/**
 * Visuals - Industrial Visualization Framework for JavaScript
 *
 * Copyright © 2012-2022 Smart HMI GmbH
 *
 * All rights reserved
 *
 * No part of this website or any of its contents may be reproduced, copied, modified or
 * adapted, without the prior written permission of Smart HMI.
 *
 * Commercial use and distribution of the contents of the website is not allowed without
 * express and prior written permission of Smart HMI.
 *
 *
 * Web: http://www.smart-hmi.de
 *
 * @version 2.11.2 416ad2f.26616 20-04-2022 07:31:54
 */

var shmi=shmi||{};shmi.visuals=shmi.visuals||{},shmi.visuals.Version="2.11.2",shmi.visuals.BuildDate="20-04-2022 07:31:54",shmi.visuals.Build="26616",shmi.visuals.Revision="416ad2f",console.log("Smart HMI visuals Version 2.11.2 416ad2f.26616 built at 20-04-2022 07:31:54"),shmi.pkg=function(e){for(var t=e.split("."),i=null,s=0,n=shmi;s<t.length;){var r=t[s];0!==s||"shmi"!==r?(n[r]=n[r]||{},n=n[r],s===t.length-1&&(i=n),s++):t.splice(0,1)}return i},shmi.requires=function(e){for(var t=e.split("."),i=null,s=0,n=shmi;s<t.length;){var r=t[s];if(0!==s||"shmi"!==r){if(void 0===n[r])throw new Error("Package not available: "+e);n=n[r],s===t.length-1&&(i=n),s++}else t.splice(0,1)}return i},shmi.c=function(e,t){if(shmi.Constants=shmi.Constants||{},void 0!==t){if(void 0!==shmi.Constants[e])throw Error("ERROR: constant '"+e+"' already defined");shmi.Constants[e]=t}return shmi.Constants[e]},shmi.log=function(e,t){let i=shmi.pkg("visuals.session");if("number"==typeof t){let s=i.config&&"number"==typeof i.config.loglevel?i.config.loglevel:2,n=i.config&&"number"==typeof i.config.alertlevel?i.config.alertlevel:Number.POSITIVE_INFINITY;if((t=null==t?2:parseInt(t))<s)return;t<n?console.log(e):console.error(e)}else"object"==typeof t?i.config&&i.config.debug&&console.log(shmi.evalString(e,t)):i.config&&i.config.debug&&console.log(shmi.evalString(e,{}))},shmi.getUiElements=function(e,t){return t||(t=document.body),t.querySelectorAll("[data-ui="+e+"]")},shmi.getUiElement=function(e,t){t||(t=document.body);var i=null;try{i=t.querySelector("[data-ui="+e+"]")}catch(e){shmi.log("[Helpers] getUiElement - Exception: "+e+" element: "+t,3)}return i},shmi.testParentChild=function(e,t){return e===t||!!t&&(t.parentNode===e||t.parentNode!==document.body&&shmi.testParentChild(e,t.parentNode))},shmi.isVisible=function(e){return e.offsetHeight>0||e.offsetWidth>0},shmi.localize=function(e){return void 0===shmi.visuals.session.locale?(console.log("[Helpers] locale not loaded yet",2),e):function localizeText(e,t){const i=e;if(!/\${(.+?)}/g.test(e))return e;const s=/\${(.+?)}/g;let n=s.exec(i);for(;n;){const[r,o]=n;let a=shmi.visuals.session.locale[o];t.includes(o)||void 0===a?t.includes(o)&&(e=e.replace(r,`[LOCALE_LOOP: ${[...t,o].join(", ")}]`)):(/\${(.+?)}/g.test(a)&&(a=localizeText(a,[...t,o])),e=e.replace(r,a)),n=s.exec(i)}return e}(e,[])},shmi.ctrl=function(e,t){const i=shmi.requires("visuals.tools.iterate").iterateObject,s=shmi.visuals.session,{HANDLE_PREFIX:n,getNodeElement:r}=shmi.requires("visuals.tools.nodes");let o=null;if("string"==typeof e&&e.startsWith(n)){const t=r(e.replace(n,""));return t?shmi.getControlByElement(t):null}if(t&&t.getName()&&0===e.indexOf(".")){let n=1;const r=e;for(;"."===e.charAt(n);)n++;const a=t.getName().split(".").slice(0,-n),l=".".repeat(n);e=e.replace(l,"");const u=s.names[a.join(".")]?s.names[a.join(".")].ctrl:null;u?i(s.names,(function(t,i){if(null===o&&0===i.indexOf(u.getName())){const t=i.indexOf(e);-1!==t&&t===i.length-e.length&&(o=s.names[i].ctrl)}})):o=shmi.ctrl(r)}else{const t=e.split(" .");let n,r=null;if(t.length>2)o=shmi.ctrl(t[0]+" ."+t[1]),o&&(t.splice(0,2),o=shmi.ctrl(o.getName()+" ."+t.join(" .")));else{if(0===t[0].indexOf(".")?(t[0]=t[0].substr(1),i(s.names,(function(e,i){null===r&&function matchesNameParts(e,t){var i=e.split("."),s=t.split("."),n=null,r=!0;return!(i.length<s.length)&&(i.splice(0,i.length-s.length),s.forEach((function(e,t){var s=i.indexOf(e);-1===s?r=!1:null!==n&&n!==s-1?r=!1:n=s})),r)}(i,t[0])&&(r=shmi.visuals.session.names[i].ctrl)}))):r=shmi.visuals.session.names[t[0]]?shmi.visuals.session.names[t[0]].ctrl:null,2===t.length){n=t[1].split(".");for(let e=0;e<n.length;e++)r=shmi.getControlByName(n[e],null,r)}o=r||null}}return o},shmi.getControlByName=function(e,t,i){var s,n=null;function isContainer(e){return e&&e.isContainer&&Array.isArray(e.controls)}function hasViews(e){return e&&e.isContainer&&Array.isArray(e.views)}function findInViews(e){for(var t=null,i=0;i<e.views.length&&null===(t=findInContainer(e.views[i]));i++);return t}function findInContainer(t){var i=null;if(Array.isArray(t.controls))for(var s=0;s<t.controls.length;s++)if(t.controls[s].getName()){var n=t.controls[s].getName();if(null==n)return null;var r=t.controls[s].getName().split(".");if(r[r.length-1]===e&&(i=t.controls[s]),null===i&&(hasViews(t.controls[s])?i=findInViews(t.controls[s]):isContainer(t.controls[s])&&(i=findInContainer(t.controls[s]))),null!==i)break}return i}if(!0===shmi.visuals.session.config.lookup_debug&&(s=Date.now()),hasViews(i))n=findInViews(i);else if(isContainer(i))n=findInContainer(i);else{var r=shmi.visuals.session.names;void 0!==r[e]&&(n=r[e].ctrl)}return!0===shmi.visuals.session.config.lookup_debug&&console.log("[Lookup] Control lookup for",n,"took",Date.now()-s,"ms"),n},shmi.getElementByName=function(e,t){return t||(t=document),t.querySelector('[data-name="'+e+'"]')},shmi.getElementsByAttribute=function(e,t,i){return i||(i=document.body),i.querySelectorAll("["+e+'="'+t+'"]')},shmi.isRegistered=function(e,t){if(!shmi.visuals.session.Layout[t])return!1;for(var i=0;i<shmi.visuals.session.Layout[t].length;i++)if(shmi.visuals.session.Layout[t][i].element===e)return!0;return!1},shmi.addClass=function(e,t){t.split(" ").forEach((function(t){e.classList.add(t)}))},shmi.hasClass=function(e,t){if(null!=e){if(e.classList)return e.classList.contains(t);if(e.getAttribute("class")){for(var i=e.getAttribute("class").split(" "),s=0;s<i.length;s++)if(i[s].trim()===t)return!0;return!1}return!1}return!1},shmi.removeClass=function(e,t){t.split(" ").forEach((function(t){e.classList.remove(t)}))},shmi.setSvgContent=function(e,t){var i=new DOMParser;i.async=!1;for(var s="<svg xmlns='http://www.w3.org/2000/svg'>"+t+"</svg>",n=0,r=i.parseFromString(s,"text/xml").documentElement.firstChild;r;)e.appendChild(e.ownerDocument.importNode(r,!0)),n++,r=r.nextSibling;shmi.log("[Helpers] added svg content ("+n+" elements)",0)},shmi.getParentGroup=function getParentGroup(e){for(var t=e.element.parentNode,i=null;t&&"group"!==t.getAttribute("data-ui");)t=t===document.body?null:t.parentNode;return t&&(i=shmi.getControlByElement(t)),i},shmi.loadGroupConfig=function(e){var t=shmi.getParentGroup(e),i=shmi.requires("visuals.session"),s=shmi.requires("visuals.tools.iterate").iterateObject;if(t)if("group"!==t.element.getAttribute("data-ui"))shmi.log("[Helpers] loadGroupConfig - Parent container is no group",1);else{let n=e.element.getAttribute("data-group-config"),r=t.getConfig(),o=r.groupId||null,a=o&&i.groupConfig[o]||null,l=shmi.requires("visuals.tools.objectHelpers").setByPath;if(r[n]&&s(r[n],(t,i)=>{null!==t&&""!==t&&(e.config[i]=t)}),a&&Array.isArray(a.snippets)){let t={};a.replacers&&a.replacers.forEach(e=>{t[e.id]=e.default}),r.replacers&&s(r.replacers,(e,i)=>{t[i]=e}),a.snippets.forEach(i=>{if(i.dest===n)try{let n=JSON.parse(shmi.evalString(i.data,t));if(null===i.path){if(null===n||"object"!=typeof n)throw new TypeError("Snippet must be an object when applied to base config!");s(n,(t,i)=>{e.config[i]=t})}else l(i.path,e.config,n)}catch(e){console.error("[shmi.loadGroupConfig] error parsing snippet:",e)}})}}else shmi.log("[Helpers] loadGroupConfig - Parent container not found",1)},shmi.registerControlType=function(e,t,i){if(void 0!==shmi.visuals.session.Layout[e])console.debug("[Parser] control identifier '"+e+"' already defined, skipping");else try{shmi.visuals.session.Layout=shmi.visuals.session.Layout||{},shmi.visuals.session.Layout[e]=new Array,shmi.visuals.session.ParserState.controlTypes.push([e,t]),i&&shmi.visuals.session.ParserState.containerTypes.push(e),console.debug("[Parser] adding control type '"+e+"', is container:"+i)}catch(e){shmi.log("[Parser] exception adding control: "+e,3)}},function(){var e=["startup","init","loadTemplate","applyTemplate","loadConfig","applyConfig","enable","disable","lock","unlock","parseAttributes","getParent","getName","isActive","isInitialized","isDeleted","getChildren","parseChildren","listen","unlisten"];shmi.extend=function(t,i){for(var s in i.prototype)if(void 0===t.prototype[s])t.prototype[s]=i.prototype[s];else if(Array.isArray(i.prototype[s])&&Array.isArray(t.prototype[s]))for(var n=0;n<i.prototype[s].length;n++)t.prototype[s].push(i.prototype[s][n]);else-1!==e.indexOf(s)&&console.warn("[shmi.extend] BaseControl method '%s' was replaced with custom implementation. This might lead to errors.",s)}}(),function(){const e={access:["read","write"],data_type:null,digits:0,item_alias:null,label:null,max:null,min:null,prewarn:null,step:0,unit:null,value_type:"string",warn:null},t=["string","bool","int","float"];function noop(){}function getItemProperties(i){const s=Object.create(e);if("string"!=typeof i.name)throw new TypeError("invalid 'name' parameter");return s.item_alias=i.name,Array.isArray(i.access)&&i.access.every(e=>"string"==typeof e)&&(s.access=i.access),"number"==typeof i.type&&t[i.type]&&(s.value_type=t[i.type]),"number"==typeof i.min&&(s.min=i.min),"number"==typeof i.max&&(s.max=i.max),"number"==typeof i.step&&(s.step=i.step),"number"==typeof i.digits&&(s.digits=i.digits),"string"==typeof i.label&&(s.label=i.label),"string"!=typeof i.unit&&"number"!=typeof i.unit||(s.unit=i.unit),i.warn&&"object"==typeof i.warn&&(s.warn={min:"number"==typeof i.warn.min?i.warn.min:null,max:"number"==typeof i.warn.max?i.warn.max:null}),i.prewarn&&"object"==typeof i.prewarn&&(s.prewarn={min:"number"==typeof i.prewarn.min?i.prewarn.min:null,max:"number"==typeof i.prewarn.max?i.prewarn.max:null}),s}shmi.createVirtualItem=function(e,t,i,s,n,r){const o={},a=shmi.visuals.session.ItemManager,l=shmi.requires("visuals.tools.iterate.iterateObject");let u=null;e&&"object"==typeof e&&arguments.length<=2?(u=e,r="function"==typeof t?t:null):u={name:e,type:t,min:i,max:s,value:n},o.setValue=noop,o.setProperties=noop,o.lock=noop,o.unlock=noop;const c=a.getItem(u.name),h=[];c&&("function"==typeof c.onDelete&&c.onDelete(),l(c._updateTargets,(function(e,t){h.push({ut:e,sid:t})})),a.removeItem(u.name)),a._createItem(u.name);const m=a.getItem(u.name);return h.forEach((function(e){m._updateTargets[e.sid]=e.ut})),r?(o.sID=a.subscribeItem(u.name,o),m.onDelete=function(){o.sID.unlisten()},o.setValue=r):m.onDelete=noop,m.value=u.value,a.setProperties(getItemProperties(u)),m.valueSet=!0,m.notifyUpdateTargets(),shmi.log("[Helpers] created virtual item '"+u.name+"'",1),m}}(),shmi.def=function(e,t,i){void 0===e[t]&&(e[t]=i)},shmi.notify=function(e,t,i){if(0===shmi.fire("notification",{message:e,title:t,param:i},shmi)){var s=shmi.evalString(shmi.localize(t),i),n=shmi.evalString(shmi.localize(e),i);alert(s+"\n"+n)}},shmi.confirm=function(e,t,i,s){i=i||"${V_CONFIRM_TITLE}",s=s||{},0===shmi.fire("confirmation",{message:e,callback:t,title:i,param:s},shmi)&&shmi.decouple((function(){t(confirm(shmi.evalString(shmi.localize(i),s)+"\n"+shmi.evalString(shmi.localize(e),s)))}))},shmi.optionDialog=function(e){var t=[],i=["option","success","warning","cancel"],s="object"==typeof e,n=s&&e.title&&e.title.length>0,r=s&&e.message&&e.message.length>0,o=s&&Array.isArray(e.buttons)&&e.buttons.every((function(e){var s="object"==typeof e;s&&(e.type=e.type||"option");var n=s&&e.type.length>0&&-1!==i.indexOf(e.type),r=s&&"function"==typeof e.callback,o=s&&"object"==typeof e.config&&e.config.name&&e.config.label;return!!(n&&r&&o)||(t.push({invalidButtonObj:e,isButtonObj:s,hasValidType:Boolean(n),hasValidCallback:Boolean(r),hasValidConfig:Boolean(o)}),!1)}));if(!(n&&r&&o)){shmi.log("[shmi.optionDialog] Invalid option dialog configuration provided:",3);var a={isDialogObj:s,isTitleValid:n,isMessageValid:r};return o?a.hasValidButtons=o:a.hasInvalidButtons=t,console.log(a),!1}e.buttonLayout=e.buttonLayout||"horizontal";var l=shmi.fire("optionDialog",e,shmi);return l||(shmi.log("[shmi.optionDialog] No optionDialog listener triggered",3),!1)},shmi.askSave=function(e,t){var i=shmi.ctrl(".ask-save-dialog");if(null===i){var s=shmi.requires("visuals.session.SysControlConfig.askSaveDialog");(i=shmi.createControl("dialog-box",document.body,s,"DIV")).enable()}else document.body.appendChild(i.element);setTimeout((function checkDialog(){if(i.active){if(!i.hidden)return void setTimeout((function retry(){shmi.askSave(e,t)}),shmi.c("ACTION_RETRY_TIMEOUT"));var s=shmi.getElementByName("ask-save-text",i.element);shmi.visuals.session.AskSaves=shmi.visuals.session.AskSaves||{};for(var n=shmi.visuals.session.AskSaves,r=Date.now();void 0!==n[r];)r++;n[r]=t;var o,a=shmi.ctrl(i.getName()+".save-button");a&&((o=[]).push("ask-save:"+r+":SAVE"),o.push("dialog:.ask-save-dialog:hide"),a.action=new shmi.visuals.core.UiAction(o,a));var l=shmi.ctrl(i.getName()+".no-save-button");l&&((o=[]).push("ask-save:"+r+":NOSAVE"),o.push("dialog:.ask-save-dialog:hide"),l.action=new shmi.visuals.core.UiAction(o,l));var u=shmi.ctrl(i.getName()+".cancel-button");u&&((o=[]).push("ask-save:"+r+":CANCEL"),o.push("dialog:.ask-save-dialog:hide"),u.action=new shmi.visuals.core.UiAction(o,u)),s&&(s.textContent=shmi.localize(e)),i.show()}else setTimeout(checkDialog,shmi.c("ACTION_RETRY_TIMEOUT"))}),shmi.c("ACTION_RETRY_TIMEOUT"))},shmi.chooseFile=function(e,t,i,s,n){shmi.requires("visuals.controls.Button"),shmi.requires("visuals.controls.DialogBox"),shmi.requires("visuals.controls.FileChooser");var r,o=shmi.requires("visuals.session.SysControlConfig.chooseFileDialog"),a=null;void 0!==n&&(o.template=n);var cancel_func=function(){r.hide(),shmi.deleteControl(r,!0),i(null)},ok_func=function(){r.hide();var e=null;null!==a&&(e=a.getValue()),shmi.deleteControl(r,!0),i(e)};r=shmi.createControl("dialog-box",document.body,o,"DIV"),shmi.waitOnInit(r,(function(){r.enable();var i=r.element.querySelector("[data-function*=ok]"),n=r.element.querySelector("[data-function*=cancel]"),l=r.element.querySelector("[data-function*=choose-file]");if(!(i&&n&&l))throw new Error("FileChooser-dialog template '"+o.template+"' does not contain all required elements");var u=shmi.getControlByElement(i),c=shmi.getControlByElement(n);if(a=shmi.getControlByElement(l),!(u&&c&&a))throw new Error("FileChooser-dialog template '"+o.template+"' does not contain all required controls");a.setExtensions(t),void 0!==s&&a.setTopLevel(s),a.setValue(e),u.onClick=ok_func,c.onClick=cancel_func,r.show()}))},shmi.multiQuery=function(e,t){for(var i={},s=0;s<e.length;s++)!function(s){var n={},r=shmi.requires("visuals.tools.iterate.iterateObject");n.id=shmi.visuals.session.QueryManager.queryDirect((function(s,o){if(n.status=s,n.query=o,Object.keys(i).length===e.length){var a=0;r(i,(function(e,t){void 0!==i[t].status&&a++})),a===Object.keys(i).length&&t(i)}}),e[s][0],e[s][1],e[s][2],e[s][3]),i[s]=n}(s)},function(){function altLoad(e,t){var i=shmi.requires("visuals.tools.iterate.iterateObject"),s=shmi.cloneObject(e),n=shmi.cloneObject(e);i(e,(function(e,i){s[i]={url:e,ready:!1,data:null,callback:function(e,r,o){n[i]=r?null:e,s[i].ready=!0,function checkReady(e){var t=shmi.requires("visuals.tools.iterate.iterateObject"),i=!0;return t(e,(function(e,t){e.ready||(i=!1)})),i}(s)&&t(n)}}})),i(s,(function(e,t){shmi.loadResource(e.url,e.callback)}))}shmi.multiLoad=function(e,t,i,s){if(Array.isArray(e)||"object"!=typeof e){var n,r=[];for(n=0;n<e.length;n++)r.push(null);for(r.counter=0,n=0;n<e.length;n++)!function(n){var o={};o.url=e[n],r[n]=o,shmi.loadResource(e[n],(function multiload_cb(i,s){if(o.failed=!!s,o.data=i,r.counter++,r.counter===e.length){for(var n=0,a=0;a<r.length;a++)void 0!==r[a].failed&&n++;n===r.length&&t(r)}}),i,s)}(n)}else altLoad(e,t)}}(),shmi.deleteControl=function(e,t){var i=shmi.requires("visuals.session"),s=shmi.requires("visuals.tools.controller");t=void 0===t||t,e.disable(),"function"==typeof e.onDelete&&e.onDelete(),e._init_&&Array.isArray(e._init_.tokens)&&(e._init_.tokens.forEach((function(e){e.unlisten()})),e._init_.tokens=[]);var n=e.getName();i&&i.config&&i.config.debug&&!n&&console.debug("[shmi.deleteControl] deleting uninitialized control"),e.parentContainer&&e.parentContainer.controls.forEach((function(t,i){t===e&&e.parentContainer.controls.splice(i,1)}));for(var r=0;r<i.Layout[e.uiType].length;r++)if(i.Layout[e.uiType][r].element===e.element){if(Array.isArray(i.Layout[e.uiType][r].controls))for(;i.Layout[e.uiType][r].controls.length;)shmi.deleteControl(i.Layout[e.uiType][r].controls[0],t);i.Layout[e.uiType][r].disable(),delete i.names[i.Layout[e.uiType][r].getName()],i.Layout[e.uiType].splice(r,1),!0===t&&e.element.parentNode&&e.element.parentNode.removeChild(e.element);break}e.deleted=!0,e.parentContainer=null,s.removeAll(n),e.fire("delete",{name:n}),shmi.fire("delete-control",{name:n},i)},shmi.createControl=function(e,t,i,s,n,r){var o=null;o=void 0!==s?s:"DIV",void 0===r&&(r=!0);var a=shmi.visuals.parser.getDefaultConfig(e),l=shmi.requires("visuals.tools.iterate.iterateObject");i=i||{},l(a,(function(e,t){shmi.def(i,t,e)}));var u=document.createElement(o);if(u.setAttribute("data-ui",e),i&&i.name&&u.setAttribute("data-name",i.name),"before"===n)t.parentNode.insertBefore(u,t);else if("after"===n)t.parentNode.insertBefore(u,t.nextSibling);else if("from"===n){if(null!==shmi.getControlByElement(t))throw new Error("element already contains a control");u=t}else!function appendFormat(e,t,i){t.hasChildNodes()&&3===t.lastChild.nodeType&&/^\s*[\r\n]\s*$/.test(t.lastChild.textContent)?(t.insertBefore(document.createTextNode("\n"+e),t.lastChild),t.insertBefore(i,t.lastChild)):(t.appendChild(document.createTextNode("\n"+e)),t.appendChild(i),t.appendChild(document.createTextNode("\n"+e.slice(0,-4))))}("    ",t,u);for(var c=-1,h=shmi.visuals.session.ParserState,m=0;m<h.controlTypes.length;m++)if(h.controlTypes[m][0]===e){c=m;break}var d=null;if(-1!==c){(d="panel"===e?new h.controlTypes[c][1](u,!1,i):new h.controlTypes[c][1](u,i)).uiType=e;var f=shmi.getParentContainerElement(d.element);d.parentContainer=null===f?null:shmi.getControlByElement(f),null!==d.getParent()?(d.getParent().controls.push(d),r&&!0===d.getParent().isActive()&&d.enable()):r&&d.enable(),shmi.visuals.session.Layout[e].push(d),d.fire("register",{})}else shmi.log("[createControl] control type '"+e+"' not available",2);return d},shmi.waitOnInit=function(e,t,i){var s=!1,n=i||{tokens:[],cancel:function(){this.tokens.forEach((function(e){e.unlisten()})),this.tokens=[]},unlisten:function(){this.cancel()}};if(Array.isArray(e)){var r,o=0;for(r=0;r<e.length;r++)!0===e[r].initialized&&o++;o===e.length&&(s=!0)}else!0===e.initialized&&(s=!0);if(!0===s)t(e);else if(Array.isArray(e))e.forEach((function(i){if(!i.initialized){var s=i.listen("init",(function(i){n.tokens.forEach((function(e){e.unlisten()})),n.tokens=[],shmi.waitOnInit(e,t,n)}));n.tokens.push(s)}}));else if(!e.initialized){var a=e.listen("init",(function(i){n.tokens.forEach((function(e){e.unlisten()})),n.tokens=[],shmi.waitOnInit(e,t,n)}));n.tokens.push(a)}return n.tokens.length?n:null},function(){function checkDomInsertion(e,t){(function getRoot(e){return null===e.parentNode?null:e.parentNode===document.body?document.body:getRoot(e.parentNode)})(e)!==document.body?setTimeout((function(){checkDomInsertion(e,t)}),100):t()}function addToParent(e){if(null!==e.parentContainer&&(e.parentContainer.controls.push(e),!0===e.parentContainer.active))var t=e.listen("init",(function(i){e.unlisten("init",t),!0===e.parentContainer.active&&e.enable()}))}shmi.registerName=function(e,t){var i=shmi.visuals.session;i.names=i.names||{};var s=i.names;if(t&&-1!==t.indexOf(".")){var n=t.split(".");t=n[n.length-1]}var r=!!t,o=r?t:e.getClassName().toLowerCase()||e.uiType||"UNDEFINED",a="";if(shmi.isRegistered(e.element,e.uiType))checkDomInsertion(e.element,(function(){if(null===e.parentContainer){var t=shmi.getParentContainerElement(e.element);e.parentContainer=null===t?null:shmi.getControlByElement(t),addToParent(e)}null!==e.parentContainer&&void 0!==e.parentContainer&&(a=e.parentContainer.getName(),o=a+"."+o);var i=1,n="";if(r)if(void 0===s[o])n=o;else{for(;void 0!==s[o+shmi.c("NAME_SUFFIX")+i];)i++;n=o+shmi.c("NAME_SUFFIX")+i}else{for(;void 0!==s[o+shmi.c("NAME_SUFFIX")+i];)i++;n=o+shmi.c("NAME_SUFFIX")+i}s[n]={},s[n].ctrl=e,e.fire("register-name",{name:n})}));else var l=e.listen("register",(function(){e.unlisten("register",l),checkDomInsertion(e.element,(function(){if(null===e.parentContainer){var t=shmi.getParentContainerElement(e.element);e.parentContainer=null===t?null:shmi.getControlByElement(t),addToParent(e)}null!==e.parentContainer&&(a=e.parentContainer.getName(),o=a+"."+o);var i=1,n="";if(r)if(void 0===s[o])n=o;else{for(;void 0!==s[o+shmi.c("NAME_SUFFIX")+i];)i++;n=o+shmi.c("NAME_SUFFIX")+i}else{for(;void 0!==s[o+shmi.c("NAME_SUFFIX")+i];)i++;n=o+shmi.c("NAME_SUFFIX")+i}s[n]={},s[n].ctrl=e,e.fire("register-name",{name:n})}))}));return t}}(),shmi.toBoolean=function(e){var t=!1;if("boolean"==typeof e||e instanceof Boolean)t=e;else if("string"==typeof e||e instanceof String){var i=e.trim().toLowerCase();"true"!==i&&"false"!==i||(t="true"===i)}else shmi.log("[toBoolean] expr ist not a boolean expression, expr: "+e,2);return t},shmi.toNumber=function(e){var t=0;return isNaN(e)?(shmi.log("[toNumber] expr ist not a number expression, expr: "+e,2),t=Number.NaN):t=Number(e),t},shmi.cloneObject=function(e){if(void 0!==e)return JSON.parse(JSON.stringify(e))},shmi.bindItems=function(e,t){var i=shmi.visuals.session,s=i.ItemManager;i.bindings=i.bindings||{};for(var n=1;void 0!==i.bindings[n];)n++;i.bindings[n]={id:n,item1:e,item2:t};var r,o,noop=function(){},a={setProperties:noop,lock:noop,unlock:noop},l={setProperties:noop,lock:noop,unlock:noop},u=!1;return a.setValue=function(e){s.items[t].valueSet&&s.writeValue(t,e)},l.setValue=function(i){u?s.writeValue(e,i):s.items[e].valueSet&&(s.writeValue(t,s.items[e].value),u=!0)},r=s.subscribeItem(e,a),o=s.subscribeItem(t,l),i.bindings[n].item1_sid=r,i.bindings[n].item2_sid=o,n},shmi.unbindItems=function(e){var t,i=!1,s=shmi.visuals.session,n=s.ItemManager;return s.bindings=s.bindings||{},void 0!==s.bindings[e]&&(t=s.bindings[e],n.unsubscribeItem(t.item1,t.item1_sid),n.unsubscribeItem(t.item2,t.item2_sid),delete s.bindings[e],i=!0),i},shmi.getControlByElement=function(e){var t=e.getAttribute("data-ui"),i=shmi.visuals.session,s=null;if(null!==t){if(!Array.isArray(i.Layout[t]))throw new Error("[shmi.getControlByElement] control type '"+t+"' not defined");for(var n=i.Layout[t],r=0;r<n.length;r++)if(n[r].element===e){s=n[r];break}}else{var o=shmi.requires("visuals.tools.iterate.iterateObject");console.debug("[shmi.getControlByName] data-ui attribute missing, checking all ui-types..."),o(i.Layout,(function(t,i){t.forEach((function(t){t.element===e&&(s=t)}))}))}return s},shmi.getFullName=function(e){return e.getName()},shmi.listen=function(e,t,i){var s=shmi.pkg("visuals.session");s.Events=s.Events||{},s.Events[e]=s.Events[e]||{};for(var n=s.Events[e],r=0;void 0!==n[r];)r++;n[r]=null!==i&&"object"==typeof i?function(e){let s=!1;return Object.keys(i).some(t=>{let n=t.split("."),r=null;for(;n.length;){let t=n.shift();if(r=null===r?e[t]:r[t],void 0===r)break}return void 0!==r&&r===i[t]?(s=!0,!1):(s=!1,!0)}),!0===s&&t(e),s}:function(e){return t(e),!0};var o={name:e,listenerId:r,unlisten:(null,function(){shmi.unlisten(o)})};return o},shmi.unlisten=function(e,t){var i,s=shmi.visuals.session;if("object"==typeof e&&1===arguments.length){if(void 0===(i=s.Events[e.name]))throw Error("ERROR: undefined event type '"+e.name+"'");if(void 0===i[e.listenerId])throw Error("ERROR: listener id "+e.listenerId+" not registered for event type '"+e.name+"'");delete i[e.listenerId]}else{if(void 0===(i=s.Events[e]))throw Error("ERROR: undefined event type '"+e+"'");if(void 0===i[t.listenerId])throw Error("ERROR: listener id "+t.listenerId+" not registered for event type '"+e+"'");delete i[t.listenerId]}},shmi.getParentContainer=function(e){if(null===(e=e.parentNode))return shmi.log("[Helpers] element is body",1),null;if(e===document.body)return shmi.log("[Helpers] element is body",1),null;for(;!shmi.isContainer(e);){if(null==e)return shmi.log("[Helpers] getParentContainer - provided element NULL",1),null;if((e=e.parentNode)===document.body)return shmi.log("[Helpers] some parent of element is body",1),null}for(var t=e.getAttribute("data-ui"),i=0;i<shmi.visuals.session.Layout[t].length;i++)if(shmi.visuals.session.Layout[t][i].element===e)return shmi.visuals.session.Layout[t][i];return shmi.log("[Helper] parent not found in layouts("+shmi.visuals.session.Layout[t].length+"), type: "+t,1),null},shmi.getParentContainerElement=function(e){if((e=e.parentNode)===document.body)return shmi.log("[Helpers] element is body",1),null;if(null===e)return shmi.log("[Helpers] parent node is null or undefined",1),null;for(;!shmi.isContainer(e);){if(null===e)return shmi.log("[Helpers] parent node is null or undefined",1),null;if((e=e.parentNode)===document.body)return shmi.log("[Helpers] some parent of element is body",1),null;if(e===document.documentElement)return shmi.log("[Helpers] some parent of element is body",1),null}return e},shmi.isContainer=function(e){if(e instanceof HTMLElement)for(var t=e.getAttribute("data-ui"),i=0;i<shmi.visuals.session.ParserState.containerTypes.length;i++)if(shmi.visuals.session.ParserState.containerTypes[i]===t)return!0;return!1},function(){function getEnableCallback(e,t,i,s){return function(n){e[t]=n;var r=shmi.requires("visuals.tools.iterate.iterateObject"),o=!0,a=0;r(e,(function(t,i){!0!==e[i].active?o=!1:a++})),o&&a===i&&s(e)}}shmi.onEnable=function(e,t){const i={},{HANDLE_PREFIX:s,getNodeHandle:n}=shmi.requires("visuals.tools.nodes");if(Array.isArray(e))for(let s=0;s<e.length;s++)shmi.onEnable(e[s],getEnableCallback(i,e[s],e.length,t));else{let i,r=shmi.ctrl(e);if(r&&r.active)t(r);else if(e.startsWith(s)){const r=e.replace(s,"");i=shmi.listen("enable",(function(e){if(!e.source||!e.source.element||!e.source.element.getAttribute("_nodeid"))return;n(e.source)===r&&(shmi.unlisten("enable",i),t(e.source))}))}else i=shmi.listen("enable",(function(s){let n,o;if(s.detail.name){n=e.split(" ."),o=0;for(let e=0;e<n.length;e++)-1===s.detail.name.indexOf(n[e])&&o++,e===n.length-1&&s.detail.name.indexOf(n[e])!==s.detail.name.length-n[e].length&&o++;0===o&&(r=shmi.ctrl(e),r&&(shmi.unlisten("enable",i),t(r)))}}))}}}(),shmi.onDisable=function(e,t){if(!e||!Array.isArray(e.events)||-1===e.events.indexOf("disable"))throw new Error("ERROR: 'disable' event not supported");if(!1===e.active)t(e);else var i=e.listen("disable",(function eventHandler(s){e.unlisten("disable",i),t(e)}))},shmi.to_utf8=function(e){return shmi.visuals.session.FileManager.to_utf8(e)},shmi.from_utf8=function(e){return shmi.visuals.session.FileManager.from_utf8(e)},shmi.objectHasOwnProperty=Object.prototype.hasOwnProperty.call.bind(Object.prototype.hasOwnProperty),shmi.onVisible=function(e,t){var i=0;arguments[2]&&(i=arguments[2]),e.offsetWidth>0||e.offsetHeight>0?(shmi.visuals.session.config.debug&&console.log("[shmi.onVisible] element visible",e),t()):(i>500&&(shmi.visuals.session.config.debug&&console.log("[shmi.onVisible] waiting for a long time to become visible...",e),i=0),setTimeout((function(){shmi.onVisible(e,t,i+1)}),shmi.c("ACTION_RETRY_TIMEOUT")))},shmi.getAbsPosition=function(e){for(var t=0,i=0,s=e.getBoundingClientRect();e;)t+=e.scrollLeft,i+=e.scrollTop,e=e.offsetParent;return{x:s.left+t,y:s.top+i}},shmi.evalString=function(in_text,dyn_content){var session=shmi.visuals.session,im=session.ItemManager,locale=session.locale;function MAP(value,mapObj){var localeString=null,localeObj=null;if("string"==typeof mapObj&&(localeString=locale[mapObj],localeString)){try{eval("localeObj = "+localeString)}catch(e){return console.error("[shmi.evalString]","failed to parse enumeration object from locale-variable:",mapObj),"INVALID_ENUM"}mapObj=localeObj}return mapObj[value]?shmi.localize(mapObj[value]):"UNKNOWN"}function DATE(e,t,i){return shmi.requires("visuals.tools.date").formatDateTime(e,{datestring:t||null,utc:!!i})}function ITEM(e){return im.readValue(e)}function LOC(e){return locale[e]}function processMarkers(e,t){let i=Object.keys(e);return t=t.trim(),i.sort((e,t)=>e.length-t.length),i.reverse(),i.forEach(e=>{let i=new RegExp(`(?!_\\$_\\.)\\b${escapeRegExp(e)}\\b`,"g");t=t.replace(i,"_$_."+e)}),t}function replace_dyn_markers(in_data,_$_){var matches=in_data.match(/<%=(.*?)%>/g),t_re=null;matches=null===matches?[]:matches,matches.sort((e,t)=>e.length-t.length),matches.reverse();for(var i=0;i<matches.length;i++){var cur_match=matches[i].match(/<%=(.*?)%>/);if(cur_match[1]){"object"!=typeof _$_&&(_$_={});var content=null;try{content=eval(processMarkers(_$_,cur_match[1])),t_re=new RegExp(escapeRegExp(cur_match[0]),"g"),in_data=in_data.replace(t_re,content)}catch(e){content="ERROR"}}}return in_data}function escapeRegExp(e){return e.replace(/[-[\]{}()*+?.\\^$|]/g,"\\$&")}return replace_dyn_markers(in_text,dyn_content)},function(){var e=null,t=null,i=shmi.c("SERVER_TIME_ITEM"),s=shmi.c("ALT_SERVER_TIME_ITEM");shmi.getServerTime=function(){var n=Date.now()/1e3,r=shmi.requires("visuals.session.ItemManager");if(r.getItem(i)?t=r.readValue(i):r.getItem(s)&&(t=r.readValue(s)),null!==t){var o=n-parseInt(t);return n-(e=null===e||isNaN(e)?o:.7*e+.3*o)}return n}}(),function(){function callComplete(e){return e.ready===e.total}shmi.onReady=function(e,t){var i={ready:0,total:0,numItems:0,numControls:0,numResources:0},s=shmi.requires("visuals.session.ItemManager"),n=shmi.requires("visuals.tools.iterate.iterateObject"),r=shmi.cloneObject(e);return"object"==typeof r.items&&n(r.items,(function(){i.numItems+=1,i.total+=1})),"object"==typeof r.controls&&n(r.controls,(function(){i.numControls+=1,i.total+=1})),"object"==typeof r.resources&&n(r.resources,(function(){i.numResources+=1,i.total+=1})),i.numItems&&n(r.items,(function(e,n){var o=s.getItemHandler(),a=null,l=!1;o.setValue=function(){l||(l=!0,r.items[n]=s.getItem(e),i.ready+=1,shmi.visuals.session.config.debug&&console.debug("item ready: ",e),callComplete(i)&&t(r),setTimeout((function(){null!==a&&a.unlisten()}),10))},a=s.subscribeItem(e,o)})),i.numControls&&n(r.controls,(function(e,s){if("string"==typeof e)shmi.onEnable(e,(function(n){r.controls[s]=n,i.ready+=1,shmi.visuals.session.config.debug&&console.debug("control ready: ",e),callComplete(i)&&t(r)}));else if(!0===e.isActive())r.controls[s]=e,i.ready+=1,callComplete(i)&&t(r);else{var n=null;n=e.listen("enable",(function(e){n.unlisten(),r.controls[s]=e.source,i.ready+=1,callComplete(i)&&t(r)}))}})),i.numResources&&n(r.resources,(function(e,s){shmi.loadResource(e,(function(e,n){r.resources[s]={data:e,failed:n},i.ready+=1,callComplete(i)&&t(r)}))})),r}}(),shmi.getVisualsVersion=function(){var e=shmi.visuals.Version.split("-"),t=e[0].split("."),i={major:parseInt(t[0]),minor:parseInt(t[1]),patch:parseInt(t[2]),dev:void 0!==e[1]?e[1]:null,build:parseInt(shmi.visuals.Build),lessThan:function lessThan(e){if(e[0]>i.major)return!0;if(e[0]===i.major){if(e[1]>i.minor)return!0;if(e[1]===i.minor&&e[2]>i.patch)return!0}return!1},greaterThan:function greaterThan(e){if(e[0]<i.major)return!0;if(e[0]===i.major){if(e[1]<i.minor)return!0;if(e[1]===i.minor&&e[2]<i.patch)return!0}return!1}};return i},shmi.getConnectVersion=function(){var e=shmi.cloneObject(shmi.visuals.session.Host.version);return e.lessThan=function lessThan(t){if(t[0]>e.major)return!0;if(t[0]===e.major){if(t[1]>e.minor)return!0;if(t[1]===e.minor&&t[2]>e.patch)return!0}return!1},e.greaterThan=function greaterThan(t){if(t[0]<e.major)return!0;if(t[0]===e.major){if(t[1]<e.minor)return!0;if(t[1]===e.minor&&t[2]<e.patch)return!0}return!1},e},shmi.onActive=function(e,t){var i=shmi.requires("visuals.task"),s=[],n=null;e.forEach((function(e,t){var n=i.createTask("on-active control-"+t),r=null;n.run=function(){e.isActive()?shmi.decouple(n.complete):r=e.listen("enable",(function(){r.unlisten(),r=null,n.complete()}))},s.push(n)})),s.length?((n=i.createTaskList(s,!1)).onComplete=t,n.run()):shmi.decouple(t)},shmi.decouple=function decouple(e){Promise.resolve().then(e)},function(){function testWarn(e,t){if("number"==typeof e&&t&&t.warn){if("number"==typeof t.warn.min&&e<=t.warn.min)return!0;if("number"==typeof t.warn.max&&e>=t.warn.max)return!0}return!1}function testPrewarn(e,t){if("number"==typeof e&&t&&t.prewarn){if("number"==typeof t.prewarn.min&&e<=t.prewarn.min)return!0;if("number"==typeof t.prewarn.max&&e>=t.prewarn.max)return!0}return!1}function updateState(e,t,i){testWarn(t,i)?(shmi.removeClass(e,"preWarn"),shmi.addClass(e,"warn")):testPrewarn(t,i)?(shmi.removeClass(e,"warn"),shmi.addClass(e,"preWarn")):(shmi.removeClass(e,"preWarn"),shmi.removeClass(e,"warn"))}function callCallback(e,t,i){e&&(testWarn(t,i)?e("warn"):testPrewarn(t,i)?e("prewarn"):e(null))}function setOption(e,t,i){e.options=e.options||{},e.options[t[0]]=e.options[t[0]]||{},e.options[t[0]][t[1]]="number"==typeof i?i:null}shmi.createConditional=function(e,t,i){var s={enable:null,disable:null,options:null,item:t},n=shmi.requires("visuals.session.ItemManager"),r=n.getItemHandler(),o=null,a=null;return r.setValue=function setValue(t){o=t,"function"==typeof i?callCallback(i,o,s.options):updateState(e,o,s.options)},r.setProperties=function setProperties(t,n,r,a,l,u,c,h,m,d){setOption(s,["prewarn","min"],h),setOption(s,["prewarn","max"],m),setOption(s,["warn","min"],u),setOption(s,["warn","max"],c),"number"==typeof o&&("function"==typeof i?callCallback(i,o,s.options):updateState(e,o,s.options))},s.enable=function enable(){null===a&&"string"==typeof s.item&&(a=n.subscribeItem(s.item,r))},s.disable=function disable(){null!==a&&(a.unlisten(),a=null,o=null,s.options=null)},s}}(),shmi.LocalizedError=class LocalizedError extends Error{constructor(e,t){super(shmi.evalString(shmi.localize(String(e)),t))}},shmi.numpad=function(e){0===shmi.fire("numpad-request",e,shmi)&&console.log("no handler registered for 'numpad-request' event")},shmi.pkg("visuals.core"),shmi.visuals.core.Alarm=function(e){this.id=e,this.properties=null},shmi.visuals.core.Alarm.prototype={setProperties:function(e){this.properties=e},ackAlarm:function(){(0,shmi.requires("visuals.tools.connect").request)("alarm.acknowledge",[this.id],(function onRequest(e,t){t&&console.error("[Alarm] acknowledge failed:",t.category,t.errc,t.message)}))},getProperties:function(){return shmi.cloneObject(this.properties)}},function(){shmi.pkg("visuals.core");var e=[1,3,1];function notifyDelayed(e,t,i){var s=t.splice(0,500);e.subscribers[i]&&(s.forEach((function(t,n){var r=e.alarms[t];e.subscribers[i].callback(shmi.cloneObject(r.properties),n===s.length-1)})),t.length&&setTimeout(notifyDelayed.bind(null,e,t,i),shmi.c("ACTION_RETRY_TIMEOUT")))}function processAlarm(e){var t=shmi.requires("visuals.tools.numericValues");return(e=shmi.cloneObject(e)).items=(e.items||[]).concat(e.context||[]),e.context=e.items,e.items.forEach((function(e){Object.defineProperty(e,"formattedValue",{enumerable:!0,configurable:!1,get:function(){return t.formatNumber(e.value,{precision:e.digits,unit:e.unit})}})})),e}shmi.visuals.core.AlarmManager=function(){var e=this;e.alarms={},e.subscribers={},e.alarmsLoaded=!1,shmi.registerMsgHandler("alarm.notify",(function(t){e.setProperties(t.data,!0)}))},shmi.visuals.core.AlarmManager.prototype={_createAlarm:function(e){if(void 0!==this.alarms[e])shmi.log("[AlarmManager] alarm '"+e+"' already exists",0);else{var t=shmi.visuals.core;this.alarms[e]=new t.Alarm(parseInt(e))}},removeAlarm:function(e){delete this.alarms[e]},removeAll:function(){var e=this;(0,shmi.requires("visuals.tools.iterate").iterateObject)(e.subscribers,(function(t,i){delete e.subscribers[i]}))},ackAlarm:function(e){var t=shmi.requires("visuals.tools.connect").request,i=!1;return-1===e?(i=!0,t("alarm.acknowledge_all",{},(function onRequest(e,t){t&&console.error("[AlarmManager] acknowledge_all failed:",t.category,t.errc,t.message)}))):void 0!==this.alarms[e]&&(this.alarms[e].ackAlarm(),i=!0),i},subscribeAlarms:function(e,t){for(var i=Date.now(),s=this,n=s.subscribers[i],r=null;void 0!==n;)i++,n=s.subscribers[i];return s.subscribers[i]={},(n=s.subscribers[i]).control=e,n.callback=t,s.alarmsLoaded?setTimeout((function(){var e=Object.keys(s.alarms);notifyDelayed(s,e,i)}),10):r=shmi.listen("alarms-loaded",(function onAlarmsReady(){r.unlisten();var e=Object.keys(s.alarms);notifyDelayed(s,e,i)})),i},unsubscribeAlarms:function(e){delete this.subscribers[e]},setProperties:function(t,i){var s=shmi.getConnectVersion(),n=shmi.requires("visuals.tools.iterate.iterateObject");s.lessThan(e)?console.error("[AlarmManager]","alarming requires at least connect version:",e.join(".")):(this.alarms[t.id]||this._createAlarm(t.id),this.alarms[t.id].setProperties(t),this.alarmsLoaded&&n(this.subscribers,(function(e,s){e.callback(t,i)})))},requestAlarmList:function(){var e=this;e.getLiveAlarms((function onLiveAlarms(t,i){Array.isArray(i)&&(i.forEach((function(t,s){e.setProperties(t,s===i.length-1)})),e.alarmsLoaded=!0,shmi.fire("alarms-loaded",{},e))}))},getAlarm:function(e){return this.alarms[e]?this.alarms[e]:null},getLiveAlarms:function(e){(0,shmi.requires("visuals.tools.connect").request)("alarm.live",{},(function onRequest(t,i){i?(console.error("[AlarmManager] getLiveAlarms failed:",i.category,i.errc,i.message),e(i,null)):e(0,t.map(processAlarm))}))},getHistoricAlarms:function(e,t){(0,shmi.requires("visuals.tools.connect").request)("alarm.historic",t,(function onRequest(t,i){i?(console.error("[AlarmManager] getLiveAlarms failed:",i.category,i.errc,i.message),e(i,null)):(t.alarms=t.alarms.map(processAlarm),e(0,t))}))}}}(),function(){function updateAppearance(e,t,i){i?shmi.addClass(e.element,t):shmi.removeClass(e.element,t)}function ensureConfig(e){e.config=e.config||{}}function setCssClasses(e){("container"!==e.uiType&&shmi.addClass(e.element,shmi.c("CSS_CONTROL_CLASS")),e.config["class-name"])&&e.config["class-name"].split(" ").forEach((function(t){""!==t.trim()&&shmi.addClass(e.element,t)}))}function initializeControl(e){"function"==typeof e.onInit?e.onInit():console.warn("["+e.getClassName()+"] initialized - no onInit function defined"),e.config.disabled&&(e.onEnable=null,e.onDisable=null,e.lock()),e.initialized=!0,e.fire("init",{}),e.enableOnInit&&(e.enableOnInit=!1,e.enable())}function defineGetConfig(e){var t=shmi.cloneObject(e.config);delete t["config-name"],Object.defineProperty(e,"getConfig",{value:function(){return shmi.cloneObject(t)},writable:!1})}function unsubscribeOnDisable(e,t){if(e.isActive()&&t.length)var i=e.listen("disable",(function(){i.unlisten(),i=null,t.forEach((function(e){e.unlisten()})),t=[]}))}shmi.pkg("visuals.core"),shmi.visuals.core.BaseControl=function(e){shmi.log("[BaseControl] cannot be instantiated",3)},shmi.visuals.core.BaseControl.prototype={uiType:"basecontrol",events:["register","register-name","enable","disable","init","delete"],tooltipProperties:["tooltip"],isContainer:!1,getClassName:function(){return"BaseControl"},getTooltip:function(){var e=this;if(!Array.isArray(e.tooltipProperties))return null;var t=e.tooltipProperties.filter((function(t){return shmi.objectHasOwnProperty(e.config,t)&&e.config[t]}));return t.length>0?e.config[t.shift()]:null},setTooltip:function(e){shmi.checkArg("tooltip",e,"string","null"),this.element&&(e?this.element.setAttribute("title",shmi.localize(e)):this.element.removeAttribute("title"))},parseAttributes:function(){var e=this,t=shmi.requires("visuals.tools.iterate").iterateNodeList;ensureConfig(e),function checkGroupConfig(e){let t=e.element.getAttribute("data-config-name"),i=t?t.split(" "):null,s=-1;i&&(i=i.map(e=>e.trim()),i=i.filter(e=>""!==e),s=i.findIndex(e=>0===e.indexOf("@")),s>=0&&(e.element.setAttribute("data-group-config",i[s]),i.splice(s,1),e.element.setAttribute("data-config-name",i.join(" "))))}(e),t(e.element.attributes,(function(t,i){"data-group-config"!==t.nodeName&&0===t.nodeName.indexOf("data-")&&(e.config[t.nodeName.substr(5)]=t.nodeValue)}))},startup:function(){!function initHandlers(e){var t=shmi.requires("visuals.session");if(t.Events=t.Events||{},!Array.isArray(e.events))throw new TypeError("Prototype is missing array of supported event types.");e._handlers={},e.events.forEach((function(i,s){if(void 0!==e._handlers[i])throw new TypeError("Eventtype '%s' is declared more than once.");e._handlers[i]={},t.Events[i]=t.Events[i]||{}}))}(this),this.element.style.display="none",ensureConfig(this),Object.defineProperty(this,"_init_",{value:{tokens:[]},writable:!1}),this.enableOnInit=!1,this.config["config-name"]?(Array.isArray(this.config["config-name"])||(this.config["config-name"]=[this.config["config-name"]]),this.loadConfig(0)):(shmi.loadGroupConfig(this),defineGetConfig(this),this.loadTemplate())},loadConfig:function(e){var t=this;if(ensureConfig(t),t.config["config-name"]&&t.config["config-name"].length>0){var i=t.config["config-name"][e];if(0===i.indexOf(shmi.c("RES_URL_PREFIX"))){var s=null,n=t.config["config-name"][e].split("@");"/"===n[0][n[0].length-1]?((n=n[0].split("/")).pop(),s=n.join("/")):s=(n=n[0].split("/")).join("/"),shmi.loadResource(s,(function loadCfgCB(i,s,n){t.applyConfig(i,s,e,n)}))}else{var r=null;r=0===i.indexOf(":")?i.replace(":","")+shmi.c("CONFIG_EXT"):shmi.c("CONFIG_PATH")+i+shmi.c("CONFIG_EXT"),shmi.loadResource(r,(function loadCfgCB(i,s,n){t.applyConfig(i,s,e,n)}))}}else shmi.loadGroupConfig(t),defineGetConfig(t),t.loadTemplate()},applyConfig:function(e,t,i,s){var n=this,r=shmi.requires("visuals.tools.iterate").iterateObject;if(ensureConfig(n),t||"string"!=typeof e)console.warn("["+n.getClassName()+"]","config file not found - 404:",s);else{var o={};try{r(o=JSON.parse(e),(function(e,t){n.config[t]=o[t]}))}catch(e){console.error("["+n.getClassName()+"]","failed to parse configuration:",s,e)}}n.config["config-name"].length===i+1?(shmi.loadGroupConfig(n),defineGetConfig(n),n.loadTemplate()):n.loadConfig(i+1)},loadTemplate:function(){if(ensureConfig(this),this.config.template)if(0===this.config.template.indexOf(shmi.c("RES_URL_PREFIX")))shmi.loadResource(this.config.template,this.applyTemplate.bind(this));else{var e=null;e=0===this.config.template.indexOf(":")?this.config.template.replace(":","")+shmi.c("TEMPLATE_EXT"):shmi.c("TEMPLATE_PATH")+this.config.template+shmi.c("TEMPLATE_EXT"),shmi.loadResource(e,this.applyTemplate.bind(this))}else setCssClasses(this),this.init()},applyTemplate:function(e,t){if(ensureConfig(this),!this.element)throw new TypeError("["+this.getClassName()+"] control has no base element.");setCssClasses(this),"function"==typeof this.onTemplate?this.onTemplate(e,t,this.init.bind(this)):(t?console.error("["+this.getClassName()+"] Template file '"+shmi.c("TEMPLATE_PATH")+this.config.template+shmi.c("TEMPLATE_EXT")+"' not found  - 404"):this.element instanceof HTMLElement?e&&(this.element.innerHTML=e):this.element instanceof SVGElement?e&&shmi.setSvgContent(this.element,e):console.error("["+this.getClassName()+"] Error in template '"+this.config.template+"base element is neither HTMLElement nor SVGElement"),this.init())},init:function(){var e=this,t=null;e.element.style.display="",ensureConfig(e),e.setTooltip(e.getTooltip()),Array.isArray(e.config._appearances_)&&e.config._appearances_.forEach((function(t){null===t.condition&&updateAppearance(e,t.modifier,!0)})),t=e.listen("register-name",(function initNamed(i){var s=null;t.unlisten(),e._init_.tokens.splice(e._init_.tokens.indexOf(t),1),t=null,function setName(e,t){var i=t.split(".");Object.defineProperty(e,"name",{value:t,writable:!1}),e.element.setAttribute("data-name",i[i.length-1])}(e,i.detail.name),"function"==typeof e.onRegister?shmi.isRegistered(e.element,e.uiType)?e.onRegister(initializeControl.bind(null,e)):(s=e.listen("register",(function(){s.unlisten(),e._init_.tokens.splice(e._init_.tokens.indexOf(s),1),s=null,e.onRegister(initializeControl.bind(null,e))})),e._init_.tokens.push(s)):initializeControl(e)})),e._init_.tokens.push(t),shmi.registerName(e,e.config.name)},onInit:function(){},enable:function(){const e=this,t=shmi.requires("visuals.tools.controller"),{ConditionObserver:i}=shmi.requires("visuals.tools.conditions");if(e.initialized){if(!e.active){if(e.active=!0,e.onEnable&&e.onEnable(),e.fire("enable",{name:e.getName()}),Array.isArray(e.config._controllers_)&&e.config._controllers_.forEach((function(i){t.registerSlot(i.name,i.slot,e)})),Array.isArray(e.config._appearances_)){let t=[];e.config._appearances_.forEach((function(s){null!==s.condition&&("string"!=typeof s.condition.type&&(s.condition=function updateLegacyCondition(e){return{type:"condition",mode:"AND",elements:[{type:"comparison",operand1:{type:"item",value:e.item},operand2:{type:"string"==typeof e.compare?"item":"value",value:e.compare},operator:e.operator}]}}(s.condition)),t.push(new i(s.condition,t=>{updateAppearance(e,s.modifier,t)})))})),unsubscribeOnDisable(e,t)}!0===e.locked&&e.lock(),e.config._lock_&&"condition"===e.config._lock_.type&&unsubscribeOnDisable(e,[new i(e.config._lock_,t=>{t?function lockRecursive(e){e.lock(!0),Array.isArray(e.controls)&&e.controls.forEach((function(e){lockRecursive(e)}))}(e):function unlockRecursive(e){e.unlock(!0),Array.isArray(e.controls)&&e.controls.forEach((function(e){unlockRecursive(e)}))}(e)})])}}else e.enableOnInit=!0},onEnable:function(){},disable:function(){this.enableOnInit=!1,this.active&&(this.active=!1,this.onDisable&&this.onDisable(),this.fire("disable",{name:this.getName()}))},onDisable:function(){},subscribeItem:function(e){return shmi.visuals.session.ItemManager.subscribeItem(e,this)},unsubscribeItem:function(e,t){shmi.visuals.session.ItemManager.unsubscribeItem(e,t)},setValue:function(e,t,i){this.initialized?this.onSetValue&&this.onSetValue(e,t,i):console.warn("["+this.getClassName()+"] setValue - not initialized yet.")},setProperties:function(e,t,i,s,n,r,o,a,l,u){this.onSetProperties&&this.onSetProperties(e,t,i,s,n,r,o,a,l,u)},lock:function(e){void 0===this.forceLocked&&(this.forceLocked=!1),this.initialized&&"function"==typeof this.onLock&&this.onLock(),this.locked=!0,this.forceLocked=!0===e||this.forceLocked},unlock:function(e){(!this.forceLocked||this.forceLocked&&e)&&(this.initialized&&"function"==typeof this.onUnlock&&this.onUnlock(),this.locked=!1,this.forceLocked=!1)},setItem:function(e){this.onSetItem?this.onSetItem():this.active?(this.disable(),this.config.item=e,this.enable()):this.config.item=e},getItem:function(){return this.config.item?this.config.item:null},isInitialized:function(){return this.initialized},isActive:function(){return!!this.active},getName:function(){return this.name?this.name:null},fire:function(e,t,i=!1){const s=this,n=shmi.requires("visuals.tools.iterate").iterateObject;s._hasEvent(e);const r=shmi.visuals.session,o={source:s,type:e,detail:t};function fireAway(){let t=0;return n(s._handlers[e],(function(i,n){s._handlers[e][n](o),t++})),n(r.Events[e],(function(e){e(o)&&t++})),t}function logFired(e){!0===r.config.event_debug&&console.log("[",s.getClassName(),"] event",o,"fired [",e,"listeners]")}if(i)return shmi.decouple(()=>logFired(fireAway())),0;const a=fireAway();return logFired(a),a},_hasEvent:function(e){if(!Array.isArray(this.events))throw new Error("ERROR: "+this.getClassName()+" object does not support events");if(-1===this.events.indexOf(e))throw new Error("ERROR: "+this.getClassName()+" unsupported event_type '"+e+"'")},listen:function(e,t){var i=this;i._hasEvent(e);for(var s=Date.now();void 0!==i._handlers[e][s];)s++;i._handlers[e][s]=t;var n={name:e,listenerId:s,unlisten:(null,function(){i.unlisten(n)})};return n},unlisten:function(e,t){"object"==typeof e&&1===arguments.length?(this._hasEvent(e.name),delete this._handlers[e.name][e.listenerId]):(this._hasEvent(e),delete this._handlers[e][t.listenerId])},parseChildren:function(e,t){var i=this,s=null,n=null;if(!i.isContainer)throw new TypeError("["+i.getClassName()+"] not a container control, cannot parse child controls.");if(!shmi.testParentChild(i.element,e))throw new TypeError("["+i.getClassName()+"] element not contained within control.");(n=shmi.parseControls(e,!1,i.element)).forEach((function(e){i.controls.push(e)})),0===i.controls.length?t(n):null!==(s=shmi.waitOnInit(i.controls,(function(){var e=i._init_.tokens.indexOf(s);-1!==e&&i._init_.tokens.splice(e,1),s=null,t(n)})))&&i._init_.tokens.push(s)},getChildren:function(){return this.isContainer?this.controls:null},isDeleted:function(){return!0===this.deleted},_setCssClasses:function(){console.warn("["+this.getClassName()+"]","_setCssClasses - is deprecated and should not be called by control implementations. This message is usually generated when BaseControl methods have been replaced, use BaseControl methods 'onTemplate' and 'onRegister' to avoid having to override system methods."),setCssClasses(this)},getParent:function(){return this.parentContainer||null},addControl:function(e,t){const i=this;"function"==typeof i.onAddControl?(!function checkAddControlOptions(e){if("object"!=typeof e||null===e)throw new TypeError("Invalid options specified for `addControl`.");Array.isArray(e)||(e=[e]),e.forEach(e=>{if(e.config&&"object"==typeof e.config||(e.config={}),"string"!=typeof e.ui)throw new TypeError("Missing `ui` property on option: "+JSON.stringify(e,null,4));Array.isArray(e.children)&&checkAddControlOptions(e.children)})}(e),i.onAddControl(e,t)):(console.error("["+i.getClassName()+"]","no implementation 'onAddControl' for control type:",i.uiType),"function"==typeof t&&t(null,[]))},isLocked:function(){return this.locked||!1}}}(),function(){const e=864e5;function getUnusedIndex(e){let t=null;do{t=Math.floor(Math.random()*Number.MAX_SAFE_INTEGER)}while(e[t]);return t}function deleteRequest(e,t){const i=e.pendingRequests[t];void 0!==i&&(clearTimeout(i.timeout),function unregisterMessageHandlerForRequest(e,t){const i=e.messageHandlerForRequests[t];void 0!==i&&--i.refCnt<=0&&(delete e.messageHandlerForRequests[t],e.unregisterMessageHandler(t,i.handlerId))}(e,i.cmd),delete e.pendingRequests[t])}function completeRequest(e,t,i,s){const n=e.pendingRequests[t];if(void 0!==n){deleteRequest(e,t);try{n.callback(i,s)}catch(e){console.error("Uncaught",e,"\nin api request callback.\n    request: ",n,"\nCallback was called with","\n    data:",i,"\n    error:",s)}}}function cancelRequest(e,t,i){completeRequest(e,t,null,void 0===i?420:i)}function promiseHandler(e,t,i,s){s?t(s):e(i)}function requestMessageHandler(e,t){var i=e.pendingRequests[t.id];i?(!function translateLegacyError(e){void 0===e.error&&"number"==typeof e.st&&(0===e.st?e.error=null:e.error={errc:e.st,category:"connect-2.1:compatibility",message:"generic error"},delete e.st)}(t),function collectPayloadData(e,t){const i=shmi.requires("visuals.tools.iterate.iterateObject"),s=t.fragmented||e.data,n=!t.fragmented;return s?null===e.data?e.data=t.data:Array.isArray(t.data)?e.data.push(...t.data):"object"==typeof t.data&&i(t.data,(function(t,i){Array.isArray(t)&&shmi.objectHasOwnProperty(e.data,i)?e.data[i].push(...t):e.data[i]=t})):e.data=t.data,n}(i,t)&&completeRequest(e,t.id,i.data,null===t.error?0:t.error)):console.error("[ConnectSession]","unknown request-ID:",t)}shmi.visuals.core.ConnectSession=function ConnectSession(t){const i=shmi.requires("visuals.io.SocketConnection");Object.defineProperties(this,{wsUrl:{configurable:!1,value:t,writable:!1},socket:{configurable:!1,value:new i(t,this),writable:!1},messageHandlers:{configurable:!1,value:{},writable:!1},pendingRequests:{configurable:!1,value:{},writable:!1},messageHandlerForRequests:{configurable:!1,value:{},writable:!1},REQUEST_TIMEOUT:{configurable:!1,value:e,writable:!1}}),Object.freeze(this)},shmi.visuals.core.ConnectSession.prototype={constructor:shmi.visuals.core.ConnectSession,connect:function(e){this.socket.connect(e)},disconnect:function disconnect(){const e=shmi.requires("visuals.tools.iterate.iterateObject");this.socket.disconnect(),e(this.pendingRequests,e=>{cancelRequest(this,e.id)})},postMessage:function(e){const t=this.messageHandlers[e.cmd];t?Object.values(t).forEach(t=>{try{t(e)}catch(e){console.error("Uncaught ",e,"\nin message handler.")}}):console.warn("[ConnectSession]","No message handler registered for ",e.cmd,"\n  message: ",e)},registerMessageHandler:function registerMessageHandler(e,t){void 0===this.messageHandlers[e]&&(this.messageHandlers[e]={});var i=getUnusedIndex(this.messageHandlers[e]);return this.messageHandlers[e][i]=t,shmi.log("[registerMsgHandler] registered message handler '"+e+"'",2),i},unregisterMessageHandler:function unregisterMessageHandler(e,t){var i=!1;return this.messageHandlers[e]&&this.messageHandlers[e][t]&&(delete this.messageHandlers[e][t],shmi.log("[unregisterMsgHandler] unregistered message handler '"+e+"'",2),i=!0),this.messageHandlers[e]&&0===Object.keys(this.messageHandlers[e]).length&&delete this.messageHandlers[e],i},request:function request(t,i,s,n,r){var o,a={cmd:t,id:function createRequest(t,i,s,n,r){const o=getUnusedIndex(t.pendingRequests);return t.pendingRequests[o]={id:o,cmd:i,parameters:s,callback:n,data:null,timeout:setTimeout((function(){console.error("[ConnectSession]","timeout on request:",t.pendingRequests[o]),cancelRequest(t,o)}),r||e),timeoutDuration:r||e},t.pendingRequests[o]}(this,t,i,s,n).id,data:i};r&&(a.target=r),o=JSON.stringify(a),function registerMessageHandlerForRequest(e,t){shmi.objectHasOwnProperty(e.messageHandlerForRequests,t)?++e.messageHandlerForRequests[t].refCnt:e.messageHandlerForRequests[t]={handlerId:e.registerMessageHandler(t,requestMessageHandler.bind(null,e)),refCnt:1}}(this,t),this.socket.sendMessage(o)},requestPromise:function requestPromise(e,t,i){const{customTimeout:s,target:n}=i||{};return new Promise((i,r)=>this.request(e,t,promiseHandler.bind(null,i,r),s,n))}}}(),function(){function alarmCallback(e,t,i){var s=[];e.fields.forEach((function(e,i){var n=function getFieldValue(e,t){var i=null;switch(t){case"level":i=e.severity;break;case"status":i=e.acknowledgeable&&!e.acknowledged;break;case"come":i=e.timestamp_in;break;case"gone":i=e.timestamp_out;break;case"json":i=JSON.stringify(e);break;default:void 0!==e[t]&&(i=e[t])}return i}(t,e);switch(typeof n){case"string":s.push({type:shmi.c("TYPE_STRING"),value:n});break;case"boolean":s.push({type:shmi.c("TYPE_BOOL"),value:n?1:0,min:0,max:1});break;case"number":s.push({type:shmi.c("TYPE_FLOAT"),value:n,min:Number.NaN,max:Number.NaN});break;default:s.push({type:shmi.c("TYPE_STRING"),value:"NULL",min:Number.NaN,max:Number.NaN})}})),e.insertRow(s,void 0,!i)}function createVirtualItem(e,t,i,s,n){var r=shmi.createVirtualItem(t,i.type,i.min,i.max,i.value,null);return r.setDataGridInfo(e.name,s,n),r}function compareColumnValue(e,t,i){return t[e].value<i[e].value?-1:t[e].value===i[e].value?0:1}function updateSubscribedRows(e){var t=shmi.requires("visuals.tools.iterate").iterateObject,i=[];t(e.subscribers,(function(t,s){for(var n=e.getCurrentIDs(s),r=0;t.offset+r<e.totalRows&&r<t.size;r++)-1===i.indexOf(n[r])&&i.push(n[r])})),i.forEach((function(t,i){var s=e.data[t];s&&s.forEach((function(e,t){e.item.readValue(!0)!==e.value&&e.item.writeValue(e.value,!0)}))}))}shmi.pkg("visuals.core"),shmi.visuals.core.DataGridAlarms=function(){this.name="alarms",this.fields=["id","index","status","level","come","active","gone","group","json"],this.conditions=[],this.type="ALARMS",this.data={},this.subscribers={},this.prefix="virtual:grid:"+this.name+":",this.totalRows=0,this.nextRowId=0,this.taskQueue=[],this.order=[0,"ASC"],this.filter={},this._subID=null,this.AM=shmi.visuals.session.AlarmManager,this.indexFields=["id"],this.lastStateUpdate=0,this.stateTO=0,this.singleStateTO=0,this.init()},shmi.visuals.core.DataGridAlarms.prototype={init:function(){var e=shmi.visuals.session.config;e&&e["disable-alarm-prefetch"]||(this._subID=this.AM.subscribeAlarms(this,alarmCallback.bind(null,this)))},subscribePage:function(e,t,i){for(var s=this,n=Date.now(),r=shmi.visuals.session.config;void 0!==s.subscribers[n];)n++;var o={};o.id=n,o.offset=e,o.size=t,o.onChange=i,o.lastUpdate=0,s.subscribers[n]=o,1===Object.keys(s.subscribers).length&&r&&r["disable-alarm-prefetch"]?s._subID=s.AM.subscribeAlarms(s,alarmCallback.bind(null,s)):shmi.decouple((function(){s.subscribers[n]&&(s.subscribers[n].lastUpdate=Date.now(),s.subscribers[n].onChange(s._calcState(n)))}));var a={};return a.id=n,a.prefix=s.prefix,a},getFields:function(e){return this.fields},getIndexFields:function(){var e=this,t=[];return e.indexFields.forEach((function(i){var s=e.fields.indexOf(i);-1!==s?t.push(s):console.warn("[DataGrid '"+this.name+"'] index field not found: "+i)})),t},getRowIndex:function(e){var t=this,i=[];return this.getIndexFields().forEach((function(s){i.push(t.data[e][s].value)})),i},searchIndexRowId:function(e){var t=this,i=-1,s=t.getIndexFields();return(0,shmi.requires("visuals.tools.iterate").iterateObject)(t.data,(function(n,r){t.searchIndexFields(r,s,e)&&-1===i&&(i=parseInt(r))})),i},searchIndexFields:function(e,t,i){var s=this,n=0;return t.forEach((function(t,r){s.data[e][t].value===i[r]&&n++})),n>0&&n===t.length},_getRowByAlarmID:function(e){var t=this,i=shmi.requires("visuals.tools.iterate").iterateObject,s=null;return i(t.data,(function(i,n){t.data[n][0].value===e&&(s=n)})),s},insertRow:function(e,t,i){var s=0,n=null,r=this._getRowByAlarmID(e[0].value);if(void 0!==t)s=t;else if(null!==r)s=r;else for(;void 0!==this.data[s];)s++;if(void 0===this.data[s]){if(1===e[2].value||1===e[5].value){this.data[s]=e;for(var o=0;o<e.length;o++){var a=e[o],l="virtual:grid:"+this.name+":"+s+":"+o,u=shmi.visuals.session.ItemManager;null===u.getItem(l)||!1===u.getItem(l).initialized?this.data[s][o].item=createVirtualItem(this,l,a,s,o):(this.data[s][o].item=u.getItem(l),u.writeValue(l,a.value))}}}else for(o=0;o<e.length;o++){if("active"===this.fields[o]&&0===e[o].value&&1!==e[2].value){delete this.data[s];break}void 0===this.data[s][o].item&&(a=e[o],l="virtual:grid:"+this.name+":"+s+":"+o,this.data[s][o].item=createVirtualItem(this,l,a,s,o)),this.data[s][o].value=e[o].value,this.data[s][o].item.writeValue(e[o].value)}return!0!==i&&(this.totalRows=this._calcKeys().length,n=Date.now(),clearTimeout(this.stateTO),this.stateTO=0,n-this.lastStateUpdate>shmi.c("ACTION_RETRY_TIMEOUT")?shmi.raf(this.sort.bind(this,this.order[0],this.order[1],!0)):this.stateTO=setTimeout(this.sort.bind(this,this.order[0],this.order[1],!0),shmi.c("ACTION_RETRY_TIMEOUT"))),this._getRowByAlarmID(e[0].value)},deleteRow:function(e){if(Array.isArray(e))for(var t=0;t<e.length;t++)void 0!==this.data[e[t]]?this.AM.ackAlarm(this.data[e[t]][0].value):shmi.log("[DataGridAlarms] alarm not found row-id="+e,2);else void 0!==this.data[e]?this.AM.ackAlarm(this.data[e][0].value):shmi.log("[DataGridAlarms] alarm not found row-id="+e,2)},deleteAll:function(){this.AM.ackAlarm(-1)},unsubscribe:function(e){var t=this,i=shmi.visuals.session.config,s=shmi.requires("visuals.tools.iterate").iterateObject;if(delete t.subscribers[e],0===Object.keys(t.subscribers).length&&i&&i["disable-alarm-prefetch"]){t.AM.unsubscribeAlarms(t._subID);var n=shmi.visuals.session.ItemManager;s(t.data,(function(e,i){for(var s=0;s<t.data[i].length;s++)n.removeItem(t.data[i][0].item.name);delete t.data[i]}))}},setOffset:function(e,t){var i=this,s=i.subscribers[t],n=Date.now();void 0!==s&&(e>i.totalRows&&(e=i.totalRows),s.offset=e,clearTimeout(i.singleStateTO),i.singleStateTO=0,n-s.lastUpdate>shmi.c("ACTION_RETRY_TIMEOUT")?(s.lastUpdate=n,shmi.raf((function(){(s=i.subscribers[t])&&s.lastUpdate===n&&(updateSubscribedRows(i),s.onChange(i._calcState(t)))}))):i.singleStateTO=setTimeout((function(){(s=i.subscribers[t])&&(s.lastUpdate=Date.now(),updateSubscribedRows(i),s.onChange(i._calcState(t)))}),shmi.c("ACTION_RETRY_TIMEOUT")))},getRowCount:function(){return this.totalRows},setFilter:function(e,t){var i=this,s=shmi.requires("visuals.tools.iterate").iterateObject;e===i.fields.indexOf("level")?(i.filter[i.fields[e]]=t,i.totalRows=i._calcKeys().length,clearTimeout(i.stateTO),i.stateTO=setTimeout((function(){s(i.subscribers,(function(e,t){i.subscribers[t].offset=0})),updateSubscribedRows(i),s(i.subscribers,(function(e,t){i.subscribers[t].onChange(i._calcState(t))}))}),shmi.c("ACTION_RETRY_TIMEOUT"))):shmi.log("[DataGridAlarms] filtering not supported for column index "+e,2)},getFilters:function(){for(var e=[],t=0;t<this.fields.length;t++)void 0!==this.filter[this.fields[t]]?e.push(this.filter[this.fields[t]]):e.push(null);return e},refresh:function(){},clearFilter:function(e){var t=this,i=shmi.requires("visuals.tools.iterate").iterateObject;e===t.fields.indexOf("level")||-1===e?(t.filter={},t.totalRows=t._calcKeys().length,clearTimeout(t.stateTO),t.stateTO=setTimeout((function(){i(t.subscribers,(function(e,i){t.subscribers[i].offset=0,t.subscribers[i].onChange(t._calcState(i))}))}),shmi.c("ACTION_RETRY_TIMEOUT"))):shmi.log("[DataGridAlarms] filtering not supported for column index "+e,2)},_calcKeys:function(){var e=[];if(void 0!==this.filter.level){var t=Object.keys(this.data),i=[];Array.isArray(this.filter.level)?i=this.filter.level:i.push(this.filter.level);for(var s=0;s<t.length;s++)-1!==i.indexOf(this.data[t[s]][this.fields.indexOf("level")].value)&&e.push(t[s])}else e=Object.keys(this.data);return e},sort:function(e,t,i,s){this.order=-1===e?[0,"ASC"]:[e,t],function sortObj(e,t,i,s){var n=shmi.requires("visuals.session.ItemManager"),r=shmi.requires("visuals.tools.iterate").iterateObject,o=[];r(i,(function(e,t){o.push(i[t]),delete i[t]})),o.sort(compareColumnValue.bind(null,t)),"DESC"===s&&o.reverse();for(var a=0;a<o.length;a++)i[a]=o[a],i[a].forEach((function(t,s){var r="virtual:grid:"+e.name+":"+a+":"+s,o=n.getItem(r);i[a][s].item=o}));updateSubscribedRows(e)}(this,this.order[0],this.data,this.order[1]),function updateSubscribers(e,t){var i=shmi.requires("visuals.tools.iterate").iterateObject,s=Date.now();i(e.subscribers,(function(i,n){!0!==t&&(e.subscribers[n].offset=0),e.subscribers[n].lastUpdate=s,e.subscribers[n].onChange(e._calcState(n))})),e.lastStateUpdate=s}(this,i)},getCurrentIDs:function(e){for(var t=[],i=this.subscribers[e],s=this._calcKeys(),n=i.offset;n<i.offset+i.size&&void 0!==s[n];n++)t.push(parseInt(s[n]));return t},getAllIDs:function(e){for(var t=[],i=this._calcKeys(),s=0;s<i.length;s++)t.push(parseInt(i[s]));return t},getRowData:function(e){return void 0!==this.data[e]?this.data[e]:null},_calcState:function(e){var t=this.subscribers[e],i={status:"OK"};return i.totalRows=this.totalRows,i.offset=Math.min(t.offset,Math.max(i.totalRows-1,0)),i}}}(),function(){function getFilterParameter(e){var t=shmi.requires("visuals.tools.iterate.iterateObject"),i={mode:e.filterChaining,clauses:[]};return t(e.filter,(function(e){i.clauses.push(e)})),i}shmi.pkg("visuals.core");var e={id:"id",index:"index",level:"severity",come:"timestamp_in",gone:"timestamp_out",group:"group",needAck:"acknowledgeable",isAck:"acknowledged",alarmAck:"timestamp_acknowledged",ackUser:"acknowledged_by",json:"id"};function getSortParameter(t){return[{column:e[t.fields[t.order[0]]],order:t.order[1],location:"property"}]}function getQueryOptions(e,t){var i=e.subscribers[t],s=null,n=shmi.requires("visuals.tools.iterate.iterateObject");return void 0===t&&(i={size:null,offset:0},n(e.subscribers,(function(e,t){e.size>i.size&&(i.size=e.size),e.offset=0}))),i&&(s={limit:i.size,offset:i.offset,filter:getFilterParameter(e),sort:getSortParameter(e)}),s}function reloadAlarms(e){var t=shmi.requires("visuals.session.AlarmManager"),i=shmi.requires("visuals.tools.iterate.iterateObject"),s=createLoadRequest(e);i(e.data,(function(t,i){!function deleteRow(e,t){var i=e.data[t];i&&Array.isArray(i)&&delete e.data[t]}(e,i)})),e.lastRequest=s,t.getHistoricAlarms((function alarmCb(t,n){delete e.requests[s.id],e.lastRequest===s&&(e.totalRows=0,n&&Array.isArray(n.alarms)?(n.alarms.forEach((function(t,i){alarmCallback(e,t,i,i!==n.alarms.length-1)})),e.totalRows=n.total_count):console.error("DataGridAlarmsHistoric","failed to retrieve historic alarms"),i(e.subscribers,(function(t,i){t.onChange({status:"OK",offset:0,totalRows:e.totalRows})})))}),getQueryOptions(e))}function loadAlarms(e,t){var i=shmi.requires("visuals.session.AlarmManager"),s=null,n=e.subscribers[t];n&&(n=null,s=createLoadRequest(e),e.lastRequest=s,i.getHistoricAlarms((function alarmCb(i,r){delete e.requests[s.id],e.lastRequest===s&&(n=e.subscribers[t])&&(e.totalRows=0,r&&Array.isArray(r.alarms)?(r.alarms.forEach((function(t,i){alarmCallback(e,t,n.offset+i,i!==r.alarms.length-1)})),e.totalRows=r.total_count):console.error("DataGridAlarmsHistoric","failed to retrieve historic alarms"),n.onChange({status:"OK",offset:n.offset,totalRows:e.totalRows}))}),getQueryOptions(e,t)))}function alarmCallback(e,t,i,s){var n=[];e.fields.forEach((function(e,i){var s=function getFieldValue(e,t){var i=null;switch(t){case"level":i=e.severity;break;case"status":i=e.acknowledgeable&&!e.acknowledged;break;case"come":i=e.timestamp_in;break;case"gone":i=e.timestamp_out;break;case"json":i=JSON.stringify(e);break;case"alarmAck":i=e.timestamp_acknowledged;break;case"ackUser":i=e.acknowledged_by;break;default:void 0!==e[t]&&(i=e[t])}return i}(t,e);switch(typeof s){case"string":n.push({type:shmi.c("TYPE_STRING"),value:s});break;case"boolean":n.push({type:shmi.c("TYPE_BOOL"),value:s?1:0,min:0,max:1});break;case"number":n.push({type:shmi.c("TYPE_FLOAT"),value:s,min:Number.NaN,max:Number.NaN});break;default:n.push({type:shmi.c("TYPE_STRING"),value:"NULL",min:Number.NaN,max:Number.NaN})}})),e.insertRow(n,i,s)}function createVirtualItem(e,t,i,s,n){var r=shmi.requires("visuals.session.ItemManager").getItem(t),o=null;return r&&r.initialized?(r.readValue()!==i.value&&r.writeValue(i.value),r):(o=shmi.createVirtualItem(t,i.type,i.min,i.max,i.value,null),-1===e.itemsCreated.indexOf(t)&&e.itemsCreated.push(t),o.setDataGridInfo(this.name,s,n),o)}function createLoadRequest(e){for(var t=0;void 0!==e.requests[t];)t+=1;return e.requests[t]={id:t},e.requests[t]}shmi.visuals.core.DataGridAlarmsHistoric=function(){this.name="alarms-historic",this.fields=["id","index","level","come","gone","group","needAck","isAck","alarmAck","ackUser","json"],this.conditions=[],this.type="ALARMS_HISTORIC",this.data={},this.subscribers={},this.prefix="virtual:grid:"+this.name+":",this.totalRows=0,this.nextRowId=0,this.taskQueue=[],this.order=[0,"ASC"],this.filter={},this.filterChaining="AND",this._subID=null,this.AM=shmi.visuals.session.AlarmManager,this.indexFields=["id"],this.requests={},this.lastRequest=null,this.itemsCreated=[],this.init()},shmi.visuals.core.DataGridAlarmsHistoric.prototype={init:function(){},subscribePage:function(e,t,i){for(var s=Date.now();void 0!==this.subscribers[s];)s++;var n={};n.id=s,n.offset=e,n.size=t,n.onChange=i,n.lastUpdate=0,n.updateTimeout=0,this.subscribers[s]=n,loadAlarms(this,n.id);var r={};return r.id=s,r.prefix=this.prefix,r},getFields:function(e){return this.fields},getIndexFields:function(){var e=this,t=[];return e.indexFields.forEach((function(i){var s=e.fields.indexOf(i);-1!==s?t.push(s):console.warn("[DataGrid '"+this.name+"'] index field not found: "+i)})),t},getRowIndex:function(e){var t=this,i=[];return this.getIndexFields().forEach((function(s){i.push(t.data[e][s].value)})),i},searchIndexRowId:function(e){var t=this,i=-1,s=t.getIndexFields();return(0,shmi.requires("visuals.tools.iterate").iterateObject)(t.data,(function(n,r){t.searchIndexFields(r,s,e)&&-1===i&&(i=parseInt(r))})),i},searchIndexFields:function(e,t,i){var s=this,n=0;return t.forEach((function(t,r){s.data[e][t].value===i[r]&&n++})),n>0&&n===t.length},setFilterChaining:function(e){"OR"===e||"AND"===e?this.filterChaining=e:console.error("[DataGridAlarmsHistoric] invalid filter chaining mode:",e)},insertRow:function(e,t,i){var s,n,r=null;if(void 0===t)return console.error("DataGridAlarmsHistoric","no row-index specified on insertRow"),null;r=t,void 0===this.data[r]&&(this.data[r]=e);for(var o=0;o<e.length;o++)s=e[o],n="virtual:grid:"+this.name+":"+r+":"+o,this.data[r][o].item=createVirtualItem(this,n,s,r,o),this.data[r][o].value=s.value;return r},deleteRow:function(e){},deleteAll:function(){},unsubscribe:function(e){var t=this,i=shmi.requires("visuals.tools.iterate.iterateObject");if(delete t.subscribers[e],0===Object.keys(t.subscribers).length){i(t.data,(function(e,i){delete t.data[i]}));var s=shmi.requires("visuals.session.ItemManager");t.itemsCreated.forEach((function(e){s.removeItem(e)})),t.itemsCreated=[],t.totalRows=0,t.lastRequest=null}},setOffset:function(e,t){var i=this,s=i.subscribers[t],n=null;void 0!==s&&(e>i.totalRows&&(e=i.totalRows),s.offset=e,n=Date.now(),clearTimeout(s.updateTimeout),s.updateTimeout=0,n-s.lastUpdate>shmi.c("ACTION_RETRY_TIMEOUT")?(s.lastUpdate=n,shmi.raf((function(){(s=i.subscribers[t])&&s.lastUpdate===n&&loadAlarms(i,t)}))):s.updateTimeout=setTimeout((function(){(s=i.subscribers[t])&&(s.lastUpdate=Date.now(),loadAlarms(i,t))}),shmi.c("ACTION_RETRY_TIMEOUT")))},getRowCount:function(){return this.totalRows},setFilter:function(e,t){var i=this,s=shmi.requires("visuals.tools.enum.createEnum")(i.fields);-1!==[s.level,s.come,s.group].indexOf(e)?(e===s.level?(i.filter.level={column:"severity",mode:"OR",location:"property",clauses:[]},Array.isArray(t)?t.forEach((function(e){i.filter.level.clauses.push({operator:"==",value:parseInt(e)})})):i.filter.level.clauses.push({operator:"==",value:parseInt(t)})):e===s.group?(i.filter.group={column:"group",mode:"OR",location:"property",clauses:[]},Array.isArray(t)?t.forEach((function(e){i.filter.group.clauses.push({operator:"==",value:parseInt(e)})})):i.filter.group.clauses.push({operator:"==",value:parseInt(t)})):e===s.come&&(i.filter.come={column:"timestamp_in",mode:"AND",location:"property",clauses:[]},Array.isArray(t)&&t.length>=2?i.filter.come.clauses.push({operator:">=",value:1e7*parseInt(t[0])},{operator:"<=",value:1e7*parseInt(t[1])}):i.filter.come.clauses.push({operator:">=",value:1e7*parseInt(t)})),reloadAlarms(i)):shmi.log("[DataGridAlarmsHistoric] filtering not supported for column index "+e,2)},getFilters:function(){for(var e=[],t=0;t<this.fields.length;t++)void 0!==this.filter[this.fields[t]]?e.push(this.filter[this.fields[t]]):e.push(null);return e},refresh:function(){reloadAlarms(this)},clearFilter:function(e){var t=null;-1===e?this.filter={}:this.fields[e]&&(t=this.fields[e],delete this.filter[t]),reloadAlarms(this)},sort:function(e,t){this.order=-1===e?[0,"ASC"]:[e,t],reloadAlarms(this)},getSortOrder:function(){return shmi.cloneObject(this.order)},getCurrentIDs:function(e){for(var t=[],i=this.subscribers[e],s=i.offset;s<i.offset+i.size;s++)s<this.totalRows&&t.push(s);return t},getAllIDs:function(e){for(var t=[],i=0;i<this.totalRows;i++)t.push(i);return t},getRowData:function(e){return void 0!==this.data[e]?this.data[e]:null}}}(),shmi.pkg("visuals.core"),shmi.visuals.core.DataGridDB=function(e,t,i,s,n,r){this.name=e,this.db=t,this.table=i,this.fields=s,this.indexFields=r||[],this.conditions=n||[],this.type="DB2",this.data={},this.subscribers={},this.prefix="virtual:grid:"+this.name+":",this.nextRowID=0,this.query=null,this.totalRows=0,this.taskQueue=[],this.order=null,this._writeTimeout=0,this.loadTimeout=15e3,this._loadTO=0,this.filter={},this.filter.chaining="AND"},shmi.visuals.core.DataGridDB.prototype={init:function(){this.taskQueue=[],this.subscribers={}},subscribePage:function(e,t,i){for(var s=Date.now();void 0!==this.subscribers[s];)s++;var n={};n.id=s,n.offset=e,n.size=t,n.onChange=i,this.subscribers[s]=n;var r={};r.id=s,r.prefix=this.prefix;var o=[];if(void 0===this.q_id){o.push({type:"query"})}var a={type:"load",subID:s};return o.push(a),this._queueTasks(o),r},getFields:function(){return this.fields},getIndexFields:function(){var e=[];return this.indexFields.forEach(function(t){var i=this.fields.indexOf(t);-1!==i?e.push(i):shmi.log("[DataGrid '"+this.name+"'] index field not found: "+t,3)}.bind(this)),e},getRowIndex:function(e){var t=[];return this.getIndexFields().forEach(function(i){t.push(this.data[e][i].value)}.bind(this)),t},searchIndexRowId:function(e){var t=this,i=-1,s=t.getIndexFields();return(0,shmi.requires("visuals.tools.iterate").iterateObject)(t.data,(function(n,r){t.searchIndexFields(r,s,e)&&-1===i&&(i=parseInt(r))})),i},searchIndexFields:function(e,t,i){var s=this,n=0;return t.forEach((function(t,r){s.data[e][t].value===i[r]&&n++})),n>0&&n===t.length},insertRow:function(e){var t=this,i=shmi.visuals.session.DataGridManager,s=shmi.visuals.session.ItemManager,n=shmi.requires("visuals.tools.iterate").iterateObject,r=this.nextRowID++;t.totalRows++,t.data[r]=e,t.reset_grid=!0;for(var o=0;o<e.length;o++){var a=t.data[r][o],l=t.prefix+r+":"+o,u=s.getItem(l);u&&u.initialized?a.item=u:(a.item=shmi.createVirtualItem(l,a.type,a.min,a.max,a.value,function(e,s){return function(n,r,o){if(t.data[e]&&t.data[e][s]){var a=t.data[e][s].value;if(t.data[e][s].value=n,!0!==t.reset_grid&&a!==n){t.db%2!=0&&(clearTimeout(t.data[e].timeout_id),t.data[e].timeout_id=setTimeout((function(){!0===shmi.visuals.session.config.debug&&console.log("SAVING DATAGRID (DB2)",e,t.data[e]),i.saveRowToDB(t.name,e,!1)}),shmi.c("DATAGRID_DB2_WRITE_DELAY")));try{shmi.log("[DataGrid '"+t.name+"'] updated value: "+n,1)}catch(e){shmi.log("[DataGrid '"+t.name+"'] failed to update value: "+e,2)}}}}}(r,o)),a.item.setDataGridInfo(t.name,r,o)),a.item.writable=!0,a.item.writeValue(a.value),t.db%2==0&&(a.item.writable=!1)}return t.reset_grid=!1,n(t.subscribers,(function(e,i){t.subscribers[i].onChange(t._calcState(i))})),shmi.log("[DataGridDB] insertRow",2),r},deleteRow:function(e){var t,i=this,s=[],n=shmi.requires("visuals.tools.iterate").iterateObject;if(Array.isArray(e))for(var r=0;r<e.length;r++)t={type:"delete",rowID:i.data[e[r]].rowID},s.push(t);else t={type:"delete",rowID:i.data[e].rowID},s.push(t);s.push({type:"query"}),n(i.subscribers,(function(e,t){i.subscribers[t].offset=0;var n={type:"load",subID:t};s.push(n)})),i._queueTasks(s)},deleteAll:function(){var e=[];e.push({type:"delete-all"});for(var t in e.push({type:"query"}),this.subscribers){this.subscribers[t].offset=0;var i={type:"load",subID:t};e.push(i)}this._queueTasks(e)},_queueTasks:function(e){shmi.decouple(()=>{for(var t=0===this.taskQueue.length,i=0;i<e.length;i++)this.taskQueue.push(e[i]);t&&this._nextTask()})},unsubscribe:function(e){var t=shmi.visuals.session;if(delete this.subscribers[e],0===Object.keys(this.subscribers).length){void 0!==this.q_id&&(t.QueryManager.close(this.q_id),delete this.q_id);for(var i=Object.keys(this.data),s=0;s<i.length;s++){for(var n=0;n<this.data[i[s]].length;n++)shmi.visuals.session.ItemManager.removeItem(this.data[i[s]][n].item.name);delete this.data[i[s]]}}},setOffset:function(e,t){if(void 0!==this.subscribers[t]){this.subscribers[t].offset=e;var i={type:"load",subID:t};this._queueTasks([i])}},getRowCount:function(){return this.totalRows},setFilter:function(e,t){this.filter[this.fields[e]]=t,clearTimeout(this.recalcTO),this.recalcTO=setTimeout(function(){this.refresh()}.bind(this),shmi.c("ACTION_RETRY_TIMEOUT"))},setFilterChaining:function(e){"OR"===e||"AND"===e?this.filter.chaining=e:console.error("[DataGridDB] invalid filter chaining mode:",e)},getFilters:function(){for(var e=[],t=0;t<this.fields.length;t++)void 0!==this.filter[this.fields[t]]?e.push(this.filter[this.fields[t]]):e.push(null);return e},refresh:function(){var e=this,t=shmi.requires("visuals.tools.iterate").iterateObject,i=[];i.push({type:"query"}),t(e.subscribers,(function(t,s){e.subscribers[s].offset=0;var n={type:"load",subID:s};i.push(n)})),e._queueTasks(i)},clearFilter:function(e){var t=!1;if(-1===e)for(var i=0;i<this.fields.length;i++)void 0!==this.filter[this.fields[i]]&&(delete this.filter[this.fields[i]],t=!0);else void 0!==this.filter[this.fields[e]]&&(delete this.filter[this.fields[e]],t=!0);t&&(clearTimeout(this.recalcTO),this.recalcTO=setTimeout(function(){this.refresh()}.bind(this),shmi.c("ACTION_RETRY_TIMEOUT")))},sort:function(e,t){var i=this.order;this.order=-1===e?null:[e,t],this.order!==i&&(clearTimeout(this.recalcTO),this.recalcTO=setTimeout(function(){this.refresh()}.bind(this),shmi.c("ACTION_RETRY_TIMEOUT")))},getCurrentIDs:function(e){var t=[],i=this.subscribers[e];if(void 0!==i)for(var s=this.totalRows<i.offset+i.size?this.totalRows:i.offset+i.size,n=i.offset;n<s;n++)t.push(n);return t},getAllIDs:function(e){for(var t=[],i=0;i<this.totalRows;i++)t.push(i);return t},getRowData:function(e){return void 0!==this.data[e]?this.data[e]:null},_calcState:function(e){var t=this.subscribers[e],i={status:"OK"};return i.offset=t.offset,i.totalRows=this.totalRows,i},_doQuery:function(){var e=this,t=shmi.visuals.session,i=null;(0,shmi.requires("visuals.tools.iterate").iterateObject)(e.data,(function(t,i){delete e.data[i]}));for(var s=[],n=0;n<e.fields.length;n++)s.push(e.fields[n]);s.push("ROWID"),void 0!==e.q_id&&(t.QueryManager.close(e.q_id),delete e.q_id);var r={mode:e.filter.chaining,clauses:[]};e.getFilters().forEach((function(t,i){var s=[];null!==t&&(t.forEach((function(e,t){s.push({operator:"like",value:e})})),r.clauses.push({mode:"OR",column:e.fields[i],clauses:s}))})),null!==e.order&&(i=[{column:e.fields[e.order[0]],order:e.order[1]}]),e.q_id=t.QueryManager.query(e._queryCB.bind(e),e.table,s,r,e.db,i)},_loadData:function(e){if(void 0!==this.subscribers[e]){var t=shmi.visuals.session,i=this.subscribers[e].size,s=this.subscribers[e].offset;t.QueryManager.get(this._getLoadCB(e,s),this.q_id,s,i>this.totalRows?this.totalRows:i)}else this._nextTask()},_queryCB:function(e,t,i){0===e?(this.totalRows=t,this.nextRowID=this.totalRows):shmi.notify("[DataGrid '<%= name %>'] Failed to query database (error code: <%= errc %>, message: <%= message %>, category: <%= category %>)","${V_ERROR}",{name:this.name,errc:e.errc,message:e.message,category:e.category}),this._nextTask()},_getLoadCB:function(e,t){var makeCells=function(e,t){for(var i=[],s=0;s<e.length;s++)if(s===e.length-1)i.rowID=parseInt(e[s]);else{var n={type:shmi.c("TYPE_STRING"),value:e[s],min:Number.NaN,max:Number.NaN};i.push(n)}return i};return function(i,s){var n=shmi.visuals.session.DataGridManager,r=shmi.visuals.session.ItemManager,o=this;if(clearTimeout(o._loadTO),0===i&&void 0!==this.subscribers[e]){var a=t,l=this.totalRows<t+this.subscribers[e].size?this.totalRows:t+this.subscribers[e].size;this.reset_grid=!0;for(var u=a;u<l;u++){var c=s.data[u-a];this.data[u]=makeCells(c),clearTimeout(this.data[u].timeout_id),this.data[u].timeout_id=0;for(var h=0;h<this.data[u].length;h++){var m=this.data[u][h],d=this.prefix+u+":"+h,f=r.getItem(d);f&&f.initialized?m.item=f:(m.item=shmi.createVirtualItem(d,m.type,m.min,m.max,m.value,function(e,t){return function(i,s,r){if(this.data[e]&&this.data[e][t]){var a=this.data[e][t].value;if(this.data[e][t].value=i,!0!==this.reset_grid&&a!==i){this.db%2!=0&&(clearTimeout(o.data[e].timeout_id),o.data[e].timeout_id=setTimeout((function(){!0===shmi.visuals.session.config.debug&&console.log("SAVING DATAGRID (DB2)",e,o.data[e]),n.saveRowToDB(o.name,e,!1)}),shmi.c("DATAGRID_DB2_WRITE_DELAY")));try{shmi.log("[DataGrid '"+this.name+"'] updated value: "+i,1)}catch(e){shmi.log("[DataGrid '"+this.name+"'] failed to update value: "+e,2)}}}}.bind(this)}.bind(this)(u,h)),m.item.setDataGridInfo(this.name,u,h)),m.item.writable=!0,m.item.writeValue(m.value),this.db%2==0&&(m.item.writable=!1)}}this.reset_grid=!1,this.subscribers[e].onChange(this._calcState(e))}else 0!==i&&shmi.notify("[DataGrid '<%= name %>'] Failed to load from database (error code: <%= errc %>, message: <%= message %>, category: <%= category %>)","${V_ERROR}",{name:o.name,errc:i.errc,message:i.message,category:i.category});this._nextTask()}.bind(this)},_nextTask:function(){var e=this;if(this.taskQueue.length>0){var t=this.taskQueue.shift();switch(t.type){case"query":!0===shmi.visuals.session.config.debug&&console.log("QUERY TASK"),this._doQuery();break;case"load":!0===shmi.visuals.session.config.debug&&console.log("LOAD TASK"),this._loadData(t.subID),clearTimeout(this._loadTO),this._loadTO=setTimeout((function(){console.error("task timeout",t),e._nextTask()}),this.loadTimeout);break;case"refresh":!0===shmi.visuals.session.config.debug&&console.log("REFRESH TASK - DISABLED");break;case"delete":!0===shmi.visuals.session.config.debug&&console.log("DELETE TASK"),this._doDelete(t.rowID);break;case"delete-all":!0===shmi.visuals.session.config.debug&&console.log("DELETE-ALL TASK"),this._doDeleteAll();break;default:shmi.notify("Unknown task type '<%= task_type %>","${V_ERROR}",{task_type:t.type})}}},_doDelete:function(e){void 0!==e?e>=0?shmi.visuals.session.QueryManager.deleteRow(this.table,e,function(){shmi.log("[DataGrid '"+this.name+"'] deleted row from DB "+this.db,2),this._nextTask()}.bind(this),this.db):(shmi.log("[DataGrid '"+this.name+"'] invalid ROW-ID "+e,2),this._nextTask()):(shmi.log("[DataGrid '"+this.name+"'] invalid Grid-Data-ID "+e,2),this._nextTask())},_doDeleteAll:function(){void 0!==this.q_id&&shmi.visuals.session.QueryManager.queries[this.q_id].deleteQuery(),this._nextTask()}},shmi.pkg("visuals.core"),shmi.visuals.core.DataGridDynamic=function(e,t,i,s,n,r){this.name=e,this.fields=t||[],this.type="DYNAMIC",this.data={},this.subscribers={},this.create_index=!0===i,this.index_name=void 0!==s?s:"INDEX",this.index_begin=void 0!==n?n:0,this.prefix="virtual:grid:"+this.name+":",this.totalRows=0,this.order="",this.filter={chaining:"AND"},this.indexFields=r||[],this.nextRowId=0,this.length_sub_id=null,this.item_def_lid=null,this.update_all_TO=null,this.indexMap={},this.indexFieldIndices=[],this.init()},shmi.visuals.core.DataGridDynamic.prototype={getChangeHandler:function(e,t){const i=this;return(s,n,r)=>{if(i.data[e][t].item){i.data[e][t].item.adapter&&(s=i.data[e][t].item.readValue(!0));try{const n=i.data[e][t].value;i.data[e][t].value=s,n!==s&&shmi.fire("grid-changed",{grid:i,row:e,cell:t,field:i.fields[t],lastValue:i.data[e][t].value,value:s},i)}catch(e){shmi.log("[DataGrid '"+i.name+"'] failed to update value: "+e,2)}}}},getIndexString:function getIndexString(e){return JSON.stringify(this.indexFieldIndices.map(t=>this.data[e][t].value))},init:function(){!0===this.create_index&&-1===this.fields.indexOf(this.index_name)&&this.fields.push(this.index_name);const e=[];this.indexFields.forEach(t=>{const i=this.fields.indexOf(t);-1!==i?e.push(i):shmi.log("[DataGrid '"+this.name+"'] index field not found: "+t,3)}),this.indexFieldIndices=e},setFields:function(e){this.fields=e,this.init()},getFields:function(){return this.fields},getIndexFields:function(){return this.indexFieldIndices},getRowIndex:function(e){return this.data[e]?this.indexFieldIndices.map(t=>this.data[e][t].value):null},searchIndexRowId:function(e){const t=this.indexMap[JSON.stringify(e)];return"number"==typeof t?t:-1},searchIndexFields:function(e,t,i){var s=this,n=0;return!!s.data[e]&&(t.forEach((function(t,r){s.data[e][t]&&s.data[e][t].value===i[r]&&n++})),n>0&&n===t.length)},setFilterChaining:function(e){"OR"===e||"AND"===e?this.filter.chaining=e:console.error("[DataGridDynamic] invalid filter chaining mode:",e)},insertRow:function(e,t,i){var s=this,n=0;n=void 0!==t?t:s.nextRowId++;const r=s.indexFieldIndices;if(r.length&&s.data[n]){const e=this.getIndexString(n);s.indexMap[e]===n&&delete s.indexMap[e]}s.data[n]=shmi.cloneObject(e),r.length&&(s.indexMap[this.getIndexString(n)]=n);for(var o=0;o<e.length;o++){var a=e[o],l="virtual:grid:"+s.name+":"+n+":"+o;s.data[n][o].item=shmi.createVirtualItem(l,a.type,a.min,a.max,a.value,s.getChangeHandler(n,o)),s.data[n][o].item.setDataGridInfo(s.name,n,o)}if(s.create_index){var u={type:shmi.c("TYPE_INT"),value:s.index_begin+(Object.keys(s.data).length-1),min:Number.NaN,max:Number.NaN,item:null,item_name:"virtual:grid:"+s.name+":"+n+":"+e.length};u.item=shmi.createVirtualItem(u.item_name,u.type,u.min,u.max,u.value,()=>{}),u.item.setDataGridInfo(s.name,n,e.length),s.data[n].push(u)}return"function"==typeof s.onInsert?s.onInsert(e,t,i,(function(){i||s._updateSubscriber(),shmi.fire("grid-insert-row",{rowId:n,rowData:s.data[n],grid:s})})):(i||s._updateSubscriber(),shmi.fire("grid-insert-row",{rowId:n,rowData:s.data[n],grid:s})),n},deleteRow:function(e){const t=this,i=shmi.visuals.session.ItemManager,s=t.indexFieldIndices;if(shmi.objectHasOwnProperty(t.data,e)){t.data[e].forEach((function(e){e.item&&(i.removeItem(e.item.name),delete e.item)}));const n=t.data[e];s.length&&t.data[e]&&delete t.indexMap[t.getIndexString(e)],delete t.data[e],"function"==typeof t.onDelete?t.onDelete(e,(function(){t._updateSubscriber(),shmi.fire("grid-delete-row",{rowId:e,rowData:n,grid:t})})):(t._updateSubscriber(),shmi.fire("grid-delete-row",{rowId:e,rowData:n,grid:t}))}},deleteAll:function(){var e=this,t=shmi.visuals.session.ItemManager;shmi.requires("visuals.tools.iterate.iterateObject")(e.data,(function(i,s){e.data[s].forEach((function(e){e.item&&(t.removeItem(e.item.name),delete e.item)})),delete e.data[s]})),e.totalRows=0,e.nextRowId=0,e.indexMap={},"function"==typeof e.onDeleteAll?e.onDeleteAll((function(){e._updateSubscriber(),shmi.fire("grid-delete-all",{grid:e})})):(e._updateSubscriber(),shmi.fire("grid-delete-all",{grid:e}))},subscribePage:function(e,t,i){for(var s=this,n=Date.now();void 0!==s.subscribers[n];)n++;var r={};r.id=n,r.offset=e,r.size=t,r.onChange=i,s.subscribers[n]=r;var o={};return o.id=n,o.prefix=s.prefix,"function"==typeof this.onSubscribe?this.onSubscribe(e,t,(function(){s._updateSubscriber(n)})):s._updateSubscriber(n),o},_updateSubscriber:function(e){var t=this,i=shmi.requires("visuals.tools.iterate.iterateObject");void 0!==e?shmi.decouple((function(){if(void 0!==t.subscribers[e]){var i=t._calcState(e);t.subscribers[e].onChange(i)}})):(clearTimeout(t.update_all_TO),t.update_all_TO=setTimeout((function(){i(t.subscribers,(function(e,i){var s=t._calcState(i);t.subscribers[i].onChange(s)}))}),shmi.c("DECOUPLE_TIMEOUT")))},unsubscribe:function(e){delete this.subscribers[e]},setOffset:function(e,t){var i=this;void 0!==i.subscribers[t]&&(i.subscribers[t].offset=e,"function"==typeof i.onSetOffset?i.onSetOffset(e,t,(function(){var e=i._calcState(t);i.subscribers[t].onChange(e)})):shmi.raf((function(){var e=i._calcState(t);i.subscribers[t].onChange(e)})))},getRowCount:function(){return this.totalRows},setFilter:function(e,t){var i=this;"function"==typeof i.onSetFilter?i.onSetFilter(e,t,(function(){shmi.fire("grid-set-filter",{grid:i,type:i.type,column:e,field:i.fields[e],expression:t})})):shmi.fire("grid-set-filter",{grid:i,type:i.type,column:e,field:i.fields[e],expression:t})},getFilters:function(){},clearFilter:function(e){var t=this;"function"==typeof t.onClearFilter?t.onClearFilter(e,(function(){shmi.fire("grid-clear-filter",{grid:t,type:t.type,column:e,field:void 0===t.fields[e]?null:t.fields[e]})})):shmi.fire("grid-clear-filter",{grid:t,type:t.type,column:e,field:void 0===t.fields[e]?null:t.fields[e]})},refresh:function(){var e=this;"function"==typeof e.onRefresh?e.onRefresh((function(){shmi.fire("grid-refresh",{grid:e,type:e.type})})):shmi.fire("grid-refresh",{grid:e,type:e.type})},sort:function(e,t){var i=this;"function"==typeof i.onSort?i.onSort(e,t,(function(){shmi.fire("grid-sort",{grid:i,type:i.type,column:e,field:i.fields[e],order:t})})):shmi.fire("grid-sort",{grid:i,type:i.type,column:e,field:i.fields[e],order:t})},getCurrentIDs:function(e){var t=[],i=this.subscribers[e];if(void 0!==i)for(var s=this.totalRows<i.offset+i.size?this.totalRows:i.offset+i.size,n=i.offset;n<s;n++)t.push(n);return t},getAllIDs:function(e){for(var t=[],i=0;i<this.totalRows;i++)t.push(i);return t},getRowData:function(e){return this.data[e]?this.data[e]:null},_calcState:function(e){this.totalRows=Object.keys(this.data).length;var t=this.subscribers[e],i={status:"OK"};return i.offset=t.offset,i.totalRows=this.totalRows,i}},function(){function alarmCallback(e,t,i){i&&updateDataGrid(e,!0)}function makeRowFromAlarmInfo(e,t,i,s){const n=shmi.requires("visuals.tools.numericValues"),r=shmi.visuals.tools.unitClasses,o=[];t.items=t.context,t.items.forEach(e=>{Object.defineProperty(e,"formattedValue",{enumerable:!0,configurable:!1,get:()=>"number"==typeof e.value?n.formatNumber(e.value,{precision:e.digits,unit:e.unit,"show-unit":!1}):e.value}),Object.defineProperty(e,"unitText",{enumerable:!0,configurable:!1,get:()=>{if("number"==typeof e.unit){const t=r.getSelectedAdapter(e.unit);if(t)return t.unitText}return e.unit}})}),e.fields.forEach((function(e,i){const s=function getFieldValue(e,t){switch(t){case"id":return e.id;case"status":return e.acknowledgeable&&!e.acknowledged;case"json":return JSON.stringify(e);case"title":return shmi.evalString(shmi.localize(`\${alarm_title_${e.index}}`),e);case"group_title":return shmi.evalString(shmi.localize(`\${alarm_group_${e.group}}`),e);default:return void 0!==e[t]?e[t]:null}}(t,e);switch(typeof s){case"string":o.push({type:shmi.c("TYPE_STRING"),value:s,min:null,max:null});break;case"boolean":o.push({type:shmi.c("TYPE_BOOL"),value:s?1:0,min:0,max:1});break;case"number":o.push({type:shmi.c("TYPE_FLOAT"),value:s,min:Number.NaN,max:Number.NaN});break;default:o.push({type:shmi.c("TYPE_STRING"),value:"NULL",min:Number.NaN,max:Number.NaN})}})),e.insertRow(o,i,!s)}function updateDataGrid(e,t){const i=shmi.requires("visuals.tools.iterate").iterateObject;!0!==t&&(i(e.subscribers,(function(t,i){e.subscribers[i].offset=0})),e.reqOffset=0),e.isQueryRunning?e.needAnotherQuery=!0:function sendAlarmQuery(e){const t=shmi.requires("visuals.tools.connect").request;let i={mode:e.displayMode,sort:e.filterSort,limit:e.reqSize,offset:e.reqOffset};i=function attachFilter(e,t){const i=t.fields[3],s=t.fields[4];if((t.filter[i]||t.filter[s])&&(e.filter={mode:"AND",clauses:[]},t.filter[s]&&e.filter.clauses.push({mode:"AND",column:s,location:"property",clauses:[{operator:">=",value:1e7*t.filter[s][0]},{operator:"<",value:1e7*t.filter[s][1]}]}),t.filter[i])){const s={mode:"OR",column:i,location:"property",clauses:[]};t.filter[i].forEach((function(e){s.clauses.push({operator:"=",value:e})})),e.filter.clauses.push(s)}return e}(i,e),e.isQueryRunning=!0,e.needAnotherQuery=!1,t("alarm.query",i,(function onRequest(t,i){if(e.isQueryRunning=!1,e.needAnotherQuery&&sendAlarmQuery(e),i)console.error("[AlarmManager] getAllAlarms failed:",i.category,i.errc,i.message);else{e.data={},t.alarms.forEach((function(t,i){makeRowFromAlarmInfo(e,t,i,!1)})),e.totalRows=t.total_count;const i=Date.now();e.stateTO&&clearTimeout(e.stateTO),e.stateTO=0,i-e.lastStateUpdate>e.refreshTimeout?shmi.decouple(e.updateSubscribers.bind(e)):e.stateTO=setTimeout(e.updateSubscribers.bind(e),e.refreshTimeout)}}))}(e)}shmi.pkg("visuals.core"),shmi.visuals.core.DataGridIQAlarms=function(e,t){this.name=t,this.fields=["id","index","status","severity","timestamp_in","active","timestamp_out","group","json","title","group_title"],this.type="ALARMS",this.data={},this.subscribers={},this.prefix="virtual:grid:"+this.name+":",this.totalRows=0,this.order=[0,"ASC"],this.filter={},this.defaultSort=[{column:"timestamp_in",order:"DESC"}],this.filterSort=this.defaultSort,this.defaultOffset=0,this.defaultSize=500,this.reqOffset=this.defaultOffset,this.reqSize=this.defaultSize,this._subID=null,this.AM=shmi.visuals.session.AlarmManager,this.indexFields=["id"],this.lastStateUpdate=0,this.stateTO=0,this.singleStateTO=0,this.displayMode=e,this.refreshTimeout=150,this.isQueryRunning=!1,this.needAnotherQuery=!1,this.indexMap={},this.indexFieldIndices=[],this.init()},shmi.visuals.core.DataGridIQAlarms.prototype={getIndexString:function getIndexString(e){return JSON.stringify(this.indexFieldIndices.map(t=>this.data[e][t].value))},init:function(){const e=[];this.indexFields.forEach(t=>{const i=this.fields.indexOf(t);-1!==i?e.push(i):shmi.log("[DataGrid '"+this.name+"'] index field not found: "+t,3)}),this.indexFieldIndices=e},setDisplayMode:function(e){this.displayMode=e,updateDataGrid(this,!1)},subscribePage:function(e,t,i){const s=this;let n=Date.now();for(s.reqOffset=e,s.reqSize=t;void 0!==s.subscribers[n];)n++;return s.subscribers[n]={id:n,offset:e,size:t,onChange:i,lastUpdate:0},1===Object.keys(s.subscribers).length&&("live"!==s.displayMode&&updateDataGrid(s,!1),s._subID=s.AM.subscribeAlarms(s,alarmCallback.bind(null,s))),shmi.decouple((function(){s.subscribers[n].lastUpdate=Date.now(),s.subscribers[n].onChange(s._calcState(n))})),{id:n,prefix:s.prefix}},getFields:function(e){return this.fields},getIndexFields:function(){return this.indexFieldIndices},getRowIndex:function(e){return this.data[e]?this.indexFieldIndices.map(t=>this.data[e][t].value):null},searchIndexRowId:function(e){const t=this.indexMap[JSON.stringify(e)];return"number"==typeof t?t:-1},searchIndexFields:function(e,t,i){const s=this;let n=0;return!!s.data[e]&&(t.forEach((function(t,r){s.data[e][t]&&s.data[e][t].value===i[r]&&n++})),n>0&&n===t.length)},insertRow:function(e,t){const i=this,s=t;if(void 0===t)return console.error("DataGridIQAlarms","no row-index specified on insertRow"),null;const n=i.indexFieldIndices;return n.length&&i.data[s]&&delete i.indexMap[this.getIndexString(s)],void 0===this.data[s]&&(this.data[s]=e),e.forEach((e,t)=>{const i=`virtual:grid:${this.name}:${s}:${t}`;this.data[s][t].item=function createVirtualItem(e,t,i,s,n){const r=shmi.requires("visuals.session.ItemManager").getItem(t);let o=null;return r&&r.initialized?(r.readValue()!==i.value&&r.writeValue(i.value),r):(o=shmi.createVirtualItem(t,i.type,i.min,i.max,i.value,null),o.setDataGridInfo(this.name,s,n),o)}(0,i,e,s,t),this.data[s][t].value=e.value}),n.length&&(i.indexMap[this.getIndexString(s)]=s),s},deleteRow:function(e){Array.isArray(e)?e.forEach(e=>{void 0!==this.data[e]?this.AM.ackAlarm(this.data[e][0].value):shmi.log("[DataGridIQAlarms] alarm not found row-id="+e,2)}):void 0!==this.data[e]?this.AM.ackAlarm(this.data[e][0].value):shmi.log("[DataGridIQAlarms] alarm not found row-id="+e,2)},deleteAll:function(){this.AM.ackAlarm(-1)},unsubscribe:function(e){const t=this,i=shmi.visuals.session.config,s=shmi.requires("visuals.tools.iterate").iterateObject;delete t.subscribers[e],0===Object.keys(t.subscribers).length&&i&&i["disable-alarm-prefetch"]&&(t.AM.unsubscribeAlarms(t._subID),s(t.data,(function(e,i){for(let e=0;e<t.data[i].length;e++)shmi.visuals.session.ItemManager.removeItem(t.data[i][0].item.name);delete t.data[i]})),t.indexMap={})},setOffset:function(e,t){const i=this,s=i.subscribers[t];void 0!==s&&(e>i.totalRows&&(e=i.totalRows),i.reqOffset=e,s.offset=e,updateDataGrid(i,!0))},getRowCount:function(){return this.totalRows},setFilter:function(e,t){this.filter[this.fields[e]]=t,updateDataGrid(this,!1)},getFilters:function(){const e=this;return e.fields.map(t=>e.filter[t]||null)},clearFilter:function(e){delete this.filter[this.fields[e]],updateDataGrid(this,!1)},updateSubscribers:function(){!function updateSubscribers(e){const t=shmi.requires("visuals.tools.iterate").iterateObject,i=Date.now();t(e.subscribers,(function(t,s){e.subscribers[s].lastUpdate=i,e.subscribers[s].onChange(e._calcState(s))})),e.lastStateUpdate=i}(this)},sort:function(e,t,i){const s=this;s.filterSort=-1===e?s.defaultSort:[{column:s.fields[e],order:t}],updateDataGrid(s,i)},getCurrentIDs:function(e){const t=[],i=this.subscribers[e],s=Object.keys(this.data);for(let e=0;e<i.size&&void 0!==s[e];e++)t.push(parseInt(s[e]));return t},getAllIDs:function(e){return Object.keys(this.data).map(e=>parseInt(e))},getRowData:function(e){return void 0!==this.data[e]?this.data[e]:null},_calcState:function(e){const t=this.subscribers[e];return{status:"OK",totalRows:this.totalRows,offset:Math.min(t.offset,Math.max(this.totalRows-1,0))}}}}(),shmi.pkg("visuals.core"),shmi.visuals.core.DataGridManager=function(){this.grids={},this.initialized=!1,this.loadGridMap()},shmi.visuals.core.DataGridManager.prototype={restart:function(){var e=this;shmi.requires("visuals.tools.iterate.iterateObject")(e.grids,(function(t,i){e.grids[i].init()}))},loadGridMap:function(){shmi.loadResource(shmi.c("DGM_GRID_MAP_PATH"),this.applyGridMap.bind(this))},applyGridMap:function(e,t,i){this.config=this.config||{};var s=new shmi.visuals.core.DataGridAlarms;if(this.grids.alarms=s,this.grids["alarms-historic"]=new shmi.visuals.core.DataGridAlarmsHistoric,t)shmi.log("[GridManager] grid map not found - 404",2),this.grid_map=[],this.applyGrid("",!0);else{this.grid_map={};try{this.grid_map=JSON.parse(e,i).grids}catch(e){console.error("[DataGridManager] failed to parse datagrid map:",i,e)}Array.isArray(this.grid_map)&&this.grid_map.length>0?this.loadGrid():(this.grid_map=[],this.applyGrid("",!0))}},loadGrid:function(){shmi.loadResource(shmi.evalString(shmi.c("GRID_PATH_PATTERN"),{name:this.grid_map.shift()}),this.applyGrid.bind(this))},getGrid:function(e){return void 0!==this.grids[e]?this.grids[e]:null},subscribePage:function(e,t,i,s){return void 0!==this.grids[e]&&this.grids[e].subscribePage?this.grids[e].subscribePage(t,i,s):null},setOffset:function(e,t,i){void 0!==this.grids[e]&&this.grids[e].setOffset&&this.grids[e].setOffset(t,i)},sort:function(e,t,i){void 0!==this.grids[e]&&this.grids[e].sort&&this.grids[e].sort(t,i)},setFilter:function(e,t,i){void 0!==this.grids[e]&&this.grids[e].setFilter&&this.grids[e].setFilter(t,i)},setFilterChaining:function(e,t){void 0!==this.grids[e]&&this.grids[e].setFilterChaining&&this.grids[e].setFilterChaining(t)},clearFilter:function(e,t){void 0!==this.grids[e]&&this.grids[e].clearFilter&&this.grids[e].clearFilter(t)},deleteAll:function(e){void 0!==this.grids[e]&&this.grids[e].deleteAll&&this.grids[e].deleteAll()},getCurrentIDs:function(e,t){return void 0!==this.grids[e]&&this.grids[e].getCurrentIDs?this.grids[e].getCurrentIDs(t):[]},getAllIDs:function(e,t){return void 0!==this.grids[e]&&this.grids[e].getAllIDs?this.grids[e].getAllIDs(t):[]},getFields:function(e){return void 0!==this.grids[e]&&this.grids[e].getFields?this.grids[e].getFields():[]},getFilters:function(e){var t=null;return void 0!==this.grids[e]&&this.grids[e].getFilters&&(t=this.grids[e].getFilters()),t},getRowCount:function(e){return void 0!==this.grids[e]&&this.grids[e].getRowCount?this.grids[e].getRowCount():-1},applyGrid:function(e,t,i){if(t)void 0!==i&&shmi.log("[GridManager] grid data ["+i+"] not found - 404",2);else{var s={};try{s=JSON.parse(e)}catch(e){console.error("[DataGridManager] failed to parse datagrid config:",i,e)}void 0===s.type?console.error("[DataGridManager]","no grid type configured:",i):"DB"===s.type||"DB2"===s.type?this.grids[s.name]=new shmi.visuals.core.DataGridDB(s.name,shmi.c(s.db),s.table,s.fields,s.conditions,s.indexFields):"DYNAMIC"===s.type?this.grids[s.name]=new shmi.visuals.core.DataGridDynamic(s.name,s.fields,s.create_index_column,s.index_name,s.index_begin,s.indexFields):"RECIPE"===s.type&&(this.grids[s.name]=new shmi.visuals.core.DataGridRecipe(s.name,s.recipe_template_id)),shmi.log("[GridManager] grid '"+s.name+"' loaded",1)}this.grid_map.length>0?this.loadGrid():(this.initialized=!0,shmi.fire("datagrid-manager",{ready:this.initialized},this))},subscribe:function(e,t){return void 0===this.grids[e]&&(shmi.log("[GridManager] subscribe - grid '"+e+"' not found",2),this.grids[e]=new shmi.visuals.core.DataGrid(e,{})),this.grids[e].subscribe(t)},unsubscribe:function(e,t){void 0!==this.grids[e]?this.grids[e].unsubscribe(t):shmi.log("[GridManager] unsubscribe - grid '"+e+"' not found",2)},deleteRow:function(e,t){void 0!==this.grids[e]?this.grids[e].deleteRow(t):shmi.log("[GridManager] deleteRow - grid '"+e+"' not found",2)},insertRow:function(e,t){var i=null;return void 0!==this.grids[e]?i=this.grids[e].insertRow(t):shmi.log("[GridManager] insertRow - grid '"+e+"' not found",2),i},getRowData:function(e,t){var i=null;return void 0!==this.grids[e]?i=this.grids[e].getRowData(t):shmi.log("[GridManager] getRowData - grid '"+e+"' not found",2),i},getColumnData:function(e,t){var i=null;return void 0!==this.grids[e]?i=this.grids[e].getColumnData(t):shmi.log("[GridManager] getColumnData - grid '"+e+"' not found",2),i},loadGridFromDB:function(e,t,i,s,n,r,o){for(var a=[],l=0;l<i.length;l++)a.push(i[l]);var u=shmi.visuals.session;n=n||shmi.c("DB_HMI_RO");var c=new shmi.visuals.core.DataGrid(e,{},r,o,"DB");if(shmi.def(this.grids,e,c),void 0===this.grids[e].fields||0===this.grids[e].fields.length){for(var h=[],m=0;h.length<a.length;)h.push(a[m]),m++;this.grids[e].fields=h}function getFieldData(e){var t=e.replace(/^,/,'" ",');for(t=(t=t.replace(/,$/,'," "')).replace(/""/g,'" "');t.replace(/,,/g,'," ",')!==t;)t=t.replace(/,,/g,'," ",');return t.match(/[^"]+(?=(",)|"$)/g)}if(Array.isArray(a)){var d=!1;void 0!==u.DataGridManager.grids[e].fields?a.length===u.DataGridManager.grids[e].fields.length&&(a.push("ROWID"),d=!0):(a.push("ROWID"),d=!0),!0===d&&shmi.log("[DataGridManager] adding ROWID to fields list",shmi.c("LOG_INFO"))}u.QueryManager.queryDirect((function(t,i){shmi.log("[DataGridManager] status: "+t,shmi.c("LOG_INFO")),shmi.log("[DataGridManager] query: "+i,shmi.c("LOG_INFO")),u.DataGridManager.grids[e].query=i;var s=i.datalength;u.DataGridManager.grids[e].totalRows=s,shmi.log("TOTAL RESULTS: "+s,1);for(;0<Object.keys(i.data).length;){for(var n=getFieldData(i.data[0]),r=[],o=-1,a=0;a<n.length;a++)if(a===n.length-1)o=parseInt(n[a]);else{var c={};c.type=shmi.c("TYPE_STRING"),c.value=n[a],c.min=Number.NaN,c.max=Number.NaN,r.push(c)}var h=u.DataGridManager.insertRow(e,r);u.DataGridManager.grids[e].data[h].rowID=o,l++}u.DataGridManager.grids[e].dbID=i.dbId,u.DataGridManager.grids[e].dbTable=i.table,shmi.log("[DataGridManager] grid '"+e+"' loaded",shmi.c("LOG_MSG"))}),t,a,s,n,o,0)},saveRowToDB:function(e,t,i){if(void 0!==this.grids[e]&&Array.isArray(this.grids[e].fields)){for(var s,n,r=[],o=[],a=this.grids[e].getRowData(t),l="DB2"===this.grids[e].type?this.grids[e].db:this.grids[e].dbID,u=0;u<a.length;u++)" "===a[u].value?r.push(null):r.push(a[u].value),o.push(this.grids[e].fields[u]);shmi.log("[DataGridManager] fields: "+o,shmi.c("LOG_INFO")),shmi.log("[DataGridManager] values: "+r,shmi.c("LOG_INFO")),!0===i?(s="DB2"===this.grids[e].type?this.grids[e].table:this.grids[e].dbTable,n=shmi.visuals.session.QueryManager.insert(s,o,r,function(i,s){this.grids[e].data[t].rowID=s,0!==i?(shmi.notify("Insert record failed with status: "+i+" Row-ID: "+s),this.grids[e].deleteRow(t)):this.grids[e].refresh(),shmi.visuals.session.QueryManager.queries[n].close()}.bind(this),l)):(s="DB2"===this.grids[e].type?this.grids[e].table:this.grids[e].dbTable,n=shmi.visuals.session.QueryManager.update(s,o,r,a.rowID,(function(e,t){0!==e&&shmi.notify("Status (update): "+e),shmi.visuals.session.QueryManager.queries[n].close()}),l))}}},function(){shmi.pkg("visuals.core");var e={error:console.error.bind(console,"[DataGridRecipe]"),warn:console.warn.bind(console,"[DataGridRecipe]"),log:console.log.bind(console,"[DataGridRecipe]"),debug:console.debug.bind(console,"[DataGridRecipe]")},t=1;function makeRowDataFromRecipe(e){return shmi.checkArg("recipe",e,"shmi.visuals.core.Recipe"),[{type:shmi.c("TYPE_INTEGER"),value:e.id,min:Number.NaN,max:Number.NaN},{type:shmi.c("TYPE_STRING"),value:e.name,min:Number.NaN,max:Number.NaN},{type:shmi.c("TYPE_STRING"),value:e.comment,min:Number.NaN,max:Number.NaN},{type:shmi.c("TYPE_BOOL"),value:"number"==typeof e.versionId?1:0,min:Number.NaN,max:Number.NaN}]}function makeRow(e,t,i){var s=shmi.visuals.session.ItemManager;shmi.checkArg("self",e,"shmi.visuals.core.DataGridRecipe"),shmi.checkArg("rowId",t,"number"),shmi.checkArg("rowData",i,"array"),e.totalRows++,e.data[t]=i,i.forEach((function(e,i){var n=this.prefix+t+":"+i,r=s.getItem(n);r&&r.initialized?(e.item=r,r.setValue(e.value)):(e.item=shmi.createVirtualItem(n,e.type,e.min,e.max,e.value,function(e,t,i,s,n){var r=this.getRowData(e);r&&r[t]&&(r[t].value=i)}.bind(this,t,i)),e.item.setDataGridInfo(this.name,t,i)),e.item.writable=!1}),e)}function calcState(e,t){return shmi.checkArg("self",e,"shmi.visuals.core.DataGridRecipe"),shmi.checkArg("subID",t,"object"),t?{status:"OK",offset:t.offset,size:t.size,totalRows:e.totalRows}:{status:"FAILED",totalRows:e.totalRows||0}}function delayedRefresh(e){shmi.checkArg("self",e,"shmi.visuals.core.DataGridRecipe"),null!==e.refreshTimeout&&clearTimeout(e.refreshTimeout),e.refreshTimeout=setTimeout(e.refresh.bind(e),shmi.c("ACTION_RETRY_TIMEOUT"))}function pushTask(e,t){shmi.checkArg("self",e,"shmi.visuals.core.DataGridRecipe"),shmi.checkArg("task",t,"object"),e.taskQueue.push(t),processTaskQueue(e)}function taskDelete(e,t){shmi.checkArg("self",e,"shmi.visuals.core.DataGridRecipe"),shmi.checkArg("task",t,"object");var i=e.rowObjectData[t.rowID];return!!i&&(i.delete(onTaskDone.bind(null,e)),!0)}function taskFetchAll(t,i){shmi.checkArg("self",t,"shmi.visuals.core.DataGridRecipe"),shmi.checkArg("task",i,"object");var s,n,r=shmi.requires("visuals.session.RecipeManager"),o=shmi.requires("visuals.task");function onComplete(){var e=shmi.requires("visuals.tools.iterate.iterateObject");onTaskDone(t,null),e(t.subscribers,doRefreshSubscriber.bind(null,t))}return 0===(s=function calculateRequestRanges(e){var t=[],i=[],s=shmi.requires("visuals.tools.iterate.iterateObject");return shmi.checkArg("self",e,"shmi.visuals.core.DataGridRecipe"),s(e.subscribers,(function(e){i.push(e)})),i.sort((function(e,t){return t.offset-e.offset})).forEach((function(e,i){if(0!==i){var s=t[t.length-1];s.end<e.offset?t.push({begin:e.offset,end:e.offset+e.size}):s.end<e.offset+e.size&&(e.end=e.offset+e.size)}else t.push({begin:e.offset,end:e.offset+e.size})})),t}(t).map((function(i){var s=o.createTask("fetch-"+i.begin+"-"+i.end);return s.run=function run(){r.listRecipes(t.recipeTemplateId,{filter:buildFilterExpression(t),sort:buildSortExpression(t),offset:i.begin,limit:i.end-i.begin,include_metadata:!1,include_values:!0},(function(n,r){r?(e.error("Error while loading recipe data",r),s.fail()):(t.totalRows=0,n.recipes.forEach((function(e,s){t.rowObjectData[i.begin+s]=e,makeRow(t,i.begin+s,makeRowDataFromRecipe(e))})),s.complete(),shmi.fire("datagrid-ready",{}))}))},s}))).length?onComplete():((n=o.createTaskList(s)).onComplete=onComplete,n.run()),!0}function taskLoad(t,i){return shmi.checkArg("self",t,"shmi.visuals.core.DataGridRecipe"),shmi.checkArg("task",i,"object"),shmi.requires("visuals.session.RecipeManager").listRecipes(t.recipeTemplateId,{filter:buildFilterExpression(t),sort:buildSortExpression(t),offset:i.offset,limit:i.size,include_metadata:!1,include_values:!0},(function(s,n){n?e.error("Error while loading recipe data",n):s.recipes.forEach((function(e,s){t.rowObjectData[i.offset+s]=e,makeRow(t,i.offset+s,makeRowDataFromRecipe(e))})),onTaskDone(t,null)})),!0}function executeTask(t,i){shmi.checkArg("self",t,"shmi.visuals.core.DataGridRecipe"),shmi.checkArg("task",i,"object");var s={delete:taskDelete.bind(null,t),fetch_all:taskFetchAll.bind(null,t),load:taskLoad.bind(null,t)}[i.type];s?(t.tasksRunning++,i.serialized&&(t.tasksJoin=!0),s(i)||(e.error("Failed to start task",i),onTaskDone(t,null))):e.error("Unknown type for task",i.type)}function processTaskQueue(e){shmi.checkArg("self",e,"shmi.visuals.core.DataGridRecipe"),function getTasks(e,t){var i,s=[];return shmi.checkArg("self",e,"shmi.visuals.core.DataGridRecipe"),shmi.checkArg("popSerialized",t,"boolean","undefined"),0===e.taskQueue.length?[]:((i=e.taskQueue.some((function(t,i){return t.serialized&&(s=e.taskQueue.splice(0,i)),!!t.serialized})))?i&&t&&s.push(e.taskQueue.shift()):(s=e.taskQueue,e.taskQueue=[]),s)}(e,!this.tasksJoin).forEach(executeTask.bind(null,e))}function onTaskDone(t,i){shmi.checkArg("self",t,"shmi.visuals.core.DataGridRecipe"),shmi.checkArg("err",i,"object","null"),i?e.error("Task command failed",i):0===t.tasksRunning&&e.warn("tasksRunning is 0 but there are still tasks running"),0==--t.tasksRunning&&(t.tasksJoin=!1,processTaskQueue(t))}function doRefreshSubscriber(e,t){shmi.checkArg("self",e,"shmi.visuals.core.DataGridRecipe"),shmi.checkArg("sub",t,"object"),t.onChange(calcState(e,t))}function buildFilterExpression(e){return shmi.checkArg("self",e,"shmi.visuals.core.DataGridRecipe"),{mode:e.filterChaining,clauses:e.getFilters().map((function(t,i){return null===t?null:{location:"property",mode:"OR",column:e.getFields()[i],clauses:t.map((function(e){return{operator:"like",value:e}}))}})).filter((function(e){return null!==e}))}}function buildSortExpression(e){return shmi.checkArg("self",e,"shmi.visuals.core.DataGridRecipe"),null===e.order?[]:[{column:e.getFields()[e.order[0]],order:e.order[1]}]}shmi.visuals.core.DataGridRecipe=function DataGridRecipe(e,t){this.name=e,this.recipeTemplateId=t,this.type="Recipe",this.data={},this.rowObjectData={},this.subscribers={},this.prefix="virtual:grid:"+this.name+":",this.nextRowID=0,this.totalRows=0,this.order=null,this.filter={},this.filterChaining="AND",this.taskQueue=[],this.tasksRunning=0,this.tasksJoin=!1,this.refreshTimeout=null},shmi.visuals.core.DataGridRecipe.prototype={constructor:shmi.visuals.core.DataGridRecipe,init:function(){this.taskQueue=[],this.subscribers={}},subscribePage:function(e,i,s){shmi.checkArg("offset",e,"number"),shmi.checkArg("size",i,"number"),shmi.checkArg("onChange",s,"function");var n={id:t++,offset:e,size:i,onChange:s};this.subscribers[n.id]=n;var r={id:n.id,prefix:this.prefix};return pushTask(this,{type:"load",offset:e,size:i}),r},getFields:function(){return["recipe_id","recipe_name","comment","values_set"]},getIndexFields:function(){return[0]},getRowIndex:function(e){shmi.checkArg("rowId",e,"number");var t=this.getRowData(e);return t?this.getIndexFields().map((function(e){return t[e].value})):null},searchIndexRowId:function(e){var t=this.getIndexFields(),i=-1;return shmi.checkArg("rowIndex",e,"array"),Object.keys(this.data).some(function(s){return!!this.searchIndexFields(parseInt(s),t,e)&&(i=s,!0)}.bind(this)),i},searchIndexFields:function(e,t,i){return shmi.checkArg("row",e,"number"),shmi.checkArg("fields",t,"array"),shmi.checkArg("rowIndex",i,"array"),t.length>0&&this.data[e].every((function(e,t){return e.value===i[t]}))},insertRow:function(e,t){var i=shmi.requires("visuals.tools.iterate").iterateObject,s=this.nextRowID++;return shmi.checkArg("rowData",e,"array"),makeRow(this,s,e),t||i(this.subscribers,function(e){e.onChange(calcState(this,e))}.bind(this)),s},deleteRow:function(e){shmi.checkArg("rowID",e,"number","array"),(Array.isArray(e)?e:[e]).forEach((function(e){pushTask(this,{type:"delete",rowID:parseInt(e)})}),this),pushTask(this,{type:"fetch_all",serialized:!0})},deleteAll:function(){this.deleteRow(Object.keys(this.rowObjectData))},unsubscribe:function(e){var t=shmi.requires("visuals.session.ItemManager"),i=shmi.requires("visuals.tools.iterate.iterateObject");shmi.checkArg("subID",e,"number"),delete this.subscribers[e],0===Object.keys(this.subscribers).length&&(i(this.data,(function(e){e.forEach((function(e){t.removeItem(e.item.name)}))})),this.data={},this.rowObjectData={})},setOffset:function(e,t){shmi.checkArg("offset",e,"number"),shmi.checkArg("subID",t,"number"),void 0!==this.subscribers[t]&&(this.subscribers[t].offset=e,pushTask(this,{type:"load",subID:t}))},getRowCount:function(){return this.totalRows},setFilter:function(e,t){this.filter[this.getFields()[e]]=t,delayedRefresh(this)},setFilterChaining:function(t){shmi.checkArg("chaining",t,"string"),"OR"===t||"AND"===t?(this.filterChaining=t,delayedRefresh(this)):e.error("Invalid filter chaining mode:",t)},getFilters:function(){return this.getFields().map(function(e){return shmi.objectHasOwnProperty(this.filter,e)?this.filter[e]:null}.bind(this))},refresh:function(){(0,shmi.requires("visuals.tools.iterate").iterateObject)(this.subscribers,(function(e){e.offset=0})),this.data={},this.rowObjectData={},this.totalRows=0,pushTask(this,{type:"fetch_all",serialized:!0})},clearFilter:function(e){var t=!1;shmi.checkArg("col",e,"number"),-1===e?(t=Object.keys(this.filter).length>0,this.filter={}):void 0!==this.filter[this.getFields()[e]]&&(delete this.filter[this.getFields()[e]],t=!0),t&&delayedRefresh(this)},sort:function(e,t){var i=this.order;shmi.checkArg("col",e,"number"),shmi.checkArg("col",t,"string"),this.order=-1===e?null:[e,t],this.order!==i&&delayedRefresh(this)},getCurrentIDs:function(e){shmi.checkArg("subID",e,"number");var t=this.subscribers[e];return void 0===t?[]:Object.keys(this.data).map((function(e){return parseInt(e)})).filter((function(e){return t.offset<=e&&e<t.offset+t.size}))},getAllIDs:function(){return Object.keys(this.data)},getRowData:function(e){return shmi.checkArg("rowId",e,"number"),void 0!==this.data[e]?this.data[e]:null}}}(),function(){shmi.pkg("visuals.core");const e={user:{events:["login-state"],basePath:"shmi.visuals.session.UserManager.currentUser"}};function getValueByPath(e,t){return t.split(".").reduce((e,t)=>"object"!=typeof e||null===e?null:shmi.objectHasOwnProperty(e,t)?e[t]:null,e)}function getDetailed(e,t,i){const s=function getKeyForVariable(e,t){return t.reduce((t,i)=>e===i||e.startsWith(`${i}.`)?!t||i.length>t?i:t:null)}(t,i);if(!s)return null;const n=e._propertyRegistry[s],r=t.substr(s.length+1),o=getValueByPath(window,n.basePath);return s===t?{variableName:t,basePropertyKey:s,basePropertyInfo:n,value:o}:{variableName:t,basePropertyKey:s,basePropertyInfo:n,value:getValueByPath(o,r)}}function onEventCallback(e,t){const i=Object.keys(e._propertyRegistry);e._tokens.forEach(s=>{const n=getDetailed(e,s.variableName,i);n&&n.basePropertyInfo.events.includes(t)&&(s.lastValue!==n.value||"object"==typeof n.value&&null!==n.value)&&(s.gotInitialValue=!0,s.lastValue=n.value,s.callback(n.value))})}function registerEvent(e,t){e._events.includes(t)||(e._events.push(t),e._eventListeners.push(shmi.listen(t,onEventCallback.bind(null,e,t))))}function getFreeTokenId(e){let t;do{t=Math.floor(Math.random()*Number.MAX_SAFE_INTEGER)}while(e._tokenIdSet.has(t));return e._tokenIdSet.add(t),t}shmi.visuals.core.EnvironmentManager=class EnvironmentManager{constructor(){const{iterateObject:t}=shmi.requires("shmi.visuals.tools.iterate");this._propertyRegistry={},this._tokenIdSet=new Set,this._tokens=[],this._events=[],this._eventListeners=[],t(e,({basePath:e,events:t},i)=>this.registerVariable(i,e,t))}destroy(){this._eventListeners.forEach(e=>e.unlisten()),this._eventListeners=[],this._events=[],this._tokens=[],this._tokenIdSet.clear(),this._propertyRegistry={}}registerVariable(e,t,i){if(shmi.checkArg("variableName",e,"string"),shmi.checkArg("basePath",t,"string"),shmi.checkArg("eventName",i,"string","array"),shmi.objectHasOwnProperty(this._propertyRegistry,e))throw new Error("Environment variable already registered");Array.isArray(i)||(i=[i]),this._propertyRegistry[e]={events:i,basePath:t},i.forEach(registerEvent.bind(this,this))}get(e){return shmi.checkArg("variableName",e,"string"),function getFrom(e,t,i){const s=getDetailed(e,t,i);return s?s.value:null}(this,e,Object.keys(this._propertyRegistry))}subscribe(e,t){shmi.checkArg("variableName",e,"string"),shmi.checkArg("callback",t,"function");const i={variableName:e,lastValue:null,id:getFreeTokenId(this),callback:t,active:!0,unlisten:()=>{i.active=!1;const e=this._tokens.findIndex(({id:e})=>e===i.id);e>0&&this._tokens.splice(e,1),this._tokenIdSet.delete(i.id)}};return shmi.decouple(()=>{if(!i.active||i.gotInitialValue)return;const e=this.get(i.variableName);i.gotInitialValue=!0,i.lastValue=e,i.callback(e)}),this._tokens.push(i),i}}}(),shmi.pkg("visuals.core"),shmi.visuals.core.FileManager=function(){this.transfers={},this.chunkSize=4096},shmi.visuals.core.FileManager.prototype={to_utf8:function(e){return unescape(encodeURIComponent(e))},from_utf8:function(e){return decodeURIComponent(escape(e))},save:function(e,t,i,s){for(var n=this,r=shmi.requires("visuals.tools.connect").request,o=0;void 0!==n.transfers[o];)o++;return n.transfers[o]={id:o,connect_id:null,type:"save",data:t||"",offset:0,err:null,callback:i,complete:!1,started:!1,failed:!1,utf8:!0===s},r("fs.open",{path:e,force:!0,open_mode:["out"]},(function(e,t){var i=n.transfers[o];0!==t?(i.failed=!0,i.err=t,i.callback(t.errc,i),delete n.transfers[i.id]):(i.started=!0,i.connect_id=e,function doSaveTransfer(e,t){var i=shmi.requires("visuals.tools.connect").request,s=null,n=null;t.offset>=t.data.length?i("fs.close",t.connect_id,(function onClose(i,s){s&&console.error("[FileManager] error closing file:",s),t.failed?t.callback(t.err.errc,t):t.callback(0,t),delete e.transfers[t.id]})):(s=t.data.slice(t.offset,t.offset+e.chunkSize),n=t.utf8?btoa(e.to_utf8(s)):btoa(s),i("fs.write",{file_id:t.connect_id,data:n},(function onWrite(i,s){s?(t.failed=!0,t.err=s,t.offset=t.data.length):t.offset+=e.chunkSize,doSaveTransfer(e,t)})))}(n,i))})),o}},shmi.pkg("visuals.core"),shmi.visuals.core.IfItemSubscriber=function(){},shmi.visuals.core.IfItemSubscriber.prototype={},function(){var e,t=shmi.pkg("visuals.core"),i={},s=(e="[visuals.core.Item]  ",e+=" ".repeat(Math.max(0,e.length-20)),console.error.bind(console,e));function queueWrite(e){(0,shmi.requires("visuals.tools.iterate").iterateObject)(e,(function(e,t){shmi.objectHasOwnProperty(i,t)?i[t].value=e:i[t]={value:e,inProgress:!1}})),function writeNextQueuedValue(){var e=shmi.requires("visuals.tools.connect").request,t=shmi.requires("visuals.tools.iterate").iterateObject,s=shmi.requires("visuals.session.ItemManager"),n={};t(i,(function(e,t){e.inProgress||(n[t]=e.value,e.inProgress=!0)})),0!==Object.keys(n).length&&e("io.write",{direct:!1,values:n},(function onRequest(e,r){r?console.error("[ItemManager] io.write failed:",r.category,r.errc,r.message,n):t(e,(function(e,t){null!==e?console.error("[ItemManager] io.write failed: (",t,":",n[t],")",e.category,e.errc,e.message):s.writeEventEnabled&&shmi.fire("write-item",n)})),t(n,(function(e,t){i[t].value===e?delete i[t]:i[t].inProgress=!1})),writeNextQueuedValue()}))}()}function toType(e,t){switch(e.type){case shmi.c("TYPE_STRING"):break;case shmi.c("TYPE_BOOL"):t="boolean"==typeof t?!0===t?1:0:parseInt(t);break;case shmi.c("TYPE_INT"):t=parseInt(t);break;case shmi.c("TYPE_FLOAT"):t=parseFloat(t);break;default:shmi.log("[Item '"+e.name+"'] unknown type "+e.type,shmi.c("LOG_INFO"))}return t}function applyLockStatus(e,t){"function"==typeof t.lock&&"function"==typeof t.unlock&&(e.writable?t.unlock():t.lock())}function applyProperties(e,t){var i={min:e.min,max:e.max,step:e.step,warnmin:e.warnmin,warnmax:e.warnmax,prewarnmin:e.prewarnmin,prewarnmax:e.prewarnmax,precision:e.digits};if(e.labelToken&&""!==e.labelToken.trim()&&"function"==typeof t.setLabel){var s=e.labelToken.trim();s=s.replace(/#(.+?)#/g,(function(e,t){return"${"+t+"}"})),t.setLabel(s)}if(e.adapter){var n=shmi.requires("visuals.tools.iterate.iterateObject"),r=["precision","step"];n(i,(function(t,s){null!==t&&-1===r.indexOf(s)&&(i[s]=e.adapter.outFunction(t))}))}!function setUnitText(e,t){if("function"==typeof t.setUnitText){var i=!1;e.adapter&&e.adapter.unitText&&(t.setUnitText(e.adapter.unitText),i=!0),i||"string"!=typeof e.unit||""===e.unit.trim()||t.setUnitText(e.unit)}}(e,t),"function"==typeof t.setProperties&&t.setProperties(i.min,i.max,i.step,e.name,e.type,i.warnmin,i.warnmax,i.prewarnmin,i.prewarnmax,i.precision)}t.Item=function(e,t){this.name=e,this.readable=!1,this.writable=!1,this.lockable=!1,this.supervisor=!1,this.locked=!1,this.virtual=!!t,this.errorcode=null,this.index=null,this.type=null,this.min=null,this.max=null,this.step=null,this.prewarnmin=null,this.prewarnmax=null,this.warnmin=null,this.warnmax=null,this.value=void 0,this.initialized=!1,this.subscribed=!!t,this.valueSet=!1,this.bitmask=null,this.unit=null,this.unitClass=null,this.labelToken="",this.digits=-1,this.interval=100,this.lastSetTime=0,this._dataGridInfo=null,this._updateTargets={},this._updateValue=this.value,Object.defineProperty(this,"formattedValue",{enumerable:!0,configurable:!1,get:function(){return shmi.requires("visuals.tools.numericValues").formatNumber(this.value,{precision:this.digits,unit:this.unit})}.bind(this)})},t.Item.prototype={setProperties:function(e){var t=shmi.requires("visuals.tools.unitClasses");this.errorcode=0,this.index=0,this.type=function getType(e){return null===e?null:{int:2,long:2,longlong:2,uint:2,ulong:2,ulonglong:2,float:3,double:3,bool:1,boolean:1,string:0,error:-1}[e]}(e.value_type),this.locked=!1,this.supervisor=-1!==e.access.indexOf("supervisor"),this.lockable=-1!==e.access.indexOf("lock"),this.writable=-1!==e.access.indexOf("write"),this.readable=-1!==e.access.indexOf("read"),this.min=e.min,this.max=e.max,this.step=e.step,e.warn?(this.warnmin=e.warn.min,this.warnmax=e.warn.max):(this.warnmin=null,this.warnmax=null),e.prewarn?(this.prewarnmin=e.prewarn.min,this.prewarnmax=e.prewarn.max):(this.prewarnmin=null,this.prewarnmax=null),this.bitmask=0,this.digits=e.digits,this.unit=e.unit,isNaN(this.unit)?(this.unitClass=null,this.adapter=null):(this.unitClass=parseInt(this.unit),this.adapter=t.getSelectedAdapter(this.unitClass)),this.labelToken=e.label,-1===[-1,null].indexOf(this.type)?this.initialized=!0:(this.initialized=!1,this.valueSet=!1,this.value=void 0,this._updateValue=void 0),this.notifyLockStatus()},getProperties:function(){return{access:{read:this.readable,write:this.writable},min:this.min,max:this.max,step:this.step,digits:this.digits,label:this.labelToken,unit:this.unit,unitClass:"number"!=typeof this.unitClass||isNaN(this.unitClass)?null:this.unitClass,initialized:this.initialized,type:this.type,warn:{min:this.warnmin,max:this.warnmax},prewarn:{min:this.prewarnmin,max:this.prewarnmax}}},addUpdateTarget:function(e){for(var t=Date.now();void 0!==this._updateTargets[t];)t++;return this._updateTargets[t]=e,this.notifyLockStatus(t),this.notifyUpdateTargets(t),shmi.log("[Item] subscribed item '"+this.name+"' with id "+t,1),t},removeUpdateTarget:function(e){void 0!==e?null!==e?(delete this._updateTargets[e],shmi.log("[Item] unsubscribed item '"+this.name+"' with id "+e,1)):shmi.log("[Item] target id null",1):shmi.log("[Item] target id undefined",1)},writeValue:function(e,t){var i,n={};this.initialized?this.subscribed?(i=!t&&this.adapter?this.adapter.inFunction(e):e,this.type!==shmi.c("TYPE_INT")&&this.type!==shmi.c("TYPE_FLOAT")||"number"!=typeof this.min||"number"!=typeof this.max||0===this.min&&0===this.max||(i<this.min&&(i=this.min),i>this.max&&(i=this.max)),toType(this,i)!==this.value&&(this.virtual?this.writable&&this.setValue(i):(n[this.name]=this.type===shmi.c("TYPE_BOOL")?1===i:toType(this,i),queueWrite(n)))):s("tried to write to not subscribed item:",this.name):s("tried to write uninitialized item:",this.name)},readValue:function(e){return this.adapter&&!e?this.adapter.outFunction(this.value):this.value},compareExchange:function(e,t,i){var n=this,r=shmi.requires("visuals.tools.connect").request,o=shmi.requires("visuals.session.ItemManager");n.initialized||(s("attempted to compare & exchange with an uninitialized item:",n.name),i(null,!1,{category:"shmi:connect:api:io",errc:2147483647,message:"((unknown error))"})),n.virtual?n.writable?n.value!==e?i(n.value,!0,{category:"shmi:connect:api:io",errc:6,message:"expectation failed"}):i(null,!1,null):i(n.value,!1,{category:"shmi:connect:api:io",errc:2,message:"no write access"}):r("io.compare_exchange",{item_alias:n.name,expected:e,desired:t},(function(e,s){!s&&o.writeEventEnabled&&shmi.fire("write-item",{[n.name]:t}),i(e,s&&"shmi:connect:api:io"===s.category&&6===s.errc,s)}))},getBitmask:function(){return this.bitmask},isDataGridMember:function(){return null!==this._dataGridInfo},getDataGridInfo:function(){return this._dataGridInfo},setDataGridInfo:function(e,t,i){this._dataGridInfo={gridName:e,rowIndex:t,cellIndex:i}},clearDataGridInfo:function(){this._dataGridInfo=null},setValue:function(e){if(this.initialized){this.value=toType(this,e),this.valueSet=!0;var t=Date.now(),i=t-this.lastSetTime;0!==this.lastSetTime&&(this.interval=this.interval+(i-this.interval)/2,this.interval=Math.round(this.interval)),this.subscribed&&(i>=shmi.c("MIN_UPDATE_INTERVAL")?(this.lastSetTime=t,this.notifyUpdateTargets()):(clearTimeout(this.setTO),this.setTO=setTimeout(function(){this.lastSetTime=t,this.notifyUpdateTargets()}.bind(this),shmi.c("MIN_UPDATE_INTERVAL")-i)))}},notifyUpdateTargets:function(e){var t,i=this,n=shmi.requires("visuals.tools.iterate").iterateObject,r=null;if(i.initialized&&i.subscribed&&i.valueSet)if(t=i.adapter?i.adapter.outFunction(i.value):i.value,void 0!==e)if(r=i._updateTargets[e])try{r.setValue(t,i.type,i.name)}catch(t){s("exception running setValue on subscriber:",e,t)}else s("subscriber not found:",e);else i._updateValue!==i.value&&(n(i._updateTargets,(function(e,n){try{i._updateTargets[n].setValue(t,i.type,i.name)}catch(e){s("exception running setValue on subscriber:",n,e)}})),i._updateValue=i.value)},notifyLockStatus:function(e){var t=this,i=null,n=shmi.requires("visuals.tools.iterate.iterateObject");void 0!==e?(i=t._updateTargets[e])?(applyLockStatus(t,i),applyProperties(t,i)):(s("subscriber not found:",e),function logSubscriber(e,t){null==t?shmi.log("[Item '"+e.name+"'] logSubscriber: specified subscriber does not exist!",3):(shmi.log("[Item '"+e.name+"'] UI Type: "+t.uiType,2),void 0!==t.config&&shmi.log("[Item '"+e.name+"'] Control Name: "+t.config.name,2))}(t,t._updateTargets[e])):n(t._updateTargets,(function(e){applyLockStatus(t,e),applyProperties(t,e)}))}}}(),function(){var e,t=shmi.pkg("visuals.core"),i=(e="[visuals.core.BitItem]  ",e+=" ".repeat(Math.max(0,e.length-20)),console.error.bind(console,e));function updateProperties(e){var t=shmi.requires("visuals.session.ItemManager").getItem(e.parentItemName),i=[];e.parentItemIsCompatible&&(t.writable&&i.push("write"),t.readable&&i.push("read")),e.setProperties({access:i,min:0,max:1,step:1,value_type:"boolean",warn:null,prewarn:null,digits:0,precision:0,unit:null,label:null})}t.BitItem=function(e,t,i){shmi.visuals.core.Item.call(this,e,!0),this.parentItemName=t,this.parentItemToken=null,this.parentItemIsCompatible=!0,this.pendingAction=null,this.bitMask=null===i?null:1<<i},t.BitItem.prototype={writeValue:function(e){var t=shmi.requires("visuals.session.ItemManager").getItem(this.parentItemName);if(this.initialized)if(this.subscribed){if(1===e||"1"===e||"true"===e)e=!0;else if(0===e||"0"===e||"false"===e)e=!1;else if(!0!==e&&!1!==e)return void i("tried to write invalid value to bit item:",e);if(t){var s=null===this.pendingAction;this.pendingAction=e?"set":"unset",s&&function startWriteBits(e,t,s){var n,r=e.pendingAction;null==s&&(s=t.readValue(!0)),n="set"===e.pendingAction?s|e.bitMask:s&~e.bitMask,null!==e.pendingAction&&(!("set"===e.pendingAction&&(s&e.bitMask)===e.bitMask||"unset"===e.pendingAction&&0==(s&e.bitMask))?t.compareExchange(s,n,(function cmpxchgCb(s,o,a){o?startWriteBits(e,t,s):(a&&i("failed to apply bitmask",a),r!==e.pendingAction?startWriteBits(e,t,n):e.pendingAction=null)})):e.pendingAction=null)}(this,t)}else i("unable to find parent item",this.parentItemName)}else i("tried to write to not subscribed item:",this.name);else i("tried to write uninitialized item:",this.name)},addUpdateTarget:function(e){return null!==this.bitMask&&0===Object.keys(this._updateTargets).length&&function subscribeParentItem(e){var t=shmi.requires("visuals.session.ItemManager");e.parentItemToken=t.subscribeItem(e.parentItemName,{setValue:function setValue(t){var i="number"==typeof t||"boolean"==typeof t;e.parentItemIsCompatible!==i&&(e.parentItemIsCompatible=i,updateProperties(e)),i&&e.setValue(!!e.bitMask&&(t&e.bitMask)===e.bitMask)},setProperties:updateProperties.bind(null,e)})}(this),shmi.visuals.core.Item.prototype.addUpdateTarget.call(this,e)},removeUpdateTarget:function(e){shmi.visuals.core.Item.prototype.removeUpdateTarget.call(this,e),null!==this.bitMask&&0===Object.keys(this._updateTargets).length&&function unsubscribeParentItem(e){e.parentItemToken&&(e.parentItemToken.unlisten(),e.parentItemToken=null,e.setProperties({access:[],min:0,max:1,step:1,value_type:null,warn:null,prewarn:null,digits:0,precision:0,unit:null,label:null}))}(this)}},shmi.extend(t.BitItem,shmi.visuals.core.Item)}(),function(){shmi.pkg("visuals.core");var e=100,t=50,i=!1,s={},n=null;function reschedule(){null!==n&&Object.keys(s).length>=e||(null!==n&&clearTimeout(n),n=setTimeout(subscriptionTickHandler,t))}function queueFromActionMap(t){var i=shmi.requires("visuals.tools.iterate").iterateObject,n=[];return i(s,(function(i,r){i===t&&n.length<e&&(n.push(r),delete s[r])})),n}function sendRequest(e,t){var s=shmi.requires("visuals.tools.connect").request;i=!0,s(e,t,(function onRequest(t,s){s&&console.error("[ItemManager] "+e+" failed:",s.category,s.errc,s.message),i=!1,subscriptionTickHandler()}))}function subscriptionTickHandler(){var e=shmi.visuals.session.ItemManager;if(n=null,!i){var t=queueFromActionMap("subscribe");t.length>0?(shmi.visuals.session.config.debug&&console.debug("SUB",t),t.forEach((function(t){var i=e.getItem(t);i&&(i.type=null)})),sendRequest("io.subscribe",t)):(t=queueFromActionMap("unsubscribe")).length>0&&(shmi.visuals.session.config.debug&&console.debug("UNSUB",t),t.forEach((function(t){var i=e.getItem(t);i&&(i.type=null)})),sendRequest("io.unsubscribe",t))}}function unsubscribeItem(e){var t=s[e.name];e.subscribed=!1,"subscribe"===t?delete s[e.name]:"unsubscribe"===t||(s[e.name]="unsubscribe",reschedule())}shmi.visuals.core.ItemManager=function(){var e=this;e.items={},e.writeEventEnabled=!1,e.next_id=0,shmi.registerMsgHandler("item.info",(function(t){!function setItemInfo(e,t){e.setProperties(t.data)}(e,t)})),shmi.registerMsgHandler("io.values",(function(t){!function setItemValues(e,t){(0,shmi.requires("visuals.tools.iterate").iterateObject)(t.data,(function(t,i){e.setValue(i,t)}))}(e,t)}))},shmi.visuals.core.ItemManager.prototype={getItemHandler:function(){var noop=function(){};return{setValue:noop,setProperties:noop,lock:noop,unlock:noop}},_createItem:function(e){"string"==typeof e?void 0===this.items[e]?0===e.indexOf("virtual:")||0===e.indexOf("objmap:")?this.items[e]=new shmi.visuals.core.Item(e,!0):0===e.indexOf("bit[")?this.items[e]=function createBitItem(e){var t=e.match(/^bit\[(\d+)\]:(.+)$/);return t?new shmi.visuals.core.BitItem(e,t[2],parseInt(t[1])):new shmi.visuals.core.BitItem(e,null,null)}(e):this.items[e]=new shmi.visuals.core.Item(e):shmi.log("[ItemManager] item '"+e+"' already exists",1):shmi.log("[ItemManager] invalid item name '"+e+"'",3)},_getNextId:function(){return++this.next_id},getItem:function(e){return void 0!==this.items[e]?this.items[e]:null},removeItem:function(e){var t=this,i=shmi.requires("visuals.tools.iterate").iterateObject;t.items[e]&&(i(t.items[e]._updateTargets,(function(i,s){delete t.items[e]._updateTargets[s]})),delete t.items[e])},removeAll:function(){var e=this,t=0,i=shmi.requires("visuals.tools.iterate").iterateObject;i(e.items,(function(s,n){i(e.items[n]._updateTargets,(function(i,s){delete e.items[n]._updateTargets[s],t++}))})),shmi.log("[ItemManager] removed all subscribers ("+t+")",1)},writeValue:function(e,t){void 0===this.items[e]?console.warn("[ItemManager]","tried to write non-existing item:",e):this.items[e].writeValue(t)},readValue:function(e){return this.items[e]?this.items[e].readValue():null},setValue:function(e,t){void 0===this.items[e]?console.warn("[ItemManager]","tried to set-value non-existing item:",e):this.items[e].setValue(t)},compareExchange:function(e,t,i,s){void 0===this.items[e]?(console.warn("[ItemManager]","attempted to compare & exchange on a non-existing item:",e),s(null,!1,{category:"shmi:connect:api:io",code:2147483647,message:"((unknown error))"})):this.items[e].compareExchange(t,i,s)},subscribeItem:function(e,t){var i=this,n=!1;void 0===i.items[e]&&i._createItem(e),null!==e&&i.items[e]&&!i.items[e].virtual&&0===Object.keys(i.items[e]._updateTargets).length&&(n=!0);var r={name:e,subscriberId:i.items[e].addUpdateTarget(t),unlisten:(null,function(){i.unsubscribeItem(r)})};return n&&function subscribeItem(e){var t=s[e.name];e.subscribed=!0,"unsubscribe"===t?(e.initialized&&(e._updateValue=void 0,e.notifyUpdateTargets()),delete s[e.name]):"subscribe"===t||(s[e.name]="subscribe",reschedule())}(i.items[e]),r},unsubscribeItem:function(e){var t=this,i=null;1===arguments.length?void 0!==t.items[e.name]&&(t.items[e.name].removeUpdateTarget(e.subscriberId),i=e.name):void 0!==t.items[arguments[0]]&&(t.items[arguments[0]].removeUpdateTarget(arguments[1].subscriberId),i=arguments[0]),null!==i&&t.items[i]&&!t.items[i].virtual&&0===Object.keys(t.items[i]._updateTargets).length&&unsubscribeItem(t.items[i])},subscribe:function(e,t=null,i=null){let s=e.map(e=>{const s=this.getItemHandler();return s.setValue="function"==typeof t?(e,i,s)=>t(s,e,i):()=>{},s.setProperties="function"==typeof i?()=>i(e,this.getItem(e).getProperties()):()=>{},this.subscribeItem(e,s)});return{unlisten:()=>{s.forEach(e=>e.unlisten()),s=[]}}},setProperties:function(e){void 0===this.items[e.item_alias]&&this._createItem(e.item_alias),this.items[e.item_alias].setProperties(e)},writeDirect:function(e,t){var i=shmi.requires("visuals.tools.connect").request,s=this;i("io.write",{direct:!0,values:e},(function onRequest(i,n){!n&&s.writeEventEnabled&&shmi.fire("write-item",e),t(n,i)}))},readDirect:function(e,t){(0,shmi.requires("visuals.tools.connect").request)("io.read",e,(function onRequest(e,i){t(i,e)}))},enableWriteEvent:function(){this.writeEventEnabled=!0},disableWriteEvent:function(){this.writeEventEnabled=!1}}}(),shmi.pkg("visuals.core"),shmi.visuals.core.QueryManager=function(){this.queries={}},shmi.visuals.core.QueryManager.prototype={query:function(e,t,i,s,n,r){var o,a=this,l=shmi.requires("visuals.tools.connect").request,u=function getQueryId(e){for(var t=1;void 0!==e.queries[t];)t+=1;return t}(a),c={database_path:(o=n,"number"==typeof o?[null,null,"internal:project","internal:project","internal:user","internal:user","internal:hmi","internal:hmi"][o]:o),table_name:t,columns:i,filter:s};return a.queries[u]={open:!1,failed:!1,connect_id:null,close:!1},Array.isArray(r)&&(c.sort=r),l("db.open",c,(function onRequest(t,i){i?(console.error("[QueryManager] query failed:",i.category,i.errc,i.message),a.queries[u].failed=!0,a.queries[u].close?a.close(u):e(i,0,[])):(a.queries[u].open=!0,a.queries[u].connect_id=t.query_id,a.queries[u].close?a.close(u):e(0,t.total_count,t.columns))})),u},queryDirect:function(e,t,i,s,n,r,o){var a=this,l=null;l=a.query((function(t,i,s){0===t?a.get((function onGet(t,i){a.close(l),e(t,i)}),l,o||0,r||2147483647):(a.close(l),e(t,null))}),t,i,s,n)},get:function(e,t,i,s){var n=shmi.requires("visuals.tools.connect").request,r=this.queries[t];if(!r)throw new Error("[QueryManager] query ID does not exist: "+t);n("db.get",{query_id:r.connect_id,offset:i,limit:s},(function onRequest(t,i){i?(console.error("[QueryManager] get failed:",i.category,i.errc,i.message),e(i,null)):e(0,{data:t.rows})}))},close:function(e,t){var i=shmi.requires("visuals.tools.connect").request,s=this.queries[e];if(!s)throw new Error("[QueryManager] query ID does not exist: "+e);s.open?(delete this.queries[e],i("db.close",s.connect_id,(function onRequest(e,i){i&&console.error("[QueryManager] close failed:",i.category,i.errc,i.message),t&&t(i||0)}))):s.failed?delete this.queries[e]:s.close=!0},insert:function(e,t,i,s,n,r){(0,shmi.requires("visuals.tools.connect").request)("db.insert",{database_path:n,table_name:e,on_conflict:r||"fail",columns:t,rows:[i]},(function onRequest(e,t){t?(console.error("[QueryManager] insert failed:",t.category,t.errc,t.message),s(t,null)):s(0,e.last_insert_id[0])}))},update:function(e,t,i,s,n,r){var o=shmi.requires("visuals.tools.connect").request,a={};if(t.length!==i.length)throw new Error("[QueryManager] number of values does not match number of columns!");t.forEach((function(e,t){a[e]=i[t]})),o("db.update",{database_path:r,table_name:e,values:a,filter:[{mode:"AND",column:"rowid",clauses:[{operator:"==",value:s}]}]},(function onRequest(e,t){t?(console.error("[QueryManager] update failed:",t.category,t.errc,t.message),n(t,null)):n(0,e.affected_rows)}))},deleteRow:function(e,t,i,s){(0,shmi.requires("visuals.tools.connect").request)("db.delete",{database_path:s,table_name:e,filter:[{mode:"AND",column:"rowid",clauses:[{operator:"==",value:t}]}]},(function onRequest(e,t){t?(console.error("[QueryManager] delete failed:",t.category,t.errc,t.message),i(t,null)):i(0,e.affected_rows)}))},customSQL:function(e,t,i,s){(0,shmi.requires("visuals.tools.connect").request)("db.sql",{database_path:i,sql:e,parameters:s||{}},(function onRequest(e,i){i?(console.error("[QueryManager] delete failed:",i.category,i.errc,i.message),t(i,null)):t(0,e)}))},executePreparedStatement:function(e,t,i){(0,shmi.requires("visuals.tools.connect").request)("db.prepared.execute",{statement_name:e,parameters:t},(function onRequest(e,t){t?(console.error("[QueryManager] delete failed:",t.category,t.errc,t.message),i(t,null)):i(0,e)}))}},function(){"use strict";function isValidTimestamp(e){return!isNaN(e)&&null!==e}function ValueUpdate(e,t,i){this.value=e,this.modifiedTimestamp=isValidTimestamp(t)?new Date(t/1e4):null,this.modifiedBy=i||null,Object.freeze(this)}shmi.pkg("visuals.core"),ValueUpdate.convertObject=function convertObject(e){var t=shmi.requires("visuals.tools.iterate.iterateObject"),i={};return e&&t(e,(function(e,t){i[t]=new ValueUpdate(e.value,e.modified_timestamp,e.modified_by)})),i},shmi.visuals.core.Recipe=function(e,t,i,s,n,r,o,a,l,u,c,h,m){Object.defineProperties(this,{id:{value:e,configurable:!1,writable:!1},templateId:{value:t,configurable:!1,writable:!1},manager:{value:m,configurable:!1,writable:!1}}),this.versionId=i,this.versionNum=s,this.name=n,this.createdBy=r,this.createdTimestamp=isValidTimestamp(o)?new Date(o/1e4):null,this.modifiedBy=a,this.modifiedTimestamp=isValidTimestamp(l)?new Date(l/1e4):null,this.comment=u||null,this.metadata=c||{},this.values=ValueUpdate.convertObject(h),Object.seal(this)},shmi.visuals.core.Recipe.prototype={clone:function(e,t){var i=shmi.requires("visuals.tools.connect").request;shmi.checkArg("newName",e,"string"),shmi.checkArg("callback",t,"function"),i("recipe.clone",{recipe_id:this.id,new_name:e},function(e,s){s?t(null,s):null===this.versionId?this.manager.getRecipe(e,t):i("recipe.version.copy",{recipe_version_id:this.versionId,destination_recipe:e},function(i,s){s?t(null,s):this.manager.getRecipe(e,t)}.bind(this))}.bind(this))},refresh:function(e){shmi.checkArg("callback",e,"function"),this.manager.getRecipe(this.id,function(t,i){i||(this.versionId=t.versionId,this.versionNum=t.versionNum,this.name=t.name,this.createdBy=t.createdBy,this.createdTimestamp=isValidTimestamp(t.createdTimestamp)?new Date(t.createdTimestamp/1e4):null,this.modifiedBy=t.modifiedBy,this.modifiedTimestamp=isValidTimestamp(t.modifiedTimestamp)?new Date(t.modifiedTimestamp/1e4):null,this.comment=t.comment||null,this.metadata=t.metadata||{},this.values=t.values),e(i)}.bind(this))},delete:function(e){var t=shmi.requires("visuals.tools.connect").request;shmi.checkArg("callback",e,"function"),t("recipe.del",this.id,(function(t,i){e(i)}))},set:function(e,t,i,s){var n=shmi.requires("visuals.tools.connect").request,r={recipe_id:this.id};shmi.checkArg("name",e,"string","null"),shmi.checkArg("metadata",t,"object","null"),shmi.checkArg("keepExisting",i,"boolean"),shmi.checkArg("callback",s,"function"),null!==e&&(r.name=e),t&&(r.metadata=t),null!==i&&(r.keep_existing=i),n("recipe.set",r,function(e,t){t?s(t):this.refresh(s)}.bind(this))},capture:function(e,t){var i=shmi.requires("visuals.tools.connect").request,s={recipe_id:this.id};shmi.checkArg("comment",e,"string","null"),shmi.checkArg("callback",t,"function"),null!==e&&(s.comment=e),this.versionNum&&(s.version=this.versionNum),i("recipe.capture",s,function(e,i){i?t(i):this.refresh(t)}.bind(this))},apply:function(e){var t=shmi.requires("visuals.tools.connect").request;shmi.checkArg("callback",e,"function"),t("recipe.apply",this.versionId,e)},write:function(e,t){var i=shmi.requires("visuals.tools.connect").request;shmi.checkArg("writeData",e,"object"),shmi.checkArg("callback",t,"function"),i("recipe.version.write",{recipe_version_id:this.versionId,values:e},function(e,i){i?t(i):this.refresh(t)}.bind(this))}}}(),function(){"use strict";shmi.pkg("visuals.core"),shmi.visuals.core.RecipeManager=function(){Object.freeze(this)},shmi.visuals.core.RecipeManager.prototype={createTemplate:function(e,t,i,s){var n=shmi.requires("visuals.tools.connect").request;shmi.checkArg("templateName",e,"string"),shmi.checkArg("items",t,"array"),shmi.checkArg("metadata",i,"object"),shmi.checkArg("callback",s,"function"),n("recipe.template.add",{template_name:e,items:t,metadata:i},function(e,t){t?s(null,t):this.getTemplate(e,s)}.bind(this))},getTemplate:function(e,t){var i=shmi.requires("visuals.tools.connect").request;shmi.checkArg("templateId",e,"number"),shmi.checkArg("callback",t,"function"),i("recipe.template.get",e,function(e,i){i?t(null,i):t(new shmi.visuals.core.RecipeTemplate(e.template_id,e.template_name,e.items.map(e=>e.item_alias),e.metadata,this),null)}.bind(this))},listTemplates:function(e,t){var i=shmi.requires("visuals.tools.connect").request;shmi.checkArg("filterOptions",e,"object"),shmi.checkArg("callback",t,"function"),i("recipe.template.list",e,function(e,i){i?t(null,i):(e.templates=e.templates.map(function(e){return new shmi.visuals.core.RecipeTemplate(e.template_id,e.template_name,Array.isArray(e.items)?e.items.map(e=>e.item_alias):null,e.metadata,this)}.bind(this)),t(e,null))}.bind(this))},getRecipe:function(e,t){var i=shmi.requires("visuals.tools.connect").request;shmi.checkArg("recipeId",e,"number"),shmi.checkArg("callback",t,"function"),i("recipe.get",e,function(s,n){n?t(null,n):i("recipe.version.latest",e,function(e,i){t(i?new shmi.visuals.core.Recipe(s.recipe_id,s.template_id,null,null,s.name,null,null,null,null,null,s.metadata,null,this):new shmi.visuals.core.Recipe(s.recipe_id,s.template_id,e.recipe_version_id,e.version,s.name,e.created_by,e.created_timestamp,e.modified_by,e.modified_timestamp,e.comment,s.metadata,e.values,this),null)}.bind(this))}.bind(this))},listRecipes:function(e,t,i){var s=this,n=shmi.requires("visuals.tools.connect").request,r=shmi.requires("visuals.tools.iterate.iterateObject"),o=t.include_values||!1;shmi.checkArg("templateId",e,"number"),shmi.checkArg("filterOptions",t,"object"),shmi.checkArg("callback",i,"function"),shmi.objectHasOwnProperty(t,"include_values")&&delete t.include_values,t.template_id=e,n("recipe.list",t,(function(e,t){var a=0;function collectCallback(t,n,o){a<=0||(o||r(n,(function(e,i){t[i]=e})),0==--a&&(e.recipes=e.recipes.map((function(e){return new shmi.visuals.core.Recipe(e.recipe_id,e.template_id,e.recipe_version_id,e.version,e.name,e.created_by,e.created_timestamp,e.modified_by,e.modified_timestamp,e.comment,e.metadata,e.values,s)})),i(e,null)))}t?i(null,t):e.recipes.length<=0||!o?(e.recipes=e.recipes.map((function(e){return new shmi.visuals.core.Recipe(e.recipe_id,e.template_id,null,null,e.name,null,null,null,null,null,e.metadata,null,s)})),i(e,null)):(a=e.recipes.length,e.recipes.forEach((function(e){n("recipe.version.latest",e.recipe_id,collectCallback.bind(null,e))})))}))}}}(),function(){"use strict";shmi.pkg("visuals.core"),shmi.visuals.core.RecipeTemplate=function(e,t,i,s,n){Object.defineProperties(this,{id:{value:e,configurable:!1,writable:!1},manager:{value:n,configurable:!1,writable:!1}}),this.name=t,this.items=i||[],this.metadata=s||{},Object.seal(this)},shmi.visuals.core.RecipeTemplate.prototype={createRecipe:function(e,t,i){var s=shmi.requires("visuals.tools.connect").request;shmi.checkArg("recipeName",e,"string"),shmi.checkArg("metadata",t,"object"),shmi.checkArg("callback",i,"function"),s("recipe.add",{template_id:this.id,recipe_name:e,metadata:t||{}},function(e,t){t?i(null,t):this.manager.getRecipe(e,i)}.bind(this))},clone:function(e,t){var i=shmi.requires("visuals.tools.connect").request;shmi.checkArg("newName",e,"string"),shmi.checkArg("callback",t,"function"),i("recipe.template.clone",{template_id:this.id,new_name:e},function(e,i){i?t(null,i):this.manager.getTemplate(e,t)}.bind(this))},set:function(e,t,i,s,n){var r=shmi.requires("visuals.tools.connect").request,o={template_id:this.id,keep_existing:s};shmi.checkArg("templateName",e,"string","null"),shmi.checkArg("items",t,"array","null"),shmi.checkArg("metadata",i,"metadata","null"),shmi.checkArg("keepExisting",s,"boolean"),shmi.checkArg("callback",n,"function"),null!==e&&(o.name=e),null!==t&&(o.items=t),null!==i&&(o.metadata=i),r("recipe.template.set",o,function(e,t){t?n(t):this.refresh(n)}.bind(this))},refresh:function(e){shmi.checkArg("callback",e,"function"),this.manager.getTemplate(this.id,function(t,i){i||(this.name=t.name,this.items=t.items||[],this.metadata=t.metadata||{}),e(i)}.bind(this))},delete:function(e){var t=shmi.requires("visuals.tools.connect").request;shmi.checkArg("callback",e,"function"),t("recipe.template.del",this.id,(function(t,i){e(i)}))},listRecipes:function(e,t){this.manager.listRecipes(this.id,e,t)}}}(),shmi.pkg("visuals.core"),function(){function isUnitClass(e){return("string"!=typeof e||""!==e.trim())&&!isNaN(e)}function processTrendData(e,t,i,s){if(!0===s?s=1:!1===s&&(s=0),e.unitClassModule&&e.trendInfo[t]){var n=e.trendInfo[t].items.find((function(e){return e.name&&e.name===i}));if(n&&isUnitClass(n.unit)){var r=parseInt(n.unit),o=e.unitClassModule.getSelectedAdapter(r);o&&(s=o.outFunction(s))}}return s}function applyAdapterSettings(e,t){e.unit=t.unitText,e.min=t.outFunction(e.min),e.max=t.outFunction(e.max)}function processTrendInfo(e,t){var i=t.items,s=shmi.requires("visuals.session.ItemManager"),n=shmi.requires("visuals.tools.iterate.iterateObject");return i.forEach((function(t,i){var r=s.getItem(t.name);if(e.customInfo[t.name]&&n(e.customInfo[t.name],(function(e,i){t[i]=e})),isUnitClass(t.unit)){var o=parseInt(t.unit),a=e.unitClassModule.getSelectedAdapter(o);a&&applyAdapterSettings(t,a)}else r&&r.adapter&&applyAdapterSettings(t,r.adapter)})),t}shmi.visuals.core.TrendManager=function(){var e=this;e.subscribers={},e.trendInfo={},shmi.registerMsgHandler("trend.live.data",(function onLiveTrendData(t){var i=e.subscribers[t.data.id];i?(t.data.values.forEach((function(s,n){t.data.values[n]=processTrendData(e,i.trend_name,i.items[n],s)})),i.callback(0,{name:i.trend_name,data:[t.data]})):console.warn("[TrendManager] subscriber not found, ID:",t.data.id)})),this.unitClassModule=null,this.customInfo={},function loadOptional(e,t,i){try{e[t]=shmi.requires(i),shmi.visuals.session.config.debug&&console.debug("optional module '",i,"' loaded")}catch(e){shmi.visuals.session.config.debug&&console.debug("optional module '",i,"' not available")}}(this,"unitClassModule","visuals.tools.unitClasses")},shmi.visuals.core.TrendManager.prototype={AGG_METHODS:{key:{last:0,avg:1,min:2,max:3},value:["last","avg","min","max"]},setCustomInfo:function(e,t){if("string"!=typeof e||""===e.trim())throw new TypeError("argument 'itemName' is not a string");if("object"!=typeof t||null===t)throw new TypeError("argument 'itemInfo' is not an object");this.customInfo[e]=t},openTrend:function(e,t,i,s,n,r,o){var a=this,l=shmi.requires("visuals.tools.connect").request,u=-1,c=null;if(r=r||0,o=o||(a.trendInfo[e]?a.trendInfo[e].items.map(e=>e.name):[]),c={trend_name:e,timestamp_start:t,aggregation_type:a.AGG_METHODS.value[r],aggregation_unit:n||1,live:!1,items:o},-1===i){for(u=1;void 0!==a.subscribers[u];)u++;a.subscribers[u]={query_id:u,trend_name:e,items:o,callback:s,aggregate:r,close:!1,open:!1},c.live=!0,c.live_trend_id=u}else c.timestamp_end=Math.round(i);return l("trend.query",c,(function onRequest(t,n){var r={name:e,data:[]};n?s(n,r):(t.rows.forEach((function(t){t.values.forEach((function(i,s){t.values[s]=processTrendData(a,e,o[s],i)})),r.data.push(t)})),s(0,r)),-1===i&&(a.subscribers[u].open=!0,a.subscribers[u].close&&a.closeTrend(e,u))})),u},closeTrend:function(e,t){var i=this,s=shmi.requires("visuals.tools.connect").request,n=i.subscribers[t];void 0!==n&&(n.open?s("trend.unsubscribe",n.query_id,(function onUnsubscribe(e,s){delete i.subscribers[t],s&&console.error("[TrendManager] error unsubscribing:",s)})):n.close=!0)},getTrendList:function(e){(0,shmi.requires("visuals.tools.connect").request)("trend.list",{},(function onRequest(t,i){var s=[];i?e(s,i):(t.recorders&&(console.warn("[TrendManager] renaming response property: 'recorders' -> 'trends'"),t.trends=t.recorders),t.trends.forEach((function(e){s.push(e.trend_name)})),e(s,0))}))},getTrendInfo:function(e,t,i){var s=this;(0,shmi.requires("visuals.tools.connect").request)("trend.info",{trend_name:e,items:i||[]},(function onRequest(e,i){var n=shmi.cloneObject(e),r={};i?t(null,i):(s.trendInfo[e.trend_name]?(s.trendInfo[e.trend_name].items.forEach((function(e){r[e.name]=!0})),e.items.forEach((function(t){r[t.name]||s.trendInfo[e.trend_name].items.push(shmi.cloneObject(t))})),s.trendInfo[e.trend_name].items.sort((function(e,t){return e.name>t.name})),n=processTrendInfo(s,n)):(s.trendInfo[e.trend_name]=shmi.cloneObject(e),n=processTrendInfo(s,n)),t(n,0))}))}}}(),shmi.pkg("visuals.core"),shmi.visuals.core.UiAction=function(e,t){this.actionParameter=e,this.owner=void 0!==t?t:null,shmi.visuals.session&&shmi.visuals.session.config&&!0===shmi.visuals.session.config.action_debug&&(null===this.owner?console.log("UiAction - no owner provided",this):console.log("UiAction - owner:",t,this)),this.onExecute=[],this.init()},shmi.visuals.core.UiAction.prototype={init:function(){var e,t=0;e=Array.isArray(this.actionParameter)?this.actionParameter:(this.actionParameter,[this.actionParameter]);for(var i=this;t<e.length;){var s=e[t];if("string"==typeof s){var n=s.split(":"),r=n[0];n.shift(),console.warn("[UiAction]","the following UI-action configuration is using deprecated string notiation and should be updated to object notation:",s),shmi.visuals.session.userActions&&shmi.visuals.session.userActions[r]?this.onExecute.push(function(e,t){return function(s,n,r){shmi.visuals.session.userActions[e](t,s,n,r,i.owner)}}(r,n)):shmi.visuals.session.sysActions&&shmi.visuals.session.sysActions[r]?this.onExecute.push(function(e,t){return function(s,n,r){shmi.visuals.session.sysActions[e](t,s,n,r,i.owner)}}(r,n)):console.warn("[UiAction]","unknown UI-action:",s)}else"object"==typeof s&&(shmi.visuals.session.userActions&&shmi.visuals.session.userActions[s.name]?this.onExecute.push(function(e,t){return function(s,n,r){shmi.visuals.session.userActions[e](t,s,n,r,i.owner)}}(s.name,s.params)):shmi.visuals.session.sysActions&&shmi.visuals.session.sysActions[s.name]?this.onExecute.push(function(e,t,s){return function(n,r,o){shmi.visuals.session.sysActions[e](t,n,r,o,s?i.owner:null)}}(s.name,s.params,s.relative)):console.warn("[UiAction]","unknown UI-action:",s.name));t++}},execute:function(e,t,i){for(var s=0;s<this.onExecute.length;s++)this.onExecute[s](e,t,i);shmi.log("[UiAction] executed "+this.onExecute.length+" actions",1)}},shmi.pkg("visuals.session"),shmi.visuals.session.sysActions=shmi.visuals.session.sysActions||{},shmi.visuals.session.sysActions.dialog=function(e){var t=null;if(t=3===e.length&&"relative"===e[2]?shmi.ctrl(e[0],arguments[4]):shmi.ctrl(e[0]))switch(e[1]){case"show":case"open":t.show();break;case"hide":case"close":t.hide();break;case"default":console.error("[UiAction] - dialog","unknown dialog action '"+e[1]+"'.")}else console.error("[UiAction] - dialog","could not find dialog:",e[0])},shmi.visuals.session.sysActions["set-theme"]=function(e){var t=document.documentElement,i=null,s=[];if(1!==e.length){for(var n=0;n<t.classList.length;n++)(i=t.classList[n]).indexOf("-theme")===i.length-"-theme".length&&s.push(i);s.forEach((function(e){t.classList.remove(e)}))}else{for(var r=0;r<t.classList.length;r++)(i=t.classList[r]).indexOf("-theme")===i.length-"-theme".length&&s.push(i);s.forEach((function(e){t.classList.remove(e)})),t.classList.add(e[0])}},function(){function stopSubscription(e){shmi.decouple((function(){e.token&&(e.token.unlisten(),e.token=null)}))}shmi.visuals.session.sysActions["write-item"]=function(e){if(2!==e.length)shmi.log("[UserAction] write-item - UI-action requires two parameters (<item alias>, <value to set>)",2);else{var t=shmi.visuals.session.ItemManager,i={};i[e[0]]=e[1],"string"==typeof e[0]&&0!==e[0].indexOf("bit[")&&(0===e[0].indexOf("virtual:")||t.getItem(e[0])&&t.getItem(e[0]).virtual)?t.writeValue(e[0],e[1]):"string"==typeof e[0]&&0===e[0].indexOf("bit[")?function writeBitItem(e,t){var i=shmi.requires("visuals.session.ItemManager"),s={token:null},n=i.getItemHandler(),r=!1,o=!1,a=!1;n.setProperties=function setProperties(t,n,a,l,u){o||"number"==typeof u&&(-1!==u&&i.getItem(e)&&(r=!0),o=!0,r||(console.error("Attempted to write to non-existing item:",e),stopSubscription(s)))},n.setValue=function setValue(n){o&&r&&!a&&(a=!0,i.writeValue(e,t?1:0),stopSubscription(s))},s.token=i.subscribeItem(e,n)}(e[0],e[1]):t.writeDirect(i,(function(){}))}}}(),shmi.visuals.session.sysActions.logout=function(e){var t=null;!0===e[0]?((t=new URL(window.location.href)).searchParams.set("autoLogin","false"),window.location.href=t.toString()):window.location.reload()},shmi.visuals.session.sysActions["logout-confirm"]=function(e){shmi.confirm(e[0]?e[0]:"logout?",(function(t){if(t){var i=null;!0===e[1]?((i=new URL(window.location.href)).searchParams.set("autoLogin","false"),window.location.href=i.toString()):window.location.reload()}}))},shmi.visuals.session.sysActions["toggle-class"]=function(e){if(2===e.length){var t=e[0],i=e[1],s=shmi.getElementByName(t);s?shmi.hasClass(s,i)?shmi.removeClass(s,i):shmi.addClass(s,i):shmi.log("[UserAction] toggle-class - no element found by name '"+t+"'",2)}},shmi.visuals.session.sysActions["add-class"]=function(e){if(2!==e.length)shmi.log("[UserAction] add-class - needs two parameters",2);else{var t=e[0],i=e[1],s=shmi.getElementByName(t);shmi.log("[UserAction] add-class - name: "+t+" cssClass: "+i,2),s?shmi.addClass(s,i):shmi.log("[UserAction] add-class - no element found by name '"+t+"'",2)}},shmi.visuals.session.sysActions["remove-class"]=function(e){if(2!==e.length)shmi.log("[UserAction] remove-class - needs two parameters",2);else{var t=e[0],i=e[1],s=shmi.getElementByName(t);shmi.log("[UserAction] remove-class - name: "+t+" cssClass: "+i,2),s?shmi.removeClass(s,i):shmi.log("[UserAction] remove-class - no element found by name '"+t+"'",2)}},shmi.visuals.session.sysActions.setview=function(e){if(2!==e.length)shmi.log("[UserAction] setview - needs two parameters",2);else{var t=shmi.ctrl(e[0]);if(t)try{t.setView(parseInt(e[1])),shmi.log("[UserAction] setview - view set",1)}catch(e){shmi.log("[UserAction] exception setting view for panel: "+e,2)}else shmi.log("[UserAction] setview - no element found by name '"+e[0]+"'",2)}},shmi.visuals.session.sysActions["screen-setview"]=shmi.visuals.session.sysActions.setview,shmi.visuals.session.sysActions["ask-save"]=function(e){if(2!==e.length)shmi.log("[UserAction] ask-save - needs two parameters",2);else if(void 0!==shmi.visuals.session.AskSaves[e[0]]){var t="SAVE"===e[1],i="SAVE"===e[1]||"NOSAVE"===e[1];shmi.visuals.session.AskSaves[e[0]](t,i),delete shmi.visuals.session.AskSaves[e[0]]}else shmi.log("[UserAction] ask-save - Save request '"+e[0]+"' was not found",2)},shmi.visuals.session.sysActions.confirm=function(e){if(2!==e.length)shmi.log("[UserAction] confirm - needs two parameters",2);else if(void 0!==shmi.visuals.session.Confirmations[e[0]]){var t="TRUE"===e[1];shmi.visuals.session.Confirmations[e[0]](t),delete shmi.visuals.session.Confirmations[e[0]]}else shmi.log("[UserAction] confirm - Confirmation request '"+e[0]+"' was not found",2)},shmi.visuals.session.sysActions.grid=function(e){if(e.length<2)shmi.log("[UserAction] grid - needs at least two parameters",2);else{var t=shmi.visuals.session.DataGridManager.grids[e[0]];if(void 0!==t)switch(e[1]){case"next-page":t.nextPage();break;case"previous-page":t.previousPage();break;case"refresh":t.refresh&&t.refresh();break;case"delete-selected":var i=arguments[4],s=shmi.ctrl(e[2],i),n=[];void 0!==s?n=s.getSelectedRows().selRows:shmi.log("[UserAction] grid:delete-selected - complex-table '"+e[2]+"' not found",2);for(var r=0;r<n.length;r++)t.deleteRow(n[r]);break;default:shmi.log("[UserAction] grid - unknown function '"+e[1]+"' configured",3)}else shmi.log("[UserAction] grid - DataGrid '"+e[0]+"' not found!",3)}},shmi.visuals.session.sysActions.createrow=function(e){if(e.length<2)shmi.log("[UserAction] createrow - needs at least two parameters",2);else{var t=shmi.ctrl(e[0]),i=shmi.visuals.session.DataGridManager.grids[e[1]];if(void 0!==t){for(var s=[],n=0;n<i.fields.length;n++)s.push({field:i.fields[n],type:4,value:""});t.setValues(s,(function(e){var t,s=[];for(n=0;n<i.fields.length;n++)t={type:4,min:Number.NaN,max:Number.NaN,value:void 0,field:i.fields[n]},s.push(t);for(var r=0;r<e.length;r++){t={type:4,min:Number.NaN,max:Number.NaN,value:e[r].value,field:e[r].field};var o=i.fields.indexOf(t.field);-1!==o&&(s[o]=t)}var a=i.insertRow(s);shmi.visuals.session.DataGridManager.saveRowToDB(i.name,a,!0)}))}else shmi.log("[UserAction] createrow - Form '"+e[0]+"' not found!",3)}},shmi.visuals.session.sysActions["test-action"]=function(e,t){console.log("UiAction: test-action",e,t)},shmi.visuals.session.sysActions.notify=function(e,t){shmi.notify(e[0],e[1])},shmi.visuals.session.sysActions.setlocale=function(e,t){1===e.length?shmi.requires("visuals.session.UserManager").setLocale(e[0]):console.error("[UiAction:setlocale] missing parameter: Locale")},shmi.visuals.session.sysActions["acknowledge-all-alarms"]=function(){shmi.requires("visuals.session.AlarmManager").ackAlarm(-1)},shmi.visuals.session.sysActions.navigate=function(e){var t=null;e.forEach((function(e,i,s){if(i%2==0){var n=shmi.ctrl("."+e,t);if(null===n)throw new Error("could not resolve control: "+e);var r=!1;if("screen"===n.uiType?n.viewElements.forEach((function(e,t){r||e.getAttribute("data-name")===s[i+1]&&(n.setView(t),r=!0)})):n.controls.forEach((function(e,t){r||"view"===e.uiType&&e.element.getAttribute("data-name")===s[i+1]&&(n.setView(t),r=!0)})),!r)throw new Error("could not resolve control: "+s[i+1]);t=n}}))},function(){shmi.pkg("visuals.core");var e=0;shmi.visuals.core.User=function(e){this.loggedIn=!1,this.name=e,this.locale=null,this.actUrl=null,this.homeUrl=null,this.groupList=[],this.userData={},this.groupData={},this.autoLogoffTime=0,this.newPasswordRequired=0,this.firstName=null,this.lastName=null,this.description=null},shmi.visuals.core.User.prototype={setProperties:function(e){this.loggedIn=null!==e,this.locale=e?e.locale_id:null,this.actUrl=null,this.homeUrl=null,this.groupList=e?e.groups:[],this.userData=e&&e.data?e.data:{},this.groupData=e&&e.group_data?e.group_data:{},this.firstName=e&&"string"==typeof e.first_name?e.first_name:null,this.lastName=e&&"string"==typeof e.last_name?e.last_name:null,this.description=e&&"string"==typeof e.comment?e.comment:null;var t=!!e&&e.password_is_expired;this.loggedIn&&(this.newPasswordRequired=t,this.newPasswordRequired&&console.info("[User]","current password expired"));var i=e?e.auto_logout_duration:0;isNaN(i)||(this.autoLogoffTime=i,console.debug("[User]","auto-logoff set to",i,"seconds."))},resetInactivity:function(){var t=this;clearTimeout(e),e=0,t.autoLogoffTime>0&&(e=setTimeout((function(){shmi.visuals.session.UserManager.logout(),console.debug("[User]","user logged out after being inactive for",t.autoLogoffTime,"seconds")}),1e3*t.autoLogoffTime))},getUserData:function getUserData(e,t){return shmi.checkArg("key",e,"string"),shmi.checkArg("lookupIn",t,"string","array","undefined"),void 0===t?t=["user","group"]:"string"==typeof t&&(t=[t]),t.includes("user")&&shmi.objectHasOwnProperty(this.userData,e)?this.userData[e]:t.includes("group")&&shmi.objectHasOwnProperty(this.groupData,e)?this.groupData[e]:null}}}(),shmi.pkg("visuals.core"),shmi.visuals.core.UserManager=function(){this.currentUser=null,this.loggedIn=!1,this.userList={},this.userListCallback=null,this.credentialProviders=[],this.credentialProviderNextId=0,this.registerDefaultCredentialProviders()},shmi.visuals.core.UserManager.prototype={registerCredentialProvider:function registerCredentialProvider(e,t){shmi.checkArg("priority",e,"number"),shmi.checkArg("providerFunc",t,"function");const i=++this.credentialProviderNextId;return this.credentialProviders.push({id:i,priority:e,func:t}),this.credentialProviders.sort(({priority:e},{priority:t})=>t-e),i},unregisterCredentialProvider:function unregisterCredentialProvider(e){shmi.checkArg("providerId",e,"number");const t=this.credentialProviders.findIndex(({id:t})=>t===e);this.credentialProviders.splice(t)},registerDefaultCredentialProviders:function registerDefaultCredentialProviders(){this.registerCredentialProvider(0,()=>{const e=shmi.visuals.session;return e.URLParameters.usr&&e.URLParameters.pwd?{username:e.URLParameters.usr,password:e.URLParameters.pwd}:null}),this.registerCredentialProvider(0,()=>{const e=shmi.visuals.session;return"false"===e.URLParameters.autoLogin?null:e.config["auto-login"]&&e.config["auto-login"].enabled?e.config["auto-login"].user?e.config["auto-login"].password?{username:e.config["auto-login"].user,password:e.config["auto-login"].password}:(console.warn("[UserManager] Auto-Login is enabled in configuration but no 'password' given."),null):(console.warn("[UserManager] Auto-Login is enabled in configuration but no 'user' given."),null):null}),this.registerCredentialProvider(0,()=>{const e=shmi.visuals.session;return"false"===e.URLParameters.autoLogin?null:e.config.observer&&e.config.observer.enabled&&e.observerAllowed?e.config.observer.user?e.config.observer.password?{username:e.config.observer.user,password:e.config.observer.password}:(console.warn("[UserManager] Auto-Observer is enabled in configuration but no 'password' given."),null):(console.warn("[UserManager] Auto-Observer is enabled in configuration but no 'user' given."),null):null})},setUserList:function(e){var t=this,i=shmi.requires("visuals.tools.iterate").iterateObject;i(t.userList,(function(e,i){delete t.userList[i]})),i(e,(function(i,s){t.userList[e[s]]=new shmi.visuals.core.User(e[s])})),t.userListCallback&&(t.userListCallback(t.userList),t.userListCallback=null)},setProperties:function(e,t,i,s){var n=this,r=!1,o=null;this.currentUser?(this.currentUser.name===e?(r=this.currentUser.loggedIn,o=this.currentUser.locale,this.currentUser.setProperties(t),this.currentUser.loggedIn&&!r?(i&&i(0),shmi.fire("login-state",{name:e,loggedIn:!0,locale:this.currentUser.locale},this)):this.currentUser.loggedIn&&r?(o!==this.currentUser.locale&&this._reloadLocale(),shmi.fire("login-state",{name:e,loggedIn:!0,locale:this.currentUser.locale},this)):i?(i(s||1),shmi.fire("login-state",{name:e,loggedIn:!1,locale:this.currentUser.locale},this)):this.currentUser.loggedIn||(shmi.log("[UserManager] already logged-in user tried to login with invalid credentials",2),shmi.fire("login-state",{name:e,loggedIn:!1,locale:this.currentUser.locale},this))):(i&&i(0),r=this.currentUser.loggedIn,o=this.currentUser.locale,this.currentUser.name=e,this.currentUser.setProperties(t),this.currentUser.loggedIn&&r?(o!==this.currentUser.locale&&this._reloadLocale(),shmi.fire("login-state",{name:e,loggedIn:!0,locale:this.currentUser.locale},this)):this.currentUser.loggedIn?(this._reloadLocale(),shmi.fire("login-state",{name:e,loggedIn:!0,locale:this.currentUser.locale},this)):shmi.fire("login-state",{name:e,loggedIn:!1,locale:this.currentUser.locale},this)),this.currentUser.resetInactivity(),function testPasswordExpired(){n.currentUser.loggedIn&&n.currentUser.newPasswordRequired&&shmi.fire("password-expired",{name:n.currentUser.name,user:n.currentUser},n,!0)}()):this.userList[e]?this.userList[e].setProperties(t):shmi.log("[UserManager] User '"+e+"' not found.",2)},_reloadLocale:function(){var e=this,t=shmi.visuals.session,i=t.UserManager;function load_json_locale(){shmi.decouple((function(){shmi.loadResource(shmi.evalString(shmi.c("LOCALE_PATH_PATTERN"),{index:i.currentUser.locale}),e._resetSession.bind(e))}))}!0===t.config.load_locale_db&&"function"==typeof shmi.loadDBLocale?shmi.loadDBLocale(i.currentUser.locale,load_json_locale):load_json_locale()},_resetSession:function(e,t,i){if(shmi.visuals.session.locale=shmi.visuals.session.locale||{},t)console.error("[UserManager] failed to load locale resource:",i);else{var s={},n={},r=shmi.requires("visuals.tools.iterate").iterateObject;try{n=JSON.parse(e),r(n,(function(e,t){shmi.visuals.session.locale[t]=n[t]}))}catch(e){console.error("[UserManager] failed to parse new locale:",i,e)}for(shmi.visuals.session.ItemManager.removeAll(),shmi.visuals.session.AlarmManager.removeAll(),shmi.decouple(shmi.visuals.session.DataGridManager.restart.bind(shmi.visuals.session.DataGridManager)),r(shmi.visuals.session.names,(function(e,t){-1===t.indexOf(".")&&shmi.deleteControl(e.ctrl)}));document.body.firstChild;)document.body.removeChild(document.body.firstChild);if(shmi.visuals.session.config["show-load-screen"]){var o=document.createElement("div"),a=shmi.pkg("visuals.session.SysControlConfig.loadingOverlay");o=document.createElement(a.tagName||"DIV"),shmi.addClass(o,a["class-name"]||"loading-box-overlay"),a.template&&shmi.loadResource(shmi.c("TEMPLATE_PATH")+a.template+shmi.c("TEMPLATE_EXT"),(function(e,t){t||(o.innerHTML=e)})),document.body.appendChild(o)}shmi.decouple(()=>{this.restartSession(s,o),shmi.log("[RESTART] CALLED",0),shmi.visuals.session.startScripts&&r(shmi.visuals.session.startScripts,(function(e,t){shmi.log("[RESTART] running script: "+t,0);try{shmi.visuals.session.startScripts[t]()}catch(e){shmi.log("[RESTART] failed to execute start-script '"+t+"': "+e,2)}}))}),shmi.log("[UserManager] Bookmark: "+s,0)}},requestLogin:function(e,t,i){var s=this,n=shmi.requires("visuals.session").SocketConnection,r=shmi.requires("visuals.tools.connect").request;if(!0!==n.connected)throw new Error("socket connection is not established yet");this.currentUser=new shmi.visuals.core.User(e),this.pwd=t,r("user.login",{username:e,password:t},(function onRequest(t,r){0===r?(s.setProperties(e,t,i,r),n.connectCallback&&s.currentUser&&s.currentUser.loggedIn&&(n.connectCallback=null)):s.setProperties(e,null,i,r)}))},requestAutoLogin:function(e){const t=this,i=this.credentialProviders.slice();(function tryNext(){if(0===i.length)return Promise.reject(new Error("Auto-Login credentials exhausted"));{const e=i.shift();return Promise.resolve(e.func()).then(i=>i?new Promise((s,n)=>{t.requestLogin(i.username,i.password,t=>{e.statusCallback&&e.statusCallback(!t),t?n(t):s()})}):tryNext())}})().then(e.bind(null,0)).catch(e.bind(null))},requestTokenAuth:function(e,t){const i=this,s=shmi.requires("visuals.session").SocketConnection,{request:n}=shmi.requires("visuals.tools.connect");if(!0!==s.connected)throw new Error("socket connection has not been established yet");i.currentUser=null,i.pwd=null,n("user.auth",{token:e},(function onRequest(e,n){0===n?(i.currentUser=new shmi.visuals.core.User(e.username),i.setProperties(e.username,e,t,n),s.connectCallback&&i.currentUser&&i.currentUser.loggedIn&&(s.connectCallback=null)):"function"==typeof t&&i.setProperties(null,null,t,n)}))},requestAuthToken:function(e,t){const i=shmi.requires("visuals.session").SocketConnection,{request:s}=shmi.requires("visuals.tools.connect");if(!0!==i.connected)throw new Error("socket connection has not been established yet");s("user.token",e,(function onRequest(e,i){0===i?t(e,null):"function"==typeof t&&t(null,i)}))},requestUserList:function(e){var t=this,i=shmi.requires("visuals.tools.connect").request;if(!0!==shmi.visuals.session.SocketConnection.connected)throw new Error("socket connection is not established yet");this.userListCallback=e,i("user.list",{},(function(e,i){var s=[];e&&Array.isArray(e.users)?e.users.forEach((function(e){s.push(e.username)})):console.error("[UserManager] could not retrieve userlist:",i.category,i.errc,i.message),t.setUserList(s)}))},logout:function(e){var t=this,i=shmi.requires("visuals.tools.connect").request,s=shmi.requires("visuals.tools.iterate.iterateObject"),n=shmi.visuals.session.ItemManager;s(n.views,(function(e,t){n.closeView(t)})),i("user.logout",{},(function onRequest(i,s){0===s&&t.setProperties(null,null),"function"==typeof e&&e(i,s)}))},changePassword:function(e,t,i){(0,shmi.requires("visuals.tools.connect").request)("user.setpw",{current_password:e,new_password:t},(function(e,s){s||(this.pwd=t),i&&i(e,s)}))},restartSession:function(e,t){var i=document.createDocumentFragment(),s=document.createElement("div");for(s.innerHTML=shmi.visuals.session.ProjectSource,i.appendChild(s);i.firstChild.firstChild;)document.body.appendChild(i.firstChild.firstChild);shmi.visuals.session.names={};var n=document.getElementById("viewportMeta");n&&n.setAttribute("content",n.getAttribute("content").replace("user-scalable=no","user-scalable=yes")),shmi.loadResource(shmi.c("VIRTUAL_ITEMS_CONFIG_PATH"),(function(i,s,n){s?console.error("error loading virtual-item config",n):shmi.visuals.init.initVItems(JSON.parse(i));const r=shmi.visuals.parser.parseProject(e);shmi.waitOnInit(r,()=>{const e=document.createEvent("Event"),i=shmi.visuals.session;shmi.log("[UserManager] All controls initialized",2),e.initEvent("resize",!0,!0),window.dispatchEvent(e),shmi.visuals.session.config["show-load-screen"]&&setTimeout((function(){!1===i.config["load-screen-transition"]?document.body.removeChild(t):(t.style.opacity=0,t.addEventListener("transitionend",(function(){document.body.removeChild(t)})),t.addEventListener("webkitTransitionEnd",(function(){document.body.removeChild(t)})))}),shmi.c("LOAD_TIMEOUT")),shmi.fire("parser-ready",{},shmi.visuals.session)})}))},resetInactivity:function(){this.currentUser&&this.currentUser.loggedIn&&this.currentUser.resetInactivity()},setLocale:function(e,t){var i,s=this,n=null,r=s.getLocaleInfo(),o=shmi.requires("visuals.tools.connect");if(!s.currentUser||!s.currentUser.loggedIn)throw new Error("No user logged in, cannot change locale");if(!(r&&r.locales&&r.locales[e]))throw new Error("Locale not configured: "+e);i=s.currentUser.locale,o.request("user.setlang",{locale_id:e},(function onResponse(r,o){0===o?(s.currentUser.locale=e,i!==e?(s._reloadLocale(),n=shmi.listen("parser-ready",(function(){n.unlisten(),shmi.fire("login-state",{name:s.currentUser.name,loggedIn:!0,locale:e},s),t&&t(o)}))):t&&t(o)):(shmi.notify("${V_ERROR_LOCALE_CHANGE}","${V_ERROR}",{LOCALE:e,ERROR_CODE:o}),t&&t(o))}))},getLocaleInfo:function(){return shmi.cloneObject(shmi.visuals.session.localeInfo)},getUserData:function getUserData(e,t){return this.currentUser?this.currentUser.getUserData(e,t):null},setUserData:function setUserData(e,t){const{ConnectSession:i}=shmi.visuals.session;if(shmi.checkArg("data",e,"object"),shmi.checkArg("callback",t,"function","undefined"),!this.currentUser)throw new Error("No user logged in, cannot set user data");i.request("user.set_data",e,(i,s)=>{!s&&this.currentUser&&Object.entries(e).forEach(([e,t])=>{void 0===t||(null===t?delete this.currentUser.userData[e]:this.currentUser.userData[e]=t)}),t?t(i,s):s&&console.error("[UserManager]","Failed to set user data.","\n\tWebIQ Server returned",s,"\n\tData was",e)})},clearUserData:function clearUserData(e){const{ConnectSession:t}=shmi.visuals.session;if(shmi.checkArg("callback",e,"function","undefined"),!this.currentUser)throw new Error("No user logged in, cannot clear user data");t.request("user.clear_data",{},(t,i)=>{!i&&this.currentUser&&(this.currentUser.userData={}),e?e(t,i):i&&console.error("[UserManager]","Failed to clear user data.","\n\tWebIQ Server returned",i)})}},function(){shmi.pkg("visuals.io");var e=1e3;function isTouchMode(t){return t.sourceCapabilities?t.sourceCapabilities.firesTouchEvents:t.timeStamp-shmi.visuals.io.TouchListener.prototype.lastTimeStamp<e}shmi.visuals.io.MouseListener=function(e,t){/iPhone/.test(navigator.userAgent)||/iPad/.test(navigator.userAgent)||/Android/.test(navigator.userAgent)?this.inactive=!0:(this.element=e,this.startX=0,this.startY=0,this.dx=0,this.dy=0,this.totalDx=0,this.totalDy=0,this.last_click_time=0,this.double_click_time=500,this.mousepressed=!1,this.moved=!1,this.functions=t,this.mousedown=this.mouseDown.bind(this),this.mouseup=this.mouseUp.bind(this),this.mousemove=this.mouseMove.bind(this),this.mouseover=this.mouseOver.bind(this),this.mouseout=this.mouseOut.bind(this),this.mousewheel=this.mouseWheel.bind(this),this.moveDiv=null,this._inactiveReset=function(){shmi.visuals.session.UserManager.resetInactivity()},this.init())},shmi.visuals.io.MouseListener.prototype={init:function(){},disable:function(){this.inactive||(this.mousepressed=!1,window.navigator.msPointerEnabled?(this.element.removeEventListener("MSPointerDown",this.mousedown),this.element.removeEventListener("MSPointerOver",this.mouseover),this.element.removeEventListener("MSPointerUp",this.mouseup),this.element.removeEventListener("MSPointerMove",this.mousemove),this.element.removeEventListener("MSPointerOut",this.mouseout),this.moveDiv&&(this.moveDiv.removeEventListener("MSPointerMove",this.mousemove),this.moveDiv.removeEventListener("MSPointerUp",this.mouseup),this.moveDiv.removeEventListener("MSPointerOut",this.mouseout),document.body.removeChild(this.moveDiv),this.moveDiv=null)):(this.element.removeEventListener("mousedown",this.mousedown),this.element.removeEventListener("mouseover",this.mouseover),this.element.removeEventListener("mouseup",this.mouseup),this.element.removeEventListener("mousemove",this.mousemove),this.element.removeEventListener("mouseout",this.mouseout),this.moveDiv&&(this.moveDiv.removeEventListener("mousemove",this.mousemove),this.moveDiv.removeEventListener("mouseup",this.mouseup),this.moveDiv.removeEventListener("mouseout",this.mouseout),document.body.removeChild(this.moveDiv),this.moveDiv=null)),this.functions.onWheel&&(this.element.removeEventListener("mousewheel",this.mousewheel),this.element.removeEventListener("DOMMouseScroll",this.mousewheel)))},enable:function(){this.inactive||(window.navigator.msPointerEnabled?(this.element.removeEventListener("MSPointerDown",this.mousedown),this.element.removeEventListener("MSPointerOver",this.mouseover),this.element.removeEventListener("MSPointerUp",this.mouseup),this.element.removeEventListener("MSPointerMove",this.mousemove),this.element.removeEventListener("MSPointerOut",this.mouseout),this.moveDiv&&(this.moveDiv.removeEventListener("MSPointerMove",this.mousemove),this.moveDiv.removeEventListener("MSPointerUp",this.mouseup),this.moveDiv.removeEventListener("MSPointerOut",this.mouseout),document.body.removeChild(this.moveDiv),this.moveDiv=null),this.element.addEventListener("MSPointerMove",this.mousemove),this.element.addEventListener("MSPointerUp",this.mouseup),this.element.addEventListener("MSPointerOut",this.mouseout),this.element.addEventListener("MSPointerDown",this.mousedown)):(this.element.removeEventListener("mousedown",this.mousedown),this.element.removeEventListener("mouseover",this.mouseover),this.element.removeEventListener("mouseup",this.mouseup),this.element.removeEventListener("mousemove",this.mousemove),this.element.removeEventListener("mouseout",this.mouseout),this.moveDiv&&(this.moveDiv.removeEventListener("mousemove",this.mousemove),this.moveDiv.removeEventListener("mouseup",this.mouseup),this.moveDiv.removeEventListener("mouseout",this.mouseout),document.body.removeChild(this.moveDiv),this.moveDiv=null),this.element.addEventListener("mouseover",this.mouseover),this.element.addEventListener("mouseout",this.mouseout),this.element.addEventListener("mousedown",this.mousedown),this.element.addEventListener("mousemove",this.mousemove),this.element.addEventListener("mouseup",this.mouseup)),this.functions.onWheel&&(this.element.addEventListener("mousewheel",this.mousewheel),this.element.addEventListener("DOMMouseScroll",this.mousewheel)))},mouseDown:function(e){this._inactiveReset(),0!==e.button||isTouchMode(e)||(this.moved=!1,this.startX=e.clientX,this.startY=e.clientY,this.totalDx=0,this.totalDy=0,this.dx=0,this.dy=0,this.mousepressed=!0,this.functions.onPress&&!e.consumed&&(this.functions.onPress(this.startX,this.startY,e),e.consumed=!0),this.functions.onDrag&&e.stopPropagation())},mouseUp:function(e){if(this._inactiveReset(),!isTouchMode(e)){if(this.functions.onRelease&&this.functions.onRelease(e.clientX,e.clientY,e),!this.moved&&this.mousepressed&&this.functions.onClick&&(e.preventDefault(),!e.consumed))if(e.consumed=!0,this.functions.onDoubleClick){var t=Date.now();t-this.last_click_time<this.double_click_time?this.functions.onDoubleClick(e.clientX,e.clientY,e):(this.functions.onClick(e.clientX,e.clientY,e),this.last_click_time=t)}else this.functions.onClick(e.clientX,e.clientY,e);this.mousepressed=!1,this.functions.onDrag&&e.stopPropagation(),this.moved=!1,window.navigator.msPointerEnabled?this.moveDiv&&(this.moveDiv.removeEventListener("MSPointerMove",this.mousemove),this.moveDiv.removeEventListener("MSPointerUp",this.mouseup),this.moveDiv.removeEventListener("MSPointerOut",this.mouseout),document.body.removeChild(this.moveDiv),this.moveDiv=null):this.moveDiv&&(this.moveDiv.removeEventListener("mousemove",this.mousemove),this.moveDiv.removeEventListener("mouseup",this.mouseup),this.moveDiv.removeEventListener("mouseout",this.mouseout),document.body.removeChild(this.moveDiv),this.element.addEventListener("mouseout",this.mouseout),this.moveDiv=null)}},mouseMove:function(e){if(this._inactiveReset(),!isTouchMode(e)&&this.mousepressed)if(this.dx=e.clientX-this.startX,this.dy=e.clientY-this.startY,this.totalDx+=this.dx,this.totalDy+=this.dy,this.startX=e.clientX,this.startY=e.clientY,this.moved=Math.abs(this.totalDx)+Math.abs(this.totalDy)>=shmi.c("MIN_MOVED_PX"),this.functions.onDrag){if(!this.moved)return;if(e.shmi&&e.shmi.listeners)for(var t=e.shmi.listeners.pop();void 0!==t;)t.mouseUp(e),t=e.shmi.listeners.pop();if(this.functions.onDrag(this.dx,this.dy,e),window.navigator.msPointerEnabled)try{e.target.setPointerCapture(e.pointerId)}catch(t){try{e.target.msSetPointerCapture(e.pointerId)}catch(e){shmi.log("Error - Could not set pointer capture of event: "+e,2)}}else null===this.moveDiv&&(this.moveDiv=document.createElement("div"),this.moveDiv.setAttribute("class","mouselistener-overlay"),window.navigator.msPointerEnabled?(this.element.removeEventListener("MSPointerOut",this.mouseout),document.body.appendChild(this.moveDiv),this.moveDiv.addEventListener("MSPointerMove",this.mousemove),this.moveDiv.addEventListener("MSPointerUp",this.mouseup)):(this.element.removeEventListener("mouseout",this.mouseout),document.body.appendChild(this.moveDiv),this.moveDiv.addEventListener("mousemove",this.mousemove),this.moveDiv.addEventListener("mouseup",this.mouseup),this.moveDiv.addEventListener("mouseout",this.mouseout)));e.stopPropagation()}else e.shmi=e.shmi||{},e.shmi.listeners=e.shmi.listeners||[],e.shmi.listeners.push(this)},mouseOver:function(e){this._inactiveReset(),isTouchMode(e)||shmi.testParentChild(this.element,e.relatedTarget)||(this.functions.onRelease&&this.mousepressed&&this.functions.onRelease(e.clientX,e.clientY,e),this.mousepressed=!1,this.functions.onEnter&&this.functions.onEnter())},mouseOut:function(e,t){if(this._inactiveReset(),!isTouchMode(e)){if(shmi.testParentChild(this.element,e.relatedTarget)){if(!t)return}else if(this.moveDiv){var i=e.srcElement||e.originalTarget;if(this.moveDiv!==i)return}this.functions.onRelease&&this.mousepressed&&this.functions.onRelease(e.clientX,e.clientY,e),this.mousepressed=!1,this.moveDiv&&(this.moveDiv.removeEventListener("mousemove",this.mousemove),this.moveDiv.removeEventListener("mouseup",this.mouseup),this.moveDiv.removeEventListener("mouseout",this.mouseout),document.body.removeChild(this.moveDiv),this.moveDiv=null),this.functions.onLeave&&this.functions.onLeave()}},mouseWheel:function(e){this._inactiveReset(),isTouchMode(e)||(e.stopPropagation(),this.functions.onWheel&&("DOMMouseScroll"===e.type?this.functions.onWheel(-50*e.detail,e):this.functions.onWheel(e.wheelDelta,e)))}}}(),shmi.pkg("visuals.io"),shmi.visuals.io.ResourceLoader=function(){this.resources={},this.active=0},shmi.visuals.io.ResourceLoader.prototype={loadResource:function(e,t,i,s){this.resources[e]&&!i?this.addCallback(e,t):i?shmi.visuals.io.loadResourceHttp(e,(function(i,s){t(i,s,e)}),s):(this.active++,this.createResource(e),this.addCallback(e,t),shmi.visuals.io.loadResourceHttp(e,function(t,i){null===t&&(i=!0),this.resources[e].data=t,this.resources[e].failed=i,this.notifyCallbacks(e)}.bind(this),s))},notifyCallbacks:function(e){var t=this.resources[e];t&&Array.isArray(t.callbacks)&&(t.callbacks.forEach((function(i){"function"==typeof i&&i(t.data,t.failed,e)})),t.callbacks=[])},createResource:function(e){this.resources[e]={},this.resources[e].data=null,this.resources[e].failed=!1,this.resources[e].callbacks=[]},addCallback:function(e,t){null!==this.resources[e].data||this.resources[e].failed?t(this.resources[e].data,this.resources[e].failed,e):this.resources[e].callbacks.push(t)}},function(){function broadcastEvent(e,t,i){e.eventsEnabled&&shmi.fire(t,i,e)}function onSocketOpen(e){shmi.log("[SocketConnection] On Open",0);const t={observerAllowed:!1,Host:{}};e.connecting=!1,e.connected=!0,e.connectSession.request("connect.info",{},(function(i,s){if(0!==s)return broadcastEvent(e,"session-data-update",{error:s}),void(e.connectCallback&&(shmi.log("[SocketConnection] Connect Callback",0),e.connectCallback(shmi.c("FAIL"))));t.Host.name=i.hostname,t.Host.version=i.version,void 0===i.version.patch&&(t.Host.version.patch=i.version.revision),t.project=i.current_project,e.connectSession.request("util.islocal",{},(function(i,s){s&&console.warn("[SocketConnection]","unable to check whether client is on local network interface"),t.observerAllowed=!0===i,e.sessionInfo=t,broadcastEvent(e,"connection-state",{established:!0,url:e.url,error:null,connecting:!1}),broadcastEvent(e,"session-data-update",t),e.connectCallback&&(shmi.log("[SocketConnection] Connect Callback",0),e.connectCallback(shmi.c("SUCCESS")))}))}))}function onSocketMessage(e,t){e.debugCallback&&e.debugCallback(t.data),e.connectSession.postMessage(JSON.parse(t.data))}function onSocketClose(e){shmi.log("[SocketConnection] connection closed (URL: '"+e.url+"')",2),e.connected=!1,broadcastEvent(e,"connection-state",{established:!1,url:e.url,error:null,connecting:!1}),e.connect(e.connectCallback)}function onSocketError(e,t){shmi.log("[SocketConnection] connection error: "+t,2),console.log("ERROR Event:",t),broadcastEvent(e,"connection-state",{established:!1,url:e.url,error:t,connecting:!1})}shmi.pkg("visuals.io"),shmi.visuals.io.SocketConnection=function(e,t){this.socket=null,this.url=e,this.protocol="smarthmi-connect",this.connecting=!1,this.connected=!1,this.aksreconnect=!1,this.attempts=0,this.maxConnectionAttempts=parseInt(shmi.visuals.session.config["max-connection-attempts"])||shmi.c("DEFAULT_CONNECTION_ATTEMPTS"),this.connectCallback=null,this.debugCallback=null,this.msgHandlers={},this.timeout=parseInt(shmi.visuals.session.config["socket-timeout"])||shmi.c("DEFAULT_CONNECTION_TIMEOUT"),this.timeoutId=0,this.connectSession=t,this.eventsEnabled=!1},shmi.visuals.io.SocketConnection.prototype={constructor:shmi.visuals.io.SocketConnection,init:function(){this.socket.onopen=onSocketOpen.bind(null,this),this.socket.onmessage=onSocketMessage.bind(null,this),this.socket.onclose=onSocketClose.bind(null,this),this.socket.onerror=onSocketError.bind(null,this)},getSocket:function(){return this.socket},enableEvents:function(){this.eventsEnabled=!0},connect:function(e){this.connectCallback=e;try{this.connected&&(shmi.log("[SocketConnection] socket already connected, disconnecting first ... ",2),this.socket.close())}catch(e){shmi.log("[SocketConnection] could not connect to socket")}if(this.connecting=!0,broadcastEvent(this,"connection-state",{established:!1,url:this.url,error:null,connecting:!0}),-1!==this.maxConnectionAttempts&&this.attempts>=this.maxConnectionAttempts)return broadcastEvent(this,"connection-failed",{socket:this,session:shmi.visuals.session}),void("function"==typeof e&&e(shmi.c("FAIL")));this.socket=new WebSocket(this.url,this.protocol),this.attempts++,shmi.log("[SocketConnection] Connecting...",2),this.init()},disconnect:function(){this.connected=!1,null!==this.socket&&this.socket.close(),this.socket=null},sendMessage:function(e){null!==this.socket?1===this.socket.readyState?(this.debugSendCallback&&this.debugSendCallback(e),this.socket.send(e)):shmi.log("[SocketConnection] EOS2 - state "+this.socket.readyState,0):shmi.log("[SocketConnection] EOS1 - state "+this,0)},isConnected:function(){return this.connected}}}(),function(){function getOffsetLeft(e){var t=0;do{isNaN(e.offsetLeft)||(t+=e.offsetLeft),e=e.offsetParent}while(e);return t}function getOffsetTop(e){var t=0;do{isNaN(e.offsetTop)||(t+=e.offsetTop),e=e.offsetParent}while(e);return t}function updateTimestamp(e){shmi.visuals.io.TouchListener.prototype.lastTimeStamp=e}shmi.pkg("visuals.io"),shmi.visuals.io.TouchListener=function(e,t,i){window.navigator.msPointerEnabled?this.inactive=!0:(this.element=e,this.touches={},this.last_click_time=0,this.double_click_time=500,this.moved=!1,this.functions=t,this.prevent_drag_scroll_x=!0,this.prevent_drag_scroll_y=!0,this.passive=void 0===i||!i,this.touchstart=this.touchStart.bind(this),this.touchend=this.touchEnd.bind(this),this.touchmove=this.touchMove.bind(this),this.touchcancel=this.touchCancel.bind(this),this.mouseover=function(){this.functions.onLeave&&(document.body.removeEventListener("mouseover",this.mouseover),this.functions.onLeave())}.bind(this),this._inactiveReset=function(){shmi.visuals.session.UserManager.resetInactivity()},this.init())},shmi.visuals.io.TouchListener.prototype={lastTimeStamp:0,init:function(){},disable:function(){this.inactive||(this.element.removeEventListener("touchstart",this.touchstart),this.element.removeEventListener("touchend",this.touchend),this.element.removeEventListener("touchcancel",this.touchend),this.element.removeEventListener("touchmove",this.touchmove))},enable:function(){this.inactive||(this.element.removeEventListener("touchstart",this.touchstart),this.element.addEventListener("touchstart",this.touchstart,{passive:this.passive}))},getNumberOfTouches:function(){var e=shmi.requires("visuals.tools.iterate").iterateObject,t=0;return e(this.touches,(function(e,i){t++})),t},touchStart:function(e){this._inactiveReset(),updateTimestamp(e.timeStamp);for(var t=0;t<e.changedTouches.length;t++)if(shmi.testParentChild(this.element,e.changedTouches[t].target)){var i=e.changedTouches[t],s=i.identifier;this.touches[s]={},this.touches[s].startPageX=i.pageX,this.touches[s].startPageY=i.pageY,this.touches[s].pageX=i.pageX,this.touches[s].pageY=i.pageY,this.touches[s].startX=i.clientX,this.touches[s].startY=i.clientY,this.touches[s].dx=0,this.touches[s].dy=0,this.touches[s].time=Date.now(),this.functions.onDrag&&this.cancelTimer(s),this.functions.onEnter&&(document.body.removeEventListener("mouseover",this.mouseover),document.body.addEventListener("mouseover",this.mouseover),e.preventDefault(),this.functions.onEnter()),this.functions.onPress&&!e.consumed&&(this.functions.onPress(this.touches[s].startX,this.touches[s].startY,e),e.consumed=!0)}this.functions.onDrag&&e.stopPropagation(),this.element.removeEventListener("touchend",this.touchend),this.element.removeEventListener("touchcancel",this.touchend),this.element.removeEventListener("touchmove",this.touchmove),this.element.addEventListener("touchend",this.touchend),this.element.addEventListener("touchcancel",this.touchend),this.element.addEventListener("touchmove",this.touchmove)},cancelTimer:function(e){void 0!==this.touches[e]&&(this.touches[e].checktime===this.touches[e].time?this.touchCancel({}):(this.touches[e].checktime=this.touches[e].time,setTimeout(function(){this.cancelTimer(e)}.bind(this),shmi.c("DRAG_TIMEOUT"))))},touchEnd:function(e){this._inactiveReset(),updateTimestamp(e.timeStamp);for(var t=0,i=0,s=0;s<e.changedTouches.length;s++)if(shmi.testParentChild(this.element,e.changedTouches[s].target)){var n=e.changedTouches[s].identifier;void 0!==this.touches[n]&&(t=this.touches[n].startX,i=this.touches[n].startY,this.functions.onRelease&&this.functions.onRelease(t,i,e),delete this.touches[n])}if(0===this.getNumberOfTouches()){if(!this.moved&&this.functions.onClick){if(!e.consumed)if(e.consumed=!0,this.functions.onDoubleClick){var r=Date.now();r-this.last_click_time<this.double_click_time?this.functions.onDoubleClick(t,i,e):(this.functions.onClick(t,i,e),this.last_click_time=r)}else this.functions.onClick(t,i,e);e.preventDefault()}this.element.removeEventListener("touchmove",this.touchmove),this.element.removeEventListener("touchend",this.touchend),this.element.removeEventListener("touchcancel",this.touchend),this.moved=!1}this.functions.onDrag&&e.stopPropagation()},touchCancel:function(e){var t=this,i=shmi.requires("visuals.tools.iterate").iterateObject;t._inactiveReset(),updateTimestamp(e.timeStamp),i(t.touches,(function(e,i){delete t.touches[i]})),t.functions.onRelease&&t.functions.onRelease(0,0,e),t.element.removeEventListener("touchmove",t.touchmove),t.element.removeEventListener("touchend",t.touchend),t.element.removeEventListener("touchcancel",t.touchend),t.moved=!1},touchMove:function(e){var t=this,i=shmi.requires("visuals.tools.iterate").iterateObject;if(t._inactiveReset(),updateTimestamp(e.timeStamp),1===t.getNumberOfTouches()){for(var s=0,n=0,r=0,o=0,a=0;a<e.changedTouches.length;a++)if(shmi.testParentChild(t.element,e.changedTouches[a].target)){var l=e.changedTouches[a],u=l.identifier;s=l.clientX-t.touches[u].startX,n=l.clientY-t.touches[u].startY,t.touches[u].startX=l.clientX,t.touches[u].startY=l.clientY,t.touches[u].time=Date.now(),void 0!==t.touches[u].totalDx?(t.touches[u].totalDx+=s,t.touches[u].totalDy+=n):(t.touches[u].totalDx=s,t.touches[u].totalDy=n),r=t.touches[u].totalDx,o=t.touches[u].totalDy;break}if(!(Math.abs(r)>=shmi.c("MIN_MOVED_PX")||Math.abs(o)>=shmi.c("MIN_MOVED_PX")))return t.functions.onDrag&&(Math.abs(r)>Math.abs(o)?t.prevent_drag_scroll_x&&(e.stopPropagation(),e.preventDefault()):t.prevent_drag_scroll_y&&(e.stopPropagation(),e.preventDefault())),void(t.moved=!1);t.moved=!0,t.functions.onDrag&&(e.stopPropagation(),t.functions.onDrag(s,n,e))}else t.moved=!0;if(2===t.getNumberOfTouches()){for(a=0;a<e.changedTouches.length;a++)shmi.testParentChild(t.element,e.changedTouches[a].target)&&(u=(l=e.changedTouches[a]).identifier,s=l.clientX-t.touches[u].startX,n=l.clientY-t.touches[u].startY,t.touches[u].startX=l.clientX,t.touches[u].startY=l.clientY,t.touches[u].pageDx=void 0===t.touches[u].pageX?l.pageX-t.touches[u].startPageX:l.pageX-t.touches[u].pageX,t.touches[u].pageDy=void 0===t.touches[u].pageY?l.pageY-t.touches[u].startPageY:l.pageY-t.touches[u].pageY,t.touches[u].pageX=l.pageX,t.touches[u].pageY=l.pageY,t.touches[u].dx=s,t.touches[u].dy=n,t.touches[u].time=Date.now());var c=[];if(i(t.touches,(function(e,t){var i={};i.x=e.startX-e.dx,i.y=e.startY-e.dy,c.push(i)})),i(t.touches,(function(e,t){var i={};i.x=e.startX,i.y=e.startY,c.push(i)})),t.functions.onRotate){e.preventDefault();var h=(c[0].x-c[1].x)/2,m=(c[0].y-c[1].y)/2,d=(c[2].x-c[3].x)/2,f=(c[2].y-c[3].y)/2,g=Math.atan2(f,d)-Math.atan2(m,h);t.functions.onRotate(g)}var p=[];if(i(t.touches,(function(e,i){p.push({x:e.startPageX-getOffsetLeft(t.element),y:e.startPageY-getOffsetTop(t.element)})})),i(t.touches,(function(e,i){p.push({x:e.pageX-getOffsetLeft(t.element),y:e.pageY-getOffsetTop(t.element)})})),t.functions.onScale){e.preventDefault();var v=Math.abs(p[0].x-p[1].x),b=Math.abs(p[0].y-p[1].y),y=Math.abs(p[2].x-p[3].x),w=Math.abs(p[2].y-p[3].y),_=0===v||v/b<.3?1:y/v,T=0===b||b/v<.3?1:w/b,A=Math.sqrt(Math.pow(p[0].x-p[1].x,2)+Math.pow(p[0].y-p[1].y,2)),E=Math.sqrt(Math.pow(p[2].x-p[3].x,2)+Math.pow(p[2].y-p[3].y,2))/A,k=(p[2].x+p[3].x)/2,I=(p[2].y+p[3].y)/2;t.functions.onScale(E,k,I,_,T,p)}}}}}(),shmi.pkg("visuals.gfx"),shmi.visuals.gfx.Animation=function(e,t,i){this.startValue=0,this.endValue=0,this.currentValue=0,this.animDuration=0,this.startTime=null,this.drawCallback=e,this.completeCallback=t,this.requestID=0,this.animate=!1,this.priority=!1,this.timer_func=void 0!==this.TIMERS[i]?this.TIMERS[i]:this.TIMERS.linear},shmi.visuals.gfx.Animation.prototype={TIMERS:{linear:function(e){return e},ease_in:function(e){return e*e*e},ease_out:function(e){return(e-1)*(e-1)*(e-1)+1},ease_in_out:function(e){return e<.5?4*e*e*e:(e-1)*(2*e-2)*(2*e-2)+1}},start:function(e,t){this.startValue=this.currentValue,this.endValue=e,void 0!==t&&(this.animDuration=t),this.animate=!0,this.startTime=null,this.requestID&&shmi.caf(this.requestID),this.requestID=shmi.raf(this.draw.bind(this),this.priority)},setCurrentValue:function(e){this.currentValue=e},draw:function(e){if(this.animate){if(null===this.startTime&&(this.startTime=e),this.animDuration){var t=this.endValue-this.startValue,i=e-this.startTime;i>this.animDuration&&(i=this.animDuration);var s=i/this.animDuration;s>1&&(s=1);var n=i/this.animDuration,r=t*this.timer_func(n);this.currentValue=this.startValue+r,t>=0?this.currentValue>=this.endValue&&(this.currentValue=this.endValue,this.animate=!1,this.startTime=null):this.currentValue<=this.endValue&&(this.currentValue=this.endValue,this.animate=!1,this.startTime=null),this.drawCallback(this.currentValue)}else this.currentValue=this.endValue,this.animate=!1,this.startTime=null,this.drawCallback(this.endValue);shmi.caf(this.requestID),this.requestID=shmi.raf(this.draw.bind(this),this.priority)}else this.completeCallback&&(this.completeCallback(),shmi.log("[Animation] complete callback called",0))},stop:function(){this.animate=!1}},function(){"use strict";shmi.pkg("visuals.gfx");const e={linear:e=>e,ease_in:e=>e*e*e,ease_out:e=>(e-1)*(e-1)*(e-1)+1,ease_in_out:e=>e<.5?4*e*e*e:(e-1)*(2*e-2)*(2*e-2)+1},t="linear";function getTimerFunction(t){const i=e[t];if(!i)throw new Error(`Timer function "${t}" does not exist.`);return i}class AlphaTransition{constructor(e=null,i=t){this._initialValue=e,this._currentValue=e,this._targetValue=null,this._startTime=null,this._currentTime=null,this._duration=0,this._timerFunc=getTimerFunction(i)}start(e,t,i){this.isDone()&&(this._currentTime=null),i&&(this._timerFunc=getTimerFunction(i)),null===this._currentValue&&(this._currentValue=e),this._initialValue=this._currentValue,this._startTime=this._currentTime,this._targetValue=e,this._duration=t}startFrom(e,t,i,s){this._currentValue=e,this.start(t,i,s)}cancel(){this._duration=0,this._targetValue=this._currentValue}update(e){if(this.isDone())return;this._startTime||(this._startTime=e);const t=Math.min(Math.max(0,(e-this._startTime)/this._duration),1),i=this._timerFunc(t),s=this._initialValue+(this._targetValue-this._initialValue)*i;this._currentValue=isNaN(s)?this._targetValue:s,this._currentTime=e}isDone(){return this._currentValue===this._targetValue}getValue(){return this._currentValue}}function allAnimationsDone(e){for(const t in e._animations)if(!e._animations[t].isDone())return!1;return!0}function onDraw(e,t){const i={};for(const s in e._animations){const n=e._animations[s];n.update(t),i[s]=n.getValue()}e._raf=null,queueAnimationFrame(e),e._animationCallback(Object.freeze(i)),e._completeCallback&&allAnimationsDone(e)&&e._completeCallback()}function queueAnimationFrame(e,t=!1){e._raf||!t&&allAnimationsDone(e)||(e._raf=shmi.raf(onDraw.bind(null,e)))}function getAnimation(e,t){let i=e._animations[t];return i||(i=new AlphaTransition,e._animations[t]=i),i}shmi.visuals.gfx.AnimationBundle=class AnimationBundle{constructor(e,t=null){shmi.checkArg("animationCallback",e,"function"),shmi.checkArg("completeCallback",t,"function","null"),this._animations={},this._animationCallback=e,this._completeCallback=t,this._raf=null}static registerTimerFunction(t,i){if(shmi.checkArg("functionName",t,"string"),shmi.checkArg("timerFunc",i,"function"),shmi.objectHasOwnProperty(e,t))throw new Error(`Timer with name ${t} has already been registered`);e[t]=i}static timerFunctionExists(t){return shmi.objectHasOwnProperty(e,t)}static timerFunctions(){return Object.keys(e)}prepare(e,i=null,s=t){if(shmi.checkArg("animationName",e,"string"),shmi.checkArg("initialValue",i,"number","null"),shmi.checkArg("timingMode",s,"string"),this._animations[e])throw new Error(`Animation with name ${e} already exists`);this._animations[e]=new AlphaTransition(i,s)}start(e,t,i="default",s=null){shmi.checkArg("targetValue",e,"number"),shmi.checkArg("duration",t,"number"),shmi.checkArg("animationName",i,"string"),shmi.checkArg("timingMode",s,"string","null"),getAnimation(this,i).start(e,t,s),queueAnimationFrame(this,!0)}startFrom(e,t,i,s="default",n=null){shmi.checkArg("startValue",e,"number"),shmi.checkArg("targetValue",t,"number"),shmi.checkArg("duration",i,"number"),shmi.checkArg("animationName",s,"string"),shmi.checkArg("timingMode",n,"string","null"),getAnimation(this,s).startFrom(e,t,i,n),queueAnimationFrame(this,!0)}cancel(e="default",t=!1){shmi.checkArg("animationName",e,"string"),shmi.checkArg("deleteAnimation",t,"boolean"),this._animations[e]&&(t?delete this._animations[e]:this._animations[e].cancel(),this._raf&&allAnimationsDone(this)&&(shmi.caf(this._raf),this._raf=null))}refresh(){queueAnimationFrame(this,!0)}getValues(){const e={};for(const t in this._animations)e[t]=this._animations[t].getValue();return Object.freeze(e)}}}(),shmi.pkg("visuals.gfx"),shmi.visuals.gfx.Movable=function(e,t){this.el=e,this.transitionStyle="all .25s",this.s=t&&"number"==typeof t.scale?t.scale:1,this.sx=t&&"number"==typeof t.scaleX?t.scaleX:1,this.sy=t&&"number"==typeof t.scaleY?t.scaleY:1,this.startX=0,this.startY=0,this.rotatable=!0,this.scalable=!0,this.tx=t&&"number"==typeof t.translateX?t.translateX:0,this.ty=t&&"number"==typeof t.translateY?t.translateY:0,this.rot=0,this.max_s=1.5,this.min_s=.5,this.transition=!1,this.tfComplete=!1,this.requestID=0,this.priority=!1,this.tf="scale(1.0) translate(0px, 0px) rotate(0deg)",this.draw()},shmi.visuals.gfx.Movable.prototype={rotate:function(e){this.rot+=e,this.update()},translate:function(e,t){this.tx+=e,this.ty+=t,this.update()},scale:function(e){this.s*=e,this.s<this.min_s?this.s=this.min_s:this.s>this.max_s&&(this.s=this.max_s),this.sx*=e,this.sx<this.min_s?this.sx=this.min_s:this.sx>this.max_s&&(this.sx=this.max_s,this.sy*=e),this.sy<this.min_s?this.sy=this.min_s:this.sy>this.max_s&&(this.sy=this.max_s),this.update()},draw:function(){this.tfComplete?(this.tf=`scale3d(${this.sx.toFixed(3)}, ${this.sy.toFixed(3)}, 1) rotate3d(0,0,1,${this.rot.toFixed(3)}deg)`,this.el.style.transform=this.tf,this.startX=this.startX+this.tx,this.startY=this.startY+this.ty,this.tx=0,this.ty=0,this.tfComplete=!1):(this.updateTransform(),this.el.style.transform=this.tf)},update:function(){this.requestID&&shmi.caf(this.requestID),this.requestID=shmi.raf(this.draw.bind(this),this.priority)},updateTransform:function(){this.tf=`translate3d(${this.tx.toFixed(0)}px, ${this.ty.toFixed(0)}px, 0px)`,this.scalable&&(this.tf+=` scale3d(${this.sx.toFixed(3)}, ${this.sy.toFixed(3)}, 1)`),this.rotatable&&(this.tf+=` rotate3d(0,0,1,${this.rot.toFixed(0)}deg)`)},setTransition:function(e){this.transition=e,this.transition?this.el.style.transition=this.transitionStyle:this.el.style.transition=""},completeTransform:function(){this.tfComplete=!0,this.update()},forceAccOff:function(){this.draw()}},Function.prototype.bind||(Function.prototype.bind=function(e){if("function"!=typeof this)throw new TypeError("Function.prototype.bind - what is trying to be bound is not callable");var t=Array.prototype.slice.call(arguments,1),i=this,fNOP=function(){},fBound=function(){return i.apply(this instanceof fNOP&&e?this:e,t.concat(Array.prototype.slice.call(arguments)))};return fNOP.prototype=this.prototype,fBound.prototype=new fNOP,fBound}),document.documentElement.addEventListener("MSHoldVisual",(function(e){e.preventDefault()}),!1),shmi.c("MIN_CONNECT_VERSION",.921),shmi.c("DEFAULT_CONNECTION_TIMEOUT",-1),shmi.c("DEFAULT_CONNECTION_ATTEMPTS",1),shmi.c("DEFAULT_VIEW","View1"),shmi.c("DEFAULT_QUERY_RESULTS",4096),shmi.c("DB_CFG_RO",0),shmi.c("DB_CFG_RW",1),shmi.c("DB_HMI_RO",2),shmi.c("DB_HMI_RW",3),shmi.c("DB_USR_RO",4),shmi.c("DB_USR_RW",5),shmi.c("DB_CUSTOM_RO",6),shmi.c("DB_CUSTOM_RW",7),shmi.c("TEMPLATE_PATH","templates/"),shmi.c("TEMPLATE_EXT",".html"),shmi.c("CONFIG_PATH","json/"),shmi.c("CONFIG_EXT",".json"),shmi.c("APP_CONFIG_PATH","json/project.json"),shmi.c("GROUP_CONFIG_PATH","json/groups/config.json"),shmi.c("LOCALE_INDEX_PATH","json/locale/index.json"),shmi.c("LOCALE_PATH_PATTERN","json/locale/lang/<%= index %>.json"),shmi.c("KEYBOARD_PATH_PATTERN","json/locale/keyboard/<%= index %>.json"),shmi.c("MEDIA_QUERIES_CONFIG_PATH","json/media-queries.json"),shmi.c("SYS_CONTROLS_CONFIG_PATH","json/sys-config/sys-controls.json"),shmi.c("SYS_HANDLERS_CONFIG_PATH","json/sys-config/sys-handlers.json"),shmi.c("VIRTUAL_ITEMS_CONFIG_PATH","json/virtual-items.json"),shmi.c("DGM_GRID_MAP_PATH","json/grids/grid_map.json"),shmi.c("GRID_PATH_PATTERN","json/grids/<%= name %>.json"),shmi.c("UNITCLASS_CONFIG_PATH","json/unit-classes.json"),shmi.c("LOAD_TIMEOUT",350),shmi.c("DECOUPLE_TIMEOUT",50),shmi.c("ACTION_RETRY_TIMEOUT",150),shmi.c("DRAG_TIMEOUT",1e3),shmi.c("SUCCESS",0),shmi.c("FAIL",1),shmi.c("MIN_UPDATE_INTERVAL",9),shmi.c("RAF_FALLBACK_TIMEOUT",33),shmi.c("CHECK_INIT_INTERVAL",100),shmi.c("LOG_DEBUG",0),shmi.c("LOG_INFO",1),shmi.c("LOG_MSG",2),shmi.c("LOG_ERROR",3),shmi.c("TYPE_STRING",0),shmi.c("TYPE_BOOL",1),shmi.c("TYPE_INT",2),shmi.c("TYPE_FLOAT",3),shmi.c("DEFAULT_PAGE_SIZE",25),shmi.c("CSS_CONTROL_CLASS","ctrl"),shmi.c("NAME_SUFFIX","_"),shmi.c("MIN_MOVED_PX",15),shmi.c("RES_URL_PREFIX","res://"),shmi.c("DATAGRID_DB2_WRITE_DELAY",250),shmi.c("DEFAULT_LAYOUT_URL","layouts/default.html"),shmi.c("SERVER_TIME_ITEM","Systemzeit"),shmi.c("ALT_SERVER_TIME_ITEM","SYS_TIME"),shmi.c("MIN_PASSWORD_LENGTH",3),shmi.pkg("visuals.session"),shmi.visuals.session.GfxState={},shmi.visuals.session.GfxState.logAnimFallback=!0,shmi.visuals.session.GfxState.drawRequests={},shmi.visuals.session.GfxState.priorityRequests={},shmi.visuals.session.GfxState.drawId=1,shmi.visuals.session.GfxState.sysDrawId=1,shmi.visuals.session.GfxState.lastDrawTime=-1,shmi.pkg("visuals.gfx"),shmi.visuals.gfx.requestAnimFrame=function(e,t){var i=shmi.visuals.session.GfxState,s=i.drawId++;return t?i.priorityRequests[s]=e:i.drawRequests[s]=e,shmi.visuals.gfx.cancelAnimFrameImpl(i.sysDrawId),i.sysDrawId=shmi.visuals.gfx.requestAnimFrameImpl(shmi.visuals.gfx.drawAnimFrames),s},shmi.raf=shmi.visuals.gfx.requestAnimFrame,shmi.visuals.gfx.cancelAnimFrame=function(e){void 0!==shmi.visuals.session.GfxState.drawRequests[e]&&delete shmi.visuals.session.GfxState.drawRequests[e]},shmi.caf=shmi.visuals.gfx.cancelAnimFrame,shmi.visuals.gfx.drawAnimFrames=function(e){const t=shmi.visuals.session.GfxState,i=Object.values(t.priorityRequests);if(i.length)t.priorityRequests={},i.forEach(t=>{try{t(e)}catch(e){console.error("[Compatibility] PRIO - could not call animation frame request:",e)}}),t.sysDrawId=shmi.visuals.gfx.requestAnimFrameImpl(shmi.visuals.gfx.drawAnimFrames);else{const i=Object.values(t.drawRequests);t.drawRequests={},i.forEach(t=>{try{t(e)}catch(e){console.error("[Compatibility] could not call animation frame request:",e)}})}},shmi.visuals.gfx.requestAnimFrameImpl=(window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(e){return shmi.visuals.session.GfxState.logAnimFallback&&(shmi.visuals.session.GfxState.logAnimFallback=!1,shmi.log("[Compatibility] -- requestAnimationFrame not available, using fallback --",2)),setTimeout((function(){e(Date.now()+shmi.c("RAF_FALLBACK_TIMEOUT"))}),1)}).bind(window),shmi.visuals.gfx.cancelAnimFrameImpl=(window.cancelAnimationFrame||window.mozCancelAnimationFrame||window.webkitCancelAnimationFrame||function(e){clearTimeout(e)}).bind(window),shmi.pkg("visuals.io"),shmi.visuals.io.loadResourceHttp=function(e,t,i,s){function onStoreReady(){var i=shmi.visuals.session.ResourceLoader;void 0!==i.resources[e]?t(i.resources[e].data,i.resources[e].failed,e):t(null,!0,e)}if(!0!==s&&(s=!1),0!==e.indexOf(shmi.c("RES_URL_PREFIX"))){var n=new XMLHttpRequest;try{if("file:"===window.location.protocol){0===e.indexOf("./")&&(e=e.replace("./",""));var r=window.location.pathname,o=r.substring(0,r.lastIndexOf("/"));e="file://"+o+"/"+e,shmi.visuals.session.config&&shmi.visuals.session.config.debug&&console.debug("[Compatibility] open file-system path: "+e)}n.open("GET",e,!s),!0===i&&(n.responseType="arraybuffer")}catch(t){try{(n=new ActiveXObject("Microsoft.XMLHTTP")).open("GET",e,!s),!0===i&&(n.responseType="arraybuffer")}catch(e){shmi.log("[ResourceLoader] Exception during GET request.",3)}}n.onreadystatechange=function(){4===n.readyState&&200===n.status?t(!0===i?n.response:n.responseText,!1,e):4===n.readyState&&0===n.status?(shmi.visuals.session.config&&shmi.visuals.session.config.debug&&console.log("[ResourceLoader] local request '"+e+"' returned, Status: "+n.status),t(!0===i?n.response:n.responseText,!1,e)):4===n.readyState&&(shmi.visuals.session.config&&shmi.visuals.session.config.debug&&console.log("[ResourceLoader] Request '"+e+"' failed, Status: "+n.status),t("",!0,e))};try{n.send()}catch(e){shmi.log("[ResourceLoader] exception during get request: "+e,2),t("",!0)}}else{if(shmi.requires("visuals.tools.json-store").isReady())onStoreReady();else var a=shmi.listen("data-store-loaded",(function(e){shmi.unlisten("data-store-loaded",a),onStoreReady()}))}},shmi.pkg("visuals.session"),function(){var e=shmi.pkg("visuals.session.ParserState");e.controlTypes=[],e.containerTypes=[]}(),shmi.visuals.session.msgHandlers={},shmi.visuals.session.Layout=shmi.visuals.session.Layout||{},function(){for(var e=0;e<shmi.visuals.session.ParserState.controlTypes.length;e++)shmi.visuals.session.Layout[shmi.visuals.session.ParserState.controlTypes[e][0]]=new Array}(),function(){for(var e in shmi.visuals.controls)if(e.charAt(0)===e.charAt(0).toUpperCase()&&void 0!==shmi.visuals.controls[e].prototype&&(shmi.log("[Parser] is control class: "+e,1),void 0!==shmi.visuals.controls[e].prototype.uiType)){var t=shmi.visuals.controls[e].prototype.uiType;shmi.log("  ui-type: "+shmi.visuals.controls[e].prototype.uiType,1);var i=!1;!0===shmi.visuals.controls[e].prototype.isContainer&&(i=!0,shmi.log("  is ui-container",1)),shmi.registerControlType(t,shmi.visuals.controls[e],i)}}(),shmi.pkg("visuals.parser"),function(){function getDefaultConfig(e,t){var i=shmi.pkg("visuals.default.ControlConfig"),s=shmi.requires("visuals.tools.iterate.iterateObject"),n={};return i[e]&&(console.debug("[visuals.parser]","applying default config",e,t),s(i[e].config,(function(e,t){n[t]=e})),i[e].variants&&i[e].variants[t]&&s(i[e].variants[t],(function(e,t){n[t]=e}))),n}shmi.visuals.parser.getDefaultConfig=getDefaultConfig,shmi.visuals.parser.parseControls=function(e,t,i){e||(e=document.body,shmi.log("[Parser] BASE DOCUMENT.BODY",0));var s=[],n=shmi.visuals.session,r=n.ParserState.controlTypes,o={};r.forEach(e=>{o[e[0]]=e[1]});let a=[...e.querySelectorAll("[data-ui]")],l=[],u=null;return l=a.map(e=>({element:e,ui:e.getAttribute("data-ui")})),l=l.filter(e=>e.ui&&o[e.ui]),l=l.filter(t=>(function testBase(e,t){for(;e.parentNode&&e.parentNode!==t&&!e.parentNode.getAttribute("data-ui");)e=e.parentNode;return!(!e.parentNode||e.parentNode!==t)})(t.element,e)),l.forEach(e=>{let i=new o[e.ui](e.element,getDefaultConfig(e.ui));null===u&&(u={element:shmi.getParentContainerElement(e.element),control:null},!t&&u.element&&(u.control=shmi.getControlByElement(u.element))),i.uiType=e.ui,i.parentContainer=u.control,n.Layout[e.ui].push(i),t&&(n.Layout.topLevel=n.Layout.topLevel||[],n.Layout.topLevel.push(i)),i.fire("register",{}),s.push(i)}),t&&s.forEach(e=>{e.enable()}),s}}(),shmi.parseControls=shmi.visuals.parser.parseControls,shmi.visuals.parser.parseProject=function(e){for(var t in shmi.visuals.session.locale.VisualsVersion=shmi.visuals.Version,shmi.visuals.session.Layout)for(;shmi.visuals.session.Layout[t].pop();)shmi.log("Clear shmi.visuals.session.Layout",1);return shmi.visuals.parser.parseControls(null,!0,null)},shmi.pkg("visuals.init"),shmi.visuals.init.initVItems=function(e){e&&Array.isArray(e.items)&&e.items.forEach(e=>{e.name=`virtual:${e.name}`,shmi.createVirtualItem(e)})},shmi.visuals.defaultClient={run:function(e){var t=shmi.getUiElement("login");if(t){var i=shmi.requires("visuals.session.SysControlConfig");shmi.createControl(i.startupLogin.ui||"login",t,i.startupLogin,"DIV","from").enable()}else console.error("entrypoint contains no login control, aborting")}},shmi.visuals.init.onDgmReady=function(e){var t=shmi.requires("visuals.session");if(t.config&&t.config.debug&&console.log("=== DataGridManager initialized ==="),t.isReady=!0,shmi.fire("visuals-session-ready",{config:t.config},t),!0!==t.config["disable-app-layer"]){"string"!=typeof t.config["session-client"]&&(t.config["session-client"]="visuals.defaultClient");var i=t.config["session-client"];shmi.requires(i).run(t)}},function(){function initSession(e){shmi.requires("visuals.core.ItemManager"),shmi.requires("visuals.core.UserManager"),shmi.requires("visuals.core.QueryManager"),shmi.requires("visuals.core.AlarmManager"),shmi.requires("visuals.core.DataGridManager"),shmi.requires("visuals.core.RecipeManager"),shmi.requires("visuals.core.ConnectSession"),shmi.requires("visuals.core.EnvironmentManager"),shmi.requires("visuals.io.SocketConnection");var t=shmi.requires("visuals.tools.iterate.iterateObject"),i=shmi.visuals.session;if(i.config=i.config||{},t(e,(function(e,t){i.config[t]=e})),i.config.keyboard&&i.config.keyboard.enabled&&(i.config.keyboard.enabled=![/android/i,/ipad/i,/iphone/i].some(e=>e.test(navigator.userAgent))),shmi.def(i.config,"loglevel",2),shmi.def(i.config,"alertlevel",3),void 0===i.config["ws-url"]){var s=0===window.location.href.indexOf("https"),n=window.location.hostname,r=parseInt(window.location.port);void 0!==window.location.port&&""!==window.location.port||(r=s?443:80);var o="ws";s&&(o+="s"),o+="://"+n+":"+r+window.location.pathname,i.config["ws-url"]=o}else 0===window.location.href.indexOf("https")&&(i.config["ws-url"]=i.config["ws-url"].replace("ws://","wss://"));i.Host={version:{major:1,minor:0,patch:0}},i.ConnectSession=new shmi.visuals.core.ConnectSession(i.config["ws-url"]),i.SocketConnection=i.ConnectSession.socket,function setupConnectSession(e,t){t.socket.enableEvents(),shmi.listen("session-data-update",(function(t){t.detail.error?shmi.notify("Error requesting host information:"+t.detail.error.message,"${V_ERROR}"):(e.Host=t.detail.Host||e.Host,e.observerAllowed=t.detail.observerAllowed||e.observerAllowed,e.project=t.detail.project)}),{source:t.socket}),shmi.listen("connection-state",(function(t){Object.values(e.ItemManager.items).forEach(e=>{e.name.startsWith("virtual:")?(e.writable=!1,e.notifyLockStatus()):shmi.log("[SocketConnection] keeping local item '"+e.name+"' accessible",0)})}),{"detail.established":!1,"detail.connecting":!1,source:t.socket})}(i,i.ConnectSession),shmi.sendMessage=i.SocketConnection.sendMessage.bind(i.SocketConnection),shmi.registerMsgHandler=i.ConnectSession.registerMessageHandler.bind(i.ConnectSession),shmi.unregisterMsgHandler=i.ConnectSession.unregisterMessageHandler.bind(i.ConnectSession),i.URLParameters=function getUrlParams(){for(var e=new URL(window.location.href).searchParams.entries(),t=e.next(),i={};!t.done;)i[t.value[0]]=t.value[1],t=e.next();return i}(),i.ItemManager=new shmi.visuals.core.ItemManager,i.UserManager=new shmi.visuals.core.UserManager,i.QueryManager=new shmi.visuals.core.QueryManager,i.TrendManager=new shmi.visuals.core.TrendManager,i.AlarmManager=new shmi.visuals.core.AlarmManager,i.DataGridManager=new shmi.visuals.core.DataGridManager,i.RecipeManager=new shmi.visuals.core.RecipeManager,i.FileManager=new shmi.visuals.core.FileManager,i.EnvironmentManager=new shmi.visuals.core.EnvironmentManager,i.observerAllowed=!1,i.FocusElement=null,shmi.loadResource(shmi.c("VIRTUAL_ITEMS_CONFIG_PATH"),(function(e,t,s){if(t?console.error("failed to load virtual-item config",s):shmi.visuals.init.initVItems(JSON.parse(e)),i.DataGridManager.initialized)shmi.visuals.init.onDgmReady();else var n=shmi.listen("datagrid-manager",(function(e){n.unlisten(),shmi.visuals.init.onDgmReady()}))}))}function startConfig(e,t){if(shmi.pkg("visuals.session.locale"),shmi.pkg("visuals.session.keyboards"),"string"==typeof e.title&&(document.title=shmi.localize(e.title)),t?(t=JSON.parse(t),shmi.visuals.session.localeInfo=t):(console.log("Locale index could not be loaded!"),window.location.reload()),!0!==e["disable-app-layer"]){!function registerControls(){shmi.requires("visuals.tools.iterate.iterateObject")(shmi.visuals.controls,(function(e,t){if(e.prototype){var i=e.prototype&&e.prototype.isContainer;shmi.registerControlType(e.prototype.uiType,shmi.visuals.controls[t],i)}}))}();var i={controls:shmi.c("SYS_CONTROLS_CONFIG_PATH"),handlers:shmi.c("SYS_HANDLERS_CONFIG_PATH"),locale:shmi.evalString(shmi.c("LOCALE_PATH_PATTERN"),{index:t.default})};t.keyboards&&Object.keys(t.keyboards).forEach((function(e){i["keyboard_"+e]=shmi.evalString(shmi.c("KEYBOARD_PATH_PATTERN"),{index:e})})),shmi.multiLoad(i,(function(i){i.controls=JSON.parse(i.controls),i.handlers=JSON.parse(i.handlers),i.locale=JSON.parse(i.locale),i.keyboards=i.keyboards||{},t.keyboards&&Object.keys(t.keyboards).forEach((function(e){var t="keyboard_"+e;i.keyboards[e]=JSON.parse(i[t]),delete i[t]})),function initSysData(e){var t=shmi.pkg("visuals.session.SysControlConfig"),i=shmi.requires("visuals.tools.iterate.iterateObject"),s=shmi.requires("visuals.session"),n=shmi.requires("visuals.session.locale"),r=shmi.requires("visuals.session.keyboards"),o=shmi.requires("visuals.init.defaults"),a=o.HANDLER_CONFIG,l=o.CONTROLS_CONFIG;Object.assign(t,e.controls),i(l,(e,i)=>{t[i]||(t[i]=e)}),s.handlers=[],a.forEach(t=>{if(!Array.isArray(e.handlers.disabled)||-1===e.handlers.disabled.indexOf(t))try{shmi.requires(t).register(),s.handlers.push(t)}catch(e){console.error(`Error registering system handler '${t}': ${e.toString()}`)}}),e.handlers.handlers=e.handlers.handlers.filter(e=>-1===a.indexOf(e)).filter(t=>!Array.isArray(e.handlers.disabled)||-1===e.handlers.disabled.indexOf(t)),e.handlers.handlers.forEach(e=>{try{shmi.requires(e).register(),s.handlers.push(e)}catch(t){console.error(`Error registering custom handler '${e}': ${t.toString()}`)}}),i(e.locale,(function(e,t){n[t]=e})),i(e.keyboards,(function(e,t){r[t]=e}))}(i);var s=function getControlTemplates(e){var t=[];return shmi.requires("visuals.tools.iterate.iterateObject")(e,(function(e,i){e.template&&t.push(shmi.c("TEMPLATE_PATH")+e.template+shmi.c("TEMPLATE_EXT")),e["content-template"]&&t.push(shmi.c("TEMPLATE_PATH")+e["content-template"]+shmi.c("TEMPLATE_EXT"))})),t}(i.controls);shmi.multiLoad(s,(function(){initSession(e)}))}))}else initSession(e)}function loadUnitClassConfig(e){var t=shmi.requires("visuals.tools.unitClasses"),i=shmi.c("UNITCLASS_CONFIG_PATH");shmi.loadResource(i,(function(s,n){n?console.error("[Init] failed to load unit-class configuration:",i):t.setUnitClassConfig(s),e()}))}shmi.visuals.init.startup=function(){var e={appCfg:shmi.c("APP_CONFIG_PATH"),localeIndex:shmi.c("LOCALE_INDEX_PATH"),groupConfig:shmi.c("GROUP_CONFIG_PATH")},t=null,i=shmi.requires("visuals.session"),s=i.ResourceLoader,n=shmi.requires("visuals.tools.iterate.iterateObject");shmi.multiLoad(e,(function(e){let r=null;t=function mergeAppConfig(e){var t={},i=shmi.requires("visuals.tools.iterate.iterateObject");return e.appCfg&&i(JSON.parse(e.appCfg),(function(e,i){t[i]=e})),t}(e);try{r=JSON.parse(e.groupConfig)}catch(e){console.error("failed to load groups config:",e)}r||(r={}),i.groupConfig=r,t["app-data"]?shmi.loadResource(t["app-data"],(function(i,r,o){if(r)console.error("failed to load",o);else{var a=JSON.parse(i);n(a,(function(e,t){s.resources[t]=e,s.resources[t].callbacks=[]})),loadUnitClassConfig(startConfig.bind(null,t,e.localeIndex))}})):loadUnitClassConfig(startConfig.bind(null,t,e.localeIndex))}))}}(),shmi.visuals.session.ResourceLoader=new shmi.visuals.io.ResourceLoader,shmi.loadResource=shmi.visuals.session.ResourceLoader.loadResource.bind(shmi.visuals.session.ResourceLoader),window.addEventListener("load",shmi.visuals.init.startup),function(){var e=shmi.pkg("visuals.init.defaults");e.HANDLER_CONFIG=["visuals.handler.default.optionDialog","visuals.handler.default.cofirmation","visuals.handler.default.notification","visuals.handler.default.passwordExpired","visuals.handler.default.connectionFailed","visuals.handler.default.keyboard","visuals.handler.default.logout","visuals.handler.default.numpad"],e.CONTROLS_CONFIG={notificationDialog:{name:"notification-dialog",title:"${V_NOTIFICATION}",template:"default/sys-dialog/dialog-notification"},confirmDialog:{"class-name":"dialog-box confirm",title:"${V_CONFIRM_TITLE}",name:"visuals-confirm-dialog",template:"default/sys-dialog/dialog-confirm","cover-background":!0},optionDialog:{"class-name":"dialog-box option",title:"${V_OPTIONDIALOG_TITLE}",name:"visuals-option-dialog",template:"default/sys-dialog/dialog-option","cover-background":!0},askSaveDialog:{"class-name":"dialog-box ask-save",title:"${V_ASK_SAVE_TITLE}",name:"ask-save-dialog",template:"default/sys-dialog/dialog-ask-save","cover-background":!0},chooseFileDialog:{template:"default/sys-dialog/dialog-file"},passwordExpiredDialog:{"class-name":"dialog-box password-expired",name:"password-expired-dialog",template:"default/sys-dialog/dialog-password-expired",title:"${V_PASSWORD_EXPIRED_TITLE}","cover-background":!0},startupLogin:{"class-name":"login",template:"default/login",userEntry:'<div data-ui="user" class="user"><div class="userPic"></div><div class="user_detail"><h1 data-ui="user-name"><%= USER %></h1></div></div>'},loadingOverlay:{tagName:"DIV","class-name":"loading-box-overlay",template:null}}}(),function(){function makeErrorString(e,t,i){var s;return"number"==typeof e?s="Invalid type for parameter #"+String(e)+". ":"string"==typeof e&&(s='Invalid type for parameter "'+e+'". '),s+="Expected ",t.length>1?s+="one of ["+t.join(", ")+"]":s+=t[0],s+=" but "+i+" given."}function instanceOfHelper(e,t){return t.some((function(t){var i=function resolveClassType(e){var t=window;return!e.split(".").some((function(e){return!shmi.objectHasOwnProperty(t,e)||(t=t[e],!1)}))&&"function"==typeof t?t:null}(t);return i&&e instanceof i}))}shmi.pkg("visuals.tools.assert").checkArg=shmi.checkArg=function checkArg(e,t,i){var s,n,r=[],o=typeof t;for(s=2;s<arguments.length;++s)switch(arguments[s]){case"Object":case"Array":case"String":case"Number":r.push(arguments[s].toLowerCase());break;default:r.push(arguments[s])}if("number"!=typeof e&&"string"!=typeof e)throw TypeError("Invalid parameter name or parameter index");if("object"===o)if(null===t)o="null";else if(t.constructor)switch(n=Object.getPrototypeOf(t).constructor.name||"object"){case"Array":case"Object":o=n.toLowerCase();break;default:o=n}else o="object";if(-1===r.indexOf(o)&&-1===r.indexOf(typeof t)&&!instanceOfHelper(t,r))throw new TypeError(makeErrorString(e,r,o))}}(),function(){var e="visuals.tools.logging",t=shmi.pkg(e),i=getFLog(e),s={},n=20;function getFLog(e){return function(){for(var t="["+e+"]  ";t.length<n;)t+=" ";for(var i=[t],r=0;r<arguments.length;r++)i.push(arguments[r]);console.log.apply(console,i),void 0!==s[e]&&!0===s[e].record&&s[e].recordLog(i)}}function getErrorLog(e){return function(){for(var t="["+e+"]  ";t.length<n;)t+=" ";for(var i=[t],r=0;r<arguments.length;r++)i.push(arguments[r]);console.error.apply(console,i),void 0!==s[e]&&!0===s[e].record&&s[e].recordLog(i)}}function getWarnLog(e){return function(){for(var t="["+e+"]  ";t.length<n;)t+=" ";for(var i=[t],r=0;r<arguments.length;r++)i.push(arguments[r]);console.warn.apply(console,i),void 0!==s[e]&&!0===s[e].record&&s[e].recordLog(i)}}function getInfoLog(e){return function(){for(var t="["+e+"]  ";t.length<n;)t+=" ";for(var i=[t],r=0;r<arguments.length;r++)i.push(arguments[r]);console.info.apply(console,i),void 0!==s[e]&&!0===s[e].record&&s[e].recordLog(i)}}t.createLogger=function(t,i,n){if(shmi.objectHasOwnProperty(s,t))return s[t];var r=null;!0===n&&(r=[]);var o=getFLog(t),a=function getLog(e,t){return function(){!0===s[e].active&&t.apply(window,arguments)}}(t,o);return s[t]={log:a,error:getErrorLog(e),warn:getWarnLog(e),info:getInfoLog(e),fLog:o,active:!0===i,record:!0===n,getLog:function(){return r},recordLog:function(){r.push(arguments[0])}},s[t]},t.getLogger=function(e){return s[e]},t.getAllLoggers=function(){var e=shmi.requires("visuals.tools.iterate.iterateObject"),t=[];return e(s,(function(e,i){t.push(i)})),t},t.getActiveLoggers=function(){var e=shmi.requires("visuals.tools.iterate.iterateObject"),t=[];return e(s,(function(e,i){!0===e.active&&t.push(i)})),t},t.getRecordingLoggers=function(){var e=shmi.requires("visuals.tools.iterate.iterateObject"),t=[];return e(s,(function(e,i){!0===e.record&&t.push(i)})),t},t.enableLogger=function(e){s[e].active=!0},t.disableLogger=function(e){s[e].active=!1},i("module loaded")}(),function(){"use strict";var e=shmi.requires("visuals.tools.logging").createLogger("visuals.tools.enum",!1,!1),t=e.fLog;e.log;shmi.pkg("visuals.tools.enum").createEnum=function(e){if(!Array.isArray(e))throw new Error("argument has to be array of strings");var t={};return e.forEach((function(e,i){t[e]=i,t[i]=e})),t},t("module loaded")}(),function(){var e=shmi.requires("visuals.tools.logging").createLogger("visuals.tools.global-events",!1,!1),t=e.fLog,i=e.log,s=shmi.pkg("visuals.tools.global-events"),n=shmi.pkg("visuals.session");n.Events=n.Events||{},shmi.fire=function fireFunc(e,s,r,o=!1){void 0===r&&(r=null);const{iterateObject:a}=shmi.visuals.tools.iterate,l={source:r,type:e,detail:s};function fireAway(){let t=0;return a(n.Events[e],(function(e){e(l)&&t++})),t}function logFired(e){!0===n.config.event_debug?t("[session] event",l,"fired [",e,"listeners]"):i("[session] event",l,"fired [",e,"listeners]")}if(function initEvent(e){n.Events||(i("init session events"),n.Events={}),n.Events[e]||(i("creating event type",e),n.Events[e]={})}(e),o)return shmi.decouple(()=>logFired(fireAway())),0;const u=fireAway();return logFired(u),u},s.fire=shmi.fire,s.listen=shmi.listen,shmi.onSessionReady=function onSessionReady(e){if(n.isReady)e({source:n,type:"visuals-session-ready",detail:{config:n.config}});else var t=shmi.listen("visuals-session-ready",(function(i){shmi.unlisten("visuals-session-ready",t),e(i)}))},s.onSessionReady=shmi.onSessionReady,t("module loaded")}(),function(){var e=shmi.requires("visuals.tools.logging").createLogger("visuals.tools.iterate",!1,!1),t=e.fLog,i=(e.log,shmi.pkg("visuals.tools.iterate"));i.iterateNodeList=function iterateNodeList(e,t){for(var i=0;i<e.length;i++)t(e[i],i,e)},i.iterateObject=function iterateObject(e,t){Object.keys(e||{}).forEach(i=>{shmi.objectHasOwnProperty(e,i)&&t(e[i],i,e)})},t("module loaded")}(),function(){var e=shmi.requires("visuals.tools.logging").createLogger("visuals.tools.control-generator",!1,!1),t=e.fLog,i=(e.log,shmi.pkg("visuals.tools.control-generator"));var s=shmi.pkg("visuals.controls");i.generate=function(e){s[e.className]=function makeConstructor(e){var t=shmi.requires("visuals.tools.iterate.iterateObject");return function(i,s){var n=this;if(!(i instanceof HTMLElement))throw new Error("base element must be instance of HTMLElement");n.element=i,n.config=s,n.parseAttributes(),n.imports={},t(e.imports,(function(e,t,i){if("string"==typeof e)n.imports[t]=shmi.requires(e);else{if("function"!=typeof e)throw new Error("import must either be a shmi-package name or a function returning a reference");n.imports[t]=e()}})),t(shmi.cloneObject(e.config),(function(e,t,i){shmi.def(n.config,t,e)})),!0===e.isContainer&&(n.controls=[]),n.vars=shmi.cloneObject(e.vars),n.startup()}}(e),s[e.className].prototype=function makePrototype(e){var t=shmi.requires("visuals.tools.iterate.iterateObject"),i=Object.create(shmi.visuals.core.BaseControl.prototype);return i.uiType=e.uiType,i.isContainer=e.isContainer,i.isContainer&&(i.containerProperties=e.containerProperties),i.events=shmi.cloneObject(shmi.visuals.core.BaseControl.prototype.events),Array.isArray(e.events)&&e.events.forEach((function(e,t){if(e in i.events)throw new Error("event type already defined: "+e);i.events.push(e)})),i.getClassName=function(){return e.className},t(e.prototypeExtensions,(function(e,t,s){i[t]=e})),i}(e),shmi.registerControlType(e.uiType,s[e.className],e.isContainer)},t("module loaded")}(),function(){var e=shmi.requires("visuals.tools.logging").createLogger("visuals.tools.lsdir",!1,!1),t=e.fLog,i=(e.log,shmi.pkg("visuals.tools.lsdir"));i.ls=function ls(e,t){(0,shmi.requires("visuals.tools.connect").request)("fs.ls",[e],(function onRequest(e,i){i||e[0].error?t(i||e[0].error,null):t(0,e[0].listing)}))},shmi.lsdir=i.ls,t("module-loaded")}(),function(){var e=shmi.requires("visuals.tools.logging").createLogger("visuals.tools.item-adapter",!0,!1),t=e.fLog,i=(e.log,shmi.pkg("visuals.tools.item-adapter")),s={};i.createAdapter=function(e){if("string"!=typeof e.name)throw new Error("adapter name has to be of type string");if("function"!=typeof e.inFunction)throw new Error("adapter inFunction has to be of type function");if("function"!=typeof e.outFunction)throw new Error("adapter outFunction has to be of type function");if(!Array.isArray(e.itemTypes))throw new Error("adapter itemTypes has to be an array");s[e.name]=e},i.setAdapter=function(e,t){var i=shmi.requires("visuals.session.ItemManager").getItem(e),n=s[t];if(!i)throw new Error("item '"+e+"' does not exist");if(!n)throw new Error("adapter '"+t+"' does not exist");if(!function isTypeCompatible(e,t){var i=!1;return t.itemTypes.forEach((function(t){e.type===shmi.c(t)&&(i=!0)})),i}(i,n))throw new Error("type of item '"+i.name+"' is not compatible with adapter '"+n.name+"'");i.adapter=n,i._updateValue=Math.random(),i.notifyLockStatus(),i.notifyUpdateTargets()},i.unsetAdapter=function(e){var t=shmi.requires("visuals.session.ItemManager").getItem(e);if(t){t.adapter=null,t._updateValue=Math.random();try{t.notifyLockStatus(),t.notifyUpdateTargets()}catch(e){console.error("exception clearing adapter:",e)}}else console.error("item '"+e+"' does not exist")},i.getAdapter=function(e){return s[e]?s[e]:null},i.getActiveAdapter=function(e){var t=shmi.requires("visuals.session.ItemManager").getItem(e),i=null;return t&&t.adapter&&(i=t.adapter),i},i.listAdapters=function(){t("loaded adapters:"),shmi.requires("visuals.tools.iterate.iterateObject")(s,(function(e,i){t(i,e.itemTypes.toString())})),t("--------")},t("module loaded")}(),function(){var e="visuals.tools.unitClasses",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),i=t.fLog,s=t.log,n=shmi.pkg(e),r="json/unit-classes.json",o=null,a=null,l={},u="virtual:num-unitclasses",c="virtual:unitclass-<%= UNITCLASS_ID %>-adapter",h=shmi.requires("visuals.tools.item-adapter"),m=shmi.requires("visuals.tools.iterate.iterateObject"),d=0;function unitClassDataLoaded(e,t){t?console.error("failed to load unit-class data from",r):(o=JSON.parse(e).unitClasses,console.debug("loaded unit-class data from",r),l={},d=0,function processUnitClassData(){o.forEach((function(e,t){void 0===l[e.unitClass]&&(l[e.unitClass]={name:e.name?e.name:null,unitClass:e.unitClass,adapters:[],selectedAdapter:null});var i=function makeAdapter(e){return{name:"item-adapter"+d++,unitText:e.unitText,inFunction:function(t){return parseFloat(((t-e.offset)/e.factor).toFixed(3))},outFunction:function(t){return parseFloat((t*e.factor+e.offset).toFixed(3))},itemTypes:["TYPE_FLOAT","TYPE_INT","TYPE_STRING"]}}(e);l[e.unitClass].adapters.push(i),h.createAdapter(i)})),s("created",d,"adapters")}())}function setUnitClassAdapter(e,t){const i=shmi.visuals.session.ItemManager,s=l[e];if(void 0===s)console.error("unitclass",e,"is not defined");else{const n=h.getAdapter(t);if(n){s.selectedAdapter=n,m(i.items,(function(i,s){i.unitClass===e&&(console.debug("setting item-adapter of",s,"to",t),h.setAdapter(s,t))}));const r=shmi.evalString(c,{UNITCLASS_ID:s.unitClass}),o=i.getItem(r);o&&o.initialized&&i.writeValue(r,s.adapters.indexOf(s.selectedAdapter))}else console.error("adapter",t,"is not defined")}}n.getUnitClasses=function(){var e=[];return m(l,(function(t){e.push(t)})),e},n.getUnitClassData=function(){return o},n.getUnitClassAdapters=function(e){return void 0!==l[e]?l[e].adapters:null},n.getSelectedAdapter=function(e){return void 0!==l[e]?l[e].selectedAdapter:null},n.setUnitClassAdapter=setUnitClassAdapter,n.setUnitClassConfig=function setUnitClassConfig(e){a=e},shmi.listen("visuals-session-ready",(function(t){a?unitClassDataLoaded(a,!1):console.error(e,"unit-class configuration not loaded!")})),shmi.listen("parser-ready",(function setupUnitClassItems(){var e=0;m(l,(function(t,i){t.adapters.length>0&&(null===t.selectedAdapter&&(t.selectedAdapter=h.getAdapter(t.adapters[0].name)),setUnitClassAdapter(t.unitClass,t.selectedAdapter.name),e++)})),m(l,(function(e,t){var i=shmi.evalString(c,{UNITCLASS_ID:e.unitClass}),s=e.adapters.indexOf(e.selectedAdapter);("number"!=typeof s||s<0)&&(s=0),shmi.createVirtualItem(i,shmi.c("TYPE_INT"),0,e.adapters.length-1,s,function getUnitClassSelectionCB(e){return function(t){console.debug("set unitclass",e.unitClass,"adapter to",e.adapters[t].name);const i=n.getSelectedAdapter(e.unitClass);(!i||e.adapters[t]&&i.name!==e.adapters[t].name)&&setUnitClassAdapter(e.unitClass,e.adapters[t].name)}}(e)).labelToken=e.name}));var t=shmi.createVirtualItem(u,shmi.c("TYPE_INT"),Number.NEGATIVE_INFINITY,Number.POSITIVE_INFINITY,e,null);t.writable=!1,t.notifyLockStatus()})),i("module loaded")}(),function(){var e=shmi.requires("visuals.tools.logging").createLogger("visuals.tools.date",!1,!1),t=e.fLog,i=(e.log,shmi.pkg("visuals.tools.date")),s={dayShort:["${V_SUN_SHORT}","${V_MON_SHORT}","${V_TUE_SHORT}","${V_WED_SHORT}","${V_THU_SHORT}","${V_FRI_SHORT}","${V_SAT_SHORT}"],dayLong:["${V_SUN}","${V_MON}","${V_TUE}","${V_WED}","${V_THU}","${V_FRI}","${V_SAT}"],monthShort:["${V_JAN}","${V_FEB}","${V_MAR}","${V_APR}","${V_MAY}","${V_JUN}","${V_JUL}","${V_AUG}","${V_SEP}","${V_OCT}","${V_NOV}","${V_DEC}"]};function DateTimeBuffer(){this.reset()}DateTimeBuffer.prototype.reset=function reset(){this.millisecond=0,this.second=0,this.minute=0,this.hour=0,this.isPM=null,this.day=1,this.month=0,this.year=0,this.timestamp=null,this.timezone=0},DateTimeBuffer.prototype.assemble=function assemble(){if(null!==this.isPM&&this.hour>12)return null;if(null!==this.timestamp)return new Date(this.timestamp-6e4*this.timezone);var e=(!0===this.isPM?12:0)+this.hour;return new Date(Date.UTC(this.year,this.month,this.day,e,this.minute-this.timezone,this.second,this.millisecond))};var n={YYYY:{serializeUTC:Date.prototype.getUTCFullYear,serialize:Date.prototype.getFullYear,parse:function(e,t){e.year=Number(t)},regex:/^(\d{4})/},YY:{serializeUTC:function(){return this.getUTCFullYear().subsctr(-2,2)},serialize:function(){return this.getFullYear().substr(-2,2)},parse:function(e,t){e.year=(t<68?2e3:1900)+Number(t)},regex:/^(\d{2})/},Y:{serializeUTC:Date.prototype.getUTCFullYear,serialize:Date.prototype.getFullYear,parse:function(e,t){e.year=Number(t)},regex:/^(-?\d{1,4})/},Q:{serializeUTC:function(){return 1+Math.floor(this.getUTCMonth()/3)},serialize:function(){return 1+Math.floor(this.getMonth()/3)},parse:function(e,t){e.month=3*(t-1)},regex:/^([1-4])/},M:{serializeUTC:function(){return this.getUTCMonth()+1},serialize:function(){return this.getMonth()+1},parse:function(e,t){e.month=Number(t)-1},regex:/^([1][0-2]|0?[1-9])/},MM:"$M",D:{serializeUTC:Date.prototype.getUTCDate,serialize:Date.prototype.getDate,parse:function(e,t){e.day=Number(t)},regex:/^([12][0-9]|3[01]|0?[1-9])/},DD:"$D",DDD:{serializeUTC:function(){return(Date.UTC(this.getUTCFullYear(),this.getUTCMonth(),this.getUTCDate())-Date.UTC(this.getUTCFullYear(),0,0))/24/60/60/1e3},serialize:function(){return(Date.UTC(this.getFullYear(),this.getMonth(),this.getDate())-Date.UTC(this.getFullYear(),0,0))/24/60/60/1e3},parse:function(e,t){e.month=0,e.day=Number(t)},regex:/^(\d{1,3})/},DDDD:"$DDD",X:{serialize:function(){return Math.floor(this.getTime()/1e3)},parse:function(e,t){e.reset(),e.timestamp=1e3*Number(t)},regex:/^(-?\d+(\.\d+)?)/},x:{serialize:Date.prototype.getTime,parse:function(e,t){e.reset(),e.timestamp=Number(t)},regex:/^(-?\d+)/},w:{serializeUTC:function(){return 1+Math.floor((Date.UTC(this.getUTCFullYear(),this.getUTCMonth(),this.getUTCDate())-Date.UTC(this.getUTCFullYear(),0,0))/24/60/60/1e3/7)},serialize:function(){return 1+Math.floor((Date.UTC(this.getFullYear(),this.getMonth(),this.getDate())-Date.UTC(this.getFullYear(),0,0))/24/60/60/1e3/7)},parse:function(e,t){e.month=0,e.day=7*Number(t)},regex:/^(\d{1,2})/},Ww:"$w",W:"$ww",WW:"$ww",e:{serializeUTC:Date.prototype.getUTCDay,serialize:Date.prototype.getDay,regex:/^([0-6])/},E:{serialize:function(){return(6+this.getDay())%7+1},regex:/^([1-7])/},H:{serializeUTC:Date.prototype.getUTCHours,serialize:Date.prototype.getHours,parse:function(e,t){e.hour=Number(t)},regex:/^(2[0-3]|[01]?[0-9])/},HH:"$H",h:{serializeUTC:function(){return this.getUTCHours()%12},serialize:function(){return this.getHours()%12},parse:function(e,t){e.hour=Number(t)},regex:/^(1[0-2]|0?[0-9])/},hh:"$h",A:{serializeUTC:function(){return this.getUTCHours()<12?"AM":"PM"},serialize:function(){return this.getHours()<12?"AM":"PM"},parse:function(e,t){e.isPM="P"===t},regex:/^([AP])M/},a:{serializeUTC:function(){return this.getUTCHours()<12?"am":"pm"},serialize:function(){return this.getHours()<12?"am":"pm"},parse:function(e,t){e.isPM="p"===t},regex:/^([ap])m/},m:{serializeUTC:Date.prototype.getUTCMinutes,serialize:Date.prototype.getMinutes,parse:function(e,t){e.minute=Number(t)},regex:/^([0-5]?[0-9])/},mm:"$m",s:{serializeUTC:Date.prototype.getUTCSeconds,serialize:Date.prototype.getSeconds,parse:function(e,t){e.second=Number(t)},regex:/^([0-5]?[0-9])/},ss:"$s",SSS:{serializeUTC:Date.prototype.getUTCMilliseconds,serialize:Date.prototype.getMilliseconds,parse:function(e,t){(t=String(t)).length<3&&(t+="0".repeat(3-t.length)),e.millisecond=Number(t)},regex:/^(\d{1,3})/,trailingZero:!0},SS:{serializeUTC:function(){return Math.floor(this.getUTCMilliseconds()/10+.5)},serialize:function(){return Math.floor(this.getMilliseconds()/10+.5)},parse:function(e,t){(t=String(t)).length<2&&(t+="0".repeat(2-t.length)),e.millisecond=10*Number(t)},regex:/^(\d{1,2})/,trailingZero:!0},S:{serializeUTC:function(){return Math.floor(this.getUTCMilliseconds()/100+.5)},serialize:function(){return Math.floor(this.getMilliseconds()/100+.5)},parse:function(e,t){e.millisecond=100*Number(t)},regex:/^(\d)/},Z:{serializeUTC:function(){return"+0000"},serialize:function(){var e=String(Math.floor(-this.getTimezoneOffset()/60)),t=String(Math.floor(-this.getTimezoneOffset()%60));return e.length<2&&(e="0"+e),t.length<2&&(t="0"+t),(this.getTimezoneOffset()>=0?"-":"+")+e+t},parse:function(e,t,i,s,n){void 0!==i&&void 0!==s&&(n=("+"===t?1:-1)*(60*Number(i)+Number(s))),e.timezone=Number(n)},regex:/^([+-])(\d{2})[:]?(\d{2})|([+-]\d{3})/},ZZ:{serializeUTC:function(){return"+00:00"},serialize:function(){var e=String(Math.floor(-this.getTimezoneOffset()/60)),t=String(Math.floor(-this.getTimezoneOffset()%60));return e.length<2&&(e="0"+e),t.length<2&&(t="0"+t),(this.getTimezoneOffset()>=0?"-":"+")+e+":"+t},parse:function(e,t,i,s,n){void 0!==i&&void 0!==s&&(n=("+"===t?1:-1)*(60*Number(i)+Number(s))),e.timezone=Number(n)},regex:/^([+-])(\d{2})[:]?(\d{2})|([+-]\d{3})/},DAYSHORT:{serializeUTC:function(){return shmi.localize(s.dayShort[this.getUTCDay()])},serialize:function(){return shmi.localize(s.dayShort[this.getDay()])},leadingZero:!1},DAY:{serializeUTC:function(){return shmi.localize(s.dayLong[this.getUTCDay()])},serialize:function(){return shmi.localize(s.dayLong[this.getDay()])}},MONTH:{serializeUTC:function(){return shmi.localize(s.monthShort[this.getUTCMonth()])},serialize:function(){return shmi.localize(s.monthShort[this.getMonth()])},leadingZero:!1}},r=Object.freeze({verbose:{components:{w:{label:" ${V_WEEKS}",hideOnZero:!0,separator:" "},d:{label:" ${V_DAYS}",hideOnZero:!0,separator:" "},h:{label:"h",hideOnZero:!0,separator:" "},m:{label:"m",hideOnZero:!0,separator:" "},s:{label:"s",hideOnZero:!0,separator:" "},ms:{label:"ms",hideOnZero:!0,separator:" "}},alwaysShowSuccessive:!0},compact:{components:{w:{label:"w",hideOnZero:!0,separator:" "},d:{label:"d",hideOnZero:!0,separator:" "},h:{label:"h",hideOnZero:!0,separator:" "},m:{label:"m",hideOnZero:!0,separator:" "},s:{label:"s",hideOnZero:!0,separator:" "},ms:{label:"ms",hideOnZero:!0,separator:" "}},alwaysShowSuccessive:!1},minimal:{components:{w:{label:"w",hideOnZero:!0,separator:" "},d:{label:"d",hideOnZero:!0,separator:" "},h:{separator:":",padding:{char:"0",minLength:2}},m:{separator:":",padding:{char:"0",minLength:2}},s:{separator:".",padding:{char:"0",minLength:2}},ms:{hideOnZero:!0,padding:{char:"0",minLength:3}}}}});function getControlSequenceHandler(e){return n[e]||null}function getSequenceFromToken(e){if("$"!==e.charAt(0))return null;var t=e.substr(1);return"{"===t.charAt(0)&&"}"===t.charAt(t.length-1)&&(t=t.substr(1,t.length-1)),null===getControlSequenceHandler(t)?null:t}function parseTimeHelper(e,t,i){var s,n=i.split(/(\$[a-zA-Z0-9]+|\${[a-zA-Z0-9]+})/),r=0;return n.every((function handleFormatToken(i){var n=getSequenceFromToken(i);if(null!==n){if((s=function parseControlSequence(e,t,i){var s,n=getControlSequenceHandler(i);if(null===n)return-1;if("string"==typeof n){if(i===n)throw new Error("Control sequence references to itself");return parseTimeHelper(e,t,n)}if("object"==typeof n){if(!n.parse)return-1;if(!(s=t.match(n.regex)))return-1;var r=s.slice(1);return r.unshift(e),n.parse.apply(null,r),s[0].length}throw new Error("Invalid handler for date format control sequence")}(e,t,n))>0)return t=t.substr(s),r+=s,!0}else if(0===t.indexOf(i))return t=t.substr(i.length),r+=i.length,!0;return!1}))?r:-1}i.formatDateTime=function formatDateTime(e,t){var s;if("string"==typeof t)t={datestring:t};else if(void 0===t)t={};else if("object"!=typeof t)throw new TypeError("Invalid options provided");return shmi.objectHasOwnProperty(t,"datestring")||(t.datestring=shmi.localize("${V_DATEFORMAT}")),shmi.objectHasOwnProperty(t,"utc")||(t.utc=!1),shmi.objectHasOwnProperty(t,"localize")||(t.localize=!0),"number"==typeof e&&(e=new Date(1e3*e)),s=t.datestring.split(/(\$[a-zA-Z0-9]+|\${[a-zA-Z0-9]+})/).map((function handleFormatToken(s){var n=getSequenceFromToken(s);return null!==n?function formatWithControlSequence(e,t,s){var n,r=getControlSequenceHandler(t),o=!1,a=!0;if(null===r)return null;if("string"==typeof r){if(t===r)throw new Error("Control sequence references to itself");n=i.formatDateTime(e,{datestring:r,utc:s,localize:!1})}else{if("object"!=typeof r)throw new Error("Invalid handler for date format control sequence");n=String((s?r.serializeUTC:r.serialize).call(e)),void 0!==r.trailingZero&&(o=r.trailingZero),void 0!==r.leadingZero&&(a=r.leadingZero)}if(o&&a)throw new Error("Both leadingZero and trailingZero set - unsupported!");return t.length>n.length&&(o?n+="0".repeat(t.length-n.length):a&&(n="0".repeat(t.length-n.length)+n)),n}(e,n,t.utc):s})).join(""),t.localize?shmi.localize(s):s},i.parseDateTime=function parseDateTime(e,t){var i=new DateTimeBuffer,s=parseTimeHelper(i,e,t);return e.length!==s?null:i.assemble()},i.getDurationPreset=function getDurationPreset(e){return r[e]||null},i.formatDuration=function formatDuration(e,t){e=Math.floor(e<0?-e:e);if("string"==typeof t){var s=i.getDurationPreset(t);if(null===s)return i.formatDateTime(e,t,!0,!0);t=s}else{var n=i.getDurationPreset("compact");t=t||{},Object.keys(n).forEach((function(e){void 0===t[e]&&(t[e]=n[e])}))}var r="",o=null,a=!1,l=!shmi.objectHasOwnProperty(t,"localize")||t.localize;return[{type:"w",div:6048e5},{type:"d",div:864e5},{type:"h",div:36e5},{type:"m",div:6e4},{type:"s",div:1e3},{type:"ms",div:1}].forEach((function processComponent(i){if(shmi.objectHasOwnProperty(t.components,i.type)){var s=t.components[i.type],n=Math.floor(e/i.div),l=String(n);if(s){e-=n*i.div;var u=n<=0&&s.hideOnZero;(u=u&&(!a||!t.alwaysShowSuccessive))||(s.padding&&l.length<s.padding.minLength&&(l=s.padding.char.repeat(s.padding.minLength-l.length)+l),null!==o&&(r+=o),r+=l,s.label&&(r+=s.label),o=s.separator||null,a=a||i.value>0)}}})),l?shmi.localize(r):r},t("module loaded")}(),function(){"use strict";var e=shmi.requires("visuals.tools.logging").createLogger("visuals.tools.numericValues",!1,!1),t=e.fLog,i=(e.log,shmi.pkg("visuals.tools.numericValues"));function isSet(e){return null!=e}function isAutoEnabled(e){return void 0===e||!!e}function isOptionSet(e,t){return shmi.objectHasOwnProperty(e,t)&&null!==e[t]&&void 0!==e[t]}i.applyInputSettings=function(e,t){var i=parseFloat(e),s=t.vars&&t.vars.valueSettings?t.vars.valueSettings:t.config;return s["decimal-delimiter"]&&(i=parseFloat(String(e).replace(shmi.localize(s["decimal-delimiter"]),"."))),i=isNaN(i)?Number.NaN:function applyStep(e,t){return t.step>0&&(e=Math.round(e/t.step)*t.step),e}(i=function applyMinMax(e,t){return 0===t.min&&0===t.max?e:null!==t.max&&!isNaN(t.max)&&e>t.max?t.max:null!==t.min&&!isNaN(t.min)&&e<t.min?t.min:e}(i,s),s)},i.getTextSettings=function(e,t){return{label:e["auto-label"]?t.label:e.label,unitText:e["auto-unit-text"]?t["unit-text"]:e["unit-text"]}},i.getValueSettings=function(e,t){return{min:isAutoEnabled(e["auto-min"])&&isSet(t.min)?t.min:e.min,max:isAutoEnabled(e["auto-max"])&&isSet(t.max)?t.max:e.max,step:isAutoEnabled(e["auto-step"])&&isSet(t.step)?t.step:e.step,precision:isAutoEnabled(e["auto-precision"])&&isSet(t.precision)?t.precision:e.precision,type:isAutoEnabled(e["auto-type"])&&isSet(t.type)?t.type:e.type,"decimal-delimiter":e["decimal-delimiter"]?shmi.localize(e["decimal-delimiter"]):"."}},i.setProperties=function(e,t){e.vars=e.vars||{},e.vars.valueSettings=i.getValueSettings(e.config,{min:t[0],max:t[1],step:t[2],precision:t[9],type:t[4]})},i.initValueSettings=function(e){e.vars=e.vars||{},e.vars.valueSettings=i.getValueSettings(e.config,{})},i.formatNumber=function(e,t){var i,s=shmi.requires("visuals.tools.unitClasses"),n=parseFloat(e);return isNaN(n)||!t?e:(isOptionSet(t,"unit")?(i=s.getSelectedAdapter(t.unit))&&(n=i.outFunction(n)):isOptionSet(t,"unit-scale")&&(n*=t["unit-scale"]),isOptionSet(t,"precision")&&t.precision>=0&&(n=n.toFixed(t.precision)),isOptionSet(t,"decimal-delimiter")&&(n=String(n).split(".").join(shmi.localize(t["decimal-delimiter"]))),isOptionSet(t,"unit")&&(i?n=isOptionSet(t,"show-unit")?!0===t["show-unit"]?String(n)+" "+i.unitText:String(n):String(n)+" "+i.unitText:"string"==typeof t.unit&&""!==t.unit&&(n=isOptionSet(t,"show-unit")?!0===t["show-unit"]?String(n)+" "+t.unit:String(n):String(n)+" "+t.unit)),n)},i.formatOutput=function(e,t){var s=t.vars&&t.vars.valueSettings?t.vars.valueSettings:t.config;return"object"==typeof s&&null!==s&&function isNumeric(e){switch(parseInt(e)){case shmi.c("TYPE_STRING"):return!1;case shmi.c("TYPE_BOOL"):case shmi.c("TYPE_INT"):case shmi.c("TYPE_FLOAT"):return!0;default:shmi.visuals.session.config.debug&&console.error("unknown type:",e)}return!1}(s.type)?i.formatNumber(e,{"unit-scale":s["unit-scale"],precision:s.precision,"decimal-delimiter":s["decimal-delimiter"]}):e},t("module loaded")}(),function(){var e=shmi.requires("visuals.tools.logging").createLogger("visuals.task",!1,!1),t=e.fLog,i=e.log,s=shmi.pkg("visuals.task");s.TASK_READY=0,s.TASK_RUNNING=1,s.TASK_COMPLETE=2,s.TASK_FAILED=3,s.TASK_STATES=[s.TASK_READY,s.TASK_RUNNING,s.TASK_COMPLETE,s.TASK_FAILED];var n={},r={};shmi.onSessionReady((function(){shmi.visuals.session.config.debug&&(i("debug functions registered"),s.getTasks=function(){return n},s.getTasklists=function(){return r})}));var o=shmi.evalString;function defaultRun(){throw new Error("run function was not set.")}s.createTask=function(e){for(var t=0;void 0!==n[t];)t++;var i=defaultRun,r=s.TASK_READY,a={get state(){return r},set state(e){if(-1===s.TASK_STATES.indexOf(e))throw new Error(o("invalid state set: <%= TASK_STATE %>",{TASK_STATE:e}));r=e,shmi.fire("task-change",{id:a.id,state:r},a)},isRunning:function(){return a.state===s.TASK_RUNNING},get run(){return function(){if(a.state>s.TASK_READY)throw new Error(o("task <%= TASK_ID %> was already started.",{TASK_ID:a.id}));a.state=s.TASK_RUNNING,i()}},set run(e){i=e},complete:function(){a.state=s.TASK_COMPLETE,s.removeTask(a.id)},isComplete:function(){return a.state>s.TASK_RUNNING},fail:function(){a.state=s.TASK_FAILED,s.removeTask(a.id)},isFailed:function(){return a.state>s.TASK_COMPLETE},id:t,name:void 0===e?null:e};return n[t]=a,a},s.removeTask=function(e){if(void 0===n[e])throw new Error(o("task id '<%= TASK_ID %>' is undefined",{TASK_ID:e}));delete n[e]},s.createTaskList=function(e,t,n){for(var a=0;void 0!==r[a];)a++;e=e||[];var l=function getDefaultOnComplete(e){return function(){i(o("Tasklist <%= TASKLIST_ID %> complete",{TASKLIST_ID:e}))}}(a),u={tasks:e,serialize:!0===t,completed:0,get length(){return e.length},id:a,run:function(){if(u.completed===u.length)throw new Error("nothing to do for tasklist");shmi.fire("tasklist-run",{id:u.id,completed:u.completed,length:u.length},u);var t=null;if(t=shmi.listen("task-change",(function(e){!function getCheckListComplete(e,t,n){var r=0;-1!==e.tasks.indexOf(t.source)?(e.tasks.forEach((function(e){e.isComplete()&&r++})),e.completed=r,t.detail.state>s.TASK_RUNNING&&shmi.fire("tasklist-progress",{completed:e.completed,length:e.length,task:t.source,id:e.id},e),r===e.tasks.length&&(i(o("unlisten 'task-change' listener ID: <%= L_ID %>",{L_ID:n})),shmi.unlisten("task-change",n),e.onComplete(e),s.removeTaskList(e.id))):i("TASK NOT IN ACTIVE TASKLIST",t.source)}(u,e,t)})),u.serialize){var r=0,a=shmi.listen("tasklist-progress",(function(t){t.detail.task.state===s.TASK_COMPLETE?++r<e.length?e[r].run():shmi.unlisten("tasklist-progress",a):(shmi.unlisten("tasklist-progress",a),e.forEach((function(e){e.state<s.TASK_COMPLETE&&(e.state=s.TASK_FAILED)})))}),{"detail.id":u.id});e[r].run()}else if(!isNaN(n)&&n>0){(n=parseInt(n))>e.length&&(n=e.length),r=0,a=shmi.listen("tasklist-progress",(function(t){t.detail.task.isComplete()&&((r+=1)<e.length?e[r].run():(a.unlisten(),a=null))}),{"detail.id":u.id}),r=n-1;for(var l=0;l<n;l++)e[l].run()}else e.forEach((function(e){e.run()}))},get onComplete(){return function(){shmi.fire("tasklist-complete",{id:u.id,completed:u.completed,length:u.length},u),l(u)}},set onComplete(e){l=e}};return r[a]=u,u},s.getTaskList=function(e){if(void 0===r[e])throw new Error(o("tasklist id '<%= LIST_ID %>' is undefined",{LIST_ID:e}));return r[e]},s.removeTaskList=function(e){if(void 0===r[e])throw new Error(o("tasklist id '<%= LIST_ID %>' is undefined",{LIST_ID:e}));delete r[e]};s.showProgress=function(e,t){var i=shmi.createControl(document.body,{ui:"dialog-box",title:t||"progress",template:"custom/loading-dialog/content",name:"loading-box","initial-state":"hidden","class-name":"dialog-box designer-dialog-box"});shmi.addClass(i.element,"progress-info");var s=shmi.listen("tasklist-run",(function(e){shmi.unlisten("tasklist-run",s),i.show(),shmi.ctrl(".progress-bar",i).setProperties(0,e.detail.length,1),shmi.ctrl(".current",i).setValue(e.detail.completed),shmi.ctrl(".total",i).setValue(e.detail.length)}),{"detail.id":e.id}),n=shmi.listen("tasklist-progress",(function(e){(shmi.ctrl(".current",i).setValue(e.detail.completed),shmi.ctrl(".total",i).setValue(e.detail.length),shmi.ctrl(".progress-bar",i).setValue(e.detail.completed),null!==e.detail.task.name)&&shmi.ctrl(".task-name",i).setValue(e.detail.task.name)}),{"detail.id":e.id}),r=shmi.listen("tasklist-complete",(function(e){shmi.unlisten("tasklist-complete",r),shmi.unlisten("tasklist-progress",n),i.hide(),shmi.deleteControl(i)}),{"detail.id":e.id});return i},t("module loaded")}(),function(){var e=shmi.pkg("visuals.tools.connect");e.REQUEST_TIMEOUT=864e5,e.request=function request(e,t,i,s,n){return shmi.visuals.session.ConnectSession.request(e,t,i,s,n)},e.callMethod=function callMethod(t,i,s,n=864e5){shmi.checkArg("methodName",t,"string"),shmi.checkArg("param",i,"object"),shmi.checkArg("callback",s,"function"),e.request("io.method",{name:t,params:i},(function(e,t){s(t,void 0!==e?e:null)}),n)}}(),function(){var e=shmi.pkg("visuals.tools.tabulator"),t=shmi.requires("visuals.tools.logging").createLogger("visuals.tools.tabulator",!1,!1),i=t.fLog,s=t.log,n={},r={},o=null,a=document.activeElement||null;function elementTabulator(e){"Tab"===(e.key?e.key:e.code)&&(1===o.length?(e.preventDefault(),o[0].focus()):o.length>1&&(e.shiftKey&&o[0]===document.activeElement?(o[o.length-1].focus(),e.preventDefault()):e.shiftKey||o[o.length-1]!==document.activeElement||(o[0].focus(),e.preventDefault())))}s("Adding focus event listener"),document.addEventListener("focus",(function(e){!function emitFocusChange(e){document.activeElement!==a&&(a=document.activeElement,Object.keys(n).forEach((function(t){n[t]&&n[t](e)})))}(e),function emitFocusLeave(e){Object.keys(r).forEach((function(t){var i=r[t],s=shmi.testParentChild(i.leaveElem,document.activeElement),n=i.leaveElem===document.activeElement;s||n||i.cb(e)}))}(e)}),!0),e.setTabParent=function(e){if(!e)return console.error("[visuals.tools.tabulator] tabParent parameter not provided"),null;if(!(e instanceof HTMLElement))return console.error("[visuals.tools.tabulator] tabParent parameter must be an HMTLElement!"),null;o=(o=Array.from(e.querySelectorAll('[tabindex]:not([tabindex="-1"])'))).filter((function(e){return function isTabElementVisible(e){var t=e.getBoundingClientRect(),i=t.top>=0&&t.left>=0;return i=(i=i&&t.bottom<=(window.innerHeight||document.documentElement.clientHeight))&&t.right<=(window.innerWidth||document.documentElement.clientWidth)}(e)}));var t=shmi.testParentChild(e,document.activeElement);return o[0]&&!t&&(o[0].focus(),s("Initial focus set on: ",o[0])),"-1"!==e.getAttribute("tabindex")&&o.unshift(e),o.length>0?e.addEventListener("keydown",elementTabulator):s("No elements with tabindex found inside the parent",e),{unsetTabParent:function(){e.removeEventListener("keyup",elementTabulator)}}},e.onFocusChange=function(e){for(var t=Math.random().toString(36).substr(2,9);void 0!==n[t];)t=Math.random().toString(36).substr(2,9);return n[t]=e,{unsetFocusChange:function(){delete n[t]}}},e.onFocusLeave=function(e,t){for(var i=Math.random().toString(36).substr(2,9);void 0!==n[i];)i=Math.random().toString(36).substr(2,9);return r[i]={leaveElem:e,cb:t},{unsetFocusLeave:function(){delete r[i]}}},i("module loaded")}(),function(){"use strict";var e=shmi.requires("visuals.tools.logging").createLogger("visuals.tools.controller",!1,!1),t=e.fLog,i=(e.log,e.error),s=e.warn,n=(e.info,shmi.pkg("visuals.tools.controller")),r=new Map(null),o={};function getSlotInstance(e,t){var i=e.slots[t];return i&&i.instance?i.instance:null}function getController(e,t){var i={name:e,parent:t||null};return r.get(JSON.stringify(i))||null}function addListener(e,t,i){var s=getSlotInstance(e,t),r=null;s&&"function"==typeof e.onEvent&&(r=s.listen(i,(function(s){e.onEvent(n.getState(e.name,e.parent),t,i,s)})),e.slots[t].tokens.push(r))}function removeListeners(e,t){var i=e.slots[t];i.tokens.forEach((function(e){e.unlisten()})),i.tokens=[]}function updateState(e,t,s){var r=getController(e,t),o=shmi.requires("visuals.tools.iterate").iterateObject,a=!0;r?(o(r.slots,(function(e,t){null!==e.instance||e.optional||(a=!1)})),a!==r.active?(r.active=a,a?(r.onEnable(n.getState(r.name,r.parent)),o(r.slots,(function(e,t){Array.isArray(e.events)&&e.events.forEach((function(e){addListener(r,t,e)}))}))):(o(r.slots,(function(e,t){removeListeners(r,t)})),r.onDisable(n.getState(r.name,r.parent)))):a&&"function"==typeof r.onChange&&(s&&Array.isArray(r.slots[s.slot].events)&&(s.active?r.slots[s.slot].events.forEach((function(e){addListener(r,s.slot,e)})):removeListeners(r,s.slot)),r.onChange(n.getState(r.name,r.parent),s))):i("Unknown controller:",e)}function getParentName(e,t){var i=o[e],s=null,n=null;if(Array.isArray(i))for(n=t;n;)-1!==i.indexOf(n.getName())?(s=n.getName(),n=null):n=n.getParent();return s}n.create=function create(e,t,n){var a=shmi.requires("visuals.tools.iterate").iterateObject,l=!1,u=getController(e,n);u?i("Controller '%s' already registered.",e):(u={name:e,slots:{},active:!1,onChange:t.onChange||null,onEnable:t.onEnable,onDisable:t.onDisable,onEvent:t.onEvent||null,tokens:[],parent:n||null},Object.defineProperty(u,"data",{value:t.data||{},writable:!1}),a(t.slots,(function(e,t){u.slots[t]={name:t,ui:e.ui,optional:!0===e.optional,instance:null,tokens:[],events:Array.isArray(e.events)?e.events:null},!0===e.optional&&(l=!0)})),function setController(e,t,i){var s={name:t,parent:i||null};r.set(JSON.stringify(s),e),o[t]||(o[t]=[]),i&&-1===o[t].indexOf(i)&&o[t].push(i)}(u,u.name,u.parent),l&&"function"!=typeof t.onChange&&s("Optional slots exist for controller '%s', but no `onChange` callback function was provided. There will be no notifications on status changes.",e))},n.getState=function getState(e,t){var i=getController(e,t),s=shmi.requires("visuals.tools.iterate").iterateObject,n=null;return i?(n={name:i.name,slots:{},getInstance:function(e){return getSlotInstance(i,e)},getParent:function(){var e=null;return i.parent&&(e=shmi.ctrl(i.parent)),e}},Object.defineProperty(n,"active",{get:function(){return i.active},set:function(){throw new TypeError("Active state cannot be set manually.")}}),Object.defineProperty(n,"data",{value:i.data,writable:!1}),s(i.slots,(function(e,t){n.slots[t]=function getSlot(e,t){var i,s=e.slots[t];return s?(i={name:t,ui:s.ui,optional:s.optional||!1},Object.defineProperty(i,"instance",{get:function(){return getSlotInstance(e,t)},set:function(){throw new TypeError("Instance reference cannot be changed manually.")}}),i):null}(i,t)})),n):null},n.remove=function remove(e,t){var s=getController(e,t),a=-1;s?(s.active&&(s.tokens.forEach((function(e){e.unlisten()})),s.tokens=[],s.onDisable(n.getState(s.name,s.parent))),r.delete(JSON.stringify({name:e,parent:t||null})),t&&o[e]&&(-1!==(a=o[e].indexOf(t))&&o[e].splice(a,1),null===o[e].length&&delete o[e])):i("Unknown controller:",e)},n.removeAll=function removeAll(e){var t=shmi.requires("visuals.tools.iterate").iterateObject,i=[];t(o,(function(t,s){-1!==t.indexOf(e)&&i.push({name:s,parent:e})})),i.forEach((function(e){n.remove(e.name,e.parent)}))},n.getControllerParent=function getControllerParent(e,t){return getParentName(e,t)},n.registerSlot=function registerSlot(e,t,s){var n=getController(e,getParentName(e,s)),r=null,o=null,a=null;null!==n?(o=n.slots[t])?o.ui===s.uiType?null===o.instance?(o.instance=s,r=s.listen("disable",(function onDisable(e){var i=-1;r&&(r.unlisten(),-1!==(i=n.tokens.indexOf(r))&&n.tokens.splice(i,1),r=null,o.instance=null,o.optional&&(a={slot:t,active:!1}),updateState(n.name,n.parent,a))})),n.tokens.push(r),o.optional&&(a={slot:t,active:!0}),updateState(n.name,n.parent,a)):i("Slot already occupied:",t+"@"+e):i("Mismatching slot ui-type:",s.uiType,", required:",o.ui,t+"@"+e):i("Unknown controller / slot combination:",t+"@"+e):i("Unknown controller:",e)},t("module loaded")}(),function(){var e=shmi.requires("visuals.tools.logging").createLogger("visuals.tools.objectHelpers",!0,!1),t=e.fLog,i=(e.log,shmi.pkg("visuals.tools.objectHelpers"));i.getByPath=function getByPath(e,t,i){var s,n,r=t;for("string"==typeof e&&(e=(e=(e=e.replace(/\[/g,".")).replace(/\]/g,"")).split(".")),s=0;s<e.length;s++){if(n=e[s],!(null!==r&&"object"==typeof r&&n in r))return i;r=r[n]}return r},i.setByPath=function setByPath(e,t,i){if("string"==typeof e&&(e=(e=(e=e.replace(/\[/g,"[.")).replace(/\]/g,"")).split(".")),e.length>1){var s=e.shift(),n={};-1!==s.indexOf("[")&&(s=s.replace("[",""),n=[]),"object"==typeof t[s]&&null!==t[s]||(t[s]=n),setByPath(e,t[s],i)}else t[e[0]]=i},t("module loaded")}(),function(){const e=shmi.pkg("visuals.tools.conditions"),t={PRIMITIVE_PRIMITIVE:{eq:(e,t)=>e===t,gt:(e,t)=>e>t,lt:(e,t)=>e<t,geq:(e,t)=>e>=t,leq:(e,t)=>e<=t,neq:(e,t)=>e!==t,and:(e,t)=>0!=(e&t),or:(e,t)=>0!=(e|t),xor:(e,t)=>0!=(e^t),nand:(e,t)=>0==(e&t),nor:(e,t)=>0==(e|t)},PRIMITIVE_ARRAY:{in:(e,t)=>t.includes(e),nin:(e,t)=>t.includes(e)},ARRAY_PRIMITIVE:{anyof:(e,t)=>e.includes(t),noneof:(e,t)=>!e.includes(t)},ARRAY_ARRAY:{anyin:(e,t)=>e.some(e=>t.includes(e)),allin:(e,t)=>e.every(e=>t.includes(e)),nonein:(e,t)=>e.every(e=>!t.includes(e)),somenotin:(e,t)=>e.some(e=>!t.includes(e))}};function getOperandValue(e,t){return"item"===t.type?e.getItemValue(t.value):"value"===t.type?t.value:"environment"===t.type?e.getEnvironmentVariableValue(t.value):null}function resolveCondition(e,i){let s=null;return s=i.elements.map(i=>"comparison"===i.type?function resolveComparison(e,i){const s=getOperandValue(e,i.operand1),n=getOperandValue(e,i.operand2),r=i.operator,o=(()=>Array.isArray(s)&&Array.isArray(n)?t.ARRAY_ARRAY[r]:Array.isArray(n)?t.PRIMITIVE_ARRAY[r]:Array.isArray(s)?t.ARRAY_PRIMITIVE[r]:t.PRIMITIVE_PRIMITIVE[r])();return!!o&&o(s,n)}(e,i):"condition"===i.type&&resolveCondition(e,i)),"AND"===i.mode?s.every(e=>!0===e):s.some(e=>!0===e)}function checkItemsReady(e){let t=shmi.requires("visuals.tools.iterate").iterateObject,i=!0;t(e._items,(e,t)=>{null===e.value&&(i=!1)}),t(e._env,(e,t)=>{null===e.value&&(i=!1)}),e._ready=i}function checkConditionState(e){if(!e._ready)return;const t=resolveCondition(e,e._condition);t!==e._active&&(e._active=t,e._observerFunc(t))}function collectOperands(e,t,i=[]){return"comparison"===e.type?(e.operand1.type===t&&i.push({name:e.operand1.value,value:null,token:null}),e.operand2.type===t&&i.push({name:e.operand2.value,value:null,token:null})):"condition"===e.type&&e.elements.forEach(e=>{collectOperands(e,t,i)}),i}function initItems(e,t){let i=collectOperands(e._condition,"item"),s=[];i=i.filter(e=>!s.includes(e.name)&&(s.push(e.name),!0)),e._items=function getItemMap(e){const t={};return e.forEach(e=>{t[e.name]=e}),t}(i),function subscribeItems(e,t,i){const s=shmi.requires("visuals.session.ItemManager");t.forEach(t=>{i.push(s.subscribeItem(t.name,{setValue:i=>{t.value=i,e.ready||checkItemsReady(e),checkConditionState(e)}}))})}(e,i,t)}function initEnvironmentVariables(e,t){let i=collectOperands(e._condition,"environment");i=i.filter((e,t)=>i.findIndex(({name:t})=>t===e.name)===t),e._env=function getEnvironmentVariableMap(e){const t={};return e.forEach(e=>{t[e.name]=e}),t}(i),function subscribeEnvironmentVariables(e,t,i){const s=shmi.requires("visuals.session.EnvironmentManager");t.forEach(t=>{i.push(s.subscribe(t.name,i=>{t.value=i,e.ready||checkItemsReady(e),checkConditionState(e)}))})}(e,i,t)}e.ConditionObserver=class ConditionObserver{constructor(e,t){shmi.checkArg("conditions",e,"object"),shmi.checkArg("observerFunc",t,"function"),this._condition=shmi.cloneObject(e),this._tokens=[],this._items={},this._env={},this._active=null,this._ready=!1,this._observerFunc=t,this.init()}init(){initItems(this,this._tokens),initEnvironmentVariables(this,this._tokens),checkItemsReady(this),checkConditionState(this)}unlisten(){this._tokens.forEach(e=>e.unlisten()),this._tokens=[],this._items={},this._env={},this._ready=!1,this._active=null}getItemValue(e){const t=this._items[e];return t?t.value:null}getEnvironmentVariableValue(e){const t=this._env[e];return t?t.value:null}get ready(){return this._ready}get active(){return this._active}}}(),function(){const e=shmi.requires("visuals.tools.logging").createLogger("visuals.tools.nodes",!1,!1),t=e.fLog,i=(e.log,shmi.pkg("visuals.tools.nodes"));i.HANDLE_PREFIX="node-handle:",i.getNodeElement=function getNodeElement(e){if("string"==typeof e){const t=e.split("@").map(e=>`[_nodeid=${e}]`);return t.reverse(),t.length?document.querySelector(t.join(" ")):null}return null},i.getNodeHandle=function getNodeHandle(e){let t=null,i=[],s=null;if(e instanceof HTMLElement?s=e:e&&e.uiType&&(s=e.element),s&&(t=s.getAttribute("_nodeid")),t){for(i.push(t),s=s.parentNode;s&&s!==document.body;)"group"===s.getAttribute("data-ui")&&i.push(s.getAttribute("_nodeid")),s=s.parentNode;return i.join("@")}return null},t("module-loaded")}(),function(){const e=shmi.pkg("visuals.tools.recipes");function saveExport(e){const t=document.createElement("a");t.href=`data:text/json;charset=utf-8,${encodeURIComponent(JSON.stringify(e,null,4))}`,t.download=`recipe-export_${function getTimestamp(){return new Date(Date.now()).toISOString().split(".")[0].replace(/:/g,"-").split("T").join("_")}()}.recipe`,t.click()}function updateRecipe(e,t){return new Promise((i,s)=>{const n=Object.keys(t.values);e.set(null,t.metadata,!1,r=>{if(r)s(r);else{const r={};n.forEach(e=>{r[e]=t.values[e].value}),e.write(r,e=>{e?s(e):i()})}})})}function createRecipe(e,t){return new Promise((i,s)=>{e.createRecipe(t.name,t.metadata,(function(e,n){if(n)s(n);else{const n={};Object.keys(t.values).forEach(e=>{n[e]=t.values[e].value}),e.capture(null,t=>{t?s(t):e.write(n,e=>{e?s(e):i()})})}}))})}function startRecipeImport(t,i,s){const n=document.createElement("INPUT"),{getDialog:r}=e.dialog;n.type="file",n.accept=".recipe",n.onchange=()=>{n.files.length&&n.files[0].text().then(async n=>{try{const o=JSON.parse(n);if(!function recipesValid(e){if(Array.isArray(e)){return e.length&&e.every(e=>e&&"object"==typeof e&&e.metadata&&"object"==typeof e.metadata&&"string"==typeof e.name&&e.values&&"object"==typeof e.values)}return!1}(o))return void shmi.notify("${ui-action.recipes.import-export.errorInvalidRecipes}","${V_NOTIFICATION}");if(function checkAndFixMeta(e,t){let i=!1;return t.forEach(t=>{Object.entries(e.metadata).forEach(([e,s])=>{(function typeMatches(e,t){const i=typeof t;switch(e){case"bool":if("boolean"!==i)return!1;break;case"int":if("number"!==i||t%1!=0)return!1;break;case"double":if("number"!==i)return!1;break;case"string":if("string"!==i)return!1;break;default:return!1}return!0})(s.value_type,t.metadata[e])||(t.metadata[e]=s.default_value,i=!0)}),Object.keys(t.metadata).forEach(s=>{void 0===e.metadata[s]&&(delete t.metadata[s],i=!0)})}),i}(i,o)){if("no"===await r("${ui-action.recipes.import-export.messageMetaChanged}","${V_CONFIRM_TITLE}",[{name:"yes",label:"${ui-action.recipes.import-export.dialogOptionYes}"},{name:"no",label:"${ui-action.recipes.import-export.dialogOptionNo}"}]))return}const a=function checkAndFixItems(e,t){const i=[],s=[],n=[];return t.length&&(e.items.forEach(e=>{void 0!==t[0].values[e]?n.push(e):i.push(e)}),Object.keys(t[0].values).forEach(t=>{e.items.includes(t)||s.push(t)}),s.length&&t.forEach(e=>{s.forEach(t=>{delete e.values[t]})})),{missing:i,additional:s,common:n}}(i,o);if(0===a.common.length)return void shmi.notify("${ui-action.recpies.import-export.messageNoCommonItems}");if(a.missing.length||a.additional.length){let e="${ui-action.recipes.import-export.messageItemsChanged}",t="";if(a.missing.length&&(t+=shmi.evalString(shmi.localize("${ui-action.recipes.import-export.messageItemsChangedMissing}"),{num_missing:a.missing.length,list_missing:a.missing.join(", ")})),a.additional.length&&(t+=shmi.evalString(shmi.localize("${ui-action.recipes.import-export.messageItemsChangedAdditional}"),{num_additional:a.additional.length,list_additional:a.additional.join(", ")})),"no"===await r(shmi.evalString(shmi.localize(e),{message_detail:t}),"${V_CONFIRM_TITLE}",[{name:"yes",label:"${ui-action.recipes.import-export.dialogOptionYes}"},{name:"no",label:"${ui-action.recipes.import-export.dialogOptionNo}"}]))return}(async function importRecipeData(t,i,s){const n=[],{getDialog:r}=e.dialog;let o=0,a=0,l=!1;for(const e of s){const s=i.find(({name:t})=>t===e.name);if(s){let t=null;l||(t=await r(shmi.evalString(shmi.localize("${ui-action.recipes.import-export.dialogMessageReplace}"),{recipe_name:e.name}),"${V_CONFIRM_TITLE}",[{name:"yes",label:"${ui-action.recipes.import-export.dialogOptionYes}"},{name:"no",label:"${ui-action.recipes.import-export.dialogOptionNo}"},{name:"all",label:"${ui-action.recipes.import-export.dialogOptionReplaceAll}"}]),"all"===t&&(l=!0)),(l||"yes"===t)&&(a+=1,n.push(updateRecipe(s,e)))}else o+=1,n.push(createRecipe(t,e))}return Promise.all(n).then(()=>({created:o,updated:a}))})(i,s,o).then(e=>{shmi.notify("${ui-action.recipes.import-export.importComplete}","${V_NOTIFICATION}",e),function updateRecipeDataGrids(e){const t=shmi.requires("visuals.session.DataGridManager");Object.keys(t.grids).forEach(i=>{const s=t.getGrid(i);s instanceof shmi.visuals.core.DataGridRecipe&&s.recipeTemplateId===e&&s.refresh()})}(t)}).catch(e=>{shmi.notify("${ui-action.recipes.import-export.errorImport}","${V_ERROR}",{message:e.message})})}catch(e){shmi.notify("${ui-action.recipes.import-export.errorImport}","${V_ERROR}",{message:e.message}),console.error("Error importing recipe data:",e.message)}})},n.click()}e.exportRecipes=(e,t=null)=>{const i=null===t;null!==e&&shmi.visuals.session.RecipeManager.listRecipes(e,{include_values:!0},(e,s)=>{if(s)return console.error("Error retrieving recipe list: ",s),void shmi.notify("${ui-action.recipes.import-export.errorRecipeList}","${V_ERROR}",{message:s.message});if(0!==e.recipes.length)if(i)saveExport(e.recipes);else{const i=e.recipes.find(({id:e})=>e===t);i?saveExport([i]):shmi.notify("${ui-action.recipes.import-export.recipeNotFound}","${V_ERROR}")}else shmi.notify("${ui-action.recipes.import-export.noRecipesExist}","${V_NOTIFICATION}")})},e.importRecipes=async e=>{if(null!==e){let t=null,i=null;try{t=await function getRecipeTemplate(e){return new Promise((t,i)=>{shmi.requires("visuals.session.RecipeManager").getTemplate(e,(function(e,s){s?i(s):t(e)}))})}(e)}catch(e){return console.error("Error retrieving recipe template: "+e.message),void shmi.notify("${ui-action.recipes.import-export.errorTemplateGet}","${V_ERROR}",{message:e.message})}try{i=await function listRecipes(e){const t=shmi.requires("visuals.session.RecipeManager");return new Promise((i,s)=>{t.listRecipes(e,{include_values:!0},(e,t)=>{t?s(t):i(e)})})}(e)}catch(e){return console.error("Error retrieving recipe list: "+e.message),void shmi.notify("${ui-action.recipes.import-export.errorRecipeList}","${V_ERROR}",{message:e.message})}startRecipeImport(e,t,i.recipes)}}}(),function(){const e=shmi.pkg("visuals.tools.recipes.dialog"),t="recipe-import-export-dialog",i={ui:"iq-button",config:{"class-name":"iq-button iq-variant-01",template:"default/iq-button.iq-variant-01",action:null,"show-text":!0,"disable-item-lock":!1,monoflop:!1,"monoflop-value":1,"monoflop-interval":100,name:"iq-button_1",ui:"iq-button",label:"Button 2",item:null,"auto-label":!0,"icon-src":null,"icon-title":null,"icon-class":null,"label-from-item":!1,"write-bool":!1,"action-release":null,"action-while-pressed":null,"interval-while-pressed":null,"action-press":null,"disable-alarms":!1,"show-icon":!1,"on-value":1,"off-value":0,tooltip:null},children:null};function getControllerConfig(e){return[{name:t,slot:e}]}function getDialogController(e,i){const s={};return e.forEach(e=>{"string"==typeof e.name&&(s[`optionButton${e.name}`]={ui:"iq-button",events:["click"],optional:!0})}),{name:t,slots:Object.assign({dialog:{ui:"dialog-box",events:["close"]},buttonContainer:{ui:"container",optional:!0}},s),onChange:function(e,t){},onEnable:function(e){},onDisable:function(e){},onEvent:function(e,t,s,n){switch(t){case"dialog":e.data.resolved||(e.data.resolved=!0,i(null)),shmi.deleteControl(e.getInstance("dialog"));break;default:e.data.resolved||(e.data.resolved=!0,i(t.replace("optionButton","")),e.getInstance("dialog").hide())}},data:{resolved:!1}}}function getDialogLayout(e,t,s,n,r,o=!1){const a=function getButtonConfigs(e){const t=[];let s=!1;return e.forEach(e=>{if("string"==typeof e.name&&e.name){const s=shmi.cloneObject(i);s.config._controllers_=getControllerConfig(`optionButton${e.name}`),"string"==typeof e.label&&(s.config.label=e.label),"string"==typeof e.icon&&(s.config["icon-src"]=e.icon,s.config["show-icon"]=!0),t.push(s)}else s=!0}),s?null:t}(s);return null===a?(r(new Error("Invalid button configuration.")),null):{ui:"dialog-box",config:{name:"messageDialog","class-name":"dialog-box recipe-message-dialog"+(o?" allow-close":""),template:"default/dialog-box","initial-state":"hidden","top-level":!0,title:t,"content-template":null,"tab-limit":!0,_controllers_:getControllerConfig("dialog")},controller:getDialogController(s,n),children:[{ui:"container",config:{ui:"container","class-name":"iq-container",type:"iqflex","flex-orientation":"column","flex-none":!0,"flex-wrap":!1,"flex-primary-align":"start","flex-secondary-align":"stretch","flex-line-align":"start",name:"content",template:null},children:[{ui:"container",config:{"class-name":"iq-container message-container",type:"iqflex","flex-orientation":"column","flex-none":!0,"flex-wrap":!1,"flex-primary-align":"start","flex-secondary-align":"stretch","flex-line-align":"start",name:"messageContainer",template:null},children:[{ui:"iq-text",config:{"class-name":"iq-text iq-variant-01 message-text",template:"default/iq-text.iq-variant-01",name:"messageText",ui:"iq-text",text:e,items:[]},children:null}]},{ui:"container",config:{"class-name":"iq-container button-container",type:"iqflex","flex-orientation":"row","flex-none":!0,"flex-wrap":!0,"flex-primary-align":"end","flex-secondary-align":"stretch","flex-line-align":"start",name:"buttonContainer",template:null,_controllers_:getControllerConfig("buttonContainer")},children:a}]}]}}e.getDialog=(e,t,i,s=!1)=>new Promise((n,r)=>{const o=document.querySelector("[data-ui=container]"),a=o?shmi.getControlByElement(o):null;if(a){const o=getDialogLayout(e,t,i,n,r,s);o&&a.addControl(o,(e,t)=>{e?r(e):t[0].show()})}else r(new Error("Base container element not found."))})}(),function(){const e="visuals.ui-actions.change-password",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),i=t.fLog;t.log,shmi.pkg(e);let s=[],n=null;function initControls(e){var t=shmi.visuals.session.UserManager;e.username.setValue(t.currentUser.name),s.push(e.cancel.listen("click",(function(){n.hide(),deleteDialog()}))),s.push(e.apply.listen("click",(function(){!function resetControls(e){shmi.removeClass(e.curpw.element,"error")}(e),function checkValid(e){var t,i,s=shmi.requires("visuals.session.UserManager");e.newpw.getValue()===e.repeatpw.getValue()?String(e.newpw.getValue()).length<shmi.c("MIN_PASSWORD_LENGTH")?shmi.notify("${V_PASSWORD_TOO_SHORT}"):(e.apply.lock(),t=e.curpw.getValue(),i=e.newpw.getValue(),s.changePassword(t,i,(function(t,i){0===i?(n.hide(),deleteDialog()):(e.apply.unlock(),shmi.addClass(e.curpw.element,"error"),shmi.notify("${V_INVALID_PASSWORD}"))}))):shmi.notify("${V_PASSWORD_REPEAT_NOT_EQUAL}")}(e)})))}function deleteDialog(){shmi.deleteControl(n),s.forEach((function(e){e.unlisten()})),s=[],n=null}shmi.pkg("visuals.session.sysActions")["change-password"]=function createDialog(){if(!n){var e=shmi.requires("visuals.session.SysControlConfig"),t=shmi.cloneObject(e.passwordExpiredDialog);t.title=shmi.localize("${V_PASSWORD_CHANGE_TITLE}"),n=shmi.createControl("dialog-box",document.body,t,"DIV");var i=null;n.isActive()?onDialogEnable():i=n.listen("enable",onDialogEnable),n.enable()}function onDialogEnable(){i&&(i.unlisten(),i=null),n.show();var e=[".current-user",".current-pwd",".new-pwd",".repeat-pwd",".apply-btn",".cancel-btn"];e.forEach((function(t,i){e[i]=n.getName()+" "+t})),shmi.onEnable(e,(function(t){initControls({username:t[e[0]],curpw:t[e[1]],newpw:t[e[2]],repeatpw:t[e[3]],apply:t[e[4]],cancel:t[e[5]]})}))}},i("module loaded")}(),function(){const e=shmi.pkg("visuals.session.sysActions"),t="composite-placeholders";e[t]=function(e){if("string"!=typeof e[0]||!e[1]||"object"!=typeof e[1])return void console.error("Invalid parameters, expected [{string}, {object}]");const i=shmi.ctrl(e[0]),s=e[1];if(i){const e=shmi.requires("visuals.tools.iterate").iterateObject,n=i.getConfig();if(n.replacers||(n.replacers={}),n.groupId){const e=function getGroupMeta(e){return shmi.visuals.session.groupConfig[e]||null}(n.groupId);e&&Array.isArray(e.replacers)&&e.replacers.forEach(e=>{void 0===n.replacers[e.id]&&(n.replacers[e.id]=e.default)})}e(s,(e,i)=>{!function setPlaceholder(e,i,s){if(s&&"object"==typeof s)switch(s.type){case"set":e[i]=s.value;break;case"inc":if(void 0===e[i])e[i]=s.limit;else if("number"==typeof e[i]){if("number"==typeof s.limit&&!(s.value>0&&s.value+e[i]<=s.limit||s.value<0&&s.value+e[i]>=s.limit))return;e[i]+=s.value}else console.warn(`[UiAction '${t}'] Cannot increment placeholder '${i}' of type '${typeof e[i]}' ('number' required).`);break;case"toggle":void 0===e[i]?e[i]=!0:"boolean"==typeof e[i]?e[i]=!e[i]:console.warn(`[UiAction '${t}'] Cannot toggle placeholder '${i}' of type '${typeof e[i]}' ('boolean' required).`);break;default:console.warn(`[UiAction '${t}'] Invalid parameter type for placeholder '${i}':`,s.type)}}(n.replacers,i,e)}),shmi.deleteControl(i,!1),i.element.removeAttribute("data-config-name"),i.element.removeAttribute("data-name"),i.element.innerHTML="",shmi.createControl("group",i.element,n,"DIV","from")}else console.warn(`[UiAction '${t}'] composite instance not found:`,e[0])}}(),function(){var e="visuals.ui-actions.inc-dec-item",t=console.error.bind(console,"["+e+"]"),i=console.log.bind(console,"["+e+"]");shmi.pkg(e);const s={};function stopSubscription(e){shmi.objectHasOwnProperty(s,e.itemAlias)&&delete s[e.itemAlias],shmi.decouple((function(){e.token&&(e.token.unlisten(),e.token=null)}))}function doAtomicAdd(e,i){const n=shmi.requires("visuals.session.ItemManager"),r={itemAlias:e,token:null};if(shmi.objectHasOwnProperty(s,e))return void(s[e]+=i);s[e]=i;let o=!1,a=null,l=!1;r.token=n.subscribeItem(e,{setProperties:function setProperties(i,s,l,u,c){if(o)return;if("number"!=typeof c)return;const h=c===shmi.c("TYPE_INT")||c===shmi.c("TYPE_FLOAT");h&&(a=n.getItem(e)),o=!0,a||(t(h?"Attempted to increment non-existing item:":"Attempted to increment item value of non-numerical type:",e),stopSubscription(r))},setValue:function setValue(e){o&&a&&!l&&(l=!0,function startCompareExchange(e,i,n,r){let o;0===n?stopSubscription(r):null==i&&(i=e.readValue(!0)),o=i+n,e.virtual?(e.writable&&e.writeValue(o,!0),stopSubscription(r)):e.compareExchange(i,o,(function cmpxchgCb(i,a,l){a?startCompareExchange(e,i,s[r.itemAlias],r):l?(t("failed to increment item",l),stopSubscription(r)):(s[r.itemAlias]-=n,0===s[r.itemAlias]?stopSubscription(r):startCompareExchange(e,o,s[r.itemAlias],r))}))}(a,e,i,r))}})}shmi.pkg("visuals.session.sysActions")["increment-item-value"]=function doIncrement(e){Array.isArray(e)?2===e.length?"string"==typeof e[0]?"number"==typeof e[1]?doAtomicAdd(e[0],e[1]):t("The second parameter (offset) must be a number."):t("The first parameter (item) must be a string."):t("This ui-action requires exactly 2 parameters: item, offset."):t("This ui-actions' parameters must be given as an array.")},i("module loaded")}(),function(){var e=shmi.requires("visuals.tools.logging").createLogger("visuals.ui-actions.recipe-add",!0,!1),t=e.fLog;e.log,shmi.pkg("visuals.ui-actions.recipe-add");shmi.pkg("visuals.session.sysActions")["recipe-add"]=function addRecipe(e){var t=shmi.requires("visuals.session.RecipeManager"),i=null,s=null;Array.isArray(e)&&"string"==typeof e[0]?(i=shmi.ctrl(e[0]))?(s=i.getValue())?"number"==typeof s.template_id?t.getTemplate(s.template_id,(function(e,t){t?shmi.notify("${ui-action.recipe-add.error.fetchTemplate}","${V_ERROR}",{ERROR_CODE:t.errc,ERROR_MSG:t.message,ERROR_CAT:t.category}):shmi.requires("recipe-controller.ls.recipe-name").getRecipeName(s.tempate_id,(function(t){null!==t&&e.createRecipe(t,{},(function(e,t){t&&shmi.notify("${ui-action.recipe-add.error.createRecipe}","${V_ERROR}",{ERROR_CODE:t.errc,ERROR_MSG:t.message,ERROR_CAT:t.category})}))}))})):shmi.notify("${ui-action.recipe-add.error.noTemplateConfigured}","${V_ERROR}"):shmi.notify("${ui-action.recipe-apply.error.noRecipeSelected}","${V_ERROR}",{CONTROL_NAME:e[0]}):shmi.notify("${ui-action.recipe-add.error.recipeSelectNotFound}","${V_ERROR}",{CONTROL_NAME:e[0]}):console.error("ui-action 'recipe-add' first parameter must be of type 'string'")},t("module loaded")}(),function(){var e=shmi.requires("visuals.tools.logging").createLogger("visuals.ui-actions.recipe-apply",!0,!1),t=e.fLog;e.log,shmi.pkg("visuals.ui-actions.recipe-apply");function doApply(e){e.apply((function(e,t){t&&shmi.notify("${ui-action.recipe-apply.error.applyRecipe}","${V_ERROR}",{ERROR_CODE:t.errc,ERROR_MSG:t.message,ERRROR_CAT:t.category})}))}shmi.pkg("visuals.session.sysActions")["recipe-apply"]=function applyRecipe(e){var t=shmi.requires("visuals.session.RecipeManager"),i=null,s=null;if(Array.isArray(e)&&"string"==typeof e[0]){const[n,r]=e;(i=shmi.ctrl(n))?(s=i.getValue())&&"number"==typeof s.recipe_id?t.getRecipe(s.recipe_id,(function(e,t){t?shmi.notify("${ui-action.recipe-apply.error.fetchRecipe}","${V_ERROR}",{ERROR_CODE:t.errc,ERROR_MSG:t.message,ERRROR_CAT:t.category}):r?doApply(e):shmi.confirm("${ui-action.recipe-add.confirm.applyRecipe}",(function(t){t&&doApply(e)}))})):shmi.notify("${ui-action.recipe-apply.error.noRecipeSelected}","${V_ERROR}"):shmi.notify("${ui-action.recipe-apply.error.recipeSelectNotFound}","${V_ERROR}",{CONTROL_NAME:n})}else console.error("ui-action 'recipe-apply' first parameter must be of type 'string'")},t("module loaded")}(),function(){var e=shmi.requires("visuals.tools.logging").createLogger("visuals.ui-actions.recipe-capture",!0,!1),t=e.fLog;e.log,shmi.pkg("visuals.ui-actions.recipe-capture");function doCapture(e){e.capture(null,(function(e){e&&shmi.notify("${ui-action.recipe-capture.error.captureRecipe}","${V_ERROR}",{ERROR_CODE:e.errc,ERROR_MSG:e.message,ERROR_CAT:e.category})}))}shmi.pkg("visuals.session.sysActions")["recipe-capture"]=function captureRecipe(e){var t=shmi.requires("visuals.session.RecipeManager"),i=null,s=null;Array.isArray(e)&&"string"==typeof e[0]?(i=shmi.ctrl(e[0]))?(s=i.getValue())?"number"==typeof s.recipe_id&&t.getRecipe(s.recipe_id,(function(e,t){t?shmi.notify("${ui-action.recipe-capture.error.fetchRecipe}","${V_ERROR}",{ERROR_CODE:t.errc,ERROR_MSG:t.message,ERROR_CAT:t.category}):"number"==typeof e.versionId?shmi.confirm("${ui-action.recipe-capture.confirm.captureRecipe}",(function(t){t&&doCapture(e)})):doCapture(e)})):shmi.notify("${ui-action.recipe-apply.error.noRecipeSelected}","${V_ERROR}",{CONTROL_NAME:e[0]}):shmi.notify("${ui-action.recipe-capture.error.recipeSelectNotFound}","${V_ERROR}",{CONTROL_NAME:e[0]}):console.error("ui-action 'recipe-capture' first parameter must be of type 'string'")},t("module loaded")}(),shmi.pkg("visuals.session.sysActions")["recipe-export"]=function exportRecipe(e){const t=e[1],i=e[0],s=shmi.requires("visuals.tools.recipes"),n=shmi.ctrl(i);if(!n)return void shmi.notify("${ui-action.recipes.import-export.widgetNotFound}","${V_ERROR}");const r=n.getTemplate();if("number"==typeof r)if(t)s.exportRecipes(r,null);else{const e=n.getValue()?n.getValue().recipe_id:null;if(null===e)return void shmi.notify("${ui-action.recipes.import-export.noRecipeSelected}","${V_NOTIFICATION}");s.exportRecipes(r,e)}else shmi.notify("${ui-action.recipes.import-export.templateNotConfigured}","${V_ERROR}")},shmi.pkg("visuals.session.sysActions")["recipe-import"]=function importRecipe(e){const t=e[0],i=shmi.requires("visuals.tools.recipes"),s=shmi.ctrl(t);if(!s)return void shmi.notify("${ui-action.recipes.import-export.widgetNotFound}","${V_ERROR}");const n=s.getTemplate();"number"==typeof n?i.importRecipes(n):shmi.notify("${ui-action.recipes.import-export.templateNotConfigured}","${V_ERROR}")},function(){const e="webiq-app-settings",t="unitclass-adapter-index";function updateAdapters(e){const t=shmi.requires("visuals.tools.unitClasses");t.getUnitClasses().forEach(i=>{const s=i.unitClass,n=i.adapters;n[e]&&t.setUnitClassAdapter(s,n[e].name)})}shmi.listen("login-state",()=>{const i=shmi.visuals.session.project||shmi.visuals.session.current_project;if(i){const s=function getAppSettings(t){const i=localStorage.getItem(e);let s={};if(null!==i)try{s=JSON.parse(i)}catch(e){console.error("Error parsing WebIQ app settings from local storage:",e)}return s[t]||{}}(i),n="number"==typeof s[t]?s[t]:null;null!==n&&n>=0&&updateAdapters(n)}},{"detail.loggedIn":!0}),shmi.pkg("visuals.session.sysActions")["unitclass-adapter"]=function unitclassAdapter(i){const s=i[0],n=shmi.visuals.session.project||shmi.visuals.session.current_project;"number"!=typeof s||s<0||s%1!=0?console.error(`Invalid unitclass adapter index '${s}' specified. Must be an integer value >= 0.`):(updateAdapters(s),n&&function updateAppSetting(t,i,s){const n=localStorage.getItem(e);let r={};if(null!==n)try{r=JSON.parse(n)}catch(e){console.error("Error parsing WebIQ app settings from local storage:",e)}const o=r[t]||{};o[i]=s,r[t]=o,localStorage.setItem(e,JSON.stringify(r,null,4))}(n,t,s))}}(),function(){var e="visuals.ui-actions.write-item-bitmask",t=console.error.bind(console,"["+e+"]"),i=console.log.bind(console,"["+e+"]");shmi.pkg(e);function stopSubscription(e){shmi.decouple((function(){e.token&&(e.token.unlisten(),e.token=null)}))}shmi.pkg("visuals.session.sysActions")["write-item-bitmask"]=function doItemBitOp(e){if(Array.isArray(e))if(3===e.length)if("string"==typeof e[0])if("set"===e[1]||"clear"===e[1])if(Number.isInteger(e[2])){var i=shmi.requires("visuals.session.ItemManager"),s=null,n=e[1],r=parseInt(e[2]),o={token:null},a=i.getItemHandler(),l=!1,u=!1,c=!1;a.setProperties=function setProperties(n,r,a,c,h){u||"number"==typeof h&&(-1!==h&&(s=i.getItem(e[0]))&&(l=!0),u=!0,l||(t("Attempted to use bit operation on non-existing item:",e[0]),stopSubscription(o)))},a.setValue=function setValue(e){u&&l&&!c&&(c=!0,function startBitwiseOperation(e,i,s,n,r){var o;switch(null==i&&(i=e.readValue(!0)),s){case"set":o=i|n;break;case"clear":o=i&~n;break;default:return void t("Invalid bitwise operation",s)}o!==i&&(e.virtual?(e.writable&&e.writeValue(o,!0),stopSubscription(r)):e.compareExchange(i,o,(function cmpxchgCb(i,o,a){o?startBitwiseOperation(e,i,s,n,r):(a&&t("failed to apply bitmask",a),stopSubscription(r))})))}(s,null,n,r,o))},o.token=i.subscribeItem(e[0],a)}else t("The second parameter (bitmask) must be an integer.");else t("The second parameter (operation) must be either 'set' or 'clear'.");else t("The first parameter (item) must be a string.");else t("This ui-action requires exactly 3 parameters: item, operation, bitmask.");else t("This ui-actions' parameters must be given as an array.")},i("module loaded")}(),function(){var e,t=[],i=null;function createDialog(){var s,n,r,o=t[0];s=o.detail.message,n=o.detail.title,r=o.detail.param;var a=shmi.requires("visuals.session.SysControlConfig"),l=shmi.cloneObject(a.notificationDialog);l.title=n||l.title,l.title=shmi.evalString(shmi.localize(l.title),r),s=shmi.evalString(shmi.localize(s),r);var u=(i=shmi.createControl("dialog-box",document.body,l,"DIV")).listen("close",(function(e){u.unlisten(),deleteDialog(),shmi.fire("notification-dismissed",{param:r,timestamp:Date.now()},shmi.visuals.session)})),c=null;function onDialogEnable(){c&&(c.unlisten(),c=null);var t=shmi.getElementByName("notification-text",i.element);t&&(t.textContent=s),i.listen("open",(function(){var e=i.element.querySelector("[data-ui=button]");e&&e.focus()})),i.element.addEventListener("keyup",e),i.show()}e=function(e){"Escape"===e.code&&(u.unlisten(),deleteDialog(),shmi.fire("notification-dismissed",{param:r,timestamp:Date.now()},shmi.visuals.session))},i.isActive()?onDialogEnable():c=i.listen("enable",onDialogEnable),i.enable()}function deleteDialog(){i.element.removeEventListener("keyup",e),shmi.deleteControl(i),i=null,t.shift(),shmi.decouple((function(){t.length&&createDialog()}))}function defaultNotificationHandler(e){try{shmi.requires("visuals.controls.Button"),shmi.requires("visuals.controls.DialogBox")}catch(e){return void console.log("error trying to load controls: Button, DialogBox\n"+e)}t.push(e),1===t.length&&createDialog()}var s=shmi.pkg("visuals.handler.default.notification"),n=null;s.register=function(){n&&(console.debug("notification handler was active!"),n.unlisten(),n=null),n=shmi.listen("notification",defaultNotificationHandler)},s.deregister=function(){n?(n.unlisten(),n=null):console.debug("notification handler not active!")}}(),function(){var e=[],t=null,i=null,s=[];function getFuncBtn(e,t){var i=null;if(Array.isArray(e))for(var s=0;s<e.length;s++){if(e[s].element.getAttribute("data-function")===t){i=e[s];break}if(Array.isArray(e[s].controls)&&(i=getFuncBtn(e[s].controls,t)))break}return i}function runCallbackDelayed(e,t){shmi.decouple((function(){try{e(t)}catch(e){console.error("exception running shmi.confirm callback:",e)}}))}function createDialog(){var s,n,r,o=e[0];s=o.detail.message,n=o.detail.title,r=o.detail.param,i=o.detail.callback;var a=shmi.requires("visuals.session.SysControlConfig"),l=shmi.cloneObject(a.confirmDialog);l.title=n||l.title,l.title=shmi.evalString(shmi.localize(l.title),r),s=shmi.evalString(shmi.localize(s),r),t=shmi.createControl("dialog-box",document.body,l,"DIV");var u=null,c=null,h=null;function onDialogEnable(){let e={cbExecuted:!1,keyHandler:null};u&&(u.unlisten(),u=null);var n=shmi.getElementByName("confirm-text",t.element);return n&&(n.textContent=s),(c=getFuncBtn(t.controls,"confirm"))?(h=getFuncBtn(t.controls,"deny"))?(c.listen("click",(function(){e.cbExecuted=!0,runCallbackDelayed(i,!0),t.hide(),deleteDialog(e)})),h.listen("click",(function(){e.cbExecuted=!0,runCallbackDelayed(i,!1),t.hide(),deleteDialog(e)})),t.listen("open",(function(){var e=t.element.querySelector("[data-ui=button]");e&&e.focus()})),t.listen("close",(function(){e.cbExecuted||(e.cbExecuted=!0,runCallbackDelayed(i,!1),deleteDialog(e))})),e.keyHandler=function getOnKeyPress(e){return function onKeypRess(s){"Escape"===s.code&&i&&(e.cbExecuted=!0,runCallbackDelayed(i,!1),t.hide(),deleteDialog(e))}}(e),t.element.addEventListener("keyup",e.keyHandler),void t.show()):(console.error("deny button missing in confirmation-dialog"),i(!1),void deleteDialog(e)):(console.error("confirm button missing in confirmation-dialog"),i(!1),void deleteDialog(e))}t.isActive()?onDialogEnable():u=t.listen("enable",onDialogEnable),t.enable()}function deleteDialog(i){t.element.removeEventListener("keyup",i.keyHandler),shmi.deleteControl(t),t=null,e.shift(),s.forEach((function(e){e.unlisten()})),s=[],shmi.decouple((function(){e.length&&createDialog()}))}function defaultConfirmationHandler(t){try{shmi.requires("visuals.controls.Button"),shmi.requires("visuals.controls.DialogBox")}catch(e){return void console.log("error trying to load controls: Button, DialogBox\n"+e)}e.push(t),1===e.length&&createDialog()}var n=shmi.pkg("visuals.handler.default.cofirmation"),r=null;n.register=function(){r&&(console.debug("confirmation handler was active!"),r.unlisten(),r=null),r=shmi.listen("confirmation",defaultConfirmationHandler)},n.deregister=function(){r?(r.unlisten(),r=null):console.debug("confirmation handler not active!")}}(),function(){var e=[],t=null,i=!1,initialLoginExpired=function(){};function initControls(i){var s=shmi.visuals.session.UserManager;i.username.setValue(s.currentUser.name),e.push(i.cancel.listen("click",(function(){t.hide(),deleteDialog()}))),e.push(i.apply.listen("click",(function(){!function resetControls(e){shmi.removeClass(e.curpw.element,"error")}(i),function checkValid(e){var i,s,n=shmi.requires("visuals.session.UserManager");e.newpw.getValue()===e.repeatpw.getValue()?String(e.newpw.getValue()).length<shmi.c("MIN_PASSWORD_LENGTH")?shmi.notify("${V_PASSWORD_TOO_SHORT}"):(e.apply.lock(),i=e.curpw.getValue(),s=e.newpw.getValue(),n.changePassword(i,s,(function(i,s){0===s?(t.hide(),deleteDialog()):(e.apply.unlock(),shmi.addClass(e.curpw.element,"error"),shmi.notify("${V_INVALID_PASSWORD}"))}))):shmi.notify("${V_PASSWORD_REPEAT_NOT_EQUAL}")}(i)})))}function deleteDialog(){shmi.deleteControl(t),e.forEach((function(e){e.unlisten()})),e=[],t=null}function defaultPasswordExpiredHandler(e){try{shmi.requires("visuals.controls.Button"),shmi.requires("visuals.controls.DialogBox")}catch(e){return void console.log("error trying to load controls: Button, DialogBox\n"+e)}null===t&&function createDialog(){if(i){var e=shmi.requires("visuals.session.SysControlConfig"),s=shmi.cloneObject(e.passwordExpiredDialog);s.title=s.title||"${V_PASSWORD_EXPIRED_TITLE}",s.title=shmi.localize(s.title),t=shmi.createControl("dialog-box",document.body,s,"DIV");var n=null;t.isActive()?onDialogEnable():n=t.listen("enable",onDialogEnable),t.enable()}else initialLoginExpired=function(){createDialog()};function onDialogEnable(){n&&(n.unlisten(),n=null),t.show();var e=[".current-user",".current-pwd",".new-pwd",".repeat-pwd",".apply-btn",".cancel-btn"];e.forEach((function(i,s){e[s]=t.getName()+" "+i})),shmi.onEnable(e,(function(t){initControls({username:t[e[0]],curpw:t[e[1]],newpw:t[e[2]],repeatpw:t[e[3]],apply:t[e[4]],cancel:t[e[5]]})}))}}()}var s=shmi.pkg("visuals.handler.default.passwordExpired"),n=null,r=shmi.listen("parser-ready",(function(){r.unlisten(),i=!0,shmi.decouple(initialLoginExpired)}));s.register=function(){n&&(console.debug("password-expired handler was active!"),n.unlisten(),n=null),n=shmi.listen("password-expired",defaultPasswordExpiredHandler)},s.deregister=function(){n?(n.unlisten(),n=null):console.debug("password-expired handler not active!")}}(),function(){var e=null;function defaultConnectionFailed(t){e=Date.now();var i=shmi.listen("notification-dismissed",(function(e){i.unlisten(),window.location.reload()}),{"detail.param.id":e});shmi.notify("${CONNECTION_RESET}","${V_NOTIFICATION}",{id:e})}var t=shmi.pkg("visuals.handler.default.connectionFailed"),i=null;t.register=function(){i&&(console.debug("connection-failed handler was active!"),i.unlisten(),i=null),i=shmi.listen("connection-failed",defaultConnectionFailed)},t.deregister=function(){i?(i.unlisten(),i=null):console.debug("connection-failed handler not active!")}}(),function(){var e,t,i=[],s=[],n=null;function defaultOptionDialogHandler(e){try{shmi.requires("visuals.controls.Button"),shmi.requires("visuals.controls.DialogBox")}catch(e){return void console.log("error trying to load controls: Button, DialogBox\n"+e)}i.push(e),1===i.length&&createDialog()}function createDialog(){var r=null,o={},a=i[0].detail;if(a.buttons&&Array.isArray(a.buttons)&&"object"==typeof a.buttons[0]){var l=shmi.requires("visuals.session.SysControlConfig"),u=shmi.cloneObject(l.optionDialog);u.title=a.title||u.title,u.title=shmi.evalString(shmi.localize(u.title),a.titleParams),n=shmi.createControl("dialog-box",document.body,u,"DIV"),t=function(t){"Escape"===t.code&&e.callback&&(e.callback(e.name,t),n.hide(),deleteDialog())},n.isActive()?onDialogEnable():r=n.listen("enable",onDialogEnable),n.enable()}else shmi.log("[shmi.optionDialog] Invalid options provided ",3);function onDialogEnable(){r&&(r.unlisten(),r=null),s.length&&(s.forEach((function(e){e&&e.unlisten&&e.unlisten()})),s=[]);var i=n.element.querySelector("[data-name=option-text]");if(i){var l=a.messageParams||{};a.message=shmi.evalString(shmi.localize(a.message),l),i.textContent=a.message}var u=n.element.querySelector("[data-name=dialog-options]"),c=n.element.querySelector("[data-name=dialog-ctrls]");a.buttons.forEach((function(e){const t=e.config.name,i=e.callback;let r=null;switch(e.type){case"warning":case"success":case"option":if("vertical"===a.buttonLayout){if(!u)return void shmi.log('[shmi.optionDialog] HTML Element not found: data-name="dialog-options"',3);r=u}else if("horizontal"===a.buttonLayout){if(!c)return void shmi.log('[shmi.optionDialog] HTML Element not found: data-name="dialog-ctrls"',3);r=c}break;case"cancel":if(!c)return void shmi.log('[shmi.optionDialog] HTML Element not found: data-name="dialog-ctrls"',3);r=c;break;default:return}r&&(e.config["class-name"]=e.config["class-name"]?e.config["class-name"]+" "+e.type:e.type,o[t]=shmi.createControl("button",r,e.config,"DIV","before"),s.push(o[t].listen("click",(function(e){n.hide(),deleteDialog();try{i(t,e)}catch(e){console.error("exception running shmi.optionDialog callback:",e)}}))))})),n.listen("open",(function(){var e=n.element.querySelector("[data-ui=button]");e&&e.focus()})),(e=a.buttons.find((function(e){return"cancel"===e.type})))&&n.element.addEventListener("keyup",t),n.show()}}function deleteDialog(){n.element.removeEventListener("keyup",t),shmi.deleteControl(n),n=null,i.shift(),s.forEach((function(e){e&&e.unlisten&&e.unlisten()})),s=[],shmi.decouple((function(){i.length&&createDialog()}))}var r=shmi.pkg("visuals.handler.default.optionDialog"),o=null;r.register=function(){o&&(console.debug("confirmation handler was active!"),o.unlisten(),o=null),o=shmi.listen("optionDialog",defaultOptionDialogHandler)},r.deregister=function(){o?(o.unlisten(),o=null):console.debug("confirmation handler not active!")}}(),function(){const e=shmi.pkg("visuals.handler.default.logout");let t=null,i=!1;e.register=function(){t||(t=shmi.listen("login-state",e=>{const t=i&&!1===e.detail.loggedIn;i=e.detail.loggedIn,t&&window.location.reload()}))},e.deregister=function(){t&&(t.unlisten(),t=null,i=!1)}}(),function(){const e=shmi.pkg("visuals.handler.default.numpad");let t=null,i=null,s=[];function getOnClose(e){return()=>{s.forEach(e=>{e.unlisten()}),s=[],function deleteNumpad(){shmi.deleteControl(t),t=null}()}}function numpadRequestHandler(e){null===t&&function createNumpad(e){const i={};shmi.requires("visuals.tools.iterate.iterateObject")(e.detail,(function(t,s){i[s]=e.detail[s]})),i.label&&(i.label=shmi.evalString(shmi.localize(i.label),e.detail.param)),t=shmi.createControl("numpad",document.body,i,"DIV",null,!0);const n=getOnClose();s.push(t.listen("close",n)),s.push(t.listen("close",n)),shmi.onActive([t],()=>{t.show()})}(e)}e.register=function(){i&&(console.debug("numpad handler was active!"),i.unlisten(),i=null),i=shmi.listen("numpad-request",numpadRequestHandler)},e.deregister=function(){i?(i.unlisten(),i=null):console.debug("numpad handler not active!")}}(),function(){var e={type:1,queries:[{name:"mobile",threshold:null,layoutWidth:"318px",editorWidth:"320px",icon:"icon mq-mobile",enabled:!0},{name:"wide-mobile",threshold:"478px",layoutWidth:"478px",editorWidth:"480px",icon:"icon mq-wide-mobile",enabled:!0},{name:"tablet-portrait",threshold:"758px",layoutWidth:"758px",editorWidth:"768px",icon:"icon mq-tablet-portrait",enabled:!0},{name:"tablet-landscape",threshold:"1018px",layoutWidth:"1018px",editorWidth:"1024px",icon:"icon mq-tablet-landscape",enabled:!0},{name:"wide",threshold:"1278px",layoutWidth:"1278px",editorWidth:"1280px",icon:"icon mq-wide",enabled:!0},{name:"extra-wide",threshold:"1918px",layoutWidth:"1918px",editorWidth:"1920px",icon:"icon mq-extra-wide",enabled:!0}]},t="(min-width: <%= threshold %>)",i="(max-width: <%= threshold %>)",s=1,n=2,r={},o=null;function testLayout(){for(var r=0,a="",l=0;l<e.queries.length;l++)e.queries[l].enabled&&(e.type===s?a=shmi.evalString(t,e.queries[l]):e.type===n&&(a=shmi.evalString(i,e.queries[l])),window.matchMedia(a).matches&&(r=l));var u=o;if(u!==(o=e.queries[r].name)&&(function setActiveLayoutClass(t){for(var i=0;i<e.queries.length;i++)shmi.removeClass(document.documentElement,e.queries[i].name);shmi.addClass(document.documentElement,e.queries[t].name),shmi.visuals.session.config&&shmi.visuals.session.config.debug&&console.log("set layout cssClass: "+e.queries[t].name+" "+e.queries[t].threshold)}(r),null!==u)){var c=document.createEvent("Event");c.initEvent("visuals-layout-change",!0,!0),window.dispatchEvent(c),shmi.visuals.session.config&&shmi.visuals.session.config.debug&&console.log("LAYOUT CHANGE ["+u+" => "+o+"]"),shmi.fire("layout-change",{oldLayout:u,layout:o},shmi.visuals.session)}}shmi.loadResource(shmi.c("MEDIA_QUERIES_CONFIG_PATH"),(function(t,i,s){var n;i&&console.error("failed to load media-query configuration: "+s);try{n=JSON.parse(t)}catch(e){console.error("failed to parse media-query configuration: "+s,e)}"object"==typeof n&&Array.isArray(n.queries)&&n.queries.length?(e=n,console.log("[visuals.media-queries] using json defined media-queries: ",s)):console.log("[visuals.media-queries] using built-in media-queries: ",e);for(var o=0;o<e.queries.length;o++)r[e.queries[o].name]=e.queries[o];shmi.onSessionReady((function(){testLayout(),window.addEventListener("resize",testLayout,!1)}))})),shmi.getCurrentLayout=function(){return o},shmi.getCurrentMediaQuery=function(){return r[o]},shmi.getActiveMediaQueries=function(){for(var r=[],o=null,a="",l=0;l<e.queries.length;l++)a="",null===(o=e.queries[l]).threshold&&o.enabled?r.push(o.name):o.enabled&&(e.type===s?a=shmi.evalString(t,o):e.type===n&&(a=shmi.evalString(i,o)),a&&window.matchMedia(a).matches&&r.push(o.name));return r},shmi.getMediaQueries=function(){return e}}();