(function () {

    /**
     * replace module name with a custom name for the local-script.
     *
     * All local-script should be attached to the "custom.ls" package.
     * If more than one script is required for an application, a common root package
     * should be created (e.g. "custom.ls.customerName.*").
     */

    var MODULE_NAME = "trigger-on-item-change",
        ENABLE_LOGGING = false,
        RECORD_LOG = false,
        logger = shmi.requires("visuals.tools.logging").createLogger(MODULE_NAME, ENABLE_LOGGING, RECORD_LOG),
        fLog = logger.fLog,
        log = logger.log,
        module = shmi.pkg( MODULE_NAME );

    // MODULE CODE - START

    /* private variables */

    /* private functions */
    function makeEaseOut(timing) {
      return function(timeFraction) {
        return 1 - timing(1 - timeFraction);
      }
    }

    function bounce(timeFraction) {
      for (let a = 0, b = 1; 1; a += b, b /= 2) {
        if (timeFraction >= (7 - 4 * a) / 11) {
          return -Math.pow((11 - 6 * a - 11 * timeFraction) / 4, 2) + Math.pow(b, 2)
        }
      }
    }

    function animate(options) {
        const start = performance.now();
        requestAnimationFrame(function animate(time) {
            let timeFraction = (time - start) / options.duration;
            if (timeFraction > 1) timeFraction = 1;

            const progress = options.timing(timeFraction)
            
            options.draw(progress);

            if (timeFraction < 1) {
                requestAnimationFrame(animate);
            }
        });
    }

    /**
     * Implements local-script run function.
     *
     * This function will be called each time a local-script will be enabled.
     *
     * @param {LocalScript} self instance reference of local-script control
     */
    module.run = function (self) {

        // Place your Code here
        const itemToReactTo = "SInt",
            itemValueToReactTo = 1,
            elementSelectorToAnimate = ".brickToAnimate .iq-image";

        // Subscribe to recipe complete (=stop button) button item
        const im            = shmi.visuals.session.ItemManager;
        const myItemHandler = im.getItemHandler();

        let bounceEaseOut = makeEaseOut(bounce);

        myItemHandler.setValue = function (value) {
            console.log("The value of the item has been set to " + value);

            if (value == itemValueToReactTo) {
                console.log("Item "+itemToReactTo+" has the value "+value+" -> handling...");

                const el = document.querySelector(elementSelectorToAnimate);
                if (el) {
                    console.log("Animating...");
                    animate({
                        duration: 3000,
                        timing: bounceEaseOut,
                        draw: function(progress) {
                            el.style.left = progress * 500 + 'px';
                        }
                    });
                } else {
                    console.log("ERROR: Element to animate not found with CSS query "+elementSelectorToAnimate);
                }
            }
        };

        // Subscribe to the item
        const subscriptionToken = im.subscribeItem(itemToReactTo, myItemHandler);

        /* called when this local-script is disabled */
        self.onDisable = function () {
            self.run = false; /* from original .onDisable function of LocalScript control */
            subscriptionToken.unlisten(); // Always clean up!
        };
    };


    // MODULE CODE - END

    fLog("module loaded");
})();
