/**
 * Visuals - Industrial Visualization Framework for JavaScript
 *
 * Copyright © 2012-2022 Smart HMI GmbH
 *
 * All rights reserved
 *
 * No part of this website or any of its contents may be reproduced, copied, modified or
 * adapted, without the prior written permission of Smart HMI.
 *
 * Commercial use and distribution of the contents of the website is not allowed without
 * express and prior written permission of Smart HMI.
 *
 *
 * Web: http://www.smart-hmi.de
 *
 * @version 2.11.2 416ad2f.26616 20-04-2022 07:31:54
 */

!function(){"use strict";var e="alarm-history",t={"class-name":e,name:null,template:"default/"+e,label:e,dateformat:"${alarmlist_dateformat}"},i=shmi.requires("visuals.tools.logging").createLogger(e,!1,!1),s=(i.fLog,i.log),n={name:"alarms-historic",fields:["id","index","level","come","gone","group","needAck","isAck","alarmAck","ackUser","json"]},a={label:"${alarmlist_history_title}",table:n.name,name:"alarm-table","class-name":"complex-table2 alarms","field-datagrid-col-map":{level:2,description:1,"alarm-start":3,"alarm-end":4,"alarm-group":5,detail:10},"select-mode":"SINGLE","default-field-control-map":{level:{"ui-type":"toggle-display",config:{template:"default/alarm-history/toggle-display-alarm-levels",conditions:["%VALUE%==0","%VALUE%==1","%VALUE%==2"],"class-name":"toggle-display icon-only no-background"}},description:{"ui-type":"text2",config:{"class-name":"text2 multiline",options:[],pattern:"${alarm_title_<%= VALUE %>}"}},"alarm-start":{"ui-type":"text2-date",config:{"class-name":"text2 text2-date multiline",dateformat:"$DD.$MM.$YYYY, $HH:$mm:$ss"}},"alarm-end":{"ui-type":"text2-date",config:{"class-name":"text2 text2-date multiline",dateformat:"$DD.$MM.$YYYY, $HH:$mm:$ss"}},"alarm-group":{"ui-type":"text2",config:{"class-name":"text2",options:[],pattern:"${alarm_group_<%= VALUE %>}"}},detail:{"ui-type":"local-script",config:{module:"visuals.tools.alarms.ls.alarmDetails"}}},"default-field-headers":{level:"${alarmlist_level_header}",description:"${alarmlist_title_header}","alarm-start":"${alarmlist_come_header}","alarm-end":"${alarmlist_gone_header}","alarm-group":"${alarmlist_group_header}",detail:"${alarmlist_detail_header}"},_comment:"expr is passed to expr parameter array of shmi.visuals.core.DataGridManager.setFilter",filters:[{label:"${alarmlist_level_info}",template:"default/alarm-history/level-service","class-name":"toggle-button icon-and-text",field:"level",expr:0},{label:"${alarmlist_level_warning}",template:"default/alarm-history/level-warning","class-name":"toggle-button icon-and-text",field:"level",expr:1},{label:"${alarmlist_level_alarm}",template:"default/alarm-history/level-alarm","class-name":"toggle-button icon-and-text",field:"level",expr:2}],"default-layout":{"class-name":"layout-std",_comment:"default == no additional css layout class","column-org":{col1:{fields:["level"],width:"5%"},col2:{fields:["description"],width:"20%"},col3:{fields:["alarm-start"],width:"20%"},col4:{fields:["alarm-end"],width:"20%"},col5:{fields:["alarm-group"],width:"20%"},col6:{fields:["detail"],width:"15%"}},"line-height":"39px"},"sortable-fields":["level","description","alarm-start","alarm-end","alarm-group"],"delete-selected-rows":!1,"show-nof-rows":!0,"show-buttons-table-min-width-px":400,"text-mode":"SINGLELINE","responsive-layouts":[{"class-name":"layout-compact","table-max-width-px":700,"v-scroll-options":["V_SWIPE"],"select-mode":"SINGLE","column-org":{col1:{fields:["level"],width:"15%"},col2:{fields:["description"],width:"30%"},col3:{fields:["alarm-start","alarm-end"],width:"25%"},col4:{fields:["detail"],width:"25%"}},"line-height":"79px"}],"default-nof-buffered-rows":150,"buffer-size":500};function computeTimestampFromControls(e){return function computeTimestamp(e,t,i,s){var n=new Date(1e3*e);return n.setHours(t,i,s,0),n.getTime()/1e3}(e.date.getValue(),e.time.getHours(),e.time.getMinutes(),e.time.getSeconds())}function setFilter(e){var t=computeTimestampFromControls(e.vars.controls.from),i=computeTimestampFromControls(e.vars.controls.to),s=shmi.requires("visuals.tools.date");shmi.addClass(e.element,"filter-active"),e.vars.activeFilterLabel.textContent=shmi.localize("${alarmlist_timefilter}"),e.vars.activeFilterFrom.textContent=s.formatDateTime(t,{datestring:shmi.localize(e.config.dateformat)}),e.vars.activeFilterTo.textContent=s.formatDateTime(i,{datestring:shmi.localize(e.config.dateformat)}),e.vars.grid.setFilter(3,[t,i])}var l={className:"AlarmHistory",uiType:e,isContainer:!0,config:t,configSchema:null,vars:{grid:null,table:null,startDate:null,endDate:null,todayButton:null,resetButton:null,timeFilterLabel:null,activeFilterLabel:null,activeFilterFrom:null,activeFilterTo:null,anchors:{from:null,to:null,table:null,filterButton:null,filterOverlay:null},controls:{table:null,from:{date:null,time:null},to:{date:null,time:null}},tokens:[],listeners:[]},imports:{im:"visuals.session.ItemManager",qm:function(){return shmi.visuals.session.QueryManager},dgm:"visuals.session.DataGridManager",iter:"visuals.tools.iterate.iterateObject"},prototypeExtensions:{onInit:function(){var t=this,i=t.imports.dgm.getGrid(n.name),l=t.imports.iter,o=!1,r=shmi.requires("visuals.io");i?console.debug(e,"grid exists:",n.name):(i=t.imports.dgm.grids[n.name]=new shmi.visuals.core.DataGridDB(n.name,shmi.c(n.db),n.table,n.fields,n.conditions),s("grid created:",n.name)),t.vars.grid=i,t.vars.resetButton=shmi.getUiElement("reset-button",t.element);var c={onClick:function(){!function clearFilter(e){e.vars.grid.clearFilter(3),shmi.removeClass(e.element,"filter-active")}(t)}};t.vars.timeFilterLabel=shmi.getUiElement("filter-label",t.element),t.vars.timeFilterLabel.textContent=shmi.localize("${alarmlist_set_timefilter}"),t.vars.activeFilterLabel=shmi.getUiElement("time-frame-label",t.element),t.vars.activeFilterFrom=shmi.getUiElement("start-date",t.element),t.vars.activeFilterTo=shmi.getUiElement("end-date",t.element);var u=new r.MouseListener(t.vars.resetButton,c),h=new r.TouchListener(t.vars.resetButton,c);t.vars.listeners.push(u,h);var m=shmi.localize(t.config.dateformat);if(a["default-field-control-map"]["alarm-start"].config.dateformat=m,a["default-field-control-map"]["alarm-end"].config.dateformat=m,function getAnchorElements(e){e.vars.anchors.from=shmi.getUiElement("from-anchor",e.element),e.vars.anchors.to=shmi.getUiElement("to-anchor",e.element),e.vars.anchors.table=shmi.getUiElement("table-anchor",e.element),e.vars.anchors.filterButton=shmi.getUiElement("filter-button",e.element),e.vars.anchors.filterOverlay=shmi.getUiElement("filter-overlay",e.element)}(t),l(t.vars.anchors,(function(e,t){e||(console.error("AlarmHistory","element not found:",t+"-anchor"),o=!0)})),!o){!function createControls(e){var t=e.vars.anchors,i=e.vars.controls;i.table=shmi.createControl("complex-table2",t.table,a,"DIV"),i.from.date=shmi.createControl("select-date",t.from,{label:"start"},"DIV"),i.from.time=shmi.createControl("select-time",t.from,{label:"start",isUTC:!0},"DIV"),i.to.date=shmi.createControl("select-date",t.to,{label:"end"},"DIV"),i.to.time=shmi.createControl("select-time",t.to,{label:"end",isUTC:!0},"DIV"),i.from.time.setValue(0),i.to.time.setValue(0)}(t);var d={onClick:function(){t.locked||(shmi.hasClass(t.element,"filter-open")?(shmi.removeClass(t.element,"filter-open"),setFilter(t)):(shmi.addClass(t.element,"filter-open"),t.vars.firstOpened||(t.vars.controls.to.date.setValue(t.vars.controls.from.date.getValue()+86400),t.vars.controls.to.time.setValue(t.vars.controls.from.time.getValue()),t.vars.firstOpened=!0)))}},f=new r.MouseListener(t.vars.anchors.filterButton,d),v=new r.TouchListener(t.vars.anchors.filterButton,d);t.vars.listeners.push(f,v);var g={onClick:function(){shmi.removeClass(t.element,"filter-open"),setFilter(t)}},p=new r.MouseListener(t.vars.anchors.filterOverlay,g),b=new r.TouchListener(t.vars.anchors.filterOverlay,g);t.vars.listeners.push(p,b)}},onEnable:function(){var t=this.vars.controls.from,i=Math.floor(new Date(1e3*shmi.getServerTime()).getTime()/1e3),n=86400*Math.floor(i/86400);this.controls.forEach((function(e){e.enable()})),t.date.setValue(n-86400),t.time.setValue(i),function attachChangeListeners(t){var i=t.vars.tokens,n=t.vars.controls.from,a=t.vars.controls.to;i.push(n.date.listen("change",(function(t){s(e,"from date:",t.detail.value),s(e,"total from:",new Date(1e3*computeTimestampFromControls(n))),a.date.setValue(n.date.getValue()+86400),a.time.setValue(n.time.getValue())}))),i.push(n.time.listen("change",(function(t){s(e,"from time:",t.detail.value),s(e,"total from:",new Date(1e3*computeTimestampFromControls(n)))}))),i.push(a.date.listen("change",(function(t){s(e,"to date:",t.detail.value)}))),i.push(a.time.listen("change",(function(t){s(e,"to time:",t.detail.value)})))}(this),this.vars.listeners.forEach((function(e){e.enable()}))},onDisable:function(){this.controls.forEach((function(e){e.disable()})),this.vars.tokens.forEach((function(e){e.unlisten()})),this.vars.firstOpened=!1,this.vars.tokens=[],this.vars.listeners.forEach((function(e){e.disable()}))},onLock:function(){this.vars.listeners.forEach((function(e){e.disable()}))},onUnlock:function(){this.vars.listeners.forEach((function(e){e.enable()}))},onSetValue:function(e,t,i){},onSetProperties:function(e,t,i){}}};shmi.requires("visuals.tools.control-generator").generate(l)}(),function(){var e="visuals.tools.alarms.ls.alarmDetails",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),i=t.fLog;t.log;shmi.pkg(e).run=function(e){var t=[],i=null,s=shmi.requires("visuals.session.ItemManager"),n=shmi.requires("visuals.tools.numericValues"),a=shmi.visuals.tools.unitClasses,l=s.getItemHandler(),o=null;e.vars=e.vars||{},i=shmi.createControl("button",e.element.parentNode,{label:"${alarmlist_show_detail}"},"DIV"),l.setValue=function(e){(o=JSON.parse(e))&&Array.isArray(o.items)&&o.items.forEach((function(t,i){if(t.formattedValue=n.formatNumber(e,{unit:t.unit,precision:t.digits}),"number"==typeof t.unit){var s=a.getSelectedAdapter(t.unit);s&&(t.unit=s.unitText,t.value=s.outFunction(t.value))}"number"==typeof t.digits&&t.digits>=0&&(t.value=t.value.toFixed(t.digits))}))},t.push(i.listen("click",(function(){var e=shmi.evalString("${alarm_msg_<%= VALUE %>}",{VALUE:o.index}),t=shmi.localize(e);shmi.notify(shmi.evalString(t,o))}))),e.config.item&&t.push(s.subscribeItem(e.config.item,l)),e.onDisable=function(){e.run=!1,t.forEach((function(e){e.unlisten()})),t=[],shmi.deleteControl(i,!0)}},i("module loaded")}(),function(){"use strict";const e="alarm-info",t={"class-name":e,name:null,template:"default/alarm-info",label:e,noAlarm:null,action:null,userGroups:null,enableCycle:!0,cycleInterval:1e3,showAlarm:!0,showWarn:!0,showInfo:!0,groupFilter:null},i=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1).log,s=["service","preWarn","warn"];function hide(e){e&&shmi.addClass(e,"hidden")}function parseAlarmGroupFilter(e){if("string"!=typeof e)return null;let t=e.split(",");t=t.map(e=>{if(e.includes("-"))return function parseAlarmGroupRange(e){const t=e.split("-");if(2===t.length){const e=parseInt(t[0]),i=parseInt(t[1]);if(!isNaN(e)&&!isNaN(i)&&e>0&&i>1&&i>e)return[e,i]}return null}(e);const t=parseInt(e);return!isNaN(t)&&t>=0?t:null}),t=t.filter(e=>null!==e);const i=[];return t.forEach(e=>{if(Array.isArray(e)){let s=e[0];for(;s<=e[1];)i.includes(s)&&t.includes(s)||i.push(s),s+=1}}),t.push(...i),t.length?t:null}function testAlarmState(e){const t=Object.values(e.imports.am.alarms).map(e=>e.properties);Array.isArray(t)&&(t.length<1?clearAlarmMsg(e):(clearInt(e),e.config.enableCycle?(e.vars.activeAlarmList=getEnabledAlarms(e,t),e.vars.activeAlarmList.length>1&&(e.vars.interval=setInterval(displayAlarms.bind(null,e),e.config.cycleInterval))):e.vars.activeAlarmList=function getLastHighest(e,t){let i=null;return getEnabledAlarms(e,t).forEach((function(e){null===i?i=e:e.severity>=i.severity&&e.timestamp_in>i.timestamp_in&&(i=e)})),null===i?[]:[i]}(e,t),displayAlarms(e)))}function displayAlarms(e){0===e.vars.activeAlarmList.length&&clearAlarmMsg(e),e.vars.currentAlarm>=e.vars.activeAlarmList.length&&(e.vars.currentAlarm=0),clearAlarmState(e);const t=e.vars.activeAlarmList[e.vars.currentAlarm++];let i=null;t?(i=shmi.evalString("${alarm_title_<%= value %>}",{value:t.index}),i=shmi.localize(i),i=shmi.evalString(i,t),isNaN(t.severity)||function setAlarmState(e,t){e in t.vars.stateIcons&&function show(e){e&&shmi.removeClass(e,"hidden")}(t.vars.stateIcons[e]);shmi.addClass(t.element,s[e])}(t.severity,e)):i=shmi.localize(e.config.noAlarm),e.vars.lastAlarmMsg.textContent=i,e.vars.lastAlarmsNum&&(e.vars.lastAlarmsNum.textContent=e.vars.lastAlarmsNumValue)}function getEnabledAlarms(e,t){const i=t.filter((function(t){if(Array.isArray(e.vars.groupFilter)&&!e.vars.groupFilter.includes(t.group))return!1;if(!t.active){if(!t.acknowledgeable)return!1;if(t.acknowledged)return!1}return 2===t.severity&&e.config.showAlarm||1===t.severity&&e.config.showWarn||0===t.severity&&e.config.showInfo}));return e.vars.lastAlarmsNumValue=i.length,i}function clearAlarmMsg(e){clearInt(e),e.vars.currentAlarm=0,clearAlarmState(e),e.vars.lastAlarmMsg.textContent=shmi.localize(e.config.noAlarm)}function clearInt(e){e.vars.interval&&(clearInterval(e.vars.interval),e.vars.interval=null)}function clearAlarmState(e){e.vars.stateIcons.forEach(hide),s.forEach((function(t){shmi.removeClass(e.element,t)}))}const n={className:"AlarmInfo",uiType:e,isContainer:!1,config:t,configSchema:null,vars:{hidden:!1,clickElement:null,lastAlarmsNum:null,lastAlarmsNumValue:0,lastAlarmMsg:null,lastAlarmMsgValue:0,lastAlarmClass:null,lastAlarmClassValue:0,listeners:[],tokens:[],stateIcons:[],activeAlarmList:[],currentAlarm:0,interval:0,alarmSubscriber:null,groupFilter:null},imports:{im:"visuals.session.ItemManager",am:"visuals.session.AlarmManager"},prototypeExtensions:{onInit:function(){const t=this,s=shmi.requires("visuals.io");let n=null,a=null,l=null,o=null,r=null,c=null;if("string"==typeof t.config.userGroups&&t.config.userGroups.length>0&&(o=t.config.userGroups.split(","),r=shmi.requires("visuals.session.UserManager"),c=r.currentUser,c.groupList.filter((function(e){return-1!==o.indexOf(e)})).length<1))return hide(shmi.getUiElement("alarm-info-wrapper",t.element)),void(t.vars.hidden=!0);t.vars.groupFilter=parseAlarmGroupFilter(t.config.groupFilter),t.vars.lastAlarmsNum=shmi.getUiElement("last-alarms-num",t.element),t.vars.lastAlarmsNum||i(e,"last-alarms-num not found in template"),t.vars.lastAlarmMsg=shmi.getUiElement("last-alarm-msg",t.element),t.vars.lastAlarmMsg?t.vars.lastAlarmMsg.textContent=shmi.localize(t.config.noAlarm):i(e,"last-alarm-msg not found in template"),t.vars.clickElement=shmi.getUiElement("alert-list-button",t.element),t.vars.clickElement&&Array.isArray(t.config.action)?(l={onClick:function(e,i,s){new(shmi.requires("visuals.core").UiAction)(t.config.action).execute()}},n=new s.MouseListener(t.vars.clickElement,l),a=new s.TouchListener(t.vars.clickElement,l),t.vars.listeners.push(n,a)):t.vars.clickElement||i(e,"click element not found in template")},onEnable:function(){const e=this;e.vars.hidden?i("Alarm Info is disabled"):(e.vars.stateIcons=shmi.getUiElements("state",e.element)||[],e.vars.alarmSubscriber=e.imports.am.subscribeAlarms(e,(function(t,i){i&&testAlarmState(e)})),e.vars.listeners.forEach((function(e){e.enable()})))},onDisable:function(){this.vars.tokens.forEach((function(e){e.unlisten()})),this.vars.tokens=[],this.vars.listeners.forEach((function(e){e.disable()})),this.imports.am.unsubscribeAlarms(this.vars.alarmSubscriber),clearInt(this)},onLock:function(){this.vars.listeners.forEach((function(e){e.disable()}))},onUnlock:function(){this.vars.listeners.forEach((function(e){e.enable()}))},onSetValue:function(e,t,i){},onSetProperties:function(e,t,i){}}};shmi.requires("visuals.tools.control-generator").generate(n)}(),function(){"use strict";var e="alpha-num-keyboard",t={"class-name":e,name:null,template:"default/alpha-num-keyboard",label:"Keyboard","key-preview":!0,"auto-key-focus":!1,"password-input":!1,"select-box-enabled":!0,keyboards:{}},i=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),s=(i.fLog,i.log),n={className:"AlphaNumKeyBoard",uiType:e,isContainer:!0,config:t,configSchema:null,vars:{listeners:[],controls:[],tokens:[],keys:[],keyboardMap:{},activeModifiers:{},activeKeyboard:null,activePalette:null,activeKeys:null,currentText:"",keyTypeListeners:{},previewContainer:null,shiftKeyActive:!1},imports:{},events:[],prototypeExtensions:{onInit:function(){var e=this;e.vars.keyListeners={onPress:onKeyPressListener.bind(null,e),onClick:onKeyClickListener.bind(null,e),onRelease:onKeyReleaseListener.bind(null,e)},e.vars.eventListeners={mouseOver:onKeyMouseInListener.bind(null,e),mouseOut:onKeyMouseOutListener.bind(null,e),mouseUp:onKeyMouseUpListener.bind(null,e),mouseDown:onKeyMouseDownListener.bind(null,e),touchStart:onKeyTouchStartListener.bind(null,e),touchEnd:onKeyTouchEndListener.bind(null,e),touchMove:onKeyTouchMoveListener.bind(null,e),keyDown:onKeyDownListener.bind(null,e),keyUp:onKeyUpListener.bind(null,e)},e.vars.keyboardContainer=shmi.getUiElement("keyboard-container",e.element),e.vars.keyboardTitleContainer=shmi.getUiElement("keyboard-title",e.element),e.vars.keyboardTitleContainer.innerHTML=e.config.label?e.config.label:"Keyboard";var t=shmi.requires("shmi.visuals.session.keyboards"),i=shmi.requires("visuals.session.localeInfo"),n=shmi.requires("visuals.session.UserManager");if(t){e.config.keyboards=t,n.currentUser&&n.currentUser.loggedIn&&t&&i.locales[n.currentUser.locale]&&i.locales[n.currentUser.locale].keyboard&&t[i.locales[n.currentUser.locale].keyboard]?e.vars.currentLocale=i.locales[n.currentUser.locale].keyboard:i.locales[i.default]&&i.locales[i.default].keyboard&&t[i.locales[i.default].keyboard]&&(e.vars.currentLocale=i.locales[i.default].keyboard);var a=Object.keys(t);!function initKeyboardControls(e){if(e.config["select-box-enabled"]&&Object.keys(e.config.keyboards).length>1){var t=shmi.requires("visuals.session.localeInfo"),i=shmi.getUiElement("language-control",e.element),n={label:"",options:[]},a=Object.keys(e.config.keyboards);if(a&&a.length>0){a.forEach((function(e,i){n.options.push({label:t.keyboards[e].label,value:e})}));var l=shmi.createControl("select-box",i,n,"DIV");shmi.waitOnInit(l,(function(){e.vars.currentLocale?l.setValue(e.vars.currentLocale):(e.config["default-keyboard"]=e.config["default-keyboard"]||a[0],l.setValue(e.config["default-keyboard"])),e.vars.tokens.push(l.listen("change",(function onChange(t){disableActiveKeyMapListeners(e),e.vars.activePalette.element.style.display="none",e.vars.activeKeyboard.element.style.display="none",e.vars.activeKeyboard=e.vars.keyboardMap[t.detail.value];var i;i=Object.keys(e.vars.activeKeyboard.paletteMap)[0],e.vars.activePalette=e.vars.activeKeyboard.paletteMap[i],e.vars.activeKeyMap=e.vars.activePalette.keyMap,e.vars.activeKeyboard.element.style.display="block",e.vars.activePalette.element.style.display="flex",enableActiveKeyMapListeners(e)})))})),shmi.addClass(i,"enabled"),e.vars.controls.push(l)}}var o=shmi.getUiElement("close-button",e.element),r=shmi.createControl("button",o,{"class-name":"button",label:"Cancel"},"DIV");e.vars.tokens.push(r.listen("click",(function onclick(t){s("Fire: Close Keyboard"),shmi.fire("keyboard-cancel",{success:!1,input:e.vars.currentText})}))),e.vars.controls.push(r);var c=shmi.getUiElement("submit-button",e.element),u=shmi.createControl("button",c,{"class-name":"button",label:"Submit"},"DIV");e.vars.tokens.push(u.listen("click",(function onclick(t){s("Fire: Submit Keyboard"),shmi.fire("keyboard-submit",{success:!0,input:e.vars.currentText})}))),e.vars.controls.push(u)}(e),a.forEach((function(i){var s=function createKeyboard(e,t,i){var s=Object.keys(i),n=document.createElement("DIV"),a={};return shmi.addClass(n,"keyboard"),shmi.addClass(n,"keyboard-"+t.toLowerCase()),n.setAttribute("data-name","keyboard-"+t),s.forEach((function(t,s){var l=i[t],o=function createKeyboardPalette(e,t,i){var s=document.createElement("DIV"),n=[],a={};return shmi.addClass(s,"keyboard-palette"),shmi.addClass(s,"keyboard-palette-"+t.toLowerCase()),s.setAttribute("data-name","palette-"+t),i.forEach((function(t){var i=function createKeyboardRow(e,t){var i=document.createElement("DIV"),s=[];return shmi.addClass(i,"key-row"),t.forEach((function(n,a){var l=function createKeyboardKey(e,t,i,s){var n=document.createElement("DIV"),a=document.createElement("DIV"),l=null,o=null,r=null;e.config["key-preview"]&&(l=document.createElement("DIV"),o=document.createElement("SPAN"));e.vars.keyTypeListeners[i.type]=e.vars.keyTypeListeners[i.type]||{};var c=String(i.name||t).replace(/"/g,'\\"');shmi.addClass(n,"key-box"),shmi.addClass(a,"key"),shmi.addClass(a,"key-"+c),a.setAttribute("data-key-name",c),e.config["auto-key-focus"]&&a.setAttribute("tabindex",0);i["class-name"]&&shmi.addClass(a,i["class-name"]);0!==Number(i.size)&&shmi.addClass(n,"key-box-flex-"+i.size);shmi.addClass(a,"key-"+i.type),a.setAttribute("data-key-type",i.type),a.innerText=i.name||"",n.appendChild(a),l&&(shmi.addClass(l,"key-preview"),o.innerText=i.name||"",n.appendChild(l),l.appendChild(o));i.alternatives&&(r=document.createElement("DIV"),shmi.addClass(r,"alt-keys"),s?shmi.addClass(r,"left-side"):shmi.addClass(r,"right-side"),i.alternatives.forEach((function(t){var i=createKeyboardKey(e,t.name,t);r.appendChild(i.element)})),shmi.addClass(r,"numofKeys-"+i.alternatives.length),n.appendChild(r));return i.element=n,i}(e,n.name,n,a<t.length/2);i.appendChild(l.element),s.push(l),l.alternatives&&l.alternatives.forEach((function(e){s.push(e)}))})),{keys:s,element:i}}(e,t);s.appendChild(i.element),n.push(i),i.keys.forEach((function(e){var t=getUnusedId(a);e["data-key-id"]=t,e.element.setAttribute("data-key-id",t),a[e["data-key-id"]]=e}))})),{name:t,element:s,keyMap:a}}(e,t,l),r=getUnusedId(a);o.id=r,o.element.setAttribute("data-key-id",r),o.element.style.display=0===s?"flex":"none",n.appendChild(o.element),a[r]=o})),{paletteMap:a,name:t,element:n}}(e,i,t[i]);e.vars.keyboardContainer.appendChild(s.element),e.vars.keyboardMap[i]=s})),e.vars.previewContainer=shmi.getUiElement("text-preview",e.element),e.vars.currentText=e.config.value||e.vars.currentText,updatePreviewTextContent(e),e.vars.previewContainer.focus();var l;e.vars.currentLocale?e.vars.activeKeyboard=e.vars.keyboardMap[e.vars.currentLocale]:e.vars.activeKeyboard=e.vars.keyboardMap[Object.keys(e.vars.keyboardMap)[0]],l=Object.keys(e.vars.activeKeyboard.paletteMap)[0],e.vars.activePalette=e.vars.activeKeyboard.paletteMap[l],e.vars.activeKeyMap=e.vars.activePalette.keyMap,e.vars.activeKeyboard.element.style.display="block",e.config["key-preview"]&&shmi.addClass(e.element,"key-preview-enabled"),enableActiveKeyMapListeners(e)}},onEnable:function(){this.vars.listeners.forEach((function(e){e.enable()})),this.vars.controls.forEach((function(e){e.enable()})),this.config["password-input"]?document.onkeydown=function(e){return!1}:(document.addEventListener("keydown",this.vars.eventListeners.keyDown),document.addEventListener("keyup",this.vars.eventListeners.keyUp)),shmi.log("[Alpha Num Keyboard] enabled",1)},onDisable:function(){this.hide(),this.config["password-input"]?document.onkeydown=null:(document.removeEventListener("keydown",this.vars.eventListeners.keyDown),document.removeEventListener("keyup",this.vars.eventListeners.keyUp)),this.vars.listeners.forEach((function(e){e.disable()})),this.vars.controls.forEach((function(e){e.disable()})),this.vars.tokens.forEach((function(e){e.unlisten()})),shmi.log("[Alpha Num Keyboard] disabled",1)},onLock:function(){this.vars.listeners.forEach((function(e){e.disable()})),this.vars.controls.forEach((function(e){e.lock()}))},onUnlock:function(){this.vars.listeners.forEach((function(e){e.enable()})),this.vars.controls.forEach((function(e){e.unlock()}))},show:function(){shmi.removeClass(this.element,"closed"),shmi.addClass(this.element,"open")},hide:function(){shmi.removeClass(this.element,"open"),shmi.addClass(this.element,"closed")},onSetValue:function(e,t,i){},onSetProperties:function(e,t,i){}}};function setKeyConfig(e,t,i){var s=i.name||t.name;if(s&&(t.element.firstChild.textContent=s,e.config["key-preview"])){var n=t.element.getElementsByTagName("span")[0];n&&(n.innerText=s)}var a=i["class-name"];a&&("!"===a.charAt(0)?shmi.removeClass(t.element,a.substring(1)):shmi.addClass(t.element,a));var l=t.element.className,o=i.size||t.size,r=o?"key-box-flex-"+o:null;-1===t.element.className.indexOf(r)&&r&&(t.element.className=(" "+l+" ").replace(/\bkey-box-flex-\S*\b/g," "),shmi.addClass(t.element,r));var c=i.type||t.type;t.element.firstChild.setAttribute("data-key-type",c)}function enableActiveKeyMapListeners(e){Object.keys(e.vars.activeKeyMap).forEach((function(t){var i=new shmi.visuals.io.MouseListener(e.vars.activeKeyMap[t].element,e.vars.keyListeners),s=new shmi.visuals.io.TouchListener(e.vars.activeKeyMap[t].element,e.vars.keyListeners),n=e.vars.activeKeyMap[t].element.firstChild;i.enable(),s.enable(),e.vars.listeners.push(i,s),n.addEventListener("mouseover",e.vars.eventListeners.mouseOver),n.addEventListener("mouseout",e.vars.eventListeners.mouseOut),n.addEventListener("mousedown",e.vars.eventListeners.mouseDown),n.addEventListener("mouseup",e.vars.eventListeners.mouseUp)})),e.vars.activePalette.element.addEventListener("touchstart",e.vars.eventListeners.touchStart)}function disableActiveKeyMapListeners(e){e.vars.listeners.forEach((function(e){e.disable()})),e.vars.listeners=[],Object.keys(e.vars.activeKeyMap).forEach((function(t){var i=e.vars.activeKeyMap[t].element.firstChild;i.removeEventListener("mouseover",e.vars.eventListeners.mouseOver),i.removeEventListener("mousedown",e.vars.eventListeners.mouseDown),i.removeEventListener("mouseout",e.vars.eventListeners.mouseOut),i.removeEventListener("mouseup",e.vars.eventListeners.mouseUp),e.vars.activePalette.element.removeEventListener("touchstart",e.vars.eventListeners.touchStart)}))}var a=["A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"];function getRandomId(e){var t="";void 0===e&&(e=3);for(var i=0;i<e;i++)t+=a[Math.floor(Math.random()*(a.length-1))];return t}function getUnusedId(e){var t=null;do{t=getRandomId(8)}while(shmi.objectHasOwnProperty(e,t));return t}function fireKeyboardClick(e,t,i){switch(t.type){case"letter":case"number":case"character":!function addLetterIntoCurrentText(e,t){var i=evaluateKeyModifiers(e,t).val||t.val,s=String(e.vars.currentText),n=null,a=e.vars.previewContainer.selectionStart;i&&1===i.length&&(n=s.substr(0,e.vars.previewContainer.selectionStart)+i+s.substr(e.vars.previewContainer.selectionEnd),e.vars.currentText=n,updatePreviewTextContent(e),e.vars.previewContainer.selectionStart=e.vars.previewContainer.selectionEnd=a+1);i&&2===i.length&&(n=s.substr(0,e.vars.previewContainer.selectionStart)+i+s.substr(e.vars.previewContainer.selectionEnd),e.vars.currentText=n,updatePreviewTextContent(e),e.vars.previewContainer.selectionStart=e.vars.previewContainer.selectionEnd=a+2)}(e,t);break;case"palette":t.palette?function setKeyboardPalette(e,t){var i,s=t.palette;(i=Object.values(e.vars.activeKeyboard.paletteMap).filter((function(e){return e&&e.name===s}))[0])?(e.vars.activePalette.element.style.display="none",disableActiveKeyMapListeners(e),e.vars.activePalette=i,e.vars.activeKeyMap=e.vars.activePalette.keyMap,e.vars.activePalette.element.style.display="flex",enableActiveKeyMapListeners(e)):console.error('[Keyboard] - can not find palette with name: "'+s+'"')}(e,t):console.error("[alpha-num-keyboard] Missing palette attribute value on key of type palette");break;case"modifier":var n,a,l,o=t.modify?t.modify.split(":"):null;o&&3===o.length&&(n=o[0],a=o[1],isModifierActive(e,l=o[2])?(shmi.removeClass(i.target,"clipped"),unsetModifier(e,l,a,n,i)):function setModifier(e,t,i,n,a){if(!isModifierActive(e,t)){var l=getActivePaletteId(e);e.vars.activeModifiers[l]=e.vars.activeModifiers[l]||[],e.vars.activeModifiers[l].push(t),function createModificationTypeListeners(e,t,i,n,a){var l=getRandomId(8);if(e&&t&&i&&n&&a)switch(i){case"clip":e.vars.keyTypeListeners[n][i]=e.vars.keyTypeListeners[n][i]||{},e.vars.keyTypeListeners[n][i][l]=function createClipModifierFunction(e,t,i,s,n,a){return function modClip(l,o){return l===a||o.modify!==s+":"+i+":"+t||(delete e.vars.keyTypeListeners[s][i][n],unsetModifier(e,t,i,s,a),!1)}}(e,t,i,n,l,a);break;case"clipOnce":shmi.addClass(a.target,"clipped"),e.vars.keyTypeListeners[n][i]=e.vars.keyTypeListeners[n][i]||{},e.vars.keyTypeListeners[n][i][l]=function createClipOnceModifierFunction(e,t,i,s,n,a){return function modClipOnce(l,o){return l===a||o.type!==s&&o.modify!==s+":"+i+":"+t||(shmi.removeClass(a.target,"clipped"),delete e.vars.keyTypeListeners[s][i][n],unsetModifier(e,t,i,s,a),!1)}}(e,t,i,n,l,a);break;default:s("Undefined modifier mode",i)}}(e,t,i,n,a),Object.keys(e.vars.activeKeyMap).forEach((function(t){if(e.vars.activeKeyMap[t].type===n){var i=evaluateKeyModifiers(e,e.vars.activeKeyMap[t]);setKeyConfig(e,e.vars.activeKeyMap[t],i)}}))}}(e,l,a,n,i));break;case"resolver":!function keyResolver(e,t){var i=t.resolve;if(i)switch(i){case"backspace":!function deleteLetterFromCurrentText(e){var t=String(e.vars.currentText),i=t,s=0;e.vars.previewContainer.selectionStart===e.vars.previewContainer.selectionEnd?0!==e.vars.previewContainer.selectionStart&&(""===function getSymbols(e){for(var t=0,i=e.length,s=[];t<i-1;++t){var n=e.charCodeAt(t);n>=55296&&n<=56319&&(n=e.charCodeAt(t+1))>=56320&&n<=57343?(s.push(e.slice(t,t+2)),++t):s.push(e.charAt(t))}return s.push(e.charAt(t)),s}(t.substr(e.vars.previewContainer.selectionStart-2,e.vars.previewContainer.selectionStart))[1]?(i=t.substr(0,e.vars.previewContainer.selectionStart-2)+t.substr(e.vars.previewContainer.selectionEnd),s=e.vars.previewContainer.selectionStart-2):(i=t.substr(0,e.vars.previewContainer.selectionStart-1)+t.substr(e.vars.previewContainer.selectionEnd),s=e.vars.previewContainer.selectionStart-1)):(i=t.substr(0,e.vars.previewContainer.selectionStart)+t.substr(e.vars.previewContainer.selectionEnd),s=e.vars.previewContainer.selectionStart);e.vars.currentText=i,updatePreviewTextContent(e),e.vars.previewContainer.selectionStart=e.vars.previewContainer.selectionEnd=s}(e);break;case"submit":s("Fire: Submit Keyboard"),shmi.fire("keyboard-submit",{success:!0,input:e.vars.currentText});break;default:s("Missing Default Case")}}(e,t);break;default:s("uncatched keyboard event: "+t.type)}}function unsetModifier(e,t,i,s,n){if(isModifierActive(e,t)){var a=getActivePaletteId(e),l=e.vars.activeModifiers[a].indexOf(t);e.vars.activeModifiers[a].splice(l,1),Object.keys(e.vars.activeKeyMap).forEach((function(t){var i=evaluateKeyModifiers(e,e.vars.activeKeyMap[t]);setKeyConfig(e,e.vars.activeKeyMap[t],i)}))}}function evaluateKeyModifiers(e,t){const i={},s=shmi.cloneObject(t.modifiers);return shmi.requires("visuals.tools.iterate.iterateObject")(s||{},(s,n)=>{const a=n.split(":");2!==a.length?console.error("[Keyboard] - modifier not configured right",t):isModifierActive(e,a[0])?i[a[1]]=s:"class-name"===a[1]&&(i[a[1]]="!"+s)}),i}function isModifierActive(e,t){var i=getActivePaletteId(e);return e.vars.activeModifiers[i]&&-1!==e.vars.activeModifiers[i].indexOf(t)}function getActivePaletteId(e){return e.vars.activeKeyboard.name.toLowerCase()+":"+e.vars.activePalette.name.toLowerCase()}function removeAllPressedHighlights(e){e.vars.activePalette.element.querySelectorAll(".key.pressed").forEach((function(e){shmi.removeClass(e,"pressed")}))}function removeAllAltKeys(e){clearTimeout(e.vars.altKeysTimeout),e.vars.activePalette.element.querySelectorAll(".key.show-alt-keys").forEach((function(e){shmi.removeClass(e,"show-alt-keys")}))}function fireTypeListeners(e,t,i){var s=shmi.requires("visuals.tools.iterate").iterateObject,n=t.type,a=!1;if(n){var l=e.vars.keyTypeListeners[n];s(l,(function(e,n){s(e,(function(e,s){!1===e(i,t)&&(a=!0)}))}))}return!a}function getKeyByValue(e,t){var i;return(i=Object.values(e.vars.activeKeyMap).filter((function(e){var i=t.key.toLowerCase();return e.name===i}))[0])?e.vars.activeKeyMap[i["data-key-id"]]:null}function updatePreviewTextContent(e){if(e.vars.previewContainer)if(e.config["password-input"]){for(var t="",i=0;i<e.vars.currentText.length;i++)t+="●";e.vars.previewContainer.value=t}else e.vars.previewContainer.value=e.vars.currentText}function onKeyPressListener(e,t,i,s){-1!==s.type.indexOf("mouse")&&-1===s.type.indexOf("touch")?shmi.addClass(e.element,"hover-enabled"):shmi.removeClass(e.element,"hover-enabled"),e.vars.keyPressed=s.target.getAttribute("data-key-name"),shmi.addClass(s.target,"pressed")}function onKeyClickListener(e,t,i,s){var n=s.target.parentNode,a=n.getAttribute("data-key-id"),l=e.vars.activeKeyMap[a];n&&l&&(e.vars.keyPressed=!1,e.vars.mouseMoveKey=null,fireKeyboardClick(e,l,s),fireTypeListeners(e,l,s),e.config["auto-key-focus"]&&document.activeElement!==n&&n.focus())}function onKeyReleaseListener(e,t,i,s){if(e.vars.keyPressed){var n=s.target;shmi.removeClass(n,"pressed")}}function onKeyMouseDownListener(e,t){shmi.removeClass(e.element,"key-preview-enabled");var i=t.target.getAttribute("data-key-name")||!1,s=e.vars.activeKeyMap[t.target.parentElement.getAttribute("data-key-id")];e.vars.keyPressed=i,e.vars.mouseMoveKey=null,e.vars.keyPressed&&s&&s.hold&&!s.alternatives&&setTimeout((function(){if(e.vars.keyPressed===i){e.vars.keyHeld=!0;var n=setInterval((function(){e.vars.keyPressed===i?(fireKeyboardClick(e,s,t),fireTypeListeners(e,s,t)):clearInterval(n)}),120)}}),1e3),s&&s.alternatives&&(e.vars.altKeysTimeout=setTimeout((function(){e.vars.keyPressed===i&&(shmi.removeClass(e.element,"key-preview-enabled"),shmi.addClass(t.target,"show-alt-keys"))}),500))}function onKeyMouseUpListener(e,t){if(e.vars.keyPressed){e.vars.keyPressed=!1;var i=t.target;shmi.removeClass(t.target,"pressed"),e.vars.previewContainer.focus(),e.config["auto-key-focus"]&&document.activeElement!==i&&i.focus(),(i=e.vars.activeKeyMap[i.parentElement.getAttribute("data-key-id")])&&e.vars.mouseMoveKey&&(fireKeyboardClick(e,i,t),fireTypeListeners(e,i,t),e.vars.mouseMoveKey=null)}removeAllAltKeys(e)}function onKeyMouseInListener(e,t){if(e.vars.keyPressed){var i=t.target;e.vars.mouseMoveKey=e.vars.keyHeld?null:i,e.vars.keyPressed=i.getAttribute("data-key-name"),shmi.addClass(i,"pressed")}}function onKeyMouseOutListener(e,t){if(e.vars.keyPressed){var i=t.target;e.vars.mouseMoveKey=null,shmi.removeClass(i,"pressed")}}function onKeyTouchStartListener(e,t){e.config["key-preview"]&&shmi.addClass(e.element,"key-preview-enabled");var i=t.target.getAttribute("data-key-name"),s=e.vars.activeKeyMap[t.target.parentElement.getAttribute("data-key-id")];e.vars.keyPressed=i,e.vars.mouseMoveKey=null,e.vars.activePalette.element.addEventListener("touchend",e.vars.eventListeners.touchEnd),e.vars.activePalette.element.addEventListener("touchmove",e.vars.eventListeners.touchMove),i&&s&&s.hold&&!s.alternatives&&setTimeout((function(){if(e.vars.keyPressed===i){e.vars.keyHeld=!0;var n=setInterval((function(){e.vars.keyPressed===i?(fireKeyboardClick(e,s,t),fireTypeListeners(e,s,t)):clearInterval(n)}),120)}}),1e3),s&&s.alternatives&&(e.vars.altKeysTimeout=setTimeout((function(){e.vars.keyPressed===i&&(shmi.removeClass(e.element,"key-preview-enabled"),shmi.addClass(t.target,"show-alt-keys"))}),500))}function onKeyTouchMoveListener(e,t){if(t.preventDefault(),t.stopPropagation(),e.vars.keyPressed){var i=t.touches[0].clientY,s=t.touches[0].clientX,n=document.elementFromPoint(s,i);if(n){var a=n.getAttribute("data-key-name");a&&n!==e.vars.dragCurrentKey&&(e.vars.keyHeld||a===e.vars.keyPressed||(removeAllPressedHighlights(e),shmi.addClass(n,"pressed")),e.vars.dragCurrentKey=n,e.vars.keyPressed=a)}}}function onKeyTouchEndListener(e,t){if(e.vars.keyPressed=!1,e.vars.activePalette.element.removeEventListener("touchend",e.vars.eventListeners.touchEnd),e.vars.activePalette.element.removeEventListener("touchmove",e.vars.eventListeners.touchMove),e.vars.dragCurrentKey&&!e.vars.keyHeld){removeAllPressedHighlights(e),e.vars.previewContainer.focus(),e.config["auto-key-focus"]&&document.activeElement!==t.target&&e.vars.dragCurrentKey.focus();var i=e.vars.activeKeyMap[e.vars.dragCurrentKey.parentElement.getAttribute("data-key-id")];i&&(fireKeyboardClick(e,i,t),fireTypeListeners(e,i,t)),e.vars.dragCurrentKey=null}else e.vars.keyHeld=!1;removeAllAltKeys(e)}function onKeyDownListener(e,t){if(!e.vars.lastKey||e.vars.lastKey!==t.key){e.vars.lastKey=t.key,shmi.removeClass(e.element,"key-preview-enabled"),shmi.removeClass(e.element,"hover-enabled");var i=getKeyByValue(e,t);i&&(shmi.addClass(i.element.firstChild,"pressed"),e.vars.previewContainer&&document.activeElement!==e.vars.previewContainer&&(e.config["auto-key-focus"]||e.vars.previewContainer.focus())),e.vars.currentText=e.vars.previewContainer.value,updatePreviewTextContent(e)}}function onKeyUpListener(e,t){e.vars.lastKey=null,"escape"===t.key.toLowerCase()&&(s("Fire: Close Keyboard"),shmi.fire("keyboard-cancel",{success:!1,input:e.vars.currentText}));var i=getKeyByValue(e,t);i&&shmi.removeClass(i.element.firstChild,"pressed"),e.vars.currentText=e.vars.previewContainer.value,updatePreviewTextContent(e)}shmi.requires("visuals.tools.control-generator").generate(n)}(),function(){var e=null,t=null;function deleteKeyboard(){t&&(shmi.deleteControl(t),t=null),e=null}function defaultkeyboardHandler(i){if(null===t)try{shmi.requires("visuals.handler.default.keyboard"),(e=i)&&function createKeyboard(){var i={},s=shmi.requires("visuals.tools.iterate.iterateObject"),n=null,a=null,l=null;function onKeyboardEnable(){l&&(l.unlisten(),l=null),t.show()}s(e.detail,(function(t,s){i[s]=e.detail[s]})),i.label&&(i.label=shmi.evalString(shmi.localize(i.label),e.detail.param)),t=shmi.createControl("alpha-num-keyboard",document.body,i,"DIV"),n=shmi.listen("keyboard-submit",(function(e){n.unlisten(),a.unlisten(),n=a=null,deleteKeyboard(),shmi.log("Keyboard closed, changes submited",e),i.callback&&"function"==typeof i.callback&&i.callback(!0,e.detail.input)})),a=shmi.listen("keyboard-cancel",(function(e){a.unlisten(),n.unlisten(),a=n=null,deleteKeyboard(),shmi.log("Keyboard closed, changes aborted",e),i.callback&&"function"==typeof i.callback&&i.callback(!1,null)})),t.isActive()?onKeyboardEnable():l=t.listen("enable",onKeyboardEnable),t.enable()}()}catch(e){shmi.log("[Keyboard] - error trying to load controls: Keyboard\n"+e)}}var i=shmi.pkg("visuals.handler.default.keyboard"),s=null;i.register=function(){s&&(console.debug("Keyboard handler was active!"),s.unlisten(),s=null),s=shmi.listen("keyboard-request",defaultkeyboardHandler)},i.deregister=function(){s?(s.unlisten(),s=null):console.debug("Keyboard handler not active!")},i.register()}(),shmi.keyboard=function(e){0===shmi.fire("keyboard-request",e,shmi)&&shmi.log("[Keyboard] - Keyboard not found")},shmi.pkg("visuals.controls"),shmi.visuals.controls.Button=function(e,t){shmi.requires("visuals.core.UiAction"),shmi.requires("visuals.io.MouseListener"),shmi.requires("visuals.io.TouchListener");this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","button"),shmi.def(this.config,"template","default/button"),shmi.def(this.config,"name",null),shmi.def(this.config,"icon-src",null),shmi.def(this.config,"icon-title",null),shmi.def(this.config,"show-text",!0),shmi.def(this.config,"show-icon",!1),shmi.def(this.config,"label-from-item",!1),shmi.def(this.config,"icon-class",null),shmi.def(this.config,"precision",-1),shmi.def(this.config,"label","button"),shmi.def(this.config,"type",shmi.c("TYPE_STRING")),shmi.def(this.config,"unit-text",null),shmi.def(this.config,"disable-item-lock",!1),shmi.def(this.config,"monoflop",!1),shmi.def(this.config,"monoflop-interval",100),shmi.def(this.config,"monoflop-value",1),shmi.def(this.config,"decimal-delimiter","."),shmi.def(this.config,"auto-precision",!0),shmi.def(this.config,"auto-label",!0),shmi.def(this.config,"auto-unit-text",!0),shmi.def(this.config,"auto-type",!0),this.config["show-text"]=shmi.toBoolean(this.config["show-text"]),this.config["show-icon"]=shmi.toBoolean(this.config["show-icon"]),this.config["label-from-item"]=shmi.toBoolean(this.config["label-from-item"]),this.mouselistener=null,this.touchlistener=null,this.active=!1,this.initialized=!1,this.labelElement=null,this.valueElement=null,this.rafId=0,this._subscriptionTargetId=null,this.vars={tokens:[],monoFlopInterval:0,conditional:null},this.startup()},shmi.visuals.controls.Button.prototype={uiType:"button",events:["press","release","click"],tooltipProperties:["icon-title"],getClassName:function(){return"Button"},onInit:function(){var e=this;shmi.requires("visuals.tools.numericValues").initValueSettings(e);var t=shmi.getUiElement("button-label",e.element);t?e.labelElement=t:shmi.log("[Button] no button-label element provided",1),e.valueElement=shmi.getUiElement("button-value",e.element);var i=shmi.getUiElement("button-icon",e.element);if(i){if(e.config["icon-src"])try{i.setAttribute("src",e.config["icon-src"])}catch(e){shmi.log("[Button] Exception setting icon-src: "+e,2)}else if(e.config["icon-class"]){if("IMG"===i.tagName){var s=document.createElement("div");shmi.addClass(s,"button-icon"),i.parentNode.insertBefore(s,i),i.parentNode.removeChild(i),i=s}e.config["icon-class"].trim().split(" ").forEach((function(e){shmi.addClass(i,e)}))}}else shmi.log("[Button] no button-icon element provided",1);t&&e.config.label&&(t.textContent=shmi.localize(e.config.label)),e.config.action&&(e.action=new shmi.visuals.core.UiAction(e.config.action,e)),!0===e.config["show-text"]&&!0===e.config["show-icon"]?shmi.addClass(e.element,"icon-and-text"):!0===e.config["show-icon"]&&shmi.addClass(e.element,"icon-only");var n=shmi.getUiElement("unit-text",e.element);n&&e.config["unit-text"]&&(n.textContent=shmi.localize(e.config["unit-text"]));var a={},l=shmi.visuals.session;a.onClick=function(t,i,s){null!==l.FocusElement&&(l.FocusElement.blur(),l.FocusElement=null),e.element instanceof HTMLElement?(e.element.focus(),shmi.log("[Button] focused",1)):shmi.log("[Button] only HTMLElements may be focused, type: "+e.element.constructor,1);var n={x:t,y:i,event:s};e.fire("click",n),e.action&&e.action.execute(),e.onClick&&e.onClick(e)},a.onPress=function(t,i,s){shmi.addClass(this.element,"pressed");var n={x:t,y:i,event:s};e.fire("press",n)}.bind(e),a.onRelease=function(t,i,s){shmi.removeClass(e.element,"pressed");var n={x:t,y:i,event:s};e.fire("release",n)};var o=shmi.visuals.io;e.mouselistener=new o.MouseListener(e.element,a),e.touchlistener=new o.TouchListener(e.element,a),e.vars.keyUpListener=function(t){if(e.vars.keyDownOnMe&&("Enter"===t.code||"NumpadEnter"===t.code)&&e.element===document.activeElement){shmi.removeClass(e.element,"pressed");var i=e.element.getBoundingClientRect();a.onClick(i.left+i.width/2,i.top+i.height/2,t),e.vars.keyDownOnMe=!1}},e.vars.keyDownListener=function(t){"Enter"!==t.code&&"NumpadEnter"!==t.code||e.element!==document.activeElement||(shmi.addClass(e.element,"pressed"),e.vars.keyDownOnMe=!0)}},onEnable:function(){var e=this;null!==e.vars.conditional?e.vars.conditional.item!==e.config.item&&(e.vars.conditional.item=e.config.item):e.config.item&&(e.vars.conditional=shmi.createConditional(e.element,e.config.item)),e.vars.conditional&&e.vars.conditional.enable(),e.element.setAttribute("tabindex","0"),e.mouselistener.enable(),e.touchlistener.enable();var t=shmi.requires("visuals.session.ItemManager");if(e.config.item){if(e.config["disable-item-lock"]){var i=t.getItemHandler();i.setValue=function(t){e.setValue(t)},e._subscriptionTargetId=t.subscribeItem(e.config.item,i)}else e._subscriptionTargetId=t.subscribeItem(e.config.item,e);if(e.config.monoflop){var s=e.listen("press",(function(){clearInterval(e.vars.monoFlopInterval),e.vars.monoFlopInterval=setInterval((function(){var i={};i[e.config.item]=e.config["monoflop-value"],t.writeDirect(i,(function(t,i){0!==t&&console.error("[ItemManager] failed to write item:",e.config.item,t,i)}))}),e.config["monoflop-interval"])})),n=e.listen("release",(function(){clearInterval(e.vars.monoFlopInterval)}));e.vars.tokens.push(s,n)}}e.element.addEventListener("keyup",e.vars.keyUpListener,!1),e.element.addEventListener("keydown",e.vars.keyDownListener,!1),shmi.log("[Button] enabled",1)},onDisable:function(){this.vars.conditional&&this.vars.conditional.disable(),this.config.item&&shmi.visuals.session.ItemManager.unsubscribeItem(this.config.item,this._subscriptionTargetId),this.element.removeAttribute("tabindex"),this.vars.tokens.forEach((function(e){e.unlisten()})),this.vars.tokens=[],this.mouselistener.disable(),this.touchlistener.disable(),this.element.removeEventListener("keyup",this.vars.keyUpListener),this.element.removeEventListener("keydown",this.vars.keyDownListener),shmi.log("[Button] disabled",1)},onSetValue:function(e){var t=this,i=shmi.requires("visuals.tools.numericValues");!0===t.config["label-from-item"]?t.labelElement&&(shmi.caf(t.rafId),t.rafId=shmi.raf((function(){t.labelElement.textContent=shmi.localize(i.formatOutput(e,t))}))):t.valueElement&&(shmi.caf(t.rafId),t.rafId=shmi.raf((function(){t.valueElement.textContent=i.formatOutput(e,t)})))},onSetProperties:function(e,t,i){var s=this,n=shmi.requires("visuals.tools.numericValues");n.setProperties(s,arguments)},onLock:function(){this.mouselistener.disable(),this.touchlistener.disable(),shmi.addClass(this.element,"locked"),shmi.log("[Button] locked",1),this.element.removeAttribute("tabindex"),this.element.removeEventListener("keyup",this.vars.keyUpListener),this.element.removeEventListener("keydown",this.vars.keyDownListener)},onUnlock:function(){this.mouselistener.enable(),this.touchlistener.enable(),shmi.removeClass(this.element,"locked"),shmi.log("[Button] unlocked",1),this.element.setAttribute("tabindex",0),this.element.addEventListener("keyup",this.vars.keyUpListener,!1),this.element.addEventListener("keydown",this.vars.keyDownListener,!1)},setLabel:function(e){this.config["auto-label"]&&this.labelElement&&(this.labelElement.textContent=shmi.localize(e))},setUnitText:function(e){var t=shmi.getUiElement("unit-text",this.element);this.config["auto-unit-text"]&&t&&(t.textContent=shmi.localize(e))}},shmi.extend(shmi.visuals.controls.Button,shmi.visuals.core.BaseControl),function(){function setBoxValue(e,t){var i=shmi.requires("visuals.session.ItemManager");e.config.item?i.writeValue(e.config.item,t):e.setValue(t)}shmi.pkg("visuals.controls"),shmi.visuals.controls.CheckBox=function(e,t){shmi.requires("visuals.io.MouseListener"),shmi.requires("visuals.io.TouchListener");this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","checkbox"),shmi.def(this.config,"template","default/checkbox"),shmi.def(this.config,"name",null),shmi.def(this.config,"on-value",1),shmi.def(this.config,"off-value",0),shmi.def(this.config,"pressedClass","pressed"),shmi.def(this.config,"icon-src",null),shmi.def(this.config,"icon-title",null),shmi.def(this.config,"icon-class",null),shmi.def(this.config,"label","checkbox"),shmi.def(this.config,"auto-label",!0),shmi.def(this.config,"show-icon",!1),shmi.def(this.config,"show-text",!0),shmi.def(this.config,"confirm-off-text","${V_CONFIRM_OFF}"),shmi.def(this.config,"confirm-on-text","${V_CONFIRM_ON}"),shmi.def(this.config,"confirm-on",!1),shmi.def(this.config,"confirm-off",!1),this.value=0,this.initialized=!1,this.active=!1,this._subscriptionTargetId=null,this.mouseListener=null,this.touchListener=null,this.startup()},shmi.visuals.controls.CheckBox.prototype={uiType:"checkbox",events:["change"],tooltipProperties:["icon-title"],getClassName:function(){return"CheckBox"},onInit:function(){var e=this,t=shmi.getUiElement("checkbox-icon",e.element);if(t){if(e.config["icon-src"])try{t.setAttribute("src",e.config["icon-src"])}catch(e){shmi.log("[Checkbox] Exception setting icon-src: "+e,2)}else if(e.config["icon-class"]){if("IMG"===t.tagName){var i=document.createElement("div");shmi.addClass(i,"checkbox-icon"),t.parentNode.insertBefore(i,t),t.parentNode.removeChild(t),t=i}e.config["icon-class"].trim().split(" ").forEach((function(e){shmi.addClass(t,e)}))}}else shmi.log("[Checkbox] no button-icon element provided",1);if(e.element)if(e.config["show-text"]&&e.config["show-icon"]?shmi.addClass(e.element,"icon-and-text"):e.config["show-icon"]&&shmi.addClass(e.element,"icon-only"),e.handleElement=shmi.getUiElement("checkbox-handle",e.element),e.handleElement)if(e.backgroundElement=shmi.getUiElement("checkbox-background",e.element),e.backgroundElement){e.labelElement=shmi.getUiElement("checkbox-label",e.element),e.labelElement&&e.config.label&&(e.labelElement.textContent=shmi.localize(e.config.label)),shmi.addClass(e.handleElement,"hidden");var s={onClick:function(){e.value===e.config["on-value"]?e.config["confirm-off"]?shmi.confirm(e.config["confirm-off-text"],(function onConfirmed(t){t&&setBoxValue(e,e.config["off-value"])})):setBoxValue(e,e.config["off-value"]):e.config["confirm-on"]?shmi.confirm(e.config["confirm-on-text"],(function onConfirmed(t){t&&setBoxValue(e,e.config["on-value"])})):setBoxValue(e,e.config["on-value"])},onPress:function(){shmi.addClass(e.element,e.config.pressedClass)},onRelease:function(){shmi.removeClass(e.element,e.config.pressedClass)}};e.mouseListener=new shmi.visuals.io.MouseListener(e.element,s),e.touchListener=new shmi.visuals.io.TouchListener(e.element,s),shmi.log("[Checkbox] initialized",1)}else shmi.log("[CheckBox] no checkbox-background found in base element",3);else shmi.log("[CheckBox] no checkbox-handle found in base element",3);else shmi.log("[CheckBox] no base element provided",3)},onEnable:function(){this.config.item&&(this._subscriptionTargetId=shmi.visuals.session.ItemManager.subscribeItem(this.config.item,this)),this.mouseListener.enable(),this.touchListener.enable(),shmi.log("[CheckBox] enabled",1)},onDisable:function(){this.config.item&&shmi.visuals.session.ItemManager.unsubscribeItem(this.config.item,this._subscriptionTargetId),this.mouseListener.disable(),this.touchListener.disable(),shmi.log("[CheckBox] disabled",1)},onLock:function(){this.mouseListener.disable(),this.touchListener.disable(),shmi.addClass(this.element,"locked"),shmi.log("[CheckBox] locked",1)},onUnlock:function(){this.mouseListener.enable(),this.touchListener.enable(),shmi.removeClass(this.element,"locked"),shmi.log("[CheckBox] unlocked",1)},onSetValue:function(e){var t=!1;e===this.config["on-value"]?(this.value=this.config["on-value"],t=!0,shmi.removeClass(this.handleElement,"hidden")):(this.value=this.config["off-value"],t=!0,shmi.addClass(this.handleElement,"hidden")),t&&this.fire("change",{value:this.value})},getValue:function(){return this.value},setLabel:function(e){this.labelElement&&this.config["auto-label"]&&(this.labelElement.textContent=shmi.localize(e))}},shmi.extend(shmi.visuals.controls.CheckBox,shmi.visuals.core.BaseControl)}(),function(){shmi.pkg("visuals.controls");var e,t=-1,i=1;function isEqualDeepImpl(e,t,i=[]){if(e===t)return!0;if(typeof e!=typeof t||"object"!=typeof e)return!1;if(Array.isArray(e)!==Array.isArray(t))return!1;if(function isKnown(e,t,i){return-1!==i.findIndex(i=>e===i.lhs&&t===i.rhs)}(e,t,i))return!0;if(Array.isArray(e))return e.length===t.length&&(i.push({lhs:e,rhs:t}),e.every((e,s)=>isEqualDeepImpl(e,t[s],i)));{const s=Object.keys(e);return!!function objectsHaveSameKeys(e,t){const i=Object.keys(e),s=Object.keys(t);return i.length===s.length&&i.every(e=>s.includes(e))}(e,t)&&(i.push({lhs:e,rhs:t}),s.every(s=>isEqualDeepImpl(e[s],t[s],i)))}}function getRowOffset(e,t){let i=null;const s=shmi.requires("visuals.session.DataGridManager").getGrid(e.cConfig.table),n=e.dgSubscription.id;if(t>=0){const a=e.pageBuf.bufferOffset,l=s.getCurrentIDs(n).findIndex(e=>e===t);l>=0&&(i=a+l)}return i}function setLastClicked(e,t){if(t>=0){const i=getRowOffset(e,t);if(null!==i)return e.lastClicked.rowId=t,void(e.lastClicked.offset=i)}e.lastClicked.rowId=-1,e.lastClicked.offset=0}function loadRange(e,t,i,s,n){startLoading(e);const a=shmi.requires("visuals.session.DataGridManager"),l=a.subscribePage(e.cConfig.table,i,s,i=>{a.getCurrentIDs(e.cConfig.table,l.id).forEach(t=>{e.addRowIdToSelection(t)}),a.unsubscribe(e.cConfig.table,l.id),setLastClicked(e,t),stopLoading(e),e.updateSelTypeFromSelRows(),e.updateDelRowsBtnEnable(),e.updateSelectionView(),clearTimeout(e.sel_fire_to);const s=shmi.cloneObject(e.selection);e.sel_fire_to=setTimeout((function(){e.fireSelChanged(s)}),shmi.c("ACTION_RETRY_TIMEOUT")),n()})}function createTableRow(e,t,i,s){var n=e.cConfig.resp["nof-cols"],a=null,l=null,o="MULTI"===e.cConfig.resp["select-mode"],r="SINGLE"===e.cConfig.resp["select-mode"],c="ITEM"===e.cConfig.resp["select-mode"],u=null,h=e.pageBuf.rows[t];if(h){a=document.createElement("tr"),null===h.rowId&&(a.style.visibility="hidden",h.visible=!1),i.appendChild(a),h.trElem=a,(e.pageBuf.offset+t)%2==0&&shmi.addClass(a,e.uiCssCl.evenRow),o?(e.config["show-select-boxes"]&&(l=document.createElement("td"),u=document.createElement("div"),h.selCB=e.createSelCBox(u,t,!1,e),h.selCB.setChangeCallback((function(t,i){e.locked||e.selectCBoxValChanged(t,i,!1,!1,!0)})),l.appendChild(u),a.appendChild(l)),h.trSelCtrl=e.createSelRowCtrl(a,t,e),h.trSelCtrl.setChangeCallback((function(t,i,s,n){e.locked||e.selectCBoxValChanged(t,i,s,n,!1)}))):(r||c)&&(h.trSelCtrl=e.createSelRowCtrl(a,t,e),h.trSelCtrl.setChangeCallback((function(t,i,s,n){e.locked||e.selectRowValChanged(t,i,s,n)})));for(var m=0;m<n;m++)createTableCell(e,t,m,a,s)}else console.error("[ComplexTable2]","missing row descriptor for row ID:",t)}function createTableCell(e,t,i,s,n){var a=e.cConfig.resp["column-org"][i],l=document.createElement("div"),o=document.createElement("td"),r=a.fields.length;o.appendChild(l),s.appendChild(o),shmi.addClass(l,e.uiCssCl.tdCont),n&&a.fields[0]["min-width"]&&(l.style.minWidth=a.fields[0]["min-width"]);for(var c=0;c<r;c++)createCellControl(e,t,i,c,a,l)}function createCellControl(e,t,i,s,n,a){var l,o=shmi.cloneObject(n.fields[s].ctrl.config),r=e.pageBuf.rows[t],c=null===r.rowId?null:e.makeItem(r.rowId,n.fields[s].dgCol),u=shmi.requires("visuals.tools.item-adapter"),h=e.getColumnAdapter(n.fields[s].fieldName);o.item=c,l=shmi.createControl(n.fields[s].ctrl["ui-type"],a,o,"div"),null!==c&&(null===h?u.unsetAdapter(c):u.setAdapter(c,h)),r.cols[i].ctrls.push(l)}function createRowDescriptor(e,t){for(var i={rowId:e,trElem:null,trSelCtrl:null,selCB:null,cols:[],visible:!0},s=0;s<t;s++)i.cols.push({ctrls:[]});return i}function onQuickSearch(e,t){e.qSearchInterval=e.qSearchInterval||null,null===e.qSearchInterval&&(e.qSearchInterval=setTimeout((function(){t.textContent!==e.qSearchOld&&e.quicksearchChanged(t.textContent),e.qSearchOld=t.textContent,e.qSearchInterval=null}),300))}function setPagePositions(e){var t=[e.tbodyElement[0],e.tbodyElement[1],e.tbodyElement[2]],i=e.cConfig["nof-buffered-rows"]/3,s=e.metricsData.lineHeightPx*i;e.vars.pageOrder.forEach((function(i){!function setElementOffset(e,t){e.style.top=t+"px"}(t[i],e.vars.pageOffsets[i]*s)}))}function reinitPages(e,t){var i=e.metricsData.lineHeightPx,s=e.pageBuf.nofTotalRows*i,n=e.cConfig["nof-buffered-rows"]/3,a=e.metricsData.lineHeightPx*n,l=Math.ceil(s/a),o=t/a,r=Math.floor(o);e.vars.pageOffsets=r>=1&&l>3?[r-1,r,r+1]:[0,1,2],e.vars.pageOrder=[0,1,2],setPagePositions(e)}function turnPage(e,t=!1){const i=e.vars.pageOffsets[t?e.vars.pageOrder[0]:e.vars.pageOrder[2]];t?e.vars.pageOrder.unshift(e.vars.pageOrder.pop()):e.vars.pageOrder.push(e.vars.pageOrder.shift()),e.vars.pageOffsets[e.vars.pageOrder[0]]=i-1,e.vars.pageOffsets[e.vars.pageOrder[1]]=i,e.vars.pageOffsets[e.vars.pageOrder[2]]=i+1,setPagePositions(e)}function updatePages(e,s){var n,a=e.metricsData.lineHeightPx,l=e.pageBuf.nofTotalRows*a,o=e.cConfig["nof-buffered-rows"]/3,r=e.metricsData.viewportHeight,c=a*o,u=Math.ceil(l/c),h=s,m=h+r,d=s-e.vars.scrollTop,f=Math.sign(d),v=null,g=null,p=e.pageBuf.offset,b=e.pageBuf.bufferOffset,y=null,E=!1;u>3&&Math.abs(d)<c/2?f===t?(v=(g=e.vars.pageOffsets[e.vars.pageOrder[0]]*c)+c/2,g>0&&h<v&&turnPage(e,!0)):f===i&&(v=(g=e.vars.pageOffsets[e.vars.pageOrder[2]]*c)+c/2,g>0&&m>v&&turnPage(e,!1)):(u>3||e.vars.pageOffsets.some(e=>e>2))&&(y=e.vars.pageOrder.toString(),reinitPages(e,s),E=!0),n=Math.floor(e.vars.pageOffsets[e.vars.pageOrder[0]]*c/a),e.vars.scrollTop=s,n!==p?(e.pageBuf.offset=n,e.pageBuf.bufferOffset=function calcBufferOffset(e){var t=e.pageBuf.bufferOffset;e.pageBuf.offset<e.pageBuf.bufferOffset?t=Math.max(0,e.pageBuf.offset+e.pageBuf.viewportSize-e.pageBuf.bufferSize):e.pageBuf.offset+e.pageBuf.viewportSize>e.pageBuf.bufferOffset+e.pageBuf.bufferSize&&(t=e.pageBuf.offset);return t}(e),b!==e.pageBuf.bufferOffset?(startLoading(e),e.dgMan.setOffset(e.cConfig.table,e.pageBuf.bufferOffset,e.dgSubscription.id)):e.onDataGridChange(e.dgSubscription.changeInfo)):E&&y!==e.vars.pageOrder.toString()&&e.onDataGridChange(e.dgSubscription.changeInfo)}function applyLineHeight(e){var t=null;e.cConfig.resp["line-height"]&&(e.styleSheet||(t=document.createElement("style"),e.styleSheet=t),e.styleSheet.innerHTML="#"+e.tableId+" .ct2-tdcont { height: "+e.cConfig.resp["line-height"]+"; }",t&&e.element.insertBefore(e.styleSheet,e.element.firstChild))}function startLoading(e){e.loadingCount+=1,1===e.loadingCount&&shmi.addClass(e.element,"loading")}function stopLoading(e){e.loadingCount-=1,e.loadingCount<=0&&(e.loadingCount=0,shmi.removeClass(e.element,"loading"))}shmi.visuals.controls.ComplexTable2=function(e,t){for(this.instID=Date.now();-1!==shmi.visuals.controls.ComplexTable2.instIDs.indexOf(this.instID);)this.instID++;shmi.visuals.controls.ComplexTable2.instIDs.push(this.instID),this.c=shmi.visuals.controls.ComplexTable2.c,this.uiElName=shmi.visuals.controls.ComplexTable2.uiElName,this.uiCssCl=shmi.visuals.controls.ComplexTable2.uiCssCl,this.element=e,this.config=t||{},this.loadingCount=0,this.lastClicked={rowId:null,offset:0},this.parseAttributes(),shmi.def(this.config,"class-name","complex-table2"),shmi.def(this.config,"template","default/complex-table2"),shmi.def(this.config,"name",null),shmi.def(this.config,"label","complex-table2"),shmi.def(this.config,"table","undefined-table"),shmi.def(this.config,"item-selected-row",null),shmi.def(this.config,"rows-items-from-1",!0),shmi.def(this.config,"field-datagrid-col-map",[]),shmi.def(this.config,"default-field-control-map",{}),shmi.def(this.config,"default-field-headers",{}),shmi.def(this.config,"default-layout",{}),shmi.def(this.config,"select-mode","MULTI"),shmi.def(this.config,"show-select-boxes",!0),shmi.def(this.config,"text-mode","NORMAL"),shmi.def(this.config,"show-nof-rows",!1),shmi.def(this.config,"delete-selected-rows",!1),shmi.def(this.config,"useDgIndex",!1),shmi.def(this.config,"col-width-changeable",!1),shmi.def(this.config,"cols-show-hide",!1),shmi.def(this.config,"cols-movable",!1),shmi.def(this.config,"rows-movable",!1),shmi.def(this.config,"sortable-fields",[]),shmi.def(this.config,"default-text-filter-fields",[]),shmi.def(this.config,"filters",[]),shmi.def(this.config,"default-nof-buffered-rows",this.c.MIN_BUF_SIZE),shmi.def(this.config,"show-buttons-table-min-width-px",300),shmi.def(this.config,"edit-mode-active",!1),shmi.def(this.config,"fieldIcons",{}),shmi.def(this.config,"headerMode","ICON"),shmi.def(this.config,"adapterSelectConfig",{"class-name":"select-box no-label"}),shmi.def(this.config,"adapterSelectClass","adapter-select"),shmi.def(this.config,"edit-mode-map",{}),this.cConfig={},this.filterData={},this.colTextFilterData={},this.ctrlPanelData={},this.header={},this.colTxtFilters={},this.pageBuf={},this.asyncProcData={},this.metricsData={},this.selection={type:this.c.SELECT_TYPE_NOTHING,selRows:[],selRowIndex:[]},this.lastSelection=null,this.scrollBar=null,this.dgMan=null,this.dgSubscription={},this.selChgEventListeners={},this.tcElement=null,this.bodyViewportElement=null,this.tabCCElement=null,this.tabHCElement=null,this.theadElement=null,this.txtFiltersHeadElement=null,this.tbodyElement=[],this.labelElement=null,this.footerElement=null,this.ctrlPanelElement=null,this.resizeDebounceTimeout=null,this.sbSliderDebounceTimeout=null,this.vpReleaseDebounceTimeout=null,this.swipeVertDebounceTimeout=null,this.cLayoutClass=null,this.isTableToCleanup=!1,this.isTouchDevice=!1,this.lastTableVpWidth=-1,this.lastTableVpHeight=-1,this.lastLayoutId=-100,this.applyFiltersEnable=!1,this.subscrIdItemSelRow=null,this.selRowByItem=0,this.editMode=!1,this.editRow=-1,this.headerMode="TEXT",this.controls=[],this.vars={lastUpdate:0,updateTimeout:0,scrollTop:0,pageOffsets:[0,1,2],pageOrder:[0,1,2]},this.startup()},shmi.visuals.controls.ComplexTable2.prototype={_tableIds:{},uiType:"complex-table2",isContainer:!0,events:["select"],getClassName:function(){return"ComplexTable2"},setEditMode:function(e){this.editMode=e},getSelectedRows:function(){return shmi.cloneObject(this.selection)},getSelectionRowData:function(e){var t=this,i=[];return e&&e.selRows.length>0&&(i=e.selRows.map(e=>t.dgMan.getRowData(t.config.table,e))),i},setSelectedRows:function(e){shmi.checkArg("selection",e,"object"),shmi.checkArg("selection.type",e.type,"number"),shmi.checkArg("selection.selRows",e.selRows,"array"),shmi.checkArg("selection.selRowIndex",e.selRowIndex,"array"),this.selection=shmi.cloneObject(e),this.updateSelectionView();var t=this;clearTimeout(t.sel_fire_to),t.sel_fire_to=setTimeout((function(){t.fireSelChanged(shmi.cloneObject(t.selection))}),shmi.c("ACTION_RETRY_TIMEOUT"))},addSelChgEventListener:function(e){for(var t=Date.now();void 0!==this.selChgEventListeners[t];)t++;return this.selChgEventListeners[t]={listener:e},shmi.log("[ComplexTable2] addSelChgEventListener called, listenerObj: "+e+" - id:"+t,1),t},removeSelChgEventListener:function(e){void 0!==this.selChgEventListeners[e]?delete this.selChgEventListeners[e]:shmi.log("[ComplexTable2] removeSelChgEventListener - id "+e+" does not exist",2),shmi.log("[ComplexTable2] removeSelChgEventListener called, id: "+e,1)},onInit:function(){var e=this,t=0;if(e.headerMode="ICON"===e.config.headerMode?"ICON":"TEXT",e.tableId=function getTableId(e){for(var t=0;void 0!==shmi.visuals.controls.ComplexTable2.prototype._tableIds["ct2-instance-"+t];)t+=1;return shmi.visuals.controls.ComplexTable2.prototype._tableIds["ct2-instance-"+t]=!0,"ct2-instance-"+t}(),e.element.setAttribute("id",e.tableId),!0===shmi.toBoolean(e.config["edit-mode-active"])&&(e.editMode=!0),this.isTouchDevice=this.detectTouchDevice(),this.isTouchDevice?shmi.addClass(this.element,this.uiCssCl.touchDev):shmi.addClass(this.element,this.uiCssCl.noTouchDev),this.buildCCfgRespIndep(),this.buildCCfgRespDep(),this.dgMan=shmi.visuals.session.DataGridManager,this.tcElement=shmi.getUiElement(this.uiElName.tabContainer,this.element),this.tcElement)if(this.theadElement=shmi.getUiElement(this.uiElName.thead,this.element),this.theadElement)if(this.txtFiltersHeadElement=shmi.getUiElement(this.uiElName.txtFiltersHead,this.element),this.txtFiltersHeadElement||shmi.log("[ComplexTable2] no "+this.uiElName.txtFiltersHead+" element provided (optional)",1),this.tableElement=shmi.getUiElement(this.uiElName.table,this.element),this.tableElement){var i=shmi.getUiElements(this.uiElName.tbody,this.element);for(this.tbodyElement=[],t=0;t<i.length;t++)this.tbodyElement.push(i[t]);if(this.tbodyElement[0])if(this.bodyViewportElement=shmi.getUiElement(this.uiElName.tbodyContainer,this.element),this.bodyViewportElement)if(this.tabCCElement=shmi.getUiElement(this.uiElName.tabContContainer,this.element),this.tabCCElement){var s;if(this.labelElement=shmi.getUiElement(this.uiElName.label,this.element),this.labelElement?this.labelElement.textContent=shmi.localize(this.cConfig.label):shmi.log("[ComplexTable2] no "+this.uiElName.label+" element provided (optional)",1),this.footerElement=shmi.getUiElement(this.uiElName.footer,this.element),this.footerElement||shmi.log("[ComplexTable2] no "+this.uiElName.footer+" element provided (optional)",1),this.ctrlPanelElement=shmi.getUiElement(this.uiElName.ctrlPanel,this.element),this.ctrlPanelElement||shmi.log("[ComplexTable2] no "+this.uiElName.ctrlPanelElement+" element provided (optional)",1),this.initScrollHandler(),this.updateSize=function(){clearTimeout(this.resizeDebounceTimeout),this.resizeDebounceTimeout=setTimeout(function(){this.resizeDebounceTimeout=null,this.processEvtOnResize()}.bind(this),this.c.DEBOUNCE_TO_RESIZE)}.bind(this),applyLineHeight(e),this.cleanupTabContent(),this.cleanupAsyncProcessing(),this.clearSelection(),this.clearFilterData(),this.clearColTextFilterData(),this.isTabSizeChanged(),this.isLayoutChanged(),shmi.log("[ComplexTable2] initialized",1),e=this,shmi.isRegistered(this.element,this.uiType))for(s=shmi.parseControls(this.tcElement,!1,this.element),t=0;t<s.length;t++)e.controls.push(s[t]);else var n=this.listen("register",(function(){for(s=shmi.parseControls(e.tcElement,!1,e.element),t=0;t<s.length;t++)e.controls.push(s[t]);e.unlisten("register",n)}));e.adapterItems=[],shmi.requires("visuals.tools.iterate.iterateObject")(e.config.adapterSettings,(function(t,i){var s={field:i,item:null,gridName:e.config.table,options:t},n="virtual:"+e.getAdapterNS()+":"+i;s.item=shmi.createVirtualItem(n,shmi.c("TYPE_INT"),0,1e3,0,e._getAdapterHandler(e,s)),e.adapterItems.push(s)}))}else shmi.log("[ComplexTable2] no "+this.uiElName.tabContContainer+" element provided (required)",3);else shmi.log("[ComplexTable2] no "+this.uiElName.tbodyContainer+" element provided (required)",3);else shmi.log("[ComplexTable2] no "+this.uiElName.tbody+" element provided (required)",3)}else shmi.log("[ComplexTable2] no "+this.uiElName.table+" element provided (required)",3);else shmi.log("[ComplexTable2] no "+this.uiElName.thead+" element provided (required)",3);else shmi.log("[ComplexTable2] no "+this.uiElName.tabContainer+" element provided (required)",3)},_getAdapterHandler:function(e,t){return function(i){var s=null,n=shmi.visuals.session.ItemManager,a=shmi.requires("visuals.tools.item-adapter"),l=[],o=shmi.requires("visuals.tools.iterate.iterateObject"),r=e.getDataColNo(t.field);t.options.forEach((function(e,t){e.value===i&&(s=e.adapter)})),o(n.items,(function(e,i){if(0===i.indexOf("virtual:grid:"+t.gridName)){var s=i.split(":");parseInt(s[4])===r&&l.push(e)}})),null===s?l.forEach((function(e,t){a.unsetAdapter(e.name)})):l.forEach((function(e,t){a.setAdapter(e.name,s)}))}},onEnable:function(){const e=this;let t=null,i=!1;this.enableEvents(),this.updateRespDepContent(!0),this.cleanupMetrics(),this.cConfig.table&&(t=this.dgMan.getGrid(this.cConfig.table),t&&(t.clearFilter(-1),e.cConfig.quicksearch&&e.cConfig.quicksearch.enable&&e.cConfig.quicksearch.remember&&"string"==typeof e.qSearchOld&&(e.ctrlPanelData.qSearchInput.setValue(e.qSearchOld),e.quicksearchChanged(e.qSearchOld)))),this.setApplyFiltersEnable(!0),this.cConfig.table&&this.dgMan.getGrid(this.cConfig.table)&&(startLoading(e),this.dgSubscription=this.dgMan.subscribePage(this.cConfig.table,0,this.cConfig["buffer-size"],t=>{stopLoading(e),this.testlog&&console.log("***** datagridChange",t),this.dgSubscription.changeInfo=t,this.onDataGridChange(t),i||(i=!0,e.processEvtOnResize())}),this.checkDgIndexFields(),this.cConfig["item-selected-row"]&&"undefined-item"!==this.cConfig["item-selected-row"]&&(this.selRowByItem=0,this.subscrIdItemSelRow=shmi.visuals.session.ItemManager.subscribeItem(this.cConfig["item-selected-row"],this))),window.addEventListener("resize",this.updateSize,!0),window.addEventListener("visuals-layout-change",this.updateSize,!0),this.controls.forEach((function(e){e.enable()})),shmi.log("[ComplexTable2] enabled",1)},resetQuickSearch:function(){this.cConfig.quicksearch&&this.cConfig.quicksearch.enable&&(this.qSearchOld=null,this.isActive()&&(this.ctrlPanelData.qSearchInput.setValue(""),this.quicksearchChanged("")))},setQuickSearch:function(e){var t=e;this.cConfig.quicksearch&&this.cConfig.quicksearch.enable&&(null==t?t="":"string"!=typeof t&&(t=String(t)),this.isActive()&&this.qSearchOld!==t&&(this.ctrlPanelData.qSearchInput.setValue(t),this.quicksearchChanged(t)))},onDisable:function(){this.pageBuf.rows&&this.pageBuf.rows.forEach((function(e,t){e.trSelCtrl&&e.trSelCtrl.rsMouseListener&&(e.trSelCtrl.rsMouseListener.disable(),e.trSelCtrl.rsTouchListener.disable()),e.selCB&&e.selCB.cbMouseListener&&(e.selCB.cbMouseListener.disable(),e.selCB.cbTouchListener.disable())})),this.cleanupAsyncProcessing(),this.dgSubscription&&(this.dgMan.unsubscribe(this.cConfig.table,this.dgSubscription.id),this.dgSubscription=null),this.disableEvents(),this.cleanupTabContent(),this.subscrIdItemSelRow&&shmi.visuals.session.ItemManager.unsubscribeItem(this.cConfig["item-selected-row"],this.subscrIdItemSelRow),this.quicksearchHandler&&this.quicksearchValueElement&&(this.quicksearchValueElement.removeEventListener("keyup",this.quicksearchHandler),this.vars.qSearchToken&&this.vars.qSearchToken.unlisten(),this.quicksearchValueElement=null,this.quicksearchHandler=null),this.cConfig.quicksearch&&this.cConfig.quicksearch.enable&&this.cConfig.quicksearch.remember||(this.qSearchOld=null),this.selection={type:this.c.SELECT_TYPE_NOTHING,selRows:[],selRowIndex:[]},this.lastSelection=null,setLastClicked(this,-1),window.removeEventListener("resize",this.updateSize,!0),window.removeEventListener("visuals-layout-change",this.updateSize,!0),shmi.log("[ComplexTable2] disabled",1)},onDelete:function(){this.header.cols&&this.header.cols.forEach((function(e,t){e.ctrls[0].cbMouseListener&&(e.ctrls[0].cbMouseListener.disable(),e.ctrls[0].cbTouchListener.disable())})),this.ctrlPanelData.filter&&this.ctrlPanelData.filter.items.forEach((function(e,t){shmi.visuals.session.ItemManager.removeItem(e.name)})),this.onBodyScroll&&this.bodyViewportElement&&this.bodyViewportElement.removeEventListener("scroll",this.onBodyScroll),function releaseTableId(e,t){delete shmi.visuals.controls.ComplexTable2.prototype._tableIds[t]}(0,this.tableId),this.element.removeAttribute("id")},onDataGridChange:function(e){if(e&&"OK"===e.status){this.isTableToCleanup&&(this.cleanupTabContent(),this.isTableToCleanup=!1);var t=this.dgMan.getCurrentIDs(this.cConfig.table,this.dgSubscription.id);this.pageBuf.rows.length===this.pageBuf.viewportSize?t.length<=this.pageBuf.bufferSize&&e.offset===this.pageBuf.bufferOffset?(this.pageBuf.size=t.length,this.pageBuf.nofTotalRows!==e.totalRows&&(this.pageBuf.nofTotalRows=e.totalRows,this.tableElement.style.height=this.pageBuf.nofTotalRows*this.metricsData.lineHeightPx+"px"),this.updateTable(e,t)):(this.cleanupTabContent(),this.reinitTable(e,t,!0)):(this.cleanupTabContent(),this.reinitTable(e,t)),this.findSelectionAfterRefresh(),this.updateNofRowsDisplay(),this.updateSelectionView()}},onSetValue:function(e,t,i){var s=-1;i===this.cConfig["item-selected-row"]&&(-1!==e&&(s=this.cConfig["rows-items-from-1"]?e-1:e),this.selRowByItem=s,this.updateSelectionView())},buildCCfgRespIndep:function(){if(this.cConfig.name=this.config.name,this.cConfig.label=this.config.label,this.cConfig["class-name"]=this.config["class-name"],this.cConfig.template=this.config.template,this.cConfig.table=this.config.table,this.cConfig["item-selected-row"]=this.config["item-selected-row"],this.cConfig["rows-items-from-1"]=this.config["rows-items-from-1"],this.config["field-datagrid-col-map"]?this.cConfig["field-datagrid-col-map"]=this.config["field-datagrid-col-map"]:this.cConfig["field-datagrid-col-map"]=null,this.cConfig["delete-selected-rows"]=shmi.toBoolean(this.config["delete-selected-rows"]),this.cConfig.filters=this.config.filters,this.cConfig.quicksearch=this.config.quicksearch,this.cConfig["nof-buffered-rows"]=shmi.toNumber(this.config["default-nof-buffered-rows"]),this.config["buffer-size"]&&this.config["buffer-size"]>this.c.MIN_BUF_SIZE?this.cConfig["buffer-size"]=this.config["buffer-size"]:this.cConfig["buffer-size"]=this.c.MIN_BUF_SIZE,this.config["delete-selected-rows-button-config"]&&(this.cConfig["delete-selected-rows-button-config"]=this.config["delete-selected-rows-button-config"]),this.config["default-filter-button-config"]&&(this.cConfig["default-filter-button-config"]=this.config["default-filter-button-config"]),this.config["browser-dependencies"])for(var e=this.config["browser-dependencies"],t=navigator.userAgent,i=0;i<e.length;i++){if(new RegExp(e[i].userAgentDetectRegEx).test(t)){e[i]["nof-buffered-rows"]&&(this.cConfig["nof-buffered-rows"]=shmi.toNumber(e[i]["nof-buffered-rows"]));break}}this.cConfig["show-buttons-table-min-width-px"]=shmi.toNumber(this.config["show-buttons-table-min-width-px"]);var s=this.cConfig["nof-buffered-rows"],n=0;s%3!=0&&(n=3*Math.ceil(s/3),this.cConfig["nof-buffered-rows"]=n,this.cConfig["nof-buffered-rows"]>this.cConfig["buffer-size"]&&(this.cConfig["buffer-size"]=this.cConfig["nof-buffered-rows"]),console.info("[ComplexTable2] nof-buffered-rows must be a multiple of 3, has been corrected to "+n))},buildCCfgRespDep:function(){const e=shmi.requires("visuals.tools.iterate.iterateObject");var t;this.cConfig.resp={},this.cConfig.resp["v-scroll-options"]=this.config["v-scroll-options"],this.cConfig.resp["h-scroll-options"]=this.config["h-scroll-options"],this.cConfig["item-selected-row"]&&"undefined-item"!==this.cConfig["item-selected-row"]?this.cConfig.resp["select-mode"]="ITEM":this.cConfig.resp["select-mode"]=this.config["select-mode"],this.cConfig.resp["text-mode"]=this.config["text-mode"],this.cConfig.resp["show-nof-rows"]=this.config["show-nof-rows"],this.cConfig.resp["col-width-changeable"]=this.config["col-width-changeable"],this.cConfig.resp["cols-show-hide"]=this.config["cols-show-hide"],this.cConfig.resp["cols-movable"]=this.config["cols-movable"],this.cConfig.resp["rows-movable"]=this.config["rows-movable"],this.cConfig.resp["sortable-fields"]=this.config["sortable-fields"],this.cConfig.resp["text-filter-fields"]=this.config["default-text-filter-fields"],this.cConfig.quicksearch&&this.cConfig.quicksearch.enable&&(this.cConfig.resp["text-filter-fields"]=this.cConfig.quicksearch.fields),this.config["default-text-filter-input-field-config"]&&(this.cConfig.resp["text-filter-input-field-config"]=this.config["default-text-filter-input-field-config"]),this.config["default-text-filter-clear-button-config"]&&(this.cConfig.resp["text-filter-clear-button-config"]=this.config["default-text-filter-clear-button-config"]);var i=this.config["default-layout"];i["class-name"]?this.cConfig.resp["layout-class-name"]=i["class-name"]:this.cConfig.resp["layout-class-name"]=null,i["line-height"]?this.cConfig.resp["line-height"]=i["line-height"]:this.cConfig.resp["line-height"]="40px",this.cConfig.resp["column-org"]=[];var s,n=i["column-org"],a=this.cConfig.resp["column-org"],l=0;e(n,(e,i)=>{if("col"===i.substr(0,3).toLowerCase()){s=parseInt(i.substring(3))-1;const n=a[s]={},o=e.fields,r=o.length;let c=!1;for(n.fields=[],t=0;t<r;t++)n.fields[t]={},n.fields[t]["min-width"]=e["min-width"],n.fields[t]["column-width"]=e["column-width"],n.fields[t].fieldName=o[t],n.fields[t].dgCol=this.getDataColNo(o[t]),n.fields[t].header=this.getHeaderCaption(o[t]),n.fields[t].icon=this.config.fieldIcons[o[t]],n.fields[t].isSortable=this.getFldSortable(o[t]),n.fields[t].hasTextFilter=this.getFldHasTextFilter(o[t]),n.fields[t].hasTextFilter&&(c=!0),n.fields[t].ctrl=this.getCtrlDef(o[t]);n.hasTextFilter=c,l++}});var o=a.length;if(this.cConfig.resp["nof-cols"]=o,o!==l&&shmi.log("[ComplexTable2] buildCCfgRespDep - error in default-layout: there must be defined col1 till coln without gaps and duplicates",3),this.cConfig.resp["layout-id"]=-1,this.config["responsive-layouts"]){var r=null,c=this.getTableWidth(),u=this.config["responsive-layouts"],h=u.length;for(t=0;t<h;t++)if(c<=u[t]["table-max-width-px"]){r=u[t],this.cConfig.resp["layout-id"]=t;break}r&&("ICON"===r.headerMode?this.cConfig.resp.headerMode="ICON":this.cConfig.resp.headerMode="TEXT",r["line-height"]&&(this.cConfig.resp["line-height"]=r["line-height"]),void 0!==r["v-scroll-options"]&&(this.cConfig.resp["v-scroll-options"]=r["v-scroll-options"]),void 0!==r["h-scroll-options"]&&(this.cConfig.resp["h-scroll-options"]=r["h-scroll-options"]),void 0!==r["select-mode"]&&(this.cConfig.resp["select-mode"]=r["select-mode"]),void 0!==r["text-mode"]&&(this.cConfig.resp["text-mode"]=r["text-mode"]),void 0!==r["show-nof-rows"]&&(this.cConfig.resp["show-nof-rows"]=r["show-nof-rows"]),void 0!==r["col-width-changeable"]&&(this.cConfig.resp["col-width-changeable"]=r["col-width-changeable"]),void 0!==r["cols-show-hide"]&&(this.cConfig.resp["cols-show-hide"]=r["cols-show-hide"]),void 0!==r["cols-movable"]&&(this.cConfig.resp["cols-movable"]=r["cols-movable"]),void 0!==r["rows-movable"]&&(this.cConfig.resp["rows-movable"]=r["rows-movable"]),void 0!==r["sortable-fields"]&&(this.cConfig.resp["sortable-fields"]=r["sortable-fields"]),void 0!==r["class-name"]&&(this.cConfig.resp["layout-class-name"]=r["class-name"]),void 0!==r["text-filter-fields"]&&(this.cConfig.resp["text-filter-fields"]=r["text-filter-fields"]),void 0!==r["text-filter-input-field-config"]&&(this.cConfig.resp["text-filter-input-field-config"]=r["text-filter-input-field-config"]),void 0!==r["text-filter-clear-button-config"]&&(this.cConfig.resp["text-filter-clear-button-config"]=r["text-filter-input-field-config"]),n=r["column-org"],a=this.cConfig.resp["column-org"],e(n,(e,i)=>{if("col"===i.substr(0,3).toLowerCase())if(s=parseInt(i.substring(3))-1,"string"==typeof(e=n[i])||e instanceof String){var l=parseInt(e.substring(3))-1;a[s]=a[l]}else{const i=a[s]={},n=e.fields,l=n.length;let c=!1;for(i.fields=[],t=0;t<l;t++){i.fields[t]={},i.fields[t].fieldName=n[t],i.fields[t].dgCol=this.getDataColNo(n[t]);var o=null;e["field-headers"]&&(o=e["field-headers"]),i.fields[t].header=this.getHeaderCaption(n[t],o),i.fields[t].icon=this.config.fieldIcons[n[t]],i.fields[t].isSortable=this.getFldSortable(n[t]),i.fields[t].hasTextFilter=this.getFldHasTextFilter(n[t]),i.fields[t].hasTextFilter&&(c=!0);var r=null;e["field-control-map"]&&(r=e["field-control-map"]),i.fields[t].ctrl=this.getCtrlDef(n[t],r)}i.hasTextFilter=c}}),(o=s+1)<a.length?(a.splice(o,a.length-o),this.cConfig.resp["nof-cols"]=o):o>this.cConfig.resp["nof-cols"]&&shmi.log("[ComplexTable2] buildCCfgRespDep, it is impossible to extent the number of columns in responsive-layouts",3))}},checkDgIndexFields:function(){var e=this.dgMan.getGrid(this.cConfig.table);e&&"function"==typeof e.getIndexFields?(this.cConfig.indexFields=e.getIndexFields(),this.cConfig.indexFields.length>0&&(this.cConfig.useDgIndex=!0)):shmi.log("[ComplexTable2] No index found in datagrid",1)},getDataColNo:function(e){var t=this.cConfig["field-datagrid-col-map"][e];return void 0===t?(t=0,shmi.log("[ComplexTable2] getDataColNo, unknown fldName "+e,3)):t=shmi.toNumber(t),t},getFldSortable:function(e){var t=!1;return-1!==this.cConfig.resp["sortable-fields"].indexOf(e)&&(t=!0),t},getFldHasTextFilter:function(e){var t=!1;return-1!==this.cConfig.resp["text-filter-fields"].indexOf(e)&&(t=!0),t},getCtrlDef:function(e,t){var i;return t&&(i=t[e])||(i=this.config["default-field-control-map"][e]),i||(i={},shmi.log("[ComplexTable2] getCtrlDef, unknown fldName "+e,3)),i},getHeaderCaption:function(e,t){var i;if(t){if(null===(i=t[e]))return null;i||(i=this.config["default-field-headers"][e])}else i=this.config["default-field-headers"][e];return i||(i="",shmi.log("[ComplexTable2] getHeaderCaption, unknown fldName "+e,3)),i},getColumnAdapter:function(e){var t=null;if(this.config.adapterSettings&&void 0!==this.config.adapterSettings[e]){var i=this.config.adapterSettings[e],s=null;this.adapterItems.forEach((function(t,i){t.field===e&&(s=t.item.readValue())})),i.forEach((function(e,i){s===e.value&&(t=e.adapter)}))}return t},getChildCtrlConfig:function(e,t){var i=null;return e?i=shmi.cloneObject(e):t&&(i=shmi.cloneObject(t)),i},processAsyncMetricsUpdate:function(e){var t=this,i=shmi.requires("visuals.task"),s=[],n=null;t.controls.forEach((function(e,t){if(!e.isActive()){var n=i.createTask("table-control-#"+(t+1));n.run=function(){var t=e.listen("enable",(function(e){t.unlisten(),n.complete()}))},s.push(n)}})),(n=i.createTaskList(s,!1)).onComplete=function(){var i=0;t.active&&(t.updateMetricsData(e),t.processTabReinitDependencies(),"number"==typeof e&&((i=t.tableElement.getBoundingClientRect().height)>=e+t.metricsData.viewportHeight?t.bodyViewportElement.scrollTop=e:t.bodyViewportElement.scrollTop=Math.max(0,i-t.metricsData.viewportHeight)))},0===s.length?n.onComplete():n.run()},processEvtOnResize:function(){this.initialized&&(this.buildCCfgRespDep(),applyLineHeight(this),this.isTabSizeChanged()&&(this.currentScrollEvtType=this.c.SCROLL_EVT_TYPE_RESIZE,this.cleanupTabContent(),this.cleanupAsyncProcessing(),this.findSelectionAfterRefresh(),this.clearFilterData(),this.clearColTextFilterData(),this.updateRespDepContent(!0),this.cleanupMetrics(),this.dgSubscription&&this.dgSubscription.changeInfo&&(this.cleanupTabContent(),this.reinitTable(this.dgSubscription.changeInfo,this.dgMan.getCurrentIDs(this.cConfig.table,this.dgSubscription.id)))))},clearSelection:function(){var e=this;this.selection.type=this.c.SELECT_TYPE_NOTHING,this.selection.selRows=[],this.selection.selRowIndex=[],this.updateDelRowsBtnEnable(),-1!==e.editRow&&(e.resetBufferRow(e.editRow),e.editRow=-1),clearTimeout(e.sel_fire_to),e.sel_fire_to=setTimeout((function(){e.fireSelChanged(shmi.cloneObject(e.selection))}),shmi.c("ACTION_RETRY_TIMEOUT"))},findSelectionAfterRefresh:function(){const e=this,t=e.dgMan.getGrid(e.cConfig.table);if(t&&this.cConfig.useDgIndex){if(this.selection.type===this.c.SELECT_TYPE_SEL_ROWS){const i=shmi.cloneObject(this.selection);i.selRowIndex.forEach((function(s,n){const a=t.searchIndexRowId(s);if(-1===a)e.removeRowIdFromSelection(i.selRows[n]);else if(a!==i.selRows[n]){const t=e.selection.selRows.indexOf(i.selRows[n]);t>-1&&(e.selection.selRows[t]=a)}}))}this.selection&&this.selection.selRows.length>0?this.selection.type=this.c.SELECT_TYPE_SEL_ROWS:this.selection.type=this.c.SELECT_TYPE_NOTHING,this.updateDelRowsBtnEnable(),-1!==e.editRow&&(e.resetBufferRow(e.editRow),e.editRow=-1),clearTimeout(e.sel_fire_to),e.sel_fire_to=setTimeout((function(){e.fireSelChanged(shmi.cloneObject(e.selection))}),shmi.c("ACTION_RETRY_TIMEOUT"))}else this.clearSelection()},updateSelectionView:function(){this.testlog&&console.log("*** update selection view",this.selection.selRows,this.selection.selRowIndex.toString());var e="MULTI"===this.cConfig.resp["select-mode"],t="SINGLE"===this.cConfig.resp["select-mode"];if("ITEM"===this.cConfig.resp["select-mode"])this.setAllRowSelectors(this.c.CB_UNCHK),this.setRowSelectorByDgRow(this.selRowByItem,this.c.CB_CHK);else switch(this.selection.type){case this.c.SELECT_TYPE_NOTHING:e?(this.setAllCheckBoxes(this.c.CB_UNCHK),this.setAllRowSelectors(this.c.CB_UNCHK)):t&&this.setAllRowSelectors(this.c.CB_UNCHK);break;case this.c.SELECT_TYPE_ALL:e?(this.setAllCheckBoxes(this.c.CB_CHK),this.setAllRowSelectors(this.c.CB_CHK)):shmi.log("[ComplexTable2] updateSelectionView, it is impossible to select all rows in single select mode",2);break;default:if(e){this.setAllCheckBoxes(this.c.CB_UNCHK),this.setAllRowSelectors(this.c.CB_UNCHK),this.header.selAllCBox&&this.header.selAllCBox.setState(this.c.CB_UNDEF);for(var i=this.dgMan.getCurrentIDs(this.cConfig.table,this.dgSubscription.id),s=0;s<this.selection.selRows.length;s++)-1!==i.indexOf(this.selection.selRows[s])&&(this.setCheckBox(this.selection.selRows[s],this.c.CB_CHK),this.setRowSelector(this.selection.selRows[s],this.c.CB_CHK))}else t&&(this.setAllRowSelectors(this.c.CB_UNCHK),this.selection.selRows.forEach(function(e){this.setRowSelector(e,this.c.CB_CHK)}.bind(this)))}},setAllCheckBoxes:function(e){this.header.selAllCBox&&this.header.selAllCBox.setState(e),this.pageBuf.rows.forEach((function(t){t.selCB&&t.selCB.setState(e)}))},setCheckBox:function(e,t){var i=this.searchRowId(e);-1!==i&&this.pageBuf.rows[i]&&this.pageBuf.rows[i].selCB&&this.pageBuf.rows[i].selCB.setState(t)},setAllRowSelectors:function(e){this.pageBuf.rows.forEach((function(t){t.trSelCtrl&&t.trSelCtrl.setState(e)}))},setRowSelector:function(e,t){var i=this,s=this.searchRowId(e);if(-1!==s&&this.pageBuf.rows[s]&&this.pageBuf.rows[s].trSelCtrl&&(this.pageBuf.rows[s].trSelCtrl.setState(t),i.editMode)){var n=shmi.requires("visuals.tools.control-config");-1!==i.editRow&&i.resetBufferRow(i.editRow),i.editRow=s,this.pageBuf.rows[s].cols.forEach((function(e,t){e.ctrls.forEach((function(s,a){var l=i.cConfig.resp["column-org"][t],o=n.getConfig(s),r=shmi.requires("visuals.tools.iterate.iterateObject");if(void 0!==i.config["edit-mode-map"][l.fields[a].fieldName]){r(shmi.cloneObject(i.config["edit-mode-map"][l.fields[a].fieldName]),(function(e,t){o[t]=e}));var c=shmi.listen("control-reconfiguration",(function(t){c.unlisten(),e.ctrls[a]=t.detail.control}),{"detail.oldControl":s});n.setConfig(s,o)}}))})),i.updateSize()}},resetBufferRow:function(e){var t=this,i=shmi.requires("visuals.tools.control-config");void 0!==t.pageBuf.rows[e]?t.pageBuf.rows[e].cols.forEach((function(e,s){var n=t.cConfig.resp["column-org"][s];e.ctrls.forEach((function(t,s){var a=i.getConfig(t),l=shmi.cloneObject(n.fields[s].ctrl.config);l.item=a.item,l.ui=n.fields[s].ctrl["ui-type"],shmi.removeClass(t.element,a["class-name"]);var o=shmi.listen("control-reconfiguration",(function(t){o.unlisten(),e.ctrls[s]=t.detail.control}),{"detail.oldControl":t});i.setConfig(t,l)}))})):t.editRow=-1},setRowSelectorByDgRow:function(e,t){var i=e-this.pageBuf.offset;i>=0&&i<this.pageBuf.viewportSize&&this.pageBuf.rows[i]&&this.pageBuf.rows[i].trSelCtrl&&this.pageBuf.rows[i].trSelCtrl.setState(t)},updateSelectionData:function(e,t,i,s,n,a){var l=this,o="MULTI"===this.cConfig.resp["select-mode"],r="SINGLE"===this.cConfig.resp["select-mode"];if("ITEM"===this.cConfig.resp["select-mode"]){var c=shmi.visuals.session.ItemManager,u=this.pageBuf.offset+t;this.cConfig["rows-items-from-1"]&&u++,c.writeValue(this.cConfig["item-selected-row"],u)}else{switch(e){case this.c.SELECT_TYPE_NOTHING:this.selection.type=this.c.SELECT_TYPE_NOTHING,this.selection.selRows=[],this.selection.selRowIndex=[];break;case this.c.SELECT_TYPE_ALL:o&&(this.selection.type=this.c.SELECT_TYPE_ALL);break;default:if(-1!==t)if(o){if(s&&this.lastClicked.rowId>-1)return n||(this.selection.selRows=[],this.selection.selRowIndex=[]),function addSelectionRange(e,t){return new Promise((i,s)=>{const n=getRowOffset(e,t);if(null===n)s(new Error("Could not find row offset"));else{let s,a;n>=e.lastClicked.offset?(a=n,s=e.lastClicked.offset):(a=e.lastClicked.offset,s=n),loadRange(e,t,s,a-s+1,i)}})}(this,this.pageBuf.rows[t].rowId).then().catch(e=>{shmi.notify("Error fetching selection data: "+e.message,"${V_ERROR}")}),this.selection.lastClickedRow=t,void setLastClicked(this,this.pageBuf.rows[t].rowId);a||n?(i===this.c.CB_CHK?this.addRowIdToSelection(this.pageBuf.rows[t].rowId):this.removeRowIdFromSelection(this.pageBuf.rows[t].rowId),this.selection.lastClickedRow=t,setLastClicked(this,this.pageBuf.rows[t].rowId)):(shmi.cloneObject(l.selection.selRows).forEach((function(e){l.removeRowIdFromSelection(e)})),i===this.c.CB_CHK&&l.addRowIdToSelection(this.pageBuf.rows[t].rowId),setLastClicked(this,this.pageBuf.rows[t].rowId))}else r&&(this.selection.selRows=[],this.selection.selRowIndex=[],i===this.c.CB_CHK?this.addRowIdToSelection(this.pageBuf.rows[t].rowId):this.removeRowIdFromSelection(this.pageBuf.rows[t].rowId));this.updateSelTypeFromSelRows()}this.updateDelRowsBtnEnable(),clearTimeout(l.sel_fire_to),l.sel_fire_to=setTimeout((function(){l.fireSelChanged(shmi.cloneObject(l.selection))}),shmi.c("ACTION_RETRY_TIMEOUT"))}},getRowIndex:function(e){var t=null,i=this.dgMan.getGrid(this.cConfig.table);return i&&(t=i.getRowIndex(e)),t},addRowIdToSelection:function(e){if(-1===this.selection.selRows.indexOf(e)&&(this.selection.selRows.push(e),this.cConfig.useDgIndex)){var t=this.getRowIndex(e);this.selection.selRowIndex.push(t)}},removeRowIdFromSelection:function(e){var t=this.selection.selRows.indexOf(e);-1!==t?(this.selection.selRows.splice(t,1),this.cConfig.useDgIndex&&this.selection.selRowIndex.splice(t,1)):-1!==this.editRow&&(this.resetBufferRow(this.editRow),this.editRow=-1,this.updateSize())},updateSelTypeFromSelRows:function(){this.selection.selRows.length===this.pageBuf.nofTotalRows?this.selection.type=this.c.SELECT_TYPE_SEL_ROWS:0===this.selection.selRows.length?this.selection.type=this.c.SELECT_TYPE_NOTHING:this.selection.type=this.c.SELECT_TYPE_SEL_ROWS},selectAllCBoxValChanged:function(e){var t;switch(e){case this.c.CB_UNCHK:t=this.c.SELECT_TYPE_NOTHING;break;case this.c.CB_CHK:return t=this.c.SELECT_TYPE_ALL,void loadRange(this,-1,0,this.dgSubscription.changeInfo.totalRows,()=>{});default:t=this.c.SELECT_TYPE_SEL_ROWS}this.updateSelectionData(t,-1,this.c.CB_UNDEF,!1,!1,!0),this.updateSelectionView()},selectCBoxValChanged:function(e,t,i,s,n){"3-state-clear"===this.c.MULTI_SELECT_MODE&&this.header.selAllCBox&&this.header.selAllCBox.getState()===this.c.CB_UNCHK&&this.clearSelection(),this.updateSelectionData(this.c.SELECT_TYPE_SEL_ROWS,e,t,i,s,n),this.updateSelectionView()},selectRowValChanged:function(e,t,i,s){this.updateSelectionData(this.c.SELECT_TYPE_SEL_ROWS,e,t,i,s,!1),this.updateSelectionView()},deleteSelectedRows:function(){var e=this;shmi.confirm(e.config["msg-confirm-delete"]||"${ct2_confirm_delete_rows}",(function(t){e.deleteSelectedRows_confirm(t)}))},deleteSelectedRows_confirm:function(e){if(e){switch(this.selection.type){case this.c.SELECT_TYPE_ALL:setLastClicked(this,-1),this.dgMan.deleteAll(this.cConfig.table);break;case this.c.SELECT_TYPE_SEL_ROWS:setLastClicked(this,-1),this.dgMan.deleteRow(this.cConfig.table,this.selection.selRows)}this.clearSelection()}},fireSelChanged:function(e){shmi.requires("visuals.tools.iterate.iterateObject")(this.selChgEventListeners,t=>{t.listener.tableSelectionChange(e)}),this.lastSelection&&function isEqualDeep(e,t){return isEqualDeepImpl(e,t,[])}(this.lastSelection,e)||(this.lastSelection=shmi.cloneObject(e),this.updateNofRowsDisplay(),this.fire("select",e))},sortHeaderChanged:function(e,t){var i,s;switch(t){case this.c.SORT_UP:i=e,s="DESC";break;case this.c.SORT_DOWN:i=e,s="ASC";break;default:i=-1,s="ASC"}setLastClicked(this,-1),this.dgMan.sort(this.cConfig.table,i,s),this.clearSortHeaderExcept(e),this.clearSelection()},clearSortHeaderExcept:function(e){for(var t=this.cConfig.resp["nof-cols"],i=0;i<t;i++)for(var s=this.header.cols[i].ctrls,n=0;n<s.length;n++)s[n].id!==e&&s[n].setState(this.c.NO_SORT)},txtFiltersUsed:function(){var e=!1;return this.config["default-text-filter-fields"].length>0&&(e=!0),e},clearFilterData:function(){this.filterData={};for(var e=this.cConfig.filters.length,t=0;t<e;t++){var i=this.cConfig.filters[t],s=this.getDataColNo(i.field).toString(),n=this.filterData[s];n||((n={}).expr=[],n.changed=!1,this.filterData[s]=n)}},clearColTextFilterData:function(){this.colTextFilterData={};for(var e=this.cConfig.resp["text-filter-fields"],t=0;t<e.length;t++){var i=this.getDataColNo(e[t]).toString(),s=this.colTextFilterData[i];s||((s={}).expr="",s.changed=!1,this.colTextFilterData[i]=s)}},quicksearchChanged:function(e){var t="string"==typeof e?e.trim():e,i=this.cConfig.quicksearch.fields;""===t?this.removeQuicksearchFilterExpr(i):this.setQuicksearchFilterExpr(t,i),this.applyFilters(),this.clearSelection(),this.resetScroll()},filterChanged:function(e,t,i){1===e?this.setFilterExpr(i):this.removeFilterExpr(i),this.applyFilters(),this.clearSelection(),this.resetScroll()},colTxtFilterChanged:function(e,t,i){var s="string"==typeof e?e.trim():e;if(""===s){var n=this.getFilterId(i);this.removeColTxtFilterExpr(n)}else this.setColTxtFilterExpr(i,s);this.applyFilters(),this.clearSelection(),this.resetScroll()},colTxtFilterReset:function(e){var t=this.colTxtFilters.items[e];t&&shmi.visuals.session.ItemManager.writeValue(t.name,"")},setFilterExpr:function(e){var t=this.getFilterId(e);if(-1!==Number(t)){var i=this.cConfig.filters[t];if(i){var s=i.expr,n=this.getDataColNo(i.field).toString(),a=this.filterData[n];-1===a.expr.indexOf(s)&&(a.expr.push(s),a.changed=!0)}}},removeFilterExpr:function(e){var t=this.getFilterId(e);if(-1!==Number(t)){var i=this.cConfig.filters[t];if(i){var s=i.expr,n=this.getDataColNo(i.field).toString(),a=this.filterData[n],l=a.expr.indexOf(s);-1!==l&&(a.expr.splice(l,1),a.changed=!0)}}},setColTxtFilterExpr:function(e,t){for(var i=this.getFilterId(e),s=this.getColTxtFilterDgCols(i),n=0;n<s.length;n++){var a=s[n].toString(),l=this.colTextFilterData[a];l?(l.expr="%"+t+"%",l.changed=!0):shmi.log("[ComplexTable2] setColTxtFilterExpr, no filter data available for data grid col: "+a,3)}},removeColTxtFilterExpr:function(e){for(var t=this.getColTxtFilterDgCols(e),i=0;i<t.length;i++){var s=t[i].toString(),n=this.colTextFilterData[s];n?(n.expr="",n.changed=!0):shmi.log("[ComplexTable2] removeColTxtFilterExpr, no filter data available for data grid col: "+s,3)}},setQuicksearchFilterExpr:function(e,t){t.forEach(function(t){for(var i=this.getColTxtFilterDgCols(this.getDataColIndex(t)),s=0;s<i.length;s++){var n=i[s].toString(),a=this.colTextFilterData[n];a?(a.expr="%"+e+"%",a.changed=!0):shmi.log("[ComplexTable2] setQuicksearchFilterExpr, no filter data available for data grid col: "+n,3)}}.bind(this))},removeQuicksearchFilterExpr:function(e){e.forEach(function(e){for(var t=this.getColTxtFilterDgCols(this.getDataColIndex(e)),i=0;i<t.length;i++){var s=t[i].toString(),n=this.colTextFilterData[s];n?(n.expr="",n.changed=!0):shmi.log("[ComplexTable2] removeQuicksearchFilterExpr, no filter data available for data grid col: "+s,3)}}.bind(this))},getDataColIndex:function(e){var t,i=0;for(var s in this.cConfig["field-datagrid-col-map"])s===e&&(t=i),i++;return void 0===t?(t=0,shmi.log("[ComplexTable2] getDataColNo, unknown fldName "+e,3)):t=shmi.toNumber(t),t},getFilterId:function(e){var t=-1,i=e.lastIndexOf(":");return-1!==Number(i)?t=shmi.toNumber(e.substring(i+1)):shmi.log("[ComplexTable2] getFilterId, unexpected format of virtual item name: "+e,3),t},getColTxtFilterDgCols:function(e){var t=[],i=this.cConfig.resp["column-org"][e];if(i)for(var s=i.fields.length,n=0;n<s;n++)i.fields[n].hasTextFilter&&t.push(i.fields[n].dgCol);return t},applyFilters:function(){if(this.isApplyFiltersEnabled()){for(var e=Object.keys(this.filterData),t=Object.keys(this.colTextFilterData),i=e.slice(),s=0;s<t.length;s++)-1===i.indexOf(t[s])&&i.push(t[s]);for(s=0;s<i.length;s++){var n=this.filterData[i[s]],a=this.colTextFilterData[i[s]],l=!1;if(n&&n.changed?l=!0:a&&a.changed&&(l=!0),l){var o=[];n&&(o=n.expr.slice(),n.changed=!1),a&&(""!==a.expr&&o.push(a.expr),a.changed=!1);var r=shmi.toNumber(i[s]);0===o.length?(setLastClicked(this,-1),this.dgMan.clearFilter(this.cConfig.table,r)):(setLastClicked(this,-1),this.dgMan.setFilter(this.cConfig.table,r,o))}}}},isApplyFiltersEnabled:function(){return this.applyFiltersEnable},setApplyFiltersEnable:function(e){this.applyFiltersEnable=e},resetFilterChangeFlags:function(){for(var e=Object.keys(this.filterData),t=0;t<e.length;t++)this.filterData[e[t]].changed=!1},resetColTxtFilterChangeFlags:function(){for(var e=Object.keys(this.colTextFilterData),t=0;t<e.length;t++)this.colTextFilterData[e[t]].changed=!1},clearCtrlPanelData:function(){this.ctrlPanelData.filter||(this.ctrlPanelData.filter={},this.ctrlPanelData.filter.names=[],this.ctrlPanelData.filter.items=[]);var e=this.isApplyFiltersEnabled();this.setApplyFiltersEnable(!1);for(var t=shmi.visuals.session.ItemManager,i=0;i<this.ctrlPanelData.filter.items.length;i++)t.writeValue(this.ctrlPanelData.filter.items[i].name,0);if(this.resetFilterChangeFlags(),this.setApplyFiltersEnable(e),this.ctrlPanelData.filter.btns)for(i=0;i<this.ctrlPanelData.filter.btns.length;i++)shmi.deleteControl(this.ctrlPanelData.filter.btns[i]);this.ctrlPanelData.filter.btns=[],this.ctrlPanelData.delRowsBtn&&shmi.deleteControl(this.ctrlPanelData.delRowsBtn),this.ctrlPanelData.delRowsBtn=null},clearColTextFilterCtrls:function(){this.colTxtFilters.items||(this.colTxtFilters.items=[]);var e=this.isApplyFiltersEnabled();this.setApplyFiltersEnable(!1);for(var t=shmi.visuals.session.ItemManager,i=0;i<this.colTxtFilters.items.length;i++)this.colTxtFilters.items[i]&&t.writeValue(this.colTxtFilters.items[i].name,"");this.resetColTxtFilterChangeFlags(),this.setApplyFiltersEnable(e);var s=[];if(this.colTxtFilters.cols)for(var n=0;n<this.colTxtFilters.cols.length;n++)if(this.colTxtFilters.cols[n])for(s=this.colTxtFilters.cols[n].ctrls,i=0;i<s.length;i++)shmi.deleteControl(s[i]);this.colTxtFilters.cols=[]},clearCtrlPanelDOM:function(){if(this.ctrlPanelElement){this.ctrlPanelData&&this.ctrlPanelData.qSearchInput&&(shmi.deleteControl(this.ctrlPanelData.qSearchInput),this.ctrlPanelData.qSearchInput=null);for(var e=this.ctrlPanelElement.firstChild;e;)this.ctrlPanelElement.removeChild(e),e=this.ctrlPanelElement.firstChild}},updateCtrlPanel:function(){if(this.ctrlPanelElement&&(this.getTableWidth()<this.cConfig["show-buttons-table-min-width-px"]?(shmi.removeClass(this.ctrlPanelElement,this.uiCssCl.ctrlPanelNormal),shmi.addClass(this.ctrlPanelElement,this.uiCssCl.ctrlPanelMin)):(shmi.removeClass(this.ctrlPanelElement,this.uiCssCl.ctrlPanelMin),shmi.addClass(this.ctrlPanelElement,this.uiCssCl.ctrlPanelNormal)),this.clearCtrlPanelData(),this.clearCtrlPanelDOM(),this.cConfig.quicksearch&&this.cConfig.quicksearch.enable?this.enableQuickSearch():this.enableFilterButtons(),this.cConfig["delete-selected-rows"])){var e=document.createElement("div");this.ctrlPanelElement.appendChild(e);var t=this.getChildCtrlConfig(this.cConfig["delete-selected-rows-button-config"]);t||(t={label:"${ct2_delete_rows}"}),this.ctrlPanelData.delRowsBtn=shmi.createControl("button",e,t,"div"),this.ctrlPanelData.delRowsBtn.onClick=function(){this.deleteSelectedRows()}.bind(this),this.updateDelRowsBtnEnable()}},enableFilterButtons:function(){var e,t=this.ctrlPanelData.filter,i=this.cConfig.filters,s=i.length,n=this.getFilterItemNS();if(0===t.items.length)for(e=0;e<s;e++){var a=shmi.localize(i[e].label);t.names.push(a);var l="virtual:"+n+":"+e,o=shmi.createVirtualItem(l,2,0,1,0,function(e,t,i){this.filterChanged(e,t,i)}.bind(this));t.items.push(o)}for(e=0;e<s;e++){var r=document.createElement("div");this.ctrlPanelElement.appendChild(r);var c=this.getChildCtrlConfig(i[e]["filter-button-config"],this.cConfig["default-filter-button-config"]);c||((c={"off-value":0,"on-value":1})["off-label"]=c["on-label"]=t.names[e],i[e].template&&(c.template=i[e].template),i[e]["class-name"]&&(c["class-name"]=i[e]["class-name"])),c.item=t.items[e].name;var u=shmi.createControl("toggle-button",r,c,"div");t.btns.push(u)}},enableQuickSearch:function(){var e=this;if("AND"===e.cConfig.quicksearch.chaining||"OR"===e.cConfig.quicksearch.chaining?shmi.visuals.session.DataGridManager.setFilterChaining(e.cConfig.table,e.cConfig.quicksearch.chaining):shmi.visuals.session.DataGridManager.setFilterChaining(e.cConfig.table,"OR"),!e.ctrlPanelData.qSearchInput){var t=document.createElement("div"),i=document.createElement("div");shmi.addClass(t,"qsearch-box"),e.ctrlPanelElement.appendChild(t);e.ctrlPanelData.qSearchInput=shmi.createControl("input-field",t,{label:"${ct2_quicksearch}","class-name":"input-field label-beside"},"div"),t.appendChild(i),shmi.addClass(i,"ct2-qsearch-clear"),i.addEventListener("click",(function(){e.isActive()&&!e.locked&&(e.ctrlPanelData.qSearchInput.setValue(""),e.qSearchOld=null,e.quicksearchHandler())})),shmi.onActive([e.ctrlPanelData.qSearchInput],(function(){if(e.isActive()){var t=e.ctrlPanelData.qSearchInput.valueElement;null!==e.qSearchOld&&e.ctrlPanelData.qSearchInput.setValue(e.qSearchOld),e.quicksearchHandler=onQuickSearch.bind(null,e,t),e.quicksearchValueElement=t,t.addEventListener("keyup",e.quicksearchHandler),e.vars.qSearchToken=e.ctrlPanelData.qSearchInput.listen("change",e.quicksearchHandler),e.cConfig.quicksearch&&e.cConfig.quicksearch.initialFocus&&e.ctrlPanelData.qSearchInput.valueElement.focus()}})),e.isLocked()&&e.ctrlPanelData.qSearchInput.lock()}},updateDelRowsBtnEnable:function(){var e=!0;this.ctrlPanelData.delRowsBtn&&((this.selection.type===this.c.SELECT_TYPE_NOTHING||this.selection.type===this.c.SELECT_TYPE_SEL_ROWS&&0===this.selection.selRows.length)&&(e=!1),e?this.ctrlPanelData.delRowsBtn.unlock():this.ctrlPanelData.delRowsBtn.lock())},getFilterItemNS:function(){return"ct2-filter-"+this.instID},getColTxtFilterItemNS:function(){return"ct2-col-txt-filter-"+this.instID},getAdapterNS:function(){return"ct2-adapter-"+this.instID},updateHeader:function(){var e=this;this.header.cols&&this.header.cols.forEach((function(e,t){e.ctrls[0].cbMouseListener&&(e.ctrls[0].cbMouseListener.disable(),e.ctrls[0].cbTouchListener.disable())})),this.header.selAllCBox=null,this.header.cols=[];for(var t=this.theadElement.firstChild;t;)this.theadElement.removeChild(t),t=this.theadElement.firstChild;var i=this.cConfig.resp["nof-cols"],s="MULTI"===this.cConfig.resp["select-mode"],n=this.createColGroup(i,s);this.theadElement.appendChild(n);var a=document.createElement("tr"),l=null,o=null;s&&this.config["show-select-boxes"]&&(l=document.createElement("th"),o=document.createElement("div"),this.header.selAllCBox=this.createSelCBox(o,-1,!0,this),this.header.selAllCBox.setChangeCallback((function(t,i){e.locked||e.selectAllCBoxValChanged(i)})),l.appendChild(o),a.appendChild(l)),this.theadElement.appendChild(a);for(var r=0;r<i;r++){var c=this.cConfig.resp["column-org"][r];l=document.createElement("th"),o=document.createElement("div"),this.header.cols[r]={},this.header.cols[r].ctrls=this.createHeaderCtrls(o,r),l.appendChild(o),a.appendChild(l),c.fields[0]["min-width"]&&(o.style.minWidth=c.fields[0]["min-width"]),this.header.cols[r].ctrls.forEach((function(t,i){var s=t.fieldName;if(e.config.adapterSettings&&e.config.adapterSettings[s]){var n=e.config.adapterSettings[s],a=null;e.adapterItems.forEach((function(e,t){e.field===s&&(a=e.item.name)}));var o=document.createElement("div");l.appendChild(o);var r=shmi.cloneObject(e.config.adapterSelectConfig);r.item=a,r.options=n,shmi.createControl("select-box",o,r,"DIV","from"),shmi.addClass(l,e.config.adapterSelectClass)}}))}},updateColTextFilters:function(){if(this.txtFiltersHeadElement&&this.txtFiltersUsed()){this.clearColTextFilterCtrls();for(var e=this.txtFiltersHeadElement.firstChild;e;)this.txtFiltersHeadElement.removeChild(e),e=this.txtFiltersHeadElement.firstChild;var t;if(0===this.colTxtFilters.items.length){var i=Object.keys(this.cConfig["field-datagrid-col-map"]).length,s=this.getColTxtFilterItemNS();for(t=0;t<i;t++){var n="virtual:"+s+":"+t;this.colTxtFilters.items[t]=shmi.createVirtualItem(n,0,0,1,"",function(e,t,i){this.colTxtFilterChanged(e,t,i)}.bind(this))}}var a=this.cConfig.resp["nof-cols"],l="MULTI"===this.cConfig.resp["select-mode"],o=this.createColGroup(a,l);this.txtFiltersHeadElement.appendChild(o);var r=document.createElement("tr");this.txtFiltersHeadElement.appendChild(r);var c=null,u=null;for(l&&(c=document.createElement("th"),r.appendChild(c)),t=0;t<a;t++){var h=this.cConfig.resp["column-org"][t];c=document.createElement("th"),u=document.createElement("div"),c.appendChild(u),r.appendChild(c),h.hasTextFilter&&(this.colTxtFilters.cols[t]={},this.colTxtFilters.cols[t].ctrls=this.createColTxtFilterCtrls(u,t))}}},getDgFilterSettings:function(){var e=this;clearTimeout(e.reset_sort_filters_to),e.reset_sort_filters_to=setTimeout((function(){e.resetSortFilters()}),shmi.c("ACTION_RETRY_TIMEOUT"))},getColTxtFilterVal:function(e){var t="",i=e.length;return i>=3&&"%"===e.charAt(0)&&"%"===e.charAt(i-1)?t=e.slice(1,i-1):shmi.log("[ComplexTable2] getColTxtFilterVal, unexpected format of filter expression: "+e,2),t},getBtnFilter:function(e,t){for(var i=-1,s=this.cConfig.filters,n=0;n<s.length;n++){if(this.getDataColNo(s[n].field)===t&&e===s[n].expr){i=n;break}}return i},resetSortFilters:function(){setLastClicked(this,-1),this.dgMan.sort(this.cConfig.table,-1,"ASC"),this.dgMan.clearFilter(this.cConfig.table,-1)},updateNofRowsDisplay:function(){this.cConfig.resp["show-nof-rows"]&&this.footerElement&&(this.footerElement.textContent=this.pageBuf.nofTotalRows+" "+shmi.localize("${ct2_nof_rows}"))},updateRespDepContent:function(e){e&&("ICON"===this.cConfig.resp.headerMode?this.headerMode="ICON":this.headerMode="TEXT",this.cLayoutClass&&shmi.removeClass(this.element,this.cLayoutClass),this.cLayoutClass=this.cConfig.resp["layout-class-name"],this.cLayoutClass&&shmi.addClass(this.element,this.cLayoutClass),this.cConfig.resp["show-nof-rows"]?(shmi.removeClass(this.element,this.uiCssCl.rowDisplInvisible),shmi.addClass(this.element,this.uiCssCl.rowDisplVisible)):(shmi.removeClass(this.element,this.uiCssCl.rowDisplVisible),shmi.addClass(this.element,this.uiCssCl.rowDisplInvisible)),"MULTI"===this.cConfig.resp["select-mode"]?shmi.addClass(this.element,this.uiCssCl.multiselect):shmi.removeClass(this.element,this.uiCssCl.multiselect)),this.updateCtrlPanel(),this.updateHeader(),this.cConfig.quicksearch&&this.cConfig.quicksearch.enable||this.updateColTextFilters()},cleanupTabContent:function(){this.clearPgBuf(),this.clearTableDOM()},clearPgBuf:function(){if(this.pageBuf.rows)for(var e=0;e<this.pageBuf.rows.length;e++){this.pageBuf.rows[e].trSelCtrl&&this.pageBuf.rows[e].trSelCtrl.rsMouseListener&&(this.pageBuf.rows[e].trSelCtrl.rsMouseListener.disable(),this.pageBuf.rows[e].trSelCtrl.rsTouchListener.disable());for(var t=0;t<this.pageBuf.nofCols;t++)for(var i=this.pageBuf.rows[e].cols[t].ctrls,s=0;s<i.length;s++)shmi.deleteControl(i[s])}this.pageBuf.offset=0,this.pageBuf.nofTotalRows=0,this.pageBuf.size=0,this.pageBuf.nofCols=0,this.pageBuf.firstVpRow=0,this.pageBuf.avgNofVpLines=0,this.pageBuf.rows=[]},clearTableDOM:function(){this.tbodyElement.forEach((function(e){for(var t=e.firstChild;t;)e.removeChild(t),t=e.firstChild}))},cleanupMetrics:function(){this.metricsData.isValid?this.metricsData.last=shmi.cloneObject(this.metricsData):this.metricsData.last={},this.metricsData.isValid=!1,this.metricsData.lineHeightPx=0},cleanupAsyncProcessing:function(){this.asyncProcData.onDgChgRetryTO&&clearTimeout(this.asyncProcData.onDgChgRetryTO),this.asyncProcData.onEvtResizeRetryTO&&clearTimeout(this.asyncProcData.onEvtResizeRetryTO),this.asyncProcData.processMetricsTO&&clearTimeout(this.asyncProcData.processMetricsTO),this.asyncProcData.onDgChgRetryTO=null,this.asyncProcData.onEvtResizeRetryTO=null,this.asyncProcData.processMetricsTO=null},reinitTable:function(e,t,i){var s=this,n=this.pageBuf.rows.length;if(0===n)if(0!==e.totalRows){shmi.removeClass(this.element,this.uiCssCl.emptyTab),this.pageBuf.bufferOffset=e.offset,this.pageBuf.nofTotalRows=e.totalRows,s.tableElement.style.height=s.pageBuf.nofTotalRows*s.metricsData.lineHeightPx+"px",this.pageBuf.size=t.length,this.pageBuf.viewportSize=this.cConfig["nof-buffered-rows"],this.pageBuf.bufferSize=this.cConfig["buffer-size"],this.pageBuf.offset<this.pageBuf.bufferOffset?this.pageBuf.offset=this.pageBuf.bufferOffset:this.pageBuf.offset>this.pageBuf.bufferOffset+this.pageBuf.bufferSize&&(this.pageBuf.offset=this.pageBuf.bufferOffset);for(var a=this.pageBuf.nofCols=this.cConfig.resp["nof-cols"],l=n;l<this.pageBuf.viewportSize;l++)this.pageBuf.rows[l]=createRowDescriptor("number"==typeof t[l]?t[l]:null,a);i||(this.bodyViewportElement.scrollTop=0);var o="MULTI"===this.cConfig.resp["select-mode"];this.tbodyElement.forEach((function(e,t){var i=s.pageBuf.viewportSize/3,n=s.createColGroup(a,o);e.appendChild(n);for(var l=0;l<i;l++)createTableRow(s,t*i+l,e,0===l)})),this.processAsyncMetricsUpdate(i?s.vars.scrollTop:null)}else this.pageBuf.nofCols=this.cConfig.resp["nof-cols"],shmi.addClass(this.element,this.uiCssCl.emptyTab);else console.warn("[ComplexTable2] reinitTable, table is not empty, length:",n)},processTabReinitDependencies:function(){this.updateNofRowsDisplay(),this.updateSelectionView()},doScrollUpdate:function doScrollUpdate(){updatePages(this,this.bodyViewportElement.scrollTop)},initScrollHandler:function(){var e=this;e.bodyViewportElement.style["overflow-y"]="scroll",e.onBodyScroll=function(t){clearTimeout(e.vars.updateTimeout),e.vars.updateTimeout=0,e.isActive()&&!e.locked?Date.now()-e.vars.lastUpdate>100?(e.doScrollUpdate(),e.vars.lastUpdate=Date.now()):e.vars.updateTimeout=setTimeout((function(){e.doScrollUpdate(),e.vars.lastUpdate=Date.now()}),100):e.bodyViewportElement.scrollTop=0},e.bodyViewportElement.addEventListener("scroll",e.onBodyScroll)},resetScroll:function(){this.bodyViewportElement.scrollTop=0},updateTable:function(e,t){var i=this,s=i.cConfig["nof-buffered-rows"]/3,n=[];if(0===i.pageBuf.rows.length||i.pageBuf.bufferSize<t.length)console.error("[ComplexTable2]","updateTable, table is empty or buffer size has been changed");else{var a=i.pageBuf.offset-i.pageBuf.bufferOffset;t.forEach((function(e,l){var o=l-a;if(!(o<0||o>=3*s)){var r=Math.floor(o/s),c=i.vars.pageOrder[r]*s+o%s,u=i.pageBuf.rows[c];u?(n.push(c),u.rowId===e&&u.visible||i.writeRow(c,t,l)):console.error("[ComplexTable2]","invalid buffer index:",c)}})),i.pageBuf.rows.forEach((function(e,t){-1===n.indexOf(t)?e.visible&&(e.visible=!1,e.trElem.style.visibility="hidden"):e.visible||(e.visible=!0,e.trElem.style.visibility="")}))}},writeRow:function(e,t,i){var s=0,n="",a=null;if(this.pageBuf.rows[e]){s=this.pageBuf.rows[e].rowId=t[i];for(var l=0;l<this.pageBuf.nofCols;l++){a=this.cConfig.resp["column-org"][l];for(var o=this.pageBuf.rows[e].cols[l].ctrls,r=0;r<o.length;r++){n=this.makeItem(s,a.fields[r].dgCol);var c=shmi.requires("visuals.tools.item-adapter"),u=this.getColumnAdapter(a.fields[r].fieldName);null!==shmi.visuals.session.ItemManager.getItem(n)&&(null===u?c.unsetAdapter(n):c.setAdapter(n,u)),o[r].setItem(n)}}}},updateMetricsData:function(e){if(this.pageBuf.size>0){this.metricsData.lineHeightPx=this.tbodyElement[0].getBoundingClientRect().height/this.tbodyElement[0].rows.length,this.tableElement.style.height=this.pageBuf.nofTotalRows*this.metricsData.lineHeightPx+"px",this.tableElement.style.overflow="hidden",this.metricsData.viewportHeight=this.bodyViewportElement.getBoundingClientRect().height,this.metricsData.viewportWidth=this.bodyViewportElement.getBoundingClientRect().width;var t=3*Math.ceil(this.metricsData.viewportHeight/this.metricsData.lineHeightPx);this.cConfig["nof-buffered-rows"]<t&&(this.cConfig["nof-buffered-rows"]=t,console.info("[ComplexTable2]","buffer rows configured too low, corrected to:",t));var i=this.cConfig["nof-buffered-rows"];this.pageBuf.nofTotalPages=this.pageBuf.nofTotalRows/(i/3)}else this.metricsData.last.isValid?this.metricsData=shmi.cloneObject(this.metricsData.last):this.metricsData.lineHeightPx=this.c.DEFAULT_LINE_HEIGHT;this.metricsData.isValid=!0,"number"==typeof e?reinitPages(this,e):(this.vars.scrollTop=0,reinitPages(this,0))},disableEvents:function(){this.header.selAllCBox&&this.header.selAllCBox.setEventsEnabled(!1)},enableEvents:function(){this.header.selAllCBox&&this.header.selAllCBox.setEventsEnabled(!0)},createHeaderCtrls:function(e,t){var i=this,s=[];shmi.addClass(e,this.uiCssCl.thCont);for(var n=this.cConfig.resp["column-org"][t],a=n.fields.length,l=0;l<a;l++){var o=document.createElement("div"),r=n.fields[l].icon,c=n.fields[l].header||" ";if(c){var u=shmi.localize(c);l>0&&(u=" / "+u);var h=new shmi.visuals.controls.ComplexTable2.FieldHeader(o,n.fields[l].dgCol,n.fields[l].isSortable,this.c.NO_SORT,u,i,n.fields[l].fieldName,r);h.setChangeCallback((function(e,t){i.locked||i.sortHeaderChanged(e,t)})),s.push(h),e.appendChild(o)}}return s},createColTxtFilterCtrls:function(e,t){var i=[],s=document.createElement("div"),n=document.createElement("div");s.appendChild(n),e.appendChild(s),shmi.addClass(e,this.uiCssCl.thCont),shmi.addClass(s,this.uiCssCl.colTxtFilterCont),shmi.addClass(n,this.uiCssCl.colTxtFilterLineCont);var a=document.createElement("img");n.appendChild(a),a.src="pics/system/controls/complex-table2/filter.svg",shmi.addClass(a,this.uiCssCl.colTxtFilterIcon);var l=this.colTxtFilters.items[t].name,o=this.getChildCtrlConfig(this.cConfig.resp["text-filter-input-field-config"]);o||(o={"class-name":"input-field if-filter"}),o.item=l;var r=shmi.createControl("input-field",n,o,"div");i.push(r),(o=this.getChildCtrlConfig(this.cConfig.resp["text-filter-clear-button-config"]))||(o={"class-name":"button icon-only reset-filter",label:"X","icon-src":"pics/system/controls/complex-table2/cross_white.svg"});var c=shmi.createControl("button",n,o,"div");return c.onClick=function(){this.colTxtFilterReset(t)}.bind(this),i.push(c),i},createSelCBox:function(e,t,i,s){return new shmi.visuals.controls.ComplexTable2.CheckBox(e,t,i,this.c.CB_UNCHK,s)},createSelRowCtrl:function(e,t,i){return new shmi.visuals.controls.ComplexTable2.RowSelector(e,t,this.c.CB_UNCHK,i)},createColGroup:function(e,t){var i=document.createElement("colgroup"),s=[];t&&this.config["show-select-boxes"]&&(s.push(document.createElement("col")),s[s.length-1].setAttribute("class",this.uiCssCl.colCb));for(var n=0;n<e;n++){var a=this.cConfig.resp["column-org"][n];s.push(document.createElement("col")),s[s.length-1].setAttribute("class",this.uiCssCl.colPfx+(n+1)),a.fields[0]["column-width"]&&(s[s.length-1].style.width=a.fields[0]["column-width"])}return s.forEach((function(e){i.appendChild(e)})),i},getTableWidth:function(){var e=0;if(this.tcElement)e=this.tcElement.offsetWidth;else{var t=shmi.getUiElement(this.uiElName.tabContainer,this.element);t?e=t.offsetWidth:shmi.log("[ComplexTable2] no "+this.uiElName.tabContainer+" element provided (required)",3)}return e},getTableVpWidth:function(){return this.bodyViewportElement.offsetWidth},isTabSizeChanged:function(){var e=!1;return this.getTableVpWidth()===this.lastTableVpWidth&&this.element.offsetHeight===this.lastTableVpHeight||(e=!0,this.lastTableVpWidth=this.getTableVpWidth(),this.lastTableVpHeight=this.element.offsetHeight),e},isLayoutChanged:function(){var e=!1;return this.cConfig.resp["layout-id"]!==this.lastLayoutId&&(e=!0,this.lastLayoutId=this.cConfig.resp["layout-id"]),e},makeItem:function(e,t){return this.dgSubscription.prefix+e+":"+t},searchRowId:function(e){for(var t=-1,i=0;i<this.pageBuf.viewportSize;i++)if(this.pageBuf.rows[i]&&this.pageBuf.rows[i].rowId===e){t=i;break}return t},detectTouchDevice:function(){return!!("ontouchstart"in document.documentElement)},onLock:function(){shmi.addClass(this.element,"locked"),this.cConfig.quicksearch&&this.cConfig.quicksearch.enable&&this.ctrlPanelData.qSearchInput&&this.ctrlPanelData.qSearchInput.lock()},onUnlock:function(){shmi.removeClass(this.element,"locked"),this.cConfig.quicksearch&&this.cConfig.quicksearch.enable&&this.ctrlPanelData.qSearchInput&&this.ctrlPanelData.qSearchInput.unlock()}},shmi.extend(shmi.visuals.controls.ComplexTable2,shmi.visuals.core.BaseControl),shmi.registerControlType("complex-table2",shmi.visuals.controls.ComplexTable2,!0),shmi.visuals.controls.ComplexTable2.CheckBox=function(e,t,i,s,n){this.ct2c=shmi.visuals.controls.ComplexTable2.c,this.css=shmi.visuals.controls.ComplexTable2.CheckBox.uiCssCl,this.element=e,this.id=t,this.is3tate=i,this.state=s,this.chgCallb=null,this.cbMouseListener=null,this.cbTouchListener=null,shmi.addClass(this.element,shmi.visuals.controls.ComplexTable2.uiCssCl.selCb);var a={};a.onPress=function(){n.locked||shmi.addClass(this.element,this.css.sel)}.bind(this),a.onRelease=function(){n.locked||shmi.removeClass(this.element,this.css.sel)}.bind(this),a.onClick=function(){if(!n.locked){if(this.is3tate)switch(this.state){case this.ct2c.CB_UNCHK:this.state=this.ct2c.CB_CHK;break;case this.ct2c.CB_CHK:this.state=this.ct2c.CB_UNDEF;break;default:this.state=this.ct2c.CB_UNCHK}else this.state=this.state===this.ct2c.CB_UNCHK?this.ct2c.CB_CHK:this.ct2c.CB_UNCHK;this.updateState(),this.fireCbChg()}}.bind(this),this.cbMouseListener=new shmi.visuals.io.MouseListener(this.element,a),this.cbTouchListener=new shmi.visuals.io.TouchListener(this.element,a),this.updateState(),this.setEventsEnabled(!0)},shmi.visuals.controls.ComplexTable2.CheckBox.prototype={setChangeCallback:function(e){this.chgCallb=e},setEventsEnabled:function(e){e?(this.cbMouseListener.enable(),this.cbTouchListener.enable()):(this.cbMouseListener.disable(),this.cbTouchListener.disable())},setState:function(e){this.state=e,this.updateState()},getState:function(){return this.state},updateState:function(){switch(shmi.removeClass(this.element,this.css.ck),shmi.removeClass(this.element,this.css.unck),shmi.removeClass(this.element,this.css.undef),this.state){case this.ct2c.CB_UNCHK:shmi.addClass(this.element,this.css.unck);break;case this.ct2c.CB_CHK:shmi.addClass(this.element,this.css.ck);break;default:shmi.addClass(this.element,this.css.undef)}},fireCbChg:function(){this.chgCallb&&this.chgCallb(this.id,this.state)}},shmi.visuals.controls.ComplexTable2.RowSelector=function(e,t,i,s){var n=this;n.ct2c=shmi.visuals.controls.ComplexTable2.c,n.css=shmi.visuals.controls.ComplexTable2.RowSelector.uiCssCl,n.element=e,n.id=t,n.state=i,n.chgCallb=null,n.rsMouseListener=null,n.rsTouchListener=null;var a={onPress:function(){s.locked||shmi.addClass(n.element,n.css.sel)},onRelease:function(){s.locked||shmi.removeClass(n.element,n.css.sel)},onClick:function(e,t,i){s.locked||(n.shiftPressed=i.shiftKey,n.ctrlPressed=i.ctrlKey,n.state=n.state===n.ct2c.CB_UNCHK?n.ct2c.CB_CHK:n.ct2c.CB_UNCHK,n.updateState(),n.fireRsChg())}};n.rsMouseListener=new shmi.visuals.io.MouseListener(n.element,a),n.rsTouchListener=new shmi.visuals.io.TouchListener(n.element,a),n.updateState(),n.setEventsEnabled(!0)},shmi.visuals.controls.ComplexTable2.RowSelector.prototype={setChangeCallback:function(e){this.chgCallb=e},setEventsEnabled:function(e){e?(this.rsMouseListener.enable(),this.rsTouchListener.enable()):(this.rsMouseListener.disable(),this.rsTouchListener.disable())},setState:function(e){this.state=e,this.updateState()},getState:function(){return this.state},updateState:function(){shmi.removeClass(this.element,this.css.ck),shmi.removeClass(this.element,this.css.unck),this.state===this.ct2c.CB_CHK?shmi.addClass(this.element,this.css.ck):shmi.addClass(this.element,this.css.unck)},fireRsChg:function(){this.chgCallb&&this.chgCallb(this.id,this.state,this.shiftPressed,this.ctrlPressed)}},shmi.visuals.controls.ComplexTable2.FieldHeader=function(e,t,i,s,n,a,l,o){if(this.ct2c=shmi.visuals.controls.ComplexTable2.c,this.css=shmi.visuals.controls.ComplexTable2.FieldHeader.uiCssCl,this.ct2Inst=a,this.element=e,this.id=t,this.isSortable=i,this.state=s,this.caption=n,this.chgCallb=null,this.cbMouseListener=null,this.cbTouchListener=null,this.fieldName=void 0!==l?l:null,this.icon=void 0===o?null:o,shmi.addClass(this.element,shmi.visuals.controls.ComplexTable2.uiCssCl.fldHeader),"ICON"===this.ct2Inst.headerMode?null!==this.icon&&shmi.addClass(e,this.icon):e.textContent=this.caption,this.isSortable){shmi.addClass(this.element,this.css.sortable);var r={};r.onPress=function(){this.ct2Inst.locked||shmi.addClass(this.element,this.css.sel)}.bind(this),r.onRelease=function(){this.ct2Inst.locked||shmi.removeClass(this.element,this.css.sel)}.bind(this),r.onClick=function(){if(!this.ct2Inst.locked){switch(this.state){case this.ct2c.SORT_UP:this.state=this.ct2c.SORT_DOWN;break;case this.ct2c.SORT_DOWN:this.state=this.ct2c.NO_SORT;break;default:this.state=this.ct2c.SORT_UP}this.updateState(),this.fireSortChg()}}.bind(this),this.cbMouseListener=new shmi.visuals.io.MouseListener(this.element,r),this.cbTouchListener=new shmi.visuals.io.TouchListener(this.element,r)}this.updateState(),this.setEventsEnabled(!0)},shmi.visuals.controls.ComplexTable2.FieldHeader.prototype={setChangeCallback:function(e){this.chgCallb=e},setEventsEnabled:function(e){this.cbMouseListener&&(e?(this.cbMouseListener.enable(),this.cbTouchListener.enable()):(this.cbMouseListener.disable(),this.cbTouchListener.disable()))},setState:function(e){this.state=e,this.updateState()},getState:function(){return this.state},updateState:function(){if(this.isSortable)switch(shmi.removeClass(this.element,this.css.noSort),shmi.removeClass(this.element,this.css.sortUp),shmi.removeClass(this.element,this.css.sortDn),this.state){case this.ct2c.SORT_UP:shmi.addClass(this.element,this.css.sortUp);break;case this.ct2c.SORT_DOWN:shmi.addClass(this.element,this.css.sortDn);break;default:shmi.addClass(this.element,this.css.noSort)}else shmi.addClass(this.element,this.css.noSort)},fireSortChg:function(){this.chgCallb&&this.chgCallb(this.id,this.state)}},shmi.visuals.controls.ComplexTable2.instIDs=[],shmi.visuals.controls.ComplexTable2.uiElName={},(e=shmi.visuals.controls.ComplexTable2.uiElName).tabContContainer="ct2-table-content-container",e.tabHeadContainer="ct2-table-header-container",e.tabContainer="ct2-table-container",e.tbodyContainer="ct2-table-body-container",e.thead="ct2-table-header",e.table="ct2-table",e.txtFiltersHead="ct2-table-filters",e.tbody="ct2-table-body",e.label="ct2-label",e.ctrlPanel="ct2-ctrl-panel",e.footer="ct2-footer",shmi.visuals.controls.ComplexTable2.uiCssCl={},(e=shmi.visuals.controls.ComplexTable2.uiCssCl).colCb="ct2-colcb",e.colPfx="ct2-col",e.thCont="ct2-thcont",e.tdCont="ct2-tdcont",e.selCb="ct2-selcb",e.evenRow="ct2-evenRow",e.fldHeader="ct2-fhead",e.colTxtFilterCont="ct2-filter",e.colTxtFilterLineCont="line",e.colTxtFilterIcon="filter-icon",e.multiline="multiline",e.multiselect="ct2-multisel",e.sbNotUsed="ct2-sb-not-used",e.sbMinimized="ct2-sb-minimized",e.sbNormal="ct2-sb-normal",e.rowDisplVisible="ct2-row-display-visible",e.rowDisplInvisible="ct2-row-display-invisible",e.emptyTab="ct2-empty-table",e.ctrlPanelMin="ct2-ctrl-panel-minimized",e.ctrlPanelNormal="ct2-ctrl-panel-normal",e.activeRow="ct2-active-row",e.touchDev="touch",e.noTouchDev="notouch",shmi.visuals.controls.ComplexTable2.c={},(e=shmi.visuals.controls.ComplexTable2.c).MIN_BUF_SIZE=150,e.CONST_LINE_HEIGHT=!1,e.DEBOUNCE_TO_RESIZE=150,e.DEFAULT_LINE_HEIGHT=20,e.MULTI_SELECT_MODE="3-state-clear",e.SCROLL_EVT_TYPE_NONE=-1,e.SCROLL_EVT_TYPE_TOUCH=11,e.SCROLL_EVT_TYPE_RELEASE=12,e.SCROLL_EVT_TYPE_SB_BTN_UP=101,e.SCROLL_EVT_TYPE_SB_BTN_DOWN=102,e.SCROLL_EVT_TYPE_SB_SLIDER_CHG=103,e.SCROLL_EVT_TYPE_SB_LARGE_CHG=104,e.SCROLL_EVT_TYPE_V_DRAG_UP=201,e.SCROLL_EVT_TYPE_V_DRAG_DOWN=202,e.SCROLL_EVT_TYPE_V_SWIPE_UP=301,e.SCROLL_EVT_TYPE_V_SWIPE_DOWN=302,e.SCROLL_EVT_TYPE_H_SWIPE_LEFT=401,e.SCROLL_EVT_TYPE_H_SWIPE_RIGHT=402,e.SCROLL_EVT_TYPE_RESIZE=501,e.SCROLL_EVT_TYPE_RESIZE_LAYOUT_CHG=502,e.SELECT_TYPE_NOTHING=-1,e.SELECT_TYPE_ALL=1,e.SELECT_TYPE_SEL_ROWS=2,e.CB_UNCHK=-1,e.CB_CHK=1,e.CB_UNDEF=2,e.NO_SORT=-1,e.SORT_UP=1,e.SORT_DOWN=2,shmi.visuals.controls.ComplexTable2.CheckBox.uiCssCl={},(e=shmi.visuals.controls.ComplexTable2.CheckBox.uiCssCl).sel="ct2-cb-sel",e.ck="ct2-cb-ck",e.unck="ct2-cb-unck",e.undef="ct2-cb-undef",shmi.visuals.controls.ComplexTable2.RowSelector.uiCssCl={},(e=shmi.visuals.controls.ComplexTable2.RowSelector.uiCssCl).sel="ct2-rs-sel",e.ck="ct2-rs-ck",e.unck="ct2-rs-unck",shmi.visuals.controls.ComplexTable2.FieldHeader.uiCssCl={},(e=shmi.visuals.controls.ComplexTable2.FieldHeader.uiCssCl).sel="ct2-fh-sel",e.sortUp="ct2-fh-sort-up",e.sortDn="ct2-fh-sort-down",e.noSort="ct2-fh-no-sort",e.sortable="ct2-fh-sortable"}(),function(){"use strict";const e={MODE:{FLOAT:null,STACKED:"stacked-layout",INLINE:"inline-layout",FLEX:"flex-layout",IQ_FLEX:"iq-flex-layout"},ALIGN:{HORIZONTAL:{LEFT:"left-aligned",CENTER:"centered",RIGHT:"right-aligned"},VERTICAL:{TOP:"top",MIDDLE:"middle",BOTTOM:"bottom"},PRIMARY:{START:"flex-primary-align-start",CENTER:"flex-primary-align-center",END:"flex-primary-align-end",SPACE_BETWEEN:"flex-primary-align-space-between",SPACE_AROUND:"flex-primary-align-space-around",SPACE_EVENLY:"flex-primary-align-space-evenly"},SECONDARY:{START:"flex-secondary-align-start",CENTER:"flex-secondary-align-center",END:"flex-secondary-align-end",STRETCH:"flex-secondary-align-stretch"},LINE:{START:"flex-line-align-start",CENTER:"flex-line-align-center",END:"flex-line-align-end",STRETCH:"flex-line-align-stretch",SPACE_BETWEEN:"flex-line-align-space-between",SPACE_AROUND:"flex-line-align-space-around"}},AUTO:{WIDTH:"auto-width",MARGIN:"auto-margin"},FLEX:{DISTRIBUTE:"distribute-evenly",WRAP:"flex-wrap",ALL:"flex-all",COLUMN:"column-orientation",NONE:"flex-none"}},t={"auto-width":[{value:!0,modifier:e.AUTO.WIDTH}],"auto-margin":[{value:!0,modifier:e.AUTO.MARGIN}],"h-alignment":[{value:"left",modifier:e.ALIGN.HORIZONTAL.LEFT},{value:"center",modifier:e.ALIGN.HORIZONTAL.CENTER},{value:"right",modifier:e.ALIGN.HORIZONTAL.RIGHT}],"v-alignment":[{value:"top",modifier:e.ALIGN.VERTICAL.TOP},{value:"middle",modifier:e.ALIGN.VERTICAL.MIDDLE},{value:"bottom",modifier:e.ALIGN.VERTICAL.BOTTOM}],"flex-orientation":[{value:"column",modifier:e.FLEX.COLUMN}],"flex-distribute":[{value:!0,modifier:e.FLEX.DISTRIBUTE}],"flex-all":[{value:!0,modifier:e.FLEX.ALL}],"flex-none":[{value:!0,modifier:e.FLEX.NONE}],"flex-wrap":[{value:!0,modifier:e.FLEX.WRAP}],"flex-primary-align":[{value:"start",modifier:e.ALIGN.PRIMARY.START},{value:"center",modifier:e.ALIGN.PRIMARY.CENTER},{value:"end",modifier:e.ALIGN.PRIMARY.END},{value:"space-between",modifier:e.ALIGN.PRIMARY.SPACE_BETWEEN},{value:"space-around",modifier:e.ALIGN.PRIMARY.SPACE_AROUND},{value:"space-evenly",modifier:e.ALIGN.PRIMARY.SPACE_EVENLY}],"flex-secondary-align":[{value:"start",modifier:e.ALIGN.SECONDARY.START},{value:"center",modifier:e.ALIGN.SECONDARY.CENTER},{value:"end",modifier:e.ALIGN.SECONDARY.END},{value:"stretch",modifier:e.ALIGN.SECONDARY.STRETCH}],"flex-line-align":[{value:"start",modifier:e.ALIGN.LINE.START},{value:"center",modifier:e.ALIGN.LINE.CENTER},{value:"end",modifier:e.ALIGN.LINE.END},{value:"stretch",modifier:e.ALIGN.LINE.STRETCH},{value:"space-between",modifier:e.ALIGN.LINE.SPACE_BETWEEN},{value:"space-around",modifier:e.ALIGN.LINE.SPACE_AROUND}]},i={float:{modifierSettings:["auto-width","auto-margin","h-alignment"]},stacked:{baseModifier:e.MODE.STACKED,modifierSettings:["auto-margin"]},inline:{baseModifier:e.MODE.INLINE,modifierSettings:["auto-width","auto-margin","h-alignment","v-alignment"]},flex:{baseModifier:e.MODE.FLEX,modifierSettings:["auto-width","auto-margin","flex-orientation","h-alignment","v-alignment","flex-distribute","flex-all","flex-none"]},iqflex:{baseModifier:e.MODE.IQ_FLEX,modifierSettings:["flex-orientation","flex-wrap","flex-primary-align","flex-secondary-align","flex-line-align","flex-none"]}};shmi.visuals.controls.Container=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","container"),shmi.def(this.config,"name",null),shmi.def(this.config,"type","stacked"),shmi.def(this.config,"auto-width",!1),shmi.def(this.config,"auto-margin",!1),shmi.def(this.config,"h-alignment","left"),shmi.def(this.config,"v-alignment","top"),shmi.def(this.config,"flex-orientation","row"),shmi.def(this.config,"flex-distribute",!1),shmi.def(this.config,"flex-all",!1),shmi.def(this.config,"flex-none",!1),shmi.def(this.config,"flex-wrap",!1),shmi.def(this.config,"flex-primary-align","start"),shmi.def(this.config,"flex-secondary-align","stretch"),shmi.def(this.config,"flex-line-align","start"),this.controls=[],this.marginCompensator=null,this.startup()},shmi.visuals.controls.Container.prototype={uiType:"container",isContainer:!0,getClassName:function(){return"Container"},onRegister:function(s){!function clearAllModifiers(t){[...Object.values(e.MODE),...Object.values(e.ALIGN.HORIZONTAL),...Object.values(e.ALIGN.VERTICAL),...Object.values(e.AUTO),...Object.values(e.FLEX)].filter(e=>null!==e).forEach(e=>shmi.removeClass(t,e))}(this.element),function applyModifiers(e,s){const n=i[s.type];n?(n.baseModifier&&shmi.addClass(e,n.baseModifier),n.modifierSettings.forEach(i=>{const n=t[i];if(!n||!Array.isArray(n))return void console.error("[Container]","missing modifier info:",i);const a=n.find(({value:e})=>s[i]===e);a&&shmi.addClass(e,a.modifier)})):console.error("[Container]","unknown layout type:",s.type)}(this.element,this.config),this.marginCompensator=function getMarginCompensator(e){let t=e.element.querySelector("div.margin-compensator"),i=null;return t&&t.parentNode===e.element||(t=document.createElement("DIV"),shmi.addClass(t,"margin-compensator"),i=e.element.innerHTML,e.element.innerHTML="",t.innerHTML=i,e.element.appendChild(t)),t}(this),this.parseChildren(this.marginCompensator,s)},onEnable:function(){this.controls.forEach(e=>e.enable())},onDisable:function(){this.controls.forEach(e=>e.disable())},onLock:function(){},onUnlock:function(){},onAddControl:function(e,t){const i=this,s=shmi.requires("visuals.tools.controller"),n=[];let a=null;if(!i.initialized)throw new Error("Control not initialized yet.");Array.isArray(e)||(e=[e]),e.forEach((function(e){const t=shmi.createControl(e.ui,i.marginCompensator,e.config,"DIV",null,!1);null!==t&&(e.style&&"object"==typeof e.style&&Object.assign(t.element.style,e.style),n.push(t))})),a=shmi.waitOnInit(n,(function(){if(a){const e=i._init_.tokens.indexOf(a);-1!==e&&i._init_.tokens.splice(e,1),a.unlisten(),a=null}const l=e.map((function(e,t){const a=n[t];return e.controller&&s.create(e.controller.name,e.controller,a.getName()),i.isActive()&&a.enable(),Array.isArray(e.children)&&e.children.length?new Promise(t=>{a.addControl(e.children,e=>t(e))}):Promise.resolve()}));Promise.all(l).then(e=>{const i=e.filter(e=>!!e);t(i.length?i[0]:null,n)})})),a&&i._init_.tokens.push(a)}},shmi.extend(shmi.visuals.controls.Container,shmi.visuals.core.BaseControl)}(),function(){"use strict";var e=shmi.requires("visuals.tools.logging").createLogger("datetime-display",!0,!1);e.fLog,e.log;function setText(e,t){e.element.textContent=t}var t={className:"datetime-display",uiType:"datetime-display",isContainer:!1,config:{"class-name":"text2 datetime-display",name:null,item:null,"display-utc":!1,"display-format":"$YYYY-$MM-$DD $HH:$mm:$ss","input-format":"$X","invalid-text":"---"},configSchema:null,vars:{subscriptionListener:null,localizedDisplayFormat:null,localizedInvalidText:null,rafRunning:!1,lastValue:null},imports:{im:"visuals.session.ItemManager",dtUtils:"visuals.tools.date"},events:[],prototypeExtensions:{onInit:function(){this.vars.localizedDisplayFormat=shmi.localize(this.config["display-format"]),this.vars.localizedInvalidText=shmi.localize(this.config["invalid-text"]),setText(this,this.vars.localizedInvalidText)},onEnable:function(){this.config.item&&!this.vars.subscriptionListener&&(this.vars.subscriptionListener=this.imports.im.subscribeItem(this.config.item,this))},onDisable:function(){this.vars.subscriptionListener&&this.vars.subscriptionListener.unlisten()},onSetValue:function(e,t){t===shmi.c("TYPE_INT")||t===shmi.c("TYPE_FLOAT")?this.vars.lastValue=this.imports.dtUtils.parseDateTime(String(e),this.config["input-format"]||"$X"):this.config["input-format"]?this.vars.lastValue=this.imports.dtUtils.parseDateTime(String(e),this.config["input-format"]):this.vars.lastValue=null,this.vars.rafRunning||(this.vars.rafRunning=!0,shmi.raf(function onDraw(){this.vars.lastValue?setText(this,this.imports.dtUtils.formatDateTime(this.vars.lastValue,{datestring:this.vars.localizedDisplayFormat,utc:this.config["display-utc"]})):setText(this,this.vars.localizedInvalidText),this.vars.rafRunning=!1}.bind(this)))}}};shmi.requires("visuals.tools.control-generator").generate(t)}(),shmi.pkg("visuals.controls"),shmi.visuals.controls.DialogBox=function(e,t){shmi.requires("visuals.gfx.Movable"),shmi.requires("visuals.io.MouseListener"),shmi.requires("visuals.io.TouchListener"),this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","dialog-box"),shmi.def(this.config,"template","default/dialog-box"),shmi.def(this.config,"name",null),shmi.def(this.config,"class-name","dialog-box"),shmi.def(this.config,"initial-state","hidden"),shmi.def(this.config,"collapsible",!1),shmi.def(this.config,"draggable",!1),shmi.def(this.config,"top-level",!1),shmi.def(this.config,"content-template",null),shmi.def(this.config,"tab-limit",!0),this.collapsed=!1,this.hidden=!0,this.active=!1,this.controls=[],this.childrenParsed=!1,this.bgDiv=null,this.dragging=!1,this.mouselistener=null,this.touchlistener=null,this.contentElement=null,this.originalParent=null,this.tokens=[],this.element.style.visibility="hidden",this.startup()},shmi.visuals.controls.DialogBox.prototype={uiType:"dialog-box",isContainer:!0,getClassName:function(){return"DialogBox"},events:["open","close"],onTemplate:function(e,t,i){var s=this;if(t)i();else if(s.element.innerHTML=e,s.contentElement=shmi.getUiElement("dialog-box-content",s.element),s.contentElement&&s.config["content-template"]){var n=0===s.config["content-template"].indexOf(shmi.c("RES_URL_PREFIX"))?s.config["content-template"]:shmi.c("TEMPLATE_PATH")+s.config["content-template"]+shmi.c("TEMPLATE_EXT");shmi.loadResource(n,(function(e,t){t||(s.contentElement.innerHTML=e),i()}))}else i()},onRegister:function(e){this.contentElement?this.parseChildren(this.contentElement,e):e()},onInit:function(){var e=this,t=shmi.requires("visuals.tools.iterate.iterateNodeList");if(e.contentElement&&t(shmi.getUiElements("button",e.element),(function(t){t.parentNode&&!shmi.testParentChild(e.contentElement,t)&&(shmi.createControl("button",t,{},"DIV","from").onClick=function(){e.hide()})})),this.titleElement=shmi.getUiElement("dialog-box-title",this.element),this.titleElement||shmi.log("[DialogBox] no dialog-box-title element provided",1),this.frameElement=shmi.getUiElement("dialog-box-frame",this.element),this.frameElement)if(this.hidden="visible"!==this.config["initial-state"],this.hidden&&shmi.addClass(this.element,"hidden"),this.element.style.visibility="",this.containerElement=shmi.getUiElement("dialog-content",this.element),this.containerElement){this.element.setAttribute("tabindex","-1"),this.mover=new shmi.visuals.gfx.Movable(this.containerElement),this.mover.priority=!0;var i={};i.onClick=function(e,t){this.config["close-on-click"]&&this.hide()}.bind(this),!0===this.config.draggable&&(i.onDrag=function(e,t,i){i.preventDefault(),this.mover.translate(e,t);for(var s=0;s<this.controls.length;s++)try{this.controls[s].offsetX=this.mover.startX+this.mover.tx}catch(e){shmi.log("[Dialog-Box] - Can not set control offset",2)}this.dragging||(this.dragging=!0)}.bind(this)),i.onRotate=function(e){this.config["rotation-enabled"]&&this.mover.rotate(57.3*e)}.bind(this),i.onScale=function(e){this.config["scaling-enabled"]&&this.mover.scale(e)}.bind(this),this.titleElement&&this.config.title&&(this.titleElement.textContent=shmi.localize(this.config.title)),i.onPress=function(e,t,i){shmi.addClass(this.element,"pressed"),document.activeElement!==this.element&&this.element.focus(),shmi.log("[DialogBox] pressed",1)}.bind(this),i.onRelease=function(){this.dragging=!1,shmi.removeClass(this.element,"pressed"),shmi.log("[DialogBox] released",1)}.bind(this),this.mouselistener=new shmi.visuals.io.MouseListener(this.containerElement,i),this.touchlistener=new shmi.visuals.io.TouchListener(this.containerElement,i)}else shmi.log("[DialogBox] no dialog-content element provided",3);else shmi.log("[DialogBox] no dialog-box-frame element provided",3)},show:function(){if(this.active){if(this.hidden){if(this.hidden=!1,!0===this.config["top-level"]&&(this.originalParent=this.element.parentNode,this.element=document.body.appendChild(this.element)),this.config["cover-background"]&&(this.bgDiv?shmi.removeClass(this.bgDiv,"hidden"):(this.bgDiv=document.createElement("div"),shmi.addClass(this.bgDiv,"dialog-box-overlay"),this.bgDiv.setAttribute("tabindex","-1"),document.body.appendChild(this.bgDiv),shmi.removeClass(this.bgDiv,"hidden"))),shmi.removeClass(this.element,"hidden"),this.config["tab-limit"]){var e=shmi.requires("visuals.tools.tabulator");this.tabLimit=e.setTabParent(this.element)}this.enableControls(),this.fire("open",{})}}else shmi.log("[DialogBox] cannot show dialog-box without enabling it first",3)},hide:function(){this.hidden||(this.hidden=!0,this.config["leave-controls-enabled"]||this.disableControls(),!0===this.config["top-level"]&&(this.element=this.originalParent.appendChild(this.element)),shmi.addClass(this.element,"hidden"),this.tabLimit&&(this.tabLimit.unsetTabParent(),this.tabLimit=null),this.reset(),this.config["cover-background"]&&this.bgDiv&&shmi.addClass(this.bgDiv,"hidden"),this.fire("close",{}))},reset:function(){this.active&&this.mover&&(this.mover.tx=0,this.mover.ty=0,this.mover.rot=0,this.mover.s=1,this.mover.sx=1,this.mover.sy=1,this.mover.update())},onEnable:function(){var e=this;e.mouselistener.enable(),e.touchlistener.enable(),e.tokens.push(shmi.listen("enable",(function(t){-1!==t.source.getName().indexOf(e.getName())&&t.source.getName()!==e.getName()&&"close"===t.source.element.getAttribute("data-function")&&(t.source.onClick=function onClick(){e.hide()})}),{"source.uiType":"button"})),e.hidden||(e.hidden=!0,e.show())},onDisable:function(){this.hide(),this.mouselistener.disable(),this.touchlistener.disable(),this.bgDiv&&(this.bgDiv.parentNode.removeChild(this.bgDiv),this.bgDiv=null),this.tokens.forEach((function(e){e.unlisten()})),this.tokens=[]},enableControls:function(){for(var e=0;e<this.controls.length;e++)try{this.controls[e].enable()}catch(t){console.error("[DialogBox]","error enabling control:",this.controls[e],this.getName(),"Exception:",t)}},disableControls:function(){for(var e=0;e<this.controls.length;e++)try{this.controls[e].disable()}catch(t){console.error("[DialogBox]","error disabling control:",this.controls[e],this.getName(),"Exception:",t)}},onAddControl:function(e,t){var i=this,s=shmi.requires("visuals.tools.controller"),n=[],a="["+i.getClassName()+"] ",l=null;if(!i.initialized)throw new Error(a+"Control not initialized yet.");Array.isArray(e)||(e=[e]),i.contentElement?(e.forEach((function(e){var t=shmi.createControl(e.ui,i.contentElement,e.config,"DIV",null,!1);if(null!==t){if(e.style&&"object"==typeof e.style){shmi.requires("visuals.tools.iterate.iterateObject")(e.style,(e,i)=>{t.element.style[i]=e})}n.push(t)}})),(l=shmi.waitOnInit(n,(function(){var a=-1,o=[],r=shmi.requires("visuals.task"),c=[],u=null;l&&(-1!==(a=i._init_.tokens.indexOf(l))&&i._init_.tokens.splice(a,1),l.unlisten(),l=null),e.forEach((function(e,t){var a=null,l=n[t];e.controller&&s.create(e.controller.name,e.controller,l.getName()),i.isActive()&&!i.hidden&&l.enable(),Array.isArray(e.children)&&e.children.length&&((a=r.createTask("child control")).run=function(){l.addControl(e.children,(function(e,t){e&&o.push(e),a.complete()}))},c.push(a))})),c.length?((u=r.createTaskList(c,!1)).onComplete=function(){t(o.length?o[0]:null,n)},u.run()):t(o.length?o[0]:null,n)})))&&i._init_.tokens.push(l)):t(new Error(a+"Content element missing from template."),n)}},shmi.extend(shmi.visuals.controls.DialogBox,shmi.visuals.core.BaseControl),function(){"use strict";var e=shmi.requires("visuals.tools.logging").createLogger("duration-display",!0,!1);e.fLog,e.log;function setText(e,t){e.element.textContent=t}function makeItemHandler(e,t,i){return{setValue:function setValue(s,n){n===shmi.c("TYPE_INT")||n===shmi.c("TYPE_FLOAT")?e.vars[i]=e.imports.dtUtils.parseDateTime(String(s),e.config[t]||"$X"):e.config[t]?e.vars[i]=e.imports.dtUtils.parseDateTime(String(s),e.config[t]):e.vars[i]=null,function doUpdate(e){null===e.vars.tsTarget||null===e.vars.tsCurrent?e.vars.lastValue=null:e.vars.lastValue=e.vars.tsTarget-e.vars.tsCurrent,e.vars.rafRunning||(e.vars.rafRunning=!0,shmi.raf((function onDraw(){e.vars.lastValue?setText(e,e.imports.dtUtils.formatDuration(e.vars.lastValue,e.config["display-preset"]||"compact")):setText(e,e.vars.localizedInvalidText),e.vars.rafRunning=!1})))}(e)}}}var t={className:"duration-display",uiType:"duration-display",isContainer:!1,config:{"class-name":"text2 duration-display",name:null,"target-ts-item":null,"target-ts-format":"$X","current-ts-item":"Systemzeit","current-ts-format":"$X","display-preset":"compact","invalid-text":"---"},configSchema:null,vars:{subscriptions:[],tsTarget:null,tsCurrent:null,localizedInvalidText:null,rafRunning:!1,lastValue:null},imports:{im:"visuals.session.ItemManager",dtUtils:"visuals.tools.date"},events:[],prototypeExtensions:{onInit:function(){this.vars.localizedInvalidText=shmi.localize(this.config["invalid-text"]),setText(this,this.vars.localizedInvalidText)},onEnable:function(){this.config["target-ts-item"]&&this.config["current-ts-item"]&&0===this.vars.subscriptions.length&&(this.vars.subscriptions.push(this.imports.im.subscribeItem(this.config["target-ts-item"],makeItemHandler(this,"target-ts-format","tsTarget"))),this.vars.subscriptions.push(this.imports.im.subscribeItem(this.config["current-ts-item"],makeItemHandler(this,"current-ts-format","tsCurrent"))))},onDisable:function(){this.vars.subscriptions.forEach((function(e){e.unlisten()})),this.vars.subscriptions=[]}}};shmi.requires("visuals.tools.control-generator").generate(t)}(),shmi.pkg("visuals.controls"),shmi.visuals.controls.FlipSwitch=function(e,t){shmi.requires("visuals.io.MouseListener"),shmi.requires("visuals.io.TouchListener"),shmi.requires("visuals.gfx.Movable"),this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","flip-switch"),shmi.def(this.config,"template","default/flip-switch"),shmi.def(this.config,"name",null),shmi.def(this.config,"label","flip-switch"),shmi.def(this.config,"on-label","I"),shmi.def(this.config,"off-label","O"),shmi.def(this.config,"on-value",1),shmi.def(this.config,"off-value",0),shmi.def(this.config,"transitionStyle","all .16s linear"),shmi.def(this.config,"confirm-off-text","${V_CONFIRM_OFF}"),shmi.def(this.config,"confirm-on-text","${V_CONFIRM_ON}"),shmi.def(this.config,"confirm-on",!1),shmi.def(this.config,"confirm-off",!1),shmi.def(this.config,"icon-src",null),shmi.def(this.config,"icon-title",null),shmi.def(this.config,"icon-class",null),shmi.def(this.config,"auto-label",!0),this.config["show-icon"]=shmi.toBoolean(this.config["show-icon"]),this.value=0,this.active=!1,this.initialized=!1,this._subscriptionTargetId=null,this.movable=null,this._dragging=!1,this.startup()},shmi.visuals.controls.FlipSwitch.prototype={uiType:"flip-switch",getClassName:function(){return"FlipSwitch"},events:["change"],tooltipProperties:["icon-title"],onInit:function(){var e=this,t=shmi.getUiElement("flip-switch-icon",e.element);if(t){if(e.config["icon-src"])try{t.setAttribute("src",e.config["icon-src"])}catch(e){shmi.log("[Flip Switch] Exception setting icon-src: "+e,2)}else if(e.config["icon-class"]){if("IMG"===t.tagName){var i=document.createElement("div");shmi.addClass(i,"flip-switch-icon"),t.parentNode.insertBefore(i,t),t.parentNode.removeChild(t),t=i}e.config["icon-class"].trim().split(" ").forEach((function(e){shmi.addClass(t,e)}))}}else shmi.log("[Flip Switch] no button-icon element provided",1);if(this.handleElement=shmi.getUiElement("flip-switch-handle",this.element),this.handleElement)if(this.handleBoxElement=shmi.getUiElement("handle-box",this.element),this.handleBoxElement){shmi.log("[FlipSwitch] flip-switch width: "+this.handleBoxElement.offsetWidth,0),shmi.log("[FlipSwitch] handle width: "+this.handleElement.offsetWidth,0),this.labelElement=shmi.getUiElement("label",this.element),this.labelElement||shmi.log("[FlipSwitch] no label element provided (optional)",1),this.onLabelElement=shmi.getUiElement("flip-switch-label-on",this.element),this.onLabelElement||shmi.log("[FlipSwitch] no flip-switch-label-on element provided (optional)",1),this.offLabelElement=shmi.getUiElement("flip-switch-label-off",this.element),this.offLabelElement||shmi.log("[FlipSwitch] no flip-switch-label-off element provided (optional)",1),this.onLabelElement&&this.config["on-label"]&&(this.onLabelElement.textContent=shmi.localize(this.config["on-label"])),this.offLabelElement&&this.config["off-label"]&&(this.offLabelElement.textContent=shmi.localize(this.config["off-label"])),this.labelElement&&this.config.label&&(this.labelElement.textContent=shmi.localize(this.config.label)),this.width=this.handleBoxElement.offsetWidth,this.handleWidth=this.handleElement.offsetWidth,this.movable=new shmi.visuals.gfx.Movable(this.handleElement),this.movable.setTransition(!0),this.movable.transitionStyle=this.config.transitionStyle;var s={};s.onDrag=function(e,t,i){i.preventDefault(),this.movable.tx+e>=0&&this.movable.tx+e+this.handleWidth<=this.handleBoxElement.offsetWidth&&(this._dragging||(this._dragging=!0),this.movable.translate(e,0))}.bind(this),s.onPress=function(){this.movable.setTransition(!1),shmi.addClass(this.handleElement,"pressed")}.bind(this),s.onRelease=function(){this._dragging&&(this._dragging=!1,this.movable.tx>(this.handleBoxElement.offsetWidth-this.handleElement.offsetWidth)/2?this.config["confirm-on"]?shmi.confirm(this.config["confirm-on-text"],(function(t){t?(e.movable.tx=e.handleBoxElement.offsetWidth-e.handleElement.offsetWidth,e.config.item?shmi.visuals.session.ItemManager.writeValue(e.config.item,e.config["on-value"]):e.setValue(e.config["on-value"])):e.setValue(e.value)})):(this.movable.tx=this.handleBoxElement.offsetWidth-this.handleElement.offsetWidth,this.config.item?shmi.visuals.session.ItemManager.writeValue(this.config.item,this.config["on-value"]):this.setValue(this.config["on-value"])):this.config["confirm-off"]?shmi.confirm(this.config["confirm-off-text"],(function(t){t?(e.movable.tx=0,e.config.item?shmi.visuals.session.ItemManager.writeValue(e.config.item,e.config["off-value"]):e.setValue(e.config["off-value"])):e.setValue(e.value)})):(this.movable.tx=0,this.config.item?shmi.visuals.session.ItemManager.writeValue(this.config.item,this.config["off-value"]):this.setValue(this.config["off-value"])),this.movable.update()),this.movable.setTransition(!0),shmi.removeClass(this.handleElement,"pressed")}.bind(this),s.onClick=function(){this.value===this.config["on-value"]?this.config["confirm-off"]?shmi.confirm(this.config["confirm-off-text"],(function(t){t&&(e.config.item?shmi.visuals.session.ItemManager.writeValue(e.config.item,e.config["off-value"]):e.setValue(e.config["off-value"]))})):this.config.item?shmi.visuals.session.ItemManager.writeValue(this.config.item,this.config["off-value"]):this.setValue(this.config["off-value"]):this.config["confirm-on"]?shmi.confirm(this.config["confirm-on-text"],(function(t){t&&(e.config.item?shmi.visuals.session.ItemManager.writeValue(e.config.item,e.config["on-value"]):e.setValue(e.config["on-value"]))})):this.config.item?shmi.visuals.session.ItemManager.writeValue(this.config.item,this.config["on-value"]):this.setValue(this.config["on-value"])}.bind(this);var n={};n.onClick=s.onClick,this.mouseListener=new shmi.visuals.io.MouseListener(this.handleElement,s),this.touchListener=new shmi.visuals.io.TouchListener(this.handleElement,s),this.mouseListener2=new shmi.visuals.io.MouseListener(this.handleBoxElement,n),this.touchListener2=new shmi.visuals.io.TouchListener(this.handleBoxElement,n)}else shmi.log("[FlipSwitch] no handle-box element provided (required)",3);else shmi.log("[FlipSwitch] no flip-switch-handle element provided (required)",3)},onEnable:function(){this.width=this.handleBoxElement.offsetWidth,this.handleWidth=this.handleElement.offsetWidth,this.config.item&&(this._subscriptionTargetId=shmi.visuals.session.ItemManager.subscribeItem(this.config.item,this)),shmi.log("[FlipSwitch] hwidth: "+this.handleWidth+" width: "+this.handleBoxElement.offsetWidth,0),this.mouseListener.enable(),this.touchListener.enable(),this.mouseListener2.enable(),this.touchListener2.enable(),shmi.log("[FlipSwitch] enabled",1)},onDisable:function(){this.config.item&&shmi.visuals.session.ItemManager.unsubscribeItem(this.config.item,this._subscriptionTargetId),this.mouseListener.disable(),this.touchListener.disable(),this.mouseListener2.disable(),this.touchListener2.disable(),shmi.log("[FlipSwitch] disabled",1)},onLock:function(){shmi.log("[FlipSwitch] locked",1),this.mouseListener.disable(),this.touchListener.disable(),this.mouseListener2.disable(),this.touchListener2.disable(),shmi.addClass(this.element,"locked")},onUnlock:function(){shmi.log("[FlipSwitch] unlocked",1),this.mouseListener.enable(),this.touchListener.enable(),this.mouseListener2.enable(),this.touchListener2.enable(),shmi.removeClass(this.element,"locked")},onSetValue:function(e){if(!this._dragging){var t=!1,i=this.value;e===this.config["on-value"]?(this.value=this.config["on-value"],shmi.addClass(this.element,"on"),t=!0):(this.value=this.config["off-value"],shmi.removeClass(this.element,"on")),this.movable.tx=t?this.handleBoxElement.offsetWidth-this.handleWidth:0,i!==this.value&&(this.fire("change",{value:this.value}),this.onChange&&this.onChange(this.value)),this.movable.update()}},getValue:function(){return this.value},setLabel:function(e){this.labelElement&&this.config["auto-label"]&&(this.labelElement.textContent=shmi.localize(e))}},shmi.extend(shmi.visuals.controls.FlipSwitch,shmi.visuals.core.BaseControl),shmi.pkg("visuals.controls"),shmi.visuals.controls.Form=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","form"),shmi.def(this.config,"name",null),shmi.def(this.config,"template",null),shmi.def(this.config,"fields",[]),shmi.def(this.config,"id-selector",null),shmi.def(this.config,"datagrid",null),this.values=[],this.controls=[],this.fieldItems=[],this.fieldControls={},this.loadedFields={},this.applyCallback=null,this.cancelCallback=null,this.sel_list_id=null,this.startup()},shmi.visuals.controls.Form.prototype={uiType:"form",isContainer:!0,getClassName:function(){return"Form"},onInit:function(){},onRegister:function(e){var t=this,i=Date.now(),s=null,n=shmi.visuals.session;for(n.FormIDs=n.FormIDs||[];-1!==n.FormIDs.indexOf(i);)i++;n.FormIDs.push(i),t.form_id=i,s=shmi.listen("register-name",(function(e){var i=e.source;if(shmi.testParentChild(t.element,i.element)&&-1!==t.config.fields.indexOf(i.config.field)&&!t.loadedFields[i.config.field]){t.fieldControls[i.config.field]=i;var s="virtual:form:"+t.form_id+":"+i.config.field;i.setItem(s),t.loadedFields[i.config.field]=!0}})),t._init_.tokens.push(s),t.parseChildren(t.element,(function(){s.unlisten(),t._init_.tokens.splice(t._init_.tokens.indexOf(s),1),s=null,e()}))},setValues:function(e,t,i,s){if(this.initialized)if(s||0===this.checkModified()){this.values=e,this.applied=!1,this.canceled=!1,this.values.length!==Object.keys(this.fieldControls).length&&shmi.log("[Form] values length ("+this.values.length+") does not match number of controls("+Object.keys(this.fieldControls).length+")",2),this.deleteFieldItems();for(var n=0;n<this.values.length;n++)if(Array.isArray(this.values[n])){if(2!==this.values[n].length){shmi.log("[Form] invalid value set: "+this.values[n],2);continue}try{this.controls[n].type=parseInt(this.values[n][1]),this.controls[n].setValue(this.values[n][0]),shmi.log("[Form] value set: "+this.values[n][0],2)}catch(e){shmi.log("[Form] exception setting form data: "+e,3)}}else{var a=this.values[n],l="virtual:form:"+this.form_id+":"+a.field;null!==a.type&&void 0!==a.type||(a.type=shmi.c("TYPE_STRING"));var o=shmi.createVirtualItem(l,a.type,Number.NaN,Number.NaN,a.value,this.getFieldValueCallback(a.field));this.fieldItems.push(o),o.writeValue(a.value),a.modified=!1,o.notifyUpdateTargets(),void 0!==this.fieldControls[a.field]&&shmi.removeClass(this.fieldControls[a.field].element,"modified")}if(t)this.applyCallback=t,0!==this.checkModified()&&this.onChange&&this.onChange(this);i&&(this.cancelCallback=i),this.unlock()}else shmi.askSave("${V_ASK_SAVE_MSG}",function(s,n){!0===s?(shmi.log("[Form] applying changes...",shmi.c("LOG_MSG")),this.apply()):shmi.log("[Form] discarding changes...",shmi.c("LOG_MSG")),!0===n?this.setValues(e,t,i,!0):this.unlock()}.bind(this))},deleteFieldItems:function(){this.fieldItems=[]},getFieldValueCallback:function(e){return function(t,i,s){for(var n=e,a=0;a<this.values.length;a++)if(this.values[a].field===n){this.values[a].value!==t?(void 0!==this.fieldControls[n]&&shmi.addClass(this.fieldControls[n].element,"modified"),this.values[a].modified=!0):(void 0!==this.fieldControls[n]&&shmi.removeClass(this.fieldControls[n].element,"modified"),this.values[a].modified=!1);break}this.onChange&&this.onChange(this)}.bind(this)},checkModified:function(){var e=0;void 0===this.values&&(this.values=[]);for(var t=0;t<this.values.length;t++)!0===this.values[t].modified&&e++;return e},apply:function(){var e;for(e=0;e<this.values.length;e++)try{this.values[e].value=this.fieldControls[this.values[e].field].getValue()}catch(e){shmi.log("[Form] control has no value: "+e.toString(),2)}for(this.applied=!0,this.applyCallback?this.applyCallback(this.values):shmi.log("[Form] no apply callback defined",2),e=0;e<this.values.length;e++)void 0!==this.fieldControls[this.values[e].field]&&shmi.removeClass(this.fieldControls[this.values[e].field].element,"modified"),this.values[e].modified=!1},cancel:function(){this.canceled=!0,this.cancelCallback&&this.cancelCallback()},onEnable:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].enable();if(this.config["id-selector"]&&(this.id_selector=shmi.ctrl(this.config["id-selector"]),this.id_selector)){var t=this,i={tableSelectionChange:function(e){t.setDataGridSelection(e)}};i.tableSelectionChange(t.id_selector.getSelectedRows()),this.sel_list_id=this.id_selector.addSelChgEventListener(i)}shmi.log("[Form] enabled",1)},getFormReset:function(e){var t=this;return function(){t.setValues(e,t.applyCallback,t.cancelCallback,!0)}},setDataGridSelection:function(e){var t,i=shmi.visuals.session.DataGridManager;if(2===e.type&&e.selRows.length>0&&this.config.datagrid){this.unlock();var s=i.grids[this.config.datagrid];if(s){var n,a=[];if(e.selRows.length>1)for(var l=s.getRowData(e.selRows[0]),o=0;o<l.length;o++){for(var r=!0,c=null,u=0;u<e.selRows.length;u++){if(n=s.getRowData(e.selRows[u]),0!==u){if(n[o].value===c)continue;r=!1;break}c=n[o].value}r?a.push({value:c,field:s.fields[o]}):a.push({value:"",field:s.fields[o]})}else for(n=s.getRowData(e.selRows[0]),t=0;t<n.length;t++)a.push({value:n[t].value,field:s.fields[t]});this.setValues(a,this.getDataGridApply(s,e.selRows),this.getFormReset(a),!1)}}else{var h=[];for(t=0;t<this.config.fields.length;t++){var m={type:shmi.c("TYPE_STRING"),field:this.config.fields[t],value:""};h.push(m)}this.setValues(h,null,null),this.lock()}},getDataGridApply:function(e,t){var i,s=this,apply_row=function(n){for(i=0;i<s.config.fields.length;i++){var a=s.fieldControls[s.config.fields[i]];if(a&&s.values[i].modified){var l=e.fields.indexOf(s.config.fields[i]);-1!==l&&e.data[t[n]][l].item.writeValue(a.getValue())}}};return 1===t.length?function(){apply_row(0)}:t.length>1?function(){for(i=0;i<t.length;i++)apply_row(i)}:function(){console.trace("NO_SELECT_STUB")}},onDisable:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].disable();null!==this.sel_list_id&&this.id_selector&&(this.id_selector.removeSelChgEventListener(this.sel_list_id),this.sel_list_id=null),this.field_ctrl_lid&&(shmi.unlisten("register-name",this.field_ctrl_lid),this.field_ctrl_lid=null),shmi.log("[Form] disabled",1)},onLock:function(){function recLock(e){e.lock(),Array.isArray(e.controls)&&e.controls.forEach(recLock)}shmi.addClass(this.element,"locked"),this.controls.forEach((function(e){recLock(e)})),shmi.log("[Form] locked",1)},onUnlock:function(){function recUnlock(e){e.unlock(),Array.isArray(e.controls)&&e.controls.forEach(recUnlock)}shmi.removeClass(this.element,"locked"),this.controls.forEach((function(e){recUnlock(e)})),shmi.log("[Form] unlocked",1)},onSetValue:function(e){shmi.log("[Form] value set: "+e,0)}},shmi.extend(shmi.visuals.controls.Form,shmi.visuals.core.BaseControl),shmi.pkg("visuals.controls"),shmi.visuals.controls.GpScrollBar=function(e,t){this.c=shmi.visuals.controls.GpScrollBar.c,this.uiElName=shmi.visuals.controls.GpScrollBar.uiElName,this.uiCssCl=shmi.visuals.controls.GpScrollBar.uiCssCl,this.element=e,this.config=t||{},shmi.def(this.config,"class-name","gp-scroll-bar"),shmi.def(this.config,"template","default/gp-scroll-bar"),shmi.def(this.config,"name","Unnamed GpScrollBar"),shmi.def(this.config,"label","Label?"),shmi.def(this.config,"max",100),shmi.def(this.config,"min",0),shmi.def(this.config,"precision",0),shmi.def(this.config,"step",0),shmi.def(this.config,"vertical",!0),shmi.def(this.config,"buttons",!0),shmi.def(this.config,"inverse",!1),this.parseAttributes(),this.isMinimized=!1,this.isEnabled=!1,this.min=0,this.max=0,this.sliderVal=0,this.sliderWidth=0,this.sliderTrackElem=null,this.sliderHandleElem=null,this.sliderHandleVisibleElem=null,this.sliderHandleMovable=null,this.btnUpElem=null,this.btnDownElem=null,this.sliderHandleMouseListener=null,this.sliderHandleTouchListener=null,this.sliderTrackMouseListener=null,this.sliderTrackTouchListener=null,this.btnUpMouseListener=null,this.btnUpTouchListener=null,this.btnDownMouseListener=null,this.btnDownTouchListener=null,this.sbEventListeners={},this.enableTO=null,this.btnStartAutoRepeatTO=null,this.btnProcessAutoRepeatTO=null,this.isBtnAutoRepeatProcessing=!1,this.debug={},this.debug.msgFIFO=[],this.testlog_msg("startup"),this.startup()},shmi.visuals.controls.GpScrollBar.prototype={uiType:"gp-scroll-bar",getClassName:function(){return"GpScrollBar"},onInit:function(){if(this.config.max=shmi.toNumber(this.config.max),this.config.min=shmi.toNumber(this.config.min),this.config.precision=shmi.toNumber(this.config.precision),this.config.step=shmi.toNumber(this.config.step),this.config.vertical=shmi.toBoolean(this.config.vertical),this.config.buttons=shmi.toBoolean(this.config.buttons),this.config.inverse=shmi.toBoolean(this.config.inverse),this.min=this.config.min,this.max=this.config.max,this.sliderVal=this.min,this.sliderWidth=(this.max-this.min)/10,this.sliderTrackElem=shmi.getUiElement(this.uiElName.sliderTrack,this.element),this.sliderTrackElem)if(this.sliderHandleElem=shmi.getUiElement(this.uiElName.sliderHandle,this.element),this.sliderHandleElem)if(this.sliderHandleMovable=new shmi.visuals.gfx.Movable(this.sliderHandleElem),shmi.addClass(this.sliderHandleElem,this.uiCssCl.sliderAni),this.sliderHandleVisibleElem=shmi.getUiElement(this.uiElName.sliderHandleVisible,this.element),this.sliderHandleVisibleElem){if(this.config.buttons){if(shmi.addClass(this.element,this.uiCssCl.withBtns),this.btnUpElem=shmi.getUiElement(this.uiElName.btnUp,this.element),!this.btnUpElem)return void shmi.log("[GpScrollBar] no "+this.uiElName.btnUp+" element provided (required)",3);if(this.btnDownElem=shmi.getUiElement(this.uiElName.btnDown,this.element),!this.btnDownElem)return void shmi.log("[GpScrollBar] no "+this.uiElName.btnDown+" element provided (required)",3)}else{shmi.addClass(this.element,this.uiCssCl.withoutBtns);var e=shmi.getUiElement(this.uiElName.btnPanel,this.element);e&&e.parentNode.removeChild(e)}var t={};t.onDrag=function(e,t,i){i.preventDefault(),this.updateVal(this.sliderHandleMovable.ty+t),this.updateSlider(),this.fireValChanged(this.sliderVal,!1)}.bind(this),t.onPress=function(){shmi.removeClass(this.sliderHandleElem,this.uiCssCl.sliderAni),shmi.addClass(this.sliderHandleVisibleElem,this.uiCssCl.btnSel)}.bind(this),t.onRelease=function(){shmi.addClass(this.sliderHandleElem,this.uiCssCl.sliderAni),shmi.removeClass(this.sliderHandleVisibleElem,this.uiCssCl.btnSel)}.bind(this),this.sliderHandleMouseListener=new shmi.visuals.io.MouseListener(this.sliderHandleElem,t),this.sliderHandleTouchListener=new shmi.visuals.io.TouchListener(this.sliderHandleElem,t);var i={};if(i.onPress=function(e,t,i){shmi.addClass(this.sliderTrackElem,this.uiCssCl.trackSel)}.bind(this),i.onRelease=function(){shmi.removeClass(this.sliderTrackElem,this.uiCssCl.trackSel)}.bind(this),i.onClick=function(e,t,i){var s=t-shmi.getAbsPosition(this.sliderTrackElem).y;this.updateVal(s),this.updateSlider(),this.fireValChanged(this.sliderVal,!0)}.bind(this),this.sliderTrackMouseListener=new shmi.visuals.io.MouseListener(this.sliderTrackElem,i),this.sliderTrackTouchListener=new shmi.visuals.io.TouchListener(this.sliderTrackElem,i),this.btnUpElem){var s={};s.onPress=function(){shmi.addClass(this.btnUpElem,this.uiCssCl.btnSel),this.btnStartAutoRepeatTO&&clearTimeout(this.btnStartAutoRepeatTO),this.btnStartAutoRepeatTO=setTimeout(function(){this.startBtnAutoRepeat("up")}.bind(this),this.c.START_BTN_AUTO_REPEAT_TO),this.fireBtnAction("up")}.bind(this),s.onRelease=function(){this.btnStartAutoRepeatTO&&clearTimeout(this.btnStartAutoRepeatTO),this.stopBtnAutoRepeat(),shmi.removeClass(this.btnUpElem,this.uiCssCl.btnSel)}.bind(this),this.btnUpMouseListener=new shmi.visuals.io.MouseListener(this.btnUpElem,s),this.btnUpTouchListener=new shmi.visuals.io.TouchListener(this.btnUpElem,s);var n={};n.onPress=function(){shmi.addClass(this.btnDownElem,this.uiCssCl.btnSel),this.btnStartAutoRepeatTO&&clearTimeout(this.btnStartAutoRepeatTO),this.btnStartAutoRepeatTO=setTimeout(function(){this.startBtnAutoRepeat("down")}.bind(this),this.c.START_BTN_AUTO_REPEAT_TO),this.fireBtnAction("down")}.bind(this),n.onRelease=function(){this.btnStartAutoRepeatTO&&clearTimeout(this.btnStartAutoRepeatTO),this.stopBtnAutoRepeat(),shmi.removeClass(this.btnDownElem,this.uiCssCl.btnSel)}.bind(this),this.btnDownMouseListener=new shmi.visuals.io.MouseListener(this.btnDownElem,n),this.btnDownTouchListener=new shmi.visuals.io.TouchListener(this.btnDownElem,n)}this.resizeListener=function(){this.processEvtOnResize()}.bind(this),shmi.log("[GpScrollBar] initialized",1)}else shmi.log("[GpScrollBar] no "+this.uiElName.sliderHandleVisibleElem+" provided (required)",3);else shmi.log("[GpScrollBar] no "+this.uiElName.sliderHandle+" provided (required)",3);else shmi.log("[GpScrollBar] no "+this.uiElName.sliderTrack+" element provided (required)",3)},onEnable:function(){this.testlog_msg("onEnable"),window.addEventListener("resize",this.resizeListener,!0),this.updateSlider(),this.isEnabled=!0,this.updateEvtEnable(),shmi.log("[GpScrollBar] enabled",1)},onDisable:function(){this.testlog_msg("onEnable"),window.removeEventListener("resize",this.resizeListener,!0),this.isEnabled=!1,this.updateEvtEnable(),shmi.log("[GpScrollBar] disabled",1)},onDelete:function(){},setSliderVal:function(e){this.sliderVal=e,this.updateSlider(),shmi.log("[GpScrollBar] setSliderVal called, val: "+e,1)},setSliderWidth:function(e){this.sliderWidth=e,this.updateSlider(),shmi.log("[GpScrollBar] setSliderWidth called, width: "+e,1)},setSliderProps:function(e,t){this.sliderVal=e,this.sliderWidth=t,this.updateSlider(),shmi.log("[GpScrollBar] setSliderProps called, val: "+e+" - width: "+t,1)},getSliderVal:function(){return shmi.log("[GpScrollBar] getSliderVal called, return: "+this.sliderVal,1),this.sliderVal},getSliderWidth:function(){return shmi.log("[GpScrollBar] getSliderVal called, return: "+this.sliderWidth,1),this.sliderWidth},setMin:function(e){this.min=e,this.updateSlider(),shmi.log("[GpScrollBar] setMin called, min: "+e,1)},setMax:function(e){this.max=e,this.updateSlider(),shmi.log("[GpScrollBar] setMax called, min: "+e,1)},setMinMax:function(e,t){this.min=e,this.max=t,this.updateSlider(),shmi.log("[GpScrollBar] setMinMax called, min: "+e+" - max: "+t,1)},getMin:function(){return shmi.log("[GpScrollBar] getMin called, return: "+this.min,1),this.min},getMax:function(){return shmi.log("[GpScrollBar] getMax called, return: "+this.max,1),this.max},setAllProps:function(e,t,i,s){this.sliderVal=e,this.sliderWidth=t,this.min=i,this.max=s,this.updateSlider(),shmi.log("[GpScrollBar] setAllProps called, , val: "+e+" - width: "+t+" - min: "+i+" - max: "+s,1)},setMinimized:function(e){this.isMinimized=e,this.updateEvtEnable(),e?(shmi.removeClass(this.element,this.uiCssCl.normal),shmi.addClass(this.element,this.uiCssCl.minimized)):(shmi.removeClass(this.element,this.uiCssCl.minimized),shmi.addClass(this.element,this.uiCssCl.normal))},getMinimized:function(){return this.isMinimized},addEventListener:function(e){for(var t=Date.now();void 0!==this.sbEventListeners[t];)t++;return this.sbEventListeners[t]={},this.sbEventListeners[t].listener=e,shmi.log("[GpScrollBar] addEventListener called, listenerObj: "+e+" - id:"+t,1),t},removeEventListener:function(e){void 0!==this.sbEventListeners[e]?delete this.sbEventListeners[e]:shmi.log("[GpScrollBar] removeEventListener - id "+e+" does not exist",2),shmi.log("[GpScrollBar] removeEventListener called, id: "+e,1)},startBtnAutoRepeat:function(e){this.isBtnAutoRepeatProcessing=!0,this.btnProcessAutoRepeatTO&&clearTimeout(this.btnProcessAutoRepeatTO),this.btnProcessAutoRepeatTO=setTimeout(function(){this.processBtnAutoRepeat(e)}.bind(this),this.c.PROCESS_BTN_AUTO_REPEAT_TO)},processBtnAutoRepeat:function(e){this.isBtnAutoRepeatProcessing&&(this.fireBtnAction(e),this.btnProcessAutoRepeatTO=setTimeout(function(){this.processBtnAutoRepeat(e)}.bind(this),this.c.PROCESS_BTN_AUTO_REPEAT_TO))},stopBtnAutoRepeat:function(){this.isBtnAutoRepeatProcessing=!1,this.btnProcessAutoRepeatTO&&clearTimeout(this.btnProcessAutoRepeatTO)},processEvtOnResize:function(){this.updateSlider()},updateSlider:function(){if(this.initialized){var e=this.sliderWidth*this.sliderTrackElem.offsetHeight/(this.max-this.min);this.isMinimized?e<this.c.MIN_SLIDER_SIZE_PX_MINIMIZED&&(e=this.c.MIN_SLIDER_SIZE_PX_MINIMIZED):e<this.c.MIN_SLIDER_SIZE_PX&&(e=this.c.MIN_SLIDER_SIZE_PX);var t=this.sliderTrackElem.offsetHeight-e,i=(this.max-this.sliderVal)*t/(this.max-this.min);this.sliderHandleElem.style.height=e+"px",this.config.inverse||(i=t-i),this.sliderHandleMovable.translate(0,i-this.sliderHandleMovable.ty)}},updateVal:function(e){if(this.initialized){var t=this.max-e*(this.max-this.min)/(this.sliderTrackElem.offsetHeight-this.sliderHandleElem.offsetHeight);this.config.inverse||(t=this.max-t),t<this.min?this.sliderVal=this.min:t>this.max?this.sliderVal=this.max:this.sliderVal=t}},updateEvtEnable:function(){var e=this.isEnabled&&!this.isMinimized;this.initialized?(this.testlog_msg("init ok - en: "+this.isEnabled+" - min: "+this.isMinimized),e?(this.sliderHandleMouseListener.enable(),this.sliderHandleTouchListener.enable(),this.sliderTrackMouseListener.enable(),this.sliderTrackTouchListener.enable(),this.btnUpElem&&(this.btnUpMouseListener.enable(),this.btnUpTouchListener.enable(),this.btnDownMouseListener.enable(),this.btnDownTouchListener.enable())):(this.sliderHandleMouseListener.disable(),this.sliderHandleTouchListener.disable(),this.sliderTrackMouseListener.disable(),this.sliderTrackTouchListener.disable(),this.btnUpElem&&(this.btnUpMouseListener.disable(),this.btnUpTouchListener.disable(),this.btnDownMouseListener.disable(),this.btnDownTouchListener.disable()))):(this.testlog_msg("init ! ok - repeat"),this.enableTO&&clearTimeout(this.enableTO),this.enableTO=setTimeout(function(){this.updateEvtEnable()}.bind(this),this.c.ENABLE_TO))},fireValChanged:function(e,t){shmi.requires("visuals.tools.iterate.iterateObject")(this.sbEventListeners,i=>{i.listener.gpsbOnValChange(e,t)})},fireBtnAction:function(e){shmi.requires("visuals.tools.iterate.iterateObject")(this.sbEventListeners,t=>{t.listener.gpsbOnBtnAction(e)})},testlog_msg:function(e){var t=document.getElementById("debugDisplEvents");if(t){var i=[];t.innerHTML="",i.push("last debug messages:"),i.push("---"),console.log(e),this.debug.msgFIFO.push(e),this.debug.msgFIFO.length>10&&this.debug.msgFIFO.shift();for(var s=this.debug.msgFIFO.length-1;s>=0;s--)i.push(this.debug.msgFIFO[s]);for(i.push("--------------------------------"),s=0;s<i.length;s++)t.innerHTML+=i[s]+"<br>"}}},shmi.extend(shmi.visuals.controls.GpScrollBar,shmi.visuals.core.BaseControl),shmi.registerControlType("gp-scroll-bar",shmi.visuals.controls.GpScrollBar,!0),shmi.visuals.controls.GpScrollBar.uiElName={},function(){var e=shmi.visuals.controls.GpScrollBar.uiElName;e.sliderTrack="gpsb-slider-track",e.sliderHandle="gpsb-slider-handle",e.sliderHandleVisible="gpsb-slider-handle-visible",e.btnPanel="gpsb-btn-panel",e.btnUp="gpsb-btn-up",e.btnDown="gpsb-btn-down",shmi.visuals.controls.GpScrollBar.uiCssCl={},(e=shmi.visuals.controls.GpScrollBar.uiCssCl).withBtns="gpsb-with-btns",e.withoutBtns="gpsb-without-btns",e.btnSel="gpsb-btn-selected",e.trackSel="gpsb-track-selected",e.minimized="gpsb-minimized",e.normal="gpsb-normal",e.sliderAni="gpsb-slider-ani",shmi.visuals.controls.GpScrollBar.c={},(e=shmi.visuals.controls.GpScrollBar.c).MIN_SLIDER_SIZE_PX=60,e.MIN_SLIDER_SIZE_PX_MINIMIZED=5,e.ENABLE_TO=500,e.START_BTN_AUTO_REPEAT_TO=1e3,e.PROCESS_BTN_AUTO_REPEAT_TO=100}(),shmi.pkg("visuals.controls"),shmi.visuals.controls.Group=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","group"),shmi.def(this.config,"template",null),shmi.def(this.config,"name",null),shmi.def(this.config,"replacers",{}),this.initialized=!1,this.controls=[],this.startup()},shmi.visuals.controls.Group.prototype={uiType:"group",isContainer:!0,getClassName:function(){return"Group"},onRegister:function(e){this.parseChildren(this.element,e)},onInit:function(){},onEnable:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].enable();shmi.log("[Group] enabled",1)},onDisable:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].disable();shmi.log("[Group] disabled",1)},onLock:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].lock();shmi.addClass(this.element,"locked"),shmi.log("[Group] locked",1)},onUnlock:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].unlock();shmi.removeClass(this.element,"locked"),shmi.log("[Group] locked",1)},onSetValue:function(e){shmi.log("[Group] value set: "+e,0)}},shmi.extend(shmi.visuals.controls.Group,shmi.visuals.core.BaseControl),function(){"use strict";var e={className:"Html",uiType:"html",isContainer:!1,config:{"class-name":"html",name:null,template:"default/html","use-shadow-dom":!1,html:""},configSchema:null,vars:{html:null},imports:{},events:[],prototypeExtensions:{onInit:function(){const e=this,t=shmi.getUiElement("html",e.element);if(!t)return void console.log('Error: "html" element is missing in template!');const i=(()=>e.config["use-shadow-dom"]?t.attachShadow({mode:"open"}):t)();e.vars.html=i,i.appendChild(function documentFragmentFromHTML(e){const t=document.createElement("template");return t.innerHTML=e,t.content.cloneNode(!0)}(e.config.html))},getRootNode:function(){return this.vars.html}}};shmi.requires("visuals.tools.control-generator").generate(e)}(),function(){"use strict";var e={className:"Iframe",uiType:"iframe",isContainer:!1,config:{"class-name":"iframe",name:null,template:"default/iframe ",src:"about:blank","disable-scrollbar":!1},configSchema:null,vars:{iframe:null},imports:{im:"visuals.session.ItemManager",qm:function(){return shmi.visuals.session.QueryManager}},events:[],prototypeExtensions:{onInit:function(){this.vars.iframe=this.element.querySelector("iframe"),this.vars.iframe&&(this.vars.iframe.onerror=function(e){shmi.notify("Error loading IFrame: "+e.toString())},this.vars.iframe.setAttribute("src",this.config.src),this.config["disable-scrollbar"]&&(this.vars.iframe.setAttribute("scrolling","no"),this.vars.iframe.style.overflow="hidden"))},onEnable:function(){},onDisable:function(){},onLock:function(){this.vars.iframe&&(this.vars.iframe.style.pointerEvents="none")},onUnlock:function(){this.vars.iframe&&(this.vars.iframe.style.pointerEvents="")},onSetValue:function(e,t,i){},onSetProperties:function(e,t,i){}}};shmi.requires("visuals.tools.control-generator").generate(e)}(),function(){"use strict";var e=shmi.requires("visuals.tools.logging").createLogger("image-changer",!0,!1);e.fLog,e.log;function getActive(e,t){var i=e.config.options.find((function(e){return e.value===t}));i||(i={"icon-src":e.config["default-image"],label:e.config["default-title"]||null}),e.vars.activeOption=i,e.vars.elements.img.setAttribute("src",i["icon-src"]),e.setTooltip(e.getTooltip())}var t={className:"ImageChanger",uiType:"image-changer",isContainer:!1,config:{"class-name":"image-changer",name:null,template:"default/image-changer",options:[],"default-image":"pics/system/icons/placeholder.svg","default-title":null},configSchema:null,vars:{tokens:[],listeners:[],value:null,activeOption:null,elements:{img:null}},imports:{im:"visuals.session.ItemManager",qm:function(){return shmi.visuals.session.QueryManager}},events:[],prototypeExtensions:{getTooltip:function(){var e=shmi.visuals.core.BaseControl.prototype.getTooltip.call(this);return e||(this.activeOption&&this.activeOption.label?this.activeOption.label:null)},onInit:function(){this.vars.elements.img=shmi.getUiElement("image",this.element),getActive(this,null)},onEnable:function(){var e=shmi.requires("visuals.session.ItemManager");this.config.item&&this.vars.tokens.push(e.subscribeItem(this.config.item,this))},onDisable:function(){this.vars.tokens.forEach((function(e){e.unlisten()})),this.vars.tokens=[]},onLock:function(){},onUnlock:function(){},onSetValue:function(e,t,i){this.vars.value=e,getActive(this,this.vars.value)},onSetProperties:function(e,t,i){}}};shmi.requires("visuals.tools.control-generator").generate(t)}(),shmi.visuals.controls.Image=function(e,t){this.element=e,this.config=t||{},this.run=!1,this.loaded=!1,shmi.def(this.config,"image-src","pics/system/icons/placeholder.svg"),shmi.def(this.config,"image-alt",null),shmi.def(this.config,"image-title",null),shmi.def(this.config,"class-name","image"),shmi.def(this.config,"template","default/image"),shmi.def(this.config,"label","image"),this.listeners=[],this.parseAttributes(),this.imgElement=null,this.startup()},shmi.visuals.controls.Image.prototype={uiType:"image",isContainer:!1,events:["click"],tooltipProperties:["image-title"],getClassName:function(){return"Image"},onInit:function(){var e=this,t=shmi.visuals.io,i=null,s=null,n=null;this.imgElement=shmi.getUiElement("image",this.element),this.labelElement=shmi.getUiElement("label",this.element),this.imgElement&&(this.imgElement.setAttribute("draggable","false"),this.config["image-src"]&&this.imgElement.setAttribute("src",this.config["image-src"]),this.config["image-alt"]&&this.imgElement.setAttribute("alt",this.config["image-alt"]),i={onClick:function(t,i,s){e.fire("click",{x:t,y:i,event:s})}},s=new t.MouseListener(e.imgElement,i),n=new t.TouchListener(e.imgElement,i),e.listeners.push(s,n)),this.labelElement&&(this.labelElement.textContent=shmi.localize(this.config.label))},onEnable:function(){this.listeners.forEach((function(e){e.enable()}))},onDisable:function(){this.listeners.forEach((function(e){e.disable()}))},onLock:function(){this.listeners.forEach((function(e){e.disable()})),shmi.addClass(this.element,"locked")},onUnlock:function(){this.listeners.forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked")},setLabel:function(e){this.labelElement&&(this.labelElement.textContent=shmi.localize(e))}},shmi.extend(shmi.visuals.controls.Image,shmi.visuals.core.BaseControl),shmi.registerControlType("image",shmi.visuals.controls.Image,!1),function(){function insertValue(e,t){"INPUT"===e.valueElement.tagName?(e.valueElement.value="",e.valueElement.value=t):e.config.multiline?e.valueElement.value=t:(e.valueElement.textContent=t,e.valueElement.firstChild||e.valueElement.appendChild(document.createTextNode(""))),e.config["value-as-tooltip"]&&(null!=t&&""!==t?e.setTooltip(String(t)):e.setTooltip(e.getTooltip()))}function retrieveValue(e){return"INPUT"===e.valueElement.tagName?e.valueElement.value:e.config.multiline?e.valueElement.value:e.valueElement.textContent}function selectContent(e){if("INPUT"===e.valueElement.tagName)e.valueElement.select();else{var t=document.createRange();shmi.addClass(e.valueElement,"selectableText"),t.setStart(e.valueElement.firstChild,0),t.setEnd(e.valueElement.lastChild,e.valueElement.lastChild.length),window.getSelection().removeAllRanges(),window.getSelection().addRange(t)}}function handleFocus(e){e.locked||e.focused||(e.focused||null===shmi.visuals.session.FocusElement||(shmi.visuals.session.FocusElement.blur(),shmi.visuals.session.FocusElement=null),shmi.log("[InputField] focused",1),function showNumpad(e){if(!e.config["numpad-enabled"])return!1;var t,i=shmi.requires("visuals.tools.numericValues"),s=null,n=shmi.visuals.session.ItemManager;e.vars&&e.vars.valueSettings||i.initValueSettings(e);return s={"decimal-delimiter":e.config["decimal-delimiter"],unit:void 0!==e.vars.unit?e.vars.unit:e.config["unit-text"],label:void 0!==e.vars.label?e.vars.label:e.config.label,value:retrieveValue(e),callback:function(t){e.config.item?(e.config.multiline&&(t=t.toString()),n.writeValue(e.config.item,t)):e.setValue(t)}},t=e.vars.valueSettings,s.min=t.min,s.max=t.max,s.type=t.type,s.precision=t.precision,shmi.numpad(s),!0}(e)||function showKeyboard(e){var t=shmi.requires("visuals.session.config");if(!t.keyboard||!t.keyboard.enabled)return!1;var i=shmi.visuals.session.ItemManager,s={value:retrieveValue(e),"select-box-enabled":t.keyboard["language-selection"],"password-input":e.valueElement&&e.valueElement.type&&"password"===e.valueElement.type.toLowerCase(),callback:function(t,s){t&&(e.config.item?i.writeValue(e.config.item,s):e.setValue(s))}};return shmi.keyboard(s),!0}(e)||(selectContent(e),e.focused=!0,e.valueElement.focus(),shmi.visuals.session.FocusElement=e.valueElement,clearTimeout(e.vars.to_enter),e.vars.to_enter=setTimeout((function(){e.fire("enter",{value:e.value})}),250)))}shmi.pkg("visuals.controls"),shmi.visuals.controls.InputField=function(e,t){this.element=e,this.value=null,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","input-field"),shmi.def(this.config,"template","default/input-field"),shmi.def(this.config,"name",null),shmi.def(this.config,"item",null),shmi.def(this.config,"value-alignment","left"),shmi.def(this.config,"numeric-class","numeric"),shmi.def(this.config,"min",Number.NEGATIVE_INFINITY),shmi.def(this.config,"auto-min",!0),shmi.def(this.config,"max",Number.POSITIVE_INFINITY),shmi.def(this.config,"auto-max",!0),shmi.def(this.config,"step",0),shmi.def(this.config,"auto-step",!1),shmi.def(this.config,"precision",-1),shmi.def(this.config,"auto-precision",!0),shmi.def(this.config,"unit-scale",1),shmi.def(this.config,"decimal-delimiter","."),shmi.def(this.config,"label","input-field"),shmi.def(this.config,"auto-label",!0),shmi.def(this.config,"unit-text",null),shmi.def(this.config,"auto-unit-text",!0),shmi.def(this.config,"type",shmi.c("TYPE_STRING")),shmi.def(this.config,"auto-type",!0),shmi.def(this.config,"numpad-enabled",!1),shmi.def(this.config,"multiline",!1),shmi.def(this.config,"value-as-tooltip",!1),this.type=shmi.c("TYPE_STRING"),this.valueElement=null,this.unitElement=null,this.textareaElement=null,this.mouseListener=null,this.touchListener=null,this.active=!1,this._subscriptionTargetId=null,this._timeout=0,this.vars={to_enter:0,wasClicked:!1},this.startup()},shmi.visuals.controls.InputField.prototype={uiType:"input-field",events:["change","enter"],getClassName:function(){return"InputField"},onInit:function(){var e=this,t=shmi.Constants;if(this.valueElement=shmi.getUiElement("input-field-value",this.element),this.valueElement){if(this.unitElement=shmi.getUiElement("input-field-unit",this.element),this.unitElement||shmi.log("[InputField] no input-field-unit element provided",1),this.labelElement=shmi.getUiElement("input-field-label",this.element),this.labelElement?void 0!==this.config.label&&(e.vars=e.vars||{},e.vars.label=this.config.label,this.labelElement.textContent=shmi.localize(this.config.label)):shmi.log("[InputField] no input-field-label element provided",1),this.config.multiline){if(this.valueBox=this.element.getElementsByClassName("value-box")[0],!this.valueBox)return void shmi.log("[InputField] no value-box element provided",3);this.valueElement.remove();var i=document.createElement("textarea");i.setAttribute("data-ui","input-field-value"),i.disabled=!0,this.textareaElement=i,shmi.addClass(i,"input-field-value"),this.valueElement=this.valueBox.appendChild(i),shmi.addClass(e.element,"textarea")}else this.textareaElement=null;this.valueElement.setAttribute("tabindex","0"),insertValue(e,"");var s=parseInt(this.config.type);isNaN(s)||(this.type=s),this.config.action&&(this.action=new shmi.visuals.core.UiAction(this.config.action,this)),e.config["auto-type"]||"auto"!==e.config["value-alignment"]?"right"===e.config["value-alignment"]&&shmi.addClass(e.element,e.config["numeric-class"]):-1!==[t.TYPE_BOOL,t.TYPE_INT,t.TYPE_FLOAT].indexOf(e.type)&&shmi.addClass(e.element,e.config["numeric-class"]);var n={};n.onPress=function(e,t,i){"INPUT"===this.valueElement.tagName||this.focused?this.focused&&window.getSelection().removeAllRanges():i.preventDefault()}.bind(this),n.onClick=function(){e.vars.wasClicked=!0,handleFocus(e),e.vars.wasClicked=!1},this.mouseListener=new shmi.visuals.io.MouseListener(this.valueElement,n),this.touchListener=new shmi.visuals.io.TouchListener(this.valueElement,n,!0),this.valueElement.addEventListener("focus",(function(){e.config.multiline?e.focused=!0:e.vars.wasClicked||handleFocus(e)})),this.valueElement.addEventListener("keypress",function(t){(13===t.keyCode&&!e.config.multiline||9===t.keyCode)&&(t.preventDefault(),window.getSelection().removeAllRanges(),this.valueElement.blur())}.bind(this)),this.valueElement.addEventListener("blur",function(){this.focused&&(shmi.log("[InputField] blur event",1),window.getSelection().removeAllRanges(),shmi.removeClass(this.valueElement,"selectableText"),this.validate(this.valueElement),this.focused=!1,shmi.visuals.session.FocusElement=null)}.bind(this)),this.valueElement.addEventListener("keydown",(function(t){if(e.type===shmi.c("TYPE_FLOAT")){var i="."===e.config["decimal-delimiter"]?",":".";t.key===i&&t.preventDefault()}})),this.config["unit-text"]&&(e.vars=e.vars||{},e.vars.unit=this.config["unit-text"],this.unitElement&&(this.unitElement.textContent=shmi.localize(this.config["unit-text"]))),this.config["unit-scale"]&&(this.config["unit-scale"]=parseFloat(shmi.localize(this.config["unit-scale"])))}else shmi.log("[InputField] no input-field-value element provided",3)},validate:function(e){const t=this,i=shmi.visuals.session.ItemManager,s=shmi.requires("visuals.tools.numericValues"),n=retrieveValue(t);if(t.config.multiline)t.config.item&&(i.writeValue(t.config.item,t.valueElement.value),this.action&&(this.action.execute(this.value),this.value!==t.valueElement.value&&this.fire("change",{value:t.valueElement.value})));else{if(t.config.item){var a=i.getItem(t.config.item);a&&t.config["auto-type"]&&(t.type=a.type)}const e=(()=>[shmi.c("TYPE_INT"),shmi.c("TYPE_FLOAT")].includes(t.type)?t.floatRegexp.test(n.replace(t.config["decimal-delimiter"],"."))?s.applyInputSettings(n,t):t.value:n)();if(insertValue(t,s.formatOutput(e,t)),t.config.item)return void i.writeValue(t.config.item,e);var l=this.value;this.value=e,this.action&&this.action.execute(this.value),this.value!==l&&(this.fire("change",{value:this.value}),this.onChange&&this.onChange(this.value))}},onSetProperties:function(e,t,i,s,n){var a=this,l=shmi.Constants,o=shmi.requires("visuals.tools.numericValues");a.config["auto-type"]&&"auto"===a.config["value-alignment"]&&[l.TYPE_BOOL,l.TYPE_INT,l.TYPE_FLOAT].indexOf(n)&&shmi.addClass(a.element,a.config["numeric-class"]),o.setProperties(a,arguments),shmi.log("[InputField] min: "+e+" max: "+t+" step: "+i,1)},onSetValue:function(e){var t=shmi.visuals.session.ItemManager,i=shmi.requires("visuals.tools.numericValues"),s=null,n=this.value;this.config.item&&this.config["auto-type"]&&((s=t.getItem(this.config.item))?this.type=s.type:shmi.visuals.session.config.debug&&console.debug(this.getClassName(),"configured item not available:",this.config.item)),this.value=e,insertValue(this,i.formatOutput(this.value,this)),document.activeElement===this.valueElement&&selectContent(this),shmi.log("[InputField] new value: "+this.value,0),this.value!==n&&(this.fire("change",{value:this.value}),this.onChange&&this.onChange(this.value))},getValue:function(){var e=this.type;return this.config.item&&this.config["auto-type"]&&(e=shmi.visuals.session.ItemManager.items[this.config.item].type),e===shmi.c("TYPE_INT")?Math.round(this.value/this.config["unit-scale"]):e===shmi.c("TYPE_FLOAT")?this.value/this.config["unit-scale"]:this.value},onEnable:function(){this.valueElement.setAttribute("contenteditable",!0),this.config.multiline||(this.mouseListener.enable(),this.touchListener.enable()),this.config.item&&(this._subscriptionTargetId=shmi.visuals.session.ItemManager.subscribeItem(this.config.item,this)),this.textareaElement&&(this.textareaElement.disabled=!1),shmi.log("[InputField] enabled",1)},onDisable:function(){this.valueElement.setAttribute("contenteditable",!1),shmi.removeClass(this.valueElement,"selectableText"),this.config.item&&shmi.visuals.session.ItemManager.unsubscribeItem(this.config.item,this._subscriptionTargetId),this.config.multiline||(this.mouseListener.disable(),this.touchListener.disable()),shmi.log("[InputField] disabled",1)},onLock:function(){this.locked=!0,shmi.log("[InputField] locked",1),"INPUT"===this.valueElement.tagName?this.valueElement.setAttribute("disabled",!0):this.valueElement.setAttribute("contenteditable",!1),shmi.removeClass(this.valueElement,"selectableText"),this.config.multiline||(this.mouseListener.disable(),this.touchListener.disable()),this.textareaElement&&(this.textareaElement.disabled=!0),shmi.addClass(this.element,"locked")},onUnlock:function(){this.locked=!1,shmi.log("[InputField] unlocked",1),"INPUT"===this.valueElement.tagName?this.valueElement.removeAttribute("disabled"):this.valueElement.setAttribute("contenteditable",!0),this.config.multiline||(this.mouseListener.enable(),this.touchListener.enable()),this.textareaElement&&(this.textareaElement.disabled=!1),shmi.removeClass(this.element,"locked")},setLabel:function(e){this.config["auto-label"]&&this.labelElement&&(this.vars=this.vars||{},this.vars.label=e,this.labelElement.textContent=shmi.localize(e))},setUnitText:function(e){this.config["auto-unit-text"]&&this.unitElement&&(this.vars=this.vars||{},this.vars.unit=e,this.unitElement.textContent=shmi.localize(e))},floatRegexp:/(^[+-]?[0-9]([.][0-9]*)?$|^[+-]?[1-9]+[0-9]*([.][0-9]*)?$)/,intRegexp:/(^[+-]?[0-9]$|^[+-]?[1-9]+[0-9]*$)/},shmi.extend(shmi.visuals.controls.InputField,shmi.visuals.core.BaseControl)}(),function(){"use strict";const e="iq-alarm-info",t={"class-name":e,name:null,template:"default/iq-alarm-info",noAlarm:null,action:null,enableCycle:!0,cycleInterval:1e3,showAlarm:!0,showWarn:!0,showInfo:!0,groupFilter:null,"icon-info":"pics/system/controls/iq-alarm-info/icon-info.svg","icon-warning":"pics/system/controls/iq-alarm-info/icon-warning.svg","icon-alarm":"pics/system/controls/iq-alarm-info/icon-alarm.svg","icon-idle":null},i=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1).log,s=["severity-info","severity-warning","severity-alarm"];function parseAlarmGroupFilter(e){if("string"!=typeof e)return null;let t=e.split(",");t=t.map(e=>{if(e.includes("-"))return function parseAlarmGroupRange(e){const t=e.split("-");if(2===t.length){const e=parseInt(t[0]),i=parseInt(t[1]);if(!isNaN(e)&&!isNaN(i)&&e>=0&&i>=e)return[e,i]}return null}(e);const t=parseInt(e);return!isNaN(t)&&t>=0?t:null}),t=t.filter(e=>null!==e);const i=[];return t.forEach(e=>{if(Array.isArray(e)){let s=e[0];for(;s<=e[1];)i.includes(s)&&t.includes(s)||i.push(s),s+=1}}),t.push(...i),t.length?t:null}function testAlarmState(e){const t=Object.values(e.imports.am.alarms).map(e=>e.properties);Array.isArray(t)&&(t.length<1?clearAlarmMsg(e):(clearInt(e),e.config.enableCycle?(e.vars.activeAlarmList=getEnabledAlarms(e,t),e.vars.alarmCount=e.vars.activeAlarmList.length,e.vars.alarmCount>1&&(e.vars.interval=setInterval(displayAlarms.bind(null,e),e.config.cycleInterval))):e.vars.activeAlarmList=function getLastHighest(e,t){let i=null;const s=getEnabledAlarms(e,t);return e.vars.alarmCount=s.length,s.forEach((function(e){null===i?i=e:e.severity>=i.severity&&e.timestamp_in>i.timestamp_in&&(i=e)})),null===i?[]:[i]}(e,t),displayAlarms(e)))}function displayAlarms(e){0===e.vars.activeAlarmList.length&&clearAlarmMsg(e),e.vars.currentAlarm>=e.vars.activeAlarmList.length&&(e.vars.currentAlarm=0);const t=e.vars.activeAlarmList[e.vars.currentAlarm++];let i=null;t?(i=shmi.evalString("${alarm_title_<%= value %>}",{value:t.index}),i=shmi.localize(i),i=shmi.evalString(i,t)):i=shmi.localize(e.config.noAlarm),setAlarmStyle(t?t.severity:-1,e),setTextContent(e,"alarmMessage",i),setTextContent(e,"alarmCount",e.vars.alarmCount)}function getEnabledAlarms(e,t){return t.filter((function(t){return!(Array.isArray(e.vars.groupFilter)&&!e.vars.groupFilter.includes(t.group))&&(!!(t.active||t.acknowledgeable&&!t.acknowledged)&&(2===t.severity&&e.config.showAlarm||1===t.severity&&e.config.showWarn||0===t.severity&&e.config.showInfo))}))}function clearAlarmMsg(e){clearInt(e),e.vars.currentAlarm=0,setAlarmStyle(-1,e),setTextContent(e,"alarmMessage",shmi.localize(e.config.noAlarm))}function clearInt(e){e.vars.interval&&(clearInterval(e.vars.interval),e.vars.interval=null)}function setAlarmIcon(e,t){e.vars.elements.stateIcon&&(e.config[t]?(e.vars.elements.stateIcon.style.visibility="",e.vars.elements.stateIcon.style.backgroundImage=`url(${e.config[t]})`):(e.vars.elements.stateIcon.style.visibility="hidden",e.vars.elements.stateIcon.style.backgroundImage=""))}function setAlarmStyle(e,t){const i=t.vars.elements.wrapper;switch(e){case 0:setAlarmIcon(t,"icon-info");break;case 1:setAlarmIcon(t,"icon-warning");break;case 2:setAlarmIcon(t,"icon-alarm");break;default:setAlarmIcon(t,"icon-idle")}i&&(shmi.removeClass(i,s.join(" ")),s[e]&&shmi.addClass(i,s[e]))}function setTextContent(e,t,i){e.vars.elements[t]&&(e.vars.elements[t].textContent=i)}const n={className:"IQAlarmInfo",uiType:e,isContainer:!1,config:t,configSchema:null,vars:{elements:{stateIcon:null,alarmCount:null,alarmMessage:null,button:null,wrapper:null},alarmCount:0,listeners:[],tokens:[],activeAlarmList:[],currentAlarm:0,interval:0,alarmSubscriber:null,groupFilter:null},imports:{am:"visuals.session.AlarmManager"},prototypeExtensions:{onInit:function(){const t=this;if(t.vars.groupFilter=parseAlarmGroupFilter(t.config.groupFilter),t.vars.elements.alarmCount=shmi.getUiElement("alarm-count",t.element),t.vars.elements.alarmCount||i(e,"alarm-count not found in template"),t.vars.elements.wrapper=shmi.getUiElement("alarm-info-wrapper",t.element),t.vars.elements.wrapper||i(e,"alarm-info-wrapper not found in template"),t.vars.elements.stateIcon=shmi.getUiElement("state-icon",t.element),t.vars.elements.stateIcon||i(e,"state-icon not found in template"),t.vars.elements.alarmMessage=shmi.getUiElement("alarm-message",t.element),t.vars.elements.alarmMessage?setTextContent(t,"alarmMessage",shmi.localize(t.config.noAlarm)):i(e,"alarm-message not found in template"),t.vars.elements.button=shmi.getUiElement("alert-list-button",t.element),t.vars.elements.button&&Array.isArray(t.config.action)&&t.config.action.length){const e=shmi.requires("visuals.core"),i=shmi.requires("visuals.io"),s=new e.UiAction(t.config.action),n={onClick:()=>s.execute()},a=new i.MouseListener(t.vars.elements.button,n),l=new i.TouchListener(t.vars.elements.button,n);shmi.addClass(t.element,"has-action"),t.vars.listeners.push(a,l)}else t.vars.elements.button||i(e,"click element not found in template");setAlarmStyle(-1,t)},onEnable:function(){const e=this;e.vars.stateIcons=shmi.getUiElements("state",e.element)||[],e.vars.alarmSubscriber=e.imports.am.subscribeAlarms(e,(t,i)=>{i&&testAlarmState(e)}),e.vars.listeners.forEach((function(e){e.enable()}))},onDisable:function(){this.vars.tokens.forEach((function(e){e.unlisten()})),this.vars.tokens=[],this.vars.listeners.forEach((function(e){e.disable()})),this.imports.am.unsubscribeAlarms(this.vars.alarmSubscriber),clearInt(this)},onLock:function(){this.vars.listeners.forEach((function(e){e.disable()})),shmi.addClass(this.element,"locked")},onUnlock:function(){this.vars.listeners.forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked")},onSetValue:function(e,t,i){},onSetProperties:function(e,t,i){}}};shmi.requires("visuals.tools.control-generator").generate(n)}(),function(){"use strict";const e=shmi.requires("visuals.tools.logging").createLogger("iq-alarm-list",!0,!1);e.fLog,e.log;function controlStartUp(e){let t=!1,i=!1;const s=shmi.requires("visuals.io");if(e.vars.timeFilterLabel=shmi.getUiElement("filter-label",e.element),e.vars.activeFilterLabel=shmi.getUiElement("time-frame-label",e.element),e.vars.activeFilterFrom=shmi.getUiElement("start-date",e.element),e.vars.activeFilterTo=shmi.getUiElement("end-date",e.element),e.vars.resetButton=shmi.getUiElement("reset-button",e.element),e.vars.detailsRight=shmi.getUiElement("alarmListDetails",e.element),!(e.vars.timeFilterLabel&&e.vars.activeFilterLabel&&e.vars.activeFilterFrom&&e.vars.activeFilterTo&&e.vars.resetButton))return!1;e.vars.timeFilterLabel.textContent=shmi.localize("${alarmlist_set_timefilter}");const n={onClick:function(){!function clearFilter(e){e.vars.controls.alarmList.resetScroll(),e.vars.grid.clearFilter(4),shmi.removeClass(e.element,"filter-active")}(e)}};return e.vars.listeners.push(new s.MouseListener(e.vars.resetButton,n),new s.TouchListener(e.vars.resetButton,n)),e.vars.configs.alarmTableConfig["default-field-control-map"].come.config.dateformat=shmi.localize(e.config.dateformat),function initAlarmTableGrid(e){do{e.vars.dataGridId="iqalarms-"+Math.random().toString(36).substr(2,9)}while(null!==e.imports.dgm.getGrid(e.vars.dataGridId));e.imports.dgm.grids[e.vars.dataGridId]=new shmi.visuals.core.DataGridIQAlarms(e.config["display-mode"],e.vars.dataGridId),e.vars.grid=e.imports.dgm.getGrid(e.vars.dataGridId)}(e),t=function gatherAnchors(e){const t=e.vars.anchorEls,i=shmi.requires("visuals.io");if(t.iconError=shmi.getUiElement("iconError",e.element),t.filterCheckBoxError=shmi.getUiElement("filterCheckBoxError",e.element),t.iconWarn=shmi.getUiElement("iconWarn",e.element),t.filterCheckBoxWarn=shmi.getUiElement("filterCheckBoxWarn",e.element),t.iconAdvise=shmi.getUiElement("iconAdvise",e.element),t.filterCheckBoxAdvise=shmi.getUiElement("filterCheckBoxAdvise",e.element),t.modeSelectBox=shmi.getUiElement("mode-select-box",e.element),t.alarmList=shmi.getUiElement("alarmList",e.element),t.confirmButtons=shmi.getUiElement("confirmButtons",e.element),t.filterButton=shmi.getUiElement("filter-button",e.element),t.filterButton){const s={onClick:function(){!function handleDialog(e){const t=shmi.ctrl(".alarmTimeFilterDialogHolder");t&&shmi.deleteControl(t);shmi.createControl("container",e.element,{name:"alarmTimeFilterDialogHolder"},"DIV").addControl([{ui:"dialog-box",controller:{name:"alarmTimeFilterController",slots:{dialog:{ui:"dialog-box",events:["close"]},selectDateStart:{ui:"iq-select-date",events:["change"]},selectTimeStart:{ui:"iq-select-time",events:["change"]},selectDateEnd:{ui:"iq-select-date",events:["change"]},selectTimeEnd:{ui:"iq-select-time",events:["change"]},cancelButton:{ui:"iq-button",events:["click"]},applyButton:{ui:"iq-button",events:["click"]}},onChange:function(e){},onDisable:function(e){},onEnable:function(e){const t=Math.floor(new Date(1e3*shmi.getServerTime()).getTime()/1e3),i=86400*Math.floor(t/86400);e.getInstance("selectDateStart").setValue(i-86400),e.getInstance("selectTimeStart").setValue(t),e.getInstance("selectDateEnd").setValue(i),e.getInstance("selectTimeEnd").setValue(t)},onEvent:function(t,i,s,n){switch(i){case"selectDateStart":t.getInstance("selectDateEnd").setValue(n.detail.value+86400),t.getInstance("selectTimeEnd").setValue(t.getInstance("selectTimeStart").getValue());break;case"applyButton":!function setFilter(e,t){const i=evaluateTimestampFromControls({time:t.getInstance("selectTimeStart"),date:t.getInstance("selectDateStart")}),s=evaluateTimestampFromControls({time:t.getInstance("selectTimeEnd"),date:t.getInstance("selectDateEnd")}),n=shmi.requires("visuals.tools.date");shmi.addClass(e.element,"filter-active"),e.vars.activeFilterLabel.textContent=shmi.localize("${alarmlist_timefilter}"),e.vars.activeFilterFrom.textContent=n.formatDateTime(i,{datestring:shmi.localize(e.config.dateformat)}),e.vars.activeFilterTo.textContent=n.formatDateTime(s,{datestring:shmi.localize(e.config.dateformat)}),e.vars.controls.alarmList.resetScroll(),e.vars.grid.setFilter(4,[i,s])}(e,t),t.getInstance("dialog").hide();break;case"cancelButton":t.getInstance("dialog").hide()}}},config:{title:"${alarmlist_select_time_range}","class-name":"dialog-box iq-alarm-list iq-alarm-list-filter-dialog",template:"default/dialog-box",name:"alarmTimeFilterDialog","top-level":!0,"content-template":null,_controllers_:[{name:"alarmTimeFilterController",slot:"dialog"}]},children:[{ui:"container",config:{"class-name":"container",name:"container",template:null},children:[{ui:"iq-label",config:{"class-name":"iq-label",template:"default/iq-label.iq-variant-01",text:"${alarmlist_from}"}},{ui:"iq-select-date",config:{label:"",template:"default/iq-select-date.iq-variant-01","class-name":"iq-select-date iq-variant-02",_controllers_:[{name:"alarmTimeFilterController",slot:"selectDateStart"}]}},{ui:"iq-select-time",config:{label:"","class-name":"iq-select-time iq-variant-01 iq-icon-variant-01",isUTC:!0,_controllers_:[{name:"alarmTimeFilterController",slot:"selectTimeStart"}]}},{ui:"iq-label",config:{"class-name":"iq-label",template:"default/iq-label.iq-variant-01",text:"${alarmlist_to}"}},{ui:"iq-select-date",config:{label:"",template:"default/iq-select-date.iq-variant-01","class-name":"iq-select-date iq-variant-02",_controllers_:[{name:"alarmTimeFilterController",slot:"selectDateEnd"}]}},{ui:"iq-select-time",config:{label:"","class-name":"iq-select-time iq-variant-01 iq-icon-variant-01",isUTC:!0,_controllers_:[{name:"alarmTimeFilterController",slot:"selectTimeEnd"}]}},{ui:"container",config:{"class-name":"container footer",type:"float","auto-width":!1,"auto-margin":!1,"h-alignment":"right","v-alignment":"top","flex-orientation":"row","flex-distribute":!1,"flex-all":!1,name:"container",template:null},children:[{ui:"iq-button",config:{"class-name":"iq-button cancel-button",label:"${cancel}",_controllers_:[{name:"alarmTimeFilterController",slot:"cancelButton"}]}},{ui:"iq-button",config:{"class-name":"iq-button apply-button",label:"${okay}",_controllers_:[{name:"alarmTimeFilterController",slot:"applyButton"}]}}]}]}]}],(function(e,t){e?console.error("Error creating controls"):t[0].show()}))}(e)}},n=new i.MouseListener(t.filterButton,s),a=new i.TouchListener(t.filterButton,s);e.vars.listeners.push(n,a)}return!0}(e),t&&(i=function createChildControls(e){const t=e.vars.anchorEls,i=e.vars.controls,s=e.vars.configs;return function configureAlarmList(e,t,i){i.alarmTableConfig.table=e.vars.dataGridId,shmi.hasClass(t.alarmList,"two-rows")&&(i.alarmTableConfig["default-layout"]["line-height"]="78px");e.config["notify-image"]&&(i.iconAdvise["image-src"]=e.config["notify-image"],i.alarmTableConfig["default-field-control-map"].level.config.options[0]["icon-src"]=e.config["notify-image"]);e.config["warn-image"]&&(i.iconWarn["image-src"]=e.config["warn-image"],i.alarmTableConfig["default-field-control-map"].level.config.options[1]["icon-src"]=e.config["warn-image"]);e.config["alarm-image"]&&(i.iconError["image-src"]=e.config["alarm-image"],i.alarmTableConfig["default-field-control-map"].level.config.options[2]["icon-src"]=e.config["alarm-image"]);e.config["detail-template"]&&(i.alarmTableConfig["default-field-control-map"].json.config["detail-template"]=e.config["detail-template"]);for(let t=1;t<=e.config.numberOfColumns;t++)null!==e.config["col"+t+"-width"]&&e.config["col"+t+"-selectBox"]&&(i.alarmTableConfig["default-layout"]["column-org"]["col"+t]["column-width"]=e.config["col"+t+"-width"]+e.config["col"+t+"-selectBox"]);if(e.vars.detailsRight){delete i.alarmTableConfig["default-layout"]["column-org"].col7,shmi.requires("visuals.tools.alarms.ls.alarmDetailsIQ").showAlarmDetails(null,"inline",e.vars.detailsRight,e)}e.config["disable-commit"]&&(i.alarmTableConfig["default-layout"]["column-org"].col7?(i.alarmTableConfig["default-layout"]["column-org"].col6=i.alarmTableConfig["default-layout"]["column-org"].col7,delete i.alarmTableConfig["default-layout"]["column-org"].col7):delete i.alarmTableConfig["default-layout"]["column-org"].col6)}(e,t,s),i.iconError=shmi.createControl("iq-image",t.iconError,s.iconError,"DIV"),i.filterCheckBoxError=shmi.createControl("iq-checkbox",t.filterCheckBoxError,s.filterCheckBoxError,"DIV"),i.iconWarn=shmi.createControl("iq-image",t.iconWarn,s.iconWarn,"DIV"),i.filterCheckBoxWarn=shmi.createControl("iq-checkbox",t.filterCheckBoxWarn,s.filterCheckBoxWarn,"DIV"),i.iconAdvise=shmi.createControl("iq-image",t.iconAdvise,s.iconAdvise,"DIV"),i.filterCheckBoxAdvise=shmi.createControl("iq-checkbox",t.filterCheckBoxAdvise,s.filterCheckBoxAdvise,"DIV"),i.modeSelectBox=shmi.createControl("iq-select-box",t.modeSelectBox,s.modeSelectBox,"DIV"),i.confirmSelAlarmButton=shmi.createControl("iq-button",t.confirmButtons,s.confirmSelAlarmButton,"DIV"),i.confirmAllAlarmsButton=shmi.createControl("iq-button",t.confirmButtons,s.confirmAllAlarmsButton,"DIV"),i.alarmList=shmi.createControl("complex-table2",t.alarmList,s.alarmTableConfig,"DIV"),!0}(e)),e.config["allow-mode-change"]||(e.vars.anchorEls.modeSelectBox.style.display="none"),e.config["disable-commit"]&&(shmi.addClass(e.vars.controls.confirmSelAlarmButton.element,"hidden locked"),shmi.addClass(e.vars.controls.confirmAllAlarmsButton.element,"hidden locked")),!(!t||!i)}function updateTableFilter(e){const t=e.vars.filterSet,i=[];t.error&&i.push(2),t.warn&&i.push(1),t.advise&&i.push(0),e.vars.controls.alarmList.resetScroll(),i.length>0?e.vars.grid.setFilter(3,i):e.vars.grid.clearFilter(3)}function toggleFilterSet(e,t){const i=e.vars.filterSet;i[t]=!i[t]}function evaluateTimestampFromControls(e){return function evaluateUnixTimestamp(e,t,i,s){const n=new Date(1e3*e);return n.setHours(t,i,s,0),n.getTime()/1e3}(e.date.getValue(),e.time.getHours(),e.time.getMinutes(),e.time.getSeconds())}function setLabelImpl(e,t){e.vars.labelEl&&(""!==t&&null!=t&&e.config["show-text"]?(e.vars.label=t,e.vars.labelEl.textContent=shmi.localize(t)):(e.vars.label="",e.vars.labelEl.textContent=""))}const t={className:"iq-alarm-list",uiType:"iq-alarm-list",isContainer:!0,config:{"class-name":"iq-alarm-list",name:null,template:"default/iq-alarm-list.variant-01",label:"[Label]","show-text":!1,"alarm-image":null,"warn-image":null,"notify-image":null,numberOfColumns:7,"col1-selectBox":null,"col1-width":null,"col2-selectBox":null,"col2-width":null,"col3-selectBox":null,"col3-width":null,"col4-selectBox":null,"col4-width":null,"col5-selectBox":null,"col5-width":null,"col6-selectBox":null,"col6-width":null,"col7-selectBox":null,"col7-width":null,dateformat:"${alarmlist_dateformat}","allow-mode-change":!1,"display-mode":"all","disable-commit":!1,"detail-template":null},configSchema:null,vars:{tempAlarmGrid:{},alarmSubscription:null,alarmLevelTemplate:null,grid:null,dataGridId:"",filterSet:{warn:!1,error:!1,advise:!1},anchorEls:{iconError:null,filterCheckBoxError:null,iconWarn:null,filterCheckBoxWarn:null,iconAdvise:null,filterCheckBoxAdvise:null,modeSelectBox:null,alarmList:null,confirmButtons:null,filterButton:null,filterOverlay:null},controls:{iconError:null,filterCheckBoxError:null,iconWarn:null,filterCheckBoxWarn:null,iconAdvise:null,filterCheckBoxAdvise:null,modeSelectBox:null,alarmList:null,confirmSelAlarmButton:null,confirmAllAlarmsButton:null},configs:{alarmLevelConfig:{"alarm-icon":"pics/system/controls/iq-alarm-list/ico_alarm_outline.svg","warn-icon":"pics/system/controls/iq-alarm-list/ico_warning_outline.svg","notify-icon":"pics/system/controls/iq-alarm-list/ico_service_outline.svg"},alarmTableConfig:{label:"${alarmlist_history_title}",table:"iqalarms",name:"alarm-table","class-name":"complex-table2 alarms","field-datagrid-col-map":{level:3,id:1,description:9,come:4,group:10,isAck:8,json:8},"select-mode":"SINGLE","default-field-control-map":{level:{"ui-type":"iq-image-changer",config:{"class-name":"iq-image-changer iq-variant-01",template:"default/iq-image-changer.iq-variant-01",options:[{label:"label",value:0,"icon-src":"pics/system/controls/iq-alarm-list/ico_service_outline.svg","icon-title":null,"icon-class":null},{label:"label",value:1,"icon-src":"pics/system/controls/iq-alarm-list/ico_warning_outline.svg","icon-title":null,"icon-class":null},{label:"label",value:2,"icon-src":"pics/system/controls/iq-alarm-list/ico_alarm_outline.svg","icon-title":null,"icon-class":null}],"scaling-mode":"fit-height"}},id:{"ui-type":"iq-label",config:{"class-name":"iq-label",template:"default/iq-label.iq-variant-01",options:[],pattern:"<%= VALUE %>","value-as-tooltip":!0}},description:{"ui-type":"iq-label",config:{"class-name":"iq-label",template:"default/iq-label.iq-variant-01",options:[],pattern:null,"value-as-tooltip":!0}},come:{"ui-type":"iq-date-time",config:{"class-name":"iq-date-time multiline",template:"default/iq-date-time.iq-variant-01",dateformat:"$DD.$MM.$YYYY, $HH:$mm:$ss","value-as-tooltip":!0}},group:{"ui-type":"iq-label",config:{"class-name":"iq-label",template:"default/iq-label.iq-variant-01",options:[],pattern:null,"value-as-tooltip":!0}},isAck:{"ui-type":"local-script",config:{module:"visuals.tools.alarms.ls.alarmCommitButton"}},json:{"ui-type":"local-script",config:{module:"visuals.tools.alarms.ls.alarmDetailsIQ","detail-template":null}}},"default-field-headers":{level:"${alarmlist_header_level}",id:"${alarmlist_header_id}",description:"${alarmlist_header_description}",come:"${alarmlist_header_come}",group:"${alarmlist_header_group}",isAck:"${alarmlist_header_isack}",json:"${alarmlist_header_json}"},_comment:"expr is passed to expr parameter array of shmi.visuals.core.DataGridManager.setFilter",filters:[],"default-layout":{"class-name":"layout-std",_comment:"default == no additional css layout class","column-org":{col1:{fields:["level"],"column-width":"10%"},col2:{fields:["id"],"column-width":"10%"},col3:{fields:["description"]},col4:{fields:["come"],"column-width":"15%"},col5:{fields:["group"]},col6:{fields:["isAck"],"column-width":"90px"},col7:{fields:["json"],"column-width":"90px"}},"line-height":"39px"},"sortable-fields":["come","id","group"],"delete-selected-rows":!1,"show-nof-rows":!0,"show-buttons-table-min-width-px":400,"text-mode":"MULTILINE","default-nof-buffered-rows":60,"buffer-size":500},iconError:{"class-name":"iq-image iq-variant-01",template:"default/iq-image.iq-variant-01","image-src":"pics/system/controls/iq-alarm-list/ico_alarm_outline.svg"},filterCheckBoxError:{"class-name":"iq-checkbox iq-variant-01",template:"default/iq-checkbox.iq-variant-01",label:"${alarmlist_level_errors}"},iconWarn:{"class-name":"iq-image iq-variant-01",template:"default/iq-image.iq-variant-01","image-src":"pics/system/controls/iq-alarm-list/ico_warning_outline.svg"},filterCheckBoxWarn:{"class-name":"iq-checkbox iq-variant-01",template:"default/iq-checkbox.iq-variant-01",label:"${alarmlist_level_warnings}"},iconAdvise:{"class-name":"iq-image iq-variant-01",template:"default/iq-image.iq-variant-01","image-src":"pics/system/controls/iq-alarm-list/ico_service_outline.svg"},filterCheckBoxAdvise:{"class-name":"iq-checkbox iq-variant-01",template:"default/iq-checkbox.iq-variant-01",label:"${alarmlist_level_notifications}"},modeSelectBox:{"class-name":"iq-select-box","show-text":!1,options:[{label:"${alarmlist_mode_all}",value:"all"},{label:"${alarmlist_mode_live}",value:"live"},{label:"${alarmlist_mode_historic}",value:"historic"}]},alarmList:{},confirmSelAlarmButton:{label:"${alarmlist_commit}",name:"confirm-sel-al-btn","class-name":"iq-button icon-and-text","icon-src":"pics/system/controls/iq-alarm-list/ButtonIcon_AcknSingle_default.svg"},confirmAllAlarmsButton:{label:"${alarmlist_commit_all}",name:"confirm-all-al-btn","class-name":"iq-button icon-and-text","icon-src":"pics/system/controls/iq-alarm-list/ButtonIcon_AcknAll_default.svg"}},listeners:[],tokens:[]},imports:{im:"visuals.session.ItemManager",dgm:"visuals.session.DataGridManager",am:"visuals.session.AlarmManager"},events:[],prototypeExtensions:{onInit:function(){controlStartUp(this)?shmi.log("Init Succeeded!"):shmi.log("Init Failed!"),this.vars.labelEl=shmi.getUiElement("label",this.element),setLabelImpl(this,this.config.label)},onEnable:function(){const e=this;e.vars.controls.modeSelectBox.setValue(e.config["display-mode"]),e.vars.listeners.forEach(e=>e.enable()),function setListener(e){const t=e.vars.controls,i=e.vars.tokens;return!!(t.confirmSelAlarmButton&&t.confirmAllAlarmsButton&&t.modeSelectBox&&t.filterCheckBoxError&&t.filterCheckBoxWarn&&t.filterCheckBoxAdvise)&&(i.push(t.confirmSelAlarmButton.listen("click",(function(i){const s=e.vars.grid.getRowData(t.alarmList.selection.selRows[0]);if(s){const t=JSON.parse(s[8].value);t.acknowledgeable&&!t.acknowledged&&e.imports.am.ackAlarm(t.real_id)}}))),i.push(t.confirmAllAlarmsButton.listen("click",(function(t){e.imports.am.ackAlarm(-1)}))),i.push(t.modeSelectBox.listen("change",(function(t){e.vars.grid.setDisplayMode(t.detail.value)}))),i.push(t.filterCheckBoxError.listen("change",(function(t){toggleFilterSet(e,"error"),updateTableFilter(e)}))),i.push(t.filterCheckBoxWarn.listen("change",(function(t){toggleFilterSet(e,"warn"),updateTableFilter(e)}))),i.push(t.filterCheckBoxAdvise.listen("change",(function(t){toggleFilterSet(e,"advise"),updateTableFilter(e)}))),!0)}(e),e.vars.detailsRight&&function attachSelectListener(e,t){e.vars.tokens.push(t.listen("select",(function(i){if(1===i.detail.selRows.length){const s=8,n=JSON.parse(t.getSelectionRowData(i.detail)[0][s].value);shmi.requires("visuals.tools.alarms.ls.alarmDetailsIQ").showAlarmDetails(n,"inline",e.vars.detailsRight,e)}})))}(e,e.vars.controls.alarmList);for(const t in e.vars.controls)e.vars.controls[t]&&e.vars.controls[t].enable&&e.vars.controls[t].enable();shmi.log("[IQ:iq-alarm-list] Enabled",1)},onDisable:function(){const e=this;e.vars.listeners.forEach(e=>e.disable());for(const t in e.vars.controls)e.vars.controls[t]&&e.vars.controls[t].disable&&e.vars.controls[t].disable();e.vars.tokens.forEach(e=>e.unlisten()),e.vars.tokens=[],shmi.log("[IQ:iq-alarm-list] disabled",1)},onLock:function(){const e=this;e.vars.listeners.forEach(e=>e.disable());for(const t in e.vars.controls)e.vars.controls[t]&&e.vars.controls[t].lock&&e.vars.controls[t].lock();shmi.addClass(e.element,"locked"),shmi.log("[IQ:iq-alarm-list] Locked",1)},onUnlock:function(){const e=this;e.vars.listeners.forEach(e=>e.enable());for(const t in e.vars.controls)e.vars.controls[t]&&e.vars.controls[t].unlock&&e.vars.controls[t].unlock();shmi.removeClass(e.element,"locked"),shmi.log("[IQ:iq-alarm-list] unlocked",1)},setLabel:function(e){setLabelImpl(this,e)}}};shmi.requires("visuals.tools.control-generator").generate(t)}(),function(){const e="visuals.tools.alarms.ls.alarmCommitButton",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),i=t.fLog;t.log;shmi.pkg(e).run=function(e){const t=shmi.requires("visuals.session.ItemManager"),i=shmi.requires("visuals.session.AlarmManager"),s=t.getItemHandler();let n=null,a=null,l=[];e.vars=e.vars||{},s.setValue=function(t){n=JSON.parse(t),a&&shmi.deleteControl(a,!0),n.active?e.element.parentElement.parentElement.parentElement.style["font-weight"]="bold":e.element.parentElement.parentElement.parentElement.style["font-weight"]="",n.acknowledgeable?(n.acknowledged?(a=shmi.createControl("iq-button",e.element.parentNode,{"icon-src":"pics/system/controls/iq-alarm-list/ButtonIcon_AcknSingle_default.svg",label:"","show-icon":!0,"show-text":!1},"DIV"),shmi.addClass(a.element,"alarm-ack")):(a=shmi.createControl("iq-button",e.element.parentNode,{label:"${alarmlist_single_commit}"},"DIV"),shmi.addClass(a.element,"alarm-ack"),l.push(a.listen("click",(function(){n.real_id&&i.ackAlarm(n.real_id)})))),n.active||shmi.addClass(a.element,"locked")):(a=shmi.createControl("iq-label",e.element.parentNode,{text:"---",template:"default/iq-label.iq-variant-01"},"DIV"),shmi.addClass(a.element,"alarm-no-ack"))},e.config.item&&l.push(t.subscribeItem(e.config.item,s)),e.onDisable=function(){e.run=!1,l.forEach((function(e){e.unlisten()})),l=[],a&&shmi.deleteControl(a,!0)}},i("module loaded")}(),function(){const e="visuals.tools.alarms.ls.alarmDetailsIQ",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),i=t.fLog,s=(t.log,shmi.pkg(e));function formatTime(e){const t=new Date(1e3*e);return null===e?"---":t.toLocaleString()}function generateContents(e,t,i,s){if("popup"===i){const i={label:"${close}",action:[{name:"dialog",params:["."+s.config.name,"hide"]}]};s.show();const n=shmi.createControl("container",s.contentElement,{},"DIV");shmi.createControl("iq-button",s.contentElement,i,"DIV"),n.element.innerHTML=shmi.localize(shmi.evalString(e,t))}else s.innerHTML=shmi.localize(shmi.evalString(e,t));if(!t.ALARM_URLS_MATCHED){const e=shmi.getElementsByAttribute("class","link-container",s.element);e[0]&&(e[0].style.display="none")}}function showAlarmDetails(e,t,i,s){let n="",a="templates/default/iq-alarm-list/detail-win.html",l=!1;s.config["detail-template"]&&(a=`templates/${s.config["detail-template"]}.html`),shmi.loadResource(a,(function(a){if(""!==a){if(e)for(const t in e.attributes){let i=e.attributes[t];"string"==typeof i&&0===i.indexOf("[URL]")&&(i=i.replace("[URL]",""),n+=t+": <a href='"+i+"' target='_blank'>"+i+"</a><br />",l=!0)}let r={};if(r=null===e?{ALARM_COME:"",ALARM_GONE:"",ALARM_ACK:"",ALARM_ACKBY:"",ALARM_INDEX:"",ALARM_TITLE:"",ALARM_URLS:"",ALARM_URLS_MATCHED:!1,ALARM_TEXT:""}:{ALARM_COME:formatTime(e.timestamp_in),ALARM_GONE:formatTime(e.timestamp_out),ALARM_ACK:formatTime(e.timestamp_acknowledged),ALARM_ACKBY:(o=e.acknowledged_by,null===o?"---":o),ALARM_INDEX:e.index,ALARM_TITLE:shmi.evalString(shmi.localize("${alarm_title_"+e.index+"}"),e),ALARM_URLS:n,ALARM_URLS_MATCHED:l,ALARM_TEXT:shmi.evalString(shmi.localize("${alarm_msg_"+e.index+"}"),e)},"popup"===t){const e=shmi.ctrl(".alarmDetailsPopup");e&&shmi.deleteControl(e);const i={name:"alarmDetailsPopup","class-name":"dialog-box iq-alarm-list","top-level":!0,title:"Alarm Details"},n=shmi.createControl("dialog-box",s.element.parentNode,i,"DIV");n.enable(),n.active?generateContents(a,r,t,n):n.listen("enable",(function(e){generateContents(a,r,t,n)}))}else generateContents(a,r,t,i)}var o}))}s.run=function(e){const t=shmi.requires("visuals.session.ItemManager"),i=t.getItemHandler();let s=null,n=[];const a=shmi.createControl("iq-button",e.element.parentNode,{label:"${alarmlist_show_detail}"},"DIV");i.setValue=function(e){try{s=JSON.parse(e)}catch(e){console.error("Error parsing alarmInfo data")}},n.push(a.listen("click",(function(){showAlarmDetails(s,"popup",null,e)}))),e.config.item&&n.push(t.subscribeItem(e.config.item,i)),e.onDisable=function(){e.run=!1,n.forEach((function(e){e.unlisten()})),n=[],shmi.deleteControl(a,!0)}},s.showAlarmDetails=function(e,t,i,s){showAlarmDetails(e,t,i,s)},i("module loaded")}(),function(){"use strict";var e={"class-name":"iq-button-rocker",name:null,template:"default/iq-button-rocker.iq-variant-01",label:"[Label]",item:null,min:Number.NEGATIVE_INFINITY,max:Number.POSITIVE_INFINITY,step:1,precision:-1,"decimal-delimiter":".",type:shmi.c("TYPE_INT"),"unit-text":"[Unit]","auto-label":!0,"auto-unit-text":!0,"auto-min":!0,"auto-max":!0,"auto-step":!0,"auto-precision":!0,"auto-type":!0,"numpad-enabled":!1,"show-icon":!1,"icon-src":null,"icon-class":null,tooltip:null,"auto-repeat":!1,"auto-repeat-interval":250},t=shmi.requires("visuals.tools.logging").createLogger("iq-button-rocker",!0,!1);t.fLog,t.log;function setUnitTextImpl(e,t){e.vars.unitEl&&(""===t||null==t?(e.vars.unit="",e.vars.unitEl.textContent="",shmi.addClass(e.element,"no-unit")):(e.vars.unit=t,e.vars.unitEl.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-unit")))}function setLabelImpl(e,t){e.vars.labelEl&&(""===t||null==t?(e.vars.label="",e.vars.labelEl.textContent="",shmi.addClass(e.element,"no-label")):(e.vars.label=t,e.vars.labelEl.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-label")))}function getButtonStepping(e){return e.vars.valueSettings&&"number"==typeof e.vars.valueSettings.step&&e.vars.valueSettings.step>0?e.vars.valueSettings.step:1}function getValueSettings(e){const t=e.getConfig(),i={vars:{valueSettings:e.vars.valueSettings?shmi.cloneObject(e.vars.valueSettings):t},config:t};return i.vars.valueSettings.step=0,i}function incValue(e,t){e.vars.valueSettings||e.imports.nv.initValueSettings(e),e.vars.currentValueEl.blur(),e.vars.value=e.imports.nv.applyInputSettings(Number(e.vars.value)+t,getValueSettings(e)),e.updateValue(),void 0!==e.vars.value&&e.setCurrentElementValue()}var i={className:"iq-button-rocker",uiType:"iq-button-rocker",isContainer:!1,config:e,configSchema:null,vars:{listeners:[],value:0,active:!1,prevEl:null,nextEl:null,currentValueEl:null,labelEl:null,unitEl:null,iconEl:null,label:null,isInputTag:null,valueSettings:null,buttonInterval:0},imports:{im:"visuals.session.ItemManager",nv:"visuals.tools.numericValues"},events:["change"],prototypeExtensions:{onInit:function(){var e=this;if(e.vars.prevEl=shmi.getUiElement("previous",e.element),e.vars.nextEl=shmi.getUiElement("next",e.element),e.vars.currentValueEl=shmi.getUiElement("current",e.element),e.vars.labelEl=shmi.getUiElement("label",e.element),e.vars.unitEl=shmi.getUiElement("unit",e.element),e.vars.iconEl=shmi.getUiElement("icon",e.element),e.vars.currentValueEl&&(e.vars.isInputTag="INPUT"===e.vars.currentValueEl.tagName),e.vars.iconEl)if(e.config["icon-src"]&&e.config["show-icon"])e.vars.iconEl.style.backgroundImage=`url(${e.config["icon-src"]})`;else if(e.config["icon-class"]&&e.config["show-icon"]){e.config["icon-class"].trim().split(" ").forEach((function(t){shmi.addClass(e.vars.iconEl,t)}))}else shmi.addClass(e.element,"no-icon");else shmi.log("[IQ:iq-button-rocker] no button-icon element provided",1);if(null===e.vars.prevEl||null===e.vars.nextEl||null===e.vars.currentValueEl)return shmi.log("[IQ:iq-button-rocker] One of the elements is missing (previous, next, current)",3),e.vars.prevEl=null,e.vars.nextEl=null,e.vars.currentValueEl=null,e.vars.labelEl=null,e.vars.unitEl=null,void(e.vars.iconEl=null);setUnitTextImpl(e,e.config["unit-text"]),setLabelImpl(e,e.config.label),void 0!==e.vars.value&&e.setCurrentElementValue(),e.createInputField(e.vars.currentValueEl,e.validate.bind(e));let t=!1;var i={onPress:function(i,s,n){shmi.addClass(e.vars.prevEl,"pressed"),!0===e.config["auto-repeat"]&&(clearInterval(e.vars.buttonInterval),t=!1,e.vars.buttonInterval=setInterval(()=>{t=!0,incValue(e,-getButtonStepping(e))},e.config["auto-repeat-interval"]))},onRelease:function(){shmi.removeClass(e.vars.prevEl,"pressed"),!0===e.config["auto-repeat"]&&clearInterval(e.vars.buttonInterval)},onClick:function(){t||incValue(e,-getButtonStepping(e))}};e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.vars.prevEl,i)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.vars.prevEl,i));var s={onPress:function(i,s,n){shmi.addClass(e.vars.nextEl,"pressed"),!0===e.config["auto-repeat"]&&(clearInterval(e.vars.buttonInterval),t=!1,e.vars.buttonInterval=setInterval(()=>{t=!0,incValue(e,getButtonStepping(e))},e.config["auto-repeat-interval"]))},onRelease:function(){shmi.removeClass(e.vars.nextEl,"pressed"),!0===e.config["auto-repeat"]&&clearInterval(e.vars.buttonInterval)},onClick:function(){t||incValue(e,getButtonStepping(e))}};e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.vars.nextEl,s)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.vars.nextEl,s)),e.vars.currentValueEl.addEventListener("keydown",(function(t){if(e.config.type===shmi.c("TYPE_FLOAT")){var i="."===e.config["decimal-delimiter"]?",":".";t.key===i&&t.preventDefault()}}))},onEnable:function(){this.vars.listeners.forEach((function(e){e.enable()})),this.config.item&&(this.vars.subscriptionTargetId=this.imports.im.subscribeItem(this.config.item,this)),shmi.log("[IQ:iq-button-rocker] Enabled",1)},onDisable:function(){this.vars.listeners.forEach((function(e){e.disable()})),this.config.item&&this.imports.im.unsubscribeItem(this.config.item,this.vars.subscriptionTargetId),shmi.log("[IQ:iq-button-rocker] disabled",1)},onLock:function(){this.vars.currentValueEl.blur(),this.vars.listeners.forEach((function(e){e.disable()})),shmi.addClass(this.element,"locked"),this.vars.isInputTag&&(this.vars.currentValueEl.disabled=!0),shmi.log("[IQ:iq-button-rocker] Locked",1)},onUnlock:function(){this.vars.listeners.forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked"),this.vars.isInputTag&&(this.vars.currentValueEl.disabled=!1),shmi.log("[IQ:iq-button-rocker] unlocked",1)},onSetValue:function(e,t,i){this.vars.value=e,this.setCurrentElementValue()},getValue:function(){return this.vars.value},onSetProperties:function(e,t,i){var s=this;s.imports.nv.setProperties(s,arguments)},setUnitText:function(e){this.vars.unitEl&&this.config["auto-unit-text"]&&setUnitTextImpl(this,e)},setLabel:function(e){this.vars.labelEl&&this.config["auto-label"]&&setLabelImpl(this,e)},createInputField:function(e,t){var i=this;if(e){var s={onClick:function(){var t=shmi.requires("visuals.session.config"),s=t.keyboard&&t.keyboard.enabled;if(i.config["numpad-enabled"]||s){var n,a=shmi.visuals.session.ItemManager,l=shmi.requires("visuals.tools.numericValues"),o={"decimal-delimiter":i.config["decimal-delimiter"],unit:void 0!==i.vars.unit?i.vars.unit:i.config["unit-text"],label:void 0!==i.vars.label?i.vars.label:i.config.label,value:i.vars.value,callback:function(e){i.vars.value=e,i.updateValue(),i.setCurrentElementValue()}};return i.vars&&i.vars.valueSettings||l.initValueSettings(i),n=i.vars.valueSettings,o.min=n.min,o.max=n.max,o.type=n.type,o.precision=n.precision,o.item="string"==typeof i.config.item&&i.config.item.length>0?i.config.item:null,i.config.item&&a.getItem(i.config.item)&&i.config["auto-type"]&&(i.type=a.items[i.config.item].type),void shmi.numpad(o)}if(shmi.addClass(e,"selectableText"),i.vars.isInputTag)i.vars.currentValueEl.setSelectionRange(0,i.vars.currentValueEl.value.length);else{e.setAttribute("contenteditable",!0);var r=document.createRange();e.focus(),e.firstChild&&e.firstChild instanceof Text?(r.setStart(e.firstChild,0),r.setEnd(e.firstChild,e.firstChild.length),window.getSelection().removeAllRanges(),window.getSelection().addRange(r)):shmi.log("[IQ:iq-button-rocker] Element not found",0)}}};i.vars.listeners.push(new shmi.visuals.io.MouseListener(e,s)),i.vars.listeners.push(new shmi.visuals.io.TouchListener(e,s)),e.addEventListener("keypress",(function(t){13===t.keyCode&&(t.preventDefault(),window.getSelection().removeAllRanges(),e.blur())})),e.addEventListener("blur",(function(){i.vars.isInputTag||e.setAttribute("contenteditable",!1),window.getSelection().removeAllRanges(),shmi.removeClass(e,"selectableText"),shmi.log("[IQ:iq-button-rocker] Blur event",0),t(e)}))}else shmi.log("[IQ:iq-button-rocker] No base element provided",3)},validate:function(e){var t=null,i=this.config.item&&this.config["auto-type"]?this.vars.valueSettings.type:this.config.type;t=this.vars.isInputTag?this.vars.currentValueEl.value:this.vars.currentValueEl.textContent;var s=String(t).replace(this.config["decimal-delimiter"],".");if(-1===[shmi.c("TYPE_INT"),shmi.c("TYPE_FLOAT")].indexOf(i))return shmi.log("[IQ:iq-button-rocker] Invalid value type '"+this.config.type+"' configured",3),void this.setCurrentElementValue();new RegExp(this.floatRegexp).test(s)?(shmi.log("[IQ:iq-button-rocker] Valid value",1),this.vars.value=this.imports.nv.applyInputSettings(s,getValueSettings(this)),this.updateValue()):shmi.log("[IQ:iq-button-rocker] Invalid value",1),this.setCurrentElementValue()},updateValue:function(){this.fire("change",{value:this.vars.value}),this.config.item&&shmi.visuals.session.ItemManager.writeValue(this.config.item,this.vars.value)},setCurrentElementValue:function(){this.vars.isInputTag?this.vars.currentValueEl.value=this.imports.nv.formatOutput(this.vars.value,this):this.vars.currentValueEl.textContent=this.imports.nv.formatOutput(this.vars.value,this)},floatRegexp:"(^[+-]?[0-9]([.][0-9]*)?$|^[+-]?[1-9]+[0-9]*([.][0-9]*)?$)"}};shmi.requires("visuals.tools.control-generator").generate(i)}(),function(){"use strict";var e=shmi.requires("visuals.tools.logging").createLogger("iq-button-toggle",!0,!1);e.fLog,e.log;function setLabelImpl(e,t){e.vars.labelEl&&(""!==t&&null!=t&&e.config["show-text"]?(e.vars.label=t,e.vars.labelEl.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-label")):(e.vars.label="",e.vars.labelEl.textContent="",shmi.addClass(e.element,"no-label")))}var t={className:"iq-button-toggle",uiType:"iq-button-toggle",isContainer:!1,config:{"class-name":"iq-button-toggle",name:null,template:"default/iq-button-toggle.variant-01",label:"[Label]",item:null,"auto-label":!0,tooltip:null,"on-value":1,"off-value":0,"confirm-on":!1,"confirm-off":!1,"on-label":"ON","off-label":"OFF","on-show-text":!0,"on-show-icon":!1,"on-icon-src":null,"on-icon-class":null,"on-tooltip":null,"off-show-text":!0,"off-show-icon":!1,"off-icon-src":null,"off-icon-class":null,"off-tooltip":null,"confirm-on-text":"${V_CONFIRM_ON}","confirm-off-text":"${V_CONFIRM_OFF}","show-icon":!1,"show-text":!0,"on-action":[],"off-action":[],"icon-src":null,"icon-class":null},configSchema:null,vars:{listeners:[],value:0,active:!1,labelEl:null,buttonEl:null,offStateEl:null,onStateEl:null,onLabelEl:null,offLabelEl:null,iconEl:null,onIconEl:null,offIconEl:null,initialized:!1,subscriptionTargetId:null,onAction:null,offAction:null},imports:{im:"visuals.session.ItemManager"},events:["change"],prototypeExtensions:{onInit:function(){var e=this,t=shmi.requires("visuals.core");if(e.vars.labelEl=shmi.getUiElement("label",e.element),e.vars.buttonEl=shmi.getUiElement("button",e.element),e.vars.iconEl=shmi.getUiElement("icon",e.element),e.vars.offStateEl=shmi.getUiElement("off-state",e.element),e.vars.offStateEl&&(e.vars.offLabelEl=shmi.getUiElement("label",e.vars.offStateEl),e.vars.offIconEl=shmi.getUiElement("toggle-icon",e.vars.offStateEl),e.vars.offLabelEl&&e.config["off-label"]&&e.config["off-show-text"]?e.vars.offLabelEl.textContent=shmi.localize(e.config["off-label"]):shmi.addClass(e.vars.offStateEl,"no-label"),e.vars.offIconEl&&e.config["off-show-icon"]&&(e.config["off-icon-class"]||e.config["off-icon-src"])?e.setupIconElement(e.vars.offIconEl,e.config["off-icon-class"],e.config["off-icon-src"],e.config["off-show-icon"],e.config["off-show-text"]):shmi.addClass(e.vars.offStateEl,"no-icon")),e.vars.onStateEl=shmi.getUiElement("on-state",e.element),e.vars.onStateEl&&(e.vars.onLabelEl=shmi.getUiElement("label",e.vars.onStateEl),e.vars.onIconEl=shmi.getUiElement("toggle-icon",e.vars.onStateEl),e.vars.onLabelEl&&e.config["on-label"]&&e.config["on-show-text"]?e.vars.onLabelEl.textContent=shmi.localize(e.config["on-label"]):shmi.addClass(e.vars.onStateEl,"no-label"),e.vars.onIconEl&&e.config["on-show-icon"]&&(e.config["on-icon-class"]||e.config["on-icon-src"])?e.setupIconElement(e.vars.onIconEl,e.config["on-icon-class"],e.config["on-icon-src"],e.config["on-show-icon"],e.config["on-show-text"]):shmi.addClass(e.vars.onStateEl,"no-icon")),e.vars.offStateEl&&e.vars.onStateEl){if(setLabelImpl(e,e.config.label),e.vars.iconEl)if(e.config["icon-src"]&&e.config["show-icon"])e.vars.iconEl.style.backgroundImage=`url(${e.config["icon-src"]})`;else if(e.config["icon-class"]&&e.config["show-icon"]){e.config["icon-class"].trim().split(" ").forEach((function(t){shmi.addClass(e.vars.iconEl,t)}))}else shmi.addClass(e.element,"no-icon");else shmi.addClass(e.element,"no-icon"),shmi.log("[IQ:iq-button-rocker] no button-icon element provided",1);var i={onPress:function(){shmi.log("[IQ:iq-button-toggle] Button pressed",0),shmi.addClass(e.element,"pressed")},onRelease:function(){shmi.log("[IQ:iq-button-toggle] Button released",0),shmi.removeClass(e.element,"pressed")},onClick:function(){e.vars.value===e.config["on-value"]?e.config["confirm-off"]?shmi.confirm(e.config["confirm-off-text"],(function(t){t&&e.toggle()})):e.toggle():e.config["confirm-on"]?shmi.confirm(e.config["confirm-on-text"],(function(t){t&&e.toggle()})):e.toggle()}};e.vars.buttonEl?(e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.vars.buttonEl,i)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.vars.buttonEl,i))):shmi.log("[IQ:iq-button-rocker] no button element provided",1),!e.config.item&&e.config.event&&(e.config["on-value"]=1,e.config["off-value"]=0),e.vars.value=e.config["off-value"],Array.isArray(e.config["on-action"])&&e.config["on-action"].length&&(e.vars.onAction=new t.UiAction(e.config["on-action"],e)),Array.isArray(e.config["off-action"])&&e.config["off-action"].length&&(e.vars.offAction=new t.UiAction(e.config["off-action"],e))}else shmi.log("[IQ:iq-button-toggle] At least one state element is missing",1)},onEnable:function(){this.vars.listeners.forEach((function(e){e.enable()})),this.config.item&&(this.vars.subscriptionTargetId=this.imports.im.subscribeItem(this.config.item,this)),shmi.log("[IQ:iq-button-toggle] Enabled",1)},onDisable:function(){this.vars.listeners.forEach((function(e){e.disable()})),this.config.item&&this.imports.im.unsubscribeItem(this.config.item,this.vars.subscriptionTargetId),shmi.log("[IQ:iq-button-toggle] disabled",1)},onLock:function(){this.vars.listeners.forEach((function(e){e.disable()})),shmi.addClass(this.element,"locked"),shmi.log("[IQ:iq-button-toggle] Locked",1)},onUnlock:function(){this.vars.listeners.forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked"),shmi.log("[IQ:iq-button-toggle] unlocked",1)},toggle:function(){var e=this.vars.value!==this.config["on-value"];this.config.item?e?this.imports.im.writeValue(this.config.item,this.config["on-value"]):this.imports.im.writeValue(this.config.item,this.config["off-value"]):e?this.setValue(this.config["on-value"]):this.setValue(this.config["off-value"]),e&&this.vars.onAction?this.vars.onAction.execute():!e&&this.vars.offAction&&this.vars.offAction.execute()},getTooltip:function(){var e=shmi.visuals.core.BaseControl.prototype.getTooltip.call(this);if(e)return e;if(this.vars.value===this.config["off-value"]){if(shmi.objectHasOwnProperty(this.config,"off-tooltip"))return this.config["off-tooltip"]}else if(this.vars.value===this.config["on-value"]&&shmi.objectHasOwnProperty(this.config,"on-tooltip"))return this.config["on-tooltip"];return null},onSetValue:function(e,t,i){var s=this.vars.value;this.vars.value=parseFloat(e),this.vars.value===this.config["off-value"]?(shmi.removeClass(this.vars.buttonEl,"iq-on-state"),shmi.addClass(this.vars.buttonEl,"iq-off-state")):(shmi.removeClass(this.vars.buttonEl,"iq-off-state"),shmi.addClass(this.vars.buttonEl,"iq-on-state")),this.vars.value!==s&&(this.setTooltip(this.getTooltip()),this.fire("change",{value:this.vars.value}))},getValue:function(){return this.vars.value},setLabel:function(e){this.vars.labelEl&&this.config["auto-label"]&&setLabelImpl(this,e)},setupIconElement:function(e,t,i){t?t.trim().split(" ").forEach((function(t){shmi.addClass(e,t)})):i&&(e.style.backgroundImage=`url(${i})`)}}};shmi.requires("visuals.tools.control-generator").generate(t)}(),function(){"use strict";var e=shmi.requires("visuals.tools.logging").createLogger("iq-button",!0,!1);e.fLog,e.log;function setLabelImpl(e,t){e.vars.labelEl&&(""===t||null==t?(e.vars.label="",e.vars.labelEl.textContent="",shmi.addClass(e.element,"no-label")):(e.vars.label=t,e.vars.labelEl.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-label")))}var t={className:"iq-button",uiType:"iq-button",isContainer:!1,config:{"class-name":"iq-button",name:null,template:"default/iq-button.iq-variant-01",item:null,label:"[Label]","auto-label":!0,"label-from-item":!1,"icon-src":null,"icon-class":null,action:null,onClick:null,tooltip:null,"write-bool":!1,"on-value":1,"off-value":0,"action-release":null,"action-while-pressed":null,"interval-while-pressed":null,"action-pressed":null,"disable-alarms":!1,"show-icon":!1},configSchema:null,tooltipProperties:["tooltip"],vars:{listeners:[],value:0,active:!1,buttonEl:null,labelEl:null,iconEl:null,label:null,action:null,actionPress:null,actionRelease:null,actionWhilePressed:null,actionWhilePressedTimer:null,keyDownListener:null,keyUpListener:null,keyDownOnMe:null,mouseListener:null,touchListener:null,initialized:!1,rafId:0,subscriptionTargetId:null,monoFlopInterval:0,conditional:null,tokens:[]},imports:{im:"visuals.session.ItemManager",nv:"visuals.tools.numericValues"},events:["press","release","click"],prototypeExtensions:{onInit:function(){var e=this;if(e.imports.nv.initValueSettings(e),e.vars.buttonEl=shmi.getUiElement("button",e.element),e.vars.labelEl=shmi.getUiElement("label",e.element),e.vars.iconEl=shmi.getUiElement("icon",e.element),e.vars.iconEl)if(e.config["icon-src"]&&e.config["show-icon"])e.vars.iconEl.style.backgroundImage=`url(${e.config["icon-src"]})`;else if(e.config["icon-class"]&&e.config["show-icon"]){e.config["icon-class"].trim().split(" ").forEach(shmi.addClass.bind(shmi,e.vars.iconEl))}else shmi.addClass(e.element,"no-icon");else shmi.log("[IQ:iq-button] no button-icon element provided",1);if(!e.vars.buttonEl)return shmi.log("[IQ:iq-button] template is missing button element",3),e.vars.buttonEl=null,e.vars.labelEl=null,void(e.vars.iconEl=null);setLabelImpl(e,e.config.label),e.config.action&&(e.vars.action=new shmi.visuals.core.UiAction(e.config.action,e)),e.config["action-press"]&&(e.vars.actionPress=new shmi.visuals.core.UiAction(e.config["action-press"],e)),e.config["action-release"]&&(e.vars.actionRelease=new shmi.visuals.core.UiAction(e.config["action-release"],e)),e.config["action-while-pressed"]&&(e.vars.actionWhilePressed=new shmi.visuals.core.UiAction(e.config["action-while-pressed"],e));var t=shmi.visuals.session,i={onClick:function(i,s,n){null!==t.FocusElement&&(t.FocusElement.blur(),t.FocusElement=null),e.vars.buttonEl instanceof HTMLElement?(e.vars.buttonEl.focus(),t.FocusElement=e.vars.buttonEl,shmi.log("[IQ:iq-button] focused",1)):shmi.log("[IQ:iq-button] only HTMLElements may be focused, type: "+e.vars.buttonEl.constructor,1),e.fire("click",{x:i,y:s,event:n}),e.vars.action&&e.vars.action.execute(),e.onClick&&e.onClick(e)},onRelease:function(t,i,s){shmi.removeClass(e.vars.buttonEl,"pressed"),e.fire("release",{x:t,y:i,event:s}),e.config["write-bool"]&&e.config.item&&e.writeValue(e.config["off-value"]),e.vars.actionWhilePressedTimer&&clearInterval(e.vars.actionWhilePressedTimer),e.vars.actionRelease&&e.vars.actionRelease.execute()},onPress:function(t,i,s){shmi.addClass(e.vars.buttonEl,"pressed"),e.fire("press",{x:t,y:i,event:s}),e.config["write-bool"]&&e.config.item&&e.writeValue(e.config["on-value"]),e.vars.actionPress&&e.vars.actionPress.execute(),e.vars.actionWhilePressed&&e.config["interval-while-pressed"]&&(e.vars.actionWhilePressedTimer&&clearInterval(e.vars.actionWhilePressedTimer),e.vars.actionWhilePressedTimer=setInterval((function(){e.vars.actionWhilePressed.execute()}),e.config["interval-while-pressed"]))}};e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.vars.buttonEl,i)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.vars.buttonEl,i)),e.vars.keyUpListener=function(t){if(e.vars.keyDownOnMe&&("Enter"===t.code||"NumpadEnter"===t.code)&&e.element===document.activeElement){shmi.removeClass(e.element,"pressed");var s=e.element.getBoundingClientRect();i.onClick(s.left+s.width/2,s.top+s.height/2,t),e.vars.keyDownOnMe=!1}},e.vars.keyDownListener=function(t){"Enter"!==t.code&&"NumpadEnter"!==t.code||e.element!==document.activeElement||(shmi.addClass(e.element,"pressed"),e.vars.keyDownOnMe=!0)}},onEnable:function(){var e=this;if(null!==e.vars.conditional?e.vars.conditional.item!==e.config.item&&(e.vars.conditional.item=e.config.item):e.config.item&&!e.config["disable-alarms"]&&(e.vars.conditional=shmi.createConditional(e.element,e.config.item)),e.vars.conditional&&e.vars.conditional.enable(),e.element.setAttribute("tabindex","0"),e.vars.listeners.forEach((function(e){e.enable()})),e.config.item){if(e.config["disable-item-lock"]){var t=e.imports.im.getItemHandler();t.setValue=function(t){e.setValue(t)},e.vars.subscriptionTargetId=e.imports.im.subscribeItem(e.config.item,t)}else e.vars.subscriptionTargetId=e.imports.im.subscribeItem(e.config.item,e);if(e.config.monoflop){var i=e.listen("press",(function(){clearInterval(e.vars.monoFlopInterval),e.vars.monoFlopInterval=setInterval((function(){var t={[e.config.item]:e.config["monoflop-value"]};e.imports.im.writeDirect(t,(function(t,i){0!==t&&console.error("[iq-button: ItemManager] failed to write item:",e.config.item,t,i)}))}),e.config["monoflop-interval"])})),s=e.listen("release",(function(){clearInterval(e.vars.monoFlopInterval)}));e.vars.tokens.push(i,s)}}e.element.addEventListener("keyup",e.vars.keyUpListener,!1),e.element.addEventListener("keydown",e.vars.keyDownListener,!1),shmi.log("[IQ:iq-button] Enabled",1)},onDisable:function(){this.vars.conditional&&this.vars.conditional.disable(),this.config.item&&this.imports.im.unsubscribeItem(this.config.item,this.vars.subscriptionTargetId),this.element.removeAttribute("tabindex"),this.vars.tokens.forEach((function(e){e.unlisten()})),this.vars.tokens=[],this.vars.listeners.forEach((function(e){e.disable()})),this.element.removeEventListener("keyup",this.vars.keyUpListener),this.element.removeEventListener("keydown",this.vars.keyDownListener),this.vars.actionWhilePressedTimer&&(clearInterval(this.vars.actionWhilePressedTimer),this.vars.actionWhilePressedTimer=null),shmi.log("[IQ:iq-button] disabled",1)},onLock:function(){this.vars.listeners.forEach((function(e){e.disable()})),this.vars.buttonEl&&(this.vars.buttonEl.removeAttribute("tabindex"),this.vars.buttonEl.removeEventListener("keyup",this.vars.keyUpListener),this.vars.buttonEl.removeEventListener("keydown",this.vars.keyDownListener),this.vars.buttonEl.blur()),shmi.addClass(this.element,"locked"),shmi.log("[IQ:iq-button] Locked",1)},onUnlock:function(){this.vars.listeners.forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked"),this.vars.buttonEl&&(this.vars.buttonEl.addEventListener("keyup",this.vars.keyUpListener,!1),this.vars.buttonEl.addEventListener("keydown",this.vars.keyDownListener,!1),this.vars.buttonEl.setAttribute("tabindex",0)),shmi.log("[IQ:iq-button] unlocked",1)},onSetValue:function(e,t,i){var s=this;s.vars.value=e,!0===s.config["label-from-item"]&&(shmi.caf(s.rafId),s.rafId=shmi.raf((function(){setLabelImpl(s,shmi.localize(s.imports.nv.formatOutput(e,s)))})))},getValue:function(){return this.vars.value},onSetProperties:function(e,t,i){var s=this;s.imports.nv.setProperties(s,arguments)},setLabel:function(e){this.vars.labelEl&&this.config["auto-label"]&&setLabelImpl(this,e)},writeValue:function(e){var t=this;if(t.config.item){var i={};i[t.config.item]=e,t.imports.im.writeDirect(i,(function(e,i){0!==e&&console.error("[iq-button: ItemManager] failed to write item:",t.config.item,e,i)}))}}}};shmi.requires("visuals.tools.control-generator").generate(t)}(),function(){"use strict";var e={"class-name":"iq-checkbox",name:null,template:"default/iq-checkbox.variant-01",label:"[Label]",item:null,type:shmi.c("TYPE_INT"),"auto-label":!0,"show-icon":!1,"show-text":!0,"icon-src":null,"icon-class":null,tooltip:null,"on-value":1,"off-value":0,"pressed-class":"pressed","confirm-off-text":"${V_CONFIRM_OFF}","confirm-on-text":"${V_CONFIRM_ON}","confirm-on":!1,"confirm-off":!1},t=shmi.requires("visuals.tools.logging").createLogger("iq-checkbox",!0,!1);t.fLog,t.log;function setLabelImpl(e,t){e.vars.labelEl&&(""===t||null==t?(e.vars.label="",e.vars.labelEl.textContent="",shmi.addClass(e.element,"no-label")):(e.vars.label=t,e.vars.labelEl.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-label")))}var i={className:"iq-checkbox",uiType:"iq-checkbox",isContainer:!1,config:e,configSchema:null,vars:{listeners:[],value:0,active:!1,checkboxEl:null,labelEl:null,iconEl:null,containerEl:null,label:null},imports:{im:"visuals.session.ItemManager",nv:"visuals.tools.numericValues"},events:["change"],prototypeExtensions:{onInit:function(){var e=this;if(e.vars.checkboxEl=shmi.getUiElement("checkbox",e.element),e.vars.labelEl=shmi.getUiElement("label",e.element),e.vars.iconEl=shmi.getUiElement("icon",e.element),e.vars.containerEl=shmi.getUiElement("iq-checkbox-container",e.element),e.vars.iconEl?e.config["icon-src"]&&e.config["show-icon"]?e.vars.iconEl.style.backgroundImage=`url(${e.config["icon-src"]})`:e.config["icon-class"]&&e.config["show-icon"]?shmi.addClass(e.vars.iconEl,e.config["icon-class"]):shmi.addClass(e.element,"no-icon"):(shmi.log("[IQ:iq-checkbox] no button-icon element provided",1),shmi.addClass(e.element,"no-icon")),null===e.vars.checkboxEl)return shmi.log("[IQ:iq-checkbox] Checkbox element is missing",3),e.vars.checkboxEl=null,e.vars.labelEl=null,void(e.vars.iconEl=null);if(e.config["show-text"]?setLabelImpl(e,e.config.label):setLabelImpl(e,null),e.vars.containerEl){var t={onPress:function(t,i,s){shmi.addClass(e.element,e.config["pressed-class"])},onRelease:function(){shmi.removeClass(e.element,e.config["pressed-class"])},onClick:function(t,i,s){s.preventDefault(),e.value===e.config["on-value"]?e.config["confirm-off"]?shmi.confirm(e.config["confirm-off-text"],(function onConfirmed(t){t&&e.updateValue(e.config["off-value"])})):e.updateValue(e.config["off-value"]):e.config["confirm-on"]?shmi.confirm(e.config["confirm-on-text"],(function onConfirmed(t){t&&e.updateValue(e.config["on-value"])})):e.updateValue(e.config["on-value"])}};e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.vars.containerEl,t)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.vars.containerEl,t))}else console.error("[IQ:iq-checkbox] 'iq-checkbox-container' element is missing, cannot attach listener.")},onEnable:function(){this.vars.listeners.forEach((function(e){e.enable()})),this.config.item&&(this.vars.subscriptionTargetId=this.imports.im.subscribeItem(this.config.item,this)),shmi.log("[IQ:iq-checkbox] Enabled",1)},onDisable:function(){this.vars.listeners.forEach((function(e){e.disable()})),this.config.item&&this.imports.im.unsubscribeItem(this.config.item,this.vars.subscriptionTargetId),shmi.log("[IQ:iq-checkbox] disabled",1)},onLock:function(){this.vars.checkboxEl.blur(),this.vars.listeners.forEach((function(e){e.disable()})),shmi.addClass(this.element,"locked"),this.vars.checkboxEl.disabled=!0,shmi.log("[IQ:iq-checkbox] Locked",1)},onUnlock:function(){this.vars.listeners.forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked"),this.vars.checkboxEl.disabled=!1,shmi.log("[IQ:iq-checkbox] unlocked",1)},onSetValue:function(e,t,i){var s=!1;e===this.config["on-value"]?(this.value=this.config["on-value"],s=!0,shmi.addClass(this.element,"checked")):(this.value=this.config["off-value"],s=!0,shmi.removeClass(this.element,"checked")),s&&this.fire("change",{value:this.value})},getValue:function(){return this.vars.value},setLabel:function(e){this.vars.labelEl&&this.config["auto-label"]&&this.config["show-text"]&&setLabelImpl(this,e)},updateValue:function(e){this.config.item?this.imports.im.writeValue(this.config.item,e):this.setValue(e)}}};shmi.requires("visuals.tools.control-generator").generate(i)}(),function(){"use strict";var e=shmi.requires("visuals.tools.logging").createLogger("iq-date-time",!0,!1),t=(e.fLog,e.log,{className:"iqDateTime",uiType:"iq-date-time",isContainer:!1,config:{"class-name":"iq-date-time",name:null,template:"default/iq-date-time.variant-01",item:null,"display-utc":!1,"display-format":"$YYYY-$MM-$DD $HH:$mm:$ss","input-format":"$X","invalid-text":"${date-time.invalid-time}",tooltip:null,"value-as-tooltip":!1},configSchema:null,vars:{listeners:[],value:0,active:!1,domEl:null,subscriptionTargetId:null,localizedDisplayFormat:null,localizedInvalidText:null,rafRunning:!1,lastValue:null},imports:{im:"visuals.session.ItemManager",dt:"visuals.tools.date"},events:[],prototypeExtensions:{onInit:function(){this.vars.domEl=shmi.getUiElement("datetime",this.element),this.vars.domEl?(this.vars.localizedDisplayFormat=shmi.localize(this.config["display-format"]),this.vars.localizedInvalidText=shmi.localize(this.config["invalid-text"]),this.vars.domEl.textContent=this.vars.localizedInvalidText,this.config["value-as-tooltip"]&&this.setTooltip(this.vars.localizedInvalidText)):shmi.log("[IQ:iq-date-time] Element is missing",3)},onEnable:function(){this.config.item&&(this.vars.subscriptionTargetId=this.imports.im.subscribeItem(this.config.item,this)),shmi.log("[IQ:iq-date-time] Enabled",1)},onDisable:function(){this.vars.subscriptionTargetId&&(this.vars.subscriptionTargetId.unlisten(),this.vars.subscriptionTargetId=null),shmi.log("[IQ:iq-date-time] disabled",1)},onSetValue:function(e,t){var i=this;t===shmi.c("TYPE_INT")||t===shmi.c("TYPE_FLOAT")?i.vars.lastValue=i.imports.dt.parseDateTime(String(e),i.config["input-format"]||"$X"):i.config["input-format"]?i.vars.lastValue=i.imports.dt.parseDateTime(String(e),i.config["input-format"]):i.vars.lastValue=null,i.vars.rafRunning||(i.vars.rafRunning=!0,shmi.raf((function onDraw(){let e=null;e=i.vars.lastValue?i.imports.dt.formatDateTime(i.vars.lastValue,{datestring:i.vars.localizedDisplayFormat,utc:i.config["display-utc"]}):i.vars.localizedInvalidText,i.vars.domEl.textContent=e,i.vars.domEl.innerHTML=i.vars.domEl.innerHTML.replace(/\n/g,"<br>"),i.config["value-as-tooltip"]&&i.setTooltip(e.replace(/(\\n)+/g," ")),i.vars.rafRunning=!1})))},onLock:function(){shmi.addClass(this.element,"locked")},onUnlock:function(){shmi.removeClass(this.element,"locked")}}});shmi.requires("visuals.tools.control-generator").generate(t)}(),function(){"use strict";var e="iq-duration-display",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1);t.fLog,t.log;function setText(e,t){e.vars.durationEl&&(e.vars.durationEl.textContent=t,e.config["value-as-tooltip"]&&e.setTooltip(t))}function makeItemHandler(e,t,i){return{setValue:function setValue(s,n){n===shmi.c("TYPE_INT")||n===shmi.c("TYPE_FLOAT")?e.vars[i]=e.imports.dt.parseDateTime(String(s),e.config[t]||"$X"):e.config[t]?e.vars[i]=e.imports.dt.parseDateTime(String(s),e.config[t]):e.vars[i]=null,function doUpdate(e){null===e.vars.tsTarget||null===e.vars.tsCurrent?e.vars.lastValue=null:e.vars.lastValue=e.vars.tsTarget-e.vars.tsCurrent,e.vars.rafRunning||(e.vars.rafRunning=!0,shmi.raf((function onDraw(){e.vars.lastValue?setText(e,e.imports.dt.formatDuration(e.vars.lastValue,e.config["display-preset"]||"compact")):setText(e,e.vars.localizedInvalidText),e.vars.rafRunning=!1})))}(e)}}}var i={className:"iq-duration-display",uiType:e,isContainer:!1,config:{"class-name":"iq-duration-display",name:null,template:"default/iq-duration-display.variant-01",label:"[Label]","target-ts-item":null,"target-ts-format":"$X","current-ts-item":"Systemzeit","current-ts-format":"$X","display-preset":"compact","invalid-text":"${duration-display.invalid-duration}",tooltip:null,"value-as-tooltip":!1},configSchema:null,vars:{listeners:[],tsTarget:null,tsCurrent:null,localizedInvalidText:null,rafRunning:!1,lastValue:null,durationEl:null},imports:{im:"visuals.session.ItemManager",dt:"visuals.tools.date"},events:[],prototypeExtensions:{onInit:function(){this.vars.durationEl=shmi.getUiElement("duration",this.element),this.vars.durationEl?(this.vars.localizedInvalidText=shmi.localize(this.config["invalid-text"]),setText(this,this.vars.localizedInvalidText)):shmi.log("[IQ:iq-duration] Element is missing",3)},onEnable:function(){this.config["target-ts-item"]&&this.config["current-ts-item"]&&0===this.vars.listeners.length&&(this.vars.listeners.push(this.imports.im.subscribeItem(this.config["target-ts-item"],makeItemHandler(this,"target-ts-format","tsTarget"))),this.vars.listeners.push(this.imports.im.subscribeItem(this.config["current-ts-item"],makeItemHandler(this,"current-ts-format","tsCurrent"))))},onDisable:function(){this.vars.listeners.forEach((function(e){e.unlisten()})),this.vars.listeners=[]},onLock:function(){shmi.addClass(this.element,"locked")},onUnlock:function(){shmi.removeClass(this.element,"locked")}}};shmi.requires("visuals.tools.control-generator").generate(i)}(),function(){"use strict";var e=shmi.requires("visuals.tools.logging").createLogger("iq-flip-switch",!0,!1);e.fLog,e.log;function setLabelImpl(e,t){e.vars.labelEl?""===t||null==t?(e.vars.label="",e.vars.labelEl.textContent="",shmi.addClass(e.element,"no-label")):(e.vars.label=t,e.vars.labelEl.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-label")):shmi.addClass(e.element,"no-label")}function updateHandle(e){const t=e.getValue(),i=e.vars.handleEl?Math.ceil(e.vars.handleEl.getBoundingClientRect().width):0,s=e.vars.handleBoxEl?e.vars.handleBoxEl.clientWidth:0;!e.vars.isDragging&&e.vars.handleBoxEl&&(t===e.config["on-value"]?e.vars.handleDragOffset=s-i:e.vars.handleDragOffset=0)}var t={className:"iq-flip-switch",uiType:"iq-flip-switch",isContainer:!1,config:{"class-name":"iq-flip-switch",name:null,template:"default/iq-flip-switch.variant-01",label:"[Label]","auto-label":!0,"on-label":"${flip-switch.label-on}","off-label":"${flip-switch.label-off}",item:null,"show-icon":!1,"icon-src":null,"icon-class":null,tooltip:null,"on-value":1,"off-value":0,transitionStyle:"all .16s linear","confirm-off-text":"${V_CONFIRM_OFF}","confirm-on-text":"${V_CONFIRM_ON}","confirm-on":!1,"confirm-off":!1},configSchema:null,vars:{listeners:[],value:0,active:!1,iconEl:null,labelEl:null,labelOnEl:null,labelOffEl:null,handleEl:null,handleBoxEl:null,initialized:!1,subscriptionTargetId:null,isDragging:!1,width:null,handleWidth:null,handleDragOffset:0},imports:{im:"visuals.session.ItemManager",nv:"visuals.tools.numericValues"},events:["change"],prototypeExtensions:{onInit:function(){var e=this;if(e.vars.iconEl=shmi.getUiElement("icon",e.element),e.vars.labelEl=shmi.getUiElement("label",e.element),e.vars.labelOnEl=shmi.getUiElement("label-on",e.element),e.vars.labelOffEl=shmi.getUiElement("label-off",e.element),e.vars.handleEl=shmi.getUiElement("handle",e.element),e.vars.handleBoxEl=shmi.getUiElement("handle-box",e.element),!e.vars.handleEl||!e.vars.handleBoxEl)return shmi.log("[IQ:iq-flip-switch] Handle or handle box element is missing!",3),e.vars.labelEl=null,e.vars.labelOnEl=null,e.vars.labelOffEl=null,e.vars.handleEl=null,e.vars.handleBoxEl=null,void(e.vars.iconEl=null);if(e.vars.iconEl)if(e.config["icon-src"]&&e.config["show-icon"])e.vars.iconEl.style.backgroundImage=`url(${e.config["icon-src"]})`;else if(e.config["icon-class"]&&e.config["show-icon"]){e.config["icon-class"].trim().split(" ").forEach((function(t){shmi.addClass(e.vars.iconEl,t)}))}else shmi.addClass(e.element,"no-icon");else shmi.addClass(e.element,"no-icon"),shmi.log("[IQ:iq-flip-switch] no button-icon element provided",1);setLabelImpl(e,e.config.label),e.vars.labelOnEl&&e.config["on-label"]&&(e.vars.labelOnEl.textContent=shmi.localize(e.config["on-label"])),e.vars.labelOffEl&&e.config["on-label"]&&(e.vars.labelOffEl.textContent=shmi.localize(e.config["off-label"]));let t=null;var i={onDrag:function(i,s,n){const a=e.vars.handleEl?Math.ceil(e.vars.handleEl.getBoundingClientRect().width):0,l=e.vars.handleBoxEl?e.vars.handleBoxEl.clientWidth:0;n.preventDefault(),e.vars.handleDragOffset+i<0?e.vars.handleDragOffset=0:e.vars.handleDragOffset+i+a>l?e.vars.handleDragOffset=l-a:e.vars.handleDragOffset+=i,t&&shmi.caf(t),t=shmi.raf(()=>{e.vars.handleEl.style.transform=`translate3d(${e.vars.handleDragOffset}px, 0, 0)`}),e.vars.isDragging||(e.vars.isDragging=!0)},onPress:function(){shmi.addClass(e.vars.handleEl,"pressed")},onRelease:function(){e.vars.isDragging&&(e.vars.isDragging=!1,e.vars.handleDragOffset>(e.vars.handleBoxEl.offsetWidth-e.vars.handleEl.offsetWidth)/2?e.config["confirm-on"]?shmi.confirm(e.config["confirm-on-text"],(function(t){e.handleOnOff(!0,t)})):e.handleOnOff(!0,null):e.config["confirm-off"]?shmi.confirm(e.config["confirm-off-text"],(function(t){e.handleOnOff(!1,t)})):e.handleOnOff(!1,null)),t&&shmi.caf(t),e.vars.handleEl.style.transform="",shmi.removeClass(e.vars.handleEl,"pressed")},onClick:function(){e.vars.value===e.config["on-value"]?e.config["confirm-off"]?shmi.confirm(e.config["confirm-off-text"],(function(t){t&&e.turnOnOff(!1)})):e.turnOnOff(!1):e.config["confirm-on"]?shmi.confirm(e.config["confirm-on-text"],(function(t){t&&e.turnOnOff(!0)})):e.turnOnOff(!0)}};e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.vars.handleEl,i)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.vars.handleEl,i));var s={onClick:i.onClick};e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.vars.handleBoxEl,s)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.vars.handleBoxEl,s)),e.vars.listeners.push(function makeResizeListener(e,t){return{disable:()=>window.removeEventListener("resize",t),enable:()=>window.addEventListener("resize",t)}}(0,updateHandle.bind(null,e)))},onEnable:function(){this.config.item&&(this.vars.subscriptionTargetId=this.imports.im.subscribeItem(this.config.item,this)),this.vars.listeners.forEach((function(e){e.enable()})),shmi.log("[IQ:iq-flip-switch] Enabled",1)},onDisable:function(){this.config.item&&(this.vars.subscriptionTargetId=this.imports.im.unsubscribeItem(this.config.item,this)),this.vars.listeners.forEach((function(e){e.disable()})),shmi.log("[IQ:iq-flip-switch] disabled",1)},onLock:function(){this.vars.listeners.forEach((function(e){e.disable()})),shmi.addClass(this.element,"locked"),shmi.log("[IQ:iq-flip-switch] Locked",1)},onUnlock:function(){this.vars.listeners.forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked"),shmi.log("[IQ:iq-flip-switch] unlocked",1)},onSetValue:function(e,t,i){const s=this,n=s.vars.value;!s.vars.isDragging&&s.vars.handleBoxEl&&(e===s.config["on-value"]?(s.vars.value=s.config["on-value"],shmi.addClass(s.element,"on")):(s.vars.value=s.config["off-value"],shmi.removeClass(s.element,"on")),n!==s.vars.value&&(s.fire("change",{value:s.vars.value}),s.onChange&&s.onChange(s.vars.value)),updateHandle(s))},getValue:function(){return this.vars.value},setLabel:function(e){this.vars.labelEl&&this.config["auto-label"]&&setLabelImpl(this,e)},handleOnOff:function(e,t){var i=e?this.config["on-value"]:this.config["off-value"];!0===t||null===t?(updateHandle(this),this.config.item?shmi.visuals.session.ItemManager.writeValue(this.config.item,i):this.setValue(i)):this.setValue(this.vars.value)},turnOnOff:function(e){var t=e?this.config["on-value"]:this.config["off-value"];this.config.item?this.imports.im.writeValue(this.config.item,t):this.setValue(t)}}};shmi.requires("visuals.tools.control-generator").generate(t)}(),function(){"use strict";var e=shmi.requires("visuals.tools.logging").createLogger("iq-heartbeat",!0,!1);e.fLog,e.log;var t={className:"iqHeartbeat",uiType:"iq-heartbeat",isContainer:!1,config:{"class-name":"iq-heartbeat",name:null,template:"default/iq-heartbeat.variant-01",item:null,"item-plc":null,"timeout-plc":null,"image-ok-src":null,"image-ok-title":null,"image-fail-src":null,"image-fail-title":null,"action-fail":null,"action-ok":null,"item-hmi":null,"timeout-hmi":null,"scaling-mode":"fit-height"},configSchema:null,vars:{active:!1,imgEl:null,tokens:[],plcItemValue:null,plcItemTimer:null,hmiItemValue:null,hmiItemTimer:null,hmiItemTimerActive:!1,isDisconnected:!1,actionOk:null,actionFail:null,imagePathOk:null,imagePathFail:null,isEnabled:!1},imports:{im:"visuals.session.ItemManager"},events:[],prototypeExtensions:{onInit:function(){this.vars.imgEl=shmi.getUiElement("image",this.element),this.vars.imgEl?(this.vars.imgEl.dataset.imgOk&&this.vars.imgEl.dataset.imgFail&&(this.vars.imagePathOk=this.vars.imgEl.dataset.imgOk,this.vars.imagePathFail=this.vars.imgEl.dataset.imgFail),this.config["image-ok-src"]&&(this.vars.imagePathOk=this.config["image-ok-src"]),this.config["image-fail-src"]&&(this.vars.imagePathFail=this.config["image-fail-src"],this.setTooltip(this.config["image-fail-title"])),this.vars.imgEl.src=this.vars.imagePathFail,this.config["action-fail"]&&(this.vars.actionFail=new shmi.visuals.core.UiAction(this.config["action-fail"],this)),this.config["action-ok"]&&(this.vars.actionOk=new shmi.visuals.core.UiAction(this.config["action-ok"],this)),function applyScalingMode(e){let t="fit-height";switch(e.config["scaling-mode"]){case"fit-height":case"fit-width":case"stretch":case"contain":t=e.config["scaling-mode"]}shmi.addClass(e.element,t)}(this)):this.log("Image element is missing!",3)},onEnable:function(){var e=this;if(e.vars.isEnabled=!0,e.config["item-plc"]){let t=e.imports.im.getItemHandler();t.setValue=function(t){e.setValue(t)},e.vars.tokens.push(e.imports.im.subscribeItem(e.config["item-plc"],t))}if(e.config["item-hmi"]&&e.config["timeout-hmi"]){let t=e.imports.im.getItemHandler();t.setValue=function(t){e.vars.hmiItemValue=parseInt(t)},e.vars.tokens.push(e.imports.im.subscribeItem(e.config["item-hmi"],t)),e.vars.hmiItemTimer=setInterval((function(){if(e.vars.hmiItemTimerActive)return;e.vars.hmiItemTimerActive=!0;let t=e.vars.hmiItemValue;null===t&&(t=0),t===Number.MAX_VALUE&&(t=0),t+=1,function performCompareExchange(e,t,i,s){e.vars.isEnabled&&e.imports.im.compareExchange(e.config["item-hmi"],t,i,(function(t,n,a){a&&n?((i=t+1)>Number.MAX_SAFE_INTEGER&&(i=0),performCompareExchange(e,t,i,s)):"function"==typeof s&&s(!a)}))}(e,e.vars.hmiItemValue,t,(function(t){e.vars.hmiItemTimerActive=!1}))}),e.config["timeout-hmi"])}e.log("Enabled",1)},onDisable:function(){this.vars.isEnabled=!1,this.vars.tokens.forEach((function(e){e.unlisten()})),this.vars.tokens=[],this.vars.hmiItemTimer&&(clearInterval(this.vars.hmiItemTimer),this.vars.hmiItemTimer=null),this.vars.plcItemTimer&&(clearTimeout(this.vars.plcItemTimer),this.vars.plcItemTimer=null),this.log("Disabled",1)},setValue:function(e){var t=this;t.config["timeout-plc"]&&(t.vars.plcItemTimer&&(clearTimeout(t.vars.plcItemTimer),t.vars.plcItemTimer=null),t.vars.isDisconnected&&(t.vars.isDisconnected=!1,t.vars.actionOk&&t.vars.actionOk.execute()),t.vars.imgEl.src!==t.vars.imagePathOk&&(t.setTooltip(t.config["image-ok-title"]),t.vars.imgEl.src=t.vars.imagePathOk),t.vars.plcItemTimer=setTimeout((function(){t.vars.isDisconnected=!0,t.vars.imgEl.src=t.vars.imagePathFail,t.setTooltip(t.config["image-fail-title"]),t.vars.actionFail&&t.vars.actionFail.execute()}),t.config["timeout-plc"]))},log:function(e,t){shmi.log("[IQ:iq-heartbeat] "+e,t)}}};shmi.requires("visuals.tools.control-generator").generate(t)}(),function(){"use strict";var e=shmi.requires("visuals.tools.logging").createLogger("iq-image-changer",!0,!1);e.fLog,e.log;var t={className:"iq-image-changer",uiType:"iq-image-changer",isContainer:!1,config:{"class-name":"iq-image-changer",name:null,template:"default/iq-image-changer.variant-01",item:null,tooltip:null,options:[],"default-image":"pics/system/icons/placeholder.svg","default-title":null,"scaling-mode":"fit-height",action:null,"action-release":null,"action-while-pressed":null,"interval-while-pressed":null,"action-pressed":null,"write-bool":!1,"on-value":1,"off-value":0},configSchema:null,vars:{listeners:[],value:0,active:!1,imageEl:null,action:null,actionRelease:null,actionWhilePressed:null,actionWhilePressedTimer:null,mouseListener:null,touchListener:null,activeOption:null,subscriptionTargetId:null},imports:{im:"visuals.session.ItemManager"},events:["press","release","click"],prototypeExtensions:{onInit:function(){var e=this;e.vars.imageEl=shmi.getUiElement("image",e.element),e.config.action&&(e.vars.action=new shmi.visuals.core.UiAction(e.config.action,e)),e.config["action-press"]&&(e.vars.actionPress=new shmi.visuals.core.UiAction(e.config["action-press"],e)),e.config["action-release"]&&(e.vars.actionRelease=new shmi.visuals.core.UiAction(e.config["action-release"],e)),e.config["action-while-pressed"]&&(e.vars.actionWhilePressed=new shmi.visuals.core.UiAction(e.config["action-while-pressed"],e)),Array.isArray(e.config.action)&&e.config.action.length>0?shmi.addClass(e.vars.imageEl,"clickable"):shmi.removeClass(e.vars.imageEl,"clickable"),function applyScalingMode(e){let t="fit-height";switch(e.config["scaling-mode"]){case"fit-height":case"fit-width":case"stretch":case"contain":t=e.config["scaling-mode"]}shmi.addClass(e.element,t)}(e),e.getActive(null);const t=shmi.visuals.session;var i={onClick:function(i,s,n){null!==t.FocusElement&&(t.FocusElement.blur(),t.FocusElement=null),e.vars.imageEl instanceof HTMLElement?(e.vars.imageEl.focus(),t.FocusElement=e.vars.imageEl,shmi.log("[IQ:iq-image-changer] focused",1)):shmi.log("[IQ:iq-image-changer] only HTMLElements may be focused, type: "+e.vars.imageEl.constructor,1),e.fire("click",{x:i,y:s,event:n}),e.vars.action&&e.vars.action.execute()},onRelease:function(t,i,s){e.fire("release",{x:t,y:i,event:s}),e.config["write-bool"]&&e.config.item&&e.writeValue(e.config["off-value"]),e.vars.actionWhilePressedTimer&&clearInterval(e.vars.actionWhilePressedTimer),e.vars.actionRelease&&e.vars.actionRelease.execute()},onPress:function(t,i,s){e.fire("press",{x:t,y:i,event:s}),e.config["write-bool"]&&e.config.item&&e.writeValue(e.config["on-value"]),e.vars.actionPress&&e.vars.actionPress.execute(),e.vars.actionWhilePressed&&e.config["interval-while-pressed"]&&(e.vars.actionWhilePressedTimer&&clearInterval(e.vars.actionWhilePressedTimer),e.vars.actionWhilePressedTimer=setInterval((function(){e.vars.actionWhilePressed.execute()}),e.config["interval-while-pressed"]))}};e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.vars.imageEl,i)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.vars.imageEl,i))},onEnable:function(){this.config.item&&(this.vars.subscriptionTargetId=this.imports.im.subscribeItem(this.config.item,this)),this.vars.listeners.forEach((function(e){e.enable()})),shmi.log("[IQ:iq-image-changer] Enabled",1)},onDisable:function(){this.config.item&&this.imports.im.unsubscribeItem(this.config.item,this.vars.subscriptionTargetId),this.vars.listeners.forEach((function(e){e.disable()})),this.vars.actionWhilePressedTimer&&(clearInterval(this.vars.actionWhilePressedTimer),this.vars.actionWhilePressedTimer=null),shmi.log("[IQ:iq-image-changer] disabled",1)},onLock:function(){this.vars.listeners.forEach((function(e){e.disable()})),shmi.addClass(this.element,"locked"),this.vars.actionWhilePressedTimer&&(clearInterval(this.vars.actionWhilePressedTimer),this.vars.actionWhilePressedTimer=null),shmi.log("[IQ:iq-image-changer] Locked",1)},onUnlock:function(){this.vars.listeners.forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked"),shmi.log("[IQ:iq-image-changer] unlocked",1)},onSetValue:function(e,t,i){this.vars.value=e,this.getActive(this.vars.value)},getValue:function(){return this.value},onSetProperties:function(e,t,i,s,n,a,l,o,r,c){},getActive:function(e){const t=this;let i=t.config.options.find(t=>Number.isSafeInteger(t.mask)&&Number.isSafeInteger(t.value)?(e&t.mask)===t.value:t.value===e);i||(i={"icon-src":t.config["default-image"],label:t.config["default-title"]||null}),t.vars.activeOption=i,t.vars.imageEl.setAttribute("src",i["icon-src"]),t.setTooltip(t.getTooltip())},getTooltip:function(){var e=shmi.visuals.core.BaseControl.prototype.getTooltip.call(this);return e||(this.vars.activeOption&&this.vars.activeOption.label?this.vars.activeOption.label:null)}}};shmi.requires("visuals.tools.control-generator").generate(t)}(),function(){"use strict";var e=shmi.requires("visuals.tools.logging").createLogger("iq-image",!0,!1);e.fLog,e.log;var t={className:"iq-image",uiType:"iq-image",isContainer:!1,config:{"class-name":"iq-image",name:null,template:"default/iq-image.variant-01",tooltip:null,"image-src":"pkg://iq-image/placeholder.svg","image-alt":null,"image-title":null,"scaling-mode":"fit-height",action:null,"action-release":null,"action-while-pressed":null,"interval-while-pressed":null,"action-pressed":null,"write-bool":!1,"on-value":1,"off-value":0},configSchema:null,vars:{listeners:[],imageEl:null,action:null,actionRelease:null,actionWhilePressed:null,actionWhilePressedTimer:null,mouseListener:null,touchListener:null},imports:{},events:["press","release","click"],prototypeExtensions:{onInit:function(){var e=this;if(e.vars.imageEl=shmi.getUiElement("image",e.element),!e.vars.imageEl)return void shmi.log("[IQ:iq-image] Missing image element",3);e.vars.imageEl.setAttribute("draggable","false"),e.config["image-src"]&&e.vars.imageEl.setAttribute("src",e.config["image-src"]),e.config["image-alt"]&&e.vars.imageEl.setAttribute("alt",e.config["image-alt"]),e.config.action&&(e.vars.action=new shmi.visuals.core.UiAction(e.config.action,e)),e.config["action-press"]&&(e.vars.actionPress=new shmi.visuals.core.UiAction(e.config["action-press"],e)),e.config["action-release"]&&(e.vars.actionRelease=new shmi.visuals.core.UiAction(e.config["action-release"],e)),e.config["action-while-pressed"]&&(e.vars.actionWhilePressed=new shmi.visuals.core.UiAction(e.config["action-while-pressed"],e)),Array.isArray(e.config.action)&&e.config.action.length>0?shmi.addClass(e.vars.imageEl,"clickable"):shmi.removeClass(e.vars.imageEl,"clickable"),function applyScalingMode(e){let t="fit-height";switch(e.config["scaling-mode"]){case"fit-height":case"fit-width":case"stretch":case"contain":t=e.config["scaling-mode"]}shmi.addClass(e.element,t)}(e);const t=shmi.visuals.session;var i={onClick:function(i,s,n){null!==t.FocusElement&&(t.FocusElement.blur(),t.FocusElement=null),e.vars.imageEl instanceof HTMLElement?(e.vars.imageEl.focus(),t.FocusElement=e.vars.imageEl,shmi.log("[IQ:iq-image] focused",1)):shmi.log("[IQ:iq-image] only HTMLElements may be focused, type: "+e.vars.imageEl.constructor,1),e.fire("click",{x:i,y:s,event:n}),e.vars.action&&e.vars.action.execute()},onRelease:function(t,i,s){e.fire("release",{x:t,y:i,event:s}),e.config["write-bool"]&&e.config.item&&e.writeValue(e.config["off-value"]),e.vars.actionWhilePressedTimer&&clearInterval(e.vars.actionWhilePressedTimer),e.vars.actionRelease&&e.vars.actionRelease.execute()},onPress:function(t,i,s){e.fire("press",{x:t,y:i,event:s}),e.config["write-bool"]&&e.config.item&&e.writeValue(e.config["on-value"]),e.vars.actionPress&&e.vars.actionPress.execute(),e.vars.actionWhilePressed&&e.config["interval-while-pressed"]&&(e.vars.actionWhilePressedTimer&&clearInterval(e.vars.actionWhilePressedTimer),e.vars.actionWhilePressedTimer=setInterval((function(){e.vars.actionWhilePressed.execute()}),e.config["interval-while-pressed"]))}};e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.vars.imageEl,i)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.vars.imageEl,i))},onEnable:function(){this.vars.listeners.forEach((function(e){e.enable()})),shmi.log("[IQ:iq-image] Enabled",1)},onDisable:function(){this.vars.listeners.forEach((function(e){e.disable()})),this.vars.actionWhilePressedTimer&&(clearInterval(this.vars.actionWhilePressedTimer),this.vars.actionWhilePressedTimer=null),shmi.log("[IQ:iq-image] disabled",1)},onLock:function(){this.vars.listeners.forEach((function(e){e.disable()})),shmi.addClass(this.element,"locked"),this.vars.actionWhilePressedTimer&&(clearInterval(this.vars.actionWhilePressedTimer),this.vars.actionWhilePressedTimer=null),shmi.log("[IQ:iq-image] Locked",1)},onUnlock:function(){this.vars.listeners.forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked"),shmi.log("[IQ:iq-image] unlocked",1)}}};shmi.requires("visuals.tools.control-generator").generate(t)}(),function(){"use strict";var e="iq-input-field",t={"class-name":e,name:null,template:"default/iq-input-field.variant-01",label:"[Label]",item:null,"numeric-class":"numeric",min:Number.NEGATIVE_INFINITY,max:Number.POSITIVE_INFINITY,step:1,precision:-1,"decimal-delimiter":".",type:shmi.c("TYPE_STRING"),"unit-text":"[Unit]","auto-label":!0,"auto-unit-text":!0,"unit-scale":1,"auto-min":!0,"auto-max":!0,"auto-step":!0,"auto-precision":!0,"auto-type":!0,"numpad-enabled":!1,"show-icon":!1,"icon-src":null,"icon-class":null,tooltip:null,multiline:!1},i=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1);i.fLog,i.log;function setUnitTextImpl(e,t){e.vars.unitEl&&(""===t||null==t?(e.vars.unit="",e.vars.unitEl.textContent="",shmi.addClass(e.element,"no-unit")):(e.vars.unit=t,e.vars.unitEl.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-unit")))}function setLabelImpl(e,t){e.vars.labelEl&&(""===t||null==t?(e.vars.label="",e.vars.labelEl.textContent="",shmi.addClass(e.element,"no-label")):(e.vars.label=t,e.vars.labelEl.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-label")))}var s={className:"IqInputField",uiType:e,isContainer:!1,config:t,configSchema:null,vars:{listeners:[],value:null,active:!1,currentValueEl:null,labelEl:null,unitEl:null,iconEl:null,inputEl:null,textAreaEl:null,label:null,domListeners:[],subscriptionTargetId:null,toEnterTmr:0,wasClicked:!1,valueSettings:null,uiAction:null,focused:!1,locked:!1,floatRegexp:"(^[+-]?[0-9]([.][0-9]*)?$|^[+-]?[1-9]+[0-9]*([.][0-9]*)?$)",intRegexp:"(^[+-]?[0-9]$|^[+-]?[1-9]+[0-9]*$)",type:null},imports:{im:"visuals.session.ItemManager",nv:"visuals.tools.numericValues"},events:["change","enter"],prototypeExtensions:{onInit:function(){var e=this,t=shmi.Constants;if(e.vars.floatRegexp=new RegExp(e.vars.floatRegexp),e.vars.currentValueEl=shmi.getUiElement("input",e.element),e.vars.textareaEl=shmi.getUiElement("textarea",e.element),e.vars.labelEl=shmi.getUiElement("label",e.element),e.vars.unitEl=shmi.getUiElement("unit",e.element),e.vars.iconEl=shmi.getUiElement("icon",e.element),e.vars.currentValueEl&&e.vars.textareaEl){e.config.multiline?(e.vars.inputEl=e.vars.textareaEl,e.vars.currentValueEl.remove()):(e.vars.inputEl=e.vars.currentValueEl,e.vars.textareaEl.remove()),e.vars.inputEl.style.display="block",e.vars.inputEl.setAttribute("tabindex","0"),e.insertValue("");var i=parseInt(e.config.type);isNaN(i)||(e.vars.type=i),e.config.action&&(e.vars.uiAction=new shmi.visuals.core.UiAction(e.config.action,this)),e.config["auto-type"]||-1!==[t.TYPE_BOOL,t.TYPE_INT,t.TYPE_FLOAT].indexOf(e.vars.type)&&shmi.addClass(e.element,e.config["numeric-class"]);var s={onPress:function(t,i,s){e.vars.focused&&window.getSelection().removeAllRanges()},onClick:function(){e.vars.wasClicked=!0,e.handleFocus(),e.vars.wasClicked=!1}};if(e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.vars.inputEl,s)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.vars.inputEl,s)),e.vars.domListeners.push(e.createEventListener(e.vars.inputEl,"focus",(function(t){e.config.multiline?e.vars.focused=!0:e.vars.wasClicked||e.handleFocus()}))),e.vars.domListeners.push(e.createEventListener(e.vars.inputEl,"keypress",(function(t){(13===t.keyCode&&!e.config.multiline||9===t.keyCode)&&(t.preventDefault(),window.getSelection().removeAllRanges(),e.vars.currentValueEl.blur())}))),e.vars.domListeners.push(e.createEventListener(e.vars.inputEl,"keydown",(function(t){if(e.vars.type===shmi.c("TYPE_FLOAT")){var i="."===e.config["decimal-delimiter"]?",":".";t.key===i&&t.preventDefault()}}))),e.vars.domListeners.push(e.createEventListener(e.vars.inputEl,"blur",(function(t){e.vars.focused&&(shmi.log("[IQ:iq-input-field] blur event",1),window.getSelection().removeAllRanges(),e.validateAndSet(e.vars.inputEl),e.vars.focused=!1,shmi.visuals.session.FocusElement=null)}))),e.vars.iconEl)if(e.config["icon-src"]&&e.config["show-icon"])e.vars.iconEl.style.backgroundImage=`url(${e.config["icon-src"]})`;else if(e.config["icon-class"]&&e.config["show-icon"]){e.config["icon-class"].trim().split(" ").forEach((function(t){shmi.addClass(e.vars.iconEl,t)}))}else shmi.addClass(e.element,"no-icon");else shmi.log("[IQ:iq-input-field] no button-icon element provided",1);setUnitTextImpl(e,e.config["unit-text"]),e.config["unit-scale"]&&(e.config["unit-scale"]=parseFloat(shmi.localize(e.config["unit-scale"]))),setLabelImpl(e,e.config.label)}else shmi.log("[IQ:iq-input-field] no input and/or element in HTML",3)},onEnable:function(){this.config.item&&(this.vars.subscriptionTargetId=this.imports.im.subscribeItem(this.config.item,this)),this.vars.inputEl.disabled=!1,this.enableAllListeners(),document.activeElement===this.vars.inputEl&&(this.vars.focused=!0),shmi.log("[IQ:iq-input-field] Enabled",1)},onDisable:function(){this.config.item&&this.imports.im.unsubscribeItem(this.config.item,this.vars.subscriptionTargetId),this.disableAllListeners(),shmi.log("[IQ:iq-input-field] disabled",1)},onLock:function(){this.vars.locked=!0,this.vars.inputEl.disabled=!0,shmi.addClass(this.element,"locked"),this.vars.inputEl.blur(),this.disableAllListeners(),shmi.log("[IQ:iq-input-field] Locked",1)},onUnlock:function(){this.vars.locked=!1,this.vars.inputEl.disabled=!1,shmi.removeClass(this.element,"locked"),this.enableAllListeners(),shmi.log("[IQ:iq-input-field] unlocked",1)},onSetValue:function(e,t,i){var s=this.vars.value;this.vars.value=e,this.insertValue(this.imports.nv.formatOutput(this.vars.value,this)),document.activeElement===this.vars.inputEl&&this.selectContent(),shmi.log("[IQ:iq-input-field] new value: "+this.vars.value,0),this.vars.value!==s&&this.fire("change",{value:this.vars.value})},getValue:function(){var e=this.vars.type;return this.config.item&&this.config["auto-type"]&&(e=this.imports.im.items[this.config.item].type),e===shmi.c("TYPE_INT")?Math.round(this.vars.value/this.config["unit-scale"]):e===shmi.c("TYPE_FLOAT")?this.vars.value/this.config["unit-scale"]:this.vars.value},onSetProperties:function(e,t,i,s,n,a,l,o,r,c){var u=this,h=shmi.Constants;u.config["auto-type"]&&(u.vars.type=n,[h.TYPE_BOOL,h.TYPE_INT,h.TYPE_FLOAT].indexOf(n)&&shmi.addClass(u.element,u.config["numeric-class"])),u.imports.nv.setProperties(u,arguments)},setUnitText:function(e){this.vars.unitEl&&this.config["auto-unit-text"]&&setUnitTextImpl(this,e)},setLabel:function(e){this.vars.labelEl&&this.config["auto-label"]&&setLabelImpl(this,e)},updateValue:function(){this.config.item&&shmi.visuals.session.ItemManager.writeValue(this.config.item,this.vars.value)},insertValue:function(e){this.vars.inputEl.value=e},retrieveValue:function(){return this.vars.inputEl.value},selectContent:function(){this.vars.inputEl.select()},handleFocus:function(){var e=this;e.vars.locked||(e.vars.focused||null===shmi.visuals.session.FocusElement||(shmi.visuals.session.FocusElement.blur(),shmi.visuals.session.FocusElement=null),shmi.log("[IQ:iq-input-field] focused",1),e.showNumpad()||e.showKeyboard()||(e.vars.wasClicked||e.selectContent(),e.vars.focused=!0,e.vars.inputEl.focus(),shmi.visuals.session.FocusElement=e.vars.inputEl,e.vars.toEnterTmr&&clearTimeout(e.vars.toEnterTmr),e.vars.toEnterTmr=setTimeout((function(){e.fire("enter",{value:e.vars.value})}),250)))},showNumpad:function(){const e=this,t=shmi.requires("visuals.tools.numericValues");return!!e.config["numpad-enabled"]&&(e.vars&&e.vars.valueSettings||t.initValueSettings(e),shmi.numpad({"decimal-delimiter":e.config["decimal-delimiter"],unit:e.vars.unitEl?e.vars.unitEl.textContent:e.config["unit-text"],label:e.vars.labelEl?e.vars.labelEl.textContent:e.config.label,value:e.retrieveValue(),callback:function(t){e.config.item?(e.config.multiline&&(t=t.toString()),e.imports.im.writeValue(e.config.item,t)):e.setValue(t)},min:e.vars.valueSettings.min,max:e.vars.valueSettings.max,type:e.vars.valueSettings.type,precision:e.vars.valueSettings.precision,item:"string"==typeof e.config.item&&e.config.item.length>0?e.config.item:null}),!0)},showKeyboard:function(){var e=this,t=shmi.requires("visuals.session.config");return!(!t.keyboard||!t.keyboard.enabled)&&(shmi.keyboard({value:e.retrieveValue(),"select-box-enabled":t.keyboard["language-selection"],"password-input":e.vars.currentValueEl&&e.vars.currentValueEl.type&&"password"===e.vars.currentValueEl.type.toLowerCase(),callback:function(t,i){t&&(e.config.item?e.imports.im.writeValue(e.config.item,i):e.setValue(i))}}),!0)},validateAndSet:function(){const e=this,t=e.retrieveValue(),i=e.vars.value;if(t===i)return;const s=(()=>e.config.multiline?t:[shmi.c("TYPE_INT"),shmi.c("TYPE_FLOAT")].includes(e.vars.type)?e.vars.floatRegexp.test(t.replace(e.config["decimal-delimiter"],"."))?e.imports.nv.applyInputSettings(t,e):i:t)();e.vars.value=s,null==s?e.insertValue(""):e.insertValue(e.imports.nv.formatOutput(s,e)),s!==i&&(e.config.item&&e.imports.im.writeValue(e.config.item,s),e.vars.uiAction&&e.vars.uiAction.execute(s),e.fire("change",{value:e.vars.value}))},enableAllListeners:function(){this.vars.domListeners.forEach((function(e){e.element.addEventListener(e.event,e.callback)})),this.vars.listeners.forEach((function(e){e.enable()}))},disableAllListeners:function(){this.vars.domListeners.forEach((function(e){e.element.removeEventListener(e.event,e.callback)})),this.vars.listeners.forEach((function(e){e.disable()}))},createEventListener:function(e,t,i){return{event:t,callback:i,element:e}}}};shmi.requires("visuals.tools.control-generator").generate(s)}(),function(){"use strict";var e={"class-name":"iq-label",name:null,template:"default/iq-label.variant-01",item:null,precision:-1,"decimal-delimiter":".",type:shmi.c("TYPE_INT"),"auto-precision":!0,"auto-type":!0,tooltip:null,options:[],pattern:null,"value-as-tooltip":!1,text:"${label.no-value}"},t=shmi.requires("visuals.tools.logging").createLogger("iq-label",!0,!1),i=(t.fLog,t.log,{className:"iq-label",uiType:"iq-label",isContainer:!1,config:e,configSchema:null,vars:{value:0,active:!1,labelEl:null,rafId:null,subscriptionTargetId:null},imports:{im:"visuals.session.ItemManager",nv:"visuals.tools.numericValues"},events:[],prototypeExtensions:{onInit:function(){this.imports.nv.initValueSettings(this),this.vars.labelEl=shmi.getUiElement("label",this.element),this.config.text&&this.updateText(shmi.localize(this.config.text))},onEnable:function(){this.config.item&&(this.vars.subscriptionTargetId=this.imports.im.subscribeItem(this.config.item,this)),shmi.log("[IQ:iq-label] Enabled",1)},onDisable:function(){this.vars.subscriptionTargetId&&this.imports.im.unsubscribeItem(this.config.item,this.vars.subscriptionTargetId),shmi.log("[IQ:iq-label] disabled",1)},getValue:function(){return this.vars.value},onSetProperties:function(e,t,i,s,n,a,l,o,r,c){var u=this;u.imports.nv.setProperties(u,arguments)},onSetValue:function(e,t,i){var s=this;shmi.caf(s.vars.rafId),s.vars.rafId=shmi.raf((function(){var t=e;if(s.config.options.length){const i=s.config.options.find(t=>Number.isSafeInteger(t.mask)&&Number.isSafeInteger(t.value)?(e&t.mask)===t.value:t.value===e);i&&(t=shmi.localize(i.label))}else t="string"==typeof s.config.pattern&&s.config.pattern.trim().length?shmi.localize(shmi.evalString(s.config.pattern,{VALUE:e})):s.imports.nv.formatOutput(e,s);s.updateText(t)}))},updateText:function(e){this.vars.labelEl.textContent=e,this.config["value-as-tooltip"]&&this.setTooltip(e)},onLock:function(){shmi.addClass(this.element,"locked")},onUnlock:function(){shmi.removeClass(this.element,"locked")}}});shmi.requires("visuals.tools.control-generator").generate(i)}(),function(){"use strict";const e="iq-linear-gauge",t={"class-name":e,name:null,template:"default/iq-linear-gauge.variant-01",item:null,tooltip:null,type:shmi.c("TYPE_INT"),precision:0,min:Number.NEGATIVE_INFINITY,max:Number.POSITIVE_INFINITY,label:"[Label]","unit-text":"[Unit]","decimal-delimiter":".","default-value":"---","show-text":!0,"show-icon":!1,"icon-src":null,"icon-class":null,"auto-min":!0,"auto-max":!0,"auto-label":!0,"auto-unit-text":!0,"auto-precision":!0,"animation-duration":100,"fill-reverse":!1,"fill-inverse":!1},i=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1);i.fLog,i.log;function setLabelImpl(e,t){e.vars.dom.label&&(""!==t&&null!=t&&e.config["show-text"]?(e.vars.label=t,e.vars.dom.label.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-label")):(e.vars.label="",e.vars.dom.label.textContent="",shmi.addClass(e.element,"no-label")))}function setUnitTextImpl(e,t){e.vars.dom.unit&&(""!==t&&null!=t&&e.config["show-text"]?(e.vars.unit=t,e.vars.dom.unit.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-unit")):(e.vars.unit="",e.vars.dom.unit.textContent="",shmi.addClass(e.element,"no-unit")))}function updateWidgetBar(e,{actValue:t}){e.vars.dom.bar&&e.vars.dom.bar.style.setProperty("--internal-fill-level",`${100*function getFillPercentage(e,t){const{min:i,max:s}=e.vars.valueSettings,n=(t-i)/(s-i);return isNaN(n)||i===s?0:e.config["fill-inverse"]?1-Math.min(Math.max(n,0),1):Math.min(Math.max(n,0),1)}(e,t)}%`)}function updateWidgetText(e){e.vars.dom.value&&(null===e.getValue()?e.vars.dom.value.textContent=shmi.localize(e.config["default-value"]):e.vars.dom.value.textContent=e.imports.nv.formatOutput(e.getValue(),e))}function queueWidgetTextUpdate(e){e.vars.rafId||(e.vars.rafId=shmi.raf(()=>{updateWidgetText(e),e.vars.rafId=null}))}const s={className:"IqLinearGauge",uiType:e,isContainer:!1,config:t,configSchema:null,vars:{dom:{value:null,bar:null,unit:null,label:null,icon:null},valueSettings:{min:0,max:100},animationBundle:null,rafId:null,value:null,orientationInfo:null,tokens:[]},imports:{im:"visuals.session.ItemManager",nv:"visuals.tools.numericValues",gfx:"visuals.gfx"},events:[],prototypeExtensions:{onInit:function(){const e=this;if(Object.assign(e.vars.dom,{value:shmi.getUiElement("value",e.element),bar:shmi.getUiElement("bar",e.element),unit:shmi.getUiElement("unit",e.element),label:shmi.getUiElement("label",e.element),icon:shmi.getUiElement("icon",e.element)}),e.imports.nv.initValueSettings(e),e.vars.dom.icon&&e.config["icon-src"]&&e.config["show-icon"])e.vars.dom.icon.style.backgroundImage=`url(${e.config["icon-src"]})`;else if(e.vars.dom.icon&&e.config["icon-class"]&&e.config["show-icon"]){e.config["icon-class"].trim().split(" ").forEach(t=>shmi.addClass(e.vars.dom.icon,t))}else shmi.addClass(e.element,"no-icon");setUnitTextImpl(e,e.config["unit-text"]),e.config["unit-scale"]&&(e.config["unit-scale"]=parseFloat(shmi.localize(e.config["unit-scale"]))),setLabelImpl(e,e.config.label),e.vars.dom.bar&&(e.vars.orientationInfo=function getFillProperties(e){if(!e.vars.dom.bar)return null;const t=getComputedStyle(e.vars.dom.bar),[i,s]=t.transformOrigin.replace("px","").split(" ").map(parseFloat),n=s<=parseFloat(t.height.replace("px",""))/2,a=0===i,l=0===s;return{orientation:n?"horizontal":"vertical",reverse:n?!l:!a,anchor:(()=>n?a?"left":"right":l?"top":"bottom")()}}(e),e.config["fill-reverse"]&&(e.vars.orientationInfo.reverse=!e.vars.orientationInfo.reverse,e.vars.orientationInfo.anchor=function invertAnchor(e){return{left:"right",right:"left",top:"bottom",bottom:"top"}[e]}(e.vars.orientationInfo.anchor),e.vars.dom.bar.style.transformOrigin=e.vars.orientationInfo.anchor)),e.vars.animationBundle=new e.imports.gfx.AnimationBundle(updateWidgetBar.bind(null,e)),e.vars.animationBundle.prepare("actValue",null,"linear"),updateWidgetText(e)},onEnable:function(){const e=this;e.config.item&&e.vars.tokens.push(e.imports.im.subscribeItem(e.config.item,e))},onDisable:function(){const e=this;e.vars.rafId&&(shmi.caf(e.vars.rafId),e.vars.rafId=null),e.vars.tokens.forEach(e=>e.unlisten()),e.vars.tokens=[],e.vars.animationBundle.cancel("actValue")},onLock:function(){shmi.addClass(this.element,"locked")},onUnlock:function(){shmi.removeClass(this.element,"locked")},getValue:function(){return this.vars.value},onSetValue:function(e,t,i){const s=[shmi.c("TYPE_BOOL"),shmi.c("TYPE_INT"),shmi.c("TYPE_FLOAT")].includes(t)?e:Number.NaN;this.vars.value!==s&&(this.vars.value=s,this.vars.animationBundle.start(s,this.config["animation-duration"],"actValue"),queueWidgetTextUpdate(this))},onSetProperties:function(...e){this.imports.nv.setProperties(this,e),this.vars.animationBundle.refresh(),queueWidgetTextUpdate(this)},setUnitText:function(e){const t=this;t.config["auto-unit-text"]&&setUnitTextImpl(t,e)},setLabel:function(e){const t=this;t.config["auto-label"]&&setLabelImpl(t,e)}}};shmi.requires("visuals.tools.control-generator").generate(s)}(),function(){"use strict";const e="iq-progress-info",t={"class-name":e,name:null,template:"default/iq-progress-info.variant-01",displayFormat:"($baseItem / $comparisonItem) - $percentValue%",baseItem:null,comparisonItem:null,tooltip:null,precision:-1,"decimal-delimiter":".","default-value":"---","auto-precision":!0,"animation-duration":100,"fill-reverse":!1,"fill-inverse":!1},i=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1);i.fLog,i.log;function updateWidgetText(e){e.vars.dom.value&&(null===e.getValue()||null===e.getComparisonValue()?(e.vars.dom.value.textContent=shmi.localize(e.config["default-value"]),e.vars.placeholders=null):(e.vars.placeholders||function setupValueElements(e,t){const{value:i}=e.vars.dom;i&&(i.innerHTML=t.replace(/[$]baseItem/g,'<span class="baseValue"></span>').replace(/[$]comparisonItem/g,'<span class="compareValue"></span>').replace(/[$]percentValue/g,'<span class="percentValue"></span>'),e.vars.placeholders={baseItem:Array.from(i.getElementsByClassName("baseValue")),comparisonItem:Array.from(i.getElementsByClassName("compareValue")),percentValue:Array.from(i.getElementsByClassName("percentValue"))})}(e,e.config.displayFormat),function setPlaceholderValues(e,t,i){const{nv:{formatOutput:s},iter:{iterateObject:n}}=e.imports,a={baseItem:s(t,e),comparisonItem:s(i,e),percentValue:Math.round(t/i*100)};e.vars.placeholders&&n(a,(t,i)=>{const s=e.vars.placeholders[i];Array.isArray(s)&&s.forEach(e=>e.textContent=t)})}(e,e.getValue(),e.getComparisonValue())))}function updateWidgetBar(e,{baseValue:t,compValue:i}){const s=function getFillPercentage(e,t,i){const s=e/t;return isNaN(s)?0:i?1-Math.min(Math.max(s,0),1):Math.min(Math.max(s,0),1)}(t,i,e.config["fill-inverse"]);e.vars.dom.bar&&e.vars.dom.bar.style.setProperty("--internal-fill-level",`${100*s}%`)}function queueWidgetTextUpdate(e){!e.vars.rafId&&e.vars.dom.value&&(e.vars.rafId=shmi.raf(()=>{updateWidgetText(e),e.vars.rafId=null}))}const s={className:"IqProgressInfo",uiType:e,isContainer:!1,config:t,configSchema:null,vars:{dom:{value:null,bar:null,barContainer:null},placeholders:null,valueSettings:{min:0,max:100},animationBundle:null,rafId:null,value:null,valueComp:null,orientationInfo:null,listeners:[],tokens:[]},imports:{im:"visuals.session.ItemManager",iter:"visuals.tools.iterate",nv:"visuals.tools.numericValues",gfx:"visuals.gfx"},events:[],prototypeExtensions:{onInit:function(){const e=this;Object.assign(e.vars.dom,{value:shmi.getUiElement("value",e.element),bar:shmi.getUiElement("bar",e.element),barContainer:shmi.getUiElement("bar-container",e.element)}),e.imports.nv.initValueSettings(e),e.vars.dom.bar&&(e.vars.orientationInfo=function getFillProperties(e){if(!e.vars.dom.bar)return null;const t=getComputedStyle(e.vars.dom.bar),[i,s]=t.transformOrigin.replace("px","").split(" ").map(parseFloat),n=s<=parseFloat(t.height.replace("px",""))/2,a=0===i,l=0===s;return{orientation:n?"horizontal":"vertical",reverse:n?!l:!a,anchor:(()=>n?a?"left":"right":l?"top":"bottom")()}}(e),e.config["fill-reverse"]&&(e.vars.orientationInfo.reverse=!e.vars.orientationInfo.reverse,e.vars.orientationInfo.anchor=function invertAnchor(e){return{left:"right",right:"left",top:"bottom",bottom:"top"}[e]}(e.vars.orientationInfo.anchor),e.vars.dom.bar.style.transformOrigin=e.vars.orientationInfo.anchor),e.vars.animationBundle=new e.imports.gfx.AnimationBundle(updateWidgetBar.bind(null,e)),e.vars.animationBundle.prepare("baseValue",null,"linear"),e.vars.animationBundle.prepare("compValue",null,"linear")),updateWidgetText(e)},onEnable:function(){const e=this;e.config.baseItem&&e.vars.tokens.push(e.imports.im.subscribeItem(e.config.baseItem,e)),e.config.comparisonItem&&e.vars.tokens.push(e.imports.im.subscribeItem(e.config.comparisonItem,{setValue:e.onSetCompValue.bind(e)}))},onDisable:function(){const e=this;e.vars.rafId&&(shmi.caf(e.vars.rafId),e.vars.rafId=null),e.vars.animationBundle&&(e.vars.animationBundle.cancel("baseValue"),e.vars.animationBundle.cancel("compValue")),e.vars.tokens.forEach(e=>e.unlisten()),e.vars.tokens=[]},onLock:function(){shmi.addClass(this.element,"locked")},onUnlock:function(){shmi.removeClass(this.element,"locked")},getValue:function(){return this.vars.value},getComparisonValue:function(){return this.vars.valueComp},onSetValue:function(e,t,i){const s=this,n=[shmi.c("TYPE_BOOL"),shmi.c("TYPE_INT"),shmi.c("TYPE_FLOAT")].includes(t)?e:Number.NaN;s.vars.value!==n&&(s.vars.value=n,s.vars.animationBundle&&s.vars.animationBundle.start(n,s.config["animation-duration"],"baseValue"),queueWidgetTextUpdate(s))},onSetCompValue:function(e,t){const i=this,s=[shmi.c("TYPE_BOOL"),shmi.c("TYPE_INT"),shmi.c("TYPE_FLOAT")].includes(t)?e:Number.NaN;i.vars.valueComp!==s&&(i.vars.valueComp=s,i.vars.animationBundle&&i.vars.animationBundle.start(s,i.config["animation-duration"],"compValue"),queueWidgetTextUpdate(i))},onSetProperties:function(...e){this.imports.nv.setProperties(this,e),queueWidgetTextUpdate(this)}}};shmi.requires("visuals.tools.control-generator").generate(s)}(),function(){"use strict";const e="iq-quality-display",t={"class-name":e,name:null,template:"default/iq-quality-display.variant-01",item:null,"item-ctrl":null,tooltip:null,type:shmi.c("TYPE_INT"),precision:0,min:0,max:100,label:"[Label]","unit-text":"[Unit]","decimal-delimiter":".","default-value":"---","show-icon":!1,"show-text":!0,"icon-src":null,"icon-class":null,"auto-type":!0,"auto-min":!0,"auto-max":!0,"auto-label":!0,"auto-unit-text":!0,"auto-precision":!0,"animation-duration":100},i=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1);i.fLog,i.log;function setLabelImpl(e,t){e.vars.dom.label&&(""!==t&&null!=t&&e.config["show-text"]?(e.vars.label=t,e.vars.dom.label.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-label")):(e.vars.label="",e.vars.dom.label.textContent="",shmi.addClass(e.element,"no-label")))}function setUnitTextImpl(e,t){e.vars.dom.unit&&(""!==t&&null!=t&&e.config["show-text"]?(e.vars.unit=t,e.vars.dom.unit.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-unit")):(e.vars.unit="",e.vars.dom.unit.textContent="",shmi.addClass(e.element,"no-unit")))}function getFillPercentage(e,t){const{min:i,max:s}=e.vars.valueSettings,n=(t-i)/(s-i);return isNaN(n)||s===i?0:Math.min(Math.max(n,0),1)}function updateWidgetText(e){e.vars.dom.value&&(null===e.getValue()?e.vars.dom.value.textContent=shmi.localize(e.config["default-value"]):e.vars.dom.value.textContent=e.imports.nv.formatOutput(e.getValue(),e)),e.vars.dom.controlValue&&(null===e.getControlValue()?e.vars.dom.controlValue.textContent=shmi.localize(e.config["default-value"]):e.vars.dom.controlValue.textContent=e.imports.nv.formatOutput(e.getControlValue(),e))}function updateWidgetBars(e,{actValue:t,ctrlValue:i}){const s=getFillPercentage(e,t),n=getFillPercentage(e,i),{barContainer:a,indicator:l,controlValue:o}=e.vars.dom;if(a&&(a.style.setProperty("--internal-fill-level-set",`${100*n}%`),a.style.setProperty("--internal-fill-level",`${100*s}%`)),l&&(l.style.setProperty("--internal-fill-level-set",`${100*n}%`),l.style.setProperty("--internal-fill-level",`${100*s}%`)),a&&o){const e=a.getBoundingClientRect();o.style.setProperty("--internal-fill-level-set",`${100*n}%`),o.style.setProperty("--internal-fill-level",`${100*s}%`),o.style.setProperty("--internal-bar-offset-h",`${e.width*n}px`),o.style.setProperty("--internal-bar-offset-v",`${e.height*(1-n)}px`)}}function queueWidgetTextUpdate(e){e.vars.rafId||(e.vars.rafId=shmi.raf(()=>{updateWidgetText(e),e.vars.rafId=null}))}const s={className:"IqQualityDisplay",uiType:e,isContainer:!1,config:t,configSchema:null,vars:{dom:{value:null,bar:null,barContainer:null,unit:null,label:null,icon:null,indicator:null,indicatorLine:null,controlValue:null},valueSettings:{min:0,max:100},animationBundle:null,rafId:null,value:null,valueCtrl:null,orientationInfo:null,listeners:[],tokens:[]},imports:{im:"visuals.session.ItemManager",nv:"visuals.tools.numericValues",gfx:"visuals.gfx"},events:[],prototypeExtensions:{onInit:function(){const e=this;if(Object.assign(e.vars.dom,{value:shmi.getUiElement("value",e.element),bar:shmi.getUiElement("bar",e.element),barContainer:shmi.getUiElement("bar-container",e.element),unit:shmi.getUiElement("unit",e.element),label:shmi.getUiElement("label",e.element),icon:shmi.getUiElement("icon",e.element),indicator:shmi.getUiElement("indicator",e.element),indicatorLine:shmi.getUiElement("indicator-line",e.element),controlValue:shmi.getUiElement("control-value",e.element)}),e.imports.nv.initValueSettings(e),e.vars.dom.icon&&e.config["icon-src"]&&e.config["show-icon"])e.vars.dom.icon.style.backgroundImage=`url(${e.config["icon-src"]})`;else if(e.vars.dom.icon&&e.config["icon-class"]&&e.config["show-icon"]){e.config["icon-class"].trim().split(" ").forEach(t=>shmi.addClass(e.vars.dom.icon,t))}else shmi.addClass(e.element,"no-icon");setUnitTextImpl(e,e.config["unit-text"]),e.config["unit-scale"]&&(e.config["unit-scale"]=parseFloat(shmi.localize(e.config["unit-scale"]))),setLabelImpl(e,e.config.label),e.vars.dom.bar&&(e.vars.orientationInfo=function getFillProperties(e){if(!e.vars.dom.bar)return null;const t=getComputedStyle(e.vars.dom.bar),[i,s]=t.transformOrigin.replace("px","").split(" ").map(parseFloat),n=s<=parseFloat(t.height.replace("px",""))/2,a=0===i,l=0===s;return{orientation:n?"horizontal":"vertical",reverse:n?!l:!a,anchor:(()=>n?a?"left":"right":l?"top":"bottom")()}}(e)),e.vars.animationBundle=new e.imports.gfx.AnimationBundle(updateWidgetBars.bind(null,e)),e.vars.animationBundle.prepare("actValue",null,"linear"),e.vars.animationBundle.prepare("ctrlValue",null,"linear"),updateWidgetText(e)},onEnable:function(){const e=this;e.vars.tokens.push(function makeUpdateToken(e,t){let i=!1;const throttledCallback=()=>{i=!1,Promise.resolve().then(()=>{i||(t(),i=!0)})},s=window.ResizeObserver?new ResizeObserver(throttledCallback):null;return window.addEventListener("resize",throttledCallback),s&&e.vars.dom.barContainer&&s.observe(e.vars.dom.barContainer),{unlisten:()=>{window.removeEventListener("resize",throttledCallback),s&&e.vars.dom.barContainer&&s.unobserve(e.vars.dom.barContainer)}}}(e,()=>{queueWidgetTextUpdate(e),e.vars.animationBundle.refresh()})),e.config.item&&e.vars.tokens.push(e.imports.im.subscribeItem(e.config.item,e)),e.config["item-ctrl"]&&e.vars.tokens.push(e.imports.im.subscribeItem(e.config["item-ctrl"],{setValue:e.onSetCtrlValue.bind(e)}))},onDisable:function(){const e=this;e.vars.rafId&&(shmi.caf(e.vars.rafId),e.vars.rafId=null),e.vars.animationBundle.cancel("actValue"),e.vars.animationBundle.cancel("ctrlValue"),e.vars.tokens.forEach(e=>e.unlisten()),e.vars.tokens=[]},onLock:function(){shmi.addClass(this.element,"locked")},onUnlock:function(){shmi.removeClass(this.element,"locked")},getValue:function(){return this.vars.value},getControlValue:function(){return this.vars.valueCtrl},onSetValue:function(e,t,i){const s=[shmi.c("TYPE_BOOL"),shmi.c("TYPE_INT"),shmi.c("TYPE_FLOAT")].includes(t)?e:Number.NaN;this.vars.value!==s&&(this.vars.value=s,this.vars.animationBundle.start(s,this.config["animation-duration"],"actValue"),queueWidgetTextUpdate(this))},onSetCtrlValue:function(e,t){const i=[shmi.c("TYPE_BOOL"),shmi.c("TYPE_INT"),shmi.c("TYPE_FLOAT")].includes(t)?e:Number.NaN;this.vars.valueCtrl!==i&&(this.vars.valueCtrl=i,this.vars.animationBundle.start(i,this.config["animation-duration"],"ctrlValue"),queueWidgetTextUpdate(this))},onSetProperties:function(...e){this.imports.nv.setProperties(this,e),this.vars.animationBundle.refresh(),queueWidgetTextUpdate(this)},setUnitText:function(e){const t=this;t.config["auto-unit-text"]&&setUnitTextImpl(t,e)},setLabel:function(e){const t=this;t.config["auto-label"]&&setLabelImpl(t,e)}}};shmi.requires("visuals.tools.control-generator").generate(s)}(),function(){"use strict";var e="iq-radial-gauge",t={"class-name":e,name:null,template:"default/iq-radial-gauge.variant-01",label:"[Label]",item:null,min:Number.NEGATIVE_INFINITY,max:Number.POSITIVE_INFINITY,step:1,precision:0,type:shmi.c("TYPE_INT"),"unit-text":"[Unit]","auto-label":!0,"auto-min":!0,"auto-max":!0,"auto-step":!0,"auto-precision":!0,"auto-type":!0,"show-icon":!1,"icon-src":null,"icon-class":null,tooltip:null,"animation-duration":100,"arc-fill-reverse":!1,"arc-fill-inverse":!1,"default-value":"---"};const i=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),s=(i.fLog,i.log,[{propName:"background",attribName:"color",conversion:"parseBackground"},{propName:"width",attribName:"lineWidth",conversion:"parseInt"},{propName:"box-shadow",attribName:["shadowColor","shadowOffsetX","shadowOffsetY","shadowBlur",null],conversion:"boxShadow"}]),n=[{propName:"color",attribName:"color",conversion:null},{propName:"font-size",attribName:"fontSize",conversion:"parseInt"},{propName:"font-family",attribName:"fontFamily",conversion:null},{propName:"font-weight",attribName:"fontWeight",conversion:null},{propName:"font-style",attribName:"fontStyle",conversion:null},{propName:"text-decoration",attribName:"textUnderline",conversion:"parseUnderline"}],a=[{propName:"top",attribName:"offsetVertical",conversion:"parsePercent"},{propName:"left",attribName:"offsetHorizontal",conversion:"parsePercent"},{propName:"offset-rotate",attribName:"rotation",conversion:"offsetRotate"}],l=[{"data-ui":"arc-bg",objName:"arcBackground",styleConfig:s},{"data-ui":"arc-fg",objName:"arcForeground",styleConfig:s.concat(a)},{"data-ui":"arc-slice",objName:"slice",styleConfig:[{propName:"width",attribName:"width",conversion:"parsePercent"}]},{"data-ui":"line-value",objName:"valueLine",styleConfig:s},{"data-ui":"value",objName:"value",styleConfig:n.concat(a)},{"data-ui":"label",objName:"label",styleConfig:n.concat(a)},{"data-ui":"unit",objName:"unit",styleConfig:n.concat(a)},{"data-ui":"icon-src",objName:"icon",styleConfig:[{propName:"width",attribName:"width",conversion:"parsePercent"},{propName:"height",attribName:"height",conversion:"parsePercent"}].concat(a)},{"data-ui":"icon-class",objName:"iconClass",styleConfig:n}],o={identity:e=>[e],parseInt:e=>{const t=parseInt(e);return isNaN(t)?null:[t]},parsePercent:e=>{if("0px"===e)return[0];if(!e.endsWith("%"))return null;const t=parseFloat(e.substr(0,e.length-1));return isNaN(t)?null:[t/100]},boxShadow:e=>{if("none"===e)return[0,0,0,0,"transparent"];const t=e.match(/^(rgba?\([-\d.,\s]+\))\s+(-?[0-9]+(?:\.[0-9]+)?)px\s+(-?[0-9]+(?:\.[0-9]+)?)px\s+(-?[0-9]+(?:\.[0-9]+)?)px\s+(-?[0-9]+(?:\.[0-9]+)?)px$/);return t?[t[1],t[2],t[3],t[4],t[5]]:null},offsetRotate:e=>{const t=e.match(/^(?:auto\s+)?(-?[0-9]+(?:\.[0-9]+)?)deg$/);return t?[Math.PI*parseFloat(t[1])/180]:null},parseBackground:e=>{const t=/^(rgba?\([-\d.,\s]+\))/,i=e.match(/(linear-gradient|radial-gradient)\((?:([^,]+), )?((?:rgba?\([-\d.,\s]+\)(?: [-\d.]+%)?(?:, )?)+)\)/);if(!i){const i=e.match(t);return i?[{type:"color",color:i[1]}]:[null]}const[,s,n,a]=i,l=Array.from(a.matchAll(/(rgba?\([-\d.,\s]+\))(?: ([-\d.]+)%)?(?:, )?/g));switch(s){case"linear-gradient":return[{type:s,rotation:void 0===n?Math.PI:parseFloat(n.substr(0,n.length-3))/180*Math.PI||0,steps:l.map(([,e,t])=>({color:e,step:parseInt(t)/100}))}];case"radial-gradient":return[{type:s,steps:l.map(([,e,t])=>({color:e,step:parseInt(t)/100}))}];default:return[null]}},parseUnderline:e=>[e.includes("underline")]};function calculateTextMeasurement(e,{fontSize:t,fontFamily:i,fontWeight:s,fontStyle:n},a){const l=e.vars.canvasObj;return l.font=`${n} ${s} ${t*(window.devicePixelRatio||1)}px ${i}`,l.measureText(a)}function computeNormalizedGaugeBoundingBox(e,t){const i=(2*Math.PI-t)/2,s=e+i,n=e+i+t,a=[{x:Math.cos(s),y:Math.sin(s),theta:s},{x:Math.cos(n),y:Math.sin(n),theta:n}];for(let e=Math.ceil(2*s/Math.PI);e<=Math.floor(2*n/Math.PI);++e){const t=e*Math.PI/2;a.push({x:Math.cos(t),y:Math.sin(t),theta:t})}return a.reduce((e,t)=>({top:Math.min(e.top,t.y),left:Math.min(e.left,t.x),bottom:Math.max(e.bottom,t.y),right:Math.max(e.right,t.x),centerX:e.centerX,centerY:e.centerY,width:e.width,height:e.height}),{top:1,left:1,bottom:-1,right:-1,centerX:0,centerY:0,width:2,height:2})}function translateGaugeBoundingBox(e,t,i){const s=(()=>{const s=(e.bottom-e.top)/e.height,n=(e.right-e.left)/e.width,a=n/s,l=s/n;return e.right-e.left>e.bottom-e.top?Math.min(a*i,t):Math.min(l*t,i)})(),computeSize=(t,i,s)=>(t-i)/Math.max(e.right-e.left,e.bottom-e.top)*s,n=computeSize(e.right,e.left,s),a=computeSize(e.bottom,e.top,s);return{top:(i-a)/2,left:(t-n)/2,bottom:(i+a)/2,right:(t+n)/2,centerY:computeSize(e.centerY,e.top,s)+(i-a)/2,centerX:computeSize(e.centerX,e.left,s)+(t-n)/2,height:a,width:n,radius:computeSize(1,0,s)}}function invalidateTextMeasurements(e){e.vars.cache||(e.vars.cache={}),e.vars.cache.textMeasurement=null}function invalidateFillStyles(e){e.vars.cache||(e.vars.cache={}),e.vars.cache.fillStyles=null}function haveStylesChanged(e){return!e.vars.cache||!e.vars.cache.hasStyles}function checkCache(e){e.vars.cache||(e.vars.cache={}),e.vars.cache.textMeasurement||(e.vars.cache.textMeasurement=function calculateTextMeasurements(e){return{value:calculateTextMeasurement(e,e.vars.styles.value,e.vars.valueFormatted),valueLineHeight:calculateTextMeasurement(e,e.vars.styles.value,`-0${e.config["decimal-delimiter"]}123456789`),unit:calculateTextMeasurement(e,e.vars.styles.unit,e.vars.unitLocalized),label:calculateTextMeasurement(e,e.vars.styles.label,e.vars.labelLocalized)}}(e))}function getIconData(e,t,i){return e.vars.cache||(e.vars.cache={}),e.vars.cache.iconData&&e.vars.cache.iconData.drawWidth===t&&e.vars.cache.iconData.drawHeight===i||(e.vars.cache.iconData=function calculateIconData(e,t,i){if(!e.vars.iconEl)return{type:"none",height:i};if("IMG"===e.vars.iconEl.nodeName){const s=e.vars.iconEl.width/e.vars.iconEl.height;return{type:"image",src:e.vars.iconEl.src,element:e.vars.iconEl,ready:e.vars.iconEl.complete,width:Math.min(s*i,t),height:Math.min(t/s,i),drawWidth:t,drawHeight:i}}if("DIV"!==e.vars.iconEl.nodeName)return{type:"invalid",drawWidth:t,drawHeight:i};const s=getComputedStyle(e.vars.iconEl,":before");return s?{type:"icon-font",str:s.content,fontFamily:s.fontFamily,measurement:calculateTextMeasurement(e,{fontSize:i,fontFamily:s.fontFamily,fontWeight:400,fontStyle:"normal"},s.content),drawWidth:t,drawHeight:i}:{type:"invalid",drawWidth:t,drawHeight:i}}(e,t,i)),e.vars.cache.iconData}function getTextPosition(e,t,i,s,n){return{x:Math.floor((e-s.width)*i.x+.5),y:Math.floor(t*i.y+(n||s.actualBoundingBoxAscent)*(1-i.y)+.5)}}function positionFromStyle(e){return{x:e.offsetHorizontal,y:e.offsetVertical}}function makeFillStyle(e,t,i,s,n,a){if("string"==typeof a)return a;switch(a.type){case"color":return a.color;case"linear-gradient":{const l=function rotateBox({x0:e,y0:t,x1:i,y1:s},n){n-=.75*Math.PI;const a=(e-i)/2,l=(t-s)/2,o=(i-e)/2,r=(s-t)/2;return{x0:a*Math.cos(n)-l*Math.sin(n)+(i+e)/2,y0:a*Math.sin(n)+l*Math.cos(n)+(s+t)/2,x1:o*Math.cos(n)-r*Math.sin(n)+(i+e)/2,y1:o*Math.sin(n)+r*Math.cos(n)+(s+t)/2}}({x0:t,y0:i,x1:t+s,y1:i+n},a.rotation),o=e.createLinearGradient(l.x0,l.y0,l.x1,l.y1);return a.steps.forEach(({color:e,step:t})=>o.addColorStop(t,e)),o}case"radial-gradient":{const l=e.createRadialGradient(t+s/2,i+n/2,0,t+s/2,i+n/2,Math.max(s,n)/2);return a.steps.forEach(({color:e,step:t})=>l.addColorStop(t,e)),l}default:return null}}function cacheFillStyle(e,t,i,s,n,a,l){e.vars.cache||(e.vars.cache={}),e.vars.cache.fillStyles||(e.vars.cache.fillStyles={}),e.vars.cache.fillStyles[t]||(e.vars.cache.fillStyles[t]=makeFillStyle(i,s,n,a,l,e.vars.styles[t].color))}function drawText(e,t,i,s,n,a,l,o,r,c,u,h,m,d){const f=getTextPosition(t,i,r,u,m),v=Math.max(1,Math.floor(s*o/15)),g=1.5*v;e.beginPath(),e.shadowBlur=0,e.fillStyle=h,e.font=`${l} ${a} ${s*o}px ${n}`,e.fillText(c,f.x,f.y),e.stroke(),d&&(e.beginPath(),e.strokeStyle=e.fillStyle,e.lineWidth=v,e.moveTo(f.x,f.y+g),e.lineTo(f.x+u.width,f.y+g),e.stroke())}function applyShadowStyles(e,t,i){e.shadowBlur=t.shadowBlur*i,e.shadowColor=t.shadowColor,e.shadowOffsetX=t.shadowOffsetX*i,e.shadowOffsetY=t.shadowOffsetY*i}function drawGauge(e,t,i,s,n,a,l,o,r){const c=(2*Math.PI-l)/2,u=e.vars.styles.arcBackground.lineWidth*o,h=e.vars.styles.arcBackground.shadowBlur*o,m=e.vars.styles.arcForeground.lineWidth*o,d=e.vars.styles.arcForeground.shadowBlur*o,f=e.vars.styles.valueLine.lineWidth*o,v=function getBoundingBox(e,t,i,s,n){return e.vars.cache||(e.vars.cache={}),e.vars.cache.boundingBox&&e.vars.cache.boundingBox.width===t&&e.vars.cache.boundingBox.height===i&&e.vars.cache.boundingBox.arcRotation===s&&e.vars.cache.boundingBox.arcAngle===n||(e.vars.cache.boundingBox={width:t,height:i,arcRotation:s,arcAngle:n,boundingBox:translateGaugeBoundingBox(computeNormalizedGaugeBoundingBox(s,n),t,i)}),e.vars.cache.boundingBox.boundingBox}(e,s,n,a,l),g=v.radius-Math.max(u,m)/2-h,p=v.radius-Math.max(u,m)/2-d,b=u-m,y=Math.max(0,Math.atan(b/p)),E=Math.max(0,Math.atan(-b/p)),C=function getGaugeOffset(e,t,i,s){return{x:(e-s.width)*(i.x-.5),y:(t-s.height)*(i.y-.5)}}(s,n,positionFromStyle(e.vars.styles.arcForeground),v);if(g<0||p<0)return;checkCache(e),cacheFillStyle(e,"arcBackground",t,v.left+C.x,v.top+C.y,v.right-v.left,v.bottom-v.top),cacheFillStyle(e,"arcForeground",t,v.left+C.x,v.top+C.y,v.right-v.left,v.bottom-v.top),t.clearRect(0,0,s,n),t.beginPath(),t.lineWidth=u,t.strokeStyle=e.vars.cache.fillStyles.arcBackground,applyShadowStyles(t,e.vars.styles.arcBackground,o),t.arc(v.centerX+C.x,v.centerY+C.y,g,a+c+E/2,l+a+c-E/2),t.stroke(),t.beginPath();const T=r?(l-y)*(1-i)+a+c+y/2:a+c+y/2,x=r?a-c+y/2:(l-y)*i+a+c+y/2;t.lineWidth=m,t.strokeStyle=e.vars.cache.fillStyles.arcForeground,applyShadowStyles(t,e.vars.styles.arcForeground,o),t.arc(v.centerX+C.x,v.centerY+C.y,p,T,x),t.stroke(),function drawIcon(e,t,i,s,n,a,l){if("image"===t.type)e.drawImage(t.element,(i-t.width)*n.x,(s-t.height)*n.y,t.width,t.height);else if("icon-font"===t.type){const o=getTextPosition(i,s,n,t.measurement);drawText(e,i,o.x,o.y,t.fontFamily,"normal","normal",a,n,t.str,t.measurement,l)}}(t,getIconData(e,s*e.vars.styles.icon.width,n*e.vars.styles.icon.height),s,n,positionFromStyle(e.vars.styles.icon),o,e.vars.styles.iconClass.color);const w=e.vars.styles.value,I=e.vars.cache.textMeasurement.value,k=e.vars.cache.textMeasurement.valueLineHeight.actualBoundingBoxAscent;t.beginPath();const S=getTextPosition(s,n,positionFromStyle(e.vars.styles.value),I,k),L={x0:S.x,y0:S.y+Math.floor(S.y+I.actualBoundingBoxAscent/4)+f/2,x1:S.x+I.width,y1:S.y+Math.floor(S.y+I.actualBoundingBoxAscent/4)+f/2};if(t.lineWidth=f,t.strokeStyle=makeFillStyle(t,L.x0,L.y0,L.x1-L.x0,L.y1-L.y0,e.vars.styles.valueLine.color),applyShadowStyles(t,e.vars.styles.valueLine,o),t.moveTo(L.x0,L.y0),t.lineTo(L.x1,L.y1),t.stroke(),drawText(t,s,n,w.fontSize,w.fontFamily,w.fontWeight,w.fontStyle,o,positionFromStyle(e.vars.styles.value),e.vars.valueFormatted,I,w.color,k,w.textUnderline),e.vars.unitLocalized){const i=e.vars.styles.unit,a=e.vars.cache.textMeasurement.unit;drawText(t,s,n,i.fontSize,i.fontFamily,i.fontWeight,i.fontStyle,o,positionFromStyle(e.vars.styles.unit),e.vars.unitLocalized,a,i.color,null,i.textUnderline)}if(e.vars.labelLocalized){const i=e.vars.styles.label,a=e.vars.cache.textMeasurement.label;drawText(t,s,n,i.fontSize,i.fontFamily,i.fontWeight,i.fontStyle,o,positionFromStyle(e.vars.styles.label),e.vars.labelLocalized,a,i.color,null,i.textUnderline)}}function updateCanvasResolution(e){const{clientWidth:t,clientHeight:i}=e.element,s=window.devicePixelRatio||1;e.vars.canvasEl.width!==e.vars.canvasEl.clientWidth*s&&(e.vars.canvasEl.width=e.vars.canvasEl.clientWidth*s),e.vars.canvasEl.height!==e.vars.canvasEl.clientHeight*s&&(e.vars.canvasEl.height=e.vars.canvasEl.clientHeight*s),e.vars.cache.display={devicePixelRatio:s,widgetWidth:t,widgetHeight:i}}function isReady(e){return!!e.vars.canvasObj}function startDrawing(e){return e.vars.animationFrameToken?null:shmi.raf(t=>{if(!isReady(e))return;const i=window.devicePixelRatio||1,{min:s,max:n}=e.vars.valueSettings,a=e.vars.canvasObj;if(null===e.vars.animationTimestamp||null===e.vars.animationValueStep||0===e.vars.animationValueStep)e.vars.animationValue=e.vars.value;else{const i=e.vars.animationValueStep*(t-e.vars.animationTimestamp);e.vars.hasChanged=!0,Math.abs(Math.abs(e.vars.animationValue)-Math.abs(e.vars.value))<Math.abs(i)?(e.vars.animationValue=e.vars.value,e.vars.animationValueStep=null):e.vars.animationValue=e.vars.animationValue+i}e.vars.animationTimestamp=t,!function haveDisplayPropertiesChanged(e){if(!e.vars.cache)return!0;if(!e.vars.cache.display)return!0;const t=e.vars.cache.display,i={devicePixelRatio:window.devicePixelRatio||1,widgetWidth:e.element.clientWidth,widgetHeight:e.element.clientHeight};return Object.keys(i).some(e=>i[e]!==t[e])}(e)?haveStylesChanged(e)?(invalidateFillStyles(e),e.setupStylesFromCss(),e.vars.hasChanged=!0):e.vars.forceRedraw&&(e.vars.hasChanged=!0,e.vars.forceRedraw=!1):(invalidateTextMeasurements(e),function invalidateGaugeBoundingBox(e){e.vars.cache||(e.vars.cache={}),e.vars.cache.boundingBox=null}(e),invalidateFillStyles(e),haveStylesChanged(e)&&e.setupStylesFromCss(),updateCanvasResolution(e),e.vars.hasChanged=!0);const l=Math.min(1,Math.max((e.vars.animationValue-s)/(n-s),0));if(e.vars.elementIsInViewport&&e.vars.hasChanged){const t=e.config["arc-fill-inverse"]?1-l:l,s=2*Math.PI*(1-e.vars.styles.slice.width);drawGauge(e,a,t,e.vars.canvasEl.width,e.vars.canvasEl.height,e.vars.styles.arcForeground.rotation,s,i,e.config["arc-fill-reverse"]),e.vars.hasChanged=!1}e.vars.animationFrameToken=null,e.vars.animationFrameToken=startDrawing(e)})}function makeDomEventListener(e,t,i){return{enable:e.addEventListener.bind(e,t,i),disable:e.removeEventListener.bind(e,t,i)}}var r={className:"IqRadialGauge",uiType:e,isContainer:!1,config:t,configSchema:null,vars:{listeners:[],value:null,valueFormatted:null,active:!1,hasChanged:!1,forceRedraw:!1,cache:{},valueSettings:null,canvasEl:null,styleHolderEl:null,iconEl:null,canvasObj:null,intersectionObserver:null,mutationObserver:null,elementIsInViewport:null,unit:null,unitLocalized:null,label:null,labelLocalized:null,animationFrameToken:null,animationValue:0,animationValueStep:null,animationTimestamp:null,styles:{arcBackground:{lineWidth:5,color:"#dddddd",shadowBlur:0},arcForeground:{lineWidth:5,offsetVertical:.5,offsetHorizontal:.5,rotation:Math.PI/2,shadowBlur:0,shadowColor:"rgba(180, 200, 59, 1)",color:"rgba(180, 200, 59, 1)"},slice:{width:276/360},valueLine:{lineWidth:1,shadowBlur:0,shadowColor:"rgba(60, 60, 60, 0.1)",color:"rgba(60, 60, 60, 0.1)"},value:{offsetVertical:.5,offsetHorizontal:.5,fontSize:36,fontFamily:"RobotoBold",color:"#7c7c7c"},label:{offsetVertical:.95,offsetHorizontal:.5,fontSize:14,fontFamily:"RobotoLight",color:"#7c7c7c"},unit:{offsetVertical:.32,offsetHorizontal:.5,fontSize:18,fontFamily:"RobotoLight",color:"#7c7c7c"},icon:{width:1/6,height:1/6,offsetVertical:.1,offsetHorizontal:.5},iconClass:{color:"black"}}},imports:{im:"visuals.session.ItemManager",nv:"visuals.tools.numericValues"},events:[],prototypeExtensions:{onInit:function(){const e=this;if(e.vars.canvasEl=shmi.getUiElement("gauge-canvas",e.element),!e.vars.canvasEl)return void e.log("Canvas element is missing!",3);if(e.vars.styleHolderEl=shmi.getUiElement("style-holder",e.element),!e.vars.styleHolderEl)return void e.log("Style Holder element is missing!",3);if(e.config["show-icon"]){if(e.config["icon-src"]){const t=document.createElement("img");t.src=e.config["icon-src"],e.vars.iconEl=t,e.vars.listeners.push(makeDomEventListener(t,"load",()=>{!function invalidateIconData(e){e.vars.cache||(e.vars.cache={}),e.vars.cache.iconData=null}(e),e.vars.forceRedraw=!0})),e.vars.styleHolderEl.appendChild(t)}else if(e.config["icon-class"]){const t=document.createElement("div");["icon"].concat(e.config["icon-class"].split(" ")).forEach(e=>shmi.addClass(t,e)),e.vars.iconEl=t,e.vars.styleHolderEl.appendChild(t)}}else;e.setupStylesFromCss(),e.vars.canvasObj=e.vars.canvasEl.getContext("2d"),e.vars.intersectionObserver=new IntersectionObserver(t=>{e.vars.elementIsInViewport=t[0].isIntersecting}),e.vars.mutationObserver=new MutationObserver(t=>(function invalidateStyles(e){e.vars.cache||(e.vars.cache={}),e.vars.cache.hasStyles=!1})(e)),e.imports.nv.initValueSettings(e),"string"==typeof e.config["unit-text"]?(e.vars.unit=e.config["unit-text"],e.vars.unitLocalized=shmi.localize(e.config["unit-text"])):e.vars.unitLocalized="","string"==typeof e.config.label?(e.vars.label=e.config.label,e.vars.labelLocalized=shmi.localize(e.config.label)):e.vars.labelLocalized="",e.vars.valueFormatted=shmi.localize(e.config["default-value"]),updateCanvasResolution(e);const t=2*Math.PI*(1-e.vars.styles.slice.width);drawGauge(e,e.vars.canvasObj,0,e.vars.canvasEl.width,e.vars.canvasEl.height,e.vars.styles.arcForeground.rotation,t,window.devicePixelRatio||1)},onEnable:function(){const e=this;isReady(e)&&(e.vars.intersectionObserver.observe(e.vars.canvasEl),e.vars.mutationObserver.observe(e.element,{attributes:!0,attributeFilter:["style","class"]}),e.vars.listeners.push(makeDomEventListener(window,"resize",()=>{e.vars.cache=null})),checkCache(e),startDrawing(e),e.config.item&&(e.vars.subscriptionTargetId=e.imports.im.subscribeItem(e.config.item,e)),e.vars.listeners.forEach(e=>e.enable()),e.log("Enabled",1))},onDisable:function(){const e=this;isReady(e)&&(e.vars.listeners.forEach(e=>e.disable()),function stopDrawing(e){e.vars.animationFrameToken&&(shmi.caf(e.vars.animationFrameToken),e.vars.animationFrameToken=null)}(e),e.vars.intersectionObserver.disconnect(e.vars.canvasEl),e.vars.mutationObserver.disconnect(e.element),e.config.item&&e.imports.im.unsubscribeItem(e.config.item,e.vars.subscriptionTargetId),e.log("Disabled",1))},onLock:function(){isReady(this)&&(shmi.addClass(this.element,"locked"),this.log("Locked",1))},onUnlock:function(){isReady(this)&&(shmi.removeClass(this.element,"locked"),this.log("Unlocked",1))},onSetValue:function(e,t,i){this.vars.value=e,this.vars.valueFormatted=this.imports.nv.formatOutput(this.vars.value,this),invalidateTextMeasurements(this),function startAnimation(e,t,i=250){e.vars.animationValueStep=i>0?(t-e.vars.animationValue)/i:t-e.vars.animationValue}(this,e,parseInt(this.config["animation-duration"])||0),this.vars.hasChanged=!0},getValue:function(){return this.vars.value},onSetProperties:function(e,t,i,s,n,a,l,o,r,c){const u=this;u.imports.nv.setProperties(u,arguments),u.vars.min=e,u.vars.max=t,invalidateTextMeasurements(u),u.vars.hasChanged=!0},setUnitText:function(e){const t=this;t.config["auto-unit-text"]&&(t.vars.unit=e,t.vars.unitLocalized=shmi.localize(e))},setLabel:function(e){const t=this;t.config["auto-label"]&&(t.vars.label=e,t.vars.labelLocalized=shmi.localize(e))},log:function(e,t){shmi.log("[IQ:iq-radial-gauge] "+e,t)},setupStylesFromCss:function(){const e=this;l.forEach((function(t){const i=shmi.getUiElement(t["data-ui"],e.vars.styleHolderEl);if(i){const s=getComputedStyle(i);s&&t.styleConfig.forEach((function(i){!function setStyleFromCss(e,t,i,s,n,a){const l=o[a||"identity"];if(!t||!l)return;const r="background"===i?"none"===t.getPropertyValue("background-image")?t.getPropertyValue("background-color"):t.getPropertyValue("background-image"):t.getPropertyValue(i);if(!r)return;const c=l(r);c&&(Array.isArray(n)||(n=[n]),c.forEach((t,i)=>{n[i]&&(e.vars.styles[s][n[i]]=t)}))}(e,s,i.propName,t.objName,i.attribName,i.conversion)}))}})),e.vars.cache||(e.vars.cache={}),e.vars.cache.hasStyles=!0}}};shmi.requires("visuals.tools.control-generator").generate(r)}(),function(){"use strict";const e="iq-recipe-list",t={"class-name":"iq-recipe-list",name:null,template:"default/iq-recipe-list",label:e,"recipe-template-id":null},i=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),s=i.fLog;i.log;function eventProxy(e,t){e.fire(t.type,t.detail)}function doSetValue(e,t){const i={selRowIndex:[],selRows:[],type:-1};for(let s=0;s<t.vars.dataGrid.getRowCount();s++){const n=t.vars.dataGrid.getRowData(s);n[0].value===parseInt(e)&&(i.selRowIndex=[n[0].value],i.selRows=[s],i.type=2)}t.vars.ct.setSelectedRows(i)}const n={className:"iq-recipe-list",uiType:e,isContainer:!0,config:t,configSchema:null,vars:{domChild:null,dataGridId:null,dataGrid:null,dataGridSubscriptionId:null,ct:null,eventProxy:null,tokens:[],recipeTableConfig:{label:"${recipe-list.title}",table:"",name:"","class-name":"complex-table2","field-datagrid-col-map":{id:0,name:1},"select-mode":"SINGLE","default-field-control-map":{id:{"ui-type":"iq-label",config:{"class-name":"iq-label",template:"default/iq-label.iq-variant-01",options:[],pattern:"<%= VALUE %>","value-as-tooltip":!0}},name:{"ui-type":"iq-label",config:{"class-name":"iq-label",template:"default/iq-label.iq-variant-01",options:[],pattern:null,"value-as-tooltip":!0}}},"default-field-headers":{id:"${recipe-list.table-header.id}",name:"${recipe-list.table-header.name}"},_comment:"expr is passed to expr parameter array of shmi.visuals.core.DataGridManager.setFilter",filters:[],"default-layout":{"class-name":"layout-std",_comment:"default == no additional css layout class","column-org":{col1:{fields:["id"],"column-width":"15%"},col2:{fields:["name"],"column-width":"85%"}}},"sortable-fields":["name","id"],quicksearch:{enable:!0,remember:!0,fields:["name"]},"text-mode":"SINGLELINE","show-nof-rows":!0,"v-scroll-options":["SCROLLBAR","V_SWIPE"]}},imports:{dgm:"visuals.session.DataGridManager"},events:["select"],prototypeExtensions:{onInit:function(){if("number"!=typeof this.config["recipe-template-id"])return this.element.textContent="Invalid or no recipe template id given. This control will not work. Please select a valid recipe template id.",void s("Invalid or no recipe template id given:",this.config["recipe-template-id"]);if(this.vars.domChild=shmi.getUiElement("table-container",this.element),null===this.vars.domChild)return this.element.textContent="One or more required DOM elements are missing from the template. This control will not work. Please select a compatible template.",void s("Some DOM elements are missing from the template.");do{this.vars.dataGridId="iq-recipe-list-"+Math.random().toString(36).substr(2,9)}while(null!==this.imports.dgm.getGrid(this.vars.dataGridId));this.imports.dgm.grids[this.vars.dataGridId]=this.vars.dataGrid=new shmi.visuals.core.DataGridRecipe(this.vars.dataGridId,this.config["recipe-template-id"]),this.vars.dataGrid.init(),this.vars.dataGrid.sort(1,"ASC")},rebuildTable:function(){const e=shmi.cloneObject(this.vars.recipeTableConfig);e.table=this.vars.dataGridId,e.name=this.vars.dataGridId,this.vars.dataGrid.sort(1,"ASC"),this.vars.eventProxy&&(this.vars.eventProxy.unlisten(),this.vars.eventProxy=null),this.vars.ct&&shmi.deleteControl(this.vars.ct),this.vars.ct=shmi.createControl("complex-table2",this.vars.domChild,e),null===this.vars.ct?(this.element.textContent="Unable to create table control for recipes. This control will not work.",s("Unable to create table control for recipes.")):this.vars.eventProxy=this.vars.ct.listen("select",eventProxy.bind(null,this))},getValue:function(){if(this.vars.ct){const e=this.vars.ct.getSelectionRowData(this.vars.ct.getSelectedRows());if(e.length>0)return{name:e[0][1].value,recipe_id:isNaN(e[0][0].value)?null:e[0][0].value,template_id:this.config["recipe-template-id"],values_set:1===e[0][3].value}}return null},setValue:function(e){!function checkIfSetValue(e,t){if(t.vars.dataGrid&&t.vars.ct)if(t.vars.dataGrid.tasksRunning>0){const i=shmi.listen("datagrid-ready",function(){i.unlisten(),doSetValue(e,t)}.bind(e,t))}else doSetValue(e,t)}(e,this)},refreshGrid:function(){this.vars.dataGrid&&this.vars.dataGrid.refresh()},onEnable:function(){this.vars.dataGrid&&this.rebuildTable()},onDisable:function(){this.vars.ct&&this.vars.ct.disable(),this.vars.eventProxy&&(this.vars.eventProxy.unlisten(),this.vars.eventProxy=null)},onDelete:function(){this.vars.ct&&shmi.deleteControl(this.vars.ct),this.vars.dataGrid&&delete this.imports.dgm.grids[this.vars.dataGridId],this.vars.tokens.forEach(e=>{e.unlisten()})},onLock:function(){this.vars.ct&&this.vars.ct.lock()},onUnlock:function(){this.vars.ct&&this.vars.ct.unlock()},getSelectedRecipe:function(){return this.vars.ct?this.vars.ct.getSelectionRowData(this.vars.ct.getSelectedRows()):null},getTemplate:function(){return this.config["recipe-template-id"]}}};shmi.requires("visuals.tools.control-generator").generate(n)}(),function(){"use strict";const e="IqResponsiveMenu",t="iq-responsive-menu",i={"class-name":t,name:null,template:`default/${t}`,menu:[],"mobile-layouts":[],"overlay-style":{background:"transparent",zIndex:1}},s=shmi.requires("visuals.tools.logging").createLogger(t,!0,!1),n=(s.fLog,s.log,"pics/system/icons/placeholder.svg");function createListener(e,t){const i=shmi.requires("visuals.io"),s=new i.MouseListener(e,t),n=new i.TouchListener(e,t);return{enable:function(){s.enable(),n.enable()},disable:function(){s.disable(),n.disable()}}}function makeElement(e,t,i="DIV"){const s=document.createElement(i||"DIV");return"string"==typeof e?shmi.addClass(s,e):Array.isArray(e)&&e.forEach((function(e){"string"==typeof e&&shmi.addClass(s,e)})),"string"==typeof t&&s.setAttribute("data-ui",t),s}function setSelected(e,t,i){e.vars.selected[i]!==t&&(null!==e.vars.selected[i]&&shmi.removeClass(e.vars.selected[i],"selected"),e.vars.selected[i]=t,null!==t&&shmi.addClass(t,"selected")),e.vars.selected.forEach((function(t,s){t&&s>i&&(shmi.removeClass(t,"selected"),e.vars.selected[s]=null)}))}function makeMenuElement(t,i,s){const a=i.type||(Array.isArray(i.items)?"group":"item");switch(a){case"group":return s>1&&console.warn(`[${e}] Creating sections for layers >1 not supported.`),function makeMenuSection(e,t,i=0){const s=makeElement("menu-group menu-element","menu-group","LI"),a=makeElement("group-data"),l=makeElement("icon","icon"),o=makeElement(null,null,"IMG"),r=makeElement("menu-group-label","menu-group-label"),c=makeElement("triangle"),u=makeElement(`menu-layer-${i+1} menu-layer-${i}-${i+1} menu-layer-${i+1}-${i+2} accent-border`,`menu-layer-${i+1}`,"UL"),h=t.items.map(t=>makeMenuElement(e,t,i+1)).filter(e=>!!e);l.appendChild(o),a.appendChild(l),a.appendChild(r),a.appendChild(c),h.forEach(({elements:{base:e}})=>u.appendChild(e)),s.appendChild(a),s.appendChild(u);const m=createListener(a,{onClick:function onClick(){const n=e.vars.crumbs[`layer${i}`];shmi.hasClass(s,"selected")?(setLayer(e,i),setSelected(e,null,i),0===i&&removeOverlay(e)):(setLayer(e,i+1),setSelected(e,s,i),n.textContent=shmi.localize(t.label),0===i&&createOverlay(e))}});return r.textContent=shmi.localize(t.label),t["icon-src"]?o.setAttribute("src",t["icon-src"]):o.setAttribute("src",n),"no-icon"===t["icon-mode"]?s.classList.add("no-icon"):"hidden"===t["icon-mode"]&&s.classList.add("hidden-icon"),0===i&&s.classList.add("accent-border"),{type:"section",config:{label:t.label||null,iconSrc:t["icon-src"]||null,iconMode:t["icon-mode"]||"show",access:shmi.cloneObject(t.access)},listeners:[m],elements:{base:s,iconImage:o,label:r,childList:u},children:h}}(t,i,s);case"item":return function makeMenuEntry(e,t,i=0){const s=makeElement("menu-item menu-element","menu-item","LI"),a=makeElement("icon","icon"),l=makeElement(null,null,"IMG"),o=makeElement("menu-item-label","menu-item-label"),{UiAction:r}=shmi.requires("visuals.core"),c=t.action?new r(t.action):null;a.appendChild(l),s.appendChild(a),s.appendChild(o),o.textContent=shmi.localize(t.label),l.setAttribute("src",t["icon-src"]||n),"no-icon"===t["icon-mode"]?s.classList.add("no-icon"):"hidden"===t["icon-mode"]&&s.classList.add("hidden-icon"),0===i&&s.classList.add("accent-border");const u=createListener(s,{onClick:function onClick(){setSelected(e,s,i),setLayer(e,-1),removeOverlay(e),c&&c.execute(e)}});return{type:"entry",config:{label:t.label||null,iconSrc:t["icon-src"]||null,iconMode:t["icon-mode"]||"show",access:shmi.cloneObject(t.access),action:shmi.cloneObject(t.action)},listeners:[u],elements:{base:s,iconImage:l,label:o}}}(t,i,s);case"separator":return function makeMenuSeparator(e,t,i=0){const s=makeElement("menu-item separator","menu-item","LI"),n=makeElement("menu-item-label","menu-item-label");return s.appendChild(n),n.textContent=shmi.localize(t.label),t["show-stroke"]&&s.classList.add("show-stroke"),{type:"separator",config:{label:t.label||null,showStroke:t["show-stroke"]||!1},listeners:[],elements:{base:s,label:n}}}(0,i,s);default:return console.warn(`[${e}] Unknown type for menu element ${a}`),null}}function setLayer(e,t){t!==e.vars.activeLayer&&(e.vars.activeLayer>=0&&shmi.removeClass(e.element,`layer-${e.vars.activeLayer}-active`),e.vars.activeLayer=t,t>=0&&shmi.addClass(e.element,`layer-${e.vars.activeLayer}-active`)),-1===t&&e.vars.selected.forEach((function(t,i){null!==t&&(shmi.removeClass(t,"selected"),e.vars.selected[i]=null)}))}function makeAccessConditionCallback({base:e,listeners:t},i){return s=>{s?(shmi.removeClass(e,i),t.forEach(e=>e.enable())):(shmi.addClass(e,i),t.forEach(e=>e.disable()))}}function createOverlay(e){e.vars.overlay&&removeOverlay(e);const t={element:document.createElement("DIV"),listener:null},i={onClick:null},s=t.element.style;s.position="fixed",s.top=0,s.bottom=0,s.left=0,s.right=0,s.background=e.config["overlay-style"].background,s.zIndex=e.config["overlay-style"].zIndex,document.body.insertBefore(t.element,document.body.firstChild),i.onClick=function(){e.vars.activeLayer>=0&&(setLayer(e,-1),removeOverlay(e))},t.listener=createListener(t.element,i),t.listener.enable(),e.vars.overlay=t}function removeOverlay(e){e.vars.overlay&&(e.vars.overlay.element.parentNode.removeChild(e.vars.overlay.element),e.vars.overlay.listener.disable(),e.vars.overlay=null)}const a={className:e,uiType:t,isContainer:!1,config:i,configSchema:null,vars:{listeners:[],activeLayer:-1,mobile:!1,selected:[null,null,null],crumbs:{layer0:null,layer1:null},tokens:[],overlay:null},imports:{},prototypeExtensions:{onInit:function(){this.vars.crumbs.layer0=shmi.getUiElement("selected-entry-layer-0",this.element),this.vars.crumbs.layer1=shmi.getUiElement("selected-entry-layer-1",this.element),this.vars.menu=function makeMenu(e,t){const i=shmi.getUiElement("menu-layer-0",e.element),s=shmi.getUiElement("burger-button",e.element),n=t.map(t=>makeMenuElement(e,t,0)).filter(e=>!!e);return n.forEach(({elements:{base:e}})=>i.appendChild(e)),{type:"menu",config:{},listeners:[createListener(s,{onClick:function onClick(){e.vars.activeLayer>=0?(setLayer(e,-1),removeOverlay(e)):(setLayer(e,0),createOverlay(e))}})],children:n}}(this,this.config.menu),shmi.removeClass(this.element,"mobile")},onEnable:function(){const e=this,{ConditionObserver:t}=shmi.requires("visuals.tools.conditions"),i=shmi.getCurrentLayout();-1!==e.config["mobile-layouts"].indexOf(i)?(shmi.addClass(e.element,"mobile"),e.vars.mobile=!0):(shmi.removeClass(e.element,"mobile"),e.vars.mobile=!1);const s=shmi.listen("layout-change",(function(t){-1!==e.config["mobile-layouts"].indexOf(t.detail.layout)?(shmi.addClass(e.element,"mobile"),e.vars.mobile||setLayer(e,-1),e.vars.mobile=!0):(shmi.removeClass(e.element,"mobile"),e.vars.mobile&&setLayer(e,0),e.vars.mobile=!1),removeOverlay(e)}));e.vars.tokens.push(s),e.vars.mobile||setLayer(e,0),e.vars.listeners=function collectListeners(e){return Array.isArray(e.children)?e.children.reduce((e,t)=>e.concat(collectListeners(t)),e.listeners):e.listeners||[]}(e.vars.menu),e.vars.listeners.forEach(e=>e.enable()),e.vars.tokens.push(...function collectAccessData(e){const t=[];return e.config.access&&e.config.access.condition&&["hide","lock"].includes(e.config.access.type)&&t.push({base:e.elements.base,type:e.config.access.type,condition:e.config.access.condition,listeners:e.listeners.slice(),menu:e}),Array.isArray(e.children)?e.children.reduce((e,t)=>e.concat(collectAccessData(t)),t):t}(e.vars.menu).map(e=>{switch(e.type){case"hide":return new t(e.condition,makeAccessConditionCallback(e,"hidden"));case"lock":return new t(e.condition,makeAccessConditionCallback(e,"locked"));default:throw new Error(`Invalid access type ${e.type}`)}}))},onDisable:function(){this.vars.tokens.forEach(e=>e.unlisten()),this.vars.listeners.forEach(e=>e.disable()),this.vars.tokens=[],this.vars.listeners=[],removeOverlay(this)},onLock:function(){shmi.addClass(this.element,"locked"),this.vars.listeners.forEach((function(e){e.disable()}))},onUnlock:function(){shmi.removeClass(this.element,"locked"),this.vars.listeners.forEach((function(e){e.enable()}))},onSetValue:function(e,t,i){},onSetProperties:function(e,t,i){}}};shmi.requires("visuals.tools.control-generator").generate(a)}(),function(){"use strict";var e="iq-searchbar",t={"class-name":"iq-searchbar",name:null,template:"default/iq-searchbar.iq-variant-01",label:e,"auto-label":!0,item:null,"show-icon":!1,"icon-src":null,"icon-class":null,tooltip:null,datagrid:null,"search-column":null,"show-results":"two-or-more","result-columns":null,"select-contents-on-focus":!0},i=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),s=i.fLog;i.log;function addRegisteredEventListener(e,t,i,s,n){var a=e.vars.registeredEventListeners[t];a||(a=e.vars.registeredEventListeners[t]||[]),i.addEventListener(s,n),a.push({type:s,target:i,listener:n})}function removeRegisteredEventListeners(e,t){var i=shmi.requires("visuals.tools.iterate.iterateObject"),s=[];t?(s=e.vars.registeredEventListeners[t]||[],delete e.vars.registeredEventListeners[t]):(i(e.vars.registeredEventListeners,(function(e){s=s.concat(e||[])})),e.vars.registeredEventListeners={}),s.forEach((function(e){e.target.removeEventListener(e.type,e.listener)}))}function clearHint(e){e.vars.dom.suggestion.textContent="",e.vars.currentHint=null}function setHint(e,t,i){var s;t&&(0!==(s=e.getValue()).length||i)?(e.vars.dom.suggestion.textContent=t.substr(s.length),e.vars.currentHint=t):clearHint(e)}function setHintByIdx(e,t,i){if(0!==e.vars.dataGridData.length){for(;t<0;)t+=e.vars.dataGridData.length;t%=e.vars.dataGridData.length,null!==e.vars.currentHintIndex&&shmi.removeClass(e.vars.dom.resultBox.firstChild.children[e.vars.currentHintIndex],"hint-current"),shmi.addClass(e.vars.dom.resultBox.firstChild.children[t],"hint-current"),setHint(e,e.vars.dataGridData[t][e.config["search-column"]],i),e.vars.currentHintIndex=t}else clearHint(e)}function updateHint(e,t){!function fetchHint(e,t){var i=e.vars.lastHintSearchToken&&0===t.indexOf(e.vars.lastHintSearchToken),s=e.vars.lastHintSearchResult&&0===e.vars.lastHintSearchResult.indexOf(t);if(i&&s)return onHint(e,t,e.vars.lastHintSearchResult),void updateResultBox(e,e.vars.dataGridData.filter((function(i){return i[e.config["search-column"]]&&-1!==i[e.config["search-column"]].indexOf(t)})));clearHint(e),e.vars.dataGrid.setFilter(e.vars.dataGridSearchColumnIdx,[t+"%"]),e.vars.lastHintSearchToken=t}(e,t||e.getValue())}function onHint(e,t,i){t=t||e.getValue(),i?(shmi.removeClass(e.element,"notfound"),setHint(e,i),e.vars.lastHintSearchResult=i):(t.length>0&&shmi.addClass(e.element,"notfound"),clearHint(e),e.vars.lastHintSearchResult=null)}function clearResultBox(e){for(removeRegisteredEventListeners(e,"result-box");e.vars.dom.resultBox.firstChild;)e.vars.dom.resultBox.removeChild(e.vars.dom.resultBox.firstChild)}function updateResultBox(e,t){var i,n,a=document.createElement("table"),l=!1;if(clearResultBox(e),"never"===e.config["show-results"]?l=!1:"two-or-more"===e.config["show-results"]&&t.length<=1?l=!1:0!==t.length&&(l=!0),l){if(e.vars.dom.resultBox.style.display="",i=Object.keys(t[0]),(e.config["result-columns"]||[]).length>0&&(i=i.filter((function(t){return-1!==e.config["result-columns"].indexOf(t)}))),0===i.length)return e.vars.dom.resultBox.innerHTML='No columns to display. Please check <span style="font-weight: bold">result-columns</span> in your control configuration.',void s("No columns to display.","dataGrid columns =",Object.keys(t[0]),"columns to display =",e.config["result-columns"]);(n=i.indexOf(e.config["search-column"]))>0&&(i.unshift(i[n]),i.splice(n+1,1)),t.forEach((function(t,s){var n=document.createElement("tr");i.forEach((function(e){var i=document.createElement("td");i.textContent=t[e]||"",n.appendChild(i)})),addRegisteredEventListener(e,"result-box",n,"touchstart",e=>{e.stopPropagation()}),addRegisteredEventListener(e,"result-box",n,"mousedown",(function(i){e.setValue(t[e.config["search-column"]])})),addRegisteredEventListener(e,"result-box",n,"mouseover",setHintByIdx.bind(null,e,s,!0)),addRegisteredEventListener(e,"result-box",n,"mouseleave",shmi.removeClass.bind(shmi,n,"hint-current")),a.appendChild(n)})),e.vars.dom.resultBox.appendChild(a)}else e.vars.dom.resultBox.style.display="none"}function doResultBoxScroll(e,t){var i=e.vars.dom.resultBox.scrollTop,s=i+e.vars.dom.resultBox.offsetHeight;t.offsetTop<i?t.scrollIntoView(!0):t.offsetTop+t.offsetHeight>s&&t.scrollIntoView(!1)}function hintFetchCompleteCallback(e,t){var i,s=e.getValue(),n=function getDataGridDataHelper(e,t){var i=e.getFields();return e.getCurrentIDs(t).map((function(t){var s=e.getRowData(t),n={};return s?(s.forEach((function(e,t){n[i[t]]=String(e.value)})),n):null}))}(e.vars.dataGrid,e.vars.dataGridSubscriptionId.id);n.length>0&&(i=(n[0]||{})[e.config["search-column"]]),e.vars.currentHintIndex=null,e.vars.dataGridData=n,onHint(e,s,i||null),updateResultBox(e,n),e.fire("change",{value:e.getValue()})}function setSelected(e,t){var i=document.createRange();i.selectNodeContents(e),t||i.setStart(e,i.endOffset);var s=window.getSelection();s.removeAllRanges(),s.addRange(i)}function userInputKeyDownHandler(e,t){"Tab"===t.key?e.vars.currentHint&&e.getValue()!==e.vars.currentHint&&(t.preventDefault(),e.setValue(e.vars.currentHint),clearHint(e),setSelected(e.vars.dom.input)):"Escape"===t.key?shmi.hasClass(e.element,"show-results")?shmi.removeClass(e.element,"show-results"):shmi.addClass(e.element,"show-results"):"ArrowUp"===t.key?e.vars.dom.resultBox.firstChild&&e.vars.dom.resultBox.firstChild.children&&(setHintByIdx(e,(e.vars.currentHintIndex||0)-1,!0),doResultBoxScroll(e,e.vars.dom.resultBox.firstChild.children[e.vars.currentHintIndex]),t.preventDefault()):"PageUp"===t.key?e.vars.dom.resultBox.firstChild&&e.vars.dom.resultBox.firstChild.children&&(setHintByIdx(e,Math.max((e.vars.currentHintIndex||0)-10,0),!0),doResultBoxScroll(e,e.vars.dom.resultBox.firstChild.children[e.vars.currentHintIndex]),t.preventDefault()):"ArrowDown"===t.key?e.vars.dom.resultBox.firstChild&&e.vars.dom.resultBox.firstChild.children&&(setHintByIdx(e,(e.vars.currentHintIndex||0)+1,!0),doResultBoxScroll(e,e.vars.dom.resultBox.firstChild.children[e.vars.currentHintIndex]),t.preventDefault()):"PageDown"===t.key?e.vars.dom.resultBox.firstChild&&e.vars.dom.resultBox.firstChild.children&&(setHintByIdx(e,Math.min((e.vars.currentHintIndex||0)+10,e.vars.dataGridData.length-1),!0),doResultBoxScroll(e,e.vars.dom.resultBox.firstChild.children[e.vars.currentHintIndex]),t.preventDefault()):13!==t.keyCode&&9!==event.keyCode||(t.preventDefault(),e.vars.currentHint&&e.setValue(e.vars.currentHint),t.target.blur())}function setupDomUserInput(e){addRegisteredEventListener(e,"input",e.vars.dom.input,"input",(function onInput(){var t=e.getValue();e.vars.dom.mirror.textContent=t,updateHint(e,t)})),addRegisteredEventListener(e,"input",e.vars.dom.input,"keydown",userInputKeyDownHandler.bind(null,e)),addRegisteredEventListener(e,"input",e.vars.dom.input,"focus",(function onFocus(){e.fire("enter",{value:e.getValue()}),e.vars.userInputActive=!0,shmi.addClass(e.element,"focused"),shmi.addClass(e.element,"show-results"),updateHint(e),e.config["select-contents-on-focus"]&&setSelected(e.vars.dom.input,!0)})),addRegisteredEventListener(e,"input",e.vars.dom.input,"blur",(function onBlur(){e.vars.userInputActive=!1,shmi.removeClass(e.element,"focused"),window.getSelection().removeAllRanges(),clearHint(e),e.vars.itemSubscription&&e.config.item&&e.imports.im.writeValue(e.config.item,e.getValue()),e.fire("change",{value:e.getValue()})})),addRegisteredEventListener(e,"input",e.vars.dom.input,"touchstart",(function onDown(e){e.stopPropagation()})),addRegisteredEventListener(e,"input",e.vars.dom.input,"click",(function onClick(){shmi.addClass(e.element,"show-results")}))}function setLabelImpl(e,t){e.vars.dom.label&&(""===t||null==t?(e.vars.label="",e.vars.dom.label.textContent="",shmi.addClass(e.element,"no-label")):(e.vars.label=t,e.vars.dom.label.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-label")))}var n={className:"iqSearchbar",uiType:e,isContainer:!1,config:t,configSchema:null,vars:{dom:{icon:null,label:null,input:null,mirror:null,suggestion:null,resultBox:null,clear:null},label:null,initDone:!1,registeredEventListeners:{},dataGrid:null,dataGridSubscriptionId:null,dataGridSearchColumnIdx:-1,dataGridData:[],currentHint:null,currentValue:null,lastHintSearchToken:null,lastHintSearchResult:null,userInputActive:!1,currentHintIndex:null,itemSubscription:null,listeners:[]},imports:{im:"visuals.session.ItemManager",dgm:"visuals.session.DataGridManager"},events:["change","enter"],prototypeExtensions:{onInit:function(){var e=this,t=shmi.requires("visuals.io");if(this.vars.dom.icon=shmi.getUiElement("icon",this.element),this.vars.dom.label=shmi.getUiElement("label",this.element),this.vars.dom.input=shmi.getUiElement("searchbar-user-input",this.element),this.vars.dom.mirror=shmi.getUiElement("searchbar-mirror",this.element),this.vars.dom.suggestion=shmi.getUiElement("searchbar-suggestion",this.element),this.vars.dom.resultBox=shmi.getUiElement("searchbar-result-box",this.element),this.vars.dom.clear=shmi.getUiElement("clear-input",this.element),this.vars.dataGrid=this.imports.dgm.getGrid(this.config.datagrid),!function verifyDomElements(e){var t=shmi.requires("visuals.tools.iterate.iterateObject"),i=!0;return t(e,(function(e){i=i&&null!==e})),i}(this.vars.dom))return this.element.textContent="One or more required DOM elements are missing from the template. This control will not work. Please select a compatible template.",void s("Some DOM elements are missing from the template.");if(this.vars.dom.icon)if(this.config["icon-src"]&&this.config["show-icon"])this.vars.dom.icon.style.backgroundImage=`url(${this.config["icon-src"]})`;else if(this.config["icon-class"]&&this.config["show-icon"]){this.config["icon-class"].trim().split(" ").forEach(shmi.addClass.bind(shmi,this.vars.dom.icon))}else shmi.addClass(this.element,"no-icon");else shmi.log("[IQ:iq-input-field] no button-icon element provided",1);setLabelImpl(this,this.config.label);var i=shmi.getUiElement("searchbar-label",this.element);i&&(this.config.label&&String(this.config.label).length>0?i.textContent=shmi.localize(this.config.label):i.style.display="none");var n={onClick:function(){e.isActive()&&!e.locked&&e.setValue("")}};if(e.vars.listeners.push(new t.MouseListener(e.vars.dom.clear,n)),e.vars.listeners.push(new t.TouchListener(e.vars.dom.clear,n)),null===this.vars.dataGrid)return this.element.textContent="Unable to find datagrid or no datagrid configured. This control will not work. Please select a valid datagrid.",void(this.config.datagrid?s("Datagrid not found",this.config.datagrid):s("No datagrid configured"));this.vars.initDone=!0,this.vars.dataGridSearchColumnIdx=this.vars.dataGrid.getFields().indexOf(this.config["search-column"]),-1===this.vars.dataGridSearchColumnIdx&&(this.element.textContent="Datagrid does not have the configured field to search in. This control will not work. Please select a valid search field.",s("Datagrid does not have the configured search field.")),this.vars.dataGrid.sort(this.vars.dataGridSearchColumnIdx,"ASC")},getValue:function(){if(!this.vars.initDone)return null;return this.vars.dom.input.value.replace(String.fromCharCode(160)," ")},getMatchData:function(){return function getMatchData(e){return(e.vars.dataGridData||[])[e.vars.currentHintIndex||0]||null}(this)},setValue:function(e){this.vars.initDone&&(this.vars.dom.input.value=e,this.vars.dom.mirror.textContent=e,updateHint(this,e))},onEnable:function(){this.vars.initDone&&(setupDomUserInput(this),this.vars.dataGridSubscriptionId=this.vars.dataGrid.subscribePage(0,100,hintFetchCompleteCallback.bind(null,this)),this.config.item&&(this.vars.itemSubscription=this.vars.im.subscribeItem(this.config.item,this)),this.vars.listeners.forEach((function(e){e.enable()})))},onDisable:function(){this.vars.initDone&&(this.vars.dataGrid.unsubscribe(this.vars.dataGridSubscriptionId.id),this.vars.dataGridSubscriptionId=null,this.vars.itemSubscription&&(this.vars.itemSubscription.unlisten(),this.vars.itemSubscription=null),clearResultBox(this),removeRegisteredEventListeners(this),this.vars.listeners.forEach((function(e){e.disable()})))},onLock:function(){this.vars.listeners.forEach((function(e){e.disable()})),shmi.addClass(this.element,"locked")},onUnlock:function(){this.vars.listeners.forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked")},onSetValue:function(e,t,i){this.vars.initDone&&!this.vars.userInputActive&&this.setValue(e)},onSetProperties:function(e,t,i){},setLabel:function(e){this.vars.dom.label&&this.config["auto-label"]&&setLabelImpl(this,e)}}};shmi.requires("visuals.tools.control-generator").generate(n)}(),function(){"use strict";var e=shmi.requires("visuals.tools.logging").createLogger("iq-select-box",!0,!1);e.fLog,e.log;function setLabelImpl(e,t){e.vars.labelEl&&(""===t||null==t?(e.vars.label="",e.vars.labelEl.textContent="",shmi.addClass(e.element,"no-label")):(e.vars.label=t,e.vars.labelEl.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-label")))}var t={className:"iq-select-box",uiType:"iq-select-box",isContainer:!1,config:{"class-name":"iq-select-box",name:null,template:"default/iq-select-box.iq-variant-01",label:"[Label]",item:null,"auto-label":!0,"icon-src":null,"icon-class":null,tooltip:null,"no-selection-label":"---",selected:-1,options:[],"show-text":!0,"show-icon":!1},configSchema:null,vars:{listeners:[],optionListeners:[],domListeners:{},value:0,active:!1,templateEl:null,labelEl:null,iconEl:null,containerEl:null,anchorEl:null,optionEl:null,selectedEl:null,selectedValEl:null,optionEls:[],selected:-1,clickedInside:!1,isOpen:!1,isLocked:!1,highlightIndex:null,subscriptionTargetId:null,iconClass:"iq-icon",showTextAndIconClass:"iq-icon-and-text",showIconOnlyClass:"iq-icon-only",labelAreaClass:"iq-label-area",highlightClass:"highlighted",selectBoxSelectedClass:"iq-select-box-selected",optionIconAndTextClass:"iq-option-icon-and-text",optionIconOnlyClass:"iq-option-icon-only",optionIconClass:"iq-option-icon"},imports:{im:"visuals.session.ItemManager",iter:"visuals.tools.iterate.iterateObject"},events:["change"],prototypeExtensions:{onInit:function(){var e=this;if(e.vars.templateEl=e.element.cloneNode(!0),e.vars.iqWidgetContent=shmi.getUiElement("iq-widget-content",e.element),e.vars.labelEl=shmi.getUiElement("label",e.element),e.vars.iconEl=shmi.getUiElement("icon",e.element),e.vars.containerEl=shmi.getUiElement("options",e.element),e.vars.selectedEl=shmi.getUiElement("selected",e.element),e.vars.selectedValEl=shmi.getUiElement("value",e.vars.selectedEl),e.vars.optionEl=shmi.getUiElement("option",e.element),e.vars.anchorEl=shmi.getUiElement("anchor",e.vars.containerEl),e.vars.containerEl&&e.vars.anchorEl&&e.vars.optionEl&&e.vars.selectedEl&&e.vars.selectedValEl){if(e.vars.iqWidgetContent.removeChild(e.vars.selectedEl),e.vars.iqWidgetContent.removeChild(e.vars.containerEl),e.vars.iqWidgetContent.removeChild(e.vars.optionEl),e.vars.containerEl=shmi.getUiElement("options",e.vars.templateEl),e.vars.anchorEl=shmi.getUiElement("anchor",e.vars.containerEl),e.vars.optionEl=shmi.getUiElement("option",e.vars.templateEl),e.vars.selectedEl=shmi.getUiElement("selected",e.vars.templateEl),e.vars.selectedValEl=shmi.getUiElement("value",e.vars.selectedEl),e.vars.iconEl)if(e.config["icon-src"]&&e.config["show-icon"])e.vars.iconEl.style.backgroundImage=`url(${e.config["icon-src"]})`;else if(e.config["icon-class"]&&e.config["show-icon"]){e.config["icon-class"].trim().split(" ").forEach((function(t){shmi.addClass(e.vars.iconEl,t)}))}else shmi.addClass(e.element,"no-icon");else shmi.log("[IQ:iq-select-box] no button-icon element provided",1);e.config["show-text"]?setLabelImpl(e,e.config.label):setLabelImpl(e,null);var t=document.createElement("DIV");shmi.addClass(t,"iq-popup-container"),e.vars.iqWidgetContent.appendChild(t),t.appendChild(e.vars.containerEl),t.appendChild(e.vars.selectedEl),e.rebuildOptions(!0),e.vars.selected=e.config.selected,e.vars.containerEl.setAttribute("tabindex","-1"),e.vars.domListeners=e.createDomListenerObject(),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.element,e.createElementListenerObject())),e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.element,e.createElementListenerObject())),e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.vars.containerEl,e.createContainerListenerObject())),shmi.addClass(e.vars.containerEl,"hidden"),-1===e.vars.selected?e.setSelected(null):e.setSelected(e.vars.optionEls[e.config.selected])}else shmi.log("[IQ:iq-select-box] At least one element is missing: containerEl, anchorEl, optionEl, selectedEl, selectedValEl",3)},onEnable:function(){this.element.setAttribute("tabindex",0),this.lockUnlockListeners(!1),this.config.item&&(this.vars.subscriptionTargetId=this.imports.im.subscribeItem(this.config.item,this)),shmi.log("[IQ:iq-select-box] Enabled",1)},onDisable:function(){this.lockUnlockListeners(!0),this.vars.subscriptionTargetId&&(this.vars.subscriptionTargetId.unlisten(),this.vars.subscriptionTargetId=null),shmi.log("[IQ:iq-select-box] disabled",1)},onLock:function(){this.vars.isLocked=!0,shmi.addClass(this.vars.containerEl,"hidden"),this.vars.highlightIndex=-1,this.lockUnlockListeners(!0),shmi.addClass(this.element,"locked"),shmi.log("[IQ:iq-select-box] Locked",1)},onUnlock:function(){this.lockUnlockListeners(!1),shmi.removeClass(this.element,"locked"),shmi.log("[IQ:iq-select-box] unlocked",1)},setOptions:function(e){this.config.options=e,this.rebuildOptions(this.active),this.setValue(this.getValue())},getOptions:function(){return shmi.cloneObject(this.config.options)},setSelected:function(e){const t=this,i=t.vars.optionEls.findIndex(t=>t===e);if(t.vars.optionEls.forEach((function(e,i){shmi.removeClass(e,t.vars.selectBoxSelectedClass)})),-1===i)t.vars.selectedValEl.textContent=shmi.localize(t.config["no-selection-label"]),t.vars.value=null,shmi.removeClass(t.vars.selectedEl,t.vars.showTextAndIconClass),shmi.removeClass(t.vars.selectedEl,t.vars.showIconOnlyClass);else{const l=t.config.options[i].label;shmi.addClass(e,t.vars.selectBoxSelectedClass),t.vars.selectedValEl.textContent=shmi.localize(l),t.vars.value=t.config.options[i].value;var s=t.config.options[i],n=shmi.getUiElement("option-icon",t.vars.selectedEl),a=!1;s&&n?(a=t.setIcon(n,s,!0))&&s.label?shmi.addClass(t.vars.selectedEl,t.vars.optionIconAndTextClass):a?shmi.addClass(t.vars.selectedEl,t.vars.optionIconOnlyClass):(shmi.removeClass(t.vars.selectedEl,t.vars.optionIconAndTextClass),shmi.removeClass(t.vars.selectedEl,t.vars.optionIconOnlyClass)):n&&(shmi.removeClass(t.vars.selectedEl,t.vars.optionIconAndTextClass),shmi.removeClass(t.vars.selectedEl,t.vars.optionIconOnlyClass))}t.vars.selected=i},getCurrentIndex:function(){return this.vars.selected},updateValue:function(){this.config.item&&this.imports.im.writeValue(this.config.item,this.getValue())},onSetValue:function(e,t,i){const s=this,n=s.getValue();shmi.log("[IQ:iq-select-box] Setting value...: "+e,0);const a=s.config.options.findIndex(t=>t.value===e);s.setSelected(-1!==a?s.vars.optionEls[a]:null),s.getValue()!==n&&s.fire("change",{value:s.getValue()}),shmi.log("[IQ:iq-select-box] Value set: "+e,1)},getValue:function(){return this.vars.value},setLabel:function(e){this.vars.labelEl&&this.config["auto-label"]&&this.config["show-text"]&&setLabelImpl(this,e)},lockUnlockListeners:function(e){this.vars.listeners.forEach((function(t){e?t.disable():t.enable()})),this.imports.iter(this.vars.domListeners,(function(t,i){t.element&&(e?t.element.removeEventListener(t.event,t.callback):t.element.addEventListener(t.event,t.callback))}))},rebuildOptions:function(e){var t=this;for(t.vars.optionListeners.forEach((function(e){e.disable()})),t.vars.optionListeners=[],t.vars.optionEls=[];t.vars.anchorEl.firstChild;)t.vars.anchorEl.removeChild(t.vars.anchorEl.firstChild);t.config.options.forEach((function(e,i){var s=shmi.localize(e.label),n=t.vars.optionEl.cloneNode(!0),a=shmi.getUiElement("value",n),l=shmi.getUiElement("icon",n),o=!1;a?a.textContent=s:n.textContent=s,(e.tooltip||e["icon-title"])&&n.setAttribute("title",shmi.localize(e.tooltip||e["icon-title"])),l&&((o=t.setIcon(l,e,!1))&&s?shmi.addClass(n,t.vars.optionIconAndTextClass):o&&shmi.addClass(n,t.vars.optionIconOnlyClass)),t.vars.anchorEl.appendChild(n),t.vars.optionEls.push(n)}));var i=t.makeOptionMouseHandler(),s=t.makeOptionTouchHandler();t.vars.optionEls.forEach((function(e){t.vars.optionListeners.push(new shmi.visuals.io.TouchListener(e,s)),t.vars.optionListeners.push(new shmi.visuals.io.MouseListener(e,i))})),e&&t.vars.optionListeners.forEach((function(e){e.enable()}))},setIcon:function(e,t,i){var s=null,n=!1;return t["icon-src"]?("IMG"!==e.tagName?(s=document.createElement("IMG"),e.parentNode.insertBefore(s,e),e.parentNode.removeChild(e)):s=e,shmi.addClass(s,this.vars.optionIconClass),s.setAttribute("src",t["icon-src"]),n=!0):t["icon-class"]?("DIV"!==e.tagName?(s=document.createElement("DIV"),e.parentNode.insertBefore(s,e),e.parentNode.removeChild(e)):s=e,shmi.addClass(s,this.vars.optionIconClass),shmi.addClass(s,t["icon-class"]),n=!0):shmi.addClass(e,this.vars.optionIconClass),s&&n?s.dataset.ui="option-icon":e.dataset.ui="option-icon",n?shmi.removeClass(e,"hidden"):shmi.addClass(e,"hidden"),n},makeOptionMouseHandler:function(){var e=this;return{onClick:function onClick(t,i,s){shmi.log("[IQ:iq-select-box] Click on element",0);const n=e.getValue();e.setSelected(s.currentTarget),e.updateValue(),shmi.addClass(e.vars.containerEl,"hidden"),e.vars.isOpen=!1,e.vars.highlightIndex=-1,e.getValue()!==n&&e.fire("change",{value:e.getValue()})},onPress:function onPress(e,t,i){shmi.log("[IQ:iq-select-box] Press",0),i.preventDefault()},onRelease:function onRelease(){shmi.log("[IQ:iq-select-box] Release",0)}}},makeOptionTouchHandler:function(){var e=this;return{onPress:function onPress(){},onClick:function onClick(t,i,s){const n=e.getValue();shmi.log("[IQ:iq-select-box] Click on element",0),e.setSelected(s.currentTarget),e.updateValue(),shmi.addClass(e.vars.containerEl,"hidden"),e.vars.isOpen=!1,e.vars.highlightIndex=-1,e.getValue()!==n&&e.fire("change",{value:e.getValue()})}}},createDomListenerObject:function(){var e=this;return{containerBlur:{event:"blur",element:e.vars.containerEl,callback:function(t){e.vars.clickedInside?setTimeout((function(){e.vars.containerEl.focus()}),shmi.c("DECOUPLE_TIMEOUT")):(shmi.addClass(e.vars.containerEl,"hidden"),setTimeout((function(){e.vars.isOpen=!1}),shmi.c("DECOUPLE_TIMEOUT")),e.vars.highlightIndex=-1)}},elementKeydown:{event:"keydown",element:e.element,callback:function(t){var i=t.key?t.key:t.code;!(this.element===document.activeElement&&!this.locked)||"Enter"!==i&&"NumpadEnter"!==i||(shmi.log("[IQ:iq-select-box] click on container",1),e.vars.isOpen?e.vars.containerEl.blur():(shmi.removeClass(e.vars.containerEl,"hidden"),e.vars.isOpen=!0,setTimeout((function(){e.vars.containerEl.focus(),shmi.visuals.session.FocusElement=e.vars.containerEl}),shmi.c("DECOUPLE_TIMEOUT"))))}},containerKeydown:{event:"keydown",element:e.vars.containerEl,callback:function(t){var i=t.key?t.key:t.code;if(shmi.log("[IQ:iq-select-box] Keydown event: "+i,1),e.vars.highlightIndex<0&&(e.vars.highlightIndex=e.getCurrentIndex()),shmi.log("[IQ:iq-select-box] Highlight index "+e.vars.highlightIndex,1),"Escape"===i)e.vars.optionEls.forEach((function(e){shmi.removeClass(e,"highlighted")})),shmi.addClass(e.vars.containerEl,"hidden"),e.vars.isOpen=!1,e.vars.highlightIndex=-1;else if("Enter"===i||"NumpadEnter"===i){if(-1!==e.vars.highlightIndex){shmi.log("[IQ:iq-select-box] Click on element",0);var s=e.vars.optionEls[e.vars.highlightIndex],n=e.getValue();e.setSelected(s),e.updateValue(),shmi.addClass(e.vars.containerEl,"hidden"),e.vars.isOpen=!1,e.vars.highlightIndex=-1,e.getValue()!==n&&e.fire("change",{value:e.getValue()}),e.vars.optionEls.forEach((function(e){shmi.removeClass(e,"highlighted")})),e.vars.highlightIndex=-1}}else"ArrowUp"===i?(e.vars.optionEls[e.vars.highlightIndex]&&shmi.removeClass(e.vars.optionEls[e.vars.highlightIndex],"highlighted"),e.vars.highlightIndex>0?e.vars.highlightIndex--:e.vars.highlightIndex=e.vars.optionEls.length-1,e.vars.optionEls[e.vars.highlightIndex]&&shmi.addClass(e.vars.optionEls[e.vars.highlightIndex],"highlighted")):"ArrowDown"===i&&(e.vars.optionEls[e.vars.highlightIndex]&&shmi.removeClass(e.vars.optionEls[e.vars.highlightIndex],"highlighted"),e.vars.highlightIndex<e.vars.optionEls.length-1?e.vars.highlightIndex++:e.vars.highlightIndex=0,e.vars.optionEls[e.vars.highlightIndex]&&shmi.addClass(e.vars.optionEls[e.vars.highlightIndex],"highlighted"));return!1}}}},createElementListenerObject:function(){var e=this;return{onPress:function(){},onClick:function(t,i,s){s.target!==e.vars.anchorEl&&(shmi.log("[IQ:is-select-box] Click on container",1),e.vars.isOpen?e.vars.containerEl.blur():(shmi.removeClass(e.vars.containerEl,"hidden"),e.vars.isOpen=!0,setTimeout((function(){e.vars.containerEl.focus(),shmi.visuals.session.FocusElement=e.vars.containerEl}),shmi.c("DECOUPLE_TIMEOUT"))))}}},createContainerListenerObject:function(){var e=this;return{onPress:function(t,i,s){s.currentTarget===e.vars.containerEl&&(e.vars.clickedInside=!0)},onRelease:function(t,i,s){s.currentTarget===e.vars.containerEl&&(e.vars.clickedInside=!1)},onLeave:function(){shmi.log("[IQ:iq-select-box] onLeave container element",0),e.vars.containerEl.blur(),e.vars.highlightIndex=-1}}}}};shmi.requires("visuals.tools.control-generator").generate(t)}(),function(){"use strict";var e=shmi.requires("visuals.tools.logging").createLogger("iq-select-date",!0,!1);e.fLog,e.log;function setLabelImpl(e,t){e.vars.labelEl&&(""===t||null==t?(e.vars.label="",e.vars.labelEl.textContent="",shmi.addClass(e.element,"no-label")):(e.vars.label=t,e.vars.labelEl.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-label")))}var t={className:"iq-select-date",uiType:"iq-select-date",isContainer:!1,config:{"class-name":"iq-select-date",name:null,template:"default/iq-select-date.variant-01",label:"[Label]",item:null,"auto-label":!0,tooltip:null,dateformat:"${V_DATEFORMAT}",daynames:["${V_SUN_SHORT}","${V_MON_SHORT}","${V_TUE_SHORT}","${V_WED_SHORT}","${V_THU_SHORT}","${V_FRI_SHORT}","${V_SAT_SHORT}"],"daynames-long":["${V_SUN}","${V_MON}","${V_TUE}","${V_WED}","${V_THU}","${V_FRI}","${V_SAT}"],monthnames:["${V_JAN}","${V_FEB}","${V_MAR}","${V_APR}","${V_MAY}","${V_JUN}","${V_JUL}","${V_AUG}","${V_SEP}","${V_OCT}","${V_NOV}","${V_DEC}"],"show-icon":!1,"show-text":!0,"icon-src":null,"icon-class":null,"icon-title":null},configSchema:null,vars:{listeners:[],value:0,active:!1,isOpen:!0,labelEl:null,calendarEl:null,daySelectEl:null,headerEl:null,dayNameEls:null,selectedEl:null,dayEls:[],monthSelectEl:null,previousMonthEl:null,currentMonthEl:null,nextMonthEl:null,yearSelectEl:null,previousYearEl:null,currentYearEl:null,nextYearEl:null,pressedEl:null,blurHandler:null,subscriptionTargetId:null,date:null,selectedDate:null},imports:{im:"visuals.session.ItemManager",nv:"visuals.tools.numericValues",dt:"visuals.tools.date"},events:["change"],prototypeExtensions:{onInit:function(){var e=this;if(e.initDate(),e.vars.iconEl=shmi.getUiElement("icon",e.element),e.vars.labelEl=shmi.getUiElement("label",e.element),e.vars.calendarEl=shmi.getUiElement("calendar",e.element),e.vars.daySelectEl=shmi.getUiElement("day-select",e.element),e.vars.headerEl=shmi.getUiElement("day-header",e.element),e.vars.yearSelectEl=shmi.getUiElement("year-select",e.element),e.vars.dayNameEls=shmi.getUiElements("day-name",e.vars.headerEl),e.vars.dayEls=shmi.getUiElements("day",e.element),e.vars.valueEl=shmi.getUiElement("value",e.element),e.vars.selectedEl=shmi.getUiElement("selected-date",e.element),e.vars.valueEl&&(e.vars.selectedEl=e.vars.valueEl),e.vars.monthSelectEl=shmi.getUiElement("month-select",e.element),e.vars.monthSelectEl&&(e.vars.previousMonthEl=shmi.getUiElement("previous",e.vars.monthSelectEl),e.vars.currentMonthEl=shmi.getUiElement("current",e.vars.monthSelectEl),e.vars.nextMonthEl=shmi.getUiElement("next",e.vars.monthSelectEl)),e.vars.yearSelectEl&&(e.vars.previousYearEl=shmi.getUiElement("previous",e.vars.yearSelectEl),e.vars.currentYearEl=shmi.getUiElement("current",e.vars.yearSelectEl),e.vars.nextYearEl=shmi.getUiElement("next",e.vars.yearSelectEl)),e.vars.calendarEl&&e.vars.daySelectEl&&e.vars.selectedEl&&e.vars.headerEl&&e.vars.monthSelectEl&&e.vars.yearSelectEl)if(!e.vars.dayNameEls||e.vars.dayNameEls&&7!==e.vars.dayNameEls.length)shmi.log("[IQ:iq-select-date] No day-name elements, or not the right count (7) provided",3);else if(e.vars.previousMonthEl&&e.vars.currentMonthEl&&e.vars.nextMonthEl&&e.vars.previousYearEl&&e.vars.currentYearEl&&e.vars.nextYearEl){if(e.vars.dayNameEls.forEach((function(t,i){t.textContent=shmi.localize(e.config.daynames[6===i?0:i+1])})),e.vars.calendarEl.setAttribute("tabindex","0"),e.vars.iconEl)if(e.config["icon-src"]&&e.config["show-icon"])e.vars.iconEl.style.backgroundImage=`url(${e.config["icon-src"]})`;else if(e.config["icon-class"]&&e.config["show-icon"]){e.config["icon-class"].trim().split(" ").forEach((function(t){shmi.addClass(e.vars.iconEl,t)}))}else shmi.addClass(e.element,"no-icon");else shmi.log("[IQ:iq-select-date] no button-icon element provided",1);e.setupListeners(),e.updateCalendar(),setLabelImpl(e,e.config["show-text"]?e.config.label:null)}else shmi.log("[IQ:iq-select-date] Not all month & year select elements provided",3);else shmi.log("[IQ:iq-select-date] No calendar/day-select/selected-date/value/day-header/month-select/year-select element provided",3)},onEnable:function(){this.vars.calendarEl&&this.vars.calendarEl.addEventListener("blur",this.vars.blurHandler),this.vars.listeners.forEach((function(e){e.enable()})),this.config.item&&(this.vars.subscriptionTargetId=this.imports.im.subscribeItem(this.config.item,this)),shmi.log("[IQ:iq-select-date] Enabled",1)},onDisable:function(){this.vars.calendarEl&&this.vars.calendarEl.removeEventListener("blur",this.vars.blurHandler),this.vars.listeners.forEach((function(e){e.disable()})),this.config.item&&this.imports.im.unsubscribeItem(this.config.item,this.vars.subscriptionTargetId),shmi.log("[IQ:iq-select-date] disabled",1)},onLock:function(){shmi.addClass(this.vars.calendarEl,"hidden"),this.isOpen=!1,this.vars.calendarEl&&this.vars.calendarEl.removeEventListener("blur",this.vars.blurHandler),this.vars.listeners.forEach((function(e){e.disable()})),shmi.addClass(this.element,"locked"),shmi.log("[IQ:iq-select-date] Locked",1)},onUnlock:function(){this.vars.calendarEl&&this.vars.calendarEl.addEventListener("blur",this.vars.blurHandler),this.vars.listeners.forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked"),shmi.log("[IQ:iq-select-date] unlocked",1)},onSetValue:function(e,t,i){var s=new Date(1e3*e),n=this.vars.value;e=parseInt(e),this.vars.value=e,this.vars.date.setFullYear(s.getYear()+1900,s.getMonth()),this.vars.selectedDate.setFullYear(s.getYear()+1900,s.getMonth(),s.getDate()),this.updateCalendar(),n!==this.vars.value&&this.fire("change",{value:this.vars.value})},getValue:function(){return this.vars.value},setLabel:function(e){this.vars.labelEl&&this.config["auto-label"]&&this.config["show-text"]&&setLabelImpl(this,e)},updateDateMonth:function(e,t){this.vars.date.setFullYear(this.vars.date.getYear()+1900,e),this.vars.selectedDate.setFullYear(this.vars.date.getYear()+1900,e,t.textContent)},setupListeners:function(){var e=this,t={onPress:function(){},onClick:function(t,i,s){e.vars.date.setFullYear(e.vars.date.getYear()+1900,e.vars.date.getMonth()-1),e.updateCalendar()}};e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.vars.previousMonthEl,t)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.vars.previousMonthEl,t));var i={onPress:function(){},onClick:function(t,i,s){e.vars.date.setFullYear(e.vars.date.getYear()+1900,e.vars.date.getMonth()+1),e.updateCalendar()}};e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.vars.nextMonthEl,i)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.vars.nextMonthEl,i));var s={onPress:function(){},onClick:function(t,i,s){e.vars.date.setFullYear(e.vars.date.getYear()+1900-1,e.vars.date.getMonth()),e.updateCalendar()}};e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.vars.previousYearEl,s)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.vars.previousYearEl,s));var n={onPress:function(){},onClick:function(t,i,s){e.vars.date.setFullYear(e.vars.date.getYear()+1900+1,e.vars.date.getMonth()),e.updateCalendar()}};e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.vars.nextYearEl,n)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.vars.nextYearEl,n)),e.vars.pressedEl=null;var a={onPress:function(t,i,s){shmi.addClass(s.target,"pressed"),e.vars.pressedEl=s.target},onRelease:function(t,i,s){shmi.removeClass(e.vars.pressedEl,"pressed")},onClick:function(t,i,s){var n=s.target;shmi.hasClass(n,"iq-previous-month-day")?e.updateDateMonth(e.vars.date.getMonth()-1,n):shmi.hasClass(n,"iq-current-month-day")?e.updateDateMonth(e.vars.date.getMonth(),n):shmi.hasClass(n,"iq-next-month-day")&&e.updateDateMonth(e.vars.date.getMonth()+1,n),e.updateCalendar(),e.config.item&&e.imports.im.writeValue(e.config.item,e.vars.value),shmi.addClass(e.vars.calendarEl,"hidden"),e.vars.isOpen=!1}};e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.vars.daySelectEl,a)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.vars.daySelectEl,a)),shmi.addClass(e.vars.calendarEl,"hidden"),e.vars.isOpen=!1;var l={onClick:function(){e.vars.isOpen?e.vars.calendarEl.blur():(shmi.removeClass(e.vars.calendarEl,"hidden"),e.isOpen=!0,shmi.decouple(()=>{e.vars.calendarEl.focus(),shmi.visuals.session.FocusElement=e.vars.calendarEl}))}};e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.element,l)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.element,l)),e.vars.blurHandler=function(){shmi.addClass(e.vars.calendarEl,"hidden"),shmi.decouple(()=>{e.vars.isOpen=!1})}},updateCalendar:function(){var e=this.vars.value,t=new Date(1e3*this.vars.value);this.initDate(),t.setFullYear(this.vars.selectedDate.getYear()+1900,this.vars.selectedDate.getMonth(),this.vars.selectedDate.getDate()),this.vars.value=t.getTime()/1e3,shmi.log("[IQ:iq-select-date] selected time: "+this.vars.value,0);var i=this.vars.date.getMonth(),s=this.vars.date.getYear()+1900,n=new Date(s,i,1).getDay(),a=n-1;this.vars.currentMonthEl.textContent=shmi.localize(this.config.monthnames[i]),this.vars.currentYearEl.textContent=s,1===n?a=7:0===n&&(a=6);for(var l=this.getDaysOfMonth(i,s),o=this.getDaysOfMonth(i+1,s),r=shmi.getUiElements("day",this.element),c=l-a+1,u=0;u<a;u++)r[u].className="iq-previous-month-day",r[u].textContent=c,new Date(s,i-1,c).getTime()===this.vars.selectedDate.getTime()?shmi.addClass(r[u],"iq-selected"):shmi.removeClass(r[u],"iq-selected"),c++;for(c=1,u=a;u<o+a;u++)r[u].className="iq-current-month-day",r[u].textContent=c,new Date(s,i,c).getTime()===this.vars.selectedDate.getTime()?shmi.addClass(r[u],"iq-selected"):shmi.removeClass(r[u],"iq-selected"),c++;for(c=1,u=o+a;u<r.length;u++)r[u].className="iq-next-month-day",r[u].textContent=c,new Date(s,i+1,c).getTime()===this.vars.selectedDate.getTime()?shmi.addClass(r[u],"iq-selected"):shmi.removeClass(r[u],"iq-selected"),c++;var h=shmi.localize(this.config.dateformat);"string"==typeof h?this.vars.selectedEl.textContent=this.imports.dt.formatDateTime(this.vars.selectedDate,{datestring:h}):this.vars.selectedEl.innerHTML="&nbsp;",e!==this.vars.value&&this.fire("change",{value:this.vars.value})},getDaysOfMonth:function(e,t){return new Date(t,e,0).getDate()},initDate:function(){null===this.vars.date&&(this.vars.date=new Date),null===this.vars.selectedDate&&(this.vars.selectedDate=new Date((new Date).setHours(0,0,0,0)))}}};shmi.requires("visuals.tools.control-generator").generate(t)}(),function(){"use strict";var e=shmi.requires("visuals.tools.logging").createLogger("iq-select-radio",!0,!1);e.fLog,e.log;function setLabelImpl(e,t){e.vars.labelEl&&(""===t||null==t?(e.vars.label="",e.vars.labelEl.textContent="",shmi.addClass(e.element,"no-label")):(e.vars.label=t,e.vars.labelEl.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-label")))}var t={className:"iq-select-radio",uiType:"iq-select-radio",isContainer:!1,config:{"class-name":"iq-select-radio",name:null,template:"default/iq-select-radio.variant-01",label:"[Label]",item:null,"auto-label":!0,"show-icon":!1,"icon-src":null,"icon-class":null,tooltip:null,options:[],selected:-1},configSchema:null,vars:{listeners:[],value:-1,active:!1,optionContainerEl:null,optionEls:[],labelEl:null,iconEl:null,iconClassEl:null,label:null,selectedEl:null},imports:{im:"visuals.session.ItemManager",nv:"visuals.tools.numericValues"},events:["change"],prototypeExtensions:{onInit:function(){var e=this;if(e.vars.labelEl=shmi.getUiElement("label",e.element),e.vars.iconEl=shmi.getUiElement("icon",e.element),e.vars.optionEl=shmi.getUiElement("option",e.element),e.vars.optionContainerEl=shmi.getUiElement("option-container",e.element),e.config.options)if(shmi.log("[IQ:iq-select-radio] Options newly defined",1),e.vars.optionEl&&e.vars.optionContainerEl){var t=e.vars.optionEl.cloneNode(!0);if(e.vars.optionContainerEl.removeChild(e.vars.optionEl),e.vars.optionEl=t,e.vars.iconEl)if(e.config["show-icon"]){if(e.config["icon-src"])e.vars.iconEl&&(e.vars.iconEl.style.backgroundImage=`url(${e.config["icon-src"]})`);else if(e.config["icon-class"]){if(e.vars.iconEl)shmi.removeClass(e.vars.iconEl,"iq-icon"),shmi.addClass(e.vars.iconEl,"iq-icon-class"),e.config["icon-class"].trim().split(" ").forEach((function(t){shmi.addClass(e.vars.iconEl,t)}))}}else e.vars.iconEl.style.display="none";else shmi.log("[IQ:iq-select-radio] no button-icon element provided",1);setLabelImpl(e,e.config.label),e.rebuildOptions()}else shmi.log("[IQ:iq-select-radio] Missing option and/or option container element in template!",1);else shmi.log("[IQ:iq-select-radio] No options defined in config",1)},onEnable:function(){this.vars.listeners.forEach((function(e){e.enable()})),this.config.item&&(this.vars.subscriptionTargetId=this.imports.im.subscribeItem(this.config.item,this)),shmi.log("[IQ:iq-select-radio] Enabled",1)},onDisable:function(){this.vars.listeners.forEach((function(e){e.disable()})),this.config.item&&this.imports.im.unsubscribeItem(this.config.item,this.vars.subscriptionTargetId),shmi.log("[IQ:iq-select-radio] disabled",1)},onLock:function(){this.vars.listeners.forEach((function(e){e.disable()})),shmi.addClass(this.element,"locked"),shmi.log("[IQ:iq-select-radio] Locked",1)},onUnlock:function(){this.vars.listeners.forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked"),shmi.log("[IQ:iq-select-radio] unlocked",1)},onSetValue:function(e,t,i){var s=this.vars.value!==e;this.vars.value=e;const n=this.config.options.findIndex(t=>t.value===e);-1!==n?this.setSelected(this.vars.optionEls[n]):this.setSelected(null),shmi.log("[IQ:iq-select-radio] value set: "+e,1),s&&this.fire("change",{value:this.vars.value})},getValue:function(){return this.vars.value},onSetProperties:function(e,t,i){var s=this;s.imports.nv.setProperties(s,arguments)},setLabel:function(e){this.vars.labelEl&&this.config["auto-label"]&&setLabelImpl(this,e)},rebuildOptions:function(e){var t=this;t.vars.listeners.forEach((function(e){e.disable()})),t.vars.listeners=[];const i=t.vars.optionContainerEl,s=t.vars.optionEl;t.vars.optionEls=[],i.innerHTML="",t.config.options.forEach((function(e,n){const a=s.cloneNode(!0);a.dataset.value=e.value,a.dataset.no=n;const l=shmi.getUiElement("option-label",a);l&&(l.textContent=shmi.localize(e.label));const o=shmi.getUiElement("option-icon",a);e["icon-src"]&&o?o.style.backgroundImage=`url(${e["icon-src"]})`:e["icon-class"]&&o?shmi.addClass(o,e["icon-class"]):shmi.addClass(a,"no-icon"),e.tooltip&&o&&o.setAttribute("title",shmi.localize(e.tooltip)),i.appendChild(a),t.vars.optionEls.push(a)}));var n={onPress:function onPress(e,t,i){shmi.addClass(i.currentTarget,"pressed")},onRelease:function onRelease(e,i,s){t.vars.optionEls.forEach(e=>{shmi.removeClass(e,"pressed")})},onClick:function onClick(e,i,s){var n=s.target,a=null,l=!1,o=null;(a=void 0!==n.dataset.ui&&"option"===n.dataset.ui?n:n.closest('[data-ui="option"]'))?void 0===a.dataset.no?(console.error(t.uiType,"Could not match clicked option (data-no missing!?)"),console.log(a)):(l=(o=t.config.options[parseInt(a.dataset.no)]).value!==t.vars.value,t.vars.value=o.value,t.setSelected(a),t.updateValue(),l&&t.fire("change",{value:t.vars.value})):console.error(t.uiType,"Could not match clicked option")}};t.vars.listeners.push(new shmi.visuals.io.MouseListener(t.vars.optionContainerEl,n)),t.vars.listeners.push(new shmi.visuals.io.TouchListener(t.vars.optionContainerEl,n)),e&&t.listeners.forEach((function(e){e.enable()}))},setSelected:function(e){this.vars.optionEls.forEach(t=>{e!==t?shmi.removeClass(t,"selected"):shmi.addClass(t,"selected")}),this.vars.selectedEl=e},getCurrentIndex:function(){var e=this.vars.selectedEl;return this.vars.optionEls.findIndex(t=>e===t)},setOptions:function(e){this.config.options=e,this.vars.value=-1,this.vars.selectedEl=null,this.rebuildOptions(this.active)},updateValue:function(){this.config.item&&shmi.visuals.session.ItemManager.writeValue(this.config.item,this.vars.value)}}};shmi.requires("visuals.tools.control-generator").generate(t)}(),function(){"use strict";var e=shmi.requires("visuals.tools.logging").createLogger("iq-select-time",!0,!1);e.fLog,e.log;function setLabelImpl(e,t){e.vars.labelEl&&(""===t||null==t?(e.vars.label="",e.vars.labelEl.textContent="",shmi.addClass(e.element,"no-label")):(e.vars.label=t,e.vars.labelEl.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-label")))}function setInputDisabledState(e,t){e.vars.hourEl&&(e.vars.hourEl.disabled=t),e.vars.minuteEl&&(e.vars.minuteEl.disabled=t),e.vars.secondEl&&(e.vars.secondEl.disabled=t)}var t={className:"iq-select-time",uiType:"iq-select-time",isContainer:!1,config:{"class-name":"iq-select-time",name:null,template:"default/iq-select-time.iq-variant-01",label:"[Label]",item:null,"auto-label":!0,"numpad-enabled":!1,tooltip:null,isUTC:!1},configSchema:null,vars:{listeners:[],value:0,active:!1,label:null,subscriptionTargetId:null,labelEl:null,hourEl:null,minuteEl:null,secondEl:null,hours:0,minutes:0,seconds:0,evListeners:[],itemNeedsString:!1},imports:{im:"visuals.session.ItemManager"},events:["change"],prototypeExtensions:{onInit:function(){this.vars.labelEl=shmi.getUiElement("label",this.element),this.setupRockerComponent({varName:"hourEl",uiElementName:"hour-select",inputValidator:this.validateGeneric.bind(this,/^[0-1]?[0-9]$|^2[0-3]$/,"hours"),addHandler:this.addHours.bind(this),max:23,label:"${V_HOURS}"}),this.setupRockerComponent({varName:"minuteEl",uiElementName:"minute-select",inputValidator:this.validateGeneric.bind(this,/^[0-5]?[0-9]$/,"minutes"),addHandler:this.addMinutes.bind(this),max:59,label:"${V_MINUTES}"}),this.setupRockerComponent({varName:"secondEl",uiElementName:"second-select",inputValidator:this.validateGeneric.bind(this,/^[0-5]?[0-9]$/,"seconds"),addHandler:this.addSeconds.bind(this),max:59,label:"${V_SECONDS}"}),this.updateInputFields(this.vars),setLabelImpl(this,this.config.label)},onEnable:function(){this.vars.listeners.forEach((function(e){e.enable()})),this.config.item&&(this.vars.subscriptionTargetId=this.imports.im.subscribeItem(this.config.item,this)),setInputDisabledState(this,!1),this.log("Enabled",1)},onDisable:function(){this.vars.listeners.forEach((function(e){e.disable()})),this.config.item&&this.imports.im.unsubscribeItem(this.config.item,this.vars.subscriptionTargetId),setInputDisabledState(this,!0),this.log("Disabled",1)},onLock:function(){setInputDisabledState(this,!0),this.vars.listeners.forEach((function(e){e.disable()})),shmi.addClass(this.element,"locked"),this.log("Locked",1)},onUnlock:function(){setInputDisabledState(this,!1),this.vars.listeners.forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked"),this.log("Unlocked",1)},onDelete:function(){this.vars.evListeners.forEach((function(e){e.element.removeEventListener(e.eventType,e.listener)})),this.vars.evListeners=[],this.vars.listeners=[]},onSetValue:function(e,t,i){e=parseInt(e);var s=new Date(1e3*e);this.vars.itemNeedsString="string"==typeof e,this.config.isUTC?(this.vars.hours=s.getUTCHours(),this.vars.minutes=s.getUTCMinutes(),this.vars.seconds=s.getUTCSeconds()):(this.vars.hours=s.getHours(),this.vars.minutes=s.getMinutes(),this.vars.seconds=s.getSeconds()),this.updateInputFields(this.vars),this.vars.value!==e&&(this.vars.value=e,this.fire("change",{value:e}))},getValue:function(){return this.vars.value},getHours:function(){return this.vars.hours},getMinutes:function(){return this.vars.minutes},getSeconds:function(){return this.vars.seconds},onSetProperties:function(e,t,i,s,n,a,l,o,r,c){},setLabel:function(e){this.vars.labelEl&&this.config["auto-label"]&&setLabelImpl(this,e)},log:function(e,t){shmi.log("[IQ:iq-select-time] "+e,t)},getType:function(e){return Array.isArray(e)?"array":null===e?"null":typeof e},checkType:function(e,t){if(Array.isArray(t)){if(!(e in t))return!1}else if(t!==this.getType(e))return!1;return!0},assertType:function(e,t,i){if(!this.checkType(e,t))throw TypeError(i)},computeNewValue:function(){var e=this.vars,t=new Date(1e3*e.value);return this.config.isUTC?(t.setUTCHours(e.hours),t.setUTCMinutes(e.minutes),t.setUTCSeconds(e.seconds)):(t.setHours(e.hours),t.setMinutes(e.minutes),t.setSeconds(e.seconds)),t.getTime()/1e3},updateValue:function(){var e=this.computeNewValue();this.config.item&&(this.vars.itemNeedsString?this.imports.im.writeValue(this.config.item,String(e)):this.imports.im.writeValue(this.config.item,e)),this.vars.value!==e&&(this.vars.value=e,this.fire("change",{value:e})),this.updateInputFields(this.vars)},integerToGroup:function(e,t){return(t+e%t)%t},addSeconds:function(e){this.assertType(e,"number"),this.vars.secondEl&&this.vars.secondEl.blur(),this.vars.seconds=this.integerToGroup(this.vars.seconds+e,60),this.updateValue()},addMinutes:function(e){this.assertType(e,"number"),this.vars.minuteEl&&this.vars.minuteEl.blur(),this.vars.minutes=this.integerToGroup(this.vars.minutes+e,60),this.updateValue()},addHours:function(e){this.assertType(e,"number"),this.vars.hourEl&&this.vars.hourEl.blur(),this.vars.hours=this.integerToGroup(this.vars.hours+e,24),this.updateValue()},validateGeneric:function(e,t,i){RegExp(e).test(i.value)?(this.vars[t]=parseInt(i.value),this.updateValue(this),this.vars[t]<10&&1===i.value.length&&(i.value="0"+i.value)):this.vars[t]<10?i.value="0"+this.vars[t]:i.value=this.vars[t]},inputKeypressListener:function(e,t){13===Number(t.keyCode)&&(t.preventDefault(),window.getSelection().removeAllRanges(),e.blur())},inputChangeListener:function(e,t){13===Number(t.keyCode)||e.value.length>1&&(window.getSelection().removeAllRanges(),e.blur())},inputBlurListener:function(e,t,i){window.getSelection().removeAllRanges(),shmi.removeClass(e,"selectableText"),t(e)},addClickTouchListener:function(e,t,i){e.listeners.push(new shmi.visuals.io.MouseListener(t,i)),e.listeners.push(new shmi.visuals.io.TouchListener(t,i))},addEventListener:function(e,t,i,s){t.addEventListener(i,s),e.evListeners.push({element:t,eventType:i,listener:s})},createInputField:function(e,t,i,s){if(t){var n=shmi.requires("visuals.session.config"),a=n.keyboard&&n.keyboard.enabled;(s=shmi.cloneObject(s)).callback=function(e){t.value=e,i(t)},this.addClickTouchListener(e,t,{onPress:(e,t,i)=>{(s.numpadEnabled||a)&&(i.preventDefault(),i.stopPropagation())},onClick:function onClick(e,i,n){(s.numpadEnabled||a)&&(s.value=t.value,shmi.numpad(s))}}),this.addEventListener(e,t,"keypress",this.inputKeypressListener.bind(null,t)),this.addEventListener(e,t,"input",this.inputChangeListener.bind(null,t)),this.addEventListener(e,t,"blur",this.inputBlurListener.bind(null,t,i)),this.addEventListener(e,t,"focus",e=>{s.numpadEnabled||a?(s.value=t.value,shmi.numpad(s)):t.select()})}else this.log("no base element provided",1)},setupRockerComponent:function(e){var t=shmi.getUiElement(e.uiElementName,this.element);if(!t)return this.log("Element not found: "+e.uiElementName,1),!1;var i=shmi.getUiElement("previous",t);if(!i)return this.log("No UI element found for "+e.uiElementName+".previous",1),!1;var s=shmi.getUiElement("current",t);if(!s)return this.log("No UI element found for "+e.uiElementName+".current",1),!1;var n=shmi.getUiElement("next",t);return n?(this.createInputField(this.vars,s,e.inputValidator.bind(this),{min:0,max:e.max,label:e.label,numpadEnabled:this.config["numpad-enabled"]||!1}),this.addClickTouchListener(this.vars,i,{onPress:shmi.addClass.bind(null,i,"pressed"),onRelease:shmi.removeClass.bind(null,i,"pressed"),onClick:e.addHandler.bind(null,-1)}),this.addClickTouchListener(this.vars,n,{onPress:shmi.addClass.bind(null,n,"pressed"),onRelease:shmi.removeClass.bind(null,n,"pressed"),onClick:e.addHandler.bind(null,1)}),this.vars[e.varName]=s,!0):(this.log("No UI element found for "+e.uiElementName+".next",1),!1)},updateInputFields:function(e){this.vars.hourEl&&(this.vars.hourEl.value=e.hours>9?e.hours:"0"+e.hours),this.vars.minuteEl&&(this.vars.minuteEl.value=e.minutes>9?e.minutes:"0"+e.minutes),this.vars.secondEl&&(this.vars.secondEl.value=e.seconds>9?e.seconds:"0"+e.seconds)}}};shmi.requires("visuals.tools.control-generator").generate(t)}(),function(){"use strict";const e="IqShape";function translateVector2D(e,t){return[e[0]+t[0],e[1]+t[1]]}const t={className:e,uiType:"iq-shape",isContainer:!1,config:{"class-name":"iq-shape",name:null,template:"default/iq-shape",polygons:[],rotation:0,scale:1},configSchema:null,vars:{},imports:{},events:[],prototypeExtensions:{onInit:function onInit(){const t=shmi.getUiElement("shape",this.element),i=function calculateRotationMatrix2D(e){return[[Math.cos(e),-Math.sin(e)],[Math.sin(e),Math.cos(e)]]}((this.config.rotation||0)/360*2*Math.PI);if(!t)return void console.error(`[${e}] "shape" element is missing in template.`);const s=function getUiElements(t,i){const s={};return t.every(t=>{const n=shmi.getUiElement(t,i);return n?(s[t]=n,!0):(console.error(`[${e}] "${t}" element is missing in template.`),!1)})?s:null}(["shape-polygon","clip-path","clip-path-polygon"],t);if(!s)return;const n=Math.floor(Math.random()*Number.MAX_SAFE_INTEGER);Object.entries(s).forEach(([e,t])=>t.setAttribute("id",`${e}-${n}`)),s["shape-polygon"].setAttribute("clip-path",`url(#clip-path-${n})`);const a=(this.config.polygons||[]).map(e=>(function scaleVector2DCentered(e,t){return translateVector2D(function scaleVector2D(e,t){return[e[0]*t,e[1]*t]}(translateVector2D(e,[-.5,-.5]),t),[.5,.5])})(function rotateVector2DCenter(e,t){return translateVector2D(function rotateVector2D(e,t){return[t[0][0]*e[0]+t[0][1]*e[1],t[1][0]*e[0]+t[1][1]*e[1]]}(translateVector2D(e,[-.5,-.5]),t),[.5,.5])}(e,i),this.config.scale/100)),l=function makePolygonPoints(e,t,i){return i.map(([i,s])=>`${i*e},${s*t}`).join(" ")}(t.viewBox.baseVal.width,t.viewBox.baseVal.height,a);switch(s["shape-polygon"].tagName){case"polygon":s["shape-polygon"].setAttribute("points",l),s["clip-path-polygon"].setAttribute("points",l)}}}};shmi.requires("visuals.tools.control-generator").generate(t)}(),function(){"use strict";const e={"class-name":"iq-slider",name:null,template:"default/iq-slider.iq-variant-01","send-interval":100,"animation-duration":100,continuous:!0,min:0,max:100,step:0,precision:-1,type:shmi.c("TYPE_FLOAT"),label:"[Label]","unit-text":"[Unit]","decimal-delimiter":".","auto-min":!0,"auto-max":!0,"auto-step":!0,"auto-label":!0,"auto-unit-text":!0,"auto-type":!0,"auto-precision":!0,"initial-text":"-","show-text":!0,"show-icon":!1,"icon-src":null,"icon-class":null},t={NO_LABEL:"no-label",NO_ICON:"no-icon",NO_UNIT:"no-unit",LOCKED:"locked",PRESSED:"pressed"},i={VERTICAL:"vertical",HORIZONTAL:"horizontal"};function setLabel(e,i){const{elements:s}=e.vars;"string"==typeof i&&i.length?(s.label.textContent=shmi.localize(i),shmi.removeClass(e.element,t.NO_LABEL)):(s.label.textContent="",shmi.addClass(e.element,t.NO_LABEL))}function setUnit(e,i){const{elements:s}=e.vars;"string"==typeof i&&i.length?(s.unit.textContent=shmi.localize(i),shmi.removeClass(e.element,t.NO_UNIT)):(s.unit.textContent="",shmi.addClass(e.element,t.NO_UNIT))}function updateDimensions(e){const{dims:t,elements:s,orientation:n}=e.vars;switch(n){case i.HORIZONTAL:t.track=s.track.clientWidth,t.handle=s.handle.offsetWidth,t.touchzone=s.touchzone.offsetWidth;break;case i.VERTICAL:t.track=s.track.clientHeight,t.handle=s.handle.offsetHeight,t.touchzone=s.touchzone.offsetHeight}updateHandle(e,getTranslation(e,e.getValue()))}function getListener(e,t,i=null){let s=!1;return null===i&&(i=window),{enable:()=>{s||(i.addEventListener(e,t),s=!0)},disable:()=>{s&&(i.removeEventListener(e,t),s=!1)},keepUnlocked:!0}}function getInputHandler(e){return{onPress:function(){e.vars.dragging=!1,shmi.addClass(e.vars.elements.handle,t.PRESSED)},onDrag:function(t,s,n){n.preventDefault();const{movable:a,dims:l}=e.vars;e.vars.dragging||(e.vars.dragging=!0,!1!==e.config.continuous&&function startSend(e){0===e.vars.sendInterval&&(e.vars.sendInterval=setInterval(updateValue.bind(null,e),e.getConfig()["send-interval"]))}(e)),e.vars.orientation===i.VERTICAL?(a.ty+s>0?(a.ty=0,a.update()):a.ty+s<Math.min(0,l.handle-l.track)?(a.ty=Math.min(0,l.handle-l.track),a.update()):a.translate(0,s),updateScale(e,a.ty),updateTouchZone(e,a.ty)):(a.tx+t<0?(a.tx=0,a.update()):a.tx+t+l.handle>l.track?(a.tx=Math.max(0,l.track-l.handle),a.update()):a.translate(t,0),updateScale(e,a.tx),updateTouchZone(e,a.tx))},onRelease:function(){e.vars.dragging=!1,function stopSend(e){0!==e.vars.sendInterval&&(clearInterval(e.vars.sendInterval),e.vars.sendInterval=0)}(e),updateValue(e),shmi.removeClass(e.vars.elements.handle,t.PRESSED)}}}function getSliderTrackInputHandler(e){const s=getInputHandler(e),n=s.onPress,a=s.onRelease;return Object.assign(s,{onPress:function onPress(a,l,o){const{movable:r,dims:c}=e.vars,{min:u,max:h}=e.vars.valueSettings;e.vars.dragging=!0,shmi.addClass(e.vars.elements.track,t.PRESSED);const m=e.vars.elements.track.getBoundingClientRect();if(e.vars.orientation===i.VERTICAL){const t=l-m.y;r.ty=getTranslation(e,(1-t/c.track)*(h-u)+u),updateScale(e,r.ty),updateTouchZone(e,r.ty)}else{const t=a-m.x;r.tx=getTranslation(e,t/c.track*(h-u)+u),updateScale(e,r.tx),updateTouchZone(e,r.tx)}r.update(),updateValue(e),n.call(s,a,l,o)},onRelease:function onRelease(...i){a.call(s,...i),shmi.removeClass(e.vars.elements.track,t.PRESSED),e.vars.elements.handle.focus()}})}function updateValue(e){const{nv:t,im:s}=e.imports,{valueSettings:n,orientation:a,movable:l,dims:o,elements:r}=e.vars,{min:c,max:u}=n,h=e.getConfig(),m=e.getValue(),d=a===i.VERTICAL?-l.ty:l.tx,f=o.track-o.handle;let v=null;f<=0||(v=u===c?u:d*(u-c)/f+c,v=t.applyInputSettings(v,e),v!==m&&(r.value&&(r.value.textContent=t.formatOutput(v,e)),e.vars.value=v,h.item?s.writeValue(h.item,v):e.fire("change",{value:v})))}function updateHandle(e,t){isNaN(t)||(e.vars.orientation===i.VERTICAL?e.vars.movable.ty=t:e.vars.movable.tx=t,e.vars.movable.update(),updateScale(e,t),updateTouchZone(e,t))}function updateScale(e,t){let i=e.vars.dims.track-e.vars.dims.handle,s=i>0?Math.abs(t)/i:1;const{elements:{scale:n}}=e.vars;n.style.setProperty("--internal-fill-level",`${100*s}%`)}function updateTouchZone(e,t){const{MIN_MOVED_PX:s}=shmi.Constants,{dims:n,orientation:a,elements:l}=e.vars,o=Math.max(0,n.track-n.handle);shmi.caf(e.vars.touchzoneRafId),e.vars.touchzoneRafId=shmi.raf(()=>{t=Math.abs(t),a===i.VERTICAL?t<s?(l.touchzone.style.height=`calc(100% + ${Math.floor(t)+s}px)`,e.vars.touchzoneState.offsetModified&&(l.touchzone.style.top="",e.vars.touchzoneState.offsetModified=!1),e.vars.touchzoneState.lengthModified=!0):t>o-s?(l.touchzone.style.height=`calc(100% + ${Math.floor(o-t)+s}px)`,l.touchzone.style.top=`-${Math.floor(o-t)}px`,e.vars.touchzoneState.lengthModified=!0,e.vars.touchzoneState.offsetModified=!0):(e.vars.touchzoneState.lengthModified&&(l.touchzone.style.height="",e.vars.touchzoneState.lengthModified=!1),e.vars.touchzoneState.offsetModified&&(l.touchzone.style.top="",e.vars.touchzoneState.offsetModified=!1)):t<s?(l.touchzone.style.width=`calc(100% + ${Math.floor(t)+s}px)`,l.touchzone.style.left=`-${Math.floor(t)}px`,e.vars.touchzoneState.lengthModified=!0,e.vars.touchzoneState.offsetModified=!0):t>o-s?(l.touchzone.style.width=`calc(100% + ${Math.floor(o-t)+s}px)`,e.vars.touchzoneState.offsetModified&&(l.touchzone.style.left="",e.vars.touchzoneState.offsetModified=!1),e.vars.touchzoneState.lengthModified=!0):(e.vars.touchzoneState.lengthModified&&(l.touchzone.style.width="",e.vars.touchzoneState.lengthModified=!1),e.vars.touchzoneState.offsetModified&&(l.touchzone.style.left="",e.vars.touchzoneState.offsetModified=!1))})}function getTranslation(e,t){const{min:s,max:n}=e.vars.valueSettings,{dims:a,orientation:l}=e.vars;let o=null;return o=n===s?Math.max(0,a.track-a.handle):(t-s)/(n-s)*Math.max(0,a.track-a.handle),l===i.VERTICAL&&(o*=-1),o}const s={className:"IqSlider",uiType:"iq-slider",isContainer:!1,config:e,configSchema:null,vars:{elements:{label:null,icon:null,value:null,unit:null,track:null,scale:null,handle:null,touchzone:null},listeners:[],tokens:[],valueSettings:null,value:0,orientation:i.HORIZONTAL,dims:{track:null,handle:null,touchzone:null},dragging:!1,movable:null,anim:null,sendInterval:0,touchzoneState:{lengthModified:!1,offsetModified:!1},touchzoneRafId:0,firstDraw:!0},imports:{im:"visuals.session.ItemManager",iter:"visuals.tools.iterate.iterateObject",nv:"visuals.tools.numericValues",io:"visuals.io",gfx:"visuals.gfx"},events:["change"],prototypeExtensions:{onInit:function(){const e=this,{elements:s,listeners:n}=e.vars,{iter:a,nv:l,io:o,gfx:r}=e.imports;a(s,(t,i)=>{s[i]=shmi.getUiElement(i,e.element)}),s.track&&s.scale&&s.handle?(l.initValueSettings(e),s.value&&"string"==typeof e.config["initial-text"]&&(s.value.textContent=shmi.localize(e.config["initial-text"])),s.label&&setLabel(e,e.config["show-text"]?e.config.label:null),s.unit&&setUnit(e,e.config["unit-text"]),s.track.dataset.orientation===i.HORIZONTAL||s.track.dataset.orientation===i.VERTICAL?e.vars.orientation=s.track.dataset.orientation:console.warn(`[IqSlider] invalid orientation setting '${s.track.dataset.orientation}' in template '${e.getConfig().template}', defaulting to horizontal.`),e.vars.orientation===i.VERTICAL?s.scale.style.transformOrigin="bottom":s.scale.style.transformOrigin="left",function initIcon(e){const{elements:i}=e.vars,s=e.getConfig();i.icon?s["show-icon"]&&s["icon-src"]?i.icon.style.backgroundImage=`url(${e.config["icon-src"]})`:s["show-icon"]&&s["icon-class"]?shmi.addClass(i.icon,s["icon-class"]):shmi.addClass(e.element,t.NO_ICON):shmi.addClass(e.element,t.NO_ICON)}(e),e.vars.movable=new r.Movable(s.handle),e.vars.anim=new r.Animation(updateHandle.bind(null,e)),n.push(getListener("resize",updateDimensions.bind(null,e))),n.push(getListener("visuals-layout-change",updateDimensions.bind(null,e))),n.push(new o.MouseListener(s.handle,getInputHandler(e))),n.push(new o.TouchListener(s.handle,getInputHandler(e))),n.push(new o.MouseListener(s.track,getSliderTrackInputHandler(e))),n.push(new o.TouchListener(s.track,getSliderTrackInputHandler(e)))):console.error('[IqSlider] template is missing required element ("track", "scale", "handle")')},onEnable:function(){const e=this,{tokens:t,listeners:i}=e.vars,{im:s}=e.imports;i.forEach(e=>e.enable()),updateDimensions(e),e.vars.firstDraw=!0,e.config.item&&t.push(s.subscribeItem(e.config.item,e))},onDisable:function(){this.vars.listeners.forEach(e=>e.disable()),this.vars.tokens.forEach(e=>e.unlisten()),this.vars.tokens=[],this.vars.anim.stop()},onDelete:function(){},onLock:function(){this.vars.listeners.forEach(e=>{e.keepUnlocked||e.disable()}),shmi.addClass(this.element,t.LOCKED)},onUnlock:function(){this.vars.listeners.forEach(e=>{e.keepUnlocked||e.enable()}),shmi.removeClass(this.element,t.LOCKED)},onSetProperties:function(){const e=this,{nv:t}=e.imports;t.setProperties(e,arguments)},onSetValue:function(e){const t=this,s=shmi.requires("visuals.tools.numericValues"),{elements:n,orientation:a,anim:l,movable:o}=t.vars,r=t.getConfig(),c=t.getValue();t.vars.value=s.applyInputSettings(e,t),n.value&&(n.value.textContent=s.formatOutput(t.vars.value,t)),t.vars.dragging||(l.setCurrentValue(a===i.VERTICAL?o.ty:o.tx),t.vars.firstDraw?(t.vars.firstDraw=!1,l.start(getTranslation(t,t.vars.value),0)):l.start(getTranslation(t,t.vars.value),r["animation-duration"])),t.vars.value!==c&&t.fire("change",{value:t.vars.value})},getValue:function(){return this.vars.value},setLabel:function(e){const t=this,{elements:i}=t.vars;t.config["show-text"]&&t.config["auto-label"]&&i.label&&(setLabel(t,e),updateDimensions(t))},setUnitText:function(e){const t=this,{elements:i}=t.vars;t.config["auto-unit-text"]&&i.unit&&(setUnit(t,e),updateDimensions(t))}}};shmi.requires("visuals.tools.control-generator").generate(s)}(),function(){"use strict";var e={"class-name":"iq-text-display",name:null,template:"default/iq-text-display.variant-01",label:"[Label]",item:null,min:Number.NEGATIVE_INFINITY,max:Number.POSITIVE_INFINITY,precision:-1,"decimal-delimiter":".",type:shmi.c("TYPE_INT"),"unit-text":"[Unit]","auto-label":!0,"auto-unit-text":!0,"auto-min":!0,"auto-max":!0,"auto-precision":!0,"auto-type":!0,"icon-src":null,"icon-class":null,"icon-title":null,tooltip:null,"initial-text":"-"},t=shmi.requires("visuals.tools.logging").createLogger("iq-text-display",!0,!1);t.fLog,t.log;function setLabel(e,t){"string"==typeof t&&t.length?(e.vars.labelEl.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-label")):(e.vars.labelEl.textContent="",shmi.addClass(e.element,"no-label"))}var i={className:"iq-text-display",uiType:"iq-text-display",isContainer:!1,config:e,configSchema:null,tooltipProperties:["icon-title"],vars:{listeners:[],value:0,active:!1,currentValueEl:null,labelEl:null,unitEl:null,iconEl:null,initialized:!1,subscriptionTargetId:null,requestId:null},imports:{im:"visuals.session.ItemManager",nv:"visuals.tools.numericValues"},events:[],prototypeExtensions:{onInit:function(){const e=this;if(e.imports.nv.initValueSettings(e),e.vars.labelEl=shmi.getUiElement("label",e.element),e.vars.unitEl=shmi.getUiElement("unit",e.element),e.vars.iconEl=shmi.getUiElement("icon",e.element),e.vars.currentValueEl=shmi.getUiElement("value",e.element),!e.vars.currentValueEl)return shmi.log("[IQ:iq-text-display] Current value element is missing)",3),e.vars.labelEl=null,void(e.vars.unitEl=null);if(e.vars.unitEl&&(e.config["unit-text"]?(e.vars.unit=e.config["unit-text"],e.vars.unitEl.textContent=shmi.localize(e.config["unit-text"])):e.vars.unitEl.textContent=""),this.config["unit-scale"]&&(this.config["unit-scale"]=parseFloat(shmi.localize(this.config["unit-scale"]))),e.vars.labelEl&&e.config["show-text"]?setLabel(e,e.config.label):setLabel(e,null),e.vars.iconEl)if(e.config["show-icon"]&&e.config["icon-src"])e.vars.iconEl.style.backgroundImage=`url(${e.config["icon-src"]})`;else if(e.config["show-icon"]&&e.config["icon-class"]){e.config["icon-class"].trim().split(" ").forEach((function(t){shmi.addClass(e.vars.iconEl,t)}))}else shmi.addClass(e.element,"no-icon");else shmi.log("[IQ:iq-button] no button-icon element provided",1),shmi.addClass(e.element,"no-icon");"string"==typeof e.config["initial-text"]&&(e.vars.currentValueEl.textContent=shmi.localize(e.config["initial-text"]))},onEnable:function(){this.config.item&&(this.vars.subscriptionTargetId=this.imports.im.subscribeItem(this.config.item,this)),shmi.log("[IQ:iq-text-display] Enabled",1)},onDisable:function(){this.config.item&&this.imports.im.unsubscribeItem(this.config.item,this.vars.subscriptionTargetId),shmi.log("[IQ:iq-text-display] disabled",1)},onSetValue:function(e,t,i){var s=this;t===shmi.c("TYPE_STRING")?s.vars.value=e:isNaN(parseFloat(e))?s.vars.value=e:s.vars.value=parseFloat(e),shmi.caf(s.vars.requestId),s.vars.requestId=shmi.raf((function(){s.asyncSet(t)}))},onSetProperties:function(){const e=this,{nv:t}=e.imports;t.setProperties(e,arguments)},setUnitText:function(e){this.vars.unitEl&&this.config["auto-unit-text"]&&(this.vars.unit=e,this.vars.unitEl.textContent=shmi.localize(e))},setLabel:function(e){this.vars.labelEl&&this.config["auto-label"]&&this.config["show-text"]&&setLabel(this,e)},asyncSet:function(e){shmi.visuals.session.deactivateControls?setTimeout(this.asyncSet.bind(this,e),shmi.c("ACTION_RETRY_TIMEOUT")):this.vars.currentValueEl.textContent=this.imports.nv.formatOutput(this.vars.value,this)},onLock:function(){shmi.addClass(this.element,"locked")},onUnlock:function(){shmi.removeClass(this.element,"locked")}}};shmi.requires("visuals.tools.control-generator").generate(i)}(),function(){"use strict";var e=shmi.requires("visuals.tools.logging").createLogger("iq-text",!0,!1),t=(e.fLog,e.log,{className:"iq-text",uiType:"iq-text",isContainer:!1,config:{"class-name":"iq-text",name:null,template:"default/iq-text.variant-01",text:"[Text]",items:[],tooltip:null},configSchema:null,vars:{tokens:[],textEl:null,itemValues:[],rafId:0},imports:{im:"visuals.session.ItemManager",nv:"visuals.tools.numericValues"},events:[],prototypeExtensions:{onInit:function(){this.vars.textEl=shmi.getUiElement("text",this.element),this.vars.textEl?this.config.text&&(this.vars.textEl.textContent=shmi.localize(this.config.text)):shmi.log("[IQ:iq-text] Missing main element",3)},onEnable:function(){var e=this;Array.isArray(e.config.items)&&e.config.items.forEach((function(t,i){var s=e.imports.im.getItemHandler();e.vars.itemValues.push({value:null,unit:null,label:null}),s.setValue=function setValue(t,s,n){const a=e.imports.im.getItem(n);let l=null;a&&(a.adapter&&a.adapter.unitText?l=a.adapter.unitText:"string"==typeof a.unit&&(l=a.unit),e.vars.itemValues[i]={value:s===shmi.Constants.TYPE_STRING?a.readValue():e.imports.nv.formatNumber(a.readValue(!0),{precision:a.digits,unit:a.unit,"show-unit":!1}),unit:l,label:a.labelToken},e.updateText())},e.vars.tokens.push(e.imports.im.subscribeItem(t,s))})),shmi.log("[IQ:iq-text] Enabled",1)},onDisable:function(){this.vars.tokens.forEach((function(e){e.unlisten()})),this.vars.tokens=[],shmi.log("[IQ:iq-text] disabled",1)},onLock:function(){shmi.addClass(this.element,"locked"),shmi.log("[IQ:iq-text] Locked",1)},onUnlock:function(){shmi.removeClass(this.element,"locked"),shmi.log("[IQ:iq-text] unlocked",1)},updateText:function(){var e=this;shmi.caf(e.vars.rafId),e.vars.rafId=shmi.raf((function(){e.isActive()&&(e.vars.textEl.textContent=shmi.evalString(shmi.localize(e.config.text),{items:e.vars.itemValues}))}))}}});shmi.requires("visuals.tools.control-generator").generate(t)}(),function(){"use strict";const e=shmi.requires("visuals.tools.logging").createLogger("iq-user-info",!0,!1),t=e.fLog;e.log;function getUser(e){const{username:i}=e.vars.user;e.imports.request("user.list",{},(function(s,n){if(s&&Array.isArray(s.users)){const n=s.users.find(({username:e})=>e===i);if(!n)return void t("User not found in remote user list");e.vars.user.name=n.first_name,e.vars.user.surname=n.last_name,function displayUser(e){const i=shmi.getUiElement("user-info-name",e.element);i?(e.config["show-name"]||(e.config["show-name"]=!1),!1===e.config["show-name"]?i.textContent=e.vars.user.username:!0===e.config["show-name"]&&(e.vars.user.name&&e.vars.user.surname?i.textContent=e.vars.user.name+" "+e.vars.user.surname:e.vars.user.name?e.vars.user.surname?i.textContent="First Name and/or Last Name not set!":i.textContent=e.vars.user.name:i.textContent=e.vars.user.surname)):t('DOM-Element "user-info-name" not found!')}(e)}else t("[UserManager] could not retrieve userlist:",n.category,n.errc,n.message),t("User name and surname cannot be displayed!")}))}const i={className:"iqUserInfo",uiType:"iq-user-info",isContainer:!1,config:{"class-name":"iq-user-info",name:null,template:"default/iq-user-info.variant-01",label:"[Label]","show-name":!1,"show-group":!1,action:null},configSchema:null,vars:{user:{userGroups:null,name:null,surname:null,username:null},action:null,listeners:[]},imports:{request:"visuals.tools.connect.request"},events:["click"],prototypeExtensions:{onInit:function(){const e=this;e.config.action&&(e.vars.action=new shmi.visuals.core.UiAction(e.config.action,e)),Array.isArray(e.config.action)&&e.config.action.length>0?shmi.addClass(e.element,"clickable"):shmi.removeClass(e.element,"clickable");const t={onClick:function(t,i,s){e.fire("click",{x:t,y:i,event:s}),e.vars.action&&e.vars.action.execute()}};e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.element,t)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.element,t))},onEnable:function(){const e=this;e.vars.user.userGroups=shmi.visuals.session.UserManager.currentUser.groupList,e.vars.user.username=shmi.visuals.session.UserManager.currentUser.name,getUser(e),!0===e.config["show-group"]&&function setUserGroup(e){let i=shmi.getUiElement("user-info-group",e.element),s=null,{userGroups:n}=e.vars.user;i?(n=n.filter(e=>0!==e.indexOf("@")),s=n.length>0?n[0]:"Default",i.textContent=s):t('Dom-Element "user-info-group" not found!')}(e),e.vars.listeners.forEach((function(e){e.enable()}))},onDisable:function(){this.vars.listeners.forEach((function(e){e.disable()}))},onLock:function(){this.vars.listeners.forEach((function(e){e.disable()})),shmi.addClass(this.element,"locked")},onUnlock:function(){this.vars.listeners.forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked")}}};shmi.requires("visuals.tools.control-generator").generate(i)}(),function(){"use strict";const e="visuals.controls.iq-user-management",t=shmi.pkg(e),i="iq-add-user-dialog";console.error.bind(console,`[${e}]`),console.warn.bind(console,`[${e}]`),console.log.bind(console,`[${e}]`),console.debug.bind(console,`[${e}]`);function closeDialog(e,t){e.active&&!e.data.isDone&&(e.data.isDone=!0,e.getInstance("dlgBox").hide(),e.data.resolve(t))}const s={onCreateUser:function onCreateUser(e){const{UserApiBinding:t}=shmi.requires("visuals.controls.iq-user-management"),{setLockedSlots:i,setUnlockedSlots:s}=shmi.requires("visuals.controls.iq-user-management.controller-tools");if(!e.active)throw new shmi.LocalizedError("${ui.error.dialogAlreadyClosed}");if("string"!=typeof e.data.formData.inputUsername||0===e.data.formData.inputUsername.length)throw new shmi.LocalizedError("${iq-user-controller.error.usernameMustNotBeEmpty}");if(e.data.formData.inputUsername.startsWith(" ")||e.data.formData.inputUsername.endsWith(" ")||e.data.formData.inputUsername.includes("  "))throw new shmi.LocalizedError("${iq-user-controller.error.usernameInvalid}");if("string"!=typeof e.data.formData.inputPassword||0===e.data.formData.inputPassword.length)throw new shmi.LocalizedError("${iq-user-controller.error.passwordMustNotBeEmpty}");if(e.data.formData.inputPassword!==e.data.formData.inputPasswordRep)throw new shmi.LocalizedError("${V_PASSWORD_REPEAT_NOT_EQUAL}");if(e.data.formData.inputPassword.length<shmi.c("MIN_PASSWORD_LENGTH"))throw new shmi.LocalizedError("${V_PASSWORD_TOO_SHORT}");const n=e.data.formData.inputUsername,a=e.data.formData.inputPassword,l={firstName:e.data.formData.inputFirstName,lastName:e.data.formData.inputLastName,userGroups:e.data.formData.inputUserGroup?[e.data.formData.inputUserGroup]:[],localeId:e.data.formData.inputLocale,passwordValidityDuration:e.data.formData.inputPasswordValidityDuration,autoLogoutDelay:e.data.formData.inputAutoLogoutDelay,description:e.data.formData.inputDescription};return s(e,[]),t.createUser(n,a,l).then(closeDialog.bind(null,e,!0)).catch(t=>{throw i(e,[]),t})},onApplyUser:function onApplyUser(e){const{UserApiBinding:t}=shmi.requires("visuals.controls.iq-user-management"),{setLockedSlots:i,setUnlockedSlots:s}=shmi.requires("visuals.controls.iq-user-management.controller-tools");if(!e.active)throw new shmi.LocalizedError("${ui.error.dialogAlreadyClosed}");if("string"!=typeof e.data.formData.inputUsername||0===e.data.formData.inputUsername.length)throw new shmi.LocalizedError("${iq-user-controller.error.usernameMustNotBeEmpty}");if(e.data.formData.inputUsername.startsWith(" ")||e.data.formData.inputUsername.endsWith(" ")||e.data.formData.inputUsername.includes("  "))throw new shmi.LocalizedError("${iq-user-controller.error.usernameInvalid}");if(e.data.formData.inputPassword!==e.data.formData.inputPasswordRep)throw new shmi.LocalizedError("${iq-user-controller.error.passwordMismatch}");if(void 0!==e.data.formData.inputPassword){if("string"!=typeof e.data.formData.inputPassword||0===e.data.formData.inputPassword.length)throw new shmi.LocalizedError("${iq-user-controller.error.passwordMustNotBeEmpty}");if(e.data.formData.inputPassword.length<shmi.c("MIN_PASSWORD_LENGTH"))throw new shmi.LocalizedError("${V_PASSWORD_TOO_SHORT}")}const n=e.data.formData.inputUsername,a={firstName:e.data.formData.inputFirstName,lastName:e.data.formData.inputLastName,userGroups:e.data.formData.inputUserGroup?[e.data.formData.inputUserGroup]:[],localeId:e.data.formData.inputLocale,password:e.data.formData.inputPassword,passwordValidityDuration:e.data.formData.inputPasswordValidityDuration,autoLogoutDelay:e.data.formData.inputAutoLogoutDelay,description:e.data.formData.inputDescription};return s(e,[]),t.setUser(n,a).then(closeDialog.bind(null,e,!0)).catch(t=>{throw i(e,["inputUsername"]),t})},onClose:function onClose(e){if(!e.active)throw new shmi.LocalizedError("${ui.error.dialogAlreadyClosed}");closeDialog(e)}};function createDialog(e,t,n,a){const l=shmi.getControlByElement(document.body.firstElementChild),{makeControllerDescriptor:o}=shmi.requires("visuals.controls.iq-user-management.controller-tools");l.addControl([{ui:"dialog-box",config:{name:"iq-add-user-dialog",title:t?"${iq-user-controller.title.editUserDialog}":"${iq-user-controller.title.createUserDialog}",template:"default/dialog-box","content-template":null,"class-name":`dialog-box add-or-edit-user ${t?"hide-passwords":""}`,"top-level":!1,_controllers_:[{name:i,slot:"dlgBox"}]},children:[{ui:"container",config:{type:"flex","flex-orientation":"column","class-name":"container full-height"},children:[{ui:"container",config:{type:"flex","flex-orientation":"column","class-name":"container dialog-form-container","auto-margin":!0},children:[{ui:"iq-input-field",config:{"class-name":"iq-input-field iq-variant-02",template:"default/iq-input-field.iq-variant-02",label:"${user_name}","unit-text":null,_controllers_:[{name:i,slot:"inputUsername"}]}},{ui:"iq-input-field",config:{"class-name":"iq-input-field iq-variant-02",template:"default/iq-input-field.iq-variant-02",label:"${iq-user-controller.label.firstName}","unit-text":null,_controllers_:[{name:i,slot:"inputFirstName"}]}},{ui:"iq-input-field",config:{"class-name":"iq-input-field iq-variant-02",template:"default/iq-input-field.iq-variant-02",label:"${iq-user-controller.label.lastName}","unit-text":null,_controllers_:[{name:i,slot:"inputLastName"}]}},{ui:"iq-select-box",config:{"class-name":"iq-select-box iq-variant-02",template:"default/iq-select-box.iq-variant-02",label:"${iq-user-controller.label.userGroup}",_controllers_:[{name:i,slot:"inputUserGroup"}]}},{ui:"iq-select-box",config:{"class-name":"iq-select-box iq-variant-02",template:"default/iq-select-box.iq-variant-02",label:"${iq-user-controller.label.localeId}",options:Object.keys(shmi.visuals.session.localeInfo.locales).map(e=>({value:e,label:e})),value:shmi.visuals.session.localeInfo.default,_controllers_:[{name:i,slot:"inputLocale"}]}},{ui:"container",config:{type:"flex","class-name":"container no-shrink","auto-margin":!0},children:[{ui:"iq-input-field",config:{"class-name":"iq-input-field iq-variant-02 flex-1",template:"default/iq-input-field.iq-variant-02",label:"${iq-user-controller.label.passwordExpiry}","unit-text":null,_controllers_:[{name:i,slot:"inputPasswordValidityDuration"}]}},{ui:"iq-input-field",config:{"class-name":"iq-input-field iq-variant-02 flex-1",template:"default/iq-input-field.iq-variant-02",label:"${iq-user-controller.label.autoLogoutDelay}","unit-text":null,_controllers_:[{name:i,slot:"inputAutoLogoutDelay"}]}}]},{ui:"iq-input-field",config:{"class-name":"iq-input-field iq-variant-05",template:"default/iq-input-field.iq-variant-05",label:"${new_pwd}","unit-text":null,_controllers_:[{name:i,slot:"inputPassword"}]}},{ui:"iq-input-field",config:{"class-name":"iq-input-field iq-variant-05",template:"default/iq-input-field.iq-variant-05",label:"${confirm_new_pwd}","unit-text":null,_controllers_:[{name:i,slot:"inputPasswordRep"}]}},{ui:"iq-input-field",config:{"class-name":"iq-input-field iq-variant-02 textarea",template:"default/iq-input-field.iq-variant-02",label:"${iq-user-controller.label.description}","unit-text":null,multiline:!0,_controllers_:[{name:i,slot:"inputDescription"}]}}]},{ui:"container",config:{"class-name":"container dialog-buttons-container",type:"inline","h-alignment":"right","auto-margin":!0},children:[{ui:"iq-button",config:{"class-name":"iq-button iq-variant-01 primary",label:t?"${iq-user-controller.label.apply}":"${iq-user-controller.label.add}",_controllers_:[{name:i,slot:"btnApply"}]}},{ui:"iq-button",config:{"class-name":"iq-button iq-variant-01",label:"${lbl_cancel}",_controllers_:[{name:i,slot:"btnCancel"}]}}]}]}],controller:o({name:i,slots:{inputUsername:{ui:"iq-input-field",formType:"string"},inputFirstName:{ui:"iq-input-field",formType:"string"},inputLastName:{ui:"iq-input-field",formType:"string"},inputUserGroup:{ui:"iq-select-box",formType:"string"},inputLocale:{ui:"iq-select-box",formType:"string"},inputPasswordValidityDuration:{ui:"iq-input-field",formType:"number"},inputAutoLogoutDelay:{ui:"iq-input-field",formType:"number"},inputPassword:{ui:"iq-input-field",formType:"string"},inputPasswordRep:{ui:"iq-input-field",formType:"string"},inputDescription:{ui:"iq-input-field",formType:"string"},btnApply:{ui:"iq-button",events:{click:t?s.onApplyUser:s.onCreateUser}},btnCancel:{ui:"iq-button",events:{click:s.onClose}},dlgBox:{ui:"dialog-box"}},data:{reject:a,resolve:n,isDone:!1,formData:{}},onEnable:function onEnable(i){const{UserApiBinding:s}=shmi.requires("visuals.controls.iq-user-management"),{setLockedSlots:n,setUnlockedSlots:a,reloadFormValues:l}=shmi.requires("visuals.controls.iq-user-management.controller-tools");a(i,["btnCancel"]);const o=s.listGroups().then(e=>{i.getInstance("inputUserGroup").setOptions([{value:null,label:"---"}].concat(e.usergroups.map(e=>({value:e.groupname,label:e.groupname}))))});Promise.all([o]).then(()=>{e&&(i.data.formData={inputUsername:t?e.username:null,inputFirstName:e.firstName,inputLastName:e.lastName,inputUserGroup:e.userGroups[0]||null,inputLocale:e.localeId,inputPasswordValidityDuration:e.passwordValidityDuration,inputAutoLogoutDelay:e.autoLogoutDelay,inputDescription:e.description},l(i,[],[])),n(i,t?["inputUsername"]:[])})},onDisable:function onDisable(e){e.data.isDone||e.data.resolve(),shmi.deleteControl(e.getInstance("dlgBox"))},onError:function onError(e,t){if("shmi:connect:api:generic"===t.category&&14===t.errc)throw new shmi.LocalizedError("${iq-user-controller.error.invalidParameter}");if("shmi:connect:api:user"===t.category&&4===t.errc)throw new shmi.LocalizedError("${iq-user-controller.error.invalidPasswordExpiryDuration}");throw t}})}],(e,t)=>{e?a(e):t[0].show()})}t.openUserAddEditDialog=function openUserAddEditDialog(e,t){return new Promise(createDialog.bind(null,e,t))}}(),function(){const e="visuals.controls.iq-user-management.controller-tools",t=shmi.pkg(e),i=(console.error.bind(console,`[${e}]`),console.warn.bind(console,`[${e}]`),console.log.bind(console,`[${e}]`),console.debug.bind(console,`[${e}]`),{string:function string(e,t,i){if(!e.active||!e.data.formData)return;const s=null===e.data.formData[t],n=(()=>{const i=e.getInstance(t);return i&&i.locked})(),a=""===i.detail.value?null:i.detail.value;(!s||null!==a&&0!==a.length)&&e.data.formData[t]!==a&&(e.data.formData[t]=a,n||(e.data.hasChanged=!0))},number:function number(e,t,i){if(!e.active||!e.data.formData)return;const s=null===e.data.formData[t],n=(()=>{const i=e.getInstance(t);return i&&i.locked})(),a=(()=>"string"==typeof i.detail.value?""===i.detail.value?null:parseFloat(i.detail.value):i.detail.value)();s&&0===a?e.data.formData[t]=a:e.data.formData[t]!==a&&(e.data.formData[t]=a,n||(e.data.hasChanged=!0))},boolean:function boolean(e,t,i){if(!e.active||!e.data.formData)return;const s=null===e.data.formData[t],n=(()=>{const i=e.getInstance(t);return i&&i.locked})(),a=!!i.detail.value;s&&!a?e.data.formData[t]=a:e.data.formData[t]!==a&&(e.data.formData[t]=a,n||(e.data.hasChanged=!0))}});function setFormWidgetValue(e,i){const s=t.uiFormWidgets[e.uiType],n=t.uiFormWidgets.default;void 0===s?n(e,i):"boolean"==typeof s?s&&n(e,i):s(e,i)}t.uiFormWidgets={"input-field":!0,"iq-input-field":!0,checkbox:(e,t)=>e.setValue(t?1:0),"iq-checkbox":(e,t)=>e.setValue(t?1:0),"select-box":!0,"iq-select-box":!0,default:(e,t)=>e.setValue(t)},t.resetFormValues=function resetFormValues(e,i,s){const n=s||Object.keys(t.uiFormWidgets);e.data.formData=i||{},Object.keys(e.slots).forEach(t=>{const i=e.getInstance(t);i&&(n.includes(i.uiType)?(i.setValue(null),e.data.formData[t]=null):e.data.formData[t]&&i.setValue(e.data.formData[t]))})},t.reloadFormValues=function reloadFormValues(e,i,s){const n=Object.keys(t.uiFormWidgets).concat(s||[]);Object.keys(e.slots).forEach(t=>{const s=e.getInstance(t);s&&-1!==n.indexOf(s.uiType)&&-1===(i||[]).indexOf(t)&&(void 0===e.data.formData[t]?setFormWidgetValue(s,null):setFormWidgetValue(s,e.data.formData[t]))})},t.addons=t.addons||[],t.addons.push({configName:"formType",addonFunc:e=>({change:i[e]})})}(),function(){"use strict";const e="visuals.controls.iq-user-management.controller-tools",t=shmi.pkg(e),i={error:console.error.bind(console,`[${e}]`),warn:console.warn.bind(console,`[${e}]`),log:console.log.bind(console,`[${e}]`),debug:console.debug.bind(console,`[${e}]`)};function defaultErrorHandler(e,t){const s=function getErrorTexts(e){const t={title:"${V_ERROR}",messageApi:"${visuals.error.api}",messageUnknown:"${visuals.error.unknown}"};return e.data&&e.data.messages?{title:e.data.messages.errorTitle||t.title,messageApi:e.data.messages.errorApi||t.messageApi,messageUnknown:e.data.messages.errorUnknown||t.messageUnknown}:t}(e);i.error(t),t.localizedMessage?shmi.notify(t.localizedMessage,s.title):!t.message&&t.apiError?shmi.notify(s.messageApi,s.title,{ERROR_CODE:t.apiError.errc,ERROR_MSG:t.apiError.message,ERROR_CAT:t.apiError.category}):shmi.notify(t.message||s.messageUnknown,s.title)}function controllerEventHandler(e,t,i,s,n,a,l){let o;if(s.data.ignoreEvents)o=Promise.resolve();else{const i=function getSlotCallback(e,t,i){return"object"!=typeof e?null:"object"!=typeof e[t]?null:"function"!=typeof e[t][i]?null:e[t][i]}(e,a,n);o=i?Promise.resolve().then(i.bind(null,s,n,l)):t?Promise.resolve():Promise.reject(new Error(`BUG: Event handler for ${a}@${n} not implemented.`))}i&&(o=o.catch(i.bind(void 0,s))),o.catch(defaultErrorHandler.bind(void 0,s))}t.makeControllerDescriptor=function makeControllerDescriptor(e){const i=function collectAndTranslateEventHandlers(e){const i=shmi.requires("shmi.visuals.tools.iterate.iterateObject"),s={};return i(e,(e,n)=>{Array.isArray(e.events)||(i(e.events||{},(e,t)=>{shmi.objectHasOwnProperty(s,t)||(s[t]={}),s[t][n]=e}),e.events=Object.keys(e.events||{}),(t.addons||[]).forEach(({configName:t,addonFunc:a})=>{if(shmi.objectHasOwnProperty(e,t)){const l=a(e[t],n,e);i(l||{},(t,i)=>{s[i]||(s[i]={});const a=s[i][n];s[i][n]=a?(...e)=>Promise.resolve().then(t.bind(void 0,...e)).then(a.bind(void 0,...e)):t,e.events.includes(i)||e.events.push(i)})}}),new Set((t.addons||[]).map(({configName:e})=>e)).forEach(t=>delete e[t]))}),s}(e.slots||{}),s=e.onEvent,n=e.onError;return e.onEvent=s?function onEvent(...e){s(...e),controllerEventHandler(i,!0,n,...e)}:controllerEventHandler.bind(void 0,i,!1,n),delete e.onError,e},t.openConfirmBox=function openConfirmBox(e,t,i){return new Promise(s=>{shmi.confirm(e,s,t,i)})}}(),function(){const e=shmi.pkg("visuals.controls.iq-user-management.controller-tools");e.unlockSlots=function unlockSlots(e,t){e.active&&t.forEach((function(t){const i=e.getInstance(t);i&&i.unlock()}))},e.lockSlots=function lockSlots(e,t){e.active&&t.forEach((function(t){const i=e.getInstance(t);i&&i.lock()}))},e.setUnlockedSlots=function setUnlockedSlots(e,t){e.active&&Object.keys(e.slots).forEach((function(i){const s=e.getInstance(i);s&&(-1===t.indexOf(i)?s.lock():s.unlock())}))},e.setLockedSlots=function setLockedSlots(e,t){e.active&&Object.keys(e.slots).forEach((function(i){const s=e.getInstance(i);s&&(-1===t.indexOf(i)?s.unlock():s.lock())}))},e.lockAllSlots=function lockAllSlots(t,i){e.lockSlots(t,Object.keys(t.slots).filter(e=>-1===(i||[]).indexOf(e)))},e.unlockAllSlots=function unlockAllSlots(t,i){e.unlockSlots(t,Object.keys(t.slots).filter(e=>-1===(i||[]).indexOf(e)))},e.delay=function delay(e){return new Promise(t=>setTimeout(t,e))}}(),function(){const e=shmi.pkg("visuals.controls.iq-user-management"),t={error:console.error.bind(console,"[DataGridUser]"),warn:console.warn.bind(console,"[DataGridUser]"),log:console.log.bind(console,"[DataGridUser]"),debug:console.debug.bind(console,"[DataGridUser]")};let i=1;function makeRowDataFromUser(e){return shmi.checkArg("user",e,"User"),[{type:shmi.c("TYPE_STRING"),value:e.username,min:Number.NaN,max:Number.NaN},{type:shmi.c("TYPE_STRING"),value:e.firstName,min:Number.NaN,max:Number.NaN},{type:shmi.c("TYPE_STRING"),value:e.lastName,min:Number.NaN,max:Number.NaN},{type:shmi.c("TYPE_STRING"),value:e.localeId,min:Number.NaN,max:Number.NaN},{type:shmi.c("TYPE_INT"),value:e.passwordValidityDuration,min:Number.NaN,max:Number.NaN},{type:shmi.c("TYPE_INT"),value:e.passwordTimestamp?e.passwordTimestamp.getTime():null,min:Number.NaN,max:Number.NaN},{type:shmi.c("TYPE_STRING"),value:e.userGroups.join(", "),min:Number.NaN,max:Number.NaN},{type:shmi.c("TYPE_INT"),value:null===e.autoLogoutDelay?-1:e.autoLogoutDelay,min:Number.NaN,max:Number.NaN},{type:shmi.c("TYPE_BOOLEAN"),value:e.deactivated,min:Number.NaN,max:Number.NaN},{type:shmi.c("TYPE_STRING"),value:e.description,min:Number.NaN,max:Number.NaN},{type:shmi.c("TYPE_STRING"),value:String.fromCodePoint(9679+118170*Math.floor(Math.random()+.001)).repeat(5),min:Number.NaN,max:Number.NaN}]}function makeRow(e,t,i){const s=shmi.visuals.session.ItemManager;shmi.checkArg("self",e,"DataGridUser"),shmi.checkArg("rowId",t,"number"),shmi.checkArg("rowData",i,"array"),e.totalRows++,e.data[t]=i,i.forEach((function(e,i){const n=this.prefix+t+":"+i,a=s.getItem(n);a&&a.initialized?(e.item=a,e.item.writable=!0,e.item.writeValue(e.value)):(e.item=shmi.createVirtualItem(n,e.type,e.min,e.max,e.value,function(e,t,i,s,n){const a=this.getRowData(e);a&&a[t]&&(a[t].value=i)}.bind(this,t,i)),e.item.setDataGridInfo(this.name,t,i)),e.item.writable=!1}),e)}function calcState(e,t){return shmi.checkArg("self",e,"DataGridUser"),shmi.checkArg("subID",t,"object"),t?{status:"OK",offset:t.offset,size:t.size,totalRows:e.totalRows}:{status:"FAILED",totalRows:e.totalRows||0}}function delayedRefresh(e){shmi.checkArg("self",e,"DataGridUser"),null!==e.refreshTimeout&&clearTimeout(e.refreshTimeout),e.refreshTimeout=setTimeout(e.refresh.bind(e),shmi.c("ACTION_RETRY_TIMEOUT"))}function doRefreshSubscriber(e,t){shmi.checkArg("self",e,"DataGridUser"),shmi.checkArg("sub",t,"object"),t.onChange(calcState(e,t))}function translateColumnName(e){return{firstName:"first_name",lastName:"last_name",localeId:"locale_id",passwordValidityDuration:"password_expiry_duration",passwordTimestamp:"password_timestamp",autoLogoutDelay:"auto_logout_duration"}[e]||e}function buildFilterExpression(e){return shmi.checkArg("self",e,"DataGridUser"),{mode:e.filterChaining,clauses:e.getFilters().map((t,i)=>null===t?null:{location:"property",mode:"OR",column:translateColumnName(e.getFields()[i]),clauses:t.map(e=>({operator:"like",value:e}))}).filter(e=>null!==e)}}function buildSortExpression(e){return shmi.checkArg("self",e,"DataGridUser"),null===e.order?[]:[{column:translateColumnName(e.getFields()[e.order[0]]),order:e.order[1]}]}function taskDelete(e,t){shmi.checkArg("self",e,"DataGridUser"),shmi.checkArg("task",t,"object");const i=e.rowObjectData[t.rowID];return i?i.delete():Promise.reject(new Error(`No row for rowID ${t.rowId}`))}function taskFetchAll(e){shmi.checkArg("self",e,"DataGridUser");const{UserApiBinding:t}=shmi.requires("visuals.controls.iq-user-management"),{iterateObject:i}=shmi.requires("visuals.tools.iterate"),s=function calculateRequestRanges(e){const t=[];return shmi.checkArg("self",e,"DataGridUser"),Object.values(e.subscribers).sort((e,t)=>t.offset-e.offset).forEach((function(e,i){if(0===i)return void t.push({begin:e.offset,end:e.offset+e.size});const s=t[t.length-1];s.end<e.offset?t.push({begin:e.offset,end:e.offset+e.size}):s.end<e.offset+e.size&&(e.end=e.offset+e.size)})),t}(e).map(i=>t.listUsers({filter:buildFilterExpression(e),sort:buildSortExpression(e),offset:i.begin,limit:i.end-i.begin}).then(t=>{t.users.forEach((function(t,s){e.rowObjectData[i.begin+s]=t,makeRow(e,i.begin+s,makeRowDataFromUser(t))}))}));return Promise.all(s).then(()=>i(e.subscribers,doRefreshSubscriber.bind(null,e)))}function taskLoad(e,t){shmi.checkArg("self",e,"DataGridUser"),shmi.checkArg("task",t,"object");const{UserApiBinding:i}=shmi.requires("visuals.controls.iq-user-management"),{iterateObject:s}=shmi.requires("visuals.tools.iterate");return i.listUsers({filter:buildFilterExpression(e),sort:buildSortExpression(e),offset:t.offset,limit:t.size}).then(i=>{i.users.forEach((function(i,s){e.rowObjectData[t.offset+s]=i,makeRow(e,t.offset+s,makeRowDataFromUser(i))})),s(e.subscribers,doRefreshSubscriber.bind(null,e))})}e.DataGridUser=class DataGridUser{constructor(e){const{TaskExecutor:t}=shmi.requires("visuals.controls.iq-user-management");Object.defineProperties(this,{name:{value:e,writable:!1},type:{value:"User",writable:!1},prefix:{value:`virtual:grid:${e}:`,writable:!1},data:{value:{},writable:!0},rowObjectData:{value:{},writable:!0},subscribers:{value:{},writable:!0},nextRowID:{value:0,writable:!0},totalRows:{value:0,writable:!0},order:{value:null,writable:!0},filter:{value:{},writable:!0},filterChaining:{value:"AND",writable:!0},executor:{value:new t,writable:!1},refreshTimeout:{value:null,writable:!0}}),this.executor.registerNamed("delete",taskDelete.bind(null,this)),this.executor.registerNamed("fetch_all",taskFetchAll.bind(null,this)),this.executor.registerNamed("load",taskLoad.bind(null,this))}init(){this.taskQueue=[],this.subscribers={}}subscribePage(e,t,s){shmi.checkArg("offset",e,"number"),shmi.checkArg("size",t,"number"),shmi.checkArg("onChange",s,"function");const n={id:i++,offset:e,size:t,onChange:s};return this.subscribers[n.id]=n,this.executor.postNamed("load",!1,{offset:e,size:t}),{id:n.id,prefix:this.prefix}}getFields(){return["username","firstName","lastName","localeId","passwordValidityDuration","passwordTimestamp","userGroups","autoLogoutDelay","deactivated","description","fakePassword"]}getIndexFields(){return[0]}getRowIndex(e){shmi.checkArg("rowId",e,"number");const t=this.getRowData(e);return t?this.getIndexFields().map((function(e){return t[e].value})):null}searchIndexRowId(e){const t=this.getIndexFields();let i=-1;return shmi.checkArg("rowIndex",e,"array"),Object.keys(this.data).map(e=>parseInt(e)).some(s=>!!this.searchIndexFields(s,t,e)&&(i=s,!0)),i}searchIndexFields(e,t,i){return shmi.checkArg("row",e,"number"),shmi.checkArg("fields",t,"array"),shmi.checkArg("rowIndex",i,"array"),t.length>0&&this.data[e].every((e,t)=>e.value===i[t])}insertRow(e,t){const i=shmi.requires("visuals.tools.iterate").iterateObject,s=this.nextRowID++;return shmi.checkArg("rowData",e,"array"),makeRow(this,s,e),t||i(this.subscribers,e=>{e.onChange(calcState(this,e))}),s}deleteRow(e){shmi.checkArg("rowID",e,"number","array"),(Array.isArray(e)?e:[e]).forEach(e=>{this.executor.postNamed("delete",!1,{rowID:parseInt(e)})}),this.executor.postNamed("fetch_all",!0)}deleteAll(){this.deleteRow(Object.keys(this.rowObjectData))}unsubscribe(e){const t=shmi.requires("visuals.session.ItemManager"),i=shmi.requires("visuals.tools.iterate.iterateObject");shmi.checkArg("subID",e,"number"),delete this.subscribers[e],0===Object.keys(this.subscribers).length&&(i(this.data,e=>{e.forEach(e=>t.removeItem(e.item.name))}),this.data={},this.rowObjectData={})}setOffset(e,t){shmi.checkArg("offset",e,"number"),shmi.checkArg("subID",t,"number"),void 0!==this.subscribers[t]&&(this.subscribers[t].offset=e,this.executor.postNamed("load",!1,{subID:t}))}getRowCount(){return this.totalRows}setFilter(e,t){this.filter[this.getFields()[e]]=t,delayedRefresh(this)}setFilterChaining(e){shmi.checkArg("chaining",e,"string"),"OR"===e||"AND"===e?(this.filterChaining=e,delayedRefresh(this)):t.error("Invalid filter chaining mode:",e)}getFilters(){return this.getFields().map(e=>shmi.objectHasOwnProperty(this.filter,e)?this.filter[e]:null)}refresh(){const{iterateObject:e}=shmi.requires("visuals.tools.iterate");e(this.subscribers,(function(e){e.offset=0})),this.data={},this.rowObjectData={},this.totalRows=0,this.executor.postNamed("fetch_all",!0)}clearFilter(e){let t=!1;shmi.checkArg("col",e,"number"),-1===e?(t=Object.keys(this.filter).length>0,this.filter={}):void 0!==this.filter[this.getFields()[e]]&&(delete this.filter[this.getFields()[e]],t=!0),t&&delayedRefresh(this)}sort(e,t){const i=this.order;shmi.checkArg("col",e,"number"),shmi.checkArg("col",t,"string"),this.order=-1===e?null:[e,t],this.order!==i&&delayedRefresh(this)}getCurrentIDs(e){shmi.checkArg("subID",e,"number");const t=this.subscribers[e];return void 0===t?[]:Object.keys(this.data).map(e=>parseInt(e)).filter(e=>t.offset<=e&&e<t.offset+t.size)}getAllIDs(){return Object.keys(this.data)}getRowData(e){return shmi.checkArg("rowId",e,"number"),void 0!==this.data[e]?this.data[e]:null}}}(),function(){"use strict";const e="IqUserController",t="iq-user-controller",i={"class-name":t,name:null,template:"default/iq-user-controller.iq-variant-01","user-select":null,"button-order":["add","edit","clone","remove","expirepw","setpw"],"button-usage":{add:!0,clone:!0,edit:!0,remove:!0,expirepw:!0,setpw:!0}},s={error:console.error.bind(console,`[${e}]`),warn:console.warn.bind(console,`[${e}]`),log:console.log.bind(console,`[${e}]`),debug:console.debug.bind(console,`[${e}]`)};function defaultErrorHandler(e){const t="${V_ERROR}",i="${visuals.error.api}",n="${visuals.error.unknown}";s.error(e),e.localizedMessage?shmi.notify(e.localizedMessage,t):!e.message&&e.apiError?shmi.notify(i,t,{ERROR_CODE:e.apiError.errc,ERROR_MSG:e.apiError.message,ERROR_CAT:e.apiError.category}):shmi.notify(e.message||n,t)}const n={onAdd:function onAdd(e){const{openUserAddEditDialog:t}=shmi.requires("visuals.controls.iq-user-management");t().catch(defaultErrorHandler).finally(refreshSelectionControl.bind(null,e))},onClone:function onClone(e){const{openUserAddEditDialog:t}=shmi.requires("visuals.controls.iq-user-management"),{UserApiBinding:i}=shmi.requires("visuals.controls.iq-user-management"),s=e.vars.select.selection;s&&i.getUser(s).then(e=>t(e)).catch(defaultErrorHandler).finally(refreshSelectionControl.bind(null,e))},onEdit:function onEdit(e){const{openUserAddEditDialog:t}=shmi.requires("visuals.controls.iq-user-management"),{UserApiBinding:i}=shmi.requires("visuals.controls.iq-user-management"),s=e.vars.select.selection;s&&i.getUser(s).then(e=>t(e,!0)).catch(defaultErrorHandler).finally(refreshSelectionControl.bind(null,e))},onRemove:function onRemove(e){const{UserApiBinding:t}=shmi.requires("visuals.controls.iq-user-management"),{openConfirmBox:i}=shmi.requires("visuals.controls.iq-user-management.controller-tools"),s=e.vars.select.selection;s&&i(shmi.evalString(shmi.localize("${iq-user-controller.confirm.delete}"),{USERNAME:s}),"${iq-user-controller.title.confirmDelete}").then(e=>e?t.deleteUser(s):Promise.resolve()).catch(defaultErrorHandler).finally(refreshSelectionControl.bind(null,e))},onForceExpire:function onForceExpire(e){const{UserApiBinding:t}=shmi.requires("visuals.controls.iq-user-management"),{openConfirmBox:i}=shmi.requires("visuals.controls.iq-user-management.controller-tools"),s=e.vars.select.selection;s&&i(shmi.evalString(shmi.localize("${iq-user-controller.confirm.expire}"),{USERNAME:s}),"${iq-user-controller.title.confirmExpire}").then(e=>e?t.setUser(s,{passwordForceExpired:!0}):Promise.resolve()).catch(defaultErrorHandler).finally(refreshSelectionControl.bind(null,e))},onSetPassword:function onSetPassword(e){const{openSetPasswordDialog:t}=shmi.requires("visuals.controls.iq-user-management"),i=e.vars.select.selection;i&&t(i).catch(defaultErrorHandler).finally(refreshSelectionControl.bind(null,e))}};function nameOrNodeHandleMatches(e,t){const{HANDLE_PREFIX:i,getNodeHandle:s}=shmi.requires("visuals.tools.nodes");return"string"==typeof e&&e.startsWith(i)?s(t)===e.replace(i,""):e===t.getName()}function attachUserSelectListeners(e){function onSelectEnableHandler(t){nameOrNodeHandleMatches(e.config["user-select"],t.source)&&onSelectEnable(e,t.source)}function onSelectDisableHandler(t){nameOrNodeHandleMatches(e.config["user-select"],t.source)&&function onSelectDisable(e,t){e.vars.select.control=null,e.vars.select.changeToken&&(e.vars.select.changeToken.unlisten(),e.vars.select.changeToken=null);setSelection(e,null)}(e,t.source)}e.vars.tokens.push(shmi.listen("enable",onSelectEnableHandler,{"source.uiType":"iq-user-select"})),e.vars.tokens.push(shmi.listen("enable",onSelectEnableHandler,{"source.uiType":"iq-user-list"})),e.vars.tokens.push(shmi.listen("disable",onSelectDisableHandler,{"source.uiType":"iq-user-select"})),e.vars.tokens.push(shmi.listen("disable",onSelectDisableHandler,{"source.uiType":"iq-user-list"}))}function updateButtonState(e){const t=Object.values(e.vars.buttons).filter(e=>null!==e),i=e.vars.select.selection;e.locked?t.forEach(e=>e.lock()):i?t.forEach(e=>e.unlock()):t.forEach(t=>{t===e.vars.buttons.add?t.unlock():t.lock()})}function toIqButtonVariant(e){let i=e.replace(t,"iq-button");const s=i.match(/iq-variant-(\d+)/);if(s){const e=parseInt(s[1]);i=i.replace(s[0],`iq-variant-0${1+(1+e)%2}`)}return i}function refreshSelectionControl(e){e.vars.select.control&&(e.vars.select.control.refresh(),e.vars.select.control.setValue(null))}function setSelection(e,t){e.vars.select.selection=t||null,updateButtonState(e)}function onSelectEnable(e,t){e.vars.select.control=t,t.getCurrentUser?setSelection(e,t.getCurrentUser()):s.error("user-select does not implement required interface"),e.vars.select.changeToken&&(e.vars.select.changeToken.unlisten(),e.vars.select.changeToken=null),e.vars.select.changeToken=t.listen("change",t=>{setSelection(e,t.detail.value)})}const a={className:e,uiType:t,isContainer:!0,config:i,configSchema:null,vars:{domContainer:null,buttons:{add:null,edit:null,remove:null,clone:null,expirepw:null,setpw:null},select:{control:null,changeToken:null,selection:null},tokens:[]},imports:{},events:[],prototypeExtensions:{onInit:function(){const e=this.vars.buttons,t={add:{name:"add-user",label:"${iq-user-controller.label.add}",icon:"pics/system/controls/iq-user-controller/add-dark.svg"},edit:{name:"edit-user",label:"${iq-user-controller.label.edit}",icon:"pics/system/controls/iq-user-controller/edit-dark.svg"},remove:{name:"remove-user",label:"${iq-user-controller.label.remove}",icon:"pics/system/controls/iq-user-controller/remove-dark.svg"},clone:{name:"clone-user",label:"${iq-user-controller.label.clone}",icon:"pics/system/controls/iq-user-controller/clone-dark.svg"},expirepw:{name:"expirepw-user",label:"${iq-user-controller.label.expirepw}",icon:"pics/system/controls/iq-user-controller/reset-dark.svg"},setpw:{name:"setpw-user",label:"${iq-user-controller.label.setpw}",icon:"pics/system/controls/iq-user-controller/password-dark.svg"}};this.vars.domContainer=shmi.getUiElement("button-container",this.element),Array.isArray(this.config["button-order"])&&this.config["button-order"].forEach(i=>{if(null===e[i]&&t[i]){const{name:s,label:n,icon:a}=t[i];e[i]=function createControllerButton(e,t,i,s,n){const a={name:t,label:i,"icon-title":null,"class-name":`${toIqButtonVariant(e.config["class-name"])} ${t}`,template:toIqButtonVariant(e.config.template),"icon-src":s,tooltip:i,"show-icon":!0,"show-text":!0};return e.config["button-usage"]&&!0!==e.config["button-usage"][n]?null:shmi.createControl("iq-button",e.vars.domContainer||e.element,a,"DIV")}(this,s,n,a,i)}})},onEnable:function(){if(this.controls.forEach(e=>e.enable()),function attachButtonListeners(e){e.vars.buttons.add&&e.vars.tokens.push(e.vars.buttons.add.listen("click",n.onAdd.bind(null,e))),e.vars.buttons.clone&&e.vars.tokens.push(e.vars.buttons.clone.listen("click",n.onClone.bind(null,e))),e.vars.buttons.edit&&e.vars.tokens.push(e.vars.buttons.edit.listen("click",n.onEdit.bind(null,e))),e.vars.buttons.remove&&e.vars.tokens.push(e.vars.buttons.remove.listen("click",n.onRemove.bind(null,e))),e.vars.buttons.expirepw&&e.vars.tokens.push(e.vars.buttons.expirepw.listen("click",n.onForceExpire.bind(null,e))),e.vars.buttons.setpw&&e.vars.tokens.push(e.vars.buttons.setpw.listen("click",n.onSetPassword.bind(null,e)))}(this),null===this.config["user-select"])updateButtonState(this);else{const e=shmi.ctrl(this.config["user-select"]);e&&e.isActive()?onSelectEnable(this,e):updateButtonState(this),attachUserSelectListeners(this)}},onDisable:function(){this.controls.forEach(e=>e.disable()),this.vars.tokens.forEach(e=>e.unlisten()),this.vars.tokens=[],this.vars.select.changeToken&&(this.vars.select.changeToken.unlisten(),this.vars.select.changeToken=null)},onDelete:function(){},onLock:function(){this.controls.forEach(e=>e.lock())},onUnlock:function(){this.controls.forEach(e=>e.unlock())}}};shmi.requires("visuals.tools.control-generator").generate(a)}(),function(){"use strict";const e="visuals.controls.iq-user-management",t=shmi.pkg(e),i="iq-set-password-dialog";console.error.bind(console,`[${e}]`),console.warn.bind(console,`[${e}]`),console.log.bind(console,`[${e}]`),console.debug.bind(console,`[${e}]`);function closeDialog(e,t){e.active&&!e.data.isDone&&(e.data.isDone=!0,e.getInstance("dlgBox").hide(),e.data.resolve(t))}const s={onSetPassword:function onSetPassword(e){const{UserApiBinding:t}=shmi.requires("visuals.controls.iq-user-management"),{setLockedSlots:i,setUnlockedSlots:s}=shmi.requires("visuals.controls.iq-user-management.controller-tools");if(!e.active)throw new shmi.LocalizedError("${ui.error.dialogAlreadyClosed}");if("string"!=typeof e.data.formData.inputPassword||0===e.data.formData.inputPassword.length)throw new shmi.LocalizedError("${iq-user-controller.error.passwordMustNotBeEmpty}");if(e.data.formData.inputPassword!==e.data.formData.inputPasswordRep)throw new shmi.LocalizedError("${V_PASSWORD_REPEAT_NOT_EQUAL}");if(e.data.formData.inputPassword.length<shmi.c("MIN_PASSWORD_LENGTH"))throw new shmi.LocalizedError("${V_PASSWORD_TOO_SHORT}");const n=e.data.username,a=e.data.formData.inputPassword;return s(e,[]),t.setUser(n,{password:a}).then(closeDialog.bind(null,e,!0)).catch(t=>{throw i(e,[]),t})},onClose:function onClose(e){if(!e.active)throw new shmi.LocalizedError("${ui.error.dialogAlreadyClosed}");closeDialog(e)}};function createDialog(e,t,n){const a=shmi.getControlByElement(document.body.firstElementChild),{makeControllerDescriptor:l}=shmi.requires("visuals.controls.iq-user-management.controller-tools");a.addControl([{ui:"dialog-box",config:{name:"iq-change-user-password",title:shmi.evalString(shmi.localize("${iq-user-controller.title.setPasswordDialog}"),{USERNAME:e}),template:"default/dialog-box","content-template":null,"class-name":"dialog-box change-user-password","top-level":!1,_controllers_:[{name:i,slot:"dlgBox"}]},children:[{ui:"container",config:{type:"flex","flex-orientation":"column","class-name":"container full-height"},children:[{ui:"container",config:{type:"flex","flex-orientation":"column","class-name":"container dialog-form-container","auto-margin":!0},children:[{ui:"iq-input-field",config:{"class-name":"iq-input-field iq-variant-05",template:"default/iq-input-field.iq-variant-05",label:"${new_pwd}","unit-text":null,_controllers_:[{name:i,slot:"inputPassword"}]}},{ui:"iq-input-field",config:{"class-name":"iq-input-field iq-variant-05",template:"default/iq-input-field.iq-variant-05",label:"${confirm_new_pwd}","unit-text":null,_controllers_:[{name:i,slot:"inputPasswordRep"}]}}]},{ui:"container",config:{"class-name":"container dialog-buttons-container",type:"inline","h-alignment":"right","auto-margin":!0},children:[{ui:"iq-button",config:{"class-name":"iq-button iq-variant-01 primary",label:"${iq-user-controller.label.setPassword}",_controllers_:[{name:i,slot:"btnApply"}]}},{ui:"iq-button",config:{"class-name":"iq-button iq-variant-01",label:"${lbl_cancel}",_controllers_:[{name:i,slot:"btnCancel"}]}}]}]}],controller:l({name:i,slots:{inputPassword:{ui:"iq-input-field",formType:"string"},inputPasswordRep:{ui:"iq-input-field",formType:"string"},btnApply:{ui:"iq-button",events:{click:s.onSetPassword}},btnCancel:{ui:"iq-button",events:{click:s.onClose}},dlgBox:{ui:"dialog-box"}},data:{reject:n,resolve:t,isDone:!1,username:e,formData:{}},onEnable:function onEnable(e){},onDisable:function onDisable(e){e.data.isDone||e.data.resolve(),shmi.deleteControl(e.getInstance("dlgBox"))}})}],(e,t)=>{e?n(e):t[0].show()})}t.openSetPasswordDialog=function openSetPasswordDialog(e){return new Promise(createDialog.bind(null,e))}}(),function(){const e=shmi.pkg("visuals.controls.iq-user-management"),t={error:console.error.bind(console,"[UserApiBinding]"),warn:console.warn.bind(console,"[UserApiBinding]"),log:console.log.bind(console,"[UserApiBinding]"),debug:console.debug.bind(console,"[UserApiBinding]")};function onTaskDone(e,i){shmi.checkArg("self",e,"TaskExecutor"),shmi.checkArg("err",i,"object","null"),i?t.error("Task command failed",i):0===e.tasksRunning&&t.warn("tasksRunning is 0 but there are still tasks running"),0==--e.tasksRunning&&(e.tasksJoin=!1,processTaskQueue(e))}function executeTask(e,t){shmi.checkArg("self",e,"TaskExecutor"),shmi.checkArg("task",t,"object"),e.tasksRunning++,t.serialized&&(e.tasksJoin=!0),Promise.resolve().then(()=>t.executor.apply(void 0,t.data)).then(onTaskDone.bind(null,e,null)).catch(onTaskDone.bind(null,e))}function processTaskQueue(e){shmi.checkArg("self",e,"TaskExecutor"),function getTasks(e,t){var i,s=[];return shmi.checkArg("self",e,"TaskExecutor"),shmi.checkArg("popSerialized",t,"boolean","undefined"),0===e.taskQueue.length?[]:((i=e.taskQueue.some((function(t,i){return t.serialized&&(s=e.taskQueue.splice(0,i)),!!t.serialized})))?i&&t&&s.push(e.taskQueue.shift()):(s=e.taskQueue,e.taskQueue=[]),s)}(e,!this.tasksJoin).forEach(executeTask.bind(null,e))}e.TaskExecutor=class TaskExecutor{constructor(){Object.defineProperties(this,{taskQueue:{value:[],writable:!0},tasksRunning:{value:0,writable:!0},tasksJoin:{value:!1,writable:!0},taskMap:{value:{},writable:!0}})}registerNamed(e,t){shmi.checkArg("name",e,"string"),shmi.checkArg("taskFunc",t,"function"),this.taskMap[e]=t}postNamed(e,t,...i){if(shmi.checkArg("name",e,"string"),shmi.checkArg("isSerialized",t,"boolean","undefined"),!shmi.objectHasOwnProperty(this.taskMap,e))throw new Error(`Named task ${e} does not exist.`);this.post(this.taskMap[e],t,...i)}post(e,t,...i){shmi.checkArg("taskFunc",e,"function"),shmi.checkArg("isSerialized",t,"boolean","undefined"),this.taskQueue.push({executor:e,serialized:t,data:[...i]}),processTaskQueue(this)}}}(),function(){const e=shmi.pkg("visuals.controls.iq-user-management");console.error.bind(console,"[User]"),console.warn.bind(console,"[User]"),console.log.bind(console,"[User]"),console.debug.bind(console,"[User]");e.User=class User{constructor(e){const t={},{iterateObject:i}=shmi.visuals.tools.iterate;i(e||{},(e,i)=>t[i]=e),Object.defineProperty(this,"_userdata",{value:t,writable:!1,enumerable:!1,configurable:!0})}setProperties(e){const{ConnectSession:t}=shmi.visuals.session,{iterateObject:i}=shmi.visuals.tools.iterate,s=User.translateInternal2Api(e);return s.username=this.username,t.requestPromise("user.set",s).then(()=>i(s,(e,t)=>this._userdata[t]=e))}delete(){const{ConnectSession:e}=shmi.visuals.session;return e.requestPromise("user.del",this.username)}getUserData(e,t){return shmi.checkArg("key",e,"string"),shmi.checkArg("lookupIn",t,"string","array","undefined"),void 0===t?t=["user","group"]:"string"==typeof t&&(t=[t]),t.includes("user")&&shmi.objectHasOwnProperty(this._userdata.data,e)?this._userdata.data[e]:t.includes("group")&&shmi.objectHasOwnProperty(this._userdata.group_data,e)?this._userdata.group_data[e]:null}static translateInternal2Api(e){return{username:e.username,auto_logout_duration:e.autoLogoutDelay,comment:e.description,first_name:e.firstName,last_name:e.lastName,locale_id:e.localeId,password:e.password,password_expiry_duration:e.passwordValidityDuration,password_force_expired:e.passwordForceExpired,groups:e.userGroups,disabled:e.deactivated,data:e.userData,group_data:e.groupData}}get autoLogoutDelay(){return this._userdata.auto_logout_duration}get username(){return this._userdata.username}get firstName(){return this._userdata.first_name}get lastName(){return this._userdata.last_name}get localeId(){return this._userdata.locale_id}get passwordValidityDuration(){return this._userdata.password_expiry_duration}get passwordIsExpired(){return!!this._userdata.password_is_expired}get passwordTimestamp(){return null===this._userdata.password_timestamp?null:new Date(this._userdata.password_timestamp/1e4)}get userGroups(){return(this._userdata.groups||[]).slice()}get deactivated(){return this._userdata.disabled}get description(){return this._userdata.comment}}}(),function(){const e=shmi.pkg("visuals.controls.iq-user-management");console.error.bind(console,"[UserApiBinding]"),console.warn.bind(console,"[UserApiBinding]"),console.log.bind(console,"[UserApiBinding]"),console.debug.bind(console,"[UserApiBinding]");e.UserApiBinding=class UserApiBinding{static listUsers(e){const{ConnectSession:t}=shmi.visuals.session,{User:i}=shmi.requires("shmi.visuals.controls.iq-user-management");return shmi.checkArg("filterOptions",e,"object","null","undefined"),t.requestPromise("user.list",e||{}).then(e=>(e.users=e.users.map(e=>new i(e)),e))}static listGroups(e){const{ConnectSession:t}=shmi.visuals.session,{UserGroup:i}=shmi.requires("shmi.visuals.controls.iq-user-management");return shmi.checkArg("filterOptions",e,"object","null","undefined"),t.requestPromise("usergroup.list",e||{}).then(e=>(e.usergroups=e.usergroups.map(e=>new i(e)),e))}static getUser(e){const{ConnectSession:t}=shmi.visuals.session,{User:i}=shmi.requires("shmi.visuals.controls.iq-user-management");return shmi.checkArg("username",e,"string"),t.requestPromise("user.get",e).then(e=>new i(e))}static createUser(e,t,i){const{ConnectSession:s}=shmi.visuals.session,{User:n}=shmi.requires("shmi.visuals.controls.iq-user-management"),a=n.translateInternal2Api(i||{});return a.username=e,a.password=t,s.requestPromise("user.add",a).then(()=>new n(e,a))}static setUser(e,t){const{ConnectSession:i}=shmi.visuals.session,{User:s}=shmi.requires("shmi.visuals.controls.iq-user-management"),n=s.translateInternal2Api(t);return n.username=e,i.requestPromise("user.set",n)}static deleteUser(e){const{ConnectSession:t}=shmi.visuals.session;return shmi.checkArg("username",e,"string"),t.requestPromise("user.del",e)}}}(),function(){const e=shmi.pkg("visuals.controls.iq-user-management");console.error.bind(console,"[UserGroup]"),console.warn.bind(console,"[UserGroup]"),console.log.bind(console,"[UserGroup]"),console.debug.bind(console,"[UserGroup]");e.UserGroup=class UserGroup{constructor(e){const t={},{iterateObject:i}=shmi.visuals.tools.iterate;i(e||{},(e,i)=>t[i]=e),Object.defineProperty(this,"_groupdata",{value:t,writable:!1,enumerable:!1,configurable:!0})}setProperties(e){const{ConnectSession:t}=shmi.visuals.session,{iterateObject:i}=shmi.visuals.tools.iterate,s=UserGroup.translateInternal2Api(e);return s.groupname=this.groupname,t.requestPromise("usergroup.set",s).then(()=>i(s,(e,t)=>this._groupdata[t]=e))}delete(){const{ConnectSession:e}=shmi.visuals.session;return e.requestPromise("usergroup.del",this.groupname)}getUserData(e){return shmi.checkArg("key",e,"string"),shmi.objectHasOwnProperty(this._groupdata.data,e)?this._groupdata.data[e]:null}static translateInternal2Api(e){return{groupname:e.groupname,data:e.groupData,comment:e.description}}get groupname(){return this._groupdata.groupname}get description(){return this._groupdata.comment}}}(),function(){"use strict";function makeDgColumnMap(e,t){const i={};return t.forEach(t=>{const s=e.getFields().findIndex(e=>e===t);s>-1&&(i[t]=s)}),i}function makeFieldControlMap(e){const t={};return e.forEach(e=>{t[e]={"ui-type":"text2",config:{options:[{label:"-",value:-1}]}}}),t}function makeColumnOrg(e){const t={};return e.forEach((e,i)=>{t[`col${i+1}`]={fields:[e]}}),t}shmi.pkg("visuals.controls.iq-user-list").makeUserListConfig=function makeUserListConfig(e,t){const i=["username","firstName","lastName","localeId"].filter(e=>t.includes(e)),s=["username","firstName","lastName","localeId","passwordValidityDuration","passwordTimestamp","autoLogoutDelay","deactivated"].filter(e=>t.includes(e));return{table:e.name,"class-name":"complex-table2","field-datagrid-col-map":makeDgColumnMap(e,t),"default-field-control-map":makeFieldControlMap(t),"default-field-headers":{username:"${user_name}",firstName:"${iq-user-controller.label.firstName}",lastName:"${iq-user-controller.label.lastName}",localeId:"${iq-user-controller.label.localeId}",passwordValidityDuration:"${iq-user-controller.label.passwordExpiry}",autoLogoutDelay:"${iq-user-controller.label.autoLogoutDelay}",userGroups:"${iq-user-controller.label.userGroups}",description:"${iq-user-controller.label.description}",fakePassword:"${iq-user-controller.label.password}"},"default-layout":{"class-name":"layout-std","column-org":makeColumnOrg(t)},"sortable-fields":s,"default-text-filter-fields":i,quicksearch:{enable:!0,fields:i,remember:!1,initialFocus:!1},"select-mode":"SINGLE","delete-selected-rows":!1,"show-nof-rows":!0,"text-mode":"SINGLELINE","v-scroll-options":["SCROLLBAR","V_SWIPE"]}}}(),function(){"use strict";const e="iq-user-list",t={"class-name":e,name:null,template:"default/iq-user-list.iq-variant-01",label:e,"column-order":["username","lastName","firstName","userGroups","passwordValidityDuration","autoLogoutDelay","localeId","description","fakePassword"],"show-last-name":!0,"show-first-name":!0,"show-user-groups":!0,"show-password-validity":!0,"show-auto-logout-delay":!0,"show-locale":!0,"show-description":!0,"show-fake-password":!1},i={error:console.error.bind(console,"[IqUserList]"),warn:console.warn.bind(console,"[IqUserList]"),log:console.log.bind(console,"[IqUserList]"),debug:console.debug.bind(console,"[IqUserList]")};function makeColumnSelection(e){const{iterateObject:i}=shmi.requires("visuals.tools.iterate"),s=["username"];return i({"show-last-name":"lastName","show-first-name":"firstName","show-user-groups":"userGroups","show-password-validity":"passwordValidityDuration","show-auto-logout-delay":"autoLogoutDelay","show-locale":"localeId","show-description":"description","show-fake-password":"fakePassword"},(t,i)=>{e[i]&&s.push(t)}),(e["column-order"]||t["column-order"]).filter(e=>s.includes(e))}const s={className:"IqUserList",uiType:e,isContainer:!0,config:t,configSchema:null,vars:{dataGridId:null,dataGrid:null,currentUser:null,listeners:[]},imports:{dgm:"visuals.session.DataGridManager"},events:["change"],prototypeExtensions:{onInit:function onInit(){const{makeUserListConfig:e}=shmi.requires("visuals.controls.iq-user-list"),{DataGridUser:t}=shmi.requires("visuals.controls.iq-user-management"),s=shmi.getUiElement("table-anchor",this.element);do{this.vars.dataGridId="IqUserList-"+Math.random().toString(36).substr(2,9)}while(null!==this.imports.dgm.getGrid(this.vars.dataGridId));const n=new t(this.vars.dataGridId);this.imports.dgm.grids[this.vars.dataGridId]=n,this.vars.dataGrid=n,s?(s.removeAttribute("data-ui"),this.vars.ct=shmi.createControl("complex-table2",s,e(n,makeColumnSelection(this.config)),null,"from")):(i.warn("No table anchor found, inserting table directly into base-element"),this.vars.ct=shmi.createControl("complex-table2",this.element,e(n,makeColumnSelection(this.config)))),null===this.vars.ct&&(this.element.textContent="Unable to create complex-table widget for users. This control will not work.",i.error("Unable to create complex-table widget for users."))},onEnable:function onEnable(){this.vars.ct&&(this.vars.ct.enable(),this.vars.listeners.push(this.vars.ct.listen("select",e=>{1!==e.detail.type&&2!==e.detail.type||1!==e.detail.selRowIndex.length?this.vars.currentUser=null:this.vars.currentUser=e.detail.selRowIndex[0][0],this.fire("change",{value:this.vars.currentUser},this,!0)})))},onLock:function onLock(){this.vars.ct&&this.vars.ct.lock()},onUnlock:function onUnlock(){this.vars.ct&&this.vars.ct.unlock()},onDisable:function onDisable(){this.vars.listeners.forEach(e=>e.unlisten()),this.vars.listeners=[],this.vars.ct&&this.vars.ct.disable()},onDelete:function onDelete(){this.vars.dataGridId&&delete this.imports.dgm.grids[this.vars.dataGridId]},getCurrentUser:function getCurrentUser(){return this.vars.currentUser},refresh:function refresh(){this.vars.dataGrid&&this.vars.dataGrid.refresh()}}};shmi.requires("visuals.tools.control-generator").generate(s)}(),function(){"use strict";const e="IqUserSelect",t="iq-user-select",i={"class-name":t,name:null,template:"default/iq-user-select.iq-variant-01",label:t,"show-icon":!1,"icon-src":null,"icon-class":null,tooltip:null,"show-results":"always"},s={error:console.error.bind(console,"[IqUserSelect]"),warn:console.warn.bind(console,"[IqUserSelect]"),log:console.log.bind(console,"[IqUserSelect]"),debug:console.debug.bind(console,"[IqUserSelect]")};function eventProxy(e,t){const i=e.vars.searchbar.getMatchData();null!==i&&i.username===t.detail.value?e.fire(t.type,t.detail):e.fire(t.type,{detail:null})}const n={className:e,uiType:t,isContainer:!0,config:i,configSchema:null,vars:{domChild:null,dataGridId:null,dataGrid:null,searchbar:null,eventProxy:null},imports:{dgm:"visuals.session.DataGridManager"},events:["change"],prototypeExtensions:{onInit:function onInit(){const{DataGridUser:i}=shmi.requires("visuals.controls.iq-user-management");if(this.vars.domChild=shmi.getUiElement("user-select-searchbar",this.element),null===this.vars.domChild)return this.element.textContent="One or more required DOM elements are missing from the template. This widget will not work. Please select a compatible template.",void s.error("Some DOM elements are missing from the template.");do{this.vars.dataGridId=e+"-"+Math.random().toString(36).substr(2,9)}while(null!==this.imports.dgm.getGrid(this.vars.dataGridId));this.imports.dgm.grids[this.vars.dataGridId]=this.vars.dataGrid=new i(this.vars.dataGridId),this.vars.dataGrid.init();const n={template:this.config.template.replace(t,"iq-searchbar"),"class-name":this.config["class-name"].split(" ").map(e=>e===t?"iq-searchbar":e).join(" "),label:this.config.label,"show-icon":this.config["show-icon"],"icon-src":this.config["icon-src"],"icon-class":this.config["icon-class"],datagrid:this.vars.dataGridId,"search-column":"username","show-results":this.config["show-results"],"result-columns":["username","userGroups"]};this.vars.searchbar=shmi.createControl("iq-searchbar",this.vars.domChild,n),null===this.vars.searchbar&&(this.element.textContent="Unable to create searchbar widget for users. This widget will not work.",s.error("Unable to create searchbar widget for users."))},getValue:function getValue(){if(this.vars.searchbar){if(null!==this.vars.searchbar.getMatchData())return this.vars.searchbar.getValue()}return null},setValue:function setValue(e){this.vars.searchbar&&this.vars.searchbar.setValue(e)},refreshGrid:function refreshGrid(){this.vars.dataGrid&&this.vars.dataGrid.refresh()},onEnable:function onEnable(){this.vars.searchbar&&(this.vars.eventProxy=this.vars.searchbar.listen("change",eventProxy.bind(null,this)),this.vars.searchbar.enable())},onDisable:function onDisable(){this.vars.searchbar&&this.vars.searchbar.disable(),this.vars.eventProxy&&(this.vars.eventProxy.unlisten(),this.vars.eventProxy=null)},onDelete:function onDelete(){this.vars.searchbar&&shmi.deleteControl(this.vars.searchbar),this.vars.dataGrid&&delete this.imports.dgm.grids[this.vars.dataGridId]},onLock:function onLock(){this.vars.searchbar&&this.vars.searchbar.lock()},onUnlock:function onUnlock(){this.vars.searchbar&&this.vars.searchbar.unlock()},getCurrentUser:function getCurrentUser(){return this.getValue()},refresh:function refresh(){this.vars.dataGrid&&this.vars.dataGrid.refresh()}}};shmi.requires("visuals.tools.control-generator").generate(n)}(),shmi.pkg("visuals.controls"),shmi.visuals.controls.LinearGauge=function(e,t){this.element=e,this.config=t||{},shmi.def(this.config,"class-name","linear-gauge"),shmi.def(this.config,"template","default/linear-gauge"),shmi.def(this.config,"name",null),shmi.def(this.config,"label","linear-gauge"),shmi.def(this.config,"min",0),shmi.def(this.config,"max",100),shmi.def(this.config,"step",0),shmi.def(this.config,"type",shmi.c("TYPE_FLOAT")),shmi.def(this.config,"bar-scale-min",0),shmi.def(this.config,"bar-scale-max",1),shmi.def(this.config,"unit-scale",1),shmi.def(this.config,"precision",-1),shmi.def(this.config,"orientation","horizontal"),shmi.def(this.config,"anim-time",300),shmi.def(this.config,"decimal-delimiter","."),shmi.def(this.config,"auto-min",!0),shmi.def(this.config,"auto-max",!0),shmi.def(this.config,"auto-step",!0),shmi.def(this.config,"auto-precision",!0),shmi.def(this.config,"auto-label",!0),shmi.def(this.config,"auto-unit-text",!0),shmi.def(this.config,"auto-type",!0),this.parseAttributes(),this.value=0,this.barScale=0,this.vertical=!1,this.anim=new shmi.visuals.gfx.Animation(this.updateHandle.bind(this)),this.labelElement=null,this.valueElement=null,this.unitElement=null,this.barElement=null,this.baseColor=null,this.colors=[],this._subscriptionTargetId=null,this.active=!1,this.vars={conditional:null},this.startup()},shmi.visuals.controls.LinearGauge.prototype={uiType:"linear-gauge",getClassName:function(){return"LinearGauge"},onInit:function(){if(shmi.requires("visuals.tools.numericValues").initValueSettings(this),this.barElement=shmi.getUiElement("linear-gauge-bar",this.element),this.barElement){if("vertical"===this.config.orientation&&(this.vertical=!0),this.vertical&&shmi.addClass(this.element,"vertical"),this.labelElement=shmi.getUiElement("label",this.element),this.labelElement&&(this.labelElement.textContent=shmi.localize(this.config.label)),this.baseColor=getComputedStyle(this.barElement).backgroundColor,this.valueElement=shmi.getUiElement("linear-gauge-value",this.element),this.valueElement||shmi.log("[LinearGauge] no value element provided",3),this.unitElement=shmi.getUiElement("linear-gauge-unit",this.element),this.unitElement||shmi.log("[LinearGauge] no unit element provided",3),shmi.log("[LinearGauge] -- all elements found --",0),this.config["unit-text"]&&this.unitElement&&(this.unitElement.textContent=shmi.localize(this.config["unit-text"])),this.config["unit-scale"]&&(this.config["unit-scale"]=parseFloat(shmi.localize(this.config["unit-scale"]))),this.config.threshold){for(var e=this.config.threshold.split(";"),t=0;t<e.length;t++)this.colors.push(e[t].split(":"));for(t=0;t<this.colors.length;t++)this.colors[t][0]=parseFloat(this.colors[t][0])}}else shmi.log("[LinearGauge] no bar element provided",3)},onSetValue:function(e){this.value=parseFloat(e),this.draw()},draw:function(){var e=this.vars.valueSettings,t=e.min,i=e.max;if(shmi.visuals.session.deactivateControls)return this.anim.stop(),void setTimeout(this.draw.bind(this),shmi.c("ACTION_RETRY_TIMEOUT"));shmi.caf(this.requestID),this.requestID=shmi.raf(this.updateText.bind(this)),this.barScale=i===t?this.config["bar-scale-max"]:(this.config["bar-scale-max"]-this.config["bar-scale-min"])*((this.value-t)/(i-t))+this.config["bar-scale-min"],this.barScale>this.config["bar-scale-max"]?this.barScale=this.config["bar-scale-max"]:this.barScale<this.config["bar-scale-min"]&&(this.barScale=this.config["bar-scale-min"]);for(var s=this.baseColor,n=0;n<this.colors.length;n++)this.value>this.colors[n][0]&&(s=this.colors[n][1]);this.barElement.style.backgroundColor=s,this.anim.start(this.barScale,this.config["anim-time"])},updateText:function(){var e=shmi.requires("visuals.tools.numericValues");this.valueElement&&(this.valueElement.textContent=e.formatOutput(this.value,this))},onSetProperties:function(e,t,i){var s=this,n=shmi.requires("visuals.tools.numericValues");n.setProperties(s,arguments),"number"==typeof s.value&&s.draw()},updateHandle:function(e){this.vertical?(this.barElement.style.webkitTransform="scale3d(1, "+e.toFixed(3)+", 1)",this.barElement.style.oTransform="scale3d(1, "+e.toFixed(3)+", 1)",this.barElement.style.msTransform="scale3d(1, "+e.toFixed(3)+", 1)",this.barElement.style.mozTransform="scale3d(1, "+e.toFixed(3)+", 1)",this.barElement.style.transform="scale3d(1, "+e.toFixed(3)+", 1)"):(this.barElement.style.webkitTransform="scale3d("+e.toFixed(3)+", 1, 1)",this.barElement.style.oTransform="scale3d("+e.toFixed(3)+", 1, 1)",this.barElement.style.msTransform="scale3d("+e.toFixed(3)+", 1, 1)",this.barElement.style.mozTransform="scale3d("+e.toFixed(3)+", 1, 1)",this.barElement.style.transform="scale3d("+e.toFixed(3)+", 1, 1)")},onEnable:function(){null!==this.vars.conditional?this.vars.conditional.item!==this.config.item&&(this.vars.conditional.item=this.config.item):this.config.item&&(this.vars.conditional=shmi.createConditional(this.element,this.config.item)),this.vars.conditional&&this.vars.conditional.enable(),this.config.item&&(this._subscriptionTargetId=shmi.visuals.session.ItemManager.subscribeItem(this.config.item,this)),shmi.log("[LinearGauge] enabled",1)},onDisable:function(){this.vars.conditional&&this.vars.conditional.disable(),this.anim.stop(),this.config.item&&shmi.visuals.session.ItemManager.unsubscribeItem(this.config.item,this._subscriptionTargetId),shmi.log("[LinearGauge] disabled",1)},setLabel:function(e){this.config["auto-label"]&&this.labelElement&&(this.labelElement.textContent=shmi.localize(e))},setUnitText:function(e){this.config["auto-unit-text"]&&this.unitElement&&(this.unitElement.textContent=shmi.localize(e))}},shmi.extend(shmi.visuals.controls.LinearGauge,shmi.visuals.core.BaseControl),shmi.pkg("visuals.controls"),shmi.visuals.controls.LinearGauge2=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","linear-gauge2"),shmi.def(this.config,"label","linear-gauge2"),shmi.def(this.config,"unit-text",null),shmi.def(this.config,"template","default/linear-gauge2"),shmi.def(this.config,"name",null),shmi.def(this.config,"min",0),shmi.def(this.config,"max",100),shmi.def(this.config,"precision",-1),shmi.def(this.config,"step",0),shmi.def(this.config,"type",shmi.c("TYPE_FLOAT")),shmi.def(this.config,"bar-scale-min",0),shmi.def(this.config,"bar-scale-max",1),shmi.def(this.config,"unit-scale",1),shmi.def(this.config,"anim-time",250),shmi.def(this.config,"dynamic-anim-time",!0),shmi.def(this.config,"orientation","horizontal"),shmi.def(this.config,"image-margin",6),shmi.def(this.config,"decimal-delimiter","."),shmi.def(this.config,"auto-min",!0),shmi.def(this.config,"auto-max",!0),shmi.def(this.config,"auto-step",!0),shmi.def(this.config,"auto-precision",!0),shmi.def(this.config,"auto-label",!0),shmi.def(this.config,"auto-unit-text",!0),shmi.def(this.config,"auto-type",!0),this.value=0,this.barScale=0,this.vertical=!1,this.anim=new shmi.visuals.gfx.Animation(this.updateHandle.bind(this)),this.valueElement=null,this.unitElement=null,this.barElement=null,this._subscriptionTargetId=null,this.active=!1,this.vars={conditional:null},this.startup()},shmi.visuals.controls.LinearGauge2.prototype={uiType:"linear-gauge2",getClassName:function(){return"LinearGauge2"},onInit:function(){var e=this;shmi.requires("visuals.tools.numericValues").initValueSettings(e),"vertical"===this.config.orientation&&(this.vertical=!0),this.barElement=shmi.getUiElement("bar",this.element),this.barElement?(this.highlightElement=shmi.getUiElement("highlight",this.element),this.highlightElement?(this.vertical&&(this.element.className+=" vertical"),this.valueElement=shmi.getUiElement("value",this.element),this.valueElement?(this.unitElement=shmi.getUiElement("unit-text",this.element),this.unitElement?(this.labelElement=shmi.getUiElement("label",this.element),this.labelElement?this.config.label&&(this.labelElement.textContent=shmi.localize(this.config.label)):shmi.log("[LinearGauge2] no label element provided",1),shmi.log("[LinearGauge2] -- all elements found --",0),this.config["unit-text"]&&(this.unitElement.textContent=shmi.localize(this.config["unit-text"])),this.config["unit-scale"]&&(this.config["unit-scale"]=parseFloat(shmi.localize(this.config["unit-scale"]))),this.resizeHandler=function(){clearTimeout(e.resizeTO),e.resizeTO=setTimeout(e.updateSize.bind(e),shmi.c("ACTION_RETRY_TIMEOUT"))},this.vertical?this.size=parseInt(getComputedStyle(this.barElement).height)-this.config["image-margin"]:this.size=parseInt(getComputedStyle(this.barElement).width)-this.config["image-margin"]):shmi.log("[LinearGauge2] no unit element provided",3)):shmi.log("[LinearGauge2] no value element provided",3)):shmi.log("[LinearGauge2] no highlight element provided",3)):shmi.log("[LinearGauge2] no bar element provided",3)},updateSize:function(){this.active&&(this.vertical?this.size=parseInt(getComputedStyle(this.barElement).height)-this.config["image-margin"]:this.size=parseInt(getComputedStyle(this.barElement).width)-this.config["image-margin"],this.setValue(this.value))},onSetValue:function(e){this.value=parseFloat(e),this.draw()},draw:function(){var e=this.vars.valueSettings,t=e.min,i=e.max;if(shmi.visuals.session.deactivateControls)return this.anim.stop(),void setTimeout(this.draw.bind(this),shmi.c("ACTION_RETRY_TIMEOUT"));shmi.caf(this.requestID),this.requestID=shmi.raf(this.updateText.bind(this)),this.barScale=i===t?this.config["bar-scale-max"]:(this.config["bar-scale-max"]-this.config["bar-scale-min"])*((this.value-t)/(i-t))+this.config["bar-scale-min"],this.barScale>this.config["bar-scale-max"]?this.barScale=this.config["bar-scale-max"]:this.barScale<this.config["bar-scale-min"]&&(this.barScale=this.config["bar-scale-min"]);var s=this.config["anim-time"];if(this.config.item){var n=shmi.visuals.session.ItemManager.items[this.config.item];void 0===n?shmi.log("[RadialCanvas] item '"+this.config.item+"' undefined in manager",1):s=!1===this.config["dynamic-anim-time"]||n.interval>this.config["anim-time"]?this.config["anim-time"]:Math.round(n.interval)}this.anim.start(this.barScale,s)},updateText:function(){var e=shmi.requires("visuals.tools.numericValues");this.valueElement.textContent=e.formatOutput(this.value,this)},onSetProperties:function(e,t,i){var s=this,n=shmi.requires("visuals.tools.numericValues");n.setProperties(s,arguments),"number"==typeof s.value&&s.draw()},updateHandle:function(e){this.vertical?(this.barElement.style.webkitTransform="scale3d(1, "+e.toFixed(3)+", 1)",this.barElement.style.oTransform="scale3d(1, "+e.toFixed(3)+", 1)",this.barElement.style.msTransform="scale3d(1, "+e.toFixed(3)+", 1)",this.barElement.style.mozTransform="scale3d(1, "+e.toFixed(3)+", 1)",this.barElement.style.transform="scale3d(1, "+e.toFixed(3)+", 1)",this.highlightElement.style.webkitTransform="translate3d(0,"+(1-e*this.size).toFixed(3)+"px, 0)",this.highlightElement.style.oTransform="translate3d(0,"+(1-e*this.size).toFixed(3)+"px, 0)",this.highlightElement.style.msTransform="translate3d(0,"+(1-e*this.size).toFixed(3)+"px, 0)",this.highlightElement.style.mozTransform="translate3d(0,"+(1-e*this.size).toFixed(3)+"px, 0)",this.highlightElement.style.transform="translate3d(0,"+(1-e*this.size).toFixed(3)+"px, 0)"):(this.barElement.style.webkitTransform="scale3d("+e.toFixed(3)+", 1, 1)",this.barElement.style.oTransform="scale3d("+e.toFixed(3)+", 1, 1)",this.barElement.style.msTransform="scale3d("+e.toFixed(3)+", 1, 1)",this.barElement.style.mozTransform="scale3d("+e.toFixed(3)+", 1, 1)",this.barElement.style.transform="scale3d("+e.toFixed(3)+", 1, 1)",this.highlightElement.style.webkitTransform="translate3d("+(e*this.size).toFixed(3)+"px, 0, 0)",this.highlightElement.style.oTransform="translate3d("+(e*this.size).toFixed(3)+"px, 0, 0)",this.highlightElement.style.msTransform="translate3d("+(e*this.size).toFixed(3)+"px, 0, 0)",this.highlightElement.style.mozTransform="translate3d("+(e*this.size).toFixed(3)+"px, 0, 0)",this.highlightElement.style.transform="translate3d("+(e*this.size).toFixed(3)+"px, 0, 0)")},onEnable:function(){null!==this.vars.conditional?this.vars.conditional.item!==this.config.item&&(this.vars.conditional.item=this.config.item):this.config.item&&(this.vars.conditional=shmi.createConditional(this.element,this.config.item)),this.vars.conditional&&this.vars.conditional.enable(),this.vertical?this.size=parseInt(getComputedStyle(this.barElement).height)-this.config["image-margin"]:this.size=parseInt(getComputedStyle(this.barElement).width)-this.config["image-margin"],this.config.item&&(this._subscriptionTargetId=shmi.visuals.session.ItemManager.subscribeItem(this.config.item,this)),this.resizeListenerAdded||(window.addEventListener("resize",this.resizeHandler,!1),window.addEventListener("visuals-layout-change",this.resizeHandler,!1),this.resizeListenerAdded=!0),shmi.log("[LinearGauge2] enabled",1)},onDisable:function(){this.resizeListenerAdded&&(window.removeEventListener("resize",this.resizeHandler),window.removeEventListener("visuals-layout-change",this.resizeHandler),this.resizeListenerAdded=!1),this.vars.conditional&&this.vars.conditional.disable(),this.anim.stop(),this.config.item&&shmi.visuals.session.ItemManager.unsubscribeItem(this.config.item,this._subscriptionTargetId),shmi.log("[LinearGauge2] disabled",1)},onLock:function(){},onUnlock:function(){},setLabel:function(e){this.config["auto-label"]&&this.labelElement&&(this.labelElement.textContent=shmi.localize(e))},setUnitText:function(e){this.config["auto-unit-text"]&&this.unitElement&&(this.unitElement.textContent=shmi.localize(e))}},shmi.extend(shmi.visuals.controls.LinearGauge2,shmi.visuals.core.BaseControl),shmi.pkg("visuals.controls"),shmi.visuals.controls.ListBox=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","list-box"),shmi.def(this.config,"template","default/list-box"),shmi.def(this.config,"name",null),shmi.def(this.config,"label","list-box"),shmi.def(this.config,"options",[]),this.active=!1,this.entries=[],this.entryElements=[],this.mouseListener=null,this.touchListener=null,this.selected=-1,this.onSelect=null,this.listElement=null,this.startup()},shmi.visuals.controls.ListBox.prototype={uiType:"list-box",events:["select"],getClassName:function(){return"ListBox"},onInit:function(){var e=this;shmi.log("[ListBox] initializing...",1);var t=shmi.getUiElement("label",this.element);t&&(t.textContent=shmi.localize(this.config.label)),Array.isArray(e.config.options)&&e.config.options.forEach((function(t){e.entries.push(t)})),this.listElement=shmi.getUiElement("list-items",this.element),this.listElement||shmi.notify("[ListBox] template missing 'list-items' element");var i={};i.onClick=function(t,i,s){this.setSelected(s.target),e.fire("select",{value:e.getSelectedEntry()})}.bind(this),this.mouseListener=new shmi.visuals.io.MouseListener(this.listElement,i),this.touchListener=new shmi.visuals.io.TouchListener(this.listElement,i),shmi.log("[ListBox] initialized",1)},onEnable:function(){this.mouseListener.enable(),this.touchListener.enable(),shmi.log("[ListBox] enabled",1)},onDisable:function(){this.mouseListener.disable(),this.touchListener.disable(),shmi.log("[ListBox] disabled",1)},addEntry:function(e){if(this.initialized){var t=document.createElement("div");t.setAttribute("data-ui","list-item"),t.setAttribute("class","list-item"),t.textContent=e,this.entries.push(e),this.entryElements.push(t),this.listElement.appendChild(t),shmi.log("[ListBox] entry added: "+e,1)}else setTimeout(function(){this.addEntry(e)}.bind(this),shmi.c("ACTION_RETRY_TIMEOUT"))},removeEntryByValue:function(e){var t=-1;this.entries.forEach((function(i,s){i.value===e&&(t=s)})),-1!==t&&(this.listElement.removeChild(this.entryElements[t]),this.entries.splice(t,1),this.entryElements.splice(t,1),this.selected===t&&this.setSelectedIndex(-1))},removeEntry:function(e){e===this.selected&&(this.selected=-1),this.listElement.removeChild(this.entryElements[e]),this.entryElements.splice(e,1),this.entries.splice(e,1)},removeAll:function(){for(;this.entries.length;)this.removeEntry(0);this.selected=-1},setSelected:function(e){for(var t=0;t<this.entryElements.length;t++)if(this.entryElements[t]===e){-1!==this.selected&&shmi.removeClass(this.entryElements[this.selected],"selected"),t===this.selected?this.selected=-1:(this.selected=t,shmi.addClass(this.entryElements[t],"selected"));break}this.onSelect&&this.onSelect(this.selected)},setSelectedIndex:function(e){-1!==this.selected&&shmi.removeClass(this.entryElements[this.selected],"selected"),e===this.selected?this.selected=-1:-1===e?this.selected=-1:(this.selected=e,shmi.addClass(this.entryElements[e],"selected")),this.onSelect&&this.onSelect(this.selected)},getSelectedEntry:function(){return-1===this.selected?null:this.entries[this.selected]},getSelectedIndex:function(){return this.selected},onLock:function(){this.active&&(this.mouseListener.disable(),this.touchListener.disable(),shmi.addClass(this.element,"locked"))},onUnlock:function(){this.active&&(this.mouseListener.enable(),this.touchListener.enable(),shmi.removeClass(this.element,"locked"))},setLabel:function(e){var t=shmi.getUiElement("label",this.element);t&&(t.textContent=shmi.localize(e))}},shmi.extend(shmi.visuals.controls.ListBox,shmi.visuals.core.BaseControl),shmi.visuals.controls.LocalScript=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"url",null),shmi.def(this.config,"name",null),this.run=!1,this.loaded=!1,this.script="",this.startup()},shmi.visuals.controls.LocalScript.prototype={uiType:"local-script",isContainer:!1,getClassName:function(){return"LocalScript"},onInit:function(){if(this.config.url)shmi.loadResource(this.config.url,this._loadCB.bind(this));else if(this.config.module){try{if(this.module=shmi.requires(this.config.module),"function"!=typeof this.module.run)throw new Error("local-script module has no 'run' function: "+this.config.module)}catch(e){this.element.textContent="UNKNOWN_MODULE: "+this.config.module,this.module={run:function(){}}}this.loaded=!0}else console.log("[LocalScript] no script configured")},_loadCB:function(data,failed){failed?console.log("[LocalScript] failed to load script:",this.config.url):(this.script=data,this.loaded=!0,this.active&&(this.run=!0,eval(this.script)))},onEnable:function(){!this.run&&this.loaded&&(this.config.module?this.module.run(this):eval(this.script))},onDisable:function(){this.run=!1}},shmi.extend(shmi.visuals.controls.LocalScript,shmi.visuals.core.BaseControl),shmi.pkg("visuals.controls"),shmi.visuals.controls.Login=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","login"),shmi.def(this.config,"template","default/login"),shmi.def(this.config,"name",null),shmi.def(this.config,"userEntry",'<div data-ui="user" class="user"><div class="userPic"></div><div class="user_detail"><h1 data-ui="user-name"><%= USER %></h1></div></div>'),this.userElement=null,this.passwordElement=null,this.loginButtonElement=null,this.clearButtonElement=null,this.autoLoginButtonElement=null,this.clickCounter=0,/Firefox/.test(navigator.userAgent)?(this.innerWidth=window.innerWidth-1,this.innerHeight=window.innerHeight-1):(this.innerWidth=window.innerWidth,this.innerHeight=window.innerHeight),this.userListContent="",this.startup()},shmi.visuals.controls.Login.prototype={uiType:"login",getClassName:function(){return"Login"},onInit:function(){var e=this,t=shmi.requires("visuals.session");if(!e.element)return void shmi.log("[Login] no base element provided",3);if(e.userElement=shmi.getUiElement("user-field",e.element),!e.userElement)return void shmi.log("[Login] no user-field element provided",3);if(shmi.addClass(e.userElement,"locked"),e.userElement.setAttribute("disabled",!0),e.passwordElement=shmi.getUiElement("password-field",e.element),!e.passwordElement)return void shmi.log("[Login] no password-field element provided",3);if(shmi.addClass(e.passwordElement,"locked"),e.passwordElement.setAttribute("disabled",!0),e.loginButtonElement=shmi.getUiElement("login-button",e.element),!e.loginButtonElement)return void shmi.log("[Login] no login-button element provided",3);if(e.clearButtonElement=shmi.getUiElement("clear-button",e.element),!e.clearButtonElement)return void shmi.log("[Login] no clear-button element provided",3);e.autoLoginButtonElement=shmi.getUiElement("autologin-button",e.element),e.autoLoginButtonElement||shmi.log("[Login] no autologin-button element provided",2),e.statusElement=shmi.getUiElement("status",e.element),e.statusElement&&(e.statusLabelElement=shmi.getUiElement("label",e.statusElement)),e.statusElement&&e.statusLabelElement&&(shmi.addClass(e.statusElement,"connecting"),e.statusLabelElement.textContent="connecting ..."),t.SocketConnection.connect((function(i){0===i?t.UserManager.requestUserList(e.applyUserList.bind(e)):e.statusElement&&e.statusLabelElement?(shmi.removeClass(e.statusElement,"connecting"),shmi.addClass(e.statusElement,"error"),e.statusLabelElement.textContent="connection error"):console.error("[Login] Error establishing WebSocket connection")}));const i=new XMLHttpRequest;i.open("GET",".webiq/preview.png",!0),i.send(),i.onload=function(){200!==i.status&&(document.getElementById("project-image").style.backgroundImage='url("pics/system/controls/login/placeholder.png")')},t.Login=this},onEnable:function(){Array.isArray(this.listeners)&&this.listeners.forEach((function(e){e.enable()}))},onDisable:function(){Array.isArray(this.listeners)&&this.listeners.forEach((function(e){e.disable()}))},applyUserList:function(){var e=this,t=shmi.visuals.session.UserManager.userList,i=shmi.requires("visuals.tools.iterate.iterateObject");e.userListContent="",i(t,(function(t,i){e.userListContent+=shmi.evalString(e.config.userEntry,{USER:i})})),this.userListElement=document.createElement("div"),shmi.addClass(this.userListElement,"hidden"),shmi.addClass(this.userListElement,"user-list");var s=document.createElement("div");s.className="toolArrow";var n=document.createElement("div");n.className="toolTip",n.innerHTML=this.userListContent,this.userListElement.appendChild(s),this.userListElement.appendChild(n),this.userNameInputElement=shmi.getUiElement("user-name-input",this.element),this.userNameInputElement&&this.userNameInputElement.appendChild(this.userListElement);var a=shmi.visuals.session.UserManager,l=null,o=shmi.visuals.session;a.requestAutoLogin(e=>{this.statusElement&&this.statusLabelElement&&(this.statusLabelElement.textContent="connected",shmi.removeClass(this.statusElement,"connecting"),shmi.addClass(this.statusElement,"connected")),e?(shmi.removeClass(this.userElement,"locked"),shmi.removeClass(this.passwordElement,"locked"),this.userElement.removeAttribute("disabled"),this.passwordElement.removeAttribute("disabled"),this.initListeners(),this.loginCallback(e)):this.loginCallback(0)}),o.URLParameters.autoLogin&&((l=new URL(window.location.href)).searchParams.delete("autoLogin"),window.history.replaceState({},document.title,l.toString()))},initListeners:function(){var e=this;this.userElement.addEventListener("focus",function(){shmi.removeClass(this.userListElement,"hidden")}.bind(this)),this.userElement.addEventListener("click",function(){var t=shmi.visuals.session.config;if(t.keyboard&&t.keyboard.enabled&&(this.clickCounter++,this.clickCounter>1)){var i={value:e.userElement.value,"password-input":!1,"select-box-enabled":!0,callback:function(t,i){t&&(e.userElement.value=i)}};shmi.keyboard(i)}}.bind(this)),this.userElement.addEventListener("blur",function(){this.clickOnUserList||shmi.addClass(this.userListElement,"hidden")}.bind(this)),this.passwordElement.addEventListener("focus",(function(){var t=shmi.visuals.session.config;if(t.keyboard&&t.keyboard.enabled){var i={value:e.passwordElement.value,"password-input":!0,"select-box-enabled":!0,callback:function(t,i){t&&(e.passwordElement.value=i)}};shmi.keyboard(i)}}));var t=shmi.getUiElements("user",this.userListElement);Array.isArray(this.listeners)&&this.listeners.forEach((function(e){e.disable()})),this.listeners=[];for(var i=0;i<t.length;i++){var s={};s.onPress=function(){this.clickOnUserList=!0}.bind(this),s.onRelease=function(){this.clickOnUserList=!1}.bind(this),s.onClick=function(e){return this.listeners.push(new shmi.visuals.io.MouseListener(e,s)),this.listeners.push(new shmi.visuals.io.TouchListener(e,s)),function(){var t=shmi.getUiElement("user-name",e);this.userElement.value=t.innerHTML,shmi.log("[Login] username: "+t.innerHTML,1),shmi.raf(function(){shmi.addClass(this.userListElement,"hidden"),this.passwordElement.focus()}.bind(this))}.bind(this)}.bind(this)(t[i])}this.userElement.addEventListener("keypress",function(e){13===e.keyCode&&shmi.raf(function(){this.passwordElement.focus()}.bind(this))}.bind(this)),this.passwordElement.addEventListener("keypress",function(e){13===e.keyCode&&(this.passwordElement.blur(),shmi.raf(function(){shmi.visuals.session.UserManager.requestLogin(this.userElement.value.trim(),this.passwordElement.value,this.loginCallback.bind(this))}.bind(this)))}.bind(this));var n,a={};if(a.onClick=function(){shmi.visuals.session.UserManager.requestLogin(this.userElement.value.trim(),this.passwordElement.value,this.loginCallback.bind(this))}.bind(this),this.listeners.push(new shmi.visuals.io.MouseListener(this.loginButtonElement,a)),this.listeners.push(new shmi.visuals.io.TouchListener(this.loginButtonElement,a)),this.clearButtonElement&&((n={}).onClick=function(){this.userElement.value="",this.passwordElement.value=""}.bind(this),this.listeners.push(new shmi.visuals.io.MouseListener(this.clearButtonElement,n)),this.listeners.push(new shmi.visuals.io.TouchListener(this.clearButtonElement,n))),this.autoLoginButtonElement){var l=shmi.requires("visuals.io"),o=shmi.requires("visuals.session"),r=o.UserManager,c={onClick:function(){r.requestLogin(o.config["auto-login"].user,o.config["auto-login"].password,e.loginCallback.bind(e))}},u=shmi.getUiElement("button-label",this.autoLoginButtonElement);o.config["auto-login"]&&o.config["auto-login"].enabled&&(u&&(u.textContent=shmi.evalString("Login as default user '<%= USER %>'",{USER:o.config["auto-login"].user})),shmi.removeClass(this.autoLoginButtonElement,"hidden"),this.listeners.push(new l.MouseListener(this.autoLoginButtonElement,c)),this.listeners.push(new l.TouchListener(this.autoLoginButtonElement,c)))}!0===this.active&&this.listeners.forEach((function(e){e.enable()}))},loginCallback:function(e){shmi.log("[Login] login-callback called",2);var t=shmi.visuals.session;if(t.UserManager.currentUser&&t.UserManager.currentUser.loggedIn){shmi.log("[Login] login succeeded",1);var i=this;if(document.body.innerHTML="",t.config["show-load-screen"]){var s=shmi.pkg("visuals.session.SysControlConfig.loadingOverlay");this.bgDiv=document.createElement(s.tagName||"DIV"),shmi.addClass(this.bgDiv,s["class-name"]||"loading-box-overlay"),s.template&&shmi.loadResource(shmi.c("TEMPLATE_PATH")+s.template+shmi.c("TEMPLATE_EXT"),(function(e,t){t||(i.bgDiv.innerHTML=e)})),document.body.appendChild(this.bgDiv)}t.AlarmManager.requestAlarmList(),shmi.raf((function(){shmi.loadResource(shmi.evalString(shmi.c("LOCALE_PATH_PATTERN"),{index:t.UserManager.currentUser.locale}),i.loadProject.bind(i))}))}else e&&"shmi:connect:license"===e.category&&4===e.errc?(shmi.notify("${login.error.too-many-clients}","${V_NOTIFICATION}"),shmi.log(`[Login] login failed - ${e.message}`,1)):e&&"Auto-Login credentials exhausted"!==e.message&&(shmi.notify("${login.error.invalid-credentials}","${V_NOTIFICATION}"),shmi.log("[Login] login failed",1))},loadProject:function(e,t,i){var s=shmi.requires("visuals.session");if(s.locale=s.locale||{},!t){var n=shmi.requires("visuals.tools.iterate.iterateObject");try{n(JSON.parse(e),(function(e,t){s.locale[t]=e}))}catch(e){console.error("[Login] failed to parse locale file:",i,e)}}var a=null;a="string"==typeof s.config.layout?s.config.layout:shmi.c("DEFAULT_LAYOUT_URL"),void 0!==s.URLParameters.layout&&(a=s.URLParameters.layout),s.LayoutURL=a,this.layout_url=a,shmi.loadResource(a,this.applyProject.bind(this))},applyProject:function(e,t){if(t)return void shmi.log("[Login] could not load project entrypoint.\n"+this.layout_url,3);var i=shmi.visuals.session,s=document.createDocumentFragment(),n=document.createElement("div");for(n.innerHTML=e,s.appendChild(n);s.firstChild.firstChild;)document.body.appendChild(s.firstChild.firstChild);i.ProjectSource=e;let a=shmi.visuals.parser.parseProject();var l=document.getElementById("viewportMeta");l&&l.setAttribute("content",l.getAttribute("content").replace("user-scalable=no","user-scalable=yes")),shmi.waitOnInit(a,()=>{var e=shmi.requires("visuals.tools.iterate.iterateObject"),t=null;shmi.log("[Login] All controls initialized",2),shmi.visuals.session.startScripts&&"visuals.defaultClient"===shmi.visuals.session.config["session-client"]&&e(shmi.visuals.session.startScripts,(function(e,t){try{shmi.visuals.session.startScripts[t]()}catch(e){shmi.log("[Login] failed to execute start-script '"+t+"': "+e,2)}})),(t=document.createEvent("Event")).initEvent("resize",!0,!0),window.dispatchEvent(t),i.config["show-load-screen"]&&shmi.raf(function(){!1===i.config["load-screen-transition"]?document.body.removeChild(this.bgDiv):(this.bgDiv.style.opacity=0,this.bgDiv.addEventListener("transitionend",function(){document.body.removeChild(this.bgDiv)}.bind(this)),this.bgDiv.addEventListener("webkitTransitionEnd",function(){document.body.removeChild(this.bgDiv)}.bind(this)))}.bind(this)),shmi.fire("parser-ready",{},shmi.visuals.session)})}},shmi.extend(shmi.visuals.controls.Login,shmi.visuals.core.BaseControl),function(){"use strict";var e={"class-name":"numpad",name:null,template:"default/numpad/numpad-box",label:"numpad",inputLimitMinimumLabel:"${NUMPAD_INPUT_LIMIT_MINIMUM}",inputLimitMaximumLabel:"${NUMPAD_INPUT_LIMIT_MAXIMUM}","initially-visible":!1,"top-level":!1,value:"0","max-chars":10,callback:null,unit:"","decimal-delimiter":".",type:shmi.c("TYPE_FLOAT"),precision:2,min:-100,max:100,"enable-key-codes":[]},t=shmi.requires("visuals.tools.logging").createLogger("numpad",!0,!1),i=(t.fLog,t.log,{add:function(e,t,s,n){e.vars.errTextElem&&t&&s&&(e.vars.messages[t]||(0===Object.keys(e.vars.messages).length&&shmi.addClass(e.vars.errTextElem,"visible"),e.vars.messages[t]=document.createElement("div"),shmi.addClass(e.vars.messages[t],"err-msg-"+t),e.vars.errTextElem.appendChild(e.vars.messages[t]),shmi.addClass(e.vars.messages[t],"fadein"),setTimeout((function(){e.vars.messages[t]&&shmi.removeClass(e.vars.messages[t],"fadein")}),250)),e.vars.messages[t].innerHTML=s,isNaN(Number(n))||setTimeout((function(){i.remove(e,t)}),Number(n)))},remove:function(e,t){e.vars.errTextElem&&t&&e.vars.messages[t]&&(shmi.addClass(e.vars.messages[t],"fadeout"),setTimeout((function(){e.vars.messages[t]&&e.vars.errTextElem.removeChild(e.vars.messages[t]),delete e.vars.messages[t]}),250))},clear:function(e){e.vars.errTextElem&&Object.keys(e.vars.messages).length>0&&(Object.keys(e.vars.messages).forEach((function(t){i.remove(e,t)})),e.vars.messages={},setTimeout((function(){shmi.removeClass(e.vars.errTextElem,"visible"),e.vars.errTextElem.innerHTML=""}),250))}});function value(e,t){return void 0!==t&&(e.config.value=t),validate(e.config.value,e)?shmi.removeClass(e.vars.inputDisplayElement,"error"):shmi.addClass(e.vars.inputDisplayElement,"error"),e.config.value}function validate(e,t){var s,n=new RegExp("[^0-9'"+t.config["decimal-delimiter"]+"-]","i"),a=Number(String(e).replace(t.config["decimal-delimiter"],".")),l="",o=0;if(-1!==e.indexOf(t.config["decimal-delimiter"])&&o++,0===e.indexOf("-")&&o++,t.vars.inputDisplayElement.setAttribute("maxlength",t.config["max-chars"]+o),t.config.type===shmi.c("TYPE_INT")&&!Number.isInteger(a))return l=shmi.localize("${numpad_entered_value_is_not_integer}"),shmi.log("[Numpad] "+l,1),i.remove(t,"no-number"),i.add(t,"no-integer",l),!1;if(isNaN(a))return l=shmi.localize("${numpad_entered_value_is_not_number}"),shmi.log("[Numpad] "+l,1),i.add(t,"no-number",l),i.remove(t,"no-integer"),!1;if(i.remove(t,"no-number"),i.remove(t,"no-integer"),e.match(n))return l=shmi.localize("${numpad_entered_value_invalid}"),shmi.log("[Numpad] "+l,1),i.add(t,"invalid",l),!1;if(i.remove(t,"invalid"),-1!==Number(t.config.precision)&&-1!==e.indexOf(t.config["decimal-delimiter"])){if(void 0!==(s=e.split(t.config["decimal-delimiter"]))[1]&&s[1].length>t.config.precision)return l=shmi.evalString(shmi.localize("${numpad_too_many_digits}"),{precision:t.config.precision}),shmi.log("[Numpad] "+l,1),i.add(t,"exceeded-decimal-digits",l),!1;i.remove(t,"exceeded-decimal-digits")}else i.remove(t,"exceeded-decimal-digits");return"number"==typeof t.config.min&&a<t.config.min?(l=shmi.localize("${numpad_entered_value_too_low}"),shmi.log("[Numpad] "+l,1),i.remove(t,"max-error"),i.add(t,"min-error",l),!1):(i.remove(t,"min-error"),"number"==typeof t.config.max&&a>t.config.max?(l=shmi.localize("${numpad_entered_value_too_large}"),shmi.log("[Numpad] "+l,1),i.remove(t,"min-error"),i.add(t,"max-error",l),!1):(i.remove(t,"max-error"),i.clear(t),!0))}function insertCharIntoString(e,t,s){var n=0;-1!==(t=String(t)).indexOf(s.config["decimal-delimiter"])&&n++,0===t.indexOf("-")&&n++;var a=!1,l=Number(s.config["max-chars"]+n);if(a=t.substr(0,s.vars.inputDisplayElement.selectionStart)+e+t.substr(s.vars.inputDisplayElement.selectionEnd),"0"===t&&e!==s.config["decimal-delimiter"])a=e;else if(l&&a.length>l){var o=shmi.evalString(shmi.localize("${numpad_too_many_characters}"),{maxChars:l-n});return shmi.log("[Numpad] "+o,3),i.add(s,"max-chars",o,3e3),e.length>1?(e=e.substr(0,l-t.length),t.substr(0,s.vars.inputDisplayElement.selectionStart)+e+t.substr(s.vars.inputDisplayElement.selectionEnd)):t}return s.vars.inputDisplayElement.focus(),a}function actionOk(e){validate(value(e),e)&&("function"==typeof e.config.callback&&e.config.callback(Number(value(e).replace(",","."))),e.hide())}function actionClose(e){e.hide()}var s={className:"Numpad",uiType:"numpad",isContainer:!1,config:e,configSchema:null,vars:{titleElement:null,inputLimitMinimum:null,inputLimitMinimumLabel:null,inputLimitMaximum:null,inputLimitMaximumLabel:null,inputDisplayElement:null,errTextElem:null,unitElement:null,buttons:{},buttonsElements:[],containerElement:null,listeners:[]},imports:{im:"visuals.session.ItemManager",qm:function(){return shmi.visuals.session.QueryManager}},events:["open","ok","close"],prototypeExtensions:{onInit:function(){var e=this;e.vars.messages={},e.config.value=String(e.config.value).replace(".",e.config["decimal-delimiter"]),e.vars.keys={number:[48,49,50,51,52,53,54,55,56,57],numpad:[96,97,98,99,100,101,102,103,104,105],arrow:[37,38,39,40],startEndDelete:[35,36,46],decimalDelimiters:[110,188,190],minus:[189,109],plus:[107,187],ctrls:[8,13,17,27],functionKeys:[112,113,114,115,116,117,118,119,120,121,122,123],configKeyCodes:e.config["enable-key-codes"].map((function(e){return Number(e)}))},e.vars.keys.validKey=Array.prototype.concat.apply([],Object.values(e.vars.keys)),e.vars.keys.validNumber=e.vars.keys.number.concat(e.vars.keys.numpad),e.vars.buttons={1:{action:function(t){return insertCharIntoString("1",t,e)}},2:{action:function(t){return insertCharIntoString("2",t,e)}},3:{action:function(t){return insertCharIntoString("3",t,e)}},4:{action:function(t){return insertCharIntoString("4",t,e)}},5:{action:function(t){return insertCharIntoString("5",t,e)}},6:{action:function(t){return insertCharIntoString("6",t,e)}},7:{action:function(t){return insertCharIntoString("7",t,e)}},8:{action:function(t){return insertCharIntoString("8",t,e)}},9:{action:function(t){return insertCharIntoString("9",t,e)}},0:{action:function(t){return"0"===t?"0":insertCharIntoString("0",t,e)}},dot:{action:function(t){return-1!==(t=String(t)).indexOf(e.config["decimal-delimiter"])?t:insertCharIntoString(null===t.match(/\d/)?`0${e.config["decimal-delimiter"]}`:e.config["decimal-delimiter"],t,e)}},backspace:{action:function(t){return t=String(t),e.vars.inputDisplayElement.selectionStart===e.vars.inputDisplayElement.selectionEnd?(0===e.vars.inputDisplayElement.selectionStart&&(e.vars.inputDisplayElement.selectionStart=t.length,e.vars.inputDisplayElement.selectionEnd=t.length),t.substr(0,e.vars.inputDisplayElement.selectionStart-1)+t.substr(e.vars.inputDisplayElement.selectionEnd)):t.substr(0,e.vars.inputDisplayElement.selectionStart)+t.substr(e.vars.inputDisplayElement.selectionEnd)}},plusMinus:{action:function(e){return e=-1!==e.indexOf("-")?String(e).replace("-",""):"-"+String(e)}},close:{action:function(t){return actionClose(e),t}},ok:{action:function(t){return actionOk(e),t}}},e.vars.titleElement=shmi.getUiElement("numpad-title",e.element),e.vars.titleElement||shmi.log("[Numpad] no numpad-title element provided",3),e.vars.errTextElem=shmi.getUiElement("error-message",e.element),e.vars.errTextElem||shmi.log("[Numpad] no error-message element provided",3),e.vars.inputLimitMinimum=shmi.getUiElement("input-limit-minimum",e.element),e.vars.inputLimitMinimum||shmi.log("[Numpad] no input-limit-minimum element provided",3),e.vars.inputLimitMinimumLabel=shmi.getUiElement("input-limit-minimum-label",e.element),e.vars.inputLimitMinimumLabel||shmi.log("[Numpad] no input-limit-minimum-label element provided",3),e.vars.inputLimitMaximum=shmi.getUiElement("input-limit-maximum",e.element),e.vars.inputLimitMaximum||shmi.log("[Numpad] no input-limit-maximum element provided",3),e.vars.inputLimitMaximumLabel=shmi.getUiElement("input-limit-maximum-label",e.element),e.vars.inputLimitMaximumLabel||shmi.log("[Numpad] no input-limit-maximum-label element provided",3),e.vars.frameElement=shmi.getUiElement("numpad-frame",e.element),e.vars.frameElement||shmi.log("[Numpad] no numpad-frame element provided",3),e.vars.inputDisplayElement=shmi.getUiElement("numpad-input-display",e.element),e.vars.inputDisplayElement?e.vars.inputDisplayElement.setAttribute("maxlength",e.config["max-chars"]):shmi.log("[Numpad] no numpad-input-display element provided",3),e.vars.unitElement=shmi.getUiElement("numpad-unit",e.element),e.vars.unitElement||shmi.log("[Numpad] no numpad-unit element provided",3),Object.keys(e.vars.buttons).forEach((function(t){var i="numpad-button-"+t;e.vars.buttonsElements[t]=shmi.getUiElement(i,e.element),e.vars.buttonsElements[t]?(e.vars.buttonsElements[t].value=t,e.vars.buttonsElements[t].setAttribute("tabindex","1")):shmi.log(shmi.evalString(shmi.localize("[Numpad] no <%= elId %> element provided!"),{elId:i}),3)})),e.vars.visible=e.config["initially-visible"],e.vars.visible&&shmi.addClass(e.element,"open"),e.vars.containerElement=shmi.getUiElement("numpad-content",e.element),e.vars.containerElement||shmi.log("[Numpad] no numpad-content element provided",3),e.vars.titleElement&&e.config.label&&(e.vars.titleElement.textContent=shmi.localize(e.config.label)),e.vars.inputLimitMinimum&&"number"==typeof e.config.min&&(e.vars.inputLimitMinimum.textContent=e.config.min),e.vars.inputLimitMinimumLabel&&e.config.inputLimitMinimumLabel&&(e.vars.inputLimitMinimumLabel.textContent=shmi.localize(e.config.inputLimitMinimumLabel)),e.vars.inputLimitMaximum&&"number"==typeof e.config.max&&(e.vars.inputLimitMaximum.textContent=e.config.max),e.vars.inputLimitMaximumLabel&&e.config.inputLimitMaximumLabel&&(e.vars.inputLimitMaximumLabel.textContent=shmi.localize(e.config.inputLimitMaximumLabel)),e.vars.unitElement&&(e.config.unit&&"unit"!==e.config.unit?e.vars.unitElement.textContent="number"==typeof e.config.unit?e.config.unit:shmi.localize(e.config.unit):shmi.addClass(e.vars.unitElement,"hidden")),e.vars.inputDisplayElement&&(value(e)&&(e.vars.inputDisplayElement.value=String(value(e)).replace(".",e.config["decimal-delimiter"])),e.vars.inputDisplayElement.onkeyup=function(t){"Enter"===t.key?actionOk(e):"Escape"===t.key?actionClose(e):value(e,e.vars.inputDisplayElement.value)}),e.vars.buttonsElements.close&&(e.vars.buttonsElements.close.textContent=shmi.localize("${cancel}")),e.vars.buttonsElements.ok&&(e.vars.buttonsElements.ok.textContent=shmi.localize("${okay}")),e.vars.buttonsElements.dot&&(e.vars.buttonsElements.dot.textContent=e.config["decimal-delimiter"]);var t=e.vars.inputDisplayElement.className;-1!==t.indexOf("large")||-1!==e.config["class-name"].indexOf("large")?e.vars.size="large":-1!==t.indexOf("small")||-1!==e.config["class-name"].indexOf("small")?e.vars.size="small":e.vars.size="default",e.vars.inputDisplayListener=function(t){if(-1!==e.vars.keys.validKey.indexOf(t.which)){var i=e.vars.inputDisplayElement.value;-1===e.vars.keys.validNumber.indexOf(t.which)||"0"!==i&&"-0"!==i?-1!==e.vars.keys.minus.indexOf(t.which)?(t.preventDefault(),-1===i.indexOf("-")&&(e.vars.inputDisplayElement.value="-"+i)):-1!==e.vars.keys.plus.indexOf(t.which)&&(t.preventDefault(),-1!==i.indexOf("-")&&(e.vars.inputDisplayElement.value=i.replace("-",""))):"0"===i?e.vars.inputDisplayElement.value="":"-0"===i&&(e.vars.inputDisplayElement.value="-")}else t.ctrlKey||t.preventDefault()},e.vars.elementEnterKey=function(t){"Enter"===t.key?actionOk(e):"Escape"===t.key&&actionClose(e)}},show:function(){var e=this;if(e.active){if(!e.vars.visible){if(e.vars.visible=!0,!0===e.config["top-level"]&&document.body.appendChild(e.element),e.config.min&&""!==e.config.min?shmi.removeClass(e.vars.inputLimitMinimumLabel.parentElement,"no-min"):shmi.addClass(e.vars.inputLimitMinimumLabel.parentElement,"no-min"),e.config.max&&""!==e.config.max?shmi.removeClass(e.vars.inputLimitMaximumLabel.parentElement,"no-max"):shmi.addClass(e.vars.inputLimitMaximumLabel.parentElement,"no-max"),e.config["cover-background"])if(e.vars.bgDiv)shmi.removeClass(e.vars.bgDiv,"hidden");else{e.vars.bgDiv=document.createElement("div"),shmi.addClass(e.vars.bgDiv,"numpad-overlay"),e.vars.bgDiv.setAttribute("tabindex","-1"),document.body.appendChild(e.vars.bgDiv),shmi.removeClass(e.vars.bgDiv,"hidden");var t={onPress:function(){document.activeElement.blur()}};shmi.visuals.io.TouchListener(e.vars.bgDiv,t)}shmi.addClass(e.element,"open"),setTimeout((function(){e.vars.inputDisplayElement.focus(),e.fire("open",{})}),shmi.c("DECOUPLE_TIMEOUT")),e.vars.inputDisplayElement.selectionStart=0,e.vars.inputDisplayElement.selectionEnd=e.vars.inputDisplayElement.value.length}}else shmi.log("[Numpad] cannot show numpad without enabling it first",3)},hide:function(){this.vars.visible&&(this.vars.visible=!1,shmi.removeClass(this.element,"open"),this.config["cover-background"]&&this.vars.bgDiv&&shmi.addClass(this.vars.bgDiv,"hidden"),this.fire("close",{}))},onEnable:function(){var e,t,i=this,s={};s.onPress=function(e,t,s){s.preventDefault();var n=s.target;shmi.addClass(i.element,"pressed"),document.activeElement!==i.element&&i.element.focus(),shmi.log("[Numpad] pressed",1),function onNumpadAction(e,t){var i;void 0!==e&&void 0!==t.vars.buttonsElements[e]&&(i=t.vars.buttons[e].action(value(t)),t.vars.inputDisplayElement.value=value(t,i))}(n.value,i),i.vars.inputDisplayElement.focus()},s.onRelease=function(){shmi.removeClass(i.element,"pressed"),shmi.log("[Numpad] released",1)},e=new shmi.visuals.io.MouseListener(i.vars.containerElement,s),t=new shmi.visuals.io.TouchListener(i.vars.containerElement,s,!0),i.vars.listeners.push(e,t),i.element.setAttribute("tabindex","1"),i.element.addEventListener("keydown",i.vars.elementEnterKey),i.vars.inputDisplayElement.addEventListener("keydown",i.vars.inputDisplayListener),i.vars.listeners.forEach((function(e){e.enable()})),shmi.log("[Numpad] enabled",1)},onDisable:function(){this.hide(),this.vars.listeners.forEach((function(e){e.disable()})),this.vars.elementEnterKey&&this.element.removeEventListener("keydown",this.vars.elementEnterKey),this.vars.inputDisplayElement&&this.vars.inputDisplayElement.removeEventListener("keydown",this.vars.inputDisplayListener),this.vars.bgDiv&&(this.vars.bgDiv.parentNode.removeChild(this.vars.bgDiv),this.vars.bgDiv=null),shmi.log("[Numpad] disabled",1)},onLock:function(){this.vars.listeners.forEach((function(e){e.disable()}))},onUnlock:function(){this.vars.listeners.forEach((function(e){e.enable()}))},onSetValue:function(e,t,i){},onSetProperties:function(e,t,i){}}};shmi.requires("visuals.tools.control-generator").generate(s)}(),shmi.pkg("visuals.controls"),shmi.visuals.controls.Panel=function(e,t){shmi.requires("visuals.controls.View"),shmi.requires("visuals.controls.panel.PanelIndicator"),shmi.requires("visuals.gfx.Animation"),shmi.requires("visuals.gfx.Movable"),shmi.requires("visuals.io.MouseListener"),shmi.requires("visuals.io.TouchListener"),this.element=e,this.configName=this.element.getAttribute("data-config-name"),3===arguments.length?this.config=arguments[2]||{}:this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","panel"),shmi.def(this.config,"name",null),shmi.def(this.config,"show-indicator",!1),shmi.def(this.config,"disable-swipe",!1),shmi.def(this.config,"anim-duration",250),shmi.def(this.config,"item",null),shmi.def(this.config,"animate",!1),shmi.def(this.config,"initial-view",0),this.config.animate="true"===this.config.animate||!0===this.config.animate,this.viewElements=[],this.controls=[],this.subpanels=[],this.history=[],this.currentView=0,this.nextView=0,this.initialized=!1,this._dragging=!1,this.anim=new shmi.visuals.gfx.Animation(this.updatePosition.bind(this),this.updateVisibility.bind(this),"ease_out"),this.anim.priority=!0,this.clientWidth=null,this.clientHeight=null,this.ignoreResize=!1,this.active=!1,this.startup()},shmi.visuals.controls.Panel.prototype={uiType:"panel",isContainer:!0,events:["navigate"],getClassName:function(){return"Panel"},onRegister:function(e){"true"===this.config["show-indicator"]?this.config["show-indicator"]=!0:"false"===this.config["show-indicator"]&&(this.config["show-indicator"]=!1),"true"===this.config["disable-swipe"]?this.config["disable-swipe"]=!0:"false"===this.config["disable-swipe"]&&(this.config["disable-swipe"]=!1),this.contentDiv=document.createElement("div"),this.element.appendChild(this.contentDiv),function initializeViews(e){for(var t=shmi.getUiElements("view",e.element),i=0;i<t.length;i++)t[i].parentNode===e.element&&(t[i].setAttribute("tabindex","-1"),e.viewElements.push(t[i]));for(e.clientWidth=e.element.clientWidth,e.clientHeight=e.element.clientHeight,e.contentDiv.style.width=e.clientWidth*e.viewElements.length+"px",e.contentDiv.style.height="100%",e.contentDiv.style.position="relative",e.viewWidth=e.clientWidth,i=0;i<e.viewElements.length;i++){var s=document.createElement("div");s.style.width=e.clientWidth+"px",s.style.height="100%",s.style.cssFloat="left",s.appendChild(e.viewElements[i]),e.contentDiv.appendChild(s)}}(this),this.parseChildren(this.contentDiv,e)},onInit:function(){var e=this;this.mover=new shmi.visuals.gfx.Movable(this.contentDiv),this.mover.rotatable=!1,this.mover.scalable=!1,this.mover.priority=!0;var on_resize=function(){e.ignoreResize||(clearTimeout(e.resizeTO),e.resizeTO=setTimeout((function(){e.updateSize()}),shmi.c("ACTION_RETRY_TIMEOUT")))};e.eHandlers=e.eHandlers||{},window.addEventListener("resize",on_resize,!1),window.addEventListener("visuals-layout-change",on_resize,!1),e.eHandlers.resize=on_resize;var t=function(e){this.active&&shmi.hasClass(e.target,"open")&&(clearTimeout(this.resizeTO),this.resizeTO=setTimeout(this.updateSize.bind(this),shmi.c("ACTION_RETRY_TIMEOUT")),shmi.log("[Panel] transition-end target: "+e.target,shmi.c("LOG_INFO")))}.bind(this);if(document.documentElement.addEventListener("transitionend",t,!1),document.documentElement.addEventListener("webkitTransitionEnd",t,!1),document.documentElement.addEventListener("oTransitionEnd",t,!1),e.eHandlers.transitionEnd=t,!this.config["disable-swipe"]){var i={};i.onDrag=function(e,t,i){var s=Math.abs(t);Math.abs(e)>s&&(i.preventDefault(),this.mover.tx+e<-this.clientWidth*(this.viewElements.length-1)?this.mover.translate(e/5,0):this.mover.tx+e>0?this.mover.translate(e/5,0):this.mover.translate(e,0),this._dragging||(this._dragging=!0,document.activeElement!==document.body&&document.activeElement.blur(),this.showNeighbors()))}.bind(this),i.onPress=function(){if(this.updateSize(),this.mover.setTransition(!1),document.activeElement!==document.body)try{document.activeElement.blur()}catch(e){}}.bind(this),i.onRelease=function(){if(this._dragging){this._dragging=!1;var t=this.currentView,i=this.currentView,s=this.currentView*this.viewWidth+this.mover.tx;s>.2*this.viewWidth?i=this.currentView-1:s<-.2*this.viewWidth&&(i=this.currentView+1),i>=0&&i<this.viewElements.length&&(this.currentView!==i&&(this.nextView=i,this.history.push(this.currentView)),this.currentView=i,this.config.item&&shmi.visuals.session.ItemManager.writeValue(this.config.item,i),!this.navInited&&this.config["nav-name"]&&(this.navInited=!0,this.nav=shmi.getControlByName(this.config["nav-name"])),this.nav&&this.nav.setActive(this.currentView));var n=-1*this.currentView*this.viewWidth,a=this.controls[this.currentView],l={index:this.currentView,old_index:t};e.isActive()&&(e.controls[t]&&e.controls[t].isActive()&&e.controls[t].disable(),a.enable(),this.fire("navigate",l)),this.anim.setCurrentValue(this.mover.tx),this.anim.start(n,this.config["anim-duration"])}}.bind(this),this.mouseListener=new shmi.visuals.io.MouseListener(this.contentDiv,i),this.touchListener=new shmi.visuals.io.TouchListener(this.contentDiv,i),this.touchListener.prevent_drag_scroll_y=!1}this.config["show-indicator"]&&(this.indicator=new shmi.visuals.controls.panel.PanelIndicator(this),shmi.addClass(this.element,"show-indicator")),this.updateVisibility(),e.viewElements.length>e.config["initial-view"]&&e.currentView===e.nextView&&e.setView(e.config["initial-view"]),shmi.log("[Panel] "+this.config.name+" created",shmi.c("LOG_INFO"))},updateVisibility:function(){shmi.log("[Panel] update visibility -  start",shmi.c("LOG_DEBUG"));for(var e=0;e<this.viewElements.length&&e<this.controls.length;e++)e!==this.currentView?shmi.addClass(this.viewElements[e],"hidden"):shmi.removeClass(this.viewElements[e],"hidden");this.config["show-indicator"]&&(this.indicator.setSelected(this.currentView),this.indicator.refresh()),shmi.log("[Panel] update visibility -  end",shmi.c("LOG_DEBUG"))},updatePosition:function(e){this.mover.tx=e,this.mover.draw()},transitionComplete:function(){this.updateVisibility()},showNeighbors:function(){this.currentView-1>=0&&shmi.removeClass(this.viewElements[this.currentView-1],"hidden"),this.currentView+1<this.viewElements.length&&shmi.removeClass(this.viewElements[this.currentView+1],"hidden")},setView:function(e){if((e<0||e>=this.viewElements.length)&&(e=0),e!==Number(this.currentView)&&(this.nextView=e,this.initialized)){this.backPushed?this.backPushed=!1:this.history.push(this.currentView);var t=this.currentView;this.currentView=e,this.config.item&&shmi.visuals.session.ItemManager.writeValue(this.config.item,e);var i=this.controls[e],s={index:e,old_index:t};shmi.removeClass(this.viewElements[this.currentView],"hidden"),this.isActive()&&(this.controls[t]&&this.controls[t].isActive()&&this.controls[t].disable(),i.enable(),this.fire("navigate",s));var n=-1*this.currentView*this.viewWidth;this.anim.setCurrentValue(this.mover.tx),!0===this.config.animate?this.anim.start(n,this.config["anim-duration"]):this.anim.start(n,0),shmi.log("[Panel '"+this.config.name+"'] view "+e+" set",shmi.c("LOG_INFO"))}},back:function(){this.history.length>0?(this.backPushed=!0,this.setView(this.history.pop())):shmi.log("[Panel] history is empty, cannot go back",shmi.c("LOG_INFO"))},onEnable:function(){var e=this;e.indicator&&(e.indicator.updateWidth(),e.indicator.refresh()),shmi.onVisible(e.element,(function(){e.updateSize()})),!this.config["disable-swipe"]&&this.mouseListener&&this.touchListener&&(this.mouseListener.enable(),this.touchListener.enable()),this.config.item&&(this._subscriptionTargetId=shmi.visuals.session.ItemManager.subscribeItem(this.config.item,this)),e.currentView!==e.nextView?e.setView(e.nextView):e.controls[e.currentView]&&e.controls[e.currentView].enable()},onDisable:function(){void 0!==this.controls[this.currentView]&&this.controls[this.currentView].disable(),!this.config["disable-swipe"]&&this.mouseListener&&this.touchListener&&(this.mouseListener.disable(),this.touchListener.disable()),this.config.item&&shmi.visuals.session.ItemManager.unsubscribeItem(this.config.item,this._subscriptionTargetId),this.anim.stop()},onLock:function(){!this.config["disable-swipe"]&&this.mouseListener&&this.touchListener&&(this.mouseListener.disable(),this.touchListener.disable()),this.indicator&&this.indicator.lock(),this.controls.forEach((function(e){e.lock()}))},onUnlock:function(){!this.config["disable-swipe"]&&this.mouseListener&&this.touchListener&&this.active&&(this.mouseListener.enable(),this.touchListener.enable()),this.indicator&&this.active&&this.indicator.unlock(),this.controls.forEach((function(e){e.unlock()}))},onSetValue:function(e){e=parseInt(e),isNaN(e)||this.setView(e)},updateSize:function(){var e=this;if(e.active){if(shmi.log("[Panel] resizing panel...",shmi.c("LOG_DEBUG")),e.clientWidth=e.element.clientWidth,e.clientHeight=e.element.clientHeight,!e.contentDiv)return clearTimeout(e.update_retry_TO),void(e.update_retry_TO=setTimeout((function(){e.updateSize()}),shmi.c("RETRY_TIMEOUT")));e.contentDiv.style.width=e.clientWidth*e.viewElements.length+"px",e.contentDiv.style.height="100%",e.viewWidth=e.clientWidth;for(var t=0;t<e.viewElements.length;t++){var i=e.viewElements[t].parentNode;i.style.width=e.clientWidth+"px",i.style.height="100%"}var s=-1*e.currentView*e.viewWidth;e.anim.setCurrentValue(s),e.updateVisibility(),e.updatePosition(s),function notifyResize(e){const t=document.createEvent("Event");e.ignoreResize=!0,t.initEvent("resize",!0,!0),window.dispatchEvent(t),e.ignoreResize=!1}(e)}},onDelete:function(){this.eHandlers&&(window.removeEventListener("resize",this.eHandlers.resize,!1),window.removeEventListener("visuals-layout-change",this.eHandlers.resize,!1),document.documentElement.removeEventListener("transitionend",this.eHandlers.transitionEnd,!1),document.documentElement.removeEventListener("webkitTransitionEnd",this.eHandlers.transitionEnd,!1),document.documentElement.removeEventListener("oTransitionEnd",this.eHandlers.transitionEnd,!1)),this.anim.stop()},onAddControl:function(e,t){var i=this,s=shmi.requires("visuals.tools.controller"),n=[],a=null;if(!i.initialized)throw new Error("Control not initialized yet.");Array.isArray(e)||(e=[e]),e.some((function(e){return"view"!==e.ui}))?t(new Error("All children must be of type 'view'"),n):(e.forEach((function(e){var t=null,s=document.createElement("div");s.style.width=i.clientWidth+"px",s.style.height="100%",s.style.cssFloat="left",i.contentDiv.appendChild(s),e.config.index=i.controls.length,null!==(t=shmi.createControl(e.ui,s,e.config,"DIV",null,!1))&&(e.style&&"object"==typeof e.style&&shmi.requires("visuals.tools.iterate.iterateObject")(e.style,(e,i)=>{t.element.style[i]=e}),shmi.addClass(t.element,"hidden"),i.viewElements.push(t.element),n.push(t))})),i.updateSize(),(a=shmi.waitOnInit(n,(function(){var l=-1,o=[],r=shmi.requires("visuals.task"),c=[],u=null;a&&(-1!==(l=i._init_.tokens.indexOf(a))&&i._init_.tokens.splice(l,1),a.unlisten(),a=null),e.forEach((function(e,t){var i=null,a=n[t];e.controller&&s.create(e.controller.name,e.controller,a.getName()),Array.isArray(e.children)&&e.children.length&&((i=r.createTask("child control")).run=function(){a.addControl(e.children,(function(e,t){e&&o.push(e),i.complete()}))},c.push(i))})),c.length?((u=r.createTaskList(c,!1)).onComplete=function(){i.controls.length&&i.controls.length===n.length&&i.setView(i.config["initial-view"]),i.indicator&&i.indicator.update(),t(o.length?o[0]:null,n)},u.run()):(i.controls.length&&i.controls.length===n.length&&i.setView(i.config["initial-view"]),i.indicator&&i.indicator.update(),t(o.length?o[0]:null,n))})))&&i._init_.tokens.push(a))}},shmi.extend(shmi.visuals.controls.Panel,shmi.visuals.core.BaseControl),shmi.pkg("visuals.controls.panel"),shmi.visuals.controls.panel.PanelIndicator=function(e){var t=document.createElement("div"),i=document.createElement("div");void 0!==e?(this.panel=e,this.template=document.createElement("div"),t.setAttribute("data-ui","indicator"),t.setAttribute("class","indicator"),i.setAttribute("class","indicator-graphic"),t.appendChild(i),this.template.appendChild(t),this.element=document.createElement("div"),this.element.setAttribute("data-ui","panel-indicator"),this.indicatorElements=[],this.listeners=[],this.selected=0,this.init()):shmi.log("[PanelIndicator] panel not found",3)},shmi.visuals.controls.panel.PanelIndicator.prototype={update:function(){this.listeners.forEach((function(e){e.disable()})),this.listeners=[],this.indicatorElements=[],this.element.parentNode===this.panel.element&&this.panel.element.removeChild(this.element),this.element.innerHTML="",this.init(),this.setSelected(this.selected)},init:function(){var e=this;if(e.indicator=shmi.getUiElement("indicator",this.template),e.indicator){e.listeners.forEach((function(e){e.disable()})),e.listeners=[],e.panel.controls.forEach((function(t,i){var s=e.indicator.cloneNode(!0),n=shmi.requires("visuals.io");e.element.appendChild(s),e.indicatorElements.push(s);var a={onClick:function(){e.panel.setView(i)}};e.listeners.push(new n.MouseListener(s,a)),e.listeners.push(new n.TouchListener(s,a)),i===Number(e.panel.currentView)&&(shmi.addClass(s,"active"),e.selected=i)})),e.panel.listen("enable",(function(){e.listeners.forEach((function(e){e.enable()}))})),e.panel.listen("disable",(function(){e.listeners.forEach((function(e){e.disable()}))})),e.panel.active&&e.listeners.forEach((function(e){e.enable()}));var t=document.createElement("div");t.style.clear="both",e.element.appendChild(t),e.panel.element.appendChild(e.element),e.updateWidth()}else shmi.log("[PanelIndicator] indicator element not found in template",3)},updateWidth:function(){shmi.addClass(this.element,"indicator-container")},refresh:function(){},setSelected:function(e){this.selected=Number(e);for(var t=0;t<this.indicatorElements.length;t++)t===e?shmi.addClass(this.indicatorElements[t],"active"):shmi.removeClass(this.indicatorElements[t],"active")},lock:function(){this.listeners.forEach((function(e){e.disable()}))},unlock:function(){this.listeners.forEach((function(e){e.enable()}))}},shmi.pkg("visuals.controls"),shmi.visuals.controls.PopupMenu=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","popup-menu"),shmi.def(this.config,"template","default/popup-menu"),shmi.def(this.config,"name",null),shmi.def(this.config,"content-template",null),shmi.def(this.config,"auto-close",!1),shmi.def(this.config,"tab-limit",!0),"false"===this.config["auto-close"]&&(this.config["auto-close"]=!1),this.controls=[],this.opened=!1,this.locked=!1,this.cls=[],this.listeners=[],this.tokens=[],this.menu_background=null,this.menu_content=null,this.startup()},shmi.visuals.controls.PopupMenu.prototype={uiType:"popup-menu",events:["open","close"],isContainer:!0,getClassName:function(){return"PopupMenu"},onRegister:function(e){var t=this;if(shmi.addClass(t.element,"hidden"),t.menu_background=shmi.getUiElement("menu-background",t.element),t.menu_content=shmi.getUiElement("menu-content",t.element),t.config["content-template"]){var i=0===t.config["content-template"].indexOf(shmi.c("RES_URL_PREFIX"))?t.config["content-template"]:shmi.c("TEMPLATE_PATH")+t.config["content-template"]+shmi.c("TEMPLATE_EXT");shmi.loadResource(i,(function(i,s,n){t.isDeleted()||(!s&&t.menu_content?(t.menu_content.innerHTML=i,t.parseChildren(t.menu_content,e)):e())}))}else t.menu_content?t.parseChildren(t.menu_content,e):e()},onInit:function(){var e=this;if(this.menu_background){var t={onClick:function(t,i,s){e.close()}},i=shmi.visuals.io,s=new i.MouseListener(this.menu_background,t),n=new i.TouchListener(this.menu_background,t);this.listeners.push(s),this.listeners.push(n)}else shmi.notify("${V_MISSING_UI_ELEMENT} 'menu-background'","${V_ERROR}");this.menu_content||shmi.notify("${V_MISSING_UI_ELEMENT} 'menu-content'","${V_ERROR}")},onEnable:function(){for(var e=this,t=0;t<e.listeners.length;t++)e.listeners[t].enable();e.config["auto-close"]&&e.tokens.push(shmi.listen("click",(function(t){t.source&&t.source.element&&shmi.testParentChild(e.element,t.source.element)&&e.close()})))},onDisable:function(){this.close();for(var e=0;e<this.listeners.length;e++)this.listeners[e].disable();this.tokens.forEach((function(e){e.unlisten()})),this.tokens=[]},onSetValue:function(){},onLock:function(){this.listeners.forEach((function(e){e.disable()})),this.locked=!0},onUnlock:function(){this.listeners.forEach((function(e){e.enable()})),this.locked=!1},open:function(){if(this.active&&!this.opened){this.opened=!0,shmi.removeClass(this.element,"hidden"),this.fire("open",{});for(var e=0;e<this.controls.length;e++)this.controls[e].enable();if(this.config["tab-limit"]){var t=shmi.requires("visuals.tools.tabulator");this.tabLimit=t.setTabParent(this.element)}}},close:function(){if(this.opened){this.opened=!1,shmi.addClass(this.element,"hidden"),this.fire("close",{});for(var e=0;e<this.controls.length;e++)this.tabLimit&&(this.tabLimit.unsetTabParent(),this.tabLimit=null),this.controls[e].disable()}},toggle:function(){this.opened?this.close():this.open()},onAddControl:function(e,t){var i=this,s=shmi.requires("visuals.tools.controller"),n=[],a=null;if(!i.initialized)throw new Error("Control not initialized yet.");Array.isArray(e)||(e=[e]),e.forEach((function(e){var t=shmi.createControl(e.ui,i.menu_content,e.config,"DIV",null,!1);if(null!==t){if(e.style&&"object"==typeof e.style){shmi.requires("visuals.tools.iterate.iterateObject")(e.style,(e,i)=>{t.element.style[i]=e})}n.push(t)}})),(a=shmi.waitOnInit(n,(function(){var l=-1,o=[],r=shmi.requires("visuals.task"),c=[],u=null;a&&(-1!==(l=i._init_.tokens.indexOf(a))&&i._init_.tokens.splice(l,1),a.unlisten(),a=null),e.forEach((function(e,t){var a=null,l=n[t];e.controller&&s.create(e.controller.name,e.controller,l.getName()),i.isActive()&&i.opened&&l.enable(),Array.isArray(e.children)&&e.children.length&&((a=r.createTask("child control")).run=function(){l.addControl(e.children,(function(e,t){e&&o.push(e),a.complete()}))},c.push(a))})),c.length?((u=r.createTaskList(c,!1)).onComplete=function(){t(o.length?o[0]:null,n)},u.run()):t(o.length?o[0]:null,n)})))&&i._init_.tokens.push(a)}},shmi.visuals.session.userActions=shmi.visuals.session.userActions||{},shmi.visuals.session.userActions["popup-menu"]=function(e,t,i,s,n){var a;if(e.length<2)shmi.log("[UserAction] popup-menu - needs two parameters",2);else if(a=3===e.length&&"relative"===e[2]?shmi.ctrl(e[0],n):shmi.ctrl(e[0]))try{"open"===e[1]?(a.open(),shmi.log("[UserAction] popup-menu - opened",2)):"close"===e[1]?(a.close(),shmi.log("[UserAction] popup-menu - closed",2)):"toggle"===e[1]&&(a.toggle(),shmi.log("[UserAction] popup-menu - toggled",2))}catch(e){shmi.log("[UserAction] exception opening / closing popup-menu: "+e,2)}else shmi.log("[UserAction] popup-menu - no element found by name '"+e[0]+"'",2)},shmi.extend(shmi.visuals.controls.PopupMenu,shmi.visuals.core.BaseControl),function(){"use strict";var e=shmi.requires("visuals.tools.logging").createLogger("progress-info",!0,!1),t=e.fLog;e.log;function updateBar(e){var t=calcPercentValue(e.vars.items.baseItem,e.vars.items.comparisonItem);e.vars.elements.barEl.style.width=t+"%"}function formatString(e){var t=e.config.displayFormat,i=formatValue(e,e.vars.items.baseItem),s=formatValue(e,e.vars.items.comparisonItem),n=calcPercentValue(e.vars.items.baseItem,e.vars.items.comparisonItem);return t=(t=(t=t.replace("$baseItem",'<span class="baseValue">'+i+"</span>")).replace("$comparisonItem",'<span class="compareValue">'+s+"</span>")).replace("$percentValue",'<span class="percentValue">'+n+"</span>")}function formatValue(e,t){var i=t;return!0===e.config["auto-precision"]?i=t.toFixed(2):(-1===e.config.precision&&(e.config.precision=0),i=t.toFixed(e.config.precision)),","===e.config["decimal-delimiter"]?i=i.replace(".",e.config["decimal-delimiter"]):"."===e.config["decimal-delimiter"]&&(i=i.replace(",",e.config["decimal-delimiter"])),i}function calcPercentValue(e,t){return 0===t&&0===e?NaN:0===t?1/0:Math.round(e/t*100)}var i={className:"progress-info",uiType:"progress-info",isContainer:!1,config:{"class-name":"progress-info",name:null,template:"default/progress-info","decimal-delimiter":".",precision:-1,"auto-precision":!0,baseItem:null,comparisonItem:null,displayFormat:"( $baseItem / $comparisonItem ) $percentValue %",displayOptions:2,barThickness:5},configSchema:null,vars:{listener:[],elements:{textContainerEl:null,barEl:null,barContainerEl:null},handler:{},items:{},subscriberTokens:[]},imports:{im:"visuals.session.ItemManager",io:"visuals.io"},events:[],prototypeExtensions:{onInit:function(){var e=this,i=e.vars.elements,s=e.vars.handler,n=e.imports.im;shmi.getUiElement("progress-info-text",e.element)&&shmi.getUiElement("progress-info-bar-container",e.element)&&shmi.getUiElement("progress-info-bar",e.element)?(i.textContainerEl=shmi.getUiElement("progress-info-text",e.element),i.barContainerEl=shmi.getUiElement("progress-info-bar-container",e.element),i.barEl=shmi.getUiElement("progress-info-bar",e.element),0===e.config.displayOptions?(i.barContainerEl.style.display="none",i.barContainerEl.style.height=0):1===e.config.displayOptions&&(i.textContainerEl.style.display="none",i.textContainerEl.style.height=0),/^[0-9]+$/.test(e.config.barThickness)&&(i.barEl.style.height=e.config.barThickness+"px"),s.baseItemHandler=n.getItemHandler(),s.compItemHandler=n.getItemHandler(),s.baseItemHandler.setValue=function(s){if(e.vars.items.baseItem=s,"number"==typeof e.vars.items.baseItem&&"number"==typeof e.vars.items.comparisonItem)switch(e.config.displayOptions){case 0:i.textContainerEl.innerHTML=formatString(e);break;case 1:updateBar(e);break;case 2:i.textContainerEl.innerHTML=formatString(e),updateBar(e);break;default:t("Invalid option in Display Options!")}else t("Please use a valid integer or float Base-Item and Comparison-Item!")},s.compItemHandler.setValue=function(s){if(e.vars.items.comparisonItem=s,"number"==typeof e.vars.items.baseItem&&"number"==typeof e.vars.items.comparisonItem)switch(e.config.displayOptions){case 0:i.textContainerEl.innerHTML=formatString(e);break;case 1:updateBar(e);break;case 2:i.textContainerEl.innerHTML=formatString(e),updateBar(e);break;default:t("Invalid option in Display Options!")}else t("Please use a valid integer or float Base-Item and Comparison-Item!")}):t('Cannot find the container element! Please make sure that the given template consists at least of a DIV container with the class attribute "progress-info-text", "progress-info-bar-container" and "progress-info-bar".')},onEnable:function(){var e=this.imports.im,t=this.config,i=this.vars.handler,s=this.vars.subscriberTokens;t.baseItem&&s.push(e.subscribeItem(t.baseItem,i.baseItemHandler)),t.comparisonItem&&s.push(e.subscribeItem(t.comparisonItem,i.compItemHandler))},onDisable:function(){this.vars.subscriberTokens.forEach((function(e){e.unlisten()})),this.vars.subscriberTokens=[]}}};shmi.requires("visuals.tools.control-generator").generate(i)}(),shmi.pkg("visuals.controls"),shmi.visuals.controls.ProjectWindow=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","project-window"),shmi.def(this.config,"template","default/project-window"),shmi.def(this.config,"name",null),shmi.def(this.config,"initial-state","open"),shmi.def(this.config,"label","LABEL"),shmi.def(this.config,"alt-label",null),shmi.def(this.config,"content-template",null),this._open=!1,this.initialized=!1,this.contentTemplate=null,this.contentWrapper=null,this.controls=[],this.listeners=[],this.startup()},shmi.visuals.controls.ProjectWindow.prototype={uiType:"project-window",isContainer:!0,getClassName:function(){return"ProjectWindow"},onRegister:function(e){var t=this;if(t.contentElement=shmi.getUiElement("content",t.element),t.contentWrapper=shmi.getUiElement("content-wrapper",t.element),t.config["content-template"]){var i=0===t.config["content-template"].indexOf(shmi.c("RES_URL_PREFIX"))?t.config["content-template"]:shmi.c("TEMPLATE_PATH")+t.config["content-template"]+shmi.c("TEMPLATE_EXT");shmi.loadResource(i,(function(i,s,n){t.isDeleted()||(!s&&t.contentElement?(t.contentElement.innerHTML=i,t.parseChildren(t.contentElement,e)):e())}))}else t.contentElement?t.parseChildren(t.contentElement,e):e()},onInit:function(){var e=this,t=shmi.getUiElement("label",e.element),i=shmi.getUiElement("header",e.element),s=shmi.getUiElement("label-2",e.element);if(s&&e.config["alt-label"]&&(s.textContent=shmi.localize(e.config["alt-label"])),t&&i){t.textContent=shmi.localize(e.config.label);var n={onClick:function(t,i,s){e._open?e.close():e.open()}},a=shmi.visuals.io,l=new a.MouseListener(i,n),o=new a.TouchListener(i,n);e.listeners.push(l,o)}else t||shmi.notify("[ProjectWindow] template missing 'label' ui-element ("+e.config.template+")","Template Error"),i?shmi.notify("[ProjectWindow] template missing ui-element ("+e.config.template+")","Template Error"):shmi.notify("[ProjectWindow] template missing 'header' ui-element ("+e.config.template+")","Template Error");"open"===e.config["initial-state"]?e.open():shmi.addClass(e.element,"minimized")},open:function(){this._open||(this._open=!0,shmi.removeClass(this.element,"minimized"))},close:function(){this._open&&(this._open=!1,shmi.addClass(this.element,"minimized"))},onEnable:function(){this.listeners.forEach((function(e){e.enable()})),this.controls.forEach((function(e){e.enable()})),shmi.log("[ProjectWindow] enabled",1)},onDisable:function(){this.listeners.forEach((function(e){e.disable()})),this.controls.forEach((function(e){e.disable()})),shmi.log("[ProjectWindow] disabled",1)},onLock:function(){this.listeners.forEach((function(e){e.disable()})),this.controls.forEach((function(e){e.lock()})),this.locked=!0,shmi.addClass(this.element,"locked"),shmi.log("[ProjectWindow] locked",1)},onUnlock:function(){this.listeners.forEach((function(e){e.enable()})),this.controls.forEach((function(e){e.unlock()})),this.locked=!1,shmi.removeClass(this.element,"locked"),shmi.log("[ProjectWindow] locked",1)},onSetValue:function(e){shmi.log("[ProjectWindow] value set: "+e,0)},setLabel:function(e){var t=shmi.getUiElement("label",this.element);t&&(t.textContent=shmi.localize(e))},onAddControl:function(e,t){var i=this,s=shmi.requires("visuals.tools.controller"),n=[],a=null;if(!i.initialized)throw new Error("Control not initialized yet.");Array.isArray(e)||(e=[e]),e.forEach((function(e){var t=shmi.createControl(e.ui,i.contentElement,e.config,"DIV",null,!1);if(null!==t){if(e.style&&"object"==typeof e.style){shmi.requires("visuals.tools.iterate.iterateObject")(e.style,(e,i)=>{t.element.style[i]=e})}n.push(t)}})),(a=shmi.waitOnInit(n,(function(){var l=-1,o=[],r=shmi.requires("visuals.task"),c=[],u=null;a&&(-1!==(l=i._init_.tokens.indexOf(a))&&i._init_.tokens.splice(l,1),a.unlisten(),a=null),e.forEach((function(e,t){var a=null,l=n[t];e.controller&&s.create(e.controller.name,e.controller,l.getName()),i.isActive()&&l.enable(),Array.isArray(e.children)&&e.children.length&&((a=r.createTask("child control")).run=function(){l.addControl(e.children,(function(e,t){e&&o.push(e),a.complete()}))},c.push(a))})),c.length?((u=r.createTaskList(c,!1)).onComplete=function(){t(o.length?o[0]:null,n)},u.run()):t(o.length?o[0]:null,n)})))&&i._init_.tokens.push(a)}},shmi.extend(shmi.visuals.controls.ProjectWindow,shmi.visuals.core.BaseControl),function(){"use strict";var e="quality-display",t={"class-name":e,name:e,template:"default/quality-display",item:"DSaw1",min:-100,warnMin:-80,preWarnMin:-50,preWarnMax:50,warnMax:80,max:100,"anim-time":300,precision:1,unit:"",label:"Label","display-act-value":!0,"display-set-value":!0,"icon-class":null,"icon-src":null,"auto-min":!0,"auto-max":!0,"auto-precision":!0,"auto-label":!0,"auto-unit":!0},i=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),s=(i.fLog,i.log,{className:"qualityDisplay",uiType:e,isContainer:!1,config:t,configSchema:null,vars:{labelElement:null,avElement:null,unitElement:null,arrowsElement:null,barElement:null,subIdValueItem:null,barMid:null,setCache:null,valCache:null,tokens:[]},imports:{im:"visuals.session.ItemManager"},prototypeExtensions:{onInit:function(){if(this.vars.labelElement=shmi.getUiElement("label",this.element),this.vars.avElement=shmi.getUiElement("actual-value",this.element),this.vars.spElement=shmi.getUiElement("set-point-value",this.element),this.vars.unitElement=shmi.getUiElement("actual-value-unit",this.element),this.vars.arrowsElement=shmi.getUiElement("set-value",this.element),this.vars.handleElement=shmi.getUiElement("value-display-handle",this.element),this.vars.valueContainer=shmi.getUiElement("value-display-container",this.element),this.vars.barElement=shmi.getUiElement("deviation",this.element),this.vars.refBar=shmi.getUiElement("ref-bar",this.element),this.vars.anim=new shmi.visuals.gfx.Animation(this.updateBar.bind(this)),this.vars.labelElement&&(this.vars.labelElement.textContent=shmi.localize(this.config.label)),this.vars.unitElement&&(this.vars.unitElement.textContent=shmi.localize(this.config.unit)),(this.config["icon-class"]||this.config["icon-src"])&&(this.iconElement=shmi.getUiElement("icon",this.element),this.iconContainerElement=shmi.getUiElement("icon-container",this.element),this.iconContainerElement.style.display="flex",this.config["icon-class"]&&shmi.addClass(this.iconElement,this.config["icon-class"]),this.config["icon-src"])){var e=document.createElement("img");e.setAttribute("src",this.config["icon-src"]),this.iconElement.appendChild(e),this.config["icon-class"]&&(e.style.display="none")}!1===this.config["display-act-value"]&&this.vars.valueContainer&&(this.vars.valueContainer.style.display="none"),!1===this.config["display-set-value"]&&this.vars.arrowsElement&&(this.vars.arrowsElement.style.display="none"),this.updateArrow(0,100,50),this.updateBar(50)},onEnable:function(){var e=this,t=e.imports.im.getItemHandler();t.setValue=function(t,i,s){var n=t;null!==t&&(e.vars.valCache=t,-1===e.config.precision&&(e.config.precision=0),e.vars.avElement&&(e.vars.avElement.textContent=t.toFixed(e.config.precision)),null!==n&&e.vars.anim.start(n,e.config["anim-time"]))},t.setProperties=function(t,i,s,n,a,l,o,r,c,u){var h=shmi.requires("visuals.tools.numericValues");h.setProperties(e,arguments),e.vars.valueSettings&&(e.config.min=e.vars.valueSettings.min,e.config.max=e.vars.valueSettings.max,e.config.precision=e.vars.valueSettings.precision),e.config.warnMin=l,e.config.preWarnMin=r,e.config.warnMax=o,e.config.preWarnMax=c,void 0!==e.vars.setCache&&e.updateArrow(e.config.min,e.config.max,e.vars.setCache),void 0!==e.vars.valCache&&null!==e.vars.valCache&&(e.vars.avElement&&(e.vars.avElement.textContent=e.vars.valCache.toFixed(e.config.precision)),e.vars.anim.start(e.vars.valCache,e.config["anim-time"]))},t.setLabel=function(t){e.config["auto-label"]&&e.vars.labelElement&&(e.vars.labelElement.textContent=shmi.localize(t))},t.setUnitText=function(t){e.config["auto-unit"]&&e.vars.unitElement&&(e.vars.unitElement.textContent=shmi.localize(t))},e.config.item&&e.config["value-item"]&&(e.vars.subIdValueItem=e.imports.im.subscribeItem(e.config.item,e),e.vars.tokens.push(e.imports.im.subscribeItem(e.config["value-item"],t)))},onDisable:function(){this.vars.subIdValueItem&&(this.vars.subIdValueItem.unlisten(),this.vars.subIdValueItem=null),this.vars.tokens.forEach((function(e){e.unlisten()})),this.vars.tokens=[],this.vars.anim.stop()},setValueElement:function(e){-1===this.config.precision&&(this.config.precision=0),this.vars.spElement&&(this.vars.spElement.textContent=e.toFixed(this.config.precision)),this.updateArrow(this.config.min,this.config.max,e),this.vars.setCache=e,void 0!==this.vars.valCache&&this.vars.anim.start(this.vars.valCache,this.config["anim-time"])},onSetProperties:function(e,t,i,s,n,a,l,o,r,c){void 0!==this.vars.setCache&&this.updateArrow(this.config.min,this.config.max,this.vars.setCache),void 0!==this.vars.valCache&&null!==this.vars.valCache&&(this.vars.avElement&&(this.vars.avElement.textContent=this.vars.valCache.toFixed(this.config.precision)),this.vars.anim.start(this.vars.valCache,this.config["anim-time"]))},onSetValue:function(e,t,i){this.vars.setValue=e,this.setValueElement(e)},updateBar:function(e){if(null!==e&&void 0!==this.vars.setValue){shmi.hasClass(this.element,"preWarn")&&shmi.removeClass(this.element,"preWarn"),shmi.hasClass(this.element,"warn")&&shmi.removeClass(this.element,"warn"),"number"==typeof this.config.preWarnMax&&"number"==typeof this.config.preWarnMin&&(e>this.config.preWarnMax||e<this.config.preWarnMin)&&(shmi.hasClass(this.element,"preWarn")||shmi.addClass(this.element,"preWarn")),"number"==typeof this.config.warnMax&&"number"==typeof this.config.warnMin&&(e>this.config.warnMax||e<this.config.warnMin)&&(shmi.hasClass(this.element,"warn")||shmi.addClass(this.element,"warn")),e>this.config.max&&(e=this.config.max),e<this.config.min&&(e=this.config.min);var t=e-this.vars.setValue,i=this.config.min,s=this.config.max;t=i===s?100:0!==t?t/(s-i)*100:0,this.vars.barElement&&(e-this.vars.setValue<=0?(this.vars.barElement.style.left=null,this.vars.barElement.style.right=100-this.vars.barMid+"%",this.vars.barElement.style.width=Math.abs(t)+"%"):(this.vars.barElement.style.right=null,this.vars.barElement.style.left=this.vars.barMid+"%",this.vars.barElement.style.width=Math.abs(t)+"%"))}},updateArrow:function(e,t,i){var s=i-e;this.vars.barMid=e===t?100:0!==s?s/(t-e)*100:0,this.vars.handleElement&&(this.vars.handleElement.style.left=this.vars.barMid+"%"),this.vars.arrowsElement&&(this.vars.arrowsElement.style.left=this.vars.barMid+"%")}}});shmi.requires("visuals.tools.control-generator").generate(s)}(),shmi.pkg("visuals.controls"),shmi.pkg("visuals.controls"),shmi.visuals.controls.RadialGauge=function(e,t){this.element=e,this.value=0,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","radial-gauge"),shmi.def(this.config,"template","default/radial-gauge"),shmi.def(this.config,"name",null),shmi.def(this.config,"min",0),shmi.def(this.config,"max",100),shmi.def(this.config,"step",0),shmi.def(this.config,"precision",-1),shmi.def(this.config,"type",shmi.c("TYPE_FLOAT")),shmi.def(this.config,"unit-scale",1),shmi.def(this.config,"min-rotation",-135),shmi.def(this.config,"max-rotation",135),shmi.def(this.config,"anim-time",250),shmi.def(this.config,"label","radial-gauge"),shmi.def(this.config,"unit-text",null),shmi.def(this.config,"decimal-delimiter","."),shmi.def(this.config,"auto-min",!0),shmi.def(this.config,"auto-max",!0),shmi.def(this.config,"auto-step",!0),shmi.def(this.config,"auto-precision",!0),shmi.def(this.config,"auto-type",!0),shmi.def(this.config,"auto-label",!0),shmi.def(this.config,"auto-unit-text",!0),this.labelElement=null,this.valueElement=null,this.unitElement=null,this.handleElement=null,this.requestAnimId=null,this._subscriptionTargetId=null,this.active=!1,this.anim=new shmi.visuals.gfx.Animation(this.updateHandle.bind(this)),this.startup()},shmi.visuals.controls.RadialGauge.prototype={uiType:"radial-gauge",getClassName:function(){return"RadialGauge"},onInit:function(){shmi.requires("visuals.tools.numericValues").initValueSettings(this),this.labelElement=shmi.getUiElement("label",this.element),this.labelElement&&(this.labelElement.textContent=shmi.localize(this.config.label)),this.handleElement=shmi.getUiElement("handle",this.element),this.handleElement?(this.valueElement=shmi.getUiElement("value",this.element),this.valueElement?(this.unitElement=shmi.getUiElement("unit",this.element),this.unitElement?(shmi.log("[RadialGauge] -- all elements found --",0),this.config["unit-text"]&&(this.unitElement.textContent=shmi.localize(this.config["unit-text"])),this.config["unit-scale"]&&(this.config["unit-scale"]=parseFloat(shmi.localize(this.config["unit-scale"])))):shmi.log("[RadialGauge] no unit element provided",3)):shmi.log("[RadialGauge] no value element provided",3)):shmi.log("[RadialGauge] no handle element provided",3)},onSetValue:function(e){this.value=parseFloat(e),this.draw()},draw:function(){var e=this.vars.valueSettings,t=e.min,i=e.max,s=null;if(shmi.visuals.session.deactivateControls)return this.anim.stop(),void setTimeout(this.draw.bind(this),shmi.c("ACTION_RETRY_TIMEOUT"));shmi.caf(this.requestAnimId),this.requestAnimId=shmi.raf(this.updateText.bind(this)),s=i===t?this.config["max-rotation"]:this.config["min-rotation"]+(this.config["max-rotation"]-this.config["min-rotation"])/(i-t)*(this.value-t),this.anim.start(s,this.config["anim-time"])},updateText:function(){var e=shmi.requires("visuals.tools.numericValues");this.valueElement.textContent=e.formatOutput(this.value,this)},updateHandle:function(e){this.handleElement.style.webkitTransform="rotate3d(0,0,1,"+e.toFixed(3)+"deg)",this.handleElement.style.oTransform="rotate3d(0,0,1,"+e.toFixed(3)+"deg)",this.handleElement.style.msTransform="rotate3d(0,0,1,"+e.toFixed(3)+"deg)",this.handleElement.style.mozTransform="rotate3d(0,0,1,"+e.toFixed(3)+"deg)",this.handleElement.style.transform="rotate3d(0,0,1,"+e.toFixed(3)+"deg)"},onEnable:function(){this.config.item&&(this._subscriptionTargetId=shmi.visuals.session.ItemManager.subscribeItem(this.config.item,this)),shmi.log("[RadialGauge] enabled",1)},onDisable:function(){this.anim.stop(),this.config.item&&shmi.visuals.session.ItemManager.unsubscribeItem(this.config.item,this._subscriptionTargetId),shmi.log("[RadialGauge] disabled",1)},onLock:function(){},onUnlock:function(){},onSetProperties:function(e,t,i){var s=this,n=shmi.requires("visuals.tools.numericValues");n.setProperties(s,arguments),"number"==typeof s.value&&s.draw()},setLabel:function(e){this.config["auto-label"]&&this.labelElement&&(this.labelElement.textContent=shmi.localize(e))},setUnitText:function(e){this.config["auto-unit-text"]&&this.unitElement&&(this.unitElement.textContent=shmi.localize(e))}},shmi.extend(shmi.visuals.controls.RadialGauge,shmi.visuals.core.BaseControl),shmi.pkg("visuals.controls"),shmi.visuals.controls.RadialGauge2=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","radial-gauge2"),shmi.def(this.config,"template","default/radial-gauge2"),shmi.def(this.config,"name",null),shmi.def(this.config,"min",0),shmi.def(this.config,"max",100),shmi.def(this.config,"precision",-1),shmi.def(this.config,"type",shmi.c("TYPE_FLOAT")),shmi.def(this.config,"unit-scale",1),shmi.def(this.config,"min-rotation",0),shmi.def(this.config,"max-rotation",270),shmi.def(this.config,"anim-time",250),shmi.def(this.config,"dynamic-anim-time",!1),shmi.def(this.config,"label","radial-gauge2"),shmi.def(this.config,"unit-text",null),shmi.def(this.config,"decimal-delimiter","."),shmi.def(this.config,"auto-min",!0),shmi.def(this.config,"auto-max",!0),shmi.def(this.config,"auto-step",!0),shmi.def(this.config,"auto-precision",!0),shmi.def(this.config,"auto-type",!0),shmi.def(this.config,"auto-label",!0),shmi.def(this.config,"auto-unit-text",!0),this.value=0,this.valueElement=null,this.unitElement=null,this.handleElement=null,this.labelElement=null,this.requestAnimId=null,this._subscriptionTargetId=null,this.active=!1,this.anim=new shmi.visuals.gfx.Animation(this.updateHandle.bind(this)),this.vars={conditional:null},this.startup()},shmi.visuals.controls.RadialGauge2.prototype={uiType:"radial-gauge2",getClassName:function(){return"RadialGauge2"},onInit:function(){shmi.requires("visuals.tools.numericValues").initValueSettings(this),this.config["anim-time"]=parseInt(this.config["anim-time"]),"true"===this.config["dynamic-anim-time"]?this.config["dynamic-anim-time"]=!0:"false"===this.config["dynamic-anim-time"]&&(this.config["dynamic-anim-time"]=!1),this.handleElement=shmi.getUiElements("handle",this.element),this.handleElement?(this.highlightElement=shmi.getUiElement("highlight",this.element),this.highlightElement?(this.valueElement=shmi.getUiElement("value",this.element),this.valueElement?(this.unitElement=shmi.getUiElement("unit",this.element),this.unitElement?(this.labelElement=shmi.getUiElement("label",this.element),this.labelElement?this.config.label&&(this.labelElement.textContent=shmi.localize(this.config.label)):shmi.log("[RadialGauge2] no label element provided",1),shmi.log("[RadialGauge2] -- all elements found --",0),this.config["unit-text"]&&(this.unitElement.textContent=shmi.localize(this.config["unit-text"])),this.config["unit-scale"]&&(this.config["unit-scale"]=parseFloat(shmi.localize(this.config["unit-scale"])))):shmi.log("[RadialGauge2] no unit element provided",3)):shmi.log("[RadialGauge2] no value element provided",3)):shmi.log("[RadialGauge2] no highlight element provided",3)):shmi.log("[RadialGauge2] no handle element provided",3)},onSetValue:function(e){this.value=parseFloat(e),this.draw()},draw:function(){var e=this.vars.valueSettings,t=e.min,i=e.max,s=null;if(shmi.visuals.session.deactivateControls)return this.anim.stop(),void setTimeout(this.draw.bind(this),shmi.c("ACTION_RETRY_TIMEOUT"));shmi.caf(this.requestAnimId),this.requestAnimId=shmi.raf(this.updateText.bind(this)),s=i===t?this.config["max-rotation"]:this.config["min-rotation"]+(this.config["max-rotation"]-this.config["min-rotation"])/(i-t)*(this.value-t);var n=this.config["anim-time"];if(this.config.item){var a=shmi.visuals.session.ItemManager.items[this.config.item];void 0===a?shmi.log("[RadialCanvas] item '"+this.config.item+"' undefined in manager",1):n=!1===this.config["dynamic-anim-time"]||a.interval>this.config["anim-time"]?this.config["anim-time"]:Math.round(a.interval)}this.anim.start(s,n)},updateText:function(){var e=shmi.requires("visuals.tools.numericValues");this.valueElement.textContent=e.formatOutput(this.value,this)},updateHandle:function(e){e>270?e=270:e<0&&(e=0);var t=Math.floor(e/90),i=!1;void 0===this.h_stat&&(this.h_stat=[{full:!1},{full:!1},{full:!1}]);for(var s=0;s<this.handleElement.length;s++)if(s<t){if(!0===this.h_stat[s].full)continue;this.handleElement[s].style.webkitTransform="rotate3d(0,0,1,0deg)",this.handleElement[s].style.oTransform="rotate3d(0,0,1,0deg)",this.handleElement[s].style.msTransform="rotate3d(0,0,1,0deg)",this.handleElement[s].style.mozTransform="rotate3d(0,0,1,0deg)",this.handleElement[s].style.transform="rotate3d(0,0,1,0deg)",this.handleElement[s].style.display="block",this.h_stat[s].full=!0}else if(i)this.handleElement[s].style.display="none";else{!0===this.h_stat[s].full&&(this.h_stat[s].full=!1);var n=e%90-90;this.handleElement[s].style.webkitTransform="rotate3d(0,0,1,"+n.toFixed(3)+"deg)",this.handleElement[s].style.oTransform="rotate3d(0,0,1,"+n.toFixed(3)+"deg)",this.handleElement[s].style.msTransform="rotate3d(0,0,1,"+n.toFixed(3)+"deg)",this.handleElement[s].style.mozTransform="rotate3d(0,0,1,"+n.toFixed(3)+"deg)",this.handleElement[s].style.transform="rotate3d(0,0,1,"+n.toFixed(3)+"deg)",this.handleElement[s].style.display="block",i=!0}e-=180,this.highlightElement.style.webkitTransform="rotate3d(0,0,1,"+e.toFixed(3)+"deg)",this.highlightElement.style.oTransform="rotate3d(0,0,1,"+e.toFixed(3)+"deg)",this.highlightElement.style.msTransform="rotate3d(0,0,1,"+e.toFixed(3)+"deg)",this.highlightElement.style.mozTransform="rotate3d(0,0,1,"+e.toFixed(3)+"deg)",this.highlightElement.style.transform="rotate3d(0,0,1,"+e.toFixed(3)+"deg)"},onEnable:function(){null!==this.vars.conditional?this.vars.conditional.item!==this.config.item&&(this.vars.conditional.item=this.config.item):this.config.item&&(this.vars.conditional=shmi.createConditional(this.element,this.config.item)),this.vars.conditional&&this.vars.conditional.enable(),this.config.item&&(this._subscriptionTargetId=shmi.visuals.session.ItemManager.subscribeItem(this.config.item,this)),shmi.log("[RadialGauge2] enabled",1)},onDisable:function(){this.anim.stop(),this.vars.conditional&&this.vars.conditional.disable(),this.config.item&&shmi.visuals.session.ItemManager.unsubscribeItem(this.config.item,this._subscriptionTargetId),shmi.log("[RadialGauge2] disabled",1)},onLock:function(){},onUnlock:function(){},onSetProperties:function(e,t){var i=this,s=shmi.requires("visuals.tools.numericValues");s.setProperties(i,arguments),"number"==typeof i.value&&i.draw()},setLabel:function(e){this.config["auto-label"]&&this.labelElement&&(this.labelElement.textContent=shmi.localize(e))},setUnitText:function(e){this.config["auto-unit-text"]&&this.unitElement&&(this.unitElement.textContent=shmi.localize(e))}},shmi.extend(shmi.visuals.controls.RadialGauge2,shmi.visuals.core.BaseControl),function(){"use strict";var e="recipe-controller",t={"class-name":"RecipeController",name:null,template:"default/recipe-controller","recipe-select":null,"recipe-edit":null,"button-order":["add","clone","remove","edit","capture","apply"],"button-usage":{add:!0,clone:!0,remove:!0,edit:!0,capture:!0,apply:!0}},i=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1);i.fLog,i.log;function watchRecipeSelection(t,i){var s=null,n=null;if(t.vars.select.changeToken&&(t.vars.select.changeToken.unlisten(),t.vars.select.changeToken=null),i&&i.isActive()){const a="iq-recipe-list"===t.vars.selectUiType?"select":"change";t.vars.select.changeToken=i.listen(a,(function(e){console.log("recipe selection changed:",e),updateSelection(t,e.source.getValue()),updateButtonState(t)})),t.vars.select.control=i,t.vars.edit.control&&t.vars.edit.control.isActive()&&(s=i.getTemplate(),t.vars.select.selection&&(n=t.vars.select.selection.recipe_id),"number"==typeof s&&t.vars.edit.control.setTemplate(s,n,(function(){console.log(e,"template-ID set")}))),updateSelection(t,i.getValue())}else t.vars.select.control=null,t.vars.select.changeToken&&(t.vars.select.changeToken.unlisten(),t.vars.select.changeToken=null),updateSelection(t,null);updateButtonState(t)}function updateSelection(e,t){var i=e.vars.edit.control;t&&null!==t.recipe_id?(e.vars.select.selection=t,i&&i.editRecipe({mode:i.MODE.EDIT,recipe_id:t.recipe_id,preview:!0})):(e.vars.select.selection=null,i&&i.reset())}function watchRecipeEdit(t,i){var s=shmi.requires("visuals.tools.iterate").iterateObject,n=null,a=null;i&&i.isActive()?(t.vars.edit.control=i,t.vars.select.control&&(n=t.vars.select.control.getTemplate(),t.vars.select.selection&&(a=t.vars.select.selection.recipe_id),"number"==typeof n&&i.setTemplate(n,a,(function(){console.log(e,"template-ID set")}))),t.vars.edit.tokens.push(i.listen("start-edit",(function(){t.vars.select.control&&t.vars.select.control.lock(),s(t.vars.buttons,(function(e,t){e&&e.lock()}))}))),t.vars.edit.tokens.push(i.listen("stop-edit",(function(){t.vars.select.control&&(t.vars.select.control.unlock(),"function"==typeof t.vars.select.control.rebuildTable&&t.vars.select.control.rebuildTable()),updateButtonState(t)})))):(t.vars.edit.control=null,t.vars.edit.tokens.forEach((function(e){e.unlisten()})),t.vars.edit.tokens=[])}function lockButton(e,t){var i=e.vars.buttons;i[t]&&i[t].lock()}function unlockButton(e,t){var i=e.vars.buttons;i[t]&&i[t].unlock()}function updateButtonState(e){var t=e.vars.select.control,i=e.vars.edit.control,s=e.vars.select.selection;e.locked||(t&&s?(s.values_set?unlockButton(e,"apply"):lockButton(e,"apply"),unlockButton(e,"remove"),unlockButton(e,"capture")):(lockButton(e,"apply"),lockButton(e,"remove"),lockButton(e,"capture")),i?(s?(unlockButton(e,"edit"),unlockButton(e,"clone")):(lockButton(e,"edit"),lockButton(e,"clone")),unlockButton(e,"add")):(lockButton(e,"add"),lockButton(e,"edit"),lockButton(e,"clone")))}function doCapture(e,t){e.capture(null,(function(e){e&&shmi.notify("${recipe-controller.error.captureRecipe}","${V_ERROR}",{ERROR_CODE:e.errc,ERROR_MSG:e.message,ERROR_CAT:e.category}),"function"==typeof t&&t(e||null)}))}function fetchRecipe(e,t){shmi.requires("visuals.session.RecipeManager").getRecipe(e,(function(e,i){i?(shmi.notify("${recipe-controller.error.fetchRecipe}","${V_ERROR}",{ERROR_CODE:i.errc,ERROR_MSG:i.message,ERROR_CAT:i.category}),t(null,i)):t(e,null)}))}function attachButtonListeners(e){var t=e.vars.buttons,i=e.vars.tokens;t.add&&i.push(t.add.listen("click",(function(t){var i=shmi.requires("recipe-controller.ls.recipe-name"),s=e.vars.select.control,n=null;s&&"number"==typeof(n=s.getTemplate())&&i.getRecipeName(n,(function(i){"string"==typeof i&&function createRecipe(e,t,i){shmi.requires("visuals.session.RecipeManager").getTemplate(e,(function(e,s){s?(shmi.notify("${recipe-controller.error.fetchTemplate}","${V_ERROR}",{ERROR_CODE:s.errc,ERROR_MSG:s.message,ERROR_CAT:s.category}),i(s)):e.createRecipe(t,{},(function(e,t){t?(shmi.notify("${recipe-controller.error.createRecipe}","${V_ERROR}",{ERROR_CODE:t.errc,ERROR_MSG:t.message,ERROR_CAT:t.category}),i(null,t)):i(e,null)}))}))}(n,i,(function(n,a){a||doCapture(n,(function(l){a||(s.refreshGrid(),s.setValue(i),t.recipe=n,t.type="add",e.fire("change",t))}))}))}))}))),t.edit&&i.push(t.edit.listen("click",(function(t){var i=e.vars.select.selection,s=e.vars.edit.control;s&&i&&s.editRecipe({mode:s.MODE.EDIT,recipe_id:i.recipe_id})}))),t.apply&&i.push(t.apply.listen("click",(function(t){var i=e.vars.select.selection;i&&fetchRecipe(i.recipe_id,(function(i,s){s||("number"!=typeof i.versionId?shmi.notify("${recipe-controller.error.noRecipeValues}","${V_ERROR}"):shmi.confirm("${recipe-controller.confirm.applyRecipe}",(function(s){s&&i.apply((function(s,n){n?shmi.notify("${recipe-controller.error.applyRecipe}","${V_ERROR}",{ERROR_CODE:n.errc,ERROR_MSG:n.message,ERROR_CAT:n.category}):(t.recipe=i,t.type="apply",e.fire("change",t))}))})))}))}))),t.capture&&i.push(t.capture.listen("click",(function(t){var i=e.vars.select.selection;i&&fetchRecipe(i.recipe_id,(function(i,s){s?(t.recipe=i,t.type="capture",e.fire("change",t)):function captureRecipe(e,t){"number"==typeof t.versionId?shmi.confirm("${recipe-controller.confirm.captureRecipe}",(function(i){i&&doCapture(t,(function(t){var i=e.vars.select.control;!t&&i&&i.refreshGrid()}))})):doCapture(t,(function(t){var i=e.vars.select.control;!t&&i&&i.refreshGrid()}))}(e,i)}))}))),t.clone&&i.push(t.clone.listen("click",(function(t){var i=shmi.requires("recipe-controller.ls.recipe-name"),s=e.vars.select.control,n=e.vars.select.selection,a=null;s&&(a=s.getTemplate(),i.getRecipeName(a,(function(i){null!==i&&function cloneRecipe(e,t,i){shmi.requires("visuals.session.RecipeManager").getRecipe(e,(function(e,s){s?(shmi.notify("${recipe-controller.error.fetchRecipe}","${V_ERROR}",{ERROR_CODE:s.errc,ERROR_MSG:s.message,ERROR_CAT:s.category}),i(s)):e.clone(t,(function(e,t){t&&shmi.notify("${recipe-controller.error.cloneRecipe}","${V_ERROR}",{ERROR_CODE:t.errc,ERROR_MSG:t.message,ERROR_CAT:t.category}),i(e,t||null)}))}))}(n.recipe_id,i,(function(n,l){l?(t.templateId=a,t.type="apply",e.fire("change",t),"function"==typeof s.rebuildTable&&s.rebuildTable()):"iq-recipe-list"===s.uiType?(s.rebuildTable(),s.setValue(n.id)):s.setValue(i)}))})))}))),t.remove&&i.push(t.remove.listen("click",(function(t){var i=e.vars.select.selection,s=e.vars.select.control,n=e.vars.edit.control,a=null;i&&shmi.confirm("${recipe-controller.confirm.deleteRecipe}",(function(l){l&&fetchRecipe(i.recipe_id,(function(l,o){o||l.delete((function(o){o?shmi.notify("${recipe-controller.error.deleteRecipe}","${V_ERROR}",{ERROR_CODE:o.errc,ERROR_MSG:o.message,ERROR_CAT:o.category}):(n&&(a=n.getState())&&a.recipe_id===i.recipe_id&&n.reset(),s&&s.setValue(""),"function"==typeof s.rebuildTable&&s.rebuildTable(),t.recipe=l,t.type="del",e.fire("change",t))}))}))}))})))}function nameOrNodeHandleMatches(e,t){const{HANDLE_PREFIX:i,getNodeHandle:s}=shmi.requires("visuals.tools.nodes");return"string"==typeof e&&e.startsWith(i)?s(t)===e.replace(i,""):e===t.getName()}var s={className:"RecipeController",uiType:e,isContainer:!0,config:t,configSchema:null,vars:{buttons:{add:null,edit:null,remove:null,apply:null,capture:null,clone:null},select:{control:null,changeToken:null,selection:null},edit:{control:null,tokens:[]},tokens:[],eventProxy:null,selectUiType:"recipe-select"},imports:{},events:["change"],prototypeExtensions:{onInit:function(){var e=this,t=e.vars.buttons,i={add:["add-recipe","${recipe-controller.label.add}"],edit:["edit-recipe","${recipe-controller.label.edit}"],remove:["remove-recipe","${recipe-controller.label.remove}"],apply:["apply-recipe","${recipe-controller.label.apply}"],capture:["capture-recipe","${recipe-controller.label.capture}"],clone:["clone-recipe","${recipe-controller.label.clone}"]};Array.isArray(e.config["button-order"])&&e.config["button-order"].forEach((function(s){null===t[s]&&i[s]&&(t[s]=function createControllerButton(e,t,i,s){var n={label:null,"icon-title":null,"class-name":"button icon-only",template:"default/button_with_bg_pic","icon-class":"icon","show-icon":!0,"show-text":!1};return e.config["button-usage"]&&!0!==e.config["button-usage"][s]?null:(n.label=i,n.tooltip=i,n["class-name"]+=" "+t,n.name=t,shmi.createControl("button",e.element,n,"DIV"))}(e,i[s][0],i[s][1],s))}))},onEnable:function(){var e=this,t=null,i=null;e.controls.forEach((function(e){e.enable()})),attachButtonListeners(e),null!==e.config["recipe-select"]&&((t=e.vars.select.control=shmi.ctrl(e.config["recipe-select"]))&&(e.vars.selectUiType=t.uiType),watchRecipeSelection(e,t),e.vars.tokens.push(shmi.listen("enable",(function(i){nameOrNodeHandleMatches(e.config["recipe-select"],i.source)&&(t=e.vars.select.control=i.source,watchRecipeSelection(e,t),updateSelection(e,t.getValue()),updateButtonState(e))}),{"source.uiType":e.vars.selectUiType})),e.vars.tokens.push(shmi.listen("disable",(function(i){nameOrNodeHandleMatches(e.config["recipe-select"],i.source)&&(t=e.vars.select.control=null,watchRecipeSelection(e,t),updateSelection(e,null),updateButtonState(e))}),{"source.uiType":e.vars.selectUiType}))),t&&updateSelection(e,t.getValue()),updateButtonState(e),null!==e.config["recipe-edit"]&&(i=e.vars.edit.control=shmi.ctrl(e.config["recipe-edit"]),watchRecipeEdit(e,i),updateButtonState(e),e.vars.tokens.push(shmi.listen("enable",(function(t){nameOrNodeHandleMatches(e.config["recipe-edit"],t.source)&&(i=e.vars.edit.control=t.source,watchRecipeEdit(e,i),updateButtonState(e))}),{"source.uiType":"recipe-edit"})),e.vars.tokens.push(shmi.listen("disable",(function(t){nameOrNodeHandleMatches(e.config["recipe-edit"],t.source)&&(i=e.vars.edit.control=null,watchRecipeEdit(e,i),updateButtonState(e))}),{"source.uiType":"recipe-edit"})),e.vars.tokens.push(shmi.listen("stop-edit",(function(t){if(nameOrNodeHandleMatches(e.config["recipe-edit"],t.source)){var i=e.vars.select.selection;i&&fetchRecipe(i.recipe_id,(function(i,s){if(!s){let s={type:"edit",recipe:i,cancel:t.detail.cancel};e.fire("change",s)}}))}}),{"source.uiType":"recipe-edit"})))},onDisable:function(){this.controls.forEach((function(e){e.disable()})),this.vars.tokens.forEach((function(e){e.unlisten()})),this.vars.tokens=[],this.vars.select.changeToken&&(this.vars.select.changeToken.unlisten(),this.vars.select.changeToken=null),this.vars.edit.tokens.forEach((function(e){e.unlisten()})),this.vars.edit.tokens=[]},onDelete:function(){},onLock:function(){this.controls.forEach((function(e){e.lock()}))},onUnlock:function(){this.controls.forEach((function(e){e.unlock()}))}}},n=shmi.pkg("recipe-controller.ls.recipe-name"),a=null,l=null,o=null;n.run=function run(e){var t=e.parentContainer.getName(),i=[];shmi.onReady({controls:{apply:t+" .apply",name:t+".recipeName"}},(function(t){var s=t.controls.apply,n=t.controls.name;e.isActive()&&(n.setValue(""),i.push(s.listen("click",(function(){var e=n.getValue();"string"==typeof e&&""!==e.trim()&&("function"==typeof a&&a(e),a=null,l&&l.hide())}))))})),e.onDisable=function(){e.run=!1,i.forEach((function(e){e.unlisten()})),i=[]}},n.getRecipeName=function getRecipeName(e,t){var i=null;if("function"==typeof a)throw new Error("Recipe name dialog still in use!");a=t,null===l&&(l=shmi.createControl("dialog-box",document.body,{title:"${recipe-controller.title.nameDialog}",name:"recipeNameDialog","class-name":"dialog-box recipe-name","content-template":"default/recipe-controller/name-dialog","top-level":!0,"tab-limit":!1},"DIV"),o&&(o.unlisten(),o=null),o=shmi.listen("delete-control",(function(e){o.unlisten(),o=null,l=null}),{"detail.name":l.getName()})),l&&shmi.onActive([l],(function(){l.show(),i=l.listen("close",(function(){i.unlisten(),"function"==typeof a&&a(null),a=null}))}))},shmi.requires("visuals.tools.control-generator").generate(s)}(),function(){"use strict";var e="recipe-edit",t={"class-name":"recipe-edit",name:null,template:"custom/controls/recipe-edit",title:e,viewMode:"linear",editName:!0,itemFetchTimeout:1e4},i=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),s=(i.fLog,i.log,{CREATE:1,EDIT:2,CLONE:3,CAPTURE:4}),n=[null,"${recipe-edit.label.create}","${recipe-edit.label.apply}","${recipe-edit.label.clone}","${recipe-edit.label.create}"];function clearGenerated(e){var t=[],i=e.vars.tokens;e.controls.forEach((function(e){t.push(e)})),t.forEach((function(e){shmi.deleteControl(e,!0)})),i.apply&&(i.apply.unlisten(),i.apply=null),i.cancel&&(i.cancel.unlisten(),i.cancel=null),e.vars.controls={name:null,items:{},meta:{},buttons:{}}}function generateContent(t){!function generateName(e){var t=e.vars.anchors,i=e.vars.controls;i.name=shmi.createControl("input-field",t.name,{label:"${recipe-edit.label.recipeName}",type:shmi.Constants.TYPE_STRING,"auto-type":!1,"class-name":"input-field label-beside"}),!e.config.editName&&i.name&&shmi.addClass(i.name.element,"hidden")}(t),function generateMeta(e){var t=e.vars.anchors,i=e.vars.controls;e.vars.recipe.meta.forEach((function(s){var n=function getMetaType(e,t){var i=e.vars.recipe,s=shmi.Constants,n={string:s.TYPE_STRING,int:s.TYPE_INT,long:s.TYPE_INT,longlong:s.TYPE_INT,uint:s.TYPE_INT,ulong:s.TYPE_INT,ulonglong:s.TYPE_INT,float:s.TYPE_FLOAT,double:s.TYPE_FLOAT,bool:s.TYPE_BOOL,boolean:s.TYPE_BOOL},a=null;return i.meta.some((function(e){return e.name===t&&(a=e,!0)})),a?n[a.type]:null}(e,s.name);n===shmi.Constants.TYPE_BOOL?i.meta[s.name]=shmi.createControl("checkbox",t.meta,{ui:"checkbox",label:s.label||s.name,"class-name":"checkbox label-beside recipe-bool",template:"default/recipe-edit/bool-checkbox","on-value":!0,"off-value":!1},"DIV"):i.meta[s.name]=shmi.createControl("input-field",t.meta,{label:s.label||s.name,type:n,"auto-type":!1,"value-alignment":"auto","class-name":"input-field label-beside"},"DIV")}))}(t),function generateItems(e){var t=e.vars.anchors,i=e.vars.recipe;"linear"===e.config.viewMode&&i.items.forEach((function(i){generateItemInput(i,t.items,e)}));if("tree"===e.config.viewMode){const t=function buildItemsObject(e){var t={};return e.items.forEach((function(e){var i={};i.raw=e.name.split("."),i.parts=[],i.index=[],i.raw.forEach((function(e,t){(i.index[t]=[],-1!==e.indexOf("["))?(e.substring(e.indexOf("[")).split("[").join("").split("]").forEach((function(e,s){i.index[t][s]=e})),i.parts[t]=e.substring(0,e.indexOf("["))):(i.parts[t]=e,i.index[t][0]="")}));var s={},n=i.parts[0]+i.index[0][0];if(i.parts.length>1||i.index.length>1){t[n]||(t[n]={}),t[n].myLabel="${"+i.parts[0]+"} "+i.index[0][0],s=t[n];for(let e=1;e<i.index[0].length-1;e++)s[i.index[0][e]]||(s[i.index[0][e]]={}),s=s[i.index[0][e]];for(let t=1;t<i.parts.length;t++){var a=i.parts[t]+i.index[t][0];s[a]||(s[a]={}),s[a].myLabel="${"+i.parts[t]+"} "+i.index[t][0],t===i.parts.length-1?(s[a].actualItem=e,s[a].value=""):s=s[a]}}else t[n]={},t[n].actualItem=e,t[n].value=""})),t}(i),s=e.vars.anchors.items;for(;s.firstChild;)s.removeChild(s.firstChild);!function buildTreeView(e,t,i){var s=shmi.requires("visuals.tools.iterate").iterateObject;shmi.loadResource("templates/default/recipe-edit/treeview.html",(function(n,a){a||(i||(i=e.vars.anchors.items),s(t,(function(s,a){if("myLabel"!==a){var l=document.createElement("div");l.setAttribute("data-ui","tree-node"),l.setAttribute("class","element cont"),l.innerHTML=n;var o=shmi.getUiElement("control-name",l),r=shmi.getUiElement("expand",l);if(i.appendChild(l),"object"!=typeof t[a]||t[a].actualItem){var c=shmi.getUiElement("value-holder",l);r.style.display="none",generateItemInput(t[a].actualItem,c,e)}else{const i=shmi.getUiElement("anchor",l),s=shmi.getUiElement("info",l),n=t[a].myLabel;i.style.display="none",o.innerText=shmi.localize(n),e.vars.rowHandlerTokens.push(new shmi.visuals.io.MouseListener(s,function getRowHandler(e,t){return{onPress:function(e,t,i){},onEnter:function(i){e.locked||shmi.addClass(t.parentNode,"hover")},onLeave:function(e){shmi.removeClass(t.parentNode,"hover")},onRelease:function(i,s,n){if(!e.locked){var a=shmi.getUiElement("expand",t);shmi.hasClass(a,"expand")?shmi.removeClass(a,"expand"):shmi.addClass(a,"expand");var l=shmi.getUiElement("anchor",t.parentNode);"none"===l.style.display?l.style.display="block":l.style.display="none"}}}}(e,s))),e.vars.rowHandlerTokens.push(new shmi.visuals.io.TouchListener(s,function getRowHandlerTouch(e,t){return{onPress:function(t,i,s){e.vars.performClick=!0},onDrag:function(t){e.vars.performClick=!1},onRelease:function(i,s,n){if(!e.locked&&e.vars.performClick){var a=shmi.getUiElement("expand",t);shmi.hasClass(a,"expand")?shmi.removeClass(a,"expand"):shmi.addClass(a,"expand");var l=shmi.getUiElement("anchor",t.parentNode);"none"===l.style.display?l.style.display="block":l.style.display="none"}}}}(e,s))),buildTreeView(e,t[a],i)}}})))}))}(e,t)}e.vars.rowHandlerTokens.forEach((function(e){e.enable()}))}(t),function generateButtons(t){var i=t.vars.anchors,a=t.vars.editor,l=t.vars.tokens,o=t.vars.controls;"tree"===t.config.viewMode&&(o.buttons.expandAll=shmi.createControl("button",i.expandCollapse,{label:"","icon-src":"pics/system/controls/recipe-edit/expand-all.svg","icon-title":"${recipe-edit.label.expand-all}","show-icon":!0,"show-text":!1,name:"expandAll"},"DIV"),l.expandAll=o.buttons.expandAll.listen("click",(function(e){var t=document.getElementsByClassName("cont");for(let e of t){const t=shmi.getUiElement("anchor",e),i=shmi.getUiElement("expand",e);t.style.display="block",shmi.addClass(i,"expand")}})),o.buttons.collapseAll=shmi.createControl("button",i.expandCollapse,{label:"","icon-src":"pics/system/controls/recipe-edit/collapse-all.svg","icon-title":"${recipe-edit.label.collapse-all}","show-icon":!0,"show-text":!1,name:"collapseAll"},"DIV"),l.collapseAll=o.buttons.collapseAll.listen("click",(function(e){var t=document.getElementsByClassName("cont");for(let e of t){const t=shmi.getUiElement("anchor",e),i=shmi.getUiElement("expand",e);t.style.display="none",shmi.removeClass(i,"expand")}})));o.buttons.apply=shmi.createControl("button",i.buttons,{label:n[s.EDIT],name:"applyRecipe"},"DIV"),l.apply=o.buttons.apply.listen("click",(function(i){switch(a.mode){case s.CREATE:createRecipe(t,(function(i,s){s?console.error(e,"error creating recipe:",s):(console.log(e,"created new recipe"),clearValues(t),t.onLock(),t.fire("stop-edit",{recipe:i,cancel:!1}))}));break;case s.EDIT:!function updateRecipe(e,t){var i=shmi.requires("visuals.session.RecipeManager"),s=e.vars.controls,n=e.vars.editor;i.getRecipe(n.recipe_id,(function(i,n){n?(shmi.notify("${recipe-edit.error.fetchRecipe}","${V_ERROR}",{ERROR_CODE:n.errc,ERROR_MSG:n.message,ERROR_CAT:n.category}),t(n)):i.set(s.name.getValue(),getMetaData(e),!1,(function(s){s?(shmi.notify("${recipe-edit.error.updateRecipe}","${V_ERROR}",{ERROR_CODE:s.errc,ERROR_MSG:s.message,ERROR_CAT:s.category}),t(s)):"number"==typeof i.versionId?i.write(function getItemData(e){var t=e.vars.recipe,i={},s=shmi.requires("shmi.visuals.tools.unitClasses");return t.items.forEach((function(t,n){var a=e.vars.controls.items[t.name];if(a&&t.read&&t.write)if(t.adapter){var l=s.getSelectedAdapter(t.unitClass);i[t.name]=l.inFunction(a.getValue())}else i[t.name]=a.getValue()})),i}(e),(function(e){e&&shmi.notify("${recipe-edit.error.writeRecipe}","${V_ERROR}",{ERROR_CODE:e.errc,ERROR_MSG:e.message,ERROR_CAT:e.category}),t(e||null)})):t(null)}))}))}(t,(function(i){i?console.error(e,"error updating recipe:",i):(console.log(e,"recipe updated"),clearValues(t),t.onLock(),t.fire("stop-edit",{recipe:t,cancel:!1}))}));break;case s.CAPTURE:createRecipe(t,(function(i,s){s?console.error(e,"error creating recipe:",s):(console.log(e,"created new recipe"),function captureRecipe(e,t){e.capture(null,(function(e){e&&shmi.notify("${recipe-edit.error.captureRecipe}","${V_ERROR}",{ERROR_CODE:e.errc,ERROR_MSG:e.message,ERROR_CAT:e.category}),t(e||null)}))}(i,(function(s){s?console.error(e,"error capturing recipe values:",s):(console.log(e,"recipe values captured"),clearValues(t),t.onLock(),t.fire("stop-edit",{recipe:i,cancel:!1}))})))}))}})),o.buttons.cancel=shmi.createControl("button",i.buttons,{label:"${recipe-edit.label.cancel}",name:"cancelRecipe"},"DIV"),l.cancel=o.buttons.cancel.listen("click",(function(e){clearValues(t),t.onLock(),t.fire("stop-edit",{cancel:!0})}))}(t)}function generateItemInput(e,t,i){var s=null,n=i.vars.controls,a=!1,l=shmi.requires("shmi.visuals.tools.unitClasses");if(e.read){if(e.type===shmi.Constants.TYPE_BOOL)s={ui:"checkbox",label:e.label||e.name,"class-name":"checkbox label-beside recipe-bool",template:"default/recipe-edit/bool-checkbox","on-value":1,"off-value":0};else if(i.vars.dictionary&&i.vars.dictionary["itemoptions-"+e.name])(s={ui:"select-box",label:e.label||e.name,"class-name":"select-box label-beside recipe-option"}).options=i.vars.dictionary["itemoptions-"+e.name];else if(i.config.enableNumpad&&(a=!0),s={ui:"input-field",label:e.label||e.name,"class-name":"input-field label-beside","numpad-enabled":a,"auto-type":!1,"value-alignment":"auto","unit-text":e.unit||"",type:e.type,precision:"number"==typeof e.digits?e.digits:-1},-1!==[shmi.Constants.TYPE_INT,shmi.Constants.TYPE_FLOAT].indexOf(e.type))if(e.adapter){var o=l.getSelectedAdapter(e.unitClass);"number"==typeof e.min&&(s.min=o.outFunction(e.min)),"number"==typeof e.max&&(s.max=o.outFunction(e.max))}else"number"==typeof e.min&&(s.min=e.min),"number"==typeof e.max&&(s.max=e.max);n.items[e.name]=shmi.createControl(s.ui,t,s,"DIV"),e.write||n.items[e.name].lock(!0)}}function getMetaData(e){var t=shmi.requires("visuals.tools.iterate").iterateObject,i={};return t(e.vars.controls.meta,(function(e,t){i[t]=e.getValue()})),i}function createRecipe(e,t){var i=shmi.requires("visuals.session.RecipeManager"),s=e.vars.controls,n=e.vars.editor;i.getTemplate(n.template_id,(function(i,n){n?(shmi.notify("${recipe-edit.error.fetchTemplate}","${V_ERROR}",{ERROR_CODE:n.errc,ERROR_MSG:n.message,ERROR_CAT:n.category}),t(n)):i.createRecipe(s.name.getValue(),getMetaData(e),(function(e,i){i?(shmi.notify("${recipe-edit.error.createRecipe}","${V_ERROR}",{ERROR_CODE:i.errc,ERROR_MSG:i.message,ERROR_CAT:i.category}),t(null,i)):t(e,null)}))}))}function setTitleRecipe(e,t){var i=e.vars.anchors.recipeName;i.textContent="string"==typeof t?"("+t+")":""}function clearValues(e){var t=e.vars.recipe=shmi.cloneObject(e.vars.template),i=e.vars.editor,s=e.vars.controls;t.valuesSet=!1,i.recipe_id=null,i.mode=null,s.name.setValue(""),setTitleRecipe(e,null),t.meta.forEach((function(e){s.meta[e.name].setValue("")})),t.items.forEach((function(e){s.items[e.name]&&s.items[e.name].setValue(null)}))}function assignSingleItemInfo(e,t){Object.assign(e,{adapter:t.adapter,unitClass:t.unitClass,type:t.type,digits:t.digits,write:t.writable,min:t.min,max:t.max,read:t.initialized&&-1!==t.type,error:!t.initialized})}function fetchItemInfo(e,i){const s=e.vars.template.items.map(i=>(function fetchSingleItemInfo(e,t=1e4){const i=shmi.requires("visuals.session.ItemManager");return new Promise((function collectItemInfo(s,n){let a=null,l=null,o=i.getItem(e.name);o&&o.initialized?(e.unit=o.unit,e.label=o.labelToken,assignSingleItemInfo(e,o),s()):(l=setTimeout(()=>{const t=new Error("Operation timed out");a.unlisten(),a=null,t.itemName=e.name,n(t)},t),a=i.subscribeItem(e.name,{setLabel:t=>e.label=t,setUnitText:t=>e.unit=t,setProperties:(t,n,r,c,u)=>{null!==u&&a&&(o=i.getItem(e.name),o&&assignSingleItemInfo(e,o),clearTimeout(l),a.unlisten(),a=null,s())},setValue:e=>{}}))}))})(i,e.config.itemFetchTimeout||t.itemFetchTimeout));Promise.allSettled(s).then(e=>{const t=e.filter(({status:e})=>"rejected"===e);if(0===t.length)return void i(null);const s=new Error(`Unable to load item info for ${t.length} item(s).`);s.items=t.map(({reason:{itemName:e}})=>e).filter(e=>e&&e.length>0),console.error(s,s.items),i(s)})}function updateEditor(e,t){var i=e.vars.editor,a=e.vars.recipe;!0===t?e.onLock():e.onUnlock(),setTitleRecipe(e,null===i.recipe_id?null:a.name),function updateVisibility(e,t){var i=e.vars.anchors,n=e.vars.recipe;switch(t){case s.CREATE:case s.CAPTURE:shmi.removeClass(i.meta,"hidden"),shmi.addClass(i.items,"hidden");break;case s.EDIT:shmi.removeClass(i.meta,"hidden"),n.valuesSet?shmi.removeClass(i.items,"hidden"):shmi.addClass(i.items,"hidden");break;default:throw new Error("[RecipeEdit] updateVisibility - Invalid mode specified: "+t)}}(e,i.mode),function updateValues(e,t){var i=e.vars.recipe,a=e.vars.controls,l=shmi.requires("shmi.visuals.tools.unitClasses");switch(a.name.setValue(i.name),a.buttons.apply.setLabel(n[t]),t){case s.CREATE:case s.CAPTURE:i.meta.forEach((function(e){a.meta[e.name].setValue(e.default)}));break;case s.EDIT:i.meta.forEach((function(e){a.meta[e.name].setValue(e.value)})),i.items.forEach((function(e){if(a.items[e.name])if(e.adapter){var t=l.getSelectedAdapter(e.unitClass);a.items[e.name].setValue(t.outFunction(e.value))}else a.items[e.name].setValue(e.value)}));break;default:throw new Error("[RecipeEdit] updateValues - Invalid mode specified: "+t)}}(e,i.mode)}var a={className:"RecipeEdit",uiType:e,isContainer:!0,config:t,configSchema:null,vars:{anchors:{title:null,body:null,name:null,meta:null,items:null,buttons:null},controls:{name:null,items:{},meta:{},buttons:{}},tokens:{apply:null,cancel:null},editor:{template_id:null,recipe_id:null,mode:null},recipe:{name:null,meta:[],items:[]},template:{name:null,meta:[],items:[]},rowHandlerTokens:[],templateSet:!1,performClick:!0,fetchId:null,dictionary:null},imports:{},events:["start-edit","stop-edit"],prototypeExtensions:{onInit:function(){!function initAnchorElements(e){var t=shmi.requires("visuals.tools.iterate").iterateObject,i=e.vars.anchors;i.title=shmi.getUiElement("editor-title",e.element),i.recipeName=shmi.getUiElement("recipe-name",e.element),i.body=shmi.getUiElement("editor-body",e.element),i.name=shmi.getUiElement("name-anchor",e.element),i.meta=shmi.getUiElement("meta-anchor",e.element),i.items=shmi.getUiElement("items-anchor",e.element),i.expandCollapse=shmi.getUiElement("expand-collapse-anchor",e.element),i.buttons=shmi.getUiElement("buttons-anchor",e.element),t(i,(function(e,t){if(null===e)throw new Error("[RecipeEdit] template does not contain all required anchor elements")}))}(this),this.vars.anchors.title.textContent=shmi.localize(this.config.title),this.config.dictionary&&(this.vars.dictionary=shmi.requires(this.config.dictionary).dictionary)},onEnable:function(){this.vars.rowHandlerTokens.forEach((function(e){e.enable()}))},onDisable:function(){this.vars.rowHandlerTokens.forEach((function(e){e.disable()})),this.vars.rowHandlerTokens=[]},onLock:function(){this.controls.forEach((function(e){"collapseAll"!==e.config.name&&"expandAll"!==e.config.name&&e.lock()}))},onUnlock:function(){this.controls.forEach((function(e){e.unlock()}))},onSetValue:function(e,t,i){},onSetProperties:function(e,t,i){},setTemplate:function(t,i,n){var a=this,l=a.vars.editor,o=null;if(a.vars.fetchId={},!a.isActive())throw new Error("["+e+"] control not enabled yet!");l.template_id=t,a.vars.templateSet=!1,o=a.vars.fetchId,function fetchTemplateData(e,t){var i=e.vars.template,s=e.vars.editor,n=shmi.requires("visuals.tools.iterate").iterateObject;shmi.requires("visuals.session.RecipeManager").getTemplate(s.template_id,(function(e,s){i.items=[],i.meta=[],s?(shmi.notify("${recipe-edit.error.fetchTemplate}","${V_ERROR}",{ERROR_CODE:s.errc,ERROR_MSG:s.message,ERROR_CAT:s.category}),t(s)):(i.name=e.name,e.items.forEach((function(e){i.items.push({name:e,label:null,unit:null,type:null,value:null,digits:null,write:!1,read:!1})})),n(e.metadata,(function(e,t){i.meta.push({name:t,default:e.default_value,label:e.label||t,type:e.value_type,value:null})})),t(null))}))}(a,(function(e){e?n(e):a.isActive()&&fetchItemInfo(a,(function(e){e?a.isActive()&&(e.items?(clearGenerated(a),shmi.notify("${recipe-edit.error.fetchItemInfoTimeout}","${V_ERROR}",{ITEM_COUNT:e.items.length,ITEMS:(e.items.length>3?[...e.items.slice(0,3),"..."]:e.items).join(", ")})):(clearGenerated(a),shmi.notify("${recipe-edit.error.fetchItemInfo}","${V_ERROR}"))):a.vars.fetchId===o&&(a.vars.fetchId=null,a.vars.templateSet=!0,a.vars.recipe=shmi.cloneObject(a.vars.template),a.isActive()&&(clearGenerated(a),generateContent(a),null!==i?a.editRecipe({mode:s.EDIT,recipe_id:i,preview:!0}):(setTitleRecipe(a,null),a.onLock()))),n(null)}))}))},isTemplateSet:function(){return this.vars.templateSet},editRecipe:function(e){var t=this,i=t.vars.editor;t.isActive()&&t.isTemplateSet()&&(i.mode=e.mode,i.recipe_id=e.recipe_id,i.preview=!0===e.preview,null!==i.recipe_id?(i.preview||t.fire("start-edit",{}),function fetchRecipeData(e,t){var i=e.vars.editor,s=e.vars.recipe=shmi.cloneObject(e.vars.template),n=shmi.requires("visuals.tools.iterate").iterateObject;shmi.requires("visuals.session.RecipeManager").getRecipe(i.recipe_id,(function(i,a){a?(shmi.notify("${recipe-edit.error.fetchRecipe}","${V_ERROR}",{ERROR_CODE:a.errc,ERROR_MSG:a.message,ERROR_CAT:a.category}),t(a)):(s.name=i.name,n(i.metadata,(function(t,i){var s=function getMetaByName(e,t){var i=e.vars.recipe,s=-1;return i.meta.some((function(e,i){return e.name===t&&(s=i,!0)})),-1!==s?i.meta[s]:null}(e,i);s&&(s.value=t)})),n(i.values,(function(t,i){var s=function getItemByName(e,t){var i=e.vars.recipe,s=-1;return i.items.some((function(e,i){return e.name===t&&(s=i,!0)})),-1!==s?i.items[s]:null}(e,i);s&&(s.value=t.value)})),"number"==typeof i.versionId?s.valuesSet=!0:s.valuesSet=!1,t(null))}))}(t,(function(e){e||updateEditor(t,i.preview)}))):(t.vars.recipe={name:null,meta:[],items:[]},updateEditor(t,i.preview)))},reset:function(){var t=this.vars.editor,i=t.template_id;this.isActive()&&this.isTemplateSet()&&(t.template_id=null,t.recipe_id=null,t.mode=null,this.setTemplate(i,null,(function(t){t&&console.error(e,"error resetting recipe-edit:",t)})))},getState:function(){return shmi.cloneObject(this.vars.editor)},MODE:s}};shmi.requires("visuals.tools.control-generator").generate(a)}(),function(){"use strict";var e="recipe-select",t={"class-name":"recipe-select",name:null,template:"default/recipe-select",label:e,"show-results":"always","recipe-template-id":null,"default-value":null,"clear-on-focus":!1},i=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),s=i.fLog;i.log;function eventProxy(e,t){e.fire(t.type,t.detail)}var n={className:"recipe-select",uiType:e,isContainer:!0,config:t,configSchema:null,vars:{domChild:null,dataGridId:null,dataGrid:null,searchbar:null,eventProxy:null,tokens:[]},imports:{dgm:"visuals.session.DataGridManager"},events:["change"],prototypeExtensions:{onInit:function(){if("number"!=typeof this.config["recipe-template-id"])return this.element.textContent="Invalid or no recipe template id given. This control will not work. Please select a valid recipe template id.",void s("Invalid or no recipe template id given:",this.config["recipe-template-id"]);if(this.vars.domChild=shmi.getUiElement("recipe-select-searchbar",this.element),null===this.vars.domChild)return this.element.textContent="One or more required DOM elements are missing from the template. This control will not work. Please select a compatible template.",void s("Some DOM elements are missing from the template.");do{this.vars.dataGridId="recipe-select-"+Math.random().toString(36).substr(2,9)}while(null!==this.imports.dgm.getGrid(this.vars.dataGridId));this.imports.dgm.grids[this.vars.dataGridId]=this.vars.dataGrid=new shmi.visuals.core.DataGridRecipe(this.vars.dataGridId,this.config["recipe-template-id"]),this.vars.dataGrid.init();var e={label:this.config.label,datagrid:this.vars.dataGridId,"search-column":"recipe_name","show-results":this.config["show-results"],"result-columns":["recipe_name"]};this.vars.searchbar=shmi.createControl("searchbar",this.vars.domChild,e),null===this.vars.searchbar&&(this.element.textContent="Unable to create searchbar control for recipes. This control will not work.",s("Unable to create searchbar control for recipes.")),this.config["clear-on-focus"]&&this.vars.tokens.push(this.vars.searchbar.listen("enter",()=>{this.vars.searchbar.setValue("")}))},getValue:function(){var e=null,t=null,i=null;return this.vars.searchbar&&null!==(e=this.vars.searchbar.getMatchData())&&(t=parseInt(e.recipe_id),i=parseInt(e.values_set),this.vars.searchbar.getValue()===e.recipe_name)?{name:this.vars.searchbar.getValue(),recipe_id:isNaN(t)?null:t,template_id:this.config["recipe-template-id"],values_set:1===i}:null},setValue:function(e){this.vars.searchbar&&this.vars.searchbar.setValue(e)},refreshGrid:function(){this.vars.dataGrid&&this.vars.dataGrid.refresh()},onEnable:function(){this.vars.searchbar&&(this.vars.eventProxy=this.vars.searchbar.listen("change",eventProxy.bind(null,this)),this.vars.searchbar.enable(),null!==this.config["default-value"]&&this.vars.searchbar.setValue(this.config["default-value"]))},onDisable:function(){this.vars.searchbar&&this.vars.searchbar.disable(),this.vars.eventProxy&&(this.vars.eventProxy.unlisten(),this.vars.eventProxy=null)},onDelete:function(){this.vars.searchbar&&shmi.deleteControl(this.vars.searchbar),this.vars.dataGrid&&delete this.imports.dgm.grids[this.vars.dataGridId],this.vars.tokens.forEach(e=>{e.unlisten()})},onLock:function(){this.vars.searchbar&&this.vars.searchbar.lock()},onUnlock:function(){this.vars.searchbar&&this.vars.searchbar.unlock()},getTemplate:function(){return this.config["recipe-template-id"]}}};shmi.requires("visuals.tools.control-generator").generate(n)}(),function(){"use strict";var e="ResponsiveMenu",t="responsive-menu",i={"class-name":t,name:null,template:"default/"+t,menu:[],"mobile-layouts":[],"overlay-style":{background:"transparent",zIndex:1}},s=shmi.requires("visuals.tools.logging").createLogger(t,!0,!1),n=(s.fLog,s.log,"pics/system/icons/placeholder.svg");function createListener(e,t){var i=shmi.requires("visuals.io"),s=new i.MouseListener(e,t),n=new i.TouchListener(e,t);return{enable:function(){s.enable(),n.enable()},disable:function(){s.disable(),n.disable()}}}function makeElement(e,t,i){var s=document.createElement(i||"DIV");return"string"==typeof e?shmi.addClass(s,e):Array.isArray(e)&&e.forEach((function(e){"string"==typeof e&&shmi.addClass(s,e)})),"string"==typeof t&&s.setAttribute("data-ui",t),s}function setSelected(e,t,i){e.vars.selected[i]!==t&&(null!==e.vars.selected[i]&&shmi.removeClass(e.vars.selected[i],"selected"),e.vars.selected[i]=t,null!==t&&shmi.addClass(t,"selected")),e.vars.selected.forEach((function(t,s){t&&s>i&&(shmi.removeClass(t,"selected"),e.vars.selected[s]=null)}))}function setLayer(e,t){t!==e.vars.activeLayer&&(e.vars.activeLayer>=0&&shmi.removeClass(e.element,shmi.evalString("layer-<%= INDEX %>-active",{INDEX:e.vars.activeLayer})),e.vars.activeLayer=t,t>=0&&shmi.addClass(e.element,shmi.evalString("layer-<%= INDEX %>-active",{INDEX:e.vars.activeLayer}))),-1===t&&e.vars.selected.forEach((function(t,i){null!==t&&(shmi.removeClass(t,"selected"),e.vars.selected[i]=null)}))}function restrictAccess(e,t){e.vars.restrictedItems.includes(t)||e.vars.restrictedItems.push(t)}function getConditionCallback(e,t,i){return s=>{s?(shmi.removeClass(e,i),t.enable()):(shmi.addClass(e,i),t.disable())}}function buildMenuItem(e,t,i){var s,a=makeElement("menu-item","menu-item","LI"),l=makeElement("icon","icon"),o=makeElement(null,null,"IMG"),r=makeElement("menu-item-label","menu-item-label"),c={onClick:null},u=shmi.requires("visuals.core"),h=t.action?new u.UiAction(t.action):null;return l.appendChild(o),t["icon-src"]?o.setAttribute("src",t["icon-src"]):o.setAttribute("src",n),a.appendChild(l),r.textContent=shmi.localize(t.label),a.appendChild(r),c.onClick=function(){setSelected(e,a,i),setLayer(e,-1),e.vars.mobile&&removeOverlay(e),h&&h.execute(e)},s=createListener(a,c),e.vars.listeners.push(s),t.access&&t.access.type&&t.access.condition&&restrictAccess(e,{base:a,listener:s,menuItem:t}),a}function buildMenu(t,i){var s,a=shmi.getUiElement("menu-layer-0",t.element),l=shmi.getUiElement("custom-content-group",t.element),o=shmi.getUiElement("burger-button",t.element),r={onClick:null};r.onClick=function(){t.vars.mobile&&(t.vars.activeLayer>=0?(setLayer(t,-1),removeOverlay(t)):(setLayer(t,0),function createOverlay(e){var t={element:document.createElement("DIV"),listener:null},i={onClick:null},s=t.element.style;s.position="fixed",s.top=0,s.bottom=0,s.left=0,s.right=0,s.background=e.config["overlay-style"].background,s.zIndex=e.config["overlay-style"].zIndex,document.body.insertBefore(t.element,document.body.firstChild),i.onClick=function(){e.vars.mobile&&e.vars.activeLayer>=0&&(setLayer(e,-1),removeOverlay(e))},t.listener=createListener(t.element,i),t.listener.enable(),e.vars.overlay=t}(t)))},s=createListener(o,r),t.vars.listeners.push(s),i.forEach((function(i){Array.isArray(i.items)?a.insertBefore(function buildMenuGroup(t,i,s){var a,l=makeElement("menu-group","menu-group","LI"),o=makeElement("click-overlay","click-overlay"),r=makeElement("group-data"),c=makeElement("icon","icon"),u=makeElement(null,null,"IMG"),h=makeElement("menu-group-label","menu-group-label"),m=makeElement("triangle"),d=makeElement("menu-layer-"+(s+1),"menu-layer-"+(s+1),"UL"),f={onClick:null};return m.style.pointerEvents="none",c.appendChild(u),r.appendChild(c),r.appendChild(h),r.appendChild(m),l.appendChild(o),l.appendChild(r),l.appendChild(d),f.onClick=function(){var e=t.vars.crumbs["layer"+s];shmi.hasClass(l,"selected")?(setLayer(t,s),setSelected(t,null,s)):(setLayer(t,s+1),setSelected(t,l,s),e.textContent=shmi.localize(i.label))},h.textContent=shmi.localize(i.label),i["icon-src"]?u.setAttribute("src",i["icon-src"]):u.setAttribute("src",n),a=createListener(o,f),t.vars.listeners.push(a),i.access&&i.access.type&&i.access.condition&&restrictAccess(t,{base:l,listener:a,menuItem:i}),i.items.forEach((function(i,n){Array.isArray(i.items)?s>=1?console.error("["+e+"]","menu-groups not allowed above layer 1"):d.appendChild(buildMenuGroup(t,i,s+1)):d.appendChild(buildMenuItem(t,i,s+1))})),l}(t,i,0),l):a.insertBefore(buildMenuItem(t,i,0),l)}))}function removeOverlay(e){e.vars.overlay&&(e.vars.overlay.element.parentNode.removeChild(e.vars.overlay.element),e.vars.overlay.listener.disable(),e.vars.overlay=null)}var a={className:e,uiType:t,isContainer:!1,config:i,configSchema:null,vars:{listeners:[],restrictedItems:[],activeLayer:-1,mobile:!1,selected:[null,null,null],crumbs:{layer0:null,layer1:null},tokens:[],overlay:null},imports:{im:"visuals.session.ItemManager",qm:function(){return shmi.visuals.session.QueryManager}},prototypeExtensions:{onInit:function(){this.vars.crumbs.layer0=shmi.getUiElement("selected-entry-layer-0"),this.vars.crumbs.layer1=shmi.getUiElement("selected-entry-layer-1"),shmi.removeClass(this.element,"slide"),shmi.removeClass(this.element,"accordion"),shmi.addClass(this.element,this.config.mode),buildMenu(this,this.config.menu)},onEnable:function(){var e,t=this,i=shmi.getCurrentLayout();-1!==t.config["mobile-layouts"].indexOf(i)?(shmi.addClass(t.element,"mobile"),t.vars.mobile=!0):(shmi.removeClass(t.element,"mobile"),t.vars.mobile=!1),e=shmi.listen("layout-change",(function(e){-1!==t.config["mobile-layouts"].indexOf(e.detail.layout)?(shmi.addClass(t.element,"mobile"),t.vars.mobile||setLayer(t,-1),t.vars.mobile=!0):(shmi.removeClass(t.element,"mobile"),t.vars.mobile&&(setLayer(t,0),removeOverlay(t)),t.vars.mobile=!1)})),t.vars.tokens.push(e),t.vars.mobile||setLayer(t,0),t.vars.listeners.forEach((function(e){e.enable()})),t.vars.restrictedItems.forEach(e=>{const{ConditionObserver:i}=shmi.requires("visuals.tools.conditions");e.menuItem.access&&e.menuItem.access.type&&e.menuItem.access.condition&&("hide"===e.menuItem.access.type?t.vars.tokens.push(new i(e.menuItem.access.condition,getConditionCallback(e.base,e.listener,"hidden"))):"lock"===e.menuItem.access.type&&t.vars.tokens.push(new i(e.menuItem.access.condition,getConditionCallback(e.base,e.listener,"locked"))))})},onDisable:function(){this.vars.listeners.forEach((function(e){e.disable()})),this.vars.tokens.forEach((function(e){e.unlisten()})),this.vars.tokens=[],removeOverlay(this)},onLock:function(){this.vars.listeners.forEach((function(e){e.disable()}))},onUnlock:function(){this.vars.listeners.forEach((function(e){e.enable()}))},onSetValue:function(e,t,i){},onSetProperties:function(e,t,i){}}};shmi.requires("visuals.tools.control-generator").generate(a)}(),shmi.pkg("visuals.controls"),shmi.visuals.controls.RockerButton=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","rocker-button"),shmi.def(this.config,"template","default/rocker-button"),shmi.def(this.config,"label","rocker-button"),shmi.def(this.config,"unit-text",null),shmi.def(this.config,"name",null),shmi.def(this.config,"min",Number.NEGATIVE_INFINITY),shmi.def(this.config,"max",Number.POSITIVE_INFINITY),shmi.def(this.config,"step",1),shmi.def(this.config,"precision",-1),shmi.def(this.config,"decimal-delimiter","."),shmi.def(this.config,"type",shmi.c("TYPE_INT")),shmi.def(this.config,"auto-min",!0),shmi.def(this.config,"auto-max",!0),shmi.def(this.config,"auto-step",!0),shmi.def(this.config,"auto-precision",!0),shmi.def(this.config,"auto-label",!0),shmi.def(this.config,"auto-unit-text",!0),shmi.def(this.config,"auto-type",!0),shmi.def(this.config,"numpad-enabled",!1),this.vars={},this.imports={nv:shmi.requires("visuals.tools.numericValues")},this.value=0,this.active=!1,this.listeners=[],this.startup()},shmi.visuals.controls.RockerButton.prototype={uiType:"rocker-button",getClassName:function(){return"RockerButton"},onInit:function(){var e=this;e.imports.nv.initValueSettings(e);var t=shmi.getUiElement("previous",e.element);if(t)if(e.currentValueElement=shmi.getUiElement("current",e.element),e.currentValueElement){var i=shmi.getUiElement("next",e.element);if(i){var s=shmi.getUiElement("label",e.element);s&&e.config.label&&(e.vars=e.vars||{},e.vars.label=e.config.label,s.textContent=shmi.localize(e.config.label));var n=shmi.getUiElement("unit",e.element);n&&e.config["unit-text"]&&(e.vars=e.vars||{},e.vars.unit=e.config["unit-text"],n.textContent=shmi.localize(e.config["unit-text"])),e.currentValueElement.textContent=e.imports.nv.formatOutput(e.value,e),e.createInputField(e.currentValueElement,e.validate.bind(e));var a={onPress:function(e,i,s){shmi.addClass(t,"pressed")},onRelease:function(){shmi.removeClass(t,"pressed")},onClick:function(){e.currentValueElement.blur();var t=e.value-e.vars.valueSettings.step;t=e.imports.nv.applyInputSettings(t,e),e.value=t,e.updateValue(),e.currentValueElement.textContent=e.imports.nv.formatOutput(e.value,e)}};e.listeners.push(new shmi.visuals.io.MouseListener(t,a)),e.listeners.push(new shmi.visuals.io.TouchListener(t,a));var l={onPress:function(e,t,s){shmi.addClass(i,"pressed")},onRelease:function(){shmi.removeClass(i,"pressed")},onClick:function(){e.currentValueElement.blur();var t=e.value+parseFloat(e.vars.valueSettings.step);t=e.imports.nv.applyInputSettings(t,e),e.value=t,e.updateValue(),e.currentValueElement.textContent=e.imports.nv.formatOutput(e.value,e)}};e.listeners.push(new shmi.visuals.io.MouseListener(i,l)),e.listeners.push(new shmi.visuals.io.TouchListener(i,l)),this.currentValueElement.addEventListener("keydown",(function(t){if(e.config.type===shmi.c("TYPE_FLOAT")){var i="."===e.config["decimal-delimiter"]?",":".";t.key===i&&t.preventDefault()}}))}else shmi.log("[RockerButton] no next element provided",3)}else shmi.log("[RockerButton] no current element provided",3);else shmi.log("[RockerButton] no previous element provided",3)},createInputField:function(e,t){var i=this;if(e){var s={onClick:function(){var t=shmi.requires("visuals.session.config"),s=t.keyboard&&t.keyboard.enabled;if(i.config["numpad-enabled"]||s){var n,a=shmi.visuals.session.ItemManager,l=shmi.requires("visuals.tools.numericValues"),o={"decimal-delimiter":i.config["decimal-delimiter"],unit:void 0!==i.vars.unit?i.vars.unit:i.config["unit-text"],label:void 0!==i.vars.label?i.vars.label:i.config.label,value:i.value,callback:function(e){i.value=e,i.updateValue(),i.currentValueElement.textContent=i.imports.nv.formatOutput(i.value,i)}};return i.vars&&i.vars.valueSettings||l.initValueSettings(i),n=i.vars.valueSettings,o.min=n.min,o.max=n.max,o.type=n.type,o.precision=n.precision,i.config.item&&a.getItem(i.config.item)&&i.config["auto-type"]&&(i.type=a.items[i.config.item].type),void shmi.numpad(o)}shmi.addClass(e,"selectableText"),e.setAttribute("contenteditable",!0);var r=document.createRange();e.focus(),e.firstChild&&e.firstChild instanceof Text?(r.setStart(e.firstChild,0),r.setEnd(e.firstChild,e.firstChild.length),window.getSelection().removeAllRanges(),window.getSelection().addRange(r)):shmi.log("[RockerButton] elem not found",0)}};this.listeners.push(new shmi.visuals.io.MouseListener(e,s)),this.listeners.push(new shmi.visuals.io.TouchListener(e,s)),e.style.overflow="hidden",e.addEventListener("keypress",(function(t){13===t.keyCode&&(t.preventDefault(),window.getSelection().removeAllRanges(),e.blur())})),e.addEventListener("blur",(function(){e.setAttribute("contenteditable",!1),window.getSelection().removeAllRanges(),shmi.removeClass(e,"selectableText"),shmi.log("[RockerButton] blur event",0),t(e)}))}else shmi.log("[RockerButton] no base element provided",3)},validate:function(e){var t=String(e.textContent).replace(this.config["decimal-delimiter"],"."),i=this.config.item&&this.config["auto-type"]?this.vars.valueSettings.type:this.config.type;if(-1===[shmi.c("TYPE_INT"),shmi.c("TYPE_FLOAT")].indexOf(i))return shmi.log("[RockerButton] invalid value type '"+this.config.type+"' configured",3),void(e.textContent=this.imports.nv.formatOutput(this.value,this));if(this.floatRegexp.test(t)){shmi.log("[RockerButton] valid value",1);var s=this.imports.nv.applyInputSettings(t,this);this.value=s,this.updateValue()}else shmi.log("[RockerButton] invalid value",1);e.textContent=this.imports.nv.formatOutput(this.value,this)},updateValue:function(){this.config.item&&shmi.visuals.session.ItemManager.writeValue(this.config.item,this.value)},onEnable:function(){var e=shmi.visuals.session.ItemManager;this.listeners.forEach((function(e){e.enable()})),this.config.item&&(this._subscriptionTargetId=e.subscribeItem(this.config.item,this)),shmi.log("[RockerButton] enabled",1)},onDisable:function(){var e=shmi.visuals.session.ItemManager;this.listeners.forEach((function(e){e.disable()})),this.config.item&&e.unsubscribeItem(this.config.item,this._subscriptionTargetId),shmi.log("[RockerButton] disabled",1)},onLock:function(){this.currentValueElement.blur(),this.listeners.forEach((function(e){e.disable()})),shmi.addClass(this.element,"locked"),shmi.log("[RockerButton] locked",1)},onUnlock:function(){this.listeners.forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked"),shmi.log("[RockerButton] unlocked",1)},onSetValue:function(e,t){this.value=e,this.currentValueElement.textContent=this.imports.nv.formatOutput(this.value,this)},getValue:function(){return this.value},onSetProperties:function(e,t,i){var s=this,n=shmi.requires("visuals.tools.numericValues");n.setProperties(s,arguments)},setLabel:function(e){var t=shmi.getUiElement("label",this.element);this.config["auto-label"]&&t&&(this.vars=this.vars||{},this.vars.label=e,t.textContent=shmi.localize(e))},setUnitText:function(e){var t=shmi.getUiElement("unit",this.element);this.config["auto-unit-text"]&&t&&(this.vars=this.vars||{},this.vars.unit=e,t.textContent=shmi.localize(e))},floatRegexp:/(^[+-]?[0-9]([.][0-9]*)?$|^[+-]?[1-9]+[0-9]*([.][0-9]*)?$)/,intRegexp:/^[-]?[0-9][0-9]*$/},shmi.extend(shmi.visuals.controls.RockerButton,shmi.visuals.core.BaseControl),shmi.pkg("visuals.controls"),shmi.visuals.controls.Screen=function(e,t){shmi.requires("visuals.controls.View"),this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","screen"),shmi.def(this.config,"name",null),shmi.def(this.config,"initial-view",0),shmi.def(this.config,"views",[]),shmi.def(this.config,"no-views-content","<h4> -- add views to this screen -- </h4>"),shmi.def(this.config,"delete-inactive-views",!0),this.controls=[],this.viewElements=[],this.currentView=-1,this.listeners=[],this.subscriptionId=null,this.tokens=[],this.startup()},shmi.visuals.controls.Screen.prototype={uiType:"screen",isContainer:!0,events:["navigate"],getClassName:function(){return"Screen"},onRegister:function(e,t){var i=this,s=[];if(Array.isArray(i.config.views)&&i.config.views.length){if("string"!=typeof t)return console.warn("["+i.getClassName()+"]","Screen option 'views' is deprecated and should no longer be used. Use a single content template specified with the 'template' option instead."),void shmi.multiLoad(i.config.views,(function(t){if(!i.isDeleted()){var s="";t.forEach((function(e){e.failed||(s+=e.data+"\n")})),i.onRegister(e,s)}}));i.element.innerHTML=t}s=shmi.getUiElements("view",this.element);for(var n=0;n<s.length;n++)s[n].parentNode===this.element&&(this.viewElements.push(s[n]),null,null===s[n].getAttribute("data-name")&&s[n].setAttribute("data-name","view_"+this.viewElements.length));this.clear(),this.config["delete-inactive-views"]?e():(this.viewElements.forEach((function(e,t){var s=e.cloneNode(!0);shmi.addClass(s,"hidden"),i.element.appendChild(s),s.setAttribute("data-index",t)})),i.parseChildren(i.element,e))},onInit:function(){this.viewElements.length>this.config["initial-view"]&&this.setView(this.config["initial-view"])},clear:function(){for(;this.element.childNodes.length>0;)this.element.removeChild(this.element.childNodes[0])},onSetValue:function(e){var t=parseInt(e);this.setView(t)},onLock:function(){void 0!==this.activeView&&this.activeView.controls.forEach((function(e){e.lock()})),shmi.log("[Screen] onLock called",2)},onUnlock:function(){void 0!==this.activeView&&this.activeView.controls.forEach((function(e){e.unlock()})),shmi.log("[Screen] onUnlock called",2)},onEnable:function(){-1!==this.currentView&&this.activeView.enable();var e=shmi.visuals.session.ItemManager;this.config.item&&(this._sID=e.subscribeItem(this.config.item,this),console.log("screen subscribed "+this.config.item))},onDisable:function(){var e=shmi.visuals.session.ItemManager;this.config.item&&(e.unsubscribeItem(this.config.item,this._sID),console.log("screen unsubscribed item")),-1!==this.currentView&&this.activeView.disable(),this.tokens.forEach((function(e){e.unlisten()}))},setView:function(e){var t=this;if(this.currentView===e)shmi.log("[Screen] view "+e+" already active",2);else if(this.viewElements[e]){var i,s=this.currentView;-1!==s&&this.activeView&&(this.config["delete-inactive-views"]?shmi.deleteControl(this.activeView,!0):(shmi.addClass(this.activeView.element,"hidden"),this.activeView.disable())),this.config["delete-inactive-views"]?(i=this.viewElements[e].cloneNode(!0),this.element.appendChild(i),this.activeView=shmi.createControl("view",i,{index:e},"DIV","from")):(this.activeView=this.controls[e],shmi.removeClass(this.activeView.element,"hidden")),this.active&&this.activeView.enable(),this.locked&&this.activeView.controls.forEach((function(e){e.lock()})),this.currentView=e;var n=shmi.visuals.session.ItemManager;this.config.item&&n.readValue(this.config.item)!==this.currentView&&n.writeValue(this.config.item,this.currentView);var a={index:e,old_index:s};if(this.activeView.isActive())this.fire("navigate",a);else{var l=this.activeView.listen("enable",(function(){var e;l.unlisten(),-1!==(e=t.tokens.indexOf(l))&&t.tokens.splice(e,1),l=null,t.fire("navigate",a)}));t.tokens.push(l)}}else console.error("["+this.getClassName()+"] invalid view index:",e)},onAddControl:function(e,t){var i=this,s=shmi.requires("visuals.tools.controller"),n=[],a=null;if(!i.initialized)throw new Error("Control not initialized yet.");i.config["delete-inactive-views"]?t(new Error("Screen is configured to delete inactive views. Disable option 'delete-inactive-views' to programatically add child controls."),n):(Array.isArray(e)||(e=[e]),e.some((function(e){return"view"!==e.ui}))?t(new Error("All children must be of type 'view'"),n):(e.forEach((function(e){var t=null;if(e.config.index=i.controls.length,null!==(t=shmi.createControl(e.ui,i.element,e.config,"DIV",null,!1))){if(e.style&&"object"==typeof e.style){shmi.requires("visuals.tools.iterate.iterateObject")(e.style,(e,i)=>{t.element.style[i]=e})}shmi.addClass(t.element,"hidden"),i.viewElements.push(t.element.cloneNode(!0)),n.push(t)}})),(a=shmi.waitOnInit(n,(function(){var l=-1,o=[],r=shmi.requires("visuals.task"),c=[],u=null;a&&(-1!==(l=i._init_.tokens.indexOf(a))&&i._init_.tokens.splice(l,1),a.unlisten(),a=null),e.forEach((function(e,t){var i=null,a=n[t];e.controller&&s.create(e.controller.name,e.controller,a.getName()),Array.isArray(e.children)&&e.children.length&&((i=r.createTask("child control")).run=function(){a.addControl(e.children,(function(e,t){e&&o.push(e),i.complete()}))},c.push(i))})),c.length?((u=r.createTaskList(c,!1)).onComplete=function(){i.controls.length&&i.controls.length===n.length&&i.setView(i.config["initial-view"]),t(o.length?o[0]:null,n)},u.run()):(i.controls.length&&i.controls.length===n.length&&i.setView(i.config["initial-view"]),t(o.length?o[0]:null,n))})))&&i._init_.tokens.push(a)))}},shmi.extend(shmi.visuals.controls.Screen,shmi.visuals.core.BaseControl),function(){"use strict";var e={"class-name":"searchbar",name:null,template:"default/searchbar",label:"searchbar",item:null,datagrid:null,"search-column":null,"show-results":"two-or-more","result-columns":null,"select-contents-on-focus":!0},t=shmi.requires("visuals.tools.logging").createLogger("searchbar",!0,!1),i=t.fLog;t.log;function addRegisteredEventListener(e,t,i,s,n){var a=e.vars.registeredEventListeners[t];a||(a=e.vars.registeredEventListeners[t]||[]),i.addEventListener(s,n),a.push({type:s,target:i,listener:n})}function removeRegisteredEventListeners(e,t){var i=shmi.requires("visuals.tools.iterate.iterateObject"),s=[];t?(s=e.vars.registeredEventListeners[t]||[],delete e.vars.registeredEventListeners[t]):(i(e.vars.registeredEventListeners,(function(e){s=s.concat(e||[])})),e.vars.registeredEventListeners={}),s.forEach((function(e){e.target.removeEventListener(e.type,e.listener)}))}function clearHint(e){e.vars.dom.suggestion.textContent="",e.vars.currentHint=null}function setHint(e,t,i){var s;t&&(0!==(s=e.getValue()).length||i)?(e.vars.dom.suggestion.textContent=t.substr(s.length),e.vars.currentHint=t):clearHint(e)}function setHintByIdx(e,t,i){if(0!==e.vars.dataGridData.length){for(;t<0;)t+=e.vars.dataGridData.length;t%=e.vars.dataGridData.length,null!==e.vars.currentHintIndex&&shmi.removeClass(e.vars.dom.resultBox.firstChild.children[e.vars.currentHintIndex],"hint-current"),shmi.addClass(e.vars.dom.resultBox.firstChild.children[t],"hint-current"),setHint(e,e.vars.dataGridData[t][e.config["search-column"]],i),e.vars.currentHintIndex=t}else clearHint(e)}function updateHint(e,t){!function fetchHint(e,t){var i=e.vars.lastHintSearchToken&&0===t.indexOf(e.vars.lastHintSearchToken),s=e.vars.lastHintSearchResult&&0===e.vars.lastHintSearchResult.indexOf(t);if(i&&s)return onHint(e,t,e.vars.lastHintSearchResult),void updateResultBox(e,e.vars.dataGridData.filter((function(i){return i[e.config["search-column"]]&&-1!==i[e.config["search-column"]].indexOf(t)})));clearHint(e),e.vars.dataGrid.setFilter(e.vars.dataGridSearchColumnIdx,[t+"%"]),e.vars.lastHintSearchToken=t}(e,t||e.getValue())}function onHint(e,t,i){t=t||e.getValue(),i?(shmi.removeClass(e.element,"notfound"),setHint(e,i),e.vars.lastHintSearchResult=i):(t.length>0&&shmi.addClass(e.element,"notfound"),clearHint(e),e.vars.lastHintSearchResult=null)}function clearResultBox(e){for(removeRegisteredEventListeners(e,"result-box");e.vars.dom.resultBox.firstChild;)e.vars.dom.resultBox.removeChild(e.vars.dom.resultBox.firstChild)}function updateResultBox(e,t){var s,n,a=document.createElement("table"),l=!1;if(clearResultBox(e),"never"===e.config["show-results"]?l=!1:"two-or-more"===e.config["show-results"]&&t.length<=1?l=!1:0!==t.length&&(l=!0),l){if(e.vars.dom.resultBox.style.display="",s=Object.keys(t[0]),(e.config["result-columns"]||[]).length>0&&(s=s.filter((function(t){return-1!==e.config["result-columns"].indexOf(t)}))),0===s.length)return e.vars.dom.resultBox.innerHTML='No columns to display. Please check <span style="font-weight: bold">result-columns</span> in your control configuration.',void i("No columns to display.","dataGrid columns =",Object.keys(t[0]),"columns to display =",e.config["result-columns"]);(n=s.indexOf(e.config["search-column"]))>0&&(s.unshift(s[n]),s.splice(n+1,1)),t.forEach((function(t,i){var n=document.createElement("tr");s.forEach((function(e){var i=document.createElement("td");i.textContent=t[e]||"",n.appendChild(i)})),addRegisteredEventListener(e,"result-box",n,"touchstart",e=>{e.stopPropagation()}),addRegisteredEventListener(e,"result-box",n,"mousedown",(function(i){e.setValue(t[e.config["search-column"]])})),addRegisteredEventListener(e,"result-box",n,"mouseover",setHintByIdx.bind(null,e,i,!0)),addRegisteredEventListener(e,"result-box",n,"mouseleave",shmi.removeClass.bind(shmi,n,"hint-current")),a.appendChild(n)})),e.vars.dom.resultBox.appendChild(a)}else e.vars.dom.resultBox.style.display="none"}function doResultBoxScroll(e,t){var i=e.vars.dom.resultBox.scrollTop,s=i+e.vars.dom.resultBox.offsetHeight;t.offsetTop<i?t.scrollIntoView(!0):t.offsetTop+t.offsetHeight>s&&t.scrollIntoView(!1)}function hintFetchCompleteCallback(e,t){var i,s=e.getValue(),n=function getDataGridDataHelper(e,t){var i=e.getFields();return e.getCurrentIDs(t).map((function(t){var s=e.getRowData(t),n={};return s?(s.forEach((function(e,t){n[i[t]]=String(e.value)})),n):null}))}(e.vars.dataGrid,e.vars.dataGridSubscriptionId.id);n.length>0&&(i=(n[0]||{})[e.config["search-column"]]),e.vars.currentHintIndex=null,e.vars.dataGridData=n,onHint(e,s,i||null),updateResultBox(e,n),e.fire("change",{value:e.getValue()})}function setSelected(e,t){var i=document.createRange();i.selectNodeContents(e),t||i.setStart(e,i.endOffset);var s=window.getSelection();s.removeAllRanges(),s.addRange(i)}function userInputKeyDownHandler(e,t){"Tab"===t.key?e.vars.currentHint&&e.getValue()!==e.vars.currentHint&&(t.preventDefault(),e.setValue(e.vars.currentHint),clearHint(e),setSelected(e.vars.dom.input)):"Escape"===t.key?shmi.hasClass(e.element,"show-results")?shmi.removeClass(e.element,"show-results"):shmi.addClass(e.element,"show-results"):"ArrowUp"===t.key?e.vars.dom.resultBox.firstChild&&e.vars.dom.resultBox.firstChild.children&&(setHintByIdx(e,(e.vars.currentHintIndex||0)-1,!0),doResultBoxScroll(e,e.vars.dom.resultBox.firstChild.children[e.vars.currentHintIndex]),t.preventDefault()):"PageUp"===t.key?e.vars.dom.resultBox.firstChild&&e.vars.dom.resultBox.firstChild.children&&(setHintByIdx(e,Math.max((e.vars.currentHintIndex||0)-10,0),!0),doResultBoxScroll(e,e.vars.dom.resultBox.firstChild.children[e.vars.currentHintIndex]),t.preventDefault()):"ArrowDown"===t.key?e.vars.dom.resultBox.firstChild&&e.vars.dom.resultBox.firstChild.children&&(setHintByIdx(e,(e.vars.currentHintIndex||0)+1,!0),doResultBoxScroll(e,e.vars.dom.resultBox.firstChild.children[e.vars.currentHintIndex]),t.preventDefault()):"PageDown"===t.key?e.vars.dom.resultBox.firstChild&&e.vars.dom.resultBox.firstChild.children&&(setHintByIdx(e,Math.min((e.vars.currentHintIndex||0)+10,e.vars.dataGridData.length-1),!0),doResultBoxScroll(e,e.vars.dom.resultBox.firstChild.children[e.vars.currentHintIndex]),t.preventDefault()):13!==t.keyCode&&9!==event.keyCode||(t.preventDefault(),e.vars.currentHint&&e.setValue(e.vars.currentHint),t.target.blur())}function setupDomUserInput(e){addRegisteredEventListener(e,"input",e.vars.dom.input,"input",(function onInput(){var t=e.getValue();e.vars.dom.mirror.textContent=t,updateHint(e,t)})),addRegisteredEventListener(e,"input",e.vars.dom.input,"keydown",userInputKeyDownHandler.bind(null,e)),addRegisteredEventListener(e,"input",e.vars.dom.input,"focus",(function onFocus(){e.fire("enter",{value:e.getValue()}),e.vars.userInputActive=!0,shmi.addClass(e.element,"focused"),shmi.addClass(e.element,"show-results"),updateHint(e),e.config["select-contents-on-focus"]&&setSelected(e.vars.dom.input,!0)})),addRegisteredEventListener(e,"input",e.vars.dom.input,"blur",(function onBlur(){e.vars.userInputActive=!1,shmi.removeClass(e.element,"focused"),window.getSelection().removeAllRanges(),clearHint(e),e.vars.itemSubscription&&e.config.item&&e.imports.im.writeValue(e.config.item,e.getValue()),e.fire("change",{value:e.getValue()})})),addRegisteredEventListener(e,"input",e.vars.dom.input,"touchstart",(function onDown(e){e.stopPropagation()})),addRegisteredEventListener(e,"input",e.vars.dom.input,"click",(function onClick(){shmi.addClass(e.element,"show-results")}))}var s={className:"searchbar",uiType:"searchbar",isContainer:!1,config:e,configSchema:null,vars:{dom:{input:null,mirror:null,suggestion:null,resultBox:null,clear:null},initDone:!1,registeredEventListeners:{},dataGrid:null,dataGridSubscriptionId:null,dataGridSearchColumnIdx:-1,dataGridData:[],currentHint:null,currentValue:null,lastHintSearchToken:null,lastHintSearchResult:null,userInputActive:!1,currentHintIndex:null,itemSubscription:null,listeners:[]},imports:{im:"visuals.session.ItemManager",dgm:"visuals.session.DataGridManager"},events:["change","enter"],prototypeExtensions:{onInit:function(){var e=this,t=shmi.requires("visuals.io");if(this.vars.dom.input=shmi.getUiElement("searchbar-user-input",this.element),this.vars.dom.mirror=shmi.getUiElement("searchbar-mirror",this.element),this.vars.dom.suggestion=shmi.getUiElement("searchbar-suggestion",this.element),this.vars.dom.resultBox=shmi.getUiElement("searchbar-result-box",this.element),this.vars.dom.clear=shmi.getUiElement("clear-input",this.element),this.vars.dataGrid=this.imports.dgm.getGrid(this.config.datagrid),!function verifyDomElements(e){var t=shmi.requires("visuals.tools.iterate.iterateObject"),i=!0;return t(e,(function(e){i=i&&null!==e})),i}(this.vars.dom))return this.element.textContent="One or more required DOM elements are missing from the template. This control will not work. Please select a compatible template.",void i("Some DOM elements are missing from the template.");var s=shmi.getUiElement("searchbar-label",this.element);s&&(this.config.label&&String(this.config.label).length>0?s.textContent=shmi.localize(this.config.label):s.style.display="none");var n={onClick:function(){e.isActive()&&!e.locked&&e.setValue("")}};if(e.vars.listeners.push(new t.MouseListener(e.vars.dom.clear,n)),e.vars.listeners.push(new t.TouchListener(e.vars.dom.clear,n)),null===this.vars.dataGrid)return this.element.textContent="Unable to find datagrid or no datagrid configured. This control will not work. Please select a valid datagrid.",void(this.config.datagrid?i("Datagrid not found",this.config.datagrid):i("No datagrid configured"));this.vars.initDone=!0,this.vars.dataGridSearchColumnIdx=this.vars.dataGrid.getFields().indexOf(this.config["search-column"]),-1===this.vars.dataGridSearchColumnIdx&&(this.element.textContent="Datagrid does not have the configured field to search in. This control will not work. Please select a valid search field.",i("Datagrid does not have the configured search field.")),this.vars.dataGrid.sort(this.vars.dataGridSearchColumnIdx,"ASC")},getValue:function(){if(!this.vars.initDone)return null;var e=this.vars.dom.input.textContent;return e=e.replace(String.fromCharCode(160)," ")},getMatchData:function(){return function getMatchData(e){return(e.vars.dataGridData||[])[e.vars.currentHintIndex||0]||null}(this)},setValue:function(e){this.vars.initDone&&(this.vars.dom.input.textContent=e,this.vars.dom.mirror.textContent=e,updateHint(this,e))},onEnable:function(){this.vars.initDone&&(setupDomUserInput(this),this.vars.dom.input.setAttribute("contenteditable","true"),this.vars.dataGridSubscriptionId=this.vars.dataGrid.subscribePage(0,100,hintFetchCompleteCallback.bind(null,this)),this.config.item&&(this.vars.itemSubscription=this.vars.im.subscribeItem(this.config.item,this)),this.vars.listeners.forEach((function(e){e.enable()})))},onDisable:function(){this.vars.initDone&&(this.vars.dataGrid.unsubscribe(this.vars.dataGridSubscriptionId.id),this.vars.dataGridSubscriptionId=null,this.vars.itemSubscription&&(this.vars.itemSubscription.unlisten(),this.vars.itemSubscription=null),clearResultBox(this),this.vars.dom.input.setAttribute("contenteditable","false"),removeRegisteredEventListeners(this),this.vars.listeners.forEach((function(e){e.disable()})))},onLock:function(){this.vars.initDone&&this.vars.dom.input.setAttribute("contenteditable","false"),this.vars.listeners.forEach((function(e){e.disable()})),shmi.addClass(this.element,"locked")},onUnlock:function(){this.vars.initDone&&this.vars.dom.input.setAttribute("contenteditable","true"),this.vars.listeners.forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked")},onSetValue:function(e,t,i){this.vars.initDone&&!this.vars.userInputActive&&this.setValue(e)},onSetProperties:function(e,t,i){}}};shmi.requires("visuals.tools.control-generator").generate(s)}(),function(){function setIcon(e,t,i){var s=null,n=!1;return t["icon-src"]?("IMG"!==e.tagName?(s=document.createElement("IMG"),e.parentNode.insertBefore(s,e),e.parentNode.removeChild(e)):s=e,s.className="icon option-icon",s.setAttribute("src",t["icon-src"]),n=!0):t["icon-class"]?("DIV"!==e.tagName?(s=document.createElement("DIV"),e.parentNode.insertBefore(s,e),e.parentNode.removeChild(e)):s=e,s.className="icon option-icon",shmi.addClass(s,t["icon-class"]),n=!0):(e.className="icon option-icon",n=!1),n?s.setAttribute("data-ui","option-icon"):e.setAttribute("data-ui","option-icon"),n}function rebuildOptions(e,t){for(e.optionInputListeners.forEach((function(e){e.disable()})),e.optionInputListeners=[],e.optionElements=[];e.anchorElement.firstChild;)e.anchorElement.removeChild(e.anchorElement.firstChild);e.config.options.forEach((function(t,i){var s=shmi.localize(t.label),n=e.optionElement.cloneNode(!0),a=shmi.getUiElement("value",n),l=shmi.getUiElement("icon",n),o=!1;a?a.textContent=s:n.textContent=s,(t.tooltip||t["icon-title"])&&n.setAttribute("title",shmi.localize(t.tooltip||t["icon-title"])),l&&((o=setIcon(l,t))&&s?shmi.addClass(n,"option-icon-and-text"):o&&shmi.addClass(n,"option-icon-only")),n.setAttribute("data-value",i),e.anchorElement.appendChild(n),e.optionElements.push(n)}));var i=function makeOptionMouseHandler(e){return{onClick:function onClick(t,i,s){shmi.log("[SelectBox] click on element",0);var n=e.value,a=parseInt(s.currentTarget.getAttribute("data-value"));e.value=e.config.options[a].value,e.setSelected(s.currentTarget),e.updateValue(),shmi.addClass(e.containerElement,"hidden"),e.open=!1,e.highlightIndex=-1,e.value!==n&&e.fire("change",{value:e.value})},onPress:function onPress(e,t,i){shmi.log("onPress",0),i.preventDefault()},onRelease:function onRelease(){shmi.log("onRelease",0)}}}(e),s=function makeOptionTouchHandler(e){return{onPress:function onPress(){},onClick:function onClick(t,i,s){shmi.log("[SelectBox] click on element",0);var n=e.value,a=parseInt(s.currentTarget.getAttribute("data-value"));e.value=e.config.options[a].value,e.setSelected(s.currentTarget),e.updateValue(),shmi.addClass(e.containerElement,"hidden"),e.open=!1,e.highlightIndex=-1,e.value!==n&&e.fire("change",{value:e.value})}}}(e);e.optionElements.forEach((function(t){e.optionInputListeners.push(new shmi.visuals.io.TouchListener(t,s)),e.optionInputListeners.push(new shmi.visuals.io.MouseListener(t,i))})),t&&e.optionInputListeners.forEach((function(e){e.enable()}))}shmi.pkg("visuals.controls"),shmi.visuals.controls.SelectBox=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","select-box"),shmi.def(this.config,"template","default/select-box"),shmi.def(this.config,"name",null),shmi.def(this.config,"no-selection-label","---"),shmi.def(this.config,"selected",-1),shmi.def(this.config,"options",[]),shmi.def(this.config,"icon-src",null),shmi.def(this.config,"icon-title",null),shmi.def(this.config,"icon-class",null),shmi.def(this.config,"label","select-box"),shmi.def(this.config,"auto-label",!0),shmi.def(this.config,"show-icon",!1),shmi.def(this.config,"show-text",!0),this.active=!1,this.open=!1,this.value=null,this.highlightIndex=-1,this.inputListeners=[],this.optionInputListeners=[],this.optionElements=[],this.labelElement=null,this.iconElement=null,this.startup()},shmi.visuals.controls.SelectBox.prototype={uiType:"select-box",events:["change"],tooltipProperties:["icon-title"],getClassName:function(){return"SelectBox"},onTemplate:function(e,t,i){if(t)shmi.log("[SelectBox] Template not found - Error 404",3),i();else{if(!this.element)return void shmi.log("[SelectBox] no base element provided",3);var s=document.createElement("DIV");for(s.innerHTML=e,this.templateElement=document.createDocumentFragment();s.firstChild;)this.templateElement.appendChild(s.firstChild);i()}},onInit:function(){var e=this;this.element.innerHTML="",this.labelElement=shmi.getUiElement("label",this.templateElement).cloneNode(!0);var t=shmi.getUiElement("icon",this.templateElement);if(t&&(e.iconElement=t.cloneNode(!0),e.config["icon-src"]?(shmi.addClass(t,"hidden"),shmi.removeClass(e.iconElement,"hidden"),"IMG"!==e.iconElement.tagName&&(e.iconElement=document.createElement("IMG"),e.iconElement.setAttribute("data-ui","icon"),shmi.addClass(e.iconElement,"control-icon icon")),e.iconElement.setAttribute("src",e.config["icon-src"])):e.config["icon-class"]&&(shmi.addClass(e.iconElement,e.config["icon-class"]),shmi.removeClass(e.iconElement,"hidden"),shmi.addClass(t,"hidden"))),e.config["show-icon"]&&e.config["show-text"]?shmi.addClass(e.element,"icon-and-text"):e.config["show-icon"]&&shmi.addClass(e.element,"icon-only"),this.containerElement=shmi.getUiElement("options",this.templateElement).cloneNode(!0),this.containerElement)if(this.anchorElement=shmi.getUiElement("anchor",this.containerElement),this.anchorElement)if(this.optionElement=shmi.getUiElement("option",this.templateElement),this.optionElement)if(this.selectedTempl=shmi.getUiElement("selected",this.templateElement).cloneNode(!0),this.selectedValField=shmi.getUiElement("value",this.selectedTempl),this.selectedTempl&&this.selectedValField){var i=document.createElement("DIV");shmi.addClass(i,"label-area"),this.element.appendChild(i),this.iconElement&&i.appendChild(this.iconElement),this.labelElement&&(this.labelElement.textContent=shmi.localize(this.config.label),i.appendChild(this.labelElement)),this.element.appendChild(this.containerElement),this.element.appendChild(this.selectedTempl),rebuildOptions(this),this.selected=this.config.selected,this.containerElement.setAttribute("tabindex","-1"),this.blurHandler=function(){e.clickedInside?setTimeout((function(){e.containerElement.focus()}),shmi.c("DECOUPLE_TIMEOUT")):(shmi.addClass(this.containerElement,"hidden"),setTimeout(function(){this.open=!1}.bind(this),shmi.c("DECOUPLE_TIMEOUT")),this.highlightIndex=-1)}.bind(this),this.containerElement.addEventListener("blur",this.blurHandler);var s={onPress:function(){}};s.onClick=function(e,t,i){i.target!==this.anchorElement&&(shmi.log("[SelectBox] click on container",1),this.open?this.containerElement.blur():(shmi.removeClass(this.containerElement,"hidden"),this.open=!0,setTimeout(function(){this.containerElement.focus(),shmi.visuals.session.FocusElement=this.containerElement}.bind(this),shmi.c("DECOUPLE_TIMEOUT"))))}.bind(this);var n={onPress:function(t,i,s){s.currentTarget===e.containerElement&&(e.clickedInside=!0)},onRelease:function(t,i,s){s.currentTarget===e.containerElement&&(e.clickedInside=!1)}};n.onLeave=function(){shmi.log("[SelectBox] onLeave container-element",0),this.containerElement.blur(),this.highlightIndex=-1}.bind(this),shmi.addClass(this.containerElement,"hidden"),-1===this.selected?this.setSelected(null):this.setSelected(this.optionElements[this.config.selected]),this.inputListeners.push(new shmi.visuals.io.MouseListener(this.containerElement,n)),this.inputListeners.push(new shmi.visuals.io.TouchListener(this.element,s)),this.inputListeners.push(new shmi.visuals.io.MouseListener(this.element,s)),this.onPressEnter=function(t){var i=t.key?t.key:t.code;!(this.element===document.activeElement&&!this.locked)||"Enter"!==i&&"NumpadEnter"!==i||(shmi.log("[SelectBox] click on container",1),this.open?this.containerElement.blur():(shmi.removeClass(this.containerElement,"hidden"),this.open=!0,setTimeout((function(){e.containerElement.focus(),shmi.visuals.session.FocusElement=e.containerElement}),shmi.c("DECOUPLE_TIMEOUT"))))}.bind(this),this.element.addEventListener("keydown",this.onPressEnter),this.keydownHandler=function(e){var t=e.key?e.key:e.code;if(shmi.log("[SelectBox] keydown event: "+t,1),this.highlightIndex<0&&(this.highlightIndex=this.getCurrentIndex()),shmi.log("[SelectBox] hightlight index "+this.highlightIndex,1),"Escape"===t)this.optionElements.forEach((function(e){shmi.removeClass(e,"highlighted")})),shmi.addClass(this.containerElement,"hidden"),this.open=!1,this.highlightIndex=-1;else if("Enter"===t||"NumpadEnter"===t){if(-1!==this.highlightIndex){shmi.log("[SelectBox] click on element",0);var i=this.optionElements[this.highlightIndex],s=this.value,n=parseInt(i.getAttribute("data-value"));this.value=this.config.options[n].value,this.setSelected(i),this.updateValue(),shmi.addClass(this.containerElement,"hidden"),this.open=!1,this.highlightIndex=-1,this.value!==s&&this.fire("change",{value:this.value}),this.optionElements.forEach((function(e){shmi.removeClass(e,"highlighted")})),this.highlightIndex=-1}}else"ArrowUp"===t?(this.optionElements[this.highlightIndex]&&shmi.removeClass(this.optionElements[this.highlightIndex],"highlighted"),this.highlightIndex>0?this.highlightIndex--:this.highlightIndex=this.optionElements.length-1,this.optionElements[this.highlightIndex]&&shmi.addClass(this.optionElements[this.highlightIndex],"highlighted")):"ArrowDown"===t&&(this.optionElements[this.highlightIndex]&&shmi.removeClass(this.optionElements[this.highlightIndex],"highlighted"),this.highlightIndex<this.optionElements.length-1?this.highlightIndex++:this.highlightIndex=0,this.optionElements[this.highlightIndex]&&shmi.addClass(this.optionElements[this.highlightIndex],"highlighted"));return!1}.bind(this),this.containerElement.addEventListener("keydown",this.keydownHandler)}else shmi.log("[SelectBox] no selected element provided",3);else shmi.log("[SelectBox] no option elements provided",3);else shmi.log("[SelectBox] no options anchor element provided",3);else shmi.log("[SelectBox] no options element provided",3)},setOptions:function(e){this.config.options=e,rebuildOptions(this,this.active),this.setValue(this.getValue())},getOptions:function(){return shmi.cloneObject(this.config.options)},setSelected:function(e){if(void 0!==e){for(var t=-1,i=function(){var e="";if(Array.isArray(this.config.options))for(var i=0;i<this.config.options.length;i++)if(this.config.options[i].value===this.value){e=this.config.options[i].label,t=i;break}return e}.bind(this),s=0;s<this.optionElements.length;s++)shmi.removeClass(this.optionElements[s],"select-box-selected");if(null===e)this.selectedValField.textContent=shmi.localize(this.config["no-selection-label"]),this.selectedTempl.setAttribute("data-value",-1),shmi.removeClass(this.selectedTempl,"option-icon-only option-icon-and-text");else{shmi.addClass(e,"select-box-selected"),this.selectedValField.textContent=shmi.localize(i()),this.selectedTempl.setAttribute("data-value",t);var n=this.config.options[t],a=shmi.getUiElement("option-icon",this.selectedTempl),l=!1;n&&a?(l=setIcon(a,n))&&n.label?shmi.addClass(this.selectedTempl,"option-icon-and-text"):l?shmi.addClass(this.selectedTempl,"option-icon-only"):shmi.removeClass(this.selectedTempl,"option-icon-only option-icon-and-text"):a&&shmi.removeClass(this.selectedTempl,"option-icon-only option-icon-and-text")}this.selected=t}},getCurrentIndex:function(){return this.selected},updateValue:function(){this.config.item&&shmi.visuals.session.ItemManager.writeValue(this.config.item,this.value)},onEnable:function(){this.inputListeners.concat(this.optionInputListeners).forEach((function(e){e.enable()})),this.element.setAttribute("tabindex",0),this.config.item&&(this._subscriptionTargetId=shmi.visuals.session.ItemManager.subscribeItem(this.config.item,this)),shmi.log("[SelectBox] enabled",1)},onDisable:function(){this.config.item&&shmi.visuals.session.ItemManager.unsubscribeItem(this.config.item,this._subscriptionTargetId),this.inputListeners.concat(this.optionInputListeners).forEach((function(e){e.disable()})),this.element.removeEventListener("keydown",this.onPressEnter),shmi.log("[SelectBox] disabled",1)},onDelete:function(){this.containerElement&&(this.containerElement.removeEventListener("blur",this.blurHandler),this.containerElement.removeEventListener("keydown",this.keydownHandler))},onLock:function(){this.locked=!0,shmi.addClass(this.containerElement,"hidden"),this.highlightIndex=-1,this.inputListeners.concat(this.optionInputListeners).forEach((function(e){e.disable()})),shmi.addClass(this.element,"locked"),shmi.log("[SelectBox] locked",1)},onUnlock:function(){this.locked=!1,this.inputListeners.concat(this.optionInputListeners).forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked"),shmi.log("[SelectBox] unlocked",1)},onSetValue:function(e){shmi.log("[SelectBox] setting value...: "+e,0);for(var t=!1,i=this.value,s=0;s<this.config.options.length;s++)if(this.config.options[s].value===e){this.value=e,this.setSelected(this.optionElements[s]),this.selected=s,t=!0;break}t||(this.value=null,this.setSelected(null),this.selected=-1),this.value!==i&&this.fire("change",{value:this.value}),shmi.log("[SelectBox] value set: "+e,1)},getValue:function(){return this.value},setLabel:function(e){this.config["auto-label"]&&this.labelElement&&(this.labelElement.textContent=shmi.localize(e))}},shmi.extend(shmi.visuals.controls.SelectBox,shmi.visuals.core.BaseControl)}(),shmi.pkg("visuals.controls"),shmi.visuals.controls.SelectDate=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","select-date"),shmi.def(this.config,"template","default/select-date"),shmi.def(this.config,"name",null),shmi.def(this.config,"daynames",["${V_SUN_SHORT}","${V_MON_SHORT}","${V_TUE_SHORT}","${V_WED_SHORT}","${V_THU_SHORT}","${V_FRI_SHORT}","${V_SAT_SHORT}"]),shmi.def(this.config,"daynames-long",["${V_SUN}","${V_MON}","${V_TUE}","${V_WED}","${V_THU}","${V_FRI}","${V_SAT}"]),shmi.def(this.config,"monthnames",["${V_JAN}","${V_FEB}","${V_MAR}","${V_APR}","${V_MAY}","${V_JUN}","${V_JUL}","${V_AUG}","${V_SEP}","${V_OCT}","${V_NOV}","${V_DEC}"]),shmi.def(this.config,"dateformat","${V_DATEFORMAT}"),shmi.def(this.config,"label","select-date"),shmi.def(this.config,"auto-label",!0),this.active=!1,this.listeners=[],this.value=null,this.date=new Date,this.selectedDate=new Date,this.selectedDate.setHours(0,0,0,0),this.startup()},shmi.visuals.controls.SelectDate.prototype={uiType:"select-date",events:["change"],getClassName:function(){return"SelectDate"},onInit:function(){if(this.labelElement=shmi.getUiElement("label",this.element),this.labelElement&&(this.labelElement.textContent=shmi.localize(this.config.label)),this.calendarElement=shmi.getUiElement("calendar",this.element),this.calendarElement)if(this.daySelectElement=shmi.getUiElement("day-select",this.element),this.daySelectElement)if(this.selectedElement=shmi.getUiElement("selected-date",this.element),this.selectedElement)if(this.selectedElement=shmi.getUiElement("value",this.selectedElement),this.selectedElement)if(this.headerElement=shmi.getUiElement("day-header",this.element),this.headerElement)if(this.dayNameElements=shmi.getUiElements("day-name",this.headerElement),this.dayNameElements||7===this.dayNameElements.length)if(this.mSelect=shmi.getUiElement("month-select",this.element),this.mSelect)if(this.ySelect=shmi.getUiElement("year-select",this.element),this.ySelect){var e=shmi.getUiElement("previous",this.mSelect);this.mCur=shmi.getUiElement("current",this.mSelect);var t=shmi.getUiElement("next",this.mSelect),i=shmi.getUiElement("previous",this.ySelect);this.yCur=shmi.getUiElement("current",this.ySelect);var s=shmi.getUiElement("next",this.ySelect);if(e&&this.mCur&&t&&i&&this.yCur&&s){for(var n=0;n<this.dayNameElements.length;n++){var a=6===n?0:n+1;this.dayNameElements[n].textContent=shmi.localize(this.config.daynames[a])}this.calendarElement.setAttribute("tabindex","0");var l={onPress:function(){}};l.onClick=function(e,t,i){this.date.setFullYear(this.date.getYear()+1900,this.date.getMonth()-1),this.updateCalendar()}.bind(this),this.listeners.push(new shmi.visuals.io.MouseListener(e,l)),this.listeners.push(new shmi.visuals.io.TouchListener(e,l));var o={onPress:function(){}};o.onClick=function(e,t,i){this.date.setFullYear(this.date.getYear()+1900,this.date.getMonth()+1),this.updateCalendar()}.bind(this),this.listeners.push(new shmi.visuals.io.MouseListener(t,o)),this.listeners.push(new shmi.visuals.io.TouchListener(t,o));var r={onPress:function(){}};r.onClick=function(e,t,i){this.date.setFullYear(this.date.getYear()+1900-1,this.date.getMonth()),this.updateCalendar()}.bind(this),this.listeners.push(new shmi.visuals.io.MouseListener(i,r)),this.listeners.push(new shmi.visuals.io.TouchListener(i,r));var c={onPress:function(){}};c.onClick=function(e,t,i){this.date.setFullYear(this.date.getYear()+1900+1,this.date.getMonth()),this.updateCalendar()}.bind(this),this.listeners.push(new shmi.visuals.io.MouseListener(s,c)),this.listeners.push(new shmi.visuals.io.TouchListener(s,c)),this.dayElements=shmi.getUiElements("day",this.element);var u={};this.pressedElement=null,u.onPress=function(e,t,i){shmi.addClass(i.target,"pressed"),this.pressedElement=i.target},u.onRelease=function(e,t,i){shmi.removeClass(this.pressedElement,"pressed")},u.onClick=function(e,t,i){var s=i.target;shmi.hasClass(s,"previous-month-day")?(this.date.setFullYear(this.date.getYear()+1900,this.date.getMonth()-1),this.selectedDate.setFullYear(this.date.getYear()+1900,this.date.getMonth(),s.textContent)):shmi.hasClass(s,"current-month-day")?(this.date.setFullYear(this.date.getYear()+1900,this.date.getMonth()),this.selectedDate.setFullYear(this.date.getYear()+1900,this.date.getMonth(),s.textContent)):shmi.hasClass(s,"next-month-day")&&(this.date.setFullYear(this.date.getYear()+1900,this.date.getMonth()+1),this.selectedDate.setFullYear(this.date.getYear()+1900,this.date.getMonth(),s.textContent)),this.updateCalendar(),this.config.item&&shmi.visuals.session.ItemManager.writeValue(this.config.item,this.value),shmi.addClass(this.calendarElement,"hidden"),this.open=!1}.bind(this),this.listeners.push(new shmi.visuals.io.MouseListener(this.daySelectElement,u)),this.listeners.push(new shmi.visuals.io.TouchListener(this.daySelectElement,u)),shmi.addClass(this.calendarElement,"hidden"),this.open=!1;var h={};h.onClick=function(){this.open?this.calendarElement.blur():(shmi.removeClass(this.calendarElement,"hidden"),this.open=!0,setTimeout(function(){this.calendarElement.focus(),shmi.visuals.session.FocusElement=this.calendarElement}.bind(this),shmi.c("DECOUPLE_TIMEOUT")))}.bind(this),this.listeners.push(new shmi.visuals.io.MouseListener(this.element,h)),this.listeners.push(new shmi.visuals.io.TouchListener(this.element,h)),this.blurHandler=function(){shmi.addClass(this.calendarElement,"hidden"),setTimeout(function(){this.open=!1}.bind(this),shmi.c("DECOUPLE_TIMEOUT"))}.bind(this),this.calendarElement.addEventListener("blur",this.blurHandler);var m={onPress:function(){},onClick:function(){},onRelease:function(){}};this.listeners.push(new shmi.visuals.io.MouseListener(this.calendarElement,m)),this.listeners.push(new shmi.visuals.io.TouchListener(this.calendarElement,m)),this.updateCalendar()}else shmi.log("[SelectDate] not all month & year select elements provided",3)}else shmi.log("[SelectDate] no year-select element provided",3);else shmi.log("[SelectDate] no month-select element provided",3);else shmi.log("[SelectDate] no day-name elements, or not the right count (7) provided",3);else shmi.log("[SelectDate] no day-header element provided",3);else shmi.log("[SelectDate] no selected-date element provided",3);else shmi.log("[SelectDate] no selected-date element provided",3);else shmi.log("[SelectDate] no day-select element provided",3);else shmi.log("[SelectDate] no calendar element provided",3)},updateCalendar:function(){var e=shmi.requires("visuals.tools.date"),t=this.value,i=new Date(1e3*this.value);i.setFullYear(this.selectedDate.getYear()+1900,this.selectedDate.getMonth(),this.selectedDate.getDate()),this.value=i.getTime()/1e3,shmi.log("[SelectDate] selected time: "+this.value,0);var s=this.date.getMonth(),n=this.date.getYear()+1900,a=new Date(n,s,1).getDay(),l=0;this.mCur.textContent=shmi.localize(this.config.monthnames[s]),this.yCur.textContent=n,l=1===a?7:0===a?6:a-1;for(var o=this.getDaysOfMonth(s,n),r=this.getDaysOfMonth(s+1,n),c=shmi.getUiElements("day",this.element),u=o-l+1,h=0;h<l;h++)c[h].className="previous-month-day",c[h].textContent=u,new Date(n,s-1,u).getTime()===this.selectedDate.getTime()?shmi.addClass(c[h],"selected"):shmi.removeClass(c[h],"selected"),u++;for(u=1,h=l;h<r+l;h++)c[h].className="current-month-day",c[h].textContent=u,new Date(n,s,u).getTime()===this.selectedDate.getTime()?shmi.addClass(c[h],"selected"):shmi.removeClass(c[h],"selected"),u++;for(u=1,h=r+l;h<c.length;h++)c[h].className="next-month-day",c[h].textContent=u,new Date(n,s+1,u).getTime()===this.selectedDate.getTime()?shmi.addClass(c[h],"selected"):shmi.removeClass(c[h],"selected"),u++;var m=shmi.localize(this.config.dateformat);"string"==typeof m?this.selectedElement.textContent=e.formatDateTime(this.selectedDate,{datestring:m}):this.selectedElement.innerHTML="&nbsp;",t!==this.value&&this.fire("change",{value:this.value})},getDaysOfMonth:function(e,t){return new Date(t,e,0).getDate()},onEnable:function(){this.config.item&&(this._subscriptionTargetId=shmi.visuals.session.ItemManager.subscribeItem(this.config.item,this));for(var e=0;e<this.listeners.length;e++)this.listeners[e].enable();shmi.log("[SelectDate] enabled",1)},onDisable:function(){this.config.item&&shmi.visuals.session.ItemManager.unsubscribeItem(this.config.item,this._subscriptionTargetId);for(var e=0;e<this.listeners.length;e++)this.listeners[e].disable();shmi.log("[SelectDate] disabled",1)},onDelete:function(){this.blurHandler&&this.calendarElement.removeEventListener("blur",this.blurHandler)},onLock:function(){shmi.addClass(this.calendarElement,"hidden"),this.open=!1;for(var e=0;e<this.listeners.length;e++)this.listeners[e].disable();shmi.addClass(this.element,"locked"),shmi.log("[SelectDate] locked",1)},onUnlock:function(){for(var e=0;e<this.listeners.length;e++)this.listeners[e].enable();shmi.removeClass(this.element,"locked"),shmi.log("[SelectDate] unlocked",1)},onSetValue:function(e){e=parseInt(e);var t=new Date(1e3*e),i=this.value;this.value=e,this.date.setFullYear(t.getYear()+1900,t.getMonth()),this.selectedDate.setFullYear(t.getYear()+1900,t.getMonth(),t.getDate(),t.getHours(),t.getMinutes(),t.getSeconds()),this.updateCalendar(),i!==this.value&&this.fire("change",{value:this.value})},getValue:function(){return this.value},setLabel:function(e){this.config["auto-label"]&&this.labelElement&&(this.labelElement.textContent=shmi.localize(e))}},shmi.extend(shmi.visuals.controls.SelectDate,shmi.visuals.core.BaseControl),function(){function rebuildOptions(e,t){e.optionInputListeners.forEach((function(e){e.disable()})),e.optionInputListeners=[],e.optionRootElements.forEach((function(t){e.element.removeChild(t)})),e.optionRootElements=[];var i=function makeOptionInputHandler(e){return{onPress:function onPress(e,t,i){shmi.addClass(i.currentTarget,"pressed")},onRelease:function onRelease(t,i,s){for(var n=0;n<e.optionElements.length;n++)shmi.removeClass(e.optionElements[n],"pressed")},onClick:function onClick(t,i,s){var n=e.optionElements.indexOf(s.currentTarget),a=e.config.options[n]?e.config.options[n].value:null,l=a!==e.value;n<0?console.error(e.uiType,"could not match clicked option"):(e.value=a,e.setSelected(s.currentTarget),e.updateValue(),l&&e.fire("change",{value:e.value}))}}}(e);e.config.options.forEach((function(t,s){var n=document.createElement("div");n.innerHTML=e.templateHtml;var a=shmi.getUiElement("option",n);a.setAttribute("data-value",t.value),shmi.getUiElement("label",a).innerHTML=shmi.localize(t.label),(t.tooltip||t["icon-title"])&&n.firstChild.setAttribute("title",shmi.localize(t.tooltip||t["icon-title"]));var l=shmi.getUiElement("option-icon",a);if(l)if(t["icon-src"]){if("IMG"!==l.tagName){var o=document.createElement("IMG");o.className=l.className,l.parentNode.insertBefore(o,l),l.parentNode.removeChild(l),l=o}l.setAttribute("src",t["icon-src"]),t.label?shmi.addClass(a,"option-icon-and-text"):shmi.addClass(a,"option-icon-only")}else if(t["icon-class"]){if("DIV"!==l.tagName){var r=document.createElement("DIV");r.className=l.className,l.parentNode.insertBefore(r,l),l.parentNode.removeChild(l),l=r}shmi.addClass(l,t["icon-class"]),t.label?shmi.addClass(a,"option-icon-and-text"):shmi.addClass(a,"option-icon-only")}e.optionInputListeners.push(new shmi.visuals.io.MouseListener(a,i)),e.optionInputListeners.push(new shmi.visuals.io.TouchListener(a,i)),e.element.appendChild(n.firstChild),e.optionElements.push(a),e.optionRootElements.push(n.firstChild)})),t&&e.optionInputListeners.forEach((function(e){e.enable()}))}shmi.pkg("visuals.controls"),shmi.visuals.controls.SelectRadio=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","select-radio"),shmi.def(this.config,"template","default/select-radio"),shmi.def(this.config,"name",null),shmi.def(this.config,"selected",-1),shmi.def(this.config,"label","select-radio"),shmi.def(this.config,"options",[]),shmi.def(this.config,"auto-label",!0),shmi.def(this.config,"icon-src",null),shmi.def(this.config,"icon-title",null),shmi.def(this.config,"icon-class",null),shmi.def(this.config,"show-icon",!1),shmi.def(this.config,"show-text",!0),this.active=!1,this.value=-1,this.selectedIndex=0,this.selectedElement=null,this.highlightIndex=-1,this.templateHtml=null,this.optionElements=[],this.inputListeners=[],this.optionInputListeners=[],this.optionRootElements=[],this.startup()},shmi.visuals.controls.SelectRadio.prototype={uiType:"select-radio",events:["change"],tooltipProperties:["icon-title"],getClassName:function(){return"SelectRadio"},onTemplate:function(e,t,i){if(!t){if(!this.element)return void shmi.log("[SelectRadio] no base element provided",3);this.templateHtml=e}i()},onInit:function(){if(this.config.options){shmi.log("[SelectRadio] options newly defined",1),this.element.innerHTML="",this.config["show-text"]&&this.config["show-icon"]?shmi.addClass(this.element,"icon-and-text"):this.config["show-icon"]&&shmi.addClass(this.element,"icon-only");var e=document.createElement("div"),t=document.createElement("DIV");shmi.addClass(t,"label-area"),this.element.appendChild(t),e.setAttribute("data-ui","label"),e.setAttribute("class","label"),void 0!==this.config.label&&(e.textContent=shmi.localize(this.config.label));var i=null;this.config["icon-src"]?((i=document.createElement("IMG")).setAttribute("data-ui","option-icon"),shmi.addClass(i,"control-icon icon"),i.setAttribute("src",this.config["icon-src"]),t.appendChild(i)):this.config["icon-class"]&&((i=document.createElement("DIV")).setAttribute("data-ui","option-icon"),shmi.addClass(i,"control-icon icon"),shmi.addClass(i,this.config["icon-class"]),t.appendChild(i)),t.appendChild(e),rebuildOptions(this)}else shmi.log("[SelectRadio] no options defined in config",1)},setOptions:function(e){this.config.options=e,this.value=-1,this.selectedIndex=0,this.selectedElement=null,this.highlightIndex=-1,rebuildOptions(this,this.active)},getOptions:function(){return shmi.cloneObject(this.config.options)},setSelected:function(e){for(var t=0;t<this.optionElements.length;t++)shmi.removeClass(this.optionElements[t],"selected");this.selectedElement=e,e&&shmi.addClass(this.selectedElement,"selected")},getCurrentIndex:function(){for(var e=-1,t=0;t<this.optionElements.length;t++)if(this.optionElements[t]===this.selectedElement){e=t;break}return e},updateValue:function(){this.config.item&&shmi.visuals.session.ItemManager.writeValue(this.config.item,this.value)},onEnable:function(){this.config.item&&(this._subscriptionTargetId=shmi.visuals.session.ItemManager.subscribeItem(this.config.item,this)),this.inputListeners.concat(this.optionInputListeners).forEach((function(e){e.enable()})),shmi.log("[SelectRadio] enabled",1)},onDisable:function(){this.config.item&&shmi.visuals.session.ItemManager.unsubscribeItem(this.config.item,this._subscriptionTargetId),this.inputListeners.concat(this.optionInputListeners).forEach((function(e){e.disable()})),shmi.log("[SelectRadio] disabled",1)},onLock:function(){this.locked=!0,this.highlightIndex=-1,this.inputListeners.concat(this.optionInputListeners).forEach((function(e){e.disable()})),shmi.addClass(this.element,"locked"),shmi.log("[SelectRadio] locked",1)},onUnlock:function(){this.locked=!1,this.inputListeners.concat(this.optionInputListeners).forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked"),shmi.log("[SelectRadio] unlocked",1)},onSetValue:function(e){var t=this.value!==e;this.value=e;for(var i=!1,s=0;s<this.config.options.length;s++)if(this.config.options[s].value===e){this.setSelected(this.optionElements[s]),i=!0;break}i||this.setSelected(null),shmi.log("[SelectRadio] value set: "+e,1),t&&this.fire("change",{value:this.value})},getValue:function(){return this.value},setLabel:function(e){var t=shmi.getUiElement("label",this.element);this.config["auto-label"]&&t&&(t.textContent=shmi.localize(e))}},shmi.extend(shmi.visuals.controls.SelectRadio,shmi.visuals.core.BaseControl)}(),function(){"use strict";var e="select-time",t={"class-name":e,name:null,template:"default/select-time",label:e,"numpad-enabled":!1},i=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),s=i.fLog,n=i.log;function assertType(e,t,i){if(!function checkType(e,t){if(Array.isArray(t)){if(!(e in t))return!1}else if(t!==function getType(e){return Array.isArray(e)?"array":null===e?"null":typeof e}(e))return!1;return!0}(e,t))throw TypeError(i)}function updateValue(e){var t=function computeNewValue(e){var t=e.vars,i=new Date(1e3*t.value);return e.config.isUTC?(i.setHours(t.hours),i.setMinutes(t.minutes),i.setSeconds(t.seconds)):(i.setUTCHours(t.hours),i.setUTCMinutes(t.minutes),i.setUTCSeconds(t.seconds)),i.getTime()/1e3}(e);e.config.item&&(e.vars.itemNeedsString?e.imports.im.writeValue(e.config.item,String(t)):e.imports.im.writeValue(e.config.item,t)),e.vars.value!==t&&(e.vars.value=t,e.fire("change",{value:t})),updateInputFields(e.vars)}function integerToGroup(e,t){return(t+e%t)%t}function addSeconds(e,t){assertType(t,"number"),e.vars.inputFields[0].blur(),e.vars.seconds=integerToGroup(e.vars.seconds+t,60),updateValue(e)}function addMinutes(e,t){assertType(t,"number"),e.vars.inputFields[1].blur(),e.vars.minutes=integerToGroup(e.vars.minutes+t,60),updateValue(e)}function addHours(e,t){assertType(t,"number"),e.vars.inputFields[2].blur(),e.vars.hours=integerToGroup(e.vars.hours+t,24),updateValue(e)}function validateGeneric(e,t,i,s){RegExp(t).test(s.textContent)?(e.vars[i]=parseInt(s.textContent),updateValue(e),e.vars[i]<10&&1===s.textContent.length&&(s.textContent="0"+s.textContent)):e.vars[i]<10?s.textContent="0"+e.vars[i]:s.textContent=e.vars[i]}function inputKeypressListener(e,t){13===Number(t.keyCode)&&(t.preventDefault(),window.getSelection().removeAllRanges(),e.blur())}function inputKeyupListener(e,t){13===Number(t.keyCode)||e.textContent.length>1&&(t.preventDefault(),window.getSelection().removeAllRanges(),e.blur())}function inputBlurListener(e,t,i){window.getSelection().removeAllRanges(),e.setAttribute("contenteditable",!1),shmi.removeClass(e,"selectableText"),t(e)}function addClickTouchListener(e,t,i){e.listeners.push(new shmi.visuals.io.MouseListener(t,i)),e.listeners.push(new shmi.visuals.io.TouchListener(t,i))}function addEventListener(e,t,i,s){t.addEventListener(i,s),e.evListeners.push({element:t,eventType:i,listener:s})}function createInputField(e,t,i,n){if(t){var a=shmi.requires("visuals.session.config"),l=a.keyboard&&a.keyboard.enabled;(n=shmi.cloneObject(n)).callback=function(e){t.textContent=e,i(t)},addClickTouchListener(e,t,{onClick:function onClick(){if(n.numpadEnabled||l)n.value=t.textContent,shmi.numpad(n);else{shmi.addClass(t,"selectableText"),t.setAttribute("contenteditable",!0);var e=document.createRange();t.focus(),t.firstChild&&t.firstChild instanceof Text?(e.setStart(t.firstChild,0),e.setEnd(t.firstChild,t.firstChild.length),window.getSelection().removeAllRanges(),window.getSelection().addRange(e)):s("elem not found")}}}),t.style.overflow="hidden",addEventListener(e,t,"keypress",inputKeypressListener.bind(null,t)),addEventListener(e,t,"keyup",inputKeyupListener.bind(null,t)),addEventListener(e,t,"blur",inputBlurListener.bind(null,t,i))}else s("no base element provided")}function setupRockerComponent(e,t){var i=shmi.getUiElement(t.uiElementName,e.element);if(!i)return s("Element not found: "+t.uiElementName),!1;var n=shmi.getUiElement("previous",i);if(!n)return s("No UI element found for "+t.uiElementName+".previous"),!1;var a=shmi.getUiElement("current",i);if(!a)return s("No UI element found for "+t.uiElementName+".current"),!1;var l=shmi.getUiElement("next",i);return l?(createInputField(e.vars,a,t.inputValidator.bind(e),{min:0,max:t.max,label:t.label,numpadEnabled:e.config["numpad-enabled"]||!1}),addClickTouchListener(e.vars,n,{onPress:shmi.addClass.bind(null,n,"pressed"),onRelease:shmi.removeClass.bind(null,n,"pressed"),onClick:t.addHandler.bind(null,-1)}),addClickTouchListener(e.vars,l,{onPress:shmi.addClass.bind(null,l,"pressed"),onRelease:shmi.removeClass.bind(null,l,"pressed"),onClick:t.addHandler.bind(null,1)}),e.vars.inputFields.push(a),!0):(s("No UI element found for "+t.uiElementName+".next"),!1)}function updateInputFields(e){e.inputFields[0].textContent=e.hours>9?e.hours:"0"+e.hours,e.inputFields[1].textContent=e.minutes>9?e.minutes:"0"+e.minutes,e.inputFields[2].textContent=e.seconds>9?e.seconds:"0"+e.seconds}var a={className:"SelectTime",uiType:e,isContainer:!1,config:t,configSchema:null,vars:{value:0,hours:0,minutes:0,seconds:0,listeners:[],evListeners:[],inputFields:[],itemNeedsString:!1},imports:{im:"visuals.session.ItemManager"},events:["change"],prototypeExtensions:{onInit:function(){var e=shmi.getUiElement("label",this.element);e&&(e.textContent=shmi.localize(this.config.label)),setupRockerComponent(this,{uiElementName:"hour-select",inputValidator:validateGeneric.bind(null,this,/^[0-1]?[0-9]$|^2[0-3]$/,"hours"),addHandler:addHours.bind(null,this),max:23,label:"${V_HOURS}"}),setupRockerComponent(this,{uiElementName:"minute-select",inputValidator:validateGeneric.bind(null,this,/^[0-5]?[0-9]$/,"minutes"),addHandler:addMinutes.bind(null,this),max:59,label:"${V_MINUTES}"}),setupRockerComponent(this,{uiElementName:"second-select",inputValidator:validateGeneric.bind(null,this,/^[0-5]?[0-9]$/,"seconds"),addHandler:addSeconds.bind(null,this),max:59,label:"${V_SECONDS}"}),updateInputFields(this.vars)},onDelete:function(){this.vars.evListeners.forEach((function(e){e.element.removeEventListener(e.eventType,e.listener)})),this.vars.evListeners=[],this.vars.listeners=[]},onEnable:function(){this.config.item&&(this.vars._subscriptionTargetId=this.imports.im.subscribeItem(this.config.item,this)),this.vars.listeners.forEach((function(e){e.enable()}))},onDisable:function(){this.config.item&&this.imports.im.unsubscribeItem(this.config.item,this.vars._subscriptionTargetId),this.vars.listeners.forEach((function(e){e.disable()}))},onLock:function(){this.vars.inputFields.forEach((function(e){e.blur()})),this.vars.listeners.forEach((function(e){e.disable()})),shmi.addClass(this.element,"locked"),n("locked")},onUnlock:function(){this.vars.listeners.forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked"),n("unlocked")},onSetValue:function(e,t,i){e=parseInt(e);var s=new Date(1e3*e);this.vars.itemNeedsString="string"==typeof e,this.config.isUTC?(this.vars.hours=s.getHours(),this.vars.minutes=s.getMinutes(),this.vars.seconds=s.getSeconds()):(this.vars.hours=s.getUTCHours(),this.vars.minutes=s.getUTCMinutes(),this.vars.seconds=s.getUTCSeconds()),updateInputFields(this.vars),this.vars.value!==e&&(this.vars.value=e,this.fire("change",{value:e}))},onSetProperties:function(e,t,i){},setLabel:function(e){var t=shmi.getUiElement("label",this.element);this.config["auto-label"]&&t&&(t.textContent=shmi.localize(e))},getValue:function(){return this.vars.value},getHours:function(){return this.vars.hours},getMinutes:function(){return this.vars.minutes},getSeconds:function(){return this.vars.seconds}}};shmi.requires("visuals.tools.control-generator").generate(a)}(),function(){"use strict";var e={BOOLEANS_TRUE:[1,"1","true",!0]},t="simple-table",i={"class-name":t,name:null,template:"custom/simple-table","grid-name":null,pager:{offset:0,"rows-per-page":50,"page-sizes":[{value:10},{value:50},{value:100},{value:250}]},"use-designer-mapping":!1,"col-mapping":[],table:{"edit-icon":"",fields:[],"edit-fields":!1,"conditional-fields":!1,select:"multi",sort:{col:null,order:"ASC"},"default-filters":{},"default-col-width":150,width:null,height:null}},s=shmi.requires("visuals.tools.logging").createLogger(t,!0,!1);s.fLog,s.log;function addTableWrapperScrollListener(e){e.vars.tbodyElementWrapper.onscroll=function(){var t=e.vars.tbodyElementWrapper.scrollLeft;e.vars.theadElementWrapper.scrollLeft=t,e.vars.tfilterElementWrapper.scrollLeft=t,e.vars.theadElementWrapper.scrollLeft!==t&&(e.vars.tbodyElementWrapper.scrollLeft=e.vars.theadElementWrapper.scrollLeft)}}function removeTableWrapperScrollListener(e){e.vars.tbodyElementWrapper.onscroll=null}function setDataGridControls(e){e.vars.tableUiElements.forEach((function(t,i){setRowControls(i,e)}))}function Voter(e,t,i){this.value=e,this.operator=t,this.operand=i,this.vote=function vote(){return!!function validate(e){var t;return-1===["contains","<",">","<=",">=","==","!="].indexOf(e.operator)?(t=shmi.evalString("[simple-table] invalid operator <%= operator %>",{operator:e.operator}),shmi.log(t,3),!1):-1!==["number","boolean","string"].indexOf(typeof e.operand)||(t=shmi.evalString("[simple-table] invalid type [<%= type %>] of the operand",{type:typeof e.operand}),shmi.log(t,3),!1)}(this)&&("contains"===this.operator?Boolean(-1!==String(this.value).indexOf(this.operand)):(-1!==["number","boolean"].indexOf(typeof this.operand)?this.value=Number(this.value):this.value=String(this.value),function compare(e){switch(e.operator){case"<":return Boolean(e.value<e.operand);case">":return Boolean(e.value>e.operand);case"<=":return Boolean(e.value<=e.operand);case">=":return Boolean(e.value>=e.operand);case"==":return"string"==typeof e.value?Boolean(e.value===String(e.operand)):Boolean(e.value===e.operand);case"!=":return"string"==typeof e.value?Boolean(e.value===String(e.operand)):Boolean(e.value===e.operand)}return!1}(this)))}}function setRowControls(e,t,i){var s=t.vars.dataGrid.getRowData(e),n=function getConditionalConfigForRow(e,t){var i=getByPath("conditional-fields",t.config.table),s={};return i&&i.some((function(i){var n=[];return i.conditions.forEach((function(i){var s,a=t.vars.dataGrid.getFields().indexOf(i.field);s=new Voter(e[a].value,i.operator,i.operand).vote(),n.push(s)})),-1===n.indexOf(!1)&&(s=i.fields,!0)})),s}(s,t);t.config.table.fields.forEach((function(a,l){var o,r,c="simple-table-item-"+e+"-"+l,u=shmi.getUiElement(c,t.element);return u?a.controls?(deleteControls(t,e,l),u.textContent="",t.vars.tableUiElements[e][l]=u,i&&getByPath("edit-fields."+l+".controls",t.config.table)&&(o=getByPath("edit-fields."+l+".controls",t.config.table)),!o&&n[l]&&(o=n[l].controls),void(o=o||a.controls).forEach((function(i){!function saveControl(e,t,i,s){var n,a;null!==e&&((a=getByPath(n=t+"."+i,s.vars.controls,[])).push(e),setByPath(n,s.vars.controls,a))}(function addControlToElement(e,t,i,s){var n,a;if("mapping"in t==!1)return n=shmi.evalString("[simple-table] no mapping for control <%= uiType %>",{uiType:t["ui-type"]}),shmi.log(n,3),null;return a=shmi.cloneObject(t.config),t.mapping.forEach((function(e){var l=s.vars.dataGrid.getFields().indexOf(e.field);"value"in e?a[e.option]=shmi.localize(e.value):i[l]&&i[l].item?a[e.option]=i[l].item.name:(n=shmi.evalString("[simple-table] Bad mapping defined for control <%= uiType %>: <%= field %>",{field:e.field,uiType:t["ui-type"]}),shmi.log(n,3))})),shmi.createControl(t["ui-type"],e,a,"DIV")}(u,i,s,t),e,l,t)}))):(r=shmi.evalString("[simple-table] no controls defined for the cell <%= dataUi %>",{dataUi:c}),void shmi.log(r,3)):(r=shmi.evalString("[simple-table] Cannot find element <%= dataUi %>",{dataUi:c}),void shmi.log(r,3))}))}function deleteControls(e,t,i){var s;void 0===t?Object.keys(e.vars.controls).forEach((function(t){deleteControls(e,t,i)})):void 0===i&&Object.keys(getByPath(t,e.vars.controls,[])).forEach((function(i){deleteControls(e,t,i)})),getByPath(s=t+"."+i,e.vars.controls,[]).forEach((function(e){shmi.deleteControl(e,!0)})),setByPath(s,e.vars.controls,[])}function onDataGridChange(e,t){e&&"OK"===e.status&&(t.vars.isTableToCleanup&&(!function cleanupTabContent(e){deleteControls(e),function clearTableDOM(e){e.vars.theadElement.innerHTML="",e.vars.tfilterElement.innerHTML="",e.vars.tbodyElement.innerHTML=""}(e)}(t),t.vars.isTableToCleanup=!1),t.vars.dataGrid=t.vars.dgMan.getGrid(t.config["grid-name"]),function prepareTable(e){var t=document.createElement("colgroup"),i=document.createElement("thead"),s=document.createElement("tbody"),n="",a={colGroupHTML:"",theadHTML:"<tr>",tfilterHTML:"<tr>",colwidth:e.config.table["default-col-width"],tabwidth:0};getByPath("table.edit-fields",e.config)&&(n='<a class="simple-table-edit-button" title="Edit selected rows" />',n+=e.config.table["edit-icon"]?'<img src="'+e.config.table["edit-icon"]+'" />':"📝",n+="</a>");getByPath("table.select",e.config)&&(a.colGroupHTML+='<col class="simple-table-col-select">',a.theadHTML+='<td class="simple-table-select-row ">',"multi"===getByPath("table.select",e.config)&&(a.theadHTML+='<input id="simple-table-select-row-all" class="simple-table-select-row-all" type="checkbox">'),a.theadHTML+="</td>",a.tfilterHTML+='<td class="simple-table-edit">'+n+"</td>");e.config.table.fields.forEach((function(t,i){!function prepareHeaderRows(e,t,i,s){var n="string"==typeof e["sort-by-field"]?"⭐":"",a="",l=getOrder(s);if(s.vars.dataGrid.getFields()[l.col]===e["sort-by-field"])switch(l.order){case"ASC":n="⭣";break;case"DESC":n="⭡"}i.colwidth=e.width||s.config.table["default-col-width"],i.tabwidth+=i.colwidth,i.colGroupHTML+='<col class="" style="width:'+i.colwidth+'px;">',e.icon&&(a='<img class="col-icon" src="'+e.icon+'" />');i.theadHTML+=""!==n?'<th  class="col-sort" data-ui="simple-table-sort-'+t+'" data-col-id="'+t+'">':"<th>";i.theadHTML+=a+" "+n+" "+shmi.localize(e.label)+" "+n+"</th>",i.tfilterHTML+='<td class="col-filter-header" data-col-id="'+t+'">',e.filter&&"label"in e.filter&&(i.tfilterHTML+='<label for="">'+shmi.localize(e.filter.label)+"</label>");e.filter&&"select"in e.filter?(i.tfilterHTML+='<select class="simple-table-filter" field="'+e.filter.field+'" size="'+Number(e.filter.size)+'"><option value=""></option>',e.filter.select.forEach((function(e){var t=e.label||e.value,s=e.value;i.tfilterHTML+='<option value="'+s+'">'+shmi.localize(t)+"</option>"})),i.tfilterHTML+="</select>"):e.filter&&(i.tfilterHTML+='<input type="text" size="'+Number(e.filter.size)+'" class="simple-table-filter" field="'+e.filter.field+'" />');i.tfilterHTML+="</td>"}(t,i,a,e)})),t.innerHTML=a.colGroupHTML,i.innerHTML=a.theadHTML+"</tr>",s.innerHTML=a.tfilterHTML+"</tr>",e.vars.theadElement.appendChild(t),e.vars.tfilterElement.appendChild(t.cloneNode(!0)),e.vars.tbodyElement.appendChild(t.cloneNode(!0)),e.vars.theadElement.appendChild(i),e.vars.tfilterElement.appendChild(s),e.vars.theadElement.style.width=a.tabwidth+"px",e.vars.tfilterElement.style.width=a.tabwidth+"px",e.vars.tbodyElement.style.width=a.tabwidth+"px",function addFilterListeners(e){var t,i,s,n,a=e.element.getElementsByClassName("simple-table-filter"),l=e.vars.dataGrid.getFilters();for(t=0;t<a.length;t++)i=a[t],s=i.getAttribute("field"),n=e.vars.dataGrid.getFields().indexOf(s),null!==l[n]&&(i.value=l[n]),i.onchange=dgFilter.bind(null,i,e)}(e)}(t),function fillTableWithData(e){var t,i,s=e.vars.dgMan.getCurrentIDs(e.config["grid-name"],e.vars.dgSubscription.id),n=document.createElement("tbody");for(e.vars.tableUiElements=[],s.forEach((function(t){var i=document.createElement("tr");i.setAttribute("data-row-id",t),shmi.addClass(i,"simple-table-data-row"),i.innerHTML=function createTableRowHtml(e,t){var i="";t.config.table.select&&(i+='<td class="simple-table-select-row"><input class="simple-table-row-'+e,i+='" id="select-row-'+e+'" value="'+e+'" type="checkbox"></td>');return t.vars.tableUiElements[e]=[],t.config.table.fields.forEach((function(s,n){t.vars.tableUiElements[e][n]=null,i+='<td class="" data-ui="simple-table-item-'+e+"-"+n+'"></td>'})),i}(t,e),n.appendChild(i)})),e.vars.tbodyElement.appendChild(n),setDataGridControls(e),t=e.element.getElementsByClassName("simple-table-select-row"),i=0;i<t.length;i++)t[i].firstChild&&(t[i].firstChild.onchange=function(){rowsSelector(this,e)})}(t),function buildPager(e){var t=[],i=document.createElement("div"),s=e.config.pager.offset,n=e.config.pager["rows-per-page"],a=e.vars.dataGrid.getRowCount(e.config["grid-name"]),l=parseInt(a/n,10)+1,o=parseInt(s/n,10)+1,r=o>1?o-1:o,c=o<l?o+1:o,u=shmi.localize("${SIMPLE_TABLE_PAGER_TOTAL}"),h=1,m=1,d=l;u=shmi.evalString(u,{value:l}),l>5&&(d=o+2,(m=o-2)<1&&(d+=1+Math.abs(m),m=1),d>l&&(m-=d-l,d=l));for(t.push({label:"⭰","data-page":1}),t.push({label:"⭠","data-page":r}),h=m;h<=d;h++)t.push({label:h,"data-page":h});t.push({label:"⭢","data-page":c}),t.push({label:"⭲","data-page":l}),t.forEach((function(e){var t=document.createElement("div"),s="pagenum button small";t.textContent=e.label,t.setAttribute("data-page",e["data-page"]),e["data-page"]===o&&(s+=" inactive"),shmi.addClass(t,s),i.appendChild(t)})),shmi.addClass(i,"pages"),e.vars.pagerElement.firstChild.replaceWith(i),e.vars.pagerTotalElement.textContent=u}(t),t.vars.isTableToCleanup=!0)}function dgFilter(t,i){var s=t.getAttribute("field"),n=i.vars.dataGrid.getFields().indexOf(s),a=t.value;if(i.clearFilter(n),""!==a){switch(getByPath("table.fields."+t.parentElement.getAttribute("data-col-id")+".filter.type",i.config)){case"numeric":a=Number(a);break;case"boolean":a=-1!==e.BOOLEANS_TRUE.indexOf(a);break;default:case"string":a=String(a)}i.setFilter(n,a)}}function rowsSelector(e,t){var i,s,n,a,l={rows:[],grid:t.config.name};if("simple-table-select-row-all"===e.id)for(s=t.element.getElementsByClassName("simple-table-select-row"),i=0;i<s.length;i++)(n=s[i]).firstChild.checked=e.checked,a=n.parentElement,"simple-table-select-row-all"!==n.firstChild.id&&!0===n.firstChild.checked?(shmi.addClass(a,"selected"),l.rows.push(n.firstChild.value)):shmi.removeClass(a,"selected");else for(a=e.parentElement.parentElement,!0===e.checked?("multi"!==t.config.table.select&&(!function clearSelection(e){var t,i,s,n=e.element.getElementsByClassName("simple-table-select-row");for(t=0;t<n.length;t++)(i=n[t]).firstChild&&(i.firstChild.checked=!1),s=i.parentElement,shmi.removeClass(s,"selected")}(t),e.checked=!0),shmi.addClass(a,"selected")):shmi.removeClass(a,"selected"),s=t.element.getElementsByClassName("simple-table-select-row"),i=0;i<s.length;i++)(n=s[i]).firstChild&&"simple-table-select-row-all"!==n.firstChild.id&&!0===n.firstChild.checked&&l.rows.push(n.firstChild.value);shmi.fire("select",l,t.element)}function getOrder(e){var t={col:null,field:null,order:"ASC"};return e.config.table.sort&&Number.isInteger(e.config.table.sort.col)&&e.config.table.sort.order&&(t.order=e.config.table.sort.order,t.col=e.config.table.sort.col),t}function getByPath(e,t,i){var s,n,a=t;for("string"==typeof e&&(e=(e=(e=e.replace("[",".")).replace("]","")).split(".")),s=0;s<e.length;s++){if(n=e[s],!(a&&n in a))return i;a=a[n]}return a}function setByPath(e,t,i){if("string"==typeof e&&(e=(e=(e=e.replace("[","[.")).replace("]","")).split(".")),e.length>1){var s=e.shift(),n={};-1!==s.indexOf("[")&&(s=s.replace("[",""),n=[]),"object"==typeof t[s]&&null!==t[s]||(t[s]=n),setByPath(e,t[s],i)}else t[e[0]]=i}var n={className:"SimpleTable",uiType:t,isContainer:!1,config:i,configSchema:null,vars:{dgMan:null,dgSubscription:{},dataGrid:{},isTableToCleanup:!1,listeners:[],theadElement:null,tfilterElement:null,tbodyElement:null,pagerElement:null,tableUiElements:[],controls:{}},imports:{im:"visuals.session.ItemManager",qm:function(){return shmi.visuals.session.QueryManager}},prototypeExtensions:{onInit:function(){var e,t;this.config.table.filters={},this.config.table["default-filters"]&&(this.config.table.filters=this.config.table["default-filters"]),function getDesignerColMapping(e){!0===e.config["use-designer-mapping"]&&e.config["col-mapping"].length>0&&e.config["col-mapping"].forEach((function(t,i){e.config.table.fields[i]||(e.config.table.fields[i]={label:"",icon:null,width:e.config.table["default-col-width"],"sort-by-field":null,controls:[{"ui-type":"text2",config:{},mapping:[]}]}),e.config.table.fields[i].controls[0]||(e.config.table.fields[i].controls[0]={"ui-type":"text2",config:{},mapping:[]}),e.config.table.fields[i].controls[0].mapping[0]||(e.config.table.fields[i].controls[0].mapping[0]={option:"item",field:null}),e.config.table.fields[i].label=t.label,e.config.table.fields[i].controls[0].mapping[0].field=t.field,t["sort-by-field"]&&""!==t["sort-by-field"]&&(e.config.table.fields[i]["sort-by-field"]=t["sort-by-field"])}))}(this),function initElements(e){var t,i=null;e.vars.theadElementWrapper=shmi.getUiElement("simple-table-head-wrapper",e.element),e.vars.theadElementWrapper||shmi.log("[simple-table] simple-table-head-wrapper element not found in template",3),e.vars.theadElement=shmi.getUiElement("simple-table-head",e.element),e.vars.theadElement||shmi.log("[simple-table] simple-table-head element not found in template",3),e.vars.tfilterElementWrapper=shmi.getUiElement("simple-table-filter-wrapper",e.element),e.vars.tfilterElementWrapper||shmi.log("[simple-table] simple-table-filter-wrapper element not found in template",3),e.vars.tfilterElement=shmi.getUiElement("simple-table-filter",e.element),e.vars.tfilterElement||shmi.log("[simple-table] simple-table-filter element not found in template",3),e.vars.tbodyElementWrapper=shmi.getUiElement("simple-table-body-wrapper",e.element),e.vars.tbodyElementWrapper||shmi.log("[simple-table] simple-table-body-wrapper element not found in template",3),e.vars.tbodyElement=shmi.getUiElement("simple-table-body",e.element),e.vars.tbodyElement||shmi.log("[simple-table] simple-table-body element not found in template",3),e.vars.pagerElement=shmi.getUiElement("simple-table-pager",e.element),e.vars.pagerElement||shmi.log("[simple-table] simple-table-pager element not found in template",3),e.vars.pagerTotalElement=shmi.getUiElement("simple-table-total",e.element),e.vars.pagerTotalElement||shmi.log("[simple-table] simple-table-total element not found in template",3),e.vars.pagerSettingsElement=shmi.getUiElement("simple-table-settings",e.element),e.vars.pagerSettingsElement||shmi.log("[simple-table] simple-table-settings element not found in template",3),e.config.table.width&&(t=15,e.vars.tbodyElementWrapper.offsetWidth&&e.vars.tbodyElementWrapper.clientWidth&&(t=Number(e.vars.tbodyElementWrapper.offsetWidth)-Number(e.vars.tbodyElementWrapper.clientWidth)),e.vars.theadElementWrapper.style.width=e.config.table.width+"px",e.vars.tfilterElementWrapper.style.width=e.config.table.width+"px",e.vars.tbodyElementWrapper.style.width=e.config.table.width+"px",e.vars.pagerElement.style.width=Number(e.config.table.width)+t+"px"),e.config.table.height&&(e.vars.tbodyElementWrapper.style.height=e.config.table.height+"px"),e.config.pager["rows-per-page"]&&e.config.pager["page-sizes"].forEach((function(t){(i=document.createElement("option")).value=t.value,i.textContent=t.label?shmi.localize(t.label):t.value,t.value===e.config.pager["rows-per-page"]&&(i.selected="selected"),e.vars.pagerSettingsElement.firstElementChild.appendChild(i)}))}(this);var i={onPress:function(e,t,i){}};e=new shmi.visuals.io.MouseListener(this.element,i),t=new shmi.visuals.io.TouchListener(this.element,i),this.vars.listeners.push(e,t)},onEnable:function(){var e,t=this,i=shmi.requires("visuals.tools.iterate.iterateObject");t.vars.dgMan=shmi.visuals.session.DataGridManager,t.vars.dgSubscription=t.vars.dgMan.subscribePage(t.config["grid-name"],t.config.pager.offset,t.config.pager["rows-per-page"],(function(e){t.vars.dgSubscription.changeInfo=e,onDataGridChange(e,t)})),t.config.table.sort&&Number.isInteger(t.config.table.sort.col)&&t.config.table.sort.order&&t.vars.dgMan.sort(t.config["grid-name"],t.config.table.sort.col,t.config.table.sort.order),e=t.vars.dgMan.getFields(t.config["grid-name"]),i(t.config.table.filters||{},(i,s)=>{-1!==e.indexOf(s)&&t.vars.dgMan.setFilter(t.config["grid-name"],e.indexOf(s),i)}),t.vars.pagerSettingsElement.onchange=function(e){var i=e.target.value;i&&i!==t.config.pager["rows-per-page"]&&(t.config.pager["rows-per-page"]=i,t.config.pager.offset=0,t.vars.pagerSettingsElement.firstChild.value=i,t.vars.dgMan.unsubscribe(t.config["grid-name"],t.vars.dgSubscription.id),t.vars.dgSubscription=t.vars.dgMan.subscribePage(t.config["grid-name"],t.config.pager.offset,t.config.pager["rows-per-page"],(function(e){t.vars.dgSubscription.changeInfo=e,onDataGridChange(e,t)})))},addTableWrapperScrollListener(t),t.vars.listeners.forEach((function(e){e.enable()}))},onDisable:function(){this.vars.dgMan.unsubscribe(this.config["grid-name"],this.vars.dgSubscription.id),this.vars.dgMan=null,this.vars.dgSubscription=null,deleteControls(this),removeTableWrapperScrollListener(this),this.vars.listeners.forEach((function(e){e.disable()}))},onLock:function(){deleteControls(this),removeTableWrapperScrollListener(this),this.vars.listeners.forEach((function(e){e.disable()}))},onUnlock:function(){addTableWrapperScrollListener(this),this.vars.listeners.forEach((function(e){e.enable()}))},onSetValue:function(e,t,i){},onSetProperties:function(e,t,i){},sort:function(e,t){this.vars.dataGrid&&(e=Number.parseInt(e,10),this.config.table.sort.col=e,this.config.table.sort.order=t,this.vars.dataGrid.sort(e,t))},setFilter:function(e,t){this.vars.dataGrid&&this.vars.dataGrid.setFilter(e,t)},clearFilter:function(e){this.vars.dataGrid&&this.vars.dataGrid.clearFilter(e)}}};shmi.requires("visuals.tools.control-generator").generate(n)}(),shmi.pkg("visuals.controls"),shmi.visuals.controls.SlideIn=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","slide-in"),shmi.def(this.config,"class-name-container","container"),shmi.def(this.config,"name",null),shmi.def(this.config,"template","default/slide-in"),shmi.def(this.config,"always-open-layouts",[]),shmi.def(this.config,"container-layouts",[]),shmi.def(this.config,"auto-layout",!0),shmi.def(this.config,"initial-mode","slide"),shmi.def(this.config,"content-template",null),shmi.def(this.config,"auto-close",!1),shmi.def(this.config,"tab-limit",!0),shmi.def(this.config,"overlay-style",{background:"transparent",zIndex:1}),this.controls=[],this.state={},this.state.open=!1,this.forceOpen=!1,this.containerMode=!1,this.startup()},shmi.visuals.controls.SlideIn.prototype={uiType:"slide-in",isContainer:!0,events:["open","close"],getClassName:function(){return"SlideIn"},onEnable:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].enable();var t=shmi.getCurrentLayout();-1!==this.config["always-open-layouts"].indexOf(t)?this.forceOpen=!0:this.forceOpen=!1,"container"===this.config["initial-mode"]&&this.enableContainerLayout(),!0===this.config["auto-layout"]&&this.testContainerLayout(),this.forceOpen&&this.open()},onDisable:function(){this.close();for(var e=0;e<this.controls.length;e++)this.controls[e].disable();Array.isArray(this.openListeners)&&(this.openListeners.forEach((function(e){e.disable()})),this.openListeners=[])},onDelete:function(){this.config["container-layouts"].length>0&&!0===this.config["auto-layout"]&&window.removeEventListener("visuals-layout-change",this.testContainerLayoutBind),this.config["always-open-layouts"].length>0&&window.removeEventListener("visuals-layout-change",this.testOpenLayoutBind)},open:function(){var e=this;if(!this.state.open){if(!1===this.containerMode&&(shmi.removeClass(this.element,"closed"),shmi.addClass(this.element,"open")),e.config["tab-limit"]){var t=shmi.requires("visuals.tools.tabulator");e.tabLimit=t.setTabParent(e.element)}if(e.config["auto-close"]){var i={onPress:function(t,i,s){shmi.testParentChild(e.element,s.target)||(s.preventDefault(),e.close(),e.openListeners.forEach((function(e){e.disable()})),e.openListeners=[])}};this.bgOverlay=document.createElement("DIV"),this.bgOverlay.classList.add("overlay-background"),this.bgOverlay.style.background=e.config["overlay-style"].background,this.bgOverlay.style.zIndex=e.config["overlay-style"].zIndex,this.bgOverlay.style.top=0,this.bgOverlay.style.right=0,this.bgOverlay.style.bottom=0,this.bgOverlay.style.left=0,this.bgOverlay.style.position="fixed",document.body.insertBefore(this.bgOverlay,document.body.firstChild),this.openListeners=[new shmi.visuals.io.MouseListener(this.bgOverlay,i),new shmi.visuals.io.TouchListener(this.bgOverlay,i)],this.openListeners.forEach((function(e){e.enable()}))}this.state.open=!0,this.fire("open",{})}},close:function(){this.state.open&&(!1===this.containerMode&&(shmi.removeClass(this.element,"open"),shmi.addClass(this.element,"closed")),this.tabLimit&&(this.tabLimit.unsetTabParent(),this.tabLimit=null),this.config["auto-close"]&&(Array.isArray(this.openListeners)&&(this.openListeners.forEach((function(e){e.disable()})),this.openListeners=[]),this.bgOverlay&&(this.bgOverlay.parentNode.removeChild(this.bgOverlay),this.bgOverlay=null)),this.state.open=!1,this.fire("close",{}))},toggle:function(){this.state.open?this.close():this.open()},onRegister:function(e){var t=this;if(t.contentElement=shmi.getUiElement("slide-in-content",t.element),t.contentElement&&t.config["content-template"]){var i=0===t.config["content-template"].indexOf(shmi.c("RES_URL_PREFIX"))?t.config["content-template"]:shmi.c("TEMPLATE_PATH")+t.config["content-template"]+shmi.c("TEMPLATE_EXT");shmi.loadResource(i,(function(i,s){t.isDeleted()||(s?e():(t.contentElement.innerHTML=i,t.parseChildren(t.contentElement,e)))}))}else t.contentElement?t.parseChildren(t.contentElement,e):e()},onInit:function(){shmi.removeClass(this.element,"open"),shmi.addClass(this.element,"closed"),this.state.open=!1,this.config["always-open-layouts"].length>0&&(this.testOpenLayoutBind=this.testOpenLayout.bind(this),window.addEventListener("visuals-layout-change",this.testOpenLayoutBind,!1)),this.config["container-layouts"].length>0&&!0===this.config["auto-layout"]&&(this.testContainerLayoutBind=this.testContainerLayout.bind(this),window.addEventListener("visuals-layout-change",this.testContainerLayoutBind,!1))},testOpenLayout:function(){var e=shmi.getCurrentLayout();-1!==this.config["always-open-layouts"].indexOf(e)?(this.forceOpen=!0,this.active&&this.open()):(this.forceOpen=!1,this.active&&this.close())},enableContainerLayout:function(){!1===this.containerMode&&(this.containerMode=!0,shmi.removeClass(this.element,this.config["class-name"]),shmi.removeClass(this.element,"open"),shmi.removeClass(this.element,"closed"),shmi.addClass(this.element,this.config["class-name-container"]),this.active&&this.open())},disableContainerLayout:function(){!0===this.containerMode&&(this.containerMode=!1,shmi.removeClass(this.element,this.config["class-name-container"]),shmi.addClass(this.element,this.config["class-name"]),this.state.open?shmi.addClass(this.element,"open"):shmi.addClass(this.element,"closed"),this.active&&this.close())},toggleContainerLayout:function(){!1===this.containerMode?(this.containerMode=!0,shmi.removeClass(this.element,this.config["class-name"]),shmi.removeClass(this.element,"open"),shmi.removeClass(this.element,"closed"),shmi.addClass(this.element,this.config["class-name-container"]),this.active&&this.open()):!0===this.containerMode&&(this.containerMode=!1,shmi.removeClass(this.element,this.config["class-name-container"]),shmi.addClass(this.element,this.config["class-name"]),this.state.open?shmi.addClass(this.element,"open"):shmi.addClass(this.element,"closed"),this.active&&this.close())},testContainerLayout:function(){var e=shmi.getCurrentLayout();-1!==this.config["container-layouts"].indexOf(e)?!1===this.containerMode&&(this.containerMode=!0,shmi.removeClass(this.element,this.config["class-name"]),shmi.removeClass(this.element,"open"),shmi.removeClass(this.element,"closed"),shmi.addClass(this.element,this.config["class-name-container"]),this.active&&this.open()):!0===this.containerMode&&(this.containerMode=!1,shmi.removeClass(this.element,this.config["class-name-container"]),shmi.addClass(this.element,this.config["class-name"]),this.state.open?shmi.addClass(this.element,"open"):shmi.addClass(this.element,"closed"),this.active&&this.close())},onLock:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].lock()},onUnlock:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].unlock()},onAddControl:function(e,t){var i=this,s=shmi.requires("visuals.tools.controller"),n=[],a=null;if(!i.initialized)throw new Error("Control not initialized yet.");Array.isArray(e)||(e=[e]),e.forEach((function(e){var t=shmi.createControl(e.ui,i.contentElement,e.config,"DIV",null,!1);if(null!==t){if(e.style&&"object"==typeof e.style){shmi.requires("visuals.tools.iterate.iterateObject")(e.style,(e,i)=>{t.element.style[i]=e})}n.push(t)}})),(a=shmi.waitOnInit(n,(function(){var l=-1,o=[],r=shmi.requires("visuals.task"),c=[],u=null;a&&(-1!==(l=i._init_.tokens.indexOf(a))&&i._init_.tokens.splice(l,1),a.unlisten(),a=null),e.forEach((function(e,t){var a=null,l=n[t];e.controller&&s.create(e.controller.name,e.controller,l.getName()),i.isActive()&&l.enable(),Array.isArray(e.children)&&e.children.length&&((a=r.createTask("child control")).run=function(){l.addControl(e.children,(function(e,t){e&&o.push(e),a.complete()}))},c.push(a))})),c.length?((u=r.createTaskList(c,!1)).onComplete=function(){t(o.length?o[0]:null,n)},u.run()):t(o.length?o[0]:null,n)})))&&i._init_.tokens.push(a)}},shmi.extend(shmi.visuals.controls.SlideIn,shmi.visuals.core.BaseControl),shmi.pkg("visuals.session"),shmi.visuals.session.userActions=shmi.visuals.session.userActions||{},shmi.visuals.session.userActions["slide-in"]=function(e){if(2!==e.length)shmi.log("[UserAction] slide-in - needs two parameters",2);else{var t=shmi.ctrl(e[1],null);switch(e[0]){case"open":t?t.open():shmi.log("[UserAction] slide-in - control '"+e[1]+"' not found",2);break;case"close":t?t.close():shmi.log("[UserAction] slide-in - control '"+e[1]+"' not found",2);break;case"toggle":t?t.toggle():shmi.log("[UserAction] slide-in - control '"+e[1]+"' not found",2);break;default:shmi.log("[UserAction] unknown function '"+e[0]+"' configured",3)}}},shmi.pkg("visuals.controls"),shmi.visuals.controls.Slider=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","slider"),shmi.def(this.config,"template","default/slider"),shmi.def(this.config,"name",null),shmi.def(this.config,"send-interval",100),shmi.def(this.config,"animation-duration",100),shmi.def(this.config,"orientation","horizontal"),shmi.def(this.config,"continuous",!0),shmi.def(this.config,"min",0),shmi.def(this.config,"max",100),shmi.def(this.config,"step",0),shmi.def(this.config,"precision",-1),shmi.def(this.config,"type",shmi.c("TYPE_FLOAT")),shmi.def(this.config,"label","slider"),shmi.def(this.config,"unit-text",null),shmi.def(this.config,"decimal-delimiter","."),shmi.def(this.config,"auto-min",!0),shmi.def(this.config,"auto-max",!0),shmi.def(this.config,"auto-step",!0),shmi.def(this.config,"auto-precision",!0),shmi.def(this.config,"auto-label",!0),shmi.def(this.config,"auto-unit-text",!0),shmi.def(this.config,"auto-type",!0),this.value=0,this.sendInterval=0,this.lastSent=0,this.active=!1,this.initialized=!1,this._subscriptionTargetId=null,this.resizeCallback=null,this._dragging=!1,this._valueTimeout=-1,this.startup()},shmi.visuals.controls.Slider.prototype={uiType:"slider",getClassName:function(){return"Slider"},events:["change"],onInit:function(){var e=this;if(shmi.requires("visuals.tools.numericValues").initValueSettings(e),"false"===this.config.continuous?this.config.continuous=!1:"true"===this.config.continuous&&(this.config.continuous=!0),this.handleElement=shmi.getUiElement("slider-handle",this.element),this.handleElement)if(this.valueElement=shmi.getUiElement("value",this.element),this.backgroundElement=shmi.getUiElement("slider-background",this.element),this.backgroundElement){this.labelElement=shmi.getUiElement("slider-label",this.element),this.labelElement?this.config.label&&(this.labelElement.textContent=shmi.localize(this.config.label)):shmi.log("[Slider] no slider-label element provided",1),this.unitElement=shmi.getUiElement("unit",this.element),this.unitElement&&this.config["unit-text"]&&(this.unitElement.textContent=shmi.localize(this.config["unit-text"])),this.config.action&&(this.action=new shmi.visuals.core.UiAction(this.config.action,this)),"vertical"===this.config.orientation&&shmi.addClass(this.element,"vertical"),this.width=0,this.handleWidth=0,this.movable=new shmi.visuals.gfx.Movable(this.handleElement),this.anim=new shmi.visuals.gfx.Animation(this.updateHandle.bind(this));var t={onPress:function(){shmi.addClass(e.handleElement,"pressed"),clearTimeout(e.dragTimeout),e._dragging=!1},onDrag:function(t,i,s){s.preventDefault(),e._dragging||(e._dragging=!0,!1!==e.config.continuous&&e.enableSend()),"vertical"===e.config.orientation?e.movable.ty+i>0?(e.movable.ty=0,e.movable.update()):e.movable.ty+i<-e.width+e.handleWidth?(e.movable.ty=-e.width+e.handleWidth,e.movable.update()):e.movable.translate(0,i):e.movable.tx+t<0?(e.movable.tx=0,e.movable.update()):e.movable.tx+t+e.handleWidth>e.width?(e.movable.tx=e.width-e.handleWidth,e.movable.update()):e.movable.translate(t,0)},onRelease:function(){e.disableSend(),shmi.removeClass(e.handleElement,"pressed"),e.dragTimeout=setTimeout((function(){e._dragging=!1}),shmi.c("DRAG_TIMEOUT"))}};this.mouseListener=new shmi.visuals.io.MouseListener(this.handleElement,t),this.touchListener=new shmi.visuals.io.TouchListener(this.handleElement,t),this.resizeListenerAdded||(e.resizeCallback=function(){clearTimeout(e.resizeTO),e.resizeTO=setTimeout((function(){e.updateSize(),e.setValue(e.value)}),shmi.c("ACTION_RETRY_TIMEOUT"))},window.addEventListener("resize",e.resizeCallback,!1),window.addEventListener("visuals-layout-change",e.resizeCallback,!1),this.resizeListenerAdded=!0)}else shmi.log("[Slider] no slider-background element provided",3);else shmi.log("[Slider] no slider-handle element provided",3)},updateSize:function(){this.width="vertical"===this.config.orientation?this.backgroundElement.offsetHeight:this.backgroundElement.offsetWidth,this.handleWidth="vertical"===this.config.orientation?this.handleElement.offsetHeight:this.handleElement.offsetWidth},onEnable:function(){this.updateSize(),this.config.item&&(this._subscriptionTargetId=shmi.visuals.session.ItemManager.subscribeItem(this.config.item,this,this.config["send-interval"])),this.mouseListener.enable(),this.touchListener.enable()},onDisable:function(){this.config.item&&shmi.visuals.session.ItemManager.unsubscribeItem(this.config.item,this._subscriptionTargetId),this.mouseListener.disable(),this.touchListener.disable(),this.anim.stop()},onLock:function(){this.mouseListener.disable(),this.touchListener.disable(),shmi.addClass(this.element,"locked")},onUnlock:function(){this.mouseListener.enable(),this.touchListener.enable(),shmi.removeClass(this.element,"locked")},onSetProperties:function(e,t,i){var s=this,n=shmi.requires("visuals.tools.numericValues");n.setProperties(s,arguments),"number"==typeof s.value&&s.setValue(s.value)},onSetValue:function(e){var t=this,i=shmi.requires("visuals.tools.numericValues"),s=t.vars.valueSettings,n=t.value,a=s.min,l=s.max;if(-1!==this._valueTimeout&&(clearTimeout(this._valueTimeout),this._valueTimeout=-1),this._dragging)this._valueTimeout=setTimeout(function(){this.setValue(e)}.bind(this),shmi.c("ACTION_RETRY_TIMEOUT"));else{if("vertical"===this.config.orientation?this.anim.setCurrentValue(this.movable.ty):this.anim.setCurrentValue(this.movable.tx),this.value=i.applyInputSettings(e,t),this.valueElement){shmi.caf(t.raf_id),t.raf_id=shmi.raf((function(){t.valueElement.textContent=i.formatOutput(e,t)}))}if(!this._dragging){var o=null;o=l===a?this.width-this.handleWidth:void 0===this.value?0:(this.value-a)/(l-a)*(this.width-this.handleWidth),"vertical"===this.config.orientation&&(o*=-1),this.anim.start(o,this.config["animation-duration"])}t.value!==n&&t.fire("change",{value:t.value})}},getValue:function(){return this.value},updateHandle:function(e){isNaN(e)||("vertical"===this.config.orientation?this.movable.ty=e:this.movable.tx=e,this.movable.update())},enableSend:function(){clearInterval(this.sendInterval),this.sendInterval=setInterval(this.writeValue.bind(this),this.config["send-interval"])},writeValue:function(e){var t=this,i=shmi.requires("visuals.tools.numericValues"),s=t.vars.valueSettings,n=s.min,a=s.max,l="vertical"===this.config.orientation?-this.movable.ty:this.movable.tx,o=null;if(o=a===n?a:l*(a-n)/(this.width-this.handleWidth)+n,o=i.applyInputSettings(o,t),this.valueElement){shmi.caf(t.raf_id),t.raf_id=shmi.raf((function(){t.valueElement.textContent=i.formatOutput(o,t)}))}(e||o!==this.lastsent)&&(this.config.item?shmi.visuals.session.ItemManager.writeValue(this.config.item,o):(this.value=o,this.fire("change",{value:o})),this.lastsent=o,this.action&&this.action.execute(this.value))},disableSend:function(){clearInterval(this.sendInterval),this.writeValue(!1)},setLabel:function(e){this.config["auto-label"]&&this.labelElement&&(this.labelElement.textContent=shmi.localize(e))},setUnitText:function(e){this.config["auto-unit-text"]&&this.unitElement&&(this.unitElement.textContent=shmi.localize(e))},onDelete:function(){this.resizeCallback&&(window.removeEventListener("resize",this.resizeCallback,!1),window.removeEventListener("visuals-layout-change",this.resizeCallback,!1))}},shmi.extend(shmi.visuals.controls.Slider,shmi.visuals.core.BaseControl),shmi.pkg("visuals.controls"),shmi.visuals.controls.TabPanel=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","tab-panel"),shmi.def(this.config,"template","default/tab-panel"),shmi.def(this.config,"name",null),shmi.def(this.config,"initial-view",0),shmi.def(this.config,"tab-labels",[]),shmi.def(this.config,"views",[]),shmi.def(this.config,"content-template",null),shmi.def(this.config,"item",null),this.mouselistener=null,this.touchlistener=null,this.active=!1,this.initialized=!1,this._subscriptionTargetId=null,this.buttons=[],this.screen=null,this.controls=[],this.startup()},shmi.visuals.controls.TabPanel.prototype={uiType:"tab-panel",events:["navigate"],isContainer:!0,getClassName:function(){return"TabPanel"},onRegister:function(e){var t=this,i=null;if(t.screen_anchor=shmi.getUiElement("screen-anchor",t.element),!t.screen_anchor){console.warn("["+t.getClassName()+"]","'screen-anchor' element missing from template, adding replacement");var s=document.createElement("DIV");s.setAttribute("class","tab-content"),t.element.appendChild(s),t.screen_anchor=s}t.screen=shmi.createControl("screen",t.screen_anchor,{name:"content","no-views-content":"",views:t.config.views,template:t.config["content-template"],"initial-view":t.config["initial-view"],"delete-inactive-views":!1,item:t.config.item},"DIV"),(i=shmi.waitOnInit([t.screen],(function(){var s=-1;i&&(-1!==(s=t._init_.tokens.indexOf(i))&&t._init_.tokens.splice(s,1),i=null),e()})))&&t._init_.tokens.push(i)},onInit:function(){var e=this,t=e.config["tab-labels"];e.tabs_anchor=shmi.getUiElement("tabs-anchor",e.element),e.tabs_anchor?e.screen.viewElements.forEach((function(i,s){e.buttons.push(shmi.createControl("button",e.tabs_anchor,{label:t[s]||"view_"+(s+1)},"DIV")),s===e.config["initial-view"]&&shmi.addClass(e.buttons[s].element,"selected"),e.buttons[s].listen("click",function getClickCB(t){return function(i){e.setView(t);for(var s=0;s<e.buttons.length;s++)shmi.removeClass(e.buttons[s].element,"selected");shmi.addClass(e.buttons[t].element,"selected")}}(s)),shmi.hasClass(e.element,"small")?shmi.addClass(e.buttons[s].element,"small"):shmi.hasClass(e.element,"large")&&shmi.addClass(e.buttons[s].element,"large")})):shmi.notify("${V_MISSING_UI_ELEMENT} 'tabs-anchor'","${V_ERROR}")},setView:function(e){if(this.initialized&&this.screen.initialized&&this.screen){this.screen.setView(e);for(var t=0;t<this.buttons.length;t++)shmi.removeClass(this.buttons[t].element,"selected");shmi.addClass(this.buttons[e].element,"selected")}},onEnable:function(){var e=this,t=shmi.requires("visuals.session.ItemManager"),i=t.getItemHandler();e.controls.forEach((function(e){e.enable()})),e.config.item&&(i.setValue=function setValue(t){var i=parseInt(t);!isNaN(i)&&i>=0&&i<e.buttons.length&&(e.buttons.forEach((function(e){shmi.removeClass(e.element,"selected")})),shmi.addClass(e.buttons[i].element,"selected"))},e._subscriptionTargetId=t.subscribeItem(e.config.item,i))},onDisable:function(){this.controls.forEach((function(e){e.disable()})),this._subscriptionTargetId&&(this._subscriptionTargetId.unlisten(),this._subscriptionTargetId=null)},onSetValue:function(){},onLock:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].lock();shmi.addClass(this.element,"locked"),shmi.log("[TabPanel] locked",1)},onUnlock:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].unlock();shmi.removeClass(this.element,"locked"),shmi.log("[TabPanel] unlocked",1)},onAddControl:function(e,t){var i,s=this;if(!s.initialized)throw new Error("Control not initialized yet.");Array.isArray(e)||(e=[e]),e.some((function(e){return"view"!==e.ui}))?t(new Error("All children must be of type 'view'"),[]):(i=s.screen.viewElements.length,e.forEach((function(e,t){var n=i+t,a=e.config.label||s.config["tab-labels"][n]||"View "+(n+1);s.buttons.push(shmi.createControl("button",s.tabs_anchor,{label:a},"DIV")),n===s.config["initial-view"]&&shmi.addClass(s.buttons[n].element,"selected"),s.buttons[n].listen("click",function getClickCB(e){return function(t){s.setView(e);for(var i=0;i<s.buttons.length;i++)shmi.removeClass(s.buttons[i].element,"selected");shmi.addClass(s.buttons[e].element,"selected")}}(n)),shmi.hasClass(s.element,"small")?shmi.addClass(s.buttons[n].element,"small"):shmi.hasClass(s.element,"large")&&shmi.addClass(s.buttons[n].element,"large")})),s.screen.addControl(e,t))}},shmi.extend(shmi.visuals.controls.TabPanel,shmi.visuals.core.BaseControl),shmi.registerControlType("tab-panel",shmi.visuals.controls.TabPanel,!0),shmi.pkg("visuals.controls"),shmi.visuals.controls.TextDisplay=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","text-display"),shmi.def(this.config,"template","default/text-display"),shmi.def(this.config,"name",null),shmi.def(this.config,"precision",-1),shmi.def(this.config,"type",shmi.c("TYPE_FLOAT")),shmi.def(this.config,"unit-scale",1),shmi.def(this.config,"label","text-display"),shmi.def(this.config,"unit-text",null),shmi.def(this.config,"decimal-delimiter","."),shmi.def(this.config,"auto-precision",!0),shmi.def(this.config,"auto-label",!0),shmi.def(this.config,"auto-unit-text",!0),shmi.def(this.config,"auto-type",!0),this.value=null,this.labelElement=null,this.valueElement=null,this.unitElement=null,this.initialized=!1,this._subscriptionTargetId=null,this.active=!1,this.vars={conditional:null},this.startup()},shmi.visuals.controls.TextDisplay.prototype={uiType:"text-display",getClassName:function(){return"TextDisplay"},onInit:function(){shmi.requires("visuals.tools.numericValues").initValueSettings(this),this.labelElement=shmi.getUiElement("text-display-label",this.element),this.labelElement||shmi.log("[TextDisplay] no text-display-label element provided",1),this.valueElement=shmi.getUiElement("text-display-value",this.element),this.valueElement?(this.unitElement=shmi.getUiElement("text-display-unit",this.element),this.unitElement||shmi.log("[TextDisplay] no text-display-unit element provided",1),shmi.log("[TextDisplay] -- all elements found --",1),this.config["unit-text"]&&this.unitElement&&(this.unitElement.innerHTML=shmi.localize(this.config["unit-text"])),this.config.label&&this.labelElement&&(this.labelElement.innerHTML=shmi.localize(this.config.label)),this.config["unit-scale"]&&(this.config["unit-scale"]=parseFloat(shmi.localize(this.config["unit-scale"])))):shmi.log("[TextDisplay] no text-display-value element provided",3)},onSetValue:function(e,t){var i=this;t===shmi.c("TYPE_STRING")?i.value=e:isNaN(parseFloat(e))?i.value=e:i.value=parseFloat(e),shmi.caf(i.requestID),i.requestID=shmi.raf((function(){i.asyncSet(t)}))},onSetProperties:function(e,t,i){var s=this,n=shmi.requires("visuals.tools.numericValues");n.setProperties(s,arguments)},asyncSet:function(e){var t=shmi.requires("visuals.tools.numericValues");if(shmi.visuals.session.deactivateControls)setTimeout(this.asyncSet.bind(this),shmi.c("ACTION_RETRY_TIMEOUT"));else{var i=t.formatOutput(this.value,this);this.valueElement.textContent=i}},onDisable:function(){this.vars.conditional&&this.vars.conditional.disable(),this.config.item&&shmi.visuals.session.ItemManager.unsubscribeItem(this.config.item,this._subscriptionTargetId),shmi.log("[TextDisplay] disabled",1)},onEnable:function(){null!==this.vars.conditional?this.vars.conditional.item!==this.config.item&&(this.vars.conditional.item=this.config.item):this.config.item&&(this.vars.conditional=shmi.createConditional(this.element,this.config.item)),this.vars.conditional&&this.vars.conditional.enable(),this.config.item?this._subscriptionTargetId=shmi.visuals.session.ItemManager.subscribeItem(this.config.item,this):this.config.action&&this.execute(this.config.action),shmi.log("[TextDisplay] enabled",1)},execute:function(e){for(var t=0,i=e.split(",");t<i.length;){if(0===(e=i[t]).indexOf("connect")){var s=e.split(":");if(3!==s.length)return void shmi.log("[TextDisplay] action has unknown format",3);var n=shmi.ctrl("."+s[1]);if(!n)return void shmi.log("[TextDisplay] '"+s[1]+"' not found in layout",3);var a=this;shmi.waitOnInit(n,(function(){n.callbacks[s[2]]=a.setValue.bind(a),a.setValue(n.getValue(s[2]))}))}else shmi.log("TextDisplay] unknown action: "+this.config.action,3);t++}},setLabel:function(e){this.config["auto-label"]&&this.labelElement&&(this.labelElement.textContent=shmi.localize(e))},setUnitText:function(e){this.config["auto-unit-text"]&&this.unitElement&&(this.unitElement.textContent=shmi.localize(e))}},shmi.extend(shmi.visuals.controls.TextDisplay,shmi.visuals.core.BaseControl),shmi.pkg("visuals.controls"),shmi.visuals.controls.TextElement=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","text"),shmi.def(this.config,"name",null),shmi.def(this.config,"text"," "),shmi.def(this.config,"bold",!1),shmi.def(this.config,"italic",!1),shmi.def(this.config,"underline",!1),shmi.def(this.config,"position","left"),shmi.def(this.config,"font-family","inherit"),shmi.def(this.config,"font-size",14),shmi.def(this.config,"items",[]),this.vars={itemValues:[],tokens:[],radId:0},this.startup()},shmi.visuals.controls.TextElement.prototype={uiType:"text",getClassName:function(){return"TextElement"},onInit:function(){if(this.config.text&&(this.element.textContent=shmi.localize(this.config.text),this.config.bold&&shmi.addClass(this.element,"text-bold"),this.config.italic&&shmi.addClass(this.element,"text-italic"),this.config.underline&&shmi.addClass(this.element,"text-underline"),"left"===this.config.position&&shmi.addClass(this.element,"text-left"),"center"===this.config.position&&shmi.addClass(this.element,"text-center"),"right"===this.config.position&&shmi.addClass(this.element,"text-right"),this.config["font-family"]&&(this.element.style.fontFamily=this.config["font-family"]),this.config["font-size"])){var e=this.config["font-size"]+"px";this.element.style.fontSize=e}shmi.log("[TextElement] inited",1)},onEnable:function(){var e=this,t=shmi.requires("visuals.tools.numericValues"),i=shmi.requires("visuals.session.ItemManager");Array.isArray(e.config.items)&&e.config.items.forEach((function(s,n){var a,l=i.getItemHandler();e.vars.itemValues.push({value:null,unit:null,label:null}),l.setValue=function setValue(s,a,l){var o=i.getItem(l),r=null;o&&(o.adapter&&o.adapter.unitText?r=o.adapter.unitText:"string"==typeof o.unit&&(r=o.unit),e.vars.itemValues[n]={value:t.formatNumber(o.readValue(!0),{precision:o.digits,unit:o.unit,"show-unit":!1}),unit:r,label:o.labelToken},e.updateText())},a=i.subscribeItem(s,l),e.vars.tokens.push(a)}))},onDisable:function(){this.vars.tokens.forEach((function(e){e.unlisten()})),this.vars.tokens=[]},updateText:function(){var e=this;shmi.caf(e.vars.rafId),e.vars.rafId=shmi.raf((function(){e.isActive()&&(e.element.textContent=shmi.evalString(shmi.localize(e.config.text),{items:e.vars.itemValues}))}))}},shmi.extend(shmi.visuals.controls.TextElement,shmi.visuals.core.BaseControl),shmi.pkg("visuals.controls"),shmi.visuals.controls.TextElement2Date=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","text2 text2-date"),shmi.def(this.config,"text"," "),shmi.def(this.config,"name",null),shmi.def(this.config,"dateformat","$YYYY-$MM-$DD, $HH:$mm:$ss"),shmi.def(this.config,"invalid-text","---"),shmi.def(this.config,"convert-to-utc",!1),this.subscriptionId=null,this.localeStr=null,this.invalidText=null,this.value=null,this.startup()},shmi.visuals.controls.TextElement2Date.prototype={uiType:"text2-date",getClassName:function(){return"TextElement2Date"},onInit:function(){this.localeStr=shmi.localize(this.config.dateformat),this.invalidText=shmi.localize(this.config["invalid-text"]),this.element.textContent=this.invalidText},onSetValue:function(e){shmi.caf(this.RAF_ID),this.RAF_ID=shmi.raf(function(){e=parseInt(e);var t=null,i=shmi.requires("visuals.tools.date.formatDateTime");t=e>0?i(e,{datestring:this.localeStr,utc:this.config["convert-to-utc"]}):this.invalidText,this.element.textContent=t}.bind(this))},onEnable:function(){this.config.item&&(this.subscriptionId=this.subscribeItem(this.config.item))},onDisable:function(){this.config.item&&this.unsubscribeItem(this.config.item,this.subscriptionId)},onLock:function(){},onUnlock:function(){}},shmi.extend(shmi.visuals.controls.TextElement2Date,shmi.visuals.core.BaseControl),shmi.visuals.controls.TextElement2=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","text2"),shmi.def(this.config,"text"," "),shmi.def(this.config,"name",null),shmi.def(this.config,"precision",-1),shmi.def(this.config,"options",[]),shmi.def(this.config,"pattern",null),shmi.def(this.config,"type",shmi.c("TYPE_STRING")),shmi.def(this.config,"decimal-delimiter","."),shmi.def(this.config,"auto-precision",!0),shmi.def(this.config,"auto-type",!0),shmi.def(this.config,"value-as-tooltip",!1),shmi.def(this.config,"item",null),this.uiType="text2",this.subscriptionId=null,this.value=null,this.startup()},shmi.visuals.controls.TextElement2.prototype={uiType:"text2",getClassName:function(){return"TextElement2"},onInit:function(){var e=null;shmi.requires("visuals.tools.numericValues").initValueSettings(this),this.config.text&&(e=shmi.localize(this.config.text),this.element.textContent=e,this.config["value-as-tooltip"]&&this.setTooltip(e))},onSetValue:function(e){var t=this,i=shmi.requires("visuals.tools.numericValues");shmi.caf(this.RAF_ID),this.RAF_ID=shmi.raf(function(){var s=null;if(void 0!==this.config.options&&Array.isArray(this.config.options)&&this.config.options.length>0){const t=this.config.options.find(t=>Number.isSafeInteger(t.mask)&&Number.isSafeInteger(t.value)?(e&t.mask)===t.value:t.value===e);t?(s=shmi.localize(t.label),this.element.textContent=s):this.element.textContent=e}else"string"==typeof t.config.pattern&&t.config.pattern.trim().length?(s=shmi.localize(shmi.evalString(t.config.pattern,{VALUE:e})),t.element.textContent=s):(s=i.formatOutput(e,t),this.element.textContent=s);t.config["value-as-tooltip"]&&("string"==typeof s&&""!==s?t.setTooltip(String(s)):t.setTooltip(t.getTooltip()))}.bind(this))},onSetProperties:function(e,t,i){var s=this,n=shmi.requires("visuals.tools.numericValues");n.setProperties(s,arguments)},onEnable:function(){this.config.item&&(this.subscriptionId=this.subscribeItem(this.config.item))},onDisable:function(){this.config.item&&this.unsubscribeItem(this.config.item,this.subscriptionId)}},shmi.extend(shmi.visuals.controls.TextElement2,shmi.visuals.core.BaseControl),shmi.pkg("visuals.controls"),shmi.visuals.controls.ToggleButton=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","toggle-button"),shmi.def(this.config,"template","default/toggle-button"),shmi.def(this.config,"name",null),shmi.def(this.config,"on-value",1),shmi.def(this.config,"off-value",0),shmi.def(this.config,"confirm-off-text","${V_CONFIRM_OFF}"),shmi.def(this.config,"confirm-on-text","${V_CONFIRM_ON}"),shmi.def(this.config,"confirm-on",!1),shmi.def(this.config,"confirm-off",!1),shmi.def(this.config,"on-label","on"),shmi.def(this.config,"off-label","off"),shmi.def(this.config,"on-icon-src",null),shmi.def(this.config,"on-icon-class",null),shmi.def(this.config,"off-icon-class",null),shmi.def(this.config,"off-icon-src",null),shmi.def(this.config,"on-icon-title",null),shmi.def(this.config,"off-icon-title",null),shmi.def(this.config,"auto-label",!0),shmi.def(this.config,"show-text",!0),shmi.def(this.config,"show-icon",!1),shmi.def(this.config,"on-action",[]),shmi.def(this.config,"off-action",[]),"string"==typeof this.config["confirm-on"]&&(this.config["confirm-on"]="true"===this.config["confirm-on"]),"string"==typeof this.config["confirm-off"]&&(this.config["confirm-off"]="true"===this.config["confirm-off"]),this.value=0,this.labelElement=null,this.alternatives=null,this.listeners=[],this.initialized=!1,this.active=!1,this._subscriptionTargetId=null,this.onAction=null,this.offAction=null,this.startup()},shmi.visuals.controls.ToggleButton.prototype={uiType:"toggle-button",getClassName:function(){return"ToggleButton"},events:["change"],onInit:function(){var e=this,t=shmi.requires("visuals.core");if(this.value=this.config["off-value"],this.alternatives=[],this.offstate=shmi.getUiElement("off-state",this.element),this.onstate=shmi.getUiElement("on-state",this.element),this.offstate&&this.onstate&&(this.alternatives.push(this.offstate),this.alternatives.push(this.onstate)),2===this.alternatives.length){var i;if(this.offLabel=shmi.getUiElement("label",this.alternatives[0]),this.offLabel&&this.config["off-label"]&&(this.offLabel.textContent=shmi.localize(this.config["off-label"])),this.onLabel=shmi.getUiElement("label",this.alternatives[1]),this.onLabel&&this.config["on-label"]&&(this.onLabel.textContent=shmi.localize(this.config["on-label"])),0===Number(this.value)?this.alternatives[1].style.display="none":this.alternatives[0].style.display="none",this.onIcon=shmi.getUiElement("toggle-button-icon",this.onstate),this.onIcon)if(this.config["on-icon-class"])"IMG"===this.onIcon.tagName&&(i=document.createElement("div"),shmi.addClass(i,"icon"),this.onIcon.parentNode.insertBefore(i,this.onIcon),this.onIcon.parentNode.removeChild(this.onIcon),this.onIcon=i),this.config["on-icon-class"].trim().split(" ").forEach((function(t){shmi.addClass(e.onIcon,t)}));else this.config["on-icon-src"]&&("IMG"===this.onIcon.tagName?this.onIcon.setAttribute("src",this.config["on-icon-src"]):console.log(this.uiType,"toggle-button-icon element is not an img-tag!"));if(this.offIcon=shmi.getUiElement("toggle-button-icon",this.offstate),this.offIcon)if(this.config["off-icon-class"])"IMG"===this.offIcon.tagName&&(i=document.createElement("div"),shmi.addClass(i,"icon"),this.offIcon.parentNode.insertBefore(i,this.offIcon),this.offIcon.parentNode.removeChild(this.offIcon),this.offIcon=i),this.config["off-icon-class"].trim().split(" ").forEach((function(t){shmi.addClass(e.offIcon,e.config["off-icon-class"])}));else this.config["off-icon-src"]&&("IMG"===this.offIcon.tagName?this.offIcon.setAttribute("src",this.config["off-icon-src"]):console.log(this.uiType,"toggle-button-icon element is not an img-tag!"));this.config["show-icon"]&&this.config["show-text"]?shmi.addClass(this.element,"icon-and-text"):this.config["show-icon"]&&shmi.addClass(this.element,"icon-only");var s={};s.onPress=function(){shmi.addClass(this.element,"pressed")}.bind(this),s.onClick=function(){this.config["confirm-on"]||this.config["confirm-off"]?this.value===this.config["on-value"]?this.config["confirm-off"]?shmi.confirm(this.config["confirm-off-text"],function(e){e&&this.toggle()}.bind(this)):this.toggle():this.config["confirm-on"]?shmi.confirm(this.config["confirm-on-text"],function(e){e&&this.toggle()}.bind(this)):this.toggle():this.toggle()}.bind(this),s.onRelease=function(){shmi.log("[ToggleButton] button released",0),shmi.removeClass(this.element,"pressed")}.bind(this),this.listeners.push(new shmi.visuals.io.MouseListener(this.offstate,s)),this.listeners.push(new shmi.visuals.io.TouchListener(this.offstate,s)),this.listeners.push(new shmi.visuals.io.MouseListener(this.onstate,s)),this.listeners.push(new shmi.visuals.io.TouchListener(this.onstate,s)),shmi.log("[ToggleButton] -- all elements found --",1),!this.config.item&&this.config.event&&(this.config["on-value"]=1,this.config["off-value"]=0),Array.isArray(e.config["on-action"])&&e.config["on-action"].length&&(e.onAction=new t.UiAction(e.config["on-action"],e)),Array.isArray(e.config["off-action"])&&e.config["off-action"].length&&(e.offAction=new t.UiAction(e.config["off-action"],e))}else shmi.log("[ToggleButton] "+this.alternatives.length+" state elements provided",1)},toggle:function(){var e=shmi.requires("visuals.session.ItemManager"),t=this.value!==this.config["on-value"];this.config.item?this.value===this.config["on-value"]?e.writeValue(this.config.item,this.config["off-value"]):e.writeValue(this.config.item,this.config["on-value"]):this.value===this.config["off-value"]?this.setValue(this.config["on-value"]):this.setValue(this.config["off-value"]),t&&this.onAction?this.onAction.execute():!t&&this.offAction&&this.offAction.execute()},getTooltip:function(){var e=shmi.visuals.core.BaseControl.prototype.getTooltip.call(this);if(e)return e;if(this.value===this.config["off-value"]){if(shmi.objectHasOwnProperty(this.config,"off-tooltip"))return this.config["off-tooltip"];if(shmi.objectHasOwnProperty(this.config,"off-icon-title"))return this.config["off-icon-title"]}else if(this.value===this.config["on-value"]){if(shmi.objectHasOwnProperty(this.config,"on-tooltip"))return this.config["on-tooltip"];if(shmi.objectHasOwnProperty(this.config,"on-icon-title"))return this.config["on-icon-title"]}return null},onSetValue:function(e){var t=this.value;this.value=parseFloat(e),this.value===this.config["off-value"]?(this.alternatives[1].style.display="none",this.alternatives[0].style.display=""):(this.alternatives[0].style.display="none",this.alternatives[1].style.display=""),this.value!==t&&(this.setTooltip(this.getTooltip()),this.fire("change",{value:this.value}))},getValue:function(){return this.value},onEnable:function(){this.config.item&&(this._subscriptionTargetId=shmi.visuals.session.ItemManager.subscribeItem(this.config.item,this)),this.listeners.forEach((function(e){e.enable()})),shmi.log("[ToggleButton] enabled",1)},onDisable:function(){this.config.item&&shmi.visuals.session.ItemManager.unsubscribeItem(this.config.item,this._subscriptionTargetId),this.listeners.forEach((function(e){e.disable()})),shmi.log("[ToggleButton] disabled",1)},onLock:function(){for(var e=0;e<this.listeners.length;e++)this.listeners[e].disable();shmi.addClass(this.element,"locked"),shmi.log("[ToggleButton] locked",1)},onUnlock:function(){for(var e=0;e<this.listeners.length;e++)this.listeners[e].enable();shmi.removeClass(this.element,"locked"),shmi.log("[ToggleButton] unlocked",1)},onSetProperties:function(){},setLabel:function(e){this.config["auto-label"]&&(this.onLabel&&(this.onLabel.textContent=shmi.localize(e)),this.offLabel&&(this.offLabel.textContent=shmi.localize(e)))}},shmi.extend(shmi.visuals.controls.ToggleButton,shmi.visuals.core.BaseControl),shmi.pkg("visuals.controls"),shmi.visuals.controls.ToggleDisplay=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","toggle-display"),shmi.def(this.config,"template","default/toggle-display"),shmi.def(this.config,"name",null),shmi.def(this.config,"labels",[]),shmi.def(this.config,"conditions",[]),this.value=0,this.labelElement=null,this.alternatives=null,this.currentState=0,this.initialized=!1,this.active=!1,this._subscriptionTargetId=null,this.vars={conditional:null},this.startup()},shmi.visuals.controls.ToggleDisplay.prototype={uiType:"toggle-display",getClassName:function(){return"ToggleDisplay"},onInit:function(){if(this.alternatives=shmi.getUiElements("state",this.element),0!==this.alternatives.length){this.labels=[];for(var e=0;e<this.alternatives.length;e++){var t=shmi.getUiElement("label",this.alternatives[e]);t&&(this.config.labels&&void 0!==this.config.labels[e]?t.textContent=shmi.localize(this.config.labels[e]):shmi.log("[ToggleDisplay] no label configured for state "+e,2)),this.labels.push(t)}for(e=0;e<this.alternatives.length;e++)shmi.addClass(this.alternatives[e],"hidden");shmi.removeClass(this.alternatives[0],"hidden"),shmi.log("[ToggleDisplay] -- all elements found --",1)}else shmi.log("[ToggleDisplay] "+this.alternatives.length+" state elements provided",2)},onSetValue:function(value){this.value=parseFloat(value),shmi.caf(this.requestID),this.requestID=shmi.raf(function(){for(var i=0;i<this.config.conditions.length;i++)if(eval(this.config.conditions[i].replace(/%VALUE%/g,value))){this.setSelected(i);break}}.bind(this))},setSelected:function(e){e!==this.currentState&&(shmi.addClass(this.alternatives[this.currentState],"hidden"),shmi.removeClass(this.alternatives[e],"hidden"),this.currentState=e)},getValue:function(){return this.value},onEnable:function(){null!==this.vars.conditional?this.vars.conditional.item!==this.config.item&&(this.vars.conditional.item=this.config.item):this.config.item&&(this.vars.conditional=shmi.createConditional(this.element,this.config.item)),this.vars.conditional&&this.vars.conditional.enable(),this.config.item&&(this._subscriptionTargetId=shmi.visuals.session.ItemManager.subscribeItem(this.config.item,this)),shmi.log("[ToggleDisplay] enabled",1)},onDisable:function(){this.vars.conditional&&this.vars.conditional.disable(),this.config.item&&shmi.visuals.session.ItemManager.unsubscribeItem(this.config.item,this._subscriptionTargetId),shmi.log("[ToggleDisplay] disabled",1)},onLock:function(){shmi.addClass(this.element,"locked"),shmi.log("[ToggleDisplay] locked",1)},onUnlock:function(){shmi.removeClass(this.element,"locked"),shmi.log("[ToggleDisplay] unlocked",1)}},shmi.extend(shmi.visuals.controls.ToggleDisplay,shmi.visuals.core.BaseControl),shmi.pkg("visuals.controls.TrendDisplay"),shmi.visuals.controls.TrendDisplay=function(e,t){"use strict";var i=new shmi.visuals.controls.TrendDisplay.Data(this),s=new shmi.visuals.controls.TrendDisplay.Messaging,n=new shmi.visuals.controls.TrendDisplay.Promise,a=0,l=t||{};shmi.def(l,"class-name","trend-display"),shmi.def(l,"template","default/trend-display/base"),shmi.def(l,"name",null),shmi.def(l,"styleId",null),Object.defineProperty(this,"element",{value:e}),Object.defineProperty(this,"data",{value:i}),Object.defineProperty(this,"tStart",{value:shmi.getServerTime()}),Object.defineProperty(this,"config",{get:function(){return l},set:function(e){e instanceof shmi.visuals.controls.TrendDisplay.Configuration&&(l.isConfigured&&e.invalid||(l=e,n.resolve(l)))}}),Object.defineProperty(this,"onBroadcast",{value:s}),Object.defineProperty(this,"isConfigured",{value:n}),Object.defineProperty(this,"isPreparing",{get:function(){return a>0},set:function(e){e?(a||(shmi.addClass(this.element,"preparing"),this.broadcast(this,"preparation-started")),a++):(0===--a&&(shmi.removeClass(this.element,"preparing"),this.broadcast(this,"preparation-finished")),a<0&&(a=0))}}),this._components={},this.controls=[],this.parseAttributes(),this.startup()},shmi.visuals.controls.TrendDisplay.iconDimensions={height:16,width:16},shmi.visuals.controls.TrendDisplay.prototype={uiType:"trend-display",isContainer:!0,getClassName:function(){"use strict";return"TrendDisplay"},_manageResizeListeners:function(e){var t=this,i=null;this._onResize||(this._onResize=function(){i&&(window.clearTimeout(i),i=null),i=window.setTimeout((function(){i=null,t.broadcast(t,"resize")}),100)}),e?(window.addEventListener("resize",this._onResize,!1),window.addEventListener("visuals-layout-change",this._onResize,!1)):(window.removeEventListener("resize",this._onResize),window.removeEventListener("visuals-layout-change",this._onResize))},onRegister:function(e){var t=this,i=shmi.visuals.controls.TrendDisplay.Promise;t.config.display&&t.config.display.type&&("multilane"===t.config.display.type.toLowerCase()||"multi"===t.config.display.type.toLowerCase())&&shmi.addClass(t.element,"swim-lane"),t.isPreparing="initializing-base",t.onBroadcast.push([1e3,this._onBroadcastEarly,this]),t.onBroadcast.push([-1e3,this._onBroadcastLate,this]),i.resolve(new shmi.visuals.controls.TrendDisplay.Configuration(this).update(this.config).then((function(i){return t.config=i,t.isDeleted()?t:(t.parseChildren(t.element,(function(i){t.discoverComponents(i),i.forEach((function(e){e.fire("discover",{trendDisplay:t})})),e()})),t)})))},onInit:function(){"use strict";var e=shmi.visuals.controls.TrendDisplay;this._manageResizeListeners(!0);var t=new e.VirtualItems(this);Object.defineProperty(this,"items",{value:t}),this.isPreparing=!1},discoverComponents:function(e){"use strict";var t=this;return e.forEach((function(e){t.addComponent(e)})),this},getComponents:function(e){"use strict";var t=this._components;return shmi.objectHasOwnProperty(t,e)?t[e]:[]},addComponent:function(e){"use strict";var t,i;return(e instanceof shmi.visuals.core.BaseControl||shmi.objectHasOwnProperty(e,"uiType"))&&(t=e.uiType,i=this._components,shmi.objectHasOwnProperty(i,t)||(i[t]=[]),-1===(i=i[t]).indexOf(e)&&i.push(e)),this},everyComponent:function(e,t){"use strict";var i=this._components;arguments.length<2&&(t=e,e=null),e?(i[e]||[]).forEach(t):Object.keys(i).forEach((function(e){(i[e]||[]).forEach(t)}))},addInitializer:function(){},removeInitializer:function(){},_onBroadcastEarly:function(e){var t=this;switch(e.type){case"render":e.detail.suppress=this.isPreparing;break;case"configuration-changed":var i=e.detail.configuration;if(i.invalid)return this.lock(),!1;this.config=i,this.unlock();break;case"scale-size":var s=e.detail.now>1?e.detail.now-1:"none";[].forEach.call(t.element.classList,(function(e){0===e.indexOf("scale-size-")&&shmi.removeClass(t.element,e)})),shmi.addClass(this.element,"scale-size-"+s)}return!0},_onBroadcastLate:function(e){switch(e.type){case"resize":this.broadcast("render")}},onEnable:function(){var e=this.getComponents("trend-display-continuous")[0],t=e?e.trend:null;t&&(t.active=!0,t.running=!0),this.everyComponent((function(e){e.enable()}))},onDisable:function(){var e=this.getComponents("trend-display-continuous")[0],t=e?e.trend:null;t&&(t.active=!1,t.running=!1),this.everyComponent((function(e){e.disable()}))},onDelete:function(){"use strict";var e=this;e.ctrls&&(Object.keys(e.ctrls).forEach((function(t){e.ctrls[t]&&shmi.deleteControl(e.ctrls[t])})),e.ctrls={}),this.everyComponent((function(e){shmi.deleteControl(e)})),this._components={},this._manageResizeListeners(!1),this.onBroadcast.reset();var t=this.items;t&&(t.items=null),localStorage.itemStyles=[]},broadcast:function(e,t,i){"use strict";return"object"==typeof i&&i||(i={}),this.onBroadcast.send({source:e,type:t,detail:i})}},shmi.visuals.controls.TrendDisplay.derive=function(e,t,i){"use strict";var s=e.prototype||{};e.prototype=Object.create(t.prototype),e.prototype.constructor=e,e.prototype.constructor._super=t,Object.getOwnPropertyNames(s).forEach((function(t){e.prototype[t]=s[t]})),e.prototype._super=function(e,t){var i;for(i=Object.getPrototypeOf(e.prototype);i;i=Object.getPrototypeOf(i))if("function"==typeof i[t])return i[t].apply(this,[].slice.call(arguments,2))};var n=String(e.name||i||"").trim();!n||n in e.prototype||Object.defineProperty(e.prototype,n,{value:e}),e.prototype.uiType&&shmi.log("derived type "+e.prototype.uiType,shmi.c("LOG_DEBUG"))},shmi.visuals.controls.TrendDisplay.onConfiguration=[],shmi.visuals.controls.TrendDisplay.nop=function(){},shmi.visuals.controls.TrendDisplay.limit=function(e,t,i){var s=parseFloat(e)||0;return s<t?t:s>i?i:s},shmi.visuals.controls.TrendDisplay.fastBind=function(e,t){return function(){return e.apply(t,arguments)}},shmi.visuals.controls.TrendDisplay.getScrollOffset=void 0!==window.pageXOffset&&void 0!==window.pageYOffset?function(){return{x:window.pageXOffset,y:window.pageYOffset}}:function(){return{x:(document.documentElement||document.body.parentNode||document.body).scrollLeft,y:(document.documentElement||document.body.parentNode||document.body).scrollTop}},shmi.visuals.controls.TrendDisplay.onUiAction=function(e,t,i){"use strict";var s=shmi.getControlByName(e,"trend-display");s?s.broadcast(null,"ui-"+t,{cause:"action",value:i||{}}):shmi.log("[UserAction] "+t+" - no control found by name '"+e+"'",2)},shmi.extend(shmi.visuals.controls.TrendDisplay,shmi.visuals.core.BaseControl),shmi.pkg("visuals.session"),shmi.visuals.session.sysActions=shmi.visuals.session.sysActions||{},shmi.visuals.session.sysActions["show-curve"]=function(e){"use strict";e.length<2?shmi.log("[UserAction] show-curve - usage is 'show-curve:<control-name>:<curve-name>[:<state>]'",2):shmi.visuals.controls.TrendDisplay.onUiAction(e[0],"show-curve",{curve:e[1],isVisible:e.length<3||shmi.toBoolean(e[2])})},shmi.visuals.controls.TrendDisplay.Messaging=function Messaging(e){this._listeners=[],this._listeners.nextId=0,this._sentBefore=shmi.visuals.controls.TrendDisplay.Promise.resolve(),Object.defineProperty(this,"synchronous",{get:function(){return e},set:function(t){e=!!t}}),Object.defineProperty(this,"length",{get:function(){return this._listeners.length}})},shmi.visuals.controls.TrendDisplay.Messaging.prototype={addListener:function(e,t,i){var s=this._listeners,n=this._normalizeListener.apply(this,arguments),a=this._indexOfListenerSignature(n);if(a>=0)return s[a][3];var l=++s.nextId;return s.push([n.prio,n.fn,n.context,l]),this._listeners=s.sort((function(e,t){return t[0]-e[0]})),l},push:function(e){return this.addListener.apply(this,arguments)},removeListener:function(e,t,i){var s=this.isListeningAt.apply(this,arguments);return s>=0&&this._listeners.splice(s,1),this},isListeningAt:function(e,t,i){var s=parseInt(e);return s>0&&1===arguments.length?this._indexOfListenerId(e):this._indexOfListenerSignature(this._normalizeListener.apply(this,arguments))},_normalizeListener:function(e,t,i){var s;return"function"==typeof(s=Array.isArray(e)?e:[e,t,i])[0]&&s.unshift(0),"function"!=typeof s[1]&&shmi.log("invalid listener callback",3),s[2]?"object"!=typeof s[2]&&shmi.log("TrendDisplay.Messaging._normalizeListener() invalid context for listener callback",3):s[2]=this,{prio:s[0],fn:s[1],context:s[2]}},_indexOfListenerId:function(e){var t,i,s=this._listeners;if((e=parseInt(e))>0)for(t=0,i=s.length;t<i;t++)if(s[t][3]===e)return t;return-1},_indexOfListenerSignature:function(e){var t,i,s=this._listeners;for(t=0,i=s.length;t<i;t++)if(s[t][1]===e.fn&&s[t][2]===e.context)return t;return-1},send:function(){var e,t,i;for(e=[],t=0,i=arguments.length;t<i;t++)e[t]=arguments[t];return this.synchronous?this._sendSynchronous(e):this._sendAsynchronous(e)},_sendSynchronous:function(e){var t,i,s,n,a=!1;for(t=0,i=(s=this._listeners).length;t<i&&!a;t++)!1===(n=s[t])[1].apply(n[2],e)&&(a=!0);return shmi.visuals.controls.TrendDisplay.Promise.resolve(a)},_sendAsynchronous:function(e){var t=this;return this._sentBefore=this._sentBefore.always((function(){var i=shmi.visuals.controls.TrendDisplay.Promise,s=!1;return i.resolve(t._listeners).each((function(t){var n=t[1].apply(t[2],e);return!1===n?s=!0:n instanceof i&&(n=n.then((function(e){return!1===e&&(s=!0),e}))),n}),(function(){return s})).then((function(){return s}))}))},merge:function(e){var t,i,s=e;if(s instanceof shmi.visuals.controls.TrendDisplay.Messaging&&(s=s._listeners),Array.isArray(s))for(t=0,i=s.length;t<i;t++)this.push(s[t]);return this},reset:function(){return this._listeners=[],this}},shmi.visuals.controls.TrendDisplay.Messaging.wrap=function(e){return(new shmi.visuals.controls.TrendDisplay.Messaging).merge(e)},shmi.visuals.controls.TrendDisplay.Object={injectFrozen:function injectFrozen(e,t,i){"use strict";var s=e;return Object.keys(t).forEach((function(e){var n=t[e];i&&(n=function _deepFreeze(e){if(e&&"object"==typeof e)return Object.isFrozen(e)?e:(Object.getOwnPropertyNames(e).forEach((function(t){var i=e[t];"object"==typeof i&&function trySet(e,t,i){try{e[t]=i}catch(e){console.error("[TrendDisplay]",e)}}(e,t,_deepFreeze(i))})),Object.freeze(e));return e}(n)),Object.defineProperty(s,e,{value:n,enumerable:!0})})),e},inject:function inject(e,t){"use strict";var i=e;return Object.keys(t).forEach((function(e){Object.defineProperty(i,e,{value:t[e],enumerable:!0,configurable:!0})})),e},injectObserved:function injectObserved(e,t,i,s,n){"use strict";var a=e,l="string"==typeof s?s:"";return Object.keys(t).forEach((function(e){var o=t[e];!s||null===o||"object"!=typeof o||Object.isFrozen(o)||Object.isSealed(o)||o.dontObserve||Array.isArray(o)||(o=shmi.visuals.controls.TrendDisplay.Object.injectObserved({},o,i,l+e+".",n)),n&&n.indexOf(l+e)>=0?Object.defineProperty(a,e,{value:o,enumerable:!0}):Object.defineProperty(a,e,{get:function(){return o},set:function(s){if(s!==t[e]){if("function"==typeof i)try{i(s,l+e,t[e])}catch(e){return}t[e]=s}},enumerable:!0})})),Object.seal(e),e},deepCopy:function deepCopy(e){var t;return Array.isArray(e)?(t=[],e.forEach((function(e){t.push(shmi.visuals.controls.TrendDisplay.Object.deepCopy(e))}))):e&&"object"==typeof e?(t={},Object.keys(e).forEach((function(i){t[i]=shmi.visuals.controls.TrendDisplay.Object.deepCopy(e[i])}))):t=e,t},mixinArray:function(e,t){Object.defineProperty(e,"length",{value:t}),e.map=function(t){return[].map.call(e,t)},e.filter=function(t){return[].filter.call(e,t)},e.some=function(t){return[].some.call(e,t)},e.every=function(t){return[].every.call(e,t)},e.reverse=function(t){return[].reverse.call(e,t)},e.sort=function(t){return[].sort.call(e,t)},e.forEach=function(t){return[].forEach.call(e,t)}}},shmi.visuals.controls.TrendDisplay.Promise=function Promise(e){"use strict";if(this._queue=[],this._state=0,this._length=1,this._creator=void 0,(shmi.visuals.session.config||{}).debug){var t,i,s,n=new Error("dummy"),a=0,l=shmi.visuals.controls.TrendDisplay.Promise._simpleTry((function(){return String(n.stack)}),(function(){return""})).split(/(?:\n\s+)/);for(i=0,s=l.length;i<s;i++)if((t=l[i]).match(/^\s*at\s+[^(]*\.Promise[.(]/))a=1;else if(a>0){a=2;break}var o=a>1&&t.match(/\/([/]+:\d+:\d+)\)?\s*$/);this._creator=o?o[1]:"unknown"}if("function"==typeof e&&e.length>=1){var r=this,_resolve=function(e){shmi.visuals.controls.TrendDisplay.Promise._resolve(r,e)},_reject=function(e){r.reject(e)};shmi.visuals.controls.TrendDisplay.Promise._simpleTry((function(){e(_resolve,_reject)}),_reject)}},shmi.visuals.controls.TrendDisplay.Promise.prototype={dontObserve:!0,isSettled:function(){"use strict";return!!this._state},isResolved:function(){"use strict";return this._state>0},isRejected:function(){"use strict";return this._state<0},then:function(e,t){"use strict";var i=new shmi.visuals.controls.TrendDisplay.Promise;if(i._creator=this._creator,i._length=this._length+1,e instanceof shmi.visuals.controls.TrendDisplay.Promise){var s=e;e=function(e){return s.resolve(e)}}else if("function"!=typeof e){var n=e;e=function(e){return void 0!==n?n:e}}if(t instanceof shmi.visuals.controls.TrendDisplay.Promise){var a=t;t=function(e){return a.reject(e)}}else if("function"!=typeof t){var l=t;t=function(e){throw void 0!==l?l:e}}return 1===this._queue.push([e,t,i])&&this._state&&shmi.visuals.controls.TrendDisplay.Promise._process(this),i},always:function(e){"use strict";return this.then(e,e)},resolve:function(e){"use strict";return this._state||(this._state=1,this._value=e,shmi.visuals.controls.TrendDisplay.Promise._process(this)),this},reject:function(e){"use strict";return this._state||(this._state=-1,this._value=e,shmi.visuals.controls.TrendDisplay.Promise._process(this)),this},catch:function(e){"use strict";var t=[].slice.call(arguments,0),i=t.pop();return this.then(void 0,(function(e){var s,n,a,l=!1;for(s=0,n=t.length;!l&&s<n;s++)"function"==typeof(a=t[s])&&(/^\S+Error$/.test(a.name)?e instanceof a&&(l=!0):l=a(e));return l||!n?i.call(i,e):(new shmi.visuals.controls.TrendDisplay.Promise).reject(e)}))},return:function(e){"use strict";return this.then((function(){return e}))},spread:function(e){"use strict";var t=this;return t.then((function(i){return"[object Array]"!==Object.prototype.toString.call(i)&&(i=[i]),e.apply(t,i)}))},each:function(e,t){"use strict";return"function"!=typeof t&&(t=shmi.visuals.controls.TrendDisplay.nop),this.then((function(i){if("[object Array]"!==Object.prototype.toString.call(i)&&!(i&&i.length>0))return i;var s=i.length;return function next(n){return n>=s?i:shmi.visuals.controls.TrendDisplay.Promise.resolve(e(i[n])).then((function(){return t.apply({},arguments)?i:next(n+1)}))}(0)}))},filter:function(e){"use strict";return this.then((function(t){if("[object Array]"!==Object.prototype.toString.call(t)&&!(t&&t.length>0))return t;var i=(t=[].slice.call(t)).length;return function next(s){return s>=i?shmi.visuals.controls.TrendDisplay.Promise.resolve(t):shmi.visuals.controls.TrendDisplay.Promise.resolve(e(t[s])).then((function(e){return e?next(s+1):(t.splice(s,1),i--,next(s))}))}(0)}))},find:function(e){"use strict";return this.then((function(t){"[object Array]"!==Object.prototype.toString.call(t)&&(t=[t]);var i=t.length;return function next(s){return s>=i?shmi.visuals.controls.TrendDisplay.Promise.resolve(null):shmi.visuals.controls.TrendDisplay.Promise.resolve(e(t[s])).then((function(e){return e?t[s]:next(s+1)}))}(0)}))},trigger:function(e){"use strict";return this.then((function(t){return e.resolve(t),t}),(function(t){throw e.reject(t),t}))},finally:function(e){"use strict";return this.then((function(t){return shmi.visuals.controls.TrendDisplay.Promise.invoke(e).always((function(){return t}))}),(function(t){return shmi.visuals.controls.TrendDisplay.Promise.invoke(e).always((function(){throw t}))}))}},shmi.visuals.controls.TrendDisplay.Promise._simpleTry=function(e,t){"use strict";try{return e()}catch(e){return t?t(e):e}},shmi.visuals.controls.TrendDisplay.Promise._applyTry=function(e,t,i,s){"use strict";try{return e.apply(i,s)}catch(e){return t?t(e):e}},shmi.visuals.controls.TrendDisplay.Promise._async=function(e){"use strict";var t=1,i={};function _async(e){var s=t++;s%100==0&&function reduceMap(){var e={};Object.keys(i).forEach((function(t){i[t]&&(e[t]=i[t])})),i=e}(),i[s]=e,window.postMessage(s,"*")}window.addEventListener("message",(function(e){var t,s=Number(e.data);s>0&&("function"==typeof(t=i[s])&&t(),i[s]=void 0)}),!1),shmi.visuals.controls.TrendDisplay.Promise._async=_async,_async(e)},shmi.visuals.controls.TrendDisplay.Promise._resolve=function _resolve(e,t){"use strict";e===t&&shmi.log("TrendDisplay.Promise_resorlve() promise on itself rejected",3);var i=!1;function onReject(t){i||(e.reject(t),i=!0)}if("object"==typeof t&&t){var s=t.then;if("function"==typeof s)return void shmi.visuals.controls.TrendDisplay.Promise._applyTry(s,onReject,t,[function onResolve(t){i||(_resolve(e,t),i=!0)},onReject])}e.resolve(t)},shmi.visuals.controls.TrendDisplay.Promise._process=function _process(e){"use strict";var t=shmi.visuals.controls.TrendDisplay.Promise,i=e._queue,s=i.shift();s||(s=i.shift()),s&&(i.length||i.push(!1),t._async((function processor(){var i=t._simpleTry((function(){t._resolve(s[2],(e._state>0?s[0]:s[1])(e._value))}));if(i){if((shmi.visuals.session.config||{}).debug){var n=i;/^\[object\s\S*Error]$/.test(Object.prototype.toString.call(i))&&(n=i.stack||i.message||String(i).replace(/@[^:]+:\/\/[^/]+\//gm,"@")),!/^\s*\S+Error/.test(n)&&i.message&&(n=i.message+"\nin "+n),/^\s*\S+Error/.test(n)||(n=i.constructor.name+": "+n),shmi.log("exception in thenable: "+n)}s[2].reject(i)}_process(e)})))},shmi.visuals.controls.TrendDisplay.Promise.invoke=function(e){"use strict";try{return shmi.visuals.controls.TrendDisplay.Promise.resolve(e())}catch(e){return shmi.visuals.controls.TrendDisplay.Promise.reject(e)}},shmi.visuals.controls.TrendDisplay.Promise.resolve=function(e){"use strict";return e instanceof shmi.visuals.controls.TrendDisplay.Promise?e:(new shmi.visuals.controls.TrendDisplay.Promise).resolve(e)},shmi.visuals.controls.TrendDisplay.Promise.reject=function(e){"use strict";return e instanceof shmi.visuals.controls.TrendDisplay.Promise&&e.isRejected()?e:new shmi.visuals.controls.TrendDisplay.Promise((function(t,i){e instanceof shmi.visuals.controls.TrendDisplay.Promise?e.always((function(){i(e)})):i(e)}))},shmi.visuals.controls.TrendDisplay.Promise.try=function(e){"use strict";return new shmi.visuals.controls.TrendDisplay.Promise((function(t){t(e())}))},shmi.visuals.controls.TrendDisplay.Promise.delay=function(e,t){"use strict";return new shmi.visuals.controls.TrendDisplay.Promise((function(e){setTimeout(e,t||0)}))},shmi.visuals.controls.TrendDisplay.Promise.all=function(e){"use strict";if(1===arguments.length&&Array.isArray(e))return shmi.visuals.controls.TrendDisplay.Promise.all.apply(this,e);var t,i,s=new shmi.visuals.controls.TrendDisplay.Promise,n=arguments,a=0,l={};try{n.length||s.resolve([]);var onSettling=function(e){if(++a>=e){var t,i=[];for(t=0;t<e;t++)i.push(l[t]);s.resolve(i)}};for(t=0,i=n.length;t<i;t++)step(t,i)}catch(e){s.reject(e)}return s;function step(e,t){n[e]instanceof shmi.visuals.controls.TrendDisplay.Promise?n[e].then((function(i){l[e]=i,onSettling(t)}),s):(l[e]=n[e],onSettling(t))}},shmi.visuals.controls.TrendDisplay.Promise.first=function(e){"use strict";if(1===arguments.length&&Array.isArray(e))return shmi.visuals.controls.TrendDisplay.Promise.all.apply(this,e);var t,i,s=new shmi.visuals.controls.TrendDisplay.Promise,n=arguments;try{for(n.length||s.resolve([]),t=0,i=n.length;t<i;t++)n[t].then(s,s)}catch(e){s.reject(e)}return s},shmi.visuals.controls.TrendDisplay.Parsers={aggregation:function(e,t,i){"use strict";if(null==e)return t;switch(String(e).trim().toLowerCase()){case"":return t;case"0":case"none":return 0;case"1":case"avg":case"average":return 1;case"2":case"min":case"minimum":return 2;case"3":case"max":case"maximum":return 3;case"4":case"sum":return 4;case"5":case"min-max":case"minimum-maximum":return 5}return arguments.length>2?i:t},timeSpanUnit:function(e,t,i){"use strict";var s=String(e||"").trim().replace(/(\d)(?:-|\s+)(\w)/,"$1$2").toLowerCase();switch(s){case"":return t;case"none":case"auto":return 0;case"s":case"sec":case"second":case"seconds":return 1;case"10s":case"10sec":case"10seconds":return 10;case"m":case"min":case"minute":case"minutes":return 180;case"10m":case"10min":case"10minutes":return 600;case"h":case"hour":case"hours":return 3600;case"d":case"day":case"days":return 86400;case"w":case"week":case"weeks":return 604800;case"month":case"months":return 2678400;case"y":case"year":case"years":return 31536e3;default:if((s=parseInt(s))>=0)return s}return arguments.length>2?i:t},valuedTimeSpan:function(e,t,i){"use strict";var s,n;if(n=/^\s*(\d+)\s*(s(?:ec(?:onds?)?)?|m(?:in(?:utes?)?)?|h(?:(?:ou)?rs?)?|d(?:ays?)?|w(?:eeks?)?|mon(?:ths?)?|y(?:(?:ea)rs?)?)?\s*$/i.exec(e))switch(s=Number(n[1]),n[2].toLowerCase().substr(0,2)){case"":case"s":case"se":return s;case"m":case"mi":return 60*s;case"h":case"ho":case"hr":return 3600*s;case"d":case"da":return 86400*s;case"w":case"we":return 7*s*86400;case"mo":return 31*s*86400;case"y":case"ye":case"yr":return 365*s*86400}else if(!String(e||"").trim().length)return t;return arguments.length>2?i:t},none:function(e){switch(String(e).trim()){case"":case"null":case"undefined":case"none":case"false":return null;default:return e}},color:function(e){"use strict";if("string"==typeof e){var t=null,i=/^(?:rgba?\s*\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)(?:\s*,\s*([01](?:\.\d*)?))?\s*\)|#([0-9a-f]{6})([0-9a-f]{2})?)$/i.exec(e);i&&(t={},"string"==typeof i[1]?(t.red=Math.min(255,i[1]),t.green=Math.min(255,i[2]),t.blue=Math.min(255,i[3]),t.hasAlpha=!!i[4],t.alpha=t.hasAlpha?parseFloat(i[4]):1,t.alpha>1&&(t.alpha=1)):(t.red=parseInt(i[5].substr(0,2),16),t.green=parseInt(i[5].substr(2,2),16),t.blue=parseInt(i[5].substr(4,2),16),t.hasAlpha="string"==typeof i[6],t.alpha=t.hasAlpha?parseInt(i[6],16)/255:1,t.alpha>1&&(t.alpha=1))),e=t}else e&&"object"==typeof e&&(e.hasAlpha|=e.alpha<1);return e&&"object"==typeof e&&(e.rgba="rgba("+e.red+","+e.green+","+e.blue+","+e.alpha+")",e.hex="#"+("00"+e.red.toString(16)).substr(-2)+("00"+e.green.toString(16)).substr(-2)+("00"+e.blue.toString(16)).substr(-2),e.hexa=e.hex+("00"+Math.round(255*e.alpha).toString(16)).substr(-2)),e},timestamp:function(e,t){"use strict";var i=null,s=parseInt(e);if(s>=-1&&isFinite(s))i=s;else switch(s=String(e).trim()){case"now":i=0;break;case"":i=t?-1:0;break;case"live":i=-1;break;default:s=Date.parse(s),isNaN(s)||(i=s.getTime()/1e3)}return i},width:function(e){"use strict";var t=null,i=/^\s*(\d+)\s*(?:px)?\s*$/.exec(e);return i&&(t=parseInt(i[1])),t},relative:function(e){"use strict";var t=null,i=/^\s*(0?(?:\.\d+)?|1(?:.0+)?)\s*$/.exec(e);return i&&(t=parseFloat(i[1])),t},positive:function(e){"use strict";return(e=parseInt(e))>0?e:null},dash:function(e){"use strict";return"string"==typeof e&&(e=e.trim().split(/(?:[,\s]+)/)),Array.isArray(e)&&(e=e.map((function(e){return parseInt(e)})).filter((function(e){return e}))).length>0?e:null},url:function(e){"use strict";if("string"==typeof e){var t=/^url\(\s*(["'])?\s*(.+)\s*(\1)\s*\)$/.exec(e);return t&&(e=t[2]),e}return e||null},isObject:function(e){return e?"object"==typeof e?e:(console.error("TrendDisplay.Parsers.isObject() expecting object, but found: "+e,3),null):{}},parseFilterAndSort:function(e,t,i){return e.map((function(e){return t(e)})).filter((function(e){return e})).sort(i?function rev(e,t){return t-e}:function fwd(e,t){return e-t})}},shmi.visuals.controls.TrendDisplay.VirtualItems=function(e){"use strict";var t=null;Object.defineProperty(this,"trendDisplay",{value:e}),Object.defineProperty(this,"items",{get:function(){return t&&t.curves||(t=this._createItems(t||{},e)),t},set:function(e){e?this._releaseSignalItems(t):t&&(this._releaseItems(t),t=null)}}),e.onBroadcast.push([900,this._onBroadcast,this])},shmi.visuals.controls.TrendDisplay.VirtualItems.prototype={_createSingleItem:function(e,t,i,s,n,a,l){var o=shmi.visuals.controls.TrendDisplay.nop,r=shmi.visuals.session.ItemManager,c={name:e,setValue:l?function _onChangeValue(e){c.lastValue=e;var t=c.suppress.indexOf(e);t>=0?c.suppress.splice(t,1):l.apply(this,arguments)}:o,setProperties:o,suppress:[],lock:o,unlock:o,properties:{access:["read","write"],data_type:null,digits:3===t?3:0,item_alias:e,label:null,min:s,max:n,prewarn:null,warn:null,step:0,unit:null,value_type:["string","bool","int","float"][t]},writeValue:function(e,t){shmi.objectHasOwnProperty(c,"lastValue")&&e===c.lastValue||(c.lastValue=e,l&&t&&c.suppress.push(e),r.getItem(c.name).writeValue(e))}},u=r.getItem(e),h=!u||!u.tdInitialized;return c.subscriptionId=r.subscribeItem(e,c),h&&(r.setProperties(c.properties),(u=r.getItem(e)).tdInitialized=!0),u.writeValue(a),c},_createGlobalItems:function(e,t){var i=shmi.c,s=i("TYPE_BOOL"),n=i("TYPE_FLOAT"),a=t.config,l="virtual:"+t.getName();return e.zoomX||(e.zoomX=this._createSingleItem(l+":zoomX",n,7,100*i("TREND_DISPLAY_ZOOM_SCALE_X_MIN"),100*i("TREND_DISPLAY_ZOOM_SCALE_X_MAX"),100,(function(e){t.broadcast(null,"ui-zoomX",{cause:"item",value:e})})),this._lockItem(e.zoomX,!1)),e.zoomY||(e.zoomY=this._createSingleItem(l+":zoomY",n,7,100*i("TREND_DISPLAY_ZOOM_SCALE_Y_MIN"),100*i("TREND_DISPLAY_ZOOM_SCALE_Y_MAX"),100,(function(e){t.broadcast(null,"ui-zoomY",{cause:"item",value:e})})),this._lockItem(e.zoomY,!1)),e.live||(e.live=this._createSingleItem(l+":live",s,7,0,1,a.invalid||"live"!==a.display.mode&&-1!==a.display.tEnd?0:1,(function(e){t.broadcast(null,"ui-live",{cause:"item",value:!!e})})),this._lockItem(e.live,!1)),e.handleTime||(e.handleTime=this._createSingleItem(l+":handleTime",n,7,0,1e13,parseInt((new Date).getTime()/1e3),(function(e){t.broadcast(null,"ui-handleTime",{cause:"item",value:e})})),this._lockItem(e.handleTime,!1)),e.leftTime||(e.leftTime=this._createSingleItem(l+":leftTime",n,7,0,1e13,parseInt((new Date).getTime()/1e3),(function(e){t.broadcast(null,"ui-leftTime",{cause:"item",value:e})})),this._lockItem(e.leftTime,!1)),e},_createPgmItems:function(e,t){var i=this,s=t.config,n="virtual:"+t.getName()+":";e.pgm={},s.program&&Array.isArray(s.program.items)&&s.program.items.forEach((function(t,s){var a=t.valueType.concat(t.valueIndex);e.pgm[a]=i._createSingleItem(n+a,shmi.c("TYPE_FLOAT"),7),console.debug("[TrendDisplay]","created item:",n+a)}))},_createSignalItems:function(e,t){var i=this,s=shmi.c,n=s("TYPE_BOOL"),a=s("TYPE_FLOAT"),l=t.config,o="virtual:"+t.getName()+":";return this._releaseSignalItems(e),e.curves={},!l.invalid&&l.trend&&l.trend.signals&&l.trend.signals.forEach((function(s,l){var r=s.alias||s.name,c=e.curves[r]={};c.value=i._createSingleItem(o+r+":value",a,7),c.visible=i._createSingleItem(o+r+":visible",n,7,0,1,s.visible?1:0,(function(e){t.broadcast(null,"ui-show-curve",{cause:"item",value:{curveName:r,curveIndex:l,isVisible:!!e}})}))})),l.program&&i._createPgmItems(e,t),e},_createItems:function(e,t){return this._createSignalItems(this._createGlobalItems(e,t),t)},_lockItem:function(e,t){var i=shmi.visuals.session.ItemManager,s=e.properties;t?s[4]|=16:s[4]&=-17,i.setProperties(s)},_releaseSignalItems:function(e){var t=shmi.visuals.session.ItemManager,i=e||{},s=i.curves||{};Object.keys(s).forEach((function(e){var i=s[e];t.unsubscribeItem(i.value.name,i.value.subscriptionId),t.unsubscribeItem(i.visible.name,i.visible.subscriptionId)})),i.curves=null},_releaseItems:function(e){if(e){var t=shmi.visuals.session.ItemManager;this._releaseSignalItems(e),e.zoomX&&(this._lockItem(e.zoomX,!0),t.unsubscribeItem(e.zoomX.name,e.zoomX.subscriptionId),e.zoomX=null),e.zoomY&&(this._lockItem(e.zoomY,!0),t.unsubscribeItem(e.zoomY.name,e.zoomY.subscriptionId),e.zoomY=null),e.live&&(this._lockItem(e.live,!0),t.unsubscribeItem(e.live.name,e.live.subscriptionId),e.live=null),e.handleTime&&(this._lockItem(e.handleTime,!0),t.unsubscribeItem(e.handleTime.name,e.handleTime.subscriptionId),e.handleTime=null),e.leftTime&&(this._lockItem(e.leftTime,!0),t.unsubscribeItem(e.leftTime.name,e.leftTime.subscriptionId),e.leftTime=null)}},_onBroadcast:function(e){"configuration-changed"===e.type&&(this.items=!0)},getByName:function(e,t){if(arguments.length<2)return this.items[e];var i=this.items.curves;if(i){var s=i[e];if(s)return s[t]||null}return null}},shmi.visuals.controls.TrendDisplay.AbstractRenderer=function(e,t){"use strict";var i=t.visible,s=new shmi.visuals.controls.TrendDisplay.DrawingContext(t,e),n=null,a=null,l=null,o=t.itemIndex;Object.defineProperty(this,"manager",{value:e}),Object.defineProperty(this,"signal",{value:t}),Object.defineProperty(this,"index",{get:function(){return o},set:function(e){var t=parseInt(e);!isNaN(t)&&t>=0&&(o=e)}}),Object.defineProperty(this,"visible",{get:function(){return i},set:function(e){i=!!e}}),Object.defineProperty(this,"drawingContext",{value:s}),Object.defineProperty(this,"path",{get:function(){return n||(n=this._createPathElement(this.manager.canvas)),n},set:function(){n&&(n.parentNode.removeChild(n),n=null)}}),Object.defineProperty(this,"css",{get:function(){if(!a){var e=this.path;a=e?window.getComputedStyle(e,null):{}}return a}}),Object.defineProperty(this,"style",{get:function(){return l||(l=this._getConfiguredStyle().getQualifiedByCss(this.css)),l}}),this._style=null},shmi.visuals.controls.TrendDisplay.AbstractRenderer.prototype={render:function(){"use strict";shmi.log("TrendDisplay: missing implemented curve renderer")},onDelete:function(){this.path=null},_getConfiguredStyle:function(){return this.manager.config.trend.items[this.signal.itemIndex].style},_createPathElement:function(e){}},shmi.visuals.controls.TrendDisplay.CanvasBackground=function(e,t,i){"use strict";this.labels=[],Object.defineProperty(this,"manager",{value:e}),Object.defineProperty(this,"units",{value:e.config.display.units}),Object.defineProperty(this,"drawingContext",{value:t}),Object.defineProperty(this,"curves",{value:i})},shmi.visuals.controls.TrendDisplay.CanvasBackground.prototype={render:function(e,t,i){"use strict";var s,n=i.getContext("2d"),a=e.viewport,l=e.trendDisplay.config.display,o=this.curves,r=this,c=[];n.lineWidth=.4,n.strokeStyle="rgba(0,0,0,0.5)",n.lineDashOffset=0,n.beginPath(),a.isMultiLane&&Object.keys(o).forEach((function(e,t){(s=r.curves[e].signal).visible&&(void 0===c[s.laneIndex]&&(c[s.laneIndex]=[]),c[s.laneIndex].push(s))}));var u=a.isDashboardView?c.length<l.lanesPerView?c.length:l.lanesPerView:1,h=l.labelHeight||0,m=i.height/2,d=(m-h*u)/u,f=m/(m-u*h);Object.keys(o).forEach((function(t,n){if((s=r.curves[t].signal).visible){var o=a.isMultiLane&&s?s.laneIndex:0,u=a.isSingleLane||a.isDetailView?0:h*o+d*o,v=m-u-d-l.firstLabelHeight;a.isMultiLane&&(r._generateLabels(e,i,s,c,u),a.isDashboardView&&r._generateDashboardActions(e,i,s,c,u)),(a.isSingleLane||a.isMultiLane&&(a.isDetailView||a.isDashboardView&&c[o][0]===s))&&r._generateBackgroundScaling(e,i,s,c,v,f)}})),a.isMultiLane&&r._generateDetailActions(e),n.stroke()},_generateDetailActions:function(e){var t=e.container,i=e.controls,s="detail-view-controls",n=e.trendDisplay,a=shmi.ctrl(n.getName()+"."+s);if(n.ctrls||(n.ctrls={}),n.ctrls[s]&&(a=n.ctrls[s]),!a){var l={"class-name":"detail-view-controls hidden",name:s};(a=shmi.createControl("container",t.parentNode.parentNode.parentNode,l,"div","before")).enable(),n.ctrls[s]=a,i.applyButtonCloseView(a.element,this)}},_generateDashboardActions:function(e,t,i,s,n){var a=e.container,l=i.laneIndex,o=e.controls,r=t.height/2,c="actions-lane-"+l,u=e.trendDisplay,h=shmi.ctrl(u.getName()+"."+c),m=u.config.display,d=m.labelHeight,f=s.length<m.lanesPerView?s.length:m.lanesPerView,v=(r-d*f)/f;if(u.ctrls||(u.ctrls={}),u.ctrls[c]&&(h=u.ctrls[c]),e.curves=this.curves,h)h.element.style.top=n+m.firstLabelHeight+"px",h.element.style.height=v+"px","applyButtonDetailView"!==u.changingView&&(h.element.className=h.element.className.replace(/(?:^|\s)hidden(?!\S)/g,""));else{var g={"class-name":"action",name:c};h=shmi.createControl("container",a.parentNode.parentNode.parentNode,g,"div"),u.ctrls[c]=h,h.element.style.top=n+m.firstLabelHeight+"px",h.element.style.height=v+"px",h.enable(),o.applyButtonDetailView(h.element,this,l,i)}},_generateBackgroundScaling:function(e,t,i,s,n,a){var l,o,r=e.container,c=e.viewport,u=this.drawingContext,h=t.getContext("2d"),m=e.trendDisplay.config.display,d=c.isDashboardView?(s.length<m.lanesPerView?s.length:m.lanesPerView)*a:a,f=shmi.getUiElement("styles",r.parentElement),v="rgba(0,0,0,0.5)",g="rgba(0,0,0,1)",p=.4,b=.4;if(f&&((l=shmi.getUiElement("grid-stroke",f))&&(v=getComputedStyle(l).color,p=parseFloat(getComputedStyle(l).strokeWidth)),(l=shmi.getUiElement("grid-stroke-hl",f))&&(g=getComputedStyle(l).color,b=parseFloat(getComputedStyle(l).strokeWidth))),c.isMultiLane){if(i.scaleVisible&&i.visible)if(h.setLineDash([0,0]),h.lineWidth=p,c.isDashboardView)[0,20/d,40/d,60/d,80/d,100/d].forEach((function(e){var i=u.value2Y(u.maxValue*e/100)-n;0===e||e===100/d?(h.strokeStyle=g,h.lineWidth=b):(h.strokeStyle=v,h.lineWidth=p),h.beginPath(),h.moveTo(0,i),h.lineTo(t.width,i),h.stroke()}));else for(var y=0;y<=100;y+=5){o=y/d;var E=u.value2Y(u.maxValue*o/100)-n-13;0===o||o===50/d||o===100/d?(h.strokeStyle=g,h.lineWidth=b):(h.strokeStyle=v,h.lineWidth=p),h.beginPath(),h.moveTo(0,E),h.lineTo(t.width,E),h.stroke()}}else{var C=u.minValue,T=u.maxValue,x=t.width,w=t.height;h.lineWidth=p,h.strokeStyle=v,h.lineDashOffset=0,h.beginPath(),[0,10,20,30,40,50,60,70,80,90,100].forEach((function(e){var t=u.value2Y(C+(T-C)*e/100);h.moveTo(0,t),h.lineTo(x,t)})),shmi.visuals.controls.TrendDisplay.CanvasBackground.getVerticalRasterTimestamps(this.units,c).forEach((function(e){var t=u.time2X(e,0);h.moveTo(t,0),h.lineTo(t,w)})),h.stroke()}var I=shmi.visuals.controls.TrendDisplay.CanvasBackground.getVerticalRasterTimestamps(this.units,c);m.hasVerticalScaling&&(h.lineWidth=.4,h.strokeStyle="rgba(162, 174, 177, 1)",h.beginPath(),I.forEach((function(e){var i=u.time2X(e,0);h.moveTo(i,0),h.lineTo(i,t.height)})),h.stroke()),h.lineWidth=2,h.strokeStyle="rgba(240, 241, 242, 1)",h.beginPath(),I.forEach((function(t){var i=u.time2X(t,0),s=new Date(1e3*t),n=e.trendDisplay,a=!!n.config["utc-time"]&&n.config["utc-time"],l=new Date(a?s.valueOf()+6e4*s.getTimezoneOffset():s);0===l.getHours()&&0===l.getMinutes()&&0===l.getSeconds()&&(h.moveTo(i,0),h.lineTo(i,u.value2Y(0)))})),h.stroke()},_generateLabels:function(e,t,i,s,n){var a=e.container,l=e.viewport,o=e.controls,r=a.ownerDocument,c=i.laneIndex,u=e.trendDisplay,h=u.config.display,m=l.isDashboardView?s.length<h.lanesPerView?s.length:h.lanesPerView:1,d=a.parentNode.parentNode.querySelector(".lane.index-"+c),f=shmi.ctrl(u.getName()+".select-box-multi-lane-"+c),v=h.labelHeight*m,g=(t.height/2-v)/m,p=(l.isDashboardView,g);if((void 0===u.detailView||null===u.detailView||u.detailView===c)&&i.scaleVisible&&i.visible)if(d){d.style.top=n+"px",d.getElementsByClassName("unit")[0].style.top=p+"px",d.getElementsByClassName("vMin")[0].style.top=Math.ceil(p)+"px";var b=d.getElementsByClassName("vMax")[0].className,y=d.getElementsByClassName("vMin")[0].className;l.isDashboardView&&"applyButtonDetailView"!==u.changingView?(d.getElementsByClassName("vMax")[0].className=b.replace(/(?:^|\s)hidden(?!\S)/g,""),d.getElementsByClassName("vMin")[0].className=y.replace(/(?:^|\s)hidden(?!\S)/g,""),h.demo&&f&&(f.element.className=f.element.className.replace(/(?:^|\s)hidden(?!\S)/g,""))):l.isDetailView&&"applyButtonCloseView"!==u.changingView&&(h.demo?f&&!f.element.className.match(/(?:^|\s)hidden(?!\S)/g)&&(f.element.className+=" hidden"):(b.match(/(?:^|\s)hidden(?!\S)/g)||(d.getElementsByClassName("vMax")[0].className+=" hidden",d.getElementsByClassName("vMin")[0].className+=" hidden"),this._generateSignalScalingValues(e,t,i)),d.className=d.className.replace(/(?:^|\s)hidden(?!\S)/g,""))}else{var E,C,T,x,w,I,k,S,L,D,_=i;k=String(_.label),S=String(_.unit),L=String(_.max),D=String(_.min),(E=r.createElement("div")).className="label",E.appendChild(r.createTextNode(shmi.localize(k))),(C=r.createElement("div")).className="unit",C.style.top=p+"px",C.appendChild(r.createTextNode(shmi.localize(S))),(I=r.createElement("div")).className="lane index-"+c,I.style.top=n+"px",I.appendChild(E),!f&&(l.isDashboardView||l.isDetailView)&&s[c].length>1?o.applySelectBoxLane(E,this,i,s):f&&(l.isDashboardView||h.demo&&l.isDetailView)&&(f.element.className=f.element.className.replace(/(?:^|\s)hidden(?!\S)/g,"")),(T=r.createElement("div")).className="values",(w=r.createElement("div")).className="vMax",w.appendChild(r.createTextNode(L)),T.appendChild(w),(x=r.createElement("div")).className="vMin",x.style.top=Math.ceil(p)+"px",x.appendChild(r.createTextNode(D)),T.appendChild(x),I.appendChild(T),I.appendChild(C),a.parentNode.parentNode.appendChild(I),l.isDetailView&&!h.demo&&"applyButtonCloseView"!==u.changingView&&this._generateSignalScalingValues(e,t,i)}},_generateSignalScalingValues:function(e,t,i){var s,n=e.container,a=e.viewport,l=n.ownerDocument,o=e.getCanvasSize(),r=this.units,c=this.curves[i.valueIndex].drawingContext,u=e.trendDisplay.config.display.labelHeight,h=n.parentNode.parentNode.querySelector(".scaling-values"),m=0,d=0,f=i.max-i.min,v=Math.pow(10,Math.ceil(Math.log(f)/Math.LN10)),g={},p=null;if(h?s=h:(s=l.createElement("div")).className="scaling-values",s.childElementCount){for(;s.firstChild;)s.removeChild(s.firstChild);this.labels=[]}var b=f/(c.visibleHeightInPixel-u);shmi.visuals.controls.TrendDisplay.Scale.forEachStep(c,o,r,r.scale.max,(function(e,t,s,n){e=Math.round(e*v)/v;var l=i.alias||i.name,r=t>=1,u=t<=0;e!==p&&t>=-.05&&t<=1.05&&(g[e]=[c.value2Y(e,1,a.zoomY,b)-o.y,l+(u?" lower value":r?" upper value":" value")],p=e),r&&-1===g[e][1].indexOf("upper")&&(g[e][1]=l+" upper value"),u&&-1===g[e][1].indexOf("lower")&&(g[e][1]=l+" lower value")}));var y=[];this.labels=this.labels.map((function(e){var t=e.value;return shmi.objectHasOwnProperty(g,t)?(e.elem.style.top=String(g[t][0])+"px",g[t]=void 0,e):(y.push(e),null)})).filter((function(e){return e})).concat(Object.keys(g).sort().map((function(e){var t,i=g[e];return i?(y.length?((t=y.shift()).elem.firstChild.nodeValue=String(e),t.value=e):((t={value:e,elem:l.createElement("span")}).elem.appendChild(l.createTextNode(String(e))),t.elem.style.left=String(m)+"px",t.elem.style.width=String(d)+"px",s.appendChild(t.elem)),t.elem.className=i[1],t.elem.style.top=String(i[0])+"px",t):null})).filter((function(e){return e}))),y.forEach((function(e){e.elem.parentNode.removeChild(e.elem)})),h||n.parentNode.parentNode.appendChild(s)},_highlightTrendCurve:function(e,t){var i,s=e.container,n=e.viewport,a=e.trendDisplay,l=t.valueIndex,o=t.laneIndex,r=a.config,c=s.parentNode.parentNode.querySelector(".lane.index-"+o),u=localStorage.itemStyles?JSON.parse(localStorage.itemStyles):[];r.trend.items.forEach((function(e,t){var s=r.styleManagers.inactiveStyle.color;e.laneIndex===o&&l!==t?(i=r.styles[e.styleIndex],u.length&&void 0!==u[e.signalIndex]&&(u[e.signalIndex]=i.color),r.styles[e.styleIndex]=i,u[e.signalIndex]=i.color):e.laneIndex===o&&l===t&&((i=r.styles[e.styleIndex]).color===s&&(i.color=u[e.signalIndex]),r.styles[e.styleIndex]=i,u[e.signalIndex]=null),localStorage.setItem("itemStyles",JSON.stringify(u))})),c&&(c.getElementsByClassName("label")[0].textContent=shmi.localize(t.label),c.getElementsByClassName("unit")[0].textContent=shmi.localize(t.unit),c.getElementsByClassName("vMin")[0].textContent=String(t.min),c.getElementsByClassName("vMax")[0].textContent=String(t.max)),a.config.update(r).then((function(){var e=a.getComponents("trend-display-continuous")[0].viewport;e=a.controls[0].viewport,a.items.items.live.writeValue(0),n.zoomX!==e.zoomX&&a.items.items.zoomX.writeValue(100*e.zoomX),n.zoomY!==e.zoomY&&a.items.items.zoomY.writeValue(100*e.zoomY),setTimeout((function(){n.leftTime!==e.leftTime&&a.items.items.leftTime.writeValue(e.leftTime),n.handleTime!==e.handleTime&&a.items.items.handleTime.writeValue(e.handleTime)}),250)}))},_updateTrendDisplay:function(e,t,i){var s=e.container,n=e.viewport,a=e.trendDisplay,l=t?t.valueIndex:null,o=i||"dashboard",r=shmi.cloneObject(a.config),c=r.display;r.display.view=o,"detail"===o?(n.isDetailView=!0,shmi.removeClass(a.element,"swim-lane")):(n.isDashboardView=!0,shmi.addClass(a.element,"swim-lane"));var u=s.parentNode.querySelectorAll(".lane");u&&shmi.requires("visuals.tools.iterate.iterateNodeList")(u,(function(e,t){e.remove()}));null!==l?r.trend.items.forEach((function(e,i){i===l?(e.scaleVisible=!0,e.visible=!0):c.demo||t.laneIndex!==e.laneIndex?(e.scaleVisible=!1,e.visible=!1):(e.scaleVisible=!1,e.visible=!0)})):r.trend.items.forEach((function(e,t){e.scaleVisible=!0,e.visible=!0})),r.viewport=n,a.config.update(r).then((function(){}))}},shmi.visuals.controls.TrendDisplay.derive(shmi.visuals.controls.TrendDisplay.CanvasBackground,shmi.visuals.controls.TrendDisplay.AbstractRenderer,"CanvasBackground"),shmi.visuals.controls.TrendDisplay.CanvasBackground.getVerticalRasterTimestamps=function(e,t){var i,s,n=t.minTime,a=t.visibleTimeSpan,l=(1+2*t.prefetch)*a,o=e.background,r=shmi.visuals.controls.TrendDisplay.Timeline.detectVisibleUnit(e.timeLine.available,a,o.timeLineMin,o.timeLineMax),c=shmi.visuals.controls.TrendDisplay.Timeline.detectVisibleUnit(e.timeLine.available,a,e.timeLine.min,e.timeLine.max),u=[];if(r>0)for(s=(i=Math.floor((t.leftRenderTime-n)/r)*r)+l;i<s;i+=r)u.push(n+i);if(c>0)for(s=(i=Math.floor((t.leftRenderTime-n)/c)*c)+l;i<s;i+=c)u.push(n+i);return u=u.sort().filter((function(e,t,i){return!t||e!==i[t-1]}))},shmi.visuals.controls.TrendDisplay.CanvasBackground.getTimestamps=function(){return[1474439364.872986,1474954461.981989,1474957469.004987,1475080519.644011,1475138756.23,1475128448.034015,1475129446.76,1475135071.640012,1475153465.722981,1476695351]},shmi.visuals.controls.TrendDisplay.onConfiguration.push([-10,function _onConfigureBackground(e,t,i){"use strict";if(e){var s,n,a,l=e.display.units;s=l.background=i.isObject(l.background),n=parseInt(s.timeLineMin),(isNaN(n)||n<1)&&(n=2),a=parseInt(s.timeLineMax),(isNaN(a)||a<1)&&(a=e.display.hasVerticalScaling?16:1440),s.timeLineMin=Math.min(n,a),s.timeLineMax=Math.max(n,a),n=parseInt(s.scaleMin),(isNaN(n)||n<1)&&(n=2),a=parseInt(s.scaleMax),(isNaN(a)||a<1)&&(a=16),s.scaleMin=Math.min(n,a),s.scaleMax=Math.max(n,a)}}]),shmi.visuals.controls.TrendDisplay.CanvasCurve=function CanvasCurve(e,t){"use strict";shmi.visuals.controls.TrendDisplay.CanvasCurve._super.call(this,e,t)},shmi.visuals.controls.TrendDisplay.CanvasCurve.prototype={_createPathElement:function(e){var t="path signal "+(this.signal.alias||this.signal.name),i=e.getElementsByClassName(t)[0];return i||((i=e.ownerDocument.createElement("path")).setAttribute("class",t),i=e.appendChild(i)),i},render:function(e,t,i){"use strict";if(this.signal&&(!this.visible||!t||!t.values))return null;var s,n=e.viewport,a=i.getContext("2d"),l=this.drawingContext,o=n.leftRenderTime,r=n.rightRenderTime,c=this.signal,u=c.valueIndex,h=n.isMultiLane?c.laneIndex:0,m=this.style.symbol,d=e.config.trend.signals.length,f=i.height/2,v=e.trendDisplay.config.display,g=v.labelHeight,p=0,b=n.isSingleLane?0:v.firstLabelHeight+30,y=f/(f-g),E=[],C=[],T=[],x=NaN,w=NaN,I=!0;if(m&&(C=shmi.visuals.controls.TrendDisplay.CanvasBackground.getVerticalRasterTimestamps(e.config.display.units,n)),this.style.applyOnCanvas(a),a.beginPath(),t.values.length&&(s=t.values[0][0]),n.isMultiLane&&n.isDashboardView){var k,S=e.curves;S&&S.forEach((function(e,t){c=e.signal,void 0===T[c.laneIndex]&&(T[c.laneIndex]=[]),T[c.laneIndex].push(c)})),d=T.length<v.lanesPerView?T.length:v.lanesPerView,y=d*(f/(f-d*g)),k=f/2-(p=(f-g*d)/d)/2+v.firstLabelHeight,b=g*h+p*h+k}return t.values.forEach((function(e,t){var i,c,h,d,f,v,g=e[0],p=e[1][u],T=b;if(!t){for(f=0,v=C.length;f<v&&!(C[f]>=g);f++);f>0&&C.splice(0,f-1)}if((g<r?g:r)>(v=s>o?s:o)){if(i=l.time2X(g,0),isFinite(p))if(c=h=l.value2Y(p,0),n.isMultiLane&&n.isDashboardView&&(c=c/y+b,h=h/y+b),I&&isFinite(x)&&(I=!1),I|=e[2])a.moveTo(i,c);else{if(isFinite(x)){var k=l.time2X(s,0),S=l.value2Y(x,0);n.isMultiLane&&n.isDashboardView&&(S=S/y+b),a.moveTo(k,S)}a.lineTo(i,c)}else if(p&&shmi.objectHasOwnProperty(p,"min")&&shmi.objectHasOwnProperty(p,"max")){I=!0;var L=parseFloat(p.min),D=parseFloat(p.max);if(isNaN(L)||isNaN(D))return;(c=l.value2Y(L,0))===(h=l.value2Y(D,0))&&(h=c+1),n.isMultiLane&&n.isDashboardView&&(c=c/y+b,h=h/y+b),a.moveTo(i,c),a.lineTo(i,h)}m&&C.length&&g>=C[0]&&(s<=C[0]?isFinite(p)&&isFinite(w)?I?(d=C.shift(),(!C.length||g-d<C[0]-g)&&E.push({x:i,y:c})):(i=C.shift(),d=(d=g-s)?(i-s)/(d/2):1,c=l.value2Y(w),n.isMultiLane&&n.isDashboardView&&(c=c/y+b),E.push({x:l.time2X(i,T),y:Math.round((h*d+c*(2-d))/2)})):(C.shift(),E.push({x:i,y:Math.round((c+h)/2)})):C.shift()),isFinite(p)&&(I=!1),x=NaN}else x=p;g>r||(w=isFinite(p)?Number(p):NaN,s=g)})),a.stroke(),E.length?m.then((function(e){E.forEach((function(t){a.drawImage(e,t.x-shmi.visuals.controls.TrendDisplay.iconDimensions.width/2,t.y-shmi.visuals.controls.TrendDisplay.iconDimensions.height/2)}))})):null}},shmi.visuals.controls.TrendDisplay.derive(shmi.visuals.controls.TrendDisplay.CanvasCurve,shmi.visuals.controls.TrendDisplay.AbstractRenderer,"CanvasCurve"),shmi.visuals.controls.TrendDisplay.CanvasRuler=function CanvasRuler(e,t,i){"use strict";shmi.visuals.controls.TrendDisplay.CanvasRuler._super.call(this,e,{min:i.min,max:i.max,curve:{}}),Object.defineProperty(this,"curves",{value:t}),Object.defineProperty(this,"units",{value:e.config.display.units})},shmi.visuals.controls.TrendDisplay.CanvasRuler.prototype={_createPathElement:function(e){var t=e.getElementsByClassName("path ruler")[0];return t||((t=e.ownerDocument.createElement("path")).setAttribute("class","path ruler"),t=e.appendChild(t)),t},_getConfiguredStyle:function(){return shmi.visuals.controls.TrendDisplay.Style.defaultStyle},render:function(e,t,i){"use strict";if(t){var s=shmi.visuals.controls.TrendDisplay,n=this.drawingContext,a=e.getCanvasSize(),l=i.getContext("2d"),o=t.dimensions.ruler,r=this.units,c=r.ruler.majorStepWidths;this.style.applyOnCanvas(l),l.beginPath(),s.Scale.forEachStep(n,a,r,r.ruler.max,(function(e,t,i,s){var r=n.value2Y(e);l.moveTo(o.x+o.width-o.width*c[s],r),l.lineTo(a.totalWidth,r)})),l.stroke()}}},shmi.visuals.controls.TrendDisplay.derive(shmi.visuals.controls.TrendDisplay.CanvasRuler,shmi.visuals.controls.TrendDisplay.CanvasCurve,"CanvasRuler"),shmi.visuals.controls.TrendDisplay.onConfiguration.push([-10,function _onConfigureRuler(e,t,i){"use strict";var s,n,a,l,o;e&&(a=(n=(s=e.display=i.isObject(e.display)).units=i.isObject(s.units)).ruler=i.isObject(n.ruler),Array.isArray(a.majorStepWidths)||(a.majorStepWidths=[1,1,.7,.5,.3,.2,.1,.05]),a.majorStepWidths=i.parseFilterAndSort(a.majorStepWidths,i.relative,!0),l=parseInt(a.min),(isNaN(l)||l<1)&&(l=1),o=parseInt(a.max),(isNaN(o)||o<1)&&(o=10),a.min=Math.min(l,o),a.max=Math.max(l,o))}]),shmi.visuals.controls.TrendDisplay.CanvasScale=function CanvasScale(e,t){"use strict";shmi.visuals.controls.TrendDisplay.CanvasScale._super.call(this,e,t),this.labels=[],Object.defineProperty(this,"units",{value:e.config.display.units})},shmi.visuals.controls.TrendDisplay.CanvasScale.prototype={render:function(e,t,i){"use strict";if(t){var s=this.signal,n=this.drawingContext,a=e.getCanvasSize(),l=t.dimensions.signals[this.index]||{x:0,width:0},o=Math.ceil(Math.log(s.max-s.min)/Math.LN10),r=null,c=this.manager.container,u=c.ownerDocument,h=this.units,m={};o=Math.pow(10,o),shmi.visuals.controls.TrendDisplay.Scale.forEachStep(n,a,h,h.scale.max,(function(e,t,i,a){e=Math.round(e*o)/o;var l=s.alias||s.name,c=t>=1,u=t<=0;e!==r&&t>=-.05&&t<=1.05&&(m[e]=[n.value2Y(e),l+(u?" lower value":c?" upper value":" value")],r=e),c&&-1===m[e][1].indexOf("upper")&&(m[e][1]=l+" upper value"),u&&-1===m[e][1].indexOf("lower")&&(m[e][1]=l+" lower value")}));var d=[];this.labels=this.labels.map((function(e){var t=e.value;return shmi.objectHasOwnProperty(m,t)?(e.elem.style.top=String(m[t][0])+"px",m[t]=void 0,e):(d.push(e),null)})).filter((function(e){return e})).concat(Object.keys(m).sort().map((function(e){var t,i=m[e];return i?(d.length?((t=d.shift()).elem.firstChild.nodeValue=String(e),t.value=e):((t={value:e,elem:u.createElement("span")}).elem.appendChild(u.createTextNode(String(e))),t.elem.style.left=String(l.x)+"px",t.elem.style.width=String(l.width)+"px",c.appendChild(t.elem)),t.elem.className=i[1],t.elem.style.top=String(i[0])+"px",t):null})).filter((function(e){return e}))),d.forEach((function(e){e.elem.parentNode.removeChild(e.elem)}))}},onDelete:function(){this.labels&&(this.labels.forEach((function(e){e.elem.parentNode.removeChild(e.elem)})),this.labels=[]),this._super(this.CanvasScale,"onDelete")}},shmi.visuals.controls.TrendDisplay.derive(shmi.visuals.controls.TrendDisplay.CanvasScale,shmi.visuals.controls.TrendDisplay.CanvasCurve,"CanvasScale"),shmi.visuals.controls.TrendDisplay.SvgCurve=function SvgCurve(e,t){"use strict";shmi.visuals.controls.TrendDisplay.SvgCurve._super.call(this,e,t)},shmi.visuals.controls.TrendDisplay.SvgCurve.prototype={render:function(e,t){"use strict";if(this.visible&&t&&t.values){var i=this.signal,s=this.drawingContext,n=e.viewport,a=n.leftRenderTime,l=n.rightRenderTime,o=!0,r=i.valueIndex,c=t.values;this.style.applyOnSvg(this.path),this.path.setAttribute("d",c.map((function(e){var t=e[0],i=e[1][r];if(t>=a&&t<=l){if(isFinite(i))return o?(o=!1,"M"+s.time2X(t)+" "+s.value2Y(i)):"L"+s.time2X(t)+" "+s.value2Y(i);if(i&&shmi.objectHasOwnProperty(i,"min")&&shmi.objectHasOwnProperty(i,"max")){o=!0;var n,c=parseFloat(i.min),u=parseFloat(i.max);return isNaN(c)||isNaN(u)?null:(n=s.time2X(t,0),(c=s.value2Y(c,0))===(u=s.value2Y(u,0))&&(u=c+1),"M"+n+" "+c+"L"+n+" "+u)}return null}return null})).join(""))}else this.path.setAttribute("d","")},_createPathElement:function(e){var t=e.getElementsByClassName(this.signal.alias||this.signal.name)[0];return t||((t=e.ownerDocument.createElementNS("http://www.w3.org/2000/svg","path")).setAttribute("class",this.signal.alias||this.signal.name),t=e.appendChild(t)),t}},shmi.visuals.controls.TrendDisplay.derive(shmi.visuals.controls.TrendDisplay.SvgCurve,shmi.visuals.controls.TrendDisplay.AbstractRenderer,"SvgCurve"),shmi.visuals.controls.TrendDisplay.AbstractRenderingManager=function(e,t,i,s,n){"use strict";var a=new shmi.visuals.controls.TrendDisplay.Messaging,l=new shmi.visuals.controls.TrendDisplay.Messaging(!0),o=new shmi.visuals.controls.TrendDisplay.Controls(this,i,[]);Object.defineProperty(this,"container",{value:e||t}),Object.defineProperty(this,"canvas",{value:t}),Object.defineProperty(this,"viewport",{value:i}),Object.defineProperty(this,"elementClass",{value:s}),Object.defineProperty(this,"onRender",{value:a}),Object.defineProperty(this,"onResize",{value:l}),Object.defineProperty(this,"config",{value:n}),Object.defineProperty(this,"controls",{value:o}),this._data=null,this._offsetX=0,this._offsetY=0,this._width=100,this._height=100},shmi.visuals.controls.TrendDisplay.AbstractRenderingManager.prototype={getData:function(){"use strict";return this._data},getCanvasSize:function(){"use strict";return{x:this._offsetX,y:this._offsetY,width:this._width,height:this._height,totalWidth:this._fullWidth,totalHeight:this._fullHeight}},update:function(e,t){"use strict";return e&&(this._data=e),t?shmi.visuals.controls.TrendDisplay.Promise.resolve(!1):this.resetLocation().onRender.send(this,this.getData())},resize:function(e,t,i,s){"use strict";if(e=parseInt(e),t=parseInt(t),e&&t&&(e!==this._width||t!==this._height)){shmi.log("resizing canvas to "+e+" x "+t,0);var n=this,a=this._offsetX=Math.ceil(e*(i||0)),l=this._offsetY=Math.ceil(t*(s||i||0));return this._width=e,this._height=t,this._fullWidth=e+2*a,this._fullHeight=t+2*l,this.canvas.setAttribute("width",this._fullWidth),this.canvas.setAttribute("height",this._fullHeight),this.resetLocation(),this.onResize.send(this,e,t).then((function(){return n.update()}))}return null},resetLocation:function(){"use strict";return this.container.style.left=String(-this._offsetX)+"px",this.container.style.top=String(-this._offsetY)+"px",this},onSlide:function(e,t){"use strict";this.container.style.left=String(-this._offsetX+t)+"px"},onShift:function(e,t){"use strict";this.container.style.top=String(-this._offsetY+t)+"px"},onDelete:function(){this.onRender.reset(),this.onResize.reset()}},shmi.visuals.controls.TrendDisplay.CanvasRenderingManager=function CanvasRenderingManager(e,t,i,s,n,a){"use strict";var l;shmi.visuals.controls.TrendDisplay.CanvasRenderingManager._super.call(this,e,t,i,s,n,a),Object.defineProperty(this,"trendDisplay",{value:a,writable:!1}),Object.defineProperty(this,"offscreen",{get:function(){return l||(l=document.createElement("canvas")),l},set:function(e){e||(l=void 0)}}),this._enableImplicitRenderingSteps()},shmi.visuals.controls.TrendDisplay.CanvasRenderingManager.prototype={update:function(e,t){"use strict";return e&&(this._data=e),t?shmi.visuals.controls.TrendDisplay.Promise.resolve(!1):this.onRender.send(this,this.getData(),this.offscreen)},_enableImplicitRenderingSteps:function(){var e=this,t=this.canvas,i=this.offscreen;this.onRender.addListener(1e3,(function _initialRenderingStep(){i.width=t.width,i.height=t.height,i.getContext("2d").clearRect(0,0,i.width,i.height)})),this.onRender.addListener(-1e3,(function _finalRenderingStep(){var s=t.getContext("2d");s.clearRect(0,0,t.width,t.height),e.resetLocation(),s.drawImage(i,0,0)}))},onDelete:function(){this.offscreen=null}},shmi.visuals.controls.TrendDisplay.derive(shmi.visuals.controls.TrendDisplay.CanvasRenderingManager,shmi.visuals.controls.TrendDisplay.AbstractRenderingManager,"CanvasRenderingManager"),shmi.visuals.controls.TrendDisplay.SvgRenderingManager=function SvgRenderingManager(e,t,i,s,n){"use strict";shmi.visuals.controls.TrendDisplay.SvgRenderingManager._super.call(this,e,t,i,s,n)},shmi.visuals.controls.TrendDisplay.SvgRenderingManager.prototype={resize:function(e,t,i){"use strict";if(e=parseInt(e),t=parseInt(t),e&&t&&(e!==this._width||t!==this._height)){var s=this._offsetX=Math.ceil(e*(i||0));this.canvas.style.left=String(-s)+"px",this.canvas.setAttribute("width",e+2*s),this.canvas.setAttribute("height",t),this.canvas.setAttribute("viewBox",s+" 0 "+e+" "+t),this._width=e,this._height=t}}},shmi.visuals.controls.TrendDisplay.derive(shmi.visuals.controls.TrendDisplay.SvgRenderingManager,shmi.visuals.controls.TrendDisplay.AbstractRenderingManager,"SvgRenderingManager"),shmi.visuals.controls.TrendDisplay.DrawingContext=function(e,t){var i,s,n,a,l,o,r,c=shmi.visuals.controls.TrendDisplay,u=t.viewport,h=t.getCanvasSize(),m=e.min,d=e.max,f=d-m;function _updateViewport(){i=u.zoomY,s=u.leftTime,n=m+f*u.zoomFocusY,a=u.visibleTimeSpan/h.width,o=f/l}function _updateCanvasSize(){h=t.getCanvasSize(),l=h.height,r=h.y+l/2,_updateViewport.call(this)}function round(e,t){var i=Math.pow(10,t||0);return Math.round(e*i)/i}m===d&&shmi.log("[TrendDisplay.DrawingContext] Min/Max values not set or equal for signal "+(e.alias||e.name),3),t.onResize.addListener(_updateCanvasSize,this),u.onUpdate.addListener(100,_updateViewport,this),Object.defineProperty(this,"visibleHeightInPixel",{get:function(){return l}}),Object.defineProperty(this,"minValue",{value:e.min}),this.manager=t,Object.defineProperty(this,"maxValue",{value:e.max}),this.time2X=function(e,t){return round((e-s)/a+h.x,t>=0?t:0)},this.x2Time=function(e){return(e-h.x)*a+s},this.value2Y=function(e,t,s,a){return round(r-((e||0)-n)*(s||i)/(a||o),t||0)},this.y2Value=function(e,t){return n-(e-r)*o/(t||i)},this.relative2Y=function(e,t,i){return this.value2Y(e*f+m,t,i)},this.relative2Value=function(e){return e*f+m},this.y2Relative=function(e,t){return(this.y2Value(e,t)-m)/f},this.minFocus=function(e){return(this.y2Value(this.value2Y(m,0,e)-l/2,e)-m)/f},this.maxFocus=function(e){return(this.y2Value(this.value2Y(d,0,e)+l/2,e)-m)/f},this.y2Focus=function(e){return(this.y2Value(e)-m)/f},this.focus2Y=function(e){return this.value2Y(e*f+m)},this.deriveFocusY=function(e,t){var i;return i=m+u.zoomFocusY*f+(1/u.zoomY-1/e)*f/l*t,c.limit((i-m)/f,this.minFocus(e),this.maxFocus(e))},_updateCanvasSize.call(this)},shmi.visuals.controls.TrendDisplay.Viewport=function Viewport(e){"use strict";var t,i,s,n=null,a=null,l=e.maxTime,o="live"===e.mode,r=o?0:l,c=!0,u=new shmi.visuals.controls.TrendDisplay.Messaging,h=this,m=null,d=e.type&&("singlelane"===e.type.toLowerCase()||"single"===e.type.toLowerCase()),f=e.type&&("multilane"===e.type.toLowerCase()||"multi"===e.type.toLowerCase()),v=""===e.view||e.view&&"detail"===e.view.toLowerCase(),g=""!==e.view&&(e.view&&"dashboard"===e.view.toLowerCase());switch(e.mode){case"now":case"live":t=limitStart((i=l)-e.visible);break;default:t=e.minTime,i=l}function limitStart(t){var i=e.minTime;return t<i?i:t}function limitEnd(e,t){var i=t?h.maxLeftTime:l;return e>i?i:e}function slideTo(e,s){e!==t&&(s.push("leftTime"),setHandleTime(e+(h.handleTime-t))&&s.push("handleTime"),i=e+(i-t),t=e),s.length>0&&_onUpdated(s)}function setHandleTime(e){var t=Number(e);if(t>0&&(t=limitStart(limitEnd(t)))!==r){if(t>=l&&o){if(0===r)return!1;t=0}return r=t,!0}return!1}function _onUpdated(e){e.length>0&&(c=!1,m?m.queue=m.queue.concat(e):u.send(h,e))}s={x:1,y:1,focusY:.5},Object.defineProperty(this,"isSingleLane",{get:function(){return d},set:function(e){var t=!!e;t!==d&&(d=t,f=!t)}}),Object.defineProperty(this,"isMultiLane",{get:function(){return f},set:function(e){var t=!!e;t!==f&&(f=t,d=!t)}}),Object.defineProperty(this,"isDetailView",{get:function(){return v},set:function(e){var t=!!e;t!==v&&(v=t,g=!t)}}),Object.defineProperty(this,"isDashboardView",{get:function(){return g},set:function(e){var t=!!e;t!==g&&(g=t,v=!t)}}),Object.defineProperty(this,"pristine",{get:function(){return c},set:function(){c=!0}}),Object.defineProperty(this,"onUpdate",{value:u}),Object.defineProperty(this,"minTime",{value:e.minTime}),Object.defineProperty(this,"maxTime",{get:function(){return l}}),Object.defineProperty(this,"prefetch",{value:e.prefetch}),Object.defineProperty(this,"isLive",{get:function(){return o},set:function(e){var t=!!e;t!==o&&(o=t,_onUpdated(["isLive"]))}}),Object.defineProperty(this,"minSampleTime",{get:function(){return n||this.minTime},set:function(e){e=Number(e),!isNaN(e)&&e>0&&e<n&&(n=e)}}),Object.defineProperty(this,"maxSampleTime",{get:function(){return a},set:function(e){var t=Number(e);t>0&&(t>a&&(a=t),t>l&&(l=t,o?slideTo(this.maxLeftTime,["maxTime"]):_onUpdated(["maxTime"])))}}),Object.defineProperty(this,"programEndTime",{set:function(e){var t=Number(e);t>0&&(t<a&&(t=a),t!==l&&(l=t,_onUpdated(["maxTime"])))},get:function(){return null}}),Object.defineProperty(this,"zoomX",{get:function(){return s.x},set:function(n){var a=parseFloat(n);if(!isNaN(a)&&a>0){var o=e.minTime,r=l,c=r-o,u=Math.min(c,e.visible/a);if((a=e.visible/u)!==s.x){s.x=a;var h=this.handleTime,m=["zoomX","handleTime"],d=h-u/2,f=h+u/2;d<o?f=(d=o)+u:f>r&&(d=(f=r)-u),t===d&&i===f||(t=d,i=f,m.push("leftTime")),_onUpdated(m)}}}}),Object.defineProperty(this,"minZoomX",{get:function(){var t=e.visible/(l-e.minTime),i=shmi.c("TREND_DISPLAY_ZOOM_SCALE_X_MIN");return t>i?t:i}}),Object.defineProperty(this,"maxZoomX",{value:shmi.c("TREND_DISPLAY_ZOOM_SCALE_X_MAX")}),Object.defineProperty(this,"zoomY",{get:function(){return s.y},set:function(e){var t=Number(e);t<this.minZoomY&&(t=this.minZoomY),t>this.maxZoomY&&(t=this.maxZoomY),t!==s.y&&(s.y=t,_onUpdated(["zoomY"]))}}),Object.defineProperty(this,"minZoomY",{value:shmi.c("TREND_DISPLAY_ZOOM_SCALE_Y_MIN")}),Object.defineProperty(this,"maxZoomY",{value:shmi.c("TREND_DISPLAY_ZOOM_SCALE_Y_MAX")}),Object.defineProperty(this,"zoomFocusY",{get:function(){return s.focusY},set:function(e){var t=Number(e);t<0&&(t=0),t>1&&(t=1),t!==s.focusY&&(s.focusY=t,_onUpdated(["zoomFocusY"]))}}),Object.defineProperty(this,"handleTime",{get:function(){return r||l},set:function(e){setHandleTime(e)&&_onUpdated(["handleTime"])}}),Object.defineProperty(this,"leftTime",{get:function(){return t},set:function(e){var t=Number(e);t>0&&slideTo(limitStart(limitEnd(t,!0)),[])}}),Object.defineProperty(this,"minLeftTime",{value:e.minTime}),Object.defineProperty(this,"maxLeftTime",{get:function(){return limitStart(l-(i-t))}}),Object.defineProperty(this,"rightTime",{get:function(){return i},set:function(e){isNaN(e)||(this.leftTime=Number(e)-(i-t))}}),Object.defineProperty(this,"visibleTimeSpan",{get:function(){return i-t}}),Object.defineProperty(this,"now",{get:function(){return shmi.getServerTime()}}),Object.defineProperty(this,"leftRenderTime",{get:function(){return limitStart(t-e.prefetch*(i-t))}}),Object.defineProperty(this,"rightRenderTime",{get:function(){return limitEnd(i+e.prefetch*(i-t))}}),Object.defineProperty(this,"transaction",{get:function(){return!!m},set:function(e){if(e)m?m.locks++:m={locks:1,queue:[],watchdog:setTimeout((function(){shmi.log("viewport transaction locked for more than 2s",2)}),2e3)};else if(m&&!--m.locks){var t=m.queue;clearTimeout(m.watchdog),m=null,t.length>0&&u.send(this,t)}}}),Object.defineProperty(this,"transactionQueue",{get:function(){return m?m.queue:[]},set:function(e){e&&m&&Array.isArray(e)&&(m.queue=m.queue.filter((function(t){return e.indexOf(t)>=0}))),!e&&m&&(m.queue=[])}})},shmi.visuals.controls.TrendDisplay.Viewport.prototype={deriveLeftMaxShiftPixels:function(e){"use strict";return Math.round((this.leftTime-this.minLeftTime)/this.visibleTimeSpan*e)},deriveRightMaxShiftPixels:function(e){"use strict";return Math.round((this.maxLeftTime-this.leftTime)/this.visibleTimeSpan*e)},deriveLeftPrefetchPixels:function(e){"use strict";return Math.round((this.leftTime-this.leftRenderTime)/this.visibleTimeSpan*e)},deriveRightPrefetchPixels:function(e){"use strict";return Math.round((this.rightRenderTime-this.rightTime)/this.visibleTimeSpan*e)},onDelete:function(){this.onUpdate.reset()}},shmi.visuals.controls.TrendDisplay.Viewport.validateDescriptor=function(e){"use strict";var t,i,s=e.tStart||"",n=e.tEnd||"",a=e.tDisplay||1800,l=e.prefetchPercentage||50,o=e.type||"singleLane",r=e.view||"",c=e.lanesPerView||5,u=e.labelHeight||50,h=e.firstLabelHeight||0,m=e.handleBarOffset||0,d=e.hasVerticalScaling||!0,f=e.demo||!1;return(t=/^\*(.+)\s*%\s*$/.exec(l))&&(l=t[1]),(l=Number(l))>1&&(l/=100)>1&&(l=1),(!l||l<0)&&(l=0),null===(t=shmi.visuals.controls.TrendDisplay.Parsers.timestamp(n,!0))&&(shmi.log("TrendDisplay.Viewport() invalid maxTime in configuration: "+n),t=0),"static"!==(i=0===(n=t)?"latest":-1===n?"live":"static")&&(n=shmi.getServerTime()),t=parseInt(s),isFinite(t)?t>0?s=t:t<0?s+=n:shmi.log("TrendDisplay.Viewport() invalid/missing time stamp in tStart",3):(s=Date.parse(String(s).trim()),isNaN?shmi.log("TrendDisplay.Viewport() invalid/missing time stamp in tStart",3):s=s.getTime()/1e3),s>n&&(t=s,s=n,n=t),a>(t=n-s)&&(a=t),{mode:i,minTime:s,maxTime:n,visible:a,prefetch:l,type:o,view:r,lanesPerView:c,firstLabelHeight:h,labelHeight:u,handleBarOffset:m,hasVerticalScaling:d,demo:f}},shmi.visuals.controls.TrendDisplay.onConfiguration.push([90,function _onConfigureViewport(e,t){"use strict";e.invalid||(e.viewport=shmi.visuals.controls.TrendDisplay.Viewport.validateDescriptor(e.display))}]),shmi.pkg("visuals.controls.TrendDisplay"),shmi.visuals.controls.TrendDisplay.Component=function Component(e,t){"use strict";var i=new shmi.visuals.controls.TrendDisplay.Promise,s=[];Object.defineProperty(this,"element",{value:e}),Object.defineProperty(this,"onBroadcast",{get:function(){return s},set:function(e){e&&Array.isArray(s)&&(s=e.merge(s))}}),Object.defineProperty(this,"isPrepared",{value:i}),this.trendDisplay={broadcast:shmi.visuals.controls.TrendDisplay.nop},this.config=this._initializeConfiguration(t||{}),this.parseAttributes(),this.startup()},shmi.visuals.controls.TrendDisplay.Component.prototype={events:shmi.visuals.core.BaseControl.prototype.events.concat("discover"),_initializeConfiguration:function(e){},broadcast:function(e,t){"use strict";return this.trendDisplay.broadcast(this,e,t)},onInit:function(){"use strict";shmi.addClass(this.element,"undiscovered");var e=this;this.listen("discover",(function(){return e.onDiscover.apply(e,arguments)}))},onDiscover:function(e){"use strict";var t=e.detail.trendDisplay;Object.defineProperty(this,"trendDisplay",{value:t}),this.onBroadcast=t.onBroadcast.merge(this.onBroadcast),this.markDiscovered()},markDiscovered:function(){"use strict";shmi.removeClass(this.element,"undiscovered"),shmi.addClass(this.element,"discovered")},onDelete:function(){}},shmi.visuals.controls.TrendDisplay.derive(shmi.visuals.controls.TrendDisplay.Component,shmi.visuals.core.BaseControl),shmi.visuals.controls.TrendDisplay.Controls=function(e,t,i){"use strict";var s=shmi.objectHasOwnProperty(i,"tokens")?i.tokens:[],n=shmi.objectHasOwnProperty(i,"buttons")?i.buttons:[],a=shmi.objectHasOwnProperty(i,"selectboxes")?i.selectboxes:[];Object.defineProperty(this,"manager",{value:e}),Object.defineProperty(this,"viewport",{value:t}),Object.defineProperty(this,"controls",{get:function(){return this._getControls()},set:function(e){e&&Array.isArray(e)&&(this.tokens=e.tokens,this.buttons=e.buttons,this.selectboxes=e.selectboxes)}}),Object.defineProperty(this,"tokens",{value:s}),Object.defineProperty(this,"buttons",{value:n}),Object.defineProperty(this,"selectboxes",{value:a})},shmi.visuals.controls.TrendDisplay.Controls.prototype={_getControls:function(){var e={};return e.tokens=this.tokens,e.buttons=this.buttons,e.selectboxes=this.selectboxes,e},applyButtonCloseView:function(e,t){var i=this.manager,s="close-view-button",n=i.trendDisplay,a=shmi.ctrl(n.getName()+"."+s);if(!a){var l={name:s,"class-name":"rh-button close","icon-class":"icon icon-ui-close","show-icon":!0,"show-text":!1},o=(a=shmi.createControl("button",e,l,"div")).listen("click",(function(s){n.changingView="applyButtonCloseView",n.detailView=null,shmi.removeClass(i.trendDisplay.element,"detail-view"),shmi.addClass(i.trendDisplay.element,"hidden");for(var a=i.container.parentNode.parentNode.parentNode.querySelectorAll(".lane, .action"),l=0;l<a.length;++l){var o=a[l];o.className=o.className.replace(/(?:^|\s)hidden(?!\S)/g,"")}var r=e.parentNode.parentNode.querySelector(".scaling-values");r&&(r.innerHTML=""),t._updateTrendDisplay(i,null,"dashboard")}));a.enable(),this.tokens.push(o),this.buttons.push(a)}return a},applyButtonDetailView:function(e,t,i,s){var n=this.manager,a="detail-view-button-"+i,l=n.trendDisplay,o=shmi.ctrl(l.getName()+"."+a);if(!o){var r={"class-name":"select-trend-button detail-view",name:a,"icon-class":"icon icon-trends-chart-extend","show-icon":!0},c=(o=shmi.createControl("button",e,r,"div")).listen("click",(function(e){l.changingView="applyButtonDetailView",l.detailView=i;var a=shmi.ctrl(l.getName()+".select-box-multi-lane-"+i);a&&(s=n.config.trend.signals[a.value]);for(var o=n.container.parentNode.parentNode.parentNode.querySelectorAll(".lane, .action"),r=0;r<o.length;++r){o[r].className+=" hidden"}shmi.addClass(l.element,"detail-view"),shmi.removeClass(shmi.ctrl(l.getName()+".detail-view-controls").element,"hidden"),t._updateTrendDisplay(n,s,"detail")}));o.enable(),this.tokens.push(c),this.buttons.push(o)}return o},applyButtonNavigateTimeline:function(e,t,i,s){var n=this.manager,a="scroll-"+i+"-timeline-"+e+"-"+s,l=shmi.ctrl(n.trendDisplay.getName()+"."+a),o="left"===e?-2:2;if(!l){var r={label:"","class-name":"button arrow "+e,name:a,"show-icon":!0,"show-text":!1,"icon-class":"icon icon-ui-move-"+e};l=shmi.createControl("button",t,r,"div",s);var c=0,u=l.listen("click",(function(t){c++,setTimeout((function(){1===c?shmi.visuals.session.userActions["trend-display"].call(this,n.trendDisplay.getName()+",handleTime,"+o):"right"===e?shmi.visuals.session.userActions["trend-display"].call(this,n.trendDisplay.getName()+",toggleLiveMode,-1"):shmi.visuals.session.userActions["trend-display"].call(this,n.trendDisplay.getName()+",handleTime,"+o),c=0}),200)}));l.enable(),this.tokens.push(u),this.buttons.push(l)}return l},applySelectBoxLane:function(e,t,i,s){var n=this.manager,a=this.viewport,l=i.laneIndex,o="select-box-multi-lane-"+l,r=shmi.ctrl(n.trendDisplay.getName()+"."+o),c=s[l];if(!r){var u="",h=!0,m=[],d={};c.forEach((function(e,t){(d={}).label=shmi.localize(e.label),d.value=e.valueIndex,m.push(d),0===t&&(u=e.valueIndex)}));var f={label:"",options:m,selected:u,name:o,"class-name":"rh-select-box",template:"custom/rh-controls/rh-select-box"},v=(r=shmi.createControl("select-box",e,f,"DIV","after")).listen("change",(function(e){h?h=!1:t._highlightTrendCurve(n,n.config.trend.signals[e.detail.value])}));r.setValue(u),r.enable(),this.tokens.push(v),this.selectboxes.push(r)}return a.isMultiLane&&(a.isDetailView?r.element.className+=" hidden":a.isDashboardView&&r.element.className.replace(/(?:^|\s)hidden(?!\S)/g,"")),r},deleteControls:function(e,t){t=t||!1,e&&e.forEach((function(e){if(shmi.getControlByElement(e.element)){var i=e.element.parentNode;"trend-display-timeline"!==i.getAttribute("data-ui")&&t&&i&&e.element?shmi.deleteControl(shmi.getControlByElement(i)):shmi.deleteControl(e,!0)}}))},deleteControlButtons:function(e){this.deleteControls(this.buttons,e),this.buttons=[]},deleteControlSelectboxes:function(){this.deleteControls(this.selectboxes),this.selectboxes=[]},deleteControlTokens:function(){this.tokens&&(this.tokens.forEach((function(e){e.unlisten()})),this.tokens=[])},onDelete:function(){this.deleteControlTokens(),this.deleteControlButtons(!0),this.deleteControlSelectboxes()}},shmi.visuals.controls.TrendDisplay.Continuous=function TrendDisplayContinuous(e,t){"use strict";shmi.visuals.controls.TrendDisplay.Continuous._super.call(this,e,t);var i=null,s=null,n=null,a=[],l=this._initUiControl(e),o=new shmi.visuals.controls.TrendDisplay.Messaging(!0),r=new shmi.visuals.controls.TrendDisplay.Messaging(!0),c=new shmi.visuals.controls.TrendDisplay.Messaging(!0);Object.defineProperty(this,"viewport",{get:function(){return i||null},set:function(e){(!e||e.isConfigured&&!e.invalid)&&(i&&(i.onUpdate.removeListener(this._onDirtyCanvas,this),i.onDelete()),e&&(i=new shmi.visuals.controls.TrendDisplay.Viewport(e.viewport)).onUpdate.push([this._onDirtyCanvas,this]))}}),Object.defineProperty(this,"width",{get:function(){return this.element.offsetWidth}}),Object.defineProperty(this,"height",{get:function(){return this.element.offsetHeight}}),Object.defineProperty(this,"mouseInput",{value:l.mouse}),Object.defineProperty(this,"touchInput",{value:l.touch}),Object.defineProperty(this,"onSlide",{value:o}),Object.defineProperty(this,"onShift",{value:r}),Object.defineProperty(this,"onState",{value:c}),Object.defineProperty(this,"curves",{get:function(){return a},set:function(e){e.isConfigured&&!e.invalid&&(a=this._generateCurves(e))}}),Object.defineProperty(this,"renderer",{get:function(){return n},set:function(e){(!e||e.isConfigured&&!e.invalid)&&(n&&(o.removeListener(n.onSlide,n),r.removeListener(n.onShift,n),n.onDelete()),e&&(n=this._generateRenderingManager(e),o.addListener(n.onSlide,n),r.addListener(n.onShift,n)))}}),Object.defineProperty(this,"trend",{get:function(){return s},set:function(e){e.isConfigured&&!e.invalid&&(s=this.trendDisplay.data.getTrendByName(e.trend.name))}})},shmi.visuals.controls.TrendDisplay.Continuous.prototype={uiType:"trend-display-continuous",isContainer:!1,getClassName:function(){"use strict";return"TrendDisplayContinuous"},_initializeConfiguration:function(e){"use strict";return shmi.def(e,"class-name","trend-display-continuous"),shmi.def(e,"template","default/trend-display/component/continuous"),e},onInit:function(){"use strict";this._super(this.TrendDisplayContinuous,"onInit")},_interactionMode:{pinching:!1,sliding:!1,shifting:!1},_initUiControl:function(e){"use strict";var t,i,s,n,a,l=shmi.visuals.controls.TrendDisplay,o=this,r=o._interactionMode,c={base:{x:0,y:0},current:{x:0,y:0},applied:{x:0,y:0},focus:{x:0,y:0},throttle:null};function _onChangingZoom(){c.throttle||(c.throttle=setTimeout(_onThrottlingZoom,50))}function _onThrottlingZoom(){c.throttle=null,c.current.x===c.applied.x&&c.current.y===c.applied.y||_applyZoom()}function _applyZoom(){var e=o.viewport;e.transaction=!0,c.applied.x=c.current.x,c.applied.y=c.current.y,e.handleTime=c.focus.x,e.zoomFocusY=c.focus.y,e.zoomX=c.current.x,e.zoomY=c.current.y,e.transaction=!1}function _zoomY(e,t){var i=o.viewport,s=o.getDC();s&&(c.current.y=l.limit(e,i.minZoomY,i.maxZoomY),isNaN(t)||(c.focus.y=s.deriveFocusY(c.current.y,-(t-o.renderer.getCanvasSize().height/2))))}return i={onPress:function(e,i,l){if(!o.trendDisplay.locked){var r=o.viewport,u=o.renderer,h=o.getDC();s=u.getCanvasSize(),t=u.canvas,c.base.x=c.current.x=c.applied.x=r.zoomX,c.base.y=c.current.y=c.applied.y=r.zoomY,function _initSlide(e,t,i,s){if(s){var a=s.time2X(t.leftTime,0),l=s.time2X(t.minLeftTime,0),o=s.time2X(t.maxLeftTime,0);(n={start:parseInt(i.style.left)||0}).end=n.start,n.min=n.start-(o-a),n.max=n.start+(a-l)}}(0,r,t,h),function _initShift(e,t,i,s,n){if(s){var l=s.value2Y(s.minValue,0),o=s.value2Y(s.maxValue,0);(a={start:parseInt(i.style.top)||0}).end=a.start,a.min=-(l-n.height),a.max=-o}}(0,0,t,h,s)}},onRelease:function(e,t,i){var s=o.trendDisplay,c=o.viewport,u=o.getDC();if(n&&n.end!==n.start&&(c.leftTime=u.x2Time(u.time2X(c.leftTime,0)+(n.start-n.end))),a&&a.end!==a.start&&(c.zoomFocusY=l.limit(u.y2Focus(u.focus2Y(c.zoomFocusY)-(a.end-a.start)),u.minFocus(),u.maxFocus())),r.sliding&&(c.transaction=!1,r.sliding=!1,shmi.removeClass(o.element,"sliding"),s.broadcast(o,"slide-end")),r.shifting&&(c.transaction=!1,r.shifting=!1,shmi.removeClass(o.element,"shifting"),s.broadcast(o,"shift-end")),r.pinching){var h=shmi.getUiElement("pinch-canvas",o.element.parentNode);c.transaction=!1,r.pinching=!1,_applyZoom(),shmi.removeClass(o.element,"pinching"),h&&(h.style.display="none"),s.broadcast(o,"pinch-end")}},onClick:function(e,t,i){if(!o.trendDisplay.locked&&"CANVAS"===i.target.nodeName&&o.getDC()){var n=o._globalToLocal(e,t);o.viewport.handleTime=o.getDC().x2Time(n.x+s.x)}},onDoubleClick:function(e,t,i){},onDrag:function(e,t,i){var s;o.trendDisplay.locked||n&&((s=l.limit(n.end+e,n.min,n.max))!==n.end?(n.end=s,r.sliding||(o.viewport.transaction=!0,r.sliding=!0,shmi.addClass(o.element,"sliding"),o.trendDisplay.broadcast(o,"slide-start"),o.trend.running=!1,o.viewport.isLive=!1),o.onSlide.send("move",s-n.start)):s===n.start&&(o.trend.running=!0,o.viewport.isLive=!0),(s=l.limit(a.end+t,a.min,a.max))!==a.end&&(a.end=s,r.shifting||(o.viewport.transaction=!0,r.shifting=!0,shmi.addClass(o.element,"shifting"),o.trendDisplay.broadcast(o,"shift-start")),o.onShift.send("move",s-a.start)),i.preventDefault(),i.stopPropagation())},onScale:function(e,t,i,n,a,l){if(!o.trendDisplay.locked){var u=shmi.getUiElement("pinch-canvas",o.element.parentNode);if(!o.viewport.isDashboardView){if(r.pinching||(o.viewport.transaction=!0,r.pinching=!0,shmi.addClass(o.element,"pinching"),o.trendDisplay.broadcast(o,"pinch-start"),c.focus.x=o.getDC().x2Time(t+s.x),u&&(u.style.display="block")),u){u.width=u.parentNode.getBoundingClientRect().width,u.height=u.parentNode.getBoundingClientRect().height;var h=getComputedStyle(u).color,m=u.getContext("2d"),d=l[2],f=l[3],v={x:d.x<f.x?d.x:f.x,y:d.y<f.y?d.y:f.y,width:Math.abs(d.x-f.x),height:Math.abs(d.y-f.y)};m.clearRect(0,0,u.width,u.height),m.beginPath(),m.strokeStyle=h,m.setLineDash([4,2]),m.rect(v.x,v.y,v.width,v.height),m.stroke()}_zoomY(c.base.y*(a+Math.sqrt(a))/2,i),c.current.x=c.base.x*(n+Math.sqrt(n))/2,_onChangingZoom()}}},onWheel:function(e,t){if(o.trendDisplay&&!o.trendDisplay.locked){t.preventDefault();var i=o._globalToLocal(t.clientX,t.clientY),s=o.viewport;if(t.shiftKey)c.current.x=e>0?s.zoomX*shmi.c("TREND_DISPLAY_ZOOM_SCALE_X"):s.zoomX/shmi.c("TREND_DISPLAY_ZOOM_SCALE_X"),c.focus.y=s.zoomFocusY,_zoomY(s.zoomY),_onChangingZoom();else if(s.isDashboardView){var n=o.trendDisplay.config.display;if(!n.demo&&"CANVAS"===t.target.nodeName){var a=parseInt(e/10),l=-parseInt(t.target.height,10)/4,r=parseInt(t.target.style.top,10)+a;if(r<l){var u=t.target.parentNode.getElementsByClassName("lane");if(r>l-2*n.labelHeight*(u.length-5)){o.trend.running=!1,o.viewport.isLive=!1,t.target.style.top=String(r)+"px";for(var h=t.target.parentNode.parentNode.parentNode.querySelectorAll(".lane, .action, .handle-bar .value, .handle-bar .signal"),m=0;m<h.length;++m){var d=h[m];d.style.top=String(parseInt(d.style.top,10)+a)+"px"}}}}}else c.current.x=s.zoomX,_zoomY(e>0?s.zoomY*shmi.c("TREND_DISPLAY_ZOOM_SCALE_Y"):s.zoomY/shmi.c("TREND_DISPLAY_ZOOM_SCALE_Y"),i.y),_onChangingZoom()}}},{mouse:new shmi.visuals.io.MouseListener(e,i),touch:new shmi.visuals.io.TouchListener(e,i)}},getDC:function(){"use strict";var e=this.curves[0];return e&&e.drawingContext},_globalToLocal:function(e,t){"use strict";var i=shmi.getAbsPosition(this.element),s=shmi.visuals.controls.TrendDisplay.getScrollOffset();return{x:e-i.x+s.x,y:t-i.y+s.y}},onEnable:function(){"use strict";this.isPrepared.then((function(e){e.mouseInput.enable(),e.touchInput.enable(),e.onResize(),e.enableTrendStream(!0)}))},onDisable:function(){"use strict";this.enableTrendStream(!1),this.mouseInput.disable(),this.touchInput.disable()},onDelete:function(){"use strict";var e=this;e.mouseInput.disable(),e.touchInput.disable(),e.viewport=null,e.enableTrendStream(!1),e.trendDisplay&&e.trendDisplay.config&&e.trendDisplay.config.trend&&e.trendDisplay.config.trend.signals&&e.trendDisplay.config.trend.signals.forEach((function(t,i){var s=shmi.ctrl("."+e.renderer.config.name+".actions-lane-"+i);s&&shmi.deleteControl(s,!0)})),e.renderer&&e.renderer.controls&&e.renderer.controls.onDelete(),e.renderer=null,e.onSlide.reset(),e.onShift.reset(),e.onState.reset(),e._super(e.TrendDisplayContinuous,"onDelete")},onDiscover:function(e){"use strict";var t=e.detail.trendDisplay;t.isPreparing="discover-continuous",this._super(this.TrendDisplayContinuous,"onDiscover",e),this._configure(t.config),this.onBroadcast.push([100,this._onBroadcast,this]),this.isPrepared.resolve(this),t.isPreparing=!1},_configure:function(e){"use strict";if(!e.invalid){var t,i=shmi.visuals.controls.TrendDisplay;if(e.noRecal||(this.viewport=e),this.renderer=e,this.trend=e,this.curves=e,this.controls=e,this.trend.gotData.isResolved()){var s=this.trend.data;this.viewport.minSampleTime=s.startTime,this.viewport.maxSampleTime=s.endTime}t=new i.CanvasBackground(this.renderer,this.getDC(),this.curves),this.renderer.onRender.push([50,t.render,t])}},_generateRenderingManager:function(e){"use strict";var t=shmi.visuals.controls.TrendDisplay,i=shmi.getUiElement("continuous-canvas-container",this.element),s=shmi.getUiElement("continuous-canvas",i||this.element);switch(((s||{}).nodeName||"").toLowerCase()){case"svg":return new t.SvgRenderingManager(i,s,this.viewport,t.SvgCurve,e);case"canvas":return new t.CanvasRenderingManager(i,s,this.viewport,t.CanvasCurve,e,this.trendDisplay);default:return shmi.log("TrendDisplay: missing canvas for rendering trend curves",2),new t.AbstractRenderingManager(i,s||{style:{}},this.viewport,(function _privateClass(){}),{})}},_generateCurves:function(e){"use strict";var t=this.renderer,i=t.elementClass,s=[];return void 0!==e.trend.signals&&(s=e.trend.signals.map((function(e,s){var n=new i(t,e);return n.index=s,t.onRender.push([n.render,n]),n}))),s},onResize:function(){var e=this.element;this.renderer&&this.renderer.resize(e.offsetWidth,e.offsetHeight,this.viewport.prefetch)},enableTrendStream:function(e){"use strict";var t=this.trend;t&&(e?(t.onData.addListener(this._onTrendData,this),this._configureTrend(t).running=!0):(t.running=!1,t.onData.removeListener(this._onTrendData,this)))},_onTrendData:function(e){var t=this.viewport,i=e.data;t.transaction=!0,t.minSampleTime=i.startTime,t.maxSampleTime=i.endTime,t.isLive&&this._setLeftTimeInLiveMode(t),this.renderer.update(i,this.trendDisplay.isPreparing||t.transactionQueue.length>0),this.broadcast("trend-update",{trend:e}),t.transaction=!1},_updateViewportRelatedItems:function(e){var t=this.trendDisplay.items,i=this.viewport;t&&((!e.length||e.indexOf("isLive")>=0)&&t.getByName("live").writeValue(i.isLive?1:0,!0),(!e.length||e.indexOf("zoomY")>=0)&&t.getByName("zoomY").writeValue(100*i.zoomY,!0),(!e.length||e.indexOf("zoomX")>=0)&&t.getByName("zoomX").writeValue(100*i.zoomX,!0),(!e.length||e.indexOf("handleTime")>=0)&&t.getByName("handleTime").writeValue(i.handleTime,!0),(!e.length||e.indexOf("leftTime")>=0)&&t.getByName("leftTime").writeValue(i.leftTime,!0))},_setLeftTimeInLiveMode:function(e){return e.transaction=!0,this.onState.send(this,{mode:"live",viewport:e}).then((function(t){t||(e.rightTime=e.maxSampleTime)})).finally((function(){e.transaction=!1}))},_setInitialHandleTime:function(e){var t=this;return e.transaction=!0,this.onState.send(this,{mode:"handleTime",viewport:e}).then((function(i){if(!i)if(e.isLive){var s=e.maxSampleTime,n=t.getDC(),a=t.renderer.getCanvasSize();n.time2X(s)>=a.x+a.width&&(s=n.x2Time(a.x+a.width-1)),e.handleTime=s}else t.trendDisplay.config.noRecal?t._onUpdateHandleTime(e.handleTime):e.handleTime=(e.leftTime+e.rightTime)/2})).finally((function(){e.transaction=!1}))},_onDirtyCanvas:function(e,t){"use strict";var i=!1,s=this.trend,n=t.filter((function(e){return"initialize"!==e}));this._updateViewportRelatedItems(n),t.indexOf("initialize")<0&&(t.indexOf("isLive")>=0&&e.isLive&&(this._setLeftTimeInLiveMode(e),i=!0),e.handleTime&&this._onUpdateHandleTime(e.handleTime),t.indexOf("zoomX")>=0&&(s.running=!1,e.isLive=!1),e.transactionQueue.length||this.broadcast("render"),(i||this._requiresFetchingData())&&(s.running=!1,this._configureTrend(s).running=!0))},_onUpdateHandleTime:function(e){var t,i=this.getDC(),s=this.renderer.getCanvasSize(),n=i.time2X(e,0),a=this,l=this.trendDisplay.items,o=this.trend.data,r=this.viewport,c=this.curves,u=[];if(!this.trendDisplay.handleDragging){var h=this.trendDisplay.controls[4];o=e>=o.startTime&&e<=o.endTime?o.values:null,r.isMultiLane&&Object.keys(c).forEach((function(e,i){t=a.curves[e].signal,void 0===u[t.laneIndex]&&(u[t.laneIndex]=[]),u[t.laneIndex].push(t)}));var m=this.trendDisplay.config.display,d=m.labelHeight,f=r.isDashboardView?u.length<m.lanesPerView?u.length:m.lanesPerView:1,v=s.height,g=(v-d*f)/f;if(Object.keys(c).forEach((function(t){var i=a.curves[t].signal,s=i.alias||i.name,n=i.valueIndex,c=i.laneIndex||0,h=l.getByName(s,"value"),f=shmi.getUiElement("handle-bar",this.element),p=!0,b=null,y=null,E=null;if(r.isMultiLane&&u[c].length>1){var C=shmi.ctrl(a.trendDisplay.getName()+".select-box-multi-lane-"+c);C&&n!==C.value&&(p=!1)}var T=f.parentNode.querySelector(".value.index-"+String(n)),x=f.parentNode.querySelector(".signal.index-"+String(n));if(p&&o&&h){if(o.some((function(t){return b=y,y={timestamp:t[0],value:t[1][n]},t[0]>e})),null!==y&&null!==y.value){if(y.value&&shmi.objectHasOwnProperty(y.value,"min")&&shmi.objectHasOwnProperty(y.value,"max"))E=(parseFloat(y.value.min)+parseFloat(y.value.max))/2;else if(b&&b.value){var w=y.timestamp-b.timestamp,I=parseFloat(b.value);E=I+(parseFloat(y.value)-I)/w*(e-b.timestamp)}else E=parseFloat(y.value);if(h.writeValue(E),f){var k,S=v-m.firstLabelHeight,L=Math.round(E),D=Math.abs(E-i.min)/(i.max-i.min)*100,_=10;if(r.isDashboardView?_=(S=d*c+g*(c+1)+m.labelHeight+m.handleBarOffset)-g:(S=v-m.handleBarOffset,_=m.labelHeight),k=S-g*D/100,T||x)x.style.top=k+"px",T.style.top=_+"px",T.innerHTML=String(L);else{var O=f.ownerDocument;(T=O.createElement("div")).className="value index-"+String(n),T.style.top=_+"px",T.innerHTML=String(L),(x=O.createElement("div")).className="signal index-"+String(n),x.style.top=k+"px",f.appendChild(T),f.appendChild(x)}}}}else T&&x&&(f.removeChild(T),f.removeChild(x))})),h){var p=h.program;p&&p.steps.then((function(t){var i=t.asArray[0],s=Math.abs(e-i.tStartReal);t.asArray.forEach((function(t,n){var a=Math.abs(e-t.tStartReal);a<s&&e>=t.tStartReal?(i=t,s=a):a===s&&e>i.tStartReal&&(i=t)})),console.debug("[TrendDisplay]","current step:",i),i.cvn.forEach((function(e,t){l.items.pgm["CV".concat(p.cvs[t].valueIndex)].writeValue(e)})),i.svn.forEach((function(e,t){l.items.pgm["SV".concat(p.svs[t].valueIndex)].writeValue(e)})),i.ndo.forEach((function(e,t){l.items.pgm["DO".concat(p.dos[t].valueIndex)].writeValue(e?1:0)}))}))}this.broadcast("move-handle",{time:e,refTime:this.viewport.minTime,left:n,canvas:s})}},_requiresFetchingData:function(){var e=this.viewport,t=this.trend;return!this._interactionMode.pinching&&(!!t&&(this._getBestTrendUnit()!==t.unit||(e.leftTime<t.startTime||!e.isLive&&e.rightTime>t.endTime)))},_getBestTrendUnit:function(){var e,t=this.viewport,i=this.trendDisplay.config||{},s=Math.ceil(t.visibleTimeSpan/this.renderer.getCanvasSize().width*i.display.pixelsPerValue);return(!(e=i.trend.aggregate.unit)||e<s)&&(e=s),e},_configureTrend:function(e){"use strict";var t=this.viewport,i=this.trendDisplay.config||{};if(e.startTime=t.leftRenderTime,e.endTime=t.isLive?-1:t.rightRenderTime,e.aggregate=i.trend.aggregate.method,e.unit=this._getBestTrendUnit(),i.trend.items.length){var s=i.trend.items.map((function(e){return e.alias}));e.items=s}return e},_onBroadcast:function(e){var t,i,s,n=this,a=this.viewport;switch(e.type){case"ui-show-curve":this.isPrepared.then((function(s){var n=e.detail.value,a=s.trendDisplay.config||{};(t=s.curves[n.curveIndex])&&(t.visible=n.isVisible&&a.trend.items[n.curveIndex].visible,s.renderer.update(),"item"!==e.detail.cause&&(i=s.trendDisplay.items.getByName(t.signal.alias||t.signal.name,"visible"))&&i.writeValue(n.isVisible?1:0))}));break;case"ui-live":a&&!this.trendDisplay.isPreparing&&this.isPrepared.then((function(t){a.isLive=!!e.detail.value,"item"!==e.detail.cause&&t._updateViewportRelatedItems(["isLive"])}));break;case"ui-zoomX":a&&this.isPrepared.then((function(t){s=e.detail.value/100,a.zoomX=s>=a.minZoomX?s:a.minZoomX,"item"!==e.detail.cause&&t._updateViewportRelatedItems(["zoomX"])}));break;case"ui-zoomY":a&&this.isPrepared.then((function(t){s=e.detail.value/100,a.transaction=!0,a.zoomY=s>=a.minZoomY?s:a.minZoomY,a.zoomFocusY=t.getDC().deriveFocusY(a.zoomY,0),a.transaction=!1,"item"!==e.detail.cause&&t._updateViewportRelatedItems(["zoomY"])}));break;case"ui-handleTime":a&&this.isPrepared.then((function(t){s=e.detail.value,a.handleTime=s>=a.minLeftTime?s:a.minLeftTime,"item"!==e.detail.cause&&t._updateViewportRelatedItems(["handleTime"])}));break;case"ui-leftTime":a&&this.isPrepared.then((function(t){s=e.detail.value,a.leftTime=s>=a.minLeftTime?s:a.minLeftTime,"item"!==e.detail.cause&&t._updateViewportRelatedItems(["leftTime"])}));break;case"resize":this.onResize();break;case"preparation-finished":this.trend.gotData.then((function(){var e;a.transaction=!0,a.isLive&&n._setLeftTimeInLiveMode(a),n._setInitialHandleTime(a),n._updateViewportRelatedItems([]),e=!a.transactionQueue.length,a.transaction=!1,e&&n.renderer.update()}));break;case"render":e.detail.suppress||this.renderer.update();break;case"configuration-changed":this.trendDisplay.isPreparing="reconfigure-continuous",this.onDisable(),this._configure(e.detail.configuration),this.onEnable(),this.trendDisplay.isPreparing=!1,this._updateViewportRelatedItems([])}}},shmi.visuals.controls.TrendDisplay.derive(shmi.visuals.controls.TrendDisplay.Continuous,shmi.visuals.controls.TrendDisplay.Component,"TrendDisplayContinuous"),shmi.visuals.controls.TrendDisplay.onConfiguration.push((function _onConfigureContinuous(e,t){"use strict";e.display||(e.display={});var i=parseInt(e.display.pixelsPerValue);isNaN(i)&&(i=1),e.display.pixelsPerValue=i})),shmi.c("TREND_DISPLAY_ZOOM_SCALE_X",1.2),shmi.c("TREND_DISPLAY_ZOOM_SCALE_Y",1.2),shmi.c("TREND_DISPLAY_ZOOM_SCALE_X_MIN",1e-5),shmi.c("TREND_DISPLAY_ZOOM_SCALE_X_MAX",Number.MAX_SAFE_INTEGER),shmi.c("TREND_DISPLAY_ZOOM_SCALE_Y_MIN",1),shmi.c("TREND_DISPLAY_ZOOM_SCALE_Y_MAX",20),shmi.c("TREND_DISPLAY_TRENDINFO_TIMEOUT",1e4),shmi.visuals.controls.TrendDisplay.Handle=function TrendDisplayHandle(e,t){"use strict";shmi.visuals.controls.TrendDisplay.Handle._super.call(this,e,t);var i=this._initUiControl(e),s=null,n=null;Object.defineProperty(this,"mouseInput",{value:i.mouse}),Object.defineProperty(this,"touchInput",{value:i.touch}),Object.defineProperty(this,"leftTabbed",{get:function(){return s},set:function(t){(t=!!t)!==s&&((s=t)?shmi.addClass(e,"left-tabbed"):shmi.removeClass(e,"left-tabbed"))}}),Object.defineProperty(this,"isSet",{get:function(){return n},set:function(t){(null===n||t)&&(t=!!t)!==n&&((n=t)?(shmi.removeClass(e,"unset"),shmi.addClass(e,"set")):(shmi.removeClass(e,"set"),shmi.addClass(e,"unset")))}})},shmi.visuals.controls.TrendDisplay.Handle.prototype={uiType:"trend-display-handle",isContainer:!1,getClassName:function(){"use strict";return"TrendDisplayHandle"},_initializeConfiguration:function(e){"use strict";return shmi.def(e,"class-name","trend-display-handle"),shmi.def(e,"template","default/trend-display/component/handle"),e},onDiscover:function(e){"use strict";this.isSet=!1,Object.defineProperties(this,{handleBar:{value:shmi.getUiElement("handle-bar",this.element)},handleTab:{value:shmi.getUiElement("handle-tab",this.element)},handleDate:{value:shmi.getUiElement("handle-date",this.element)}}),this.onBroadcast.push([this._onBroadcast,this]),this._super(this.TrendDisplayHandle,"onDiscover",e);var t=this,i=e.detail.trendDisplay.getComponents("trend-display-continuous")[0];i&&(Object.defineProperty(this,"continuous",{value:i}),i.isPrepared.then((function(){t.isPrepared.resolve(t)})))},onEnable:function(){"use strict";this.isPrepared.then((function(e){e.mouseInput.enable(),e.touchInput.enable()}))},onDisable:function(){"use strict";this.mouseInput.disable(),this.touchInput.disable()},_onBroadcast:function(e){var t,i,s,n,a,l=e.detail,o=this.handleBar,r=this.handleTab,c=this.handleDate,u=this.trendDisplay.config;switch(e.type){case"move-handle":this.isSet=!0,a=l.left-l.canvas.x,o.style.left=String(a)+"px",l.keepTabbing||(this.leftTabbed=a>.8*l.canvas.width),c&&(s=u["date-format"]||"$DD.$MM.$YYYY",n=!!u["utc-time"]&&u["utc-time"],i=!0!==this.trendDisplay.config["rel-time"]?Math.round(l.time):Math.round(l.time-l.refTime),c.textContent=shmi.requires("visuals.tools.date").formatDateTime(i,{datestring:s,utc:n})),r&&(t=!0!==this.trendDisplay.config["rel-time"]?this._formatRelativeTime(Math.round(l.time)):this._formatRelativeTime(Math.round(l.time-l.refTime)),r.textContent=t)}},_formatRelativeTime:function(e){if(!0!==this.trendDisplay.config["rel-time"]){var t=this.trendDisplay.config["time-format"]||"$HH:$mm:$ss";return shmi.requires("visuals.tools.date").formatDateTime(e,{datestring:t,utc:this.trendDisplay.config["utc-time"]})}for(var i,s,n=[60,60,24,30],a=["",":",":","d ","m "],l="";n.length>2&&e>0;)i=e%(s=n.shift()),e=Math.floor(e/s),l=(i=60===s&&(n.length>2||e>0)?String("00"+i).substr(-2):String(i))+a.shift()+l;return l},_initUiControl:function(e){"use strict";var t,i,s,n,a=shmi.visuals.controls.TrendDisplay,l=this,o=null;function _onDragHandleBar(){s||(s=setTimeout(_onThrottledShowTime,100))}function _stopThrottledShowTime(){s&&(clearTimeout(s),s=null)}function _onThrottledShowTime(){s&&(i.vp.handleTime=i.dc.x2Time(i.canvas.x+i.bar+i.end-i.start),l.continuous._onUpdateHandleTime(i.vp.handleTime),_stopThrottledShowTime(),function _showTime(){var e=i.canvas.x+i.bar+i.end-i.start;l._onBroadcast({source:l,type:"move-handle",detail:{time:i.dc.x2Time(e),refTime:i.vp.minTime,left:e,canvas:i.canvas,keepTabbing:!0}})}())}return t={onPress:function(e,t,s){var a=l.continuous,o=a.element,r=parseInt(l.handleBar.style.left)||0;a.getDC()&&(i={box:o,dc:a.getDC(),canvas:a.renderer.getCanvasSize(),vp:a.viewport,bar:r,start:e,end:e,min:e-r,max:e+o.offsetWidth-r-1,current:e},n={bar:r,x:e},s.preventDefault(),s.stopPropagation())},onRelease:function(e,t,s){var n=l.trendDisplay;n.handleDragging=!1,i&&(i.end!==i.start&&(_stopThrottledShowTime(),i.vp.handleTime=i.dc.x2Time(i.canvas.x+i.bar+i.end-i.start)),o&&(i.vp.transaction=!1,o=null,shmi.removeClass(l.element,"dragging"),n.broadcast(l,"drag-handle-end")),i=null),s.preventDefault(),s.stopPropagation()},onDrag:function(e,t,s){if(i){i.current+=e;var r=a.limit(i.current,i.min,i.max),c=e<=0&&r<=i.min+200,u=e>=0&&r>=i.max-200,h=l.trendDisplay.config.display;if(l.trendDisplay.handleDragging=!0,r!==i.end)i.end=r,o||(i.vp.transaction=!0,o=!0,shmi.addClass(l.element,"dragging"),l.trendDisplay.broadcast(l,"drag-handle-start")),l.handleBar.style.left=String(i.bar+i.end-i.start)+"px",_onDragHandleBar();else if(null!==i){var m=!1;if(c||u){var d=parseInt(l.handleBar.style.left),f=d<2&&d===n.bar?10:-r+i.start;if(c)m=i.start>=i.current&&(f>n.x||d<2&&d===n.bar);else if(u){var v=-i.canvas.width/2;m=-l.continuous.element._offsetX+r>v&&f<n.x}m&&!h.demo&&(i.start+=e,i.end+=e,o||(i.vp.transaction=!0,o=!0,shmi.addClass(l.element,"dragging"),l.trendDisplay.broadcast(l,"drag-handle-start"),i.vp.handleTime=i.dc.x2Time(d+i.canvas.x+i.bar+Number(i.end)-i.start),l.continuous._onUpdateHandleTime(i.vp.handleTime),l.continuous.trend.running=!1,i.vp.isLive=!1),d<=20&&(f+=50,d=d<=1?1:d),l.continuous.onSlide.send("move",f),l.handleBar.style.left=String(d)+"px",_onDragHandleBar()),n={bar:d,x:f}}}s.preventDefault(),s.stopPropagation()}}},{mouse:new shmi.visuals.io.MouseListener(e,t),touch:new shmi.visuals.io.TouchListener(e,t)}}},shmi.visuals.controls.TrendDisplay.derive(shmi.visuals.controls.TrendDisplay.Handle,shmi.visuals.controls.TrendDisplay.Component,"TrendDisplayHandle"),shmi.visuals.controls.TrendDisplay.Scale=function TrendDisplayScale(e,t){"use strict";shmi.visuals.controls.TrendDisplay.Scale._super.call(this,e,t);var i=null,s=null,n=null,a=null,l=null,o=null,r=null;Object.defineProperty(this,"viewport",{get:function(){return i||(i=this.continuous?this.continuous.viewport:null),i},set:function(){i=null}}),Object.defineProperty(this,"renderer",{get:function(){return s||(s=this._generateRenderingManager()),s},set:function(){s&&s.onDelete(),s=null}}),Object.defineProperty(this,"curves",{get:function(){var e,t=0,i={};return n||(n=this.continuous?this.continuous.curves.filter((function(s,n){var a,l="_"+s.signal.unit+"_"+s.signal.max+"_"+s.signal.min;return s.signal.scaleVisible?(e=String.fromCharCode(65+t),++t,a=!0):i[l]?(e=i[l],a=!1):(e="",i[l]=e,a=!1),s.signal.labelLetter=e,a})):null),n||[]},set:function(){n=null}}),Object.defineProperty(this,"labels",{get:function(){return a||(a=this._generateLabels()),a},set:function(){a&&(a.forEach((function(e){e.parentNode.removeChild(e)})),a=null)}}),Object.defineProperty(this,"labelsReady",{get:function(){return null!==a}}),Object.defineProperty(this,"scales",{get:function(){return l||(l=this._generateScales()),l||[]},set:function(){l&&(l.forEach((function(e){e.onDelete()})),l=null)}}),Object.defineProperty(this,"ruler",{get:function(){return o||(o=this._generateRuler()),o},set:function(){o&&(o.onDelete(),o=null)}}),Object.defineProperty(this,"dimensions",{get:function(){return r||(r=this._getDimensions()),r},set:function(){r=null}})},shmi.visuals.controls.TrendDisplay.Scale.prototype={uiType:"trend-display-scale",isContainer:!1,getClassName:function(){"use strict";return"TrendDisplayScale"},_initializeConfiguration:function(e){"use strict";return shmi.def(e,"class-name","trend-display-scale"),shmi.def(e,"template","default/trend-display/component/scale"),e},onDiscover:function(e){"use strict";this._super(this.TrendDisplayScale,"onDiscover",e);var t=this,i=e.detail.trendDisplay,s=i.getComponents("trend-display-continuous")[0];s&&(i.isPreparing="discover-scale",Object.defineProperty(this,"continuous",{value:s}),s.isPrepared.then((function(e){Object.defineProperty(t,"labelsContainer",{value:shmi.getUiElement("labels-container",t.element)}),Object.defineProperty(t,"container",{value:shmi.getUiElement("scales-canvas-container",t.element)}),Object.defineProperty(t,"canvas",{value:shmi.getUiElement("scales-canvas",t.container||t.element)}),Object.defineProperty(t,"rulerLabel",{value:t._generateRulerLabel()}),e.onShift.push([t._onShift,t]),t.onBroadcast.push([50,t._onBroadcast,t]),t._configure().then((function(){t.isPrepared.resolve(t),i.isPreparing=!1}))})))},_configure:function(){var e=this,t=e._countCurveLabels();return this.viewport=null,this.renderer=null,this.curves=null,this.labels=null,this.scales=null,this.ruler=null,this.dimensions=null,this.scales,this.ruler,this.broadcast("scale-size",{before:t||0,now:this.curves.filter((function(e){return e&&e.signal&&e.signal.scaleVisible})).length||0}).then((function(){e.broadcast("resize")}))},_countCurveLabels:function(){return this.trendDisplay.config.trend.signals.filter((function(e){return e.scaleVisible})).length},onEnable:function(){this.isPrepared.then((function(e){e.onResize()}))},onDelete:function(){this.scales.forEach((function(e){e.onDelete()})),this.labels.forEach((function(e){e.parentNode.removeChild(e)})),this.ruler=null,this.rulerLabel&&this.rulerLabel.parentNode&&this.rulerLabel.parentNode.removeChild(this.rulerLabel),this.renderer=null},_generateRenderingManager:function(){var e;switch(((this.canvas||{}).nodeName||"").toLowerCase()){case"canvas":e=new shmi.visuals.controls.TrendDisplay.CanvasRenderingManager(this.container,this.canvas,this.viewport,shmi.visuals.controls.TrendDisplay.CanvasScale,this.trendDisplay.config,this.trendDisplay);break;default:return shmi.log("TrendDisplay: missing canvas element for rendering scales",2),null}return e.onRender.synchronous=!0,e},_generateLabels:function(){if(!this.labelsContainer)return[];var e=this.labelsContainer,t=this.rulerLabel,i=e.ownerDocument,s=this.curves.filter((function(e){return e&&e.signal&&e.signal.scaleVisible})).map((function(s,n){var a,l,o,r=s.signal,c=r.labelLetter,u=i.createElement("div"),h=String(r.unit)?"["+String(r.unit)+"]":"";return(a=i.createElement("div")).className="label",u.className="inner-text",u.textContent=c,a.appendChild(u),(l=i.createElement("div")).className="unit",l.appendChild(i.createTextNode(shmi.localize(h))),(o=i.createElement("div")).className="curve index-"+String(n+1),o.appendChild(a),o.appendChild(l),e.insertBefore(o,t)}));return shmi.fire("labels-ready",{name:this.trendDisplay.getName()},this.trendDisplay),s},_generateRulerLabel:function(){var e,t=this.labelsContainer,i=t.ownerDocument;return(e=i.createElement("div")).className="ruler",e.appendChild(i.createTextNode(" ")),t.appendChild(e)},_generateRuler:function(){if(!this.curves.length)return null;var e=this.renderer,t=this.viewport,i=e.elementClass,s=shmi.visuals.controls.TrendDisplay,n=this.curves,a=n[0].signal,l=null;switch(i){case s.CanvasScale:t.isSingleLane&&(l=new s.CanvasRuler(e,n,a))}return l&&e.onRender.push([l.render,l]),l},_generateScales:function(){var e=this.renderer,t=e?e.elementClass:null;return t?this.curves.map((function(i,s){var n=new t(e,i.signal);return n.index=s,e.onRender.push([n.render,n]),n})):[]},_getDimensions:function(){var e=this.labels,t={width:0},i=this.rulerLabel;return t.signals=this.curves.filter((function(e){return e&&e.signal&&e.signal.scaleVisible})).map((function(i,s){var n=e[s],a=n.offsetWidth;return t.width+=a,{x:n.offsetLeft,width:a}})),t.ruler={x:i.offsetLeft,width:i.offsetWidth},t.width+=t.ruler.width,t},onResize:function(){var e,t,i=this.container||this.canvas,s=this.renderer,n=this.viewport;s&&n&&(this.dimensions=!0,e=this.dimensions.width,t=i.offsetParent.offsetHeight,s.resize(e,t,0,n.prefetch),s.update(this))},_onShift:function(e,t){this.container.style.top=String(-this.renderer.getCanvasSize().y+t)+"px"},_onBroadcast:function(e){var t,i,s=this;switch(e.type){case"preparation-finished":case"render":e.detail.suppress||this.isPrepared.then((function(e){e.renderer.update(e)}));break;case"resize":this.onResize();break;case"configuration-changed":(i=(t=this.trendDisplay).getComponents("trend-display-continuous")[0])&&i.isPrepared.isResolved()&&(t.isPreparing="reconfigure-scale",this._configure().then((function(){return s.broadcast("resize")})).then((function(){t.isPreparing=!1})))}}},shmi.visuals.controls.TrendDisplay.derive(shmi.visuals.controls.TrendDisplay.Scale,shmi.visuals.controls.TrendDisplay.Component,"TrendDisplayScale"),shmi.visuals.controls.TrendDisplay.Scale.forEachStep=function(e,t,i,s,n){var a,l,o=e.y2Relative(t.y),r=e.y2Relative(t.y+t.height),c=i.scale.availableSteps,u=i.scale.availableMajorSteps,h=null,m=-1;if(c.forEach((function(e,t){(o-r)/e<=s+1&&(h=e,m=t)})),h)for(r=_accuracy(Math.floor(e.y2Relative(t.totalHeight)/h)*h),o=e.y2Relative(0),r<0&&(r=0),o>1&&(o=1),a=r;a<=o;a+=h){for(a=_accuracy(a),l=0;u[l]>c[m]&&_accuracy(Math.floor(a/u[l])*u[l])!==a;l++);if(!1===n(e.relative2Value(a),a,m,l))break}function _accuracy(e){return Math.round(1e4*e)/1e4}},shmi.visuals.controls.TrendDisplay.onConfiguration.push((function _onConfigureScale(e,t,i){"use strict";var s,n,a,l,o;e&&(a=(n=(s=e.display=i.isObject(e.display)).units=i.isObject(s.units)).scale=i.isObject(n.scale),Array.isArray(a.availableSteps)||(a.availableSteps=[1,.5,.2,.1,.05,.02,.01,.005,.002,.001]),a.availableSteps=i.parseFilterAndSort(a.availableSteps,i.relative,!0),Array.isArray(a.availableMajorSteps)||(a.availableMajorSteps=[1,.5,.1,.05,.01,.005,.001]),a.availableMajorSteps=i.parseFilterAndSort(a.availableMajorSteps,i.relative,!0),l=parseInt(a.min),(isNaN(l)||l<1)&&(l=1),o=parseInt(a.max),(isNaN(o)||o<1)&&(o=10),a.min=Math.min(l,o),a.max=Math.max(l,o))})),shmi.visuals.controls.TrendDisplay.Timeline=function TrendDisplayTimeline(e,t){"use strict";shmi.visuals.controls.TrendDisplay.Timeline._super.call(this,e,t)},shmi.visuals.controls.TrendDisplay.Timeline.prototype={uiType:"trend-display-timeline",isContainer:!1,getClassName:function(){"use strict";return"TrendDisplayTimeline"},_initializeConfiguration:function(e){"use strict";return shmi.def(e,"class-name","trend-display-timeline"),shmi.def(e,"template","default/trend-display/component/timeline"),this._labels={},e},onDiscover:function(e){"use strict";this._super(this.TrendDisplayTimeline,"onDiscover",e),Object.defineProperty(this,"container",{value:shmi.getUiElement("timestamps-container",this.element)});var t=this,i=e.detail.trendDisplay,s=i.config,n=i.getComponents("trend-display-continuous")[0];n&&(Object.defineProperty(this,"continuous",{value:n}),n.isPrepared.then((function(e){e.onSlide.push([t._onSlide,t]),t.onBroadcast.push([50,t._onBroadcast,t]),t.isPrepared.resolve(t),s.invalid||t._updateElements(e)})))},onDelete:function(){this.onDeleteLabels(),this._super(this.TrendDisplayTimeline,"onDelete")},onDeleteLabels:function(){var e=this._labels;Object.keys(e).forEach((function(t){var i=e[t];i.parentNode.removeChild(i)})),this._labels={}},_onSlide:function(e,t){isNaN(this._offsetX)||(this.container.style.left=String(-this._offsetX+t)+"px")},_reconfigure:function(e){var t=this.trendDisplay.getComponents("trend-display-continuous")[0];t&&t.isPrepared.isResolved()&&(this.onDeleteLabels(),this._updateElements(t))},_onBroadcast:function(e){"use strict";switch(e.type){case"preparation-finished":case"render":e.detail.suppress||this._updateElements(this.continuous);break;case"configuration-changed":var t=e.detail.configuration;t.invalid||this._reconfigure(t)}},_updateElements:function(e){var t,i,s=this.trendDisplay.config,n=e.viewport,a=e.getDC(),l=e.renderer,o=l.controls,r=l.getCanvasSize(),c=this.container,u=c.ownerDocument,h=shmi.visuals.controls.TrendDisplay,m=shmi.getUiElement("trend-display-timeline"),d=r.totalWidth,f=n.minTime,v=n.rightRenderTime-f,g=s.display.units.timeLine,p=h.Timeline.detectVisibleUnit(g.available,n.visibleTimeSpan,g.min,g.max),b=this._labels;if(this._offsetX=r.x,p>0){c.style.left=String(-r.x)+"px",c.style.width=String(d)+"px";var y=m===c.parentNode.parentNode&&shmi.hasClass(m,"top-timeline")?"top":"bottom";o.applyButtonNavigateTimeline("left",c.parentNode,y,"after"),o.applyButtonNavigateTimeline("right",c.parentNode,y,"after"),this._generateTimelineScaling(e,c.parentNode,y);var E,C,T,x=0,w={},I=null;for(t=Math.floor((n.leftRenderTime-f)/p)*p;t<v;t+=p){T=b[t];var k=!0===s["rel-time"]?t:f+t,S=new Date(1e3*k),L=!!s["utc-time"]&&s["utc-time"],D=new Date(L?S.valueOf()+6e4*S.getTimezoneOffset():S);T?((i=a.time2X(f+t,0))!==parseFloat(T.style.left)&&(T.style.left=String(i)+"px"),b[t]=null):((T=u.createElement("label")).style.left=String(a.time2X(f+t,0))+"px",T.appendChild(u.createTextNode(shmi.requires("visuals.tools.date").formatDateTime(k,{datestring:s["time-format"]||"$HH:$mm:$ss",utc:L}))),c.appendChild(T)),m===c.parentNode.parentNode&&shmi.hasClass(m,"top-timeline")&&(0===D.getHours()&&0===D.getMinutes()&&0===D.getSeconds()?((I=u.createElement("span")).className="date",I.appendChild(u.createTextNode(shmi.requires("visuals.tools.date").formatDateTime(k,{datestring:s["date-format"],utc:L}))),T.appendChild(I)):0!==t&&0!==x&&x<Math.floor(t/86400)&&(D.setHours(0,0,0,0),w[E=parseInt(D.getTime()/1e3)+86400]||((C=u.createElement("label")).style.left=String(a.time2X(E,0))+"px",c.appendChild(C),(I=u.createElement("span")).className="date",I.appendChild(u.createTextNode(shmi.requires("visuals.tools.date").formatDateTime(E,{datestring:s["date-format"],utc:L}))),C.appendChild(I),w[E]=C))),w[t]=T,x=Math.floor(t/86400),this._labels=w}}else this._labels=[];Object.keys(b).forEach((function(e){var t=b[e];t&&c.removeChild(t)}))},_generateTimelineScaling:function(e,t,i){var s=e.viewport,n=e.renderer,a=e.getDC(),l=shmi.getUiElement("continuous-canvas",t.parentNode.parentNode),o="vertical-raster-"+i+"-canvas",r=t.querySelector("."+o),c="top"===i?t.parentNode.scrollHeight-1:0,u="top"===i?c-7:c+7;if(r){r.width=l.width;var h=r.getContext("2d");h.lineWidth=1,h.strokeStyle="rgba(255,255,255,1)",h.beginPath(),shmi.visuals.controls.TrendDisplay.CanvasBackground.getVerticalRasterTimestamps(n.config.display.units,s).forEach((function(e){var t=a.time2X(e,0);h.moveTo(t,c),h.lineTo(t,u)})),h.stroke()}else(r=document.createElement("canvas")).className="canvas "+o,r.height=t.parentNode.scrollHeight,t.appendChild(r)}},shmi.visuals.controls.TrendDisplay.derive(shmi.visuals.controls.TrendDisplay.Timeline,shmi.visuals.controls.TrendDisplay.Component,"TrendDisplayTimeline"),shmi.visuals.controls.TrendDisplay.Timeline.detectVisibleUnit=function(e,t,i,s){var n=e.map((function(e){var n=t/e;return n>=i&&n<=s?e:0})).filter((function(e){return e})).sort((function(e,t){return t-e}));if(0===n.length){var a=null;return e.forEach((function(e){if(null===a){var i=t/e;i<1&&(a=e),i>=1&&i<=s&&(a=e)}})),a}return n.length?n[Math.floor(n.length/2)]:e[0]},shmi.visuals.controls.TrendDisplay.Timeline.renderTime=function(e,t){if(!0!==t["rel-time"]){var i=t["time-format"]||"$YYYY-$MM-$DD $HH:$mm";return shmi.requires("visuals.tools.date").formatDateTime(e,{datestring:i,utc:t["utc-time"]})}var s=e,n={year:31536e3,month:2592e3,week:604800,day:86400,hour:3600,minute:60,second:1};Object.keys(n).forEach((function(e){var t=n[e];s>=t?(n[e]=Math.floor(s/t),s-=t*n[e]):n[e]=""}));var a=!0;return t["rel-time-format"]||"$Dd $HH:$MM:$SS".replace(/\$([YNWDHMS]{1,3})([^\s$]*)/g,(function(e,t,i){var s;switch(t[0]){case"Y":s=n.year;break;case"N":s=n.month;break;case"W":s=n.week;break;case"D":s=n.day;break;case"H":s=n.hour;break;case"M":s=n.minute;break;case"S":s=n.second;break;default:return t+i}if(a&&!s)return"";for(a=!1,s=String(s);s.length<t.length;)s="0"+s;return s+i})).trim()},shmi.visuals.controls.TrendDisplay.onConfiguration.push((function _onConfigureTimeLine(e,t,i){"use strict";var s,n,a,l,o;e&&(a=(n=(s=e.display=i.isObject(e.display)).units=i.isObject(s.units)).timeLine=i.isObject(n.timeLine),Array.isArray(a.available)||(a.available=[5,10,30,60,120,300,600,900,1800,3600,14400,21600,43200,86400,604800,2678400,31536e3]),a.available=i.parseFilterAndSort(a.available,i.timeSpanUnit),l=parseInt(a.min),(isNaN(l)||l<1)&&(l=1),o=parseInt(a.max),(isNaN(o)||o<1)&&(o=6),a.min=Math.min(l,o),a.max=Math.max(l,o))})),shmi.visuals.controls.TrendDisplay.CanvasProgramCurve=function CanvasProgramCurve(e,t,i,s){"use strict";shmi.visuals.controls.TrendDisplay.CanvasProgramCurve._super.call(this,e,i.getTrend().signal),Object.defineProperty(this,"program",{value:t}),Object.defineProperty(this,"programValue",{value:i}),Object.defineProperty(this,"waitStyle",{value:s})},shmi.visuals.controls.TrendDisplay.CanvasProgramCurve.prototype={_createPathElement:function(e){var t="path program "+(this.programValue.isCValue?"cv-":this.programValue.isDoValue?"do-":"sv-")+(this.signal.alias||this.signal.name),i=e.getElementsByClassName(t)[0];return i||((i=e.ownerDocument.createElement("path")).setAttribute("class",t),i=e.appendChild(i)),i},render:function(e,t,i){"use strict";var s,n=this.program,a=this,l=this.waitStyle.symbol;return n.steps.isResolved()?(s=[n.steps],l&&l.isResolved()&&s.push(l),shmi.visuals.controls.TrendDisplay.Promise.all(s).spread((function(t,s){var l=a.drawingContext,o=e.viewport,r=i.getContext("2d"),c=o.leftRenderTime,u=o.rightRenderTime,h=a.programValue,m=h.isCValue,d=h.isDoValue,f=m?"cvn":d?"ndo":"svn",v=h.index,g=h.style.symbol,p=[],b=NaN,y=NaN,E=shmi.requires("visuals.tools.item-adapter").getActiveAdapter(a.signal.alias||a.signal.name);!n.preview&&c<n.tStartReal&&(c=n.tStartReal);var C=t.asArray;!function calcLoops(){var e=[];C[0].loop&&(C.forEach((function(t,i){t.loop.count>0&&e.push({start:t.loop.t,end:i-1,loops:t.loop.count})})),C.forEach((function(t,i){t.loopInfo={loops:0,isEnd:!1,reps:0},e.forEach((function(e,s){i>=e.start&&i<=e.end&&(t.loopInfo.loops+=1,i===e.end&&(t.loopInfo.isEnd=!0,t.loopInfo.reps=e.loops))}))})))}(),h.style.applyOnCanvas(r),r.beginPath(),t.asArray.some((function(e,t,i){if(t>=i.length-1)return!1;var a,o,h,C,T,x,w,I,k=e[f][v];if(E&&(k=E.outFunction(k)),o=e.tStartReal,(h=e.tEndReal)<(a=isNaN(y)?o:y)&&(h=a),(h<u?h:u)>=(a>c?a:c)){C=l.time2X(o,0),x=l.value2Y(k,0),isNaN(y)?C:l.time2X(y,0),(I=0!==e.waitForCVIndex.icv&&e.waitForCVIndex.icv===v+1&&m)&&e.tStart>=n.time&&s&&r.drawImage(s,C-30,x-shmi.visuals.controls.TrendDisplay.iconDimensions.height/2);var S=i[t+1][f][v];if(E&&(S=E.outFunction(S)),d&&e.tStart>=n.time&&b!==k){var L=l.time2X(y,0),D=l.value2Y(b,0);r.moveTo(L,D),r.lineTo(C,x),g&&p.push({x:C,y:x})}T=l.time2X(h,0),w=d?l.value2Y(k,0):l.value2Y(S,0),e.tStart>=n.time&&(r.moveTo(C,x),r.lineTo(T,w),g&&(p.length&&!I||p.push({x:C,y:x}),p.push({x:T,y:w})))}return b=k,y=h,o>=u})),r.stroke(),C[0].loop&&(r.save(),r.strokeStyle="#9ba302",r.fillStyle="#9ba302",r.lineWidth=3,b=NaN,y=NaN,t.asArray.some((function(e,t){if(t>=C.length-1)return!1;var i,s,a,o,h,m=e[f][v];if(E&&(m=E.outFunction(m)),s=e.tStartReal,(a=e.tEndReal)<(i=isNaN(y)?s:y)&&(a=i),(a<u?a:u)>=(i>c?i:c)&&(o=l.time2X(s,0),isNaN(y)?o:l.time2X(y,0),h=l.time2X(a,0),e.tStart>=n.time&&e.loopInfo)){for(var d=0,g=0;d<e.loopInfo.loops;)r.beginPath(),r.moveTo(o,l.manager._offsetY+6+30*d),r.lineTo(h,l.manager._offsetY+6+30*d),r.stroke(),d+=1;e.loopInfo.isEnd&&(e.loopInfo.reps>=10&&(g+=8),e.loopInfo.reps>=100&&(g+=8),d-=1,r.fillRect(h-(25+g),l.manager._offsetY+30*d+7,25+g,25),r.font="14px sans-serif",r.save(),r.fillStyle="#FFFFFF",r.fillText(e.loopInfo.reps,h-(17+g),l.manager._offsetY+30*d+23),r.restore())}return b=m,y=a,s>=u})),r.restore()),g&&g.then((function(e){p.forEach((function(t){isFinite(t.y)&&r.drawImage(e,t.x-shmi.visuals.controls.TrendDisplay.iconDimensions.width/2,t.y-shmi.visuals.controls.TrendDisplay.iconDimensions.height/2)}))}))}))):null}},shmi.visuals.controls.TrendDisplay.derive(shmi.visuals.controls.TrendDisplay.CanvasProgramCurve,shmi.visuals.controls.TrendDisplay.CanvasCurve,"CanvasProgramCurve"),shmi.visuals.controls.TrendDisplay.ProgramManager=function TrendDisplayProgramManager(e,t){"use strict";shmi.visuals.controls.TrendDisplay.ProgramManager._super.call(this,e,t);var i=null,s=null,n=null,a=null,l=null,o=null;Object.defineProperty(this,"disabled",{get:function(){return!!o},set:function(t){(t=!!t)!==o&&(t?shmi.addClass(e,"disabled"):shmi.removeClass(e,"disabled"),o=t)}}),Object.defineProperty(this,"viewport",{get:function(){return!i&&this.continuous&&(i=this.continuous.viewport),i},set:function(){i=null}}),Object.defineProperty(this,"trends",{get:function(){return!s&&this.continuous&&(s=this.continuous.curves),s},set:function(){s=null}}),Object.defineProperty(this,"timeline",{get:function(){return n&&n.onDelete(),n=null,n=this._generateTimeLine()},set:function(){n&&n.onDelete(),n=null}}),Object.defineProperty(this,"program",{get:function(){return a||o||(a=this._generateProgram()),a},set:function(){a&&a.onDelete(),a=null}}),Object.defineProperty(this,"curves",{get:function(){return l||(l=this._generateProgramValues()),l},set:function(){if(l){var e=(this.continuous||{}).renderer;l.forEach((function(t){e&&e.onRender.removeListener([t.render,t]),t.onDelete()}))}l=null}})},shmi.visuals.controls.TrendDisplay.ProgramManager.prototype={uiType:"trend-display-program",isContainer:!1,getClassName:function(){"use strict";return"TrendDisplayProgramManager"},_initializeConfiguration:function(e){"use strict";return shmi.def(e,"class-name","trend-display-program"),shmi.def(e,"template","default/trend-display/component/program"),e},onDiscover:function(e){"use strict";this._super(this.TrendDisplayProgramManager,"onDiscover",e);var t=this,i=e.detail.trendDisplay,s=i.getComponents("trend-display-continuous")[0],n=null,a={color:"#C8C8C8",width:1,label:"label"};s&&(Object.defineProperty(t,"continuous",{value:s}),Object.defineProperty(t,"container",{value:shmi.getUiElement("program-timeline-container",t.element)}),Object.defineProperty(t,"canvas",{value:shmi.getUiElement("program-timeline",t.container||t.element)}),Object.defineProperty(t,"waitStub",{value:shmi.getUiElement("program-wait",t.element)}),Object.defineProperty(t,"waitStyle",{get:function(){return n},set:function(e){e&&(n=e.styleManagers.waitStyle)&&(n.symbol="pics/system/icon_196.png")}}),Object.defineProperty(t,"inactiveStyle",{get:function(){return a},set:function(e){e&&(a=e.styleManagers.inactiveStyle)}}),s.isPrepared.then((function(e){return e.onSlide.push([t._onSlide,t]),e.onState.push([t._onContinuousState,t]),t.onBroadcast.push([t._onBroadcast,t]),t._configure(i.config).then((function(){t.isPrepared.resolve(t),t.trendDisplay.isPreparing=!1}))})))},onDelete:function(){var e=this.continuous;e&&e.onSlide&&e.onSlide.removeListener([this._onSlide,this]),e&&e.onState&&e.onState.removeListener([this._onContinuousState,this]),this.onBroadcast&&"function"==typeof this.onBroadcast.removeListener&&this.onBroadcast.removeListener([this._onBroadcast,this])},_configure:function(e){var t=this;return this.isPrepared.isResolved()&&e.invalid?shmi.visuals.controls.TrendDisplay.Promise.resolve():(this.disabled=e.invalid||!e.program,this.viewport=null,this.trends=null,this.timeline=null,this.program=null,this.curves=null,this.waitStyle=null,this.controls=null,this.disabled?shmi.visuals.controls.TrendDisplay.Promise.resolve():(this.waitStyle=e,this.timeline,this.curves,this.controls,this.program.steps.then((function(){return t.onResize()}))))},_generateTimeLine:function(){return new shmi.visuals.controls.TrendDisplay.ProgramTimeLine(this.container,this.continuous,this.program)},_generateProgram:function(){var e=new shmi.visuals.controls.TrendDisplay.Program(this,this.trendDisplay.config,this.continuous);return e.updateMaxTime(this.continuous.viewport),e},_generateProgramValues:function(){var e=this,t=(this.continuous||{}).renderer,i=t.elementClass,s=shmi.visuals.controls.TrendDisplay.CanvasProgramCurve;if(t){if(Object.create(s.prototype)instanceof i){var n=this.program;return[].concat(n.cvs.map(_create),n.svs.map(_create),n.dos.map(_create)).map((function(e){return t.onRender.push([e.render,e]),e}))}shmi.log("[ProgramManager]: curve renderers not suitable for selected canvas of Continuous")}return null;function _create(i){return new s(t,n,i,e.waitStyle)}},onResize:function(){var e=this.timeline;e&&e.onResize()},_onSlide:function(){if(!this.disabled){var e=this.timeline;if(e)return e.onSlide.apply(e,arguments)}return null},_onContinuousState:function(e,t){var i=t.viewport;switch(t.mode){case"live":return!!this.disabled||(i.leftTime=i.maxSampleTime-i.visibleTimeSpan/2,!1);case"handleTime":return!!this.disabled||(i.handleTime=i.maxSampleTime,!1);default:return!0}},_onBroadcast:function(e){var t,i;switch(e.type){case"preparation-finished":case"render":e.detail.suppress||this.disabled||this.timeline.render();break;case"resize":this.disabled||this.onResize();break;case"configuration-changed":t=this.trendDisplay,i=e.detail.configuration,t.isPreparing="reconfigure-program-manager",this._configure(i).then((function(){t.isPreparing=!1,i.program&&(t.isPreparing=!1)}))}}},shmi.visuals.controls.TrendDisplay.derive(shmi.visuals.controls.TrendDisplay.ProgramManager,shmi.visuals.controls.TrendDisplay.Component,"TrendDisplayProgramManager"),shmi.visuals.controls.TrendDisplay.onConfiguration.push((function _onConfigureProgramManager(e,t){})),shmi.visuals.controls.TrendDisplay.Program=function Program(e,t,i){"use strict";var s=null,n=null,a=null,l=null,o=[],r=[],c=[];this._compileItems(t,i,o,r,c),Object.defineProperty(this,"manager",{value:e}),Object.defineProperty(this,"continuous",{value:i}),Object.defineProperty(this,"code",{get:function(){return s||(s=this._getOnConfiguration(t)),s},set:function(){s=null}}),Object.defineProperty(this,"index",{value:t.program.index}),Object.defineProperty(this,"preview",{value:t.program.preview}),Object.defineProperty(this,"tStart",{value:t.program.tStart}),Object.defineProperty(this,"tStartProgram",{value:this.time}),Object.defineProperty(this,"tStartReal",{value:shmi.getServerTime()}),Object.defineProperty(this,"time",{get:function(){return this.preview?0:(a||(a=this._bindProgramTimer(t)),a.value)},set:function(){a&&(this._unbindProgramTimer(a),a=null)}}),Object.defineProperty(this,"cvs",{value:o}),Object.defineProperty(this,"svs",{value:r}),Object.defineProperty(this,"dos",{value:c}),Object.defineProperty(this,"waiting",{get:function(){return!!l},set:function(e){if(Boolean(e)!==Boolean(l))if(e){var t=this;l=!0===t.preview?0:window.setInterval((function(){t._whileWaiting()}),1100)}else window.clearInterval(l),l=null}}),Object.defineProperty(this,"steps",{get:function(){return n||(n=this.code.then((function(e){return e.step}))),n}})},shmi.visuals.controls.TrendDisplay.Program.prototype={_compileItems:function(e,t,i,s,n){e.program.items.forEach((function(a){var l,o="CV"===a.valueType,r="DO"===a.valueType,c=o?i:r?n:s;c.push({alias:a.alias,name:a.name,index:c.length,trendIndex:a.trendIndex,valueIndex:a.valueIndex,styleIndex:a.styleIndex,style:e.styleManagers[a.styleIndex]||null,getTrend:(l=a.trendIndex,function(){return t.curves[l]}),isCValue:o,isDoValue:r})}))},_normalizeRealTime:function(e){var t=this.tStartReal;return isNaN(e)&&(e=shmi.getServerTime()),t+Math.round(e-t)},_getOnConfiguration:function(e){var t=this,i=this.cvs.map(_extractIndex),s=this.svs.map(_extractIndex),n=this.dos.map(_extractIndex);return new shmi.visuals.controls.TrendDisplay.Promise((function(a,l){shmi.visuals.controls.TrendDisplay.Program.api.getProgram(e.program.index,i,s,n,(function(i,s){if(i)l("error #"+i+" on fetching program #"+e.program.index);else{var n=s.len,o=null;s.step=new ProgramSteps(s.step.reverse().map((function(e){return e.length=n-e.t,n=e.t,e})).reverse().map((function(e){return o=new ProgramStep(e.cvn,e.svn,e.ndo,e["#"],e.t,e.length,e.w,o,e.loop)}))),t._updateMaxTime(t.continuous.viewport,s.step),t.preview&&(t.waiting=!0),a(s)}}))}));function _extractIndex(e){return e.valueIndex}function ProgramStep(e,i,s,n,a,l,o,r,c){var u=null;this.next=null,this.offsetTime=0,this.waitTime=0,r&&(r.next=this),Object.defineProperties(this,{cvn:{value:e},svn:{value:i},ndo:{value:s},label:{value:n},tStart:{value:a},tStartReal:{get:function(){var e,i,s,n,a;if(null!==u)return u;if(r)return r.hasTStartReal&&this.tStart>t.time&&t.waiting?(e=t.time-r.tStart,i=r.tStartReal+e,(s=shmi.getServerTime()-i)<0&&(s=0),n=r.length-e,a=shmi.getServerTime()+n,r.offsetTime=s,t._normalizeRealTime(a)):r.hasTStartReal&&this.tStart===t.time&&t.waiting?(e=t.time-r.tStart,i=r.tStartReal+e,(s=shmi.getServerTime()-i)<0&&(s=0),n=r.length-e,a=shmi.getServerTime()+n,this.waitTime=s,t._normalizeRealTime(a)):r.hasTStartReal&&this.tStart>=t.time?(e=t.time-r.tStart,i=r.tStartReal+e,(s=shmi.getServerTime()-i)<0&&(s=0),n=r.length-e,a=shmi.getServerTime()+n,r.offsetTime=s,t._normalizeRealTime(a)):r.tEndReal+this.waitTime;if(t.preview)return t.tStartReal;var l=t.tStartProgram;return void 0===l?shmi.getServerTime():t._normalizeRealTime(shmi.getServerTime()-(this.tStart-l))},set:function(e){null!==u&&null!==e||(u=e)}},tEndReal:{get:function(){return this.tStartReal+this.length+this.offsetTime}},hasTStartReal:{get:function(){return null!==u}},previous:{value:r||null},length:{value:l},waitForCVIndex:{value:o},waitingTime:{value:function(){if(!r)return 0;var e=this.tStartReal-r.tEndReal;return e<0?0:e}},loop:{value:c||null}})}function ProgramSteps(e){var i=this,s=-1,n=null;Object.defineProperties(this,{asArray:{value:e},current:{value:function(t){var s=i.currentIndex(t);return s>=0?e[s]:null}},currentIndex:{value:function(i){if(isNaN(i)&&(i=t.time),i!==n||s<0){var a,l,o;for(a=Math.max(0,s),l=e.length;a<l;a++){if((o=e[a]).tStart<i)if(o.hasTStartReal){if(n&&n>i){e.forEach((function(e,t){e.tStartReal=null,e.waitTime=0,e.offsetTime=0})),s=-1;break}}else o.tStartReal=t._normalizeRealTime()-(i-o.tStart),console.debug("fixing real start time of step #"+a+" at "+o.tStartReal);else if(n&&n>i){e.forEach((function(e,t){e.tStartReal=null,e.waitTime=0,e.offsetTime=0})),s=-1;break}if(o.tStart>i)break;s=a}n=i}return s}},first:{value:e[0]},last:{value:e[e.length-1]}})}},_bindProgramTimer:function(e){var t=this,i={name:e.program.time,id:0,value:-1,timer:0,setValue:function(e){var s=parseFloat(e)||0;s!==i.value&&(i.timer&&(clearTimeout(i.timer),i.timer=null),i.value=s,t.waiting=!1,t.steps.isSettled()&&t.steps.then((function(e){e.current(s)})),t.preview||(i.timer=setTimeout((function(){t.waiting=!0}),2e3)))},lock:shmi.visuals.controls.TrendDisplay.nop,unlock:shmi.visuals.controls.TrendDisplay.nop,setProperties:shmi.visuals.controls.TrendDisplay.nop};return i.id=shmi.visuals.session.ItemManager.subscribeItem(i.name,i),i},_unbindProgramTimer:function(e){e.timer&&(clearTimeout(e.timer),e.timer=null),shmi.visuals.session.ItemManager.unsubscribeItem(e.name,e.id)},_whileWaiting:function(){var e=this,t=this.continuous.viewport;this.updateMaxTime(t).then((function(i){!t.isLive&&!t.transaction&&i<t.rightRenderTime&&e.manager.broadcast("render")}))},_updateMaxTime:function(e,t){return e.programEndTime=t.last.tEndReal,null===t.current()?null:t.current().tStartReal},updateMaxTime:function(e){var t=this;return this.steps.then((function(i){return t._updateMaxTime(e,i)}))},onDelete:function(){this.code=null,this.time=null,this.waiting=!1}},shmi.visuals.controls.TrendDisplay.onConfiguration.push([-10,function _parseProgramConfiguration(e,t,i){"use strict";if(e&&"object"==typeof e&&e.program&&"object"==typeof e.program){t.isPreparing="processing-program-manager-configuration";var s=!!e.program.preview,n=parseInt(e.program.index);n<0&&shmi.log("TrendDisplay.onConfiguration() invalid program index",3);var a=i.timestamp(e.program.tStart);null===a&&shmi.log("TrendDisplay.onConfiguration() invalid tStart in configuration of program",3);var l=String(e.program.time||"").trim();l.length||shmi.log("TrendDisplay.onConfiguration() missing name of program timer item",3);var o,r=e.program.items;Array.isArray(r)&&r.length||shmi.log("TrendDisplay.onConfiguration() invalid/missing program items configuration",3),shmi.objectHasOwnProperty(e.program,"waitStyleIndex")?((o=parseInt(e.program.waitStyleIndex))<0||o>=e.styles.length)&&shmi.log("TrendDisplay.onConfiguration() invalid index of wait state indicator style",3):o=-1,e.program={index:n,preview:s,tStart:a,time:l,items:r.map((function(t,i){t&&"object"==typeof t||shmi.log("TrendDisplay.onConfiguration() invalid/missing program item configuration @"+i,3);var s={};switch(s.valueType=String(t.valueType||"").toUpperCase(),s.valueType){case"CV":case"SV":case"DO":break;default:shmi.log("TrendDisplay.onConfiguration() invalid valueType of program value on program item @"+i,3)}return s.valueIndex=parseInt(t.valueIndex),(isNaN(s.valueIndex)||s.valueIndex<0)&&shmi.log("TrendDisplay.onConfiguration() invalid valueIndex of program value on program item @"+i,3),s.trendIndex=parseInt(t.trendIndex),(isNaN(s.trendIndex)||s.trendIndex<0||s.trendIndex>=e.trend.items.length)&&shmi.log("TrendDisplay.onConfiguration() invalid trendIndex of trend item on program item @"+i,3),shmi.objectHasOwnProperty(t,"styleIndex")?(s.styleIndex=parseInt(t.styleIndex),(isNaN(s.styleIndex)||s.styleIndex<0||s.styleIndex>=e.styles.length)&&shmi.log("TrendDisplay.onConfiguration() invalid styleIndex on program item @"+i,3),s.style=e.styleManagers[s.styleIndex]):s.style=shmi.visuals.controls.TrendDisplay.Style.defaultStyle,s})),waitStyleIndex:o};var c=shmi.visuals.controls.TrendDisplay.Program;c.api||(c.api=shmi.requires("visuals.custom.wut.pgm"))}}]),shmi.visuals.controls.TrendDisplay.Program.api=null,shmi.visuals.controls.TrendDisplay.ProgramTimeLine=function(e,t,i){"use strict";e.innerHTML="",Object.defineProperty(this,"container",{value:e}),Object.defineProperty(this,"continuous",{value:t}),Object.defineProperty(this,"program",{value:i})},shmi.visuals.controls.TrendDisplay.ProgramTimeLine.prototype={_resetLocation:function(e){var t=this.container.style;this._offsetX=e.x,t.left=String(-e.x)+"px",t.width=String(e.totalWidth)+"px"},render:function(){"use strict";var e=this;return this.container?this.program.steps.then((function(t){var i=e.continuous,s=i.viewport,n=i.getDC(),a=i.renderer.getCanvasSize(),l=e.container,o=e.program,r=o.preview,c=l.ownerDocument,u=s.leftRenderTime,h=s.rightRenderTime,m=e._labels||{},d={};e._resetLocation(a),!r&&u<o.tStartReal&&(u=o.tStartReal),t.asArray.some((function(e,t){var i,s,a,u,m;return a=e.previous?e.previous.tEndReal:e.tStartReal,u=e.tEndReal,e.next,!(e.tStart<o.time)&&((r||u>o.tStartReal)&&u>a&&(i=n.time2X(a,0),s=n.time2X(u,0),(m=c.createElement("label")).appendChild(c.createTextNode(e.label)),(m=l.appendChild(m)).style.left=i+"px",m.style.width=Math.round(s-i)+"px",d[t]=m),a>h)})),Object.keys(m).forEach((function(e){var t=m[e];t&&t.parentNode.removeChild(t)})),e._labels=d})):null},onSlide:function(e,t){isNaN(this._offsetX)||(this.container.style.left=String(-this._offsetX+t)+"px")},onResize:function(){},onDelete:function(){"use strict";var e=this._labels;Object.keys(e||{}).forEach((function(t){var i=e[t];i.parentNode.removeChild(i)}))}},shmi.visuals.controls.TrendDisplay.derive(shmi.visuals.controls.TrendDisplay.ProgramTimeLine,shmi.visuals.controls.TrendDisplay.AbstractRenderer,"ProgramTimeLine"),shmi.visuals.controls.TrendDisplay.Configuration=function(e){"use strict";var t=!1;Object.defineProperties(this,{trendDisplay:{value:e},isConfigured:{get:function(){return t},set:function(){t=!0}}})},shmi.visuals.controls.TrendDisplay.Configuration.prototype={validate:function(e){"use strict";var t=e||{},i=this.trendDisplay,s=shmi.visuals.controls.TrendDisplay;return Array.isArray(s.onConfiguration)&&(s.onConfiguration=s.Messaging.wrap(s.onConfiguration)),s.onConfiguration.send(t,i,s.Parsers).return(t)},_notifyChange:function(e,t,i){this.trendDisplay.broadcast(this,"configuration-changed",{name:t,newValue:e,oldValue:i,configuration:this})},read:function(){return shmi.visuals.controls.TrendDisplay.Object.deepCopy(this)},update:function(e,t){"use strict";var i=this,s=this.trendDisplay,n=shmi.visuals.controls.TrendDisplay;return(e=shmi.visuals.controls.TrendDisplay.Object.deepCopy(e)).invalid=!1,e.noRecal=t||!1,this.validate(e).catch((function(t){if(e.invalid=!0,i.isConfigured){var s=String(t.message||t||"");shmi.log(s.trim(),3),shmi.log("TrendDisplay.Configuration.update() invalid configuration rejected",3)}return e})).then((function(e){var t=Object.isSealed(i);return t&&(i=new n.Configuration(s)),n.Object.injectObserved(i,e,n.fastBind(i._notifyChange,i),!0,["invalid"]),i.isConfigured=!0,t&&i._notifyChange(null,null,null),i}))}},shmi.visuals.controls.TrendDisplay.Data=function(e){"use strict";var t=shmi.visuals.session.TrendManager,i=null;Object.defineProperty(this,"manager",{value:t}),Object.defineProperty(this,"instance",{get:function(){return e}}),Object.defineProperty(this,"trends",{get:function(){return i||(i=new shmi.visuals.controls.TrendDisplay.Promise((function(e){t.getTrendList((function(t){e(t)}))}))),i}})},shmi.visuals.controls.TrendDisplay.Data.prototype={_cache:{},getTrendByName:function(e){"use strict";return new shmi.visuals.controls.TrendDisplay.Trend(this.manager,e,this.instance)}},shmi.visuals.controls.TrendDisplay.onConfiguration.push([100,function parseDataConfiguration(e,t){"use strict";if(!e||"object"!=typeof e)return null;if(!e.trend||"object"!=typeof e.trend)throw new TypeError("invalid/missing trend configuration");var i=String(e.trend.name||"").trim();i||shmi.log("TrendDisplay.onConfiguration() missing name of trend to show",3);var s=e.trend.aggregate;s&&"object"==typeof s||shmi.log("TrendDisplay.onConfiguration() missing configuration on aggregation",3);var n=shmi.visuals.controls.TrendDisplay.Parsers,a=n.aggregation(s.method||"",1),l=n.timeSpanUnit(s.unit||"",0);null===a&&shmi.log("TrendDisplay.onConfiguration() invalid aggregation method: "+s.method,3),null===l&&shmi.log("TrendDisplay.onConfiguration() invalid aggregation unit: "+s.unit,3);var o=e.trend.items;return o&&o.length||shmi.log("TrendDisplay.onConfiguration() missing configuration on items",2),e.trend.aggregate={method:a,unit:l},t.data.trends.then((function(t){t.indexOf(i)<0&&shmi.log("TrendDisplay.onConfiguration() selected trend is not available",3),e.trend.name=i}))}]),shmi.visuals.controls.TrendDisplay.Signal=function(e){"use strict";shmi.visuals.controls.TrendDisplay.Object.injectFrozen(this,e,!0)},shmi.visuals.controls.TrendDisplay.Signal.prototype={dontObserve:!0},shmi.visuals.controls.TrendDisplay.Style=function Style(){var e=null,t=null,i=null,s=null,n=null,a=null;function _setColor(t){var i=shmi.visuals.controls.TrendDisplay.Parsers.color(t);i?e=i:shmi.log("TrendDisplay.Style() invalid color: "+t,3)}Object.defineProperties(this,{black:{value:{red:0,green:0,blue:0,opacity:1,hasAlpha:!1,rgba:"rgba(0,0,0,1)",hex:"#000000",hexa:"#000000FF"}},color:{get:function(){return e||this.black},set:_setColor},colour:{get:function(){return e||this.black},set:_setColor},width:{get:function(){return t||1},set:function(e){var i=parseInt(e);i>0?t=i:e&&shmi.log("TrendDisplay.Style() invalid stroke width: "+e,1)}},dash:{get:function(){return i||[]},set:function(e){var t=shmi.visuals.controls.TrendDisplay.Parsers.dash(e);null!==t?i=t:e.length&&shmi.log("TrendDisplay.Style() invalid dash: "+e,1)}},offset:{get:function(){return s||0},set:function(e){var t=shmi.visuals.controls.TrendDisplay.Parsers.positive(e);null!==t?s=t:""!==e&&shmi.log("TrendDisplay.Style() invalid offset: "+e,1)}},opacity:{get:function(){return e&&e.hasAlpha?e.alpha:null===n?1:n},set:function(t){var i=shmi.visuals.controls.TrendDisplay.Parsers.relative(t);null!==i?(e&&(e.alpha=i,e=shmi.visuals.controls.TrendDisplay.Parsers.color(e)),n=i):shmi.log("TrendDisplay.Style() invalid opacity: "+t,1)}},symbol:{get:function(){return a},set:function(e){var t,i=shmi.visuals.controls.TrendDisplay;if(e instanceof i.Promise)a=e;else if(null!==(t=i.Parsers.url(e))){a=new i.Promise;var s=new Image;s.onload=function(){a.resolve(s)},s.onerror=function(){a.reject("loading image "+t+" failed")},s.src=t}else shmi.log("TrendDisplay.Style() invalid symbol URL: "+e,3)}},raw:{get:function(){var l={};return null!==e&&(l.color=e),null!==t&&(l.width=t),null!==n&&(l.opacity=n),null!==i&&(l.dash=i),null!==s&&(l.offset=s),null!==a&&(l.symbol=a),l}}})},shmi.visuals.controls.TrendDisplay.Style.prototype={dontObserve:!0,getQualifiedByCss:function(e){var t,i,s=this._cssParserDefs,n=shmi.visuals.controls.TrendDisplay.Parsers;return t=new shmi.visuals.controls.TrendDisplay.Style,i=this.raw,Object.keys(i).forEach((function(e){t[e]=i[e]})),Object.keys(s).forEach((function(a){shmi.objectHasOwnProperty(i,a)||s[a].some((function(i){var s=n.none(e[i]);if(null!==s)try{return t[a]=s,!0}catch(e){return!1}return!1}))})),t},_cssParserDefs:{color:["stroke","color"],width:["stroke-width"],opacity:["stroke-opacity","opacity"],dash:["stroke-dasharray"],offset:["stroke-dashoffset"],symbol:["background-image"]},applyOnCanvas:function(e){e.strokeStyle=this.color.rgba,e.lineWidth=this.width,"function"==typeof e.setLineDash&&(e.setLineDash(this.dash),e.lineDashOffset=this.offset)},applyOnSvg:function(e){e.style.stroke=this.color.rgba,e.style["stroke-width"]=this.width,e.style["stroke-dasharray"]=this.dash.join(","),e.style["stroke-dashoffset"]=this.offset},applyOnElement:function(e){e.style.color=this.color.rgba},copy:function(){var e=new shmi.visuals.controls.TrendDisplay.Style,t=this.raw;return Object.keys(t).forEach((function(i){e[i]=t[i]})),e}},shmi.visuals.controls.TrendDisplay.Style.defaultStyle=new shmi.visuals.controls.TrendDisplay.Style,shmi.visuals.controls.TrendDisplay.Style.getOnElement=function(e){var t=shmi.visuals.controls.TrendDisplay.Style.defaultStyle;return e?t.getQualifiedByCss(window.getComputedStyle(e,null)):t},shmi.visuals.controls.TrendDisplay.onConfiguration.push([50,function _parseStyleConfiguration(e,t){if(e&&"object"==typeof e){Array.isArray(e.styles)||shmi.log("TrendDisplay.onConfiguration() invalid/missing style set",3);var i=shmi.visuals.controls.TrendDisplay.Style;e.styleManagers=e.styles.map((function(e,t){try{return styleParser(e)}catch(e){return shmi.log("TrendDisplay.onConfiguration() ignoring style due to invalid property @"+t+": "+e.message,1),i.defaultStyle}})),e.styleManagers.waitStyle=styleParser({color:"#000000",symbol:"pics/system/icon_196.png"}),e.styleManagers.inactiveStyle=e.inactiveStyle}function styleParser(e){var t=new i;return["color","colour","width","dash","opacity","symbol"].forEach((function(i){shmi.objectHasOwnProperty(e,i)&&(t[i]=e[i])})),t}}]),shmi.visuals.controls.TrendDisplay.Trend=function Trend(e,t,i){"use strict";this.active=!0,this.trendDisplay=i;var s=new shmi.visuals.controls.TrendDisplay.Messaging,n=new shmi.visuals.controls.TrendDisplay.Messaging,a=new shmi.visuals.controls.TrendDisplay.Messaging,l=new shmi.visuals.controls.TrendDisplay.Promise,o=null,r=null,c=!1,u=0,h=1,m=null,d=null,f=!1,v=[];Object.defineProperty(this,"info",{get:function(){var i=shmi.visuals.controls.TrendDisplay.Promise;return i.first(i.delay((function(){shmi.log("TrendDisplay.Trend() timeout on gathering information on trend: "+t,3)}),shmi.c("TREND_DISPLAY_TRENDINFO_TIMEOUT")),new i((function(i){var s=[];v.forEach((function(e){s.push(e.alias)})),e.getTrendInfo(t,(function(e){i(e)}),s)})))}}),Object.defineProperty(this,"manager",{value:e}),Object.defineProperty(this,"name",{value:t}),Object.defineProperty(this,"startTime",{get:function(){return o||0},set:function(e){var t=Number(e);t>0&&t!==o&&(o=t,f=!1,s.send(this))}}),Object.defineProperty(this,"endTime",{get:function(){return r||shmi.getServerTime()},set:function(e){var t=Number(e);t>-2&&t!==r&&((c=-1===(r=t))&&(r=0),f=!1,s.send(this))}}),Object.defineProperty(this,"aggregate",{get:function(){return h},set:function(e){var t=shmi.visuals.controls.TrendDisplay.Parsers.aggregation(e,1,null);null!==t&&((h=t)&&!u&&(u=1),f=!1,s.send(this))}}),Object.defineProperty(this,"unit",{get:function(){return u},set:function(e){var t=shmi.visuals.controls.TrendDisplay.Parsers.timeSpanUnit(e,0,null);null!==t&&(u=t,h&&!u&&(u=1),f=!1,s.send(this))}}),Object.defineProperty(this,"items",{get:function(){return v},set:function(e){v=e,f=!1,s.send(this)}}),Object.defineProperty(this,"isLive",{get:function(){return c}}),Object.defineProperty(this,"isPristine",{get:function(){return f}}),Object.defineProperty(this,"data",{get:function(){return d||{startTime:1,endTime:2,values:[]}}}),Object.defineProperty(this,"gotData",{value:l}),Object.defineProperty(this,"running",{get:function(){return null!==m},set:function(t){var i=null!==m,a=this;if(!!t!==i){if(i)shmi.log("TrendDisplay: closing trend "+a.name,0),e.closeTrend(a.name,m),m=null;else if(null!==o){var g=!0;shmi.log("TrendDisplay: opening trend "+a.name+": ["+o+","+(c?-1:r)+"] "+h+" "+u+" "+v,0);var p=!0;shmi.fire("trend-display.state",{loading:!0},a),o=10*Math.floor(o/10),v.length>0&&(m=e.openTrend(a.name,o,c?-1:r,(function(e,t){p&&(p=!1,shmi.fire("trend-display.state",{loading:!1},a)),a.active?(d=a._collectData.call(a,g?null:d,e,t),g=!1,c||(m=null),f=!0,n.send(a).then((function(){l.resolve()}))):console.debug("trend-display not running, cancel callback")}),u,h,v))}f=!1,s.send(a)}}}),Object.defineProperty(this,"onUpdate",{value:s}),Object.defineProperty(this,"onData",{value:n}),Object.defineProperty(this,"onError",{value:a})},shmi.visuals.controls.TrendDisplay.Trend.prototype={_collectData:function(e,t,i){"use strict";var s,n,a,l;return t?s=new Error("TrendDisplay.Trend._collectData() error status #"+t+" on retrieving trend data"):i&&Array.isArray(i.data)?i.name!==this.name&&(s=new TypeError("TrendDisplay.Trend._collectData() got foreign trend data, wanted: "+this.name+", got: "+i.name)):s=new TypeError("TrendDisplay.Trend._collectData() invalid or missing trend data"),s?(shmi.log(s.message,3),this.onError.send(s,t)):(e&&this.isLive||(e={}),n=Number(e.startTime)||shmi.getServerTime(),a=Number(e.endTime)||0,(l=e.values||[])&&(e.values=l.concat(i.data.map((function(e){var t=Number(e.timestamp);return t&&isFinite(t)?(t<n&&(n=t),t>a&&(a=t),[t,e.values,0===parseInt(e.id)]):(console.error("TrendDisplay: got trend data lacking valid timestamp",2),null)})).filter((function(e){return e}))).sort((function(e,t){return e[0]-t[0]}))),e.startTime=n,e.endTime=n>a?n:a),e}},shmi.visuals.controls.TrendDisplay.onConfiguration.push([20,function _parseTrendConfiguration(e,t){"use strict";if(!e&&"object"!=typeof e)return null;Array.isArray(e.trend.items)&&e.trend.items||shmi.log("TrendDisplay.onConfiguration() missing trend items in configuration",3);var i,s,n,a=e.trend.name,l=e.display.type&&("multilane"===e.display.type.toLowerCase()||"multi"===e.display.type.toLowerCase()),o=[];if(!e.trend.items.length)return null;var r=localStorage.itemStyles?JSON.parse(localStorage.itemStyles):[],c=null;e.trend.items.forEach((function(t){e.display.highlightSignal===t.signalIndex&&(c=e.display.highlightSignal)})),null===c&&delete e.display.highlightSignal,i=e.trend.items.map((function(t,i){t&&"object"==typeof t||shmi.log("TrendDisplay.onConfiguration() invalid/missing configuration of trend item @"+i,3);var a={};return shmi.objectHasOwnProperty(t,"styleIndex")?(a.styleIndex=parseInt(t.styleIndex),(isNaN(a.styleIndex)||a.styleIndex<0||a.styleIndex>=e.styles.length)&&shmi.log("TrendDisplay.onConfiguration() invalid/missing styleIndex on trend item @"+i,3),a.style=e.styleManagers[a.styleIndex],s=e.styleManagers.inactiveStyle.color,l&&(n=e.styles[t.styleIndex],void 0!==o[t.laneIndex]?r.length&&void 0!==r[t.signalIndex]&&null!==r[t.signalIndex]?a.style.color=s:(n.color!==s&&(r[t.signalIndex]=n.color),null===r[t.signalIndex]?a.style.color=n.color:a.style.color=s):null===r[t.signalIndex]||void 0===r[t.signalIndex]?(a.style.color=n.color,o[t.laneIndex]=[],o[t.laneIndex].push(t)):(n.color!==s&&(r[t.signalIndex]=n.color),a.style.color=s)),shmi.objectHasOwnProperty(e.display,"highlightSignal")&&void 0!==e.display.highlightSignal&&null!==c&&c!==t.signalIndex&&(a.style.color=s)):a.style=shmi.visuals.controls.TrendDisplay.Style.defaultStyle,shmi.objectHasOwnProperty(t,"signalIndex")?(a.signalIndex=parseInt(t.signalIndex),(isNaN(a.signalIndex)||a.signalIndex<0)&&shmi.log("TrendDisplay.onConfiguration() invalid signalIndex on trend item @"+i,3)):a.signalIndex=i,shmi.objectHasOwnProperty(t,"laneIndex")?(a.laneIndex=parseInt(t.laneIndex),(isNaN(a.laneIndex)||a.laneIndex<0)&&shmi.log("TrendDisplay.onConfiguration() invalid laneIndex on trend item @"+i,3)):a.laneIndex=i,["alias","label","name","unit"].forEach((function(e){shmi.objectHasOwnProperty(t,e)&&(a[e]=String(t[e]).trim())})),["visible","scaleVisible"].forEach((function(e){shmi.objectHasOwnProperty(t,e)&&(a[e]=!!t[e])})),a})),r.length&&localStorage.setItem("itemStyles",JSON.stringify(r));var u=t.data.getTrendByName(a);return u.items=i,u.info.then((function(t){var s=shmi.visuals.controls.TrendDisplay.Signal;e.trend={name:a,items:i,aggregate:e.trend.aggregate,signals:i.map((function(e,i){var n=t.items[e.signalIndex];""!==e.alias&&((n=t.items.filter((function(t){return t.name===e.alias}))).length?n=n[0]:shmi.log("TrendDisplay.onConfiguration() missing/invalid item.alias in trend display config (my-trend.json) or in trendInfo object @"+a,3));var l=null,o=null;n&&"object"==typeof n||shmi.log("missing/invalid info on item @"+i,3),l="function"==typeof(o=shmi.pkg("visuals.custom.wut.helpers")).convertLabelToken?shmi.localize(o.convertLabelToken(n.label)):shmi.localize(n.label);var r=parseFloat(n.min),c=parseFloat(n.max);return(isNaN(r)||isNaN(c))&&shmi.log("missing/invalid min/max value on item @"+i,3),new s({alias:String(e.alias||n.alias||""),name:String(e.name||n.name||"item"+i),label:String(l||n.label||e.name||n.name||""),unit:String(e.unit||n.unit||""),min:r,max:c,visible:e.visible,scaleVisible:shmi.objectHasOwnProperty(e,"scaleVisible")?e.scaleVisible:e.visible,valueIndex:e.signalIndex,styleIndex:e.styleIndex||0,laneIndex:e.laneIndex||0,itemIndex:i})}))}}))}]),shmi.registerControlType("trend-display",shmi.visuals.controls.TrendDisplay,!0),shmi.registerControlType("trend-display-continuous",shmi.visuals.controls.TrendDisplay.Continuous,!1),shmi.registerControlType("trend-display-handle",shmi.visuals.controls.TrendDisplay.Handle,!1),shmi.registerControlType("trend-display-scale",shmi.visuals.controls.TrendDisplay.Scale,!1),shmi.registerControlType("trend-display-timeline",shmi.visuals.controls.TrendDisplay.Timeline,!1),shmi.registerControlType("trend-display-program",shmi.visuals.controls.TrendDisplay.ProgramManager,!1),Object.unfreeze=function(e){var t=void 0;if(e instanceof Array){t=[];e.forEach((function(e){t.push(e)}))}else if(e instanceof String)t=String(e);else if("object"==typeof e)for(var i in t={},e)t[i]="object"==typeof i?Object.unfreeze(e[i]):e[i];return t},shmi.visuals.session.userActions["trend-display"]=function(e){var t=e.toString().split(","),i=t[0],s=t[1],n=shmi.ctrl(i),a=null;if(n)switch(s){case"addZoomX":(function addZoomX(e){var t=n.items.items,i=parseFloat(e)||100;if(t){var s=getIM().getItem(t.zoomX.name);i=s.value<100*shmi.c("TREND_DISPLAY_ZOOM_SCALE_X_MIN")?shmi.c("TREND_DISPLAY_ZOOM_SCALE_X_MIN")*(100+i):s.value*(100+i)/100,s.writeValue(i)}})(a=t.length>2?t[2]:100);break;case"setZoomX":(function setZoomX(e){var t=n.items.items,i=parseFloat(e)||100;if(t){var s=getIM().getItem(t.zoomX.name);console.warn("zoomX.value: "+s.value+" level: "+i),s.writeValue(i)}})(a=t.length>2?t[2]:100);break;case"handleTime":a=t.length>2?t[2]:0;var l=t.length>3?t[3]:"";setHandleTime(a,l);break;case"timepicker":var o=shmi.ctrl(".trend-display-select-time").getValue();setHandleTime(a=1e3*o);break;case"toggleLiveMode":(function toggleLiveMode(e){var t=n.items.items,i=e||-1;if(t){var s=getIM().getItem(t.live.name),a=getIM().getItem(t.handleTime.name),l=n.getComponents("trend-display-continuous")[0];-1===i||0===t.live.lastValue?(s.writeValue(i),l&&l.trend&&(l.trend.running=!0),setTimeout((function(){var e=(new Date).getTime()/1e3,t=n.element.getAttribute("class").match(/(?:^|\s)rh-trend-display(?!\S)/g)?-11:0,i=parseInt(e)+t,s=new Date(1e3*i);a.writeValue(i),shmi.log("[UserAction] trend-display - toggleLiveMode: "+t+" min offset due to invisible area for RH "+s.getHours()+":"+s.getMinutes(),1)}),250)):(s.writeValue(0),l&&l.trend&&(l.trend.running=!1))}})(a=t.length>2?t[2]:null);break;case"previousTimestamp":showTimestamp(-1);break;case"nextTimestamp":showTimestamp(1)}else console.error("trend-display action: TrendDisplay element '"+i+"' not found");function getIM(){return shmi.requires("visuals.session.ItemManager")}function setHandleTime(e,t){var i=n.items.items,s=new Date,l=parseInt(e),o=t||"",r=13===a.toString().length?a:s;if(i){var c=getIM().getItem(i.live.name),u=getIM().getItem(i.leftTime.name),h=getIM().getItem(i.handleTime.name);if(""!==o){var m=s;if(0!==i.leftTime.lastValue){var d=i.leftTime.lastValue.toString().length;m=10===d?new Date(1e3*i.leftTime.lastValue):13===d?new Date(i.leftTime.lastValue):s}switch(o.toLowerCase()){case"year":r=m.setFullYear(m.getFullYear()+l);break;case"quarter":r=m.setMonth(m.getMonth()+3*l);break;case"month":r=m.setMonth(m.getMonth()+l);break;case"week":r=m.setDate(m.getDate()+7*l);break;case"day":r=m.setDate(m.getDate()+l);break;case"hour":r=m.setTime(m.getTime()+36e5*l);break;case"minute":r=m.setTime(m.getTime()+6e4*l);break;case"second":r=m.setTime(m.getTime()+1e3*l);break;default:shmi.log("[UserAction] trend-display - setTimestamp: undefined interval "+o,3)}}else l.toString().length<=10&&(r=0!==parseInt(i.leftTime.lastValue)?parseInt(i.leftTime.lastValue)+3600*l:new Date(s.getTime()+3600*l).getTime());10===(r=13===r.toString().length?parseInt(r/1e3):parseInt(r)).toString().length?(parseInt(s.getTime()/1e3)<=r?c.writeValue(-1):n.isActive()&&c.writeValue(0),u.writeValue(r),setTimeout((function(){h.writeValue(r)}),250)):shmi.log("[UserAction] trend-display - setTimestamp: no correct value/timestamp "+r,3)}}function showTimestamp(e){var t=n.items.items,i=e||-1,s=shmi.visuals.controls.TrendDisplay.CanvasBackground.getTimestamps();if(t&&s){var a=getIM().getItem(t.live.name),l=getIM().getItem(t.leftTime.name),o=getIM().getItem(t.handleTime.name),r=new Date(1e3*parseInt(o.value));a.writeValue(0);var c=[];s.forEach((function(e){c.push(new Date(1e3*parseInt(e)))})),c.sort((function(e,t){return Math.abs(r-e)-Math.abs(r-t)}));var u=c.filter((function(e){return-1===i?e-r<0:e-r>0}));if(u&&u.length){if(u=u[0].getTime()/1e3,-1===i?l.value>=u:l.value<=u){l.writeValue(u-500)}o.writeValue(u)}}}},function(){"use strict";var e="trend-legend",t=1,i={"class-name":e,name:e,"trend-display":null,template:"default/trend-legend","label-type":0},s=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),n=(s.fLog,s.log);function highlightTrendSignal(e,t){var i=t.vars.trendDisplay,s=null;return i?((s=shmi.cloneObject(i.config)).display.highlightSignal=e,n("highlighted signal:",e),function reloadTrendDisplay(e,t,i){i.locked||(delete t.trend.signals,delete t.styleManagers,delete t.viewport,delete t["config-name"],delete t.display.units.background,delete t.display.units.ruler,delete shmi.visuals.session.TrendManager.$$trendNames,i.lock(),e.config.update(t,!0).then((function(){i.unlock()})))}(i,s,t),!0):(n("trend-display control not resolved:",t.config.trendControl),!1)}function createEntryElement(e,t){var i,s=document.createElement("DIV"),n=t.vars.trendDisplay,a=shmi.requires("visuals.tools.iterate.iterateObject"),l={labelLetter:"?",color:"#333333",value:"",signalLabel:"[LABEL]",signalUnit:"[UNIT]",signalIndex:-1e3};return a(l,(function(t,i){void 0===e[i]&&(e[i]=l[i])})),s.setAttribute("data-ui","trend-legend-entry"),s.classList.add("trend-legend-entry"),s.dataset.signalIndex=e.signalIndex,i='<div data-ui="scale-id" class="scale-id"><div class="scale-letter">'+(e.labelLetter||"&nbsp;")+'</div></div><div data-ui="trend-style" class="trend-style" style="border-style: solid; border-color: '+e.color+'; border-width: 2px;"></div><div data-ui="trend-item-name" class="trend-item-name" title="'+e.signalLabel+'">'+e.signalLabel+'</div><div data-ui="trend-item-unit" class="trend-item-unit">'+shmi.localize(e.signalUnit)+'</div><div data-ui="trend-item-value" class="trend-item-value">'+formatItemsValue(e.value,e.signalName,t)+"</div>",s.innerHTML=i,n&&n.config.display&&n.config.display.highlightSignal===e.signalIndex&&(shmi.addClass(s,"selected"),shmi.addClass(t.element,"highlight-mode")),s}function formatItemsValue(e,t,i){var s=shmi.requires("visuals.tools.numericValues"),n=shmi.visuals.tools.unitClasses,a=null,l=null;return t=i.vars.curveMap[t]?i.vars.curveMap[t]:t,i.vars.trendInfo&&i.vars.trendInfo.items&&i.vars.trendInfo.items.forEach((function(e){e.name===t&&(l=e)})),l&&(l.unitClass&&(a=n.getSelectedAdapter(l.unitClass))&&(e=a.outFunction(e)),e=s.formatOutput(e,{vars:{valueSettings:{min:l.min,max:l.max,step:0,precision:null===l.digits?-1:l.digits,type:shmi.c("TYPE_FLOAT")}}})),e}function lock(e,t){e.locked=!0,e.vars.listeners.forEach((function(e){e.disable()})),e.controls.forEach((function(e){e.lock(t)}))}function onLabelsReady(e){!function renderLegend(e){var i,s,n,a=shmi.requires("visuals.io"),l=e.imports.im,o=l.getItemHandler(),r=null;!(i=e.vars.trendDisplay)&&e.config["trend-display"]&&(i=e.vars.trendDisplay=shmi.ctrl(e.config["trend-display"])),i&&i.config&&i.config.trend?(n=i.config.trend.signals||[],e.element.innerHTML="",s=i.items.items.curves,e.vars.curveMap={},n.forEach((function(n){var c,u,h,m,d,f,v,g,p=document.createElement("DIV"),b=n.labelLetter;if(s&&s[n]&&s[n.name]&&s[n.name].value)f=n.name;else{if(!(s&&s[n.alias]&&s[n.alias].value))return;f=n.alias}if(v=s[f].value.name,e.vars.curveMap[v]=f,d=s[f].value.lastValue,i.config.styles[i.config.trend.items[n.itemIndex].styleIndex])m=i.config.styles[i.config.trend.items[n.itemIndex].styleIndex].color;else{if(!i.config.trend.items[n.itemIndex].style.color)return void console.log("Trend Item color is not defined?");m=i.config.trend.items[n.itemIndex].style.color}g={labelLetter:b,color:m,value:d,signalLabel:e.config["label-type"]===t?n.alias||n.name:shmi.localize(n.label),signalUnit:n.unit,signalIndex:n.valueIndex,signalName:n.name},p=createEntryElement(g,e),e.vars.entryElements.push(p),e.element.appendChild(p),r=l.subscribeItem(v,o),e.vars.tokens.push(r),e.vars.lastValueElements[v]||(e.vars.lastValueElements[v]=[]),e.vars.lastValueElements[v].push(shmi.getUiElement("trend-item-value",p)),h={onClick:function(t,i,s){var n=document.getElementsByClassName("trend-legend-entry selected",e.element)||[],a=shmi.hasClass(p,"selected"),l=null;shmi.removeClass(e.element,"highlight-mode"),[].forEach.call(n,(function(e){shmi.removeClass(e,"selected")})),a||(shmi.addClass(p,"selected"),l=Number(p.dataset.signalIndex)),highlightTrendSignal(l,e)}},c=new a.MouseListener(p,h),u=new a.TouchListener(p,h),e.vars.listeners.push(c,u)})),o.setValue=function(t,i,s){s in e.vars.lastValueElements&&e.vars.lastValueElements[s].forEach((function(i){i.textContent=formatItemsValue(t,s,e)}))},e.locked||e.vars.listeners.forEach((function(e){e.enable()}))):console.log("TrendDisplay is not defined!")}(e),e.vars.listeners.forEach((function(e){e.enable()})),e.locked&&lock(e,!0)}var a={className:"TrendLegend",uiType:e,isContainer:!0,config:i,configSchema:null,vars:{trendDisplay:null,trendInfo:null,curves:{},selectedCurve:null,entryElements:[],lastValueElements:{},listeners:[],tokens:[],curveMap:{}},imports:{im:"visuals.session.ItemManager",qm:function(){return shmi.visuals.session.QueryManager}},prototypeExtensions:{onInit:function(){var e=createEntryElement({},this);this.element.appendChild(e)},onEnable:function(){var e=this,t=shmi.visuals.session.TrendManager;e.config["trend-display"]&&shmi.onReady({controls:{trendControl:e.config["trend-display"]},items:{},resources:{}},(function(i){var s,n=i.controls.trendControl;e.vars.trendDisplay=n,n&&n.config&&n.config.trend&&n.config.trend.name&&t.getTrendInfo(n.config.trend.name,(function(t){e.vars.trendInfo=t})),s=shmi.listen("labels-ready",onLabelsReady.bind(null,e),{"detail.name":n.getName()}),e.vars.tokens.push(s),n._components&&n._components["trend-display-scale"]&&n._components["trend-display-scale"][0]&&n._components["trend-display-scale"][0].labelsReady&&onLabelsReady(e)}))},onDisable:function(){!function disable(e){e.vars.tokens.forEach((function(e){e.unlisten()})),e.vars.tokens=[],e.vars.listeners.forEach((function(e){e.disable()})),e.vars.listeners=[],e.vars.entryElements=[],e.vars.lastValueElements={},e.element.innerHTML="",e.vars.trendDisplay=null}(this)},onLock:function(){lock(this,!0)},onUnlock:function(){!function unlock(e,t){e.locked=!1,e.controls.forEach((function(e){e.unlock(t)})),e.vars.listeners.forEach((function(e){e.enable()}))}(this,!0)},onSetValue:function(e,t,i){},onSetProperties:function(e,t,i){}}};shmi.requires("visuals.tools.control-generator").generate(a)}(),function(){"use strict";var e="TrendSelect",t="trend-select",i=10,s=0,n={"class-name":t,name:null,template:"default/trend-select",label:t,"trend-display":null,pager:{"per-page":1e4},"label-type":s},a=shmi.requires("visuals.tools.logging").createLogger(t,!0,!1),l=(a.fLog,a.log);function lock(e,t){e.locked=!0,e.controls.forEach((function(e){e.lock(t)}))}function enable(t){shmi.onReady({controls:{trendControl:t.config["trend-display"]}},(function(i){t.isActive()&&(t.vars.trendDisplay=i.controls.trendControl,t.vars.trendName=t.vars.trendDisplay.config.trend?t.vars.trendDisplay.config.trend.name:"",function getTrendStyles(e){var t=[];e.vars.trendDisplay&&e.vars.trendDisplay.config.styles&&(t=e.vars.trendDisplay.config.styles);t.forEach((function(t,i){e.vars.colors[i]=t,e.vars.colors[i].value=i}))}(t),t.imports.tm.getTrendInfo(t.vars.trendName,(function(i){t.isActive()&&(t.vars.trendInfo=i,l("trend info set:",i),t.vars.trendInfo&&t.vars.trendInfo.items&&(t.vars.curDataSet={curStartPos:0,curFilter:"",visibleItems:t.vars.trendInfo.items}),function prepareListElements(e){var t,i,s={template:"default/trend-select/list-element","class-name":"group list-element","@select-checkbox-config":{item:""},"@var-name-config":{_text:"[VAR_NAME]"},"@unit-config":{text:"UNIT"},"@button-config":{trendItem:null,_action:"dialog-box:.graph-style-dialog:show"},"@scale-checkbox-config":{}},n=e.config.pager["per-page"],a=e.vars.trendInfo.items;a.length?a.length<n&&(n=a.length):n=0;for(var l=0;l<n;l++)(i=shmi.cloneObject(s)).name="list-element_"+l,i["@select-checkbox-config"].name="select-list-element",i["@var-name-config"].name="name-list-element",i["@unit-config"].name="unit-list-element",i["@button-config"].name="button-list-element",i["@scale-checkbox-config"].name="scale-list-element",t=shmi.createControl("group",e.vars.optionListAnchor,i,"DIV",null),shmi.addClass(t.element,"hidden"),e.vars.listElements.push(t),e.vars.listElementNames["listElement_"+l]=e.getName()+" .list-element_"+l}(t),shmi.onReady({controls:t.vars.listElementNames},(function(i){if(t.isActive()){updateListElements(t.vars.trendInfo.items,t),function onTrendDisplayReady(t){var i;setItemsToListElements(t),i=t.vars.inputField.listen("change",(function(i){l("changed",i.detail.value),function applyInputFilter(t,i){if(t.vars.curDataSet={curStartPos:0,curFilter:i,visibleItems:[]},t.vars.trendInfo&&t.vars.trendInfo.items){var s=[];t.vars.trendInfo.items.forEach((function(e){var n=getItemLabel(t,e.name);-1!==String(n).toLowerCase().indexOf(String(i).toLowerCase())&&s.push(e)})),t.vars.curDataSet.visibleItems=s,updateListElements(s,t)}else console.error(e,"trend info not loaded yet")}(t,i.detail.value)})),t.vars.tokens.push(i),function prepareDialogBox(e){e.vars.dialogBox||(e.vars.dialogBox=shmi.createControl("dialog-box",e.vars.dialogBoxAnchor,{name:"graph-style-dialog",title:"${selected-trend-name}","content-template":"default/trend-select/graph-style-dialog","class-name":"dialog-box trend-select graph-style-dialog-box","top-level":!0,"@button-cancel-config":{name:"button-cancel-config"},"@button-apply-config":{name:"button-apply-config"}},"DIV",null));shmi.onActive([e.vars.dialogBox],(function(){var t=shmi.getElementByName("select-radio-anchor",e.vars.dialogBox.element),i=null,s=shmi.ctrl(e.vars.dialogBox.getName()+" .button-apply-config"),n=shmi.ctrl(e.vars.dialogBox.getName()+" .button-cancel-config");e.vars.colorSelect||(e.vars.colorSelect=shmi.createControl("select-radio",t,{name:"color-selection",options:e.vars.colors,"class-name":"select-radio no-label color-selection"},"DIV",null)),e.vars.tokens.push(s.listen("click",(function(t){var i,s,n,a=t.source,l=shmi.ctrl(a.parentContainer.getName()+" .color-selection");s=a.parentContainer.config["item-name"];var o=shmi.cloneObject(e.vars.trendDisplay.config);o.trend.items.forEach((function(e){e.alias===a.parentContainer.config["item-name"]&&(n=e)})),i=null===(i=Number(l.value))?-1:i,o.styles[i]&&(l.value!==a.parentContainer.config["current-color-index"]?(a.parentContainer.config["current-color-index"]=i,changeLineStyleElement(s,n,i,e),n&&(n.styleIndex=i,n.style={},reloadTrendDisplay(o,e)),addTrendItem(e,s,{styleIndex:i}),setTimeout((function(){e.vars.dialogBox.hide()}),100)):setTimeout((function(){e.vars.dialogBox.hide()}),100))}))),e.vars.tokens.push(n.listen("click",(function(t){var i,s=t.source,n=shmi.ctrl(s.parentContainer.getName()+" .color-selection");i=null===(i=Number(s.parentContainer.config["current-color-index"]))?-1:i,n.setValue(i),e.vars.dialogBox.hide()}))),i=e.vars.colorSelect.listen("enable",(function(t){var s,n,a=shmi.getUiElements("option",e.vars.colorSelect.element);i.unlisten(),e.vars.tokens.splice(e.vars.tokens.indexOf(i),1);for(var l=0;l<a.length;l++)n=(s=a[l]).dataset.value,e.vars.colors[n]&&(s.style.backgroundColor=e.vars.colors[n].color)})),e.vars.tokens.push(i)}))}(t),t.controls.forEach((function(e){e.enable()})),t.locked&&lock(t,!0)}(t);var s=shmi.listen("enable",(function(e){t.vars.trendDisplay=e.source}),{"detail.name":t.config["trend-display"]});t.vars.tokens.push(s),t.vars.optionListAnchor&&t.vars.optionListAnchor.addEventListener("scroll",t.vars.scrollListener)}})))})))}))}function getItemLabel(e,t){var i=t,n=null;return e.config["label-type"]===s&&e.vars.trendInfo&&Array.isArray(e.vars.trendInfo.items)&&(e.vars.trendInfo.items.some((function(e){return e.name===t&&(n=e,!0)})),n&&"string"==typeof n.label&&(i=shmi.localize(n.label))),i}function updateListElements(e,t){t.vars.trendItemsPosByName=[],t.vars.listElements.forEach((function(i,s){var n=shmi.ctrl(i.getName()+".name-list-element"),a=shmi.ctrl(i.getName()+".unit-list-element"),o=shmi.ctrl(i.getName()+" .select-list-element"),r=shmi.ctrl(i.getName()+" .button-list-element"),c=shmi.getElementByName("line-style",i.element),u=shmi.ctrl(i.getName()+" .scale-list-element"),h=e[s]?e[s]:null,m="",d=h?h.unit:"";if(i.itemName=h?getItemName(h):"",i.listElementIndex=s,r.config.trendItem=null,c.style.borderColor="#000000",c.style.borderWidth="1px",t.vars.disableChangeListener=!0,h){t.vars.trendItemsPosByName[getItemName(h)]=s,m=getItemLabel(t,h.name);var f=-1!==t.vars.trendDisplayItemNames.indexOf(h.name);o.value!==f&&o.setValue(f),shmi.removeClass(i.element,"hidden")}else shmi.addClass(i.element,"hidden");if(n.element.title=m,n.setValue(m),a.setValue(shmi.localize(d)),t.vars.disableChangeListener=!1,!t.vars.boxes[s]){t.vars.boxes[s]=o;var v=o.listen("change",(function(e){var i,s=e.source.parentContainer.itemName,n=e.source.parentContainer.listElementIndex,a={};t.vars.disableChangeListener||-1!==t.vars.trendDisplayItemNames.indexOf(s)==(0===e.detail.value)&&(t.vars.disableChangeListener=!0,1===e.detail.value?(a.scaleVisible=!1,addTrendItem(t,s,a)?u.setValue(a.scaleVisible):(i=t.vars.disableChangeListener,t.vars.boxes[n].setValue(0),t.vars.disableChangeListener=i)):!function removeTrendItem(e,t){var i=shmi.requires("visuals.tools.iterate.iterateObject"),s=null,n=-1;if(e.vars.trendDisplay=shmi.ctrl(e.config["trend-display"]),e.vars.trendDisplay)return(s=shmi.cloneObject(e.vars.trendDisplay.config)).trend.items.length<2?(l("Last trend item:",s.trend.items),!1):(s.trend.items.forEach((function(e,i){getItemName(e)===t&&(n=i)})),-1!==n&&(e.vars.availableStyleIndices.push(s.trend.items[n].styleIndex),s.trend.items.splice(n,1),i(e.vars.boxes,(function(e){e.unlock()})),l("removed trend item:",t),changeLineStyleElement(t,null,null,e),reloadTrendDisplay(s,e)),!0);return!1}(t,s)?(i=t.vars.disableChangeListener,t.vars.boxes[n].setValue(1),t.vars.disableChangeListener=i):u.setValue(0),t.vars.disableChangeListener=!1)}));t.vars.tokens.push(v),t.vars.tokens.push(r.listen("click",(function(e){if(e.source.config.trendItem){var i,s,n=t.vars.colorSelect,a=e.source.config.trendItem;t.vars.dialogBox&&(t.vars.dialogBox.show(),n.setValue(a.styleIndex),t.vars.dialogBox.config["current-color-index"]=a.styleIndex,i=getItemName(a),t.vars.dialogBox.config["item-name"]=i,(s=shmi.getUiElement("dialog-box-title",t.vars.dialogBox.element))&&(s.textContent=getItemLabel(t,i)))}else console.log("Cannot set colour. Lane is inactive.")})));var g=u.listen("change",(function(e){var i=e.source.parentContainer.itemName,s=0;t.vars.disableChangeListener||(1===e.detail.value&&(s=1),function setScaleVisibility(e,t,i){var s=null,n=null;return e.vars.trendDisplay=shmi.ctrl(e.config["trend-display"]),e.vars.trendDisplay?((s=shmi.cloneObject(e.vars.trendDisplay.config)).trend.items.some((function(e){return e.alias===t&&(n=e,!0)})),n?Boolean(n.scaleVisible)===Boolean(i)?(l("scale visibility already set"),!0):(n.scaleVisible=1===i,reloadTrendDisplay(s,e),!0):(l("item not found"),!1)):(l("trend-display control not resolved:",e.config["trend-display"]),!1)}(t,i,s)||(t.vars.disableChangeListener=!0,u.setValue(0),t.vars.disableChangeListener=!1))}));t.vars.tokens.push(g)}})),setItemsToListElements(t)}function getItemName(e){return e.alias||e.name}function setItemsToListElements(e){var t,i=[],s=[],n=[],a={};e.vars.trendDisplay&&e.vars.trendDisplay.config&&(a=e.vars.trendDisplay.config),a.trend&&a.trend.items&&(s=a.trend.items),a.styles&&(n=a.styles),e.vars.disableChangeListener=!0,s.forEach((function(s){var a,l,o=getItemName(s),r=e.vars.trendItemsPosByName[o];if(n[s.styleIndex]&&(t=n[s.styleIndex].color),void 0!==r){var c=shmi.getElementByName("line-style",e.vars.listElements[r].element);c.style.borderColor=t,c.style.borderWidth="3px"}e.vars.listElements[r]&&(shmi.ctrl(e.vars.listElements[r].getName()+" .select-list-element").setValue(1),shmi.ctrl(e.vars.listElements[r].getName()+" .button-list-element").config.trendItem=s,a=shmi.ctrl(e.vars.listElements[r].getName()+" .scale-list-element"),Boolean(s.scaleVisible)!==Boolean(a.getValue())&&(l=s.scaleVisible?1:0,a.setValue(l))),i.push(s.styleIndex),e.vars.trendDisplayItemNames.push(o)})),e.vars.disableChangeListener=!1;for(var l=0;l<n.length;l++)-1===i.indexOf(l)&&e.vars.availableStyleIndices.push(l)}function reloadTrendDisplay(e,t){t.locked||(delete e.trend.signals,delete e.styleManagers,delete e.viewport,delete e["config-name"],delete e.display.units.background,delete e.display.units.ruler,delete shmi.visuals.session.TrendManager.$$trendNames,t.vars.trendDisplayItemNames=[],e.trend.items.forEach((function(e,i){e.signalIndex=i,t.vars.trendDisplayItemNames.push(getItemName(e))})),t.vars.trendDisplay.config.update(e,!0).then((function(){console.log("TREND_DISPLAY_UPDATE - TrendSelect",arguments)})))}function addTrendItem(e,t,s){var n=shmi.requires("visuals.tools.iterate.iterateObject"),a=null,o=-1,r={alias:t,label:"label",styleIndex:null,visible:!0,scaleVisible:!1},c=!1;return s&&n(s,(function(e,t){r[t]=e})),e.vars.trendDisplay=shmi.ctrl(e.config["trend-display"]),e.vars.trendDisplay?((a=shmi.cloneObject(e.vars.trendDisplay.config)).trend.items.forEach((function(e){c=e.alias===t||c})),c?(l("item already selected"),!0):(o=a.trend.items.length)>=i?(shmi.notify("${trend-select.notification.max-curves}","${V_NOTIFICATION}",{VALUE:i}),l("too many items selected"),!1):(null===r.styleIndex&&(r.styleIndex=e.vars.availableStyleIndices.shift()),r.signalIndex=o,r.laneIndex=r.signalIndex,a.trend.items.push(r),o===i&&n(e.vars.boxes,(function(e){1!==e.getValue()&&e.lock()})),changeLineStyleElement(t,r,r.styleIndex,e),l("added trend item:",t),reloadTrendDisplay(a,e),!0)):(l("trend-display control not resolved:",e.config["trend-display"]),!1)}function changeLineStyleElement(e,t,i,s){var n="#000000",a="1px",l=s.vars.trendItemsPosByName[e];if(shmi.ctrl(s.vars.listElements[l].getName()+" .button-list-element").config.trendItem=t,void 0!==l){null!==i&&s.vars.trendDisplay.config.styles[i]&&(n=s.vars.trendDisplay.config.styles[i].color,a="3px");var o=shmi.getElementByName("line-style",s.vars.listElements[l].element);o.style.borderColor=n,o.style.borderWidth=a}}var o={className:e,uiType:t,isContainer:!0,config:n,configSchema:null,vars:{dialogBox:null,colorSelect:null,disableChangeListener:null,inputAnchor:null,optionList:null,optionListAnchor:null,inputField:null,listElements:[],listElementNames:{},boxes:{},colors:[],availableStyleIndices:[],trendInfo:null,trendItemsPosByName:{},trendDisplay:null,trendName:null,tokens:[],scrollListener:null,trendDisplayItemNames:[],curDataSet:{curStartPos:0,curFilter:"",visibleItems:[]},reloadTimeout:0},imports:{im:"visuals.session.ItemManager",tm:"visuals.session.TrendManager",qm:function(){return shmi.visuals.session.QueryManager}},prototypeExtensions:{onInit:function(){var e=this;e.vars.inputAnchor=shmi.getUiElement("input-anchor",e.element),e.vars.optionList=shmi.getUiElement("option-list",e.element),e.vars.optionListAnchor=shmi.getUiElement("option-list-anchor",e.element),e.vars.dialogBoxAnchor=shmi.getUiElement("dialog-box-anchor",e.element);var t=shmi.getUiElement("input-field",e.vars.inputAnchor);e.vars.inputField=shmi.createControl("input-field",t,{},"DIV","from"),e.vars.scrollListener=function(t){var i,s=t.target||t.srcElement,n=e.config.pager["per-page"],a=e.vars.curDataSet,l=a.curStartPos+n,o=a.visibleItems.length,r=null,c=null,u=null,h=0,m=s.scrollHeight/n*(n-5);l>=o&&(l=o-1),i=l-a.curStartPos,0===s.scrollTop&&a.curStartPos>0?(c=(c=(r=(r=a.curStartPos-(n-5))>-1?r:0)+n)>=o?o:c,u=a.visibleItems.slice(r,c),h=s.scrollHeight/i*(u.length-5)):s.scrollTop>m&&((c=(r=l-5)+n)>o&&(c=o-1),u=a.visibleItems.slice(r,c),h=1),null!==r&&r!==a.curStartPos&&c!==l&&(a.curStartPos=r,s.scrollTop=h,updateListElements(u,e))},function prepareListHeader(e){var t=document.createElement("div");shmi.addClass(t,"list-header"),shmi.createControl("text2",t,{text:" ","class-name":"col1 ctrl text2"},"DIV",null),shmi.createControl("text2",t,{text:"${trend-select-value}","class-name":"col2 ctrl text2"},"DIV",null),shmi.createControl("text2",t,{text:"${trend-select-unit}","class-name":"col3 ctrl text2"},"DIV",null),shmi.createControl("text2",t,{text:"${trend-select-graph}","class-name":"col4 ctrl text2"},"DIV",null),shmi.createControl("text2",t,{text:"${trend-select-scale}","class-name":"col5 ctrl text2"},"DIV",null),e.vars.optionList.insertAdjacentElement("afterbegin",t)}(e)},onEnable:function(){this.config["trend-display"]?enable(this):console.log("Trend-display ist not defined!")},onDisable:function(){!function disable(e){e.vars.tokens.forEach((function(e){e.unlisten()})),e.vars.tokens=[],e.vars.optionListAnchor&&e.vars.optionListAnchor.removeEventListener("scroll",e.vars.scrollListener),e.vars.boxes={},e.vars.trendDisplay=null}(this)},onLock:function(e){lock(this,e)},onUnlock:function(e){!function unlock(e,t){e.locked=!1,e.controls.forEach((function(e){e.unlock(t)}))}(this,e)},onSetValue:function(e,t,i){},onSetProperties:function(e,t,i){}}};shmi.requires("visuals.tools.control-generator").generate(o)}(),function(){"use strict";var e="TrendZoomModule",t="trend-zoom",i={"class-name":t,name:null,"trend-display":null,template:"default/trend-zoom",label:t},s=shmi.requires("visuals.tools.logging").createLogger(t,!0,!1),n=(s.fLog,s.log,{});function lock(e,t){e.controls.forEach((function(e){e.lock(t)}))}function generateButtonAction(e,t){var i={zoom24hButton:"percentIn24h",zoom12hButton:"percentIn12h",zoom8hButton:"percentIn8h",zoom4hButton:"percentIn4h",zoom2hButton:"percentIn2h",zoom1hButton:"percentIn1h"};return i[e]&&n[i[e]]?{name:"trend-display",params:[t.config["trend-display"],"setZoomX",n[i[e]]]}:(console.log("Unknown zoom or time unit for button name ["+e+"].",i,n),null)}function setLiveMode(e,t){var i=shmi.requires("visuals.core"),s={name:"trend-display",params:[t.config["trend-display"],"toggleLiveMode",e]};e!==t.vars.liveMode&&new i.UiAction(s).execute()}function initDateTimePicker(e,t){var i=e.selectDate,s=e.selectTime;t.vars.tokens.push(e.doneButton.listen("click",(function(){var e=i.value,n=s.getHours(),a=s.getMinutes(),l=s.getSeconds(),o=new Date(1e3*e);o.setHours(n,a,l,0),new shmi.visuals.core.UiAction({name:"trend-display",params:[t.config["trend-display"],"handleTime",o.getTime()]}).execute()})))}function create(t){var i=t.getName(),s=null,a=null,l={playButton:{anchorName:"play-button-anchor",controls:[{ui_type:"button",cfg:{name:"play-button",template:"default/button_with_bg_pic","class-name":"icon-only no-frame play button"},events:{click:"playLiveMode"}}]},pauseButton:{anchorName:"pause-button-anchor",controls:[{ui_type:"button",cfg:{name:"pause-button",template:"default/button_with_bg_pic","class-name":"icon-only no-frame pause button"},events:{click:"pauseLiveMode"}}]},zoomOutButton:{anchorName:"zoom-out-button-anchor",controls:[{ui_type:"button",cfg:{name:"zoom-out-button",template:"default/button_with_bg_pic",action:{name:"trend-display",params:[t.config["trend-display"],"addZoomX",-25]},"class-name":"ctrl button zoom-out icon-only no-frame"}}]},zoomInButton:{anchorName:"zoom-in-button-anchor",controls:[{ui_type:"button",cfg:{name:"zoom-in-button",template:"default/button_with_bg_pic",action:{name:"trend-display",params:[t.config["trend-display"],"addZoomX",25]},"class-name":"ctrl button zoom-in icon-only no-frame"}}]},pointInTimeArea:{anchorName:"point-in-time-area",controls:[{ui_type:"button",cfg:{name:"zoom-stages-button",template:"default/button_with_bg_pic",action:{name:"popup-menu",params:[i+" .point-in-time-popup","open"]},"class-name":"ctrl button icon-only no-frame point-in-time"}},{ui_type:"popup-menu",cfg:{name:"point-in-time-popup","content-template":"default/trend-zoom/point-in-time-popup"},dateTimePicker:{selectDate:i+" .select-date-anchor.select-date",selectTime:i+" .select-time-anchor.select-time",doneButton:i+" .done-button-anchor.done"}}]},zoomStagesArea:{anchorName:"zoom-stages-area",controls:[{ui_type:"button",cfg:{name:"zoom-stages-button","show-icon":!0,"show-text":!1,"icon-src":"pics/system/controls/trend-zoom/Zeitspanne.svg",action:{name:"popup-menu",params:[i+" .zoom-stages-popup","toggle"]},"class-name":"ctrl button zoom-stage no-frame"}},{ui_type:"popup-menu",cfg:{name:"zoom-stages-popup","class-name":"zoom-stages-popup ctrl popup-menu hidden","content-template":"default/trend-zoom/zoom-stages-popup"},buttonActions:{buttons:{zoom24hButton:i+".zoom-stages-popup.zoom-stages-button-anchor.zoom-24h-button",zoom12hButton:i+".zoom-stages-popup.zoom-stages-button-anchor.zoom-12h-button",zoom8hButton:i+".zoom-stages-popup.zoom-stages-button-anchor.zoom-8h-button",zoom4hButton:i+".zoom-stages-popup.zoom-stages-button-anchor.zoom-4h-button",zoom2hButton:i+".zoom-stages-popup.zoom-stages-button-anchor.zoom-2h-button",zoom1hButton:i+".zoom-stages-popup.zoom-stages-button-anchor.zoom-1h-button"}}}]}},o=document.body,r=document.documentElement,c=Math.max(o.scrollHeight,o.offsetHeight,r.clientHeight,r.scrollHeight,r.offsetHeight);for(s in l){a=s+"AnchorEl";var u=l[s];t.vars[a]=shmi.getUiElement(u.anchorName,t.element),t.vars[a]?(t.vars.controls[s]=[],u.controls.forEach((function(e){var i=null,l=null,o=shmi.createControl(e.ui_type,t.vars[a],e.cfg,"DIV");t.vars.controls[s].push(o),e.buttonActions&&(i=o.listen("open",(function(s){i.unlisten(),t.vars.tokens.splice(t.vars.tokens.indexOf(i),1),shmi.onReady({controls:e.buttonActions.buttons},(function(e){var i,s,a,l,o,r;if(e.controls){for(i in t.vars.trendDisplay&&t.vars.trendDisplay.config&&t.vars.trendDisplay.config.viewport&&(a=t.vars.trendDisplay.config.viewport.visible,n={"secondsIn100%":a,"hoursIn100%":l=a/3600,percentIn24h:100*l/24,percentIn12h:100*l/12,percentIn8h:100*l/8,percentIn4h:100*l/4,percentIn2h:100*l/2,percentIn1h:100*l}),e.controls)(s=generateButtonAction(i,t))&&(e.controls[i].action=new shmi.visuals.core.UiAction(s,e.controls[i]));if(o=(r=shmi.getUiElement("menu-frame",e.controls.zoom1hButton.parentContainer.parentContainer.element)).getBoundingClientRect(),c<o.y+r.scrollHeight){var u=t.element.getBoundingClientRect().height+10;r.style.bottom=u+"px"}else shmi.addClass(r.parentElement,"menu-down")}}))})),t.vars.tokens.push(i)),e.events&&Object.keys(e.events).forEach((function(i){var s,n=e.events[i];"playLiveMode"!==n&&"pauseLiveMode"!==n||t.vars.tokens.push(o.listen(i,(function(e){"playLiveMode"===n?s=1:"pauseLiveMode"===n&&(s=0),setLiveMode(s,t)})))})),e.dateTimePicker&&(l=o.listen("open",(function(i){l.unlisten(),t.vars.tokens.splice(t.vars.tokens.indexOf(l),1),shmi.onReady({controls:e.dateTimePicker},(function(e){var i,s;if(initDateTimePicker(e.controls,t),s=(i=shmi.getUiElement("menu-frame",e.controls.doneButton.parentContainer.parentContainer.element)).getBoundingClientRect(),c<s.y+i.scrollHeight){var n=t.element.getBoundingClientRect().height+10;i.style.bottom=n+"px"}else shmi.addClass(i.parentElement,"menu-down")}))})),t.vars.tokens.push(l))}))):console.error(e,"Element `"+u.anchorName+"` not found in template")}}var a={className:e,uiType:t,isContainer:!0,config:i,configSchema:null,vars:{created:!1,trendDisplay:null,liveMode:null,liveModeItem:null,playButtonAnchorEl:null,pauseButtonAnchorEl:null,zoomOutButtonAnchorEl:null,zoomInButtonAnchorEl:null,zoomStagesAreaEl:null,zoomResetButtonAnchorEl:null,selectDateAnchorEl:null,selectTimeAnchorEl:null,controls:{},tokens:[]},imports:{im:"visuals.session.ItemManager",qm:function(){return shmi.visuals.session.QueryManager}},prototypeExtensions:{onInit:function(){},onEnable:function(){var e=this,t=e.imports.im,i=t.getItemHandler(),s=null;if(!e.config["trend-display"])return console.log("config trend-display not found! Trend Zoom aborted."),create(e),void lock(e,!0);shmi.onReady({controls:{trendDisplay:e.config["trend-display"]}},(function(n){e.vars.trendDisplay=n.controls.trendDisplay,e.vars.liveModeItem="virtual:"+e.vars.trendDisplay.getName()+":live",i.setValue=function(t,i,s){e.vars.liveMode=t,function setLiveModeButtons(e){var t=Number(e.vars.liveMode>0);e.vars.controls.playButton&&e.vars.controls.playButton[0]&&(1===t?shmi.addClass(e.vars.controls.playButton[0].element,"on"):shmi.removeClass(e.vars.controls.playButton[0].element,"on")),e.vars.controls.pauseButton&&e.vars.controls.pauseButton[0]&&(1!==t?shmi.addClass(e.vars.controls.pauseButton[0].element,"on"):shmi.removeClass(e.vars.controls.pauseButton[0].element,"on"))}(e)},create(e),s=t.subscribeItem(e.vars.liveModeItem,i),e.vars.tokens.push(s),e.locked&&lock(e,!0)}))},onDisable:function(){var e=this,t=shmi.requires("visuals.tools.iterate.iterateObject");e.vars.tokens.forEach((function(e){e.unlisten()})),e.vars.tokens=[],t(e.vars.controls,(function(t,i){t.forEach((function(e){shmi.deleteControl(e,!0)})),e.vars.controls[i]=[]})),e.vars.controls={},e.vars.trendDisplay=null},onLock:function(){lock(this,!0)},onUnlock:function(){!function unlock(e,t){e.controls.forEach((function(e){e.unlock(t)}))}(this,!0)},onSetValue:function(e,t,i){},onSetProperties:function(e,t,i){}}};shmi.requires("visuals.tools.control-generator").generate(a)}(),function(){"use strict";var e={"class-name":"user-info",name:null,template:"custom/controls/user-info",label:"user-info","show-name":!1,"show-group":!1},t=shmi.requires("visuals.tools.logging").createLogger("user-info",!0,!1),i=t.fLog;t.log;function getUser(e){var t=shmi.requires("visuals.tools.connect").request,s=e.vars.user.username;t("user.list",{},(function(t,n){t&&Array.isArray(t.users)?(t.users.forEach((function(t){t.username===s&&(e.vars.user.name=t.first_name,e.vars.user.surname=t.last_name)})),function displayUser(e){var t=null;shmi.getUiElement("user-info-name",e.element)?(t=shmi.getUiElement("user-info-name",e.element),e.config["show-name"]||(e.config["show-name"]=!1),!1===e.config["show-name"]?t.textContent=e.vars.user.username:!0===e.config["show-name"]&&(e.vars.user.name&&e.vars.user.surname?t.textContent=e.vars.user.name+" "+e.vars.user.surname:e.vars.user.name?e.vars.user.surname?t.textContent="First Name and/or Last Name not set!":t.textContent=e.vars.user.name:t.textContent=e.vars.user.surname)):i('Dom-Element "user-info-name" not found!')}(e)):(i("[UserManager] could not retrieve userlist:",n.category,n.errc,n.message),i("User name and surname cannot be displayed!"))}))}var s={className:"user-info",uiType:"user-info",isContainer:!1,config:e,configSchema:null,vars:{user:{userGroups:null,name:null,surname:null,username:null}},imports:{},events:[],prototypeExtensions:{onEnable:function(){this.vars.user.userGroups=shmi.visuals.session.UserManager.currentUser.groupList,this.vars.user.username=shmi.visuals.session.UserManager.currentUser.name,getUser(this),!0===this.config["show-group"]&&function setUserGroup(e){var t=null,s=null,n=e.vars.user.userGroups;void 0!==!shmi.getUiElement("user-info-group",e.element)?(t=shmi.getUiElement("user-info-group",e.element),s=(n=n.filter((function(e){return 0!==e.indexOf("@")})))[0]&&!n[0].includes("@")?n[0]:"Default",t.textContent=s):i('Dom-Element "user-info-group" not found!')}(this)}}};shmi.requires("visuals.tools.control-generator").generate(s)}(),shmi.pkg("visuals.controls.panel"),shmi.visuals.controls.View=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"name",null),shmi.def(this.config,"class-name","view inner-layout"),shmi.def(this.config,"index",0),"string"==typeof this.config.index&&(this.config.index=parseInt(this.config.index)),this.parentContainer=null,this.controls=[],this.active=!1,this.initialized=!1,this.startup()},shmi.visuals.controls.View.prototype={isContainer:!0,uiType:"view",getClassName:function(){return"View"},onRegister:function(e){this.parseChildren(this.element,e)},onInit:function(){this.index=this.config.index,shmi.removeClass(this.element,"ctrl")},onEnable:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].enable()},onDisable:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].disable()},onLock:function(){this.controls.forEach((function(e){e.lock()}))},onUnlock:function(){this.controls.forEach((function(e){e.unlock()}))},getIndex:function(){return this.index},onAddControl:function(e,t){var i=this,s=shmi.requires("visuals.tools.controller"),n=[],a=null;if(!i.initialized)throw new Error("Control not initialized yet.");Array.isArray(e)||(e=[e]),e.forEach((function(e){var t=shmi.createControl(e.ui,i.element,e.config,"DIV",null,!1);if(null!==t){if(e.style&&"object"==typeof e.style){shmi.requires("visuals.tools.iterate.iterateObject")(e.style,(e,i)=>{t.element.style[i]=e})}n.push(t)}})),(a=shmi.waitOnInit(n,(function(){var l=-1,o=[],r=shmi.requires("visuals.task"),c=[],u=null;a&&(-1!==(l=i._init_.tokens.indexOf(a))&&i._init_.tokens.splice(l,1),a.unlisten(),a=null),e.forEach((function(e,t){var a=null,l=n[t];e.controller&&s.create(e.controller.name,e.controller,l.getName()),i.isActive()&&l.enable(),Array.isArray(e.children)&&e.children.length&&((a=r.createTask("child control")).run=function(){l.addControl(e.children,(function(e,t){e&&o.push(e),a.complete()}))},c.push(a))})),c.length?((u=r.createTaskList(c,!1)).onComplete=function(){t(o.length?o[0]:null,n)},u.run()):t(o.length?o[0]:null,n)})))&&i._init_.tokens.push(a)}},shmi.extend(shmi.visuals.controls.View,shmi.visuals.core.BaseControl);