# README datalayer.register.method

## Introduction

The sample app is based on the SDK sample __datalayer.register.node__ it creates a new Data Layer folder '__sample-cpp-registermethod__' with one method, which can calculate the square root of the input.

## Prerequisite

* This sample is based on the V1.20 SDK.
* To build it use a V1.20 SDK and App Build Environment and place it besides the other C++ samples at ctrlx-automation-sdk/samples-cpp/
* To test it install the snap on a ctrlX CORE (virtual) V1.20

## Functional Description

It demonstrates how you can create a method in the Data Layer.
This node can be accessed by a Data Layer client app e.g. ctrlX-Node-RED.
The metadata of the node is provided by a metadata database.

## Implementation Description

All actions are implemented in main.cpp:

* Start Data Layer system
* Connect as Data Layer provider
* Connect as Data Layer client
* Create a Data Layer scope
* Register metadata database
* Register the node in the datalayer
* Endless loop where the Data Layer connection is observed
* Shutdown if the Data Layer connection is broken


!!! important
    If the app is running as snap on a ctrlX CORE it will be restarted if it has exited on error. 

## Build and Install the Snap

Build and install the snap like described [here](../README.md).

## Test the Snap

* Open the web interface of your ctrlX CORE
* Check output in the web interface
* Try to calculate the sqrt

___

## License

MIT License

Copyright (c) 2020-2022 Bosch Rexroth AG

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
