const FS_COOKIE_KEY_VAL = "="
const FS_COOKIE_PAIRS = ";"
const SHOW_WS_TELEGRAMS = false

const ROW_DATA_FIRST = 0; // first table row with data
const sColorBody = "#f0fafa";
const sColorOn = "rgb(217, 255, 217)"
const sColorOff = "";  // must be an empty string
const sColorTableHeader = "lightgray";
const sColorTableContent = "#f7f7f7";
const iTimeOut = 1000; // in [ms]

const sAT_START = "@AtStart"
const sNONE = "@None"
const sINVALID = "@Invalid"
const sIDENTIFIER = "@Identifier"
const sINPUT = "@Input"
const sOK = "ok";
const sCANCEL = "cancel"

const sProjectLoad = '{"cmd":"project.load","data":"MyFancyProject"}"';

const cmdLogin = { "cmd": "user.login", "data": { "username": "importer", "password": "123456789" } };
const cmdLogout = { "cmd": "user.logout", "data": {} };

const cmdConnectLogGet = { "cmd": "connect.log.get", "data": {} }
const cmdConnectLogSet = {
  "cmd": "connect.log.set",
  "data": {
   "file_path": "",
   "file_severity": "info",
   "file_size_limit": MAX_SIZE_LOG_FILE,
   "std_severity": "info"
  }
 }
const cmdWorkspaceInfo = { "cmd": "workspace.info", "data": "_Guid" };
const cmdWorkspaceRecover = { "cmd": "workspace.recover", "data": "_Guid" };
const cmdVariableList = { "cmd": "experimental.structure_store.variable.list", "data": {} };
const cmdVariableGet = { "cmd": "experimental.structure_store.variable.get", "data": { "name": "" } }
const cmdVariableDel = { "cmd": "experimental.structure_store.variable.del", "data": { "name": "" } }
const cmdFsLs = { "cmd": "fs.ls", "data": ["Path"] }
const cmdFsOpen = {
  "cmd": "fs.open",
  "data": {
    "path": "fileName",
    "open_mode": ["in", "out"],
    "force": true
  }
}
// when count is not provided, server sends multiple responses, when file is to big for 1 response telegram
const cmdFsRead = { "cmd": "fs.read", "data": { "file_id": 0, "count": 1000 } }
const cmdFsClose = { "cmd": "fs.close", "data": 0 } // data=file id

const cmdProjectLoad = { "cmd": "project.load", "data": "_projectName" }
const cmdioExtBrowse = {
  "cmd": "io_extension.browse",
  "data": {
    "name": "ctrlX",
    "node_id": {
      "node": "plc/app/Application/sym",
      "namespace": 8
    }
  }
};
const cmdAlarmList = { "cmd": "alarm.list", "data": {} }
const cmdTrendList = { "cmd": "trend.list", "data": {} }
const cmdTrendItemList = { "cmd": "trend.item.list", "data": {} }
const cmdRecipeTemplateList = {
  "cmd": "recipe.template.list",
  "data": {
    "include_items": true,
    "include_metadata": false
  }
}
let wiqVar
let sLang_gb = "en"
let arTableCol =
  [
    { name: "name", lang: "${l.name}", fctParse: parseName, width: "400px", align: "L", show: true, edit: null },
    { name: "label", lang: "${l.label}", fctParse: null, width: "100px", align: "L", show: true, edit: [sINPUT, sIDENTIFIER, sNONE] },
    { name: "interval", lang: "${l.interval}", fctParse: parseInt, width: "70px", align: "R", show: true, edit: [sINPUT, sNONE, sAT_START, "1", "10", "50", "100", "200", "500"] },
    { name: "source", lang: "${l.source}", fctParse: parseToLower, width: "90px", align: "L", show: true, edit: null },
    { name: "unit", lang: "${l.unit}", fctParse: parseName, width: "100px", align: "L", show: true, edit: [sINPUT, sNONE] },
    { name: "digits", lang: "${l.digits}", fctParse: parseName, width: "60px", align: "R", show: true, edit: [sINPUT, sNONE, "0", "1", "2", "3", "4"] },
    { name: "check", lang: "${l.check}", fctParse: parseName, width: "190px", align: "R", show: true, edit: null },
    { name: "type", lang: "${l.type}", fctParse: parseToLower, width: "100px", align: "L", show: true, edit: null },
    { name: "arSize", lang: "${l.arraySize}", fctParse: parseName, width: "80px", align: "R", show: true, edit: [sINPUT, "1", "10", "20"] },
    { name: "limitsMin", lang: "${l.min}", fctParse: parseName, width: "50px", align: "R", show: true, edit: [sINPUT, sNONE, "1", "10", "20", "50", "100"] },
    { name: "limitsMax", lang: "${l.max}", fctParse: parseName, width: "50px", align: "R", show: true, edit: [sINPUT, sNONE, "1", "10", "20", "50", "100"] }
  ];
function getColID(sColName) {
  const fctFind = (col) => col.name === sColName;
  return arTableCol.findIndex(fctFind);
}

const COL_ITEM = getColID("name")
const COL_LABEL = getColID("label")
const COL_INTERVAL = getColID("interval")
const COL_SOURCE = getColID("source")
const COL_UNIT = getColID("unit")
const COL_DIGITS = getColID("digits")
const COL_TYPE = getColID("type")
const COL_CHECK = getColID("check")
const COL_ARSIZE = getColID("arSize")
const COL_LIMITS_MIN = getColID("limitsMin")
const COL_LIMITS_MAX = getColID("limitsMax")

let tableData = {
  bReverse: false,
  iColSort: 0,
  iRowsAll: 0,
  iRowsVisible: 0,
  iRowsSelected: -1,
  iRowFirst: -1,
  iRowLast: -1,
}
var l = {} // json with translation texts
let arList = [];  // content used to fill table cells
let table = null; // table with displayed data
let tableHeader = null; // header is extra table => always visible at scrolling
let iProjectLoadId = -1; // 1-:display selct list, for multiple projects >=0: id of loaded project