'  ========================================================
' Installes WebIQ Designer AddOn into workspace directories
'    AddOn provides important features, 
'    which are currently missing in WebIQ Designer
'
' 2023-01-17 Add folder name to install request
' 2023-01-13 First release
'  ========================================================

' Get command line arguments
Set myArgs = WScript.Arguments.Unnamed
bAll = false
bAdd = true
bSilent = false

for i = 0 to myArgs.count-1
  if myArgs.item(i)="del" then
    bAdd = false
  elseif myArgs.item(i)="all" then
    bAll = true
  elseif myArgs.item(i)="silent" then
    bSilent = true
  end if 
next

Set wshShell = CreateObject( "WScript.Shell" )
appData = wshShell.ExpandEnvironmentStrings( "%APPDATA%" )

Set objFSO = CreateObject("Scripting.FileSystemObject")
Set objFolder = objFSO.GetFolder(appData)
Set objSubFolders = objFolder.SubFolders
sSource  = "addon"  ' directory name of addon
sAppInfo = "\workspace\.designer\app-info.json" ' webIQ file with app info (e.g. project name)

' Read version of AddOn
sVersionNew = "???"
sFileVersion = sSource + "\json\version.txt"
if objFSO.FileExists(sFileVersion) then
  Set oFile = objFSO.OpenTextFile (sFileVersion, 1)
  sVersionNew = oFile.Readline
  oFile.Close
end if

' Count WebIQ workspaces with project
iProjects = 0
For each objSubFolder In objSubFolders
  sFile = objSubFolder + sAppInfo
  if objFSO.FileExists(sFile) Then
    iProjects = iProjects + 1
  End if
Next

if (iProjects=0) Then 
  sInstalled = "No WebIQ projects in workspace found." + vbCrLf + "You must load a project, before you can install the AddOn"
  call MsgBox(sInstalled, vbOkOnly+vbCritical, "Info")
else
  ' loop over all workspace project & ask if add should be installed
  iProject = 0
  For each objSubFolder In objSubFolders
    sTarget = objSubFolder + "\workspace\"
    sDir    = sTarget + sSource
    arWords = split(objSubFolder, "\")
    sFile = objSubFolder + sAppInfo
    if objFSO.FileExists(sFile) Then
      iProject = iProject + 1
      sFileWebIq = sTarget + "\webiq.json"
      sInfo = "Workspace " + CStr(iProject) + " of " + CStr(iProjects)

      if bAll then
        oAnswer = vbYes
      else
        oAnswer = MsgBox("Do you want to install '" + sVersionNew + "' ?" + vbCrLf + vbCrLf + _
                  "Project:       " + getProjectName(sFileWebIq) + vbCrLf + _
                  "Folder:        " + getProjectFolder(sFile) + vbCrLf + _
                  "AddOn:        "  + getAddonVersion(sDir) + vbCrLf + _
                  "Workspace: "     + arWords(uBound(arWords)) , _
                  vbYesNo+vbQuestion, _
                  "Install " + sInfo)
      end if
      If (oAnswer=vbYes) Then
        if (bAdd) then
          Call objFSO.CopyFolder(sSource,sTarget)
        else
          sTmp = sTarget + sSource
          if (objFSO.FolderExists(sTmp)) then
            Call objFSO.DeleteFolder(sTmp)
          end if
        End if
      End if
    End if
  Next
  if (bAll) then
    
    if (bAdd) then
      sAction = "installed"
      sXXX = getAddonVersion(sDir)
    else
      sAction = "deleted"
      sXXX = "AddOn"
    end if
    if (bSilent=false) then
      call MsgBox(sXXX + " " + sAction + " in " + CStr(iProjects) + " projects", vbInformation, "Info")
    end if
  end if
end if

' returns version of add on or string "not installed"
function getAddonVersion(sDir)
  getAddonVersion = "not installed"

  sFileVersion = sDir + "\json\version.txt"
  if objFSO.FileExists(sFileVersion) then
    Set oFile = objFSO.OpenTextFile (sFileVersion, 1)
    getAddonVersion = oFile.Readline
    oFile.Close
  end if
end function

' Returns project name, read form webiq.json
function getProjectName(sFile)
    getProjectName = "???"
    if objFSO.FileExists(sFile) then
      Set oFile = objFSO.OpenTextFile (sFile, 1)
      Do Until oFile.AtEndOfStream
        sText = trim(oFile.Readline)
        if (left(sText,7) = """name"":") then
          getProjectName = trim(mid(sText,8))
          exit function
        end if
      Loop
      oFile.Close
    end if
end function

' Returns project name, read form webiq.json
function getProjectFolder(sFile)
    getProjectFolder = "???"
    sContent = ""
    if objFSO.FileExists(sFile) then
      Set oFile = objFSO.OpenTextFile (sFile, 1)
      Do Until oFile.AtEndOfStream
        sText = trim(oFile.Readline)
        sContent = sContent + sText
      Loop
      oFile.Close
      ' "app_name":"HMI-Template-v1.1c"
      arW = split(sContent, ",")
      for each sWord in arW
        sWord = trim(sWord)
        sKey = """app_name"""
        arX = split(sWord + ":::", ":")
        sW1 = trim(arX(0))
        'MsgBox( "|" + sW1 + "|" + vbCrLf + "|" + sKey + "|")
        if sW1 = sKey then
          getProjectFolder = trim(arX(1))
          exit function
        end if
      Next
    end if
end function
