function saveExport(sData) {
  const anchor = document.createElement("a")

  anchor.href = `data:text/csv;charset=utf-8,${encodeURIComponent(sData)}`
  anchor.href = `data:text/csv;charset=8859,sData}`
  
  anchor.download = `languages.csv`
  anchor.click()
  anchor.remove()
}
/**
 * Creates a single CSV file with all languages
 */
 async function exportLanguagesCsv() {
  // read list with existing languages
  let sFile = FILE_LANGUAGES
  let sContent = await fetchTextFile(sFile)
  let jContent = JSON.parse(sContent)
  let bFirst = true
  let jExport = {}
  let sExport = ""
  const FS = "\t"
  const NL = "\n"

  let arHeader = ["variable"]
  // store all languages in a json object
  for (let lang in jContent.locales) {
    arHeader.push(lang)
    // read translation file
    sFile = DIR_LANG + lang + ".json"
    sContent = await fetchTextFile(sFile)
    let jLang = JSON.parse(sContent)
    for (let sVar in jLang) {
      if (bFirst) {
        jExport[sVar] = []
      }
      if (jExport[sVar]) {
        jExport[sVar].push(jLang[sVar])
      }
    }
    bFirst = false
  }
  //*** create export string ***
  // create column header
  for (let i = 0; i < arHeader.length; i++) {
    sExport += arHeader[i] + FS
  }
  sExport += NL
  const iColMax = arHeader.length - 1
  // create column data
  for (let sKey in jExport) {
    sExport += sKey + FS
    for (let iCol = 0; iCol < iColMax; iCol++) {
      sExport += jExport[sKey][iCol] + FS
    }
    sExport += NL
  }
  saveExport(sExport)
  console.log(sExport)
}
/**
 * creates a translation file with selected languages
 */
async function createTranslationCsv() {
  let jCmd = {};
  let jRespLsDir = {};
  let jResp = {};
  let sPath = "/json/locale/lang";
  let sContent = "";

  //let iId = 10;

  // set name of project to connect to
  sTarget = sWsGuid;

  // setup fs.ls command
  jCmd = cmdFsLs;
  cmdFsLs.data = [sPath];
  jRespLsDir = await wsSendRecv(jCmd).catch((err) => { abortJS(err.message); });

  for (let i = 0; i < jRespLsDir.data[0].listing.files.length; i++) {
    console.log("***" + jRespLsDir.data[0].listing.files[i].name + "***");

    let sFile = sPath + "/" + jRespLsDir.data[0].listing.files[i].name;
    sContent = await readTextFile(sFile)
  }
  await msgBox("info", "Export done")
}