"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Host = void 0;
const urlModule = require("url");
class Host {
    /**
     * Creates a new Host instance.
     * @param url
     * @param backoff
     */
    constructor(url, backoff, options) {
        this.backoff = backoff;
        this.options = options;
        this.url = urlModule.parse(url);
    }
    /**
     * Marks a failure on the host and returns the length of time it
     * should be removed from the pool
     * @return removal time in milliseconds
     */
    fail() {
        const value = this.backoff.getDelay();
        this.backoff = this.backoff.next();
        return value;
    }
    /**
     * Should be called when a successful operation is run against the host.
     * It resets the host's backoff strategy.
     */
    success() {
        this.backoff = this.backoff.reset();
    }
}
exports.Host = Host;
