/// <reference types="node" />
import { RequestOptions } from "https";
import * as urlModule from "url";
import { IBackoffStrategy } from "./backoff/backoff";
export declare class Host {
    private backoff;
    readonly options: RequestOptions;
    readonly url: urlModule.Url;
    /**
     * Creates a new Host instance.
     * @param url
     * @param backoff
     */
    constructor(url: string, backoff: IBackoffStrategy, options: RequestOptions);
    /**
     * Marks a failure on the host and returns the length of time it
     * should be removed from the pool
     * @return removal time in milliseconds
     */
    fail(): number;
    /**
     * Should be called when a successful operation is run against the host.
     * It resets the host's backoff strategy.
     */
    success(): void;
}
