"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExponentialBackoff = void 0;
/**
 * Exponential Backoff
 * @see https://en.wikipedia.org/wiki/Exponential_backoff
 */
class ExponentialBackoff {
    /**
     * Creates a new exponential backoff strategy.
     * @see https://en.wikipedia.org/wiki/Exponential_backoff
     * @param options
     */
    constructor(options) {
        this.options = options;
        this._counter = 0;
    }
    /**
     * @inheritDoc
     */
    getDelay() {
        const count = this._counter - Math.round(Math.random() * this.options.random); // Tslint:disable-line
        return Math.min(this.options.max, this.options.initial * Math.pow(2, Math.max(count, 0)));
    }
    /**
     * @inheritDoc
     */
    next() {
        const next = new ExponentialBackoff(this.options);
        next._counter = this._counter + 1;
        return next;
    }
    /**
     * @inheritDoc
     */
    reset() {
        return new ExponentialBackoff(this.options);
    }
}
exports.ExponentialBackoff = ExponentialBackoff;
