"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstantBackoff = void 0;
/**
 * Constant Backoff
 */
class ConstantBackoff {
    /**
     * Creates a new constant backoff strategy.
     * @param options
     */
    constructor(options) {
        this.options = {
            delay: Math.max(options.delay, 0),
            jitter: Math.min(Math.max(options.jitter || 0, 0), 1),
        };
    }
    /**
     * @inheritDoc
     */
    getDelay() {
        let delay = this.options.delay;
        if (this.options.jitter > 0) {
            const min = delay * (1 - this.options.jitter);
            const max = delay * (1 + this.options.jitter);
            delay = Math.random() * (max - min) + min;
        }
        return delay;
    }
    /**
     * @inheritDoc
     */
    next() {
        return this;
    }
    /**
     * @inheritDoc
     */
    reset() {
        return this;
    }
}
exports.ConstantBackoff = ConstantBackoff;
