import { IBackoffStrategy } from "./backoff";
/**
 * IConstantOptions are passed into the ConstantBackoff constructor. The
 * backoff equation is, the simplest possible, a constant delay with an
 * optional jitter, delay*(1-random_jitter) and delay*(1+random_jitter).
 *
 */
export interface IConstantOptions {
    /**
     * The constant delay passed to the equation.
     */
    delay: number;
    /**
     * Random factor between 0 and 1 to avoid the thundering herd problem.
     */
    jitter?: number;
}
/**
 * Constant Backoff
 */
export declare class ConstantBackoff implements IBackoffStrategy {
    protected options: IConstantOptions;
    /**
     * Creates a new constant backoff strategy.
     * @param options
     */
    constructor(options: IConstantOptions);
    /**
     * @inheritDoc
     */
    getDelay(): number;
    /**
     * @inheritDoc
     */
    next(): IBackoffStrategy;
    /**
     * @inheritDoc
     */
    reset(): IBackoffStrategy;
}
