<p align="center">
  <img src="https://raw.github.com/node-influx/node-influx/master/logo.png?v3" alt="node-influx, an InfluxDB client for Node.js and Browsers">
</p>

<hr/>

<p align="center">
  <b><!--An InfluxDB Client for Node.js and Browsers--></b>
</p>

<p align="center">
 <a href="https://github.com/node-influx/node-influx/actions">
    <img src="https://img.shields.io/github/workflow/status/node-influx/node-influx/CI/master?style=flat-square"
         alt="CI Status">
  </a>
  <a href="">
    <img alt="Coveralls github branch" src="https://img.shields.io/coveralls/github/node-influx/node-influx/master.svg?style=flat-square">
  </a>
  <a href="https://www.npmjs.com/package/influx">
    <img src="https://img.shields.io/npm/v/influx.svg?style=flat-square"
          alt="NPM Version">
  </a>
  <a href="https://www.npmjs.com/package/influx">
    <img src="https://img.shields.io/npm/dm/influx.svg?style=flat-square"
         alt="NPM Downloads">

  </a>
</p>

# InfluxDB v1.x JavaScript library

Node and browser library for InfluxDB v1.x and older. For v2, please use the [official client](https://github.com/influxdata/influxdb-client-js/).

<hr/>

## Installation

For Node, simply:

    $ npm install --save influx

For browsers, see the [browser setup](https://node-influx.github.io/manual/usage.html#browser-setup) instructions.

## Features

- Simple API for nearly all Influx operations
- Fully supported in Node and the browser
- Performant, processing millions of rows/sec on modest hardware
- Zero dependencies

## Compatibility

Version 5.x.x is compatible with InfluxDB 1.x on Node 4 on onwards, and modern browsers

Version 4.x.x is compatible with InfluxDB 0.9.x - 0.13.x on Node 0.12 and onwards

Version 3.x.x is compatible with InfluxDB 0.8.x - 3.x will no longer have updates by core contributers, please consider upgrading.

## Usage

- [API Documentation](https://node-influx.github.io/class/src/index.js~InfluxDB.html)
- [Tutorials & Examples](https://node-influx.github.io/manual/tutorial.html)
- [Changelog](https://node-influx.github.io/manual/changelog.html)
- [Contributing](CONTRIBUTING.md)
