
#include <stdio.h>
#include <iostream>

#include "comm/datalayer/datalayer.h"
#include "comm/datalayer/datalayer_system.h"


static std::string getConnectionString(
    const std::string& ip = "192.168.1.1",
    const std::string& user = "boschrexroth",
    const std::string& password = "boschrexroth",
    int sslPort = 443)
{

    std::string connectionString = DL_TCP + user + std::string(":") + password + std::string("@") + ip;

    if (443 == sslPort)
    {
        return connectionString;
    }

    return connectionString + std::string("?sslport=") + std::to_string(sslPort);
}


int main()
{

    int counter = 1;

    comm::datalayer::Variant data;
    comm::datalayer::DlResult result;
    comm::datalayer::DatalayerSystem datalayerSystem;
    datalayerSystem.start(false);
    std::cout << getConnectionString() << std::endl;
    // creating the Data Layer Client
    //comm::datalayer::IClient2* dataLayerClient = datalayerSystem.factory()->createClient2(getConnectionString());
    comm::datalayer::IClient* dataLayerClient = datalayerSystem.factory()->createClient(getConnectionString());
    if (dataLayerClient->isConnected())
    {
        std::cout << "Bingo! it is connected" << std::endl;
    }
    else {
        std::cout << "Client is not connected" << std::endl;
    }

    //endless loop 
    for (int p = 0; p < 1000; p++)
    {
        //std::string co = "ping 192.168.1.1";
        //std::system(co.c_str());
        //std::cout << "Loop #" << counter++ << std::endl;

       

        //Synchronous read to the Data Layer path "framework/met..."
        result = dataLayerClient->readSync("plc/app/Application/sym/PLC_PRG/iI", &data);

        if (result == DL_OK) {
            std::cout << "stored value at destination " << double(data) << " %" << std::endl;
        }
        else {
            std::cout << "Reading failed with: " << result.toString() << std::endl;
        }



        std::cout << "Sleeping..." << std::endl;
    }

    delete dataLayerClient; // Callbacks are no more called
}
