#ifndef MY_BSEC_H
#define MY_BSEC_H

#include <QObject>
#include <QDebug>
#include <bsec_interface.h>
#include <bsec_datatypes.h>
#include <QFile>


class My_BSEC : public QObject
{
    Q_OBJECT

public:
    explicit My_BSEC(QObject *parent = nullptr);
    void init();
    void sensorConfiguration();
    void sensorControl();
    bool calculateData(QByteArray inputArray);

    float getIAQ();
    float getCO2Equivalent();
    float getTemperature();
    float getHumidity();
    qint8 getCO2Acc();
    qint8 getIAQAcc();
    float getStaticIAQ();
    bool readState();
    void setStateDataFile(QFile *stateDataFile);
    void setSaveCycles(int cycles);
private:
    QFile *stateDataFile;
    bsec_bme_settings_t BSECBMESettings;
    const static quint8 NR_BSEC_INPUTS = 3;
    bsec_input_t  bsecInputs[NR_BSEC_INPUTS];
    bsec_output_t bsecOutputs[BSEC_NUMBER_OUTPUTS];
    quint8 nrBSECOutputs;
    float getSensorSingal(uint8_t outputSensorID);
    qint8 getSensorAcc(uint8_t outputSensorID);
    bool writeState();
    int saveCycles = 0;
    int curCycle = 0;
};

#endif // MY_BSEC_H
