#include <QCoreApplication>
#include <QTextStream>
#include <QDebug>
#include "my_bsec.h"
#include <QCommandLineParser>


// pass this into prompt to trigger the errorneous behaviour
/*
0 F105C79AB0000014279641C1DE6847DB23704231A17048
1 F105C79AB0000014279641C1DE6847DB23704231A17049
*/
// --> BSEC warning: 4
// BSEC did no steps! Timestamp:  2.59673e+06
// from bsec_datatypes.h:   BSEC_W_DOSTEPS_TSINTRADIFFOUTOFRANGE = 4,       /*!< Duplicate timestamps passed to bsec_do_steps() */


int main(int argc, char *argv[])
{
    QCoreApplication a(argc, argv);
    QCoreApplication::setApplicationName("BME680 IAQ calculator");
    QCoreApplication::setApplicationVersion("1.0");

    QCommandLineParser parser;
    parser.addHelpOption();
    parser.addVersionOption();
    parser.process(a);

    QTextStream streamIn(stdin);
    QTextStream streamOut(stdout);
    QString line;

    My_BSEC bsec[2];

    streamOut << "Init complete. Waiting for user input: SensorId (here 0 or 1) + rawData\n\n";

    while(1){
        while (streamIn.readLineInto(&line)) {
            bool idOk;
            uint8_t bsecId = QString(line.at(0)).toUInt(&idOk);
            if (!idOk)
            {
                streamOut << "Put the id of the sensor first! '0' or '1', followed by a space in this minimal example...\n" << Qt::flush;
                continue;
            }
            line.remove(0,2);
            bool ret = bsec[bsecId].calculateData(line.toUtf8());
                if(ret){
                    streamOut << "--> { \"Temperature\":" << bsec[bsecId].getTemperature();
                    streamOut << ",\"Humidity\":" << bsec[bsecId].getHumidity();
                    streamOut << ",\"Pressure\":0";
                    streamOut << ",\"IAQ\":[" << bsec[bsecId].getIAQ() << ',' << bsec[bsecId].getIAQAcc() << ']';
                    streamOut << ",\"sIAQ\":[" << bsec[bsecId].getStaticIAQ() << ',' << bsec[bsecId].getIAQAcc()<< ']';
                    streamOut << ",\"CO2_Equivalent\":[" << bsec[bsecId].getCO2Equivalent() << ',' << bsec[bsecId].getCO2Acc()<< "]}\n"<< Qt::flush;
            }
        }
    }

    return EXIT_SUCCESS;
}
