#include <Wire.h>

//Inclino
#define INC_ADDRESS 0x68
#define ACC_CONF  0x20  //Page 91
#define GYR_CONF  0x21  //Page 93
#define CMD       0x7E  //Page 65

/*! Earth's gravity in m/s^2 */
#define GRAVITY_EARTH  (9.80665f)

int16_t x, y, z;
int16_t gyr_x, gyr_y, gyr_z;

int16_t  temperature = 0;
float     temperatureInDegree = 0.f;

unsigned long timer = 0;
int divider = 1;

float print_ms = 200;

void setup(void) {  
  Serial.begin(115200); 
  //Accelerometer
  Wire.begin();  
  //Wire.setClock(400000);      // I2C Fast Mode (400kHz)  
  timer = millis();
  print_ms = millis();
  softReset();  
  
  //writeRegister16(0x10,0x0000);//Setting I²C bus 

  
  /*
   * Acc_Conf P.91
   * ODR:         0x000B  -> 800Hz
   * range:       0x0000  -> 2G
   * filtering:   0x0000  -> ODR/2
   * average:     0x0600  -> 64 sample
   * mode:        0x7000  -> High
   * Total:       0x760B
   * 0111000000001011
   */
  writeRegister16(ACC_CONF,0x760C);//Setting accelerometer  
  delay(50);   
  /*
   * Gyr_Conf P.93
   * mode:        0x7000  -> High
   * average:     0x0600  -> 64
   * filtering:   0x0000  -> ODR/2
   * range:       0x0000  -> 125kdps
   * ODR:         0x000B  -> 800Hz
   * Total:       0x760B
   */
  writeRegister16(GYR_CONF,0x760E);//Setting gyroscope  
  //writeRegister16(GYR_CONF,0x708B);//Setting gyroscope    

  delay(50);    
  
}

void softReset(){  
  writeRegister16(CMD, 0xDEAF);
  delay(50);     
}

void loop() {
  static float deltat = 0;  //loop time in seconds
  static unsigned long now = 0, last = 0; //micros() timers

  //Serial.print("rdy ?= ");
  //Serial.println(readRegister16(0x02), HEX);
    
  if(readRegister16(0x02) == 0xC0) {   
    readAllAccel();
    now = millis();
    if(now - print_ms > 200){
      Serial.print("time:");
      Serial.print(now - print_ms);   
      print_ms = now;
      //Read ChipID
      //Serial.print("ChipID:");
      //Serial.print(readRegister16(0x00));    
      //*
      Serial.print(" \tx:");
      Serial.print(x);
      Serial.print(" \ty:");
      Serial.print(y);
      Serial.print(" \tz:");
      Serial.print(z);
      Serial.print(" \ttemp:");
      Serial.print(temperatureInDegree);    
      //*/
      
      Serial.println();
    }
  }

}

//Write data in 16 bits
void writeRegister16(int16_t reg, int16_t value) {
  Wire.beginTransmission(INC_ADDRESS);
  Wire.write(reg);
  //Low 
  Wire.write((int16_t)value & 0xff);
  //High
  Wire.write((int16_t)value >> 8);
  Wire.endTransmission();
}

//Read data in 16 bits
int16_t readRegister16(int16_t reg) {
  Wire.beginTransmission(INC_ADDRESS);
  Wire.write(reg);
  Wire.endTransmission(false);
  int n = Wire.requestFrom(INC_ADDRESS, 4);  
  int16_t data[20];
  int i =0;
  while(Wire.available()){
    data[i] = Wire.read();
    i++;
  }  
  return ((int16_t)data[2]   | (int16_t)data[3] << 8);
}

//Read all axis
void readAllAccel() {
  Wire.beginTransmission(INC_ADDRESS);
  Wire.write(0x03);
  Wire.endTransmission();
  Wire.requestFrom(INC_ADDRESS, 16);
  int16_t data[16];
  int i =0;
  while(Wire.available()){
    data[i] = Wire.read();
    i++;
  }

  //Offset = 2 because the 2 first bytes are dummy (useless)
  int offset = 2;  
  
  //*
  x =             ((int16_t) (data[offset + 1] << 8   | (int16_t) data[offset + 0]));  //0x03
  y =             ((int16_t) (data[offset + 3] << 8   | (int16_t) data[offset + 2]));  //0x04
  z =             ((int16_t) (data[offset + 5] << 8   | (int16_t) data[offset + 4]));  //0x05
  //*/
  
  gyr_x =         ((int16_t) data[offset + 7] << 8   | (int16_t) data[offset + 6]);  //0x06
  gyr_y =         ((int16_t) data[offset + 9] << 8   | (int16_t) data[offset + 8]);  //0x07
  gyr_z =         ((int16_t) data[offset + 11] << 8  | (int16_t) data[offset + 10]); //0x08
  temperature =   ((int16_t) data[offset + 13] << 8  | (int16_t) data[offset + 12]); //0x09
  temperatureInDegree = (temperature/512.0) + 23.0;
}

