#from ctrxpy import motion
#from ctrxpy import datalayer

sNode_bTest = '/plc/app/Application/sym/GVL_BASE/bPyFlag'
sNode_sTest = '/plc/app/Application/sym/GVL_BASE/strPyInfo'
sNode_iStopPython = '/plc/app/Application/sym/GVL_BASE/iPyStop'

# Returns True, if posAct is in range around posTarget
def isInRange(valAct, valCompare):
    rOffset = 0.01
    rMin = valCompare - rOffset
    rMax = valCompare + rOffset
    return (valAct > rMin) and (valAct < rMax)

# returns true, if x,y,z axes of kinematic is in range around provides positions
def kinInPos(x,y,z):
    bX = isInRange(motion.get_axs_ipo_values("X").get("pos"), x)
    bY = isInRange(motion.get_axs_ipo_values("Y").get("pos"), y)
    bZ = isInRange(motion.get_axs_ipo_values("Z").get("pos"), z)
    return bX and bY and bZ


motion.attach_obj("X")
motion.attach_obj("Y")
motion.attach_obj("Z")
motion.attach_obj("Robot")

datalayer.write(sNode_sTest, "*** MOVE to start position ***")
motion.kin_cmd_move_lin_abs(kin="Robot",pos=[0,0,0],coord_sys="ACS",vel=100,acc=100,dec=100,jrk_acc=0,jrk_dec=0)
while not kinInPos(0,0,0):
    pass

# number of cycles to run
i = 4
# velocity for movements
rVel = 10
bTest = False
while (i > 0):
    # set info for debug visu
    sTest = "MOVE: Cycles to go {}".format(i)
    i -= 1
    datalayer.write(sNode_sTest, sTest)
    bTest = not bTest
    datalayer.write(sNode_bTest, bTest)

    # start some movements
    motion.kin_cmd_move_lin_abs(kin="Robot",pos=[20,0,0],coord_sys="ACS",vel=rVel,acc=100,dec=100,jrk_acc=0,jrk_dec=0)
    while not kinInPos(20,0,0):
        pass

    motion.kin_cmd_move_lin_abs(kin="Robot",pos=[20,20,0],coord_sys="ACS",vel=rVel,acc=100,dec=100,jrk_acc=0,jrk_dec=0)
    motion.kin_cmd_move_lin_abs(kin="Robot",pos=[20,20,20],coord_sys="ACS",vel=rVel,acc=100,dec=100,jrk_acc=0,jrk_dec=0)
    while not kinInPos(20,20,20):
        pass
    #time.sleep(0.1)

motion.detach_obj("X")
motion.detach_obj("Y")
motion.detach_obj("Z")
motion.detach_obj("Robot")

datalayer.write(sNode_sTest, "*** MOVE: Python script finished ***")
exit(0)