' Windows has no build in SVG preview. Therefore this script
' Creates a _SvgImages.htm with all svg files in current directory

sImgWidth = "40"               ' width of image in html page
sFileName = "_ImgPreview.htm"  ' name of htm file
sBgColor  = "lightblue"

Set objFSO = CreateObject("Scripting.FileSystemObject")
iLenPath = Len(Wscript.ScriptFullName) - Len(Wscript.ScriptName)
sStartFolder = LEFT(Wscript.ScriptFullName, iLenPath)

Set objFolder = objFSO.GetFolder(sStartFolder)

sOutFile = sStartFolder & sFileName

Set fsoOut = objFSO.CreateTextFile(sOutFile,True)

fsoOut.WriteLine "<!DOCTYPE html>" 
fsoOut.WriteLine "<head>"
fsoOut.WriteLine "</head>"
fsoOut.WriteLine "<body style=""background-color:" & sBgColor & ";"">"
    
Set colFiles = objFolder.Files

For Each objFile in colFiles
    sExt = LCase(Right(objFile.Name, 3))
    If (sExt = "svg") OR (sExt="png") OR (sExt="jpg") Then
       fsoOut.WriteLine "<img width=" & sImgWidth & " src=""" & objFile.Name & """ title=""" & objFile.Name & """>"
    End If
Next
fsoOut.WriteLine " </body>"

fsoOut.Close
Wscript.Echo "Created file " & sOutFile & vbCrLf & "Open it to display preview of all svg graphics in this folder."