/**
 * Visuals - Industrial Visualization Framework for JavaScript
 *
 * Copyright © 2012-2024 Smart HMI GmbH
 *
 * All rights reserved
 *
 * No part of this website or any of its contents may be reproduced, copied, modified or
 * adapted, without the prior written permission of Smart HMI.
 *
 * Commercial use and distribution of the contents of the website is not allowed without
 * express and prior written permission of Smart HMI.
 *
 *
 * Web: http://www.smart-hmi.de
 *
 * @version 2.15.7 c927faeb.44385 25-01-2024 14:05:49
 */

var shmi=shmi||{};shmi.visuals=shmi.visuals||{},shmi.visuals.Version="2.15.7",shmi.visuals.BuildDate="25-01-2024 14:05:49",shmi.visuals.Build="44385",shmi.visuals.Revision="c927faeb",console.log("Smart HMI visuals Version 2.15.7 c927faeb.44385 built at 25-01-2024 14:05:49"),shmi.pkg=function(e){for(var t=e.split("."),s=null,n=0,a=shmi;n<t.length;){var r=t[n];0!==n||"shmi"!==r?(a[r]=a[r]||{},a=a[r],n===t.length-1&&(s=a),n++):t.splice(0,1)}return s},shmi.requires=function(e){for(var t=e.split("."),s=null,n=0,a=shmi;n<t.length;){var r=t[n];if(0!==n||"shmi"!==r){if(void 0===a[r])throw new Error("Package not available: "+e);a=a[r],n===t.length-1&&(s=a),n++}else t.splice(0,1)}return s},shmi.c=function(e,t){if(shmi.Constants=shmi.Constants||{},void 0!==t){if(void 0!==shmi.Constants[e])throw Error("ERROR: constant '"+e+"' already defined");shmi.Constants[e]=t}return shmi.Constants[e]},shmi.log=function(e,t){let s=shmi.pkg("visuals.session");if("number"==typeof t){let n=s.config&&"number"==typeof s.config.loglevel?s.config.loglevel:2,a=s.config&&"number"==typeof s.config.alertlevel?s.config.alertlevel:Number.POSITIVE_INFINITY;if((t=null==t?2:parseInt(t))<n)return;t<a?console.log(e):console.error(e)}else"object"==typeof t?s.config&&s.config.debug&&console.log(shmi.evalString(e,t)):s.config&&s.config.debug&&console.log(shmi.evalString(e,{}))},shmi.getUiElements=function(e,t){return t||(t=document.body),t.querySelectorAll("[data-ui="+e+"]")},shmi.getUiElement=function(e,t){t||(t=document.body);var s=null;try{s=t.querySelector("[data-ui="+e+"]")}catch(e){shmi.log("[Helpers] getUiElement - Exception: "+e+" element: "+t,3)}return s},shmi.testParentChild=function(e,t){return e===t||!!t&&(t.parentNode===e||t.parentNode!==document.body&&shmi.testParentChild(e,t.parentNode))},shmi.isVisible=function(e){return e.offsetHeight>0||e.offsetWidth>0},function(){function localizeText(e,t){const s=e;if(!/\${(.+?)}/g.test(e))return e;const n=/\${(.+?)}/g;let a=n.exec(s);for(;a;){const[r,o]=a;let l=shmi.visuals.session.locale[o];t.includes(o)||void 0===l?t.includes(o)&&(e=e.replace(r,`[LOCALE_LOOP: ${[...t,o].join(", ")}]`)):(/\${(.+?)}/g.test(l)&&(l=localizeText(l,[...t,o])),e=e.replace(r,l)),a=n.exec(s)}return e}shmi.localize=function(e){return void 0===shmi.visuals.session.locale?(console.log("[Helpers] locale not loaded yet",2),e):localizeText(e,[])}}(),shmi.ctrl=function(e,t){const s=shmi.requires("visuals.tools.iterate").iterateObject,n=shmi.visuals.session,{HANDLE_PREFIX:a,getNodeElement:r}=shmi.requires("visuals.tools.nodes");let o=null;if("string"==typeof e&&e.startsWith(a)){const t=r(e.replace(a,""));return t?shmi.getControlByElement(t):null}if(t&&t.getName()&&0===e.indexOf(".")){let a=1;const r=e;for(;"."===e.charAt(a);)a++;const l=t.getName().split(".").slice(0,-a),u=".".repeat(a);e=e.replace(u,"");const c=n.names[l.join(".")]?n.names[l.join(".")].ctrl:null;c?s(n.names,(function(t,s){if(null===o&&0===s.indexOf(c.getName())){const t=s.lastIndexOf(e);-1!==t&&t===s.length-e.length&&(o=n.names[s].ctrl)}})):o=shmi.ctrl(r)}else{const t=e.split(" .");let a,r=null;if(t.length>2)o=shmi.ctrl(t[0]+" ."+t[1]),o&&(t.splice(0,2),o=shmi.ctrl(o.getName()+" ."+t.join(" .")));else{if(0===t[0].indexOf(".")?(t[0]=t[0].substr(1),s(n.names,(function(e,s){null===r&&function matchesNameParts(e,t){var s=e.split("."),n=t.split("."),a=null,r=!0;return!(s.length<n.length)&&(s.splice(0,s.length-n.length),n.forEach((function(e,t){var n=s.indexOf(e);-1===n||null!==a&&a!==n-1?r=!1:a=n})),r)}(s,t[0])&&(r=shmi.visuals.session.names[s].ctrl)}))):r=shmi.visuals.session.names[t[0]]?shmi.visuals.session.names[t[0]].ctrl:null,2===t.length){a=t[1].split(".");for(let e=0;e<a.length;e++)r=shmi.getControlByName(a[e],null,r)}o=r||null}}return o},shmi.getControlByName=function(e,t,s){var n,a=null;function isContainer(e){return e&&e.isContainer&&Array.isArray(e.controls)}function hasViews(e){return e&&e.isContainer&&Array.isArray(e.views)}function findInViews(e){for(var t=null,s=0;s<e.views.length&&null===(t=findInContainer(e.views[s]));s++);return t}function findInContainer(t){var s=null;if(Array.isArray(t.controls))for(var n=0;n<t.controls.length;n++)if(t.controls[n].getName()){var a=t.controls[n].getName();if(null==a)return null;var r=t.controls[n].getName().split(".");if(r[r.length-1]===e&&(s=t.controls[n]),null===s&&(hasViews(t.controls[n])?s=findInViews(t.controls[n]):isContainer(t.controls[n])&&(s=findInContainer(t.controls[n]))),null!==s)break}return s}if(!0===shmi.visuals.session.config.lookup_debug&&(n=Date.now()),hasViews(s))a=findInViews(s);else if(isContainer(s))a=findInContainer(s);else{var r=shmi.visuals.session.names;void 0!==r[e]&&(a=r[e].ctrl)}return!0===shmi.visuals.session.config.lookup_debug&&console.log("[Lookup] Control lookup for",a,"took",Date.now()-n,"ms"),a},shmi.getElementByName=function(e,t){return t||(t=document),t.querySelector('[data-name="'+e+'"]')},shmi.getElementsByAttribute=function(e,t,s){return s||(s=document.body),s.querySelectorAll("["+e+'="'+t+'"]')},shmi.isRegistered=function(e,t){if(!shmi.visuals.session.Layout[t])return!1;for(var s=0;s<shmi.visuals.session.Layout[t].length;s++)if(shmi.visuals.session.Layout[t][s].element===e)return!0;return!1},shmi.addClass=function(e,t){if("string"!=typeof t)throw new Error("Parameter 'classname' must be a string.");t.split(" ").forEach((function(t){e.classList.add(t)}))},shmi.hasClass=function(e,t){if("string"!=typeof t)throw new Error("Parameter 'classname' must be a string.");if(null!=e){if(e.classList)return e.classList.contains(t);if(e.getAttribute("class")){const s=e.getAttribute("class").split(" ");for(let e=0;e<s.length;e++)if(s[e].trim()===t)return!0;return!1}return!1}return!1},shmi.removeClass=function(e,t){if("string"!=typeof t)throw new Error("Parameter 'classname' must be a string.");t.split(" ").forEach((function(t){e.classList.remove(t)}))},shmi.setSvgContent=function(e,t){var s=new DOMParser;s.async=!1;for(var n="<svg xmlns='http://www.w3.org/2000/svg'>"+t+"</svg>",a=0,r=s.parseFromString(n,"text/xml").documentElement.firstChild;r;)e.appendChild(e.ownerDocument.importNode(r,!0)),a++,r=r.nextSibling;shmi.log("[Helpers] added svg content ("+a+" elements)",0)},shmi.getParentGroup=function getParentGroup(e){if(!e||!e.element)return null;let t=e.isInitialized()?e.getParent():shmi.getParentContainer(e.element);for(;t&&"group"!==t.uiType;)t=t.getParent();return t},shmi.loadGroupConfig=function(e){var t=shmi.getParentGroup(e),s=shmi.requires("visuals.session"),n=shmi.requires("visuals.tools.iterate").iterateObject;if(t)if("group"!==t.element.getAttribute("data-ui"))shmi.log("[Helpers] loadGroupConfig - Parent container is no group",1);else{let a=e.element.getAttribute("data-group-config"),r=t.getConfig(),o=r.groupId||null,l=o&&s.groupConfig[o]||null,u=shmi.requires("visuals.tools.objectHelpers").setByPath;if(r[a]&&n(r[a],((t,s)=>{null!==t&&""!==t&&(e.config[s]=t)})),l&&Array.isArray(l.snippets)){let t={};l.replacers&&l.replacers.forEach((e=>{t[e.id]=e.default})),r.replacers&&n(r.replacers,((e,s)=>{t[s]=e})),l.snippets.forEach((s=>{if(s.dest===a)try{let a=JSON.parse(shmi.evalString(s.data,t));if(null===s.path){if(null===a||"object"!=typeof a)throw new TypeError("Snippet must be an object when applied to base config!");n(a,((t,s)=>{e.config[s]=t}))}else u(s.path,e.config,a)}catch(e){console.error("[shmi.loadGroupConfig] error parsing snippet:",e)}}))}}else shmi.log("[Helpers] loadGroupConfig - Parent container not found",1)},shmi.registerControlType=function(e,t,s){if(void 0!==shmi.visuals.session.Layout[e])console.debug("[Parser] control identifier '"+e+"' already defined, skipping");else try{shmi.visuals.session.Layout=shmi.visuals.session.Layout||{},shmi.visuals.session.Layout[e]=new Array,shmi.visuals.session.ParserState.controlTypes.push([e,t]),s&&shmi.visuals.session.ParserState.containerTypes.push(e),console.debug("[Parser] adding control type '"+e+"', is container:"+s)}catch(e){shmi.log("[Parser] exception adding control: "+e,3)}},function(){var e=["startup","init","loadTemplate","applyTemplate","loadConfig","applyConfig","enable","disable","lock","unlock","parseAttributes","getParent","getName","isActive","isInitialized","isDeleted","getChildren","parseChildren","listen","unlisten"];shmi.extend=function(t,s){for(var n in s.prototype)if(void 0===t.prototype[n])t.prototype[n]=s.prototype[n];else if(Array.isArray(s.prototype[n])&&Array.isArray(t.prototype[n]))for(var a=0;a<s.prototype[n].length;a++)t.prototype[n].push(s.prototype[n][a]);else-1!==e.indexOf(n)&&console.warn("[shmi.extend] BaseControl method '%s' was replaced with custom implementation. This might lead to errors.",n)}}(),function(){const e={access:["read","write"],data_type:null,digits:0,item_alias:null,label:null,max:null,min:null,prewarn:null,step:0,unit:null,value_type:"string",warn:null},t=["string","bool","int","float"];function noop(){}shmi.createVirtualItem=function(s,n,a,r,o,l){const u={},c=shmi.visuals.session.ItemManager,m=shmi.requires("visuals.tools.iterate.iterateObject");let d=null;s&&"object"==typeof s&&arguments.length<=2?(d=s,l="function"==typeof n?n:null):d={name:s,type:n,min:a,max:r,value:o},u.setValue=noop,u.setProperties=noop,u.lock=noop,u.unlock=noop;const h=c.getItem(d.name),f=[];h&&("function"==typeof h.onDelete&&h.onDelete(),m(h._updateTargets,(function(e,t){f.push({ut:e,sid:t})})),c.removeItem(d.name)),c._createItem(d.name);const g=c.getItem(d.name);return f.forEach((function(e){g._updateTargets[e.sid]=e.ut})),l?(u.sID=c.subscribeItem(d.name,u),g.onDelete=function(){u.sID.unlisten()},u.setValue=l):g.onDelete=noop,g.value=d.value,c.setProperties(function getItemProperties(s){const n=Object.create(e);if("string"!=typeof s.name)throw new TypeError("invalid 'name' parameter");return n.item_alias=s.name,Array.isArray(s.access)&&s.access.every((e=>"string"==typeof e))&&(n.access=s.access),"number"==typeof s.type&&t[s.type]&&(n.value_type=t[s.type]),"number"==typeof s.min&&(n.min=s.min),"number"==typeof s.max&&(n.max=s.max),"number"==typeof s.step&&(n.step=s.step),"number"==typeof s.digits&&(n.digits=s.digits),"string"==typeof s.label&&(n.label=s.label),"string"!=typeof s.unit&&"number"!=typeof s.unit||(n.unit=s.unit),s.warn&&"object"==typeof s.warn&&(n.warn={min:"number"==typeof s.warn.min?s.warn.min:null,max:"number"==typeof s.warn.max?s.warn.max:null}),s.prewarn&&"object"==typeof s.prewarn&&(n.prewarn={min:"number"==typeof s.prewarn.min?s.prewarn.min:null,max:"number"==typeof s.prewarn.max?s.prewarn.max:null}),n}(d)),g.valueSet=!0,g.notifyUpdateTargets(),shmi.log("[Helpers] created virtual item '"+d.name+"'",1),g}}(),shmi.def=function(e,t,s){void 0===e[t]&&(e[t]=s)},shmi.notify=function(e,t,s){if(0===shmi.fire("notification",{message:e,title:t,param:s},shmi)){var n=shmi.evalString(shmi.localize(t),s),a=shmi.evalString(shmi.localize(e),s);alert(n+"\n"+a)}},shmi.confirm=function(e,t,s,n){s=s||"${V_CONFIRM_TITLE}",n=n||{},0===shmi.fire("confirmation",{message:e,callback:t,title:s,param:n},shmi)&&shmi.decouple((function(){t(confirm(shmi.evalString(shmi.localize(s),n)+"\n"+shmi.evalString(shmi.localize(e),n)))}))},shmi.optionDialog=function(e){var t=[],s=["option","success","warning","cancel"],n="object"==typeof e,a=n&&e.title&&e.title.length>0,r=n&&e.message&&e.message.length>0,o=n&&Array.isArray(e.buttons)&&e.buttons.every((function(e){var n="object"==typeof e;n&&(e.type=e.type||"option");var a=n&&e.type.length>0&&-1!==s.indexOf(e.type),r=n&&"function"==typeof e.callback,o=n&&"object"==typeof e.config&&e.config.name&&e.config.label;return!!(a&&r&&o)||(t.push({invalidButtonObj:e,isButtonObj:n,hasValidType:Boolean(a),hasValidCallback:Boolean(r),hasValidConfig:Boolean(o)}),!1)}));if(!(a&&r&&o)){shmi.log("[shmi.optionDialog] Invalid option dialog configuration provided:",3);var l={isDialogObj:n,isTitleValid:a,isMessageValid:r};return o?l.hasValidButtons=o:l.hasInvalidButtons=t,console.log(l),!1}e.buttonLayout=e.buttonLayout||"horizontal";var u=shmi.fire("optionDialog",e,shmi);return u||(shmi.log("[shmi.optionDialog] No optionDialog listener triggered",3),!1)},shmi.askSave=function(e,t){var s=shmi.ctrl(".ask-save-dialog");if(null===s){var n=shmi.requires("visuals.session.SysControlConfig.askSaveDialog");(s=shmi.createControl("dialog-box",document.body,n,"DIV")).enable()}else document.body.appendChild(s.element);setTimeout((function checkDialog(){if(s.active){if(!s.hidden)return void setTimeout((function retry(){shmi.askSave(e,t)}),shmi.c("ACTION_RETRY_TIMEOUT"));var n=shmi.getElementByName("ask-save-text",s.element);shmi.visuals.session.AskSaves=shmi.visuals.session.AskSaves||{};for(var a=shmi.visuals.session.AskSaves,r=Date.now();void 0!==a[r];)r++;a[r]=t;var o,l=shmi.ctrl(s.getName()+".save-button");l&&((o=[]).push("ask-save:"+r+":SAVE"),o.push("dialog:.ask-save-dialog:hide"),l.action=new shmi.visuals.core.UiAction(o,l));var u=shmi.ctrl(s.getName()+".no-save-button");u&&((o=[]).push("ask-save:"+r+":NOSAVE"),o.push("dialog:.ask-save-dialog:hide"),u.action=new shmi.visuals.core.UiAction(o,u));var c=shmi.ctrl(s.getName()+".cancel-button");c&&((o=[]).push("ask-save:"+r+":CANCEL"),o.push("dialog:.ask-save-dialog:hide"),c.action=new shmi.visuals.core.UiAction(o,c)),n&&(n.textContent=shmi.localize(e)),s.show()}else setTimeout(checkDialog,shmi.c("ACTION_RETRY_TIMEOUT"))}),shmi.c("ACTION_RETRY_TIMEOUT"))},shmi.chooseFile=function(e,t,s,n,a){shmi.requires("visuals.controls.Button"),shmi.requires("visuals.controls.DialogBox"),shmi.requires("visuals.controls.FileChooser");var r,o=shmi.requires("visuals.session.SysControlConfig.chooseFileDialog"),l=null;void 0!==a&&(o.template=a);var cancel_func=function(){r.hide(),shmi.deleteControl(r,!0),s(null)},ok_func=function(){r.hide();var e=null;null!==l&&(e=l.getValue()),shmi.deleteControl(r,!0),s(e)};r=shmi.createControl("dialog-box",document.body,o,"DIV"),shmi.waitOnInit(r,(function(){r.enable();var s=r.element.querySelector("[data-function*=ok]"),a=r.element.querySelector("[data-function*=cancel]"),u=r.element.querySelector("[data-function*=choose-file]");if(!(s&&a&&u))throw new Error("FileChooser-dialog template '"+o.template+"' does not contain all required elements");var c=shmi.getControlByElement(s),m=shmi.getControlByElement(a);if(l=shmi.getControlByElement(u),!(c&&m&&l))throw new Error("FileChooser-dialog template '"+o.template+"' does not contain all required controls");l.setExtensions(t),void 0!==n&&l.setTopLevel(n),l.setValue(e),c.onClick=ok_func,m.onClick=cancel_func,r.show()}))},shmi.multiQuery=function(e,t){for(var s={},n=0;n<e.length;n++)!function(n){var a={},r=shmi.requires("visuals.tools.iterate.iterateObject");a.id=shmi.visuals.session.QueryManager.queryDirect((function(n,o){if(a.status=n,a.query=o,Object.keys(s).length===e.length){var l=0;r(s,(function(e,t){void 0!==s[t].status&&l++})),l===Object.keys(s).length&&t(s)}}),e[n][0],e[n][1],e[n][2],e[n][3]),s[n]=a}(n)},function(){function altLoad(e,t){var s=shmi.requires("visuals.tools.iterate.iterateObject"),n=shmi.cloneObject(e),a=shmi.cloneObject(e);s(e,(function(e,s){n[s]={url:e,ready:!1,data:null,callback:function(e,r,o){a[s]=r?null:e,n[s].ready=!0,function checkReady(e){var t=shmi.requires("visuals.tools.iterate.iterateObject"),s=!0;return t(e,(function(e,t){e.ready||(s=!1)})),s}(n)&&t(a)}}})),s(n,(function(e,t){shmi.loadResource(e.url,e.callback)}))}shmi.multiLoad=function(e,t,s,n){if(Array.isArray(e)||"object"!=typeof e){var a,r=[];for(a=0;a<e.length;a++)r.push(null);for(r.counter=0,a=0;a<e.length;a++)!function(a){var o={};o.url=e[a],r[a]=o,shmi.loadResource(e[a],(function multiload_cb(s,n){if(o.failed=!!n,o.data=s,r.counter++,r.counter===e.length){for(var a=0,l=0;l<r.length;l++)void 0!==r[l].failed&&a++;a===r.length&&t(r)}}),s,n)}(a)}else altLoad(e,t)}}(),shmi.deleteControl=function(e,t){var s=shmi.requires("visuals.session"),n=shmi.requires("visuals.tools.controller");t=void 0===t||t,e.disable(),"function"==typeof e.onDelete&&e.onDelete(),e._init_&&Array.isArray(e._init_.tokens)&&(e._init_.tokens.forEach((function(e){e.unlisten()})),e._init_.tokens=[]);var a=e.getName();s&&s.config&&s.config.debug&&!a&&console.debug("[shmi.deleteControl] deleting uninitialized control"),e.parentContainer&&e.parentContainer.controls.forEach((function(t,s){t===e&&e.parentContainer.controls.splice(s,1)}));for(var r=0;r<s.Layout[e.uiType].length;r++)if(s.Layout[e.uiType][r].element===e.element){if(Array.isArray(s.Layout[e.uiType][r].controls))for(;s.Layout[e.uiType][r].controls.length;)shmi.deleteControl(s.Layout[e.uiType][r].controls[0],t);s.Layout[e.uiType][r].disable(),delete s.names[s.Layout[e.uiType][r].getName()],s.Layout[e.uiType].splice(r,1),!0===t&&e.element.parentNode&&e.element.parentNode.removeChild(e.element);break}e.deleted=!0,e.parentContainer=null,n.removeAll(a),e.fire("delete",{name:a}),shmi.fire("delete-control",{name:a},s)},shmi.createControl=function(e,t,s,n,a,r){var o=null;o=void 0!==n?n:"DIV",void 0===r&&(r=!0);var l=shmi.visuals.parser.getDefaultConfig(e),u=shmi.requires("visuals.tools.iterate.iterateObject");s=s||{},u(l,(function(e,t){shmi.def(s,t,e)}));var c=document.createElement(o);if(c.setAttribute("data-ui",e),s&&s.name&&c.setAttribute("data-name",s.name),"before"===a)t.parentNode.insertBefore(c,t);else if("after"===a)t.parentNode.insertBefore(c,t.nextSibling);else if("from"===a){if(null!==shmi.getControlByElement(t))throw new Error("element already contains a control");c=t}else!function appendFormat(e,t,s){t.hasChildNodes()&&3===t.lastChild.nodeType&&/^\s*[\r\n]\s*$/.test(t.lastChild.textContent)?(t.insertBefore(document.createTextNode("\n"+e),t.lastChild),t.insertBefore(s,t.lastChild)):(t.appendChild(document.createTextNode("\n"+e)),t.appendChild(s),t.appendChild(document.createTextNode("\n"+e.slice(0,-4))))}("    ",t,c);for(var m=-1,d=shmi.visuals.session.ParserState,h=0;h<d.controlTypes.length;h++)if(d.controlTypes[h][0]===e){m=h;break}var f=null;if(-1!==m){(f="panel"===e?new d.controlTypes[m][1](c,!1,s):new d.controlTypes[m][1](c,s)).uiType=e;var g=shmi.getParentContainerElement(f.element);f.parentContainer=null===g?null:shmi.getControlByElement(g),null!==f.getParent()?(f.getParent().controls.push(f),r&&!0===f.getParent().isActive()&&f.enable()):r&&f.enable(),shmi.visuals.session.Layout[e].push(f),f.fire("register",{})}else shmi.log("[createControl] control type '"+e+"' not available",2);return f},shmi.waitOnInit=function(e,t,s){var n=!1,a=s||{tokens:[],cancel:function(){this.tokens.forEach((function(e){e.unlisten()})),this.tokens=[]},unlisten:function(){this.cancel()}};if(Array.isArray(e)){var r,o=0;for(r=0;r<e.length;r++)!0===e[r].initialized&&o++;o===e.length&&(n=!0)}else!0===e.initialized&&(n=!0);if(!0===n)t(e);else if(Array.isArray(e))e.forEach((function(s){if(!s.initialized){var n=s.listen("init",(function(s){a.tokens.forEach((function(e){e.unlisten()})),a.tokens=[],shmi.waitOnInit(e,t,a)}));a.tokens.push(n)}}));else if(!e.initialized){var l=e.listen("init",(function(s){a.tokens.forEach((function(e){e.unlisten()})),a.tokens=[],shmi.waitOnInit(e,t,a)}));a.tokens.push(l)}return a.tokens.length?a:null},function(){function checkDomInsertion(e,t){getRoot(e)!==document.body?setTimeout((function(){checkDomInsertion(e,t)}),100):t()}function getRoot(e){return null===e.parentNode?null:e.parentNode===document.body?document.body:getRoot(e.parentNode)}function addToParent(e){if(null!==e.parentContainer&&(e.parentContainer.controls.push(e),!0===e.parentContainer.active))var t=e.listen("init",(function(s){e.unlisten("init",t),!0===e.parentContainer.active&&e.enable()}))}shmi.registerName=function(e,t){var s=shmi.visuals.session;s.names=s.names||{};var n=s.names;if(t&&-1!==t.indexOf(".")){var a=t.split(".");t=a[a.length-1]}var r=!!t,o=r?t:e.getClassName().toLowerCase()||e.uiType||"UNDEFINED",l="";if(shmi.isRegistered(e.element,e.uiType))checkDomInsertion(e.element,(function(){if(null===e.parentContainer){var t=shmi.getParentContainerElement(e.element);e.parentContainer=null===t?null:shmi.getControlByElement(t),addToParent(e)}null!==e.parentContainer&&void 0!==e.parentContainer&&(l=e.parentContainer.getName(),o=l+"."+o);var s=1,a="";if(r)if(void 0===n[o])a=o;else{for(;void 0!==n[o+shmi.c("NAME_SUFFIX")+s];)s++;a=o+shmi.c("NAME_SUFFIX")+s}else{for(;void 0!==n[o+shmi.c("NAME_SUFFIX")+s];)s++;a=o+shmi.c("NAME_SUFFIX")+s}n[a]={},n[a].ctrl=e,e.fire("register-name",{name:a})}));else var u=e.listen("register",(function(){e.unlisten("register",u),checkDomInsertion(e.element,(function(){if(null===e.parentContainer){var t=shmi.getParentContainerElement(e.element);e.parentContainer=null===t?null:shmi.getControlByElement(t),addToParent(e)}null!==e.parentContainer&&(l=e.parentContainer.getName(),o=l+"."+o);var s=1,a="";if(r)if(void 0===n[o])a=o;else{for(;void 0!==n[o+shmi.c("NAME_SUFFIX")+s];)s++;a=o+shmi.c("NAME_SUFFIX")+s}else{for(;void 0!==n[o+shmi.c("NAME_SUFFIX")+s];)s++;a=o+shmi.c("NAME_SUFFIX")+s}n[a]={},n[a].ctrl=e,e.fire("register-name",{name:a})}))}));return t}}(),shmi.toBoolean=function(e){var t=!1;if("boolean"==typeof e||e instanceof Boolean)t=e;else if("string"==typeof e||e instanceof String){var s=e.trim().toLowerCase();"true"!==s&&"false"!==s||(t="true"===s)}else shmi.log("[toBoolean] expr ist not a boolean expression, expr: "+e,2);return t},shmi.toNumber=function(e){var t=0;return isNaN(e)?(shmi.log("[toNumber] expr ist not a number expression, expr: "+e,2),t=Number.NaN):t=Number(e),t},shmi.cloneObject=function(e){if(void 0!==e)return JSON.parse(JSON.stringify(e))},shmi.bindItems=function(e,t){var s=shmi.visuals.session,n=s.ItemManager;s.bindings=s.bindings||{};for(var a=1;void 0!==s.bindings[a];)a++;s.bindings[a]={id:a,item1:e,item2:t};var r,o,noop=function(){},l={setProperties:noop,lock:noop,unlock:noop},u={setProperties:noop,lock:noop,unlock:noop},c=!1;return l.setValue=function(e){n.items[t].valueSet&&n.writeValue(t,e)},u.setValue=function(s){c?n.writeValue(e,s):n.items[e].valueSet&&(n.writeValue(t,n.items[e].value),c=!0)},r=n.subscribeItem(e,l),o=n.subscribeItem(t,u),s.bindings[a].item1_sid=r,s.bindings[a].item2_sid=o,a},shmi.unbindItems=function(e){var t,s=!1,n=shmi.visuals.session,a=n.ItemManager;return n.bindings=n.bindings||{},void 0!==n.bindings[e]&&(t=n.bindings[e],a.unsubscribeItem(t.item1,t.item1_sid),a.unsubscribeItem(t.item2,t.item2_sid),delete n.bindings[e],s=!0),s},shmi.getControlByElement=function(e){var t=e.getAttribute("data-ui"),s=shmi.visuals.session,n=null;if(null!==t){if(!Array.isArray(s.Layout[t]))throw new Error("[shmi.getControlByElement] control type '"+t+"' not defined");for(var a=s.Layout[t],r=0;r<a.length;r++)if(a[r].element===e){n=a[r];break}}else{var o=shmi.requires("visuals.tools.iterate.iterateObject");console.debug("[shmi.getControlByName] data-ui attribute missing, checking all ui-types..."),o(s.Layout,(function(t,s){t.forEach((function(t){t.element===e&&(n=t)}))}))}return n},shmi.getFullName=function(e){return e.getName()},shmi.listen=function(e,t,s){var n=shmi.pkg("visuals.session");n.Events=n.Events||{},n.Events[e]=n.Events[e]||{};for(var a=n.Events[e],r=0;void 0!==a[r];)r++;a[r]=null!==s&&"object"==typeof s?function(e){let n=!1;return Object.keys(s).some((t=>{let a=t.split("."),r=null;for(;a.length;){let t=a.shift();if(r=null===r?e[t]:r[t],void 0===r)break}return void 0!==r&&r===s[t]?(n=!0,!1):(n=!1,!0)})),!0===n&&t(e),n}:function(e){return t(e),!0};var o={name:e,listenerId:r,unlisten:(null,function(){shmi.unlisten(o)})};return o},shmi.listenOnce=function(e,t,s){let n=0;const a=shmi.listen(e,((...e)=>{2&n||a.unlisten(),1&n||(n|=1,t(...e))}),s),r=a.unlisten;return a.unlisten=()=>{1&n?n|=6:(n|=2,r.call(a))},a},shmi.unlisten=function(e,t){var s,n=shmi.visuals.session;if("object"==typeof e&&1===arguments.length){if(void 0===(s=n.Events[e.name]))throw Error("ERROR: undefined event type '"+e.name+"'");if(void 0===s[e.listenerId])throw Error("ERROR: listener id "+e.listenerId+" not registered for event type '"+e.name+"'");delete s[e.listenerId]}else{if(void 0===(s=n.Events[e]))throw Error("ERROR: undefined event type '"+e+"'");if(void 0===s[t.listenerId])throw Error("ERROR: listener id "+t.listenerId+" not registered for event type '"+e+"'");delete s[t.listenerId]}},shmi.getParentContainer=function(e){if(null===(e=e.parentNode))return shmi.log("[Helpers] element is body",1),null;if(e===document.body)return shmi.log("[Helpers] element is body",1),null;for(;!shmi.isContainer(e);){if(null==e)return shmi.log("[Helpers] getParentContainer - provided element NULL",1),null;if((e=e.parentNode)===document.body)return shmi.log("[Helpers] some parent of element is body",1),null}for(var t=e.getAttribute("data-ui"),s=0;s<shmi.visuals.session.Layout[t].length;s++)if(shmi.visuals.session.Layout[t][s].element===e)return shmi.visuals.session.Layout[t][s];return shmi.log("[Helper] parent not found in layouts("+shmi.visuals.session.Layout[t].length+"), type: "+t,1),null},shmi.getParentContainerElement=function(e){if((e=e.parentNode)===document.body)return shmi.log("[Helpers] element is body",1),null;if(null===e)return shmi.log("[Helpers] parent node is null or undefined",1),null;for(;!shmi.isContainer(e);){if(null===e)return shmi.log("[Helpers] parent node is null or undefined",1),null;if((e=e.parentNode)===document.body)return shmi.log("[Helpers] some parent of element is body",1),null;if(e===document.documentElement)return shmi.log("[Helpers] some parent of element is body",1),null}return e},shmi.isContainer=function(e){if(e instanceof HTMLElement)for(var t=e.getAttribute("data-ui"),s=0;s<shmi.visuals.session.ParserState.containerTypes.length;s++)if(shmi.visuals.session.ParserState.containerTypes[s]===t)return!0;return!1},function(){function getEnableCallback(e,t,s,n,a){return function(r){e[t]=r;var o=shmi.requires("visuals.tools.iterate.iterateObject"),l=!0,u=0;o(e,(function(t,s){!0!==e[s].active?l=!1:u++})),l&&u===s&&(a.canceled||(a.completed=!0,n(e)))}}shmi.onEnable=function(e,t){const s={},{HANDLE_PREFIX:n,getNodeHandle:a}=shmi.requires("visuals.tools.nodes");let r=[],o=[];const l=shmi.getCancelable((()=>{o.forEach((e=>{e.cancel()})),o=[],r.forEach((e=>{e.unlisten()})),r=[]}));if(Array.isArray(e))for(let n=0;n<e.length;n++){const a=shmi.onEnable(e[n],getEnableCallback(s,e[n],e.length,t,l));o.push(a)}else{let s,o=shmi.ctrl(e);if(o&&o.isActive())shmi.decouple((()=>{l.canceled||(l.complete(),t(o))}));else if(e.startsWith(n)){const o=e.replace(n,"");s=shmi.listen("enable",(function(e){if(!e.source||!e.source.element||!e.source.element.getAttribute("_nodeid"))return;a(e.source)===o&&(shmi.unlisten("enable",s),l.complete(),t(e.source))})),r.push(s)}else s=shmi.listen("enable",(function(n){let a,r;if(n.detail.name){a=e.split(" ."),r=0;for(let e=0;e<a.length;e++)-1===n.detail.name.indexOf(a[e])&&r++,e===a.length-1&&n.detail.name.lastIndexOf(a[e])!==n.detail.name.length-a[e].length&&r++;0===r&&(o=shmi.ctrl(e),o&&(shmi.unlisten("enable",s),l.complete(),t(o)))}})),r.push(s)}return l.returnValue}}(),shmi.onDisable=function(e,t){let s=null;const n=shmi.getCancelable((()=>{s&&(s.unlisten(),s=null)}));if(!e||!Array.isArray(e.events)||-1===e.events.indexOf("disable"))throw new Error("ERROR: 'disable' event not supported");return!1===e.active?shmi.decouple((()=>{n.canceled||(n.complete(),t(e))})):s=e.listen("disable",(function eventHandler(a){s.unlisten(),s=null,n.complete(),t(e)})),n.returnValue},shmi.to_utf8=function(e){return shmi.visuals.session.FileManager.to_utf8(e)},shmi.from_utf8=function(e){return shmi.visuals.session.FileManager.from_utf8(e)},shmi.objectHasOwnProperty=Object.prototype.hasOwnProperty.call.bind(Object.prototype.hasOwnProperty),shmi.getCancelable=e=>{let t=!1,s=!1;return{get canceled(){return s},get completed(){return t},complete:function(){s||(t=!0)},returnValue:{cancel:function(){if(!t&&!s){s=!0;try{e()}catch(e){console.error(`Error canceling task: ${e.message}`,e)}e=null}},get canceled(){return s},set canceled(e){throw new Error("State 'canceled' cannot be set manually. Call 'cancel' method instead.")},get completed(){return t},set completed(e){throw new Error("State 'completed' cannot be set by consumer. Issuer must call 'complete' method instead.")}}}},shmi.onVisible=function(e,t){let s=0;const n=shmi.getCancelable((()=>{clearTimeout(s),s=0}));return e.offsetWidth>0||e.offsetHeight>0?shmi.decouple((()=>{n.canceled||(n.complete(),t())})):s=setTimeout((function(){shmi.onVisible(e,t)}),shmi.c("ACTION_RETRY_TIMEOUT")),n.returnValue},shmi.getAbsPosition=function(e){for(var t=0,s=0,n=e.getBoundingClientRect();e;)t+=e.scrollLeft,s+=e.scrollTop,e=e.offsetParent;return{x:n.left+t,y:n.top+s}},shmi.evalString=function(in_text,dyn_content){var session=shmi.visuals.session,im=session.ItemManager,locale=session.locale;function MAP(value,mapObj){var localeString=null,localeObj=null;if("string"==typeof mapObj&&(localeString=locale[mapObj],localeString)){try{eval("localeObj = "+localeString)}catch(e){return console.error("[shmi.evalString]","failed to parse enumeration object from locale-variable:",mapObj),"INVALID_ENUM"}mapObj=localeObj}return mapObj[value]?shmi.localize(mapObj[value]):"UNKNOWN"}function DATE(e,t,s){return shmi.requires("visuals.tools.date").formatDateTime(e,{datestring:t||null,utc:!!s})}function ITEM(e){return im.readValue(e)}function LOC(e){return locale[e]}function processMarkers(e,t){let s=Object.keys(e);return t=t.trim(),s.sort(((e,t)=>e.length-t.length)),s.reverse(),s.forEach((e=>{let s=new RegExp(`(?!_\\$_\\.)\\b${escapeRegExp(e)}\\b`,"g");t=t.replace(s,"_$_."+e)})),t}function replace_dyn_markers(in_data,_$_){var matches=in_data.match(/<%=(.*?)%>/g),t_re=null;matches=null===matches?[]:matches,matches.sort(((e,t)=>e.length-t.length)),matches.reverse();for(var i=0;i<matches.length;i++){var cur_match=matches[i].match(/<%=(.*?)%>/);if(cur_match[1]){"object"!=typeof _$_&&(_$_={});var content=null;try{content=eval(processMarkers(_$_,cur_match[1])),t_re=new RegExp(escapeRegExp(cur_match[0]),"g"),in_data=in_data.replace(t_re,content)}catch(e){content="ERROR"}}}return in_data}function escapeRegExp(e){return e.replace(/[-[\]{}()*+?.\\^$|]/g,"\\$&")}return replace_dyn_markers(in_text,dyn_content)},function(){var e=null,t=null,s=shmi.c("SERVER_TIME_ITEM"),n=shmi.c("ALT_SERVER_TIME_ITEM");shmi.getServerTime=function(){var a=Date.now()/1e3,r=shmi.requires("visuals.session.ItemManager");if(r.getItem(s)?t=r.readValue(s):r.getItem(n)&&(t=r.readValue(n)),null!==t){var o=a-parseInt(t);return a-(e=null===e||isNaN(e)?o:.7*e+.3*o)}return a}}(),function(){function callComplete(e){return!e.cancelable.canceled&&e.ready===e.total}shmi.onReady=function(e,t){const s={ready:0,total:0,numItems:0,numControls:0,numResources:0,cancelable:null},n=shmi.requires("visuals.session.ItemManager"),a=shmi.requires("visuals.tools.iterate.iterateObject"),r=shmi.cloneObject(e);let o=[],l=[];const u=shmi.getCancelable((()=>{o.forEach((e=>{try{e.cancel()}catch(e){console.error(`Could not cancel task: ${e.message}`,e)}})),o=[],l.forEach((e=>{try{e.unlisten()}catch(e){console.error(`Could not stop listener: ${e.message}`,e)}})),l=[]}));return s.cancelable=u,"object"==typeof r.items&&a(r.items,(function(){s.numItems+=1,s.total+=1})),"object"==typeof r.controls&&a(r.controls,(function(){s.numControls+=1,s.total+=1})),"object"==typeof r.resources&&a(r.resources,(function(){s.numResources+=1,s.total+=1})),s.numItems&&a(r.items,(function(e,a){var o=n.getItemHandler(),c=null,m=!1;o.setValue=function(){m||(m=!0,r.items[a]=n.getItem(e),s.ready+=1,shmi.visuals.session.config.debug&&console.debug("item ready: ",e),callComplete(s)&&shmi.decouple((()=>{u.canceled||(u.complete(),t(r))})),setTimeout((function(){null!==c&&c.unlisten()}),10))},c=n.subscribeItem(e,o),l.push(c)})),s.numControls&&a(r.controls,(function(e,n){if("string"==typeof e){const a=shmi.onEnable(e,(function(a){r.controls[n]=a,s.ready+=1,shmi.visuals.session.config.debug&&console.debug("control ready: ",e),callComplete(s)&&(u.complete(),t(r))}));o.push(a)}else if(!0===e.isActive())r.controls[n]=e,s.ready+=1,callComplete(s)&&shmi.decouple((()=>{u.canceled||(u.complete(),t(r))}));else{var a=null;a=e.listen("enable",(function(e){a.unlisten(),r.controls[n]=e.source,s.ready+=1,callComplete(s)&&(u.complete(),t(r))})),l.push(a)}})),s.numResources&&a(r.resources,(function(e,n){shmi.loadResource(e,(function(e,a){r.resources[n]={data:e,failed:a},s.ready+=1,callComplete(s)&&shmi.decouple((()=>{u.canceled||(u.complete(),t(r))}))}))})),u.returnValue}}(),shmi.getVisualsVersion=function(){var e=shmi.visuals.Version.split("-"),t=e[0].split("."),s={major:parseInt(t[0]),minor:parseInt(t[1]),patch:parseInt(t[2]),dev:void 0!==e[1]?e[1]:null,build:parseInt(shmi.visuals.Build),lessThan:function lessThan(e){if(e[0]>s.major)return!0;if(e[0]===s.major){if(e[1]>s.minor)return!0;if(e[1]===s.minor&&e[2]>s.patch)return!0}return!1},greaterThan:function greaterThan(e){if(e[0]<s.major)return!0;if(e[0]===s.major){if(e[1]<s.minor)return!0;if(e[1]===s.minor&&e[2]<s.patch)return!0}return!1}};return s},shmi.getConnectVersion=function(){var e=shmi.cloneObject(shmi.visuals.session.Host.version);return e.lessThan=function lessThan(t){if(t[0]>e.major)return!0;if(t[0]===e.major){if(t[1]>e.minor)return!0;if(t[1]===e.minor&&t[2]>e.patch)return!0}return!1},e.greaterThan=function greaterThan(t){if(t[0]<e.major)return!0;if(t[0]===e.major){if(t[1]<e.minor)return!0;if(t[1]===e.minor&&t[2]<e.patch)return!0}return!1},e},shmi.onActive=function(e,t){let s=[];const n=shmi.getCancelable((()=>{s.forEach((e=>{try{e.unlisten()}catch(e){console.error(`Could not stop listener: ${e.message}`,e)}})),s=[]}));return e.forEach((function(e){if(!e.isActive()){const a=e.listen("enable",(()=>{a.unlisten(),s.splice(s.indexOf(a),1),0===s.length&&(n.complete(),t())}));s.push(a)}})),s.length||shmi.decouple((()=>{n.canceled||(n.complete(),t())})),n.returnValue},shmi.decouple=function decouple(e){Promise.resolve().then(e)},shmi.isDesignerPreview=function isDesignerPreview(){return shmi.designer&&shmi.designer.sessionClient&&shmi.designer.sessionClient.isPreview()},shmi.isDesignerEditor=function isDesignerEditor(){return shmi.designer&&shmi.designer.sessionClient&&!shmi.designer.sessionClient.isPreview()},shmi.getCompositePlaceholders=e=>shmi.requires("visuals.tools.composites").getPlaceholders(e),shmi.setCompositePlaceholders=(e,t)=>shmi.requires("visuals.tools.composites").modifyPlaceholders(e,t),function(){function testWarn(e,t){if("number"==typeof e&&t&&t.warn){if("number"==typeof t.warn.min&&e<=t.warn.min)return!0;if("number"==typeof t.warn.max&&e>=t.warn.max)return!0}return!1}function testPrewarn(e,t){if("number"==typeof e&&t&&t.prewarn){if("number"==typeof t.prewarn.min&&e<=t.prewarn.min)return!0;if("number"==typeof t.prewarn.max&&e>=t.prewarn.max)return!0}return!1}function updateState(e,t,s){testWarn(t,s)?(shmi.removeClass(e,"preWarn"),shmi.addClass(e,"warn")):testPrewarn(t,s)?(shmi.removeClass(e,"warn"),shmi.addClass(e,"preWarn")):(shmi.removeClass(e,"preWarn"),shmi.removeClass(e,"warn"))}function callCallback(e,t,s){e&&(testWarn(t,s)?e("warn"):testPrewarn(t,s)?e("prewarn"):e(null))}function setOption(e,t,s){e.options=e.options||{},e.options[t[0]]=e.options[t[0]]||{},e.options[t[0]][t[1]]="number"==typeof s?s:null}shmi.createConditional=function(e,t,s){var n={enable:null,disable:null,options:null,item:t},a=shmi.requires("visuals.session.ItemManager"),r=a.getItemHandler(),o=null,l=null;return r.setValue=function setValue(t){o=t,"function"==typeof s?callCallback(s,o,n.options):updateState(e,o,n.options)},r.setProperties=function setProperties(t,a,r,l,u,c,m,d,h,f){setOption(n,["prewarn","min"],d),setOption(n,["prewarn","max"],h),setOption(n,["warn","min"],c),setOption(n,["warn","max"],m),"number"==typeof o&&("function"==typeof s?callCallback(s,o,n.options):updateState(e,o,n.options))},n.enable=function enable(){null===l&&"string"==typeof n.item&&(l=a.subscribeItem(n.item,r))},n.disable=function disable(){null!==l&&(l.unlisten(),l=null,o=null,n.options=null)},n}}(),shmi.LocalizedError=class LocalizedError extends Error{constructor(e,t){super(shmi.evalString(shmi.localize(String(e)),t))}},shmi.numpad=function(e){0===shmi.fire("numpad-request",e,shmi)&&console.log("no handler registered for 'numpad-request' event")},shmi.pkg("visuals.core"),shmi.visuals.core.Alarm=function(e){this.id=e,this.properties=null},shmi.visuals.core.Alarm.prototype={setProperties:function(e){this.properties=e},ackAlarm:function(){(0,shmi.requires("visuals.tools.connect").request)("alarm.acknowledge",[this.id],(function onRequest(e,t){t&&console.error("[Alarm] acknowledge failed:",t.category,t.errc,t.message)}))},getProperties:function(){return shmi.cloneObject(this.properties)}},function(){shmi.pkg("visuals.core");var e=[1,3,1];function notifyDelayed(e,t,s){var n=t.splice(0,500);e.subscribers[s]&&(n.forEach((function(t,a){var r=e.alarms[t];e.subscribers[s].callback(shmi.cloneObject(r.properties),a===n.length-1)})),t.length&&setTimeout(notifyDelayed.bind(null,e,t,s),shmi.c("ACTION_RETRY_TIMEOUT")))}function processAlarm(e){const t=shmi.requires("visuals.tools.numericValues"),s=shmi.visuals.tools.unitClasses;return(e=shmi.cloneObject(e)).items=(e.items||[]).concat(e.context||[]),e.context=e.items,e.items.forEach((function(e){Object.defineProperty(e,"formattedValue",{enumerable:!0,configurable:!1,get:function(){return t.formatNumber(e.value,{precision:e.digits,unit:e.unit})}}),Object.defineProperty(e,"unitText",{enumerable:!0,configurable:!1,get:()=>{if(null!==e&&!isNaN(e.unit)){const t=s.getSelectedAdapter(parseInt(e.unit));if(t)return t.unitText}return e.unit}})})),e}shmi.visuals.core.AlarmManager=function(){var e=this;e.alarms={},e.subscribers={},e.alarmsLoaded=!1,shmi.registerMsgHandler("alarm.notify",(function(t){e.setProperties(t.data,!0)}))},shmi.visuals.core.AlarmManager.prototype={_createAlarm:function(e){if(void 0!==this.alarms[e])shmi.log("[AlarmManager] alarm '"+e+"' already exists",0);else{var t=shmi.visuals.core;this.alarms[e]=new t.Alarm(parseInt(e))}},removeAlarm:function(e){delete this.alarms[e]},removeAll:function(){var e=this;(0,shmi.requires("visuals.tools.iterate").iterateObject)(e.subscribers,(function(t,s){delete e.subscribers[s]}))},ackAlarm:function(e){var t=shmi.requires("visuals.tools.connect").request,s=!1;return-1===e?(s=!0,t("alarm.acknowledge_all",{},(function onRequest(e,t){t&&console.error("[AlarmManager] acknowledge_all failed:",t.category,t.errc,t.message)}))):void 0!==this.alarms[e]&&(this.alarms[e].ackAlarm(),s=!0),s},ackAlarmGroups:function(e){const{request:t}=shmi.requires("visuals.tools.connect");Array.isArray(e)||(e=[e]),t("alarm.acknowledge_groups",e,(function onRequest(e,t){t&&console.error("[AlarmManager] acknowledge_groups failed:",t.category,t.errc,t.message)}))},subscribeAlarms:function(e,t){for(var s=Date.now(),n=this,a=n.subscribers[s],r=null;void 0!==a;)s++,a=n.subscribers[s];return n.subscribers[s]={},(a=n.subscribers[s]).control=e,a.callback=t,n.alarmsLoaded?setTimeout((function(){var e=Object.keys(n.alarms);notifyDelayed(n,e,s)}),10):r=shmi.listen("alarms-loaded",(function onAlarmsReady(){r.unlisten();var e=Object.keys(n.alarms);notifyDelayed(n,e,s)})),s},unsubscribeAlarms:function(e){delete this.subscribers[e]},setProperties:function(t,s){var n=this,a=shmi.getConnectVersion(),r=shmi.requires("visuals.tools.iterate.iterateObject");a.lessThan(e)?console.error("[AlarmManager]","alarming requires at least connect version:",e.join(".")):(n.alarms[t.id]||n._createAlarm(t.id),n.alarms[t.id].setProperties(t),n.alarmsLoaded&&r(n.subscribers,(function(e,n){e.callback(t,s)})))},requestAlarmList:function(){var e=this;e.getLiveAlarms((function onLiveAlarms(t,s){Array.isArray(s)&&(s.forEach((function(t,n){e.setProperties(t,n===s.length-1)})),e.alarmsLoaded=!0,shmi.fire("alarms-loaded",{},e))}))},getAlarm:function(e){return this.alarms[e]?this.alarms[e]:null},getLiveAlarms:function(e){(0,shmi.requires("visuals.tools.connect").request)("alarm.live",{},(function onRequest(t,s){s?(console.error("[AlarmManager] getLiveAlarms failed:",s.category,s.errc,s.message),e(s,null)):e(0,t.map(processAlarm))}))},getHistoricAlarms:function(e,t){(0,shmi.requires("visuals.tools.connect").request)("alarm.historic",t,(function onRequest(t,s){s?(console.error("[AlarmManager] getLiveAlarms failed:",s.category,s.errc,s.message),e(s,null)):(t.alarms=t.alarms.map(processAlarm),e(0,t))}))}}}(),function(){"use strict";shmi.pkg("visuals.core");const e={overrides:{"user.setpw":{"auth-generic":{3:"${V_INVALID_PASSWORD}"},"shmi:connect:api:user":{3:"${V_INVALID_PASSWORD}"}}},categories:{"auth-generic":{1:"${connect.error.auth-generic.user-not-found}",2:"${connect.error.auth-generic.user-already-exists}",3:"${connect.error.auth-generic.invalid-credentials}",4:"${connect.error.auth-generic.invalid-username}",5:"${connect.error.auth-generic.weak-password}",6:"${connect.error.auth-generic.group-not-found}",7:"${connect.error.auth-generic.group-already-exists}",8:"${connect.error.auth-generic.user-already-in-group}",9:"${connect.error.auth-generic.group-already-in-group}",10:"${connect.error.auth-generic.not-supported}",11:"${connect.error.auth-generic.not-implemented}",12:"${connect.error.auth-generic.internal-error}",13:"${connect.error.auth-generic.internal-error}",14:"${connect.error.auth-generic.realm-not-connected}",15:"${connect.error.auth-generic.authentication-not-available}",16:"${connect.error.auth-generic.internal-error}"},"shmi:connect:api:user":{3:"${connect.error.auth-generic.invalid-credentials}"}}};function getMessageFromObject(e,{category:t,errc:s}){if(shmi.objectHasOwnProperty(e,t)){const n=e[t];if(shmi.objectHasOwnProperty(n,s))return n[s]}return null}function translateError(t,{category:s,errc:n,message:a},r,o){const l=function getMessageString(t,{category:s,errc:n},a,r){let o=null;return r&&(o=getMessageFromObject(r,{category:s,errc:n})),null===o&&shmi.objectHasOwnProperty(e.overrides,t)&&(o=getMessageFromObject(e.overrides[t],{category:s,errc:n})),null===o&&(o=getMessageFromObject(e.categories,{category:s,errc:n})),null===o&&(o=void 0===a?"${connect.error.genericBackendError}":a),o}(t,{category:s,errc:n},r,o);return shmi.evalString(shmi.localize(l),{ERROR_CODE:n,ERROR_CAT:s,ERROR_MSG:a,ERROR_COMMAND:t})}class ApiDiagnostics{constructor(e=null){Object.assign(this,e??{})}isEmpty(){return 0===Object.keys(this).length}toString(e=1){const t=[];return this.property_path&&this.expected_root_type?(t.push(`in property of ${this.expected_root_type}`),t.push(`at $.${this.property_path}`)):this.property_path?t.push(`in property at $.${this.property_path}`):this.expected_root_type&&t.push(`in property of ${this.expected_root_type}`),this.expected_type&&t.push(`    expected ${this.expected_type}`),this.provided_type&&t.push(`    provided ${this.provided_type}`),t.map((t=>`${"    ".repeat(e)}${t}`)).join("\n")}}shmi.visuals.core.ApiError=class ApiError extends Error{constructor(e,{category:t,errc:s,message:n,diagnostics:a},r={}){const o=translateError(e,{category:t,errc:s,message:n},void 0,r?.messageMapOverlay);super(r?.useLocalizedMessage?o:`Backend reported an error while processing API command "${e}": ${t}:${s}:${n}`),this.name=this.constructor.name,this.command=e,this.apiError={category:t,errc:s,message:n,diagnostics:a},this.localizedMessage=o,this.diagnostics.isEmpty()||(this.stack=`${this.stack}\n${this.diagnostics}`)}get category(){return this.apiError.category}get errc(){return this.apiError.errc}get message(){return this.apiError.message}get diagnostics(){return new ApiDiagnostics(this.apiError.diagnostics)}static setLocalizedMessage(t,s,n){shmi.checkArg("category",t,"string"),shmi.checkArg("code",s,"number"),shmi.checkArg("message",n,"string","null"),n?e.categories[t]?e.categories[t][s]=n:e.categories[t]={[s]:n}:e.categories[t]&&delete e.categories[t][s]}static setLocalizedMessageOverride(t,s,n,a){shmi.checkArg("command",t,"string"),shmi.checkArg("category",s,"string"),shmi.checkArg("code",n,"number"),shmi.checkArg("message",a,"string","null"),a?e.overrides[t]?e.overrides[t][s]?e.overrides[t][s][n]=a:e.overrides[t][s]={[n]:a}:e.overrides[t]={[s]:{[n]:a}}:e.overrides[t]?.[s]&&delete e.overrides[t][s][n]}}}(),function(){function updateAppearance(e,t,s){s?shmi.addClass(e.element,t):shmi.removeClass(e.element,t)}function ensureConfig(e){e.config=e.config||{}}function setCssClasses(e){("container"!==e.uiType&&shmi.addClass(e.element,shmi.c("CSS_CONTROL_CLASS")),e.config["class-name"])&&e.config["class-name"].split(" ").forEach((function(t){""!==t.trim()&&shmi.addClass(e.element,t)}))}function initializeControl(e){"function"==typeof e.onInit?e.onInit():console.warn("["+e.getClassName()+"] initialized - no onInit function defined"),e.config.disabled&&(e.onEnable=null,e.onDisable=null,e.lock()),e.initialized=!0,e.fire("init",{}),e.enableOnInit&&(e.enableOnInit=!1,e.enable())}function defineGetConfig(e){var t=shmi.cloneObject(e.config);delete t["config-name"],Object.defineProperty(e,"getConfig",{value:function(){return shmi.cloneObject(t)},writable:!1})}function unsubscribeOnDisable(e,t){if(e.isActive()&&t.length)var s=e.listen("disable",(function(){s.unlisten(),s=null,t.forEach((function(e){e.unlisten()})),t=[]}))}function checkAddControlOptions(e){if("object"!=typeof e||null===e)throw new TypeError("Invalid options specified for `addControl`.");Array.isArray(e)||(e=[e]),e.forEach((e=>{if(e.config&&"object"==typeof e.config||(e.config={}),"string"!=typeof e.ui)throw new TypeError("Missing `ui` property on option: "+JSON.stringify(e,null,4));Array.isArray(e.children)&&checkAddControlOptions(e.children)}))}function lockRecursive(e){e.lock(!0),Array.isArray(e.controls)&&e.controls.forEach((function(e){lockRecursive(e)}))}function unlockRecursive(e){e.unlock(!0),Array.isArray(e.controls)&&e.controls.forEach((function(e){unlockRecursive(e)}))}shmi.pkg("visuals.core"),shmi.visuals.core.BaseControl=function(e){shmi.log("[BaseControl] cannot be instantiated",3)},shmi.visuals.core.BaseControl.prototype={uiType:"basecontrol",events:["register","register-name","enable","disable","init","delete"],tooltipProperties:["tooltip"],isContainer:!1,getClassName:function(){return"BaseControl"},getTooltip:function(){var e=this;if(!Array.isArray(e.tooltipProperties))return null;var t=e.tooltipProperties.filter((function(t){return shmi.objectHasOwnProperty(e.config,t)&&e.config[t]}));return t.length>0?e.config[t.shift()]:null},setTooltip:function(e){var t=this;shmi.checkArg("tooltip",e,"string","null"),t.element&&(e?t.element.setAttribute("title",shmi.localize(e)):t.element.removeAttribute("title"))},parseAttributes:function(){var e=this,t=shmi.requires("visuals.tools.iterate").iterateNodeList;ensureConfig(e),function checkGroupConfig(e){let t=e.element.getAttribute("data-config-name"),s=t?t.split(" "):null,n=-1;s&&(s=s.map((e=>e.trim())),s=s.filter((e=>""!==e)),n=s.findIndex((e=>0===e.indexOf("@"))),n>=0&&(e.element.setAttribute("data-group-config",s[n]),s.splice(n,1),e.element.setAttribute("data-config-name",s.join(" "))))}(e),t(e.element.attributes,(function(t,s){"data-group-config"!==t.nodeName&&0===t.nodeName.indexOf("data-")&&(e.config[t.nodeName.substr(5)]=t.nodeValue)}))},startup:function(){var e=this;!function initHandlers(e){var t=shmi.requires("visuals.session");if(t.Events=t.Events||{},!Array.isArray(e.events))throw new TypeError("Prototype is missing array of supported event types.");e._handlers={},e.events.forEach((function(s,n){if(void 0!==e._handlers[s])throw new TypeError("Eventtype '%s' is declared more than once.");e._handlers[s]={},t.Events[s]=t.Events[s]||{}}))}(e),e.element.style.display="none",ensureConfig(e),Object.defineProperty(e,"_init_",{value:{tokens:[]},writable:!1}),e.enableOnInit=!1,e.config["config-name"]?(Array.isArray(e.config["config-name"])||(e.config["config-name"]=[e.config["config-name"]]),e.loadConfig(0)):(shmi.loadGroupConfig(e),defineGetConfig(e),e.loadTemplate())},loadConfig:function(e){var t=this;if(ensureConfig(t),t.config["config-name"]&&t.config["config-name"].length>0){var s=t.config["config-name"][e];if(0===s.indexOf(shmi.c("RES_URL_PREFIX"))){var n=null,a=t.config["config-name"][e].split("@");"/"===a[0][a[0].length-1]?((a=a[0].split("/")).pop(),n=a.join("/")):n=(a=a[0].split("/")).join("/"),shmi.loadResource(n,(function loadCfgCB(s,n,a){t.applyConfig(s,n,e,a)}))}else{var r=null;r=0===s.indexOf(":")?s.replace(":","")+shmi.c("CONFIG_EXT"):shmi.c("CONFIG_PATH")+s+shmi.c("CONFIG_EXT"),shmi.loadResource(r,(function loadCfgCB(s,n,a){t.applyConfig(s,n,e,a)}))}}else shmi.loadGroupConfig(t),defineGetConfig(t),t.loadTemplate()},applyConfig:function(e,t,s,n){var a=this,r=shmi.requires("visuals.tools.iterate").iterateObject;if(ensureConfig(a),t||"string"!=typeof e)console.warn("["+a.getClassName()+"]","config file not found - 404:",n);else{var o={};try{r(o=JSON.parse(e),(function(e,t){a.config[t]=o[t]}))}catch(e){console.error("["+a.getClassName()+"]","failed to parse configuration:",n,e)}}a.config["config-name"].length===s+1?(shmi.loadGroupConfig(a),defineGetConfig(a),a.loadTemplate()):a.loadConfig(s+1)},loadTemplate:function(){var e=this;if(ensureConfig(e),e.config.template)if(0===e.config.template.indexOf(shmi.c("RES_URL_PREFIX")))shmi.loadResource(e.config.template,e.applyTemplate.bind(e));else{var t=null;t=0===e.config.template.indexOf(":")?e.config.template.replace(":","")+shmi.c("TEMPLATE_EXT"):shmi.c("TEMPLATE_PATH")+e.config.template+shmi.c("TEMPLATE_EXT"),shmi.loadResource(t,e.applyTemplate.bind(e))}else setCssClasses(e),e.init()},applyTemplate:function(e,t){var s=this;if(ensureConfig(s),!s.element)throw new TypeError("["+s.getClassName()+"] control has no base element.");setCssClasses(s),"function"==typeof s.onTemplate?s.onTemplate(e,t,s.init.bind(s)):(t?console.error("["+s.getClassName()+"] Template file '"+shmi.c("TEMPLATE_PATH")+s.config.template+shmi.c("TEMPLATE_EXT")+"' not found  - 404"):s.element instanceof HTMLElement?e&&(s.element.innerHTML=e):s.element instanceof SVGElement?e&&shmi.setSvgContent(s.element,e):console.error("["+s.getClassName()+"] Error in template '"+s.config.template+"base element is neither HTMLElement nor SVGElement"),s.init())},init:function(){var e=this,t=null;e.element.style.display="",ensureConfig(e),e.setTooltip(e.getTooltip()),Array.isArray(e.config._appearances_)&&e.config._appearances_.forEach((function(t){t&&null===t.condition&&"string"==typeof t.modifier&&t.modifier.trim().length>0?updateAppearance(e,t.modifier,!0):null===t.condition&&console.error("[BaseControl] Invalid appearance configured:",t)})),t=e.listen("register-name",(function initNamed(s){var n=null;t.unlisten(),e._init_.tokens.splice(e._init_.tokens.indexOf(t),1),t=null,function setName(e,t){var s=t.split(".");Object.defineProperty(e,"name",{value:t,writable:!1}),e.element.setAttribute("data-name",s[s.length-1])}(e,s.detail.name),"function"==typeof e.onRegister?shmi.isRegistered(e.element,e.uiType)?e.onRegister(initializeControl.bind(null,e)):(n=e.listen("register",(function(){n.unlisten(),e._init_.tokens.splice(e._init_.tokens.indexOf(n),1),n=null,e.onRegister(initializeControl.bind(null,e))})),e._init_.tokens.push(n)):initializeControl(e)})),e._init_.tokens.push(t),shmi.registerName(e,e.config.name)},onInit:function(){},enable:function(){const e=this,t=shmi.requires("visuals.tools.controller"),{ConditionObserver:s}=shmi.requires("visuals.tools.conditions");if(e.initialized){if(!e.active){if(e.active=!0,e.onEnable&&e.onEnable(),e.fire("enable",{name:e.getName()}),Array.isArray(e.config._controllers_)&&e.config._controllers_.forEach((function(s){t.registerSlot(s.name,s.slot,e)})),Array.isArray(e.config._appearances_)){let t=[];e.config._appearances_.forEach((function(n){n&&null!==n.condition&&("string"!=typeof n.condition.type&&(n.condition=function updateLegacyCondition(e){return{type:"condition",mode:"AND",elements:[{type:"comparison",operand1:{type:"item",value:e.item},operand2:{type:"string"==typeof e.compare?"item":"value",value:e.compare},operator:e.operator}]}}(n.condition)),"string"==typeof n.modifier&&n.modifier.trim().length>0?t.push(new s(n.condition,(t=>{updateAppearance(e,n.modifier,t)}))):console.error("[BaseControl] Conditional appearance has an invalid modifier configured:",n))})),unsubscribeOnDisable(e,t)}!0===e.locked&&e.lock(),e.config._lock_&&"condition"===e.config._lock_.type&&unsubscribeOnDisable(e,[new s(e.config._lock_,(t=>{t?lockRecursive(e):unlockRecursive(e)}))])}}else e.enableOnInit=!0},onEnable:function(){},disable:function(){var e=this;e.enableOnInit=!1,e.active&&(e.active=!1,e.onDisable&&e.onDisable(),e.fire("disable",{name:e.getName()}))},onDisable:function(){},subscribeItem:function(e){return shmi.visuals.session.ItemManager.subscribeItem(e,this)},unsubscribeItem:function(e,t){shmi.visuals.session.ItemManager.unsubscribeItem(e,t)},setValue:function(e,t,s){var n=this;n.initialized?n.onSetValue&&n.onSetValue(e,t,s):console.warn("["+n.getClassName()+"] setValue - not initialized yet.")},setProperties:function(e,t,s,n,a,r,o,l,u,c){this.onSetProperties&&this.onSetProperties(e,t,s,n,a,r,o,l,u,c)},lock:function(e){var t=this;void 0===t.forceLocked&&(t.forceLocked=!1),t.initialized&&"function"==typeof t.onLock&&t.onLock(),t.locked=!0,t.forceLocked=!0===e||t.forceLocked},unlock:function(e){var t=this;(!t.forceLocked||t.forceLocked&&e)&&(t.initialized&&"function"==typeof t.onUnlock&&t.onUnlock(),t.locked=!1,t.forceLocked=!1)},setItem:function(e){this.onSetItem?this.onSetItem():this.active?(this.disable(),this.config.item=e,this.enable()):this.config.item=e},getItem:function(){return this.config.item?this.config.item:null},isInitialized:function(){return this.initialized},isActive:function(){return!!this.active},getName:function(){return this.name?this.name:null},fire:function(e,t,s=!1){const n=this,a=shmi.requires("visuals.tools.iterate").iterateObject;n._hasEvent(e);const r=shmi.visuals.session,o={source:n,type:e,detail:t};function fireAway(){let t=0;return a(n._handlers[e],(function(s,a){n._handlers[e][a](o),t++})),a(r.Events[e],(function(e){e(o)&&t++})),t}function logFired(e){!0===r.config.event_debug&&console.log("[",n.getClassName(),"] event",o,"fired [",e,"listeners]")}if(s)return shmi.decouple((()=>logFired(fireAway()))),0;const l=fireAway();return logFired(l),l},_hasEvent:function(e){if(!Array.isArray(this.events))throw new Error("ERROR: "+this.getClassName()+" object does not support events");if(-1===this.events.indexOf(e))throw new Error("ERROR: "+this.getClassName()+" unsupported event_type '"+e+"'")},listen:function(e,t){var s=this;s._hasEvent(e);for(var n=Date.now();void 0!==s._handlers[e][n];)n++;s._handlers[e][n]=t;var a={name:e,listenerId:n,unlisten:(null,function(){s.unlisten(a)})};return a},listenOnce:function(e,t){let s=0;const n=this.listen(e,((...e)=>{2&s||n.unlisten(),1&s||(s|=1,t(...e))})),a=n.unlisten;return n.unlisten=()=>{1&s?s|=6:(s|=2,a.call(n))},n},unlisten:function(e,t){"object"==typeof e&&1===arguments.length?(this._hasEvent(e.name),delete this._handlers[e.name][e.listenerId]):(this._hasEvent(e),delete this._handlers[e][t.listenerId])},parseChildren:function(e,t){var s=this,n=null,a=null;if(!s.isContainer)throw new TypeError("["+s.getClassName()+"] not a container control, cannot parse child controls.");if(!shmi.testParentChild(s.element,e))throw new TypeError("["+s.getClassName()+"] element not contained within control.");(a=shmi.parseControls(e,!1,s.element)).forEach((function(e){s.controls.push(e)})),0===s.controls.length?t(a):null!==(n=shmi.waitOnInit(s.controls,(function(){var e=s._init_.tokens.indexOf(n);-1!==e&&s._init_.tokens.splice(e,1),n=null,t(a)})))&&s._init_.tokens.push(n)},getChildren:function(){return this.isContainer?this.controls:null},isDeleted:function(){return!0===this.deleted},_setCssClasses:function(){console.warn("["+this.getClassName()+"]","_setCssClasses - is deprecated and should not be called by control implementations. This message is usually generated when BaseControl methods have been replaced, use BaseControl methods 'onTemplate' and 'onRegister' to avoid having to override system methods."),setCssClasses(this)},getParent:function(){return this.parentContainer||null},addControl:function(e,t){const s=this;"function"==typeof s.onAddControl?(checkAddControlOptions(e),s.onAddControl(e,t)):(console.error("["+s.getClassName()+"]","no implementation 'onAddControl' for control type:",s.uiType),"function"==typeof t&&t(null,[]))},isLocked:function(){return this.locked||!1}}}(),function(){const e=864e5;function getUnusedIndex(e){let t=null;do{t=Math.floor(Math.random()*Number.MAX_SAFE_INTEGER)}while(e[t]);return t}function deleteRequest(e,t){const s=e.pendingRequests[t];void 0!==s&&(clearTimeout(s.timeout),function unregisterMessageHandlerForRequest(e,t){const s=e.messageHandlerForRequests[t];void 0!==s&&--s.refCnt<=0&&(delete e.messageHandlerForRequests[t],e.unregisterMessageHandler(t,s.handlerId))}(e,s.cmd),delete e.pendingRequests[t])}function completeRequest(e,t,s,n){const a=e.pendingRequests[t];if(void 0!==a){deleteRequest(e,t);const r=n?new shmi.visuals.core.ApiError(a.cmd,n,a.apiErrorOptions??{}):0;try{a.callback(s,r)}catch(e){console.error("Uncaught",e,"\nin api request callback.\n    request: ",a,"\nCallback was called with","\n    data:",s,"\n    error:",n)}}}function cancelRequest(e,t,s){completeRequest(e,t,null,s??{errc:-1,category:"unknown",message:"operation cancelled"})}function promiseHandler(e,t,s,n){n?t(n):e(s)}function requestMessageHandler(e,t){var s=e.pendingRequests[t.id];s?(!function translateLegacyError(e){void 0===e.error&&"number"==typeof e.st&&(0===e.st?e.error=null:e.error={errc:e.st,category:"connect-2.1:compatibility",message:"generic error"},delete e.st)}(t),function collectPayloadData(e,t){const s=shmi.requires("visuals.tools.iterate.iterateObject"),n=t.fragmented||e.data,a=!t.fragmented;return n?null===e.data?e.data=t.data:Array.isArray(t.data)?e.data.push(...t.data):"object"==typeof t.data&&s(t.data,(function(t,s){Array.isArray(t)&&shmi.objectHasOwnProperty(e.data,s)?e.data[s].push(...t):e.data[s]=t})):e.data=t.data,a}(s,t)&&completeRequest(e,t.id,s.data,null===t.error?0:t.error)):console.error("[ConnectSession]","unknown request-ID:",t)}shmi.visuals.core.ConnectSession=function ConnectSession(t){const s=shmi.requires("visuals.io.SocketConnection");Object.defineProperties(this,{wsUrl:{configurable:!1,value:t,writable:!1},socket:{configurable:!1,value:new s(t,this),writable:!1},messageHandlers:{configurable:!1,value:{},writable:!1},pendingRequests:{configurable:!1,value:{},writable:!1},messageHandlerForRequests:{configurable:!1,value:{},writable:!1},REQUEST_TIMEOUT:{configurable:!1,value:e,writable:!1}}),Object.freeze(this)},shmi.visuals.core.ConnectSession.prototype={constructor:shmi.visuals.core.ConnectSession,connect:function(e){this.socket.connect(e)},disconnect:function disconnect(){const e=shmi.requires("visuals.tools.iterate.iterateObject");this.socket.disconnect(),e(this.pendingRequests,(e=>{cancelRequest(this,e.id)}))},postMessage:function(e){const t=this.messageHandlers[e.cmd];t?Object.values(t).forEach((t=>{try{t(e)}catch(e){console.error("Uncaught ",e,"\nin message handler.")}})):console.warn("[ConnectSession]","No message handler registered for ",e.cmd,"\n  message: ",e)},registerMessageHandler:function registerMessageHandler(e,t){void 0===this.messageHandlers[e]&&(this.messageHandlers[e]={});var s=getUnusedIndex(this.messageHandlers[e]);return this.messageHandlers[e][s]=t,shmi.log("[registerMsgHandler] registered message handler '"+e+"'",2),s},unregisterMessageHandler:function unregisterMessageHandler(e,t){var s=!1;return this.messageHandlers[e]&&this.messageHandlers[e][t]&&(delete this.messageHandlers[e][t],shmi.log("[unregisterMsgHandler] unregistered message handler '"+e+"'",2),s=!0),this.messageHandlers[e]&&0===Object.keys(this.messageHandlers[e]).length&&delete this.messageHandlers[e],s},request:function request(t,s,n,a,r,o){var l,u=function createRequest(t,s,n,a,r,o){const l=getUnusedIndex(t.pendingRequests);return t.pendingRequests[l]={id:l,cmd:s,parameters:n,callback:a,data:null,timeout:setTimeout((function(){console.error("[ConnectSession]","timeout on request:",t.pendingRequests[l]),cancelRequest(t,l)}),r||e),timeoutDuration:r||e,apiErrorOptions:o},t.pendingRequests[l]}(this,t,s,n,a,o),c={cmd:t,id:u.id,data:s};r&&(c.target=r),l=JSON.stringify(c),function registerMessageHandlerForRequest(e,t){shmi.objectHasOwnProperty(e.messageHandlerForRequests,t)?++e.messageHandlerForRequests[t].refCnt:e.messageHandlerForRequests[t]={handlerId:e.registerMessageHandler(t,requestMessageHandler.bind(null,e)),refCnt:1}}(this,t),this.socket.sendMessage(l)},requestPromise:function requestPromise(e,t,s){const{customTimeout:n,target:a,apiErrorOptions:r}=s||{};return new Promise(((s,o)=>this.request(e,t,promiseHandler.bind(null,s,o),n,a,r)))}}}(),function(){function alarmCallback(e,t,s){var n=[];e.fields.forEach((function(e,s){var a=function getFieldValue(e,t){var s=null;switch(t){case"level":s=e.severity;break;case"status":s=e.acknowledgeable&&!e.acknowledged;break;case"come":s=e.timestamp_in;break;case"gone":s=e.timestamp_out;break;case"json":s=JSON.stringify(e);break;default:void 0!==e[t]&&(s=e[t])}return s}(t,e);switch(typeof a){case"string":n.push({type:shmi.c("TYPE_STRING"),value:a});break;case"boolean":n.push({type:shmi.c("TYPE_BOOL"),value:a?1:0,min:0,max:1});break;case"number":n.push({type:shmi.c("TYPE_FLOAT"),value:a,min:Number.NaN,max:Number.NaN});break;default:n.push({type:shmi.c("TYPE_STRING"),value:"NULL",min:Number.NaN,max:Number.NaN})}})),e.insertRow(n,void 0,!s)}function createVirtualItem(e,t,s,n,a){var r=shmi.createVirtualItem(t,s.type,s.min,s.max,s.value,null);return r.setDataGridInfo(e.name,n,a),r}function compareColumnValue(e,t,s){return t[e].value<s[e].value?-1:t[e].value===s[e].value?0:1}function updateSubscribedRows(e){var t=shmi.requires("visuals.tools.iterate").iterateObject,s=[];t(e.subscribers,(function(t,n){for(var a=e.getCurrentIDs(n),r=0;t.offset+r<e.totalRows&&r<t.size;r++)-1===s.indexOf(a[r])&&s.push(a[r])})),s.forEach((function(t,s){var n=e.data[t];n&&n.forEach((function(e,t){e.item.readValue(!0)!==e.value&&e.item.writeValue(e.value,!0)}))}))}shmi.pkg("visuals.core"),shmi.visuals.core.DataGridAlarms=function(){this.name="alarms",this.fields=["id","index","status","level","come","active","gone","group","json"],this.conditions=[],this.type="ALARMS",this.data={},this.subscribers={},this.prefix="virtual:grid:"+this.name+":",this.totalRows=0,this.nextRowId=0,this.taskQueue=[],this.order=[0,"ASC"],this.filter={},this._subID=null,this.AM=shmi.visuals.session.AlarmManager,this.indexFields=["id"],this.lastStateUpdate=0,this.stateTO=0,this.singleStateTO=0,this.init()},shmi.visuals.core.DataGridAlarms.prototype={init:function(){var e=this,t=shmi.visuals.session.config;t&&t["disable-alarm-prefetch"]||(e._subID=e.AM.subscribeAlarms(e,alarmCallback.bind(null,e)))},subscribePage:function(e,t,s){for(var n=this,a=Date.now(),r=shmi.visuals.session.config;void 0!==n.subscribers[a];)a++;var o={};o.id=a,o.offset=e,o.size=t,o.onChange=s,o.lastUpdate=0,n.subscribers[a]=o,1===Object.keys(n.subscribers).length&&r&&r["disable-alarm-prefetch"]?n._subID=n.AM.subscribeAlarms(n,alarmCallback.bind(null,n)):shmi.decouple((function(){n.subscribers[a]&&(n.subscribers[a].lastUpdate=Date.now(),n.subscribers[a].onChange(n._calcState(a)))}));var l={};return l.id=a,l.prefix=n.prefix,l},getFields:function(e){return this.fields},getIndexFields:function(){var e=this,t=[];return e.indexFields.forEach((function(s){var n=e.fields.indexOf(s);-1!==n?t.push(n):console.warn("[DataGrid '"+this.name+"'] index field not found: "+s)})),t},getRowIndex:function(e){var t=this,s=[];return this.getIndexFields().forEach((function(n){s.push(t.data[e][n].value)})),s},searchIndexRowId:function(e){var t=this,s=-1,n=t.getIndexFields();return(0,shmi.requires("visuals.tools.iterate").iterateObject)(t.data,(function(a,r){t.searchIndexFields(r,n,e)&&-1===s&&(s=parseInt(r))})),s},searchIndexFields:function(e,t,s){var n=this,a=0;return t.forEach((function(t,r){n.data[e][t].value===s[r]&&a++})),a>0&&a===t.length},_getRowByAlarmID:function(e){var t=this,s=shmi.requires("visuals.tools.iterate").iterateObject,n=null;return s(t.data,(function(s,a){t.data[a][0].value===e&&(n=a)})),n},insertRow:function(e,t,s){var n=this,a=0,r=null,o=n._getRowByAlarmID(e[0].value);if(void 0!==t)a=t;else if(null!==o)a=o;else for(;void 0!==n.data[a];)a++;if(void 0===n.data[a]){if(1===e[2].value||1===e[5].value){n.data[a]=e;for(var l=0;l<e.length;l++){var u=e[l],c="virtual:grid:"+n.name+":"+a+":"+l,m=shmi.visuals.session.ItemManager;null===m.getItem(c)||!1===m.getItem(c).initialized?n.data[a][l].item=createVirtualItem(n,c,u,a,l):(n.data[a][l].item=m.getItem(c),m.writeValue(c,u.value))}}}else for(l=0;l<e.length;l++){if("active"===n.fields[l]&&0===e[l].value&&1!==e[2].value){delete n.data[a];break}void 0===n.data[a][l].item&&(u=e[l],c="virtual:grid:"+n.name+":"+a+":"+l,n.data[a][l].item=createVirtualItem(n,c,u,a,l)),n.data[a][l].value=e[l].value,n.data[a][l].item.writeValue(e[l].value)}return!0!==s&&(n.totalRows=n._calcKeys().length,r=Date.now(),clearTimeout(n.stateTO),n.stateTO=0,r-n.lastStateUpdate>shmi.c("ACTION_RETRY_TIMEOUT")?shmi.raf(n.sort.bind(n,n.order[0],n.order[1],!0)):n.stateTO=setTimeout(n.sort.bind(n,n.order[0],n.order[1],!0),shmi.c("ACTION_RETRY_TIMEOUT"))),n._getRowByAlarmID(e[0].value)},deleteRow:function(e){if(Array.isArray(e))for(var t=0;t<e.length;t++)void 0!==this.data[e[t]]?this.AM.ackAlarm(this.data[e[t]][0].value):shmi.log("[DataGridAlarms] alarm not found row-id="+e,2);else void 0!==this.data[e]?this.AM.ackAlarm(this.data[e][0].value):shmi.log("[DataGridAlarms] alarm not found row-id="+e,2)},deleteAll:function(){this.AM.ackAlarm(-1)},unsubscribe:function(e){var t=this,s=shmi.visuals.session.config,n=shmi.requires("visuals.tools.iterate").iterateObject;if(delete t.subscribers[e],0===Object.keys(t.subscribers).length&&s&&s["disable-alarm-prefetch"]){t.AM.unsubscribeAlarms(t._subID);var a=shmi.visuals.session.ItemManager;n(t.data,(function(e,s){for(var n=0;n<t.data[s].length;n++)a.removeItem(t.data[s][0].item.name);delete t.data[s]}))}},setOffset:function(e,t){var s=this,n=s.subscribers[t],a=Date.now();void 0!==n&&(e>s.totalRows&&(e=s.totalRows),n.offset=e,clearTimeout(s.singleStateTO),s.singleStateTO=0,a-n.lastUpdate>shmi.c("ACTION_RETRY_TIMEOUT")?(n.lastUpdate=a,shmi.raf((function(){(n=s.subscribers[t])&&n.lastUpdate===a&&(updateSubscribedRows(s),n.onChange(s._calcState(t)))}))):s.singleStateTO=setTimeout((function(){(n=s.subscribers[t])&&(n.lastUpdate=Date.now(),updateSubscribedRows(s),n.onChange(s._calcState(t)))}),shmi.c("ACTION_RETRY_TIMEOUT")))},getRowCount:function(){return this.totalRows},setFilter:function(e,t){var s=this,n=shmi.requires("visuals.tools.iterate").iterateObject;e===s.fields.indexOf("level")?(s.filter[s.fields[e]]=t,s.totalRows=s._calcKeys().length,clearTimeout(s.stateTO),s.stateTO=setTimeout((function(){n(s.subscribers,(function(e,t){s.subscribers[t].offset=0})),updateSubscribedRows(s),n(s.subscribers,(function(e,t){s.subscribers[t].onChange(s._calcState(t))}))}),shmi.c("ACTION_RETRY_TIMEOUT"))):shmi.log("[DataGridAlarms] filtering not supported for column index "+e,2)},getFilters:function(){for(var e=this,t=[],s=0;s<e.fields.length;s++)void 0!==e.filter[e.fields[s]]?t.push(e.filter[e.fields[s]]):t.push(null);return t},refresh:function(){},clearFilter:function(e){var t=this,s=shmi.requires("visuals.tools.iterate").iterateObject;e===t.fields.indexOf("level")||-1===e?(t.filter={},t.totalRows=t._calcKeys().length,clearTimeout(t.stateTO),t.stateTO=setTimeout((function(){s(t.subscribers,(function(e,s){t.subscribers[s].offset=0,t.subscribers[s].onChange(t._calcState(s))}))}),shmi.c("ACTION_RETRY_TIMEOUT"))):shmi.log("[DataGridAlarms] filtering not supported for column index "+e,2)},_calcKeys:function(){var e=[];if(void 0!==this.filter.level){var t=Object.keys(this.data),s=[];Array.isArray(this.filter.level)?s=this.filter.level:s.push(this.filter.level);for(var n=0;n<t.length;n++)-1!==s.indexOf(this.data[t[n]][this.fields.indexOf("level")].value)&&e.push(t[n])}else e=Object.keys(this.data);return e},sort:function(e,t,s,n){var a=this;a.order=-1===e?[0,"ASC"]:[e,t],function sortObj(e,t,s,n){var a=shmi.requires("visuals.session.ItemManager"),r=shmi.requires("visuals.tools.iterate").iterateObject,o=[];r(s,(function(e,t){o.push(s[t]),delete s[t]})),o.sort(compareColumnValue.bind(null,t)),"DESC"===n&&o.reverse();for(var l=0;l<o.length;l++)s[l]=o[l],s[l].forEach((function(t,n){var r="virtual:grid:"+e.name+":"+l+":"+n,o=a.getItem(r);s[l][n].item=o}));updateSubscribedRows(e)}(a,a.order[0],a.data,a.order[1]),function updateSubscribers(e,t){var s=shmi.requires("visuals.tools.iterate").iterateObject,n=Date.now();s(e.subscribers,(function(s,a){!0!==t&&(e.subscribers[a].offset=0),e.subscribers[a].lastUpdate=n,e.subscribers[a].onChange(e._calcState(a))})),e.lastStateUpdate=n}(a,s)},getCurrentIDs:function(e){for(var t=[],s=this.subscribers[e],n=this._calcKeys(),a=s.offset;a<s.offset+s.size&&void 0!==n[a];a++)t.push(parseInt(n[a]));return t},getAllIDs:function(e){for(var t=[],s=this._calcKeys(),n=0;n<s.length;n++)t.push(parseInt(s[n]));return t},getRowData:function(e){return void 0!==this.data[e]?this.data[e]:null},_calcState:function(e){var t=this.subscribers[e],s={status:"OK"};return s.totalRows=this.totalRows,s.offset=Math.min(t.offset,Math.max(s.totalRows-1,0)),s}}}(),function(){function getFilterParameter(e){var t=shmi.requires("visuals.tools.iterate.iterateObject"),s={mode:e.filterChaining,clauses:[]};return t(e.filter,(function(e){s.clauses.push(e)})),s}shmi.pkg("visuals.core");var e={id:"id",index:"index",level:"severity",come:"timestamp_in",gone:"timestamp_out",group:"group",needAck:"acknowledgeable",isAck:"acknowledged",alarmAck:"timestamp_acknowledged",ackUser:"acknowledged_by",json:"id"};function getSortParameter(t){return[{column:e[t.fields[t.order[0]]],order:t.order[1],location:"property"}]}function getQueryOptions(e,t){var s=e.subscribers[t],n=null,a=shmi.requires("visuals.tools.iterate.iterateObject");return void 0===t&&(s={size:null,offset:0},a(e.subscribers,(function(e,t){e.size>s.size&&(s.size=e.size),e.offset=0}))),s&&(n={limit:s.size,offset:s.offset,filter:getFilterParameter(e),sort:getSortParameter(e)}),n}function reloadAlarms(e){var t=shmi.requires("visuals.session.AlarmManager"),s=shmi.requires("visuals.tools.iterate.iterateObject"),n=createLoadRequest(e);s(e.data,(function(t,s){!function deleteRow(e,t){var s=e.data[t];s&&Array.isArray(s)&&delete e.data[t]}(e,s)})),e.lastRequest=n,t.getHistoricAlarms((function alarmCb(t,a){delete e.requests[n.id],e.lastRequest===n&&(e.totalRows=0,a&&Array.isArray(a.alarms)?(a.alarms.forEach((function(t,s){alarmCallback(e,t,s,s!==a.alarms.length-1)})),e.totalRows=a.total_count):console.error("DataGridAlarmsHistoric","failed to retrieve historic alarms"),s(e.subscribers,(function(t,s){t.onChange({status:"OK",offset:0,totalRows:e.totalRows})})))}),getQueryOptions(e))}function loadAlarms(e,t){var s=shmi.requires("visuals.session.AlarmManager"),n=null,a=e.subscribers[t];a&&(a=null,n=createLoadRequest(e),e.lastRequest=n,s.getHistoricAlarms((function alarmCb(s,r){delete e.requests[n.id],e.lastRequest===n&&(a=e.subscribers[t])&&(e.totalRows=0,r&&Array.isArray(r.alarms)?(r.alarms.forEach((function(t,s){alarmCallback(e,t,a.offset+s,s!==r.alarms.length-1)})),e.totalRows=r.total_count):console.error("DataGridAlarmsHistoric","failed to retrieve historic alarms"),a.onChange({status:"OK",offset:a.offset,totalRows:e.totalRows}))}),getQueryOptions(e,t)))}function alarmCallback(e,t,s,n){var a=[];e.fields.forEach((function(e,s){var n=function getFieldValue(e,t){var s=null;switch(t){case"level":s=e.severity;break;case"status":s=e.acknowledgeable&&!e.acknowledged;break;case"come":s=e.timestamp_in;break;case"gone":s=e.timestamp_out;break;case"json":s=JSON.stringify(e);break;case"alarmAck":s=e.timestamp_acknowledged;break;case"ackUser":s=e.acknowledged_by;break;default:void 0!==e[t]&&(s=e[t])}return s}(t,e);switch(typeof n){case"string":a.push({type:shmi.c("TYPE_STRING"),value:n});break;case"boolean":a.push({type:shmi.c("TYPE_BOOL"),value:n?1:0,min:0,max:1});break;case"number":a.push({type:shmi.c("TYPE_FLOAT"),value:n,min:Number.NaN,max:Number.NaN});break;default:a.push({type:shmi.c("TYPE_STRING"),value:"NULL",min:Number.NaN,max:Number.NaN})}})),e.insertRow(a,s,n)}function createVirtualItem(e,t,s,n,a){var r=shmi.requires("visuals.session.ItemManager").getItem(t),o=null;return r&&r.initialized?(r.readValue()!==s.value&&r.writeValue(s.value),r):(o=shmi.createVirtualItem(t,s.type,s.min,s.max,s.value,null),-1===e.itemsCreated.indexOf(t)&&e.itemsCreated.push(t),o.setDataGridInfo(this.name,n,a),o)}function createLoadRequest(e){for(var t=0;void 0!==e.requests[t];)t+=1;return e.requests[t]={id:t},e.requests[t]}shmi.visuals.core.DataGridAlarmsHistoric=function(){this.name="alarms-historic",this.fields=["id","index","level","come","gone","group","needAck","isAck","alarmAck","ackUser","json"],this.conditions=[],this.type="ALARMS_HISTORIC",this.data={},this.subscribers={},this.prefix="virtual:grid:"+this.name+":",this.totalRows=0,this.nextRowId=0,this.taskQueue=[],this.order=[0,"ASC"],this.filter={},this.filterChaining="AND",this._subID=null,this.AM=shmi.visuals.session.AlarmManager,this.indexFields=["id"],this.requests={},this.lastRequest=null,this.itemsCreated=[],this.init()},shmi.visuals.core.DataGridAlarmsHistoric.prototype={init:function(){},subscribePage:function(e,t,s){for(var n=Date.now();void 0!==this.subscribers[n];)n++;var a={};a.id=n,a.offset=e,a.size=t,a.onChange=s,a.lastUpdate=0,a.updateTimeout=0,this.subscribers[n]=a,loadAlarms(this,a.id);var r={};return r.id=n,r.prefix=this.prefix,r},getFields:function(e){return this.fields},getIndexFields:function(){var e=this,t=[];return e.indexFields.forEach((function(s){var n=e.fields.indexOf(s);-1!==n?t.push(n):console.warn("[DataGrid '"+this.name+"'] index field not found: "+s)})),t},getRowIndex:function(e){var t=this,s=[];return this.getIndexFields().forEach((function(n){s.push(t.data[e][n].value)})),s},searchIndexRowId:function(e){var t=this,s=-1,n=t.getIndexFields();return(0,shmi.requires("visuals.tools.iterate").iterateObject)(t.data,(function(a,r){t.searchIndexFields(r,n,e)&&-1===s&&(s=parseInt(r))})),s},searchIndexFields:function(e,t,s){var n=this,a=0;return t.forEach((function(t,r){n.data[e][t].value===s[r]&&a++})),a>0&&a===t.length},setFilterChaining:function(e){"OR"===e||"AND"===e?this.filterChaining=e:console.error("[DataGridAlarmsHistoric] invalid filter chaining mode:",e)},insertRow:function(e,t,s){var n,a,r=null;if(void 0===t)return console.error("DataGridAlarmsHistoric","no row-index specified on insertRow"),null;r=t,void 0===this.data[r]&&(this.data[r]=e);for(var o=0;o<e.length;o++)n=e[o],a="virtual:grid:"+this.name+":"+r+":"+o,this.data[r][o].item=createVirtualItem(this,a,n,r,o),this.data[r][o].value=n.value;return r},deleteRow:function(e){},deleteAll:function(){},unsubscribe:function(e){var t=this,s=shmi.requires("visuals.tools.iterate.iterateObject");if(delete t.subscribers[e],0===Object.keys(t.subscribers).length){s(t.data,(function(e,s){delete t.data[s]}));var n=shmi.requires("visuals.session.ItemManager");t.itemsCreated.forEach((function(e){n.removeItem(e)})),t.itemsCreated=[],t.totalRows=0,t.lastRequest=null}},setOffset:function(e,t){var s=this,n=s.subscribers[t],a=null;void 0!==n&&(e>s.totalRows&&(e=s.totalRows),n.offset=e,a=Date.now(),clearTimeout(n.updateTimeout),n.updateTimeout=0,a-n.lastUpdate>shmi.c("ACTION_RETRY_TIMEOUT")?(n.lastUpdate=a,shmi.raf((function(){(n=s.subscribers[t])&&n.lastUpdate===a&&loadAlarms(s,t)}))):n.updateTimeout=setTimeout((function(){(n=s.subscribers[t])&&(n.lastUpdate=Date.now(),loadAlarms(s,t))}),shmi.c("ACTION_RETRY_TIMEOUT")))},getRowCount:function(){return this.totalRows},setFilter:function(e,t){var s=this,n=shmi.requires("visuals.tools.enum.createEnum")(s.fields);-1!==[n.level,n.come,n.group].indexOf(e)?(e===n.level?(s.filter.level={column:"severity",mode:"OR",location:"property",clauses:[]},Array.isArray(t)?t.forEach((function(e){s.filter.level.clauses.push({operator:"==",value:parseInt(e)})})):s.filter.level.clauses.push({operator:"==",value:parseInt(t)})):e===n.group?(s.filter.group={column:"group",mode:"OR",location:"property",clauses:[]},Array.isArray(t)?t.forEach((function(e){s.filter.group.clauses.push({operator:"==",value:parseInt(e)})})):s.filter.group.clauses.push({operator:"==",value:parseInt(t)})):e===n.come&&(s.filter.come={column:"timestamp_in",mode:"AND",location:"property",clauses:[]},Array.isArray(t)&&t.length>=2?s.filter.come.clauses.push({operator:">=",value:1e7*parseInt(t[0])},{operator:"<=",value:1e7*parseInt(t[1])}):s.filter.come.clauses.push({operator:">=",value:1e7*parseInt(t)})),reloadAlarms(s)):shmi.log("[DataGridAlarmsHistoric] filtering not supported for column index "+e,2)},getFilters:function(){for(var e=this,t=[],s=0;s<e.fields.length;s++)void 0!==e.filter[e.fields[s]]?t.push(e.filter[e.fields[s]]):t.push(null);return t},refresh:function(){reloadAlarms(this)},clearFilter:function(e){var t=this,s=null;-1===e?t.filter={}:t.fields[e]&&(s=t.fields[e],delete t.filter[s]),reloadAlarms(t)},sort:function(e,t){this.order=-1===e?[0,"ASC"]:[e,t],reloadAlarms(this)},getSortOrder:function(){return shmi.cloneObject(this.order)},getCurrentIDs:function(e){for(var t=[],s=this.subscribers[e],n=s.offset;n<s.offset+s.size;n++)n<this.totalRows&&t.push(n);return t},getAllIDs:function(e){for(var t=[],s=0;s<this.totalRows;s++)t.push(s);return t},getRowData:function(e){return void 0!==this.data[e]?this.data[e]:null}}}(),shmi.pkg("visuals.core"),shmi.visuals.core.DataGridDB=function(e,t,s,n,a,r){this.name=e,this.db=t,this.table=s,this.fields=n,this.indexFields=r||[],this.conditions=a||[],this.type="DB2",this.data={},this.subscribers={},this.prefix="virtual:grid:"+this.name+":",this.nextRowID=0,this.query=null,this.totalRows=0,this.taskQueue=[],this.order=null,this._writeTimeout=0,this.loadTimeout=15e3,this._loadTO=0,this.filter={},this.filter.chaining="AND"},shmi.visuals.core.DataGridDB.prototype={init:function(){this.taskQueue=[],this.subscribers={}},subscribePage:function(e,t,s){for(var n=Date.now();void 0!==this.subscribers[n];)n++;var a={};a.id=n,a.offset=e,a.size=t,a.onChange=s,this.subscribers[n]=a;var r={};r.id=n,r.prefix=this.prefix;var o=[];if(void 0===this.q_id){o.push({type:"query"})}var l={type:"load",subID:n};return o.push(l),this._queueTasks(o),r},getFields:function(){return this.fields},getIndexFields:function(){var e=[];return this.indexFields.forEach(function(t){var s=this.fields.indexOf(t);-1!==s?e.push(s):shmi.log("[DataGrid '"+this.name+"'] index field not found: "+t,3)}.bind(this)),e},getRowIndex:function(e){var t=[];return this.getIndexFields().forEach(function(s){t.push(this.data[e][s].value)}.bind(this)),t},searchIndexRowId:function(e){var t=this,s=-1,n=t.getIndexFields();return(0,shmi.requires("visuals.tools.iterate").iterateObject)(t.data,(function(a,r){t.searchIndexFields(r,n,e)&&-1===s&&(s=parseInt(r))})),s},searchIndexFields:function(e,t,s){var n=this,a=0;return t.forEach((function(t,r){n.data[e][t].value===s[r]&&a++})),a>0&&a===t.length},insertRow:function(e){var t=this,s=shmi.visuals.session.DataGridManager,n=shmi.visuals.session.ItemManager,a=shmi.requires("visuals.tools.iterate").iterateObject,r=this.nextRowID++;t.totalRows++,t.data[r]=e,t.reset_grid=!0;for(var o=0;o<e.length;o++){var l=t.data[r][o],u=t.prefix+r+":"+o,c=n.getItem(u);c&&c.initialized?l.item=c:(l.item=shmi.createVirtualItem(u,l.type,l.min,l.max,l.value,function(e,n){return function(a,r,o){if(t.data[e]&&t.data[e][n]){var l=t.data[e][n].value;if(t.data[e][n].value=a,!0!==t.reset_grid&&l!==a){t.db%2!=0&&(clearTimeout(t.data[e].timeout_id),t.data[e].timeout_id=setTimeout((function(){!0===shmi.visuals.session.config.debug&&console.log("SAVING DATAGRID (DB2)",e,t.data[e]),s.saveRowToDB(t.name,e,!1)}),shmi.c("DATAGRID_DB2_WRITE_DELAY")));try{shmi.log("[DataGrid '"+t.name+"'] updated value: "+a,1)}catch(e){shmi.log("[DataGrid '"+t.name+"'] failed to update value: "+e,2)}}}}}(r,o)),l.item.setDataGridInfo(t.name,r,o)),l.item.writable=!0,l.item.writeValue(l.value),t.db%2==0&&(l.item.writable=!1)}return t.reset_grid=!1,a(t.subscribers,(function(e,s){t.subscribers[s].onChange(t._calcState(s))})),shmi.log("[DataGridDB] insertRow",2),r},deleteRow:function(e){var t,s=this,n=[],a=shmi.requires("visuals.tools.iterate").iterateObject;if(Array.isArray(e))for(var r=0;r<e.length;r++)t={type:"delete",rowID:s.data[e[r]].rowID},n.push(t);else t={type:"delete",rowID:s.data[e].rowID},n.push(t);n.push({type:"query"}),a(s.subscribers,(function(e,t){s.subscribers[t].offset=0;var a={type:"load",subID:t};n.push(a)})),s._queueTasks(n)},deleteAll:function(){var e=[];e.push({type:"delete-all"});for(var t in e.push({type:"query"}),this.subscribers){this.subscribers[t].offset=0;var s={type:"load",subID:t};e.push(s)}this._queueTasks(e)},_queueTasks:function(e){shmi.decouple((()=>{for(var t=0===this.taskQueue.length,s=0;s<e.length;s++)this.taskQueue.push(e[s]);t&&this._nextTask()}))},unsubscribe:function(e){var t=shmi.visuals.session;if(delete this.subscribers[e],0===Object.keys(this.subscribers).length){void 0!==this.q_id&&(t.QueryManager.close(this.q_id),delete this.q_id);for(var s=Object.keys(this.data),n=0;n<s.length;n++){for(var a=0;a<this.data[s[n]].length;a++)shmi.visuals.session.ItemManager.removeItem(this.data[s[n]][a].item.name);delete this.data[s[n]]}}},setOffset:function(e,t){if(void 0!==this.subscribers[t]){this.subscribers[t].offset=e;var s={type:"load",subID:t};this._queueTasks([s])}},getRowCount:function(){return this.totalRows},setFilter:function(e,t){this.filter[this.fields[e]]=t,clearTimeout(this.recalcTO),this.recalcTO=setTimeout(function(){this.refresh()}.bind(this),shmi.c("ACTION_RETRY_TIMEOUT"))},setFilterChaining:function(e){"OR"===e||"AND"===e?this.filter.chaining=e:console.error("[DataGridDB] invalid filter chaining mode:",e)},getFilters:function(){for(var e=this,t=[],s=0;s<e.fields.length;s++)void 0!==e.filter[e.fields[s]]?t.push(e.filter[e.fields[s]]):t.push(null);return t},refresh:function(){var e=this,t=shmi.requires("visuals.tools.iterate").iterateObject,s=[];s.push({type:"query"}),t(e.subscribers,(function(t,n){e.subscribers[n].offset=0;var a={type:"load",subID:n};s.push(a)})),e._queueTasks(s)},clearFilter:function(e){var t=!1;if(-1===e)for(var s=0;s<this.fields.length;s++)void 0!==this.filter[this.fields[s]]&&(delete this.filter[this.fields[s]],t=!0);else void 0!==this.filter[this.fields[e]]&&(delete this.filter[this.fields[e]],t=!0);t&&(clearTimeout(this.recalcTO),this.recalcTO=setTimeout(function(){this.refresh()}.bind(this),shmi.c("ACTION_RETRY_TIMEOUT")))},sort:function(e,t){var s=this.order;this.order=-1===e?null:[e,t],this.order!==s&&(clearTimeout(this.recalcTO),this.recalcTO=setTimeout(function(){this.refresh()}.bind(this),shmi.c("ACTION_RETRY_TIMEOUT")))},getCurrentIDs:function(e){var t=[],s=this.subscribers[e];if(void 0!==s)for(var n=this.totalRows<s.offset+s.size?this.totalRows:s.offset+s.size,a=s.offset;a<n;a++)t.push(a);return t},getAllIDs:function(e){for(var t=[],s=0;s<this.totalRows;s++)t.push(s);return t},getRowData:function(e){return void 0!==this.data[e]?this.data[e]:null},_calcState:function(e){var t=this.subscribers[e],s={status:"OK"};return s.offset=t.offset,s.totalRows=this.totalRows,s},_doQuery:function(){var e=this,t=shmi.visuals.session,s=null;(0,shmi.requires("visuals.tools.iterate").iterateObject)(e.data,(function(t,s){delete e.data[s]}));for(var n=[],a=0;a<e.fields.length;a++)n.push(e.fields[a]);n.push("ROWID"),void 0!==e.q_id&&(t.QueryManager.close(e.q_id),delete e.q_id);var r={mode:e.filter.chaining,clauses:[]};e.getFilters().forEach((function(t,s){var n=[];null!==t&&(t.forEach((function(e,t){n.push({operator:"like",value:e})})),r.clauses.push({mode:"OR",column:e.fields[s],clauses:n}))})),null!==e.order&&(s=[{column:e.fields[e.order[0]],order:e.order[1]}]),e.q_id=t.QueryManager.query(e._queryCB.bind(e),e.table,n,r,e.db,s)},_loadData:function(e){if(void 0!==this.subscribers[e]){var t=shmi.visuals.session,s=this.subscribers[e].size,n=this.subscribers[e].offset;t.QueryManager.get(this._getLoadCB(e,n),this.q_id,n,s>this.totalRows?this.totalRows:s)}else this._nextTask()},_queryCB:function(e,t,s){var n=this;0===e?(n.totalRows=t,n.nextRowID=n.totalRows):shmi.notify("[DataGrid '<%= name %>'] Failed to query database (error code: <%= errc %>, message: <%= message %>, category: <%= category %>)","${V_ERROR}",{name:n.name,errc:e.errc,message:e.message,category:e.category}),n._nextTask()},_getLoadCB:function(e,t){var makeCells=function(e,t){for(var s=[],n=0;n<e.length;n++)if(n===e.length-1)s.rowID=parseInt(e[n]);else{var a={type:shmi.c("TYPE_STRING"),value:e[n],min:Number.NaN,max:Number.NaN};s.push(a)}return s};return function(s,n){var a=shmi.visuals.session.DataGridManager,r=shmi.visuals.session.ItemManager,o=this;if(clearTimeout(o._loadTO),0===s&&void 0!==this.subscribers[e]){var l=t,u=this.totalRows<t+this.subscribers[e].size?this.totalRows:t+this.subscribers[e].size;this.reset_grid=!0;for(var c=l;c<u;c++){var m=n.data[c-l];this.data[c]=makeCells(m),clearTimeout(this.data[c].timeout_id),this.data[c].timeout_id=0;for(var d=0;d<this.data[c].length;d++){var h=this.data[c][d],f=this.prefix+c+":"+d,g=r.getItem(f);g&&g.initialized?h.item=g:(h.item=shmi.createVirtualItem(f,h.type,h.min,h.max,h.value,function(e,t){return function(s,n,r){if(this.data[e]&&this.data[e][t]){var l=this.data[e][t].value;if(this.data[e][t].value=s,!0!==this.reset_grid&&l!==s){this.db%2!=0&&(clearTimeout(o.data[e].timeout_id),o.data[e].timeout_id=setTimeout((function(){!0===shmi.visuals.session.config.debug&&console.log("SAVING DATAGRID (DB2)",e,o.data[e]),a.saveRowToDB(o.name,e,!1)}),shmi.c("DATAGRID_DB2_WRITE_DELAY")));try{shmi.log("[DataGrid '"+this.name+"'] updated value: "+s,1)}catch(e){shmi.log("[DataGrid '"+this.name+"'] failed to update value: "+e,2)}}}}.bind(this)}.bind(this)(c,d)),h.item.setDataGridInfo(this.name,c,d)),h.item.writable=!0,h.item.writeValue(h.value),this.db%2==0&&(h.item.writable=!1)}}this.reset_grid=!1,this.subscribers[e].onChange(this._calcState(e))}else 0!==s&&shmi.notify("[DataGrid '<%= name %>'] Failed to load from database (error code: <%= errc %>, message: <%= message %>, category: <%= category %>)","${V_ERROR}",{name:o.name,errc:s.errc,message:s.message,category:s.category});this._nextTask()}.bind(this)},_nextTask:function(){var e=this;if(this.taskQueue.length>0){var t=this.taskQueue.shift();switch(t.type){case"query":!0===shmi.visuals.session.config.debug&&console.log("QUERY TASK"),this._doQuery();break;case"load":!0===shmi.visuals.session.config.debug&&console.log("LOAD TASK"),this._loadData(t.subID),clearTimeout(this._loadTO),this._loadTO=setTimeout((function(){console.error("task timeout",t),e._nextTask()}),this.loadTimeout);break;case"refresh":!0===shmi.visuals.session.config.debug&&console.log("REFRESH TASK - DISABLED");break;case"delete":!0===shmi.visuals.session.config.debug&&console.log("DELETE TASK"),this._doDelete(t.rowID);break;case"delete-all":!0===shmi.visuals.session.config.debug&&console.log("DELETE-ALL TASK"),this._doDeleteAll();break;default:shmi.notify("Unknown task type '<%= task_type %>","${V_ERROR}",{task_type:t.type})}}},_doDelete:function(e){void 0!==e?e>=0?shmi.visuals.session.QueryManager.deleteRow(this.table,e,function(){shmi.log("[DataGrid '"+this.name+"'] deleted row from DB "+this.db,2),this._nextTask()}.bind(this),this.db):(shmi.log("[DataGrid '"+this.name+"'] invalid ROW-ID "+e,2),this._nextTask()):(shmi.log("[DataGrid '"+this.name+"'] invalid Grid-Data-ID "+e,2),this._nextTask())},_doDeleteAll:function(){void 0!==this.q_id&&shmi.visuals.session.QueryManager.queries[this.q_id].deleteQuery(),this._nextTask()}},shmi.pkg("visuals.core"),shmi.visuals.core.DataGridDynamic=function(e,t,s,n,a,r){this.name=e,this.fields=t||[],this.type="DYNAMIC",this.data={},this.subscribers={},this.create_index=!0===s,this.index_name=void 0!==n?n:"INDEX",this.index_begin=void 0!==a?a:0,this.prefix="virtual:grid:"+this.name+":",this.totalRows=0,this.order="",this.filter={chaining:"AND"},this.indexFields=r||[],this.nextRowId=0,this.length_sub_id=null,this.item_def_lid=null,this.update_all_TO=null,this.indexMap={},this.indexFieldIndices=[],this.init()},shmi.visuals.core.DataGridDynamic.prototype={getChangeHandler:function(e,t){const s=this;return(n,a,r)=>{if(s.data[e][t].item){s.data[e][t].item.adapter&&(n=s.data[e][t].item.readValue(!0));try{const a=s.data[e][t].value;s.data[e][t].value=n,a!==n&&shmi.fire("grid-changed",{grid:s,row:e,cell:t,field:s.fields[t],lastValue:s.data[e][t].value,value:n},s)}catch(e){shmi.log("[DataGrid '"+s.name+"'] failed to update value: "+e,2)}}}},getIndexString:function getIndexString(e){return JSON.stringify(this.indexFieldIndices.map((t=>this.data[e][t].value)))},init:function(){var e=this;!0===e.create_index&&-1===e.fields.indexOf(e.index_name)&&e.fields.push(e.index_name);const t=[];this.indexFields.forEach((e=>{const s=this.fields.indexOf(e);-1!==s?t.push(s):shmi.log("[DataGrid '"+this.name+"'] index field not found: "+e,3)})),this.indexFieldIndices=t},setFields:function(e){this.fields=e,this.init()},getFields:function(){return this.fields},getIndexFields:function(){return this.indexFieldIndices},getRowIndex:function(e){return this.data[e]?this.indexFieldIndices.map((t=>this.data[e][t].value)):null},searchIndexRowId:function(e){const t=this.indexMap[JSON.stringify(e)];return"number"==typeof t?t:-1},searchIndexFields:function(e,t,s){var n=this,a=0;return!!n.data[e]&&(t.forEach((function(t,r){n.data[e][t]&&n.data[e][t].value===s[r]&&a++})),a>0&&a===t.length)},setFilterChaining:function(e){"OR"===e||"AND"===e?this.filter.chaining=e:console.error("[DataGridDynamic] invalid filter chaining mode:",e)},insertRow:function(e,t,s){var n=this,a=0;a=void 0!==t?t:n.nextRowId++;const r=n.indexFieldIndices;if(r.length&&n.data[a]){const e=this.getIndexString(a);n.indexMap[e]===a&&delete n.indexMap[e]}n.data[a]=shmi.cloneObject(e),r.length&&(n.indexMap[this.getIndexString(a)]=a);for(var o=0;o<e.length;o++){var l=e[o],u="virtual:grid:"+n.name+":"+a+":"+o;n.data[a][o].item=shmi.createVirtualItem(u,l.type,l.min,l.max,l.value,n.getChangeHandler(a,o)),n.data[a][o].item.setDataGridInfo(n.name,a,o)}if(n.create_index){var c={type:shmi.c("TYPE_INT"),value:n.index_begin+(Object.keys(n.data).length-1),min:Number.NaN,max:Number.NaN,item:null,item_name:"virtual:grid:"+n.name+":"+a+":"+e.length};c.item=shmi.createVirtualItem(c.item_name,c.type,c.min,c.max,c.value,(()=>{})),c.item.setDataGridInfo(n.name,a,e.length),n.data[a].push(c)}return"function"==typeof n.onInsert?n.onInsert(e,t,s,(function(){s||n._updateSubscriber(),shmi.fire("grid-insert-row",{rowId:a,rowData:n.data[a],grid:n})})):(s||n._updateSubscriber(),shmi.fire("grid-insert-row",{rowId:a,rowData:n.data[a],grid:n})),a},deleteRow:function(e){const t=this,s=shmi.visuals.session.ItemManager,n=t.indexFieldIndices;if(shmi.objectHasOwnProperty(t.data,e)){t.data[e].forEach((function(e){e.item&&(s.removeItem(e.item.name),delete e.item)}));const a=t.data[e];n.length&&t.data[e]&&delete t.indexMap[t.getIndexString(e)],delete t.data[e],"function"==typeof t.onDelete?t.onDelete(e,(function(){t._updateSubscriber(),shmi.fire("grid-delete-row",{rowId:e,rowData:a,grid:t})})):(t._updateSubscriber(),shmi.fire("grid-delete-row",{rowId:e,rowData:a,grid:t}))}},deleteAll:function(){var e=this,t=shmi.visuals.session.ItemManager;shmi.requires("visuals.tools.iterate.iterateObject")(e.data,(function(s,n){e.data[n].forEach((function(e){e.item&&(t.removeItem(e.item.name),delete e.item)})),delete e.data[n]})),e.totalRows=0,e.nextRowId=0,e.indexMap={},"function"==typeof e.onDeleteAll?e.onDeleteAll((function(){e._updateSubscriber(),shmi.fire("grid-delete-all",{grid:e})})):(e._updateSubscriber(),shmi.fire("grid-delete-all",{grid:e}))},subscribePage:function(e,t,s){for(var n=this,a=Date.now();void 0!==n.subscribers[a];)a++;var r={};r.id=a,r.offset=e,r.size=t,r.onChange=s,n.subscribers[a]=r;var o={};return o.id=a,o.prefix=n.prefix,"function"==typeof this.onSubscribe?this.onSubscribe(e,t,(function(){n._updateSubscriber(a)})):n._updateSubscriber(a),o},_updateSubscriber:function(e){var t=this,s=shmi.requires("visuals.tools.iterate.iterateObject");void 0!==e?shmi.decouple((function(){if(void 0!==t.subscribers[e]){var s=t._calcState(e);t.subscribers[e].onChange(s)}})):(clearTimeout(t.update_all_TO),t.update_all_TO=setTimeout((function(){s(t.subscribers,(function(e,s){var n=t._calcState(s);t.subscribers[s].onChange(n)}))}),shmi.c("DECOUPLE_TIMEOUT")))},unsubscribe:function(e){delete this.subscribers[e]},setOffset:function(e,t){var s=this;void 0!==s.subscribers[t]&&(s.subscribers[t].offset=e,"function"==typeof s.onSetOffset?s.onSetOffset(e,t,(function(){var e=s._calcState(t);s.subscribers[t].onChange(e)})):shmi.raf((function(){var e=s._calcState(t);s.subscribers[t].onChange(e)})))},getRowCount:function(){return this.totalRows},setFilter:function(e,t){var s=this;"function"==typeof s.onSetFilter?s.onSetFilter(e,t,(function(){shmi.fire("grid-set-filter",{grid:s,type:s.type,column:e,field:s.fields[e],expression:t})})):shmi.fire("grid-set-filter",{grid:s,type:s.type,column:e,field:s.fields[e],expression:t})},getFilters:function(){},clearFilter:function(e){var t=this;"function"==typeof t.onClearFilter?t.onClearFilter(e,(function(){shmi.fire("grid-clear-filter",{grid:t,type:t.type,column:e,field:void 0===t.fields[e]?null:t.fields[e]})})):shmi.fire("grid-clear-filter",{grid:t,type:t.type,column:e,field:void 0===t.fields[e]?null:t.fields[e]})},refresh:function(){var e=this;"function"==typeof e.onRefresh?e.onRefresh((function(){shmi.fire("grid-refresh",{grid:e,type:e.type})})):shmi.fire("grid-refresh",{grid:e,type:e.type})},sort:function(e,t){var s=this;"function"==typeof s.onSort?s.onSort(e,t,(function(){shmi.fire("grid-sort",{grid:s,type:s.type,column:e,field:s.fields[e],order:t})})):shmi.fire("grid-sort",{grid:s,type:s.type,column:e,field:s.fields[e],order:t})},getCurrentIDs:function(e){var t=[],s=this.subscribers[e];if(void 0!==s)for(var n=this.totalRows<s.offset+s.size?this.totalRows:s.offset+s.size,a=s.offset;a<n;a++)t.push(a);return t},getAllIDs:function(e){for(var t=[],s=0;s<this.totalRows;s++)t.push(s);return t},getRowData:function(e){return this.data[e]?this.data[e]:null},_calcState:function(e){var t=this;t.totalRows=Object.keys(t.data).length;var s=t.subscribers[e],n={status:"OK"};return n.offset=s.offset,n.totalRows=t.totalRows,n}},function(){function alarmCallback(e,t,s){s&&updateDataGrid(e,!0)}function makeRowFromAlarmInfo(e,t,s,n){const a=shmi.requires("visuals.tools.numericValues"),r=shmi.visuals.tools.unitClasses,o=[];t.items=t.context,t.items.forEach((e=>{Object.defineProperty(e,"formattedValue",{enumerable:!0,configurable:!1,get:()=>"number"==typeof e.value?a.formatNumber(e.value,{precision:e.digits,unit:e.unit,"show-unit":!1}):e.value}),Object.defineProperty(e,"unitText",{enumerable:!0,configurable:!1,get:()=>{if(null!==e.unit&&!isNaN(e.unit)){const t=r.getSelectedAdapter(parseInt(e.unit));if(t)return t.unitText}return e.unit}})})),e.fields.forEach((function(e,s){const n=function getFieldValue(e,t){switch(t){case"id":return e.id;case"status":return e.acknowledgeable&&!e.acknowledged;case"json":return JSON.stringify(e);case"title":return shmi.evalString(shmi.localize(`\${alarm_title_${e.index}}`),e);case"group_title":return shmi.evalString(shmi.localize(`\${alarm_group_${e.group}}`),e);default:return void 0!==e[t]?e[t]:null}}(t,e);switch(typeof n){case"string":o.push({type:shmi.c("TYPE_STRING"),value:n,min:null,max:null});break;case"boolean":o.push({type:shmi.c("TYPE_BOOL"),value:n?1:0,min:0,max:1});break;case"number":o.push({type:shmi.c("TYPE_FLOAT"),value:n,min:Number.NaN,max:Number.NaN});break;default:o.push({type:shmi.c("TYPE_STRING"),value:"NULL",min:Number.NaN,max:Number.NaN})}})),e.insertRow(o,s,!n)}function updateDataGrid(e,t){const s=shmi.requires("visuals.tools.iterate").iterateObject;!0!==t&&(s(e.subscribers,(function(t,s){e.subscribers[s].offset=0})),e.reqOffset=0),e.isQueryRunning?e.needAnotherQuery=!0:sendAlarmQuery(e)}function sendAlarmQuery(e){const t=shmi.requires("visuals.tools.connect").request;let s={mode:e.displayMode,sort:e.filterSort,limit:e.reqSize,offset:e.reqOffset};s=function attachFilter(e,t){const s=t.fields[3],n=t.fields[4],a=t.fields[7];if(t.filter[s]||t.filter[n]||t.filter[a]){if(e.filter={mode:"AND",clauses:[]},t.filter[n]&&e.filter.clauses.push({mode:"AND",column:n,location:"property",clauses:[{operator:">=",value:1e7*t.filter[n][0]},{operator:"<",value:1e7*t.filter[n][1]}]}),t.filter[s]){const n={mode:"OR",column:s,location:"property",clauses:[]};t.filter[s].forEach((function(e){n.clauses.push({operator:"=",value:e})})),e.filter.clauses.push(n)}t.filter[a]&&e.filter.clauses.push({mode:"OR",column:a,location:"property",clauses:t.filter[a].map((e=>({operator:"=",value:e})))})}return e}(s,e),e.isQueryRunning=!0,e.needAnotherQuery=!1,t("alarm.query",s,(function onRequest(t,s){if(e.isQueryRunning=!1,e.needAnotherQuery&&sendAlarmQuery(e),s)console.error("[AlarmManager] getAllAlarms failed:",s.category,s.errc,s.message);else{e.data={},t.alarms.forEach((function(t,s){makeRowFromAlarmInfo(e,t,s,!1)})),e.totalRows=t.total_count;const s=Date.now();e.stateTO&&clearTimeout(e.stateTO),e.stateTO=0,s-e.lastStateUpdate>e.refreshTimeout?shmi.decouple(e.updateSubscribers.bind(e)):e.stateTO=setTimeout(e.updateSubscribers.bind(e),e.refreshTimeout)}}))}shmi.pkg("visuals.core"),shmi.visuals.core.DataGridIQAlarms=function(e,t){this.name=t,this.fields=["id","index","status","severity","timestamp_in","active","timestamp_out","group","json","title","group_title"],this.type="ALARMS",this.data={},this.subscribers={},this.prefix="virtual:grid:"+this.name+":",this.totalRows=0,this.order=[0,"ASC"],this.filter={},this.defaultSort=[{column:"timestamp_in",order:"DESC"}],this.filterSort=this.defaultSort,this.defaultOffset=0,this.defaultSize=500,this.reqOffset=this.defaultOffset,this.reqSize=this.defaultSize,this._subID=null,this.AM=shmi.visuals.session.AlarmManager,this.indexFields=["id"],this.lastStateUpdate=0,this.stateTO=0,this.singleStateTO=0,this.displayMode=e,this.refreshTimeout=150,this.isQueryRunning=!1,this.needAnotherQuery=!1,this.indexMap={},this.indexFieldIndices=[],this.init()},shmi.visuals.core.DataGridIQAlarms.prototype={getIndexString:function getIndexString(e){return JSON.stringify(this.indexFieldIndices.map((t=>this.data[e][t].value)))},init:function(){const e=[];this.indexFields.forEach((t=>{const s=this.fields.indexOf(t);-1!==s?e.push(s):shmi.log("[DataGrid '"+this.name+"'] index field not found: "+t,3)})),this.indexFieldIndices=e},setDisplayMode:function(e){this.displayMode=e,updateDataGrid(this,!1)},subscribePage:function(e,t,s){const n=this;let a=Date.now();for(n.reqOffset=e,n.reqSize=t;void 0!==n.subscribers[a];)a++;n.subscribers[a]={id:a,offset:e,size:t,onChange:s,lastUpdate:0},1===Object.keys(n.subscribers).length&&("live"!==n.displayMode&&updateDataGrid(n,!1),n._subID=n.AM.subscribeAlarms(n,alarmCallback.bind(null,n))),shmi.decouple((function(){n.subscribers[a].lastUpdate=Date.now(),n.subscribers[a].onChange(n._calcState(a))}));return{id:a,prefix:n.prefix}},getFields:function(e){return this.fields},getIndexFields:function(){return this.indexFieldIndices},getRowIndex:function(e){return this.data[e]?this.indexFieldIndices.map((t=>this.data[e][t].value)):null},searchIndexRowId:function(e){const t=this.indexMap[JSON.stringify(e)];return"number"==typeof t?t:-1},searchIndexFields:function(e,t,s){const n=this;let a=0;return!!n.data[e]&&(t.forEach((function(t,r){n.data[e][t]&&n.data[e][t].value===s[r]&&a++})),a>0&&a===t.length)},insertRow:function(e,t){const s=this,n=t;if(void 0===t)return console.error("DataGridIQAlarms","no row-index specified on insertRow"),null;const a=s.indexFieldIndices;return a.length&&s.data[n]&&delete s.indexMap[this.getIndexString(n)],void 0===this.data[n]&&(this.data[n]=e),e.forEach(((e,t)=>{const s=`virtual:grid:${this.name}:${n}:${t}`;this.data[n][t].item=function createVirtualItem(e,t,s,n,a){const r=shmi.requires("visuals.session.ItemManager").getItem(t);let o=null;return r&&r.initialized?(r.readValue()!==s.value&&r.writeValue(s.value),r):(o=shmi.createVirtualItem(t,s.type,s.min,s.max,s.value,null),o.setDataGridInfo(this.name,n,a),o)}(0,s,e,n,t),this.data[n][t].value=e.value})),a.length&&(s.indexMap[this.getIndexString(n)]=n),n},deleteRow:function(e){Array.isArray(e)?e.forEach((e=>{void 0!==this.data[e]?this.AM.ackAlarm(this.data[e][0].value):shmi.log("[DataGridIQAlarms] alarm not found row-id="+e,2)})):void 0!==this.data[e]?this.AM.ackAlarm(this.data[e][0].value):shmi.log("[DataGridIQAlarms] alarm not found row-id="+e,2)},deleteAll:function(){this.AM.ackAlarm(-1)},unsubscribe:function(e){const t=this,s=shmi.visuals.session.config,n=shmi.requires("visuals.tools.iterate").iterateObject;delete t.subscribers[e],0===Object.keys(t.subscribers).length&&s&&s["disable-alarm-prefetch"]&&(t.AM.unsubscribeAlarms(t._subID),n(t.data,(function(e,s){for(let e=0;e<t.data[s].length;e++)shmi.visuals.session.ItemManager.removeItem(t.data[s][0].item.name);delete t.data[s]})),t.indexMap={})},setOffset:function(e,t){const s=this,n=s.subscribers[t];void 0!==n&&(e>s.totalRows&&(e=s.totalRows),s.reqOffset=e,n.offset=e,updateDataGrid(s,!0))},getRowCount:function(){return this.totalRows},setFilter:function(e,t){const s=this;s.filter[s.fields[e]]=t,updateDataGrid(s,!1)},getFilters:function(){const e=this;return e.fields.map((t=>e.filter[t]||null))},clearFilter:function(e){const t=this;delete t.filter[t.fields[e]],updateDataGrid(t,!1)},updateSubscribers:function(){!function updateSubscribers(e){const t=shmi.requires("visuals.tools.iterate").iterateObject,s=Date.now();t(e.subscribers,(function(t,n){e.subscribers[n].lastUpdate=s,e.subscribers[n].onChange(e._calcState(n))})),e.lastStateUpdate=s}(this)},sort:function(e,t,s){const n=this;e<0||n.fields.length<=e?e=-1:"group_title"===n.fields[e]&&-1===(e=n.fields.findIndex((e=>"group"===e)))&&console.error("DataGridIQAlarms",'Unable to map column "group_title" to "group": Column "group" not found.'),n.filterSort=-1===e?n.defaultSort:[{column:n.fields[e],order:t}],updateDataGrid(n,s)},getCurrentIDs:function(e){const t=[],s=this.subscribers[e],n=Object.keys(this.data);for(let e=0;e<s.size&&void 0!==n[e];e++)t.push(parseInt(n[e]));return t},getAllIDs:function(e){return Object.keys(this.data).map((e=>parseInt(e)))},getRowData:function(e){return void 0!==this.data[e]?this.data[e]:null},_calcState:function(e){const t=this.subscribers[e];return{status:"OK",totalRows:this.totalRows,offset:Math.min(t.offset,Math.max(this.totalRows-1,0))}}}}(),shmi.pkg("visuals.core"),shmi.visuals.core.DataGridManager=function(){this.grids={},this.initialized=!1,this.loadGridMap()},shmi.visuals.core.DataGridManager.prototype={restart:function(){var e=this;shmi.requires("visuals.tools.iterate.iterateObject")(e.grids,(function(t,s){e.grids[s].init()}))},loadGridMap:function(){shmi.loadResource(shmi.c("DGM_GRID_MAP_PATH"),this.applyGridMap.bind(this))},applyGridMap:function(e,t,s){this.config=this.config||{};var n=new shmi.visuals.core.DataGridAlarms;if(this.grids.alarms=n,this.grids["alarms-historic"]=new shmi.visuals.core.DataGridAlarmsHistoric,t)shmi.log("[GridManager] grid map not found - 404",2),this.grid_map=[],this.applyGrid("",!0);else{this.grid_map={};try{this.grid_map=JSON.parse(e,s).grids}catch(e){console.error("[DataGridManager] failed to parse datagrid map:",s,e)}Array.isArray(this.grid_map)&&this.grid_map.length>0?this.loadGrid():(this.grid_map=[],this.applyGrid("",!0))}},loadGrid:function(){shmi.loadResource(shmi.evalString(shmi.c("GRID_PATH_PATTERN"),{name:this.grid_map.shift()}),this.applyGrid.bind(this))},getGrid:function(e){return void 0!==this.grids[e]?this.grids[e]:null},subscribePage:function(e,t,s,n){return void 0!==this.grids[e]&&this.grids[e].subscribePage?this.grids[e].subscribePage(t,s,n):null},setOffset:function(e,t,s){void 0!==this.grids[e]&&this.grids[e].setOffset&&this.grids[e].setOffset(t,s)},sort:function(e,t,s){void 0!==this.grids[e]&&this.grids[e].sort&&this.grids[e].sort(t,s)},setFilter:function(e,t,s){void 0!==this.grids[e]&&this.grids[e].setFilter&&this.grids[e].setFilter(t,s)},setFilterChaining:function(e,t){void 0!==this.grids[e]&&this.grids[e].setFilterChaining&&this.grids[e].setFilterChaining(t)},clearFilter:function(e,t){void 0!==this.grids[e]&&this.grids[e].clearFilter&&this.grids[e].clearFilter(t)},deleteAll:function(e){void 0!==this.grids[e]&&this.grids[e].deleteAll&&this.grids[e].deleteAll()},getCurrentIDs:function(e,t){return void 0!==this.grids[e]&&this.grids[e].getCurrentIDs?this.grids[e].getCurrentIDs(t):[]},getAllIDs:function(e,t){return void 0!==this.grids[e]&&this.grids[e].getAllIDs?this.grids[e].getAllIDs(t):[]},getFields:function(e){return void 0!==this.grids[e]&&this.grids[e].getFields?this.grids[e].getFields():[]},getFilters:function(e){var t=this,s=null;return void 0!==t.grids[e]&&t.grids[e].getFilters&&(s=t.grids[e].getFilters()),s},getRowCount:function(e){return void 0!==this.grids[e]&&this.grids[e].getRowCount?this.grids[e].getRowCount():-1},applyGrid:function(e,t,s){if(t)void 0!==s&&shmi.log("[GridManager] grid data ["+s+"] not found - 404",2);else{var n={};try{n=JSON.parse(e)}catch(e){console.error("[DataGridManager] failed to parse datagrid config:",s,e)}void 0===n.type?console.error("[DataGridManager]","no grid type configured:",s):"DB"===n.type||"DB2"===n.type?this.grids[n.name]=new shmi.visuals.core.DataGridDB(n.name,shmi.c(n.db),n.table,n.fields,n.conditions,n.indexFields):"DYNAMIC"===n.type?this.grids[n.name]=new shmi.visuals.core.DataGridDynamic(n.name,n.fields,n.create_index_column,n.index_name,n.index_begin,n.indexFields):"RECIPE"===n.type&&(this.grids[n.name]=new shmi.visuals.core.DataGridRecipe(n.name,n.recipe_template_id)),shmi.log("[GridManager] grid '"+n.name+"' loaded",1)}this.grid_map.length>0?this.loadGrid():(this.initialized=!0,shmi.fire("datagrid-manager",{ready:this.initialized},this))},subscribe:function(e,t){return void 0===this.grids[e]&&(shmi.log("[GridManager] subscribe - grid '"+e+"' not found",2),this.grids[e]=new shmi.visuals.core.DataGrid(e,{})),this.grids[e].subscribe(t)},unsubscribe:function(e,t){void 0!==this.grids[e]?this.grids[e].unsubscribe(t):shmi.log("[GridManager] unsubscribe - grid '"+e+"' not found",2)},deleteRow:function(e,t){void 0!==this.grids[e]?this.grids[e].deleteRow(t):shmi.log("[GridManager] deleteRow - grid '"+e+"' not found",2)},insertRow:function(e,t){var s=null;return void 0!==this.grids[e]?s=this.grids[e].insertRow(t):shmi.log("[GridManager] insertRow - grid '"+e+"' not found",2),s},getRowData:function(e,t){var s=null;return void 0!==this.grids[e]?s=this.grids[e].getRowData(t):shmi.log("[GridManager] getRowData - grid '"+e+"' not found",2),s},getColumnData:function(e,t){var s=null;return void 0!==this.grids[e]?s=this.grids[e].getColumnData(t):shmi.log("[GridManager] getColumnData - grid '"+e+"' not found",2),s},loadGridFromDB:function(e,t,s,n,a,r,o){for(var l=[],u=0;u<s.length;u++)l.push(s[u]);var c=shmi.visuals.session;a=a||shmi.c("DB_HMI_RO");var m=new shmi.visuals.core.DataGrid(e,{},r,o,"DB");if(shmi.def(this.grids,e,m),void 0===this.grids[e].fields||0===this.grids[e].fields.length){for(var d=[],h=0;d.length<l.length;)d.push(l[h]),h++;this.grids[e].fields=d}function getFieldData(e){var t=e.replace(/^,/,'" ",');for(t=(t=t.replace(/,$/,'," "')).replace(/""/g,'" "');t.replace(/,,/g,'," ",')!==t;)t=t.replace(/,,/g,'," ",');return t.match(/[^"]+(?=(",)|"$)/g)}if(Array.isArray(l)){var f=!1;void 0!==c.DataGridManager.grids[e].fields?l.length===c.DataGridManager.grids[e].fields.length&&(l.push("ROWID"),f=!0):(l.push("ROWID"),f=!0),!0===f&&shmi.log("[DataGridManager] adding ROWID to fields list",shmi.c("LOG_INFO"))}c.QueryManager.queryDirect((function(t,s){shmi.log("[DataGridManager] status: "+t,shmi.c("LOG_INFO")),shmi.log("[DataGridManager] query: "+s,shmi.c("LOG_INFO")),c.DataGridManager.grids[e].query=s;var n=s.datalength;c.DataGridManager.grids[e].totalRows=n,shmi.log("TOTAL RESULTS: "+n,1);for(;0<Object.keys(s.data).length;){for(var a=getFieldData(s.data[0]),r=[],o=-1,l=0;l<a.length;l++)if(l===a.length-1)o=parseInt(a[l]);else{var m={};m.type=shmi.c("TYPE_STRING"),m.value=a[l],m.min=Number.NaN,m.max=Number.NaN,r.push(m)}var d=c.DataGridManager.insertRow(e,r);c.DataGridManager.grids[e].data[d].rowID=o,u++}c.DataGridManager.grids[e].dbID=s.dbId,c.DataGridManager.grids[e].dbTable=s.table,shmi.log("[DataGridManager] grid '"+e+"' loaded",shmi.c("LOG_MSG"))}),t,l,n,a,o,0)},saveRowToDB:function(e,t,s){if(void 0!==this.grids[e]&&Array.isArray(this.grids[e].fields)){for(var n,a,r=[],o=[],l=this.grids[e].getRowData(t),u="DB2"===this.grids[e].type?this.grids[e].db:this.grids[e].dbID,c=0;c<l.length;c++)" "===l[c].value?r.push(null):r.push(l[c].value),o.push(this.grids[e].fields[c]);shmi.log("[DataGridManager] fields: "+o,shmi.c("LOG_INFO")),shmi.log("[DataGridManager] values: "+r,shmi.c("LOG_INFO")),!0===s?(n="DB2"===this.grids[e].type?this.grids[e].table:this.grids[e].dbTable,a=shmi.visuals.session.QueryManager.insert(n,o,r,function(s,n){this.grids[e].data[t].rowID=n,0!==s?(shmi.notify("Insert record failed with status: "+s+" Row-ID: "+n),this.grids[e].deleteRow(t)):this.grids[e].refresh(),shmi.visuals.session.QueryManager.queries[a].close()}.bind(this),u)):(n="DB2"===this.grids[e].type?this.grids[e].table:this.grids[e].dbTable,a=shmi.visuals.session.QueryManager.update(n,o,r,l.rowID,(function(e,t){0!==e&&shmi.notify("Status (update): "+e),shmi.visuals.session.QueryManager.queries[a].close()}),u))}}},function(){shmi.pkg("visuals.core");var e={error:console.error.bind(console,"[DataGridRecipe]"),warn:console.warn.bind(console,"[DataGridRecipe]"),log:console.log.bind(console,"[DataGridRecipe]"),debug:console.debug.bind(console,"[DataGridRecipe]")},t=1;function makeRowDataFromRecipe(e){return shmi.checkArg("recipe",e,"shmi.visuals.core.Recipe"),[{type:shmi.c("TYPE_INTEGER"),value:e.id,min:Number.NaN,max:Number.NaN},{type:shmi.c("TYPE_STRING"),value:e.name,min:Number.NaN,max:Number.NaN},{type:shmi.c("TYPE_STRING"),value:e.comment,min:Number.NaN,max:Number.NaN},{type:shmi.c("TYPE_BOOL"),value:"number"==typeof e.versionId?1:0,min:Number.NaN,max:Number.NaN}]}function makeRow(e,t,s){var n=shmi.visuals.session.ItemManager;shmi.checkArg("self",e,"shmi.visuals.core.DataGridRecipe"),shmi.checkArg("rowId",t,"number"),shmi.checkArg("rowData",s,"array"),e.totalRows++,e.data[t]=s,s.forEach((function(e,s){var a=this.prefix+t+":"+s,r=n.getItem(a);r&&r.initialized?(e.item=r,r.setValue(e.value)):(e.item=shmi.createVirtualItem(a,e.type,e.min,e.max,e.value,function(e,t,s,n,a){var r=this.getRowData(e);r&&r[t]&&(r[t].value=s)}.bind(this,t,s)),e.item.setDataGridInfo(this.name,t,s)),e.item.writable=!1}),e)}function calcState(e,t){return shmi.checkArg("self",e,"shmi.visuals.core.DataGridRecipe"),shmi.checkArg("subID",t,"object"),t?{status:"OK",offset:t.offset,size:t.size,totalRows:e.totalRows}:{status:"FAILED",totalRows:e.totalRows||0}}function delayedRefresh(e){shmi.checkArg("self",e,"shmi.visuals.core.DataGridRecipe"),null!==e.refreshTimeout&&clearTimeout(e.refreshTimeout),e.refreshTimeout=setTimeout(e.refresh.bind(e),shmi.c("ACTION_RETRY_TIMEOUT"))}function pushTask(e,t){shmi.checkArg("self",e,"shmi.visuals.core.DataGridRecipe"),shmi.checkArg("task",t,"object"),e.taskQueue.push(t),processTaskQueue(e)}function taskDelete(e,t){shmi.checkArg("self",e,"shmi.visuals.core.DataGridRecipe"),shmi.checkArg("task",t,"object");var s=e.rowObjectData[t.rowID];return!!s&&(s.delete(onTaskDone.bind(null,e)),!0)}function taskFetchAll(t,s){shmi.checkArg("self",t,"shmi.visuals.core.DataGridRecipe"),shmi.checkArg("task",s,"object");var n,a,r=shmi.requires("visuals.session.RecipeManager"),o=shmi.requires("visuals.task"),l=function calculateRequestRanges(e){var t=[],s=[],n=shmi.requires("visuals.tools.iterate.iterateObject");return shmi.checkArg("self",e,"shmi.visuals.core.DataGridRecipe"),n(e.subscribers,(function(e){s.push(e)})),s.sort((function(e,t){return t.offset-e.offset})).forEach((function(e,s){if(0!==s){var n=t[t.length-1];n.end<e.offset?t.push({begin:e.offset,end:e.offset+e.size}):n.end<e.offset+e.size&&(e.end=e.offset+e.size)}else t.push({begin:e.offset,end:e.offset+e.size})})),t}(t);function onComplete(){var e=shmi.requires("visuals.tools.iterate.iterateObject");onTaskDone(t,null),e(t.subscribers,doRefreshSubscriber.bind(null,t))}return 0===(n=l.map((function(s){var n=o.createTask("fetch-"+s.begin+"-"+s.end);return n.run=function run(){r.listRecipes(t.recipeTemplateId,{filter:buildFilterExpression(t),sort:buildSortExpression(t),offset:s.begin,limit:s.end-s.begin,include_metadata:!1,include_values:!0},(function(a,r){r?(e.error("Error while loading recipe data",r),n.fail()):(t.totalRows=0,a.recipes.forEach((function(e,n){t.rowObjectData[s.begin+n]=e,makeRow(t,s.begin+n,makeRowDataFromRecipe(e))})),n.complete(),shmi.fire("datagrid-ready",{}))}))},n}))).length?onComplete():((a=o.createTaskList(n)).onComplete=onComplete,a.run()),!0}function taskLoad(t,s){return shmi.checkArg("self",t,"shmi.visuals.core.DataGridRecipe"),shmi.checkArg("task",s,"object"),shmi.requires("visuals.session.RecipeManager").listRecipes(t.recipeTemplateId,{filter:buildFilterExpression(t),sort:buildSortExpression(t),offset:s.offset,limit:s.size,include_metadata:!1,include_values:!0},(function(n,a){a?e.error("Error while loading recipe data",a):n.recipes.forEach((function(e,n){t.rowObjectData[s.offset+n]=e,makeRow(t,s.offset+n,makeRowDataFromRecipe(e))})),onTaskDone(t,null)})),!0}function executeTask(t,s){shmi.checkArg("self",t,"shmi.visuals.core.DataGridRecipe"),shmi.checkArg("task",s,"object");var n={delete:taskDelete.bind(null,t),fetch_all:taskFetchAll.bind(null,t),load:taskLoad.bind(null,t)}[s.type];n?(t.tasksRunning++,s.serialized&&(t.tasksJoin=!0),n(s)||(e.error("Failed to start task",s),onTaskDone(t,null))):e.error("Unknown type for task",s.type)}function processTaskQueue(e){shmi.checkArg("self",e,"shmi.visuals.core.DataGridRecipe"),function getTasks(e,t){var s,n=[];return shmi.checkArg("self",e,"shmi.visuals.core.DataGridRecipe"),shmi.checkArg("popSerialized",t,"boolean","undefined"),0===e.taskQueue.length?[]:((s=e.taskQueue.some((function(t,s){return t.serialized&&(n=e.taskQueue.splice(0,s)),!!t.serialized})))?s&&t&&n.push(e.taskQueue.shift()):(n=e.taskQueue,e.taskQueue=[]),n)}(e,!this.tasksJoin).forEach(executeTask.bind(null,e))}function onTaskDone(t,s){shmi.checkArg("self",t,"shmi.visuals.core.DataGridRecipe"),shmi.checkArg("err",s,"object","null"),s?e.error("Task command failed",s):0===t.tasksRunning&&e.warn("tasksRunning is 0 but there are still tasks running"),0==--t.tasksRunning&&(t.tasksJoin=!1,processTaskQueue(t))}function doRefreshSubscriber(e,t){shmi.checkArg("self",e,"shmi.visuals.core.DataGridRecipe"),shmi.checkArg("sub",t,"object"),t.onChange(calcState(e,t))}function buildFilterExpression(e){return shmi.checkArg("self",e,"shmi.visuals.core.DataGridRecipe"),{mode:e.filterChaining,clauses:e.getFilters().map((function(t,s){return null===t?null:{location:"property",mode:"OR",column:e.getFields()[s],clauses:t.map((function(e){return{operator:"like",value:e}}))}})).filter((function(e){return null!==e}))}}function buildSortExpression(e){return shmi.checkArg("self",e,"shmi.visuals.core.DataGridRecipe"),null===e.order?[]:[{column:e.getFields()[e.order[0]],order:e.order[1]}]}shmi.visuals.core.DataGridRecipe=function DataGridRecipe(e,t){this.name=e,this.recipeTemplateId=t,this.type="Recipe",this.data={},this.rowObjectData={},this.subscribers={},this.prefix="virtual:grid:"+this.name+":",this.nextRowID=0,this.totalRows=0,this.order=null,this.filter={},this.filterChaining="AND",this.taskQueue=[],this.tasksRunning=0,this.tasksJoin=!1,this.refreshTimeout=null},shmi.visuals.core.DataGridRecipe.prototype={constructor:shmi.visuals.core.DataGridRecipe,init:function(){this.taskQueue=[],this.subscribers={}},subscribePage:function(e,s,n){shmi.checkArg("offset",e,"number"),shmi.checkArg("size",s,"number"),shmi.checkArg("onChange",n,"function");var a={id:t++,offset:e,size:s,onChange:n};this.subscribers[a.id]=a;var r={id:a.id,prefix:this.prefix};return pushTask(this,{type:"load",offset:e,size:s}),r},getFields:function(){return["recipe_id","recipe_name","comment","values_set"]},getIndexFields:function(){return[0]},getRowIndex:function(e){shmi.checkArg("rowId",e,"number");var t=this.getRowData(e);return t?this.getIndexFields().map((function(e){return t[e].value})):null},searchIndexRowId:function(e){var t=this.getIndexFields(),s=-1;return shmi.checkArg("rowIndex",e,"array"),Object.keys(this.data).some(function(n){return!!this.searchIndexFields(parseInt(n),t,e)&&(s=n,!0)}.bind(this)),s},searchIndexFields:function(e,t,s){return shmi.checkArg("row",e,"number"),shmi.checkArg("fields",t,"array"),shmi.checkArg("rowIndex",s,"array"),t.length>0&&this.data[e].every((function(e,t){return e.value===s[t]}))},insertRow:function(e,t){var s=shmi.requires("visuals.tools.iterate").iterateObject,n=this.nextRowID++;return shmi.checkArg("rowData",e,"array"),makeRow(this,n,e),t||s(this.subscribers,function(e){e.onChange(calcState(this,e))}.bind(this)),n},deleteRow:function(e){shmi.checkArg("rowID",e,"number","array"),(Array.isArray(e)?e:[e]).forEach((function(e){pushTask(this,{type:"delete",rowID:parseInt(e)})}),this),pushTask(this,{type:"fetch_all",serialized:!0})},deleteAll:function(){this.deleteRow(Object.keys(this.rowObjectData))},unsubscribe:function(e){var t=shmi.requires("visuals.session.ItemManager"),s=shmi.requires("visuals.tools.iterate.iterateObject");shmi.checkArg("subID",e,"number"),delete this.subscribers[e],0===Object.keys(this.subscribers).length&&(s(this.data,(function(e){e.forEach((function(e){t.removeItem(e.item.name)}))})),this.data={},this.rowObjectData={})},setOffset:function(e,t){shmi.checkArg("offset",e,"number"),shmi.checkArg("subID",t,"number"),void 0!==this.subscribers[t]&&(this.subscribers[t].offset=e,pushTask(this,{type:"load",subID:t}))},getRowCount:function(){return this.totalRows},setFilter:function(e,t){this.filter[this.getFields()[e]]=t,delayedRefresh(this)},setFilterChaining:function(t){shmi.checkArg("chaining",t,"string"),"OR"===t||"AND"===t?(this.filterChaining=t,delayedRefresh(this)):e.error("Invalid filter chaining mode:",t)},getFilters:function(){return this.getFields().map(function(e){return shmi.objectHasOwnProperty(this.filter,e)?this.filter[e]:null}.bind(this))},refresh:function(){(0,shmi.requires("visuals.tools.iterate").iterateObject)(this.subscribers,(function(e){e.offset=0})),this.data={},this.rowObjectData={},this.totalRows=0,pushTask(this,{type:"fetch_all",serialized:!0})},clearFilter:function(e){var t=!1;shmi.checkArg("col",e,"number"),-1===e?(t=Object.keys(this.filter).length>0,this.filter={}):void 0!==this.filter[this.getFields()[e]]&&(delete this.filter[this.getFields()[e]],t=!0),t&&delayedRefresh(this)},sort:function(e,t){var s=this.order;shmi.checkArg("col",e,"number"),shmi.checkArg("col",t,"string"),this.order=-1===e?null:[e,t],this.order!==s&&delayedRefresh(this)},getCurrentIDs:function(e){shmi.checkArg("subID",e,"number");var t=this.subscribers[e];return void 0===t?[]:Object.keys(this.data).map((function(e){return parseInt(e)})).filter((function(e){return t.offset<=e&&e<t.offset+t.size}))},getAllIDs:function(){return Object.keys(this.data)},getRowData:function(e){return shmi.checkArg("rowId",e,"number"),void 0!==this.data[e]?this.data[e]:null}}}(),function(){shmi.pkg("visuals.core");const e={user:{events:["login-state"],basePath:"shmi.visuals.session.UserManager.currentUser"}};function getValueByPath(e,t){return t.split(".").reduce(((e,t)=>"object"!=typeof e||null===e?null:shmi.objectHasOwnProperty(e,t)?e[t]:null),e)}function getDetailed(e,t,s){const n=function getKeyForVariable(e,t){return t.reduce(((t,s)=>e===s||e.startsWith(`${s}.`)?!t||s.length>t?s:t:null))}(t,s);if(!n)return null;const a=e._propertyRegistry[n],r=t.substr(n.length+1),o=getValueByPath(window,a.basePath);return n===t?{variableName:t,basePropertyKey:n,basePropertyInfo:a,value:o}:{variableName:t,basePropertyKey:n,basePropertyInfo:a,value:getValueByPath(o,r)}}function onEventCallback(e,t){const s=Object.keys(e._propertyRegistry);e._tokens.forEach((n=>{const a=getDetailed(e,n.variableName,s);a&&a.basePropertyInfo.events.includes(t)&&(n.lastValue!==a.value||"object"==typeof a.value&&null!==a.value)&&(n.gotInitialValue=!0,n.lastValue=a.value,n.callback(a.value))}))}function registerEvent(e,t){e._events.includes(t)||(e._events.push(t),e._eventListeners.push(shmi.listen(t,onEventCallback.bind(null,e,t))))}function getFreeTokenId(e){let t;do{t=Math.floor(Math.random()*Number.MAX_SAFE_INTEGER)}while(e._tokenIdSet.has(t));return e._tokenIdSet.add(t),t}shmi.visuals.core.EnvironmentManager=class EnvironmentManager{constructor(){const{iterateObject:t}=shmi.requires("shmi.visuals.tools.iterate");this._propertyRegistry={},this._tokenIdSet=new Set,this._tokens=[],this._events=[],this._eventListeners=[],t(e,(({basePath:e,events:t},s)=>this.registerVariable(s,e,t)))}destroy(){this._eventListeners.forEach((e=>e.unlisten())),this._eventListeners=[],this._events=[],this._tokens=[],this._tokenIdSet.clear(),this._propertyRegistry={}}registerVariable(e,t,s){if(shmi.checkArg("variableName",e,"string"),shmi.checkArg("basePath",t,"string"),shmi.checkArg("eventName",s,"string","array"),shmi.objectHasOwnProperty(this._propertyRegistry,e))throw new Error("Environment variable already registered");Array.isArray(s)||(s=[s]),this._propertyRegistry[e]={events:s,basePath:t},s.forEach(registerEvent.bind(this,this))}get(e){return shmi.checkArg("variableName",e,"string"),function getFrom(e,t,s){const n=getDetailed(e,t,s);return n?n.value:null}(this,e,Object.keys(this._propertyRegistry))}subscribe(e,t){shmi.checkArg("variableName",e,"string"),shmi.checkArg("callback",t,"function");const s={variableName:e,lastValue:null,id:getFreeTokenId(this),callback:t,active:!0,unlisten:()=>{s.active=!1;const e=this._tokens.findIndex((({id:e})=>e===s.id));e>0&&this._tokens.splice(e,1),this._tokenIdSet.delete(s.id)}};return shmi.decouple((()=>{if(!s.active||s.gotInitialValue)return;const e=this.get(s.variableName);s.gotInitialValue=!0,s.lastValue=e,s.callback(e)})),this._tokens.push(s),s}}}(),function(){function doSaveTransfer(e,t){var s=shmi.requires("visuals.tools.connect").request,n=null,a=null;t.offset>=t.data.length?s("fs.close",t.connect_id,(function onClose(s,n){n&&console.error("[FileManager] error closing file:",n),t.failed?t.callback(t.err.errc,t):t.callback(0,t),delete e.transfers[t.id]})):(n=t.data.slice(t.offset,t.offset+e.chunkSize),a=t.utf8?btoa(e.to_utf8(n)):btoa(n),s("fs.write",{file_id:t.connect_id,data:a},(function onWrite(s,n){n?(t.failed=!0,t.err=n,t.offset=t.data.length):t.offset+=e.chunkSize,doSaveTransfer(e,t)})))}shmi.pkg("visuals.core"),shmi.visuals.core.FileManager=function(){this.transfers={},this.chunkSize=4096},shmi.visuals.core.FileManager.prototype={to_utf8:function(e){return unescape(encodeURIComponent(e))},from_utf8:function(e){return decodeURIComponent(escape(e))},save:function(e,t,s,n){for(var a=this,r=shmi.requires("visuals.tools.connect").request,o=0;void 0!==a.transfers[o];)o++;return a.transfers[o]={id:o,connect_id:null,type:"save",data:t||"",offset:0,err:null,callback:s,complete:!1,started:!1,failed:!1,utf8:!0===n},r("fs.open",{path:e,force:!0,open_mode:["out"]},(function(e,t){var s=a.transfers[o];0!==t?(s.failed=!0,s.err=t,s.callback(t.errc,s),delete a.transfers[s.id]):(s.started=!0,s.connect_id=e,doSaveTransfer(a,s))})),o}}}(),shmi.pkg("visuals.core"),shmi.visuals.core.IfItemSubscriber=function(){},shmi.visuals.core.IfItemSubscriber.prototype={},function(){var e,t="visuals.core",s=shmi.pkg(t),n={},a=(e="["+t+".Item]  ",e+=" ".repeat(Math.max(0,e.length-20)),console.error.bind(console,e));function writeNextQueuedValue(){var e=shmi.requires("visuals.tools.connect").request,t=shmi.requires("visuals.tools.iterate").iterateObject,s=shmi.requires("visuals.session.ItemManager"),a={},r={};t(n,(function(e,t){e.inProgress||(a[t]=e.value,e.inProgress=!0,s.readBeforeWriteEvent&&(r[t]={value:e.value,oldValue:e.oldvalue}))})),0!==Object.keys(a).length&&e("io.write",{direct:!1,values:a},(function onRequest(e,o){o?console.error("[ItemManager] io.write failed:",o.category,o.errc,o.message,a):t(e,(function(e,t){null!==e?console.error("[ItemManager] io.write failed: (",t,":",a[t],")",e.category,e.errc,e.message):s.readBeforeWriteEvent?shmi.fire("write-item",r):s.writeEventEnabled&&shmi.fire("write-item",a)})),t(a,(function(e,t){n[t].value===e?delete n[t]:n[t].inProgress=!1})),writeNextQueuedValue()}))}function queueWrite(e){const t=shmi.requires("visuals.tools.iterate").iterateObject,s=shmi.requires("visuals.session.ItemManager");t(e,(function(e,t){shmi.objectHasOwnProperty(n,t)?n[t].value=e:n[t]={value:e,inProgress:!1},s.readBeforeWriteEvent&&(n[t].oldvalue=s.getItem(t).readValue(!0))})),writeNextQueuedValue()}function toType(e,t){switch(e.type){case shmi.c("TYPE_STRING"):break;case shmi.c("TYPE_BOOL"):t="boolean"==typeof t?!0===t?1:0:parseInt(t);break;case shmi.c("TYPE_INT"):t=parseInt(t);break;case shmi.c("TYPE_FLOAT"):t=parseFloat(t);break;default:shmi.log("[Item '"+e.name+"'] unknown type "+e.type,shmi.c("LOG_INFO"))}return t}function applyLockStatus(e,t){"function"==typeof t.lock&&"function"==typeof t.unlock&&(e.writable?t.unlock():t.lock())}function applyProperties(e,t){var s={min:e.min,max:e.max,step:e.step,warnmin:e.warnmin,warnmax:e.warnmax,prewarnmin:e.prewarnmin,prewarnmax:e.prewarnmax,precision:e.digits};if(e.labelToken&&""!==e.labelToken.trim()&&"function"==typeof t.setLabel){var n=e.labelToken.trim();n=n.replace(/#(.+?)#/g,(function(e,t){return"${"+t+"}"})),t.setLabel(n)}if(e.adapter){var a=shmi.requires("visuals.tools.iterate.iterateObject"),r=["precision","step"];a(s,(function(t,n){null!==t&&-1===r.indexOf(n)&&(s[n]=e.adapter.outFunction(t))}))}!function setUnitText(e,t){if("function"==typeof t.setUnitText){var s=!1;e.adapter&&e.adapter.unitText&&(t.setUnitText(e.adapter.unitText),s=!0),s||"string"!=typeof e.unit||""===e.unit.trim()||t.setUnitText(e.unit)}}(e,t),"function"==typeof t.setProperties&&t.setProperties(s.min,s.max,s.step,e.name,e.type,s.warnmin,s.warnmax,s.prewarnmin,s.prewarnmax,s.precision)}s.Item=function(e,t){this.name=e,this.readable=!1,this.writable=!1,this.lockable=!1,this.supervisor=!1,this.locked=!1,this.virtual=!!t,this.errorcode=null,this.index=null,this.type=null,this.min=null,this.max=null,this.step=null,this.prewarnmin=null,this.prewarnmax=null,this.warnmin=null,this.warnmax=null,this.value=void 0,this.initialized=!1,this.subscribed=!!t,this.valueSet=!1,this.bitmask=null,this.unit=null,this.unitClass=null,this.labelToken="",this.digits=-1,this.interval=100,this.lastSetTime=0,this._dataGridInfo=null,this._updateTargets={},this._updateValue=this.value,Object.defineProperty(this,"formattedValue",{enumerable:!0,configurable:!1,get:function(){return shmi.requires("visuals.tools.numericValues").formatNumber(this.value,{precision:this.digits,unit:this.unit})}.bind(this)})},s.Item.prototype={setProperties:function(e){var t=shmi.requires("visuals.tools.unitClasses");this.errorcode=0,this.index=0,this.type=function getType(e){return null===e?null:{int:2,long:2,longlong:2,uint:2,ulong:2,ulonglong:2,float:3,double:3,bool:1,boolean:1,string:0,error:-1}[e]}(e.value_type),this.locked=!1,this.supervisor=-1!==e.access.indexOf("supervisor"),this.lockable=-1!==e.access.indexOf("lock"),this.writable=-1!==e.access.indexOf("write"),this.readable=-1!==e.access.indexOf("read"),this.min=e.min,this.max=e.max,this.step=e.step,e.warn?(this.warnmin=e.warn.min,this.warnmax=e.warn.max):(this.warnmin=null,this.warnmax=null),e.prewarn?(this.prewarnmin=e.prewarn.min,this.prewarnmax=e.prewarn.max):(this.prewarnmin=null,this.prewarnmax=null),this.bitmask=0,this.digits=e.digits,this.unit=e.unit,isNaN(this.unit)?(this.unitClass=null,this.adapter=null):(this.unitClass=parseInt(this.unit),this.adapter=t.getSelectedAdapter(this.unitClass)),this.labelToken=e.label,-1===[-1,null].indexOf(this.type)?this.initialized=!0:(this.initialized=!1,this.valueSet=!1,this.value=void 0,this._updateValue=void 0),this.notifyLockStatus()},getProperties:function(){return{access:{read:this.readable,write:this.writable},min:this.min,max:this.max,step:this.step,digits:this.digits,label:this.labelToken,unit:this.unit,unitClass:"number"!=typeof this.unitClass||isNaN(this.unitClass)?null:this.unitClass,initialized:this.initialized,type:this.type,warn:{min:this.warnmin,max:this.warnmax},prewarn:{min:this.prewarnmin,max:this.prewarnmax}}},addUpdateTarget:function(e){for(var t=Date.now();void 0!==this._updateTargets[t];)t++;return this._updateTargets[t]=e,this.notifyLockStatus(t),this.notifyUpdateTargets(t),shmi.log("[Item] subscribed item '"+this.name+"' with id "+t,1),t},removeUpdateTarget:function(e){void 0!==e?null!==e?(delete this._updateTargets[e],shmi.log("[Item] unsubscribed item '"+this.name+"' with id "+e,1)):shmi.log("[Item] target id null",1):shmi.log("[Item] target id undefined",1)},writeValue:function(e,t={}){var s,n=this,r={};const{ignoreAdapter:o,skipSameValueCheck:l}="object"==typeof t&&t?t:{ignoreAdapter:!!t};n.initialized?n.subscribed?(s=!o&&n.adapter?n.adapter.inFunction(e):e,this.type!==shmi.c("TYPE_INT")&&this.type!==shmi.c("TYPE_FLOAT")||"number"!=typeof this.min||"number"!=typeof this.max||0===this.min&&0===this.max||(s<this.min&&(s=this.min),s>this.max&&(s=this.max)),(l||toType(n,s)!==n.value)&&(n.virtual?n.writable&&n.setValue(s):(r[n.name]=n.type===shmi.c("TYPE_BOOL")?1===s:toType(n,s),queueWrite(r)))):a("tried to write to not subscribed item:",n.name):a("tried to write uninitialized item:",n.name)},readValue:function(e){var t=this;return t.adapter&&!e?t.adapter.outFunction(t.value):t.value},compareExchange:function(e,t,s){var n=this,r=shmi.requires("visuals.tools.connect").request,o=shmi.requires("visuals.session.ItemManager");n.initialized||(a("attempted to compare & exchange with an uninitialized item:",n.name),s(null,!1,{category:"shmi:connect:api:io",errc:2147483647,message:"((unknown error))"})),n.virtual?n.writable?n.value!==e?s(n.value,!0,{category:"shmi:connect:api:io",errc:6,message:"expectation failed"}):s(null,!1,null):s(n.value,!1,{category:"shmi:connect:api:io",errc:2,message:"no write access"}):r("io.compare_exchange",{item_alias:n.name,expected:e,desired:t},(function(a,r){!r&&o.readBeforeWriteEvent?shmi.fire("write-item",{[n.name]:{oldValue:e,value:t}}):!r&&o.writeEventEnabled&&shmi.fire("write-item",{[n.name]:t}),s(a,r&&"shmi:connect:api:io"===r.category&&6===r.errc,r)}))},getBitmask:function(){return this.bitmask},isDataGridMember:function(){return null!==this._dataGridInfo},getDataGridInfo:function(){return this._dataGridInfo},setDataGridInfo:function(e,t,s){this._dataGridInfo={gridName:e,rowIndex:t,cellIndex:s}},clearDataGridInfo:function(){this._dataGridInfo=null},setValue:function(e){if(this.initialized){this.value=toType(this,e),this.valueSet=!0;var t=Date.now(),s=t-this.lastSetTime;0!==this.lastSetTime&&(this.interval=this.interval+(s-this.interval)/2,this.interval=Math.round(this.interval)),this.subscribed&&(s>=shmi.c("MIN_UPDATE_INTERVAL")?(this.lastSetTime=t,this.notifyUpdateTargets()):(clearTimeout(this.setTO),this.setTO=setTimeout(function(){this.lastSetTime=t,this.notifyUpdateTargets()}.bind(this),shmi.c("MIN_UPDATE_INTERVAL")-s)))}},notifyUpdateTargets:function(e){var t,s=this,n=shmi.requires("visuals.tools.iterate").iterateObject,r=null;if(s.initialized&&s.subscribed&&s.valueSet)if(t=s.adapter?s.adapter.outFunction(s.value):s.value,void 0!==e)if(r=s._updateTargets[e])try{r.setValue(t,s.type,s.name)}catch(t){a("exception running setValue on subscriber:",e,t)}else a("subscriber not found:",e);else s._updateValue!==s.value&&(n(s._updateTargets,(function(e,n){try{s._updateTargets[n].setValue(t,s.type,s.name)}catch(e){a("exception running setValue on subscriber:",n,e)}})),s._updateValue=s.value)},notifyLockStatus:function(e){var t=this,s=null,n=shmi.requires("visuals.tools.iterate.iterateObject");void 0!==e?(s=t._updateTargets[e])?(applyLockStatus(t,s),applyProperties(t,s)):(a("subscriber not found:",e),function logSubscriber(e,t){null==t?shmi.log("[Item '"+e.name+"'] logSubscriber: specified subscriber does not exist!",3):(shmi.log("[Item '"+e.name+"'] UI Type: "+t.uiType,2),void 0!==t.config&&shmi.log("[Item '"+e.name+"'] Control Name: "+t.config.name,2))}(t,t._updateTargets[e])):n(t._updateTargets,(function(e){applyLockStatus(t,e),applyProperties(t,e)}))}}}(),function(){var e,t="visuals.core",s=shmi.pkg(t),n=(e="["+t+".BitItem]  ",e+=" ".repeat(Math.max(0,e.length-20)),console.error.bind(console,e));function updateProperties(e){var t=shmi.requires("visuals.session.ItemManager").getItem(e.parentItemName),s=[];e.parentItemIsCompatible&&(t.writable&&s.push("write"),t.readable&&s.push("read")),e.setProperties({access:s,min:0,max:1,step:1,value_type:"boolean",warn:null,prewarn:null,digits:0,precision:0,unit:null,label:null})}function startWriteBits(e,t,s){var a,r=e.pendingAction;null==s&&(s=t.readValue(!0)),a="set"===e.pendingAction?s|e.bitMask:s&~e.bitMask,null!==e.pendingAction&&(!("set"===e.pendingAction&&(s&e.bitMask)===e.bitMask||"unset"===e.pendingAction&&0==(s&e.bitMask))?t.compareExchange(s,a,(function cmpxchgCb(s,o,l){o?startWriteBits(e,t,s):(l&&n("failed to apply bitmask",l),r!==e.pendingAction?startWriteBits(e,t,a):e.pendingAction=null)})):e.pendingAction=null)}s.BitItem=function(e,t,s){shmi.visuals.core.Item.call(this,e,!0),this.parentItemName=t,this.parentItemToken=null,this.parentItemIsCompatible=!0,this.pendingAction=null,this.bitMask=null===s?null:1<<s},s.BitItem.prototype={writeValue:function(e){var t=this,s=shmi.requires("visuals.session.ItemManager").getItem(t.parentItemName);if(t.initialized)if(t.subscribed){if(1===e||"1"===e||"true"===e)e=!0;else if(0===e||"0"===e||"false"===e)e=!1;else if(!0!==e&&!1!==e)return void n("tried to write invalid value to bit item:",e);if(s){var a=null===t.pendingAction;t.pendingAction=e?"set":"unset",a&&startWriteBits(t,s)}else n("unable to find parent item",t.parentItemName)}else n("tried to write to not subscribed item:",t.name);else n("tried to write uninitialized item:",t.name)},addUpdateTarget:function(e){return null!==this.bitMask&&0===Object.keys(this._updateTargets).length&&function subscribeParentItem(e){var t=shmi.requires("visuals.session.ItemManager");e.parentItemToken=t.subscribeItem(e.parentItemName,{setValue:function setValue(t){var s="number"==typeof t||"boolean"==typeof t;e.parentItemIsCompatible!==s&&(e.parentItemIsCompatible=s,updateProperties(e)),s&&e.setValue(!!e.bitMask&&(t&e.bitMask)===e.bitMask)},setProperties:updateProperties.bind(null,e)})}(this),shmi.visuals.core.Item.prototype.addUpdateTarget.call(this,e)},removeUpdateTarget:function(e){shmi.visuals.core.Item.prototype.removeUpdateTarget.call(this,e),null!==this.bitMask&&0===Object.keys(this._updateTargets).length&&function unsubscribeParentItem(e){e.parentItemToken&&(e.parentItemToken.unlisten(),e.parentItemToken=null,e.setProperties({access:[],min:0,max:1,step:1,value_type:null,warn:null,prewarn:null,digits:0,precision:0,unit:null,label:null}))}(this)}},shmi.extend(s.BitItem,shmi.visuals.core.Item)}(),function(){shmi.pkg("visuals.core");var e=100,t=50,s=!1,n={},a=null;function reschedule(){null!==a&&Object.keys(n).length>=e||(null!==a&&clearTimeout(a),a=setTimeout(subscriptionTickHandler,t))}function queueFromActionMap(t){var s=shmi.requires("visuals.tools.iterate").iterateObject,a=[];return s(n,(function(s,r){s===t&&a.length<e&&(a.push(r),delete n[r])})),a}function sendRequest(e,t){var n=shmi.requires("visuals.tools.connect").request;s=!0,n(e,t,(function onRequest(t,n){n&&console.error("[ItemManager] "+e+" failed:",n.category,n.errc,n.message),s=!1,subscriptionTickHandler()}))}function subscriptionTickHandler(){var e=shmi.visuals.session.ItemManager;if(a=null,!s){var t=queueFromActionMap("subscribe");t.length>0?(shmi.visuals.session.config.debug&&console.debug("SUB",t),t.forEach((function(t){var s=e.getItem(t);s&&(s.type=null)})),sendRequest("io.subscribe",t)):(t=queueFromActionMap("unsubscribe")).length>0&&(shmi.visuals.session.config.debug&&console.debug("UNSUB",t),t.forEach((function(t){var s=e.getItem(t);s&&(s.type=null)})),sendRequest("io.unsubscribe",t))}}function unsubscribeItem(e){var t=n[e.name];e.subscribed||void 0!==t?(e.subscribed=!1,"subscribe"===t?delete n[e.name]:"unsubscribe"===t||(n[e.name]="unsubscribe",reschedule())):console.warn("[ItemManager]","Attempted to unsubscribe item that is not subscribed:",e.name)}shmi.visuals.core.ItemManager=function(){var e=this;e.items={},e.writeEventEnabled=!1,e.readBeforeWriteEvent=!1,e.next_id=0,shmi.registerMsgHandler("item.info",(function(t){!function setItemInfo(e,t){e.setProperties(t.data)}(e,t)})),shmi.registerMsgHandler("io.values",(function(t){!function setItemValues(e,t){(0,shmi.requires("visuals.tools.iterate").iterateObject)(t.data,(function(t,s){e.setValue(s,t)}))}(e,t)}))},shmi.visuals.core.ItemManager.prototype={getItemHandler:function(){var noop=function(){};return{setValue:noop,setProperties:noop,lock:noop,unlock:noop}},_createItem:function(e){"string"==typeof e?void 0===this.items[e]?0===e.indexOf("virtual:")||0===e.indexOf("objmap:")?this.items[e]=new shmi.visuals.core.Item(e,!0):0===e.indexOf("bit[")?this.items[e]=function createBitItem(e){var t=e.match(/^bit\[(\d+)\]:(.+)$/);return t?new shmi.visuals.core.BitItem(e,t[2],parseInt(t[1])):new shmi.visuals.core.BitItem(e,null,null)}(e):this.items[e]=new shmi.visuals.core.Item(e):shmi.log("[ItemManager] item '"+e+"' already exists",1):shmi.log("[ItemManager] invalid item name '"+e+"'",3)},_getNextId:function(){return++this.next_id},getItem:function(e){return void 0!==this.items[e]?this.items[e]:null},removeItem:function(e){var t=this,s=shmi.requires("visuals.tools.iterate").iterateObject;t.items[e]&&(s(t.items[e]._updateTargets,(function(s,n){delete t.items[e]._updateTargets[n]})),delete t.items[e])},removeAll:function(){const e=this,t=shmi.requires("visuals.tools.iterate").iterateObject;let s=0;t(e.items,(function(n,a){const r=e.items[a];let o=!1;t(r._updateTargets,(function(e,t){delete r._updateTargets[t],s++,o=!0})),o&&!r.virtual&&r.subscribed&&unsubscribeItem(e.items[a])})),shmi.log("[ItemManager] removed all subscribers ("+s+")",1)},writeValue:function(e,t,s={}){void 0===this.items[e]?console.warn("[ItemManager]","tried to write non-existing item:",e):this.items[e].writeValue(t,s)},readValue:function(e){return this.items[e]?this.items[e].readValue():null},setValue:function(e,t){void 0===this.items[e]?console.warn("[ItemManager]","tried to set-value non-existing item:",e):this.items[e].setValue(t)},compareExchange:function(e,t,s,n){void 0===this.items[e]?(console.warn("[ItemManager]","attempted to compare & exchange on a non-existing item:",e),n(null,!1,{category:"shmi:connect:api:io",code:2147483647,message:"((unknown error))"})):this.items[e].compareExchange(t,s,n)},subscribeItem:function(e,t){var s=this,a=!1;if("string"!=typeof e||!e.length)throw new TypeError(`Invalid item name specified: ${e}`);void 0===s.items[e]&&s._createItem(e),null===e||!s.items[e]||s.items[e].virtual||s.items[e].subscribed||0!==Object.keys(s.items[e]._updateTargets).length||(a=!0);var r={name:e,subscriberId:s.items[e].addUpdateTarget(t),unlisten:(null,function(){s.unsubscribeItem(r)})};return a&&function subscribeItem(e){var t=n[e.name];e.subscribed&&void 0===t?console.warn("[ItemManager]","Attempted to subscribe already subscribed item:",e.name):(e.subscribed=!0,"unsubscribe"===t?(e.initialized&&(e._updateValue=void 0,e.notifyUpdateTargets()),delete n[e.name]):"subscribe"===t||(n[e.name]="subscribe",reschedule()))}(s.items[e]),r},unsubscribeItem:function(e){var t=this,s=null;1===arguments.length?void 0!==t.items[e.name]&&(t.items[e.name].removeUpdateTarget(e.subscriberId),s=e.name):void 0!==t.items[arguments[0]]&&(t.items[arguments[0]].removeUpdateTarget(arguments[1].subscriberId),s=arguments[0]),null!==s&&t.items[s]&&!t.items[s].virtual&&0===Object.keys(t.items[s]._updateTargets).length&&unsubscribeItem(t.items[s])},subscribe:function(e,t=null,s=null){let n=e.map((e=>{const n=this.getItemHandler();return n.setValue="function"==typeof t?(e,s,n)=>t(n,e,s):()=>{},n.setProperties="function"==typeof s?()=>s(e,this.getItem(e).getProperties()):()=>{},this.subscribeItem(e,n)}));return{unlisten:()=>{n.forEach((e=>e.unlisten())),n=[]}}},setProperties:function(e){void 0===this.items[e.item_alias]&&this._createItem(e.item_alias),this.items[e.item_alias].setProperties(e)},writeDirect:function(e,t){var s=shmi.requires("visuals.tools.connect").request,n=this;if(n.readBeforeWriteEvent){const n=Object.getOwnPropertyNames(e);s("io.read",n,(function onRead(n,a){a?t(a,n):s("io.write",{direct:!0,values:e},(function onRequest(s,a){if(!a){const t={};for(let s in e)t[s]={value:e[s],oldValue:n[s]};shmi.fire("write-item",t)}t(a,s)}))}))}else s("io.write",{direct:!0,values:e},(function onRequest(s,a){!a&&n.writeEventEnabled&&shmi.fire("write-item",e),t(a,s)}))},readDirect:function(e,t){(0,shmi.requires("visuals.tools.connect").request)("io.read",e,(function onRequest(e,s){t(s,e)}))},getItemProperties:function(e,t=null){const s=shmi.requires("visuals.session"),n=s.ConnectSession.requestPromise.bind(s.ConnectSession);return"function"==typeof t?n("io.read_item_info",e).then((e=>{t(null,e)})).catch((e=>{t(e,null)})):n("io.read_item_info",e)},enableWriteEvent:function(e){this.writeEventEnabled=!0,e&&(this.readBeforeWriteEvent=!0)},disableWriteEvent:function(){this.writeEventEnabled=!1,this.readBeforeWriteEvent=!1}}}(),shmi.pkg("visuals.core"),shmi.visuals.core.QueryManager=function(){this.queries={}},shmi.visuals.core.QueryManager.prototype={query:function(e,t,s,n,a,r){var o,l=this,u=shmi.requires("visuals.tools.connect").request,c=function getQueryId(e){for(var t=1;void 0!==e.queries[t];)t+=1;return t}(l),m={database_path:(o=a,"number"==typeof o?[null,null,"internal:project","internal:project","internal:user","internal:user","internal:hmi","internal:hmi"][o]:o),table_name:t,columns:s,filter:n};return l.queries[c]={open:!1,failed:!1,connect_id:null,close:!1},Array.isArray(r)&&(m.sort=r),u("db.open",m,(function onRequest(t,s){s?(console.error("[QueryManager] query failed:",s.category,s.errc,s.message),l.queries[c].failed=!0,l.queries[c].close?l.close(c):e(s,0,[])):(l.queries[c].open=!0,l.queries[c].connect_id=t.query_id,l.queries[c].close?l.close(c):e(0,t.total_count,t.columns))})),c},queryDirect:function(e,t,s,n,a,r,o){var l=this,u=null;u=l.query((function(t,s,n){0===t?l.get((function onGet(t,s){l.close(u),e(t,s)}),u,o||0,r||2147483647):(l.close(u),e(t,null))}),t,s,n,a)},get:function(e,t,s,n){var a=shmi.requires("visuals.tools.connect").request,r=this.queries[t];if(!r)throw new Error("[QueryManager] query ID does not exist: "+t);a("db.get",{query_id:r.connect_id,offset:s,limit:n},(function onRequest(t,s){s?(console.error("[QueryManager] get failed:",s.category,s.errc,s.message),e(s,null)):e(0,{data:t.rows})}))},close:function(e,t){var s=this,n=shmi.requires("visuals.tools.connect").request,a=s.queries[e];if(!a)throw new Error("[QueryManager] query ID does not exist: "+e);a.open?(delete s.queries[e],n("db.close",a.connect_id,(function onRequest(e,s){s&&console.error("[QueryManager] close failed:",s.category,s.errc,s.message),t&&t(s||0)}))):a.failed?delete s.queries[e]:a.close=!0},insert:function(e,t,s,n,a,r){(0,shmi.requires("visuals.tools.connect").request)("db.insert",{database_path:a,table_name:e,on_conflict:r||"fail",columns:t,rows:[s]},(function onRequest(e,t){t?(console.error("[QueryManager] insert failed:",t.category,t.errc,t.message),n(t,null)):n(0,e.last_insert_id[0])}))},update:function(e,t,s,n,a,r){var o=shmi.requires("visuals.tools.connect").request,l={};if(t.length!==s.length)throw new Error("[QueryManager] number of values does not match number of columns!");t.forEach((function(e,t){l[e]=s[t]})),o("db.update",{database_path:r,table_name:e,values:l,filter:[{mode:"AND",column:"rowid",clauses:[{operator:"==",value:n}]}]},(function onRequest(e,t){t?(console.error("[QueryManager] update failed:",t.category,t.errc,t.message),a(t,null)):a(0,e.affected_rows)}))},deleteRow:function(e,t,s,n){(0,shmi.requires("visuals.tools.connect").request)("db.delete",{database_path:n,table_name:e,filter:[{mode:"AND",column:"rowid",clauses:[{operator:"==",value:t}]}]},(function onRequest(e,t){t?(console.error("[QueryManager] delete failed:",t.category,t.errc,t.message),s(t,null)):s(0,e.affected_rows)}))},customSQL:function(e,t,s,n){(0,shmi.requires("visuals.tools.connect").request)("db.sql",{database_path:s,sql:e,parameters:n||{}},(function onRequest(e,s){s?(console.error("[QueryManager] delete failed:",s.category,s.errc,s.message),t(s,null)):t(0,e)}))},executePreparedStatement:function(e,t,s){(0,shmi.requires("visuals.tools.connect").request)("db.prepared.execute",{statement_name:e,parameters:t},(function onRequest(e,t){t?(console.error("[QueryManager] prepared query failed:",t.category,t.errc,t.message),s(t,null)):s(0,e)}))}},function(){"use strict";function isValidTimestamp(e){return!isNaN(e)&&null!==e}function ValueUpdate(e,t,s){this.value=e,this.modifiedTimestamp=isValidTimestamp(t)?new Date(t/1e4):null,this.modifiedBy=s||null,Object.freeze(this)}shmi.pkg("visuals.core"),ValueUpdate.convertObject=function convertObject(e){var t=shmi.requires("visuals.tools.iterate.iterateObject"),s={};return e&&t(e,(function(e,t){s[t]=new ValueUpdate(e.value,e.modified_timestamp,e.modified_by)})),s},shmi.visuals.core.Recipe=function(e,t,s,n,a,r,o,l,u,c,m,d,h){Object.defineProperties(this,{id:{value:e,configurable:!1,writable:!1},templateId:{value:t,configurable:!1,writable:!1},manager:{value:h,configurable:!1,writable:!1}}),this.versionId=s,this.versionNum=n,this.name=a,this.createdBy=r,this.createdTimestamp=isValidTimestamp(o)?new Date(o/1e4):null,this.modifiedBy=l,this.modifiedTimestamp=isValidTimestamp(u)?new Date(u/1e4):null,this.comment=c||null,this.metadata=m||{},this.values=ValueUpdate.convertObject(d),Object.seal(this)},shmi.visuals.core.Recipe.prototype={clone:function(e,t){var s=shmi.requires("visuals.tools.connect").request;shmi.checkArg("newName",e,"string"),shmi.checkArg("callback",t,"function"),s("recipe.clone",{recipe_id:this.id,new_name:e},function(e,n){n?t(null,n):null===this.versionId?this.manager.getRecipe(e,t):s("recipe.version.copy",{recipe_version_id:this.versionId,destination_recipe:e},function(s,n){n?t(null,n):this.manager.getRecipe(e,t)}.bind(this))}.bind(this))},refresh:function(e){shmi.checkArg("callback",e,"function"),this.manager.getRecipe(this.id,function(t,s){s||(this.versionId=t.versionId,this.versionNum=t.versionNum,this.name=t.name,this.createdBy=t.createdBy,this.createdTimestamp=isValidTimestamp(t.createdTimestamp)?new Date(t.createdTimestamp/1e4):null,this.modifiedBy=t.modifiedBy,this.modifiedTimestamp=isValidTimestamp(t.modifiedTimestamp)?new Date(t.modifiedTimestamp/1e4):null,this.comment=t.comment||null,this.metadata=t.metadata||{},this.values=t.values),e(s)}.bind(this))},delete:function(e){var t=shmi.requires("visuals.tools.connect").request;shmi.checkArg("callback",e,"function"),t("recipe.del",this.id,(function(t,s){e(s)}))},set:function(e,t,s,n){var a=shmi.requires("visuals.tools.connect").request,r={recipe_id:this.id};shmi.checkArg("name",e,"string","null"),shmi.checkArg("metadata",t,"object","null"),shmi.checkArg("keepExisting",s,"boolean"),shmi.checkArg("callback",n,"function"),null!==e&&(r.name=e),t&&(r.metadata=t),null!==s&&(r.keep_existing=s),a("recipe.set",r,function(e,t){t?n(t):this.refresh(n)}.bind(this))},capture:function(e,t){var s=shmi.requires("visuals.tools.connect").request,n={recipe_id:this.id};shmi.checkArg("comment",e,"string","null"),shmi.checkArg("callback",t,"function"),null!==e&&(n.comment=e),this.versionNum&&(n.version=this.versionNum),s("recipe.capture",n,function(e,s){s?t(s):this.refresh(t)}.bind(this))},apply:function(e){var t=shmi.requires("visuals.tools.connect").request;shmi.checkArg("callback",e,"function"),t("recipe.apply",this.versionId,e)},write:function(e,t){var s=shmi.requires("visuals.tools.connect").request;shmi.checkArg("writeData",e,"object"),shmi.checkArg("callback",t,"function"),s("recipe.version.write",{recipe_version_id:this.versionId,values:e},function(e,s){s?t(s):this.refresh(t)}.bind(this))}}}(),function(){"use strict";shmi.pkg("visuals.core"),shmi.visuals.core.RecipeManager=function(){Object.freeze(this)},shmi.visuals.core.RecipeManager.prototype={createTemplate:function(e,t,s,n){var a=shmi.requires("visuals.tools.connect").request;shmi.checkArg("templateName",e,"string"),shmi.checkArg("items",t,"array"),shmi.checkArg("metadata",s,"object"),shmi.checkArg("callback",n,"function"),a("recipe.template.add",{template_name:e,items:t,metadata:s},function(e,t){t?n(null,t):this.getTemplate(e,n)}.bind(this))},getTemplate:function(e,t){var s=shmi.requires("visuals.tools.connect").request;shmi.checkArg("templateId",e,"number"),shmi.checkArg("callback",t,"function"),s("recipe.template.get",e,function(e,s){s?t(null,s):t(new shmi.visuals.core.RecipeTemplate(e.template_id,e.template_name,e.items.map((e=>e.item_alias)),e.metadata,this),null)}.bind(this))},listTemplates:function(e,t){var s=shmi.requires("visuals.tools.connect").request;shmi.checkArg("filterOptions",e,"object"),shmi.checkArg("callback",t,"function"),s("recipe.template.list",e,function(e,s){s?t(null,s):(e.templates=e.templates.map(function(e){return new shmi.visuals.core.RecipeTemplate(e.template_id,e.template_name,Array.isArray(e.items)?e.items.map((e=>e.item_alias)):null,e.metadata,this)}.bind(this)),t(e,null))}.bind(this))},getRecipe:function(e,t){var s=shmi.requires("visuals.tools.connect").request;shmi.checkArg("recipeId",e,"number"),shmi.checkArg("callback",t,"function"),s("recipe.get",e,function(n,a){a?t(null,a):s("recipe.version.latest",e,function(e,s){t(s?new shmi.visuals.core.Recipe(n.recipe_id,n.template_id,null,null,n.name,null,null,null,null,null,n.metadata,null,this):new shmi.visuals.core.Recipe(n.recipe_id,n.template_id,e.recipe_version_id,e.version,n.name,e.created_by,e.created_timestamp,e.modified_by,e.modified_timestamp,e.comment,n.metadata,e.values,this),null)}.bind(this))}.bind(this))},listRecipes:function(e,t,s){var n=this,a=shmi.requires("visuals.tools.connect").request,r=shmi.requires("visuals.tools.iterate.iterateObject"),o=t.include_values||!1;shmi.checkArg("templateId",e,"number"),shmi.checkArg("filterOptions",t,"object"),shmi.checkArg("callback",s,"function"),shmi.objectHasOwnProperty(t,"include_values")&&delete t.include_values,t.template_id=e,a("recipe.list",t,(function(e,t){var l=0;function collectCallback(t,a,o){l<=0||(o||r(a,(function(e,s){t[s]=e})),0==--l&&(e.recipes=e.recipes.map((function(e){return new shmi.visuals.core.Recipe(e.recipe_id,e.template_id,e.recipe_version_id,e.version,e.name,e.created_by,e.created_timestamp,e.modified_by,e.modified_timestamp,e.comment,e.metadata,e.values,n)})),s(e,null)))}t?s(null,t):e.recipes.length<=0||!o?(e.recipes=e.recipes.map((function(e){return new shmi.visuals.core.Recipe(e.recipe_id,e.template_id,null,null,e.name,null,null,null,null,null,e.metadata,null,n)})),s(e,null)):(l=e.recipes.length,e.recipes.forEach((function(e){a("recipe.version.latest",e.recipe_id,collectCallback.bind(null,e))})))}))}}}(),function(){"use strict";shmi.pkg("visuals.core"),shmi.visuals.core.RecipeTemplate=function(e,t,s,n,a){Object.defineProperties(this,{id:{value:e,configurable:!1,writable:!1},manager:{value:a,configurable:!1,writable:!1}}),this.name=t,this.items=s||[],this.metadata=n||{},Object.seal(this)},shmi.visuals.core.RecipeTemplate.prototype={createRecipe:function(e,t,s){var n=shmi.requires("visuals.tools.connect").request;shmi.checkArg("recipeName",e,"string"),shmi.checkArg("metadata",t,"object"),shmi.checkArg("callback",s,"function"),n("recipe.add",{template_id:this.id,recipe_name:e,metadata:t||{}},function(e,t){t?s(null,t):this.manager.getRecipe(e,s)}.bind(this))},clone:function(e,t){var s=shmi.requires("visuals.tools.connect").request;shmi.checkArg("newName",e,"string"),shmi.checkArg("callback",t,"function"),s("recipe.template.clone",{template_id:this.id,new_name:e},function(e,s){s?t(null,s):this.manager.getTemplate(e,t)}.bind(this))},set:function(e,t,s,n,a){var r=shmi.requires("visuals.tools.connect").request,o={template_id:this.id,keep_existing:n};shmi.checkArg("templateName",e,"string","null"),shmi.checkArg("items",t,"array","null"),shmi.checkArg("metadata",s,"metadata","null"),shmi.checkArg("keepExisting",n,"boolean"),shmi.checkArg("callback",a,"function"),null!==e&&(o.name=e),null!==t&&(o.items=t),null!==s&&(o.metadata=s),r("recipe.template.set",o,function(e,t){t?a(t):this.refresh(a)}.bind(this))},refresh:function(e){shmi.checkArg("callback",e,"function"),this.manager.getTemplate(this.id,function(t,s){s||(this.name=t.name,this.items=t.items||[],this.metadata=t.metadata||{}),e(s)}.bind(this))},delete:function(e){var t=shmi.requires("visuals.tools.connect").request;shmi.checkArg("callback",e,"function"),t("recipe.template.del",this.id,(function(t,s){e(s)}))},listRecipes:function(e,t){this.manager.listRecipes(this.id,e,t)}}}(),shmi.pkg("visuals.core"),function(){function isUnitClass(e){return("string"!=typeof e||""!==e.trim())&&!isNaN(e)}function processTrendData(e,t,s,n){if(!0===n?n=1:!1===n&&(n=0),e.unitClassModule&&e.trendInfo[t]){var a=e.trendInfo[t].items.find((function(e){return e.name&&e.name===s}));if(a&&isUnitClass(a.unit)){var r=parseInt(a.unit),o=e.unitClassModule.getSelectedAdapter(r);o&&(n=o.outFunction(n))}}return n}function applyAdapterSettings(e,t){e.unit=t.unitText,e.min=t.outFunction(e.min),e.max=t.outFunction(e.max)}function processTrendInfo(e,t){var s=t.items,n=shmi.requires("visuals.session.ItemManager"),a=shmi.requires("visuals.tools.iterate.iterateObject");return s.forEach((function(t,s){var r=n.getItem(t.name);if(e.customInfo[t.name]&&a(e.customInfo[t.name],(function(e,s){t[s]=e})),isUnitClass(t.unit)){var o=parseInt(t.unit),l=e.unitClassModule.getSelectedAdapter(o);l&&applyAdapterSettings(t,l)}else r&&r.adapter&&applyAdapterSettings(t,r.adapter)})),t}shmi.visuals.core.TrendManager=function(){var e=this;e.subscribers={},e.trendInfo={},shmi.registerMsgHandler("trend.live.data",(function onLiveTrendData(t){var s=e.subscribers[t.data.id];s?(t.data.values.forEach((function(n,a){t.data.values[a]=processTrendData(e,s.trend_name,s.items[a],n)})),s.callback(0,{name:s.trend_name,data:[t.data]})):console.warn("[TrendManager] subscriber not found, ID:",t.data.id)})),this.unitClassModule=null,this.customInfo={},function loadOptional(e,t,s){try{e[t]=shmi.requires(s),shmi.visuals.session.config.debug&&console.debug("optional module '",s,"' loaded")}catch(e){shmi.visuals.session.config.debug&&console.debug("optional module '",s,"' not available")}}(this,"unitClassModule","visuals.tools.unitClasses")},shmi.visuals.core.TrendManager.prototype={AGG_METHODS:{key:{last:0,avg:1,min:2,max:3},value:["last","avg","min","max"]},setCustomInfo:function(e,t){if("string"!=typeof e||""===e.trim())throw new TypeError("argument 'itemName' is not a string");if("object"!=typeof t||null===t)throw new TypeError("argument 'itemInfo' is not an object");this.customInfo[e]=t},openTrend:function(e,t,s,n,a,r,o){var l=this,u=shmi.requires("visuals.tools.connect").request,c=-1,m=null;if(r=r||0,o=o||(l.trendInfo[e]?l.trendInfo[e].items.map((e=>e.name)):[]),m={trend_name:e,timestamp_start:t,aggregation_type:l.AGG_METHODS.value[r],aggregation_unit:a||1,live:!1,items:o},-1===s){for(c=1;void 0!==l.subscribers[c];)c++;l.subscribers[c]={query_id:c,trend_name:e,items:o,callback:n,aggregate:r,close:!1,open:!1},m.live=!0,m.live_trend_id=c}else m.timestamp_end=Math.round(s);return u("trend.query",m,(function onRequest(t,a){var r={name:e,data:[]};a?n(a,r):(t.rows.forEach((function(t){t.values.forEach((function(s,n){t.values[n]=processTrendData(l,e,o[n],s)})),r.data.push(t)})),n(0,r)),-1===s&&(l.subscribers[c].open=!0,l.subscribers[c].close&&l.closeTrend(e,c))})),c},closeTrend:function(e,t){var s=this,n=shmi.requires("visuals.tools.connect").request,a=s.subscribers[t];void 0!==a&&(a.open?n("trend.unsubscribe",a.query_id,(function onUnsubscribe(e,n){delete s.subscribers[t],n&&console.error("[TrendManager] error unsubscribing:",n)})):a.close=!0)},getTrendList:function(e){(0,shmi.requires("visuals.tools.connect").request)("trend.list",{},(function onRequest(t,s){var n=[];s?e(n,s):(t.recorders&&(console.warn("[TrendManager] renaming response property: 'recorders' -> 'trends'"),t.trends=t.recorders),t.trends.forEach((function(e){n.push(e.trend_name)})),e(n,0))}))},getTrendInfo:function(e,t,s){var n=this;(0,shmi.requires("visuals.tools.connect").request)("trend.info",{trend_name:e,items:s||[]},(function onRequest(e,s){var a=shmi.cloneObject(e),r={};s?t(null,s):(n.trendInfo[e.trend_name]?(n.trendInfo[e.trend_name].items.forEach((function(e){r[e.name]=!0})),e.items.forEach((function(t){r[t.name]||n.trendInfo[e.trend_name].items.push(shmi.cloneObject(t))})),n.trendInfo[e.trend_name].items.sort((function(e,t){return e.name>t.name})),a=processTrendInfo(n,a)):(n.trendInfo[e.trend_name]=shmi.cloneObject(e),a=processTrendInfo(n,a)),t(a,0))}))}}}(),function(){function request(e,t,s){return shmi.visuals.session.ConnectSession.requestPromise(e,t,s)}shmi.pkg("visuals.core"),shmi.visuals.core.TrendManager2=class TrendManager2{constructor(){this._subscriptions={subscribers:{},handles:{}},shmi.registerMsgHandler("trend2.live.data",(e=>{const{data:t}=e,s=t.values.map((e=>{const s=t.timestamp-e.timestamp_offset,n=this._subscriptions.handles[e.handle];return n?{item:n[1],property:n[2],timestamp:s,value:e.value,subscriber:n[0]}:(console.warn(`[TrendManager2] unknown handle received with live trend data: ${e.handle}`),null)})).filter((e=>null!==e));Object.entries(this._subscriptions.subscribers).forEach((([e,t])=>{const n=s.filter((e=>e.subscriber===t)).map((e=>({item:e.item,property:e.property,timestamp:e.timestamp,value:e.value})));n.length&&t.callback(n)}))}))}static async query(e,t,s,n,a){return function getTrendData(e){const t={},s={};return e.items.forEach((e=>{t[e.item_alias]=e,s[e.handle]=e.item_alias,e.values={item:[]},Object.keys(e.additional_handles).forEach((t=>{s[e.additional_handles[t]]=[e.item_alias,t],e.values[t]=[]}))})),e.values.forEach((([e,n,a])=>{const r=s[e];if(r)if(Array.isArray(r)){const[e,s]=r,o=t[e];if(!o)return void console.log("[TrendManager2] unknown item:",e);o.values[s].push([n,a])}else{const e=t[r];if(!e)return void console.log("[TrendManager2] unknown item:",r);e.values.item.push([n,a])}else console.log("[TrendManager2] unknown handle:",e)})),Object.values(t)}(await request("trend2.query",{trend_name:e,items:t,timestamp_start:s,timestamp_end:n,with_info:!1,resolution:a}))}static getInfo(e,t){return request("trend2.info",{trend_name:e,items:t})}static async getTrendList(){return(await request("trend.list",{})).trends.map((e=>e.trend_name))}async subscribe(e,t,s,n){const a=await request("trend2.subscribe",{trend_name:e,resolution:s,items:t}),r=this._subscriptions.subscribers[a.trend_subscription_id]={id:a.trend_subscription_id,items:t.slice(),callback:n};return a.items.forEach((e=>{this._subscriptions.handles[e.handle]=[r,e.item_alias,null],Object.entries(e.additional_handles).forEach((([t,s])=>{this._subscriptions.handles[s]=[r,e.item_alias,t]}))})),r.id}async unsubscribe(e){await request("trend2.unsubscribe",e),Object.keys(this._subscriptions.handles).forEach((t=>{this._subscriptions.handles[t][0].id===e&&delete this._subscriptions.handles[t]})),delete this._subscriptions.subscribers[e]}}}(),shmi.pkg("visuals.core"),shmi.visuals.core.UiAction=function(e,t){this.actionParameter=e,this.owner=void 0!==t?t:null,shmi.visuals.session&&shmi.visuals.session.config&&!0===shmi.visuals.session.config.action_debug&&(null===this.owner?console.log("UiAction - no owner provided",this):console.log("UiAction - owner:",t,this)),this.onExecute=[],this.init()},shmi.visuals.core.UiAction.prototype={init:function(){var e,t=0;e=Array.isArray(this.actionParameter)?this.actionParameter:(this.actionParameter,[this.actionParameter]);for(var s=this;t<e.length;){var n=e[t];if("string"==typeof n){var a=n.split(":"),r=a[0];a.shift(),console.warn("[UiAction]","the following UI-action configuration is using deprecated string notiation and should be updated to object notation:",n),shmi.visuals.session.userActions&&shmi.visuals.session.userActions[r]?this.onExecute.push(function(e,t){return function(n,a,r){shmi.visuals.session.userActions[e](t,n,a,r,s.owner)}}(r,a)):shmi.visuals.session.sysActions&&shmi.visuals.session.sysActions[r]?this.onExecute.push(function(e,t){return function(n,a,r){shmi.visuals.session.sysActions[e](t,n,a,r,s.owner)}}(r,a)):console.warn("[UiAction]","unknown UI-action:",n)}else"object"==typeof n&&(shmi.visuals.session.userActions&&shmi.visuals.session.userActions[n.name]?this.onExecute.push(function(e,t){return function(n,a,r){shmi.visuals.session.userActions[e](t,n,a,r,s.owner)}}(n.name,n.params)):shmi.visuals.session.sysActions&&shmi.visuals.session.sysActions[n.name]?this.onExecute.push(function(e,t,n){return function(a,r,o){shmi.visuals.session.sysActions[e](t,a,r,o,n?s.owner:null)}}(n.name,n.params,n.relative)):console.warn("[UiAction]","unknown UI-action:",n.name));t++}},execute:function(e,t,s){for(var n=0;n<this.onExecute.length;n++)this.onExecute[n](e,t,s);shmi.log("[UiAction] executed "+this.onExecute.length+" actions",1)}},shmi.pkg("visuals.session"),shmi.visuals.session.sysActions=shmi.visuals.session.sysActions||{},shmi.visuals.session.sysActions.dialog=function(e){var t=null;if(t=3===e.length&&"relative"===e[2]?shmi.ctrl(e[0],arguments[4]):shmi.ctrl(e[0]))switch(e[1]){case"show":case"open":t.show();break;case"hide":case"close":t.hide();break;case"default":console.error("[UiAction] - dialog","unknown dialog action '"+e[1]+"'.")}else console.error("[UiAction] - dialog","could not find dialog:",e[0])},shmi.visuals.session.sysActions["set-theme"]=function(e){var t="-theme",s=document.documentElement,n=null,a=[];if(1!==e.length){for(var r=0;r<s.classList.length;r++)(n=s.classList[r]).indexOf(t)===n.length-t.length&&a.push(n);a.forEach((function(e){s.classList.remove(e)}))}else{for(var o=0;o<s.classList.length;o++)(n=s.classList[o]).indexOf(t)===n.length-t.length&&a.push(n);a.forEach((function(e){s.classList.remove(e)})),s.classList.add(e[0])}},function(){function stopSubscription(e){shmi.decouple((function(){e.token&&(e.token.unlisten(),e.token=null)}))}shmi.visuals.session.sysActions["write-item"]=function(e){if(2!==e.length)shmi.log("[UserAction] write-item - UI-action requires two parameters (<item alias>, <value to set>)",2);else{var t=shmi.visuals.session.ItemManager,s={};s[e[0]]=e[1],"string"==typeof e[0]&&0!==e[0].indexOf("bit[")&&(0===e[0].indexOf("virtual:")||t.getItem(e[0])&&t.getItem(e[0]).virtual)?t.writeValue(e[0],e[1]):"string"==typeof e[0]&&0===e[0].indexOf("bit[")?function writeBitItem(e,t){var s=shmi.requires("visuals.session.ItemManager"),n={token:null},a=s.getItemHandler(),r=!1,o=!1,l=!1;a.setProperties=function setProperties(t,a,l,u,c){o||"number"==typeof c&&(-1!==c&&s.getItem(e)&&(r=!0),o=!0,r||(console.error("Attempted to write to non-existing item:",e),stopSubscription(n)))},a.setValue=function setValue(a){o&&r&&!l&&(l=!0,s.writeValue(e,t?1:0),stopSubscription(n))},n.token=s.subscribeItem(e,a)}(e[0],e[1]):t.writeDirect(s,(function(){}))}}}(),shmi.visuals.session.sysActions.logout=function(e){var t=null;!0===e[0]?((t=new URL(window.location.href)).searchParams.set("autoLogin","false"),window.location.href=t.toString()):window.location.reload()},shmi.visuals.session.sysActions["logout-confirm"]=function(e){shmi.confirm(e[0]?e[0]:"logout?",(function(t){if(t){var s=null;!0===e[1]?((s=new URL(window.location.href)).searchParams.set("autoLogin","false"),window.location.href=s.toString()):window.location.reload()}}))},shmi.visuals.session.sysActions["toggle-class"]=function(e){if(2===e.length){var t=e[0],s=e[1],n=shmi.getElementByName(t);n?shmi.hasClass(n,s)?shmi.removeClass(n,s):shmi.addClass(n,s):shmi.log("[UserAction] toggle-class - no element found by name '"+t+"'",2)}},shmi.visuals.session.sysActions["add-class"]=function(e){if(2!==e.length)shmi.log("[UserAction] add-class - needs two parameters",2);else{var t=e[0],s=e[1],n=shmi.getElementByName(t);shmi.log("[UserAction] add-class - name: "+t+" cssClass: "+s,2),n?shmi.addClass(n,s):shmi.log("[UserAction] add-class - no element found by name '"+t+"'",2)}},shmi.visuals.session.sysActions["remove-class"]=function(e){if(2!==e.length)shmi.log("[UserAction] remove-class - needs two parameters",2);else{var t=e[0],s=e[1],n=shmi.getElementByName(t);shmi.log("[UserAction] remove-class - name: "+t+" cssClass: "+s,2),n?shmi.removeClass(n,s):shmi.log("[UserAction] remove-class - no element found by name '"+t+"'",2)}},shmi.visuals.session.sysActions.setview=function(e){if(2!==e.length)shmi.log("[UserAction] setview - needs two parameters",2);else{var t=shmi.ctrl(e[0]);if(t)try{t.setView(parseInt(e[1])),shmi.log("[UserAction] setview - view set",1)}catch(e){shmi.log("[UserAction] exception setting view for panel: "+e,2)}else shmi.log("[UserAction] setview - no element found by name '"+e[0]+"'",2)}},shmi.visuals.session.sysActions["screen-setview"]=shmi.visuals.session.sysActions.setview,shmi.visuals.session.sysActions["ask-save"]=function(e){if(2!==e.length)shmi.log("[UserAction] ask-save - needs two parameters",2);else if(void 0!==shmi.visuals.session.AskSaves[e[0]]){var t="SAVE"===e[1],s="SAVE"===e[1]||"NOSAVE"===e[1];shmi.visuals.session.AskSaves[e[0]](t,s),delete shmi.visuals.session.AskSaves[e[0]]}else shmi.log("[UserAction] ask-save - Save request '"+e[0]+"' was not found",2)},shmi.visuals.session.sysActions.confirm=function(e){if(2!==e.length)shmi.log("[UserAction] confirm - needs two parameters",2);else if(void 0!==shmi.visuals.session.Confirmations[e[0]]){var t="TRUE"===e[1];shmi.visuals.session.Confirmations[e[0]](t),delete shmi.visuals.session.Confirmations[e[0]]}else shmi.log("[UserAction] confirm - Confirmation request '"+e[0]+"' was not found",2)},shmi.visuals.session.sysActions.grid=function(e){if(e.length<2)shmi.log("[UserAction] grid - needs at least two parameters",2);else{var t=shmi.visuals.session.DataGridManager.grids[e[0]];if(void 0!==t)switch(e[1]){case"next-page":t.nextPage();break;case"previous-page":t.previousPage();break;case"refresh":t.refresh&&t.refresh();break;case"delete-selected":var s=arguments[4],n=shmi.ctrl(e[2],s),a=[];void 0!==n?a=n.getSelectedRows().selRows:shmi.log("[UserAction] grid:delete-selected - complex-table '"+e[2]+"' not found",2);for(var r=0;r<a.length;r++)t.deleteRow(a[r]);break;default:shmi.log("[UserAction] grid - unknown function '"+e[1]+"' configured",3)}else shmi.log("[UserAction] grid - DataGrid '"+e[0]+"' not found!",3)}},shmi.visuals.session.sysActions.createrow=function(e){if(e.length<2)shmi.log("[UserAction] createrow - needs at least two parameters",2);else{var t=shmi.ctrl(e[0]),s=shmi.visuals.session.DataGridManager.grids[e[1]];if(void 0!==t){for(var n=[],a=0;a<s.fields.length;a++)n.push({field:s.fields[a],type:4,value:""});t.setValues(n,(function(e){var t,n=[];for(a=0;a<s.fields.length;a++)t={type:4,min:Number.NaN,max:Number.NaN,value:void 0,field:s.fields[a]},n.push(t);for(var r=0;r<e.length;r++){t={type:4,min:Number.NaN,max:Number.NaN,value:e[r].value,field:e[r].field};var o=s.fields.indexOf(t.field);-1!==o&&(n[o]=t)}var l=s.insertRow(n);shmi.visuals.session.DataGridManager.saveRowToDB(s.name,l,!0)}))}else shmi.log("[UserAction] createrow - Form '"+e[0]+"' not found!",3)}},shmi.visuals.session.sysActions["test-action"]=function(e,t){console.log("UiAction: test-action",e,t)},shmi.visuals.session.sysActions.notify=function(e,t){shmi.notify(e[0],e[1])},shmi.visuals.session.sysActions.setlocale=function(e,t){1===e.length?shmi.requires("visuals.session.UserManager").setLocale(e[0]):console.error("[UiAction:setlocale] missing parameter: Locale")},shmi.visuals.session.sysActions["acknowledge-all-alarms"]=function(){shmi.requires("visuals.session.AlarmManager").ackAlarm(-1)},shmi.visuals.session.sysActions.navigate=function(e){var t=null;e.forEach((function(e,s,n){if(s%2==0){var a=shmi.ctrl("."+e,t);if(null===a)throw new Error("could not resolve control: "+e);var r=!1;if("screen"===a.uiType?a.viewElements.forEach((function(e,t){r||e.getAttribute("data-name")===n[s+1]&&(a.setView(t),r=!0)})):a.controls.forEach((function(e,t){r||"view"===e.uiType&&e.element.getAttribute("data-name")===n[s+1]&&(a.setView(t),r=!0)})),!r)throw new Error("could not resolve control: "+n[s+1]);t=a}}))},function(){shmi.pkg("visuals.core");var e=0;function setLongTimeout(t,s){s>2147483647?(s-=2147483647,e=setTimeout((function(){setLongTimeout(t,s)}),2147483647)):e=setTimeout(t,s)}shmi.visuals.core.User=function(e){this.loggedIn=!1,this.name=e,this.locale=null,this.actUrl=null,this.homeUrl=null,this.groupList=[],this.userData={},this.groupData={},this.autoLogoffTime=0,this.newPasswordRequired=0,this.firstName=null,this.lastName=null,this.description=null,this.id=null},shmi.visuals.core.User.prototype={setProperties:function(e){const{selectLocale:t}=shmi.requires("visuals.tools.localeSelection"),{localeInfo:s}=shmi.requires("visuals.session");this.loggedIn=null!==e,this.locale=e?t(e.locale_id,Object.keys(s.locales),s.default):null,this.actUrl=null,this.homeUrl=null,this.groupList=e?e.groups:[],this.userData=e&&e.data?e.data:{},this.groupData=e&&e.group_data?e.group_data:{},this.firstName=e&&"string"==typeof e.first_name?e.first_name:null,this.lastName=e&&"string"==typeof e.last_name?e.last_name:null,this.description=e&&"string"==typeof e.comment?e.comment:null,this.id=e&&"string"==typeof e.id?e.id:null;var n=!!e&&e.password_is_expired;this.loggedIn&&(this.newPasswordRequired=n,this.newPasswordRequired&&console.info("[User]","current password expired"));var a=e?e.auto_logout_duration:0;isNaN(a)||(this.autoLogoffTime=a,console.debug("[User]","auto-logoff set to",a,"seconds."))},resetInactivity:function(){var t=this;clearTimeout(e),e=0,t.autoLogoffTime>0&&setLongTimeout((function(){shmi.visuals.session.UserManager.logout(),console.debug("[User]","user logged out after being inactive for",t.autoLogoffTime,"seconds")}),1e3*t.autoLogoffTime)},getUserData:function getUserData(e,t){return shmi.checkArg("key",e,"string"),shmi.checkArg("lookupIn",t,"string","array","undefined"),void 0===t?t=["user","group"]:"string"==typeof t&&(t=[t]),t.includes("user")&&shmi.objectHasOwnProperty(this.userData,e)?this.userData[e]:t.includes("group")&&shmi.objectHasOwnProperty(this.groupData,e)?this.groupData[e]:null}}}(),shmi.pkg("visuals.core"),shmi.visuals.core.UserManager=function(){this.currentUser=null,this.loggedIn=!1,this.userList={},this.userListCallback=null,this.credentialProviders=[],this.credentialProviderNextId=0,this.registerDefaultCredentialProviders()},shmi.visuals.core.UserManager.prototype={registerCredentialProvider:function registerCredentialProvider(e,t){shmi.checkArg("priority",e,"number"),shmi.checkArg("providerFunc",t,"function");const s=++this.credentialProviderNextId;return this.credentialProviders.push({id:s,priority:e,func:t}),this.credentialProviders.sort((({priority:e},{priority:t})=>t-e)),s},unregisterCredentialProvider:function unregisterCredentialProvider(e){shmi.checkArg("providerId",e,"number");const t=this.credentialProviders.findIndex((({id:t})=>t===e));this.credentialProviders.splice(t)},registerDefaultCredentialProviders:function registerDefaultCredentialProviders(){this.registerCredentialProvider(0,(()=>{const e=shmi.visuals.session;return e.URLParameters.usr&&e.URLParameters.pwd?{username:e.URLParameters.usr,password:e.URLParameters.pwd}:null})),this.registerCredentialProvider(0,(()=>{const e=shmi.visuals.session;return"false"===e.URLParameters.autoLogin?null:e.config["auto-login"]&&e.config["auto-login"].enabled?e.config["auto-login"].user?e.config["auto-login"].password?{username:e.config["auto-login"].user,password:e.config["auto-login"].password}:(console.warn("[UserManager] Auto-Login is enabled in configuration but no 'password' given."),null):(console.warn("[UserManager] Auto-Login is enabled in configuration but no 'user' given."),null):null})),this.registerCredentialProvider(0,(()=>{const e=shmi.visuals.session;return"false"===e.URLParameters.autoLogin?null:e.config.observer&&e.config.observer.enabled&&e.observerAllowed?e.config.observer.user?e.config.observer.password?{username:e.config.observer.user,password:e.config.observer.password}:(console.warn("[UserManager] Auto-Observer is enabled in configuration but no 'password' given."),null):(console.warn("[UserManager] Auto-Observer is enabled in configuration but no 'user' given."),null):null}))},setUserList:function(e){var t=this,s=shmi.requires("visuals.tools.iterate").iterateObject;s(t.userList,(function(e,s){delete t.userList[s]})),s(e,(function(s,n){t.userList[e[n]]=new shmi.visuals.core.User(e[n])})),t.userListCallback&&(t.userListCallback(t.userList),t.userListCallback=null)},setProperties:function(e,t,s,n){var a=this,r=!1,o=null;this.currentUser?(this.currentUser.name===e?(r=this.currentUser.loggedIn,o=this.currentUser.locale,this.currentUser.setProperties(t),this.currentUser.loggedIn&&!r?(s&&s(0),shmi.fire("login-state",{name:e,loggedIn:!0,locale:this.currentUser.locale},this)):this.currentUser.loggedIn&&r?(o!==this.currentUser.locale&&this._reloadLocale(),shmi.fire("login-state",{name:e,loggedIn:!0,locale:this.currentUser.locale},this)):s?(s(n||1),shmi.fire("login-state",{name:e,loggedIn:!1,locale:this.currentUser.locale},this)):this.currentUser.loggedIn||(shmi.log("[UserManager] already logged-in user tried to login with invalid credentials",2),shmi.fire("login-state",{name:e,loggedIn:!1,locale:this.currentUser.locale},this))):(s&&s(0),r=this.currentUser.loggedIn,o=this.currentUser.locale,this.currentUser.name=e,this.currentUser.setProperties(t),this.currentUser.loggedIn&&r?(o!==this.currentUser.locale&&this._reloadLocale(),shmi.fire("login-state",{name:e,loggedIn:!0,locale:this.currentUser.locale},this)):this.currentUser.loggedIn?(this._reloadLocale(),shmi.fire("login-state",{name:e,loggedIn:!0,locale:this.currentUser.locale},this)):shmi.fire("login-state",{name:e,loggedIn:!1,locale:this.currentUser.locale},this)),this.currentUser.resetInactivity(),function testPasswordExpired(){a.currentUser.loggedIn&&a.currentUser.newPasswordRequired&&shmi.fire("password-expired",{name:a.currentUser.name,user:a.currentUser},a,!0)}()):this.userList[e]?this.userList[e].setProperties(t):shmi.log("[UserManager] User '"+e+"' not found.",2)},_reloadLocale:function(){var e=this,t=shmi.visuals.session,s=t.UserManager;function load_json_locale(){shmi.decouple((function(){shmi.loadResource(shmi.evalString(shmi.c("LOCALE_PATH_PATTERN"),{index:s.currentUser.locale}),e._resetSession.bind(e))}))}!0===t.config.load_locale_db&&"function"==typeof shmi.loadDBLocale?shmi.loadDBLocale(s.currentUser.locale,load_json_locale):load_json_locale()},_resetSession:function(e,t,s){if(shmi.visuals.session.locale=shmi.visuals.session.locale||{},t)console.error("[UserManager] failed to load locale resource:",s);else{var n={},a={},r=shmi.requires("visuals.tools.iterate").iterateObject;try{a=JSON.parse(e),r(a,(function(e,t){shmi.visuals.session.locale[t]=a[t]}))}catch(e){console.error("[UserManager] failed to parse new locale:",s,e)}for(shmi.visuals.session.ItemManager.removeAll(),shmi.visuals.session.AlarmManager.removeAll(),shmi.decouple(shmi.visuals.session.DataGridManager.restart.bind(shmi.visuals.session.DataGridManager)),r(shmi.visuals.session.names,(function(e,t){-1===t.indexOf(".")&&shmi.deleteControl(e.ctrl)}));document.body.firstChild;)document.body.removeChild(document.body.firstChild);if(shmi.visuals.session.config["show-load-screen"]){var o=document.createElement("div"),l=shmi.pkg("visuals.session.SysControlConfig.loadingOverlay");o=document.createElement(l.tagName||"DIV"),shmi.addClass(o,l["class-name"]||"loading-box-overlay"),l.template&&shmi.loadResource(shmi.c("TEMPLATE_PATH")+l.template+shmi.c("TEMPLATE_EXT"),(function(e,t){t||(o.innerHTML=e)})),document.body.appendChild(o)}shmi.decouple((()=>{this.restartSession(n,o),shmi.log("[RESTART] CALLED",0),shmi.visuals.session.startScripts&&r(shmi.visuals.session.startScripts,(function(e,t){shmi.log("[RESTART] running script: "+t,0);try{shmi.visuals.session.startScripts[t]()}catch(e){shmi.log("[RESTART] failed to execute start-script '"+t+"': "+e,2)}}))})),shmi.log("[UserManager] Bookmark: "+n,0)}},requestLogin:function(e,t,s){var n=this,a=shmi.requires("visuals.session").SocketConnection,r=shmi.requires("visuals.tools.connect").request;if(!0!==a.connected)throw new Error("socket connection is not established yet");this.currentUser=new shmi.visuals.core.User(e),this.pwd=t,r("user.login",{username:e,password:t},(function onRequest(t,r){0===r?(n.setProperties(e,t,s,r),a.connectCallback&&n.currentUser&&n.currentUser.loggedIn&&(a.connectCallback=null)):n.setProperties(e,null,s,r)}))},requestAutoLogin:function(e){const t=this,s=this.credentialProviders.slice();(function tryNext(){if(0===s.length)return Promise.reject(new Error("Auto-Login credentials exhausted"));{const e=s.shift();return Promise.resolve(e.func()).then((s=>s?new Promise(((n,a)=>{t.requestLogin(s.username,s.password,(t=>{e.statusCallback&&e.statusCallback(!t),t?a(t):n()}))})):tryNext()))}})().then(e.bind(null,0)).catch(e.bind(null))},requestTokenAuth:function(e,t){const s=this,n=shmi.requires("visuals.session").SocketConnection,{request:a}=shmi.requires("visuals.tools.connect");if(!0!==n.connected)throw new Error("socket connection has not been established yet");s.currentUser=null,s.pwd=null,a("user.auth",{token:e},(function onRequest(e,a){0===a?(s.currentUser=new shmi.visuals.core.User(e.username),s.setProperties(e.username,e,t,a),n.connectCallback&&s.currentUser&&s.currentUser.loggedIn&&(n.connectCallback=null)):"function"==typeof t&&s.setProperties(null,null,t,a)}))},requestAuthToken:function(e,t){const s=shmi.requires("visuals.session").SocketConnection,{request:n}=shmi.requires("visuals.tools.connect");if(!0!==s.connected)throw new Error("socket connection has not been established yet");n("user.token",e,(function onRequest(e,s){0===s?t(e,null):"function"==typeof t&&t(null,s)}))},requestUserList:function(e){const t=this,{request:s}=shmi.requires("visuals.tools.connect");if(!0!==shmi.visuals.session.SocketConnection.connected)throw new Error("socket connection is not established yet");this.userListCallback=e,s("user.list",{sort:[{column:"username",order:"ASC"}]},(function(e,s){var n=[];e&&Array.isArray(e.users)?e.users.forEach((function(e){n.push(e.username)})):console.error("[UserManager] could not retrieve userlist:",s.category,s.errc,s.message),t.setUserList(n)}))},logout:function(e){var t=this,s=shmi.requires("visuals.tools.connect").request,n=shmi.requires("visuals.tools.iterate.iterateObject"),a=shmi.visuals.session.ItemManager;n(a.views,(function(e,t){a.closeView(t)})),s("user.logout",{},(function onRequest(s,n){0===n&&t.setProperties(null,null),"function"==typeof e&&e(s,n)}))},changePassword:function(e,t,s){(0,shmi.requires("visuals.tools.connect").request)("user.setpw",{current_password:e,new_password:t},(function(e,n){n||(this.pwd=t),s&&s(e,n)}))},restartSession:function(e,t){var s=document.createDocumentFragment(),n=document.createElement("div");for(n.innerHTML=shmi.visuals.session.ProjectSource,s.appendChild(n);s.firstChild.firstChild;)document.body.appendChild(s.firstChild.firstChild);shmi.visuals.session.names={};var a=document.getElementById("viewportMeta");a&&a.setAttribute("content",a.getAttribute("content").replace("user-scalable=no","user-scalable=yes")),shmi.loadResource(shmi.c("VIRTUAL_ITEMS_CONFIG_PATH"),(function(s,n,a){n?console.error("error loading virtual-item config",a):shmi.visuals.init.initVItems(JSON.parse(s));const r=shmi.visuals.parser.parseProject(e);shmi.waitOnInit(r,(()=>{const e=document.createEvent("Event"),s=shmi.visuals.session;shmi.log("[UserManager] All controls initialized",2),e.initEvent("resize",!0,!0),window.dispatchEvent(e),shmi.visuals.session.config["show-load-screen"]&&setTimeout((function(){!1===s.config["load-screen-transition"]?document.body.removeChild(t):(t.style.opacity=0,t.addEventListener("transitionend",(function(){document.body.removeChild(t)})),t.addEventListener("webkitTransitionEnd",(function(){document.body.removeChild(t)})))}),shmi.c("LOAD_TIMEOUT")),shmi.fire("parser-ready",{},shmi.visuals.session)}))}))},resetInactivity:function(){this.currentUser&&this.currentUser.loggedIn&&this.currentUser.resetInactivity()},setLocale:function(e,t){var s,n=this,a=null,r=n.getLocaleInfo(),o=shmi.requires("visuals.tools.connect");if(!n.currentUser||!n.currentUser.loggedIn)throw new Error("No user logged in, cannot change locale");if(!(r&&r.locales&&r.locales[e]))throw new Error("Locale not configured: "+e);s=n.currentUser.locale,o.request("user.setlang",{locale_id:e},(function onResponse(r,o){0===o?(n.currentUser.locale=e,s!==e?(n._reloadLocale(),a=shmi.listen("parser-ready",(function(){a.unlisten(),shmi.fire("login-state",{name:n.currentUser.name,loggedIn:!0,locale:e},n),t&&t(o)}))):t&&t(o)):(shmi.notify("${V_ERROR_LOCALE_CHANGE}","${V_ERROR}",{LOCALE:e,ERROR_CODE:o}),t&&t(o))}))},getLocaleInfo:function(){return shmi.cloneObject(shmi.visuals.session.localeInfo)},getUserData:function getUserData(e,t){return this.currentUser?this.currentUser.getUserData(e,t):null},setUserData:function setUserData(e,t){const{ConnectSession:s}=shmi.visuals.session;if(shmi.checkArg("data",e,"object"),shmi.checkArg("callback",t,"function","undefined"),!this.currentUser)throw new Error("No user logged in, cannot set user data");s.request("user.set_data",e,((s,n)=>{!n&&this.currentUser&&Object.entries(e).forEach((([e,t])=>{void 0===t||(null===t?delete this.currentUser.userData[e]:this.currentUser.userData[e]=t)})),t?t(s,n):n&&console.error("[UserManager]","Failed to set user data.","\n\tWebIQ Server returned",n,"\n\tData was",e)}))},clearUserData:function clearUserData(e){const{ConnectSession:t}=shmi.visuals.session;if(shmi.checkArg("callback",e,"function","undefined"),!this.currentUser)throw new Error("No user logged in, cannot clear user data");t.request("user.clear_data",{},((t,s)=>{!s&&this.currentUser&&(this.currentUser.userData={}),e?e(t,s):s&&console.error("[UserManager]","Failed to clear user data.","\n\tWebIQ Server returned",s)}))},getCurrentUser:function getCurrentUser(){return this.currentUser}},function(){shmi.pkg("visuals.io");var e=1e3;function isTouchMode(t){return t.sourceCapabilities?t.sourceCapabilities.firesTouchEvents:t.timeStamp-shmi.visuals.io.TouchListener.prototype.lastTimeStamp<e}shmi.visuals.io.MouseListener=function(e,t,s){/iPhone/.test(navigator.userAgent)||/iPad/.test(navigator.userAgent)||/Android/.test(navigator.userAgent)?this.inactive=!0:(this.element=e,this.startX=0,this.startY=0,this.dx=0,this.dy=0,this.totalDx=0,this.totalDy=0,this.last_click_time=0,this.double_click_time=500,this.mousepressed=!1,this.moved=!1,this.functions=t,this.dragThreshold=s&&"number"==typeof s.dragThreshold?s.dragThreshold:shmi.c("MIN_MOVED_PX"),this.mousedown=this.mouseDown.bind(this),this.mouseup=this.mouseUp.bind(this),this.mousemove=this.mouseMove.bind(this),this.mouseover=this.mouseOver.bind(this),this.mouseout=this.mouseOut.bind(this),this.mousewheel=this.mouseWheel.bind(this),this.moveDiv=null,this._inactiveReset=function(){shmi.visuals.session.UserManager.resetInactivity()},this.init())},shmi.visuals.io.MouseListener.prototype={init:function(){},disable:function(){this.inactive||(this.mousepressed=!1,window.navigator.msPointerEnabled?(this.element.removeEventListener("MSPointerDown",this.mousedown),this.element.removeEventListener("MSPointerOver",this.mouseover),this.element.removeEventListener("MSPointerUp",this.mouseup),this.element.removeEventListener("MSPointerMove",this.mousemove),this.element.removeEventListener("MSPointerOut",this.mouseout),this.moveDiv&&(this.moveDiv.removeEventListener("MSPointerMove",this.mousemove),this.moveDiv.removeEventListener("MSPointerUp",this.mouseup),this.moveDiv.removeEventListener("MSPointerOut",this.mouseout),document.body.removeChild(this.moveDiv),this.moveDiv=null)):(this.element.removeEventListener("mousedown",this.mousedown),this.element.removeEventListener("mouseover",this.mouseover),this.element.removeEventListener("mouseup",this.mouseup),this.element.removeEventListener("mousemove",this.mousemove),this.element.removeEventListener("mouseout",this.mouseout),this.moveDiv&&(this.moveDiv.removeEventListener("mousemove",this.mousemove),this.moveDiv.removeEventListener("mouseup",this.mouseup),this.moveDiv.removeEventListener("mouseout",this.mouseout),document.body.removeChild(this.moveDiv),this.moveDiv=null)),this.functions.onWheel&&(this.element.removeEventListener("mousewheel",this.mousewheel),this.element.removeEventListener("DOMMouseScroll",this.mousewheel)))},enable:function(){this.inactive||(window.navigator.msPointerEnabled?(this.element.removeEventListener("MSPointerDown",this.mousedown),this.element.removeEventListener("MSPointerOver",this.mouseover),this.element.removeEventListener("MSPointerUp",this.mouseup),this.element.removeEventListener("MSPointerMove",this.mousemove),this.element.removeEventListener("MSPointerOut",this.mouseout),this.moveDiv&&(this.moveDiv.removeEventListener("MSPointerMove",this.mousemove),this.moveDiv.removeEventListener("MSPointerUp",this.mouseup),this.moveDiv.removeEventListener("MSPointerOut",this.mouseout),document.body.removeChild(this.moveDiv),this.moveDiv=null),this.element.addEventListener("MSPointerMove",this.mousemove),this.element.addEventListener("MSPointerUp",this.mouseup),this.element.addEventListener("MSPointerOut",this.mouseout),this.element.addEventListener("MSPointerDown",this.mousedown)):(this.element.removeEventListener("mousedown",this.mousedown),this.element.removeEventListener("mouseover",this.mouseover),this.element.removeEventListener("mouseup",this.mouseup),this.element.removeEventListener("mousemove",this.mousemove),this.element.removeEventListener("mouseout",this.mouseout),this.moveDiv&&(this.moveDiv.removeEventListener("mousemove",this.mousemove),this.moveDiv.removeEventListener("mouseup",this.mouseup),this.moveDiv.removeEventListener("mouseout",this.mouseout),document.body.removeChild(this.moveDiv),this.moveDiv=null),this.element.addEventListener("mouseover",this.mouseover),this.element.addEventListener("mouseout",this.mouseout),this.element.addEventListener("mousedown",this.mousedown),this.element.addEventListener("mousemove",this.mousemove),this.element.addEventListener("mouseup",this.mouseup)),this.functions.onWheel&&(this.element.addEventListener("mousewheel",this.mousewheel),this.element.addEventListener("DOMMouseScroll",this.mousewheel)))},mouseDown:function(e){this._inactiveReset(),0!==e.button||isTouchMode(e)||(this.moved=!1,this.startX=e.clientX,this.startY=e.clientY,this.totalDx=0,this.totalDy=0,this.dx=0,this.dy=0,this.mousepressed=!0,this.functions.onPress&&!e.consumed&&(this.functions.onPress(this.startX,this.startY,e),e.consumed=!0),this.functions.onDrag&&e.stopPropagation())},mouseUp:function(e){if(this._inactiveReset(),!isTouchMode(e)){if(this.functions.onRelease&&this.functions.onRelease(e.clientX,e.clientY,e),!this.moved&&this.mousepressed&&this.functions.onClick&&(e.preventDefault(),!e.consumed))if(e.consumed=!0,this.functions.onDoubleClick){var t=Date.now();t-this.last_click_time<this.double_click_time?this.functions.onDoubleClick(e.clientX,e.clientY,e):(this.functions.onClick(e.clientX,e.clientY,e),this.last_click_time=t)}else this.functions.onClick(e.clientX,e.clientY,e);this.mousepressed=!1,this.functions.onDrag&&e.stopPropagation(),this.moved=!1,window.navigator.msPointerEnabled?this.moveDiv&&(this.moveDiv.removeEventListener("MSPointerMove",this.mousemove),this.moveDiv.removeEventListener("MSPointerUp",this.mouseup),this.moveDiv.removeEventListener("MSPointerOut",this.mouseout),document.body.removeChild(this.moveDiv),this.moveDiv=null):this.moveDiv&&(this.moveDiv.removeEventListener("mousemove",this.mousemove),this.moveDiv.removeEventListener("mouseup",this.mouseup),this.moveDiv.removeEventListener("mouseout",this.mouseout),document.body.removeChild(this.moveDiv),this.element.addEventListener("mouseout",this.mouseout),this.moveDiv=null)}},mouseMove:function(e){if(this._inactiveReset(),!isTouchMode(e)&&this.mousepressed)if(this.dx=e.clientX-this.startX,this.dy=e.clientY-this.startY,this.totalDx+=this.dx,this.totalDy+=this.dy,this.startX=e.clientX,this.startY=e.clientY,this.moved=Math.abs(this.totalDx)+Math.abs(this.totalDy)>=this.dragThreshold,this.functions.onDrag){if(!this.moved)return;if(e.shmi&&e.shmi.listeners)for(var t=e.shmi.listeners.pop();void 0!==t;)t.mouseUp(e),t=e.shmi.listeners.pop();if(this.functions.onDrag(this.dx,this.dy,e),window.navigator.msPointerEnabled)try{e.target.setPointerCapture(e.pointerId)}catch(t){try{e.target.msSetPointerCapture(e.pointerId)}catch(e){shmi.log("Error - Could not set pointer capture of event: "+e,2)}}else null===this.moveDiv&&(this.moveDiv=document.createElement("div"),this.moveDiv.setAttribute("class","mouselistener-overlay"),window.navigator.msPointerEnabled?(this.element.removeEventListener("MSPointerOut",this.mouseout),document.body.appendChild(this.moveDiv),this.moveDiv.addEventListener("MSPointerMove",this.mousemove),this.moveDiv.addEventListener("MSPointerUp",this.mouseup)):(this.element.removeEventListener("mouseout",this.mouseout),document.body.appendChild(this.moveDiv),this.moveDiv.addEventListener("mousemove",this.mousemove),this.moveDiv.addEventListener("mouseup",this.mouseup),this.moveDiv.addEventListener("mouseout",this.mouseout)));e.stopPropagation()}else e.shmi=e.shmi||{},e.shmi.listeners=e.shmi.listeners||[],e.shmi.listeners.push(this)},mouseOver:function(e){this._inactiveReset(),isTouchMode(e)||shmi.testParentChild(this.element,e.relatedTarget)||(this.functions.onRelease&&this.mousepressed&&this.functions.onRelease(e.clientX,e.clientY,e),this.mousepressed=!1,this.functions.onEnter&&this.functions.onEnter())},mouseOut:function(e,t){if(this._inactiveReset(),!isTouchMode(e)){if(shmi.testParentChild(this.element,e.relatedTarget)){if(!t)return}else if(this.moveDiv){var s=e.srcElement||e.originalTarget;if(this.moveDiv!==s)return}this.functions.onRelease&&this.mousepressed&&this.functions.onRelease(e.clientX,e.clientY,e),this.mousepressed=!1,this.moveDiv&&(this.moveDiv.removeEventListener("mousemove",this.mousemove),this.moveDiv.removeEventListener("mouseup",this.mouseup),this.moveDiv.removeEventListener("mouseout",this.mouseout),document.body.removeChild(this.moveDiv),this.moveDiv=null),this.functions.onLeave&&this.functions.onLeave()}},mouseWheel:function(e){this._inactiveReset(),isTouchMode(e)||(e.stopPropagation(),this.functions.onWheel&&("DOMMouseScroll"===e.type?this.functions.onWheel(-50*e.detail,e):this.functions.onWheel(e.wheelDelta,e)))}}}(),shmi.pkg("visuals.io"),shmi.visuals.io.ResourceLoader=function(){this.resources={},this.active=0},shmi.visuals.io.ResourceLoader.prototype={loadResource:function(e,t,s,n){this.resources[e]&&!s?this.addCallback(e,t):s?shmi.visuals.io.loadResourceHttp(e,(function(s,n){t(s,n,e)}),n):(this.active++,this.createResource(e),this.addCallback(e,t),shmi.visuals.io.loadResourceHttp(e,function(t,s){null===t&&(s=!0),this.resources[e].data=t,this.resources[e].failed=s,this.notifyCallbacks(e)}.bind(this),n))},loadResourcePromise:function(e,t,s){return new Promise(((n,a)=>{shmi.loadResource(e,((t,s)=>{if(s){const s=new Error(`Failed to load resource from ${e}`);s.url=e,s.requestData=t,a(s)}else n(t)}),!!t,!!s)}))},notifyCallbacks:function(e){var t=this.resources[e];t&&Array.isArray(t.callbacks)&&(t.callbacks.forEach((function(s){"function"==typeof s&&s(t.data,t.failed,e)})),t.callbacks=[])},createResource:function(e){this.resources[e]={},this.resources[e].data=null,this.resources[e].failed=!1,this.resources[e].callbacks=[]},addCallback:function(e,t){null!==this.resources[e].data||this.resources[e].failed?t(this.resources[e].data,this.resources[e].failed,e):this.resources[e].callbacks.push(t)}},function(){function broadcastEvent(e,t,s){e.eventsEnabled&&shmi.fire(t,s,e)}function onSocketOpen(e){shmi.log("[SocketConnection] On Open",0);const t={observerAllowed:!1,Host:{}};e.connecting=!1,e.connected=!0,e.connectSession.request("connect.info",{},(function(s,n){if(0!==n)return broadcastEvent(e,"session-data-update",{error:n}),void(e.connectCallback&&(shmi.log("[SocketConnection] Connect Callback",0),e.connectCallback(shmi.c("FAIL"))));t.Host.name=s.hostname,t.Host.version=s.version,void 0===s.version.patch&&(t.Host.version.patch=s.version.revision),t.project=s.current_project,e.connectSession.request("util.islocal",{},(function(s,n){n&&console.warn("[SocketConnection]","unable to check whether client is on local network interface"),t.observerAllowed=!0===s,e.sessionInfo=t,broadcastEvent(e,"connection-state",{established:!0,url:e.url,error:null,connecting:!1}),broadcastEvent(e,"session-data-update",t),e.connectCallback&&(shmi.log("[SocketConnection] Connect Callback",0),e.connectCallback(shmi.c("SUCCESS")))}))}))}function onSocketMessage(e,t){e.debugCallback&&e.debugCallback(t.data),e.connectSession.postMessage(JSON.parse(t.data))}function onSocketClose(e){shmi.log("[SocketConnection] connection closed (URL: '"+e.url+"')",2),e.connected=!1,broadcastEvent(e,"connection-state",{established:!1,url:e.url,error:null,connecting:!1}),e.connect(e.connectCallback)}function onSocketError(e,t){shmi.log("[SocketConnection] connection error: "+t,2),console.log("ERROR Event:",t),broadcastEvent(e,"connection-state",{established:!1,url:e.url,error:t,connecting:!1})}shmi.pkg("visuals.io"),shmi.visuals.io.SocketConnection=function(e,t){this.socket=null,this.url=e,this.protocol="smarthmi-connect",this.connecting=!1,this.connected=!1,this.aksreconnect=!1,this.attempts=0,this.maxConnectionAttempts=parseInt(shmi.visuals.session.config["max-connection-attempts"])||shmi.c("DEFAULT_CONNECTION_ATTEMPTS"),this.connectCallback=null,this.debugCallback=null,this.msgHandlers={},this.timeout=parseInt(shmi.visuals.session.config["socket-timeout"])||shmi.c("DEFAULT_CONNECTION_TIMEOUT"),this.timeoutId=0,this.connectSession=t,this.eventsEnabled=!1},shmi.visuals.io.SocketConnection.prototype={constructor:shmi.visuals.io.SocketConnection,init:function(){this.socket.onopen=onSocketOpen.bind(null,this),this.socket.onmessage=onSocketMessage.bind(null,this),this.socket.onclose=onSocketClose.bind(null,this),this.socket.onerror=onSocketError.bind(null,this)},getSocket:function(){return this.socket},enableEvents:function(){this.eventsEnabled=!0},connect:function(e){var t=this;t.connectCallback=e;try{t.connected&&(shmi.log("[SocketConnection] socket already connected, disconnecting first ... ",2),t.socket.close())}catch(e){shmi.log("[SocketConnection] could not connect to socket")}if(t.connecting=!0,broadcastEvent(t,"connection-state",{established:!1,url:t.url,error:null,connecting:!0}),-1!==t.maxConnectionAttempts&&t.attempts>=t.maxConnectionAttempts)return broadcastEvent(t,"connection-failed",{socket:t,session:shmi.visuals.session}),void("function"==typeof e&&e(shmi.c("FAIL")));t.socket=new WebSocket(t.url,t.protocol),t.attempts++,shmi.log("[SocketConnection] Connecting...",2),t.init()},disconnect:function(){this.connected=!1,null!==this.socket&&this.socket.close(),this.socket=null},sendMessage:function(e){null!==this.socket?1===this.socket.readyState?(this.debugSendCallback&&this.debugSendCallback(e),this.socket.send(e)):shmi.log("[SocketConnection] EOS2 - state "+this.socket.readyState,0):shmi.log("[SocketConnection] EOS1 - state "+this,0)},isConnected:function(){return this.connected}}}(),function(){function getOffsetLeft(e){var t=0;do{isNaN(e.offsetLeft)||(t+=e.offsetLeft),e=e.offsetParent}while(e);return t}function getOffsetTop(e){var t=0;do{isNaN(e.offsetTop)||(t+=e.offsetTop),e=e.offsetParent}while(e);return t}function updateTimestamp(e){shmi.visuals.io.TouchListener.prototype.lastTimeStamp=e}shmi.pkg("visuals.io"),shmi.visuals.io.TouchListener=function(e,t,s,n){window.navigator.msPointerEnabled?this.inactive=!0:(this.element=e,this.touches={},this.last_click_time=0,this.double_click_time=500,this.moved=!1,this.functions=t,this.prevent_drag_scroll_x=!0,this.prevent_drag_scroll_y=!0,this.passive=void 0===s||!s,this.dragThreshold=n&&"number"==typeof n.dragThreshold?n.dragThreshold:shmi.c("MIN_MOVED_PX"),this.touchstart=this.touchStart.bind(this),this.touchend=this.touchEnd.bind(this),this.touchmove=this.touchMove.bind(this),this.touchcancel=this.touchCancel.bind(this),this.mouseover=function(){this.functions.onLeave&&(document.body.removeEventListener("mouseover",this.mouseover),this.functions.onLeave())}.bind(this),this._inactiveReset=function(){shmi.visuals.session.UserManager.resetInactivity()},this.init())},shmi.visuals.io.TouchListener.prototype={lastTimeStamp:0,init:function(){},disable:function(){this.inactive||(this.element.removeEventListener("touchstart",this.touchstart),this.element.removeEventListener("touchend",this.touchend),this.element.removeEventListener("touchcancel",this.touchend),this.element.removeEventListener("touchmove",this.touchmove))},enable:function(){this.inactive||(this.element.removeEventListener("touchstart",this.touchstart),this.element.addEventListener("touchstart",this.touchstart,{passive:this.passive}))},getNumberOfTouches:function(){var e=shmi.requires("visuals.tools.iterate").iterateObject,t=0;return e(this.touches,(function(e,s){t++})),t},touchStart:function(e){this._inactiveReset(),updateTimestamp(e.timeStamp);for(var t=0;t<e.changedTouches.length;t++)if(shmi.testParentChild(this.element,e.changedTouches[t].target)){var s=e.changedTouches[t],n=s.identifier;this.touches[n]={},this.touches[n].startPageX=s.pageX,this.touches[n].startPageY=s.pageY,this.touches[n].pageX=s.pageX,this.touches[n].pageY=s.pageY,this.touches[n].startX=s.clientX,this.touches[n].startY=s.clientY,this.touches[n].dx=0,this.touches[n].dy=0,this.touches[n].time=Date.now(),this.functions.onDrag&&this.cancelTimer(n),this.functions.onEnter&&(document.body.removeEventListener("mouseover",this.mouseover),document.body.addEventListener("mouseover",this.mouseover),e.preventDefault(),this.functions.onEnter()),this.functions.onPress&&!e.consumed&&(this.functions.onPress(this.touches[n].startX,this.touches[n].startY,e),e.consumed=!0)}this.functions.onDrag&&e.stopPropagation(),this.element.removeEventListener("touchend",this.touchend),this.element.removeEventListener("touchcancel",this.touchend),this.element.removeEventListener("touchmove",this.touchmove),this.element.addEventListener("touchend",this.touchend),this.element.addEventListener("touchcancel",this.touchend),this.element.addEventListener("touchmove",this.touchmove)},cancelTimer:function(e){void 0!==this.touches[e]&&(this.touches[e].checktime===this.touches[e].time?this.touchCancel({}):(this.touches[e].checktime=this.touches[e].time,setTimeout(function(){this.cancelTimer(e)}.bind(this),shmi.c("DRAG_TIMEOUT"))))},touchEnd:function(e){this._inactiveReset(),updateTimestamp(e.timeStamp);for(var t=0,s=0,n=0;n<e.changedTouches.length;n++)if(shmi.testParentChild(this.element,e.changedTouches[n].target)){var a=e.changedTouches[n].identifier;void 0!==this.touches[a]&&(t=this.touches[a].startX,s=this.touches[a].startY,this.functions.onRelease&&this.functions.onRelease(t,s,e),delete this.touches[a])}if(0===this.getNumberOfTouches()){if(!this.moved&&this.functions.onClick){if(!e.consumed)if(e.consumed=!0,this.functions.onDoubleClick){var r=Date.now();r-this.last_click_time<this.double_click_time?this.functions.onDoubleClick(t,s,e):(this.functions.onClick(t,s,e),this.last_click_time=r)}else this.functions.onClick(t,s,e);e.preventDefault()}this.element.removeEventListener("touchmove",this.touchmove),this.element.removeEventListener("touchend",this.touchend),this.element.removeEventListener("touchcancel",this.touchend),this.moved=!1}this.functions.onDrag&&e.stopPropagation()},touchCancel:function(e){var t=this,s=shmi.requires("visuals.tools.iterate").iterateObject;t._inactiveReset(),updateTimestamp(e.timeStamp),s(t.touches,(function(e,s){delete t.touches[s]})),t.functions.onRelease&&t.functions.onRelease(0,0,e),t.element.removeEventListener("touchmove",t.touchmove),t.element.removeEventListener("touchend",t.touchend),t.element.removeEventListener("touchcancel",t.touchend),t.moved=!1},touchMove:function(e){var t=this,s=shmi.requires("visuals.tools.iterate").iterateObject;if(t._inactiveReset(),updateTimestamp(e.timeStamp),1===t.getNumberOfTouches()){for(var n=0,a=0,r=0,o=0,l=0;l<e.changedTouches.length;l++)if(shmi.testParentChild(t.element,e.changedTouches[l].target)){var u=e.changedTouches[l],c=u.identifier;n=u.clientX-t.touches[c].startX,a=u.clientY-t.touches[c].startY,t.touches[c].startX=u.clientX,t.touches[c].startY=u.clientY,t.touches[c].time=Date.now(),void 0!==t.touches[c].totalDx?(t.touches[c].totalDx+=n,t.touches[c].totalDy+=a):(t.touches[c].totalDx=n,t.touches[c].totalDy=a),r=t.touches[c].totalDx,o=t.touches[c].totalDy;break}if(!(Math.abs(r)>=this.dragThreshold||Math.abs(o)>=this.dragThreshold))return t.functions.onDrag&&(Math.abs(r)>Math.abs(o)?t.prevent_drag_scroll_x&&(e.stopPropagation(),e.preventDefault()):t.prevent_drag_scroll_y&&(e.stopPropagation(),e.preventDefault())),void(t.moved=!1);t.moved=!0,t.functions.onDrag&&(e.stopPropagation(),t.functions.onDrag(n,a,e))}else t.moved=!0;if(2===t.getNumberOfTouches()){for(l=0;l<e.changedTouches.length;l++)shmi.testParentChild(t.element,e.changedTouches[l].target)&&(c=(u=e.changedTouches[l]).identifier,n=u.clientX-t.touches[c].startX,a=u.clientY-t.touches[c].startY,t.touches[c].startX=u.clientX,t.touches[c].startY=u.clientY,t.touches[c].pageDx=void 0===t.touches[c].pageX?u.pageX-t.touches[c].startPageX:u.pageX-t.touches[c].pageX,t.touches[c].pageDy=void 0===t.touches[c].pageY?u.pageY-t.touches[c].startPageY:u.pageY-t.touches[c].pageY,t.touches[c].pageX=u.pageX,t.touches[c].pageY=u.pageY,t.touches[c].dx=n,t.touches[c].dy=a,t.touches[c].time=Date.now());var m=[];if(s(t.touches,(function(e,t){var s={};s.x=e.startX-e.dx,s.y=e.startY-e.dy,m.push(s)})),s(t.touches,(function(e,t){var s={};s.x=e.startX,s.y=e.startY,m.push(s)})),t.functions.onRotate){e.preventDefault();var d=(m[0].x-m[1].x)/2,h=(m[0].y-m[1].y)/2,f=(m[2].x-m[3].x)/2,g=(m[2].y-m[3].y)/2,p=Math.atan2(g,f)-Math.atan2(h,d);t.functions.onRotate(p)}var v=[];if(s(t.touches,(function(e,s){v.push({x:e.startPageX-getOffsetLeft(t.element),y:e.startPageY-getOffsetTop(t.element)})})),s(t.touches,(function(e,s){v.push({x:e.pageX-getOffsetLeft(t.element),y:e.pageY-getOffsetTop(t.element)})})),t.functions.onScale){e.preventDefault();var b=Math.abs(v[0].x-v[1].x),y=Math.abs(v[0].y-v[1].y),w=Math.abs(v[2].x-v[3].x),_=Math.abs(v[2].y-v[3].y),T=0===b||b/y<.3?1:w/b,E=0===y||y/b<.3?1:_/y,A=Math.sqrt(Math.pow(v[0].x-v[1].x,2)+Math.pow(v[0].y-v[1].y,2)),C=Math.sqrt(Math.pow(v[2].x-v[3].x,2)+Math.pow(v[2].y-v[3].y,2))/A,k=(v[2].x+v[3].x)/2,I=(v[2].y+v[3].y)/2;t.functions.onScale(C,k,I,T,E,v)}}}}}(),shmi.pkg("visuals.gfx"),shmi.visuals.gfx.Animation=function(e,t,s){this.startValue=0,this.endValue=0,this.currentValue=0,this.animDuration=0,this.startTime=null,this.drawCallback=e,this.completeCallback=t,this.requestID=0,this.animate=!1,this.priority=!1,this.timer_func=void 0!==this.TIMERS[s]?this.TIMERS[s]:this.TIMERS.linear},shmi.visuals.gfx.Animation.prototype={TIMERS:{linear:function(e){return e},ease_in:function(e){return e*e*e},ease_out:function(e){return(e-1)*(e-1)*(e-1)+1},ease_in_out:function(e){return e<.5?4*e*e*e:(e-1)*(2*e-2)*(2*e-2)+1}},start:function(e,t){this.startValue=this.currentValue,this.endValue=e,void 0!==t&&(this.animDuration=t),this.animate=!0,this.startTime=null,this.requestID&&shmi.caf(this.requestID),this.requestID=shmi.raf(this.draw.bind(this),this.priority)},setCurrentValue:function(e){this.currentValue=e},draw:function(e){if(this.animate){if(null===this.startTime&&(this.startTime=e),this.animDuration){var t=this.endValue-this.startValue,s=e-this.startTime;s>this.animDuration&&(s=this.animDuration);var n=s/this.animDuration;n>1&&(n=1);var a=s/this.animDuration,r=t*this.timer_func(a);this.currentValue=this.startValue+r,t>=0?this.currentValue>=this.endValue&&(this.currentValue=this.endValue,this.animate=!1,this.startTime=null):this.currentValue<=this.endValue&&(this.currentValue=this.endValue,this.animate=!1,this.startTime=null),this.drawCallback(this.currentValue)}else this.currentValue=this.endValue,this.animate=!1,this.startTime=null,this.drawCallback(this.endValue);shmi.caf(this.requestID),this.requestID=shmi.raf(this.draw.bind(this),this.priority)}else this.completeCallback&&(this.completeCallback(),shmi.log("[Animation] complete callback called",0))},stop:function(){this.animate=!1}},function(){"use strict";shmi.pkg("visuals.gfx");const e={linear:e=>e,ease_in:e=>e*e*e,ease_out:e=>(e-1)*(e-1)*(e-1)+1,ease_in_out:e=>e<.5?4*e*e*e:(e-1)*(2*e-2)*(2*e-2)+1},t="linear";function getTimerFunction(t){const s=e[t];if(!s)throw new Error(`Timer function "${t}" does not exist.`);return s}class AlphaTransition{constructor(e=null,s=t){this._initialValue=e,this._currentValue=e,this._targetValue=null,this._startTime=null,this._currentTime=null,this._duration=0,this._timerFunc=getTimerFunction(s)}start(e,t,s){this.isDone()&&(this._currentTime=null),s&&(this._timerFunc=getTimerFunction(s)),null===this._currentValue&&(this._currentValue=e),this._initialValue=this._currentValue,this._startTime=this._currentTime,this._targetValue=e,this._duration=t}startFrom(e,t,s,n){this._currentValue=e,this.start(t,s,n)}cancel(){this._duration=0,this._targetValue=this._currentValue}update(e){if(this.isDone())return;this._startTime||(this._startTime=e);const t=Math.min(Math.max(0,(e-this._startTime)/this._duration),1),s=this._timerFunc(t),n=this._initialValue+(this._targetValue-this._initialValue)*s;this._currentValue=isNaN(n)?this._targetValue:n,this._currentTime=e}isDone(){return this._currentValue===this._targetValue}getValue(){return this._currentValue}}function allAnimationsDone(e){for(const t in e._animations)if(!e._animations[t].isDone())return!1;return!0}function onDraw(e,t){const s={};for(const n in e._animations){const a=e._animations[n];a.update(t),s[n]=a.getValue()}e._raf=null,queueAnimationFrame(e),e._animationCallback(Object.freeze(s)),e._completeCallback&&allAnimationsDone(e)&&e._completeCallback()}function queueAnimationFrame(e,t=!1){e._raf||!t&&allAnimationsDone(e)||(e._raf=shmi.raf(onDraw.bind(null,e)))}function getAnimation(e,t){let s=e._animations[t];return s||(s=new AlphaTransition,e._animations[t]=s),s}shmi.visuals.gfx.AnimationBundle=class AnimationBundle{constructor(e,t=null){shmi.checkArg("animationCallback",e,"function"),shmi.checkArg("completeCallback",t,"function","null"),this._animations={},this._animationCallback=e,this._completeCallback=t,this._raf=null}static registerTimerFunction(t,s){if(shmi.checkArg("functionName",t,"string"),shmi.checkArg("timerFunc",s,"function"),shmi.objectHasOwnProperty(e,t))throw new Error(`Timer with name ${t} has already been registered`);e[t]=s}static timerFunctionExists(t){return shmi.objectHasOwnProperty(e,t)}static timerFunctions(){return Object.keys(e)}prepare(e,s=null,n=t){if(shmi.checkArg("animationName",e,"string"),shmi.checkArg("initialValue",s,"number","null"),shmi.checkArg("timingMode",n,"string"),this._animations[e])throw new Error(`Animation with name ${e} already exists`);this._animations[e]=new AlphaTransition(s,n)}start(e,t,s="default",n=null){shmi.checkArg("targetValue",e,"number"),shmi.checkArg("duration",t,"number"),shmi.checkArg("animationName",s,"string"),shmi.checkArg("timingMode",n,"string","null"),getAnimation(this,s).start(e,t,n),queueAnimationFrame(this,!0)}startFrom(e,t,s,n="default",a=null){shmi.checkArg("startValue",e,"number"),shmi.checkArg("targetValue",t,"number"),shmi.checkArg("duration",s,"number"),shmi.checkArg("animationName",n,"string"),shmi.checkArg("timingMode",a,"string","null"),getAnimation(this,n).startFrom(e,t,s,a),queueAnimationFrame(this,!0)}cancel(e="default",t=!1){shmi.checkArg("animationName",e,"string"),shmi.checkArg("deleteAnimation",t,"boolean"),this._animations[e]&&(t?delete this._animations[e]:this._animations[e].cancel(),this._raf&&allAnimationsDone(this)&&(shmi.caf(this._raf),this._raf=null))}refresh(){queueAnimationFrame(this,!0)}getValues(){const e={};for(const t in this._animations)e[t]=this._animations[t].getValue();return Object.freeze(e)}}}(),shmi.pkg("visuals.gfx"),shmi.visuals.gfx.Movable=function(e,t){this.el=e,this.transitionStyle="all .25s",this.s=t&&"number"==typeof t.scale?t.scale:1,this.sx=t&&"number"==typeof t.scaleX?t.scaleX:1,this.sy=t&&"number"==typeof t.scaleY?t.scaleY:1,this.startX=0,this.startY=0,this.rotatable=!0,this.scalable=!0,this.tx=t&&"number"==typeof t.translateX?t.translateX:0,this.ty=t&&"number"==typeof t.translateY?t.translateY:0,this.rot=0,this.max_s=1.5,this.min_s=.5,this.transition=!1,this.tfComplete=!1,this.requestID=0,this.priority=!1,this.tf="scale(1.0) translate(0px, 0px) rotate(0deg)",this.draw()},shmi.visuals.gfx.Movable.prototype={rotate:function(e){this.rot+=e,this.update()},translate:function(e,t){this.tx+=e,this.ty+=t,this.update()},scale:function(e){this.s*=e,this.s<this.min_s?this.s=this.min_s:this.s>this.max_s&&(this.s=this.max_s),this.sx*=e,this.sx<this.min_s?this.sx=this.min_s:this.sx>this.max_s&&(this.sx=this.max_s,this.sy*=e),this.sy<this.min_s?this.sy=this.min_s:this.sy>this.max_s&&(this.sy=this.max_s),this.update()},draw:function(){this.tfComplete?(this.tf=`scale3d(${this.sx.toFixed(3)}, ${this.sy.toFixed(3)}, 1) rotate3d(0,0,1,${this.rot.toFixed(3)}deg)`,this.el.style.transform=this.tf,this.startX=this.startX+this.tx,this.startY=this.startY+this.ty,this.tx=0,this.ty=0,this.tfComplete=!1):(this.updateTransform(),this.el.style.transform=this.tf)},update:function(){this.requestID&&shmi.caf(this.requestID),this.requestID=shmi.raf(this.draw.bind(this),this.priority)},updateTransform:function(){this.tf=`translate3d(${this.tx.toFixed(0)}px, ${this.ty.toFixed(0)}px, 0px)`,this.scalable&&(this.tf+=` scale3d(${this.sx.toFixed(3)}, ${this.sy.toFixed(3)}, 1)`),this.rotatable&&(this.tf+=` rotate3d(0,0,1,${this.rot.toFixed(0)}deg)`)},setTransition:function(e){this.transition=e,this.transition?this.el.style.transition=this.transitionStyle:this.el.style.transition=""},completeTransform:function(){this.tfComplete=!0,this.update()},forceAccOff:function(){this.draw()}},Function.prototype.bind||(Function.prototype.bind=function(e){if("function"!=typeof this)throw new TypeError("Function.prototype.bind - what is trying to be bound is not callable");var t=Array.prototype.slice.call(arguments,1),s=this,fNOP=function(){},fBound=function(){return s.apply(this instanceof fNOP&&e?this:e,t.concat(Array.prototype.slice.call(arguments)))};return fNOP.prototype=this.prototype,fBound.prototype=new fNOP,fBound}),document.documentElement.addEventListener("MSHoldVisual",(function(e){e.preventDefault()}),!1),shmi.c("MIN_CONNECT_VERSION",.921),shmi.c("DEFAULT_CONNECTION_TIMEOUT",-1),shmi.c("DEFAULT_CONNECTION_ATTEMPTS",1),shmi.c("DEFAULT_VIEW","View1"),shmi.c("DEFAULT_QUERY_RESULTS",4096),shmi.c("DB_CFG_RO",0),shmi.c("DB_CFG_RW",1),shmi.c("DB_HMI_RO",2),shmi.c("DB_HMI_RW",3),shmi.c("DB_USR_RO",4),shmi.c("DB_USR_RW",5),shmi.c("DB_CUSTOM_RO",6),shmi.c("DB_CUSTOM_RW",7),shmi.c("TEMPLATE_PATH","templates/"),shmi.c("TEMPLATE_EXT",".html"),shmi.c("CONFIG_PATH","json/"),shmi.c("CONFIG_EXT",".json"),shmi.c("APP_CONFIG_PATH","json/project.json"),shmi.c("GROUP_CONFIG_PATH","json/groups/config.json"),shmi.c("LOCALE_INDEX_PATH","json/locale/index.json"),shmi.c("LOCALE_PATH_PATTERN","json/locale/lang/<%= index %>.json"),shmi.c("KEYBOARD_PATH_PATTERN","json/locale/keyboard/<%= index %>.json"),shmi.c("MEDIA_QUERIES_CONFIG_PATH","json/media-queries.json"),shmi.c("SYS_CONTROLS_CONFIG_PATH","json/sys-config/sys-controls.json"),shmi.c("SYS_HANDLERS_CONFIG_PATH","json/sys-config/sys-handlers.json"),shmi.c("VIRTUAL_ITEMS_CONFIG_PATH","json/virtual-items.json"),shmi.c("DGM_GRID_MAP_PATH","json/grids/grid_map.json"),shmi.c("GRID_PATH_PATTERN","json/grids/<%= name %>.json"),shmi.c("UNITCLASS_CONFIG_PATH","json/unit-classes.json"),shmi.c("LOAD_TIMEOUT",350),shmi.c("DECOUPLE_TIMEOUT",50),shmi.c("ACTION_RETRY_TIMEOUT",150),shmi.c("DRAG_TIMEOUT",1e3),shmi.c("SUCCESS",0),shmi.c("FAIL",1),shmi.c("MIN_UPDATE_INTERVAL",9),shmi.c("RAF_FALLBACK_TIMEOUT",33),shmi.c("CHECK_INIT_INTERVAL",100),shmi.c("LOG_DEBUG",0),shmi.c("LOG_INFO",1),shmi.c("LOG_MSG",2),shmi.c("LOG_ERROR",3),shmi.c("TYPE_STRING",0),shmi.c("TYPE_BOOL",1),shmi.c("TYPE_INT",2),shmi.c("TYPE_FLOAT",3),shmi.c("DEFAULT_PAGE_SIZE",25),shmi.c("CSS_CONTROL_CLASS","ctrl"),shmi.c("NAME_SUFFIX","_"),shmi.c("MIN_MOVED_PX",15),shmi.c("RES_URL_PREFIX","res://"),shmi.c("DATAGRID_DB2_WRITE_DELAY",250),shmi.c("DEFAULT_LAYOUT_URL","layouts/default.html"),shmi.c("SERVER_TIME_ITEM","Systemzeit"),shmi.c("ALT_SERVER_TIME_ITEM","SYS_TIME"),shmi.c("MIN_PASSWORD_LENGTH",3),shmi.pkg("visuals.session"),shmi.visuals.session.GfxState={},shmi.visuals.session.GfxState.logAnimFallback=!0,shmi.visuals.session.GfxState.drawRequests={},shmi.visuals.session.GfxState.priorityRequests={},shmi.visuals.session.GfxState.drawId=1,shmi.visuals.session.GfxState.sysDrawId=1,shmi.visuals.session.GfxState.lastDrawTime=-1,shmi.pkg("visuals.gfx"),shmi.visuals.gfx.requestAnimFrame=function(e,t){var s=shmi.visuals.session.GfxState,n=s.drawId++;return t?s.priorityRequests[n]=e:s.drawRequests[n]=e,shmi.visuals.gfx.cancelAnimFrameImpl(s.sysDrawId),s.sysDrawId=shmi.visuals.gfx.requestAnimFrameImpl(shmi.visuals.gfx.drawAnimFrames),n},shmi.raf=shmi.visuals.gfx.requestAnimFrame,shmi.visuals.gfx.cancelAnimFrame=function(e){void 0!==shmi.visuals.session.GfxState.drawRequests[e]&&delete shmi.visuals.session.GfxState.drawRequests[e]},shmi.caf=shmi.visuals.gfx.cancelAnimFrame,shmi.visuals.gfx.drawAnimFrames=function(e){const t=shmi.visuals.session.GfxState,s=Object.values(t.priorityRequests);if(s.length)t.priorityRequests={},s.forEach((t=>{try{t(e)}catch(e){console.error("[Compatibility] PRIO - could not call animation frame request:",e)}})),t.sysDrawId=shmi.visuals.gfx.requestAnimFrameImpl(shmi.visuals.gfx.drawAnimFrames);else{const s=Object.values(t.drawRequests);t.drawRequests={},s.forEach((t=>{try{t(e)}catch(e){console.error("[Compatibility] could not call animation frame request:",e)}}))}},shmi.visuals.gfx.requestAnimFrameImpl=(window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(e){return shmi.visuals.session.GfxState.logAnimFallback&&(shmi.visuals.session.GfxState.logAnimFallback=!1,shmi.log("[Compatibility] -- requestAnimationFrame not available, using fallback --",2)),setTimeout((function(){e(Date.now()+shmi.c("RAF_FALLBACK_TIMEOUT"))}),1)}).bind(window),shmi.visuals.gfx.cancelAnimFrameImpl=(window.cancelAnimationFrame||window.mozCancelAnimationFrame||window.webkitCancelAnimationFrame||function(e){clearTimeout(e)}).bind(window),shmi.pkg("visuals.io"),shmi.visuals.io.loadResourceHttp=function(e,t,s,n){!0!==n&&(n=!1);const a=new XMLHttpRequest;try{if("file:"===window.location.protocol){0===e.indexOf("./")&&(e=e.replace("./",""));const t=window.location.pathname,s=t.substring(0,t.lastIndexOf("/"));e="file://"+s+"/"+e,shmi.visuals.session.config&&shmi.visuals.session.config.debug&&console.debug("[Compatibility] open file-system path: "+e)}a.open("GET",e,!n),!0===s&&(a.responseType="arraybuffer")}catch(e){shmi.log("[ResourceLoader] Exception during GET request.",3)}a.onreadystatechange=function(){4===a.readyState&&200===a.status?t(!0===s?a.response:a.responseText,!1,e):4===a.readyState&&0===a.status?(shmi.visuals.session.config&&shmi.visuals.session.config.debug&&console.log("[ResourceLoader] local request '"+e+"' returned, Status: "+a.status),t(!0===s?a.response:a.responseText,!1,e)):4===a.readyState&&(shmi.visuals.session.config&&shmi.visuals.session.config.debug&&console.log("[ResourceLoader] Request '"+e+"' failed, Status: "+a.status),t("",!0,e))};try{a.send()}catch(e){shmi.log("[ResourceLoader] exception during get request: "+e,2),t("",!0)}},shmi.pkg("visuals.session"),function(){var e=shmi.pkg("visuals.session.ParserState");e.controlTypes=[],e.containerTypes=[]}(),shmi.visuals.session.msgHandlers={},shmi.visuals.session.Layout=shmi.visuals.session.Layout||{},function(){for(var e=0;e<shmi.visuals.session.ParserState.controlTypes.length;e++)shmi.visuals.session.Layout[shmi.visuals.session.ParserState.controlTypes[e][0]]=new Array}(),function(){for(var e in shmi.visuals.controls)if(e.charAt(0)===e.charAt(0).toUpperCase()&&void 0!==shmi.visuals.controls[e].prototype&&(shmi.log("[Parser] is control class: "+e,1),void 0!==shmi.visuals.controls[e].prototype.uiType)){var t=shmi.visuals.controls[e].prototype.uiType;shmi.log("  ui-type: "+shmi.visuals.controls[e].prototype.uiType,1);var s=!1;!0===shmi.visuals.controls[e].prototype.isContainer&&(s=!0,shmi.log("  is ui-container",1)),shmi.registerControlType(t,shmi.visuals.controls[e],s)}}(),shmi.pkg("visuals.parser"),function(){function getDefaultConfig(e,t){var s=shmi.pkg("visuals.default.ControlConfig"),n=shmi.requires("visuals.tools.iterate.iterateObject"),a={};return s[e]&&(console.debug("[visuals.parser]","applying default config",e,t),n(s[e].config,(function(e,t){a[t]=e})),s[e].variants&&s[e].variants[t]&&n(s[e].variants[t],(function(e,t){a[t]=e}))),a}shmi.visuals.parser.getDefaultConfig=getDefaultConfig,shmi.visuals.parser.parseControls=function(e,t,s){e||(e=document.body,shmi.log("[Parser] BASE DOCUMENT.BODY",0));const n=shmi.requires("visuals.model"),a=[],r=shmi.visuals.session,o=r.ParserState.controlTypes,l={};o.forEach((e=>{l[e[0]]=e[1]}));const u=[...e.querySelectorAll("[data-ui]")];let c=[],m=null;return c=u.map((e=>({element:e,ui:e.getAttribute("data-ui")}))),c=c.filter((e=>e.ui&&l[e.ui])),c=c.filter((t=>function testBase(e,t){for(;e.parentNode&&e.parentNode!==t&&!e.parentNode.getAttribute("data-ui");)e=e.parentNode;return!(!e.parentNode||e.parentNode!==t)}(t.element,e))),c.forEach((e=>{const s=e.element.getAttribute("_nodeid");let o=null;if(s){const t=n.getConfig(s);delete t["config-name"],o=new l[e.ui](e.element,Object.assign({},getDefaultConfig(e.ui),t))}else o=new l[e.ui](e.element,getDefaultConfig(e.ui));null===m&&(m={element:shmi.getParentContainerElement(e.element),control:null},!t&&m.element&&(m.control=shmi.getControlByElement(m.element))),o.uiType=e.ui,o.parentContainer=m.control,r.Layout[e.ui].push(o),t&&(r.Layout.topLevel=r.Layout.topLevel||[],r.Layout.topLevel.push(o)),o.fire("register",{}),a.push(o)})),t&&a.forEach((e=>{e.enable()})),a}}(),shmi.parseControls=shmi.visuals.parser.parseControls,shmi.visuals.parser.parseProject=function(e){for(var t in shmi.visuals.session.locale.VisualsVersion=shmi.visuals.Version,shmi.visuals.session.Layout)for(;shmi.visuals.session.Layout[t].pop();)shmi.log("Clear shmi.visuals.session.Layout",1);return shmi.visuals.parser.parseControls(null,!0,null)},function(){const e=shmi.pkg("visuals.model");let t={},s=null;function mapNode(e){"string"==typeof e.id&&(t[e.id]=e,Array.isArray(e.children)&&e.children.forEach((function(e){mapNode(e)})))}function mapTemplate(e){e.forEach((function(e){mapNode(e)}))}function generateElement(e){const t=shmi.requires("visuals.tools.iterate.iterateObject");let s=null;return e.type===Node.TEXT_NODE?s=document.createTextNode(e.value):e.type===Node.COMMENT_NODE?s=document.createComment(e.value):e.type===Node.ELEMENT_NODE&&(s=document.createElement(e.tagName),t(e.attributes,(function(e,t){"data-config-name"!==t&&s.setAttribute(t,e)})),e.children.forEach((e=>{const t=generateElement(e);t&&s.appendChild(t)}))),s}e.parse=n=>(s=JSON.parse(n),t={},Object.keys(s.templates).forEach((t=>{mapTemplate(s.templates[t]),function putResource(e,t){const s=shmi.requires("visuals.session.ResourceLoader");void 0!==s.resources[t]?(s.resources[t].data=e,s.resources[t].failed=!1,Array.isArray(s.resources[t].callbacks)||(s.resources[t].callbacks=[]),s.notifyCallbacks(t)):s.resources[t]={data:e,failed:!1,callbacks:[]}}(e.generateTemplate(s.templates[t]),`res://${t}/template`)})),t),e.getConfig=e=>{const s=t[e];return s?s.parentGroupId?shmi.cloneObject(s.controlConfig):s.controlConfig:{}},e.getModelData=()=>s,e.getNodeMap=()=>t,e.getTemplate=e=>{const t=shmi.requires("visuals.session.ResourceLoader");return void 0!==t.resources[`res://${e}/template`]?t.resources[`res://${e}/template`].data:null},e.generateTemplate=e=>{const t=document.createElement("DIV");return Array.isArray(e)?e.forEach((function(e){const s=generateElement(e);t.appendChild(s)})):t.appendChild(generateElement(e)),t.innerHTML}}(),shmi.pkg("visuals.init"),shmi.visuals.init.initVItems=function(e){e&&Array.isArray(e.items)&&e.items.forEach((e=>{e.name=`virtual:${e.name}`,shmi.createVirtualItem(e)}))},shmi.visuals.defaultClient={run:function(e){var t=shmi.getUiElement("login");if(t){var s=shmi.requires("visuals.session.SysControlConfig");shmi.createControl(s.startupLogin.ui||"login",t,s.startupLogin,"DIV","from").enable()}else console.error("entrypoint contains no login control, aborting")}},shmi.visuals.init.onDgmReady=function(e){var t=shmi.requires("visuals.session");if(t.config&&t.config.debug&&console.log("=== DataGridManager initialized ==="),t.isReady=!0,shmi.fire("visuals-session-ready",{config:t.config},t),!0!==t.config["disable-app-layer"]){"string"!=typeof t.config["session-client"]&&(t.config["session-client"]="visuals.defaultClient");var s=t.config["session-client"];shmi.requires(s).run(t)}},function(){function initSession(e){shmi.requires("visuals.core.ItemManager"),shmi.requires("visuals.core.UserManager"),shmi.requires("visuals.core.QueryManager"),shmi.requires("visuals.core.AlarmManager"),shmi.requires("visuals.core.DataGridManager"),shmi.requires("visuals.core.RecipeManager"),shmi.requires("visuals.core.ConnectSession"),shmi.requires("visuals.core.EnvironmentManager"),shmi.requires("visuals.io.SocketConnection");var t=shmi.requires("visuals.tools.iterate.iterateObject"),s=shmi.visuals.session;if(s.config=s.config||{},t(e,(function(e,t){s.config[t]=e})),s.config.keyboard&&s.config.keyboard.enabled&&(s.config.keyboard.enabled=![/android/i,/ipad/i,/iphone/i].some((e=>e.test(navigator.userAgent)))),shmi.def(s.config,"loglevel",2),shmi.def(s.config,"alertlevel",3),void 0===s.config["ws-url"]){var n=0===window.location.href.indexOf("https"),a=window.location.hostname,r=parseInt(window.location.port);void 0!==window.location.port&&""!==window.location.port||(r=n?443:80);var o="ws";n&&(o+="s"),o+="://"+a+":"+r+window.location.pathname,s.config["ws-url"]=o}else 0===window.location.href.indexOf("https")&&(s.config["ws-url"]=s.config["ws-url"].replace("ws://","wss://"));s.Host={version:{major:1,minor:0,patch:0}},s.ConnectSession=new shmi.visuals.core.ConnectSession(s.config["ws-url"]),s.SocketConnection=s.ConnectSession.socket,function setupConnectSession(e,t){t.socket.enableEvents(),shmi.listen("session-data-update",(function(t){t.detail.error?shmi.notify("Error requesting host information:"+t.detail.error.message,"${V_ERROR}"):(e.Host=t.detail.Host||e.Host,e.observerAllowed=t.detail.observerAllowed||e.observerAllowed,e.project=t.detail.project)}),{source:t.socket}),shmi.listen("connection-state",(function(t){Object.values(e.ItemManager.items).forEach((e=>{e.name.startsWith("virtual:")?(e.writable=!1,e.notifyLockStatus()):shmi.log("[SocketConnection] keeping local item '"+e.name+"' accessible",0)}))}),{"detail.established":!1,"detail.connecting":!1,source:t.socket})}(s,s.ConnectSession),shmi.sendMessage=s.SocketConnection.sendMessage.bind(s.SocketConnection),shmi.registerMsgHandler=s.ConnectSession.registerMessageHandler.bind(s.ConnectSession),shmi.unregisterMsgHandler=s.ConnectSession.unregisterMessageHandler.bind(s.ConnectSession),s.URLParameters=function getUrlParams(){for(var e=new URL(window.location.href).searchParams.entries(),t=e.next(),s={};!t.done;)s[t.value[0]]=t.value[1],t=e.next();return s}(),s.ItemManager=new shmi.visuals.core.ItemManager,s.UserManager=new shmi.visuals.core.UserManager,s.QueryManager=new shmi.visuals.core.QueryManager,s.TrendManager=new shmi.visuals.core.TrendManager,s.TrendManager2=new shmi.visuals.core.TrendManager2,s.AlarmManager=new shmi.visuals.core.AlarmManager,s.DataGridManager=new shmi.visuals.core.DataGridManager,s.RecipeManager=new shmi.visuals.core.RecipeManager,s.FileManager=new shmi.visuals.core.FileManager,s.EnvironmentManager=new shmi.visuals.core.EnvironmentManager,s.observerAllowed=!1,s.FocusElement=null,shmi.loadResource(shmi.c("VIRTUAL_ITEMS_CONFIG_PATH"),(function(e,t,n){if(t?console.error("failed to load virtual-item config",n):shmi.visuals.init.initVItems(JSON.parse(e)),s.DataGridManager.initialized)shmi.visuals.init.onDgmReady();else var a=shmi.listen("datagrid-manager",(function(e){a.unlisten(),shmi.visuals.init.onDgmReady()}))}))}function startConfig(e,t){if(shmi.pkg("visuals.session.locale"),shmi.pkg("visuals.session.keyboards"),"string"==typeof e.title&&(document.title=shmi.localize(e.title)),t?(t=JSON.parse(t),shmi.visuals.session.localeInfo=t):(console.log("Locale index could not be loaded!"),window.location.reload()),!0!==e["disable-app-layer"]){!function registerControls(){shmi.requires("visuals.tools.iterate.iterateObject")(shmi.visuals.controls,(function(e,t){if(e.prototype){var s=e.prototype&&e.prototype.isContainer;shmi.registerControlType(e.prototype.uiType,shmi.visuals.controls[t],s)}}))}();var s={controls:shmi.c("SYS_CONTROLS_CONFIG_PATH"),handlers:shmi.c("SYS_HANDLERS_CONFIG_PATH"),locale:shmi.evalString(shmi.c("LOCALE_PATH_PATTERN"),{index:t.default})};t.keyboards&&Object.keys(t.keyboards).forEach((function(e){s["keyboard_"+e]=shmi.evalString(shmi.c("KEYBOARD_PATH_PATTERN"),{index:e})})),shmi.multiLoad(s,(function(s){s.controls=JSON.parse(s.controls),s.handlers=JSON.parse(s.handlers),s.locale=JSON.parse(s.locale),s.keyboards=s.keyboards||{},t.keyboards&&Object.keys(t.keyboards).forEach((function(e){var t="keyboard_"+e;s.keyboards[e]=JSON.parse(s[t]),delete s[t]})),function initSysData(e){var t=shmi.pkg("visuals.session.SysControlConfig"),s=shmi.requires("visuals.tools.iterate.iterateObject"),n=shmi.requires("visuals.session"),a=shmi.requires("visuals.session.locale"),r=shmi.requires("visuals.session.keyboards"),o=shmi.requires("visuals.init.defaults"),l=o.HANDLER_CONFIG,u=o.CONTROLS_CONFIG;Object.assign(t,e.controls),s(u,((e,s)=>{t[s]||(t[s]=e)})),n.handlers=[],l.forEach((t=>{if(!Array.isArray(e.handlers.disabled)||-1===e.handlers.disabled.indexOf(t))try{shmi.requires(t).register(),n.handlers.push(t)}catch(e){console.error(`Error registering system handler '${t}': ${e.toString()}`)}})),e.handlers.handlers=e.handlers.handlers.filter((e=>-1===l.indexOf(e))).filter((t=>!Array.isArray(e.handlers.disabled)||-1===e.handlers.disabled.indexOf(t))),e.handlers.handlers.forEach((e=>{try{shmi.requires(e).register(),n.handlers.push(e)}catch(t){console.error(`Error registering custom handler '${e}': ${t.toString()}`)}})),s(e.locale,(function(e,t){a[t]=e})),s(e.keyboards,(function(e,t){r[t]=e}))}(s);var n=function getControlTemplates(e){var t=[];return shmi.requires("visuals.tools.iterate.iterateObject")(e,(function(e,s){e.template&&t.push(shmi.c("TEMPLATE_PATH")+e.template+shmi.c("TEMPLATE_EXT")),e["content-template"]&&t.push(shmi.c("TEMPLATE_PATH")+e["content-template"]+shmi.c("TEMPLATE_EXT"))})),t}(s.controls);shmi.multiLoad(n,(function(){initSession(e)}))}))}else initSession(e)}function loadUnitClassConfig(e){var t=shmi.requires("visuals.tools.unitClasses"),s=shmi.c("UNITCLASS_CONFIG_PATH");shmi.loadResource(s,(function(n,a){a?console.error("[Init] failed to load unit-class configuration:",s):t.setUnitClassConfig(n),e()}))}shmi.visuals.init.startup=function(){var e={appCfg:shmi.c("APP_CONFIG_PATH"),localeIndex:shmi.c("LOCALE_INDEX_PATH"),groupConfig:shmi.c("GROUP_CONFIG_PATH")},t=null,s=shmi.requires("visuals.session"),n=s.ResourceLoader,a=shmi.requires("visuals.tools.iterate.iterateObject");shmi.multiLoad(e,(function(e){let r=null;t=function mergeAppConfig(e){var t={},s=shmi.requires("visuals.tools.iterate.iterateObject");return e.appCfg&&s(JSON.parse(e.appCfg),(function(e,s){t[s]=e})),t}(e);try{r=JSON.parse(e.groupConfig)}catch(e){console.error("failed to load groups config:",e)}r||(r={}),s.groupConfig=r,t["app-data"]?shmi.loadResource(t["app-data"],(function(s,r,o){if(r)console.error("failed to load",o);else{var l=JSON.parse(s);a(l,(function(e,t){n.resources[t]=e,n.resources[t].callbacks=[]})),loadUnitClassConfig(startConfig.bind(null,t,e.localeIndex))}})):loadUnitClassConfig(startConfig.bind(null,t,e.localeIndex))}))}}(),shmi.visuals.session.ResourceLoader=new shmi.visuals.io.ResourceLoader,shmi.loadResource=shmi.visuals.session.ResourceLoader.loadResource.bind(shmi.visuals.session.ResourceLoader),shmi.loadResourcePromise=shmi.visuals.session.ResourceLoader.loadResourcePromise.bind(shmi.visuals.session.ResourceLoader),window.addEventListener("load",shmi.visuals.init.startup),function(){var e=shmi.pkg("visuals.init.defaults");e.HANDLER_CONFIG=["visuals.handler.default.optionDialog","visuals.handler.default.cofirmation","visuals.handler.default.notification","visuals.handler.default.passwordExpired","visuals.handler.default.connectionFailed","visuals.handler.default.keyboard","visuals.handler.default.logout","visuals.handler.default.numpad"],e.CONTROLS_CONFIG={notificationDialog:{name:"notification-dialog",title:"${V_NOTIFICATION}",template:"default/sys-dialog/dialog-notification"},confirmDialog:{"class-name":"dialog-box confirm",title:"${V_CONFIRM_TITLE}",name:"visuals-confirm-dialog",template:"default/sys-dialog/dialog-confirm","cover-background":!0},optionDialog:{"class-name":"dialog-box option",title:"${V_OPTIONDIALOG_TITLE}",name:"visuals-option-dialog",template:"default/sys-dialog/dialog-option","cover-background":!0},askSaveDialog:{"class-name":"dialog-box ask-save",title:"${V_ASK_SAVE_TITLE}",name:"ask-save-dialog",template:"default/sys-dialog/dialog-ask-save","cover-background":!0},chooseFileDialog:{template:"default/sys-dialog/dialog-file"},passwordExpiredDialog:{"class-name":"dialog-box password-expired",name:"password-expired-dialog",template:"default/sys-dialog/dialog-password-expired",title:"${V_PASSWORD_EXPIRED_TITLE}","cover-background":!0},startupLogin:{"class-name":"login",template:"default/login",userEntry:'<div data-ui="user" class="user"><div class="userPic"></div><div class="user_detail"><h1 data-ui="user-name"><%= USER %></h1></div></div>'},loadingOverlay:{tagName:"DIV","class-name":"loading-box-overlay",template:null},threadsDialogCreate:{dialogTitle:"${threads.create.dialog.title}",dialogClassName:"dialog-box threads-dialog",dialogTemplate:"default/dialog-box",titleClassName:"iq-input-field iq-variant-02 title",titleTemplate:"default/iq-input-field.iq-variant-02",titleLabel:"${threads.create.title.label}",messageClassName:"iq-input-field iq-variant-02 message",messageTemplate:"default/iq-input-field.iq-variant-02",messageLabel:"${threads.create.message.label}",deleteClassName:"iq-button iq-variant-01 delete",deleteTemplate:"default/iq-button.iq-variant-01",deleteLabel:"",applyClassName:"iq-button iq-variant-01 apply",applyTemplate:"default/iq-button.iq-variant-01",applyLabel:"${threads.create.apply.label}",enterMessageNotification:"${threads.enterMessage.notification}"},threadsDialogEdit:{dialogTitle:"${threads.edit.dialog.title}",dialogClassName:"dialog-box threads-dialog",dialogTemplate:"default/dialog-box",titleClassName:"iq-input-field iq-variant-02 title",titleTemplate:"default/iq-input-field.iq-variant-02",titleLabel:"${threads.edit.title.label}",messageClassName:"iq-input-field iq-variant-02 message",messageTemplate:"default/iq-input-field.iq-variant-02",messageLabel:"${threads.edit.message.label}",deleteClassName:"iq-button iq-variant-01 delete",deleteTemplate:"default/iq-button.iq-variant-01",deleteLabel:"${threads.edit.delete.label}",deleteConfirmation:"${threads.edit.delete.confirmation}",applyClassName:"iq-button iq-variant-01 apply",applyTemplate:"default/iq-button.iq-variant-01",applyLabel:"${threads.edit.apply.label}",enterMessageNotification:"${threads.enterMessage.notification}"},trendSetsDialogCreate:{dialogClassName:"dialog-box trend-sets-dialog",dialogTemplate:"default/dialog-box",dialogTitle:"${ui-action.trend-set-create.dialog.title}",nameClassName:"iq-input-field iq-variant-02 title",nameTemplate:"default/iq-input-field.iq-variant-02",nameLabel:"${ui-action.trend-set-create.name.label}",cancelClassName:"iq-button iq-variant-01 cancel",cancelTemplate:"default/iq-button.iq-variant-01",cancelLabel:"${ui-action.trend-set-create.cancel.label}",applyClassName:"iq-button iq-variant-01 apply",applyTemplate:"default/iq-button.iq-variant-01",applyLabel:"${ui-action.trend-set-create.apply.label}",enterNameMessage:"${ui-action.trend-set-create.enterName.message}",enterNameTitle:"${ui-action.trend-set-create.enterName.title}",nameExistsMessage:"${ui-action.trend-set-create.nameExists.message}",nameExistsTitle:"${ui-action.trend-set-create.nameExists.title}"},trendSetsDialogEdit:{dialogClassName:"dialog-box trend-sets-dialog edit",dialogTemplate:"default/dialog-box",dialogTitle:"${ui-action.trend-set-rename.dialog.title}",nameClassName:"iq-input-field iq-variant-02 title",nameTemplate:"default/iq-input-field.iq-variant-02",nameLabel:"${ui-action.trend-set-rename.name.label}",cancelClassName:"iq-button iq-variant-01 cancel",cancelTemplate:"default/iq-button.iq-variant-01",cancelLabel:"${ui-action.trend-set-rename.cancel.label}",applyClassName:"iq-button iq-variant-01 apply",applyTemplate:"default/iq-button.iq-variant-01",applyLabel:"${ui-action.trend-set-rename.apply.label}",enterNameMessage:"${ui-action.trend-set-rename.enterName.message}",enterNameTitle:"${ui-action.trend-set-rename.enterName.title}",nameExistsMessage:"${ui-action.trend-set-rename.nameExists.message}",nameExistsTitle:"${ui-action.trend-set-rename.nameExists.title}"},trendExportDialog:{dialogClassName:"dialog-box trend-data-export",dialogTemplate:"default/dialog-box",dialogTitle:"${ui-action.trend-export.dialog.title}",startLabelClassName:"iq-label iq-variant-01 start-label",startLabelTemplate:"default/iq-label.iq-variant-01",startLabel:"${ui-action.trend-export.start.label}",startClassName:"iq-button iq-variant-02 date-time-selection",startTemplate:"default/iq-button.date-time-selection",endLabelClassName:"iq-label iq-variant-01 end-label",endLabelTemplate:"default/iq-label.iq-variant-01",endLabel:"${ui-action.trend-export.end.label}",endClassName:"iq-button iq-variant-02 date-time-selection",endTemplate:"default/iq-button.date-time-selection",applyClassName:"iq-button iq-variant-01 apply",applyTemplate:"default/iq-button.iq-variant-01",applyLabel:"${ui-action.trend-export.apply.label}",cancelClassName:"iq-button iq-variant-01 cancel",cancelTemplate:"default/iq-button.iq-variant-01",cancelLabel:"${ui-action.trend-export.cancel.label}",dateTimeFormat:"${iqtrend_timestamp_format}"},dateTimeDialog:{dialogClassName:"dialog-box date-time-selection",dialogTemplate:"default/dialog-box",dateLabelClassName:"iq-label date-label iq-variant-01",dateLabelTemplate:"default/iq-label.iq-variant-01",dateLabel:"${date-time-selection.date.label}",dateSelectClassName:"iq-select-date iq-variant-01 always-open",dateSelectTemplate:"default/iq-select-date.iq-variant-01",timeLabelClassName:"iq-label time-label iq-variant-01",timeLabelTemplate:"default/iq-label.iq-variant-01",timeLabel:"${date-time-selection.time.label}",timeSelectClassName:"iq-select-time iq-variant-01 iq-icon-variant-01",timeSelectTemplate:"default/iq-select-time.iq-variant-01",applyClassName:"iq-button iq-variant-01",applyTemplate:"default/iq-button.iq-variant-01",applyLabel:"${date-time-selection.apply.label}",cancelClassName:"iq-button iq-variant-01",cancelTemplate:"default/iq-button.iq-variant-01",cancelLabel:"${date-time-selection.cancel.label}"}}}(),function(){function instanceOfHelper(e,t){return t.some((function(t){var s=function resolveClassType(e){var t=window;return e.split(".").some((function(e){return!shmi.objectHasOwnProperty(t,e)||(t=t[e],!1)}))||"function"!=typeof t?null:t}(t);return s&&e instanceof s}))}shmi.pkg("visuals.tools.assert").checkArg=shmi.checkArg=function checkArg(e,t,s){var n,a,r=[],o=typeof t;for(n=2;n<arguments.length;++n)switch(arguments[n]){case"Object":case"Array":case"String":case"Number":r.push(arguments[n].toLowerCase());break;default:r.push(arguments[n])}if("number"!=typeof e&&"string"!=typeof e)throw TypeError("Invalid parameter name or parameter index");if("object"===o)if(null===t)o="null";else if(t.constructor)switch(a=Object.getPrototypeOf(t).constructor.name||"object"){case"Array":case"Object":o=a.toLowerCase();break;default:o=a}else o="object";if(-1===r.indexOf(o)&&-1===r.indexOf(typeof t)&&!instanceOfHelper(t,r))throw new TypeError(function makeErrorString(e,t,s){var n;return"number"==typeof e?n="Invalid type for parameter #"+String(e)+". ":"string"==typeof e&&(n='Invalid type for parameter "'+e+'". '),n+="Expected ",t.length>1?n+="one of ["+t.join(", ")+"]":n+=t[0],n+" but "+s+" given."}(e,r,o))}}(),function(){var e="visuals.tools.logging",t=shmi.pkg(e),s=getFLog(e),n={},a=20;function getFLog(e){return function(){for(var t="["+e+"]  ";t.length<a;)t+=" ";for(var s=[t],r=0;r<arguments.length;r++)s.push(arguments[r]);console.log.apply(console,s),void 0!==n[e]&&!0===n[e].record&&n[e].recordLog(s)}}function getErrorLog(e){return function(){for(var t="["+e+"]  ";t.length<a;)t+=" ";for(var s=[t],r=0;r<arguments.length;r++)s.push(arguments[r]);console.error.apply(console,s),void 0!==n[e]&&!0===n[e].record&&n[e].recordLog(s)}}function getWarnLog(e){return function(){for(var t="["+e+"]  ";t.length<a;)t+=" ";for(var s=[t],r=0;r<arguments.length;r++)s.push(arguments[r]);console.warn.apply(console,s),void 0!==n[e]&&!0===n[e].record&&n[e].recordLog(s)}}function getInfoLog(e){return function(){for(var t="["+e+"]  ";t.length<a;)t+=" ";for(var s=[t],r=0;r<arguments.length;r++)s.push(arguments[r]);console.info.apply(console,s),void 0!==n[e]&&!0===n[e].record&&n[e].recordLog(s)}}t.createLogger=function(t,s,a){if(shmi.objectHasOwnProperty(n,t))return n[t];var r=null;!0===a&&(r=[]);var o=getFLog(t),l=function getLog(e,t){return function(){!0===n[e].active&&t.apply(window,arguments)}}(t,o);return n[t]={log:l,error:getErrorLog(e),warn:getWarnLog(e),info:getInfoLog(e),fLog:o,active:!0===s,record:!0===a,getLog:function(){return r},recordLog:function(){r.push(arguments[0])}},n[t]},t.getLogger=function(e){return n[e]},t.getAllLoggers=function(){var e=shmi.requires("visuals.tools.iterate.iterateObject"),t=[];return e(n,(function(e,s){t.push(s)})),t},t.getActiveLoggers=function(){var e=shmi.requires("visuals.tools.iterate.iterateObject"),t=[];return e(n,(function(e,s){!0===e.active&&t.push(s)})),t},t.getRecordingLoggers=function(){var e=shmi.requires("visuals.tools.iterate.iterateObject"),t=[];return e(n,(function(e,s){!0===e.record&&t.push(s)})),t},t.enableLogger=function(e){n[e].active=!0},t.disableLogger=function(e){n[e].active=!1},s("module loaded")}(),function(){"use strict";var e="visuals.tools.enum",t=shmi.requires("visuals.tools.logging").createLogger(e,!1,!1),s=t.fLog;t.log;shmi.pkg(e).createEnum=function(e){if(!Array.isArray(e))throw new Error("argument has to be array of strings");var t={};return e.forEach((function(e,s){t[e]=s,t[s]=e})),t},s("module loaded")}(),(()=>{function isEqualDeepImpl(e,t,s=[]){if(e===t)return!0;if(typeof e!=typeof t||"object"!=typeof e)return!1;if(Array.isArray(e)!==Array.isArray(t))return!1;if(function isKnown(e,t,s){return-1!==s.findIndex((s=>e===s.lhs&&t===s.rhs))}(e,t,s))return!0;if(Array.isArray(e))return e.length===t.length&&(s.push({lhs:e,rhs:t}),e.every(((e,n)=>isEqualDeepImpl(e,t[n],s))));{const n=Object.keys(e);return!!function objectsHaveSameKeys(e,t){const s=Object.keys(e),n=Object.keys(t);return s.length===n.length&&s.every((e=>n.includes(e)))}(e,t)&&(s.push({lhs:e,rhs:t}),n.every((n=>isEqualDeepImpl(e[n],t[n],s))))}}shmi.pkg("visuals.tools.compare").isEqualDeep=function isEqualDeep(e,t){return isEqualDeepImpl(e,t,[])}})(),function(){const e="visuals.tools.global-events",t=shmi.requires("visuals.tools.logging").createLogger(e,!1,!1),s=t.fLog,n=t.log,a=shmi.pkg(e),r=shmi.pkg("visuals.session");r.Events=r.Events||{},shmi.fire=function fireFunc(e,t,a,o=!1){void 0===a&&(a=null);const{iterateObject:l}=shmi.visuals.tools.iterate,u={source:a,type:e,detail:t};function fireAway(){let t=0;return l(r.Events[e],(function(e){e(u)&&t++})),t}function logFired(e){!0===r.config.event_debug?s("[session] event",u,"fired [",e,"listeners]"):n("[session] event",u,"fired [",e,"listeners]")}if(function initEvent(e){r.Events||(n("init session events"),r.Events={}),r.Events[e]||(n("creating event type",e),r.Events[e]={})}(e),o)return shmi.decouple((()=>logFired(fireAway()))),0;const c=fireAway();return logFired(c),c},a.fire=shmi.fire,a.listen=shmi.listen,shmi.onSessionReady=function onSessionReady(e){let t=null;const s=shmi.getCancelable((()=>{t&&(t.unlisten(),t=null)}));return r.isReady?shmi.decouple((()=>{s.canceled||(s.complete(),e({source:r,type:"visuals-session-ready",detail:{config:r.config}}))})):t=shmi.listen("visuals-session-ready",(function(n){t.unlisten(),t=null,s.complete(),e(n)})),s.returnValue},a.onSessionReady=shmi.onSessionReady,s("module loaded")}(),function(){var e="visuals.tools.iterate",t=shmi.requires("visuals.tools.logging").createLogger(e,!1,!1),s=t.fLog,n=(t.log,shmi.pkg(e));n.iterateNodeList=function iterateNodeList(e,t){for(var s=0;s<e.length;s++)t(e[s],s,e)},n.iterateObject=function iterateObject(e,t){Object.keys(e||{}).forEach((s=>{shmi.objectHasOwnProperty(e,s)&&t(e[s],s,e)}))},s("module loaded")}(),function(){var e="visuals.tools.control-generator",t=shmi.requires("visuals.tools.logging").createLogger(e,!1,!1),s=t.fLog,n=(t.log,shmi.pkg(e));var a=shmi.pkg("visuals.controls");n.generate=function(e){a[e.className]=function makeConstructor(e){var t=shmi.requires("visuals.tools.iterate.iterateObject");return function(s,n){var a=this;if(!(s instanceof HTMLElement))throw new Error("base element must be instance of HTMLElement");a.element=s,a.config=n,a.parseAttributes(),a.imports={},t(e.imports,(function(e,t,s){if("string"==typeof e)a.imports[t]=shmi.requires(e);else{if("function"!=typeof e)throw new Error("import must either be a shmi-package name or a function returning a reference");a.imports[t]=e()}})),t(shmi.cloneObject(e.config),(function(e,t,s){shmi.def(a.config,t,e)})),!0===e.isContainer&&(a.controls=[]),a.vars=shmi.cloneObject(e.vars),a.startup()}}(e),a[e.className].prototype=function makePrototype(e){var t=shmi.requires("visuals.tools.iterate.iterateObject"),s=Object.create(shmi.visuals.core.BaseControl.prototype);return s.uiType=e.uiType,s.isContainer=e.isContainer,s.isContainer&&(s.containerProperties=e.containerProperties),s.events=shmi.cloneObject(shmi.visuals.core.BaseControl.prototype.events),Array.isArray(e.events)&&e.events.forEach((function(e,t){if(e in s.events)throw new Error("event type already defined: "+e);s.events.push(e)})),s.getClassName=function(){return e.className},t(e.prototypeExtensions,(function(e,t,n){s[t]=e})),s}(e),shmi.registerControlType(e.uiType,a[e.className],e.isContainer)},s("module loaded")}(),function(){var e="visuals.tools.lsdir",t=shmi.requires("visuals.tools.logging").createLogger(e,!1,!1),s=t.fLog,n=(t.log,shmi.pkg(e));n.ls=function ls(e,t){(0,shmi.requires("visuals.tools.connect").request)("fs.ls",[e],(function onRequest(e,s){s||e[0].error?t(s||e[0].error,null):t(0,e[0].listing)}))},shmi.lsdir=n.ls,s("module-loaded")}(),function(){var e="visuals.tools.item-adapter",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),s=t.fLog,n=(t.log,shmi.pkg(e)),a={};n.createAdapter=function(e){if("string"!=typeof e.name)throw new Error("adapter name has to be of type string");if("function"!=typeof e.inFunction)throw new Error("adapter inFunction has to be of type function");if("function"!=typeof e.outFunction)throw new Error("adapter outFunction has to be of type function");if(!Array.isArray(e.itemTypes))throw new Error("adapter itemTypes has to be an array");a[e.name]=e},n.setAdapter=function(e,t){var s=shmi.requires("visuals.session.ItemManager").getItem(e),n=a[t];if(!s)throw new Error("item '"+e+"' does not exist");if(!n)throw new Error("adapter '"+t+"' does not exist");if(!function isTypeCompatible(e,t){var s=!1;return t.itemTypes.forEach((function(t){e.type===shmi.c(t)&&(s=!0)})),s}(s,n))throw new Error("type of item '"+s.name+"' is not compatible with adapter '"+n.name+"'");s.adapter=n,s._updateValue=Math.random(),s.notifyLockStatus(),s.notifyUpdateTargets()},n.unsetAdapter=function(e){var t=shmi.requires("visuals.session.ItemManager").getItem(e);if(t){t.adapter=null,t._updateValue=Math.random();try{t.notifyLockStatus(),t.notifyUpdateTargets()}catch(e){console.error("exception clearing adapter:",e)}}else console.error("item '"+e+"' does not exist")},n.getAdapter=function(e){return a[e]?a[e]:null},n.getActiveAdapter=function(e){var t=shmi.requires("visuals.session.ItemManager").getItem(e),s=null;return t&&t.adapter&&(s=t.adapter),s},n.listAdapters=function(){s("loaded adapters:"),shmi.requires("visuals.tools.iterate.iterateObject")(a,(function(e,t){s(t,e.itemTypes.toString())})),s("--------")},s("module loaded")}(),function(){var e="visuals.tools.unitClasses",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),s=t.fLog,n=t.log,a=shmi.pkg(e),r="json/unit-classes.json",o=null,l=null,u={},c="virtual:num-unitclasses",m="virtual:unitclass-<%= UNITCLASS_ID %>-adapter",d=shmi.requires("visuals.tools.item-adapter"),h=shmi.requires("visuals.tools.iterate.iterateObject"),f=0;function unitClassDataLoaded(e,t){t?console.error("failed to load unit-class data from",r):(o=JSON.parse(e).unitClasses,console.debug("loaded unit-class data from",r),u={},f=0,function processUnitClassData(){o.forEach((function(e,t){void 0===u[e.unitClass]&&(u[e.unitClass]={name:e.name?e.name:null,unitClass:e.unitClass,adapters:[],selectedAdapter:null});var s=function makeAdapter(e){return{name:"item-adapter"+f++,unitText:e.unitText,inFunction:function(t){return parseFloat(((t-e.offset)/e.factor).toFixed(3))},outFunction:function(t){return parseFloat((t*e.factor+e.offset).toFixed(3))},itemTypes:["TYPE_FLOAT","TYPE_INT","TYPE_STRING"]}}(e);u[e.unitClass].adapters.push(s),d.createAdapter(s)})),n("created",f,"adapters")}())}function setUnitClassAdapter(e,t){const s=shmi.visuals.session.ItemManager,n=u[e];if(void 0===n)console.error("unitclass",e,"is not defined");else{const a=d.getAdapter(t);if(a){n.selectedAdapter=a,h(s.items,(function(s,n){s.unitClass===e&&(console.debug("setting item-adapter of",n,"to",t),d.setAdapter(n,t))}));const r=shmi.evalString(m,{UNITCLASS_ID:n.unitClass}),o=s.getItem(r);o&&o.initialized&&s.writeValue(r,n.adapters.indexOf(n.selectedAdapter))}else console.error("adapter",t,"is not defined")}}a.getUnitClasses=function(){var e=[];return h(u,(function(t){e.push(t)})),e},a.getUnitClassData=function(){return o},a.getUnitClassAdapters=function(e){return void 0!==u[e]?u[e].adapters:null},a.getSelectedAdapter=function(e){return void 0!==u[e]?u[e].selectedAdapter:null},a.setUnitClassAdapter=setUnitClassAdapter,a.setUnitClassConfig=function setUnitClassConfig(e){l=e},shmi.listen("visuals-session-ready",(function(t){l?unitClassDataLoaded(l,!1):console.error(e,"unit-class configuration not loaded!")})),shmi.listen("parser-ready",(function setupUnitClassItems(){var e=0;h(u,(function(t,s){t.adapters.length>0&&(null===t.selectedAdapter&&(t.selectedAdapter=d.getAdapter(t.adapters[0].name)),setUnitClassAdapter(t.unitClass,t.selectedAdapter.name),e++)})),h(u,(function(e,t){var s=shmi.evalString(m,{UNITCLASS_ID:e.unitClass}),n=e.adapters.indexOf(e.selectedAdapter);("number"!=typeof n||n<0)&&(n=0),shmi.createVirtualItem(s,shmi.c("TYPE_INT"),0,e.adapters.length-1,n,function getUnitClassSelectionCB(e){return function(t){console.debug("set unitclass",e.unitClass,"adapter to",e.adapters[t].name);const s=a.getSelectedAdapter(e.unitClass);(!s||e.adapters[t]&&s.name!==e.adapters[t].name)&&setUnitClassAdapter(e.unitClass,e.adapters[t].name)}}(e)).labelToken=e.name}));var t=shmi.createVirtualItem(c,shmi.c("TYPE_INT"),Number.NEGATIVE_INFINITY,Number.POSITIVE_INFINITY,e,null);t.writable=!1,t.notifyLockStatus()})),s("module loaded")}(),function(){var e="visuals.tools.date",t=shmi.requires("visuals.tools.logging").createLogger(e,!1,!1),s=t.fLog,n=(t.log,shmi.pkg(e)),a={dayShort:["${V_SUN_SHORT}","${V_MON_SHORT}","${V_TUE_SHORT}","${V_WED_SHORT}","${V_THU_SHORT}","${V_FRI_SHORT}","${V_SAT_SHORT}"],dayLong:["${V_SUN}","${V_MON}","${V_TUE}","${V_WED}","${V_THU}","${V_FRI}","${V_SAT}"],monthShort:["${V_JAN}","${V_FEB}","${V_MAR}","${V_APR}","${V_MAY}","${V_JUN}","${V_JUL}","${V_AUG}","${V_SEP}","${V_OCT}","${V_NOV}","${V_DEC}"]};function DateTimeBuffer(){this.reset()}DateTimeBuffer.prototype.reset=function reset(){this.millisecond=0,this.second=0,this.minute=0,this.hour=0,this.isPM=null,this.day=1,this.month=0,this.year=0,this.timestamp=null,this.timezone=0},DateTimeBuffer.prototype.assemble=function assemble(){if(null!==this.isPM&&this.hour>12)return null;if(null!==this.timestamp)return new Date(this.timestamp-6e4*this.timezone);var e=(!0===this.isPM?12:0)+this.hour;return new Date(Date.UTC(this.year,this.month,this.day,e,this.minute-this.timezone,this.second,this.millisecond))};var r={YYYY:{serializeUTC:Date.prototype.getUTCFullYear,serialize:Date.prototype.getFullYear,parse:function(e,t){e.year=Number(t)},regex:/^(\d{4})/},YY:{serializeUTC:function(){return this.getUTCFullYear().subsctr(-2,2)},serialize:function(){return this.getFullYear().substr(-2,2)},parse:function(e,t){e.year=(t<68?2e3:1900)+Number(t)},regex:/^(\d{2})/},Y:{serializeUTC:Date.prototype.getUTCFullYear,serialize:Date.prototype.getFullYear,parse:function(e,t){e.year=Number(t)},regex:/^(-?\d{1,4})/},Q:{serializeUTC:function(){return 1+Math.floor(this.getUTCMonth()/3)},serialize:function(){return 1+Math.floor(this.getMonth()/3)},parse:function(e,t){e.month=3*(t-1)},regex:/^([1-4])/},M:{serializeUTC:function(){return this.getUTCMonth()+1},serialize:function(){return this.getMonth()+1},parse:function(e,t){e.month=Number(t)-1},regex:/^([1][0-2]|0?[1-9])/},MM:"$M",D:{serializeUTC:Date.prototype.getUTCDate,serialize:Date.prototype.getDate,parse:function(e,t){e.day=Number(t)},regex:/^([12][0-9]|3[01]|0?[1-9])/},DD:"$D",DDD:{serializeUTC:function(){return(Date.UTC(this.getUTCFullYear(),this.getUTCMonth(),this.getUTCDate())-Date.UTC(this.getUTCFullYear(),0,0))/24/60/60/1e3},serialize:function(){return(Date.UTC(this.getFullYear(),this.getMonth(),this.getDate())-Date.UTC(this.getFullYear(),0,0))/24/60/60/1e3},parse:function(e,t){e.month=0,e.day=Number(t)},regex:/^(\d{1,3})/},DDDD:"$DDD",X:{serialize:function(){return Math.floor(this.getTime()/1e3)},parse:function(e,t){e.reset(),e.timestamp=1e3*Number(t)},regex:/^(-?\d+(\.\d+)?)/},x:{serialize:Date.prototype.getTime,parse:function(e,t){e.reset(),e.timestamp=Number(t)},regex:/^(-?\d+)/},w:{serializeUTC:function(){return 1+Math.floor((Date.UTC(this.getUTCFullYear(),this.getUTCMonth(),this.getUTCDate())-Date.UTC(this.getUTCFullYear(),0,0))/24/60/60/1e3/7)},serialize:function(){return 1+Math.floor((Date.UTC(this.getFullYear(),this.getMonth(),this.getDate())-Date.UTC(this.getFullYear(),0,0))/24/60/60/1e3/7)},parse:function(e,t){e.month=0,e.day=7*Number(t)},regex:/^(\d{1,2})/},Ww:"$w",W:"$ww",WW:"$ww",e:{serializeUTC:Date.prototype.getUTCDay,serialize:Date.prototype.getDay,regex:/^([0-6])/},E:{serialize:function(){return(6+this.getDay())%7+1},regex:/^([1-7])/},H:{serializeUTC:Date.prototype.getUTCHours,serialize:Date.prototype.getHours,parse:function(e,t){e.hour=Number(t)},regex:/^(2[0-3]|[01]?[0-9])/},HH:"$H",h:{serializeUTC:function(){return this.getUTCHours()%12},serialize:function(){return this.getHours()%12},parse:function(e,t){e.hour=Number(t)},regex:/^(1[0-2]|0?[0-9])/},hh:"$h",A:{serializeUTC:function(){return this.getUTCHours()<12?"AM":"PM"},serialize:function(){return this.getHours()<12?"AM":"PM"},parse:function(e,t){e.isPM="P"===t},regex:/^([AP])M/},a:{serializeUTC:function(){return this.getUTCHours()<12?"am":"pm"},serialize:function(){return this.getHours()<12?"am":"pm"},parse:function(e,t){e.isPM="p"===t},regex:/^([ap])m/},m:{serializeUTC:Date.prototype.getUTCMinutes,serialize:Date.prototype.getMinutes,parse:function(e,t){e.minute=Number(t)},regex:/^([0-5]?[0-9])/},mm:"$m",s:{serializeUTC:Date.prototype.getUTCSeconds,serialize:Date.prototype.getSeconds,parse:function(e,t){e.second=Number(t)},regex:/^([0-5]?[0-9])/},ss:"$s",SSS:{serializeUTC:Date.prototype.getUTCMilliseconds,serialize:Date.prototype.getMilliseconds,parse:function(e,t){(t=String(t)).length<3&&(t+="0".repeat(3-t.length)),e.millisecond=Number(t)},regex:/^(\d{1,3})/,trailingZero:!1},SS:{serializeUTC:function(){return Math.floor(this.getUTCMilliseconds()/10+.5)},serialize:function(){return Math.floor(this.getMilliseconds()/10+.5)},parse:function(e,t){(t=String(t)).length<2&&(t+="0".repeat(2-t.length)),e.millisecond=10*Number(t)},regex:/^(\d{1,2})/,trailingZero:!1},S:{serializeUTC:function(){return Math.floor(this.getUTCMilliseconds()/100+.5)},serialize:function(){return Math.floor(this.getMilliseconds()/100+.5)},parse:function(e,t){e.millisecond=100*Number(t)},regex:/^(\d)/},Z:{serializeUTC:function(){return"+0000"},serialize:function(){var e=String(Math.floor(-this.getTimezoneOffset()/60)),t=String(Math.floor(-this.getTimezoneOffset()%60));return e.length<2&&(e="0"+e),t.length<2&&(t="0"+t),(this.getTimezoneOffset()>=0?"-":"+")+e+t},parse:function(e,t,s,n,a){void 0!==s&&void 0!==n&&(a=("+"===t?1:-1)*(60*Number(s)+Number(n))),e.timezone=Number(a)},regex:/^([+-])(\d{2})[:]?(\d{2})|([+-]\d{3})/},ZZ:{serializeUTC:function(){return"+00:00"},serialize:function(){var e=String(Math.floor(-this.getTimezoneOffset()/60)),t=String(Math.floor(-this.getTimezoneOffset()%60));return e.length<2&&(e="0"+e),t.length<2&&(t="0"+t),(this.getTimezoneOffset()>=0?"-":"+")+e+":"+t},parse:function(e,t,s,n,a){void 0!==s&&void 0!==n&&(a=("+"===t?1:-1)*(60*Number(s)+Number(n))),e.timezone=Number(a)},regex:/^([+-])(\d{2})[:]?(\d{2})|([+-]\d{3})/},DAYSHORT:{serializeUTC:function(){return shmi.localize(a.dayShort[this.getUTCDay()])},serialize:function(){return shmi.localize(a.dayShort[this.getDay()])},leadingZero:!1},DAY:{serializeUTC:function(){return shmi.localize(a.dayLong[this.getUTCDay()])},serialize:function(){return shmi.localize(a.dayLong[this.getDay()])}},MONTH:{serializeUTC:function(){return shmi.localize(a.monthShort[this.getUTCMonth()])},serialize:function(){return shmi.localize(a.monthShort[this.getMonth()])},leadingZero:!1}},o=Object.freeze({verbose:{components:{w:{label:" ${V_WEEKS}",hideOnZero:!0,separator:" "},d:{label:" ${V_DAYS}",hideOnZero:!0,separator:" "},h:{label:"h",hideOnZero:!0,separator:" "},m:{label:"m",hideOnZero:!0,separator:" "},s:{label:"s",hideOnZero:!0,separator:" "},ms:{label:"ms",hideOnZero:!0,separator:" "}},alwaysShowSuccessive:!0},compact:{components:{w:{label:"w",hideOnZero:!0,separator:" "},d:{label:"d",hideOnZero:!0,separator:" "},h:{label:"h",hideOnZero:!0,separator:" "},m:{label:"m",hideOnZero:!0,separator:" "},s:{label:"s",hideOnZero:!0,separator:" "},ms:{label:"ms",hideOnZero:!0,separator:" "}},alwaysShowSuccessive:!1},minimal:{components:{w:{label:"w",hideOnZero:!0,separator:" "},d:{label:"d",hideOnZero:!0,separator:" "},h:{separator:":",padding:{char:"0",minLength:2}},m:{separator:":",padding:{char:"0",minLength:2}},s:{separator:".",padding:{char:"0",minLength:2}},ms:{hideOnZero:!0,padding:{char:"0",minLength:3}}}}});function getControlSequenceHandler(e){return r[e]||null}function getSequenceFromToken(e){if("$"!==e.charAt(0))return null;var t=e.substr(1);return"{"===t.charAt(0)&&"}"===t.charAt(t.length-1)&&(t=t.substr(1,t.length-2)),null===getControlSequenceHandler(t)?null:t}function parseTimeHelper(e,t,s){var n,a,r=s.split(/(\$[a-zA-Z0-9]+|\${[a-zA-Z0-9]+})/),o=0;return a=r.every((function handleFormatToken(s){var a=getSequenceFromToken(s);if(null!==a){if(n=function parseControlSequence(e,t,s){var n,a=getControlSequenceHandler(s);if(null===a)return-1;if("string"==typeof a){if(s===a)throw new Error("Control sequence references to itself");return parseTimeHelper(e,t,a)}if("object"==typeof a){if(!a.parse)return-1;if(!(n=t.match(a.regex)))return-1;var r=n.slice(1);return r.unshift(e),a.parse.apply(null,r),n[0].length}throw new Error("Invalid handler for date format control sequence")}(e,t,a),n>0)return t=t.substr(n),o+=n,!0}else if(0===t.indexOf(s))return t=t.substr(s.length),o+=s.length,!0;return!1})),a?o:-1}n.formatDateTime=function formatDateTime(e,t){var s;if("string"==typeof t)t={datestring:t};else if(void 0===t)t={};else if("object"!=typeof t)throw new TypeError("Invalid options provided");return shmi.objectHasOwnProperty(t,"datestring")||(t.datestring=shmi.localize("${V_DATEFORMAT}")),shmi.objectHasOwnProperty(t,"utc")||(t.utc=!1),shmi.objectHasOwnProperty(t,"localize")||(t.localize=!0),"number"==typeof e&&(e=new Date(1e3*e)),s=t.datestring.split(/(\$[a-zA-Z0-9]+|\${[a-zA-Z0-9]+})/).map((function handleFormatToken(s){var a=getSequenceFromToken(s);return null!==a?function formatWithControlSequence(e,t,s){var a,r=getControlSequenceHandler(t),o=!1,l=!0;if(null===r)return null;if("string"==typeof r){if(t===r)throw new Error("Control sequence references to itself");a=n.formatDateTime(e,{datestring:r,utc:s,localize:!1})}else{if("object"!=typeof r)throw new Error("Invalid handler for date format control sequence");a=String((s?r.serializeUTC:r.serialize).call(e)),void 0!==r.trailingZero&&(o=r.trailingZero),void 0!==r.leadingZero&&(l=r.leadingZero)}if(o&&l)throw new Error("Both leadingZero and trailingZero set - unsupported!");return t.length>a.length&&(o?a+="0".repeat(t.length-a.length):l&&(a="0".repeat(t.length-a.length)+a)),a}(e,a,t.utc):s})).join(""),t.localize?shmi.localize(s):s},n.parseDateTime=function parseDateTime(e,t){var s=new DateTimeBuffer,n=parseTimeHelper(s,e,t);return e.length!==n?null:s.assemble()},n.getDurationPreset=function getDurationPreset(e){return o[e]||null},n.formatDuration=function formatDuration(e,t){e=Math.floor(e<0?-e:e);if("string"==typeof t){var s=n.getDurationPreset(t);if(null===s)return n.formatDateTime(e,t,!0,!0);t=s}else{var a=n.getDurationPreset("compact");t=t||{},Object.keys(a).forEach((function(e){void 0===t[e]&&(t[e]=a[e])}))}var r="",o=null,l=!1,u=!shmi.objectHasOwnProperty(t,"localize")||t.localize;return[{type:"w",div:6048e5},{type:"d",div:864e5},{type:"h",div:36e5},{type:"m",div:6e4},{type:"s",div:1e3},{type:"ms",div:1}].forEach((function processComponent(s){if(shmi.objectHasOwnProperty(t.components,s.type)){var n=t.components[s.type],a=Math.floor(e/s.div),u=String(a);if(n){e-=a*s.div;var c=a<=0&&n.hideOnZero;(c=c&&(!l||!t.alwaysShowSuccessive))||(n.padding&&u.length<n.padding.minLength&&(u=n.padding.char.repeat(n.padding.minLength-u.length)+u),null!==o&&(r+=o),r+=u,n.label&&(r+=n.label),o=n.separator||null,l=l||s.value>0)}}})),u?shmi.localize(r):r},n.requestDateAndTime=(e={timestamp:Date.now()})=>{const{getDialog:t}=n.dateTimeDialog,s=shmi.requires("visuals.session.SysControlConfig").dateTimeDialog||{};return t(Object.assign(s,e))},s("module loaded")}(),function(){"use strict";var e="visuals.tools.numericValues",t=shmi.requires("visuals.tools.logging").createLogger(e,!1,!1),s=t.fLog,n=(t.log,shmi.pkg(e));function isSet(e){return null!=e}function isAutoEnabled(e){return void 0===e||!!e}function isOptionSet(e,t){return shmi.objectHasOwnProperty(e,t)&&null!==e[t]&&void 0!==e[t]}n.applyInputSettings=function(e,t){var s=parseFloat(e),n=t.vars&&t.vars.valueSettings?t.vars.valueSettings:t.config;return n["decimal-delimiter"]&&(s=parseFloat(String(e).replace(shmi.localize(n["decimal-delimiter"]),"."))),s=isNaN(s)?Number.NaN:function applyStep(e,t){return t.step>0&&(e=Math.round(e/t.step)*t.step),e}(s=function applyMinMax(e,t){return 0===t.min&&0===t.max?e:null!==t.max&&!isNaN(t.max)&&e>t.max?t.max:null!==t.min&&!isNaN(t.min)&&e<t.min?t.min:e}(s,n),n)},n.getTextSettings=function(e,t){return{label:e["auto-label"]?t.label:e.label,unitText:e["auto-unit-text"]?t["unit-text"]:e["unit-text"]}},n.getValueSettings=function(e,t){return{min:isAutoEnabled(e["auto-min"])&&isSet(t.min)?t.min:e.min,max:isAutoEnabled(e["auto-max"])&&isSet(t.max)?t.max:e.max,step:isAutoEnabled(e["auto-step"])&&isSet(t.step)?t.step:e.step,precision:isAutoEnabled(e["auto-precision"])&&isSet(t.precision)?t.precision:e.precision,type:isAutoEnabled(e["auto-type"])&&isSet(t.type)?t.type:e.type,"decimal-delimiter":e["decimal-delimiter"]?shmi.localize(e["decimal-delimiter"]):"."}},n.setProperties=function(e,t){e.vars=e.vars||{},e.vars.valueSettings=n.getValueSettings(e.config,{min:t[0],max:t[1],step:t[2],precision:t[9],type:t[4]})},n.initValueSettings=function(e){e.vars=e.vars||{},e.vars.valueSettings=n.getValueSettings(e.config,{})},n.formatNumber=function(e,t){var s,n=shmi.requires("visuals.tools.unitClasses"),a=parseFloat(e);return isNaN(a)||!t?e:(isOptionSet(t,"unit")?(s=n.getSelectedAdapter(t.unit))&&(a=s.outFunction(a)):isOptionSet(t,"unit-scale")&&(a*=t["unit-scale"]),isOptionSet(t,"precision")&&t.precision>=0&&(a=a.toFixed(t.precision)),isOptionSet(t,"decimal-delimiter")&&(a=String(a).split(".").join(shmi.localize(t["decimal-delimiter"]))),isOptionSet(t,"unit")&&(s?a=isOptionSet(t,"show-unit")?!0===t["show-unit"]?String(a)+" "+s.unitText:String(a):String(a)+" "+s.unitText:"string"==typeof t.unit&&""!==t.unit&&(a=isOptionSet(t,"show-unit")?!0===t["show-unit"]?String(a)+" "+t.unit:String(a):String(a)+" "+t.unit)),a)},n.formatOutput=function(e,t){var s=t.vars&&t.vars.valueSettings?t.vars.valueSettings:t.config;return"object"==typeof s&&null!==s&&function isNumeric(e){switch(parseInt(e)){case shmi.c("TYPE_STRING"):return!1;case shmi.c("TYPE_BOOL"):case shmi.c("TYPE_INT"):case shmi.c("TYPE_FLOAT"):return!0;default:shmi.visuals.session.config.debug&&console.error("unknown type:",e)}return!1}(s.type)?n.formatNumber(e,{"unit-scale":s["unit-scale"],precision:s.precision,"decimal-delimiter":s["decimal-delimiter"]}):e},s("module loaded")}(),function(){var e="visuals.task",t=shmi.requires("visuals.tools.logging").createLogger(e,!1,!1),s=t.fLog,n=t.log,a=shmi.pkg(e);a.TASK_READY=0,a.TASK_RUNNING=1,a.TASK_COMPLETE=2,a.TASK_FAILED=3,a.TASK_STATES=[a.TASK_READY,a.TASK_RUNNING,a.TASK_COMPLETE,a.TASK_FAILED];var r={},o={};shmi.onSessionReady((function(){shmi.visuals.session.config.debug&&(n("debug functions registered"),a.getTasks=function(){return r},a.getTasklists=function(){return o})}));var l=shmi.evalString;function defaultRun(){throw new Error("run function was not set.")}a.createTask=function(e){for(var t=0;void 0!==r[t];)t++;var s=defaultRun,n=a.TASK_READY,o={get state(){return n},set state(e){if(-1===a.TASK_STATES.indexOf(e))throw new Error(l("invalid state set: <%= TASK_STATE %>",{TASK_STATE:e}));n=e,shmi.fire("task-change",{id:o.id,state:n},o)},isRunning:function(){return o.state===a.TASK_RUNNING},get run(){return function(){if(o.state>a.TASK_READY)throw new Error(l("task <%= TASK_ID %> was already started.",{TASK_ID:o.id}));o.state=a.TASK_RUNNING,s()}},set run(e){s=e},complete:function(){o.state=a.TASK_COMPLETE,a.removeTask(o.id)},isComplete:function(){return o.state>a.TASK_RUNNING},fail:function(){o.state=a.TASK_FAILED,a.removeTask(o.id)},isFailed:function(){return o.state>a.TASK_COMPLETE},id:t,name:void 0===e?null:e};return r[t]=o,o},a.removeTask=function(e){if(void 0===r[e])throw new Error(l("task id '<%= TASK_ID %>' is undefined",{TASK_ID:e}));delete r[e]},a.createTaskList=function(e,t,s){for(var r=0;void 0!==o[r];)r++;e=e||[];var u=function getDefaultOnComplete(e){return function(){n(l("Tasklist <%= TASKLIST_ID %> complete",{TASKLIST_ID:e}))}}(r),c={tasks:e,serialize:!0===t,completed:0,get length(){return e.length},id:r,run:function(){if(c.completed===c.length)throw new Error("nothing to do for tasklist");shmi.fire("tasklist-run",{id:c.id,completed:c.completed,length:c.length},c);var t=null;if(t=shmi.listen("task-change",(function(e){!function getCheckListComplete(e,t,s){var r=0;-1!==e.tasks.indexOf(t.source)?(e.tasks.forEach((function(e){e.isComplete()&&r++})),e.completed=r,t.detail.state>a.TASK_RUNNING&&shmi.fire("tasklist-progress",{completed:e.completed,length:e.length,task:t.source,id:e.id},e),r===e.tasks.length&&(n(l("unlisten 'task-change' listener ID: <%= L_ID %>",{L_ID:s})),shmi.unlisten("task-change",s),e.onComplete(e),a.removeTaskList(e.id))):n("TASK NOT IN ACTIVE TASKLIST",t.source)}(c,e,t)})),c.serialize){var r=0,o=shmi.listen("tasklist-progress",(function(t){t.detail.task.state===a.TASK_COMPLETE?++r<e.length?e[r].run():shmi.unlisten("tasklist-progress",o):(shmi.unlisten("tasklist-progress",o),e.forEach((function(e){e.state<a.TASK_COMPLETE&&(e.state=a.TASK_FAILED)})))}),{"detail.id":c.id});e[r].run()}else if(!isNaN(s)&&s>0){(s=parseInt(s))>e.length&&(s=e.length),r=0,o=shmi.listen("tasklist-progress",(function(t){t.detail.task.isComplete()&&((r+=1)<e.length?e[r].run():(o.unlisten(),o=null))}),{"detail.id":c.id}),r=s-1;for(var u=0;u<s;u++)e[u].run()}else e.forEach((function(e){e.run()}))},get onComplete(){return function(){shmi.fire("tasklist-complete",{id:c.id,completed:c.completed,length:c.length},c),u(c)}},set onComplete(e){u=e}};return o[r]=c,c},a.getTaskList=function(e){if(void 0===o[e])throw new Error(l("tasklist id '<%= LIST_ID %>' is undefined",{LIST_ID:e}));return o[e]},a.removeTaskList=function(e){if(void 0===o[e])throw new Error(l("tasklist id '<%= LIST_ID %>' is undefined",{LIST_ID:e}));delete o[e]};a.showProgress=function(e,t){var s=shmi.createControl(document.body,{ui:"dialog-box",title:t||"progress",template:"custom/loading-dialog/content",name:"loading-box","initial-state":"hidden","class-name":"dialog-box designer-dialog-box"});shmi.addClass(s.element,"progress-info");var n=shmi.listen("tasklist-run",(function(e){shmi.unlisten("tasklist-run",n),s.show(),shmi.ctrl(".progress-bar",s).setProperties(0,e.detail.length,1),shmi.ctrl(".current",s).setValue(e.detail.completed),shmi.ctrl(".total",s).setValue(e.detail.length)}),{"detail.id":e.id}),a=shmi.listen("tasklist-progress",(function(e){(shmi.ctrl(".current",s).setValue(e.detail.completed),shmi.ctrl(".total",s).setValue(e.detail.length),shmi.ctrl(".progress-bar",s).setValue(e.detail.completed),null!==e.detail.task.name)&&shmi.ctrl(".task-name",s).setValue(e.detail.task.name)}),{"detail.id":e.id}),r=shmi.listen("tasklist-complete",(function(e){shmi.unlisten("tasklist-complete",r),shmi.unlisten("tasklist-progress",a),s.hide(),shmi.deleteControl(s)}),{"detail.id":e.id});return s},s("module loaded")}(),function(){var e=shmi.pkg("visuals.tools.connect"),t=864e5;e.REQUEST_TIMEOUT=t,e.request=function request(e,t,s,n,a){return shmi.visuals.session.ConnectSession.request(e,t,s,n,a)},e.callMethod=function callMethod(t,s,n,a=864e5){shmi.checkArg("methodName",t,"string"),shmi.checkArg("param",s,"object"),shmi.checkArg("callback",n,"function"),e.request("io.method",{name:t,params:s},(function(e,t){n(t,void 0!==e?e:null)}),a)}}(),function(){var e="visuals.tools.tabulator",t=shmi.pkg(e),s=shmi.requires("visuals.tools.logging").createLogger(e,!1,!1),n=s.fLog,a=s.log,r={},o={},l=null,u=document.activeElement||null;function elementTabulator(e){"Tab"===(e.key?e.key:e.code)&&(1===l.length?(e.preventDefault(),l[0].focus()):l.length>1&&(e.shiftKey&&l[0]===document.activeElement?(l[l.length-1].focus(),e.preventDefault()):e.shiftKey||l[l.length-1]!==document.activeElement||(l[0].focus(),e.preventDefault())))}a("Adding focus event listener"),document.addEventListener("focus",(function(e){!function emitFocusChange(e){document.activeElement!==u&&(u=document.activeElement,Object.keys(r).forEach((function(t){r[t]&&r[t](e)})))}(e),function emitFocusLeave(e){Object.keys(o).forEach((function(t){var s=o[t],n=shmi.testParentChild(s.leaveElem,document.activeElement),a=s.leaveElem===document.activeElement;n||a||s.cb(e)}))}(e)}),!0),t.setTabParent=function(e){if(!e)return console.error("[visuals.tools.tabulator] tabParent parameter not provided"),null;if(!(e instanceof HTMLElement))return console.error("[visuals.tools.tabulator] tabParent parameter must be an HMTLElement!"),null;l=(l=Array.from(e.querySelectorAll('[tabindex]:not([tabindex="-1"])'))).filter((function(e){return function isTabElementVisible(e){var t=e.getBoundingClientRect(),s=t.top>=0&&t.left>=0;return s=(s=s&&t.bottom<=(window.innerHeight||document.documentElement.clientHeight))&&t.right<=(window.innerWidth||document.documentElement.clientWidth)}(e)}));var t=shmi.testParentChild(e,document.activeElement);return l[0]&&!t&&(l[0].focus(),a("Initial focus set on: ",l[0])),"-1"!==e.getAttribute("tabindex")&&l.unshift(e),l.length>0?e.addEventListener("keydown",elementTabulator):a("No elements with tabindex found inside the parent",e),{unsetTabParent:function(){e.removeEventListener("keyup",elementTabulator)}}},t.onFocusChange=function(e){for(var t=Math.random().toString(36).substr(2,9);void 0!==r[t];)t=Math.random().toString(36).substr(2,9);return r[t]=e,{unsetFocusChange:function(){delete r[t]}}},t.onFocusLeave=function(e,t){for(var s=Math.random().toString(36).substr(2,9);void 0!==r[s];)s=Math.random().toString(36).substr(2,9);return o[s]={leaveElem:e,cb:t},{unsetFocusLeave:function(){delete o[s]}}},n("module loaded")}(),function(){"use strict";var e="visuals.tools.controller",t=shmi.requires("visuals.tools.logging").createLogger(e,!1,!1),s=t.fLog,n=(t.log,t.error),a=t.warn,r=(t.info,shmi.pkg(e)),o=new Map(null),l={};function getSlotInstance(e,t){var s=e.slots[t];return s&&s.instance?s.instance:null}function getController(e,t){var s={name:e,parent:t||null};return o.get(JSON.stringify(s))||null}function addListener(e,t,s){var n=getSlotInstance(e,t),a=null;n&&"function"==typeof e.onEvent&&(a=n.listen(s,(function(n){e.onEvent(r.getState(e.name,e.parent),t,s,n)})),e.slots[t].tokens.push(a))}function removeListeners(e,t){var s=e.slots[t];s.tokens.forEach((function(e){e.unlisten()})),s.tokens=[]}function updateState(e,t,s){var a=getController(e,t),o=shmi.requires("visuals.tools.iterate").iterateObject,l=!0;a?(o(a.slots,(function(e,t){null!==e.instance||e.optional||(l=!1)})),l!==a.active?(a.active=l,l?(a.onEnable(r.getState(a.name,a.parent)),o(a.slots,(function(e,t){Array.isArray(e.events)&&e.events.forEach((function(e){addListener(a,t,e)}))}))):(o(a.slots,(function(e,t){removeListeners(a,t)})),a.onDisable(r.getState(a.name,a.parent)))):l&&"function"==typeof a.onChange&&(s&&Array.isArray(a.slots[s.slot].events)&&(s.active?a.slots[s.slot].events.forEach((function(e){addListener(a,s.slot,e)})):removeListeners(a,s.slot)),a.onChange(r.getState(a.name,a.parent),s))):n("Unknown controller:",e)}function getParentName(e,t){var s=l[e],n=null,a=null;if(Array.isArray(s))for(a=t;a;)-1!==s.indexOf(a.getName())?(n=a.getName(),a=null):a=a.getParent();return n}r.create=function create(e,t,s){var r=shmi.requires("visuals.tools.iterate").iterateObject,u=!1,c=getController(e,s);c?n("Controller '%s' already registered.",e):(c={name:e,slots:{},active:!1,onChange:t.onChange||null,onEnable:t.onEnable,onDisable:t.onDisable,onEvent:t.onEvent||null,tokens:[],parent:s||null},Object.defineProperty(c,"data",{value:t.data||{},writable:!1}),r(t.slots,(function(e,t){c.slots[t]={name:t,ui:e.ui,optional:!0===e.optional,instance:null,tokens:[],events:Array.isArray(e.events)?e.events:null},!0===e.optional&&(u=!0)})),function setController(e,t,s){var n={name:t,parent:s||null};o.set(JSON.stringify(n),e),l[t]||(l[t]=[]),s&&-1===l[t].indexOf(s)&&l[t].push(s)}(c,c.name,c.parent),u&&"function"!=typeof t.onChange&&a("Optional slots exist for controller '%s', but no `onChange` callback function was provided. There will be no notifications on status changes.",e))},r.getState=function getState(e,t){var s=getController(e,t),n=shmi.requires("visuals.tools.iterate").iterateObject,a=null;return s?(a={name:s.name,slots:{},getInstance:function(e){return getSlotInstance(s,e)},getParent:function(){var e=null;return s.parent&&(e=shmi.ctrl(s.parent)),e}},Object.defineProperty(a,"active",{get:function(){return s.active},set:function(){throw new TypeError("Active state cannot be set manually.")}}),Object.defineProperty(a,"data",{value:s.data,writable:!1}),n(s.slots,(function(e,t){a.slots[t]=function getSlot(e,t){var s,n=e.slots[t];return n?(s={name:t,ui:n.ui,optional:n.optional||!1},Object.defineProperty(s,"instance",{get:function(){return getSlotInstance(e,t)},set:function(){throw new TypeError("Instance reference cannot be changed manually.")}}),s):null}(s,t)})),a):null},r.remove=function remove(e,t){var s=getController(e,t),a=-1;s?(s.active&&(s.tokens.forEach((function(e){e.unlisten()})),s.tokens=[],s.onDisable(r.getState(s.name,s.parent))),o.delete(JSON.stringify({name:e,parent:t||null})),t&&l[e]&&(-1!==(a=l[e].indexOf(t))&&l[e].splice(a,1),null===l[e].length&&delete l[e])):n("Unknown controller:",e)},r.removeAll=function removeAll(e){var t=shmi.requires("visuals.tools.iterate").iterateObject,s=[];t(l,(function(t,n){-1!==t.indexOf(e)&&s.push({name:n,parent:e})})),s.forEach((function(e){r.remove(e.name,e.parent)}))},r.getControllerParent=function getControllerParent(e,t){return getParentName(e,t)},r.registerSlot=function registerSlot(e,t,s){var a=getController(e,getParentName(e,s)),r=null,o=null,l=null;null!==a?(o=a.slots[t])?o.ui===s.uiType?null===o.instance?(o.instance=s,r=s.listen("disable",(function onDisable(e){var s=-1;r&&(r.unlisten(),-1!==(s=a.tokens.indexOf(r))&&a.tokens.splice(s,1),r=null,o.instance=null,o.optional&&(l={slot:t,active:!1}),updateState(a.name,a.parent,l))})),a.tokens.push(r),o.optional&&(l={slot:t,active:!0}),updateState(a.name,a.parent,l)):n("Slot already occupied:",t+"@"+e):n("Mismatching slot ui-type:",s.uiType,", required:",o.ui,t+"@"+e):n("Unknown controller / slot combination:",t+"@"+e):n("Unknown controller:",e)},s("module loaded")}(),function(){var e="visuals.tools.objectHelpers",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),s=t.fLog,n=(t.log,shmi.pkg(e));n.getByPath=function getByPath(e,t,s){var n,a,r=t;for("string"==typeof e&&(e=(e=(e=e.replace(/\[/g,".")).replace(/\]/g,"")).split(".")),n=0;n<e.length;n++){if(a=e[n],null===r||"object"!=typeof r||!(a in r))return s;r=r[a]}return r},n.setByPath=function setByPath(e,t,s){if("string"==typeof e&&(e=(e=(e=e.replace(/\[/g,"[.")).replace(/\]/g,"")).split(".")),e.length>1){var n=e.shift(),a={};-1!==n.indexOf("[")&&(n=n.replace("[",""),a=[]),"object"==typeof t[n]&&null!==t[n]||(t[n]=a),setByPath(e,t[n],s)}else t[e[0]]=s},s("module loaded")}(),function(){const e=shmi.pkg("visuals.tools.conditions"),t={PRIMITIVE_PRIMITIVE:{eq:(e,t)=>e===t,gt:(e,t)=>e>t,lt:(e,t)=>e<t,geq:(e,t)=>e>=t,leq:(e,t)=>e<=t,neq:(e,t)=>e!==t,and:(e,t)=>0!=(e&t),or:(e,t)=>0!=(e|t),xor:(e,t)=>0!=(e^t),nand:(e,t)=>0==(e&t),nor:(e,t)=>0==(e|t)},PRIMITIVE_ARRAY:{in:(e,t)=>t.includes(e),nin:(e,t)=>t.includes(e)},ARRAY_PRIMITIVE:{anyof:(e,t)=>e.includes(t),noneof:(e,t)=>!e.includes(t)},ARRAY_ARRAY:{anyin:(e,t)=>e.some((e=>t.includes(e))),allin:(e,t)=>e.every((e=>t.includes(e))),nonein:(e,t)=>e.every((e=>!t.includes(e))),somenotin:(e,t)=>e.some((e=>!t.includes(e)))}};function getOperandValue(e,t){return"item"===t.type?e.getItemValue(t.value):"value"===t.type?t.value:"environment"===t.type?e.getEnvironmentVariableValue(t.value):null}function resolveCondition(e,s){let n=null;return n=s.elements.map((s=>"comparison"===s.type?function resolveComparison(e,s){const n=getOperandValue(e,s.operand1),a=getOperandValue(e,s.operand2),r=s.operator,o=Array.isArray(n)&&Array.isArray(a)?t.ARRAY_ARRAY[r]:Array.isArray(a)?t.PRIMITIVE_ARRAY[r]:Array.isArray(n)?t.ARRAY_PRIMITIVE[r]:t.PRIMITIVE_PRIMITIVE[r];return!!o&&o(n,a)}(e,s):"condition"===s.type&&resolveCondition(e,s))),"AND"===s.mode?n.every((e=>!0===e)):n.some((e=>!0===e))}function checkItemsReady(e){let t=shmi.requires("visuals.tools.iterate").iterateObject,s=!0;t(e._items,((e,t)=>{null===e.value&&(s=!1)})),t(e._env,((e,t)=>{null===e.value&&(s=!1)})),e._ready=s}function checkConditionState(e){if(!e._ready)return;const t=resolveCondition(e,e._condition);t!==e._active&&(e._active=t,e._observerFunc(t))}function collectOperands(e,t,s=[]){return"comparison"===e.type?(e.operand1.type===t&&s.push({name:e.operand1.value,value:null,token:null}),e.operand2.type===t&&s.push({name:e.operand2.value,value:null,token:null})):"condition"===e.type&&e.elements.forEach((e=>{collectOperands(e,t,s)})),s}function initItems(e,t){let s=collectOperands(e._condition,"item"),n=[];s=s.filter((e=>!("string"!=typeof e.name||!e.name.length||n.includes(e.name))&&(n.push(e.name),!0))),e._items=function getItemMap(e){const t={};return e.forEach((e=>{t[e.name]=e})),t}(s),function subscribeItems(e,t,s){const n=shmi.requires("visuals.session.ItemManager");t.forEach((t=>{s.push(n.subscribeItem(t.name,{setValue:s=>{t.value=s,e.ready||checkItemsReady(e),checkConditionState(e)}}))}))}(e,s,t)}function initEnvironmentVariables(e,t){let s=collectOperands(e._condition,"environment");s=s.filter(((e,t)=>s.findIndex((({name:t})=>t===e.name))===t)),e._env=function getEnvironmentVariableMap(e){const t={};return e.forEach((e=>{t[e.name]=e})),t}(s),function subscribeEnvironmentVariables(e,t,s){const n=shmi.requires("visuals.session.EnvironmentManager");t.forEach((t=>{s.push(n.subscribe(t.name,(s=>{t.value=s,e.ready||checkItemsReady(e),checkConditionState(e)})))}))}(e,s,t)}e.ConditionObserver=class ConditionObserver{constructor(e,t){shmi.checkArg("conditions",e,"object"),shmi.checkArg("observerFunc",t,"function"),this._condition=shmi.cloneObject(e),this._tokens=[],this._items={},this._env={},this._active=null,this._ready=!1,this._observerFunc=t,this.init()}init(){initItems(this,this._tokens),initEnvironmentVariables(this,this._tokens),checkItemsReady(this),checkConditionState(this)}unlisten(){this._tokens.forEach((e=>e.unlisten())),this._tokens=[],this._items={},this._env={},this._ready=!1,this._active=null}getItemValue(e){const t=this._items[e];return t?t.value:null}getEnvironmentVariableValue(e){const t=this._env[e];return t?t.value:null}get ready(){return this._ready}get active(){return this._active}}}(),function(){const e="visuals.tools.nodes",t=shmi.requires("visuals.tools.logging").createLogger(e,!1,!1),s=t.fLog,n=(t.log,shmi.pkg(e));n.HANDLE_PREFIX="node-handle:",n.getNodeElement=function getNodeElement(e){if("string"==typeof e){const t=e.split("@").map((e=>`[_nodeid=${e}]`));t.reverse();let s=t.length?document.querySelector(t.join(" ")):null;if(s)return s;if(t.length>1){let t=e.split("@");const n=[...document.querySelectorAll(`[_nodeid=${t[0]}]`)];return t.shift(),s=n.find((e=>{const s=shmi.getControlByElement(e);if(s){let e="",n=shmi.getParentGroup(s);for(;n;)e+=`@${n.element.getAttribute("_nodeid")}`,n=shmi.getParentGroup(n);if(e=e.substr(1),e===t.join("@"))return!0}return!1}))||null,s}}return null},n.getNodeHandle=function getNodeHandle(e){let t=null,s=[],n=null;if(e instanceof HTMLElement?n=e:e&&e.uiType&&(n=e.element),n&&(t=n.getAttribute("_nodeid")),t){for(s.push(t),n=n.parentNode;n&&n!==document.body;)"group"===n.getAttribute("data-ui")&&s.push(n.getAttribute("_nodeid")),n=n.parentNode;return s.join("@")}return null},s("module-loaded")}(),function(){const e="visuals.tools.composites",t=shmi.pkg(e);function getCompositeInstance(e){return"string"==typeof e?shmi.ctrl(e):e&&"group"===e.uiType?e:null}t.getMeta=e=>shmi.visuals.session.groupConfig[e]||null,t.getPlaceholders=s=>{const n=getCompositeInstance(s);if(n){const e=n.getConfig();if(e.replacers||(e.replacers={}),e.groupId){const s=t.getMeta(e.groupId);s&&Array.isArray(s.replacers)&&s.replacers.forEach((t=>{void 0===e.replacers[t.id]&&(e.replacers[t.id]=t.default)}))}return e.replacers}return console.warn(`[${e}] composite instance not found:`,s),null},t.modifyPlaceholders=(s,n)=>{const a=getCompositeInstance(s);if(!n||"object"!=typeof n)throw new TypeError("Placeholder parameter must be specified.");if(a){const s=a.getConfig();return s.replacers=t.getPlaceholders(a),Object.entries(n).forEach((([t,n])=>{!function setPlaceholderValue(t,s,n){if(n&&"object"==typeof n&&"string"==typeof n.type)switch(n.type){case"set":t[s]=n.value;break;case"inc":if(void 0===t[s])t[s]=n.limit;else if("number"==typeof t[s]){if("number"==typeof n.limit&&!(n.value>0&&n.value+t[s]<=n.limit||n.value<0&&n.value+t[s]>=n.limit))return;t[s]+=n.value}else console.warn(`[${e}] Cannot increment placeholder '${s}' of type '${typeof t[s]}' ('number' required).`);break;case"toggle":void 0===t[s]?t[s]=!0:"boolean"==typeof t[s]?t[s]=!t[s]:console.warn(`[${e}] Cannot toggle placeholder '${s}' of type '${typeof t[s]}' ('boolean' required).`);break;default:console.warn(`[${e}] Invalid parameter type for placeholder '${s}':`,n.type)}else void 0!==n&&(t[s]=n)}(s.replacers,t,n)})),function reinstanceComposite(e,t){return shmi.deleteControl(e,!1),e.element.removeAttribute("data-config-name"),e.element.removeAttribute("data-name"),e.element.innerHTML="",shmi.createControl("group",e.element,t,"DIV","from")}(a,s)}return console.warn(`[${e}] composite instance not found:`,s),null}}(),function(){const e=shmi.pkg("visuals.tools.recipes");function saveExport(e){const t=document.createElement("a");t.href=`data:text/json;charset=utf-8,${encodeURIComponent(JSON.stringify(e,null,4))}`,t.download=`recipe-export_${function getTimestamp(){return new Date(Date.now()).toISOString().split(".")[0].replace(/:/g,"-").split("T").join("_")}()}.recipe`,t.click()}function updateRecipe(e,t){return new Promise(((s,n)=>{const a=Object.keys(t.values);e.set(null,t.metadata,!1,(r=>{if(r)n(r);else{const r={};a.forEach((e=>{r[e]=t.values[e].value})),e.write(r,(e=>{e?n(e):s()}))}}))}))}function createRecipe(e,t){return new Promise(((s,n)=>{e.createRecipe(t.name,t.metadata,(function(e,a){if(a)n(a);else{const a={};Object.keys(t.values).forEach((e=>{a[e]=t.values[e].value})),e.capture(null,(t=>{t?n(t):e.write(a,(e=>{e?n(e):s()}))}))}}))}))}function startRecipeImport(t,s,n){const a=document.createElement("INPUT"),{getDialog:r}=e.dialog;a.type="file",a.accept=".recipe",a.onchange=()=>{a.files.length&&a.files[0].text().then((async a=>{try{const o=JSON.parse(a);if(!function recipesValid(e){if(Array.isArray(e))return e.length&&e.every((e=>e&&"object"==typeof e&&e.metadata&&"object"==typeof e.metadata&&"string"==typeof e.name&&e.values&&"object"==typeof e.values));return!1}(o))return void shmi.notify("${ui-action.recipes.import-export.errorInvalidRecipes}","${V_NOTIFICATION}");const l=function checkAndFixMeta(e,t){let s=!1;return t.forEach((t=>{Object.entries(e.metadata).forEach((([e,n])=>{(function typeMatches(e,t){const s=typeof t;switch(e){case"bool":if("boolean"!==s)return!1;break;case"int":if("number"!==s||t%1!=0)return!1;break;case"double":if("number"!==s)return!1;break;case"string":if("string"!==s)return!1;break;default:return!1}return!0})(n.value_type,t.metadata[e])||(t.metadata[e]=n.default_value,s=!0)})),Object.keys(t.metadata).forEach((n=>{void 0===e.metadata[n]&&(delete t.metadata[n],s=!0)}))})),s}(s,o);if(l){if("no"===await r("${ui-action.recipes.import-export.messageMetaChanged}","${V_CONFIRM_TITLE}",[{name:"yes",label:"${ui-action.recipes.import-export.dialogOptionYes}"},{name:"no",label:"${ui-action.recipes.import-export.dialogOptionNo}"}]))return}const u=function checkAndFixItems(e,t){const s=[],n=[],a=[];return t.length&&(e.items.forEach((e=>{void 0!==t[0].values[e]?a.push(e):s.push(e)})),Object.keys(t[0].values).forEach((t=>{e.items.includes(t)||n.push(t)})),n.length&&t.forEach((e=>{n.forEach((t=>{delete e.values[t]}))}))),{missing:s,additional:n,common:a}}(s,o);if(0===u.common.length)return void shmi.notify("${ui-action.recpies.import-export.messageNoCommonItems}");if(u.missing.length||u.additional.length){let e="${ui-action.recipes.import-export.messageItemsChanged}",t="";u.missing.length&&(t+=shmi.evalString(shmi.localize("${ui-action.recipes.import-export.messageItemsChangedMissing}"),{num_missing:u.missing.length,list_missing:u.missing.join(", ")})),u.additional.length&&(t+=shmi.evalString(shmi.localize("${ui-action.recipes.import-export.messageItemsChangedAdditional}"),{num_additional:u.additional.length,list_additional:u.additional.join(", ")}));if("no"===await r(shmi.evalString(shmi.localize(e),{message_detail:t}),"${V_CONFIRM_TITLE}",[{name:"yes",label:"${ui-action.recipes.import-export.dialogOptionYes}"},{name:"no",label:"${ui-action.recipes.import-export.dialogOptionNo}"}]))return}(async function importRecipeData(t,s,n){const a=[],{getDialog:r}=e.dialog;let o=0,l=0,u=!1;for(const e of n){const n=s.find((({name:t})=>t===e.name));if(n){let t=null;u||(t=await r(shmi.evalString(shmi.localize("${ui-action.recipes.import-export.dialogMessageReplace}"),{recipe_name:e.name}),"${V_CONFIRM_TITLE}",[{name:"yes",label:"${ui-action.recipes.import-export.dialogOptionYes}"},{name:"no",label:"${ui-action.recipes.import-export.dialogOptionNo}"},{name:"all",label:"${ui-action.recipes.import-export.dialogOptionReplaceAll}"}]),"all"===t&&(u=!0)),(u||"yes"===t)&&(l+=1,a.push(updateRecipe(n,e)))}else o+=1,a.push(createRecipe(t,e))}return Promise.all(a).then((()=>({created:o,updated:l})))})(s,n,o).then((e=>{shmi.notify("${ui-action.recipes.import-export.importComplete}","${V_NOTIFICATION}",e),updateRecipeDataGrids(t)})).catch((e=>{shmi.notify("${ui-action.recipes.import-export.errorImport}","${V_ERROR}",{message:e.message})}))}catch(e){shmi.notify("${ui-action.recipes.import-export.errorImport}","${V_ERROR}",{message:e.message}),console.error("Error importing recipe data:",e.message)}}))},a.click()}function updateRecipeDataGrids(e){const t=shmi.requires("visuals.session.DataGridManager");Object.keys(t.grids).forEach((s=>{const n=t.getGrid(s);n instanceof shmi.visuals.core.DataGridRecipe&&n.recipeTemplateId===e&&n.refresh()}))}e.exportRecipes=(e,t=null)=>{const s=null===t;null!==e&&shmi.visuals.session.RecipeManager.listRecipes(e,{include_values:!0},((e,n)=>{if(n)return console.error("Error retrieving recipe list: ",n),void shmi.notify("${ui-action.recipes.import-export.errorRecipeList}","${V_ERROR}",{message:n.message});if(0!==e.recipes.length)if(s)saveExport(e.recipes);else{const s=e.recipes.find((({id:e})=>e===t));s?saveExport([s]):shmi.notify("${ui-action.recipes.import-export.recipeNotFound}","${V_ERROR}")}else shmi.notify("${ui-action.recipes.import-export.noRecipesExist}","${V_NOTIFICATION}")}))},e.updateRecipeDataGrids=updateRecipeDataGrids,e.importRecipes=async e=>{if(null!==e){let t=null,s=null;try{t=await function getRecipeTemplate(e){return new Promise(((t,s)=>{shmi.requires("visuals.session.RecipeManager").getTemplate(e,(function(e,n){n?s(n):t(e)}))}))}(e)}catch(e){return console.error("Error retrieving recipe template: "+e.message),void shmi.notify("${ui-action.recipes.import-export.errorTemplateGet}","${V_ERROR}",{message:e.message})}try{s=await function listRecipes(e){const t=shmi.requires("visuals.session.RecipeManager");return new Promise(((s,n)=>{t.listRecipes(e,{include_values:!0},((e,t)=>{t?n(t):s(e)}))}))}(e)}catch(e){return console.error("Error retrieving recipe list: "+e.message),void shmi.notify("${ui-action.recipes.import-export.errorRecipeList}","${V_ERROR}",{message:e.message})}startRecipeImport(e,t,s.recipes)}}}(),function(){const e=shmi.pkg("visuals.tools.recipes.dialog"),t="recipe-import-export-dialog",s={ui:"iq-button",config:{"class-name":"iq-button iq-variant-01",template:"default/iq-button.iq-variant-01",action:null,"show-text":!0,"disable-item-lock":!1,monoflop:!1,"monoflop-value":1,"monoflop-interval":100,name:"iq-button_1",ui:"iq-button",label:"Button 2",item:null,"auto-label":!0,"icon-src":null,"icon-title":null,"icon-class":null,"label-from-item":!1,"write-bool":!1,"action-release":null,"action-while-pressed":null,"interval-while-pressed":null,"action-press":null,"disable-alarms":!1,"show-icon":!1,"on-value":1,"off-value":0,tooltip:null},children:null};function getControllerConfig(e){return[{name:t,slot:e}]}function getDialogController(e,s){const n={};return e.forEach((e=>{"string"==typeof e.name&&(n[`optionButton${e.name}`]={ui:"iq-button",events:["click"],optional:!0})})),{name:t,slots:Object.assign({dialog:{ui:"dialog-box",events:["close"]},buttonContainer:{ui:"container",optional:!0}},n),onChange:function(e,t){},onEnable:function(e){},onDisable:function(e){},onEvent:function(e,t,n,a){if("dialog"===t)e.data.resolved||(e.data.resolved=!0,s(null)),shmi.deleteControl(e.getInstance("dialog"));else e.data.resolved||(e.data.resolved=!0,s(t.replace("optionButton","")),e.getInstance("dialog").hide())},data:{resolved:!1}}}function getDialogLayout(e,t,n,a,r,o=!1){const l=function getButtonConfigs(e){const t=[];let n=!1;return e.forEach((e=>{if("string"==typeof e.name&&e.name){const n=shmi.cloneObject(s);n.config._controllers_=getControllerConfig(`optionButton${e.name}`),"string"==typeof e.label&&(n.config.label=e.label),"string"==typeof e.icon&&(n.config["icon-src"]=e.icon,n.config["show-icon"]=!0),t.push(n)}else n=!0})),n?null:t}(n);return null===l?(r(new Error("Invalid button configuration.")),null):{ui:"dialog-box",config:{name:"messageDialog","class-name":"dialog-box recipe-message-dialog"+(o?" allow-close":""),template:"default/dialog-box","initial-state":"hidden","top-level":!0,title:t,"content-template":null,"tab-limit":!0,_controllers_:getControllerConfig("dialog")},controller:getDialogController(n,a),children:[{ui:"container",config:{ui:"container","class-name":"iq-container",type:"iqflex","flex-orientation":"column","flex-none":!0,"flex-wrap":!1,"flex-primary-align":"start","flex-secondary-align":"stretch","flex-line-align":"start",name:"content",template:null},children:[{ui:"container",config:{"class-name":"iq-container message-container",type:"iqflex","flex-orientation":"column","flex-none":!0,"flex-wrap":!1,"flex-primary-align":"start","flex-secondary-align":"stretch","flex-line-align":"start",name:"messageContainer",template:null},children:[{ui:"iq-text",config:{"class-name":"iq-text iq-variant-01 message-text",template:"default/iq-text.iq-variant-01",name:"messageText",ui:"iq-text",text:e,items:[]},children:null}]},{ui:"container",config:{"class-name":"iq-container button-container",type:"iqflex","flex-orientation":"row","flex-none":!0,"flex-wrap":!0,"flex-primary-align":"end","flex-secondary-align":"stretch","flex-line-align":"start",name:"buttonContainer",template:null,_controllers_:getControllerConfig("buttonContainer")},children:l}]}]}}e.getDialog=(e,t,s,n=!1)=>new Promise(((a,r)=>{const o=document.querySelector("[data-ui=container]"),l=o?shmi.getControlByElement(o):null;if(l){const o=getDialogLayout(e,t,s,a,r,n);o&&l.addControl(o,((e,t)=>{e?r(e):t[0].show()}))}else r(new Error("Base container element not found."))}))}(),function(){var e=shmi.pkg("visuals.tools.threads");function getFilterClauses(e,t,s,n){const a=[{mode:"AND",column:"reference_type",location:"property",clauses:[{operator:"==",value:e}]},{mode:"AND",column:"reference_object",location:"property",clauses:[{operator:"==",value:t}]}],r={mode:"AND",column:"reference_timestamp",location:"property",clauses:[]};return"number"!=typeof s&&"number"!=typeof n||(a.push(r),"number"==typeof s&&r.clauses.push({operator:">=",value:s}),"number"==typeof n&&r.clauses.push({operator:"<=",value:n})),a}e.create=async function create(t,s,n=null,a={}){const{getDialog:r}=e.dialog,o=shmi.requires("visuals.session.SysControlConfig").threadsDialogCreate;"number"==typeof n&&(n=Math.round(n));const l=await r(!0,Object.assign(o,a)),u=shmi.visuals.session,c=u.ConnectSession.requestPromise.bind(u.ConnectSession);if(null!==l&&"apply"===l.action){return await c("thread.create",{reference_type:t,reference_object:s,reference_timestamp:n,title:l.title,message:l.message})}return null},e.edit=async function edit(t,s={}){const n=shmi.visuals.session,a=n.ConnectSession.requestPromise.bind(n.ConnectSession),{getDialog:r}=e.dialog,o=shmi.requires("visuals.session.SysControlConfig").threadsDialogEdit,l=await a("thread.get",{thread_id:t});if(l){try{await a("thread.del",{thread_id:-1})}catch(e){"shmi:connect:api:generic"===e.category&&4===e.errc||(s.allowDelete=!0)}const e=await r(!1,Object.assign(o,s,{title:l.message.title,message:l.message.message}));if(null!==e&&"apply"===e.action)return await a("thread.modify",{thread_id:t,title:e.title,message:e.message}),t;if(null!==e&&"delete"===e.action){return await function asyncConfirm(e,t=null,s={}){return new Promise((n=>{shmi.confirm(e,n,t,s)}))}(s.deleteConfirmation||o.deleteConfirmation)&&await a("thread.del",{thread_id:t}),-1}}return null},e.list=async function list(e="global",t,s={}){const n=shmi.visuals.session,a=n.ConnectSession.requestPromise.bind(n.ConnectSession),{tStart:r,tEnd:o,limit:l,offset:u,loadReplies:c,loadUserDisplayName:m}=Object.assign({tStart:null,tEnd:null,limit:null,offset:null,loadReplies:!1,loadUserDisplayName:!1},s),d=await a("thread.list",{filter:{mode:"AND",clauses:getFilterClauses(e,t,r,o)},sort:[{column:"reference_timestamp",order:"ASC"}],limit:"number"==typeof l?l:void 0,offset:"number"==typeof u?u:void 0});if(c&&await Promise.all(d.threads.map((e=>a("thread.reply.list",{thread_id:e.thread_id}).then((t=>e.replies=t.replies))))),m){const e=d.threads.map((e=>[e.message.user_id,...(e.replies||[]).map((e=>e.message.user_id))])).flat().filter(((e,t,s)=>s.indexOf(e)===t)),t=await Promise.allSettled(e.map((e=>a("user.info",e)))),s={};t.forEach((({status:t,value:n},a)=>{"fulfilled"===t&&(s[e[a]]=n)}));const assignUserDisplayName=e=>{const t=s[e.message.user_id];t?t.first_name.length&&t.last_name.length?e.message.user_display_name=`${t.first_name} ${t.last_name}`:e.message.user_display_name=t.username:e.message.user_display_name=e.message.user_id};d.threads.forEach((e=>{assignUserDisplayName(e),e.replies&&e.replies.forEach(assignUserDisplayName)}))}return d}}(),function(){const e=shmi.pkg("visuals.tools.threads.dialog"),t="thread-create-edit-dialog";function getControllerConfig(e){return[{name:t,slot:e}]}function getDialogController(e,s,n){return{name:t,slots:{dialog:{ui:"dialog-box",events:["close"]},inputTitle:{ui:"iq-input-field",optional:!0,events:["change"]},inputMessage:{ui:"iq-input-field",optional:!0,events:["change"]},buttonDelete:{ui:"iq-button",optional:!0,events:["click"]},buttonApply:{ui:"iq-button",optional:!0,events:["click"]}},onChange:function(e,t){const n=e.getInstance("inputTitle"),a=e.getInstance("inputMessage"),r=e.getInstance("buttonDelete");!e.data.contentSet&&a&&n&&r&&(e.data.contentSet=!0,s.title&&n.setValue(s.title),s.message&&a.setValue(s.message),!0!==s.allowDelete&&shmi.addClass(r.element,"hidden"))},onEnable:function(e){},onDisable:function(e){},onEvent:function(e,t,a,r){let o=null;switch(t){case"dialog":e.data.resolved||(e.data.resolved=!0,n(null)),shmi.deleteControl(e.getInstance("dialog"));break;case"buttonDelete":e.data.resolved=!0,n({action:"delete"}),e.getInstance("dialog").hide();break;case"buttonApply":o=e.getInstance("inputMessage").getValue(),"string"==typeof o&&o.trim().length?(e.data.resolved=!0,n({action:"apply",title:e.getInstance("inputTitle").getValue(),message:e.getInstance("inputMessage").getValue()}),e.getInstance("dialog").hide()):shmi.notify(s.enterMessageNotification)}},data:{resolved:!1,contentSet:!1}}}e.getDialog=(e,t)=>new Promise(((s,n)=>{const a=document.querySelector("[data-ui=container]"),r=a?shmi.getControlByElement(a):null;if(r){const a=function getDialogLayout(e,t,s,n){return{ui:"dialog-box",config:{name:"threadsDialog","class-name":(t.dialogClassName||"dialog-box threads-dialog")+(e?" create":" edit"),template:t.dialogTemplate||"default/dialog-box","initial-state":"hidden","top-level":!0,title:t.dialogTitle||(e?"Create Comment":"Edit Comment"),"content-template":null,"tab-limit":!1,_controllers_:getControllerConfig("dialog")},controller:getDialogController(0,t,s),children:[{ui:"container",config:{ui:"container","class-name":"iq-container content-container",type:"iqflex","flex-orientation":"column","flex-none":!0,"flex-wrap":!1,"flex-primary-align":"start","flex-secondary-align":"stretch","flex-line-align":"start",name:"content",template:null},children:[{ui:"container",config:{"class-name":"iq-container message-container",type:"iqflex","flex-orientation":"column","flex-none":!0,"flex-wrap":!1,"flex-primary-align":"start","flex-secondary-align":"stretch","flex-line-align":"start",name:"messageContainer",template:null},children:[{ui:"iq-input-field",config:{"class-name":t.titleClassName||"iq-input-field iq-variant-02 title",template:t.titleTemplate||"default/iq-input-field.iq-variant-02",name:"commentTitle",ui:"iq-input-field",label:t.titleLabel||"Title",item:null,min:null,max:null,"value-alignment":"left","numeric-class":"numeric",unit:"[Unit]","unit-text":"","auto-label":!1,"auto-unit-text":!1,"unit-scale":1,"auto-min":!0,"auto-max":!0,type:0,"auto-type":!1,"decimal-delimiter":".","numpad-enabled":!1,precision:-1,"auto-precision":!0,"icon-src":null,"icon-title":null,"icon-class":null,multiline:!1,"show-icon":!1,tooltip:null,_controllers_:getControllerConfig("inputTitle")},children:null},{ui:"iq-input-field",config:{"class-name":t.messageClassName||"iq-input-field iq-variant-02 message",template:t.messageTemplate||"default/iq-input-field.iq-variant-02",name:"commentMessage",ui:"iq-input-field",label:t.messageLabel||"Message",item:null,min:null,max:null,"value-alignment":"left","numeric-class":"numeric",unit:"[Unit]","unit-text":"","auto-label":!1,"auto-unit-text":!1,"unit-scale":1,"auto-min":!0,"auto-max":!0,type:0,"auto-type":!1,"decimal-delimiter":".","numpad-enabled":!1,precision:-1,"auto-precision":!0,"icon-src":null,"icon-title":null,"icon-class":null,multiline:!0,"show-icon":!1,tooltip:null,_controllers_:getControllerConfig("inputMessage")},children:null}]},{ui:"container",config:{"class-name":"iq-container button-container",type:"iqflex","flex-orientation":"row","flex-none":!0,"flex-wrap":!0,"flex-primary-align":"end","flex-secondary-align":"stretch","flex-line-align":"start",name:"buttonContainer",template:null},children:[{ui:"iq-button",config:{"class-name":t.deleteClassName||"iq-button iq-variant-01 delete",template:t.deleteTemplate||"default/iq-button.iq-variant-01",action:null,"show-text":!0,"disable-item-lock":!1,monoflop:!1,"monoflop-value":1,"monoflop-interval":100,name:"commentDelete",ui:"iq-button",label:t.deleteLabel||"Delete",item:null,"auto-label":!1,"icon-src":null,"icon-title":null,"icon-class":null,"label-from-item":!1,"write-bool":!1,"action-release":null,"action-while-pressed":null,"interval-while-pressed":null,"action-press":null,"disable-alarms":!1,"show-icon":!1,"on-value":1,"off-value":0,tooltip:null,_controllers_:getControllerConfig("buttonDelete")},children:null},{ui:"iq-button",config:{"class-name":t.applyClassName||"iq-button iq-variant-01 apply",template:t.applyTemplate||"default/iq-button.iq-variant-01",action:null,"show-text":!0,"disable-item-lock":!1,monoflop:!1,"monoflop-value":1,"monoflop-interval":100,name:"commentApply",ui:"iq-button",label:t.applyLabel||"Create / Update",item:null,"auto-label":!1,"icon-src":null,"icon-title":null,"icon-class":null,"label-from-item":!1,"write-bool":!1,"action-release":null,"action-while-pressed":null,"interval-while-pressed":null,"action-press":null,"disable-alarms":!1,"show-icon":!1,"on-value":1,"off-value":0,tooltip:null,_controllers_:getControllerConfig("buttonApply")},children:null}]}]}]}}(e,t,s);a&&r.addControl(a,((e,t)=>{e?n(e):t[0].show()}))}else n(new Error("Base container element not found."))}))}(),function(){const e=shmi.pkg("visuals.tools.threads.render"),t={thread:null,templateUrl:"default/thread-list",dateformat:"$DD.$MM.$YYYY, $HH:$mm:$ss",renderReplies:!1,styleSpeechBubble:!1};function renderThreadListImpl(e,t,s){const n=new DocumentFragment;return t.forEach((t=>n.append(function renderOneThreadImpl(e,t,s){const n=shmi.requires("visuals.tools.date"),a=new DocumentFragment,{dateformat:r,renderReplies:o,styleSpeechBubble:l}=s,u=e.content.cloneNode(!0),c=shmi.getUiElement("thread-list",u),m=shmi.getUiElement("title",u),d=shmi.getUiElement("message",u),h=shmi.getUiElement("author",u),f=shmi.getUiElement("timestamp",u),g=shmi.getUiElement("thread-edit",u),p=shmi.getUiElement("edited-by",u),v=shmi.getUiElement("replies",u);return c&&l&&c.classList.add("style-speech-bubble"),m&&t.message.title&&(m.textContent=t.message.title),d&&(d.textContent=t.message.message),h&&(h.textContent=t.message.user_display_name),f&&(f.textContent=n.formatDateTime(t.message.timestamp/1e3,{datestring:shmi.localize(r)})),g&&(g.setAttribute("data-thread-id",t.thread_id),g.setAttribute("data-user-id",t.message.user_id)),p&&t.message.edited_by&&(p.textContent=t.message.edited_by),v&&o&&t.replies?v.append(renderThreadListImpl(e,t.replies,{dateformat:r,renderReplies:!1})):v&&(v.parentElement?v.parentElement.removeChild(v):u.removeChild(v)),a.append(u),a}(e,t,s)))),n}e.renderThreadList=async function renderThreadList(e,s={}){const{threadsList:n}=shmi.requires("visuals.session.SysControlConfig"),a=Object.assign({},t,n,s),{templateUrl:r}=a;let{template:o}=a;return r&&!o&&(o=await async function loadHTMLTemplate(e,t=null,s={}){const n=await shmi.loadResourcePromise(e,s),a=document.createElement("template");return a.innerHTML=t?shmi.localize(shmi.evalString(n,t)):shmi.localize(n),a}(`templates/${r}.html`)),renderThreadListImpl(o,e,a)},e.renderOneThread=function renderOneThread(t,s={}){return e.renderThreadList([t],s)}}(),function(){const e=shmi.pkg("visuals.tools.trendSets");e.create=async function create(t,s={}){const{getDialog:n}=e.dialog,a=shmi.requires("visuals.session.SysControlConfig").trendSetsDialogCreate,r=await n(!0,t,Object.assign(a,s));return null!==r&&"create"===r.action?r.name:null},e.edit=async function edit(t,s={}){const{getDialog:n}=e.dialog,a=shmi.requires("visuals.session.SysControlConfig").trendSetsDialogEdit;if(!t)return null;const r=t.getSelected();if(!r)return null;s.name=r.name;const o=await n(!1,t,Object.assign(a,s));return null!==o&&"edit"===o.action?o.name:null}}(),function(){const e=shmi.pkg("visuals.tools.trendSets.dialog"),t="trend-set-create-edit-dialog";function getControllerConfig(e){return[{name:t,slot:e}]}function getDialogController(e,s,n,a){return{name:t,slots:{dialog:{ui:"dialog-box",events:["close"]},inputName:{ui:"iq-input-field",optional:!0,events:["change"]},buttonCancel:{ui:"iq-button",optional:!0,events:["click"]},buttonApply:{ui:"iq-button",optional:!0,events:["click"]}},onChange:function(e,t){const s=e.getInstance("inputName"),a=e.getInstance("buttonCancel");!e.data.contentSet&&s&&a&&(e.data.contentSet=!0,n.name&&s.setValue(n.name))},onEnable:function(e){},onDisable:function(e){},onEvent:function(t,r,o,l){let u=null;switch(r){case"dialog":t.data.resolved||(t.data.resolved=!0,a(null)),shmi.deleteControl(t.getInstance("dialog"));break;case"buttonCancel":t.data.resolved=!0,a(null),t.getInstance("dialog").hide();break;case"buttonApply":if(u=t.getInstance("inputName").getValue(),"string"==typeof u&&u.trim().length){u=u.trim();s.getTrendSets().map((e=>e.name)).includes(u)?shmi.notify(n.nameExistsMessage,n.nameExistsTitle,{NAME:u}):(t.data.resolved=!0,a({action:e?"create":"edit",name:t.getInstance("inputName").getValue()}),t.getInstance("dialog").hide())}else shmi.notify(n.enterNameMessage,n.enterNameTitle)}},data:{resolved:!1,contentSet:!1}}}e.getDialog=(e,t,s)=>new Promise(((n,a)=>{const r=document.querySelector("[data-ui=container]"),o=r?shmi.getControlByElement(r):null;if(o){const r=function getDialogLayout(e,t,s,n,a){return{ui:"dialog-box",config:{name:"trendSetNameDialog","class-name":s.dialogClassName||"dialog-box trend-sets-dialog"+(e?" create":" edit"),template:s.dialogTemplate||"default/dialog-box","initial-state":"hidden","top-level":!0,title:s.dialogTitle||(e?"Create Trend Set":"Edit Trend Set"),"content-template":null,"tab-limit":!1,_controllers_:getControllerConfig("dialog")},controller:getDialogController(e,t,s,n),children:[{ui:"container",config:{ui:"container","class-name":"iq-container content-container",type:"iqflex","flex-orientation":"column","flex-none":!0,"flex-wrap":!1,"flex-primary-align":"start","flex-secondary-align":"stretch","flex-line-align":"start",name:"content",template:null},children:[{ui:"container",config:{"class-name":"iq-container message-container",type:"iqflex","flex-orientation":"column","flex-none":!0,"flex-wrap":!1,"flex-primary-align":"start","flex-secondary-align":"stretch","flex-line-align":"start",name:"messageContainer",template:null},children:[{ui:"iq-input-field",config:{"class-name":s.nameClassName||"iq-input-field iq-variant-02 name",template:s.nameTemplate||"default/iq-input-field.iq-variant-02",name:"inputName",ui:"iq-input-field",label:s.nameLabel||"Trend Set Name",item:null,min:null,max:null,"value-alignment":"left","numeric-class":"numeric",unit:"[Unit]","unit-text":"","auto-label":!1,"auto-unit-text":!1,"unit-scale":1,"auto-min":!0,"auto-max":!0,type:0,"auto-type":!1,"decimal-delimiter":".","numpad-enabled":!1,precision:-1,"auto-precision":!0,"icon-src":null,"icon-title":null,"icon-class":null,multiline:!1,"show-icon":!1,tooltip:null,_controllers_:getControllerConfig("inputName")},children:null}]},{ui:"container",config:{"class-name":"iq-container button-container",type:"iqflex","flex-orientation":"row","flex-none":!0,"flex-wrap":!0,"flex-primary-align":"end","flex-secondary-align":"stretch","flex-line-align":"start",name:"buttonContainer",template:null},children:[{ui:"iq-button",config:{"class-name":s.applyClassName||"iq-button iq-variant-01 apply",template:s.applyTemplate||"default/iq-button.iq-variant-01",action:null,"show-text":!0,"disable-item-lock":!1,monoflop:!1,"monoflop-value":1,"monoflop-interval":100,name:"commentApply",ui:"iq-button",label:s.applyLabel||"Create",item:null,"auto-label":!1,"icon-src":null,"icon-title":null,"icon-class":null,"label-from-item":!1,"write-bool":!1,"action-release":null,"action-while-pressed":null,"interval-while-pressed":null,"action-press":null,"disable-alarms":!1,"show-icon":!1,"on-value":1,"off-value":0,tooltip:null,_controllers_:getControllerConfig("buttonApply")},children:null},{ui:"iq-button",config:{"class-name":s.cancelClassName||"iq-button iq-variant-01 cancel",template:s.cancelTemplate||"default/iq-button.iq-variant-01",action:null,"show-text":!0,"disable-item-lock":!1,monoflop:!1,"monoflop-value":1,"monoflop-interval":100,name:"buttonCancel",ui:"iq-button",label:s.cancelLabel||"Cancel",item:null,"auto-label":!1,"icon-src":null,"icon-title":null,"icon-class":null,"label-from-item":!1,"write-bool":!1,"action-release":null,"action-while-pressed":null,"interval-while-pressed":null,"action-press":null,"disable-alarms":!1,"show-icon":!1,"on-value":1,"off-value":0,tooltip:null,_controllers_:getControllerConfig("buttonCancel")},children:null}]}]}]}}(e,t,s,n);r&&o.addControl(r,((e,t)=>{e?a(e):t[0].show()}))}else a(new Error("Base container element not found."))}))}(),function(){const e=shmi.pkg("visuals.tools.trendExport");e.export=async(t,s={})=>{const{getDialog:n}=e.dialog,{displayLoadingOverlay:a}=shmi.requires("visuals.tools.loading-overlay"),r=shmi.requires("visuals.session.SysControlConfig").trendExportDialog||{},o=await n(t,Object.assign(r,s));if(null!==o){const{query:e,getInfo:n}=shmi.requires("visuals.core.TrendManager2");let r=null,l=[];try{r=await a("${ui-action.trend-export.loading-overlay.info}",n(t)),l=r.items.map((e=>e.name))}catch(e){return console.error(`Error retrieving trend info for trend '${t}':`,e),void("shmi:connect:trend"===e.category&&1===e.errc?shmi.notify("${ui-action.trend-export.error.info.not-found}","${V_ERROR}",{NAME:t}):shmi.notify("${ui-action.trend-export.error.info.generic}","${V_ERROR}",{ERROR_CODE:e.errc,ERROR_MSG:e.message,ERROR_CAT:e.category}))}if(o.start>o.end){const e=o.start;o.start=o.end,o.end=e}try{let n=await a("${ui-action.trend-export.loading-overlay.data}",e(t,l,o.start,o.end,1));n=n.map((e=>({name:e.item_alias,resolution:e.resolution,values:e.values}))),function downloadFile(e,t){const s=document.createElement("a"),n=new Blob([t],{type:"application/json"}),a=URL.createObjectURL(n);s.setAttribute("href",a),s.setAttribute("download",e),s.style.display="none",document.body.appendChild(s),s.click(),document.body.removeChild(s),URL.revokeObjectURL(a)}(s.filename||"export-data.json",JSON.stringify(n))}catch(e){console.error(`Error retrieving trend data for trend '${t}':`,e),e.category&&e.errc?shmi.notify("${ui-action.trend-export.error.data.api}","${V_ERROR}",{ERROR_CODE:e.errc,ERROR_MSG:e.message,ERROR_CAT:e.category}):"Invalid string length"===e.message?shmi.notify("${ui-action.trend-export.error.data.size}","${V_ERROR}"):shmi.notify("${ui-action.trend-export.error.data.generic}","${V_ERROR}",{ERROR_MSG:e.message})}}}}(),function(){const e=shmi.pkg("visuals.tools.trendExport.dialog"),t="trend-data-export-dialog",s="$DD.$MM.$YYYY, $HH:$mm:$ss";function getControllerConfig(e){return[{name:t,slot:e}]}function updateTimeLabels(e){const{formatDateTime:t}=shmi.requires("visuals.tools.date"),s=e.getInstance("buttonStart"),n=e.getInstance("buttonEnd");s.setLabel(t(Math.floor(e.data.timestampStart/1e3),e.data.dateTimeFormat)),n.setLabel(t(Math.floor(e.data.timestampEnd/1e3),e.data.dateTimeFormat))}function getDialogController(e,n,a){return{name:t,slots:{dialog:{ui:"dialog-box",events:["close"]},buttonStart:{ui:"iq-button",optional:!0,events:["click"]},buttonEnd:{ui:"iq-button",optional:!0,events:["click"]},buttonCancel:{ui:"iq-button",optional:!0,events:["click"]},buttonApply:{ui:"iq-button",optional:!0,events:["click"]}},onChange:function(e,t){const s=e.getInstance("buttonStart"),a=e.getInstance("buttonEnd");!e.data.contentSet&&s&&a&&(e.data.contentSet=!0,n.timestampStart&&(e.data.timestampStart=n.timestampStart),n.timestampEnd&&(e.data.timestampEnd=n.timestampEnd),n.dateTimeFormat&&(e.data.dateTimeFormat=shmi.localize(n.dateTimeFormat)),updateTimeLabels(e))},onEnable:function(e){},onDisable:function(e){},onEvent:async function(e,t,s,n){let r=!0;switch(t){case"dialog":e.data.resolved||(e.data.resolved=!0,a(null)),shmi.deleteControl(e.getInstance("dialog"));break;case"buttonStart":{const t=await shmi.visuals.tools.date.requestDateAndTime({timestamp:e.data.timestampStart});null!==t&&(e.data.timestampStart=t,updateTimeLabels(e));break}case"buttonEnd":{const t=await shmi.visuals.tools.date.requestDateAndTime({timestamp:e.data.timestampEnd});null!==t&&(e.data.timestampEnd=t,updateTimeLabels(e));break}case"buttonCancel":e.data.resolved=!0,a(null),e.getInstance("dialog").hide();break;case"buttonApply":e.data.timestampEnd-e.data.timestampStart>864e5&&(r=await function asyncConfirm(e,t=null,s={}){return new Promise((n=>{shmi.confirm(e,n,t,s)}))}("${ui-action.trend-export.confirmation.large-duration}")),r&&(e.data.resolved=!0,a({start:e.data.timestampStart,end:e.data.timestampEnd}),e.getInstance("dialog").hide())}},data:{timestampStart:0,timestampEnd:0,resolved:!1,contentSet:!1,dateTimeFormat:s}}}e.getDialog=(e,t)=>new Promise(((e,s)=>{const n=document.querySelector("[data-ui=container]"),a=n?shmi.getControlByElement(n):null;if(a){const n=function getDialogLayout(e,t,s,n){return{ui:"dialog-box",config:{name:"trendSetNameDialog","class-name":t.dialogClassName||"dialog-box trend-data-export",template:t.dialogTemplate||"default/dialog-box","initial-state":"hidden","top-level":!0,title:t.dialogTitle||"Export Trend Data","content-template":null,"tab-limit":!1,_controllers_:getControllerConfig("dialog")},controller:getDialogController(0,t,s),children:[{ui:"container",config:{ui:"container","class-name":"iq-container content-container",type:"iqflex","flex-orientation":"column","flex-none":!0,"flex-wrap":!1,"flex-primary-align":"start","flex-secondary-align":"stretch","flex-line-align":"start",name:"content",template:null},children:[{ui:"container",config:{"class-name":"iq-container selection-container",type:"iqflex","flex-orientation":"row","flex-none":!0,"flex-wrap":!0,"flex-primary-align":"start","flex-secondary-align":"stretch","flex-line-align":"start",name:"selectionContainer",template:null},children:[{ui:"container",config:{"class-name":"iq-container time-date",type:"iqflex","flex-orientation":"column","flex-none":!0,"flex-wrap":!1,"flex-primary-align":"start","flex-secondary-align":"stretch","flex-line-align":"start",name:"startTimeDate",template:null},children:[{ui:"iq-label",config:{"class-name":t.startLabelClassName||"iq-label iq-variant-01 start-label",template:t.startLabelTemplate||"default/iq-label.iq-variant-01",name:"startLabel",ui:"iq-label",item:null,type:null,"auto-type":!0,"decimal-delimiter":".",precision:2,"auto-precision":!0,options:[],pattern:null,tooltip:null,"value-as-tooltip":!1,text:t.startLabel||"Start"},children:null},{ui:"iq-button",config:{"class-name":t.startClassName||"iq-button iq-variant-02 date-time-selection",template:t.startTemplate||"default/iq-button.date-time-selection",action:null,"show-text":!0,"disable-item-lock":!1,monoflop:!1,"monoflop-value":1,"monoflop-interval":100,name:"buttonStart",ui:"iq-button",label:"[Start Date/Time]",item:null,"auto-label":!0,"icon-src":null,"icon-title":null,"icon-class":null,"label-from-item":!1,"write-bool":!1,"action-release":null,"action-while-pressed":null,"interval-while-pressed":null,"action-press":null,"disable-alarms":!1,"show-icon":!1,"on-value":1,"off-value":0,tooltip:null,_controllers_:getControllerConfig("buttonStart")},children:null}]},{ui:"container",config:{"class-name":"iq-container time-date",type:"iqflex","flex-orientation":"column","flex-none":!0,"flex-wrap":!1,"flex-primary-align":"start","flex-secondary-align":"stretch","flex-line-align":"start",name:"endTimeDate",template:null},children:[{ui:"iq-label",config:{"class-name":t.endLabelClassName||"iq-label iq-variant-01 end-label",template:t.endLabelTemplate||"default/iq-label.iq-variant-01",name:"endLabel",ui:"iq-label",item:null,type:null,"auto-type":!0,"decimal-delimiter":".",precision:2,"auto-precision":!0,options:[],pattern:null,tooltip:null,"value-as-tooltip":!1,text:t.endLabel||"End"},children:null},{ui:"iq-button",config:{"class-name":t.endClassName||"iq-button iq-variant-02 date-time-selection",template:t.endTemplate||"default/iq-button.date-time-selection",action:null,"show-text":!0,"disable-item-lock":!1,monoflop:!1,"monoflop-value":1,"monoflop-interval":100,name:"buttonEnd",ui:"iq-button",label:"[End Date/Time]",item:null,"auto-label":!0,"icon-src":null,"icon-title":null,"icon-class":null,"label-from-item":!1,"write-bool":!1,"action-release":null,"action-while-pressed":null,"interval-while-pressed":null,"action-press":null,"disable-alarms":!1,"show-icon":!1,"on-value":1,"off-value":0,tooltip:null,_controllers_:getControllerConfig("buttonEnd")},children:null}]}]},{ui:"container",config:{"class-name":"iq-container button-container",type:"iqflex","flex-orientation":"row","flex-none":!0,"flex-wrap":!0,"flex-primary-align":"end","flex-secondary-align":"stretch","flex-line-align":"start",name:"buttonContainer",template:null},children:[{ui:"iq-button",config:{"class-name":t.applyClassName||"iq-button iq-variant-01 apply",template:t.applyTemplate||"default/iq-button.iq-variant-01",action:null,"show-text":!0,"disable-item-lock":!1,monoflop:!1,"monoflop-value":1,"monoflop-interval":100,name:"commentApply",ui:"iq-button",label:t.applyLabel||"Export",item:null,"auto-label":!1,"icon-src":null,"icon-title":null,"icon-class":null,"label-from-item":!1,"write-bool":!1,"action-release":null,"action-while-pressed":null,"interval-while-pressed":null,"action-press":null,"disable-alarms":!1,"show-icon":!1,"on-value":1,"off-value":0,tooltip:null,_controllers_:getControllerConfig("buttonApply")},children:null},{ui:"iq-button",config:{"class-name":t.cancelClassName||"iq-button iq-variant-01 cancel",template:t.cancelTemplate||"default/iq-button.iq-variant-01",action:null,"show-text":!0,"disable-item-lock":!1,monoflop:!1,"monoflop-value":1,"monoflop-interval":100,name:"buttonCancel",ui:"iq-button",label:t.cancelLabel||"Cancel",item:null,"auto-label":!1,"icon-src":null,"icon-title":null,"icon-class":null,"label-from-item":!1,"write-bool":!1,"action-release":null,"action-while-pressed":null,"interval-while-pressed":null,"action-press":null,"disable-alarms":!1,"show-icon":!1,"on-value":1,"off-value":0,tooltip:null,_controllers_:getControllerConfig("buttonCancel")},children:null}]}]}]}}(0,t,e);n&&a.addControl(n,((e,t)=>{e?s(e):t[0].show()}))}else s(new Error("Base container element not found."))}))}(),function(){const e=shmi.pkg("visuals.tools.date.dateTimeDialog"),t="date-time-selection-dialog";function getControllerConfig(e){return[{name:t,slot:e}]}function getDialogController(e,s){return{name:t,slots:{dialog:{ui:"dialog-box",events:["close"]},selectDate:{ui:"iq-select-date",optional:!0,events:["change"]},selectTime:{ui:"iq-select-time",optional:!0,events:["change"]},buttonCancel:{ui:"iq-button",optional:!0,events:["click"]},buttonApply:{ui:"iq-button",optional:!0,events:["click"]}},onChange:function(t,s){(function widgetsReady(e){return["selectDate","selectTime","buttonApply","buttonCancel"].every((t=>!!e.getInstance(t)))})(t)&&!t.data.contentSet&&(t.data.contentSet=!0,function setTimestamp(e,t){const s=Math.round(t/1e3);e.data.ignoreEvents=!0,e.getInstance("selectDate").setValue(s),e.getInstance("selectTime").setValue(s),e.data.ignoreEvents=!1}(t,e.timestamp||Date.now()))},onEnable:function(e){},onDisable:function(e){},onEvent:function(e,t,n,a){if(!e.data.ignoreEvents)switch(t){case"dialog":e.data.resolved||(e.data.resolved=!0,s(null)),shmi.deleteControl(e.getInstance("dialog"));break;case"selectDate":e.data.ignoreEvents=!0,e.getInstance("selectTime").setValue(e.getInstance("selectDate").getValue()),e.data.ignoreEvents=!1;break;case"selectTime":e.data.ignoreEvents=!0,e.getInstance("selectDate").setValue(e.getInstance("selectTime").getValue()),e.data.ignoreEvents=!1;break;case"buttonCancel":e.data.resolved=!0,s(null),e.getInstance("dialog").hide();break;case"buttonApply":e.data.resolved=!0,s(function getTimestamp(e){return 1e3*e.getInstance("selectTime").getValue()}(e)),e.getInstance("dialog").hide()}},data:{resolved:!1,contentSet:!1,ignoreEvents:!1}}}e.getDialog=e=>new Promise(((t,s)=>{const n=document.querySelector("[data-ui=container]"),a=n?shmi.getControlByElement(n):null;if(a){const n=function getDialogLayout(e,t,s){return{ui:"dialog-box",config:{name:"dateDialog","class-name":e.dialogClassName||"dialog-box date-time-selection",template:e.dialogTemplate||"default/dialog-box","initial-state":"hidden","top-level":!0,title:e.dialogTitle||"Select Date and Time","content-template":null,"tab-limit":!0,_controllers_:getControllerConfig("dialog")},controller:getDialogController(e,t),children:[{ui:"container",config:{ui:"container","class-name":"iq-container date-time-content",type:"iqflex","flex-orientation":"column","flex-none":!0,"flex-wrap":!1,"flex-primary-align":"start","flex-secondary-align":"stretch","flex-line-align":"start",name:"content",template:null},children:[{ui:"container",config:{"class-name":"iq-container",type:"iqflex","flex-orientation":"row","flex-none":!0,"flex-wrap":!0,"flex-primary-align":"start","flex-secondary-align":"stretch","flex-line-align":"start",name:"containerDateTime",template:null},children:[{ui:"container",config:{"class-name":"iq-container date-container",type:"iqflex","flex-orientation":"column","flex-none":!0,"flex-wrap":!1,"flex-primary-align":"start","flex-secondary-align":"stretch","flex-line-align":"start",name:"containerDate",template:null},children:[{ui:"iq-label",config:{"class-name":e.dateLabelClassName||"iq-label date-label iq-variant-01",template:e.dateLabelTemplate||"default/iq-label.iq-variant-01",name:"labelDate",ui:"iq-label",item:null,type:null,"auto-type":!0,"decimal-delimiter":".",precision:2,"auto-precision":!0,options:[],pattern:null,tooltip:null,"value-as-tooltip":!1,text:e.dateLabel||"Date"},children:[]},{ui:"iq-select-date",config:{"class-name":e.dateSelectClassName||"iq-select-date iq-variant-01 always-open",template:e.dateSelectTemplate||"default/iq-select-date.iq-variant-01",name:"selectDate",ui:"iq-select-date",label:"",item:null,"auto-label":!0,dateformat:"${V_DATEFORMAT}","show-icon":!1,"icon-src":null,"icon-class":null,"icon-title":null,_controllers_:getControllerConfig("selectDate")},children:[]}]},{ui:"container",config:{"class-name":"iq-container time-container",type:"iqflex","flex-orientation":"column","flex-none":!0,"flex-wrap":!1,"flex-primary-align":"start","flex-secondary-align":"stretch","flex-line-align":"start",name:"containerTime",template:null},children:[{ui:"iq-label",config:{"class-name":e.timeLabelClassName||"iq-label time-label iq-variant-01",template:e.timeLabelTemplate||"default/iq-label.iq-variant-01",name:"labelTime",ui:"iq-label",item:null,type:null,"auto-type":!0,"decimal-delimiter":".",precision:2,"auto-precision":!0,options:[],pattern:null,tooltip:null,"value-as-tooltip":!1,text:e.timeLabel||"Time"},children:[]},{ui:"container",config:{"class-name":"iq-container time-content",type:"iqflex","flex-orientation":"column","flex-none":!0,"flex-wrap":!1,"flex-primary-align":"center","flex-secondary-align":"stretch","flex-line-align":"start",name:"containerTime",template:null},children:[{ui:"iq-select-time",config:{"class-name":e.timeSelectClassName||"iq-select-time iq-variant-01 iq-icon-variant-01",template:e.timeSelectTemplate||"default/iq-select-time.iq-variant-01",name:"selectTime",ui:"iq-select-time",label:"",item:null,"auto-label":!0,"numpad-enabled":!1,isUTC:!1,_controllers_:getControllerConfig("selectTime")},children:[]}]}]}]},{ui:"container",config:{"class-name":"iq-container",type:"iqflex","flex-orientation":"row","flex-none":!0,"flex-wrap":!1,"flex-primary-align":"end","flex-secondary-align":"stretch","flex-line-align":"start",name:"containerFooter",template:null},children:[{ui:"iq-button",config:{"class-name":e.applyClassName||"iq-button iq-variant-01",template:e.applyTemplate||"default/iq-button.iq-variant-01",action:null,"show-text":!0,"disable-item-lock":!1,monoflop:!1,"monoflop-value":1,"monoflop-interval":100,name:"buttonApply",ui:"iq-button",label:e.applyLabel||"Apply",item:null,"auto-label":!0,"icon-src":null,"icon-title":null,"icon-class":null,"label-from-item":!1,"write-bool":!1,"action-release":null,"action-while-pressed":null,"interval-while-pressed":null,"action-press":null,"disable-alarms":!1,"show-icon":!1,"on-value":1,"off-value":0,tooltip:null,_controllers_:getControllerConfig("buttonApply")},children:[]},{ui:"iq-button",config:{"class-name":e.cancelClassName||"iq-button iq-variant-01",template:e.cancelTemplate||"default/iq-button.iq-variant-01",action:null,"show-text":!0,"disable-item-lock":!1,monoflop:!1,"monoflop-value":1,"monoflop-interval":100,name:"buttonCancel",ui:"iq-button",label:e.cancelLabel||"Cancel",item:null,"auto-label":!0,"icon-src":null,"icon-title":null,"icon-class":null,"label-from-item":!1,"write-bool":!1,"action-release":null,"action-while-pressed":null,"interval-while-pressed":null,"action-press":null,"disable-alarms":!1,"show-icon":!1,"on-value":1,"off-value":0,tooltip:null,_controllers_:getControllerConfig("buttonCancel")},children:[]}]}]}]}}(e,t);n?a.addControl(n,((e,[t])=>{e?s(e):t.show()})):s(new Error("Dialog layout could not be created."))}else s(new Error("Base container element not found."))}))}(),function(){const e="visuals.tools.loading-overlay",t=shmi.requires("visuals.tools.logging").createLogger(e,!1,!1),s=(t.fLog,t.log,shmi.pkg(e)),n={},a={template:null,templateUrl:"default/loading-overlay",className:"webiq-loading-overlay",rootElement:null,contentElement:null};async function loadTemplate(e){const t=document.createElement("template");return t.innerHTML=await function loadResourcePromise(e,t=!1,s=!1){return new Promise(((n,a)=>{shmi.loadResource(e,((t,s)=>{if(s){const s=new Error(`Failed to load resource from ${e}`);s.url=e,s.requestData=t,a(s)}else n(t)}),t,s)}))}(shmi.c("TEMPLATE_PATH")+e+shmi.c("TEMPLATE_EXT")),t}function setLoadingOverlayText(e){const{contentElement:t}=a;t&&(t.textContent=e?shmi.localize(e):null)}s.setTemplate=async function setTemplate(e,t=null){e&&(a.templateUrl=e,a.template=await loadTemplate(e)),t&&(a.className=t)},s.displayLoadingOverlay=async function displayLoadingOverlay(t,s){let r,o=!1;for(;n[r=Math.floor(Math.random()*Number.MAX_SAFE_INTEGER)];);n[r]={message:t},function templateIsLoaded(){return!!a.template}()||await async function tryLoadTemplate(){if(a.template)return!0;try{return a.template=await loadTemplate(a.templateUrl),!0}catch(t){console.warn(`[${e}]`,`Unable to load template for loading overlay from ${a.templateUrl}:`,t)}return!1}(),function createLoadingOverlay(e=null){if(a.rootElement)return void setLoadingOverlayText(e);if(!a.template)return;const t=document.createElement("div");t.setAttribute("id","loading-overlay"),t.classList.add("ctrl",...a.className.split(/\s+/)),t.append(a.template.content.cloneNode(!0)),a.rootElement=t,a.contentElement=shmi.getUiElement("message",t),setLoadingOverlayText(e),document.body.appendChild(t)}(t);const onUpdate=()=>{const e=Object.values(n);if(e.length>0){const t=e[e.length-1];setLoadingOverlayText(t?.details?`${t.message}\n${t.details}`:t?.message??null)}else!function destroyLoadingOverlay(){a.rootElement&&(a.rootElement.parentElement.removeChild(a.rootElement),a.rootElement=null,a.contentElement=null)}()},setDetails=e=>{const t=n[r];t&&(t.details=e,o||(requestAnimationFrame((()=>{onUpdate(),o=!1})),o=!0))},onDone=()=>{delete n[r],onUpdate()};try{let e;return e=s instanceof Promise?await s:await s(setDetails),onDone(),e}catch(e){throw onDone(),e}}}(),function(){const e="visuals.tools.localeSelection",t=shmi.pkg(e);function decomposeLocaleId(e){const t=/^(.+)[-_]([A-Z]{2})$/.exec(e);return t?{language:t[1],region:t[2]}:function stringIsRegionCode(e){return null!==/^[A-Z]{2}$/.exec(e)}(e)?{language:null,region:e}:{language:e,region:null}}const s={EXACT_MATCH:0,LANG_MATCH_NO_REGION:1,LANG_MATCH:2,REGION_MATCH_NO_LANG:3,REGION_MATCH:4,LOCALE_NO_MATCH:4294967295};function getLocaleMatchWeight(e,t){return e.language===t.language&&e.region===t.region?s.EXACT_MATCH:e.language===t.language&&null===t.region?s.LANG_MATCH_NO_REGION:e.language===t.language?s.LANG_MATCH:e.region===t.region&&null===t.language?s.REGION_MATCH_NO_LANG:e.region===t.region?s.REGION_MATCH:s.LOCALE_NO_MATCH}t.selectLocale=function selectLocale(t,n,a){const r=decomposeLocaleId(t),o=n.map((e=>{const t=decomposeLocaleId(e);return function weighLocale(e,t){return{language:t.language,region:t.region,weight:getLocaleMatchWeight(e,t)}}(r,t)})).sort(((e,t)=>e.weight-t.weight));return 0===o.length||o[0].weight===s.LOCALE_NO_MATCH?(console.log(`[${e}] no matching locale found for '${t}' - loading default locale: ${a}`),a):null===o[0].language&&null===o[0].region?(console.log(`[${e}] no language or region information could be extracted from '${t}' - loading default locale: ${a}`),a):null===o[0].language?(console.log(`[${e}] selected best region match for '${t}' - loading locale: ${o[0].region}`),o[0].region):null===o[0].region?(console.log(`[${e}] selected best language match for '${t}' - loading locale: ${o[0].language}`),o[0].language):(console.log(`[${e}] selected best match for '${t}' - loading locale: ${o[0].language}-${o[0].region}`),`${o[0].language}-${o[0].region}`)}}(),function(){const e="visuals.ui-actions.change-password",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),s=t.fLog;t.log,shmi.pkg(e);let n=[],a=null;function initControls(e){var t=shmi.visuals.session.UserManager;e.username.setValue(t.currentUser.name),n.push(e.cancel.listen("click",(function(){a.hide(),deleteDialog()}))),n.push(e.apply.listen("click",(function(){!function resetControls(e){shmi.removeClass(e.curpw.element,"error")}(e),function checkValid(e){var t,s,n=shmi.requires("visuals.session.UserManager");e.newpw.getValue()===e.repeatpw.getValue()?String(e.newpw.getValue()).length<shmi.c("MIN_PASSWORD_LENGTH")?shmi.notify("${V_PASSWORD_TOO_SHORT}"):(e.apply.lock(),t=e.curpw.getValue(),s=e.newpw.getValue(),n.changePassword(t,s,(function(t,s){0===s?(a.hide(),deleteDialog()):(e.apply.unlock(),shmi.addClass(e.curpw.element,"error"),shmi.notify("${V_INVALID_PASSWORD}"))}))):shmi.notify("${V_PASSWORD_REPEAT_NOT_EQUAL}")}(e)})))}function deleteDialog(){shmi.deleteControl(a),n.forEach((function(e){e.unlisten()})),n=[],a=null}shmi.pkg("visuals.session.sysActions")["change-password"]=function createDialog(){if(!a){var e=shmi.requires("visuals.session.SysControlConfig"),t=shmi.cloneObject(e.passwordExpiredDialog);t.title=shmi.localize("${V_PASSWORD_CHANGE_TITLE}"),a=shmi.createControl("dialog-box",document.body,t,"DIV");var s=null;a.isActive()?onDialogEnable():s=a.listen("enable",onDialogEnable),a.enable()}function onDialogEnable(){s&&(s.unlisten(),s=null),a.show();var e=[".current-user",".current-pwd",".new-pwd",".repeat-pwd",".apply-btn",".cancel-btn"];e.forEach((function(t,s){e[s]=a.getName()+" "+t})),shmi.onEnable(e,(function(t){initControls({username:t[e[0]],curpw:t[e[1]],newpw:t[e[2]],repeatpw:t[e[3]],apply:t[e[4]],cancel:t[e[5]]})}))}},s("module loaded")}(),function(){const e=shmi.pkg("visuals.session.sysActions"),t="composite-placeholders";e[t]=function(e){if("string"!=typeof e[0]||!e[1]||"object"!=typeof e[1])return void console.error("Invalid parameters, expected [{string}, {object}]");const s=shmi.ctrl(e[0]),n=e[1];if(s){const{modifyPlaceholders:e}=shmi.requires("visuals.tools.composites");e(s,n)}else console.warn(`[UiAction '${t}'] composite instance not found:`,e[0])}}(),shmi.pkg("visuals.session.sysActions")["data-recorder-record-now"]=function recordNow(e){const{request:t}=shmi.requires("visuals.tools.connect"),[s]=e;t("recorder.record_now",s,((e,t)=>{if(t){let e;e="shmi:connect:api:generic"===t.category&&4===t.errc?"${ui-action.data-recorder-trigger-now.error.accessDenied}":"shmi:connect:api:data_recorder"===t.category&&1===t.errc?"${ui-action.data-recorder-trigger-now.error.notFound}":"shmi:connect:api:data_recorder"===t.category&&4===t.errc?"${ui-action.data-recorder-trigger-now.error.notInManualMode}":"${ui-action.data-recorder-trigger-now.error.generic}",shmi.notify(e,"${V_ERROR}",{DATA_RECORDER_NAME:s,ERROR_CODE:t.errc,ERROR_MSG:t.message,ERROR_CAT:t.category})}}))},shmi.pkg("visuals.session.sysActions")["data-recorder-start-stop"]=function startStop(e){if(!Array.isArray(e)||!["start","stop"].includes(e[1]))throw new Error("Invalid parameters for UI-Action 'data-recorder-start-stop':",e);const{request:t}=shmi.requires("visuals.tools.connect"),[s,n]=e;t("stop"===n?"recorder.stop":"recorder.start",s,((e,t)=>{if(t){let e;e="shmi:connect:api:generic"===t.category&&4===t.errc?"stop"===n?"${ui-action.data-recorder-start-stop.error.stopAccessDenied}":"${ui-action.data-recorder-start-stop.error.startAccessDenied}":"shmi:connect:api:data_recorder"===t.category&&1===t.errc?"stop"===n?"${ui-action.data-recorder-start-stop.error.stopNotFound}":"${ui-action.data-recorder-start-stop.error.startNotFound}":"stop"===n?"${ui-action.data-recorder-start-stop.error.stopGeneric}":"${ui-action.data-recorder-start-stop.error.startGeneric}",shmi.notify(e,"${V_ERROR}",{DATA_RECORDER_NAME:s,ERROR_CODE:t.errc,ERROR_MSG:t.message,ERROR_CAT:t.category})}}))},function(){var e="visuals.ui-actions.inc-dec-item",t=console.error.bind(console,"["+e+"]"),s=console.log.bind(console,"["+e+"]");shmi.pkg(e);const n={};function startCompareExchange(e,s,a,r){let o;0===a?stopSubscription(r):null==s&&(s=e.readValue(!0)),o=s+a,e.virtual?(e.writable&&e.writeValue(o,!0),stopSubscription(r)):e.compareExchange(s,o,(function cmpxchgCb(s,l,u){l?startCompareExchange(e,s,n[r.itemAlias],r):u?(t("failed to increment item",u),stopSubscription(r)):(n[r.itemAlias]-=a,0===n[r.itemAlias]?stopSubscription(r):startCompareExchange(e,o,n[r.itemAlias],r))}))}function stopSubscription(e){shmi.objectHasOwnProperty(n,e.itemAlias)&&delete n[e.itemAlias],shmi.decouple((function(){e.token&&(e.token.unlisten(),e.token=null)}))}function doAtomicAdd(e,s){const a=shmi.requires("visuals.session.ItemManager"),r={itemAlias:e,token:null};if(shmi.objectHasOwnProperty(n,e))return void(n[e]+=s);n[e]=s;let o=!1,l=null,u=!1;r.token=a.subscribeItem(e,{setProperties:function setProperties(s,n,u,c,m){if(o)return;if("number"!=typeof m)return;const d=m===shmi.c("TYPE_INT")||m===shmi.c("TYPE_FLOAT");d&&(l=a.getItem(e)),o=!0,l||(t(d?"Attempted to increment non-existing item:":"Attempted to increment item value of non-numerical type:",e),stopSubscription(r))},setValue:function setValue(e){o&&l&&!u&&(u=!0,startCompareExchange(l,e,s,r))}})}shmi.pkg("visuals.session.sysActions")["increment-item-value"]=function doIncrement(e){Array.isArray(e)?2===e.length?"string"==typeof e[0]?"number"==typeof e[1]?doAtomicAdd(e[0],e[1]):t("The second parameter (offset) must be a number."):t("The first parameter (item) must be a string."):t("This ui-action requires exactly 2 parameters: item, offset."):t("This ui-actions' parameters must be given as an array.")},s("module loaded")}(),function(){const e="visuals.ui-actions.recipe-add",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),s=t.fLog;t.log,shmi.pkg(e);shmi.pkg("visuals.session.sysActions")["recipe-add"]=function addRecipe(e){const t=shmi.requires("visuals.session.RecipeManager");let s=null;if(Array.isArray(e)&&"string"==typeof e[0])if(s=shmi.ctrl(e[0]),s){const e=s.getTemplate();"number"==typeof e?t.getTemplate(e,(function(t,s){if(s)shmi.notify("${ui-action.recipe-add.error.fetchTemplate}","${V_ERROR}",{ERROR_CODE:s.errc,ERROR_MSG:s.message,ERROR_CAT:s.category});else{shmi.requires("recipe-controller.ls.recipe-name").getRecipeName(e,(function(n){null!==n&&t.createRecipe(n,{},(function(t,n){n?shmi.notify("${ui-action.recipe-add.error.createRecipe}","${V_ERROR}",{ERROR_CODE:n.errc,ERROR_MSG:n.message,ERROR_CAT:n.category}):t.capture(null,(function(t){t?shmi.notify("${ui-action.recipe-add.error.createRecipe}","${V_ERROR}",{ERROR_CODE:s.errc,ERROR_MSG:s.message,ERROR_CAT:s.category}):shmi.requires("visuals.tools.recipes").updateRecipeDataGrids(e)}))}))}))}})):shmi.notify("${ui-action.recipe-add.error.noTemplateConfigured}","${V_ERROR}")}else shmi.notify("${ui-action.recipe-add.error.recipeSelectNotFound}","${V_ERROR}",{CONTROL_NAME:e[0]});else console.error("ui-action 'recipe-add' first parameter must be of type 'string'")},s("module loaded")}(),function(){var e="visuals.ui-actions.recipe-apply",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),s=t.fLog;t.log,shmi.pkg(e);function doApply(e){e.apply((function(e,t){t&&shmi.notify("${ui-action.recipe-apply.error.applyRecipe}","${V_ERROR}",{ERROR_CODE:t.errc,ERROR_MSG:t.message,ERROR_CAT:t.category})}))}shmi.pkg("visuals.session.sysActions")["recipe-apply"]=function applyRecipe(e){var t=shmi.requires("visuals.session.RecipeManager"),s=null,n=null;if(Array.isArray(e)&&"string"==typeof e[0]){const[a,r]=e;(s=shmi.ctrl(a))?(n=s.getValue())&&"number"==typeof n.recipe_id?t.getRecipe(n.recipe_id,(function(e,t){t?shmi.notify("${ui-action.recipe-apply.error.fetchRecipe}","${V_ERROR}",{ERROR_CODE:t.errc,ERROR_MSG:t.message,ERROR_CAT:t.category}):r?doApply(e):shmi.confirm("${ui-action.recipe-add.confirm.applyRecipe}",(function(t){t&&doApply(e)}))})):shmi.notify("${ui-action.recipe-apply.error.noRecipeSelected}","${V_ERROR}"):shmi.notify("${ui-action.recipe-apply.error.recipeSelectNotFound}","${V_ERROR}",{CONTROL_NAME:a})}else console.error("ui-action 'recipe-apply' first parameter must be of type 'string'")},s("module loaded")}(),function(){var e="visuals.ui-actions.recipe-capture",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),s=t.fLog;t.log,shmi.pkg(e);function doCapture(e){e.capture(null,(function(e){e&&shmi.notify("${ui-action.recipe-capture.error.captureRecipe}","${V_ERROR}",{ERROR_CODE:e.errc,ERROR_MSG:e.message,ERROR_CAT:e.category})}))}shmi.pkg("visuals.session.sysActions")["recipe-capture"]=function captureRecipe(e){var t=shmi.requires("visuals.session.RecipeManager"),s=null,n=null;Array.isArray(e)&&"string"==typeof e[0]?(s=shmi.ctrl(e[0]))?(n=s.getValue())?"number"==typeof n.recipe_id&&t.getRecipe(n.recipe_id,(function(e,t){t?shmi.notify("${ui-action.recipe-capture.error.fetchRecipe}","${V_ERROR}",{ERROR_CODE:t.errc,ERROR_MSG:t.message,ERROR_CAT:t.category}):"number"==typeof e.versionId?shmi.confirm("${ui-action.recipe-capture.confirm.captureRecipe}",(function(t){t&&doCapture(e)})):doCapture(e)})):shmi.notify("${ui-action.recipe-apply.error.noRecipeSelected}","${V_ERROR}",{CONTROL_NAME:e[0]}):shmi.notify("${ui-action.recipe-capture.error.recipeSelectNotFound}","${V_ERROR}",{CONTROL_NAME:e[0]}):console.error("ui-action 'recipe-capture' first parameter must be of type 'string'")},s("module loaded")}(),shmi.pkg("visuals.session.sysActions")["recipe-export"]=function exportRecipe(e){const t=e[1],s=e[0],n=shmi.requires("visuals.tools.recipes"),a=shmi.ctrl(s);if(!a)return void shmi.notify("${ui-action.recipes.import-export.widgetNotFound}","${V_ERROR}");const r=a.getTemplate();if("number"==typeof r)if(t)n.exportRecipes(r,null);else{const e=a.getValue()?a.getValue().recipe_id:null;if(null===e)return void shmi.notify("${ui-action.recipes.import-export.noRecipeSelected}","${V_NOTIFICATION}");n.exportRecipes(r,e)}else shmi.notify("${ui-action.recipes.import-export.templateNotConfigured}","${V_ERROR}")},shmi.pkg("visuals.session.sysActions")["recipe-import"]=function importRecipe(e){const t=e[0],s=shmi.requires("visuals.tools.recipes"),n=shmi.ctrl(t);if(!n)return void shmi.notify("${ui-action.recipes.import-export.widgetNotFound}","${V_ERROR}");const a=n.getTemplate();"number"==typeof a?s.importRecipes(a):shmi.notify("${ui-action.recipes.import-export.templateNotConfigured}","${V_ERROR}")},shmi.pkg("visuals.session.sysActions")["trend-export"]=function(e){const t=e[0],s=Date.now();shmi.requires("visuals.tools.trendExport").export(t,{timestampStart:s-36e5,timestampEnd:s})},shmi.pkg("visuals.session.sysActions")["trend-set-create"]=async function createTrendSet(e){if(!Array.isArray(e)&&"string"==typeof e[0])throw new Error("Invalid parameters for UI-Action 'trend-set-create':",e);const t=shmi.ctrl(e[0]),{create:s}=shmi.requires("visuals.tools.trendSets");if(t){const e=await s(t);null!==e&&t.createTrendSet(e)}else shmi.notify("${ui-action.trend-set-create.widgetNotFound.message}","${ui-action.trend-set-create.widgetNotFound.title}")},shmi.pkg("visuals.session.sysActions")["trend-set-delete"]=async function deleteTrendSet(e){if(!Array.isArray(e)&&"string"==typeof e[0])throw new Error("Invalid parameters for UI-Action 'trend-set-delete':",e);const t=shmi.ctrl(e[0]);if(t){const e=t.getSelected();e&&!e.fixed?await function asyncConfirm(e,t=null,s={}){return new Promise((n=>{shmi.confirm(e,n,t,s)}))}("${ui-action.trend-set-delete.confirmation.message}","${ui-action.trend-set-delete.confirmation.title}",{NAME:e.name})&&await t.deleteTrendSet():e?shmi.notify("${ui-action.trend-set-delete.fixedSetSelected.message}","${ui-action.trend-set-delete.fixedSetSelected.title}"):shmi.notify("${ui-action.trend-set-delete.noSetSelected.message}","${ui-action.trend-set-delete.noSetSelected.title}")}else shmi.notify("${ui-action.trend-set-delete.widgetNotFound.message}","${ui-action.trend-set-delete.widgetNotFound.title}")},shmi.pkg("visuals.session.sysActions")["trend-set-rename"]=async function renameTrendSet(e){if(!Array.isArray(e)&&"string"==typeof e[0])throw new Error("Invalid parameters for UI-Action 'trend-set-rename':",e);const t=shmi.ctrl(e[0]),{edit:s}=shmi.requires("visuals.tools.trendSets");if(t){const e=t.getSelected();if(e&&!e.fixed){const e=await s(t);null!==e&&t.renameTrendSet(e)}else e?shmi.notify("${ui-action.trend-set-rename.fixedSetSelected.message}","${ui-action.trend-set-rename.fixedSetSelected.title}"):shmi.notify("${ui-action.trend-set-rename.noSetSelected.message}","${ui-action.trend-set-rename.noSetSelected.title}")}else shmi.notify("${ui-action.trend-set-rename.widgetNotFound.message}","${ui-action.trend-set-rename.widgetNotFound.title}")},shmi.pkg("visuals.session.sysActions")["trend-set-save"]=async function saveTrendSet(e){if(!Array.isArray(e)&&"string"==typeof e[0])throw new Error("Invalid parameters for UI-Action 'trend-set-save':",e);const t=shmi.ctrl(e[0]);if(t){const e=t.getSelected();e&&!e.fixed?await t.saveTrendSet():e?shmi.notify("${ui-action.trend-set-save.fixedSetSelected.message}","${ui-action.trend-set-save.fixedSetSelected.title}"):shmi.notify("${ui-action.trend-set-save.noSetSelected.message}","${ui-action.trend-set-save.noSetSelected.title}")}else shmi.notify("${ui-action.trend-set-save.widgetNotFound.message}","${ui-action.trend-set-save.widgetNotFound.title}")},shmi.pkg("visuals.session.sysActions")["trend-set-values"]=async function setTrendValues(e){if(!Array.isArray(e)||"string"!=typeof e[0]||!Array.isArray(e[1]))throw new Error("Invalid parameters for UI-Action 'trend-set-values':",e);const t=shmi.ctrl(e[0]);let s=e[1];if(t){const e=t.getTrendInfo(),n=s.map((e=>e.name));if(e&&"trend"===e.type&&e.name){const t=shmi.requires("visuals.core.TrendManager2");let a=null;try{a=await t.getInfo(e.name,n)}catch(t){console.error(`[UI-Action 'trend-set-values'] error retrieving trend info for trend: ${e.name}:`,t)}const r=null===a?[]:a.items.map((e=>e.name));s=s.filter((t=>{const s=r.includes(t.name);return s||console.warn(`[UI-Action 'trend-set-values'] item included in values is not present in trend '${e.name}': ${t.name}`),s}))}t&&t.setSelectedValues(s)}else shmi.notify("${ui-action.trend-set-values.widgetNotFound.message}","${ui-action.trend-set-values.widgetNotFound.title}")},function(){const e="webiq-app-settings",t="unitclass-adapter-index";function updateAdapters(e){const t=shmi.requires("visuals.tools.unitClasses");t.getUnitClasses().forEach((s=>{const n=s.unitClass,a=s.adapters;a[e]&&t.setUnitClassAdapter(n,a[e].name)}))}shmi.listen("login-state",(()=>{const s=shmi.visuals.session.project||shmi.visuals.session.current_project;if(s){const n=function getAppSettings(t){const s=localStorage.getItem(e);let n={};if(null!==s)try{n=JSON.parse(s)}catch(e){console.error("Error parsing WebIQ app settings from local storage:",e)}return n[t]||{}}(s),a="number"==typeof n[t]?n[t]:null;null!==a&&a>=0&&updateAdapters(a)}}),{"detail.loggedIn":!0}),shmi.pkg("visuals.session.sysActions")["unitclass-adapter"]=function unitclassAdapter(s){const n=s[0],a=shmi.visuals.session.project||shmi.visuals.session.current_project;"number"!=typeof n||n<0||n%1!=0?console.error(`Invalid unitclass adapter index '${n}' specified. Must be an integer value >= 0.`):(updateAdapters(n),a&&function updateAppSetting(t,s,n){const a=localStorage.getItem(e);let r={};if(null!==a)try{r=JSON.parse(a)}catch(e){console.error("Error parsing WebIQ app settings from local storage:",e)}const o=r[t]||{};o[s]=n,r[t]=o,localStorage.setItem(e,JSON.stringify(r,null,4))}(a,t,n))}}(),function(){const e="visuals.ui-actions.write-item-bitmask",t=console.error.bind(console,"["+e+"]"),s=console.log.bind(console,"["+e+"]");shmi.pkg(e);function startBitwiseOperation(e,s,n,a,r,o){null==s&&(s=e.readValue(!0));const l=s&~n|a&n;l!==s&&(e.virtual?(e.writable&&e.writeValue(l,!0),r()):e.compareExchange(s,l,(function cmpxchgCb(s,l,u){l?startBitwiseOperation(e,s,n,a,r,o):u?(t("failed to apply bitmask",u),o(u)):r()})))}function doBitwiseOperation(e,t,s,n){return new Promise(((a,r)=>startBitwiseOperation(e,t,s,n,a,r)))}function stopSubscription(e){shmi.decouple((function(){e.token&&(e.token.unlisten(),e.token=null)}))}shmi.pkg("visuals.session.sysActions")["write-item-bitmask"]=function doItemBitOp(e){if(!Array.isArray(e))return void t("This ui-actions' parameters must be given as an array.");if(3!==e.length)return void t("This ui-action requires exactly 3 parameters: item, operation, bitmask.");if("string"!=typeof e[0])return void t("The first parameter (item) must be a string.");if(!["set","clear","toggle"].includes(e[1]))return void t("The second parameter (operation) must be either 'set', 'clear' or 'toggle'.");if(!Number.isInteger(e[2]))return void t("The second parameter (bitmask) must be an integer.");const s=shmi.requires("visuals.session.ItemManager"),n=e[1],a=parseInt(e[2]),r=s.getItemHandler(),o={token:null};let l=null,u=!1,c=!1,m=!1;r.setProperties=function setProperties(n,a,r,m,d){c||"number"==typeof d&&(-1!==d&&(l=s.getItem(e[0]),l&&(u=!0)),c=!0,u||(t("Attempted to use bit operation on non-existing item:",e[0]),stopSubscription(o)))},r.setValue=function setValue(e){if(c&&u&&!m){let s;switch(m=!0,n){case"set":s=a;break;case"clear":s=0;break;case"toggle":s=~e&a;break;default:return t("Invalid bitwise operation",n),void stopSubscription(o)}doBitwiseOperation(l,e,a,s).catch((()=>{})).finally(stopSubscription.bind(null,o))}},o.token=s.subscribeItem(e[0],r)},s("module loaded")}(),function(){var e,t=[],s=null;function createDialog(){var n,a,r,o=t[0];n=o.detail.message,a=o.detail.title,r=o.detail.param;var l=shmi.requires("visuals.session.SysControlConfig"),u=shmi.cloneObject(l.notificationDialog);u.title=a||u.title,u.title=shmi.evalString(shmi.localize(u.title),r),n=shmi.evalString(shmi.localize(n),r);var c=(s=shmi.createControl("dialog-box",document.body,u,"DIV")).listen("close",(function(e){c.unlisten(),deleteDialog(),shmi.fire("notification-dismissed",{param:r,timestamp:Date.now()},shmi.visuals.session)})),m=null;function onDialogEnable(){m&&(m.unlisten(),m=null);var t=shmi.getElementByName("notification-text",s.element);t&&(t.textContent=n),s.listen("open",(function(){var e=s.element.querySelector("[data-ui=button]");e&&e.focus()})),s.element.addEventListener("keyup",e),s.show()}e=function(e){"Escape"===e.code&&(c.unlisten(),deleteDialog(),shmi.fire("notification-dismissed",{param:r,timestamp:Date.now()},shmi.visuals.session))},s.isActive()?onDialogEnable():m=s.listen("enable",onDialogEnable),s.enable()}function deleteDialog(){s.element.removeEventListener("keyup",e),shmi.deleteControl(s),s=null,t.shift(),shmi.decouple((function(){t.length&&createDialog()}))}function defaultNotificationHandler(e){try{shmi.requires("visuals.controls.Button"),shmi.requires("visuals.controls.DialogBox")}catch(e){return void console.log("error trying to load controls: Button, DialogBox\n"+e)}t.push(e),1===t.length&&createDialog()}var n=shmi.pkg("visuals.handler.default.notification"),a=null;n.register=function(){a&&(console.debug("notification handler was active!"),a.unlisten(),a=null),a=shmi.listen("notification",defaultNotificationHandler)},n.deregister=function(){a?(a.unlisten(),a=null):console.debug("notification handler not active!")}}(),function(){var e=[],t=null,s=null,n=[];function getFuncBtn(e,t){var s=null;if(Array.isArray(e))for(var n=0;n<e.length;n++){if(e[n].element.getAttribute("data-function")===t){s=e[n];break}if(Array.isArray(e[n].controls)&&(s=getFuncBtn(e[n].controls,t)))break}return s}function runCallbackDelayed(e,t){shmi.decouple((function(){try{e(t)}catch(e){console.error("exception running shmi.confirm callback:",e)}}))}function createDialog(){var n,a,r,o=e[0];n=o.detail.message,a=o.detail.title,r=o.detail.param,s=o.detail.callback;var l=shmi.requires("visuals.session.SysControlConfig"),u=shmi.cloneObject(l.confirmDialog);u.title=a||u.title,u.title=shmi.evalString(shmi.localize(u.title),r),n=shmi.evalString(shmi.localize(n),r),t=shmi.createControl("dialog-box",document.body,u,"DIV");var c=null,m=null,d=null;function onDialogEnable(){let e={cbExecuted:!1,keyHandler:null};c&&(c.unlisten(),c=null);var a=shmi.getElementByName("confirm-text",t.element);return a&&(a.textContent=n),(m=getFuncBtn(t.controls,"confirm"))?(d=getFuncBtn(t.controls,"deny"))?(m.listen("click",(function(){e.cbExecuted=!0,runCallbackDelayed(s,!0),t.hide(),deleteDialog(e)})),d.listen("click",(function(){e.cbExecuted=!0,runCallbackDelayed(s,!1),t.hide(),deleteDialog(e)})),t.listen("open",(function(){var e=t.element.querySelector("[data-ui=button]");e&&e.focus()})),t.listen("close",(function(){e.cbExecuted||(e.cbExecuted=!0,runCallbackDelayed(s,!1),deleteDialog(e))})),e.keyHandler=function getOnKeyPress(e){return function onKeypRess(n){"Escape"===n.code&&s&&(e.cbExecuted=!0,runCallbackDelayed(s,!1),t.hide(),deleteDialog(e))}}(e),t.element.addEventListener("keyup",e.keyHandler),void t.show()):(console.error("deny button missing in confirmation-dialog"),s(!1),void deleteDialog(e)):(console.error("confirm button missing in confirmation-dialog"),s(!1),void deleteDialog(e))}t.isActive()?onDialogEnable():c=t.listen("enable",onDialogEnable),t.enable()}function deleteDialog(s){t.element.removeEventListener("keyup",s.keyHandler),shmi.deleteControl(t),t=null,e.shift(),n.forEach((function(e){e.unlisten()})),n=[],shmi.decouple((function(){1===e.length&&null===t&&createDialog()}))}function defaultConfirmationHandler(t){try{shmi.requires("visuals.controls.Button"),shmi.requires("visuals.controls.DialogBox")}catch(e){return void console.log("error trying to load controls: Button, DialogBox\n"+e)}e.push(t),1===e.length&&createDialog()}var a=shmi.pkg("visuals.handler.default.cofirmation"),r=null;a.register=function(){r&&(console.debug("confirmation handler was active!"),r.unlisten(),r=null),r=shmi.listen("confirmation",defaultConfirmationHandler)},a.deregister=function(){r?(r.unlisten(),r=null):console.debug("confirmation handler not active!")}}(),function(){var e=[],t=null,s=!1,initialLoginExpired=function(){};function initControls(s){var n=shmi.visuals.session.UserManager;s.username.setValue(n.currentUser.name),e.push(s.cancel.listen("click",(function(){t.hide(),deleteDialog()}))),e.push(s.apply.listen("click",(function(){!function resetControls(e){shmi.removeClass(e.curpw.element,"error"),shmi.removeClass(e.newpw.element,"error"),shmi.removeClass(e.repeatpw.element,"error")}(s),function checkValid(e){var s,n,a=shmi.requires("visuals.session.UserManager");if(e.newpw.getValue()!==e.repeatpw.getValue())return shmi.notify("${V_PASSWORD_REPEAT_NOT_EQUAL}"),void shmi.addClass(e.repeatpw.element,"error");e.apply.lock(),s=e.curpw.getValue(),n=e.newpw.getValue(),a.changePassword(s,n,(function(s,n){if(!n)return t.hide(),void deleteDialog();e.apply.unlock(),shmi.addClass(e.curpw.element,"error"),"auth-generic"===n.category&&3===n.errc?shmi.addClass(e.curpw.element,"error"):"auth-generic"===n.category&&5===n.errc&&shmi.addClass(e.newpw.element,"error"),n.localizedMessage?shmi.notify(n.localizedMessage):shmi.notify("${V_INVALID_PASSWORD}")}))}(s)})))}function createDialog(){if(s){var e=shmi.requires("visuals.session.SysControlConfig"),n=shmi.cloneObject(e.passwordExpiredDialog);n.title=n.title||"${V_PASSWORD_EXPIRED_TITLE}",n.title=shmi.localize(n.title),(t=shmi.createControl("dialog-box",document.body,n,"DIV")).isActive()?onDialogEnable():t.listenOnce("enable",onDialogEnable),t.enable()}else initialLoginExpired=function(){createDialog()};function onDialogEnable(){t.show();var e=[".current-user",".current-pwd",".new-pwd",".repeat-pwd",".apply-btn",".cancel-btn"];e.forEach((function(s,n){e[n]=t.getName()+" "+s})),shmi.onEnable(e,(function(t){initControls({username:t[e[0]],curpw:t[e[1]],newpw:t[e[2]],repeatpw:t[e[3]],apply:t[e[4]],cancel:t[e[5]]})}))}}function deleteDialog(){shmi.deleteControl(t),e.forEach((function(e){e.unlisten()})),e=[],t=null}function defaultPasswordExpiredHandler(e){try{shmi.requires("visuals.controls.Button"),shmi.requires("visuals.controls.DialogBox")}catch(e){return void console.log("error trying to load controls: Button, DialogBox\n"+e)}null===t&&createDialog()}var n=shmi.pkg("visuals.handler.default.passwordExpired"),a=null,r=shmi.listen("parser-ready",(function(){r.unlisten(),s=!0,shmi.decouple(initialLoginExpired)}));n.register=function(){a&&(console.debug("password-expired handler was active!"),a.unlisten(),a=null),a=shmi.listen("password-expired",defaultPasswordExpiredHandler)},n.deregister=function(){a?(a.unlisten(),a=null):console.debug("password-expired handler not active!")}}(),function(){var e=null;function defaultConnectionFailed(t){e=Date.now();var s=shmi.listen("notification-dismissed",(function(e){s.unlisten(),window.location.reload()}),{"detail.param.id":e});shmi.notify("${CONNECTION_RESET}","${V_NOTIFICATION}",{id:e})}var t=shmi.pkg("visuals.handler.default.connectionFailed"),s=null;t.register=function(){s&&(console.debug("connection-failed handler was active!"),s.unlisten(),s=null),s=shmi.listen("connection-failed",defaultConnectionFailed)},t.deregister=function(){s?(s.unlisten(),s=null):console.debug("connection-failed handler not active!")}}(),function(){var e,t,s=[],n=[],a=null;function defaultOptionDialogHandler(e){try{shmi.requires("visuals.controls.Button"),shmi.requires("visuals.controls.DialogBox")}catch(e){return void console.log("error trying to load controls: Button, DialogBox\n"+e)}s.push(e),1===s.length&&createDialog()}function createDialog(){var r=null,o={},l=s[0].detail;if(l.buttons&&Array.isArray(l.buttons)&&"object"==typeof l.buttons[0]){var u=shmi.requires("visuals.session.SysControlConfig"),c=shmi.cloneObject(u.optionDialog);c.title=l.title||c.title,c.title=shmi.evalString(shmi.localize(c.title),l.titleParams),(c["class-name"]||l["class-name"])&&(c["class-name"]=[...new Set([...c["class-name"]?c["class-name"].split(/\s+/):[],...l["class-name"]?l["class-name"].split(/\s+/):[]])].filter((e=>e.length)).join(" ")),a=shmi.createControl("dialog-box",document.body,c,"DIV"),t=function(t){"Escape"===t.code&&e.callback&&(e.callback(e.name,t),a.hide(),deleteDialog())},a.isActive()?onDialogEnable():r=a.listen("enable",onDialogEnable),a.enable()}else shmi.log("[shmi.optionDialog] Invalid options provided ",3);function onDialogEnable(){r&&(r.unlisten(),r=null),n.length&&(n.forEach((function(e){e&&e.unlisten&&e.unlisten()})),n=[]);var s=a.element.querySelector("[data-name=option-text]");if(s){var u=l.messageParams||{};l.message=shmi.evalString(shmi.localize(l.message),u),s.textContent=l.message}var c=a.element.querySelector("[data-name=dialog-options]"),m=a.element.querySelector("[data-name=dialog-ctrls]");l.buttons.forEach((function(e){const t=e.config.name,s=e.callback;let r=null;switch(e.type){case"warning":case"success":case"option":if("vertical"===l.buttonLayout){if(!c)return void shmi.log('[shmi.optionDialog] HTML Element not found: data-name="dialog-options"',3);r=c}else if("horizontal"===l.buttonLayout){if(!m)return void shmi.log('[shmi.optionDialog] HTML Element not found: data-name="dialog-ctrls"',3);r=m}break;case"cancel":if(!m)return void shmi.log('[shmi.optionDialog] HTML Element not found: data-name="dialog-ctrls"',3);r=m;break;default:return}r&&(e.config["class-name"]=e.config["class-name"]?e.config["class-name"]+" "+e.type:e.type,o[t]=shmi.createControl("button",r,e.config,"DIV","before"),n.push(o[t].listen("click",(function(e){a.hide(),deleteDialog();try{s(t,e)}catch(e){console.error("exception running shmi.optionDialog callback:",e)}}))))})),a.listen("open",(function(){var e=a.element.querySelector("[data-ui=button]");e&&e.focus()})),(e=l.buttons.find((function(e){return"cancel"===e.type})))&&a.element.addEventListener("keyup",t),a.show()}}function deleteDialog(){a.element.removeEventListener("keyup",t),shmi.deleteControl(a),a=null,s.shift(),n.forEach((function(e){e&&e.unlisten&&e.unlisten()})),n=[],shmi.decouple((function(){1===s.length&&null===a&&createDialog()}))}var r=shmi.pkg("visuals.handler.default.optionDialog"),o=null;r.register=function(){o&&(console.debug("confirmation handler was active!"),o.unlisten(),o=null),o=shmi.listen("optionDialog",defaultOptionDialogHandler)},r.deregister=function(){o?(o.unlisten(),o=null):console.debug("confirmation handler not active!")}}(),function(){const e=shmi.pkg("visuals.handler.default.logout");let t=null,s=!1;e.register=function(){t||(t=shmi.listen("login-state",(e=>{const t=s&&!1===e.detail.loggedIn;s=e.detail.loggedIn,t&&window.location.reload()})))},e.deregister=function(){t&&(t.unlisten(),t=null,s=!1)}}(),function(){const e=shmi.pkg("visuals.handler.default.numpad");let t=null,s=null,n=[];function getOnClose(e){return()=>{n.forEach((e=>{e.unlisten()})),n=[],function deleteNumpad(){shmi.deleteControl(t),t=null}()}}function numpadRequestHandler(e){null===t&&function createNumpad(e){const s={};shmi.requires("visuals.tools.iterate.iterateObject")(e.detail,(function(t,n){s[n]=e.detail[n]})),s.label&&(s.label=shmi.evalString(shmi.localize(s.label),e.detail.param)),t=shmi.createControl("numpad",document.body,s,"DIV",null,!0);const a=getOnClose();n.push(t.listen("close",a)),n.push(t.listen("close",a)),shmi.onActive([t],(()=>{t.show()}))}(e)}e.register=function(){s&&(console.debug("numpad handler was active!"),s.unlisten(),s=null),s=shmi.listen("numpad-request",numpadRequestHandler)},e.deregister=function(){s?(s.unlisten(),s=null):console.debug("numpad handler not active!")}}(),function(){var e={type:1,queries:[{name:"mobile",threshold:null,layoutWidth:"318px",editorWidth:"320px",icon:"icon mq-mobile",enabled:!0},{name:"wide-mobile",threshold:"478px",layoutWidth:"478px",editorWidth:"480px",icon:"icon mq-wide-mobile",enabled:!0},{name:"tablet-portrait",threshold:"758px",layoutWidth:"758px",editorWidth:"768px",icon:"icon mq-tablet-portrait",enabled:!0},{name:"tablet-landscape",threshold:"1018px",layoutWidth:"1018px",editorWidth:"1024px",icon:"icon mq-tablet-landscape",enabled:!0},{name:"wide",threshold:"1278px",layoutWidth:"1278px",editorWidth:"1280px",icon:"icon mq-wide",enabled:!0},{name:"extra-wide",threshold:"1918px",layoutWidth:"1918px",editorWidth:"1920px",icon:"icon mq-extra-wide",enabled:!0}]},t="(min-width: <%= threshold %>)",s="(max-width: <%= threshold %>)",n=1,a=2,r={},o=null;function testLayout(){for(var r=0,l="",u=0;u<e.queries.length;u++)e.queries[u].enabled&&(e.type===n?l=shmi.evalString(t,e.queries[u]):e.type===a&&(l=shmi.evalString(s,e.queries[u])),window.matchMedia(l).matches&&(r=u));var c=o;if(c!==(o=e.queries[r].name)&&(function setActiveLayoutClass(t){for(var s=0;s<e.queries.length;s++)shmi.removeClass(document.documentElement,e.queries[s].name);shmi.addClass(document.documentElement,e.queries[t].name),shmi.visuals.session.config&&shmi.visuals.session.config.debug&&console.log("set layout cssClass: "+e.queries[t].name+" "+e.queries[t].threshold)}(r),null!==c)){var m=document.createEvent("Event");m.initEvent("visuals-layout-change",!0,!0),window.dispatchEvent(m),shmi.visuals.session.config&&shmi.visuals.session.config.debug&&console.log("LAYOUT CHANGE ["+c+" => "+o+"]"),shmi.fire("layout-change",{oldLayout:c,layout:o},shmi.visuals.session)}}shmi.loadResource(shmi.c("MEDIA_QUERIES_CONFIG_PATH"),(function(t,s,n){var a;s&&console.error("failed to load media-query configuration: "+n);try{a=JSON.parse(t)}catch(e){console.error("failed to parse media-query configuration: "+n,e)}"object"==typeof a&&Array.isArray(a.queries)&&a.queries.length?(e=a,console.log("[visuals.media-queries] using json defined media-queries: ",n)):console.log("[visuals.media-queries] using built-in media-queries: ",e);for(var o=0;o<e.queries.length;o++)r[e.queries[o].name]=e.queries[o];shmi.onSessionReady((function(){testLayout(),window.addEventListener("resize",testLayout,!1)}))})),shmi.getCurrentLayout=function(){return o},shmi.getCurrentMediaQuery=function(){return r[o]},shmi.getActiveMediaQueries=function(){for(var r=[],o=null,l="",u=0;u<e.queries.length;u++)l="",null===(o=e.queries[u]).threshold&&o.enabled?r.push(o.name):o.enabled&&(e.type===n?l=shmi.evalString(t,o):e.type===a&&(l=shmi.evalString(s,o)),l&&window.matchMedia(l).matches&&r.push(o.name));return r},shmi.getMediaQueries=function(){return e}}();