/**
 * Custom UI-Action 'selectItem'.
 *
 * Description:
 * opens dialog to select item
 */
(function () {
    var actions = shmi.pkg("visuals.session.userActions"); //get reference to userActions object

    actions["selectItem"] = async function (p) {
        const bVirtual = p[0]
        const sItem = p[1]
        const iRow = await cxt.getItem(p[2])

        let sOpt = ""
        let sFS = ""
        let sPrefix = ""
        let sMsg = "Select an item"
        if (bVirtual) {
            for (let i = 0; i < arItemsVirtual.length; i++) {
                console.log(arItemsVirtual[i])
                sOpt += sFS + arItemsVirtual[i]
                sFS = "|"
            }
            sPrefix = "virtual:"
            sMsg = "Select a virtual item"
        } else {
            for (let i = 0; i < arItemsPlc.length; i++) {
                console.log(arItemsPlc[i].name)
                sOpt += sFS + arItemsPlc[i].name
                sFS = "|"
            }
        }
        let sResult = await cxt.msgBox("select", sMsg, "", sOpt, "|", "=")
        if (sResult !== null) {
            const sRowFs = "\n"
            const sColFs = "="

            let arRows = await cxt.getItem(sItem).split(sRowFs)
            let arCols = arRows[iRow].split(sColFs)
            sResult = sPrefix + sResult
            if (arCols.length > 1) sResult += sColFs + arCols[1]
            arRows[iRow] = sResult
            cxt.setItem(sItem, arRows.join(sRowFs))
        }
    };
}());