/**
 * Custom UI-Action 'bitActions'.
 *
 * Description:
 * [Add description here]
 */
(function () {
    var actions = shmi.pkg("visuals.session.userActions"); //get reference to userActions object

    /**
     * UI-Action 'bitActions' implementation
     *
     * @params {any[]} parameters  configured ui-action parameters
     * ---- Initial parameters, needs to be updated manually when changed ----
     * @param {string} parameters[0]  Action (s=Set c=Clear t=Toggle)
     *
     */
    actions["bitActions"] = function (parameters) {
        let sAction = parameters[0]
        let sItemName = parameters[1]
        let iBitNo = parameters[2]
        const im = shmi.requires("visuals.session.ItemManager")
        let iValue = im.readValue(sItemName)
        if (sAction === "s") {
            iValue = cxt.bitSet(iValue, iBitNo)
        } else if (sAction === "c") {
            iValue = cxt.bitClear(iValue, iBitNo)
        } else if (sAction === "t") {
            iValue = cxt.bitToggle(iValue, iBitNo)
        }
        console.log("bitActions " + sAction + " " + sItemName + ":" + iBitNo + "=" + iValue)
        im.writeValue(sItemName, iValue, { skipSameValueCheck: true });
    };
}());