'use strict';
const FILTER_ON = "+"
const FILTER_OFF = ""
const SORT_OFF = "-"
const SORT_STRING = "s"
const SORT_INT = "i"
const SORT_FLOAT = "f"
const SORT_LIST = "l"
const FS_COL = "/"
const FS_DCOL = "\t"
const FS_DROW = "\n"

/**
* reads configuration for all defined Axes and displays it in a table
* @param {bool} bClear true=clear existing content
*/
async function readApps() {
    // read app icon as blob
    // function blob2DataURL(blob, callback, img) {
    //     let fr = new FileReader()
    //     fr.onload = function (e) {
    //         callback(e.target.result, img)
    //     }
    //     fr.readAsDataURL(blob)
    // }
    // function setImg(dataURL, img) {
    //     img.src = dataURL
    // }
    let sCfg = ""
    let sData = ""

    const sMgr = "/package-manager/api/v1"
    let Items = []
    //      array bShow sTitle sValue sUnit
    addItem(Items, true, "", "id", "", FILTER_ON, SORT_STRING, '', '', '260px', 'L')
    addItem(Items, true, "", "enabled", "", FILTER_ON, SORT_STRING, '', '', '80px', 'L')
    addItem(Items, true, "", "title", "", FILTER_ON, SORT_STRING, '', '', '260px', 'L')
    addItem(Items, true, "", "release.version", "", FILTER_ON, SORT_STRING, '', '', '80px')
    addItem(Items, true, "", "summary", "", FILTER_ON, SORT_STRING, '', '', '480px', 'L')
    addItem(Items, false, "", "description", "", FILTER_ON, SORT_STRING, '', '', '200px', 'L')
    sCfg = makeConfig(Items)
    const hideApps = ["Automation Core", "Device Admin", "Setup", "Solutions"]

    // retriev all installed apps
    let jResp = await cxApi.get(`${sMgr}/packages`)
    let jData = jResp.data
    let Apps = [] // array with json objects to enable sorting
    for (let i = 0; i < jData.length; i++) {
        if (jData[i].appType === "app") {
            if (!hideApps.includes(jData[i].title)) {
                let jApp = {}
                // store all app properties defined in Keys[]
                for (let j = 0; j < Items.length; j++) {
                    jApp[Items[j].sValue] = getJsonValue(jData[i], Items[j].sValue)
                }
                Apps.push(jApp)
            }
        }
    }
    // Apps = Apps.sort((a, b) => { return (a.title.toLowerCase() < b.title.toLowerCase()) ? -1 : 1 })
    for (let i = 0; i < Apps.length; i++) {
        if (i > 0) sData += "\n"
        // app icons
        // let img = document.createElement("img")
        // img.style.width = "80px"
        // jResp = await cxApi.get(`${sMgr}/packages/${Apps[i][Items[0].sValue]}/icon`, "blob")
        // blob2DataURL(jResp.data, setImg, img)
        // data columns
        let sCFS = ""
        for (let j = 0; j < Items.length; j++) {
            sData += sCFS + Apps[i][Items[j].sValue]
            sCFS = FS_DCOL
        }
    }
    return {
        "cfg": sCfg,
        "data": sData,
        "msg": "state makeTable"
    }
}
/**
 * reads configuration for all defined Axes and displays it in a table
 * @param {bool} bClear true=clear existing content
 */
async function readLicenses() {
    console.log(`readLicenses`)
    let sCfg = ""
    let sData = ""

    const sMgr = "/license-manager/api/v1"
    let Items = []
    //      array bShow sTitle sValue sUnit
    addItem(Items, true, "license-of", "app", "", FILTER_ON, SORT_STRING, '', '', '200px', 'L')
    addItem(Items, true, "license-title", "title", "", FILTER_ON, SORT_STRING, '', '', '260px', 'L')
    addItem(Items, true, "license-id", "name", "", FILTER_ON, SORT_STRING, '', '', '240px', 'L')
    addItem(Items, true, "", "count", "", FILTER_ON, SORT_INT, '', '', '80px')
    addItem(Items, true, "", "startDate", "", FILTER_ON, SORT_STRING, '', '', '180px', 'L')
    // addItem(Items, true, "", "finalExpirationDate", "")
    addItem(Items, true, "", "isPermanent", "", FILTER_ON, SORT_STRING, '', '', '120px', 'L')
    // addItem(Items, true, "", "description", "")
    sCfg = makeConfig(Items)
    const jLicApps = {
        "SWL-XCx-3DV-3DVIEWERxxxxx-NNNN": "rexroth-3dviewer",
        "SWL-XCx-ECM-ETHERCATMASxx-BANN": "rexroth-",
        "SWL-XCx-IDE-TEXTUALCODExx-NNNN": "rexroth-ide",
        "SWL-XCx-MOT-AXISxxxxxxxxx-NNNN": "rexroth-motion",
        "SWL-XCx-MOT-CARTESIANxxxx-NNNN": "rexroth-motion",
        "SWL-XCx-MOT-STDMOTIONxxxx-NNNN": "rexroth-motion",
        "SWL-XCx-MOT-STDMOTIONxxxx-NNNN": "rexroth-motion",
        "SWL-XCx-PLC-PLCxxxxxxxxxx-BANN": "rexroth-plc",
        "SWL-XCx-PYR-PYTHONRUNTIME-NNNN": "rexroth-python",
        "SWL-XCx-UAS-OPCUASERVERxx-NNNN": "rexroth-opcua-server"
    }

    // retrieve host information
    let jResp = await cxApi.get(`${sMgr}/capabilities`)
    let jData = jResp.data

    // display license properties
    for (let i = 0; i < jData.length; i++) {
        if (i > 0) sData += "\n"
        let sFS = ""
        for (let j = 0; j < Items.length; j++) {
            let sContent = getJsonValue(jData[i], Items[j].sValue)
            if (Items[j].sValue === "app") {
                if (sContent == "") {
                    sContent = (jLicApps[jData[i].name]) ? jLicApps[jData[i].name] : "${app-not-installed}"
                }
            }
            sData += sFS + sContent
            sFS = FS_DCOL
        }
    }
    return {
        "cfg": sCfg,
        "data": sData,
        "msg": "state makeTable"
    }
}
/**
 * reads configuration for all defined Axes and displays it in a table
 * @param {bool} bClear true=clear existing content
 */
async function readHostInfo() {
    console.log(`readHostInfo`)
    let sCfg = ""
    let sData = ""

    const sMgr = "/system/api/v1"
    let Items = []
    //      array bShow sTitle sValue sUnit
    // system/info
    addItem(Items, true, "", "hostname")
    addItem(Items, true, "", "operatingSystem")
    addItem(Items, true, "", "osVersion")
    addItem(Items, true, "", "architecture")
    addItem(Items, true, "", "macAddress")
    addItem(Items, true, "", "virtualized")

    let ItemsCx = []
    //      array bShow sTitle sValue sUnit
    addItem(ItemsCx, true, "", "typePlateType")
    addItem(ItemsCx, true, "", "typeCode")
    addItem(ItemsCx, true, "", "serialNumber")
    addItem(ItemsCx, true, "", "materialIndex")
    addItem(ItemsCx, true, "", "hardwareRevision")

    let ItemsCx1 = []
    addItem(ItemsCx1, true, "time", "system/info/time")
    addItem(ItemsCx1, true, "timezone", "system/info/timezone")
    
    addItem(ItemsCx1, true, "boot-count", "system/health/boot-count/value")
    addItem(ItemsCx1, true, "operating-hours", "system/health/operation-hours/value")
    /*
    addItem(ItemsCx1, true, "", "system/health/temperature-core/value")
    addItem(ItemsCx1, true, "", "system/health/battery/value")
    */
    let jCfg = {}
    jCfg.title = "${varName}/${varValue}"
    jCfg.filter = "+/+"
    jCfg.format = "/"
    jCfg.list = ""
    jCfg.sort = SORT_STRING + FS_COL + SORT_STRING
    jCfg.unit = ""
    jCfg.width = "200px/400px"
    jCfg.talign = "L/L"
    sCfg = JSON.stringify(jCfg)

    // retrieve host information
    let jResp = await cxApi.get(`${sMgr}/info`)
    let jData = jResp.data
    // show properties
    for (let i = 0; i < Items.length; i++) {
        sData += shmi.localize("${" + Items[i].sTitle + "}")
        if (Items[i].sTitle === "virtualized") {
            Items[i].sValue = (Items[i].sValue === undefined) ? "false" : Items[i].sValue
        }
        sData += FS_DCOL + getJsonValue(jData, Items[i].sValue)
        sData += FS_DROW
    }
    // jResp = await cxApi.get(`${sMgr}/info/architecture`)
    // jData = jResp.data

    // retrieve type plate
    jResp = await cxApi.get(`${sMgr}/typeplate`)
    jData = jResp.data
    // show all type plate properties
    for (let i = 0; i < ItemsCx.length; i++) {
        sData += shmi.localize("${" + ItemsCx[i].sTitle + "}")
        let sVal = getJsonValue(jData, ItemsCx[i].sValue)
        // virtual control does not have all properties
        sVal = (sVal === undefined) ? "---" : sVal
        sData += FS_DCOL + sVal + FS_DROW
    }

    const sMgr2 = "/automation/api/v2"
    for (let i = 0; i < ItemsCx1.length; i++) {
        let sCmd = `${sMgr2}/nodes/${ItemsCx1[i].sValue}`
        try {
            jResp = await cxApi.get(sCmd)
            let sVal = jResp.data.value
            if (ItemsCx1[i].sTitle==="operating-hours") sVal = jResp.data.value.toFixed(0)
            console.log(sCmd + "=" + sVal)
            sData += shmi.localize("${" + ItemsCx1[i].sTitle + "}") + FS_DCOL + sVal + FS_DROW
        } catch { }
    }

    return {
        "cfg": sCfg,
        "data": sData,
        "msg": "state makeTable"
    }
}
/**
 * reads configuration for all defined Axes and displays it in a table
 * @param {bool} bClear true=clear existing content
 */
async function readKinematics() {
    console.log(`readKinematics}`)
    let sCfg = ""
    let sData = ""

    const sMgr = "/automation/api/v2"
    let Items = []
    //      array bShow sTitle sValue sUnit
    addItem(Items, true, "", "kinematic", "", "", "", "", "", "", "L")
    addItem(Items, true, "", "axsName", "", "", "", "", "", "", "L")
    addItem(Items, true, "", "axsMeaning", "", "", "", "", "", "", "L")
    addItem(Items, true, "", "limits.vel")
    addItem(Items, true, "none", "limits.velUnit", "", "", "", "", "", "", "L")
    addItem(Items, true, "", "limits.acc")
    addItem(Items, true, "none", "limits.accUnit", "", "", "", "", "", "", "L")
    addItem(Items, true, "", "limits.dec")
    addItem(Items, true, "none", "limits.decUnit", "", "", "", "", "", "", "L")
    addItem(Items, true, "", "limits.jrkAcc")
    addItem(Items, true, "none", "limits.jrkAccUnit", "", "", "", "", "", "", "L")
    addItem(Items, true, "", "limits.jrkAcc")
    addItem(Items, true, "none", "limits.jrkDecUnit", "", "", "", "", "", "", "L")
    sCfg = makeConfig(Items)

    let arKin = []
    // retriev all axes names
    let jResp = await cxApi.get(`${sMgr}/nodes/motion/kin?type=browse`)
    arKin = jResp.data.value // kinematic names

    // display all kinematics
    for (let i = 0; i < arKin.length; i++) {
        // display kin config
        jResp = await cxApi.get(`${sMgr}/nodes/motion/kin/${arKin[i]}/cfg`)

        let sFS = ""
        for (let j = 0; j < Items.length; j++) {
            if (Items[j].sValue === "kinematic") {
                sData += sFS + arKin[i]
            } else if (["axsName", "axsMeaning"].includes(Items[j].sValue)) {
                sData += sFS
            } else {
                sData += sFS + getJsonValue(jResp.data.value, Items[j].sValue)
            }
            sFS = FS_DCOL
        }
        sData += FS_DROW
        // display axes of kinematics
        let arAxes = jResp.data.value.axsCfg
        for (let j = 0; j < arAxes.length; j++) {
            let iDisplayCnt = 0
            sFS = ""
            for (let k = 0; k < Items.length; k++) {
                if (["axsName", "axsMeaning"].includes(Items[k].sValue)) {
                    iDisplayCnt++
                    sData += sFS + getJsonValue(arAxes[j], Items[k].sValue)
                } else if (iDisplayCnt < 2) {
                    sData += sFS
                }
                sFS = FS_DCOL
            }
            sData += FS_DROW
        }
    }
    return {
        "cfg": sCfg,
        "data": sData,
        "msg": "state makeTable"
    }
}
/**
 * reads configuration for all defined Axes and displays it in a table
 * @param {bool} bClear true=clear existing content
 */
async function readAxes() {
    let sCfg = ""
    let sData = ""
    const sMgr = "/automation/api/v2"
    let Items = []
    //   arItems, bShow sTitle sJsonKey sUnit sFilter sSortType sFormatFct sListName sWidth sTAlign
    addItem(Items, true, "", "axis", "", FILTER_ON, SORT_STRING, "", "", "50px", "L")
    addItem(Items, true, "", "limits.posMin", "", FILTER_ON, SORT_FLOAT, "", "", "76px")
    addItem(Items, true, "none", "limits.posMinUnit", "", FILTER_ON, SORT_STRING, "", "", "30px")

    addItem(Items, true, "", "limits.posMax", "", FILTER_ON, SORT_FLOAT, "", "", "76px")
    addItem(Items, true, "none", "limits.posMaxUnit", "", FILTER_ON, SORT_STRING, "", "", "30px", "L")

    addItem(Items, true, "", "limits.velNeg", "", FILTER_ON, SORT_FLOAT, "", "", "76px")
    addItem(Items, true, "none", "limits.velNegUnit", "", FILTER_ON, SORT_STRING, "", "", "30px", "L")

    addItem(Items, true, "", "limits.velPos", "", FILTER_ON, SORT_FLOAT, "", "", "76px")
    addItem(Items, true, "none", "limits.velPosUnit", "", FILTER_ON, SORT_STRING, "", "", "40px", "L")

    addItem(Items, true, "", "limits.acc", "", FILTER_ON, SORT_FLOAT, "", "", "70px")
    addItem(Items, true, "none", "limits.accUnit", "", FILTER_ON, SORT_STRING, "", "", "30px", "L")

    addItem(Items, true, "", "limits.dec", "", FILTER_ON, SORT_FLOAT, "", "", "70px")
    addItem(Items, true, "none", "limits.decUnit", "", FILTER_ON, SORT_STRING, "", "", "30px", "L")

    addItem(Items, true, "", "limits.jrkAcc", "", FILTER_ON, SORT_FLOAT, "", "", "76px")
    addItem(Items, true, "none", "limits.jrkAccUnit", "", FILTER_ON, SORT_STRING, "", "", "30px", "L")

    addItem(Items, true, "", "limits.jrkDec", "", FILTER_ON, SORT_FLOAT, "", "", "76px")
    addItem(Items, true, "none", "limits.jrkDecUnit", "", FILTER_ON, SORT_STRING, "", "", "30px", "L")

    addItem(Items, true, "", "properties.axsType", "", FILTER_ON, SORT_STRING, "", "", "76px", "L")
    addItem(Items, true, "", "properties.modulo", "", FILTER_ON, SORT_STRING, "", "", "30px", "L")

    addItem(Items, true, "", "properties.moduloValue", "", FILTER_ON, SORT_FLOAT, "", "", "76px")
    addItem(Items, true, "none", "properties.moduloValueUnit", "", FILTER_ON, SORT_STRING, "", "", "30px", "L")

    sCfg = makeConfig(Items)

    let arAxes = []
    // retriev all axes names
    let jResp = await cxApi.get(`${sMgr}/nodes/motion/axs?type=browse`)
    arAxes = jResp.data.value

    // display all axes
    for (let i = 0; i < arAxes.length; i++) {
        if (i > 0) sData += FS_DROW
        let sCmd = `${sMgr}/nodes/motion/axs/${arAxes[i]}/cfg`
        jResp = await cxApi.get(sCmd)

        let sCFS = ""
        for (let j = 0; j < Items.length; j++) {
            if (Items[j].sValue === "axis") {
                sData += sCFS + arAxes[i]
            } else {
                let value = getJsonValue(jResp.data.value, Items[j].sValue)
                let unit = (Items[j].sUnit === "") ? "" : " " + getJsonValue(jResp.data.value, Items[j].sUnit)
                if (typeof (value) === "number") {
                    sData += sCFS + value.toFixed(2) + unit
                } else if (Items[j].sValue === "properties.modulo") {
                    sData += sCFS + ((value) ? "Modulo" : "Absolute")
                } else {
                    sData += sCFS + value.replace("^2", "²").replace("^3", "³")
                }
            }
            sCFS = FS_DCOL
        }
    }
    return {
        "cfg": sCfg,
        "data": sData,
        "msg": "state makeTable"
    }
}
/**
 * directory listing
 * @param {string}  sDir          dir path to list
 * @param {string}  sExt          file extension to list, if ''=>list all
 * @param {boolean} bFile         true=list files false=don't list files
 * @param {boolean} bDir          true=list dirs false=don't list dirs
 * @param {string}  sSolutionName soltion to list
 */
async function readDirListing(sDir, sExt = "", bFile = true, bDir = false, sSolutionName = "DefaultSolution") {
    let sCfg = ""
    let sData = ""
    console.log(`readPlcVars`)
    let jCfg = {}
    jCfg.title = "Name/Size [Byte]/Date"
    jCfg.filter = "+/+/+"
    jCfg.format = ""
    jCfg.list = ""
    jCfg.sort = SORT_STRING + FS_COL + SORT_INT + FS_COL + SORT_STRING
    jCfg.unit = ""
    jCfg.talign = "L/R/L"
    jCfg.width = "/60px/160px"
    jCfg.sortCol = 0
    jCfg.sortUp = false
    sCfg = JSON.stringify(jCfg)
    let arData = await dirList(sDir, sExt, bFile, bDir, sSolutionName)

    for (let i = 0; i < arData.length; i++) {
        let me = arData[i]
        if (!me.isDir) { // ignore folders
            if (bFile) {
                if (me.name.endsWith(sExt)) {
                    sData += me.name + FS_DCOL + me.size + FS_DCOL + me.modified + FS_DROW
                }
            }
        } else {
            if (bDir) {
                sData += me.name + FS_DCOL + FS_DCOL + FS_DROW
            }
        }
    }
    if (bDir) {
        sData += "/.." + FS_DCOL + FS_DCOL + FS_DROW
    }
    return {
        "cfg": sCfg,
        "data": sData,
        "msg": "state updateTable"
    }
}
/**
 * returns array with items in directory
 * @param {string}  sDir          dir path to list
 * @param {string}  sExt          file extension to list, if ''=>list all
 * @param {boolean} bFile         true=list files false=don't list files
 * @param {boolean} bDir          true=list dirs false=don't list dirs
 * @param {string}  sSolutionName soltion to list
 * @returns {object[]} name,isDir (only for files) size,modified
 */
async function dirList(sDir, sExt = "", bFile = true, bDir = false, sSolutionName = "DefaultSolution") {
    const sMgr = "/solutions/api/v1"
    let jResp = await cxApi.get(`${sMgr}/solutions/${sSolutionName}/filesystem?dir=${sDir}&depth=1`)
    let arItems = [] // items of directory
    for (let i = 0; i < jResp.data.entries.length; i++) {
        let me = jResp.data.entries[i]
        if (!me.isContainer) { // ignore folders
            if (bFile) {
                let sName = me.name.replace(/"/g, '')
                if (sName.endsWith(sExt)) {
                    let sModified = me.modified.replace(/T/, ' ').replace(/Z/, '').replace(/\..*/, '')
                    let jItem = {}
                    jItem.name = sName
                    jItem.size = me.size
                    jItem.modified = sModified
                    jItem.isDir = false
                    arItems.push(jItem)
                }
            }
        } else {
            if (bDir) {
                let sName = me.name.replace(/"/g, '')
                let jItem = {}
                jItem.name = "/" + sName
                jItem.isDir = true
                arItems.push(jItem)
            }
        }
    }
    return arItems.sort(cxt.sortByKey(false, "name", null, cxt.parseToLower, null))
}
async function readPlcVars() {
    // let sCfg = ""
    // let sData = ""
    // console.log(`ReadOpcVars ${bClear}`)
    // const sMgr = "/automation/api/v2/nodes"
    // let Items = []
    // addItem(Items, true, "strLimitA", "/plc/app/Application/sym/GVL_SysInfo/strLimitA", "")
    // addItem(Items, true, "iLimitB", "/plc/app/Application/sym/GVL_SysInfo/iLimitB", "")
    // addItem(Items, true, "rLimitC", "/plc/app/Application/sym/GVL_SysInfo/rLimitC", "")
    // let jCfg = {}
    // jCfg.title = "Name/Value"
    // jCfg.filter = "+/+"
    // jCfg.format = "/"
    // jCfg.list = ""
    // jCfg.sort = SORT_STRING + FS_COL + SORT_STRING
    // jCfg.unit = ""
    // sCfg = JSON.stringify(jCfg)

    // // retrieve Sys information
    // for (let i = 0; i < Items.length; i++) {
    //     let jResp = await cxApi.get(`${sMgr}/${Items[i].sValue}`)
    //     let jData = jResp.data
    //     let to = typeof (jData.value)
    //     if (typeof (jData.value) === "number") {
    //         if (jData.value % 1 !== 0)
    //             jData.value = cxt.float2String(jData.value, 4)
    //     }

    //     sData += Items[i].sTitle + FS_DCOL + jData.value + FS_DROW
    // }
    // await cxt.setItem(TAB_CFG, sCfg, true)
    // await cxt.setItem(TAB_DATA, sData, true)
    // cxt.setItem(TAB_MSG, "state makeTable")
}

/*** support functions ********/
/**
 * Create table and appends it to oParent
 * @param {element} oParent parent element
 * @returns created table element
 */

/**
 * Add new item to array which is used for display
 * @param {array} arItems array storing data
 * @param {boolean} bShow     true=show item false=hide item
 * @param {string} sTitle     description of item
 * @param {string} sJsonKey   json key of value
 * @param {string} sUnit      json key of unit (optional)
 * @param {string} sFilter    filter function FILTER_ON FILTER_OFF
 * @param {string} sSortType  sort type SORT_FLOAT, *_INT, *_LIST, *_STRING, _OFF
 * @param {string} sFormatFct JS format function
 * @param {string} sListName  text list name
 * @param {string} sWidth     width of column
 * @param {string} sTAlign    text align L=left C=Center R=Right
 */
function addItem(arItems, bShow = true, sTitle, sJsonKey, sUnit = "", sFilter = "", sSortType = "", sFormatFct = "", sListName = "", sWidth = "", sTAlign = "R") {
    if (bShow) {
        let jTmp = {}
        jTmp.sTitle = (sTitle === "") ? sJsonKey : sTitle
        jTmp.sValue = sJsonKey
        jTmp.sUnit = sUnit
        jTmp.sFilter = sFilter
        jTmp.sSortType = sSortType
        jTmp.sFormatFct = sFormatFct
        jTmp.sListName = sListName
        jTmp.sWidth = sWidth
        jTmp.sTAlign = sTAlign
        // add item to array
        arItems.push(jTmp)
    }
}
/**
 * Returns value of a json key, which can contain multiple children
 * @param {json} jData parent object
 * @param {string} sKeys key with multiple level splitted by "." e.g. release.version
 */
function getJsonValue(jData, sKeys) {
    let jTmp = jData
    let arKeys = sKeys.split(".")
    for (let i = 0; i < arKeys.length; i++) {
        jTmp = jTmp[arKeys[i]]
    }
    return jTmp
}
/**
 * create table config object
 * @param {object[]} Items 
 * @returns 
 */
function makeConfig(Items) {
    let sHeader = ""
    let sFilter = ""
    let sFormat = ""
    let sList = ""
    let sSort = ""
    let sWidth = ""
    let sTAlign = ""
    let sFS = ""
    for (let i = 0; i < Items.length; i++) {
        // sHeader += sFS + Items[i].sTitle
        sHeader += sFS + "${" + Items[i].sTitle + "}"
        sFilter += sFS + Items[i].sFilter
        sFormat += sFS + Items[i].sFormatFct
        sList += sFS + Items[i].sListName
        sSort += sFS + Items[i].sSortType
        sWidth += sFS + Items[i].sWidth
        sTAlign += sFS + Items[i].sTAlign
        sFS = FS_COL
    }
    let jCfg = {}
    jCfg.title = sHeader
    jCfg.filter = sFilter
    jCfg.format = sFormat
    jCfg.list = sList
    jCfg.sort = sSort
    jCfg.width = sWidth
    jCfg.unit = ""
    jCfg.talign = sTAlign
    return JSON.stringify(jCfg)

}

const cxApi = new function ctrlxApi() {
    // private variables
    let _this = this        // refernce to me, requested for funcs called by events
    // let _ApiServer = "/automation/api/v2"
    let _sOrigin = ""
    // let _sIdmToken = null
    let _jConfig = null
    let _jCxLogin = {}
    _this.init = async function (itemUser = 'sUser', itemPassword = 'sPassword', itemTokenOk = 'virtual:idmTokenValid', timeout = 8000) {
        _jCxLogin = {
            sHost: document.location.origin,
            itemUser: itemUser,
            itemPassword: itemPassword,
            LoggedIn: false,
            jConfig: {
                // `timeout` specifies the number of milliseconds before the request times out.
                // If the request takes longer than `timeout`, the request will be aborted.
                timeout: timeout, // default is `0` (no timeout)

                // `responseType` indicates the type of data that the server will respond with
                // options are: 'arraybuffer', 'document', 'json', 'text', 'stream'
                //   browser only: 'blob'
                // responseType: 'json', // default
                responseType: 'json',

                // `baseURL` will be prepended to `url` unless `url` is absolute.
                // It can be convenient to set `baseURL` for an instance of axios to pass relative URLs
                // to methods of that instance.
                baseURL: _jCxLogin.sHost
            },
            sVirtualItemTokenOk: itemTokenOk
        }
    }
    _this.loggedIn = () => { return _jCxLogin.LoggedIn }
    _this.idmToken = () => { return _jCxLogin.sIdmToken }
    _this.host = () => { return _jCxLogin.sHost }

    /**
     * calls getIdmToken
     * @param {boolean} bForceLogin TRUE:force login even if logged in
     * @returns {boolean} TRUE:ok FALSE:failed
     */
    _this.login = async function (bForceLogin = true) {
        return getIdmToken(false, bForceLogin)
    }
    /**
    * gets authentification token via axios library and ctrlX REST API
    * @param {bool} bInvalidURL 
    * @param {bool} bForceLogin TRUE: force login, even if yet logged in
    * @return true: logIn succesful false: failed
    */
    async function getIdmToken(bInvalidURL = false, bForceLogin = false) {
        if ((_jCxLogin.LoggedIn) && (bForceLogin === false)) return true

        const im = shmi.requires("visuals.session.ItemManager");

        let bError = false
        let sResult = ""
        let sReq = ""
        let sHost = _jCxLogin.sHost

        // check if all data are provided
        let sUser = await cxt.getItem(_jCxLogin.itemUser, true)
        let sPwd = await cxt.getItem(_jCxLogin.itemPassword, true)
        if (sUser === "" || sPwd === "") {
            sResult += shmi.localize("${emptyCtrlXCoreLoginData}"); // The Login data for your ctrlX is empty.Go to Settings and insert your username and password for your ctrlX CORE.
            bError = true;
        }

        if (bError) {
            cxt.msgBox("Warning", sResult);
            window.sessionStorage.removeItem("idm_token");
            _jCxLogin.LoggedIn = false;
            return false;
        }

        // login to identify me 
        try {
            sReq = sHost + '/identity-manager/api/v1.0/auth/token';
            var response = await axios.post(sReq, { name: sUser, password: sPwd });

            if (response === null) {
                window.sessionStorage.removeItem("idm_token");
                im.writeValue(_jCxLogin.sVirtualItemTokenOk, 0);
                sResult += shmi.localize("${axiosCallFailed}") //`AXIOS call failed, check if package-axios is installed.`;
                cxt.msgBox("Error", sResult);
                _jCxLogin.LoggedIn = false;
                return false;
            }
        } catch (err) {
            window.sessionStorage.removeItem("idm_token");
            im.writeValue(_jCxLogin.sVirtualItemTokenOk, 0);
            sResult += shmi.localize("${axiosPostFailed}"); //`AXIOS unable to post request: ${err}\n${sReq}\nPlease check ip, user, password, ctrlX & network`;
            if (bInvalidURL === false) cxt.msgBox("Error", sResult);
            _jCxLogin.LoggedIn = false;
            return false;
        }
        _jCxLogin.sIdmToken = response.data.access_token;
        _jCxLogin.LoggedIn = true
        _jCxLogin.jConfig.headers = { authorization: 'Bearer ' + _jCxLogin.sIdmToken }
        // store token in session storage
        window.sessionStorage.setItem("idm_token", _jCxLogin.sIdmToken);
        im.writeValue(_jCxLogin.sVirtualItemTokenOk, 1);
        return true;
    }

    _this.put = async function (sRequest, jParam, sType = "json") {
        if (!await getIdmToken()) {
            cxt.abortJS("")
            return null
        }
        try {
            _jConfig.responseType = sType
            let jRes = await axios.put(sRequest, jParam, _jConfig)
            // unknown API command does not provide a type => use it to detect a valid response
            if (!jRes.data.type && false) {
                // happens, e.g. when invalid api server is used
                cxt.abortJS("Invalid ctrlX API command:\n" + _sOrigin + sRequest)
                return null
            } else {
                return jRes
            }
        } catch (err) {
            cxt.abortJS(err.message + " " + err.code + "\nRequest:\n" + _sOrigin + sRequest)
            return null
        }
    }

    _this.post = async function (sRequest, jParam, sType = "json") {
        if (!await getIdmToken()) {
            cxt.abortJS("")
            return null
        }
        try {
            _jConfig.responseType = sType
            let jRes = await axios.post(sRequest, jParam, _jConfig)
            // unknown API command does not provide a type => use it to detect a valid response
            if (!jRes.data.type && false) {
                // happens, e.g. when invalid api server is used
                cxt.abortJS("Invalid ctrlX API command:\n" + _sOrigin + sRequest)
                return null
            } else {
                return jRes
            }
        } catch (err) {
            cxt.abortJS(err.message + " " + err.code + "\nRequest:\n" + _sOrigin + sRequest)
            return null
        }
    }
    // retrieves authorization token, if not set and call axios.get(sRequest)
    // @param {string} sRequest request string without host, starting with /
    // @return null: error jObject: response of API command
    _this.get = async function (sRequest, sType = "json") {
        if (!await getIdmToken()) {
            // cxt.abortJS("")
            return null
        }
        try {
            let _jConfig = _jCxLogin.jConfig
            _jConfig.responseType = sType
            let jRes = await axios.get(sRequest, _jConfig)
            // unknown API command does not provide a type => use it to detect a valid response
            if (!jRes.data.type && false) {
                // happens, e.g. when invalid api server is used
                cxt.abortJS("Invalid ctrlX API command:\n" + _sOrigin + sRequest)
                return null
            } else {
                return jRes
            }
        } catch (err) {
            cxt.abortJS(err.message + " " + err.code + "\nRequest:\n" + _sOrigin + sRequest)
            return null
        }
    }

}