// 'use strict';
(function () {
    var MODULE_NAME = "start-up",
        ENABLE_LOGGING = false,
        RECORD_LOG = false,
        logger = shmi.requires("visuals.tools.logging").createLogger(MODULE_NAME, ENABLE_LOGGING, RECORD_LOG),
        fLog = logger.fLog,
        log = logger.log,
        module = shmi.pkg(MODULE_NAME);
    /**
     * This function will be called each time a local-script will be enabled.
     * @param {LocalScript} self instance reference of local-script control
     */
    module.run = async function (self) {
        //console.clear()
        console.warn("###################### Start-up #######################")
        const im = shmi.requires("visuals.session.ItemManager");
        const SHOW_KP = "virtual:bShowKeypad"
        const MSG_TOP = "GVL_BASE.strMsgTop"
        const OP_MODE = "GVL_BASE.enStatusOpMode"
        const ALARM1 = "GVL_BASE.arAppAlarm.1.enErrID"
        const APE_DEV_AXIS_CFG_INVALID = 1001
        const APE_DEV_KIN_CFG_INVALID = 1002

        const JOG_MINUS = "GVL_BASE.stHMIMultiAxes.Ctrl_bSetupModeJogMinus"
        // const sSessionCnt = "virtual:iSessionCount"
        const sSessionCnt = "iSessionCount"
        const OP_INIT = 4
        // While ctrlX OpcUA server does not yet support
        // unicode strings, they are converted to UTF8 in PLC
        // and converted to UTF16 in HMI
        const RCP_FILE_NAME = "GVL_CUSTOMER.stRecipeMgr.strName"
        const V_RCP_FILE_NAME = "virtual:strRecipeName"

        const RCP_EDIT_FILE_NAME = "GVL_CUSTOMER.stRecipeMgr.strNameEdit"
        const V_RCP_EDIT_FILE_NAME = "virtual:strRecipeNameEdit"

        let tok = null
        let subscrSI = null
        // disable context menu for window and all children
        window.addEventListener("contextmenu", e => e.preventDefault());
        // if (is_touch_enabled())
        //     console.log("Touch")
        // else
        //     console.log("NO TOUCH")
        setCss(); // read css colors

        // disable tabulators dependent on user group
        const currentUser = shmi.visuals.session.UserManager.currentUser
        let bHide = true
        for (let i = 0; i < arTabUserGroupsShow.length; i++)
            if (currentUser.groupList.includes(arTabUserGroupsShow[i]))
                bHide = false
        if (bHide) {
            let sTabsCssHide = ""
            for (const key in cssHideTabs) {
                sTabsCssHide += cssHideTabs[key] + "\n";
            }
            const myDoc = document
            let oStyle = myDoc.createElement('style')
            oStyle.setAttribute('type', 'text/css');
            oStyle.appendChild(myDoc.createTextNode(sTabsCssHide));

            let oHead = myDoc.getElementsByTagName('head')[0]
            cssTmp = oHead.appendChild(oStyle);
        }


        // check if only a single session is running
        if (bCfgSingleSession) {
            // redirect to error HTML page, when 2nd client is started
            // to not check for WebIQ preview and localhost, because
            // Designer needs an instance, too
            if (!["", "localhost"].includes(window.location.hostname)) {
                subscrSI = im.subscribe([sSessionCnt], (name, value, type) => {
                    if (name === sSessionCnt) {
                        // im.writeValue("virtual:" + sSessionCnt, value)
                        if (value > 1) {
                            let loc = window.location
                            let sRedirect = `${loc.href}singleInstance.htm`
                            loc.replace(sRedirect)
                        } else {
                            // stop listening for 1st client, to avoid stopping of it
                            // when a 2nd client tries to start
                            //
                            // wait a moment until all updates of value are sent, because
                            // sometimes multiple values are sent sequentielly (1,2)
                            setTimeout(() =>
                                subscrSI.unlisten(), 500)
                        }

                    }
                });
            }
        }
        cxt.setItem("virtual:bCfgHideHelp", bCfgHideHelp)
        cxt.setItem("virtual:bCfgHideFullscreen", bCfgHideFullscreen)
        cxt.setItem("virtual:bCfgHideKinPosInHeader", bCfgHideKinPosInHeader)
        cxt.setItem("virtual:bCfgHideCtrlxName", bCfgHideCtrlxName)
        cxt.setItem("virtual:bCfgHideMenuToggle", bCfgHideMenuToggle)
        if (iCfgHideVirtualKeypad < 0)
            cxt.setItem(SHOW_KP, cxt.isTouchEnabled())
        else if (iCfgHideVirtualKeypad === 0)
            cxt.setItem(SHOW_KP, false)
        else
            cxt.setItem(SHOW_KP, true)

        // check connection via heartbeat
        if (iCfgHeartbeatInterval > 0) {
            let bConnected = false
            do { // wait until connected to avoid parallel checks
                await cxt.wait(1000)
                try {
                    bConnected = await cxt.checkHeartbeat(HEARTBEAT_PLC)
                } catch (e) {
                    bConnected = false
                }
            } while (!bConnected)
            setInterval(() => { cxt.checkHeartbeat(HEARTBEAT_PLC) }, iCfgHeartbeatInterval * 1000)
        }

        // wait until mode init is exited
        let iOpMode = OP_INIT
        let bVisible = false
        do {
            await cxt.wait(1000)
            iOpMode = await cxt.getItem(OP_MODE)
            let iAlarm = await cxt.getItem(ALARM1)
            if (!bVisible) {
                if (iAlarm === APE_DEV_AXIS_CFG_INVALID) {
                    cxt.msgTop('error', '${cfg-error-AxInterface}', -1)
                    bVisible = true
                } else if (iAlarm === APE_DEV_KIN_CFG_INVALID) {
                    cxt.msgTop('error', '${cfg-error-KinInterface}', -1)
                    bVisible = true
                }
            }
        } while (iOpMode === OP_INIT)
        if (!bCfgHideSingleSessionInfo)
            cxt.msgBox("info", "${singleSessionInfo}")
        activateBlink("virtual:bBlinkSlow")
        tok = im.subscribe([SHOW_KP, MSG_TOP, RCP_FILE_NAME, RCP_EDIT_FILE_NAME, SCRIPT_FILE_NAME, OP_MODE, JOG_MINUS],
            async function (name, value, type) {
                if (name === RCP_FILE_NAME) {
                    let sTmp = shmi.from_utf8(value)
                    cxt.setItem(V_RCP_FILE_NAME, sTmp)
                } else if (name === RCP_EDIT_FILE_NAME) {
                    let sTmp = shmi.from_utf8(value)
                    cxt.setItem(V_RCP_EDIT_FILE_NAME, sTmp)
                } else if (name === SCRIPT_FILE_NAME) {
                    let sTmp = shmi.from_utf8(value)
                    const VISUAL_PATH = "/scripts/bosch/tiger/"
                    const TEXT_PATH = "/script/"
                    const arW = sTmp.split("/")
                    if (sTmp.startsWith(VISUAL_PATH))
                        sTmp = "VISUAL: " + arW[arW.length - 1]
                    else
                        sTmp = "TEXT: " + arW[arW.length - 1]
                    cxt.setItem(V_SCRIPT_FILE_NAME, sTmp)
                } else if (name === SHOW_KP) {
                    cxt.keypadEnable((value == 0) ? false : true)
                } else if (name === OP_MODE) {
                    if (value == OP_INIT)
                        cxt.overlayWait(true)
                    else
                        cxt.overlayWait(false)
                } else if (name === MSG_TOP) {
                    if (value === null) return
                    if (value.length === 0) return
                    let jMsg = {}
                    try {
                        jMsg = JSON.parse(value)
                    } catch (e) {
                        jMsg.type = "Error"
                        jMsg.msg = "JSON parsing failed:\n${value}"
                    }
                    cxt.msgTop(jMsg.type, shmi.from_utf8(jMsg.msg))
                    cxt.setItem(MSG_TOP, '')
                }
            });
        (cxt.isWebIqPreview()) ? im.writeValue("virtual:isWebIqPreview", true) : im.writeValue("virtual:isWebIqPreview", false)

        await loginCore()

        //cxt.setItem("virtual:iMenuMain", 5)

        /* called when this local-script is disabled */
        self.onDisable = function () {
            if (subscrSI) subscrSI.unlisten()
            tok.unlisten()
            self.run = false; /* from original .onDisable function of LocalScript control */
        };
    };

    // MODULE CODE - END
    fLog("module loaded");
})();

function setCss() {
    /**
     * callback function to write colors of active css group
     */
    const im = shmi.requires("visuals.session.ItemManager");
    const cancelable = shmi.onReady({
        controls: {},
        items: {
            item0: "iCssSelected",
            item1: "sCssGroup[0]",
            item2: "sCssGroup[1]",
            item3: "sCssGroup[2]",
            item4: "sCssGroup[3]",
            item5: "virtual:iMenuMain",
            item6: "virtual:bSimulateCommunication"
        },
        resources: {}
    }, function (resolved) {
        cssThemeLoad(false);
    });
}

function activateBlink(sItem) {
    let iSlow = -1
    setInterval(() => {
        const im = shmi.requires("visuals.session.ItemManager");
        iSlow = (iSlow) ? 0 : 1
        im.writeValue(sItem, iSlow)
    }, 1000)
}