(function () {
    var MODULE_NAME = "start-up-sys-info",
        ENABLE_LOGGING = false,
        RECORD_LOG = false,
        logger = shmi.requires("visuals.tools.logging").createLogger(MODULE_NAME, ENABLE_LOGGING, RECORD_LOG),
        fLog = logger.fLog,
        log = logger.log,
        module = shmi.pkg(MODULE_NAME);

    module.run = async function (self) {
        try {
            // call sys-info for axes when screen is opened
            const p = [{
                name: "_callFuncs",
                params: ["sys-info", "axes"]
            }];
            new shmi.visuals.core.UiAction(p).execute();
            cxt.setItem("virtual:iSysInfoID", 0)
        } catch { }


        // called when local-script is disabled
        self.onDisable = function () {
            self.run = false; /* from original .onDisable function of LocalScript control */
        };
    };

    // MODULE CODE - END
    fLog("module loaded");
})();
