(function () {
    'use strict'
    var MODULE_NAME = "start-up-palletizing",
        ENABLE_LOGGING = false,
        RECORD_LOG = false,
        logger = shmi.requires("visuals.tools.logging").createLogger(MODULE_NAME, ENABLE_LOGGING, RECORD_LOG),
        fLog = logger.fLog,
        log = logger.log,
        module = shmi.pkg(MODULE_NAME);

    // MODULE CODE - START
    // private variables
    // private functions

    /**
     * This function will be called each time a local-script will be enabled.
     * @param {LocalScript} self instance reference of local-script control
     */
    module.run = function (self) {
        const im = shmi.requires("visuals.session.ItemManager")
        // cxt.onReadyCheck(MODULE_NAME, 2000); // check after 2s if onReady() fired
        // cxt.setItem("GVL_CUSTOMER.stPlaceMgr.strCmd", "cmd updateTable", true)
        let sTableName = ".cx-table-pal"
        const cancelable = shmi.onReady({
            controls: { myTable: sTableName }
        }, function (resolved) {
            // cxt.onReadyOk(MODULE_NAME);  // set flag, callback is executed
        });
        const SVG_STRING = "GVL_CUSTOMER.strPalletizerSvg"
        const SVG_STRING2 = "GVL_CUSTOMER.strPalletizerSvg2"
        
        let tok=im.subscribe([SVG_STRING, SVG_STRING2],
            async function (name, value, type) {
                if (name===SVG_STRING){
                    let x = cxt.getCtrl("box-svg").marginCompensator
                    x.innerHTML = value
                } else if (name===SVG_STRING2) {
                    let x = cxt.getCtrl("box-svg-level").marginCompensator
                    x.innerHTML = value
                }
            });


        /* called when this local-script is disabled */
        self.onDisable = function () {
            tok.unlisten()
            cancelable.cancel();
            self.run = false; /* from original .onDisable function of LocalScript control */
        };
    };


    // MODULE CODE - END
    fLog("module loaded");
})();



