(function () {
    var MODULE_NAME = "start-up-color-theme",
        ENABLE_LOGGING = false,
        RECORD_LOG = false,
        logger = shmi.requires("visuals.tools.logging").createLogger(MODULE_NAME, ENABLE_LOGGING, RECORD_LOG),
        fLog = logger.fLog,
        log = logger.log,
        module = shmi.pkg(MODULE_NAME);

    /**
     * Implements local-script run function.
     *
     * This function will be called each time a local-script will be enabled.
     *
     * @param {LocalScript} self instance reference of local-script control
     */
    module.run = function (self) {
        const im = shmi.requires("visuals.session.ItemManager");
        
        let tok = im.subscribe(["iCssSelected", "sCssGroup[2]", "sCssGroup[3]", "virtual:iShowPassword"], (name, value, type) => {
            im.writeValue("virtual:iShowPassword", 0)
            cssThemeLoad(true);
        });
        /* called when this local-script is disabled */
        self.onDisable = function () {
            im.writeValue("virtual:iShowPassword", 0);
            tok.unlisten();
            // remove table, when windows closed (problem: click 2x to activate new window)
            if (cssParent) cssParent.remove();
            self.run = false; /* from original .onDisable function of LocalScript control */
        };
    };

    // MODULE CODE - END
    fLog("module loaded");
})();