(function () {
    'use strict';
    var MODULE_NAME = "start-up-IDE",
        ENABLE_LOGGING = false,
        RECORD_LOG = false,
        logger = shmi.requires("visuals.tools.logging").createLogger(MODULE_NAME, ENABLE_LOGGING, RECORD_LOG),
        fLog = logger.fLog,
        log = logger.log,
        module = shmi.pkg(MODULE_NAME);

    // MODULE CODE - START
    /**
     * Implements local-script run function.
     * @param {LocalScript} self instance reference of local-script control
     */
    module.run = async function (self) {
        let iframe = cxt.getCtrl("iframe-tiger").vars.iframe;
        if (!cxApi.loggedIn()) {
            await loginCore()
        }
        if (cxApi.loggedIn()) {
            let sSrcNew = updateUrl(URL_TIGER)
            iframe.src = sSrcNew
            // Hide all ctrl's defined in csHideIdeCtrls
            const currentUser = shmi.visuals.session.UserManager.currentUser
            let bHide = true
            for (let i = 0; i < arIdeUserGroupsShow.length; i++)
                if (currentUser.groupList.includes(arIdeUserGroupsShow[i]))
                    bHide = false
            if (bHide) {
                iframe.onload = function () {
                    let sCss = ""
                    for (const key in cssHideIdeCtrls) {
                        sCss += cssHideIdeCtrls[key] + "\n"
                    }
                    if (sCss !== "") {
                        let iframeDoc = iframe.contentWindow.document
                        let oStyle = iframeDoc.createElement('style')
                        oStyle.setAttribute('type', 'text/css');
                        oStyle.appendChild(iframeDoc.createTextNode(sCss));

                        let oHead = iframeDoc.getElementsByTagName('head')[0]
                        oHead.appendChild(oStyle);
                    }
                }
            }
            iframe.style.display = "";
        }

        /* called when this local-script is disabled */
        self.onDisable = function () {
            self.run = false; /* from original .onDisable function of LocalScript control */
        };
    }

    // MODULE CODE - END

    fLog("module loaded");
})();

