let checkUaItems //
//
(function () {
    "use strict";  // variables must be defined
    let MODULE_NAME = "start-debug",
        ENABLE_LOGGING = false,
        RECORD_LOG = false,
        logger = shmi.requires("visuals.tools.logging").createLogger(MODULE_NAME, ENABLE_LOGGING, RECORD_LOG),
        fLog = logger.fLog,
        log = logger.log,
        module = shmi.pkg(MODULE_NAME);

    // MODULE CODE - START

    /* private variables */
    const SHOW_WS_TELEGRAMS = false
    const sLoginUser = "admin"
    const sLoginPassword = "&oschRexroth1"
    const ITEM_IO_DEVICES = "virtual:sIoDevices"
    const ITEM_IO_DEVICE_SELECTED = "virtual:sIoDeviceSelected"
    const ITEM_INFO = "virtual:sInfo"
    const ITEM_ITEMS = "virtual:sItems"
    const ITEM_SHOW_ALL = "virtual:bShowAllCheckedItems"
    const ITEM_PROGRESS = "virtual:iProgress"

    // const DIR_ROOT = "../"
    const DIR_ROOT = "./"
    const DIR_DESIGNER = DIR_ROOT + ".designer/"
    const DIR_JSON = DIR_ROOT + "json/"
    const FILE_APP_INFO = DIR_DESIGNER + "app-info.json"
    const FILE_VIRTUAL_ITEMS = DIR_JSON + "virtual-items.json"
    const cmdLogin = { "cmd": "user.login", "data": { "username": "admin", "password": "&oschRexroth1" } }
    const cmdLogout = { "cmd": "user.logout", "data": {} }
    const cmdVariableList = { "cmd": "experimental.structure_store.variable.list", "data": {} };
    const cmdVariableGet = { "cmd": "experimental.structure_store.variable.get", "data": { "name": "" } }
    const cmdVariableDel = { "cmd": "experimental.structure_store.variable.del", "data": { "name": "" } }
    const cmdStructGet1 = { "cmd": "experimental.structure_store.structure.get", "data": { "name": "", "namespace": null } }
    const cmdIoExtBrowse = {
        "cmd": "io_extension.browse",
        "data": {
            "name": "ctrlX",
            "node_id": {
                "node": "plc/app/Application/sym",
                "namespace": 8
            }
        }
    }
    const cmdIoExtList = { "cmd": "io_extension.list", "data": {} }

    const cmdStructGet = {
        "cmd": "experimental.structure_store.structure.get",
        "id": 0,
        "data": {
            "name": "",
            "namespace": null
        }
    }


    let myWsServer = null  // web server object
    let sTarget = ""       // target project name
    let sWsGuid = ""       // GUID of project
    let iID = 0            // id for API cmd's
    let jSend = {}
    let arItems = []
    let jTypes = {}
    let iProgress = 0

    /* private functions */
    function isArray(jElem) {
        return jElem.array_config !== null
    }
    function isStruct(jElem) {
        return !["bool", "float", "int", "string"].includes(jElem.type.name)
    }
    // returns all children (array and struct)
    async function getAllChildNames(jElem, arList) {
        let jItem = {}
        jItem.name = jElem.name
        jItem.type = jElem.type.name
        jItem.plcName = jElem.plc_name.value
        jItem.source = (jElem.source === null) ? "*" : jElem.source
        if (jElem.name === "AAA_struct_array")
            jElem
        if (isArray(jElem)) {
            for (let j = 0; j < jElem.array_config.size; j++) {
                let jTmp = shmi.cloneObject(jItem)
                jTmp.name = `${jElem.name}${jElem.object_plc_name.array_prefix}${j}${jElem.object_plc_name.array_suffix}`
                if (isStruct(jTmp)) {
                    jTmp.name += "*"
                    arList.push(jTmp)
                } else
                    arList.push(jTmp)

                // if (isStruct(jTmp)) {
                //     getAllChildNames(jTmp, arList)
                //     // } else if (isArray(jTmp)) {
                //     //     getAllChildNames(jTmp, arList)
                // } else {
                //     jTmp.name = `${jElem.name}${jElem.object_plc_name.array_prefix}${j}${jElem.object_plc_name.array_suffix}`
                //     arList.push(jTmp)
                // }
            }
        } else if (isStruct(jElem)) {
            let jCmd = cmdStructGet
            jCmd.data.name = jItem.type
            let jResp = await wsSendRecv(jCmd).catch((err) => { cxt.abortJS(err.error.message) })
            for (const sKey in jResp.data.members) {
                // getAllChildNames(jResp.data.members[sKey], arList)
                let jTmp = shmi.cloneObject(jResp.data.members[sKey])
                jTmp.name = jElem.name + "." + sKey
                if (isArray(jTmp)) {
                    getAllChildNames(jTmp, arList)
                } else if (isStruct(jTmp)) {
                    getAllChildNames(jTmp, arList)
                } else {
                    arList.push(jTmp)
                }
            }
        } else {
            arList.push(jItem)
        }
    }
    /**
     * Copies item attributes from jResp into arList[]
     * @param {json} jResp resonse of experimental.structure_store.variable.list
     */
    async function getItems() {
        let jResp = await wsSendRecv(cmdVariableList).catch((err) => {
            if (err.error.errc === 17) {
                cxt.abortJS(eval(l.connectFailed))
            } else {
                cxt.abortJS(err.error.message);
            }
        })
        let arList = [];  // clear global array
        // create array with items for sorting
        let iMax = jResp.data.length

        for (let i = 0; i < iMax; i++) {
            let e = jResp.data[i];
            let jItem = {}
            if (e.name.startsWith("AAA"))
                e.name
            jItem.name = e.name
            jItem.type = e.type.name
            jItem.plcName = e.plc_name.value
            jItem.source = (e.source === null) ? "*" : e.source
            console.log(`${e.name} ${e.type}`)
            await getAllChildNames(e, arList)
            // if (e.array_config === null) {
            //     arList.push(jItem)  // add new item to array
            // } else {
            //     // add all array item names
            //     const sName = jItem.name
            //     for (let j = 0; j < e.array_config.size; j++) {
            //         let jTmp = shmi.cloneObject(jItem)
            //         jTmp.name = `${sName}${e.object_plc_name.array_prefix}${j}${e.object_plc_name.array_suffix}`
            //         arList.push(jTmp)
            //     }
            // }
        }
        return arList
    }
    /**
     * Reads in a text file
     * @param {string} sFile name of text file to read
     * @returns content of text file
     */
    async function fetchTextFile(sFile) {
        let resp = null
        resp = await fetch(sFile)
        if (resp.status !== 200) {
            cxt.abortJS(resp.statusText + "\n" + resp.url)
            //abortJS("")
        }
        const myText = await resp.text()
        return myText;
    }
    /**
     * establish connection to WebIQ server
     * 
     * @param {string} sServer (e.g. "ws://127.0.0.1:10123/";)
     * @param {string} sProtocol (e.g. "smarthmi-connect";)
     */
    function wsConnect(sServer, sProtocol) {
        return new Promise(function (resolve, reject) {
            let bTimeOutActive = false
            let oTimeOutFunc = null
            if (sProtocol !== "") {
                try {
                    bTimeOutActive = true
                    oTimeOutFunc = setTimeout(function () {
                        myWsServer = null
                        console.error("setTimeout called")
                        bTimeOutActive = false
                        reject()
                    }, 2000)
                    myWsServer = new WebSocket(sServer, sProtocol)
                }
                catch (err) {
                    msgBox("error", eval(l.connectFailed));
                    reject(err);
                }
            } else {
                myWsServer = new WebSocket(sServer);
            }

            myWsServer.onopen = function (event) {
                if (SHOW_WS_TELEGRAMS) {
                    console.warn(`>CB:Connected to ${sServer} OK`)
                }
                clearTimeout(oTimeOutFunc)
                resolve("connection OK");
            };
            myWsServer.onerror = function (err) {
                if (bTimeOutActive) {
                    clearTimeout(oTimeOutFunc)
                    myWsServer = null
                    console.error("onError called")
                    msgBox("error", eval(l.connectFailed))
                    reject(err)
                }
            }
        });
    }
    /**
     * close connection to WebIQ server
     * 
     */
    function wsClose() {
        return new Promise(function (resolve, reject) {
            if (SHOW_WS_TELEGRAMS)
                console.warn(`>Close connection requested`);
            myWsServer.close()
            myWsServer.onclose = function (event) {
                myWsServer = null
                if (SHOW_WS_TELEGRAMS)
                    console.warn(`>>>CB:onClose connection OK`)
                resolve(event)
            };

            myWsServer.onerror = function (err) {
                // msgBox("error", `Close connection to ${sWebIQServer} failed`);
                reject(err);
            };
        });
    }
    /**
     * send message to WebIQ server and waits for response
     * @param {json} jCmd 
     * @param {boolean} bThrowError true=throw error when response.errc>0
     * @return {json} received command response
     */
    function wsSendRecv(jCmd, bThrowErr) {
        if (bThrowErr === undefined)
            bThrowErr = true
        if (myWsServer === null) {
            abortJS(eval(l.connectFailed), true)
        }
        return new Promise(function (resolve, reject) {
            // add target project name if defined => to select the defined project

            jCmd.id = ++iID
            sWsGuid
            if (sTarget !== "") {
                jCmd.target = sTarget;
            }
            jSend = jCmd;
            let sCmd = JSON.stringify(jCmd, null, 0);
            myWsServer.send(sCmd);
            if (SHOW_WS_TELEGRAMS)
                console.warn("S:" + JSON.stringify(jCmd, null, 2));

            myWsServer.onerror = function (err) {
                msgBox("error", `Receive error ${err.message}`);
                reject(err);
            };
            myWsServer.onmessage = function (evt) {
                let jResp = JSON.parse(evt.data);
                if (jResp.cmd === "connect.event") {
                    jResp;
                } else {
                    if (SHOW_WS_TELEGRAMS)
                        console.warn("R:" + JSON.stringify(jResp, null, 2));
                    if (iID !== jResp.id) {
                        jResp.error = {};
                        jResp.error.errc = 99999;  // programming error?
                        jResp.error.message = `${jResp.cmd} failed. Code=${jResp.error.errc} msg=Invalid id.\nSend=${iID} ${jSend.cmd}\nRecv=${jResp.id} ${jResp.cmd}`;
                        //alert(oResp.error.message);
                        reject(jResp);
                    } else if (isRespOK(jResp)) {
                        resolve(jResp);
                    } else {
                        if (bThrowErr === true) {
                            jResp.error.message = `${jResp.cmd} failed. code=${jResp.error.errc} msg=${jResp.error.message}`;
                            reject(jResp);
                        } else {
                            resolve(jResp);
                        }
                    }
                }
            }
        });
    }
    /**
     * Waits for API response. Some commands returns multiple messages.
     * Func. is necessary, because wsSendRecv only waits for 1 response msessage 
     * @param {json} jResp1 first response, for checking of ID & commands
     * @param {boolean} bThrowError true=throw error when response.errc>0
     * @return {json} received command response
     */
    function wsRecv(jResp1, bThrowErr) {
        if (myWsServer === null) {
            abortJS(eval(l.connectFailed))
        }
        return new Promise(function (resolve, reject) {
            let toRecv = setTimeout(() => {
                abortJS(`Nothing received within timeout.\nid=${jResp1.id} cmd=${jResp1.cmd}`)
            }, iTimeOut)

            myWsServer.onerror = function (err) {
                msgBox("error", `Receive error ${err.message}`);
                reject(err);
            };
            myWsServer.onmessage = function (evt) {
                clearTimeout(toRecv)
                let jResp = JSON.parse(evt.data);
                if (SHOW_WS_TELEGRAMS)
                    console.log("R: " + jResp.id + ":" + jResp.cmd);
                if (jResp1.id !== jResp.id) {
                    jResp.error = {};
                    jResp.error.errc = 99999;  // programming error?
                    jResp.error.message = `${jResp.cmd} failed. Code=${jResp.error.errc} msg=Invalid id.\nSend=${iID} ${jSend.cmd}\nRecv=${jResp.id} ${jResp.cmd}`;
                    //alert(oResp.error.message);
                    reject(jResp);
                } else if (isRespOK(jResp)) {
                    resolve(jResp);
                } else {
                    if (bThrowErr === true) {
                        jResp.error.message = `${jResp.cmd} failed. code=${jResp.error.errc} msg=${jResp.error.message}`;
                        reject(jResp);
                    } else {
                        resolve(jResp);
                    }
                }
            }
        });
    }
    /**
     * Check if response  reports an error
     */
    function isRespOK(oResp) {
        return (oResp.error === null);
    }
    function Progress() {
        ++iProgress
        if (iProgress > 1000) iProgress = 1
        cxt.setItem(ITEM_PROGRESS, iProgress)
    }
    /**
     * checks all opcua items are available (via trying to read them)
     */
    async function checkOpcuaItems() {
        let bShowAll = await cxt.getItem(ITEM_SHOW_ALL)
        cxt.setItem(ITEM_ITEMS, "")
        cxt.setItem(ITEM_INFO, "Reading OpcUa item types...")

        let jCmd = cmdIoExtBrowse
        const sIoDevice = await cxt.getItem(ITEM_IO_DEVICE_SELECTED)
        jCmd.data.name = sIoDevice // io name
        jCmd.data.node_id.node = "plc/app/Application/sym"
        jCmd.data.node_id.namespace = 8 //jResp.data.plc_name.namespace;
        jTypes = {}
        await getOpcuaTypes(jCmd, jCmd.data.node_id.node.length)
        // retrieve list with all variables/itemsx
        cxt.setItem(ITEM_INFO, "Verifying OpcUa items...")
        arItems = await getItems()
        let iMax = arItems.length
        let sItems = ""
        let NL = ""
        let oVal = null
        let _iTypeChanged = 0
        let _iRange = 0
        let _iFound = 0
        let _iNotFound = 0
        for (let i = 0; i < iMax; i++) {
            if (arItems[i].source === sIoDevice) {
                try {
                    oVal = await cxt.getItem(arItems[i].name, true, false)
                    oVal = "OK"
                    _iFound++;
                } catch (e) {
                    oVal = "NOT FOUND"
                    _iNotFound++
                }
                // // Read data type via ctrlX REST API (returns value & type)
                // // https://127.0.0.1:8443/automation/api/v2/nodes/plc/app/Application/sym/GVL_BASE/stIoForce/0/ForceValue' 
                // // get data of item
                // let jCmd = cmdVariableGet
                // jCmd.data.name = arItems[i].name
                // jResp = await wsSendRecv(jCmd).catch((err) => {
                //     cxt.msgBox("error", err.message)
                //     return
                // })
                let sTypeWebIQ = arItems[i].type
                let sTmp = arItems[i].plcName.replace(/\/[0-9]+$/, "");
                let sTypePlc = jTypes[sTmp]
                if (typeof sTypePlc !== "string") sTypePlc = "[?]"
                if (oVal === "OK") {
                    let bTypeChanged = false
                    if (sTypeWebIQ === "int") {
                        if (!((sTypePlc.startsWith("i")) || (sTypePlc.startsWith("u")))) {
                            bTypeChanged = true
                        }
                    } else if (sTypeWebIQ === "float") {
                        if (!["float", "double"].includes(sTypePlc)) {
                            bTypeChanged = true
                        }
                    } else if (sTypeWebIQ !== sTypeWebIQ) {
                        bTypeChanged = true
                    }

                    if (bTypeChanged) {
                        oVal = "TYPE CHANGED"
                        _iTypeChanged++
                        // } else if (["i64", "u64", "u32", "double"].includes(sTypePlc)) {
                    } else if (["i64", "u64"].includes(sTypePlc)) {
                        oVal = "OUT OF RANGE"
                        _iRange++
                    }
                }

                if ((oVal !== "OK") || (bShowAll > 0)) {
                    sItems += `${NL}${oVal} ${arItems[i].name} ${sTypeWebIQ} PLC:${sTypePlc}`
                    NL = "\n"
                }
            }
            Progress()
        }
        cxt.setItem(ITEM_ITEMS, sItems)
        cxt.setItem(ITEM_PROGRESS, 0)
        let sInfo = `OPC "${sIoDevice}": Items: Ok=${_iFound} Not exists=${_iNotFound} Type changed=${_iTypeChanged} Out of range=${_iRange}`
        cxt.setItem(ITEM_INFO, sInfo)
    }

    /**
    * async load project
    * @param {string} iProjectID -1=open dialog to select project >=0:open project with provided ID
    */
    async function projectOpen(iProjectID) {
        let bConnected = true

        // establish connection to webIQ server
        if (myWsServer === null) {
            let sWebIQServer = `ws://127.0.0.1:10123/`
            try {
                await wsConnect(sWebIQServer, "smarthmi-connect")
            } catch {
                cxt.msgBox("warning", "Connect failed")
                return
            }
            // login with system user & password
            let cmdLoginX = cmdLogin
            cmdLoginX.data.username = sLoginUser
            cmdLoginX.data.password = sLoginPassword
            await wsSendRecv(cmdLoginX).catch((err) => {
                bConnected = false
                if (err.error.errc === 3) {
                    myWsServer = null
                    cxt.msgBox("error", "login failed")
                } else {
                    cxt.abortJS(err.error.message);
                }
            })
        }

        // get project guid
        let sContent = await fetchTextFile(FILE_APP_INFO)
        let jContent = JSON.parse(sContent)

        sWsGuid = jContent.guid
        {
            // true: loaded via localhost:10124 from workspace in %appdata%
            // false: loaded via file://...
            /*
            if (true) {
                if (bConnected) {
                    await projectWorkspace()
                } else {
                    return
                }
            } else {
                // get workspace projects with project names
                let iProjects = 0;
                let sProjectOpts = "";
                jCmd = cmdFsLs;
                jCmd.data = [".workspace"];
                jResp = await wsSendRecv(jCmd).catch((err) => { abortJS(err.error.message); });
                let arProjects = [];
                for (let i = 0; i < jResp.data[0].listing.files.length; i++) {
                    if (jResp.data[0].listing.files[i].type === "json") {
                        let oProject = {};
    
                        oProject.guid = jResp.data[0].listing.files[i].name.replace(".json", "");
                        jCmd = cmdWorkspaceInfo;
                        jCmd.data = oProject.guid;
                        let oResp1 = await wsSendRecv(jCmd).catch((err) => { abortJS(err.error.message); });
                        // build options string for msgBox()
                        oProject.name = oResp1.data.app_name;
                        sProjectOpts += oProject.name + FS_VAL + iProjects + FS_OPT;
    
                        // store project in array
                        arProjects.push(oProject);
                        iProjects++;
                    }
                }
                if (iProjects === 0) {
                    abortJS(l.noWorkspaceProject);
                    return
                } else if (iProjects > 1) {
                    if (iProjectID === -1) {
                        //      sProjectOpts += "*** CANCEL ***" + FS_VAL + 9999 + FS_OPT;
                        iProjectID = await msgBox("select", eval(l.multipleProjectsInWorkspace), "", sProjectOpts, FS_OPT, FS_VAL);
                        if (iProjectID === "cancel") {
                            return;
                        }
                    }
                } else {
                    iProjectID = 0
                }
                iProjectLoadId = iProjectID;
    
                //console.log(`Open ${arProjects[iProjectID].name} ${arProjects[iProjectID].guid}`);
    
                // update window title
                document.title = arProjects[iProjectID].name;
                sWsGuid = arProjects[iProjectID].guid;
                sWsProject = arProjects[iProjectID].name;
    
                // start project on server, can not check if it is yet running
                jCmd = cmdWorkspaceRecover;
                jCmd.data = sWsGuid;
                jResp = await wsSendRecv(jCmd).catch((err) => { abortJS(err.error.message); });
            }
            */
        }
        // set name of project to connect to
        sTarget = sWsGuid
    }
    /**
     * Close project
     */
    async function projectClose() {
        if (myWsServer !== null) {
            jResp = await wsSendRecv(cmdLogout).catch((err) => { cxt.abortJS(err.error.message); });
            await wsClose()
            myWsServer = null
        }
        sWsGuid = ""
    }
    async function projectWorkspace() {
    }
    async function getOpcuaTypes(jCmd) {
        let jRespBrowse = await wsSendRecv(jCmd, false)
        if (jRespBrowse.error) {
            if (jRespBrowse.error.errc === -2136080384) {
                cxt.msgBox("error", "No connection to OpcUa Server")
            }
        } else {
            let iMax = jRespBrowse.data.length
            for (let i = 0; i < iMax; i++) {
                Progress()
                let sType = jRespBrowse.data[i].data_type.type
                let sName = jRespBrowse.data[i].browse_name.node
                if (sType === "empty") {
                    let jCmdX = JSON.parse(JSON.stringify(jCmd))
                    jCmdX.data.node_id.node = jCmd.data.node_id.node + "/" + sName
                    await getOpcuaTypes(jCmdX)
                } else {
                    let sName = jCmd.data.node_id.node + "/" + jRespBrowse.data[i].browse_name.node
                    jTypes[sName] = sType
                }
            }
        }

    }

    /**
     * 
     */
    async function getVirtualItems() {
        let sContent = await fetchTextFile(FILE_VIRTUAL_ITEMS)
        let jVItems = JSON.parse(sContent)
        for (let i = 0; i < jVItems.items.length; i++) {
            arItemsVirtual.push(jVItems.items[i].name)
        }
    }
    async function getIoDevices() {
        let sRes = ""
        let jResp = await wsSendRecv(cmdIoExtList, false)
        if (jResp.error) {
            if (jResp.error.errc === -2136080384) {
                cxt.msgBox("error", "No connection to OpcUa Server")
            }
        } else {
            let iMax = jResp.data.io_extensions.length
            let sFS = ""
            let bSet = false
            for (let i = 0; i < iMax; i++) {
                let io = jResp.data.io_extensions[i]
                if (io.config.endpoint_url)
                    if (io.config.endpoint_url.startsWith("opc.tcp://")) {
                        // '1=red;2=blue;3=green;4=yellow;5=cyan;6=orange'
                        if (bSet === false) {
                            bSet = true
                            cxt.setItem(ITEM_IO_DEVICE_SELECTED, io.name)
                        }
                        sRes += sFS + io.name + "=" + io.name
                        sFS = ";"
                    }
            }
        }
        cxt.setItem(ITEM_IO_DEVICES, sRes)
    }
    /**
     * Implements local-script run function.
     *
     * This function will be called each time a local-script will be enabled.
     *
     * @param {LocalScript} self instance reference of local-script control
     */
    module.run = async function (self) {
        checkUaItems = checkOpcuaItems
        cxt.setItem(ITEM_ITEMS, '')
        cxt.setItem(ITEM_INFO, 'Select OpcUA connection, then press "▶"...')
        await cxt.setItem(ITEM_PROGRESS, 0)
        await projectOpen(-1)
        await getIoDevices()
        await getVirtualItems()
        arItemsPlc = await getItems()

        /* called when this local-script is disabled */
        self.onDisable = function () {
            self.run = false; /* from original .onDisable function of LocalScript control */
            // projectClose()
            // log("Project closed")
        };
    };

    // MODULE CODE - END
    fLog("module loaded");
})();
let arItemsVirtual = []
let arItemsPlc = []
