'use strict';
var cssParent = null; // reference to dyn. created css parent element
var iHeartBeatPLC;
var cssTmp = null

// retrieve all CSS variables from styleSheets
/*
var cssVarsAll = Array.from(document.styleSheets)
  .filter(styleSheet => {
    try { return styleSheet.cssRules; }
    catch (e) { console.warn(e); }
  })
  .map(styleSheet => Array.from(styleSheet.cssRules))
  .flat()
  .filter(cssRule => cssRule.selectorText === ':root')
  .map(cssRule => cssRule.cssText.split('{')[1].split('}')[0].trim().split(';'))
  .flat()
  .filter(text => text !== "")
//  .filter(text => text.startsWith("--col") )
  .map(text => text.split(':'))
  //.map(parts => ({key: parts[0].trim(), value: parts[1].trim() }))
  .map(parts => (parts[0].trim()));
*/
const cssVarsAll = [
  "${css-header-menu}",
  "--col-bg-header-top", "--col-bg-rexroth-gif", "--col-bg-header", "--col-header-label",
  "--inv-header-img", "--col-bg-sidebar", "--col-sidebar-border",

  "--col-bg-tab-inactive", "--col-tab-inactive-font", // bg active tab=uses --col-bg-content-window & --col-content-font

  "${css-content}",
  "--col-bg-content-window", "--col-bg-content-box",
  "--col-bg-table-hdr", "--col-bg-table-row-active",
  "--col-content-font", "--inv-content-img",

  "${css-state}",
  "--col-bg-ok", "--col-bg-ok-label",             // rename --col-ok
  "--col-bg-warn", "--col-bg-warn-label",         // rename --col-warn
  "--col-bg-error", "--col-bg-error-label",       // rename --col-error
  "--col-bg-question", "--col-bg-question-label", // rename --col-question

  "${css-button}",
  "--col-bg-btn-normal", "--col-btn-normal-border", "--col-btn-normal-label", "--inv-btn-normal-img",
  "--col-bg-btn-active", "--col-btn-active-border", "--col-btn-active-label", "--inv-btn-active-img"
];

/**
 * Reads Css variable values & stores them in a string
 * @returns String with key value pairs
 */
function cssGetKeyVal() {
  let sSet = "";
  let docStyle = document.documentElement.style;
  let cssVars = cssVarsAll; //.sort();
  //get variable values
  for (let i = 0; i < cssVars.length; i++) {
    //split up key and value, ignore section headers
    if (cssVars[i].startsWith("--")) {
      let sVal = docStyle.getPropertyValue(cssVars[i]);
      sSet += cssVars[i] + FS_CSS_COL + sVal + FS_CSS_ROW;
    }
  }
  return sSet;
}
/**
 * set all css variables of selected theme
 * @param {number} iID number of theme
 */
function setTheme(iID) {
  cxt.cssSetVar("--f-size-normal", "12px");
  cxt.cssSetVar("--f-size-big", "14px");
  cxt.cssSetVar("--f-size-huge", "18px");
  cxt.cssSetVar("--f-weigth", "bold");

  // Set theme 0 colors etc.
  if (iID == 0) {
    // Rexroth Corporate Identity Color Theme 0
    cxt.cssSetVar("--col-bg-header-top", "#D1DCE3");
    cxt.cssSetVar("--col-bg-rexroth-gif", "#D1DCE3");
    cxt.cssSetVar("--col-bg-header", "#EFF1F2");
    cxt.cssSetVar("--col-header-label", "#000000");
    cxt.cssSetVar("--inv-header-img", "0");

    cxt.cssSetVar("--col-bg-sidebar", "#EFF1F2");
    cxt.cssSetVar("--col-sidebar-border", "#D1DCE3");
    cxt.cssSetVar("--col-bg-tab-inactive", "#9D9D9D");
    cxt.cssSetVar("--col-tab-inactive-font", "#ffffff");

    cxt.cssSetVar("--col-bg-content-window", "#ffffff");
    cxt.cssSetVar("--col-bg-content-box", "#EFF1F2");
    cxt.cssSetVar("--col-bg-table-hdr", "#D1DCE3");
    cxt.cssSetVar("--col-bg-table-row-active", "#7FE5FF");
    cxt.cssSetVar("--col-content-font", "#000000");
    cxt.cssSetVar("--inv-content-img", "0");

    cxt.cssSetVar("--col-bg-ok", "#78BE20");
    cxt.cssSetVar("--col-bg-ok-label", "#000000");
    cxt.cssSetVar("--col-bg-warn", "#FCAF17");
    cxt.cssSetVar("--col-bg-warn-label", "#000000");
    cxt.cssSetVar("--col-bg-error", "#EA0016");
    cxt.cssSetVar("--col-bg-error-label", "#000000");
    cxt.cssSetVar("--col-bg-question", "#00CCFF");
    cxt.cssSetVar("--col-bg-question-label", "#000000");

    cxt.cssSetVar("--col-bg-btn-normal", "#919191");
    cxt.cssSetVar("--col-btn-normal-border", "#DADADA");
    cxt.cssSetVar("--col-btn-normal-label", "#ffffff");
    cxt.cssSetVar("--inv-btn-normal-img", "1");
    cxt.cssSetVar("--col-bg-btn-active", "#00CCFF");
    cxt.cssSetVar("--col-btn-active-border", "#91F0FF");
    cxt.cssSetVar("--col-btn-active-label", "#ffffff");
    cxt.cssSetVar("--inv-btn-active-img", "1");
  }
  if (iID == 1) {
    // Dark Theme 1
    cxt.cssSetVar("--col-bg-header-top", "#464646");
    cxt.cssSetVar("--col-bg-rexroth-gif", "#646464");
    cxt.cssSetVar("--col-bg-header", "#646464");
    cxt.cssSetVar("--col-header-label", "#FAFAFA");
    cxt.cssSetVar("--inv-header-img", "1");

    cxt.cssSetVar("--col-bg-sidebar", "#646464");
    cxt.cssSetVar("--col-sidebar-border", "#464646");
    cxt.cssSetVar("--col-bg-tab-inactive", "#9D9D9D");
    cxt.cssSetVar("--col-tab-inactive-font", "#ffffff");

    cxt.cssSetVar("--col-bg-content-window", "#121212");
    cxt.cssSetVar("--col-bg-content-box", "#505050");
    cxt.cssSetVar("--col-bg-table-hdr", "#969696");
    cxt.cssSetVar("--col-bg-table-row-active", "#00CCFF");
    cxt.cssSetVar("--col-content-font", "#FAFAFA");
    cxt.cssSetVar("--inv-content-img", "1");

    cxt.cssSetVar("--col-bg-ok", "#78BE20");
    cxt.cssSetVar("--col-bg-ok-label", "#000000");
    cxt.cssSetVar("--col-bg-warn", "#FCAF17");
    cxt.cssSetVar("--col-bg-warn-label", "#000000");
    cxt.cssSetVar("--col-bg-error", "#EA0016");
    cxt.cssSetVar("--col-bg-error-label", "#000000");
    cxt.cssSetVar("--col-bg-question", "#00CCFF");
    cxt.cssSetVar("--col-bg-question-label", "#000000");

    cxt.cssSetVar("--col-bg-btn-normal", "#CCCCCC"); // #919191
    cxt.cssSetVar("--col-btn-normal-border", "#AAAAAA");
    cxt.cssSetVar("--col-btn-normal-label", "#ffffff");
    cxt.cssSetVar("--inv-btn-normal-img", "1");
    cxt.cssSetVar("--col-bg-btn-active", "#00CCFF");
    cxt.cssSetVar("--col-btn-active-border", "#91F0FF");
    cxt.cssSetVar("--col-btn-active-label", "#ffffff");
    cxt.cssSetVar("--inv-btn-active-img", "1");

  }
  if (iID == 2) {
    // Theme 2
    cxt.cssSetVar("--col-bg-header-top", "#707070");
    cxt.cssSetVar("--col-bg-rexroth-gif", "#707070");
    cxt.cssSetVar("--col-bg-header", "#3E3E3E");
    cxt.cssSetVar("--col-header-label", "#FAFAFA");
    cxt.cssSetVar("--inv-header-img", "1");


    cxt.cssSetVar("--col-bg-sidebar", "#3E3E3E");
    cxt.cssSetVar("--col-sidebar-border", "#707070");
    cxt.cssSetVar("--col-bg-tab-inactive", "#666666");
    cxt.cssSetVar("--col-tab-inactive-font", "#ffffff");

    cxt.cssSetVar("--col-bg-content-window", "#ffffff");
    cxt.cssSetVar("--col-bg-content-box", "#EBEBEB");
    cxt.cssSetVar("--col-bg-table-hdr", "#B8B8B8");
    cxt.cssSetVar("--col-bg-table-row-active", "#FF8080");
    cxt.cssSetVar("--col-content-font", "#000000");
    cxt.cssSetVar("--inv-content-img", "0");

    cxt.cssSetVar("--col-bg-ok", "#78BE20");
    cxt.cssSetVar("--col-bg-ok-label", "#000000");
    cxt.cssSetVar("--col-bg-warn", "#FCAF17");
    cxt.cssSetVar("--col-bg-warn-label", "#000000");
    cxt.cssSetVar("--col-bg-error", "#EA0016");
    cxt.cssSetVar("--col-bg-error-label", "#000000");
    cxt.cssSetVar("--col-bg-question", "#00CCFF");
    cxt.cssSetVar("--col-bg-question-label", "#000000");

    cxt.cssSetVar("--col-bg-btn-normal", "#C4C4C4");
    cxt.cssSetVar("--col-btn-normal-border", "#BEBEBE");
    cxt.cssSetVar("--col-btn-normal-label", "#000000");
    cxt.cssSetVar("--inv-btn-normal-img", "0");
    cxt.cssSetVar("--col-bg-btn-active", "#FF4D4D");
    cxt.cssSetVar("--col-btn-active-border", "#FF6666");
    cxt.cssSetVar("--col-btn-active-label", "#000000");
    cxt.cssSetVar("--inv-btn-active-img", "0");

  }
  if (iID == 3) {
    // Theme 3
    cxt.cssSetVar("--col-bg-header-top", "#464646");
    cxt.cssSetVar("--col-bg-rexroth-gif", "#646464");
    cxt.cssSetVar("--col-bg-header", "#646464");
    cxt.cssSetVar("--col-header-label", "#FAFAFA");
    cxt.cssSetVar("--inv-header-img", "0");

    cxt.cssSetVar("--col-bg-sidebar", "#646464");
    cxt.cssSetVar("--col-sidebar-border", "#464646");
    cxt.cssSetVar("--col-bg-tab-inactive", "#9D9D9D");
    cxt.cssSetVar("--col-tab-inactive-font", "#ffffff");

    cxt.cssSetVar("--col-bg-content-window", "#121212");
    cxt.cssSetVar("--col-bg-content-box", "#505050");
    cxt.cssSetVar("--col-bg-table-hdr", "#969696");
    cxt.cssSetVar("--col-bg-table-row-active", "#00CCFF");
    cxt.cssSetVar("--col-content-font", "#FAFAFA");
    cxt.cssSetVar("--inv-content-img", "1");

    cxt.cssSetVar("--col-bg-ok", "#78BE20");
    cxt.cssSetVar("--col-bg-ok-label", "#000000");
    cxt.cssSetVar("--col-bg-warn", "#FCAF17");
    cxt.cssSetVar("--col-bg-warn-label", "#000000");
    cxt.cssSetVar("--col-bg-error", "#EA0016");
    cxt.cssSetVar("--col-bg-error-label", "#000000");
    cxt.cssSetVar("--col-bg-question", "#00CCFF");
    cxt.cssSetVar("--col-bg-question-label", "#000000");

    cxt.cssSetVar("--col-bg-btn-normal", "#919191");
    cxt.cssSetVar("--col-btn-normal-border", "#AAAAAA");
    cxt.cssSetVar("--col-btn-normal-label", "#ffffff");
    cxt.cssSetVar("--inv-btn-normal-img", "1");
    cxt.cssSetVar("--col-bg-btn-active", "#00CCFF");
    cxt.cssSetVar("--col-btn-active-border", "#91F0FF");
    cxt.cssSetVar("--col-btn-active-label", "#ffffff");
    cxt.cssSetVar("--inv-btn-active-img", "1");

  }




}
/**
 * Generates js code to set css variable values
 * @returns String with js code to set variables (key:value pairs)
 * cxt.cssSetVar("--col-bg-ok", "#BBBBBB");
 */
function cssJsCode() {
  let sCode = "";
  let docStyle = document.documentElement.style;
  let cssVars = cssVarsAll; //.sort();
  //get variable values
  for (let i = 0; i < cssVars.length; i++) {
    //split up key and value, ignore section headers
    if (cssVars[i].startsWith("--")) {
      let sVal = docStyle.getPropertyValue(cssVars[i]);
      sCode += `cxt.cssSetVar("${cssVars[i]}", "${sVal}");` + "\n";
    }
  }
  return sCode;
}
/**
 * Set Css variables, provided in a string (key:value pairs)
 * @param: String with key:value pairs separator rows=FS_CSS_ROW, separator key-value=FS_CSS_COL e.g: "--col1:#ffaaff,--col2:#aaffbb"
 */
function cssSetKeyVal(sCssSet) {
  if ((sCssSet === "") || (!sCssSet)) {
    return;
  }
  let docStyle = document.documentElement.style;
  // split up all key:value pair
  let arR = sCssSet.split(FS_CSS_ROW);
  for (let i = 0; i < arR.length; i++) {
    if (arR[i] !== "") {
      //split up key and value
      let arC = arR[i].split(FS_CSS_COL);
      docStyle.setProperty(arC[0], arC[1]);
    }
  }
}
/**
 * Insert value for place holders
 * @param {string} sUrl 
 * @returns sUrl with replaced values
 */
function updateUrl(sUrl) {
  sUrl = sUrl.replace("${sURL}", document.location.host);
  sUrl = sUrl.replace("${sToken}", cxApi.idmToken);
  return sUrl
}

/**
 * Creates table with color pickers for CSS variables
 * @returns null
 */
function cssThemeLoad(bBuildScreen) {
  const im = shmi.requires("visuals.session.ItemManager");
  let iSetNo = im.readValue("iCssSelected");
  console.log("Load theme: " + iSetNo)
  if (!iSetNo)
    iSetNo = 0;
  let sCssGrp = "";

  let cssVars = cssVarsAll; //.sort();
  // retrieve active css variables
  if (iSetNo < 2) {
    setTheme(iSetNo);
    sCssGrp = cssGetKeyVal();
  } else {
    sCssGrp = im.readValue(`sCssGroup[${iSetNo}]`);
    // if group empty, use default theme
    if ((sCssGrp === null) || (sCssGrp === "")) {
      setTheme(0);
      sCssGrp = cssGetKeyVal();
    }
  }

  cssSetKeyVal(sCssGrp);
  if (!bBuildScreen)
    return;
  let sCtrl = "box-css-color-setup";
  let myCtrl = cxt.getCtrl(sCtrl);
  if (!myCtrl)
    return;
  // In box.marginCompensator all childs MUST be placed
  let parent = myCtrl.marginCompensator;

  // color picker name/desciption of CSS variable
  if (cssParent)
    cssParent.remove();

  cssParent = document.createElement("div");
  cssParent.classList.add("flex-col");

  let sHeight = "44px";
  let sWidth = "50px";
  let divRow;
  for (var iRow = 0; iRow < cssVars.length; iRow++) {
    // filter css var's dependent on prefix
    if (cssVars[iRow].startsWith("--")) {
      let flexColor = document.createElement("div");
      flexColor.classList.add("flex-color");

      let btnMark = document.createElement("buton");
      btnMark.style.minWidth = sWidth;
      // btnMark.style.backgroundColor = "lightgray"
      let sCssColorBak = "";
      let iCssMarkCnt = 0;
      let sCssVarName = "";
      btnMark.innerHTML = `<img src="pics/custom/msgbox/locator-spot.svg" width="${sWidth}">`;
      // btnMark.innerHTML = "☼"
      btnMark.setAttribute("cssVar", cssVars[iRow]);
      // toggle color to highlight element in browser
      btnMark.onclick = function () {
        let myScreen = null;
        let myDialog = null;
        let sMsg = "${css-info}";
        if (iCssMarkCnt === 0) {
          sCssVarName = this.getAttribute("cssVar");
          if (sCssVarName.startsWith("--col-bg-ok")) {
            myScreen = cxt.msgBox("info", sMsg);
          } else if (sCssVarName.startsWith("--col-bg-warn")) {
            myScreen = cxt.msgBox("warning", sMsg);
          } else if (sCssVarName.startsWith("--col-bg-error")) {
            myScreen = cxt.msgBox("error", sMsg);
          } else if (sCssVarName.startsWith("--col-bg-question")) {
            myScreen = cxt.msgBox("question", sMsg);
          } else if (sCssVarName.startsWith("--col-bg-table")) {
            const p = [{ name: "dialog", params: [".dialogbox-table-example", "show"] }];
            myDialog = 1
            new shmi.visuals.core.UiAction(p).execute();
          }

          let docStyle = getComputedStyle(document.documentElement);
          sCssColorBak = docStyle.getPropertyValue(sCssVarName).trim();
          iCssMarkCnt = 1;
          let oCssInterval = setInterval(function () {
            let myStyle = document.documentElement.style;
            iCssMarkCnt++;
            let sVal0 = sCssVarName.startsWith("--col") ? "#EC0003" : 0;
            let sVal1 = sCssVarName.startsWith("--col") ? "#F0F800" : 1;
            if (iCssMarkCnt < 10) {
              if ((iCssMarkCnt % 2) === 0)
                myStyle.setProperty(sCssVarName, sVal0);
              else
                myStyle.setProperty(sCssVarName, sVal1);
            } else {
              iCssMarkCnt = 0;
              myStyle.setProperty(sCssVarName, sCssColorBak);
              if (myDialog === 1) {
                const p = [{ name: "dialog", params: [".dialogbox-table-example", "hide"] }];
                new shmi.visuals.core.UiAction(p).execute();
                myDialog = null;
              }
              if (myScreen) {
                myScreen.remove();
              }
              clearInterval(oCssInterval);
            }
          }, 380);
        }
      }

      let userIn = document.createElement("input");
      userIn.style.height = sHeight;
      userIn.style.minWidth = sWidth;
      userIn.style.marginLeft = "6px";
      userIn.style.marginRight = "6px";
      userIn.setAttribute("cssVar", cssVars[iRow]);
      userIn.value = getComputedStyle(document.documentElement).getPropertyValue(cssVars[iRow]).trim();
      if (cssVars[iRow].startsWith("--col-")) {

        userIn.setAttribute('type', 'color');
        userIn.setAttribute("cssVar", cssVars[iRow]);
        userIn.onchange = function () {
          let sName = this.getAttribute("cssVar");
          document.documentElement.style.setProperty(sName, this.value);
        }
      } else {
        userIn.setAttribute('type', 'input');
        userIn.readOnly = false;
        userIn.style.minWidth = "42px";
        userIn.style.width = userIn.style.minWidth
        userIn.style.backgroundColor = "var(--col-bg-btn-normal)"
        userIn.style.color = "var(--col-btn-normal-label)"
        userIn.style.textAlign = "right"
        userIn.min = 0;
        userIn.max = 1;
        userIn.onclick = async function () {
          await cxt.keypad(userIn, "value", 0, TYP_FLOAT, parseInt(userIn.min), parseInt(userIn.max))
          userIn.onchange()
        }

        userIn.onchange = function () {
          let sName = this.getAttribute("cssVar");
          let rVal = this.value;
          rVal = rVal > 1 ? rVal / 100 : rVal;
          this.value = rVal;
          document.documentElement.style.setProperty(sName, rVal);
        }
      }
      let myText = document.createElement("p");
      // skip "--" for localization variables
      myText.innerHTML = shmi.localize(`\${${cssVars[iRow].substring(2)}}`);

      flexColor.appendChild(btnMark);
      flexColor.appendChild(userIn);
      flexColor.appendChild(myText);

      divRow.appendChild(flexColor);
      //row added to end of table body
    } else {
      let myHeader = document.createElement("p");
      myHeader.innerHTML = shmi.localize(cssVars[iRow]);
      cssParent.appendChild(myHeader);

      divRow = document.createElement("div");
      divRow.classList.add("flex-row");
      cssParent.appendChild(divRow);

    }
  }
  parent.appendChild(cssParent);
}

/**
 * Check if selected action is available
 */
function isActionSupported(sAction) {
  if ((sAction === "showHelp") && cxt.isWebIqPreview()) {
    shmi.notify("Feature are only available when running in Webbrowser")
    return false;
  }
  return true;
}
/**
 * Toggles visibility of HTML element
 * @param {HTMLElement} oEleme  HTML element (DOM) to toggle
 */
function toggleHide(oEleme) {
  if (oEleme) {
    oEleme.style.display = (oEleme.style.display === "none") ? "block" : "none";
  }
}
/**
 * updates attribute src of provided iframe
 * @param {string} sName name of iframe to update
 * @param {string} sSrc url to write to src attribute of iframe
 */
function updateIframeSrc(sName, sSrc) {
  let sIP = document.location.host;
  let arTypes = ["iframe"];
  let ctrl = shmi.ctrl(sName); // find the 1st element with matching name
  if (ctrl && arTypes.includes(ctrl.uiType)) {
    let sSrcNew = sSrc.replace("${sURL}", sIP);
    ctrl.vars.iframe.setAttribute("src", sSrcNew);
    console.log("iframe URL:" + sSrcNew);
  } else {
    alert(`Type ${ctrl.uiType} must be one of:.\n${arTypes.join()}`);
  }

}

/**
  * Login function for your ctrlX Core, calls getIdmToken to store the authentification token
  */
async function loginCore() {
  const im = shmi.requires("visuals.session.ItemManager");
  // check if connected via reverse proxy
  if (cxt.isWebIqPreview() || (location.port !== "")) {
    if (cxt.isWebIqPreview()) {
      await cxt.msgBox("warning", shmi.localize("${preview-not-supported}"))
    } else {
      let loc = window.location
      if (!loc.pathname.startsWith("/webiq/")) {
        let sRedirect = `https://${loc.hostname}/webiq${loc.pathname}`
        let res = await cxt.msgBox("error", shmi.localize("${InvalidStartOfProject}") + sRedirect, shmi.localize("${redirect-url}"))
        if (res !== null)
          loc.replace(sRedirect);
      }
    }
  }
  //         user     pwd          itemTokenOk            axiosTimeout
  cxApi.init('sUser', 'sPassword', 'virtual:idmTokenValid', 8000)
  let bOK = await cxApi.login()
  if (bOK) {
    // read & display ctrlX name 
    // let jResp = await cxApi.get(`/system/api/v1/info`)
    // cxt.setItem("virtual:sDeviceName", jResp.data.hostname)
  } else
    // show setting screen
    im.writeValue("virtual:iMenuMain", 3)
  return bOK
}

/**
 * appends file to header of iframe dom
 * @param {object} parent   iframe object
 * @param {string} fileName name of css/js file
 */
function loadFile(parent, fileName) {
  let fileRef = undefined
  if (fileName.endsWith(".js")) { //if filename is a external JavaScript file
    fileRef = parent.createElement('script')
    fileRef.setAttribute("type", "text/javascript")
    fileRef.setAttribute("src", fileName)
  } else if (fileName.endsWith(".css")) { //if filename is an external CSS file
    fileRef = parent.createElement("link")
    fileRef.setAttribute("rel", "stylesheet")
    fileRef.setAttribute("type", "text/css")
    fileRef.setAttribute("href", fileName)
  }
  if (typeof fileRef != "undefined") {
    let myHead = parent.getElementsByTagName("head")[0]
    myHead.appendChild(fileRef)
  }
}