'use strict';
const bCfgHideMenuToggle = false         // buttons in header to make side & top menu invisible
const bCfgHideHelp = false                // button in header to display help page
const bCfgHideFullscreen = false         // button in header to toggle fullscreen / framed browser
const bCfgHideKinPosInHeader = true     // x,y,z position of kinematic in header
const bCfgHideCtrlxName = false          // display name of machine in header?
const iCfgHideVirtualKeypad = 1          // -1 automatic, 0=disabled 1=enabled
const iCfgHeartbeatInterval = 3          // 0:disabled >0 check interval in seconds

const bCfgHideSingleSessionInfo = true   // only a single instance of HMI is supported
const bCfgSingleSession = false          // allow only 1 session/clientonly
const HEARTBEAT_PLC = "GVL_BASE.uiHeartBeatPlc" // heartbeat variable from PLC

const arLANGUAGES = ["EN", "DE", "TR"]  // all languages of project, strings are used as dir names of help files
const iDEFAULT_LANG = 0                 // array id of arLANGUAGES for default language

const URL_3D_VIEWER = 'https://${sURL}/3dviewer/Demo%20Model?nosandbox=1';

const URL_CTRLX_DIAG = "https://${sURL}/diagnostics/logbook?showsidebar=false&token=${sToken}";
const URL_TIGER = "https://${sURL}/tiger/index.html?nosandbox=1&token=${sToken}";

const FS_CSS_COL = ":";  // field separator css key:value
const FS_CSS_ROW = ",";  // field separator css set1,set2,...

const SCRIPT_FILE_NAME = "GVL_CUSTOMER.refScriptName" // name of python script stored in recipe (UTF8)
const V_SCRIPT_FILE_NAME = "virtual:strScriptName"    // name of python script converted to UTF16

const arTabUserGroupsShow = ["admin"] // hide for "operator", "service"
// first tab is button_1
const cssCmd = "{display: none;}"
const cssHideTabs = {
  "home-2": `[data-name="tab-home"] [data-name="button_2"] ${cssCmd}`,              // charts
  "home-4": `[data-name="tab-home"] [data-name="button_4"] ${cssCmd}`,              // set deadan, alarms, warns, infos
  "diag-3": `[data-name="tab-diagnostic"] [data-name="button_3"] ${cssCmd}`,        // ctrlX diag
  "commision-6": `[data-name="tab-comissioning"] [data-name="button_6"] ${cssCmd}`, // sys state
  "commision-7": `[data-name="tab-comissioning"] [data-name="button_7"] ${cssCmd}`, // jog
  "setting-3": `[data-name="tab-settings"] [data-name="button_3"] ${cssCmd}`,       // user mgr
  "recipe-6": `[data-name="tab-recipe"] [data-name="button_6"] ${cssCmd}`           // place points
}

// css selectors to hide IDE controls
const arIdeUserGroupsShow = ["admin"] // hide for "operator", "service"
const cssHideIdeCtrls = {
  // buttons on main screen
  "homeHome": `#homemenu > div.left.menu > a ${cssCmd}`,
  "gearHome": `#homemenu > div.right.menu > div ${cssCmd}`,
  // buttons on editor screen
  "start": `#editortools > div.ui.compact.menu > div > div:nth-child(1) > div:nth-child(1) ${cssCmd}`,
  "debug": `#editortools > div.ui.compact.menu > div > div:nth-child(1) > div:nth-child(2) ${cssCmd}`,
  "github": `#projectNameArea > div > button ${cssCmd}`,
  "editorToggle": `#editortoggle ${cssCmd}`,
  "deployBrowser": `#editortools > div.ui.compact.menu > div > div.ui.simple.bottom.dropdown.item > div.menu > div:nth-child(1) ${cssCmd}`,
  // "deployTarget" : `#editortools > div.ui.compact.menu > div > div.ui.simple.bottom.dropdown.item > div.menu > div:nth-child(2) ${cssCmd}`,
  "deployIDE": `#editortools > div.ui.compact.menu > div > div.ui.simple.bottom.dropdown.item > div.menu > div:nth-child(3) ${cssCmd}`,
  "gear": `#mainmenu > div.right.menu > div.ui.dropdown.icon.item.icon.more-dropdown-menuitem ${cssCmd}`,
  // blocks editor not working (svg graphics)
  // "cfgMotion": `#blocksEditor > div > svg:nth-child(6) > g > g.blocklyBlockCanvas > g.blocklyFlyoutButton.__web-inspector-hide-shortcut__ ${cssCmd}`,
  // "cfgMotionMore": `#blocksEditor > div > svg:nth-child(7) > g > g.blocklyBlockCanvas > g.blocklyFlyoutButton.__web-inspector-hide-shortcut__ ${cssCmd}`,
  // "cfgInOut": `#blocksEditor > div > svg:nth-child(8) > g > g.blocklyBlockCanvas > g.blocklyFlyoutButton.__web-inspector-hide-shortcut__ ${cssCmd}`,
  // "cfgDataLayer": `#blocksEditor > div > svg:nth-child(14) > g > g.blocklyBlockCanvas > g.blocklyFlyoutButton.__web-inspector-hide-shortcut__ ${cssCmd}`,
  // "cfgDataLayerMore": `#blocksEditor > div > svg:nth-child(15) > g > g.blocklyBlockCanvas > g.blocklyFlyoutButton.__web-inspector-hide-shortcut__ ${cssCmd}`
}