' Windows has no build in SVG preview. Therefore this script
' Creates a _SvgImages.htm with all svg files in current directory

sImgWidth = "40"               ' width of image in html page
sFileName = "_ImgPreview.htm"  ' name of htm file
sBgColor  = "lightblue"        ' background color of HTML page, different to white a contrast for white img's
sImgExt   = "svg,png,jpg"      ' comma separated list of image extensions

sMsg      = "Create file '" & sFileName & "'" & vbCrLf & "containing images with extensions" 
sMsg      = sMsg & vbCrLf & "  '" & sImgExt & "'"
sMsg      = sMsg & vbCrLf & vbCrLf & "Recursive listing of images?"
result = MsgBox(sMsg,vbYesNo+vbQuestion, "Recursive listing")

Set objFSO = CreateObject("Scripting.FileSystemObject")
iLenPath = Len(Wscript.ScriptFullName) - Len(Wscript.ScriptName)
sStartFolder = LEFT(Wscript.ScriptFullName, iLenPath)

Set objFolder = objFSO.GetFolder(sStartFolder)

sOutFile = sStartFolder & sFileName

Set fsoOut = objFSO.CreateTextFile(sOutFile,True)

fsoOut.WriteLine "<!DOCTYPE html>" 
fsoOut.WriteLine "<head>"
fsoOut.WriteLine "</head>"
fsoOut.WriteLine "<body style=""background-color:" & sBgColor & ";"">"
fsoOut.WriteLine "<H2>" & sStartFolder & "</H2>"
Set myFiles = objFolder.Files

For Each objFile in myFiles
    sExt = LCase(Right(objFile.Name, 3))
    If (sExt = "svg") OR (sExt="png") OR (sExt="jpg") Then
       fsoOut.WriteLine "<img width=" & sImgWidth & " src=""" & objFile.Name & """ title=""" & objFile.Name & """>"
    End If
Next

Set myFolders = objFolder.SubFolders

If (result=vbYes) Then
    ShowSubFolders objFolder
End If

fsoOut.WriteLine " </body></HTML>"

fsoOut.Close

Function ExtOk(sName, sImgExt)
  ExtOk   = 0 ' set default return value
  ' convert all strings to lower case for string compare
  sImgExt = Lcase(sImgExt)
  sName   = LCase(sName)

  arName   = split(sName, ".")
  arImgExt = split(sImgExt, ",")
  sExt     = arName(UBound(arName))

  ' check if file extension is in array
  For i=LBound(arImgExt) To UBound(arImgExt)
    If (arImgExt(i)=sExt) Then
      ExtOk = 1
      Exit Function
    End If
  Next
End Function

Sub ShowSubFolders(Folder)
    'Wscript.Echo "sOutFIle=" & objStartFolder
    For Each Subfolder in Folder.SubFolders
        'Wscript.Echo "Folder: " & Subfolder.Path
        fsoOut.WriteLine "<H2>." & Mid(Subfolder.Path, iLenPath) & "</H2>"
        Set objFolder = objFSO.GetFolder(Subfolder.Path)
        Set colFiles = objFolder.Files
        For Each objFile in colFiles
            If (ExtoK(objFile.Name, sImgExt)>0) Then
               ' show only relativ path, by cutting parent folder
               sImg = Mid(Subfolder.Path, iLenPath+1) & "\" & objFile.Name
               fsoOut.Write "<img height=" & sImgWidth & " src=""" & sImg & """ title=""" & objFile.Name & """>"
            End If

            'Wscript.Echo ">>>File: " & Subfolder.Path & "\" & objFile.Name
        Next

        ShowSubFolders Subfolder
    Next
End Sub


REM Wscript.Echo "Created file " & sOutFile & vbCrLf & "Open it to display preview of all svg graphics in this folder."