/**
 * Description: Toggles between kiosk and framed browser
 */
(function () {
    var actions = shmi.pkg("visuals.session.userActions"); //get reference to userActions object
    actions["toggleFullscreen"] = function (parameters) {
        let myBody = document.body;
        let isFullscreen = document.webkitIsFullScreen || document.mozFullScreen || false;
        myBody.requestFullScreen = myBody.requestFullScreen || myBody.webkitRequestFullScreen || myBody.mozRequestFullScreen || function () {
            return false;
        };
        document.cancelFullScreen = document.cancelFullScreen || document.webkitCancelFullScreen || document.mozCancelFullScreen || function () {
            return false;
        };

        isFullscreen ? document.cancelFullScreen() : myBody.requestFullScreen();
    };
}());