/**
 * Custom UI-Action 'setKeypad'.
 *
 * Description:
 * enables/disables virtual keypad
 */
(function () {
    var actions = shmi.pkg("visuals.session.userActions"); //get reference to userActions object
    actions["setKeypad"] = function (p) {
        const bEnable = p[0]
        // switch to a different main menu item, because current
        // screen must be recreated to activate different virtual keypad settings
        const ITEM_MENU = "virtual:iMenuMain"
        const iMainMenu = cxt.getItem(ITEM_MENU)
        cxt.setItem(ITEM_MENU, 0)
        cxt.keypadEnable(bEnable)
        setTimeout(() => cxt.setItem(ITEM_MENU, iMainMenu))
    };
}());