/**
 * Custom UI-Action 'selectTextList'.
 *
 * Description:
 * opens dialog to select a text list
 */
(function () {
    let actions = shmi.pkg("visuals.session.userActions"); //get reference to userActions object
    actions["selectTextList"] = async function (p) {
        const sItem = p[0]
        const iRow = await cxt.getItem(p[1])

        let sFS = ""
        let sOpt = ""
        for (const sKey in cxt.textList) {
            sOpt += sFS + sKey
            sFS = "|"
        }
        const sRowFs = "\n"
        const sColFs = "="
        let sResult = await cxt.msgBox("select", "Select a color", "", sOpt, "|", "=")
        if (sResult !== null) {
            let arRows = await cxt.getItem(sItem).split(sRowFs)
            let arCols = arRows[iRow].split(sColFs)
            arRows[iRow] = arCols[0] + sColFs + sResult
            cxt.setItem(sItem, arRows.join(sRowFs))
        }
    };
}());