/**
 * Custom UI-Action '_showHelp'.
 *
 * Description: Show help information
 *   Show default help, if help for active language is missing
 */
(function () {
    'use strict'
    var actions = shmi.pkg("visuals.session.userActions"); //get reference to userActions object
    actions["_showHelp"] = async function (parameters) {
        let sFile1, sFile2
        let sHtml1, sHtml2
        let sPdf1, sPdf2
        let sUrl
        // in webIQ internal preview, show PDF
        if (cxt.isWebIqPreview()) {
            sUrl = "docs/Basic-Hints-Template-Handling.pdf";
            window.open(sUrl, "_docWin");
        } else {
            const myIframe = cxt.getCtrl("iframe-help-context", "iframe");
            if (!myIframe)
                return;

            const im = shmi.requires("visuals.session.ItemManager");
            const iMenuMain = im.readValue("virtual:iMenuMain");
            const iMenuSub = im.readValue("virtual:iMenuSub");
            let iLangActual = shmi.localize("${iLangId}")
            sFile1 = `docs/help/${arLANGUAGES[iDEFAULT_LANG]}/help${iMenuMain}-${iMenuSub}`
            sFile2 = `docs/help/${arLANGUAGES[iLangActual]}/help${iMenuMain}-${iMenuSub}`

            sHtml1 = sFile1 + ".htm"
            sPdf1 = sFile1 + '.pdf'
            sHtml2 = sFile2 + ".htm"
            sPdf2 = sFile2 + '.pdf'

            if (cxt.existsFile(sPdf2))
                sUrl = sPdf2
            else if (cxt.existsFile(sHtml2))
                sUrl = sHtml2
            else if (cxt.existsFile(sPdf1))
                sUrl = sPdf1
            else if (cxt.existsFile(sHtml1))
                sUrl = sHtml1
            else {
                cxt.msgTop("info", "No help available")
                return
            }

            myIframe.vars.iframe.setAttribute("src", sUrl);
            new shmi.visuals.core.UiAction([{ name: "toggle-class", params: ["box-help-hidden", "hidden"] }]).execute();
        }
    };
}());