(function () {
    'use strict'
    var actions = shmi.pkg("visuals.session.userActions"); //get reference to userActions object

    /**
     * UI-Action '_overwriteRecipe' implementation
     * @params {any[]} parameters  configured ui-action parameters
     * 
     */
    actions["_overwriteRecipe"] = async function (parameters) {
        // read existing recipes
        const RCP_NEW_NAME = "virtual:strRecipeNameNew"
        const RCP_MSG = "GVL_CUSTOMER.stRecipeMgr.strCmd"
        const EXT = ".rcp"
        let sNameNew = await cxt.getItem(RCP_NEW_NAME)

        // check for invalid chars or empty string
        let bInvalid = /[/\\:*?"<>|=]/.test(sNameNew)
        if (bInvalid || sNameNew === "") {
            cxt.msgBox("warning", shmi.localize("${invalid-filename}"))
            return
        }

        // read recipes and check if new name exists
        let arRecipeFiles = await dirList("configurations/appdata/recipe", EXT, true, false)
        let bExist = false
        let sCheck = sNameNew + EXT
        for (let i = 0; i < arRecipeFiles.length; i++) {
            if (arRecipeFiles[i].name === sCheck) bExist = true
        }
        if (bExist) {
            let res = await cxt.msgBox("confirm", "${overwrite-recipe}\n" + sNameNew, "${overwrite}")
            if (res === null) {
                return
            }
        }
        // sNameNew = cxt.utf16_2_utf8(sNameNew)
        sNameNew = shmi.to_utf8(sNameNew)
        cxt.setItem(RCP_MSG, `saveas ${sNameNew}`)
        cxt.setItem(RCP_NEW_NAME, '')
        new shmi.visuals.core.UiAction({
            name: "dialog",
            params: [".dialogbox-save-as", "hide"]
        }).execute();
    };
}());