/**
 * Custom UI-Action '_increaseItem'.
 *
 * Description:
 * increase/descrease item within limits
 */
(function () {
    var actions = shmi.pkg("visuals.session.userActions"); //get reference to userActions object

    /**
     * UI-Action '_increaseItem' implementation
     *
     * @params {any[]} parameters  configured ui-action parameters
     * ---- Initial parameters, needs to be updated manually when changed ----
     * @param {string} parameters[0]  item (Int, Float)
     * @param {number} parameters[1]  Step
     * @param {number} parameters[2]  Min
     * @param {number} parameters[3]  Max
     *
     */
    actions["_increaseItem"] = async function (parameters) {
        let sItem = parameters[0]
        let iStep = parameters[1]
        let iMin = parameters[2]
        let iMax = parameters[3]

        let iValue = await cxt.getItem(sItem)
        iValue += iStep
        if (iValue < iMin)
            iValue = iMin
        else if (iValue > iMax)
            iValue = iMax
        cxt.setItem(sItem, iValue)
    };
}());