/**
 * Custom UI-Action '_callFuncs'.
 *
 * Description:
 * Calls different functions
 */
(function () {
    var actions = shmi.pkg("visuals.session.userActions"); //get reference to userActions object
    // function utoa(str) {
    //     return window.btoa(unescape(encodeURIComponent(str)));
    // }
    // // base64 encoded ascii to ucs-2 string
    // function atou(str) {
    //     return decodeURIComponent(escape(window.atob(str)));
    // }
    /**
     * UI-Action '_callFuncs' implementation
     *
     * @params {any[]} parameters  configured ui-action parameters
     * ---- Initial parameters, needs to be updated manually when changed ----
     * @param {string} parameters[0]  sAction
     * @param {string} parameters[1]  sParam1
     *
     */
    actions["_callFuncs"] = async function (parameters) {
        const FS_DROW = "\n"
        const FS_DCOL = "\t"
        const im = shmi.requires("visuals.session.ItemManager")
        let sAction = parameters[0]
        let sParam1 = parameters[1]

        if (sAction === "cleanMonitor") {
            cxt.cleanMonitor(sParam1)
        } else if (sAction === "svg") {
            let x = cxt.getCtrl("box-svg").marginCompensator
            svgStart(0, 0, 150, 120)
            // svgStart() // no view box
            let jMax = 8
            let iMax = 10
            for (let j = 0; j < jMax; j++)
                for (let i = 0; i < iMax; i++)
                    svgCircle(10 + i * 14, 10 + j * 14, 5.6, i + j * iMax)
            svgEnd()
            x.innerHTML = sSvg
        } else if (sAction === "dirList") {
            let arR, sMsg, sExt, sPyPath
            sPyPath = ""
            if (sParam1.startsWith("python")) {
                // dir, ext, bFile, bDir
                sExt = ".py"

                if (sParam1 === "python-visual")
                    sPyPath = "/scripts/bosch/tiger/"
                else
                    sPyPath = "/script/"

                arR = await dirList("configurations/appdata" + sPyPath, sExt, true, false)
                sMsg = "${select-file}"
                sItem = "GVL_CUSTOMER.stRecipeMgr.strCmd"
            } else if (["recipeOpen", "recipeDel"].includes(sParam1)) {
                sExt = ".rcp"
                arR = await dirList("configurations/appdata/recipe", sExt, true, false)
                sMsg = "${select-file}"
                sItem = "GVL_CUSTOMER.stRecipeMgr.strCmd"

            } else if (["gcodeOpen", "gcodeDel"].includes(sParam1)) {
                sExt = ".txt"
                let sPath = "/var/snap/rexroth-ide/common/solutions/activeConfiguration/scripts/gcode"
                sPath = "/configurations/appdata/scripts/gcode"
                arR = await dirList(sPath, sExt, true, false)
                sMsg = "${select-file}"
                sItem = "GVL_CUSTOMER.stRecipeMgr.strCmd"
            }
            let sOpt = ""
            let sFS = ""
            let iLen = sExt.length
            for (i = 0; i < arR.length; i++) {
                arR[i].name
                sOpt += sFS + arR[i].name.substring(0, arR[i].name.length - iLen)
                sFS = FS_DROW
            }
            let sLabel = (sParam1 === "recipeDel") ? "${delete}" : "${open}"
            let res = await cxt.msgBox("select", sMsg, sLabel, sOpt)
            if (res !== null) {
                let sCmd
                if (sParam1 === "recipeDel") {
                    let res1 = await cxt.msgBox("confirm", `Delete file ?\n${res}`)
                    if (res1 !== null) {
                        // sCmd = `del ${cxt.utf16_2_utf8(res)}`
                        sCmd = `del ${shmi.to_utf8(res)}`
                        cxt.setItem(sItem, sCmd)
                    }
                } else {
                    // sCmd = `open ${cxt.utf16_2_utf8(sPyPath + res)}`
                    // if (["gcodeOpen", "gcodeDel"].includes(sParam1))
                        // sCmd = shmi.to_utf8(res + sExt)
                    // else
                        sCmd = `open ${shmi.to_utf8(sPyPath + res)}`
                    cxt.setItem(sItem, sCmd)
                }
            }
        } else if (sAction === "utf") {
            let text = "汽车=auto"
            // let text = "auto"
            let utf8 = shmi.to_utf8(text)
            console.log(utf8)
            let utf16 = shmi.from_utf8(utf8)
            console.log(utf16)
        } else if (sAction === "sys-info") {
            cxt.overlayWait(true)
            try {
                const TAB_CFG = "stTab.strCfg"
                const TAB_DATA = "stTab.strData"
                const TAB_STATE = "stTab.strState"

                let r = {}
                if (sParam1 === "axes") {
                    r = await readAxes()
                } else if (sParam1 === "kinematics")
                    r = await readKinematics()
                else if (sParam1 === "apps")
                    r = await readApps()
                else if (sParam1 === "licenses")
                    r = await readLicenses()
                else if (sParam1 === "app-licenses")
                    r = await readAppsLicense()
                else if (sParam1 === "host-info")
                    r = await readHostInfo()
                else if (sParam1 === "plcVars")
                    r = await readPlcVars()
                else if (sParam1 === "recipes")
                    r = await readDirListing("configurations/appdata/recipe", ".rcp", true, true)
                else if (sParam1 === "python")
                    r = await readDirListing("configurations/appdata/script")
                else
                    cxt.msgBox("bug", "_callFuncs: Invalid sParam: ", + sParam1)
                if (r.cfg) {
                    await cxt.setItem(TAB_CFG, r.cfg, true)
                    await cxt.setItem(TAB_DATA, r.data, true)
                    cxt.setItem(TAB_STATE, r.msg)
                    console.log(TAB_STATE + ":" + r.msg)
                }
                await cxt.wait(300)
            } catch { }
            cxt.overlayWait(false)
        } else if (sAction === "toggleMenuHiding") {
            const ITEM_HIDE_MAIN = "virtual:iHideMenuMain"
            const ITEM_HIDE_OP = "virtual:iHideMenuOpMode"
            const ITEM_HIDE_COUNT = "virtual:iHideCounter"
            let iCounter = im.readValue(ITEM_HIDE_COUNT)
            iCounter = (iCounter === 3) ? 0 : iCounter + 1
            let iMain = (iCounter >> 0) & 1
            let iOp = (iCounter >> 1) & 1
            im.writeValue(ITEM_HIDE_COUNT, iCounter)
            im.writeValue(ITEM_HIDE_MAIN, (iCounter >> 0) & 1)
            im.writeValue(ITEM_HIDE_OP, (iCounter >> 1) & 1)

            console.log(iCounter)
        } else {
            cxt.msgBox("bug", "_callFuncs: Invalid sAction: " + sAction)
        }

        // ucs-2 string to base64 encoded ascii
    };
}());