(function () {
    'use strict'
    var MODULE_NAME = "start-up-system-state",
        ENABLE_LOGGING = false,
        RECORD_LOG = false,
        logger = shmi.requires("visuals.tools.logging").createLogger(MODULE_NAME, ENABLE_LOGGING, RECORD_LOG),
        fLog = logger.fLog,
        log = logger.log,
        module = shmi.pkg(MODULE_NAME);

    // MODULE CODE - START
    // private variables
    // private functions

    /**
     * This function will be called each time a local-script will be enabled.
     * @param {LocalScript} self instance reference of local-script control
     */
    module.run = function (self) {
        let tok = null
        const im = shmi.requires("visuals.session.ItemManager")
        const cancelable = shmi.onReady({
            controls: { myBox: ".box-table-sys-state" }
            // items: {  },
            // resources: {}
        }, function (resolved) {
            // subscribe item with HTML table code
            tok = im.subscribe(["GVL_BASE.strSystemState"],
                async function (name, value, type) {
                    let divTable = cxt.getCtrl("box-table-sys-state")
                    divTable = divTable.marginCompensator
                    divTable.innerHTML = value
                });
        });
        cxt.cssSetVar("--c1-talign", "left")
        /* called when this local-script is disabled */
        self.onDisable = function () {
            tok.unlisten()
            cancelable.cancel();
            self.run = false; /* from original .onDisable function of LocalScript control */
        };
    };

    // MODULE CODE - END
    fLog("module loaded");
})();
