(function () {
    'use strict'
    var MODULE_NAME = "start-up-settings-global",
        ENABLE_LOGGING = false,
        RECORD_LOG = false,
        logger = shmi.requires("visuals.tools.logging").createLogger(MODULE_NAME, ENABLE_LOGGING, RECORD_LOG),
        fLog = logger.fLog,
        log = logger.log,
        module = shmi.pkg( MODULE_NAME );

    /**
     * Implements local-script run function.
     * @param {LocalScript} self instance reference of local-script control
     */
    module.run = function (self) {
        const im = shmi.requires("visuals.session.ItemManager")
        cxt.setItem("virtual:language", shmi.localize("${iLangId}"))
        let tok = im.subscribe(["iCssSelected", "sCssGroup[2]", "sCssGroup[3]"], (name, value, type) => {
            cssThemeLoad(true);
        });
        /* called when this local-script is disabled */
        self.onDisable = function () {
            tok.unlisten();
            self.run = false; /* from original .onDisable function of LocalScript control */
        };
    };

    // MODULE CODE - END
    fLog("module loaded");
})();
