(function () {
    var MODULE_NAME = "start-up-dbg-funcs",
        ENABLE_LOGGING = false,
        RECORD_LOG = false,
        logger = shmi.requires("visuals.tools.logging").createLogger(MODULE_NAME, ENABLE_LOGGING, RECORD_LOG),
        fLog = logger.fLog,
        log = logger.log,
        module = shmi.pkg(MODULE_NAME);

    module.run = function (self) {
        let tok2 = null

        // * 'motion/kin/Robot/state/diag-info/diag-descr'
        // const im = shmi.requires("visuals.session.ItemManager")
        const cancelable = shmi.onReady({
            controls: {
                safeArea: ".box-safe-area-states"
            }
        }, function (resolved) {
            // subscribe item with HTML table code
            // TODO: adapt kinematic name to existing one to avoid errors
            const KIN_NAME = 'Robot'
            // const KIN_NAME = 'Kinematics_1'
            if (true) {
                const KIN_STATE = `motion/kin/${KIN_NAME}/state`
                const SAFE_AREA_PRESELECTED = `${KIN_STATE}/diag/cmd-opt-preselected`
                const SAFE_AREA_ACTIVE = `${KIN_STATE}/diag/cmd-opt-active`
                const PLC_OPEN_STATE = `${KIN_STATE}/opstate/plcopen`
                const sMgr = "/automation/api/v2/nodes"
                tok2 = setInterval(async function () {
                    let sOut = ""
                    let jResp = ""
                    // cxt.setItem("GVL_CUSTOMER.stDebugVars.strCmd", "cmd updateCells")

                    jResp = await cxApi.get(`${sMgr}/${PLC_OPEN_STATE}`)
                    sOut += `State ${KIN_NAME}:&nbsp;` + jResp.data.value + "<BR><BR>"

                    jResp = await cxApi.get(`${sMgr}/${SAFE_AREA_PRESELECTED}`)
                    let myWords = jResp.data.value.split(";")
                    myWords.forEach(sWord => {
                        if (sWord.startsWith("safeZones"))
                            sOut += "<u>Preselected " + sWord.replace("(", "</u>").replace(")", "").replaceAll(",", ", ")
                    });
                    jResp = await cxApi.get(`${sMgr}/${SAFE_AREA_ACTIVE}`)
                    myWords = jResp.data.value.split(";")
                    myWords.forEach(sWord => {
                        if (sWord.startsWith("safeZones"))
                            sOut += "<BR><BR><u>Active " + sWord.replace("(", "</u>").replace(")", "").replaceAll(",", ", ")
                    });

                    resolved.controls.safeArea.marginCompensator.innerHTML = sOut
                }, 900)
            }

        });
        cxt.cssSetVar("--c1-talign", "left")
        /* called when this local-script is disabled */
        self.onDisable = function () {
            console.clear()
            if (tok2) clearInterval(tok2)
            if (cancelable) cancelable.cancel();
            self.run = false;
        };
    };
    // MODULE CODE - END
    fLog("module loaded");
})();
