/**
 * @description installed by package cxTools
 * @version 1.0.0
 * Do not edit, because changes are lost, when package is reinstalled
 * 
 * 1.1.0 -setItem(): add option { skipSameValueCheck: true } to im.writeValue()
 *       -add tooltip functionality
 *       -add DataURL images
 *       -show interrupt time in connection error dialog
 *       -add bit functions
 *       -add existsFile(), isTooltipEnabled()
 *       -msgBox() localize select options
 *       -add this.textList = "tl-trueFalse": { "0": "false", "1": "true" }, "tl-onOff": { "0": "off", "1": "on" } }
 *       -keypad: bugfix for key ESC. Do not use entered value
 *       -getOverlay() disable context menu
 * 1.0.0 -extend keypad features (support input via HW keyboard, show item name)
 *       -add keypadAddLanguage(), keypadEnable(), msgTop(), formatString()
 *       -use promise in getItem()/setItem() 
 *       -keypad(): added, use css, added 2nd language "en", new option "input"
 *       -msgBox(): use css
 *       -css in external file 
 */
"use strict";  // variables must be defined
// type values used in item properties
const TYP_STRING = 0
const TYP_BOOL = 1
const TYP_INT = 2
const TYP_FLOAT = 3
const TYP_PASSWORD = 88
const TYP_LIST = 99
const TOOLTIP_ITEM = "virtual:iShowTooltip"

const DEFAULT_MIN = -100000000
const DEFAULT_MAX = 100000000

const CHAR_OK = `✔`
const CHAR_CANCEL = "✘"
const CHAR_SHIFT = "⇪"
const CHAR_DEL = "⌫"
const CHAR_LEFT = "<" //"⤌"
const CHAR_RIGHT = ">" //"⇥"
const CHAR_START = "|≪"// "⇤"
const CHAR_END = "≫|" //"⇥"
const CHAR_PLUSMIN = "±"
const CHAR_WLEFT = "≪"      //String.fromCharCode(10508), 
const CHAR_WRIGHT = "≫"      //String.fromCharCode(10509),

const PREFIX_HEX = "0& "
const PREFIX_BIN = "2& "
const PREFIX_DEC = ""

const ZINDEX_MSGBOX = 90000
const ZINDEX_KEYPAD = ZINDEX_MSGBOX + 1
const ZINDEX_CONNECT_ERR = 10 * ZINDEX_MSGBOX
const ROW_HEIGHT = "40px"
const MOVE_CURSOR_CMDS = ["#|<", "#<<", "#<", "#>", "#>>", "#>|"]
const CXT_CLIENT_ID = "ID=" + Date.now().toString(32)

// /** @namespace cxTools.wrapperWebIQ */
// /** @namespace cxTools.dialogs */
// /** @namespace cxTools.commonTools */
// /** @namespace cxTools.filter */
// /** @namespace cxTools.sort */
// /** @namespace cxTools.format */


let cxt = new class cxTools {
    constructor() {
        this.startID = "ID=" + Date.now().toString(32)

        this.numPadFloat = {
            char: [
                { lower: "1 2 3" },
                { lower: "4 5 6" },
                { lower: "7 8 9" },
                { lower: ". 0 #<del" }
            ],

            header: { lower: "#< #> #clear" },
            // header: { lower: "#clear" },  // keep empty for no header buttons
            footer: { lower: "#cancel #+- #ok" }
        }
        this.numPadInt = {
            char: [
                { lower: "1 2 3" },
                { lower: "4 5 6" },
                { lower: "7 8 9" },
                { lower: "0 #<del" }
            ],

            // header: { lower: "#< " },
            header: { lower: "#< #> #clear" },  // keep empty for no header buttons
            footer: { lower: "#cancel #+- #ok" }
        }
        this.sKeypadLanguage = "en"
        this.keypadLanguages = {
            de: {
                char: [
                    {
                        lower: "° 1 2 3 4 5 6 7 8 9 0 ß",
                        upper: '^ ! " § $ % & / ( ) = ?'
                    },
                    {
                        lower: "q w e r t z u i o p ü #<del",
                        upper: "Q W E R T Z U I O P Ü #<del"
                    },
                    {
                        lower: "a s d f g h j k l ö ä #",
                        upper: "A S D F G H J K L Ö Ä '"
                    },
                    {
                        lower: "#shift < y x c v b n m , . -",
                        upper: "#shift > Y X C V B N M ; : _"
                    }
                ],

                number: [
                    {
                        lower: "° 1 2 3 4 5 6 7 8 9 0 ß",
                        upper: '^ ! " § $ % & / ( ) = ?'
                    },
                    {
                        lower: "q w e r t z u i o p ü #<del",
                        upper: "Q W E R T Z U I O P Ü #<del"
                    },
                    {
                        lower: "a s d f g h j k l ö ä #",
                        upper: "A S D F G H J K L Ö Ä '"
                    },
                    {
                        lower: "#shift < y x c v b n m , . -",
                        upper: "#shift > Y X C V B N M ; : _"
                    }
                ],
                // header: { lower: "#|< #< #clear #> #>|" },
                header: { lower: "#|< #<< #< #clear #> #>> #>|" },
                // header: { lower: "" },  // keep empty for no header buttons
                footer: { lower: "#cancel #space #ok" }
                // footer: { lower: "#cancel #abc #space #123 #ok" }
            },
            en: {
                char: [
                    {
                        lower: "° 1 2 3 4 5 6 7 8 9 0 - =",
                        upper: '` ! " £ $ % ^ & * ( ) _ +'
                    },
                    {
                        lower: "q w e r t y u i o p { } #<del",
                        upper: "Q W E R T Y U I O P [ ] #<del"
                    },
                    {
                        lower: "a s d f g h j k l : @ ~",
                        upper: "A S D F G H J K L ; ' #"
                    },
                    {
                        lower: "#shift | z x c v b n m < > ?",
                        upper: "#shift \\ Z X C V B N M , . /"
                    }
                ],

                number: [
                ],
                // header: { lower: "#|< #< #clear #> #>|" },
                header: { lower: "#|< #<< #< #clear #> #>> #>|" },
                // header: { lower: "" },  // keep empty for no header buttons
                footer: { lower: "#cancel #space #ok" }
                // footer: { lower: "#cancel #abc #space #123 #ok" }
            }
        }
        this.textList = { "tl-trueFalse": { "0": "FALSE", "1": "TRUE" }, "tl-onOff": { "0": "OFF", "1": "ON" } }
        this.bKeypadEnabled = true;
        this.titleWin = null // tooltip window dom element
        this.jOnReady = {}
        this.myMsgBoxOverlay = null
        this.cfgMsgBox = {
            bgcolOverlay: "rgba(0,0,0, 0.4)",

            colContent: "black", //"black",
            bgcolContent: "white", //"white",

            colInfo: "black",
            bgcolInfo: "#d9faa0",

            colWarn: "black",
            bgcolWarn: "#fad3a0",

            colErr: "black",
            bgcolErr: "#f78f86",

            colConfirm: "black",
            bgcolConfirm: "#98CBF9",

            colSelect: "black",
            bgcolSelect: "#98CBF9",
            imgLock: "data:image/svg+xml;base64,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",
            imgAxLinear: "data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiPz4KPCEtLSBHZW5lcmF0b3I6IEFkb2JlIElsbHVzdHJhdG9yIDI1LjAuMCwgU1ZHIEV4cG9ydCBQbHVnLUluIC4gU1ZHIFZlcnNpb246IDYuMDAgQnVpbGQgMCkgIC0tPgo8c3ZnIHZlcnNpb249IjEuMSIgaWQ9Ikljb25feDVGX2NvbnRvdXIiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiIHg9IjBweCIKCSB5PSIwcHgiIHZpZXdCb3g9IjAgMCAxOTIgMTkyIiBzdHlsZT0iZW5hYmxlLWJhY2tncm91bmQ6bmV3IDAgMCAxOTIgMTkyOyIgeG1sOnNwYWNlPSJwcmVzZXJ2ZSI+CjxwYXRoIGQ9Ik0xNzYuMDAwOTgsMTI4LjAwMDk4SDMzLjY1NzU5bDE3LjIxMzUsMTcuMjEzODdsLTUuNjU3MjMsNS42NTYyNWwtMjYuODY5NjMtMjYuODcwMTJsMjYuODY5NjMtMjYuODcwMTJsNS42NTcyMyw1LjY1NjI1CglsLTE3LjIxMzUsMTcuMjEzODdoMTQyLjM0MzM4VjEyOC4wMDA5OHogTTE0MS4xNzE4OCw4OS4yMTI4OWw1LjY1NjI1LDUuNjU3MjNMMTczLjY5OTIyLDY4bC0yNi44NzEwOS0yNi44NzAxMmwtNS42NTYyNSw1LjY1NzIzCglMMTU4LjM4NDc3LDY0SDE2djhoMTQyLjM4NDc3TDE0MS4xNzE4OCw4OS4yMTI4OXoiLz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPC9zdmc+Cg==",
            imgAxRotary: "data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiPz4KPCEtLSBHZW5lcmF0b3I6IEFkb2JlIElsbHVzdHJhdG9yIDI0LjAuMSwgU1ZHIEV4cG9ydCBQbHVnLUluIC4gU1ZHIFZlcnNpb246IDYuMDAgQnVpbGQgMCkgIC0tPgo8c3ZnIHZlcnNpb249IjEuMSIgaWQ9Ikljb25feDVGX2NvbnRvdXIiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiIHg9IjBweCIKCSB5PSIwcHgiIHZpZXdCb3g9IjAgMCAxOTIgMTkyIiBzdHlsZT0iZW5hYmxlLWJhY2tncm91bmQ6bmV3IDAgMCAxOTIgMTkyOyIgeG1sOnNwYWNlPSJwcmVzZXJ2ZSI+CjxwYXRoIGQ9Ik02OC41MjY4NiwyOS40MjU3OGwtMy4wNTQ2OS03LjM5MzU1YzcuMDU2NjQtMi45MTU1MywxNC40OTYwOS00Ljc5Nzg1LDIyLjExMTgyLTUuNTk0NzNsMC44MzIwMyw3Ljk1NzAzCglDODEuNTY0OTQsMjUuMTExMzMsNzQuODczMDUsMjYuODA0Miw2OC41MjY4NiwyOS40MjU3OHogTTYxLjg5Njk3LDMyLjU3MjI3bC0zLjc5NDkyLTcuMDQyOTcKCWMtNi45NzY1NiwzLjc1OTI4LTEzLjM1MDEsOC41MjkzLTE4Ljk0NDM0LDE0LjE3NzI1bDUuNjg0NTcsNS42Mjk4OEM0OS44Nzg5MSw0MC4yNTA0OSw1NS42MTcxOSwzNS45NTYwNSw2MS44OTY5NywzMi41NzIyN3oKCSBNNDAuMTczMzQsNTAuNTI3ODNsLTYuMjAwMi01LjA1NTY2Yy00Ljk0Njc4LDYuMDY1OTItOC45NjQzNiwxMi43OTQ5Mi0xMS45NDA5MiwyMC4wMDA0OWw3LjM5MzU1LDMuMDU0NjkKCUMzMi4xMDQsNjIuMDQzOTUsMzUuNzIwMjEsNTUuOTg4MjgsNDAuMTczMzQsNTAuNTI3ODN6IE0xNiw5Nmg4YzAtNy4xMDEwNywxLjAzMDI3LTE0LjExMzc3LDMuMDYyMDEtMjAuODQzNzVsLTcuNjU4Mi0yLjMxMjUKCUMxNy4xNDUwMiw4MC4zMjQyMiwxNiw4OC4xMTUyMywxNiw5NnogTTk2LDE2djhjMzkuNzAxMTcsMCw3MiwzMi4yOTg4Myw3Miw3MnMtMzIuMjk4ODMsNzItNzIsNzIKCWMtMjEuNzUzOTcsMC00MC45ODkyNi05LjkwMjEtNTQuNjc2NTctMjhINzJ2LThIMjh2NDRoOHYtMjkuNzk2NTdDNTEuMTUwMjcsMTY1LjQ3ODIxLDcyLjIwNTU3LDE3Niw5NiwxNzYKCWM0NC4xMTIzLDAsODAtMzUuODg3Nyw4MC04MFMxNDAuMTEyMywxNiw5NiwxNnoiLz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPGc+CjwvZz4KPC9zdmc+Cg==",
            imgOk: "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxOTIgMTkyIj4NCjxwYXRoIGQ9Ik03NiAxNDEuNjU3TDMzLjE3MSA5OC44MjlsNS42NTgtNS42NThMNzYgMTMwLjM0M2w3Ny4xNzEtNzcuMTcyIDUuNjU4IDUuNjU4TDc2IDE0MS42NTd6Ii8+DQo8L3N2Zz4=",
            imgCancel: "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxOTIgMTkyIj4NCjxwYXRoIGQ9Ik0xMDEuNjU3IDk2bDU3LjE3MiA1Ny4xNzEtNS42NTggNS42NThMOTYgMTAxLjY1NyAzOC44MjkgMTU4LjgzbC01LjY1OC01LjY1OEw5MC4zNDMgOTYgMzMuMTcgMzguODI5bDUuNjU4LTUuNjU4TDk2IDkwLjM0M2w1Ny4xNzEtNTcuMTcyIDUuNjU4IDUuNjU4TDEwMS42NTcgOTZ6Ii8+DQo8L3N2Zz4=",
            imgInfo: "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxOTIgMTkyIj4NCjxjaXJjbGUgY3g9Ijk2IiBjeT0iOTYiIHI9IjgwIiBmaWxsPSIjZjJmMmYyIiBvcGFjaXR5PSI3MCUiLz4NCjxwYXRoIGQ9Ik05NiAxNzZjLTQ0LjExMiAwLTgwLTM1Ljg4OC04MC04MHMzNS44ODgtODAgODAtODAgODAgMzUuODg4IDgwIDgwLTM1Ljg4OCA4MC04MCA4MHptMC0xNTJjLTM5LjcwMSAwLTcyIDMyLjI5OS03MiA3MnMzMi4yOTkgNzIgNzIgNzIgNzItMzIuMjk5IDcyLTcyLTMyLjI5OS03Mi03Mi03MnptLTcuMSAzOS4xYzAtMy45IDMuMi03LjEgNy4xLTcuMSA0IDAgNy4xIDMuMSA3LjEgNy4xcy0zLjEgNy4xLTcuMSA3LjFjLTMuOSAwLTcuMS0zLjItNy4xLTcuMXptMS44NSAxNy4zaDEwLjVWMTM2aC0xMC41VjgwLjR6Ii8+DQo8L3N2Zz4=",
            imgWarning: "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxOTIgMTkyIj4NCjxwYXRoIGZpbGw9IiNmMmYyZjIiIG9wYWNpdHk9IjcwJSIgZD0iTTE3NS43ODMgMTYwSDE2LjIxN0w5NiAxNS43MzUgMTc1Ljc4MyAxNjB6IiAvPg0KPHBhdGggZD0iTTE3NS43ODMgMTYwSDE2LjIxN0w5NiAxNS43MzUgMTc1Ljc4MyAxNjB6IG0tMTQ2LThoMTMyLjQzNEw5NiAzMi4yNjUgMjkuNzgzIDE1MnptNzMuMzI4LTE1LjExMWMwIDMuODktMy4yMjIgNy4xMTEtNy4xMTEgNy4xMTEtNCAwLTcuMTExLTMuMTEtNy4xMTEtNy4xMTEgMC00IDMuMTEtNy4xMTEgNy4xMTEtNy4xMTEgMy44ODkgMCA3LjExMSAzLjIyMiA3LjExMSA3LjExem0tMTIuMjIzLTQ4VjY0aDEwLjIyM3YyNC44ODlsLTIuNjY3IDMwLjY2N2gtNC44ODhsLTIuNjY4LTMwLjY2N3oiLz4NCjwvc3ZnPg==",
            imgError: "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxOTIgMTkyIj4NCjxwYXRoIGZpbGw9IiNmMmYyZjIiIG9wYWNpdHk9IjcwJSIgZD0iTTEyOS42NTcgMTc2SDYyLjM0M0wxNiAxMjkuNjU3VjYyLjM0M0w2Mi4zNDMgMTZoNjcuMzE0TDE3NiA2Mi4zNDN2NjcuMzE0TDEyOS42NTcgMTc2eiIvPg0KPHBhdGggZD0iTTUyLjU5OSA4OC43OTdjLTEuNTE5LTIuNDMzLTMuMjI4LTMuMzU3LTYuMTctMy4zNTctMi43NTMgMC00LjIyNC45MjQtNC4yMjQgMi42NzYgMCAxLjcwNCAxLjE4NiAyLjQ4MiA0Ljg0MSAzLjIxMiA1LjIyIDEuMDIyIDcuNDk5IDEuNzAzIDkuNDkyIDIuOTY5IDIuODQ4IDEuOCA0LjEzIDQuMzggNC4xMyA4LjI3MyAwIDcuMzQ5LTQuODQyIDExLjM4OC0xMy42NyAxMS4zODgtNy4zMDkgMC0xMi4xOTgtMi40ODItMTQuOTk4LTcuNjRsNy44MzEtMy44OTRjMS4yODIgMi44MjMgMy40NjUgNC4xMzcgNi44ODIgNC4xMzcgMy4xMzMgMCA0Ljk4NC0xLjEyIDQuOTg0LTMuMDE4IDAtMS43MDMtMS4yODEtMi41NzktNC43OTQtMy4yNi00LjkzNi0uOTc0LTYuODM0LTEuNTU4LTguODI4LTIuNjc3LTMuMDg1LTEuNzUyLTQuNTU2LTQuNDc3LTQuNTU2LTguNTE3IDAtNi44NjIgNC44NDEtMTEuMDQ3IDEyLjgxNS0xMS4wNDcgNi4yNjUgMCAxMC43NzQgMi4yODggMTMuNTc0IDYuOTExbC03LjMxIDMuODQ0em0xOS44MzctMi41M2gtOS4xMTN2LTcuNjloMjcuNTc2djcuNjloLTkuMTEzdjI3LjEwN2gtOS4zNVY4Ni4yNjd6TTEyNi41ODkgOTZjMCAxMC43MDctNi43ODcgMTcuOTU4LTE2LjgwMSAxNy45NTgtMTAuMDE1IDAtMTYuODUtNy4yNTEtMTYuODUtMTcuOTEgMC01LjU5NiAxLjg5OS0xMC40NjIgNS4zNjQtMTMuNzIzIDMuMTMyLTIuOTIgNi44MzQtNC4yODMgMTEuNjc1LTQuMjgzIDkuODI1IDAgMTYuNjEyIDcuMzQ5IDE2LjYxMiAxNy45NTh6bS0yMy45NjguMDQ5YzAgNi42MTggMi41MTUgMTAuMjIgNy4xMiAxMC4yMiA0LjY5OCAwIDcuMTY2LTMuNTUzIDcuMTY2LTEwLjI2OSAwLTYuNjE4LTIuNTE2LTEwLjI2OS03LjAyNS0xMC4yNjktNC43OTQgMC03LjI2MSAzLjUwNC03LjI2MSAxMC4zMTh6bTI5LjM3Ni0xNy40NzJoMTUuMjM2YzguMDIgMCAxMi43NjcgNC4zMzIgMTIuNzY3IDExLjczIDAgNy4wMDctNC42MDQgMTEuMjQtMTIuMjkzIDExLjI0aC02LjM2djExLjgyN2gtOS4zNVY3OC41Nzd6bTE0LjQyOCAxNi4wMTFjMi45OSAwIDQuNjA0LTEuNTU3IDQuNjA0LTQuNDI4cy0xLjU2Ni00LjM4LTQuNTU2LTQuMzhoLTUuMTI2djguODA4aDUuMDc4ek0xMjkuNjU3IDE3Nkg2Mi4zNDNMMTYgMTI5LjY1N1Y2Mi4zNDNMNjIuMzQzIDE2aDY3LjMxNEwxNzYgNjIuMzQzdjY3LjMxNEwxMjkuNjU3IDE3NnptLTY0LThoNjAuNjg2TDE2OCAxMjYuMzQzVjY1LjY1N0wxMjYuMzQzIDI0SDY1LjY1N0wyNCA2NS42NTd2NjAuNjg2TDY1LjY1NyAxNjh6Ii8+DQo8L3N2Zz4=",
            imgConfirm: "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxOTIgMTkyIj4NCjxjaXJjbGUgY3g9Ijk2IiBjeT0iOTYiIHI9IjgwIiBmaWxsPSIjZjJmMmYyIiBvcGFjaXR5PSI3MCUiLz4NCjxwYXRoIGQ9Ik05MC4zNDkgMTA1LjkzMmMwLTguMTIxIDIuMzA0LTEyLjA3MiAxMC41MzUtMTcuODg4IDYuMzY0LTQuMzkgOC40NS03LjY4MiA4LjQ1LTEzLjA1OSAwLTYuODA0LTUuMDQ5LTExLjQxMy0xMi42Mi0xMS40MTMtOC4zNDEgMC0xMy4zODkgNC4zOS0xNS4wMzUgMTMuMjc5bC04LjQ1LTEuMDk4YzEuMDk3LTYuNDc0IDIuOTYzLTEwLjMxNSA3LjAyNC0xMy45MzdDODQuNTMzIDU3Ljk3NiA5MC4zNDkgNTYgOTcuMDQzIDU2YzEyLjk0OCAwIDIxLjcyOCA3LjU3MiAyMS43MjggMTguNzY2IDAgNS4xNTctMS42NDYgOS40MzctNC44MjkgMTIuOTQ5LTEuOTc1IDIuMDg1LTMuNTExIDMuMjkyLTguNDUgNi41ODQtNS44MTYgMy44NC03LjEzMyA2LjI1NS03LjEzMyAxMi44NHY0LjcxOGgtOC4wMXYtNS45MjV6bTEwLjg2NCAyMy4wNDVjMCAzLjg0LTMuMTgzIDcuMDIzLTcuMDI0IDcuMDIzLTMuOTUgMC03LjAyMy0zLjA3My03LjAyMy03LjAyMyAwLTMuOTUgMy4wNzMtNy4wMjQgNy4wMjMtNy4wMjQgMy44NDEgMCA3LjAyNCAzLjE4MyA3LjAyNCA3LjAyNHpNOTYgMTc2Yy00NC4xMTIgMC04MC0zNS44ODgtODAtODBzMzUuODg4LTgwIDgwLTgwIDgwIDM1Ljg4OCA4MCA4MC0zNS44ODggODAtODAgODB6bTAtMTUyYy0zOS43MDEgMC03MiAzMi4yOTktNzIgNzJzMzIuMjk5IDcyIDcyIDcyIDcyLTMyLjI5OSA3Mi03Mi0zMi4yOTktNzItNzItNzJ6Ii8+DQo8L3N2Zz4=",
            imgBug: "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxOTIgMTkyIj4NCjxjaXJjbGUgY3g9Ijk2IiBjeT0iOTYiIHI9Ijg2IiBmaWxsPSIjZjJmMmYyIiBvcGFjaXR5PSI3MCUiLz4NCjxwYXRoIGQ9Ik0xMzYgMTA4aDI0di04aC0yNFY4Mi41bDIxLjgtMTAuOS0zLjYtNy4yLTE4LjIgOS4xdi00bC0yLjItMS4xYy0uMy0uMS0zLjEtMS41LTcuOC0zLjItLjItOC4zLTMuOC0xNS43LTkuMy0yMWw2LjctMTAtNi43LTQuNC02LjUgOS44Yy00LjItMi4zLTktMy42LTE0LjItMy42cy05LjkgMS4zLTE0LjIgMy42bC02LjUtOS44LTYuNyA0LjQgNi43IDEwYy01LjYgNS4zLTkuMSAxMi43LTkuMyAyMS00LjcgMS42LTcuNSAzLTcuOCAzLjJMNTYgNjkuNXYzLjlsLTE3LjEtOC45LTMuNyA3LjFMNTYgODIuNFYxMDBIMzJ2OGgyNHYxMy44bC0yMi4zIDE0LjggNC40IDYuNyAxOS4yLTEyLjhjNC42IDE3IDIwLjIgMjkuNSAzOC42IDI5LjUgMTguNCAwIDMzLjktMTIuNSAzOC42LTI5LjRsMTguMiAxMi42IDQuNi02LjYtMjEuMy0xNC43VjEwOHpNOTYgNDRjMTEgMCAyMC4yIDguMiAyMS44IDE4LjgtNi4yLTEuNS0xMy42LTIuOC0yMS44LTIuOHMtMTUuNiAxLjMtMjEuOCAyLjhDNzUuOCA1Mi4yIDg1IDQ0IDk2IDQ0em0tMzIgNzZWNzQuNmM0LjUtMS45IDE1LjItNS44IDI4LTYuNXY4My42Yy0xNS44LTEuOS0yOC0xNS40LTI4LTMxLjd6bTY0IDBjMCAxNi4zLTEyLjIgMjkuOC0yOCAzMS43VjY4LjFjMTIuOC43IDIzLjYgNC42IDI4IDYuNVYxMjB6Ii8+DQo8L3N2Zz4=",
            imgConnect: "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxOTIgMTkyIj4NCjxjaXJjbGUgY3g9Ijk2IiBjeT0iOTYiIHI9Ijk0IiBmaWxsPSIjZjJmMmYyIiBvcGFjaXR5PSI3MCUiLz4NCjxwYXRoIGQ9Ik0xNjIuODI5IDM0LjgyOWwtNS42NTgtNS42NTgtMTUuMjcgMTUuMjcxQzEzNS4xNjQgMzguOTc1IDEyNi44MjYgMzYgMTE4LjAzIDM2Yy0xMC4xNDMgMC0xOS42NzggMy45NS0yNi44NTUgMTEuMTI3bC03LjE4MSA3LjIxLTUuMTY2LTUuMTY2LTUuNjU4IDUuNjU4TDg4LjM0MyA3MCA3NS4xNyA4My4xNzFsNS42NTggNS42NThMOTQgNzUuNjU3IDExNi4zNDMgOThsLTEzLjE3MiAxMy4xNzEgNS42NTggNS42NThMMTIyIDEwMy42NTdsMTUuMTcxIDE1LjE3MiA1LjY1OC01LjY1OC01LjE2Ni01LjE2NiA3LjIxNi03LjE4N0MxNTIuMDUgOTMuNjQ3IDE1NiA4NC4xMTIgMTU2IDczLjk3YzAtOC43OTYtMi45NzUtMTcuMTM0LTguNDQyLTIzLjg3bDE1LjI3LTE1LjI3MXptLTIzLjYwMSA2MC4zMjdsLTcuMjIyIDcuMTkzTDg5LjY1IDU5Ljk5NGw3LjE4OC03LjIxNmM1LjY2LTUuNjYgMTMuMTg2LTguNzc4IDIxLjE5MS04Ljc3OHMxNS41MzIgMy4xMTggMjEuMTkyIDguNzc4UzE0OCA2NS45NjQgMTQ4IDczLjk3cy0zLjExOCAxNS41MzEtOC43NzIgMjEuMTg2ek00OS4xNyA3OC44MjlsNS4xNjYgNS4xNjYtNy4yMTYgNy4xODdDMzkuOTUgOTguMzUzIDM2IDEwNy44ODggMzYgMTE4LjAzYzAgOC43OTYgMi45NzUgMTcuMTM0IDguNDQyIDIzLjg3bC0xNS4yNyAxNS4yNzEgNS42NTcgNS42NTggMTUuMjctMTUuMjcxQzU2LjgzNiAxNTMuMDI1IDY1LjE3NCAxNTYgNzMuOTcgMTU2YzEwLjE0MyAwIDE5LjY3OC0zLjk1IDI2Ljg1NS0xMS4xMjdsNy4xODEtNy4yMSA1LjE2NiA1LjE2NiA1LjY1OC01LjY1OC02NC02NC01LjY1OCA1LjY1OHptNDUuOTkgNjAuMzkzQzg5LjUwMSAxNDQuODgyIDgxLjk3NSAxNDggNzMuOTcgMTQ4cy0xNS41MzItMy4xMTgtMjEuMTkyLTguNzc4UzQ0IDEyNi4wMzYgNDQgMTE4LjAzczMuMTE4LTE1LjUzMSA4Ljc3Mi0yMS4xODZsNy4yMjItNy4xOTMgNDIuMzU1IDQyLjM1NS03LjE4OCA3LjIxNnoiLz4NCjwvc3ZnPg==",
            imgSpinner: "data:image/svg+xml;base64,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",
            imgSelect: ""
        }
        this.cfgMsgBox.imgSelect = this.cfgMsgBox.imgConfirm
        this.divFrameMsgOnTop = null
        this.sectionLen = 0 // 0=no 1000 seperator, 3=1000 seperator for numbers in cx-input
        this.waitOverlay = null
        this.iHeartBeatPlcBak = null
        this.bIsConnectErrorOpen = false
        this.IntervalHeartbeatTime = null
    }
    init() {
    }

    /**
     * @description
     * WebIQ_Wrappers<br>
     * <a href="#getCtrl">getCtrl()</a> 
     * <a href="#getItem">getItem()</a> 
     * <a href="#isWebIqPreview">isWebIqPreview()</a> 
     * <a href="#localize">localize()</a> 
     * <a href="#setItem">setItem()</a> 
     * 
     * <br><br>Dialog_boxes<br>
     * <a href="#cleanMonitor">cleanMonitor()</a>
     * <a href="#closeConnectError">closeConnectError()</a>
     * <a href="#getOverlay">getOverlay()</a>
     * <a href="#msgBox">msgBox()</a>
     * <a href="#msgTop">msgTop()</a>
     * <a href="#overlayWait">overlayWait()</a> 
     * <br>
     * <br>Keypad<br>
     * <a href="#keypad">keypad()</a>
     * <a href="#keypadAddLanguage">keypadAddLanguage()</a>
     * <a href="#keypadEnable">keypadEnable()</a>
     * <br>
     * <br>Common_tools<br>
     * <a href="#abortJS">abortJS()</a>
     * <a href="#addChild">addChild()</a>
     * <a href="#bitClear">bitClear()</a>
     * <a href="#bitSet">bitSet()</a>
     * <a href="#bitTest">bitTest()</a>
     * <a href="#bitToggle">bitToggle()</a>
     * <a href="#isTouchEnabled">isTouchEnabled()</a>
     
     * <a href="#checkArg">checkArg()</a>
     * <a href="#checkHeartbeat">checkHeartbeat()</a>
     * <a href="#cssGetVar">cssGetVar()</a>
     * <a href="#cssSetVar">cssSetVar()</a>
     * <a href="#csvSplit">csvSplit()</a>
     * <a href="#csvAppend">csvAppend()</a>
     * <a href="#downloadTextFile">downloadTextFile()</a>
     * 
     * <a href="#getClientId">getClientId()</a> 
     * <a href="#isFloat">isFloat()</a>
     * <a href="#isInt">isInt()</a>
     * <a href="#isNullOrUndef">isNullOrUndef()</a>
     * <a href="#isTooltipEnabled">isTooltipEnabled()</a>
     * <a href="#onReadyCheck">onReadyCheck()</a>
     * <a href="#onReadyOk">onReadyOk()</a>
     * <a href="#reloadWebIq">reloadWebIq()</a>
     * <a href="#wait">wait()</a>
     *  
     * <br><br>Filter/Sort<br>
     * <a href="#filterMatch">filterMatch()</a>
     * <a href="#sortByKey">sortByKey()</a> 
     * <br>
     * <br>Format<br>
     * <a href="#float2String">float2String()</a>
     * <a href="#int2String">int2String()</a>
     * <a href="#parseBool">parseBool()</a>
     * <a href="#parseToLower">parseToLower()</a> 
     * <a href="#formatString">formatString()</a>
     */
    _Funcs_Sorted_By_Themes_() { }
    /****** wrappers for WebIQ functions ******/
    /**
     * Read WebIQ item. When item is subscribed with readValue() else with readDirect()
     * @memberof_ cxTools.wrapperWebIQ
     * @param {string}  sItem  item name
     * @param {any}     oValue item value
     * @param {boolean} bAbort true=call abortJS() false=don't call abortJS()
     * @return {string|number|boolean}
     * @TODO: Use promise to enable await, check virtual items always working.
     * @example
     * let val1 = cxt.getItem("SFloat")
     * let val2 = await cxt.getItem("SInt", true) // force to use readDirect()
     */
    getItem(sItem, bForceDirect = false, bAbort = true) {
        const im = shmi.requires("visuals.session.ItemManager")
        // virtual items can't be read with readDirect
        if (sItem.startsWith("virtual:")) bForceDirect = false
        if (im.items[sItem] && (bForceDirect === false)) { // item subscribed => read value
            // log(`readValue(${sItem})`)
            return im.readValue(sItem)
        } else { // item not subscribed => read direct
            return new Promise((resolve, reject) => {
                im.readDirect([sItem], function (iResult, oData) {
                    if (oData[sItem] === null) {
                        if ((bAbort) && (!shmi.isDesignerEditor()))
                            cxt.abortJS(`Invalid item name "${sItem}"`)
                        reject(null)
                    } else {
                        // log(`readDirect(${sItem})`)
                        resolve(oData[sItem]);
                    }
                });
            })
        }

    }
    /**
     * Set webIQ item value. When item is subscribed with writeValue() else with writeDirect()
     * Aborts script when writing fails and displays a notification with stack where error occured
     * HINT: value could not be read with getItem() in the same fuction, because update is done later
     * @memberof_ cxTools.wrapperWebIQ
     * @param {string}  sItem item name
     * @param {string|number|boolean}  oValue value to set (int,float,string,bool)
     * @param {boolean} bForceDirect true=force usage of writeDirect(), even if sItem is subscribed
     * @return {Promise|string|number|boolean} 
     * @example
     * setItem("SInt", 10)
     * await setItem("SInt", 10, true) // force to use writeDirect()
     */
    setItem(sItem, oValue, bForceDirect = false) {
        const im = shmi.requires("visuals.session.ItemManager")
        const WriteOpt = { skipSameValueCheck: true }
        // virtual items can't be written with writeDirect
        if (sItem.startsWith("virtual:")) bForceDirect = false
        if (im.items[sItem] && (bForceDirect === false)) { // item subscribed => write value
            im.writeValue(sItem, oValue, WriteOpt)
            // log(`writeValue(${sItem}='${oValue}')`)
            return true
        } else {
            // item not subscribed => use writeDirect with callback
            let jItem = {}
            jItem[sItem] = oValue
            return new Promise((resolve, reject) => {
                im.writeDirect(jItem, function (s, i) {
                    if (s.errc) {
                        if (!shmi.isDesignerEditor())
                            cxt.abortJS(`Invalid item name "${sItem}"`)
                        reject(false)
                    } else {
                        // log(`writeDirect(${sItem}, ${oValue})`)
                        resolve(true)
                    }
                });
            })
        }
    }
    /**
     * Checks if project is running in WebIQ preview mode
     * @memberof_ cxTools.wrapperWebIQ
     * @returns {boolean} true: webIQ preview false: run in browser
     * @example
     * if (cxt.isWebIqPreview()) {
     *   log("WebIQ is running in preview environment")
     * } else {
     *   log("WebIQ is running in browser")
     * }
     */
    isWebIqPreview() {
        /**
         * Checks if WebIQ project runs in preview mode or via webserver
         * -  preview is started via protocol file:
         * -  normal  is started via protocol http: https:
         * @returns true=preview false=normal view
         */
        return window.location.host === ""
    }
    /**
    * Returns WebIQ control, with the requested attribute "data-name" and type.<br>
    * If no or multiple controls are found a bug msgBox is displayed
    * @memberof_ cxTools.wrapperWebIQ
    * @param  {string}   sName      name of WebIQ control without path (e.g. "iq-button-test")
    * @param  {string[]} [arTypes]  optional array of allowed types e.g. ["","",""]
    * @return {domObject|null}      WebIQ control or null at error
    * 
    * @example
    * let myCtrl = cxt.getCtrl("iq-button-test", ["iq-button"]); // name and type must match
    * myCtrl = cxt.getCtrl("iq-button-test");  // only name must match
    */
    getCtrl(sName, arTypes) {
        let domElements = shmi.getElementsByAttribute("data-name", sName);
        let sMsg = "";
        // OK: 1 element found
        if (domElements.length === 1) {
            let ctrl = shmi.getControlByElement(domElements[0]);
            // check 

            if ((!arTypes) || arTypes.includes(ctrl.uiType)) {
                sMsg = `One control with name "${ctrl.name}" found`;
                return ctrl;
            } else {
                sMsg = `Type ${ctrl.uiType} must be one of:.\n${arTypes.join()}`;
            }
            return ctrl;
            // ERROR: no element found
        } else if (domElements.length === 0) {
            sMsg = `No control with name "${sName}" found`;
            // ERROR: multiple elements found
        } else {
            sMsg = `${domElements.length} controls with name "${sName}" found\n\n`
            let iMax = (domElements.length > 10) ? 8 : domElements.length;
            for (let i = 0; i < iMax; i++) {
                let ctrl = shmi.getControlByElement(domElements[i]);
                sMsg += `- ${ctrl.name}\n`
            }
        }
        cxt.msgBox("bug", sMsg);
        return;
    }
    /**
     * Returns the translation for the localization variable whose name is created dynamically.
     * Usefull to translate status/error numbers into text
     * @memberof_ cxTools.wrapperWebIQ
     * @param {string}  sPrefix start of localization name
     * @param {integer} iValue  postfix of localization item
     * @returns {string} translation text defined by inputs
     * @example
     * console.log(cxt.localize("state", 1))  // returns value of localization var: state001
     * console.log(cxt.localize("state", 10)) // returns value of localization var: state010
     */
    localize(sPrefix, iValue) {
        return shmi.localize("${" + sPrefix + ("" + iValue).padStart(3, "0") + "}")
    }
    lockImg(self, value, parent = null) {
        const vr = self.vars
        let me = self.element
        if (parent) me = parent
        if (value === 1) {
            vr.imgLock = cxt.addChild(null, "img")
            vr.imgLock.src = cxt.cfgMsgBox.imgLock
            vr.imgLock.style.position = "absolute"
            vr.imgLock.style.top = 2
            vr.imgLock.style.left = 2
            vr.imgLock.style.zIndex = 10
            vr.imgLock.style.width = "16px"
            me.insertBefore(vr.imgLock, me.firstChild);
        } else {
            if (!cxt.isNullOrUndef(vr.imgLock)) {
                vr.imgLock.remove()
                vr.imgLock = null
            }
        }
    }
    tooltip(self, value) {
        const me = self.element
        const vr = self.vars
        const cf = self.config
        if (value === 1) {
            vr.overlay = cxt.addChild(null, "div")
            // vr.overlay.style.width = me.offsetWidth + "px"
            vr.overlay.style.width = "100%"
            // vr.overlay.style.height = me.offsetHeight + "px"
            vr.overlay.style.height = "100%"

            if ((cf.title === "") || cxt.isNullOrUndef(cf.title)) {
                vr.overlay.style.backgroundColor = "red"
            } else {
                vr.overlay.style.backgroundColor = "green"
                vr.overlay.onclick = () => {
                    cxt.msgTop("tooltip", cf.title)
                }
            }
            vr.overlay.style.opacity = "20%"
            vr.overlay.style.position = "absolute"
            vr.overlay.style.top = 0
            vr.overlay.style.left = 0
            vr.overlay.style.zIndex = 10
            me.insertBefore(vr.overlay, me.firstChild);
        } else {
            if (!cxt.isNullOrUndef(vr.overlay)) {
                vr.overlay.remove()
                vr.overlay = null
            }
        }
    }
    /***** dialog boxes *****/
    /**
     * Generates background for dialog boxes. Controls behind overlay cann't be used until overlay is closed again.<br>
     * Used by msgBox,...
     * @memberof_ cxTools.dialogs
     * @param   {domElement} parent optional parent object
     * @returns {domElement} overlay element
     * @example
     * let overlay = cxt.getOverlay() // get overlay div
     * let box = overlay.firstChild   // get content div
     * box.innerHTML = "My info"      // show any info, image, ....
     * await cxt.wait(1000)           // wait until simulated action is done
     * overlay.remove()               // close overlay
     */
    getOverlay(parent = null) {
        let overlay = null;
        // div for overlay the complete screen
        overlay = cxt.addChild(null, "div", "overlay")
        overlay.addEventListener('contextmenu', (e) => e.preventDefault(), false)
        // box with header and content
        let box = document.createElement("div")

        box.style.backgroundColor = `var(--col-bg-content-box,${this.cfgMsgBox.bgcolContent})`

        box.style.padding = "0px"
        box.style.position = "relative"
        // box.style.left = "50px"
        overlay.appendChild(box)

        parent = (parent === null) ? document.body : parent
        parent.appendChild(overlay)
        return overlay
    }
    /**
     * show/hides an overlay with spinner, which locks the screen for inputs
     * @param {bool} bOn true:show false:hide overlay
     */
    overlayWait(bOn = true) {
        if (bOn) {
            if (this.waitOverlay === null) {
                this.waitOverlay = cxt.getOverlay()
                this.waitOverlay.style.backgroundColor = "transparent"
                this.waitOverlay.firstChild.style.backgroundColor = "transparent"
                let myImg = document.createElement("img");
                myImg.setAttribute("src", cxt.cssGetVar("--icon-info", cxt.cfgMsgBox.imgSpinner, true))
                this.waitOverlay.firstChild.appendChild(myImg)
            }
        } else {
            if (this.waitOverlay !== null) {
                this.waitOverlay.remove()
                this.waitOverlay = null
            }
        }
    }
    /**
     * Displays a non blocking message on top side of panel
     * @memberof_ cxTools.dialogs
     * @param {string} sType    "Info","Warning","Error","Tooltip" (only 1st char requested)
     * @param {string} sMsg     message to display
     * @param {number} iTimeOut >0: msec for auto close =0: not auto close <0: not closable
     * @return {DOM}   created message top DOM element or null, when nothing created
     * @example
     * msgTop("info", "My info message, 2000") // show info, which is automatically closed after 2000ms
     * msgTop("warn", "My warning")            // show warning, which must be manually closed
     * msgTop("warn", "My error")              // show warning, which must be manually closed
     */
    msgTop(sType, sMsg, iTimeOut = 0) {
        sType = sType.substring(0, 1).toUpperCase()

        if (this.divFrameMsgOnTop === null)
            this.divFrameMsgOnTop = this.addChild(document.body, "div", "divMsgFrame")
        if (sType === "T") {
            if (this.titleWin !== null) this.titleWin.remove()
            if (sMsg === null) return null
        }
        let oMsg = cxt.addChild(this.divFrameMsgOnTop, "div", "divMsg")
        let oIcon = cxt.addChild(oMsg, "div", "divIcon")
        let myImg = document.createElement("img");
        oIcon.appendChild(myImg)

        cxt.addChild(oMsg, "div", "divText", shmi.localize(sMsg).replaceAll("\n", "<br>"))
        if (sType === "I") {
            myImg.setAttribute("src", cxt.cssGetVar("--icon-info", cxt.cfgMsgBox.imgInfo, true))
            iTimeOut = iTimeOut > 0 ? iTimeOut : 4000
            oMsg.classList.add("divMsgOk")
        } else if (sType === "W") {
            oMsg.classList.add("divMsgWarn")
            myImg.setAttribute("src", cxt.cssGetVar("--icon-info", cxt.cfgMsgBox.imgWarning, true))
        } else if (sType === "E") {
            oMsg.classList.add("divMsgErr")
            myImg.setAttribute("src", cxt.cssGetVar("--icon-info", cxt.cfgMsgBox.imgError, true))
        } else if (sType === "B") {
            oMsg.classList.add("divMsgErr")
            myImg.setAttribute("src", cxt.cssGetVar("--icon-info", cxt.cfgMsgBox.imgBug, true))
        } else if (sType === "T") {
            myImg.setAttribute("src", cxt.cssGetVar("--icon-info", cxt.cfgMsgBox.imgInfo, true))
            iTimeOut = iTimeOut > 0 ? iTimeOut : 4000
            oMsg.classList.add("divMsgTitle")
            // if (this.titleWin !== null) this.titleWin.remove()
            this.titleWin = oMsg
        }
        if ((sType !== "B") && (iTimeOut >= 0)) {
            oMsg.onmouseup = () => { // close message on click
                oMsg.remove();
                oMsg = null
            }
            cxt.addChild(oMsg, "button", "divIcon", CHAR_CANCEL)
        }
        // set timeout for auto close
        if (iTimeOut > 0)
            setTimeout(() => {
                if (oMsg !== null) {
                    oMsg.remove()
                    oMsg = null
                }

            }, iTimeOut)
        return oMsg
    }
    /**
     * Displays a dialog box with icon
     * @memberof_ cxTools.dialogs
     * @param  {string} sType           type of msgBox (info,warning,error,bug,confirm,select,connecterror)
     * @param  {string} sMsg            message to display
     * @param  {string} sOK             title of OK button for type "confirm"
     * @param  {string} [sOptions]      type="select" CSV string with options e.g. "option1=123|option2=234"
     * @param  {string} [sFsOpt="\n"]   type="select" field separator options e.g "|".
     * @param  {string} [sFsVal="\t"]   type="select" field separator label:value e.g. "="
     * @param  {string|number} oVal     type="select" current value
     * @return {string|void} string for type=="select"      
     * @example
     * cxt.msgBox("info",    "Action successful done")
     * cxt.msgBox("warning", "Temperatur is very high")
     * cxt.msgBox("error",   "Failed to delete file")
     * cxt.msgBox("bug",     "Ctrl with name 'iq-box-iframe' not found")
     * let sResult = await cxt.msgBox("select",  "Select a color", "", "red=1|blue=2|red=3|blue=4|red=5|blue=6", "|", "=",)
     * if (sResult !== null) {
     *   console.log("sResult = " + sResult)
     * } else {
     *   console.log("cancelled")
     * }
     * sResult = await cxt.msgBox("confirm", "Delete file?", "${delete}")
     * if (sResult !== null) {
     *    // delete file
     * }
     */
    msgBox(sType, sMsg, sOK = "", sOptions, sFsOpt = "\n", sFsVal = "\t", oVal) {
        // TODO: use CSS for msgBox
        let sValue = ""
        let sHeader = ""
        let sImg = ""
        let sOkMsg = ""
        let bgcolHeader = ""
        let colHeader = ""
        let bCancel = false
        let bShowList = false
        let zIndex = ZINDEX_MSGBOX
        let iFilteredItems = 0

        sMsg += ""
        sMsg = shmi.localize(sMsg)
        sMsg = sMsg.replaceAll("\n", "<br>").trim()
        sType = sType.toLowerCase();

        let overlay = cxt.getOverlay() //
        let box = overlay.firstChild    // get content div 

        if (sType === "info") {
            colHeader = `var(--col-bg-info-label, ${this.cfgMsgBox.colInfo})`
            bgcolHeader = `var(--col-bg-info, ${this.cfgMsgBox.bgcolInfo})`
            sImg = cxt.cssGetVar("--icon-info", this.cfgMsgBox.imgInfo, true)
            sHeader = "Info"
        } else if (sType === "warning") {
            colHeader = `var(--col-bg-warn-label,${this.cfgMsgBox.colWarn})`
            bgcolHeader = `var(--col-bg-warn,${this.cfgMsgBox.bgcolWarn})`
            sImg = cxt.cssGetVar("--icon-warning", this.cfgMsgBox.imgWarning, true)
            sHeader = "Warning"
        } else if (sType === "error") {
            colHeader = `var(--col-bg-error-label,${this.cfgMsgBox.colErr})`
            bgcolHeader = `var(--col-bg-error,${this.cfgMsgBox.bgcolErr})`
            sImg = cxt.cssGetVar("--icon-error", this.cfgMsgBox.imgError, true)
            sHeader = "Error"
        } else if (sType === "bug") {
            colHeader = `var(--col-bg-error-label,${this.cfgMsgBox.colErr})`
            bgcolHeader = `var(--col-bg-error,${this.cfgMsgBox.bgcolErr})`
            sImg = cxt.cssGetVar("--icon-bug", this.cfgMsgBox.imgBug, true)
            sHeader = "Bug"
        } else if (sType === "confirm") {
            colHeader = `var(--col-bg-confirm-label,${this.cfgMsgBox.colConfirm})`
            bgcolHeader = `var(--col-bg-confirm,${this.cfgMsgBox.bgcolConfirm})`
            sImg = cxt.cssGetVar("--icon-confirm", this.cfgMsgBox.imgConfirm, true)
            sHeader = "Confirm"
            bCancel = true
            if (sOK !== "") sOkMsg = `<small>${shmi.localize(sOK)}</small>`
        } else if (sType === "select") {
            colHeader = `var(--col-bg-select-label, ${this.cfgMsgBox.colSelect})`
            bgcolHeader = `var(--col-bg-select, ${this.cfgMsgBox.bgcolSelect})`
            // sImg = cxt.cssGetVar("--icon-select", this.cfgMsgBox.imgSelect, true)
            sHeader = "Select"
            box.style.width = "400px"
            box.style.minHeight = "200px"
            bCancel = true
            bShowList = true
            // if (sOK !== "") sOkMsg = `${shmi.localize(sOK)}`
            if (sOK !== "") sOkMsg = `<small>${shmi.localize(sOK)}</small>`
        } else if (sType === "connecterror") {
            colHeader = `var(--col-bg-error-label,${this.cfgMsgBox.colErr})`
            bgcolHeader = `var(--col-bg-error,${this.cfgMsgBox.bgcolErr})`
            sImg = cxt.cssGetVar("--icon-select", this.cfgMsgBox.imgConnect, true)
            sHeader = shmi.localize("${heartbeat_title}")
            zIndex = ZINDEX_CONNECT_ERR
            this.myMsgBoxOverlay = overlay
        } else {
            shmi.notify(`msgBox: Unknown type "${sType}"`)
        }
        overlay.style.zIndex = zIndex;
        sFsOpt = (sFsOpt === undefined) ? "\n" : sFsOpt;
        sFsVal = (sFsVal === undefined) ? "\t" : sFsVal;
        let arOpts = []
        let arW = []
        if (typeof (sOptions) === "string") {
            arW = sOptions.split(sFsOpt); // split options into words
            for (let i = 0; i < arW.length; i++) {
                if (arW[i] !== "") {
                    let arCol = arW[i].split(sFsVal);
                    let jTmp = {}
                    jTmp.label = arCol[0]
                    jTmp.val = arCol[1] ? arCol[1] : arCol[0]
                    arOpts.push(jTmp)
                }
            }
            // console.log(JSON.stringify(arOpts))
        } else if (typeof (sOptions) === "object") {
            arOpts = sOptions
        }
        let arSelect = []
        // header/title of window
        let header = document.createElement("div");
        header.style.backgroundColor = bgcolHeader
        header.style.color = colHeader
        header.style.fontWeight = "bold"
        header.style.minWidth = "180px"
        // header.style.width = "80%";
        header.style.height = "30px"
        header.style.margin = "0px"
        header.style.padding = "0px"
        header.style.paddingLeft = "8px"
        header.style.paddingTop = "4px"
        header.innerHTML = sHeader;
        box.appendChild(header);

        // content box, with message & buttons
        let content = document.createElement("div")
        content.style.padding = "10px"
        let tab = document.createElement("table")
        let tr = document.createElement("tr")

        tab.appendChild(tr)
        let td = document.createElement("td")
        tr.appendChild(td)
        // message
        let boxMsg = document.createElement("div");
        // boxMsg.innerHTML = sMsg;
        let myImg = null
        if (sImg !== "") {
            myImg = document.createElement("img");
            myImg.setAttribute("src", sImg)
            myImg.classList.add("invertCImg");
            myImg.style.width = "80px";
            myImg.style.margin = "0px";
            td.appendChild(myImg)
        }
        if (sType === "connecterror") {
            let tStart = new Date()
            myImg.onclick = () => { cxt.reloadWebIq() }

            cxt.IntervalHeartbeatTime = setInterval(() => {
                const dt = shmi.requires("visuals.tools.date"),
                    options = {
                        utc: true,
                        datestring: "$HH:$mm:$ss"
                    };
                header.innerHTML = sHeader + " - "
                    + dt.formatDateTime((new Date() - tStart) / 1000, options)
            }, 1000)
        }

        td = document.createElement("td")
        td.style.color = `var(--col-content-font,${this.cfgMsgBox.colContent})`
        td.innerHTML = sMsg
        tr.appendChild(td)
        boxMsg.appendChild(tab)

        let boxList
        let btnSelect = null
        if (bShowList) {
            boxList = document.createElement("div")
            boxList.style.marginTop = "10pt"
            boxList.style.minWidth = "240px"
            boxList.style.width = "100%"
            boxList.style.height = "456px"
            boxList.style.display = "flex"
            boxList.style.flexDirection = "column"
            boxList.style.overflowY = "auto"

            let boxFilter = document.createElement("div")
            boxList.appendChild(boxFilter)
            let txtFilter = document.createElement("input");
            txtFilter.placeholder = "filter"
            txtFilter.style.width = "89%"
            txtFilter.style.height = ROW_HEIGHT
            txtFilter.style.marginBottom = "10px"
            // txtFilter.style.flexGrow = "1"
            txtFilter.onkeyup = function (e) {
                let arFilter = txtFilter.value.toLowerCase().split(/[ ]+/)
                iFilteredItems = 0
                for (let i = 0; i < arSelect.length; i++) {
                    if (cxt.filterMatch(arSelect[i].value.toLowerCase(), arFilter)) {
                        arSelect[i].style.display = ""
                        iFilteredItems++
                    } else {
                        arSelect[i].style.display = "none"
                    }
                }
                console.log("Filtered item count=" + iFilteredItems)
            }
            txtFilter.onclick = async function (e) {
                if (this.bKeypadEnabled === false) return
                let res = await cxt.keypad(txtFilter, 'value')
                if (res !== null)
                    txtFilter.onkeyup(e)
            }
            boxFilter.appendChild(txtFilter)
            let btnClear = document.createElement("input")
            btnClear.type = "button"
            btnClear.value = "✗"
            btnClear.style.width = "30px"
            btnClear.style.height = "46px" // ROW_HEIGHT
            btnClear.style.margin = "0px"
            btnClear.style.backgroundColor = "transparent"
            btnClear.style.border = "none"
            btnClear.onclick = async function (e) {
                txtFilter.value = ""
                txtFilter.onkeyup(e)
            }
            boxFilter.appendChild(btnClear)

            let boxScroll = document.createElement("div")
            boxScroll.style.width = "100%"
            boxScroll.style.height = "100%"
            boxScroll.style.overflowY = "scroll"
            boxList.appendChild(boxScroll)

            // show all options
            let iSelectBak = -1
            for (let i = 0; i < arOpts.length; i++) {
                let btn = document.createElement("input")
                btn.type = "button"
                btn.value = shmi.localize(arOpts[i].label)
                btn.name = arOpts[i].val
                btn.style.height = txtFilter.style.height
                btn.style.margin = "0px"
                // btn.style.width = filter.style.width
                btn.style.width = "96%"
                btn.style.textAlign = "left"
                btn.style.backgroundColor = "white"
                btn.style.color = "black"
                btn.style.borderColor = "black"
                btn.style.borderWidth = "1px"
                // define callback
                btn.onclick = function () {
                    sValue = this.name;
                    if (iSelectBak >= 0)
                        arSelect[iSelectBak].style.backgroundColor = "white"
                    arSelect[i].style.backgroundColor = "lightblue"
                    iSelectBak = i
                    btnOK.disabled = false
                }
                btn.ondblclick = function () {
                    overlay.dispatchEvent(new Event('closeOverlay'));
                }
                arSelect.push(btn)
                boxScroll.appendChild(btn);
                if (arOpts[i].val == oVal) {
                    btnSelect = btn
                }
            }
        }


        // buttons of selection list
        let boxButtons = document.createElement("div");
        boxButtons.style.marginTop = "10pt";
        boxButtons.style.width = "100%"
        boxButtons.style.display = "flex"
        boxButtons.style.flexDirection = "row"
        boxButtons.style.justifyContent = "space-around"

        let btnOK = null
        if (!["connecterror"].includes(sType)) {
            btnOK = document.createElement("button")
            // btnOK.type = "button"
            btnOK.style.minWidth = "50%"
            // btnOK.style.maxWidth = "300px"
            btnOK.style.height = "40px"
            btnOK.style.fontSize = "34px"
            btnOK.style.color = `var(--col-btn-normal-label, ${this.cfgMsgBox.colContent})`
            btnOK.style.backgroundColor = `var(--col-bg-btn-normal,${this.cfgMsgBox.bgcolContent})`
            btnOK.innerHTML = CHAR_OK + sOkMsg

            btnOK.onclick = function () {
                sValue = (sType === "select") ? sValue : CHAR_OK
                overlay.dispatchEvent(new Event('closeOverlay'))
            }
            boxButtons.appendChild(btnOK)
            btnOK.focus()
        }

        let btnCancel = null
        if (bCancel) {
            btnCancel = document.createElement("button")
            // btnCancel.type = "button"
            // btnCancel.value = "cancel"
            btnCancel.style.width = "30%"
            btnCancel.style.maxWidth = "100px"
            btnCancel.style.height = "40px"
            btnCancel.style.fontSize = "34px"
            btnCancel.style.color = `var(--col-btn-normal-label, ${this.cfgMsgBox.colContent})`
            btnCancel.style.backgroundColor = `var(--col-bg-btn-normal,${this.cfgMsgBox.bgcolContent})`
            btnCancel.innerHTML = CHAR_CANCEL
            btnCancel.onclick = function () {
                sValue = null
                overlay.dispatchEvent(new Event('closeOverlay'))
            }
            boxButtons.appendChild(btnCancel)
            btnCancel.focus()
        }
        content.appendChild(boxMsg);
        if (bShowList) {
            content.appendChild(boxList)
            let info = document.createElement("div")
            info.innerHTML = arOpts.length + shmi.localize(" ${elements}")
            info.style.fontSize = "80%"
            content.appendChild(info);
        }

        content.appendChild(boxButtons)
        box.appendChild(content)
        if (btnCancel) btnCancel.focus()
        if (btnOK) {
            if (sType === "select")
                btnOK.disabled = true
            else
                btnOK.focus()
        }
        if (btnSelect !== null) btnSelect.onclick()
        return new Promise((resolve, reject) => {
            overlay.addEventListener('closeOverlay', function (e) {
                overlay.remove()
                resolve(sValue)
                overlay = null
            }, { once: false });
        });
        /**
         * close keypad when Enter(=ok) or Escape(=cancel) is pressed
         * @param {*} evt event data
         */
        function checkHwKeys(evt) {
            if (evt.key === "Enter") {
                if (btnOK)
                    btnOK.onclick()
            } else if (evt.key === "Escape") {
                if (btnCancel)
                    btnCancel.onclick()
            }
        }
    }
    /**
     * Close dialog connect error
     * @memberof_ cxTools.dialogs
     * @return {void}
     * @example
     * closeConnectError() // close connection error dialog
     */
    closeConnectError() {
        if (this.myMsgBoxOverlay) {
            if (cxt.IntervalHeartbeatTime != null) {
                clearInterval(cxt.IntervalHeartbeatTime)
                cxt.IntervalHeartbeatTime = null
            }
            this.myMsgBoxOverlay.remove()
            this.myMsgBoxOverlay = null
        }
    }
    /**
     * Locks screen, for iDelaySec seconds, which allows to clean the monitor
     * @memberof_ cxTools.dialogs
     * @param {number} iDelaySec duration of screen lock
     * @param {string} sImage    background image
     * @param {string} sInfo     info to display
     * @return {void}
     * @example
     * cleanMonitor(30) // locks panel for 30s, to allow cleaning of monitor
     */
    cleanMonitor(iDelaySec = 30, sImage = "pics/custom/ctrlX.png", sInfo = shmi.localize("${wait-clean-monitor}")) {
        iDelaySec = isNaN(iDelaySec) ? 300 : Math.abs(parseInt(iDelaySec))
        let overlay = cxt.getOverlay() //
        // overlay.firstChild.style.backgroundColor = "rgb(0,0,0,0.1)"
        overlay.style.backgroundImage = `url('${sImage}')`
        overlay.style.backgroundRepeat = "no-repeat";
        overlay.style.backgroundSize = "contain"

        let divText = cxt.addChild(overlay.firstChild, "div", "", iDelaySec + "s<br>&nbsp; " + sInfo + " &nbsp;<br>")
        divText.style.fontSize = "20px"
        // divText.style.lineHeight = "80px"
        divText.style.minWidth = "140px"
        divText.style.textAlign = "center"
        // divText.style.borderRadius = "30px"
        divText.style.backgroundColor = "rgba(55,55,55,0.1)"
        let iOffset = 0
        let countDn = setInterval(() => {
            iDelaySec--
            iOffset = iDelaySec % 2
            divText.innerHTML = iDelaySec + "s<br>&nbsp; " + sInfo + " &nbsp;<br>"

            overlay.firstChild.style.top = iOffset * 10 + "px"
            if (iDelaySec < 1) {
                clearInterval(countDn)
                overlay.remove()
            }
        }, 1000)
    }
    /*        common programming support              */
    /**
     * Returns TRUE if touch is enabled else FALSE
     * @returns {boolean}
     */
    isTouchEnabled() {
        return ('ontouchstart' in window) ||
            (navigator.maxTouchPoints > 0) ||
            (navigator.msMaxTouchPoints > 0);
    }
    /**
     * Set bit iBitNo of iNumber
     * @memberof_ cxTools.commonTools
     * @param {integer} iNumber item which bit is cleared
     * @param {integer} iBitNo  bit 0-31 to set
     * @returns {integer} iNumber
     * @example
     * iVal = bitSet(0,2)     // iVal =  4 0b0000 => 0b0100
     * iVal = bitSet(iVal, 3) // iVal = 12 0b0100 => 0b1100
     */
    bitSet(iNumber, iBitNo) {
        return iNumber | (1 << iBitNo)
    }
    /**
     * Clear bit iBitNo of iNumber
     * @memberof_ cxTools.commonTools
     * @param {integer} iNumber item which bit is cleared
     * @param {integer} iBitNo  bit 0-31 to clear
     * @returns {integer} iNumber
     * @example
     * iVal = bitClear(6,1)     // iVal =  4 0b0110 => 0b0100
     * iVal = bitClear(iVal, 3) // iVal = 12 0b1000 => 0b0000
     */
    bitClear(iNumber, iBitNo) {
        return iNumber & ~(1 << iBitNo);
    }
    /**
    * Toggle bit iBitNo of iNumber
    * @memberof_ cxTools.commonTools
     * @param {integer} iNumber item which bit is cleared
     * @param {integer} iBitNo  bit 0-31 to toggle
    * @returns {integer} iNumber
    * @example
    * iVal = bitToggle(0,1)     // iVal =  2 0b0000 => 0b0010
    * iVal = bitToggle(iVal, 3) // iVal = 10 0b0010 => 0b1010
    */
    bitToggle(iNumber, iBitNo) {
        return bit_test(iNumber, iBitNo) ? bit_clear(iNumber, iBitNo) : bit_set(iNumber, iBitNo);
    }
    /**
    * Check if bit iBitNo of iNumber is set
    * @memberof_ cxTools.commonTools
     * @param {integer} iNumber item which bit is cleared
     * @param {integer} iBitNo  bit 0-31 to test
    * @returns {boolean} true:bit set false:bit not set
    * @example
    * bIsSet = bitTest(4, 1)     // bIsSet=false 4=0b0100
    * bIsSet = bitTest(2, 1)     // bIsSet=true  2=0b0010
    */
    bitTest(iNumber, iBitNo) {
        return ((iNumber >> iBitNo) % 2 != 0)
    }
    /**
     * checks connection to PLC via heartbeat.
     *  if heartbeat = null or not changed since previous
     *  call connection is interrupted => show error dialog
     * @memberof_ cxTools.commonTools
     * @param {string}  sHeartBeatItem name of heartbeat item
     * @return {boolean} true:connected false:disconnected
     * @example
     * SetInterval(()=>{checkHeartbeat("iPlcHeartbeat")}, 3000) // check every 3sec
     */
    async checkHeartbeat(sHeartBeatItem) {
        let bConnected = false
        let iHeartBeatPlc
        try {
            iHeartBeatPlc = await cxt.getItem(sHeartBeatItem, false, false)
        } catch (e) {
            iHeartBeatPlc = cxt.iHeartBeatPlcBak
        }
        bConnected = ((iHeartBeatPlc !== cxt.iHeartBeatPlcBak) && (cxt.iHeartBeatPlcBak !== null))
        if (bConnected) {
            if (cxt.bIsConnectErrorOpen) {
                cxt.closeConnectError()
                cxt.bIsConnectErrorOpen = false
            }
        } else {
            if (!cxt.bIsConnectErrorOpen) {
                cxt.msgBox("connecterror", "${heartbeat_fail}")
                cxt.bIsConnectErrorOpen = true
            }
        }
        cxt.iHeartBeatPlcBak = iHeartBeatPlc
        return bConnected
    }
    /**
     * Reloads WebIQ project
     * @memberof_ cxTools.commonTools
     * @return {void}
     * @example
     * cxt.reloadWebIq() // reload webIQ project in browser
     */
    reloadWebIq() {
        location.reload();
    }
    /**
     * set value of css variable sKey
     * @memberof_ cxTools.commonTools
     * @param {string} sKey css var name
     * @param {string} sValue css var value
     * @return {void}
     * @see cssGetVar
     * @example
     * see example of cssGetVar()
     */
    cssSetVar(sKey, sValue) {
        document.documentElement.style.setProperty(sKey, sValue);
    }
    /**
     * Get value of css variable sKey
     * @memberof_ cxTools.commonTools
     * @param  {string} sKey            css var name
     * @param  {string} sDefault=""     default value, if sKey == ""
     * @param  {bool}   bDelQuotes      =false:return value as defined true:remove quotes at start & end of value string
     * @return {string} Value of sKey
     * @example
     * cxt.cssSetVar("--myColor", "red") // set css variable --myColor = "red"
     * let myColor = cxt.cssGetVar("--myColor", "blue") // returns value of --myColor or "blue" if css variable is undefined
     * // returns value of --ImgDataUrl or "" if css variable is undefined
     * // removes quotes around data url, which are neccessary in css variable definition
     * // :root {
     * //  --icon-info: "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZlcnNpb249IjEuMSIgdmlld0JveD0iMCAwIDEwIDEwIj4KPHJlY3QgeT0iMSIgeD0iMSIgaGVpZ2h0PSI4IiB3aWR0aD0iOCIgc3R5bGU9InN0cm9rZTojZmYwMDAwO3N0cm9rZS13aWR0aDoxIi8+Cjwvc3ZnPgo=";
     * // }
     * let myImgDataUrl = cxt.cssGetVar("--ImgDataUrl", "", true) 
     */
    cssGetVar(sKey, sDefault = "", bDelQuotes = false) {
        // let sVal = document.documentElement.style.getPropertyValue(sKey)
        let sVal = getComputedStyle(document.documentElement).getPropertyValue(sKey)
        if (bDelQuotes) {
            sVal = sVal.replace(/^[^"]+"/g, "")
            sVal = sVal.substring(0, sVal.length - 1)
        }
        return (sVal === "") ? sDefault : sVal
    }
    /**
     * Creates a dom element and appends it to oParent, if oParent is provided
     * @memberof_ cxTools.commonTools
     * @param {domElement} oParent parent element or null
     * @param {string}  sType dom type to create (e.g. table, td, tr,...)
     * @param {string}  [sClass] css class to assign
     * @param {string}  [sText]  text to set (only if element has innterHTML)
     * @returns {domElement} created dom element
     * @example
     * let oTable = cxt.addChild(null, "table", "myTableClass")
     * for (let iRow=1; iRow<4; iRow++) {
     *     let oRow = cxt.addChild(oTable, "tr")
     *       for (let iCol=1; iCol<6; iCol++) {
     *         let oCol = cxt.addChild(oRow, "td", "", `Row=${iRow} Col=${iCol}`)
     *       }
     *     }
     */
    addChild(oParent, sType, sClass = "", sText = "") {
        let oChild = document.createElement(sType)
        if (sClass !== "")
            oChild.setAttribute("class", sClass)
        if (sText !== "")
            oChild.innerHTML = sText
        // oChild.outerHTML = sText
        if (oParent)
            oParent.appendChild(oChild)
        return oChild
    }
    /**
     * Waits iMSec milli seconds
     * @memberof_ cxTools.commonTools
     * @param   {number} iMSec wait time in msec
     * @returns {Promise}
     * @example
     * async function demo() {
     *   console.log("hello") // displays "hello"
     *   await cxt.wait(1000) // waits 1 sec
     *   console.log("wait")  // displays "wait" after 1 sec
     * }
     */
    wait(iMSec) {
        return new Promise(resolve => setTimeout(resolve, iMSec))
    }
    /**
     * Displays error message and stops java script execution
     * @memberof_ cxTools.commonTools
     * @param {string} sMsg abort message
     * @param {bool}   [bHideStack=false] false:show stack true:hide stack
     * @return {void}
     * @example
     * cxt.abortJS("Development bug 1", false) // aborts function and display dialog with message and stack
     * cxt.abortJS("Development bug 2", true)  // aborts function and display dialog with message without stack
     */
    abortJS(sMsg, bHideStack = false) {
        let myErr = new Error();
        const sStack = myErr.stack
            .split('\n')
            .slice(2)  // remove row 1+2 containing non relevant info
            // .map((line) => line.replace(/[ ]+at[ ]+/, ''))          
            // .map((line) => line.replace(/\s+at\s+/, ''))
            .map(function x(i) { return i.replace(/^[ ]+at[ ]+/, '- ') })
            .join('\n') // concat to string

        if (bHideStack === true) {
            sMsg += "\n\n";
        } else {
            sMsg += "\n\n" + sStack.replaceAll(document.location.href, "./")
        }
        cxt.msgBox("bug", sMsg.replaceAll("\n", "<br>"))
        // exit JS program
        throw new Error(`\n*** abortJS("${sMsg}") ***\nDo not catch error.\nIt is thrown to stop script because of programming bug.`);
    }
    /**
     * When you provided a non existing item to onReady(), the callback is never executed. 
     * With this function, you can detect this problem. <br>
     * Checks if onReady() callback of sModul was executed.
     * If not program is aborted & a dialog message is displayed <br>
     * @memberof_ cxTools.commonTools
     * @param {string}  sModulName name of local script
     * @param {number}  iTime      wait time in msec before check starts
     * @example
     * // WebIQ local script
     * module.run = function (self) {
     *   cxt.onReadyCheck(MODULE_NAME, 2000); // check after 2s if onReady() fired
     *   // SInt must be used in the panel
     *   const cancelable = shmi.onReady({
     *     controls: {},
     *     items: {
     *         SInt: "SInt"
     *     },
     *     resources: {}
     *   }, function (resolved) {
     *     cxt.onReadyOk(MODULE_NAME);  // set flag, callback is executed
     *     console.log("SInt="+ resolved.items.SInt.value)
     *   });
     *   // called when this local-script is disabled
     *   self.onDisable = function () {
     *      cancelable.cancel(); // cancel onReady() function
     *      self.run = false;    // from original .onDisable function of LocalScript control
     *   };
     * };
     */
    onReadyCheck(sModulName, iTime = 2000) {
        setTimeout(() => {
            if (this.jOnReady[sModulName] === true) {
                delete this.jOnReady[sModulName]
            } else {
                this.abortJS("onReady timeout: " + sModulName)
            }
        }, iTime)
    }
    /**
     * Must be called within onReady() callback
     * @memberof_ cxTools.commonTools
     * @param {string} sModulName name of local script
     * @see onReadyCheck
     * @example
     * see example of onReadyCheck()
     */
    onReadyOk(sModulName) {
        this.jOnReady[sModulName] = true
    }
    /**
     * checks if parameters have defined types
     * @memberof_ cxTools.commonTools
     * @param {*} parameterNameOrNumber 
     * @param {*} variable 
     * @param {*} types 
     * @see shmi.checkArg
     * @example
     * ToDo: Add example
     */
    checkArg(parameterNameOrNumber, variable, types) {
        let sCmd = `shmi.checkArg(`
        sCmd += `"${parameterNameOrNumber}", variable`
        for (let i = 2; i < arguments.length; i++) {
            sCmd += `, "${arguments[i]}"`
        }
        sCmd += ")"

        try {
            eval(sCmd)
        } catch (e) {
            cxt.abortJS(e.message)
        }
    }
    /**
     * Download sText as file, depenendt on browser defaults, the browser prompts for the file name or not
     * @memberof_ cxTools.commonTools
     * @param {string} sText     string to save as file
     * @param {string} sFileName name of download file
     * @return {void}
     * @example
     * downloadTextFile("my string to download as file", "text.txt")
     */
    downloadTextFile(sText, sFileName) {
        const anchor = document.createElement("a");
        anchor.href = `data:text/json;charset=utf-8,${encodeURIComponent(sText)}`;
        anchor.download = sFileName;
        anchor.click();
    }
    /**
     * Check if str contains an integer
     * @memberof_ cxTools.commonTools
     * @param {any} str string to check
     * @returns {boolean} 
     * @example
     * let r = isInt("123") // r=true
     * r = isInt("1.2")     // r=false
     * r = isInt(3)         // r=true
     * r = isInt("abc")     // r=false
     */
    isInt(str) {
        str = "" + str
        return /^[+-]?\d+$/.test(str);  // returns a boolean
    }
    /**
     * Check if str contains a float (exponential numbers not supported)
     * @memberof_ cxTools.commonTools
     * @param {any} str string to check
     * @returns {boolean} 
     * @example
     * let r = isFloat("123.45") // r=true
     * r = isFloat("1")          // r=true
     * r = isFloat(3.14)         // r=true
     * r = isFloat("abc")        // r=false
     */
    isFloat(str) {
        str = "" + str
        return /^[+-]?\d+\.?\d*$/.test(str);  // returns a boolean
    }
    /**
     * Check if val is null or undefined
     * @memberof_ cxTools.commonTools
     * @param {any} val value to check
     * @returns {boolean} true:is null or undefined false: val is NOT null or undefined
     */
    isNullOrUndef(val) {
        // `value == null` is the same as `value === undefined || value === null`
        return val == null
    }
    /** split a csv string. Mask char is removed and decoded
     * @memberof_ cxTools.commonTools
     * @param sFS   {string} csv field seperator (1 char)
     * @param sText {string} csv text for splitting
     * @param sMask {string} csv mask character
     * @return {array} array of splitted strings
     * @example
     * let arW = csvSplit("10;20;"a;b";"c""d"') // arW = ['10', '20', 'a;b', 'c"d']
     * 
     */
    csvSplit(sText, sFS = ";", sMask = `"`) {
        let sRegEx = `(?:\"([^\"]*(?:\"\"[^\"]*)*)\")|([^\",]+)`
        let sSearch = `""`
        let sReplace = `"`
        sFS = sFS.substring(0, 1)
        sMask = sMask.substring(0, 1)

        raw = raw.replaceAll(`"`, sMask)
        sRegEx = sRegEx.replaceAll(`"`, sMask)
        sSearch = sSearch.replaceAll(`"`, sMask)
        sReplace = sReplace.replaceAll(`"`, sMask)

        const reValues = new RegExp(sRegEx, "g");
        const reSearch = new RegExp(sSearch, "g")

        let element = {};
        arData = []
        // create json object, key=column name value=column value
        while (matches = reValues.exec(sText)) {
            var value = matches[1] || matches[2];
            value = value.replace(reSearch, sReplace)
            arData.push(value)
        }
        return arData
    }
    /** Creates a csv formated STRING, by appending sText to sCsvText
     * If sFS or sMask is included in sText the generated string is automatically (CSV conform) masked
     * @memberof_ cxTools.commonTools
     * @param sCsvText {string} csv text (single line)
     * @param sText    {string} column text for append
     * @param sFS      {string} csv field seperator (1 char)
     * @param sMask    {string} csv mask character
     * @example
     * let sCsv = ""
     * sCsv = csvAppend(sCsv, 10, ';', '"')     // sCsv = '10
     * sCsv = csvAppend(sCsv, 20, ';', '"')     // sCsv = '10;20'
     * sCsv = csvAppend(sCsv, 'a;b', ';', '"')  // sCsv = "10;20;"a;b"'
     * sCsv = csvAppend(sCsv, 'c"d', ';', '"')  // sCsv = "10;20;"a;b";"c""d"'
     */
    csvAppend(sCsvText, sText, sFS = `;`, sMask = `"`) {
        sFS = sFS.substring(0, 1)
        sMask = sMask.substring(0, 1)
        sText = "" + sText
        sText = sText.replaceAll(sMask, sMask + sMask)
        if (sText.includes(sFS))
            sText = sMask + sText + sMask
        if (sCsvText !== "")
            sText = sFS + sText
        return sCsvText + sText
    }
    /* FILTER    */
    /**
     * Checks if all words of arFillter are contained in sText
     * @memberof_ cxTools.filter
     * @param  {string}   sText text to be checked
     * @param  {string[]} arFilter array with searched strings
     * @return {boolean}  true=matches false=NOT matches arFilter
     * @example
     * let bMatch = filterMatch("ab cd ef", ["a", "b"]) // bMatch = true
     * bMatch = filterMatch("ab cd ef", ["b", "a"])     // bMatch = true
     * bMatch = filterMatch("ab cd ef", ["a", "bz"])    // bMatch = false
     */
    filterMatch(sText, arFilter) {
        if (typeof arFilter !== "object") return
        if (false) {
            // use regular expression
            for (let i = 0; i < arFilter.length; i++) {
                let regEx = new RegExp(arFilter[i], "ig");
                return sText.match(regEx)
            }
        } else {
            for (let i = 0; i < arFilter.length; i++) {
                if (sText.indexOf(arFilter[i]) === -1) {
                    return false
                }
            }
            return true
        }
    }
    /*    SORTING     */
    /**
     * Sort array of json objects
     * @memberof_ cxTools.sort
     * @param {string}   sKey1 name of 1st key used for sorting (mandatory)
     * @param {string}   sKey2 name of 2nd key used for sorting (optional)
     * @returns {number} 1=a greater then b -1:a lower than b 0:a equal b
     * @example
     * arList = [{ name: "b", size: 10 }, { name: "a", size: 20 }, { name: "C", size: 3 },
     * { name: "b", size: 1 }]
     * arList = arList.sort(cxt.sortByKey(false, "name", null, cxt.parseToLower, null))
     * console.log(arList[0].name + " " + arList[0].size) // a 20
     * console.log(arList[1].name + " " + arList[1].size) // b 10
     * console.log(arList[2].name + " " + arList[2].size) // b 1
     * console.log(arList[3].name + " " + arList[3].size) // C 3
     * 
     * console.log("___")
     * arList = arList.sort(cxt.sortByKey(false, "name", "size", cxt.parseToLower, null))
     * console.log(arList[0].name + " " + arList[0].size) // a 20
     * console.log(arList[1].name + " " + arList[1].size) // b 1
     * console.log(arList[2].name + " " + arList[2].size) // b 10
     * console.log(arList[3].name + " " + arList[3].size) // C 3
     * 
     * console.log("___")
     * arList = arList.sort(cxt.sortByKey(false, "size", null, null, null))
     * console.log(arList[0].name + " " + arList[0].size) // b 1
     * console.log(arList[1].name + " " + arList[1].size) // C 3
     * console.log(arList[2].name + " " + arList[2].size) // b 10
     * console.log(arList[3].name + " " + arList[3].size) // a 20
     */
    sortByKey(bReverse, sKey1, sKey2, fctParse1, fctParse2) {
        const iRet = bReverse ? -1 : 1;

        return function (a, b) {
            let aa = a[sKey1];
            let bb = b[sKey1];

            if (fctParse1) {
                aa = fctParse1(aa);
                bb = fctParse1(bb);
            }
            if (aa > bb) {
                return iRet;
            } else if (aa < bb) {
                return -iRet;
            } else {
                // use optional sKey2
                if (sKey2) {
                    let aa = a[sKey2];
                    let bb = b[sKey2];

                    if (fctParse2) {
                        aa = fctParse2(aa);
                        bb = fctParse2(bb);
                    }
                    if (aa > bb) {
                        return iRet;
                    } else if (aa < bb) {
                        return -iRet;
                    } else {
                        return 0;
                    }
                }
            }
        }
    }
    /*     FORMATING        */
    /**
     * Converts string to lower case for sorting
     * @memberof_ cxTools.format
     * @param {string} sIn string to convert
     * @returns {string} converted lower string
     * @see sortByKey
     * @example
     * see cxt.sortByKey
     */
    parseToLower(sIn) {
        return ("" + sIn).toLowerCase();
    }
    /**
     * Converts bool to number for sorting
     * @memberof_ cxTools.format
     * @param {bool}     bVal boolean to convert
     * @returns {number} converted number
     * @see sortByKey
     * @example
     * see cxt.sortByKey
     */
    parseBool(bVal, sOn, sOff) {
        return ["true", "1", "on"].includes(("" + bVal).toLowerCase()) ? sOn : sOff
    }
    /**
     * Inserts a seperator into a string for better readability.<br>
     * e.g. thousand sepearator into numbers "12345" => "12 345"
     * @memberof_ cxTools.format
     * @param {string} sText text to format
     * @param {number} iLen  section length
     * @param {string} sFS   text to insert
     * @returns {string}     formated string
     * @example
     * let sTest = ""
     * sTest = formatSection("123456", 3, " ") // "123 456"
     * sTest = formatSection("0101110111", 4, "_") // 01_0001_0111
     */
    formatString(sText, iSecLen = 3, sFS = " ") {
        let sOut = ""
        let sFsTmp = ""
        let iLen = (sText.length % iSecLen)
        iLen = (iLen === 0) ? iSecLen : iLen
        for (let i = 0; i < sText.length;) {
            sOut += sFsTmp + sText.substring(i, i + iLen)
            sFsTmp = sFS
            i += iLen
            iLen = iSecLen
        }
        return sOut
    }
    /**
     * @memberof_ cxTools.format
     * Show 1000 seperator for numbers
     * @param {boolean} seperator when no bool is provided, just return value, else set value&return it
     * @returns {boolean} true:insert false: do not insert 1000 seperator
     * @example see int2String
     */
    seperator1000(seperator = null) {
        if (seperator === true)
            this.sectionLen = 3
        else if (seperator === false)
            this.sectionLen = 0
        return (this.sectionLen > 0)
    }
    /**
     * Converts an interger number to a DEC,HEX,BIN,OCT,.. string
     * Alias i2s = cxt.int2String
     * @memberof_ cxTools.format
     * @param {number} iVal         Number to convert
     * @param {number} iBase        base used for convert (e.g. 2=bin 16=hex)
     * @param {number} [iLen]       length of converted string withou sFS
     * @param {number} [iSecLen]    length of sections
     * @param {number} [sFC="0"]    fill character for pad start
     * @returns {string} string of iVal
     * @example
     * // hex number
     * let sNbr = cxt.int2String(255, 16, 4)); // sNbr = "00FF"
     * // binary number
     * sNbr = cxt.int2String(5, 2, 4)); // sNbr = "0101"
     * sNbr = cxt.int2String(2695938256, 16, 12, 4, "_")); // sNbr = "0000 A0B0 C0D0"
     * // decimal number
     * sNbr = cxt.int2String(99, 10, 4, 0, "0") // sNbr = "0010"
     * seperator1000(true)
     * sNbr = cxt.int2String(12345, 10, 0, -1)  // sNbr = "123 45"
     * seperator1000(false)
     * sNbr = cxt.int2String(12345, 10, 0, -1)  // sNbr = "12345"
     */
    int2String(iVal, iBase = 10, iLen = 0, iSecLen = 0, sFS = "0") {
        if (iSecLen < 0) iSecLen = this.sectionLen
        let sVal = parseInt(iVal).toString(iBase).toUpperCase().padStart(iLen, sFS)
        if (iSecLen > 0) {
            sVal = cxt.formatString(sVal, iSecLen, " ")
        }
        return sVal
    }
    /**
     * Format float number with digits. 
     * Alias f2s = cxt.float2String
     * @memberof_ cxTools.format
     * @param {float}   rVal    number to format
     * @param {integer} [iDigits] digits to display
     * @param {number}  [iSecLen]    >=0:length of sections <0:use global setting
     * @returns string formated number {string}
     * @example
     * let sText = cxt.float2String(1.2345, 2)     // sText = "1.23"
     * sText = cxt.float2String(1.2348, 3)         // sText = "1.235"
     * sText = cxt.float2String(12345.2348, 2, 3)  // sText = "12 345.24"
     * seperator1000(true)
     * sNbr = cxt.int2String(12345, 2, -1)  // sNbr = "123 45"
     * seperator1000(false)
     * sNbr = cxt.int2String(12345, 10, 0, -1)  // sNbr = "12345"
     */
    float2String(rVal, iDigits = 2, iSecLen = 0) {
        let sFS = " "
        let sVal = parseFloat(rVal).toFixed(iDigits)

        if (iSecLen < 0) iSecLen = this.sectionLen
        if (iSecLen > 0) {
            const arW = sVal.split(".")
            sVal = cxt.formatString(arW[0], iSecLen, sFS)
            if (arW.length === 2) sVal += `.${arW[1]}`
        }
        return sVal
    }
    /**
     * adds/changes the json which defines a keyboard language
     * @memberof_ cxTools.dialog
     * @param {string} sLanguage 2 letter id string for language
     * @param {json}   jData     json defining keypad
     * @return {void}
     * @see keypad
     * @example 
     * // Keypad has 2 pages (char, number), a header and a footer.
     * // The 2nd page can be used for special characters like �, @, ~,...
     * // Any page, can contain any character or function key
     * // Just write the char and function keys, separated by one or multiple spaces in a string. (example see below)
     * //
     * // Character keys: Are defined by providing the character e.g. X
     * // Function keys:
     * // #cancel cancel key
     * // #ok     ok key
     * // 
     * // #|<     move cursor to start
     * // #>|     move cursor to end
     * // #<<     move cursor to previous word
     * // #>>     move cursor to next word
     * // #<      move cursor to previous char
     * // #>      move cursor to next char
     * // 
     * // #abc    display keypad character page
     * // #123    display keypad special char page 
     * // #shift  shift key
     * // #<del   delete key
     * // #clear  clear user input
     * // #space  space key
     * // #+-     +/- key
     * const jDE = {
     *      char: [
     *          {
     *              lower: "° 1 2 3 4 5 6 7 8 9 0 ß",
     *              upper: '^ ! " § $ % & / ( ) = ?'
     *          },
     *          {
     *              lower: "q w e r t z u i o p ü #<del",
     *              upper: "Q W E R T Z U I O P Ü #<del"
     *          },
     *          {
     *              lower: "a s d f g h j k l ö ä #",
     *              upper: "A S D F G H J K L Ö Ä '"
     *          },
     *          {
     *              lower: "#shift < y x c v b n m , . -",
     *              upper: "#shift > Y X C V B N M ; : _"
     *          }
     *      ],
     *      // structure of number[] is identical to char[], can be empty if not used
     *      number: [],
     *      header: { lower: "#|< #< #clear #> #>|" },
     *      footer: { lower: "#cancel #abc #space #123 #ok" }
     *  }
     * cxt.keypadAddLanguage("de", jDE)
     */
    keypadAddLanguage(sLanguage, jData) {
        this.keypadLanguages[sLanguage] = jData
    }
    /**
     * Displays a virtual keypad (numeric,alphanumeric) and saves edited value
     * @memberof_ cxTools.dialog
     * @param {any}     sItem           item to edit. webIQ Item name (string) or dom element name or value for "input" 
     * @param {string}  sType           type of sItem "webiq","innerText","innerHTML","value","input"
     * @param {number}  iDigits         TYP_FLOAT: number of digits
     * @param {number}  iType           TYP_STRING=0, TYP_INT=2, TYP_FLOAT=3
     * @param {number}  rMin            TYP_STRING: unused      ELSE: min value for numeric input
     * @param {number}  rMax            TYP_STRING: max. length ELSE: max value for numeric input
     * @param {boolean} bSelectLanguage true:allow to select language false:do not allow to select language
     * @param {boolean} bIsUtf8         webiq string is utf8 encoded
     * @returns {Promise}               Edited value or null for cancel
     * @see keypadAddLanguage
     * @example
     * keypad("SInt",    "webiq", -1, TYP_INT )         // displays numpad for integer. No input range
     * keypad("SFloat",  "webiq", -1, TYP_FLOAT)        // displays numpad for float. No input range
     * keypad("SFloat",  "webiq", -1, TYP_FLOAT, 0, 20) // displays numpad for float. input range:0-20
     * keypad(myDomText, "value", -1, TYP_STRING)       // directly edits a value item of a DOM elements
     */
    async keypad(sItem, sType = "webiq", iDigits = -1, iType = TYP_STRING, rMin = -100, rMax = 100,
        bSelectLanguage = true, bIsUtf8 = false) {
        if (this.bKeypadEnabled === false) return

        let cxtKeypadLanguages = this.keypadLanguages
        const im = shmi.requires("visuals.session.ItemManager")
        let bCheckRange = false
        let bChanged = false
        let sRange = ""
        let bCancelEdit = true
        const jCmd = {
            "cancel": CHAR_CANCEL, //String.fromCharCode(10008),
            "|<": CHAR_START,      //String.fromCharCode(8676),
            "<<": CHAR_WLEFT,      //String.fromCharCode(10508), 
            "<": CHAR_LEFT,        //String.fromCharCode(8592),
            ">": CHAR_RIGHT,       //String.fromCharCode(8594),
            ">>": CHAR_WRIGHT,     //String.fromCharCode(10509),
            ">|": CHAR_END,        //String.fromCharCode(8677),
            "shift": CHAR_SHIFT,   //String.fromCharCode(8682),
            "+-": CHAR_PLUSMIN,
            "<del": CHAR_DEL,
            "ro": "ro",           // toggle read only
            "clear": "CE",
            "space": "",
            "abc": "abc",
            "123": "!#1",
            "ok": CHAR_OK // String.fromCharCode(10004), 
        }
        let jLangKeys = ""
        if ([TYP_FLOAT, TYP_INT].includes(iType)) {
            let iTmp = 0
            if (typeof (rMin) === "number" && typeof (rMax) === "number") {
                bCheckRange = true;
                if (iType === TYP_FLOAT) iTmp = (iDigits < 1) ? 3 : iDigits
                if (rMin === DEFAULT_MIN) sRange += `min: ${rMin.toFixed(iTmp)}<br>`
                if (rMax === DEFAULT_MAX) sRange += `max: ${rMax.toFixed(iTmp)}`

                sRange = `min: ${rMin.toFixed(iTmp)}<br>max: ${rMax.toFixed(iTmp)}`
            }
        } else {
            jLangKeys = cxtKeypadLanguages[this.sKeypadLanguage]
        }
        let sPage = "char"
        let iShift = 0                 // 0: off 1:shift on 2: caps locked
        let bFirstCall = true          // true: no child defined before
        let overlay = cxt.getOverlay() // get overlay div
        let box = overlay.firstChild   // get content div
        box.onkeyup = checkHwKeys
        let sItemValue = ""
        let btnOk = null

        box.style.width = "80%"
        box.style.minWidth = "400px"
        overlay.style.zIndex = ZINDEX_KEYPAD;

        if ([TYP_FLOAT, TYP_INT].includes(iType)) {
            jLangKeys = (iType === TYP_FLOAT) ? this.numPadFloat : this.numPadInt
            box.style.width = "280px"
            box.style.minWidth = "220px"
        }
        // get item content for editing
        if (sType === "webiq") {
            sItemValue = await cxt.getItem(sItem)
            if (sItemValue === null) {
                cxt.abortJS("Invalid WebIQ item: " + sItem)
                return
            }
            // if (bIsUtf8) sItemValue = cxt.utf8_2_utf16(sItemValue)
            if (bIsUtf8) sItemValue = shmi.from_utf8(sItemValue)
        } else if (sType === "innerText") {
            sItemValue = sItem.innerText
        } else if (sType === "innerHTML") {
            sItemValue = sItem.innerHTML
        } else if (sType === "value") {
            sItemValue = sItem.value
        } else if (sType === "input")
            sItemValue = sItem

        // header
        let oKeypad = cxt.addChild(box, "div", "keypad")
        let divHeader = cxt.addChild(oKeypad, "div", "header")
        let divInfo = null
        // content
        let divContent = cxt.addChild(oKeypad, "div", "")
        divContent.style.padding = "10px"

        // text input
        let divText = cxt.addChild(divContent, "div")
        let txtEdit = cxt.addChild(divText, "input", "input")
        txtEdit.onblur = function () { txtEdit.focus() }
        // ignore char's for numeric input
        txtEdit.onkeydown = function (e) {
            let bCancel = false
            let sCharOk = "0123456789"
            if (iType === TYP_INT) {
                if ("+-".includes(e.key)) {
                    let iPos = txtEdit.selectionStart
                    let sTmp = txtEdit.value
                    if (sTmp.startsWith("-")) {
                        sTmp = sTmp.substring(1)
                        iPos--
                    } else {
                        sTmp = "-" + sTmp
                        iPos++
                    }
                    txtEdit.value = sTmp
                    setCursorPos(iPos)
                    bCancel = true
                } else {
                    bCancel = !sCharOk.includes(e.key) ? true : false
                }

            } else if (iType === TYP_FLOAT) {
                if (!txtEdit.value.includes(".")) sCharOk += "."
                bCancel = !sCharOk.includes(e.key) ? true : false
            }

            bCancel = ((e.key.length > 2) && (!["Enter", "Escape"].includes(e.key))) ? false : bCancel
            if (bCancel) {
                e = e || window.event;
                // to cancel the event:
                if (e.preventDefault) e.preventDefault();
                return false;
            }
            checkChanged((["ArrowLeft", "ArrowRight", "Backspace", "Delete"].includes(e.code)) ? false : true)
        }
        txtEdit.onkeyup = function (e) {
            checkRange()
        }

        // txtEdit.type = (iType === TYP_STRING) ? "text":"number"
        txtEdit.type = (iType === TYP_PASSWORD) ? "password" : "text"
        txtEdit.value = (TYP_FLOAT === iType) ? parseFloat(sItemValue).toFixed(4) : sItemValue
        if ([TYP_FLOAT, TYP_INT].includes(iType)) {
            txtEdit.style.textAlign = "right"
            txtEdit.classList.add("highlight")

            // min max info
            cxt.addChild(divContent, "div", "minmax", sRange)
        }
        txtEdit.setAttribute("virtualkeyboardpolicy", "manual")
        if (!("virtualKeyboard" in navigator)) txtEdit.readOnly = true

        divInfo = cxt.addChild(divContent, "div", "warning")
        divInfo.innerHTML = '&nbsp;' //(sType === "webiq") ? sItem : sItem + "." + sType
        divInfo.setAttribute("class", "divMsgOk")

        // key rows
        let divKeys = cxt.addChild(divContent, "div", "")
        let divCtrls = cxt.addChild(divContent, "div", "row")
        update(false)

        // // footer
        // let divCtrls = cxt.addChild(divContent, "div", "row")
        // arW = jLangKeys.footer.lower.split(" ")
        // for (let iCol = 0; iCol < arW.length; iCol++) {
        //     addKey(arW[iCol], divCtrls)
        // }
        setCursorPos(txtEdit.value.length)
        checkRange()
        txtEdit.focus()

        return new Promise((resolve, reject) => {
            overlay.addEventListener('closeOverlay', function (e) {
                overlay.remove()
                if (bCancelEdit) {
                    resolve(null)
                } else {
                    let sVal = txtEdit.value
                    if (sType === "webiq") {
                        // if (bIsUtf8) sVal = cxt.utf16_2_utf8(txtEdit.value)
                        if (bIsUtf8) sVal = shmi.to_utf8(txtEdit.value)
                        cxt.setItem(sItem, sVal);
                    } else if (sType === "innerText") {
                        sItem.innerText = sVal
                    } else if (sType === "innerHTML") {
                        sItem.innerHTML = sVal
                    } else if (sType === "value") {
                        sItem.value = sVal
                        sItem.focus()
                    }
                    resolve(sVal)
                }
                // bCancelEdit ? resolve(null) : resolve(txtEdit.value)
            }, { once: false });
        })
        // }
        function setCursorPos(iPos) {
            txtEdit.setSelectionRange(iPos, iPos)
        }
        function checkChanged(bClear = false) {
            if (bChanged === false) {
                txtEdit.classList.remove("highlight")
                bChanged = true
                if ((bClear) && ([TYP_FLOAT, TYP_INT].includes(iType)))
                    txtEdit.value = ""
            }
        }
        function btnChar() {
            checkChanged(true)
            let sText = this.value
            // log("btnChar:" + sText)
            if (sText === ".") {
                if (iType === TYP_INT)
                    return
                else if (iType == TYP_FLOAT) {
                    if (txtEdit.value.includes("."))
                        return
                }
            }
            let iPos = txtEdit.selectionStart
            txtEdit.setRangeText(sText, iPos, iPos)
            setCursorPos(iPos + sText.length)
            if (iShift === 1) {
                iShift = 0
                update()
            }
            checkRange()
        }
        function checkRange() {
            if (bCheckRange) {
                let rValue = (iType === TYP_FLOAT) ? parseFloat(txtEdit.value) : parseInt(txtEdit.value)
                if (rValue < rMin) {
                    btnOk.disabled = true
                    divInfo.setAttribute("class", "divMsgErr")
                    divInfo.innerHTML = shmi.localize("${cxVisuals.LowerMin}")
                } else if (rValue > rMax) {
                    btnOk.disabled = true
                    divInfo.setAttribute("class", "divMsgErr")
                    divInfo.innerHTML = shmi.localize("${cxVisuals.GreaterMax}")
                } else {
                    btnOk.disabled = false
                    divInfo.setAttribute("class", "divMsgOk")
                    let bShowItem = false // change to global var, with set/get for external access
                    if (bShowItem)
                        divInfo.innerHTML = (sType === "webiq") ? sItem : sItem + "." + sType
                    else
                        divInfo.innerHTML = "&nbsp;"
                }
                // btnOk.style.visibility = btnOk.disabled ? "hidden" : "visible"
            } else if ([TYP_STRING, TYP_PASSWORD].includes(iType)) {
                if (rMax > 0) {
                    let iLenTxt = txtEdit.value.length
                    if (iLenTxt > rMax) {
                        btnOk.disabled = true
                        divInfo.setAttribute("class", "divMsgErr")
                        divInfo.innerHTML = shmi.localize("${cxVisuals.TextTooLong} ") + `(≤ ${rMax.toFixed(0)})`
                    } else {
                        btnOk.disabled = false
                        divInfo.setAttribute("class", "divMsgOk")
                        divInfo.innerHTML = "&nbsp;"
                    }
                }
            }
            if (btnOk.disabled)
                btnOk.classList.add("disabled")
            else
                btnOk.classList.remove("disabled")
        }
        function btnCmd() {
            let me = this
            checkChanged(false)
            let sCmd = me.getAttribute("cmd")
            if (sCmd === "cancel") {
                // sItem = null
                bCancelEdit = true
                overlay.dispatchEvent(new Event('closeOverlay'))
            } else if (sCmd === "ro") {
                console.warn("toogle readOnly=" + txtEdit.readOnly)
                txtEdit.readOnly = !txtEdit.readOnly
            } else if (sCmd === "ok") {
                bCancelEdit = false
                overlay.dispatchEvent(new Event('closeOverlay'))
            } else if (sCmd === "|<") {
                setCursorPos(0)
            } else if (sCmd === ">|") {
                setCursorPos(txtEdit.value.length)
            } else if (sCmd === "<<") {
                let iPos = txtEdit.selectionStart
                let sText = txtEdit.value
                if (iPos > 0) {
                    let iTmp = iPos - 1
                    let sTmp = sText.substring(iTmp, iTmp - 1)
                    while ((sTmp === " ") && (iTmp > 0)) {
                        iTmp--
                        sTmp = sText.substring(iTmp, iTmp + 1)
                    }
                    while ((sTmp !== " ") && (iTmp > 0)) {
                        iTmp--
                        sTmp = sText.substring(iTmp, iTmp + 1)
                    }
                    setCursorPos((iTmp === 0) ? 0 : iTmp + 1)
                }
            } else if (sCmd === ">>") {
                let iPos = txtEdit.selectionStart
                let sText = txtEdit.value
                if (iPos < sText.length) {
                    let iTmp = iPos + 1
                    let sTmp = sText.substring(iTmp, iTmp + 1)
                    while ((sTmp !== " ") && (iTmp < sText.length)) {
                        iTmp++
                        sTmp = sText.substring(iTmp, iTmp + 1)
                    }
                    while ((sTmp === " ") && (iTmp < sText.length)) {
                        iTmp++
                        sTmp = sText.substring(iTmp, iTmp + 1)
                    }
                    setCursorPos(iTmp)
                }
            } else if (sCmd === "<") {
                if (txtEdit.selectionStart > 0)
                    setCursorPos(--txtEdit.selectionStart)
            } else if (sCmd === ">") {
                setCursorPos(++txtEdit.selectionStart)
            } else if (sCmd === "abc") {
                iShift = 0
                sPage = "char"
                update()
            } else if (sCmd === "123") {
                iShift = 0
                sPage = "number"
                update()
            } else if (sCmd === "shift") {
                iShift = (iShift == 2) ? 0 : iShift + 1
                update()
            } else if (sCmd === "<del") {
                let iPos = txtEdit.selectionStart
                if (iPos > 0)
                    txtEdit.setRangeText("", iPos - 1, iPos)
            } else if (sCmd === "clear") {
                if ([TYP_STRING, TYP_PASSWORD].includes(iType))
                    txtEdit.value = ""
                else
                    txtEdit.value = "0"
            } else if (sCmd === "+-") {
                let iPos = txtEdit.selectionStart
                let iOffset = 0
                if (txtEdit.value.startsWith("-")) {
                    txtEdit.value = txtEdit.value.substring(1)
                    iOffset = (iPos > 0) ? -1 : 0
                } else {
                    txtEdit.value = "-" + txtEdit.value
                    iOffset = 1
                }
                setCursorPos(iPos + iOffset)

            } else
                abortJS("not implemented:" + sCmd)
            checkRange()
        }
        function addKey(sVal, oDiv) {
            if (sVal === "")
                return
            if (MOVE_CURSOR_CMDS.includes(sVal))
                if (!"virtualKeyboard" in navigator)
                    return
            let btn = cxt.addChild(oDiv, "input", "key")
            btn.type = "button"
            if (sVal.match("^#.")) {
                sVal = sVal.substring(1)
                if (sVal === "#") {
                    btn.value = sVal
                    btn.onclick = btnChar
                } else if (sVal === "space") {
                    btn.value = " "
                    btn.onclick = btnChar
                    btn.setAttribute("class", "spaceKey")
                } else if (jCmd[sVal]) {
                    btn.value = jCmd[sVal]
                    btn.onclick = btnCmd
                    btn.setAttribute("class", "funcKey")
                    btn.setAttribute("cmd", sVal)
                    if ((sVal === "shift"))
                        if (iShift > 0)
                            btn.classList.add((iShift === 1) ? "shiftKey1" : "shiftKey2")
                } else {
                    cxt.abortJS("Invalid command in keypad def: #" + sVal.replaceAll("<", "&lt;").replaceAll(">", "&gt;"))
                }
            } else {
                btn.value = sVal
                btn.onclick = btnChar
            }
            if (sVal === "ok") {
                btnOk = btn
            }

            return btn
        }
        /**
         * create select box with options
         * @param {element}  jParent    parent HTML element
         * @param {string[]} arData     array with data options
         * @param {string}   sPrefix    prefix to data options to generate localization
         * @returns {element} created select element
         */
        function makeSelect(jParent, arData, sPrefix = "lang") {
            let select = document.createElement("select");
            select.style.textAlign = "left"
            select.style.color = "blue"

            // Create & append options
            for (let i = 0; i < arData.length; i++) {
                let option = document.createElement("option")
                option.value = arData[i]
                option.text = " " + shmi.localize("${" + `${sPrefix}.${arData[i]}` + "}") + " . "
                option.style.fontSize = "200%"
                // option.style.color = "blue"
                select.appendChild(option)
            }
            jParent.appendChild(select)
            return select
        }
        /**
         * update keypad layout, when pressing shift or different page
         */
        function update() {
            // let divTmpHdr = cxt.addChild(oKeypad, "div", "header")
            while (divHeader.firstChild) {
                divHeader.removeChild(divHeader.lastChild);
            }
            if (([TYP_STRING, TYP_PASSWORD].includes(iType)) && (bSelectLanguage)) {
                let oLang = makeSelect(divHeader, Object.keys(cxtKeypadLanguages))
                oLang.value = cxt.sKeypadLanguage
                oLang.onchange = () => {
                    // console.log("onchange language:" + oLang.value)
                    jLangKeys = cxtKeypadLanguages[oLang.value]

                    // cxt.setActiveLanguage(iKeypadLanguage)
                    cxt.sKeypadLanguage = oLang.value

                    // update keypad
                    iShift = 0
                    sPage = "char"
                    update()
                }
            }
            let arW = jLangKeys.header.lower.split(/[ ]+/)
            for (let iCol = 0; iCol < arW.length; iCol++) {
                addKey(arW[iCol], divHeader)
            }

            let divTmpKeys = cxt.addChild(null, "div", "rows")
            let sKeyMode = (iShift > 0) ? "upper" : "lower"
            let jRows = jLangKeys[sPage]
            for (let iRow = 0; iRow < jRows.length; iRow++) {
                let oRow = cxt.addChild(divTmpKeys, "div", "row")
                let arKeys = jRows[iRow][sKeyMode].split(" ")
                for (let iCol = 0; iCol < arKeys.length; iCol++) {
                    addKey(arKeys[iCol], oRow)
                }
            }

            // footer
            let divTmpFooter = cxt.addChild(divContent, "div", "row")
            arW = jLangKeys.footer.lower.split(" ")
            for (let iCol = 0; iCol < arW.length; iCol++) {
                addKey(arW[iCol], divTmpFooter)
            }

            if (bFirstCall === false) {
                // divHeader.firstChild.remove()
                divKeys.firstChild.remove()
                divCtrls.firstChild.remove()
            }
            bFirstCall = false
            // divHeader.appendChild(divTmpHdr)
            // divHeader = divTmpHdr
            divKeys.appendChild(divTmpKeys)
            divCtrls.appendChild(divTmpFooter)

        }
        /**
         * close keypad when Enter(=ok) or Escape(=cancel) is pressed
         * @param {*} evt event data
         */
        function checkHwKeys(evt) {
            if (evt.key === "Enter") {
                bCancelEdit = false
                if (!btnOk.disabled)
                    overlay.dispatchEvent(new Event('closeOverlay'))
            } else if (evt.key === "Escape") {
                bCancelEdit = true
                // sItem = null
                overlay.dispatchEvent(new Event('closeOverlay'))
            }
        }
    }
    /**
     * Enables/Disables virtual keypad
     * @memberof_ cxTools.dialog
     * @param  {boolean|null} bEnable true=show keypad false=hide keypad null=do not change
     * @return {boolean}      true=enabled false=disabled
     * @example
     * cxt.keypadEnable(true)        // enable virtual keypad
     * let bVal = cxt.keypadEnable() // bVal=true
     */
    keypadEnable(val = null) {
        if (val !== null) this.bKeypadEnabled = val
        return this.bKeypadEnabled
    }
    /**
     * Checks if a file exits
     * @memberof_ cxTools.commonTools
     * @param {string} sUrl URL of file
     * @returns boolean true=exists false=NOT exits
     */
    existsFile(sUrl) {
        let http = new XMLHttpRequest();
        http.open('HEAD', sUrl, false);
        http.send();
        return http.status != 404;
    }

    /**
     * Returns a unique id created with Date.now() when program is started
     * 
     * Is used to assign a client ID to requests to the PLC, 
     * so that the client can distinguish whether the 
     * response is intended for it based on the ID
     * @memberof_ cxTools.commonTools
     * @returns start ID
     */
    getClientId() {
        // return this.startID
        return CXT_CLIENT_ID
    }
    /**
     * Sets title/tooltip string
     * @memberof_ cxTools.commonTools
     * @param {object}  self   widget parent object
     * @param {string}  sTitle tooltip string to set
     * @param {boolean} bSet   true=set fale=do not set tooltip string
     * @returns null
     */
    setWidgetTitle(self, sTitle, bSet = true) {
        if (bSet) self.element.title = sTitle
    }
    /** 
     * when TOOLTIP_ITEM exists, tooltip feature is enabled
     * return always false, while not correctly implemented
     * @memberof_ cxTools.commonTools
     */
    isTooltipEnabled() {
        // let im = shmi.requires("visuals.session.ItemManager")
        // return im.getItem(TOOLTIP_ITEM) === null ? false : true
        return false
    }

}
const f2s = cxt.float2String
const i2s = cxt.int2String