/**
 * Widget features
 *  - display axis position
 *  - jog kinematic axes
 *  - jog single axes
 *  - set reference of single axes
 * History:
 * 24-04-17 bugfix use correct axis number instead of loop index
 */
(function () {
    'use strict'
    const SWITCH_ARRAY = false
    const iOP_AUTO = 0
    const iOP_MANUAL = 1
    const iOP_SETUP = 2

    // variables for reference in widget definition
    const templatePath = "custom/controls/cx-jog" // "{%= template_path %}"
    const uiType = "cx-jog"    // widget keyword (data-ui) {%= ui_type %}
    const className = uiType   // widget name in camel case {%= constructor_name %}
    const isContainer = false  // true: widgets included false: no widgets included

    // example - default configuration
    const defaultConfig = {
        "class-name": uiType,
        "name": null,
        "template": templatePath,
        "label": uiType,
        "item": null
    };

    // setup module-logger
    const ENABLE_LOGGING = true //enable logging with 'log' function
    const RECORD_LOG = false //store logged messages in logger memory
    const logger = shmi.requires("visuals.tools.logging").createLogger(uiType, ENABLE_LOGGING, RECORD_LOG)
    const fLog = logger.fLog //force log - logs message even if logger is disabled
    const log = logger.log; //log message if logger is enabled

    // declare private functions - START
    // (CUSTOM ADDITION++)
    /**
     * update progress bar
     * @param {real} axPosAct 
     * @param {json} self 
     */
    function setProgressBar(axPosAct, self) {
        const el = self.vars.elements
        let rDelta = 100 * (axPosAct - self.vars.axPosMin) / (self.vars.axPosMax - self.vars.axPosMin)
        rDelta = rDelta.toFixed(1)
        el["divGraphValue"].style.width = rDelta + "%"
    }
    function setDeadmen(self) {
        const el = self.vars.elements
        const vr = self.vars
        if (vr.Status_strFuncs === '') {
            el["divJogDeadmen"].style.display = "none"
            el["divJogCmd"].style.display = "none"
        } else {
            if (vr.iDeadmenSwitch === 0) {
                el["divJogDeadmen"].style.display = ""
                el["divJogCmd"].style.display = "none"
            } else {
                el["divJogDeadmen"].style.display = "none"
                el["divJogCmd"].style.display = ""
            }
        }
    }
    function setValue(value, type, name, self) {
        const cf = self.config
        const vr = self.vars
        const el = self.vars.elements

        // if (name === cf.itemOpMode) {
        if (name === cf.Status_strFuncs) {
            vr.Status_strFuncs = value
            if (value === '') {
                el["imgOpMode"].src = "pics/custom/icons/mode-auto.svg"
                setLabel(el["txtOpMode"], "${cxVisuals.opAuto}")
                el["divSelectCmd"].style.display = "none"
                el["divJogDist"].style.display = "none"
                el["divNonAuto"].style.display = "none"
                setDeadmen(self)
            } else if (value === 'jog') {
                el["imgOpMode"].src = "pics/custom/icons/robot.svg"
                setLabel(el["txtOpMode"], "${cxVisuals.opManual}")
                el["divSelectCmd"].style.display = "none"
                el["divJogDist"].style.display = ""
                el["divNonAuto"].style.display = ""
                setDeadmen(self)
            } else if (value === 'jog+ref') {
                el["imgOpMode"].src = "pics/custom/icons/accelerometer.svg"
                setLabel(el["txtOpMode"], "${cxVisuals.opSetup}")
                el["divSelectCmd"].style.display = ""
                el["divJogDist"].style.display = ""
                el["divNonAuto"].style.display = ""
                setDeadmen(self)
            }
        } else if (name === cf.lrJogStepWidth) {
            [0, 1, 10, 100].forEach(iId => {
                let sId = "btnJog" + iId
                addClass(el[sId], (value === iId))
            });
        } else if (name === cf.bPowerOn) {
            addClass(el["txtAhAf"], !(value === 0))
            addClass(el["btnCmdJogRel"], !(value === 0))
            // addClass(el["btnCmdJogAbs"], !(value === 0))
            addClass(el["btnCmdSetRef"], (value === 0))
            if (value === 0) {
                el["divRef"].style.display = ""
                el["divJogCmd"].style.display = "none"
                el["divJogDist"].style.display = "none"
            } else {
                el["divRef"].style.display = "none"
                el["divJogCmd"].style.display = ""
                el["divJogDist"].style.display = ""
            }
        } else if (name === cf.strGroupName) {
            setLabel(el["btnGrpName"], value + " ☰")
        } else if (name === cf.bError) {
            addClass(el["txtError"], value === 1)
        } else if (name === cf.bInRef) {
            addClass(el["txtInRef"], value === 1)
        } else if (name === cf.bModulo) {
            addClass(el["txtModulo"], value === 1)

        } else if (name === cf.strUnitPos) {
            setLabel(el["txtPosUnit"], value)
        } else if (name === cf.strUnitVel) {
            setLabel(el["txtVelUnit"], value)
        } else if (name === cf.uiSelectAxis) {
            for (let i = 0; i < 16; i++) {
                addClass(el["axName" + i], false)
            }
            addClass(el["axName" + value], true)
        } else if (name === cf.lrVel) {
            setLabel(el["txtVelVal"], value.toFixed(cf.precisionVel))
        } else if (name.startsWith(cf.lrPosArray)) {
            let sId = name.replace(cf.lrPosArray, "").split(".")[0]
            setLabel(el["axVal" + sId], value.toFixed(cf.precisionPos))
        } else if (name === cf.AxesDef) {
            const jAxDef = JSON.parse(value)
            // hide all axes
            for (let i = 0; i < 16; i++) {
                const divAxis = shmi.getUiElement("divAxis" + i, self.element)
                divAxis.style.display = "none"
            }
            // display existing axes
            for (let i = 0; i < jAxDef.length; i++) {
                let id = jAxDef[i].id 
                const divAxis = shmi.getUiElement("divAxis" + id, self.element)
                divAxis.style.display = ""
                let myButton = shmi.getUiElement("axName" + id, self.element)
                let myUnit = shmi.getUiElement("axUnit" + id, self.element)
                setLabel(myButton, jAxDef[i].name)
                setLabel(myUnit, jAxDef[i].unit)
            }
        } else if (name === cf.bLinear) {
            let sLabel = shmi.localize(value ? "${cxVisuals.AxLinear}" : "${cxVisuals.AxRotatory}")
            setLabel(el["txtAxType"], sLabel)
            let myImg = value ? cxt.cfgMsgBox.imgAxLinear : cxt.cfgMsgBox.imgAxRotary
            el["imgAxType"].setAttribute("src", cxt.cssGetVar("", myImg, true))
        } else if (name === cf.lrLimitMin) {
            setLabel(el["txtAxMin"], value.toFixed(cf.precisionPos))
            self.vars.axPosMin = value
            setProgressBar(self.vars.axPosAct, self)
        } else if (name === cf.lrLimitMax) {
            setLabel(el["txtAxMax"], value.toFixed(cf.precisionPos))
            self.vars.axPosMax = value
            setProgressBar(self.vars.axPosAct, self)
        } else if (name === cf.lrPos) {
            setLabel(el["txtPosVal"], value.toFixed(cf.precisionPos))
            self.vars.axPosAct = value
            setProgressBar(value, self)
        } else if (name === cf.itemDeadmenSwitch) {
            self.vars.iDeadmenSwitch = value
            setDeadmen(self, true)
        }
        if (SWITCH_ARRAY) {
            ;
        } else {
            if (name.startsWith(cf.SwitchName)) {
                let sId = name.replace(cf.SwitchName, '')
                setLabel(el["btnSwitch" + sId], value)
                if (value === "") el["btnSwitch" + sId].style.display = "none"
                else el["btnSwitch" + sId].style.display = ""
            } else if (name.startsWith(cf.bSwitch)) {
                let sId = name.replace(cf.bSwitch, '')
                addClass(el["btnSwitch" + sId], value === 1)
            }
        }
    }
    function setCtrlLabels(self) {
        const el = self.vars.elements
        setLabel(el["txtError"], "${cxVisuals.Error}");
        setLabel(el["txtInRef"], "${cxVisuals.InRef}");
        setLabel(el["txtAhAf"], "${cxVisuals.AhAf}");
        setLabel(el["txtModulo"], "${cxVisuals.Modulo}");
        setLabel(el["txtVelLabel"], "${cxVisuals.velocity}");
        setLabel(el["txtPosLabel"], "${cxVisuals.position}");

        setLabel(el["btnCmdJogRel"], "${cxVisuals.jogRel}");
        setLabel(el["btnCmdJogAbs"], "${cxVisuals.jogAbs}");
        setLabel(el["btnCmdSetRef"], "${cxVisuals.reference}");
        setLabel(el["btnJogMinus"], "${cxVisuals.jogMinus}");
        setLabel(el["btnJogStop"], "${cxVisuals.jogStop}");
        setLabel(el["btnJogPlus"], "${cxVisuals.jogPlus}");
        setLabel(el["btnJog0"], "${cxVisuals.jogCont}");
        setLabel(el["btnSetRef"], "${cxVisuals.setRef}");
    }
    /**
     * store item names in widget for later usage
     * @param {*} self 
     * @returns 
     */
    function setItemNames(self) {
        const cf = self.config
        if (cf.itemStruct === null) return
        // define config item names
        if (!cf.itemStruct.endsWith('.')) cf.itemStruct += '.'
        cf.bPowerOn = cf.itemStruct + "Ctrl_bPowerOn"
        cf.lrJogStepWidth = cf.itemStruct + "Ctrl_lrSetupModeStepWidth"
        cf.bJogMinus = cf.itemStruct + "Ctrl_bSetupModeJogMinus"
        cf.bJogPlus = cf.itemStruct + "Ctrl_bSetupModeJogPlus"
        cf.bJogStop = cf.itemStruct + "Ctrl_bSetupModeJogStop"
        cf.bSetRef = cf.itemStruct + "Ctrl_bSetReference"
        cf.lrAbsMeasure = cf.itemStruct + "Ctrl_lrAbsoluteMeasure"

        cf.strGroupName = cf.itemStruct + "strGroupName"

        cf.bError = cf.itemStruct + "Status_bDiagError"
        cf.bInRef = cf.itemStruct + "Status_bReferenced"
        cf.bModulo = cf.itemStruct + "Status_bModulo"
        cf.bLinear = cf.itemStruct + "Status_bLinear"
        cf.lrLimitMin = cf.itemStruct + "Status_lrLimitMin"
        cf.lrLimitMax = cf.itemStruct + "Status_lrLimitMax"
        cf.Status_strFuncs = cf.itemStruct + "Status_strFuncs"

        cf.strUnitPos = cf.itemStruct + "Status_strUnitsPositionAndLength"
        cf.strUnitVel = cf.itemStruct + "Status_strUnitsVelocity"
        cf.lrPos = cf.itemStruct + "Status_lrActualPosition"
        cf.lrVel = cf.itemStruct + "Status_lrActualVelocity"
        cf.AxesDef = cf.itemStruct + "strJsonAxesDef"
        cf.uiSelectAxis = cf.itemStruct + "uiSelectAxis"
        cf.strCmd = cf.itemStruct + "strCmd"
        cf.lrPosArray = cf.itemStruct + "Status_lrActPos."

        if (SWITCH_ARRAY) {
            cf.structSwitch = `${cf.itemStruct}Switch.`
            cf.bSwitch = ".bValue"
            cf.SwitchName = ".Name"
        } else {
            cf.bSwitch = cf.itemStruct + "bSwitch"
            cf.SwitchName = cf.itemStruct + "SwitchName"
        }


        // cf.x = cf.itemStruct + "Status_strDiagMessage"
        // cf.x = cf.itemStruct + "Status_dwDiagNumberMain"
        // cf.x = cf.itemStruct + "Status_dwDiagNumberDetail"
        // cf.x = cf.itemStruct + "Status_strPLCopenState"
        // cf.x = cf.itemStruct + "Status_strAxisName"
        // cf.x = cf.itemStruct + "Status_lrActPosPercent"

        cf.iGrp = cf.itemStruct + "uiGroup"
    }
    /**
     * Store dom references in widget for later usage
     * @param {*} self 
     */
    function getDomRefs(self) {
        const el = self.vars.elements
        const arUiElems = [
            "btnGrpName", "btnGrpPrev", "btnGrpNext",
            "imgOpMode", "txtOpMode",
            "txtError", "txtInRef", "txtAhAf", "txtModulo", "txtVelLabel", "txtPosLabel",
            "txtVelVal", "txtVelUnit", "txtPosVal", "txtPosUnit",
            "divSelectCmd", "btnCmdJogRel", "btnCmdJogAbs", "btnCmdSetRef", "divPosGraph",
            "divNonAuto",
            "divJogDeadmen", "divJogCmd", "btnJogMinus", "btnJogStop", "btnJogPlus",
            "divJogDist", "txtJogVal", "btnJog0", "btnJog1", "btnJog10", "btnJog100",
            "divRef", "refVal", "btnSetRef", "divAxisList",
            "btnSwitch0", "btnSwitch1", "btnSwitch2",
            "txtAxMin", "txtAxType", "imgAxType", "txtAxMax", "divGraphValue",

            "axName0", "axName1", "axName2", "axName3", "axName4", "axName5", "axName6", "axName7",
            "axName8", "axName9", "axName10", "axName11", "axName12", "axName13", "axName14", "axName15",

            "axVal0", "axVal1", "axVal2", "axVal3", "axVal4", "axVal5", "axVal6", "axVal7",
            "axVal8", "axVal9", "axVal10", "axVal11", "axVal12", "axVal13", "axVal14", "axVal15"
        ]
        // store reference to multiple used elements
        arUiElems.forEach(sUiElem => {
            el[sUiElem] = shmi.getUiElement(sUiElem, self.element)
        });
        el["divAxisList"] = shmi.getUiElement("divAxisList", self.element)
        // show info, when deadman switch is missing
        setLabel(el["divJogDeadmen"], "${cxVisuals.DeadmenSwitchMissing}")
    }
    // add dynamic created widgets
    function addWidgets(self) {
        const el = self.vars.elements
        const cf = self.config
        if (cf.itemStruct === null) return

        let cfTmp = {
            "class-name": "cx-input",
            "template": "custom/controls/cx-input",
            "name": "cx-input-jog-Dist",
            "myLabel": "",
            "item": "",
            "anyMin": "",
            "anyMax": "",
            "anyDigits": "1",
            "formatInt": 10,
            "stepMode": "",
            "title": "",
            "unit": ""
        }
        let cfgJogIn = shmi.cloneObject(cfTmp)
        cfgJogIn.item = cf.lrJogStepWidth
        cfgJogIn.anyMin = 0
        cfgJogIn.anyMax = 1000
        el.txtJogVal = shmi.createControl("cx-input", el["divJogDist"], cfgJogIn, "DIV");
        el.txtJogVal.element.style.height = "110%"
        el.txtJogVal.element.style.width = "60%"

        let cfgRefIn = shmi.cloneObject(cfTmp)
        cfgRefIn.item = cf.lrAbsMeasure
        cfgRefIn.anyMin = -9000
        cfgRefIn.anyMax = 9000
        el.txtAbsMeasureVal = shmi.createControl("cx-input", el["divRef"], cfgRefIn, "DIV");
        el.txtAbsMeasureVal.element.style.height = "110%"
        el.txtAbsMeasureVal.element.style.width = "50%"
    }
    function addClass(el, bAdd, strClass = "btnActive") {
        if (bAdd)
            el.classList.add(strClass)
        else
            el.classList.remove(strClass)
    }

    function enableListeners(self) {
        self.vars.listeners.forEach((l) => {
            l.enable();
        });
    }

    function disableListeners(self) {
        self.vars.listeners.forEach((l) => {
            l.disable();
        });
    }
    // set element label
    function setLabel(el, sLabel) {
        if (el) el.innerText = shmi.localize(sLabel)
    }

    // (/CUSTOM ADDITION--)
    // declare private functions - END

    // definition of new widget extending BaseControl - START
    const definition = {
        className: className,
        uiType: uiType,
        isContainer: isContainer,
        // default configuration settings - all available options have to be initialized!
        config: defaultConfig,
        // instance variables
        vars: {
            // (CUSTOM ADDITION++)
            // references to widget elements (div, input, image, ...)
            elements: {},
            //reference for PLC item subscription token - will be set when widget is enabled
            subscribe: {},
            axPosMin: 0,
            axPosAct: 0,
            axPosMax: 10,
            iDeadmenSwitch: 0,

            listeners: [], //event listeners
            subscribes: [] // subscribed items 
            // (/CUSTOM ADDITION--)
        },
        // imports added at runtime
        imports: {
            // example - add import via shmi.requires(...)
            im: "visuals.session.ItemManager",
            // (CUSTOM ADDITION++)
            io: "visuals.io"
            // (/CUSTOM ADDITION--)
        },

        // array of custom event types fired by this widget
        events: [],

        // functions to extend or override the BaseControl prototype
        prototypeExtensions: {
            // called when config-file (optional) is loaded and template (optional) is inserted into base element
            onInit: function () {
                // (CUSTOM ADDITION++)
                log("onInit")
                const self = this
                const el = self.vars.elements
                const cf = self.config
                const vr = self.vars
                // disable context menu
                self.element.addEventListener('contextmenu', (e) => e.preventDefault(), false)

                // const WriteOpt = { skipSameValueCheck: true }
                const btnTap = {
                    onPress: async function (x, y, event) {
                        const btn = event.currentTarget
                        // btn.classList.add("btnActive")
                        addClass(btn, true)
                        const sDataUi = btn.getAttribute("data-ui")
                        log(sDataUi + " Press")
                        if (sDataUi === "btnGrpPrev") {
                            cxt.setItem(cf.strCmd, "set -", true)
                        } else if (sDataUi === "btnGrpNext") {
                            cxt.setItem(cf.strCmd, "set +", true)
                        } else if (sDataUi === "btnGrpName") {
                            let sOpt = await cxt.getItem(cf.itemStruct + "strJsonGroups")
                            let iGrp = await cxt.getItem(cf.itemStruct + "uiSelectGroup")
                            let sRes = await cxt.msgBox("select", "", "", sOpt, ":", "=", iGrp)
                            if (sRes != null) cxt.setItem(cf.strCmd, "set " + sRes, true)
                        } else if (sDataUi === "btnJogMinus") {
                            cxt.setItem(cf.bJogMinus, 1)
                        } else if (sDataUi === "btnJogStop") {
                            cxt.setItem(cf.bJogStop, 1)
                        } else if (sDataUi === "btnJogPlus") {
                            cxt.setItem(cf.bJogPlus, 1)
                        } else if (sDataUi === "btnSetRef") {
                            cxt.setItem(cf.bSetRef, 1)
                        }

                    },
                    onRelease: async function (x, y, event) {
                        const btn = event.currentTarget
                        // btn.classList.remove("btnActive")
                        addClass(btn, false)
                        const sDataUi = btn.getAttribute("data-ui")
                        log(sDataUi + " Release")
                        cxt.setItem(cf.strCmd, "")
                        if (sDataUi === "btnJogMinus") {
                            cxt.setItem(cf.bJogMinus, 0)
                        } else if (sDataUi === "btnJogStop") {
                            cxt.setItem(cf.bJogStop, 0)
                        } else if (sDataUi === "btnJogPlus") {
                            cxt.setItem(cf.bJogPlus, 0)
                        } else if (sDataUi === "btnSetRef") {
                            cxt.setItem(cf.bSetRef, 0)
                        }
                    }
                }

                const btnSelect = {
                    onPress: async function (x, y, event) {
                        const btn = event.currentTarget
                        //const cf = self.config
                        const sDataUi = btn.getAttribute("data-ui")
                        const BTN_SWITCH = "btnSwitch"
                        if (sDataUi === "btnJog0") {
                            cxt.setItem(cf.lrJogStepWidth, 0)
                        } else if (sDataUi === "btnJog1") {
                            cxt.setItem(cf.lrJogStepWidth, 1)
                        } else if (sDataUi === "btnJog10") {
                            cxt.setItem(cf.lrJogStepWidth, 10)
                        } else if (sDataUi === "btnJog100") {
                            cxt.setItem(cf.lrJogStepWidth, 100)
                        } else if (sDataUi === "btnCmdJogRel") {
                            cxt.setItem(cf.bPowerOn, 1)
                        } else if (sDataUi === "btnCmdJogAbs") {
                            cxt.setItem(cf.bPowerOn, 1)
                        } else if (sDataUi === "btnCmdSetRef") {
                            cxt.setItem(cf.bPowerOn, 0)
                        } else if (sDataUi.startsWith("axName")) {
                            let iId = parseInt(sDataUi.replace("axName", ""))
                            cxt.setItem(cf.uiSelectAxis, iId)
                        } else if (sDataUi.startsWith(BTN_SWITCH)) {
                            if (vr.Status_strFuncs === '') return
                            let sId = sDataUi.replace(BTN_SWITCH, '')
                            if (SWITCH_ARRAY) {
                                ;
                            } else {
                                let bVal = cxt.getItem(cf.bSwitch + sId)
                                cxt.setItem(cf.bSwitch + sId, bVal ? 0 : 1)
                            }
                        }
                    }
                }
                vr.Status_strFuncs = ''
                // abort when not all parameters are provided

                getDomRefs(self)     // Store references to the DOM elements for performance reasons
                setItemNames(self)
                setCtrlLabels(self)
                addWidgets(self)
                el["btnCmdJogAbs"].style.display = "none"
                //get reference to Mouse- & TouchListener constructors
                const arListeners = [self.imports.io.MouseListener, self.imports.io.TouchListener]
                //create listeners
                if (cf.itemStruct === null) return
                for (let i = 0; i < arListeners.length; i++) {
                    self.vars.listeners.push(
                        new arListeners[i](el["btnGrpPrev"], btnTap),
                        new arListeners[i](el["btnGrpNext"], btnTap),
                        new arListeners[i](el["btnCmdJogRel"], btnSelect),
                        new arListeners[i](el["btnCmdJogAbs"], btnSelect),
                        new arListeners[i](el["btnCmdSetRef"], btnSelect),

                        new arListeners[i](el["btnJogMinus"], btnTap),
                        new arListeners[i](el["btnJogStop"], btnTap),
                        new arListeners[i](el["btnJogPlus"], btnTap),

                        new arListeners[i](el["btnJog0"], btnSelect),
                        new arListeners[i](el["btnJog1"], btnSelect),
                        new arListeners[i](el["btnJog10"], btnSelect),
                        new arListeners[i](el["btnJog100"], btnSelect),

                        new arListeners[i](el["btnSetRef"], btnTap),
                        new arListeners[i](el["btnGrpName"], btnTap),

                        new arListeners[i](el["btnSwitch0"], btnSelect),
                        new arListeners[i](el["btnSwitch1"], btnSelect),
                        new arListeners[i](el["btnSwitch2"], btnSelect),
                    );
                    // listeners for axes
                    for (let i = 0; i < 2; i++) {
                        for (let j = 0; j < 16; j++)
                            self.vars.listeners.push(
                                new arListeners[i](el["axName" + j], btnSelect)
                            )
                    }
                }
                // (CUSTOM ADDITION--)
            },
            // called when widget is enabled
            onEnable: function () {
                // (CUSTOM ADDITION++)
                log("onEnable")
                const self = this
                const cf = self.config
                const { im } = self.imports;
                if (cf.itemStruct === null) return
                // if ((cf.itemStruct === null) || (cf.itemOpMode===null)) return

                enableListeners(self);
                cf.precisionVel = parseInt(cf.precisionVel)
                cf.precisionPos = parseInt(cf.precisionPos)

                // Subscribe to item updates
                const myAry = [cf.lrJogStepWidth, cf.bPowerOn, /* cf.itemOpMode, */ cf.strGroupName,
                cf.bError, cf.bInRef, cf.bModulo,
                cf.strUnitPos, cf.strUnitVel, cf.lrPos, cf.lrVel, cf.AxesDef,
                cf.uiSelectAxis, cf.Status_strFuncs,
                cf.lrLimitMin, cf.lrLimitMax, cf.bLinear, cf.itemDeadmenSwitch]
                myAry.forEach(item => {
                    if ((item !== null) && (item !== undefined))
                        self.vars.subscribes.push(im.subscribeItem(item, self))
                });
                for (let i = 0; i < 3; i++) {
                    if (SWITCH_ARRAY) {
                        ;
                    } else {
                        self.vars.subscribes.push(im.subscribeItem(cf.bSwitch + i, self))
                        self.vars.subscribes.push(im.subscribeItem(cf.SwitchName + i, self))
                    }
                }
                // subscribe all kin axes positions
                for (let i = 0; i < 16; i++) {
                    self.vars.subscribes.push(im.subscribeItem(cf.lrPosArray + i, self))
                }

                // (/CUSTOM ADDITION--)
            },
            // called when widget is disabled
            onDisable: function () {
                // (CUSTOM ADDITION++)
                log("onDisable")
                // if ((cf.itemStruct === null) || (cf.itemOpMode===null)) return

                const self = this;
                disableListeners(self);
                // Stop listening to item, i.e. unsubscribe from item updates
                self.vars.subscribes.forEach((s) => {
                    s.unlisten();
                })
                self.vars.subscribes = []
                // (/CUSTOM ADDITION--)
            },
            // called when widget is locked - disable mouse- and touch-listeners
            onLock: function () {
                // (CUSTOM ADDITION++)
                log("onLock")
                const self = this;
                disableListeners(self);
                // (/CUSTOM ADDITION--)
            },
            // called when widget is unlocked - enable mouse- and touch-listeners
            onUnlock: function () {
                // (CUSTOM ADDITION++)
                log("onUnlock")
                const self = this;
                enableListeners(self);
                // (/CUSTOM ADDITION--)
            },
            // called by ItemManager when value of subscribed item changes and once on initial subscription
            onSetValue: function (value, type, name) {
                // (CUSTOM ADDITION++)
                log("onSetValue: " + name + "=" + value)
                if (type === null)  // when type===null do nothing, because params are invalid
                    return
                setValue(value, type, name, this)
                // (/CUSTOM ADDITION--)
            },
            // called by ItemManager to provide properties (min & max values etc.) of subscribed item
            onSetProperties: function (min, max, step, name, type, warnMin, warnMax, prewarnMin, prewarnMax, digits) {
                // (CUSTOM ADDITION++)
                log("onSetProperties" + `name:${name} type:${type} min:${min} max:${max}`)
                if (type === null)  // when type===null do nothing, because params are invalid
                    return

                const self = this;
                // (/CUSTOM ADDITION--)
            },
            // called when widget is deleted - used for instance clean-up
            onDelete: function () {
                log("onDelete")
                // const self = this;
                // const el = self.vars.elements
                // const arCtrl = [el.txtJogVal, el.txtAbsMeasureVal]
                // arCtrl.forEach(element => {
                //     if (element) shmi.deleteControl(element)
                // });
            }
        }
    };

    // definition of new widget extending BaseControl - END

    // generate widget constructor & prototype using the control-generator tool
    shmi.requires("visuals.tools.control-generator").generate(definition);
})();
