/**
 * WebIQ Visuals widget template.
 *
 * Configuration options (default):
 *
 * {
 *     "class-name": "cx-inputX", // {%= ui_type %}
 *     "name": null,
 *     "template": "custom/controls/cx-inputX" // {%= template_path %}
 * }
 *
 * Explanation of configuration options:
 *
 * class-name {string}: Sets default CSS class applied on widget root element
 * name {string}: Name of widget set to data-name attribute
 * template {string}: Path to template file
 *
 * @version 1.2 changed by boschrexroth
 */
/*
- bugfix toggle editors
*/
(function () {
    'use strict';
    // variables for reference in widget definition
    const templatePath = "custom/controls/cx-inputX" // "{%= template_path %}"
    const uiType = "cx-inputX"    // widget keyword (data-ui) {%= ui_type %}
    const className = uiType           // widget name in camel case {%= constructor_name %}
    const isContainer = false
    const jScrollOpt = { block: "center" }
    const COL_DATA = 1

    // example - default configuration
    const defaultConfig = {
        "class-name": uiType,
        "name": null,
        "template": templatePath,
        "label": uiType,
        "item": null
    };

    // setup module-logger
    const ENABLE_LOGGING = false //enable logging with 'log' function
    const RECORD_LOG = false //store logged messages in logger memory
    const logger = shmi.requires("visuals.tools.logging").createLogger(uiType, ENABLE_LOGGING, RECORD_LOG)
    const fLog = logger.fLog //force log - logs message even if logger is disabled
    const log = logger.log; //log message if logger is enabled
    const bForceTitle = true

    const FIRST_ROW = 1

    // declare private functions - START
    // (CUSTOM ADDITION++)
    async function updateTable(self) {
        const el = self.vars.elements
        const cf = self.config
        let sValue = await cxt.getItem(cf.item, true)
        // if (cf.isUtf8) sValue = cxt.utf8_2_utf16(sValue)
        if (cf.isUtf8) sValue = shmi.from_utf8(sValue)
        el.txtArea.value = sValue
        text2table(self)
        selectRow(self, 0)
    }
    function hideElements(self, bHide) {
        const el = self.vars.elements
        if (el.btnAdd) hideElement(el.btnAdd.element, bHide)
        if (el.btnDel) hideElement(el.btnDel.element, bHide)
        if (el.btnMvUp) hideElement(el.btnMvUp.element, bHide)
        if (el.btnMvDn) hideElement(el.btnMvDn.element, bHide)
        if (el.btnCopy) hideElement(el.btnCopy.element, bHide)
        if (el.btnPaste) hideElement(el.btnPaste.element, bHide)
    }
    /**
     * toggle between table rows & textarea
     * @param {dom}  self     widget dom element
     * @param {json} itemCtrl item name of editor flag
     */
    function toggleEditor(self) {
        const el = self.vars.elements
        const vr = self.vars
        hideElements(self, (vr.iTouchEdit === 0))
        if (vr.iTouchEdit === 1) {
            el.txtArea.style.display = "none"
            text2table(self)
        } else {
            el.txtArea.style.display = ""
            table2text(self)
        }
    }
    /**
     * enable/disable all listeners stored in listenrs[]
     * @param {Dom} self reference to widget element
     */
    async function enableListeners(self, bEnable = true) {
        const vr = self.vars
        const cf = self.config
        const el = self.vars.elements
        // enable/disable listeners show/hide frame with buttons
        if (bEnable) {
            self.vars.listeners.forEach((l) => { l.enable(); });
            el.cxInputXBtns.style.display = ""
            el.imgLock.style.display = "none"
        } else {
            self.vars.listeners.forEach((l) => { l.disable(); });
            el.cxInputXBtns.style.display = "none"
            el.imgLock.style.display = "block"
        }
        vr.bLocked = !bEnable
        if (vr.bLocked) {
            hideElements(self, true)
        } else {
            hideElements(self, (vr.iTouchEdit === 0))
        }
        el.txtArea.readOnly = vr.bLocked
    }
    function hideElement(myElement, bHide) {
        if (myElement)
            myElement.style.display = bHide ? "none" : ""
        myElement.style.width = "70px"
        myElement.style.marginLeft = "10px"
    }
    /**
     * creates table with gcode program for touch editing
     * @param {string} sText text with gcode program
     */
    function text2table(self) {
        const vr = self.vars
        const el = self.vars.elements
        const cf = self.config

        if (el.table) el.table.remove()
        // create table
        let sText = el.txtArea.value
        el.table = cxt.addChild(null, "table", "cxInputXTable")
        let arRows = sText.split("\n")
        for (let iRow = 0; iRow < arRows.length; iRow++) {
            tableAddRow(self, arRows[iRow], iRow + 1)
        }
        el.cxInputXInput.classList.add("overflowScroll")
        el.cxInputXInput.appendChild(el.table)
        el.txtArea.value = ""
        selectRow(self, vr.iRowSelected)
    }
    function table2text(self, bRemoveTable = true) {
        const el = self.vars.elements
        const cf = self.config
        if (!el.table) return
        let sData = ""
        let sNL = ""
        for (let i = 0; i < el.table.rows.length; i++) {
            sData += sNL + el.table.rows[i].cells[COL_DATA].innerText
            sNL = "\n"
        }
        el.cxInputXInput.classList.remove("overflowScroll")
        el.txtArea.value = sData
        // if (cf.isUtf8) sData = cxt.utf16_2_utf8(sData)
        if (cf.isUtf8) sData = shmi.to_utf8(sData)
        cxt.setItem(cf.item, sData)
        if (bRemoveTable) el.table.remove()
    }
    /**
     * set table row numbers
     * @param {dom} self 
     */
    function setRowNumber(self) {
        const el = self.vars.elements
        if (el.table) {
            for (let iRow = 0; iRow < el.table.rows.length; iRow++) {
                el.table.rows[iRow].cells[0].innerText = "" + (iRow + FIRST_ROW)
            }
        }
    }
    /**
     * subscribe item if defined & stores it in an array
     * @param {object} self  reference to WebIQ widget
     * @param {string} sItem name of item
     */
    function subscribeIfExists(self, sItem) {
        const { im } = self.imports;
        if (sItem)
            self.vars.subscribes.push(im.subscribeItem(sItem, self))
    }
    /**
     * adds a table row
     * @param  {dom}    oTable table dom element
     * @param  {string} sText  text of cell
     * @return {dom}    created table row
     */
    function tableAddRow(self, sText, iRow) {
        const el = self.vars.elements
        const vr = self.vars
        let tr = cxt.addChild(el.table, "tr")
        tr.onclick = async (e) => {
            if (vr.bLocked) return

            if (vr.iRowSelected !== e.currentTarget.rowIndex) {
                selectRow(self, e.currentTarget.rowIndex)

            } else {
                let bBak = cxt.keypadEnable()
                cxt.keypadEnable(true)
                await cxt.keypad(e.currentTarget.cells[COL_DATA], "innerText")
                cxt.keypadEnable(bBak)
                table2text(self, false)
            }
        }
        cxt.addChild(tr, "td", "", iRow)
        cxt.addChild(tr, "td", "", sText)
        return tr
    }
    function selectRow(self, iRow) {
        const vr = self.vars
        const el = self.vars.elements
        const cf = self.config

        if (cf.itemLine) cxt.setItem(cf.itemLine, iRow)
        if (el.table.rows[vr.iRowSelected]) {
            el.table.rows[vr.iRowSelected].style.backgroundColor = ""
        }
        if (el.table.rows[iRow]) {
            el.table.rows[iRow].style.backgroundColor = "skyblue"
            vr.iRowSelected = iRow
            el.table.rows[iRow].scrollIntoView(jScrollOpt)
        }
    }
    // (/CUSTOM ADDITION--)
    // declare private functions - END

    // definition of new widget extending BaseControl - START
    const definition = {
        className: className,
        uiType: uiType,
        isContainer: isContainer,
        // default configuration settings - all available options have to be initialized!
        config: defaultConfig,
        // instance variables
        vars: {
            // (CUSTOM ADDITION++)
            elements: {
                //references for DOM elements accessed with JS code
                label: null,   //element to display label text
                txtArea: null, // textarea element
                btnAdd: null, btnDel: null, btnMvUp: null, btnMvDn: null, btnCopy: null, btnPaste: null
            },
            item: null,      //reference for PLC item subscription token - will be set when widget is enabled
            listeners: [],   //event listeners
            subscribes: []   //subscribed items
            // (/CUSTOM ADDITION--)
        },
        // imports added at runtime
        imports: {
            // example - add import via shmi.requires(...)
            im: "visuals.session.ItemManager",
            // (CUSTOM ADDITION++)
            io: "visuals.io"
            // (/CUSTOM ADDITION--)
        },

        // array of custom event types fired by this widget
        events: [],

        // functions to extend or override the BaseControl prototype
        prototypeExtensions: {
            // called when config-file (optional) is loaded and template (optional) is inserted into base element
            onInit: async function () {
                // (CUSTOM ADDITION++)
                log("onInit")
                const self = this
                const vr = self.vars
                const el = vr.elements
                const cf = self.config
                // disable context menu
                self.element.addEventListener('contextmenu', (e) => e.preventDefault(), false)

                vr.iRowSelected = -1 // <0: nothing selected
                vr.iTouchEdit = 1
                vr.Copy = "***"

                el.imgLock = shmi.getUiElement("cxLock", self.element);
                el.imgLock.src = cxt.cfgMsgBox.imgLock
                // {
                //     "ui": "cx-button",
                //     "class-name": "cx-button",
                //     "name": "cx-button-toggle",
                //     "template": "custom/controls/cx-button",
                //     "label": "cx-button",
                //     "item": null,
                //     "btnType": "toggle",
                //     "labelOn": " toggle",
                //     "imgPosition": "hide",
                //     "valueOn": 1,
                //     "valueOff": 0,
                //     "intervalWhilePressed": 500,
                //     "auto-label": null,
                //     "actionDn": [],
                //     "itemCtrl": "SInt"
                //   }
                let cfgBtn = {
                    "ui": "cx-button",
                    "class-name": "cx-button",
                    "name": "cx-button",
                    "template": "custom/controls/cx-button",
                    "label": null,
                    "btnType": null,
                    "labelOn": null,
                    "imgPosition": "hide",
                }

                // Store references to the DOM elements for performance reasons
                el.cxInputXBtns = shmi.getUiElement("cxInputXBtns", self.element)
                el.cxInputXInput = shmi.getUiElement("cxInputXInput", self.element)
                el.label = shmi.getUiElement("cxInputXLabel", self.element)
                el.txtArea = shmi.getUiElement("cxInputXtxtArea", self.element)
                el.txtArea.onchange = (e) => {
                    console.log("txtArea content changed")
                    let sData = el.txtArea.value
                    if (cf.isUtf8) sData = shmi.to_utf8(sData)
                    cxt.setItem(cf.item, sData)
                }

                if (cf.itemToggleEditor) { // toggle textarea / table
                    let cfg = shmi.cloneObject(cfgBtn)
                    cfg.name = cfg.label = "cx-btn-set-editor"
                    cfg.itemCtrl = cf.itemToggleEditor
                    cfg.imgPosition = "top"
                    cfg.imgUrlOn = "pics/custom/controls/cx-inputX/touch.svg"
                    cfg.imgUrlOff = "pics/custom/controls/cx-inputX/keyboard.svg"
                    cfg.valueOn = 1
                    cfg.valueOff = 0
                    cfg.btnType = "toggle"
                    cfg.actionUp = async () => {
                        if (vr.iTouchEdit === 0) {
                            vr.iTouchEdit = 1
                            await cxt.setItem(cf.itemToggleEditor, 1)
                        } else {
                            vr.iTouchEdit = 0
                            await cxt.setItem(cf.itemToggleEditor, 0)
                        }
                        toggleEditor(self)
                    }

                    el.btnToggle = shmi.createControl("cx-button", el.cxInputXBtns, cfg, "DIV")
                    el.btnToggle.element.style.width = "70px"
                    el.btnToggle.element.style.marginLeft = "20px"
                }

                if (cf.btnAdd) {
                    let cfg = shmi.cloneObject(cfgBtn)
                    cfg.name = cfg.label = "cx-btn-add"
                    cfg.imgPosition = "top"
                    cfg.imgUrlOn = "pics/custom/controls/cx-inputX/table-row-add-below.svg"
                    cfg.btnType = "on-off"
                    cfg.actionUp = async () => {
                        let tr = tableAddRow(self, "")
                        let iRowNew = vr.iRowSelected + 1
                        if (vr.iRowSelected === 0) {
                            let sRes = await cxt.msgBox("confirm", "Insert Before (OK) After(Cancel)")
                            if (sRes !== null) iRowNew--
                            // let sRes = await cxt.msgBox("select", "Insert", "", "before=1|after=2", "|", "=")
                            // if (sRes === "2")
                            //     ;
                            // else if (sRes === "1")
                            //     iRowNew--
                            // else
                            //     return
                        }
                        el.table.insertBefore(tr, el.table.rows[iRowNew])
                        setRowNumber(self)
                        selectRow(self, iRowNew)
                        table2text(self, false)
                    }

                    el.btnAdd = shmi.createControl("cx-button", el.cxInputXBtns, cfg, "DIV");
                }
                if (cf.btnDel) {
                    let cfg = shmi.cloneObject(cfgBtn)
                    cfg.name = cfg.label = "cx-btn-del"
                    cfg.imgPosition = "top"
                    cfg.imgUrlOn = "pics/custom/controls/cx-inputX/table-row-delete.svg"
                    el.btnDel = shmi.createControl("cx-button", el.cxInputXBtns, cfg, "DIV");
                    cfg.actionUp = async () => {
                        let res = await cxt.msgBox("confirm", "Delete?")
                        if (res) {
                            if (el.table.rows.length === 1) {
                                el.table.rows[0].cells[COL_DATA].innerText = ""
                                return
                            } else {
                                el.table.rows[vr.iRowSelected].remove()
                                setRowNumber(self)
                                vr.iRowSelected = (vr.iRowSelected > 0) ? vr.iRowSelected - 1 : 0
                                selectRow(self, vr.iRowSelected)
                                table2text(self, false)
                            }
                        }
                    }
                }

                if (cf.btnMvUp) {
                    let cfg = shmi.cloneObject(cfgBtn)
                    cfg.name = cfg.label = "cx-btn-mvUp"
                    cfg.imgPosition = "top"
                    cfg.imgUrlOn = "pics/custom/controls/cx-inputX/table-row-mv-up.svg"

                    el.btnMvUp = shmi.createControl("cx-button", el.cxInputXBtns, cfg, "DIV");
                    cfg.actionUp = () => {
                        if (vr.iRowSelected > 0) {
                            let iRowNew = vr.iRowSelected - 1
                            let sTmp = el.table.rows[iRowNew].cells[COL_DATA].innerText
                            el.table.rows[iRowNew].cells[COL_DATA].innerText = el.table.rows[vr.iRowSelected].cells[COL_DATA].innerText
                            el.table.rows[vr.iRowSelected].cells[COL_DATA].innerText = sTmp
                            selectRow(self, iRowNew)
                            table2text(self, false)
                        }
                    }
                }

                if (cf.btnMvDn) {
                    let cfg = shmi.cloneObject(cfgBtn)
                    cfg.name = cfg.label = "cx-btn-mvDn"
                    cfg.imgPosition = "top"
                    cfg.imgUrlOn = "pics/custom/controls/cx-inputX/table-row-mv-dn.svg"
                    el.btnMvDn = shmi.createControl("cx-button", el.cxInputXBtns, cfg, "DIV")
                    cfg.actionUp = () => {
                        if (vr.iRowSelected < el.table.rows.length - 1) {
                            let iRowNew = vr.iRowSelected + 1
                            let sTmp = el.table.rows[iRowNew].cells[1].innerText
                            el.table.rows[iRowNew].cells[1].innerText = el.table.rows[vr.iRowSelected].cells[COL_DATA].innerText
                            el.table.rows[vr.iRowSelected].cells[COL_DATA].innerText = sTmp
                            selectRow(self, iRowNew)
                            table2text(self, false)
                        }
                    }
                }
                if (cf.btnCopyPaste) { // btn-copy
                    let cfg = shmi.cloneObject(cfgBtn)
                    cfg.name = cfg.label = "cx-btn-copy"
                    // cfg.labelOn = "Copy"
                    cfg.imgPosition = "top"
                    cfg.imgUrlOn = "pics/custom/controls/cx-inputX/copy.svg"
                    el.btnCopy = shmi.createControl("cx-button", el.cxInputXBtns, cfg, "DIV")
                    cfg.actionUp = async () => {
                        vr.Copy = el.table.rows[vr.iRowSelected].cells[COL_DATA].innerText
                        cxt.msgTop("info", "Copied selected row")
                    }
                }
                if (cf.btnCopyPaste) { // btn-paste
                    let cfg = shmi.cloneObject(cfgBtn)
                    cfg.name = cfg.label = "cx-btn-paste"
                    // cfg.labelOn = "Paste"
                    cfg.imgPosition = "top"
                    cfg.imgUrlOn = "pics/custom/controls/cx-inputX/paste.svg"
                    el.btnPaste = shmi.createControl("cx-button", el.cxInputXBtns, cfg, "DIV")
                    cfg.actionUp = async () => {
                        // let tr = tableAddRow(self, "")
                        // let iRowNew = vr.iRowSelected + 1
                        // el.table.insertBefore(tr, el.table.rows[iRowNew])
                        // setRowNumber(self)
                        // selectRow(self, iRowNew)
                        el.table.rows[vr.iRowSelected].cells[COL_DATA].innerText = vr.Copy
                        table2text(self, false)
                    }
                }

                // Set label
                if (el.label) el.label.textContent = shmi.localize(self.config.label);

                // add onClick handler to execute an function
                // if (el.bar) {
                //     //get reference to Mouse- & TouchListener constructors
                //     const arListeners = [self.imports.io.MouseListener, self.imports.io.TouchListener]

                //     // define the onClick handler
                //     const handler = {
                //         onClick: function (x, y, event) {
                //             // Change bar color to random color
                //             el.bar.style.backgroundColor = `#${Math.floor(Math.random() * 16777215).toString(16)}`;
                //         }
                //         // , onPress: function (x, y, event) { log("onPress event")}
                //         // , OnRelease: function (x, y, event) { log("onRelease event")}
                //         // , onDrag: function (x, y, event){ log("onDrag event")}
                //     };

                //     //create listeners for root element (=self.element) of the widget
                //     arListeners.forEach(listen => {
                //         self.vars.listeners.push(
                //             new listen(self.element, handler)
                //         )
                //     });
                // }
                // (CUSTOM ADDITION--)
            },
            // called when widget is enabled
            onEnable: async function () {
                // (CUSTOM ADDITION++)
                log("onEnable")
                const self = this
                const el = self.vars.elements
                const cf = self.config
                //el.txtArea.value = await cxt.getItem(cf.item)

                enableListeners(self, true);
                el.txtArea.readOnly = false
                // Subscribe to item updates
                subscribeIfExists(self, self.config.item)
                subscribeIfExists(self, self.config.itemLine)

                toggleEditor(self)
                updateTable(self)

                // (/CUSTOM ADDITION--)
            },
            // called when widget is disabled
            onDisable: function () {
                // (CUSTOM ADDITION++)
                log("onDisable")
                const self = this
                const el = self.vars.elements

                enableListeners(self, false)
                el.txtArea.readOnly = true
                // Stop listening to all items in subscribes[]
                self.vars.subscribes.forEach((s) => {
                    s.unlisten();
                })
                self.vars.subscribes = []
                // (/CUSTOM ADDITION--)
            },
            // called when widget is locked - disable mouse- and touch-listeners
            onLock: function () {
                // (CUSTOM ADDITION++)
                const self = this
                // cxt.setWidgetTitle(self, "onLock", bForceTitle)
                // subscribe item, with row number to highlight
                // if (self.config.itemLine) {
                //     const { im } = self.imports;
                //     self.vars.subscribes.itemLine = im.subscribeItem(self.config.itemLine, self)
                // }
                enableListeners(self, false)
                // highlight row
                // try { selectRow(self, -1) } catch (e) { }
                // (/CUSTOM ADDITION--)
            },
            // called when widget is unlocked - enable mouse- and touch-listeners
            onUnlock: function () {
                // (CUSTOM ADDITION++)
                const self = this
                // cxt.setWidgetTitle(self, "onUnlock", bForceTitle)
                // if (self.vars.subscribes.itemLine) {
                //     self.vars.subscribes.itemLine.unlisten();
                //     self.vars.subscribes.itemLine = null
                // }
                enableListeners(self, true)
                // (/CUSTOM ADDITION--)
            },
            // called by ItemManager when value of subscribed item changes and once on initial subscription
            onSetValue: function (value, type, name) {
                // (CUSTOM ADDITION++)
                log("onSetValue")
                if (type === null)  // when type===null do nothing, because params are invalid
                    return
                const self = this;
                const el = self.vars.elements
                const cf = self.config
                const vr = self.vars
                if (name === cf.item) {
                    // if (cf.isUtf8) value = cxt.utf8_2_utf16(value)
                    if (cf.isUtf8) value = shmi.from_utf8(value)
                    el.txtArea.value = value
                    // create table, if table selected
                    if (vr.iTouchEdit === 1) text2table(self)
                } else if ((name === cf.itemLine) && (vr.bLocked)) {
                    selectRow(self, value - 1)
                }
                // (/CUSTOM ADDITION--)
            },

            // called by ItemManager to provide properties (min & max values etc.) of subscribed item
            onSetProperties: function (min, max, step, name, type, warnMin, warnMax, prewarnMin, prewarnMax, digits) {
                // (CUSTOM ADDITION++)
                log("onSetProperties" + `name:${name} type:${type} min:${min} max:${max}`)
                if (type === null)  // when type===null do nothing, because params are invalid
                    return
                const self = this;
                // (/CUSTOM ADDITION--)
            },
            // called when widget is deleted - used for instance clean-up
            onDelete: function () {
                log("onDelete")
                // const self = this;
                // const el = self.vars.elements
                // const arCtrl = [el.btnToggle, el.btnAdd, el.btnDel, el.btnMvUp, el.btnMvDn, el.btnCopy, el.btnPaste]
                // arCtrl.forEach(element => {
                //     if (element) shmi.deleteControl(element)
                // });
            }
        }
    };

    // definition of new widget extending BaseControl - END

    // generate widget constructor & prototype using the control-generator tool
    shmi.requires("visuals.tools.control-generator").generate(definition);
})();
