/**
 * Visuals - Industrial Visualization Framework for JavaScript
 *
 * Copyright © 2012-2024 Smart HMI GmbH
 *
 * All rights reserved
 *
 * No part of this website or any of its contents may be reproduced, copied, modified or
 * adapted, without the prior written permission of Smart HMI.
 *
 * Commercial use and distribution of the contents of the website is not allowed without
 * express and prior written permission of Smart HMI.
 *
 *
 * Web: http://www.smart-hmi.de
 *
 * @version 2.15.7 c927faeb.44385 25-01-2024 14:05:49
 */

!function(){"use strict";var e="AlarmHistory",t="alarm-history",s={"class-name":t,name:null,template:"default/"+t,label:t,dateformat:"${alarmlist_dateformat}"},n=shmi.requires("visuals.tools.logging").createLogger(t,!1,!1),a=(n.fLog,n.log),l={name:"alarms-historic",fields:["id","index","level","come","gone","group","needAck","isAck","alarmAck","ackUser","json"]},o={label:"${alarmlist_history_title}",table:l.name,name:"alarm-table","class-name":"complex-table2 alarms","field-datagrid-col-map":{level:2,description:1,"alarm-start":3,"alarm-end":4,"alarm-group":5,detail:10},"select-mode":"SINGLE","default-field-control-map":{level:{"ui-type":"toggle-display",config:{template:"default/alarm-history/toggle-display-alarm-levels",conditions:["%VALUE%==0","%VALUE%==1","%VALUE%==2"],"class-name":"toggle-display icon-only no-background"}},description:{"ui-type":"text2",config:{"class-name":"text2 multiline",options:[],pattern:"${alarm_title_<%= VALUE %>}"}},"alarm-start":{"ui-type":"text2-date",config:{"class-name":"text2 text2-date multiline",dateformat:"$DD.$MM.$YYYY, $HH:$mm:$ss"}},"alarm-end":{"ui-type":"text2-date",config:{"class-name":"text2 text2-date multiline",dateformat:"$DD.$MM.$YYYY, $HH:$mm:$ss"}},"alarm-group":{"ui-type":"text2",config:{"class-name":"text2",options:[],pattern:"${alarm_group_<%= VALUE %>}"}},detail:{"ui-type":"local-script",config:{module:"visuals.tools.alarms.ls.alarmDetails"}}},"default-field-headers":{level:"${alarmlist_level_header}",description:"${alarmlist_title_header}","alarm-start":"${alarmlist_come_header}","alarm-end":"${alarmlist_gone_header}","alarm-group":"${alarmlist_group_header}",detail:"${alarmlist_detail_header}"},_comment:"expr is passed to expr parameter array of shmi.visuals.core.DataGridManager.setFilter",filters:[{label:"${alarmlist_level_info}",template:"default/alarm-history/level-service","class-name":"toggle-button icon-and-text",field:"level",expr:0},{label:"${alarmlist_level_warning}",template:"default/alarm-history/level-warning","class-name":"toggle-button icon-and-text",field:"level",expr:1},{label:"${alarmlist_level_alarm}",template:"default/alarm-history/level-alarm","class-name":"toggle-button icon-and-text",field:"level",expr:2}],"default-layout":{"class-name":"layout-std",_comment:"default == no additional css layout class","column-org":{col1:{fields:["level"],width:"5%"},col2:{fields:["description"],width:"20%"},col3:{fields:["alarm-start"],width:"20%"},col4:{fields:["alarm-end"],width:"20%"},col5:{fields:["alarm-group"],width:"20%"},col6:{fields:["detail"],width:"15%"}},"line-height":"39px"},"sortable-fields":["level","description","alarm-start","alarm-end","alarm-group"],"delete-selected-rows":!1,"show-nof-rows":!0,"show-buttons-table-min-width-px":400,"text-mode":"SINGLELINE","responsive-layouts":[{"class-name":"layout-compact","table-max-width-px":700,"v-scroll-options":["V_SWIPE"],"select-mode":"SINGLE","column-org":{col1:{fields:["level"],width:"15%"},col2:{fields:["description"],width:"30%"},col3:{fields:["alarm-start","alarm-end"],width:"25%"},col4:{fields:["detail"],width:"25%"}},"line-height":"79px"}],"default-nof-buffered-rows":150,"buffer-size":500};function computeTimestampFromControls(e){return function computeTimestamp(e,t,s,n){var a=new Date(1e3*e);return a.setHours(t,s,n,0),a.getTime()/1e3}(e.date.getValue(),e.time.getHours(),e.time.getMinutes(),e.time.getSeconds())}function setFilter(e){var t=computeTimestampFromControls(e.vars.controls.from),s=computeTimestampFromControls(e.vars.controls.to),n=shmi.requires("visuals.tools.date");shmi.addClass(e.element,"filter-active"),e.vars.activeFilterLabel.textContent=shmi.localize("${alarmlist_timefilter}"),e.vars.activeFilterFrom.textContent=n.formatDateTime(t,{datestring:shmi.localize(e.config.dateformat)}),e.vars.activeFilterTo.textContent=n.formatDateTime(s,{datestring:shmi.localize(e.config.dateformat)}),e.vars.grid.setFilter(3,[t,s])}var r={className:e,uiType:t,isContainer:!0,config:s,configSchema:null,vars:{grid:null,table:null,startDate:null,endDate:null,todayButton:null,resetButton:null,timeFilterLabel:null,activeFilterLabel:null,activeFilterFrom:null,activeFilterTo:null,anchors:{from:null,to:null,table:null,filterButton:null,filterOverlay:null},controls:{table:null,from:{date:null,time:null},to:{date:null,time:null}},tokens:[],listeners:[]},imports:{im:"visuals.session.ItemManager",qm:function(){return shmi.visuals.session.QueryManager},dgm:"visuals.session.DataGridManager",iter:"visuals.tools.iterate.iterateObject"},prototypeExtensions:{onInit:function(){var s=this,n=s.imports.dgm.getGrid(l.name),r=s.imports.iter,c=!1,u=shmi.requires("visuals.io");n?console.debug(t,"grid exists:",l.name):(n=s.imports.dgm.grids[l.name]=new shmi.visuals.core.DataGridDB(l.name,shmi.c(l.db),l.table,l.fields,l.conditions),a("grid created:",l.name)),s.vars.grid=n,s.vars.resetButton=shmi.getUiElement("reset-button",s.element);var m={onClick:function(){!function clearFilter(e){e.vars.grid.clearFilter(3),shmi.removeClass(e.element,"filter-active")}(s)}};s.vars.timeFilterLabel=shmi.getUiElement("filter-label",s.element),s.vars.timeFilterLabel.textContent=shmi.localize("${alarmlist_set_timefilter}"),s.vars.activeFilterLabel=shmi.getUiElement("time-frame-label",s.element),s.vars.activeFilterFrom=shmi.getUiElement("start-date",s.element),s.vars.activeFilterTo=shmi.getUiElement("end-date",s.element);var h=new u.MouseListener(s.vars.resetButton,m),d=new u.TouchListener(s.vars.resetButton,m);s.vars.listeners.push(h,d);var f=shmi.localize(s.config.dateformat);if(o["default-field-control-map"]["alarm-start"].config.dateformat=f,o["default-field-control-map"]["alarm-end"].config.dateformat=f,function getAnchorElements(e){e.vars.anchors.from=shmi.getUiElement("from-anchor",e.element),e.vars.anchors.to=shmi.getUiElement("to-anchor",e.element),e.vars.anchors.table=shmi.getUiElement("table-anchor",e.element),e.vars.anchors.filterButton=shmi.getUiElement("filter-button",e.element),e.vars.anchors.filterOverlay=shmi.getUiElement("filter-overlay",e.element)}(s),r(s.vars.anchors,(function(t,s){t||(console.error(e,"element not found:",s+"-anchor"),c=!0)})),!c){!function createControls(e){var t=e.vars.anchors,s=e.vars.controls;s.table=shmi.createControl("complex-table2",t.table,o,"DIV"),s.from.date=shmi.createControl("select-date",t.from,{label:"start"},"DIV"),s.from.time=shmi.createControl("select-time",t.from,{label:"start",isUTC:!0},"DIV"),s.to.date=shmi.createControl("select-date",t.to,{label:"end"},"DIV"),s.to.time=shmi.createControl("select-time",t.to,{label:"end",isUTC:!0},"DIV"),s.from.time.setValue(0),s.to.time.setValue(0)}(s);var v={onClick:function(){var e="filter-open";s.locked||(shmi.hasClass(s.element,e)?(shmi.removeClass(s.element,e),setFilter(s)):(shmi.addClass(s.element,e),s.vars.firstOpened||(s.vars.controls.to.date.setValue(s.vars.controls.from.date.getValue()+86400),s.vars.controls.to.time.setValue(s.vars.controls.from.time.getValue()),s.vars.firstOpened=!0)))}},g=new u.MouseListener(s.vars.anchors.filterButton,v),p=new u.TouchListener(s.vars.anchors.filterButton,v);s.vars.listeners.push(g,p);var b={onClick:function(){shmi.removeClass(s.element,"filter-open"),setFilter(s)}},y=new u.MouseListener(s.vars.anchors.filterOverlay,b),E=new u.TouchListener(s.vars.anchors.filterOverlay,b);s.vars.listeners.push(y,E)}},onEnable:function(){var e=this,s=e.vars.controls.from,n=Math.floor(new Date(1e3*shmi.getServerTime()).getTime()/1e3),l=86400*Math.floor(n/86400);e.controls.forEach((function(e){e.enable()})),s.date.setValue(l-86400),s.time.setValue(n),function attachChangeListeners(e){var s=e.vars.tokens,n=e.vars.controls.from,l=e.vars.controls.to;s.push(n.date.listen("change",(function(e){a(t,"from date:",e.detail.value),a(t,"total from:",new Date(1e3*computeTimestampFromControls(n))),l.date.setValue(n.date.getValue()+86400),l.time.setValue(n.time.getValue())}))),s.push(n.time.listen("change",(function(e){a(t,"from time:",e.detail.value),a(t,"total from:",new Date(1e3*computeTimestampFromControls(n)))}))),s.push(l.date.listen("change",(function(e){a(t,"to date:",e.detail.value)}))),s.push(l.time.listen("change",(function(e){a(t,"to time:",e.detail.value)})))}(e),e.vars.listeners.forEach((function(e){e.enable()}))},onDisable:function(){var e=this;e.controls.forEach((function(e){e.disable()})),e.vars.tokens.forEach((function(e){e.unlisten()})),e.vars.firstOpened=!1,e.vars.tokens=[],e.vars.listeners.forEach((function(e){e.disable()}))},onLock:function(){this.vars.listeners.forEach((function(e){e.disable()}))},onUnlock:function(){this.vars.listeners.forEach((function(e){e.enable()}))},onSetValue:function(e,t,s){},onSetProperties:function(e,t,s){}}};shmi.requires("visuals.tools.control-generator").generate(r)}(),function(){var e="visuals.tools.alarms.ls.alarmDetails",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),s=t.fLog;t.log;shmi.pkg(e).run=function(e){var t=[],s=null,n=shmi.requires("visuals.session.ItemManager"),a=shmi.requires("visuals.tools.numericValues"),l=shmi.visuals.tools.unitClasses,o=n.getItemHandler(),r=null;e.vars=e.vars||{},s=shmi.createControl("button",e.element.parentNode,{label:"${alarmlist_show_detail}"},"DIV"),o.setValue=function(e){(r=JSON.parse(e))&&Array.isArray(r.items)&&r.items.forEach((function(t,s){if(t.formattedValue=a.formatNumber(e,{unit:t.unit,precision:t.digits}),"number"==typeof t.unit){var n=l.getSelectedAdapter(t.unit);n&&(t.unit=n.unitText,t.value=n.outFunction(t.value))}"number"==typeof t.digits&&t.digits>=0&&(t.value=t.value.toFixed(t.digits))}))},t.push(s.listen("click",(function(){var e=shmi.evalString("${alarm_msg_<%= VALUE %>}",{VALUE:r.index}),t=shmi.localize(e);shmi.notify(shmi.evalString(t,r))}))),e.config.item&&t.push(n.subscribeItem(e.config.item,o)),e.onDisable=function(){e.run=!1,t.forEach((function(e){e.unlisten()})),t=[],shmi.deleteControl(s,!0)}},s("module loaded")}(),function(){"use strict";const e="alarm-info",t={"class-name":e,name:null,template:"default/alarm-info",label:e,noAlarm:null,action:null,userGroups:null,enableCycle:!0,cycleInterval:1e3,showAlarm:!0,showWarn:!0,showInfo:!0,groupFilter:null},s=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1).log,n=["service","preWarn","warn"];function hide(e){e&&shmi.addClass(e,"hidden")}function parseAlarmGroupFilter(e){if("string"!=typeof e)return null;let t=e.split(",");t=t.map((e=>{if(e.includes("-"))return function parseAlarmGroupRange(e){const t=e.split("-");if(2===t.length){const e=parseInt(t[0]),s=parseInt(t[1]);if(!isNaN(e)&&!isNaN(s)&&e>0&&s>1&&s>e)return[e,s]}return null}(e);const t=parseInt(e);return!isNaN(t)&&t>=0?t:null})),t=t.filter((e=>null!==e));const s=[];return t.forEach((e=>{if(Array.isArray(e)){let n=e[0];for(;n<=e[1];)s.includes(n)&&t.includes(n)||s.push(n),n+=1}})),t.push(...s),t.length?t:null}function testAlarmState(e){const t=Object.values(e.imports.am.alarms).map((e=>e.properties));Array.isArray(t)&&(t.length<1?clearAlarmMsg(e):(clearInt(e),e.config.enableCycle?(e.vars.activeAlarmList=getEnabledAlarms(e,t),e.vars.activeAlarmList.length>1&&(e.vars.interval=setInterval(displayAlarms.bind(null,e),e.config.cycleInterval))):e.vars.activeAlarmList=function getLastHighest(e,t){let s=null;return getEnabledAlarms(e,t).forEach((function(e){(null===s||e.severity>=s.severity&&e.timestamp_in>s.timestamp_in)&&(s=e)})),null===s?[]:[s]}(e,t),displayAlarms(e)))}function displayAlarms(e){0===e.vars.activeAlarmList.length&&clearAlarmMsg(e),e.vars.currentAlarm>=e.vars.activeAlarmList.length&&(e.vars.currentAlarm=0),clearAlarmState(e);const t=e.vars.activeAlarmList[e.vars.currentAlarm++];let s=null;t?(s=shmi.evalString("${alarm_title_<%= value %>}",{value:t.index}),s=shmi.localize(s),s=shmi.evalString(s,t),isNaN(t.severity)||function setAlarmState(e,t){e in t.vars.stateIcons&&function show(e){e&&shmi.removeClass(e,"hidden")}(t.vars.stateIcons[e]);shmi.addClass(t.element,n[e])}(t.severity,e)):s=shmi.localize(e.config.noAlarm),e.vars.lastAlarmMsg.textContent=s,e.vars.lastAlarmsNum&&(e.vars.lastAlarmsNum.textContent=e.vars.lastAlarmsNumValue)}function getEnabledAlarms(e,t){const s=t.filter((function(t){if(Array.isArray(e.vars.groupFilter)&&!e.vars.groupFilter.includes(t.group))return!1;if(!t.active){if(!t.acknowledgeable)return!1;if(t.acknowledged)return!1}return 2===t.severity&&e.config.showAlarm||1===t.severity&&e.config.showWarn||0===t.severity&&e.config.showInfo}));return e.vars.lastAlarmsNumValue=s.length,s}function clearAlarmMsg(e){clearInt(e),e.vars.currentAlarm=0,clearAlarmState(e),e.vars.lastAlarmMsg.textContent=shmi.localize(e.config.noAlarm)}function clearInt(e){e.vars.interval&&(clearInterval(e.vars.interval),e.vars.interval=null)}function clearAlarmState(e){e.vars.stateIcons.forEach(hide),n.forEach((function(t){shmi.removeClass(e.element,t)}))}const a={className:"AlarmInfo",uiType:e,isContainer:!1,config:t,configSchema:null,vars:{hidden:!1,clickElement:null,lastAlarmsNum:null,lastAlarmsNumValue:0,lastAlarmMsg:null,lastAlarmMsgValue:0,lastAlarmClass:null,lastAlarmClassValue:0,listeners:[],tokens:[],stateIcons:[],activeAlarmList:[],currentAlarm:0,interval:0,alarmSubscriber:null,groupFilter:null},imports:{im:"visuals.session.ItemManager",am:"visuals.session.AlarmManager"},prototypeExtensions:{onInit:function(){const t=this,n=shmi.requires("visuals.io");let a=null,l=null,o=null,r=null,c=null,u=null;if("string"==typeof t.config.userGroups&&t.config.userGroups.length>0&&(r=t.config.userGroups.split(","),c=shmi.requires("visuals.session.UserManager"),u=c.currentUser,u.groupList.filter((function(e){return-1!==r.indexOf(e)})).length<1))return hide(shmi.getUiElement("alarm-info-wrapper",t.element)),void(t.vars.hidden=!0);t.vars.groupFilter=parseAlarmGroupFilter(t.config.groupFilter),t.vars.lastAlarmsNum=shmi.getUiElement("last-alarms-num",t.element),t.vars.lastAlarmsNum||s(e,"last-alarms-num not found in template"),t.vars.lastAlarmMsg=shmi.getUiElement("last-alarm-msg",t.element),t.vars.lastAlarmMsg?t.vars.lastAlarmMsg.textContent=shmi.localize(t.config.noAlarm):s(e,"last-alarm-msg not found in template"),t.vars.clickElement=shmi.getUiElement("alert-list-button",t.element),t.vars.clickElement&&Array.isArray(t.config.action)?(o={onClick:function(e,s,n){new(shmi.requires("visuals.core").UiAction)(t.config.action).execute()}},a=new n.MouseListener(t.vars.clickElement,o),l=new n.TouchListener(t.vars.clickElement,o),t.vars.listeners.push(a,l)):t.vars.clickElement||s(e,"click element not found in template")},onEnable:function(){const e=this;e.vars.hidden?s("Alarm Info is disabled"):(e.vars.stateIcons=shmi.getUiElements("state",e.element)||[],e.vars.alarmSubscriber=e.imports.am.subscribeAlarms(e,(function(t,s){s&&testAlarmState(e)})),e.vars.listeners.forEach((function(e){e.enable()})))},onDisable:function(){const e=this;e.vars.tokens.forEach((function(e){e.unlisten()})),e.vars.tokens=[],e.vars.listeners.forEach((function(e){e.disable()})),e.imports.am.unsubscribeAlarms(e.vars.alarmSubscriber),clearInt(e)},onLock:function(){this.vars.listeners.forEach((function(e){e.disable()}))},onUnlock:function(){this.vars.listeners.forEach((function(e){e.enable()}))},onSetValue:function(e,t,s){},onSetProperties:function(e,t,s){}}};shmi.requires("visuals.tools.control-generator").generate(a)}(),function(){"use strict";var e="alpha-num-keyboard",t={"class-name":e,name:null,template:"default/alpha-num-keyboard",label:"","key-preview":!0,"show-enter":!1,"auto-key-focus":!1,"password-input":!1,"select-box-enabled":!0,keyboards:{}},s=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),n=(s.fLog,s.log),a={className:"AlphaNumKeyBoard",uiType:e,isContainer:!0,config:t,configSchema:null,vars:{listeners:[],controls:[],tokens:[],keys:[],keyboardMap:{},activeModifiers:{},activeKeyboard:null,activePalette:null,activeKeys:null,currentText:"",keyTypeListeners:{},previewContainer:null,shiftKeyActive:!1,showPassword:!1},imports:{},events:[],prototypeExtensions:{onInit:function(){var e=this;e.vars.keyListeners={onPress:onKeyPressListener.bind(null,e),onClick:onKeyClickListener.bind(null,e),onRelease:onKeyReleaseListener.bind(null,e)},e.vars.eventListeners={mouseOver:onKeyMouseInListener.bind(null,e),mouseOut:onKeyMouseOutListener.bind(null,e),mouseUp:onKeyMouseUpListener.bind(null,e),mouseDown:onKeyMouseDownListener.bind(null,e),touchStart:onKeyTouchStartListener.bind(null,e),touchEnd:onKeyTouchEndListener.bind(null,e),touchMove:onKeyTouchMoveListener.bind(null,e),keyDown:onKeyDownListener.bind(null,e),keyUp:onKeyUpListener.bind(null,e)},e.vars.keyboardContainer=shmi.getUiElement("keyboard-container",e.element);var t=shmi.requires("shmi.visuals.session.keyboards"),s=shmi.requires("visuals.session.localeInfo"),a=shmi.requires("visuals.session.UserManager");if(t){e.config.keyboards=t,a.currentUser&&a.currentUser.loggedIn&&t&&s.locales[a.currentUser.locale]&&s.locales[a.currentUser.locale].keyboard&&t[s.locales[a.currentUser.locale].keyboard]?e.vars.currentLocale=s.locales[a.currentUser.locale].keyboard:s.locales[s.default]&&s.locales[s.default].keyboard&&t[s.locales[s.default].keyboard]&&(e.vars.currentLocale=s.locales[s.default].keyboard);var l=Object.keys(t);!function initKeyboardControls(e){if(e.config["select-box-enabled"]&&Object.keys(e.config.keyboards).length>1){var t=shmi.requires("visuals.session.localeInfo"),s=shmi.getUiElement("language-control",e.element),a={label:"",options:[]},l=Object.keys(e.config.keyboards);if(l&&l.length>0){l.forEach((function(e,s){a.options.push({label:t.keyboards[e].label,value:e})}));var o=shmi.createControl("select-box",s,a,"DIV");shmi.waitOnInit(o,(function(){e.vars.currentLocale?o.setValue(e.vars.currentLocale):(e.config["default-keyboard"]=e.config["default-keyboard"]||l[0],o.setValue(e.config["default-keyboard"])),e.vars.tokens.push(o.listen("change",(function onChange(t){disableActiveKeyMapListeners(e),e.vars.activePalette.element.style.display="none",e.vars.activeKeyboard.element.style.display="none",e.vars.activeKeyboard=e.vars.keyboardMap[t.detail.value];var s=null;s=Object.keys(e.vars.activeKeyboard.paletteMap)[0],e.vars.activePalette=e.vars.activeKeyboard.paletteMap[s],e.vars.activeKeyMap=e.vars.activePalette.keyMap,e.vars.activeKeyboard.element.style.display="block",e.vars.activePalette.element.style.display="flex",enableActiveKeyMapListeners(e)})))})),shmi.addClass(s,"enabled"),e.vars.controls.push(o)}}var r=shmi.getUiElement("close-button",e.element),c={"class-name":"button icon-only",label:"Cancel",template:"default/button_with_bg_pic"},u=shmi.createControl("button",r,c,"DIV");e.vars.tokens.push(u.listen("click",(function onclick(t){n("Fire: Close Keyboard"),shmi.fire("keyboard-cancel",{success:!1,input:e.vars.currentText})}))),e.vars.controls.push(u);var m=shmi.getUiElement("submit-button",e.element),h={"class-name":"button icon-only",template:"default/button_with_bg_pic"},d=shmi.createControl("button",m,h,"DIV");if(e.vars.tokens.push(d.listen("click",(function onclick(t){n("Fire: Submit Keyboard"),shmi.fire("keyboard-submit",{success:!0,input:e.vars.currentText})}))),e.vars.controls.push(d),e.config["password-input"]){const t=shmi.getUiElement("pw-button",e.element),s={"class-name":"button icon-only",template:"default/button_with_bg_pic"},n=shmi.createControl("button",t,s,"DIV");e.vars.tokens.push(n.listen("click",(function onclick(t){e.vars.showPassword=!e.vars.showPassword,updatePreviewTextContent(e)}))),e.vars.controls.push(n)}}(e),l.forEach((function(s){var n=function createKeyboard(e,t,s){var n=Object.keys(s),a=document.createElement("DIV"),l={};return shmi.addClass(a,"keyboard"),shmi.addClass(a,"keyboard-"+t.toLowerCase()),a.setAttribute("data-name","keyboard-"+t),n.forEach((function(t,n){var o=s[t],r=function createKeyboardPalette(e,t,s){var n=document.createElement("DIV"),a=[],l={};return shmi.addClass(n,"keyboard-palette"),shmi.addClass(n,"keyboard-palette-"+t.toLowerCase()),n.setAttribute("data-name","palette-"+t),s.forEach((function(t){var s=function createKeyboardRow(e,t){var s=document.createElement("DIV"),n=[];return shmi.addClass(s,"key-row"),t.forEach((function(a,l){var o=createKeyboardKey(e,a.name,a,l<t.length/2);s.appendChild(o.element),n.push(o),o.alternatives&&o.alternatives.forEach((function(e){n.push(e)}))})),{keys:n,element:s}}(e,t);n.appendChild(s.element),a.push(s),s.keys.forEach((function(e){var t=getUnusedId(l);e["data-key-id"]=t,e.element.setAttribute("data-key-id",t),l[e["data-key-id"]]=e}))})),{name:t,element:n,keyMap:l}}(e,t,o),c=getUnusedId(l);r.id=c,r.element.setAttribute("data-key-id",c),r.element.style.display=0===n?"flex":"none",a.appendChild(r.element),l[c]=r})),{paletteMap:l,name:t,element:a}}(e,s,t[s]);e.vars.keyboardContainer.appendChild(n.element),e.vars.keyboardMap[s]=n})),e.vars.previewContainer=shmi.getUiElement("text-preview",e.element),e.vars.currentText=e.config.value||e.vars.currentText,updatePreviewTextContent(e),e.vars.previewContainer.focus();var o;e.vars.currentLocale?e.vars.activeKeyboard=e.vars.keyboardMap[e.vars.currentLocale]:e.vars.activeKeyboard=e.vars.keyboardMap[Object.keys(e.vars.keyboardMap)[0]],o=Object.keys(e.vars.activeKeyboard.paletteMap)[0],e.vars.activePalette=e.vars.activeKeyboard.paletteMap[o],e.vars.activeKeyMap=e.vars.activePalette.keyMap,e.vars.activeKeyboard.element.style.display="block",e.config["key-preview"]&&shmi.addClass(e.element,"key-preview-enabled"),e.config["password-input"]&&shmi.addClass(e.element,"password-input"),e.config["show-enter"]||shmi.addClass(e.element,"hide-enter"),enableActiveKeyMapListeners(e)}},onEnable:function(){var e=this;e.vars.listeners.forEach((function(e){e.enable()})),e.vars.controls.forEach((function(e){e.enable()})),document.addEventListener("keydown",e.vars.eventListeners.keyDown),document.addEventListener("keyup",e.vars.eventListeners.keyUp),shmi.log("[Alpha Num Keyboard] enabled",1)},onDisable:function(){var e=this;e.hide(),document.removeEventListener("keydown",e.vars.eventListeners.keyDown),document.removeEventListener("keyup",e.vars.eventListeners.keyUp),e.vars.listeners.forEach((function(e){e.disable()})),e.vars.controls.forEach((function(e){e.disable()})),e.vars.tokens.forEach((function(e){e.unlisten()})),shmi.log("[Alpha Num Keyboard] disabled",1)},onLock:function(){this.vars.listeners.forEach((function(e){e.disable()})),this.vars.controls.forEach((function(e){e.lock()}))},onUnlock:function(){this.vars.listeners.forEach((function(e){e.enable()})),this.vars.controls.forEach((function(e){e.unlock()}))},show:function(){shmi.removeClass(this.element,"closed"),shmi.addClass(this.element,"open")},hide:function(){shmi.removeClass(this.element,"open"),shmi.addClass(this.element,"closed")},onSetValue:function(e,t,s){},onSetProperties:function(e,t,s){}}};function createKeyboardKey(e,t,s,n){var a=document.createElement("DIV"),l=document.createElement("DIV"),o=null,r=null,c=null;e.config["key-preview"]&&(o=document.createElement("DIV"),r=document.createElement("SPAN")),e.vars.keyTypeListeners[s.type]=e.vars.keyTypeListeners[s.type]||{};var u=String(s.name||t).replace(/"/g,'\\"');return shmi.addClass(a,"key-box"),shmi.addClass(l,"key"),shmi.addClass(l,"key-"+u),l.setAttribute("data-key-name",u),e.config["auto-key-focus"]&&l.setAttribute("tabindex",0),s["class-name"]&&shmi.addClass(l,s["class-name"]),0!==Number(s.size)&&shmi.addClass(a,"key-box-flex-"+s.size),shmi.addClass(l,"key-"+s.type),l.setAttribute("data-key-type",s.type),l.innerText=s.name||"",a.appendChild(l),o&&(shmi.addClass(o,"key-preview"),r.innerText=s.name||"",a.appendChild(o),o.appendChild(r)),s.alternatives&&(c=document.createElement("DIV"),shmi.addClass(c,"alt-keys"),n?shmi.addClass(c,"left-side"):shmi.addClass(c,"right-side"),s.alternatives.forEach((function(t){var s=createKeyboardKey(e,t.name,t);c.appendChild(s.element)})),shmi.addClass(c,"numofKeys-"+s.alternatives.length),a.appendChild(c)),s.element=a,s}function setKeyConfig(e,t,s){var n=s.name||t.name;if(n&&(t.element.firstChild.textContent=n,e.config["key-preview"])){var a=t.element.getElementsByTagName("span")[0];a&&(a.innerText=n)}var l=s["class-name"];l&&("!"===l.charAt(0)?shmi.removeClass(t.element,l.substring(1)):shmi.addClass(t.element,l));var o=t.element.className,r=s.size||t.size,c=r?"key-box-flex-"+r:null;-1===t.element.className.indexOf(c)&&c&&(t.element.className=(" "+o+" ").replace(/\bkey-box-flex-\S*\b/g," "),shmi.addClass(t.element,c));var u=s.type||t.type;t.element.firstChild.setAttribute("data-key-type",u)}function enableActiveKeyMapListeners(e){Object.keys(e.vars.activeKeyMap).forEach((function(t){var s=new shmi.visuals.io.MouseListener(e.vars.activeKeyMap[t].element,e.vars.keyListeners),n=new shmi.visuals.io.TouchListener(e.vars.activeKeyMap[t].element,e.vars.keyListeners),a=e.vars.activeKeyMap[t].element.firstChild;s.enable(),n.enable(),e.vars.listeners.push(s,n),a.addEventListener("mouseover",e.vars.eventListeners.mouseOver),a.addEventListener("mouseout",e.vars.eventListeners.mouseOut),a.addEventListener("mousedown",e.vars.eventListeners.mouseDown),a.addEventListener("mouseup",e.vars.eventListeners.mouseUp)})),e.vars.activePalette.element.addEventListener("touchstart",e.vars.eventListeners.touchStart)}function disableActiveKeyMapListeners(e){e.vars.listeners.forEach((function(e){e.disable()})),e.vars.listeners=[],Object.keys(e.vars.activeKeyMap).forEach((function(t){var s=e.vars.activeKeyMap[t].element.firstChild;s.removeEventListener("mouseover",e.vars.eventListeners.mouseOver),s.removeEventListener("mousedown",e.vars.eventListeners.mouseDown),s.removeEventListener("mouseout",e.vars.eventListeners.mouseOut),s.removeEventListener("mouseup",e.vars.eventListeners.mouseUp),e.vars.activePalette.element.removeEventListener("touchstart",e.vars.eventListeners.touchStart)}))}var l=["A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"];function getRandomId(e){var t="";void 0===e&&(e=3);for(var s=0;s<e;s++)t+=l[Math.floor(Math.random()*(l.length-1))];return t}function getUnusedId(e){var t=null;do{t=getRandomId(8)}while(shmi.objectHasOwnProperty(e,t));return t}function fireKeyboardClick(e,t,s){switch(t.type){case"letter":case"number":case"character":!function addLetterIntoCurrentText(e,t){var s=evaluateKeyModifiers(e,t),n=s.val||t.val,a=String(e.vars.currentText),l=null,o=e.vars.previewContainer.selectionStart;n&&1===n.length&&(l=a.substr(0,e.vars.previewContainer.selectionStart)+n+a.substr(e.vars.previewContainer.selectionEnd),e.vars.currentText=l,updatePreviewTextContent(e),e.vars.previewContainer.selectionStart=e.vars.previewContainer.selectionEnd=o+1);n&&2===n.length&&(l=a.substr(0,e.vars.previewContainer.selectionStart)+n+a.substr(e.vars.previewContainer.selectionEnd),e.vars.currentText=l,updatePreviewTextContent(e),e.vars.previewContainer.selectionStart=e.vars.previewContainer.selectionEnd=o+2)}(e,t);break;case"palette":t.palette?function setKeyboardPalette(e,t){var s=t.palette,n=null;n=Object.values(e.vars.activeKeyboard.paletteMap).filter((function(e){return e&&e.name===s}))[0],n?(e.vars.activePalette.element.style.display="none",disableActiveKeyMapListeners(e),e.vars.activePalette=n,e.vars.activeKeyMap=e.vars.activePalette.keyMap,e.vars.activePalette.element.style.display="flex",enableActiveKeyMapListeners(e)):console.error('[Keyboard] - can not find palette with name: "'+s+'"')}(e,t):console.error("[alpha-num-keyboard] Missing palette attribute value on key of type palette");break;case"modifier":var a,l,o,r=t.modify?t.modify.split(":"):null;r&&3===r.length&&(a=r[0],l=r[1],isModifierActive(e,o=r[2])?(shmi.removeClass(s.target,"clipped"),unsetModifier(e,o,l,a,s)):setModifier(e,o,l,a,s));break;case"resolver":!function keyResolver(e,t){var s=t.resolve;if(s)switch(s){case"backspace":deleteLetterFromCurrentText(e);break;case"submit":n("Fire: Submit Keyboard"),shmi.fire("keyboard-submit",{success:!0,input:e.vars.currentText});break;default:n("Missing Default Case")}}(e,t);break;default:n("uncatched keyboard event: "+t.type)}}function setModifier(e,t,s,a,l){if(!isModifierActive(e,t)){var o=getActivePaletteId(e);e.vars.activeModifiers[o]=e.vars.activeModifiers[o]||[],e.vars.activeModifiers[o].push(t),function createModificationTypeListeners(e,t,s,a,l){var o=getRandomId(8);if(e&&t&&s&&a&&l)switch(s){case"clip":e.vars.keyTypeListeners[a][s]=e.vars.keyTypeListeners[a][s]||{},e.vars.keyTypeListeners[a][s][o]=function createClipModifierFunction(e,t,s,n,a,l){return function modClip(o,r){return o===l||r.modify!==n+":"+s+":"+t||(delete e.vars.keyTypeListeners[n][s][a],unsetModifier(e,t,s,n,l),!1)}}(e,t,s,a,o,l);break;case"clipOnce":shmi.addClass(l.target,"clipped"),e.vars.keyTypeListeners[a][s]=e.vars.keyTypeListeners[a][s]||{},e.vars.keyTypeListeners[a][s][o]=function createClipOnceModifierFunction(e,t,s,n,a,l){return function modClipOnce(o,r){return o===l||r.type!==n&&r.modify!==n+":"+s+":"+t||(shmi.removeClass(l.target,"clipped"),delete e.vars.keyTypeListeners[n][s][a],unsetModifier(e,t,s,n,l),!1)}}(e,t,s,a,o,l);break;default:n("Undefined modifier mode",s)}}(e,t,s,a,l),Object.keys(e.vars.activeKeyMap).forEach((function(t){if(e.vars.activeKeyMap[t].type===a){var s=evaluateKeyModifiers(e,e.vars.activeKeyMap[t]);setKeyConfig(e,e.vars.activeKeyMap[t],s)}}))}}function unsetModifier(e,t,s,n,a){if(isModifierActive(e,t)){var l=getActivePaletteId(e),o=e.vars.activeModifiers[l].indexOf(t);e.vars.activeModifiers[l].splice(o,1),Object.keys(e.vars.activeKeyMap).forEach((function(t){var s=evaluateKeyModifiers(e,e.vars.activeKeyMap[t]);setKeyConfig(e,e.vars.activeKeyMap[t],s)}))}}function evaluateKeyModifiers(e,t){const s={},n=shmi.cloneObject(t.modifiers);return shmi.requires("visuals.tools.iterate.iterateObject")(n||{},((n,a)=>{const l=a.split(":");2!==l.length?console.error("[Keyboard] - modifier not configured right",t):isModifierActive(e,l[0])?s[l[1]]=n:"class-name"===l[1]&&(s[l[1]]="!"+n)})),s}function isModifierActive(e,t){var s=getActivePaletteId(e);return e.vars.activeModifiers[s]&&-1!==e.vars.activeModifiers[s].indexOf(t)}function getActivePaletteId(e){return e.vars.activeKeyboard.name.toLowerCase()+":"+e.vars.activePalette.name.toLowerCase()}function removeAllPressedHighlights(e){e.vars.activePalette.element.querySelectorAll(".key.pressed").forEach((function(e){shmi.removeClass(e,"pressed")}))}function removeAllAltKeys(e){clearTimeout(e.vars.altKeysTimeout),e.vars.activePalette.element.querySelectorAll(".key.show-alt-keys").forEach((function(e){shmi.removeClass(e,"show-alt-keys")}))}function fireTypeListeners(e,t,s){var n=shmi.requires("visuals.tools.iterate").iterateObject,a=t.type,l=!1;if(a){var o=e.vars.keyTypeListeners[a];n(o,(function(e,a){n(e,(function(e,n){!1===e(s,t)&&(l=!0)}))}))}return!l}function getKeyByValue(e,t){var s;return(s=Object.values(e.vars.activeKeyMap).filter((function(e){var s=t.key.toLowerCase();return e.name===s}))[0])?e.vars.activeKeyMap[s["data-key-id"]]:null}function deleteLetterFromCurrentText(e,t){var s=String(e.vars.currentText),n=s,a=0;e.vars.previewContainer.selectionStart===e.vars.previewContainer.selectionEnd?0!==e.vars.previewContainer.selectionStart&&(t?""===getSymbols(s.substr(e.vars.previewContainer.selectionStart,e.vars.previewContainer.selectionStart+2))[1]?(n=s.substr(0,e.vars.previewContainer.selectionStart)+s.substr(e.vars.previewContainer.selectionEnd+2),a=e.vars.previewContainer.selectionStart):(n=s.substr(0,e.vars.previewContainer.selectionStart)+s.substr(e.vars.previewContainer.selectionEnd+1),a=e.vars.previewContainer.selectionStart):""===getSymbols(s.substr(e.vars.previewContainer.selectionStart-2,e.vars.previewContainer.selectionStart))[1]?(n=s.substr(0,e.vars.previewContainer.selectionStart-2)+s.substr(e.vars.previewContainer.selectionEnd),a=e.vars.previewContainer.selectionStart-2):(n=s.substr(0,e.vars.previewContainer.selectionStart-1)+s.substr(e.vars.previewContainer.selectionEnd),a=e.vars.previewContainer.selectionStart-1)):(n=s.substr(0,e.vars.previewContainer.selectionStart)+s.substr(e.vars.previewContainer.selectionEnd),a=e.vars.previewContainer.selectionStart),e.vars.currentText=n,updatePreviewTextContent(e),e.vars.previewContainer.selectionStart=e.vars.previewContainer.selectionEnd=a}function getSymbols(e){for(var t=0,s=e.length,n=[];t<s-1;++t){var a=e.charCodeAt(t);a>=55296&&a<=56319&&(a=e.charCodeAt(t+1))>=56320&&a<=57343?(n.push(e.slice(t,t+2)),++t):n.push(e.charAt(t))}return n.push(e.charAt(t)),n}function updatePreviewTextContent(e){if(e.vars.previewContainer)if(e.config["password-input"]){let t="";if(!0===e.vars.showPassword)t=e.vars.currentText;else for(let s=0;s<e.vars.currentText.length;s++)t+="●";e.vars.previewContainer.value=t}else e.vars.previewContainer.value=e.vars.currentText}function onKeyPressListener(e,t,s,n){-1!==n.type.indexOf("mouse")&&-1===n.type.indexOf("touch")?shmi.addClass(e.element,"hover-enabled"):shmi.removeClass(e.element,"hover-enabled"),e.vars.keyPressed=n.target.getAttribute("data-key-name"),e.config["password-input"]?n.preventDefault():shmi.addClass(n.target,"pressed")}function onKeyClickListener(e,t,s,n){var a=n.target.parentNode,l=a.getAttribute("data-key-id"),o=e.vars.activeKeyMap[l];a&&o&&(e.vars.keyPressed=!1,e.vars.mouseMoveKey=null,fireKeyboardClick(e,o,n),fireTypeListeners(e,o,n),e.config["auto-key-focus"]&&document.activeElement!==a&&a.focus())}function onKeyReleaseListener(e,t,s,n){if(e.vars.keyPressed){var a=n.target;shmi.removeClass(a,"pressed")}}function onKeyMouseDownListener(e,t){shmi.removeClass(e.element,"key-preview-enabled");var s=t.target.getAttribute("data-key-name")||!1,n=e.vars.activeKeyMap[t.target.parentElement.getAttribute("data-key-id")];e.vars.keyPressed=s,e.vars.mouseMoveKey=null,e.vars.keyPressed&&n&&n.hold&&!n.alternatives&&setTimeout((function(){if(e.vars.keyPressed===s){e.vars.keyHeld=!0;var a=setInterval((function(){e.vars.keyPressed===s?(fireKeyboardClick(e,n,t),fireTypeListeners(e,n,t)):clearInterval(a)}),120)}}),1e3),n&&n.alternatives&&(e.vars.altKeysTimeout=setTimeout((function(){e.vars.keyPressed===s&&(shmi.removeClass(e.element,"key-preview-enabled"),shmi.addClass(t.target,"show-alt-keys"))}),500))}function onKeyMouseUpListener(e,t){if(e.vars.keyPressed){e.vars.keyPressed=!1;var s=t.target;shmi.removeClass(t.target,"pressed"),e.vars.previewContainer.focus(),e.config["auto-key-focus"]&&document.activeElement!==s&&s.focus(),(s=e.vars.activeKeyMap[s.parentElement.getAttribute("data-key-id")])&&e.vars.mouseMoveKey&&(fireKeyboardClick(e,s,t),fireTypeListeners(e,s,t),e.vars.mouseMoveKey=null)}removeAllAltKeys(e)}function onKeyMouseInListener(e,t){if(e.vars.keyPressed&&!e.config["password-input"]){var s=t.target;e.vars.mouseMoveKey=e.vars.keyHeld?null:s,e.vars.keyPressed=s.getAttribute("data-key-name"),shmi.addClass(s,"pressed")}}function onKeyMouseOutListener(e,t){if(e.vars.keyPressed){var s=t.target;e.vars.mouseMoveKey=null,shmi.removeClass(s,"pressed")}}function onKeyTouchStartListener(e,t){e.config["key-preview"]&&shmi.addClass(e.element,"key-preview-enabled");var s=t.target.getAttribute("data-key-name"),n=e.vars.activeKeyMap[t.target.parentElement.getAttribute("data-key-id")];e.vars.keyPressed=s,e.vars.mouseMoveKey=null,e.vars.activePalette.element.addEventListener("touchend",e.vars.eventListeners.touchEnd),e.vars.activePalette.element.addEventListener("touchmove",e.vars.eventListeners.touchMove),s&&n&&n.hold&&!n.alternatives&&setTimeout((function(){if(e.vars.keyPressed===s){e.vars.keyHeld=!0;var a=setInterval((function(){e.vars.keyPressed===s?(fireKeyboardClick(e,n,t),fireTypeListeners(e,n,t)):clearInterval(a)}),120)}}),1e3),n&&n.alternatives&&(e.vars.altKeysTimeout=setTimeout((function(){e.vars.keyPressed===s&&(shmi.removeClass(e.element,"key-preview-enabled"),shmi.addClass(t.target,"show-alt-keys"))}),500))}function onKeyTouchMoveListener(e,t){if(t.preventDefault(),t.stopPropagation(),e.vars.keyPressed){var s=t.touches[0].clientY,n=t.touches[0].clientX,a=document.elementFromPoint(n,s);if(a){var l=a.getAttribute("data-key-name");l&&a!==e.vars.dragCurrentKey&&(e.vars.keyHeld||l===e.vars.keyPressed||(removeAllPressedHighlights(e),e.config["password-input"]||shmi.addClass(a,"pressed")),e.vars.dragCurrentKey=a,e.vars.keyPressed=l)}}}function onKeyTouchEndListener(e,t){if(e.vars.keyPressed=!1,e.vars.activePalette.element.removeEventListener("touchend",e.vars.eventListeners.touchEnd),e.vars.activePalette.element.removeEventListener("touchmove",e.vars.eventListeners.touchMove),e.vars.dragCurrentKey&&!e.vars.keyHeld){removeAllPressedHighlights(e),e.vars.previewContainer.focus(),e.config["auto-key-focus"]&&document.activeElement!==t.target&&e.vars.dragCurrentKey.focus();var s=e.vars.activeKeyMap[e.vars.dragCurrentKey.parentElement.getAttribute("data-key-id")];s&&(fireKeyboardClick(e,s,t),fireTypeListeners(e,s,t)),e.vars.dragCurrentKey=null}else e.vars.keyHeld=!1;removeAllAltKeys(e)}function onKeyDownListener(e,t){if(e.vars.lastKey&&e.vars.lastKey===t.key)e.config["password-input"]&&t.preventDefault();else{e.vars.lastKey=t.key,shmi.removeClass(e.element,"key-preview-enabled"),shmi.removeClass(e.element,"hover-enabled");var s=getKeyByValue(e,t);if(s&&!e.config["password-input"]&&(shmi.addClass(s.element.firstChild,"pressed"),e.vars.previewContainer&&document.activeElement!==e.vars.previewContainer&&(e.config["auto-key-focus"]||e.vars.previewContainer.focus()),e.vars.currentText=e.vars.previewContainer.value),"Enter"!==t.key||e.config["show-enter"]||shmi.fire("keyboard-submit",{success:!0,input:e.vars.currentText}),e.config["password-input"]){if("v"===t.key&&!0===t.ctrlKey)return navigator.clipboard.readText().then((function(t){for(var n=0;n<t.length;n++)handleKeyHit(s=t.charAt(n),null,e)})),void t.preventDefault();if(!0===t.ctrlKey)return void t.preventDefault();"ArrowLeft"!==t.key&&"ArrowRight"!==t.key&&"ArrowUp"!==t.key&&"ArrowDown"!==t.key&&"Home"!==t.key&&"End"!==t.key&&t.preventDefault(),handleKeyHit(t.key,t,e)}updatePreviewTextContent(e)}}function handleKeyHit(e,t,s){let n=!1;for(var a in s.vars.activeKeyboard.paletteMap)for(var l in s.vars.activeKeyboard.paletteMap[a].keyMap){const o=s.vars.activeKeyboard.paletteMap[a].keyMap[l];if(n)break;o.val!==e||"letter"!==o.type&&"character"!==o.type&&"number"!==o.type?o.modifiers&&o.modifiers["shift:val"]&&o.modifiers["shift:val"]===e&&("letter"===o.type||"character"===o.type||"number"===o.type)?(setModifier(s,"shift","clipOnce","letter",t),fireKeyboardClick(s,o,t),unsetModifier(s,"shift"),n=!0):o.resolve&&o.resolve.toLowerCase()===e.toLowerCase()?(fireKeyboardClick(s,o,t),n=!0):"Delete"===e&&(deleteLetterFromCurrentText(s,!0),n=!0):(fireKeyboardClick(s,o,t),n=!0)}}function onKeyUpListener(e,t){e.vars.lastKey=null,"escape"===t.key.toLowerCase()&&(n("Fire: Close Keyboard"),shmi.fire("keyboard-cancel",{success:!1,input:e.vars.currentText}));var s=getKeyByValue(e,t);s&&!e.config["password-input"]&&shmi.removeClass(s.element.firstChild,"pressed"),e.config["password-input"]?t.preventDefault():e.vars.currentText=e.vars.previewContainer.value,updatePreviewTextContent(e)}shmi.requires("visuals.tools.control-generator").generate(a)}(),function(){var e=null,t=null;function deleteKeyboard(){t&&(shmi.deleteControl(t),t=null),e=null}function defaultkeyboardHandler(s){if(null===t)try{shmi.requires("visuals.handler.default.keyboard"),(e=s)&&function createKeyboard(){var s={},n=shmi.requires("visuals.tools.iterate.iterateObject"),a=null,l=null,o=null;function onKeyboardEnable(){o&&(o.unlisten(),o=null),t.show()}n(e.detail,(function(t,n){s[n]=e.detail[n]})),s.label&&(s.label=shmi.evalString(shmi.localize(s.label),e.detail.param)),t=shmi.createControl("alpha-num-keyboard",document.body,s,"DIV"),a=shmi.listen("keyboard-submit",(function(e){a.unlisten(),l.unlisten(),a=l=null,deleteKeyboard(),shmi.log("Keyboard closed, changes submited",e),s.callback&&"function"==typeof s.callback&&s.callback(!0,e.detail.input)})),l=shmi.listen("keyboard-cancel",(function(e){l.unlisten(),a.unlisten(),l=a=null,deleteKeyboard(),shmi.log("Keyboard closed, changes aborted",e),s.callback&&"function"==typeof s.callback&&s.callback(!1,null)})),t.isActive()?onKeyboardEnable():o=t.listen("enable",onKeyboardEnable),t.enable()}()}catch(e){shmi.log("[Keyboard] - error trying to load controls: Keyboard\n"+e)}}var s=shmi.pkg("visuals.handler.default.keyboard"),n=null;s.register=function(){n&&(console.debug("Keyboard handler was active!"),n.unlisten(),n=null),n=shmi.listen("keyboard-request",defaultkeyboardHandler)},s.deregister=function(){n?(n.unlisten(),n=null):console.debug("Keyboard handler not active!")}}(),shmi.keyboard=function(e){0===shmi.fire("keyboard-request",e,shmi)&&shmi.log("[Keyboard] - Keyboard not found")},shmi.pkg("visuals.controls"),shmi.visuals.controls.Button=function(e,t){shmi.requires("visuals.core.UiAction"),shmi.requires("visuals.io.MouseListener"),shmi.requires("visuals.io.TouchListener");var s=this;s.element=e,s.config=t||{},s.parseAttributes(),shmi.def(s.config,"class-name","button"),shmi.def(s.config,"template","default/button"),shmi.def(s.config,"name",null),shmi.def(s.config,"icon-src",null),shmi.def(s.config,"icon-title",null),shmi.def(s.config,"show-text",!0),shmi.def(s.config,"show-icon",!1),shmi.def(s.config,"label-from-item",!1),shmi.def(s.config,"icon-class",null),shmi.def(s.config,"precision",-1),shmi.def(s.config,"label","button"),shmi.def(s.config,"type",shmi.c("TYPE_STRING")),shmi.def(s.config,"unit-text",null),shmi.def(s.config,"disable-item-lock",!1),shmi.def(s.config,"monoflop",!1),shmi.def(s.config,"monoflop-interval",100),shmi.def(s.config,"monoflop-value",1),shmi.def(s.config,"decimal-delimiter","."),shmi.def(this.config,"auto-precision",!0),shmi.def(this.config,"auto-label",!0),shmi.def(this.config,"auto-unit-text",!0),shmi.def(this.config,"auto-type",!0),s.config["show-text"]=shmi.toBoolean(s.config["show-text"]),s.config["show-icon"]=shmi.toBoolean(s.config["show-icon"]),s.config["label-from-item"]=shmi.toBoolean(s.config["label-from-item"]),s.mouselistener=null,s.touchlistener=null,s.active=!1,s.initialized=!1,s.labelElement=null,s.valueElement=null,s.rafId=0,s._subscriptionTargetId=null,s.vars={tokens:[],monoFlopInterval:0,conditional:null},s.startup()},shmi.visuals.controls.Button.prototype={uiType:"button",events:["press","release","click"],tooltipProperties:["icon-title"],getClassName:function(){return"Button"},onInit:function(){var e=this;shmi.requires("visuals.tools.numericValues").initValueSettings(e);var t=shmi.getUiElement("button-label",e.element);t?e.labelElement=t:shmi.log("[Button] no button-label element provided",1),e.valueElement=shmi.getUiElement("button-value",e.element);var s=shmi.getUiElement("button-icon",e.element);if(s){if(e.config["icon-src"])try{s.setAttribute("src",e.config["icon-src"])}catch(e){shmi.log("[Button] Exception setting icon-src: "+e,2)}else if(e.config["icon-class"]){if("IMG"===s.tagName){var n=document.createElement("div");shmi.addClass(n,"button-icon"),s.parentNode.insertBefore(n,s),s.parentNode.removeChild(s),s=n}e.config["icon-class"].trim().split(" ").forEach((function(e){shmi.addClass(s,e)}))}}else shmi.log("[Button] no button-icon element provided",1);t&&e.config.label&&(t.textContent=shmi.localize(e.config.label)),e.config.action&&(e.action=new shmi.visuals.core.UiAction(e.config.action,e)),!0===e.config["show-text"]&&!0===e.config["show-icon"]?shmi.addClass(e.element,"icon-and-text"):!0===e.config["show-icon"]&&shmi.addClass(e.element,"icon-only");var a=shmi.getUiElement("unit-text",e.element);a&&e.config["unit-text"]&&(a.textContent=shmi.localize(e.config["unit-text"]));var l={},o=shmi.visuals.session;l.onClick=function(t,s,n){null!==o.FocusElement&&(o.FocusElement.blur(),o.FocusElement=null),e.element instanceof HTMLElement?(e.element.focus(),shmi.log("[Button] focused",1)):shmi.log("[Button] only HTMLElements may be focused, type: "+e.element.constructor,1);var a={x:t,y:s,event:n};e.fire("click",a),e.action&&e.action.execute(),e.onClick&&e.onClick(e)},l.onPress=function(t,s,n){shmi.addClass(this.element,"pressed");var a={x:t,y:s,event:n};e.fire("press",a)}.bind(e),l.onRelease=function(t,s,n){shmi.removeClass(e.element,"pressed");var a={x:t,y:s,event:n};e.fire("release",a)};var r=shmi.visuals.io;e.mouselistener=new r.MouseListener(e.element,l),e.touchlistener=new r.TouchListener(e.element,l),e.vars.keyUpListener=function(t){if(e.vars.keyDownOnMe&&("Enter"===t.code||"NumpadEnter"===t.code)&&e.element===document.activeElement){shmi.removeClass(e.element,"pressed");var s=e.element.getBoundingClientRect();l.onClick(s.left+s.width/2,s.top+s.height/2,t),e.vars.keyDownOnMe=!1}},e.vars.keyDownListener=function(t){"Enter"!==t.code&&"NumpadEnter"!==t.code||e.element!==document.activeElement||(shmi.addClass(e.element,"pressed"),e.vars.keyDownOnMe=!0)}},onEnable:function(){var e=this;null!==e.vars.conditional?e.vars.conditional.item!==e.config.item&&(e.vars.conditional.item=e.config.item):e.config.item&&(e.vars.conditional=shmi.createConditional(e.element,e.config.item)),e.vars.conditional&&e.vars.conditional.enable(),e.element.setAttribute("tabindex","0"),e.mouselistener.enable(),e.touchlistener.enable();var t=shmi.requires("visuals.session.ItemManager");if(e.config.item){if(e.config["disable-item-lock"]){var s=t.getItemHandler();s.setValue=function(t){e.setValue(t)},e._subscriptionTargetId=t.subscribeItem(e.config.item,s)}else e._subscriptionTargetId=t.subscribeItem(e.config.item,e);if(e.config.monoflop){var n=e.listen("press",(function(){clearInterval(e.vars.monoFlopInterval),e.vars.monoFlopInterval=setInterval((function(){var s={};s[e.config.item]=e.config["monoflop-value"],t.writeDirect(s,(function(t,s){0!==t&&console.error("[ItemManager] failed to write item:",e.config.item,t,s)}))}),e.config["monoflop-interval"])})),a=e.listen("release",(function(){clearInterval(e.vars.monoFlopInterval)}));e.vars.tokens.push(n,a)}}e.element.addEventListener("keyup",e.vars.keyUpListener,!1),e.element.addEventListener("keydown",e.vars.keyDownListener,!1),shmi.log("[Button] enabled",1)},onDisable:function(){var e=this;e.vars.conditional&&e.vars.conditional.disable(),e.config.item&&shmi.visuals.session.ItemManager.unsubscribeItem(e.config.item,e._subscriptionTargetId),e.element.removeAttribute("tabindex"),e.vars.tokens.forEach((function(e){e.unlisten()})),e.vars.tokens=[],e.mouselistener.disable(),e.touchlistener.disable(),e.element.removeEventListener("keyup",e.vars.keyUpListener),e.element.removeEventListener("keydown",e.vars.keyDownListener),shmi.log("[Button] disabled",1)},onSetValue:function(e){var t=this,s=shmi.requires("visuals.tools.numericValues");!0===t.config["label-from-item"]?t.labelElement&&(shmi.caf(t.rafId),t.rafId=shmi.raf((function(){t.labelElement.textContent=shmi.localize(s.formatOutput(e,t))}))):t.valueElement&&(shmi.caf(t.rafId),t.rafId=shmi.raf((function(){t.valueElement.textContent=s.formatOutput(e,t)})))},onSetProperties:function(e,t,s){shmi.requires("visuals.tools.numericValues").setProperties(this,arguments)},onLock:function(){var e=this;e.mouselistener.disable(),e.touchlistener.disable(),shmi.addClass(e.element,"locked"),shmi.log("[Button] locked",1),e.element.removeAttribute("tabindex"),e.element.removeEventListener("keyup",e.vars.keyUpListener),e.element.removeEventListener("keydown",e.vars.keyDownListener)},onUnlock:function(){var e=this;e.mouselistener.enable(),e.touchlistener.enable(),shmi.removeClass(e.element,"locked"),shmi.log("[Button] unlocked",1),e.element.setAttribute("tabindex",0),e.element.addEventListener("keyup",e.vars.keyUpListener,!1),e.element.addEventListener("keydown",e.vars.keyDownListener,!1)},setLabel:function(e){var t=this;t.config["auto-label"]&&t.labelElement&&(t.labelElement.textContent=shmi.localize(e))},setUnitText:function(e){var t=shmi.getUiElement("unit-text",this.element);this.config["auto-unit-text"]&&t&&(t.textContent=shmi.localize(e))}},shmi.extend(shmi.visuals.controls.Button,shmi.visuals.core.BaseControl),function(){function setBoxValue(e,t){var s=shmi.requires("visuals.session.ItemManager");e.config.item?s.writeValue(e.config.item,t):e.setValue(t)}shmi.pkg("visuals.controls"),shmi.visuals.controls.CheckBox=function(e,t){shmi.requires("visuals.io.MouseListener"),shmi.requires("visuals.io.TouchListener");var s=this;s.element=e,s.config=t||{},s.parseAttributes(),shmi.def(s.config,"class-name","checkbox"),shmi.def(s.config,"template","default/checkbox"),shmi.def(s.config,"name",null),shmi.def(s.config,"on-value",1),shmi.def(s.config,"off-value",0),shmi.def(s.config,"pressedClass","pressed"),shmi.def(s.config,"icon-src",null),shmi.def(s.config,"icon-title",null),shmi.def(s.config,"icon-class",null),shmi.def(s.config,"label","checkbox"),shmi.def(s.config,"auto-label",!0),shmi.def(s.config,"show-icon",!1),shmi.def(s.config,"show-text",!0),shmi.def(this.config,"confirm-off-text","${V_CONFIRM_OFF}"),shmi.def(this.config,"confirm-on-text","${V_CONFIRM_ON}"),shmi.def(this.config,"confirm-on",!1),shmi.def(this.config,"confirm-off",!1),s.value=0,s.initialized=!1,s.active=!1,s._subscriptionTargetId=null,s.mouseListener=null,s.touchListener=null,s.startup()},shmi.visuals.controls.CheckBox.prototype={uiType:"checkbox",events:["change"],tooltipProperties:["icon-title"],getClassName:function(){return"CheckBox"},onInit:function(){var e=this,t=shmi.getUiElement("checkbox-icon",e.element);if(t){if(e.config["icon-src"])try{t.setAttribute("src",e.config["icon-src"])}catch(e){shmi.log("[Checkbox] Exception setting icon-src: "+e,2)}else if(e.config["icon-class"]){if("IMG"===t.tagName){var s=document.createElement("div");shmi.addClass(s,"checkbox-icon"),t.parentNode.insertBefore(s,t),t.parentNode.removeChild(t),t=s}e.config["icon-class"].trim().split(" ").forEach((function(e){shmi.addClass(t,e)}))}}else shmi.log("[Checkbox] no button-icon element provided",1);if(e.element)if(e.config["show-text"]&&e.config["show-icon"]?shmi.addClass(e.element,"icon-and-text"):e.config["show-icon"]&&shmi.addClass(e.element,"icon-only"),e.handleElement=shmi.getUiElement("checkbox-handle",e.element),e.handleElement)if(e.backgroundElement=shmi.getUiElement("checkbox-background",e.element),e.backgroundElement){e.labelElement=shmi.getUiElement("checkbox-label",e.element),e.labelElement&&e.config.label&&(e.labelElement.textContent=shmi.localize(e.config.label)),shmi.addClass(e.handleElement,"hidden");var n={onClick:function(){e.value===e.config["on-value"]?e.config["confirm-off"]?shmi.confirm(e.config["confirm-off-text"],(function onConfirmed(t){t&&setBoxValue(e,e.config["off-value"])})):setBoxValue(e,e.config["off-value"]):e.config["confirm-on"]?shmi.confirm(e.config["confirm-on-text"],(function onConfirmed(t){t&&setBoxValue(e,e.config["on-value"])})):setBoxValue(e,e.config["on-value"])},onPress:function(){shmi.addClass(e.element,e.config.pressedClass)},onRelease:function(){shmi.removeClass(e.element,e.config.pressedClass)}};e.mouseListener=new shmi.visuals.io.MouseListener(e.element,n),e.touchListener=new shmi.visuals.io.TouchListener(e.element,n),shmi.log("[Checkbox] initialized",1)}else shmi.log("[CheckBox] no checkbox-background found in base element",3);else shmi.log("[CheckBox] no checkbox-handle found in base element",3);else shmi.log("[CheckBox] no base element provided",3)},onEnable:function(){var e=this;e.config.item&&(e._subscriptionTargetId=shmi.visuals.session.ItemManager.subscribeItem(e.config.item,e)),e.mouseListener.enable(),e.touchListener.enable(),shmi.log("[CheckBox] enabled",1)},onDisable:function(){var e=this;e.config.item&&shmi.visuals.session.ItemManager.unsubscribeItem(e.config.item,e._subscriptionTargetId),e.mouseListener.disable(),e.touchListener.disable(),shmi.log("[CheckBox] disabled",1)},onLock:function(){var e=this;e.mouseListener.disable(),e.touchListener.disable(),shmi.addClass(e.element,"locked"),shmi.log("[CheckBox] locked",1)},onUnlock:function(){var e=this;e.mouseListener.enable(),e.touchListener.enable(),shmi.removeClass(e.element,"locked"),shmi.log("[CheckBox] unlocked",1)},onSetValue:function(e){var t=this,s=!1;e===t.config["on-value"]?(t.value=t.config["on-value"],s=!0,shmi.removeClass(t.handleElement,"hidden")):(t.value=t.config["off-value"],s=!0,shmi.addClass(t.handleElement,"hidden")),s&&t.fire("change",{value:t.value})},getValue:function(){return this.value},setLabel:function(e){var t=this;t.labelElement&&t.config["auto-label"]&&(t.labelElement.textContent=shmi.localize(e))}},shmi.extend(shmi.visuals.controls.CheckBox,shmi.visuals.core.BaseControl)}(),function(){shmi.pkg("visuals.controls");var e,t=-1,s=1;function isEqualDeepImpl(e,t,s=[]){if(e===t)return!0;if(typeof e!=typeof t||"object"!=typeof e)return!1;if(Array.isArray(e)!==Array.isArray(t))return!1;if(function isKnown(e,t,s){return-1!==s.findIndex((s=>e===s.lhs&&t===s.rhs))}(e,t,s))return!0;if(Array.isArray(e))return e.length===t.length&&(s.push({lhs:e,rhs:t}),e.every(((e,n)=>isEqualDeepImpl(e,t[n],s))));{const n=Object.keys(e);return!!function objectsHaveSameKeys(e,t){const s=Object.keys(e),n=Object.keys(t);return s.length===n.length&&s.every((e=>n.includes(e)))}(e,t)&&(s.push({lhs:e,rhs:t}),n.every((n=>isEqualDeepImpl(e[n],t[n],s))))}}function isEqualSelection(e,t){const s=Object.assign({},e),n=Object.assign({},t);return delete s.dblClicked,delete n.dblClicked,function isEqualDeep(e,t){return isEqualDeepImpl(e,t,[])}(s,n)}function getRowOffset(e,t){let s=null;const n=shmi.requires("visuals.session.DataGridManager").getGrid(e.cConfig.table),a=e.dgSubscription.id;if(t>=0){const l=e.pageBuf.bufferOffset,o=n.getCurrentIDs(a).findIndex((e=>e===t));o>=0&&(s=l+o)}return s}function setLastClicked(e,t){if(t>=0){const s=getRowOffset(e,t);if(null!==s)return e.lastClicked.rowId=t,void(e.lastClicked.offset=s)}e.lastClicked.rowId=-1,e.lastClicked.offset=0}function loadRange(e,t,s,n,a){startLoading(e);const l=shmi.requires("visuals.session.DataGridManager"),o=l.subscribePage(e.cConfig.table,s,n,(s=>{l.getCurrentIDs(e.cConfig.table,o.id).forEach((t=>{e.addRowIdToSelection(t)})),l.unsubscribe(e.cConfig.table,o.id),setLastClicked(e,t),stopLoading(e),e.updateSelTypeFromSelRows(),e.updateDelRowsBtnEnable(),e.updateSelectionView(),clearTimeout(e.sel_fire_to);const n=shmi.cloneObject(e.selection);n.dblClicked=!1,e.sel_fire_to=setTimeout((function(){e.fireSelChanged(n)}),shmi.c("ACTION_RETRY_TIMEOUT")),a()}))}function createTableRow(e,t,s,n){var a=e.cConfig.resp["nof-cols"],l=null,o=null,r="MULTI"===e.cConfig.resp["select-mode"],c="SINGLE"===e.cConfig.resp["select-mode"],u="ITEM"===e.cConfig.resp["select-mode"],m=null,h=e.pageBuf.rows[t];if(h){l=document.createElement("tr"),null===h.rowId&&(l.style.visibility="hidden",h.visible=!1),s.appendChild(l),h.trElem=l,(e.pageBuf.offset+t)%2==0&&shmi.addClass(l,e.uiCssCl.evenRow),r?(e.config["show-select-boxes"]&&(o=document.createElement("td"),m=document.createElement("div"),h.selCB=e.createSelCBox(m,t,!1,e),h.selCB.setChangeCallback((function(t,s){e.locked||e.selectCBoxValChanged(t,s,!1,!1,!0,!1)})),o.appendChild(m),l.appendChild(o)),h.trSelCtrl=e.createSelRowCtrl(l,t,e),h.trSelCtrl.setChangeCallback((function(t,s,n,a,l){e.locked||e.selectCBoxValChanged(t,s,n,a,!1,l)}))):(c||u)&&(h.trSelCtrl=e.createSelRowCtrl(l,t,e),h.trSelCtrl.setChangeCallback((function(t,s,n,a,l){e.locked||e.selectRowValChanged(t,s,n,a,l)})));for(var d=0;d<a;d++)createTableCell(e,t,d,l,n)}else console.error("[ComplexTable2]","missing row descriptor for row ID:",t)}function createTableCell(e,t,s,n,a){var l=e.cConfig.resp["column-org"][s],o=document.createElement("div"),r=document.createElement("td"),c=l.fields.length;r.appendChild(o),n.appendChild(r),shmi.addClass(o,e.uiCssCl.tdCont),a&&l.fields[0]["min-width"]&&(o.style.minWidth=l.fields[0]["min-width"]);for(var u=0;u<c;u++)createCellControl(e,t,s,u,l,o)}function createCellControl(e,t,s,n,a,l){var o,r=shmi.cloneObject(a.fields[n].ctrl.config),c=e.pageBuf.rows[t],u=null===c.rowId?null:e.makeItem(c.rowId,a.fields[n].dgCol),m=shmi.requires("visuals.tools.item-adapter"),h=e.getColumnAdapter(a.fields[n].fieldName);r.item=u,o=shmi.createControl(a.fields[n].ctrl["ui-type"],l,r,"div"),null!==u&&(null===h?m.unsetAdapter(u):m.setAdapter(u,h)),c.cols[s].ctrls.push(o)}function createRowDescriptor(e,t){for(var s={rowId:e,trElem:null,trSelCtrl:null,selCB:null,cols:[],visible:!0},n=0;n<t;n++)s.cols.push({ctrls:[]});return s}function onQuickSearch(e,t){e.qSearchInterval=e.qSearchInterval||null,null===e.qSearchInterval&&(e.qSearchInterval=setTimeout((function(){t.textContent!==e.qSearchOld&&e.quicksearchChanged(t.textContent),e.qSearchOld=t.textContent,e.qSearchInterval=null}),300))}function setPagePositions(e){var t=[e.tbodyElement[0],e.tbodyElement[1],e.tbodyElement[2]],s=e.cConfig["nof-buffered-rows"]/3,n=e.metricsData.lineHeightPx*s;e.vars.pageOrder.forEach((function(s){!function setElementOffset(e,t){e.style.top=t+"px"}(t[s],e.vars.pageOffsets[s]*n)}))}function reinitPages(e,t){var s=e.metricsData.lineHeightPx,n=e.pageBuf.nofTotalRows*s,a=e.cConfig["nof-buffered-rows"]/3,l=e.metricsData.lineHeightPx*a,o=Math.ceil(n/l),r=t/l,c=Math.floor(r);e.vars.pageOffsets=c>=1&&o>3?[c-1,c,c+1]:[0,1,2],e.vars.pageOrder=[0,1,2],setPagePositions(e)}function turnPage(e,t=!1){const s=e.vars.pageOffsets[t?e.vars.pageOrder[0]:e.vars.pageOrder[2]];t?e.vars.pageOrder.unshift(e.vars.pageOrder.pop()):e.vars.pageOrder.push(e.vars.pageOrder.shift()),e.vars.pageOffsets[e.vars.pageOrder[0]]=s-1,e.vars.pageOffsets[e.vars.pageOrder[1]]=s,e.vars.pageOffsets[e.vars.pageOrder[2]]=s+1,setPagePositions(e)}function updatePages(e,n){var a,l=e.metricsData.lineHeightPx,o=e.pageBuf.nofTotalRows*l,r=e.cConfig["nof-buffered-rows"]/3,c=e.metricsData.viewportHeight,u=l*r,m=Math.ceil(o/u),h=n,d=h+c,f=n-e.vars.scrollTop,v=Math.sign(f),g=null,p=null,b=e.pageBuf.offset,y=e.pageBuf.bufferOffset,E=null,C=!1;m>3&&Math.abs(f)<u/2?v===t?(g=(p=e.vars.pageOffsets[e.vars.pageOrder[0]]*u)+u/2,p>0&&h<g&&turnPage(e,!0)):v===s&&(g=(p=e.vars.pageOffsets[e.vars.pageOrder[2]]*u)+u/2,p>0&&d>g&&turnPage(e,!1)):(m>3||e.vars.pageOffsets.some((e=>e>2)))&&(E=e.vars.pageOrder.toString(),reinitPages(e,n),C=!0),a=Math.floor(e.vars.pageOffsets[e.vars.pageOrder[0]]*u/l),e.vars.scrollTop=n,a!==b?(e.pageBuf.offset=a,e.pageBuf.bufferOffset=function calcBufferOffset(e){var t=e.pageBuf.bufferOffset;e.pageBuf.offset<e.pageBuf.bufferOffset?t=Math.max(0,e.pageBuf.offset+e.pageBuf.viewportSize-e.pageBuf.bufferSize):e.pageBuf.offset+e.pageBuf.viewportSize>e.pageBuf.bufferOffset+e.pageBuf.bufferSize&&(t=e.pageBuf.offset);return t}(e),y!==e.pageBuf.bufferOffset?(startLoading(e),e.dgMan.setOffset(e.cConfig.table,e.pageBuf.bufferOffset,e.dgSubscription.id)):e.onDataGridChange(e.dgSubscription.changeInfo)):C&&E!==e.vars.pageOrder.toString()&&e.onDataGridChange(e.dgSubscription.changeInfo)}function applyLineHeight(e){var t=null;e.cConfig.resp["line-height"]&&(e.styleSheet||(t=document.createElement("style"),e.styleSheet=t),e.styleSheet.innerHTML="#"+e.tableId+" .ct2-tdcont { height: "+e.cConfig.resp["line-height"]+"; }",t&&e.element.insertBefore(e.styleSheet,e.element.firstChild))}function startLoading(e){e.loadingCount+=1,1===e.loadingCount&&shmi.addClass(e.element,"loading")}function stopLoading(e){e.loadingCount-=1,e.loadingCount<=0&&(e.loadingCount=0,shmi.removeClass(e.element,"loading"))}shmi.visuals.controls.ComplexTable2=function(e,t){for(this.instID=Date.now();-1!==shmi.visuals.controls.ComplexTable2.instIDs.indexOf(this.instID);)this.instID++;shmi.visuals.controls.ComplexTable2.instIDs.push(this.instID),this.c=shmi.visuals.controls.ComplexTable2.c,this.uiElName=shmi.visuals.controls.ComplexTable2.uiElName,this.uiCssCl=shmi.visuals.controls.ComplexTable2.uiCssCl,this.element=e,this.config=t||{},this.loadingCount=0,this.lastClicked={rowId:null,offset:0},this.parseAttributes(),shmi.def(this.config,"class-name","complex-table2"),shmi.def(this.config,"template","default/complex-table2"),shmi.def(this.config,"name",null),shmi.def(this.config,"label","complex-table2"),shmi.def(this.config,"table","undefined-table"),shmi.def(this.config,"item-selected-row",null),shmi.def(this.config,"rows-items-from-1",!0),shmi.def(this.config,"field-datagrid-col-map",[]),shmi.def(this.config,"default-field-control-map",{}),shmi.def(this.config,"default-field-headers",{}),shmi.def(this.config,"default-layout",{}),shmi.def(this.config,"select-mode","MULTI"),shmi.def(this.config,"show-select-boxes",!0),shmi.def(this.config,"text-mode","NORMAL"),shmi.def(this.config,"show-nof-rows",!1),shmi.def(this.config,"delete-selected-rows",!1),shmi.def(this.config,"useDgIndex",!1),shmi.def(this.config,"col-width-changeable",!1),shmi.def(this.config,"cols-show-hide",!1),shmi.def(this.config,"cols-movable",!1),shmi.def(this.config,"rows-movable",!1),shmi.def(this.config,"sortable-fields",[]),shmi.def(this.config,"default-text-filter-fields",[]),shmi.def(this.config,"filters",[]),shmi.def(this.config,"default-nof-buffered-rows",this.c.MIN_BUF_SIZE),shmi.def(this.config,"show-buttons-table-min-width-px",300),shmi.def(this.config,"edit-mode-active",!1),shmi.def(this.config,"fieldIcons",{}),shmi.def(this.config,"headerMode","ICON"),shmi.def(this.config,"adapterSelectConfig",{"class-name":"select-box no-label"}),shmi.def(this.config,"toggle-selection",!0),shmi.def(this.config,"double-click-events",!1),shmi.def(this.config,"adapterSelectClass","adapter-select"),shmi.def(this.config,"edit-mode-map",{}),this.cConfig={},this.filterData={},this.colTextFilterData={},this.ctrlPanelData={},this.header={},this.colTxtFilters={},this.pageBuf={},this.asyncProcData={},this.metricsData={},this.selection={type:this.c.SELECT_TYPE_NOTHING,selRows:[],selRowIndex:[],dblClicked:!1},this.lastSelection=null,this.scrollBar=null,this.dgMan=null,this.dgSubscription={},this.selChgEventListeners={},this.tcElement=null,this.bodyViewportElement=null,this.tabCCElement=null,this.tabHCElement=null,this.theadElement=null,this.txtFiltersHeadElement=null,this.tbodyElement=[],this.labelElement=null,this.footerElement=null,this.ctrlPanelElement=null,this.resizeDebounceTimeout=null,this.sbSliderDebounceTimeout=null,this.vpReleaseDebounceTimeout=null,this.swipeVertDebounceTimeout=null,this.cLayoutClass=null,this.isTableToCleanup=!1,this.isTouchDevice=!1,this.lastTableVpWidth=-1,this.lastTableVpHeight=-1,this.lastLayoutId=-100,this.applyFiltersEnable=!1,this.subscrIdItemSelRow=null,this.selRowByItem=0,this.editMode=!1,this.editRow=-1,this.headerMode="TEXT",this.controls=[],this.vars={lastUpdate:0,updateTimeout:0,scrollTop:0,pageOffsets:[0,1,2],pageOrder:[0,1,2]},this.startup()},shmi.visuals.controls.ComplexTable2.prototype={_tableIds:{},uiType:"complex-table2",isContainer:!0,events:["select"],getClassName:function(){return"ComplexTable2"},setEditMode:function(e){this.editMode=e},getSelectedRows:function(){return shmi.cloneObject(this.selection)},getSelectionRowData:function(e){var t=this,s=[];return e&&e.selRows.length>0&&(s=e.selRows.map((e=>t.dgMan.getRowData(t.config.table,e)))),s},setSelectedRows:function(e){shmi.checkArg("selection",e,"object"),shmi.checkArg("selection.type",e.type,"number"),shmi.checkArg("selection.selRows",e.selRows,"array"),shmi.checkArg("selection.selRowIndex",e.selRowIndex,"array"),shmi.checkArg("selection.dblClicked",e.dblClicked,"boolean","undefined"),Object.assign(this.selection,{type:this.c.SELECT_TYPE_NOTHING,selRows:[],selRowIndex:[],dblClicked:!1},shmi.cloneObject(e)),this.updateSelectionView();var t=this;clearTimeout(t.sel_fire_to),t.sel_fire_to=setTimeout((function(){t.fireSelChanged(shmi.cloneObject(t.selection))}),shmi.c("ACTION_RETRY_TIMEOUT"))},addSelChgEventListener:function(e){for(var t=Date.now();void 0!==this.selChgEventListeners[t];)t++;return this.selChgEventListeners[t]={listener:e},shmi.log("[ComplexTable2] addSelChgEventListener called, listenerObj: "+e+" - id:"+t,1),t},removeSelChgEventListener:function(e){void 0!==this.selChgEventListeners[e]?delete this.selChgEventListeners[e]:shmi.log("[ComplexTable2] removeSelChgEventListener - id "+e+" does not exist",2),shmi.log("[ComplexTable2] removeSelChgEventListener called, id: "+e,1)},onInit:function(){var e=this,t=0;if(e.headerMode="ICON"===e.config.headerMode?"ICON":"TEXT",e.tableId=function getTableId(e){for(var t="ct2-instance-",s=0;void 0!==shmi.visuals.controls.ComplexTable2.prototype._tableIds[t+s];)s+=1;return shmi.visuals.controls.ComplexTable2.prototype._tableIds[t+s]=!0,t+s}(),e.element.setAttribute("id",e.tableId),!0===shmi.toBoolean(e.config["edit-mode-active"])&&(e.editMode=!0),this.isTouchDevice=this.detectTouchDevice(),this.isTouchDevice?shmi.addClass(this.element,this.uiCssCl.touchDev):shmi.addClass(this.element,this.uiCssCl.noTouchDev),this.buildCCfgRespIndep(),this.buildCCfgRespDep(),this.dgMan=shmi.visuals.session.DataGridManager,this.tcElement=shmi.getUiElement(this.uiElName.tabContainer,this.element),this.tcElement)if(this.theadElement=shmi.getUiElement(this.uiElName.thead,this.element),this.theadElement)if(this.txtFiltersHeadElement=shmi.getUiElement(this.uiElName.txtFiltersHead,this.element),this.txtFiltersHeadElement||shmi.log("[ComplexTable2] no "+this.uiElName.txtFiltersHead+" element provided (optional)",1),this.tableElement=shmi.getUiElement(this.uiElName.table,this.element),this.tableElement){var s=shmi.getUiElements(this.uiElName.tbody,this.element);for(this.tbodyElement=[],t=0;t<s.length;t++)this.tbodyElement.push(s[t]);if(this.tbodyElement[0])if(this.bodyViewportElement=shmi.getUiElement(this.uiElName.tbodyContainer,this.element),this.bodyViewportElement)if(this.tabCCElement=shmi.getUiElement(this.uiElName.tabContContainer,this.element),this.tabCCElement){var n;if(this.labelElement=shmi.getUiElement(this.uiElName.label,this.element),this.labelElement?this.labelElement.textContent=shmi.localize(this.cConfig.label):shmi.log("[ComplexTable2] no "+this.uiElName.label+" element provided (optional)",1),this.footerElement=shmi.getUiElement(this.uiElName.footer,this.element),this.footerElement||shmi.log("[ComplexTable2] no "+this.uiElName.footer+" element provided (optional)",1),this.ctrlPanelElement=shmi.getUiElement(this.uiElName.ctrlPanel,this.element),this.ctrlPanelElement||shmi.log("[ComplexTable2] no "+this.uiElName.ctrlPanelElement+" element provided (optional)",1),this.initScrollHandler(),this.updateSize=function(){clearTimeout(this.resizeDebounceTimeout),this.resizeDebounceTimeout=setTimeout(function(){this.resizeDebounceTimeout=null,this.processEvtOnResize()}.bind(this),this.c.DEBOUNCE_TO_RESIZE)}.bind(this),applyLineHeight(e),this.cleanupTabContent(),this.cleanupAsyncProcessing(),this.clearSelection(),this.clearFilterData(),this.clearColTextFilterData(),this.isTabSizeChanged(),this.isLayoutChanged(),shmi.log("[ComplexTable2] initialized",1),e=this,shmi.isRegistered(this.element,this.uiType))for(n=shmi.parseControls(this.tcElement,!1,this.element),t=0;t<n.length;t++)e.controls.push(n[t]);else var a=this.listen("register",(function(){for(n=shmi.parseControls(e.tcElement,!1,e.element),t=0;t<n.length;t++)e.controls.push(n[t]);e.unlisten("register",a)}));e.adapterItems=[],shmi.requires("visuals.tools.iterate.iterateObject")(e.config.adapterSettings,(function(t,s){var n={field:s,item:null,gridName:e.config.table,options:t},a="virtual:"+e.getAdapterNS()+":"+s;n.item=shmi.createVirtualItem(a,shmi.c("TYPE_INT"),0,1e3,0,e._getAdapterHandler(e,n)),e.adapterItems.push(n)}))}else shmi.log("[ComplexTable2] no "+this.uiElName.tabContContainer+" element provided (required)",3);else shmi.log("[ComplexTable2] no "+this.uiElName.tbodyContainer+" element provided (required)",3);else shmi.log("[ComplexTable2] no "+this.uiElName.tbody+" element provided (required)",3)}else shmi.log("[ComplexTable2] no "+this.uiElName.table+" element provided (required)",3);else shmi.log("[ComplexTable2] no "+this.uiElName.thead+" element provided (required)",3);else shmi.log("[ComplexTable2] no "+this.uiElName.tabContainer+" element provided (required)",3)},_getAdapterHandler:function(e,t){return function(s){var n=null,a=shmi.visuals.session.ItemManager,l=shmi.requires("visuals.tools.item-adapter"),o=[],r=shmi.requires("visuals.tools.iterate.iterateObject"),c=e.getDataColNo(t.field);t.options.forEach((function(e,t){e.value===s&&(n=e.adapter)})),r(a.items,(function(e,s){if(0===s.indexOf("virtual:grid:"+t.gridName)){var n=s.split(":");parseInt(n[4])===c&&o.push(e)}})),null===n?o.forEach((function(e,t){l.unsetAdapter(e.name)})):o.forEach((function(e,t){l.setAdapter(e.name,n)}))}},onEnable:function(){const e=this;let t=null,s=!1;this.enableEvents(),this.updateRespDepContent(!0),this.cleanupMetrics(),this.cConfig.table&&(t=this.dgMan.getGrid(this.cConfig.table),t&&(t.clearFilter(-1),e.cConfig.quicksearch&&e.cConfig.quicksearch.enable&&e.cConfig.quicksearch.remember&&"string"==typeof e.qSearchOld&&(e.ctrlPanelData.qSearchInput.setValue(e.qSearchOld),e.quicksearchChanged(e.qSearchOld)))),this.setApplyFiltersEnable(!0),this.cConfig.table&&this.dgMan.getGrid(this.cConfig.table)&&(startLoading(e),this.dgSubscription=this.dgMan.subscribePage(this.cConfig.table,0,this.cConfig["buffer-size"],(t=>{stopLoading(e),this.testlog&&console.log("***** datagridChange",t),this.dgSubscription.changeInfo=t,this.onDataGridChange(t),s||(s=!0,e.processEvtOnResize())})),this.checkDgIndexFields(),this.cConfig["item-selected-row"]&&"undefined-item"!==this.cConfig["item-selected-row"]&&(this.selRowByItem=0,this.subscrIdItemSelRow=shmi.visuals.session.ItemManager.subscribeItem(this.cConfig["item-selected-row"],this))),window.addEventListener("resize",this.updateSize,!0),window.addEventListener("visuals-layout-change",this.updateSize,!0),this.controls.forEach((function(e){e.enable()})),shmi.log("[ComplexTable2] enabled",1)},resetQuickSearch:function(){var e=this;e.cConfig.quicksearch&&e.cConfig.quicksearch.enable&&(e.qSearchOld=null,e.isActive()&&(e.ctrlPanelData.qSearchInput.setValue(""),e.quicksearchChanged("")))},setQuickSearch:function(e){var t=this,s=e;t.cConfig.quicksearch&&t.cConfig.quicksearch.enable&&(null==s?s="":"string"!=typeof s&&(s=String(s)),t.isActive()&&t.qSearchOld!==s&&(t.ctrlPanelData.qSearchInput.setValue(s),t.quicksearchChanged(s)))},onDisable:function(){this.pageBuf.rows&&this.pageBuf.rows.forEach((function(e,t){e.trSelCtrl&&e.trSelCtrl.rsMouseListener&&(e.trSelCtrl.rsMouseListener.disable(),e.trSelCtrl.rsTouchListener.disable()),e.selCB&&e.selCB.cbMouseListener&&(e.selCB.cbMouseListener.disable(),e.selCB.cbTouchListener.disable())})),this.cleanupAsyncProcessing(),this.dgSubscription&&(this.dgMan.unsubscribe(this.cConfig.table,this.dgSubscription.id),this.dgSubscription=null),this.disableEvents(),this.cleanupTabContent(),this.subscrIdItemSelRow&&shmi.visuals.session.ItemManager.unsubscribeItem(this.cConfig["item-selected-row"],this.subscrIdItemSelRow),this.quicksearchHandler&&this.quicksearchValueElement&&(this.quicksearchValueElement.removeEventListener("keyup",this.quicksearchHandler),this.vars.qSearchToken&&this.vars.qSearchToken.unlisten(),this.quicksearchValueElement=null,this.quicksearchHandler=null),this.cConfig.quicksearch&&this.cConfig.quicksearch.enable&&this.cConfig.quicksearch.remember||(this.qSearchOld=null),this.selection={type:this.c.SELECT_TYPE_NOTHING,selRows:[],selRowIndex:[]},this.lastSelection=null,setLastClicked(this,-1),window.removeEventListener("resize",this.updateSize,!0),window.removeEventListener("visuals-layout-change",this.updateSize,!0),shmi.log("[ComplexTable2] disabled",1)},onDelete:function(){var e=this;e.header.cols&&e.header.cols.forEach((function(e,t){e.ctrls[0].cbMouseListener&&(e.ctrls[0].cbMouseListener.disable(),e.ctrls[0].cbTouchListener.disable())})),e.ctrlPanelData.filter&&e.ctrlPanelData.filter.items.forEach((function(e,t){shmi.visuals.session.ItemManager.removeItem(e.name)})),e.onBodyScroll&&e.bodyViewportElement&&e.bodyViewportElement.removeEventListener("scroll",e.onBodyScroll),function releaseTableId(e,t){delete shmi.visuals.controls.ComplexTable2.prototype._tableIds[t]}(0,e.tableId),e.element.removeAttribute("id")},onDataGridChange:function(e){var t=this;if(e&&"OK"===e.status){t.isTableToCleanup&&(t.cleanupTabContent(),t.isTableToCleanup=!1);var s=t.dgMan.getCurrentIDs(t.cConfig.table,t.dgSubscription.id);t.pageBuf.rows.length===t.pageBuf.viewportSize?s.length<=t.pageBuf.bufferSize&&e.offset===t.pageBuf.bufferOffset?(t.pageBuf.size=s.length,t.pageBuf.nofTotalRows!==e.totalRows&&(t.pageBuf.nofTotalRows=e.totalRows,t.tableElement.style.height=t.pageBuf.nofTotalRows*t.metricsData.lineHeightPx+"px"),t.updateTable(e,s)):(t.cleanupTabContent(),t.reinitTable(e,s,!0)):(t.cleanupTabContent(),t.reinitTable(e,s)),t.findSelectionAfterRefresh(),t.updateNofRowsDisplay(),t.updateSelectionView()}},onSetValue:function(e,t,s){var n=-1;s===this.cConfig["item-selected-row"]&&(-1!==e&&(n=this.cConfig["rows-items-from-1"]?e-1:e),this.selRowByItem=n,this.updateSelectionView())},buildCCfgRespIndep:function(){if(this.cConfig.name=this.config.name,this.cConfig.label=this.config.label,this.cConfig["class-name"]=this.config["class-name"],this.cConfig.template=this.config.template,this.cConfig.table=this.config.table,this.cConfig["item-selected-row"]=this.config["item-selected-row"],this.cConfig["rows-items-from-1"]=this.config["rows-items-from-1"],this.config["field-datagrid-col-map"]?this.cConfig["field-datagrid-col-map"]=this.config["field-datagrid-col-map"]:this.cConfig["field-datagrid-col-map"]=null,this.cConfig["delete-selected-rows"]=shmi.toBoolean(this.config["delete-selected-rows"]),this.cConfig.filters=this.config.filters,this.cConfig.quicksearch=this.config.quicksearch,this.cConfig["nof-buffered-rows"]=shmi.toNumber(this.config["default-nof-buffered-rows"]),this.config["buffer-size"]&&this.config["buffer-size"]>this.c.MIN_BUF_SIZE?this.cConfig["buffer-size"]=this.config["buffer-size"]:this.cConfig["buffer-size"]=this.c.MIN_BUF_SIZE,this.config["delete-selected-rows-button-config"]&&(this.cConfig["delete-selected-rows-button-config"]=this.config["delete-selected-rows-button-config"]),this.config["default-filter-button-config"]&&(this.cConfig["default-filter-button-config"]=this.config["default-filter-button-config"]),this.config["browser-dependencies"])for(var e=this.config["browser-dependencies"],t=navigator.userAgent,s=0;s<e.length;s++){if(new RegExp(e[s].userAgentDetectRegEx).test(t)){e[s]["nof-buffered-rows"]&&(this.cConfig["nof-buffered-rows"]=shmi.toNumber(e[s]["nof-buffered-rows"]));break}}this.cConfig["show-buttons-table-min-width-px"]=shmi.toNumber(this.config["show-buttons-table-min-width-px"]);var n=this.cConfig["nof-buffered-rows"],a=0;n%3!=0&&(a=3*Math.ceil(n/3),this.cConfig["nof-buffered-rows"]=a,this.cConfig["nof-buffered-rows"]>this.cConfig["buffer-size"]&&(this.cConfig["buffer-size"]=this.cConfig["nof-buffered-rows"]),console.info("[ComplexTable2] nof-buffered-rows must be a multiple of 3, has been corrected to "+a))},buildCCfgRespDep:function(){const e=shmi.requires("visuals.tools.iterate.iterateObject");var t;this.cConfig.resp={},this.cConfig.resp["v-scroll-options"]=this.config["v-scroll-options"],this.cConfig.resp["h-scroll-options"]=this.config["h-scroll-options"],this.cConfig["item-selected-row"]&&"undefined-item"!==this.cConfig["item-selected-row"]?this.cConfig.resp["select-mode"]="ITEM":this.cConfig.resp["select-mode"]=this.config["select-mode"],this.cConfig.resp["text-mode"]=this.config["text-mode"],this.cConfig.resp["show-nof-rows"]=this.config["show-nof-rows"],this.cConfig.resp["col-width-changeable"]=this.config["col-width-changeable"],this.cConfig.resp["cols-show-hide"]=this.config["cols-show-hide"],this.cConfig.resp["cols-movable"]=this.config["cols-movable"],this.cConfig.resp["rows-movable"]=this.config["rows-movable"],this.cConfig.resp["sortable-fields"]=this.config["sortable-fields"],this.cConfig.resp["text-filter-fields"]=this.config["default-text-filter-fields"],this.cConfig.resp["toggle-selection"]=(this.config["toggle-selection"]??!0)&&"MULTI"!==this.cConfig.resp["select-mode"],this.cConfig.resp["double-click-events"]=(this.config["double-click-events"]??!1)&&!this.cConfig.resp["toggle-selection"],this.cConfig.quicksearch&&this.cConfig.quicksearch.enable&&(this.cConfig.resp["text-filter-fields"]=this.cConfig.quicksearch.fields),this.config["default-text-filter-input-field-config"]&&(this.cConfig.resp["text-filter-input-field-config"]=this.config["default-text-filter-input-field-config"]),this.config["default-text-filter-clear-button-config"]&&(this.cConfig.resp["text-filter-clear-button-config"]=this.config["default-text-filter-clear-button-config"]);var s=this.config["default-layout"];s["class-name"]?this.cConfig.resp["layout-class-name"]=s["class-name"]:this.cConfig.resp["layout-class-name"]=null,s["line-height"]?this.cConfig.resp["line-height"]=s["line-height"]:this.cConfig.resp["line-height"]="40px",this.cConfig.resp["column-org"]=[];var n,a=s["column-org"],l=this.cConfig.resp["column-org"],o=0;e(a,((e,s)=>{if("col"===s.substr(0,3).toLowerCase()){n=parseInt(s.substring(3))-1;const a=l[n]={},r=e.fields,c=r.length;let u=!1;for(a.fields=[],t=0;t<c;t++)a.fields[t]={},a.fields[t]["min-width"]=e["min-width"],a.fields[t]["column-width"]=e["column-width"],a.fields[t].fieldName=r[t],a.fields[t].dgCol=this.getDataColNo(r[t]),a.fields[t].header=this.getHeaderCaption(r[t]),a.fields[t].icon=this.config.fieldIcons[r[t]],a.fields[t].isSortable=this.getFldSortable(r[t]),a.fields[t].hasTextFilter=this.getFldHasTextFilter(r[t]),a.fields[t].hasTextFilter&&(u=!0),a.fields[t].ctrl=this.getCtrlDef(r[t]);a.hasTextFilter=u,o++}}));var r=l.length;if(this.cConfig.resp["nof-cols"]=r,r!==o&&shmi.log("[ComplexTable2] buildCCfgRespDep - error in default-layout: there must be defined col1 till coln without gaps and duplicates",3),this.cConfig.resp["layout-id"]=-1,this.config["responsive-layouts"]){var c=null,u=this.getTableWidth(),m=this.config["responsive-layouts"],h=m.length;for(t=0;t<h;t++)if(u<=m[t]["table-max-width-px"]){c=m[t],this.cConfig.resp["layout-id"]=t;break}c&&("ICON"===c.headerMode?this.cConfig.resp.headerMode="ICON":this.cConfig.resp.headerMode="TEXT",c["line-height"]&&(this.cConfig.resp["line-height"]=c["line-height"]),void 0!==c["v-scroll-options"]&&(this.cConfig.resp["v-scroll-options"]=c["v-scroll-options"]),void 0!==c["h-scroll-options"]&&(this.cConfig.resp["h-scroll-options"]=c["h-scroll-options"]),void 0!==c["select-mode"]&&(this.cConfig.resp["select-mode"]=c["select-mode"]),void 0!==c["text-mode"]&&(this.cConfig.resp["text-mode"]=c["text-mode"]),void 0!==c["show-nof-rows"]&&(this.cConfig.resp["show-nof-rows"]=c["show-nof-rows"]),void 0!==c["col-width-changeable"]&&(this.cConfig.resp["col-width-changeable"]=c["col-width-changeable"]),void 0!==c["cols-show-hide"]&&(this.cConfig.resp["cols-show-hide"]=c["cols-show-hide"]),void 0!==c["cols-movable"]&&(this.cConfig.resp["cols-movable"]=c["cols-movable"]),void 0!==c["rows-movable"]&&(this.cConfig.resp["rows-movable"]=c["rows-movable"]),void 0!==c["sortable-fields"]&&(this.cConfig.resp["sortable-fields"]=c["sortable-fields"]),void 0!==c["class-name"]&&(this.cConfig.resp["layout-class-name"]=c["class-name"]),void 0!==c["text-filter-fields"]&&(this.cConfig.resp["text-filter-fields"]=c["text-filter-fields"]),void 0!==c["text-filter-input-field-config"]&&(this.cConfig.resp["text-filter-input-field-config"]=c["text-filter-input-field-config"]),void 0!==c["text-filter-clear-button-config"]&&(this.cConfig.resp["text-filter-clear-button-config"]=c["text-filter-input-field-config"]),a=c["column-org"],l=this.cConfig.resp["column-org"],e(a,((e,s)=>{if("col"===s.substr(0,3).toLowerCase())if(n=parseInt(s.substring(3))-1,"string"==typeof(e=a[s])||e instanceof String){var o=parseInt(e.substring(3))-1;l[n]=l[o]}else{const s=l[n]={},a=e.fields,o=a.length;let u=!1;for(s.fields=[],t=0;t<o;t++){s.fields[t]={},s.fields[t].fieldName=a[t],s.fields[t].dgCol=this.getDataColNo(a[t]);var r=null;e["field-headers"]&&(r=e["field-headers"]),s.fields[t].header=this.getHeaderCaption(a[t],r),s.fields[t].icon=this.config.fieldIcons[a[t]],s.fields[t].isSortable=this.getFldSortable(a[t]),s.fields[t].hasTextFilter=this.getFldHasTextFilter(a[t]),s.fields[t].hasTextFilter&&(u=!0);var c=null;e["field-control-map"]&&(c=e["field-control-map"]),s.fields[t].ctrl=this.getCtrlDef(a[t],c)}s.hasTextFilter=u}})),(r=n+1)<l.length?(l.splice(r,l.length-r),this.cConfig.resp["nof-cols"]=r):r>this.cConfig.resp["nof-cols"]&&shmi.log("[ComplexTable2] buildCCfgRespDep, it is impossible to extent the number of columns in responsive-layouts",3))}},checkDgIndexFields:function(){var e=this.dgMan.getGrid(this.cConfig.table);e&&"function"==typeof e.getIndexFields?(this.cConfig.indexFields=e.getIndexFields(),this.cConfig.indexFields.length>0&&(this.cConfig.useDgIndex=!0)):shmi.log("[ComplexTable2] No index found in datagrid",1)},getDataColNo:function(e){var t=this.cConfig["field-datagrid-col-map"][e];return void 0===t?(t=0,shmi.log("[ComplexTable2] getDataColNo, unknown fldName "+e,3)):t=shmi.toNumber(t),t},getFldSortable:function(e){var t=!1;return-1!==this.cConfig.resp["sortable-fields"].indexOf(e)&&(t=!0),t},getFldHasTextFilter:function(e){var t=!1;return-1!==this.cConfig.resp["text-filter-fields"].indexOf(e)&&(t=!0),t},getCtrlDef:function(e,t){var s;return t&&(s=t[e])||(s=this.config["default-field-control-map"][e]),s||(s={},shmi.log("[ComplexTable2] getCtrlDef, unknown fldName "+e,3)),s},getHeaderCaption:function(e,t){var s;if(t){if(null===(s=t[e]))return null;s||(s=this.config["default-field-headers"][e])}else s=this.config["default-field-headers"][e];return s||(s="",shmi.log("[ComplexTable2] getHeaderCaption, unknown fldName "+e,3)),s},getColumnAdapter:function(e){var t=this,s=null;if(t.config.adapterSettings&&void 0!==t.config.adapterSettings[e]){var n=t.config.adapterSettings[e],a=null;t.adapterItems.forEach((function(t,s){t.field===e&&(a=t.item.readValue())})),n.forEach((function(e,t){a===e.value&&(s=e.adapter)}))}return s},getChildCtrlConfig:function(e,t){var s=null;return e?s=shmi.cloneObject(e):t&&(s=shmi.cloneObject(t)),s},processAsyncMetricsUpdate:function(e){var t=this,s=shmi.requires("visuals.task"),n=[],a=null;t.controls.forEach((function(e,t){if(!e.isActive()){var a=s.createTask("table-control-#"+(t+1));a.run=function(){var t=e.listen("enable",(function(e){t.unlisten(),a.complete()}))},n.push(a)}})),(a=s.createTaskList(n,!1)).onComplete=function(){var s=0;t.active&&(t.updateMetricsData(e),t.processTabReinitDependencies(),"number"==typeof e&&((s=t.tableElement.getBoundingClientRect().height)>=e+t.metricsData.viewportHeight?t.bodyViewportElement.scrollTop=e:t.bodyViewportElement.scrollTop=Math.max(0,s-t.metricsData.viewportHeight)))},0===n.length?a.onComplete():a.run()},processEvtOnResize:function(){var e=this;this.initialized&&(this.buildCCfgRespDep(),applyLineHeight(e),this.isTabSizeChanged()&&(this.currentScrollEvtType=this.c.SCROLL_EVT_TYPE_RESIZE,this.cleanupTabContent(),this.cleanupAsyncProcessing(),this.findSelectionAfterRefresh(),this.clearFilterData(),this.clearColTextFilterData(),this.updateRespDepContent(!0),this.cleanupMetrics(),this.dgSubscription&&this.dgSubscription.changeInfo&&(e.cleanupTabContent(),e.reinitTable(this.dgSubscription.changeInfo,e.dgMan.getCurrentIDs(e.cConfig.table,e.dgSubscription.id)))))},clearSelection:function(){var e=this;this.selection.type=this.c.SELECT_TYPE_NOTHING,this.selection.selRows=[],this.selection.selRowIndex=[],this.selection.dblClicked=!1,this.updateDelRowsBtnEnable(),-1!==e.editRow&&(e.resetBufferRow(e.editRow),e.editRow=-1),clearTimeout(e.sel_fire_to),e.sel_fire_to=setTimeout((function(){e.fireSelChanged(shmi.cloneObject(e.selection))}),shmi.c("ACTION_RETRY_TIMEOUT"))},findSelectionAfterRefresh:function(){const e=this,t=e.dgMan.getGrid(e.cConfig.table);if(t&&this.cConfig.useDgIndex){if(this.selection.type===this.c.SELECT_TYPE_SEL_ROWS){const s=shmi.cloneObject(this.selection);s.selRowIndex.forEach((function(n,a){const l=t.searchIndexRowId(n);if(-1===l)e.removeRowIdFromSelection(s.selRows[a]);else if(l!==s.selRows[a]){const t=e.selection.selRows.indexOf(s.selRows[a]);t>-1&&(e.selection.selRows[t]=l)}}))}this.selection&&this.selection.selRows.length>0?this.selection.type=this.c.SELECT_TYPE_SEL_ROWS:this.selection.type=this.c.SELECT_TYPE_NOTHING,this.selection.dblClicked=!1,this.updateDelRowsBtnEnable(),-1!==e.editRow&&(e.resetBufferRow(e.editRow),e.editRow=-1),clearTimeout(e.sel_fire_to),e.sel_fire_to=setTimeout((function(){e.fireSelChanged(shmi.cloneObject(e.selection))}),shmi.c("ACTION_RETRY_TIMEOUT"))}else this.clearSelection()},updateSelectionView:function(){this.testlog&&console.log("*** update selection view",this.selection.selRows,this.selection.selRowIndex.toString());var e="MULTI"===this.cConfig.resp["select-mode"],t="SINGLE"===this.cConfig.resp["select-mode"];if("ITEM"===this.cConfig.resp["select-mode"])this.setAllRowSelectors(this.c.CB_UNCHK),this.setRowSelectorByDgRow(this.selRowByItem,this.c.CB_CHK);else switch(this.selection.type){case this.c.SELECT_TYPE_NOTHING:e?(this.setAllCheckBoxes(this.c.CB_UNCHK),this.setAllRowSelectors(this.c.CB_UNCHK)):t&&this.setAllRowSelectors(this.c.CB_UNCHK);break;case this.c.SELECT_TYPE_ALL:e?(this.setAllCheckBoxes(this.c.CB_CHK),this.setAllRowSelectors(this.c.CB_CHK)):shmi.log("[ComplexTable2] updateSelectionView, it is impossible to select all rows in single select mode",2);break;default:if(e){this.setAllCheckBoxes(this.c.CB_UNCHK),this.setAllRowSelectors(this.c.CB_UNCHK),this.header.selAllCBox&&this.header.selAllCBox.setState(this.c.CB_UNDEF);for(var s=this.dgMan.getCurrentIDs(this.cConfig.table,this.dgSubscription.id),n=0;n<this.selection.selRows.length;n++)-1!==s.indexOf(this.selection.selRows[n])&&(this.setCheckBox(this.selection.selRows[n],this.c.CB_CHK),this.setRowSelector(this.selection.selRows[n],this.c.CB_CHK))}else t&&(this.setAllRowSelectors(this.c.CB_UNCHK),this.selection.selRows.forEach(function(e){this.setRowSelector(e,this.c.CB_CHK)}.bind(this)))}},setAllCheckBoxes:function(e){var t=this;t.header.selAllCBox&&t.header.selAllCBox.setState(e),t.pageBuf.rows.forEach((function(t){t.selCB&&t.selCB.setState(e)}))},setCheckBox:function(e,t){var s=this.searchRowId(e);-1!==s&&this.pageBuf.rows[s]&&this.pageBuf.rows[s].selCB&&this.pageBuf.rows[s].selCB.setState(t)},setAllRowSelectors:function(e){this.pageBuf.rows.forEach((function(t){t.trSelCtrl&&t.trSelCtrl.setState(e)}))},setRowSelector:function(e,t){var s=this,n=this.searchRowId(e);if(-1!==n&&this.pageBuf.rows[n]&&this.pageBuf.rows[n].trSelCtrl&&(this.pageBuf.rows[n].trSelCtrl.setState(t),s.editMode)){var a=shmi.requires("visuals.tools.control-config");-1!==s.editRow&&s.resetBufferRow(s.editRow),s.editRow=n,this.pageBuf.rows[n].cols.forEach((function(e,t){e.ctrls.forEach((function(n,l){var o=s.cConfig.resp["column-org"][t],r=a.getConfig(n),c=shmi.requires("visuals.tools.iterate.iterateObject");if(void 0!==s.config["edit-mode-map"][o.fields[l].fieldName]){c(shmi.cloneObject(s.config["edit-mode-map"][o.fields[l].fieldName]),(function(e,t){r[t]=e}));var u=shmi.listen("control-reconfiguration",(function(t){u.unlisten(),e.ctrls[l]=t.detail.control}),{"detail.oldControl":n});a.setConfig(n,r)}}))})),s.updateSize()}},resetBufferRow:function(e){var t=this,s=shmi.requires("visuals.tools.control-config");void 0!==t.pageBuf.rows[e]?t.pageBuf.rows[e].cols.forEach((function(e,n){var a=t.cConfig.resp["column-org"][n];e.ctrls.forEach((function(t,n){var l=s.getConfig(t),o=shmi.cloneObject(a.fields[n].ctrl.config);o.item=l.item,o.ui=a.fields[n].ctrl["ui-type"],shmi.removeClass(t.element,l["class-name"]);var r=shmi.listen("control-reconfiguration",(function(t){r.unlisten(),e.ctrls[n]=t.detail.control}),{"detail.oldControl":t});s.setConfig(t,o)}))})):t.editRow=-1},setRowSelectorByDgRow:function(e,t){var s=e-this.pageBuf.offset;s>=0&&s<this.pageBuf.viewportSize&&this.pageBuf.rows[s]&&this.pageBuf.rows[s].trSelCtrl&&this.pageBuf.rows[s].trSelCtrl.setState(t)},updateSelectionData:function(e,t,s,n,a,l,o){var r=this,c="MULTI"===this.cConfig.resp["select-mode"],u="SINGLE"===this.cConfig.resp["select-mode"];if("ITEM"===this.cConfig.resp["select-mode"]){var m=shmi.visuals.session.ItemManager,h=this.pageBuf.offset+t;this.cConfig["rows-items-from-1"]&&h++,m.writeValue(this.cConfig["item-selected-row"],h)}else{switch(e){case this.c.SELECT_TYPE_ALL:c||console.warn("ComplexTable2","updateSelectionData called with type SELECT_TYPE_ALL but table not in multi-select mode.");case this.c.SELECT_TYPE_NOTHING:this.selection.type=e,this.selection.selRows=[],this.selection.selRowIndex=[],this.selection.dblClicked=o;break;default:if(-1!==t)if(c){if(n&&this.lastClicked.rowId>-1)return a||(this.selection.selRows=[],this.selection.selRowIndex=[]),function addSelectionRange(e,t){return new Promise(((s,n)=>{const a=getRowOffset(e,t);if(null===a)n(new Error("Could not find row offset"));else{let n,l;a>=e.lastClicked.offset?(l=a,n=e.lastClicked.offset):(l=e.lastClicked.offset,n=a),loadRange(e,t,n,l-n+1,s)}}))}(this,this.pageBuf.rows[t].rowId).then().catch((e=>{shmi.notify("Error fetching selection data: "+e.message,"${V_ERROR}")})),this.selection.lastClickedRow=t,void setLastClicked(this,this.pageBuf.rows[t].rowId);l||a?(s===this.c.CB_CHK?this.addRowIdToSelection(this.pageBuf.rows[t].rowId):this.removeRowIdFromSelection(this.pageBuf.rows[t].rowId),this.selection.lastClickedRow=t,setLastClicked(this,this.pageBuf.rows[t].rowId)):(shmi.cloneObject(r.selection.selRows).forEach((function(e){r.removeRowIdFromSelection(e)})),s===this.c.CB_CHK&&r.addRowIdToSelection(this.pageBuf.rows[t].rowId),setLastClicked(this,this.pageBuf.rows[t].rowId))}else u&&(this.selection.selRows=[],this.selection.selRowIndex=[],s===this.c.CB_CHK?this.addRowIdToSelection(this.pageBuf.rows[t].rowId):this.removeRowIdFromSelection(this.pageBuf.rows[t].rowId));this.selection.dblClicked=o,this.updateSelTypeFromSelRows()}this.updateDelRowsBtnEnable(),clearTimeout(r.sel_fire_to),r.sel_fire_to=setTimeout((function(){r.fireSelChanged(shmi.cloneObject(r.selection))}),shmi.c("ACTION_RETRY_TIMEOUT"))}},getRowIndex:function(e){var t=null,s=this.dgMan.getGrid(this.cConfig.table);return s&&(t=s.getRowIndex(e)),t},addRowIdToSelection:function(e){if(-1===this.selection.selRows.indexOf(e)&&(this.selection.selRows.push(e),this.cConfig.useDgIndex)){var t=this.getRowIndex(e);this.selection.selRowIndex.push(t)}},removeRowIdFromSelection:function(e){var t=this,s=this.selection.selRows.indexOf(e);-1!==s?(this.selection.selRows.splice(s,1),this.cConfig.useDgIndex&&this.selection.selRowIndex.splice(s,1)):-1!==t.editRow&&(t.resetBufferRow(t.editRow),t.editRow=-1,t.updateSize())},updateSelTypeFromSelRows:function(){this.selection.selRows.length===this.pageBuf.nofTotalRows?this.selection.type=this.c.SELECT_TYPE_SEL_ROWS:0===this.selection.selRows.length?this.selection.type=this.c.SELECT_TYPE_NOTHING:this.selection.type=this.c.SELECT_TYPE_SEL_ROWS},selectAllCBoxValChanged:function(e){var t;switch(e){case this.c.CB_UNCHK:t=this.c.SELECT_TYPE_NOTHING;break;case this.c.CB_CHK:return t=this.c.SELECT_TYPE_ALL,void loadRange(this,-1,0,this.dgSubscription.changeInfo.totalRows,(()=>{}));default:t=this.c.SELECT_TYPE_SEL_ROWS}this.updateSelectionData(t,-1,this.c.CB_UNDEF,!1,!1,!0,!1),this.updateSelectionView()},selectCBoxValChanged:function(e,t,s,n,a,l){"3-state-clear"===this.c.MULTI_SELECT_MODE&&this.header.selAllCBox&&this.header.selAllCBox.getState()===this.c.CB_UNCHK&&this.clearSelection(),this.updateSelectionData(this.c.SELECT_TYPE_SEL_ROWS,e,t,s,n,a,l),this.updateSelectionView()},selectRowValChanged:function(e,t,s,n,a){this.updateSelectionData(this.c.SELECT_TYPE_SEL_ROWS,e,t,s,n,!1,a),this.updateSelectionView()},deleteSelectedRows:function(){var e=this;shmi.confirm(e.config["msg-confirm-delete"]||"${ct2_confirm_delete_rows}",(function(t){e.deleteSelectedRows_confirm(t)}))},deleteSelectedRows_confirm:function(e){if(e){switch(this.selection.type){case this.c.SELECT_TYPE_ALL:setLastClicked(this,-1),this.dgMan.deleteAll(this.cConfig.table);break;case this.c.SELECT_TYPE_SEL_ROWS:setLastClicked(this,-1),this.dgMan.deleteRow(this.cConfig.table,this.selection.selRows)}this.clearSelection()}},fireSelChanged:function(e){shmi.requires("visuals.tools.iterate.iterateObject")(this.selChgEventListeners,(t=>{t.listener.tableSelectionChange(e)})),this.lastSelection&&!e.dblClicked&&isEqualSelection(this.lastSelection,e)||(this.lastSelection=shmi.cloneObject(e),this.updateNofRowsDisplay(),this.fire("select",e))},sortHeaderChanged:function(e,t){var s,n;switch(t){case this.c.SORT_UP:s=e,n="DESC";break;case this.c.SORT_DOWN:s=e,n="ASC";break;default:s=-1,n="ASC"}setLastClicked(this,-1),this.dgMan.sort(this.cConfig.table,s,n),this.clearSortHeaderExcept(e),this.clearSelection()},clearSortHeaderExcept:function(e){for(var t=this.cConfig.resp["nof-cols"],s=0;s<t;s++)for(var n=this.header.cols[s].ctrls,a=0;a<n.length;a++)n[a].id!==e&&n[a].setState(this.c.NO_SORT)},txtFiltersUsed:function(){var e=!1;return this.config["default-text-filter-fields"].length>0&&(e=!0),e},clearFilterData:function(){this.filterData={};for(var e=this.cConfig.filters.length,t=0;t<e;t++){var s=this.cConfig.filters[t],n=this.getDataColNo(s.field).toString(),a=this.filterData[n];a||((a={}).expr=[],a.changed=!1,this.filterData[n]=a)}},clearColTextFilterData:function(){this.colTextFilterData={};for(var e=this.cConfig.resp["text-filter-fields"],t=0;t<e.length;t++){var s=this.getDataColNo(e[t]).toString(),n=this.colTextFilterData[s];n||((n={}).expr="",n.changed=!1,this.colTextFilterData[s]=n)}},quicksearchChanged:function(e){var t="string"==typeof e?e.trim():e,s=this.cConfig.quicksearch.fields;""===t?this.removeQuicksearchFilterExpr(s):this.setQuicksearchFilterExpr(t,s),this.applyFilters(),this.clearSelection(),this.resetScroll()},filterChanged:function(e,t,s){1===e?this.setFilterExpr(s):this.removeFilterExpr(s),this.applyFilters(),this.clearSelection(),this.resetScroll()},colTxtFilterChanged:function(e,t,s){var n="string"==typeof e?e.trim():e;if(""===n){var a=this.getFilterId(s);this.removeColTxtFilterExpr(a)}else this.setColTxtFilterExpr(s,n);this.applyFilters(),this.clearSelection(),this.resetScroll()},colTxtFilterReset:function(e){var t=this.colTxtFilters.items[e];t&&shmi.visuals.session.ItemManager.writeValue(t.name,"")},setFilterExpr:function(e){var t=this.getFilterId(e);if(-1!==Number(t)){var s=this.cConfig.filters[t];if(s){var n=s.expr,a=this.getDataColNo(s.field).toString(),l=this.filterData[a];-1===l.expr.indexOf(n)&&(l.expr.push(n),l.changed=!0)}}},removeFilterExpr:function(e){var t=this.getFilterId(e);if(-1!==Number(t)){var s=this.cConfig.filters[t];if(s){var n=s.expr,a=this.getDataColNo(s.field).toString(),l=this.filterData[a],o=l.expr.indexOf(n);-1!==o&&(l.expr.splice(o,1),l.changed=!0)}}},setColTxtFilterExpr:function(e,t){for(var s=this.getFilterId(e),n=this.getColTxtFilterDgCols(s),a=0;a<n.length;a++){var l=n[a].toString(),o=this.colTextFilterData[l];o?(o.expr="%"+t+"%",o.changed=!0):shmi.log("[ComplexTable2] setColTxtFilterExpr, no filter data available for data grid col: "+l,3)}},removeColTxtFilterExpr:function(e){for(var t=this.getColTxtFilterDgCols(e),s=0;s<t.length;s++){var n=t[s].toString(),a=this.colTextFilterData[n];a?(a.expr="",a.changed=!0):shmi.log("[ComplexTable2] removeColTxtFilterExpr, no filter data available for data grid col: "+n,3)}},setQuicksearchFilterExpr:function(e,t){t.forEach(function(t){for(var s=this.getColTxtFilterDgCols(this.getDataColIndex(t)),n=0;n<s.length;n++){var a=s[n].toString(),l=this.colTextFilterData[a];l?(l.expr="%"+e+"%",l.changed=!0):shmi.log("[ComplexTable2] setQuicksearchFilterExpr, no filter data available for data grid col: "+a,3)}}.bind(this))},removeQuicksearchFilterExpr:function(e){e.forEach(function(e){for(var t=this.getColTxtFilterDgCols(this.getDataColIndex(e)),s=0;s<t.length;s++){var n=t[s].toString(),a=this.colTextFilterData[n];a?(a.expr="",a.changed=!0):shmi.log("[ComplexTable2] removeQuicksearchFilterExpr, no filter data available for data grid col: "+n,3)}}.bind(this))},getDataColIndex:function(e){var t,s=0;for(var n in this.cConfig["field-datagrid-col-map"])n===e&&(t=s),s++;return void 0===t?(t=0,shmi.log("[ComplexTable2] getDataColNo, unknown fldName "+e,3)):t=shmi.toNumber(t),t},getFilterId:function(e){var t=-1,s=e.lastIndexOf(":");return-1!==Number(s)?t=shmi.toNumber(e.substring(s+1)):shmi.log("[ComplexTable2] getFilterId, unexpected format of virtual item name: "+e,3),t},getColTxtFilterDgCols:function(e){var t=[],s=this.cConfig.resp["column-org"][e];if(s)for(var n=s.fields.length,a=0;a<n;a++)s.fields[a].hasTextFilter&&t.push(s.fields[a].dgCol);return t},applyFilters:function(){if(this.isApplyFiltersEnabled()){for(var e=Object.keys(this.filterData),t=Object.keys(this.colTextFilterData),s=e.slice(),n=0;n<t.length;n++)-1===s.indexOf(t[n])&&s.push(t[n]);for(n=0;n<s.length;n++){var a=this.filterData[s[n]],l=this.colTextFilterData[s[n]],o=!1;if((a&&a.changed||l&&l.changed)&&(o=!0),o){var r=[];a&&(r=a.expr.slice(),a.changed=!1),l&&(""!==l.expr&&r.push(l.expr),l.changed=!1);var c=shmi.toNumber(s[n]);0===r.length?(setLastClicked(this,-1),this.dgMan.clearFilter(this.cConfig.table,c)):(setLastClicked(this,-1),this.dgMan.setFilter(this.cConfig.table,c,r))}}}},isApplyFiltersEnabled:function(){return this.applyFiltersEnable},setApplyFiltersEnable:function(e){this.applyFiltersEnable=e},resetFilterChangeFlags:function(){for(var e=Object.keys(this.filterData),t=0;t<e.length;t++)this.filterData[e[t]].changed=!1},resetColTxtFilterChangeFlags:function(){for(var e=Object.keys(this.colTextFilterData),t=0;t<e.length;t++)this.colTextFilterData[e[t]].changed=!1},clearCtrlPanelData:function(){this.ctrlPanelData.filter||(this.ctrlPanelData.filter={},this.ctrlPanelData.filter.names=[],this.ctrlPanelData.filter.items=[]);var e=this.isApplyFiltersEnabled();this.setApplyFiltersEnable(!1);for(var t=shmi.visuals.session.ItemManager,s=0;s<this.ctrlPanelData.filter.items.length;s++)t.writeValue(this.ctrlPanelData.filter.items[s].name,0);if(this.resetFilterChangeFlags(),this.setApplyFiltersEnable(e),this.ctrlPanelData.filter.btns)for(s=0;s<this.ctrlPanelData.filter.btns.length;s++)shmi.deleteControl(this.ctrlPanelData.filter.btns[s]);this.ctrlPanelData.filter.btns=[],this.ctrlPanelData.delRowsBtn&&shmi.deleteControl(this.ctrlPanelData.delRowsBtn),this.ctrlPanelData.delRowsBtn=null},clearColTextFilterCtrls:function(){this.colTxtFilters.items||(this.colTxtFilters.items=[]);var e=this.isApplyFiltersEnabled();this.setApplyFiltersEnable(!1);for(var t=shmi.visuals.session.ItemManager,s=0;s<this.colTxtFilters.items.length;s++)this.colTxtFilters.items[s]&&t.writeValue(this.colTxtFilters.items[s].name,"");this.resetColTxtFilterChangeFlags(),this.setApplyFiltersEnable(e);var n=[];if(this.colTxtFilters.cols)for(var a=0;a<this.colTxtFilters.cols.length;a++)if(this.colTxtFilters.cols[a])for(n=this.colTxtFilters.cols[a].ctrls,s=0;s<n.length;s++)shmi.deleteControl(n[s]);this.colTxtFilters.cols=[]},clearCtrlPanelDOM:function(){var e=this;if(e.ctrlPanelElement){e.ctrlPanelData&&e.ctrlPanelData.qSearchInput&&(shmi.deleteControl(e.ctrlPanelData.qSearchInput),e.ctrlPanelData.qSearchInput=null);for(var t=e.ctrlPanelElement.firstChild;t;)e.ctrlPanelElement.removeChild(t),t=e.ctrlPanelElement.firstChild}},updateCtrlPanel:function(){if(this.ctrlPanelElement&&(this.getTableWidth()<this.cConfig["show-buttons-table-min-width-px"]?(shmi.removeClass(this.ctrlPanelElement,this.uiCssCl.ctrlPanelNormal),shmi.addClass(this.ctrlPanelElement,this.uiCssCl.ctrlPanelMin)):(shmi.removeClass(this.ctrlPanelElement,this.uiCssCl.ctrlPanelMin),shmi.addClass(this.ctrlPanelElement,this.uiCssCl.ctrlPanelNormal)),this.clearCtrlPanelData(),this.clearCtrlPanelDOM(),this.cConfig.quicksearch&&this.cConfig.quicksearch.enable?this.enableQuickSearch():this.enableFilterButtons(),this.cConfig["delete-selected-rows"])){var e=document.createElement("div");this.ctrlPanelElement.appendChild(e);var t=this.getChildCtrlConfig(this.cConfig["delete-selected-rows-button-config"]);t||(t={label:"${ct2_delete_rows}"}),this.ctrlPanelData.delRowsBtn=shmi.createControl("button",e,t,"div"),this.ctrlPanelData.delRowsBtn.onClick=function(){this.deleteSelectedRows()}.bind(this),this.updateDelRowsBtnEnable()}},enableFilterButtons:function(){var e,t=this.ctrlPanelData.filter,s=this.cConfig.filters,n=s.length,a=this.getFilterItemNS();if(0===t.items.length)for(e=0;e<n;e++){var l=shmi.localize(s[e].label);t.names.push(l);var o="virtual:"+a+":"+e,r=shmi.createVirtualItem(o,2,0,1,0,function(e,t,s){this.filterChanged(e,t,s)}.bind(this));t.items.push(r)}for(e=0;e<n;e++){var c=document.createElement("div");this.ctrlPanelElement.appendChild(c);var u=this.getChildCtrlConfig(s[e]["filter-button-config"],this.cConfig["default-filter-button-config"]);u||((u={"off-value":0,"on-value":1})["off-label"]=u["on-label"]=t.names[e],s[e].template&&(u.template=s[e].template),s[e]["class-name"]&&(u["class-name"]=s[e]["class-name"])),u.item=t.items[e].name;var m=shmi.createControl("toggle-button",c,u,"div");t.btns.push(m)}},enableQuickSearch:function(){var e=this;if("AND"===e.cConfig.quicksearch.chaining||"OR"===e.cConfig.quicksearch.chaining?shmi.visuals.session.DataGridManager.setFilterChaining(e.cConfig.table,e.cConfig.quicksearch.chaining):shmi.visuals.session.DataGridManager.setFilterChaining(e.cConfig.table,"OR"),e.ctrlPanelData.qSearchInput)return;var t=document.createElement("div"),s=document.createElement("div");shmi.addClass(t,"qsearch-box"),e.ctrlPanelElement.appendChild(t);e.ctrlPanelData.qSearchInput=shmi.createControl("input-field",t,{label:"${ct2_quicksearch}","class-name":"input-field label-beside"},"div"),t.appendChild(s),shmi.addClass(s,"ct2-qsearch-clear");const qSearchHandler=function(){e.isActive()&&!e.locked&&(e.ctrlPanelData.qSearchInput.setValue(""),e.qSearchOld=null,e.quicksearchHandler())};s.addEventListener("click",qSearchHandler),s.addEventListener("touchstart",qSearchHandler),shmi.onActive([e.ctrlPanelData.qSearchInput],(function(){if(e.isActive()){var t=e.ctrlPanelData.qSearchInput.valueElement;null!==e.qSearchOld&&e.ctrlPanelData.qSearchInput.setValue(e.qSearchOld),e.quicksearchHandler=onQuickSearch.bind(null,e,t),e.quicksearchValueElement=t,t.addEventListener("keyup",e.quicksearchHandler),e.vars.qSearchToken=e.ctrlPanelData.qSearchInput.listen("change",e.quicksearchHandler),e.cConfig.quicksearch&&e.cConfig.quicksearch.initialFocus&&e.ctrlPanelData.qSearchInput.valueElement.focus()}})),e.isLocked()&&e.ctrlPanelData.qSearchInput.lock()},updateDelRowsBtnEnable:function(){var e=!0;this.ctrlPanelData.delRowsBtn&&((this.selection.type===this.c.SELECT_TYPE_NOTHING||this.selection.type===this.c.SELECT_TYPE_SEL_ROWS&&0===this.selection.selRows.length)&&(e=!1),e?this.ctrlPanelData.delRowsBtn.unlock():this.ctrlPanelData.delRowsBtn.lock())},getFilterItemNS:function(){return"ct2-filter-"+this.instID},getColTxtFilterItemNS:function(){return"ct2-col-txt-filter-"+this.instID},getAdapterNS:function(){return"ct2-adapter-"+this.instID},updateHeader:function(){var e=this;this.header.cols&&this.header.cols.forEach((function(e,t){e.ctrls[0].cbMouseListener&&(e.ctrls[0].cbMouseListener.disable(),e.ctrls[0].cbTouchListener.disable())})),this.header.selAllCBox=null,this.header.cols=[];for(var t=this.theadElement.firstChild;t;)this.theadElement.removeChild(t),t=this.theadElement.firstChild;var s=this.cConfig.resp["nof-cols"],n="MULTI"===this.cConfig.resp["select-mode"],a=this.createColGroup(s,n);this.theadElement.appendChild(a);var l=document.createElement("tr"),o=null,r=null;n&&this.config["show-select-boxes"]&&(o=document.createElement("th"),r=document.createElement("div"),this.header.selAllCBox=this.createSelCBox(r,-1,!0,this),this.header.selAllCBox.setChangeCallback((function(t,s){e.locked||e.selectAllCBoxValChanged(s)})),o.appendChild(r),l.appendChild(o)),this.theadElement.appendChild(l);for(var c=0;c<s;c++){var u=this.cConfig.resp["column-org"][c];o=document.createElement("th"),r=document.createElement("div"),this.header.cols[c]={},this.header.cols[c].ctrls=this.createHeaderCtrls(r,c),o.appendChild(r),l.appendChild(o),u.fields[0]["min-width"]&&(r.style.minWidth=u.fields[0]["min-width"]),this.header.cols[c].ctrls.forEach((function(t,s){var n=t.fieldName;if(e.config.adapterSettings&&e.config.adapterSettings[n]){var a=e.config.adapterSettings[n],l=null;e.adapterItems.forEach((function(e,t){e.field===n&&(l=e.item.name)}));var r=document.createElement("div");o.appendChild(r);var c=shmi.cloneObject(e.config.adapterSelectConfig);c.item=l,c.options=a,shmi.createControl("select-box",r,c,"DIV","from"),shmi.addClass(o,e.config.adapterSelectClass)}}))}},updateColTextFilters:function(){if(this.txtFiltersHeadElement&&this.txtFiltersUsed()){this.clearColTextFilterCtrls();for(var e=this.txtFiltersHeadElement.firstChild;e;)this.txtFiltersHeadElement.removeChild(e),e=this.txtFiltersHeadElement.firstChild;var t;if(0===this.colTxtFilters.items.length){var s=Object.keys(this.cConfig["field-datagrid-col-map"]).length,n=this.getColTxtFilterItemNS();for(t=0;t<s;t++){var a="virtual:"+n+":"+t;this.colTxtFilters.items[t]=shmi.createVirtualItem(a,0,0,1,"",function(e,t,s){this.colTxtFilterChanged(e,t,s)}.bind(this))}}var l=this.cConfig.resp["nof-cols"],o="MULTI"===this.cConfig.resp["select-mode"],r=this.createColGroup(l,o);this.txtFiltersHeadElement.appendChild(r);var c=document.createElement("tr");this.txtFiltersHeadElement.appendChild(c);var u=null,m=null;for(o&&(u=document.createElement("th"),c.appendChild(u)),t=0;t<l;t++){var h=this.cConfig.resp["column-org"][t];u=document.createElement("th"),m=document.createElement("div"),u.appendChild(m),c.appendChild(u),h.hasTextFilter&&(this.colTxtFilters.cols[t]={},this.colTxtFilters.cols[t].ctrls=this.createColTxtFilterCtrls(m,t))}}},getDgFilterSettings:function(){var e=this;clearTimeout(e.reset_sort_filters_to),e.reset_sort_filters_to=setTimeout((function(){e.resetSortFilters()}),shmi.c("ACTION_RETRY_TIMEOUT"))},getColTxtFilterVal:function(e){var t="",s=e.length;return s>=3&&"%"===e.charAt(0)&&"%"===e.charAt(s-1)?t=e.slice(1,s-1):shmi.log("[ComplexTable2] getColTxtFilterVal, unexpected format of filter expression: "+e,2),t},getBtnFilter:function(e,t){for(var s=-1,n=this.cConfig.filters,a=0;a<n.length;a++){if(this.getDataColNo(n[a].field)===t&&e===n[a].expr){s=a;break}}return s},resetSortFilters:function(){setLastClicked(this,-1),this.dgMan.sort(this.cConfig.table,-1,"ASC"),this.dgMan.clearFilter(this.cConfig.table,-1)},updateNofRowsDisplay:function(){this.cConfig.resp["show-nof-rows"]&&this.footerElement&&(this.footerElement.textContent=this.pageBuf.nofTotalRows+" "+shmi.localize("${ct2_nof_rows}"))},updateRespDepContent:function(e){var t=this;e&&("ICON"===t.cConfig.resp.headerMode?t.headerMode="ICON":t.headerMode="TEXT",this.cLayoutClass&&shmi.removeClass(this.element,this.cLayoutClass),this.cLayoutClass=this.cConfig.resp["layout-class-name"],this.cLayoutClass&&shmi.addClass(this.element,this.cLayoutClass),this.cConfig.resp["show-nof-rows"]?(shmi.removeClass(this.element,this.uiCssCl.rowDisplInvisible),shmi.addClass(this.element,this.uiCssCl.rowDisplVisible)):(shmi.removeClass(this.element,this.uiCssCl.rowDisplVisible),shmi.addClass(this.element,this.uiCssCl.rowDisplInvisible)),"MULTI"===this.cConfig.resp["select-mode"]?shmi.addClass(this.element,this.uiCssCl.multiselect):shmi.removeClass(this.element,this.uiCssCl.multiselect)),this.updateCtrlPanel(),this.updateHeader(),this.cConfig.quicksearch&&this.cConfig.quicksearch.enable||this.updateColTextFilters()},cleanupTabContent:function(){this.clearPgBuf(),this.clearTableDOM()},clearPgBuf:function(){if(this.pageBuf.rows)for(var e=0;e<this.pageBuf.rows.length;e++){this.pageBuf.rows[e].trSelCtrl&&this.pageBuf.rows[e].trSelCtrl.rsMouseListener&&(this.pageBuf.rows[e].trSelCtrl.rsMouseListener.disable(),this.pageBuf.rows[e].trSelCtrl.rsTouchListener.disable());for(var t=0;t<this.pageBuf.nofCols;t++)for(var s=this.pageBuf.rows[e].cols[t].ctrls,n=0;n<s.length;n++)shmi.deleteControl(s[n])}this.pageBuf.offset=0,this.pageBuf.nofTotalRows=0,this.pageBuf.size=0,this.pageBuf.nofCols=0,this.pageBuf.firstVpRow=0,this.pageBuf.avgNofVpLines=0,this.pageBuf.rows=[]},clearTableDOM:function(){this.tbodyElement.forEach((function(e){for(var t=e.firstChild;t;)e.removeChild(t),t=e.firstChild}))},cleanupMetrics:function(){this.metricsData.isValid?this.metricsData.last=shmi.cloneObject(this.metricsData):this.metricsData.last={},this.metricsData.isValid=!1,this.metricsData.lineHeightPx=0},cleanupAsyncProcessing:function(){this.asyncProcData.onDgChgRetryTO&&clearTimeout(this.asyncProcData.onDgChgRetryTO),this.asyncProcData.onEvtResizeRetryTO&&clearTimeout(this.asyncProcData.onEvtResizeRetryTO),this.asyncProcData.processMetricsTO&&clearTimeout(this.asyncProcData.processMetricsTO),this.asyncProcData.onDgChgRetryTO=null,this.asyncProcData.onEvtResizeRetryTO=null,this.asyncProcData.processMetricsTO=null},reinitTable:function(e,t,s){var n=this,a=this.pageBuf.rows.length;if(0===a)if(0!==e.totalRows){shmi.removeClass(this.element,this.uiCssCl.emptyTab),this.pageBuf.bufferOffset=e.offset,this.pageBuf.nofTotalRows=e.totalRows,n.tableElement.style.height=n.pageBuf.nofTotalRows*n.metricsData.lineHeightPx+"px",this.pageBuf.size=t.length,this.pageBuf.viewportSize=this.cConfig["nof-buffered-rows"],this.pageBuf.bufferSize=this.cConfig["buffer-size"],(this.pageBuf.offset<this.pageBuf.bufferOffset||this.pageBuf.offset>this.pageBuf.bufferOffset+this.pageBuf.bufferSize)&&(this.pageBuf.offset=this.pageBuf.bufferOffset);for(var l=this.pageBuf.nofCols=this.cConfig.resp["nof-cols"],o=a;o<this.pageBuf.viewportSize;o++)this.pageBuf.rows[o]=createRowDescriptor("number"==typeof t[o]?t[o]:null,l);s||(this.bodyViewportElement.scrollTop=0);var r="MULTI"===this.cConfig.resp["select-mode"];this.tbodyElement.forEach((function(e,t){var s=n.pageBuf.viewportSize/3,a=n.createColGroup(l,r);e.appendChild(a);for(var o=0;o<s;o++)createTableRow(n,t*s+o,e,0===o)})),this.processAsyncMetricsUpdate(s?n.vars.scrollTop:null)}else this.pageBuf.nofCols=this.cConfig.resp["nof-cols"],shmi.addClass(this.element,this.uiCssCl.emptyTab);else console.warn("[ComplexTable2] reinitTable, table is not empty, length:",a)},processTabReinitDependencies:function(){this.updateNofRowsDisplay(),this.updateSelectionView()},doScrollUpdate:function doScrollUpdate(){updatePages(this,this.bodyViewportElement.scrollTop)},initScrollHandler:function(){var e=this;e.bodyViewportElement.style["overflow-y"]="scroll",e.onBodyScroll=function(t){clearTimeout(e.vars.updateTimeout),e.vars.updateTimeout=0,e.isActive()&&!e.locked?Date.now()-e.vars.lastUpdate>100?(e.doScrollUpdate(),e.vars.lastUpdate=Date.now()):e.vars.updateTimeout=setTimeout((function(){e.doScrollUpdate(),e.vars.lastUpdate=Date.now()}),100):e.bodyViewportElement.scrollTop=0},e.bodyViewportElement.addEventListener("scroll",e.onBodyScroll)},resetScroll:function(){this.bodyViewportElement.scrollTop=0},updateTable:function(e,t){var s=this,n=s.cConfig["nof-buffered-rows"]/3,a=[];if(0===s.pageBuf.rows.length||s.pageBuf.bufferSize<t.length)console.error("[ComplexTable2]","updateTable, table is empty or buffer size has been changed");else{var l=s.pageBuf.offset-s.pageBuf.bufferOffset;t.forEach((function(e,o){var r=o-l;if(!(r<0||r>=3*n)){var c=Math.floor(r/n),u=s.vars.pageOrder[c]*n+r%n,m=s.pageBuf.rows[u];m?(a.push(u),m.rowId===e&&m.visible||s.writeRow(u,t,o)):console.error("[ComplexTable2]","invalid buffer index:",u)}})),s.pageBuf.rows.forEach((function(e,t){-1===a.indexOf(t)?e.visible&&(e.visible=!1,e.trElem.style.visibility="hidden"):e.visible||(e.visible=!0,e.trElem.style.visibility="")}))}},writeRow:function(e,t,s){var n=0,a="",l=null;if(this.pageBuf.rows[e]){n=this.pageBuf.rows[e].rowId=t[s];for(var o=0;o<this.pageBuf.nofCols;o++){l=this.cConfig.resp["column-org"][o];for(var r=this.pageBuf.rows[e].cols[o].ctrls,c=0;c<r.length;c++){a=this.makeItem(n,l.fields[c].dgCol);var u=shmi.requires("visuals.tools.item-adapter"),m=this.getColumnAdapter(l.fields[c].fieldName);null!==shmi.visuals.session.ItemManager.getItem(a)&&(null===m?u.unsetAdapter(a):u.setAdapter(a,m)),r[c].setItem(a)}}}},updateMetricsData:function(e){var t=this;if(t.pageBuf.size>0){t.metricsData.lineHeightPx=t.tbodyElement[0].getBoundingClientRect().height/t.tbodyElement[0].rows.length,t.tableElement.style.height=t.pageBuf.nofTotalRows*t.metricsData.lineHeightPx+"px",t.tableElement.style.overflow="hidden",t.metricsData.viewportHeight=t.bodyViewportElement.getBoundingClientRect().height,t.metricsData.viewportWidth=t.bodyViewportElement.getBoundingClientRect().width;var s=3*Math.ceil(t.metricsData.viewportHeight/t.metricsData.lineHeightPx);t.cConfig["nof-buffered-rows"]<s&&(t.cConfig["nof-buffered-rows"]=s,console.info("[ComplexTable2]","buffer rows configured too low, corrected to:",s));var n=t.cConfig["nof-buffered-rows"];t.pageBuf.nofTotalPages=t.pageBuf.nofTotalRows/(n/3)}else t.metricsData.last.isValid?t.metricsData=shmi.cloneObject(t.metricsData.last):t.metricsData.lineHeightPx=t.c.DEFAULT_LINE_HEIGHT;t.metricsData.isValid=!0,"number"==typeof e?reinitPages(t,e):(t.vars.scrollTop=0,reinitPages(t,0))},disableEvents:function(){this.header.selAllCBox&&this.header.selAllCBox.setEventsEnabled(!1)},enableEvents:function(){this.header.selAllCBox&&this.header.selAllCBox.setEventsEnabled(!0)},createHeaderCtrls:function(e,t){var s=this,n=[];shmi.addClass(e,this.uiCssCl.thCont);for(var a=this.cConfig.resp["column-org"][t],l=a.fields.length,o=0;o<l;o++){var r=document.createElement("div"),c=a.fields[o].icon,u=a.fields[o].header||" ";if(u){var m=shmi.localize(u);o>0&&(m=" / "+m);var h=new shmi.visuals.controls.ComplexTable2.FieldHeader(r,a.fields[o].dgCol,a.fields[o].isSortable,this.c.NO_SORT,m,s,a.fields[o].fieldName,c);h.setChangeCallback((function(e,t){s.locked||s.sortHeaderChanged(e,t)})),n.push(h),e.appendChild(r)}}return n},createColTxtFilterCtrls:function(e,t){var s=[],n=document.createElement("div"),a=document.createElement("div");n.appendChild(a),e.appendChild(n),shmi.addClass(e,this.uiCssCl.thCont),shmi.addClass(n,this.uiCssCl.colTxtFilterCont),shmi.addClass(a,this.uiCssCl.colTxtFilterLineCont);var l=document.createElement("img");a.appendChild(l),l.src="pics/system/controls/complex-table2/filter.svg",shmi.addClass(l,this.uiCssCl.colTxtFilterIcon);var o=this.colTxtFilters.items[t].name,r=this.getChildCtrlConfig(this.cConfig.resp["text-filter-input-field-config"]);r||(r={"class-name":"input-field if-filter"}),r.item=o;var c=shmi.createControl("input-field",a,r,"div");s.push(c),(r=this.getChildCtrlConfig(this.cConfig.resp["text-filter-clear-button-config"]))||(r={"class-name":"button icon-only reset-filter",label:"X","icon-src":"pics/system/controls/complex-table2/cross_white.svg"});var u=shmi.createControl("button",a,r,"div");return u.onClick=function(){this.colTxtFilterReset(t)}.bind(this),s.push(u),s},createSelCBox:function(e,t,s,n){return new shmi.visuals.controls.ComplexTable2.CheckBox(e,t,s,this.c.CB_UNCHK,n)},createSelRowCtrl:function(e,t,s){return new shmi.visuals.controls.ComplexTable2.RowSelector(e,t,this.c.CB_UNCHK,s,{toggleSelection:this.cConfig.resp["toggle-selection"],doubleClickEvents:this.cConfig.resp["double-click-events"]})},createColGroup:function(e,t){var s=document.createElement("colgroup"),n=[];t&&this.config["show-select-boxes"]&&(n.push(document.createElement("col")),n[n.length-1].setAttribute("class",this.uiCssCl.colCb));for(var a=0;a<e;a++){var l=this.cConfig.resp["column-org"][a];n.push(document.createElement("col")),n[n.length-1].setAttribute("class",this.uiCssCl.colPfx+(a+1)),l.fields[0]["column-width"]&&(n[n.length-1].style.width=l.fields[0]["column-width"])}return n.forEach((function(e){s.appendChild(e)})),s},getTableWidth:function(){var e=0;if(this.tcElement)e=this.tcElement.offsetWidth;else{var t=shmi.getUiElement(this.uiElName.tabContainer,this.element);t?e=t.offsetWidth:shmi.log("[ComplexTable2] no "+this.uiElName.tabContainer+" element provided (required)",3)}return e},getTableVpWidth:function(){return this.bodyViewportElement.offsetWidth},isTabSizeChanged:function(){var e=!1;return this.getTableVpWidth()===this.lastTableVpWidth&&this.element.offsetHeight===this.lastTableVpHeight||(e=!0,this.lastTableVpWidth=this.getTableVpWidth(),this.lastTableVpHeight=this.element.offsetHeight),e},isLayoutChanged:function(){var e=!1;return this.cConfig.resp["layout-id"]!==this.lastLayoutId&&(e=!0,this.lastLayoutId=this.cConfig.resp["layout-id"]),e},makeItem:function(e,t){return this.dgSubscription.prefix+e+":"+t},searchRowId:function(e){for(var t=-1,s=0;s<this.pageBuf.viewportSize;s++)if(this.pageBuf.rows[s]&&this.pageBuf.rows[s].rowId===e){t=s;break}return t},detectTouchDevice:function(){return!!("ontouchstart"in document.documentElement)},onLock:function(){var e=this;shmi.addClass(e.element,"locked"),e.cConfig.quicksearch&&e.cConfig.quicksearch.enable&&e.ctrlPanelData.qSearchInput&&e.ctrlPanelData.qSearchInput.lock()},onUnlock:function(){var e=this;shmi.removeClass(e.element,"locked"),e.cConfig.quicksearch&&e.cConfig.quicksearch.enable&&e.ctrlPanelData.qSearchInput&&e.ctrlPanelData.qSearchInput.unlock()}},shmi.extend(shmi.visuals.controls.ComplexTable2,shmi.visuals.core.BaseControl),shmi.registerControlType("complex-table2",shmi.visuals.controls.ComplexTable2,!0),shmi.visuals.controls.ComplexTable2.CheckBox=function(e,t,s,n,a){this.ct2c=shmi.visuals.controls.ComplexTable2.c,this.css=shmi.visuals.controls.ComplexTable2.CheckBox.uiCssCl,this.element=e,this.id=t,this.is3tate=s,this.state=n,this.chgCallb=null,this.cbMouseListener=null,this.cbTouchListener=null,shmi.addClass(this.element,shmi.visuals.controls.ComplexTable2.uiCssCl.selCb);var l={};l.onPress=function(){a.locked||shmi.addClass(this.element,this.css.sel)}.bind(this),l.onRelease=function(){a.locked||shmi.removeClass(this.element,this.css.sel)}.bind(this),l.onClick=function(){if(!a.locked){if(this.is3tate)switch(this.state){case this.ct2c.CB_UNCHK:this.state=this.ct2c.CB_CHK;break;case this.ct2c.CB_CHK:this.state=this.ct2c.CB_UNDEF;break;default:this.state=this.ct2c.CB_UNCHK}else this.state=this.state===this.ct2c.CB_UNCHK?this.ct2c.CB_CHK:this.ct2c.CB_UNCHK;this.updateState(),this.fireCbChg()}}.bind(this),this.cbMouseListener=new shmi.visuals.io.MouseListener(this.element,l),this.cbTouchListener=new shmi.visuals.io.TouchListener(this.element,l),this.updateState(),this.setEventsEnabled(!0)},shmi.visuals.controls.ComplexTable2.CheckBox.prototype={setChangeCallback:function(e){this.chgCallb=e},setEventsEnabled:function(e){e?(this.cbMouseListener.enable(),this.cbTouchListener.enable()):(this.cbMouseListener.disable(),this.cbTouchListener.disable())},setState:function(e){this.state=e,this.updateState()},getState:function(){return this.state},updateState:function(){switch(shmi.removeClass(this.element,this.css.ck),shmi.removeClass(this.element,this.css.unck),shmi.removeClass(this.element,this.css.undef),this.state){case this.ct2c.CB_UNCHK:shmi.addClass(this.element,this.css.unck);break;case this.ct2c.CB_CHK:shmi.addClass(this.element,this.css.ck);break;default:shmi.addClass(this.element,this.css.undef)}},fireCbChg:function(){this.chgCallb&&this.chgCallb(this.id,this.state)}},shmi.visuals.controls.ComplexTable2.RowSelector=function(e,t,s,n,a){var l=this;l.ct2c=shmi.visuals.controls.ComplexTable2.c,l.css=shmi.visuals.controls.ComplexTable2.RowSelector.uiCssCl,l.element=e,l.id=t,l.state=s,l.chgCallb=null,l.rsMouseListener=null,l.rsTouchListener=null,l.toggleSelection=a?.toggleSelection??!0;var o={onPress:function(){n.locked||shmi.addClass(l.element,l.css.sel)},onRelease:function(){n.locked||shmi.removeClass(l.element,l.css.sel)},onClick:function(e,t,s){n.locked||(l.shiftPressed=s.shiftKey,l.ctrlPressed=s.ctrlKey,l.dblClicked=!1,l.state=l.toggleSelection&&l.state!==l.ct2c.CB_UNCHK?l.ct2c.CB_UNCHK:l.ct2c.CB_CHK,l.updateState(),l.fireRsChg())}};(a?.doubleClickEvents??1)&&(o.onDoubleClick=function(e,t,s){n.locked||(l.shiftPressed=s.shiftKey,l.ctrlPressed=s.ctrlKey,l.dblClicked=!0,l.state=l.ct2c.CB_CHK,l.updateState(),l.fireRsChg())}),l.rsMouseListener=new shmi.visuals.io.MouseListener(l.element,o),l.rsTouchListener=new shmi.visuals.io.TouchListener(l.element,o),l.updateState(),l.setEventsEnabled(!0)},shmi.visuals.controls.ComplexTable2.RowSelector.prototype={setChangeCallback:function(e){this.chgCallb=e},setEventsEnabled:function(e){e?(this.rsMouseListener.enable(),this.rsTouchListener.enable()):(this.rsMouseListener.disable(),this.rsTouchListener.disable())},setState:function(e){this.state=e,this.updateState()},getState:function(){return this.state},updateState:function(){shmi.removeClass(this.element,this.css.ck),shmi.removeClass(this.element,this.css.unck),this.state===this.ct2c.CB_CHK?shmi.addClass(this.element,this.css.ck):shmi.addClass(this.element,this.css.unck)},fireRsChg:function(){this.chgCallb&&this.chgCallb(this.id,this.state,this.shiftPressed,this.ctrlPressed,this.dblClicked)}},shmi.visuals.controls.ComplexTable2.FieldHeader=function(e,t,s,n,a,l,o,r){if(this.ct2c=shmi.visuals.controls.ComplexTable2.c,this.css=shmi.visuals.controls.ComplexTable2.FieldHeader.uiCssCl,this.ct2Inst=l,this.element=e,this.id=t,this.isSortable=s,this.state=n,this.caption=a,this.chgCallb=null,this.cbMouseListener=null,this.cbTouchListener=null,this.fieldName=void 0!==o?o:null,this.icon=void 0===r?null:r,shmi.addClass(this.element,shmi.visuals.controls.ComplexTable2.uiCssCl.fldHeader),"ICON"===this.ct2Inst.headerMode?null!==this.icon&&shmi.addClass(e,this.icon):e.textContent=this.caption,this.isSortable){shmi.addClass(this.element,this.css.sortable);var c={};c.onPress=function(){this.ct2Inst.locked||shmi.addClass(this.element,this.css.sel)}.bind(this),c.onRelease=function(){this.ct2Inst.locked||shmi.removeClass(this.element,this.css.sel)}.bind(this),c.onClick=function(){if(!this.ct2Inst.locked){switch(this.state){case this.ct2c.SORT_UP:this.state=this.ct2c.SORT_DOWN;break;case this.ct2c.SORT_DOWN:this.state=this.ct2c.NO_SORT;break;default:this.state=this.ct2c.SORT_UP}this.updateState(),this.fireSortChg()}}.bind(this),this.cbMouseListener=new shmi.visuals.io.MouseListener(this.element,c),this.cbTouchListener=new shmi.visuals.io.TouchListener(this.element,c)}this.updateState(),this.setEventsEnabled(!0)},shmi.visuals.controls.ComplexTable2.FieldHeader.prototype={setChangeCallback:function(e){this.chgCallb=e},setEventsEnabled:function(e){this.cbMouseListener&&(e?(this.cbMouseListener.enable(),this.cbTouchListener.enable()):(this.cbMouseListener.disable(),this.cbTouchListener.disable()))},setState:function(e){this.state=e,this.updateState()},getState:function(){return this.state},updateState:function(){if(this.isSortable)switch(shmi.removeClass(this.element,this.css.noSort),shmi.removeClass(this.element,this.css.sortUp),shmi.removeClass(this.element,this.css.sortDn),this.state){case this.ct2c.SORT_UP:shmi.addClass(this.element,this.css.sortUp);break;case this.ct2c.SORT_DOWN:shmi.addClass(this.element,this.css.sortDn);break;default:shmi.addClass(this.element,this.css.noSort)}else shmi.addClass(this.element,this.css.noSort)},fireSortChg:function(){this.chgCallb&&this.chgCallb(this.id,this.state)}},shmi.visuals.controls.ComplexTable2.instIDs=[],shmi.visuals.controls.ComplexTable2.uiElName={},(e=shmi.visuals.controls.ComplexTable2.uiElName).tabContContainer="ct2-table-content-container",e.tabHeadContainer="ct2-table-header-container",e.tabContainer="ct2-table-container",e.tbodyContainer="ct2-table-body-container",e.thead="ct2-table-header",e.table="ct2-table",e.txtFiltersHead="ct2-table-filters",e.tbody="ct2-table-body",e.label="ct2-label",e.ctrlPanel="ct2-ctrl-panel",e.footer="ct2-footer",shmi.visuals.controls.ComplexTable2.uiCssCl={},(e=shmi.visuals.controls.ComplexTable2.uiCssCl).colCb="ct2-colcb",e.colPfx="ct2-col",e.thCont="ct2-thcont",e.tdCont="ct2-tdcont",e.selCb="ct2-selcb",e.evenRow="ct2-evenRow",e.fldHeader="ct2-fhead",e.colTxtFilterCont="ct2-filter",e.colTxtFilterLineCont="line",e.colTxtFilterIcon="filter-icon",e.multiline="multiline",e.multiselect="ct2-multisel",e.sbNotUsed="ct2-sb-not-used",e.sbMinimized="ct2-sb-minimized",e.sbNormal="ct2-sb-normal",e.rowDisplVisible="ct2-row-display-visible",e.rowDisplInvisible="ct2-row-display-invisible",e.emptyTab="ct2-empty-table",e.ctrlPanelMin="ct2-ctrl-panel-minimized",e.ctrlPanelNormal="ct2-ctrl-panel-normal",e.activeRow="ct2-active-row",e.touchDev="touch",e.noTouchDev="notouch",shmi.visuals.controls.ComplexTable2.c={},(e=shmi.visuals.controls.ComplexTable2.c).MIN_BUF_SIZE=150,e.CONST_LINE_HEIGHT=!1,e.DEBOUNCE_TO_RESIZE=150,e.DEFAULT_LINE_HEIGHT=20,e.MULTI_SELECT_MODE="3-state-clear",e.SCROLL_EVT_TYPE_NONE=-1,e.SCROLL_EVT_TYPE_TOUCH=11,e.SCROLL_EVT_TYPE_RELEASE=12,e.SCROLL_EVT_TYPE_SB_BTN_UP=101,e.SCROLL_EVT_TYPE_SB_BTN_DOWN=102,e.SCROLL_EVT_TYPE_SB_SLIDER_CHG=103,e.SCROLL_EVT_TYPE_SB_LARGE_CHG=104,e.SCROLL_EVT_TYPE_V_DRAG_UP=201,e.SCROLL_EVT_TYPE_V_DRAG_DOWN=202,e.SCROLL_EVT_TYPE_V_SWIPE_UP=301,e.SCROLL_EVT_TYPE_V_SWIPE_DOWN=302,e.SCROLL_EVT_TYPE_H_SWIPE_LEFT=401,e.SCROLL_EVT_TYPE_H_SWIPE_RIGHT=402,e.SCROLL_EVT_TYPE_RESIZE=501,e.SCROLL_EVT_TYPE_RESIZE_LAYOUT_CHG=502,e.SELECT_TYPE_NOTHING=-1,e.SELECT_TYPE_ALL=1,e.SELECT_TYPE_SEL_ROWS=2,e.CB_UNCHK=-1,e.CB_CHK=1,e.CB_UNDEF=2,e.NO_SORT=-1,e.SORT_UP=1,e.SORT_DOWN=2,shmi.visuals.controls.ComplexTable2.CheckBox.uiCssCl={},(e=shmi.visuals.controls.ComplexTable2.CheckBox.uiCssCl).sel="ct2-cb-sel",e.ck="ct2-cb-ck",e.unck="ct2-cb-unck",e.undef="ct2-cb-undef",shmi.visuals.controls.ComplexTable2.RowSelector.uiCssCl={},(e=shmi.visuals.controls.ComplexTable2.RowSelector.uiCssCl).sel="ct2-rs-sel",e.ck="ct2-rs-ck",e.unck="ct2-rs-unck",shmi.visuals.controls.ComplexTable2.FieldHeader.uiCssCl={},(e=shmi.visuals.controls.ComplexTable2.FieldHeader.uiCssCl).sel="ct2-fh-sel",e.sortUp="ct2-fh-sort-up",e.sortDn="ct2-fh-sort-down",e.noSort="ct2-fh-no-sort",e.sortable="ct2-fh-sortable"}(),function(){"use strict";const e={MODE:{FLOAT:null,STACKED:"stacked-layout",INLINE:"inline-layout",FLEX:"flex-layout",IQ_FLEX:"iq-flex-layout"},ALIGN:{HORIZONTAL:{LEFT:"left-aligned",CENTER:"centered",RIGHT:"right-aligned"},VERTICAL:{TOP:"top",MIDDLE:"middle",BOTTOM:"bottom"},PRIMARY:{START:"flex-primary-align-start",CENTER:"flex-primary-align-center",END:"flex-primary-align-end",SPACE_BETWEEN:"flex-primary-align-space-between",SPACE_AROUND:"flex-primary-align-space-around",SPACE_EVENLY:"flex-primary-align-space-evenly"},SECONDARY:{START:"flex-secondary-align-start",CENTER:"flex-secondary-align-center",END:"flex-secondary-align-end",STRETCH:"flex-secondary-align-stretch"},LINE:{START:"flex-line-align-start",CENTER:"flex-line-align-center",END:"flex-line-align-end",STRETCH:"flex-line-align-stretch",SPACE_BETWEEN:"flex-line-align-space-between",SPACE_AROUND:"flex-line-align-space-around"}},AUTO:{WIDTH:"auto-width",MARGIN:"auto-margin"},FLEX:{DISTRIBUTE:"distribute-evenly",WRAP:"flex-wrap",ALL:"flex-all",COLUMN:"column-orientation",NONE:"flex-none"}},t={"auto-width":[{value:!0,modifier:e.AUTO.WIDTH}],"auto-margin":[{value:!0,modifier:e.AUTO.MARGIN}],"h-alignment":[{value:"left",modifier:e.ALIGN.HORIZONTAL.LEFT},{value:"center",modifier:e.ALIGN.HORIZONTAL.CENTER},{value:"right",modifier:e.ALIGN.HORIZONTAL.RIGHT}],"v-alignment":[{value:"top",modifier:e.ALIGN.VERTICAL.TOP},{value:"middle",modifier:e.ALIGN.VERTICAL.MIDDLE},{value:"bottom",modifier:e.ALIGN.VERTICAL.BOTTOM}],"flex-orientation":[{value:"column",modifier:e.FLEX.COLUMN}],"flex-distribute":[{value:!0,modifier:e.FLEX.DISTRIBUTE}],"flex-all":[{value:!0,modifier:e.FLEX.ALL}],"flex-none":[{value:!0,modifier:e.FLEX.NONE}],"flex-wrap":[{value:!0,modifier:e.FLEX.WRAP}],"flex-primary-align":[{value:"start",modifier:e.ALIGN.PRIMARY.START},{value:"center",modifier:e.ALIGN.PRIMARY.CENTER},{value:"end",modifier:e.ALIGN.PRIMARY.END},{value:"space-between",modifier:e.ALIGN.PRIMARY.SPACE_BETWEEN},{value:"space-around",modifier:e.ALIGN.PRIMARY.SPACE_AROUND},{value:"space-evenly",modifier:e.ALIGN.PRIMARY.SPACE_EVENLY}],"flex-secondary-align":[{value:"start",modifier:e.ALIGN.SECONDARY.START},{value:"center",modifier:e.ALIGN.SECONDARY.CENTER},{value:"end",modifier:e.ALIGN.SECONDARY.END},{value:"stretch",modifier:e.ALIGN.SECONDARY.STRETCH}],"flex-line-align":[{value:"start",modifier:e.ALIGN.LINE.START},{value:"center",modifier:e.ALIGN.LINE.CENTER},{value:"end",modifier:e.ALIGN.LINE.END},{value:"stretch",modifier:e.ALIGN.LINE.STRETCH},{value:"space-between",modifier:e.ALIGN.LINE.SPACE_BETWEEN},{value:"space-around",modifier:e.ALIGN.LINE.SPACE_AROUND}]},s={float:{modifierSettings:["auto-width","auto-margin","h-alignment"]},stacked:{baseModifier:e.MODE.STACKED,modifierSettings:["auto-margin"]},inline:{baseModifier:e.MODE.INLINE,modifierSettings:["auto-width","auto-margin","h-alignment","v-alignment"]},flex:{baseModifier:e.MODE.FLEX,modifierSettings:["auto-width","auto-margin","flex-orientation","h-alignment","v-alignment","flex-distribute","flex-all","flex-none"]},iqflex:{baseModifier:e.MODE.IQ_FLEX,modifierSettings:["flex-orientation","flex-wrap","flex-primary-align","flex-secondary-align","flex-line-align","flex-none"]}};shmi.visuals.controls.Container=function(e,t){var s=this;s.element=e,s.config=t||{},s.parseAttributes(),shmi.def(s.config,"class-name","container"),shmi.def(s.config,"name",null),shmi.def(s.config,"type","stacked"),shmi.def(s.config,"auto-width",!1),shmi.def(s.config,"auto-margin",!1),shmi.def(s.config,"h-alignment","left"),shmi.def(s.config,"v-alignment","top"),shmi.def(s.config,"flex-orientation","row"),shmi.def(s.config,"flex-distribute",!1),shmi.def(s.config,"flex-all",!1),shmi.def(s.config,"flex-none",!1),shmi.def(s.config,"flex-wrap",!1),shmi.def(s.config,"flex-primary-align","start"),shmi.def(s.config,"flex-secondary-align","stretch"),shmi.def(s.config,"flex-line-align","start"),s.controls=[],s.marginCompensator=null,s.startup()},shmi.visuals.controls.Container.prototype={uiType:"container",isContainer:!0,getClassName:function(){return"Container"},onRegister:function(n){var a=this;!function clearAllModifiers(t){[...Object.values(e.MODE),...Object.values(e.ALIGN.HORIZONTAL),...Object.values(e.ALIGN.VERTICAL),...Object.values(e.AUTO),...Object.values(e.FLEX)].filter((e=>null!==e)).forEach((e=>shmi.removeClass(t,e)))}(a.element),function applyModifiers(e,n){const a=s[n.type];a?(a.baseModifier&&shmi.addClass(e,a.baseModifier),a.modifierSettings.forEach((s=>{const a=t[s];if(!a||!Array.isArray(a))return void console.error("[Container]","missing modifier info:",s);const l=a.find((({value:e})=>n[s]===e));l&&shmi.addClass(e,l.modifier)}))):console.error("[Container]","unknown layout type:",n.type)}(a.element,a.config),a.marginCompensator=function getMarginCompensator(e){let t=e.element.querySelector("div.margin-compensator"),s=null;return t&&t.parentNode===e.element||(t=document.createElement("DIV"),shmi.addClass(t,"margin-compensator"),s=e.element.innerHTML,e.element.innerHTML="",t.innerHTML=s,e.element.appendChild(t)),t}(a),a.parseChildren(a.marginCompensator,n)},onEnable:function(){this.controls.forEach((e=>e.enable()))},onDisable:function(){this.controls.forEach((e=>e.disable()))},onLock:function(){},onUnlock:function(){},onAddControl:function(e,t){const s=this,n=shmi.requires("visuals.tools.controller"),a=[];let l=null;if(!s.initialized)throw new Error("Control not initialized yet.");Array.isArray(e)||(e=[e]),e.forEach((function(e){const t=shmi.createControl(e.ui,s.marginCompensator,e.config,"DIV",null,!1);null!==t&&(e.style&&"object"==typeof e.style&&Object.assign(t.element.style,e.style),a.push(t))})),l=shmi.waitOnInit(a,(function(){if(l){const e=s._init_.tokens.indexOf(l);-1!==e&&s._init_.tokens.splice(e,1),l.unlisten(),l=null}const o=e.map((function(e,t){const l=a[t];return e.controller&&n.create(e.controller.name,e.controller,l.getName()),s.isActive()&&l.enable(),Array.isArray(e.children)&&e.children.length?new Promise((t=>{l.addControl(e.children,(e=>t(e)))})):Promise.resolve()}));Promise.all(o).then((e=>{const s=e.filter((e=>!!e));t(s.length?s[0]:null,a)}))})),l&&s._init_.tokens.push(l)}},shmi.extend(shmi.visuals.controls.Container,shmi.visuals.core.BaseControl)}(),function(){"use strict";var e="datetime-display",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1);t.fLog,t.log;function setText(e,t){e.element.textContent=t}var s={className:"datetime-display",uiType:e,isContainer:!1,config:{"class-name":"text2 datetime-display",name:null,item:null,"display-utc":!1,"display-format":"$YYYY-$MM-$DD $HH:$mm:$ss","input-format":"$X","invalid-text":"---"},configSchema:null,vars:{subscriptionListener:null,localizedDisplayFormat:null,localizedInvalidText:null,rafRunning:!1,lastValue:null},imports:{im:"visuals.session.ItemManager",dtUtils:"visuals.tools.date"},events:[],prototypeExtensions:{onInit:function(){this.vars.localizedDisplayFormat=shmi.localize(this.config["display-format"]),this.vars.localizedInvalidText=shmi.localize(this.config["invalid-text"]),setText(this,this.vars.localizedInvalidText)},onEnable:function(){this.config.item&&!this.vars.subscriptionListener&&(this.vars.subscriptionListener=this.imports.im.subscribeItem(this.config.item,this))},onDisable:function(){this.vars.subscriptionListener&&this.vars.subscriptionListener.unlisten()},onSetValue:function(e,t){t===shmi.c("TYPE_INT")||t===shmi.c("TYPE_FLOAT")?this.vars.lastValue=this.imports.dtUtils.parseDateTime(String(e),this.config["input-format"]||"$X"):this.config["input-format"]?this.vars.lastValue=this.imports.dtUtils.parseDateTime(String(e),this.config["input-format"]):this.vars.lastValue=null,this.vars.rafRunning||(this.vars.rafRunning=!0,shmi.raf(function onDraw(){this.vars.lastValue?setText(this,this.imports.dtUtils.formatDateTime(this.vars.lastValue,{datestring:this.vars.localizedDisplayFormat,utc:this.config["display-utc"]})):setText(this,this.vars.localizedInvalidText),this.vars.rafRunning=!1}.bind(this)))}}};shmi.requires("visuals.tools.control-generator").generate(s)}(),shmi.pkg("visuals.controls"),shmi.visuals.controls.DialogBox=function(e,t){shmi.requires("visuals.gfx.Movable"),shmi.requires("visuals.io.MouseListener"),shmi.requires("visuals.io.TouchListener"),this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","dialog-box"),shmi.def(this.config,"template","default/dialog-box"),shmi.def(this.config,"name",null),shmi.def(this.config,"class-name","dialog-box"),shmi.def(this.config,"initial-state","hidden"),shmi.def(this.config,"collapsible",!1),shmi.def(this.config,"draggable",!1),shmi.def(this.config,"top-level",!1),shmi.def(this.config,"content-template",null),shmi.def(this.config,"tab-limit",!0),this.collapsed=!1,this.hidden=!0,this.active=!1,this.controls=[],this.childrenParsed=!1,this.bgDiv=null,this.dragging=!1,this.mouselistener=null,this.touchlistener=null,this.contentElement=null,this.originalParent=null,this.tokens=[],this.element.style.visibility="hidden",this.startup()},shmi.visuals.controls.DialogBox.prototype={uiType:"dialog-box",isContainer:!0,getClassName:function(){return"DialogBox"},events:["open","close"],onTemplate:function(e,t,s){var n=this;if(t)s();else if(n.element.innerHTML=e,n.contentElement=shmi.getUiElement("dialog-box-content",n.element),n.contentElement&&n.config["content-template"]){var a=0===n.config["content-template"].indexOf(shmi.c("RES_URL_PREFIX"))?n.config["content-template"]:shmi.c("TEMPLATE_PATH")+n.config["content-template"]+shmi.c("TEMPLATE_EXT");shmi.loadResource(a,(function(e,t){t||(n.contentElement.innerHTML=e),s()}))}else s()},onRegister:function(e){var t=this;t.contentElement?t.parseChildren(t.contentElement,e):e()},onInit:function(){var e=this,t=shmi.requires("visuals.tools.iterate.iterateNodeList");if(e.contentElement&&t(shmi.getUiElements("button",e.element),(function(t){t.parentNode&&!shmi.testParentChild(e.contentElement,t)&&(shmi.createControl("button",t,{},"DIV","from").onClick=function(){e.hide()})})),this.titleElement=shmi.getUiElement("dialog-box-title",this.element),this.titleElement||shmi.log("[DialogBox] no dialog-box-title element provided",1),this.frameElement=shmi.getUiElement("dialog-box-frame",this.element),this.frameElement)if(this.hidden="visible"!==this.config["initial-state"],this.hidden&&shmi.addClass(this.element,"hidden"),this.element.style.visibility="",this.containerElement=shmi.getUiElement("dialog-content",this.element),this.containerElement){this.element.setAttribute("tabindex","-1"),this.mover=new shmi.visuals.gfx.Movable(this.containerElement),this.mover.priority=!0;var s={};s.onClick=function(e,t){this.config["close-on-click"]&&this.hide()}.bind(this),!0===this.config.draggable&&(s.onDrag=function(e,t,s){s.preventDefault(),this.mover.translate(e,t);for(var n=0;n<this.controls.length;n++)try{this.controls[n].offsetX=this.mover.startX+this.mover.tx}catch(e){shmi.log("[Dialog-Box] - Can not set control offset",2)}this.dragging||(this.dragging=!0)}.bind(this)),s.onRotate=function(e){this.config["rotation-enabled"]&&this.mover.rotate(57.3*e)}.bind(this),s.onScale=function(e){this.config["scaling-enabled"]&&this.mover.scale(e)}.bind(this),this.titleElement&&this.config.title&&(this.titleElement.textContent=shmi.localize(this.config.title)),s.onPress=function(e,t,s){shmi.addClass(this.element,"pressed"),document.activeElement!==this.element&&this.element.focus(),shmi.log("[DialogBox] pressed",1)}.bind(this),s.onRelease=function(){this.dragging=!1,shmi.removeClass(this.element,"pressed"),shmi.log("[DialogBox] released",1)}.bind(this),this.mouselistener=new shmi.visuals.io.MouseListener(this.containerElement,s),this.touchlistener=new shmi.visuals.io.TouchListener(this.containerElement,s)}else shmi.log("[DialogBox] no dialog-content element provided",3);else shmi.log("[DialogBox] no dialog-box-frame element provided",3)},show:function(){var e=this;if(e.active){if(e.hidden){if(e.hidden=!1,!0===e.config["top-level"]&&(e.originalParent=e.element.parentNode,e.element=document.body.appendChild(e.element)),e.config["cover-background"]&&(e.bgDiv||(e.bgDiv=document.createElement("div"),shmi.addClass(e.bgDiv,"dialog-box-overlay"),e.bgDiv.setAttribute("tabindex","-1"),document.body.appendChild(e.bgDiv)),shmi.removeClass(e.bgDiv,"hidden")),shmi.removeClass(e.element,"hidden"),e.config["tab-limit"]){var t=shmi.requires("visuals.tools.tabulator");e.tabLimit=t.setTabParent(e.element)}e.enableControls(),e.fire("open",{})}}else shmi.log("[DialogBox] cannot show dialog-box without enabling it first",3)},hide:function(){var e=this;this.hidden||(this.hidden=!0,this.config["leave-controls-enabled"]||this.disableControls(),!0===e.config["top-level"]&&(e.element=e.originalParent.appendChild(e.element)),shmi.addClass(this.element,"hidden"),e.tabLimit&&(e.tabLimit.unsetTabParent(),e.tabLimit=null),this.reset(),this.config["cover-background"]&&this.bgDiv&&shmi.addClass(this.bgDiv,"hidden"),this.fire("close",{}))},reset:function(){this.active&&this.mover&&(this.mover.tx=0,this.mover.ty=0,this.mover.rot=0,this.mover.s=1,this.mover.sx=1,this.mover.sy=1,this.mover.update())},onEnable:function(){var e=this;e.mouselistener.enable(),e.touchlistener.enable(),e.tokens.push(shmi.listen("enable",(function(t){-1!==t.source.getName().indexOf(e.getName())&&t.source.getName()!==e.getName()&&"close"===t.source.element.getAttribute("data-function")&&(t.source.onClick=function onClick(){e.hide()})}),{"source.uiType":"button"})),e.hidden||(e.hidden=!0,e.show())},onDisable:function(){var e=this;e.hide(),e.mouselistener.disable(),e.touchlistener.disable(),this.bgDiv&&(this.bgDiv.parentNode.removeChild(this.bgDiv),this.bgDiv=null),e.tokens.forEach((function(e){e.unlisten()})),e.tokens=[]},enableControls:function(){for(var e=0;e<this.controls.length;e++)try{this.controls[e].enable()}catch(t){console.error("[DialogBox]","error enabling control:",this.controls[e],this.getName(),"Exception:",t)}},disableControls:function(){for(var e=0;e<this.controls.length;e++)try{this.controls[e].disable()}catch(t){console.error("[DialogBox]","error disabling control:",this.controls[e],this.getName(),"Exception:",t)}},onAddControl:function(e,t){var s=this,n=shmi.requires("visuals.tools.controller"),a=[],l="["+s.getClassName()+"] ",o=null;if(!s.initialized)throw new Error(l+"Control not initialized yet.");Array.isArray(e)||(e=[e]),s.contentElement?(e.forEach((function(e){var t=shmi.createControl(e.ui,s.contentElement,e.config,"DIV",null,!1);if(null!==t){if(e.style&&"object"==typeof e.style){shmi.requires("visuals.tools.iterate.iterateObject")(e.style,((e,s)=>{t.element.style[s]=e}))}a.push(t)}})),(o=shmi.waitOnInit(a,(function(){var l=-1,r=[],c=shmi.requires("visuals.task"),u=[],m=null;o&&(-1!==(l=s._init_.tokens.indexOf(o))&&s._init_.tokens.splice(l,1),o.unlisten(),o=null),e.forEach((function(e,t){var l=null,o=a[t];e.controller&&n.create(e.controller.name,e.controller,o.getName()),s.isActive()&&!s.hidden&&o.enable(),Array.isArray(e.children)&&e.children.length&&((l=c.createTask("child control")).run=function(){o.addControl(e.children,(function(e,t){e&&r.push(e),l.complete()}))},u.push(l))})),u.length?((m=c.createTaskList(u,!1)).onComplete=function(){t(r.length?r[0]:null,a)},m.run()):t(r.length?r[0]:null,a)})))&&s._init_.tokens.push(o)):t(new Error(l+"Content element missing from template."),a)}},shmi.extend(shmi.visuals.controls.DialogBox,shmi.visuals.core.BaseControl),function(){"use strict";var e="duration-display",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1);t.fLog,t.log;function setText(e,t){e.element.textContent=t}function makeItemHandler(e,t,s){return{setValue:function setValue(n,a){a===shmi.c("TYPE_INT")||a===shmi.c("TYPE_FLOAT")?e.vars[s]=e.imports.dtUtils.parseDateTime(String(n),e.config[t]||"$X"):e.config[t]?e.vars[s]=e.imports.dtUtils.parseDateTime(String(n),e.config[t]):e.vars[s]=null,function doUpdate(e){null===e.vars.tsTarget||null===e.vars.tsCurrent?e.vars.lastValue=null:e.vars.lastValue=e.vars.tsTarget-e.vars.tsCurrent,e.vars.rafRunning||(e.vars.rafRunning=!0,shmi.raf((function onDraw(){e.vars.lastValue?setText(e,e.imports.dtUtils.formatDuration(e.vars.lastValue,e.config["display-preset"]||"compact")):setText(e,e.vars.localizedInvalidText),e.vars.rafRunning=!1})))}(e)}}}var s={className:"duration-display",uiType:e,isContainer:!1,config:{"class-name":"text2 duration-display",name:null,"target-ts-item":null,"target-ts-format":"$X","current-ts-item":"Systemzeit","current-ts-format":"$X","display-preset":"compact","invalid-text":"---"},configSchema:null,vars:{subscriptions:[],tsTarget:null,tsCurrent:null,localizedInvalidText:null,rafRunning:!1,lastValue:null},imports:{im:"visuals.session.ItemManager",dtUtils:"visuals.tools.date"},events:[],prototypeExtensions:{onInit:function(){this.vars.localizedInvalidText=shmi.localize(this.config["invalid-text"]),setText(this,this.vars.localizedInvalidText)},onEnable:function(){this.config["target-ts-item"]&&this.config["current-ts-item"]&&0===this.vars.subscriptions.length&&(this.vars.subscriptions.push(this.imports.im.subscribeItem(this.config["target-ts-item"],makeItemHandler(this,"target-ts-format","tsTarget"))),this.vars.subscriptions.push(this.imports.im.subscribeItem(this.config["current-ts-item"],makeItemHandler(this,"current-ts-format","tsCurrent"))))},onDisable:function(){this.vars.subscriptions.forEach((function(e){e.unlisten()})),this.vars.subscriptions=[]}}};shmi.requires("visuals.tools.control-generator").generate(s)}(),shmi.pkg("visuals.controls"),shmi.visuals.controls.FlipSwitch=function(e,t){shmi.requires("visuals.io.MouseListener"),shmi.requires("visuals.io.TouchListener"),shmi.requires("visuals.gfx.Movable"),this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","flip-switch"),shmi.def(this.config,"template","default/flip-switch"),shmi.def(this.config,"name",null),shmi.def(this.config,"label","flip-switch"),shmi.def(this.config,"on-label","I"),shmi.def(this.config,"off-label","O"),shmi.def(this.config,"on-value",1),shmi.def(this.config,"off-value",0),shmi.def(this.config,"transitionStyle","all .16s linear"),shmi.def(this.config,"confirm-off-text","${V_CONFIRM_OFF}"),shmi.def(this.config,"confirm-on-text","${V_CONFIRM_ON}"),shmi.def(this.config,"confirm-on",!1),shmi.def(this.config,"confirm-off",!1),shmi.def(this.config,"icon-src",null),shmi.def(this.config,"icon-title",null),shmi.def(this.config,"icon-class",null),shmi.def(this.config,"auto-label",!0),this.config["show-icon"]=shmi.toBoolean(this.config["show-icon"]),this.value=0,this.active=!1,this.initialized=!1,this._subscriptionTargetId=null,this.movable=null,this._dragging=!1,this.startup()},shmi.visuals.controls.FlipSwitch.prototype={uiType:"flip-switch",getClassName:function(){return"FlipSwitch"},events:["change"],tooltipProperties:["icon-title"],onInit:function(){var e=this,t=shmi.getUiElement("flip-switch-icon",e.element);if(t){if(e.config["icon-src"])try{t.setAttribute("src",e.config["icon-src"])}catch(e){shmi.log("[Flip Switch] Exception setting icon-src: "+e,2)}else if(e.config["icon-class"]){if("IMG"===t.tagName){var s=document.createElement("div");shmi.addClass(s,"flip-switch-icon"),t.parentNode.insertBefore(s,t),t.parentNode.removeChild(t),t=s}e.config["icon-class"].trim().split(" ").forEach((function(e){shmi.addClass(t,e)}))}}else shmi.log("[Flip Switch] no button-icon element provided",1);if(this.handleElement=shmi.getUiElement("flip-switch-handle",this.element),this.handleElement)if(this.handleBoxElement=shmi.getUiElement("handle-box",this.element),this.handleBoxElement){shmi.log("[FlipSwitch] flip-switch width: "+this.handleBoxElement.offsetWidth,0),shmi.log("[FlipSwitch] handle width: "+this.handleElement.offsetWidth,0),this.labelElement=shmi.getUiElement("label",this.element),this.labelElement||shmi.log("[FlipSwitch] no label element provided (optional)",1),this.onLabelElement=shmi.getUiElement("flip-switch-label-on",this.element),this.onLabelElement||shmi.log("[FlipSwitch] no flip-switch-label-on element provided (optional)",1),this.offLabelElement=shmi.getUiElement("flip-switch-label-off",this.element),this.offLabelElement||shmi.log("[FlipSwitch] no flip-switch-label-off element provided (optional)",1),this.onLabelElement&&this.config["on-label"]&&(this.onLabelElement.textContent=shmi.localize(this.config["on-label"])),this.offLabelElement&&this.config["off-label"]&&(this.offLabelElement.textContent=shmi.localize(this.config["off-label"])),this.labelElement&&this.config.label&&(this.labelElement.textContent=shmi.localize(this.config.label)),this.width=this.handleBoxElement.offsetWidth,this.handleWidth=this.handleElement.offsetWidth,this.movable=new shmi.visuals.gfx.Movable(this.handleElement),this.movable.setTransition(!0),this.movable.transitionStyle=this.config.transitionStyle;var n={};n.onDrag=function(e,t,s){s.preventDefault(),this.movable.tx+e>=0&&this.movable.tx+e+this.handleWidth<=this.handleBoxElement.offsetWidth&&(this._dragging||(this._dragging=!0),this.movable.translate(e,0))}.bind(this),n.onPress=function(){this.movable.setTransition(!1),shmi.addClass(this.handleElement,"pressed")}.bind(this),n.onRelease=function(){this._dragging&&(this._dragging=!1,this.movable.tx>(this.handleBoxElement.offsetWidth-this.handleElement.offsetWidth)/2?this.config["confirm-on"]?shmi.confirm(this.config["confirm-on-text"],(function(t){t?(e.movable.tx=e.handleBoxElement.offsetWidth-e.handleElement.offsetWidth,e.config.item?shmi.visuals.session.ItemManager.writeValue(e.config.item,e.config["on-value"]):e.setValue(e.config["on-value"])):e.setValue(e.value)})):(this.movable.tx=this.handleBoxElement.offsetWidth-this.handleElement.offsetWidth,this.config.item?shmi.visuals.session.ItemManager.writeValue(this.config.item,this.config["on-value"]):this.setValue(this.config["on-value"])):this.config["confirm-off"]?shmi.confirm(this.config["confirm-off-text"],(function(t){t?(e.movable.tx=0,e.config.item?shmi.visuals.session.ItemManager.writeValue(e.config.item,e.config["off-value"]):e.setValue(e.config["off-value"])):e.setValue(e.value)})):(this.movable.tx=0,this.config.item?shmi.visuals.session.ItemManager.writeValue(this.config.item,this.config["off-value"]):this.setValue(this.config["off-value"])),this.movable.update()),this.movable.setTransition(!0),shmi.removeClass(this.handleElement,"pressed")}.bind(this),n.onClick=function(){this.value===this.config["on-value"]?this.config["confirm-off"]?shmi.confirm(this.config["confirm-off-text"],(function(t){t&&(e.config.item?shmi.visuals.session.ItemManager.writeValue(e.config.item,e.config["off-value"]):e.setValue(e.config["off-value"]))})):this.config.item?shmi.visuals.session.ItemManager.writeValue(this.config.item,this.config["off-value"]):this.setValue(this.config["off-value"]):this.config["confirm-on"]?shmi.confirm(this.config["confirm-on-text"],(function(t){t&&(e.config.item?shmi.visuals.session.ItemManager.writeValue(e.config.item,e.config["on-value"]):e.setValue(e.config["on-value"]))})):this.config.item?shmi.visuals.session.ItemManager.writeValue(this.config.item,this.config["on-value"]):this.setValue(this.config["on-value"])}.bind(this);var a={};a.onClick=n.onClick,this.mouseListener=new shmi.visuals.io.MouseListener(this.handleElement,n),this.touchListener=new shmi.visuals.io.TouchListener(this.handleElement,n),this.mouseListener2=new shmi.visuals.io.MouseListener(this.handleBoxElement,a),this.touchListener2=new shmi.visuals.io.TouchListener(this.handleBoxElement,a)}else shmi.log("[FlipSwitch] no handle-box element provided (required)",3);else shmi.log("[FlipSwitch] no flip-switch-handle element provided (required)",3)},onEnable:function(){this.width=this.handleBoxElement.offsetWidth,this.handleWidth=this.handleElement.offsetWidth,this.config.item&&(this._subscriptionTargetId=shmi.visuals.session.ItemManager.subscribeItem(this.config.item,this)),shmi.log("[FlipSwitch] hwidth: "+this.handleWidth+" width: "+this.handleBoxElement.offsetWidth,0),this.mouseListener.enable(),this.touchListener.enable(),this.mouseListener2.enable(),this.touchListener2.enable(),shmi.log("[FlipSwitch] enabled",1)},onDisable:function(){this.config.item&&shmi.visuals.session.ItemManager.unsubscribeItem(this.config.item,this._subscriptionTargetId),this.mouseListener.disable(),this.touchListener.disable(),this.mouseListener2.disable(),this.touchListener2.disable(),shmi.log("[FlipSwitch] disabled",1)},onLock:function(){shmi.log("[FlipSwitch] locked",1),this.mouseListener.disable(),this.touchListener.disable(),this.mouseListener2.disable(),this.touchListener2.disable(),shmi.addClass(this.element,"locked")},onUnlock:function(){shmi.log("[FlipSwitch] unlocked",1),this.mouseListener.enable(),this.touchListener.enable(),this.mouseListener2.enable(),this.touchListener2.enable(),shmi.removeClass(this.element,"locked")},onSetValue:function(e){if(!this._dragging){var t=!1,s=this.value;e===this.config["on-value"]?(this.value=this.config["on-value"],shmi.addClass(this.element,"on"),t=!0):(this.value=this.config["off-value"],shmi.removeClass(this.element,"on")),this.movable.tx=t?this.handleBoxElement.offsetWidth-this.handleWidth:0,s!==this.value&&(this.fire("change",{value:this.value}),this.onChange&&this.onChange(this.value)),this.movable.update()}},getValue:function(){return this.value},setLabel:function(e){var t=this;t.labelElement&&t.config["auto-label"]&&(t.labelElement.textContent=shmi.localize(e))}},shmi.extend(shmi.visuals.controls.FlipSwitch,shmi.visuals.core.BaseControl),shmi.pkg("visuals.controls"),shmi.visuals.controls.Form=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","form"),shmi.def(this.config,"name",null),shmi.def(this.config,"template",null),shmi.def(this.config,"fields",[]),shmi.def(this.config,"id-selector",null),shmi.def(this.config,"datagrid",null),this.values=[],this.controls=[],this.fieldItems=[],this.fieldControls={},this.loadedFields={},this.applyCallback=null,this.cancelCallback=null,this.sel_list_id=null,this.startup()},shmi.visuals.controls.Form.prototype={uiType:"form",isContainer:!0,getClassName:function(){return"Form"},onInit:function(){},onRegister:function(e){var t=this,s=Date.now(),n=null,a=shmi.visuals.session;for(a.FormIDs=a.FormIDs||[];-1!==a.FormIDs.indexOf(s);)s++;a.FormIDs.push(s),t.form_id=s,n=shmi.listen("register-name",(function(e){var s=e.source;if(shmi.testParentChild(t.element,s.element)&&-1!==t.config.fields.indexOf(s.config.field)&&!t.loadedFields[s.config.field]){t.fieldControls[s.config.field]=s;var n="virtual:form:"+t.form_id+":"+s.config.field;s.setItem(n),t.loadedFields[s.config.field]=!0}})),t._init_.tokens.push(n),t.parseChildren(t.element,(function(){n.unlisten(),t._init_.tokens.splice(t._init_.tokens.indexOf(n),1),n=null,e()}))},setValues:function(e,t,s,n){if(this.initialized)if(n||0===this.checkModified()){this.values=e,this.applied=!1,this.canceled=!1,this.values.length!==Object.keys(this.fieldControls).length&&shmi.log("[Form] values length ("+this.values.length+") does not match number of controls("+Object.keys(this.fieldControls).length+")",2),this.deleteFieldItems();for(var a=0;a<this.values.length;a++)if(Array.isArray(this.values[a])){if(2!==this.values[a].length){shmi.log("[Form] invalid value set: "+this.values[a],2);continue}try{this.controls[a].type=parseInt(this.values[a][1]),this.controls[a].setValue(this.values[a][0]),shmi.log("[Form] value set: "+this.values[a][0],2)}catch(e){shmi.log("[Form] exception setting form data: "+e,3)}}else{var l=this.values[a],o="virtual:form:"+this.form_id+":"+l.field;null!==l.type&&void 0!==l.type||(l.type=shmi.c("TYPE_STRING"));var r=shmi.createVirtualItem(o,l.type,Number.NaN,Number.NaN,l.value,this.getFieldValueCallback(l.field));this.fieldItems.push(r),r.writeValue(l.value),l.modified=!1,r.notifyUpdateTargets(),void 0!==this.fieldControls[l.field]&&shmi.removeClass(this.fieldControls[l.field].element,"modified")}if(t)this.applyCallback=t,0!==this.checkModified()&&this.onChange&&this.onChange(this);s&&(this.cancelCallback=s),this.unlock()}else shmi.askSave("${V_ASK_SAVE_MSG}",function(n,a){!0===n?(shmi.log("[Form] applying changes...",shmi.c("LOG_MSG")),this.apply()):shmi.log("[Form] discarding changes...",shmi.c("LOG_MSG")),!0===a?this.setValues(e,t,s,!0):this.unlock()}.bind(this))},deleteFieldItems:function(){this.fieldItems=[]},getFieldValueCallback:function(e){return function(t,s,n){for(var a=e,l=0;l<this.values.length;l++)if(this.values[l].field===a){this.values[l].value!==t?(void 0!==this.fieldControls[a]&&shmi.addClass(this.fieldControls[a].element,"modified"),this.values[l].modified=!0):(void 0!==this.fieldControls[a]&&shmi.removeClass(this.fieldControls[a].element,"modified"),this.values[l].modified=!1);break}this.onChange&&this.onChange(this)}.bind(this)},checkModified:function(){var e=0;void 0===this.values&&(this.values=[]);for(var t=0;t<this.values.length;t++)!0===this.values[t].modified&&e++;return e},apply:function(){var e;for(e=0;e<this.values.length;e++)try{this.values[e].value=this.fieldControls[this.values[e].field].getValue()}catch(e){shmi.log("[Form] control has no value: "+e.toString(),2)}for(this.applied=!0,this.applyCallback?this.applyCallback(this.values):shmi.log("[Form] no apply callback defined",2),e=0;e<this.values.length;e++)void 0!==this.fieldControls[this.values[e].field]&&shmi.removeClass(this.fieldControls[this.values[e].field].element,"modified"),this.values[e].modified=!1},cancel:function(){this.canceled=!0,this.cancelCallback&&this.cancelCallback()},onEnable:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].enable();if(this.config["id-selector"]&&(this.id_selector=shmi.ctrl(this.config["id-selector"]),this.id_selector)){var t=this,s={tableSelectionChange:function(e){t.setDataGridSelection(e)}};s.tableSelectionChange(t.id_selector.getSelectedRows()),this.sel_list_id=this.id_selector.addSelChgEventListener(s)}shmi.log("[Form] enabled",1)},getFormReset:function(e){var t=this;return function(){t.setValues(e,t.applyCallback,t.cancelCallback,!0)}},setDataGridSelection:function(e){var t,s=this,n=shmi.visuals.session.DataGridManager;if(2===e.type&&e.selRows.length>0&&s.config.datagrid){s.unlock();var a=n.grids[s.config.datagrid];if(a){var l,o=[];if(e.selRows.length>1)for(var r=a.getRowData(e.selRows[0]),c=0;c<r.length;c++){for(var u=!0,m=null,h=0;h<e.selRows.length;h++){if(l=a.getRowData(e.selRows[h]),0!==h){if(l[c].value===m)continue;u=!1;break}m=l[c].value}u?o.push({value:m,field:a.fields[c]}):o.push({value:"",field:a.fields[c]})}else for(l=a.getRowData(e.selRows[0]),t=0;t<l.length;t++)o.push({value:l[t].value,field:a.fields[t]});s.setValues(o,s.getDataGridApply(a,e.selRows),s.getFormReset(o),!1)}}else{var d=[];for(t=0;t<s.config.fields.length;t++){var f={type:shmi.c("TYPE_STRING"),field:s.config.fields[t],value:""};d.push(f)}s.setValues(d,null,null),s.lock()}},getDataGridApply:function(e,t){var s,n=this,apply_row=function(a){for(s=0;s<n.config.fields.length;s++){var l=n.fieldControls[n.config.fields[s]];if(l&&n.values[s].modified){var o=e.fields.indexOf(n.config.fields[s]);-1!==o&&e.data[t[a]][o].item.writeValue(l.getValue())}}};return 1===t.length?function(){apply_row(0)}:t.length>1?function(){for(s=0;s<t.length;s++)apply_row(s)}:function(){console.trace("NO_SELECT_STUB")}},onDisable:function(){for(var e=this,t=0;t<e.controls.length;t++)e.controls[t].disable();null!==e.sel_list_id&&e.id_selector&&(e.id_selector.removeSelChgEventListener(e.sel_list_id),e.sel_list_id=null),e.field_ctrl_lid&&(shmi.unlisten("register-name",e.field_ctrl_lid),e.field_ctrl_lid=null),shmi.log("[Form] disabled",1)},onLock:function(){function recLock(e){e.lock(),Array.isArray(e.controls)&&e.controls.forEach(recLock)}shmi.addClass(this.element,"locked"),this.controls.forEach((function(e){recLock(e)})),shmi.log("[Form] locked",1)},onUnlock:function(){function recUnlock(e){e.unlock(),Array.isArray(e.controls)&&e.controls.forEach(recUnlock)}shmi.removeClass(this.element,"locked"),this.controls.forEach((function(e){recUnlock(e)})),shmi.log("[Form] unlocked",1)},onSetValue:function(e){shmi.log("[Form] value set: "+e,0)}},shmi.extend(shmi.visuals.controls.Form,shmi.visuals.core.BaseControl),shmi.pkg("visuals.controls"),shmi.visuals.controls.GpScrollBar=function(e,t){this.c=shmi.visuals.controls.GpScrollBar.c,this.uiElName=shmi.visuals.controls.GpScrollBar.uiElName,this.uiCssCl=shmi.visuals.controls.GpScrollBar.uiCssCl,this.element=e,this.config=t||{},shmi.def(this.config,"class-name","gp-scroll-bar"),shmi.def(this.config,"template","default/gp-scroll-bar"),shmi.def(this.config,"name","Unnamed GpScrollBar"),shmi.def(this.config,"label","Label?"),shmi.def(this.config,"max",100),shmi.def(this.config,"min",0),shmi.def(this.config,"precision",0),shmi.def(this.config,"step",0),shmi.def(this.config,"vertical",!0),shmi.def(this.config,"buttons",!0),shmi.def(this.config,"inverse",!1),this.parseAttributes(),this.isMinimized=!1,this.isEnabled=!1,this.min=0,this.max=0,this.sliderVal=0,this.sliderWidth=0,this.sliderTrackElem=null,this.sliderHandleElem=null,this.sliderHandleVisibleElem=null,this.sliderHandleMovable=null,this.btnUpElem=null,this.btnDownElem=null,this.sliderHandleMouseListener=null,this.sliderHandleTouchListener=null,this.sliderTrackMouseListener=null,this.sliderTrackTouchListener=null,this.btnUpMouseListener=null,this.btnUpTouchListener=null,this.btnDownMouseListener=null,this.btnDownTouchListener=null,this.sbEventListeners={},this.enableTO=null,this.btnStartAutoRepeatTO=null,this.btnProcessAutoRepeatTO=null,this.isBtnAutoRepeatProcessing=!1,this.debug={},this.debug.msgFIFO=[],this.testlog_msg("startup"),this.startup()},shmi.visuals.controls.GpScrollBar.prototype={uiType:"gp-scroll-bar",getClassName:function(){return"GpScrollBar"},onInit:function(){if(this.config.max=shmi.toNumber(this.config.max),this.config.min=shmi.toNumber(this.config.min),this.config.precision=shmi.toNumber(this.config.precision),this.config.step=shmi.toNumber(this.config.step),this.config.vertical=shmi.toBoolean(this.config.vertical),this.config.buttons=shmi.toBoolean(this.config.buttons),this.config.inverse=shmi.toBoolean(this.config.inverse),this.min=this.config.min,this.max=this.config.max,this.sliderVal=this.min,this.sliderWidth=(this.max-this.min)/10,this.sliderTrackElem=shmi.getUiElement(this.uiElName.sliderTrack,this.element),this.sliderTrackElem)if(this.sliderHandleElem=shmi.getUiElement(this.uiElName.sliderHandle,this.element),this.sliderHandleElem)if(this.sliderHandleMovable=new shmi.visuals.gfx.Movable(this.sliderHandleElem),shmi.addClass(this.sliderHandleElem,this.uiCssCl.sliderAni),this.sliderHandleVisibleElem=shmi.getUiElement(this.uiElName.sliderHandleVisible,this.element),this.sliderHandleVisibleElem){if(this.config.buttons){if(shmi.addClass(this.element,this.uiCssCl.withBtns),this.btnUpElem=shmi.getUiElement(this.uiElName.btnUp,this.element),!this.btnUpElem)return void shmi.log("[GpScrollBar] no "+this.uiElName.btnUp+" element provided (required)",3);if(this.btnDownElem=shmi.getUiElement(this.uiElName.btnDown,this.element),!this.btnDownElem)return void shmi.log("[GpScrollBar] no "+this.uiElName.btnDown+" element provided (required)",3)}else{shmi.addClass(this.element,this.uiCssCl.withoutBtns);var e=shmi.getUiElement(this.uiElName.btnPanel,this.element);e&&e.parentNode.removeChild(e)}var t={};t.onDrag=function(e,t,s){s.preventDefault(),this.updateVal(this.sliderHandleMovable.ty+t),this.updateSlider(),this.fireValChanged(this.sliderVal,!1)}.bind(this),t.onPress=function(){shmi.removeClass(this.sliderHandleElem,this.uiCssCl.sliderAni),shmi.addClass(this.sliderHandleVisibleElem,this.uiCssCl.btnSel)}.bind(this),t.onRelease=function(){shmi.addClass(this.sliderHandleElem,this.uiCssCl.sliderAni),shmi.removeClass(this.sliderHandleVisibleElem,this.uiCssCl.btnSel)}.bind(this),this.sliderHandleMouseListener=new shmi.visuals.io.MouseListener(this.sliderHandleElem,t),this.sliderHandleTouchListener=new shmi.visuals.io.TouchListener(this.sliderHandleElem,t);var s={};if(s.onPress=function(e,t,s){shmi.addClass(this.sliderTrackElem,this.uiCssCl.trackSel)}.bind(this),s.onRelease=function(){shmi.removeClass(this.sliderTrackElem,this.uiCssCl.trackSel)}.bind(this),s.onClick=function(e,t,s){var n=t-shmi.getAbsPosition(this.sliderTrackElem).y;this.updateVal(n),this.updateSlider(),this.fireValChanged(this.sliderVal,!0)}.bind(this),this.sliderTrackMouseListener=new shmi.visuals.io.MouseListener(this.sliderTrackElem,s),this.sliderTrackTouchListener=new shmi.visuals.io.TouchListener(this.sliderTrackElem,s),this.btnUpElem){var n={};n.onPress=function(){shmi.addClass(this.btnUpElem,this.uiCssCl.btnSel),this.btnStartAutoRepeatTO&&clearTimeout(this.btnStartAutoRepeatTO),this.btnStartAutoRepeatTO=setTimeout(function(){this.startBtnAutoRepeat("up")}.bind(this),this.c.START_BTN_AUTO_REPEAT_TO),this.fireBtnAction("up")}.bind(this),n.onRelease=function(){this.btnStartAutoRepeatTO&&clearTimeout(this.btnStartAutoRepeatTO),this.stopBtnAutoRepeat(),shmi.removeClass(this.btnUpElem,this.uiCssCl.btnSel)}.bind(this),this.btnUpMouseListener=new shmi.visuals.io.MouseListener(this.btnUpElem,n),this.btnUpTouchListener=new shmi.visuals.io.TouchListener(this.btnUpElem,n);var a={};a.onPress=function(){shmi.addClass(this.btnDownElem,this.uiCssCl.btnSel),this.btnStartAutoRepeatTO&&clearTimeout(this.btnStartAutoRepeatTO),this.btnStartAutoRepeatTO=setTimeout(function(){this.startBtnAutoRepeat("down")}.bind(this),this.c.START_BTN_AUTO_REPEAT_TO),this.fireBtnAction("down")}.bind(this),a.onRelease=function(){this.btnStartAutoRepeatTO&&clearTimeout(this.btnStartAutoRepeatTO),this.stopBtnAutoRepeat(),shmi.removeClass(this.btnDownElem,this.uiCssCl.btnSel)}.bind(this),this.btnDownMouseListener=new shmi.visuals.io.MouseListener(this.btnDownElem,a),this.btnDownTouchListener=new shmi.visuals.io.TouchListener(this.btnDownElem,a)}this.resizeListener=function(){this.processEvtOnResize()}.bind(this),shmi.log("[GpScrollBar] initialized",1)}else shmi.log("[GpScrollBar] no "+this.uiElName.sliderHandleVisibleElem+" provided (required)",3);else shmi.log("[GpScrollBar] no "+this.uiElName.sliderHandle+" provided (required)",3);else shmi.log("[GpScrollBar] no "+this.uiElName.sliderTrack+" element provided (required)",3)},onEnable:function(){this.testlog_msg("onEnable"),window.addEventListener("resize",this.resizeListener,!0),this.updateSlider(),this.isEnabled=!0,this.updateEvtEnable(),shmi.log("[GpScrollBar] enabled",1)},onDisable:function(){this.testlog_msg("onEnable"),window.removeEventListener("resize",this.resizeListener,!0),this.isEnabled=!1,this.updateEvtEnable(),shmi.log("[GpScrollBar] disabled",1)},onDelete:function(){},setSliderVal:function(e){this.sliderVal=e,this.updateSlider(),shmi.log("[GpScrollBar] setSliderVal called, val: "+e,1)},setSliderWidth:function(e){this.sliderWidth=e,this.updateSlider(),shmi.log("[GpScrollBar] setSliderWidth called, width: "+e,1)},setSliderProps:function(e,t){this.sliderVal=e,this.sliderWidth=t,this.updateSlider(),shmi.log("[GpScrollBar] setSliderProps called, val: "+e+" - width: "+t,1)},getSliderVal:function(){return shmi.log("[GpScrollBar] getSliderVal called, return: "+this.sliderVal,1),this.sliderVal},getSliderWidth:function(){return shmi.log("[GpScrollBar] getSliderVal called, return: "+this.sliderWidth,1),this.sliderWidth},setMin:function(e){this.min=e,this.updateSlider(),shmi.log("[GpScrollBar] setMin called, min: "+e,1)},setMax:function(e){this.max=e,this.updateSlider(),shmi.log("[GpScrollBar] setMax called, min: "+e,1)},setMinMax:function(e,t){this.min=e,this.max=t,this.updateSlider(),shmi.log("[GpScrollBar] setMinMax called, min: "+e+" - max: "+t,1)},getMin:function(){return shmi.log("[GpScrollBar] getMin called, return: "+this.min,1),this.min},getMax:function(){return shmi.log("[GpScrollBar] getMax called, return: "+this.max,1),this.max},setAllProps:function(e,t,s,n){this.sliderVal=e,this.sliderWidth=t,this.min=s,this.max=n,this.updateSlider(),shmi.log("[GpScrollBar] setAllProps called, , val: "+e+" - width: "+t+" - min: "+s+" - max: "+n,1)},setMinimized:function(e){this.isMinimized=e,this.updateEvtEnable(),e?(shmi.removeClass(this.element,this.uiCssCl.normal),shmi.addClass(this.element,this.uiCssCl.minimized)):(shmi.removeClass(this.element,this.uiCssCl.minimized),shmi.addClass(this.element,this.uiCssCl.normal))},getMinimized:function(){return this.isMinimized},addEventListener:function(e){for(var t=Date.now();void 0!==this.sbEventListeners[t];)t++;return this.sbEventListeners[t]={},this.sbEventListeners[t].listener=e,shmi.log("[GpScrollBar] addEventListener called, listenerObj: "+e+" - id:"+t,1),t},removeEventListener:function(e){void 0!==this.sbEventListeners[e]?delete this.sbEventListeners[e]:shmi.log("[GpScrollBar] removeEventListener - id "+e+" does not exist",2),shmi.log("[GpScrollBar] removeEventListener called, id: "+e,1)},startBtnAutoRepeat:function(e){this.isBtnAutoRepeatProcessing=!0,this.btnProcessAutoRepeatTO&&clearTimeout(this.btnProcessAutoRepeatTO),this.btnProcessAutoRepeatTO=setTimeout(function(){this.processBtnAutoRepeat(e)}.bind(this),this.c.PROCESS_BTN_AUTO_REPEAT_TO)},processBtnAutoRepeat:function(e){this.isBtnAutoRepeatProcessing&&(this.fireBtnAction(e),this.btnProcessAutoRepeatTO=setTimeout(function(){this.processBtnAutoRepeat(e)}.bind(this),this.c.PROCESS_BTN_AUTO_REPEAT_TO))},stopBtnAutoRepeat:function(){this.isBtnAutoRepeatProcessing=!1,this.btnProcessAutoRepeatTO&&clearTimeout(this.btnProcessAutoRepeatTO)},processEvtOnResize:function(){this.updateSlider()},updateSlider:function(){if(this.initialized){var e=this.sliderWidth*this.sliderTrackElem.offsetHeight/(this.max-this.min);this.isMinimized?e<this.c.MIN_SLIDER_SIZE_PX_MINIMIZED&&(e=this.c.MIN_SLIDER_SIZE_PX_MINIMIZED):e<this.c.MIN_SLIDER_SIZE_PX&&(e=this.c.MIN_SLIDER_SIZE_PX);var t=this.sliderTrackElem.offsetHeight-e,s=(this.max-this.sliderVal)*t/(this.max-this.min);this.sliderHandleElem.style.height=e+"px",this.config.inverse||(s=t-s),this.sliderHandleMovable.translate(0,s-this.sliderHandleMovable.ty)}},updateVal:function(e){if(this.initialized){var t=this.max-e*(this.max-this.min)/(this.sliderTrackElem.offsetHeight-this.sliderHandleElem.offsetHeight);this.config.inverse||(t=this.max-t),t<this.min?this.sliderVal=this.min:t>this.max?this.sliderVal=this.max:this.sliderVal=t}},updateEvtEnable:function(){var e=this.isEnabled&&!this.isMinimized;this.initialized?(this.testlog_msg("init ok - en: "+this.isEnabled+" - min: "+this.isMinimized),e?(this.sliderHandleMouseListener.enable(),this.sliderHandleTouchListener.enable(),this.sliderTrackMouseListener.enable(),this.sliderTrackTouchListener.enable(),this.btnUpElem&&(this.btnUpMouseListener.enable(),this.btnUpTouchListener.enable(),this.btnDownMouseListener.enable(),this.btnDownTouchListener.enable())):(this.sliderHandleMouseListener.disable(),this.sliderHandleTouchListener.disable(),this.sliderTrackMouseListener.disable(),this.sliderTrackTouchListener.disable(),this.btnUpElem&&(this.btnUpMouseListener.disable(),this.btnUpTouchListener.disable(),this.btnDownMouseListener.disable(),this.btnDownTouchListener.disable()))):(this.testlog_msg("init ! ok - repeat"),this.enableTO&&clearTimeout(this.enableTO),this.enableTO=setTimeout(function(){this.updateEvtEnable()}.bind(this),this.c.ENABLE_TO))},fireValChanged:function(e,t){shmi.requires("visuals.tools.iterate.iterateObject")(this.sbEventListeners,(s=>{s.listener.gpsbOnValChange(e,t)}))},fireBtnAction:function(e){shmi.requires("visuals.tools.iterate.iterateObject")(this.sbEventListeners,(t=>{t.listener.gpsbOnBtnAction(e)}))},testlog_msg:function(e){var t=document.getElementById("debugDisplEvents");if(t){var s=[];t.innerHTML="",s.push("last debug messages:"),s.push("---"),console.log(e),this.debug.msgFIFO.push(e),this.debug.msgFIFO.length>10&&this.debug.msgFIFO.shift();for(var n=this.debug.msgFIFO.length-1;n>=0;n--)s.push(this.debug.msgFIFO[n]);for(s.push("--------------------------------"),n=0;n<s.length;n++)t.innerHTML+=s[n]+"<br>"}}},shmi.extend(shmi.visuals.controls.GpScrollBar,shmi.visuals.core.BaseControl),shmi.registerControlType("gp-scroll-bar",shmi.visuals.controls.GpScrollBar,!0),shmi.visuals.controls.GpScrollBar.uiElName={},function(){var e=shmi.visuals.controls.GpScrollBar.uiElName;e.sliderTrack="gpsb-slider-track",e.sliderHandle="gpsb-slider-handle",e.sliderHandleVisible="gpsb-slider-handle-visible",e.btnPanel="gpsb-btn-panel",e.btnUp="gpsb-btn-up",e.btnDown="gpsb-btn-down",shmi.visuals.controls.GpScrollBar.uiCssCl={},(e=shmi.visuals.controls.GpScrollBar.uiCssCl).withBtns="gpsb-with-btns",e.withoutBtns="gpsb-without-btns",e.btnSel="gpsb-btn-selected",e.trackSel="gpsb-track-selected",e.minimized="gpsb-minimized",e.normal="gpsb-normal",e.sliderAni="gpsb-slider-ani",shmi.visuals.controls.GpScrollBar.c={},(e=shmi.visuals.controls.GpScrollBar.c).MIN_SLIDER_SIZE_PX=60,e.MIN_SLIDER_SIZE_PX_MINIMIZED=5,e.ENABLE_TO=500,e.START_BTN_AUTO_REPEAT_TO=1e3,e.PROCESS_BTN_AUTO_REPEAT_TO=100}(),shmi.pkg("visuals.controls"),shmi.visuals.controls.Group=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","group"),shmi.def(this.config,"template",null),shmi.def(this.config,"name",null),shmi.def(this.config,"replacers",{}),this.initialized=!1,this.controls=[],this.startup()},shmi.visuals.controls.Group.prototype={uiType:"group",isContainer:!0,getClassName:function(){return"Group"},onRegister:function(e){this.parseChildren(this.element,e)},onInit:function(){},onEnable:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].enable();shmi.log("[Group] enabled",1)},onDisable:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].disable();shmi.log("[Group] disabled",1)},onLock:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].lock();shmi.addClass(this.element,"locked"),shmi.log("[Group] locked",1)},onUnlock:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].unlock();shmi.removeClass(this.element,"locked"),shmi.log("[Group] locked",1)},onSetValue:function(e){shmi.log("[Group] value set: "+e,0)}},shmi.extend(shmi.visuals.controls.Group,shmi.visuals.core.BaseControl),function(){"use strict";var e={className:"Html",uiType:"html",isContainer:!1,config:{"class-name":"html",name:null,template:"default/html","use-shadow-dom":!1,html:""},configSchema:null,vars:{html:null},imports:{},events:[],prototypeExtensions:{onInit:function(){const e=this,t=shmi.getUiElement("html",e.element);if(!t)return void console.log('Error: "html" element is missing in template!');const s=e.config["use-shadow-dom"]?t.attachShadow({mode:"open"}):t;e.vars.html=s,s.appendChild(function documentFragmentFromHTML(e){const t=document.createElement("template");return t.innerHTML=e,t.content.cloneNode(!0)}(e.config.html))},getRootNode:function(){return this.vars.html}}};shmi.requires("visuals.tools.control-generator").generate(e)}(),function(){"use strict";var e={className:"Iframe",uiType:"iframe",isContainer:!1,config:{"class-name":"iframe",name:null,template:"default/iframe ",src:"about:blank","disable-scrollbar":!1},configSchema:null,vars:{iframe:null},imports:{im:"visuals.session.ItemManager",qm:function(){return shmi.visuals.session.QueryManager}},events:[],prototypeExtensions:{onInit:function(){var e=this;e.vars.iframe=e.element.querySelector("iframe"),e.vars.iframe&&(e.vars.iframe.onerror=function(e){shmi.notify("Error loading IFrame: "+e.toString())},e.vars.iframe.setAttribute("src",e.config.src),e.config["disable-scrollbar"]&&(e.vars.iframe.setAttribute("scrolling","no"),e.vars.iframe.style.overflow="hidden"))},onEnable:function(){},onDisable:function(){},onLock:function(){this.vars.iframe&&(this.vars.iframe.style.pointerEvents="none")},onUnlock:function(){this.vars.iframe&&(this.vars.iframe.style.pointerEvents="")},onSetValue:function(e,t,s){},onSetProperties:function(e,t,s){}}};shmi.requires("visuals.tools.control-generator").generate(e)}(),function(){"use strict";var e="image-changer",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1);t.fLog,t.log;function getActive(e,t){var s=e.config.options.find((function(e){return e.value===t}));s||(s={"icon-src":e.config["default-image"],label:e.config["default-title"]||null}),e.vars.activeOption=s,e.vars.elements.img.setAttribute("src",s["icon-src"]),e.setTooltip(e.getTooltip())}var s={className:"ImageChanger",uiType:e,isContainer:!1,config:{"class-name":"image-changer",name:null,template:"default/image-changer",options:[],"default-image":"pics/system/icons/placeholder.svg","default-title":null},configSchema:null,vars:{tokens:[],listeners:[],value:null,activeOption:null,elements:{img:null}},imports:{im:"visuals.session.ItemManager",qm:function(){return shmi.visuals.session.QueryManager}},events:[],prototypeExtensions:{getTooltip:function(){var e=this,t=shmi.visuals.core.BaseControl.prototype.getTooltip.call(this);return t||(e.activeOption&&e.activeOption.label?e.activeOption.label:null)},onInit:function(){var e=this;e.vars.elements.img=shmi.getUiElement("image",e.element),getActive(e,null)},onEnable:function(){var e=this,t=shmi.requires("visuals.session.ItemManager");e.config.item&&e.vars.tokens.push(t.subscribeItem(e.config.item,e))},onDisable:function(){this.vars.tokens.forEach((function(e){e.unlisten()})),this.vars.tokens=[]},onLock:function(){},onUnlock:function(){},onSetValue:function(e,t,s){var n=this;n.vars.value=e,getActive(n,n.vars.value)},onSetProperties:function(e,t,s){}}};shmi.requires("visuals.tools.control-generator").generate(s)}(),shmi.visuals.controls.Image=function(e,t){this.element=e,this.config=t||{},this.run=!1,this.loaded=!1,shmi.def(this.config,"image-src","pics/system/icons/placeholder.svg"),shmi.def(this.config,"image-alt",null),shmi.def(this.config,"image-title",null),shmi.def(this.config,"class-name","image"),shmi.def(this.config,"template","default/image"),shmi.def(this.config,"label","image"),this.listeners=[],this.parseAttributes(),this.imgElement=null,this.startup()},shmi.visuals.controls.Image.prototype={uiType:"image",isContainer:!1,events:["click"],tooltipProperties:["image-title"],getClassName:function(){return"Image"},onInit:function(){var e=this,t=shmi.visuals.io,s=null,n=null,a=null;this.imgElement=shmi.getUiElement("image",this.element),this.labelElement=shmi.getUiElement("label",this.element),this.imgElement&&(this.imgElement.setAttribute("draggable","false"),this.config["image-src"]&&this.imgElement.setAttribute("src",this.config["image-src"]),this.config["image-alt"]&&this.imgElement.setAttribute("alt",this.config["image-alt"]),s={onClick:function(t,s,n){e.fire("click",{x:t,y:s,event:n})}},n=new t.MouseListener(e.imgElement,s),a=new t.TouchListener(e.imgElement,s),e.listeners.push(n,a)),this.labelElement&&(this.labelElement.textContent=shmi.localize(this.config.label))},onEnable:function(){this.listeners.forEach((function(e){e.enable()}))},onDisable:function(){this.listeners.forEach((function(e){e.disable()}))},onLock:function(){this.listeners.forEach((function(e){e.disable()})),shmi.addClass(this.element,"locked")},onUnlock:function(){this.listeners.forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked")},setLabel:function(e){this.labelElement&&(this.labelElement.textContent=shmi.localize(e))}},shmi.extend(shmi.visuals.controls.Image,shmi.visuals.core.BaseControl),shmi.registerControlType("image",shmi.visuals.controls.Image,!1),function(){function isInputElement(e){return["INPUT","TEXTAREA"].includes(e.tagName)}function insertValue(e,t){isInputElement(e.valueElement)?(e.valueElement.value="",e.valueElement.value=t):(e.valueElement.textContent=t,e.valueElement.firstChild||e.valueElement.appendChild(document.createTextNode(""))),e.config["value-as-tooltip"]&&(null!=t&&""!==t?e.setTooltip(String(t)):e.setTooltip(e.getTooltip()))}function retrieveValue(e){return isInputElement(e.valueElement)?e.valueElement.value:e.valueElement.textContent}function selectContent(e){if(isInputElement(e.valueElement))e.valueElement.select();else if(shmi.addClass(e.valueElement,"selectableText"),window.getSelection().removeAllRanges(),e.valueElement.firstChild&&e.valueElement.lastChild&&e.valueElement.firstChild instanceof Node&&e.valueElement.lastChild instanceof Node){const t=document.createRange();t.setStart(e.valueElement.firstChild,0),t.setEnd(e.valueElement.lastChild,e.valueElement.lastChild.length),window.getSelection().addRange(t)}}function handleFocus(e){e.locked||e.focused||(e.focused||null===shmi.visuals.session.FocusElement||(shmi.visuals.session.FocusElement.blur(),shmi.visuals.session.FocusElement=null),shmi.log("[InputField] focused",1),e.vars.wasClicked&&function showNumpad(e){if(!e.config["numpad-enabled"])return!1;var t=shmi.requires("visuals.tools.numericValues"),s=null,n=null,a=shmi.visuals.session.ItemManager;e.vars&&e.vars.valueSettings||t.initValueSettings(e);return n={"decimal-delimiter":e.config["decimal-delimiter"],unit:void 0!==e.vars.unit?e.vars.unit:e.config["unit-text"],label:void 0!==e.vars.label?e.vars.label:e.config.label,value:retrieveValue(e),callback:function(t){e.config.item?(e.config.multiline&&(t=t.toString()),a.writeValue(e.config.item,t)):e.setValue(t)}},s=e.vars.valueSettings,n.min=s.min,n.max=s.max,n.type=s.type,n.precision=s.precision,shmi.numpad(n),!0}(e)||e.vars.wasClicked&&function showKeyboard(e){var t=shmi.requires("visuals.session.config");if(!t.keyboard||!t.keyboard.enabled)return!1;var s=shmi.visuals.session.ItemManager,n={value:retrieveValue(e),"select-box-enabled":t.keyboard["language-selection"],"password-input":e.valueElement&&e.valueElement.type&&"password"===e.valueElement.type.toLowerCase(),"show-enter":e.config.multiline,callback:function(t,n){t&&(e.config.item?s.writeValue(e.config.item,n):e.setValue(n))}};return shmi.keyboard(n),!0}(e)||(selectContent(e),e.focused=!0,e.valueElement.focus(),shmi.visuals.session.FocusElement=e.valueElement,clearTimeout(e.vars.to_enter),e.vars.to_enter=setTimeout((function(){e.fire("enter",{value:e.value})}),250)))}shmi.pkg("visuals.controls"),shmi.visuals.controls.InputField=function(e,t){this.element=e,this.value=null,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","input-field"),shmi.def(this.config,"template","default/input-field"),shmi.def(this.config,"name",null),shmi.def(this.config,"item",null),shmi.def(this.config,"value-alignment","left"),shmi.def(this.config,"numeric-class","numeric"),shmi.def(this.config,"min",Number.NEGATIVE_INFINITY),shmi.def(this.config,"auto-min",!0),shmi.def(this.config,"max",Number.POSITIVE_INFINITY),shmi.def(this.config,"auto-max",!0),shmi.def(this.config,"step",0),shmi.def(this.config,"auto-step",!1),shmi.def(this.config,"precision",-1),shmi.def(this.config,"auto-precision",!0),shmi.def(this.config,"unit-scale",1),shmi.def(this.config,"decimal-delimiter","."),shmi.def(this.config,"label","input-field"),shmi.def(this.config,"auto-label",!0),shmi.def(this.config,"unit-text",null),shmi.def(this.config,"auto-unit-text",!0),shmi.def(this.config,"type",shmi.c("TYPE_STRING")),shmi.def(this.config,"auto-type",!0),shmi.def(this.config,"numpad-enabled",!1),shmi.def(this.config,"multiline",!1),shmi.def(this.config,"value-as-tooltip",!1),this.type=shmi.c("TYPE_STRING"),this.valueElement=null,this.unitElement=null,this.textareaElement=null,this.mouseListener=null,this.touchListener=null,this.active=!1,this._subscriptionTargetId=null,this._timeout=0,this.vars={to_enter:0,wasClicked:!1},this.startup()},shmi.visuals.controls.InputField.prototype={uiType:"input-field",events:["change","enter"],getClassName:function(){return"InputField"},onInit:function(){var e=this,t=shmi.Constants;if(this.valueElement=shmi.getUiElement("input-field-value",this.element),this.valueElement){if(this.unitElement=shmi.getUiElement("input-field-unit",this.element),this.unitElement||shmi.log("[InputField] no input-field-unit element provided",1),this.labelElement=shmi.getUiElement("input-field-label",this.element),this.labelElement?void 0!==this.config.label&&(e.vars=e.vars||{},e.vars.label=this.config.label,this.labelElement.textContent=shmi.localize(this.config.label)):shmi.log("[InputField] no input-field-label element provided",1),this.config.multiline){if(this.valueBox=this.element.getElementsByClassName("value-box")[0],!this.valueBox)return void shmi.log("[InputField] no value-box element provided",3);this.valueElement.remove();var s=document.createElement("textarea");s.setAttribute("data-ui","input-field-value"),s.disabled=!0,this.textareaElement=s,shmi.addClass(s,"input-field-value"),this.valueElement=this.valueBox.appendChild(s),shmi.addClass(e.element,"textarea")}else this.textareaElement=null;this.valueElement.setAttribute("tabindex","0"),insertValue(e,"");var n=parseInt(this.config.type);isNaN(n)||(this.type=n),this.config.action&&(this.action=new shmi.visuals.core.UiAction(this.config.action,this)),e.config["auto-type"]||"auto"!==e.config["value-alignment"]?"right"===e.config["value-alignment"]&&shmi.addClass(e.element,e.config["numeric-class"]):-1!==[t.TYPE_BOOL,t.TYPE_INT,t.TYPE_FLOAT].indexOf(e.type)&&shmi.addClass(e.element,e.config["numeric-class"]);var a={};a.onPress=function(e,t,s){isInputElement(this.valueElement)||this.focused?this.focused&&window.getSelection().removeAllRanges():s.preventDefault()}.bind(this),a.onClick=function(){e.vars.wasClicked=!0,handleFocus(e),e.vars.wasClicked=!1},this.mouseListener=new shmi.visuals.io.MouseListener(this.valueElement,a),this.touchListener=new shmi.visuals.io.TouchListener(this.valueElement,a,!0),this.valueElement.addEventListener("focus",(function(){e.config.multiline?e.focused=!0:e.vars.wasClicked||handleFocus(e)})),this.valueElement.addEventListener("keypress",function(t){(13===t.keyCode&&!e.config.multiline||9===t.keyCode)&&(t.preventDefault(),window.getSelection().removeAllRanges(),this.valueElement.blur())}.bind(this)),this.valueElement.addEventListener("blur",function(){this.focused&&(shmi.log("[InputField] blur event",1),window.getSelection().removeAllRanges(),shmi.removeClass(this.valueElement,"selectableText"),this.validate(this.valueElement),this.focused=!1,shmi.visuals.session.FocusElement=null)}.bind(this)),this.valueElement.addEventListener("keydown",(function(t){if(e.type===shmi.c("TYPE_FLOAT")){var s="."===e.config["decimal-delimiter"]?",":".";t.key===s&&t.preventDefault()}})),isInputElement(this.valueElement)||this.valueElement.addEventListener("paste",(async t=>{t.preventDefault();try{const t=await navigator.clipboard.readText(),s=e.valueElement,n=window.getSelection();if(n.rangeCount){const e=n.getRangeAt(0),a=e.startOffset;if(e.commonAncestorContainer.parentNode===s){const n=s.textContent,a=n.substring(0,e.startOffset),l=n.substring(e.endOffset,n.length);s.textContent=`${a}${t}${l}`}else e.commonAncestorContainer===s&&(s.textContent=t);if(s.firstChild){const n=a+t.length;e.setEnd(s.firstChild,n),e.setStart(s.firstChild,n)}}}catch(e){console.error("[InputField] error pasting from clipboard:",e)}})),this.config["unit-text"]&&(e.vars=e.vars||{},e.vars.unit=this.config["unit-text"],this.unitElement&&(this.unitElement.textContent=shmi.localize(this.config["unit-text"]))),this.config["unit-scale"]&&(this.config["unit-scale"]=parseFloat(shmi.localize(this.config["unit-scale"])))}else shmi.log("[InputField] no input-field-value element provided",3)},validate:function(e){const t=this,s=shmi.visuals.session.ItemManager,n=shmi.requires("visuals.tools.numericValues"),a=retrieveValue(t),l=t.value;if(a===l)return;if(t.config["auto-type"]){if(t.config.multiline)t.type=shmi.c("TYPE_STRING");else if(t.config.item){const e=s.getItem(t.config.item);e&&(t.type=e.type)}}else;const o=t.config.multiline?a:[shmi.c("TYPE_INT"),shmi.c("TYPE_FLOAT")].includes(t.type)?t.floatRegexp.test(a.replace(t.config["decimal-delimiter"],"."))?n.applyInputSettings(a,t):l:a;t.value=o,insertValue(t,null==o?"":n.formatOutput(o,t)),o!==l&&(t.config.item&&s.writeValue(t.config.item,o),t.action&&t.action.execute(o),t.fire("change",{value:t.value}),t.onChange&&t.onChange(t.value))},onSetProperties:function(e,t,s,n,a){var l=this,o=shmi.Constants,r=shmi.requires("visuals.tools.numericValues");l.config["auto-type"]&&"auto"===l.config["value-alignment"]&&[o.TYPE_BOOL,o.TYPE_INT,o.TYPE_FLOAT].indexOf(a)&&shmi.addClass(l.element,l.config["numeric-class"]),r.setProperties(l,arguments),shmi.log("[InputField] min: "+e+" max: "+t+" step: "+s,1)},onSetValue:function(e){var t=this,s=shmi.visuals.session.ItemManager,n=shmi.requires("visuals.tools.numericValues"),a=null,l=t.value;t.config.item&&t.config["auto-type"]&&((a=s.getItem(t.config.item))?t.type=a.type:shmi.visuals.session.config.debug&&console.debug(t.getClassName(),"configured item not available:",t.config.item)),t.value=e,insertValue(t,n.formatOutput(t.value,t)),document.activeElement===t.valueElement&&selectContent(t),shmi.log("[InputField] new value: "+this.value,0),this.value!==l&&(this.fire("change",{value:this.value}),this.onChange&&this.onChange(this.value))},getValue:function(){var e=this.type;return this.config.item&&this.config["auto-type"]&&(e=shmi.visuals.session.ItemManager.items[this.config.item].type),e===shmi.c("TYPE_INT")?Math.round(this.value/this.config["unit-scale"]):e===shmi.c("TYPE_FLOAT")?this.value/this.config["unit-scale"]:this.value},onEnable:function(){this.valueElement.setAttribute("contenteditable",!0),this.config.multiline||(this.mouseListener.enable(),this.touchListener.enable()),this.config.item&&(this._subscriptionTargetId=shmi.visuals.session.ItemManager.subscribeItem(this.config.item,this)),this.textareaElement&&(this.textareaElement.disabled=!1),shmi.log("[InputField] enabled",1)},onDisable:function(){this.valueElement.setAttribute("contenteditable",!1),shmi.removeClass(this.valueElement,"selectableText"),this.config.item&&shmi.visuals.session.ItemManager.unsubscribeItem(this.config.item,this._subscriptionTargetId),this.config.multiline||(this.mouseListener.disable(),this.touchListener.disable()),shmi.log("[InputField] disabled",1)},onLock:function(){this.locked=!0,shmi.log("[InputField] locked",1),isInputElement(this.valueElement)?this.valueElement.setAttribute("disabled",!0):this.valueElement.setAttribute("contenteditable",!1),shmi.removeClass(this.valueElement,"selectableText"),this.config.multiline||(this.mouseListener.disable(),this.touchListener.disable()),shmi.addClass(this.element,"locked")},onUnlock:function(){this.locked=!1,shmi.log("[InputField] unlocked",1),isInputElement(this.valueElement)?this.valueElement.removeAttribute("disabled"):this.valueElement.setAttribute("contenteditable",!0),this.config.multiline||(this.mouseListener.enable(),this.touchListener.enable()),shmi.removeClass(this.element,"locked")},setLabel:function(e){var t=this;t.config["auto-label"]&&t.labelElement&&(t.vars=t.vars||{},t.vars.label=e,t.labelElement.textContent=shmi.localize(e))},setUnitText:function(e){var t=this;t.config["auto-unit-text"]&&t.unitElement&&(t.vars=t.vars||{},t.vars.unit=e,t.unitElement.textContent=shmi.localize(e))},floatRegexp:/(^[+-]?[0-9]([.][0-9]*)?$|^[+-]?[1-9]+[0-9]*([.][0-9]*)?$)/,intRegexp:/(^[+-]?[0-9]$|^[+-]?[1-9]+[0-9]*$)/},shmi.extend(shmi.visuals.controls.InputField,shmi.visuals.core.BaseControl)}(),function(){"use strict";const e="iq-alarm-info",t={"class-name":e,name:null,template:"default/iq-alarm-info",noAlarm:null,action:null,enableCycle:!0,cycleInterval:1e3,showAlarm:!0,showWarn:!0,showInfo:!0,groupFilter:null,"icon-info":"pics/system/controls/iq-alarm-info/icon-info.svg","icon-warning":"pics/system/controls/iq-alarm-info/icon-warning.svg","icon-alarm":"pics/system/controls/iq-alarm-info/icon-alarm.svg","icon-idle":null},s=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1).log,n=["severity-info","severity-warning","severity-alarm"];function parseAlarmGroupFilter(e){if("string"!=typeof e)return null;let t=e.split(",");t=t.map((e=>{if(e.includes("-"))return function parseAlarmGroupRange(e){const t=e.split("-");if(2===t.length){const e=parseInt(t[0]),s=parseInt(t[1]);if(!isNaN(e)&&!isNaN(s)&&e>=0&&s>=e)return[e,s]}return null}(e);const t=parseInt(e);return!isNaN(t)&&t>=0?t:null})),t=t.filter((e=>null!==e));const s=[];return t.forEach((e=>{if(Array.isArray(e)){let n=e[0];for(;n<=e[1];)s.includes(n)&&t.includes(n)||s.push(n),n+=1}})),t.push(...s),t.length?t:null}function testAlarmState(e){const t=Object.values(e.imports.am.alarms).map((e=>e.properties));Array.isArray(t)&&(t.length<1?clearAlarmMsg(e):(clearInt(e),e.config.enableCycle?(e.vars.activeAlarmList=getEnabledAlarms(e,t),e.vars.alarmCount=e.vars.activeAlarmList.length,e.vars.alarmCount>1&&(e.vars.interval=setInterval(displayAlarms.bind(null,e),e.config.cycleInterval))):e.vars.activeAlarmList=function getLastHighest(e,t){let s=null;const n=getEnabledAlarms(e,t);return e.vars.alarmCount=n.length,n.forEach((function(e){(null===s||e.severity>=s.severity&&e.timestamp_in>s.timestamp_in)&&(s=e)})),null===s?[]:[s]}(e,t),displayAlarms(e)))}function displayAlarms(e){0===e.vars.activeAlarmList.length&&clearAlarmMsg(e),e.vars.currentAlarm>=e.vars.activeAlarmList.length&&(e.vars.currentAlarm=0);const t=e.vars.activeAlarmList[e.vars.currentAlarm++];let s=null,n="";t?(s=shmi.evalString(shmi.localize(`\${alarm_title_${t.index}}`),t),n=shmi.evalString(shmi.localize(`\${alarm_msg_${t.index}}`),t)):s=shmi.localize(e.config.noAlarm),setAlarmStyle(t?t.severity:-1,e),setTextContent(e,"alarmMessage",s),setTextContent(e,"alarmDetails",n),setTextContent(e,"alarmCount",e.vars.alarmCount)}function getEnabledAlarms(e,t){return t.filter((function(t){return!(Array.isArray(e.vars.groupFilter)&&!e.vars.groupFilter.includes(t.group))&&(!!(t.active||t.acknowledgeable&&!t.acknowledged)&&(2===t.severity&&e.config.showAlarm||1===t.severity&&e.config.showWarn||0===t.severity&&e.config.showInfo))}))}function clearAlarmMsg(e){clearInt(e),e.vars.currentAlarm=0,setAlarmStyle(-1,e),setTextContent(e,"alarmMessage",shmi.localize(e.config.noAlarm))}function clearInt(e){e.vars.interval&&(clearInterval(e.vars.interval),e.vars.interval=null)}function setAlarmIcon(e,t){e.vars.elements.stateIcon&&(e.config[t]?(e.vars.elements.stateIcon.style.visibility="",e.vars.elements.stateIcon.style.backgroundImage=`url(${e.config[t]})`):(e.vars.elements.stateIcon.style.visibility="hidden",e.vars.elements.stateIcon.style.backgroundImage=""))}function setAlarmStyle(e,t){const s=t.vars.elements.wrapper;switch(e){case 0:setAlarmIcon(t,"icon-info");break;case 1:setAlarmIcon(t,"icon-warning");break;case 2:setAlarmIcon(t,"icon-alarm");break;default:setAlarmIcon(t,"icon-idle")}s&&(shmi.removeClass(s,n.join(" ")),n[e]&&shmi.addClass(s,n[e]))}function setTextContent(e,t,s){e.vars.elements[t]&&(e.vars.elements[t].textContent=s)}const a={className:"IQAlarmInfo",uiType:e,isContainer:!1,config:t,configSchema:null,vars:{elements:{stateIcon:null,alarmCount:null,alarmMessage:null,button:null,wrapper:null},alarmCount:0,listeners:[],tokens:[],activeAlarmList:[],currentAlarm:0,interval:0,alarmSubscriber:null,groupFilter:null},imports:{am:"visuals.session.AlarmManager"},prototypeExtensions:{onInit:function(){const t=this;if(t.vars.groupFilter=parseAlarmGroupFilter(t.config.groupFilter),t.vars.elements.alarmCount=shmi.getUiElement("alarm-count",t.element),t.vars.elements.alarmCount||s(e,"alarm-count not found in template"),t.vars.elements.wrapper=shmi.getUiElement("alarm-info-wrapper",t.element),t.vars.elements.wrapper||s(e,"alarm-info-wrapper not found in template"),t.vars.elements.stateIcon=shmi.getUiElement("state-icon",t.element),t.vars.elements.stateIcon||s(e,"state-icon not found in template"),t.vars.elements.alarmMessage=shmi.getUiElement("alarm-message",t.element),t.vars.elements.alarmMessage?setTextContent(t,"alarmMessage",shmi.localize(t.config.noAlarm)):s(e,"alarm-message not found in template"),t.vars.elements.alarmDetails=shmi.getUiElement("alarm-details",t.element),t.vars.elements.alarmDetails?setTextContent(t,"alarmDetails",""):s(e,"alarm-details not found in template"),t.vars.elements.button=shmi.getUiElement("alert-list-button",t.element),t.vars.elements.button&&Array.isArray(t.config.action)&&t.config.action.length){const e=shmi.requires("visuals.core"),s=shmi.requires("visuals.io"),n=new e.UiAction(t.config.action),a={onClick:()=>n.execute()},l=new s.MouseListener(t.vars.elements.button,a),o=new s.TouchListener(t.vars.elements.button,a);shmi.addClass(t.element,"has-action"),t.vars.listeners.push(l,o)}else t.vars.elements.button||s(e,"click element not found in template");setAlarmStyle(-1,t)},onEnable:function(){const e=this;e.vars.stateIcons=shmi.getUiElements("state",e.element)||[],e.vars.alarmSubscriber=e.imports.am.subscribeAlarms(e,((t,s)=>{s&&testAlarmState(e)})),e.vars.listeners.forEach((function(e){e.enable()}))},onDisable:function(){const e=this;e.vars.tokens.forEach((function(e){e.unlisten()})),e.vars.tokens=[],e.vars.listeners.forEach((function(e){e.disable()})),e.imports.am.unsubscribeAlarms(e.vars.alarmSubscriber),clearInt(e)},onLock:function(){this.vars.listeners.forEach((function(e){e.disable()})),shmi.addClass(this.element,"locked")},onUnlock:function(){this.vars.listeners.forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked")},onSetValue:function(e,t,s){},onSetProperties:function(e,t,s){}}};shmi.requires("visuals.tools.control-generator").generate(a)}(),function(){"use strict";const e="iq-alarm-list",t="iq-alarm-list",s=shmi.requires("visuals.tools.logging").createLogger(t,!0,!1);s.fLog,s.log;function parseAlarmGroupFilter(e){if("string"!=typeof e)return null;const t=e.split(",").map((e=>{if(e.includes("-"))return function parseAlarmGroupRange(e){const t=e.split("-");if(2===t.length){const e=parseInt(t[0]),s=parseInt(t[1]);if(!isNaN(e)&&!isNaN(s)&&e>=0&&s>=e)return[e,s]}return null}(e);const t=parseInt(e);return!isNaN(t)&&t>=0?t:null})),s=[];return t.forEach((e=>{if(Array.isArray(e)){let n=e[0];for(;n<=e[1];)s.includes(n)&&t.includes(n)||s.push(n),n+=1}else"number"==typeof e&&s.push(e)})),s.length?s:null}function controlStartUp(e){let t=!1,s=!1;const n=shmi.requires("visuals.io");if(e.vars.timeFilterLabel=shmi.getUiElement("filter-label",e.element),e.vars.activeFilterLabel=shmi.getUiElement("time-frame-label",e.element),e.vars.activeFilterFrom=shmi.getUiElement("start-date",e.element),e.vars.activeFilterTo=shmi.getUiElement("end-date",e.element),e.vars.resetButton=shmi.getUiElement("reset-button",e.element),e.vars.detailsRight=shmi.getUiElement("alarmListDetails",e.element),!(e.vars.timeFilterLabel&&e.vars.activeFilterLabel&&e.vars.activeFilterFrom&&e.vars.activeFilterTo&&e.vars.resetButton))return!1;e.vars.timeFilterLabel.textContent=shmi.localize("${alarmlist_set_timefilter}");const a={onClick:function(){!function clearFilter(e){e.vars.controls.alarmList.resetScroll(),e.vars.grid.clearFilter(4),shmi.removeClass(e.element,"filter-active")}(e)}};e.vars.listeners.push(new n.MouseListener(e.vars.resetButton,a),new n.TouchListener(e.vars.resetButton,a)),e.vars.configs.alarmTableConfig["default-field-control-map"].come.config["display-format"]=e.config.dateformat,function initAlarmTableGrid(e){do{e.vars.dataGridId="iqalarms-"+getRandomId()}while(null!==e.imports.dgm.getGrid(e.vars.dataGridId));e.imports.dgm.grids[e.vars.dataGridId]=new shmi.visuals.core.DataGridIQAlarms(e.config["display-mode"],e.vars.dataGridId),e.vars.grid=e.imports.dgm.getGrid(e.vars.dataGridId)}(e),t=function gatherAnchors(e){const t=e.vars.anchorEls,s=shmi.requires("visuals.io");if(t.iconError=shmi.getUiElement("iconError",e.element),t.filterCheckBoxError=shmi.getUiElement("filterCheckBoxError",e.element),t.iconWarn=shmi.getUiElement("iconWarn",e.element),t.filterCheckBoxWarn=shmi.getUiElement("filterCheckBoxWarn",e.element),t.iconAdvise=shmi.getUiElement("iconAdvise",e.element),t.filterCheckBoxAdvise=shmi.getUiElement("filterCheckBoxAdvise",e.element),t.filterGroupSelectBox=shmi.getUiElement("filterGroupSelectBox",e.element),t.modeSelectBox=shmi.getUiElement("mode-select-box",e.element),t.alarmList=shmi.getUiElement("alarmList",e.element),t.confirmButtons=shmi.getUiElement("confirmButtons",e.element),t.filterButton=shmi.getUiElement("filter-button",e.element),t.filterButton){const n={onClick:function(){!function handleDialog(e){const t=shmi.ctrl(".alarmTimeFilterDialogHolder"),s={name:"alarmTimeFilterDialogHolder","class-name":"container alarm-filter-dialog-holder"};t&&shmi.deleteControl(t);const n=shmi.createControl("container",e.element,s,"DIV");n.addControl([{ui:"dialog-box",controller:{name:"alarmTimeFilterController",slots:{dialog:{ui:"dialog-box",events:["close"]},selectDateStart:{ui:"iq-select-date",events:["change"]},selectTimeStart:{ui:"iq-select-time",events:["change"]},selectDateEnd:{ui:"iq-select-date",events:["change"]},selectTimeEnd:{ui:"iq-select-time",events:["change"]},cancelButton:{ui:"iq-button",events:["click"]},applyButton:{ui:"iq-button",events:["click"]}},onChange:function(e){},onDisable:function(e){},onEnable:function(e){const t=Math.floor(new Date(1e3*shmi.getServerTime()).getTime()/1e3),s=86400*Math.floor(t/86400);e.getInstance("selectDateStart").setValue(s-86400),e.getInstance("selectTimeStart").setValue(t),e.getInstance("selectDateEnd").setValue(s),e.getInstance("selectTimeEnd").setValue(t)},onEvent:function(t,s,n,a){switch(s){case"selectDateStart":t.getInstance("selectDateEnd").setValue(a.detail.value+86400),t.getInstance("selectTimeEnd").setValue(t.getInstance("selectTimeStart").getValue());break;case"applyButton":!function setFilter(e,t){const s=evaluateTimestampFromControls({time:t.getInstance("selectTimeStart"),date:t.getInstance("selectDateStart")}),n=evaluateTimestampFromControls({time:t.getInstance("selectTimeEnd"),date:t.getInstance("selectDateEnd")}),a=shmi.requires("visuals.tools.date");shmi.addClass(e.element,"filter-active"),e.vars.activeFilterLabel.textContent=shmi.localize("${alarmlist_timefilter}"),e.vars.activeFilterFrom.textContent=a.formatDateTime(s,{datestring:shmi.localize(e.config.dateformat)}),e.vars.activeFilterTo.textContent=a.formatDateTime(n,{datestring:shmi.localize(e.config.dateformat)}),e.vars.controls.alarmList.resetScroll(),e.vars.grid.setFilter(4,[s,n])}(e,t),t.getInstance("dialog").hide();break;case"cancelButton":t.getInstance("dialog").hide()}}},config:{title:"${alarmlist_select_time_range}","class-name":"dialog-box iq-alarm-list iq-alarm-list-filter-dialog",template:"default/dialog-box",name:"alarmTimeFilterDialog","top-level":!0,"content-template":null,_controllers_:[{name:"alarmTimeFilterController",slot:"dialog"}]},children:[{ui:"container",config:{"class-name":"container",name:"container",template:null},children:[{ui:"iq-label",config:{"class-name":"iq-label",template:"default/iq-label.iq-variant-01",text:"${alarmlist_from}"}},{ui:"iq-select-date",config:{label:"",template:"default/iq-select-date.iq-variant-01","class-name":"iq-select-date iq-variant-02",_controllers_:[{name:"alarmTimeFilterController",slot:"selectDateStart"}]}},{ui:"iq-select-time",config:{label:"","class-name":"iq-select-time iq-variant-01 iq-icon-variant-01",isUTC:!0,_controllers_:[{name:"alarmTimeFilterController",slot:"selectTimeStart"}]}},{ui:"iq-label",config:{"class-name":"iq-label",template:"default/iq-label.iq-variant-01",text:"${alarmlist_to}"}},{ui:"iq-select-date",config:{label:"",template:"default/iq-select-date.iq-variant-01","class-name":"iq-select-date iq-variant-02",_controllers_:[{name:"alarmTimeFilterController",slot:"selectDateEnd"}]}},{ui:"iq-select-time",config:{label:"","class-name":"iq-select-time iq-variant-01 iq-icon-variant-01",isUTC:!0,_controllers_:[{name:"alarmTimeFilterController",slot:"selectTimeEnd"}]}},{ui:"container",config:{"class-name":"container footer",type:"float","auto-width":!1,"auto-margin":!1,"h-alignment":"right","v-alignment":"top","flex-orientation":"row","flex-distribute":!1,"flex-all":!1,name:"container",template:null},children:[{ui:"iq-button",config:{"class-name":"iq-button cancel-button",label:"${cancel}",_controllers_:[{name:"alarmTimeFilterController",slot:"cancelButton"}]}},{ui:"iq-button",config:{"class-name":"iq-button apply-button",label:"${okay}",_controllers_:[{name:"alarmTimeFilterController",slot:"applyButton"}]}}]}]}]}],(function(e,t){e?console.error("Error creating controls"):t[0].show()}))}(e)}},a=new s.MouseListener(t.filterButton,n),l=new s.TouchListener(t.filterButton,n);e.vars.listeners.push(a,l)}return!0}(e),t&&(s=function createChildControls(e){const t=e.vars.anchorEls,s=e.vars.controls,n=e.vars.configs;(function configureAlarmList(e,t,s){s.alarmTableConfig.table=e.vars.dataGridId,shmi.hasClass(t.alarmList,"two-rows")&&(s.alarmTableConfig["default-layout"]["line-height"]="78px");e.config["notify-image"]&&(s.iconAdvise["image-src"]=e.config["notify-image"],s.alarmTableConfig["default-field-control-map"].level.config.options[0]["icon-src"]=e.config["notify-image"]);e.config["warn-image"]&&(s.iconWarn["image-src"]=e.config["warn-image"],s.alarmTableConfig["default-field-control-map"].level.config.options[1]["icon-src"]=e.config["warn-image"]);e.config["alarm-image"]&&(s.iconError["image-src"]=e.config["alarm-image"],s.alarmTableConfig["default-field-control-map"].level.config.options[2]["icon-src"]=e.config["alarm-image"]);e.config["detail-template"]&&(s.alarmTableConfig["default-field-control-map"].json.config["detail-template"]=e.config["detail-template"]);e.config["comment-template"]&&(s.alarmTableConfig["default-field-control-map"].json.config["comment-template"]=e.config["comment-template"]);e.config["comment-mode"]&&(s.alarmTableConfig["default-field-control-map"].json.config["comment-mode"]=e.config["comment-mode"]);e.config.dateformat&&(s.alarmTableConfig["default-field-control-map"].json.config.dateformat=e.config.dateformat);Object.assign(s.alarmTableConfig["default-field-control-map"].json.config,{iconAdvise:s.iconAdvise,iconWarn:s.iconWarn,iconError:s.iconError});for(let t=1;t<=e.config.numberOfColumns;t++)null!==e.config["col"+t+"-width"]&&e.config["col"+t+"-selectBox"]&&(s.alarmTableConfig["default-layout"]["column-org"]["col"+t]["column-width"]=e.config["col"+t+"-width"]+e.config["col"+t+"-selectBox"]);if(e.vars.detailsRight){delete s.alarmTableConfig["default-layout"]["column-org"].col7;shmi.requires("visuals.tools.alarms.ls.alarmDetailsIQ").showAlarmDetails(null,"inline",e.vars.detailsRight,e)}e.config["disable-commit"]&&(s.alarmTableConfig["default-layout"]["column-org"].col7?(s.alarmTableConfig["default-layout"]["column-org"].col6=s.alarmTableConfig["default-layout"]["column-org"].col7,delete s.alarmTableConfig["default-layout"]["column-org"].col7):delete s.alarmTableConfig["default-layout"]["column-org"].col6)})(e,t,n),s.iconError=shmi.createControl("iq-image",t.iconError,n.iconError,"DIV"),s.filterCheckBoxError=shmi.createControl("iq-checkbox",t.filterCheckBoxError,n.filterCheckBoxError,"DIV"),s.iconWarn=shmi.createControl("iq-image",t.iconWarn,n.iconWarn,"DIV"),s.filterCheckBoxWarn=shmi.createControl("iq-checkbox",t.filterCheckBoxWarn,n.filterCheckBoxWarn,"DIV"),s.iconAdvise=shmi.createControl("iq-image",t.iconAdvise,n.iconAdvise,"DIV"),s.filterCheckBoxAdvise=shmi.createControl("iq-checkbox",t.filterCheckBoxAdvise,n.filterCheckBoxAdvise,"DIV"),t.filterGroupSelectBox&&(s.filterGroupSelectBox=shmi.createControl("iq-select-box",t.filterGroupSelectBox,n.filterGroupSelectBox,"DIV"));return s.modeSelectBox=shmi.createControl("iq-select-box",t.modeSelectBox,n.modeSelectBox,"DIV"),s.confirmSelAlarmButton=shmi.createControl("iq-button",t.confirmButtons,n.confirmSelAlarmButton,"DIV"),s.confirmAllAlarmsButton=shmi.createControl("iq-button",t.confirmButtons,n.confirmAllAlarmsButton,"DIV"),s.createThreadButton=shmi.createControl("iq-button",t.confirmButtons,n.createThreadButton,"DIV"),s.alarmList=shmi.createControl("complex-table2",t.alarmList,n.alarmTableConfig,"DIV"),!0}(e)),e.config["allow-mode-change"]||(e.vars.anchorEls.modeSelectBox.style.display="none"),!e.config["allow-group-filter-change"]&&e.vars.anchorEls.filterGroupSelectBox&&(e.vars.anchorEls.filterGroupSelectBox.style.display="none"),e.config["disable-commit"]&&(shmi.addClass(e.vars.controls.confirmSelAlarmButton.element,"hidden locked"),shmi.addClass(e.vars.controls.confirmAllAlarmsButton.element,"hidden locked")),e.config["comment-mode"]&&"disabled"!==e.config["comment-mode"]||shmi.addClass(e.vars.controls.createThreadButton.element,"hidden locked");const l=parseAlarmGroupFilter(e.config["group-filter"]);return e.vars.groupFilter=l,l&&e.vars.grid.setFilter(7,l),!(!t||!s)}function getRandomId(){return Math.random().toString(36).substr(2,9)}function updateTableFilter(e){const t=e.vars.filterSet,s=[];t.error&&s.push(2),t.warn&&s.push(1),t.advise&&s.push(0),e.vars.controls.alarmList.resetScroll(),s.length>0?e.vars.grid.setFilter(3,s):e.vars.grid.clearFilter(3)}function toggleFilterSet(e,t){const s=e.vars.filterSet;s[t]=!s[t]}function evaluateTimestampFromControls(e){return function evaluateUnixTimestamp(e,t,s,n){const a=new Date(1e3*e);return a.setHours(t,s,n,0),a.getTime()/1e3}(e.date.getValue(),e.time.getHours(),e.time.getMinutes(),e.time.getSeconds())}function setLabelImpl(e,t){e.vars.labelEl&&(""!==t&&null!=t&&e.config["show-text"]?(e.vars.label=t,e.vars.labelEl.textContent=shmi.localize(t)):(e.vars.label="",e.vars.labelEl.textContent=""))}const n={className:e,uiType:t,isContainer:!0,config:{"class-name":"iq-alarm-list",name:null,template:"default/iq-alarm-list.variant-01",label:"[Label]","show-text":!1,"group-filter":null,"alarm-image":null,"warn-image":null,"notify-image":null,numberOfColumns:7,"col1-selectBox":null,"col1-width":null,"col2-selectBox":null,"col2-width":null,"col3-selectBox":null,"col3-width":null,"col4-selectBox":null,"col4-width":null,"col5-selectBox":null,"col5-width":null,"col6-selectBox":null,"col6-width":null,"col7-selectBox":null,"col7-width":null,dateformat:"${alarmlist_dateformat}","allow-mode-change":!1,"allow-group-filter-change":!1,"display-mode":"all","disable-commit":!1,"detail-template":null,"comment-mode":"disabled"},configSchema:null,vars:{tempAlarmGrid:{},alarmSubscription:null,alarmLevelTemplate:null,grid:null,dataGridId:"",groupFilter:null,cancelable:null,filterSet:{warn:!1,error:!1,advise:!1},anchorEls:{iconError:null,filterCheckBoxError:null,iconWarn:null,filterCheckBoxWarn:null,iconAdvise:null,filterCheckBoxAdvise:null,filterGroupSelectBox:null,modeSelectBox:null,alarmList:null,confirmButtons:null,filterButton:null,filterOverlay:null},controls:{iconError:null,filterCheckBoxError:null,iconWarn:null,filterCheckBoxWarn:null,iconAdvise:null,filterCheckBoxAdvise:null,filterGroupSelectBox:null,modeSelectBox:null,alarmList:null,confirmSelAlarmButton:null,confirmAllAlarmsButton:null,createThreadButton:null},configs:{alarmLevelConfig:{"alarm-icon":"pics/system/controls/iq-alarm-list/ico_alarm_outline.svg","warn-icon":"pics/system/controls/iq-alarm-list/ico_warning_outline.svg","notify-icon":"pics/system/controls/iq-alarm-list/ico_service_outline.svg"},alarmTableConfig:{label:"${alarmlist_history_title}",table:"iqalarms",name:"alarm-table","class-name":"complex-table2 alarms","field-datagrid-col-map":{level:3,id:1,description:9,come:4,group:10,isAck:8,json:8},"select-mode":"SINGLE","default-field-control-map":{level:{"ui-type":"iq-image-changer",config:{"class-name":"iq-image-changer iq-variant-01",template:"default/iq-image-changer.iq-variant-01",options:[{label:"label",value:0,"icon-src":"pics/system/controls/iq-alarm-list/ico_service_outline.svg","icon-title":null,"icon-class":null},{label:"label",value:1,"icon-src":"pics/system/controls/iq-alarm-list/ico_warning_outline.svg","icon-title":null,"icon-class":null},{label:"label",value:2,"icon-src":"pics/system/controls/iq-alarm-list/ico_alarm_outline.svg","icon-title":null,"icon-class":null}],"scaling-mode":"fit-height"}},id:{"ui-type":"iq-label",config:{"class-name":"iq-label",template:"default/iq-label.iq-variant-01",options:[],pattern:"<%= VALUE %>","value-as-tooltip":!0}},description:{"ui-type":"iq-label",config:{"class-name":"iq-label",template:"default/iq-label.iq-variant-01",options:[],pattern:null,"value-as-tooltip":!0}},come:{"ui-type":"iq-date-time",config:{"class-name":"iq-date-time multiline",template:"default/iq-date-time.iq-variant-01","display-format":"$DD.$MM.$YYYY, $HH:$mm:$ss","value-as-tooltip":!0}},group:{"ui-type":"iq-label",config:{"class-name":"iq-label",template:"default/iq-label.iq-variant-01",options:[],pattern:null,"value-as-tooltip":!0}},isAck:{"ui-type":"local-script",config:{module:"visuals.tools.alarms.ls.alarmCommitButton"}},json:{"ui-type":"local-script",config:{module:"visuals.tools.alarms.ls.alarmDetailsIQ","detail-template":null,"comment-template":null,dateformat:null}}},"default-field-headers":{level:"${alarmlist_header_level}",id:"${alarmlist_header_id}",description:"${alarmlist_header_description}",come:"${alarmlist_header_come}",group:"${alarmlist_header_group}",isAck:"${alarmlist_header_isack}",json:"${alarmlist_header_json}"},_comment:"expr is passed to expr parameter array of shmi.visuals.core.DataGridManager.setFilter",filters:[],"default-layout":{"class-name":"layout-std",_comment:"default == no additional css layout class","column-org":{col1:{fields:["level"],"column-width":"10%"},col2:{fields:["id"],"column-width":"10%"},col3:{fields:["description"]},col4:{fields:["come"],"column-width":"15%"},col5:{fields:["group"]},col6:{fields:["isAck"],"column-width":"90px"},col7:{fields:["json"],"column-width":"90px"}},"line-height":"39px"},"sortable-fields":["come","id","group"],"delete-selected-rows":!1,"show-nof-rows":!0,"show-buttons-table-min-width-px":400,"text-mode":"MULTILINE","default-nof-buffered-rows":60,"buffer-size":500},iconError:{"class-name":"iq-image iq-variant-01",template:"default/iq-image.iq-variant-01","image-src":"pics/system/controls/iq-alarm-list/ico_alarm_outline.svg"},filterCheckBoxError:{"class-name":"iq-checkbox iq-variant-01",template:"default/iq-checkbox.iq-variant-01",label:"${alarmlist_level_errors}"},iconWarn:{"class-name":"iq-image iq-variant-01",template:"default/iq-image.iq-variant-01","image-src":"pics/system/controls/iq-alarm-list/ico_warning_outline.svg"},filterCheckBoxWarn:{"class-name":"iq-checkbox iq-variant-01",template:"default/iq-checkbox.iq-variant-01",label:"${alarmlist_level_warnings}"},iconAdvise:{"class-name":"iq-image iq-variant-01",template:"default/iq-image.iq-variant-01","image-src":"pics/system/controls/iq-alarm-list/ico_service_outline.svg"},filterCheckBoxAdvise:{"class-name":"iq-checkbox iq-variant-01",template:"default/iq-checkbox.iq-variant-01",label:"${alarmlist_level_notifications}"},filterGroupSelectBox:{name:"filter-group-select-box","class-name":"iq-select-box","show-text":!1,options:[{label:"${alarmlist_filter_group_all}",value:null}]},modeSelectBox:{name:"mode-select-box","class-name":"iq-select-box","show-text":!1,options:[{label:"${alarmlist_mode_all}",value:"all"},{label:"${alarmlist_mode_live}",value:"live"},{label:"${alarmlist_mode_historic}",value:"historic"}]},alarmList:{},confirmSelAlarmButton:{label:"${alarmlist_commit}",name:"confirm-sel-al-btn","class-name":"iq-button icon-and-text","icon-src":"pics/system/controls/iq-alarm-list/ButtonIcon_AcknSingle_default.svg"},confirmAllAlarmsButton:{label:"${alarmlist_commit_all}",name:"confirm-all-al-btn","class-name":"iq-button icon-and-text","icon-src":"pics/system/controls/iq-alarm-list/ButtonIcon_AcknAll_default.svg"},createThreadButton:{label:"${alarmlist_create_thread}",name:"create-thread-btn","class-name":"iq-button icon-and-text","icon-src":"pics/system/controls/iq-alarm-list/ButtonIcon_CreateThread_default.svg"}},listeners:[],tokens:[],editListeners:[]},imports:{im:"visuals.session.ItemManager",dgm:"visuals.session.DataGridManager",am:"visuals.session.AlarmManager"},events:[],prototypeExtensions:{onInit:function(){const e=this;controlStartUp(e)?shmi.log("Init Succeeded!"):shmi.log("Init Failed!"),e.vars.labelEl=shmi.getUiElement("label",e.element),setLabelImpl(e,e.config.label)},onEnable:function(){const t=this;t.vars.listeners.forEach((e=>e.enable())),function setListener(e){const{controls:t,tokens:s}=e.vars,{showAlarmDetails:n,openCreateThreadDialogForAlarmInfo:a}=shmi.requires("visuals.tools.alarms.ls.alarmDetailsIQ");return!!(t.confirmSelAlarmButton&&t.confirmAllAlarmsButton&&t.createThreadButton&&t.modeSelectBox&&t.filterCheckBoxError&&t.filterCheckBoxWarn&&t.filterCheckBoxAdvise)&&(s.push(t.confirmSelAlarmButton.listen("click",(function(s){const n=e.vars.grid.getRowData(t.alarmList.selection.selRows[0]);if(n){const t=JSON.parse(n[8].value);t.acknowledgeable&&!t.acknowledged&&e.imports.am.ackAlarm(t.real_id)}}))),s.push(t.confirmAllAlarmsButton.listen("click",(function(t){const s=e.vars.grid.getFilters();s&&Array.isArray(s[7])?e.imports.am.ackAlarmGroups(s[7]):e.imports.am.ackAlarm(-1)}))),s.push(t.createThreadButton.listen("click",(async function(s){const l=e.vars.grid.getRowData(t.alarmList.selection.selRows[0]);if(l){const t=JSON.parse(l[8].value);await a(e,t),e.vars.detailsRight&&n(t,"inline",e.vars.detailsRight,e)}}))),t.filterGroupSelectBox&&s.push(t.filterGroupSelectBox.listen("change",(function(t){const{groupFilter:s}=e.vars;t.detail&&null!==t.detail.value?e.vars.grid.setFilter(7,[t.detail.value]):s?e.vars.grid.setFilter(7,s):e.vars.grid.clearFilter(7)}))),s.push(t.modeSelectBox.listen("change",(function(t){e.vars.grid.setDisplayMode(t.detail.value)}))),s.push(t.filterCheckBoxError.listen("change",(function(t){toggleFilterSet(e,"error"),updateTableFilter(e)}))),s.push(t.filterCheckBoxWarn.listen("change",(function(t){toggleFilterSet(e,"warn"),updateTableFilter(e)}))),s.push(t.filterCheckBoxAdvise.listen("change",(function(t){toggleFilterSet(e,"advise"),updateTableFilter(e)}))),!0)}(t),function attachSelectListener(e,t){const s=[];e.vars.controls.confirmSelAlarmButton&&s.push(e.vars.controls.confirmSelAlarmButton),e.vars.controls.createThreadButton&&s.push(e.vars.controls.createThreadButton),e.vars.tokens.push(t.listen("select",(function(n){if(1===n.detail.selRows.length){if(e.vars.detailsRight){const s=8,a=JSON.parse(t.getSelectionRowData(n.detail)[0][s].value);shmi.requires("visuals.tools.alarms.ls.alarmDetailsIQ").showAlarmDetails(a,"inline",e.vars.detailsRight,e)}s.forEach((e=>e.unlock()))}else s.forEach((e=>e.lock()))})))}(t,t.vars.controls.alarmList);for(const e in t.vars.controls)t.vars.controls[e]&&t.vars.controls[e].enable&&t.vars.controls[e].enable();t.vars.controls.confirmSelAlarmButton&&t.vars.controls.confirmSelAlarmButton.lock(),t.vars.controls.createThreadButton&&t.vars.controls.createThreadButton.lock(),t.vars.cancelable=shmi.onReady({controls:{modeSelectBox:t.getName()+".mode-select-box",filterGroupSelectBox:t.getName()+".filter-group-select-box"}},(function(s){s.controls.modeSelectBox.setValue(t.config["display-mode"]),s.controls.filterGroupSelectBox.setValue(null),function updateGroupFilterSelectbox(t){const{controls:{filterGroupSelectBox:s},groupFilter:n}=t.vars;s&&shmi.visuals.session.ConnectSession.requestPromise("alarm.get_groups",{}).then((e=>{const a=s.getValue();s.setOptions([...t.vars.configs.filterGroupSelectBox.options,...e.filter((e=>!n||n.includes(e))).map((e=>({label:`\${alarm_group_${e}}`,value:e})))]),s.setValue(a)})).catch((n=>{console.error(`[${e}] Unable to get list of alarm groups`,n),s.setOptions(t.vars.configs.filterGroupSelectBox.options),s.setValue(null)}))}(t)})),shmi.log("[IQ:iq-alarm-list] Enabled",1)},onDisable:function(){const e=this;e.vars.listeners.forEach((e=>e.disable()));for(const t in e.vars.controls)e.vars.controls[t]&&e.vars.controls[t].disable&&e.vars.controls[t].disable();e.vars.tokens.forEach((e=>e.unlisten())),e.vars.tokens=[],e.vars.editListeners.forEach((e=>e.disable())),e.vars.editListeners=[],e.vars.cancelable&&(e.vars.cancelable.cancel(),e.vars.cancelable=null),shmi.log("[IQ:iq-alarm-list] disabled",1)},onLock:function(){const e=this;e.vars.listeners.forEach((e=>e.disable()));for(const t in e.vars.controls)e.vars.controls[t]&&e.vars.controls[t].lock&&e.vars.controls[t].lock();shmi.addClass(e.element,"locked"),shmi.log("[IQ:iq-alarm-list] Locked",1)},onUnlock:function(){const e=this;e.vars.listeners.forEach((e=>e.enable()));for(const t in e.vars.controls)e.vars.controls[t]&&e.vars.controls[t].unlock&&e.vars.controls[t].unlock();shmi.removeClass(e.element,"locked"),shmi.log("[IQ:iq-alarm-list] unlocked",1)},setLabel:function(e){setLabelImpl(this,e)}}};shmi.requires("visuals.tools.control-generator").generate(n)}(),function(){const e="visuals.tools.alarms.ls.alarmCommitButton",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),s=t.fLog;t.log;shmi.pkg(e).run=function(e){const t=shmi.requires("visuals.session.ItemManager"),s=shmi.requires("visuals.session.AlarmManager"),n=t.getItemHandler();let a=null,l=null,o=[];e.vars=e.vars||{},n.setValue=function(t){a=JSON.parse(t),l&&shmi.deleteControl(l,!0),a.active?e.element.parentElement.parentElement.parentElement.style["font-weight"]="bold":e.element.parentElement.parentElement.parentElement.style["font-weight"]="",a.acknowledgeable?(a.acknowledged?(l=shmi.createControl("iq-button",e.element.parentNode,{"icon-src":"pics/system/controls/iq-alarm-list/ButtonIcon_AcknSingle_default.svg",label:"","show-icon":!0,"show-text":!1},"DIV"),shmi.addClass(l.element,"alarm-ack")):(l=shmi.createControl("iq-button",e.element.parentNode,{label:"${alarmlist_single_commit}"},"DIV"),shmi.addClass(l.element,"alarm-ack"),o.push(l.listen("click",(function(){a.real_id&&s.ackAlarm(a.real_id)})))),a.active||shmi.addClass(l.element,"locked")):(l=shmi.createControl("iq-label",e.element.parentNode,{text:"---",template:"default/iq-label.iq-variant-01"},"DIV"),shmi.addClass(l.element,"alarm-no-ack"))},e.config.item&&o.push(t.subscribeItem(e.config.item,n)),e.onDisable=function(){e.run=!1,o.forEach((function(e){e.unlisten()})),o=[],l&&shmi.deleteControl(l,!0)}},s("module loaded")}(),function(){const e="visuals.tools.alarms.ls.alarmDetailsIQ",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),s=t.fLog,n=(t.log,shmi.pkg(e));function formatTime(e){const t=new Date(1e3*e);return null===e?"---":t.toLocaleString()}function openCreateThreadDialogForAlarm(e,t){const{create:s}=shmi.requires("visuals.tools.threads");return s(t,e,null,{dialogTitle:"${alarmlist_create_thread}",titleLabel:"${alarmlist_threads_title}",messageLabel:"${alarmlist_threads_message}",applyLabel:"${alarmlist_threads_create_btn}"})}function openCreateThreadDialogForAlarmInfo(e,t){switch(e.config["comment-mode"]){case"alarm":return openCreateThreadDialogForAlarm(t.id,"alarm");case"alarm_type":return openCreateThreadDialogForAlarm(t.index,"alarm_type");default:return Promise.resolve(null)}}async function loadHTMLTemplate(e,t=null,s={}){const n=await shmi.loadResourcePromise(e,s),a=document.createElement("template");return a.innerHTML=t?shmi.localize(shmi.evalString(n,t)):shmi.localize(n),a}async function loadCommentsForAlarm(t,s){const{list:n}=shmi.requires("visuals.tools.threads");if(!s)return Promise.resolve([]);try{switch(t.config["comment-mode"]){case"alarm":return(await n("alarm",s.id,{loadReplies:!0,loadUserDisplayName:!0})).threads;case"alarm_type":return(await n("alarm_type",s.index,{loadReplies:!0,loadUserDisplayName:!0})).threads}}catch(t){console.error(`[${e}]`,"Failed to load comments:",t)}return[]}async function initCommentEditing(e,t,s=null,n=null){const a=shmi.requires("visuals.session"),l=a.ConnectSession.requestPromise.bind(a.ConnectSession);let o=[],r=!1;try{await l("thread.modify",{thread_id:-1,title:null,message:""})}catch(e){"shmi:connect:api:generic"===e.category&&4===e.errc||(r=!0)}e.vars.editListeners.forEach((e=>{e.disable()})),e.vars.editListeners=[],r&&(o=[...t.querySelectorAll("[data-ui=thread-edit]")],o.forEach((t=>{!function initEditElement(e,t,s=null,n=null){const a=t.getAttribute("data-user-id"),l=parseInt(t.getAttribute("data-thread-id")),o=shmi.requires("visuals.session.UserManager"),{MouseListener:r,TouchListener:c}=shmi.requires("visuals.io"),{currentUser:u}=o;if(!isNaN(l)&&u&&a===u.id){const{edit:a}=shmi.requires("visuals.tools.threads"),o={onClick:async()=>{null!==await a(l,{dialogTitle:"${alarmlist_edit_thread}",titleLabel:"${alarmlist_threads_title}",messageLabel:"${alarmlist_threads_message}",applyLabel:"${alarmlist_threads_edit_btn}",deleteLabel:"${alarmlist_threads_delete_btn}"})&&(s?(s.hide(),showAlarmDetails(n,"popup",null,e)):e.vars.detailsRight&&showAlarmDetails(n,"inline",e.vars.detailsRight,e))}},u=new r(t,o),m=new c(t,o);u.enable(),m.enable(),e.vars.editListeners.push(u,m),shmi.addClass(t,"editable")}}(e,t,s,n)})))}async function showAlarmDetails(e,t,s,n){const{renderThreadList:a}=shmi.requires("visuals.tools.threads.render");let l="templates/default/iq-alarm-list/detail-win.html";const o={renderReplies:!0};n.config["detail-template"]&&(l=`templates/${n.config["detail-template"]}.html`),n.config["comment-template"]&&(o.templateUrl=n.config["comment-template"]);let r={ALARM_SEVERITY:-1,ALARM_SEVERITY_ICON_SRC:"",ALARM_COME:"",ALARM_GONE:"",ALARM_ACK:"",ALARM_ACKBY:"",ALARM_INDEX:"",ALARM_TITLE:"",ALARM_URLS:"",ALARM_URLS_MATCHED:!1,ALARM_TEXT:""};if(e){const t=Object.entries(e.attributes).filter((([e,t])=>"string"==typeof t&&t.startsWith("[URL]"))),s=t.map((([e,t])=>`${e}: <a href='${t.substr(5)}' target='_blank'>${t.substr(5)}</a><br />`)).join("");r={ALARM_SEVERITY:e.severity,ALARM_SEVERITY_ICON_SRC:function getSeverityAlarmIconSrc(e){const t=n.vars&&n.vars.configs?n.vars.configs:n.config;switch(e){case 0:return t.iconAdvise["image-src"];case 1:return t.iconWarn["image-src"];case 2:return t.iconError["image-src"];default:return""}}(e.severity),ALARM_COME:formatTime(e.timestamp_in),ALARM_GONE:formatTime(e.timestamp_out),ALARM_ACK:formatTime(e.timestamp_acknowledged),ALARM_ACKBY:(c=e.acknowledged_by,null===c?"---":c),ALARM_INDEX:e.index,ALARM_TITLE:shmi.evalString(shmi.localize("${alarm_title_"+e.index+"}"),e),ALARM_URLS:s,ALARM_URLS_MATCHED:t.length>0,ALARM_TEXT:shmi.evalString(shmi.localize("${alarm_msg_"+e.index+"}"),e)}}var c;const[u,m]=await Promise.all([loadHTMLTemplate(l,r),loadCommentsForAlarm(n,e)]),h=shmi.getUiElement("comments",u.content);if(h&&(h.append(await a(m,o)),m.length&&shmi.addClass(h,"has-comments")),!r.ALARM_URLS_MATCHED){const e=shmi.getElementsByAttribute("class","link-container",u.content);e[0]&&(e[0].style.display="none")}if("popup"===t)!function openAlarmDetailsPopup(e,t,s){const n=shmi.createControl("dialog-box",e.element.parentNode,{name:"alarmDetailsPopup","class-name":"dialog-box iq-alarm-list","top-level":!0,title:"Alarm Details"},"DIV");let a=[];const onDialogBoxActive=()=>{const l=shmi.createControl("container",n.contentElement,{},"DIV"),o=shmi.createControl("container",n.contentElement,{"class-name":"iq-container",type:"iqflex"},"DIV"),r=function isCommentModeEnabled(e){return"alarm"===e.config["comment-mode"]||"alarm_type"===e.config["comment-mode"]}(e)?shmi.createControl("iq-button",o.marginCompensator,{label:"${alarmlist_create_thread}"},"DIV"):null,c=shmi.createControl("iq-button",o.marginCompensator,{label:"${close}"},"DIV"),u=l.marginCompensator||l.element;a.push(c.listen("click",(()=>n.hide())),n.listen("close",(()=>{a.forEach((e=>e.unlisten())),a=[],shmi.deleteControl(n)}))),r&&a.push(r.listen("click",(async()=>{null!==await openCreateThreadDialogForAlarmInfo(e,s)&&(n.hide(),showAlarmDetails(s,"popup",null,e))})));const m=t.content.cloneNode(!0);u.appendChild(m),initCommentEditing(e,u,n,s),n.show()};n.active?onDialogBoxActive():a.push(n.listen("enable",onDialogBoxActive))}(n,u,e);else{for(;s.lastChild;)s.removeChild(s.lastChild);const t=u.content.cloneNode(!0);s.appendChild(t),initCommentEditing(n,s,null,e)}}n.run=function(e){const t=shmi.requires("visuals.session.ItemManager"),s=t.getItemHandler();let n=null,a=[];e.vars=e.vars||{},e.vars.editListeners=[];const l=shmi.createControl("iq-button",e.element.parentNode,{label:"${alarmlist_show_detail}"},"DIV");s.setValue=function(e){try{n=JSON.parse(e)}catch(e){console.error("Error parsing alarmInfo data")}},a.push(l.listen("click",(function(){showAlarmDetails(n,"popup",null,e)}))),e.config.item&&a.push(t.subscribeItem(e.config.item,s)),e.onDisable=function(){e.run=!1,a.forEach((function(e){e.unlisten()})),a=[],e.vars.editListeners.forEach((e=>{e.disable()})),e.vars.editListeners=[],shmi.deleteControl(l,!0)}},n.showAlarmDetails=showAlarmDetails,n.openCreateThreadDialogForAlarmInfo=openCreateThreadDialogForAlarmInfo,s("module loaded")}(),function(){"use strict";var e="iq-button-rocker",t={"class-name":"iq-button-rocker",name:null,template:"default/iq-button-rocker.iq-variant-01",label:"[Label]",item:null,min:Number.NEGATIVE_INFINITY,max:Number.POSITIVE_INFINITY,step:1,precision:-1,"decimal-delimiter":".",type:shmi.c("TYPE_INT"),"unit-text":"[Unit]","auto-label":!0,"auto-unit-text":!0,"auto-min":!0,"auto-max":!0,"auto-step":!0,"auto-precision":!0,"auto-type":!0,"numpad-enabled":!1,"show-icon":!1,"icon-src":null,"icon-class":null,tooltip:null,"auto-repeat":!1,"auto-repeat-interval":250},s=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1);s.fLog,s.log;function setUnitTextImpl(e,t){e.vars.unitEl&&(""===t||null==t?(e.vars.unit="",e.vars.unitEl.textContent="",shmi.addClass(e.element,"no-unit")):(e.vars.unit=t,e.vars.unitEl.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-unit")))}function setLabelImpl(e,t){e.vars.labelEl&&(""===t||null==t?(e.vars.label="",e.vars.labelEl.textContent="",shmi.addClass(e.element,"no-label")):(e.vars.label=t,e.vars.labelEl.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-label")))}function getButtonStepping(e){return e.vars.valueSettings&&"number"==typeof e.vars.valueSettings.step&&e.vars.valueSettings.step>0?e.vars.valueSettings.step:1}function getValueSettings(e){const t=e.getConfig(),s={vars:{valueSettings:e.vars.valueSettings?shmi.cloneObject(e.vars.valueSettings):t},config:t};return s.vars.valueSettings.step=0,s}function incValue(e,t){e.vars.valueSettings||e.imports.nv.initValueSettings(e),e.vars.currentValueEl.blur(),e.vars.value=e.imports.nv.applyInputSettings(Number(e.vars.value)+t,getValueSettings(e)),e.updateValue(),void 0!==e.vars.value&&e.setCurrentElementValue()}var n={className:"iq-button-rocker",uiType:e,isContainer:!1,config:t,configSchema:null,vars:{listeners:[],value:0,active:!1,prevEl:null,nextEl:null,currentValueEl:null,labelEl:null,unitEl:null,iconEl:null,label:null,isInputTag:null,valueSettings:null,buttonInterval:0},imports:{im:"visuals.session.ItemManager",nv:"visuals.tools.numericValues"},events:["change"],prototypeExtensions:{onInit:function(){var e=this;if(e.vars.prevEl=shmi.getUiElement("previous",e.element),e.vars.nextEl=shmi.getUiElement("next",e.element),e.vars.currentValueEl=shmi.getUiElement("current",e.element),e.vars.labelEl=shmi.getUiElement("label",e.element),e.vars.unitEl=shmi.getUiElement("unit",e.element),e.vars.iconEl=shmi.getUiElement("icon",e.element),e.vars.currentValueEl&&(e.vars.isInputTag="INPUT"===e.vars.currentValueEl.tagName),e.vars.iconEl)if(e.config["icon-src"]&&e.config["show-icon"])e.vars.iconEl.style.backgroundImage=`url(${e.config["icon-src"]})`;else if(e.config["icon-class"]&&e.config["show-icon"]){e.config["icon-class"].trim().split(" ").forEach((function(t){shmi.addClass(e.vars.iconEl,t)}))}else shmi.addClass(e.element,"no-icon");else shmi.log("[IQ:iq-button-rocker] no button-icon element provided",1);if(null===e.vars.prevEl||null===e.vars.nextEl||null===e.vars.currentValueEl)return shmi.log("[IQ:iq-button-rocker] One of the elements is missing (previous, next, current)",3),e.vars.prevEl=null,e.vars.nextEl=null,e.vars.currentValueEl=null,e.vars.labelEl=null,e.vars.unitEl=null,void(e.vars.iconEl=null);setUnitTextImpl(e,e.config["unit-text"]),setLabelImpl(e,e.config.label),void 0!==e.vars.value&&e.setCurrentElementValue(),e.createInputField(e.vars.currentValueEl,e.validate.bind(e));let t=!1;var s={onPress:function(s,n,a){shmi.addClass(e.vars.prevEl,"pressed"),!0===e.config["auto-repeat"]&&(clearInterval(e.vars.buttonInterval),t=!1,e.vars.buttonInterval=setInterval((()=>{t=!0,incValue(e,-getButtonStepping(e))}),e.config["auto-repeat-interval"]))},onRelease:function(){shmi.removeClass(e.vars.prevEl,"pressed"),!0===e.config["auto-repeat"]&&clearInterval(e.vars.buttonInterval)},onClick:function(){t||incValue(e,-getButtonStepping(e))}};e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.vars.prevEl,s)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.vars.prevEl,s));var n={onPress:function(s,n,a){shmi.addClass(e.vars.nextEl,"pressed"),!0===e.config["auto-repeat"]&&(clearInterval(e.vars.buttonInterval),t=!1,e.vars.buttonInterval=setInterval((()=>{t=!0,incValue(e,getButtonStepping(e))}),e.config["auto-repeat-interval"]))},onRelease:function(){shmi.removeClass(e.vars.nextEl,"pressed"),!0===e.config["auto-repeat"]&&clearInterval(e.vars.buttonInterval)},onClick:function(){t||incValue(e,getButtonStepping(e))}};e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.vars.nextEl,n)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.vars.nextEl,n)),e.vars.currentValueEl.addEventListener("keydown",(function(t){if(e.config.type===shmi.c("TYPE_FLOAT")){var s="."===e.config["decimal-delimiter"]?",":".";t.key===s&&t.preventDefault()}}))},onEnable:function(){var e=this;e.vars.listeners.forEach((function(e){e.enable()})),e.config.item&&(e.vars.subscriptionTargetId=e.imports.im.subscribeItem(e.config.item,e)),shmi.log("[IQ:iq-button-rocker] Enabled",1)},onDisable:function(){var e=this;e.vars.listeners.forEach((function(e){e.disable()})),e.config.item&&e.imports.im.unsubscribeItem(e.config.item,e.vars.subscriptionTargetId),shmi.log("[IQ:iq-button-rocker] disabled",1)},onLock:function(){var e=this;e.vars.currentValueEl.blur(),e.vars.listeners.forEach((function(e){e.disable()})),shmi.addClass(this.element,"locked"),e.vars.isInputTag&&(e.vars.currentValueEl.disabled=!0),shmi.log("[IQ:iq-button-rocker] Locked",1)},onUnlock:function(){var e=this;e.vars.listeners.forEach((function(e){e.enable()})),shmi.removeClass(e.element,"locked"),e.vars.isInputTag&&(e.vars.currentValueEl.disabled=!1),shmi.log("[IQ:iq-button-rocker] unlocked",1)},onSetValue:function(e,t,s){this.vars.value=e,this.setCurrentElementValue()},getValue:function(){return this.vars.value},onSetProperties:function(e,t,s){this.imports.nv.setProperties(this,arguments)},setUnitText:function(e){var t=this;t.vars.unitEl&&t.config["auto-unit-text"]&&setUnitTextImpl(t,e)},setLabel:function(e){var t=this;t.vars.labelEl&&t.config["auto-label"]&&setLabelImpl(t,e)},createInputField:function(e,t){var s=this;if(e){var n={onClick:function(){var t=shmi.requires("visuals.session.config"),n=t.keyboard&&t.keyboard.enabled;if(s.config["numpad-enabled"]||n){var a,l=shmi.visuals.session.ItemManager,o=shmi.requires("visuals.tools.numericValues"),r={"decimal-delimiter":s.config["decimal-delimiter"],unit:void 0!==s.vars.unit?s.vars.unit:s.config["unit-text"],label:void 0!==s.vars.label?s.vars.label:s.config.label,value:s.vars.value,callback:function(e){s.vars.value=e,s.updateValue(),s.setCurrentElementValue()}};return s.vars&&s.vars.valueSettings||o.initValueSettings(s),a=s.vars.valueSettings,r.min=a.min,r.max=a.max,r.type=a.type,r.precision=a.precision,r.item="string"==typeof s.config.item&&s.config.item.length>0?s.config.item:null,s.config.item&&l.getItem(s.config.item)&&s.config["auto-type"]&&(s.type=l.items[s.config.item].type),void shmi.numpad(r)}if(shmi.addClass(e,"selectableText"),s.vars.isInputTag)s.vars.currentValueEl.setSelectionRange(0,s.vars.currentValueEl.value.length);else{e.setAttribute("contenteditable",!0);var c=document.createRange();e.focus(),e.firstChild&&e.firstChild instanceof Text?(c.setStart(e.firstChild,0),c.setEnd(e.firstChild,e.firstChild.length),window.getSelection().removeAllRanges(),window.getSelection().addRange(c)):shmi.log("[IQ:iq-button-rocker] Element not found",0)}}};s.vars.listeners.push(new shmi.visuals.io.MouseListener(e,n)),s.vars.listeners.push(new shmi.visuals.io.TouchListener(e,n)),e.addEventListener("keypress",(function(t){13===t.keyCode&&(t.preventDefault(),window.getSelection().removeAllRanges(),e.blur())})),e.addEventListener("blur",(function(){s.vars.isInputTag||e.setAttribute("contenteditable",!1),window.getSelection().removeAllRanges(),shmi.removeClass(e,"selectableText"),shmi.log("[IQ:iq-button-rocker] Blur event",0),t(e)}))}else shmi.log("[IQ:iq-button-rocker] No base element provided",3)},validate:function(e){var t=this,s=null,n=t.config.item&&t.config["auto-type"]?t.vars.valueSettings.type:t.config.type;s=t.vars.isInputTag?t.vars.currentValueEl.value:t.vars.currentValueEl.textContent;var a=String(s).replace(t.config["decimal-delimiter"],".");if(-1===[shmi.c("TYPE_INT"),shmi.c("TYPE_FLOAT")].indexOf(n))return shmi.log("[IQ:iq-button-rocker] Invalid value type '"+t.config.type+"' configured",3),void t.setCurrentElementValue();new RegExp(t.floatRegexp).test(a)?(shmi.log("[IQ:iq-button-rocker] Valid value",1),t.vars.value=t.imports.nv.applyInputSettings(a,getValueSettings(t)),t.updateValue()):shmi.log("[IQ:iq-button-rocker] Invalid value",1),t.setCurrentElementValue()},updateValue:function(){var e=this;e.fire("change",{value:e.vars.value}),e.config.item&&shmi.visuals.session.ItemManager.writeValue(e.config.item,e.vars.value)},setCurrentElementValue:function(){var e=this;e.vars.isInputTag?e.vars.currentValueEl.value=e.imports.nv.formatOutput(e.vars.value,e):e.vars.currentValueEl.textContent=e.imports.nv.formatOutput(e.vars.value,e)},floatRegexp:"(^[+-]?[0-9]([.][0-9]*)?$|^[+-]?[1-9]+[0-9]*([.][0-9]*)?$)"}};shmi.requires("visuals.tools.control-generator").generate(n)}(),function(){"use strict";var e="iq-button-toggle",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1);t.fLog,t.log;function setLabelImpl(e,t){e.vars.labelEl&&(""!==t&&null!=t&&e.config["show-text"]?(e.vars.label=t,e.vars.labelEl.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-label")):(e.vars.label="",e.vars.labelEl.textContent="",shmi.addClass(e.element,"no-label")))}var s={className:"iq-button-toggle",uiType:e,isContainer:!1,config:{"class-name":"iq-button-toggle",name:null,template:"default/iq-button-toggle.variant-01",label:"[Label]",item:null,"auto-label":!0,tooltip:null,"on-value":1,"off-value":0,"confirm-on":!1,"confirm-off":!1,"on-label":"ON","off-label":"OFF","on-show-text":!0,"on-show-icon":!1,"on-icon-src":null,"on-icon-class":null,"on-tooltip":null,"off-show-text":!0,"off-show-icon":!1,"off-icon-src":null,"off-icon-class":null,"off-tooltip":null,"confirm-on-text":"${V_CONFIRM_ON}","confirm-off-text":"${V_CONFIRM_OFF}","show-icon":!1,"show-text":!0,"on-action":[],"off-action":[],"icon-src":null,"icon-class":null},configSchema:null,vars:{listeners:[],value:0,active:!1,labelEl:null,buttonEl:null,offStateEl:null,onStateEl:null,onLabelEl:null,offLabelEl:null,iconEl:null,onIconEl:null,offIconEl:null,initialized:!1,subscriptionTargetId:null,onAction:null,offAction:null},imports:{im:"visuals.session.ItemManager"},events:["change"],prototypeExtensions:{onInit:function(){var e=this,t=shmi.requires("visuals.core");if(e.vars.labelEl=shmi.getUiElement("label",e.element),e.vars.buttonEl=shmi.getUiElement("button",e.element),e.vars.iconEl=shmi.getUiElement("icon",e.element),e.vars.offStateEl=shmi.getUiElement("off-state",e.element),e.vars.offStateEl&&(e.vars.offLabelEl=shmi.getUiElement("label",e.vars.offStateEl),e.vars.offIconEl=shmi.getUiElement("toggle-icon",e.vars.offStateEl),e.vars.offLabelEl&&e.config["off-label"]&&e.config["off-show-text"]?e.vars.offLabelEl.textContent=shmi.localize(e.config["off-label"]):shmi.addClass(e.vars.offStateEl,"no-label"),e.vars.offIconEl&&e.config["off-show-icon"]&&(e.config["off-icon-class"]||e.config["off-icon-src"])?e.setupIconElement(e.vars.offIconEl,e.config["off-icon-class"],e.config["off-icon-src"],e.config["off-show-icon"],e.config["off-show-text"]):shmi.addClass(e.vars.offStateEl,"no-icon")),e.vars.onStateEl=shmi.getUiElement("on-state",e.element),e.vars.onStateEl&&(e.vars.onLabelEl=shmi.getUiElement("label",e.vars.onStateEl),e.vars.onIconEl=shmi.getUiElement("toggle-icon",e.vars.onStateEl),e.vars.onLabelEl&&e.config["on-label"]&&e.config["on-show-text"]?e.vars.onLabelEl.textContent=shmi.localize(e.config["on-label"]):shmi.addClass(e.vars.onStateEl,"no-label"),e.vars.onIconEl&&e.config["on-show-icon"]&&(e.config["on-icon-class"]||e.config["on-icon-src"])?e.setupIconElement(e.vars.onIconEl,e.config["on-icon-class"],e.config["on-icon-src"],e.config["on-show-icon"],e.config["on-show-text"]):shmi.addClass(e.vars.onStateEl,"no-icon")),e.vars.offStateEl&&e.vars.onStateEl){if(setLabelImpl(e,e.config.label),e.vars.iconEl)if(e.config["icon-src"]&&e.config["show-icon"])e.vars.iconEl.style.backgroundImage=`url(${e.config["icon-src"]})`;else if(e.config["icon-class"]&&e.config["show-icon"]){e.config["icon-class"].trim().split(" ").forEach((function(t){shmi.addClass(e.vars.iconEl,t)}))}else shmi.addClass(e.element,"no-icon");else shmi.addClass(e.element,"no-icon"),shmi.log("[IQ:iq-button-rocker] no button-icon element provided",1);var s={onPress:function(){shmi.log("[IQ:iq-button-toggle] Button pressed",0),shmi.addClass(e.element,"pressed")},onRelease:function(){shmi.log("[IQ:iq-button-toggle] Button released",0),shmi.removeClass(e.element,"pressed")},onClick:function(){e.vars.value===e.config["on-value"]?e.config["confirm-off"]?shmi.confirm(e.config["confirm-off-text"],(function(t){t&&e.toggle()})):e.toggle():e.config["confirm-on"]?shmi.confirm(e.config["confirm-on-text"],(function(t){t&&e.toggle()})):e.toggle()}};e.vars.buttonEl?(e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.vars.buttonEl,s)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.vars.buttonEl,s))):shmi.log("[IQ:iq-button-rocker] no button element provided",1),!e.config.item&&e.config.event&&(e.config["on-value"]=1,e.config["off-value"]=0),e.vars.value=e.config["off-value"],Array.isArray(e.config["on-action"])&&e.config["on-action"].length&&(e.vars.onAction=new t.UiAction(e.config["on-action"],e)),Array.isArray(e.config["off-action"])&&e.config["off-action"].length&&(e.vars.offAction=new t.UiAction(e.config["off-action"],e))}else shmi.log("[IQ:iq-button-toggle] At least one state element is missing",1)},onEnable:function(){var e=this;e.vars.listeners.forEach((function(e){e.enable()})),e.config.item&&(e.vars.subscriptionTargetId=e.imports.im.subscribeItem(e.config.item,e)),shmi.log("[IQ:iq-button-toggle] Enabled",1)},onDisable:function(){var e=this;e.vars.listeners.forEach((function(e){e.disable()})),e.config.item&&e.imports.im.unsubscribeItem(e.config.item,e.vars.subscriptionTargetId),shmi.log("[IQ:iq-button-toggle] disabled",1)},onLock:function(){this.vars.listeners.forEach((function(e){e.disable()})),shmi.addClass(this.element,"locked"),shmi.log("[IQ:iq-button-toggle] Locked",1)},onUnlock:function(){this.vars.listeners.forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked"),shmi.log("[IQ:iq-button-toggle] unlocked",1)},toggle:function(){var e=this,t=e.vars.value!==e.config["on-value"];e.config.item?t?e.imports.im.writeValue(e.config.item,e.config["on-value"]):e.imports.im.writeValue(e.config.item,e.config["off-value"]):t?e.setValue(e.config["on-value"]):e.setValue(e.config["off-value"]),t&&e.vars.onAction?e.vars.onAction.execute():!t&&e.vars.offAction&&e.vars.offAction.execute()},getTooltip:function(){var e=this,t=shmi.visuals.core.BaseControl.prototype.getTooltip.call(this);if(t)return t;if(e.vars.value===e.config["off-value"]){if(shmi.objectHasOwnProperty(e.config,"off-tooltip"))return e.config["off-tooltip"]}else if(e.vars.value===e.config["on-value"]&&shmi.objectHasOwnProperty(e.config,"on-tooltip"))return e.config["on-tooltip"];return null},onSetValue:function(e,t,s){var n=this,a=n.vars.value;n.vars.value=parseFloat(e),n.vars.value===n.config["off-value"]?(shmi.removeClass(n.vars.buttonEl,"iq-on-state"),shmi.addClass(n.vars.buttonEl,"iq-off-state")):(shmi.removeClass(n.vars.buttonEl,"iq-off-state"),shmi.addClass(n.vars.buttonEl,"iq-on-state")),n.vars.value!==a&&(n.setTooltip(n.getTooltip()),n.fire("change",{value:n.vars.value}))},getValue:function(){return this.vars.value},setLabel:function(e){var t=this;t.vars.labelEl&&t.config["auto-label"]&&setLabelImpl(t,e)},setupIconElement:function(e,t,s){t?t.trim().split(" ").forEach((function(t){shmi.addClass(e,t)})):s&&(e.style.backgroundImage=`url(${s})`)}}};shmi.requires("visuals.tools.control-generator").generate(s)}(),function(){"use strict";var e="iq-button",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1);t.fLog,t.log;function setLabelImpl(e,t){e.vars.labelEl&&(""===t||null==t?(e.vars.label="",e.vars.labelEl.textContent="",shmi.addClass(e.element,"no-label")):(e.vars.label=t,e.vars.labelEl.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-label")))}var s={className:"iq-button",uiType:e,isContainer:!1,config:{"class-name":"iq-button",name:null,template:"default/iq-button.iq-variant-01",item:null,label:"[Label]","auto-label":!0,"label-from-item":!1,"icon-src":null,"icon-class":null,action:null,onClick:null,tooltip:null,"write-bool":!1,"on-value":1,"off-value":0,"action-release":null,"action-while-pressed":null,"interval-while-pressed":null,"action-pressed":null,"disable-alarms":!1,"show-icon":!1},configSchema:null,tooltipProperties:["tooltip"],vars:{listeners:[],value:0,active:!1,buttonEl:null,labelEl:null,iconEl:null,label:null,action:null,actionPress:null,actionRelease:null,actionWhilePressed:null,actionWhilePressedTimer:null,keyDownListener:null,keyUpListener:null,keyDownOnMe:null,mouseListener:null,touchListener:null,initialized:!1,rafId:0,subscriptionTargetId:null,monoFlopInterval:0,conditional:null,tokens:[]},imports:{im:"visuals.session.ItemManager",nv:"visuals.tools.numericValues"},events:["press","release","click"],prototypeExtensions:{onInit:function(){var e=this;if(e.imports.nv.initValueSettings(e),e.vars.buttonEl=shmi.getUiElement("button",e.element),e.vars.labelEl=shmi.getUiElement("label",e.element),e.vars.iconEl=shmi.getUiElement("icon",e.element),e.vars.iconEl)if(e.config["icon-src"]&&e.config["show-icon"])e.vars.iconEl.style.backgroundImage=`url(${e.config["icon-src"]})`;else if(e.config["icon-class"]&&e.config["show-icon"]){e.config["icon-class"].trim().split(" ").forEach(shmi.addClass.bind(shmi,e.vars.iconEl))}else shmi.addClass(e.element,"no-icon");else shmi.log("[IQ:iq-button] no button-icon element provided",1);if(!e.vars.buttonEl)return shmi.log("[IQ:iq-button] template is missing button element",3),e.vars.buttonEl=null,e.vars.labelEl=null,void(e.vars.iconEl=null);setLabelImpl(e,e.config.label),e.config.action&&(e.vars.action=new shmi.visuals.core.UiAction(e.config.action,e)),e.config["action-press"]&&(e.vars.actionPress=new shmi.visuals.core.UiAction(e.config["action-press"],e)),e.config["action-release"]&&(e.vars.actionRelease=new shmi.visuals.core.UiAction(e.config["action-release"],e)),e.config["action-while-pressed"]&&(e.vars.actionWhilePressed=new shmi.visuals.core.UiAction(e.config["action-while-pressed"],e));var t=shmi.visuals.session,s={onClick:function(s,n,a){null!==t.FocusElement&&(t.FocusElement.blur(),t.FocusElement=null),e.vars.buttonEl instanceof HTMLElement?(e.vars.buttonEl.focus(),t.FocusElement=e.vars.buttonEl,shmi.log("[IQ:iq-button] focused",1)):shmi.log("[IQ:iq-button] only HTMLElements may be focused, type: "+e.vars.buttonEl.constructor,1),e.fire("click",{x:s,y:n,event:a}),e.vars.action&&e.vars.action.execute(),e.onClick&&e.onClick(e)},onRelease:function(t,s,n){shmi.removeClass(e.vars.buttonEl,"pressed"),e.fire("release",{x:t,y:s,event:n}),e.config["write-bool"]&&e.config.item&&e.writeValue(e.config["off-value"]),e.vars.actionWhilePressedTimer&&clearInterval(e.vars.actionWhilePressedTimer),e.vars.actionRelease&&e.vars.actionRelease.execute()},onPress:function(t,s,n){shmi.addClass(e.vars.buttonEl,"pressed"),e.fire("press",{x:t,y:s,event:n}),e.config["write-bool"]&&e.config.item&&e.writeValue(e.config["on-value"]),e.vars.actionPress&&e.vars.actionPress.execute(),e.vars.actionWhilePressed&&e.config["interval-while-pressed"]&&(e.vars.actionWhilePressedTimer&&clearInterval(e.vars.actionWhilePressedTimer),e.vars.actionWhilePressedTimer=setInterval((function(){e.vars.actionWhilePressed.execute()}),e.config["interval-while-pressed"]))}};e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.vars.buttonEl,s)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.vars.buttonEl,s)),e.vars.keyUpListener=function(t){if(e.vars.keyDownOnMe&&("Enter"===t.code||"NumpadEnter"===t.code)&&e.element===document.activeElement){shmi.removeClass(e.element,"pressed");var n=e.element.getBoundingClientRect();s.onClick(n.left+n.width/2,n.top+n.height/2,t),e.vars.keyDownOnMe=!1}},e.vars.keyDownListener=function(t){"Enter"!==t.code&&"NumpadEnter"!==t.code||e.element!==document.activeElement||(shmi.addClass(e.element,"pressed"),e.vars.keyDownOnMe=!0)}},onEnable:function(){var e=this;if(null!==e.vars.conditional?e.vars.conditional.item!==e.config.item&&(e.vars.conditional.item=e.config.item):e.config.item&&!e.config["disable-alarms"]&&(e.vars.conditional=shmi.createConditional(e.element,e.config.item)),e.vars.conditional&&e.vars.conditional.enable(),e.element.setAttribute("tabindex","0"),e.vars.listeners.forEach((function(e){e.enable()})),e.config.item){if(e.config["disable-item-lock"]){var t=e.imports.im.getItemHandler();t.setValue=function(t){e.setValue(t)},e.vars.subscriptionTargetId=e.imports.im.subscribeItem(e.config.item,t)}else e.vars.subscriptionTargetId=e.imports.im.subscribeItem(e.config.item,e);if(e.config.monoflop){var s=e.listen("press",(function(){clearInterval(e.vars.monoFlopInterval),e.vars.monoFlopInterval=setInterval((function(){e.imports.im.writeValue(e.config.item,e.config["monoflop-value"],{skipSameValueCheck:!0})}),e.config["monoflop-interval"])})),n=e.listen("release",(function(){clearInterval(e.vars.monoFlopInterval)}));e.vars.tokens.push(s,n)}}e.element.addEventListener("keyup",e.vars.keyUpListener,!1),e.element.addEventListener("keydown",e.vars.keyDownListener,!1),shmi.log("[IQ:iq-button] Enabled",1)},onDisable:function(){var e=this;e.vars.conditional&&e.vars.conditional.disable(),e.config.item&&e.imports.im.unsubscribeItem(e.config.item,e.vars.subscriptionTargetId),e.element.removeAttribute("tabindex"),e.vars.tokens.forEach((function(e){e.unlisten()})),e.vars.tokens=[],e.vars.listeners.forEach((function(e){e.disable()})),e.element.removeEventListener("keyup",e.vars.keyUpListener),e.element.removeEventListener("keydown",e.vars.keyDownListener),e.vars.actionWhilePressedTimer&&(clearInterval(e.vars.actionWhilePressedTimer),e.vars.actionWhilePressedTimer=null),shmi.log("[IQ:iq-button] disabled",1)},onLock:function(){var e=this;e.vars.listeners.forEach((function(e){e.disable()})),e.vars.buttonEl&&(e.vars.buttonEl.removeAttribute("tabindex"),e.vars.buttonEl.removeEventListener("keyup",e.vars.keyUpListener),e.vars.buttonEl.removeEventListener("keydown",e.vars.keyDownListener),e.vars.buttonEl.blur()),shmi.addClass(e.element,"locked"),shmi.log("[IQ:iq-button] Locked",1)},onUnlock:function(){var e=this;e.vars.listeners.forEach((function(e){e.enable()})),shmi.removeClass(e.element,"locked"),e.vars.buttonEl&&(e.vars.buttonEl.addEventListener("keyup",e.vars.keyUpListener,!1),e.vars.buttonEl.addEventListener("keydown",e.vars.keyDownListener,!1),e.vars.buttonEl.setAttribute("tabindex",0)),shmi.log("[IQ:iq-button] unlocked",1)},onSetValue:function(e,t,s){var n=this;n.vars.value=e,!0===n.config["label-from-item"]&&(shmi.caf(n.rafId),n.rafId=shmi.raf((function(){setLabelImpl(n,shmi.localize(n.imports.nv.formatOutput(e,n)))})))},getValue:function(){return this.vars.value},onSetProperties:function(e,t,s){this.imports.nv.setProperties(this,arguments)},setLabel:function(e){var t=this;t.vars.labelEl&&t.config["auto-label"]&&setLabelImpl(t,e)},writeValue:function(e){var t=this;t.config.item&&t.imports.im.writeValue(t.config.item,e,{skipSameValueCheck:!0})}}};shmi.requires("visuals.tools.control-generator").generate(s)}(),function(){"use strict";var e="iq-checkbox",t={"class-name":"iq-checkbox",name:null,template:"default/iq-checkbox.variant-01",label:"[Label]",item:null,type:shmi.c("TYPE_INT"),"auto-label":!0,"show-icon":!1,"show-text":!0,"icon-src":null,"icon-class":null,tooltip:null,"on-value":1,"off-value":0,"pressed-class":"pressed","confirm-off-text":"${V_CONFIRM_OFF}","confirm-on-text":"${V_CONFIRM_ON}","confirm-on":!1,"confirm-off":!1},s=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1);s.fLog,s.log;function setLabelImpl(e,t){e.vars.labelEl&&(""===t||null==t?(e.vars.label="",e.vars.labelEl.textContent="",shmi.addClass(e.element,"no-label")):(e.vars.label=t,e.vars.labelEl.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-label")))}var n={className:"iq-checkbox",uiType:e,isContainer:!1,config:t,configSchema:null,vars:{listeners:[],value:0,active:!1,checkboxEl:null,labelEl:null,iconEl:null,containerEl:null,label:null},imports:{im:"visuals.session.ItemManager",nv:"visuals.tools.numericValues"},events:["change"],prototypeExtensions:{onInit:function(){var e=this;if(e.vars.checkboxEl=shmi.getUiElement("checkbox",e.element),e.vars.labelEl=shmi.getUiElement("label",e.element),e.vars.iconEl=shmi.getUiElement("icon",e.element),e.vars.containerEl=shmi.getUiElement("iq-checkbox-container",e.element),e.vars.iconEl?e.config["icon-src"]&&e.config["show-icon"]?e.vars.iconEl.style.backgroundImage=`url(${e.config["icon-src"]})`:e.config["icon-class"]&&e.config["show-icon"]?shmi.addClass(e.vars.iconEl,e.config["icon-class"]):shmi.addClass(e.element,"no-icon"):(shmi.log("[IQ:iq-checkbox] no button-icon element provided",1),shmi.addClass(e.element,"no-icon")),e.vars.value=e.config["off-value"],null===e.vars.checkboxEl)return shmi.log("[IQ:iq-checkbox] Checkbox element is missing",3),e.vars.checkboxEl=null,e.vars.labelEl=null,void(e.vars.iconEl=null);if(e.config["show-text"]?setLabelImpl(e,e.config.label):setLabelImpl(e,null),e.vars.containerEl){var t={onPress:function(t,s,n){shmi.addClass(e.element,e.config["pressed-class"])},onRelease:function(){shmi.removeClass(e.element,e.config["pressed-class"])},onClick:function(t,s,n){n.preventDefault(),e.vars.value===e.config["on-value"]?e.config["confirm-off"]?shmi.confirm(e.config["confirm-off-text"],(function onConfirmed(t){t&&e.updateValue(e.config["off-value"])})):e.updateValue(e.config["off-value"]):e.config["confirm-on"]?shmi.confirm(e.config["confirm-on-text"],(function onConfirmed(t){t&&e.updateValue(e.config["on-value"])})):e.updateValue(e.config["on-value"])}};e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.vars.containerEl,t)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.vars.containerEl,t))}else console.error("[IQ:iq-checkbox] 'iq-checkbox-container' element is missing, cannot attach listener.")},onEnable:function(){var e=this;e.vars.listeners.forEach((function(e){e.enable()})),e.config.item&&(e.vars.subscriptionTargetId=e.imports.im.subscribeItem(e.config.item,e)),shmi.log("[IQ:iq-checkbox] Enabled",1)},onDisable:function(){var e=this;e.vars.listeners.forEach((function(e){e.disable()})),e.config.item&&e.imports.im.unsubscribeItem(e.config.item,e.vars.subscriptionTargetId),shmi.log("[IQ:iq-checkbox] disabled",1)},onLock:function(){var e=this;e.vars.checkboxEl.blur(),e.vars.listeners.forEach((function(e){e.disable()})),shmi.addClass(this.element,"locked"),e.vars.checkboxEl.disabled=!0,shmi.log("[IQ:iq-checkbox] Locked",1)},onUnlock:function(){var e=this;e.vars.listeners.forEach((function(e){e.enable()})),shmi.removeClass(e.element,"locked"),e.vars.checkboxEl.disabled=!1,shmi.log("[IQ:iq-checkbox] unlocked",1)},onSetValue:function(e,t,s){var n=this,a=!1;e===n.config["on-value"]?(n.vars.value=n.config["on-value"],a=!0,shmi.addClass(n.element,"checked")):(n.vars.value=n.config["off-value"],a=!0,shmi.removeClass(n.element,"checked")),a&&n.fire("change",{value:n.vars.value})},getValue:function(){return this.vars.value},setLabel:function(e){var t=this;t.vars.labelEl&&t.config["auto-label"]&&t.config["show-text"]&&setLabelImpl(t,e)},updateValue:function(e){var t=this;t.config.item?t.imports.im.writeValue(t.config.item,e):t.setValue(e)}}};shmi.requires("visuals.tools.control-generator").generate(n)}(),function(){"use strict";var e="iq-date-time",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),s=(t.fLog,t.log,{className:"iqDateTime",uiType:e,isContainer:!1,config:{"class-name":"iq-date-time",name:null,template:"default/iq-date-time.variant-01",item:null,"display-utc":!1,"display-format":"$YYYY-$MM-$DD $HH:$mm:$ss","input-format":"$X","invalid-text":"${date-time.invalid-time}",tooltip:null,"value-as-tooltip":!1},configSchema:null,vars:{listeners:[],value:0,active:!1,domEl:null,subscriptionTargetId:null,localizedDisplayFormat:null,localizedInvalidText:null,rafRunning:!1,lastValue:null},imports:{im:"visuals.session.ItemManager",dt:"visuals.tools.date"},events:[],prototypeExtensions:{onInit:function(){var e=this;e.vars.domEl=shmi.getUiElement("datetime",e.element),e.vars.domEl?(e.vars.localizedDisplayFormat=shmi.localize(e.config["display-format"]),e.vars.localizedInvalidText=shmi.localize(e.config["invalid-text"]),e.vars.domEl.textContent=e.vars.localizedInvalidText,e.config["value-as-tooltip"]&&e.setTooltip(e.vars.localizedInvalidText)):shmi.log("[IQ:iq-date-time] Element is missing",3)},onEnable:function(){var e=this;e.config.item&&(e.vars.subscriptionTargetId=e.imports.im.subscribeItem(e.config.item,e)),shmi.log("[IQ:iq-date-time] Enabled",1)},onDisable:function(){var e=this;e.vars.subscriptionTargetId&&(e.vars.subscriptionTargetId.unlisten(),e.vars.subscriptionTargetId=null),shmi.log("[IQ:iq-date-time] disabled",1)},onSetValue:function(e,t){var s=this;t===shmi.c("TYPE_INT")||t===shmi.c("TYPE_FLOAT")?s.vars.lastValue=s.imports.dt.parseDateTime(String(e),s.config["input-format"]||"$X"):s.config["input-format"]?s.vars.lastValue=s.imports.dt.parseDateTime(String(e),s.config["input-format"]):s.vars.lastValue=null,s.vars.rafRunning||(s.vars.rafRunning=!0,shmi.raf((function onDraw(){let e=null;e=s.vars.lastValue?s.imports.dt.formatDateTime(s.vars.lastValue,{datestring:s.vars.localizedDisplayFormat,utc:s.config["display-utc"]}):s.vars.localizedInvalidText,s.vars.domEl.textContent=e,s.vars.domEl.innerHTML=s.vars.domEl.innerHTML.replace(/\n/g,"<br>"),s.config["value-as-tooltip"]&&s.setTooltip(e.replace(/(\\n)+/g," ")),s.vars.rafRunning=!1})))},onLock:function(){shmi.addClass(this.element,"locked")},onUnlock:function(){shmi.removeClass(this.element,"locked")}}});shmi.requires("visuals.tools.control-generator").generate(s)}(),function(){"use strict";var e="iq-duration-display",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1);t.fLog,t.log;function setText(e,t){e.vars.durationEl&&(e.vars.durationEl.textContent=t,e.config["value-as-tooltip"]&&e.setTooltip(t))}function makeItemHandler(e,t,s){return{setValue:function setValue(n,a){a===shmi.c("TYPE_INT")||a===shmi.c("TYPE_FLOAT")?e.vars[s]=e.imports.dt.parseDateTime(String(n),e.config[t]||"$X"):e.config[t]?e.vars[s]=e.imports.dt.parseDateTime(String(n),e.config[t]):e.vars[s]=null,function doUpdate(e){null===e.vars.tsTarget||null===e.vars.tsCurrent?e.vars.lastValue=null:e.vars.lastValue=e.vars.tsTarget-e.vars.tsCurrent,e.vars.rafRunning||(e.vars.rafRunning=!0,shmi.raf((function onDraw(){e.vars.lastValue?setText(e,e.imports.dt.formatDuration(e.vars.lastValue,e.config["display-preset"]||"compact")):setText(e,e.vars.localizedInvalidText),e.vars.rafRunning=!1})))}(e)}}}var s={className:"iq-duration-display",uiType:e,isContainer:!1,config:{"class-name":"iq-duration-display",name:null,template:"default/iq-duration-display.variant-01",label:"[Label]","target-ts-item":null,"target-ts-format":"$X","current-ts-item":"Systemzeit","current-ts-format":"$X","display-preset":"compact","invalid-text":"${duration-display.invalid-duration}",tooltip:null,"value-as-tooltip":!1},configSchema:null,vars:{listeners:[],tsTarget:null,tsCurrent:null,localizedInvalidText:null,rafRunning:!1,lastValue:null,durationEl:null},imports:{im:"visuals.session.ItemManager",dt:"visuals.tools.date"},events:[],prototypeExtensions:{onInit:function(){var e=this;e.vars.durationEl=shmi.getUiElement("duration",e.element),e.vars.durationEl?(e.vars.localizedInvalidText=shmi.localize(e.config["invalid-text"]),setText(e,e.vars.localizedInvalidText)):shmi.log("[IQ:iq-duration] Element is missing",3)},onEnable:function(){var e=this;e.config["target-ts-item"]&&e.config["current-ts-item"]&&0===e.vars.listeners.length&&(e.vars.listeners.push(e.imports.im.subscribeItem(e.config["target-ts-item"],makeItemHandler(e,"target-ts-format","tsTarget"))),e.vars.listeners.push(e.imports.im.subscribeItem(e.config["current-ts-item"],makeItemHandler(e,"current-ts-format","tsCurrent"))))},onDisable:function(){this.vars.listeners.forEach((function(e){e.unlisten()})),this.vars.listeners=[]},onLock:function(){shmi.addClass(this.element,"locked")},onUnlock:function(){shmi.removeClass(this.element,"locked")}}};shmi.requires("visuals.tools.control-generator").generate(s)}(),function(){"use strict";var e="iq-flip-switch",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1);t.fLog,t.log;function setLabelImpl(e,t){e.vars.labelEl?""===t||null==t?(e.vars.label="",e.vars.labelEl.textContent="",shmi.addClass(e.element,"no-label")):(e.vars.label=t,e.vars.labelEl.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-label")):shmi.addClass(e.element,"no-label")}function updateHandle(e){const t=e.getValue(),s=e.vars.handleEl?Math.ceil(e.vars.handleEl.getBoundingClientRect().width):0,n=e.vars.handleBoxEl?e.vars.handleBoxEl.clientWidth:0;!e.vars.isDragging&&e.vars.handleBoxEl&&(t===e.config["on-value"]?e.vars.handleDragOffset=n-s:e.vars.handleDragOffset=0)}var s={className:"iq-flip-switch",uiType:e,isContainer:!1,config:{"class-name":"iq-flip-switch",name:null,template:"default/iq-flip-switch.variant-01",label:"[Label]","auto-label":!0,"on-label":"${flip-switch.label-on}","off-label":"${flip-switch.label-off}",item:null,"show-icon":!1,"icon-src":null,"icon-class":null,tooltip:null,"on-value":1,"off-value":0,transitionStyle:"all .16s linear","confirm-off-text":"${V_CONFIRM_OFF}","confirm-on-text":"${V_CONFIRM_ON}","confirm-on":!1,"confirm-off":!1},configSchema:null,vars:{listeners:[],value:0,active:!1,iconEl:null,labelEl:null,labelOnEl:null,labelOffEl:null,handleEl:null,handleBoxEl:null,initialized:!1,subscriptionTargetId:null,isDragging:!1,width:null,handleWidth:null,handleDragOffset:0},imports:{im:"visuals.session.ItemManager",nv:"visuals.tools.numericValues"},events:["change"],prototypeExtensions:{onInit:function(){var e=this;if(e.vars.iconEl=shmi.getUiElement("icon",e.element),e.vars.labelEl=shmi.getUiElement("label",e.element),e.vars.labelOnEl=shmi.getUiElement("label-on",e.element),e.vars.labelOffEl=shmi.getUiElement("label-off",e.element),e.vars.handleEl=shmi.getUiElement("handle",e.element),e.vars.handleBoxEl=shmi.getUiElement("handle-box",e.element),!e.vars.handleEl||!e.vars.handleBoxEl)return shmi.log("[IQ:iq-flip-switch] Handle or handle box element is missing!",3),e.vars.labelEl=null,e.vars.labelOnEl=null,e.vars.labelOffEl=null,e.vars.handleEl=null,e.vars.handleBoxEl=null,void(e.vars.iconEl=null);if(e.vars.iconEl)if(e.config["icon-src"]&&e.config["show-icon"])e.vars.iconEl.style.backgroundImage=`url(${e.config["icon-src"]})`;else if(e.config["icon-class"]&&e.config["show-icon"]){e.config["icon-class"].trim().split(" ").forEach((function(t){shmi.addClass(e.vars.iconEl,t)}))}else shmi.addClass(e.element,"no-icon");else shmi.addClass(e.element,"no-icon"),shmi.log("[IQ:iq-flip-switch] no button-icon element provided",1);setLabelImpl(e,e.config.label),e.vars.labelOnEl&&e.config["on-label"]&&(e.vars.labelOnEl.textContent=shmi.localize(e.config["on-label"])),e.vars.labelOffEl&&e.config["on-label"]&&(e.vars.labelOffEl.textContent=shmi.localize(e.config["off-label"]));let t=null;var s={onDrag:function(s,n,a){const l=e.vars.handleEl?Math.ceil(e.vars.handleEl.getBoundingClientRect().width):0,o=e.vars.handleBoxEl?e.vars.handleBoxEl.clientWidth:0;a.preventDefault(),e.vars.handleDragOffset+s<0?e.vars.handleDragOffset=0:e.vars.handleDragOffset+s+l>o?e.vars.handleDragOffset=o-l:e.vars.handleDragOffset+=s,t&&shmi.caf(t),t=shmi.raf((()=>{e.vars.handleEl.style.transform=`translate3d(${e.vars.handleDragOffset}px, 0, 0)`})),e.vars.isDragging||(e.vars.isDragging=!0)},onPress:function(){shmi.addClass(e.vars.handleEl,"pressed")},onRelease:function(){e.vars.isDragging&&(e.vars.isDragging=!1,e.vars.handleDragOffset>(e.vars.handleBoxEl.offsetWidth-e.vars.handleEl.offsetWidth)/2?e.config["confirm-on"]?shmi.confirm(e.config["confirm-on-text"],(function(t){e.handleOnOff(!0,t)})):e.handleOnOff(!0,null):e.config["confirm-off"]?shmi.confirm(e.config["confirm-off-text"],(function(t){e.handleOnOff(!1,t)})):e.handleOnOff(!1,null)),t&&shmi.caf(t),e.vars.handleEl.style.transform="",shmi.removeClass(e.vars.handleEl,"pressed")},onClick:function(){e.vars.value===e.config["on-value"]?e.config["confirm-off"]?shmi.confirm(e.config["confirm-off-text"],(function(t){t&&e.turnOnOff(!1)})):e.turnOnOff(!1):e.config["confirm-on"]?shmi.confirm(e.config["confirm-on-text"],(function(t){t&&e.turnOnOff(!0)})):e.turnOnOff(!0)}};e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.vars.handleEl,s)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.vars.handleEl,s));var n={onClick:s.onClick};e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.vars.handleBoxEl,n)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.vars.handleBoxEl,n)),e.vars.listeners.push(function makeResizeListener(e,t){return{disable:()=>window.removeEventListener("resize",t),enable:()=>window.addEventListener("resize",t)}}(0,updateHandle.bind(null,e)))},onEnable:function(){var e=this;e.config.item&&(e.vars.subscriptionTargetId=e.imports.im.subscribeItem(e.config.item,e)),e.vars.listeners.forEach((function(e){e.enable()})),shmi.log("[IQ:iq-flip-switch] Enabled",1)},onDisable:function(){var e=this;e.vars.subscriptionTargetId&&(e.vars.subscriptionTargetId.unlisten(),e.vars.subscriptionTargetId=null),e.vars.listeners.forEach((function(e){e.disable()})),shmi.log("[IQ:iq-flip-switch] disabled",1)},onLock:function(){this.vars.listeners.forEach((function(e){e.disable()})),shmi.addClass(this.element,"locked"),shmi.log("[IQ:iq-flip-switch] Locked",1)},onUnlock:function(){this.vars.listeners.forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked"),shmi.log("[IQ:iq-flip-switch] unlocked",1)},onSetValue:function(e,t,s){const n=this,a=n.vars.value;!n.vars.isDragging&&n.vars.handleBoxEl&&(e===n.config["on-value"]?(n.vars.value=n.config["on-value"],shmi.addClass(n.element,"on")):(n.vars.value=n.config["off-value"],shmi.removeClass(n.element,"on")),a!==n.vars.value&&(n.fire("change",{value:n.vars.value}),n.onChange&&n.onChange(n.vars.value)),updateHandle(n))},getValue:function(){return this.vars.value},setLabel:function(e){var t=this;t.vars.labelEl&&t.config["auto-label"]&&setLabelImpl(t,e)},handleOnOff:function(e,t){var s=this,n=e?s.config["on-value"]:s.config["off-value"];!0===t||null===t?(updateHandle(s),s.config.item?shmi.visuals.session.ItemManager.writeValue(s.config.item,n):s.setValue(n)):s.setValue(s.vars.value)},turnOnOff:function(e){var t=this,s=e?t.config["on-value"]:t.config["off-value"];t.config.item?t.imports.im.writeValue(t.config.item,s):t.setValue(s)}}};shmi.requires("visuals.tools.control-generator").generate(s)}(),function(){"use strict";var e="iq-heartbeat",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1);t.fLog,t.log;function performCompareExchange(e,t,s,n){e.vars.isEnabled&&e.imports.im.compareExchange(e.config["item-hmi"],t,s,(function(t,a,l){l&&a?((s=t+1)>Number.MAX_SAFE_INTEGER&&(s=0),performCompareExchange(e,t,s,n)):"function"==typeof n&&n(!l)}))}function onPlcTimerElapsed(e){e.vars.isDisconnected=!0,e.vars.imgEl.src=e.vars.imagePathFail,e.setTooltip(e.config["image-fail-title"]),e.vars.actionFail&&e.vars.actionFail.execute()}var s={className:"iqHeartbeat",uiType:e,isContainer:!1,config:{"class-name":"iq-heartbeat",name:null,template:"default/iq-heartbeat.variant-01",item:null,"item-plc":null,"timeout-plc":null,"image-ok-src":null,"image-ok-title":null,"image-fail-src":null,"image-fail-title":null,"action-fail":null,"action-ok":null,"item-hmi":null,"timeout-hmi":null,"scaling-mode":"fit-height"},configSchema:null,vars:{active:!1,imgEl:null,tokens:[],plcItemValue:null,plcItemTimer:null,hmiItemValue:null,hmiItemTimer:null,hmiItemTimerActive:!1,isDisconnected:!1,actionOk:null,actionFail:null,imagePathOk:null,imagePathFail:null,isEnabled:!1},imports:{im:"visuals.session.ItemManager"},events:[],prototypeExtensions:{onInit:function(){var e=this;e.vars.imgEl=shmi.getUiElement("image",e.element),e.vars.imgEl?(e.vars.imgEl.dataset.imgOk&&e.vars.imgEl.dataset.imgFail&&(e.vars.imagePathOk=e.vars.imgEl.dataset.imgOk,e.vars.imagePathFail=e.vars.imgEl.dataset.imgFail),e.config["image-ok-src"]&&(e.vars.imagePathOk=e.config["image-ok-src"]),e.config["image-fail-src"]&&(e.vars.imagePathFail=e.config["image-fail-src"],e.setTooltip(e.config["image-fail-title"])),e.vars.imgEl.src=e.vars.imagePathFail,e.config["action-fail"]&&(e.vars.actionFail=new shmi.visuals.core.UiAction(e.config["action-fail"],e)),e.config["action-ok"]&&(e.vars.actionOk=new shmi.visuals.core.UiAction(e.config["action-ok"],e)),function applyScalingMode(e){let t="fit-height";switch(e.config["scaling-mode"]){case"fit-height":case"fit-width":case"stretch":case"contain":t=e.config["scaling-mode"]}shmi.addClass(e.element,t)}(e)):e.log("Image element is missing!",3)},onEnable:function(){var e=this;if(e.vars.isEnabled=!0,e.config["item-plc"]&&(e.vars.tokens.push(e.imports.im.subscribeItem(e.config["item-plc"],e)),e.vars.plcItemTimer=setTimeout(onPlcTimerElapsed.bind(null,e),e.config["timeout-plc"])),e.config["item-hmi"]&&e.config["timeout-hmi"]){let t=e.imports.im.getItemHandler();t.setValue=function(t){e.vars.hmiItemValue=parseInt(t)},e.vars.tokens.push(e.imports.im.subscribeItem(e.config["item-hmi"],t)),e.vars.hmiItemTimer=setInterval((function(){if(e.vars.hmiItemTimerActive)return;e.vars.hmiItemTimerActive=!0;let t=e.vars.hmiItemValue;null===t&&(t=0),t===Number.MAX_VALUE&&(t=0),t+=1,performCompareExchange(e,e.vars.hmiItemValue,t,(function(t){e.vars.hmiItemTimerActive=!1}))}),e.config["timeout-hmi"])}e.log("Enabled",1)},onDisable:function(){var e=this;e.vars.isEnabled=!1,e.vars.tokens.forEach((function(e){e.unlisten()})),e.vars.tokens=[],e.vars.hmiItemTimer&&(clearInterval(e.vars.hmiItemTimer),e.vars.hmiItemTimer=null),e.vars.plcItemTimer&&(clearTimeout(e.vars.plcItemTimer),e.vars.plcItemTimer=null),e.log("Disabled",1)},onSetValue:function(e){var t=this;t.config["timeout-plc"]&&(t.vars.plcItemTimer&&(clearTimeout(t.vars.plcItemTimer),t.vars.plcItemTimer=null),t.vars.isDisconnected&&(t.vars.isDisconnected=!1,t.vars.actionOk&&t.vars.actionOk.execute()),t.vars.imgEl.src!==t.vars.imagePathOk&&(t.setTooltip(t.config["image-ok-title"]),t.vars.imgEl.src=t.vars.imagePathOk),t.vars.plcItemTimer=setTimeout(onPlcTimerElapsed.bind(null,t),t.config["timeout-plc"]))},log:function(e,t){shmi.log("[IQ:iq-heartbeat] "+e,t)}}};shmi.requires("visuals.tools.control-generator").generate(s)}(),function(){"use strict";var e="iq-image-changer",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1);t.fLog,t.log;var s={className:"iq-image-changer",uiType:e,isContainer:!1,config:{"class-name":"iq-image-changer",name:null,template:"default/iq-image-changer.variant-01",item:null,tooltip:null,options:[],"default-image":"pics/system/icons/placeholder.svg","default-title":null,"scaling-mode":"fit-height",action:null,"action-release":null,"action-while-pressed":null,"interval-while-pressed":null,"action-pressed":null,"write-bool":!1,"on-value":1,"off-value":0},configSchema:null,vars:{listeners:[],value:0,active:!1,imageEl:null,action:null,actionRelease:null,actionWhilePressed:null,actionWhilePressedTimer:null,mouseListener:null,touchListener:null,activeOption:null,subscriptionTargetId:null},imports:{im:"visuals.session.ItemManager"},events:["press","release","click"],prototypeExtensions:{onInit:function(){var e=this;e.vars.imageEl=shmi.getUiElement("image",e.element),e.config.action&&(e.vars.action=new shmi.visuals.core.UiAction(e.config.action,e)),e.config["action-press"]&&(e.vars.actionPress=new shmi.visuals.core.UiAction(e.config["action-press"],e)),e.config["action-release"]&&(e.vars.actionRelease=new shmi.visuals.core.UiAction(e.config["action-release"],e)),e.config["action-while-pressed"]&&(e.vars.actionWhilePressed=new shmi.visuals.core.UiAction(e.config["action-while-pressed"],e)),Array.isArray(e.config.action)&&e.config.action.length>0?shmi.addClass(e.vars.imageEl,"clickable"):shmi.removeClass(e.vars.imageEl,"clickable"),function applyScalingMode(e){let t="fit-height";switch(e.config["scaling-mode"]){case"fit-height":case"fit-width":case"stretch":case"contain":t=e.config["scaling-mode"]}shmi.addClass(e.element,t)}(e),e.getActive(null);const t=shmi.visuals.session;var s={onClick:function(s,n,a){null!==t.FocusElement&&(t.FocusElement.blur(),t.FocusElement=null),e.vars.imageEl instanceof HTMLElement?(e.vars.imageEl.focus(),t.FocusElement=e.vars.imageEl,shmi.log("[IQ:iq-image-changer] focused",1)):shmi.log("[IQ:iq-image-changer] only HTMLElements may be focused, type: "+e.vars.imageEl.constructor,1),e.fire("click",{x:s,y:n,event:a}),e.vars.action&&e.vars.action.execute()},onRelease:function(t,s,n){e.fire("release",{x:t,y:s,event:n}),e.config["write-bool"]&&e.config.item&&e.writeValue(e.config["off-value"]),e.vars.actionWhilePressedTimer&&clearInterval(e.vars.actionWhilePressedTimer),e.vars.actionRelease&&e.vars.actionRelease.execute()},onPress:function(t,s,n){e.fire("press",{x:t,y:s,event:n}),e.config["write-bool"]&&e.config.item&&e.writeValue(e.config["on-value"]),e.vars.actionPress&&e.vars.actionPress.execute(),e.vars.actionWhilePressed&&e.config["interval-while-pressed"]&&(e.vars.actionWhilePressedTimer&&clearInterval(e.vars.actionWhilePressedTimer),e.vars.actionWhilePressedTimer=setInterval((function(){e.vars.actionWhilePressed.execute()}),e.config["interval-while-pressed"]))}};e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.vars.imageEl,s)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.vars.imageEl,s))},onEnable:function(){var e=this;e.config.item&&(e.vars.subscriptionTargetId=e.imports.im.subscribeItem(e.config.item,e)),e.vars.listeners.forEach((function(e){e.enable()})),shmi.log("[IQ:iq-image-changer] Enabled",1)},onDisable:function(){var e=this;e.config.item&&e.imports.im.unsubscribeItem(e.config.item,e.vars.subscriptionTargetId),e.vars.listeners.forEach((function(e){e.disable()})),e.vars.actionWhilePressedTimer&&(clearInterval(e.vars.actionWhilePressedTimer),e.vars.actionWhilePressedTimer=null),shmi.log("[IQ:iq-image-changer] disabled",1)},onLock:function(){var e=this;e.vars.listeners.forEach((function(e){e.disable()})),shmi.addClass(e.element,"locked"),e.vars.actionWhilePressedTimer&&(clearInterval(e.vars.actionWhilePressedTimer),e.vars.actionWhilePressedTimer=null),shmi.log("[IQ:iq-image-changer] Locked",1)},onUnlock:function(){this.vars.listeners.forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked"),shmi.log("[IQ:iq-image-changer] unlocked",1)},onSetValue:function(e,t,s){var n=this;n.vars.value=e,n.getActive(n.vars.value)},getValue:function(){return this.value},onSetProperties:function(e,t,s,n,a,l,o,r,c,u){},getActive:function(e){const t=this;let s=null!==e?t.config.options.find((t=>Number.isSafeInteger(e)&&Number.isSafeInteger(t.mask)&&Number.isSafeInteger(t.value)?(BigInt(e)&BigInt(t.mask))===BigInt(t.value):t.value===e)):null;s||(s={"icon-src":t.config["default-image"],label:t.config["default-title"]||null}),t.vars.activeOption=s,t.vars.imageEl.setAttribute("src",s["icon-src"]),t.setTooltip(t.getTooltip())},getTooltip:function(){var e=this,t=shmi.visuals.core.BaseControl.prototype.getTooltip.call(this);return t||(e.vars.activeOption&&e.vars.activeOption.label?e.vars.activeOption.label:null)}}};shmi.requires("visuals.tools.control-generator").generate(s)}(),function(){"use strict";var e="iq-image",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1);t.fLog,t.log;var s={className:"iq-image",uiType:e,isContainer:!1,config:{"class-name":"iq-image",name:null,template:"default/iq-image.variant-01",tooltip:null,"image-src":"pkg://iq-image/placeholder.svg","image-alt":null,"image-title":null,"scaling-mode":"fit-height",action:null,"action-release":null,"action-while-pressed":null,"interval-while-pressed":null,"action-pressed":null,"write-bool":!1,"on-value":1,"off-value":0},configSchema:null,vars:{listeners:[],imageEl:null,action:null,actionRelease:null,actionWhilePressed:null,actionWhilePressedTimer:null,mouseListener:null,touchListener:null},imports:{},events:["press","release","click"],prototypeExtensions:{onInit:function(){var e=this;if(e.vars.imageEl=shmi.getUiElement("image",e.element),!e.vars.imageEl)return void shmi.log("[IQ:iq-image] Missing image element",3);e.vars.imageEl.setAttribute("draggable","false"),e.config["image-src"]&&e.vars.imageEl.setAttribute("src",e.config["image-src"]),e.config["image-alt"]&&e.vars.imageEl.setAttribute("alt",e.config["image-alt"]),e.config.action&&(e.vars.action=new shmi.visuals.core.UiAction(e.config.action,e)),e.config["action-press"]&&(e.vars.actionPress=new shmi.visuals.core.UiAction(e.config["action-press"],e)),e.config["action-release"]&&(e.vars.actionRelease=new shmi.visuals.core.UiAction(e.config["action-release"],e)),e.config["action-while-pressed"]&&(e.vars.actionWhilePressed=new shmi.visuals.core.UiAction(e.config["action-while-pressed"],e)),Array.isArray(e.config.action)&&e.config.action.length>0?shmi.addClass(e.vars.imageEl,"clickable"):shmi.removeClass(e.vars.imageEl,"clickable"),function applyScalingMode(e){let t="fit-height";switch(e.config["scaling-mode"]){case"fit-height":case"fit-width":case"stretch":case"contain":t=e.config["scaling-mode"]}shmi.addClass(e.element,t)}(e);const t=shmi.visuals.session;var s={onClick:function(s,n,a){null!==t.FocusElement&&(t.FocusElement.blur(),t.FocusElement=null),e.vars.imageEl instanceof HTMLElement?(e.vars.imageEl.focus(),t.FocusElement=e.vars.imageEl,shmi.log("[IQ:iq-image] focused",1)):shmi.log("[IQ:iq-image] only HTMLElements may be focused, type: "+e.vars.imageEl.constructor,1),e.fire("click",{x:s,y:n,event:a}),e.vars.action&&e.vars.action.execute()},onRelease:function(t,s,n){e.fire("release",{x:t,y:s,event:n}),e.config["write-bool"]&&e.config.item&&e.writeValue(e.config["off-value"]),e.vars.actionWhilePressedTimer&&clearInterval(e.vars.actionWhilePressedTimer),e.vars.actionRelease&&e.vars.actionRelease.execute()},onPress:function(t,s,n){e.fire("press",{x:t,y:s,event:n}),e.config["write-bool"]&&e.config.item&&e.writeValue(e.config["on-value"]),e.vars.actionPress&&e.vars.actionPress.execute(),e.vars.actionWhilePressed&&e.config["interval-while-pressed"]&&(e.vars.actionWhilePressedTimer&&clearInterval(e.vars.actionWhilePressedTimer),e.vars.actionWhilePressedTimer=setInterval((function(){e.vars.actionWhilePressed.execute()}),e.config["interval-while-pressed"]))}};e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.vars.imageEl,s)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.vars.imageEl,s))},onEnable:function(){this.vars.listeners.forEach((function(e){e.enable()})),shmi.log("[IQ:iq-image] Enabled",1)},onDisable:function(){var e=this;e.vars.listeners.forEach((function(e){e.disable()})),e.vars.actionWhilePressedTimer&&(clearInterval(e.vars.actionWhilePressedTimer),e.vars.actionWhilePressedTimer=null),shmi.log("[IQ:iq-image] disabled",1)},onLock:function(){var e=this;e.vars.listeners.forEach((function(e){e.disable()})),shmi.addClass(e.element,"locked"),e.vars.actionWhilePressedTimer&&(clearInterval(e.vars.actionWhilePressedTimer),e.vars.actionWhilePressedTimer=null),shmi.log("[IQ:iq-image] Locked",1)},onUnlock:function(){this.vars.listeners.forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked"),shmi.log("[IQ:iq-image] unlocked",1)}}};shmi.requires("visuals.tools.control-generator").generate(s)}(),function(){"use strict";var e="iq-input-field",t={"class-name":e,name:null,template:"default/iq-input-field.variant-01",label:"[Label]",item:null,"numeric-class":"numeric",min:Number.NEGATIVE_INFINITY,max:Number.POSITIVE_INFINITY,step:1,precision:-1,"decimal-delimiter":".",type:shmi.c("TYPE_STRING"),"unit-text":"[Unit]","auto-label":!0,"auto-unit-text":!0,"unit-scale":1,"auto-min":!0,"auto-max":!0,"auto-step":!0,"auto-precision":!0,"auto-type":!0,"numpad-enabled":!1,"show-icon":!1,"icon-src":null,"icon-class":null,tooltip:null,multiline:!1,notResizable:!1},s=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1);s.fLog,s.log;function setUnitTextImpl(e,t){e.vars.unitEl&&(""===t||null==t?(e.vars.unit="",e.vars.unitEl.textContent="",shmi.addClass(e.element,"no-unit")):(e.vars.unit=t,e.vars.unitEl.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-unit")))}function setLabelImpl(e,t){e.vars.labelEl&&(""===t||null==t?(e.vars.label="",e.vars.labelEl.textContent="",shmi.addClass(e.element,"no-label")):(e.vars.label=t,e.vars.labelEl.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-label")))}var n={className:"IqInputField",uiType:e,isContainer:!1,config:t,configSchema:null,vars:{listeners:[],value:null,active:!1,currentValueEl:null,labelEl:null,unitEl:null,iconEl:null,inputEl:null,textAreaEl:null,label:null,domListeners:[],subscriptionTargetId:null,toEnterTmr:0,wasClicked:!1,valueSettings:null,uiAction:null,focused:!1,locked:!1,floatRegexp:"(^[+-]?[0-9]([.][0-9]*)?$|^[+-]?[1-9]+[0-9]*([.][0-9]*)?$)",intRegexp:"(^[+-]?[0-9]$|^[+-]?[1-9]+[0-9]*$)",type:null},imports:{im:"visuals.session.ItemManager",nv:"visuals.tools.numericValues"},events:["change","enter"],prototypeExtensions:{onInit:function(){var e=this,t=shmi.Constants;if(e.vars.floatRegexp=new RegExp(e.vars.floatRegexp),e.vars.currentValueEl=shmi.getUiElement("input",e.element),e.vars.textareaEl=shmi.getUiElement("textarea",e.element),e.vars.labelEl=shmi.getUiElement("label",e.element),e.vars.unitEl=shmi.getUiElement("unit",e.element),e.vars.iconEl=shmi.getUiElement("icon",e.element),e.vars.currentValueEl&&e.vars.textareaEl){e.config.multiline?(e.vars.inputEl=e.vars.textareaEl,e.vars.currentValueEl.remove()):(e.vars.inputEl=e.vars.currentValueEl,e.vars.textareaEl.remove()),e.vars.inputEl.style.display="block",e.config.notResizable?shmi.addClass(e.element,"not-resizable"):shmi.removeClass(e.element,"not-resizable"),e.vars.inputEl.setAttribute("tabindex","0"),e.insertValue("");var s=parseInt(e.config.type);isNaN(s)||(e.vars.type=s),e.config.action&&(e.vars.uiAction=new shmi.visuals.core.UiAction(e.config.action,this)),e.config["auto-type"]||-1!==[t.TYPE_BOOL,t.TYPE_INT,t.TYPE_FLOAT].indexOf(e.vars.type)&&shmi.addClass(e.element,e.config["numeric-class"]);var n={onPress:function(t,s,n){e.vars.focused&&window.getSelection().removeAllRanges()},onClick:function(){e.vars.wasClicked=!0,e.handleFocus(),e.vars.wasClicked=!1}};if(e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.vars.inputEl,n)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.vars.inputEl,n)),e.vars.domListeners.push(e.createEventListener(e.vars.inputEl,"focus",(function(t){e.config.multiline?e.vars.focused=!0:e.vars.wasClicked||e.handleFocus()}))),e.vars.domListeners.push(e.createEventListener(e.vars.inputEl,"keypress",(function(t){(13===t.keyCode&&!e.config.multiline||9===t.keyCode)&&(t.preventDefault(),window.getSelection().removeAllRanges(),e.vars.currentValueEl.blur())}))),e.vars.domListeners.push(e.createEventListener(e.vars.inputEl,"keydown",(function(t){if(e.vars.type===shmi.c("TYPE_FLOAT")){var s="."===e.config["decimal-delimiter"]?",":".";t.key===s&&t.preventDefault()}}))),e.vars.domListeners.push(e.createEventListener(e.vars.inputEl,"blur",(function(t){e.vars.focused&&(shmi.log("[IQ:iq-input-field] blur event",1),window.getSelection().removeAllRanges(),e.validateAndSet(e.vars.inputEl),e.vars.focused=!1,shmi.visuals.session.FocusElement=null)}))),e.vars.iconEl)if(e.config["icon-src"]&&e.config["show-icon"])e.vars.iconEl.style.backgroundImage=`url(${e.config["icon-src"]})`;else if(e.config["icon-class"]&&e.config["show-icon"]){e.config["icon-class"].trim().split(" ").forEach((function(t){shmi.addClass(e.vars.iconEl,t)}))}else shmi.addClass(e.element,"no-icon");else shmi.log("[IQ:iq-input-field] no button-icon element provided",1);setUnitTextImpl(e,e.config["unit-text"]),e.config["unit-scale"]&&(e.config["unit-scale"]=parseFloat(shmi.localize(e.config["unit-scale"]))),setLabelImpl(e,e.config.label)}else shmi.log("[IQ:iq-input-field] no input and/or element in HTML",3)},onEnable:function(){var e=this;e.config.item&&(e.vars.subscriptionTargetId=e.imports.im.subscribeItem(e.config.item,e)),e.vars.inputEl.disabled=!1,e.enableAllListeners(),document.activeElement===e.vars.inputEl&&(e.vars.focused=!0),shmi.log("[IQ:iq-input-field] Enabled",1)},onDisable:function(){var e=this;e.config.item&&e.imports.im.unsubscribeItem(e.config.item,e.vars.subscriptionTargetId),e.disableAllListeners(),shmi.log("[IQ:iq-input-field] disabled",1)},onLock:function(){var e=this;e.vars.locked=!0,e.vars.inputEl.disabled=!0,shmi.addClass(e.element,"locked"),e.vars.inputEl.blur(),e.disableAllListeners(),shmi.log("[IQ:iq-input-field] Locked",1)},onUnlock:function(){var e=this;e.vars.locked=!1,e.vars.inputEl.disabled=!1,shmi.removeClass(e.element,"locked"),e.enableAllListeners(),shmi.log("[IQ:iq-input-field] unlocked",1)},onSetValue:function(e,t,s){var n=this,a=n.vars.value;n.vars.value=e,n.insertValue(n.imports.nv.formatOutput(n.vars.value,n)),document.activeElement===n.vars.inputEl&&n.selectContent(),shmi.log("[IQ:iq-input-field] new value: "+n.vars.value,0),n.vars.value!==a&&n.fire("change",{value:n.vars.value})},getValue:function(){var e=this,t=e.vars.type;return e.config.item&&e.config["auto-type"]&&(t=e.imports.im.items[e.config.item].type),t===shmi.c("TYPE_INT")?Math.round(e.vars.value/e.config["unit-scale"]):t===shmi.c("TYPE_FLOAT")?e.vars.value/e.config["unit-scale"]:e.vars.value},onSetProperties:function(e,t,s,n,a,l,o,r,c,u){var m=this,h=shmi.Constants;m.config["auto-type"]&&(m.vars.type=a,[h.TYPE_BOOL,h.TYPE_INT,h.TYPE_FLOAT].indexOf(a)&&shmi.addClass(m.element,m.config["numeric-class"])),m.imports.nv.setProperties(m,arguments)},setUnitText:function(e){var t=this;t.vars.unitEl&&t.config["auto-unit-text"]&&setUnitTextImpl(t,e)},setLabel:function(e){var t=this;t.vars.labelEl&&t.config["auto-label"]&&setLabelImpl(t,e)},updateValue:function(){this.config.item&&shmi.visuals.session.ItemManager.writeValue(this.config.item,this.vars.value)},insertValue:function(e){this.vars.inputEl.value=e},retrieveValue:function(){return this.vars.inputEl.value},selectContent:function(){this.vars.inputEl.select()},handleFocus:function(){var e=this;if(!e.vars.locked){if(e.vars.focused||null===shmi.visuals.session.FocusElement||(shmi.visuals.session.FocusElement.blur(),shmi.visuals.session.FocusElement=null),shmi.log("[IQ:iq-input-field] focused",1),e.vars.wasClicked){if(e.showNumpad())return;if(e.showKeyboard())return}else e.selectContent();e.vars.focused=!0,e.vars.inputEl.focus(),shmi.visuals.session.FocusElement=e.vars.inputEl,e.vars.toEnterTmr&&clearTimeout(e.vars.toEnterTmr),e.vars.toEnterTmr=setTimeout((function(){e.fire("enter",{value:e.vars.value})}),250)}},showNumpad:function(){const e=this,t=shmi.requires("visuals.tools.numericValues");return!!e.config["numpad-enabled"]&&(e.vars&&e.vars.valueSettings||t.initValueSettings(e),shmi.numpad({"decimal-delimiter":e.config["decimal-delimiter"],unit:e.vars.unitEl?e.vars.unitEl.textContent:e.config["unit-text"],label:e.vars.labelEl?e.vars.labelEl.textContent:e.config.label,value:e.retrieveValue(),callback:function(t){e.config.item?(e.config.multiline&&(t=t.toString()),e.imports.im.writeValue(e.config.item,t)):e.setValue(t)},min:e.vars.valueSettings.min,max:e.vars.valueSettings.max,type:e.vars.valueSettings.type,precision:e.vars.valueSettings.precision,item:"string"==typeof e.config.item&&e.config.item.length>0?e.config.item:null}),!0)},showKeyboard:function(){var e=this,t=shmi.requires("visuals.session.config");return!(!t.keyboard||!t.keyboard.enabled)&&(shmi.keyboard({value:e.retrieveValue(),"select-box-enabled":t.keyboard["language-selection"],"password-input":e.vars.currentValueEl&&e.vars.currentValueEl.type&&"password"===e.vars.currentValueEl.type.toLowerCase(),"show-enter":e.config.multiline,callback:function(t,s){t&&(e.config.item?e.imports.im.writeValue(e.config.item,s):e.setValue(s))}}),!0)},validateAndSet:function(){const e=this,t=e.retrieveValue(),s=e.vars.value;if(t===s)return;const n=e.config.multiline?t:[shmi.c("TYPE_INT"),shmi.c("TYPE_FLOAT")].includes(e.vars.type)?e.vars.floatRegexp.test(t.replace(e.config["decimal-delimiter"],"."))?e.imports.nv.applyInputSettings(t,e):s:t;e.vars.value=n,null==n?e.insertValue(""):e.insertValue(e.imports.nv.formatOutput(n,e)),n!==s&&(e.config.item&&e.imports.im.writeValue(e.config.item,n),e.vars.uiAction&&e.vars.uiAction.execute(n),e.fire("change",{value:e.vars.value}))},enableAllListeners:function(){this.vars.domListeners.forEach((function(e){e.element.addEventListener(e.event,e.callback)})),this.vars.listeners.forEach((function(e){e.enable()}))},disableAllListeners:function(){this.vars.domListeners.forEach((function(e){e.element.removeEventListener(e.event,e.callback)})),this.vars.listeners.forEach((function(e){e.disable()}))},createEventListener:function(e,t,s){return{event:t,callback:s,element:e}}}};shmi.requires("visuals.tools.control-generator").generate(n)}(),function(){"use strict";var e="iq-label",t={"class-name":"iq-label",name:null,template:"default/iq-label.variant-01",item:null,precision:-1,"decimal-delimiter":".",type:shmi.c("TYPE_INT"),"auto-precision":!0,"auto-type":!0,tooltip:null,options:[],pattern:null,"value-as-tooltip":!1,text:"${label.no-value}"},s=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),n=(s.fLog,s.log,{className:"iq-label",uiType:e,isContainer:!1,config:t,configSchema:null,vars:{value:0,active:!1,labelEl:null,rafId:null,subscriptionTargetId:null},imports:{im:"visuals.session.ItemManager",nv:"visuals.tools.numericValues"},events:[],prototypeExtensions:{onInit:function(){var e=this;e.imports.nv.initValueSettings(e),e.vars.labelEl=shmi.getUiElement("label",e.element),e.config.text&&e.updateText(shmi.localize(e.config.text))},onEnable:function(){var e=this;e.config.item&&(e.vars.subscriptionTargetId=e.imports.im.subscribeItem(e.config.item,e)),shmi.log("[IQ:iq-label] Enabled",1)},onDisable:function(){var e=this;e.vars.subscriptionTargetId&&e.imports.im.unsubscribeItem(e.config.item,e.vars.subscriptionTargetId),shmi.log("[IQ:iq-label] disabled",1)},getValue:function(){return this.vars.value},onSetProperties:function(e,t,s,n,a,l,o,r,c,u){this.imports.nv.setProperties(this,arguments)},onSetValue:function(e,t,s){var n=this;shmi.caf(n.vars.rafId),n.vars.rafId=shmi.raf((function(){var t=e;if(n.config.options.length){const s=n.config.options.find((t=>Number.isSafeInteger(e)&&Number.isSafeInteger(t.mask)&&Number.isSafeInteger(t.value)?(BigInt(e)&BigInt(t.mask))===BigInt(t.value):t.value===e));s&&(t=shmi.localize(s.label))}else t="string"==typeof n.config.pattern&&n.config.pattern.trim().length?shmi.localize(shmi.evalString(n.config.pattern,{VALUE:e})):n.imports.nv.formatOutput(e,n);n.updateText(t)}))},updateText:function(e){var t=this;t.vars.labelEl.textContent=e,t.config["value-as-tooltip"]&&t.setTooltip(e)},onLock:function(){shmi.addClass(this.element,"locked")},onUnlock:function(){shmi.removeClass(this.element,"locked")}}});shmi.requires("visuals.tools.control-generator").generate(n)}(),function(){"use strict";const e="iq-linear-gauge",t={"class-name":e,name:null,template:"default/iq-linear-gauge.variant-01",item:null,tooltip:null,type:shmi.c("TYPE_INT"),precision:0,min:Number.NEGATIVE_INFINITY,max:Number.POSITIVE_INFINITY,label:"[Label]","unit-text":"[Unit]","decimal-delimiter":".","default-value":"---","show-text":!0,"show-icon":!1,"icon-src":null,"icon-class":null,"auto-min":!0,"auto-max":!0,"auto-label":!0,"auto-unit-text":!0,"auto-precision":!0,"animation-duration":100,"fill-reverse":!1,"fill-inverse":!1},s=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1);s.fLog,s.log;function setLabelImpl(e,t){e.vars.dom.label&&(""!==t&&null!=t&&e.config["show-text"]?(e.vars.label=t,e.vars.dom.label.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-label")):(e.vars.label="",e.vars.dom.label.textContent="",shmi.addClass(e.element,"no-label")))}function setUnitTextImpl(e,t){e.vars.dom.unit&&(""!==t&&null!=t&&e.config["show-text"]?(e.vars.unit=t,e.vars.dom.unit.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-unit")):(e.vars.unit="",e.vars.dom.unit.textContent="",shmi.addClass(e.element,"no-unit")))}function updateWidgetBar(e,{actValue:t}){e.vars.dom.bar&&e.vars.dom.bar.style.setProperty("--internal-fill-level",100*function getFillPercentage(e,t){const{min:s,max:n}=e.vars.valueSettings,a=(t-s)/(n-s);return isNaN(a)||s===n?0:e.config["fill-inverse"]?1-Math.min(Math.max(a,0),1):Math.min(Math.max(a,0),1)}(e,t)+"%")}function updateWidgetText(e){e.vars.dom.value&&(null===e.getValue()?e.vars.dom.value.textContent=shmi.localize(e.config["default-value"]):e.vars.dom.value.textContent=e.imports.nv.formatOutput(e.getValue(),e))}function queueWidgetTextUpdate(e){e.vars.rafId||(e.vars.rafId=shmi.raf((()=>{updateWidgetText(e),e.vars.rafId=null})))}const n={className:"IqLinearGauge",uiType:e,isContainer:!1,config:t,configSchema:null,vars:{dom:{value:null,bar:null,unit:null,label:null,icon:null},valueSettings:{min:0,max:100},animationBundle:null,rafId:null,value:null,tokens:[]},imports:{im:"visuals.session.ItemManager",nv:"visuals.tools.numericValues",gfx:"visuals.gfx"},events:[],prototypeExtensions:{onInit:function(){const e=this;if(Object.assign(e.vars.dom,{value:shmi.getUiElement("value",e.element),bar:shmi.getUiElement("bar",e.element),unit:shmi.getUiElement("unit",e.element),label:shmi.getUiElement("label",e.element),icon:shmi.getUiElement("icon",e.element)}),e.imports.nv.initValueSettings(e),e.vars.dom.icon&&e.config["icon-src"]&&e.config["show-icon"])e.vars.dom.icon.style.backgroundImage=`url(${e.config["icon-src"]})`;else if(e.vars.dom.icon&&e.config["icon-class"]&&e.config["show-icon"]){e.config["icon-class"].trim().split(" ").forEach((t=>shmi.addClass(e.vars.dom.icon,t)))}else shmi.addClass(e.element,"no-icon");setUnitTextImpl(e,e.config["unit-text"]),e.config["unit-scale"]&&(e.config["unit-scale"]=parseFloat(shmi.localize(e.config["unit-scale"]))),setLabelImpl(e,e.config.label),e.vars.dom.bar&&e.config["fill-reverse"]&&shmi.addClass(e.vars.dom.bar,"reversed"),e.vars.animationBundle=new e.imports.gfx.AnimationBundle(updateWidgetBar.bind(null,e)),e.vars.animationBundle.prepare("actValue",null,"linear"),updateWidgetText(e)},onEnable:function(){const e=this;e.config.item&&e.vars.tokens.push(e.imports.im.subscribeItem(e.config.item,e))},onDisable:function(){const e=this;e.vars.rafId&&(shmi.caf(e.vars.rafId),e.vars.rafId=null),e.vars.tokens.forEach((e=>e.unlisten())),e.vars.tokens=[],e.vars.animationBundle.cancel("actValue")},onLock:function(){shmi.addClass(this.element,"locked")},onUnlock:function(){shmi.removeClass(this.element,"locked")},getValue:function(){return this.vars.value},onSetValue:function(e,t,s){const n=this,a=[shmi.c("TYPE_BOOL"),shmi.c("TYPE_INT"),shmi.c("TYPE_FLOAT")].includes(t)?e:Number.NaN;n.vars.value!==a&&(n.vars.value=a,n.vars.animationBundle.start(a,n.config["animation-duration"],"actValue"),queueWidgetTextUpdate(n))},onSetProperties:function(...e){const t=this;t.imports.nv.setProperties(t,e),t.vars.animationBundle.refresh(),queueWidgetTextUpdate(t)},setUnitText:function(e){const t=this;t.config["auto-unit-text"]&&setUnitTextImpl(t,e)},setLabel:function(e){const t=this;t.config["auto-label"]&&setLabelImpl(t,e)}}};shmi.requires("visuals.tools.control-generator").generate(n)}(),function(){"use strict";const e="iq-progress-info",t={"class-name":e,name:null,template:"default/iq-progress-info.variant-01",displayFormat:"($baseItem / $comparisonItem) - $percentValue%",baseItem:null,comparisonItem:null,tooltip:null,precision:-1,"decimal-delimiter":".","default-value":"---","auto-precision":!0,"animation-duration":100,"fill-reverse":!1,"fill-inverse":!1},s=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1);s.fLog,s.log;function updateWidgetText(e){e.vars.dom.value&&(null===e.getValue()||null===e.getComparisonValue()?(e.vars.dom.value.textContent=shmi.localize(e.config["default-value"]),e.vars.placeholders=null):(e.vars.placeholders||function setupValueElements(e,t){const{value:s}=e.vars.dom;s&&(s.innerHTML=t.replace(/[$]baseItem/g,'<span class="baseValue"></span>').replace(/[$]comparisonItem/g,'<span class="compareValue"></span>').replace(/[$]percentValue/g,'<span class="percentValue"></span>'),e.vars.placeholders={baseItem:Array.from(s.getElementsByClassName("baseValue")),comparisonItem:Array.from(s.getElementsByClassName("compareValue")),percentValue:Array.from(s.getElementsByClassName("percentValue"))})}(e,e.config.displayFormat),function setPlaceholderValues(e,t,s){const{nv:{formatOutput:n},iter:{iterateObject:a}}=e.imports,l={baseItem:n(t,e),comparisonItem:n(s,e),percentValue:Math.round(t/s*100)};e.vars.placeholders&&a(l,((t,s)=>{const n=e.vars.placeholders[s];Array.isArray(n)&&n.forEach((e=>e.textContent=t))}))}(e,e.getValue(),e.getComparisonValue())))}function updateWidgetBar(e,{baseValue:t,compValue:s}){const n=function getFillPercentage(e,t,s){const n=e/t;return isNaN(n)?0:s?1-Math.min(Math.max(n,0),1):Math.min(Math.max(n,0),1)}(t,s,e.config["fill-inverse"]);e.vars.dom.bar&&e.vars.dom.bar.style.setProperty("--internal-fill-level",100*n+"%")}function queueWidgetTextUpdate(e){!e.vars.rafId&&e.vars.dom.value&&(e.vars.rafId=shmi.raf((()=>{updateWidgetText(e),e.vars.rafId=null})))}const n={className:"IqProgressInfo",uiType:e,isContainer:!1,config:t,configSchema:null,vars:{dom:{value:null,bar:null,barContainer:null},placeholders:null,valueSettings:{min:0,max:100},animationBundle:null,rafId:null,value:null,valueComp:null,listeners:[],tokens:[]},imports:{im:"visuals.session.ItemManager",iter:"visuals.tools.iterate",nv:"visuals.tools.numericValues",gfx:"visuals.gfx"},events:[],prototypeExtensions:{onInit:function(){const e=this;Object.assign(e.vars.dom,{value:shmi.getUiElement("value",e.element),bar:shmi.getUiElement("bar",e.element),barContainer:shmi.getUiElement("bar-container",e.element)}),e.imports.nv.initValueSettings(e),e.vars.dom.bar&&(e.config["fill-reverse"]&&shmi.addClass(e.vars.dom.bar,"reversed"),e.vars.animationBundle=new e.imports.gfx.AnimationBundle(updateWidgetBar.bind(null,e)),e.vars.animationBundle.prepare("baseValue",null,"linear"),e.vars.animationBundle.prepare("compValue",null,"linear")),updateWidgetText(e)},onEnable:function(){const e=this;e.config.baseItem&&e.vars.tokens.push(e.imports.im.subscribeItem(e.config.baseItem,e)),e.config.comparisonItem&&e.vars.tokens.push(e.imports.im.subscribeItem(e.config.comparisonItem,{setValue:e.onSetCompValue.bind(e)}))},onDisable:function(){const e=this;e.vars.rafId&&(shmi.caf(e.vars.rafId),e.vars.rafId=null),e.vars.animationBundle&&(e.vars.animationBundle.cancel("baseValue"),e.vars.animationBundle.cancel("compValue")),e.vars.tokens.forEach((e=>e.unlisten())),e.vars.tokens=[]},onLock:function(){shmi.addClass(this.element,"locked")},onUnlock:function(){shmi.removeClass(this.element,"locked")},getValue:function(){return this.vars.value},getComparisonValue:function(){return this.vars.valueComp},onSetValue:function(e,t,s){const n=this,a=[shmi.c("TYPE_BOOL"),shmi.c("TYPE_INT"),shmi.c("TYPE_FLOAT")].includes(t)?e:Number.NaN;n.vars.value!==a&&(n.vars.value=a,n.vars.animationBundle&&n.vars.animationBundle.start(a,n.config["animation-duration"],"baseValue"),queueWidgetTextUpdate(n))},onSetCompValue:function(e,t){const s=this,n=[shmi.c("TYPE_BOOL"),shmi.c("TYPE_INT"),shmi.c("TYPE_FLOAT")].includes(t)?e:Number.NaN;s.vars.valueComp!==n&&(s.vars.valueComp=n,s.vars.animationBundle&&s.vars.animationBundle.start(n,s.config["animation-duration"],"compValue"),queueWidgetTextUpdate(s))},onSetProperties:function(...e){const t=this;t.imports.nv.setProperties(t,e),queueWidgetTextUpdate(t)}}};shmi.requires("visuals.tools.control-generator").generate(n)}(),function(){"use strict";const e="iq-quality-display",t={"class-name":e,name:null,template:"default/iq-quality-display.variant-01",item:null,"item-ctrl":null,tooltip:null,type:shmi.c("TYPE_INT"),precision:0,min:0,max:100,label:"[Label]","unit-text":"[Unit]","decimal-delimiter":".","default-value":"---","show-icon":!1,"show-text":!0,"icon-src":null,"icon-class":null,"auto-type":!0,"auto-min":!0,"auto-max":!0,"auto-label":!0,"auto-unit-text":!0,"auto-precision":!0,"animation-duration":100},s=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1);s.fLog,s.log;function setLabelImpl(e,t){e.vars.dom.label&&(""!==t&&null!=t&&e.config["show-text"]?(e.vars.label=t,e.vars.dom.label.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-label")):(e.vars.label="",e.vars.dom.label.textContent="",shmi.addClass(e.element,"no-label")))}function setUnitTextImpl(e,t){e.vars.dom.unit&&(""!==t&&null!=t&&e.config["show-text"]?(e.vars.unit=t,e.vars.dom.unit.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-unit")):(e.vars.unit="",e.vars.dom.unit.textContent="",shmi.addClass(e.element,"no-unit")))}function getFillPercentage(e,t){const{min:s,max:n}=e.vars.valueSettings,a=(t-s)/(n-s);return isNaN(a)||n===s?0:Math.min(Math.max(a,0),1)}function updateWidgetText(e){e.vars.dom.value&&(null===e.getValue()?e.vars.dom.value.textContent=shmi.localize(e.config["default-value"]):e.vars.dom.value.textContent=e.imports.nv.formatOutput(e.getValue(),e)),e.vars.dom.controlValue&&(null===e.getControlValue()?e.vars.dom.controlValue.textContent=shmi.localize(e.config["default-value"]):e.vars.dom.controlValue.textContent=e.imports.nv.formatOutput(e.getControlValue(),e))}function updateWidgetBars(e,{actValue:t,ctrlValue:s}){const n=getFillPercentage(e,t),a=getFillPercentage(e,s),{barContainer:l,indicator:o,controlValue:r}=e.vars.dom;if(l&&(l.style.setProperty("--internal-fill-level-set",100*a+"%"),l.style.setProperty("--internal-fill-level",100*n+"%")),o&&(o.style.setProperty("--internal-fill-level-set",100*a+"%"),o.style.setProperty("--internal-fill-level",100*n+"%")),l&&r){const e=l.getBoundingClientRect();r.style.setProperty("--internal-fill-level-set",100*a+"%"),r.style.setProperty("--internal-fill-level",100*n+"%"),r.style.setProperty("--internal-bar-offset-h",e.width*a+"px"),r.style.setProperty("--internal-bar-offset-v",e.height*(1-a)+"px")}}function queueWidgetTextUpdate(e){e.vars.rafId||(e.vars.rafId=shmi.raf((()=>{updateWidgetText(e),e.vars.rafId=null})))}const n={className:"IqQualityDisplay",uiType:e,isContainer:!1,config:t,configSchema:null,vars:{dom:{value:null,bar:null,barContainer:null,unit:null,label:null,icon:null,indicator:null,indicatorLine:null,controlValue:null},valueSettings:{min:0,max:100},animationBundle:null,rafId:null,value:null,valueCtrl:null,orientationInfo:null,listeners:[],tokens:[]},imports:{im:"visuals.session.ItemManager",nv:"visuals.tools.numericValues",gfx:"visuals.gfx"},events:[],prototypeExtensions:{onInit:function(){const e=this;if(Object.assign(e.vars.dom,{value:shmi.getUiElement("value",e.element),bar:shmi.getUiElement("bar",e.element),barContainer:shmi.getUiElement("bar-container",e.element),unit:shmi.getUiElement("unit",e.element),label:shmi.getUiElement("label",e.element),icon:shmi.getUiElement("icon",e.element),indicator:shmi.getUiElement("indicator",e.element),indicatorLine:shmi.getUiElement("indicator-line",e.element),controlValue:shmi.getUiElement("control-value",e.element)}),e.imports.nv.initValueSettings(e),e.vars.dom.icon&&e.config["icon-src"]&&e.config["show-icon"])e.vars.dom.icon.style.backgroundImage=`url(${e.config["icon-src"]})`;else if(e.vars.dom.icon&&e.config["icon-class"]&&e.config["show-icon"]){e.config["icon-class"].trim().split(" ").forEach((t=>shmi.addClass(e.vars.dom.icon,t)))}else shmi.addClass(e.element,"no-icon");setUnitTextImpl(e,e.config["unit-text"]),e.config["unit-scale"]&&(e.config["unit-scale"]=parseFloat(shmi.localize(e.config["unit-scale"]))),setLabelImpl(e,e.config.label),e.vars.dom.bar&&(e.vars.orientationInfo=function getFillProperties(e){if(!e.vars.dom.bar)return null;const t=getComputedStyle(e.vars.dom.bar),[s,n]=t.transformOrigin.replace("px","").split(" ").map(parseFloat),a=n<=parseFloat(t.height.replace("px",""))/2,l=0===s,o=0===n;return{orientation:a?"horizontal":"vertical",reverse:a?!o:!l,anchor:a?l?"left":"right":o?"top":"bottom"}}(e)),e.vars.animationBundle=new e.imports.gfx.AnimationBundle(updateWidgetBars.bind(null,e)),e.vars.animationBundle.prepare("actValue",null,"linear"),e.vars.animationBundle.prepare("ctrlValue",null,"linear"),updateWidgetText(e)},onEnable:function(){const e=this;e.vars.tokens.push(function makeUpdateToken(e,t){let s=!1;const throttledCallback=()=>{s=!1,Promise.resolve().then((()=>{s||(t(),s=!0)}))},n=window.ResizeObserver?new ResizeObserver(throttledCallback):null;return window.addEventListener("resize",throttledCallback),n&&e.vars.dom.barContainer&&n.observe(e.vars.dom.barContainer),{unlisten:()=>{window.removeEventListener("resize",throttledCallback),n&&e.vars.dom.barContainer&&n.unobserve(e.vars.dom.barContainer)}}}(e,(()=>{queueWidgetTextUpdate(e),e.vars.animationBundle.refresh()}))),e.config.item&&e.vars.tokens.push(e.imports.im.subscribeItem(e.config.item,e)),e.config["item-ctrl"]&&e.vars.tokens.push(e.imports.im.subscribeItem(e.config["item-ctrl"],{setValue:e.onSetCtrlValue.bind(e)}))},onDisable:function(){const e=this;e.vars.rafId&&(shmi.caf(e.vars.rafId),e.vars.rafId=null),e.vars.animationBundle.cancel("actValue"),e.vars.animationBundle.cancel("ctrlValue"),e.vars.tokens.forEach((e=>e.unlisten())),e.vars.tokens=[]},onLock:function(){shmi.addClass(this.element,"locked")},onUnlock:function(){shmi.removeClass(this.element,"locked")},getValue:function(){return this.vars.value},getControlValue:function(){return this.vars.valueCtrl},onSetValue:function(e,t,s){const n=this,a=[shmi.c("TYPE_BOOL"),shmi.c("TYPE_INT"),shmi.c("TYPE_FLOAT")].includes(t)?e:Number.NaN;n.vars.value!==a&&(n.vars.value=a,n.vars.animationBundle.start(a,n.config["animation-duration"],"actValue"),queueWidgetTextUpdate(n))},onSetCtrlValue:function(e,t){const s=this,n=[shmi.c("TYPE_BOOL"),shmi.c("TYPE_INT"),shmi.c("TYPE_FLOAT")].includes(t)?e:Number.NaN;s.vars.valueCtrl!==n&&(s.vars.valueCtrl=n,s.vars.animationBundle.start(n,s.config["animation-duration"],"ctrlValue"),queueWidgetTextUpdate(s))},onSetProperties:function(...e){const t=this;t.imports.nv.setProperties(t,e),t.vars.animationBundle.refresh(),queueWidgetTextUpdate(t)},setUnitText:function(e){const t=this;t.config["auto-unit-text"]&&setUnitTextImpl(t,e)},setLabel:function(e){const t=this;t.config["auto-label"]&&setLabelImpl(t,e)}}};shmi.requires("visuals.tools.control-generator").generate(n)}(),function(){"use strict";var e="iq-radial-gauge",t={"class-name":e,name:null,template:"default/iq-radial-gauge.variant-01",label:"[Label]",item:null,min:Number.NEGATIVE_INFINITY,max:Number.POSITIVE_INFINITY,step:1,precision:0,type:shmi.c("TYPE_INT"),"unit-text":"[Unit]","auto-label":!0,"auto-min":!0,"auto-max":!0,"auto-step":!0,"auto-precision":!0,"auto-type":!0,"show-icon":!1,"icon-src":null,"icon-class":null,tooltip:null,"animation-duration":100,"arc-fill-reverse":!1,"arc-fill-inverse":!1,"default-value":"---"};const s=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),n=(s.fLog,s.log,[{propName:"background",attribName:"color",conversion:"parseBackground"},{propName:"width",attribName:"lineWidth",conversion:"parseInt"},{propName:"box-shadow",attribName:["shadowColor","shadowOffsetX","shadowOffsetY","shadowBlur",null],conversion:"boxShadow"}]),a=[{propName:"color",attribName:"color",conversion:null},{propName:"font-size",attribName:"fontSize",conversion:"parseInt"},{propName:"font-family",attribName:"fontFamily",conversion:null},{propName:"font-weight",attribName:"fontWeight",conversion:null},{propName:"font-style",attribName:"fontStyle",conversion:null},{propName:"text-decoration",attribName:"textUnderline",conversion:"parseUnderline"}],l=[{propName:"top",attribName:"offsetVertical",conversion:"parsePercent"},{propName:"left",attribName:"offsetHorizontal",conversion:"parsePercent"},{propName:"offset-rotate",attribName:"rotation",conversion:"offsetRotate"}],o=[{"data-ui":"arc-bg",objName:"arcBackground",styleConfig:n},{"data-ui":"arc-fg",objName:"arcForeground",styleConfig:n.concat(l)},{"data-ui":"arc-slice",objName:"slice",styleConfig:[{propName:"width",attribName:"width",conversion:"parsePercent"}]},{"data-ui":"line-value",objName:"valueLine",styleConfig:n},{"data-ui":"value",objName:"value",styleConfig:a.concat(l)},{"data-ui":"label",objName:"label",styleConfig:a.concat(l)},{"data-ui":"unit",objName:"unit",styleConfig:a.concat(l)},{"data-ui":"icon-src",objName:"icon",styleConfig:[{propName:"width",attribName:"width",conversion:"parsePercent"},{propName:"height",attribName:"height",conversion:"parsePercent"}].concat(l)},{"data-ui":"icon-class",objName:"iconClass",styleConfig:a}],r={identity:e=>[e],parseInt:e=>{const t=parseInt(e);return isNaN(t)?null:[t]},parsePercent:e=>{if("0px"===e)return[0];if(!e.endsWith("%"))return null;const t=parseFloat(e.substr(0,e.length-1));return isNaN(t)?null:[t/100]},boxShadow:e=>{if("none"===e)return[0,0,0,0,"transparent"];const t=e.match(/^(rgba?\([-\d.,\s]+\))\s+(-?[0-9]+(?:\.[0-9]+)?)px\s+(-?[0-9]+(?:\.[0-9]+)?)px\s+(-?[0-9]+(?:\.[0-9]+)?)px\s+(-?[0-9]+(?:\.[0-9]+)?)px$/);return t?[t[1],t[2],t[3],t[4],t[5]]:null},offsetRotate:e=>{const t=e.match(/^(?:auto\s+)?(-?[0-9]+(?:\.[0-9]+)?)deg$/);return t?[Math.PI*parseFloat(t[1])/180]:null},parseBackground:e=>{const t=/^(rgba?\([-\d.,\s]+\))/,s=e.match(/(linear-gradient|radial-gradient)\((?:([^,]+), )?((?:rgba?\([-\d.,\s]+\)(?: [-\d.]+(%|px)?)?(?:, )?)+)\)/);if(!s){const s=e.match(t);return s?[{type:"color",color:s[1]}]:[null]}const[,n,a,l]=s,o=Array.from(l.matchAll(/(rgba?\([-\d.,\s]+\))(?: ([-\d.]+)(%|px)?)?(?:, )?/g));switch(n){case"linear-gradient":return[{type:n,rotation:void 0===a?Math.PI:parseFloat(a.substr(0,a.length-3))/180*Math.PI||0,steps:o.map((([,e,t])=>({color:e,step:parseInt(t)/100})))}];case"radial-gradient":return[{type:n,steps:o.map((([,e,t])=>({color:e,step:parseInt(t)/100})))}];default:return[null]}},parseUnderline:e=>[e.includes("underline")]};function calculateTextMeasurement(e,{fontSize:t,fontFamily:s,fontWeight:n,fontStyle:a},l){const o=e.vars.canvasObj;return o.font=`${a} ${n} ${t*(window.devicePixelRatio||1)}px ${s}`,o.measureText(l)}function computeNormalizedGaugeBoundingBox(e,t){const s=(2*Math.PI-t)/2,n=e+s,a=e+s+t,l=[{x:Math.cos(n),y:Math.sin(n),theta:n},{x:Math.cos(a),y:Math.sin(a),theta:a}];for(let e=Math.ceil(2*n/Math.PI);e<=Math.floor(2*a/Math.PI);++e){const t=e*Math.PI/2;l.push({x:Math.cos(t),y:Math.sin(t),theta:t})}return l.reduce(((e,t)=>({top:Math.min(e.top,t.y),left:Math.min(e.left,t.x),bottom:Math.max(e.bottom,t.y),right:Math.max(e.right,t.x),centerX:e.centerX,centerY:e.centerY,width:e.width,height:e.height})),{top:1,left:1,bottom:-1,right:-1,centerX:0,centerY:0,width:2,height:2})}function translateGaugeBoundingBox(e,t,s){const n=(()=>{const n=(e.bottom-e.top)/e.height,a=(e.right-e.left)/e.width,l=a/n,o=n/a;return e.right-e.left>e.bottom-e.top?Math.min(l*s,t):Math.min(o*t,s)})(),computeSize=(t,s,n)=>(t-s)/Math.max(e.right-e.left,e.bottom-e.top)*n,a=computeSize(e.right,e.left,n),l=computeSize(e.bottom,e.top,n);return{top:(s-l)/2,left:(t-a)/2,bottom:(s+l)/2,right:(t+a)/2,centerY:computeSize(e.centerY,e.top,n)+(s-l)/2,centerX:computeSize(e.centerX,e.left,n)+(t-a)/2,height:l,width:a,radius:computeSize(1,0,n)}}function invalidateTextMeasurements(e){e.vars.cache||(e.vars.cache={}),e.vars.cache.textMeasurement=null}function invalidateFillStyles(e){e.vars.cache||(e.vars.cache={}),e.vars.cache.fillStyles=null}function haveStylesChanged(e){return!e.vars.cache||!e.vars.cache.hasStyles}function checkCache(e){e.vars.cache||(e.vars.cache={}),e.vars.cache.textMeasurement||(e.vars.cache.textMeasurement=function calculateTextMeasurements(e){return{value:calculateTextMeasurement(e,e.vars.styles.value,e.vars.valueFormatted),valueLineHeight:calculateTextMeasurement(e,e.vars.styles.value,`-0${e.config["decimal-delimiter"]}123456789`),unit:calculateTextMeasurement(e,e.vars.styles.unit,e.vars.unitLocalized),label:calculateTextMeasurement(e,e.vars.styles.label,e.vars.labelLocalized)}}(e))}function getIconData(e,t,s){return e.vars.cache||(e.vars.cache={}),e.vars.cache.iconData&&e.vars.cache.iconData.drawWidth===t&&e.vars.cache.iconData.drawHeight===s||(e.vars.cache.iconData=function calculateIconData(e,t,s){if(!e.vars.iconEl)return{type:"none",height:s};if("IMG"===e.vars.iconEl.nodeName){const n=e.vars.iconEl.width/e.vars.iconEl.height;return{type:"image",src:e.vars.iconEl.src,element:e.vars.iconEl,ready:e.vars.iconEl.complete,width:Math.min(n*s,t),height:Math.min(t/n,s),drawWidth:t,drawHeight:s}}if("DIV"!==e.vars.iconEl.nodeName)return{type:"invalid",drawWidth:t,drawHeight:s};const n=getComputedStyle(e.vars.iconEl,":before");return n?{type:"icon-font",str:n.content,fontFamily:n.fontFamily,measurement:calculateTextMeasurement(e,{fontSize:s,fontFamily:n.fontFamily,fontWeight:400,fontStyle:"normal"},n.content),drawWidth:t,drawHeight:s}:{type:"invalid",drawWidth:t,drawHeight:s}}(e,t,s)),e.vars.cache.iconData}function getTextPosition(e,t,s,n,a){return{x:Math.floor((e-n.width)*s.x+.5),y:Math.floor(t*s.y+(a||n.actualBoundingBoxAscent)*(1-s.y)+.5)}}function positionFromStyle(e){return{x:e.offsetHorizontal,y:e.offsetVertical}}function makeFillStyle(e,t,s,n,a,l){if("string"==typeof l)return l;if(null===l)return null;switch(l.type){case"color":return l.color;case"linear-gradient":{const o=Math.max(1,...l.steps.map((({step:e})=>e))),r=function rotateBox({x0:e,y0:t,x1:s,y1:n},a){a-=.75*Math.PI;const l=(e-s)/2,o=(t-n)/2,r=(s-e)/2,c=(n-t)/2;return{x0:l*Math.cos(a)-o*Math.sin(a)+(s+e)/2,y0:l*Math.sin(a)+o*Math.cos(a)+(n+t)/2,x1:r*Math.cos(a)-c*Math.sin(a)+(s+e)/2,y1:r*Math.sin(a)+c*Math.cos(a)+(n+t)/2}}({x0:t-n*(o-1),y0:s-a*(o-1),x1:t+n*o,y1:s+a*o},l.rotation),c=e.createLinearGradient(r.x0,r.y0,r.x1,r.y1);return l.steps.forEach((({color:e,step:t})=>c.addColorStop(t/o,e))),c}case"radial-gradient":{const o=Math.max(1,...l.steps.map((({step:e})=>e))),r=e.createRadialGradient(t+n/2,s+a/2,0,t+n/2,s+a/2,Math.max(n,a)*o/2);return l.steps.forEach((({color:e,step:t})=>r.addColorStop(t/o,e))),r}default:return null}}function cacheFillStyle(e,t,s,n,a,l,o){e.vars.cache||(e.vars.cache={}),e.vars.cache.fillStyles||(e.vars.cache.fillStyles={}),e.vars.cache.fillStyles[t]||(e.vars.cache.fillStyles[t]=makeFillStyle(s,n,a,l,o,e.vars.styles[t].color))}function drawText(e,t,s,n,a,l,o,r,c,u,m,h,d,f){const v=getTextPosition(t,s,c,m,d),g=Math.max(1,Math.floor(n*r/15)),p=1.5*g;e.beginPath(),e.shadowBlur=0,e.fillStyle=h,e.font=`${o} ${l} ${n*r}px ${a}`,e.fillText(u,v.x,v.y),e.stroke(),f&&(e.beginPath(),e.strokeStyle=e.fillStyle,e.lineWidth=g,e.moveTo(v.x,v.y+p),e.lineTo(v.x+m.width,v.y+p),e.stroke())}function applyShadowStyles(e,t,s){e.shadowBlur=t.shadowBlur*s,e.shadowColor=t.shadowColor,e.shadowOffsetX=t.shadowOffsetX*s,e.shadowOffsetY=t.shadowOffsetY*s}function drawGauge(e,t,s,n,a,l,o,r,c){const u=(2*Math.PI-o)/2,m=e.vars.styles.arcBackground.lineWidth*r,h=e.vars.styles.arcBackground.shadowBlur*r,d=e.vars.styles.arcForeground.lineWidth*r,f=e.vars.styles.arcForeground.shadowBlur*r,v=e.vars.styles.valueLine.lineWidth*r,g=function getBoundingBox(e,t,s,n,a){return e.vars.cache||(e.vars.cache={}),e.vars.cache.boundingBox&&e.vars.cache.boundingBox.width===t&&e.vars.cache.boundingBox.height===s&&e.vars.cache.boundingBox.arcRotation===n&&e.vars.cache.boundingBox.arcAngle===a||(e.vars.cache.boundingBox={width:t,height:s,arcRotation:n,arcAngle:a,boundingBox:translateGaugeBoundingBox(computeNormalizedGaugeBoundingBox(n,a),t,s)}),e.vars.cache.boundingBox.boundingBox}(e,n,a,l,o),p=g.radius-Math.max(m,d)/2-h,b=g.radius-Math.max(m,d)/2-f,y=m-d,E=Math.max(0,Math.atan(y/b)),C=Math.max(0,Math.atan(-y/b)),x=function getGaugeOffset(e,t,s,n){return{x:(e-n.width)*(s.x-.5),y:(t-n.height)*(s.y-.5)}}(n,a,positionFromStyle(e.vars.styles.arcForeground),g);if(p<0||b<0)return;checkCache(e),cacheFillStyle(e,"arcBackground",t,g.left+x.x,g.top+x.y,g.right-g.left,g.bottom-g.top),cacheFillStyle(e,"arcForeground",t,g.left+x.x,g.top+x.y,g.right-g.left,g.bottom-g.top),t.clearRect(0,0,n,a),t.beginPath(),t.lineWidth=m,t.strokeStyle=e.vars.cache.fillStyles.arcBackground,applyShadowStyles(t,e.vars.styles.arcBackground,r),t.arc(g.centerX+x.x,g.centerY+x.y,p,l+u+C/2,o+l+u-C/2),t.stroke(),t.beginPath();const T=c?(o-E)*(1-s)+l+u+E/2:l+u+E/2,w=c?l-u+E/2:(o-E)*s+l+u+E/2;t.lineWidth=d,t.strokeStyle=e.vars.cache.fillStyles.arcForeground,applyShadowStyles(t,e.vars.styles.arcForeground,r),t.arc(g.centerX+x.x,g.centerY+x.y,b,T,w),t.stroke(),function drawIcon(e,t,s,n,a,l,o){if("image"===t.type)e.drawImage(t.element,(s-t.width)*a.x,(n-t.height)*a.y,t.width,t.height);else if("icon-font"===t.type){const r=getTextPosition(s,n,a,t.measurement);drawText(e,s,r.x,r.y,t.fontFamily,"normal","normal",l,a,t.str,t.measurement,o)}}(t,getIconData(e,n*e.vars.styles.icon.width,a*e.vars.styles.icon.height),n,a,positionFromStyle(e.vars.styles.icon),r,e.vars.styles.iconClass.color);const k=e.vars.styles.value,I=e.vars.cache.textMeasurement.value,S=e.vars.cache.textMeasurement.valueLineHeight.actualBoundingBoxAscent;t.beginPath();const L=getTextPosition(n,a,positionFromStyle(e.vars.styles.value),I,S),D={x0:L.x,y0:L.y+Math.floor(L.y+I.actualBoundingBoxAscent/4)+v/2,x1:L.x+I.width,y1:L.y+Math.floor(L.y+I.actualBoundingBoxAscent/4)+v/2};if(t.lineWidth=v,t.strokeStyle=makeFillStyle(t,D.x0,D.y0,D.x1-D.x0,D.y1-D.y0,e.vars.styles.valueLine.color),applyShadowStyles(t,e.vars.styles.valueLine,r),t.moveTo(D.x0,D.y0),t.lineTo(D.x1,D.y1),t.stroke(),drawText(t,n,a,k.fontSize,k.fontFamily,k.fontWeight,k.fontStyle,r,positionFromStyle(e.vars.styles.value),e.vars.valueFormatted,I,k.color,S,k.textUnderline),e.vars.unitLocalized){const s=e.vars.styles.unit,l=e.vars.cache.textMeasurement.unit;drawText(t,n,a,s.fontSize,s.fontFamily,s.fontWeight,s.fontStyle,r,positionFromStyle(e.vars.styles.unit),e.vars.unitLocalized,l,s.color,null,s.textUnderline)}if(e.vars.labelLocalized){const s=e.vars.styles.label,l=e.vars.cache.textMeasurement.label;drawText(t,n,a,s.fontSize,s.fontFamily,s.fontWeight,s.fontStyle,r,positionFromStyle(e.vars.styles.label),e.vars.labelLocalized,l,s.color,null,s.textUnderline)}}function updateCanvasResolution(e){const{clientWidth:t,clientHeight:s}=e.element,n=window.devicePixelRatio||1;e.vars.canvasEl.width!==e.vars.canvasEl.clientWidth*n&&(e.vars.canvasEl.width=e.vars.canvasEl.clientWidth*n),e.vars.canvasEl.height!==e.vars.canvasEl.clientHeight*n&&(e.vars.canvasEl.height=e.vars.canvasEl.clientHeight*n),e.vars.cache.display={devicePixelRatio:n,widgetWidth:t,widgetHeight:s}}function isReady(e){return!!e.vars.canvasObj}function startDrawing(e){return e.vars.animationFrameToken?null:shmi.raf((t=>{if(!isReady(e))return;const s=window.devicePixelRatio||1,{min:n,max:a}=e.vars.valueSettings,l=e.vars.canvasObj;if(null===e.vars.animationTimestamp||null===e.vars.animationValueStep||0===e.vars.animationValueStep)e.vars.animationValue=e.vars.value;else{const s=e.vars.animationValueStep*(t-e.vars.animationTimestamp);e.vars.hasChanged=!0,Math.abs(Math.abs(e.vars.animationValue)-Math.abs(e.vars.value))<Math.abs(s)?(e.vars.animationValue=e.vars.value,e.vars.animationValueStep=null):e.vars.animationValue=e.vars.animationValue+s}e.vars.animationTimestamp=t,!function haveDisplayPropertiesChanged(e){if(!e.vars.cache)return!0;if(!e.vars.cache.display)return!0;const t=e.vars.cache.display,s={devicePixelRatio:window.devicePixelRatio||1,widgetWidth:e.element.clientWidth,widgetHeight:e.element.clientHeight};return Object.keys(s).some((e=>s[e]!==t[e]))}(e)?haveStylesChanged(e)?(invalidateFillStyles(e),e.setupStylesFromCss(),e.vars.hasChanged=!0):e.vars.forceRedraw&&(e.vars.hasChanged=!0,e.vars.forceRedraw=!1):(invalidateTextMeasurements(e),function invalidateGaugeBoundingBox(e){e.vars.cache||(e.vars.cache={}),e.vars.cache.boundingBox=null}(e),invalidateFillStyles(e),haveStylesChanged(e)&&e.setupStylesFromCss(),updateCanvasResolution(e),e.vars.hasChanged=!0);const o=Math.min(1,Math.max((e.vars.animationValue-n)/(a-n),0));if(e.vars.elementIsInViewport&&e.vars.hasChanged){const t=e.config["arc-fill-inverse"]?1-o:o,n=2*Math.PI*(1-e.vars.styles.slice.width);drawGauge(e,l,t,e.vars.canvasEl.width,e.vars.canvasEl.height,e.vars.styles.arcForeground.rotation,n,s,e.config["arc-fill-reverse"]),e.vars.hasChanged=!1}e.vars.animationFrameToken=null,e.vars.animationFrameToken=startDrawing(e)}))}function makeDomEventListener(e,t,s){return{enable:e.addEventListener.bind(e,t,s),disable:e.removeEventListener.bind(e,t,s)}}var c={className:"IqRadialGauge",uiType:e,isContainer:!1,config:t,configSchema:null,vars:{listeners:[],value:null,valueFormatted:null,active:!1,hasChanged:!1,forceRedraw:!1,cache:{},valueSettings:null,canvasEl:null,styleHolderEl:null,iconEl:null,canvasObj:null,intersectionObserver:null,mutationObserver:null,elementIsInViewport:null,unit:null,unitLocalized:null,label:null,labelLocalized:null,animationFrameToken:null,animationValue:0,animationValueStep:null,animationTimestamp:null,styles:{arcBackground:{lineWidth:5,color:"#dddddd",shadowBlur:0},arcForeground:{lineWidth:5,offsetVertical:.5,offsetHorizontal:.5,rotation:Math.PI/2,shadowBlur:0,shadowColor:"rgba(180, 200, 59, 1)",color:"rgba(180, 200, 59, 1)"},slice:{width:276/360},valueLine:{lineWidth:1,shadowBlur:0,shadowColor:"rgba(60, 60, 60, 0.1)",color:"rgba(60, 60, 60, 0.1)"},value:{offsetVertical:.5,offsetHorizontal:.5,fontSize:36,fontFamily:"RobotoBold",color:"#7c7c7c"},label:{offsetVertical:.95,offsetHorizontal:.5,fontSize:14,fontFamily:"RobotoLight",color:"#7c7c7c"},unit:{offsetVertical:.32,offsetHorizontal:.5,fontSize:18,fontFamily:"RobotoLight",color:"#7c7c7c"},icon:{width:1/6,height:1/6,offsetVertical:.1,offsetHorizontal:.5},iconClass:{color:"black"}}},imports:{im:"visuals.session.ItemManager",nv:"visuals.tools.numericValues"},events:[],prototypeExtensions:{onInit:function(){const e=this;if(e.vars.canvasEl=shmi.getUiElement("gauge-canvas",e.element),!e.vars.canvasEl)return void e.log("Canvas element is missing!",3);if(e.vars.styleHolderEl=shmi.getUiElement("style-holder",e.element),!e.vars.styleHolderEl)return void e.log("Style Holder element is missing!",3);if(e.config["show-icon"]){if(e.config["icon-src"]){const t=document.createElement("img");t.src=e.config["icon-src"],e.vars.iconEl=t,e.vars.listeners.push(makeDomEventListener(t,"load",(()=>{!function invalidateIconData(e){e.vars.cache||(e.vars.cache={}),e.vars.cache.iconData=null}(e),e.vars.forceRedraw=!0}))),e.vars.styleHolderEl.appendChild(t)}else if(e.config["icon-class"]){const t=document.createElement("div");["icon"].concat(e.config["icon-class"].split(" ")).forEach((e=>shmi.addClass(t,e))),e.vars.iconEl=t,e.vars.styleHolderEl.appendChild(t)}}else;e.setupStylesFromCss(),e.vars.canvasObj=e.vars.canvasEl.getContext("2d"),e.vars.intersectionObserver=new IntersectionObserver((t=>{t.length>1&&t.sort(((e,t)=>t.time-e.time)),e.vars.elementIsInViewport=t[0].isIntersecting})),e.vars.mutationObserver=new MutationObserver((t=>function invalidateStyles(e){e.vars.cache||(e.vars.cache={}),e.vars.cache.hasStyles=!1}(e))),e.imports.nv.initValueSettings(e),"string"==typeof e.config["unit-text"]?(e.vars.unit=e.config["unit-text"],e.vars.unitLocalized=shmi.localize(e.config["unit-text"])):e.vars.unitLocalized="","string"==typeof e.config.label?(e.vars.label=e.config.label,e.vars.labelLocalized=shmi.localize(e.config.label)):e.vars.labelLocalized="",e.vars.valueFormatted=shmi.localize(e.config["default-value"]),updateCanvasResolution(e);const t=2*Math.PI*(1-e.vars.styles.slice.width);drawGauge(e,e.vars.canvasObj,0,e.vars.canvasEl.width,e.vars.canvasEl.height,e.vars.styles.arcForeground.rotation,t,window.devicePixelRatio||1)},onEnable:function(){const e=this;isReady(e)&&(e.vars.intersectionObserver.observe(e.vars.canvasEl),e.vars.mutationObserver.observe(e.element,{attributes:!0,attributeFilter:["style","class"]}),e.vars.listeners.push(makeDomEventListener(window,"resize",(()=>{e.vars.cache=null}))),checkCache(e),startDrawing(e),e.config.item&&(e.vars.subscriptionTargetId=e.imports.im.subscribeItem(e.config.item,e)),e.vars.listeners.forEach((e=>e.enable())),e.log("Enabled",1))},onDisable:function(){const e=this;isReady(e)&&(e.vars.listeners.forEach((e=>e.disable())),function stopDrawing(e){e.vars.animationFrameToken&&(shmi.caf(e.vars.animationFrameToken),e.vars.animationFrameToken=null)}(e),e.vars.intersectionObserver.disconnect(e.vars.canvasEl),e.vars.mutationObserver.disconnect(e.element),e.config.item&&e.imports.im.unsubscribeItem(e.config.item,e.vars.subscriptionTargetId),e.log("Disabled",1))},onLock:function(){isReady(this)&&(shmi.addClass(this.element,"locked"),this.log("Locked",1))},onUnlock:function(){const e=this;isReady(e)&&(shmi.removeClass(e.element,"locked"),e.log("Unlocked",1))},onSetValue:function(e,t,s){const n=this;n.vars.value=e,n.vars.valueFormatted=n.imports.nv.formatOutput(n.vars.value,n),invalidateTextMeasurements(n),function startAnimation(e,t,s=250){e.vars.animationValueStep=s>0?(t-e.vars.animationValue)/s:t-e.vars.animationValue}(n,e,parseInt(n.config["animation-duration"])||0),n.vars.hasChanged=!0},getValue:function(){return this.vars.value},onSetProperties:function(e,t,s,n,a,l,o,r,c,u){const m=this;m.imports.nv.setProperties(m,arguments),m.vars.min=e,m.vars.max=t,invalidateTextMeasurements(m),m.vars.hasChanged=!0},setUnitText:function(e){const t=this;t.config["auto-unit-text"]&&(t.vars.unit=e,t.vars.unitLocalized=shmi.localize(e))},setLabel:function(e){const t=this;t.config["auto-label"]&&(t.vars.label=e,t.vars.labelLocalized=shmi.localize(e))},log:function(e,t){shmi.log("[IQ:iq-radial-gauge] "+e,t)},setupStylesFromCss:function(){const e=this;o.forEach((function(t){const s=shmi.getUiElement(t["data-ui"],e.vars.styleHolderEl);if(s){const n=getComputedStyle(s);n&&t.styleConfig.forEach((function(s){!function setStyleFromCss(e,t,s,n,a,l){const o=r[l||"identity"];if(!t||!o)return;const c="background"===s?"none"===t.getPropertyValue("background-image")?t.getPropertyValue("background-color"):t.getPropertyValue("background-image"):t.getPropertyValue(s);if(!c)return;const u=o(c);u&&(Array.isArray(a)||(a=[a]),u.forEach(((t,s)=>{a[s]&&(e.vars.styles[n][a[s]]=t)})))}(e,n,s.propName,t.objName,s.attribName,s.conversion)}))}})),e.vars.cache||(e.vars.cache={}),e.vars.cache.hasStyles=!0}}};shmi.requires("visuals.tools.control-generator").generate(c)}(),function(){"use strict";const e="iq-recipe-list",t="iq-recipe-list",s={"class-name":e,name:null,template:"default/iq-recipe-list",label:t,"recipe-template-id":null},n=shmi.requires("visuals.tools.logging").createLogger(t,!0,!1),a=n.fLog;n.log;function eventProxy(e,t){e.fire(t.type,t.detail)}function doSetValue(e,t){const s={selRowIndex:[],selRows:[],type:-1};for(let n=0;n<t.vars.dataGrid.getRowCount();n++){const a=t.vars.dataGrid.getRowData(n);a[0].value===parseInt(e)&&(s.selRowIndex=[a[0].value],s.selRows=[n],s.type=2)}t.vars.ct.setSelectedRows(s)}const l={className:e,uiType:t,isContainer:!0,config:s,configSchema:null,vars:{domChild:null,dataGridId:null,dataGrid:null,dataGridSubscriptionId:null,ct:null,eventProxy:null,tokens:[],recipeTableConfig:{label:"${recipe-list.title}",table:"",name:"","class-name":"complex-table2","field-datagrid-col-map":{id:0,name:1},"select-mode":"SINGLE","default-field-control-map":{id:{"ui-type":"iq-label",config:{"class-name":"iq-label",template:"default/iq-label.iq-variant-01",options:[],pattern:"<%= VALUE %>","value-as-tooltip":!0}},name:{"ui-type":"iq-label",config:{"class-name":"iq-label",template:"default/iq-label.iq-variant-01",options:[],pattern:null,"value-as-tooltip":!0}}},"default-field-headers":{id:"${recipe-list.table-header.id}",name:"${recipe-list.table-header.name}"},_comment:"expr is passed to expr parameter array of shmi.visuals.core.DataGridManager.setFilter",filters:[],"default-layout":{"class-name":"layout-std",_comment:"default == no additional css layout class","column-org":{col1:{fields:["id"],"column-width":"15%"},col2:{fields:["name"],"column-width":"85%"}}},"sortable-fields":["name","id"],quicksearch:{enable:!0,remember:!0,fields:["name"]},"text-mode":"SINGLELINE","show-nof-rows":!0,"v-scroll-options":["SCROLLBAR","V_SWIPE"]}},imports:{dgm:"visuals.session.DataGridManager"},events:["select"],prototypeExtensions:{onInit:function(){if("number"!=typeof this.config["recipe-template-id"])return this.element.textContent="Invalid or no recipe template id given. This control will not work. Please select a valid recipe template id.",void a("Invalid or no recipe template id given:",this.config["recipe-template-id"]);if(this.vars.domChild=shmi.getUiElement("table-container",this.element),null===this.vars.domChild)return this.element.textContent="One or more required DOM elements are missing from the template. This control will not work. Please select a compatible template.",void a("Some DOM elements are missing from the template.");do{this.vars.dataGridId=e+"-"+Math.random().toString(36).substr(2,9)}while(null!==this.imports.dgm.getGrid(this.vars.dataGridId));this.imports.dgm.grids[this.vars.dataGridId]=this.vars.dataGrid=new shmi.visuals.core.DataGridRecipe(this.vars.dataGridId,this.config["recipe-template-id"]),this.vars.dataGrid.init(),this.vars.dataGrid.sort(1,"ASC")},rebuildTable:function(){const e=shmi.cloneObject(this.vars.recipeTableConfig);e.table=this.vars.dataGridId,e.name=this.vars.dataGridId,this.vars.dataGrid.sort(1,"ASC"),this.vars.eventProxy&&(this.vars.eventProxy.unlisten(),this.vars.eventProxy=null),this.vars.ct&&shmi.deleteControl(this.vars.ct),this.vars.ct=shmi.createControl("complex-table2",this.vars.domChild,e),null===this.vars.ct?(this.element.textContent="Unable to create table control for recipes. This control will not work.",a("Unable to create table control for recipes.")):this.vars.eventProxy=this.vars.ct.listen("select",eventProxy.bind(null,this))},getValue:function(){if(this.vars.ct){const e=this.vars.ct.getSelectionRowData(this.vars.ct.getSelectedRows());if(e.length>0)return{name:e[0][1].value,recipe_id:isNaN(e[0][0].value)?null:e[0][0].value,template_id:this.config["recipe-template-id"],values_set:1===e[0][3].value}}return null},setValue:function(e){!function checkIfSetValue(e,t){if(t.vars.dataGrid&&t.vars.ct)if(t.vars.dataGrid.tasksRunning>0){const s=shmi.listen("datagrid-ready",function(){s.unlisten(),doSetValue(e,t)}.bind(e,t))}else doSetValue(e,t)}(e,this)},refreshGrid:function(){this.vars.dataGrid&&this.vars.dataGrid.refresh()},onEnable:function(){this.vars.dataGrid&&this.rebuildTable()},onDisable:function(){this.vars.ct&&this.vars.ct.disable(),this.vars.eventProxy&&(this.vars.eventProxy.unlisten(),this.vars.eventProxy=null)},onDelete:function(){this.vars.ct&&shmi.deleteControl(this.vars.ct),this.vars.dataGrid&&delete this.imports.dgm.grids[this.vars.dataGridId],this.vars.tokens.forEach((e=>{e.unlisten()}))},onLock:function(){this.vars.ct&&this.vars.ct.lock()},onUnlock:function(){this.vars.ct&&this.vars.ct.unlock()},getSelectedRecipe:function(){return this.vars.ct?this.vars.ct.getSelectionRowData(this.vars.ct.getSelectedRows()):null},getTemplate:function(){return this.config["recipe-template-id"]}}};shmi.requires("visuals.tools.control-generator").generate(l)}(),function(){"use strict";const e="IqResponsiveMenu",t="iq-responsive-menu",s={"class-name":t,name:null,template:`default/${t}`,menu:[],"mobile-layouts":[],"overlay-style":{background:"transparent",zIndex:1}},n=shmi.requires("visuals.tools.logging").createLogger(t,!0,!1),a=(n.fLog,n.log,"pics/system/icons/placeholder.svg");function createListener(e,t){const s=shmi.requires("visuals.io"),n=new s.MouseListener(e,t),a=new s.TouchListener(e,t);return{enable:function(){n.enable(),a.enable()},disable:function(){n.disable(),a.disable()}}}function makeElement(e,t,s="DIV"){const n=document.createElement(s||"DIV");return"string"==typeof e?shmi.addClass(n,e):Array.isArray(e)&&e.forEach((function(e){"string"==typeof e&&shmi.addClass(n,e)})),"string"==typeof t&&n.setAttribute("data-ui",t),n}function setSelected(e,t,s){e.vars.selected[s]!==t&&(null!==e.vars.selected[s]&&shmi.removeClass(e.vars.selected[s],"selected"),e.vars.selected[s]=t,null!==t&&shmi.addClass(t,"selected")),e.vars.selected.forEach((function(t,n){t&&n>s&&(shmi.removeClass(t,"selected"),e.vars.selected[n]=null)}))}function makeMenuElement(t,s,n){const l=s.type||(Array.isArray(s.items)?"group":"item");switch(l){case"group":return n>1&&console.warn(`[${e}] Creating sections for layers >1 not supported.`),function makeMenuSection(e,t,s=0){const n=makeElement("menu-group menu-element","menu-group","LI"),l=makeElement("group-data"),o=makeElement("icon","icon"),r=makeElement(null,null,"IMG"),c=makeElement("menu-group-label","menu-group-label"),u=makeElement("triangle"),m=makeElement(`menu-layer-${s+1} menu-layer-${s}-${s+1} menu-layer-${s+1}-${s+2} accent-border`,`menu-layer-${s+1}`,"UL"),h=t.items.map((t=>makeMenuElement(e,t,s+1))).filter((e=>!!e));o.appendChild(r),l.appendChild(o),l.appendChild(c),l.appendChild(u),h.forEach((({elements:{base:e}})=>m.appendChild(e))),n.appendChild(l),n.appendChild(m);const d=createListener(l,{onClick:function onClick(){const a=e.vars.crumbs[`layer${s}`];shmi.hasClass(n,"selected")?(setLayer(e,s),setSelected(e,null,s),0===s&&removeOverlay(e)):(setLayer(e,s+1),setSelected(e,n,s),a.textContent=shmi.localize(t.label),0===s&&createOverlay(e))}});return c.textContent=shmi.localize(t.label),t["icon-src"]?r.setAttribute("src",t["icon-src"]):r.setAttribute("src",a),"no-icon"===t["icon-mode"]?n.classList.add("no-icon"):"hidden"===t["icon-mode"]&&n.classList.add("hidden-icon"),0===s&&n.classList.add("accent-border"),{type:"section",config:{label:t.label||null,iconSrc:t["icon-src"]||null,iconMode:t["icon-mode"]||"show",access:shmi.cloneObject(t.access)},listeners:[d],elements:{base:n,iconImage:r,label:c,childList:m},children:h}}(t,s,n);case"item":return function makeMenuEntry(e,t,s=0){const n=makeElement("menu-item menu-element","menu-item","LI"),l=makeElement("icon","icon"),o=makeElement(null,null,"IMG"),r=makeElement("menu-item-label","menu-item-label"),{UiAction:c}=shmi.requires("visuals.core"),u=t.action?new c(t.action):null;l.appendChild(o),n.appendChild(l),n.appendChild(r),r.textContent=shmi.localize(t.label),o.setAttribute("src",t["icon-src"]||a),"no-icon"===t["icon-mode"]?n.classList.add("no-icon"):"hidden"===t["icon-mode"]&&n.classList.add("hidden-icon"),0===s&&n.classList.add("accent-border");const m=createListener(n,{onClick:function onClick(){setSelected(e,n,s),setLayer(e,-1),removeOverlay(e),u&&u.execute(e)}});return{type:"entry",config:{label:t.label||null,iconSrc:t["icon-src"]||null,iconMode:t["icon-mode"]||"show",access:shmi.cloneObject(t.access),action:shmi.cloneObject(t.action)},listeners:[m],elements:{base:n,iconImage:o,label:r}}}(t,s,n);case"separator":return function makeMenuSeparator(e,t,s=0){const n=makeElement("menu-item separator","menu-item","LI"),a=makeElement("menu-item-label","menu-item-label");return n.appendChild(a),a.textContent=shmi.localize(t.label),t["show-stroke"]&&n.classList.add("show-stroke"),{type:"separator",config:{label:t.label||null,showStroke:t["show-stroke"]||!1},listeners:[],elements:{base:n,label:a}}}(0,s,n);default:return console.warn(`[${e}] Unknown type for menu element ${l}`),null}}function collectListeners(e){return Array.isArray(e.children)?e.children.reduce(((e,t)=>e.concat(collectListeners(t))),e.listeners):e.listeners||[]}function collectAccessData(e){const t=[];return e.config.access&&e.config.access.condition&&["hide","lock"].includes(e.config.access.type)&&t.push({base:e.elements.base,type:e.config.access.type,condition:e.config.access.condition,listeners:e.listeners.slice(),menu:e}),Array.isArray(e.children)?e.children.reduce(((e,t)=>e.concat(collectAccessData(t))),t):t}function setLayer(e,t){t!==e.vars.activeLayer&&(e.vars.activeLayer>=0&&shmi.removeClass(e.element,`layer-${e.vars.activeLayer}-active`),e.vars.activeLayer=t,t>=0&&shmi.addClass(e.element,`layer-${e.vars.activeLayer}-active`)),-1===t&&e.vars.selected.forEach((function(t,s){null!==t&&(shmi.removeClass(t,"selected"),e.vars.selected[s]=null)}))}function makeAccessConditionCallback({base:e,listeners:t},s){return n=>{n?(shmi.removeClass(e,s),t.forEach((e=>e.enable()))):(shmi.addClass(e,s),t.forEach((e=>e.disable())))}}function createOverlay(e){e.vars.overlay&&removeOverlay(e);const t={element:document.createElement("DIV"),listener:null},s={onClick:null},n=t.element.style;n.position="fixed",n.top=0,n.bottom=0,n.left=0,n.right=0,n.background=e.config["overlay-style"].background,n.zIndex=e.config["overlay-style"].zIndex,document.body.insertBefore(t.element,document.body.firstChild),s.onClick=function(){e.vars.activeLayer>=0&&(setLayer(e,-1),removeOverlay(e))},t.listener=createListener(t.element,s),t.listener.enable(),e.vars.overlay=t}function removeOverlay(e){e.vars.overlay&&(e.vars.overlay.element.parentNode.removeChild(e.vars.overlay.element),e.vars.overlay.listener.disable(),e.vars.overlay=null)}const l={className:e,uiType:t,isContainer:!1,config:s,configSchema:null,vars:{listeners:[],activeLayer:-1,mobile:!1,selected:[null,null,null],crumbs:{layer0:null,layer1:null},tokens:[],overlay:null},imports:{},prototypeExtensions:{onInit:function(){const e=this;e.vars.crumbs.layer0=shmi.getUiElement("selected-entry-layer-0",e.element),e.vars.crumbs.layer1=shmi.getUiElement("selected-entry-layer-1",e.element),e.vars.menu=function makeMenu(e,t){const s=shmi.getUiElement("menu-layer-0",e.element),n=shmi.getUiElement("burger-button",e.element),a=t.map((t=>makeMenuElement(e,t,0))).filter((e=>!!e));return a.forEach((({elements:{base:e}})=>s.appendChild(e))),{type:"menu",config:{},listeners:[createListener(n,{onClick:function onClick(){e.vars.activeLayer>=0?(setLayer(e,-1),removeOverlay(e)):(setLayer(e,0),createOverlay(e))}})],children:a}}(e,e.config.menu),shmi.removeClass(e.element,"mobile")},onEnable:function(){const e=this,{ConditionObserver:t}=shmi.requires("visuals.tools.conditions"),s=shmi.getCurrentLayout();-1!==e.config["mobile-layouts"].indexOf(s)?(shmi.addClass(e.element,"mobile"),e.vars.mobile=!0):(shmi.removeClass(e.element,"mobile"),e.vars.mobile=!1);const n=shmi.listen("layout-change",(function(t){-1!==e.config["mobile-layouts"].indexOf(t.detail.layout)?(shmi.addClass(e.element,"mobile"),e.vars.mobile||setLayer(e,-1),e.vars.mobile=!0):(shmi.removeClass(e.element,"mobile"),e.vars.mobile&&setLayer(e,0),e.vars.mobile=!1),removeOverlay(e)}));e.vars.tokens.push(n),e.vars.mobile||setLayer(e,0),e.vars.listeners=collectListeners(e.vars.menu),e.vars.listeners.forEach((e=>e.enable())),e.vars.tokens.push(...collectAccessData(e.vars.menu).map((e=>{switch(e.type){case"hide":return new t(e.condition,makeAccessConditionCallback(e,"hidden"));case"lock":return new t(e.condition,makeAccessConditionCallback(e,"locked"));default:throw new Error(`Invalid access type ${e.type}`)}})))},onDisable:function(){const e=this;e.vars.tokens.forEach((e=>e.unlisten())),e.vars.listeners.forEach((e=>e.disable())),e.vars.tokens=[],e.vars.listeners=[],removeOverlay(e)},onLock:function(){shmi.addClass(this.element,"locked"),this.vars.listeners.forEach((function(e){e.disable()}))},onUnlock:function(){shmi.removeClass(this.element,"locked"),this.vars.listeners.forEach((function(e){e.enable()}))},onSetValue:function(e,t,s){},onSetProperties:function(e,t,s){}}};shmi.requires("visuals.tools.control-generator").generate(l)}(),function(){"use strict";var e="iq-searchbar",t={"class-name":"iq-searchbar",name:null,template:"default/iq-searchbar.iq-variant-01",label:e,"auto-label":!0,item:null,"show-icon":!1,"icon-src":null,"icon-class":null,tooltip:null,datagrid:null,"search-column":null,"show-results":"two-or-more","max-results":100,"max-results-hint":!1,"result-columns":null,"select-contents-on-focus":!0,"partial-word-search":!1},s=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),n=s.fLog;s.log;function addRegisteredEventListener(e,t,s,n,a){var l=e.vars.registeredEventListeners[t];l||(e.vars.registeredEventListeners[t]=[],l=e.vars.registeredEventListeners[t]),s.addEventListener(n,a),l.push({type:n,target:s,listener:a})}function removeRegisteredEventListeners(e,t){var s=shmi.requires("visuals.tools.iterate.iterateObject"),n=[];t?(n=e.vars.registeredEventListeners[t]||[],delete e.vars.registeredEventListeners[t]):(s(e.vars.registeredEventListeners,(function(e){n=n.concat(e||[])})),e.vars.registeredEventListeners={}),n.forEach((function(e){e.target.removeEventListener(e.type,e.listener)}))}function clearHint(e){e.vars.dom.suggestion.textContent="",e.vars.currentHint=null}function setHint(e,t,s){var n;t&&(0!==(n=e.getValueDirect()).length||s)?(e.config["partial-word-search"]||(e.vars.dom.suggestion.textContent=t.substr(n.length)),e.vars.currentHint=t):clearHint(e)}function setHintByIdx(e,t,s){if(0!==e.vars.dataGridData.length){for(;t<0;)t+=e.vars.dataGridData.length;t%=e.vars.dataGridData.length,null!==e.vars.currentHintIndex&&shmi.removeClass(e.vars.dom.resultBox.firstChild.children[e.vars.currentHintIndex],"hint-current"),shmi.addClass(e.vars.dom.resultBox.firstChild.children[t],"hint-current"),setHint(e,e.vars.dataGridData[t][e.config["search-column"]],s),e.vars.currentHintIndex=t}else clearHint(e)}function updateHint(e,t){!function fetchHint(e,t){var s=e.vars.lastHintSearchToken&&0===t.indexOf(e.vars.lastHintSearchToken),n=e.vars.lastHintSearchResult&&0===e.vars.lastHintSearchResult.indexOf(t);if(s&&n)return onHint(e,t,e.vars.lastHintSearchResult),e.vars.dataGridData=e.vars.dataGridData.filter((s=>s[e.config["search-column"]]&&-1!==s[e.config["search-column"]].indexOf(t))),void updateResultBox(e,e.vars.dataGridData);clearHint(e),e.config["partial-word-search"]?e.vars.dataGrid.setFilter(e.vars.dataGridSearchColumnIdx,["%"+t+"%"]):e.vars.dataGrid.setFilter(e.vars.dataGridSearchColumnIdx,[t+"%"]);e.vars.lastHintSearchToken=t}(e,t||e.getValueDirect())}function onHint(e,t,s){t=t||e.getValueDirect(),s?(shmi.removeClass(e.element,"notfound"),setHint(e,s),e.vars.lastHintSearchResult=s):(t.length>0&&shmi.addClass(e.element,"notfound"),clearHint(e),e.vars.lastHintSearchResult=null)}function clearResultBox(e){for(removeRegisteredEventListeners(e,"result-box");e.vars.dom.resultBox.firstChild;)e.vars.dom.resultBox.removeChild(e.vars.dom.resultBox.firstChild)}function updateResultBox(e,t){var s,a,l=document.createElement("table"),o=!1;if(clearResultBox(e),"never"===e.config["show-results"]||"two-or-more"===e.config["show-results"]&&t.length<=1?o=!1:0!==t.length&&(o=!0),o){if(e.vars.dom.resultBox.style.display="",s=Object.keys(t[0]),(e.config["result-columns"]||[]).length>0&&(s=s.filter((function(t){return-1!==e.config["result-columns"].indexOf(t)}))),0===s.length)return e.vars.dom.resultBox.innerHTML='No columns to display. Please check <span style="font-weight: bold">result-columns</span> in your control configuration.',void n("No columns to display.","dataGrid columns =",Object.keys(t[0]),"columns to display =",e.config["result-columns"]);if((a=s.indexOf(e.config["search-column"]))>0&&(s.unshift(s[a]),s.splice(a+1,1)),t.forEach((function(t,n){var a=document.createElement("tr");s.forEach((function(e){var s=document.createElement("td");s.textContent=t[e]||"",a.appendChild(s)})),addRegisteredEventListener(e,"result-box",a,"touchstart",(e=>{e.stopPropagation()})),addRegisteredEventListener(e,"result-box",a,"mousedown",(function(s){e.setValue(t[e.config["search-column"]]),shmi.removeClass(e.element,"focused"),e.vars.lastValue=e.getValueDirect(),e.fire("change",{value:e.vars.lastValue})})),addRegisteredEventListener(e,"result-box",a,"mouseover",setHintByIdx.bind(null,e,n,!0)),addRegisteredEventListener(e,"result-box",a,"mouseleave",shmi.removeClass.bind(shmi,a,"hint-current")),l.appendChild(a)})),e.config["max-results-hint"]&&t.length===e.config["max-results"]&&e.vars.dataGridResults>t.length){const e=document.createElement("tr");e.classList.add("max-results-notice"),s.forEach(((t,s)=>{const n=document.createElement("td");if(0===s){const e=shmi.localize("${iqsearchbar.results.moreAvailable}");n.textContent=e,n.setAttribute("title",e)}e.appendChild(n)})),l.appendChild(e)}e.vars.dom.resultBox.appendChild(l)}else e.vars.dom.resultBox.style.display="none"}function doResultBoxScroll(e,t){var s=e.vars.dom.resultBox.scrollTop,n=s+e.vars.dom.resultBox.offsetHeight;t.offsetTop<s?t.scrollIntoView(!0):t.offsetTop+t.offsetHeight>n&&t.scrollIntoView(!1)}function hintFetchCompleteCallback(e,t){const s=e.getValueDirect(),n=function getDataGridDataHelper(e,t){var s=e.getFields();return e.getCurrentIDs(t).map((function(t){var n=e.getRowData(t),a={};return n?(n.forEach((function(e,t){a[s[t]]=String(e.value)})),a):null}))}(e.vars.dataGrid,e.vars.dataGridSubscriptionId.id);let a;n.length>0&&(a=(n[0]||{})[e.config["search-column"]]),e.vars.currentHintIndex=null,e.vars.dataGridData=n,e.vars.dataGridResults=t.totalRows,onHint(e,s,a||null),updateResultBox(e,n)}function setSelected(e,t){var s=document.createRange();s.selectNodeContents(e),t||s.setStart(e,s.endOffset);var n=window.getSelection();n.removeAllRanges(),n.addRange(s)}function userInputKeyDownHandler(e,t){"Tab"===t.key?e.vars.currentHint&&e.getValueDirect()!==e.vars.currentHint&&(t.preventDefault(),e.setValue(e.vars.currentHint),clearHint(e),setSelected(e.vars.dom.input)):"Escape"===t.key?shmi.hasClass(e.element,"show-results")?shmi.removeClass(e.element,"show-results"):shmi.addClass(e.element,"show-results"):"ArrowUp"===t.key?e.vars.dom.resultBox.firstChild&&e.vars.dom.resultBox.firstChild.children&&(setHintByIdx(e,(e.vars.currentHintIndex||0)-1,!0),doResultBoxScroll(e,e.vars.dom.resultBox.firstChild.children[e.vars.currentHintIndex]),t.preventDefault()):"PageUp"===t.key?e.vars.dom.resultBox.firstChild&&e.vars.dom.resultBox.firstChild.children&&(setHintByIdx(e,Math.max((e.vars.currentHintIndex||0)-10,0),!0),doResultBoxScroll(e,e.vars.dom.resultBox.firstChild.children[e.vars.currentHintIndex]),t.preventDefault()):"ArrowDown"===t.key?e.vars.dom.resultBox.firstChild&&e.vars.dom.resultBox.firstChild.children&&(setHintByIdx(e,(e.vars.currentHintIndex||0)+1,!0),doResultBoxScroll(e,e.vars.dom.resultBox.firstChild.children[e.vars.currentHintIndex]),t.preventDefault()):"PageDown"===t.key?e.vars.dom.resultBox.firstChild&&e.vars.dom.resultBox.firstChild.children&&(setHintByIdx(e,Math.min((e.vars.currentHintIndex||0)+10,e.vars.dataGridData.length-1),!0),doResultBoxScroll(e,e.vars.dom.resultBox.firstChild.children[e.vars.currentHintIndex]),t.preventDefault()):"Enter"===t.key&&(e.vars.currentHint&&e.setValue(e.vars.currentHint),t.target.blur())}function setupDomUserInput(e){addRegisteredEventListener(e,"input",e.vars.dom.input,"input",(function onInput(){var t=e.getValueDirect();e.vars.dom.mirror.textContent=t,updateHint(e,t)})),addRegisteredEventListener(e,"input",e.vars.dom.input,"keydown",userInputKeyDownHandler.bind(null,e)),addRegisteredEventListener(e,"input",e.vars.dom.input,"focus",(function onFocus(){e.fire("enter",{value:e.getValue()}),e.vars.userInputActive=!0,shmi.addClass(e.element,"focused"),shmi.addClass(e.element,"show-results"),updateHint(e),e.config["select-contents-on-focus"]&&setSelected(e.vars.dom.input,!0)})),addRegisteredEventListener(e,"input",e.vars.dom.input,"blur",(function onBlur(){const t=e.getValueDirect();e.vars.userInputActive=!1,e.vars.lastValue=t,shmi.removeClass(e.element,"focused"),window.getSelection().removeAllRanges(),clearHint(e),e.vars.itemSubscription&&e.config.item&&e.imports.im.writeValue(e.config.item,t),e.fire("change",{value:t})})),addRegisteredEventListener(e,"input",e.vars.dom.input,"touchstart",(function onDown(t){showKeyboard(e),t.stopPropagation()})),addRegisteredEventListener(e,"input",e.vars.dom.input,"click",(function onClick(){showKeyboard(e),shmi.addClass(e.element,"show-results")}))}function setLabelImpl(e,t){e.vars.dom.label&&(""===t||null==t?(e.vars.label="",e.vars.dom.label.textContent="",shmi.addClass(e.element,"no-label")):(e.vars.label=t,e.vars.dom.label.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-label")))}function showKeyboard(e){const t=shmi.requires("visuals.session.config");t.keyboard&&t.keyboard.enabled&&shmi.keyboard({value:e.getValueDirect(),"select-box-enabled":t.keyboard["language-selection"],"show-enter":!1,callback:function(t,s){t&&(e.setValue(s),shmi.addClass(e.element,"focused"),e.fire("change",{value:e.getValue()}))}})}var a={className:"iqSearchbar",uiType:e,isContainer:!1,config:t,configSchema:null,vars:{dom:{icon:null,label:null,input:null,mirror:null,suggestion:null,resultBox:null,clear:null},label:null,initDone:!1,registeredEventListeners:{},dataGrid:null,dataGridSubscriptionId:null,dataGridSearchColumnIdx:-1,dataGridData:[],dataGridResults:0,currentHint:null,currentValue:null,lastHintSearchToken:null,lastHintSearchResult:null,lastValue:null,userInputActive:!1,currentHintIndex:null,itemSubscription:null,listeners:[]},imports:{im:"visuals.session.ItemManager",dgm:"visuals.session.DataGridManager"},events:["change","enter"],prototypeExtensions:{onInit:function(){const e=this,t=shmi.requires("visuals.io");if(this.vars.dom.icon=shmi.getUiElement("icon",this.element),this.vars.dom.label=shmi.getUiElement("label",this.element),this.vars.dom.input=shmi.getUiElement("searchbar-user-input",this.element),this.vars.dom.mirror=shmi.getUiElement("searchbar-mirror",this.element),this.vars.dom.suggestion=shmi.getUiElement("searchbar-suggestion",this.element),this.vars.dom.resultBox=shmi.getUiElement("searchbar-result-box",this.element),this.vars.dom.clear=shmi.getUiElement("clear-input",this.element),this.vars.dataGrid=this.imports.dgm.getGrid(this.config.datagrid),!function verifyDomElements(e){var t=shmi.requires("visuals.tools.iterate.iterateObject"),s=!0;return t(e,(function(e){s=s&&null!==e})),s}(this.vars.dom))return this.element.textContent="One or more required DOM elements are missing from the template. This control will not work. Please select a compatible template.",void n("Some DOM elements are missing from the template.");if(this.vars.dom.icon)if(this.config["icon-src"]&&this.config["show-icon"])this.vars.dom.icon.style.backgroundImage=`url(${this.config["icon-src"]})`;else if(this.config["icon-class"]&&this.config["show-icon"]){this.config["icon-class"].trim().split(" ").forEach(shmi.addClass.bind(shmi,this.vars.dom.icon))}else shmi.addClass(this.element,"no-icon");else shmi.log("[IQ:iq-input-field] no button-icon element provided",1);setLabelImpl(this,this.config.label);const s=shmi.getUiElement("searchbar-label",this.element);s&&(this.config.label&&String(this.config.label).length>0?s.textContent=shmi.localize(this.config.label):s.style.display="none");const a={onClick:function(){e.isActive()&&!e.locked&&(e.setValue(""),e.fire("change",{value:e.getValue()}))}};if(e.vars.listeners.push(new t.MouseListener(e.vars.dom.clear,a)),e.vars.listeners.push(new t.TouchListener(e.vars.dom.clear,a)),null===this.vars.dataGrid)return this.element.textContent="Unable to find datagrid or no datagrid configured. This control will not work. Please select a valid datagrid.",void(this.config.datagrid?n("Datagrid not found",this.config.datagrid):n("No datagrid configured"));this.vars.initDone=!0,this.vars.dataGridSearchColumnIdx=this.vars.dataGrid.getFields().indexOf(this.config["search-column"]),-1===this.vars.dataGridSearchColumnIdx&&(this.element.textContent="Datagrid does not have the configured field to search in. This control will not work. Please select a valid search field.",n("Datagrid does not have the configured search field.")),this.vars.dataGrid.sort(this.vars.dataGridSearchColumnIdx,"ASC")},getValue:function(){return this.vars.lastValue},getValueDirect:function(){if(!this.vars.initDone)return null;return this.vars.dom.input.value.replace(String.fromCharCode(160)," ")},getMatchData:function(){return function getMatchData(e){return(e.vars.dataGridData||[])[e.vars.currentHintIndex||0]||null}(this)},setValue:function(e){this.vars.initDone&&(this.vars.dom.input.value=e,this.vars.dom.mirror.textContent=e,this.vars.lastValue=e,updateHint(this,e))},onEnable:function(){if(!this.vars.initDone)return;const e="number"==typeof this.config["max-results"]&&this.config["max-results"]>0?this.config["max-results"]:100;setupDomUserInput(this),this.vars.dataGridSubscriptionId=this.vars.dataGrid.subscribePage(0,e,hintFetchCompleteCallback.bind(null,this)),this.config.item&&(this.vars.itemSubscription=this.vars.im.subscribeItem(this.config.item,this)),this.vars.listeners.forEach((function(e){e.enable()}))},onDisable:function(){this.vars.initDone&&(this.vars.dataGrid.unsubscribe(this.vars.dataGridSubscriptionId.id),this.vars.dataGridSubscriptionId=null,this.vars.itemSubscription&&(this.vars.itemSubscription.unlisten(),this.vars.itemSubscription=null),clearResultBox(this),removeRegisteredEventListeners(this),this.vars.listeners.forEach((function(e){e.disable()})))},onLock:function(){this.vars.listeners.forEach((function(e){e.disable()})),shmi.addClass(this.element,"locked")},onUnlock:function(){this.vars.listeners.forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked")},onSetValue:function(e,t,s){this.vars.initDone&&!this.vars.userInputActive&&this.setValue(e)},onSetProperties:function(e,t,s){},setLabel:function(e){this.vars.dom.label&&this.config["auto-label"]&&setLabelImpl(this,e)}}};shmi.requires("visuals.tools.control-generator").generate(a)}(),function(){"use strict";var e="iq-select-box",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1);t.fLog,t.log;function setLabelImpl(e,t){e.vars.labelEl&&(""===t||null==t?(e.vars.label="",e.vars.labelEl.textContent="",shmi.addClass(e.element,"no-label")):(e.vars.label=t,e.vars.labelEl.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-label")))}var s={className:"iq-select-box",uiType:e,isContainer:!1,config:{"class-name":"iq-select-box",name:null,template:"default/iq-select-box.iq-variant-01",label:"[Label]",item:null,"auto-label":!0,"icon-src":null,"icon-class":null,tooltip:null,"no-selection-label":"---",selected:-1,options:[],"show-text":!0,"show-icon":!1},configSchema:null,vars:{listeners:[],optionListeners:[],domListeners:{},value:0,active:!1,templateEl:null,labelEl:null,iconEl:null,containerEl:null,anchorEl:null,optionEl:null,selectedEl:null,selectedValEl:null,optionEls:[],selected:-1,clickedInside:!1,isOpen:!1,isLocked:!1,highlightIndex:null,subscriptionTargetId:null,iconClass:"iq-icon",showTextAndIconClass:"iq-icon-and-text",showIconOnlyClass:"iq-icon-only",labelAreaClass:"iq-label-area",highlightClass:"highlighted",selectBoxSelectedClass:"iq-select-box-selected",optionIconAndTextClass:"iq-option-icon-and-text",optionIconOnlyClass:"iq-option-icon-only",optionIconClass:"iq-option-icon"},imports:{im:"visuals.session.ItemManager",iter:"visuals.tools.iterate.iterateObject"},events:["change"],prototypeExtensions:{onInit:function(){var e=this;if(e.vars.templateEl=e.element.cloneNode(!0),e.vars.iqWidgetContent=shmi.getUiElement("iq-widget-content",e.element),e.vars.labelEl=shmi.getUiElement("label",e.element),e.vars.iconEl=shmi.getUiElement("icon",e.element),e.vars.containerEl=shmi.getUiElement("options",e.element),e.vars.selectedEl=shmi.getUiElement("selected",e.element),e.vars.selectedValEl=shmi.getUiElement("value",e.vars.selectedEl),e.vars.optionEl=shmi.getUiElement("option",e.element),e.vars.anchorEl=shmi.getUiElement("anchor",e.vars.containerEl),e.vars.containerEl&&e.vars.anchorEl&&e.vars.optionEl&&e.vars.selectedEl&&e.vars.selectedValEl){if(e.vars.iqWidgetContent.removeChild(e.vars.selectedEl),e.vars.iqWidgetContent.removeChild(e.vars.containerEl),e.vars.iqWidgetContent.removeChild(e.vars.optionEl),e.vars.containerEl=shmi.getUiElement("options",e.vars.templateEl),e.vars.anchorEl=shmi.getUiElement("anchor",e.vars.containerEl),e.vars.optionEl=shmi.getUiElement("option",e.vars.templateEl),e.vars.selectedEl=shmi.getUiElement("selected",e.vars.templateEl),e.vars.selectedValEl=shmi.getUiElement("value",e.vars.selectedEl),e.vars.iconEl)if(e.config["icon-src"]&&e.config["show-icon"])e.vars.iconEl.style.backgroundImage=`url(${e.config["icon-src"]})`;else if(e.config["icon-class"]&&e.config["show-icon"]){e.config["icon-class"].trim().split(" ").forEach((function(t){shmi.addClass(e.vars.iconEl,t)}))}else shmi.addClass(e.element,"no-icon");else shmi.log("[IQ:iq-select-box] no button-icon element provided",1);e.config["show-text"]?setLabelImpl(e,e.config.label):setLabelImpl(e,null);var t=document.createElement("DIV");shmi.addClass(t,"iq-popup-container"),e.vars.iqWidgetContent.appendChild(t),t.appendChild(e.vars.containerEl),t.appendChild(e.vars.selectedEl),e.rebuildOptions(!1),e.vars.selected=e.config.selected,e.vars.containerEl.setAttribute("tabindex","-1"),e.vars.domListeners=e.createDomListenerObject(),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.element,e.createElementListenerObject())),e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.element,e.createElementListenerObject())),e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.vars.containerEl,e.createContainerListenerObject())),shmi.addClass(e.vars.containerEl,"hidden"),-1===e.vars.selected?e.setSelected(null):e.setSelected(e.vars.optionEls[e.config.selected])}else shmi.log("[IQ:iq-select-box] At least one element is missing: containerEl, anchorEl, optionEl, selectedEl, selectedValEl",3)},onEnable:function(){var e=this;e.element.setAttribute("tabindex",0),e.lockUnlockListeners(!1),e.config.item&&(e.vars.subscriptionTargetId=e.imports.im.subscribeItem(e.config.item,e)),shmi.log("[IQ:iq-select-box] Enabled",1)},onDisable:function(){var e=this;e.lockUnlockListeners(!0),e.vars.subscriptionTargetId&&(e.vars.subscriptionTargetId.unlisten(),e.vars.subscriptionTargetId=null),shmi.log("[IQ:iq-select-box] disabled",1)},onLock:function(){var e=this;e.vars.isLocked=!0,shmi.addClass(e.vars.containerEl,"hidden"),e.vars.highlightIndex=-1,e.lockUnlockListeners(!0),shmi.addClass(e.element,"locked"),shmi.log("[IQ:iq-select-box] Locked",1)},onUnlock:function(){this.lockUnlockListeners(!1),shmi.removeClass(this.element,"locked"),shmi.log("[IQ:iq-select-box] unlocked",1)},setOptions:function(e){const t=this;t.config.options=e,t.initialized&&(t.rebuildOptions(t.isActive()),t.setValue(t.getValue()))},getOptions:function(){return shmi.cloneObject(this.config.options)},setSelected:function(e){const t=this,s=t.vars.optionEls.findIndex((t=>t===e));if(t.vars.optionEls.forEach((function(e,s){shmi.removeClass(e,t.vars.selectBoxSelectedClass)})),-1===s)t.vars.selectedValEl.textContent=shmi.localize(t.config["no-selection-label"]),t.vars.value=null,shmi.removeClass(t.vars.selectedEl,t.vars.showTextAndIconClass),shmi.removeClass(t.vars.selectedEl,t.vars.showIconOnlyClass);else{const o=t.config.options[s].label;shmi.addClass(e,t.vars.selectBoxSelectedClass),t.vars.selectedValEl.textContent=shmi.localize(o),t.vars.value=t.config.options[s].value;var n=t.config.options[s],a=shmi.getUiElement("option-icon",t.vars.selectedEl),l=!1;n&&a?(l=t.setIcon(a,n,!0))&&n.label?shmi.addClass(t.vars.selectedEl,t.vars.optionIconAndTextClass):l?shmi.addClass(t.vars.selectedEl,t.vars.optionIconOnlyClass):(shmi.removeClass(t.vars.selectedEl,t.vars.optionIconAndTextClass),shmi.removeClass(t.vars.selectedEl,t.vars.optionIconOnlyClass)):a&&(shmi.removeClass(t.vars.selectedEl,t.vars.optionIconAndTextClass),shmi.removeClass(t.vars.selectedEl,t.vars.optionIconOnlyClass))}t.vars.selected=s},getCurrentIndex:function(){return this.vars.selected},updateValue:function(){var e=this;e.config.item&&e.imports.im.writeValue(e.config.item,e.getValue())},onSetValue:function(e,t,s){const n=this,a=n.getValue();shmi.log("[IQ:iq-select-box] Setting value...: "+e,0);const l=n.config.options.findIndex((t=>t.value===e));n.setSelected(-1!==l?n.vars.optionEls[l]:null),n.getValue()!==a&&n.fire("change",{value:n.getValue()}),shmi.log("[IQ:iq-select-box] Value set: "+e,1)},getValue:function(){return this.vars.value},setLabel:function(e){var t=this;t.vars.labelEl&&t.config["auto-label"]&&t.config["show-text"]&&setLabelImpl(t,e)},lockUnlockListeners:function(e){var t=this;t.vars.listeners.forEach((function(t){e?t.disable():t.enable()})),t.vars.optionListeners.forEach((function(t){e?t.disable():t.enable()})),t.imports.iter(t.vars.domListeners,(function(t,s){t.element&&(e?t.element.removeEventListener(t.event,t.callback):t.element.addEventListener(t.event,t.callback))}))},rebuildOptions:function(e){var t=this;for(t.vars.optionListeners.forEach((function(e){e.disable()})),t.vars.optionListeners=[],t.vars.optionEls=[];t.vars.anchorEl.firstChild;)t.vars.anchorEl.removeChild(t.vars.anchorEl.firstChild);t.config.options.forEach((function(e,s){var n=shmi.localize(e.label),a=t.vars.optionEl.cloneNode(!0),l=shmi.getUiElement("value",a),o=shmi.getUiElement("icon",a),r=!1;l?l.textContent=n:a.textContent=n,(e.tooltip||e["icon-title"])&&a.setAttribute("title",shmi.localize(e.tooltip||e["icon-title"])),o&&((r=t.setIcon(o,e,!1))&&n?shmi.addClass(a,t.vars.optionIconAndTextClass):r&&shmi.addClass(a,t.vars.optionIconOnlyClass)),t.vars.anchorEl.appendChild(a),t.vars.optionEls.push(a)}));var s=t.makeOptionMouseHandler(),n=t.makeOptionTouchHandler();t.vars.optionEls.forEach((function(e){t.vars.optionListeners.push(new shmi.visuals.io.TouchListener(e,n)),t.vars.optionListeners.push(new shmi.visuals.io.MouseListener(e,s))})),e&&t.vars.optionListeners.forEach((function(e){e.enable()}))},setIcon:function(e,t,s){var n=this,a=null,l=!1;return t["icon-src"]?("IMG"!==e.tagName?(a=document.createElement("IMG"),e.parentNode.insertBefore(a,e),e.parentNode.removeChild(e)):a=e,shmi.addClass(a,n.vars.optionIconClass),a.setAttribute("src",t["icon-src"]),l=!0):t["icon-class"]?("DIV"!==e.tagName?(a=document.createElement("DIV"),e.parentNode.insertBefore(a,e),e.parentNode.removeChild(e)):a=e,shmi.addClass(a,n.vars.optionIconClass),shmi.addClass(a,t["icon-class"]),l=!0):shmi.addClass(e,n.vars.optionIconClass),a&&l?a.dataset.ui="option-icon":e.dataset.ui="option-icon",l?shmi.removeClass(e,"hidden"):shmi.addClass(e,"hidden"),l},makeOptionMouseHandler:function(){var e=this;return{onClick:function onClick(t,s,n){shmi.log("[IQ:iq-select-box] Click on element",0);const a=e.getValue();e.setSelected(n.currentTarget),e.updateValue(),shmi.addClass(e.vars.containerEl,"hidden"),e.vars.isOpen=!1,e.vars.highlightIndex=-1,e.getValue()!==a&&e.fire("change",{value:e.getValue()})},onPress:function onPress(e,t,s){shmi.log("[IQ:iq-select-box] Press",0),s.preventDefault()},onRelease:function onRelease(){shmi.log("[IQ:iq-select-box] Release",0)}}},makeOptionTouchHandler:function(){var e=this;return{onPress:function onPress(){},onClick:function onClick(t,s,n){const a=e.getValue();shmi.log("[IQ:iq-select-box] Click on element",0),e.setSelected(n.currentTarget),e.updateValue(),shmi.addClass(e.vars.containerEl,"hidden"),e.vars.isOpen=!1,e.vars.highlightIndex=-1,e.getValue()!==a&&e.fire("change",{value:e.getValue()})}}},createDomListenerObject:function(){var e=this;return{containerBlur:{event:"blur",element:e.vars.containerEl,callback:function(t){e.vars.clickedInside?setTimeout((function(){e.vars.containerEl.focus()}),shmi.c("DECOUPLE_TIMEOUT")):(shmi.addClass(e.vars.containerEl,"hidden"),setTimeout((function(){e.vars.isOpen=!1}),shmi.c("DECOUPLE_TIMEOUT")),e.vars.highlightIndex=-1)}},elementKeydown:{event:"keydown",element:e.element,callback:function(t){var s=t.key?t.key:t.code;!(this.element===document.activeElement&&!this.locked)||"Enter"!==s&&"NumpadEnter"!==s||(shmi.log("[IQ:iq-select-box] click on container",1),e.vars.isOpen?e.vars.containerEl.blur():(shmi.removeClass(e.vars.containerEl,"hidden"),e.vars.isOpen=!0,setTimeout((function(){e.vars.containerEl.focus(),shmi.visuals.session.FocusElement=e.vars.containerEl}),shmi.c("DECOUPLE_TIMEOUT"))))}},containerKeydown:{event:"keydown",element:e.vars.containerEl,callback:function(t){var s=t.key?t.key:t.code;if(shmi.log("[IQ:iq-select-box] Keydown event: "+s,1),e.vars.highlightIndex<0&&(e.vars.highlightIndex=e.getCurrentIndex()),shmi.log("[IQ:iq-select-box] Highlight index "+e.vars.highlightIndex,1),"Escape"===s)e.vars.optionEls.forEach((function(e){shmi.removeClass(e,"highlighted")})),shmi.addClass(e.vars.containerEl,"hidden"),e.vars.isOpen=!1,e.vars.highlightIndex=-1;else if("Enter"===s||"NumpadEnter"===s){if(-1!==e.vars.highlightIndex){shmi.log("[IQ:iq-select-box] Click on element",0);var n=e.vars.optionEls[e.vars.highlightIndex],a=e.getValue();e.setSelected(n),e.updateValue(),shmi.addClass(e.vars.containerEl,"hidden"),e.vars.isOpen=!1,e.vars.highlightIndex=-1,e.getValue()!==a&&e.fire("change",{value:e.getValue()}),e.vars.optionEls.forEach((function(e){shmi.removeClass(e,"highlighted")})),e.vars.highlightIndex=-1}}else"ArrowUp"===s?(e.vars.optionEls[e.vars.highlightIndex]&&shmi.removeClass(e.vars.optionEls[e.vars.highlightIndex],"highlighted"),e.vars.highlightIndex>0?e.vars.highlightIndex--:e.vars.highlightIndex=e.vars.optionEls.length-1,e.vars.optionEls[e.vars.highlightIndex]&&shmi.addClass(e.vars.optionEls[e.vars.highlightIndex],"highlighted")):"ArrowDown"===s&&(e.vars.optionEls[e.vars.highlightIndex]&&shmi.removeClass(e.vars.optionEls[e.vars.highlightIndex],"highlighted"),e.vars.highlightIndex<e.vars.optionEls.length-1?e.vars.highlightIndex++:e.vars.highlightIndex=0,e.vars.optionEls[e.vars.highlightIndex]&&shmi.addClass(e.vars.optionEls[e.vars.highlightIndex],"highlighted"));return!1}}}},createElementListenerObject:function(){var e=this;return{onPress:function(){},onClick:function(t,s,n){n.target!==e.vars.anchorEl&&(shmi.log("[IQ:is-select-box] Click on container",1),e.vars.isOpen?e.vars.containerEl.blur():(shmi.removeClass(e.vars.containerEl,"hidden"),e.vars.isOpen=!0,setTimeout((function(){e.vars.containerEl.focus(),shmi.visuals.session.FocusElement=e.vars.containerEl}),shmi.c("DECOUPLE_TIMEOUT"))))}}},createContainerListenerObject:function(){var e=this;return{onPress:function(t,s,n){n.currentTarget===e.vars.containerEl&&(e.vars.clickedInside=!0)},onRelease:function(t,s,n){n.currentTarget===e.vars.containerEl&&(e.vars.clickedInside=!1)},onLeave:function(){shmi.log("[IQ:iq-select-box] onLeave container element",0),e.vars.containerEl.blur(),e.vars.highlightIndex=-1}}}}};shmi.requires("visuals.tools.control-generator").generate(s)}(),function(){"use strict";var e="iq-select-date",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1);t.fLog,t.log;function setLabelImpl(e,t){e.vars.labelEl&&(""===t||null==t?(e.vars.label="",e.vars.labelEl.textContent="",shmi.addClass(e.element,"no-label")):(e.vars.label=t,e.vars.labelEl.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-label")))}var s={className:"iq-select-date",uiType:e,isContainer:!1,config:{"class-name":"iq-select-date",name:null,template:"default/iq-select-date.variant-01",label:"[Label]",item:null,"auto-label":!0,tooltip:null,dateformat:"${V_DATEFORMAT}",daynames:["${V_SUN_SHORT}","${V_MON_SHORT}","${V_TUE_SHORT}","${V_WED_SHORT}","${V_THU_SHORT}","${V_FRI_SHORT}","${V_SAT_SHORT}"],"daynames-long":["${V_SUN}","${V_MON}","${V_TUE}","${V_WED}","${V_THU}","${V_FRI}","${V_SAT}"],monthnames:["${V_JAN}","${V_FEB}","${V_MAR}","${V_APR}","${V_MAY}","${V_JUN}","${V_JUL}","${V_AUG}","${V_SEP}","${V_OCT}","${V_NOV}","${V_DEC}"],"show-icon":!1,"show-text":!0,"icon-src":null,"icon-class":null,"icon-title":null},configSchema:null,vars:{listeners:[],value:0,active:!1,isOpen:!0,labelEl:null,calendarEl:null,daySelectEl:null,headerEl:null,dayNameEls:null,selectedEl:null,dayEls:[],monthSelectEl:null,previousMonthEl:null,currentMonthEl:null,nextMonthEl:null,yearSelectEl:null,previousYearEl:null,currentYearEl:null,nextYearEl:null,pressedEl:null,blurHandler:null,subscriptionTargetId:null,date:null,selectedDate:null},imports:{im:"visuals.session.ItemManager",nv:"visuals.tools.numericValues",dt:"visuals.tools.date"},events:["change"],prototypeExtensions:{onInit:function(){var e=this;if(e.initDate(),e.vars.iconEl=shmi.getUiElement("icon",e.element),e.vars.labelEl=shmi.getUiElement("label",e.element),e.vars.calendarEl=shmi.getUiElement("calendar",e.element),e.vars.daySelectEl=shmi.getUiElement("day-select",e.element),e.vars.headerEl=shmi.getUiElement("day-header",e.element),e.vars.yearSelectEl=shmi.getUiElement("year-select",e.element),e.vars.dayNameEls=shmi.getUiElements("day-name",e.vars.headerEl),e.vars.dayEls=shmi.getUiElements("day",e.element),e.vars.valueEl=shmi.getUiElement("value",e.element),e.vars.selectedEl=shmi.getUiElement("selected-date",e.element),e.vars.valueEl&&(e.vars.selectedEl=e.vars.valueEl),e.vars.monthSelectEl=shmi.getUiElement("month-select",e.element),e.vars.monthSelectEl&&(e.vars.previousMonthEl=shmi.getUiElement("previous",e.vars.monthSelectEl),e.vars.currentMonthEl=shmi.getUiElement("current",e.vars.monthSelectEl),e.vars.nextMonthEl=shmi.getUiElement("next",e.vars.monthSelectEl)),e.vars.yearSelectEl&&(e.vars.previousYearEl=shmi.getUiElement("previous",e.vars.yearSelectEl),e.vars.currentYearEl=shmi.getUiElement("current",e.vars.yearSelectEl),e.vars.nextYearEl=shmi.getUiElement("next",e.vars.yearSelectEl)),e.vars.calendarEl&&e.vars.daySelectEl&&e.vars.selectedEl&&e.vars.headerEl&&e.vars.monthSelectEl&&e.vars.yearSelectEl)if(!e.vars.dayNameEls||e.vars.dayNameEls&&7!==e.vars.dayNameEls.length)shmi.log("[IQ:iq-select-date] No day-name elements, or not the right count (7) provided",3);else if(e.vars.previousMonthEl&&e.vars.currentMonthEl&&e.vars.nextMonthEl&&e.vars.previousYearEl&&e.vars.currentYearEl&&e.vars.nextYearEl){if(e.vars.dayNameEls.forEach((function(t,s){t.textContent=shmi.localize(e.config.daynames[6===s?0:s+1])})),e.vars.calendarEl.setAttribute("tabindex","0"),e.vars.iconEl)if(e.config["icon-src"]&&e.config["show-icon"])e.vars.iconEl.style.backgroundImage=`url(${e.config["icon-src"]})`;else if(e.config["icon-class"]&&e.config["show-icon"]){e.config["icon-class"].trim().split(" ").forEach((function(t){shmi.addClass(e.vars.iconEl,t)}))}else shmi.addClass(e.element,"no-icon");else shmi.log("[IQ:iq-select-date] no button-icon element provided",1);e.setupListeners(),e.updateCalendar(),setLabelImpl(e,e.config["show-text"]?e.config.label:null)}else shmi.log("[IQ:iq-select-date] Not all month & year select elements provided",3);else shmi.log("[IQ:iq-select-date] No calendar/day-select/selected-date/value/day-header/month-select/year-select element provided",3)},onEnable:function(){var e=this;e.vars.calendarEl&&e.vars.calendarEl.addEventListener("blur",e.vars.blurHandler),e.vars.listeners.forEach((function(e){e.enable()})),e.config.item&&(e.vars.subscriptionTargetId=e.imports.im.subscribeItem(e.config.item,e)),shmi.log("[IQ:iq-select-date] Enabled",1)},onDisable:function(){var e=this;e.vars.calendarEl&&e.vars.calendarEl.removeEventListener("blur",e.vars.blurHandler),e.vars.listeners.forEach((function(e){e.disable()})),e.config.item&&e.imports.im.unsubscribeItem(e.config.item,e.vars.subscriptionTargetId),shmi.log("[IQ:iq-select-date] disabled",1)},onLock:function(){var e=this;shmi.addClass(e.vars.calendarEl,"hidden"),e.isOpen=!1,e.vars.calendarEl&&e.vars.calendarEl.removeEventListener("blur",e.vars.blurHandler),e.vars.listeners.forEach((function(e){e.disable()})),shmi.addClass(e.element,"locked"),shmi.log("[IQ:iq-select-date] Locked",1)},onUnlock:function(){var e=this;e.vars.calendarEl&&e.vars.calendarEl.addEventListener("blur",e.vars.blurHandler),e.vars.listeners.forEach((function(e){e.enable()})),shmi.removeClass(e.element,"locked"),shmi.log("[IQ:iq-select-date] unlocked",1)},onSetValue:function(e,t,s){var n=this,a=new Date(1e3*e),l=n.vars.value;e=parseInt(e),n.vars.value=e,n.vars.date.setFullYear(a.getYear()+1900,a.getMonth()),n.vars.selectedDate.setFullYear(a.getYear()+1900,a.getMonth(),a.getDate()),n.updateCalendar(),l!==n.vars.value&&n.fire("change",{value:n.vars.value})},getValue:function(){return this.vars.value},setLabel:function(e){var t=this;t.vars.labelEl&&t.config["auto-label"]&&t.config["show-text"]&&setLabelImpl(t,e)},updateDateMonth:function(e,t){var s=this;s.vars.date.setFullYear(s.vars.date.getYear()+1900,e),s.vars.selectedDate.setFullYear(s.vars.date.getYear()+1900,e,t.textContent)},setupListeners:function(){var e=this,t={onPress:function(){},onClick:function(t,s,n){e.vars.date.setFullYear(e.vars.date.getYear()+1900,e.vars.date.getMonth()-1),e.updateCalendar()}};e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.vars.previousMonthEl,t)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.vars.previousMonthEl,t));var s={onPress:function(){},onClick:function(t,s,n){e.vars.date.setFullYear(e.vars.date.getYear()+1900,e.vars.date.getMonth()+1),e.updateCalendar()}};e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.vars.nextMonthEl,s)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.vars.nextMonthEl,s));var n={onPress:function(){},onClick:function(t,s,n){e.vars.date.setFullYear(e.vars.date.getYear()+1900-1,e.vars.date.getMonth()),e.updateCalendar()}};e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.vars.previousYearEl,n)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.vars.previousYearEl,n));var a={onPress:function(){},onClick:function(t,s,n){e.vars.date.setFullYear(e.vars.date.getYear()+1900+1,e.vars.date.getMonth()),e.updateCalendar()}};e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.vars.nextYearEl,a)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.vars.nextYearEl,a)),e.vars.pressedEl=null;var l={onPress:function(t,s,n){shmi.addClass(n.target,"pressed"),e.vars.pressedEl=n.target},onRelease:function(t,s,n){shmi.removeClass(e.vars.pressedEl,"pressed")},onClick:function(t,s,n){var a=n.target;shmi.hasClass(a,"iq-previous-month-day")?e.updateDateMonth(e.vars.date.getMonth()-1,a):shmi.hasClass(a,"iq-current-month-day")?e.updateDateMonth(e.vars.date.getMonth(),a):shmi.hasClass(a,"iq-next-month-day")&&e.updateDateMonth(e.vars.date.getMonth()+1,a),e.updateCalendar(),e.config.item&&e.imports.im.writeValue(e.config.item,e.vars.value),shmi.addClass(e.vars.calendarEl,"hidden"),e.vars.isOpen=!1}};e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.vars.daySelectEl,l)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.vars.daySelectEl,l)),shmi.addClass(e.vars.calendarEl,"hidden"),e.vars.isOpen=!1;var o={onClick:function(){e.vars.isOpen?e.vars.calendarEl.blur():(shmi.removeClass(e.vars.calendarEl,"hidden"),e.isOpen=!0,shmi.decouple((()=>{e.vars.calendarEl.focus(),shmi.visuals.session.FocusElement=e.vars.calendarEl})))}};e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.element,o)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.element,o)),e.vars.blurHandler=function(){shmi.addClass(e.vars.calendarEl,"hidden"),shmi.decouple((()=>{e.vars.isOpen=!1}))}},updateCalendar:function(){var e=this,t=e.vars.value,s=new Date(1e3*e.vars.value);e.initDate(),s.setFullYear(e.vars.selectedDate.getYear()+1900,e.vars.selectedDate.getMonth(),e.vars.selectedDate.getDate()),e.vars.value=s.getTime()/1e3,shmi.log("[IQ:iq-select-date] selected time: "+e.vars.value,0);var n=e.vars.date.getMonth(),a=e.vars.date.getYear()+1900,l=new Date(a,n,1).getDay(),o=l-1;e.vars.currentMonthEl.textContent=shmi.localize(e.config.monthnames[n]),e.vars.currentYearEl.textContent=a,1===l?o=7:0===l&&(o=6);for(var r=e.getDaysOfMonth(n,a),c=e.getDaysOfMonth(n+1,a),u=shmi.getUiElements("day",e.element),m=r-o+1,h=0;h<o;h++)u[h].className="iq-previous-month-day",u[h].textContent=m,new Date(a,n-1,m).getTime()===e.vars.selectedDate.getTime()?shmi.addClass(u[h],"iq-selected"):shmi.removeClass(u[h],"iq-selected"),m++;for(m=1,h=o;h<c+o;h++)u[h].className="iq-current-month-day",u[h].textContent=m,new Date(a,n,m).getTime()===e.vars.selectedDate.getTime()?shmi.addClass(u[h],"iq-selected"):shmi.removeClass(u[h],"iq-selected"),m++;for(m=1,h=c+o;h<u.length;h++)u[h].className="iq-next-month-day",u[h].textContent=m,new Date(a,n+1,m).getTime()===e.vars.selectedDate.getTime()?shmi.addClass(u[h],"iq-selected"):shmi.removeClass(u[h],"iq-selected"),m++;var d=shmi.localize(e.config.dateformat);"string"==typeof d?e.vars.selectedEl.textContent=e.imports.dt.formatDateTime(e.vars.selectedDate,{datestring:d}):e.vars.selectedEl.innerHTML="&nbsp;",t!==e.vars.value&&e.fire("change",{value:e.vars.value})},getDaysOfMonth:function(e,t){return new Date(t,e,0).getDate()},initDate:function(){var e=this;null===e.vars.date&&(e.vars.date=new Date),null===e.vars.selectedDate&&(e.vars.selectedDate=new Date((new Date).setHours(0,0,0,0)))}}};shmi.requires("visuals.tools.control-generator").generate(s)}(),function(){"use strict";var e="iq-select-radio",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1);t.fLog,t.log;function setLabelImpl(e,t){e.vars.labelEl&&(""===t||null==t?(e.vars.label="",e.vars.labelEl.textContent="",shmi.addClass(e.element,"no-label")):(e.vars.label=t,e.vars.labelEl.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-label")))}var s={className:"iq-select-radio",uiType:e,isContainer:!1,config:{"class-name":"iq-select-radio",name:null,template:"default/iq-select-radio.variant-01",label:"[Label]",item:null,"auto-label":!0,"show-icon":!1,"icon-src":null,"icon-class":null,tooltip:null,options:[],selected:-1},configSchema:null,vars:{listeners:[],value:-1,active:!1,optionContainerEl:null,optionEls:[],labelEl:null,iconEl:null,iconClassEl:null,label:null,selectedEl:null},imports:{im:"visuals.session.ItemManager",nv:"visuals.tools.numericValues"},events:["change"],prototypeExtensions:{onInit:function(){var e=this;if(e.vars.labelEl=shmi.getUiElement("label",e.element),e.vars.iconEl=shmi.getUiElement("icon",e.element),e.vars.optionEl=shmi.getUiElement("option",e.element),e.vars.optionContainerEl=shmi.getUiElement("option-container",e.element),e.config.options)if(shmi.log("[IQ:iq-select-radio] Options newly defined",1),e.vars.optionEl&&e.vars.optionContainerEl){var t=e.vars.optionEl.cloneNode(!0);if(e.vars.optionContainerEl.removeChild(e.vars.optionEl),e.vars.optionEl=t,e.vars.iconEl)if(e.config["show-icon"]){if(e.config["icon-src"])e.vars.iconEl&&(e.vars.iconEl.style.backgroundImage=`url(${e.config["icon-src"]})`);else if(e.config["icon-class"]){if(e.vars.iconEl)shmi.removeClass(e.vars.iconEl,"iq-icon"),shmi.addClass(e.vars.iconEl,"iq-icon-class"),e.config["icon-class"].trim().split(" ").forEach((function(t){shmi.addClass(e.vars.iconEl,t)}))}}else e.vars.iconEl.style.display="none";else shmi.log("[IQ:iq-select-radio] no button-icon element provided",1);setLabelImpl(e,e.config.label),e.rebuildOptions()}else shmi.log("[IQ:iq-select-radio] Missing option and/or option container element in template!",1);else shmi.log("[IQ:iq-select-radio] No options defined in config",1)},onEnable:function(){var e=this;e.vars.listeners.forEach((function(e){e.enable()})),e.config.item&&(e.vars.subscriptionTargetId=e.imports.im.subscribeItem(e.config.item,e)),shmi.log("[IQ:iq-select-radio] Enabled",1)},onDisable:function(){var e=this;e.vars.listeners.forEach((function(e){e.disable()})),e.config.item&&e.imports.im.unsubscribeItem(e.config.item,e.vars.subscriptionTargetId),shmi.log("[IQ:iq-select-radio] disabled",1)},onLock:function(){this.vars.listeners.forEach((function(e){e.disable()})),shmi.addClass(this.element,"locked"),shmi.log("[IQ:iq-select-radio] Locked",1)},onUnlock:function(){this.vars.listeners.forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked"),shmi.log("[IQ:iq-select-radio] unlocked",1)},onSetValue:function(e,t,s){var n=this,a=n.vars.value!==e;n.vars.value=e;const l=n.config.options.findIndex((t=>t.value===e));-1!==l?n.setSelected(n.vars.optionEls[l]):n.setSelected(null),shmi.log("[IQ:iq-select-radio] value set: "+e,1),a&&this.fire("change",{value:n.vars.value})},getValue:function(){return this.vars.value},onSetProperties:function(e,t,s){this.imports.nv.setProperties(this,arguments)},setLabel:function(e){var t=this;t.vars.labelEl&&t.config["auto-label"]&&setLabelImpl(t,e)},rebuildOptions:function(e){var t=this;t.vars.listeners.forEach((function(e){e.disable()})),t.vars.listeners=[];const s=t.vars.optionContainerEl,n=t.vars.optionEl;t.vars.optionEls=[],s.innerHTML="",t.config.options.forEach((function(e,a){const l=n.cloneNode(!0);l.dataset.value=e.value,l.dataset.no=a;const o=shmi.getUiElement("option-label",l);e.label&&o?o.textContent=shmi.localize(e.label):shmi.addClass(l,"no-label");const r=shmi.getUiElement("option-icon",l);e["icon-src"]&&r?r.style.backgroundImage=`url(${e["icon-src"]})`:e["icon-class"]&&r?shmi.addClass(r,e["icon-class"]):shmi.addClass(l,"no-icon"),e.tooltip&&r&&r.setAttribute("title",shmi.localize(e.tooltip)),s.appendChild(l),t.vars.optionEls.push(l)}));var a={onPress:function onPress(e,t,s){shmi.addClass(s.currentTarget,"pressed")},onRelease:function onRelease(e,s,n){t.vars.optionEls.forEach((e=>{shmi.removeClass(e,"pressed")}))},onClick:function onClick(e,s,n){var a=n.target,l=null,o=!1,r=null;(l=void 0!==a.dataset.ui&&"option"===a.dataset.ui?a:a.closest('[data-ui="option"]'))?void 0===l.dataset.no?(console.error(t.uiType,"Could not match clicked option (data-no missing!?)"),console.log(l)):(o=(r=t.config.options[parseInt(l.dataset.no)]).value!==t.vars.value,t.vars.value=r.value,t.setSelected(l),t.updateValue(),o&&t.fire("change",{value:t.vars.value})):console.error(t.uiType,"Could not match clicked option")}};t.vars.listeners.push(new shmi.visuals.io.MouseListener(t.vars.optionContainerEl,a)),t.vars.listeners.push(new shmi.visuals.io.TouchListener(t.vars.optionContainerEl,a)),e&&t.listeners.forEach((function(e){e.enable()}))},setSelected:function(e){this.vars.optionEls.forEach((t=>{e!==t?shmi.removeClass(t,"selected"):shmi.addClass(t,"selected")})),this.vars.selectedEl=e},getCurrentIndex:function(){var e=this.vars.selectedEl;return this.vars.optionEls.findIndex((t=>e===t))},setOptions:function(e){var t=this;t.config.options=e,t.vars.value=-1,t.vars.selectedEl=null,t.rebuildOptions(t.active)},updateValue:function(){this.config.item&&shmi.visuals.session.ItemManager.writeValue(this.config.item,this.vars.value)}}};shmi.requires("visuals.tools.control-generator").generate(s)}(),function(){"use strict";var e="iq-select-time",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1);t.fLog,t.log;function setLabelImpl(e,t){e.vars.labelEl&&(""===t||null==t?(e.vars.label="",e.vars.labelEl.textContent="",shmi.addClass(e.element,"no-label")):(e.vars.label=t,e.vars.labelEl.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-label")))}function setInputDisabledState(e,t){e.vars.hourEl&&(e.vars.hourEl.disabled=t),e.vars.minuteEl&&(e.vars.minuteEl.disabled=t),e.vars.secondEl&&(e.vars.secondEl.disabled=t)}var s={className:"iq-select-time",uiType:e,isContainer:!1,config:{"class-name":"iq-select-time",name:null,template:"default/iq-select-time.iq-variant-01",label:"[Label]",item:null,"auto-label":!0,"numpad-enabled":!1,tooltip:null,isUTC:!1},configSchema:null,vars:{listeners:[],value:0,active:!1,label:null,subscriptionTargetId:null,labelEl:null,hourEl:null,minuteEl:null,secondEl:null,hours:0,minutes:0,seconds:0,evListeners:[],itemNeedsString:!1},imports:{im:"visuals.session.ItemManager"},events:["change"],prototypeExtensions:{onInit:function(){var e=this;e.vars.labelEl=shmi.getUiElement("label",e.element),e.setupRockerComponent({varName:"hourEl",uiElementName:"hour-select",inputValidator:e.validateGeneric.bind(this,/^[0-1]?[0-9]$|^2[0-3]$/,"hours"),addHandler:e.addHours.bind(e),max:23,label:"${V_HOURS}"}),e.setupRockerComponent({varName:"minuteEl",uiElementName:"minute-select",inputValidator:e.validateGeneric.bind(this,/^[0-5]?[0-9]$/,"minutes"),addHandler:e.addMinutes.bind(e),max:59,label:"${V_MINUTES}"}),e.setupRockerComponent({varName:"secondEl",uiElementName:"second-select",inputValidator:e.validateGeneric.bind(this,/^[0-5]?[0-9]$/,"seconds"),addHandler:e.addSeconds.bind(e),max:59,label:"${V_SECONDS}"}),e.updateInputFields(e.vars),setLabelImpl(e,e.config.label)},onEnable:function(){var e=this;e.vars.listeners.forEach((function(e){e.enable()})),e.config.item&&(e.vars.subscriptionTargetId=e.imports.im.subscribeItem(e.config.item,e)),setInputDisabledState(e,!1),e.log("Enabled",1)},onDisable:function(){var e=this;e.vars.listeners.forEach((function(e){e.disable()})),e.config.item&&e.imports.im.unsubscribeItem(e.config.item,e.vars.subscriptionTargetId),setInputDisabledState(e,!0),e.log("Disabled",1)},onLock:function(){var e=this;setInputDisabledState(e,!0),e.vars.listeners.forEach((function(e){e.disable()})),shmi.addClass(e.element,"locked"),e.log("Locked",1)},onUnlock:function(){var e=this;setInputDisabledState(e,!1),e.vars.listeners.forEach((function(e){e.enable()})),shmi.removeClass(e.element,"locked"),e.log("Unlocked",1)},onDelete:function(){var e=this;e.vars.evListeners.forEach((function(e){e.element.removeEventListener(e.eventType,e.listener)})),e.vars.evListeners=[],e.vars.listeners=[]},onSetValue:function(e,t,s){var n=this;e=parseInt(e);var a=new Date(1e3*e);n.vars.itemNeedsString="string"==typeof e,n.config.isUTC?(n.vars.hours=a.getUTCHours(),n.vars.minutes=a.getUTCMinutes(),n.vars.seconds=a.getUTCSeconds()):(n.vars.hours=a.getHours(),n.vars.minutes=a.getMinutes(),n.vars.seconds=a.getSeconds()),n.updateInputFields(n.vars),n.vars.value!==e&&(n.vars.value=e,n.fire("change",{value:e}))},getValue:function(){return this.vars.value},getHours:function(){return this.vars.hours},getMinutes:function(){return this.vars.minutes},getSeconds:function(){return this.vars.seconds},onSetProperties:function(e,t,s,n,a,l,o,r,c,u){},setLabel:function(e){var t=this;t.vars.labelEl&&t.config["auto-label"]&&setLabelImpl(t,e)},log:function(e,t){shmi.log("[IQ:iq-select-time] "+e,t)},getType:function(e){return Array.isArray(e)?"array":null===e?"null":typeof e},checkType:function(e,t){if(Array.isArray(t)){if(!(e in t))return!1}else if(t!==this.getType(e))return!1;return!0},assertType:function(e,t,s){if(!this.checkType(e,t))throw TypeError(s)},computeNewValue:function(){var e=this.vars,t=new Date(1e3*e.value);return this.config.isUTC?(t.setUTCHours(e.hours),t.setUTCMinutes(e.minutes),t.setUTCSeconds(e.seconds)):(t.setHours(e.hours),t.setMinutes(e.minutes),t.setSeconds(e.seconds)),t.getTime()/1e3},updateValue:function(){var e=this,t=e.computeNewValue();e.config.item&&(e.vars.itemNeedsString?e.imports.im.writeValue(e.config.item,String(t)):e.imports.im.writeValue(e.config.item,t)),e.vars.value!==t&&(e.vars.value=t,e.fire("change",{value:t})),e.updateInputFields(e.vars)},integerToGroup:function(e,t){return(t+e%t)%t},addSeconds:function(e){var t=this;t.assertType(e,"number"),t.vars.secondEl&&t.vars.secondEl.blur(),t.vars.seconds=t.integerToGroup(t.vars.seconds+e,60),t.updateValue()},addMinutes:function(e){var t=this;t.assertType(e,"number"),t.vars.minuteEl&&t.vars.minuteEl.blur(),t.vars.minutes=t.integerToGroup(t.vars.minutes+e,60),t.updateValue()},addHours:function(e){var t=this;t.assertType(e,"number"),t.vars.hourEl&&t.vars.hourEl.blur(),t.vars.hours=t.integerToGroup(t.vars.hours+e,24),t.updateValue()},validateGeneric:function(e,t,s){var n=this;RegExp(e).test(s.value)?(n.vars[t]=parseInt(s.value),n.updateValue(n),n.vars[t]<10&&1===s.value.length&&(s.value="0"+s.value)):n.vars[t]<10?s.value="0"+n.vars[t]:s.value=n.vars[t]},inputKeypressListener:function(e,t){13===Number(t.keyCode)&&(t.preventDefault(),window.getSelection().removeAllRanges(),e.blur())},inputChangeListener:function(e,t){13===Number(t.keyCode)||e.value.length>1&&(window.getSelection().removeAllRanges(),e.blur())},inputBlurListener:function(e,t,s){window.getSelection().removeAllRanges(),shmi.removeClass(e,"selectableText"),t(e)},addClickTouchListener:function(e,t,s){e.listeners.push(new shmi.visuals.io.MouseListener(t,s)),e.listeners.push(new shmi.visuals.io.TouchListener(t,s))},addEventListener:function(e,t,s,n){t.addEventListener(s,n),e.evListeners.push({element:t,eventType:s,listener:n})},createInputField:function(e,t,s,n){var a=this;if(t){var l=shmi.requires("visuals.session.config"),o=l.keyboard&&l.keyboard.enabled;(n=shmi.cloneObject(n)).callback=function(e){t.value=e,s(t)},a.addClickTouchListener(e,t,{onPress:(e,t,s)=>{(n.numpadEnabled||o)&&(s.preventDefault(),s.stopPropagation())},onClick:function onClick(e,s,a){(n.numpadEnabled||o)&&(n.value=t.value,shmi.numpad(n))}}),a.addEventListener(e,t,"keypress",a.inputKeypressListener.bind(null,t)),a.addEventListener(e,t,"input",a.inputChangeListener.bind(null,t)),a.addEventListener(e,t,"blur",a.inputBlurListener.bind(null,t,s)),a.addEventListener(e,t,"focus",(e=>{n.numpadEnabled||o?(n.value=t.value,shmi.numpad(n)):t.select()}))}else a.log("no base element provided",1)},setupRockerComponent:function(e){var t=this,s=shmi.getUiElement(e.uiElementName,t.element);if(!s)return t.log("Element not found: "+e.uiElementName,1),!1;var n=shmi.getUiElement("previous",s);if(!n)return t.log("No UI element found for "+e.uiElementName+".previous",1),!1;var a=shmi.getUiElement("current",s);if(!a)return t.log("No UI element found for "+e.uiElementName+".current",1),!1;var l=shmi.getUiElement("next",s);return l?(t.createInputField(t.vars,a,e.inputValidator.bind(t),{min:0,max:e.max,label:e.label,numpadEnabled:t.config["numpad-enabled"]||!1}),t.addClickTouchListener(t.vars,n,{onPress:shmi.addClass.bind(null,n,"pressed"),onRelease:shmi.removeClass.bind(null,n,"pressed"),onClick:e.addHandler.bind(null,-1)}),t.addClickTouchListener(t.vars,l,{onPress:shmi.addClass.bind(null,l,"pressed"),onRelease:shmi.removeClass.bind(null,l,"pressed"),onClick:e.addHandler.bind(null,1)}),t.vars[e.varName]=a,!0):(t.log("No UI element found for "+e.uiElementName+".next",1),!1)},updateInputFields:function(e){var t=this;t.vars.hourEl&&(t.vars.hourEl.value=e.hours>9?e.hours:"0"+e.hours),t.vars.minuteEl&&(t.vars.minuteEl.value=e.minutes>9?e.minutes:"0"+e.minutes),t.vars.secondEl&&(t.vars.secondEl.value=e.seconds>9?e.seconds:"0"+e.seconds)}}};shmi.requires("visuals.tools.control-generator").generate(s)}(),function(){"use strict";const e="IqShape";function translateVector2D(e,t){return[e[0]+t[0],e[1]+t[1]]}const t={className:e,uiType:"iq-shape",isContainer:!1,config:{"class-name":"iq-shape",name:null,template:"default/iq-shape",polygons:[],rotation:0,scale:1},configSchema:null,vars:{},imports:{},events:[],prototypeExtensions:{onInit:function onInit(){const t=shmi.getUiElement("shape",this.element),s=function calculateRotationMatrix2D(e){return[[Math.cos(e),-Math.sin(e)],[Math.sin(e),Math.cos(e)]]}((this.config.rotation||0)/360*2*Math.PI);if(!t)return void console.error(`[${e}] "shape" element is missing in template.`);const n=function getUiElements(t,s){const n={};return t.every((t=>{const a=shmi.getUiElement(t,s);return a?(n[t]=a,!0):(console.error(`[${e}] "${t}" element is missing in template.`),!1)}))?n:null}(["shape-polygon","clip-path","clip-path-polygon"],t);if(!n)return;const a=Math.floor(Math.random()*Number.MAX_SAFE_INTEGER);Object.entries(n).forEach((([e,t])=>t.setAttribute("id",`${e}-${a}`))),n["shape-polygon"].setAttribute("clip-path",`url(#clip-path-${a})`);const l=(this.config.polygons||[]).map((e=>function scaleVector2DCentered(e,t){return translateVector2D(function scaleVector2D(e,t){return[e[0]*t,e[1]*t]}(translateVector2D(e,[-.5,-.5]),t),[.5,.5])}(function rotateVector2DCenter(e,t){return translateVector2D(function rotateVector2D(e,t){return[t[0][0]*e[0]+t[0][1]*e[1],t[1][0]*e[0]+t[1][1]*e[1]]}(translateVector2D(e,[-.5,-.5]),t),[.5,.5])}(e,s),this.config.scale/100))),o=function makePolygonPoints(e,t,s){return s.map((([s,n])=>`${s*e},${n*t}`)).join(" ")}(t.viewBox.baseVal.width,t.viewBox.baseVal.height,l);if("polygon"===n["shape-polygon"].tagName)n["shape-polygon"].setAttribute("points",o),n["clip-path-polygon"].setAttribute("points",o)}}};shmi.requires("visuals.tools.control-generator").generate(t)}(),function(){"use strict";const e="IqSlider",t="iq-slider",s={"class-name":t,name:null,template:"default/iq-slider.iq-variant-01","send-interval":100,"animation-duration":100,continuous:!0,min:0,max:100,step:0,precision:-1,type:shmi.c("TYPE_FLOAT"),label:"[Label]","unit-text":"[Unit]","decimal-delimiter":".","auto-min":!0,"auto-max":!0,"auto-step":!0,"auto-label":!0,"auto-unit-text":!0,"auto-type":!0,"auto-precision":!0,"initial-text":"-","show-text":!0,"show-icon":!1,"icon-src":null,"icon-class":null,inverted:!1},n={NO_LABEL:"no-label",NO_ICON:"no-icon",NO_UNIT:"no-unit",LOCKED:"locked",PRESSED:"pressed",INVERTED:"invert-slider"},a={VERTICAL:"vertical",HORIZONTAL:"horizontal"};function setLabel(e,t){const{elements:s}=e.vars;"string"==typeof t&&t.length?(s.label.textContent=shmi.localize(t),shmi.removeClass(e.element,n.NO_LABEL)):(s.label.textContent="",shmi.addClass(e.element,n.NO_LABEL))}function setUnit(e,t){const{elements:s}=e.vars;"string"==typeof t&&t.length?(s.unit.textContent=shmi.localize(t),shmi.removeClass(e.element,n.NO_UNIT)):(s.unit.textContent="",shmi.addClass(e.element,n.NO_UNIT))}function updateDimensions(e){const{dims:t,elements:s,orientation:n}=e.vars;switch(n){case a.HORIZONTAL:t.track=s.track.clientWidth,t.handle=s.handle.offsetWidth,t.touchzone=s.touchzone.offsetWidth;break;case a.VERTICAL:t.track=s.track.clientHeight,t.handle=s.handle.offsetHeight,t.touchzone=s.touchzone.offsetHeight}updateHandle(e,getTranslation(e,e.getValue()))}function getInputHandler(e){return{onPress:function(){e.vars.dragging=!1,shmi.addClass(e.vars.elements.handle,n.PRESSED)},onDrag:function(t,s,n){n.preventDefault();const{movable:l,dims:o}=e.vars;e.vars.dragging||(e.vars.dragging=!0,!1!==e.config.continuous&&function startSend(e){0===e.vars.sendInterval&&(e.vars.sendInterval=setInterval(updateValue.bind(null,e),e.getConfig()["send-interval"]))}(e)),e.vars.orientation===a.VERTICAL?(l.ty+s>0?(l.ty=0,l.update()):l.ty+s<Math.min(0,o.handle-o.track)?(l.ty=Math.min(0,o.handle-o.track),l.update()):l.translate(0,s),updateScale(e,l.ty),updateTouchZone(e,l.ty)):(l.tx+t<0?(l.tx=0,l.update()):l.tx+t+o.handle>o.track?(l.tx=Math.max(0,o.track-o.handle),l.update()):l.translate(t,0),updateScale(e,l.tx),updateTouchZone(e,l.tx))},onRelease:function(){e.vars.dragging=!1,function stopSend(e){0!==e.vars.sendInterval&&(clearInterval(e.vars.sendInterval),e.vars.sendInterval=0)}(e),updateValue(e),shmi.removeClass(e.vars.elements.handle,n.PRESSED)}}}function getSliderTrackInputHandler(e){const t=getInputHandler(e),s=t.onPress,l=t.onRelease;return Object.assign(t,{onPress:function onPress(l,o,r){const{movable:c,dims:u}=e.vars,{min:m,max:h}=e.vars.valueSettings;e.vars.dragging=!0,shmi.addClass(e.vars.elements.track,n.PRESSED);const d=e.vars.elements.track.getBoundingClientRect();if(e.vars.orientation===a.VERTICAL){const t=o-d.y;e.config.inverted?c.ty=getTranslation(e,t/u.track*(h-m)+m):c.ty=getTranslation(e,(1-t/u.track)*(h-m)+m),updateScale(e,c.ty),updateTouchZone(e,c.ty)}else{const t=l-d.x;e.config.inverted?c.tx=getTranslation(e,(1-t/u.track)*(h-m)+m):c.tx=getTranslation(e,t/u.track*(h-m)+m),updateScale(e,c.tx),updateTouchZone(e,c.tx)}c.update(),updateValue(e),s.call(t,l,o,r)},onRelease:function onRelease(...s){l.call(t,...s),shmi.removeClass(e.vars.elements.track,n.PRESSED),e.vars.elements.handle.focus()}})}function updateValue(e){const{nv:t,im:s}=e.imports,{valueSettings:n,orientation:l,movable:o,dims:r,elements:c}=e.vars,{min:u,max:m}=n,h=e.getConfig(),d=e.getValue(),f=l===a.VERTICAL?-o.ty:o.tx,v=r.track-r.handle;let g=null;v<=0||(g=m===u?m:e.config.inverted?(1-f/v)*(m-u)+u:f*(m-u)/v+u,g=t.applyInputSettings(g,e),g!==d&&(c.value&&(c.value.textContent=t.formatOutput(g,e)),e.vars.value=g,h.item?s.writeValue(h.item,g):e.fire("change",{value:g})))}function updateHandle(e,t){isNaN(t)||(e.vars.orientation===a.VERTICAL?e.vars.movable.ty=t:e.vars.movable.tx=t,e.vars.movable.update(),updateScale(e,t),updateTouchZone(e,t))}function updateScale(e,t){let s=e.vars.dims.track-e.vars.dims.handle,n=s>0?Math.abs(t)/s:1;const{elements:{scale:a}}=e.vars;a.style.setProperty("--internal-fill-level",100*n+"%")}function updateTouchZone(e,t){const{MIN_MOVED_PX:s}=shmi.Constants,{dims:n,orientation:l,elements:o}=e.vars,r=Math.max(0,n.track-n.handle);shmi.caf(e.vars.touchzoneRafId),e.vars.touchzoneRafId=shmi.raf((()=>{t=Math.abs(t),l===a.VERTICAL?t<s?(o.touchzone.style.height=`calc(100% + ${Math.floor(t)+s}px)`,e.vars.touchzoneState.offsetModified&&(o.touchzone.style.top="",e.vars.touchzoneState.offsetModified=!1),e.vars.touchzoneState.lengthModified=!0):t>r-s?(o.touchzone.style.height=`calc(100% + ${Math.floor(r-t)+s}px)`,o.touchzone.style.top=`-${Math.floor(r-t)}px`,e.vars.touchzoneState.lengthModified=!0,e.vars.touchzoneState.offsetModified=!0):(e.vars.touchzoneState.lengthModified&&(o.touchzone.style.height="",e.vars.touchzoneState.lengthModified=!1),e.vars.touchzoneState.offsetModified&&(o.touchzone.style.top="",e.vars.touchzoneState.offsetModified=!1)):t<s?(o.touchzone.style.width=`calc(100% + ${Math.floor(t)+s}px)`,o.touchzone.style.left=`-${Math.floor(t)}px`,e.vars.touchzoneState.lengthModified=!0,e.vars.touchzoneState.offsetModified=!0):t>r-s?(o.touchzone.style.width=`calc(100% + ${Math.floor(r-t)+s}px)`,e.vars.touchzoneState.offsetModified&&(o.touchzone.style.left="",e.vars.touchzoneState.offsetModified=!1),e.vars.touchzoneState.lengthModified=!0):(e.vars.touchzoneState.lengthModified&&(o.touchzone.style.width="",e.vars.touchzoneState.lengthModified=!1),e.vars.touchzoneState.offsetModified&&(o.touchzone.style.left="",e.vars.touchzoneState.offsetModified=!1))}))}function getTranslation(e,t){const{min:s,max:n}=e.vars.valueSettings,{dims:l,orientation:o}=e.vars;let r=null;return r=n===s?Math.max(0,l.track-l.handle):e.config.inverted?(1-(t-s)/(n-s))*Math.max(0,l.track-l.handle):(t-s)/(n-s)*Math.max(0,l.track-l.handle),o===a.VERTICAL&&(r*=-1),r}const l={className:e,uiType:t,isContainer:!1,config:s,configSchema:null,vars:{elements:{label:null,icon:null,value:null,unit:null,track:null,scale:null,handle:null,touchzone:null},resizeObserver:null,listeners:[],tokens:[],valueSettings:null,value:0,orientation:a.HORIZONTAL,dims:{track:null,handle:null,touchzone:null},dragging:!1,movable:null,anim:null,sendInterval:0,touchzoneState:{lengthModified:!1,offsetModified:!1},touchzoneRafId:0,firstDraw:!0},imports:{im:"visuals.session.ItemManager",iter:"visuals.tools.iterate.iterateObject",nv:"visuals.tools.numericValues",io:"visuals.io",gfx:"visuals.gfx"},events:["change"],prototypeExtensions:{onInit:function(){const t=this,{elements:s,listeners:l}=t.vars,{iter:o,nv:r,io:c,gfx:u}=t.imports;o(s,((e,n)=>{s[n]=shmi.getUiElement(n,t.element)})),s.track&&s.scale&&s.handle?(r.initValueSettings(t),s.value&&"string"==typeof t.config["initial-text"]&&(s.value.textContent=shmi.localize(t.config["initial-text"])),s.label&&setLabel(t,t.config["show-text"]?t.config.label:null),s.unit&&setUnit(t,t.config["unit-text"]),s.track.dataset.orientation===a.HORIZONTAL||s.track.dataset.orientation===a.VERTICAL?t.vars.orientation=s.track.dataset.orientation:console.warn(`[${e}] invalid orientation setting '${s.track.dataset.orientation}' in template '${t.getConfig().template}', defaulting to horizontal.`),t.vars.orientation===a.VERTICAL?s.scale.style.transformOrigin="bottom":s.scale.style.transformOrigin="left",t.config.inverted&&shmi.addClass(t.element,n.INVERTED),function initIcon(e){const{elements:t}=e.vars,s=e.getConfig();t.icon?s["show-icon"]&&s["icon-src"]?t.icon.style.backgroundImage=`url(${e.config["icon-src"]})`:s["show-icon"]&&s["icon-class"]?shmi.addClass(t.icon,s["icon-class"]):shmi.addClass(e.element,n.NO_ICON):shmi.addClass(e.element,n.NO_ICON)}(t),t.vars.movable=new u.Movable(s.handle),t.vars.anim=new u.Animation(updateHandle.bind(null,t)),t.vars.resizeObserver=new ResizeObserver(updateDimensions.bind(null,t)),l.push(new c.MouseListener(s.handle,getInputHandler(t))),l.push(new c.TouchListener(s.handle,getInputHandler(t))),l.push(new c.MouseListener(s.track,getSliderTrackInputHandler(t))),l.push(new c.TouchListener(s.track,getSliderTrackInputHandler(t)))):console.error(`[${e}] template is missing required element ("track", "scale", "handle")`)},onEnable:function(){const e=this,{tokens:t,listeners:s}=e.vars,{im:n}=e.imports;s.forEach((e=>e.enable())),updateDimensions(e),e.vars.resizeObserver.observe(e.element),e.vars.firstDraw=!0,e.config.item&&t.push(n.subscribeItem(e.config.item,e))},onDisable:function(){const e=this;e.vars.resizeObserver.unobserve(e.element),e.vars.listeners.forEach((e=>e.disable())),e.vars.tokens.forEach((e=>e.unlisten())),e.vars.tokens=[],e.vars.anim.stop()},onDelete:function(){},onLock:function(){this.vars.listeners.forEach((e=>{e.keepUnlocked||e.disable()})),shmi.addClass(this.element,n.LOCKED)},onUnlock:function(){this.vars.listeners.forEach((e=>{e.keepUnlocked||e.enable()})),shmi.removeClass(this.element,n.LOCKED)},onSetProperties:function(){const{nv:e}=this.imports;e.setProperties(this,arguments)},onSetValue:function(e){const t=this,s=shmi.requires("visuals.tools.numericValues"),{elements:n,orientation:l,anim:o,movable:r}=t.vars,c=t.getConfig(),u=t.getValue();t.vars.value=s.applyInputSettings(e,t),n.value&&(n.value.textContent=s.formatOutput(t.vars.value,t)),t.vars.dragging||(o.setCurrentValue(l===a.VERTICAL?r.ty:r.tx),t.vars.firstDraw?(t.vars.firstDraw=!1,o.start(getTranslation(t,t.vars.value),0)):o.start(getTranslation(t,t.vars.value),c["animation-duration"])),t.vars.value!==u&&t.fire("change",{value:t.vars.value})},getValue:function(){return this.vars.value},setLabel:function(e){const t=this,{elements:s}=t.vars;t.config["show-text"]&&t.config["auto-label"]&&s.label&&(setLabel(t,e),updateDimensions(t))},setUnitText:function(e){const t=this,{elements:s}=t.vars;t.config["auto-unit-text"]&&s.unit&&(setUnit(t,e),updateDimensions(t))}}};shmi.requires("visuals.tools.control-generator").generate(l)}(),function(){"use strict";var e="iq-text-display",t={"class-name":"iq-text-display",name:null,template:"default/iq-text-display.variant-01",label:"[Label]",item:null,min:Number.NEGATIVE_INFINITY,max:Number.POSITIVE_INFINITY,precision:-1,"decimal-delimiter":".",type:shmi.c("TYPE_INT"),"unit-text":"[Unit]","auto-label":!0,"auto-unit-text":!0,"auto-min":!0,"auto-max":!0,"auto-precision":!0,"auto-type":!0,"icon-src":null,"icon-class":null,"icon-title":null,tooltip:null,"initial-text":"-"},s=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1);s.fLog,s.log;function setLabel(e,t){"string"==typeof t&&t.length?(e.vars.labelEl.textContent=shmi.localize(t),shmi.removeClass(e.element,"no-label")):(e.vars.labelEl.textContent="",shmi.addClass(e.element,"no-label"))}var n={className:"iq-text-display",uiType:e,isContainer:!1,config:t,configSchema:null,tooltipProperties:["icon-title"],vars:{listeners:[],value:0,active:!1,currentValueEl:null,labelEl:null,unitEl:null,iconEl:null,initialized:!1,subscriptionTargetId:null,requestId:null},imports:{im:"visuals.session.ItemManager",nv:"visuals.tools.numericValues"},events:[],prototypeExtensions:{onInit:function(){const e=this;if(e.imports.nv.initValueSettings(e),e.vars.labelEl=shmi.getUiElement("label",e.element),e.vars.unitEl=shmi.getUiElement("unit",e.element),e.vars.iconEl=shmi.getUiElement("icon",e.element),e.vars.currentValueEl=shmi.getUiElement("value",e.element),!e.vars.currentValueEl)return shmi.log("[IQ:iq-text-display] Current value element is missing)",3),e.vars.labelEl=null,void(e.vars.unitEl=null);if(e.vars.unitEl&&(e.config["unit-text"]?(e.vars.unit=e.config["unit-text"],e.vars.unitEl.textContent=shmi.localize(e.config["unit-text"])):e.vars.unitEl.textContent=""),this.config["unit-scale"]&&(this.config["unit-scale"]=parseFloat(shmi.localize(this.config["unit-scale"]))),e.vars.labelEl&&e.config["show-text"]?setLabel(e,e.config.label):setLabel(e,null),e.vars.iconEl)if(e.config["show-icon"]&&e.config["icon-src"])e.vars.iconEl.style.backgroundImage=`url(${e.config["icon-src"]})`;else if(e.config["show-icon"]&&e.config["icon-class"]){e.config["icon-class"].trim().split(" ").forEach((function(t){shmi.addClass(e.vars.iconEl,t)}))}else shmi.addClass(e.element,"no-icon");else shmi.log("[IQ:iq-button] no button-icon element provided",1),shmi.addClass(e.element,"no-icon");"string"==typeof e.config["initial-text"]&&(e.vars.currentValueEl.textContent=shmi.localize(e.config["initial-text"]))},onEnable:function(){var e=this;e.config.item&&(e.vars.subscriptionTargetId=e.imports.im.subscribeItem(e.config.item,e)),shmi.log("[IQ:iq-text-display] Enabled",1)},onDisable:function(){var e=this;e.config.item&&e.imports.im.unsubscribeItem(e.config.item,e.vars.subscriptionTargetId),shmi.log("[IQ:iq-text-display] disabled",1)},onSetValue:function(e,t,s){var n=this;t===shmi.c("TYPE_STRING")||isNaN(parseFloat(e))?n.vars.value=e:n.vars.value=parseFloat(e),shmi.caf(n.vars.requestId),n.vars.requestId=shmi.raf((function(){n.asyncSet(t)}))},onSetProperties:function(){const{nv:e}=this.imports;e.setProperties(this,arguments)},setUnitText:function(e){var t=this;t.vars.unitEl&&t.config["auto-unit-text"]&&(t.vars.unit=e,t.vars.unitEl.textContent=shmi.localize(e))},setLabel:function(e){var t=this;t.vars.labelEl&&t.config["auto-label"]&&t.config["show-text"]&&setLabel(t,e)},asyncSet:function(e){var t=this;shmi.visuals.session.deactivateControls?setTimeout(t.asyncSet.bind(t,e),shmi.c("ACTION_RETRY_TIMEOUT")):t.vars.currentValueEl.textContent=t.imports.nv.formatOutput(t.vars.value,t)},onLock:function(){shmi.addClass(this.element,"locked")},onUnlock:function(){shmi.removeClass(this.element,"locked")}}};shmi.requires("visuals.tools.control-generator").generate(n)}(),function(){"use strict";var e="iq-text",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),s=(t.fLog,t.log,{className:"iq-text",uiType:e,isContainer:!1,config:{"class-name":"iq-text",name:null,template:"default/iq-text.variant-01",text:"[Text]",items:[],tooltip:null},configSchema:null,vars:{tokens:[],textEl:null,itemValues:[],rafId:0},imports:{im:"visuals.session.ItemManager",nv:"visuals.tools.numericValues"},events:[],prototypeExtensions:{onInit:function(){var e=this;e.vars.textEl=shmi.getUiElement("text",e.element),e.vars.textEl?e.config.text&&(e.vars.textEl.textContent=shmi.localize(e.config.text)):shmi.log("[IQ:iq-text] Missing main element",3)},onEnable:function(){var e=this;Array.isArray(e.config.items)&&e.config.items.forEach((function(t,s){var n=e.imports.im.getItemHandler();e.vars.itemValues.push({value:null,unit:null,label:null}),n.setValue=function setValue(t,n,a){const l=e.imports.im.getItem(a);let o=null;l&&(l.adapter&&l.adapter.unitText?o=l.adapter.unitText:"string"==typeof l.unit&&(o=l.unit),e.vars.itemValues[s]={value:n===shmi.Constants.TYPE_STRING?l.readValue():e.imports.nv.formatNumber(l.readValue(!0),{precision:l.digits,unit:l.unit,"show-unit":!1}),unit:shmi.localize(o),label:shmi.localize(l.labelToken)},e.updateText())},e.vars.tokens.push(e.imports.im.subscribeItem(t,n))})),shmi.log("[IQ:iq-text] Enabled",1)},onDisable:function(){this.vars.tokens.forEach((function(e){e.unlisten()})),this.vars.tokens=[],shmi.log("[IQ:iq-text] disabled",1)},onLock:function(){shmi.addClass(this.element,"locked"),shmi.log("[IQ:iq-text] Locked",1)},onUnlock:function(){shmi.removeClass(this.element,"locked"),shmi.log("[IQ:iq-text] unlocked",1)},updateText:function(){var e=this;shmi.caf(e.vars.rafId),e.vars.rafId=shmi.raf((function(){e.isActive()&&(e.vars.textEl.textContent=shmi.evalString(shmi.localize(e.config.text),{items:e.vars.itemValues}))}))}}});shmi.requires("visuals.tools.control-generator").generate(s)}(),function(){"use strict";const e="iq-trend-legend",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1);t.fLog,t.log;function handleGraphChange(e){clearValueInfo(e),generateValueInfo(e)}function onTrendEnable(e,t){e.vars.trendWidget=t,e.vars.styleImages=loadStyleImages(e,t.getValueStyles()),e.vars.defaultStyleImage=loadStyleImages(e,[t.getDefaultStyle()])[0],e.vars.inactiveImage=loadStyleImages(e,[t.getInactiveStyle()])[0],generateValueInfo(e),e.vars.infoToken=t.listen("value-info",handleGraphChange.bind(null,e)),e.vars.optionsToken=t.listen("graph-options",handleGraphChange.bind(null,e))}function onTrendDisable(e){clearValueInfo(e),e.vars.trendWidget=null,e.vars.infoToken&&(e.vars.infoToken.unlisten(),e.vars.infoToken=null),e.vars.optionsToken&&(e.vars.optionsToken.unlisten(),e.vars.optionsToken=null)}function nameOrNodeHandleMatches(e,t){const{HANDLE_PREFIX:s,getNodeHandle:n}=shmi.requires("visuals.tools.nodes");return"string"==typeof e&&e.startsWith(s)?n(t)===e.replace(s,""):e===t.getName()}function clearValueInfo(e){e.vars.listeners.forEach((e=>{e.disable()})),e.vars.listeners=[],e.vars.valueInfos.forEach((e=>{e.base.parentNode.removeChild(e.base)})),e.vars.valueInfos=[]}function generateValueInfo(e){const{trendWidget:t}=e.vars;if(!t)return;const s=e.vars.trendWidget.getValueInfo(),n=e.vars.trendWidget.getSelectedValues(),a=shmi.requires("visuals.tools.unitClasses"),l=n.some((e=>!(!e.options||!e.options.highlight)));l?shmi.addClass(e.element,"highlighted"):(e.vars.highlighted&&shmi.removeClass(e.vars.highlighted.base,"active"),e.vars.highlighted=null,shmi.removeClass(e.element,"highlighted")),e.vars.valueInfos=n.filter((e=>s[e.name]&&"string"==typeof s[e.name].data_type&&"string"!==s[e.name].data_type)).map((n=>{const o=e.vars.elements.valueInfoTemplate.content.cloneNode(!0),r=shmi.getUiElement("value-info",o),c=r||null,u=c?shmi.getUiElement("value-label",c):null,m=c?shmi.getUiElement("value-icon",c):null,h=c?shmi.getUiElement("value-unit",c):null;if(u&&(u.textContent=s[n.name]&&s[n.name].label?shmi.localize(s[n.name].label):n.name),m)if(l&&!n.options.highlight)m.setAttribute("src",e.vars.inactiveImage);else{const t=e.vars.styleImages[n.options.style]?e.vars.styleImages[n.options.style]:e.vars.defaultStyleImage;m.setAttribute("src",t)}let d="";if(c&&h){if(e.config["show-unit"]&&s[n.name]&&null!==s[n.name].unit)if(function isUnitClass(e){return String(parseInt(e))===String(e)}(s[n.name].unit)){const e=a.getSelectedAdapter(s[n.name].unit);e&&(d=e.unitText)}else d=s[n.name].unit;"string"==typeof d&&""!==d?h.textContent=shmi.localize(d):shmi.addClass(c,"no-unit")}const f={base:c,label:u,icon:m,unit:h,info:n};if(c){(n.options&&n.options.highlight||e.vars.highlighted&&e.vars.highlighted.info.name===n.name)&&(e.vars.highlighted&&e.vars.highlighted!==f&&shmi.removeClass(e.vars.highlighted.base,"active"),e.vars.highlighted=f,shmi.addClass(c,"active"));const{MouseListener:s,TouchListener:a}=shmi.requires("visuals.io"),l={onPress:()=>{},onClick:()=>{const s=e.vars.highlighted;t.setGraphOptions(n.name,{highlight:null===s||s!==f})}};e.vars.listeners.push(new s(c,l),new a(c,l))}return f})),e.vars.valueInfos.forEach((t=>{t.base&&e.vars.elements.valueAnchor.appendChild(t.base)})),e.isLocked()||e.vars.listeners.forEach((e=>{e.enable()}))}function loadStyleImages(e,t){if(!e.vars.elements.styleIconTemplate)return[];return t.map((t=>{const s=e.vars.elements.styleIconTemplate.content.cloneNode(!0).querySelector("svg");if(s){const e=s.querySelector(".curve-line");e&&e.style.setProperty("fill",t.value.strokeStyle);const n=s.querySelector(".curve-fill");return n&&n.style.setProperty("fill",t.value.fillStyle),`data:image/svg+xml;base64,${btoa(s.outerHTML)}`}return null})).filter((e=>null!==e))}const s={className:"iq-trend-legend",uiType:e,isContainer:!1,config:{"class-name":"iq-trend-legend",name:null,template:"default/iq-trend-legend","trend-widget":null,"show-unit":!0},configSchema:null,vars:{trendWidget:null,elements:{valueAnchor:null,valueInfoTemplate:null,styleIconTemplate:null},styleImages:[],defaultStyleImage:null,inactiveImage:null,valueInfos:[],infoToken:null,optionsToken:null,tokens:[],listeners:[],highlighted:null},imports:{},events:[],prototypeExtensions:{onInit:function(){const e=this;e.vars.elements.valueAnchor=shmi.getUiElement("value-anchor",e.element),e.vars.elements.valueInfoTemplate=shmi.getUiElement("value-info-template",e.element),e.vars.elements.styleIconTemplate=shmi.getUiElement("style-icon-template",e.element),e.vars.elements.valueAnchor&&"vertical"===e.config.orientation&&shmi.addClass(e.vars.elements.valueAnchor,"vertical")},onEnable:function(){const{elements:t}=this.vars;if(t.valueAnchor&&t.valueInfoTemplate&&t.styleIconTemplate){if(null!==this.config["trend-widget"]){const e=shmi.ctrl(this.config["trend-widget"]);e&&e.isActive()&&onTrendEnable(this,e),function attachTrendListeners(e){e.vars.tokens.push(shmi.listen("enable",(function onTrendEnableHandler(t){nameOrNodeHandleMatches(e.config["trend-widget"],t.source)&&onTrendEnable(e,t.source)}),{"source.uiType":"iq-trend"})),e.vars.tokens.push(shmi.listen("disable",(function onTrendDisableHandler(t){nameOrNodeHandleMatches(e.config["trend-widget"],t.source)&&onTrendDisable(e,t.source)}),{"source.uiType":"iq-trend"}))}(this)}}else console.error(`[${e}] template is missing required elements.`)},onDisable:function(){onTrendDisable(this),this.vars.tokens.forEach((e=>{e.unlisten()})),this.vars.tokens=[]},onDelete:function(){},onLock:function(){shmi.addClass(this.element,"locked"),this.vars.listeners.forEach((e=>{e.disable()}))},onUnlock:function(){shmi.removeClass(this.element,"locked"),this.vars.listeners.forEach((e=>{e.enable()}))}}};shmi.requires("visuals.tools.control-generator").generate(s)}(),function(){"use strict";const e="iq-trend-live",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1);t.fLog,t.log;function updateButtonState(e,t){t?(shmi.removeClass(e.vars.elements.pauseButton,"active"),shmi.addClass(e.vars.elements.playButton,"active")):(shmi.removeClass(e.vars.elements.playButton,"active"),shmi.addClass(e.vars.elements.pauseButton,"active"))}function onTrendEnable(e,t){e.vars.trendWidget=t,e.isLocked()||shmi.removeClass(e.element,"locked"),updateButtonState(e,t.isLive()),e.vars.tokens.push(t.listen("live",(t=>{updateButtonState(e,t.detail.isLive)})))}function onTrendDisable(e){e.vars.trendWidget=null,e.isActive()&&!e.isLocked()&&shmi.addClass(e.element,"locked")}function nameOrNodeHandleMatches(e,t){const{HANDLE_PREFIX:s,getNodeHandle:n}=shmi.requires("visuals.tools.nodes");return"string"==typeof e&&e.startsWith(s)?n(t)===e.replace(s,""):e===t.getName()}const s={className:"iq-trend-live",uiType:e,isContainer:!1,config:{"class-name":"iq-trend-live",name:null,template:"default/iq-trend-live","trend-widget":null,orientation:"horizontal"},configSchema:null,vars:{trendWidget:null,elements:{playButton:null,pauseButton:null},tokens:[],listeners:[]},imports:{},events:[],prototypeExtensions:{onInit:function(){const e=this,{MouseListener:t,TouchListener:s}=shmi.requires("visuals.io");if(e.vars.elements.playButton=shmi.getUiElement("play-button",e.element),e.vars.elements.pauseButton=shmi.getUiElement("pause-button",e.element),"vertical"===e.config.orientation&&shmi.addClass(e.element,"vertical"),e.vars.elements.playButton&&e.vars.elements.pauseButton){const n={onClick:()=>{e.vars.trendWidget&&!e.vars.trendWidget.isLive()&&e.vars.trendWidget.setLive(!0)}};e.vars.listeners.push(new t(e.vars.elements.playButton,n),new s(e.vars.elements.playButton,n));const a={onClick:()=>{e.vars.trendWidget&&e.vars.trendWidget.isLive()&&e.vars.trendWidget.setLive(!1)}};e.vars.listeners.push(new t(e.vars.elements.pauseButton,a),new s(e.vars.elements.pauseButton,a))}},onEnable:function(){const{elements:t}=this.vars;if(t.playButton&&t.pauseButton){if(null!==this.config["trend-widget"]){const e=shmi.ctrl(this.config["trend-widget"]);e&&e.isActive()&&onTrendEnable(this,e),function attachTrendListeners(e){e.vars.tokens.push(shmi.listen("enable",(function onTrendEnableHandler(t){nameOrNodeHandleMatches(e.config["trend-widget"],t.source)&&onTrendEnable(e,t.source)}),{"source.uiType":"iq-trend"})),e.vars.tokens.push(shmi.listen("disable",(function onTrendDisableHandler(t){nameOrNodeHandleMatches(e.config["trend-widget"],t.source)&&onTrendDisable(e,t.source)}),{"source.uiType":"iq-trend"}))}(this)}this.vars.listeners.forEach((e=>{e.enable()}))}else console.error(`[${e}] template is missing required elements.`)},onDisable:function(){onTrendDisable(this),this.vars.tokens.forEach((e=>{e.unlisten()})),this.vars.tokens=[],this.vars.listeners.forEach((e=>{e.disable()}))},onDelete:function(){},onLock:function(){shmi.addClass(this.element,"locked"),this.vars.listeners.forEach((e=>{e.disable()}))},onUnlock:function(){shmi.removeClass(this.element,"locked"),this.vars.listeners.forEach((e=>{e.enable()}))}}};shmi.requires("visuals.tools.control-generator").generate(s)}(),function(){"use strict";const e="iq-trend-select",t="iq-trend-select",s=shmi.requires("visuals.tools.logging").createLogger(t,!0,!1);s.fLog,s.log;function onTrendEnable(e,t){e.vars.trendWidget=t,e.vars.styleImages=loadStyleImages(e,t.getValueStyles()),e.vars.infoToken=t.listen("value-info",(t=>{e.vars.grid.refresh()}))}function nameOrNodeHandleMatches(e,t){const{HANDLE_PREFIX:s,getNodeHandle:n}=shmi.requires("visuals.tools.nodes");return"string"==typeof e&&e.startsWith(s)?n(t)===e.replace(s,""):e===t.getName()}function loadStyleImages(e,t){if(!e.vars.elements.styleIconTemplate)return[];return t.map((t=>{const s=document.createElement("div");s.innerHTML=e.vars.elements.styleIconTemplate.innerHTML;const n=s.querySelector("svg");if(n){const e=n.querySelector(".curve-line");e&&e.style.setProperty("fill",t.value.strokeStyle);const a=n.querySelector(".curve-fill");return a&&a.style.setProperty("fill",t.value.fillStyle),`data:image/svg+xml;base64,${btoa(s.innerHTML)}`}return null})).filter((e=>null!==e))}const n={className:e,uiType:t,isContainer:!0,config:{"class-name":"iq-trend-select",name:null,template:"default/iq-trend-select","trend-widget":null,"label-mode":"label",settingsDialogOptions:{}},configSchema:null,vars:{trendWidget:null,elements:{tableAnchor:null,styleIconTemplate:null},styleImages:[],defaultStyleImage:null,grid:null,infoToken:null,tokens:[],storedSettings:{}},imports:{},events:[],prototypeExtensions:{onInit:function(){const t=this,s=shmi.requires("visuals.controls.iqtrendselect.grid"),n=shmi.requires("visuals.session.DataGridManager"),a=shmi.requires("visuals.core.TrendManager2");let l=null;do{l=e+"-"+Math.random().toString(36).substr(2,9)}while(null!==n.getGrid(l));t.vars.elements.styleIconTemplate=shmi.getUiElement("style-icon-template",t.element),t.vars.grid=s.create({name:l,fields:["name","label","options","selected","image-url"],index:["name"],mode:s.FILTER_MODE_OR},(e=>{if(t.vars.trendWidget){const s=t.vars.trendWidget.getTrendInfo(),n=t.vars.trendWidget.getValueInfo(),l=t.vars.trendWidget.getValueStyles(),o=t.vars.trendWidget.getSelectedValues(),r=[];s||e([]),t.vars.styleImages=loadStyleImages(t,l),t.vars.defaultStyleImage=loadStyleImages(t,[t.vars.trendWidget.getDefaultStyle()]),o.forEach((e=>{e.options&&"number"==typeof e.options.scaleGroup&&!r.includes(e.options.scaleGroup)&&r.push(e.options.scaleGroup)})),a.getInfo(s.name).then((s=>{if(s&&Array.isArray(s.items)){const a=s.items.map(((e,s)=>{const a=o.find((t=>t.name===e.name));return[{type:shmi.c("TYPE_STRING"),value:e.name,min:null,max:null},{type:shmi.c("TYPE_STRING"),value:e.label?shmi.localize(e.label):e.name,min:null,max:null},{type:shmi.c("TYPE_STRING"),value:JSON.stringify({data:a||null,scaleGroups:r,styles:l,item:e}),min:null,max:null},{type:shmi.c("TYPE_BOOL"),value:n&&n[e.name]?1:0,min:null,max:null},{type:shmi.c("TYPE_STRING"),value:a&&a.options&&"number"==typeof a.options.style?t.vars.styleImages[a.options.style]:"",min:null,max:null}]}));e(a)}else e([])})).catch((t=>{console.error("Error retrieving trend info:",t),e([])}))}else e([])})),t.vars.elements.tableAnchor=shmi.getUiElement("table-anchor",t.element),t.vars.elements.tableAnchor&&shmi.createControl("complex-table2",t.vars.elements.tableAnchor,((e,t="label",s)=>({label:"Trend Select Table",table:e,name:"trend-select-table","class-name":"complex-table2 trend-item-selection","field-datagrid-col-map":{selected:3,name:0,label:1,options:2,"image-url":4},"default-field-control-map":{selected:{"ui-type":"iq-checkbox",config:{"class-name":"iq-checkbox iq-variable-01",template:"default/iq-checkbox.iq-variant-01",label:""}},name:{"ui-type":"iq-label",config:{"class-name":"iq-label iq-variant-01",template:"default/iq-label.iq-variant-01"}},label:{"ui-type":"iq-label",config:{"class-name":"iq-label variant-01",template:"default/iq-label.iq-variant-01"}},options:{"ui-type":"local-script",config:{module:"visuals.controls.iqtrendselect.ls.settings",handle:s}},"image-url":{"ui-type":"local-script",config:{module:"visuals.controls.iqtrendselect.ls.style",handle:s}}},"default-field-headers":{selected:" ",name:"${iqtrendselect.table.value.header}",label:"${iqtrendselect.table.value.header}",options:" ","image-url":" "},_comment:"expr is passed to expr parameter array of shmi.visuals.core.DataGridManager.setFilter",filters:[],"default-layout":{"class-name":"layout-std",_comment:"default == no additional css layout class","column-org":{col1:{fields:["selected"],"column-width":"10%"},col2:{fields:["label"===t?"label":"name"],"column-width":"40%"},col3:{fields:["image-url"],"column-width":"10%"},col4:{fields:["options"],"column-width":"10%"}},"line-height":"var(--table-row-height)"},"sortable-fields":["selected","name","label"],"delete-selected-rows":!1,"show-nof-rows":!0,"show-buttons-table-min-width-px":400,"text-mode":"SINGLELINE","responsive-layouts":[],"default-nof-buffered-rows":60,"buffer-size":500,quicksearch:{enable:!0,remember:!0,fields:["name","label"]},"select-mode":"SINGLE","show-select-boxes":!1}))(l,t.config["label-mode"],shmi.requires("visuals.tools.nodes").getNodeHandle(t)),"DIV")},onEnable:function(){if(null!==this.config["trend-widget"]){const e=shmi.ctrl(this.config["trend-widget"]);e&&e.isActive()&&onTrendEnable(this,e),function attachTrendListeners(e){e.vars.tokens.push(shmi.listen("enable",(function onTrendEnableHandler(t){nameOrNodeHandleMatches(e.config["trend-widget"],t.source)&&onTrendEnable(e,t.source)}),{"source.uiType":"iq-trend"})),e.vars.tokens.push(shmi.listen("disable",(function onTrendDisableHandler(t){nameOrNodeHandleMatches(e.config["trend-widget"],t.source)&&function onTrendDisable(e){e.vars.trendWidget=null,e.vars.infoToken.unlisten(),e.vars.infoToken=null}(e,t.source)}),{"source.uiType":"iq-trend"}))}(this)}this.controls.forEach((e=>{e.enable()})),this.vars.tokens.push(shmi.listen("grid-changed",(e=>{if(!this.vars.trendWidget)return;const t=e.source.getRowData(e.detail.row);if(t)if(1===e.detail.value){const e=function getValueSettings(e,t,s){const n=e.vars.storedSettings[t]??null,a=e.vars.trendWidget.getSelectedValues(),l=e.vars.trendWidget.getValueStyles(),o=a.map((e=>e.options&&"number"==typeof e.options.style?e.options.style:null)).filter((e=>null!==e)),r=Object.values(e.vars.storedSettings).map((e=>e.options.style)),c=l.findIndex(((e,t)=>!o.includes(t)&&!r.includes(t))),u=c>-1?c:l.findIndex(((e,t)=>!o.includes(t))),m=JSON.parse(s[2].value);return n?n.options:{fillCurve:!1,drawTolerance:!1,style:"number"==typeof u?u:void 0,scale:{location:"left",hidden:"string"===m.item.data_type},limits:{mode:"config"},scaleGroup:null}}(this,t[0].value,t);this.vars.trendWidget.addGraphValue(t[0].value,e),delete this.vars.storedSettings[t[0].value]}else!function storeValueSettings(e,t){if(e.vars.trendWidget){const s=e.vars.trendWidget.getSelectedValues().find((({name:e})=>e===t));s&&(e.vars.storedSettings[t]=s)}}(this,t[0].value),this.vars.trendWidget.removeGraph(t[0].value)}),{"detail.grid.name":this.vars.grid.name,"detail.field":"selected"})),this.vars.tokens.push(shmi.listen("grid-changed",(e=>{if(this.vars.trendWidget){const t=JSON.parse(e.detail.value);this.vars.trendWidget.setGraphOptions(t.data.name,t.data.options),this.vars.grid.refresh()}}),{"detail.grid.name":this.vars.grid.name,"detail.field":"options"}))},getStyleImages(){return shmi.cloneObject(this.vars.styleImages)},getDefaultStyleImage(){return this.vars.defaultStyleImage},onDisable:function(){this.controls.forEach((e=>{e.disable()})),this.vars.tokens.forEach((e=>{e.unlisten()})),this.vars.tokens=[]},onDelete:function(){const e=shmi.requires("visuals.controls.iqtrendselect.grid");this.vars.grid&&(e.remove(this.vars.grid.name),this.vars.grid=null)},onLock:function(){shmi.addClass(this.element,"locked")},onUnlock:function(){shmi.removeClass(this.element,"locked")}}};shmi.requires("visuals.tools.control-generator").generate(n)}(),function(){const e=shmi.pkg("visuals.controls.iqtrendselect.dialog"),t="trend-select-config-dialog";function getControllerConfig(e){return[{name:t,slot:e}]}function widgetsReady(e){return["selectStyle","checkTolerance","checkFill","selectLimitsMode","inputLimitsStep","inputLimitsMin","inputLimitsMax","selectScaleLocation","checkScaleHide","selectScaleGroup","buttonScaleAddGroup","buttonApply"].every((t=>!!e.getInstance(t)))}function handleSlotEvent(e,t,s,n){if(!e.data.ignoreEvents)switch(t){case"dialog":e.data.resolved||(e.data.resolved=!0,e.data.resolve(null)),shmi.deleteControl(e.getInstance("dialog"));break;case"selectLimitsMode":updateState(e);break;case"buttonApply":e.data.resolved=!0,e.data.resolve(function getSlotValues(e){const t={style:e.getInstance("selectStyle").getValue(),drawTolerance:e.getInstance("checkTolerance").getValue(),fillCurve:e.getInstance("checkFill").getValue(),limits:{mode:e.getInstance("selectLimitsMode").getValue(),step:e.getInstance("inputLimitsStep").getValue(),min:e.getInstance("inputLimitsMin").getValue(),max:e.getInstance("inputLimitsMax").getValue()},scale:{location:e.getInstance("selectScaleLocation").getValue(),hidden:e.getInstance("checkScaleHide").getValue()},scaleGroup:e.getInstance("selectScaleGroup").getValue()};if("config"===t.limits.mode)delete t.limits.step,delete t.limits.min,delete t.limits.max;else if("auto"===t.limits.mode)0===t.limits.step&&(t.limits.step=null),delete t.limits.min,delete t.limits.max;else if(delete t.limits.step,t.limits.min>t.limits.max){const e=t.limits.min;t.limits.min=t.limits.max,t.limits.max=e}return t}(e)),e.getInstance("dialog").hide();break;case"buttonScaleAddGroup":!function handleAddScalegroup(e){e.data.ignoreEvents=!0;const t=e.getInstance("selectScaleGroup"),s=t.getOptions(),n=s.map((e=>e.value)).filter((e=>null!==e));let a=1;for(;n.includes(a);)a+=1;s.push({label:`${a}`,value:a}),t.setOptions(s),t.setValue(a),e.getInstance("checkScaleHide").setValue(!1),e.data.ignoreEvents=!1}(e)}}function getDialogController(e,s,n){return{name:t,slots:{dialog:{ui:"dialog-box",events:["close"]},selectStyle:{ui:"iq-select-box",optional:!0,events:["change"]},checkTolerance:{ui:"iq-checkbox",optional:!0,events:["change"]},checkFill:{ui:"iq-checkbox",optional:!0,events:["change"]},selectLimitsMode:{ui:"iq-select-box",optional:!0,events:["change"]},inputLimitsStep:{ui:"iq-input-field",optional:!0,events:["change"]},inputLimitsMin:{ui:"iq-input-field",optional:!0,events:["change"]},inputLimitsMax:{ui:"iq-input-field",optional:!0,events:["change"]},selectScaleLocation:{ui:"iq-select-box",optional:!0,events:["change"]},checkScaleHide:{ui:"iq-checkbox",optional:!0,events:["change"]},selectScaleGroup:{ui:"iq-select-box",optional:!0,events:["change"]},buttonScaleAddGroup:{ui:"iq-button",optional:!0,events:["click"]},buttonApply:{ui:"iq-button",optional:!0,events:["click"]}},onChange:function(t,n){widgetsReady(t)&&!t.data.contentSet&&(!function initStyles(e,t){e.getInstance("selectStyle").setOptions(t.map(((e,t)=>({label:`\${iqtrendselect.settings.style.option} ${t+1}`,value:t,"icon-src":e}))))}(t,s),function setSlotValues(e,t){const{cellInfo:s}=e.data,n=[{label:"${iqtrendselect.settings.scalegroup.none}",value:null}];e.data.ignoreEvents=!0,s.scaleGroups.forEach((e=>{n.push({label:`${e}`,value:e})})),e.getInstance("selectScaleGroup").setOptions(n),e.getInstance("selectStyle").setValue(t.style),e.getInstance("checkTolerance").setValue(!!t.drawTolerance),e.getInstance("checkFill").setValue(!!t.fillCurve),e.getInstance("selectLimitsMode").setValue(t.limits&&t.limits.mode?t.limits.mode:"config"),e.getInstance("inputLimitsStep").setValue(t.limits&&"number"==typeof t.limits.step?t.limits.step:0),e.getInstance("inputLimitsMin").setValue(t.limits&&"number"==typeof t.limits.min?t.limits.min:0),e.getInstance("inputLimitsMax").setValue(t.limits&&"number"==typeof t.limits.max?t.limits.max:100),e.getInstance("selectScaleLocation").setValue(t.scale&&"string"==typeof t.scale.location?t.scale.location:"left"),e.getInstance("checkScaleHide").setValue(!(!t.scale||"boolean"!=typeof t.scale.hidden)&&t.scale.hidden),e.getInstance("selectScaleGroup").setValue("number"==typeof t.scaleGroup?t.scaleGroup:null),e.data.ignoreEvents=!1,updateState(e)}(t,e.cellInfo&&e.cellInfo.data?e.cellInfo.data.options:{}),updateState(t),t.data.contentSet=!0)},onEnable:function(t){t.data.cellInfo=e.cellInfo,t.data.resolve=n},onDisable:function(e){},onEvent:handleSlotEvent,data:{cellInfo:null,ignoreEvents:!1,resolve:null,resolved:!1,contentSet:!1}}}function updateState(e){if(!widgetsReady(e))return;const t=e.getInstance("selectLimitsMode"),s=e.getInstance("inputLimitsStep"),n=e.getInstance("inputLimitsMin"),a=e.getInstance("inputLimitsMax");switch(t.getValue()){case"config":shmi.addClass(s.element,"hidden"),shmi.addClass(n.element,"hidden"),shmi.addClass(a.element,"hidden");break;case"auto":shmi.removeClass(s.element,"hidden"),shmi.addClass(n.element,"hidden"),shmi.addClass(a.element,"hidden");break;case"manual":shmi.addClass(s.element,"hidden"),shmi.removeClass(n.element,"hidden"),shmi.removeClass(a.element,"hidden")}}e.getDialog=(e,t=[])=>new Promise(((s,n)=>{const a=document.querySelector("[data-ui=container]"),l=a?shmi.getControlByElement(a):null;if(l){const a=function getDialogLayout(e,t,s,n){return{ui:"dialog-box",config:{name:"curveSettingsDialog","class-name":e.dialogClassName||"dialog-box iq-trend-select-dialog",template:e.dialogTemplate||"default/dialog-box","initial-state":"hidden","top-level":!0,title:"${iqtrendselect.settings.dialogTitle}","content-template":null,"tab-limit":!1,_controllers_:getControllerConfig("dialog")},controller:getDialogController(e,t,s),children:[{ui:"container",config:{ui:"container","class-name":"iq-container settings-content",type:"iqflex","flex-orientation":"column","flex-none":!0,"flex-wrap":!1,"flex-primary-align":"start","flex-secondary-align":"stretch","flex-line-align":"start",name:"content",template:null},children:[{ui:"iq-select-box",config:{"class-name":e.selectStyleClassName||"iq-select-box iq-variant-01 style-select",template:e.selectStyleTemplate||"default/iq-select-box.iq-variant-01",name:"styleSelect",ui:"iq-select-box",label:"${iqtrendselect.settings.style.label}",item:null,"auto-label":!0,"icon-src":null,"icon-title":null,"icon-class":null,"show-icon":!1,"show-text":!0,"no-selection-label":"---",selected:-1,options:[],_controllers_:getControllerConfig("selectStyle")},children:null},{ui:"iq-checkbox",config:{"class-name":e.checkFillClassName||"iq-checkbox iq-variant-01 fill-curve",template:e.checkFillTemplate||"default/iq-checkbox.iq-variant-01",name:"fillBox",ui:"iq-checkbox",label:"${iqtrendselect.settings.fill.label}",item:null,"auto-label":!0,type:2,"show-text":!0,"show-icon":!1,"icon-src":null,tooltip:null,"icon-class":null,"on-value":!0,"off-value":!1,"pressed-class":"pressed","confirm-on":!1,"confirm-off":!1,"confirm-on-text":"${V_CONFIRM_ON}","confirm-off-text":"${V_CONFIRM_OFF}",_controllers_:getControllerConfig("checkFill")},children:null},{ui:"iq-checkbox",config:{"class-name":e.checkToleranceClassName||"iq-checkbox iq-variant-01 draw-tolerance",template:e.checkToleranceTemplate||"default/iq-checkbox.iq-variant-01",name:"toleranceBox",ui:"iq-checkbox",label:"${iqtrendselect.settings.tolerance.label}",item:null,"auto-label":!0,type:2,"show-text":!0,"show-icon":!1,"icon-src":null,tooltip:null,"icon-class":null,"on-value":!0,"off-value":!1,"pressed-class":"pressed","confirm-on":!1,"confirm-off":!1,"confirm-on-text":"${V_CONFIRM_ON}","confirm-off-text":"${V_CONFIRM_OFF}",_controllers_:getControllerConfig("checkTolerance")},children:null},{ui:"container",config:{"class-name":"iq-container",type:"iqflex","flex-orientation":"column","flex-none":!0,"flex-wrap":!1,"flex-primary-align":"start","flex-secondary-align":"stretch","flex-line-align":"start",name:"limitsContainer",template:null},children:[{ui:"iq-label",config:{"class-name":e.labelLimitsClassName||"iq-label iq-variant-01 limits-header",template:e.labelLimitsTemplate||"default/iq-label.iq-variant-01",name:"limitsLabel",ui:"iq-label",item:null,type:null,"auto-type":!0,"decimal-delimiter":".",precision:2,"auto-precision":!0,options:[],pattern:null,tooltip:null,"value-as-tooltip":!1,text:"${iqtrendselect.settings.limits.header}"},children:null},{ui:"iq-select-box",config:{"class-name":e.selectLimitsModeClassName||"iq-select-box iq-variant-01 limits-select",template:e.selectLimitsModeTemplate||"default/iq-select-box.iq-variant-01",name:"limitModeSelect",ui:"iq-select-box",label:"${iqtrendselect.settings.limits.mode.label}",item:null,"auto-label":!0,"icon-src":null,"icon-title":null,"icon-class":null,"show-icon":!1,"show-text":!0,"no-selection-label":"---",selected:-1,options:[{label:"${iqtrendselect.settings.limits.mode.config}",value:"config",mask:null,"icon-src":null,"icon-title":null,"icon-class":null},{label:"${iqtrendselect.settings.limits.mode.auto}",value:"auto",mask:null,"icon-src":null,"icon-title":null,"icon-class":null},{label:"${iqtrendselect.settings.limits.mode.manual}",value:"manual",mask:null,"icon-src":null,"icon-title":null,"icon-class":null}],_controllers_:getControllerConfig("selectLimitsMode")},children:null},{ui:"iq-input-field",config:{"class-name":e.inputLimitsStepClassName||"iq-input-field iq-variant-01 step-input",template:e.inputLimitsStepTemplate||"default/iq-input-field.iq-variant-01",name:"iq-input-field",ui:"iq-input-field",label:"${iqtrendselect.settings.limits.step.label}",item:null,min:0,max:null,"value-alignment":"left","numeric-class":"numeric",unit:"[Unit]","unit-text":"","auto-label":!1,"auto-unit-text":!1,"unit-scale":1,"auto-min":!0,"auto-max":!0,type:3,"auto-type":!1,"decimal-delimiter":".","numpad-enabled":!1,precision:-1,"auto-precision":!0,"icon-src":null,"icon-title":null,"icon-class":null,multiline:!1,"show-icon":!1,tooltip:null,_controllers_:getControllerConfig("inputLimitsStep")},children:null},{ui:"iq-input-field",config:{"class-name":e.inputLimitsMinClassName||"iq-input-field iq-variant-01 min-input",template:e.inputLimitsMinTemplate||"default/iq-input-field.iq-variant-01",name:"iq-input-field_1",ui:"iq-input-field",label:"${iqtrendselect.settings.limits.min.label}",item:null,min:null,max:null,"value-alignment":"left","numeric-class":"numeric",unit:"[Unit]","unit-text":"","auto-label":!1,"auto-unit-text":!1,"unit-scale":1,"auto-min":!0,"auto-max":!0,type:3,"auto-type":!1,"decimal-delimiter":".","numpad-enabled":!1,precision:-1,"auto-precision":!0,"icon-src":null,"icon-title":null,"icon-class":null,multiline:!1,"show-icon":!1,tooltip:null,_controllers_:getControllerConfig("inputLimitsMin")},children:null},{ui:"iq-input-field",config:{"class-name":e.inputLimitsMaxClassName||"iq-input-field iq-variant-01 max-input",template:e.inputLimitsMaxTemplate||"default/iq-input-field.iq-variant-01",name:"iq-input-field_2",ui:"iq-input-field",label:"${iqtrendselect.settings.limits.max.label}",item:null,min:null,max:null,"value-alignment":"left","numeric-class":"numeric",unit:"[Unit]","unit-text":"","auto-label":!1,"auto-unit-text":!1,"unit-scale":1,"auto-min":!0,"auto-max":!0,type:3,"auto-type":!1,"decimal-delimiter":".","numpad-enabled":!1,precision:-1,"auto-precision":!0,"icon-src":null,"icon-title":null,"icon-class":null,multiline:!1,"show-icon":!1,tooltip:null,_controllers_:getControllerConfig("inputLimitsMax")},children:null}]},{ui:"container",config:{"class-name":"iq-container",type:"iqflex","flex-orientation":"column","flex-none":!0,"flex-wrap":!1,"flex-primary-align":"start","flex-secondary-align":"stretch","flex-line-align":"start",name:"scaleContainer",template:null},children:[{ui:"iq-label",config:{"class-name":e.labelScaleClassName||"iq-label iq-variant-01 scale-header",template:e.labelScaleTemplate||"default/iq-label.iq-variant-01",name:"scaleLabel",ui:"iq-label",item:null,type:null,"auto-type":!0,"decimal-delimiter":".",precision:2,"auto-precision":!0,options:[],pattern:null,tooltip:null,"value-as-tooltip":!1,text:"${iqtrendselect.settings.scale.header}"},children:null},{ui:"iq-select-box",config:{"class-name":e.selectScaleLocationClassName||"iq-select-box iq-variant-01 location-select list-on-top",template:e.selectScaleLocationTemplate||"default/iq-select-box.iq-variant-01",name:"locationSelect",ui:"iq-select-box",label:"${iqtrendselect.settings.scale.location.label}",item:null,"auto-label":!0,"icon-src":null,"icon-title":null,"icon-class":null,"show-icon":!1,"show-text":!0,"no-selection-label":"---",selected:-1,options:[{label:"${iqtrendselect.settings.scale.location.left}",value:"left",mask:null,"icon-src":null,"icon-title":null,"icon-class":null},{label:"${iqtrendselect.settings.scale.location.right}",value:"right",mask:null,"icon-src":null,"icon-title":null,"icon-class":null}],_controllers_:getControllerConfig("selectScaleLocation")},children:null},{ui:"iq-checkbox",config:{"class-name":e.checkScaleHideClassName||"iq-checkbox iq-variant-01 hide-scale",template:e.checkScaleHideTemplate||"default/iq-checkbox.iq-variant-01",name:"hiddenBox",ui:"iq-checkbox",label:"${iqtrendselect.settings.scale.hide.label}",item:null,"auto-label":!0,type:2,"show-text":!0,"show-icon":!1,"icon-src":null,tooltip:null,"icon-class":null,"on-value":!0,"off-value":!1,"pressed-class":"pressed","confirm-on":!1,"confirm-off":!1,"confirm-on-text":"${V_CONFIRM_ON}","confirm-off-text":"${V_CONFIRM_OFF}",_controllers_:getControllerConfig("checkScaleHide")},children:null},{ui:"container",config:{"class-name":"iq-container",type:"iqflex","flex-orientation":"row","flex-none":!0,"flex-wrap":!0,"flex-primary-align":"start","flex-secondary-align":"stretch","flex-line-align":"start",name:"buttonContainer",template:null},children:[{ui:"iq-select-box",config:{"class-name":e.selectScaleGroupClassName||"iq-select-box iq-variant-01 scalegroup-select list-on-top",template:e.selectScaleGroupTemplate||"default/iq-select-box.iq-variant-01",name:"scaleGroupSelect",ui:"iq-select-box",label:"${iqtrendselect.settings.scalegroup.label}",item:null,"auto-label":!0,"icon-src":null,"icon-title":null,"icon-class":null,"show-icon":!1,"show-text":!0,"no-selection-label":"---",selected:-1,options:[],_controllers_:getControllerConfig("selectScaleGroup")},children:null},{ui:"iq-button",config:{"class-name":e.addGroupClassName||"iq-button iq-variant-01 add-scale-group",template:e.addGroupTemplate||"default/iq-button.iq-variant-01",action:null,"show-text":!0,"disable-item-lock":!1,monoflop:!1,"monoflop-value":1,"monoflop-interval":100,name:"scaleGroupAdd",ui:"iq-button",label:"${iqtrendselect.settings.scalegroup.add}",item:null,"auto-label":!1,"icon-src":null,"icon-title":null,"icon-class":null,"label-from-item":!1,"write-bool":!1,"action-release":null,"action-while-pressed":null,"interval-while-pressed":null,"action-press":null,"disable-alarms":!1,"show-icon":!1,"on-value":!0,"off-value":!1,tooltip:null,_controllers_:getControllerConfig("buttonScaleAddGroup")},children:null}]}]}]},{ui:"container",config:{"class-name":"iq-container button-container",type:"iqflex","flex-orientation":"row","flex-none":!0,"flex-wrap":!0,"flex-primary-align":"end","flex-secondary-align":"stretch","flex-line-align":"start",name:"buttonContainer",template:null},children:[{ui:"iq-button",config:{"class-name":e.applyClassName||"iq-button iq-variant-01 apply",template:e.applyTemplate||"default/iq-button.iq-variant-01",action:null,"show-text":!0,"disable-item-lock":!1,monoflop:!1,"monoflop-value":1,"monoflop-interval":100,name:"commentApply",ui:"iq-button",label:"${iqtrendselect.settings.apply}",item:null,"auto-label":!1,"icon-src":null,"icon-title":null,"icon-class":null,"label-from-item":!1,"write-bool":!1,"action-release":null,"action-while-pressed":null,"interval-while-pressed":null,"action-press":null,"disable-alarms":!1,"show-icon":!1,"on-value":!0,"off-value":!1,tooltip:null,_controllers_:getControllerConfig("buttonApply")},children:null}]}]}}(e,t,s);a&&l.addControl(a,((e,t)=>{e?n(e):t[0].show()}))}else n(new Error("Base container element not found."))}))}(),function(){var e="visuals.controls.iqtrendselect.grid",t=shmi.pkg(e);function sortGridData(s,n,a){s.sort(function getColumnSorter(t){return function columnSorter(s,n){if(!s[t]||!n[t])throw new Error(e+" invalid row index: "+t);return(s=String(s[t].value).toUpperCase())<(n=String(n[t].value).toUpperCase())?-1:s>n?1:0}}(n)),a===t.SORT_ORDER_DESC&&s.reverse()}function filterGridData(e,s,n,a){var l=shmi.requires("visuals.tools.iterate").iterateObject,o=null,r=!0,c={};return l(n,(function(e){null!==e&&(r=!1)})),e.forEach((function(e){l(n,(function(n,l){const u=s.indexOf(l);c[l]=c[l]||[],r?c[l].push(e):null!==n?(o=function convertFilterToRegExp(e){return e=(e=(e=(e=e.toLowerCase()).replace(/([.?*{}[\]():^$!])/g,"\\$1")).replace(/%/g,".*")).replace(/_/g,"."),RegExp("^"+e+"$")}(n))&&String(e[u].value).toLowerCase().match(o)&&c[l].push(e):a===t.FILTER_MODE_AND&&c[l].push(e)}))})),e.filter((function(e){let s=!1;return a===t.FILTER_MODE_OR?s=Object.keys(n).some((function(t){return-1!==c[t].indexOf(e)})):a===t.FILTER_MODE_AND&&(s=Object.keys(n).every((function(t){return-1!==c[t].indexOf(e)}))),s}))}function throwError(t){throw new Error(`[${e}] ${t}`)}function setGridData(e,t){if(e.nextRowId=0,e.indexMap={},e.totalRows>t.length){const s=e.totalRows-t.length;for(let n=0;n<s;n++)delete e.data[t.length+n]}t.forEach((function(t,s){e.insertRow(t,s,!0)})),e.totalRows=t.length,e._updateSubscriber()}t.FILTER_MODE_AND=1,t.FILTER_MODE_OR=2,t.SORT_ORDER_ASC=1,t.SORT_ORDER_DESC=2;const s=[];let n=!1;function checkQueue(){s.length&&!n&&(n=!0,s[0][0](s[0][1]))}t.create=function create(a,l){var o=shmi.requires("visuals.session.DataGridManager"),r=shmi.requires("visuals.tools.iterate.iterateObject"),c=shmi.requires("visuals.core"),u={},m=null,h=null,d=[],f=[];function onLoaded(e,t){n=!1,s.splice(0,1),Array.isArray(t)||throwError("callback parameter 'response' must be an array of row data"),d=t,m&&sortGridData(d,a.fields.indexOf(m.column),m.order),f=filterGridData(d,a.fields,u,a.mode),setGridData(h,f),e(),shmi.decouple((()=>{checkQueue()}))}return function checkOptions(e){const s=shmi.requires("visuals.session.DataGridManager");null!==e&&"object"==typeof e||throwError("parameter 'options' must be an object"),"string"==typeof e.name&&0!==e.name.trim().length||throwError("option `name` must be a non-empty string"),s.getGrid(e.name)&&throwError(`grid '${e.name}' already exists`),Array.isArray(e.fields)||throwError("option 'fields' must be an array of field names"),Array.isArray(e.index)||throwError("option 'index' must be an array of field names"),"number"==typeof e.mode&&-1!==[t.FILTER_MODE_OR,t.FILTER_MODE_AND].indexOf(e.mode)||throwError(`option 'mode' must either be '${t.FILTER_MODE_OR}' (OR) or '${t.FILTER_MODE_AND}' (AND)`)}(a),"function"!=typeof l&&throwError("parameter 'loadFunction' must be a function accepting a callback parameter to return an array of row data"),a.fields.forEach((function(e){u[e]=null})),(h=new c.DataGridDynamic(a.name,a.fields,!1,null,0,a.index)).onSubscribe=function onSubscribe(e,t,n){s.push([l,onLoaded.bind(null,n)]),checkQueue()},h.onSetOffset=function onSetOffset(e,t,s){shmi.raf(s)},h.onSetFilter=function onSetFilter(e,t,s){r(h.subscribers,(function(e,t){e.offset=0})),u[a.fields[e]]=t[0],f=filterGridData(d,a.fields,u,a.mode),setGridData(h,f),s()},h.onClearFilter=function onClearFilter(e,t){r(h.subscribers,(function(e,t){e.offset=0})),-1===e?r(u,(function(e,t){u[t]=null})):a.fields[e]&&(u[a.fields[e]]=null),f=filterGridData(d,a.fields,u,a.mode),setGridData(h,f),t()},h.onRefresh=function onRefresh(e){r(h.subscribers,(function(e,t){e.offset=0})),s.push([l,onLoaded.bind(null,e)]),checkQueue()},h.onSort=function onSort(e,s,n){r(h.subscribers,(function(e,t){e.offset=0})),(m=-1===e?null:{column:a.fields[e],order:"DESC"===s?t.SORT_ORDER_DESC:t.SORT_ORDER_ASC})&&sortGridData(d,a.fields.indexOf(m.column),m.order),f=filterGridData(d,a.fields,u,a.mode),setGridData(h,f),n()},h.onInsert=function onInsert(e,t,s,n){shmi.raf(n)},h.onDelete=function onDelete(e,t){shmi.raf(t)},h.onDeleteAll=function onDeleteAll(e){shmi.raf(e)},h._calcState=function _calcState(e){var t=this.subscribers[e],s={status:"OK"};return s.offset=t.offset,s.totalRows=this.totalRows,s},h.getGridData=()=>shmi.cloneObject(f),o.grids[a.name]=h,console.log(e,"created datagrid:",a.name),h},t.remove=function remove(e){const t=shmi.requires("visuals.session.DataGridManager");shmi.objectHasOwnProperty(t.grids,e)&&(t.grids[e].subscribers={},delete t.grids[e])}}(),function(){const e="visuals.controls.iqtrendselect.ls.settings",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),s=t.fLog;t.log;shmi.pkg(e).run=function(e){const t=[],s=shmi.requires("visuals.session.ItemManager"),n=s.getItemHandler();let a=null,l=null;e.vars=e.vars||{},a=shmi.createControl("iq-button",e.element.parentNode,{"class-name":"iq-button iq-variant-01 curve-settings",template:"default/iq-button.iq-variant-01",label:null,"show-icon":!0,"show-text":!1,"icon-src":"pics/system/controls/iq-trend-select/edit-dark.svg"},"DIV"),n.setValue=function(e){try{l=JSON.parse(e),l&&l.data?a.unlock():(a.lock(),l=null)}catch(e){l=null}},t.push(a.listen("click",(function(){const{HANDLE_PREFIX:t}=shmi.requires("visuals.tools.nodes");let n=[],a={cellInfo:l};const o=e.config.handle?shmi.ctrl(`${t}${e.config.handle}`):null;o&&(n=o.getStyleImages(),a=Object.assign(o.config.settingsDialogOptions||{},a)),shmi.requires("visuals.controls.iqtrendselect.dialog").getDialog(a,n||[]).then((t=>{null!==t&&(l.data.options=t,s.writeValue(e.config.item,JSON.stringify(l)))}))}))),e.config.item&&t.push(s.subscribeItem(e.config.item,n)),e.onDisable=function(){e.run=!1,t.forEach((function(e){e.unlisten()})),shmi.deleteControl(a)}},s("module loaded")}(),function(){const e="visuals.controls.iqtrendselect.ls.style",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),s=t.fLog;t.log;shmi.pkg(e).run=function(e){const t=[],s=shmi.requires("visuals.session.ItemManager"),n=s.getItemHandler();e.vars=e.vars||{};let a=null;n.setValue=function(t){t?(a||(a=document.createElement("img")),a.classList.add("style-image"),a.setAttribute("src",t),e.element.parentNode.appendChild(a)):a&&(a.parentNode.removeChild(a),a=null)},e.config.item&&t.push(s.subscribeItem(e.config.item,n)),e.onDisable=function(){e.run=!1,t.forEach((function(e){e.unlisten()})),a&&(a.parentNode.removeChild(a),a=null)}},s("module loaded")}(),function(){"use strict";const e="IqTrendSetSelect",t="iq-trend-set-select",s="webiq-trend-sets",n="webiq-widget-settings",a={"class-name":"iq-trend-set-select",name:null,template:"default/iq-trend-set-select",label:t,"trend-widget":null,"trend-sets-identifier":"trend-sets-1","storage-location":"localStorage","trend-sets":[],selected:null,"popup-location":"bottom","modified-marker":"(*)","remember-last-set":!1,layoutOptions:{selectBoxClassName:"iq-select-box iq-variant-01 set-select",selectBoxTemplate:"default/iq-select-box.iq-variant-01"},"fixed-set-icon":"pics/system/controls/iq-trend-set-select/fixed-set.svg"},l=shmi.requires("visuals.tools.logging").createLogger(t,!0,!1);l.fLog,l.log;function onTrendEnable(e,t){e.vars.trendWidget=t,updateTrendWidget(e),e.vars.trendWidgetTokens.push(t.listen("value-info",(t=>{checkModified(e)}))),e.vars.trendWidgetTokens.push(t.listen("graph-options",(t=>{checkModified(e)})))}function checkModified(e){if(e.vars.selected){const t=e.vars.trendSets.find((({name:t})=>t===e.vars.selected));if(t){const{isEqualDeep:s}=shmi.requires("visuals.tools.compare");t.fixed||s(e.vars.trendWidget.getSelectedValues(),t.values)?setModified(e,!1):setModified(e,!0)}}}function setModified(e,t){e.vars.modified=t,t?shmi.addClass(e.element,"modified"):shmi.removeClass(e.element,"modified")}function nameOrNodeHandleMatches(e,t){const{HANDLE_PREFIX:s,getNodeHandle:n}=shmi.requires("visuals.tools.nodes");return"string"==typeof e&&e.startsWith(s)?n(t)===e.replace(s,""):e===t.getName()}function loadTrendSets(e){switch(e.vars.storageLocation){case"localStorage":!function loadTrendSetsLocalStorage(e){const n=localStorage.getItem(s),a=shmi.requires("visuals.session.UserManager").currentUser.name;let l={};if(n)try{l=JSON.parse(n)}catch(e){console.error(`[${t}] could not parse saved selection:`,e)}l[a]=l[a]||{},l[a][e.vars.trendSetsIdentifier]=l[a][e.vars.trendSetsIdentifier]||[],e.vars.trendSets.push(...l[a][e.vars.trendSetsIdentifier])}(e);break;case"userData":!function loadTrendSetsUserData(e){const n=shmi.requires("visuals.session.UserManager").getUserData(`${s}:${e.vars.trendSetsIdentifier}`);let a=[];if(n)try{a=JSON.parse(n)}catch(e){console.error(`[${t}] could not parse saved selection:`,e)}e.vars.trendSets.push(...a)}(e);break;default:throw new Error(`Invalid storage location configured: ${e.vars.storageLocation}`)}e.vars.setsLoaded=!0}async function saveTrendSets(e){switch(e.vars.storageLocation){case"localStorage":!function saveTrendSetsLocalStorage(e){const n=localStorage.getItem(s),a=shmi.requires("visuals.session.UserManager").currentUser.name;let l={};if(n)try{l=JSON.parse(n)}catch(e){console.error(`[${t}] could not parse saved selection:`,e)}l[a]=l[a]||{},l[a][e.vars.trendSetsIdentifier]=e.vars.trendSets.filter((e=>!e.fixed)),localStorage.setItem(s,JSON.stringify(l,null,4))}(e);break;case"userData":await function saveTrendSetsUserData(e){const t=e.vars.trendSets.filter((e=>!e.fixed));return new Promise(((n,a)=>{shmi.requires("visuals.session.UserManager").setUserData({[`${s}:${e.vars.trendSetsIdentifier}`]:JSON.stringify(t,null,4)},((e,t)=>{t?a(t):n(e)}))}))}(e);break;default:throw new Error(`Invalid storage location configured: ${e.vars.storageLocation}`)}}async function updateTrendWidget(t){if(t.vars.trendWidget&&t.vars.selected){const s=t.vars.selected,n=t.vars.trendSets.find((({name:e})=>e===t.vars.selected));if(n){const a=t.vars.trendWidget.getTrendInfo(),l=n.values.map((e=>e.name));if("trend"===a.type&&a.name){const s=shmi.requires("visuals.core.TrendManager2");let o=null;try{o=await s.getInfo(a.name,l)}catch(e){console.error(`[trend2.info] error retrieving trend info for trend: ${t._name}:`,e)}const r=null===o?[]:o.items.map((e=>e.name));n.values=n.values.filter((t=>{const s=r.includes(t.name);return s||console.warn(`[${e}] item included in set is not present in trend '${a.name}': ${t.name}`),s}))}t.vars.trendWidget&&s===t.vars.selected&&t.vars.trendWidget.setSelectedValues(n.values)}}}function saveLastSet(e){if(e.config["remember-last-set"]){const s=shmi.requires("visuals.session.UserManager").currentUser.name,a=localStorage.getItem(n);let l={},o=shmi.requires("visuals.tools.nodes").getNodeHandle(e);if(o||(o=e.getName()),a)try{l=JSON.parse(a)}catch(e){console.error(`[${t}] could not parse saved widget settings:`,e)}l[s]=l[s]||{},l[s][t]=l[s][t]||{},l[s][t][o]=l[s][t][o]||{},l[s][t][o].selectedSet=shmi.cloneObject(e.vars.selected),localStorage.setItem(n,JSON.stringify(l))}}function updateSetOptions(e){if(e.vars.selectBox){if(e.vars.ignoreChange=!0,e.vars.selectBox.setOptions(e.vars.trendSets.map((({name:t,fixed:s})=>({label:t,tooltip:t,value:t,"icon-src":s&&e.config["fixed-set-icon"]?e.config["fixed-set-icon"]:null})))),e.vars.selectBox.initialized)e.vars.selectBox.setValue(e.vars.selected);else{const t=e.vars.trendSets.findIndex((({name:t})=>t===e.vars.selected));e.vars.selectBox.config.selected=t}e.vars.ignoreChange=!1}}const o={className:e,uiType:t,isContainer:!0,config:a,vars:{elements:{selectionAnchor:null},selectBox:null,trendWidget:null,trendSetsIdentifier:null,selected:null,trendSets:[],tokens:[],trendWidgetTokens:[],storageLocation:null,setsLoaded:!1,ignoreChange:!1,modified:!1},imports:{im:"visuals.session.ItemManager"},events:[],prototypeExtensions:{onInit:function(){const t=this;t.vars.trendSetsIdentifier=t.config["trend-sets-identifier"],t.vars.storageLocation=t.config["storage-location"],t.vars.selected=t.config.selected?t.config.selected:null,t.config["modified-marker"]&&t.element.style.setProperty("--modified-marker-content",`"${t.config["modified-marker"]} "`),t.vars.elements.selectionAnchor=shmi.getUiElement("selection-anchor",t.element),t.vars.elements.selectionAnchor?t.vars.selectBox=shmi.createControl("iq-select-box",t.vars.elements.selectionAnchor,{"class-name":(t.config.layoutOptions?.selectBoxClassName??"iq-select-box iq-variant-01 set-select")+("top"===t.config["popup-location"]?" list-on-top":""),template:t.config.layoutOptions?.selectBoxTemplate??"default/iq-select-box.iq-variant-01",label:t.config.label,name:"trendSetSelectBox"},"DIV"):console.error(`[${e}] template is missing required element ("selection-anchor")`)},onEnable:function(){const e=this;if(e.controls.forEach((e=>{e.enable()})),function initFixedTrendSets(e){e.vars.trendSets=shmi.cloneObject(e.config["trend-sets"]),e.vars.trendSets.forEach((e=>{e.fixed=!0}))}(e),loadTrendSets(e),e.config["remember-last-set"]&&function restoreLastSet(e){const s=localStorage.getItem(n);if(s)try{const n=shmi.requires("visuals.session.UserManager").currentUser.name,a=JSON.parse(s);let l=shmi.requires("visuals.tools.nodes").getNodeHandle(e);if(l||(l=e.getName()),a?.[n]?.[t]?.[l]?.selectedSet){const s=e.vars.trendSets.find((({name:e})=>e===a[n][t][l].selectedSet));s&&(e.vars.selected=s.name)}}catch(e){console.error(`[${t}] could not parse saved widget settings:`,e)}}(e),e.vars.selectBox&&(updateSetOptions(e),e.vars.tokens.push(e.vars.selectBox.listen("change",(t=>{e.vars.ignoreChange||(e.vars.selected=t.detail.value,updateTrendWidget(e),setModified(e,!1),saveLastSet(e))})))),null!==e.config["trend-widget"]){const t=shmi.ctrl(e.config["trend-widget"]);t&&t.isActive()&&onTrendEnable(e,t),function attachTrendListeners(e){e.vars.tokens.push(shmi.listen("enable",(function onTrendEnableHandler(t){nameOrNodeHandleMatches(e.config["trend-widget"],t.source)&&onTrendEnable(e,t.source)}),{"source.uiType":"iq-trend"})),e.vars.tokens.push(shmi.listen("disable",(function onTrendDisableHandler(t){nameOrNodeHandleMatches(e.config["trend-widget"],t.source)&&function onTrendDisable(e){e.vars.trendWidget=null,e.vars.trendWidgetTokens.forEach((e=>e.unlisten())),e.vars.trendWidgetTokens=[]}(e,t.source)}),{"source.uiType":"iq-trend"}))}(e)}},onDisable:function(){const e=this;e.controls.forEach((e=>{e.disable()})),e.vars.tokens.forEach((e=>{e.unlisten()})),e.vars.tokens=[],e.vars.trendWidgetTokens.forEach((e=>e.unlisten())),e.vars.trendWidgetTokens=[],e.vars.trendWidget=null},onLock:function(){const e=this;e.vars.selectBox&&e.vars.selectBox.lock()},onUnlock:function(){const e=this;e.vars.selectBox&&e.vars.selectBox.unlock()},onSetValue:function(e,t,s){},onSetProperties:function(e,t,s,n,a,l,o,r,c,u){},onDelete:function(){},getTrendWidget:function(){return this.vars.trendWidget},getTrendSetsIdentifier:function(){return this.vars.trendSetsIdentifier},getTrendSets:function(){return this.vars.setsLoaded?this.vars.trendSets:null},getSelected:function(){const e=this,t=e.vars.trendSets.find((({name:t})=>t===e.vars.selected));return t||null},createTrendSet:async function(e){const t=this;return!(t.vars.trendSets.find((({name:t})=>t===e))||!t.vars.trendWidget)&&(t.vars.trendSets.push({name:e,values:t.vars.trendWidget.getSelectedValues()}),await saveTrendSets(t),t.vars.selected=e,setModified(t,!1),updateSetOptions(t),saveLastSet(t),!0)},renameTrendSet:async function(e){const t=this,s=!t.vars.trendSets.every((({name:t})=>t!==e)),n=t.getSelected();return!(s||!n||!t.vars.trendWidget)&&(n.name=e,await saveTrendSets(t),t.vars.selected=e,checkModified(t),updateSetOptions(t),saveLastSet(t),!0)},saveTrendSet:async function(){const e=this,t=e.vars.trendSets.find((({name:t,fixed:s})=>t===e.vars.selected&&!s));return!(!t||!e.vars.trendWidget)&&(t.values=e.vars.trendWidget.getSelectedValues(),await saveTrendSets(e),setModified(e,!1),!0)},deleteTrendSet:async function(){const e=this;if(e.vars.selected){const t=e.vars.trendSets.length;if(e.vars.trendSets=e.vars.trendSets.filter((t=>t.name!==e.vars.selected||t.fixed)),e.vars.trendSets.length!==t)return e.vars.selected=null,setModified(e,!1),updateSetOptions(e),await saveTrendSets(e),saveLastSet(e),!0}return!1},isTrendSetModified:function(){return this.vars.modified}}};shmi.requires("visuals.tools.control-generator").generate(o)}(),function(){"use strict";const e="iq-trend-time",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1);t.fLog,t.log;function updateDisplayTime(e){const{formatDateTime:t}=shmi.requires("visuals.tools.date"),{startValue:s,endValue:n}=e.vars.elements;if(e.vars.trendWidget){const a=e.vars.trendWidget.getDimensionsX();"start-end"===e.config.mode?(s&&(s.textContent=t(Math.floor(a.min/1e3),shmi.localize(e.config["date-time-format"]))),n&&(n.textContent=t(Math.floor(a.max/1e3),shmi.localize(e.config["date-time-format"])))):"start-duration"===e.config.mode&&s&&(s.textContent=t(a.min/1e3,shmi.localize(e.config["date-time-format"])))}}function updateInactiveState(e){e.vars.isInactive=!e.vars.trendWidget,e.vars.isInactive?(shmi.addClass(e.element,"inactive-mode"),e.vars.durationSelect&&e.vars.durationSelect.lock()):(shmi.removeClass(e.element,"inactive-mode"),e.vars.durationSelect&&e.vars.durationSelect.unlock())}function updatePopupAnchor(e,t=!0){const s=e.element.querySelector(".widget-content"),n=s?s.getBoundingClientRect():e.element.getBoundingClientRect(),{popup:a,startTime:l,endTime:o}=e.vars.elements;let r=null,c=0;switch(e.config["popup-orientation"]){case"bottom-right":case"top-right":r=t?l.getBoundingClientRect():o.getBoundingClientRect(),c=n.x+n.width-(r.x+r.width),a.style.right=`${c}px`;break;case"bottom-left":case"top-left":r=t?l.getBoundingClientRect():o.getBoundingClientRect(),c=r.x-n.x,a.style.left=`${c}px`}}function isWidgetReady(e){return e.isActive()&&e.vars.trendWidget&&e.vars.durationSelect}async function updateDurationOptions(e){if(isWidgetReady(e)){if(await function onInitControl(e){return new Promise((t=>{shmi.waitOnInit(e,t)}))}(e.vars.durationSelect),!isWidgetReady(e))return;const{formatDuration:t}=shmi.requires("visuals.tools.date"),s=e.vars.trendWidget.getDisplayDurations().reverse().map((e=>({label:t(e,"compact"),value:e})));e.vars.ignoreChange=!0,e.vars.durationSelect.setOptions(s);const n=e.vars.trendWidget.getDisplayDuration();e.vars.durationSelect.setValue(n),e.vars.ignoreChange=!1}}function onTrendEnable(e,t){e.vars.trendWidget=t,updateDisplayTime(e),updateInactiveState(e),updateDurationOptions(e),e.vars.tokens.push(t.listen("live",(t=>{t.detail.isLive||updateDisplayTime(e)}))),e.vars.tokens.push(t.listen("display-duration",(t=>{updateDisplayTime(e),e.vars.durationSelect&&(e.vars.ignoreChange=!0,e.vars.durationSelect.setValue(t.detail.duration),e.vars.ignoreChange=!1)}))),e.vars.tokens.push(t.listen("display-time",updateDisplayTime.bind(null,e))),e.isLocked()||shmi.removeClass(e.element,"locked")}function onTrendDisable(e){e.vars.trendWidget=null,updateInactiveState(e)}function nameOrNodeHandleMatches(e,t){const{HANDLE_PREFIX:s,getNodeHandle:n}=shmi.requires("visuals.tools.nodes");return"string"==typeof e&&e.startsWith(s)?n(t)===e.replace(s,""):e===t.getName()}const s={className:"iq-trend-time",uiType:e,isContainer:!0,config:{"class-name":"iq-trend-time",name:null,template:"default/iq-trend-time","trend-widget":null,mode:"start-end","date-time-format":"$DD.$MM.$YYYY, $HH:$mm:$ss","popup-orientation":"bottom-left",startLabel:"Start",endLabel:"End",durationLabel:"Duration",layoutOptions:{dateLabel:"Select Date",timeLabel:"Select Time",okLabel:"OK",cancelLabel:"Cancel"}},configSchema:null,vars:{trendWidget:null,elements:{startTime:null,startValue:null,endTime:null,endValue:null,duration:null,popup:null},durationSelect:null,ignoreChange:!1,tokens:[],listeners:[],isInactive:!1,templateElementsFound:!1},imports:{},events:[],prototypeExtensions:{onInit:function(){const t=this,{getPopup:s}=shmi.requires("visuals.controls.iqtrendtime.popup"),{MouseListener:n,TouchListener:a}=shmi.requires("visuals.io"),{elements:l}=t.vars;if(l.startTime=shmi.getUiElement("start-time",t.element),l.startLabel=shmi.getUiElement("start-label",t.element),l.startValue=l.startTime?shmi.getUiElement("label",l.startTime):null,l.endTime=shmi.getUiElement("end-time",t.element),l.endLabel=shmi.getUiElement("end-label",t.element),l.endValue=l.endTime?shmi.getUiElement("label",l.endTime):null,l.duration=shmi.getUiElement("duration",t.element),l.popup=shmi.getUiElement("popup-anchor",t.element),l.startTime&&l.startValue&&l.startLabel&&l.endTime&&l.endValue&&l.endLabel&&l.duration&&l.popup){if(t.vars.templateElementsFound=!0,["top-right","top-left"].includes(t.config["popup-orientation"])&&shmi.addClass(l.popup,"popup-on-top"),["top-right","bottom-right"].includes(t.config["popup-orientation"])&&shmi.addClass(l.popup,"right-orientation"),l.startLabel.textContent=shmi.localize(t.config.startLabel),l.endLabel.textContent=shmi.localize(t.config.endLabel),l.startTime){const e={onClick:async()=>{if(t.vars.trendWidget){updatePopupAnchor(t,!0);const e=t.vars.trendWidget.getDimensionsX(),n=await s(t,Object.assign(t.config.layoutOptions||{},{timestamp:e.min}));if(null!==n&&(t.vars.trendWidget.setOptions({tStart:n}),"start-end"===t.config.mode)){const s=Math.floor(e.max-n);t.vars.trendWidget.setDisplayDuration(s>=1e3?s:1e3)}}}};t.vars.listeners.push(new n(l.startTime,e),new a(l.startTime,e))}if("start-end"===t.config.mode){if(shmi.addClass(t.element,"mode-start-end"),l.endTime){const e={onClick:async()=>{if(t.vars.trendWidget){updatePopupAnchor(t,!1);const e=t.vars.trendWidget.getDimensionsX(),n=await s(t,Object.assign(t.config.layoutOptions||{},{timestamp:e.max}));if(null!==n){const s=Math.floor(n-e.min);s<1e3?t.vars.trendWidget.setOptions({tStart:n-1e3}):t.vars.trendWidget.setOptions({tStart:e.min}),t.vars.trendWidget.setDisplayDuration(s>=1e3?s:1e3)}}}};t.vars.listeners.push(new n(l.endTime,e),new a(l.endTime,e))}}else if("start-duration"===t.config.mode&&(shmi.addClass(t.element,"mode-start-duration"),l.duration)){const{layoutOptions:e}=t.config,s=e&&e.selectDurationClassName?e.selectDurationClassName:"iq-select-box iq-variant-01"+(["top-right","top-left"].includes(t.config["popup-orientation"])?" list-on-top":""),n=e&&e.selectDurationTemplate?e.selectDurationTemplate:"default/iq-select-box.iq-variant-01";t.vars.durationSelect=shmi.createControl("iq-select-box",l.duration,{label:t.config.durationLabel,"class-name":s,template:n}),t.vars.tokens.push(t.vars.durationSelect.listen("change",(e=>{t.vars.trendWidget&&!t.vars.ignoreChange&&t.vars.trendWidget.setDisplayDuration(e.detail.value)})))}}else console.error(`[${e}] template is missing required elements: ${t.config.template}`)},onEnable:function(){if(this.vars.templateElementsFound){if(null!==this.config["trend-widget"]){const e=shmi.ctrl(this.config["trend-widget"]);e&&e.isActive()&&onTrendEnable(this,e),function attachTrendListeners(e){e.vars.tokens.push(shmi.listen("enable",(function onTrendEnableHandler(t){nameOrNodeHandleMatches(e.config["trend-widget"],t.source)&&onTrendEnable(e,t.source)}),{"source.uiType":"iq-trend"})),e.vars.tokens.push(shmi.listen("disable",(function onTrendDisableHandler(t){nameOrNodeHandleMatches(e.config["trend-widget"],t.source)&&onTrendDisable(e,t.source)}),{"source.uiType":"iq-trend"}))}(this)}updateInactiveState(this),this.controls.forEach((e=>{e.enable()})),this.vars.listeners.forEach((e=>{e.enable()}))}},onDisable:function(){this.vars.templateElementsFound&&(onTrendDisable(this),this.vars.tokens.forEach((e=>{"change"!==e.name&&e.unlisten()})),this.vars.tokens=this.vars.tokens.filter((e=>"change"===e.name)),this.vars.listeners.forEach((e=>{e.disable()})),this.controls.forEach((e=>{e.disable()})))},onDelete:function(){this.vars.tokens.forEach((e=>{e.unlisten()})),this.vars.tokens=[]},onLock:function(){shmi.addClass(this.element,"locked"),this.vars.templateElementsFound&&(this.vars.listeners.forEach((e=>{e.disable()})),this.vars.durationSelect&&this.vars.durationSelect.lock())},onUnlock:function(){this.vars.trendWidget&&shmi.removeClass(this.element,"locked"),this.vars.templateElementsFound&&(this.vars.listeners.forEach((e=>{e.enable()})),this.vars.durationSelect&&this.vars.durationSelect.unlock())},onAddControl:function(e,t){const s=this,n=shmi.requires("visuals.tools.controller"),a=[];let l=null;if(!s.initialized)throw new Error("Control not initialized yet.");if(!s.vars.elements.popup)throw new Error("Element missing in template: 'popup-anchor'");Array.isArray(e)||(e=[e]),e.forEach((function(e){const t=shmi.createControl(e.ui,s.vars.elements.popup,e.config,"DIV",null,!1);if(null!==t){if(e.style&&"object"==typeof e.style){shmi.requires("visuals.tools.iterate.iterateObject")(e.style,((e,s)=>{t.element.style[s]=e}))}a.push(t)}})),l=shmi.waitOnInit(a,(function(){const o=[],r=shmi.requires("visuals.task"),c=[];let u=-1,m=null;l&&(u=s._init_.tokens.indexOf(l),-1!==u&&s._init_.tokens.splice(u,1),l.unlisten(),l=null),e.forEach((function(e,t){const l=a[t];let u=null;e.controller&&n.create(e.controller.name,e.controller,l.getName()),s.isActive()&&l.enable(),Array.isArray(e.children)&&e.children.length&&(u=r.createTask("child control"),u.run=function(){l.addControl(e.children,(function(e,t){e&&o.push(e),u.complete()}))},c.push(u))})),c.length?(m=r.createTaskList(c,!1),m.onComplete=function(){t(o.length?o[0]:null,a)},m.run()):t(o.length?o[0]:null,a)})),l&&s._init_.tokens.push(l)}}};shmi.requires("visuals.tools.control-generator").generate(s)}(),function(){const e=shmi.pkg("visuals.controls.iqtrendtime.popup"),t="trend-time-popup";function getControllerConfig(e){return[{name:t,slot:e}]}function handleSlotEvent(e,t,s,n){if(!e.data.ignoreEvents)switch(t){case"popup":e.data.resolved||(e.data.resolved=!0,e.data.resolve(null)),shmi.deleteControl(e.getInstance("popup"));break;case"selectDate":e.data.ignoreEvents=!0,e.getInstance("selectTime").setValue(e.getInstance("selectDate").getValue()),e.data.ignoreEvents=!1;break;case"selectTime":e.data.ignoreEvents=!0,e.getInstance("selectDate").setValue(e.getInstance("selectTime").getValue()),e.data.ignoreEvents=!1;break;case"buttonOk":e.data.resolved=!0,e.data.resolve(function getTimestamp(e){return 1e3*e.getInstance("selectTime").getValue()}(e)),e.getInstance("popup").close();break;case"buttonCancel":e.data.resolved||(e.data.resolved=!0,e.data.resolve(null)),e.getInstance("popup").close()}}function getPopupController(e,s){return{name:t,slots:{popup:{ui:"popup-menu",events:["close"]},selectDate:{ui:"iq-select-date",events:["change"],optional:!0},selectTime:{ui:"iq-select-time",events:["change"],optional:!0},buttonOk:{ui:"iq-button",events:["click"],optional:!0},buttonCancel:{ui:"iq-button",events:["click"],optional:!0}},onChange:function(t,s){(function widgetsReady(e){return["selectDate","selectTime","buttonOk","buttonCancel"].every((t=>!!e.getInstance(t)))})(t)&&!t.data.contentSet&&(!function setTimestamp(e,t){const s=Math.round(t/1e3);e.data.ignoreEvents=!0,e.getInstance("selectDate").setValue(s),e.getInstance("selectTime").setValue(s),e.data.ignoreEvents=!1}(t,e.timestamp),t.data.contentSet=!0)},onEnable:function(e){e.data.resolve=s},onDisable:function(e){},onEvent:handleSlotEvent,data:{ignoreEvents:!1,resolve:null,resolved:!1,contentSet:!1}}}e.getPopup=(e,t)=>new Promise(((s,n)=>{if(e){const a=function getPopupLayout(e,t,s){return{ui:"popup-menu",config:{name:"trendTimePopup","class-name":e.popupClassName||"popup-menu iq-flex trend-time",template:"default/popup-menu","auto-close":!1,"content-template":null,"tab-limit":!1,_controllers_:getControllerConfig("popup")},controller:getPopupController(e,t),children:[{ui:"container",config:{ui:"container","class-name":"iq-container",type:"iqflex","flex-orientation":"column","flex-none":!0,"flex-wrap":!1,"flex-primary-align":"start","flex-secondary-align":"stretch","flex-line-align":"start",name:"content",template:null},children:[{ui:"iq-label",config:{"class-name":e.dateLabelClassName||"iq-label iq-variant-01 date",template:e.dateLabelTemplate||"default/iq-label.iq-variant-01",name:"dateLabel",ui:"iq-label",item:null,type:null,"auto-type":!0,"decimal-delimiter":".",precision:2,"auto-precision":!0,options:[],pattern:null,tooltip:null,"value-as-tooltip":!1,text:e.dateLabel||"Select Date"},children:null},{ui:"iq-select-date",config:{"class-name":e.selectDateClassName||"iq-select-date iq-variant-01 always-open",template:e.selectDateTemplate||"default/iq-select-date.iq-variant-01",name:"selectDate",ui:"iq-select-date",label:"",item:null,"auto-label":!1,dateformat:"${V_DATEFORMAT}","show-icon":!1,"icon-src":null,"icon-class":null,"icon-title":null,_controllers_:getControllerConfig("selectDate")},children:null},{ui:"iq-label",config:{"class-name":e.timeLabelClassName||"iq-label iq-variant-01 time",template:e.timeLabelTemplate||"default/iq-label.iq-variant-01",name:"timeLabel",ui:"iq-label",item:null,type:null,"auto-type":!0,"decimal-delimiter":".",precision:2,"auto-precision":!0,options:[],pattern:null,tooltip:null,"value-as-tooltip":!1,text:e.timeLabel||"Select Time"},children:null},{ui:"iq-select-time",config:{"class-name":e.selectTimeClassName||"iq-select-time iq-variant-01 iq-icon-variant-01",template:e.selectTimeTemplate||"default/iq-select-time.iq-variant-01",name:"selectTime",ui:"iq-select-time",label:"",item:null,"auto-label":!1,"numpad-enabled":!1,isUTC:!1,_controllers_:getControllerConfig("selectTime")},children:null},{ui:"container",config:{"class-name":"iq-container button-container",type:"iqflex","flex-orientation":"row","flex-none":!0,"flex-wrap":!1,"flex-primary-align":"space-between","flex-secondary-align":"stretch","flex-line-align":"start",name:"buttonContainer",template:null},children:[{ui:"iq-button",config:{"class-name":e.cancelButtonClassName||"iq-button iq-variant-01",template:e.cancelButtonTemplate||"default/iq-button.iq-variant-01",action:null,"show-text":!0,"disable-item-lock":!1,monoflop:!1,"monoflop-value":1,"monoflop-interval":100,name:"cancelButton",ui:"iq-button",label:e.cancelLabel||"Cancel",item:null,"auto-label":!0,"icon-src":null,"icon-title":null,"icon-class":null,"label-from-item":!1,"write-bool":!1,"action-release":null,"action-while-pressed":null,"interval-while-pressed":null,"action-press":null,"disable-alarms":!1,"show-icon":!1,"on-value":1,"off-value":0,tooltip:null,_controllers_:getControllerConfig("buttonCancel")},children:null},{ui:"iq-button",config:{"class-name":e.okButtonClassName||"iq-button iq-variant-01",template:e.okButtonTemplate||"default/iq-button.iq-variant-01",action:null,"show-text":!0,"disable-item-lock":!1,monoflop:!1,"monoflop-value":1,"monoflop-interval":100,name:"okButton",ui:"iq-button",label:e.okLabel||"OK",item:null,"auto-label":!0,"icon-src":null,"icon-title":null,"icon-class":null,"label-from-item":!1,"write-bool":!1,"action-release":null,"action-while-pressed":null,"interval-while-pressed":null,"action-press":null,"disable-alarms":!1,"show-icon":!1,"on-value":1,"off-value":0,tooltip:null,_controllers_:getControllerConfig("buttonOk")},children:null}]}]}]}}(t,s);a&&e.addControl(a,((e,t)=>{e?n(e):t[0].open()}))}else n(new Error("Parent widget not specified."))}))}(),function(){"use strict";const e="iq-trend-zoom",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1);t.fLog,t.log;function onTrendEnable(e,t){e.vars.trendWidget=t,e.isLocked()||shmi.removeClass(e.element,"locked")}function onTrendDisable(e){e.vars.trendWidget=null,e.isActive()&&!e.isLocked()&&shmi.addClass(e.element,"locked")}function nameOrNodeHandleMatches(e,t){const{HANDLE_PREFIX:s,getNodeHandle:n}=shmi.requires("visuals.tools.nodes");return"string"==typeof e&&e.startsWith(s)?n(t)===e.replace(s,""):e===t.getName()}const s={className:"iq-trend-zoom",uiType:e,isContainer:!1,config:{"class-name":"iq-trend-zoom",name:null,template:"default/iq-trend-zoom","trend-widget":null,orientation:"horizontal"},configSchema:null,vars:{trendWidget:null,elements:{inButton:null,outButton:null},tokens:[],listeners:[]},imports:{},events:[],prototypeExtensions:{onInit:function(){const e=this,{MouseListener:t,TouchListener:s}=shmi.requires("visuals.io");if(e.vars.elements.inButton=shmi.getUiElement("in-button",e.element),e.vars.elements.outButton=shmi.getUiElement("out-button",e.element),"vertical"===e.config.orientation&&shmi.addClass(e.element,"vertical"),e.vars.elements.inButton&&e.vars.elements.outButton){const n={onClick:()=>{e.vars.trendWidget&&("y-axis"===e.config.axis?e.vars.trendWidget.zoomInY():"x-axis"===e.config.axis&&e.vars.trendWidget.zoomInX())}};e.vars.listeners.push(new t(e.vars.elements.inButton,n),new s(e.vars.elements.inButton,n));const a={onClick:()=>{e.vars.trendWidget&&("y-axis"===e.config.axis?e.vars.trendWidget.zoomOutY():"x-axis"===e.config.axis&&e.vars.trendWidget.zoomOutX())}};e.vars.listeners.push(new t(e.vars.elements.outButton,a),new s(e.vars.elements.outButton,a))}},onEnable:function(){const{elements:t}=this.vars;if(t.inButton&&t.outButton){if(null!==this.config["trend-widget"]){const e=shmi.ctrl(this.config["trend-widget"]);e&&e.isActive()&&onTrendEnable(this,e),function attachTrendListeners(e){e.vars.tokens.push(shmi.listen("enable",(function onTrendEnableHandler(t){nameOrNodeHandleMatches(e.config["trend-widget"],t.source)&&onTrendEnable(e,t.source)}),{"source.uiType":"iq-trend"})),e.vars.tokens.push(shmi.listen("disable",(function onTrendDisableHandler(t){nameOrNodeHandleMatches(e.config["trend-widget"],t.source)&&onTrendDisable(e,t.source)}),{"source.uiType":"iq-trend"}))}(this)}this.vars.listeners.forEach((e=>{e.enable()}))}else console.error(`[${e}] template is missing required elements.`)},onDisable:function(){onTrendDisable(this),this.vars.tokens.forEach((e=>{e.unlisten()})),this.vars.tokens=[],this.vars.listeners.forEach((e=>{e.disable()}))},onDelete:function(){},onLock:function(){shmi.addClass(this.element,"locked"),this.vars.listeners.forEach((e=>{e.disable()}))},onUnlock:function(){shmi.removeClass(this.element,"locked"),this.vars.listeners.forEach((e=>{e.enable()}))}}};shmi.requires("visuals.tools.control-generator").generate(s)}(),function(){"use strict";const e="iq-trend",t={value:{lineWidth:1,strokeStyle:"rgb(0, 0, 0)",fillStyle:"rgba(0, 0, 0, 0.1)",lineDash:[]},tolerance:{lineWidth:1,strokeStyle:"rgb(0, 0, 0)",lineDash:[5,5]}},s={value:{lineWidth:1,strokeStyle:"rgb(163, 163, 163)",fillStyle:"rgba(163, 163, 163, 0.1)",lineDash:[]},tolerance:{lineWidth:1,strokeStyle:"rgb(163, 163, 163)",lineDash:[5,5]}},n="webiq-widget-settings",a=1e3,l=6e4,o=36e5,r=864e5,c=6048e5,u=2592e6,m=2;function updateHighlightState(e){const{selectedValues:t,datasets:s}=e.vars,n=e.getValueStyles(),a=t.find((e=>e.options&&e.options.highlight));s.forEach(((s,l)=>{a&&a.name!==s.name?s.setOptions({style:e.config.inactiveStyle}):s.setOptions({style:n[t[l].options.style]?n[t[l].options.style]:e.config.defaultValueStyle}),s.update()}))}function addGraphValue(e,t,s={drawTolerance:!1,externalDraw:!0,fillCurve:!0,style:0,scaleGroup:null,limits:null}){s=shmi.cloneObject(s);const{DataSet:n}=shmi.requires("visuals.controls.iqtrend.dataset"),a=e.config.valueStyles[s.style]||e.config.defaultValueStyle;s.scaleGroup=void 0===s.scaleGroup?null:s.scaleGroup,s.scale=s.scale||{location:s.scale&&s.scale.location&&["left","right"].includes(s.scale.location)?s.scale.location:e.vars.elements.scalesLeft.childElementCount>e.vars.elements.scalesRight.childElementCount?"right":"left"},s.style=a,s.name=t;const l=new n(e.vars.elements,s,e),o=e.vars.xAxis.getDimensions(),r=o.min,c=o.max,u=c-r,h=Math.ceil(u/l.getDimensions().width*m);l.setOptions({x:{min:r,max:c},y:{min:0,max:1},interval:h}),updateZoomStage(e,e.vars.focusY,l);let d=null;s.limits&&(d=shmi.cloneObject(s.limits),d.name=s.name);let f=null;"boolean"==typeof s.drawTolerance&&(f={name:s.name,drawTolerance:s.drawTolerance}),e.vars.datasource.source.setOptions({tStart:r,duration:u,interval:h,limits:d||void 0,tolerance:f||void 0,loadComments:e.config.showComments},!0),e.vars.markerLayer&&e.vars.markerLayer.setOptions({x:{min:r,max:r+u}});let v=0;return{setToken:l.watch((({width:t,dimensions:s})=>{clearTimeout(v),v=setTimeout((()=>{if(e.vars.handleInfo.primary.active&&e.vars.handleInfo.primary.graphWidth!==t){const s=(e.vars.handleInfo.primary.graphWidth+1)/(t+1);e.vars.handleInfo.primary.graphWidth=t,e.vars.handleInfo.primary.offset/=s,e.vars.elements.handle.primary.base.style.left=`${e.vars.handleInfo.primary.offset}px`,setHandlePosition(e,!0,e.vars.handleInfo.primary.offset,!1)}if(e.vars.handleInfo.secondary.active&&e.vars.handleInfo.secondary.graphWidth!==t){const s=(e.vars.handleInfo.secondary.graphWidth+1)/(t+1);e.vars.handleInfo.secondary.graphWidth=t,e.vars.handleInfo.secondary.offset/=s,e.vars.elements.handle.secondary.base.style.left=`${e.vars.handleInfo.secondary.offset}px`,setHandlePosition(e,!1,e.vars.handleInfo.secondary.offset,!1)}e.vars.datasource.source.setOptions({interval:Math.ceil((s.x.max-s.x.min)/t*m)}),e.vars.markerLayer&&e.vars.markerLayer.updateSize()}),100)})),dataset:l}}function updateDatasetZoomStage(e,t,s){if(!e.vars.datasource.source.getValueSettings()[s.name])return;if(s.scaleGroup&&s.scaleGroup.master.dataset!==s)return;const{min:n,max:a}=s.scaleGroup?s.scaleGroup.getValueLimits():e.vars.datasource.source.getValueSettings()[s.name];if(0===e.vars.zoomStage)return void(s.scaleGroup?s.scaleGroup.setOptions({y:{min:n,max:a}},null):s.setOptions({y:{min:n,max:a}}));const l=(a-n)/(e.vars.zoomStages[e.vars.zoomStage]/100),o=s.getValueAtY(t),r=s.getDimensions().y,c=r.max-r.min;let u=o-(o-r.min)/c*l,m=u+l;if(u<n){u+=n-u,m=u+l}else if(m>a){m-=m-a,u=m-l}s.scaleGroup?s.scaleGroup.setOptions({y:{min:u,max:m}},null):s.setOptions({y:{min:u,max:m}})}function updateZoomStage(e,t,s=null){null!==s?updateDatasetZoomStage(e,t,s):e.vars.datasets.forEach((s=>{updateDatasetZoomStage(e,t,s)}))}function updateDrag(e,t,s){if(0!==s&&e.vars.datasets.forEach((t=>{let n=!1;if(t.scaleGroup&&t.scaleGroup.master&&t.scaleGroup.master.dataset!==t)return;t.scaleGroup&&t.scaleGroup.master&&(n=!0);const{min:a,max:l}=function getMinMax(e,t){if(t.scaleGroup){const s=t.scaleGroup.getValueNames().map((t=>e.vars.datasource.source.getValueSettings()[t].min)),n=t.scaleGroup.getValueNames().map((t=>e.vars.datasource.source.getValueSettings()[t].max));return{min:Math.min(...s),max:Math.max(...n)}}{const s=e.vars.datasource.source.getValueSettings()[t.name];return{min:s.min,max:s.max}}}(e,t),{scaleY:o}=t.graph,r=t.getDimensions().y,c=r.max-r.min,u=s/o;if(s>0&&r.max!==l){let e=r.max+u;e>l&&(e=l),n?t.scaleGroup.setOptions({y:{min:e-c,max:e}},null):t.setOptions({y:{min:e-c,max:e}})}else if(s<0&&r.min!==a){let e=r.min+u;e<a&&(e=a),n?t.scaleGroup.setOptions({y:{min:e,max:e+c}},null):t.setOptions({y:{min:e,max:e+c}})}})),0!==t){e.vars.live&&e.setLive(!1);const s=0,n=Date.now(),{xAxis:a}=e.vars,l=a.getScale(),o=a.getDimensions(),r=o.max-o.min,c=t/l;let u=o.max,m=o.min;t<0&&o.max!==n?(u=o.max-c,u>n&&(u=n),m=u-r):t>0&&o.min!==s&&(m=o.min-c,m<s&&(m=s),u=m+r),m===o.min&&u===o.max||(a.setOptions({x:{min:m,max:u}}),e.vars.datasets.forEach((e=>{e.setOptions({x:{min:m,max:u}},!0)})),e.vars.markerLayer&&e.vars.markerLayer.setOptions({x:{min:m,max:u}}),e.vars.datasource.source.setOptions({tStart:m}))}}function updateHandleTime(e,t){const{formatDateTime:s}=shmi.requires("visuals.tools.date"),n=t?e.vars.elements.handle.primary:e.vars.elements.handle.secondary,a=t?e.vars.handleInfo.primary:e.vars.handleInfo.secondary;if(e.vars.datasets.length){const t=e.vars.datasets[0].getTimeAt(a.offset);a.timestamp=t}const l=e.vars.datasets.length&&e.vars.datasets[0].graph.interval<1e3?shmi.localize(e.config.handleDateTimeFormat.time_sub_second):shmi.localize(e.config.handleDateTimeFormat.time);n.date.textContent=s(a.timestamp/1e3,shmi.localize(e.config.handleDateTimeFormat.date)),n.time.textContent=s(a.timestamp/1e3,l)}function updateHandleValues(e,t){const{formatNumber:s}=shmi.requires("visuals.tools.numericValues"),n=e.vars.datasource.source.getValueSettings(),a=t?e.vars.elements.handle.primary:e.vars.elements.handle.secondary,l=t?e.vars.handleInfo.primary:e.vars.handleInfo.secondary,o=function getHandleValues(e,t){const s={};return e.vars.datasets.forEach((e=>{const n=e.getTimeAt(t),a=e.getValue(n);s[e.name]=a})),s}(e,l.offset),r=shmi.requires("visuals.tools.unitClasses");Object.keys(o).forEach((t=>{const c=e.vars.datasets.find((e=>e.name===t));if(l.values[t])c&&l.values[t].strokeStyle!==c.graph.style.value.strokeStyle&&(l.values[t].strokeStyle=c.graph.style.value.strokeStyle,l.values[t].ref.base.style.setProperty("--line-color",c.graph.style.value.strokeStyle));else{const s={base:e.vars.handleValuesTemplate.cloneNode(!0),label:null,value:null,unit:null};s.label=shmi.getUiElement("label",s.base),s.value=shmi.getUiElement("value",s.base),s.unit=shmi.getUiElement("unit",s.base),l.values[t]={ref:s,info:o[t],strokeStyle:null,labelText:null},a.values.appendChild(s.base),c&&(l.values[t].strokeStyle=c.graph.style.value.strokeStyle,s.base.style.setProperty("--line-color",c.graph.style.value.strokeStyle))}const u=n[t]&&n[t].label?shmi.localize(n[t].label):t;l.values[t].labelText!==u&&(l.values[t].labelText=u,l.values[t].ref.label.textContent=u);let m="";if(n[t])if(function isUnitClass(e){return String(parseInt(e))===String(e)}(n[t].unit)){const e=r.getSelectedAdapter(n[t].unit);e&&(m=e.unitText)}else m=n[t].unit;null===o[t].value?l.values[t].ref.value.textContent=e.config.noValueText?shmi.localize(e.config.noValueText):"<no value>":"number"==typeof o[t].value&&n[t]?l.values[t].ref.value.textContent=s(o[t].value,{unit:m,precision:n[t].digits,"show-unit":!1}):l.values[t].ref.value.textContent=o[t].value,l.values[t].ref.unit.textContent=null===m?"":shmi.localize(m)})),Object.keys(l.values).forEach((e=>{o[e]||(l.values[e].ref.base.parentNode.removeChild(l.values[e].ref.base),delete l.values[e])}))}function checkHandleFocus(e,t,s){const n=t?e.vars.handleInfo.primary:e.vars.handleInfo.secondary,a=t?e.vars.elements.handle.primary:e.vars.elements.handle.secondary,l=t?e.vars.handleInfo.secondary:e.vars.handleInfo.primary,o=t?e.vars.elements.handle.secondary:e.vars.elements.handle.primary;if(s&&(n.recent=!0,l.recent=!1),n.recent&&l.active){const e=a.base.parentNode,t=a.base.getBoundingClientRect(),s=o.base.getBoundingClientRect();s.left>=t.right||s.right<=t.left||s.top>=t.bottom||s.bottom<=t.top?(a.base.classList.remove("focused"),o.base.classList.remove("focused")):(e.insertBefore(o.base,a.base),a.base.classList.add("focused"),o.base.classList.remove("focused"))}else l.active||(a.base.classList.remove("focused"),o.base.classList.remove("focused"))}function setHandlePosition(e,t,s,n=!0){if(!e.vars.datasets.length)return;const a=t?e.vars.handleInfo.primary:e.vars.handleInfo.secondary,l=t?e.vars.elements.handle.primary:e.vars.elements.handle.secondary,o=e.vars.datasets[0].getDimensions(),{width:r}=o,c=l.base.offsetWidth;let u=s;u<1?u=1:u>r+1&&(u=r+1);let m=!1;u>r+1-c?(l.base.classList.add("reversed"),m=!0):l.base.classList.remove("reversed");let h=m?u-c:u;a.offset=u,a.graphWidth=o.width,l.base.style.left=`${h}px`,updateHandleTime(e,t),updateHandleValues(e,t),a.active||(a.active=!0,l.base.classList.add("active")),checkHandleFocus(e,t,n),clearTimeout(e.vars.handleUpdateTimeout),e.vars.handleUpdateTimeout=setTimeout((()=>{e.isActive()&&e.fire("handle-info",e.getHandleInfo())}),100)}function getRelativePosition(e,t,s){const n=e.getBoundingClientRect();return{x:t-n.left,y:s-n.top,bounds:n}}function initHandle(e,t){const s=e.vars.elements.graphs,n=e.vars.handleTemplate.cloneNode(!0),a=t?e.vars.elements.handle.primary:e.vars.elements.handle.secondary;if(a.base=n,a.date=shmi.getUiElement("handle-date",n),a.time=shmi.getUiElement("handle-time",n),a.button=shmi.getUiElement("button",n),a.values=shmi.getUiElement("data-values",n),a.handle=shmi.getUiElement("drag-handle",n),a.comment=shmi.getUiElement("comment-anchor",n),e.config.showComments){const s=shmi.createControl("iq-button",a.comment,shmi.cloneObject(e.config.commentButtonConfig),"DIV");e.vars.eventTokens.push(s.listen("click",(async s=>{const n=e.getTrendInfo(),a=shmi.requires("visuals.tools.threads"),l=t?e.vars.handleInfo.primary:e.vars.handleInfo.secondary;if(n){null!==await a.create("trend",n.trend_id,l.timestamp,{dialogTitle:"${iqtrend_create_thread}",titleLabel:"${iqtrend_threads_title}",messageLabel:"${iqtrend_threads_message}",applyLabel:"${iqtrend_threads_create_btn}",enterMessageNotification:"${iqtrend_threads_enter_message_notification}"})&&e.vars.datasource.source&&"function"==typeof e.vars.datasource.source.reloadComments&&e.vars.datasource.source.reloadComments()}})))}const{MouseListener:l,TouchListener:o}=shmi.requires("visuals.io"),r={onPress:()=>{},onRelease:()=>{},onDrag:(s,n,a)=>{const l=t?e.vars.handleInfo.primary:e.vars.handleInfo.secondary;setHandlePosition(e,t,l.offset+s)}},c=new l(a.handle,r,{dragThreshold:0}),u=new o(a.handle,r,!1,{dragThreshold:0}),m={onPress:()=>{},onRelease:()=>{},onClick:(s,n,a)=>{checkHandleFocus(e,t,!0)},onWheel:(e,t)=>{t.stopPropagation()}},h=new l(a.base,m),d=new o(a.base,m),f={onPress:()=>{},onRelease:()=>{},onClick:()=>{if(!e.isLocked()){a.base.classList.remove("active");(t?e.vars.handleInfo.primary:e.vars.handleInfo.secondary).active=!1,e.fire("handle-info",e.getHandleInfo())}}},v=new l(a.button,f),g=new o(a.button,f);e.vars.inputListeners.push(c,u,h,d,v,g),s.appendChild(a.base)}function updateWidgetSettings(t){if(t.config.rememberSelectedValues){const s=shmi.requires("visuals.tools.nodes").getNodeHandle(t),a=shmi.requires("visuals.session.UserManager").currentUser.name,l=localStorage.getItem(n);let o={};if(l)try{o=JSON.parse(l)}catch(t){console.error(`[${e}] could not parse saved selection:`,t)}o[a]=o[a]||{},o[a][e]=o[a][e]||{},o[a][e][s]=o[a][e][s]||{},o[a][e][s].selectedValues=shmi.cloneObject(t.vars.selectedValues),localStorage.setItem(n,JSON.stringify(o))}}function fireDisplayTimeUpdate(e,t){e.isLive()?Date.now()-e.vars.lastDisplayTimeUpdate>1e3&&(e.fire("display-time",t),e.vars.lastDisplayTimeUpdate=Date.now()):(shmi.caf(e.vars.displayTimeRafId),e.vars.displayTimeRafId=shmi.raf((()=>{e.updateHandles(),e.fire("display-time",t),e.vars.lastDisplayTimeUpdate=Date.now()})))}function setScaleGroupOption(e,t,s,n){const a=Object.keys(t.values);a.forEach((t=>{const a=e.vars.selectedValues.find((e=>e.name===t));a&&(a.options.scale=a.options.scale||{},a.options.scale[s]=n)})),"hidden"===s?t.master.dataset.scale.setOptions({[s]:n}):a.forEach((e=>{t.values[e].dataset.scale.setOptions({[s]:n})}))}const h={className:"IqTrend",uiType:e,isContainer:!0,config:{"class-name":"iq-trend",name:null,template:"default/iq-trend",tooltip:null,datasource:{type:"trend",name:"Trend"},valueStyles:[{value:{lineWidth:1,strokeStyle:"rgb(141, 77, 163)",fillStyle:"rgba(141, 77, 163, 0.1)",lineDash:[]},tolerance:{lineWidth:1,strokeStyle:"rgb(141, 77, 163)",lineDash:[5,5]}},{value:{lineWidth:1,strokeStyle:"rgb(227, 67, 147)",fillStyle:"rgba(227, 67, 147, 0.1)",lineDash:[]},tolerance:{lineWidth:1,strokeStyle:"rgb(227, 67, 147)",lineDash:[5,5]}},{value:{lineWidth:1,strokeStyle:"rgb(211, 229, 116)",fillStyle:"rgba(211, 229, 116, 0.1)",lineDash:[]},tolerance:{lineWidth:1,strokeStyle:"rgb(211, 229, 116)",lineDash:[5,5]}},{value:{lineWidth:1,strokeStyle:"rgb(71, 178, 178)",fillStyle:"rgba(71, 178, 178, 0.1)",lineDash:[]},tolerance:{lineWidth:1,strokeStyle:"rgb(71, 178, 178)",lineDash:[5,5]}},{value:{lineWidth:1,strokeStyle:"rgb(186, 74, 130)",fillStyle:"rgba(186, 74, 130, 0.1)",lineDash:[]},tolerance:{lineWidth:1,strokeStyle:"rgb(186, 74, 130)",lineDash:[5,5]}}],defaultValueStyle:t,inactiveStyle:s,selectedValues:[],displayDuration:6e4,availableDurations:null,availableZoomStages:null,timelineMarkerFormats:null,timelineStartMarkerFormat:null,handleDateTimeFormat:{date:"$DD.$MM.$YYYY",time:"$HH:$mm:$ss",time_sub_second:"$HH:$mm:$ss .${SSS}"},handle:{enabled:!0,secondary:!0},showComments:!0,startLive:!1,rememberSelectedValues:!1,noValueText:"<no value>",commentTimestampFormat:"$DD.$MM.$YYYY, $HH:$mm:$ss",commentButtonConfig:{"class-name":"iq-button iq-variant-01",template:"default/iq-button.iq-variant-01",action:null,"show-text":!0,"disable-item-lock":!1,monoflop:!1,"monoflop-value":1,"monoflop-interval":100,name:"iq-button",ui:"iq-button",label:"Comment",item:null,"auto-label":!0,"icon-src":null,"icon-title":null,"icon-class":null,"label-from-item":!1,"write-bool":!1,"action-release":null,"action-while-pressed":null,"interval-while-pressed":null,"action-press":null,"disable-alarms":!1,"show-icon":!1,"on-value":1,"off-value":0,tooltip:null}},configSchema:null,vars:{datasets:[],xAxis:null,tokens:[],valueTokens:[],handleToken:null,rafId:0,displayDuration:6e4,displayDurationUpdate:null,values:{},collectValues:!1,inputListeners:[],zoomStage:0,focusY:50,elements:{scalesLeft:null,scalesRight:null,graphs:null,timeline:null,loadingIndicator:null,markerLayer:null,handle:{primary:{base:null,time:null,date:null,button:null,values:null,handle:null},secondary:{base:null,time:null,date:null,button:null,values:null,handle:null}}},handleInfo:{primary:{active:!1,offset:0,timestamp:null,graphWidth:null,values:{},recent:!1},secondary:{active:!1,offset:0,timestamp:null,graphWidth:null,values:{},recent:!1}},handleTemplate:null,handleValuesTemplate:null,markerTemplates:{comment:null,alarm:null},markerLayer:null,valueSettings:{},live:!1,xAxisMode:"timeline",datasource:{type:"trend",name:"Trend",source:null},selectedValues:[],durationUpdateTimeout:0,handleUpdateTimeout:0,scaleGroups:{},loadingToken:null,markerToken:null,eventTokens:[],lastValueInfo:[],zoomStages:[100,110,125,150,175,200,250,300,400,500,600,700,800,900,1e3],displayDurations:[a,2*a,3*a,4*a,5*a,10*a,30*a,l,2*l,3*l,5*l,10*l,15*l,30*l,o,2*o,4*o,8*o,12*o,r,2*r,c,2*c,u,3*u,6*u,31536e6],displayTimeRafId:0,lastDisplayTimeUpdate:0,restoreLiveToken:null},imports:{},events:["display-duration","handle-info","value-info","graph-options","live","display-time"],prototypeExtensions:{onInit:function(){const t=this;if(t.element.style.overflow="hidden",t.vars.elements.scalesLeft=shmi.getUiElement("scales-left",t.element),t.vars.elements.scalesRight=shmi.getUiElement("scales-right",t.element),t.vars.elements.graphs=shmi.getUiElement("graphs",t.element),t.vars.elements.xAxis=shmi.getUiElement("x-axis",t.element),t.vars.elements.loadingIndicator=shmi.getUiElement("loading-indicator",t.element),t.config.rememberSelectedValues){const s=localStorage.getItem(n);if(s)try{const n=shmi.requires("visuals.tools.nodes").getNodeHandle(t),a=shmi.requires("visuals.session.UserManager").currentUser.name,l=JSON.parse(s);l&&l[a]&&l[a][e]&&l[a][e][n]&&Array.isArray(l[a][e][n].selectedValues)&&(t.config.selectedValues=l[a][e][n].selectedValues)}catch(t){console.error(`[${e}] could not parse saved selection:`,t)}}if(t.vars.elements.markerLayer=shmi.getUiElement("marker-layer",t.element),!t.vars.elements.markerLayer)return void console.error(`[${e}] could not find required 'marker-layer' element in template.`);if(t.vars.markerTemplates.comment=shmi.getUiElement("trend-marker-comment",t.element),!t.vars.markerTemplates.comment)return void console.error(`[${e}] could not find required 'trend-marker-comment' element in template.`);const s=t.vars.markerTemplates.comment.cloneNode(!0);if(t.vars.markerTemplates.comment.parentNode.removeChild(t.vars.markerTemplates.comment),t.vars.markerTemplates.comment=s,t.vars.markerTemplates.alarm=shmi.getUiElement("trend-marker-alarm",t.element),!t.vars.markerTemplates.alarm)return void console.error(`[${e}] could not find required 'trend-marker-alarm' element in template.`);const a=t.vars.markerTemplates.alarm.cloneNode(!0);if(t.vars.markerTemplates.alarm.parentNode.removeChild(t.vars.markerTemplates.alarm),t.vars.markerTemplates.alarm=a,t.vars.handleTemplate=shmi.getUiElement("trend-handle",t.element),!t.vars.handleTemplate)return void console.error(`[${e}] could not find required 'trend-handle' element in template.`);const l=t.vars.handleTemplate.cloneNode(!0);if(t.vars.handleTemplate.parentNode.removeChild(t.vars.handleTemplate),t.vars.handleTemplate=l,t.vars.handleValuesTemplate=shmi.getUiElement("data-box",t.vars.handleTemplate),!t.vars.handleValuesTemplate)return void console.error(`[${e}] could not find required 'data-box' element in template.`);const o=t.vars.handleValuesTemplate.cloneNode(!0);t.vars.handleValuesTemplate.parentNode.removeChild(t.vars.handleValuesTemplate),t.vars.handleValuesTemplate=o,Array.isArray(t.config.availableDurations)&&(t.vars.displayDurations=t.config.availableDurations,t.vars.displayDurations.length||(console.warn("[IqTrend] no display durations configured, adding 60000ms"),t.vars.displayDurations.push(6e4)),t.vars.displayDurations.sort(((e,t)=>e-t))),Array.isArray(t.config.availableZoomStages)&&(t.vars.zoomStages=t.config.availableZoomStages.filter((e=>!(e<100)||(console.warn(`[IqTrend] configured zoom-stage is below 100 and will not be available: ${e}`),!1))),t.vars.zoomStages.includes(100)||(console.warn("[IqTrend] configured zoom-stages do not include 100% - original zoom-stage added"),t.vars.zoomStages.push(100)),t.vars.zoomStages.sort(((e,t)=>e-t))),initHandle(t,!0),initHandle(t,!1);const{MouseListener:r,TouchListener:c}=shmi.requires("visuals.io");t.vars.displayDuration=t.config.displayDuration;const u=function getInputHandler(e){let t=!1,s=1,n=1;return{onPress:(e,s,n)=>{n.touches&&n.touches.length>1&&(t=!0)},onRelease:(a,l,o)=>{t&&o.touches&&0===o.touches.length&&shmi.decouple((()=>{t=!1,1===s&&1===n&&e.setLive(!e.vars.live),s=1,n=1}))},onClick:(s,n,a)=>{if(t)return;a.shiftKey&&e.setLive(!e.vars.live);const l=getRelativePosition(e.vars.elements.graphs,s,n);if(!a.shiftKey&&e.config.handle.enabled){const t=e.vars.handleInfo;if(t.primary.active)if(e.config.handle.secondary&&!t.secondary.active)setHandlePosition(e,!1,l.x);else if(e.config.handle.secondary){const s=Math.abs(l.x-t.primary.offset),n=Math.abs(l.x-t.secondary.offset);setHandlePosition(e,s<n,l.x)}else setHandlePosition(e,!0,l.x);else setHandlePosition(e,!0,l.x)}},onDrag:(t,s,n)=>{n.preventDefault(),n.stopPropagation(),0===t&&0===e.vars.zoomStage||updateDrag(e,t,s)},onWheel:(t,s)=>{s.preventDefault(),s.stopPropagation();const n=getRelativePosition(e.vars.elements.graphs,s.clientX,s.clientY);if(s.shiftKey){const s=null===e.vars.displayDurationUpdate?e.vars.displayDuration:e.vars.displayDurationUpdate;let a=s;t<0&&s<e.vars.displayDurations[e.vars.displayDurations.length-1]?a=e.vars.displayDurations.find((e=>e>s)):t>0&&s>e.vars.displayDurations[0]&&(a=e.vars.displayDurations.slice().reverse().find((e=>e<s))),a!==s&&(e.vars.live&&e.setLive(!1),clearTimeout(e.vars.durationUpdateTimeout),e.vars.displayDurationUpdate=a,e.vars.durationUpdateTimeout=setTimeout((()=>{e.vars.displayDurationUpdate=null,e.setDisplayDuration(a,n.x)}),100))}else t>0&&e.vars.zoomStage<e.vars.zoomStages.length-1?(e.vars.zoomStage=e.vars.zoomStage+1,e.vars.focusY=n.y,updateZoomStage(e,n.y)):t<0&&e.vars.zoomStage>0&&(e.vars.zoomStage=e.vars.zoomStage-1,e.vars.focusY=n.y,updateZoomStage(e,n.y))},onScale:(t,a,l,o,r,c)=>{if((r>=1.25*n||r<=.75*n)&&(r>n&&e.vars.zoomStage<e.vars.zoomStages.length-1?(e.vars.zoomStage=e.vars.zoomStage+1,e.vars.focusY=l,updateZoomStage(e,l),n*=1.25):r<n&&e.vars.zoomStage>0&&(e.vars.zoomStage=e.vars.zoomStage-1,e.vars.focusY=l,updateZoomStage(e,l),n*=.75)),o>=1.25*s||o<=.75*s){const t=null===e.vars.displayDurationUpdate?e.vars.displayDuration:e.vars.displayDurationUpdate;let n=t;o<s&&t<e.vars.displayDurations[e.vars.displayDurations.length-1]?(n=e.vars.displayDurations.find((e=>e>t)),s*=.75):o>s&&t>e.vars.displayDurations[0]&&(n=e.vars.displayDurations.slice().reverse().find((e=>e<t)),s*=1.25),n!==t&&(e.vars.live&&e.setLive(!1),clearTimeout(e.vars.durationUpdateTimeout),e.vars.displayDurationUpdate=n,e.vars.durationUpdateTimeout=setTimeout((()=>{e.vars.displayDurationUpdate=null,e.setDisplayDuration(n,a)}),100))}}}}(this);if(this.vars.inputListeners.push(new r(t.vars.elements.graphs,u,{dragThreshold:10})),this.vars.inputListeners.push(new c(t.vars.elements.graphs,u,!1,{dragThreshold:10})),t.vars.elements.graphs.oncontextmenu=e=>{e.preventDefault()},"timeline"===t.vars.xAxisMode){const{Timeline:e}=shmi.requires("visuals.controls.iqtrend.timeline"),s=Date.now();this.vars.xAxis=new e(t.vars.elements.xAxis,{min:s-t.vars.displayDuration,max:s,numSteps:21,mirrored:!1,markerFormats:t.config.timelineMarkerFormats,startMarkerFormat:t.config.timelineStartMarkerFormat},fireDisplayTimeUpdate.bind(null,t))}else{const{XAxis:e}=shmi.requires("visuals.controls.iqtrend.xaxis");this.vars.xAxis=new e(t.vars.elements.xAxis,{min:0,max:100,numSteps:21,mirrored:!1},fireDisplayTimeUpdate.bind(null,t))}if(t.config.showComments){const{MarkerLayer:e}=shmi.requires("visuals.controls.iqtrend.markerlayer");this.vars.markerLayer=new e(this.vars.elements.markerLayer,this)}if(this.config.datasource&&"string"==typeof this.config.datasource.type&&"string"==typeof this.config.datasource.name&&(this.vars.datasource.type=this.config.datasource.type,this.vars.datasource.name=this.config.datasource.name),"trend"===this.vars.datasource.type){const{DataSourceTrend:e}=shmi.requires("visuals.controls.iqtrend.datasourceTrend");this.vars.datasource.source=new e(this.vars.datasource.name),this.vars.loadingToken=this.vars.datasource.source.watch((({loading:e})=>{"boolean"==typeof e&&(e?shmi.addClass(t.vars.elements.loadingIndicator,"loading"):shmi.removeClass(t.vars.elements.loadingIndicator,"loading"))}))}},addGraphValue:function(e,t){const s=this,n=shmi.cloneObject(t);s.vars.selectedValues.push({name:e,options:n}),s.vars.valueTokens.push(addGraphValue(s,e,n)),updateHighlightState(s),s.vars.datasource.source.select(e),updateWidgetSettings(s)},removeGraph:function(e){const t=this;let s=-1,n=null;"number"==typeof e?t.vars.selectedValues[e]&&(s=e):"string"==typeof e&&(s=t.vars.selectedValues.findIndex((t=>t.name===e))),s>=0&&(1===t.vars.selectedValues.length&&t.isLive()&&t.setLive(!1),n=t.vars.selectedValues[s].name,t.vars.selectedValues[s].options&&t.vars.selectedValues[s].options.highlight&&t.setGraphOptions(n,{highlight:!1}),t.vars.selectedValues.splice(s,1),t.vars.datasource.source.deselect(n),t.vars.valueTokens[s].setToken.unwatch(),t.vars.valueTokens.splice(s,1),t.vars.datasets[s].remove(),t.vars.datasets.splice(s,1),updateWidgetSettings(t),t.updateHandles())},setGraphOptions(e,t){const s=this,n=s.vars.datasets.find((t=>t.name===e)),a=s.vars.selectedValues.find((t=>t.name===e)),l={},o={};let r=!1,c=!1,u=!1;if(n&&a){if("number"==typeof t.style){const e=s.getValueStyles();l.style=e[t.style]?e[t.style]:s.config.defaultValueStyle,a.options.style=t.style,r=!0,c=!0}if("boolean"==typeof t.drawTolerance&&(l.drawTolerance=t.drawTolerance,a.options.drawTolerance=t.drawTolerance,o.tolerance={name:e,drawTolerance:t.drawTolerance},r=!0,u=!0),"boolean"==typeof t.fillCurve&&(l.fillCurve=t.fillCurve,a.options.fillCurve=t.fillCurve,r=!0),t.limits&&"string"==typeof t.limits.mode){a.options.limits=a.options.limits||{},a.options.limits=t.limits;const s=shmi.cloneObject(t.limits);s.name=e,o.limits=s,u=!0}if((null===t.scaleGroup||"number"==typeof t.scaleGroup)&&n.groupId!==t.scaleGroup)if(a.options.scaleGroup=t.scaleGroup,n.scaleGroup&&"number"==typeof n.groupId&&n.scaleGroup.removeValue(e),n.groupId=t.scaleGroup,null===t.scaleGroup)n.scaleGroup&&0===n.scaleGroup.getValueNames().length&&delete s.vars.scaleGroups[n.scaleGroup.groupId],n.scaleGroup=null;else if(s.vars.scaleGroups[t.scaleGroup])n.scaleGroup=s.vars.scaleGroups[t.scaleGroup],n.scaleGroup.addValue(e,n);else{const{ScaleGroup:e}=shmi.requires("visuals.controls.iqtrend.scalegroup");s.vars.scaleGroups[t.scaleGroup]=n.scaleGroup=new e(t.scaleGroup,this,n)}t.scale&&("string"==typeof t.scale.location&&(n.scaleGroup?setScaleGroupOption(s,n.scaleGroup,"location",t.scale.location):(a.options.scale=a.options.scale||{},a.options.scale.location=t.scale.location,n.scale.setOptions({location:t.scale.location}))),"boolean"==typeof t.scale.hidden&&(n.scaleGroup?setScaleGroupOption(s,n.scaleGroup,"hidden",t.scale.hidden):(a.options.scale=a.options.scale||{},a.options.scale.hidden=t.scale.hidden,t.scale.hidden!==n.scale.hidden&&n.scale.setOptions({hidden:t.scale.hidden})))),"boolean"==typeof t.highlight&&(s.vars.datasets.forEach(((n,a)=>{!1===t.highlight||n.name!==e?s.vars.selectedValues[a].options.highlight=!1:s.vars.selectedValues[a].options.highlight=!0})),updateHighlightState(s),c=!0),r&&n.setOptions(l),u&&s.vars.datasource.source.setOptions(o),c&&s.updateHandles(),s.fire("graph-options",shmi.cloneObject(a)),updateWidgetSettings(s)}else console.warn(`[IqTrend] cannot set options for unknown graph: ${e}`)},getSelectedValues:function(){const e=this,t=shmi.cloneObject(e.vars.selectedValues);return t.forEach((t=>{const s=e.vars.datasets.find((e=>e.name===t.name));s&&s.scaleGroup&&(t.options.scale=t.options.scale||{},t.options.scale.location=s.scaleGroup.master.dataset.scale.location,t.options.scale.hidden=s.scaleGroup.master.dataset.scale.hidden)})),t},setSelectedValues:function(e){if(!this.isActive())return void console.error("Cannot set selected values while widget is inactive.");if(!Array.isArray(e)||!e.every((e=>"string"==typeof e.name&&e.options&&"object"==typeof e.options)))throw console.error("Parameter contains invalid value definitions:",e),new Error("Parameter contains invalid value definitions.");const t=this,s=t.vars.selectedValues.map((e=>e.name)),n=t.isLive()||0===s.length&&t.config.startLive;t.vars.restoreLiveToken&&(t.vars.restoreLiveToken.unwatch(),t.vars.restoreLiveToken=null),t.vars.selectedValues=shmi.cloneObject(e),t.vars.datasource.source.deselect(...s),t.vars.valueTokens.forEach((e=>{e.setToken.unwatch()})),t.vars.valueTokens=[],t.vars.datasets.forEach((e=>{e.remove()})),t.vars.datasets=[],t.vars.selectedValues.forEach((e=>{t.vars.valueTokens.push(addGraphValue(t,e.name,e.options))})),t.vars.datasource.source.select(...t.vars.selectedValues.map((e=>e.name))),n&&(t.vars.datasource.source._busy?t.vars.restoreLiveToken=t.vars.datasource.source.watch((()=>{t.vars.datasource.source._busy||(t.vars.restoreLiveToken.unwatch(),t.vars.restoreLiveToken=null,t.setLive(!0))})):t.setLive(!0)),updateHighlightState(t),updateWidgetSettings(t)},setDisplayDuration:function(e,t=0){this.vars.live&&this.setLive(!1),this.vars.displayDuration=e,this.fire("display-duration",{duration:this.vars.displayDuration}),function updateDisplayDuration(e,t,s){const n=e.vars.datasets[0],a=Date.now(),l=Math.round(n.getTimeAt(s)),o=n.getDimensions().x,r=o.max-o.min;let c=l-(l-o.min)/r*t,u=c+t;c<0?(c+=0-c,u=c+t):u>a&&(u-=u-a,c=u-t);e.vars.xAxis.setOptions({x:{min:c,max:u}}),e.vars.datasets.forEach((e=>{e.setOptions({x:{min:c,max:u}},!0)})),e.vars.markerLayer&&e.vars.markerLayer.setOptions({x:{min:c,max:u}}),e.vars.xAxis.draw(),e.vars.datasets.forEach((e=>{e.update()}));const h=n.getDimensions();e.vars.datasource.source.setOptions({tStart:c,duration:u-c,interval:Math.ceil((h.x.max-h.x.min)/h.width*m)})}(this,e,t)},getDisplayDuration:function(){return this.vars.displayDuration},getDisplayDurations:function(){return shmi.cloneObject(this.vars.displayDurations)},onEnable:function(){const e=this;e.vars.live=!0===e.config.startLive,Array.isArray(e.config.selectedValues)&&(e.vars.selectedValues=shmi.cloneObject(e.config.selectedValues)),e.vars.selectedValues.forEach((t=>{e.vars.valueTokens.push(addGraphValue(e,t.name,t.options))})),updateHighlightState(e),e.vars.handleToken=e.vars.datasource.source.watch((({info:t,data:s})=>{if(t&&s&&t.values){e.vars.datasets.forEach((n=>{const a=n.name;t.values[a]&&(n.setOptions({interval:t.values[a].interval,unit:t.values[a].unit,discrete:"boolean"===t.values[a].data_type||t.values[a].discrete}),"string"!==t.values[a].data_type||n.scale.hidden||n.scale.setOptions({hidden:!0}),updateZoomStage(e,e.vars.focusY,n)),s.values[a]&&(n.clearValues(),n.addValues(function getSourceDataValues(e,t){const s=[],n=e.values[t];return Object.keys(n).forEach((e=>{s.push(...n[e].map((([t,s])=>"item"===e?[t,s,null]:[t,s,e])))})),s}(s,a)),n.update())})),e.updateHandles();const n=shmi.cloneObject(t.values),a=[];Object.keys(n).forEach((e=>{"number"==typeof n[e].interval&&"string"==typeof n[e].data_type?a.push(e):delete n[e]})),a.sort(),a.length===e.vars.lastValueInfo.length&&e.vars.lastValueInfo.every(((e,t)=>e===a[t]))||(e.fire("value-info",shmi.cloneObject(n)),e.vars.lastValueInfo=a)}}));const t=e.vars.selectedValues.map((e=>e.name));e.vars.datasource.source.select(...t),e.vars.inputListeners.forEach((e=>{e.enable()})),e.config.showComments&&(e.vars.markerToken=e.vars.datasource.source.watch((({comments:t,alarms:s})=>{t&&(e.vars.markerLayer.clearMarkers("comment"),e.vars.markerLayer.addMarkers(t)),s&&(e.vars.markerLayer.clearMarkers("alarm"),e.vars.markerLayer.addMarkers(s))}))),e.controls.forEach((e=>{e.enable()})),e.setLive(e.vars.live)},isLive:function(){return this.vars.live},setLive:function(t){const s=this,{source:n}=s.vars.datasource;n.hasLive?t!==n.isLive&&(s.vars.live=n.setLive(t),s.fire("live",{isLive:s.vars.live}),s.vars.live?function updateGraph(){if(s.isActive()&&s.vars.live){const e=Date.now(),t=e-s.vars.displayDuration;s.vars.xAxis.setOptions({x:{min:t,max:e}}),s.vars.datasets.forEach((s=>{s.setOptions({x:{min:t,max:e}},!0)})),s.vars.markerLayer&&s.vars.markerLayer.setOptions({x:{min:t,max:e}}),s.vars.datasource.source.setOptions({tStart:t},!0),s.updateHandles(),s.vars.rafId=shmi.raf(updateGraph)}}():(shmi.caf(s.vars.rafId),s.vars.rafId=0)):console.log(`[${e}] live mode not available with current datatsource.`)},onDisable:function(){const e=this;shmi.caf(e.vars.rafId),e.vars.rafId=0,e.vars.live&&e.setLive(!1),e.vars.handleToken&&(e.vars.handleToken.unwatch(),e.vars.handleToken=null);const t=e.vars.selectedValues.map((e=>e.name));e.vars.datasource.source.deselect(...t),e.vars.valueTokens.forEach((e=>{e.setToken.unwatch()})),e.vars.valueTokens=[],e.vars.datasets.forEach((e=>{e.remove()})),e.vars.datasets=[],e.vars.inputListeners.forEach((e=>{e.disable()})),e.controls.forEach((e=>{e.disable()})),e.vars.lastValueInfo=[]},onLock:function(){this.vars.inputListeners.forEach((e=>{e.disable()})),this.controls.forEach((e=>{e.lock()}))},onUnlock:function(){this.vars.inputListeners.forEach((e=>{e.enable()})),this.controls.forEach((e=>{e.unlock()}))},onDelete:function(){this.vars.xAxis&&(this.vars.xAxis.remove(),this.vars.xAxis=null),this.vars.loadingToken&&(this.vars.loadingToken.unwatch(),this.vars.loadingToken=null),this.vars.eventTokens.forEach((e=>{e.unlisten()})),this.vars.eventTokens=[]},setOptions:function(e){const t=this,{xAxis:s}=t.vars;"number"==typeof e.tStart&&(t.vars.live&&t.setLive(!1),s.setOptions({x:{min:e.tStart,max:e.tStart+t.vars.displayDuration}}),t.vars.datasets.forEach((s=>{s.setOptions({x:{min:e.tStart,max:e.tStart+t.vars.displayDuration}},!0)})),t.vars.markerLayer&&t.vars.markerLayer.setOptions({x:{min:e.tStart,max:e.tStart+t.vars.displayDuration}}),t.vars.datasource.source.setOptions({tStart:e.tStart}))},updateHandles(){this.vars.handleInfo.primary.active&&(updateHandleTime(this,!0),updateHandleValues(this,!0)),this.vars.handleInfo.secondary.active&&(updateHandleTime(this,!1),updateHandleValues(this,!1))},getHandleInfo(){const e=shmi.cloneObject(this.vars.handleInfo);return e.primary.active?(delete e.primary.active,delete e.primary.graphWidth,delete e.primary.offset,Object.keys(e.primary.values).forEach((t=>{e.primary.values[t]=e.primary.values[t].info}))):e.primary=null,e.secondary.active?(delete e.secondary.active,delete e.secondary.graphWidth,delete e.secondary.offset,Object.keys(e.secondary.values).forEach((t=>{e.secondary.values[t]=e.secondary.values[t].info}))):e.secondary=null,e},getValueInfo(){return this.vars.datasource.source?this.vars.datasource.source.getValueSettings():null},getTrendInfo(){if(this.vars.datasource.source){const e=this.vars.datasource.source.getTrendSettings();return e.type=this.vars.datasource.type,e.name=this.vars.datasource.name,e}return null},getInactiveStyle(){return shmi.cloneObject(this.config.inactiveStyle?this.config.inactiveStyle:s)},getDefaultStyle(){return shmi.cloneObject(this.config.defaultValueStyle?this.config.defaultValueStyle:t)},getValueStyles(){return shmi.cloneObject(this.config.valueStyles)},setHandlePosition(e=!0,t,s=!0){setHandlePosition(this,e,t,s)},zoomInY(){const e=this;if(e.vars.zoomStage<e.vars.zoomStages.length-1){const t=e.vars.elements.graphs.getBoundingClientRect(),s=Math.floor(t.height/2);e.vars.zoomStage=e.vars.zoomStage+1,e.vars.focusY=s,updateZoomStage(e,s)}},zoomOutY(){const e=this;if(e.vars.zoomStage>0){const t=e.vars.elements.graphs.getBoundingClientRect(),s=Math.floor(t.height/2);e.vars.zoomStage=e.vars.zoomStage-1,e.vars.focusY=s,updateZoomStage(e,s)}},getZoomStage(){return this.vars.zoomStages[this.vars.zoomStage]},getZoomStages(){return shmi.cloneObject(this.vars.zoomStages)},zoomInX(){const e=this,{displayDuration:t}=e.vars;let s=t;if(t>e.vars.displayDurations[0]){const n=e.vars.elements.graphs.getBoundingClientRect(),a=Math.floor(n.width/2);s=e.vars.displayDurations.slice().reverse().find((e=>e<t)),e.vars.live&&e.setLive(!1),e.setDisplayDuration(s,a)}},zoomOutX(){const e=this,{displayDuration:t}=e.vars;let s=t;if(t<e.vars.displayDurations[e.vars.displayDurations.length-1]){const n=e.vars.elements.graphs.getBoundingClientRect(),a=Math.floor(n.width/2);s=e.vars.displayDurations.find((e=>e>t)),e.vars.live&&e.setLive(!1),e.setDisplayDuration(s,a)}},getDimensionsX(){return this.vars.xAxis.getDimensions()}}};shmi.requires("visuals.tools.control-generator").generate(h)}(),function(){"use strict";const e=shmi.pkg("visuals.controls.iqtrend.common");let t=null,s=null;e.taskStates={CREATED:1,RUNNING:2,DONE:3,ERROR:4,CANCELED:5},e.getTextDimensions=function(e,n="400 12px RobotoLight"){t||(t=document.createElement("canvas")),s||(s=t.getContext("2d")),s.font=n;const a=s.measureText(e);return a.fontHeight=a.fontBoundingBoxAscent+a.fontBoundingBoxDescent,a.textHeight=a.actualBoundingBoxAscent+a.actualBoundingBoxDescent,a},e.getFontStyle=function(e){const t=getComputedStyle(e);return`${t.fontWeight} ${t.fontSize} ${t.fontFamily}`}}(),function(){"use strict";const e=shmi.pkg("visuals.controls.iqtrend.dataset");function isGroupMaster(e){return e.scaleGroup&&e.scaleGroup.master.dataset===e}e.DataSet=class DataSet{constructor(e,t,s){const{Graph:n}=shmi.requires("visuals.controls.iqtrend.graph"),{Scale:a}=shmi.requires("visuals.controls.iqtrend.scale"),{ScaleGroup:l}=shmi.requires("visuals.controls.iqtrend.scalegroup");this.name=t.name,this.trendWidget=s,this.groupId=t.scaleGroup,t.dataset=this;const{scaleGroups:o}=this.trendWidget.vars;null!==this.groupId&&(o[this.groupId]?(this.scaleGroup=o[this.groupId],this.scaleGroup.addValue(this.name,this)):this.scaleGroup=o[this.groupId]=new l(this.groupId,this.trendWidget,this)),this.graph=new n(e.graphs,t),t.scale&&"right"===t.scale.location?this.scale=new a(e.scalesRight,{mirrored:"left"!==t.scale.align,align:t.scale.align?t.scale.align:"right",location:"right",hidden:!(!this.scaleGroup||isGroupMaster(this))||!(!t.scale||"boolean"!=typeof t.scale.hidden)&&t.scale.hidden,valueName:t.name,autoWidth:!!this.trendWidget.config.autoScaleWidth},this):this.scale=new a(e.scalesLeft,{mirrored:t.scale&&"right"===t.scale.align,align:t.scale&&t.scale.align?t.scale.align:"left",location:"left",hidden:!(!this.scaleGroup||isGroupMaster(this))||!(!t.scale||"boolean"!=typeof t.scale.hidden)&&t.scale.hidden,valueName:t.name,autoWidth:!!this.trendWidget.config.autoScaleWidth},this),this.trendWidget.vars.datasets.push(this),this.scaleGroup&&!isGroupMaster(this)&&this.scaleGroup.master.dataset.scale.setOptions({addValue:this.name})}getDimensions(){return this.graph.getDimensions()}setOptions(e){e.y&&this.scaleGroup&&(this.scaleGroup.setOptions({y:e.y},this.name),delete(e=shmi.cloneObject(e)).y),this.graph.setOptions(e),this.scale.setOptions(e),e.style&&this.scaleGroup&&!isGroupMaster(this)&&this.scaleGroup.master.dataset.scale.setOptions({style:e.style})}addValue(){this.graph.addValue.apply(this.graph,arguments)}addValues(){this.graph.addValues.apply(this.graph,arguments)}clearValues(){this.graph.clearValues()}getValue(){return this.graph.getValue.apply(this.graph,arguments)}getValueAtY(){return this.graph.getValueAtY.apply(this.graph,arguments)}getTimeAt(){return this.graph.getTimeAt.apply(this.graph,arguments)}watch(){return this.graph.watch.apply(this.graph,arguments)}update(){this.graph.draw(),this.scale.draw()}remove(){this.graph.remove(),this.scale.remove(),this.scaleGroup&&(this.scaleGroup.removeValue(this.name),0===this.scaleGroup.getValueNames().length&&delete this.trendWidget.vars.scaleGroups[this.scaleGroup.groupId],this.scaleGroup=null)}}}(),function(){"use strict";const e=shmi.pkg("visuals.controls.iqtrend.datasource");const t="Abstract method has no implementation:";e.DataSource=class DataSource{constructor(){this._name="AbstractDataSource",this._type="abstract",this._hasLive=!1,this._hasArchived=!1,this._hasComments=!1,this._hasAlarms=!1,this._isLive=!1,this._tStart=0,this._tEnd=0,this._interval=0}get name(){return this._name}get type(){return this._type}get hasLive(){return this._hasLive}get hasArchived(){return this._hasArchived}get hasComments(){return this._hasComments}get hasAlarms(){return this._hasAlarms}get isLive(){return this._isLive}get interval(){return this._interval}setLive(e){if(!this._hasLive)throw new Error("Data source does not support live mode")}getValueSettings(){throw new Error(`[${this.name}] ${t} getValueSettings`)}getTrendSettings(){throw new Error(`[${this.name}] ${t} getTrendSettings`)}setOptions(e,s){throw new Error(`[${this.name}] ${t} setOptions`)}select(...e){throw new Error(`[${this.name}] ${t} select`)}deselect(...e){throw new Error(`[${this.name}] ${t} deselect`)}watch(e){throw new Error(`[${this.name}] ${t} watch`)}reloadComments(){throw new Error(`[${this.name}] ${t} reloadComments`)}reloadAlarms(){throw new Error(`[${this.name}] ${t} reloadAlarms`)}}}(),function(){"use strict";const e=shmi.pkg("visuals.controls.iqtrend.datasourceTrend"),t=!1;function log(){t&&console.log.apply(console,arguments)}const{DataSource:s}=shmi.requires("visuals.controls.iqtrend.datasource"),{taskStates:n}=shmi.requires("visuals.controls.iqtrend.common");function getMax(e,t){let s=null;return Array.isArray(t)&&(t.length>=2&&t[0][0]<e.data.start&&t[1][0]<=e.data.start&&t.shift(),t.forEach((([e,t])=>{"number"==typeof t&&(null===s||t>s)&&(s=t)}))),s}function getMin(e,t){let s=null;return Array.isArray(t)&&(t.length>=2&&t[0][0]<e.data.start&&t[1][0]<=e.data.start&&t.shift(),t.forEach((([e,t])=>{"number"==typeof t&&(null===s||t<s)&&(s=t)}))),s}function sortAndFilterValues(e,t,s){const n=e.data.values[t];return n[s].sort(((e,t)=>e[0]-t[0])),n[s]=n[s].filter(((a,l,o)=>{let r=!0,c=!0;if(a[0]<e.data.start)return!(!r||Array.isArray(o[l+1])&&!(o[l+1][0]>=e.data.start))&&(r=!1,!0);if(a[0]>e.data.end)return!!c&&(c=!1,!0);if(0===l)return!0;const u=a[0]===o[l-1][0];return u&&log("Duplicate datapoint:","item"===s?t:`${t}.${s}`,a[0],`${a[1]} (${n[s][l-1][1]})`),!u})),n[s]}function initValues(e,t){e.data.values[t]||(e.data.values[t]={item:[],display_min:[],display_max:[],display_trend_min:[],display_trend_max:[],prewarn_min:[],prewarn_max:[],tolerance_upper:[],tolerance_lower:[],warn_min:[],warn_max:[],stepsize:[]})}function processTrendData(e,t,s){const n=shmi.requires("visuals.tools.unitClasses"),a=e._valueSettings[t];if(null!==s&&a&&function isUnitClass(e){return("string"!=typeof e||""!==e.trim())&&!isNaN(e)}(a.unit)){const e=parseInt(a.unit),t=n.getSelectedAdapter(e);t&&(s=t.outFunction(s))}return s}function updateLimits(e,t){initValues(e,t);const s=e.data.values[t],n=e._valueSettings[t];if(n){if("manual"!==n.limits.mode||"number"==typeof n.limits.min&&"number"==typeof n.limits.max||(n.limits.mode="auto",console.info("[iq-trend] changed limit mode from 'manual' to 'auto' due to missing limit specification.")),"config"===n.limits.mode){const t=getMin(e,s.display_trend_min.length?s.display_trend_min:s.display_min),a=getMax(e,s.display_trend_max.length?s.display_trend_max:s.display_max);n.min=null!==t?t:null,n.max=null!==a?a:null}if("auto"===n.limits.mode||"config"===n.limits.mode&&(null===n.min||null===n.max)){let t=null,a=null;if(n.drawTolerance){let n=getMin(e,s.tolerance_lower),l=getMax(e,s.tolerance_upper);t=Math.min(...[n,getMin(e,s.item)].filter((e=>null!==e))),t===Number.POSITIVE_INFINITY&&(t=null),a=Math.max(...[l,getMax(e,s.item)].filter((e=>null!==e))),a===Number.NEGATIVE_INFINITY&&(a=null)}else t=getMin(e,s.item),a=getMax(e,s.item);"number"==typeof n.limits.step&&(null!==t&&(t=Math.floor(t/n.limits.step)*n.limits.step),null!==a&&(a=Math.ceil(a/n.limits.step)*n.limits.step)),n.min=null===t?"number"==typeof n.min?n.min:null:t,n.max=null===a?"number"==typeof n.max?n.max:null:a}else"manual"===n.limits.mode&&(n.min=n.limits.min,n.max=n.limits.max);"string"===n.data_type||null===n.min||null===n.max?(n.min=0,n.max=1):"number"==typeof n.min&&n.min===n.max&&(n.min-=.5,n.max+=.5)}}async function loadData({self:e,tStart:t,tEnd:s},a){const{TrendManager2:l}=shmi.requires("visuals.core"),o=await l.query(e._name,e.selectedValues,t,s,e._interval);return a.state!==n.CANCELED?(o.forEach((t=>{if(e.selectedValues.includes(t.item_alias)){e._valueSettings[t.item_alias]=e._valueSettings[t.item_alias]||{limits:{mode:"config",min:null,max:null}};e._valueSettings[t.item_alias].interval=t.resolution,function insertItemValues(e,t){initValues(e,t.item_alias);const s=e.data.values[t.item_alias];Object.keys(t.values).forEach((n=>{t.values[n].map((s=>[s[0],processTrendData(e,t.item_alias,s[1])])).forEach((e=>{s[n].push(e)})),sortAndFilterValues(e,t.item_alias,n)}))}(e,t),updateLimits(e,t.item_alias)}})),Promise.resolve().then((()=>{notifyWatchers(e)}))):null}async function loadInfo({self:e},t){const{TrendManager2:s}=shmi.requires("visuals.core"),a=await s.getInfo(e._name,e.selectedValues);t.state!==n.CANCELED&&(e._trendSettings=e._trendSettings||{},e._trendSettings.start=a.record_first,e._trendSettings.end=a.record_last,e._trendSettings.trend_id=a.trend_id,a.items.forEach((t=>{e._valueSettings[t.name]=e._valueSettings[t.name]||{limits:{mode:"config",min:null,max:null}},Object.keys(t).forEach((s=>{e._valueSettings[t.name][s]=t[s]}))})),e._infoSet=!0)}async function loadThreads({self:e,tStart:t,tEnd:s},a){const l=shmi.requires("visuals.tools.threads"),o=void 0===e._trendSettings.trend_id?{threads:[]}:await l.list("trend",e._trendSettings.trend_id,{tStart:t,tEnd:s,loadUserDisplayName:!0});return a.state!==n.CANCELED?(function insertMarkers(e,t,s){const n=t.map((e=>e.id));e.data.markers[s]=e.data.markers[s].filter((e=>!n.includes(e.id))),t.forEach((t=>{e.data.markers[s].push(t)})),function sortAndFilterMarkers(e,t){let s=e.data.markers[t];s.sort(((e,t)=>e.timestamp-t.timestamp)),s=s.filter((t=>e.data.start<=t.timestamp&&t.timestamp<=e.data.end)),e.data.markers[t]=s}(e,s)}(e,o.threads.map((e=>({timestamp:e.reference_timestamp,id:e.thread_id,type:"comment"}))),"comment"),Promise.resolve().then((()=>{notifyWatchers(e,{comments:!0})}))):null}function reloadAll(e,t=!1,s=!1){const{TrendTask:a}=shmi.requires("visuals.controls.iqtrend.trendtask");if(e.queue.getTasks().forEach((e=>{t?"info"!==e.type&&(e.state=n.CANCELED):e.state=n.CANCELED})),!t||!e._infoSet){const t=new a("info",{self:e},loadInfo);e.queue.queueTask(t)}const l=Date.now(),o=Math.floor(e._tStart-e._duration/2),r=Math.min(l,Math.ceil(e._tEnd+e._duration/2));e.data.start=o,e.data.end=s?Number.MAX_SAFE_INTEGER:r,e.data.values={};const c=new a("load",{self:e,tStart:o,tEnd:r},loadData);if(e.queue.queueTask(c),e._loadComments){e.data.markers.comment=[];const t=new a("threads",{self:e,tStart:o,tEnd:r},loadThreads);e.queue.queueTask(t)}}function loadSlice(e,t,s){const{TrendTask:n}=shmi.requires("visuals.controls.iqtrend.trendtask");t<e.data.start?(e.data.start=t,e.data.end>t+3*e._duration&&(e.data.end=t+2*e._duration)):s>e.data.end&&(e.data.end=s,e.data.start<s-3*e._duration&&(e.data.start=s-2*e._duration));const a=new n("load",{self:e,tStart:t,tEnd:s},loadData);if(e.queue.queueTask(a),e._loadComments){const a=new n("threads",{self:e,tStart:t,tEnd:s},loadThreads);e.queue.queueTask(a)}}function notifyWatchers(e,t={loadingState:!1,comments:!1,alarms:!1}){t.loadingState?e.watchers.forEach((t=>{t({source:e,loading:e.queue.loading})})):t.comments?e.watchers.forEach((t=>{t({source:e,comments:e.data.markers.comment})})):t.alarms?e.watchers.forEach((t=>{t({source:e,alarms:e.data.markers.alarm})})):e.watchers.forEach((t=>{t({source:e,info:{range:e._trendSettings,values:e._valueSettings},data:e.data})}))}async function enableLive(e,t=!1){e._isLive=!0,e._busy=!0,e.setOptions({tStart:Date.now()-e._duration},!0);try{const{TrendManager2:t}=shmi.requires("visuals.session");e._subscriptionId=await t.subscribe(e._name,e.selectedValues,e._interval,(t=>{!function insertLiveValues(e,t){const s=e.data.values;let n=Date.now();t.forEach((t=>{e.selectedValues.includes(t.item)&&t.timestamp<n&&(n=t.timestamp)}));const a=n-2*e._duration;a>e.data.start&&(e.data.start=a);const l=[];t.forEach((t=>{if(!e.selectedValues.includes(t.item))return;l.includes(t.item)||l.push(t.item),initValues(e,t.item);const n=null===t.property?"item":t.property;s[t.item][n].push([t.timestamp,processTrendData(e,t.item,t.value)]),sortAndFilterValues(e,t.item,n)})),l.forEach((t=>{updateLimits(e,t)}))}(e,t),notifyWatchers(e)})),e._busy=!1}catch(t){e._busy=!1,console.error("[trend2.subscribe] Error subscribing live trend:",t)}reloadAll(e,!t,!0)}async function disableLive(e){const{TrendManager2:t}=shmi.requires("visuals.session");if(e._isLive=!1,null!==e._subscriptionId){e._busy=!0;try{await t.unsubscribe(e._subscriptionId),e._subscriptionId=null,e._busy=!1;const s=e.data.values;let n=Date.now();Object.entries(s).forEach((([e,t])=>{if(t.length){const e=t[t.length-1][0];e<n&&(n=e)}})),e.data.end=n}catch(t){e._busy=!1,console.error("[trend2.unsubscribe] Error unsubscribing live trend:",t)}}}e.DataSourceTrend=class DataSourceTrend extends s{constructor(e){super();const{TaskQueue:t}=shmi.requires("visuals.controls.iqtrend.taskqueue");this._name=e,this._type="trend",this._hasLive=!0,this._hasArchived=!0,this._hasComments=!0,this._hasAlarms=!1,this._isLive=!1,this._tStart=0,this._duration=0,this._interval=0,this._tEnd=this._tStart+this._duration,this.data={start:0,end:0,values:{},markers:{comment:[],alarm:[]}},this._infoSet=!1,this._loadComments=!1,this.selectedValues=[],this.watchers=[],this.queue=new t,this.queue.watch((()=>{notifyWatchers(this,{loadingState:!0})})),this._loadQueue=[],this._valueSettings={},this._trendSettings={start:0,end:0},this._busy=!1,this._subscriptionId=null}getValueSettings(){return shmi.cloneObject(this._valueSettings)}getTrendSettings(){return shmi.cloneObject(this._trendSettings)}setOptions(e,t=!1){if(!e)throw new Error("No options provided");let s=!1,n=!1,a=!1;if("number"==typeof e.tStart&&this._tStart!==e.tStart&&(this._tStart=e.tStart,s=!0),"number"==typeof e.duration&&this._duration!==e.duration&&(this._duration=e.duration,s=!0),"number"==typeof e.interval&&this._interval!==e.interval&&(this._interval=Math.max(1,e.interval),n=!0),s&&(this._tEnd=this._tStart+this._duration),e.tolerance&&"boolean"==typeof e.tolerance.drawTolerance&&"string"==typeof e.tolerance.name&&(this._valueSettings[e.tolerance.name]=this._valueSettings[e.tolerance.name]||{limits:{mode:"config",min:null,max:null}},this._valueSettings[e.tolerance.name].drawTolerance=e.tolerance.drawTolerance),e.limits&&"object"==typeof e.limits&&"string"==typeof e.limits.name){const t=shmi.cloneObject(e.limits);delete t.name,this._valueSettings[e.limits.name]=this._valueSettings[e.limits.name]||{},this._valueSettings[e.limits.name].limits=t,updateLimits(this,e.limits.name),a=!0}e.loadComments&&"boolean"==typeof e.loadComments&&(this._loadComments=!0),t||async function updateData(e,{timeChanged:t,intervalChanged:s,limitsChanged:n}){if(s)e.isLive?(await disableLive(e),await enableLive(e)):reloadAll(e,!0);else if(t){const t=Math.floor(e._tStart-e._duration/4),s=Math.floor(e._tStart-e._duration/2),n=Date.now(),a=Math.min(n,Math.ceil(e._tEnd+e._duration/4)),l=Math.min(n,Math.ceil(e._tEnd+e._duration/2));l<e.data.start||s>e.data.end?reloadAll(e,!0):t<e.data.start?loadSlice(e,s,e.data.start):a>e.data.end&&loadSlice(e,e.data.end,l)}else n&&notifyWatchers(e)}(this,{timeChanged:s,intervalChanged:n,limitsChanged:a})}select(...e){let t=!1;e.forEach((e=>{this.selectedValues.includes(e)||(log("Add value to selection:",e),this.selectedValues.push(e),t=!0)})),t&&(this.isLive?disableLive(this).then((()=>{enableLive(this,!0)})):reloadAll(this))}deselect(...e){let t=!1;e.forEach((e=>{this.selectedValues.includes(e)&&(log("Remove value from selection:",e),this.selectedValues.splice(this.selectedValues.indexOf(e),1),delete this.data.values[e],delete this._valueSettings[e],t=!0)})),t&&this.selectedValues.length>0?this.isLive?disableLive(this).then((()=>{enableLive(this)})):reloadAll(this):0===this.selectedValues.length&&(this.isLive?disableLive(this).then((()=>{notifyWatchers(this)})):notifyWatchers(this))}setLive(e){if(e===this._isLive)return this._isLive;if(super.setLive(),this._busy)return this._isLive;if(e&&this.selectedValues.length>0)enableLive(this);else{if(!this._subscriptionId)return this._isLive;disableLive(this)}return this._isLive}watch(e){return this.watchers.push(e),{unwatch:()=>{const t=this.watchers.indexOf(e);-1!==t&&this.watchers.splice(t,1)}}}reloadComments(){const{TrendTask:e}=shmi.requires("visuals.controls.iqtrend.trendtask"),t=Math.floor(this._tStart-this._duration/2),s=Math.min(Date.now(),Math.ceil(this._tEnd+this._duration/2));if(this._loadComments){this.data.markers.comment=[];const n=new e("threads",{self:this,tStart:t,tEnd:s},loadThreads);this.queue.queueTask(n)}}}}(),function(){"use strict";const e=shmi.pkg("visuals.controls.iqtrend.graph"),t=!1;function log(){t&&console.log.apply(console,arguments)}function updateSize(e){e.canvas.width=e.width+2,e.canvas.height=e.height+2}function getCoordinates(e,t,s){return{x:null===t?null:(t-e.minX)*e.scaleX+1,y:null===s?null:e.height-(s-e.minY)*e.scaleY+1}}function getSegments(e,t=null){const s=e.values.filter((e=>e.property===t));let n=s.findIndex((t=>t.x>=e.minX));n>0?n-=1:-1===n&&s.length&&(n=s.length-1);let a=[];if(n>=0){for(let t=n;t<s.length;t++){if(a.push({x1:s[t].x,x2:null,y:"boolean"==typeof s[t].y?s[t].y?1:0:s[t].y}),a.length>1){let n=a[a.length-2];const l=s[t].x-n.x1;let o=Math.floor(l/e.interval);const r=l-o*e.interval;!e.discrete&&o>0&&0===r&&(o-=1),n.x2=n.x1+o*e.interval,e.discrete&&(n.x2+=r)}if(s[t].x>=e.maxX)break}if(a.length)if(a[0].x1<e.minX&&(a[0].x2>a[0].x1||null===a[0].x2)&&(a[0].x1=e.minX),a[a.length-1].x1<e.maxX)e.dataset.trendWidget.isLive()&&a[a.length-1].x1+2*e.interval<=e.maxX?a[a.length-1].x2=a[a.length-1].x1+Math.floor((e.maxX-a[a.length-1].x1)/e.interval)*e.interval:!e.dataset.trendWidget.isLive()&&a[a.length-1].x1<e.maxX?a[a.length-1].x2=a[a.length-1].x1+Math.ceil((e.maxX-a[a.length-1].x1)/e.interval)*e.interval:a[a.length-1].x2=a[a.length-1].x1;else{if(a=a.filter(((t,s)=>0===s||t.x1<=e.maxX||a[s-1].x2<e.maxX)),0===a.length)return[];const t=a[a.length-1],s=a[a.length-2];if(s&&t.x1>e.maxX){const n=t.x1-s.x2,a=(t.y-s.y)/n,l=e.maxX-s.x2;t.x1=t.x2=e.maxX,t.y=s.y+l*a}else t.x2>e.maxX&&t.x2>t.x1&&(t.x2=e.maxX)}}return a}function drawLine(e,t,s){if(!s.length)return[];const n=e.context;n.lineWidth=t.lineWidth?t.lineWidth:1,n.strokeStyle=t.strokeStyle?t.strokeStyle:"rgb(0, 0, 0)",Array.isArray(t.lineDash)&&t.lineDash.length?n.setLineDash(t.lineDash):n.setLineDash([]),n.beginPath();let a=null;const l=[];let o=[];return s.forEach((t=>{if("number"!=typeof t.y||null===t.y||null===t.x1||null===t.x2)return a=null,void(o.length&&(l.push(o),o=[]));const s=getCoordinates(e,t.x1,t.y),r=getCoordinates(e,t.x2,null);null===a?(log(`moveTo ${s.x}, ${s.y}`),n.moveTo(s.x,s.y)):(log(`lineTo ${s.x}, ${s.y}`),n.lineTo(s.x,s.y)),a=s.y,log(`lineTo ${r.x}, ${s.y}`),n.lineTo(r.x,s.y),o.push({x1:s.x,x2:r.x,y:s.y})})),o.length&&l.push(o),log("-> stroke"),n.stroke(),l}function setLineStyle(e,t,s){const n=e.style[t];n&&("number"==typeof s.lineWidth&&s.lineWidth>0&&(n.lineWidth=s.lineWidth),"string"==typeof s.strokeStyle&&(n.strokeStyle=s.strokeStyle),"string"==typeof s.fillStyle&&(n.fillStyle=s.fillStyle),Array.isArray(s.lineDash)&&(n.lineDash=s.lineDash))}function findSegmentValue(e,t){const s=e.slice().reverse().find((e=>e.x1<=t)),n=e.find((e=>e.x2>=t));if(!s||!n)return null;if(s===n)return s.y;if("string"==typeof s.y||"string"==typeof n.y)return"string"==typeof s.y?s.y:n.y;const a=s.x2-n.x1,l=t-s.x2,o=n.y-s.y;return s.y-l/a*o}e.Graph=class Graph{constructor(e,{externalDraw:t=!1,x:s={min:0,max:6e4},y:n={min:0,max:100},interval:a=1e3,discrete:l=!1,style:o={value:{lineWidth:1,strokeStyle:"rgb(0, 0, 0)",fillStyle:"rgb(0, 0, 0.05)",lineDash:[]},tolerance:{lineWidth:1,strokeStyle:"rgb(0, 0, 0)",lineDash:[5,5]}},fillCurve:r=!1,drawTolerance:c=!1,dataset:u=null}){this.values=[],this.canvas=document.createElement("canvas"),this.parent=e,this.canvas.classList.add("graph-canvas"),this.parent.appendChild(this.canvas);const m=this.parent.getBoundingClientRect();this.width=m.width-2,this.height=m.height-2,this.style={value:{lineWidth:1,strokeStyle:"rgb(0, 0, 0)",fillStyle:"rgb(0, 0, 0.05)",lineDash:[]},tolerance:{lineWidth:1,strokeStyle:"rgb(0, 0, 0)",lineDash:[5,5]}},this.dataset=u,this.segments={value:[],tolerance:{min:[],max:[]}},this.setOptions({externalDraw:t,x:s,y:n,interval:a,discrete:l,style:o,fillCurve:r,drawTolerance:c},!1),updateSize(this),this.context=this.canvas.getContext("2d");let h=0;this.observer=new ResizeObserver((e=>{const t=e[0];this.width=t.contentRect.width-2,this.height=t.contentRect.height-2,this.scaleX=this.width/(this.maxX-this.minX),this.scaleY=this.height/(this.maxY-this.minY),updateSize(this),shmi.caf(h),h=shmi.raf((()=>{this.parent&&this.watchers.forEach((e=>{e({graph:this,dataset:this.dataset,width:this.width,height:this.height,scale:{x:this.scaleX,y:this.scaleY},dimensions:{x:{min:this.minX,max:this.maxX},y:{min:this.minY,max:this.maxY}}})}))})),this.draw()})),this.watchers=[],this.observer.observe(this.parent),this.draw()}setOptions(e,t=!0){let s=!1,n=!1;"boolean"==typeof e.discrete&&(this.discrete=e.discrete,n=!0),e.y&&"number"==typeof e.y.min&&(this.minY=e.y.min,s=!0),e.y&&"number"==typeof e.y.max&&(this.maxY=e.y.max,s=!0),e.x&&"number"==typeof e.x.min&&(this.minX=e.x.min,s=!0),e.x&&"number"==typeof e.x.max&&(this.maxX=e.x.max,s=!0),"number"==typeof e.interval&&e.interval>0&&(this.interval=e.interval,n=!0),"boolean"==typeof e.externalDraw&&(this.externalDraw=e.externalDraw,n=!0),"boolean"==typeof e.fillCurve&&(this.fillCurve=e.fillCurve,n=!0),"boolean"==typeof e.drawTolerance&&(this.drawTolerance=e.drawTolerance,n=!0),e.style&&(e.style.value&&setLineStyle(this,"value",e.style.value),e.style.tolerance&&setLineStyle(this,"tolerance",e.style.tolerance)),s&&(this.scaleX=this.width/(this.maxX-this.minX),this.scaleY=this.height/(this.maxY-this.minY)),t&&(n||s)&&this.draw()}draw(){if(!this.parent)return;this.context.clearRect(0,0,this.width+2,this.height+2);const e=getSegments(this,null);this.segments.value=e;const t=drawLine(this,{lineWidth:this.style.value.lineWidth,strokeStyle:this.style.value.strokeStyle,lineDash:this.style.value.lineDash},e);if(this.fillCurve&&t.length&&(this.context.fillStyle=this.style.value.fillStyle,t.forEach((e=>{this.context.beginPath(),e.forEach(((e,t)=>{0===t?this.context.moveTo(e.x1,e.y):this.context.lineTo(e.x1,e.y),this.context.lineTo(e.x2,e.y)}));const t=this.height+2;this.context.lineTo(e[e.length-1].x2,t),this.context.lineTo(e[0].x1,t),this.context.closePath(),this.context.fill()}))),this.drawTolerance){const e=getSegments(this,"tolerance_lower"),t=getSegments(this,"tolerance_upper");this.segments.tolerance.min=e,this.segments.tolerance.max=t,drawLine(this,{lineWidth:this.style.tolerance.lineWidth,strokeStyle:this.style.tolerance.strokeStyle,lineDash:this.style.tolerance.lineDash},e),drawLine(this,{lineWidth:this.style.tolerance.lineWidth,strokeStyle:this.style.tolerance.strokeStyle,lineDash:this.style.tolerance.lineDash},t)}}getTimeAt(e){e-=1;const t=this.maxX-this.minX;return this.minX+e/this.width*t}getValueAtY(e){e-=1;const t=this.maxY-this.minY,s=this.height-e;return this.minY+s/this.height*t}getValue(e){const t=findSegmentValue(this.segments.value,e),s=findSegmentValue(this.segments.tolerance.max,e),n=findSegmentValue(this.segments.tolerance.min,e);return{value:"number"==typeof t||"string"==typeof t?t:null,tolerance:{min:"number"==typeof s?s:null,max:"number"==typeof n?n:null}}}getDimensions(){return{x:{min:this.minX,max:this.maxX},y:{min:this.minY,max:this.maxY},width:this.width,height:this.height}}addValue(e,t,s=null){this.values.push({x:e,y:t,property:s}),this.values.sort(((e,t)=>e.x-t.x)),this.externalDraw||this.draw()}addValues(e){e.forEach((([e,t,s=null])=>{this.values.push({x:e,y:t,property:s})})),this.values.sort(((e,t)=>e.x-t.x)),this.externalDraw||this.draw()}clearValues(){this.values=[]}remove(){this.parent&&(this.clearValues(),this.observer.disconnect(),this.parent.removeChild(this.canvas),this.parent=null,this.watchers=[])}watch(e){return this.watchers.push(e),{unwatch:()=>{const t=this.watchers.indexOf(e);-1!==t&&this.watchers.splice(t,1)}}}}}(),function(){"use strict";const e=shmi.pkg("visuals.controls.iqtrend.markerlayer");function updateSize(e,t){e.width=t.width-2,e.scale=e.width/(e.max-e.min)}function getMarkerTemplate(e,t){return e.trendWidget.vars.markerTemplates[t]||null}function request(e,t,s){return shmi.visuals.session.ConnectSession.requestPromise(e,t,s)}function lookupMarkerElement(e,t,s){return e[t]=shmi.getUiElement(s,e.element),!!e[t]||(console.warn(`Widget template is missing '${s}' element required to activate comment markers.`),!1)}function onMarkerClose(e,t){t.element.classList.remove("open"),e.parent.classList.remove("active"),t.listenersContent.forEach((e=>{e.disable()})),t.listenersContent=[],e.currentMarker=null}function updateMarkerSize(e,t){t.info.classList.remove("reversed"),t.info.style.removeProperty("--trend-marker-info-width");const s=getComputedStyle(e.trendWidget.element),n=parseInt(s.getPropertyValue("--trend-marker-info-width").replace("px","")),a=e.trendWidget.vars.elements.graphs.getBoundingClientRect(),l=t.element.getBoundingClientRect(),o=t.info.getBoundingClientRect(),r=Math.abs(l.x-o.x);if(l.x<=a.x+a.width/2){if(l.x-r+n>a.x+a.width){const e=l.x-r+n-(a.x+a.width);t.info.style.setProperty("--trend-marker-info-width",n-e+"px")}}else if(t.info.classList.add("reversed"),l.x+r-n<a.x){const e=a.x-(l.x+r-n);t.info.style.setProperty("--trend-marker-info-width",n-e+"px")}}async function setMarkerContent(e,t){const{formatDateTime:s}=shmi.requires("visuals.tools.date"),n=t.marker,{currentUser:a}=shmi.requires("visuals.session.UserManager"),l=shmi.localize(e.trendWidget.config.commentTimestampFormat||"$DD.$MM.$YYYY, $HH:$mm:$ss");try{const e=await request("thread.get",{thread_id:n.id});let o=!1;try{await request("thread.modify",{thread_id:-1,title:null,message:""})}catch(e){"shmi:connect:api:generic"===e.category&&4===e.errc||(o=!0)}if(e){t.title.textContent=e.message.title,t.title.title=e.message.title,t.text.textContent=e.message.message;const n=s(("number"==typeof e.message.edited_timestamp?e.message.edited_timestamp:e.message.timestamp)/1e3,l);t.time.textContent=n,t.time.title=n,o&&a.id===e.message.user_id&&t.element.classList.add("editable");try{const s=await request("user.info",e.message.user_id);s.first_name&&s.first_name.length&&s.last_name&&s.last_name.length?t.user.textContent=`${s.first_name} ${s.last_name}`:t.user.textContent=s.username}catch(s){console.error(`Error retrieving user information for user-id '${e.message.user_id}':`,s),t.user.textContent=e.message.user_id}}}catch(e){console.error(`Error retrieving data for thread-ID '${n.id}':`,e)}}function createMarker(e,t){const s=e.markerElements[t.type][t.id]={marker:t,element:getMarkerTemplate(e,t.type).cloneNode(!0),icon:null,listenersIcon:[],listenersContent:[]};if([lookupMarkerElement(s,"icon","marker-icon"),lookupMarkerElement(s,"title","marker-title"),lookupMarkerElement(s,"text","marker-text"),lookupMarkerElement(s,"time","marker-time"),lookupMarkerElement(s,"user","marker-user"),lookupMarkerElement(s,"info","marker-info"),lookupMarkerElement(s,"close","marker-close"),lookupMarkerElement(s,"content","marker-content"),lookupMarkerElement(s,"edit","marker-edit")].every((e=>e))){const{MouseListener:t,TouchListener:n}=shmi.requires("visuals.io"),a={onPress:()=>{},onRelease:()=>{},onClick:async()=>{e.trendWidget.isLocked()||e.currentMarker&&e.currentMarker.ref===s||await async function onMarkerOpen(e,t){const s=t.marker;e.trendWidget.isLive()&&e.trendWidget.setLive(!1),e.currentMarker&&onMarkerClose(e,e.currentMarker.ref),e.currentMarker={data:s,ref:t},updateMarkerSize(e,t),await setMarkerContent(e,t),t.element.classList.add("open"),e.parent.classList.add("active");const{MouseListener:n,TouchListener:a}=shmi.requires("visuals.io"),l={onPress:(e,t,s)=>{s.stopPropagation()},onRelease:(e,t,s)=>{s.stopPropagation()},onClick:(s,n,a)=>{a.stopPropagation(),onMarkerClose(e,t)}},o=new n(t.close,l),r=new a(t.close,l),c=new n(e.parent,l),u=new a(e.parent,l),m={onPress:(e,t,s)=>{s.stopPropagation()},onRelease:(e,t,s)=>{s.stopPropagation()},onClick:async(n,a,l)=>{if(l.stopPropagation(),!e.trendWidget.isLocked()){const n=shmi.requires("visuals.tools.threads"),a=await n.edit(s.id,{dialogTitle:"${iqtrend_edit_thread}",titleLabel:"${iqtrend_threads_title}",messageLabel:"${iqtrend_threads_message}",deleteLabel:"${iqtrend_threads_delete_btn}",deleteConfirmation:"${iqtrend_threads_delete_confirmation}",applyLabel:"${iqtrend_threads_edit_btn}",enterMessageNotification:"${iqtrend_threads_enter_message_notification}"});null!==a&&(-1===a&&onMarkerClose(e,t),e.trendWidget.vars.datasource.source.reloadComments())}}},h=new n(t.edit,m),d=new a(t.edit,m),f={onPress:(e,t,s)=>{s.stopPropagation()},onRelease:(e,t,s)=>{s.stopPropagation()},onClick:(e,t,s)=>{s.stopPropagation()},onWheel:(e,t)=>{t.stopPropagation()}},v=new n(t.content,f),g=new a(t.content,f);t.listenersContent.push(o,r,c,u,h,d,v,g),t.listenersContent.forEach((e=>{e.enable()}))}(e,s)}},l=new t(s.icon,a),o=new n(s.icon,a);s.listenersIcon.push(l,o),s.listenersIcon.forEach((e=>{e.enable()}))}}e.MarkerLayer=class MarkerLayer{constructor(e,t){this.parent=e,this.trendWidget=t,this.width=1,this.scale=1,this.min=0,this.max=6e4,this.markers=[],this.markerElements={alarm:{},comment:{}},this.currentMarker=null,updateSize(this,this.parent.getBoundingClientRect())}draw(){const e=[];this.markers.forEach((t=>{if(this.markerElements[t.type]){this.markerElements[t.type][t.id]?async function updateMarker(e,t){const s=e.markerElements[t.type][t.id];s&&(s.marker=t,e.currentMarker&&e.currentMarker.ref===s&&(e.currentMarker.data=t),await setMarkerContent(e,s))}(this,t):createMarker(this,t);const s=this.markerElements[t.type][t.id],n=function getXCoordinate(e,t){return null===t?null:(t-e.min)*e.scale+1}(this,t.timestamp);t.timestamp<this.min||t.timestamp>this.max?s.element.style.display="none":s.element.style.display="",s.element.style.left=`${n}px`,s.element.parentNode||this.parent.appendChild(s.element),e.push(s.marker)}})),Object.keys(this.markerElements).forEach((t=>{Object.keys(this.markerElements[t]).forEach((s=>{const n=this.markerElements[t][s];e.includes(n.marker)||(this.currentMarker&&n===this.currentMarker.ref&&onMarkerClose(this,n),n.listenersIcon.forEach((e=>{e.disable()})),n.listenersIcon=[],this.parent.removeChild(n.element),delete this.markerElements[t][s])}))}))}addMarkers(e){e.forEach((e=>{this.markers.push(e)})),this.markers.sort(((e,t)=>e.timestamp-t.timestamp)),this.draw()}clearMarkers(e=null){this.markers="string"==typeof e?this.markers.filter((t=>t.type!==e)):[]}setOptions(e){e.x&&("number"==typeof e.x.min&&(this.min=e.x.min),"number"==typeof e.x.max&&(this.max=e.x.max),this.scale=this.width/(this.max-this.min),this.draw())}updateSize(){updateSize(this,this.parent.getBoundingClientRect()),this.draw(),this.currentMarker&&updateMarkerSize(this,this.currentMarker.ref)}}}(),function(){"use strict";const e=shmi.pkg("visuals.controls.iqtrend.scale"),t=!1;function updateSize(e){e.canvas.width=e.width+2,e.canvas.height=e.height+2;const t=getComputedStyle(e.parent);e.strokeStyle=t.getPropertyValue("--scale-color")}const s=[1,.5,.25,.2];function toDigits(e,t){return parseFloat(e.toFixed(t))}function getRangeInfo(e,t,n){const a=function getSimpleStep(e,t,n){const a=t-e;let l=Math.ceil(Math.log10(a)),o=1,r=0;for(;r<n;){for(let e=0;e<s.length;e++){let t=s[e]*10**l;if(r=a/t,!(r<=n))break;o=t}l-=1}return o}(e,t,n),l=getDigits(a),o=Math.floor(e/a)*a,r=o+Math.ceil((t-o)/a)*a;return{step:toDigits(a,l),start:toDigits(o,l),range:toDigits(r-o,l)}}function getDigits(e){e=parseFloat(e.toFixed(14));const t=String(e);let s=t.indexOf(".");return s=-1!==s?t.length-s-1:0,s}function addLineMarker(e,t){const s=document.createElement("div");s.classList.add("line-marker"),s.style.setProperty("--line-color",function getValueStroke(e,t){let s=e.dataset;return t!==e.valueName&&(s=e.dataset.trendWidget.vars.datasets.find((e=>e.name===t))),s?s.graph.style.value.strokeStyle:null}(e,t)),e.lineMarkers.push(s)}function updateUnitInfo(e){const t=e.dataset.trendWidget.vars.datasource.source.getValueSettings(),s=shmi.requires("visuals.tools.unitClasses");let n="";if((0===e.additionalValues.length||t[e.valueName]&&e.additionalValues.every((s=>t[s]&&t[e.valueName].unit===t[s].unit)))&&t[e.valueName]){if(function isUnitClass(e){return String(parseInt(e))===String(e)}(t[e.valueName].unit)){const a=s.getSelectedAdapter(t[e.valueName].unit);n=a?a.unitText:t[e.valueName].unit}else n=null===t[e.valueName].unit?"":t[e.valueName].unit;e.unit=t[e.valueName].unit}e.unitInfo.textContent=shmi.localize(n)}function updateScaleInfo(e){e.lineMarkers.forEach((e=>{e.parentNode.removeChild(e)})),e.lineMarkers=[],addLineMarker(e,e.valueName),e.additionalValues.forEach((t=>{addLineMarker(e,t)})),e.lineMarkers.forEach((t=>{e.markerContainer.appendChild(t)})),updateUnitInfo(e);const t=e.parent.getBoundingClientRect(),s=e.scaleInfo.getBoundingClientRect();e.scaleInfoOffset=s.top-t.top+e.scaleInfo.offsetHeight}function drawScaleMarker(e,t,s,n){const a=function getCoordinate(e,t,s){return e.height-(s-e.min)*t+1}(e,t,s),l=e.lineWidth/2;return e.mirrored?(e.context.moveTo(1,a-l),e.context.lineTo(n+1,a-l)):(e.context.moveTo(e.width+1,a-l),e.context.lineTo(e.width-n+1,a-l)),a}function drawSmallMarkers(e,t,s,n,a,l){if(n>25){if(0===l){const n=a-s.step/2;n>=e.min&&drawScaleMarker(e,t,n,e.width-2)}drawScaleMarker(e,t,a+s.step/2,e.width-2)}}e.Scale=class Scale{constructor(e,{min:t=0,max:s=100,numSteps:n=21,mirrored:a=!1,location:l="left",align:o="left",lineWidth:r=1,hidden:c=!1,valueName:u="value",additionalValues:m=[],autoWidth:h=!0},d){this.dataset=d,this.canvas=document.createElement("canvas"),this.wrapper=document.createElement("div"),this.wrapper.classList.add("scale-wrapper"),this.parent=e,this.canvas.classList.add("scale-canvas"),this.scaleInfo=document.createElement("div"),this.scaleInfo.classList.add("scale-info"),this.markerContainer=document.createElement("div"),this.markerContainer.classList.add("line-markers"),this.lineMarkers=[],this.valueName=u,this.additionalValues=m,this.unitInfo=document.createElement("div"),this.unitInfo.classList.add("unit-info"),this.scaleInfo.appendChild(this.markerContainer),this.scaleInfo.appendChild(this.unitInfo),this.wrapper.appendChild(this.scaleInfo),this.unit=null,this.mirrored=a,this.location=l,"left"===l&&a?this.wrapper.classList.add("mirrored"):"right"!==l||a||this.wrapper.classList.add("mirrored"),this.lineWidth=r,this.hidden=c,this.hidden&&this.wrapper.classList.add("hidden"),this.markers=[];for(let e=0;e<n+1;e++){const e=document.createElement("div");e.classList.add("scale-label"),e.style.display="none",this.wrapper.appendChild(e),this.markers.push(e)}this.wrapper.appendChild(this.canvas),this.parent.appendChild(this.wrapper);const f=this.parent.getBoundingClientRect();this.width=this.canvas.offsetWidth-2,this.height=f.height-2;const{getFontStyle:v}=shmi.requires("visuals.controls.iqtrend.common");this.fontStyle=v(this.markers[0]);const{getTextDimensions:g}=shmi.requires("visuals.controls.iqtrend.common"),p=g("123",this.fontStyle);this.markerHeight=p.textHeight,this.min=t,this.max=s,this.numSteps=n,this.autoWidth=h,this.baseWidth=44;try{this.baseWidth=parseInt(getComputedStyle(this.parent).getPropertyValue("--scale-width"))}catch(e){console.error("Error computing base label width (possibly required definition of --scale-width missing):",e)}this.currentWidth=this.baseWidth,updateScaleInfo(this),updateSize(this),this.context=this.canvas.getContext("2d"),this.observer=new ResizeObserver((e=>{const t=e[0];this.width=this.canvas.offsetWidth-2,this.height=t.contentRect.height-2,updateSize(this),updateScaleInfo(this),this.draw()})),this.observer.observe(this.parent),this.autoWidth&&(this.labelObserver=new ResizeObserver((()=>{let e=this.baseWidth;this.markers.forEach((t=>{const s=t.getBoundingClientRect().width+this.width+4;if(s>e){const t=this.baseWidth+10*Math.ceil((s-this.baseWidth)/10);e<t&&(e=t)}})),e>this.baseWidth&&this.currentWidth!==e?(this.currentWidth=e,this.wrapper.style.setProperty("--scale-width",`${this.currentWidth}px`)):e<=this.baseWidth&&(this.wrapper.style.removeProperty("--scale-width"),this.currentWidth=this.baseWidth)})),this.markers.forEach((e=>{this.labelObserver.observe(e)}))),this.draw()}setOptions(e){let t=!1,s=!1;null!==this.parent&&(e.y&&("number"==typeof e.y.min&&(this.min=e.y.min),"number"==typeof e.y.max&&(this.max=e.y.max),t=!0),"string"==typeof e.location&&e.location!==this.location&&("left"===e.location?(this.location="left",this.mirrored=!this.mirrored,this.parent=this.dataset.trendWidget.vars.elements.scalesLeft,this.parent.appendChild(this.wrapper)):"right"===e.location&&(this.location="right",this.mirrored=!this.mirrored,this.parent=this.dataset.trendWidget.vars.elements.scalesRight,this.parent.appendChild(this.wrapper)),"left"===this.location&&this.mirrored?this.wrapper.classList.add("mirrored"):"right"!==this.location||this.mirrored?this.wrapper.classList.remove("mirrored"):this.wrapper.classList.add("mirrored"),t=!0),"boolean"==typeof e.hidden&&(this.hidden&&!e.hidden&&(s=!0),this.hidden=e.hidden,this.hidden?this.wrapper.classList.add("hidden"):(this.wrapper.classList.remove("hidden"),this.width=this.canvas.offsetWidth,updateSize(this)),t=!0),"string"==typeof e.addValue&&(this.additionalValues.includes(e.addValue)||e.addValue===this.valueName||(this.additionalValues.push(e.addValue),s=!0)),"string"==typeof e.removeValue&&this.additionalValues.includes(e.removeValue)&&(this.additionalValues.splice(this.additionalValues.indexOf(e.removeValue),1),s=!0,t=!0),e.style&&(s=!0),void 0!==e.unit&&this.unit!==e.unit&&(s=!0),s&&updateScaleInfo(this),t&&this.draw())}draw(){if(!this.parent)return;this.context.clearRect(0,0,this.width+2,this.height+2),this.context.lineWidth=this.lineWidth,this.context.strokeStyle=this.strokeStyle;const e=this.lineWidth/2;this.context.beginPath(),this.mirrored?(this.context.moveTo(1+e,1),this.context.lineTo(1+e,this.height+1)):(this.context.moveTo(this.width+1-e,1),this.context.lineTo(this.width+1-e,this.height+1));const s=Math.max(1,Math.min(this.numSteps,Math.floor(this.height/30))),n=getRangeInfo(this.min,this.max,s),a=getDigits(n.step),l=toDigits(n.range/n.step,a)+1,o=this.height/(this.max-this.min),r=n.step*o;for(let e=0;e<l&&e<this.markers.length;e++){const t=toDigits(n.start+e*n.step,a);if(this.min<=t&&t<=this.max){const s=drawScaleMarker(this,o,t,this.width);drawSmallMarkers(this,o,n,r,t,e),s>this.scaleInfoOffset+this.markerHeight?(this.markers[e].textContent=toDigits(t,a),this.markers[e].style.top=s-1+"px",this.markers[e].style.display="block"):this.markers[e].style.display="none"}else 0===e&&drawSmallMarkers(this,o,n,r,t,e),this.markers[e].style.display="none"}this.markers.slice(l,this.markers.length).forEach((e=>{e.style.display="none"})),this.context.stroke(),function log(){t&&console.log.apply(console,arguments)}(`Scale Markers: ${[].join(", ")}`)}remove(){this.parent&&(this.observer.disconnect(),this.labelObserver&&this.labelObserver.disconnect(),this.parent.removeChild(this.wrapper),this.parent=null)}}}(),function(){"use strict";const e=shmi.pkg("visuals.controls.iqtrend.scalegroup");function updateLimits(e){const{min:t,max:s}=e.getCurrentLimits();Object.keys(e.values).forEach((n=>{e.values[n].dataset.graph.setOptions({y:{min:t,max:s}}),e.values[n].dataset.scale.setOptions({y:{min:t,max:s}})}))}function setLimitOption(e,t,s){e.limits[t]||(e.limits[t]={min:null,max:null}),"number"==typeof s.y.min&&(e.limits[t].min=s.y.min),"number"==typeof s.y.max&&(e.limits[t].max=s.y.max)}e.ScaleGroup=class ScaleGroup{constructor(e,t,s=null){this.groupId=e,this.trendWidget=t,this.values={},s&&(this.values[s.name]={name:s.name,dataset:s}),this.master=s?this.values[s.name]:null,this.limits={}}addValue(e,t){this.values[e]||(this.values[e]={name:e,dataset:t},this.master||(this.master=this.values[e]),this.master.dataset.scale.setOptions({addValue:e}),t!==this.master.dataset&&t.scale&&t.scale.setOptions({hidden:!0}))}removeValue(e){if(this.values[e]){const t=this.values[e]===this.master;if(delete this.values[e],delete this.limits[e],t){this.master.dataset.scale.additionalValues.slice().forEach((e=>{this.master.dataset.scale.setOptions({removeValue:e})}));const e=this.getValueNames()[0];e?(this.master=this.values[e],Object.keys(this.values).forEach((e=>{e!==this.master.name&&this.master.dataset.scale.setOptions({addValue:e})})),this.master.dataset.scale.setOptions({hidden:!1})):this.master=null}else this.master&&this.master.dataset.scale.setOptions({removeValue:e});updateLimits(this)}}getValueLimits(){const e=this.trendWidget.vars.datasource.source.getValueSettings();let t=null,s=null;return this.getValueNames().forEach((n=>{const a=e[n];a&&"number"==typeof a.min&&(null===t||t>a.min)&&(t=a.min),a&&"number"==typeof a.max&&(null===s||s<a.max)&&(s=a.max)})),{min:t,max:s}}getCurrentLimits(){let e=null,t=null;return Object.keys(this.limits).forEach((s=>{(null===e||this.limits[s].min<e)&&(e=this.limits[s].min),(null===t||this.limits[s].max>t)&&(t=this.limits[s].max)})),{min:e,max:t}}getValueNames(){return Object.keys(this.values)}setOptions(e,t){e.y&&(null===t?this.getValueNames().forEach((t=>{setLimitOption(this,t,e)})):setLimitOption(this,t,e),updateLimits(this))}}}(),function(){"use strict";const e=shmi.pkg("visuals.controls.iqtrend.taskqueue");const t=shmi.requires("visuals.controls.iqtrend.common").taskStates;function cleanupTasks(e){e._tasks=e._tasks.filter((e=>e.state===t.CREATED||e.state===t.RUNNING))}function checkTasks(e){cleanupTasks(e),notifyWatchers(e);const s=e._tasks.find((e=>e.state===t.CREATED));return s?s.run().then((t=>checkTasks(e))):Promise.resolve}function notifyWatchers(e){e._watchers.forEach((t=>{t({source:e,loading:e.loading})}))}e.TaskQueue=class TaskQueue{constructor(){this._tasks=[],this._watchers=[]}get loading(){return!!this._tasks.length}getTasks(){return this._tasks}queueTask(e){return cleanupTasks(this),this._tasks.push(e),1===this._tasks.length?(notifyWatchers(this),this._tasks[0].run().then((()=>checkTasks(this)))):Promise.resolve()}watch(e){return this._watchers.push(e),{unwatch:()=>{const t=this._watchers.indexOf(e);-1!==t&&this._watchers.splice(t,1)}}}}}(),function(){"use strict";const e=shmi.pkg("visuals.controls.iqtrend.timeline");function updateSize(e){e.canvas.width=e.width+2,e.canvas.height=e.height+2;const t=getComputedStyle(e.parent);e.strokeStyle=t.getPropertyValue("--timeline-color")}const t=1e3,s=6e4,n=36e5,a=864e5,l=6048e5,o=2592e6,r=31536e6,c=[{unit:r,format:"$YYYY"},{unit:o,format:"$DD.$MM"},{unit:l,format:"$DD.$MM"},{unit:a,format:"$DD.$MM"},{unit:n,format:"$HH:$mm"},{unit:s,format:"$HH:$mm"},{unit:t,format:"$mm:$ss"},{unit:1,format:"$ss.$SSS"}],u={time:"$HH:$mm:$ss",date:"$DD.$MM.$YYYY"};function getMarkerText(e,t,s){const{formatDateTime:n}=shmi.requires("visuals.tools.date"),a=function getMarkerFormat(e,t){return t.find(((s,n)=>e%s.unit==0||n===t.length-1))}(t.step,e.markerFormats);return n(s/1e3,a?a.format:void 0)}const m=[1,5,10,25,50,100,250,500,t,2*t,5*t,10*t,15*t,30*t,s,2*s,5*s,10*s,15*s,20*s,30*s,n,2*n,3*n,6*n,12*n,a,2*a,l,2*l,o,2*o,3*o,6*o,r];function getRangeInfo(e,t,s){const n=function getTimeStep(e,t,s){const n=t-e;let a=1,l=0;const o=m.slice().reverse();for(let e=0;e<o.length;e++){const t=o[e];if(l=n/t,!(l<=s))break;a=t}return a}(e,t,s),a=Math.floor(e/n)*n;return{step:n,start:a,range:a+Math.ceil((t-a)/n)*n-a}}function drawScaleMarker(e,t,s,n){const a=function getCoordinate(e,t,s){return(s-e.min)*t+1}(e,t,s);return e.mirrored?(e.context.moveTo(a,e.height+1),e.context.lineTo(a,n+1)):(e.context.moveTo(a,1+n),e.context.lineTo(a,1)),a}function drawSmallMarkers(e,t,s,n,a,l){if(n>100){const n=s.step/4;if(0===l)for(let s=0;s<3;s++){const l=a-(s+1)*n;l>=e.min&&drawScaleMarker(e,t,l,e.height-2)}for(let s=0;s<3;s++){drawScaleMarker(e,t,a+(s+1)*n,e.height-2)}}else if(n>75){if(0===l){const n=a-s.step/2;n>=e.min&&drawScaleMarker(e,t,n,e.height-2)}drawScaleMarker(e,t,a+s.step/2,e.height-2)}}function updateStartMarker(e){const{formatDateTime:t}=shmi.requires("visuals.tools.date");e.startDate.textContent=t(e.min/1e3,e.startMarkerFormat.date),e.startTime.textContent=t(e.min/1e3,e.startMarkerFormat.time)}e.Timeline=class Timeline{constructor(e,{min:t=0,max:s=100,numSteps:n=21,mirrored:a=!1,markerFormats:l,startMarkerFormat:o},r){this.canvas=document.createElement("canvas"),this.parent=e,this.canvas.classList.add("timeline-canvas"),this.updateCallback="function"==typeof r?r:()=>{},this.mirrored=a,this.markerFormats=Array.isArray(l)?l:c,this.markerFormats.forEach((e=>{e.format=shmi.localize(e.format)})),this.startMarkerFormat=o&&"string"==typeof o.time&&"string"==typeof o.date?o:u,this.startMarkerFormat.date=shmi.localize(this.startMarkerFormat.date),this.startMarkerFormat.time=shmi.localize(this.startMarkerFormat.time);let m="";this.markerFormats.forEach((e=>{e.format.length>m.length&&(m=e.format)})),this.maxMarkerFormat=m,this.markers=[];for(let e=0;e<n+1;e++){const e=document.createElement("div");e.classList.add("timeline-label"),e.style.display="none",this.parent.appendChild(e),this.markers.push(e)}this.startMarker=document.createElement("div"),this.startMarker.classList.add("timeline-start"),this.startDate=document.createElement("div"),this.startDate.classList.add("start-date"),this.startTime=document.createElement("div"),this.startTime.classList.add("start-time"),this.startMarker.appendChild(this.startDate),this.startMarker.appendChild(this.startTime),this.parent.appendChild(this.canvas),this.mirrored?this.parent.classList.add("mirrored"):this.parent.classList.remove("mirrored"),this.parent.appendChild(this.startMarker);const{getFontStyle:h}=shmi.requires("visuals.controls.iqtrend.common");this.fontStyle=h(this.markers[0]);const{getTextDimensions:d}=shmi.requires("visuals.controls.iqtrend.common");this.markerWidth=20*Math.ceil((Math.max(65,d(this.maxMarkerFormat,this.fontStyle).width)+10)/20);{const e=this.parent.getBoundingClientRect();this.width=e.width-2,this.height=this.canvas.offsetHeight-2;const t=this.startMarker.getBoundingClientRect();this.startMarkerOffset=t.left-e.left+t.width}this.min=t,this.max=s,this.numSteps=n,updateSize(this),updateStartMarker(this),this.context=this.canvas.getContext("2d"),this.observer=new ResizeObserver((e=>{const t=e[0];this.width=t.contentRect.width-2,this.height=this.canvas.offsetHeight-2;const s=this.parent.getBoundingClientRect(),n=this.startMarker.getBoundingClientRect();this.startMarkerOffset=n.left-s.left+n.width,updateSize(this),this.draw()})),this.observer.observe(this.parent),this.draw()}getDimensions(){return{min:this.min,max:this.max}}getScale(){return this.width/(this.max-this.min)}setOptions(e){e.x&&("number"==typeof e.x.min&&(this.min=e.x.min),"number"==typeof e.x.max&&(this.max=e.x.max),this.updateCallback({min:this.min,max:this.max}),this.draw())}draw(){if(!this.parent)return;this.context.clearRect(0,0,this.width+2,this.height+2),this.context.lineWidth=1,this.context.strokeStyle=this.strokeStyle,this.context.beginPath(),this.mirrored?(this.context.moveTo(1,this.height+.5),this.context.lineTo(this.width+1,this.height+.5)):(this.context.moveTo(1,1.5),this.context.lineTo(this.width+1,1.5));const e=Math.max(1,Math.min(this.numSteps,Math.floor(this.width/this.markerWidth))),t=getRangeInfo(this.min,this.max,e),s=t.range/t.step+1,n=this.getScale(),a=t.step*n;for(let e=0;e<s&&e<this.markers.length;e++){const s=t.start+e*t.step;if(s>=this.min&&s<=this.max){const l=drawScaleMarker(this,n,s,this.height);drawSmallMarkers(this,n,t,a,s,e),l>this.startMarkerOffset+this.markerWidth/2?(this.markers[e].textContent=getMarkerText(this,t,s),this.markers[e].style.left=l-this.markerWidth/2+"px",this.markers[e].style.width=`${this.markerWidth}px`,this.markers[e].style.display="block"):this.markers[e].style.display="none"}else 0===e&&drawSmallMarkers(this,n,t,a,s,e),this.markers[e].style.display="none"}this.markers.slice(s,this.markers.length).forEach((e=>{e.style.display="none"})),this.context.stroke(),updateStartMarker(this)}remove(){this.parent&&(this.observer.disconnect(),this.parent.removeChild(this.canvas),this.markers.forEach((e=>{this.parent.removeChild(e)})),this.parent.removeChild(this.startMarker),this.parent=null)}}}(),function(){"use strict";const e=shmi.pkg("visuals.controls.iqtrend.trendtask");const t=shmi.requires("visuals.controls.iqtrend.common").taskStates;e.TrendTask=class TrendTask{constructor(e,s,n){this._type=e,this._parameters=s,this._state=t.CREATED,this._taskFunction=n,this._result=null,this._error=null}get state(){return this._state}set state(e){this._state=e}get type(){return this._type}get parameters(){return this._parameters}get result(){return this._result}get error(){return this._error}async run(){if(this._state!==t.CREATED)throw new Error("Tried to run task that is not in initial 'CREATED' state.");this._state=t.RUNNING;try{this._result=await this._taskFunction(this._parameters,this),this._state=t.DONE}catch(e){this._error=e,console.error("Error executing task:",e,this.type,this.parameters),this._state=t.ERROR}return this._result}}}(),function(){"use strict";const e=shmi.pkg("visuals.controls.iqtrend.xaxis");let t=75;function updateSize(e){e.canvas.width=e.width+2,e.canvas.height=e.height+2;const t=getComputedStyle(e.parent);e.strokeStyle=t.getPropertyValue("--timeline-color")}const s=[1,.5,.25,.2];function toDigits(e,t){return parseFloat(e.toFixed(t))}function getRangeInfo(e,t,n){const a=function getSimpleStep(e,t,n){const a=t-e;let l=Math.ceil(Math.log10(a)),o=1,r=0;for(;r<n;){for(let e=0;e<s.length;e++){const t=s[e]*10**l;if(r=a/t,!(r<=n))break;o=t}l-=1}return o}(e,t,n),l=getDigits(a),o=Math.floor(e/a)*a,r=o+Math.ceil((t-o)/a)*a;return{step:toDigits(a,l),start:toDigits(o,l),range:toDigits(r-o,l)}}function getDigits(e){const t=String(e);let s=t.indexOf(".");return s=-1!==s?t.length-s-1:0,s}function drawScaleMarker(e,t,s,n){const a=function getCoordinate(e,t,s){return(s-e.min)*t+1}(e,t,s);return e.mirrored?(e.context.moveTo(a,e.height+1),e.context.lineTo(a,n+1)):(e.context.moveTo(a,1+n),e.context.lineTo(a,1)),a}function drawSmallMarkers(e,t,s,n,a,l){if(n>100){const n=s.step/4;if(0===l)for(let s=0;s<3;s++){const l=a-(s+1)*n;l>=e.min&&drawScaleMarker(e,t,l,e.height-2)}for(let s=0;s<3;s++){drawScaleMarker(e,t,a+(s+1)*n,e.height-2)}}else if(n>75){if(0===l){const n=a-s.step/2;n>=e.min&&drawScaleMarker(e,t,n,e.height-2)}drawScaleMarker(e,t,a+s.step/2,e.height-2)}}e.XAxis=class XAxis{constructor(e,{min:t=0,max:s=100,numSteps:n=21,mirrored:a=!1},l){this.canvas=document.createElement("canvas"),this.wrapper=document.createElement("div"),this.wrapper.classList.add("xaxis-wrapper"),this.parent=e,this.canvas.classList.add("xaxis-canvas"),this.updateCallback="function"==typeof l?l:()=>{},this.mirrored=a,this.mirrored&&this.wrapper.classList.add("mirrored"),this.markers=[];for(let e=0;e<n+1;e++){const e=document.createElement("div");e.classList.add("xaxis-label"),e.style.display="none",this.wrapper.appendChild(e),this.markers.push(e)}this.wrapper.appendChild(this.canvas),this.parent.appendChild(this.wrapper);const{getFontStyle:o}=shmi.requires("visuals.controls.iqtrend.common");this.fontStyle=o(this.markers[0]);const r=this.parent.getBoundingClientRect();this.width=r.width-2,this.height=this.canvas.offsetHeight-2,this.min=t,this.max=s,this.numSteps=n,updateSize(this),this.context=this.canvas.getContext("2d"),this.observer=new ResizeObserver((e=>{const t=e[0];this.width=t.contentRect.width-2,this.height=this.canvas.offsetHeight-2,updateSize(this),this.draw()})),this.observer.observe(this.parent),this.draw()}setOptions(e){e.x&&("number"==typeof e.x.min&&(this.min=e.x.min),"number"==typeof e.x.max&&(this.max=e.x.max),this.updateCallback({min:this.min,max:this.max}),this.draw())}draw(){if(!this.parent)return;this.context.clearRect(0,0,this.width+2,this.height+2),this.context.lineWidth=1,this.context.strokeStyle=this.strokeStyle,this.context.beginPath(),this.mirrored?(this.context.moveTo(1,this.height+.5),this.context.lineTo(this.width+1,this.height+.5)):(this.context.moveTo(1,1.5),this.context.lineTo(this.width+1,1.5));const{getTextDimensions:e}=shmi.requires("visuals.controls.iqtrend.common");t=Math.max(65,e(this.min,this.fontStyle).width,e(this.max,this.fontStyle).width)+10;const s=Math.max(1,Math.min(this.numSteps,Math.floor(this.width/t))),n=getRangeInfo(this.min,this.max,s),a=getDigits(n.step),l=toDigits(n.range/n.step,a)+1,o=this.width/(this.max-this.min),r=n.step*o;for(let e=0;e<l&&e<this.markers.length;e++){const s=toDigits(n.start+e*n.step,a);if(s>=this.min&&s<=this.max){const l=drawScaleMarker(this,o,s,this.height);drawSmallMarkers(this,o,n,r,s,e),this.markers[e].textContent=toDigits(s,a),this.markers[e].style.left=l-t/2+"px",this.markers[e].style.width=`${t}px`,this.markers[e].style.display="block"}else 0===e&&drawSmallMarkers(this,o,n,r,s,e),this.markers[e].style.display="none"}this.markers.slice(l,this.markers.length).forEach((e=>{e.style.display="none"})),this.context.stroke()}getDimensions(){return{min:this.min,max:this.max}}getScale(){return this.width/(this.max-this.min)}remove(){this.parent&&(this.observer.disconnect(),this.parent.removeChild(this.wrapper),this.parent=null)}}}(),function(){"use strict";const e="iq-user-info",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),s=t.fLog;t.log;function getUser(e){const{username:t}=e.vars.user;e.imports.request("user.list",{},(function(n,a){if(n&&Array.isArray(n.users)){const a=n.users.find((({username:e})=>e===t));if(!a)return void s("User not found in remote user list");e.vars.user.name=a.first_name,e.vars.user.surname=a.last_name,function displayUser(e){const t=shmi.getUiElement("user-info-name",e.element);t?(e.config["show-name"]||(e.config["show-name"]=!1),!1===e.config["show-name"]?t.textContent=e.vars.user.username:!0===e.config["show-name"]&&(e.vars.user.name&&e.vars.user.surname?t.textContent=e.vars.user.name+" "+e.vars.user.surname:e.vars.user.name?e.vars.user.surname?t.textContent="First Name and/or Last Name not set!":t.textContent=e.vars.user.name:t.textContent=e.vars.user.surname)):s('DOM-Element "user-info-name" not found!')}(e)}else s("[UserManager] could not retrieve userlist:",a.category,a.errc,a.message),s("User name and surname cannot be displayed!")}))}const n={className:"iqUserInfo",uiType:e,isContainer:!1,config:{"class-name":"iq-user-info",name:null,template:"default/iq-user-info.variant-01",label:"[Label]","show-name":!1,"show-group":!1,action:null},configSchema:null,vars:{user:{userGroups:null,name:null,surname:null,username:null},action:null,listeners:[]},imports:{request:"visuals.tools.connect.request"},events:["click"],prototypeExtensions:{onInit:function(){const e=this;e.config.action&&(e.vars.action=new shmi.visuals.core.UiAction(e.config.action,e)),Array.isArray(e.config.action)&&e.config.action.length>0?shmi.addClass(e.element,"clickable"):shmi.removeClass(e.element,"clickable");const t={onClick:function(t,s,n){e.fire("click",{x:t,y:s,event:n}),e.vars.action&&e.vars.action.execute()}};e.vars.listeners.push(new shmi.visuals.io.MouseListener(e.element,t)),e.vars.listeners.push(new shmi.visuals.io.TouchListener(e.element,t))},onEnable:function(){const e=this;e.vars.user.userGroups=shmi.visuals.session.UserManager.currentUser.groupList,e.vars.user.username=shmi.visuals.session.UserManager.currentUser.name,getUser(e),!0===e.config["show-group"]&&function setUserGroup(e){let t=shmi.getUiElement("user-info-group",e.element),n=null,{userGroups:a}=e.vars.user;t?(a=a.filter((e=>0!==e.indexOf("@"))),n=a.length>0?a[0]:"Default",t.textContent=n):s('Dom-Element "user-info-group" not found!')}(e),e.vars.listeners.forEach((function(e){e.enable()}))},onDisable:function(){this.vars.listeners.forEach((function(e){e.disable()}))},onLock:function(){this.vars.listeners.forEach((function(e){e.disable()})),shmi.addClass(this.element,"locked")},onUnlock:function(){this.vars.listeners.forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked")}}};shmi.requires("visuals.tools.control-generator").generate(n)}(),function(){"use strict";const e="visuals.controls.iq-user-management",t=shmi.pkg(e),s="iq-add-user-dialog";console.error.bind(console,`[${e}]`),console.warn.bind(console,`[${e}]`),console.log.bind(console,`[${e}]`),console.debug.bind(console,`[${e}]`);function closeDialog(e,t){e.active&&!e.data.isDone&&(e.data.isDone=!0,e.getInstance("dlgBox").hide(),e.data.resolve(t))}const n={onCreateUser:function onCreateUser(e){const{UserApiBinding:t}=shmi.requires("visuals.controls.iq-user-management"),{setLockedSlots:s,setUnlockedSlots:n}=shmi.requires("visuals.controls.iq-user-management.controller-tools");if(!e.active)throw new shmi.LocalizedError("${ui.error.dialogAlreadyClosed}");if("string"!=typeof e.data.formData.inputUsername||0===e.data.formData.inputUsername.length)throw new shmi.LocalizedError("${iq-user-controller.error.usernameMustNotBeEmpty}");if(e.data.formData.inputUsername.startsWith(" ")||e.data.formData.inputUsername.endsWith(" ")||e.data.formData.inputUsername.includes("  "))throw new shmi.LocalizedError("${iq-user-controller.error.usernameInvalid}");if("string"!=typeof e.data.formData.inputPassword||0===e.data.formData.inputPassword.length)throw new shmi.LocalizedError("${iq-user-controller.error.passwordMustNotBeEmpty}");if(e.data.formData.inputPassword!==e.data.formData.inputPasswordRep)throw new shmi.LocalizedError("${V_PASSWORD_REPEAT_NOT_EQUAL}");if(e.data.formData.inputPassword.length<shmi.c("MIN_PASSWORD_LENGTH"))throw new shmi.LocalizedError("${V_PASSWORD_TOO_SHORT}");const a=e.data.formData.inputUsername,l=e.data.formData.inputPassword,o={firstName:e.data.formData.inputFirstName,lastName:e.data.formData.inputLastName,userGroups:e.data.formData.inputUserGroup?[e.data.formData.inputUserGroup]:[],localeId:e.data.formData.inputLocale,passwordValidityDuration:e.data.formData.inputPasswordValidityDuration,autoLogoutDelay:e.data.formData.inputAutoLogoutDelay,description:e.data.formData.inputDescription};return n(e,[]),t.createUser(a,l,o).then(closeDialog.bind(null,e,!0)).catch((t=>{throw s(e,[]),t}))},onApplyUser:function onApplyUser(e){const{UserApiBinding:t}=shmi.requires("visuals.controls.iq-user-management"),{setLockedSlots:s,setUnlockedSlots:n}=shmi.requires("visuals.controls.iq-user-management.controller-tools");if(!e.active)throw new shmi.LocalizedError("${ui.error.dialogAlreadyClosed}");if("string"!=typeof e.data.formData.inputUsername||0===e.data.formData.inputUsername.length)throw new shmi.LocalizedError("${iq-user-controller.error.usernameMustNotBeEmpty}");if(e.data.formData.inputUsername.startsWith(" ")||e.data.formData.inputUsername.endsWith(" ")||e.data.formData.inputUsername.includes("  "))throw new shmi.LocalizedError("${iq-user-controller.error.usernameInvalid}");if(e.data.formData.inputPassword!==e.data.formData.inputPasswordRep)throw new shmi.LocalizedError("${iq-user-controller.error.passwordMismatch}");if(void 0!==e.data.formData.inputPassword){if("string"!=typeof e.data.formData.inputPassword||0===e.data.formData.inputPassword.length)throw new shmi.LocalizedError("${iq-user-controller.error.passwordMustNotBeEmpty}");if(e.data.formData.inputPassword.length<shmi.c("MIN_PASSWORD_LENGTH"))throw new shmi.LocalizedError("${V_PASSWORD_TOO_SHORT}")}const a=e.data.formData.inputUsername,l={firstName:e.data.formData.inputFirstName,lastName:e.data.formData.inputLastName,userGroups:e.data.formData.inputUserGroup?[e.data.formData.inputUserGroup]:[],localeId:e.data.formData.inputLocale,password:e.data.formData.inputPassword,passwordValidityDuration:e.data.formData.inputPasswordValidityDuration,autoLogoutDelay:e.data.formData.inputAutoLogoutDelay,description:e.data.formData.inputDescription};return n(e,[]),t.setUser(a,l).then(closeDialog.bind(null,e,!0)).catch((t=>{throw s(e,["inputUsername"]),t}))},onClose:function onClose(e){if(!e.active)throw new shmi.LocalizedError("${ui.error.dialogAlreadyClosed}");closeDialog(e)}};function createDialog(e,t,a,l,o){const r=shmi.getControlByElement(document.body.firstElementChild),{makeControllerDescriptor:c}=shmi.requires("visuals.controls.iq-user-management.controller-tools");r.addControl([{ui:"dialog-box",config:{name:"iq-add-user-dialog",title:t?"${iq-user-controller.title.editUserDialog}":"${iq-user-controller.title.createUserDialog}",template:"default/dialog-box","content-template":null,"class-name":"dialog-box add-or-edit-user "+(t?"hide-passwords":""),"top-level":!1,_controllers_:[{name:s,slot:"dlgBox"}]},children:[{ui:"container",config:{type:"flex","flex-orientation":"column","class-name":"container full-height"},children:[{ui:"container",config:{type:"flex","flex-orientation":"column","class-name":"container dialog-form-container","auto-margin":!0},children:[{ui:"iq-input-field",config:{"class-name":"iq-input-field iq-variant-02",template:"default/iq-input-field.iq-variant-02",label:"${user_name}","unit-text":null,_controllers_:[{name:s,slot:"inputUsername"}]}},{ui:"iq-input-field",config:{"class-name":"iq-input-field iq-variant-02",template:"default/iq-input-field.iq-variant-02",label:"${iq-user-controller.label.firstName}","unit-text":null,_controllers_:[{name:s,slot:"inputFirstName"}]}},{ui:"iq-input-field",config:{"class-name":"iq-input-field iq-variant-02",template:"default/iq-input-field.iq-variant-02",label:"${iq-user-controller.label.lastName}","unit-text":null,_controllers_:[{name:s,slot:"inputLastName"}]}},{ui:"iq-select-box",config:{"class-name":"iq-select-box iq-variant-02",template:"default/iq-select-box.iq-variant-02",label:"${iq-user-controller.label.userGroup}",_controllers_:[{name:s,slot:"inputUserGroup"}]}},{ui:"iq-select-box",config:{"class-name":"iq-select-box iq-variant-02",template:"default/iq-select-box.iq-variant-02",label:"${iq-user-controller.label.localeId}",options:Object.keys(shmi.visuals.session.localeInfo.locales).map((e=>({value:e,label:e}))),value:shmi.visuals.session.localeInfo.default,_controllers_:[{name:s,slot:"inputLocale"}]}},{ui:"container",config:{type:"flex","class-name":"container no-shrink","auto-margin":!0},children:[{ui:"iq-input-field",config:{"class-name":"iq-input-field iq-variant-02 flex-1",template:"default/iq-input-field.iq-variant-02",label:"${iq-user-controller.label.passwordExpiry}","unit-text":null,_controllers_:[{name:s,slot:"inputPasswordValidityDuration"}]}},{ui:"iq-input-field",config:{"class-name":"iq-input-field iq-variant-02 flex-1",template:"default/iq-input-field.iq-variant-02",label:"${iq-user-controller.label.autoLogoutDelay}","unit-text":null,_controllers_:[{name:s,slot:"inputAutoLogoutDelay"}]}}]},{ui:"iq-input-field",config:{"class-name":"iq-input-field iq-variant-05",template:"default/iq-input-field.iq-variant-05",label:"${new_pwd}","unit-text":null,_controllers_:[{name:s,slot:"inputPassword"}]}},{ui:"iq-input-field",config:{"class-name":"iq-input-field iq-variant-05",template:"default/iq-input-field.iq-variant-05",label:"${confirm_new_pwd}","unit-text":null,_controllers_:[{name:s,slot:"inputPasswordRep"}]}},{ui:"iq-input-field",config:{"class-name":"iq-input-field iq-variant-02 textarea",template:"default/iq-input-field.iq-variant-02",label:"${iq-user-controller.label.description}","unit-text":null,multiline:!0,_controllers_:[{name:s,slot:"inputDescription"}]}}]},{ui:"container",config:{"class-name":"container dialog-buttons-container",type:"inline","h-alignment":"right","auto-margin":!0},children:[{ui:"iq-button",config:{"class-name":"iq-button iq-variant-01 primary",label:t?"${iq-user-controller.label.apply}":"${iq-user-controller.label.add}",_controllers_:[{name:s,slot:"btnApply"}]}},{ui:"iq-button",config:{"class-name":"iq-button iq-variant-01",label:"${lbl_cancel}",_controllers_:[{name:s,slot:"btnCancel"}]}}]}]}],controller:c({name:s,slots:{inputUsername:{ui:"iq-input-field",formType:"string"},inputFirstName:{ui:"iq-input-field",formType:"string"},inputLastName:{ui:"iq-input-field",formType:"string"},inputUserGroup:{ui:"iq-select-box",formType:"string"},inputLocale:{ui:"iq-select-box",formType:"string"},inputPasswordValidityDuration:{ui:"iq-input-field",formType:"number"},inputAutoLogoutDelay:{ui:"iq-input-field",formType:"number"},inputPassword:{ui:"iq-input-field",formType:"string"},inputPasswordRep:{ui:"iq-input-field",formType:"string"},inputDescription:{ui:"iq-input-field",formType:"string"},btnApply:{ui:"iq-button",events:{click:t?n.onApplyUser:n.onCreateUser}},btnCancel:{ui:"iq-button",events:{click:n.onClose}},dlgBox:{ui:"dialog-box"}},data:{reject:o,resolve:l,isDone:!1,formData:{}},onEnable:function onEnable(s){const{UserApiBinding:n}=shmi.requires("visuals.controls.iq-user-management"),{setLockedSlots:l,setUnlockedSlots:o,reloadFormValues:r}=shmi.requires("visuals.controls.iq-user-management.controller-tools");o(s,["btnCancel"]);const c=n.listGroups().then((e=>{const t={};e.usergroups.forEach((e=>{t[e.groupname]=[e.groupname],e._groupdata.member_groups.forEach((s=>{t[e.groupname].push(s)}))})),s.getInstance("inputUserGroup").setOptions([{value:null,label:"---"}].concat(e.usergroups.filter((e=>!a||!t[e.groupname].includes("admin"))).map((e=>({value:e.groupname,label:e.groupname})))))}));Promise.all([c]).then((()=>{e&&(s.data.formData={inputUsername:t?e.username:null,inputFirstName:e.firstName,inputLastName:e.lastName,inputUserGroup:e.userGroups[0]||null,inputLocale:e.localeId,inputPasswordValidityDuration:e.passwordValidityDuration,inputAutoLogoutDelay:e.autoLogoutDelay,inputDescription:e.description},r(s,[],[])),l(s,t?["inputUsername"]:[])}))},onDisable:function onDisable(e){e.data.isDone||e.data.resolve(),shmi.deleteControl(e.getInstance("dlgBox"))},onError:function onError(e,t){if("shmi:connect:api:generic"===t.category&&14===t.errc)throw new shmi.LocalizedError("${iq-user-controller.error.invalidParameter}");if("shmi:connect:api:user"===t.category&&4===t.errc)throw new shmi.LocalizedError("${iq-user-controller.error.invalidPasswordExpiryDuration}");throw t}})}],((e,t)=>{e?o(e):t[0].show()}))}t.openUserAddEditDialog=function openUserAddEditDialog(e,t,s){return new Promise(createDialog.bind(null,e,t,s))}}(),function(){const e="visuals.controls.iq-user-management.controller-tools",t=shmi.pkg(e),s=(console.error.bind(console,`[${e}]`),console.warn.bind(console,`[${e}]`),console.log.bind(console,`[${e}]`),console.debug.bind(console,`[${e}]`),{string:function string(e,t,s){if(!e.active||!e.data.formData)return;const n=null===e.data.formData[t],a=(()=>{const s=e.getInstance(t);return s&&s.locked})(),l=""===s.detail.value?null:s.detail.value;(!n||null!==l&&0!==l.length)&&e.data.formData[t]!==l&&(e.data.formData[t]=l,a||(e.data.hasChanged=!0))},number:function number(e,t,s){if(!e.active||!e.data.formData)return;const n=null===e.data.formData[t],a=(()=>{const s=e.getInstance(t);return s&&s.locked})(),l="string"==typeof s.detail.value?""===s.detail.value?null:parseFloat(s.detail.value):s.detail.value;n&&0===l?e.data.formData[t]=l:e.data.formData[t]!==l&&(e.data.formData[t]=l,a||(e.data.hasChanged=!0))},boolean:function boolean(e,t,s){if(!e.active||!e.data.formData)return;const n=null===e.data.formData[t],a=(()=>{const s=e.getInstance(t);return s&&s.locked})(),l=!!s.detail.value;n&&!l?e.data.formData[t]=l:e.data.formData[t]!==l&&(e.data.formData[t]=l,a||(e.data.hasChanged=!0))}});function setFormWidgetValue(e,s){const n=t.uiFormWidgets[e.uiType],a=t.uiFormWidgets.default;void 0===n?a(e,s):"boolean"==typeof n?n&&a(e,s):n(e,s)}t.uiFormWidgets={"input-field":!0,"iq-input-field":!0,checkbox:(e,t)=>e.setValue(t?1:0),"iq-checkbox":(e,t)=>e.setValue(t?1:0),"select-box":!0,"iq-select-box":!0,default:(e,t)=>e.setValue(t)},t.resetFormValues=function resetFormValues(e,s,n){const a=n||Object.keys(t.uiFormWidgets);e.data.formData=s||{},Object.keys(e.slots).forEach((t=>{const s=e.getInstance(t);s&&(a.includes(s.uiType)?(s.setValue(null),e.data.formData[t]=null):e.data.formData[t]&&s.setValue(e.data.formData[t]))}))},t.reloadFormValues=function reloadFormValues(e,s,n){const a=Object.keys(t.uiFormWidgets).concat(n||[]);Object.keys(e.slots).forEach((t=>{const n=e.getInstance(t);n&&-1!==a.indexOf(n.uiType)&&-1===(s||[]).indexOf(t)&&(void 0===e.data.formData[t]?setFormWidgetValue(n,null):setFormWidgetValue(n,e.data.formData[t]))}))},t.addons=t.addons||[],t.addons.push({configName:"formType",addonFunc:e=>({change:s[e]})})}(),function(){"use strict";const e="visuals.controls.iq-user-management.controller-tools",t=shmi.pkg(e),s={error:console.error.bind(console,`[${e}]`),warn:console.warn.bind(console,`[${e}]`),log:console.log.bind(console,`[${e}]`),debug:console.debug.bind(console,`[${e}]`)};function defaultErrorHandler(e,t){const n=function getErrorTexts(e){const t={title:"${V_ERROR}",messageApi:"${visuals.error.api}",messageUnknown:"${visuals.error.unknown}"};return e.data&&e.data.messages?{title:e.data.messages.errorTitle||t.title,messageApi:e.data.messages.errorApi||t.messageApi,messageUnknown:e.data.messages.errorUnknown||t.messageUnknown}:t}(e);s.error(t),t.localizedMessage?shmi.notify(t.localizedMessage,n.title):!t.message&&t.apiError?shmi.notify(n.messageApi,n.title,{ERROR_CODE:t.apiError.errc,ERROR_MSG:t.apiError.message,ERROR_CAT:t.apiError.category}):shmi.notify(t.message||n.messageUnknown,n.title)}function controllerEventHandler(e,t,s,n,a,l,o){let r;if(n.data.ignoreEvents)r=Promise.resolve();else{const s=function getSlotCallback(e,t,s){return"object"!=typeof e||"object"!=typeof e[t]||"function"!=typeof e[t][s]?null:e[t][s]}(e,l,a);r=s?Promise.resolve().then(s.bind(null,n,a,o)):t?Promise.resolve():Promise.reject(new Error(`BUG: Event handler for ${l}@${a} not implemented.`))}s&&(r=r.catch(s.bind(void 0,n))),r.catch(defaultErrorHandler.bind(void 0,n))}t.makeControllerDescriptor=function makeControllerDescriptor(e){const s=function collectAndTranslateEventHandlers(e){const s=shmi.requires("shmi.visuals.tools.iterate.iterateObject"),n={};return s(e,((e,a)=>{Array.isArray(e.events)||(s(e.events||{},((e,t)=>{shmi.objectHasOwnProperty(n,t)||(n[t]={}),n[t][a]=e})),e.events=Object.keys(e.events||{}),(t.addons||[]).forEach((({configName:t,addonFunc:l})=>{if(shmi.objectHasOwnProperty(e,t)){const o=l(e[t],a,e);s(o||{},((t,s)=>{n[s]||(n[s]={});const l=n[s][a];n[s][a]=l?(...e)=>Promise.resolve().then(t.bind(void 0,...e)).then(l.bind(void 0,...e)):t,e.events.includes(s)||e.events.push(s)}))}})),new Set((t.addons||[]).map((({configName:e})=>e))).forEach((t=>delete e[t])))})),n}(e.slots||{}),n=e.onEvent,a=e.onError;return e.onEvent=n?function onEvent(...e){n(...e),controllerEventHandler(s,!0,a,...e)}:controllerEventHandler.bind(void 0,s,!1,a),delete e.onError,e},t.openConfirmBox=function openConfirmBox(e,t,s){return new Promise((n=>{shmi.confirm(e,n,t,s)}))}}(),function(){const e=shmi.pkg("visuals.controls.iq-user-management.controller-tools");e.unlockSlots=function unlockSlots(e,t){e.active&&t.forEach((function(t){const s=e.getInstance(t);s&&s.unlock()}))},e.lockSlots=function lockSlots(e,t){e.active&&t.forEach((function(t){const s=e.getInstance(t);s&&s.lock()}))},e.setUnlockedSlots=function setUnlockedSlots(e,t){e.active&&Object.keys(e.slots).forEach((function(s){const n=e.getInstance(s);n&&(-1===t.indexOf(s)?n.lock():n.unlock())}))},e.setLockedSlots=function setLockedSlots(e,t){e.active&&Object.keys(e.slots).forEach((function(s){const n=e.getInstance(s);n&&(-1===t.indexOf(s)?n.unlock():n.lock())}))},e.lockAllSlots=function lockAllSlots(t,s){e.lockSlots(t,Object.keys(t.slots).filter((e=>-1===(s||[]).indexOf(e))))},e.unlockAllSlots=function unlockAllSlots(t,s){e.unlockSlots(t,Object.keys(t.slots).filter((e=>-1===(s||[]).indexOf(e))))},e.delay=function delay(e){return new Promise((t=>setTimeout(t,e)))}}(),function(){const e=shmi.pkg("visuals.controls.iq-user-management"),t={error:console.error.bind(console,"[DataGridUser]"),warn:console.warn.bind(console,"[DataGridUser]"),log:console.log.bind(console,"[DataGridUser]"),debug:console.debug.bind(console,"[DataGridUser]")};let s=1;function makeRow(e,t,s){const n=shmi.visuals.session.ItemManager;shmi.checkArg("self",e,"DataGridUser"),shmi.checkArg("rowId",t,"number"),shmi.checkArg("rowData",s,"array"),e.data[t]=s,s.forEach((function(e,s){const a=this.prefix+t+":"+s,l=n.getItem(a);l&&l.initialized?(e.item=l,e.item.writable=!0,e.item.writeValue(e.value)):(e.item=shmi.createVirtualItem(a,e.type,e.min,e.max,e.value,function(e,t,s,n,a){const l=this.getRowData(e);l&&l[t]&&(l[t].value=s)}.bind(this,t,s)),e.item.setDataGridInfo(this.name,t,s)),e.item.writable=!1}),e)}function calcState(e,t){return shmi.checkArg("self",e,"DataGridUser"),shmi.checkArg("subID",t,"object"),t?{status:"OK",offset:t.offset,size:t.size,totalRows:e.totalRows}:{status:"FAILED",totalRows:e.totalRows||0}}function delayedRefresh(e){shmi.checkArg("self",e,"DataGridUser"),null!==e.refreshTimeout&&clearTimeout(e.refreshTimeout),e.refreshTimeout=setTimeout(e.refresh.bind(e),shmi.c("ACTION_RETRY_TIMEOUT"))}function doRefreshSubscriber(e,t){shmi.checkArg("self",e,"DataGridUser"),shmi.checkArg("sub",t,"object"),t.onChange(calcState(e,t))}function translateColumnName(e){return{firstName:"first_name",lastName:"last_name",localeId:"locale_id",passwordValidityDuration:"password_expiry_duration",passwordTimestamp:"password_timestamp",autoLogoutDelay:"auto_logout_duration"}[e]||e}function buildFilterExpression(e){return shmi.checkArg("self",e,"DataGridUser"),{mode:e.filterChaining,clauses:e.getFilters().map(((t,s)=>null===t?null:{location:"property",mode:"OR",column:translateColumnName(e.getFields()[s]),clauses:t.map((e=>({operator:"like",value:e})))})).filter((e=>null!==e))}}function buildSortExpression(e){return shmi.checkArg("self",e,"DataGridUser"),null===e.order?[]:[{column:translateColumnName(e.getFields()[e.order[0]]),order:e.order[1]}]}function taskDelete(e,t){shmi.checkArg("self",e,"DataGridUser"),shmi.checkArg("task",t,"object");const s=e.rowObjectData[t.rowID];return s?s.delete():Promise.reject(new Error(`No row for rowID ${t.rowId}`))}async function taskFetchAll(e){shmi.checkArg("self",e,"DataGridUser");const{UserApiBinding:t}=shmi.requires("visuals.controls.iq-user-management"),{iterateObject:s}=shmi.requires("visuals.tools.iterate"),n=function calculateRequestRanges(e){const t=[];return shmi.checkArg("self",e,"DataGridUser"),Object.values(e.subscribers).sort(((e,t)=>t.offset-e.offset)).forEach((function(e,s){if(0===s)return void t.push({begin:e.offset,end:e.offset+e.size});const n=t[t.length-1];n.end<e.offset?t.push({begin:e.offset,end:e.offset+e.size}):n.end<e.offset+e.size&&(e.end=e.offset+e.size)})),t}(e),a=await t.listGroups(),l={};a.usergroups.forEach((e=>{l[e.groupname]=[e.groupname],e._groupdata.member_groups.forEach((t=>{l[e.groupname].push(t)}))}));const o=n.map((s=>t.listUsers({filter:buildFilterExpression(e),sort:buildSortExpression(e)}).then((t=>{e.hideAdmin&&(t.users=t.users.filter((e=>!e.userGroups.some((e=>l[e].includes("admin")))))),t.users.forEach((function(t,s){e.rowObjectData[s]=t,makeRow(e,s,function makeRowDataFromUser(e){return shmi.checkArg("user",e,"User"),[{type:shmi.c("TYPE_STRING"),value:e.username,min:Number.NaN,max:Number.NaN},{type:shmi.c("TYPE_STRING"),value:e.firstName,min:Number.NaN,max:Number.NaN},{type:shmi.c("TYPE_STRING"),value:e.lastName,min:Number.NaN,max:Number.NaN},{type:shmi.c("TYPE_STRING"),value:e.localeId,min:Number.NaN,max:Number.NaN},{type:shmi.c("TYPE_INT"),value:e.passwordValidityDuration,min:Number.NaN,max:Number.NaN},{type:shmi.c("TYPE_INT"),value:e.passwordTimestamp?e.passwordTimestamp.getTime():null,min:Number.NaN,max:Number.NaN},{type:shmi.c("TYPE_STRING"),value:e.userGroups.join(", "),min:Number.NaN,max:Number.NaN},{type:shmi.c("TYPE_INT"),value:null===e.autoLogoutDelay?-1:e.autoLogoutDelay,min:Number.NaN,max:Number.NaN},{type:shmi.c("TYPE_BOOLEAN"),value:e.disabled,min:Number.NaN,max:Number.NaN},{type:shmi.c("TYPE_STRING"),value:e.description,min:Number.NaN,max:Number.NaN},{type:shmi.c("TYPE_STRING"),value:String.fromCodePoint(9679+118170*Math.floor(Math.random()+.001)).repeat(5),min:Number.NaN,max:Number.NaN}]}(t))})),e.totalRows=t.users.length}))));return Promise.all(o).then((()=>s(e.subscribers,doRefreshSubscriber.bind(null,e))))}e.DataGridUser=class DataGridUser{constructor(e,t){const{TaskExecutor:s}=shmi.requires("visuals.controls.iq-user-management");Object.defineProperties(this,{name:{value:e,writable:!1},type:{value:"User",writable:!1},prefix:{value:`virtual:grid:${e}:`,writable:!1},data:{value:{},writable:!0},rowObjectData:{value:{},writable:!0},subscribers:{value:{},writable:!0},nextRowID:{value:0,writable:!0},totalRows:{value:0,writable:!0},order:{value:null,writable:!0},filter:{value:{},writable:!0},filterChaining:{value:"AND",writable:!0},executor:{value:new s,writable:!1},refreshTimeout:{value:null,writable:!0},hideAdmin:{value:!(!t||!t.hideAdmin),writable:!1}}),this.executor.registerNamed("delete",taskDelete.bind(null,this)),this.executor.registerNamed("fetch_all",taskFetchAll.bind(null,this))}init(){this.taskQueue=[],this.subscribers={}}subscribePage(e,t,n){shmi.checkArg("offset",e,"number"),shmi.checkArg("size",t,"number"),shmi.checkArg("onChange",n,"function");const a={id:s++,offset:e,size:t,onChange:n};return this.subscribers[a.id]=a,this.executor.postNamed("fetch_all",!0),{id:a.id,prefix:this.prefix}}getFields(){return["username","firstName","lastName","localeId","passwordValidityDuration","passwordTimestamp","userGroups","autoLogoutDelay","disabled","description","fakePassword"]}getIndexFields(){return[0]}getRowIndex(e){shmi.checkArg("rowId",e,"number");const t=this.getRowData(e);return t?this.getIndexFields().map((function(e){return t[e].value})):null}searchIndexRowId(e){const t=this.getIndexFields();let s=-1;return shmi.checkArg("rowIndex",e,"array"),Object.keys(this.data).map((e=>parseInt(e))).some((n=>!!this.searchIndexFields(n,t,e)&&(s=n,!0))),s}searchIndexFields(e,t,s){return shmi.checkArg("row",e,"number"),shmi.checkArg("fields",t,"array"),shmi.checkArg("rowIndex",s,"array"),t.length>0&&this.data[e].every(((e,t)=>e.value===s[t]))}insertRow(e,t){const s=shmi.requires("visuals.tools.iterate").iterateObject,n=this.nextRowID++;return shmi.checkArg("rowData",e,"array"),makeRow(this,n,e),t||s(this.subscribers,(e=>{e.onChange(calcState(this,e))})),n}deleteRow(e){shmi.checkArg("rowID",e,"number","array"),(Array.isArray(e)?e:[e]).forEach((e=>{this.executor.postNamed("delete",!1,{rowID:parseInt(e)})})),this.executor.postNamed("fetch_all",!0)}deleteAll(){this.deleteRow(Object.keys(this.rowObjectData))}unsubscribe(e){const t=shmi.requires("visuals.session.ItemManager"),s=shmi.requires("visuals.tools.iterate.iterateObject");shmi.checkArg("subID",e,"number"),delete this.subscribers[e],0===Object.keys(this.subscribers).length&&(s(this.data,(e=>{e.forEach((e=>t.removeItem(e.item.name)))})),this.data={},this.rowObjectData={})}setOffset(e,t){shmi.checkArg("offset",e,"number"),shmi.checkArg("subID",t,"number"),void 0!==this.subscribers[t]&&(this.subscribers[t].offset=e,this.executor.postNamed("fetch_all",!0))}getRowCount(){return this.totalRows}setFilter(e,t){this.filter[this.getFields()[e]]=t,delayedRefresh(this)}setFilterChaining(e){shmi.checkArg("chaining",e,"string"),"OR"===e||"AND"===e?(this.filterChaining=e,delayedRefresh(this)):t.error("Invalid filter chaining mode:",e)}getFilters(){return this.getFields().map((e=>shmi.objectHasOwnProperty(this.filter,e)?this.filter[e]:null))}refresh(){const{iterateObject:e}=shmi.requires("visuals.tools.iterate");e(this.subscribers,(function(e){e.offset=0})),this.data={},this.rowObjectData={},this.totalRows=0,this.executor.postNamed("fetch_all",!0)}clearFilter(e){let t=!1;shmi.checkArg("col",e,"number"),-1===e?(t=Object.keys(this.filter).length>0,this.filter={}):void 0!==this.filter[this.getFields()[e]]&&(delete this.filter[this.getFields()[e]],t=!0),t&&delayedRefresh(this)}sort(e,t){const s=this.order;shmi.checkArg("col",e,"number"),shmi.checkArg("col",t,"string"),this.order=-1===e?null:[e,t],this.order!==s&&delayedRefresh(this)}getCurrentIDs(e){shmi.checkArg("subID",e,"number");const t=this.subscribers[e];return void 0===t?[]:Object.keys(this.data).map((e=>parseInt(e))).filter((e=>t.offset<=e&&e<t.offset+t.size))}getAllIDs(){return Object.keys(this.data)}getRowData(e){return shmi.checkArg("rowId",e,"number"),void 0!==this.data[e]?this.data[e]:null}}}(),function(){"use strict";const e="IqUserController",t="iq-user-controller",s={"class-name":t,name:null,template:"default/iq-user-controller.iq-variant-01","user-select":null,"button-order":["add","edit","clone","remove","expirepw","setpw"],"button-usage":{add:!0,clone:!0,edit:!0,remove:!0,expirepw:!0,setpw:!0}},n={error:console.error.bind(console,`[${e}]`),warn:console.warn.bind(console,`[${e}]`),log:console.log.bind(console,`[${e}]`),debug:console.debug.bind(console,`[${e}]`)};function defaultErrorHandler(e){const t="${V_ERROR}",s="${visuals.error.api}",a="${visuals.error.unknown}";n.error(e),e.localizedMessage?shmi.notify(e.localizedMessage,t):!e.message&&e.apiError?shmi.notify(s,t,{ERROR_CODE:e.apiError.errc,ERROR_MSG:e.apiError.message,ERROR_CAT:e.apiError.category}):shmi.notify(e.message||a,t)}function isAdminUser(e,t){const s=[];return e.userGroups.forEach((e=>{t[e].forEach((e=>{s.includes(e)||s.push(e)}))})),s.includes("admin")}function isAdminHidden(e){return e.vars.select.control&&e.vars.select.control.getConfig()["hide-admin"]}const a={onAdd:function onAdd(e){const{openUserAddEditDialog:t}=shmi.requires("visuals.controls.iq-user-management");t(null,!1,isAdminHidden(e)).catch(defaultErrorHandler).finally(refreshSelectionControl.bind(null,e))},onClone:function onClone(e){const{openUserAddEditDialog:t}=shmi.requires("visuals.controls.iq-user-management"),{UserApiBinding:s}=shmi.requires("visuals.controls.iq-user-management"),n=e.vars.select.selection;n&&s.getUser(n).then((s=>t(s,!1,isAdminHidden(e)))).catch(defaultErrorHandler).finally(refreshSelectionControl.bind(null,e))},onEdit:function onEdit(e){const{openUserAddEditDialog:t}=shmi.requires("visuals.controls.iq-user-management"),{UserApiBinding:s}=shmi.requires("visuals.controls.iq-user-management"),n=e.vars.select.selection;n&&s.getUser(n).then((s=>t(s,!0,isAdminHidden(e)))).catch(defaultErrorHandler).finally(refreshSelectionControl.bind(null,e))},onRemove:async function onRemove(e){const{UserApiBinding:t}=shmi.requires("visuals.controls.iq-user-management"),{openConfirmBox:s}=shmi.requires("visuals.controls.iq-user-management.controller-tools"),n=e.vars.select.selection;if(!n)return;const a=await t.listGroups(),l={};a.usergroups.forEach((e=>{l[e.groupname]=[e.groupname],e._groupdata.member_groups.forEach((t=>{l[e.groupname].push(t)}))}));const o=await t.listUsers(),r=o.users.find((e=>e.username===n));if(r&&isAdminUser(r,l)){if(!o.users.some((e=>e!==r&&isAdminUser(e,l))))return void shmi.notify("${iq-user-controller.message.lastAdminUser}")}s(shmi.evalString(shmi.localize("${iq-user-controller.confirm.delete}"),{USERNAME:n}),"${iq-user-controller.title.confirmDelete}").then((e=>e?t.deleteUser(n):Promise.resolve())).catch(defaultErrorHandler).finally(refreshSelectionControl.bind(null,e))},onForceExpire:function onForceExpire(e){const{UserApiBinding:t}=shmi.requires("visuals.controls.iq-user-management"),{openConfirmBox:s}=shmi.requires("visuals.controls.iq-user-management.controller-tools"),n=e.vars.select.selection;n&&s(shmi.evalString(shmi.localize("${iq-user-controller.confirm.expire}"),{USERNAME:n}),"${iq-user-controller.title.confirmExpire}").then((e=>e?t.setUser(n,{passwordForceExpired:!0}):Promise.resolve())).catch(defaultErrorHandler).finally(refreshSelectionControl.bind(null,e))},onSetPassword:function onSetPassword(e){const{openSetPasswordDialog:t}=shmi.requires("visuals.controls.iq-user-management"),s=e.vars.select.selection;s&&t(s).catch(defaultErrorHandler).finally(refreshSelectionControl.bind(null,e))}};function nameOrNodeHandleMatches(e,t){const{HANDLE_PREFIX:s,getNodeHandle:n}=shmi.requires("visuals.tools.nodes");return"string"==typeof e&&e.startsWith(s)?n(t)===e.replace(s,""):e===t.getName()}function attachUserSelectListeners(e){function onSelectEnableHandler(t){nameOrNodeHandleMatches(e.config["user-select"],t.source)&&onSelectEnable(e,t.source)}function onSelectDisableHandler(t){nameOrNodeHandleMatches(e.config["user-select"],t.source)&&function onSelectDisable(e,t){e.vars.select.control=null,e.vars.select.changeToken&&(e.vars.select.changeToken.unlisten(),e.vars.select.changeToken=null);setSelection(e,null)}(e,t.source)}e.vars.tokens.push(shmi.listen("enable",onSelectEnableHandler,{"source.uiType":"iq-user-select"})),e.vars.tokens.push(shmi.listen("enable",onSelectEnableHandler,{"source.uiType":"iq-user-list"})),e.vars.tokens.push(shmi.listen("disable",onSelectDisableHandler,{"source.uiType":"iq-user-select"})),e.vars.tokens.push(shmi.listen("disable",onSelectDisableHandler,{"source.uiType":"iq-user-list"}))}function updateButtonState(e){const t=Object.values(e.vars.buttons).filter((e=>null!==e)),s=e.vars.select.selection;e.locked?t.forEach((e=>e.lock())):s?t.forEach((e=>e.unlock())):t.forEach((t=>{t===e.vars.buttons.add?t.unlock():t.lock()}))}function toIqButtonVariant(e){let s=e.replace(t,"iq-button");const n=s.match(/iq-variant-(\d+)/);if(n){const e=parseInt(n[1]);s=s.replace(n[0],"iq-variant-0"+(1+(1+e)%2))}return s}function refreshSelectionControl(e){e.vars.select.control&&(e.vars.select.control.refresh(),e.vars.select.control.setValue(null))}function setSelection(e,t){e.vars.select.selection=t||null,updateButtonState(e)}function onSelectEnable(e,t){e.vars.select.control=t,t.getCurrentUser?setSelection(e,t.getCurrentUser()):n.error("user-select does not implement required interface"),e.vars.select.changeToken&&(e.vars.select.changeToken.unlisten(),e.vars.select.changeToken=null),e.vars.select.changeToken=t.listen("change",(t=>{setSelection(e,t.detail.value)}))}const l={className:e,uiType:t,isContainer:!0,config:s,configSchema:null,vars:{domContainer:null,buttons:{add:null,edit:null,remove:null,clone:null,expirepw:null,setpw:null},select:{control:null,changeToken:null,selection:null},tokens:[]},imports:{},events:[],prototypeExtensions:{onInit:function(){const e=this.vars.buttons,t={add:{name:"add-user",label:"${iq-user-controller.label.add}",icon:"pics/system/controls/iq-user-controller/add-dark.svg"},edit:{name:"edit-user",label:"${iq-user-controller.label.edit}",icon:"pics/system/controls/iq-user-controller/edit-dark.svg"},remove:{name:"remove-user",label:"${iq-user-controller.label.remove}",icon:"pics/system/controls/iq-user-controller/remove-dark.svg"},clone:{name:"clone-user",label:"${iq-user-controller.label.clone}",icon:"pics/system/controls/iq-user-controller/clone-dark.svg"},expirepw:{name:"expirepw-user",label:"${iq-user-controller.label.expirepw}",icon:"pics/system/controls/iq-user-controller/reset-dark.svg"},setpw:{name:"setpw-user",label:"${iq-user-controller.label.setpw}",icon:"pics/system/controls/iq-user-controller/password-dark.svg"}};this.vars.domContainer=shmi.getUiElement("button-container",this.element),Array.isArray(this.config["button-order"])&&this.config["button-order"].forEach((s=>{if(null===e[s]&&t[s]){const{name:n,label:a,icon:l}=t[s];e[s]=function createControllerButton(e,t,s,n,a){const l={name:t,label:s,"icon-title":null,"class-name":`${toIqButtonVariant(e.config["class-name"])} ${t}`,template:toIqButtonVariant(e.config.template),"icon-src":n,tooltip:s,"show-icon":!0,"show-text":!0};return e.config["button-usage"]&&!0!==e.config["button-usage"][a]?null:shmi.createControl("iq-button",e.vars.domContainer||e.element,l,"DIV")}(this,n,a,l,s)}}))},onEnable:function(){if(this.controls.forEach((e=>e.enable())),function attachButtonListeners(e){e.vars.buttons.add&&e.vars.tokens.push(e.vars.buttons.add.listen("click",a.onAdd.bind(null,e))),e.vars.buttons.clone&&e.vars.tokens.push(e.vars.buttons.clone.listen("click",a.onClone.bind(null,e))),e.vars.buttons.edit&&e.vars.tokens.push(e.vars.buttons.edit.listen("click",a.onEdit.bind(null,e))),e.vars.buttons.remove&&e.vars.tokens.push(e.vars.buttons.remove.listen("click",a.onRemove.bind(null,e))),e.vars.buttons.expirepw&&e.vars.tokens.push(e.vars.buttons.expirepw.listen("click",a.onForceExpire.bind(null,e))),e.vars.buttons.setpw&&e.vars.tokens.push(e.vars.buttons.setpw.listen("click",a.onSetPassword.bind(null,e)))}(this),null===this.config["user-select"])updateButtonState(this);else{const e=shmi.ctrl(this.config["user-select"]);e&&e.isActive()?onSelectEnable(this,e):updateButtonState(this),attachUserSelectListeners(this)}},onDisable:function(){this.controls.forEach((e=>e.disable())),this.vars.tokens.forEach((e=>e.unlisten())),this.vars.tokens=[],this.vars.select.changeToken&&(this.vars.select.changeToken.unlisten(),this.vars.select.changeToken=null)},onDelete:function(){},onLock:function(){this.controls.forEach((e=>e.lock()))},onUnlock:function(){this.controls.forEach((e=>e.unlock()))}}};shmi.requires("visuals.tools.control-generator").generate(l)}(),function(){"use strict";const e="visuals.controls.iq-user-management",t=shmi.pkg(e),s="iq-set-password-dialog";console.error.bind(console,`[${e}]`),console.warn.bind(console,`[${e}]`),console.log.bind(console,`[${e}]`),console.debug.bind(console,`[${e}]`);function closeDialog(e,t){e.active&&!e.data.isDone&&(e.data.isDone=!0,e.getInstance("dlgBox").hide(),e.data.resolve(t))}const n={onSetPassword:function onSetPassword(e){const{UserApiBinding:t}=shmi.requires("visuals.controls.iq-user-management"),{setLockedSlots:s,setUnlockedSlots:n}=shmi.requires("visuals.controls.iq-user-management.controller-tools");if(!e.active)throw new shmi.LocalizedError("${ui.error.dialogAlreadyClosed}");if("string"!=typeof e.data.formData.inputPassword||0===e.data.formData.inputPassword.length)throw new shmi.LocalizedError("${iq-user-controller.error.passwordMustNotBeEmpty}");if(e.data.formData.inputPassword!==e.data.formData.inputPasswordRep)throw new shmi.LocalizedError("${V_PASSWORD_REPEAT_NOT_EQUAL}");if(e.data.formData.inputPassword.length<shmi.c("MIN_PASSWORD_LENGTH"))throw new shmi.LocalizedError("${V_PASSWORD_TOO_SHORT}");const a=e.data.username,l=e.data.formData.inputPassword;return n(e,[]),t.setUser(a,{password:l}).then(closeDialog.bind(null,e,!0)).catch((t=>{throw s(e,[]),t}))},onClose:function onClose(e){if(!e.active)throw new shmi.LocalizedError("${ui.error.dialogAlreadyClosed}");closeDialog(e)}};function createDialog(e,t,a){const l=shmi.getControlByElement(document.body.firstElementChild),{makeControllerDescriptor:o}=shmi.requires("visuals.controls.iq-user-management.controller-tools");l.addControl([{ui:"dialog-box",config:{name:"iq-change-user-password",title:shmi.evalString(shmi.localize("${iq-user-controller.title.setPasswordDialog}"),{USERNAME:e}),template:"default/dialog-box","content-template":null,"class-name":"dialog-box change-user-password","top-level":!1,_controllers_:[{name:s,slot:"dlgBox"}]},children:[{ui:"container",config:{type:"flex","flex-orientation":"column","class-name":"container full-height"},children:[{ui:"container",config:{type:"flex","flex-orientation":"column","class-name":"container dialog-form-container","auto-margin":!0},children:[{ui:"iq-input-field",config:{"class-name":"iq-input-field iq-variant-05",template:"default/iq-input-field.iq-variant-05",label:"${new_pwd}","unit-text":null,_controllers_:[{name:s,slot:"inputPassword"}]}},{ui:"iq-input-field",config:{"class-name":"iq-input-field iq-variant-05",template:"default/iq-input-field.iq-variant-05",label:"${confirm_new_pwd}","unit-text":null,_controllers_:[{name:s,slot:"inputPasswordRep"}]}}]},{ui:"container",config:{"class-name":"container dialog-buttons-container",type:"inline","h-alignment":"right","auto-margin":!0},children:[{ui:"iq-button",config:{"class-name":"iq-button iq-variant-01 primary",label:"${iq-user-controller.label.setPassword}",_controllers_:[{name:s,slot:"btnApply"}]}},{ui:"iq-button",config:{"class-name":"iq-button iq-variant-01",label:"${lbl_cancel}",_controllers_:[{name:s,slot:"btnCancel"}]}}]}]}],controller:o({name:s,slots:{inputPassword:{ui:"iq-input-field",formType:"string"},inputPasswordRep:{ui:"iq-input-field",formType:"string"},btnApply:{ui:"iq-button",events:{click:n.onSetPassword}},btnCancel:{ui:"iq-button",events:{click:n.onClose}},dlgBox:{ui:"dialog-box"}},data:{reject:a,resolve:t,isDone:!1,username:e,formData:{}},onEnable:function onEnable(e){},onDisable:function onDisable(e){e.data.isDone||e.data.resolve(),shmi.deleteControl(e.getInstance("dlgBox"))}})}],((e,t)=>{e?a(e):t[0].show()}))}t.openSetPasswordDialog=function openSetPasswordDialog(e){return new Promise(createDialog.bind(null,e))}}(),function(){const e=shmi.pkg("visuals.controls.iq-user-management"),t={error:console.error.bind(console,"[UserApiBinding]"),warn:console.warn.bind(console,"[UserApiBinding]"),log:console.log.bind(console,"[UserApiBinding]"),debug:console.debug.bind(console,"[UserApiBinding]")};function onTaskDone(e,s){shmi.checkArg("self",e,"TaskExecutor"),shmi.checkArg("err",s,"object","null"),s?t.error("Task command failed",s):0===e.tasksRunning&&t.warn("tasksRunning is 0 but there are still tasks running"),0==--e.tasksRunning&&(e.tasksJoin=!1,processTaskQueue(e))}function executeTask(e,t){shmi.checkArg("self",e,"TaskExecutor"),shmi.checkArg("task",t,"object"),e.tasksRunning++,t.serialized&&(e.tasksJoin=!0),Promise.resolve().then((()=>t.executor.apply(void 0,t.data))).then(onTaskDone.bind(null,e,null)).catch(onTaskDone.bind(null,e))}function processTaskQueue(e){shmi.checkArg("self",e,"TaskExecutor"),function getTasks(e,t){var s,n=[];return shmi.checkArg("self",e,"TaskExecutor"),shmi.checkArg("popSerialized",t,"boolean","undefined"),0===e.taskQueue.length?[]:((s=e.taskQueue.some((function(t,s){return t.serialized&&(n=e.taskQueue.splice(0,s)),!!t.serialized})))?s&&t&&n.push(e.taskQueue.shift()):(n=e.taskQueue,e.taskQueue=[]),n)}(e,!this.tasksJoin).forEach(executeTask.bind(null,e))}e.TaskExecutor=class TaskExecutor{constructor(){Object.defineProperties(this,{taskQueue:{value:[],writable:!0},tasksRunning:{value:0,writable:!0},tasksJoin:{value:!1,writable:!0},taskMap:{value:{},writable:!0}})}registerNamed(e,t){shmi.checkArg("name",e,"string"),shmi.checkArg("taskFunc",t,"function"),this.taskMap[e]=t}postNamed(e,t,...s){if(shmi.checkArg("name",e,"string"),shmi.checkArg("isSerialized",t,"boolean","undefined"),!shmi.objectHasOwnProperty(this.taskMap,e))throw new Error(`Named task ${e} does not exist.`);this.post(this.taskMap[e],t,...s)}post(e,t,...s){shmi.checkArg("taskFunc",e,"function"),shmi.checkArg("isSerialized",t,"boolean","undefined"),this.taskQueue.push({executor:e,serialized:t,data:[...s]}),processTaskQueue(this)}}}(),function(){const e=shmi.pkg("visuals.controls.iq-user-management");console.error.bind(console,"[User]"),console.warn.bind(console,"[User]"),console.log.bind(console,"[User]"),console.debug.bind(console,"[User]");e.User=class User{constructor(e){const t={},{iterateObject:s}=shmi.visuals.tools.iterate;s(e||{},((e,s)=>t[s]=e)),Object.defineProperty(this,"_userdata",{value:t,writable:!1,enumerable:!1,configurable:!0})}setProperties(e){const{ConnectSession:t}=shmi.visuals.session,{iterateObject:s}=shmi.visuals.tools.iterate,n=User.translateInternal2Api(e);return n.username=this.username,t.requestPromise("user.set",n).then((()=>s(n,((e,t)=>this._userdata[t]=e))))}delete(){const{ConnectSession:e}=shmi.visuals.session;return e.requestPromise("user.del",this.username)}getUserData(e,t){return shmi.checkArg("key",e,"string"),shmi.checkArg("lookupIn",t,"string","array","undefined"),void 0===t?t=["user","group"]:"string"==typeof t&&(t=[t]),t.includes("user")&&shmi.objectHasOwnProperty(this._userdata.data,e)?this._userdata.data[e]:t.includes("group")&&shmi.objectHasOwnProperty(this._userdata.group_data,e)?this._userdata.group_data[e]:null}static translateInternal2Api(e){return{username:e.username,auto_logout_duration:e.autoLogoutDelay,comment:e.description,first_name:e.firstName,last_name:e.lastName,locale_id:e.localeId,password:e.password,password_expiry_duration:e.passwordValidityDuration,password_force_expired:e.passwordForceExpired,groups:e.userGroups,disabled:e.disabled,data:e.userData,group_data:e.groupData}}get autoLogoutDelay(){return this._userdata.auto_logout_duration}get username(){return this._userdata.username}get firstName(){return this._userdata.first_name}get lastName(){return this._userdata.last_name}get localeId(){return this._userdata.locale_id}get passwordValidityDuration(){return this._userdata.password_expiry_duration}get passwordIsExpired(){return!!this._userdata.password_is_expired}get passwordTimestamp(){return null===this._userdata.password_timestamp?null:new Date(this._userdata.password_timestamp/1e4)}get userGroups(){return(this._userdata.groups||[]).slice()}get deactivated(){return this._userdata.disabled}get disabled(){return this._userdata.disabled}get description(){return this._userdata.comment}}}(),function(){const e=shmi.pkg("visuals.controls.iq-user-management");console.error.bind(console,"[UserApiBinding]"),console.warn.bind(console,"[UserApiBinding]"),console.log.bind(console,"[UserApiBinding]"),console.debug.bind(console,"[UserApiBinding]");e.UserApiBinding=class UserApiBinding{static listUsers(e){const{ConnectSession:t}=shmi.visuals.session,{User:s}=shmi.requires("shmi.visuals.controls.iq-user-management");return shmi.checkArg("filterOptions",e,"object","null","undefined"),t.requestPromise("user.list",e||{}).then((e=>(e.users=e.users.map((e=>new s(e))),e)))}static listGroups(e){const{ConnectSession:t}=shmi.visuals.session,{UserGroup:s}=shmi.requires("shmi.visuals.controls.iq-user-management");return shmi.checkArg("filterOptions",e,"object","null","undefined"),t.requestPromise("usergroup.list",e||{}).then((e=>(e.usergroups=e.usergroups.map((e=>new s(e))),e)))}static getUser(e){const{ConnectSession:t}=shmi.visuals.session,{User:s}=shmi.requires("shmi.visuals.controls.iq-user-management");return shmi.checkArg("username",e,"string"),t.requestPromise("user.get",e).then((e=>new s(e)))}static createUser(e,t,s){const{ConnectSession:n}=shmi.visuals.session,{User:a}=shmi.requires("shmi.visuals.controls.iq-user-management"),l=a.translateInternal2Api(s||{});return l.username=e,l.password=t,n.requestPromise("user.add",l).then((()=>new a(e,l)))}static setUser(e,t){const{ConnectSession:s}=shmi.visuals.session,{User:n}=shmi.requires("shmi.visuals.controls.iq-user-management"),a=n.translateInternal2Api(t);return a.username=e,s.requestPromise("user.set",a)}static deleteUser(e){const{ConnectSession:t}=shmi.visuals.session;return shmi.checkArg("username",e,"string"),t.requestPromise("user.del",e)}}}(),function(){const e=shmi.pkg("visuals.controls.iq-user-management");console.error.bind(console,"[UserGroup]"),console.warn.bind(console,"[UserGroup]"),console.log.bind(console,"[UserGroup]"),console.debug.bind(console,"[UserGroup]");e.UserGroup=class UserGroup{constructor(e){const t={},{iterateObject:s}=shmi.visuals.tools.iterate;s(e||{},((e,s)=>t[s]=e)),Object.defineProperty(this,"_groupdata",{value:t,writable:!1,enumerable:!1,configurable:!0})}setProperties(e){const{ConnectSession:t}=shmi.visuals.session,{iterateObject:s}=shmi.visuals.tools.iterate,n=UserGroup.translateInternal2Api(e);return n.groupname=this.groupname,t.requestPromise("usergroup.set",n).then((()=>s(n,((e,t)=>this._groupdata[t]=e))))}delete(){const{ConnectSession:e}=shmi.visuals.session;return e.requestPromise("usergroup.del",this.groupname)}getUserData(e){return shmi.checkArg("key",e,"string"),shmi.objectHasOwnProperty(this._groupdata.data,e)?this._groupdata.data[e]:null}static translateInternal2Api(e){return{groupname:e.groupname,data:e.groupData,comment:e.description}}get groupname(){return this._groupdata.groupname}get description(){return this._groupdata.comment}}}(),function(){"use strict";function makeDgColumnMap(e,t){const s={};return t.forEach((t=>{const n=e.getFields().findIndex((e=>e===t));n>-1&&(s[t]=n)})),s}function makeFieldControlMap(e){const t={};return e.forEach((e=>{t[e]={"ui-type":"text2",config:{options:[{label:"-",value:-1}]}}})),t}function makeColumnOrg(e){const t={};return e.forEach(((e,s)=>{t[`col${s+1}`]={fields:[e]}})),t}shmi.pkg("visuals.controls.iq-user-list").makeUserListConfig=function makeUserListConfig(e,t){const s=["username","firstName","lastName","localeId"].filter((e=>t.includes(e))),n=["username","firstName","lastName","localeId","passwordValidityDuration","passwordTimestamp","autoLogoutDelay","disabled"].filter((e=>t.includes(e)));return{table:e.name,"class-name":"complex-table2","field-datagrid-col-map":makeDgColumnMap(e,t),"default-field-control-map":makeFieldControlMap(t),"default-field-headers":{username:"${user_name}",firstName:"${iq-user-controller.label.firstName}",lastName:"${iq-user-controller.label.lastName}",localeId:"${iq-user-controller.label.localeId}",passwordValidityDuration:"${iq-user-controller.label.passwordExpiry}",autoLogoutDelay:"${iq-user-controller.label.autoLogoutDelay}",userGroups:"${iq-user-controller.label.userGroups}",description:"${iq-user-controller.label.description}",fakePassword:"${iq-user-controller.label.password}"},"default-layout":{"class-name":"layout-std","column-org":makeColumnOrg(t)},"sortable-fields":n,"default-text-filter-fields":s,quicksearch:{enable:!0,fields:s,remember:!1,initialFocus:!1},"select-mode":"SINGLE","delete-selected-rows":!1,"show-nof-rows":!0,"text-mode":"SINGLELINE","v-scroll-options":["SCROLLBAR","V_SWIPE"]}}}(),function(){"use strict";const e="IqUserList",t="iq-user-list",s={"class-name":t,name:null,template:"default/iq-user-list.iq-variant-01",label:t,"column-order":["username","lastName","firstName","userGroups","passwordValidityDuration","autoLogoutDelay","localeId","description","fakePassword"],"show-last-name":!0,"show-first-name":!0,"show-user-groups":!0,"show-password-validity":!0,"show-auto-logout-delay":!0,"show-locale":!0,"show-description":!0,"show-fake-password":!1,"hide-admin":!1},n={error:console.error.bind(console,`[${e}]`),warn:console.warn.bind(console,`[${e}]`),log:console.log.bind(console,`[${e}]`),debug:console.debug.bind(console,`[${e}]`)};function makeColumnSelection(e){const{iterateObject:t}=shmi.requires("visuals.tools.iterate"),n=["username"];return t({"show-last-name":"lastName","show-first-name":"firstName","show-user-groups":"userGroups","show-password-validity":"passwordValidityDuration","show-auto-logout-delay":"autoLogoutDelay","show-locale":"localeId","show-description":"description","show-fake-password":"fakePassword"},((t,s)=>{e[s]&&n.push(t)})),(e["column-order"]||s["column-order"]).filter((e=>n.includes(e)))}const a={className:e,uiType:t,isContainer:!0,config:s,configSchema:null,vars:{dataGridId:null,dataGrid:null,currentUser:null,listeners:[]},imports:{dgm:"visuals.session.DataGridManager"},events:["change"],prototypeExtensions:{onInit:function onInit(){const{makeUserListConfig:t}=shmi.requires("visuals.controls.iq-user-list"),{DataGridUser:s}=shmi.requires("visuals.controls.iq-user-management"),a=shmi.getUiElement("table-anchor",this.element);do{this.vars.dataGridId=e+"-"+Math.random().toString(36).substr(2,9)}while(null!==this.imports.dgm.getGrid(this.vars.dataGridId));const l=new s(this.vars.dataGridId,{hideAdmin:!!this.config["hide-admin"]});this.imports.dgm.grids[this.vars.dataGridId]=l,this.vars.dataGrid=l,a?(a.removeAttribute("data-ui"),this.vars.ct=shmi.createControl("complex-table2",a,t(l,makeColumnSelection(this.config)),null,"from")):(n.warn("No table anchor found, inserting table directly into base-element"),this.vars.ct=shmi.createControl("complex-table2",this.element,t(l,makeColumnSelection(this.config)))),null===this.vars.ct&&(this.element.textContent="Unable to create complex-table widget for users. This control will not work.",n.error("Unable to create complex-table widget for users."))},onEnable:function onEnable(){this.vars.ct&&(this.vars.ct.enable(),this.vars.listeners.push(this.vars.ct.listen("select",(e=>{1!==e.detail.type&&2!==e.detail.type||1!==e.detail.selRowIndex.length?this.vars.currentUser=null:this.vars.currentUser=e.detail.selRowIndex[0][0],this.fire("change",{value:this.vars.currentUser},this,!0)}))))},onLock:function onLock(){this.vars.ct&&this.vars.ct.lock()},onUnlock:function onUnlock(){this.vars.ct&&this.vars.ct.unlock()},onDisable:function onDisable(){this.vars.listeners.forEach((e=>e.unlisten())),this.vars.listeners=[],this.vars.ct&&this.vars.ct.disable()},onDelete:function onDelete(){this.vars.dataGridId&&delete this.imports.dgm.grids[this.vars.dataGridId]},getCurrentUser:function getCurrentUser(){return this.vars.currentUser},refresh:function refresh(){this.vars.dataGrid&&this.vars.dataGrid.refresh()}}};shmi.requires("visuals.tools.control-generator").generate(a)}(),function(){"use strict";const e="IqUserSelect",t="iq-user-select",s={"class-name":t,name:null,template:"default/iq-user-select.iq-variant-01",label:t,"show-icon":!1,"icon-src":null,"icon-class":null,tooltip:null,"show-results":"always","hide-admin":!1},n={error:console.error.bind(console,`[${e}]`),warn:console.warn.bind(console,`[${e}]`),log:console.log.bind(console,`[${e}]`),debug:console.debug.bind(console,`[${e}]`)};function eventProxy(e,t){const s=e.vars.searchbar.getMatchData();null!==s&&s.username===t.detail.value?e.fire(t.type,t.detail):e.fire(t.type,{detail:null})}const a={className:e,uiType:t,isContainer:!0,config:s,configSchema:null,vars:{domChild:null,dataGridId:null,dataGrid:null,searchbar:null,eventProxy:null},imports:{dgm:"visuals.session.DataGridManager"},events:["change"],prototypeExtensions:{onInit:function onInit(){const{DataGridUser:s}=shmi.requires("visuals.controls.iq-user-management");if(this.vars.domChild=shmi.getUiElement("user-select-searchbar",this.element),null===this.vars.domChild)return this.element.textContent="One or more required DOM elements are missing from the template. This widget will not work. Please select a compatible template.",void n.error("Some DOM elements are missing from the template.");do{this.vars.dataGridId=e+"-"+Math.random().toString(36).substr(2,9)}while(null!==this.imports.dgm.getGrid(this.vars.dataGridId));this.imports.dgm.grids[this.vars.dataGridId]=this.vars.dataGrid=new s(this.vars.dataGridId,{hideAdmin:!!this.config["hide-admin"]}),this.vars.dataGrid.init();const a={template:this.config.template.replace(t,"iq-searchbar"),"class-name":this.config["class-name"].split(" ").map((e=>e===t?"iq-searchbar":e)).join(" "),label:this.config.label,"show-icon":this.config["show-icon"],"icon-src":this.config["icon-src"],"icon-class":this.config["icon-class"],datagrid:this.vars.dataGridId,"search-column":"username","show-results":this.config["show-results"],"result-columns":["username","userGroups"]};this.vars.searchbar=shmi.createControl("iq-searchbar",this.vars.domChild,a),null===this.vars.searchbar&&(this.element.textContent="Unable to create searchbar widget for users. This widget will not work.",n.error("Unable to create searchbar widget for users."))},getValue:function getValue(){if(this.vars.searchbar){if(null!==this.vars.searchbar.getMatchData())return this.vars.searchbar.getValue()}return null},setValue:function setValue(e){this.vars.searchbar&&this.vars.searchbar.setValue(e)},refreshGrid:function refreshGrid(){this.vars.dataGrid&&this.vars.dataGrid.refresh()},onEnable:function onEnable(){this.vars.searchbar&&(this.vars.eventProxy=this.vars.searchbar.listen("change",eventProxy.bind(null,this)),this.vars.searchbar.enable())},onDisable:function onDisable(){this.vars.searchbar&&this.vars.searchbar.disable(),this.vars.eventProxy&&(this.vars.eventProxy.unlisten(),this.vars.eventProxy=null)},onDelete:function onDelete(){this.vars.searchbar&&shmi.deleteControl(this.vars.searchbar),this.vars.dataGrid&&delete this.imports.dgm.grids[this.vars.dataGridId]},onLock:function onLock(){this.vars.searchbar&&this.vars.searchbar.lock()},onUnlock:function onUnlock(){this.vars.searchbar&&this.vars.searchbar.unlock()},getCurrentUser:function getCurrentUser(){return this.getValue()},refresh:function refresh(){this.vars.dataGrid&&this.vars.dataGrid.refresh()}}};shmi.requires("visuals.tools.control-generator").generate(a)}(),shmi.pkg("visuals.controls"),shmi.visuals.controls.LinearGauge=function(e,t){this.element=e,this.config=t||{},shmi.def(this.config,"class-name","linear-gauge"),shmi.def(this.config,"template","default/linear-gauge"),shmi.def(this.config,"name",null),shmi.def(this.config,"label","linear-gauge"),shmi.def(this.config,"min",0),shmi.def(this.config,"max",100),shmi.def(this.config,"step",0),shmi.def(this.config,"type",shmi.c("TYPE_FLOAT")),shmi.def(this.config,"bar-scale-min",0),shmi.def(this.config,"bar-scale-max",1),shmi.def(this.config,"unit-scale",1),shmi.def(this.config,"precision",-1),shmi.def(this.config,"orientation","horizontal"),shmi.def(this.config,"anim-time",300),shmi.def(this.config,"decimal-delimiter","."),shmi.def(this.config,"auto-min",!0),shmi.def(this.config,"auto-max",!0),shmi.def(this.config,"auto-step",!0),shmi.def(this.config,"auto-precision",!0),shmi.def(this.config,"auto-label",!0),shmi.def(this.config,"auto-unit-text",!0),shmi.def(this.config,"auto-type",!0),this.parseAttributes(),this.value=0,this.barScale=0,this.vertical=!1,this.anim=new shmi.visuals.gfx.Animation(this.updateHandle.bind(this)),this.labelElement=null,this.valueElement=null,this.unitElement=null,this.barElement=null,this.baseColor=null,this.colors=[],this._subscriptionTargetId=null,this.active=!1,this.vars={conditional:null},this.startup()},shmi.visuals.controls.LinearGauge.prototype={uiType:"linear-gauge",getClassName:function(){return"LinearGauge"},onInit:function(){if(shmi.requires("visuals.tools.numericValues").initValueSettings(this),this.barElement=shmi.getUiElement("linear-gauge-bar",this.element),this.barElement){if("vertical"===this.config.orientation&&(this.vertical=!0),this.vertical&&shmi.addClass(this.element,"vertical"),this.labelElement=shmi.getUiElement("label",this.element),this.labelElement&&(this.labelElement.textContent=shmi.localize(this.config.label)),this.baseColor=getComputedStyle(this.barElement).backgroundColor,this.valueElement=shmi.getUiElement("linear-gauge-value",this.element),this.valueElement||shmi.log("[LinearGauge] no value element provided",3),this.unitElement=shmi.getUiElement("linear-gauge-unit",this.element),this.unitElement||shmi.log("[LinearGauge] no unit element provided",3),shmi.log("[LinearGauge] -- all elements found --",0),this.config["unit-text"]&&this.unitElement&&(this.unitElement.textContent=shmi.localize(this.config["unit-text"])),this.config["unit-scale"]&&(this.config["unit-scale"]=parseFloat(shmi.localize(this.config["unit-scale"]))),this.config.threshold){for(var e=this.config.threshold.split(";"),t=0;t<e.length;t++)this.colors.push(e[t].split(":"));for(t=0;t<this.colors.length;t++)this.colors[t][0]=parseFloat(this.colors[t][0])}}else shmi.log("[LinearGauge] no bar element provided",3)},onSetValue:function(e){this.value=parseFloat(e),this.draw()},draw:function(){var e=this,t=e.vars.valueSettings,s=t.min,n=t.max;if(shmi.visuals.session.deactivateControls)return e.anim.stop(),void setTimeout(e.draw.bind(e),shmi.c("ACTION_RETRY_TIMEOUT"));shmi.caf(e.requestID),e.requestID=shmi.raf(e.updateText.bind(e)),e.barScale=n===s?e.config["bar-scale-max"]:(e.config["bar-scale-max"]-e.config["bar-scale-min"])*((e.value-s)/(n-s))+e.config["bar-scale-min"],e.barScale>e.config["bar-scale-max"]?e.barScale=e.config["bar-scale-max"]:e.barScale<e.config["bar-scale-min"]&&(e.barScale=e.config["bar-scale-min"]);for(var a=e.baseColor,l=0;l<e.colors.length;l++)e.value>e.colors[l][0]&&(a=e.colors[l][1]);e.barElement.style.backgroundColor=a,e.anim.start(e.barScale,e.config["anim-time"])},updateText:function(){var e=this,t=shmi.requires("visuals.tools.numericValues");e.valueElement&&(e.valueElement.textContent=t.formatOutput(e.value,e))},onSetProperties:function(e,t,s){var n=this;shmi.requires("visuals.tools.numericValues").setProperties(n,arguments),"number"==typeof n.value&&n.draw()},updateHandle:function(e){this.vertical?(this.barElement.style.webkitTransform="scale3d(1, "+e.toFixed(3)+", 1)",this.barElement.style.oTransform="scale3d(1, "+e.toFixed(3)+", 1)",this.barElement.style.msTransform="scale3d(1, "+e.toFixed(3)+", 1)",this.barElement.style.mozTransform="scale3d(1, "+e.toFixed(3)+", 1)",this.barElement.style.transform="scale3d(1, "+e.toFixed(3)+", 1)"):(this.barElement.style.webkitTransform="scale3d("+e.toFixed(3)+", 1, 1)",this.barElement.style.oTransform="scale3d("+e.toFixed(3)+", 1, 1)",this.barElement.style.msTransform="scale3d("+e.toFixed(3)+", 1, 1)",this.barElement.style.mozTransform="scale3d("+e.toFixed(3)+", 1, 1)",this.barElement.style.transform="scale3d("+e.toFixed(3)+", 1, 1)")},onEnable:function(){var e=this;null!==e.vars.conditional?e.vars.conditional.item!==e.config.item&&(e.vars.conditional.item=e.config.item):e.config.item&&(e.vars.conditional=shmi.createConditional(e.element,e.config.item)),e.vars.conditional&&e.vars.conditional.enable(),this.config.item&&(this._subscriptionTargetId=shmi.visuals.session.ItemManager.subscribeItem(this.config.item,this)),shmi.log("[LinearGauge] enabled",1)},onDisable:function(){this.vars.conditional&&this.vars.conditional.disable(),this.anim.stop(),this.config.item&&shmi.visuals.session.ItemManager.unsubscribeItem(this.config.item,this._subscriptionTargetId),shmi.log("[LinearGauge] disabled",1)},setLabel:function(e){var t=this;t.config["auto-label"]&&t.labelElement&&(t.labelElement.textContent=shmi.localize(e))},setUnitText:function(e){var t=this;t.config["auto-unit-text"]&&t.unitElement&&(t.unitElement.textContent=shmi.localize(e))}},shmi.extend(shmi.visuals.controls.LinearGauge,shmi.visuals.core.BaseControl),shmi.pkg("visuals.controls"),shmi.visuals.controls.LinearGauge2=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","linear-gauge2"),shmi.def(this.config,"label","linear-gauge2"),shmi.def(this.config,"unit-text",null),shmi.def(this.config,"template","default/linear-gauge2"),shmi.def(this.config,"name",null),shmi.def(this.config,"min",0),shmi.def(this.config,"max",100),shmi.def(this.config,"precision",-1),shmi.def(this.config,"step",0),shmi.def(this.config,"type",shmi.c("TYPE_FLOAT")),shmi.def(this.config,"bar-scale-min",0),shmi.def(this.config,"bar-scale-max",1),shmi.def(this.config,"unit-scale",1),shmi.def(this.config,"anim-time",250),shmi.def(this.config,"dynamic-anim-time",!0),shmi.def(this.config,"orientation","horizontal"),shmi.def(this.config,"image-margin",6),shmi.def(this.config,"decimal-delimiter","."),shmi.def(this.config,"auto-min",!0),shmi.def(this.config,"auto-max",!0),shmi.def(this.config,"auto-step",!0),shmi.def(this.config,"auto-precision",!0),shmi.def(this.config,"auto-label",!0),shmi.def(this.config,"auto-unit-text",!0),shmi.def(this.config,"auto-type",!0),this.value=0,this.barScale=0,this.vertical=!1,this.anim=new shmi.visuals.gfx.Animation(this.updateHandle.bind(this)),this.valueElement=null,this.unitElement=null,this.barElement=null,this._subscriptionTargetId=null,this.active=!1,this.vars={conditional:null},this.startup()},shmi.visuals.controls.LinearGauge2.prototype={uiType:"linear-gauge2",getClassName:function(){return"LinearGauge2"},onInit:function(){var e=this;shmi.requires("visuals.tools.numericValues").initValueSettings(e),"vertical"===this.config.orientation&&(this.vertical=!0),this.barElement=shmi.getUiElement("bar",this.element),this.barElement?(this.highlightElement=shmi.getUiElement("highlight",this.element),this.highlightElement?(this.vertical&&(this.element.className+=" vertical"),this.valueElement=shmi.getUiElement("value",this.element),this.valueElement?(this.unitElement=shmi.getUiElement("unit-text",this.element),this.unitElement?(this.labelElement=shmi.getUiElement("label",this.element),this.labelElement?this.config.label&&(this.labelElement.textContent=shmi.localize(this.config.label)):shmi.log("[LinearGauge2] no label element provided",1),shmi.log("[LinearGauge2] -- all elements found --",0),this.config["unit-text"]&&(this.unitElement.textContent=shmi.localize(this.config["unit-text"])),this.config["unit-scale"]&&(this.config["unit-scale"]=parseFloat(shmi.localize(this.config["unit-scale"]))),this.resizeHandler=function(){clearTimeout(e.resizeTO),e.resizeTO=setTimeout(e.updateSize.bind(e),shmi.c("ACTION_RETRY_TIMEOUT"))},this.vertical?this.size=parseInt(getComputedStyle(this.barElement).height)-this.config["image-margin"]:this.size=parseInt(getComputedStyle(this.barElement).width)-this.config["image-margin"]):shmi.log("[LinearGauge2] no unit element provided",3)):shmi.log("[LinearGauge2] no value element provided",3)):shmi.log("[LinearGauge2] no highlight element provided",3)):shmi.log("[LinearGauge2] no bar element provided",3)},updateSize:function(){this.active&&(this.vertical?this.size=parseInt(getComputedStyle(this.barElement).height)-this.config["image-margin"]:this.size=parseInt(getComputedStyle(this.barElement).width)-this.config["image-margin"],this.setValue(this.value))},onSetValue:function(e){this.value=parseFloat(e),this.draw()},draw:function(){var e=this.vars.valueSettings,t=e.min,s=e.max;if(shmi.visuals.session.deactivateControls)return this.anim.stop(),void setTimeout(this.draw.bind(this),shmi.c("ACTION_RETRY_TIMEOUT"));shmi.caf(this.requestID),this.requestID=shmi.raf(this.updateText.bind(this)),this.barScale=s===t?this.config["bar-scale-max"]:(this.config["bar-scale-max"]-this.config["bar-scale-min"])*((this.value-t)/(s-t))+this.config["bar-scale-min"],this.barScale>this.config["bar-scale-max"]?this.barScale=this.config["bar-scale-max"]:this.barScale<this.config["bar-scale-min"]&&(this.barScale=this.config["bar-scale-min"]);var n=this.config["anim-time"];if(this.config.item){var a=shmi.visuals.session.ItemManager.items[this.config.item];void 0===a?shmi.log("[RadialCanvas] item '"+this.config.item+"' undefined in manager",1):n=!1===this.config["dynamic-anim-time"]||a.interval>this.config["anim-time"]?this.config["anim-time"]:Math.round(a.interval)}this.anim.start(this.barScale,n)},updateText:function(){var e=this,t=shmi.requires("visuals.tools.numericValues");e.valueElement.textContent=t.formatOutput(e.value,e)},onSetProperties:function(e,t,s){var n=this;shmi.requires("visuals.tools.numericValues").setProperties(n,arguments),"number"==typeof n.value&&n.draw()},updateHandle:function(e){this.vertical?(this.barElement.style.webkitTransform="scale3d(1, "+e.toFixed(3)+", 1)",this.barElement.style.oTransform="scale3d(1, "+e.toFixed(3)+", 1)",this.barElement.style.msTransform="scale3d(1, "+e.toFixed(3)+", 1)",this.barElement.style.mozTransform="scale3d(1, "+e.toFixed(3)+", 1)",this.barElement.style.transform="scale3d(1, "+e.toFixed(3)+", 1)",this.highlightElement.style.webkitTransform="translate3d(0,"+(1-e*this.size).toFixed(3)+"px, 0)",this.highlightElement.style.oTransform="translate3d(0,"+(1-e*this.size).toFixed(3)+"px, 0)",this.highlightElement.style.msTransform="translate3d(0,"+(1-e*this.size).toFixed(3)+"px, 0)",this.highlightElement.style.mozTransform="translate3d(0,"+(1-e*this.size).toFixed(3)+"px, 0)",this.highlightElement.style.transform="translate3d(0,"+(1-e*this.size).toFixed(3)+"px, 0)"):(this.barElement.style.webkitTransform="scale3d("+e.toFixed(3)+", 1, 1)",this.barElement.style.oTransform="scale3d("+e.toFixed(3)+", 1, 1)",this.barElement.style.msTransform="scale3d("+e.toFixed(3)+", 1, 1)",this.barElement.style.mozTransform="scale3d("+e.toFixed(3)+", 1, 1)",this.barElement.style.transform="scale3d("+e.toFixed(3)+", 1, 1)",this.highlightElement.style.webkitTransform="translate3d("+(e*this.size).toFixed(3)+"px, 0, 0)",this.highlightElement.style.oTransform="translate3d("+(e*this.size).toFixed(3)+"px, 0, 0)",this.highlightElement.style.msTransform="translate3d("+(e*this.size).toFixed(3)+"px, 0, 0)",this.highlightElement.style.mozTransform="translate3d("+(e*this.size).toFixed(3)+"px, 0, 0)",this.highlightElement.style.transform="translate3d("+(e*this.size).toFixed(3)+"px, 0, 0)")},onEnable:function(){var e=this;null!==e.vars.conditional?e.vars.conditional.item!==e.config.item&&(e.vars.conditional.item=e.config.item):e.config.item&&(e.vars.conditional=shmi.createConditional(e.element,e.config.item)),e.vars.conditional&&e.vars.conditional.enable(),this.vertical?this.size=parseInt(getComputedStyle(this.barElement).height)-this.config["image-margin"]:this.size=parseInt(getComputedStyle(this.barElement).width)-this.config["image-margin"],this.config.item&&(this._subscriptionTargetId=shmi.visuals.session.ItemManager.subscribeItem(this.config.item,this)),this.resizeListenerAdded||(window.addEventListener("resize",this.resizeHandler,!1),window.addEventListener("visuals-layout-change",this.resizeHandler,!1),this.resizeListenerAdded=!0),shmi.log("[LinearGauge2] enabled",1)},onDisable:function(){this.resizeListenerAdded&&(window.removeEventListener("resize",this.resizeHandler),window.removeEventListener("visuals-layout-change",this.resizeHandler),this.resizeListenerAdded=!1),this.vars.conditional&&this.vars.conditional.disable(),this.anim.stop(),this.config.item&&shmi.visuals.session.ItemManager.unsubscribeItem(this.config.item,this._subscriptionTargetId),shmi.log("[LinearGauge2] disabled",1)},onLock:function(){},onUnlock:function(){},setLabel:function(e){var t=this;t.config["auto-label"]&&t.labelElement&&(t.labelElement.textContent=shmi.localize(e))},setUnitText:function(e){var t=this;t.config["auto-unit-text"]&&t.unitElement&&(t.unitElement.textContent=shmi.localize(e))}},shmi.extend(shmi.visuals.controls.LinearGauge2,shmi.visuals.core.BaseControl),shmi.pkg("visuals.controls"),shmi.visuals.controls.ListBox=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","list-box"),shmi.def(this.config,"template","default/list-box"),shmi.def(this.config,"name",null),shmi.def(this.config,"label","list-box"),shmi.def(this.config,"options",[]),this.active=!1,this.entries=[],this.entryElements=[],this.mouseListener=null,this.touchListener=null,this.selected=-1,this.onSelect=null,this.listElement=null,this.startup()},shmi.visuals.controls.ListBox.prototype={uiType:"list-box",events:["select"],getClassName:function(){return"ListBox"},onInit:function(){var e=this;shmi.log("[ListBox] initializing...",1);var t=shmi.getUiElement("label",this.element);t&&(t.textContent=shmi.localize(this.config.label)),Array.isArray(e.config.options)&&e.config.options.forEach((function(t){e.entries.push(t)})),this.listElement=shmi.getUiElement("list-items",this.element),this.listElement||shmi.notify("[ListBox] template missing 'list-items' element");var s={};s.onClick=function(t,s,n){this.setSelected(n.target),e.fire("select",{value:e.getSelectedEntry()})}.bind(this),this.mouseListener=new shmi.visuals.io.MouseListener(this.listElement,s),this.touchListener=new shmi.visuals.io.TouchListener(this.listElement,s),shmi.log("[ListBox] initialized",1)},onEnable:function(){this.mouseListener.enable(),this.touchListener.enable(),shmi.log("[ListBox] enabled",1)},onDisable:function(){this.mouseListener.disable(),this.touchListener.disable(),shmi.log("[ListBox] disabled",1)},addEntry:function(e){if(this.initialized){var t=document.createElement("div");t.setAttribute("data-ui","list-item"),t.setAttribute("class","list-item"),t.textContent=e,this.entries.push(e),this.entryElements.push(t),this.listElement.appendChild(t),shmi.log("[ListBox] entry added: "+e,1)}else setTimeout(function(){this.addEntry(e)}.bind(this),shmi.c("ACTION_RETRY_TIMEOUT"))},removeEntryByValue:function(e){var t=-1;this.entries.forEach((function(s,n){s.value===e&&(t=n)})),-1!==t&&(this.listElement.removeChild(this.entryElements[t]),this.entries.splice(t,1),this.entryElements.splice(t,1),this.selected===t&&this.setSelectedIndex(-1))},removeEntry:function(e){e===this.selected&&(this.selected=-1),this.listElement.removeChild(this.entryElements[e]),this.entryElements.splice(e,1),this.entries.splice(e,1)},removeAll:function(){for(;this.entries.length;)this.removeEntry(0);this.selected=-1},setSelected:function(e){for(var t=0;t<this.entryElements.length;t++)if(this.entryElements[t]===e){-1!==this.selected&&shmi.removeClass(this.entryElements[this.selected],"selected"),t===this.selected?this.selected=-1:(this.selected=t,shmi.addClass(this.entryElements[t],"selected"));break}this.onSelect&&this.onSelect(this.selected)},setSelectedIndex:function(e){-1!==this.selected&&shmi.removeClass(this.entryElements[this.selected],"selected"),e===this.selected||-1===e?this.selected=-1:(this.selected=e,shmi.addClass(this.entryElements[e],"selected")),this.onSelect&&this.onSelect(this.selected)},getSelectedEntry:function(){return-1===this.selected?null:this.entries[this.selected]},getSelectedIndex:function(){return this.selected},onLock:function(){this.active&&(this.mouseListener.disable(),this.touchListener.disable(),shmi.addClass(this.element,"locked"))},onUnlock:function(){this.active&&(this.mouseListener.enable(),this.touchListener.enable(),shmi.removeClass(this.element,"locked"))},setLabel:function(e){var t=shmi.getUiElement("label",this.element);t&&(t.textContent=shmi.localize(e))}},shmi.extend(shmi.visuals.controls.ListBox,shmi.visuals.core.BaseControl),shmi.visuals.controls.LocalScript=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"url",null),shmi.def(this.config,"name",null),this.run=!1,this.loaded=!1,this.script="",this.startup()},shmi.visuals.controls.LocalScript.prototype={uiType:"local-script",isContainer:!1,getClassName:function(){return"LocalScript"},onInit:function(){if(this.config.url)shmi.loadResource(this.config.url,this._loadCB.bind(this));else if(this.config.module){try{if(this.module=shmi.requires(this.config.module),"function"!=typeof this.module.run)throw new Error("local-script module has no 'run' function: "+this.config.module)}catch(e){this.element.textContent="UNKNOWN_MODULE: "+this.config.module,this.module={run:function(){}}}this.loaded=!0}else console.log("[LocalScript] no script configured")},_loadCB:function(data,failed){failed?console.log("[LocalScript] failed to load script:",this.config.url):(this.script=data,this.loaded=!0,this.active&&(this.run=!0,eval(this.script)))},onEnable:function(){!this.run&&this.loaded&&(this.config.module?this.module.run(this):eval(this.script))},onDisable:function(){this.run=!1}},shmi.extend(shmi.visuals.controls.LocalScript,shmi.visuals.core.BaseControl),function(){shmi.pkg("visuals.controls");const e={"auth-generic":{3:"${login.error.invalid-credentials}",10:"${login.error.not-supported}",11:"${login.error.not-implemented}",14:"${login.error.realm-not-connected}",15:"${login.error.authentication-not-available}",16:"${login.error.internal-error}"},"shmi:connect:api:user":{3:"${login.error.invalid-credentials}"},"shmi:connect:license":{4:"${login.error.too-many-clients}"}};shmi.visuals.controls.Login=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","login"),shmi.def(this.config,"template","default/login"),shmi.def(this.config,"name",null),shmi.def(this.config,"userEntry",'<div data-ui="user" class="user"><div class="userPic"></div><div class="user_detail"><h1 data-ui="user-name"><%= USER %></h1></div></div>'),this.userElement=null,this.passwordElement=null,this.loginButtonElement=null,this.clearButtonElement=null,this.autoLoginButtonElement=null,this.clickCounter=0,/Firefox/.test(navigator.userAgent)?(this.innerWidth=window.innerWidth-1,this.innerHeight=window.innerHeight-1):(this.innerWidth=window.innerWidth,this.innerHeight=window.innerHeight),this.userListContent="",this.startup()},shmi.visuals.controls.Login.prototype={uiType:"login",getClassName:function(){return"Login"},onInit:function(){var e=this,t=shmi.requires("visuals.session");if(!e.element)return void shmi.log("[Login] no base element provided",3);if(e.userElement=shmi.getUiElement("user-field",e.element),!e.userElement)return void shmi.log("[Login] no user-field element provided",3);if(shmi.addClass(e.userElement,"locked"),e.userElement.setAttribute("disabled",!0),e.passwordElement=shmi.getUiElement("password-field",e.element),!e.passwordElement)return void shmi.log("[Login] no password-field element provided",3);if(shmi.addClass(e.passwordElement,"locked"),e.passwordElement.setAttribute("disabled",!0),e.loginButtonElement=shmi.getUiElement("login-button",e.element),!e.loginButtonElement)return void shmi.log("[Login] no login-button element provided",3);if(e.clearButtonElement=shmi.getUiElement("clear-button",e.element),!e.clearButtonElement)return void shmi.log("[Login] no clear-button element provided",3);e.autoLoginButtonElement=shmi.getUiElement("autologin-button",e.element),e.autoLoginButtonElement||shmi.log("[Login] no autologin-button element provided",2),e.statusElement=shmi.getUiElement("status",e.element),e.statusElement&&(e.statusLabelElement=shmi.getUiElement("label",e.statusElement)),e.statusElement&&e.statusLabelElement&&(shmi.addClass(e.statusElement,"connecting"),e.statusLabelElement.textContent="connecting ..."),t.SocketConnection.connect((function(s){0===s?t.UserManager.requestUserList(e.applyUserList.bind(e)):e.statusElement&&e.statusLabelElement?(shmi.removeClass(e.statusElement,"connecting"),shmi.addClass(e.statusElement,"error"),e.statusLabelElement.textContent="connection error"):console.error("[Login] Error establishing WebSocket connection")}));const s=new XMLHttpRequest;s.open("GET",".webiq/preview.png",!0),s.send(),s.onload=function(){200!==s.status&&(document.getElementById("project-image").style.backgroundImage='url("pics/system/controls/login/placeholder.png")')},t.Login=this},onEnable:function(){Array.isArray(this.listeners)&&this.listeners.forEach((function(e){e.enable()}))},onDisable:function(){Array.isArray(this.listeners)&&this.listeners.forEach((function(e){e.disable()}))},applyUserList:function(){var e=this,t=shmi.visuals.session.UserManager.userList,s=shmi.requires("visuals.tools.iterate.iterateObject");e.userListContent="",s(t,(function(t,s){e.userListContent+=shmi.evalString(e.config.userEntry,{USER:s})})),this.userListElement=document.createElement("div"),shmi.addClass(this.userListElement,"hidden"),shmi.addClass(this.userListElement,"user-list");var n=document.createElement("div");n.className="toolArrow";var a=document.createElement("div");a.className="toolTip",a.innerHTML=this.userListContent,this.userListElement.appendChild(n),this.userListElement.appendChild(a),this.userNameInputElement=shmi.getUiElement("user-name-input",this.element),this.userNameInputElement&&this.userNameInputElement.appendChild(this.userListElement);var l=shmi.visuals.session.UserManager,o=null,r=shmi.visuals.session;l.requestAutoLogin((e=>{this.statusElement&&this.statusLabelElement&&(this.statusLabelElement.textContent="connected",shmi.removeClass(this.statusElement,"connecting"),shmi.addClass(this.statusElement,"connected")),e?(shmi.removeClass(this.userElement,"locked"),shmi.removeClass(this.passwordElement,"locked"),this.userElement.removeAttribute("disabled"),this.passwordElement.removeAttribute("disabled"),this.initListeners(),this.loginCallback(e)):this.loginCallback(0)})),r.URLParameters.autoLogin&&((o=new URL(window.location.href)).searchParams.delete("autoLogin"),window.history.replaceState({},document.title,o.toString()))},initListeners:function(){var e=this;this.userElement.addEventListener("focus",function(){shmi.removeClass(this.userListElement,"hidden")}.bind(this)),this.userElement.addEventListener("click",function(){var t=shmi.visuals.session.config;if(t.keyboard&&t.keyboard.enabled&&(this.clickCounter++,this.clickCounter>1)){var s={value:e.userElement.value,"password-input":!1,"select-box-enabled":!0,callback:function(t,s){t&&(e.userElement.value=s)}};shmi.keyboard(s)}}.bind(this)),this.userElement.addEventListener("blur",function(){this.clickOnUserList||shmi.addClass(this.userListElement,"hidden")}.bind(this)),this.passwordElement.addEventListener("focus",(function(){var t=shmi.visuals.session.config;if(t.keyboard&&t.keyboard.enabled){var s={value:e.passwordElement.value,"password-input":!0,"select-box-enabled":!0,callback:function(t,s){t&&(e.passwordElement.value=s)}};shmi.keyboard(s)}}));var t=shmi.getUiElements("user",this.userListElement);Array.isArray(this.listeners)&&this.listeners.forEach((function(e){e.disable()})),this.listeners=[];for(var s=0;s<t.length;s++){var n={};n.onPress=function(){this.clickOnUserList=!0}.bind(this),n.onRelease=function(){this.clickOnUserList=!1}.bind(this),n.onClick=function(e){return this.listeners.push(new shmi.visuals.io.MouseListener(e,n)),this.listeners.push(new shmi.visuals.io.TouchListener(e,n)),function(){var t=shmi.getUiElement("user-name",e);this.userElement.value=t.innerHTML,shmi.log("[Login] username: "+t.innerHTML,1),shmi.raf(function(){shmi.addClass(this.userListElement,"hidden"),this.passwordElement.focus()}.bind(this))}.bind(this)}.bind(this)(t[s])}this.userElement.addEventListener("keypress",function(e){13===e.keyCode&&shmi.raf(function(){this.passwordElement.focus()}.bind(this))}.bind(this)),this.passwordElement.addEventListener("keypress",function(e){13===e.keyCode&&(this.passwordElement.blur(),shmi.raf(function(){shmi.visuals.session.UserManager.requestLogin(this.userElement.value.trim(),this.passwordElement.value,this.loginCallback.bind(this))}.bind(this)))}.bind(this));var a,l={};if(l.onClick=function(){shmi.visuals.session.UserManager.requestLogin(this.userElement.value.trim(),this.passwordElement.value,this.loginCallback.bind(this))}.bind(this),this.listeners.push(new shmi.visuals.io.MouseListener(this.loginButtonElement,l)),this.listeners.push(new shmi.visuals.io.TouchListener(this.loginButtonElement,l)),this.clearButtonElement&&((a={}).onClick=function(){this.userElement.value="",this.passwordElement.value=""}.bind(this),this.listeners.push(new shmi.visuals.io.MouseListener(this.clearButtonElement,a)),this.listeners.push(new shmi.visuals.io.TouchListener(this.clearButtonElement,a))),this.autoLoginButtonElement){var o=shmi.requires("visuals.io"),r=shmi.requires("visuals.session"),c=r.UserManager,u={onClick:function(){c.requestLogin(r.config["auto-login"].user,r.config["auto-login"].password,e.loginCallback.bind(e))}},m=shmi.getUiElement("button-label",this.autoLoginButtonElement);r.config["auto-login"]&&r.config["auto-login"].enabled&&(m&&(m.textContent=shmi.evalString("Login as default user '<%= USER %>'",{USER:r.config["auto-login"].user})),shmi.removeClass(this.autoLoginButtonElement,"hidden"),this.listeners.push(new o.MouseListener(this.autoLoginButtonElement,u)),this.listeners.push(new o.TouchListener(this.autoLoginButtonElement,u)))}!0===this.active&&this.listeners.forEach((function(e){e.enable()}))},loginCallback:function(t){shmi.log("[Login] login-callback called",2);var s=shmi.visuals.session;if(s.UserManager.currentUser&&s.UserManager.currentUser.loggedIn){shmi.log("[Login] login succeeded",1);var n=this;if(document.body.innerHTML="",s.config["show-load-screen"]){var a=shmi.pkg("visuals.session.SysControlConfig.loadingOverlay");this.bgDiv=document.createElement(a.tagName||"DIV"),shmi.addClass(this.bgDiv,a["class-name"]||"loading-box-overlay"),a.template&&shmi.loadResource(shmi.c("TEMPLATE_PATH")+a.template+shmi.c("TEMPLATE_EXT"),(function(e,t){t||(n.bgDiv.innerHTML=e)})),document.body.appendChild(this.bgDiv)}s.AlarmManager.requestAlarmList(),shmi.raf((function(){shmi.loadResource(shmi.evalString(shmi.c("LOCALE_PATH_PATTERN"),{index:s.UserManager.currentUser.locale}),n.loadProject.bind(n))}))}else"Auto-Login credentials exhausted"===t?.message||(shmi.notify(function getLoginErrorReason(t){return t&&"object"==typeof t?e[t.category]?.[t.errc]??null:null}(t)??"${login.error.invalid-credentials}","${V_NOTIFICATION}"),t?.message?shmi.log(`[Login] login failed - ${t.message}`,1):shmi.log("[Login] login failed",1))},loadProject:function(e,t,s){var n=shmi.requires("visuals.session");if(n.locale=n.locale||{},!t){var a=shmi.requires("visuals.tools.iterate.iterateObject");try{a(JSON.parse(e),(function(e,t){n.locale[t]=e}))}catch(e){console.error("[Login] failed to parse locale file:",s,e)}}var l=null;l="string"==typeof n.config.layout?n.config.layout:shmi.c("DEFAULT_LAYOUT_URL"),void 0!==n.URLParameters.layout&&(l=n.URLParameters.layout),n.LayoutURL=l,this.layout_url=l,l.endsWith(".json")?shmi.loadResource(`json/layouts/${l}`,((e,t)=>{const s=shmi.requires("visuals.model");if(t)this.applyProject(null,!0);else try{s.parse(e),this.applyProject(s.getTemplate("root"),!1)}catch(e){console.error("Error parsing app model:",e),this.applyProject(null,!0)}})):shmi.loadResource(l,this.applyProject.bind(this))},applyProject:function(e,t){if(t)return void shmi.log("[Login] could not load project entrypoint.\n"+this.layout_url,3);var s=shmi.visuals.session,n=document.createDocumentFragment(),a=document.createElement("div");for(a.innerHTML=e,n.appendChild(a);n.firstChild.firstChild;)document.body.appendChild(n.firstChild.firstChild);s.ProjectSource=e;let l=shmi.visuals.parser.parseProject();var o=document.getElementById("viewportMeta");o&&o.setAttribute("content",o.getAttribute("content").replace("user-scalable=no","user-scalable=yes")),shmi.waitOnInit(l,(()=>{var e=shmi.requires("visuals.tools.iterate.iterateObject"),t=null;shmi.log("[Login] All controls initialized",2),shmi.visuals.session.startScripts&&"visuals.defaultClient"===shmi.visuals.session.config["session-client"]&&e(shmi.visuals.session.startScripts,(function(e,t){try{shmi.visuals.session.startScripts[t]()}catch(e){shmi.log("[Login] failed to execute start-script '"+t+"': "+e,2)}})),(t=document.createEvent("Event")).initEvent("resize",!0,!0),window.dispatchEvent(t),s.config["show-load-screen"]&&shmi.raf(function(){!1===s.config["load-screen-transition"]?document.body.removeChild(this.bgDiv):(this.bgDiv.style.opacity=0,this.bgDiv.addEventListener("transitionend",function(){document.body.removeChild(this.bgDiv)}.bind(this)),this.bgDiv.addEventListener("webkitTransitionEnd",function(){document.body.removeChild(this.bgDiv)}.bind(this)))}.bind(this)),shmi.fire("parser-ready",{},shmi.visuals.session)}))}},shmi.extend(shmi.visuals.controls.Login,shmi.visuals.core.BaseControl)}(),function(){"use strict";var e="numpad",t={"class-name":e,name:null,template:"default/numpad/numpad-box",label:e,inputLimitMinimumLabel:"${NUMPAD_INPUT_LIMIT_MINIMUM}",inputLimitMaximumLabel:"${NUMPAD_INPUT_LIMIT_MAXIMUM}","initially-visible":!1,"top-level":!1,value:"0","max-chars":10,callback:null,unit:"","decimal-delimiter":".",type:shmi.c("TYPE_FLOAT"),precision:2,min:-100,max:100,"enable-key-codes":[]},s=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),n=(s.fLog,s.log,{add:function(e,t,s,a){e.vars.errTextElem&&t&&s&&(e.vars.messages[t]||(0===Object.keys(e.vars.messages).length&&shmi.addClass(e.vars.errTextElem,"visible"),e.vars.messages[t]=document.createElement("div"),shmi.addClass(e.vars.messages[t],"err-msg-"+t),e.vars.errTextElem.appendChild(e.vars.messages[t]),shmi.addClass(e.vars.messages[t],"fadein"),setTimeout((function(){e.vars.messages[t]&&shmi.removeClass(e.vars.messages[t],"fadein")}),250)),e.vars.messages[t].innerHTML=s,isNaN(Number(a))||setTimeout((function(){n.remove(e,t)}),Number(a)))},remove:function(e,t){e.vars.errTextElem&&t&&e.vars.messages[t]&&(shmi.addClass(e.vars.messages[t],"fadeout"),setTimeout((function(){e.vars.messages[t]&&e.vars.errTextElem.removeChild(e.vars.messages[t]),delete e.vars.messages[t]}),250))},clear:function(e){e.vars.errTextElem&&Object.keys(e.vars.messages).length>0&&(Object.keys(e.vars.messages).forEach((function(t){n.remove(e,t)})),e.vars.messages={},setTimeout((function(){shmi.removeClass(e.vars.errTextElem,"visible"),e.vars.errTextElem.innerHTML=""}),250))}});function value(e,t){return void 0!==t&&(e.config.value=t),validate(e.config.value,e)?shmi.removeClass(e.vars.inputDisplayElement,"error"):shmi.addClass(e.vars.inputDisplayElement,"error"),e.config.value}function validate(e,t){var s,a=new RegExp("[^0-9'"+t.config["decimal-delimiter"]+"-]","i"),l=Number(String(e).replace(t.config["decimal-delimiter"],".")),o="",r=0;if(-1!==e.indexOf(t.config["decimal-delimiter"])&&r++,0===e.indexOf("-")&&r++,t.vars.inputDisplayElement.setAttribute("maxlength",t.config["max-chars"]+r),t.config.type===shmi.c("TYPE_INT")&&!Number.isInteger(l))return o=shmi.localize("${numpad_entered_value_is_not_integer}"),shmi.log("[Numpad] "+o,1),n.remove(t,"no-number"),n.add(t,"no-integer",o),!1;if(isNaN(l))return o=shmi.localize("${numpad_entered_value_is_not_number}"),shmi.log("[Numpad] "+o,1),n.add(t,"no-number",o),n.remove(t,"no-integer"),!1;if(n.remove(t,"no-number"),n.remove(t,"no-integer"),e.match(a))return o=shmi.localize("${numpad_entered_value_invalid}"),shmi.log("[Numpad] "+o,1),n.add(t,"invalid",o),!1;if(n.remove(t,"invalid"),-1!==Number(t.config.precision)&&-1!==e.indexOf(t.config["decimal-delimiter"])){if(void 0!==(s=e.split(t.config["decimal-delimiter"]))[1]&&s[1].length>t.config.precision)return o=shmi.evalString(shmi.localize("${numpad_too_many_digits}"),{precision:t.config.precision}),shmi.log("[Numpad] "+o,1),n.add(t,"exceeded-decimal-digits",o),!1;n.remove(t,"exceeded-decimal-digits")}else n.remove(t,"exceeded-decimal-digits");return"number"==typeof t.config.min&&l<t.config.min?(o=shmi.localize("${numpad_entered_value_too_low}"),shmi.log("[Numpad] "+o,1),n.remove(t,"max-error"),n.add(t,"min-error",o),!1):(n.remove(t,"min-error"),"number"==typeof t.config.max&&l>t.config.max?(o=shmi.localize("${numpad_entered_value_too_large}"),shmi.log("[Numpad] "+o,1),n.remove(t,"min-error"),n.add(t,"max-error",o),!1):(n.remove(t,"max-error"),n.clear(t),!0))}function insertCharIntoString(e,t,s){var a=0;-1!==(t=String(t)).indexOf(s.config["decimal-delimiter"])&&a++,0===t.indexOf("-")&&a++;var l=!1,o=Number(s.config["max-chars"]+a);if(l=t.substr(0,s.vars.inputDisplayElement.selectionStart)+e+t.substr(s.vars.inputDisplayElement.selectionEnd),"0"===t&&e!==s.config["decimal-delimiter"])l=e;else if(o&&l.length>o){var r=shmi.evalString(shmi.localize("${numpad_too_many_characters}"),{maxChars:o-a});return shmi.log("[Numpad] "+r,3),n.add(s,"max-chars",r,3e3),e.length>1?(e=e.substr(0,o-t.length),t.substr(0,s.vars.inputDisplayElement.selectionStart)+e+t.substr(s.vars.inputDisplayElement.selectionEnd)):t}return s.vars.inputDisplayElement.selectionStart=s.vars.inputDisplayElement.selectionEnd,s.vars.inputDisplayElement.focus(),l}function actionOk(e){validate(value(e),e)&&("function"==typeof e.config.callback&&e.config.callback(Number(value(e).replace(",","."))),e.hide())}function actionClose(e){e.hide()}var a={className:"Numpad",uiType:e,isContainer:!1,config:t,configSchema:null,vars:{titleElement:null,inputLimitMinimum:null,inputLimitMinimumLabel:null,inputLimitMaximum:null,inputLimitMaximumLabel:null,inputDisplayElement:null,errTextElem:null,unitElement:null,buttons:{},buttonsElements:[],containerElement:null,listeners:[]},imports:{im:"visuals.session.ItemManager",qm:function(){return shmi.visuals.session.QueryManager}},events:["open","ok","close"],prototypeExtensions:{onInit:function(){var e=this;e.vars.messages={},e.config.value=String(e.config.value).replace(".",e.config["decimal-delimiter"]),e.vars.keys={number:[48,49,50,51,52,53,54,55,56,57],numpad:[96,97,98,99,100,101,102,103,104,105],arrow:[37,38,39,40],startEndDelete:[35,36,46],decimalDelimiters:[110,188,190],minus:[189,109],plus:[107,187],ctrls:[8,13,17,27],functionKeys:[112,113,114,115,116,117,118,119,120,121,122,123],configKeyCodes:e.config["enable-key-codes"].map((function(e){return Number(e)}))},e.vars.keys.validKey=Array.prototype.concat.apply([],Object.values(e.vars.keys)),e.vars.keys.validNumber=e.vars.keys.number.concat(e.vars.keys.numpad),e.vars.buttons={1:{action:function(t){return insertCharIntoString("1",t,e)}},2:{action:function(t){return insertCharIntoString("2",t,e)}},3:{action:function(t){return insertCharIntoString("3",t,e)}},4:{action:function(t){return insertCharIntoString("4",t,e)}},5:{action:function(t){return insertCharIntoString("5",t,e)}},6:{action:function(t){return insertCharIntoString("6",t,e)}},7:{action:function(t){return insertCharIntoString("7",t,e)}},8:{action:function(t){return insertCharIntoString("8",t,e)}},9:{action:function(t){return insertCharIntoString("9",t,e)}},0:{action:function(t){return"0"===t?"0":insertCharIntoString("0",t,e)}},dot:{action:function(t){return-1!==(t=String(t)).indexOf(e.config["decimal-delimiter"])?t:insertCharIntoString(null===t.match(/\d/)?`0${e.config["decimal-delimiter"]}`:e.config["decimal-delimiter"],t,e)}},backspace:{action:function(t){return t=String(t),e.vars.inputDisplayElement.selectionStart===e.vars.inputDisplayElement.selectionEnd?(0===e.vars.inputDisplayElement.selectionStart&&(e.vars.inputDisplayElement.selectionStart=t.length,e.vars.inputDisplayElement.selectionEnd=t.length),t.substr(0,e.vars.inputDisplayElement.selectionStart-1)+t.substr(e.vars.inputDisplayElement.selectionEnd)):t.substr(0,e.vars.inputDisplayElement.selectionStart)+t.substr(e.vars.inputDisplayElement.selectionEnd)}},plusMinus:{action:function(e){return e=-1!==e.indexOf("-")?String(e).replace("-",""):"-"+String(e)}},close:{action:function(t){return actionClose(e),t}},ok:{action:function(t){return actionOk(e),t}}},e.vars.titleElement=shmi.getUiElement("numpad-title",e.element),e.vars.titleElement||shmi.log("[Numpad] no numpad-title element provided",3),e.vars.errTextElem=shmi.getUiElement("error-message",e.element),e.vars.errTextElem||shmi.log("[Numpad] no error-message element provided",3),e.vars.inputLimitMinimum=shmi.getUiElement("input-limit-minimum",e.element),e.vars.inputLimitMinimum||shmi.log("[Numpad] no input-limit-minimum element provided",3),e.vars.inputLimitMinimumLabel=shmi.getUiElement("input-limit-minimum-label",e.element),e.vars.inputLimitMinimumLabel||shmi.log("[Numpad] no input-limit-minimum-label element provided",3),e.vars.inputLimitMaximum=shmi.getUiElement("input-limit-maximum",e.element),e.vars.inputLimitMaximum||shmi.log("[Numpad] no input-limit-maximum element provided",3),e.vars.inputLimitMaximumLabel=shmi.getUiElement("input-limit-maximum-label",e.element),e.vars.inputLimitMaximumLabel||shmi.log("[Numpad] no input-limit-maximum-label element provided",3),e.vars.frameElement=shmi.getUiElement("numpad-frame",e.element),e.vars.frameElement||shmi.log("[Numpad] no numpad-frame element provided",3),e.vars.inputDisplayElement=shmi.getUiElement("numpad-input-display",e.element),e.vars.inputDisplayElement?e.vars.inputDisplayElement.setAttribute("maxlength",e.config["max-chars"]):shmi.log("[Numpad] no numpad-input-display element provided",3),e.vars.unitElement=shmi.getUiElement("numpad-unit",e.element),e.vars.unitElement||shmi.log("[Numpad] no numpad-unit element provided",3),Object.keys(e.vars.buttons).forEach((function(t){var s="numpad-button-"+t;e.vars.buttonsElements[t]=shmi.getUiElement(s,e.element),e.vars.buttonsElements[t]?(e.vars.buttonsElements[t].value=t,e.vars.buttonsElements[t].setAttribute("tabindex","1")):shmi.log(shmi.evalString(shmi.localize("[Numpad] no <%= elId %> element provided!"),{elId:s}),3)})),e.vars.visible=e.config["initially-visible"],e.vars.visible&&shmi.addClass(e.element,"open"),e.vars.containerElement=shmi.getUiElement("numpad-content",e.element),e.vars.containerElement||shmi.log("[Numpad] no numpad-content element provided",3),e.vars.titleElement&&e.config.label&&(e.vars.titleElement.textContent=shmi.localize(e.config.label)),e.vars.inputLimitMinimum&&"number"==typeof e.config.min&&(e.vars.inputLimitMinimum.textContent=e.config.min),e.vars.inputLimitMinimumLabel&&e.config.inputLimitMinimumLabel&&(e.vars.inputLimitMinimumLabel.textContent=shmi.localize(e.config.inputLimitMinimumLabel)),e.vars.inputLimitMaximum&&"number"==typeof e.config.max&&(e.vars.inputLimitMaximum.textContent=e.config.max),e.vars.inputLimitMaximumLabel&&e.config.inputLimitMaximumLabel&&(e.vars.inputLimitMaximumLabel.textContent=shmi.localize(e.config.inputLimitMaximumLabel)),e.vars.unitElement&&(e.config.unit&&"unit"!==e.config.unit?e.vars.unitElement.textContent="number"==typeof e.config.unit?e.config.unit:shmi.localize(e.config.unit):shmi.addClass(e.vars.unitElement,"hidden")),e.vars.inputDisplayElement&&(value(e)&&(e.vars.inputDisplayElement.value=String(value(e)).replace(".",e.config["decimal-delimiter"])),e.vars.inputDisplayElement.onkeyup=function(t){"Enter"===t.key?actionOk(e):"Escape"===t.key?actionClose(e):value(e,e.vars.inputDisplayElement.value)}),e.vars.buttonsElements.close&&(e.vars.buttonsElements.close.textContent=shmi.localize("${cancel}")),e.vars.buttonsElements.ok&&(e.vars.buttonsElements.ok.textContent=shmi.localize("${okay}")),e.vars.buttonsElements.dot&&(e.vars.buttonsElements.dot.textContent=e.config["decimal-delimiter"]);var t=e.vars.inputDisplayElement.className;-1!==t.indexOf("large")||-1!==e.config["class-name"].indexOf("large")?e.vars.size="large":-1!==t.indexOf("small")||-1!==e.config["class-name"].indexOf("small")?e.vars.size="small":e.vars.size="default",e.vars.inputDisplayListener=function(t){if(-1!==e.vars.keys.validKey.indexOf(t.which)){var s=e.vars.inputDisplayElement.value;-1===e.vars.keys.validNumber.indexOf(t.which)||"0"!==s&&"-0"!==s?-1!==e.vars.keys.minus.indexOf(t.which)?(t.preventDefault(),-1===s.indexOf("-")&&(e.vars.inputDisplayElement.value="-"+s)):-1!==e.vars.keys.plus.indexOf(t.which)&&(t.preventDefault(),-1!==s.indexOf("-")&&(e.vars.inputDisplayElement.value=s.replace("-",""))):"0"===s?e.vars.inputDisplayElement.value="":"-0"===s&&(e.vars.inputDisplayElement.value="-")}else t.ctrlKey||t.preventDefault()},e.vars.elementEnterKey=function(t){"Enter"===t.key?actionOk(e):"Escape"===t.key&&actionClose(e)}},show:function(){var e=this;if(e.active){if(!e.vars.visible){if(e.vars.visible=!0,!0===e.config["top-level"]&&document.body.appendChild(e.element),e.config.min&&""!==e.config.min?shmi.removeClass(e.vars.inputLimitMinimumLabel.parentElement,"no-min"):shmi.addClass(e.vars.inputLimitMinimumLabel.parentElement,"no-min"),e.config.max&&""!==e.config.max?shmi.removeClass(e.vars.inputLimitMaximumLabel.parentElement,"no-max"):shmi.addClass(e.vars.inputLimitMaximumLabel.parentElement,"no-max"),e.config["cover-background"])if(e.vars.bgDiv)shmi.removeClass(e.vars.bgDiv,"hidden");else{e.vars.bgDiv=document.createElement("div"),shmi.addClass(e.vars.bgDiv,"numpad-overlay"),e.vars.bgDiv.setAttribute("tabindex","-1"),document.body.appendChild(e.vars.bgDiv),shmi.removeClass(e.vars.bgDiv,"hidden");var t={onPress:function(){document.activeElement.blur()}};shmi.visuals.io.TouchListener(e.vars.bgDiv,t)}shmi.addClass(e.element,"open"),setTimeout((function(){e.vars.inputDisplayElement.focus(),e.fire("open",{})}),shmi.c("DECOUPLE_TIMEOUT")),e.vars.inputDisplayElement.selectionStart=0,e.vars.inputDisplayElement.selectionEnd=e.vars.inputDisplayElement.value.length}}else shmi.log("[Numpad] cannot show numpad without enabling it first",3)},hide:function(){var e=this;e.vars.visible&&(e.vars.visible=!1,shmi.removeClass(e.element,"open"),e.config["cover-background"]&&e.vars.bgDiv&&shmi.addClass(e.vars.bgDiv,"hidden"),e.fire("close",{}))},onEnable:function(){var e,t,s=this,n={};n.onPress=function(e,t,n){n.preventDefault();var a=n.target;shmi.addClass(s.element,"pressed"),document.activeElement!==s.element&&s.element.focus(),shmi.log("[Numpad] pressed",1),function onNumpadAction(e,t){var s;void 0!==e&&void 0!==t.vars.buttonsElements[e]&&(s=t.vars.buttons[e].action(value(t)),t.vars.inputDisplayElement.value=value(t,s))}(a.value,s),s.vars.inputDisplayElement.focus()},n.onRelease=function(){shmi.removeClass(s.element,"pressed"),shmi.log("[Numpad] released",1)},e=new shmi.visuals.io.MouseListener(s.vars.containerElement,n),t=new shmi.visuals.io.TouchListener(s.vars.containerElement,n,!0),s.vars.listeners.push(e,t),s.element.setAttribute("tabindex","1"),s.element.addEventListener("keydown",s.vars.elementEnterKey),s.vars.inputDisplayElement.addEventListener("keydown",s.vars.inputDisplayListener),s.vars.listeners.forEach((function(e){e.enable()})),shmi.log("[Numpad] enabled",1)},onDisable:function(){var e=this;e.hide(),e.vars.listeners.forEach((function(e){e.disable()})),e.vars.elementEnterKey&&e.element.removeEventListener("keydown",e.vars.elementEnterKey),e.vars.inputDisplayElement&&e.vars.inputDisplayElement.removeEventListener("keydown",e.vars.inputDisplayListener),e.vars.bgDiv&&(e.vars.bgDiv.parentNode.removeChild(e.vars.bgDiv),e.vars.bgDiv=null),shmi.log("[Numpad] disabled",1)},onLock:function(){this.vars.listeners.forEach((function(e){e.disable()}))},onUnlock:function(){this.vars.listeners.forEach((function(e){e.enable()}))},onSetValue:function(e,t,s){},onSetProperties:function(e,t,s){}}};shmi.requires("visuals.tools.control-generator").generate(a)}(),shmi.pkg("visuals.controls"),shmi.visuals.controls.Panel=function(e,t){shmi.requires("visuals.controls.View"),shmi.requires("visuals.controls.panel.PanelIndicator"),shmi.requires("visuals.gfx.Animation"),shmi.requires("visuals.gfx.Movable"),shmi.requires("visuals.io.MouseListener"),shmi.requires("visuals.io.TouchListener"),this.element=e,this.configName=this.element.getAttribute("data-config-name"),this.config=3===arguments.length?arguments[2]||{}:t||{},this.parseAttributes(),shmi.def(this.config,"class-name","panel"),shmi.def(this.config,"name",null),shmi.def(this.config,"show-indicator",!1),shmi.def(this.config,"disable-swipe",!1),shmi.def(this.config,"anim-duration",250),shmi.def(this.config,"item",null),shmi.def(this.config,"animate",!1),shmi.def(this.config,"initial-view",0),this.config.animate="true"===this.config.animate||!0===this.config.animate,this.viewElements=[],this.controls=[],this.subpanels=[],this.history=[],this.currentView=0,this.nextView=0,this.initialized=!1,this._dragging=!1,this.anim=new shmi.visuals.gfx.Animation(this.updatePosition.bind(this),this.updateVisibility.bind(this),"ease_out"),this.anim.priority=!0,this.clientWidth=null,this.clientHeight=null,this.ignoreResize=!1,this.resizeTO=0,this.resizeObserver=null,this.active=!1,this.startup()},shmi.visuals.controls.Panel.prototype={uiType:"panel",isContainer:!0,events:["navigate"],getClassName:function(){return"Panel"},onRegister:function(e){var t=this;"true"===t.config["show-indicator"]?t.config["show-indicator"]=!0:"false"===t.config["show-indicator"]&&(t.config["show-indicator"]=!1),"true"===t.config["disable-swipe"]?t.config["disable-swipe"]=!0:"false"===t.config["disable-swipe"]&&(t.config["disable-swipe"]=!1),t.contentDiv=document.createElement("div"),t.element.appendChild(t.contentDiv),function initializeViews(e){for(var t=shmi.getUiElements("view",e.element),s=0;s<t.length;s++)t[s].parentNode===e.element&&(t[s].setAttribute("tabindex","-1"),e.viewElements.push(t[s]));for(e.clientWidth=e.element.clientWidth,e.clientHeight=e.element.clientHeight,e.contentDiv.style.width=e.clientWidth*e.viewElements.length+"px",e.contentDiv.style.height="100%",e.contentDiv.style.position="relative",e.viewWidth=e.clientWidth,s=0;s<e.viewElements.length;s++){var n=document.createElement("div");n.style.width=e.clientWidth+"px",n.style.height="100%",n.style.cssFloat="left",n.appendChild(e.viewElements[s]),e.contentDiv.appendChild(n)}}(t),t.parseChildren(t.contentDiv,e)},onInit:function(){var e=this;if(this.mover=new shmi.visuals.gfx.Movable(this.contentDiv),this.mover.rotatable=!1,this.mover.scalable=!1,this.mover.priority=!0,this.resizeObserver=new ResizeObserver((()=>{e.ignoreResize||(clearTimeout(e.resizeTO),e.resizeTO=setTimeout((function(){e.updateSize()}),shmi.c("ACTION_RETRY_TIMEOUT")))})),!this.config["disable-swipe"]){var t={};t.onDrag=function(e,t,s){var n=Math.abs(t);Math.abs(e)>n&&(s.preventDefault(),this.mover.tx+e<-this.clientWidth*(this.viewElements.length-1)||this.mover.tx+e>0?this.mover.translate(e/5,0):this.mover.translate(e,0),this._dragging||(this._dragging=!0,document.activeElement!==document.body&&document.activeElement.blur(),this.showNeighbors()))}.bind(this),t.onPress=function(){if(this.updateSize(),this.mover.setTransition(!1),document.activeElement!==document.body)try{document.activeElement.blur()}catch(e){}}.bind(this),t.onRelease=function(){if(this._dragging){this._dragging=!1;var t=this.currentView,s=this.currentView,n=this.currentView*this.viewWidth+this.mover.tx;n>.2*this.viewWidth?s=this.currentView-1:n<-.2*this.viewWidth&&(s=this.currentView+1),s>=0&&s<this.viewElements.length&&(this.currentView!==s&&(this.nextView=s,this.history.push(this.currentView)),this.currentView=s,this.config.item&&shmi.visuals.session.ItemManager.writeValue(this.config.item,s),!this.navInited&&this.config["nav-name"]&&(this.navInited=!0,this.nav=shmi.getControlByName(this.config["nav-name"])),this.nav&&this.nav.setActive(this.currentView));var a=-1*this.currentView*this.viewWidth,l=this.controls[this.currentView],o={index:this.currentView,old_index:t};e.isActive()&&(e.controls[t]&&e.controls[t].isActive()&&e.controls[t].disable(),l.enable(),this.fire("navigate",o)),this.anim.setCurrentValue(this.mover.tx),this.anim.start(a,this.config["anim-duration"])}}.bind(this),this.mouseListener=new shmi.visuals.io.MouseListener(this.contentDiv,t),this.touchListener=new shmi.visuals.io.TouchListener(this.contentDiv,t),this.touchListener.prevent_drag_scroll_y=!1}this.config["show-indicator"]&&(this.indicator=new shmi.visuals.controls.panel.PanelIndicator(this),shmi.addClass(this.element,"show-indicator")),this.updateVisibility(),e.viewElements.length>e.config["initial-view"]&&e.currentView===e.nextView&&e.setView(e.config["initial-view"]),shmi.log("[Panel] "+this.config.name+" created",shmi.c("LOG_INFO"))},updateVisibility:function(){shmi.log("[Panel] update visibility -  start",shmi.c("LOG_DEBUG"));for(var e=0;e<this.viewElements.length&&e<this.controls.length;e++)e!==this.currentView?shmi.addClass(this.viewElements[e],"hidden"):shmi.removeClass(this.viewElements[e],"hidden");this.config["show-indicator"]&&(this.indicator.setSelected(this.currentView),this.indicator.refresh()),shmi.log("[Panel] update visibility -  end",shmi.c("LOG_DEBUG"))},updatePosition:function(e){this.mover.tx=e,this.mover.draw()},transitionComplete:function(){this.updateVisibility()},showNeighbors:function(){this.currentView-1>=0&&shmi.removeClass(this.viewElements[this.currentView-1],"hidden"),this.currentView+1<this.viewElements.length&&shmi.removeClass(this.viewElements[this.currentView+1],"hidden")},setView:function(e){var t=this;if((e<0||e>=this.viewElements.length)&&(e=0),e!==Number(this.currentView)&&(this.nextView=e,this.initialized)){this.backPushed?this.backPushed=!1:this.history.push(this.currentView);var s=this.currentView;this.currentView=e,this.config.item&&shmi.visuals.session.ItemManager.writeValue(this.config.item,e);var n=this.controls[e],a={index:e,old_index:s};shmi.removeClass(this.viewElements[this.currentView],"hidden"),t.isActive()&&(t.controls[s]&&t.controls[s].isActive()&&t.controls[s].disable(),n.enable(),this.fire("navigate",a));var l=-1*this.currentView*this.viewWidth;this.anim.setCurrentValue(this.mover.tx),!0===this.config.animate?this.anim.start(l,this.config["anim-duration"]):this.anim.start(l,0),shmi.log("[Panel '"+this.config.name+"'] view "+e+" set",shmi.c("LOG_INFO"))}},back:function(){this.history.length>0?(this.backPushed=!0,this.setView(this.history.pop())):shmi.log("[Panel] history is empty, cannot go back",shmi.c("LOG_INFO"))},onEnable:function(){const e=this;e.indicator&&(e.indicator.updateWidth(),e.indicator.refresh()),e.updateSize(),e.resizeObserver.observe(e.element),!e.config["disable-swipe"]&&e.mouseListener&&e.touchListener&&(e.mouseListener.enable(),e.touchListener.enable()),e.config.item&&(e._subscriptionTargetId=shmi.visuals.session.ItemManager.subscribeItem(e.config.item,e)),e.currentView!==e.nextView?e.setView(e.nextView):e.controls[e.currentView]&&e.controls[e.currentView].enable()},onDisable:function(){void 0!==this.controls[this.currentView]&&this.controls[this.currentView].disable(),!this.config["disable-swipe"]&&this.mouseListener&&this.touchListener&&(this.mouseListener.disable(),this.touchListener.disable()),this.config.item&&shmi.visuals.session.ItemManager.unsubscribeItem(this.config.item,this._subscriptionTargetId),this.resizeObserver.unobserve(this.element),this.anim.stop()},onLock:function(){var e=this;!e.config["disable-swipe"]&&e.mouseListener&&e.touchListener&&(this.mouseListener.disable(),this.touchListener.disable()),e.indicator&&e.indicator.lock(),e.controls.forEach((function(e){e.lock()}))},onUnlock:function(){var e=this;!e.config["disable-swipe"]&&e.mouseListener&&e.touchListener&&e.active&&(e.mouseListener.enable(),e.touchListener.enable()),e.indicator&&e.active&&e.indicator.unlock(),e.controls.forEach((function(e){e.unlock()}))},onSetValue:function(e){shmi.isDesignerEditor()||(e=parseInt(e),isNaN(e)||this.setView(e))},updateSize:function(){var e=this;if(e.active&&(shmi.log("[Panel] resizing panel...",shmi.c("LOG_DEBUG")),e.clientWidth=e.element.clientWidth,e.clientHeight=e.element.clientHeight,e.contentDiv)){e.contentDiv.style.width=e.clientWidth*e.viewElements.length+"px",e.contentDiv.style.height="100%",e.viewWidth=e.clientWidth;for(var t=0;t<e.viewElements.length;t++){var s=e.viewElements[t].parentNode;s.style.width=e.clientWidth+"px",s.style.height="100%"}var n=-1*e.currentView*e.viewWidth;e.anim.setCurrentValue(n),e.updateVisibility(),e.updatePosition(n),function notifyResize(e){const t=document.createEvent("Event");e.ignoreResize=!0,t.initEvent("resize",!0,!0),window.dispatchEvent(t),e.ignoreResize=!1}(e)}},onDelete:function(){this.anim.stop()},onAddControl:function(e,t){var s=this,n=shmi.requires("visuals.tools.controller"),a=[],l=null;if(!s.initialized)throw new Error("Control not initialized yet.");Array.isArray(e)||(e=[e]),e.some((function(e){return"view"!==e.ui}))?t(new Error("All children must be of type 'view'"),a):(e.forEach((function(e){var t=null,n=document.createElement("div");n.style.width=s.clientWidth+"px",n.style.height="100%",n.style.cssFloat="left",s.contentDiv.appendChild(n),e.config.index=s.controls.length,null!==(t=shmi.createControl(e.ui,n,e.config,"DIV",null,!1))&&(e.style&&"object"==typeof e.style&&shmi.requires("visuals.tools.iterate.iterateObject")(e.style,((e,s)=>{t.element.style[s]=e})),shmi.addClass(t.element,"hidden"),s.viewElements.push(t.element),a.push(t))})),s.updateSize(),(l=shmi.waitOnInit(a,(function(){var o=-1,r=[],c=shmi.requires("visuals.task"),u=[],m=null;l&&(-1!==(o=s._init_.tokens.indexOf(l))&&s._init_.tokens.splice(o,1),l.unlisten(),l=null),e.forEach((function(e,t){var s=null,l=a[t];e.controller&&n.create(e.controller.name,e.controller,l.getName()),Array.isArray(e.children)&&e.children.length&&((s=c.createTask("child control")).run=function(){l.addControl(e.children,(function(e,t){e&&r.push(e),s.complete()}))},u.push(s))})),u.length?((m=c.createTaskList(u,!1)).onComplete=function(){s.controls.length&&s.controls.length===a.length&&s.setView(s.config["initial-view"]),s.indicator&&s.indicator.update(),t(r.length?r[0]:null,a)},m.run()):(s.controls.length&&s.controls.length===a.length&&s.setView(s.config["initial-view"]),s.indicator&&s.indicator.update(),t(r.length?r[0]:null,a))})))&&s._init_.tokens.push(l))}},shmi.extend(shmi.visuals.controls.Panel,shmi.visuals.core.BaseControl),shmi.pkg("visuals.controls.panel"),shmi.visuals.controls.panel.PanelIndicator=function(e){var t=document.createElement("div"),s=document.createElement("div");void 0!==e?(this.panel=e,this.template=document.createElement("div"),t.setAttribute("data-ui","indicator"),t.setAttribute("class","indicator"),s.setAttribute("class","indicator-graphic"),t.appendChild(s),this.template.appendChild(t),this.element=document.createElement("div"),this.element.setAttribute("data-ui","panel-indicator"),this.indicatorElements=[],this.listeners=[],this.selected=0,this.init()):shmi.log("[PanelIndicator] panel not found",3)},shmi.visuals.controls.panel.PanelIndicator.prototype={update:function(){var e=this;e.listeners.forEach((function(e){e.disable()})),e.listeners=[],e.indicatorElements=[],e.element.parentNode===e.panel.element&&e.panel.element.removeChild(e.element),e.element.innerHTML="",e.init(),e.setSelected(e.selected)},init:function(){var e=this;if(e.indicator=shmi.getUiElement("indicator",this.template),e.indicator){e.listeners.forEach((function(e){e.disable()})),e.listeners=[],e.panel.controls.forEach((function(t,s){var n=e.indicator.cloneNode(!0),a=shmi.requires("visuals.io");e.element.appendChild(n),e.indicatorElements.push(n);var l={onClick:function(){e.panel.setView(s)}};e.listeners.push(new a.MouseListener(n,l)),e.listeners.push(new a.TouchListener(n,l)),s===Number(e.panel.currentView)&&(shmi.addClass(n,"active"),e.selected=s)})),e.panel.listen("enable",(function(){e.listeners.forEach((function(e){e.enable()}))})),e.panel.listen("disable",(function(){e.listeners.forEach((function(e){e.disable()}))})),e.panel.active&&e.listeners.forEach((function(e){e.enable()}));var t=document.createElement("div");t.style.clear="both",e.element.appendChild(t),e.panel.element.appendChild(e.element),e.updateWidth()}else shmi.log("[PanelIndicator] indicator element not found in template",3)},updateWidth:function(){shmi.addClass(this.element,"indicator-container")},refresh:function(){},setSelected:function(e){this.selected=Number(e);for(var t=0;t<this.indicatorElements.length;t++)t===e?shmi.addClass(this.indicatorElements[t],"active"):shmi.removeClass(this.indicatorElements[t],"active")},lock:function(){this.listeners.forEach((function(e){e.disable()}))},unlock:function(){this.listeners.forEach((function(e){e.enable()}))}},shmi.pkg("visuals.controls"),shmi.visuals.controls.PopupMenu=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","popup-menu"),shmi.def(this.config,"template","default/popup-menu"),shmi.def(this.config,"name",null),shmi.def(this.config,"content-template",null),shmi.def(this.config,"auto-close",!1),shmi.def(this.config,"tab-limit",!0),"false"===this.config["auto-close"]&&(this.config["auto-close"]=!1),this.controls=[],this.opened=!1,this.locked=!1,this.cls=[],this.listeners=[],this.tokens=[],this.menu_background=null,this.menu_content=null,this.startup()},shmi.visuals.controls.PopupMenu.prototype={uiType:"popup-menu",events:["open","close"],isContainer:!0,getClassName:function(){return"PopupMenu"},onRegister:function(e){var t=this;if(shmi.addClass(t.element,"hidden"),t.menu_background=shmi.getUiElement("menu-background",t.element),t.menu_content=shmi.getUiElement("menu-content",t.element),t.config["content-template"]){var s=0===t.config["content-template"].indexOf(shmi.c("RES_URL_PREFIX"))?t.config["content-template"]:shmi.c("TEMPLATE_PATH")+t.config["content-template"]+shmi.c("TEMPLATE_EXT");shmi.loadResource(s,(function(s,n,a){t.isDeleted()||(!n&&t.menu_content?(t.menu_content.innerHTML=s,t.parseChildren(t.menu_content,e)):e())}))}else t.menu_content?t.parseChildren(t.menu_content,e):e()},onInit:function(){var e=this;if(this.menu_background){var t={onClick:function(t,s,n){e.close()}},s=shmi.visuals.io,n=new s.MouseListener(this.menu_background,t),a=new s.TouchListener(this.menu_background,t);this.listeners.push(n),this.listeners.push(a)}else shmi.notify("${V_MISSING_UI_ELEMENT} 'menu-background'","${V_ERROR}");this.menu_content||shmi.notify("${V_MISSING_UI_ELEMENT} 'menu-content'","${V_ERROR}")},onEnable:function(){for(var e=this,t=0;t<e.listeners.length;t++)e.listeners[t].enable();e.config["auto-close"]&&e.tokens.push(shmi.listen("click",(function(t){t.source&&t.source.element&&shmi.testParentChild(e.element,t.source.element)&&e.close()})))},onDisable:function(){var e=this;e.close();for(var t=0;t<e.listeners.length;t++)e.listeners[t].disable();e.tokens.forEach((function(e){e.unlisten()})),e.tokens=[]},onSetValue:function(){},onLock:function(){this.listeners.forEach((function(e){e.disable()})),this.locked=!0},onUnlock:function(){this.listeners.forEach((function(e){e.enable()})),this.locked=!1},open:function(){var e=this;if(e.active&&!e.opened){if(e.opened=!0,shmi.removeClass(e.element,"hidden"),e.config["tab-limit"]){var t=shmi.requires("visuals.tools.tabulator");e.tabLimit=t.setTabParent(e.element)}for(var s=0;s<e.controls.length;s++)e.controls[s].enable();e.fire("open",{})}},close:function(){if(this.opened){this.opened=!1,shmi.addClass(this.element,"hidden"),this.fire("close",{});for(var e=0;e<this.controls.length;e++)this.tabLimit&&(this.tabLimit.unsetTabParent(),this.tabLimit=null),this.controls[e].disable()}},toggle:function(){var e=this;e.opened?e.close():e.open()},onAddControl:function(e,t){var s=this,n=shmi.requires("visuals.tools.controller"),a=[],l=null;if(!s.initialized)throw new Error("Control not initialized yet.");Array.isArray(e)||(e=[e]),e.forEach((function(e){var t=shmi.createControl(e.ui,s.menu_content,e.config,"DIV",null,!1);if(null!==t){if(e.style&&"object"==typeof e.style){shmi.requires("visuals.tools.iterate.iterateObject")(e.style,((e,s)=>{t.element.style[s]=e}))}a.push(t)}})),(l=shmi.waitOnInit(a,(function(){var o=-1,r=[],c=shmi.requires("visuals.task"),u=[],m=null;l&&(-1!==(o=s._init_.tokens.indexOf(l))&&s._init_.tokens.splice(o,1),l.unlisten(),l=null),e.forEach((function(e,t){var l=null,o=a[t];e.controller&&n.create(e.controller.name,e.controller,o.getName()),s.isActive()&&s.opened&&o.enable(),Array.isArray(e.children)&&e.children.length&&((l=c.createTask("child control")).run=function(){o.addControl(e.children,(function(e,t){e&&r.push(e),l.complete()}))},u.push(l))})),u.length?((m=c.createTaskList(u,!1)).onComplete=function(){t(r.length?r[0]:null,a)},m.run()):t(r.length?r[0]:null,a)})))&&s._init_.tokens.push(l)}},shmi.visuals.session.userActions=shmi.visuals.session.userActions||{},shmi.visuals.session.userActions["popup-menu"]=function(e,t,s,n,a){var l;if(e.length<2)shmi.log("[UserAction] popup-menu - needs two parameters",2);else if(l=3===e.length&&"relative"===e[2]?shmi.ctrl(e[0],a):shmi.ctrl(e[0]))try{"open"===e[1]?(l.open(),shmi.log("[UserAction] popup-menu - opened",2)):"close"===e[1]?(l.close(),shmi.log("[UserAction] popup-menu - closed",2)):"toggle"===e[1]&&(l.toggle(),shmi.log("[UserAction] popup-menu - toggled",2))}catch(e){shmi.log("[UserAction] exception opening / closing popup-menu: "+e,2)}else shmi.log("[UserAction] popup-menu - no element found by name '"+e[0]+"'",2)},shmi.extend(shmi.visuals.controls.PopupMenu,shmi.visuals.core.BaseControl),function(){"use strict";var e="progress-info",t=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),s=t.fLog;t.log;function updateBar(e){var t=calcPercentValue(e.vars.items.baseItem,e.vars.items.comparisonItem);e.vars.elements.barEl.style.width=t+"%"}function formatString(e){var t=e.config.displayFormat,s=formatValue(e,e.vars.items.baseItem),n=formatValue(e,e.vars.items.comparisonItem),a=calcPercentValue(e.vars.items.baseItem,e.vars.items.comparisonItem);return t=(t=(t=t.replace("$baseItem",'<span class="baseValue">'+s+"</span>")).replace("$comparisonItem",'<span class="compareValue">'+n+"</span>")).replace("$percentValue",'<span class="percentValue">'+a+"</span>")}function formatValue(e,t){var s=t;return!0===e.config["auto-precision"]?s=t.toFixed(2):(-1===e.config.precision&&(e.config.precision=0),s=t.toFixed(e.config.precision)),","===e.config["decimal-delimiter"]?s=s.replace(".",e.config["decimal-delimiter"]):"."===e.config["decimal-delimiter"]&&(s=s.replace(",",e.config["decimal-delimiter"])),s}function calcPercentValue(e,t){return 0===t&&0===e?NaN:0===t?1/0:Math.round(e/t*100)}var n={className:"progress-info",uiType:e,isContainer:!1,config:{"class-name":"progress-info",name:null,template:"default/progress-info","decimal-delimiter":".",precision:-1,"auto-precision":!0,baseItem:null,comparisonItem:null,displayFormat:"( $baseItem / $comparisonItem ) $percentValue %",displayOptions:2,barThickness:5},configSchema:null,vars:{listener:[],elements:{textContainerEl:null,barEl:null,barContainerEl:null},handler:{},items:{},subscriberTokens:[]},imports:{im:"visuals.session.ItemManager",io:"visuals.io"},events:[],prototypeExtensions:{onInit:function(){var e=this,t=e.vars.elements,n=e.vars.handler,a=e.imports.im;shmi.getUiElement("progress-info-text",e.element)&&shmi.getUiElement("progress-info-bar-container",e.element)&&shmi.getUiElement("progress-info-bar",e.element)?(t.textContainerEl=shmi.getUiElement("progress-info-text",e.element),t.barContainerEl=shmi.getUiElement("progress-info-bar-container",e.element),t.barEl=shmi.getUiElement("progress-info-bar",e.element),0===e.config.displayOptions?(t.barContainerEl.style.display="none",t.barContainerEl.style.height=0):1===e.config.displayOptions&&(t.textContainerEl.style.display="none",t.textContainerEl.style.height=0),/^[0-9]+$/.test(e.config.barThickness)&&(t.barEl.style.height=e.config.barThickness+"px"),n.baseItemHandler=a.getItemHandler(),n.compItemHandler=a.getItemHandler(),n.baseItemHandler.setValue=function(n){if(e.vars.items.baseItem=n,"number"==typeof e.vars.items.baseItem&&"number"==typeof e.vars.items.comparisonItem)switch(e.config.displayOptions){case 0:t.textContainerEl.innerHTML=formatString(e);break;case 1:updateBar(e);break;case 2:t.textContainerEl.innerHTML=formatString(e),updateBar(e);break;default:s("Invalid option in Display Options!")}else s("Please use a valid integer or float Base-Item and Comparison-Item!")},n.compItemHandler.setValue=function(n){if(e.vars.items.comparisonItem=n,"number"==typeof e.vars.items.baseItem&&"number"==typeof e.vars.items.comparisonItem)switch(e.config.displayOptions){case 0:t.textContainerEl.innerHTML=formatString(e);break;case 1:updateBar(e);break;case 2:t.textContainerEl.innerHTML=formatString(e),updateBar(e);break;default:s("Invalid option in Display Options!")}else s("Please use a valid integer or float Base-Item and Comparison-Item!")}):s('Cannot find the container element! Please make sure that the given template consists at least of a DIV container with the class attribute "progress-info-text", "progress-info-bar-container" and "progress-info-bar".')},onEnable:function(){var e=this,t=e.imports.im,s=e.config,n=e.vars.handler,a=e.vars.subscriberTokens;s.baseItem&&a.push(t.subscribeItem(s.baseItem,n.baseItemHandler)),s.comparisonItem&&a.push(t.subscribeItem(s.comparisonItem,n.compItemHandler))},onDisable:function(){this.vars.subscriberTokens.forEach((function(e){e.unlisten()})),this.vars.subscriberTokens=[]}}};shmi.requires("visuals.tools.control-generator").generate(n)}(),shmi.pkg("visuals.controls"),shmi.visuals.controls.ProjectWindow=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","project-window"),shmi.def(this.config,"template","default/project-window"),shmi.def(this.config,"name",null),shmi.def(this.config,"initial-state","open"),shmi.def(this.config,"label","LABEL"),shmi.def(this.config,"alt-label",null),shmi.def(this.config,"content-template",null),this._open=!1,this.initialized=!1,this.contentTemplate=null,this.contentWrapper=null,this.controls=[],this.listeners=[],this.startup()},shmi.visuals.controls.ProjectWindow.prototype={uiType:"project-window",isContainer:!0,getClassName:function(){return"ProjectWindow"},onRegister:function(e){var t=this;if(t.contentElement=shmi.getUiElement("content",t.element),t.contentWrapper=shmi.getUiElement("content-wrapper",t.element),t.config["content-template"]){var s=0===t.config["content-template"].indexOf(shmi.c("RES_URL_PREFIX"))?t.config["content-template"]:shmi.c("TEMPLATE_PATH")+t.config["content-template"]+shmi.c("TEMPLATE_EXT");shmi.loadResource(s,(function(s,n,a){t.isDeleted()||(!n&&t.contentElement?(t.contentElement.innerHTML=s,t.parseChildren(t.contentElement,e)):e())}))}else t.contentElement?t.parseChildren(t.contentElement,e):e()},onInit:function(){var e=this,t=shmi.getUiElement("label",e.element),s=shmi.getUiElement("header",e.element),n=shmi.getUiElement("label-2",e.element);if(n&&e.config["alt-label"]&&(n.textContent=shmi.localize(e.config["alt-label"])),t&&s){t.textContent=shmi.localize(e.config.label);var a={onClick:function(t,s,n){e._open?e.close():e.open()}},l=shmi.visuals.io,o=new l.MouseListener(s,a),r=new l.TouchListener(s,a);e.listeners.push(o,r)}else t||shmi.notify("[ProjectWindow] template missing 'label' ui-element ("+e.config.template+")","Template Error"),s?shmi.notify("[ProjectWindow] template missing ui-element ("+e.config.template+")","Template Error"):shmi.notify("[ProjectWindow] template missing 'header' ui-element ("+e.config.template+")","Template Error");"open"===e.config["initial-state"]?e.open():shmi.addClass(e.element,"minimized")},open:function(){this._open||(this._open=!0,shmi.removeClass(this.element,"minimized"))},close:function(){this._open&&(this._open=!1,shmi.addClass(this.element,"minimized"))},onEnable:function(){this.listeners.forEach((function(e){e.enable()})),this.controls.forEach((function(e){e.enable()})),shmi.log("[ProjectWindow] enabled",1)},onDisable:function(){this.listeners.forEach((function(e){e.disable()})),this.controls.forEach((function(e){e.disable()})),shmi.log("[ProjectWindow] disabled",1)},onLock:function(){this.listeners.forEach((function(e){e.disable()})),this.controls.forEach((function(e){e.lock()})),this.locked=!0,shmi.addClass(this.element,"locked"),shmi.log("[ProjectWindow] locked",1)},onUnlock:function(){this.listeners.forEach((function(e){e.enable()})),this.controls.forEach((function(e){e.unlock()})),this.locked=!1,shmi.removeClass(this.element,"locked"),shmi.log("[ProjectWindow] locked",1)},onSetValue:function(e){shmi.log("[ProjectWindow] value set: "+e,0)},setLabel:function(e){var t=shmi.getUiElement("label",this.element);t&&(t.textContent=shmi.localize(e))},onAddControl:function(e,t){var s=this,n=shmi.requires("visuals.tools.controller"),a=[],l=null;if(!s.initialized)throw new Error("Control not initialized yet.");Array.isArray(e)||(e=[e]),e.forEach((function(e){var t=shmi.createControl(e.ui,s.contentElement,e.config,"DIV",null,!1);if(null!==t){if(e.style&&"object"==typeof e.style){shmi.requires("visuals.tools.iterate.iterateObject")(e.style,((e,s)=>{t.element.style[s]=e}))}a.push(t)}})),(l=shmi.waitOnInit(a,(function(){var o=-1,r=[],c=shmi.requires("visuals.task"),u=[],m=null;l&&(-1!==(o=s._init_.tokens.indexOf(l))&&s._init_.tokens.splice(o,1),l.unlisten(),l=null),e.forEach((function(e,t){var l=null,o=a[t];e.controller&&n.create(e.controller.name,e.controller,o.getName()),s.isActive()&&o.enable(),Array.isArray(e.children)&&e.children.length&&((l=c.createTask("child control")).run=function(){o.addControl(e.children,(function(e,t){e&&r.push(e),l.complete()}))},u.push(l))})),u.length?((m=c.createTaskList(u,!1)).onComplete=function(){t(r.length?r[0]:null,a)},m.run()):t(r.length?r[0]:null,a)})))&&s._init_.tokens.push(l)}},shmi.extend(shmi.visuals.controls.ProjectWindow,shmi.visuals.core.BaseControl),function(){"use strict";var e="quality-display",t={"class-name":e,name:e,template:"default/quality-display",item:"DSaw1",min:-100,warnMin:-80,preWarnMin:-50,preWarnMax:50,warnMax:80,max:100,"anim-time":300,precision:1,unit:"",label:"Label","display-act-value":!0,"display-set-value":!0,"icon-class":null,"icon-src":null,"auto-min":!0,"auto-max":!0,"auto-precision":!0,"auto-label":!0,"auto-unit":!0},s=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),n=(s.fLog,s.log,{className:"qualityDisplay",uiType:e,isContainer:!1,config:t,configSchema:null,vars:{labelElement:null,avElement:null,unitElement:null,arrowsElement:null,barElement:null,subIdValueItem:null,barMid:null,setCache:null,valCache:null,tokens:[]},imports:{im:"visuals.session.ItemManager"},prototypeExtensions:{onInit:function(){var e=this;if(e.vars.labelElement=shmi.getUiElement("label",e.element),e.vars.avElement=shmi.getUiElement("actual-value",e.element),e.vars.spElement=shmi.getUiElement("set-point-value",e.element),e.vars.unitElement=shmi.getUiElement("actual-value-unit",e.element),e.vars.arrowsElement=shmi.getUiElement("set-value",e.element),e.vars.handleElement=shmi.getUiElement("value-display-handle",e.element),e.vars.valueContainer=shmi.getUiElement("value-display-container",e.element),e.vars.barElement=shmi.getUiElement("deviation",e.element),e.vars.refBar=shmi.getUiElement("ref-bar",e.element),e.vars.anim=new shmi.visuals.gfx.Animation(e.updateBar.bind(e)),e.vars.labelElement&&(e.vars.labelElement.textContent=shmi.localize(e.config.label)),e.vars.unitElement&&(e.vars.unitElement.textContent=shmi.localize(e.config.unit)),(this.config["icon-class"]||this.config["icon-src"])&&(this.iconElement=shmi.getUiElement("icon",this.element),this.iconContainerElement=shmi.getUiElement("icon-container",this.element),this.iconContainerElement.style.display="flex",this.config["icon-class"]&&shmi.addClass(this.iconElement,this.config["icon-class"]),this.config["icon-src"])){var t=document.createElement("img");t.setAttribute("src",this.config["icon-src"]),this.iconElement.appendChild(t),this.config["icon-class"]&&(t.style.display="none")}!1===this.config["display-act-value"]&&e.vars.valueContainer&&(e.vars.valueContainer.style.display="none"),!1===this.config["display-set-value"]&&e.vars.arrowsElement&&(e.vars.arrowsElement.style.display="none"),e.updateArrow(0,100,50),e.updateBar(50)},onEnable:function(){var e=this,t=e.imports.im.getItemHandler();t.setValue=function(t,s,n){var a=t;null!==t&&(e.vars.valCache=t,-1===e.config.precision&&(e.config.precision=0),e.vars.avElement&&(e.vars.avElement.textContent=t.toFixed(e.config.precision)),null!==a&&e.vars.anim.start(a,e.config["anim-time"]))},t.setProperties=function(t,s,n,a,l,o,r,c,u,m){shmi.requires("visuals.tools.numericValues").setProperties(e,arguments),e.vars.valueSettings&&(e.config.min=e.vars.valueSettings.min,e.config.max=e.vars.valueSettings.max,e.config.precision=e.vars.valueSettings.precision),e.config.warnMin=o,e.config.preWarnMin=c,e.config.warnMax=r,e.config.preWarnMax=u,void 0!==e.vars.setCache&&e.updateArrow(e.config.min,e.config.max,e.vars.setCache),void 0!==e.vars.valCache&&null!==e.vars.valCache&&(e.vars.avElement&&(e.vars.avElement.textContent=e.vars.valCache.toFixed(e.config.precision)),e.vars.anim.start(e.vars.valCache,e.config["anim-time"]))},t.setLabel=function(t){e.config["auto-label"]&&e.vars.labelElement&&(e.vars.labelElement.textContent=shmi.localize(t))},t.setUnitText=function(t){e.config["auto-unit"]&&e.vars.unitElement&&(e.vars.unitElement.textContent=shmi.localize(t))},e.config.item&&e.config["value-item"]&&(e.vars.subIdValueItem=e.imports.im.subscribeItem(e.config.item,e),e.vars.tokens.push(e.imports.im.subscribeItem(e.config["value-item"],t)))},onDisable:function(){var e=this;e.vars.subIdValueItem&&(e.vars.subIdValueItem.unlisten(),e.vars.subIdValueItem=null),e.vars.tokens.forEach((function(e){e.unlisten()})),e.vars.tokens=[],e.vars.anim.stop()},setValueElement:function(e){var t=this;-1===t.config.precision&&(t.config.precision=0),t.vars.spElement&&(t.vars.spElement.textContent=e.toFixed(t.config.precision)),t.updateArrow(t.config.min,t.config.max,e),t.vars.setCache=e,void 0!==t.vars.valCache&&t.vars.anim.start(t.vars.valCache,t.config["anim-time"])},onSetProperties:function(e,t,s,n,a,l,o,r,c,u){var m=this;void 0!==m.vars.setCache&&m.updateArrow(m.config.min,m.config.max,m.vars.setCache),void 0!==m.vars.valCache&&null!==m.vars.valCache&&(m.vars.avElement&&(m.vars.avElement.textContent=m.vars.valCache.toFixed(m.config.precision)),m.vars.anim.start(m.vars.valCache,m.config["anim-time"]))},onSetValue:function(e,t,s){this.vars.setValue=e,this.setValueElement(e)},updateBar:function(e){var t=this;if(null!==e&&void 0!==t.vars.setValue){shmi.hasClass(t.element,"preWarn")&&shmi.removeClass(t.element,"preWarn"),shmi.hasClass(t.element,"warn")&&shmi.removeClass(t.element,"warn"),"number"==typeof t.config.preWarnMax&&"number"==typeof t.config.preWarnMin&&(e>t.config.preWarnMax||e<t.config.preWarnMin)&&(shmi.hasClass(t.element,"preWarn")||shmi.addClass(t.element,"preWarn")),"number"==typeof t.config.warnMax&&"number"==typeof t.config.warnMin&&(e>t.config.warnMax||e<t.config.warnMin)&&(shmi.hasClass(t.element,"warn")||shmi.addClass(t.element,"warn")),e>t.config.max&&(e=t.config.max),e<t.config.min&&(e=t.config.min);var s=e-t.vars.setValue,n=t.config.min,a=t.config.max;s=n===a?100:0!==s?s/(a-n)*100:0,t.vars.barElement&&(e-t.vars.setValue<=0?(t.vars.barElement.style.left=null,t.vars.barElement.style.right=100-t.vars.barMid+"%",t.vars.barElement.style.width=Math.abs(s)+"%"):(t.vars.barElement.style.right=null,t.vars.barElement.style.left=t.vars.barMid+"%",t.vars.barElement.style.width=Math.abs(s)+"%"))}},updateArrow:function(e,t,s){var n=this,a=s-e;n.vars.barMid=e===t?100:0!==a?a/(t-e)*100:0,n.vars.handleElement&&(n.vars.handleElement.style.left=n.vars.barMid+"%"),n.vars.arrowsElement&&(n.vars.arrowsElement.style.left=n.vars.barMid+"%")}}});shmi.requires("visuals.tools.control-generator").generate(n)}(),shmi.pkg("visuals.controls"),shmi.pkg("visuals.controls"),shmi.visuals.controls.RadialGauge=function(e,t){this.element=e,this.value=0,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","radial-gauge"),shmi.def(this.config,"template","default/radial-gauge"),shmi.def(this.config,"name",null),shmi.def(this.config,"min",0),shmi.def(this.config,"max",100),shmi.def(this.config,"step",0),shmi.def(this.config,"precision",-1),shmi.def(this.config,"type",shmi.c("TYPE_FLOAT")),shmi.def(this.config,"unit-scale",1),shmi.def(this.config,"min-rotation",-135),shmi.def(this.config,"max-rotation",135),shmi.def(this.config,"anim-time",250),shmi.def(this.config,"label","radial-gauge"),shmi.def(this.config,"unit-text",null),shmi.def(this.config,"decimal-delimiter","."),shmi.def(this.config,"auto-min",!0),shmi.def(this.config,"auto-max",!0),shmi.def(this.config,"auto-step",!0),shmi.def(this.config,"auto-precision",!0),shmi.def(this.config,"auto-type",!0),shmi.def(this.config,"auto-label",!0),shmi.def(this.config,"auto-unit-text",!0),this.labelElement=null,this.valueElement=null,this.unitElement=null,this.handleElement=null,this.requestAnimId=null,this._subscriptionTargetId=null,this.active=!1,this.anim=new shmi.visuals.gfx.Animation(this.updateHandle.bind(this)),this.startup()},shmi.visuals.controls.RadialGauge.prototype={uiType:"radial-gauge",getClassName:function(){return"RadialGauge"},onInit:function(){shmi.requires("visuals.tools.numericValues").initValueSettings(this),this.labelElement=shmi.getUiElement("label",this.element),this.labelElement&&(this.labelElement.textContent=shmi.localize(this.config.label)),this.handleElement=shmi.getUiElement("handle",this.element),this.handleElement?(this.valueElement=shmi.getUiElement("value",this.element),this.valueElement?(this.unitElement=shmi.getUiElement("unit",this.element),this.unitElement?(shmi.log("[RadialGauge] -- all elements found --",0),this.config["unit-text"]&&(this.unitElement.textContent=shmi.localize(this.config["unit-text"])),this.config["unit-scale"]&&(this.config["unit-scale"]=parseFloat(shmi.localize(this.config["unit-scale"])))):shmi.log("[RadialGauge] no unit element provided",3)):shmi.log("[RadialGauge] no value element provided",3)):shmi.log("[RadialGauge] no handle element provided",3)},onSetValue:function(e){this.value=parseFloat(e),this.draw()},draw:function(){var e=this.vars.valueSettings,t=e.min,s=e.max,n=null;if(shmi.visuals.session.deactivateControls)return this.anim.stop(),void setTimeout(this.draw.bind(this),shmi.c("ACTION_RETRY_TIMEOUT"));shmi.caf(this.requestAnimId),this.requestAnimId=shmi.raf(this.updateText.bind(this)),n=s===t?this.config["max-rotation"]:this.config["min-rotation"]+(this.config["max-rotation"]-this.config["min-rotation"])/(s-t)*(this.value-t),this.anim.start(n,this.config["anim-time"])},updateText:function(){var e=this,t=shmi.requires("visuals.tools.numericValues");e.valueElement.textContent=t.formatOutput(e.value,e)},updateHandle:function(e){this.handleElement.style.webkitTransform="rotate3d(0,0,1,"+e.toFixed(3)+"deg)",this.handleElement.style.oTransform="rotate3d(0,0,1,"+e.toFixed(3)+"deg)",this.handleElement.style.msTransform="rotate3d(0,0,1,"+e.toFixed(3)+"deg)",this.handleElement.style.mozTransform="rotate3d(0,0,1,"+e.toFixed(3)+"deg)",this.handleElement.style.transform="rotate3d(0,0,1,"+e.toFixed(3)+"deg)"},onEnable:function(){this.config.item&&(this._subscriptionTargetId=shmi.visuals.session.ItemManager.subscribeItem(this.config.item,this)),shmi.log("[RadialGauge] enabled",1)},onDisable:function(){this.anim.stop(),this.config.item&&shmi.visuals.session.ItemManager.unsubscribeItem(this.config.item,this._subscriptionTargetId),shmi.log("[RadialGauge] disabled",1)},onLock:function(){},onUnlock:function(){},onSetProperties:function(e,t,s){var n=this;shmi.requires("visuals.tools.numericValues").setProperties(n,arguments),"number"==typeof n.value&&n.draw()},setLabel:function(e){var t=this;t.config["auto-label"]&&t.labelElement&&(t.labelElement.textContent=shmi.localize(e))},setUnitText:function(e){var t=this;t.config["auto-unit-text"]&&t.unitElement&&(t.unitElement.textContent=shmi.localize(e))}},shmi.extend(shmi.visuals.controls.RadialGauge,shmi.visuals.core.BaseControl),shmi.pkg("visuals.controls"),shmi.visuals.controls.RadialGauge2=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","radial-gauge2"),shmi.def(this.config,"template","default/radial-gauge2"),shmi.def(this.config,"name",null),shmi.def(this.config,"min",0),shmi.def(this.config,"max",100),shmi.def(this.config,"precision",-1),shmi.def(this.config,"type",shmi.c("TYPE_FLOAT")),shmi.def(this.config,"unit-scale",1),shmi.def(this.config,"min-rotation",0),shmi.def(this.config,"max-rotation",270),shmi.def(this.config,"anim-time",250),shmi.def(this.config,"dynamic-anim-time",!1),shmi.def(this.config,"label","radial-gauge2"),shmi.def(this.config,"unit-text",null),shmi.def(this.config,"decimal-delimiter","."),shmi.def(this.config,"auto-min",!0),shmi.def(this.config,"auto-max",!0),shmi.def(this.config,"auto-step",!0),shmi.def(this.config,"auto-precision",!0),shmi.def(this.config,"auto-type",!0),shmi.def(this.config,"auto-label",!0),shmi.def(this.config,"auto-unit-text",!0),this.value=0,this.valueElement=null,this.unitElement=null,this.handleElement=null,this.labelElement=null,this.requestAnimId=null,this._subscriptionTargetId=null,this.active=!1,this.anim=new shmi.visuals.gfx.Animation(this.updateHandle.bind(this)),this.vars={conditional:null},this.startup()},shmi.visuals.controls.RadialGauge2.prototype={uiType:"radial-gauge2",getClassName:function(){return"RadialGauge2"},onInit:function(){shmi.requires("visuals.tools.numericValues").initValueSettings(this),this.config["anim-time"]=parseInt(this.config["anim-time"]),"true"===this.config["dynamic-anim-time"]?this.config["dynamic-anim-time"]=!0:"false"===this.config["dynamic-anim-time"]&&(this.config["dynamic-anim-time"]=!1),this.handleElement=shmi.getUiElements("handle",this.element),this.handleElement?(this.highlightElement=shmi.getUiElement("highlight",this.element),this.highlightElement?(this.valueElement=shmi.getUiElement("value",this.element),this.valueElement?(this.unitElement=shmi.getUiElement("unit",this.element),this.unitElement?(this.labelElement=shmi.getUiElement("label",this.element),this.labelElement?this.config.label&&(this.labelElement.textContent=shmi.localize(this.config.label)):shmi.log("[RadialGauge2] no label element provided",1),shmi.log("[RadialGauge2] -- all elements found --",0),this.config["unit-text"]&&(this.unitElement.textContent=shmi.localize(this.config["unit-text"])),this.config["unit-scale"]&&(this.config["unit-scale"]=parseFloat(shmi.localize(this.config["unit-scale"])))):shmi.log("[RadialGauge2] no unit element provided",3)):shmi.log("[RadialGauge2] no value element provided",3)):shmi.log("[RadialGauge2] no highlight element provided",3)):shmi.log("[RadialGauge2] no handle element provided",3)},onSetValue:function(e){this.value=parseFloat(e),this.draw()},draw:function(){var e=this.vars.valueSettings,t=e.min,s=e.max,n=null;if(shmi.visuals.session.deactivateControls)return this.anim.stop(),void setTimeout(this.draw.bind(this),shmi.c("ACTION_RETRY_TIMEOUT"));shmi.caf(this.requestAnimId),this.requestAnimId=shmi.raf(this.updateText.bind(this)),n=s===t?this.config["max-rotation"]:this.config["min-rotation"]+(this.config["max-rotation"]-this.config["min-rotation"])/(s-t)*(this.value-t);var a=this.config["anim-time"];if(this.config.item){var l=shmi.visuals.session.ItemManager.items[this.config.item];void 0===l?shmi.log("[RadialCanvas] item '"+this.config.item+"' undefined in manager",1):a=!1===this.config["dynamic-anim-time"]||l.interval>this.config["anim-time"]?this.config["anim-time"]:Math.round(l.interval)}this.anim.start(n,a)},updateText:function(){var e=this,t=shmi.requires("visuals.tools.numericValues");e.valueElement.textContent=t.formatOutput(e.value,e)},updateHandle:function(e){e>270?e=270:e<0&&(e=0);var t=Math.floor(e/90),s=!1;void 0===this.h_stat&&(this.h_stat=[{full:!1},{full:!1},{full:!1}]);for(var n=0;n<this.handleElement.length;n++)if(n<t){if(!0===this.h_stat[n].full)continue;this.handleElement[n].style.webkitTransform="rotate3d(0,0,1,0deg)",this.handleElement[n].style.oTransform="rotate3d(0,0,1,0deg)",this.handleElement[n].style.msTransform="rotate3d(0,0,1,0deg)",this.handleElement[n].style.mozTransform="rotate3d(0,0,1,0deg)",this.handleElement[n].style.transform="rotate3d(0,0,1,0deg)",this.handleElement[n].style.display="block",this.h_stat[n].full=!0}else if(s)this.handleElement[n].style.display="none";else{!0===this.h_stat[n].full&&(this.h_stat[n].full=!1);var a=e%90-90;this.handleElement[n].style.webkitTransform="rotate3d(0,0,1,"+a.toFixed(3)+"deg)",this.handleElement[n].style.oTransform="rotate3d(0,0,1,"+a.toFixed(3)+"deg)",this.handleElement[n].style.msTransform="rotate3d(0,0,1,"+a.toFixed(3)+"deg)",this.handleElement[n].style.mozTransform="rotate3d(0,0,1,"+a.toFixed(3)+"deg)",this.handleElement[n].style.transform="rotate3d(0,0,1,"+a.toFixed(3)+"deg)",this.handleElement[n].style.display="block",s=!0}e-=180,this.highlightElement.style.webkitTransform="rotate3d(0,0,1,"+e.toFixed(3)+"deg)",this.highlightElement.style.oTransform="rotate3d(0,0,1,"+e.toFixed(3)+"deg)",this.highlightElement.style.msTransform="rotate3d(0,0,1,"+e.toFixed(3)+"deg)",this.highlightElement.style.mozTransform="rotate3d(0,0,1,"+e.toFixed(3)+"deg)",this.highlightElement.style.transform="rotate3d(0,0,1,"+e.toFixed(3)+"deg)"},onEnable:function(){var e=this;null!==e.vars.conditional?e.vars.conditional.item!==e.config.item&&(e.vars.conditional.item=e.config.item):e.config.item&&(e.vars.conditional=shmi.createConditional(e.element,e.config.item)),e.vars.conditional&&e.vars.conditional.enable(),this.config.item&&(this._subscriptionTargetId=shmi.visuals.session.ItemManager.subscribeItem(this.config.item,this)),shmi.log("[RadialGauge2] enabled",1)},onDisable:function(){this.anim.stop(),this.vars.conditional&&this.vars.conditional.disable(),this.config.item&&shmi.visuals.session.ItemManager.unsubscribeItem(this.config.item,this._subscriptionTargetId),shmi.log("[RadialGauge2] disabled",1)},onLock:function(){},onUnlock:function(){},onSetProperties:function(e,t){var s=this;shmi.requires("visuals.tools.numericValues").setProperties(s,arguments),"number"==typeof s.value&&s.draw()},setLabel:function(e){var t=this;t.config["auto-label"]&&t.labelElement&&(t.labelElement.textContent=shmi.localize(e))},setUnitText:function(e){var t=this;t.config["auto-unit-text"]&&t.unitElement&&(t.unitElement.textContent=shmi.localize(e))}},shmi.extend(shmi.visuals.controls.RadialGauge2,shmi.visuals.core.BaseControl),function(){"use strict";var e="RecipeController",t="recipe-controller",s={"class-name":e,name:null,template:"default/recipe-controller","recipe-select":null,"recipe-edit":null,"button-order":["add","clone","remove","edit","capture","apply"],"button-usage":{add:!0,clone:!0,remove:!0,edit:!0,capture:!0,apply:!0}},n=shmi.requires("visuals.tools.logging").createLogger(t,!0,!1);n.fLog,n.log;function watchRecipeSelection(e,s){var n=null,a=null;if(e.vars.select.changeToken&&(e.vars.select.changeToken.unlisten(),e.vars.select.changeToken=null),s&&s.isActive()){const l="iq-recipe-list"===e.vars.selectUiType?"select":"change";e.vars.select.changeToken=s.listen(l,(function(t){console.log("recipe selection changed:",t),updateSelection(e,t.source.getValue()),updateButtonState(e)})),e.vars.select.control=s,e.vars.edit.control&&e.vars.edit.control.isActive()&&(n=s.getTemplate(),e.vars.select.selection&&(a=e.vars.select.selection.recipe_id),"number"==typeof n&&e.vars.edit.control.setTemplate(n,a,(function(){console.log(t,"template-ID set")}))),updateSelection(e,s.getValue())}else e.vars.select.control=null,e.vars.select.changeToken&&(e.vars.select.changeToken.unlisten(),e.vars.select.changeToken=null),updateSelection(e,null);updateButtonState(e)}function updateSelection(e,t){var s=e.vars.edit.control;t&&null!==t.recipe_id?(e.vars.select.selection=t,s&&s.editRecipe({mode:s.MODE.EDIT,recipe_id:t.recipe_id,preview:!0})):(e.vars.select.selection=null,s&&s.reset())}function watchRecipeEdit(e,s){var n=shmi.requires("visuals.tools.iterate").iterateObject,a=null,l=null;s&&s.isActive()?(e.vars.edit.control=s,e.vars.select.control&&(a=e.vars.select.control.getTemplate(),e.vars.select.selection&&(l=e.vars.select.selection.recipe_id),"number"==typeof a&&s.setTemplate(a,l,(function(){console.log(t,"template-ID set")}))),e.vars.edit.tokens.push(s.listen("start-edit",(function(){e.vars.select.control&&e.vars.select.control.lock(),n(e.vars.buttons,(function(e,t){e&&e.lock()}))}))),e.vars.edit.tokens.push(s.listen("stop-edit",(function(){e.vars.select.control&&(e.vars.select.control.unlock(),"function"==typeof e.vars.select.control.rebuildTable&&e.vars.select.control.rebuildTable()),updateButtonState(e)})))):(e.vars.edit.control=null,e.vars.edit.tokens.forEach((function(e){e.unlisten()})),e.vars.edit.tokens=[])}function lockButton(e,t){var s=e.vars.buttons;s[t]&&s[t].lock()}function unlockButton(e,t){var s=e.vars.buttons;s[t]&&s[t].unlock()}function updateButtonState(e){var t=e.vars.select.control,s=e.vars.edit.control,n=e.vars.select.selection;e.locked||(t&&n?(n.values_set?unlockButton(e,"apply"):lockButton(e,"apply"),unlockButton(e,"remove"),unlockButton(e,"capture")):(lockButton(e,"apply"),lockButton(e,"remove"),lockButton(e,"capture")),s?(n?(unlockButton(e,"edit"),unlockButton(e,"clone")):(lockButton(e,"edit"),lockButton(e,"clone")),unlockButton(e,"add")):(lockButton(e,"add"),lockButton(e,"edit"),lockButton(e,"clone")))}function doCapture(e,t){e.capture(null,(function(e){e&&shmi.notify("${recipe-controller.error.captureRecipe}","${V_ERROR}",{ERROR_CODE:e.errc,ERROR_MSG:e.message,ERROR_CAT:e.category}),"function"==typeof t&&t(e||null)}))}function fetchRecipe(e,t){shmi.requires("visuals.session.RecipeManager").getRecipe(e,(function(e,s){s?(shmi.notify("${recipe-controller.error.fetchRecipe}","${V_ERROR}",{ERROR_CODE:s.errc,ERROR_MSG:s.message,ERROR_CAT:s.category}),t(null,s)):t(e,null)}))}function attachButtonListeners(e){var t=e.vars.buttons,s=e.vars.tokens;t.add&&s.push(t.add.listen("click",(function(t){var s=shmi.requires("recipe-controller.ls.recipe-name"),n=e.vars.select.control,a=null;n&&"number"==typeof(a=n.getTemplate())&&s.getRecipeName(a,(function(s){"string"==typeof s&&function createRecipe(e,t,s){shmi.requires("visuals.session.RecipeManager").getTemplate(e,(function(e,n){n?(shmi.notify("${recipe-controller.error.fetchTemplate}","${V_ERROR}",{ERROR_CODE:n.errc,ERROR_MSG:n.message,ERROR_CAT:n.category}),s(n)):e.createRecipe(t,{},(function(e,t){t?(shmi.notify("${recipe-controller.error.createRecipe}","${V_ERROR}",{ERROR_CODE:t.errc,ERROR_MSG:t.message,ERROR_CAT:t.category}),s(null,t)):s(e,null)}))}))}(a,s,(function(a,l){l||doCapture(a,(function(o){l||(n.refreshGrid(),n.setValue(s),t.recipe=a,t.type="add",e.fire("change",t))}))}))}))}))),t.edit&&s.push(t.edit.listen("click",(function(t){var s=e.vars.select.selection,n=e.vars.edit.control;n&&s&&n.editRecipe({mode:n.MODE.EDIT,recipe_id:s.recipe_id})}))),t.apply&&s.push(t.apply.listen("click",(function(t){var s=e.vars.select.selection;s&&fetchRecipe(s.recipe_id,(function(s,n){n||("number"!=typeof s.versionId?shmi.notify("${recipe-controller.error.noRecipeValues}","${V_ERROR}"):shmi.confirm("${recipe-controller.confirm.applyRecipe}",(function(n){n&&s.apply((function(n,a){a?shmi.notify("${recipe-controller.error.applyRecipe}","${V_ERROR}",{ERROR_CODE:a.errc,ERROR_MSG:a.message,ERROR_CAT:a.category}):(t.recipe=s,t.type="apply",e.fire("change",t))}))})))}))}))),t.capture&&s.push(t.capture.listen("click",(function(t){var s=e.vars.select.selection;s&&fetchRecipe(s.recipe_id,(function(s,n){n?(t.recipe=s,t.type="capture",e.fire("change",t)):function captureRecipe(e,t){"number"==typeof t.versionId?shmi.confirm("${recipe-controller.confirm.captureRecipe}",(function(s){s&&doCapture(t,(function(t){var s=e.vars.select.control;!t&&s&&s.refreshGrid()}))})):doCapture(t,(function(t){var s=e.vars.select.control;!t&&s&&s.refreshGrid()}))}(e,s)}))}))),t.clone&&s.push(t.clone.listen("click",(function(t){var s=shmi.requires("recipe-controller.ls.recipe-name"),n=e.vars.select.control,a=e.vars.select.selection,l=null;n&&(l=n.getTemplate(),s.getRecipeName(l,(function(s){null!==s&&function cloneRecipe(e,t,s){shmi.requires("visuals.session.RecipeManager").getRecipe(e,(function(e,n){n?(shmi.notify("${recipe-controller.error.fetchRecipe}","${V_ERROR}",{ERROR_CODE:n.errc,ERROR_MSG:n.message,ERROR_CAT:n.category}),s(n)):e.clone(t,(function(e,t){t&&shmi.notify("${recipe-controller.error.cloneRecipe}","${V_ERROR}",{ERROR_CODE:t.errc,ERROR_MSG:t.message,ERROR_CAT:t.category}),s(e,t||null)}))}))}(a.recipe_id,s,(function(a,o){o?(t.templateId=l,t.type="apply",e.fire("change",t),"function"==typeof n.rebuildTable&&n.rebuildTable()):"iq-recipe-list"===n.uiType?(n.rebuildTable(),n.setValue(a.id)):n.setValue(s)}))})))}))),t.remove&&s.push(t.remove.listen("click",(function(t){var s=e.vars.select.selection,n=e.vars.select.control,a=e.vars.edit.control,l=null;s&&shmi.confirm("${recipe-controller.confirm.deleteRecipe}",(function(o){o&&fetchRecipe(s.recipe_id,(function(o,r){r||o.delete((function(r){r?shmi.notify("${recipe-controller.error.deleteRecipe}","${V_ERROR}",{ERROR_CODE:r.errc,ERROR_MSG:r.message,ERROR_CAT:r.category}):(a&&(l=a.getState())&&l.recipe_id===s.recipe_id&&a.reset(),n&&n.setValue(""),"function"==typeof n.rebuildTable&&n.rebuildTable(),t.recipe=o,t.type="del",e.fire("change",t))}))}))}))})))}function nameOrNodeHandleMatches(e,t){const{HANDLE_PREFIX:s,getNodeHandle:n}=shmi.requires("visuals.tools.nodes");return"string"==typeof e&&e.startsWith(s)?n(t)===e.replace(s,""):e===t.getName()}var a={className:e,uiType:t,isContainer:!0,config:s,configSchema:null,vars:{buttons:{add:null,edit:null,remove:null,apply:null,capture:null,clone:null},select:{control:null,changeToken:null,selection:null},edit:{control:null,tokens:[]},tokens:[],eventProxy:null,selectUiType:"recipe-select"},imports:{},events:["change"],prototypeExtensions:{onInit:function(){var e=this,t=e.vars.buttons,s={add:["add-recipe","${recipe-controller.label.add}"],edit:["edit-recipe","${recipe-controller.label.edit}"],remove:["remove-recipe","${recipe-controller.label.remove}"],apply:["apply-recipe","${recipe-controller.label.apply}"],capture:["capture-recipe","${recipe-controller.label.capture}"],clone:["clone-recipe","${recipe-controller.label.clone}"]};Array.isArray(e.config["button-order"])&&e.config["button-order"].forEach((function(n){null===t[n]&&s[n]&&(t[n]=function createControllerButton(e,t,s,n){var a={label:null,"icon-title":null,"class-name":"button icon-only",template:"default/button_with_bg_pic","icon-class":"icon","show-icon":!0,"show-text":!1};return e.config["button-usage"]&&!0!==e.config["button-usage"][n]?null:(a.label=s,a.tooltip=s,a["class-name"]+=" "+t,a.name=t,shmi.createControl("button",e.element,a,"DIV"))}(e,s[n][0],s[n][1],n))}))},onEnable:function(){var e=this,t=null,s=null;e.controls.forEach((function(e){e.enable()})),attachButtonListeners(e),null!==e.config["recipe-select"]&&((t=e.vars.select.control=shmi.ctrl(e.config["recipe-select"]))&&(e.vars.selectUiType=t.uiType),watchRecipeSelection(e,t),e.vars.tokens.push(shmi.listen("enable",(function(s){nameOrNodeHandleMatches(e.config["recipe-select"],s.source)&&(t=e.vars.select.control=s.source,watchRecipeSelection(e,t),updateSelection(e,t.getValue()),updateButtonState(e))}),{"source.uiType":e.vars.selectUiType})),e.vars.tokens.push(shmi.listen("disable",(function(s){nameOrNodeHandleMatches(e.config["recipe-select"],s.source)&&(t=e.vars.select.control=null,watchRecipeSelection(e,t),updateSelection(e,null),updateButtonState(e))}),{"source.uiType":e.vars.selectUiType}))),t&&updateSelection(e,t.getValue()),updateButtonState(e),null!==e.config["recipe-edit"]&&(s=e.vars.edit.control=shmi.ctrl(e.config["recipe-edit"]),watchRecipeEdit(e,s),updateButtonState(e),e.vars.tokens.push(shmi.listen("enable",(function(t){nameOrNodeHandleMatches(e.config["recipe-edit"],t.source)&&(s=e.vars.edit.control=t.source,watchRecipeEdit(e,s),updateButtonState(e))}),{"source.uiType":"recipe-edit"})),e.vars.tokens.push(shmi.listen("disable",(function(t){nameOrNodeHandleMatches(e.config["recipe-edit"],t.source)&&(s=e.vars.edit.control=null,watchRecipeEdit(e,s),updateButtonState(e))}),{"source.uiType":"recipe-edit"})),e.vars.tokens.push(shmi.listen("stop-edit",(function(t){if(nameOrNodeHandleMatches(e.config["recipe-edit"],t.source)){var s=e.vars.select.selection;s&&fetchRecipe(s.recipe_id,(function(s,n){if(!n){let n={type:"edit",recipe:s,cancel:t.detail.cancel};e.fire("change",n)}}))}}),{"source.uiType":"recipe-edit"})))},onDisable:function(){var e=this;e.controls.forEach((function(e){e.disable()})),e.vars.tokens.forEach((function(e){e.unlisten()})),e.vars.tokens=[],e.vars.select.changeToken&&(e.vars.select.changeToken.unlisten(),e.vars.select.changeToken=null),e.vars.edit.tokens.forEach((function(e){e.unlisten()})),e.vars.edit.tokens=[]},onDelete:function(){},onLock:function(){this.controls.forEach((function(e){e.lock()}))},onUnlock:function(){this.controls.forEach((function(e){e.unlock()}))}}},l=shmi.pkg("recipe-controller.ls.recipe-name"),o=null,r=null,c=null;l.run=function run(e){var t=e.parentContainer.getName(),s=[];shmi.onReady({controls:{apply:t+" .apply",name:t+".recipeName"}},(function(t){var n=t.controls.apply,a=t.controls.name;e.isActive()&&(a.setValue(""),s.push(n.listen("click",(function(){var e=a.getValue();"string"==typeof e&&""!==e.trim()&&("function"==typeof o&&o(e),o=null,r&&r.hide())}))))})),e.onDisable=function(){e.run=!1,s.forEach((function(e){e.unlisten()})),s=[]}},l.getRecipeName=function getRecipeName(e,t){var s=null;if("function"==typeof o)throw new Error("Recipe name dialog still in use!");o=t,null===r&&(r=shmi.createControl("dialog-box",document.body,{title:"${recipe-controller.title.nameDialog}",name:"recipeNameDialog","class-name":"dialog-box recipe-name","content-template":"default/recipe-controller/name-dialog","top-level":!0,"tab-limit":!1},"DIV"),c&&(c.unlisten(),c=null),c=r.listen("delete",(function(e){c.unlisten(),c=null,r=null}))),r&&shmi.onActive([r],(function(){r.show(),s=r.listen("close",(function(){s.unlisten(),"function"==typeof o&&o(null),o=null}))}))},shmi.requires("visuals.tools.control-generator").generate(a)}(),function(){"use strict";var e="recipe-edit",t={"class-name":"recipe-edit",name:null,template:"custom/controls/recipe-edit",title:e,viewMode:"linear",editName:!0,itemFetchTimeout:1e4},s=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),n=(s.fLog,s.log,{CREATE:1,EDIT:2,CLONE:3,CAPTURE:4}),a=[null,"${recipe-edit.label.create}","${recipe-edit.label.apply}","${recipe-edit.label.clone}","${recipe-edit.label.create}"];function clearGenerated(e){var t=[],s=e.vars.tokens;e.controls.forEach((function(e){t.push(e)})),t.forEach((function(e){shmi.deleteControl(e,!0)})),s.apply&&(s.apply.unlisten(),s.apply=null),s.cancel&&(s.cancel.unlisten(),s.cancel=null),e.vars.controls={name:null,items:{},meta:{},buttons:{}}}function generateContent(t){!function generateName(e){var t=e.vars.anchors,s=e.vars.controls;s.name=shmi.createControl("input-field",t.name,{label:"${recipe-edit.label.recipeName}",type:shmi.Constants.TYPE_STRING,"auto-type":!1,"class-name":"input-field label-beside"}),!e.config.editName&&s.name&&shmi.addClass(s.name.element,"hidden")}(t),function generateMeta(e){var t=e.vars.anchors,s=e.vars.controls,n=e.vars.recipe;n.meta.forEach((function(n){var a=function getMetaType(e,t){var s=e.vars.recipe,n=shmi.Constants,a={string:n.TYPE_STRING,int:n.TYPE_INT,long:n.TYPE_INT,longlong:n.TYPE_INT,uint:n.TYPE_INT,ulong:n.TYPE_INT,ulonglong:n.TYPE_INT,float:n.TYPE_FLOAT,double:n.TYPE_FLOAT,bool:n.TYPE_BOOL,boolean:n.TYPE_BOOL},l=null;return s.meta.some((function(e){return e.name===t&&(l=e,!0)})),l?a[l.type]:null}(e,n.name);a===shmi.Constants.TYPE_BOOL?s.meta[n.name]=shmi.createControl("checkbox",t.meta,{ui:"checkbox",label:n.label||n.name,"class-name":"checkbox label-beside recipe-bool",template:"default/recipe-edit/bool-checkbox","on-value":!0,"off-value":!1},"DIV"):s.meta[n.name]=shmi.createControl("input-field",t.meta,{label:n.label||n.name,type:a,"auto-type":!1,"value-alignment":"auto","class-name":"input-field label-beside"},"DIV")}))}(t),function generateItems(e){var t=e.vars.anchors,s=e.vars.recipe;"linear"===e.config.viewMode&&s.items.forEach((function(s){generateItemInput(s,t.items,e)}));if("tree"===e.config.viewMode){const t=function buildItemsObject(e){var t={};return e.items.forEach((function(e){var s={};s.raw=e.name.split("."),s.parts=[],s.index=[],s.raw.forEach((function(e,t){(s.index[t]=[],-1!==e.indexOf("["))?(e.substring(e.indexOf("[")).split("[").join("").split("]").forEach((function(e,n){s.index[t][n]=e})),s.parts[t]=e.substring(0,e.indexOf("["))):(s.parts[t]=e,s.index[t][0]="")}));var n={},a=s.parts[0]+s.index[0][0];if(s.parts.length>1||s.index.length>1){t[a]||(t[a]={}),t[a].myLabel="${"+s.parts[0]+"} "+s.index[0][0],n=t[a];for(let e=1;e<s.index[0].length-1;e++)n[s.index[0][e]]||(n[s.index[0][e]]={}),n=n[s.index[0][e]];for(let t=1;t<s.parts.length;t++){var l=s.parts[t]+s.index[t][0];n[l]||(n[l]={}),n[l].myLabel="${"+s.parts[t]+"} "+s.index[t][0],t===s.parts.length-1?(n[l].actualItem=e,n[l].value=""):n=n[l]}}else t[a]={},t[a].actualItem=e,t[a].value=""})),t}(s),n=e.vars.anchors.items;for(;n.firstChild;)n.removeChild(n.firstChild);buildTreeView(e,t)}e.vars.rowHandlerTokens.forEach((function(e){e.enable()}))}(t),function generateButtons(t){var s=t.vars.anchors,l=t.vars.editor,o=t.vars.tokens,r=t.vars.controls;"tree"===t.config.viewMode&&(r.buttons.expandAll=shmi.createControl("button",s.expandCollapse,{label:"","icon-src":"pics/system/controls/recipe-edit/expand-all.svg","icon-title":"${recipe-edit.label.expand-all}","show-icon":!0,"show-text":!1,name:"expandAll"},"DIV"),o.expandAll=r.buttons.expandAll.listen("click",(function(e){var t=document.getElementsByClassName("cont");for(let e of t){const t=shmi.getUiElement("anchor",e),s=shmi.getUiElement("expand",e);t.style.display="block",shmi.addClass(s,"expand")}})),r.buttons.collapseAll=shmi.createControl("button",s.expandCollapse,{label:"","icon-src":"pics/system/controls/recipe-edit/collapse-all.svg","icon-title":"${recipe-edit.label.collapse-all}","show-icon":!0,"show-text":!1,name:"collapseAll"},"DIV"),o.collapseAll=r.buttons.collapseAll.listen("click",(function(e){var t=document.getElementsByClassName("cont");for(let e of t){const t=shmi.getUiElement("anchor",e),s=shmi.getUiElement("expand",e);t.style.display="none",shmi.removeClass(s,"expand")}})));r.buttons.apply=shmi.createControl("button",s.buttons,{label:a[n.EDIT],name:"applyRecipe"},"DIV"),o.apply=r.buttons.apply.listen("click",(function(s){switch(l.mode){case n.CREATE:createRecipe(t,(function(s,n){n?console.error(e,"error creating recipe:",n):(console.log(e,"created new recipe"),clearValues(t),t.onLock(),t.fire("stop-edit",{recipe:s,cancel:!1}))}));break;case n.EDIT:!function updateRecipe(e,t){var s=shmi.requires("visuals.session.RecipeManager"),n=e.vars.controls,a=e.vars.editor;s.getRecipe(a.recipe_id,(function(s,a){a?(shmi.notify("${recipe-edit.error.fetchRecipe}","${V_ERROR}",{ERROR_CODE:a.errc,ERROR_MSG:a.message,ERROR_CAT:a.category}),t(a)):s.set(n.name.getValue(),getMetaData(e),!1,(function(n){n?(shmi.notify("${recipe-edit.error.updateRecipe}","${V_ERROR}",{ERROR_CODE:n.errc,ERROR_MSG:n.message,ERROR_CAT:n.category}),t(n)):"number"==typeof s.versionId?s.write(function getItemData(e){var t=e.vars.recipe,s={},n=shmi.requires("shmi.visuals.tools.unitClasses");return t.items.forEach((function(t,a){var l=e.vars.controls.items[t.name];if(l&&t.read&&t.write)if(t.adapter){var o=n.getSelectedAdapter(t.unitClass);s[t.name]=o.inFunction(l.getValue())}else s[t.name]=l.getValue()})),s}(e),(function(e){e&&shmi.notify("${recipe-edit.error.writeRecipe}","${V_ERROR}",{ERROR_CODE:e.errc,ERROR_MSG:e.message,ERROR_CAT:e.category}),t(e||null)})):t(null)}))}))}(t,(function(s){s?console.error(e,"error updating recipe:",s):(console.log(e,"recipe updated"),clearValues(t),t.onLock(),t.fire("stop-edit",{recipe:t,cancel:!1}))}));break;case n.CAPTURE:createRecipe(t,(function(s,n){n?console.error(e,"error creating recipe:",n):(console.log(e,"created new recipe"),function captureRecipe(e,t){e.capture(null,(function(e){e&&shmi.notify("${recipe-edit.error.captureRecipe}","${V_ERROR}",{ERROR_CODE:e.errc,ERROR_MSG:e.message,ERROR_CAT:e.category}),t(e||null)}))}(s,(function(n){n?console.error(e,"error capturing recipe values:",n):(console.log(e,"recipe values captured"),clearValues(t),t.onLock(),t.fire("stop-edit",{recipe:s,cancel:!1}))})))}))}})),r.buttons.cancel=shmi.createControl("button",s.buttons,{label:"${recipe-edit.label.cancel}",name:"cancelRecipe"},"DIV"),o.cancel=r.buttons.cancel.listen("click",(function(e){clearValues(t),t.onLock(),t.fire("stop-edit",{cancel:!0})}))}(t)}function buildTreeView(e,t,s){var n=shmi.requires("visuals.tools.iterate").iterateObject;shmi.loadResource("templates/default/recipe-edit/treeview.html",(function(a,l){l||(s||(s=e.vars.anchors.items),n(t,(function(n,l){if("myLabel"!==l){var o=document.createElement("div");o.setAttribute("data-ui","tree-node"),o.setAttribute("class","element cont"),o.innerHTML=a;var r=shmi.getUiElement("control-name",o),c=shmi.getUiElement("expand",o);if(s.appendChild(o),"object"!=typeof t[l]||t[l].actualItem){var u=shmi.getUiElement("value-holder",o);c.style.display="none",generateItemInput(t[l].actualItem,u,e)}else{const s=shmi.getUiElement("anchor",o),n=shmi.getUiElement("info",o),a=t[l].myLabel;s.style.display="none",r.innerText=shmi.localize(a),e.vars.rowHandlerTokens.push(new shmi.visuals.io.MouseListener(n,function getRowHandler(e,t){return{onPress:function(e,t,s){},onEnter:function(s){e.locked||shmi.addClass(t.parentNode,"hover")},onLeave:function(e){shmi.removeClass(t.parentNode,"hover")},onRelease:function(s,n,a){if(!e.locked){var l=shmi.getUiElement("expand",t);shmi.hasClass(l,"expand")?shmi.removeClass(l,"expand"):shmi.addClass(l,"expand");var o=shmi.getUiElement("anchor",t.parentNode);"none"===o.style.display?o.style.display="block":o.style.display="none"}}}}(e,n))),e.vars.rowHandlerTokens.push(new shmi.visuals.io.TouchListener(n,function getRowHandlerTouch(e,t){return{onPress:function(t,s,n){e.vars.performClick=!0},onDrag:function(t){e.vars.performClick=!1},onRelease:function(s,n,a){if(!e.locked&&e.vars.performClick){var l=shmi.getUiElement("expand",t);shmi.hasClass(l,"expand")?shmi.removeClass(l,"expand"):shmi.addClass(l,"expand");var o=shmi.getUiElement("anchor",t.parentNode);"none"===o.style.display?o.style.display="block":o.style.display="none"}}}}(e,n))),buildTreeView(e,t[l],s)}}})))}))}function generateItemInput(e,t,s){var n=null,a=s.vars.controls,l=!1,o=shmi.requires("shmi.visuals.tools.unitClasses");if(e.read){if(e.type===shmi.Constants.TYPE_BOOL)n={ui:"checkbox",label:e.label||e.name,"class-name":"checkbox label-beside recipe-bool",template:"default/recipe-edit/bool-checkbox","on-value":1,"off-value":0};else if(s.vars.dictionary&&s.vars.dictionary["itemoptions-"+e.name])(n={ui:"select-box",label:e.label||e.name,"class-name":"select-box label-beside recipe-option"}).options=s.vars.dictionary["itemoptions-"+e.name];else if(s.config.enableNumpad&&e.type!==shmi.Constants.TYPE_STRING&&(l=!0),n={ui:"input-field",label:e.label||e.name,"class-name":"input-field label-beside","numpad-enabled":l,"auto-type":!1,"value-alignment":"auto","unit-text":e.unit||"",type:e.type,precision:"number"==typeof e.digits?e.digits:-1},-1!==[shmi.Constants.TYPE_INT,shmi.Constants.TYPE_FLOAT].indexOf(e.type))if(e.adapter){var r=o.getSelectedAdapter(e.unitClass);"number"==typeof e.min&&(n.min=r.outFunction(e.min)),"number"==typeof e.max&&(n.max=r.outFunction(e.max))}else"number"==typeof e.min&&(n.min=e.min),"number"==typeof e.max&&(n.max=e.max);a.items[e.name]=shmi.createControl(n.ui,t,n,"DIV"),e.write||a.items[e.name].lock(!0)}}function getMetaData(e){var t=shmi.requires("visuals.tools.iterate").iterateObject,s={};return t(e.vars.controls.meta,(function(e,t){s[t]=e.getValue()})),s}function createRecipe(e,t){var s=shmi.requires("visuals.session.RecipeManager"),n=e.vars.controls,a=e.vars.editor;s.getTemplate(a.template_id,(function(s,a){a?(shmi.notify("${recipe-edit.error.fetchTemplate}","${V_ERROR}",{ERROR_CODE:a.errc,ERROR_MSG:a.message,ERROR_CAT:a.category}),t(a)):s.createRecipe(n.name.getValue(),getMetaData(e),(function(e,s){s?(shmi.notify("${recipe-edit.error.createRecipe}","${V_ERROR}",{ERROR_CODE:s.errc,ERROR_MSG:s.message,ERROR_CAT:s.category}),t(null,s)):t(e,null)}))}))}function setTitleRecipe(e,t){var s=e.vars.anchors.recipeName;s.textContent="string"==typeof t?"("+t+")":""}function clearValues(e){var t=e.vars.recipe=shmi.cloneObject(e.vars.template),s=e.vars.editor,n=e.vars.controls;t.valuesSet=!1,s.recipe_id=null,s.mode=null,n.name.setValue(""),setTitleRecipe(e,null),t.meta.forEach((function(e){n.meta[e.name].setValue("")})),t.items.forEach((function(e){n.items[e.name]&&n.items[e.name].setValue(null)}))}function getType(e){return null===e?null:{int:2,long:2,longlong:2,uint:2,ulong:2,ulonglong:2,float:3,double:3,bool:1,boolean:1,string:0,error:-1}[e]}async function fetchItemInfo(e){const t=shmi.requires("visuals.session.ItemManager"),{getSelectedAdapter:s}=shmi.requires("visuals.tools.unitClasses"),n=e.vars.template.items.map((e=>e.name)),a=await t.getItemProperties(n),l=Object.keys(a),o=n.filter((e=>!l.includes(e)));if(e.vars.template.items.forEach((e=>{const t=a[e.name];if(t){const n=function getUnitClass(e){if(String(parseInt(e))===e)return parseInt(e);return null}(t.unit),a=null!==n?s(n):null,l=getType(t.value_type);Object.assign(e,{type:getType(t.value_type),label:t.label,unit:a?.unitText??t.unit,unitClass:n,adapter:a,digits:t.digits,min:t.min,max:t.max,read:t.access.includes("read")&&-1!==l,write:t.access.includes("write"),error:-1!==l})}})),0!==o.length){const e=new Error(`Unable to load item info for ${o.length} item(s).`);throw e.items=o,console.error(e,e.items),e}}function updateEditor(e,t){var s=e.vars.editor,l=e.vars.recipe;!0===t?e.onLock():e.onUnlock(),setTitleRecipe(e,null===s.recipe_id?null:l.name),function updateVisibility(e,t){var s=e.vars.anchors,a=e.vars.recipe;switch(t){case n.CREATE:case n.CAPTURE:shmi.removeClass(s.meta,"hidden"),shmi.addClass(s.items,"hidden");break;case n.EDIT:shmi.removeClass(s.meta,"hidden"),a.valuesSet?shmi.removeClass(s.items,"hidden"):shmi.addClass(s.items,"hidden");break;default:throw new Error("[RecipeEdit] updateVisibility - Invalid mode specified: "+t)}}(e,s.mode),function updateValues(e,t){var s=e.vars.recipe,l=e.vars.controls,o=shmi.requires("shmi.visuals.tools.unitClasses");switch(l.name.setValue(s.name),l.buttons.apply.setLabel(a[t]),t){case n.CREATE:case n.CAPTURE:s.meta.forEach((function(e){l.meta[e.name].setValue(e.default)}));break;case n.EDIT:s.meta.forEach((function(e){l.meta[e.name].setValue(e.value)})),s.items.forEach((function(e){if(l.items[e.name])if(e.adapter){var t=o.getSelectedAdapter(e.unitClass);l.items[e.name].setValue(t.outFunction(e.value))}else l.items[e.name].setValue(e.value)}));break;default:throw new Error("[RecipeEdit] updateValues - Invalid mode specified: "+t)}}(e,s.mode)}var l={className:"RecipeEdit",uiType:e,isContainer:!0,config:t,configSchema:null,vars:{anchors:{title:null,body:null,name:null,meta:null,items:null,buttons:null},controls:{name:null,items:{},meta:{},buttons:{}},tokens:{apply:null,cancel:null},editor:{template_id:null,recipe_id:null,mode:null},recipe:{name:null,meta:[],items:[]},template:{name:null,meta:[],items:[]},rowHandlerTokens:[],templateSet:!1,performClick:!0,fetchId:null,dictionary:null},imports:{},events:["start-edit","stop-edit"],prototypeExtensions:{onInit:function(){var e=this;!function initAnchorElements(e){var t=shmi.requires("visuals.tools.iterate").iterateObject,s=e.vars.anchors;s.title=shmi.getUiElement("editor-title",e.element),s.recipeName=shmi.getUiElement("recipe-name",e.element),s.body=shmi.getUiElement("editor-body",e.element),s.name=shmi.getUiElement("name-anchor",e.element),s.meta=shmi.getUiElement("meta-anchor",e.element),s.items=shmi.getUiElement("items-anchor",e.element),s.expandCollapse=shmi.getUiElement("expand-collapse-anchor",e.element),s.buttons=shmi.getUiElement("buttons-anchor",e.element),t(s,(function(e,t){if(null===e)throw new Error("[RecipeEdit] template does not contain all required anchor elements")}))}(e),e.vars.anchors.title.textContent=shmi.localize(e.config.title),e.config.dictionary&&(e.vars.dictionary=shmi.requires(e.config.dictionary).dictionary)},onEnable:function(){this.vars.rowHandlerTokens.forEach((function(e){e.enable()}))},onDisable:function(){this.vars.rowHandlerTokens.forEach((function(e){e.disable()})),this.vars.rowHandlerTokens=[]},onLock:function(){this.controls.forEach((function(e){"collapseAll"!==e.config.name&&"expandAll"!==e.config.name&&e.lock()}))},onUnlock:function(){this.controls.forEach((function(e){e.unlock()}))},onSetValue:function(e,t,s){},onSetProperties:function(e,t,s){},setTemplate:function(t,s,a){var l=this,o=l.vars.editor,r=null;if(l.vars.fetchId={},!l.isActive())throw new Error("["+e+"] control not enabled yet!");o.template_id=t,l.vars.templateSet=!1,r=l.vars.fetchId,function fetchTemplateData(e,t){var s=e.vars.template,n=e.vars.editor,a=shmi.requires("visuals.tools.iterate").iterateObject;shmi.requires("visuals.session.RecipeManager").getTemplate(n.template_id,(function(e,n){s.items=[],s.meta=[],n?(shmi.notify("${recipe-edit.error.fetchTemplate}","${V_ERROR}",{ERROR_CODE:n.errc,ERROR_MSG:n.message,ERROR_CAT:n.category}),t(n)):(s.name=e.name,e.items.forEach((function(e){s.items.push({name:e,label:null,unit:null,type:null,value:null,digits:null,write:!1,read:!1})})),a(e.metadata,(function(e,t){s.meta.push({name:t,default:e.default_value,label:e.label||t,type:e.value_type,value:null})})),t(null))}))}(l,(async function(e){if(e)a(e);else{if(l.isActive())try{await fetchItemInfo(l),l.vars.fetchId===r&&(l.vars.fetchId=null,l.vars.templateSet=!0,l.vars.recipe=shmi.cloneObject(l.vars.template),l.isActive()&&(clearGenerated(l),generateContent(l),null!==s?l.editRecipe({mode:n.EDIT,recipe_id:s,preview:!0}):(setTitleRecipe(l,null),l.onLock())))}catch(e){l.isActive()&&(e.items?(clearGenerated(l),shmi.notify("${recipe-edit.error.fetchItemInfoTimeout}","${V_ERROR}",{ITEM_COUNT:e.items.length,ITEMS:(e.items.length>3?[...e.items.slice(0,3),"..."]:e.items).join(", ")})):(clearGenerated(l),shmi.notify("${recipe-edit.error.fetchItemInfo}","${V_ERROR}")))}a(null)}}))},isTemplateSet:function(){return this.vars.templateSet},editRecipe:function(e){var t=this,s=t.vars.editor;t.isActive()&&t.isTemplateSet()&&(s.mode=e.mode,s.recipe_id=e.recipe_id,s.preview=!0===e.preview,null!==s.recipe_id?(s.preview||t.fire("start-edit",{}),function fetchRecipeData(e,t){var s=e.vars.editor,n=e.vars.recipe=shmi.cloneObject(e.vars.template),a=shmi.requires("visuals.tools.iterate").iterateObject;shmi.requires("visuals.session.RecipeManager").getRecipe(s.recipe_id,(function(s,l){l?(shmi.notify("${recipe-edit.error.fetchRecipe}","${V_ERROR}",{ERROR_CODE:l.errc,ERROR_MSG:l.message,ERROR_CAT:l.category}),t(l)):(n.name=s.name,a(s.metadata,(function(t,s){var n=function getMetaByName(e,t){var s=e.vars.recipe,n=-1;return s.meta.some((function(e,s){return e.name===t&&(n=s,!0)})),-1!==n?s.meta[n]:null}(e,s);n&&(n.value=t)})),a(s.values,(function(t,s){var n=function getItemByName(e,t){var s=e.vars.recipe,n=-1;return s.items.some((function(e,s){return e.name===t&&(n=s,!0)})),-1!==n?s.items[n]:null}(e,s);n&&(n.value=t.value)})),"number"==typeof s.versionId?n.valuesSet=!0:n.valuesSet=!1,t(null))}))}(t,(function(e){e||updateEditor(t,s.preview)}))):(t.vars.recipe={name:null,meta:[],items:[]},updateEditor(t,s.preview)))},reset:function(){var t=this,s=t.vars.editor,n=s.template_id;t.isActive()&&t.isTemplateSet()&&(s.template_id=null,s.recipe_id=null,s.mode=null,t.setTemplate(n,null,(function(t){t&&console.error(e,"error resetting recipe-edit:",t)})))},getState:function(){return shmi.cloneObject(this.vars.editor)},MODE:n}};shmi.requires("visuals.tools.control-generator").generate(l)}(),function(){"use strict";var e="recipe-select",t="recipe-select",s={"class-name":e,name:null,template:"default/recipe-select",label:t,"show-results":"always","recipe-template-id":null,"default-value":null,"clear-on-focus":!1},n=shmi.requires("visuals.tools.logging").createLogger(t,!0,!1),a=n.fLog;n.log;function eventProxy(e,t){e.fire(t.type,t.detail)}var l={className:e,uiType:t,isContainer:!0,config:s,configSchema:null,vars:{domChild:null,dataGridId:null,dataGrid:null,searchbar:null,eventProxy:null,tokens:[]},imports:{dgm:"visuals.session.DataGridManager"},events:["change"],prototypeExtensions:{onInit:function(){if("number"!=typeof this.config["recipe-template-id"])return this.element.textContent="Invalid or no recipe template id given. This control will not work. Please select a valid recipe template id.",void a("Invalid or no recipe template id given:",this.config["recipe-template-id"]);if(this.vars.domChild=shmi.getUiElement("recipe-select-searchbar",this.element),null===this.vars.domChild)return this.element.textContent="One or more required DOM elements are missing from the template. This control will not work. Please select a compatible template.",void a("Some DOM elements are missing from the template.");do{this.vars.dataGridId=e+"-"+Math.random().toString(36).substr(2,9)}while(null!==this.imports.dgm.getGrid(this.vars.dataGridId));this.imports.dgm.grids[this.vars.dataGridId]=this.vars.dataGrid=new shmi.visuals.core.DataGridRecipe(this.vars.dataGridId,this.config["recipe-template-id"]),this.vars.dataGrid.init();var t={label:this.config.label,datagrid:this.vars.dataGridId,"search-column":"recipe_name","show-results":this.config["show-results"],"result-columns":["recipe_name"]};this.vars.searchbar=shmi.createControl("searchbar",this.vars.domChild,t),null===this.vars.searchbar&&(this.element.textContent="Unable to create searchbar control for recipes. This control will not work.",a("Unable to create searchbar control for recipes."));const s=shmi.requires("visuals.session.config"),n=s.keyboard&&s.keyboard.enabled;this.config["clear-on-focus"]&&this.vars.tokens.push(this.vars.searchbar.listen("enter",(()=>{n||this.vars.searchbar.setValue("")})))},getValue:function(){var e=null,t=null,s=null;return this.vars.searchbar&&null!==(e=this.vars.searchbar.getMatchData())&&(t=parseInt(e.recipe_id),s=parseInt(e.values_set),this.vars.searchbar.getValue()===e.recipe_name)?{name:this.vars.searchbar.getValue(),recipe_id:isNaN(t)?null:t,template_id:this.config["recipe-template-id"],values_set:1===s}:null},setValue:function(e){this.vars.searchbar&&this.vars.searchbar.setValue(e)},refreshGrid:function(){this.vars.dataGrid&&this.vars.dataGrid.refresh()},onEnable:function(){this.vars.searchbar&&(this.vars.eventProxy=this.vars.searchbar.listen("change",eventProxy.bind(null,this)),this.vars.searchbar.enable(),null!==this.config["default-value"]&&this.vars.searchbar.setValue(this.config["default-value"]))},onDisable:function(){this.vars.searchbar&&this.vars.searchbar.disable(),this.vars.eventProxy&&(this.vars.eventProxy.unlisten(),this.vars.eventProxy=null)},onDelete:function(){this.vars.searchbar&&shmi.deleteControl(this.vars.searchbar),this.vars.dataGrid&&delete this.imports.dgm.grids[this.vars.dataGridId],this.vars.tokens.forEach((e=>{e.unlisten()}))},onLock:function(){this.vars.searchbar&&this.vars.searchbar.lock()},onUnlock:function(){this.vars.searchbar&&this.vars.searchbar.unlock()},getTemplate:function(){return this.config["recipe-template-id"]}}};shmi.requires("visuals.tools.control-generator").generate(l)}(),function(){"use strict";var e="ResponsiveMenu",t="responsive-menu",s={"class-name":t,name:null,template:"default/"+t,menu:[],"mobile-layouts":[],"overlay-style":{background:"transparent",zIndex:1}},n=shmi.requires("visuals.tools.logging").createLogger(t,!0,!1),a=(n.fLog,n.log,"pics/system/icons/placeholder.svg");function createListener(e,t){var s=shmi.requires("visuals.io"),n=new s.MouseListener(e,t),a=new s.TouchListener(e,t);return{enable:function(){n.enable(),a.enable()},disable:function(){n.disable(),a.disable()}}}function makeElement(e,t,s){var n=document.createElement(s||"DIV");return"string"==typeof e?shmi.addClass(n,e):Array.isArray(e)&&e.forEach((function(e){"string"==typeof e&&shmi.addClass(n,e)})),"string"==typeof t&&n.setAttribute("data-ui",t),n}function setSelected(e,t,s){e.vars.selected[s]!==t&&(null!==e.vars.selected[s]&&shmi.removeClass(e.vars.selected[s],"selected"),e.vars.selected[s]=t,null!==t&&shmi.addClass(t,"selected")),e.vars.selected.forEach((function(t,n){t&&n>s&&(shmi.removeClass(t,"selected"),e.vars.selected[n]=null)}))}function setLayer(e,t){var s="layer-<%= INDEX %>-active";t!==e.vars.activeLayer&&(e.vars.activeLayer>=0&&shmi.removeClass(e.element,shmi.evalString(s,{INDEX:e.vars.activeLayer})),e.vars.activeLayer=t,t>=0&&shmi.addClass(e.element,shmi.evalString(s,{INDEX:e.vars.activeLayer}))),-1===t&&e.vars.selected.forEach((function(t,s){null!==t&&(shmi.removeClass(t,"selected"),e.vars.selected[s]=null)}))}function restrictAccess(e,t){e.vars.restrictedItems.includes(t)||e.vars.restrictedItems.push(t)}function buildMenuGroup(t,s,n){var l,o=makeElement("menu-group","menu-group","LI"),r=makeElement("click-overlay","click-overlay"),c=makeElement("group-data"),u=makeElement("icon","icon"),m=makeElement(null,null,"IMG"),h=makeElement("menu-group-label","menu-group-label"),d=makeElement("triangle"),f=makeElement("menu-layer-"+(n+1),"menu-layer-"+(n+1),"UL"),v={onClick:null};return d.style.pointerEvents="none",u.appendChild(m),c.appendChild(u),c.appendChild(h),c.appendChild(d),o.appendChild(r),o.appendChild(c),o.appendChild(f),v.onClick=function(){var e=t.vars.crumbs["layer"+n];shmi.hasClass(o,"selected")?(setLayer(t,n),setSelected(t,null,n)):(setLayer(t,n+1),setSelected(t,o,n),e.textContent=shmi.localize(s.label))},h.textContent=shmi.localize(s.label),s["icon-src"]?m.setAttribute("src",s["icon-src"]):m.setAttribute("src",a),l=createListener(r,v),t.vars.listeners.push(l),s.access&&s.access.type&&s.access.condition&&restrictAccess(t,{base:o,listener:l,menuItem:s}),s.items.forEach((function(s,a){Array.isArray(s.items)?n>=1?console.error("["+e+"]","menu-groups not allowed above layer 1"):f.appendChild(buildMenuGroup(t,s,n+1)):f.appendChild(buildMenuItem(t,s,n+1))})),o}function getConditionCallback(e,t,s){return n=>{n?(shmi.removeClass(e,s),t.enable()):(shmi.addClass(e,s),t.disable())}}function buildMenuItem(e,t,s){var n,l=makeElement("menu-item","menu-item","LI"),o=makeElement("icon","icon"),r=makeElement(null,null,"IMG"),c=makeElement("menu-item-label","menu-item-label"),u={onClick:null},m=shmi.requires("visuals.core"),h=t.action?new m.UiAction(t.action):null;return o.appendChild(r),t["icon-src"]?r.setAttribute("src",t["icon-src"]):r.setAttribute("src",a),l.appendChild(o),c.textContent=shmi.localize(t.label),l.appendChild(c),u.onClick=function(){setSelected(e,l,s),setLayer(e,-1),e.vars.mobile&&removeOverlay(e),h&&h.execute(e)},n=createListener(l,u),e.vars.listeners.push(n),t.access&&t.access.type&&t.access.condition&&restrictAccess(e,{base:l,listener:n,menuItem:t}),l}function buildMenu(e,t){var s,n=shmi.getUiElement("menu-layer-0",e.element),a=shmi.getUiElement("custom-content-group",e.element),l=shmi.getUiElement("burger-button",e.element),o={onClick:null};o.onClick=function(){e.vars.mobile&&(e.vars.activeLayer>=0?(setLayer(e,-1),removeOverlay(e)):(setLayer(e,0),function createOverlay(e){var t={element:document.createElement("DIV"),listener:null},s={onClick:null},n=t.element.style;n.position="fixed",n.top=0,n.bottom=0,n.left=0,n.right=0,n.background=e.config["overlay-style"].background,n.zIndex=e.config["overlay-style"].zIndex,document.body.insertBefore(t.element,document.body.firstChild),s.onClick=function(){e.vars.mobile&&e.vars.activeLayer>=0&&(setLayer(e,-1),removeOverlay(e))},t.listener=createListener(t.element,s),t.listener.enable(),e.vars.overlay=t}(e)))},s=createListener(l,o),e.vars.listeners.push(s),t.forEach((function(t){Array.isArray(t.items)?n.insertBefore(buildMenuGroup(e,t,0),a):n.insertBefore(buildMenuItem(e,t,0),a)}))}function removeOverlay(e){e.vars.overlay&&(e.vars.overlay.element.parentNode.removeChild(e.vars.overlay.element),e.vars.overlay.listener.disable(),e.vars.overlay=null)}var l={className:e,uiType:t,isContainer:!1,config:s,configSchema:null,vars:{listeners:[],restrictedItems:[],activeLayer:-1,mobile:!1,selected:[null,null,null],crumbs:{layer0:null,layer1:null},tokens:[],overlay:null},imports:{im:"visuals.session.ItemManager",qm:function(){return shmi.visuals.session.QueryManager}},prototypeExtensions:{onInit:function(){var e=this;e.vars.crumbs.layer0=shmi.getUiElement("selected-entry-layer-0"),e.vars.crumbs.layer1=shmi.getUiElement("selected-entry-layer-1"),shmi.removeClass(e.element,"slide"),shmi.removeClass(e.element,"accordion"),shmi.addClass(e.element,e.config.mode),buildMenu(e,e.config.menu)},onEnable:function(){var e,t=this,s=shmi.getCurrentLayout();-1!==t.config["mobile-layouts"].indexOf(s)?(shmi.addClass(t.element,"mobile"),t.vars.mobile=!0):(shmi.removeClass(t.element,"mobile"),t.vars.mobile=!1),e=shmi.listen("layout-change",(function(e){-1!==t.config["mobile-layouts"].indexOf(e.detail.layout)?(shmi.addClass(t.element,"mobile"),t.vars.mobile||setLayer(t,-1),t.vars.mobile=!0):(shmi.removeClass(t.element,"mobile"),t.vars.mobile&&(setLayer(t,0),removeOverlay(t)),t.vars.mobile=!1)})),t.vars.tokens.push(e),t.vars.mobile||setLayer(t,0),t.vars.listeners.forEach((function(e){e.enable()})),t.vars.restrictedItems.forEach((e=>{const{ConditionObserver:s}=shmi.requires("visuals.tools.conditions");e.menuItem.access&&e.menuItem.access.type&&e.menuItem.access.condition&&("hide"===e.menuItem.access.type?t.vars.tokens.push(new s(e.menuItem.access.condition,getConditionCallback(e.base,e.listener,"hidden"))):"lock"===e.menuItem.access.type&&t.vars.tokens.push(new s(e.menuItem.access.condition,getConditionCallback(e.base,e.listener,"locked"))))}))},onDisable:function(){var e=this;e.vars.listeners.forEach((function(e){e.disable()})),e.vars.tokens.forEach((function(e){e.unlisten()})),e.vars.tokens=[],removeOverlay(e)},onLock:function(){this.vars.listeners.forEach((function(e){e.disable()}))},onUnlock:function(){this.vars.listeners.forEach((function(e){e.enable()}))},onSetValue:function(e,t,s){},onSetProperties:function(e,t,s){}}};shmi.requires("visuals.tools.control-generator").generate(l)}(),shmi.pkg("visuals.controls"),shmi.visuals.controls.RockerButton=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","rocker-button"),shmi.def(this.config,"template","default/rocker-button"),shmi.def(this.config,"label","rocker-button"),shmi.def(this.config,"unit-text",null),shmi.def(this.config,"name",null),shmi.def(this.config,"min",Number.NEGATIVE_INFINITY),shmi.def(this.config,"max",Number.POSITIVE_INFINITY),shmi.def(this.config,"step",1),shmi.def(this.config,"precision",-1),shmi.def(this.config,"decimal-delimiter","."),shmi.def(this.config,"type",shmi.c("TYPE_INT")),shmi.def(this.config,"auto-min",!0),shmi.def(this.config,"auto-max",!0),shmi.def(this.config,"auto-step",!0),shmi.def(this.config,"auto-precision",!0),shmi.def(this.config,"auto-label",!0),shmi.def(this.config,"auto-unit-text",!0),shmi.def(this.config,"auto-type",!0),shmi.def(this.config,"numpad-enabled",!1),this.vars={},this.imports={nv:shmi.requires("visuals.tools.numericValues")},this.value=0,this.active=!1,this.listeners=[],this.startup()},shmi.visuals.controls.RockerButton.prototype={uiType:"rocker-button",getClassName:function(){return"RockerButton"},onInit:function(){var e=this;e.imports.nv.initValueSettings(e);var t=shmi.getUiElement("previous",e.element);if(t)if(e.currentValueElement=shmi.getUiElement("current",e.element),e.currentValueElement){var s=shmi.getUiElement("next",e.element);if(s){var n=shmi.getUiElement("label",e.element);n&&e.config.label&&(e.vars=e.vars||{},e.vars.label=e.config.label,n.textContent=shmi.localize(e.config.label));var a=shmi.getUiElement("unit",e.element);a&&e.config["unit-text"]&&(e.vars=e.vars||{},e.vars.unit=e.config["unit-text"],a.textContent=shmi.localize(e.config["unit-text"])),e.currentValueElement.textContent=e.imports.nv.formatOutput(e.value,e),e.createInputField(e.currentValueElement,e.validate.bind(e));var l={onPress:function(e,s,n){shmi.addClass(t,"pressed")},onRelease:function(){shmi.removeClass(t,"pressed")},onClick:function(){e.currentValueElement.blur();var t=e.value-e.vars.valueSettings.step;t=e.imports.nv.applyInputSettings(t,e),e.value=t,e.updateValue(),e.currentValueElement.textContent=e.imports.nv.formatOutput(e.value,e)}};e.listeners.push(new shmi.visuals.io.MouseListener(t,l)),e.listeners.push(new shmi.visuals.io.TouchListener(t,l));var o={onPress:function(e,t,n){shmi.addClass(s,"pressed")},onRelease:function(){shmi.removeClass(s,"pressed")},onClick:function(){e.currentValueElement.blur();var t=e.value+parseFloat(e.vars.valueSettings.step);t=e.imports.nv.applyInputSettings(t,e),e.value=t,e.updateValue(),e.currentValueElement.textContent=e.imports.nv.formatOutput(e.value,e)}};e.listeners.push(new shmi.visuals.io.MouseListener(s,o)),e.listeners.push(new shmi.visuals.io.TouchListener(s,o)),this.currentValueElement.addEventListener("keydown",(function(t){if(e.config.type===shmi.c("TYPE_FLOAT")){var s="."===e.config["decimal-delimiter"]?",":".";t.key===s&&t.preventDefault()}}))}else shmi.log("[RockerButton] no next element provided",3)}else shmi.log("[RockerButton] no current element provided",3);else shmi.log("[RockerButton] no previous element provided",3)},createInputField:function(e,t){var s=this;if(e){var n={onClick:function(){var t=shmi.requires("visuals.session.config"),n=t.keyboard&&t.keyboard.enabled;if(s.config["numpad-enabled"]||n){var a,l=shmi.visuals.session.ItemManager,o=shmi.requires("visuals.tools.numericValues"),r={"decimal-delimiter":s.config["decimal-delimiter"],unit:void 0!==s.vars.unit?s.vars.unit:s.config["unit-text"],label:void 0!==s.vars.label?s.vars.label:s.config.label,value:s.value,callback:function(e){s.value=e,s.updateValue(),s.currentValueElement.textContent=s.imports.nv.formatOutput(s.value,s)}};return s.vars&&s.vars.valueSettings||o.initValueSettings(s),a=s.vars.valueSettings,r.min=a.min,r.max=a.max,r.type=a.type,r.precision=a.precision,s.config.item&&l.getItem(s.config.item)&&s.config["auto-type"]&&(s.type=l.items[s.config.item].type),void shmi.numpad(r)}shmi.addClass(e,"selectableText"),e.setAttribute("contenteditable",!0);var c=document.createRange();e.focus(),e.firstChild&&e.firstChild instanceof Text?(c.setStart(e.firstChild,0),c.setEnd(e.firstChild,e.firstChild.length),window.getSelection().removeAllRanges(),window.getSelection().addRange(c)):shmi.log("[RockerButton] elem not found",0)}};this.listeners.push(new shmi.visuals.io.MouseListener(e,n)),this.listeners.push(new shmi.visuals.io.TouchListener(e,n)),e.style.overflow="hidden",e.addEventListener("keypress",(function(t){13===t.keyCode&&(t.preventDefault(),window.getSelection().removeAllRanges(),e.blur())})),e.addEventListener("blur",(function(){e.setAttribute("contenteditable",!1),window.getSelection().removeAllRanges(),shmi.removeClass(e,"selectableText"),shmi.log("[RockerButton] blur event",0),t(e)}))}else shmi.log("[RockerButton] no base element provided",3)},validate:function(e){var t=this,s=String(e.textContent).replace(t.config["decimal-delimiter"],"."),n=t.config.item&&t.config["auto-type"]?t.vars.valueSettings.type:t.config.type;if(-1===[shmi.c("TYPE_INT"),shmi.c("TYPE_FLOAT")].indexOf(n))return shmi.log("[RockerButton] invalid value type '"+t.config.type+"' configured",3),void(e.textContent=t.imports.nv.formatOutput(t.value,t));if(t.floatRegexp.test(s)){shmi.log("[RockerButton] valid value",1);var a=t.imports.nv.applyInputSettings(s,t);t.value=a,t.updateValue()}else shmi.log("[RockerButton] invalid value",1);e.textContent=t.imports.nv.formatOutput(t.value,t)},updateValue:function(){this.config.item&&shmi.visuals.session.ItemManager.writeValue(this.config.item,this.value)},onEnable:function(){var e=this,t=shmi.visuals.session.ItemManager;e.listeners.forEach((function(e){e.enable()})),e.config.item&&(e._subscriptionTargetId=t.subscribeItem(e.config.item,e)),shmi.log("[RockerButton] enabled",1)},onDisable:function(){var e=this,t=shmi.visuals.session.ItemManager;e.listeners.forEach((function(e){e.disable()})),e.config.item&&t.unsubscribeItem(e.config.item,e._subscriptionTargetId),shmi.log("[RockerButton] disabled",1)},onLock:function(){this.currentValueElement.blur(),this.listeners.forEach((function(e){e.disable()})),shmi.addClass(this.element,"locked"),shmi.log("[RockerButton] locked",1)},onUnlock:function(){this.listeners.forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked"),shmi.log("[RockerButton] unlocked",1)},onSetValue:function(e,t){var s=this;s.value=e,s.currentValueElement.textContent=s.imports.nv.formatOutput(s.value,s)},getValue:function(){return this.value},onSetProperties:function(e,t,s){shmi.requires("visuals.tools.numericValues").setProperties(this,arguments)},setLabel:function(e){var t=this,s=shmi.getUiElement("label",t.element);t.config["auto-label"]&&s&&(t.vars=t.vars||{},t.vars.label=e,s.textContent=shmi.localize(e))},setUnitText:function(e){var t=this,s=shmi.getUiElement("unit",t.element);t.config["auto-unit-text"]&&s&&(t.vars=t.vars||{},t.vars.unit=e,s.textContent=shmi.localize(e))},floatRegexp:/(^[+-]?[0-9]([.][0-9]*)?$|^[+-]?[1-9]+[0-9]*([.][0-9]*)?$)/,intRegexp:/^[-]?[0-9][0-9]*$/},shmi.extend(shmi.visuals.controls.RockerButton,shmi.visuals.core.BaseControl),shmi.pkg("visuals.controls"),shmi.visuals.controls.Screen=function(e,t){shmi.requires("visuals.controls.View"),this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","screen"),shmi.def(this.config,"name",null),shmi.def(this.config,"initial-view",0),shmi.def(this.config,"views",[]),shmi.def(this.config,"no-views-content","<h4> -- add views to this screen -- </h4>"),shmi.def(this.config,"delete-inactive-views",!0),this.controls=[],this.viewElements=[],this.currentView=-1,this.listeners=[],this.subscriptionId=null,this.tokens=[],this.startup()},shmi.visuals.controls.Screen.prototype={uiType:"screen",isContainer:!0,events:["navigate"],getClassName:function(){return"Screen"},onRegister:function(e,t){const s=this;if(Array.isArray(s.config.views)&&s.config.views.length){if("string"!=typeof t)return console.warn("["+s.getClassName()+"]","Screen option 'views' is deprecated and should no longer be used. Use a single content template specified with the 'template' option instead."),void shmi.multiLoad(s.config.views,(t=>{if(s.isDeleted())return;const n=t.map((e=>e.failed?"":e.data+"\n")).join("");s.onRegister(e,n)}));s.element.innerHTML=t}const n=shmi.getUiElements("view",this.element);for(let e=0;e<n.length;e++)n[e].parentNode===this.element&&this.viewElements.push(n[e]);this.clear(),this.config["delete-inactive-views"]?e():(this.viewElements.forEach(((e,t)=>{const n=e.cloneNode(!0);shmi.addClass(n,"hidden"),s.element.appendChild(n),n.setAttribute("data-index",t)})),s.parseChildren(s.element,e))},onInit:function(){var e=this;e.viewElements.length>e.config["initial-view"]&&e.setView(e.config["initial-view"])},clear:function(){for(;this.element.childNodes.length>0;)this.element.removeChild(this.element.childNodes[0])},onSetValue:function(e){if(!shmi.isDesignerEditor()){var t=parseInt(e);this.setView(t)}},onLock:function(){void 0!==this.activeView&&this.activeView.controls.forEach((function(e){e.lock()})),shmi.log("[Screen] onLock called",2)},onUnlock:function(){void 0!==this.activeView&&this.activeView.controls.forEach((function(e){e.unlock()})),shmi.log("[Screen] onUnlock called",2)},onEnable:function(){-1!==this.currentView&&this.activeView.enable();var e=shmi.visuals.session.ItemManager;this.config.item&&(this._sID=e.subscribeItem(this.config.item,this),console.log("screen subscribed "+this.config.item))},onDisable:function(){var e=shmi.visuals.session.ItemManager;this.config.item&&(e.unsubscribeItem(this.config.item,this._sID),console.log("screen unsubscribed item")),-1!==this.currentView&&this.activeView.disable(),this.tokens.forEach((function(e){e.unlisten()}))},setView:function(e){var t=this;if(this.currentView===e)shmi.log("[Screen] view "+e+" already active",2);else if(this.viewElements[e]){var s,n=this.currentView;if(-1!==n&&this.activeView&&(this.config["delete-inactive-views"]?shmi.deleteControl(this.activeView,!0):(shmi.addClass(this.activeView.element,"hidden"),this.activeView.disable())),this.config["delete-inactive-views"]){s=this.viewElements[e].cloneNode(!0),this.element.appendChild(s);const t=s.getAttribute("_nodeid");let n={};t&&(n=shmi.visuals.model.getConfig(t)),n.index=e,this.activeView=shmi.createControl("view",s,n,"DIV","from")}else this.activeView=this.controls[e],shmi.removeClass(this.activeView.element,"hidden");this.active&&this.activeView.enable(),this.locked&&this.activeView.controls.forEach((function(e){e.lock()})),this.currentView=e;var a=shmi.visuals.session.ItemManager;this.config.item&&a.readValue(this.config.item)!==this.currentView&&a.writeValue(this.config.item,this.currentView);var l={index:e,old_index:n};if(this.activeView.isActive())this.fire("navigate",l);else{var o=this.activeView.listen("enable",(function(){var e;o.unlisten(),-1!==(e=t.tokens.indexOf(o))&&t.tokens.splice(e,1),o=null,t.fire("navigate",l)}));t.tokens.push(o)}}else console.error("["+this.getClassName()+"] invalid view index:",e)},onAddControl:function(e,t){var s=this,n=shmi.requires("visuals.tools.controller"),a=[],l=null;if(!s.initialized)throw new Error("Control not initialized yet.");s.config["delete-inactive-views"]?t(new Error("Screen is configured to delete inactive views. Disable option 'delete-inactive-views' to programatically add child controls."),a):(Array.isArray(e)||(e=[e]),e.some((function(e){return"view"!==e.ui}))?t(new Error("All children must be of type 'view'"),a):(e.forEach((function(e){var t=null;if(e.config.index=s.controls.length,null!==(t=shmi.createControl(e.ui,s.element,e.config,"DIV",null,!1))){if(e.style&&"object"==typeof e.style){shmi.requires("visuals.tools.iterate.iterateObject")(e.style,((e,s)=>{t.element.style[s]=e}))}shmi.addClass(t.element,"hidden"),s.viewElements.push(t.element.cloneNode(!0)),a.push(t)}})),(l=shmi.waitOnInit(a,(function(){var o=-1,r=[],c=shmi.requires("visuals.task"),u=[],m=null;l&&(-1!==(o=s._init_.tokens.indexOf(l))&&s._init_.tokens.splice(o,1),l.unlisten(),l=null),e.forEach((function(e,t){var s=null,l=a[t];e.controller&&n.create(e.controller.name,e.controller,l.getName()),Array.isArray(e.children)&&e.children.length&&((s=c.createTask("child control")).run=function(){l.addControl(e.children,(function(e,t){e&&r.push(e),s.complete()}))},u.push(s))})),u.length?((m=c.createTaskList(u,!1)).onComplete=function(){s.controls.length&&s.controls.length===a.length&&s.setView(s.config["initial-view"]),t(r.length?r[0]:null,a)},m.run()):(s.controls.length&&s.controls.length===a.length&&s.setView(s.config["initial-view"]),t(r.length?r[0]:null,a))})))&&s._init_.tokens.push(l)))}},shmi.extend(shmi.visuals.controls.Screen,shmi.visuals.core.BaseControl),function(){"use strict";var e="searchbar",t={"class-name":"searchbar",name:null,template:"default/searchbar",label:e,item:null,datagrid:null,"search-column":null,"show-results":"two-or-more","max-results":100,"result-columns":null,"select-contents-on-focus":!0},s=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),n=s.fLog;s.log;function addRegisteredEventListener(e,t,s,n,a){var l=e.vars.registeredEventListeners[t];l||(e.vars.registeredEventListeners[t]=[],l=e.vars.registeredEventListeners[t]),s.addEventListener(n,a),l.push({type:n,target:s,listener:a})}function removeRegisteredEventListeners(e,t){var s=shmi.requires("visuals.tools.iterate.iterateObject"),n=[];t?(n=e.vars.registeredEventListeners[t]||[],delete e.vars.registeredEventListeners[t]):(s(e.vars.registeredEventListeners,(function(e){n=n.concat(e||[])})),e.vars.registeredEventListeners={}),n.forEach((function(e){e.target.removeEventListener(e.type,e.listener)}))}function clearHint(e){e.vars.dom.suggestion.textContent="",e.vars.currentHint=null}function setHint(e,t,s){var n;t&&(0!==(n=e.getValue()).length||s)?(e.vars.dom.suggestion.textContent=t.substr(n.length),e.vars.currentHint=t):clearHint(e)}function setHintByIdx(e,t,s){if(0!==e.vars.dataGridData.length){for(;t<0;)t+=e.vars.dataGridData.length;t%=e.vars.dataGridData.length,null!==e.vars.currentHintIndex&&shmi.removeClass(e.vars.dom.resultBox.firstChild.children[e.vars.currentHintIndex],"hint-current"),shmi.addClass(e.vars.dom.resultBox.firstChild.children[t],"hint-current"),setHint(e,e.vars.dataGridData[t][e.config["search-column"]],s),e.vars.currentHintIndex=t}else clearHint(e)}function updateHint(e,t){!function fetchHint(e,t){var s=e.vars.lastHintSearchToken&&0===t.indexOf(e.vars.lastHintSearchToken),n=e.vars.lastHintSearchResult&&0===e.vars.lastHintSearchResult.indexOf(t);if(s&&n)return onHint(e,t,e.vars.lastHintSearchResult),e.vars.dataGridData=e.vars.dataGridData.filter((s=>s[e.config["search-column"]]&&-1!==s[e.config["search-column"]].indexOf(t))),void updateResultBox(e,e.vars.dataGridData);clearHint(e),e.vars.dataGrid.setFilter(e.vars.dataGridSearchColumnIdx,[t+"%"]),e.vars.lastHintSearchToken=t}(e,t||e.getValue())}function onHint(e,t,s){t=t||e.getValue(),s?(shmi.removeClass(e.element,"notfound"),setHint(e,s),e.vars.lastHintSearchResult=s):(t.length>0&&shmi.addClass(e.element,"notfound"),clearHint(e),e.vars.lastHintSearchResult=null)}function clearResultBox(e){for(removeRegisteredEventListeners(e,"result-box");e.vars.dom.resultBox.firstChild;)e.vars.dom.resultBox.removeChild(e.vars.dom.resultBox.firstChild)}function updateResultBox(e,t){var s,a,l=document.createElement("table"),o=!1;if(clearResultBox(e),"never"===e.config["show-results"]||"two-or-more"===e.config["show-results"]&&t.length<=1?o=!1:0!==t.length&&(o=!0),o){if(e.vars.dom.resultBox.style.display="",s=Object.keys(t[0]),(e.config["result-columns"]||[]).length>0&&(s=s.filter((function(t){return-1!==e.config["result-columns"].indexOf(t)}))),0===s.length)return e.vars.dom.resultBox.innerHTML='No columns to display. Please check <span style="font-weight: bold">result-columns</span> in your control configuration.',void n("No columns to display.","dataGrid columns =",Object.keys(t[0]),"columns to display =",e.config["result-columns"]);(a=s.indexOf(e.config["search-column"]))>0&&(s.unshift(s[a]),s.splice(a+1,1)),t.forEach((function(t,n){var a=document.createElement("tr");s.forEach((function(e){var s=document.createElement("td");s.textContent=t[e]||"",a.appendChild(s)})),addRegisteredEventListener(e,"result-box",a,"touchstart",(e=>{e.stopPropagation()})),addRegisteredEventListener(e,"result-box",a,"mousedown",(function(s){e.setValue(t[e.config["search-column"]])})),addRegisteredEventListener(e,"result-box",a,"mouseover",setHintByIdx.bind(null,e,n,!0)),addRegisteredEventListener(e,"result-box",a,"mouseleave",shmi.removeClass.bind(shmi,a,"hint-current")),l.appendChild(a)})),e.vars.dom.resultBox.appendChild(l)}else e.vars.dom.resultBox.style.display="none"}function doResultBoxScroll(e,t){var s=e.vars.dom.resultBox.scrollTop,n=s+e.vars.dom.resultBox.offsetHeight;t.offsetTop<s?t.scrollIntoView(!0):t.offsetTop+t.offsetHeight>n&&t.scrollIntoView(!1)}function hintFetchCompleteCallback(e,t){var s,n=e.getValue(),a=function getDataGridDataHelper(e,t){var s=e.getFields();return e.getCurrentIDs(t).map((function(t){var n=e.getRowData(t),a={};return n?(n.forEach((function(e,t){a[s[t]]=String(e.value)})),a):null}))}(e.vars.dataGrid,e.vars.dataGridSubscriptionId.id);a.length>0&&(s=(a[0]||{})[e.config["search-column"]]),e.vars.currentHintIndex=null,e.vars.dataGridData=a,onHint(e,n,s||null),updateResultBox(e,a),e.fire("change",{value:e.getValue()})}function setSelected(e,t){var s=document.createRange();s.selectNodeContents(e),t||s.setStart(e,s.endOffset);var n=window.getSelection();n.removeAllRanges(),n.addRange(s)}function userInputKeyDownHandler(e,t){"Tab"===t.key?e.vars.currentHint&&e.getValue()!==e.vars.currentHint&&(t.preventDefault(),e.setValue(e.vars.currentHint),clearHint(e),setSelected(e.vars.dom.input)):"Escape"===t.key?shmi.hasClass(e.element,"show-results")?shmi.removeClass(e.element,"show-results"):shmi.addClass(e.element,"show-results"):"ArrowUp"===t.key?e.vars.dom.resultBox.firstChild&&e.vars.dom.resultBox.firstChild.children&&(setHintByIdx(e,(e.vars.currentHintIndex||0)-1,!0),doResultBoxScroll(e,e.vars.dom.resultBox.firstChild.children[e.vars.currentHintIndex]),t.preventDefault()):"PageUp"===t.key?e.vars.dom.resultBox.firstChild&&e.vars.dom.resultBox.firstChild.children&&(setHintByIdx(e,Math.max((e.vars.currentHintIndex||0)-10,0),!0),doResultBoxScroll(e,e.vars.dom.resultBox.firstChild.children[e.vars.currentHintIndex]),t.preventDefault()):"ArrowDown"===t.key?e.vars.dom.resultBox.firstChild&&e.vars.dom.resultBox.firstChild.children&&(setHintByIdx(e,(e.vars.currentHintIndex||0)+1,!0),doResultBoxScroll(e,e.vars.dom.resultBox.firstChild.children[e.vars.currentHintIndex]),t.preventDefault()):"PageDown"===t.key?e.vars.dom.resultBox.firstChild&&e.vars.dom.resultBox.firstChild.children&&(setHintByIdx(e,Math.min((e.vars.currentHintIndex||0)+10,e.vars.dataGridData.length-1),!0),doResultBoxScroll(e,e.vars.dom.resultBox.firstChild.children[e.vars.currentHintIndex]),t.preventDefault()):"Enter"===t.key&&(e.vars.currentHint&&e.setValue(e.vars.currentHint),t.target.blur())}function setupDomUserInput(e){addRegisteredEventListener(e,"input",e.vars.dom.input,"input",(function onInput(){var t=e.getValue();e.vars.dom.mirror.textContent=t,updateHint(e,t)})),addRegisteredEventListener(e,"input",e.vars.dom.input,"keydown",userInputKeyDownHandler.bind(null,e)),addRegisteredEventListener(e,"input",e.vars.dom.input,"focus",(function onFocus(){e.fire("enter",{value:e.getValue()}),e.vars.userInputActive=!0,shmi.addClass(e.element,"focused"),shmi.addClass(e.element,"show-results"),updateHint(e),e.vars.focusFromKeyboard||e.showKeyboard(),e.vars.focusFromKeyboard=!1,e.config["select-contents-on-focus"]&&setSelected(e.vars.dom.input,!0)})),addRegisteredEventListener(e,"input",e.vars.dom.input,"blur",(function onBlur(){e.vars.userInputActive=!1,shmi.removeClass(e.element,"focused"),window.getSelection().removeAllRanges(),clearHint(e),e.vars.itemSubscription&&e.config.item&&e.imports.im.writeValue(e.config.item,e.getValue()),e.fire("change",{value:e.getValue()})})),addRegisteredEventListener(e,"input",e.vars.dom.input,"touchstart",(function onDown(t){e.showKeyboard(),t.stopPropagation()})),addRegisteredEventListener(e,"input",e.vars.dom.input,"click",(function onClick(){e.showKeyboard(),shmi.addClass(e.element,"show-results")}))}var a={className:"searchbar",uiType:e,isContainer:!1,config:t,configSchema:null,vars:{dom:{input:null,mirror:null,suggestion:null,resultBox:null,clear:null},initDone:!1,registeredEventListeners:{},dataGrid:null,dataGridSubscriptionId:null,dataGridSearchColumnIdx:-1,dataGridData:[],currentHint:null,currentValue:null,lastHintSearchToken:null,lastHintSearchResult:null,focusFromKeyboard:!1,userInputActive:!1,currentHintIndex:null,itemSubscription:null,listeners:[]},imports:{im:"visuals.session.ItemManager",dgm:"visuals.session.DataGridManager"},events:["change","enter"],prototypeExtensions:{onInit:function(){var e=this,t=shmi.requires("visuals.io");if(this.vars.dom.input=shmi.getUiElement("searchbar-user-input",this.element),this.vars.dom.mirror=shmi.getUiElement("searchbar-mirror",this.element),this.vars.dom.suggestion=shmi.getUiElement("searchbar-suggestion",this.element),this.vars.dom.resultBox=shmi.getUiElement("searchbar-result-box",this.element),this.vars.dom.clear=shmi.getUiElement("clear-input",this.element),this.vars.dataGrid=this.imports.dgm.getGrid(this.config.datagrid),!function verifyDomElements(e){var t=shmi.requires("visuals.tools.iterate.iterateObject"),s=!0;return t(e,(function(e){s=s&&null!==e})),s}(this.vars.dom))return this.element.textContent="One or more required DOM elements are missing from the template. This control will not work. Please select a compatible template.",void n("Some DOM elements are missing from the template.");var s=shmi.getUiElement("searchbar-label",this.element);s&&(this.config.label&&String(this.config.label).length>0?s.textContent=shmi.localize(this.config.label):s.style.display="none");var a={onClick:function(){e.isActive()&&!e.locked&&e.setValue("")}};if(e.vars.listeners.push(new t.MouseListener(e.vars.dom.clear,a)),e.vars.listeners.push(new t.TouchListener(e.vars.dom.clear,a)),null===this.vars.dataGrid)return this.element.textContent="Unable to find datagrid or no datagrid configured. This control will not work. Please select a valid datagrid.",void(this.config.datagrid?n("Datagrid not found",this.config.datagrid):n("No datagrid configured"));this.vars.initDone=!0,this.vars.dataGridSearchColumnIdx=this.vars.dataGrid.getFields().indexOf(this.config["search-column"]),-1===this.vars.dataGridSearchColumnIdx&&(this.element.textContent="Datagrid does not have the configured field to search in. This control will not work. Please select a valid search field.",n("Datagrid does not have the configured search field.")),this.vars.dataGrid.sort(this.vars.dataGridSearchColumnIdx,"ASC")},getValue:function(){if(!this.vars.initDone)return null;var e=this.vars.dom.input.textContent;return e=e.replace(String.fromCharCode(160)," ")},getMatchData:function(){return function getMatchData(e){return(e.vars.dataGridData||[])[e.vars.currentHintIndex||0]||null}(this)},showKeyboard:function(){const e=this,t=shmi.requires("visuals.session.config");t.keyboard&&t.keyboard.enabled&&shmi.keyboard({value:e.getValue(),"select-box-enabled":t.keyboard["language-selection"],"password-input":!1,"show-enter":!1,callback:function(t,s){t&&(e.config.item?e.imports.im.writeValue(e.config.item,s):e.setValue(s),e.vars.focusFromKeyboard=!0,e.vars.dom.input.focus())}})},setValue:function(e){this.vars.initDone&&(this.vars.dom.input.textContent=e,this.vars.dom.mirror.textContent=e,updateHint(this,e))},onEnable:function(){if(!this.vars.initDone)return;const e="number"==typeof this.config["max-results"]&&this.config["max-results"]>0?this.config["max-results"]:100;setupDomUserInput(this),this.vars.dom.input.setAttribute("contenteditable","true"),this.vars.dataGridSubscriptionId=this.vars.dataGrid.subscribePage(0,e,hintFetchCompleteCallback.bind(null,this)),this.config.item&&(this.vars.itemSubscription=this.vars.im.subscribeItem(this.config.item,this)),this.vars.listeners.forEach((function(e){e.enable()}))},onDisable:function(){this.vars.initDone&&(this.vars.dataGrid.unsubscribe(this.vars.dataGridSubscriptionId.id),this.vars.dataGridSubscriptionId=null,this.vars.itemSubscription&&(this.vars.itemSubscription.unlisten(),this.vars.itemSubscription=null),clearResultBox(this),this.vars.dom.input.setAttribute("contenteditable","false"),removeRegisteredEventListeners(this),this.vars.listeners.forEach((function(e){e.disable()})))},onLock:function(){this.vars.initDone&&this.vars.dom.input.setAttribute("contenteditable","false"),this.vars.listeners.forEach((function(e){e.disable()})),shmi.addClass(this.element,"locked")},onUnlock:function(){this.vars.initDone&&this.vars.dom.input.setAttribute("contenteditable","true"),this.vars.listeners.forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked")},onSetValue:function(e,t,s){this.vars.initDone&&!this.vars.userInputActive&&this.setValue(e)},onSetProperties:function(e,t,s){}}};shmi.requires("visuals.tools.control-generator").generate(a)}(),function(){function setIcon(e,t,s){var n=null,a=!1;return t["icon-src"]?("IMG"!==e.tagName?(n=document.createElement("IMG"),e.parentNode.insertBefore(n,e),e.parentNode.removeChild(e)):n=e,n.className="icon option-icon",n.setAttribute("src",t["icon-src"]),a=!0):t["icon-class"]?("DIV"!==e.tagName?(n=document.createElement("DIV"),e.parentNode.insertBefore(n,e),e.parentNode.removeChild(e)):n=e,n.className="icon option-icon",shmi.addClass(n,t["icon-class"]),a=!0):(e.className="icon option-icon",a=!1),a?n.setAttribute("data-ui","option-icon"):e.setAttribute("data-ui","option-icon"),a}function rebuildOptions(e,t){for(e.optionInputListeners.forEach((function(e){e.disable()})),e.optionInputListeners=[],e.optionElements=[];e.anchorElement.firstChild;)e.anchorElement.removeChild(e.anchorElement.firstChild);e.config.options.forEach((function(t,s){var n=shmi.localize(t.label),a=e.optionElement.cloneNode(!0),l=shmi.getUiElement("value",a),o=shmi.getUiElement("icon",a),r=!1;l?l.textContent=n:a.textContent=n,(t.tooltip||t["icon-title"])&&a.setAttribute("title",shmi.localize(t.tooltip||t["icon-title"])),o&&((r=setIcon(o,t))&&n?shmi.addClass(a,"option-icon-and-text"):r&&shmi.addClass(a,"option-icon-only")),a.setAttribute("data-value",s),e.anchorElement.appendChild(a),e.optionElements.push(a)}));var s=function makeOptionMouseHandler(e){return{onClick:function onClick(t,s,n){shmi.log("[SelectBox] click on element",0);var a=e.value,l=parseInt(n.currentTarget.getAttribute("data-value"));e.value=e.config.options[l].value,e.setSelected(n.currentTarget),e.updateValue(),shmi.addClass(e.containerElement,"hidden"),e.open=!1,e.highlightIndex=-1,e.value!==a&&e.fire("change",{value:e.value})},onPress:function onPress(e,t,s){shmi.log("onPress",0),s.preventDefault()},onRelease:function onRelease(){shmi.log("onRelease",0)}}}(e),n=function makeOptionTouchHandler(e){return{onPress:function onPress(){},onClick:function onClick(t,s,n){shmi.log("[SelectBox] click on element",0);var a=e.value,l=parseInt(n.currentTarget.getAttribute("data-value"));e.value=e.config.options[l].value,e.setSelected(n.currentTarget),e.updateValue(),shmi.addClass(e.containerElement,"hidden"),e.open=!1,e.highlightIndex=-1,e.value!==a&&e.fire("change",{value:e.value})}}}(e);e.optionElements.forEach((function(t){e.optionInputListeners.push(new shmi.visuals.io.TouchListener(t,n)),e.optionInputListeners.push(new shmi.visuals.io.MouseListener(t,s))})),t&&e.optionInputListeners.forEach((function(e){e.enable()}))}shmi.pkg("visuals.controls"),shmi.visuals.controls.SelectBox=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","select-box"),shmi.def(this.config,"template","default/select-box"),shmi.def(this.config,"name",null),shmi.def(this.config,"no-selection-label","---"),shmi.def(this.config,"selected",-1),shmi.def(this.config,"options",[]),shmi.def(this.config,"icon-src",null),shmi.def(this.config,"icon-title",null),shmi.def(this.config,"icon-class",null),shmi.def(this.config,"label","select-box"),shmi.def(this.config,"auto-label",!0),shmi.def(this.config,"show-icon",!1),shmi.def(this.config,"show-text",!0),this.active=!1,this.open=!1,this.value=null,this.highlightIndex=-1,this.inputListeners=[],this.optionInputListeners=[],this.optionElements=[],this.labelElement=null,this.iconElement=null,this.startup()},shmi.visuals.controls.SelectBox.prototype={uiType:"select-box",events:["change"],tooltipProperties:["icon-title"],getClassName:function(){return"SelectBox"},onTemplate:function(e,t,s){if(t)shmi.log("[SelectBox] Template not found - Error 404",3),s();else{if(!this.element)return void shmi.log("[SelectBox] no base element provided",3);var n=document.createElement("DIV");for(n.innerHTML=e,this.templateElement=document.createDocumentFragment();n.firstChild;)this.templateElement.appendChild(n.firstChild);s()}},onInit:function(){var e=this;this.element.innerHTML="",this.labelElement=shmi.getUiElement("label",this.templateElement).cloneNode(!0);var t=shmi.getUiElement("icon",this.templateElement);if(t&&(e.iconElement=t.cloneNode(!0),e.config["icon-src"]?(shmi.addClass(t,"hidden"),shmi.removeClass(e.iconElement,"hidden"),"IMG"!==e.iconElement.tagName&&(e.iconElement=document.createElement("IMG"),e.iconElement.setAttribute("data-ui","icon"),shmi.addClass(e.iconElement,"control-icon icon")),e.iconElement.setAttribute("src",e.config["icon-src"])):e.config["icon-class"]&&(shmi.addClass(e.iconElement,e.config["icon-class"]),shmi.removeClass(e.iconElement,"hidden"),shmi.addClass(t,"hidden"))),e.config["show-icon"]&&e.config["show-text"]?shmi.addClass(e.element,"icon-and-text"):e.config["show-icon"]&&shmi.addClass(e.element,"icon-only"),this.containerElement=shmi.getUiElement("options",this.templateElement).cloneNode(!0),this.containerElement)if(this.anchorElement=shmi.getUiElement("anchor",this.containerElement),this.anchorElement)if(this.optionElement=shmi.getUiElement("option",this.templateElement),this.optionElement)if(this.selectedTempl=shmi.getUiElement("selected",this.templateElement).cloneNode(!0),this.selectedValField=shmi.getUiElement("value",this.selectedTempl),this.selectedTempl&&this.selectedValField){var s=document.createElement("DIV");shmi.addClass(s,"label-area"),this.element.appendChild(s),this.iconElement&&s.appendChild(this.iconElement),this.labelElement&&(this.labelElement.textContent=shmi.localize(this.config.label),s.appendChild(this.labelElement)),this.element.appendChild(this.containerElement),this.element.appendChild(this.selectedTempl),rebuildOptions(this),this.selected=this.config.selected,this.containerElement.setAttribute("tabindex","-1"),this.blurHandler=function(){e.clickedInside?setTimeout((function(){e.containerElement.focus()}),shmi.c("DECOUPLE_TIMEOUT")):(shmi.addClass(this.containerElement,"hidden"),setTimeout(function(){this.open=!1}.bind(this),shmi.c("DECOUPLE_TIMEOUT")),this.highlightIndex=-1)}.bind(this),this.containerElement.addEventListener("blur",this.blurHandler);var n={onPress:function(){}};n.onClick=function(e,t,s){s.target!==this.anchorElement&&(shmi.log("[SelectBox] click on container",1),this.open?this.containerElement.blur():(shmi.removeClass(this.containerElement,"hidden"),this.open=!0,setTimeout(function(){this.containerElement.focus(),shmi.visuals.session.FocusElement=this.containerElement}.bind(this),shmi.c("DECOUPLE_TIMEOUT"))))}.bind(this);var a={onPress:function(t,s,n){n.currentTarget===e.containerElement&&(e.clickedInside=!0)},onRelease:function(t,s,n){n.currentTarget===e.containerElement&&(e.clickedInside=!1)}};a.onLeave=function(){shmi.log("[SelectBox] onLeave container-element",0),this.containerElement.blur(),this.highlightIndex=-1}.bind(this),shmi.addClass(this.containerElement,"hidden"),-1===this.selected?this.setSelected(null):this.setSelected(this.optionElements[this.config.selected]),this.inputListeners.push(new shmi.visuals.io.MouseListener(this.containerElement,a)),this.inputListeners.push(new shmi.visuals.io.TouchListener(this.element,n)),this.inputListeners.push(new shmi.visuals.io.MouseListener(this.element,n)),this.onPressEnter=function(t){var s=t.key?t.key:t.code;!(this.element===document.activeElement&&!this.locked)||"Enter"!==s&&"NumpadEnter"!==s||(shmi.log("[SelectBox] click on container",1),this.open?this.containerElement.blur():(shmi.removeClass(this.containerElement,"hidden"),this.open=!0,setTimeout((function(){e.containerElement.focus(),shmi.visuals.session.FocusElement=e.containerElement}),shmi.c("DECOUPLE_TIMEOUT"))))}.bind(this),this.element.addEventListener("keydown",this.onPressEnter),this.keydownHandler=function(e){var t=e.key?e.key:e.code;if(shmi.log("[SelectBox] keydown event: "+t,1),this.highlightIndex<0&&(this.highlightIndex=this.getCurrentIndex()),shmi.log("[SelectBox] hightlight index "+this.highlightIndex,1),"Escape"===t)this.optionElements.forEach((function(e){shmi.removeClass(e,"highlighted")})),shmi.addClass(this.containerElement,"hidden"),this.open=!1,this.highlightIndex=-1;else if("Enter"===t||"NumpadEnter"===t){if(-1!==this.highlightIndex){shmi.log("[SelectBox] click on element",0);var s=this.optionElements[this.highlightIndex],n=this.value,a=parseInt(s.getAttribute("data-value"));this.value=this.config.options[a].value,this.setSelected(s),this.updateValue(),shmi.addClass(this.containerElement,"hidden"),this.open=!1,this.highlightIndex=-1,this.value!==n&&this.fire("change",{value:this.value}),this.optionElements.forEach((function(e){shmi.removeClass(e,"highlighted")})),this.highlightIndex=-1}}else"ArrowUp"===t?(this.optionElements[this.highlightIndex]&&shmi.removeClass(this.optionElements[this.highlightIndex],"highlighted"),this.highlightIndex>0?this.highlightIndex--:this.highlightIndex=this.optionElements.length-1,this.optionElements[this.highlightIndex]&&shmi.addClass(this.optionElements[this.highlightIndex],"highlighted")):"ArrowDown"===t&&(this.optionElements[this.highlightIndex]&&shmi.removeClass(this.optionElements[this.highlightIndex],"highlighted"),this.highlightIndex<this.optionElements.length-1?this.highlightIndex++:this.highlightIndex=0,this.optionElements[this.highlightIndex]&&shmi.addClass(this.optionElements[this.highlightIndex],"highlighted"));return!1}.bind(this),this.containerElement.addEventListener("keydown",this.keydownHandler)}else shmi.log("[SelectBox] no selected element provided",3);else shmi.log("[SelectBox] no option elements provided",3);else shmi.log("[SelectBox] no options anchor element provided",3);else shmi.log("[SelectBox] no options element provided",3)},setOptions:function(e){var t=this;t.config.options=e,rebuildOptions(t,t.active),t.setValue(t.getValue())},getOptions:function(){return shmi.cloneObject(this.config.options)},setSelected:function(e){if(void 0!==e){for(var t=-1,s=function(){var e="";if(Array.isArray(this.config.options))for(var s=0;s<this.config.options.length;s++)if(this.config.options[s].value===this.value){e=this.config.options[s].label,t=s;break}return e}.bind(this),n=0;n<this.optionElements.length;n++)shmi.removeClass(this.optionElements[n],"select-box-selected");if(null===e)this.selectedValField.textContent=shmi.localize(this.config["no-selection-label"]),this.selectedTempl.setAttribute("data-value",-1),shmi.removeClass(this.selectedTempl,"option-icon-only option-icon-and-text");else{shmi.addClass(e,"select-box-selected"),this.selectedValField.textContent=shmi.localize(s()),this.selectedTempl.setAttribute("data-value",t);var a=this.config.options[t],l=shmi.getUiElement("option-icon",this.selectedTempl),o=!1;a&&l?(o=setIcon(l,a))&&a.label?shmi.addClass(this.selectedTempl,"option-icon-and-text"):o?shmi.addClass(this.selectedTempl,"option-icon-only"):shmi.removeClass(this.selectedTempl,"option-icon-only option-icon-and-text"):l&&shmi.removeClass(this.selectedTempl,"option-icon-only option-icon-and-text")}this.selected=t}},getCurrentIndex:function(){return this.selected},updateValue:function(){this.config.item&&shmi.visuals.session.ItemManager.writeValue(this.config.item,this.value)},onEnable:function(){this.inputListeners.concat(this.optionInputListeners).forEach((function(e){e.enable()})),this.element.setAttribute("tabindex",0),this.config.item&&(this._subscriptionTargetId=shmi.visuals.session.ItemManager.subscribeItem(this.config.item,this)),shmi.log("[SelectBox] enabled",1)},onDisable:function(){this.config.item&&shmi.visuals.session.ItemManager.unsubscribeItem(this.config.item,this._subscriptionTargetId),this.inputListeners.concat(this.optionInputListeners).forEach((function(e){e.disable()})),this.element.removeEventListener("keydown",this.onPressEnter),shmi.log("[SelectBox] disabled",1)},onDelete:function(){this.containerElement&&(this.containerElement.removeEventListener("blur",this.blurHandler),this.containerElement.removeEventListener("keydown",this.keydownHandler))},onLock:function(){this.locked=!0,shmi.addClass(this.containerElement,"hidden"),this.highlightIndex=-1,this.inputListeners.concat(this.optionInputListeners).forEach((function(e){e.disable()})),shmi.addClass(this.element,"locked"),shmi.log("[SelectBox] locked",1)},onUnlock:function(){this.locked=!1,this.inputListeners.concat(this.optionInputListeners).forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked"),shmi.log("[SelectBox] unlocked",1)},onSetValue:function(e){shmi.log("[SelectBox] setting value...: "+e,0);for(var t=!1,s=this.value,n=0;n<this.config.options.length;n++)if(this.config.options[n].value===e){this.value=e,this.setSelected(this.optionElements[n]),this.selected=n,t=!0;break}t||(this.value=null,this.setSelected(null),this.selected=-1),this.value!==s&&this.fire("change",{value:this.value}),shmi.log("[SelectBox] value set: "+e,1)},getValue:function(){return this.value},setLabel:function(e){this.config["auto-label"]&&this.labelElement&&(this.labelElement.textContent=shmi.localize(e))}},shmi.extend(shmi.visuals.controls.SelectBox,shmi.visuals.core.BaseControl)}(),shmi.pkg("visuals.controls"),shmi.visuals.controls.SelectDate=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","select-date"),shmi.def(this.config,"template","default/select-date"),shmi.def(this.config,"name",null),shmi.def(this.config,"daynames",["${V_SUN_SHORT}","${V_MON_SHORT}","${V_TUE_SHORT}","${V_WED_SHORT}","${V_THU_SHORT}","${V_FRI_SHORT}","${V_SAT_SHORT}"]),shmi.def(this.config,"daynames-long",["${V_SUN}","${V_MON}","${V_TUE}","${V_WED}","${V_THU}","${V_FRI}","${V_SAT}"]),shmi.def(this.config,"monthnames",["${V_JAN}","${V_FEB}","${V_MAR}","${V_APR}","${V_MAY}","${V_JUN}","${V_JUL}","${V_AUG}","${V_SEP}","${V_OCT}","${V_NOV}","${V_DEC}"]),shmi.def(this.config,"dateformat","${V_DATEFORMAT}"),shmi.def(this.config,"label","select-date"),shmi.def(this.config,"auto-label",!0),this.active=!1,this.listeners=[],this.value=null,this.date=new Date,this.selectedDate=new Date,this.selectedDate.setHours(0,0,0,0),this.startup()},shmi.visuals.controls.SelectDate.prototype={uiType:"select-date",events:["change"],getClassName:function(){return"SelectDate"},onInit:function(){if(this.labelElement=shmi.getUiElement("label",this.element),this.labelElement&&(this.labelElement.textContent=shmi.localize(this.config.label)),this.calendarElement=shmi.getUiElement("calendar",this.element),this.calendarElement)if(this.daySelectElement=shmi.getUiElement("day-select",this.element),this.daySelectElement)if(this.selectedElement=shmi.getUiElement("selected-date",this.element),this.selectedElement)if(this.selectedElement=shmi.getUiElement("value",this.selectedElement),this.selectedElement)if(this.headerElement=shmi.getUiElement("day-header",this.element),this.headerElement)if(this.dayNameElements=shmi.getUiElements("day-name",this.headerElement),this.dayNameElements||7===this.dayNameElements.length)if(this.mSelect=shmi.getUiElement("month-select",this.element),this.mSelect)if(this.ySelect=shmi.getUiElement("year-select",this.element),this.ySelect){var e=shmi.getUiElement("previous",this.mSelect);this.mCur=shmi.getUiElement("current",this.mSelect);var t=shmi.getUiElement("next",this.mSelect),s=shmi.getUiElement("previous",this.ySelect);this.yCur=shmi.getUiElement("current",this.ySelect);var n=shmi.getUiElement("next",this.ySelect);if(e&&this.mCur&&t&&s&&this.yCur&&n){for(var a=0;a<this.dayNameElements.length;a++){var l=6===a?0:a+1;this.dayNameElements[a].textContent=shmi.localize(this.config.daynames[l])}this.calendarElement.setAttribute("tabindex","0");var o={onPress:function(){}};o.onClick=function(e,t,s){this.date.setFullYear(this.date.getYear()+1900,this.date.getMonth()-1),this.updateCalendar()}.bind(this),this.listeners.push(new shmi.visuals.io.MouseListener(e,o)),this.listeners.push(new shmi.visuals.io.TouchListener(e,o));var r={onPress:function(){}};r.onClick=function(e,t,s){this.date.setFullYear(this.date.getYear()+1900,this.date.getMonth()+1),this.updateCalendar()}.bind(this),this.listeners.push(new shmi.visuals.io.MouseListener(t,r)),this.listeners.push(new shmi.visuals.io.TouchListener(t,r));var c={onPress:function(){}};c.onClick=function(e,t,s){this.date.setFullYear(this.date.getYear()+1900-1,this.date.getMonth()),this.updateCalendar()}.bind(this),this.listeners.push(new shmi.visuals.io.MouseListener(s,c)),this.listeners.push(new shmi.visuals.io.TouchListener(s,c));var u={onPress:function(){}};u.onClick=function(e,t,s){this.date.setFullYear(this.date.getYear()+1900+1,this.date.getMonth()),this.updateCalendar()}.bind(this),this.listeners.push(new shmi.visuals.io.MouseListener(n,u)),this.listeners.push(new shmi.visuals.io.TouchListener(n,u)),this.dayElements=shmi.getUiElements("day",this.element);var m={};this.pressedElement=null,m.onPress=function(e,t,s){shmi.addClass(s.target,"pressed"),this.pressedElement=s.target},m.onRelease=function(e,t,s){shmi.removeClass(this.pressedElement,"pressed")},m.onClick=function(e,t,s){var n=s.target;shmi.hasClass(n,"previous-month-day")?(this.date.setFullYear(this.date.getYear()+1900,this.date.getMonth()-1),this.selectedDate.setFullYear(this.date.getYear()+1900,this.date.getMonth(),n.textContent)):shmi.hasClass(n,"current-month-day")?(this.date.setFullYear(this.date.getYear()+1900,this.date.getMonth()),this.selectedDate.setFullYear(this.date.getYear()+1900,this.date.getMonth(),n.textContent)):shmi.hasClass(n,"next-month-day")&&(this.date.setFullYear(this.date.getYear()+1900,this.date.getMonth()+1),this.selectedDate.setFullYear(this.date.getYear()+1900,this.date.getMonth(),n.textContent)),this.updateCalendar(),this.config.item&&shmi.visuals.session.ItemManager.writeValue(this.config.item,this.value),shmi.addClass(this.calendarElement,"hidden"),this.open=!1}.bind(this),this.listeners.push(new shmi.visuals.io.MouseListener(this.daySelectElement,m)),this.listeners.push(new shmi.visuals.io.TouchListener(this.daySelectElement,m)),shmi.addClass(this.calendarElement,"hidden"),this.open=!1;var h={};h.onClick=function(){this.open?this.calendarElement.blur():(shmi.removeClass(this.calendarElement,"hidden"),this.open=!0,setTimeout(function(){this.calendarElement.focus(),shmi.visuals.session.FocusElement=this.calendarElement}.bind(this),shmi.c("DECOUPLE_TIMEOUT")))}.bind(this),this.listeners.push(new shmi.visuals.io.MouseListener(this.element,h)),this.listeners.push(new shmi.visuals.io.TouchListener(this.element,h)),this.blurHandler=function(){shmi.addClass(this.calendarElement,"hidden"),setTimeout(function(){this.open=!1}.bind(this),shmi.c("DECOUPLE_TIMEOUT"))}.bind(this),this.calendarElement.addEventListener("blur",this.blurHandler);var d={onPress:function(){},onClick:function(){},onRelease:function(){}};this.listeners.push(new shmi.visuals.io.MouseListener(this.calendarElement,d)),this.listeners.push(new shmi.visuals.io.TouchListener(this.calendarElement,d)),this.updateCalendar()}else shmi.log("[SelectDate] not all month & year select elements provided",3)}else shmi.log("[SelectDate] no year-select element provided",3);else shmi.log("[SelectDate] no month-select element provided",3);else shmi.log("[SelectDate] no day-name elements, or not the right count (7) provided",3);else shmi.log("[SelectDate] no day-header element provided",3);else shmi.log("[SelectDate] no selected-date element provided",3);else shmi.log("[SelectDate] no selected-date element provided",3);else shmi.log("[SelectDate] no day-select element provided",3);else shmi.log("[SelectDate] no calendar element provided",3)},updateCalendar:function(){var e=this,t=shmi.requires("visuals.tools.date"),s=e.value,n=new Date(1e3*this.value);n.setFullYear(this.selectedDate.getYear()+1900,this.selectedDate.getMonth(),this.selectedDate.getDate()),this.value=n.getTime()/1e3,shmi.log("[SelectDate] selected time: "+this.value,0);var a=this.date.getMonth(),l=this.date.getYear()+1900,o=new Date(l,a,1).getDay(),r=0;this.mCur.textContent=shmi.localize(this.config.monthnames[a]),this.yCur.textContent=l,r=1===o?7:0===o?6:o-1;for(var c=this.getDaysOfMonth(a,l),u=this.getDaysOfMonth(a+1,l),m=shmi.getUiElements("day",this.element),h=c-r+1,d=0;d<r;d++)m[d].className="previous-month-day",m[d].textContent=h,new Date(l,a-1,h).getTime()===this.selectedDate.getTime()?shmi.addClass(m[d],"selected"):shmi.removeClass(m[d],"selected"),h++;for(h=1,d=r;d<u+r;d++)m[d].className="current-month-day",m[d].textContent=h,new Date(l,a,h).getTime()===this.selectedDate.getTime()?shmi.addClass(m[d],"selected"):shmi.removeClass(m[d],"selected"),h++;for(h=1,d=u+r;d<m.length;d++)m[d].className="next-month-day",m[d].textContent=h,new Date(l,a+1,h).getTime()===this.selectedDate.getTime()?shmi.addClass(m[d],"selected"):shmi.removeClass(m[d],"selected"),h++;var f=shmi.localize(this.config.dateformat);"string"==typeof f?this.selectedElement.textContent=t.formatDateTime(this.selectedDate,{datestring:f}):this.selectedElement.innerHTML="&nbsp;",s!==e.value&&e.fire("change",{value:e.value})},getDaysOfMonth:function(e,t){return new Date(t,e,0).getDate()},onEnable:function(){this.config.item&&(this._subscriptionTargetId=shmi.visuals.session.ItemManager.subscribeItem(this.config.item,this));for(var e=0;e<this.listeners.length;e++)this.listeners[e].enable();shmi.log("[SelectDate] enabled",1)},onDisable:function(){this.config.item&&shmi.visuals.session.ItemManager.unsubscribeItem(this.config.item,this._subscriptionTargetId);for(var e=0;e<this.listeners.length;e++)this.listeners[e].disable();shmi.log("[SelectDate] disabled",1)},onDelete:function(){this.blurHandler&&this.calendarElement.removeEventListener("blur",this.blurHandler)},onLock:function(){shmi.addClass(this.calendarElement,"hidden"),this.open=!1;for(var e=0;e<this.listeners.length;e++)this.listeners[e].disable();shmi.addClass(this.element,"locked"),shmi.log("[SelectDate] locked",1)},onUnlock:function(){for(var e=0;e<this.listeners.length;e++)this.listeners[e].enable();shmi.removeClass(this.element,"locked"),shmi.log("[SelectDate] unlocked",1)},onSetValue:function(e){e=parseInt(e);var t=new Date(1e3*e),s=this.value;this.value=e,this.date.setFullYear(t.getYear()+1900,t.getMonth()),this.selectedDate.setFullYear(t.getYear()+1900,t.getMonth(),t.getDate(),t.getHours(),t.getMinutes(),t.getSeconds()),this.updateCalendar(),s!==this.value&&this.fire("change",{value:this.value})},getValue:function(){return this.value},setLabel:function(e){var t=this;t.config["auto-label"]&&t.labelElement&&(t.labelElement.textContent=shmi.localize(e))}},shmi.extend(shmi.visuals.controls.SelectDate,shmi.visuals.core.BaseControl),function(){function rebuildOptions(e,t){e.optionInputListeners.forEach((function(e){e.disable()})),e.optionInputListeners=[],e.optionRootElements.forEach((function(t){e.element.removeChild(t)})),e.optionRootElements=[];var s=function makeOptionInputHandler(e){return{onPress:function onPress(e,t,s){shmi.addClass(s.currentTarget,"pressed")},onRelease:function onRelease(t,s,n){for(var a=0;a<e.optionElements.length;a++)shmi.removeClass(e.optionElements[a],"pressed")},onClick:function onClick(t,s,n){var a=e.optionElements.indexOf(n.currentTarget),l=e.config.options[a]?e.config.options[a].value:null,o=l!==e.value;a<0?console.error(e.uiType,"could not match clicked option"):(e.value=l,e.setSelected(n.currentTarget),e.updateValue(),o&&e.fire("change",{value:e.value}))}}}(e);e.config.options.forEach((function(t,n){var a=document.createElement("div");a.innerHTML=e.templateHtml;var l=shmi.getUiElement("option",a);l.setAttribute("data-value",t.value),shmi.getUiElement("label",l).innerHTML=shmi.localize(t.label),(t.tooltip||t["icon-title"])&&a.firstChild.setAttribute("title",shmi.localize(t.tooltip||t["icon-title"]));var o=shmi.getUiElement("option-icon",l);if(o)if(t["icon-src"]){if("IMG"!==o.tagName){var r=document.createElement("IMG");r.className=o.className,o.parentNode.insertBefore(r,o),o.parentNode.removeChild(o),o=r}o.setAttribute("src",t["icon-src"]),t.label?shmi.addClass(l,"option-icon-and-text"):shmi.addClass(l,"option-icon-only")}else if(t["icon-class"]){if("DIV"!==o.tagName){var c=document.createElement("DIV");c.className=o.className,o.parentNode.insertBefore(c,o),o.parentNode.removeChild(o),o=c}shmi.addClass(o,t["icon-class"]),t.label?shmi.addClass(l,"option-icon-and-text"):shmi.addClass(l,"option-icon-only")}e.optionInputListeners.push(new shmi.visuals.io.MouseListener(l,s)),e.optionInputListeners.push(new shmi.visuals.io.TouchListener(l,s)),e.element.appendChild(a.firstChild),e.optionElements.push(l),e.optionRootElements.push(a.firstChild)})),t&&e.optionInputListeners.forEach((function(e){e.enable()}))}shmi.pkg("visuals.controls"),shmi.visuals.controls.SelectRadio=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","select-radio"),shmi.def(this.config,"template","default/select-radio"),shmi.def(this.config,"name",null),shmi.def(this.config,"selected",-1),shmi.def(this.config,"label","select-radio"),shmi.def(this.config,"options",[]),shmi.def(this.config,"auto-label",!0),shmi.def(this.config,"icon-src",null),shmi.def(this.config,"icon-title",null),shmi.def(this.config,"icon-class",null),shmi.def(this.config,"show-icon",!1),shmi.def(this.config,"show-text",!0),this.active=!1,this.value=-1,this.selectedIndex=0,this.selectedElement=null,this.highlightIndex=-1,this.templateHtml=null,this.optionElements=[],this.inputListeners=[],this.optionInputListeners=[],this.optionRootElements=[],this.startup()},shmi.visuals.controls.SelectRadio.prototype={uiType:"select-radio",events:["change"],tooltipProperties:["icon-title"],getClassName:function(){return"SelectRadio"},onTemplate:function(e,t,s){if(!t){if(!this.element)return void shmi.log("[SelectRadio] no base element provided",3);this.templateHtml=e}s()},onInit:function(){var e=this;if(e.config.options){shmi.log("[SelectRadio] options newly defined",1),e.element.innerHTML="",e.config["show-text"]&&e.config["show-icon"]?shmi.addClass(e.element,"icon-and-text"):e.config["show-icon"]&&shmi.addClass(e.element,"icon-only");var t=document.createElement("div"),s=document.createElement("DIV");shmi.addClass(s,"label-area"),e.element.appendChild(s),t.setAttribute("data-ui","label"),t.setAttribute("class","label"),void 0!==e.config.label&&(t.textContent=shmi.localize(e.config.label));var n=null;e.config["icon-src"]?((n=document.createElement("IMG")).setAttribute("data-ui","option-icon"),shmi.addClass(n,"control-icon icon"),n.setAttribute("src",e.config["icon-src"]),s.appendChild(n)):e.config["icon-class"]&&((n=document.createElement("DIV")).setAttribute("data-ui","option-icon"),shmi.addClass(n,"control-icon icon"),shmi.addClass(n,e.config["icon-class"]),s.appendChild(n)),s.appendChild(t),rebuildOptions(e)}else shmi.log("[SelectRadio] no options defined in config",1)},setOptions:function(e){var t=this;t.config.options=e,t.value=-1,t.selectedIndex=0,t.selectedElement=null,t.highlightIndex=-1,rebuildOptions(t,t.active)},getOptions:function(){return shmi.cloneObject(this.config.options)},setSelected:function(e){for(var t=0;t<this.optionElements.length;t++)shmi.removeClass(this.optionElements[t],"selected");this.selectedElement=e,e&&shmi.addClass(this.selectedElement,"selected")},getCurrentIndex:function(){for(var e=-1,t=0;t<this.optionElements.length;t++)if(this.optionElements[t]===this.selectedElement){e=t;break}return e},updateValue:function(){this.config.item&&shmi.visuals.session.ItemManager.writeValue(this.config.item,this.value)},onEnable:function(){this.config.item&&(this._subscriptionTargetId=shmi.visuals.session.ItemManager.subscribeItem(this.config.item,this)),this.inputListeners.concat(this.optionInputListeners).forEach((function(e){e.enable()})),shmi.log("[SelectRadio] enabled",1)},onDisable:function(){this.config.item&&shmi.visuals.session.ItemManager.unsubscribeItem(this.config.item,this._subscriptionTargetId),this.inputListeners.concat(this.optionInputListeners).forEach((function(e){e.disable()})),shmi.log("[SelectRadio] disabled",1)},onLock:function(){this.locked=!0,this.highlightIndex=-1,this.inputListeners.concat(this.optionInputListeners).forEach((function(e){e.disable()})),shmi.addClass(this.element,"locked"),shmi.log("[SelectRadio] locked",1)},onUnlock:function(){this.locked=!1,this.inputListeners.concat(this.optionInputListeners).forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked"),shmi.log("[SelectRadio] unlocked",1)},onSetValue:function(e){var t=this.value!==e;this.value=e;for(var s=!1,n=0;n<this.config.options.length;n++)if(this.config.options[n].value===e){this.setSelected(this.optionElements[n]),s=!0;break}s||this.setSelected(null),shmi.log("[SelectRadio] value set: "+e,1),t&&this.fire("change",{value:this.value})},getValue:function(){return this.value},setLabel:function(e){var t=shmi.getUiElement("label",this.element);this.config["auto-label"]&&t&&(t.textContent=shmi.localize(e))}},shmi.extend(shmi.visuals.controls.SelectRadio,shmi.visuals.core.BaseControl)}(),function(){"use strict";var e="select-time",t={"class-name":e,name:null,template:"default/select-time",label:e,"numpad-enabled":!1},s=shmi.requires("visuals.tools.logging").createLogger(e,!0,!1),n=s.fLog,a=s.log;function assertType(e,t,s){if(!function checkType(e,t){if(Array.isArray(t)){if(!(e in t))return!1}else if(t!==function getType(e){return Array.isArray(e)?"array":null===e?"null":typeof e}(e))return!1;return!0}(e,t))throw TypeError(s)}function updateValue(e){var t=function computeNewValue(e){var t=e.vars,s=new Date(1e3*t.value);return e.config.isUTC?(s.setHours(t.hours),s.setMinutes(t.minutes),s.setSeconds(t.seconds)):(s.setUTCHours(t.hours),s.setUTCMinutes(t.minutes),s.setUTCSeconds(t.seconds)),s.getTime()/1e3}(e);e.config.item&&(e.vars.itemNeedsString?e.imports.im.writeValue(e.config.item,String(t)):e.imports.im.writeValue(e.config.item,t)),e.vars.value!==t&&(e.vars.value=t,e.fire("change",{value:t})),updateInputFields(e.vars)}function integerToGroup(e,t){return(t+e%t)%t}function addSeconds(e,t){assertType(t,"number"),e.vars.inputFields[0].blur(),e.vars.seconds=integerToGroup(e.vars.seconds+t,60),updateValue(e)}function addMinutes(e,t){assertType(t,"number"),e.vars.inputFields[1].blur(),e.vars.minutes=integerToGroup(e.vars.minutes+t,60),updateValue(e)}function addHours(e,t){assertType(t,"number"),e.vars.inputFields[2].blur(),e.vars.hours=integerToGroup(e.vars.hours+t,24),updateValue(e)}function validateGeneric(e,t,s,n){RegExp(t).test(n.textContent)?(e.vars[s]=parseInt(n.textContent),updateValue(e),e.vars[s]<10&&1===n.textContent.length&&(n.textContent="0"+n.textContent)):e.vars[s]<10?n.textContent="0"+e.vars[s]:n.textContent=e.vars[s]}function inputKeypressListener(e,t){13===Number(t.keyCode)&&(t.preventDefault(),window.getSelection().removeAllRanges(),e.blur())}function inputKeyupListener(e,t){13===Number(t.keyCode)||e.textContent.length>1&&(t.preventDefault(),window.getSelection().removeAllRanges(),e.blur())}function inputBlurListener(e,t,s){window.getSelection().removeAllRanges(),e.setAttribute("contenteditable",!1),shmi.removeClass(e,"selectableText"),t(e)}function addClickTouchListener(e,t,s){e.listeners.push(new shmi.visuals.io.MouseListener(t,s)),e.listeners.push(new shmi.visuals.io.TouchListener(t,s))}function addEventListener(e,t,s,n){t.addEventListener(s,n),e.evListeners.push({element:t,eventType:s,listener:n})}function createInputField(e,t,s,a){if(t){var l=shmi.requires("visuals.session.config"),o=l.keyboard&&l.keyboard.enabled;(a=shmi.cloneObject(a)).callback=function(e){t.textContent=e,s(t)},addClickTouchListener(e,t,{onClick:function onClick(){if(a.numpadEnabled||o)a.value=t.textContent,shmi.numpad(a);else{shmi.addClass(t,"selectableText"),t.setAttribute("contenteditable",!0);var e=document.createRange();t.focus(),t.firstChild&&t.firstChild instanceof Text?(e.setStart(t.firstChild,0),e.setEnd(t.firstChild,t.firstChild.length),window.getSelection().removeAllRanges(),window.getSelection().addRange(e)):n("elem not found")}}}),t.style.overflow="hidden",addEventListener(e,t,"keypress",inputKeypressListener.bind(null,t)),addEventListener(e,t,"keyup",inputKeyupListener.bind(null,t)),addEventListener(e,t,"blur",inputBlurListener.bind(null,t,s))}else n("no base element provided")}function setupRockerComponent(e,t){var s=shmi.getUiElement(t.uiElementName,e.element);if(!s)return n("Element not found: "+t.uiElementName),!1;var a=shmi.getUiElement("previous",s);if(!a)return n("No UI element found for "+t.uiElementName+".previous"),!1;var l=shmi.getUiElement("current",s);if(!l)return n("No UI element found for "+t.uiElementName+".current"),!1;var o=shmi.getUiElement("next",s);return o?(createInputField(e.vars,l,t.inputValidator.bind(e),{min:0,max:t.max,label:t.label,numpadEnabled:e.config["numpad-enabled"]||!1}),addClickTouchListener(e.vars,a,{onPress:shmi.addClass.bind(null,a,"pressed"),onRelease:shmi.removeClass.bind(null,a,"pressed"),onClick:t.addHandler.bind(null,-1)}),addClickTouchListener(e.vars,o,{onPress:shmi.addClass.bind(null,o,"pressed"),onRelease:shmi.removeClass.bind(null,o,"pressed"),onClick:t.addHandler.bind(null,1)}),e.vars.inputFields.push(l),!0):(n("No UI element found for "+t.uiElementName+".next"),!1)}function updateInputFields(e){e.inputFields[0].textContent=e.hours>9?e.hours:"0"+e.hours,e.inputFields[1].textContent=e.minutes>9?e.minutes:"0"+e.minutes,e.inputFields[2].textContent=e.seconds>9?e.seconds:"0"+e.seconds}var l={className:"SelectTime",uiType:e,isContainer:!1,config:t,configSchema:null,vars:{value:0,hours:0,minutes:0,seconds:0,listeners:[],evListeners:[],inputFields:[],itemNeedsString:!1},imports:{im:"visuals.session.ItemManager"},events:["change"],prototypeExtensions:{onInit:function(){var e=shmi.getUiElement("label",this.element);e&&(e.textContent=shmi.localize(this.config.label)),setupRockerComponent(this,{uiElementName:"hour-select",inputValidator:validateGeneric.bind(null,this,/^[0-1]?[0-9]$|^2[0-3]$/,"hours"),addHandler:addHours.bind(null,this),max:23,label:"${V_HOURS}"}),setupRockerComponent(this,{uiElementName:"minute-select",inputValidator:validateGeneric.bind(null,this,/^[0-5]?[0-9]$/,"minutes"),addHandler:addMinutes.bind(null,this),max:59,label:"${V_MINUTES}"}),setupRockerComponent(this,{uiElementName:"second-select",inputValidator:validateGeneric.bind(null,this,/^[0-5]?[0-9]$/,"seconds"),addHandler:addSeconds.bind(null,this),max:59,label:"${V_SECONDS}"}),updateInputFields(this.vars)},onDelete:function(){this.vars.evListeners.forEach((function(e){e.element.removeEventListener(e.eventType,e.listener)})),this.vars.evListeners=[],this.vars.listeners=[]},onEnable:function(){this.config.item&&(this.vars._subscriptionTargetId=this.imports.im.subscribeItem(this.config.item,this)),this.vars.listeners.forEach((function(e){e.enable()}))},onDisable:function(){this.config.item&&this.imports.im.unsubscribeItem(this.config.item,this.vars._subscriptionTargetId),this.vars.listeners.forEach((function(e){e.disable()}))},onLock:function(){this.vars.inputFields.forEach((function(e){e.blur()})),this.vars.listeners.forEach((function(e){e.disable()})),shmi.addClass(this.element,"locked"),a("locked")},onUnlock:function(){this.vars.listeners.forEach((function(e){e.enable()})),shmi.removeClass(this.element,"locked"),a("unlocked")},onSetValue:function(e,t,s){e=parseInt(e);var n=new Date(1e3*e);this.vars.itemNeedsString="string"==typeof e,this.config.isUTC?(this.vars.hours=n.getHours(),this.vars.minutes=n.getMinutes(),this.vars.seconds=n.getSeconds()):(this.vars.hours=n.getUTCHours(),this.vars.minutes=n.getUTCMinutes(),this.vars.seconds=n.getUTCSeconds()),updateInputFields(this.vars),this.vars.value!==e&&(this.vars.value=e,this.fire("change",{value:e}))},onSetProperties:function(e,t,s){},setLabel:function(e){var t=shmi.getUiElement("label",this.element);this.config["auto-label"]&&t&&(t.textContent=shmi.localize(e))},getValue:function(){return this.vars.value},getHours:function(){return this.vars.hours},getMinutes:function(){return this.vars.minutes},getSeconds:function(){return this.vars.seconds}}};shmi.requires("visuals.tools.control-generator").generate(l)}(),function(){"use strict";var e={BOOLEANS_TRUE:[1,"1","true",!0]},t="simple-table",s={"class-name":t,name:null,template:"custom/simple-table","grid-name":null,pager:{offset:0,"rows-per-page":50,"page-sizes":[{value:10},{value:50},{value:100},{value:250}]},"use-designer-mapping":!1,"col-mapping":[],table:{"edit-icon":"",fields:[],"edit-fields":!1,"conditional-fields":!1,select:"multi",sort:{col:null,order:"ASC"},"default-filters":{},"default-col-width":150,width:null,height:null}},n=shmi.requires("visuals.tools.logging").createLogger(t,!0,!1);n.fLog,n.log;function addTableWrapperScrollListener(e){e.vars.tbodyElementWrapper.onscroll=function(){var t=e.vars.tbodyElementWrapper.scrollLeft;e.vars.theadElementWrapper.scrollLeft=t,e.vars.tfilterElementWrapper.scrollLeft=t,e.vars.theadElementWrapper.scrollLeft!==t&&(e.vars.tbodyElementWrapper.scrollLeft=e.vars.theadElementWrapper.scrollLeft)}}function removeTableWrapperScrollListener(e){e.vars.tbodyElementWrapper.onscroll=null}function setDataGridControls(e){e.vars.tableUiElements.forEach((function(t,s){setRowControls(s,e)}))}function Voter(e,t,s){this.value=e,this.operator=t,this.operand=s,this.vote=function vote(){var e=this;return!!function validate(e){var t;return-1===["contains","<",">","<=",">=","==","!="].indexOf(e.operator)?(t=shmi.evalString("[simple-table] invalid operator <%= operator %>",{operator:e.operator}),shmi.log(t,3),!1):-1!==["number","boolean","string"].indexOf(typeof e.operand)||(t=shmi.evalString("[simple-table] invalid type [<%= type %>] of the operand",{type:typeof e.operand}),shmi.log(t,3),!1)}(e)&&("contains"===e.operator?Boolean(-1!==String(e.value).indexOf(e.operand)):(-1!==["number","boolean"].indexOf(typeof e.operand)?e.value=Number(e.value):e.value=String(e.value),function compare(e){switch(e.operator){case"<":return Boolean(e.value<e.operand);case">":return Boolean(e.value>e.operand);case"<=":return Boolean(e.value<=e.operand);case">=":return Boolean(e.value>=e.operand);case"==":case"!=":return"string"==typeof e.value?Boolean(e.value===String(e.operand)):Boolean(e.value===e.operand)}return!1}(e)))}}function setRowControls(e,t,s){var n=t.vars.dataGrid.getRowData(e),a=function getConditionalConfigForRow(e,t){var s=getByPath("conditional-fields",t.config.table),n={};return s&&s.some((function(s){var a=[];return s.conditions.forEach((function(s){var n,l=t.vars.dataGrid.getFields().indexOf(s.field);n=new Voter(e[l].value,s.operator,s.operand).vote(),a.push(n)})),-1===a.indexOf(!1)&&(n=s.fields,!0)})),n}(n,t);t.config.table.fields.forEach((function(l,o){var r,c,u="simple-table-item-"+e+"-"+o,m=shmi.getUiElement(u,t.element);return m?l.controls?(deleteControls(t,e,o),m.textContent="",t.vars.tableUiElements[e][o]=m,s&&getByPath("edit-fields."+o+".controls",t.config.table)&&(r=getByPath("edit-fields."+o+".controls",t.config.table)),!r&&a[o]&&(r=a[o].controls),void(r=r||l.controls).forEach((function(s){var a=function addControlToElement(e,t,s,n){var a,l;if("mapping"in t==!1)return a=shmi.evalString("[simple-table] no mapping for control <%= uiType %>",{uiType:t["ui-type"]}),shmi.log(a,3),null;return l=shmi.cloneObject(t.config),t.mapping.forEach((function(e){var o=n.vars.dataGrid.getFields().indexOf(e.field);"value"in e?l[e.option]=shmi.localize(e.value):s[o]&&s[o].item?l[e.option]=s[o].item.name:(a=shmi.evalString("[simple-table] Bad mapping defined for control <%= uiType %>: <%= field %>",{field:e.field,uiType:t["ui-type"]}),shmi.log(a,3))})),shmi.createControl(t["ui-type"],e,l,"DIV")}(m,s,n,t);!function saveControl(e,t,s,n){var a,l;null!==e&&((l=getByPath(a=t+"."+s,n.vars.controls,[])).push(e),setByPath(a,n.vars.controls,l))}(a,e,o,t)}))):(c=shmi.evalString("[simple-table] no controls defined for the cell <%= dataUi %>",{dataUi:u}),void shmi.log(c,3)):(c=shmi.evalString("[simple-table] Cannot find element <%= dataUi %>",{dataUi:u}),void shmi.log(c,3))}))}function deleteControls(e,t,s){var n;void 0===t?Object.keys(e.vars.controls).forEach((function(t){deleteControls(e,t,s)})):void 0===s&&Object.keys(getByPath(t,e.vars.controls,[])).forEach((function(s){deleteControls(e,t,s)})),getByPath(n=t+"."+s,e.vars.controls,[]).forEach((function(e){shmi.deleteControl(e,!0)})),setByPath(n,e.vars.controls,[])}function onDataGridChange(e,t){e&&"OK"===e.status&&(t.vars.isTableToCleanup&&(!function cleanupTabContent(e){deleteControls(e),function clearTableDOM(e){e.vars.theadElement.innerHTML="",e.vars.tfilterElement.innerHTML="",e.vars.tbodyElement.innerHTML=""}(e)}(t),t.vars.isTableToCleanup=!1),t.vars.dataGrid=t.vars.dgMan.getGrid(t.config["grid-name"]),function prepareTable(e){var t=document.createElement("colgroup"),s=document.createElement("thead"),n=document.createElement("tbody"),a="",l={colGroupHTML:"",theadHTML:"<tr>",tfilterHTML:"<tr>",colwidth:e.config.table["default-col-width"],tabwidth:0};getByPath("table.edit-fields",e.config)&&(a='<a class="simple-table-edit-button" title="Edit selected rows" />',a+=e.config.table["edit-icon"]?'<img src="'+e.config.table["edit-icon"]+'" />':"📝",a+="</a>");getByPath("table.select",e.config)&&(l.colGroupHTML+='<col class="simple-table-col-select">',l.theadHTML+='<td class="simple-table-select-row ">',"multi"===getByPath("table.select",e.config)&&(l.theadHTML+='<input id="simple-table-select-row-all" class="simple-table-select-row-all" type="checkbox">'),l.theadHTML+="</td>",l.tfilterHTML+='<td class="simple-table-edit">'+a+"</td>");e.config.table.fields.forEach((function(t,s){!function prepareHeaderRows(e,t,s,n){var a="string"==typeof e["sort-by-field"]?"⭐":"",l="",o=getOrder(n);if(n.vars.dataGrid.getFields()[o.col]===e["sort-by-field"])switch(o.order){case"ASC":a="⭣";break;case"DESC":a="⭡"}s.colwidth=e.width||n.config.table["default-col-width"],s.tabwidth+=s.colwidth,s.colGroupHTML+='<col class="" style="width:'+s.colwidth+'px;">',e.icon&&(l='<img class="col-icon" src="'+e.icon+'" />');s.theadHTML+=""!==a?'<th  class="col-sort" data-ui="simple-table-sort-'+t+'" data-col-id="'+t+'">':"<th>";s.theadHTML+=l+" "+a+" "+shmi.localize(e.label)+" "+a+"</th>",s.tfilterHTML+='<td class="col-filter-header" data-col-id="'+t+'">',e.filter&&"label"in e.filter&&(s.tfilterHTML+='<label for="">'+shmi.localize(e.filter.label)+"</label>");e.filter&&"select"in e.filter?(s.tfilterHTML+='<select class="simple-table-filter" field="'+e.filter.field+'" size="'+Number(e.filter.size)+'"><option value=""></option>',e.filter.select.forEach((function(e){var t=e.label||e.value,n=e.value;s.tfilterHTML+='<option value="'+n+'">'+shmi.localize(t)+"</option>"})),s.tfilterHTML+="</select>"):e.filter&&(s.tfilterHTML+='<input type="text" size="'+Number(e.filter.size)+'" class="simple-table-filter" field="'+e.filter.field+'" />');s.tfilterHTML+="</td>"}(t,s,l,e)})),t.innerHTML=l.colGroupHTML,s.innerHTML=l.theadHTML+"</tr>",n.innerHTML=l.tfilterHTML+"</tr>",e.vars.theadElement.appendChild(t),e.vars.tfilterElement.appendChild(t.cloneNode(!0)),e.vars.tbodyElement.appendChild(t.cloneNode(!0)),e.vars.theadElement.appendChild(s),e.vars.tfilterElement.appendChild(n),e.vars.theadElement.style.width=l.tabwidth+"px",e.vars.tfilterElement.style.width=l.tabwidth+"px",e.vars.tbodyElement.style.width=l.tabwidth+"px",function addFilterListeners(e){var t,s,n,a,l=e.element.getElementsByClassName("simple-table-filter"),o=e.vars.dataGrid.getFilters();for(t=0;t<l.length;t++)n=(s=l[t]).getAttribute("field"),null!==o[a=e.vars.dataGrid.getFields().indexOf(n)]&&(s.value=o[a]),s.onchange=dgFilter.bind(null,s,e)}(e)}(t),function fillTableWithData(e){var t,s,n=e.vars.dgMan.getCurrentIDs(e.config["grid-name"],e.vars.dgSubscription.id),a=document.createElement("tbody");for(e.vars.tableUiElements=[],n.forEach((function(t){var s=document.createElement("tr");s.setAttribute("data-row-id",t),shmi.addClass(s,"simple-table-data-row"),s.innerHTML=function createTableRowHtml(e,t){var s="";t.config.table.select&&(s+='<td class="simple-table-select-row"><input class="simple-table-row-'+e,s+='" id="select-row-'+e+'" value="'+e+'" type="checkbox"></td>');return t.vars.tableUiElements[e]=[],t.config.table.fields.forEach((function(n,a){t.vars.tableUiElements[e][a]=null,s+='<td class="" data-ui="simple-table-item-'+e+"-"+a+'"></td>'})),s}(t,e),a.appendChild(s)})),e.vars.tbodyElement.appendChild(a),setDataGridControls(e),t=e.element.getElementsByClassName("simple-table-select-row"),s=0;s<t.length;s++)t[s].firstChild&&(t[s].firstChild.onchange=function(){rowsSelector(this,e)})}(t),function buildPager(e){var t=[],s=document.createElement("div"),n=e.config.pager.offset,a=e.config.pager["rows-per-page"],l=e.vars.dataGrid.getRowCount(e.config["grid-name"]),o=parseInt(l/a,10)+1,r=parseInt(n/a,10)+1,c=r>1?r-1:r,u=r<o?r+1:r,m=shmi.localize("${SIMPLE_TABLE_PAGER_TOTAL}"),h=1,d=1,f=o;m=shmi.evalString(m,{value:o}),o>5&&(f=r+2,(d=r-2)<1&&(f+=1+Math.abs(d),d=1),f>o&&(d-=f-o,f=o));for(t.push({label:"⭰","data-page":1}),t.push({label:"⭠","data-page":c}),h=d;h<=f;h++)t.push({label:h,"data-page":h});t.push({label:"⭢","data-page":u}),t.push({label:"⭲","data-page":o}),t.forEach((function(e){var t=document.createElement("div"),n="pagenum button small";t.textContent=e.label,t.setAttribute("data-page",e["data-page"]),e["data-page"]===r&&(n+=" inactive"),shmi.addClass(t,n),s.appendChild(t)})),shmi.addClass(s,"pages"),e.vars.pagerElement.firstChild.replaceWith(s),e.vars.pagerTotalElement.textContent=m}(t),t.vars.isTableToCleanup=!0)}function dgFilter(t,s){var n=t.getAttribute("field"),a=s.vars.dataGrid.getFields().indexOf(n),l=t.value;if(s.clearFilter(a),""!==l){switch(getByPath("table.fields."+t.parentElement.getAttribute("data-col-id")+".filter.type",s.config)){case"numeric":l=Number(l);break;case"boolean":l=-1!==e.BOOLEANS_TRUE.indexOf(l);break;default:l=String(l)}s.setFilter(a,l)}}function rowsSelector(e,t){var s,n,a,l,o={rows:[],grid:t.config.name};if("simple-table-select-row-all"===e.id)for(n=t.element.getElementsByClassName("simple-table-select-row"),s=0;s<n.length;s++)(a=n[s]).firstChild.checked=e.checked,l=a.parentElement,"simple-table-select-row-all"!==a.firstChild.id&&!0===a.firstChild.checked?(shmi.addClass(l,"selected"),o.rows.push(a.firstChild.value)):shmi.removeClass(l,"selected");else for(l=e.parentElement.parentElement,!0===e.checked?("multi"!==t.config.table.select&&(!function clearSelection(e){var t,s,n,a=e.element.getElementsByClassName("simple-table-select-row");for(t=0;t<a.length;t++)(s=a[t]).firstChild&&(s.firstChild.checked=!1),n=s.parentElement,shmi.removeClass(n,"selected")}(t),e.checked=!0),shmi.addClass(l,"selected")):shmi.removeClass(l,"selected"),n=t.element.getElementsByClassName("simple-table-select-row"),s=0;s<n.length;s++)(a=n[s]).firstChild&&"simple-table-select-row-all"!==a.firstChild.id&&!0===a.firstChild.checked&&o.rows.push(a.firstChild.value);shmi.fire("select",o,t.element)}function getOrder(e){var t={col:null,field:null,order:"ASC"};return e.config.table.sort&&Number.isInteger(e.config.table.sort.col)&&e.config.table.sort.order&&(t.order=e.config.table.sort.order,t.col=e.config.table.sort.col),t}function getByPath(e,t,s){var n,a,l=t;for("string"==typeof e&&(e=(e=(e=e.replace("[",".")).replace("]","")).split(".")),n=0;n<e.length;n++){if(a=e[n],!l||!(a in l))return s;l=l[a]}return l}function setByPath(e,t,s){if("string"==typeof e&&(e=(e=(e=e.replace("[","[.")).replace("]","")).split(".")),e.length>1){var n=e.shift(),a={};-1!==n.indexOf("[")&&(n=n.replace("[",""),a=[]),"object"==typeof t[n]&&null!==t[n]||(t[n]=a),setByPath(e,t[n],s)}else t[e[0]]=s}var a={className:"SimpleTable",uiType:t,isContainer:!1,config:s,configSchema:null,vars:{dgMan:null,dgSubscription:{},dataGrid:{},isTableToCleanup:!1,listeners:[],theadElement:null,tfilterElement:null,tbodyElement:null,pagerElement:null,tableUiElements:[],controls:{}},imports:{im:"visuals.session.ItemManager",qm:function(){return shmi.visuals.session.QueryManager}},prototypeExtensions:{onInit:function(){var e,t,s=this;s.config.table.filters={},s.config.table["default-filters"]&&(s.config.table.filters=s.config.table["default-filters"]),function getDesignerColMapping(e){!0===e.config["use-designer-mapping"]&&e.config["col-mapping"].length>0&&e.config["col-mapping"].forEach((function(t,s){e.config.table.fields[s]||(e.config.table.fields[s]={label:"",icon:null,width:e.config.table["default-col-width"],"sort-by-field":null,controls:[{"ui-type":"text2",config:{},mapping:[]}]}),e.config.table.fields[s].controls[0]||(e.config.table.fields[s].controls[0]={"ui-type":"text2",config:{},mapping:[]}),e.config.table.fields[s].controls[0].mapping[0]||(e.config.table.fields[s].controls[0].mapping[0]={option:"item",field:null}),e.config.table.fields[s].label=t.label,e.config.table.fields[s].controls[0].mapping[0].field=t.field,t["sort-by-field"]&&""!==t["sort-by-field"]&&(e.config.table.fields[s]["sort-by-field"]=t["sort-by-field"])}))}(s),function initElements(e){var t,s=null;e.vars.theadElementWrapper=shmi.getUiElement("simple-table-head-wrapper",e.element),e.vars.theadElementWrapper||shmi.log("[simple-table] simple-table-head-wrapper element not found in template",3),e.vars.theadElement=shmi.getUiElement("simple-table-head",e.element),e.vars.theadElement||shmi.log("[simple-table] simple-table-head element not found in template",3),e.vars.tfilterElementWrapper=shmi.getUiElement("simple-table-filter-wrapper",e.element),e.vars.tfilterElementWrapper||shmi.log("[simple-table] simple-table-filter-wrapper element not found in template",3),e.vars.tfilterElement=shmi.getUiElement("simple-table-filter",e.element),e.vars.tfilterElement||shmi.log("[simple-table] simple-table-filter element not found in template",3),e.vars.tbodyElementWrapper=shmi.getUiElement("simple-table-body-wrapper",e.element),e.vars.tbodyElementWrapper||shmi.log("[simple-table] simple-table-body-wrapper element not found in template",3),e.vars.tbodyElement=shmi.getUiElement("simple-table-body",e.element),e.vars.tbodyElement||shmi.log("[simple-table] simple-table-body element not found in template",3),e.vars.pagerElement=shmi.getUiElement("simple-table-pager",e.element),e.vars.pagerElement||shmi.log("[simple-table] simple-table-pager element not found in template",3),e.vars.pagerTotalElement=shmi.getUiElement("simple-table-total",e.element),e.vars.pagerTotalElement||shmi.log("[simple-table] simple-table-total element not found in template",3),e.vars.pagerSettingsElement=shmi.getUiElement("simple-table-settings",e.element),e.vars.pagerSettingsElement||shmi.log("[simple-table] simple-table-settings element not found in template",3),e.config.table.width&&(t=15,e.vars.tbodyElementWrapper.offsetWidth&&e.vars.tbodyElementWrapper.clientWidth&&(t=Number(e.vars.tbodyElementWrapper.offsetWidth)-Number(e.vars.tbodyElementWrapper.clientWidth)),e.vars.theadElementWrapper.style.width=e.config.table.width+"px",e.vars.tfilterElementWrapper.style.width=e.config.table.width+"px",e.vars.tbodyElementWrapper.style.width=e.config.table.width+"px",e.vars.pagerElement.style.width=Number(e.config.table.width)+t+"px"),e.config.table.height&&(e.vars.tbodyElementWrapper.style.height=e.config.table.height+"px"),e.config.pager["rows-per-page"]&&e.config.pager["page-sizes"].forEach((function(t){(s=document.createElement("option")).value=t.value,s.textContent=t.label?shmi.localize(t.label):t.value,t.value===e.config.pager["rows-per-page"]&&(s.selected="selected"),e.vars.pagerSettingsElement.firstElementChild.appendChild(s)}))}(s);var n={onPress:function(e,t,s){}};e=new shmi.visuals.io.MouseListener(s.element,n),t=new shmi.visuals.io.TouchListener(s.element,n),s.vars.listeners.push(e,t)},onEnable:function(){var e,t=this,s=shmi.requires("visuals.tools.iterate.iterateObject");t.vars.dgMan=shmi.visuals.session.DataGridManager,t.vars.dgSubscription=t.vars.dgMan.subscribePage(t.config["grid-name"],t.config.pager.offset,t.config.pager["rows-per-page"],(function(e){t.vars.dgSubscription.changeInfo=e,onDataGridChange(e,t)})),t.config.table.sort&&Number.isInteger(t.config.table.sort.col)&&t.config.table.sort.order&&t.vars.dgMan.sort(t.config["grid-name"],t.config.table.sort.col,t.config.table.sort.order),e=t.vars.dgMan.getFields(t.config["grid-name"]),s(t.config.table.filters||{},((s,n)=>{-1!==e.indexOf(n)&&t.vars.dgMan.setFilter(t.config["grid-name"],e.indexOf(n),s)})),t.vars.pagerSettingsElement.onchange=function(e){var s=e.target.value;s&&s!==t.config.pager["rows-per-page"]&&(t.config.pager["rows-per-page"]=s,t.config.pager.offset=0,t.vars.pagerSettingsElement.firstChild.value=s,t.vars.dgMan.unsubscribe(t.config["grid-name"],t.vars.dgSubscription.id),t.vars.dgSubscription=t.vars.dgMan.subscribePage(t.config["grid-name"],t.config.pager.offset,t.config.pager["rows-per-page"],(function(e){t.vars.dgSubscription.changeInfo=e,onDataGridChange(e,t)})))},addTableWrapperScrollListener(t),t.vars.listeners.forEach((function(e){e.enable()}))},onDisable:function(){var e=this;e.vars.dgMan.unsubscribe(e.config["grid-name"],e.vars.dgSubscription.id),e.vars.dgMan=null,e.vars.dgSubscription=null,deleteControls(e),removeTableWrapperScrollListener(e),e.vars.listeners.forEach((function(e){e.disable()}))},onLock:function(){var e=this;deleteControls(e),removeTableWrapperScrollListener(e),e.vars.listeners.forEach((function(e){e.disable()}))},onUnlock:function(){addTableWrapperScrollListener(this),this.vars.listeners.forEach((function(e){e.enable()}))},onSetValue:function(e,t,s){},onSetProperties:function(e,t,s){},sort:function(e,t){var s=this;s.vars.dataGrid&&(e=Number.parseInt(e,10),s.config.table.sort.col=e,s.config.table.sort.order=t,s.vars.dataGrid.sort(e,t))},setFilter:function(e,t){this.vars.dataGrid&&this.vars.dataGrid.setFilter(e,t)},clearFilter:function(e){this.vars.dataGrid&&this.vars.dataGrid.clearFilter(e)}}};shmi.requires("visuals.tools.control-generator").generate(a)}(),shmi.pkg("visuals.controls"),shmi.visuals.controls.SlideIn=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","slide-in"),shmi.def(this.config,"class-name-container","container"),shmi.def(this.config,"name",null),shmi.def(this.config,"template","default/slide-in"),shmi.def(this.config,"always-open-layouts",[]),shmi.def(this.config,"container-layouts",[]),shmi.def(this.config,"auto-layout",!0),shmi.def(this.config,"initial-mode","slide"),shmi.def(this.config,"content-template",null),shmi.def(this.config,"auto-close",!1),shmi.def(this.config,"tab-limit",!0),shmi.def(this.config,"overlay-style",{background:"transparent",zIndex:1}),this.controls=[],this.state={},this.state.open=!1,this.forceOpen=!1,this.containerMode=!1,this.startup()},shmi.visuals.controls.SlideIn.prototype={uiType:"slide-in",isContainer:!0,events:["open","close"],getClassName:function(){return"SlideIn"},onEnable:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].enable();var t=shmi.getCurrentLayout();-1!==this.config["always-open-layouts"].indexOf(t)?this.forceOpen=!0:this.forceOpen=!1,"container"===this.config["initial-mode"]&&this.enableContainerLayout(),!0===this.config["auto-layout"]&&this.testContainerLayout(),this.forceOpen&&this.open()},onDisable:function(){var e=this;this.close();for(var t=0;t<this.controls.length;t++)this.controls[t].disable();Array.isArray(e.openListeners)&&(e.openListeners.forEach((function(e){e.disable()})),e.openListeners=[])},onDelete:function(){this.config["container-layouts"].length>0&&!0===this.config["auto-layout"]&&window.removeEventListener("visuals-layout-change",this.testContainerLayoutBind),this.config["always-open-layouts"].length>0&&window.removeEventListener("visuals-layout-change",this.testOpenLayoutBind)},open:function(){var e=this;if(!this.state.open){if(!1===this.containerMode&&(shmi.removeClass(this.element,"closed"),shmi.addClass(this.element,"open")),e.config["tab-limit"]){var t=shmi.requires("visuals.tools.tabulator");e.tabLimit=t.setTabParent(e.element)}if(e.config["auto-close"]){var s={onPress:function(t,s,n){shmi.testParentChild(e.element,n.target)||(n.preventDefault(),e.close(),e.openListeners.forEach((function(e){e.disable()})),e.openListeners=[])}};this.bgOverlay=document.createElement("DIV"),this.bgOverlay.classList.add("overlay-background"),this.bgOverlay.style.background=e.config["overlay-style"].background,this.bgOverlay.style.zIndex=e.config["overlay-style"].zIndex,this.bgOverlay.style.top=0,this.bgOverlay.style.right=0,this.bgOverlay.style.bottom=0,this.bgOverlay.style.left=0,this.bgOverlay.style.position="fixed",document.body.insertBefore(this.bgOverlay,document.body.firstChild),this.openListeners=[new shmi.visuals.io.MouseListener(this.bgOverlay,s),new shmi.visuals.io.TouchListener(this.bgOverlay,s)],this.openListeners.forEach((function(e){e.enable()}))}this.state.open=!0,this.fire("open",{})}},close:function(){var e=this;this.state.open&&(!1===this.containerMode&&(shmi.removeClass(this.element,"open"),shmi.addClass(this.element,"closed")),e.tabLimit&&(e.tabLimit.unsetTabParent(),e.tabLimit=null),e.config["auto-close"]&&(Array.isArray(e.openListeners)&&(e.openListeners.forEach((function(e){e.disable()})),e.openListeners=[]),this.bgOverlay&&(this.bgOverlay.parentNode.removeChild(this.bgOverlay),this.bgOverlay=null)),this.state.open=!1,this.fire("close",{}))},toggle:function(){this.state.open?this.close():this.open()},onRegister:function(e){var t=this;if(t.contentElement=shmi.getUiElement("slide-in-content",t.element),t.contentElement&&t.config["content-template"]){var s=0===t.config["content-template"].indexOf(shmi.c("RES_URL_PREFIX"))?t.config["content-template"]:shmi.c("TEMPLATE_PATH")+t.config["content-template"]+shmi.c("TEMPLATE_EXT");shmi.loadResource(s,(function(s,n){t.isDeleted()||(n?e():(t.contentElement.innerHTML=s,t.parseChildren(t.contentElement,e)))}))}else t.contentElement?t.parseChildren(t.contentElement,e):e()},onInit:function(){shmi.removeClass(this.element,"open"),shmi.addClass(this.element,"closed"),this.state.open=!1,this.config["always-open-layouts"].length>0&&(this.testOpenLayoutBind=this.testOpenLayout.bind(this),window.addEventListener("visuals-layout-change",this.testOpenLayoutBind,!1)),this.config["container-layouts"].length>0&&!0===this.config["auto-layout"]&&(this.testContainerLayoutBind=this.testContainerLayout.bind(this),window.addEventListener("visuals-layout-change",this.testContainerLayoutBind,!1))},testOpenLayout:function(){var e=shmi.getCurrentLayout();-1!==this.config["always-open-layouts"].indexOf(e)?(this.forceOpen=!0,this.active&&this.open()):(this.forceOpen=!1,this.active&&this.close())},enableContainerLayout:function(){!1===this.containerMode&&(this.containerMode=!0,shmi.removeClass(this.element,this.config["class-name"]),shmi.removeClass(this.element,"open"),shmi.removeClass(this.element,"closed"),shmi.addClass(this.element,this.config["class-name-container"]),this.active&&this.open())},disableContainerLayout:function(){!0===this.containerMode&&(this.containerMode=!1,shmi.removeClass(this.element,this.config["class-name-container"]),shmi.addClass(this.element,this.config["class-name"]),this.state.open?shmi.addClass(this.element,"open"):shmi.addClass(this.element,"closed"),this.active&&this.close())},toggleContainerLayout:function(){!1===this.containerMode?(this.containerMode=!0,shmi.removeClass(this.element,this.config["class-name"]),shmi.removeClass(this.element,"open"),shmi.removeClass(this.element,"closed"),shmi.addClass(this.element,this.config["class-name-container"]),this.active&&this.open()):!0===this.containerMode&&(this.containerMode=!1,shmi.removeClass(this.element,this.config["class-name-container"]),shmi.addClass(this.element,this.config["class-name"]),this.state.open?shmi.addClass(this.element,"open"):shmi.addClass(this.element,"closed"),this.active&&this.close())},testContainerLayout:function(){var e=shmi.getCurrentLayout();-1!==this.config["container-layouts"].indexOf(e)?!1===this.containerMode&&(this.containerMode=!0,shmi.removeClass(this.element,this.config["class-name"]),shmi.removeClass(this.element,"open"),shmi.removeClass(this.element,"closed"),shmi.addClass(this.element,this.config["class-name-container"]),this.active&&this.open()):!0===this.containerMode&&(this.containerMode=!1,shmi.removeClass(this.element,this.config["class-name-container"]),shmi.addClass(this.element,this.config["class-name"]),this.state.open?shmi.addClass(this.element,"open"):shmi.addClass(this.element,"closed"),this.active&&this.close())},onLock:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].lock()},onUnlock:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].unlock()},onAddControl:function(e,t){var s=this,n=shmi.requires("visuals.tools.controller"),a=[],l=null;if(!s.initialized)throw new Error("Control not initialized yet.");Array.isArray(e)||(e=[e]),e.forEach((function(e){var t=shmi.createControl(e.ui,s.contentElement,e.config,"DIV",null,!1);if(null!==t){if(e.style&&"object"==typeof e.style){shmi.requires("visuals.tools.iterate.iterateObject")(e.style,((e,s)=>{t.element.style[s]=e}))}a.push(t)}})),(l=shmi.waitOnInit(a,(function(){var o=-1,r=[],c=shmi.requires("visuals.task"),u=[],m=null;l&&(-1!==(o=s._init_.tokens.indexOf(l))&&s._init_.tokens.splice(o,1),l.unlisten(),l=null),e.forEach((function(e,t){var l=null,o=a[t];e.controller&&n.create(e.controller.name,e.controller,o.getName()),s.isActive()&&o.enable(),Array.isArray(e.children)&&e.children.length&&((l=c.createTask("child control")).run=function(){o.addControl(e.children,(function(e,t){e&&r.push(e),l.complete()}))},u.push(l))})),u.length?((m=c.createTaskList(u,!1)).onComplete=function(){t(r.length?r[0]:null,a)},m.run()):t(r.length?r[0]:null,a)})))&&s._init_.tokens.push(l)}},shmi.extend(shmi.visuals.controls.SlideIn,shmi.visuals.core.BaseControl),shmi.pkg("visuals.session"),shmi.visuals.session.userActions=shmi.visuals.session.userActions||{},shmi.visuals.session.userActions["slide-in"]=function(e){if(2!==e.length)shmi.log("[UserAction] slide-in - needs two parameters",2);else{var t=shmi.ctrl(e[1],null);switch(e[0]){case"open":t?t.open():shmi.log("[UserAction] slide-in - control '"+e[1]+"' not found",2);break;case"close":t?t.close():shmi.log("[UserAction] slide-in - control '"+e[1]+"' not found",2);break;case"toggle":t?t.toggle():shmi.log("[UserAction] slide-in - control '"+e[1]+"' not found",2);break;default:shmi.log("[UserAction] unknown function '"+e[0]+"' configured",3)}}},shmi.pkg("visuals.controls"),shmi.visuals.controls.Slider=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","slider"),shmi.def(this.config,"template","default/slider"),shmi.def(this.config,"name",null),shmi.def(this.config,"send-interval",100),shmi.def(this.config,"animation-duration",100),shmi.def(this.config,"orientation","horizontal"),shmi.def(this.config,"continuous",!0),shmi.def(this.config,"min",0),shmi.def(this.config,"max",100),shmi.def(this.config,"step",0),shmi.def(this.config,"precision",-1),shmi.def(this.config,"type",shmi.c("TYPE_FLOAT")),shmi.def(this.config,"label","slider"),shmi.def(this.config,"unit-text",null),shmi.def(this.config,"decimal-delimiter","."),shmi.def(this.config,"auto-min",!0),shmi.def(this.config,"auto-max",!0),shmi.def(this.config,"auto-step",!0),shmi.def(this.config,"auto-precision",!0),shmi.def(this.config,"auto-label",!0),shmi.def(this.config,"auto-unit-text",!0),shmi.def(this.config,"auto-type",!0),this.value=0,this.sendInterval=0,this.lastSent=0,this.active=!1,this.initialized=!1,this._subscriptionTargetId=null,this.resizeCallback=null,this._dragging=!1,this._valueTimeout=-1,this.startup()},shmi.visuals.controls.Slider.prototype={uiType:"slider",getClassName:function(){return"Slider"},events:["change"],onInit:function(){var e=this;if(shmi.requires("visuals.tools.numericValues").initValueSettings(e),"false"===this.config.continuous?this.config.continuous=!1:"true"===this.config.continuous&&(this.config.continuous=!0),this.handleElement=shmi.getUiElement("slider-handle",this.element),this.handleElement)if(this.valueElement=shmi.getUiElement("value",this.element),this.backgroundElement=shmi.getUiElement("slider-background",this.element),this.backgroundElement){this.labelElement=shmi.getUiElement("slider-label",this.element),this.labelElement?this.config.label&&(this.labelElement.textContent=shmi.localize(this.config.label)):shmi.log("[Slider] no slider-label element provided",1),this.unitElement=shmi.getUiElement("unit",this.element),this.unitElement&&this.config["unit-text"]&&(this.unitElement.textContent=shmi.localize(this.config["unit-text"])),this.config.action&&(this.action=new shmi.visuals.core.UiAction(this.config.action,this)),"vertical"===this.config.orientation&&shmi.addClass(this.element,"vertical"),this.width=0,this.handleWidth=0,this.movable=new shmi.visuals.gfx.Movable(this.handleElement),this.anim=new shmi.visuals.gfx.Animation(this.updateHandle.bind(this));var t={onPress:function(){shmi.addClass(e.handleElement,"pressed"),clearTimeout(e.dragTimeout),e._dragging=!1},onDrag:function(t,s,n){n.preventDefault(),e._dragging||(e._dragging=!0,!1!==e.config.continuous&&e.enableSend()),"vertical"===e.config.orientation?e.movable.ty+s>0?(e.movable.ty=0,e.movable.update()):e.movable.ty+s<-e.width+e.handleWidth?(e.movable.ty=-e.width+e.handleWidth,e.movable.update()):e.movable.translate(0,s):e.movable.tx+t<0?(e.movable.tx=0,e.movable.update()):e.movable.tx+t+e.handleWidth>e.width?(e.movable.tx=e.width-e.handleWidth,e.movable.update()):e.movable.translate(t,0)},onRelease:function(){e.disableSend(),shmi.removeClass(e.handleElement,"pressed"),e.dragTimeout=setTimeout((function(){e._dragging=!1}),shmi.c("DRAG_TIMEOUT"))}};this.mouseListener=new shmi.visuals.io.MouseListener(this.handleElement,t),this.touchListener=new shmi.visuals.io.TouchListener(this.handleElement,t),this.resizeListenerAdded||(e.resizeCallback=function(){clearTimeout(e.resizeTO),e.resizeTO=setTimeout((function(){e.updateSize(),e.setValue(e.value)}),shmi.c("ACTION_RETRY_TIMEOUT"))},window.addEventListener("resize",e.resizeCallback,!1),window.addEventListener("visuals-layout-change",e.resizeCallback,!1),this.resizeListenerAdded=!0)}else shmi.log("[Slider] no slider-background element provided",3);else shmi.log("[Slider] no slider-handle element provided",3)},updateSize:function(){this.width="vertical"===this.config.orientation?this.backgroundElement.offsetHeight:this.backgroundElement.offsetWidth,this.handleWidth="vertical"===this.config.orientation?this.handleElement.offsetHeight:this.handleElement.offsetWidth},onEnable:function(){this.updateSize(),this.config.item&&(this._subscriptionTargetId=shmi.visuals.session.ItemManager.subscribeItem(this.config.item,this,this.config["send-interval"])),this.mouseListener.enable(),this.touchListener.enable()},onDisable:function(){this.config.item&&shmi.visuals.session.ItemManager.unsubscribeItem(this.config.item,this._subscriptionTargetId),this.mouseListener.disable(),this.touchListener.disable(),this.anim.stop()},onLock:function(){this.mouseListener.disable(),this.touchListener.disable(),shmi.addClass(this.element,"locked")},onUnlock:function(){this.mouseListener.enable(),this.touchListener.enable(),shmi.removeClass(this.element,"locked")},onSetProperties:function(e,t,s){var n=this;shmi.requires("visuals.tools.numericValues").setProperties(n,arguments),"number"==typeof n.value&&n.setValue(n.value)},onSetValue:function(e){var t=this,s=shmi.requires("visuals.tools.numericValues"),n=t.vars.valueSettings,a=t.value,l=n.min,o=n.max;if(-1!==this._valueTimeout&&(clearTimeout(this._valueTimeout),this._valueTimeout=-1),this._dragging)this._valueTimeout=setTimeout(function(){this.setValue(e)}.bind(this),shmi.c("ACTION_RETRY_TIMEOUT"));else{if("vertical"===this.config.orientation?this.anim.setCurrentValue(this.movable.ty):this.anim.setCurrentValue(this.movable.tx),this.value=s.applyInputSettings(e,t),this.valueElement){shmi.caf(t.raf_id),t.raf_id=shmi.raf((function(){t.valueElement.textContent=s.formatOutput(e,t)}))}if(!this._dragging){var r=null;r=o===l?this.width-this.handleWidth:void 0===this.value?0:(this.value-l)/(o-l)*(this.width-this.handleWidth),"vertical"===this.config.orientation&&(r*=-1),this.anim.start(r,this.config["animation-duration"])}t.value!==a&&t.fire("change",{value:t.value})}},getValue:function(){return this.value},updateHandle:function(e){isNaN(e)||("vertical"===this.config.orientation?this.movable.ty=e:this.movable.tx=e,this.movable.update())},enableSend:function(){clearInterval(this.sendInterval),this.sendInterval=setInterval(this.writeValue.bind(this),this.config["send-interval"])},writeValue:function(e){var t=this,s=shmi.requires("visuals.tools.numericValues"),n=t.vars.valueSettings,a=n.min,l=n.max,o="vertical"===this.config.orientation?-this.movable.ty:this.movable.tx,r=null;if(r=l===a?l:o*(l-a)/(this.width-this.handleWidth)+a,r=s.applyInputSettings(r,t),this.valueElement){shmi.caf(t.raf_id),t.raf_id=shmi.raf((function(){t.valueElement.textContent=s.formatOutput(r,t)}))}(e||r!==this.lastsent)&&(this.config.item?shmi.visuals.session.ItemManager.writeValue(this.config.item,r):(this.value=r,this.fire("change",{value:r})),this.lastsent=r,this.action&&this.action.execute(this.value))},disableSend:function(){clearInterval(this.sendInterval),this.writeValue(!1)},setLabel:function(e){var t=this;t.config["auto-label"]&&t.labelElement&&(t.labelElement.textContent=shmi.localize(e))},setUnitText:function(e){var t=this;t.config["auto-unit-text"]&&t.unitElement&&(t.unitElement.textContent=shmi.localize(e))},onDelete:function(){var e=this;e.resizeCallback&&(window.removeEventListener("resize",e.resizeCallback,!1),window.removeEventListener("visuals-layout-change",e.resizeCallback,!1))}},shmi.extend(shmi.visuals.controls.Slider,shmi.visuals.core.BaseControl),shmi.pkg("visuals.controls"),shmi.visuals.controls.TabPanel=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","tab-panel"),shmi.def(this.config,"template","default/tab-panel"),shmi.def(this.config,"name",null),shmi.def(this.config,"initial-view",0),shmi.def(this.config,"tab-labels",[]),shmi.def(this.config,"views",[]),shmi.def(this.config,"content-template",null),shmi.def(this.config,"item",null),this.mouselistener=null,this.touchlistener=null,this.active=!1,this.initialized=!1,this._subscriptionTargetId=null,this.buttons=[],this.screen=null,this.controls=[],this.startup()},shmi.visuals.controls.TabPanel.prototype={uiType:"tab-panel",events:["navigate"],isContainer:!0,getClassName:function(){return"TabPanel"},onRegister:function(e){var t=this,s=null;if(t.screen_anchor=shmi.getUiElement("screen-anchor",t.element),!t.screen_anchor){console.warn("["+t.getClassName()+"]","'screen-anchor' element missing from template, adding replacement");var n=document.createElement("DIV");n.setAttribute("class","tab-content"),t.element.appendChild(n),t.screen_anchor=n}t.screen=shmi.createControl("screen",t.screen_anchor,{name:"content","no-views-content":"",views:t.config.views,template:t.config["content-template"],"initial-view":t.config["initial-view"],"delete-inactive-views":!1,item:t.config.item},"DIV"),(s=shmi.waitOnInit([t.screen],(function(){var n=-1;s&&(-1!==(n=t._init_.tokens.indexOf(s))&&t._init_.tokens.splice(n,1),s=null),e()})))&&t._init_.tokens.push(s)},onInit:function(){var e=this,t=e.config["tab-labels"];e.tabs_anchor=shmi.getUiElement("tabs-anchor",e.element),e.tabs_anchor?e.screen.viewElements.forEach((function(s,n){e.buttons.push(shmi.createControl("button",e.tabs_anchor,{label:t[n]||"view_"+(n+1)},"DIV")),n===e.config["initial-view"]&&shmi.addClass(e.buttons[n].element,"selected"),e.buttons[n].listen("click",function getClickCB(t){return function(s){e.setView(t);for(var n=0;n<e.buttons.length;n++)shmi.removeClass(e.buttons[n].element,"selected");shmi.addClass(e.buttons[t].element,"selected")}}(n)),shmi.hasClass(e.element,"small")?shmi.addClass(e.buttons[n].element,"small"):shmi.hasClass(e.element,"large")&&shmi.addClass(e.buttons[n].element,"large")})):shmi.notify("${V_MISSING_UI_ELEMENT} 'tabs-anchor'","${V_ERROR}")},setView:function(e){var t=this;if(t.initialized&&t.screen.initialized&&t.screen){t.screen.setView(e);for(var s=0;s<t.buttons.length;s++)shmi.removeClass(t.buttons[s].element,"selected");shmi.addClass(t.buttons[e].element,"selected")}},onEnable:function(){var e=this,t=shmi.requires("visuals.session.ItemManager"),s=t.getItemHandler();e.controls.forEach((function(e){e.enable()})),e.config.item&&(s.setValue=function setValue(t){if(!shmi.isDesignerEditor()){var s=parseInt(t);!isNaN(s)&&s>=0&&s<e.buttons.length&&(e.buttons.forEach((function(e){shmi.removeClass(e.element,"selected")})),shmi.addClass(e.buttons[s].element,"selected"))}},e._subscriptionTargetId=t.subscribeItem(e.config.item,s))},onDisable:function(){var e=this;e.controls.forEach((function(e){e.disable()})),e._subscriptionTargetId&&(e._subscriptionTargetId.unlisten(),e._subscriptionTargetId=null)},onSetValue:function(){},onLock:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].lock();shmi.addClass(this.element,"locked"),shmi.log("[TabPanel] locked",1)},onUnlock:function(){for(var e=0;e<this.controls.length;e++)this.controls[e].unlock();shmi.removeClass(this.element,"locked"),shmi.log("[TabPanel] unlocked",1)},onAddControl:function(e,t){var s,n=this;if(!n.initialized)throw new Error("Control not initialized yet.");Array.isArray(e)||(e=[e]),e.some((function(e){return"view"!==e.ui}))?t(new Error("All children must be of type 'view'"),[]):(s=n.screen.viewElements.length,e.forEach((function(e,t){var a=s+t,l=e.config.label||n.config["tab-labels"][a]||"View "+(a+1);n.buttons.push(shmi.createControl("button",n.tabs_anchor,{label:l},"DIV")),a===n.config["initial-view"]&&shmi.addClass(n.buttons[a].element,"selected"),n.buttons[a].listen("click",function getClickCB(e){return function(t){n.setView(e);for(var s=0;s<n.buttons.length;s++)shmi.removeClass(n.buttons[s].element,"selected");shmi.addClass(n.buttons[e].element,"selected")}}(a)),shmi.hasClass(n.element,"small")?shmi.addClass(n.buttons[a].element,"small"):shmi.hasClass(n.element,"large")&&shmi.addClass(n.buttons[a].element,"large")})),n.screen.addControl(e,t))}},shmi.extend(shmi.visuals.controls.TabPanel,shmi.visuals.core.BaseControl),shmi.registerControlType("tab-panel",shmi.visuals.controls.TabPanel,!0),shmi.pkg("visuals.controls"),shmi.visuals.controls.TextDisplay=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","text-display"),shmi.def(this.config,"template","default/text-display"),shmi.def(this.config,"name",null),shmi.def(this.config,"precision",-1),shmi.def(this.config,"type",shmi.c("TYPE_FLOAT")),shmi.def(this.config,"unit-scale",1),shmi.def(this.config,"label","text-display"),shmi.def(this.config,"unit-text",null),shmi.def(this.config,"decimal-delimiter","."),shmi.def(this.config,"auto-precision",!0),shmi.def(this.config,"auto-label",!0),shmi.def(this.config,"auto-unit-text",!0),shmi.def(this.config,"auto-type",!0),this.value=null,this.labelElement=null,this.valueElement=null,this.unitElement=null,this.initialized=!1,this._subscriptionTargetId=null,this.active=!1,this.vars={conditional:null},this.startup()},shmi.visuals.controls.TextDisplay.prototype={uiType:"text-display",getClassName:function(){return"TextDisplay"},onInit:function(){shmi.requires("visuals.tools.numericValues").initValueSettings(this),this.labelElement=shmi.getUiElement("text-display-label",this.element),this.labelElement||shmi.log("[TextDisplay] no text-display-label element provided",1),this.valueElement=shmi.getUiElement("text-display-value",this.element),this.valueElement?(this.unitElement=shmi.getUiElement("text-display-unit",this.element),this.unitElement||shmi.log("[TextDisplay] no text-display-unit element provided",1),shmi.log("[TextDisplay] -- all elements found --",1),this.config["unit-text"]&&this.unitElement&&(this.unitElement.innerHTML=shmi.localize(this.config["unit-text"])),this.config.label&&this.labelElement&&(this.labelElement.innerHTML=shmi.localize(this.config.label)),this.config["unit-scale"]&&(this.config["unit-scale"]=parseFloat(shmi.localize(this.config["unit-scale"])))):shmi.log("[TextDisplay] no text-display-value element provided",3)},onSetValue:function(e,t){var s=this;t===shmi.c("TYPE_STRING")||isNaN(parseFloat(e))?s.value=e:s.value=parseFloat(e),shmi.caf(s.requestID),s.requestID=shmi.raf((function(){s.asyncSet(t)}))},onSetProperties:function(e,t,s){shmi.requires("visuals.tools.numericValues").setProperties(this,arguments)},asyncSet:function(e){var t=shmi.requires("visuals.tools.numericValues");if(shmi.visuals.session.deactivateControls)setTimeout(this.asyncSet.bind(this),shmi.c("ACTION_RETRY_TIMEOUT"));else{var s=t.formatOutput(this.value,this);this.valueElement.textContent=s}},onDisable:function(){this.vars.conditional&&this.vars.conditional.disable(),this.config.item&&shmi.visuals.session.ItemManager.unsubscribeItem(this.config.item,this._subscriptionTargetId),shmi.log("[TextDisplay] disabled",1)},onEnable:function(){var e=this;null!==e.vars.conditional?e.vars.conditional.item!==e.config.item&&(e.vars.conditional.item=e.config.item):e.config.item&&(e.vars.conditional=shmi.createConditional(e.element,e.config.item)),e.vars.conditional&&e.vars.conditional.enable(),this.config.item?this._subscriptionTargetId=shmi.visuals.session.ItemManager.subscribeItem(this.config.item,this):this.config.action&&this.execute(this.config.action),shmi.log("[TextDisplay] enabled",1)},execute:function(e){for(var t=0,s=e.split(",");t<s.length;){if(0===(e=s[t]).indexOf("connect")){var n=e.split(":");if(3!==n.length)return void shmi.log("[TextDisplay] action has unknown format",3);var a=shmi.ctrl("."+n[1]);if(!a)return void shmi.log("[TextDisplay] '"+n[1]+"' not found in layout",3);var l=this;shmi.waitOnInit(a,(function(){a.callbacks[n[2]]=l.setValue.bind(l),l.setValue(a.getValue(n[2]))}))}else shmi.log("TextDisplay] unknown action: "+this.config.action,3);t++}},setLabel:function(e){var t=this;t.config["auto-label"]&&t.labelElement&&(t.labelElement.textContent=shmi.localize(e))},setUnitText:function(e){var t=this;t.config["auto-unit-text"]&&t.unitElement&&(t.unitElement.textContent=shmi.localize(e))}},shmi.extend(shmi.visuals.controls.TextDisplay,shmi.visuals.core.BaseControl),shmi.pkg("visuals.controls"),shmi.visuals.controls.TextElement=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","text"),shmi.def(this.config,"name",null),shmi.def(this.config,"text"," "),shmi.def(this.config,"bold",!1),shmi.def(this.config,"italic",!1),shmi.def(this.config,"underline",!1),shmi.def(this.config,"position","left"),shmi.def(this.config,"font-family","inherit"),shmi.def(this.config,"font-size",14),shmi.def(this.config,"items",[]),this.vars={itemValues:[],tokens:[],radId:0},this.startup()},shmi.visuals.controls.TextElement.prototype={uiType:"text",getClassName:function(){return"TextElement"},onInit:function(){if(this.config.text&&(this.element.textContent=shmi.localize(this.config.text),this.config.bold&&shmi.addClass(this.element,"text-bold"),this.config.italic&&shmi.addClass(this.element,"text-italic"),this.config.underline&&shmi.addClass(this.element,"text-underline"),"left"===this.config.position&&shmi.addClass(this.element,"text-left"),"center"===this.config.position&&shmi.addClass(this.element,"text-center"),"right"===this.config.position&&shmi.addClass(this.element,"text-right"),this.config["font-family"]&&(this.element.style.fontFamily=this.config["font-family"]),this.config["font-size"])){var e=this.config["font-size"]+"px";this.element.style.fontSize=e}shmi.log("[TextElement] inited",1)},onEnable:function(){var e=this,t=shmi.requires("visuals.tools.numericValues"),s=shmi.requires("visuals.session.ItemManager");Array.isArray(e.config.items)&&e.config.items.forEach((function(n,a){var l,o=s.getItemHandler();e.vars.itemValues.push({value:null,unit:null,label:null}),o.setValue=function setValue(n,l,o){var r=s.getItem(o),c=null;r&&(r.adapter&&r.adapter.unitText?c=r.adapter.unitText:"string"==typeof r.unit&&(c=r.unit),e.vars.itemValues[a]={value:t.formatNumber(r.readValue(!0),{precision:r.digits,unit:r.unit,"show-unit":!1}),unit:c,label:r.labelToken},e.updateText())},l=s.subscribeItem(n,o),e.vars.tokens.push(l)}))},onDisable:function(){this.vars.tokens.forEach((function(e){e.unlisten()})),this.vars.tokens=[]},updateText:function(){var e=this;shmi.caf(e.vars.rafId),e.vars.rafId=shmi.raf((function(){e.isActive()&&(e.element.textContent=shmi.evalString(shmi.localize(e.config.text),{items:e.vars.itemValues}))}))}},shmi.extend(shmi.visuals.controls.TextElement,shmi.visuals.core.BaseControl),shmi.pkg("visuals.controls"),shmi.visuals.controls.TextElement2Date=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","text2 text2-date"),shmi.def(this.config,"text"," "),shmi.def(this.config,"name",null),shmi.def(this.config,"dateformat","$YYYY-$MM-$DD, $HH:$mm:$ss"),shmi.def(this.config,"invalid-text","---"),shmi.def(this.config,"convert-to-utc",!1),this.subscriptionId=null,this.localeStr=null,this.invalidText=null,this.value=null,this.startup()},shmi.visuals.controls.TextElement2Date.prototype={uiType:"text2-date",getClassName:function(){return"TextElement2Date"},onInit:function(){this.localeStr=shmi.localize(this.config.dateformat),this.invalidText=shmi.localize(this.config["invalid-text"]),this.element.textContent=this.invalidText},onSetValue:function(e){shmi.caf(this.RAF_ID),this.RAF_ID=shmi.raf(function(){e=parseInt(e);var t=null,s=shmi.requires("visuals.tools.date.formatDateTime");t=e>0?s(e,{datestring:this.localeStr,utc:this.config["convert-to-utc"]}):this.invalidText,this.element.textContent=t}.bind(this))},onEnable:function(){this.config.item&&(this.subscriptionId=this.subscribeItem(this.config.item))},onDisable:function(){this.config.item&&this.unsubscribeItem(this.config.item,this.subscriptionId)},onLock:function(){},onUnlock:function(){}},shmi.extend(shmi.visuals.controls.TextElement2Date,shmi.visuals.core.BaseControl),shmi.visuals.controls.TextElement2=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","text2"),shmi.def(this.config,"text"," "),shmi.def(this.config,"name",null),shmi.def(this.config,"precision",-1),shmi.def(this.config,"options",[]),shmi.def(this.config,"pattern",null),shmi.def(this.config,"type",shmi.c("TYPE_STRING")),shmi.def(this.config,"decimal-delimiter","."),shmi.def(this.config,"auto-precision",!0),shmi.def(this.config,"auto-type",!0),shmi.def(this.config,"value-as-tooltip",!1),shmi.def(this.config,"item",null),this.uiType="text2",this.subscriptionId=null,this.value=null,this.startup()},shmi.visuals.controls.TextElement2.prototype={uiType:"text2",getClassName:function(){return"TextElement2"},onInit:function(){var e=this,t=null;shmi.requires("visuals.tools.numericValues").initValueSettings(e),this.config.text&&(t=shmi.localize(this.config.text),this.element.textContent=t,e.config["value-as-tooltip"]&&e.setTooltip(t))},onSetValue:function(e){var t=this,s=shmi.requires("visuals.tools.numericValues");shmi.caf(this.RAF_ID),this.RAF_ID=shmi.raf(function(){var n=null;if(void 0!==this.config.options&&Array.isArray(this.config.options)&&this.config.options.length>0){const t=this.config.options.find((t=>Number.isSafeInteger(e)&&Number.isSafeInteger(t.mask)&&Number.isSafeInteger(t.value)?(BigInt(e)&BigInt(t.mask))===BigInt(t.value):t.value===e));t?(n=shmi.localize(t.label),this.element.textContent=n):this.element.textContent=e}else"string"==typeof t.config.pattern&&t.config.pattern.trim().length?(n=shmi.localize(shmi.evalString(t.config.pattern,{VALUE:e})),t.element.textContent=n):(n=s.formatOutput(e,t),this.element.textContent=n);t.config["value-as-tooltip"]&&("string"==typeof n&&""!==n?t.setTooltip(String(n)):t.setTooltip(t.getTooltip()))}.bind(this))},onSetProperties:function(e,t,s){shmi.requires("visuals.tools.numericValues").setProperties(this,arguments)},onEnable:function(){this.config.item&&(this.subscriptionId=this.subscribeItem(this.config.item))},onDisable:function(){this.config.item&&this.unsubscribeItem(this.config.item,this.subscriptionId)}},shmi.extend(shmi.visuals.controls.TextElement2,shmi.visuals.core.BaseControl),shmi.pkg("visuals.controls"),shmi.visuals.controls.ToggleButton=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","toggle-button"),shmi.def(this.config,"template","default/toggle-button"),shmi.def(this.config,"name",null),shmi.def(this.config,"on-value",1),shmi.def(this.config,"off-value",0),shmi.def(this.config,"confirm-off-text","${V_CONFIRM_OFF}"),shmi.def(this.config,"confirm-on-text","${V_CONFIRM_ON}"),shmi.def(this.config,"confirm-on",!1),shmi.def(this.config,"confirm-off",!1),shmi.def(this.config,"on-label","on"),shmi.def(this.config,"off-label","off"),shmi.def(this.config,"on-icon-src",null),shmi.def(this.config,"on-icon-class",null),shmi.def(this.config,"off-icon-class",null),shmi.def(this.config,"off-icon-src",null),shmi.def(this.config,"on-icon-title",null),shmi.def(this.config,"off-icon-title",null),shmi.def(this.config,"auto-label",!0),shmi.def(this.config,"show-text",!0),shmi.def(this.config,"show-icon",!1),shmi.def(this.config,"on-action",[]),shmi.def(this.config,"off-action",[]),"string"==typeof this.config["confirm-on"]&&(this.config["confirm-on"]="true"===this.config["confirm-on"]),"string"==typeof this.config["confirm-off"]&&(this.config["confirm-off"]="true"===this.config["confirm-off"]),this.value=0,this.labelElement=null,this.alternatives=null,this.listeners=[],this.initialized=!1,this.active=!1,this._subscriptionTargetId=null,this.onAction=null,this.offAction=null,this.startup()},shmi.visuals.controls.ToggleButton.prototype={uiType:"toggle-button",getClassName:function(){return"ToggleButton"},events:["change"],onInit:function(){var e=this,t=shmi.requires("visuals.core");if(this.value=this.config["off-value"],this.alternatives=[],this.offstate=shmi.getUiElement("off-state",this.element),this.onstate=shmi.getUiElement("on-state",this.element),this.offstate&&this.onstate&&(this.alternatives.push(this.offstate),this.alternatives.push(this.onstate)),2===this.alternatives.length){var s;if(this.offLabel=shmi.getUiElement("label",this.alternatives[0]),this.offLabel&&this.config["off-label"]&&(this.offLabel.textContent=shmi.localize(this.config["off-label"])),this.onLabel=shmi.getUiElement("label",this.alternatives[1]),this.onLabel&&this.config["on-label"]&&(this.onLabel.textContent=shmi.localize(this.config["on-label"])),0===Number(this.value)?this.alternatives[1].style.display="none":this.alternatives[0].style.display="none",this.onIcon=shmi.getUiElement("toggle-button-icon",this.onstate),this.onIcon)if(this.config["on-icon-class"])"IMG"===this.onIcon.tagName&&(s=document.createElement("div"),shmi.addClass(s,"icon"),this.onIcon.parentNode.insertBefore(s,this.onIcon),this.onIcon.parentNode.removeChild(this.onIcon),this.onIcon=s),this.config["on-icon-class"].trim().split(" ").forEach((function(t){shmi.addClass(e.onIcon,t)}));else this.config["on-icon-src"]&&("IMG"===this.onIcon.tagName?this.onIcon.setAttribute("src",this.config["on-icon-src"]):console.log(this.uiType,"toggle-button-icon element is not an img-tag!"));if(this.offIcon=shmi.getUiElement("toggle-button-icon",this.offstate),this.offIcon)if(this.config["off-icon-class"])"IMG"===this.offIcon.tagName&&(s=document.createElement("div"),shmi.addClass(s,"icon"),this.offIcon.parentNode.insertBefore(s,this.offIcon),this.offIcon.parentNode.removeChild(this.offIcon),this.offIcon=s),this.config["off-icon-class"].trim().split(" ").forEach((function(t){shmi.addClass(e.offIcon,e.config["off-icon-class"])}));else this.config["off-icon-src"]&&("IMG"===this.offIcon.tagName?this.offIcon.setAttribute("src",this.config["off-icon-src"]):console.log(this.uiType,"toggle-button-icon element is not an img-tag!"));this.config["show-icon"]&&this.config["show-text"]?shmi.addClass(this.element,"icon-and-text"):this.config["show-icon"]&&shmi.addClass(this.element,"icon-only");var n={};n.onPress=function(){shmi.addClass(this.element,"pressed")}.bind(this),n.onClick=function(){this.config["confirm-on"]||this.config["confirm-off"]?this.value===this.config["on-value"]?this.config["confirm-off"]?shmi.confirm(this.config["confirm-off-text"],function(e){e&&this.toggle()}.bind(this)):this.toggle():this.config["confirm-on"]?shmi.confirm(this.config["confirm-on-text"],function(e){e&&this.toggle()}.bind(this)):this.toggle():this.toggle()}.bind(this),n.onRelease=function(){shmi.log("[ToggleButton] button released",0),shmi.removeClass(this.element,"pressed")}.bind(this),this.listeners.push(new shmi.visuals.io.MouseListener(this.offstate,n)),this.listeners.push(new shmi.visuals.io.TouchListener(this.offstate,n)),this.listeners.push(new shmi.visuals.io.MouseListener(this.onstate,n)),this.listeners.push(new shmi.visuals.io.TouchListener(this.onstate,n)),shmi.log("[ToggleButton] -- all elements found --",1),!this.config.item&&this.config.event&&(this.config["on-value"]=1,this.config["off-value"]=0),Array.isArray(e.config["on-action"])&&e.config["on-action"].length&&(e.onAction=new t.UiAction(e.config["on-action"],e)),Array.isArray(e.config["off-action"])&&e.config["off-action"].length&&(e.offAction=new t.UiAction(e.config["off-action"],e))}else shmi.log("[ToggleButton] "+this.alternatives.length+" state elements provided",1)},toggle:function(){var e=this,t=shmi.requires("visuals.session.ItemManager"),s=e.value!==e.config["on-value"];e.config.item?e.value===e.config["on-value"]?t.writeValue(e.config.item,e.config["off-value"]):t.writeValue(e.config.item,e.config["on-value"]):e.value===e.config["off-value"]?e.setValue(e.config["on-value"]):e.setValue(e.config["off-value"]),s&&e.onAction?e.onAction.execute():!s&&e.offAction&&e.offAction.execute()},getTooltip:function(){var e=shmi.visuals.core.BaseControl.prototype.getTooltip.call(this);if(e)return e;if(this.value===this.config["off-value"]){if(shmi.objectHasOwnProperty(this.config,"off-tooltip"))return this.config["off-tooltip"];if(shmi.objectHasOwnProperty(this.config,"off-icon-title"))return this.config["off-icon-title"]}else if(this.value===this.config["on-value"]){if(shmi.objectHasOwnProperty(this.config,"on-tooltip"))return this.config["on-tooltip"];if(shmi.objectHasOwnProperty(this.config,"on-icon-title"))return this.config["on-icon-title"]}return null},onSetValue:function(e){var t=this.value;this.value=parseFloat(e),this.value===this.config["off-value"]?(this.alternatives[1].style.display="none",this.alternatives[0].style.display=""):(this.alternatives[0].style.display="none",this.alternatives[1].style.display=""),this.value!==t&&(this.setTooltip(this.getTooltip()),this.fire("change",{value:this.value}))},getValue:function(){return this.value},onEnable:function(){this.config.item&&(this._subscriptionTargetId=shmi.visuals.session.ItemManager.subscribeItem(this.config.item,this)),this.listeners.forEach((function(e){e.enable()})),shmi.log("[ToggleButton] enabled",1)},onDisable:function(){this.config.item&&shmi.visuals.session.ItemManager.unsubscribeItem(this.config.item,this._subscriptionTargetId),this.listeners.forEach((function(e){e.disable()})),shmi.log("[ToggleButton] disabled",1)},onLock:function(){for(var e=0;e<this.listeners.length;e++)this.listeners[e].disable();shmi.addClass(this.element,"locked"),shmi.log("[ToggleButton] locked",1)},onUnlock:function(){for(var e=0;e<this.listeners.length;e++)this.listeners[e].enable();shmi.removeClass(this.element,"locked"),shmi.log("[ToggleButton] unlocked",1)},onSetProperties:function(){},setLabel:function(e){this.config["auto-label"]&&(this.onLabel&&(this.onLabel.textContent=shmi.localize(e)),this.offLabel&&(this.offLabel.textContent=shmi.localize(e)))}},shmi.extend(shmi.visuals.controls.ToggleButton,shmi.visuals.core.BaseControl),shmi.pkg("visuals.controls"),shmi.visuals.controls.ToggleDisplay=function(e,t){this.element=e,this.config=t||{},this.parseAttributes(),shmi.def(this.config,"class-name","toggle-display"),shmi.def(this.config,"template","default/toggle-display"),shmi.def(this.config,"name",null),shmi.def(this.config,"labels",[]),shmi.def(this.config,"conditions",[]),this.value=0,this.labelElement=null,this.alternatives=null,this.currentState=0,this.initialized=!1,this.active=!1,this._subscriptionTargetId=null,this.vars={conditional:null},this.startup()},shmi.visuals.controls.ToggleDisplay.prototype={uiType:"toggle-display",getClassName:function(){return"ToggleDisplay"},onInit:function(){if(this.alternatives=shmi.getUiElements("state",this.element),0!==this.alternatives.length){this.labels=[];for(var e=0;e<this.alternatives.length;e++){var t=shmi.getUiElement("label",this.alternatives[e]);t&&(this.config.labels&&void 0!==this.config.labels[e]?t.textContent=shmi.localize(this.config.labels[e]):shmi.log("[ToggleDisplay] no label configured for state "+e,2)),this.labels.push(t)}for(e=0;e<this.alternatives.length;e++)shmi.addClass(this.alternatives[e],"hidden");shmi.removeClass(this.alternatives[0],"hidden"),shmi.log("[ToggleDisplay] -- all elements found --",1)}else shmi.log("[ToggleDisplay] "+this.alternatives.length+" state elements provided",2)},onSetValue:function(value){this.value=parseFloat(value),shmi.caf(this.requestID),this.requestID=shmi.raf(function(){for(var i=0;i<this.config.conditions.length;i++)if(eval(this.config.conditions[i].replace(/%VALUE%/g,value))){this.setSelected(i);break}}.bind(this))},setSelected:function(e){e!==this.currentState&&(shmi.addClass(this.alternatives[this.currentState],"hidden"),shmi.removeClass(this.alternatives[e],"hidden"),this.currentState=e)},getValue:function(){return this.value},onEnable:function(){var e=this;null!==e.vars.conditional?e.vars.conditional.item!==e.config.item&&(e.vars.conditional.item=e.config.item):e.config.item&&(e.vars.conditional=shmi.createConditional(e.element,e.config.item)),e.vars.conditional&&e.vars.conditional.enable(),this.config.item&&(this._subscriptionTargetId=shmi.visuals.session.ItemManager.subscribeItem(this.config.item,this)),shmi.log("[ToggleDisplay] enabled",1)},onDisable:function(){this.vars.conditional&&this.vars.conditional.disable(),this.config.item&&shmi.visuals.session.ItemManager.unsubscribeItem(this.config.item,this._subscriptionTargetId),shmi.log("[ToggleDisplay] disabled",1)},onLock:function(){shmi.addClass(this.element,"locked"),shmi.log("[ToggleDisplay] locked",1)},onUnlock:function(){shmi.removeClass(this.element,"locked"),shmi.log("[ToggleDisplay] unlocked",1)}},shmi.extend(shmi.visuals.controls.ToggleDisplay,shmi.visuals.core.BaseControl),shmi.pkg("visuals.controls.TrendDisplay"),shmi.visuals.controls.TrendDisplay=function(e,t){"use strict";var s=new shmi.visuals.controls.TrendDisplay.Data(this),n=new shmi.visuals.controls.TrendDisplay.Messaging,a=new shmi.visuals.controls.TrendDisplay.Promise,l=0,o=t||{};shmi.def(o,"class-name","trend-display"),shmi.def(o,"template","default/trend-display/base"),shmi.def(o,"name",null),shmi.def(o,"styleId",null),Object.defineProperty(this,"element",{value:e}),Object.defineProperty(this,"data",{value:s}),Object.defineProperty(this,"tStart",{value:shmi.getServerTime()}),Object.defineProperty(this,"config",{get:function(){return o},set:function(e){e instanceof shmi.visuals.controls.TrendDisplay.Configuration&&(o.isConfigured&&e.invalid||(o=e,a.resolve(o)))}}),Object.defineProperty(this,"onBroadcast",{value:n}),Object.defineProperty(this,"isConfigured",{value:a}),Object.defineProperty(this,"isPreparing",{get:function(){return l>0},set:function(e){e?(l||(shmi.addClass(this.element,"preparing"),this.broadcast(this,"preparation-started")),l++):(0===--l&&(shmi.removeClass(this.element,"preparing"),this.broadcast(this,"preparation-finished")),l<0&&(l=0))}}),this._components={},this.controls=[],this.parseAttributes(),this.startup()},shmi.visuals.controls.TrendDisplay.iconDimensions={height:16,width:16},shmi.visuals.controls.TrendDisplay.prototype={uiType:"trend-display",isContainer:!0,getClassName:function(){"use strict";return"TrendDisplay"},_manageResizeListeners:function(e){var t=this,s=null;this._onResize||(this._onResize=function(){s&&(window.clearTimeout(s),s=null),s=window.setTimeout((function(){s=null,t.broadcast(t,"resize")}),100)}),e?(window.addEventListener("resize",this._onResize,!1),window.addEventListener("visuals-layout-change",this._onResize,!1)):(window.removeEventListener("resize",this._onResize),window.removeEventListener("visuals-layout-change",this._onResize))},onRegister:function(e){var t=this,s=shmi.visuals.controls.TrendDisplay.Promise;t.config.display&&t.config.display.type&&("multilane"===t.config.display.type.toLowerCase()||"multi"===t.config.display.type.toLowerCase())&&shmi.addClass(t.element,"swim-lane"),t.isPreparing="initializing-base",t.onBroadcast.push([1e3,this._onBroadcastEarly,this]),t.onBroadcast.push([-1e3,this._onBroadcastLate,this]),s.resolve(new shmi.visuals.controls.TrendDisplay.Configuration(this).update(this.config).then((function(s){return t.config=s,t.isDeleted()||t.parseChildren(t.element,(function(s){t.discoverComponents(s),s.forEach((function(e){e.fire("discover",{trendDisplay:t})})),e()})),t})))},onInit:function(){"use strict";var e=this,t=shmi.visuals.controls.TrendDisplay;e._manageResizeListeners(!0);var s=new t.VirtualItems(e);Object.defineProperty(e,"items",{value:s}),e.isPreparing=!1},discoverComponents:function(e){"use strict";var t=this;return e.forEach((function(e){t.addComponent(e)})),this},getComponents:function(e){"use strict";var t=this._components;return shmi.objectHasOwnProperty(t,e)?t[e]:[]},addComponent:function(e){"use strict";var t,s;return(e instanceof shmi.visuals.core.BaseControl||shmi.objectHasOwnProperty(e,"uiType"))&&(t=e.uiType,s=this._components,shmi.objectHasOwnProperty(s,t)||(s[t]=[]),-1===(s=s[t]).indexOf(e)&&s.push(e)),this},everyComponent:function(e,t){"use strict";var s=this._components;arguments.length<2&&(t=e,e=null),e?(s[e]||[]).forEach(t):Object.keys(s).forEach((function(e){(s[e]||[]).forEach(t)}))},addInitializer:function(){},removeInitializer:function(){},_onBroadcastEarly:function(e){var t=this;switch(e.type){case"render":e.detail.suppress=this.isPreparing;break;case"configuration-changed":var s=e.detail.configuration;if(s.invalid)return this.lock(),!1;this.config=s,this.unlock();break;case"scale-size":var n=e.detail.now>1?e.detail.now-1:"none";[].forEach.call(t.element.classList,(function(e){0===e.indexOf("scale-size-")&&shmi.removeClass(t.element,e)})),shmi.addClass(this.element,"scale-size-"+n)}return!0},_onBroadcastLate:function(e){if("resize"===e.type)this.broadcast("render")},onEnable:function(){var e=this.getComponents("trend-display-continuous")[0],t=e?e.trend:null;t&&(t.active=!0,t.running=!0),this.everyComponent((function(e){e.enable()}))},onDisable:function(){var e=this.getComponents("trend-display-continuous")[0],t=e?e.trend:null;t&&(t.active=!1,t.running=!1),this.everyComponent((function(e){e.disable()}))},onDelete:function(){"use strict";var e=this;e.ctrls&&(Object.keys(e.ctrls).forEach((function(t){e.ctrls[t]&&shmi.deleteControl(e.ctrls[t])})),e.ctrls={}),this.everyComponent((function(e){shmi.deleteControl(e)})),this._components={},this._manageResizeListeners(!1),this.onBroadcast.reset();var t=this.items;t&&(t.items=null),localStorage.itemStyles=[]},broadcast:function(e,t,s){"use strict";return"object"==typeof s&&s||(s={}),this.onBroadcast.send({source:e,type:t,detail:s})}},shmi.visuals.controls.TrendDisplay.derive=function(e,t,s){"use strict";var n=e.prototype||{};e.prototype=Object.create(t.prototype),e.prototype.constructor=e,e.prototype.constructor._super=t,Object.getOwnPropertyNames(n).forEach((function(t){e.prototype[t]=n[t]})),e.prototype._super=function(e,t){var s;for(s=Object.getPrototypeOf(e.prototype);s;s=Object.getPrototypeOf(s))if("function"==typeof s[t])return s[t].apply(this,[].slice.call(arguments,2))};var a=String(e.name||s||"").trim();a&&!(a in e.prototype)&&Object.defineProperty(e.prototype,a,{value:e}),e.prototype.uiType&&shmi.log("derived type "+e.prototype.uiType,shmi.c("LOG_DEBUG"))},shmi.visuals.controls.TrendDisplay.onConfiguration=[],shmi.visuals.controls.TrendDisplay.nop=function(){},shmi.visuals.controls.TrendDisplay.limit=function(e,t,s){var n=parseFloat(e)||0;return n<t?t:n>s?s:n},shmi.visuals.controls.TrendDisplay.fastBind=function(e,t){return function(){return e.apply(t,arguments)}},shmi.visuals.controls.TrendDisplay.getScrollOffset=void 0!==window.pageXOffset&&void 0!==window.pageYOffset?function(){return{x:window.pageXOffset,y:window.pageYOffset}}:function(){return{x:(document.documentElement||document.body.parentNode||document.body).scrollLeft,y:(document.documentElement||document.body.parentNode||document.body).scrollTop}},shmi.visuals.controls.TrendDisplay.onUiAction=function(e,t,s){"use strict";var n=shmi.getControlByName(e,"trend-display");n?n.broadcast(null,"ui-"+t,{cause:"action",value:s||{}}):shmi.log("[UserAction] "+t+" - no control found by name '"+e+"'",2)},shmi.extend(shmi.visuals.controls.TrendDisplay,shmi.visuals.core.BaseControl),shmi.pkg("visuals.session"),shmi.visuals.session.sysActions=shmi.visuals.session.sysActions||{},shmi.visuals.session.sysActions["show-curve"]=function(e){"use strict";e.length<2?shmi.log("[UserAction] show-curve - usage is 'show-curve:<control-name>:<curve-name>[:<state>]'",2):shmi.visuals.controls.TrendDisplay.onUiAction(e[0],"show-curve",{curve:e[1],isVisible:e.length<3||shmi.toBoolean(e[2])})},shmi.visuals.controls.TrendDisplay.Messaging=function Messaging(e){this._listeners=[],this._listeners.nextId=0,this._sentBefore=shmi.visuals.controls.TrendDisplay.Promise.resolve(),Object.defineProperty(this,"synchronous",{get:function(){return e},set:function(t){e=!!t}}),Object.defineProperty(this,"length",{get:function(){return this._listeners.length}})},shmi.visuals.controls.TrendDisplay.Messaging.prototype={addListener:function(e,t,s){var n=this._listeners,a=this._normalizeListener.apply(this,arguments),l=this._indexOfListenerSignature(a);if(l>=0)return n[l][3];var o=++n.nextId;return n.push([a.prio,a.fn,a.context,o]),this._listeners=n.sort((function(e,t){return t[0]-e[0]})),o},push:function(e){return this.addListener.apply(this,arguments)},removeListener:function(e,t,s){var n=this.isListeningAt.apply(this,arguments);return n>=0&&this._listeners.splice(n,1),this},isListeningAt:function(e,t,s){return parseInt(e)>0&&1===arguments.length?this._indexOfListenerId(e):this._indexOfListenerSignature(this._normalizeListener.apply(this,arguments))},_normalizeListener:function(e,t,s){var n;return"function"==typeof(n=Array.isArray(e)?e:[e,t,s])[0]&&n.unshift(0),"function"!=typeof n[1]&&shmi.log("invalid listener callback",3),n[2]?"object"!=typeof n[2]&&shmi.log("TrendDisplay.Messaging._normalizeListener() invalid context for listener callback",3):n[2]=this,{prio:n[0],fn:n[1],context:n[2]}},_indexOfListenerId:function(e){var t,s,n=this._listeners;if((e=parseInt(e))>0)for(t=0,s=n.length;t<s;t++)if(n[t][3]===e)return t;return-1},_indexOfListenerSignature:function(e){var t,s,n=this._listeners;for(t=0,s=n.length;t<s;t++)if(n[t][1]===e.fn&&n[t][2]===e.context)return t;return-1},send:function(){var e,t,s;for(e=[],t=0,s=arguments.length;t<s;t++)e[t]=arguments[t];return this.synchronous?this._sendSynchronous(e):this._sendAsynchronous(e)},_sendSynchronous:function(e){var t,s,n,a,l=!1;for(t=0,s=(n=this._listeners).length;t<s&&!l;t++)!1===(a=n[t])[1].apply(a[2],e)&&(l=!0);return shmi.visuals.controls.TrendDisplay.Promise.resolve(l)},_sendAsynchronous:function(e){var t=this;return this._sentBefore=this._sentBefore.always((function(){var s=shmi.visuals.controls.TrendDisplay.Promise,n=!1;return s.resolve(t._listeners).each((function(t){var a=t[1].apply(t[2],e);return!1===a?n=!0:a instanceof s&&(a=a.then((function(e){return!1===e&&(n=!0),e}))),a}),(function(){return n})).then((function(){return n}))}))},merge:function(e){var t,s,n=e;if(n instanceof shmi.visuals.controls.TrendDisplay.Messaging&&(n=n._listeners),Array.isArray(n))for(t=0,s=n.length;t<s;t++)this.push(n[t]);return this},reset:function(){return this._listeners=[],this}},shmi.visuals.controls.TrendDisplay.Messaging.wrap=function(e){return(new shmi.visuals.controls.TrendDisplay.Messaging).merge(e)},shmi.visuals.controls.TrendDisplay.Object={injectFrozen:function injectFrozen(e,t,s){"use strict";var n=e;return Object.keys(t).forEach((function(e){var a=t[e];s&&(a=_deepFreeze(a)),Object.defineProperty(n,e,{value:a,enumerable:!0})})),e;function _deepFreeze(e){return e&&"object"==typeof e?Object.isFrozen(e)?e:(Object.getOwnPropertyNames(e).forEach((function(t){var s=e[t];"object"==typeof s&&function trySet(e,t,s){try{e[t]=s}catch(e){console.error("[TrendDisplay]",e)}}(e,t,_deepFreeze(s))})),Object.freeze(e)):e}},inject:function inject(e,t){"use strict";var s=e;return Object.keys(t).forEach((function(e){Object.defineProperty(s,e,{value:t[e],enumerable:!0,configurable:!0})})),e},injectObserved:function injectObserved(e,t,s,n,a){"use strict";var l=e,o="string"==typeof n?n:"";return Object.keys(t).forEach((function(e){var r=t[e];!n||null===r||"object"!=typeof r||Object.isFrozen(r)||Object.isSealed(r)||r.dontObserve||Array.isArray(r)||(r=shmi.visuals.controls.TrendDisplay.Object.injectObserved({},r,s,o+e+".",a)),a&&a.indexOf(o+e)>=0?Object.defineProperty(l,e,{value:r,enumerable:!0}):Object.defineProperty(l,e,{get:function(){return r},set:function(n){if(n!==t[e]){if("function"==typeof s)try{s(n,o+e,t[e])}catch(e){return}t[e]=n}},enumerable:!0})})),Object.seal(e),e},deepCopy:function deepCopy(e){var t;return Array.isArray(e)?(t=[],e.forEach((function(e){t.push(shmi.visuals.controls.TrendDisplay.Object.deepCopy(e))}))):e&&"object"==typeof e?(t={},Object.keys(e).forEach((function(s){t[s]=shmi.visuals.controls.TrendDisplay.Object.deepCopy(e[s])}))):t=e,t},mixinArray:function(e,t){Object.defineProperty(e,"length",{value:t}),e.map=function(t){return[].map.call(e,t)},e.filter=function(t){return[].filter.call(e,t)},e.some=function(t){return[].some.call(e,t)},e.every=function(t){return[].every.call(e,t)},e.reverse=function(t){return[].reverse.call(e,t)},e.sort=function(t){return[].sort.call(e,t)},e.forEach=function(t){return[].forEach.call(e,t)}}},shmi.visuals.controls.TrendDisplay.Promise=function Promise(e){"use strict";if(this._queue=[],this._state=0,this._length=1,this._creator=void 0,(shmi.visuals.session.config||{}).debug){var t,s,n,a=new Error("dummy"),l=0,o=shmi.visuals.controls.TrendDisplay.Promise._simpleTry((function(){return String(a.stack)}),(function(){return""})).split(/(?:\n\s+)/);for(s=0,n=o.length;s<n;s++)if((t=o[s]).match(/^\s*at\s+[^(]*\.Promise[.(]/))l=1;else if(l>0){l=2;break}var r=l>1&&t.match(/\/([/]+:\d+:\d+)\)?\s*$/);this._creator=r?r[1]:"unknown"}if("function"==typeof e&&e.length>=1){var c=this,_resolve=function(e){shmi.visuals.controls.TrendDisplay.Promise._resolve(c,e)},_reject=function(e){c.reject(e)};shmi.visuals.controls.TrendDisplay.Promise._simpleTry((function(){e(_resolve,_reject)}),_reject)}},shmi.visuals.controls.TrendDisplay.Promise.prototype={dontObserve:!0,isSettled:function(){"use strict";return!!this._state},isResolved:function(){"use strict";return this._state>0},isRejected:function(){"use strict";return this._state<0},then:function(e,t){"use strict";var s=new shmi.visuals.controls.TrendDisplay.Promise;if(s._creator=this._creator,s._length=this._length+1,e instanceof shmi.visuals.controls.TrendDisplay.Promise){var n=e;e=function(e){return n.resolve(e)}}else if("function"!=typeof e){var a=e;e=function(e){return void 0!==a?a:e}}if(t instanceof shmi.visuals.controls.TrendDisplay.Promise){var l=t;t=function(e){return l.reject(e)}}else if("function"!=typeof t){var o=t;t=function(e){throw void 0!==o?o:e}}return 1===this._queue.push([e,t,s])&&this._state&&shmi.visuals.controls.TrendDisplay.Promise._process(this),s},always:function(e){"use strict";return this.then(e,e)},resolve:function(e){"use strict";return this._state||(this._state=1,this._value=e,shmi.visuals.controls.TrendDisplay.Promise._process(this)),this},reject:function(e){"use strict";return this._state||(this._state=-1,this._value=e,shmi.visuals.controls.TrendDisplay.Promise._process(this)),this},catch:function(e){"use strict";var t=[].slice.call(arguments,0),s=t.pop();return this.then(void 0,(function(e){var n,a,l,o=!1;for(n=0,a=t.length;!o&&n<a;n++)"function"==typeof(l=t[n])&&(/^\S+Error$/.test(l.name)?e instanceof l&&(o=!0):o=l(e));return o||!a?s.call(s,e):(new shmi.visuals.controls.TrendDisplay.Promise).reject(e)}))},return:function(e){"use strict";return this.then((function(){return e}))},spread:function(e){"use strict";var t=this;return t.then((function(s){return"[object Array]"!==Object.prototype.toString.call(s)&&(s=[s]),e.apply(t,s)}))},each:function(e,t){"use strict";return"function"!=typeof t&&(t=shmi.visuals.controls.TrendDisplay.nop),this.then((function(s){if("[object Array]"!==Object.prototype.toString.call(s)&&!(s&&s.length>0))return s;var n=s.length;return function next(a){return a>=n?s:shmi.visuals.controls.TrendDisplay.Promise.resolve(e(s[a])).then((function(){return t.apply({},arguments)?s:next(a+1)}))}(0)}))},filter:function(e){"use strict";return this.then((function(t){if("[object Array]"!==Object.prototype.toString.call(t)&&!(t&&t.length>0))return t;var s=(t=[].slice.call(t)).length;return function next(n){return n>=s?shmi.visuals.controls.TrendDisplay.Promise.resolve(t):shmi.visuals.controls.TrendDisplay.Promise.resolve(e(t[n])).then((function(e){return e?next(n+1):(t.splice(n,1),s--,next(n))}))}(0)}))},find:function(e){"use strict";return this.then((function(t){"[object Array]"!==Object.prototype.toString.call(t)&&(t=[t]);var s=t.length;return function next(n){return n>=s?shmi.visuals.controls.TrendDisplay.Promise.resolve(null):shmi.visuals.controls.TrendDisplay.Promise.resolve(e(t[n])).then((function(e){return e?t[n]:next(n+1)}))}(0)}))},trigger:function(e){"use strict";return this.then((function(t){return e.resolve(t),t}),(function(t){throw e.reject(t),t}))},finally:function(e){"use strict";return this.then((function(t){return shmi.visuals.controls.TrendDisplay.Promise.invoke(e).always((function(){return t}))}),(function(t){return shmi.visuals.controls.TrendDisplay.Promise.invoke(e).always((function(){throw t}))}))}},shmi.visuals.controls.TrendDisplay.Promise._simpleTry=function(e,t){"use strict";try{return e()}catch(e){return t?t(e):e}},shmi.visuals.controls.TrendDisplay.Promise._applyTry=function(e,t,s,n){"use strict";try{return e.apply(s,n)}catch(e){return t?t(e):e}},shmi.visuals.controls.TrendDisplay.Promise._async=function(e){"use strict";var t=1,s={};function _async(e){var n=t++;n%100==0&&function reduceMap(){var e={};Object.keys(s).forEach((function(t){s[t]&&(e[t]=s[t])})),s=e}(),s[n]=e,window.postMessage(n,"*")}window.addEventListener("message",(function(e){var t,n=Number(e.data);n>0&&("function"==typeof(t=s[n])&&t(),s[n]=void 0)}),!1),shmi.visuals.controls.TrendDisplay.Promise._async=_async,_async(e)},shmi.visuals.controls.TrendDisplay.Promise._resolve=function _resolve(e,t){"use strict";e===t&&shmi.log("TrendDisplay.Promise_resorlve() promise on itself rejected",3);var s=!1;function onReject(t){s||(e.reject(t),s=!0)}if("object"==typeof t&&t){var n=t.then;if("function"==typeof n)return void shmi.visuals.controls.TrendDisplay.Promise._applyTry(n,onReject,t,[function onResolve(t){s||(_resolve(e,t),s=!0)},onReject])}e.resolve(t)},shmi.visuals.controls.TrendDisplay.Promise._process=function _process(e){"use strict";var t=shmi.visuals.controls.TrendDisplay.Promise,s=e._queue,n=s.shift();n||(n=s.shift()),n&&(s.length||s.push(!1),t._async((function processor(){var s=t._simpleTry((function(){t._resolve(n[2],(e._state>0?n[0]:n[1])(e._value))}));if(s){if((shmi.visuals.session.config||{}).debug){var a=s;/^\[object\s\S*Error]$/.test(Object.prototype.toString.call(s))&&(a=s.stack||s.message||String(s).replace(/@[^:]+:\/\/[^/]+\//gm,"@")),!/^\s*\S+Error/.test(a)&&s.message&&(a=s.message+"\nin "+a),/^\s*\S+Error/.test(a)||(a=s.constructor.name+": "+a),shmi.log("exception in thenable: "+a)}n[2].reject(s)}_process(e)})))},shmi.visuals.controls.TrendDisplay.Promise.invoke=function(e){"use strict";try{return shmi.visuals.controls.TrendDisplay.Promise.resolve(e())}catch(e){return shmi.visuals.controls.TrendDisplay.Promise.reject(e)}},shmi.visuals.controls.TrendDisplay.Promise.resolve=function(e){"use strict";return e instanceof shmi.visuals.controls.TrendDisplay.Promise?e:(new shmi.visuals.controls.TrendDisplay.Promise).resolve(e)},shmi.visuals.controls.TrendDisplay.Promise.reject=function(e){"use strict";return e instanceof shmi.visuals.controls.TrendDisplay.Promise&&e.isRejected()?e:new shmi.visuals.controls.TrendDisplay.Promise((function(t,s){e instanceof shmi.visuals.controls.TrendDisplay.Promise?e.always((function(){s(e)})):s(e)}))},shmi.visuals.controls.TrendDisplay.Promise.try=function(e){"use strict";return new shmi.visuals.controls.TrendDisplay.Promise((function(t){t(e())}))},shmi.visuals.controls.TrendDisplay.Promise.delay=function(e,t){"use strict";return new shmi.visuals.controls.TrendDisplay.Promise((function(e){setTimeout(e,t||0)}))},shmi.visuals.controls.TrendDisplay.Promise.all=function(e){"use strict";if(1===arguments.length&&Array.isArray(e))return shmi.visuals.controls.TrendDisplay.Promise.all.apply(this,e);var t,s,n=new shmi.visuals.controls.TrendDisplay.Promise,a=arguments,l=0,o={};try{a.length||n.resolve([]);var onSettling=function(e){if(++l>=e){var t,s=[];for(t=0;t<e;t++)s.push(o[t]);n.resolve(s)}};for(t=0,s=a.length;t<s;t++)step(t,s)}catch(e){n.reject(e)}return n;function step(e,t){a[e]instanceof shmi.visuals.controls.TrendDisplay.Promise?a[e].then((function(s){o[e]=s,onSettling(t)}),n):(o[e]=a[e],onSettling(t))}},shmi.visuals.controls.TrendDisplay.Promise.first=function(e){"use strict";if(1===arguments.length&&Array.isArray(e))return shmi.visuals.controls.TrendDisplay.Promise.all.apply(this,e);var t,s,n=new shmi.visuals.controls.TrendDisplay.Promise,a=arguments;try{for(a.length||n.resolve([]),t=0,s=a.length;t<s;t++)a[t].then(n,n)}catch(e){n.reject(e)}return n},shmi.visuals.controls.TrendDisplay.Parsers={aggregation:function(e,t,s){"use strict";if(null==e)return t;switch(String(e).trim().toLowerCase()){case"":return t;case"0":case"none":return 0;case"1":case"avg":case"average":return 1;case"2":case"min":case"minimum":return 2;case"3":case"max":case"maximum":return 3;case"4":case"sum":return 4;case"5":case"min-max":case"minimum-maximum":return 5}return arguments.length>2?s:t},timeSpanUnit:function(e,t,s){"use strict";var n=String(e||"").trim().replace(/(\d)(?:-|\s+)(\w)/,"$1$2").toLowerCase();switch(n){case"":return t;case"none":case"auto":return 0;case"s":case"sec":case"second":case"seconds":return 1;case"10s":case"10sec":case"10seconds":return 10;case"m":case"min":case"minute":case"minutes":return 180;case"10m":case"10min":case"10minutes":return 600;case"h":case"hour":case"hours":return 3600;case"d":case"day":case"days":return 86400;case"w":case"week":case"weeks":return 604800;case"month":case"months":return 2678400;case"y":case"year":case"years":return 31536e3;default:if((n=parseInt(n))>=0)return n}return arguments.length>2?s:t},valuedTimeSpan:function(e,t,s){"use strict";var n,a;if(a=/^\s*(\d+)\s*(s(?:ec(?:onds?)?)?|m(?:in(?:utes?)?)?|h(?:(?:ou)?rs?)?|d(?:ays?)?|w(?:eeks?)?|mon(?:ths?)?|y(?:(?:ea)rs?)?)?\s*$/i.exec(e))switch(n=Number(a[1]),a[2].toLowerCase().substr(0,2)){case"":case"s":case"se":return n;case"m":case"mi":return 60*n;case"h":case"ho":case"hr":return 3600*n;case"d":case"da":return 86400*n;case"w":case"we":return 7*n*86400;case"mo":return 31*n*86400;case"y":case"ye":case"yr":return 365*n*86400}else if(!String(e||"").trim().length)return t;return arguments.length>2?s:t},none:function(e){switch(String(e).trim()){case"":case"null":case"undefined":case"none":case"false":return null;default:return e}},color:function(e){"use strict";if("string"==typeof e){var t=null,s=/^(?:rgba?\s*\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)(?:\s*,\s*([01](?:\.\d*)?))?\s*\)|#([0-9a-f]{6})([0-9a-f]{2})?)$/i.exec(e);s&&(t={},"string"==typeof s[1]?(t.red=Math.min(255,s[1]),t.green=Math.min(255,s[2]),t.blue=Math.min(255,s[3]),t.hasAlpha=!!s[4],t.alpha=t.hasAlpha?parseFloat(s[4]):1,t.alpha>1&&(t.alpha=1)):(t.red=parseInt(s[5].substr(0,2),16),t.green=parseInt(s[5].substr(2,2),16),t.blue=parseInt(s[5].substr(4,2),16),t.hasAlpha="string"==typeof s[6],t.alpha=t.hasAlpha?parseInt(s[6],16)/255:1,t.alpha>1&&(t.alpha=1))),e=t}else e&&"object"==typeof e&&(e.hasAlpha|=e.alpha<1);return e&&"object"==typeof e&&(e.rgba="rgba("+e.red+","+e.green+","+e.blue+","+e.alpha+")",e.hex="#"+("00"+e.red.toString(16)).substr(-2)+("00"+e.green.toString(16)).substr(-2)+("00"+e.blue.toString(16)).substr(-2),e.hexa=e.hex+("00"+Math.round(255*e.alpha).toString(16)).substr(-2)),e},timestamp:function(e,t){"use strict";var s=null,n=parseInt(e);if(n>=-1&&isFinite(n))s=n;else switch(n=String(e).trim()){case"now":s=0;break;case"":s=t?-1:0;break;case"live":s=-1;break;default:n=Date.parse(n),isNaN(n)||(s=n.getTime()/1e3)}return s},width:function(e){"use strict";var t=null,s=/^\s*(\d+)\s*(?:px)?\s*$/.exec(e);return s&&(t=parseInt(s[1])),t},relative:function(e){"use strict";var t=null,s=/^\s*(0?(?:\.\d+)?|1(?:.0+)?)\s*$/.exec(e);return s&&(t=parseFloat(s[1])),t},positive:function(e){"use strict";return(e=parseInt(e))>0?e:null},dash:function(e){"use strict";return"string"==typeof e&&(e=e.trim().split(/(?:[,\s]+)/)),Array.isArray(e)&&(e=e.map((function(e){return parseInt(e)})).filter((function(e){return e}))).length>0?e:null},url:function(e){"use strict";if("string"==typeof e){var t=/^url\(\s*(["'])?\s*(.+)\s*(\1)\s*\)$/.exec(e);return t&&(e=t[2]),e}return e||null},isObject:function(e){return e?"object"==typeof e?e:(console.error("TrendDisplay.Parsers.isObject() expecting object, but found: "+e,3),null):{}},parseFilterAndSort:function(e,t,s){return e.map((function(e){return t(e)})).filter((function(e){return e})).sort(s?function rev(e,t){return t-e}:function fwd(e,t){return e-t})}},shmi.visuals.controls.TrendDisplay.VirtualItems=function(e){"use strict";var t=null;Object.defineProperty(this,"trendDisplay",{value:e}),Object.defineProperty(this,"items",{get:function(){return t&&t.curves||(t=this._createItems(t||{},e)),t},set:function(e){e?this._releaseSignalItems(t):t&&(this._releaseItems(t),t=null)}}),e.onBroadcast.push([900,this._onBroadcast,this])},shmi.visuals.controls.TrendDisplay.VirtualItems.prototype={_createSingleItem:function(e,t,s,n,a,l,o){var r=shmi.visuals.controls.TrendDisplay.nop,c=shmi.visuals.session.ItemManager,u={name:e,setValue:o?function _onChangeValue(e){u.lastValue=e;var t=u.suppress.indexOf(e);t>=0?u.suppress.splice(t,1):o.apply(this,arguments)}:r,setProperties:r,suppress:[],lock:r,unlock:r,properties:{access:["read","write"],data_type:null,digits:3===t?3:0,item_alias:e,label:null,min:n,max:a,prewarn:null,warn:null,step:0,unit:null,value_type:["string","bool","int","float"][t]},writeValue:function(e,t){shmi.objectHasOwnProperty(u,"lastValue")&&e===u.lastValue||(u.lastValue=e,o&&t&&u.suppress.push(e),c.getItem(u.name).writeValue(e))}},m=c.getItem(e),h=!m||!m.tdInitialized;return u.subscriptionId=c.subscribeItem(e,u),h&&(c.setProperties(u.properties),(m=c.getItem(e)).tdInitialized=!0),m.writeValue(l),u},_createGlobalItems:function(e,t){var s=this,n=shmi.c,a=n("TYPE_BOOL"),l=n("TYPE_FLOAT"),o=t.config,r="virtual:"+t.getName();return e.zoomX||(e.zoomX=s._createSingleItem(r+":zoomX",l,7,100*n("TREND_DISPLAY_ZOOM_SCALE_X_MIN"),100*n("TREND_DISPLAY_ZOOM_SCALE_X_MAX"),100,(function(e){t.broadcast(null,"ui-zoomX",{cause:"item",value:e})})),this._lockItem(e.zoomX,!1)),e.zoomY||(e.zoomY=s._createSingleItem(r+":zoomY",l,7,100*n("TREND_DISPLAY_ZOOM_SCALE_Y_MIN"),100*n("TREND_DISPLAY_ZOOM_SCALE_Y_MAX"),100,(function(e){t.broadcast(null,"ui-zoomY",{cause:"item",value:e})})),this._lockItem(e.zoomY,!1)),e.live||(e.live=s._createSingleItem(r+":live",a,7,0,1,o.invalid||"live"!==o.display.mode&&-1!==o.display.tEnd?0:1,(function(e){t.broadcast(null,"ui-live",{cause:"item",value:!!e})})),this._lockItem(e.live,!1)),e.handleTime||(e.handleTime=s._createSingleItem(r+":handleTime",l,7,0,1e13,parseInt((new Date).getTime()/1e3),(function(e){t.broadcast(null,"ui-handleTime",{cause:"item",value:e})})),this._lockItem(e.handleTime,!1)),e.leftTime||(e.leftTime=s._createSingleItem(r+":leftTime",l,7,0,1e13,parseInt((new Date).getTime()/1e3),(function(e){t.broadcast(null,"ui-leftTime",{cause:"item",value:e})})),this._lockItem(e.leftTime,!1)),e},_createPgmItems:function(e,t){var s=this,n=t.config,a="virtual:"+t.getName()+":";e.pgm={},n.program&&Array.isArray(n.program.items)&&n.program.items.forEach((function(t,n){var l=t.valueType.concat(t.valueIndex);e.pgm[l]=s._createSingleItem(a+l,shmi.c("TYPE_FLOAT"),7),console.debug("[TrendDisplay]","created item:",a+l)}))},_createSignalItems:function(e,t){var s=this,n=shmi.c,a=n("TYPE_BOOL"),l=n("TYPE_FLOAT"),o=t.config,r="virtual:"+t.getName()+":";return this._releaseSignalItems(e),e.curves={},!o.invalid&&o.trend&&o.trend.signals&&o.trend.signals.forEach((function(n,o){var c=n.alias||n.name,u=e.curves[c]={};u.value=s._createSingleItem(r+c+":value",l,7),u.visible=s._createSingleItem(r+c+":visible",a,7,0,1,n.visible?1:0,(function(e){t.broadcast(null,"ui-show-curve",{cause:"item",value:{curveName:c,curveIndex:o,isVisible:!!e}})}))})),o.program&&s._createPgmItems(e,t),e},_createItems:function(e,t){return this._createSignalItems(this._createGlobalItems(e,t),t)},_lockItem:function(e,t){var s=shmi.visuals.session.ItemManager,n=e.properties;t?n[4]|=16:n[4]&=-17,s.setProperties(n)},_releaseSignalItems:function(e){var t=shmi.visuals.session.ItemManager,s=e||{},n=s.curves||{};Object.keys(n).forEach((function(e){var s=n[e];t.unsubscribeItem(s.value.name,s.value.subscriptionId),t.unsubscribeItem(s.visible.name,s.visible.subscriptionId)})),s.curves=null},_releaseItems:function(e){if(e){var t=shmi.visuals.session.ItemManager;this._releaseSignalItems(e),e.zoomX&&(this._lockItem(e.zoomX,!0),t.unsubscribeItem(e.zoomX.name,e.zoomX.subscriptionId),e.zoomX=null),e.zoomY&&(this._lockItem(e.zoomY,!0),t.unsubscribeItem(e.zoomY.name,e.zoomY.subscriptionId),e.zoomY=null),e.live&&(this._lockItem(e.live,!0),t.unsubscribeItem(e.live.name,e.live.subscriptionId),e.live=null),e.handleTime&&(this._lockItem(e.handleTime,!0),t.unsubscribeItem(e.handleTime.name,e.handleTime.subscriptionId),e.handleTime=null),e.leftTime&&(this._lockItem(e.leftTime,!0),t.unsubscribeItem(e.leftTime.name,e.leftTime.subscriptionId),e.leftTime=null)}},_onBroadcast:function(e){"configuration-changed"===e.type&&(this.items=!0)},getByName:function(e,t){if(arguments.length<2)return this.items[e];var s=this.items.curves;if(s){var n=s[e];if(n)return n[t]||null}return null}},shmi.visuals.controls.TrendDisplay.AbstractRenderer=function(e,t){"use strict";var s=t.visible,n=new shmi.visuals.controls.TrendDisplay.DrawingContext(t,e),a=null,l=null,o=null,r=t.itemIndex;Object.defineProperty(this,"manager",{value:e}),Object.defineProperty(this,"signal",{value:t}),Object.defineProperty(this,"index",{get:function(){return r},set:function(e){var t=parseInt(e);!isNaN(t)&&t>=0&&(r=e)}}),Object.defineProperty(this,"visible",{get:function(){return s},set:function(e){s=!!e}}),Object.defineProperty(this,"drawingContext",{value:n}),Object.defineProperty(this,"path",{get:function(){return a||(a=this._createPathElement(this.manager.canvas)),a},set:function(){a&&(a.parentNode.removeChild(a),a=null)}}),Object.defineProperty(this,"css",{get:function(){if(!l){var e=this.path;l=e?window.getComputedStyle(e,null):{}}return l}}),Object.defineProperty(this,"style",{get:function(){return o||(o=this._getConfiguredStyle().getQualifiedByCss(this.css)),o}}),this._style=null},shmi.visuals.controls.TrendDisplay.AbstractRenderer.prototype={render:function(){"use strict";shmi.log("TrendDisplay: missing implemented curve renderer")},onDelete:function(){this.path=null},_getConfiguredStyle:function(){return this.manager.config.trend.items[this.signal.itemIndex].style},_createPathElement:function(e){}},shmi.visuals.controls.TrendDisplay.CanvasBackground=function(e,t,s){"use strict";this.labels=[],Object.defineProperty(this,"manager",{value:e}),Object.defineProperty(this,"units",{value:e.config.display.units}),Object.defineProperty(this,"drawingContext",{value:t}),Object.defineProperty(this,"curves",{value:s})},shmi.visuals.controls.TrendDisplay.CanvasBackground.prototype={render:function(e,t,s){"use strict";var n,a=s.getContext("2d"),l=e.viewport,o=e.trendDisplay.config.display,r=this.curves,c=this,u=[];a.lineWidth=.4,a.strokeStyle="rgba(0,0,0,0.5)",a.lineDashOffset=0,a.beginPath(),l.isMultiLane&&Object.keys(r).forEach((function(e,t){(n=c.curves[e].signal).visible&&(void 0===u[n.laneIndex]&&(u[n.laneIndex]=[]),u[n.laneIndex].push(n))}));var m=l.isDashboardView?u.length<o.lanesPerView?u.length:o.lanesPerView:1,h=o.labelHeight||0,d=s.height/2,f=(d-h*m)/m,v=d/(d-m*h);Object.keys(r).forEach((function(t,a){if((n=c.curves[t].signal).visible){var r=l.isMultiLane&&n?n.laneIndex:0,m=l.isSingleLane||l.isDetailView?0:h*r+f*r,g=d-m-f-o.firstLabelHeight;l.isMultiLane&&(c._generateLabels(e,s,n,u,m),l.isDashboardView&&c._generateDashboardActions(e,s,n,u,m)),(l.isSingleLane||l.isMultiLane&&(l.isDetailView||l.isDashboardView&&u[r][0]===n))&&c._generateBackgroundScaling(e,s,n,u,g,v)}})),l.isMultiLane&&c._generateDetailActions(e),a.stroke()},_generateDetailActions:function(e){var t=e.container,s=e.controls,n="detail-view-controls",a=e.trendDisplay,l=shmi.ctrl(a.getName()+"."+n);if(a.ctrls||(a.ctrls={}),a.ctrls[n]&&(l=a.ctrls[n]),!l){var o={"class-name":"detail-view-controls hidden",name:n};(l=shmi.createControl("container",t.parentNode.parentNode.parentNode,o,"div","before")).enable(),a.ctrls[n]=l,s.applyButtonCloseView(l.element,this)}},_generateDashboardActions:function(e,t,s,n,a){var l=e.container,o=s.laneIndex,r=e.controls,c=t.height/2,u="actions-lane-"+o,m=e.trendDisplay,h=shmi.ctrl(m.getName()+"."+u),d=m.config.display,f=d.labelHeight,v=n.length<d.lanesPerView?n.length:d.lanesPerView,g=(c-f*v)/v;if(m.ctrls||(m.ctrls={}),m.ctrls[u]&&(h=m.ctrls[u]),e.curves=this.curves,h)h.element.style.top=a+d.firstLabelHeight+"px",h.element.style.height=g+"px","applyButtonDetailView"!==m.changingView&&(h.element.className=h.element.className.replace(/(?:^|\s)hidden(?!\S)/g,""));else{var p={"class-name":"action",name:u};h=shmi.createControl("container",l.parentNode.parentNode.parentNode,p,"div"),m.ctrls[u]=h,h.element.style.top=a+d.firstLabelHeight+"px",h.element.style.height=g+"px",h.enable(),r.applyButtonDetailView(h.element,this,o,s)}},_generateBackgroundScaling:function(e,t,s,n,a,l){var o,r,c=e.container,u=e.viewport,m=this.drawingContext,h=t.getContext("2d"),d=e.trendDisplay.config.display,f=u.isDashboardView?(n.length<d.lanesPerView?n.length:d.lanesPerView)*l:l,v=shmi.getUiElement("styles",c.parentElement),g="rgba(0,0,0,0.5)",p="rgba(0,0,0,1)",b=.4,y=.4;if(v&&((o=shmi.getUiElement("grid-stroke",v))&&(g=getComputedStyle(o).color,b=parseFloat(getComputedStyle(o).strokeWidth)),(o=shmi.getUiElement("grid-stroke-hl",v))&&(p=getComputedStyle(o).color,y=parseFloat(getComputedStyle(o).strokeWidth))),u.isMultiLane){if(s.scaleVisible&&s.visible)if(h.setLineDash([0,0]),h.lineWidth=b,u.isDashboardView)[0,20/f,40/f,60/f,80/f,100/f].forEach((function(e){var s=m.value2Y(m.maxValue*e/100)-a;0===e||e===100/f?(h.strokeStyle=p,h.lineWidth=y):(h.strokeStyle=g,h.lineWidth=b),h.beginPath(),h.moveTo(0,s),h.lineTo(t.width,s),h.stroke()}));else for(var E=0;E<=100;E+=5){r=E/f;var C=m.value2Y(m.maxValue*r/100)-a-13;0===r||r===50/f||r===100/f?(h.strokeStyle=p,h.lineWidth=y):(h.strokeStyle=g,h.lineWidth=b),h.beginPath(),h.moveTo(0,C),h.lineTo(t.width,C),h.stroke()}}else{var x=m.minValue,T=m.maxValue,w=t.width,k=t.height;h.lineWidth=b,h.strokeStyle=g,h.lineDashOffset=0,h.beginPath(),[0,10,20,30,40,50,60,70,80,90,100].forEach((function(e){var t=m.value2Y(x+(T-x)*e/100);h.moveTo(0,t),h.lineTo(w,t)})),shmi.visuals.controls.TrendDisplay.CanvasBackground.getVerticalRasterTimestamps(this.units,u).forEach((function(e){var t=m.time2X(e,0);h.moveTo(t,0),h.lineTo(t,k)})),h.stroke()}var I=shmi.visuals.controls.TrendDisplay.CanvasBackground.getVerticalRasterTimestamps(this.units,u);d.hasVerticalScaling&&(h.lineWidth=.4,h.strokeStyle="rgba(162, 174, 177, 1)",h.beginPath(),I.forEach((function(e){var s=m.time2X(e,0);h.moveTo(s,0),h.lineTo(s,t.height)})),h.stroke()),h.lineWidth=2,h.strokeStyle="rgba(240, 241, 242, 1)",h.beginPath(),I.forEach((function(t){var s=m.time2X(t,0),n=new Date(1e3*t),a=e.trendDisplay,l=!!a.config["utc-time"]&&a.config["utc-time"],o=new Date(l?n.valueOf()+6e4*n.getTimezoneOffset():n);0===o.getHours()&&0===o.getMinutes()&&0===o.getSeconds()&&(h.moveTo(s,0),h.lineTo(s,m.value2Y(0)))})),h.stroke()},_generateLabels:function(e,t,s,n,a){var l=e.container,o=e.viewport,r=e.controls,c=l.ownerDocument,u=s.laneIndex,m=e.trendDisplay,h=m.config.display,d=o.isDashboardView?n.length<h.lanesPerView?n.length:h.lanesPerView:1,f=l.parentNode.parentNode.querySelector(".lane.index-"+u),v=shmi.ctrl(m.getName()+".select-box-multi-lane-"+u),g=h.labelHeight*d,p=(t.height/2-g)/d,b=(o.isDashboardView,p);if((void 0===m.detailView||null===m.detailView||m.detailView===u)&&s.scaleVisible&&s.visible)if(f){f.style.top=a+"px",f.getElementsByClassName("unit")[0].style.top=b+"px",f.getElementsByClassName("vMin")[0].style.top=Math.ceil(b)+"px";var y=f.getElementsByClassName("vMax")[0].className,E=f.getElementsByClassName("vMin")[0].className;o.isDashboardView&&"applyButtonDetailView"!==m.changingView?(f.getElementsByClassName("vMax")[0].className=y.replace(/(?:^|\s)hidden(?!\S)/g,""),f.getElementsByClassName("vMin")[0].className=E.replace(/(?:^|\s)hidden(?!\S)/g,""),h.demo&&v&&(v.element.className=v.element.className.replace(/(?:^|\s)hidden(?!\S)/g,""))):o.isDetailView&&"applyButtonCloseView"!==m.changingView&&(h.demo?v&&!v.element.className.match(/(?:^|\s)hidden(?!\S)/g)&&(v.element.className+=" hidden"):(y.match(/(?:^|\s)hidden(?!\S)/g)||(f.getElementsByClassName("vMax")[0].className+=" hidden",f.getElementsByClassName("vMin")[0].className+=" hidden"),this._generateSignalScalingValues(e,t,s)),f.className=f.className.replace(/(?:^|\s)hidden(?!\S)/g,""))}else{var C,x,T,w,k,I,S,L,D,_,O=s;S=String(O.label),L=String(O.unit),D=String(O.max),_=String(O.min),(C=c.createElement("div")).className="label",C.appendChild(c.createTextNode(shmi.localize(S))),(x=c.createElement("div")).className="unit",x.style.top=b+"px",x.appendChild(c.createTextNode(shmi.localize(L))),(I=c.createElement("div")).className="lane index-"+u,I.style.top=a+"px",I.appendChild(C),!v&&(o.isDashboardView||o.isDetailView)&&n[u].length>1?r.applySelectBoxLane(C,this,s,n):v&&(o.isDashboardView||h.demo&&o.isDetailView)&&(v.element.className=v.element.className.replace(/(?:^|\s)hidden(?!\S)/g,"")),(T=c.createElement("div")).className="values",(k=c.createElement("div")).className="vMax",k.appendChild(c.createTextNode(D)),T.appendChild(k),(w=c.createElement("div")).className="vMin",w.style.top=Math.ceil(b)+"px",w.appendChild(c.createTextNode(_)),T.appendChild(w),I.appendChild(T),I.appendChild(x),l.parentNode.parentNode.appendChild(I),o.isDetailView&&!h.demo&&"applyButtonCloseView"!==m.changingView&&this._generateSignalScalingValues(e,t,s)}},_generateSignalScalingValues:function(e,t,s){var n,a=e.container,l=e.viewport,o=a.ownerDocument,r=e.getCanvasSize(),c=this.units,u=this.curves[s.valueIndex].drawingContext,m=e.trendDisplay.config.display.labelHeight,h=a.parentNode.parentNode.querySelector(".scaling-values"),d=0,f=0,v=s.max-s.min,g=Math.pow(10,Math.ceil(Math.log(v)/Math.LN10)),p={},b=null;if(h?n=h:(n=o.createElement("div")).className="scaling-values",n.childElementCount){for(;n.firstChild;)n.removeChild(n.firstChild);this.labels=[]}var y=v/(u.visibleHeightInPixel-m);shmi.visuals.controls.TrendDisplay.Scale.forEachStep(u,r,c,c.scale.max,(function(e,t,n,a){e=Math.round(e*g)/g;var o=s.alias||s.name,c=t>=1,m=t<=0;e!==b&&t>=-.05&&t<=1.05&&(p[e]=[u.value2Y(e,1,l.zoomY,y)-r.y,o+(m?" lower value":c?" upper value":" value")],b=e),c&&-1===p[e][1].indexOf("upper")&&(p[e][1]=o+" upper value"),m&&-1===p[e][1].indexOf("lower")&&(p[e][1]=o+" lower value")}));var E=[];this.labels=this.labels.map((function(e){var t=e.value;return shmi.objectHasOwnProperty(p,t)?(e.elem.style.top=String(p[t][0])+"px",p[t]=void 0,e):(E.push(e),null)})).filter((function(e){return e})).concat(Object.keys(p).sort().map((function(e){var t,s=p[e];return s?(E.length?((t=E.shift()).elem.firstChild.nodeValue=String(e),t.value=e):((t={value:e,elem:o.createElement("span")}).elem.appendChild(o.createTextNode(String(e))),t.elem.style.left=String(d)+"px",t.elem.style.width=String(f)+"px",n.appendChild(t.elem)),t.elem.className=s[1],t.elem.style.top=String(s[0])+"px",t):null})).filter((function(e){return e}))),E.forEach((function(e){e.elem.parentNode.removeChild(e.elem)})),h||a.parentNode.parentNode.appendChild(n)},_highlightTrendCurve:function(e,t){var s,n=e.container,a=e.viewport,l=e.trendDisplay,o=t.valueIndex,r=t.laneIndex,c=l.config,u=n.parentNode.parentNode.querySelector(".lane.index-"+r),m=localStorage.itemStyles?JSON.parse(localStorage.itemStyles):[];c.trend.items.forEach((function(e,t){var n=c.styleManagers.inactiveStyle.color;e.laneIndex===r&&o!==t?(s=c.styles[e.styleIndex],m.length&&void 0!==m[e.signalIndex]&&(m[e.signalIndex]=s.color),c.styles[e.styleIndex]=s,m[e.signalIndex]=s.color):e.laneIndex===r&&o===t&&((s=c.styles[e.styleIndex]).color===n&&(s.color=m[e.signalIndex]),c.styles[e.styleIndex]=s,m[e.signalIndex]=null),localStorage.setItem("itemStyles",JSON.stringify(m))})),u&&(u.getElementsByClassName("label")[0].textContent=shmi.localize(t.label),u.getElementsByClassName("unit")[0].textContent=shmi.localize(t.unit),u.getElementsByClassName("vMin")[0].textContent=String(t.min),u.getElementsByClassName("vMax")[0].textContent=String(t.max)),l.config.update(c).then((function(){var e=l.getComponents("trend-display-continuous")[0].viewport;e=l.controls[0].viewport,l.items.items.live.writeValue(0),a.zoomX!==e.zoomX&&l.items.items.zoomX.writeValue(100*e.zoomX),a.zoomY!==e.zoomY&&l.items.items.zoomY.writeValue(100*e.zoomY),setTimeout((function(){a.leftTime!==e.leftTime&&l.items.items.leftTime.writeValue(e.leftTime),a.handleTime!==e.handleTime&&l.items.items.handleTime.writeValue(e.handleTime)}),250)}))},_updateTrendDisplay:function(e,t,s){var n=e.container,a=e.viewport,l=e.trendDisplay,o=t?t.valueIndex:null,r=s||"dashboard",c=shmi.cloneObject(l.config),u=c.display;c.display.view=r,"detail"===r?(a.isDetailView=!0,shmi.removeClass(l.element,"swim-lane")):(a.isDashboardView=!0,shmi.addClass(l.element,"swim-lane"));var m=n.parentNode.querySelectorAll(".lane");m&&shmi.requires("visuals.tools.iterate.iterateNodeList")(m,(function(e,t){e.remove()}));null!==o?c.trend.items.forEach((function(e,s){s===o?(e.scaleVisible=!0,e.visible=!0):u.demo||t.laneIndex!==e.laneIndex?(e.scaleVisible=!1,e.visible=!1):(e.scaleVisible=!1,e.visible=!0)})):c.trend.items.forEach((function(e,t){e.scaleVisible=!0,e.visible=!0})),c.viewport=a,l.config.update(c).then((function(){}))}},shmi.visuals.controls.TrendDisplay.derive(shmi.visuals.controls.TrendDisplay.CanvasBackground,shmi.visuals.controls.TrendDisplay.AbstractRenderer,"CanvasBackground"),shmi.visuals.controls.TrendDisplay.CanvasBackground.getVerticalRasterTimestamps=function(e,t){var s,n,a=t.minTime,l=t.visibleTimeSpan,o=(1+2*t.prefetch)*l,r=e.background,c=shmi.visuals.controls.TrendDisplay.Timeline.detectVisibleUnit(e.timeLine.available,l,r.timeLineMin,r.timeLineMax),u=shmi.visuals.controls.TrendDisplay.Timeline.detectVisibleUnit(e.timeLine.available,l,e.timeLine.min,e.timeLine.max),m=[];if(c>0)for(n=(s=Math.floor((t.leftRenderTime-a)/c)*c)+o;s<n;s+=c)m.push(a+s);if(u>0)for(n=(s=Math.floor((t.leftRenderTime-a)/u)*u)+o;s<n;s+=u)m.push(a+s);return m=m.sort().filter((function(e,t,s){return!t||e!==s[t-1]}))},shmi.visuals.controls.TrendDisplay.CanvasBackground.getTimestamps=function(){return[1474439364.872986,1474954461.981989,1474957469.004987,1475080519.644011,1475138756.23,1475128448.034015,1475129446.76,1475135071.640012,1475153465.722981,1476695351]},shmi.visuals.controls.TrendDisplay.onConfiguration.push([-10,function _onConfigureBackground(e,t,s){"use strict";if(e){var n,a,l,o=e.display.units;n=o.background=s.isObject(o.background),a=parseInt(n.timeLineMin),(isNaN(a)||a<1)&&(a=2),l=parseInt(n.timeLineMax),(isNaN(l)||l<1)&&(l=e.display.hasVerticalScaling?16:1440),n.timeLineMin=Math.min(a,l),n.timeLineMax=Math.max(a,l),a=parseInt(n.scaleMin),(isNaN(a)||a<1)&&(a=2),l=parseInt(n.scaleMax),(isNaN(l)||l<1)&&(l=16),n.scaleMin=Math.min(a,l),n.scaleMax=Math.max(a,l)}}]),shmi.visuals.controls.TrendDisplay.CanvasCurve=function CanvasCurve(e,t){"use strict";shmi.visuals.controls.TrendDisplay.CanvasCurve._super.call(this,e,t)},shmi.visuals.controls.TrendDisplay.CanvasCurve.prototype={_createPathElement:function(e){var t="path signal "+(this.signal.alias||this.signal.name),s=e.getElementsByClassName(t)[0];return s||((s=e.ownerDocument.createElement("path")).setAttribute("class",t),s=e.appendChild(s)),s},render:function(e,t,s){"use strict";if(this.signal&&(!this.visible||!t||!t.values))return null;var n,a=e.viewport,l=s.getContext("2d"),o=this.drawingContext,r=a.leftRenderTime,c=a.rightRenderTime,u=this.signal,m=u.valueIndex,h=a.isMultiLane?u.laneIndex:0,d=this.style.symbol,f=e.config.trend.signals.length,v=s.height/2,g=e.trendDisplay.config.display,p=g.labelHeight,b=0,y=a.isSingleLane?0:g.firstLabelHeight+30,E=v/(v-p),C=[],x=[],T=[],w=NaN,k=NaN,I=!0;if(d&&(x=shmi.visuals.controls.TrendDisplay.CanvasBackground.getVerticalRasterTimestamps(e.config.display.units,a)),this.style.applyOnCanvas(l),l.beginPath(),t.values.length&&(n=t.values[0][0]),a.isMultiLane&&a.isDashboardView){var S,L=e.curves;L&&L.forEach((function(e,t){u=e.signal,void 0===T[u.laneIndex]&&(T[u.laneIndex]=[]),T[u.laneIndex].push(u)})),f=T.length<g.lanesPerView?T.length:g.lanesPerView,E=f*(v/(v-f*p)),S=v/2-(b=(v-p*f)/f)/2+g.firstLabelHeight,y=p*h+b*h+S}return t.values.forEach((function(e,t){var s,u,h,f,v,g,p=e[0],b=e[1][m],T=y;if(!t){for(v=0,g=x.length;v<g&&!(x[v]>=p);v++);v>0&&x.splice(0,v-1)}if((p<c?p:c)>(g=n>r?n:r)){if(s=o.time2X(p,0),isFinite(b))if(u=h=o.value2Y(b,0),a.isMultiLane&&a.isDashboardView&&(u=u/E+y,h=h/E+y),I&&isFinite(w)&&(I=!1),I|=e[2])l.moveTo(s,u);else{if(isFinite(w)){var S=o.time2X(n,0),L=o.value2Y(w,0);a.isMultiLane&&a.isDashboardView&&(L=L/E+y),l.moveTo(S,L)}l.lineTo(s,u)}else if(b&&shmi.objectHasOwnProperty(b,"min")&&shmi.objectHasOwnProperty(b,"max")){I=!0;var D=parseFloat(b.min),_=parseFloat(b.max);if(isNaN(D)||isNaN(_))return;(u=o.value2Y(D,0))===(h=o.value2Y(_,0))&&(h=u+1),a.isMultiLane&&a.isDashboardView&&(u=u/E+y,h=h/E+y),l.moveTo(s,u),l.lineTo(s,h)}d&&x.length&&p>=x[0]&&(n<=x[0]?isFinite(b)&&isFinite(k)?I?(f=x.shift(),(!x.length||p-f<x[0]-p)&&C.push({x:s,y:u})):(s=x.shift(),f=(f=p-n)?(s-n)/(f/2):1,u=o.value2Y(k),a.isMultiLane&&a.isDashboardView&&(u=u/E+y),C.push({x:o.time2X(s,T),y:Math.round((h*f+u*(2-f))/2)})):(x.shift(),C.push({x:s,y:Math.round((u+h)/2)})):x.shift()),isFinite(b)&&(I=!1),w=NaN}else w=b;p>c||(k=isFinite(b)?Number(b):NaN,n=p)})),l.stroke(),C.length?d.then((function(e){C.forEach((function(t){l.drawImage(e,t.x-shmi.visuals.controls.TrendDisplay.iconDimensions.width/2,t.y-shmi.visuals.controls.TrendDisplay.iconDimensions.height/2)}))})):null}},shmi.visuals.controls.TrendDisplay.derive(shmi.visuals.controls.TrendDisplay.CanvasCurve,shmi.visuals.controls.TrendDisplay.AbstractRenderer,"CanvasCurve"),shmi.visuals.controls.TrendDisplay.CanvasRuler=function CanvasRuler(e,t,s){"use strict";shmi.visuals.controls.TrendDisplay.CanvasRuler._super.call(this,e,{min:s.min,max:s.max,curve:{}}),Object.defineProperty(this,"curves",{value:t}),Object.defineProperty(this,"units",{value:e.config.display.units})},shmi.visuals.controls.TrendDisplay.CanvasRuler.prototype={_createPathElement:function(e){var t="path ruler",s=e.getElementsByClassName(t)[0];return s||((s=e.ownerDocument.createElement("path")).setAttribute("class",t),s=e.appendChild(s)),s},_getConfiguredStyle:function(){return shmi.visuals.controls.TrendDisplay.Style.defaultStyle},render:function(e,t,s){"use strict";if(t){var n=shmi.visuals.controls.TrendDisplay,a=this.drawingContext,l=e.getCanvasSize(),o=s.getContext("2d"),r=t.dimensions.ruler,c=this.units,u=c.ruler.majorStepWidths;this.style.applyOnCanvas(o),o.beginPath(),n.Scale.forEachStep(a,l,c,c.ruler.max,(function(e,t,s,n){var c=a.value2Y(e);o.moveTo(r.x+r.width-r.width*u[n],c),o.lineTo(l.totalWidth,c)})),o.stroke()}}},shmi.visuals.controls.TrendDisplay.derive(shmi.visuals.controls.TrendDisplay.CanvasRuler,shmi.visuals.controls.TrendDisplay.CanvasCurve,"CanvasRuler"),shmi.visuals.controls.TrendDisplay.onConfiguration.push([-10,function _onConfigureRuler(e,t,s){"use strict";var n,a,l,o,r;e&&(l=(a=(n=e.display=s.isObject(e.display)).units=s.isObject(n.units)).ruler=s.isObject(a.ruler),Array.isArray(l.majorStepWidths)||(l.majorStepWidths=[1,1,.7,.5,.3,.2,.1,.05]),l.majorStepWidths=s.parseFilterAndSort(l.majorStepWidths,s.relative,!0),o=parseInt(l.min),(isNaN(o)||o<1)&&(o=1),r=parseInt(l.max),(isNaN(r)||r<1)&&(r=10),l.min=Math.min(o,r),l.max=Math.max(o,r))}]),shmi.visuals.controls.TrendDisplay.CanvasScale=function CanvasScale(e,t){"use strict";shmi.visuals.controls.TrendDisplay.CanvasScale._super.call(this,e,t),this.labels=[],Object.defineProperty(this,"units",{value:e.config.display.units})},shmi.visuals.controls.TrendDisplay.CanvasScale.prototype={render:function(e,t,s){"use strict";if(t){var n=this.signal,a=this.drawingContext,l=e.getCanvasSize(),o=t.dimensions.signals[this.index]||{x:0,width:0},r=Math.ceil(Math.log(n.max-n.min)/Math.LN10),c=null,u=this.manager.container,m=u.ownerDocument,h=this.units,d={};r=Math.pow(10,r),shmi.visuals.controls.TrendDisplay.Scale.forEachStep(a,l,h,h.scale.max,(function(e,t,s,l){e=Math.round(e*r)/r;var o=n.alias||n.name,u=t>=1,m=t<=0;e!==c&&t>=-.05&&t<=1.05&&(d[e]=[a.value2Y(e),o+(m?" lower value":u?" upper value":" value")],c=e),u&&-1===d[e][1].indexOf("upper")&&(d[e][1]=o+" upper value"),m&&-1===d[e][1].indexOf("lower")&&(d[e][1]=o+" lower value")}));var f=[];this.labels=this.labels.map((function(e){var t=e.value;return shmi.objectHasOwnProperty(d,t)?(e.elem.style.top=String(d[t][0])+"px",d[t]=void 0,e):(f.push(e),null)})).filter((function(e){return e})).concat(Object.keys(d).sort().map((function(e){var t,s=d[e];return s?(f.length?((t=f.shift()).elem.firstChild.nodeValue=String(e),t.value=e):((t={value:e,elem:m.createElement("span")}).elem.appendChild(m.createTextNode(String(e))),t.elem.style.left=String(o.x)+"px",t.elem.style.width=String(o.width)+"px",u.appendChild(t.elem)),t.elem.className=s[1],t.elem.style.top=String(s[0])+"px",t):null})).filter((function(e){return e}))),f.forEach((function(e){e.elem.parentNode.removeChild(e.elem)}))}},onDelete:function(){this.labels&&(this.labels.forEach((function(e){e.elem.parentNode.removeChild(e.elem)})),this.labels=[]),this._super(this.CanvasScale,"onDelete")}},shmi.visuals.controls.TrendDisplay.derive(shmi.visuals.controls.TrendDisplay.CanvasScale,shmi.visuals.controls.TrendDisplay.CanvasCurve,"CanvasScale"),shmi.visuals.controls.TrendDisplay.SvgCurve=function SvgCurve(e,t){"use strict";shmi.visuals.controls.TrendDisplay.SvgCurve._super.call(this,e,t)},shmi.visuals.controls.TrendDisplay.SvgCurve.prototype={render:function(e,t){"use strict";if(this.visible&&t&&t.values){var s=this.signal,n=this.drawingContext,a=e.viewport,l=a.leftRenderTime,o=a.rightRenderTime,r=!0,c=s.valueIndex,u=t.values;this.style.applyOnSvg(this.path),this.path.setAttribute("d",u.map((function(e){var t=e[0],s=e[1][c];if(t>=l&&t<=o){if(isFinite(s))return r?(r=!1,"M"+n.time2X(t)+" "+n.value2Y(s)):"L"+n.time2X(t)+" "+n.value2Y(s);if(s&&shmi.objectHasOwnProperty(s,"min")&&shmi.objectHasOwnProperty(s,"max")){r=!0;var a,u=parseFloat(s.min),m=parseFloat(s.max);return isNaN(u)||isNaN(m)?null:(a=n.time2X(t,0),(u=n.value2Y(u,0))===(m=n.value2Y(m,0))&&(m=u+1),"M"+a+" "+u+"L"+a+" "+m)}return null}return null})).join(""))}else this.path.setAttribute("d","")},_createPathElement:function(e){var t=e.getElementsByClassName(this.signal.alias||this.signal.name)[0];return t||((t=e.ownerDocument.createElementNS("http://www.w3.org/2000/svg","path")).setAttribute("class",this.signal.alias||this.signal.name),t=e.appendChild(t)),t}},shmi.visuals.controls.TrendDisplay.derive(shmi.visuals.controls.TrendDisplay.SvgCurve,shmi.visuals.controls.TrendDisplay.AbstractRenderer,"SvgCurve"),shmi.visuals.controls.TrendDisplay.AbstractRenderingManager=function(e,t,s,n,a){"use strict";var l=new shmi.visuals.controls.TrendDisplay.Messaging,o=new shmi.visuals.controls.TrendDisplay.Messaging(!0),r=new shmi.visuals.controls.TrendDisplay.Controls(this,s,[]);Object.defineProperty(this,"container",{value:e||t}),Object.defineProperty(this,"canvas",{value:t}),Object.defineProperty(this,"viewport",{value:s}),Object.defineProperty(this,"elementClass",{value:n}),Object.defineProperty(this,"onRender",{value:l}),Object.defineProperty(this,"onResize",{value:o}),Object.defineProperty(this,"config",{value:a}),Object.defineProperty(this,"controls",{value:r}),this._data=null,this._offsetX=0,this._offsetY=0,this._width=100,this._height=100},shmi.visuals.controls.TrendDisplay.AbstractRenderingManager.prototype={getData:function(){"use strict";return this._data},getCanvasSize:function(){"use strict";return{x:this._offsetX,y:this._offsetY,width:this._width,height:this._height,totalWidth:this._fullWidth,totalHeight:this._fullHeight}},update:function(e,t){"use strict";return e&&(this._data=e),t?shmi.visuals.controls.TrendDisplay.Promise.resolve(!1):this.resetLocation().onRender.send(this,this.getData())},resize:function(e,t,s,n){"use strict";if(e=parseInt(e),t=parseInt(t),e&&t&&(e!==this._width||t!==this._height)){shmi.log("resizing canvas to "+e+" x "+t,0);var a=this,l=this._offsetX=Math.ceil(e*(s||0)),o=this._offsetY=Math.ceil(t*(n||s||0));return this._width=e,this._height=t,this._fullWidth=e+2*l,this._fullHeight=t+2*o,this.canvas.setAttribute("width",this._fullWidth),this.canvas.setAttribute("height",this._fullHeight),this.resetLocation(),this.onResize.send(this,e,t).then((function(){return a.update()}))}return null},resetLocation:function(){"use strict";return this.container.style.left=String(-this._offsetX)+"px",this.container.style.top=String(-this._offsetY)+"px",this},onSlide:function(e,t){"use strict";this.container.style.left=String(-this._offsetX+t)+"px"},onShift:function(e,t){"use strict";this.container.style.top=String(-this._offsetY+t)+"px"},onDelete:function(){this.onRender.reset(),this.onResize.reset()}},shmi.visuals.controls.TrendDisplay.CanvasRenderingManager=function CanvasRenderingManager(e,t,s,n,a,l){"use strict";var o;shmi.visuals.controls.TrendDisplay.CanvasRenderingManager._super.call(this,e,t,s,n,a,l),Object.defineProperty(this,"trendDisplay",{value:l,writable:!1}),Object.defineProperty(this,"offscreen",{get:function(){return o||(o=document.createElement("canvas")),o},set:function(e){e||(o=void 0)}}),this._enableImplicitRenderingSteps()},shmi.visuals.controls.TrendDisplay.CanvasRenderingManager.prototype={update:function(e,t){"use strict";return e&&(this._data=e),t?shmi.visuals.controls.TrendDisplay.Promise.resolve(!1):this.onRender.send(this,this.getData(),this.offscreen)},_enableImplicitRenderingSteps:function(){var e=this,t=this.canvas,s=this.offscreen;this.onRender.addListener(1e3,(function _initialRenderingStep(){s.width=t.width,s.height=t.height,s.getContext("2d").clearRect(0,0,s.width,s.height)})),this.onRender.addListener(-1e3,(function _finalRenderingStep(){var n=t.getContext("2d");n.clearRect(0,0,t.width,t.height),e.resetLocation(),n.drawImage(s,0,0)}))},onDelete:function(){this.offscreen=null}},shmi.visuals.controls.TrendDisplay.derive(shmi.visuals.controls.TrendDisplay.CanvasRenderingManager,shmi.visuals.controls.TrendDisplay.AbstractRenderingManager,"CanvasRenderingManager"),shmi.visuals.controls.TrendDisplay.SvgRenderingManager=function SvgRenderingManager(e,t,s,n,a){"use strict";shmi.visuals.controls.TrendDisplay.SvgRenderingManager._super.call(this,e,t,s,n,a)},shmi.visuals.controls.TrendDisplay.SvgRenderingManager.prototype={resize:function(e,t,s){"use strict";if(e=parseInt(e),t=parseInt(t),e&&t&&(e!==this._width||t!==this._height)){var n=this._offsetX=Math.ceil(e*(s||0));this.canvas.style.left=String(-n)+"px",this.canvas.setAttribute("width",e+2*n),this.canvas.setAttribute("height",t),this.canvas.setAttribute("viewBox",n+" 0 "+e+" "+t),this._width=e,this._height=t}}},shmi.visuals.controls.TrendDisplay.derive(shmi.visuals.controls.TrendDisplay.SvgRenderingManager,shmi.visuals.controls.TrendDisplay.AbstractRenderingManager,"SvgRenderingManager"),shmi.visuals.controls.TrendDisplay.DrawingContext=function(e,t){var s,n,a,l,o,r,c,u=shmi.visuals.controls.TrendDisplay,m=t.viewport,h=t.getCanvasSize(),d=e.min,f=e.max,v=f-d;function _updateViewport(){s=m.zoomY,n=m.leftTime,a=d+v*m.zoomFocusY,l=m.visibleTimeSpan/h.width,r=v/o}function _updateCanvasSize(){h=t.getCanvasSize(),o=h.height,c=h.y+o/2,_updateViewport.call(this)}function round(e,t){var s=Math.pow(10,t||0);return Math.round(e*s)/s}d===f&&shmi.log("[TrendDisplay.DrawingContext] Min/Max values not set or equal for signal "+(e.alias||e.name),3),t.onResize.addListener(_updateCanvasSize,this),m.onUpdate.addListener(100,_updateViewport,this),Object.defineProperty(this,"visibleHeightInPixel",{get:function(){return o}}),Object.defineProperty(this,"minValue",{value:e.min}),this.manager=t,Object.defineProperty(this,"maxValue",{value:e.max}),this.time2X=function(e,t){return round((e-n)/l+h.x,t>=0?t:0)},this.x2Time=function(e){return(e-h.x)*l+n},this.value2Y=function(e,t,n,l){return round(c-((e||0)-a)*(n||s)/(l||r),t||0)},this.y2Value=function(e,t){return a-(e-c)*r/(t||s)},this.relative2Y=function(e,t,s){return this.value2Y(e*v+d,t,s)},this.relative2Value=function(e){return e*v+d},this.y2Relative=function(e,t){return(this.y2Value(e,t)-d)/v},this.minFocus=function(e){return(this.y2Value(this.value2Y(d,0,e)-o/2,e)-d)/v},this.maxFocus=function(e){return(this.y2Value(this.value2Y(f,0,e)+o/2,e)-d)/v},this.y2Focus=function(e){return(this.y2Value(e)-d)/v},this.focus2Y=function(e){return this.value2Y(e*v+d)},this.deriveFocusY=function(e,t){var s;return s=d+m.zoomFocusY*v+(1/m.zoomY-1/e)*v/o*t,u.limit((s-d)/v,this.minFocus(e),this.maxFocus(e))},_updateCanvasSize.call(this)},shmi.visuals.controls.TrendDisplay.Viewport=function Viewport(e){"use strict";var t,s,n,a=null,l=null,o=e.maxTime,r="live"===e.mode,c=r?0:o,u=!0,m=new shmi.visuals.controls.TrendDisplay.Messaging,h=this,d=null,f=e.type&&("singlelane"===e.type.toLowerCase()||"single"===e.type.toLowerCase()),v=e.type&&("multilane"===e.type.toLowerCase()||"multi"===e.type.toLowerCase()),g=""===e.view||e.view&&"detail"===e.view.toLowerCase(),p=""!==e.view&&(e.view&&"dashboard"===e.view.toLowerCase());switch(e.mode){case"now":case"live":t=limitStart((s=o)-e.visible);break;default:t=e.minTime,s=o}function limitStart(t){var s=e.minTime;return t<s?s:t}function limitEnd(e,t){var s=t?h.maxLeftTime:o;return e>s?s:e}function slideTo(e,n){e!==t&&(n.push("leftTime"),setHandleTime(e+(h.handleTime-t))&&n.push("handleTime"),s=e+(s-t),t=e),n.length>0&&_onUpdated(n)}function setHandleTime(e){var t=Number(e);if(t>0&&(t=limitStart(limitEnd(t)))!==c){if(t>=o&&r){if(0===c)return!1;t=0}return c=t,!0}return!1}function _onUpdated(e){e.length>0&&(u=!1,d?d.queue=d.queue.concat(e):m.send(h,e))}n={x:1,y:1,focusY:.5},Object.defineProperty(this,"isSingleLane",{get:function(){return f},set:function(e){var t=!!e;t!==f&&(f=t,v=!t)}}),Object.defineProperty(this,"isMultiLane",{get:function(){return v},set:function(e){var t=!!e;t!==v&&(v=t,f=!t)}}),Object.defineProperty(this,"isDetailView",{get:function(){return g},set:function(e){var t=!!e;t!==g&&(g=t,p=!t)}}),Object.defineProperty(this,"isDashboardView",{get:function(){return p},set:function(e){var t=!!e;t!==p&&(p=t,g=!t)}}),Object.defineProperty(this,"pristine",{get:function(){return u},set:function(){u=!0}}),Object.defineProperty(this,"onUpdate",{value:m}),Object.defineProperty(this,"minTime",{value:e.minTime}),Object.defineProperty(this,"maxTime",{get:function(){return o}}),Object.defineProperty(this,"prefetch",{value:e.prefetch}),Object.defineProperty(this,"isLive",{get:function(){return r},set:function(e){var t=!!e;t!==r&&(r=t,_onUpdated(["isLive"]))}}),Object.defineProperty(this,"minSampleTime",{get:function(){return a||this.minTime},set:function(e){e=Number(e),!isNaN(e)&&e>0&&e<a&&(a=e)}}),Object.defineProperty(this,"maxSampleTime",{get:function(){return l},set:function(e){var t=Number(e);t>0&&(t>l&&(l=t),t>o&&(o=t,r?slideTo(this.maxLeftTime,["maxTime"]):_onUpdated(["maxTime"])))}}),Object.defineProperty(this,"programEndTime",{set:function(e){var t=Number(e);t>0&&(t<l&&(t=l),t!==o&&(o=t,_onUpdated(["maxTime"])))},get:function(){return null}}),Object.defineProperty(this,"zoomX",{get:function(){return n.x},set:function(a){var l=parseFloat(a);if(!isNaN(l)&&l>0){var r=e.minTime,c=o,u=c-r,m=Math.min(u,e.visible/l);if((l=e.visible/m)!==n.x){n.x=l;var h=this.handleTime,d=["zoomX","handleTime"],f=h-m/2,v=h+m/2;f<r?v=(f=r)+m:v>c&&(f=(v=c)-m),t===f&&s===v||(t=f,s=v,d.push("leftTime")),_onUpdated(d)}}}}),Object.defineProperty(this,"minZoomX",{get:function(){var t=e.visible/(o-e.minTime),s=shmi.c("TREND_DISPLAY_ZOOM_SCALE_X_MIN");return t>s?t:s}}),Object.defineProperty(this,"maxZoomX",{value:shmi.c("TREND_DISPLAY_ZOOM_SCALE_X_MAX")}),Object.defineProperty(this,"zoomY",{get:function(){return n.y},set:function(e){var t=Number(e);t<this.minZoomY&&(t=this.minZoomY),t>this.maxZoomY&&(t=this.maxZoomY),t!==n.y&&(n.y=t,_onUpdated(["zoomY"]))}}),Object.defineProperty(this,"minZoomY",{value:shmi.c("TREND_DISPLAY_ZOOM_SCALE_Y_MIN")}),Object.defineProperty(this,"maxZoomY",{value:shmi.c("TREND_DISPLAY_ZOOM_SCALE_Y_MAX")}),Object.defineProperty(this,"zoomFocusY",{get:function(){return n.focusY},set:function(e){var t=Number(e);t<0&&(t=0),t>1&&(t=1),t!==n.focusY&&(n.focusY=t,_onUpdated(["zoomFocusY"]))}}),Object.defineProperty(this,"handleTime",{get:function(){return c||o},set:function(e){setHandleTime(e)&&_onUpdated(["handleTime"])}}),Object.defineProperty(this,"leftTime",{get:function(){return t},set:function(e){var t=Number(e);t>0&&slideTo(limitStart(limitEnd(t,!0)),[])}}),Object.defineProperty(this,"minLeftTime",{value:e.minTime}),Object.defineProperty(this,"maxLeftTime",{get:function(){return limitStart(o-(s-t))}}),Object.defineProperty(this,"rightTime",{get:function(){return s},set:function(e){isNaN(e)||(this.leftTime=Number(e)-(s-t))}}),Object.defineProperty(this,"visibleTimeSpan",{get:function(){return s-t}}),Object.defineProperty(this,"now",{get:function(){return shmi.getServerTime()}}),Object.defineProperty(this,"leftRenderTime",{get:function(){return limitStart(t-e.prefetch*(s-t))}}),Object.defineProperty(this,"rightRenderTime",{get:function(){return limitEnd(s+e.prefetch*(s-t))}}),Object.defineProperty(this,"transaction",{get:function(){return!!d},set:function(e){if(e)d?d.locks++:d={locks:1,queue:[],watchdog:setTimeout((function(){shmi.log("viewport transaction locked for more than 2s",2)}),2e3)};else if(d&&!--d.locks){var t=d.queue;clearTimeout(d.watchdog),d=null,t.length>0&&m.send(this,t)}}}),Object.defineProperty(this,"transactionQueue",{get:function(){return d?d.queue:[]},set:function(e){e&&d&&Array.isArray(e)&&(d.queue=d.queue.filter((function(t){return e.indexOf(t)>=0}))),!e&&d&&(d.queue=[])}})},shmi.visuals.controls.TrendDisplay.Viewport.prototype={deriveLeftMaxShiftPixels:function(e){"use strict";return Math.round((this.leftTime-this.minLeftTime)/this.visibleTimeSpan*e)},deriveRightMaxShiftPixels:function(e){"use strict";return Math.round((this.maxLeftTime-this.leftTime)/this.visibleTimeSpan*e)},deriveLeftPrefetchPixels:function(e){"use strict";return Math.round((this.leftTime-this.leftRenderTime)/this.visibleTimeSpan*e)},deriveRightPrefetchPixels:function(e){"use strict";return Math.round((this.rightRenderTime-this.rightTime)/this.visibleTimeSpan*e)},onDelete:function(){this.onUpdate.reset()}},shmi.visuals.controls.TrendDisplay.Viewport.validateDescriptor=function(e){"use strict";var t,s,n=e.tStart||"",a=e.tEnd||"",l=e.tDisplay||1800,o=e.prefetchPercentage||50,r=e.type||"singleLane",c=e.view||"",u=e.lanesPerView||5,m=e.labelHeight||50,h=e.firstLabelHeight||0,d=e.handleBarOffset||0,f=e.hasVerticalScaling||!0,v=e.demo||!1;return(t=/^\*(.+)\s*%\s*$/.exec(o))&&(o=t[1]),(o=Number(o))>1&&(o/=100)>1&&(o=1),(!o||o<0)&&(o=0),null===(t=shmi.visuals.controls.TrendDisplay.Parsers.timestamp(a,!0))&&(shmi.log("TrendDisplay.Viewport() invalid maxTime in configuration: "+a),t=0),"static"!==(s=0===(a=t)?"latest":-1===a?"live":"static")&&(a=shmi.getServerTime()),t=parseInt(n),isFinite(t)?t>0?n=t:t<0?n+=a:shmi.log("TrendDisplay.Viewport() invalid/missing time stamp in tStart",3):(n=Date.parse(String(n).trim()),isNaN?shmi.log("TrendDisplay.Viewport() invalid/missing time stamp in tStart",3):n=n.getTime()/1e3),n>a&&(t=n,n=a,a=t),l>(t=a-n)&&(l=t),{mode:s,minTime:n,maxTime:a,visible:l,prefetch:o,type:r,view:c,lanesPerView:u,firstLabelHeight:h,labelHeight:m,handleBarOffset:d,hasVerticalScaling:f,demo:v}},shmi.visuals.controls.TrendDisplay.onConfiguration.push([90,function _onConfigureViewport(e,t){"use strict";e.invalid||(e.viewport=shmi.visuals.controls.TrendDisplay.Viewport.validateDescriptor(e.display))}]),shmi.pkg("visuals.controls.TrendDisplay"),shmi.visuals.controls.TrendDisplay.Component=function Component(e,t){"use strict";var s=new shmi.visuals.controls.TrendDisplay.Promise,n=[];Object.defineProperty(this,"element",{value:e}),Object.defineProperty(this,"onBroadcast",{get:function(){return n},set:function(e){e&&Array.isArray(n)&&(n=e.merge(n))}}),Object.defineProperty(this,"isPrepared",{value:s}),this.trendDisplay={broadcast:shmi.visuals.controls.TrendDisplay.nop},this.config=this._initializeConfiguration(t||{}),this.parseAttributes(),this.startup()},shmi.visuals.controls.TrendDisplay.Component.prototype={events:shmi.visuals.core.BaseControl.prototype.events.concat("discover"),_initializeConfiguration:function(e){},broadcast:function(e,t){"use strict";return this.trendDisplay.broadcast(this,e,t)},onInit:function(){"use strict";shmi.addClass(this.element,"undiscovered");var e=this;this.listen("discover",(function(){return e.onDiscover.apply(e,arguments)}))},onDiscover:function(e){"use strict";var t=e.detail.trendDisplay;Object.defineProperty(this,"trendDisplay",{value:t}),this.onBroadcast=t.onBroadcast.merge(this.onBroadcast),this.markDiscovered()},markDiscovered:function(){"use strict";shmi.removeClass(this.element,"undiscovered"),shmi.addClass(this.element,"discovered")},onDelete:function(){}},shmi.visuals.controls.TrendDisplay.derive(shmi.visuals.controls.TrendDisplay.Component,shmi.visuals.core.BaseControl),shmi.visuals.controls.TrendDisplay.Controls=function(e,t,s){"use strict";var n=shmi.objectHasOwnProperty(s,"tokens")?s.tokens:[],a=shmi.objectHasOwnProperty(s,"buttons")?s.buttons:[],l=shmi.objectHasOwnProperty(s,"selectboxes")?s.selectboxes:[];Object.defineProperty(this,"manager",{value:e}),Object.defineProperty(this,"viewport",{value:t}),Object.defineProperty(this,"controls",{get:function(){return this._getControls()},set:function(e){e&&Array.isArray(e)&&(this.tokens=e.tokens,this.buttons=e.buttons,this.selectboxes=e.selectboxes)}}),Object.defineProperty(this,"tokens",{value:n}),Object.defineProperty(this,"buttons",{value:a}),Object.defineProperty(this,"selectboxes",{value:l})},shmi.visuals.controls.TrendDisplay.Controls.prototype={_getControls:function(){var e={};return e.tokens=this.tokens,e.buttons=this.buttons,e.selectboxes=this.selectboxes,e},applyButtonCloseView:function(e,t){var s=this.manager,n="close-view-button",a=s.trendDisplay,l=shmi.ctrl(a.getName()+"."+n);if(!l){var o={name:n,"class-name":"rh-button close","icon-class":"icon icon-ui-close","show-icon":!0,"show-text":!1},r=(l=shmi.createControl("button",e,o,"div")).listen("click",(function(n){a.changingView="applyButtonCloseView",a.detailView=null,shmi.removeClass(s.trendDisplay.element,"detail-view"),shmi.addClass(s.trendDisplay.element,"hidden");for(var l=s.container.parentNode.parentNode.parentNode.querySelectorAll(".lane, .action"),o=0;o<l.length;++o){var r=l[o];r.className=r.className.replace(/(?:^|\s)hidden(?!\S)/g,"")}var c=e.parentNode.parentNode.querySelector(".scaling-values");c&&(c.innerHTML=""),t._updateTrendDisplay(s,null,"dashboard")}));l.enable(),this.tokens.push(r),this.buttons.push(l)}return l},applyButtonDetailView:function(e,t,s,n){var a=this.manager,l="detail-view-button-"+s,o=a.trendDisplay,r=shmi.ctrl(o.getName()+"."+l);if(!r){var c={"class-name":"select-trend-button detail-view",name:l,"icon-class":"icon icon-trends-chart-extend","show-icon":!0},u=(r=shmi.createControl("button",e,c,"div")).listen("click",(function(e){o.changingView="applyButtonDetailView",o.detailView=s;var l=shmi.ctrl(o.getName()+".select-box-multi-lane-"+s);l&&(n=a.config.trend.signals[l.value]);for(var r=a.container.parentNode.parentNode.parentNode.querySelectorAll(".lane, .action"),c=0;c<r.length;++c){r[c].className+=" hidden"}shmi.addClass(o.element,"detail-view"),shmi.removeClass(shmi.ctrl(o.getName()+".detail-view-controls").element,"hidden"),t._updateTrendDisplay(a,n,"detail")}));r.enable(),this.tokens.push(u),this.buttons.push(r)}return r},applyButtonNavigateTimeline:function(e,t,s,n){var a=this.manager,l="scroll-"+s+"-timeline-"+e+"-"+n,o=shmi.ctrl(a.trendDisplay.getName()+"."+l),r="left"===e?-2:2;if(!o){var c={label:"","class-name":"button arrow "+e,name:l,"show-icon":!0,"show-text":!1,"icon-class":"icon icon-ui-move-"+e};o=shmi.createControl("button",t,c,"div",n);var u=0,m=o.listen("click",(function(t){u++,setTimeout((function(){1===u?shmi.visuals.session.userActions["trend-display"].call(this,a.trendDisplay.getName()+",handleTime,"+r):"right"===e?shmi.visuals.session.userActions["trend-display"].call(this,a.trendDisplay.getName()+",toggleLiveMode,-1"):shmi.visuals.session.userActions["trend-display"].call(this,a.trendDisplay.getName()+",handleTime,"+r),u=0}),200)}));o.enable(),this.tokens.push(m),this.buttons.push(o)}return o},applySelectBoxLane:function(e,t,s,n){var a=this.manager,l=this.viewport,o=s.laneIndex,r="select-box-multi-lane-"+o,c=shmi.ctrl(a.trendDisplay.getName()+"."+r),u=n[o];if(!c){var m="",h=!0,d=[],f={};u.forEach((function(e,t){(f={}).label=shmi.localize(e.label),f.value=e.valueIndex,d.push(f),0===t&&(m=e.valueIndex)}));var v={label:"",options:d,selected:m,name:r,"class-name":"rh-select-box",template:"custom/rh-controls/rh-select-box"},g=(c=shmi.createControl("select-box",e,v,"DIV","after")).listen("change",(function(e){h?h=!1:t._highlightTrendCurve(a,a.config.trend.signals[e.detail.value])}));c.setValue(m),c.enable(),this.tokens.push(g),this.selectboxes.push(c)}return l.isMultiLane&&(l.isDetailView?c.element.className+=" hidden":l.isDashboardView&&c.element.className.replace(/(?:^|\s)hidden(?!\S)/g,"")),c},deleteControls:function(e,t){t=t||!1,e&&e.forEach((function(e){if(shmi.getControlByElement(e.element)){var s=e.element.parentNode;"trend-display-timeline"!==s.getAttribute("data-ui")&&t&&s&&e.element?shmi.deleteControl(shmi.getControlByElement(s)):shmi.deleteControl(e,!0)}}))},deleteControlButtons:function(e){this.deleteControls(this.buttons,e),this.buttons=[]},deleteControlSelectboxes:function(){this.deleteControls(this.selectboxes),this.selectboxes=[]},deleteControlTokens:function(){this.tokens&&(this.tokens.forEach((function(e){e.unlisten()})),this.tokens=[])},onDelete:function(){this.deleteControlTokens(),this.deleteControlButtons(!0),this.deleteControlSelectboxes()}},shmi.visuals.controls.TrendDisplay.Continuous=function TrendDisplayContinuous(e,t){"use strict";shmi.visuals.controls.TrendDisplay.Continuous._super.call(this,e,t);var s=null,n=null,a=null,l=[],o=this._initUiControl(e),r=new shmi.visuals.controls.TrendDisplay.Messaging(!0),c=new shmi.visuals.controls.TrendDisplay.Messaging(!0),u=new shmi.visuals.controls.TrendDisplay.Messaging(!0);Object.defineProperty(this,"viewport",{get:function(){return s||null},set:function(e){(!e||e.isConfigured&&!e.invalid)&&(s&&(s.onUpdate.removeListener(this._onDirtyCanvas,this),s.onDelete()),e&&(s=new shmi.visuals.controls.TrendDisplay.Viewport(e.viewport)).onUpdate.push([this._onDirtyCanvas,this]))}}),Object.defineProperty(this,"width",{get:function(){return this.element.offsetWidth}}),Object.defineProperty(this,"height",{get:function(){return this.element.offsetHeight}}),Object.defineProperty(this,"mouseInput",{value:o.mouse}),Object.defineProperty(this,"touchInput",{value:o.touch}),Object.defineProperty(this,"onSlide",{value:r}),Object.defineProperty(this,"onShift",{value:c}),Object.defineProperty(this,"onState",{value:u}),Object.defineProperty(this,"curves",{get:function(){return l},set:function(e){e.isConfigured&&!e.invalid&&(l=this._generateCurves(e))}}),Object.defineProperty(this,"renderer",{get:function(){return a},set:function(e){(!e||e.isConfigured&&!e.invalid)&&(a&&(r.removeListener(a.onSlide,a),c.removeListener(a.onShift,a),a.onDelete()),e&&(a=this._generateRenderingManager(e),r.addListener(a.onSlide,a),c.addListener(a.onShift,a)))}}),Object.defineProperty(this,"trend",{get:function(){return n},set:function(e){e.isConfigured&&!e.invalid&&(n=this.trendDisplay.data.getTrendByName(e.trend.name))}})},shmi.visuals.controls.TrendDisplay.Continuous.prototype={uiType:"trend-display-continuous",isContainer:!1,getClassName:function(){"use strict";return"TrendDisplayContinuous"},_initializeConfiguration:function(e){"use strict";return shmi.def(e,"class-name","trend-display-continuous"),shmi.def(e,"template","default/trend-display/component/continuous"),e},onInit:function(){"use strict";this._super(this.TrendDisplayContinuous,"onInit")},_interactionMode:{pinching:!1,sliding:!1,shifting:!1},_initUiControl:function(e){"use strict";var t,s,n,a,l,o=shmi.visuals.controls.TrendDisplay,r=this,c=r._interactionMode,u={base:{x:0,y:0},current:{x:0,y:0},applied:{x:0,y:0},focus:{x:0,y:0},throttle:null};function _onChangingZoom(){u.throttle||(u.throttle=setTimeout(_onThrottlingZoom,50))}function _onThrottlingZoom(){u.throttle=null,u.current.x===u.applied.x&&u.current.y===u.applied.y||_applyZoom()}function _applyZoom(){var e=r.viewport;e.transaction=!0,u.applied.x=u.current.x,u.applied.y=u.current.y,e.handleTime=u.focus.x,e.zoomFocusY=u.focus.y,e.zoomX=u.current.x,e.zoomY=u.current.y,e.transaction=!1}function _zoomY(e,t){var s=r.viewport,n=r.getDC();n&&(u.current.y=o.limit(e,s.minZoomY,s.maxZoomY),isNaN(t)||(u.focus.y=n.deriveFocusY(u.current.y,-(t-r.renderer.getCanvasSize().height/2))))}return s={onPress:function(e,s,o){if(!r.trendDisplay.locked){var c=r.viewport,m=r.renderer,h=r.getDC();n=m.getCanvasSize(),t=m.canvas,u.base.x=u.current.x=u.applied.x=c.zoomX,u.base.y=u.current.y=u.applied.y=c.zoomY,function _initSlide(e,t,s,n){if(n){var l=n.time2X(t.leftTime,0),o=n.time2X(t.minLeftTime,0),r=n.time2X(t.maxLeftTime,0);(a={start:parseInt(s.style.left)||0}).end=a.start,a.min=a.start-(r-l),a.max=a.start+(l-o)}}(0,c,t,h),function _initShift(e,t,s,n,a){if(n){var o=n.value2Y(n.minValue,0),r=n.value2Y(n.maxValue,0);(l={start:parseInt(s.style.top)||0}).end=l.start,l.min=-(o-a.height),l.max=-r}}(0,0,t,h,n)}},onRelease:function(e,t,s){var n=r.trendDisplay,u=r.viewport,m=r.getDC();if(a&&a.end!==a.start&&(u.leftTime=m.x2Time(m.time2X(u.leftTime,0)+(a.start-a.end))),l&&l.end!==l.start&&(u.zoomFocusY=o.limit(m.y2Focus(m.focus2Y(u.zoomFocusY)-(l.end-l.start)),m.minFocus(),m.maxFocus())),c.sliding&&(u.transaction=!1,c.sliding=!1,shmi.removeClass(r.element,"sliding"),n.broadcast(r,"slide-end")),c.shifting&&(u.transaction=!1,c.shifting=!1,shmi.removeClass(r.element,"shifting"),n.broadcast(r,"shift-end")),c.pinching){var h=shmi.getUiElement("pinch-canvas",r.element.parentNode);u.transaction=!1,c.pinching=!1,_applyZoom(),shmi.removeClass(r.element,"pinching"),h&&(h.style.display="none"),n.broadcast(r,"pinch-end")}},onClick:function(e,t,s){if(!r.trendDisplay.locked&&"CANVAS"===s.target.nodeName&&r.getDC()){var a=r._globalToLocal(e,t);r.viewport.handleTime=r.getDC().x2Time(a.x+n.x)}},onDoubleClick:function(e,t,s){},onDrag:function(e,t,s){var n;r.trendDisplay.locked||a&&((n=o.limit(a.end+e,a.min,a.max))!==a.end?(a.end=n,c.sliding||(r.viewport.transaction=!0,c.sliding=!0,shmi.addClass(r.element,"sliding"),r.trendDisplay.broadcast(r,"slide-start"),r.trend.running=!1,r.viewport.isLive=!1),r.onSlide.send("move",n-a.start)):n===a.start&&(r.trend.running=!0,r.viewport.isLive=!0),(n=o.limit(l.end+t,l.min,l.max))!==l.end&&(l.end=n,c.shifting||(r.viewport.transaction=!0,c.shifting=!0,shmi.addClass(r.element,"shifting"),r.trendDisplay.broadcast(r,"shift-start")),r.onShift.send("move",n-l.start)),s.preventDefault(),s.stopPropagation())},onScale:function(e,t,s,a,l,o){if(!r.trendDisplay.locked){var m=shmi.getUiElement("pinch-canvas",r.element.parentNode);if(!r.viewport.isDashboardView){if(c.pinching||(r.viewport.transaction=!0,c.pinching=!0,shmi.addClass(r.element,"pinching"),r.trendDisplay.broadcast(r,"pinch-start"),u.focus.x=r.getDC().x2Time(t+n.x),m&&(m.style.display="block")),m){m.width=m.parentNode.getBoundingClientRect().width,m.height=m.parentNode.getBoundingClientRect().height;var h=getComputedStyle(m).color,d=m.getContext("2d"),f=o[2],v=o[3],g={x:f.x<v.x?f.x:v.x,y:f.y<v.y?f.y:v.y,width:Math.abs(f.x-v.x),height:Math.abs(f.y-v.y)};d.clearRect(0,0,m.width,m.height),d.beginPath(),d.strokeStyle=h,d.setLineDash([4,2]),d.rect(g.x,g.y,g.width,g.height),d.stroke()}_zoomY(u.base.y*(l+Math.sqrt(l))/2,s),u.current.x=u.base.x*(a+Math.sqrt(a))/2,_onChangingZoom()}}},onWheel:function(e,t){if(r.trendDisplay&&!r.trendDisplay.locked){t.preventDefault();var s=r._globalToLocal(t.clientX,t.clientY),n=r.viewport;if(t.shiftKey)u.current.x=e>0?n.zoomX*shmi.c("TREND_DISPLAY_ZOOM_SCALE_X"):n.zoomX/shmi.c("TREND_DISPLAY_ZOOM_SCALE_X"),u.focus.y=n.zoomFocusY,_zoomY(n.zoomY),_onChangingZoom();else if(n.isDashboardView){var a=r.trendDisplay.config.display;if(!a.demo&&"CANVAS"===t.target.nodeName){var l=parseInt(e/10),o=-parseInt(t.target.height,10)/4,c=parseInt(t.target.style.top,10)+l;if(c<o){var m=t.target.parentNode.getElementsByClassName("lane");if(c>o-2*a.labelHeight*(m.length-5)){r.trend.running=!1,r.viewport.isLive=!1,t.target.style.top=String(c)+"px";for(var h=t.target.parentNode.parentNode.parentNode.querySelectorAll(".lane, .action, .handle-bar .value, .handle-bar .signal"),d=0;d<h.length;++d){var f=h[d];f.style.top=String(parseInt(f.style.top,10)+l)+"px"}}}}}else u.current.x=n.zoomX,_zoomY(e>0?n.zoomY*shmi.c("TREND_DISPLAY_ZOOM_SCALE_Y"):n.zoomY/shmi.c("TREND_DISPLAY_ZOOM_SCALE_Y"),s.y),_onChangingZoom()}}},{mouse:new shmi.visuals.io.MouseListener(e,s),touch:new shmi.visuals.io.TouchListener(e,s)}},getDC:function(){"use strict";var e=this.curves[0];return e&&e.drawingContext},_globalToLocal:function(e,t){"use strict";var s=shmi.getAbsPosition(this.element),n=shmi.visuals.controls.TrendDisplay.getScrollOffset();return{x:e-s.x+n.x,y:t-s.y+n.y}},onEnable:function(){"use strict";this.isPrepared.then((function(e){e.mouseInput.enable(),e.touchInput.enable(),e.onResize(),e.enableTrendStream(!0)}))},onDisable:function(){"use strict";this.enableTrendStream(!1),this.mouseInput.disable(),this.touchInput.disable()},onDelete:function(){"use strict";var e=this;e.mouseInput.disable(),e.touchInput.disable(),e.viewport=null,e.enableTrendStream(!1),e.trendDisplay&&e.trendDisplay.config&&e.trendDisplay.config.trend&&e.trendDisplay.config.trend.signals&&e.trendDisplay.config.trend.signals.forEach((function(t,s){var n=shmi.ctrl("."+e.renderer.config.name+".actions-lane-"+s);n&&shmi.deleteControl(n,!0)})),e.renderer&&e.renderer.controls&&e.renderer.controls.onDelete(),e.renderer=null,e.onSlide.reset(),e.onShift.reset(),e.onState.reset(),e._super(e.TrendDisplayContinuous,"onDelete")},onDiscover:function(e){"use strict";var t=e.detail.trendDisplay;t.isPreparing="discover-continuous",this._super(this.TrendDisplayContinuous,"onDiscover",e),this._configure(t.config),this.onBroadcast.push([100,this._onBroadcast,this]),this.isPrepared.resolve(this),t.isPreparing=!1},_configure:function(e){"use strict";if(!e.invalid){var t,s=shmi.visuals.controls.TrendDisplay;if(e.noRecal||(this.viewport=e),this.renderer=e,this.trend=e,this.curves=e,this.controls=e,this.trend.gotData.isResolved()){var n=this.trend.data;this.viewport.minSampleTime=n.startTime,this.viewport.maxSampleTime=n.endTime}t=new s.CanvasBackground(this.renderer,this.getDC(),this.curves),this.renderer.onRender.push([50,t.render,t])}},_generateRenderingManager:function(e){"use strict";var t=this,s=shmi.visuals.controls.TrendDisplay,n=shmi.getUiElement("continuous-canvas-container",t.element),a=shmi.getUiElement("continuous-canvas",n||t.element);switch(((a||{}).nodeName||"").toLowerCase()){case"svg":return new s.SvgRenderingManager(n,a,t.viewport,s.SvgCurve,e);case"canvas":return new s.CanvasRenderingManager(n,a,t.viewport,s.CanvasCurve,e,t.trendDisplay);default:return shmi.log("TrendDisplay: missing canvas for rendering trend curves",2),new s.AbstractRenderingManager(n,a||{style:{}},t.viewport,(function _privateClass(){}),{})}},_generateCurves:function(e){"use strict";var t=this.renderer,s=t.elementClass,n=[];return void 0!==e.trend.signals&&(n=e.trend.signals.map((function(e,n){var a=new s(t,e);return a.index=n,t.onRender.push([a.render,a]),a}))),n},onResize:function(){var e=this.element;this.renderer&&this.renderer.resize(e.offsetWidth,e.offsetHeight,this.viewport.prefetch)},enableTrendStream:function(e){"use strict";var t=this.trend;t&&(e?(t.onData.addListener(this._onTrendData,this),this._configureTrend(t).running=!0):(t.running=!1,t.onData.removeListener(this._onTrendData,this)))},_onTrendData:function(e){var t=this.viewport,s=e.data;t.transaction=!0,t.minSampleTime=s.startTime,t.maxSampleTime=s.endTime,t.isLive&&this._setLeftTimeInLiveMode(t),this.renderer.update(s,this.trendDisplay.isPreparing||t.transactionQueue.length>0),this.broadcast("trend-update",{trend:e}),t.transaction=!1},_updateViewportRelatedItems:function(e){var t=this.trendDisplay.items,s=this.viewport;t&&((!e.length||e.indexOf("isLive")>=0)&&t.getByName("live").writeValue(s.isLive?1:0,!0),(!e.length||e.indexOf("zoomY")>=0)&&t.getByName("zoomY").writeValue(100*s.zoomY,!0),(!e.length||e.indexOf("zoomX")>=0)&&t.getByName("zoomX").writeValue(100*s.zoomX,!0),(!e.length||e.indexOf("handleTime")>=0)&&t.getByName("handleTime").writeValue(s.handleTime,!0),(!e.length||e.indexOf("leftTime")>=0)&&t.getByName("leftTime").writeValue(s.leftTime,!0))},_setLeftTimeInLiveMode:function(e){return e.transaction=!0,this.onState.send(this,{mode:"live",viewport:e}).then((function(t){t||(e.rightTime=e.maxSampleTime)})).finally((function(){e.transaction=!1}))},_setInitialHandleTime:function(e){var t=this;return e.transaction=!0,this.onState.send(this,{mode:"handleTime",viewport:e}).then((function(s){if(!s)if(e.isLive){var n=e.maxSampleTime,a=t.getDC(),l=t.renderer.getCanvasSize();a.time2X(n)>=l.x+l.width&&(n=a.x2Time(l.x+l.width-1)),e.handleTime=n}else t.trendDisplay.config.noRecal?t._onUpdateHandleTime(e.handleTime):e.handleTime=(e.leftTime+e.rightTime)/2})).finally((function(){e.transaction=!1}))},_onDirtyCanvas:function(e,t){"use strict";var s=!1,n=this.trend,a=t.filter((function(e){return"initialize"!==e}));this._updateViewportRelatedItems(a),t.indexOf("initialize")<0&&(t.indexOf("isLive")>=0&&e.isLive&&(this._setLeftTimeInLiveMode(e),s=!0),e.handleTime&&this._onUpdateHandleTime(e.handleTime),t.indexOf("zoomX")>=0&&(n.running=!1,e.isLive=!1),e.transactionQueue.length||this.broadcast("render"),(s||this._requiresFetchingData())&&(n.running=!1,this._configureTrend(n).running=!0))},_onUpdateHandleTime:function(e){var t,s=this.getDC(),n=this.renderer.getCanvasSize(),a=s.time2X(e,0),l=this,o=this.trendDisplay.items,r=this.trend.data,c=this.viewport,u=this.curves,m=[];if(!this.trendDisplay.handleDragging){var h=this.trendDisplay.controls[4];r=e>=r.startTime&&e<=r.endTime?r.values:null,c.isMultiLane&&Object.keys(u).forEach((function(e,s){t=l.curves[e].signal,void 0===m[t.laneIndex]&&(m[t.laneIndex]=[]),m[t.laneIndex].push(t)}));var d=this.trendDisplay.config.display,f=d.labelHeight,v=c.isDashboardView?m.length<d.lanesPerView?m.length:d.lanesPerView:1,g=n.height,p=(g-f*v)/v;if(Object.keys(u).forEach((function(t){var s=l.curves[t].signal,n=s.alias||s.name,a=s.valueIndex,u=s.laneIndex||0,h=o.getByName(n,"value"),v=shmi.getUiElement("handle-bar",this.element),b=!0,y=null,E=null,C=null;if(c.isMultiLane&&m[u].length>1){var x=shmi.ctrl(l.trendDisplay.getName()+".select-box-multi-lane-"+u);x&&a!==x.value&&(b=!1)}var T=v.parentNode.querySelector(".value.index-"+String(a)),w=v.parentNode.querySelector(".signal.index-"+String(a));if(b&&r&&h){if(r.some((function(t){return y=E,E={timestamp:t[0],value:t[1][a]},t[0]>e})),null!==E&&null!==E.value){if(E.value&&shmi.objectHasOwnProperty(E.value,"min")&&shmi.objectHasOwnProperty(E.value,"max"))C=(parseFloat(E.value.min)+parseFloat(E.value.max))/2;else if(y&&y.value){var k=E.timestamp-y.timestamp,I=parseFloat(y.value);C=I+(parseFloat(E.value)-I)/k*(e-y.timestamp)}else C=parseFloat(E.value);if(h.writeValue(C),v){var S,L=g-d.firstLabelHeight,D=Math.round(C),_=Math.abs(C-s.min)/(s.max-s.min)*100,O=10;if(c.isDashboardView?O=(L=f*u+p*(u+1)+d.labelHeight+d.handleBarOffset)-p:(L=g-d.handleBarOffset,O=d.labelHeight),S=L-p*_/100,T||w)w.style.top=S+"px",T.style.top=O+"px",T.innerHTML=String(D);else{var M=v.ownerDocument;(T=M.createElement("div")).className="value index-"+String(a),T.style.top=O+"px",T.innerHTML=String(D),(w=M.createElement("div")).className="signal index-"+String(a),w.style.top=S+"px",v.appendChild(T),v.appendChild(w)}}}}else T&&w&&(v.removeChild(T),v.removeChild(w))})),h){var b=h.program;b&&b.steps.then((function(t){var s=t.asArray[0],n=Math.abs(e-s.tStartReal);t.asArray.forEach((function(t,a){var l=Math.abs(e-t.tStartReal);l<n&&e>=t.tStartReal?(s=t,n=l):l===n&&e>s.tStartReal&&(s=t)})),console.debug("[TrendDisplay]","current step:",s),s.cvn.forEach((function(e,t){o.items.pgm["CV".concat(b.cvs[t].valueIndex)].writeValue(e)})),s.svn.forEach((function(e,t){o.items.pgm["SV".concat(b.svs[t].valueIndex)].writeValue(e)})),s.ndo.forEach((function(e,t){o.items.pgm["DO".concat(b.dos[t].valueIndex)].writeValue(e?1:0)}))}))}this.broadcast("move-handle",{time:e,refTime:this.viewport.minTime,left:a,canvas:n})}},_requiresFetchingData:function(){var e=this.viewport,t=this.trend;return!this._interactionMode.pinching&&(!!t&&(this._getBestTrendUnit()!==t.unit||(e.leftTime<t.startTime||!e.isLive&&e.rightTime>t.endTime)))},_getBestTrendUnit:function(){var e,t=this.viewport,s=this.trendDisplay.config||{},n=Math.ceil(t.visibleTimeSpan/this.renderer.getCanvasSize().width*s.display.pixelsPerValue);return(!(e=s.trend.aggregate.unit)||e<n)&&(e=n),e},_configureTrend:function(e){"use strict";var t=this.viewport,s=this.trendDisplay.config||{};if(e.startTime=t.leftRenderTime,e.endTime=t.isLive?-1:t.rightRenderTime,e.aggregate=s.trend.aggregate.method,e.unit=this._getBestTrendUnit(),s.trend.items.length){var n=s.trend.items.map((function(e){return e.alias}));e.items=n}return e},_onBroadcast:function(e){var t,s,n,a=this,l=this.viewport;switch(e.type){case"ui-show-curve":this.isPrepared.then((function(n){var a=e.detail.value,l=n.trendDisplay.config||{};(t=n.curves[a.curveIndex])&&(t.visible=a.isVisible&&l.trend.items[a.curveIndex].visible,n.renderer.update(),"item"!==e.detail.cause&&(s=n.trendDisplay.items.getByName(t.signal.alias||t.signal.name,"visible"))&&s.writeValue(a.isVisible?1:0))}));break;case"ui-live":l&&!this.trendDisplay.isPreparing&&this.isPrepared.then((function(t){l.isLive=!!e.detail.value,"item"!==e.detail.cause&&t._updateViewportRelatedItems(["isLive"])}));break;case"ui-zoomX":l&&this.isPrepared.then((function(t){n=e.detail.value/100,l.zoomX=n>=l.minZoomX?n:l.minZoomX,"item"!==e.detail.cause&&t._updateViewportRelatedItems(["zoomX"])}));break;case"ui-zoomY":l&&this.isPrepared.then((function(t){n=e.detail.value/100,l.transaction=!0,l.zoomY=n>=l.minZoomY?n:l.minZoomY,l.zoomFocusY=t.getDC().deriveFocusY(l.zoomY,0),l.transaction=!1,"item"!==e.detail.cause&&t._updateViewportRelatedItems(["zoomY"])}));break;case"ui-handleTime":l&&this.isPrepared.then((function(t){n=e.detail.value,l.handleTime=n>=l.minLeftTime?n:l.minLeftTime,"item"!==e.detail.cause&&t._updateViewportRelatedItems(["handleTime"])}));break;case"ui-leftTime":l&&this.isPrepared.then((function(t){n=e.detail.value,l.leftTime=n>=l.minLeftTime?n:l.minLeftTime,"item"!==e.detail.cause&&t._updateViewportRelatedItems(["leftTime"])}));break;case"resize":this.onResize();break;case"preparation-finished":this.trend.gotData.then((function(){var e;l.transaction=!0,l.isLive&&a._setLeftTimeInLiveMode(l),a._setInitialHandleTime(l),a._updateViewportRelatedItems([]),e=!l.transactionQueue.length,l.transaction=!1,e&&a.renderer.update()}));break;case"render":e.detail.suppress||this.renderer.update();break;case"configuration-changed":this.trendDisplay.isPreparing="reconfigure-continuous",this.onDisable(),this._configure(e.detail.configuration),this.onEnable(),this.trendDisplay.isPreparing=!1,this._updateViewportRelatedItems([])}}},shmi.visuals.controls.TrendDisplay.derive(shmi.visuals.controls.TrendDisplay.Continuous,shmi.visuals.controls.TrendDisplay.Component,"TrendDisplayContinuous"),shmi.visuals.controls.TrendDisplay.onConfiguration.push((function _onConfigureContinuous(e,t){"use strict";e.display||(e.display={});var s=parseInt(e.display.pixelsPerValue);isNaN(s)&&(s=1),e.display.pixelsPerValue=s})),shmi.c("TREND_DISPLAY_ZOOM_SCALE_X",1.2),shmi.c("TREND_DISPLAY_ZOOM_SCALE_Y",1.2),shmi.c("TREND_DISPLAY_ZOOM_SCALE_X_MIN",1e-5),shmi.c("TREND_DISPLAY_ZOOM_SCALE_X_MAX",Number.MAX_SAFE_INTEGER),shmi.c("TREND_DISPLAY_ZOOM_SCALE_Y_MIN",1),shmi.c("TREND_DISPLAY_ZOOM_SCALE_Y_MAX",20),shmi.c("TREND_DISPLAY_TRENDINFO_TIMEOUT",1e4),shmi.visuals.controls.TrendDisplay.Handle=function TrendDisplayHandle(e,t){"use strict";shmi.visuals.controls.TrendDisplay.Handle._super.call(this,e,t);var s=this._initUiControl(e),n=null,a=null;Object.defineProperty(this,"mouseInput",{value:s.mouse}),Object.defineProperty(this,"touchInput",{value:s.touch}),Object.defineProperty(this,"leftTabbed",{get:function(){return n},set:function(t){(t=!!t)!==n&&((n=t)?shmi.addClass(e,"left-tabbed"):shmi.removeClass(e,"left-tabbed"))}}),Object.defineProperty(this,"isSet",{get:function(){return a},set:function(t){(null===a||t)&&(t=!!t)!==a&&((a=t)?(shmi.removeClass(e,"unset"),shmi.addClass(e,"set")):(shmi.removeClass(e,"set"),shmi.addClass(e,"unset")))}})},shmi.visuals.controls.TrendDisplay.Handle.prototype={uiType:"trend-display-handle",isContainer:!1,getClassName:function(){"use strict";return"TrendDisplayHandle"},_initializeConfiguration:function(e){"use strict";return shmi.def(e,"class-name","trend-display-handle"),shmi.def(e,"template","default/trend-display/component/handle"),e},onDiscover:function(e){"use strict";this.isSet=!1,Object.defineProperties(this,{handleBar:{value:shmi.getUiElement("handle-bar",this.element)},handleTab:{value:shmi.getUiElement("handle-tab",this.element)},handleDate:{value:shmi.getUiElement("handle-date",this.element)}}),this.onBroadcast.push([this._onBroadcast,this]),this._super(this.TrendDisplayHandle,"onDiscover",e);var t=this,s=e.detail.trendDisplay.getComponents("trend-display-continuous")[0];s&&(Object.defineProperty(this,"continuous",{value:s}),s.isPrepared.then((function(){t.isPrepared.resolve(t)})))},onEnable:function(){"use strict";this.isPrepared.then((function(e){e.mouseInput.enable(),e.touchInput.enable()}))},onDisable:function(){"use strict";this.mouseInput.disable(),this.touchInput.disable()},_onBroadcast:function(e){var t,s,n,a,l,o=e.detail,r=this.handleBar,c=this.handleTab,u=this.handleDate,m=this.trendDisplay.config;if("move-handle"===e.type)this.isSet=!0,l=o.left-o.canvas.x,r.style.left=String(l)+"px",o.keepTabbing||(this.leftTabbed=l>.8*o.canvas.width),u&&(n=m["date-format"]||"$DD.$MM.$YYYY",a=!!m["utc-time"]&&m["utc-time"],s=!0!==this.trendDisplay.config["rel-time"]?Math.round(o.time):Math.round(o.time-o.refTime),u.textContent=shmi.requires("visuals.tools.date").formatDateTime(s,{datestring:n,utc:a})),c&&(t=!0!==this.trendDisplay.config["rel-time"]?this._formatRelativeTime(Math.round(o.time)):this._formatRelativeTime(Math.round(o.time-o.refTime)),c.textContent=t)},_formatRelativeTime:function(e){if(!0!==this.trendDisplay.config["rel-time"]){var t=this.trendDisplay.config["time-format"]||"$HH:$mm:$ss";return shmi.requires("visuals.tools.date").formatDateTime(e,{datestring:t,utc:this.trendDisplay.config["utc-time"]})}for(var s,n,a=[60,60,24,30],l=["",":",":","d ","m "],o="";a.length>2&&e>0;)s=e%(n=a.shift()),e=Math.floor(e/n),o=(s=60===n&&(a.length>2||e>0)?String("00"+s).substr(-2):String(s))+l.shift()+o;return o},_initUiControl:function(e){"use strict";var t,s,n,a,l=shmi.visuals.controls.TrendDisplay,o=this,r=null;function _onDragHandleBar(){n||(n=setTimeout(_onThrottledShowTime,100))}function _stopThrottledShowTime(){n&&(clearTimeout(n),n=null)}function _onThrottledShowTime(){n&&(s.vp.handleTime=s.dc.x2Time(s.canvas.x+s.bar+s.end-s.start),o.continuous._onUpdateHandleTime(s.vp.handleTime),_stopThrottledShowTime(),function _showTime(){var e=s.canvas.x+s.bar+s.end-s.start;o._onBroadcast({source:o,type:"move-handle",detail:{time:s.dc.x2Time(e),refTime:s.vp.minTime,left:e,canvas:s.canvas,keepTabbing:!0}})}())}return t={onPress:function(e,t,n){var l=o.continuous,r=l.element,c=parseInt(o.handleBar.style.left)||0;l.getDC()&&(s={box:r,dc:l.getDC(),canvas:l.renderer.getCanvasSize(),vp:l.viewport,bar:c,start:e,end:e,min:e-c,max:e+r.offsetWidth-c-1,current:e},a={bar:c,x:e},n.preventDefault(),n.stopPropagation())},onRelease:function(e,t,n){var a=o.trendDisplay;a.handleDragging=!1,s&&(s.end!==s.start&&(_stopThrottledShowTime(),s.vp.handleTime=s.dc.x2Time(s.canvas.x+s.bar+s.end-s.start)),r&&(s.vp.transaction=!1,r=null,shmi.removeClass(o.element,"dragging"),a.broadcast(o,"drag-handle-end")),s=null),n.preventDefault(),n.stopPropagation()},onDrag:function(e,t,n){if(s){s.current+=e;var c=l.limit(s.current,s.min,s.max),u=e<=0&&c<=s.min+200,m=e>=0&&c>=s.max-200,h=o.trendDisplay.config.display;if(o.trendDisplay.handleDragging=!0,c!==s.end)s.end=c,r||(s.vp.transaction=!0,r=!0,shmi.addClass(o.element,"dragging"),o.trendDisplay.broadcast(o,"drag-handle-start")),o.handleBar.style.left=String(s.bar+s.end-s.start)+"px",_onDragHandleBar();else if(null!==s){var d=!1;if(u||m){var f=parseInt(o.handleBar.style.left),v=f<2&&f===a.bar?10:-c+s.start;if(u)d=s.start>=s.current&&(v>a.x||f<2&&f===a.bar);else if(m){var g=-s.canvas.width/2;d=-o.continuous.element._offsetX+c>g&&v<a.x}d&&!h.demo&&(s.start+=e,s.end+=e,r||(s.vp.transaction=!0,r=!0,shmi.addClass(o.element,"dragging"),o.trendDisplay.broadcast(o,"drag-handle-start"),s.vp.handleTime=s.dc.x2Time(f+s.canvas.x+s.bar+Number(s.end)-s.start),o.continuous._onUpdateHandleTime(s.vp.handleTime),o.continuous.trend.running=!1,s.vp.isLive=!1),f<=20&&(v+=50,f=f<=1?1:f),o.continuous.onSlide.send("move",v),o.handleBar.style.left=String(f)+"px",_onDragHandleBar()),a={bar:f,x:v}}}n.preventDefault(),n.stopPropagation()}}},{mouse:new shmi.visuals.io.MouseListener(e,t),touch:new shmi.visuals.io.TouchListener(e,t)}}},shmi.visuals.controls.TrendDisplay.derive(shmi.visuals.controls.TrendDisplay.Handle,shmi.visuals.controls.TrendDisplay.Component,"TrendDisplayHandle"),shmi.visuals.controls.TrendDisplay.Scale=function TrendDisplayScale(e,t){"use strict";shmi.visuals.controls.TrendDisplay.Scale._super.call(this,e,t);var s=null,n=null,a=null,l=null,o=null,r=null,c=null;Object.defineProperty(this,"viewport",{get:function(){return s||(s=this.continuous?this.continuous.viewport:null),s},set:function(){s=null}}),Object.defineProperty(this,"renderer",{get:function(){return n||(n=this._generateRenderingManager()),n},set:function(){n&&n.onDelete(),n=null}}),Object.defineProperty(this,"curves",{get:function(){var e,t=0,s={};return a||(a=this.continuous?this.continuous.curves.filter((function(n,a){var l,o="_"+n.signal.unit+"_"+n.signal.max+"_"+n.signal.min;return n.signal.scaleVisible?(e=String.fromCharCode(65+t),++t,l=!0):s[o]?(e=s[o],l=!1):(e="",s[o]=e,l=!1),n.signal.labelLetter=e,l})):null),a||[]},set:function(){a=null}}),Object.defineProperty(this,"labels",{get:function(){return l||(l=this._generateLabels()),l},set:function(){l&&(l.forEach((function(e){e.parentNode.removeChild(e)})),l=null)}}),Object.defineProperty(this,"labelsReady",{get:function(){return null!==l}}),Object.defineProperty(this,"scales",{get:function(){return o||(o=this._generateScales()),o||[]},set:function(){o&&(o.forEach((function(e){e.onDelete()})),o=null)}}),Object.defineProperty(this,"ruler",{get:function(){return r||(r=this._generateRuler()),r},set:function(){r&&(r.onDelete(),r=null)}}),Object.defineProperty(this,"dimensions",{get:function(){return c||(c=this._getDimensions()),c},set:function(){c=null}})},shmi.visuals.controls.TrendDisplay.Scale.prototype={uiType:"trend-display-scale",isContainer:!1,getClassName:function(){"use strict";return"TrendDisplayScale"},_initializeConfiguration:function(e){"use strict";return shmi.def(e,"class-name","trend-display-scale"),shmi.def(e,"template","default/trend-display/component/scale"),e},onDiscover:function(e){"use strict";this._super(this.TrendDisplayScale,"onDiscover",e);var t=this,s=e.detail.trendDisplay,n=s.getComponents("trend-display-continuous")[0];n&&(s.isPreparing="discover-scale",Object.defineProperty(this,"continuous",{value:n}),n.isPrepared.then((function(e){Object.defineProperty(t,"labelsContainer",{value:shmi.getUiElement("labels-container",t.element)}),Object.defineProperty(t,"container",{value:shmi.getUiElement("scales-canvas-container",t.element)}),Object.defineProperty(t,"canvas",{value:shmi.getUiElement("scales-canvas",t.container||t.element)}),Object.defineProperty(t,"rulerLabel",{value:t._generateRulerLabel()}),e.onShift.push([t._onShift,t]),t.onBroadcast.push([50,t._onBroadcast,t]),t._configure().then((function(){t.isPrepared.resolve(t),s.isPreparing=!1}))})))},_configure:function(){var e=this,t=e._countCurveLabels();return this.viewport=null,this.renderer=null,this.curves=null,this.labels=null,this.scales=null,this.ruler=null,this.dimensions=null,this.scales,this.ruler,this.broadcast("scale-size",{before:t||0,now:this.curves.filter((function(e){return e&&e.signal&&e.signal.scaleVisible})).length||0}).then((function(){e.broadcast("resize")}))},_countCurveLabels:function(){return this.trendDisplay.config.trend.signals.filter((function(e){return e.scaleVisible})).length},onEnable:function(){this.isPrepared.then((function(e){e.onResize()}))},onDelete:function(){this.scales.forEach((function(e){e.onDelete()})),this.labels.forEach((function(e){e.parentNode.removeChild(e)})),this.ruler=null,this.rulerLabel&&this.rulerLabel.parentNode&&this.rulerLabel.parentNode.removeChild(this.rulerLabel),this.renderer=null},_generateRenderingManager:function(){var e;return"canvas"!==((this.canvas||{}).nodeName||"").toLowerCase()?(shmi.log("TrendDisplay: missing canvas element for rendering scales",2),null):((e=new shmi.visuals.controls.TrendDisplay.CanvasRenderingManager(this.container,this.canvas,this.viewport,shmi.visuals.controls.TrendDisplay.CanvasScale,this.trendDisplay.config,this.trendDisplay)).onRender.synchronous=!0,e)},_generateLabels:function(){if(!this.labelsContainer)return[];var e=this.labelsContainer,t=this.rulerLabel,s=e.ownerDocument,n=this.curves.filter((function(e){return e&&e.signal&&e.signal.scaleVisible})).map((function(n,a){var l,o,r,c=n.signal,u=c.labelLetter,m=s.createElement("div"),h=String(c.unit)?"["+String(c.unit)+"]":"";return(l=s.createElement("div")).className="label",m.className="inner-text",m.textContent=u,l.appendChild(m),(o=s.createElement("div")).className="unit",o.appendChild(s.createTextNode(shmi.localize(h))),(r=s.createElement("div")).className="curve index-"+String(a+1),r.appendChild(l),r.appendChild(o),e.insertBefore(r,t)}));return shmi.fire("labels-ready",{name:this.trendDisplay.getName()},this.trendDisplay),n},_generateRulerLabel:function(){var e,t=this.labelsContainer,s=t.ownerDocument;return(e=s.createElement("div")).className="ruler",e.appendChild(s.createTextNode(" ")),t.appendChild(e)},_generateRuler:function(){if(!this.curves.length)return null;var e=this.renderer,t=this.viewport,s=e.elementClass,n=shmi.visuals.controls.TrendDisplay,a=this.curves,l=a[0].signal,o=null;if(s===n.CanvasScale)t.isSingleLane&&(o=new n.CanvasRuler(e,a,l));return o&&e.onRender.push([o.render,o]),o},_generateScales:function(){var e=this.renderer,t=e?e.elementClass:null;return t?this.curves.map((function(s,n){var a=new t(e,s.signal);return a.index=n,e.onRender.push([a.render,a]),a})):[]},_getDimensions:function(){var e=this.labels,t={width:0},s=this.rulerLabel;return t.signals=this.curves.filter((function(e){return e&&e.signal&&e.signal.scaleVisible})).map((function(s,n){var a=e[n],l=a.offsetWidth;return t.width+=l,{x:a.offsetLeft,width:l}})),t.ruler={x:s.offsetLeft,width:s.offsetWidth},t.width+=t.ruler.width,t},onResize:function(){var e,t,s=this.container||this.canvas,n=this.renderer,a=this.viewport;n&&a&&(this.dimensions=!0,e=this.dimensions.width,t=s.offsetParent.offsetHeight,n.resize(e,t,0,a.prefetch),n.update(this))},_onShift:function(e,t){this.container.style.top=String(-this.renderer.getCanvasSize().y+t)+"px"},_onBroadcast:function(e){var t,s,n=this;switch(e.type){case"preparation-finished":case"render":e.detail.suppress||this.isPrepared.then((function(e){e.renderer.update(e)}));break;case"resize":this.onResize();break;case"configuration-changed":(s=(t=this.trendDisplay).getComponents("trend-display-continuous")[0])&&s.isPrepared.isResolved()&&(t.isPreparing="reconfigure-scale",this._configure().then((function(){return n.broadcast("resize")})).then((function(){t.isPreparing=!1})))}}},shmi.visuals.controls.TrendDisplay.derive(shmi.visuals.controls.TrendDisplay.Scale,shmi.visuals.controls.TrendDisplay.Component,"TrendDisplayScale"),shmi.visuals.controls.TrendDisplay.Scale.forEachStep=function(e,t,s,n,a){var l,o,r=e.y2Relative(t.y),c=e.y2Relative(t.y+t.height),u=s.scale.availableSteps,m=s.scale.availableMajorSteps,h=null,d=-1;if(u.forEach((function(e,t){(r-c)/e<=n+1&&(h=e,d=t)})),h)for(c=_accuracy(Math.floor(e.y2Relative(t.totalHeight)/h)*h),r=e.y2Relative(0),c<0&&(c=0),r>1&&(r=1),l=c;l<=r;l+=h){for(l=_accuracy(l),o=0;m[o]>u[d]&&_accuracy(Math.floor(l/m[o])*m[o])!==l;o++);if(!1===a(e.relative2Value(l),l,d,o))break}function _accuracy(e){return Math.round(1e4*e)/1e4}},shmi.visuals.controls.TrendDisplay.onConfiguration.push((function _onConfigureScale(e,t,s){"use strict";var n,a,l,o,r;e&&(l=(a=(n=e.display=s.isObject(e.display)).units=s.isObject(n.units)).scale=s.isObject(a.scale),Array.isArray(l.availableSteps)||(l.availableSteps=[1,.5,.2,.1,.05,.02,.01,.005,.002,.001]),l.availableSteps=s.parseFilterAndSort(l.availableSteps,s.relative,!0),Array.isArray(l.availableMajorSteps)||(l.availableMajorSteps=[1,.5,.1,.05,.01,.005,.001]),l.availableMajorSteps=s.parseFilterAndSort(l.availableMajorSteps,s.relative,!0),o=parseInt(l.min),(isNaN(o)||o<1)&&(o=1),r=parseInt(l.max),(isNaN(r)||r<1)&&(r=10),l.min=Math.min(o,r),l.max=Math.max(o,r))})),shmi.visuals.controls.TrendDisplay.Timeline=function TrendDisplayTimeline(e,t){"use strict";shmi.visuals.controls.TrendDisplay.Timeline._super.call(this,e,t)},shmi.visuals.controls.TrendDisplay.Timeline.prototype={uiType:"trend-display-timeline",isContainer:!1,getClassName:function(){"use strict";return"TrendDisplayTimeline"},_initializeConfiguration:function(e){"use strict";return shmi.def(e,"class-name","trend-display-timeline"),shmi.def(e,"template","default/trend-display/component/timeline"),this._labels={},e},onDiscover:function(e){"use strict";this._super(this.TrendDisplayTimeline,"onDiscover",e),Object.defineProperty(this,"container",{value:shmi.getUiElement("timestamps-container",this.element)});var t=this,s=e.detail.trendDisplay,n=s.config,a=s.getComponents("trend-display-continuous")[0];a&&(Object.defineProperty(this,"continuous",{value:a}),a.isPrepared.then((function(e){e.onSlide.push([t._onSlide,t]),t.onBroadcast.push([50,t._onBroadcast,t]),t.isPrepared.resolve(t),n.invalid||t._updateElements(e)})))},onDelete:function(){this.onDeleteLabels(),this._super(this.TrendDisplayTimeline,"onDelete")},onDeleteLabels:function(){var e=this._labels;Object.keys(e).forEach((function(t){var s=e[t];s.parentNode.removeChild(s)})),this._labels={}},_onSlide:function(e,t){isNaN(this._offsetX)||(this.container.style.left=String(-this._offsetX+t)+"px")},_reconfigure:function(e){var t=this.trendDisplay.getComponents("trend-display-continuous")[0];t&&t.isPrepared.isResolved()&&(this.onDeleteLabels(),this._updateElements(t))},_onBroadcast:function(e){"use strict";switch(e.type){case"preparation-finished":case"render":e.detail.suppress||this._updateElements(this.continuous);break;case"configuration-changed":var t=e.detail.configuration;t.invalid||this._reconfigure(t)}},_updateElements:function(e){var t,s,n=this.trendDisplay.config,a=e.viewport,l=e.getDC(),o=e.renderer,r=o.controls,c=o.getCanvasSize(),u=this.container,m=u.ownerDocument,h=shmi.visuals.controls.TrendDisplay,d=shmi.getUiElement("trend-display-timeline"),f=c.totalWidth,v=a.minTime,g=a.rightRenderTime-v,p=n.display.units.timeLine,b=h.Timeline.detectVisibleUnit(p.available,a.visibleTimeSpan,p.min,p.max),y=this._labels;if(this._offsetX=c.x,b>0){u.style.left=String(-c.x)+"px",u.style.width=String(f)+"px";var E=d===u.parentNode.parentNode&&shmi.hasClass(d,"top-timeline")?"top":"bottom";r.applyButtonNavigateTimeline("left",u.parentNode,E,"after"),r.applyButtonNavigateTimeline("right",u.parentNode,E,"after"),this._generateTimelineScaling(e,u.parentNode,E);var C,x,T,w=0,k={},I=null;for(t=Math.floor((a.leftRenderTime-v)/b)*b;t<g;t+=b){T=y[t];var S=!0===n["rel-time"]?t:v+t,L=new Date(1e3*S),D=!!n["utc-time"]&&n["utc-time"],_=new Date(D?L.valueOf()+6e4*L.getTimezoneOffset():L);T?((s=l.time2X(v+t,0))!==parseFloat(T.style.left)&&(T.style.left=String(s)+"px"),y[t]=null):((T=m.createElement("label")).style.left=String(l.time2X(v+t,0))+"px",T.appendChild(m.createTextNode(shmi.requires("visuals.tools.date").formatDateTime(S,{datestring:n["time-format"]||"$HH:$mm:$ss",utc:D}))),u.appendChild(T)),d===u.parentNode.parentNode&&shmi.hasClass(d,"top-timeline")&&(0===_.getHours()&&0===_.getMinutes()&&0===_.getSeconds()?((I=m.createElement("span")).className="date",I.appendChild(m.createTextNode(shmi.requires("visuals.tools.date").formatDateTime(S,{datestring:n["date-format"],utc:D}))),T.appendChild(I)):0!==t&&0!==w&&w<Math.floor(t/86400)&&(_.setHours(0,0,0,0),k[C=parseInt(_.getTime()/1e3)+86400]||((x=m.createElement("label")).style.left=String(l.time2X(C,0))+"px",u.appendChild(x),(I=m.createElement("span")).className="date",I.appendChild(m.createTextNode(shmi.requires("visuals.tools.date").formatDateTime(C,{datestring:n["date-format"],utc:D}))),x.appendChild(I),k[C]=x))),k[t]=T,w=Math.floor(t/86400),this._labels=k}}else this._labels=[];Object.keys(y).forEach((function(e){var t=y[e];t&&u.removeChild(t)}))},_generateTimelineScaling:function(e,t,s){var n=e.viewport,a=e.renderer,l=e.getDC(),o=shmi.getUiElement("continuous-canvas",t.parentNode.parentNode),r="vertical-raster-"+s+"-canvas",c=t.querySelector("."+r),u="top"===s?t.parentNode.scrollHeight-1:0,m="top"===s?u-7:u+7;if(c){c.width=o.width;var h=c.getContext("2d");h.lineWidth=1,h.strokeStyle="rgba(255,255,255,1)",h.beginPath(),shmi.visuals.controls.TrendDisplay.CanvasBackground.getVerticalRasterTimestamps(a.config.display.units,n).forEach((function(e){var t=l.time2X(e,0);h.moveTo(t,u),h.lineTo(t,m)})),h.stroke()}else(c=document.createElement("canvas")).className="canvas "+r,c.height=t.parentNode.scrollHeight,t.appendChild(c)}},shmi.visuals.controls.TrendDisplay.derive(shmi.visuals.controls.TrendDisplay.Timeline,shmi.visuals.controls.TrendDisplay.Component,"TrendDisplayTimeline"),shmi.visuals.controls.TrendDisplay.Timeline.detectVisibleUnit=function(e,t,s,n){var a=e.map((function(e){var a=t/e;return a>=s&&a<=n?e:0})).filter((function(e){return e})).sort((function(e,t){return t-e}));if(0===a.length){var l=null;return e.forEach((function(e){if(null===l){var s=t/e;s<1&&(l=e),s>=1&&s<=n&&(l=e)}})),l}return a.length?a[Math.floor(a.length/2)]:e[0]},shmi.visuals.controls.TrendDisplay.Timeline.renderTime=function(e,t){if(!0!==t["rel-time"]){var s=t["time-format"]||"$YYYY-$MM-$DD $HH:$mm";return shmi.requires("visuals.tools.date").formatDateTime(e,{datestring:s,utc:t["utc-time"]})}var n=e,a={year:31536e3,month:2592e3,week:604800,day:86400,hour:3600,minute:60,second:1};Object.keys(a).forEach((function(e){var t=a[e];n>=t?(a[e]=Math.floor(n/t),n-=t*a[e]):a[e]=""}));var l=!0;return t["rel-time-format"]||"$Dd $HH:$MM:$SS".replace(/\$([YNWDHMS]{1,3})([^\s$]*)/g,(function(e,t,s){var n;switch(t[0]){case"Y":n=a.year;break;case"N":n=a.month;break;case"W":n=a.week;break;case"D":n=a.day;break;case"H":n=a.hour;break;case"M":n=a.minute;break;case"S":n=a.second;break;default:return t+s}if(l&&!n)return"";for(l=!1,n=String(n);n.length<t.length;)n="0"+n;return n+s})).trim()},shmi.visuals.controls.TrendDisplay.onConfiguration.push((function _onConfigureTimeLine(e,t,s){"use strict";var n,a,l,o,r;e&&(l=(a=(n=e.display=s.isObject(e.display)).units=s.isObject(n.units)).timeLine=s.isObject(a.timeLine),Array.isArray(l.available)||(l.available=[5,10,30,60,120,300,600,900,1800,3600,14400,21600,43200,86400,604800,2678400,31536e3]),l.available=s.parseFilterAndSort(l.available,s.timeSpanUnit),o=parseInt(l.min),(isNaN(o)||o<1)&&(o=1),r=parseInt(l.max),(isNaN(r)||r<1)&&(r=6),l.min=Math.min(o,r),l.max=Math.max(o,r))})),shmi.visuals.controls.TrendDisplay.CanvasProgramCurve=function CanvasProgramCurve(e,t,s,n){"use strict";shmi.visuals.controls.TrendDisplay.CanvasProgramCurve._super.call(this,e,s.getTrend().signal),Object.defineProperty(this,"program",{value:t}),Object.defineProperty(this,"programValue",{value:s}),Object.defineProperty(this,"waitStyle",{value:n})},shmi.visuals.controls.TrendDisplay.CanvasProgramCurve.prototype={_createPathElement:function(e){var t="path program "+(this.programValue.isCValue?"cv-":this.programValue.isDoValue?"do-":"sv-")+(this.signal.alias||this.signal.name),s=e.getElementsByClassName(t)[0];return s||((s=e.ownerDocument.createElement("path")).setAttribute("class",t),s=e.appendChild(s)),s},render:function(e,t,s){"use strict";var n,a=this.program,l=this,o=this.waitStyle.symbol;return a.steps.isResolved()?(n=[a.steps],o&&o.isResolved()&&n.push(o),shmi.visuals.controls.TrendDisplay.Promise.all(n).spread((function(t,n){var o=l.drawingContext,r=e.viewport,c=s.getContext("2d"),u=r.leftRenderTime,m=r.rightRenderTime,h=l.programValue,d=h.isCValue,f=h.isDoValue,v=d?"cvn":f?"ndo":"svn",g=h.index,p=h.style.symbol,b=[],y=NaN,E=NaN,C=shmi.requires("visuals.tools.item-adapter").getActiveAdapter(l.signal.alias||l.signal.name);!a.preview&&u<a.tStartReal&&(u=a.tStartReal);var x=t.asArray;!function calcLoops(){var e=[];x[0].loop&&(x.forEach((function(t,s){t.loop.count>0&&e.push({start:t.loop.t,end:s-1,loops:t.loop.count})})),x.forEach((function(t,s){t.loopInfo={loops:0,isEnd:!1,reps:0},e.forEach((function(e,n){s>=e.start&&s<=e.end&&(t.loopInfo.loops+=1,s===e.end&&(t.loopInfo.isEnd=!0,t.loopInfo.reps=e.loops))}))})))}(),h.style.applyOnCanvas(c),c.beginPath(),t.asArray.some((function(e,t,s){if(t>=s.length-1)return!1;var l,r,h,x,T,w,k,I,S=e[v][g];if(C&&(S=C.outFunction(S)),r=e.tStartReal,(h=e.tEndReal)<(l=isNaN(E)?r:E)&&(h=l),(h<m?h:m)>=(l>u?l:u)){x=o.time2X(r,0),w=o.value2Y(S,0),isNaN(E)?x:o.time2X(E,0),(I=0!==e.waitForCVIndex.icv&&e.waitForCVIndex.icv===g+1&&d)&&e.tStart>=a.time&&n&&c.drawImage(n,x-30,w-shmi.visuals.controls.TrendDisplay.iconDimensions.height/2);var L=s[t+1][v][g];if(C&&(L=C.outFunction(L)),f&&e.tStart>=a.time&&y!==S){var D=o.time2X(E,0),_=o.value2Y(y,0);c.moveTo(D,_),c.lineTo(x,w),p&&b.push({x:x,y:w})}T=o.time2X(h,0),k=f?o.value2Y(S,0):o.value2Y(L,0),e.tStart>=a.time&&(c.moveTo(x,w),c.lineTo(T,k),p&&(b.length&&!I||b.push({x:x,y:w}),b.push({x:T,y:k})))}return y=S,E=h,r>=m})),c.stroke(),x[0].loop&&(c.save(),c.strokeStyle="#9ba302",c.fillStyle="#9ba302",c.lineWidth=3,y=NaN,E=NaN,t.asArray.some((function(e,t){if(t>=x.length-1)return!1;var s,n,l,r,h,d=e[v][g];if(C&&(d=C.outFunction(d)),n=e.tStartReal,(l=e.tEndReal)<(s=isNaN(E)?n:E)&&(l=s),(l<m?l:m)>=(s>u?s:u)&&(r=o.time2X(n,0),isNaN(E)?r:o.time2X(E,0),h=o.time2X(l,0),e.tStart>=a.time&&e.loopInfo)){for(var f=0,p=0;f<e.loopInfo.loops;)c.beginPath(),c.moveTo(r,o.manager._offsetY+6+30*f),c.lineTo(h,o.manager._offsetY+6+30*f),c.stroke(),f+=1;e.loopInfo.isEnd&&(e.loopInfo.reps>=10&&(p+=8),e.loopInfo.reps>=100&&(p+=8),f-=1,c.fillRect(h-(25+p),o.manager._offsetY+30*f+7,25+p,25),c.font="14px sans-serif",c.save(),c.fillStyle="#FFFFFF",c.fillText(e.loopInfo.reps,h-(17+p),o.manager._offsetY+30*f+23),c.restore())}return y=d,E=l,n>=m})),c.restore()),p&&p.then((function(e){b.forEach((function(t){isFinite(t.y)&&c.drawImage(e,t.x-shmi.visuals.controls.TrendDisplay.iconDimensions.width/2,t.y-shmi.visuals.controls.TrendDisplay.iconDimensions.height/2)}))}))}))):null}},shmi.visuals.controls.TrendDisplay.derive(shmi.visuals.controls.TrendDisplay.CanvasProgramCurve,shmi.visuals.controls.TrendDisplay.CanvasCurve,"CanvasProgramCurve"),shmi.visuals.controls.TrendDisplay.ProgramManager=function TrendDisplayProgramManager(e,t){"use strict";shmi.visuals.controls.TrendDisplay.ProgramManager._super.call(this,e,t);var s=null,n=null,a=null,l=null,o=null,r=null;Object.defineProperty(this,"disabled",{get:function(){return!!r},set:function(t){(t=!!t)!==r&&(t?shmi.addClass(e,"disabled"):shmi.removeClass(e,"disabled"),r=t)}}),Object.defineProperty(this,"viewport",{get:function(){return!s&&this.continuous&&(s=this.continuous.viewport),s},set:function(){s=null}}),Object.defineProperty(this,"trends",{get:function(){return!n&&this.continuous&&(n=this.continuous.curves),n},set:function(){n=null}}),Object.defineProperty(this,"timeline",{get:function(){return a&&a.onDelete(),a=null,a=this._generateTimeLine()},set:function(){a&&a.onDelete(),a=null}}),Object.defineProperty(this,"program",{get:function(){return l||r||(l=this._generateProgram()),l},set:function(){l&&l.onDelete(),l=null}}),Object.defineProperty(this,"curves",{get:function(){return o||(o=this._generateProgramValues()),o},set:function(){if(o){var e=(this.continuous||{}).renderer;o.forEach((function(t){e&&e.onRender.removeListener([t.render,t]),t.onDelete()}))}o=null}})},shmi.visuals.controls.TrendDisplay.ProgramManager.prototype={uiType:"trend-display-program",isContainer:!1,getClassName:function(){"use strict";return"TrendDisplayProgramManager"},_initializeConfiguration:function(e){"use strict";return shmi.def(e,"class-name","trend-display-program"),shmi.def(e,"template","default/trend-display/component/program"),e},onDiscover:function(e){"use strict";this._super(this.TrendDisplayProgramManager,"onDiscover",e);var t=this,s=e.detail.trendDisplay,n=s.getComponents("trend-display-continuous")[0],a=null,l={color:"#C8C8C8",width:1,label:"label"};n&&(Object.defineProperty(t,"continuous",{value:n}),Object.defineProperty(t,"container",{value:shmi.getUiElement("program-timeline-container",t.element)}),Object.defineProperty(t,"canvas",{value:shmi.getUiElement("program-timeline",t.container||t.element)}),Object.defineProperty(t,"waitStub",{value:shmi.getUiElement("program-wait",t.element)}),Object.defineProperty(t,"waitStyle",{get:function(){return a},set:function(e){e&&(a=e.styleManagers.waitStyle)&&(a.symbol="pics/system/icon_196.png")}}),Object.defineProperty(t,"inactiveStyle",{get:function(){return l},set:function(e){e&&(l=e.styleManagers.inactiveStyle)}}),n.isPrepared.then((function(e){return e.onSlide.push([t._onSlide,t]),e.onState.push([t._onContinuousState,t]),t.onBroadcast.push([t._onBroadcast,t]),t._configure(s.config).then((function(){t.isPrepared.resolve(t),t.trendDisplay.isPreparing=!1}))})))},onDelete:function(){var e=this.continuous;e&&e.onSlide&&e.onSlide.removeListener([this._onSlide,this]),e&&e.onState&&e.onState.removeListener([this._onContinuousState,this]),this.onBroadcast&&"function"==typeof this.onBroadcast.removeListener&&this.onBroadcast.removeListener([this._onBroadcast,this])},_configure:function(e){var t=this;return this.isPrepared.isResolved()&&e.invalid?shmi.visuals.controls.TrendDisplay.Promise.resolve():(this.disabled=e.invalid||!e.program,this.viewport=null,this.trends=null,this.timeline=null,this.program=null,this.curves=null,this.waitStyle=null,this.controls=null,this.disabled?shmi.visuals.controls.TrendDisplay.Promise.resolve():(this.waitStyle=e,this.timeline,this.curves,this.controls,this.program.steps.then((function(){return t.onResize()}))))},_generateTimeLine:function(){return new shmi.visuals.controls.TrendDisplay.ProgramTimeLine(this.container,this.continuous,this.program)},_generateProgram:function(){var e=new shmi.visuals.controls.TrendDisplay.Program(this,this.trendDisplay.config,this.continuous);return e.updateMaxTime(this.continuous.viewport),e},_generateProgramValues:function(){var e=this,t=(this.continuous||{}).renderer,s=t.elementClass,n=shmi.visuals.controls.TrendDisplay.CanvasProgramCurve;if(t){if(Object.create(n.prototype)instanceof s){var a=this.program;return[].concat(a.cvs.map(_create),a.svs.map(_create),a.dos.map(_create)).map((function(e){return t.onRender.push([e.render,e]),e}))}shmi.log("[ProgramManager]: curve renderers not suitable for selected canvas of Continuous")}return null;function _create(s){return new n(t,a,s,e.waitStyle)}},onResize:function(){var e=this.timeline;e&&e.onResize()},_onSlide:function(){if(!this.disabled){var e=this.timeline;if(e)return e.onSlide.apply(e,arguments)}return null},_onContinuousState:function(e,t){var s=t.viewport;switch(t.mode){case"live":return!!this.disabled||(s.leftTime=s.maxSampleTime-s.visibleTimeSpan/2,!1);case"handleTime":return!!this.disabled||(s.handleTime=s.maxSampleTime,!1);default:return!0}},_onBroadcast:function(e){var t,s;switch(e.type){case"preparation-finished":case"render":e.detail.suppress||this.disabled||this.timeline.render();break;case"resize":this.disabled||this.onResize();break;case"configuration-changed":t=this.trendDisplay,s=e.detail.configuration,t.isPreparing="reconfigure-program-manager",this._configure(s).then((function(){t.isPreparing=!1,s.program&&(t.isPreparing=!1)}))}}},shmi.visuals.controls.TrendDisplay.derive(shmi.visuals.controls.TrendDisplay.ProgramManager,shmi.visuals.controls.TrendDisplay.Component,"TrendDisplayProgramManager"),shmi.visuals.controls.TrendDisplay.onConfiguration.push((function _onConfigureProgramManager(e,t){})),shmi.visuals.controls.TrendDisplay.Program=function Program(e,t,s){"use strict";var n=null,a=null,l=null,o=null,r=[],c=[],u=[];this._compileItems(t,s,r,c,u),Object.defineProperty(this,"manager",{value:e}),Object.defineProperty(this,"continuous",{value:s}),Object.defineProperty(this,"code",{get:function(){return n||(n=this._getOnConfiguration(t)),n},set:function(){n=null}}),Object.defineProperty(this,"index",{value:t.program.index}),Object.defineProperty(this,"preview",{value:t.program.preview}),Object.defineProperty(this,"tStart",{value:t.program.tStart}),Object.defineProperty(this,"tStartProgram",{value:this.time}),Object.defineProperty(this,"tStartReal",{value:shmi.getServerTime()}),Object.defineProperty(this,"time",{get:function(){return this.preview?0:(l||(l=this._bindProgramTimer(t)),l.value)},set:function(){l&&(this._unbindProgramTimer(l),l=null)}}),Object.defineProperty(this,"cvs",{value:r}),Object.defineProperty(this,"svs",{value:c}),Object.defineProperty(this,"dos",{value:u}),Object.defineProperty(this,"waiting",{get:function(){return!!o},set:function(e){if(Boolean(e)!==Boolean(o))if(e){var t=this;o=!0===t.preview?0:window.setInterval((function(){t._whileWaiting()}),1100)}else window.clearInterval(o),o=null}}),Object.defineProperty(this,"steps",{get:function(){return a||(a=this.code.then((function(e){return e.step}))),a}})},shmi.visuals.controls.TrendDisplay.Program.prototype={_compileItems:function(e,t,s,n,a){e.program.items.forEach((function(l){var o,r="CV"===l.valueType,c="DO"===l.valueType,u=r?s:c?a:n;u.push({alias:l.alias,name:l.name,index:u.length,trendIndex:l.trendIndex,valueIndex:l.valueIndex,styleIndex:l.styleIndex,style:e.styleManagers[l.styleIndex]||null,getTrend:(o=l.trendIndex,function(){return t.curves[o]}),isCValue:r,isDoValue:c})}))},_normalizeRealTime:function(e){var t=this.tStartReal;return isNaN(e)&&(e=shmi.getServerTime()),t+Math.round(e-t)},_getOnConfiguration:function(e){var t=this,s=this.cvs.map(_extractIndex),n=this.svs.map(_extractIndex),a=this.dos.map(_extractIndex);return new shmi.visuals.controls.TrendDisplay.Promise((function(l,o){shmi.visuals.controls.TrendDisplay.Program.api.getProgram(e.program.index,s,n,a,(function(s,n){if(s)o("error #"+s+" on fetching program #"+e.program.index);else{var a=n.len,r=null;n.step=new ProgramSteps(n.step.reverse().map((function(e){return e.length=a-e.t,a=e.t,e})).reverse().map((function(e){return r=new ProgramStep(e.cvn,e.svn,e.ndo,e["#"],e.t,e.length,e.w,r,e.loop)}))),t._updateMaxTime(t.continuous.viewport,n.step),t.preview&&(t.waiting=!0),l(n)}}))}));function _extractIndex(e){return e.valueIndex}function ProgramStep(e,s,n,a,l,o,r,c,u){var m=null;this.next=null,this.offsetTime=0,this.waitTime=0,c&&(c.next=this),Object.defineProperties(this,{cvn:{value:e},svn:{value:s},ndo:{value:n},label:{value:a},tStart:{value:l},tStartReal:{get:function(){var e,s,n,a,l;if(null!==m)return m;if(c)return c.hasTStartReal&&this.tStart>t.time&&t.waiting?(e=t.time-c.tStart,s=c.tStartReal+e,(n=shmi.getServerTime()-s)<0&&(n=0),a=c.length-e,l=shmi.getServerTime()+a,c.offsetTime=n,t._normalizeRealTime(l)):c.hasTStartReal&&this.tStart===t.time&&t.waiting?(e=t.time-c.tStart,s=c.tStartReal+e,(n=shmi.getServerTime()-s)<0&&(n=0),a=c.length-e,l=shmi.getServerTime()+a,this.waitTime=n,t._normalizeRealTime(l)):c.hasTStartReal&&this.tStart>=t.time?(e=t.time-c.tStart,s=c.tStartReal+e,(n=shmi.getServerTime()-s)<0&&(n=0),a=c.length-e,l=shmi.getServerTime()+a,c.offsetTime=n,t._normalizeRealTime(l)):c.tEndReal+this.waitTime;if(t.preview)return t.tStartReal;var o=t.tStartProgram;return void 0===o?shmi.getServerTime():t._normalizeRealTime(shmi.getServerTime()-(this.tStart-o))},set:function(e){null!==m&&null!==e||(m=e)}},tEndReal:{get:function(){return this.tStartReal+this.length+this.offsetTime}},hasTStartReal:{get:function(){return null!==m}},previous:{value:c||null},length:{value:o},waitForCVIndex:{value:r},waitingTime:{value:function(){if(!c)return 0;var e=this.tStartReal-c.tEndReal;return e<0?0:e}},loop:{value:u||null}})}function ProgramSteps(e){var s=this,n=-1,a=null;Object.defineProperties(this,{asArray:{value:e},current:{value:function(t){var n=s.currentIndex(t);return n>=0?e[n]:null}},currentIndex:{value:function(s){if(isNaN(s)&&(s=t.time),s!==a||n<0){var l,o,r;for(l=Math.max(0,n),o=e.length;l<o;l++){if((r=e[l]).tStart<s)if(r.hasTStartReal){if(a&&a>s){e.forEach((function(e,t){e.tStartReal=null,e.waitTime=0,e.offsetTime=0})),n=-1;break}}else r.tStartReal=t._normalizeRealTime()-(s-r.tStart),console.debug("fixing real start time of step #"+l+" at "+r.tStartReal);else if(a&&a>s){e.forEach((function(e,t){e.tStartReal=null,e.waitTime=0,e.offsetTime=0})),n=-1;break}if(r.tStart>s)break;n=l}a=s}return n}},first:{value:e[0]},last:{value:e[e.length-1]}})}},_bindProgramTimer:function(e){var t=this,s={name:e.program.time,id:0,value:-1,timer:0,setValue:function(e){var n=parseFloat(e)||0;n!==s.value&&(s.timer&&(clearTimeout(s.timer),s.timer=null),s.value=n,t.waiting=!1,t.steps.isSettled()&&t.steps.then((function(e){e.current(n)})),t.preview||(s.timer=setTimeout((function(){t.waiting=!0}),2e3)))},lock:shmi.visuals.controls.TrendDisplay.nop,unlock:shmi.visuals.controls.TrendDisplay.nop,setProperties:shmi.visuals.controls.TrendDisplay.nop};return s.id=shmi.visuals.session.ItemManager.subscribeItem(s.name,s),s},_unbindProgramTimer:function(e){e.timer&&(clearTimeout(e.timer),e.timer=null),shmi.visuals.session.ItemManager.unsubscribeItem(e.name,e.id)},_whileWaiting:function(){var e=this,t=this.continuous.viewport;this.updateMaxTime(t).then((function(s){!t.isLive&&!t.transaction&&s<t.rightRenderTime&&e.manager.broadcast("render")}))},_updateMaxTime:function(e,t){return e.programEndTime=t.last.tEndReal,null===t.current()?null:t.current().tStartReal},updateMaxTime:function(e){var t=this;return this.steps.then((function(s){return t._updateMaxTime(e,s)}))},onDelete:function(){this.code=null,this.time=null,this.waiting=!1}},shmi.visuals.controls.TrendDisplay.onConfiguration.push([-10,function _parseProgramConfiguration(e,t,s){"use strict";if(e&&"object"==typeof e&&e.program&&"object"==typeof e.program){t.isPreparing="processing-program-manager-configuration";var n=!!e.program.preview,a=parseInt(e.program.index);a<0&&shmi.log("TrendDisplay.onConfiguration() invalid program index",3);var l=s.timestamp(e.program.tStart);null===l&&shmi.log("TrendDisplay.onConfiguration() invalid tStart in configuration of program",3);var o=String(e.program.time||"").trim();o.length||shmi.log("TrendDisplay.onConfiguration() missing name of program timer item",3);var r,c=e.program.items;Array.isArray(c)&&c.length||shmi.log("TrendDisplay.onConfiguration() invalid/missing program items configuration",3),shmi.objectHasOwnProperty(e.program,"waitStyleIndex")?((r=parseInt(e.program.waitStyleIndex))<0||r>=e.styles.length)&&shmi.log("TrendDisplay.onConfiguration() invalid index of wait state indicator style",3):r=-1,e.program={index:a,preview:n,tStart:l,time:o,items:c.map((function(t,s){t&&"object"==typeof t||shmi.log("TrendDisplay.onConfiguration() invalid/missing program item configuration @"+s,3);var n={};switch(n.valueType=String(t.valueType||"").toUpperCase(),n.valueType){case"CV":case"SV":case"DO":break;default:shmi.log("TrendDisplay.onConfiguration() invalid valueType of program value on program item @"+s,3)}return n.valueIndex=parseInt(t.valueIndex),(isNaN(n.valueIndex)||n.valueIndex<0)&&shmi.log("TrendDisplay.onConfiguration() invalid valueIndex of program value on program item @"+s,3),n.trendIndex=parseInt(t.trendIndex),(isNaN(n.trendIndex)||n.trendIndex<0||n.trendIndex>=e.trend.items.length)&&shmi.log("TrendDisplay.onConfiguration() invalid trendIndex of trend item on program item @"+s,3),shmi.objectHasOwnProperty(t,"styleIndex")?(n.styleIndex=parseInt(t.styleIndex),(isNaN(n.styleIndex)||n.styleIndex<0||n.styleIndex>=e.styles.length)&&shmi.log("TrendDisplay.onConfiguration() invalid styleIndex on program item @"+s,3),n.style=e.styleManagers[n.styleIndex]):n.style=shmi.visuals.controls.TrendDisplay.Style.defaultStyle,n})),waitStyleIndex:r};var u=shmi.visuals.controls.TrendDisplay.Program;u.api||(u.api=shmi.requires("visuals.custom.wut.pgm"))}}]),shmi.visuals.controls.TrendDisplay.Program.api=null,shmi.visuals.controls.TrendDisplay.ProgramTimeLine=function(e,t,s){"use strict";e.innerHTML="",Object.defineProperty(this,"container",{value:e}),Object.defineProperty(this,"continuous",{value:t}),Object.defineProperty(this,"program",{value:s})},shmi.visuals.controls.TrendDisplay.ProgramTimeLine.prototype={_resetLocation:function(e){var t=this.container.style;this._offsetX=e.x,t.left=String(-e.x)+"px",t.width=String(e.totalWidth)+"px"},render:function(){"use strict";var e=this;return this.container?this.program.steps.then((function(t){var s=e.continuous,n=s.viewport,a=s.getDC(),l=s.renderer.getCanvasSize(),o=e.container,r=e.program,c=r.preview,u=o.ownerDocument,m=n.leftRenderTime,h=n.rightRenderTime,d=e._labels||{},f={};e._resetLocation(l),!c&&m<r.tStartReal&&(m=r.tStartReal),t.asArray.some((function(e,t){var s,n,l,m,d;return l=e.previous?e.previous.tEndReal:e.tStartReal,m=e.tEndReal,e.next,!(e.tStart<r.time)&&((c||m>r.tStartReal)&&m>l&&(s=a.time2X(l,0),n=a.time2X(m,0),(d=u.createElement("label")).appendChild(u.createTextNode(e.label)),(d=o.appendChild(d)).style.left=s+"px",d.style.width=Math.round(n-s)+"px",f[t]=d),l>h)})),Object.keys(d).forEach((function(e){var t=d[e];t&&t.parentNode.removeChild(t)})),e._labels=f})):null},onSlide:function(e,t){isNaN(this._offsetX)||(this.container.style.left=String(-this._offsetX+t)+"px")},onResize:function(){},onDelete:function(){"use strict";var e=this._labels;Object.keys(e||{}).forEach((function(t){var s=e[t];s.parentNode.removeChild(s)}))}},shmi.visuals.controls.TrendDisplay.derive(shmi.visuals.controls.TrendDisplay.ProgramTimeLine,shmi.visuals.controls.TrendDisplay.AbstractRenderer,"ProgramTimeLine"),shmi.visuals.controls.TrendDisplay.Configuration=function(e){"use strict";var t=!1;Object.defineProperties(this,{trendDisplay:{value:e},isConfigured:{get:function(){return t},set:function(){t=!0}}})},shmi.visuals.controls.TrendDisplay.Configuration.prototype={validate:function(e){"use strict";var t=e||{},s=this.trendDisplay,n=shmi.visuals.controls.TrendDisplay;return Array.isArray(n.onConfiguration)&&(n.onConfiguration=n.Messaging.wrap(n.onConfiguration)),n.onConfiguration.send(t,s,n.Parsers).return(t)},_notifyChange:function(e,t,s){this.trendDisplay.broadcast(this,"configuration-changed",{name:t,newValue:e,oldValue:s,configuration:this})},read:function(){return shmi.visuals.controls.TrendDisplay.Object.deepCopy(this)},update:function(e,t){"use strict";var s=this,n=this.trendDisplay,a=shmi.visuals.controls.TrendDisplay;return(e=shmi.visuals.controls.TrendDisplay.Object.deepCopy(e)).invalid=!1,e.noRecal=t||!1,this.validate(e).catch((function(t){if(e.invalid=!0,s.isConfigured){var n=String(t.message||t||"");shmi.log(n.trim(),3),shmi.log("TrendDisplay.Configuration.update() invalid configuration rejected",3)}return e})).then((function(e){var t=Object.isSealed(s);return t&&(s=new a.Configuration(n)),a.Object.injectObserved(s,e,a.fastBind(s._notifyChange,s),!0,["invalid"]),s.isConfigured=!0,t&&s._notifyChange(null,null,null),s}))}},shmi.visuals.controls.TrendDisplay.Data=function(e){"use strict";var t=shmi.visuals.session.TrendManager,s=null;Object.defineProperty(this,"manager",{value:t}),Object.defineProperty(this,"instance",{get:function(){return e}}),Object.defineProperty(this,"trends",{get:function(){return s||(s=new shmi.visuals.controls.TrendDisplay.Promise((function(e){t.getTrendList((function(t){e(t)}))}))),s}})},shmi.visuals.controls.TrendDisplay.Data.prototype={_cache:{},getTrendByName:function(e){"use strict";return new shmi.visuals.controls.TrendDisplay.Trend(this.manager,e,this.instance)}},shmi.visuals.controls.TrendDisplay.onConfiguration.push([100,function parseDataConfiguration(e,t){"use strict";if(!e||"object"!=typeof e)return null;if(!e.trend||"object"!=typeof e.trend)throw new TypeError("invalid/missing trend configuration");var s=String(e.trend.name||"").trim();s||shmi.log("TrendDisplay.onConfiguration() missing name of trend to show",3);var n=e.trend.aggregate;n&&"object"==typeof n||shmi.log("TrendDisplay.onConfiguration() missing configuration on aggregation",3);var a=shmi.visuals.controls.TrendDisplay.Parsers,l=a.aggregation(n.method||"",1),o=a.timeSpanUnit(n.unit||"",0);null===l&&shmi.log("TrendDisplay.onConfiguration() invalid aggregation method: "+n.method,3),null===o&&shmi.log("TrendDisplay.onConfiguration() invalid aggregation unit: "+n.unit,3);var r=e.trend.items;return r&&r.length||shmi.log("TrendDisplay.onConfiguration() missing configuration on items",2),e.trend.aggregate={method:l,unit:o},t.data.trends.then((function(t){t.indexOf(s)<0&&shmi.log("TrendDisplay.onConfiguration() selected trend is not available",3),e.trend.name=s}))}]),shmi.visuals.controls.TrendDisplay.Signal=function(e){"use strict";shmi.visuals.controls.TrendDisplay.Object.injectFrozen(this,e,!0)},shmi.visuals.controls.TrendDisplay.Signal.prototype={dontObserve:!0},shmi.visuals.controls.TrendDisplay.Style=function Style(){var e=null,t=null,s=null,n=null,a=null,l=null;function _setColor(t){var s=shmi.visuals.controls.TrendDisplay.Parsers.color(t);s?e=s:shmi.log("TrendDisplay.Style() invalid color: "+t,3)}Object.defineProperties(this,{black:{value:{red:0,green:0,blue:0,opacity:1,hasAlpha:!1,rgba:"rgba(0,0,0,1)",hex:"#000000",hexa:"#000000FF"}},color:{get:function(){return e||this.black},set:_setColor},colour:{get:function(){return e||this.black},set:_setColor},width:{get:function(){return t||1},set:function(e){var s=parseInt(e);s>0?t=s:e&&shmi.log("TrendDisplay.Style() invalid stroke width: "+e,1)}},dash:{get:function(){return s||[]},set:function(e){var t=shmi.visuals.controls.TrendDisplay.Parsers.dash(e);null!==t?s=t:e.length&&shmi.log("TrendDisplay.Style() invalid dash: "+e,1)}},offset:{get:function(){return n||0},set:function(e){var t=shmi.visuals.controls.TrendDisplay.Parsers.positive(e);null!==t?n=t:""!==e&&shmi.log("TrendDisplay.Style() invalid offset: "+e,1)}},opacity:{get:function(){return e&&e.hasAlpha?e.alpha:null===a?1:a},set:function(t){var s=shmi.visuals.controls.TrendDisplay.Parsers.relative(t);null!==s?(e&&(e.alpha=s,e=shmi.visuals.controls.TrendDisplay.Parsers.color(e)),a=s):shmi.log("TrendDisplay.Style() invalid opacity: "+t,1)}},symbol:{get:function(){return l},set:function(e){var t,s=shmi.visuals.controls.TrendDisplay;if(e instanceof s.Promise)l=e;else if(null!==(t=s.Parsers.url(e))){l=new s.Promise;var n=new Image;n.onload=function(){l.resolve(n)},n.onerror=function(){l.reject("loading image "+t+" failed")},n.src=t}else shmi.log("TrendDisplay.Style() invalid symbol URL: "+e,3)}},raw:{get:function(){var o={};return null!==e&&(o.color=e),null!==t&&(o.width=t),null!==a&&(o.opacity=a),null!==s&&(o.dash=s),null!==n&&(o.offset=n),null!==l&&(o.symbol=l),o}}})},shmi.visuals.controls.TrendDisplay.Style.prototype={dontObserve:!0,getQualifiedByCss:function(e){var t,s,n=this._cssParserDefs,a=shmi.visuals.controls.TrendDisplay.Parsers;return t=new shmi.visuals.controls.TrendDisplay.Style,s=this.raw,Object.keys(s).forEach((function(e){t[e]=s[e]})),Object.keys(n).forEach((function(l){shmi.objectHasOwnProperty(s,l)||n[l].some((function(s){var n=a.none(e[s]);if(null!==n)try{return t[l]=n,!0}catch(e){return!1}return!1}))})),t},_cssParserDefs:{color:["stroke","color"],width:["stroke-width"],opacity:["stroke-opacity","opacity"],dash:["stroke-dasharray"],offset:["stroke-dashoffset"],symbol:["background-image"]},applyOnCanvas:function(e){e.strokeStyle=this.color.rgba,e.lineWidth=this.width,"function"==typeof e.setLineDash&&(e.setLineDash(this.dash),e.lineDashOffset=this.offset)},applyOnSvg:function(e){e.style.stroke=this.color.rgba,e.style["stroke-width"]=this.width,e.style["stroke-dasharray"]=this.dash.join(","),e.style["stroke-dashoffset"]=this.offset},applyOnElement:function(e){e.style.color=this.color.rgba},copy:function(){var e=new shmi.visuals.controls.TrendDisplay.Style,t=this.raw;return Object.keys(t).forEach((function(s){e[s]=t[s]})),e}},shmi.visuals.controls.TrendDisplay.Style.defaultStyle=new shmi.visuals.controls.TrendDisplay.Style,shmi.visuals.controls.TrendDisplay.Style.getOnElement=function(e){var t=shmi.visuals.controls.TrendDisplay.Style.defaultStyle;return e?t.getQualifiedByCss(window.getComputedStyle(e,null)):t},shmi.visuals.controls.TrendDisplay.onConfiguration.push([50,function _parseStyleConfiguration(e,t){if(e&&"object"==typeof e){Array.isArray(e.styles)||shmi.log("TrendDisplay.onConfiguration() invalid/missing style set",3);var s=shmi.visuals.controls.TrendDisplay.Style;e.styleManagers=e.styles.map((function(e,t){try{return styleParser(e)}catch(e){return shmi.log("TrendDisplay.onConfiguration() ignoring style due to invalid property @"+t+": "+e.message,1),s.defaultStyle}})),e.styleManagers.waitStyle=styleParser({color:"#000000",symbol:"pics/system/icon_196.png"}),e.styleManagers.inactiveStyle=e.inactiveStyle}function styleParser(e){var t=new s;return["color","colour","width","dash","opacity","symbol"].forEach((function(s){shmi.objectHasOwnProperty(e,s)&&(t[s]=e[s])})),t}}]),shmi.visuals.controls.TrendDisplay.Trend=function Trend(e,t,s){"use strict";this.active=!0,this.trendDisplay=s;var n=new shmi.visuals.controls.TrendDisplay.Messaging,a=new shmi.visuals.controls.TrendDisplay.Messaging,l=new shmi.visuals.controls.TrendDisplay.Messaging,o=new shmi.visuals.controls.TrendDisplay.Promise,r=null,c=null,u=!1,m=0,h=1,d=null,f=null,v=!1,g=[];Object.defineProperty(this,"info",{get:function(){var s=shmi.visuals.controls.TrendDisplay.Promise;return s.first(s.delay((function(){shmi.log("TrendDisplay.Trend() timeout on gathering information on trend: "+t,3)}),shmi.c("TREND_DISPLAY_TRENDINFO_TIMEOUT")),new s((function(s){var n=[];g.forEach((function(e){n.push(e.alias)})),e.getTrendInfo(t,(function(e){s(e)}),n)})))}}),Object.defineProperty(this,"manager",{value:e}),Object.defineProperty(this,"name",{value:t}),Object.defineProperty(this,"startTime",{get:function(){return r||0},set:function(e){var t=Number(e);t>0&&t!==r&&(r=t,v=!1,n.send(this))}}),Object.defineProperty(this,"endTime",{get:function(){return c||shmi.getServerTime()},set:function(e){var t=Number(e);t>-2&&t!==c&&((u=-1===(c=t))&&(c=0),v=!1,n.send(this))}}),Object.defineProper