namespace motion {
	config = {"axes":[{"type":0,"limits":{"position":{"min":0,"max":1000,"unit":"mm"},"velocity":{"min":-1000,"max":1000,"unit":"mm/s"},"acceleration":{"min":-100,"max":100,"unit":"m/s^2"},"torque":{"min":-100,"max":100,"unit":"Nm"}},"axisParams":{"x":0,"y":0,"z":0,"xr":0,"yr":0,"zr":0},"id":"X","address":"X"},{"type":0,"limits":{"position":{"min":0,"max":1000,"unit":"mm"},"velocity":{"min":-1000,"max":1000,"unit":"mm/s"},"acceleration":{"min":-100,"max":100,"unit":"m/s^2"},"torque":{"min":-100,"max":100,"unit":"Nm"}},"axisParams":{"x":0,"y":0,"z":0,"xr":0,"yr":0,"zr":0},"id":"Y","address":"Y"},{"type":0,"limits":{"position":{"min":0,"max":1000,"unit":"mm"},"velocity":{"min":-1000,"max":1000,"unit":"mm/s"},"acceleration":{"min":-100,"max":100,"unit":"m/s^2"},"torque":{"min":-100,"max":100,"unit":"Nm"}},"axisParams":{"x":0,"y":0,"z":0,"xr":0,"yr":0,"zr":0},"id":"Z","address":"Z"}],"kins":[{"limits":{"velocity":{"min":0,"max":6000,"unit":"mm/s"},"acceleration":{"min":0,"max":2,"unit":"m/s^2"}},"units":{"position":"mm","torque":"Nm"},"axes":[{"direction":0,"axis":"X","meaning":0},{"direction":0,"axis":"Y","meaning":1},{"direction":0,"axis":"Z","meaning":2}],"id":"Robot","address":"Robot"}],"points":[{"positions":[{"meaning":0,"value":0},{"meaning":1,"value":0},{"meaning":2,"value":0}],"reference":"Robot","id":"pointStart"},{"positions":[{"meaning":0,"value":100},{"meaning":1,"value":0},{"meaning":2,"value":0}],"reference":"Robot","id":"point1"},{"positions":[{"meaning":0,"value":100},{"meaning":1,"value":100},{"meaning":2,"value":0}],"reference":"Robot","id":"point2"},{"positions":[{"meaning":0,"value":100},{"meaning":1,"value":100},{"meaning":2,"value":100}],"reference":"Robot","id":"point3"}]};
}
namespace motion {

	//% fixedInstance whenUsed
	export const X = motion.factory.createAxis(`X`, {"x":0,"y":0,"z":0,"xr":0,"yr":0,"zr":0}, undefined);
	//% fixedInstance whenUsed
	export const Y = motion.factory.createAxis(`Y`, {"x":0,"y":0,"z":0,"xr":0,"yr":0,"zr":0}, undefined);
	//% fixedInstance whenUsed
	export const Z = motion.factory.createAxis(`Z`, {"x":0,"y":0,"z":0,"xr":0,"yr":0,"zr":0}, undefined);
	//% fixedInstance whenUsed
	export const Robot = motion.factory.createKinematic(`Robot`, [X,Y,Z]);
	//% fixedInstance whenUsed
	export const pointStart: motion.Point<Position[]> = new motion.Point(motion.config['points'][0]);
	//% fixedInstance whenUsed
	export const point1: motion.Point<Position[]> = new motion.Point(motion.config['points'][1]);
	//% fixedInstance whenUsed
	export const point2: motion.Point<Position[]> = new motion.Point(motion.config['points'][2]);
	//% fixedInstance whenUsed
	export const point3: motion.Point<Position[]> = new motion.Point(motion.config['points'][3]);

	//% block="pointStart" group="Points"
	export function points_pointStart() { return motion.pointStart.getValue() }
	//% block="point1" group="Points"
	export function points_point1() { return motion.point1.getValue() }
	//% block="point2" group="Points"
	export function points_point2() { return motion.point2.getValue() }
	//% block="point3" group="Points"
	export function points_point3() { return motion.point3.getValue() }
}