/**
 * WebIQ Visuals widget template.
 * @version 1.2 changed by boschrexroth
 */
(function () {
    'use strict';

    // variables for reference in widget definition
    const templatePath = "custom/controls/cx-input" // "{%= template_path %}"
    const uiType = "cx-input"    // widget keyword (data-ui) {%= ui_type %}
    const className = uiType           // widget name in camel case {%= constructor_name %}
    const isContainer = false
    const DEFAULT_DIGITS = 2
    // example - default configuration
    const defaultConfig = {
        "class-name": uiType,
        "name": null,
        "template": templatePath,
        "label": uiType,
        "item": null
    };

    // setup module-logger
    const ENABLE_LOGGING = false //enable logging with 'log' function
    const RECORD_LOG = false //store logged messages in logger memory
    const logger = shmi.requires("visuals.tools.logging").createLogger(uiType, ENABLE_LOGGING, RECORD_LOG)
    const fLog = logger.fLog //force log - logs message even if logger is disabled
    const log = logger.log; //log message if logger is enabled

    // *******************************************************
    function dragTest(self) {
        // if (self.vars.bEnableTouchTitle) {
        self.vars.bEnableTouchTitle = false
        cxt.msgTop("Title", (self.element.title !== "") ? self.element.title : "* no title defined *")
        // }

    }
    function touch2Mouse(e, self) {
        var theTouch = e.changedTouches[0];
        let iXDelta = 0
        switch (e.type) {
            case "touchstart":
                // cxt.msgTop("Title", null)// close previous title
                self.vars.iXTouchStart = theTouch.screenX
                self.vars.bEnableTouchTitle = true
                break;
            case "touchmove":
                iXDelta = Math.abs(theTouch.screenX - self.vars.iXTouchStart);
                if ((self.vars.bEnableTouchTitle) && (iXDelta > 25)) {
                    self.vars.bEnableTouchTitle = false
                    cxt.msgTop("Title", (self.element.title !== "") ? self.element.title : "* no title defined *")
                }
                break;
            default: return;
        }
    }
    // declare private functions - START
    // (CUSTOM ADDITION++)
    function enableListeners(self) {
        self.vars.listeners.forEach((l) => {
            l.enable();
        });
        self.vars.elements.input.disabled = false
    }

    function disableListeners(self) {
        self.vars.listeners.forEach((l) => {
            l.disable();
        });
        self.vars.elements.input.disabled = true
    }

    function updateValue(self, value) {
        log("updateValue:" + value)
        let cf = self.config
        if (self.vars.itemType === TYP_FLOAT)
            self.vars.elements.input.value = cxt.float2String(value, self.vars.digits, -1)
        else if (self.vars.itemType === TYP_INT) {
            cf.formatInt = 10
            let iSecLen = -1
            let iLen = 0
            let sPrefix = PREFIX_DEC
            if (cf.formatInt === 16) {
                iLen = 4
                iSecLen = 2
                sPrefix = PREFIX_HEX
            } else if (cf.formatInt === 2) {
                iLen = 8
                iSecLen = 4
                sPrefix = PREFIX_BIN
            }
            self.vars.elements.input.value = sPrefix + cxt.int2String(value, cf.formatInt, iLen, iSecLen, "0")
        } else {
            self.vars.elements.input.value = value
        }
    }
    // (/CUSTOM ADDITION--)
    // declare private functions - END

    // definition of new widget extending BaseControl - START
    const definition = {
        className: className,
        uiType: uiType,
        isContainer: isContainer,
        // default configuration settings - all available options have to be initialized!
        config: defaultConfig,
        // instance variables
        vars: {
            // (CUSTOM ADDITION++)
            elements: {
                //references for DOM elements accessed with JS code
                label: null, //element to display label text
                input: null, //element to display item value
                unit: null   //element to display unit text
            },
            min: 0,      //min value for item, will be replaced by actual item minimum if defined
            max: 100,    //max value for item, will be replaced by actual item maximum if defined
            minType: null, // prop, const, item
            maxType: null, // prop, const, item
            item: null,    //reference for PLC item subscription token - will be set when widget is enabled
            itemType: -1,
            stepWidth: 1,
            iXTouchStart: 0,
            bEnableTouchTitle: false,
            listeners: [] //event listeners
            // (/CUSTOM ADDITION--)
        },
        // imports added at runtime
        imports: {
            // example - add import via shmi.requires(...)
            im: "visuals.session.ItemManager",
            // (CUSTOM ADDITION++)
            io: "visuals.io"
            // (/CUSTOM ADDITION--)
        },

        // array of custom event types fired by this widget
        events: [],

        // functions to extend or override the BaseControl prototype
        prototypeExtensions: {
            // called when config-file (optional) is loaded and template (optional) is inserted into base element
            onInit: function () {
                // (CUSTOM ADDITION++)
                log("onInit")
                const self = this
                const el = self.vars.elements
                const vr = self.vars
                const cf = self.config

                const im = self.imports.im
                let myWidget = self.element;
                myWidget.title = cf.title
                // disable context menu
                self.element.addEventListener('contextmenu', (e) => e.preventDefault(), false)

                // Store references to the DOM elements for performance reasons
                myWidget = self.element.firstChild;
                if (cf.myLabel) {
                    el.label = cxt.addChild(myWidget, "button", "divLabel")
                    el.label.textContent = shmi.localize(cf.myLabel)
                }

                let myDiv = cxt.addChild(myWidget, "div", "divFrame")
                let imgLock = cxt.addChild(myDiv, "img", "cxLock")
                imgLock.src = cxt.cfgMsgBox.imgLock
                el.myDiv = myDiv

                let txtEdit = cxt.addChild(myDiv, "input", "divInput")
                el.input = txtEdit

                // set readonly to avoid opening of tablet keypad
                if (cxt.keypadEnable()) txtEdit.readOnly = cxt.keypadEnable()
                // console.warn(cf.title + ": readOnly=" + txtEdit.readOnly)
                if (cf.bIsPassword)
                    txtEdit.type = "password"
                else
                    txtEdit.type = "text"
                // open virtual keypad, when input is enabled
                if (cf.item !== null) {
                    // txtEdit.onclick = () => {
                    //     if (self.vars.elements.input.disabled) return
                    //     cxt.keypad(cf.item, "webiq", 0, vr.itemType, vr.min, vr.max, true)
                    // }
                    txtEdit.onchange = () => {
                        // console.log("onChange " + vr.min + "-" + vr.max)
                        let myVal
                        if ([TYP_FLOAT, TYP_INT].includes(vr.itemType)) {
                            myVal = parseFloat(txtEdit.value.replaceAll(" ", ""))
                            if (myVal < vr.min)
                                myVal = vr.min
                            else if (myVal > vr.max) {
                                myVal = vr.max
                            }
                        } else {
                            myVal = txtEdit.value
                        }
                        updateValue(self, myVal)
                        // let myItemVal = cf.isUtf8 ? cxt.utf16_2_utf8(myVal) : myVal
                        let myItemVal = cf.isUtf8 ? shmi.to_utf8(myVal) : myVal
                        im.writeValue(cf.item, myItemVal)
                    }
                    txtEdit.onblur = () => {
                        txtEdit.onchange()
                    }

                    // txtEdit.onfocus = () => {
                    // show tooltip
                    // if (cf.title) cxt.msgTop("title", cf.title)
                    // }
                    function checkSign() {
                        let iPos = txtEdit.selectionStart
                        let sTmp = txtEdit.value
                        if (sTmp.startsWith("-")) {
                            sTmp = sTmp.substring(1)
                            iPos--
                        } else {
                            sTmp = "-" + sTmp
                            iPos++
                        }
                        txtEdit.value = sTmp
                        txtEdit.setSelectionRange(iPos, iPos)
                    }
                    txtEdit.onkeydown = function (e) {
                        if (vr.elements.input.disabled) return
                        let bCancel = false
                        let sCharOk = "0123456789"
                        if (vr.itemType === TYP_INT) {
                            if ("+-".includes(e.key)) {
                                checkSign()
                                bCancel = true
                            } else {
                                bCancel = !sCharOk.includes(e.key) ? true : false
                            }

                        } else if (vr.itemType === TYP_FLOAT) {
                            if ("+-".includes(e.key)) {
                                checkSign()
                                bCancel = true
                            } else {
                                if (!txtEdit.value.includes("."))
                                    sCharOk += "."
                                bCancel = !sCharOk.includes(e.key) ? true : false
                            }
                        } else if (vr.itemType === TYP_STRING) {
                            let iLen = 20
                            bCancel = (txtEdit.value.length >= iLen) ? true : false
                            bCancel = (iLen === 0) ? false : bCancel
                        }

                        bCancel = (e.key.length > 2) ? false : bCancel
                        if (bCancel) {
                            e = e || window.event;
                            // to cancel the event:
                            if (e.preventDefault) e.preventDefault();
                            return false;
                        }
                        // checkChanged((["ArrowLeft", "ArrowRight", "Backspace", "Delete"].includes(e.code)) ? false : true)
                    }
                    // add inc/dec buttons
                    if (["+-", "upDn"].includes(cf.stepMode)) {
                        // add decrease button ▲ / ▼
                        // ➕➖ ✚⚊
                        let myBtnDn = cxt.addChild(null, "button", "divBtn", (cf.stepMode === "+-") ? "⚊" : "▼")
                        myBtnDn.style.marginRight = "4px"
                        myBtnDn.onmousedown = () => {
                            if (el.input.disabled) return
                            myBtnDn.classList.add("divBtnActive")
                            let val = im.readValue(cf.item) - vr.stepWidth
                            if (val < vr.min) val = vr.min
                            im.writeValue(cf.item, val)
                        }
                        myBtnDn.onmouseup = () => {
                            if (el.input.disabled) return
                            myBtnDn.classList.remove("divBtnActive")
                        }
                        // myWidget.insertBefore(myBtnDn, txtEdit)
                        myWidget.insertBefore(myBtnDn, myDiv)

                        // add increase button
                        let myBtnUp = cxt.addChild(myWidget, "button", "divBtn", (cf.stepMode === "+-") ? "✚" : "▲")
                        myBtnUp.style.marginLeft = "4px"
                        myBtnUp.onmousedown = () => {
                            if (el.input.disabled) return

                            myBtnUp.classList.add("divBtnActive")
                            let val = im.readValue(cf.item) + vr.stepWidth
                            if (val > vr.max) val = vr.max
                            im.writeValue(cf.item, val)
                        }
                        myBtnUp.onmouseup = () => {
                            if (el.input.disabled) return
                            myBtnUp.classList.remove("divBtnActive")
                        }
                    }
                }

                if (cf.unit) {
                    el.unit = cxt.addChild(myWidget, "button", "divUnit")
                    el.unit.textContent = shmi.localize(cf.unit);
                }

                // add onClick handler to execute an function
                if (el.input) {
                    //get reference to Mouse- & TouchListener constructors
                    const { MouseListener, TouchListener } = self.imports.io;
                    // define the onClick handler
                    const handler = {
                        onClick: async function (x, y, event) {
                            if (el.input.disabled) return
                            let adapt = im.items[cf.item].adapter
                            if ((vr.minType === "item") && (cf.anyMin != "")) {
                                let rVal = await cxt.getItem(cf.anyMin, true)
                                vr.min = (adapt) ? adapt.outFunction(rVal) : parseFloat(rVal)
                            }
                            if ((vr.maxType === "item") && (cf.anyMax != "")) {
                                let rVal = await cxt.getItem(cf.anyMax, true)
                                vr.max = (adapt) ? adapt.outFunction(rVal) : parseFloat(rVal)
                            }
                            // async keypad(sItem, sType, iDigits, iType, rMin, rMax, bSelectLanguage = true, bIsUtf8 = false)
                            if (cf.bIsPassword)
                                cxt.keypad(cf.item, "webiq", 0, TYP_PASSWORD, vr.min, vr.max, true, cf.isUtf8)
                            else
                                cxt.keypad(cf.item, "webiq", 0, vr.itemType, vr.min, vr.max, true, cf.isUtf8)
                        }
                    };

                    //create listeners for root element (=self.element) of the widget
                    vr.listeners.push(
                        new MouseListener(el.input, handler),
                        new TouchListener(el.input, handler)
                    );
                }
                // (CUSTOM ADDITION--)
            },
            // called when widget is enabled
            onEnable: function () {
                // (CUSTOM ADDITION++)
                log("onEnable")
                const self = this
                const vr = self.vars
                const cf = self.config
                const im = self.imports.im
                enableListeners(self);

                // Subscribe to item updates
                if (cf.item) {
                    vr.item = im.subscribeItem(cf.item, self);
                }
                // If TOOLTIP_ITEM not defined => widget not correct enabled
                self.vars.toolTip = cxt.isTooltipEnabled() ? im.subscribeItem(TOOLTIP_ITEM, self) : null

                // (/CUSTOM ADDITION--)
            },
            // called when widget is disabled
            onDisable: function () {
                // (CUSTOM ADDITION++)
                log("onDisable")
                const self = this
                const vr = self.vars
                disableListeners(self);

                // Stop listening to item, i.e. unsubscribe from item updates
                if (vr.toolTip) vr.toolTip.unlisten(); vr.toolTip = null
                if (vr.item) {
                    vr.item.unlisten();
                    vr.item = null;
                }
                // (/CUSTOM ADDITION--)
            },
            // called when widget is locked - disable mouse- and touch-listeners
            onLock: function () {
                // (CUSTOM ADDITION++)
                log("onLock")
                const self = this;
                disableListeners(self);
                self.element.classList.add("locked")
                // (/CUSTOM ADDITION--)
            },
            // called when widget is unlocked - enable mouse- and touch-listeners
            onUnlock: function () {
                // (CUSTOM ADDITION++)
                log("onUnlock")
                const self = this;
                enableListeners(self);
                self.element.classList.remove("locked")
                // (/CUSTOM ADDITION--)
            },
            // called by ItemManager when value of subscribed item changes and once on initial subscription
            onSetValue: function (value, type, name) {
                // (CUSTOM ADDITION++)
                log(this.config.name + `: onSetValue(${name}=${value})`)
                const self = this
                const cf = self.config
                const vr = self.vars

                if (name === cf.item) {
                    if ((self.vars.itemType === TYP_STRING) && (cf.isUtf8))
                        // value = cxt.utf8_2_utf16(value)
                        value = shmi.from_utf8(value)
                    updateValue(self, value)
                } else if (name === TOOLTIP_ITEM) {
                    cxt.tooltip(self, value)
                }
                // (/CUSTOM ADDITION--)
            },
            // called by ItemManager to provide properties (min & max values etc.) of subscribed item
            onSetProperties: function (min, max, step, name, type, warnMin, warnMax, prewarnMin, prewarnMax, digits) {
                // (CUSTOM ADDITION++)
                const im = shmi.requires("visuals.session.ItemManager")
                log("onSetProperties " + `${this.name} name:${name} type:${type} min:${min} max:${max} digits:${digits} step:${step}`)
                if (type === null) return

                const vr = this.vars
                const el = vr.elements
                const cf = this.config

                if (cf.item === name) {
                    let adapt = im.items[name].adapter
                    // unit class defined for item?
                    if (adapt && el.unit) {
                        el.unit.textContent = shmi.localize(im.items[name].adapter.unitText);
                    }
                    vr.itemType = type
                    // limit to default min, if nothing defined
                    vr.min = (!cxt.isNullOrUndef(min)) ? min : DEFAULT_MIN
                    vr.minType = "prop"
                    if (!cxt.isNullOrUndef(cf.anyMin)) {
                        // if input is numeric, use it, else read item value, when start editing
                        if (cxt.isFloat(cf.anyMin)) {
                            vr.minType = "const"
                            // convert min to selected unit
                            let rMin = (adapt) ? adapt.outFunction(cf.anyMin) : parseFloat(cf.anyMin)
                            vr.min = (rMin > vr.min) ? rMin : vr.min
                        } else
                            vr.minType = "item"
                    }

                    // limit to default max, if nothing defined
                    vr.maxType = "prop"
                    vr.max = (!cxt.isNullOrUndef(max)) ? max : DEFAULT_MAX
                    if (!cxt.isNullOrUndef(cf.anyMax)) {
                        if (cxt.isFloat(cf.anyMax)) {
                            vr.maxType = "const"
                            let rMax = (adapt) ? adapt.outFunction(cf.anyMax) : parseFloat(cf.anyMax)
                            vr.max = (vr.max < rMax) ? vr.max : rMax
                        } else
                            vr.maxType = "item"
                    }
                    vr.digits = (digits !== -1) ? digits : DEFAULT_DIGITS
                    if (!cxt.isNullOrUndef(cf.anyDigits)) {
                        if (cxt.isFloat(cf.anyDigits))
                            vr.digits = Math.abs(parseInt(cf.anyDigits))
                    }
                    vr.stepWidth = (step > 0) ? step : 1
                    if (cf.step > 0) {
                        vr.stepWidth = cf.step
                    }

                    if (el.input) {
                        el.input.classList.add("iq-input")
                        // console.log("add class iq-input to cx-input")
                        // alert("add class iq-input to cx-input")
                        if (type === TYP_STRING) // set max. input length
                            el.input.maxLength = vr.max
                        else // right align numbers
                            el.input.classList.add("divNumber")

                    }
                }
                // (/CUSTOM ADDITION--)
            },
            // called when widget is deleted - used for instance clean-up
            onDelete: function () {
                log("onDelete")
            }
        }
    };

    // definition of new widget extending BaseControl - END

    // generate widget constructor & prototype using the control-generator tool
    shmi.requires("visuals.tools.control-generator").generate(definition);
})();
