/**
 * WebIQ Visuals widget template.
 *
 * Configuration options (default):
 *
 * {
 *     "class-name": "cx-ioForce", // {%= ui_type %}
 *     "name": null,
 *     "template": "custom/controls/cx-ioForce" // {%= template_path %}
 * }
 *
 * Explanation of configuration options:
 *
 * class-name {string}: Sets default CSS class applied on widget root element
 * name {string}: Name of widget set to data-name attribute
 * template {string}: Path to template file
 *
 * @version 1.2 changed by boschrexroth
 */

(function () {
    'use strict';
    const CHAR_ON = "✓"
    const CHAR_OFF = ""
    // variables for reference in widget definition
    const templatePath = "custom/controls/cx-ioForce" // "{%= template_path %}"
    const uiType = "cx-ioForce"    // widget keyword (data-ui) {%= ui_type %}
    const className = uiType           // widget name in camel case {%= constructor_name %}
    const isContainer = false

    // example - default configuration
    const defaultConfig = {
        "class-name": uiType,
        "name": null,
        "template": templatePath,
        "label": uiType,
        "item": null
    };

    // setup module-logger
    const ENABLE_LOGGING = true //enable logging with 'log' function
    const RECORD_LOG = false //store logged messages in logger memory
    const logger = shmi.requires("visuals.tools.logging").createLogger(uiType, ENABLE_LOGGING, RECORD_LOG)
    const fLog = logger.fLog //force log - logs message even if logger is disabled
    const log = logger.log; //log message if logger is enabled

    // declare private functions - START
    // (CUSTOM ADDITION++)
    function enableListeners(self) {
        let el = self.vars.elements
        self.vars.bEnabled = true

        self.vars.listeners.forEach((l) => {
            l.enable();
        })
        for (let i = 0; i < el.enables.length; i++) {
            el.enables[i].disabled = false
            el.forceValues[i].disabled = false

            el.enables[i].style.display = "block"
            el.forceValues[i].style.display = "block"
        }
    }

    function disableListeners(self) {
        let el = self.vars.elements
        self.vars.bEnabled = false
        self.vars.listeners.forEach((l) => {
            l.disable();
        })
        for (let i = 0; i < el.enables.length; i++) {
            el.enables[i].disabled = true
            el.forceValues[i].disabled = true

            el.enables[i].style.display = "none"
            el.forceValues[i].style.display = "none"
        }
    }
    /**
     * subscribe item if it is provided to widget
     * @param {object} self  reference to WebIQ widget
     * @param {string} sItem name of item
     */
    function subscribeIfExists(self, sItem) {
        // if (self.config[sItem]) {
        //     self.vars[sItem] = self.imports.im.subscribeItem(self.config[sItem], self);
        // }
        let sItemName = self.config.itemStruct + "." + sItem
        log("subscribe: " + sItemName)
        self.vars[sItem] = self.imports.im.subscribeItem(sItemName, self);
    }
    /**
     * toggles bit of selected byte
     * @param {integer} iBit   of selected byte to toggle
     * @param {integer} iValue variable to toggle
     * @returns updated value
     */
    function toggleBit(iBit, iByte, iValue) {
        let iMask = 1 << (iBit + 8 * iByte)
        // toggle bit
        return iValue ^= iMask
    }
    /**
     * returns selected bit
     * @param {integer} iBit 
     * @param {integer} iByte 
     * @param {integer} iValue 
     * @returns value selected bit 
     */
    function getBit(iBit, iByte, iValue) {
        let iShift = iBit + 8 * iByte
        let iMask = 1 << iShift
        let iRes = iValue & iMask
        return iRes
    }
    function setForceValue(self, iBit) {
        const { im } = self.imports;
        let iVal = im.readValue(self.config.itemForceValue);
        iVal = toggleBit(iBit, self.config.intByte, iVal)
        im.writeValue(self.config.itemForceValue, iVal);
    }
    function setChecked(self, iBit) {
        const { im } = self.imports;
        let iVal = im.readValue(self.config.itemChecked);
        iVal = toggleBit(iBit, self.config.intByte, iVal)
        im.writeValue(self.config.itemChecked, iVal);
    }
    function setForceEnable(self, iBit, iID) {
        log(self.config.name + ": setForceEnable")
        const { im } = self.imports;
        let iVal = im.readValue(self.config.itemForceEnable);
        iVal = toggleBit(iBit, self.config.intByte, iVal)
        im.writeValue(self.config.itemForceEnable, iVal);
    }
    function updateValue(self, iValue) {
        for (let i = 0; i < 8; i++) {
            let iBit = getBit(i, self.config.intByte, iValue)
            if (iBit === 0) {
                self.vars.elements.values[i].classList.remove("divButtonActive")
            } else {
                self.vars.elements.values[i].classList.add("divButtonActive")
            }
        }
    }
    function updateBitNames(self, value) {
        let jNames = {}
        let el = self.vars.elements
        try {
            jNames = JSON.parse(value)
        } catch (e) {
            console.error("JSON string containing bit names is invalid")
        }
        let iOffset = self.config.intByte * 8
        for (let i = 0; i < 8; i++) {
            let sKey = "" + (i + iOffset)
            let sName = ""
            if (jNames[sKey]) {
                sName = jNames[sKey].replaceAll("_", "_<wbr>")
            } else {
                el.enables[i].disabled = true
            }
            self.vars.elements.names[i].innerHTML = sName
            log(i + " bit:" + sName)
        }
    }
    function updateForceEnable(self, iValue) {
        let el = self.vars.elements
        for (let i = 0; i < 8; i++) {
            let iBit = getBit(i, self.config.intByte, iValue)
            if (iBit === 0) {
                el.forceValues[i].style.visibility = "hidden"
                el.enables[i].classList.remove("divButtonActive")
                el.values[i].innerHTML = ""
            } else {
                el.forceValues[i].style.visibility = "visible"
                el.enables[i].classList.add("divButtonActive")
                el.values[i].innerHTML = shmi.localize("${cxVisuals.forceF}").substring(0, 1)
            }
        }
    }
    function updateForceValue(self, iValue) {
        for (let i = 0; i < 8; i++) {
            let iBit = getBit(i, self.config.intByte, iValue)
            if (iBit === 0) {
                self.vars.elements.forceValues[i].classList.remove("divButtonActive")
            } else {
                self.vars.elements.forceValues[i].classList.add("divButtonActive")
            }
        }
    }
    function updateChecked(self, iValue) {
        for (let i = 0; i < 8; i++) {
            let iBit = getBit(i, self.config.intByte, iValue)
            if (iBit === 0) {
                self.vars.elements.checked[i].classList.remove("divButtonActive")
                self.vars.elements.checked[i].innerHTML = CHAR_OFF
            } else {
                self.vars.elements.checked[i].classList.add("divButtonActive")
                self.vars.elements.checked[i].innerHTML = CHAR_ON
            }
        }
    }

    // function showChecked(self, me) {
    //     let el = self.vars.elements
    //     let vr = self.vars
    //     vr.bShowChecked = !vr.bShowChecked
    //     log((vr.bShowChecked) ? "show" : "hide")

    //     // show/hide checked buttons
    //     for (let i = 0; i < 8; i++) {
    //         el.checked[i].style.display = (vr.bShowChecked) ? "block" : "none"
    //     }
    //     vr.bShowChecked ? me.classList.add("divButtonActive") : me.classList.remove("divButtonActive")
    //     me.innerHTML = vr.bShowChecked ? CHAR_ON : CHAR_OFF
    // }

    // (/CUSTOM ADDITION--)
    // declare private functions - END

    // definition of new widget extending BaseControl - START
    const definition = {
        className: className,
        uiType: uiType,
        isContainer: isContainer,
        // default configuration settings - all available options have to be initialized!
        config: defaultConfig,
        // instance variables
        vars: {
            // (CUSTOM ADDITION++)
            elements: {
                //references for DOM elements accessed with JS code
                title: null,
                names: [],
                values: [],
                enables: [],
                forceValues: [],
                checked: []
            },
            itemBitNames: null,         // json with bit names {"n0":"bit0",...}
            itemChecked: null,          // bit set = true else false (value of IO)
            itemForceEnable: null,      // bit set = true else false
            itemForceValue: null,       // bit set = true else false
            itemModuleId: null,         // id of selected module
            bShowChecked: false,        // true=show checked boxes false=hide ...
            bEnabled: false,            // widget is: true=enabled false=disabled
            listeners: []               // event listeners
            // (/CUSTOM ADDITION--)
        },
        // imports added at runtime
        imports: {
            // example - add import via shmi.requires(...)
            im: "visuals.session.ItemManager",
            // (CUSTOM ADDITION++)
            io: "visuals.io"
            // (/CUSTOM ADDITION--)
        },

        // array of custom event types fired by this widget
        events: [],

        // functions to extend or override the BaseControl prototype
        prototypeExtensions: {
            // called when config-file (optional) is loaded and template (optional) is inserted into base element
            onInit: function () {
                // (CUSTOM ADDITION++)
                log("onInit")
                const self = this
                const el = self.vars.elements
                const cf = self.config
                self.vars.bEnabled = false
                // disable context menu
                self.element.addEventListener('contextmenu', (e) => e.preventDefault(), false)

                // define config items
                cf.itemTitle = cf.itemStruct + ".Title"
                cf.itemBitNames = cf.itemStruct + ".Names"
                cf.itemValue = cf.itemStruct + ".ValOut"
                cf.itemVerified = cf.itemStruct + ".Checked"
                cf.itemModules = cf.itemStruct + ".Modules"
                cf.itemCmd = cf.itemStruct + ".Cmd"
                cf.itemModuleId = cf.itemStruct + ".iId"

                let sNo = (self.config.intByte < 4) ? "" : "2"
                cf.itemForceEnable = cf.itemStruct + ".ForceEnable" + sNo
                cf.itemForceValue = cf.itemStruct + ".ForceValue" + sNo
                cf.itemChecked = cf.itemStruct + ".Checked" + sNo

                // header 
                let myWidget = shmi.getUiElement("widget", self.element)
                let divRow = cxt.addChild(myWidget, "div", "divRow")
                // empty space above bit number
                let divTmp
                function scrollIO(event, oBtn, bOn, sOnCmd = "") {
                    if (event !== null)
                        event.preventDefault()
                    if (!self.vars.bEnabled) return
                    if (bOn) {
                        oBtn.classList.add("divButtonActive")
                        cxt.setItem(cf.itemCmd, sOnCmd)
                    } else {
                        oBtn.classList.remove("divButtonActive")
                    }
                }
                // scroll previous
                let divPrev = cxt.addChild(divRow, "button", "divButton", "<") //"◀")

                // title
                el.title = cxt.addChild(divRow, "button", "divBitName", "")
                el.title.style.textAlign = "center";
                el.title.style.fontWeight = "bold"

                // open select box
                const funcsTitle = {
                    onRelease: async function (x, y, event) {
                        let sModules = await cxt.getItem(self.config.itemModules)
                        let iModuleId = await cxt.getItem(self.config.itemModuleId)
                        let iSelected = await cxt.msgBox("select", "${Select-module}", "", sModules, ":", "=", iModuleId)
                        if (iSelected !== null)
                            cxt.setItem(cf.itemCmd, "set " + iSelected)
                    }
                }
                // scroll next
                let divNext = cxt.addChild(divRow, "button", "divButton", ">") //"▶")
                // define the onClick handler
                const funcsPrev = {
                    onPress: function (x, y, event) {
                        scrollIO(event, divPrev, true, "set -")
                    },
                    onRelease: function (x, y, event) {
                        scrollIO(event, divPrev, false)
                    }
                }
                const funcsNext = {
                    onPress: function (x, y, event) {
                        scrollIO(event, divNext, true, "set +")
                    },
                    onRelease: function (x, y, event) {
                        scrollIO(event, divNext, false)
                    }
                }

                //get reference to Mouse- & TouchListener constructors
                const arListeners = [self.imports.io.MouseListener, self.imports.io.TouchListener]
                //create listeners for root element (=self.element) of the widget
                for (let i = 0; i < 2; i++) {
                    self.vars.listeners.push(
                        new arListeners[i](divNext, funcsNext),
                        new arListeners[i](divPrev, funcsPrev),
                        new arListeners[i](el.title, funcsTitle)
                    );
                }

                // Store references to the DOM elements for performance reasons
                for (let i = 0; i < 8; i++) {
                    divRow = cxt.addChild(myWidget, "div", "divRow")
                    divTmp = cxt.addChild(divRow, "div", "divBitNo", "" + (i + 8 * cf.intByte))

                    divTmp = cxt.addChild(divRow, "button", "divValue", "")
                    el.values.push(divTmp)

                    divTmp = cxt.addChild(divRow, "button", "divBitName", "???")
                    el.names.push(divTmp)

                    let divForce = cxt.addChild(divRow, "div", "divForce")
                    divTmp = cxt.addChild(divForce, "button", "divForceEnable", shmi.localize("${cxVisuals.force}"))
                    divTmp.onclick = () => {
                        if (!self.vars.bEnabled) return
                        setForceEnable(self, i, self.config.name)
                    }
                    el.enables.push(divTmp)

                    divTmp = cxt.addChild(divForce, "button", "divForceValue", shmi.localize("${cxVisuals.forceOn}"))
                    divTmp.onclick = () => {
                        if (!self.vars.bEnabled) return
                        setForceValue(self, i)
                    }
                    el.forceValues.push(divTmp)

                    divTmp = cxt.addChild(divRow, "button", "divBtnVerified")
                    // divTmp.style.display = "none"
                    divTmp.onclick = () => {
                        if (!self.vars.bEnabled) return
                        setChecked(self, i)
                    }
                    el.checked.push(divTmp)
                }
                // (CUSTOM ADDITION--)
            },
            // called when widget is enabled
            onEnable: function () {
                // (CUSTOM ADDITION++)
                log("onEnable Byte:" + this.config.intByte)
                const self = this,
                    { im } = self.imports;
                enableListeners(self);

                // Subscribe to item updates
                subscribeIfExists(self, "Title")
                subscribeIfExists(self, "Names")

                let sNo = (self.config.intByte < 4) ? "" : "2"
                subscribeIfExists(self, "ValOut" + sNo)
                subscribeIfExists(self, "ForceEnable" + sNo)
                subscribeIfExists(self, "ForceValue" + sNo)
                subscribeIfExists(self, "Checked" + sNo)
                // (/CUSTOM ADDITION--)
            },
            // called when widget is disabled
            onDisable: function () {
                // (CUSTOM ADDITION++)
                log("onDisable")
                const self = this;
                disableListeners(self);
                // Stop listening to item, i.e. unsubscribe from item updates
                if (self.vars.item) {
                    self.vars.item.unlisten();
                    self.vars.item = null;
                }
                // (/CUSTOM ADDITION--)
            },
            // called when widget is locked - disable mouse- and touch-listeners
            onLock: function () {
                // (CUSTOM ADDITION++)
                log("onLock")
                const self = this;
                disableListeners(self);
                // (/CUSTOM ADDITION--)
            },
            // called when widget is unlocked - enable mouse- and touch-listeners
            onUnlock: function () {
                // (CUSTOM ADDITION++)
                log("onUnlock")
                const self = this;
                enableListeners(self);
                // (/CUSTOM ADDITION--)
            },
            // called by ItemManager when value of subscribed item changes and once on initial subscription
            onSetValue: function (value, type, name) {
                // (CUSTOM ADDITION++)
                const self = this
                log(self.config.name + ": onSetValue: " + `${name}=${value}`)
                if (name === self.config.itemBitNames) {
                    updateBitNames(self, value)
                } else if (name === self.config.itemTitle) {
                    self.vars.elements.title.innerHTML = value + " ☰"
                } else if (name === self.config.itemForceEnable) {
                    updateForceEnable(self, value)
                } else if (name === self.config.itemForceValue) {
                    updateForceValue(self, value)
                } else if (name === self.config.itemValue) {
                    updateValue(self, value)
                } else if (name === self.config.itemChecked) {
                    updateChecked(self, value)
                }
                // (/CUSTOM ADDITION--)
            },
            // called by ItemManager to provide properties (min & max values etc.) of subscribed item
            onSetProperties: function (min, max, step, name, type, warnMin, warnMax, prewarnMin, prewarnMax, digits) {
                // (CUSTOM ADDITION++)
                //log(self.config.name +" onSetProperties:" + `name:${name} type:${type} min:${min} max:${max}`)

                const self = this;
                self.vars.min = min;
                self.vars.max = max;
                // (/CUSTOM ADDITION--)
            },
            // called when widget is deleted - used for instance clean-up
            onDelete: function () {
                log("onDelete")
            }
        }
    };

    // definition of new widget extending BaseControl - END

    // generate widget constructor & prototype using the control-generator tool
    shmi.requires("visuals.tools.control-generator").generate(definition);
})();
