var HTML5_BatteryElementWrapper;

(function ()
{
	HTML5_BatteryElementWrapper = function(idGenerator)
	{

		this.svg = document.createElementNS("http://www.w3.org/2000/svg", "svg");
		this.svg.setAttribute("viewBox", "0 0 50 100")

		this.outline = document.createElementNS("http://www.w3.org/2000/svg", "path");
		this.outline.setAttributeNS(null, "d","m 15.468947,1.162241 v 9.464372 H 2.6369413 c -0.9974863,0 -1.8004088,0.802922 -1.8004088,1.800408 v 84.609918 c 0,0.99749 0.8029225,1.80082 1.8004088,1.80082 H 47.363063 c 0.99748,0 1.800405,-0.80333 1.800405,-1.80082 V 12.427021 c 0,-0.997486 -0.802925,-1.800408 -1.800405,-1.800408 H 34.140256 V 1.162241 Z");

		this.bolt = document.createElementNS("http://www.w3.org/2000/svg", "path");
		this.bolt.setAttributeNS(null, "d","m 28.913606,26.038854 -1.95511,19.486785 7.82044,0.06431 -13.68575,27.371519 1.9551,-19.655011 -7.82039,0.103928 13.68571,-27.371525");
		this.bolt.setAttribute('id', 'is_charging');
		this.bolt.classList.add('bolt');

		this.g = document.createElementNS("http://www.w3.org/2000/svg", "g");

		this.rect = [10]

		for (let i = 0; i < 10; i++){
			let _id = `level_${10 + 10*i}`

			this.rect[i] = document.createElementNS("http://www.w3.org/2000/svg", "rect");
			this.rect[i].setAttribute('x',2.5);
			this.rect[i].setAttribute('y',90 - i * 8.5);
			this.rect[i].setAttribute('width',45.0);
			this.rect[i].setAttribute('height',8.0);
			this.rect[i].setAttribute('id', _id);
			this.rect[i].classList.add('level')


			this.g.appendChild(this.rect[i]);
		}

		this.svg.appendChild(this.outline);
		this.svg.appendChild(this.g);
		this.svg.appendChild(this.bolt);
		document.body.appendChild(this.svg);

	};
		
	HTML5_BatteryElementWrapper.prototype =
	{
		setLevel: function(value) {
			let _temp = Math.floor(value/10);

			let _color = '#cccccc';
			_color = _temp > 4 ? 'green' : _temp > 2 ? 'yellow' : 'red';

			for (let i= 0; i<_temp; i++){
				this.rect[i].style.fill=_color;
			}

			for (let i= _temp; i<10; i++){
				this.rect[i].style.fill='#cccccc';
			} 

			_temp == 0 ? this.rect[0].classList.add('blink'): this.rect[0].classList.remove('blink');
		},

		isCharging: function(value) {
			this.bolt.style.opacity = (value > 0 ? 1.0 : 0.1);
		}
		
	};
}());